# Scene Description

Official MPEG repository to discuss work related to MPEG-I SD (ISO/IEC 23090-14 Scene Description).

The table below lists final and current documents produced by MPEG regarding Scene Description.
Links to MPEG Output documents are only accessible to MPEG members.

| Document Name | Output Date | Output doc# (MPEG-member only) | ISO Status | Comments |
| ----- | ----- | ----- | ----- | ----- | 
| Text of ISO/IEC FDIS 23090-14 Scene Description | 2022-05-04 | [MDS21201_WG03_N00485](https://dms.mpeg.expert/doc_end_user/documents/137_OnLine/wg11/MDS21201_WG03_N00485-v2.zip) | [ISO](https://www.iso.org/standard/80900.html) | [published](https://sd.iso.org/projects/project/80900/overview) |
| Text of ISO/IEC FDIS 23090-14 2nd edition Scene description | 2024-07-09 | [MDS23831_WG03_N01221](https://dms.mpeg.expert/doc_end_user/documents/146_Rennes/wg11/MDS23831_WG03_N01221.zip) | [ISO](https://www.iso.org/standard/90191.html) | [DIS approved for registration as FDIS](https://sd.iso.org/projects/project/90191/overview) |
| Request for ISO/IEC 23090-14 2nd edition AMD 1 Support of MPEG-I immersive audio, scene understanding and other extensions | 2024-12-16 | [MDS24556_WG03_N01399](https://dms.mpeg.expert/doc_end_user/documents/147_Sapporo/wg11/MDS24158_WG03_N01312.zip) | [ISO](https://www.iso.org/standard/90213.html) | [Project registered](https://sd.iso.org/projects/project/90213/overview) |
| Text of ISO/IEC IS 23090-24 Conformance and reference software for scene description | 2024-03-15 | [MDS23538_WG03_N01169](https://dms.mpeg.expert/doc_end_user/documents/145_OnLine/wg11/MDS23538_WG03_N01169.zip) | [ISO](https://www.iso.org/standard/83696.html) | [Published](https://sd.iso.org/projects/project/83696/overview) |
| Working Draft of ISO/IEC 23090-24 AMD 1 Conformance and reference software for scene description on haptics, augmented reality, avatars, interactivity, MPEG-I audio and lighting | 2024-08-28 | [MDS24166_WG03_N01320](https://dms.mpeg.expert/doc_end_user/documents/147_Sapporo/wg11/MDS24166_WG03_N01320.zip) | [ISO](https://www.iso.org/standard/87584.html) | [Timeline extended](https://sd.iso.org/projects/project/87584/overview) |




# MPEG glTF Extension Registry

## Extensions for glTF 2.0

#### Vendor Extensions

* [MPEG_accessor_timed](MPEG_accessor_timed/README.md)
* [MPEG_animation_timing](MPEG_animation_timing/README.md)
* [MPEG_audio_spatial](MPEG_audio_spatial/README.md)
* [MPEG_buffer_circular](MPEG_buffer_circular/README.md)
* [MPEG_media](MPEG_media/README.md)
* [MPEG_mesh_linking](MPEG_mesh_linking/README.md)
* [MPEG_scene_dynamic](MPEG_scene_dynamic/README.md)
* [MPEG_texture_video](MPEG_texture_video/README.md)
* [MPEG_viewport_recommended](MPEG_viewport_recommended/README.md)

The following extensions were added in the ISO/IEC 23090-14 2nd Edition:

* [MPEG_anchor](MPEG_anchor/README.md)
* [MPEG_interactivity](MPEG_interactivity/README.md)
* [MPEG_lighting](MPEG_lighting/README.md)
* [MPEG_node_avatar](MPEG_node_avatar/README.md)

## License

The copyright in this software is being made available under the BSD License, included below. This software may be subject to other third party and contributor rights, including patentrights, and no such rights are granted under this license.

Copyright (c) 2010-2021, ISO/IEC
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* Neither the name of the ISO/IEC nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
