# MPEG_scene_dynamic

## Contributors

* ISO/IEC SC29 WG3 (MPEG Systems) - Scene Description Breakout Group
* Contacts
  * Thomas Stockhammer (MPEG-I Scene Description BoG Chair, tsto@qti.qualcomm.com)

## Status

Based on [ISO/IEC FDIS 23090-14](https://www.iso.org/standard/80900.html)

## Dependencies

Written against the glTF 2.0 spec.

## glTF Schema Updates

**`MPEG_scene_dynamic extension` Properties**

|   |Type|Description|Required|
|---|---|---|---|
|**media**|`integer`|The index of the media in `MPEG_media` extension.| &#10003; Yes|
|**track**|`integer`|The index of a track of media in `MPEG_media` extension.|No|
|**extensions**|`object`|JSON object with extension-specific objects.|No|
|**extras**|[`any`](#reference-any)|Application-specific data.|No|

Additional properties are allowed.

* **JSON schema**: [MPEG_scene_dynamic.schema.json](/Extensions/MPEG_scene_dynamic/schema/MPEG_scene_dynamic.schema.json)

### MPEG_scene_dynamic extension.media

The index of the media in `MPEG_media` that provides dynamic scene update information.

* **Type**: `integer`
* **Required**:  &#10003; Yes
* **Minimum**: ` >= 0`

### MPEG_scene_dynamic extension.track

The index of a track of media in `MPEG_media` that provides dynamic scene update information. The track samples as defined in ISO/IEC 23090-14 contain scene description updates and provide timing to perform these updates. If track is not provided, it shall be assumed that all tracks provided by the referenced media object are used to provide the update samples.

* **Type**: `integer`
* **Required**: No
* **Minimum**: ` >= 0`

### MPEG_scene_dynamic extension.extensions

JSON object with extension-specific objects.

* **Type**: `object`
* **Required**: No
* **Type of each property**: Extension

### MPEG_scene_dynamic extension.extras

Application-specific data.

* **Type**: [`any`](#reference-any)
* **Required**: No




## Known Implementations

* [ISO/IEC WD 23090-24](https://www.iso.org/standard/83696.html)

## Resources

* [ISO/IEC FDIS 23090-14](https://www.iso.org/standard/80900.html), Information technology — Coded representation of immersive media — Part 14: Scene Description 
* [ISO/IEC WD 23090-24](https://www.iso.org/standard/83696.html), Information technology — Coded representation of immersive media — Part 24: Conformance and Reference Software for Scene Description for MPEG Media

## License

Copyright ISO/IEC 2022

The use of the "MPEG scene description extensions" is subject to the license as accessible here: https://standards.iso.org/ and is subject to the IPR policy as accessible here: https://www.iso.org/iso-standards-and-patents.html.

