/*

====================================================================
                        Copyright Header            
====================================================================

This software module was originally developed by Ralf Funken
(Philips, Eindhoven, The Netherlands) and edited by Takehiro Moriya 
(NTT Labs. Tokyo, Japan) in the course of development of the
MPEG-2/MPEG-4 Conformance ISO/IEC 13818-4, 14496-4. This software
module is an implementation of one or more of the Audio Conformance
tools as specified by MPEG-2/MPEG-4 Conformance. ISO/IEC gives users
of the MPEG-2 AAC/MPEG-4 Audio (ISO/IEC 13818-3,7, 14496-3) free
license to this software module or modifications thereof for use in
hardware or software products. Those intending to use this software
module in hardware or software products are advised that its use may
infringe existing patents. The original developer of this software
module and his/her company, the subsequent editors and their
companies, and ISO/IEC have no liability for use of this software
module or modifications thereof in an implementation. Philips retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party. This copyright notice must be included in 
all copies or derivative works. Copyright 2000.


Source file: TABLES.H

*/

#ifndef TABLES_H_
#define TABLES_H_

#include "pns_common.h"

#define LEN_SAMP_IDX        4

/*******************************************************************/
/*     Scale Factor Bands                                          */
/*******************************************************************/

/* fs = 88.2, 96 kHz */
const short sfb_96_1024[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  32, 36, 40, 44, 48, 52, 56, 
  64, 72, 80, 88, 96, 108, 120, 
  132, 144, 156, 172, 188, 212, 240, 
  276, 320, 384, 448, 512, 576, 640, 
  704, 768, 832, 896, 960, 1024
};

const short sfb_96_960[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  32, 36, 40, 44, 48, 52, 56, 
  64, 72, 80, 88, 96, 108, 120, 
  132, 144, 156, 172, 188, 212, 240, 
  276, 320, 384, 448, 512, 576, 640, 
  704, 768, 832, 896, 960
};

const short sfb_96_128[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 32, 
  40, 48, 64, 92, 128
};

const short sfb_96_120[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 32, 
  40, 48, 64, 92, 120
};

/* fs = 64 kHz */
const short sfb_64_1024[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  32, 36, 40, 44, 48, 52, 56, 
  64, 72, 80, 88, 100, 112, 124, 
  140, 156, 172, 192, 216, 240, 268, 
  304, 344, 384, 424, 464, 504, 544, 
  584, 624, 664, 704, 744, 784, 824, 
  864, 904, 944, 984, 1024
};

const short sfb_64_960[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  32, 36, 40, 44, 48, 52, 56, 
  64, 72, 80, 88, 100, 112, 124, 
  140, 156, 172, 192, 216, 240, 268, 
  304, 344, 384, 424, 464, 504, 544, 
  584, 624, 664, 704, 744, 784, 824, 
  864, 904, 944, 960
}; 

const short sfb_64_128[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 32, 
  40, 48, 64, 92, 128
};

const short sfb_64_120[] =
{ 0,  
  4, 8, 12, 16, 20, 24, 32, 
  40, 48, 64, 92, 120
};

/* fs = 44.1, 48 kHz */
const short sfb_48_1024[] =
 { 0, 
  4,    8,  12, 16, 20, 24, 28, 
  32,   36, 40, 48, 56, 64, 72, 
  80,   88, 96, 108,    120,    132,    144,    
  160,  176,    196,    216,    240,    264,    292,    
  320,  352,    384,    416,    448,    480,    512,    
  544,  576,    608,    640,    672,    704,    736,    
  768,  800,    832,    864,    896,    928,    1024
};

const short sfb_48_960[] = 
{ 0, 
  4,      8,      12,     16,     20,     24,     28,
  32,     36,     40,     48,     56,     64,     72,
  80,     88,     96,     108,    120,    132,    144,
  160,    176,    196,    216,    240,    264,    292,
  320,    352,    384,    416,    448,    480,    512,
  544,    576,    608,    640,    672,    704,    736,
  768,    800,    832,    864,    896,    928,    960
};

const short sfb_48_512[] = 
{ 0, 
  4,      8,      12,     16,     20,     24,     28, 
  32,     36,     40,     44,     48,     52,     56, 
  60,     68,     76,     84,     92,     100,    112,
  124,    136,    148,    164,    184,    208,    236,
  268,    300,    332,    364,    396,    428,    460,
  512
};

const short sfb_48_480[] = 
{ 0, 
  4,      8,      12,     16,     20,     24,     28, 
  32,     36,     40,     44,     48,     52,     56, 
  64,     72,     80,     88,     96,     108,    120,
  132,    144,    156,    172,    188,    212,    240,
  272,    304,    336,    368,    400,    432,    480
};

const short sfb_48_128[] =
{ 0, 
  4,    8,  12, 16, 20, 28, 36, 
  44,   56, 68, 80, 96, 112,    128
};

const short sfb_48_120[] =
{   0, 
    4,    8,      12,     16,     20,     28,     36,
    44,   56,     68,     80,     96,     112,    120
};

/* fs = 32 kHz */
const short sfb_32_1024[] =
{ 0, 
  4,    8,  12, 16, 20, 24, 28, 
  32,   36, 40, 48, 56, 64, 72, 
  80,   88, 96, 108,    120,    132,    144,    
  160,  176,    196,    216,    240,    264,    292,    
  320,  352,    384,    416,    448,    480,    512,    
  544,  576,    608,    640,    672,    704,    736,    
  768,  800,    832,    864,    896,    928,    960,
  992,  1024
};

const short sfb_32_960[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 48, 56, 64, 72, 80, 88, 96, 108, 120, 132, 144, 160, 176, 196, 216, 240, 264, 292, 320, 
  352, 384, 416, 448, 480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 960
};

const short sfb_32_512[] =
{ 0, 
  4,     8,       12,     16,     20,     24,     28, 
  32,    36,      40,     44,     48,     52,     56, 
  64,    72,      80,     88,     96,     108,    120, 
  132,   144,     160,    176,    192,    212,    236, 
  260,   288,     320,    352,    384,    416,    448, 
  480,   512
};

const short sfb_32_480[] =
{ 0, 
  4,     8,       12,     16,     20,      24,     28, 
  32,    36,      40,     44,     48,      52,     56, 
  60,    64,      72,     80,     88,      96,     104, 
  112,   124,     136,    148,    164,     180,    200, 
  224,   256,     288,    320,    352,     384,    416, 
  448,   480
};

const short sfb_32_120[] =
{ 0, 
  4, 8, 12, 16, 20, 28, 36, 44, 56, 68, 80, 96, 112, 120, 0 
};

/* fs = 22.05, 24 kHz */
const short sfb_24_1024[] =
{ 0, 
  4,   8,   12,  16,  20,  24,  28, 
  32,  36,  40,  44,  52,  60,  68, 
  76,  84,  92,  100, 108, 116, 124, 
  136, 148, 160, 172, 188, 204, 220, 
  240, 260, 284, 308, 336, 364, 396, 
  432, 468, 508, 552, 600, 652, 704, 
  768, 832, 896, 960, 1024
};

const short sfb_24_960[] =
{ 0, 
  4,   8,   12,  16,  20,  24,  28,
  32,  36,  40,  44,  52,  60,  68,
  76,  84,  92,  100, 108, 116, 124,
  136, 148, 160, 172, 188, 204, 220,
  240, 260, 284, 308, 336, 364, 396,
  432, 468, 508, 552, 600, 652, 704,
  768, 832, 896, 960
};

const short sfb_24_512[] =
{ 0, 
  4,   8,   12,  16,  20,  24,  28,  
  32,  36,  40,  44,  52,  60,  68, 
  80,  92,  104, 120, 140, 164, 192, 
  224, 256, 288, 320, 352, 384, 416, 
  448, 480, 512
};

const short sfb_24_480[] =
{ 0, 
  4,   8,   12,  16,  20,  24,  28,  
  32,  36,  40,  44,  52,  60,  68, 
  80,  92,  104, 120, 140, 164, 192, 
  224, 256, 288, 320, 352, 384, 416, 
  448, 480
};

const short sfb_24_128[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 36, 44, 52, 64, 76, 92, 108, 128
};

const short sfb_24_120[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 36, 44, 52, 64, 76, 92, 108, 120, 0
};

/* fs = 11.025, 12, 16 kHz */
const short sfb_16_1024[] =
{ 0, 
  8,   16,  24,  32,  40,  48,  56, 
  64,  72,  80,  88,  100, 112, 124, 
  136, 148, 160, 172, 184, 196, 212, 
  228, 244, 260, 280, 300, 320, 344, 
  368, 396, 424, 456, 492, 532, 572, 
  616, 664, 716, 772, 832, 896, 960, 
  1024
};

const short sfb_16_960[] =
{ 0, 
  8,   16,  24,  32,  40,  48,  56, 
  64,  72,  80,  88,  100, 112, 124, 
  136, 148, 160, 172, 184, 196, 212, 
  228, 244, 260, 280, 300, 320, 344, 
  368, 396, 424, 456, 492, 532, 572, 
  616, 664, 716, 772, 832, 896, 960
};

const short sfb_16_128[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 60, 72, 88, 108, 128
};

const short sfb_16_120[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 60, 72, 88, 108, 120
};

/* fs = 8 kHz */
const short sfb_8_1024[] =
{ 0, 
  12, 24, 36, 48, 60, 72, 84, 
  96, 108, 120, 132, 144, 156, 172, 
  188, 204, 220, 236, 252, 268, 288, 
  308, 328, 348, 372, 396, 420, 448, 
  476, 508, 544, 580, 620, 664, 712, 
  764, 820, 880, 944, 1024
};

const short sfb_8_960[] =
{ 0, 
  12, 24, 36, 48, 60, 72, 84, 
  96, 108, 120, 132, 144, 156, 172, 
  188, 204, 220, 236, 252, 268, 288, 
  308, 328, 348, 372, 396, 420, 448, 
  476, 508, 544, 580, 620, 664, 712, 
  764, 820, 880, 944, 960
};

const short sfb_8_128[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  36, 44, 52, 60, 72, 88, 108, 
  128
};

const short sfb_8_120[] =
{ 0, 
  4, 8, 12, 16, 20, 24, 28, 
  36, 44, 52, 60, 72, 88, 108, 
  120
};

typedef struct {
  int           samp_rate;
  int           nsfb1024;
  const short*  SFbands1024;
  int           nsfb128;
  const short*  SFbands128;
  int           nsfb960;
  const short*  SFbands960;
  int           nsfb120;
  const short*  SFbands120;
  int           nsfb480;
  const short*  SFbands480;
  int           nsfb512;
  const short*  SFbands512;
} SR_Info;

SR_Info samp_rate_info[(1<<LEN_SAMP_IDX)] =
{
  /* sr , 1024             128             960             120               480              512               */
  /*      #sft, sft        #sft, sft       #sft, sft       #sft, sft         #sft, sft        #sft, sft         */
  {96000, 41, sfb_96_1024, 12, sfb_96_128, 40, sfb_96_960, 12, sfb_96_120   ,  0,          0,  0,          0  },
  {88200, 41, sfb_96_1024, 12, sfb_96_128, 40, sfb_96_960, 12, sfb_96_120   ,  0,          0,  0,          0  },
  {64000, 47, sfb_64_1024, 12, sfb_64_128, 46, sfb_64_960, 12, sfb_64_120   ,  0,          0,  0,          0  },
  {48000, 49, sfb_48_1024, 14, sfb_48_128, 49, sfb_48_960, 14, sfb_48_120   , 35, sfb_48_480, 36, sfb_48_512  },
  {44100, 49, sfb_48_1024, 14, sfb_48_128, 49, sfb_48_960, 14, sfb_48_120   , 35, sfb_48_480, 36, sfb_48_512  },
  {32000, 51, sfb_32_1024, 14, sfb_48_128, 49, sfb_32_960, 14, sfb_48_120   , 37, sfb_32_480, 37, sfb_32_512  },
  {24000, 47, sfb_24_1024, 15, sfb_24_128, 46, sfb_24_960, 15, sfb_24_120   , 30, sfb_24_480, 31, sfb_24_512  },
  {22050, 47, sfb_24_1024, 15, sfb_24_128, 46, sfb_24_960, 15, sfb_24_120   , 30, sfb_24_480, 31, sfb_24_512  },
  {16000, 43, sfb_16_1024, 15, sfb_16_128, 42, sfb_16_960, 15, sfb_16_120   ,  0,          0,  0,          0  },
  {12000, 43, sfb_16_1024, 15, sfb_16_128, 42, sfb_16_960, 15, sfb_16_120   ,  0,          0,  0,          0  },
  {11025, 43, sfb_16_1024, 15, sfb_16_128, 42, sfb_16_960, 15, sfb_16_120   ,  0,          0,  0,          0  },
  { 8000, 40,  sfb_8_1024, 15,  sfb_8_128, 40,  sfb_8_960, 15,  sfb_8_120   ,  0,          0,  0,          0  },
  {    0,  0,           0,  0,          0,  0,          0,  0,          0   ,  0,          0,  0,          0  }
};


/*******************************************************************/
/*     Hanning Windows                                             */
/*******************************************************************/

static Float hannwin_2048[] = {0.000000e+00,2.355395e-06,9.421557e-06,2.119842e-05,3.768587e-05,5.888376e-05,8.479188e-05,1.154100e-04,1.507378e-04,1.907750e-04,2.355212e-04,2.849759e-04,3.391388e-04,3.980092e-04,4.615867e-04,5.298706e-04,6.028604e-04,6.805552e-04,7.629544e-04,8.500572e-04,9.418628e-04,1.038370e-03,1.139579e-03,1.245487e-03,1.356095e-03,1.471401e-03,1.591403e-03,1.716102e-03,1.845495e-03,1.979581e-03,2.118360e-03,2.261829e-03,2.409988e-03,2.562835e-03,2.720368e-03,2.882587e-03,3.049489e-03,3.221074e-03,3.397339e-03,3.578282e-03,3.763903e-03,3.954199e-03,4.149168e-03,4.348810e-03,4.553121e-03,4.762100e-03,4.975745e-03,5.194054e-03,5.417024e-03,5.644655e-03,5.876943e-03,6.113886e-03,6.355483e-03,6.601730e-03,6.852626e-03,7.108169e-03,7.368355e-03,7.633183e-03,7.902649e-03,8.176752e-03,8.455488e-03,8.738856e-03,9.026852e-03,9.319474e-03,9.616719e-03,9.918584e-03,1.022507e-02,1.053616e-02,1.085187e-02,1.117219e-02,1.149711e-02,1.182664e-02,1.216076e-02,1.249948e-02,1.284279e-02,1.319070e-02,1.354319e-02,1.390026e-02,1.426191e-02,1.462814e-02,1.499894e-02,1.537432e-02,1.575425e-02,1.613875e-02,1.652781e-02,1.692143e-02,1.731959e-02,1.772230e-02,1.812956e-02,1.854136e-02,1.895769e-02,1.937855e-02,1.980395e-02,2.023386e-02,2.066830e-02,2.110725e-02,2.155072e-02,2.199869e-02,2.245117e-02,2.290815e-02,2.336962e-02,2.383558e-02,2.430603e-02,2.478096e-02,2.526036e-02,2.574424e-02,2.623259e-02,2.672540e-02,2.722267e-02,2.772440e-02,2.823057e-02,2.874119e-02,2.925625e-02,2.977574e-02,3.029967e-02,3.082802e-02,3.136079e-02,3.189797e-02,3.243957e-02,3.298557e-02,3.353597e-02,3.409077e-02,3.464995e-02,3.521352e-02,3.578147e-02,3.635379e-02,3.693048e-02,3.751154e-02,3.809695e-02,3.868671e-02,3.928082e-02,3.987927e-02,4.048206e-02,4.108917e-02,4.170061e-02,4.231636e-02,4.293643e-02,4.356081e-02,4.418948e-02,4.482245e-02,4.545971e-02,4.610125e-02,4.674706e-02,4.739715e-02,4.805150e-02,4.871011e-02,4.937297e-02,5.004008e-02,5.071142e-02,5.138700e-02,5.206681e-02,5.275083e-02,5.343907e-02,5.413152e-02,5.482817e-02,5.552901e-02,5.623404e-02,5.694325e-02,5.765664e-02,5.837419e-02,5.909590e-02,5.982177e-02,6.055178e-02,6.128594e-02,6.202423e-02,6.276664e-02,6.351317e-02,6.426382e-02,6.501857e-02,6.577742e-02,6.654036e-02,6.730739e-02,6.807849e-02,6.885366e-02,6.963289e-02,7.041618e-02,7.120352e-02,7.199489e-02,7.279030e-02,7.358973e-02,7.439318e-02,7.520064e-02,7.601210e-02,7.682756e-02,7.764700e-02,7.847042e-02,7.929782e-02,8.012918e-02,8.096449e-02,8.180375e-02,8.264695e-02,8.349409e-02,8.434515e-02,8.520012e-02,8.605900e-02,8.692179e-02,8.778846e-02,8.865902e-02,8.953345e-02,9.041175e-02,9.129391e-02,9.217992e-02,9.306977e-02,9.396346e-02,9.486097e-02,9.576230e-02,9.666744e-02,9.757638e-02,9.848911e-02,9.940562e-02,1.003259e-01,1.012500e-01,1.021778e-01,1.031093e-01,1.040446e-01,1.049836e-01,1.059264e-01,1.068729e-01,1.078230e-01,1.087769e-01,1.097344e-01,1.106956e-01,1.116605e-01,1.126291e-01,1.136013e-01,1.145771e-01,1.155566e-01,1.165397e-01,1.175264e-01,1.185167e-01,1.195106e-01,1.205081e-01,1.215092e-01,1.225138e-01,1.235220e-01,1.245337e-01,1.255490e-01,1.265678e-01,1.275901e-01,1.286159e-01,1.296452e-01,1.306781e-01,1.317143e-01,1.327541e-01,1.337973e-01,1.348440e-01,1.358941e-01,1.369477e-01,1.380046e-01,1.390650e-01,1.401288e-01,1.411959e-01,1.422665e-01,1.433404e-01,1.444177e-01,1.454983e-01,1.465823e-01,1.476696e-01,1.487602e-01,1.498541e-01,1.509514e-01,1.520519e-01,1.531557e-01,1.542627e-01,1.553730e-01,1.564866e-01,1.576034e-01,1.587234e-01,1.598467e-01,1.609731e-01,1.621028e-01,1.632356e-01,1.643716e-01,1.655107e-01,1.666530e-01,1.677985e-01,1.689471e-01,1.700988e-01,1.712536e-01,1.724115e-01,1.735725e-01,1.747366e-01,1.759037e-01,1.770739e-01,1.782471e-01,1.794234e-01,1.806026e-01,1.817849e-01,1.829702e-01,1.841585e-01,1.853497e-01,1.865440e-01,1.877411e-01,1.889412e-01,1.901443e-01,1.913502e-01,1.925591e-01,1.937709e-01,1.949855e-01,1.962030e-01,1.974234e-01,1.986467e-01,1.998727e-01,2.011016e-01,2.023334e-01,2.035679e-01,2.048052e-01,2.060453e-01,2.072882e-01,2.085338e-01,2.097822e-01,2.110333e-01,2.122871e-01,2.135436e-01,2.148029e-01,2.160648e-01,2.173294e-01,2.185967e-01,2.198666e-01,2.211391e-01,2.224143e-01,2.236921e-01,2.249725e-01,2.262555e-01,2.275411e-01,2.288292e-01,2.301199e-01,2.314131e-01,2.327089e-01,2.340072e-01,2.353080e-01,2.366112e-01,2.379170e-01,2.392252e-01,2.405359e-01,2.418491e-01,2.431646e-01,2.444826e-01,2.458030e-01,2.471258e-01,2.484510e-01,2.497785e-01,2.511084e-01,2.524407e-01,2.537752e-01,2.551121e-01,2.564513e-01,2.577928e-01,2.591366e-01,2.604827e-01,2.618310e-01,2.631815e-01,2.645343e-01,2.658893e-01,2.672465e-01,2.686059e-01,2.699675e-01,2.713312e-01,2.726971e-01,2.740652e-01,2.754353e-01,2.768076e-01,2.781820e-01,2.795585e-01,2.809370e-01,2.823177e-01,2.837003e-01,2.850850e-01,2.864718e-01,2.878605e-01,2.892513e-01,2.906440e-01,2.920387e-01,2.934354e-01,2.948340e-01,2.962345e-01,2.976370e-01,2.990413e-01,3.004476e-01,3.018557e-01,3.032657e-01,3.046776e-01,3.060913e-01,3.075068e-01,3.089242e-01,3.103433e-01,3.117642e-01,3.131869e-01,3.146114e-01,3.160376e-01,3.174656e-01,3.188952e-01,3.203266e-01,3.217596e-01,3.231944e-01,3.246308e-01,3.260689e-01,3.275085e-01,3.289499e-01,3.303928e-01,3.318373e-01,3.332834e-01,3.347311e-01,3.361804e-01,3.376312e-01,3.390835e-01,3.405373e-01,3.419927e-01,3.434495e-01,3.449078e-01,3.463675e-01,3.478287e-01,3.492914e-01,3.507554e-01,3.522209e-01,3.536878e-01,3.551560e-01,3.566256e-01,3.580966e-01,3.595689e-01,3.610425e-01,3.625174e-01,3.639936e-01,3.654711e-01,3.669499e-01,3.684299e-01,3.699112e-01,3.713936e-01,3.728773e-01,3.743622e-01,3.758483e-01,3.773356e-01,3.788240e-01,3.803135e-01,3.818042e-01,3.832960e-01,3.847889e-01,3.862828e-01,3.877779e-01,3.892740e-01,3.907711e-01,3.922693e-01,3.937685e-01,3.952687e-01,3.967698e-01,3.982720e-01,3.997751e-01,4.012792e-01,4.027841e-01,4.042900e-01,4.057968e-01,4.073045e-01,4.088131e-01,4.103225e-01,4.118328e-01,4.133439e-01,4.148558e-01,4.163685e-01,4.178820e-01,4.193963e-01,4.209113e-01,4.224271e-01,4.239436e-01,4.254608e-01,4.269787e-01,4.284973e-01,4.300166e-01,4.315366e-01,4.330572e-01,4.345784e-01,4.361002e-01,4.376227e-01,4.391457e-01,4.406693e-01,4.421935e-01,4.437182e-01,4.452434e-01,4.467692e-01,4.482955e-01,4.498222e-01,4.513494e-01,4.528771e-01,4.544052e-01,4.559338e-01,4.574627e-01,4.589921e-01,4.605218e-01,4.620520e-01,4.635824e-01,4.651133e-01,4.666444e-01,4.681759e-01,4.697076e-01,4.712397e-01,4.727720e-01,4.743046e-01,4.758374e-01,4.773705e-01,4.789037e-01,4.804372e-01,4.819708e-01,4.835046e-01,4.850386e-01,4.865727e-01,4.881070e-01,4.896413e-01,4.911758e-01,4.927103e-01,4.942449e-01,4.957795e-01,4.973142e-01,4.988490e-01,5.003837e-01,5.019184e-01,5.034531e-01,5.049878e-01,5.065224e-01,5.080570e-01,5.095915e-01,5.111259e-01,5.126602e-01,5.141943e-01,5.157284e-01,5.172623e-01,5.187960e-01,5.203296e-01,5.218629e-01,5.233961e-01,5.249290e-01,5.264617e-01,5.279942e-01,5.295264e-01,5.310583e-01,5.325899e-01,5.341212e-01,5.356522e-01,5.371828e-01,5.387132e-01,5.402431e-01,5.417726e-01,5.433018e-01,5.448306e-01,5.463589e-01,5.478868e-01,5.494143e-01,5.509412e-01,5.524677e-01,5.539937e-01,5.555192e-01,5.570442e-01,5.585687e-01,5.600925e-01,5.616159e-01,5.631386e-01,5.646607e-01,5.661823e-01,5.677032e-01,5.692235e-01,5.707431e-01,5.722620e-01,5.737803e-01,5.752979e-01,5.768148e-01,5.783309e-01,5.798463e-01,5.813610e-01,5.828749e-01,5.843880e-01,5.859003e-01,5.874118e-01,5.889225e-01,5.904323e-01,5.919413e-01,5.934494e-01,5.949567e-01,5.964630e-01,5.979685e-01,5.994730e-01,6.009766e-01,6.024792e-01,6.039809e-01,6.054815e-01,6.069812e-01,6.084799e-01,6.099776e-01,6.114742e-01,6.129698e-01,6.144643e-01,6.159577e-01,6.174501e-01,6.189413e-01,6.204314e-01,6.219204e-01,6.234082e-01,6.248949e-01,6.263804e-01,6.278647e-01,6.293478e-01,6.308296e-01,6.323103e-01,6.337897e-01,6.352678e-01,6.367447e-01,6.382202e-01,6.396945e-01,6.411675e-01,6.426391e-01,6.441094e-01,6.455783e-01,6.470458e-01,6.485120e-01,6.499768e-01,6.514401e-01,6.529020e-01,6.543625e-01,6.558216e-01,6.572791e-01,6.587352e-01,6.601898e-01,6.616429e-01,6.630944e-01,6.645444e-01,6.659929e-01,6.674398e-01,6.688851e-01,6.703289e-01,6.717710e-01,6.732115e-01,6.746504e-01,6.760876e-01,6.775232e-01,6.789571e-01,6.803893e-01,6.818198e-01,6.832486e-01,6.846757e-01,6.861010e-01,6.875246e-01,6.889464e-01,6.903665e-01,6.917847e-01,6.932012e-01,6.946158e-01,6.960286e-01,6.974395e-01,6.988486e-01,7.002558e-01,7.016611e-01,7.030645e-01,7.044660e-01,7.058656e-01,7.072632e-01,7.086589e-01,7.100526e-01,7.114444e-01,7.128341e-01,7.142218e-01,7.156076e-01,7.169913e-01,7.183729e-01,7.197525e-01,7.211300e-01,7.225054e-01,7.238788e-01,7.252500e-01,7.266191e-01,7.279861e-01,7.293509e-01,7.307136e-01,7.320741e-01,7.334324e-01,7.347885e-01,7.361424e-01,7.374940e-01,7.388435e-01,7.401906e-01,7.415356e-01,7.428782e-01,7.442186e-01,7.455566e-01,7.468923e-01,7.482258e-01,7.495568e-01,7.508856e-01,7.522119e-01,7.535359e-01,7.548575e-01,7.561767e-01,7.574935e-01,7.588078e-01,7.601197e-01,7.614292e-01,7.627362e-01,7.640407e-01,7.653428e-01,7.666423e-01,7.679393e-01,7.692338e-01,7.705258e-01,7.718152e-01,7.731020e-01,7.743863e-01,7.756680e-01,7.769471e-01,7.782236e-01,7.794975e-01,7.807687e-01,7.820373e-01,7.833032e-01,7.845665e-01,7.858271e-01,7.870850e-01,7.883402e-01,7.895926e-01,7.908424e-01,7.920894e-01,7.933336e-01,7.945751e-01,7.958138e-01,7.970497e-01,7.982829e-01,7.995132e-01,8.007407e-01,8.019653e-01,8.031871e-01,8.044061e-01,8.056222e-01,8.068354e-01,8.080457e-01,8.092531e-01,8.104576e-01,8.116592e-01,8.128578e-01,8.140535e-01,8.152463e-01,8.164360e-01,8.176228e-01,8.188066e-01,8.199874e-01,8.211651e-01,8.223399e-01,8.235116e-01,8.246803e-01,8.258459e-01,8.270084e-01,8.281678e-01,8.293242e-01,8.304775e-01,8.316276e-01,8.327746e-01,8.339185e-01,8.350592e-01,8.361968e-01,8.373312e-01,8.384625e-01,8.395905e-01,8.407154e-01,8.418370e-01,8.429554e-01,8.440706e-01,8.451825e-01,8.462912e-01,8.473966e-01,8.484988e-01,8.495977e-01,8.506932e-01,8.517855e-01,8.528745e-01,8.539601e-01,8.550424e-01,8.561214e-01,8.571970e-01,8.582692e-01,8.593381e-01,8.604035e-01,8.614656e-01,8.625243e-01,8.635795e-01,8.646314e-01,8.656798e-01,8.667247e-01,8.677662e-01,8.688042e-01,8.698388e-01,8.708699e-01,8.718974e-01,8.729215e-01,8.739421e-01,8.749591e-01,8.759726e-01,8.769826e-01,8.779890e-01,8.789918e-01,8.799911e-01,8.809868e-01,8.819789e-01,8.829674e-01,8.839523e-01,8.849336e-01,8.859112e-01,8.868853e-01,8.878556e-01,8.888224e-01,8.897854e-01,8.907448e-01,8.917005e-01,8.926525e-01,8.936008e-01,8.945454e-01,8.954863e-01,8.964235e-01,8.973569e-01,8.982866e-01,8.992125e-01,9.001347e-01,9.010531e-01,9.019677e-01,9.028786e-01,9.037856e-01,9.046888e-01,9.055883e-01,9.064839e-01,9.073756e-01,9.082636e-01,9.091477e-01,9.100279e-01,9.109042e-01,9.117767e-01,9.126454e-01,9.135101e-01,9.143709e-01,9.152279e-01,9.160809e-01,9.169300e-01,9.177751e-01,9.186164e-01,9.194537e-01,9.202870e-01,9.211164e-01,9.219418e-01,9.227632e-01,9.235807e-01,9.243941e-01,9.252036e-01,9.260090e-01,9.268105e-01,9.276079e-01,9.284013e-01,9.291907e-01,9.299760e-01,9.307572e-01,9.315344e-01,9.323076e-01,9.330766e-01,9.338416e-01,9.346025e-01,9.353593e-01,9.361120e-01,9.368606e-01,9.376051e-01,9.383454e-01,9.390817e-01,9.398137e-01,9.405417e-01,9.412655e-01,9.419851e-01,9.427006e-01,9.434119e-01,9.441190e-01,9.448219e-01,9.455207e-01,9.462152e-01,9.469056e-01,9.475917e-01,9.482736e-01,9.489513e-01,9.496248e-01,9.502940e-01,9.509590e-01,9.516197e-01,9.522762e-01,9.529284e-01,9.535764e-01,9.542201e-01,9.548595e-01,9.554946e-01,9.561254e-01,9.567519e-01,9.573741e-01,9.579921e-01,9.586057e-01,9.592149e-01,9.598199e-01,9.604205e-01,9.610168e-01,9.616087e-01,9.621963e-01,9.627795e-01,9.633584e-01,9.639329e-01,9.645030e-01,9.650688e-01,9.656302e-01,9.661872e-01,9.667398e-01,9.672880e-01,9.678318e-01,9.683712e-01,9.689061e-01,9.694367e-01,9.699628e-01,9.704846e-01,9.710018e-01,9.715147e-01,9.720231e-01,9.725270e-01,9.730265e-01,9.735216e-01,9.740121e-01,9.744983e-01,9.749799e-01,9.754571e-01,9.759298e-01,9.763980e-01,9.768617e-01,9.773209e-01,9.777756e-01,9.782259e-01,9.786716e-01,9.791128e-01,9.795495e-01,9.799817e-01,9.804093e-01,9.808324e-01,9.812510e-01,9.816651e-01,9.820746e-01,9.824796e-01,9.828801e-01,9.832760e-01,9.836673e-01,9.840541e-01,9.844363e-01,9.848139e-01,9.851870e-01,9.855555e-01,9.859195e-01,9.862788e-01,9.866336e-01,9.869838e-01,9.873294e-01,9.876705e-01,9.880069e-01,9.883387e-01,9.886659e-01,9.889885e-01,9.893066e-01,9.896200e-01,9.899288e-01,9.902329e-01,9.905325e-01,9.908274e-01,9.911177e-01,9.914034e-01,9.916845e-01,9.919609e-01,9.922327e-01,9.924998e-01,9.927623e-01,9.930202e-01,9.932734e-01,9.935220e-01,9.937659e-01,9.940052e-01,9.942398e-01,9.944697e-01,9.946950e-01,9.949157e-01,9.951317e-01,9.953430e-01,9.955496e-01,9.957516e-01,9.959489e-01,9.961415e-01,9.963295e-01,9.965128e-01,9.966914e-01,9.968653e-01,9.970345e-01,9.971991e-01,9.973590e-01,9.975142e-01,9.976647e-01,9.978105e-01,9.979516e-01,9.980880e-01,9.982198e-01,9.983468e-01,9.984692e-01,9.985868e-01,9.986998e-01,9.988081e-01,9.989116e-01,9.990105e-01,9.991046e-01,9.991941e-01,9.992788e-01,9.993589e-01,9.994342e-01,9.995049e-01,9.995708e-01,9.996320e-01,9.996885e-01,9.997403e-01,9.997874e-01,9.998298e-01,9.998675e-01,9.999005e-01,9.999288e-01,9.999523e-01,9.999711e-01,9.999853e-01,9.999947e-01,9.999994e-01,9.999994e-01,9.999947e-01,9.999853e-01,9.999711e-01,9.999523e-01,9.999288e-01,9.999005e-01,9.998675e-01,9.998298e-01,9.997874e-01,9.997403e-01,9.996885e-01,9.996320e-01,9.995708e-01,9.995049e-01,9.994342e-01,9.993589e-01,9.992788e-01,9.991941e-01,9.991046e-01,9.990105e-01,9.989116e-01,9.988081e-01,9.986998e-01,9.985868e-01,9.984692e-01,9.983468e-01,9.982198e-01,9.980880e-01,9.979516e-01,9.978105e-01,9.976647e-01,9.975142e-01,9.973590e-01,9.971991e-01,9.970345e-01,9.968653e-01,9.966914e-01,9.965128e-01,9.963295e-01,9.961415e-01,9.959489e-01,9.957516e-01,9.955496e-01,9.953430e-01,9.951317e-01,9.949157e-01,9.946950e-01,9.944697e-01,9.942398e-01,9.940052e-01,9.937659e-01,9.935220e-01,9.932734e-01,9.930202e-01,9.927623e-01,9.924998e-01,9.922327e-01,9.919609e-01,9.916845e-01,9.914034e-01,9.911177e-01,9.908274e-01,9.905325e-01,9.902329e-01,9.899288e-01,9.896200e-01,9.893066e-01,9.889885e-01,9.886659e-01,9.883387e-01,9.880069e-01,9.876705e-01,9.873294e-01,9.869838e-01,9.866336e-01,9.862788e-01,9.859195e-01,9.855555e-01,9.851870e-01,9.848139e-01,9.844363e-01,9.840541e-01,9.836673e-01,9.832760e-01,9.828801e-01,9.824796e-01,9.820746e-01,9.816651e-01,9.812510e-01,9.808324e-01,9.804093e-01,9.799817e-01,9.795495e-01,9.791128e-01,9.786716e-01,9.782259e-01,9.777756e-01,9.773209e-01,9.768617e-01,9.763980e-01,9.759298e-01,9.754571e-01,9.749799e-01,9.744983e-01,9.740121e-01,9.735216e-01,9.730265e-01,9.725270e-01,9.720231e-01,9.715147e-01,9.710018e-01,9.704846e-01,9.699628e-01,9.694367e-01,9.689061e-01,9.683712e-01,9.678318e-01,9.672880e-01,9.667398e-01,9.661872e-01,9.656302e-01,9.650688e-01,9.645030e-01,9.639329e-01,9.633584e-01,9.627795e-01,9.621963e-01,9.616087e-01,9.610168e-01,9.604205e-01,9.598199e-01,9.592149e-01,9.586057e-01,9.579921e-01,9.573741e-01,9.567519e-01,9.561254e-01,9.554946e-01,9.548595e-01,9.542201e-01,9.535764e-01,9.529284e-01,9.522762e-01,9.516197e-01,9.509590e-01,9.502940e-01,9.496248e-01,9.489513e-01,9.482736e-01,9.475917e-01,9.469056e-01,9.462152e-01,9.455207e-01,9.448219e-01,9.441190e-01,9.434119e-01,9.427006e-01,9.419851e-01,9.412655e-01,9.405417e-01,9.398137e-01,9.390817e-01,9.383454e-01,9.376051e-01,9.368606e-01,9.361120e-01,9.353593e-01,9.346025e-01,9.338416e-01,9.330766e-01,9.323076e-01,9.315344e-01,9.307572e-01,9.299760e-01,9.291907e-01,9.284013e-01,9.276079e-01,9.268105e-01,9.260090e-01,9.252036e-01,9.243941e-01,9.235807e-01,9.227632e-01,9.219418e-01,9.211164e-01,9.202870e-01,9.194537e-01,9.186164e-01,9.177751e-01,9.169300e-01,9.160809e-01,9.152279e-01,9.143709e-01,9.135101e-01,9.126454e-01,9.117767e-01,9.109042e-01,9.100279e-01,9.091477e-01,9.082636e-01,9.073756e-01,9.064839e-01,9.055883e-01,9.046888e-01,9.037856e-01,9.028786e-01,9.019677e-01,9.010531e-01,9.001347e-01,8.992125e-01,8.982866e-01,8.973569e-01,8.964235e-01,8.954863e-01,8.945454e-01,8.936008e-01,8.926525e-01,8.917005e-01,8.907448e-01,8.897854e-01,8.888224e-01,8.878556e-01,8.868853e-01,8.859112e-01,8.849336e-01,8.839523e-01,8.829674e-01,8.819789e-01,8.809868e-01,8.799911e-01,8.789918e-01,8.779890e-01,8.769826e-01,8.759726e-01,8.749591e-01,8.739421e-01,8.729215e-01,8.718974e-01,8.708699e-01,8.698388e-01,8.688042e-01,8.677662e-01,8.667247e-01,8.656798e-01,8.646314e-01,8.635795e-01,8.625243e-01,8.614656e-01,8.604035e-01,8.593381e-01,8.582692e-01,8.571970e-01,8.561214e-01,8.550424e-01,8.539601e-01,8.528745e-01,8.517855e-01,8.506932e-01,8.495977e-01,8.484988e-01,8.473966e-01,8.462912e-01,8.451825e-01,8.440706e-01,8.429554e-01,8.418370e-01,8.407154e-01,8.395905e-01,8.384625e-01,8.373312e-01,8.361968e-01,8.350592e-01,8.339185e-01,8.327746e-01,8.316276e-01,8.304775e-01,8.293242e-01,8.281678e-01,8.270084e-01,8.258459e-01,8.246803e-01,8.235116e-01,8.223399e-01,8.211651e-01,8.199874e-01,8.188066e-01,8.176228e-01,8.164360e-01,8.152463e-01,8.140535e-01,8.128578e-01,8.116592e-01,8.104576e-01,8.092531e-01,8.080457e-01,8.068354e-01,8.056222e-01,8.044061e-01,8.031871e-01,8.019653e-01,8.007407e-01,7.995132e-01,7.982829e-01,7.970497e-01,7.958138e-01,7.945751e-01,7.933336e-01,7.920894e-01,7.908424e-01,7.895926e-01,7.883402e-01,7.870850e-01,7.858271e-01,7.845665e-01,7.833032e-01,7.820373e-01,7.807687e-01,7.794975e-01,7.782236e-01,7.769471e-01,7.756680e-01,7.743863e-01,7.731020e-01,7.718152e-01,7.705258e-01,7.692338e-01,7.679393e-01,7.666423e-01,7.653428e-01,7.640407e-01,7.627362e-01,7.614292e-01,7.601197e-01,7.588078e-01,7.574935e-01,7.561767e-01,7.548575e-01,7.535359e-01,7.522119e-01,7.508856e-01,7.495568e-01,7.482258e-01,7.468923e-01,7.455566e-01,7.442186e-01,7.428782e-01,7.415356e-01,7.401906e-01,7.388435e-01,7.374940e-01,7.361424e-01,7.347885e-01,7.334324e-01,7.320741e-01,7.307136e-01,7.293509e-01,7.279861e-01,7.266191e-01,7.252500e-01,7.238788e-01,7.225054e-01,7.211300e-01,7.197525e-01,7.183729e-01,7.169913e-01,7.156076e-01,7.142218e-01,7.128341e-01,7.114444e-01,7.100526e-01,7.086589e-01,7.072632e-01,7.058656e-01,7.044660e-01,7.030645e-01,7.016611e-01,7.002558e-01,6.988486e-01,6.974395e-01,6.960286e-01,6.946158e-01,6.932012e-01,6.917847e-01,6.903665e-01,6.889464e-01,6.875246e-01,6.861010e-01,6.846757e-01,6.832486e-01,6.818198e-01,6.803893e-01,6.789571e-01,6.775232e-01,6.760876e-01,6.746504e-01,6.732115e-01,6.717710e-01,6.703289e-01,6.688851e-01,6.674398e-01,6.659929e-01,6.645444e-01,6.630944e-01,6.616429e-01,6.601898e-01,6.587352e-01,6.572791e-01,6.558216e-01,6.543625e-01,6.529020e-01,6.514401e-01,6.499768e-01,6.485120e-01,6.470458e-01,6.455783e-01,6.441094e-01,6.426391e-01,6.411675e-01,6.396945e-01,6.382202e-01,6.367447e-01,6.352678e-01,6.337897e-01,6.323103e-01,6.308296e-01,6.293478e-01,6.278647e-01,6.263804e-01,6.248949e-01,6.234082e-01,6.219204e-01,6.204314e-01,6.189413e-01,6.174501e-01,6.159577e-01,6.144643e-01,6.129698e-01,6.114742e-01,6.099776e-01,6.084799e-01,6.069812e-01,6.054815e-01,6.039809e-01,6.024792e-01,6.009766e-01,5.994730e-01,5.979685e-01,5.964630e-01,5.949567e-01,5.934494e-01,5.919413e-01,5.904323e-01,5.889225e-01,5.874118e-01,5.859003e-01,5.843880e-01,5.828749e-01,5.813610e-01,5.798463e-01,5.783309e-01,5.768148e-01,5.752979e-01,5.737803e-01,5.722620e-01,5.707431e-01,5.692235e-01,5.677032e-01,5.661823e-01,5.646607e-01,5.631386e-01,5.616159e-01,5.600925e-01,5.585687e-01,5.570442e-01,5.555192e-01,5.539937e-01,5.524677e-01,5.509412e-01,5.494143e-01,5.478868e-01,5.463589e-01,5.448306e-01,5.433018e-01,5.417726e-01,5.402431e-01,5.387132e-01,5.371828e-01,5.356522e-01,5.341212e-01,5.325899e-01,5.310583e-01,5.295264e-01,5.279942e-01,5.264617e-01,5.249290e-01,5.233961e-01,5.218629e-01,5.203296e-01,5.187960e-01,5.172623e-01,5.157284e-01,5.141943e-01,5.126602e-01,5.111259e-01,5.095915e-01,5.080570e-01,5.065224e-01,5.049878e-01,5.034531e-01,5.019184e-01,5.003837e-01,4.988490e-01,4.973142e-01,4.957795e-01,4.942449e-01,4.927103e-01,4.911758e-01,4.896413e-01,4.881070e-01,4.865727e-01,4.850386e-01,4.835046e-01,4.819708e-01,4.804372e-01,4.789037e-01,4.773705e-01,4.758374e-01,4.743046e-01,4.727720e-01,4.712397e-01,4.697076e-01,4.681759e-01,4.666444e-01,4.651133e-01,4.635824e-01,4.620520e-01,4.605218e-01,4.589921e-01,4.574627e-01,4.559338e-01,4.544052e-01,4.528771e-01,4.513494e-01,4.498222e-01,4.482955e-01,4.467692e-01,4.452434e-01,4.437182e-01,4.421935e-01,4.406693e-01,4.391457e-01,4.376227e-01,4.361002e-01,4.345784e-01,4.330572e-01,4.315366e-01,4.300166e-01,4.284973e-01,4.269787e-01,4.254608e-01,4.239436e-01,4.224271e-01,4.209113e-01,4.193963e-01,4.178820e-01,4.163685e-01,4.148558e-01,4.133439e-01,4.118328e-01,4.103225e-01,4.088131e-01,4.073045e-01,4.057968e-01,4.042900e-01,4.027841e-01,4.012792e-01,3.997751e-01,3.982720e-01,3.967698e-01,3.952687e-01,3.937685e-01,3.922693e-01,3.907711e-01,3.892740e-01,3.877779e-01,3.862828e-01,3.847889e-01,3.832960e-01,3.818042e-01,3.803135e-01,3.788240e-01,3.773356e-01,3.758483e-01,3.743622e-01,3.728773e-01,3.713936e-01,3.699112e-01,3.684299e-01,3.669499e-01,3.654711e-01,3.639936e-01,3.625174e-01,3.610425e-01,3.595689e-01,3.580966e-01,3.566256e-01,3.551560e-01,3.536878e-01,3.522209e-01,3.507554e-01,3.492914e-01,3.478287e-01,3.463675e-01,3.449078e-01,3.434495e-01,3.419927e-01,3.405373e-01,3.390835e-01,3.376312e-01,3.361804e-01,3.347311e-01,3.332834e-01,3.318373e-01,3.303928e-01,3.289499e-01,3.275085e-01,3.260689e-01,3.246308e-01,3.231944e-01,3.217596e-01,3.203266e-01,3.188952e-01,3.174656e-01,3.160376e-01,3.146114e-01,3.131869e-01,3.117642e-01,3.103433e-01,3.089242e-01,3.075068e-01,3.060913e-01,3.046776e-01,3.032657e-01,3.018557e-01,3.004476e-01,2.990413e-01,2.976370e-01,2.962345e-01,2.948340e-01,2.934354e-01,2.920387e-01,2.906440e-01,2.892513e-01,2.878605e-01,2.864718e-01,2.850850e-01,2.837003e-01,2.823177e-01,2.809370e-01,2.795585e-01,2.781820e-01,2.768076e-01,2.754353e-01,2.740652e-01,2.726971e-01,2.713312e-01,2.699675e-01,2.686059e-01,2.672465e-01,2.658893e-01,2.645343e-01,2.631815e-01,2.618310e-01,2.604827e-01,2.591366e-01,2.577928e-01,2.564513e-01,2.551121e-01,2.537752e-01,2.524407e-01,2.511084e-01,2.497785e-01,2.484510e-01,2.471258e-01,2.458030e-01,2.444826e-01,2.431646e-01,2.418491e-01,2.405359e-01,2.392252e-01,2.379170e-01,2.366112e-01,2.353080e-01,2.340072e-01,2.327089e-01,2.314131e-01,2.301199e-01,2.288292e-01,2.275411e-01,2.262555e-01,2.249725e-01,2.236921e-01,2.224143e-01,2.211391e-01,2.198666e-01,2.185967e-01,2.173294e-01,2.160648e-01,2.148029e-01,2.135436e-01,2.122871e-01,2.110333e-01,2.097822e-01,2.085338e-01,2.072882e-01,2.060453e-01,2.048052e-01,2.035679e-01,2.023334e-01,2.011016e-01,1.998727e-01,1.986467e-01,1.974234e-01,1.962030e-01,1.949855e-01,1.937709e-01,1.925591e-01,1.913502e-01,1.901443e-01,1.889412e-01,1.877411e-01,1.865440e-01,1.853497e-01,1.841585e-01,1.829702e-01,1.817849e-01,1.806026e-01,1.794234e-01,1.782471e-01,1.770739e-01,1.759037e-01,1.747366e-01,1.735725e-01,1.724115e-01,1.712536e-01,1.700988e-01,1.689471e-01,1.677985e-01,1.666530e-01,1.655107e-01,1.643716e-01,1.632356e-01,1.621028e-01,1.609731e-01,1.598467e-01,1.587234e-01,1.576034e-01,1.564866e-01,1.553730e-01,1.542627e-01,1.531557e-01,1.520519e-01,1.509514e-01,1.498541e-01,1.487602e-01,1.476696e-01,1.465823e-01,1.454983e-01,1.444177e-01,1.433404e-01,1.422665e-01,1.411959e-01,1.401288e-01,1.390650e-01,1.380046e-01,1.369477e-01,1.358941e-01,1.348440e-01,1.337973e-01,1.327541e-01,1.317143e-01,1.306781e-01,1.296452e-01,1.286159e-01,1.275901e-01,1.265678e-01,1.255490e-01,1.245337e-01,1.235220e-01,1.225138e-01,1.215092e-01,1.205081e-01,1.195106e-01,1.185167e-01,1.175264e-01,1.165397e-01,1.155566e-01,1.145771e-01,1.136013e-01,1.126291e-01,1.116605e-01,1.106956e-01,1.097344e-01,1.087769e-01,1.078230e-01,1.068729e-01,1.059264e-01,1.049836e-01,1.040446e-01,1.031093e-01,1.021778e-01,1.012500e-01,1.003259e-01,9.940562e-02,9.848911e-02,9.757638e-02,9.666744e-02,9.576230e-02,9.486097e-02,9.396346e-02,9.306977e-02,9.217992e-02,9.129391e-02,9.041175e-02,8.953345e-02,8.865902e-02,8.778846e-02,8.692179e-02,8.605900e-02,8.520012e-02,8.434515e-02,8.349409e-02,8.264695e-02,8.180375e-02,8.096449e-02,8.012918e-02,7.929782e-02,7.847042e-02,7.764700e-02,7.682756e-02,7.601210e-02,7.520064e-02,7.439318e-02,7.358973e-02,7.279030e-02,7.199489e-02,7.120352e-02,7.041618e-02,6.963289e-02,6.885366e-02,6.807849e-02,6.730739e-02,6.654036e-02,6.577742e-02,6.501857e-02,6.426382e-02,6.351317e-02,6.276664e-02,6.202423e-02,6.128594e-02,6.055178e-02,5.982177e-02,5.909590e-02,5.837419e-02,5.765664e-02,5.694325e-02,5.623404e-02,5.552901e-02,5.482817e-02,5.413152e-02,5.343907e-02,5.275083e-02,5.206681e-02,5.138700e-02,5.071142e-02,5.004008e-02,4.937297e-02,4.871011e-02,4.805150e-02,4.739715e-02,4.674706e-02,4.610125e-02,4.545971e-02,4.482245e-02,4.418948e-02,4.356081e-02,4.293643e-02,4.231636e-02,4.170061e-02,4.108917e-02,4.048206e-02,3.987927e-02,3.928082e-02,3.868671e-02,3.809695e-02,3.751154e-02,3.693048e-02,3.635379e-02,3.578147e-02,3.521352e-02,3.464995e-02,3.409077e-02,3.353597e-02,3.298557e-02,3.243957e-02,3.189797e-02,3.136079e-02,3.082802e-02,3.029967e-02,2.977574e-02,2.925625e-02,2.874119e-02,2.823057e-02,2.772440e-02,2.722267e-02,2.672540e-02,2.623259e-02,2.574424e-02,2.526036e-02,2.478096e-02,2.430603e-02,2.383558e-02,2.336962e-02,2.290815e-02,2.245117e-02,2.199869e-02,2.155072e-02,2.110725e-02,2.066830e-02,2.023386e-02,1.980395e-02,1.937855e-02,1.895769e-02,1.854136e-02,1.812956e-02,1.772230e-02,1.731959e-02,1.692143e-02,1.652781e-02,1.613875e-02,1.575425e-02,1.537432e-02,1.499894e-02,1.462814e-02,1.426191e-02,1.390026e-02,1.354319e-02,1.319070e-02,1.284279e-02,1.249948e-02,1.216076e-02,1.182664e-02,1.149711e-02,1.117219e-02,1.085187e-02,1.053616e-02,1.022507e-02,9.918584e-03,9.616719e-03,9.319474e-03,9.026852e-03,8.738856e-03,8.455488e-03,8.176752e-03,7.902649e-03,7.633183e-03,7.368355e-03,7.108169e-03,6.852626e-03,6.601730e-03,6.355483e-03,6.113886e-03,5.876943e-03,5.644655e-03,5.417024e-03,5.194054e-03,4.975745e-03,4.762100e-03,4.553121e-03,4.348810e-03,4.149168e-03,3.954199e-03,3.763903e-03,3.578282e-03,3.397339e-03,3.221074e-03,3.049489e-03,2.882587e-03,2.720368e-03,2.562835e-03,2.409988e-03,2.261829e-03,2.118360e-03,1.979581e-03,1.845495e-03,1.716102e-03,1.591403e-03,1.471401e-03,1.356095e-03,1.245487e-03,1.139579e-03,1.038370e-03,9.418628e-04,8.500572e-04,7.629544e-04,6.805552e-04,6.028604e-04,5.298706e-04,4.615867e-04,3.980092e-04,3.391388e-04,2.849759e-04,2.355212e-04,1.907750e-04,1.507378e-04,1.154100e-04,8.479188e-05,5.888376e-05,3.768587e-05,2.119842e-05,9.421557e-06,2.355395e-06,0.000000e+00};

static Float hannwin_1920[] = {0.000000e+00,2.680090e-06,1.072033e-05,2.412064e-05,4.288087e-05,6.700082e-05,9.648023e-05,1.313188e-04,1.715161e-04,2.170718e-04,2.679853e-04,3.242561e-04,3.858837e-04,4.528673e-04,5.252062e-04,6.028996e-04,6.859468e-04,7.743468e-04,8.680987e-04,9.672014e-04,1.071654e-03,1.181455e-03,1.296604e-03,1.417099e-03,1.542939e-03,1.674123e-03,1.810649e-03,1.952515e-03,2.099721e-03,2.252265e-03,2.410145e-03,2.573359e-03,2.741905e-03,2.915782e-03,3.094989e-03,3.279522e-03,3.469380e-03,3.664562e-03,3.865064e-03,4.070885e-03,4.282022e-03,4.498474e-03,4.720238e-03,4.947311e-03,5.179691e-03,5.417376e-03,5.660364e-03,5.908650e-03,6.162234e-03,6.421111e-03,6.685280e-03,6.954738e-03,7.229481e-03,7.509507e-03,7.794812e-03,8.085394e-03,8.381250e-03,8.682376e-03,8.988769e-03,9.300426e-03,9.617343e-03,9.939517e-03,1.026695e-02,1.059962e-02,1.093755e-02,1.128072e-02,1.162912e-02,1.198277e-02,1.234164e-02,1.270574e-02,1.307507e-02,1.344961e-02,1.382937e-02,1.421435e-02,1.460453e-02,1.499992e-02,1.540050e-02,1.580628e-02,1.621725e-02,1.663341e-02,1.705475e-02,1.748126e-02,1.791295e-02,1.834981e-02,1.879183e-02,1.923901e-02,1.969134e-02,2.014882e-02,2.061145e-02,2.107921e-02,2.155211e-02,2.203014e-02,2.251330e-02,2.300157e-02,2.349495e-02,2.399345e-02,2.449704e-02,2.500574e-02,2.551952e-02,2.603840e-02,2.656235e-02,2.709138e-02,2.762548e-02,2.816464e-02,2.870886e-02,2.925814e-02,2.981246e-02,3.037182e-02,3.093621e-02,3.150564e-02,3.208008e-02,3.265955e-02,3.324402e-02,3.383349e-02,3.442797e-02,3.502743e-02,3.563188e-02,3.624131e-02,3.685571e-02,3.747508e-02,3.809940e-02,3.872867e-02,3.936289e-02,4.000205e-02,4.064614e-02,4.129516e-02,4.194909e-02,4.260793e-02,4.327167e-02,4.394031e-02,4.461385e-02,4.529226e-02,4.597554e-02,4.666370e-02,4.735671e-02,4.805458e-02,4.875729e-02,4.946484e-02,5.017722e-02,5.089442e-02,5.161644e-02,5.234326e-02,5.307488e-02,5.381130e-02,5.455249e-02,5.529847e-02,5.604920e-02,5.680470e-02,5.756495e-02,5.832995e-02,5.909967e-02,5.987413e-02,6.065330e-02,6.143718e-02,6.222577e-02,6.301904e-02,6.381701e-02,6.461964e-02,6.542695e-02,6.623891e-02,6.705553e-02,6.787678e-02,6.870267e-02,6.953318e-02,7.036831e-02,7.120804e-02,7.205237e-02,7.290129e-02,7.375478e-02,7.461285e-02,7.547547e-02,7.634265e-02,7.721437e-02,7.809062e-02,7.897139e-02,7.985668e-02,8.074647e-02,8.164075e-02,8.253952e-02,8.344277e-02,8.435048e-02,8.526265e-02,8.617926e-02,8.710031e-02,8.802579e-02,8.895568e-02,8.988998e-02,9.082868e-02,9.177176e-02,9.271922e-02,9.367104e-02,9.462722e-02,9.558775e-02,9.655261e-02,9.752180e-02,9.849530e-02,9.947311e-02,1.004552e-01,1.014416e-01,1.024322e-01,1.034272e-01,1.044263e-01,1.054297e-01,1.064374e-01,1.074492e-01,1.084653e-01,1.094856e-01,1.105100e-01,1.115387e-01,1.125714e-01,1.136084e-01,1.146495e-01,1.156947e-01,1.167440e-01,1.177975e-01,1.188550e-01,1.199167e-01,1.209824e-01,1.220521e-01,1.231259e-01,1.242038e-01,1.252857e-01,1.263716e-01,1.274615e-01,1.285554e-01,1.296533e-01,1.307552e-01,1.318610e-01,1.329707e-01,1.340844e-01,1.352021e-01,1.363236e-01,1.374490e-01,1.385783e-01,1.397115e-01,1.408486e-01,1.419895e-01,1.431342e-01,1.442828e-01,1.454352e-01,1.465913e-01,1.477513e-01,1.489151e-01,1.500826e-01,1.512538e-01,1.524288e-01,1.536076e-01,1.547900e-01,1.559761e-01,1.571660e-01,1.583595e-01,1.595566e-01,1.607574e-01,1.619619e-01,1.631700e-01,1.643817e-01,1.655969e-01,1.668158e-01,1.680383e-01,1.692643e-01,1.704938e-01,1.717269e-01,1.729635e-01,1.742036e-01,1.754472e-01,1.766943e-01,1.779448e-01,1.791988e-01,1.804562e-01,1.817171e-01,1.829814e-01,1.842490e-01,1.855201e-01,1.867945e-01,1.880723e-01,1.893534e-01,1.906379e-01,1.919256e-01,1.932167e-01,1.945111e-01,1.958087e-01,1.971096e-01,1.984138e-01,1.997212e-01,2.010318e-01,2.023456e-01,2.036626e-01,2.049827e-01,2.063061e-01,2.076326e-01,2.089622e-01,2.102949e-01,2.116308e-01,2.129697e-01,2.143117e-01,2.156568e-01,2.170049e-01,2.183561e-01,2.197103e-01,2.210674e-01,2.224276e-01,2.237908e-01,2.251569e-01,2.265259e-01,2.278979e-01,2.292728e-01,2.306506e-01,2.320313e-01,2.334149e-01,2.348013e-01,2.361906e-01,2.375827e-01,2.389776e-01,2.403753e-01,2.417758e-01,2.431790e-01,2.445851e-01,2.459938e-01,2.474053e-01,2.488195e-01,2.502363e-01,2.516559e-01,2.530781e-01,2.545030e-01,2.559305e-01,2.573606e-01,2.587933e-01,2.602286e-01,2.616664e-01,2.631069e-01,2.645498e-01,2.659953e-01,2.674433e-01,2.688938e-01,2.703468e-01,2.718022e-01,2.732601e-01,2.747204e-01,2.761831e-01,2.776482e-01,2.791157e-01,2.805856e-01,2.820578e-01,2.835323e-01,2.850092e-01,2.864884e-01,2.879699e-01,2.894536e-01,2.909396e-01,2.924279e-01,2.939184e-01,2.954110e-01,2.969059e-01,2.984030e-01,2.999022e-01,3.014035e-01,3.029070e-01,3.044126e-01,3.059203e-01,3.074301e-01,3.089419e-01,3.104558e-01,3.119717e-01,3.134897e-01,3.150096e-01,3.165315e-01,3.180554e-01,3.195812e-01,3.211090e-01,3.226387e-01,3.241703e-01,3.257037e-01,3.272391e-01,3.287763e-01,3.303153e-01,3.318562e-01,3.333988e-01,3.349433e-01,3.364895e-01,3.380374e-01,3.395871e-01,3.411385e-01,3.426917e-01,3.442465e-01,3.458029e-01,3.473611e-01,3.489208e-01,3.504822e-01,3.520452e-01,3.536098e-01,3.551759e-01,3.567436e-01,3.583128e-01,3.598836e-01,3.614558e-01,3.630296e-01,3.646048e-01,3.661814e-01,3.677595e-01,3.693390e-01,3.709199e-01,3.725022e-01,3.740859e-01,3.756709e-01,3.772573e-01,3.788449e-01,3.804339e-01,3.820241e-01,3.836156e-01,3.852084e-01,3.868024e-01,3.883975e-01,3.899939e-01,3.915915e-01,3.931902e-01,3.947901e-01,3.963911e-01,3.979933e-01,3.995965e-01,4.012008e-01,4.028061e-01,4.044125e-01,4.060199e-01,4.076283e-01,4.092377e-01,4.108481e-01,4.124595e-01,4.140717e-01,4.156849e-01,4.172990e-01,4.189140e-01,4.205299e-01,4.221466e-01,4.237641e-01,4.253825e-01,4.270017e-01,4.286216e-01,4.302423e-01,4.318638e-01,4.334860e-01,4.351089e-01,4.367325e-01,4.383568e-01,4.399817e-01,4.416073e-01,4.432335e-01,4.448603e-01,4.464877e-01,4.481157e-01,4.497442e-01,4.513733e-01,4.530029e-01,4.546330e-01,4.562636e-01,4.578946e-01,4.595261e-01,4.611581e-01,4.627904e-01,4.644232e-01,4.660563e-01,4.676898e-01,4.693237e-01,4.709579e-01,4.725923e-01,4.742271e-01,4.758622e-01,4.774975e-01,4.791331e-01,4.807688e-01,4.824048e-01,4.840410e-01,4.856773e-01,4.873138e-01,4.889505e-01,4.905872e-01,4.922241e-01,4.938610e-01,4.954980e-01,4.971351e-01,4.987722e-01,5.004093e-01,5.020464e-01,5.036834e-01,5.053205e-01,5.069574e-01,5.085943e-01,5.102312e-01,5.118679e-01,5.135044e-01,5.151408e-01,5.167771e-01,5.184132e-01,5.200491e-01,5.216848e-01,5.233202e-01,5.249554e-01,5.265903e-01,5.282249e-01,5.298593e-01,5.314933e-01,5.331270e-01,5.347603e-01,5.363932e-01,5.380258e-01,5.396579e-01,5.412897e-01,5.429210e-01,5.445518e-01,5.461821e-01,5.478120e-01,5.494413e-01,5.510701e-01,5.526984e-01,5.543261e-01,5.559532e-01,5.575797e-01,5.592056e-01,5.608309e-01,5.624555e-01,5.640794e-01,5.657027e-01,5.673252e-01,5.689470e-01,5.705681e-01,5.721885e-01,5.738080e-01,5.754268e-01,5.770447e-01,5.786619e-01,5.802781e-01,5.818936e-01,5.835081e-01,5.851218e-01,5.867345e-01,5.883463e-01,5.899572e-01,5.915671e-01,5.931760e-01,5.947839e-01,5.963908e-01,5.979967e-01,5.996015e-01,6.012053e-01,6.028079e-01,6.044095e-01,6.060100e-01,6.076093e-01,6.092074e-01,6.108044e-01,6.124002e-01,6.139948e-01,6.155882e-01,6.171803e-01,6.187712e-01,6.203608e-01,6.219491e-01,6.235361e-01,6.251218e-01,6.267061e-01,6.282891e-01,6.298707e-01,6.314509e-01,6.330297e-01,6.346071e-01,6.361830e-01,6.377575e-01,6.393305e-01,6.409020e-01,6.424720e-01,6.440404e-01,6.456074e-01,6.471727e-01,6.487365e-01,6.502987e-01,6.518593e-01,6.534182e-01,6.549755e-01,6.565312e-01,6.580851e-01,6.596374e-01,6.611879e-01,6.627368e-01,6.642839e-01,6.658292e-01,6.673727e-01,6.689145e-01,6.704544e-01,6.719925e-01,6.735288e-01,6.750632e-01,6.765958e-01,6.781264e-01,6.796551e-01,6.811819e-01,6.827068e-01,6.842297e-01,6.857506e-01,6.872696e-01,6.887865e-01,6.903014e-01,6.918143e-01,6.933251e-01,6.948338e-01,6.963405e-01,6.978450e-01,6.993474e-01,7.008477e-01,7.023458e-01,7.038418e-01,7.053356e-01,7.068272e-01,7.083165e-01,7.098036e-01,7.112885e-01,7.127711e-01,7.142515e-01,7.157295e-01,7.172052e-01,7.186786e-01,7.201497e-01,7.216184e-01,7.230847e-01,7.245486e-01,7.260101e-01,7.274692e-01,7.289258e-01,7.303800e-01,7.318318e-01,7.332810e-01,7.347278e-01,7.361720e-01,7.376137e-01,7.390528e-01,7.404894e-01,7.419234e-01,7.433548e-01,7.447836e-01,7.462098e-01,7.476333e-01,7.490542e-01,7.504724e-01,7.518880e-01,7.533008e-01,7.547109e-01,7.561183e-01,7.575229e-01,7.589248e-01,7.603239e-01,7.617202e-01,7.631137e-01,7.645044e-01,7.658923e-01,7.672773e-01,7.686594e-01,7.700386e-01,7.714150e-01,7.727885e-01,7.741590e-01,7.755266e-01,7.768912e-01,7.782529e-01,7.796115e-01,7.809672e-01,7.823199e-01,7.836695e-01,7.850161e-01,7.863597e-01,7.877002e-01,7.890375e-01,7.903718e-01,7.917030e-01,7.930311e-01,7.943560e-01,7.956777e-01,7.969963e-01,7.983117e-01,7.996239e-01,8.009329e-01,8.022387e-01,8.035412e-01,8.048405e-01,8.061365e-01,8.074292e-01,8.087187e-01,8.100048e-01,8.112876e-01,8.125670e-01,8.138431e-01,8.151159e-01,8.163852e-01,8.176512e-01,8.189138e-01,8.201729e-01,8.214286e-01,8.226809e-01,8.239297e-01,8.251751e-01,8.264169e-01,8.276553e-01,8.288901e-01,8.301214e-01,8.313492e-01,8.325734e-01,8.337941e-01,8.350111e-01,8.362246e-01,8.374345e-01,8.386408e-01,8.398434e-01,8.410424e-01,8.422377e-01,8.434294e-01,8.446174e-01,8.458017e-01,8.469823e-01,8.481591e-01,8.493323e-01,8.505017e-01,8.516673e-01,8.528291e-01,8.539872e-01,8.551415e-01,8.562920e-01,8.574386e-01,8.585815e-01,8.597204e-01,8.608556e-01,8.619868e-01,8.631142e-01,8.642377e-01,8.653572e-01,8.664729e-01,8.675846e-01,8.686924e-01,8.697963e-01,8.708961e-01,8.719920e-01,8.730839e-01,8.741719e-01,8.752558e-01,8.763356e-01,8.774115e-01,8.784833e-01,8.795510e-01,8.806147e-01,8.816743e-01,8.827298e-01,8.837811e-01,8.848284e-01,8.858716e-01,8.869106e-01,8.879455e-01,8.889762e-01,8.900027e-01,8.910251e-01,8.920432e-01,8.930572e-01,8.940670e-01,8.950725e-01,8.960738e-01,8.970708e-01,8.980636e-01,8.990521e-01,9.000364e-01,9.010163e-01,9.019920e-01,9.029633e-01,9.039304e-01,9.048931e-01,9.058514e-01,9.068054e-01,9.077551e-01,9.087003e-01,9.096412e-01,9.105777e-01,9.115098e-01,9.124375e-01,9.133608e-01,9.142796e-01,9.151940e-01,9.161039e-01,9.170094e-01,9.179104e-01,9.188070e-01,9.196990e-01,9.205865e-01,9.214696e-01,9.223481e-01,9.232221e-01,9.240915e-01,9.249564e-01,9.258168e-01,9.266725e-01,9.275237e-01,9.283704e-01,9.292124e-01,9.300498e-01,9.308827e-01,9.317109e-01,9.325344e-01,9.333534e-01,9.341677e-01,9.349773e-01,9.357823e-01,9.365826e-01,9.373782e-01,9.381691e-01,9.389553e-01,9.397369e-01,9.405137e-01,9.412858e-01,9.420531e-01,9.428158e-01,9.435736e-01,9.443268e-01,9.450751e-01,9.458187e-01,9.465575e-01,9.472915e-01,9.480208e-01,9.487452e-01,9.494648e-01,9.501796e-01,9.508895e-01,9.515947e-01,9.522950e-01,9.529904e-01,9.536810e-01,9.543667e-01,9.550476e-01,9.557235e-01,9.563946e-01,9.570608e-01,9.577221e-01,9.583785e-01,9.590300e-01,9.596765e-01,9.603181e-01,9.609548e-01,9.615866e-01,9.622134e-01,9.628352e-01,9.634521e-01,9.640640e-01,9.646710e-01,9.652729e-01,9.658699e-01,9.664619e-01,9.670488e-01,9.676308e-01,9.682078e-01,9.687797e-01,9.693466e-01,9.699085e-01,9.704653e-01,9.710171e-01,9.715639e-01,9.721056e-01,9.726422e-01,9.731738e-01,9.737003e-01,9.742217e-01,9.747380e-01,9.752492e-01,9.757554e-01,9.762564e-01,9.767524e-01,9.772432e-01,9.777289e-01,9.782095e-01,9.786850e-01,9.791553e-01,9.796205e-01,9.800806e-01,9.805355e-01,9.809852e-01,9.814298e-01,9.818693e-01,9.823035e-01,9.827326e-01,9.831566e-01,9.835753e-01,9.839889e-01,9.843973e-01,9.848004e-01,9.851984e-01,9.855912e-01,9.859788e-01,9.863612e-01,9.867383e-01,9.871102e-01,9.874770e-01,9.878385e-01,9.881947e-01,9.885457e-01,9.888915e-01,9.892321e-01,9.895674e-01,9.898974e-01,9.902222e-01,9.905418e-01,9.908561e-01,9.911651e-01,9.914688e-01,9.917673e-01,9.920606e-01,9.923485e-01,9.926312e-01,9.929086e-01,9.931807e-01,9.934475e-01,9.937090e-01,9.939652e-01,9.942162e-01,9.944618e-01,9.947021e-01,9.949372e-01,9.951669e-01,9.953913e-01,9.956104e-01,9.958242e-01,9.960327e-01,9.962359e-01,9.964337e-01,9.966262e-01,9.968134e-01,9.969953e-01,9.971718e-01,9.973430e-01,9.975089e-01,9.976695e-01,9.978247e-01,9.979745e-01,9.981191e-01,9.982583e-01,9.983921e-01,9.985206e-01,9.986438e-01,9.987616e-01,9.988741e-01,9.989812e-01,9.990830e-01,9.991794e-01,9.992705e-01,9.993562e-01,9.994366e-01,9.995116e-01,9.995813e-01,9.996456e-01,9.997045e-01,9.997581e-01,9.998064e-01,9.998493e-01,9.998868e-01,9.999189e-01,9.999457e-01,9.999672e-01,9.999832e-01,9.999940e-01,9.999993e-01,9.999993e-01,9.999940e-01,9.999832e-01,9.999672e-01,9.999457e-01,9.999189e-01,9.998868e-01,9.998493e-01,9.998064e-01,9.997581e-01,9.997045e-01,9.996456e-01,9.995813e-01,9.995116e-01,9.994366e-01,9.993562e-01,9.992705e-01,9.991794e-01,9.990830e-01,9.989812e-01,9.988741e-01,9.987616e-01,9.986438e-01,9.985206e-01,9.983921e-01,9.982583e-01,9.981191e-01,9.979745e-01,9.978247e-01,9.976695e-01,9.975089e-01,9.973430e-01,9.971718e-01,9.969953e-01,9.968134e-01,9.966262e-01,9.964337e-01,9.962359e-01,9.960327e-01,9.958242e-01,9.956104e-01,9.953913e-01,9.951669e-01,9.949372e-01,9.947021e-01,9.944618e-01,9.942162e-01,9.939652e-01,9.937090e-01,9.934475e-01,9.931807e-01,9.929086e-01,9.926312e-01,9.923485e-01,9.920606e-01,9.917673e-01,9.914688e-01,9.911651e-01,9.908561e-01,9.905418e-01,9.902222e-01,9.898974e-01,9.895674e-01,9.892321e-01,9.888915e-01,9.885457e-01,9.881947e-01,9.878385e-01,9.874770e-01,9.871102e-01,9.867383e-01,9.863612e-01,9.859788e-01,9.855912e-01,9.851984e-01,9.848004e-01,9.843973e-01,9.839889e-01,9.835753e-01,9.831566e-01,9.827326e-01,9.823035e-01,9.818693e-01,9.814298e-01,9.809852e-01,9.805355e-01,9.800806e-01,9.796205e-01,9.791553e-01,9.786850e-01,9.782095e-01,9.777289e-01,9.772432e-01,9.767524e-01,9.762564e-01,9.757554e-01,9.752492e-01,9.747380e-01,9.742217e-01,9.737003e-01,9.731738e-01,9.726422e-01,9.721056e-01,9.715639e-01,9.710171e-01,9.704653e-01,9.699085e-01,9.693466e-01,9.687797e-01,9.682078e-01,9.676308e-01,9.670488e-01,9.664619e-01,9.658699e-01,9.652729e-01,9.646710e-01,9.640640e-01,9.634521e-01,9.628352e-01,9.622134e-01,9.615866e-01,9.609548e-01,9.603181e-01,9.596765e-01,9.590300e-01,9.583785e-01,9.577221e-01,9.570608e-01,9.563946e-01,9.557235e-01,9.550476e-01,9.543667e-01,9.536810e-01,9.529904e-01,9.522950e-01,9.515947e-01,9.508895e-01,9.501796e-01,9.494648e-01,9.487452e-01,9.480208e-01,9.472915e-01,9.465575e-01,9.458187e-01,9.450751e-01,9.443268e-01,9.435736e-01,9.428158e-01,9.420531e-01,9.412858e-01,9.405137e-01,9.397369e-01,9.389553e-01,9.381691e-01,9.373782e-01,9.365826e-01,9.357823e-01,9.349773e-01,9.341677e-01,9.333534e-01,9.325344e-01,9.317109e-01,9.308827e-01,9.300498e-01,9.292124e-01,9.283704e-01,9.275237e-01,9.266725e-01,9.258168e-01,9.249564e-01,9.240915e-01,9.232221e-01,9.223481e-01,9.214696e-01,9.205865e-01,9.196990e-01,9.188070e-01,9.179104e-01,9.170094e-01,9.161039e-01,9.151940e-01,9.142796e-01,9.133608e-01,9.124375e-01,9.115098e-01,9.105777e-01,9.096412e-01,9.087003e-01,9.077551e-01,9.068054e-01,9.058514e-01,9.048931e-01,9.039304e-01,9.029633e-01,9.019920e-01,9.010163e-01,9.000364e-01,8.990521e-01,8.980636e-01,8.970708e-01,8.960738e-01,8.950725e-01,8.940670e-01,8.930572e-01,8.920432e-01,8.910251e-01,8.900027e-01,8.889762e-01,8.879455e-01,8.869106e-01,8.858716e-01,8.848284e-01,8.837811e-01,8.827298e-01,8.816743e-01,8.806147e-01,8.795510e-01,8.784833e-01,8.774115e-01,8.763356e-01,8.752558e-01,8.741719e-01,8.730839e-01,8.719920e-01,8.708961e-01,8.697963e-01,8.686924e-01,8.675846e-01,8.664729e-01,8.653572e-01,8.642377e-01,8.631142e-01,8.619868e-01,8.608556e-01,8.597204e-01,8.585815e-01,8.574386e-01,8.562920e-01,8.551415e-01,8.539872e-01,8.528291e-01,8.516673e-01,8.505017e-01,8.493323e-01,8.481591e-01,8.469823e-01,8.458017e-01,8.446174e-01,8.434294e-01,8.422377e-01,8.410424e-01,8.398434e-01,8.386408e-01,8.374345e-01,8.362246e-01,8.350111e-01,8.337941e-01,8.325734e-01,8.313492e-01,8.301214e-01,8.288901e-01,8.276553e-01,8.264169e-01,8.251751e-01,8.239297e-01,8.226809e-01,8.214286e-01,8.201729e-01,8.189138e-01,8.176512e-01,8.163852e-01,8.151159e-01,8.138431e-01,8.125670e-01,8.112876e-01,8.100048e-01,8.087187e-01,8.074292e-01,8.061365e-01,8.048405e-01,8.035412e-01,8.022387e-01,8.009329e-01,7.996239e-01,7.983117e-01,7.969963e-01,7.956777e-01,7.943560e-01,7.930311e-01,7.917030e-01,7.903718e-01,7.890375e-01,7.877002e-01,7.863597e-01,7.850161e-01,7.836695e-01,7.823199e-01,7.809672e-01,7.796115e-01,7.782529e-01,7.768912e-01,7.755266e-01,7.741590e-01,7.727885e-01,7.714150e-01,7.700386e-01,7.686594e-01,7.672773e-01,7.658923e-01,7.645044e-01,7.631137e-01,7.617202e-01,7.603239e-01,7.589248e-01,7.575229e-01,7.561183e-01,7.547109e-01,7.533008e-01,7.518880e-01,7.504724e-01,7.490542e-01,7.476333e-01,7.462098e-01,7.447836e-01,7.433548e-01,7.419234e-01,7.404894e-01,7.390528e-01,7.376137e-01,7.361720e-01,7.347278e-01,7.332810e-01,7.318318e-01,7.303800e-01,7.289258e-01,7.274692e-01,7.260101e-01,7.245486e-01,7.230847e-01,7.216184e-01,7.201497e-01,7.186786e-01,7.172052e-01,7.157295e-01,7.142515e-01,7.127711e-01,7.112885e-01,7.098036e-01,7.083165e-01,7.068272e-01,7.053356e-01,7.038418e-01,7.023458e-01,7.008477e-01,6.993474e-01,6.978450e-01,6.963405e-01,6.948338e-01,6.933251e-01,6.918143e-01,6.903014e-01,6.887865e-01,6.872696e-01,6.857506e-01,6.842297e-01,6.827068e-01,6.811819e-01,6.796551e-01,6.781264e-01,6.765958e-01,6.750632e-01,6.735288e-01,6.719925e-01,6.704544e-01,6.689145e-01,6.673727e-01,6.658292e-01,6.642839e-01,6.627368e-01,6.611879e-01,6.596374e-01,6.580851e-01,6.565312e-01,6.549755e-01,6.534182e-01,6.518593e-01,6.502987e-01,6.487365e-01,6.471727e-01,6.456074e-01,6.440404e-01,6.424720e-01,6.409020e-01,6.393305e-01,6.377575e-01,6.361830e-01,6.346071e-01,6.330297e-01,6.314509e-01,6.298707e-01,6.282891e-01,6.267061e-01,6.251218e-01,6.235361e-01,6.219491e-01,6.203608e-01,6.187712e-01,6.171803e-01,6.155882e-01,6.139948e-01,6.124002e-01,6.108044e-01,6.092074e-01,6.076093e-01,6.060100e-01,6.044095e-01,6.028079e-01,6.012053e-01,5.996015e-01,5.979967e-01,5.963908e-01,5.947839e-01,5.931760e-01,5.915671e-01,5.899572e-01,5.883463e-01,5.867345e-01,5.851218e-01,5.835081e-01,5.818936e-01,5.802781e-01,5.786619e-01,5.770447e-01,5.754268e-01,5.738080e-01,5.721885e-01,5.705681e-01,5.689470e-01,5.673252e-01,5.657027e-01,5.640794e-01,5.624555e-01,5.608309e-01,5.592056e-01,5.575797e-01,5.559532e-01,5.543261e-01,5.526984e-01,5.510701e-01,5.494413e-01,5.478120e-01,5.461821e-01,5.445518e-01,5.429210e-01,5.412897e-01,5.396579e-01,5.380258e-01,5.363932e-01,5.347603e-01,5.331270e-01,5.314933e-01,5.298593e-01,5.282249e-01,5.265903e-01,5.249554e-01,5.233202e-01,5.216848e-01,5.200491e-01,5.184132e-01,5.167771e-01,5.151408e-01,5.135044e-01,5.118679e-01,5.102312e-01,5.085943e-01,5.069574e-01,5.053205e-01,5.036834e-01,5.020464e-01,5.004093e-01,4.987722e-01,4.971351e-01,4.954980e-01,4.938610e-01,4.922241e-01,4.905872e-01,4.889505e-01,4.873138e-01,4.856773e-01,4.840410e-01,4.824048e-01,4.807688e-01,4.791331e-01,4.774975e-01,4.758622e-01,4.742271e-01,4.725923e-01,4.709579e-01,4.693237e-01,4.676898e-01,4.660563e-01,4.644232e-01,4.627904e-01,4.611581e-01,4.595261e-01,4.578946e-01,4.562636e-01,4.546330e-01,4.530029e-01,4.513733e-01,4.497442e-01,4.481157e-01,4.464877e-01,4.448603e-01,4.432335e-01,4.416073e-01,4.399817e-01,4.383568e-01,4.367325e-01,4.351089e-01,4.334860e-01,4.318638e-01,4.302423e-01,4.286216e-01,4.270017e-01,4.253825e-01,4.237641e-01,4.221466e-01,4.205299e-01,4.189140e-01,4.172990e-01,4.156849e-01,4.140717e-01,4.124595e-01,4.108481e-01,4.092377e-01,4.076283e-01,4.060199e-01,4.044125e-01,4.028061e-01,4.012008e-01,3.995965e-01,3.979933e-01,3.963911e-01,3.947901e-01,3.931902e-01,3.915915e-01,3.899939e-01,3.883975e-01,3.868024e-01,3.852084e-01,3.836156e-01,3.820241e-01,3.804339e-01,3.788449e-01,3.772573e-01,3.756709e-01,3.740859e-01,3.725022e-01,3.709199e-01,3.693390e-01,3.677595e-01,3.661814e-01,3.646048e-01,3.630296e-01,3.614558e-01,3.598836e-01,3.583128e-01,3.567436e-01,3.551759e-01,3.536098e-01,3.520452e-01,3.504822e-01,3.489208e-01,3.473611e-01,3.458029e-01,3.442465e-01,3.426917e-01,3.411385e-01,3.395871e-01,3.380374e-01,3.364895e-01,3.349433e-01,3.333988e-01,3.318562e-01,3.303153e-01,3.287763e-01,3.272391e-01,3.257037e-01,3.241703e-01,3.226387e-01,3.211090e-01,3.195812e-01,3.180554e-01,3.165315e-01,3.150096e-01,3.134897e-01,3.119717e-01,3.104558e-01,3.089419e-01,3.074301e-01,3.059203e-01,3.044126e-01,3.029070e-01,3.014035e-01,2.999022e-01,2.984030e-01,2.969059e-01,2.954110e-01,2.939184e-01,2.924279e-01,2.909396e-01,2.894536e-01,2.879699e-01,2.864884e-01,2.850092e-01,2.835323e-01,2.820578e-01,2.805856e-01,2.791157e-01,2.776482e-01,2.761831e-01,2.747204e-01,2.732601e-01,2.718022e-01,2.703468e-01,2.688938e-01,2.674433e-01,2.659953e-01,2.645498e-01,2.631069e-01,2.616664e-01,2.602286e-01,2.587933e-01,2.573606e-01,2.559305e-01,2.545030e-01,2.530781e-01,2.516559e-01,2.502363e-01,2.488195e-01,2.474053e-01,2.459938e-01,2.445851e-01,2.431790e-01,2.417758e-01,2.403753e-01,2.389776e-01,2.375827e-01,2.361906e-01,2.348013e-01,2.334149e-01,2.320313e-01,2.306506e-01,2.292728e-01,2.278979e-01,2.265259e-01,2.251569e-01,2.237908e-01,2.224276e-01,2.210674e-01,2.197103e-01,2.183561e-01,2.170049e-01,2.156568e-01,2.143117e-01,2.129697e-01,2.116308e-01,2.102949e-01,2.089622e-01,2.076326e-01,2.063061e-01,2.049827e-01,2.036626e-01,2.023456e-01,2.010318e-01,1.997212e-01,1.984138e-01,1.971096e-01,1.958087e-01,1.945111e-01,1.932167e-01,1.919256e-01,1.906379e-01,1.893534e-01,1.880723e-01,1.867945e-01,1.855201e-01,1.842490e-01,1.829814e-01,1.817171e-01,1.804562e-01,1.791988e-01,1.779448e-01,1.766943e-01,1.754472e-01,1.742036e-01,1.729635e-01,1.717269e-01,1.704938e-01,1.692643e-01,1.680383e-01,1.668158e-01,1.655969e-01,1.643817e-01,1.631700e-01,1.619619e-01,1.607574e-01,1.595566e-01,1.583595e-01,1.571660e-01,1.559761e-01,1.547900e-01,1.536076e-01,1.524288e-01,1.512538e-01,1.500826e-01,1.489151e-01,1.477513e-01,1.465913e-01,1.454352e-01,1.442828e-01,1.431342e-01,1.419895e-01,1.408486e-01,1.397115e-01,1.385783e-01,1.374490e-01,1.363236e-01,1.352021e-01,1.340844e-01,1.329707e-01,1.318610e-01,1.307552e-01,1.296533e-01,1.285554e-01,1.274615e-01,1.263716e-01,1.252857e-01,1.242038e-01,1.231259e-01,1.220521e-01,1.209824e-01,1.199167e-01,1.188550e-01,1.177975e-01,1.167440e-01,1.156947e-01,1.146495e-01,1.136084e-01,1.125714e-01,1.115387e-01,1.105100e-01,1.094856e-01,1.084653e-01,1.074492e-01,1.064374e-01,1.054297e-01,1.044263e-01,1.034272e-01,1.024322e-01,1.014416e-01,1.004552e-01,9.947311e-02,9.849530e-02,9.752180e-02,9.655261e-02,9.558775e-02,9.462722e-02,9.367104e-02,9.271922e-02,9.177176e-02,9.082868e-02,8.988998e-02,8.895568e-02,8.802579e-02,8.710031e-02,8.617926e-02,8.526265e-02,8.435048e-02,8.344277e-02,8.253952e-02,8.164075e-02,8.074647e-02,7.985668e-02,7.897139e-02,7.809062e-02,7.721437e-02,7.634265e-02,7.547547e-02,7.461285e-02,7.375478e-02,7.290129e-02,7.205237e-02,7.120804e-02,7.036831e-02,6.953318e-02,6.870267e-02,6.787678e-02,6.705553e-02,6.623891e-02,6.542695e-02,6.461964e-02,6.381701e-02,6.301904e-02,6.222577e-02,6.143718e-02,6.065330e-02,5.987413e-02,5.909967e-02,5.832995e-02,5.756495e-02,5.680470e-02,5.604920e-02,5.529847e-02,5.455249e-02,5.381130e-02,5.307488e-02,5.234326e-02,5.161644e-02,5.089442e-02,5.017722e-02,4.946484e-02,4.875729e-02,4.805458e-02,4.735671e-02,4.666370e-02,4.597554e-02,4.529226e-02,4.461385e-02,4.394031e-02,4.327167e-02,4.260793e-02,4.194909e-02,4.129516e-02,4.064614e-02,4.000205e-02,3.936289e-02,3.872867e-02,3.809940e-02,3.747508e-02,3.685571e-02,3.624131e-02,3.563188e-02,3.502743e-02,3.442797e-02,3.383349e-02,3.324402e-02,3.265955e-02,3.208008e-02,3.150564e-02,3.093621e-02,3.037182e-02,2.981246e-02,2.925814e-02,2.870886e-02,2.816464e-02,2.762548e-02,2.709138e-02,2.656235e-02,2.603840e-02,2.551952e-02,2.500574e-02,2.449704e-02,2.399345e-02,2.349495e-02,2.300157e-02,2.251330e-02,2.203014e-02,2.155211e-02,2.107921e-02,2.061145e-02,2.014882e-02,1.969134e-02,1.923901e-02,1.879183e-02,1.834981e-02,1.791295e-02,1.748126e-02,1.705475e-02,1.663341e-02,1.621725e-02,1.580628e-02,1.540050e-02,1.499992e-02,1.460453e-02,1.421435e-02,1.382937e-02,1.344961e-02,1.307507e-02,1.270574e-02,1.234164e-02,1.198277e-02,1.162912e-02,1.128072e-02,1.093755e-02,1.059962e-02,1.026695e-02,9.939517e-03,9.617343e-03,9.300426e-03,8.988769e-03,8.682376e-03,8.381250e-03,8.085394e-03,7.794812e-03,7.509507e-03,7.229481e-03,6.954738e-03,6.685280e-03,6.421111e-03,6.162234e-03,5.908650e-03,5.660364e-03,5.417376e-03,5.179691e-03,4.947311e-03,4.720238e-03,4.498474e-03,4.282022e-03,4.070885e-03,3.865064e-03,3.664562e-03,3.469380e-03,3.279522e-03,3.094989e-03,2.915782e-03,2.741905e-03,2.573359e-03,2.410145e-03,2.252265e-03,2.099721e-03,1.952515e-03,1.810649e-03,1.674123e-03,1.542939e-03,1.417099e-03,1.296604e-03,1.181455e-03,1.071654e-03,9.672014e-04,8.680987e-04,7.743468e-04,6.859468e-04,6.028996e-04,5.252062e-04,4.528673e-04,3.858837e-04,3.242561e-04,2.679853e-04,2.170718e-04,1.715161e-04,1.313188e-04,9.648023e-05,6.700082e-05,4.288087e-05,2.412064e-05,1.072033e-05,2.680090e-06,0.000000e+00};

static Float hannwin_1024[] = {0.000000e+00,9.430769e-06,3.772272e-05,8.487479e-05,1.508852e-04,2.357514e-04,3.394703e-04,4.620380e-04,6.034497e-04,7.637002e-04,9.427834e-04,1.140693e-03,1.357420e-03,1.592958e-03,1.847298e-03,2.120429e-03,2.412342e-03,2.723026e-03,3.052468e-03,3.400657e-03,3.767578e-03,4.153220e-03,4.557566e-03,4.980602e-03,5.422311e-03,5.882678e-03,6.361684e-03,6.859311e-03,7.375542e-03,7.910355e-03,8.463732e-03,9.035651e-03,9.626091e-03,1.023503e-02,1.086244e-02,1.150831e-02,1.217260e-02,1.285530e-02,1.355637e-02,1.427579e-02,1.501354e-02,1.576958e-02,1.654388e-02,1.733643e-02,1.814718e-02,1.897611e-02,1.982318e-02,2.068837e-02,2.157164e-02,2.247296e-02,2.339229e-02,2.432960e-02,2.528485e-02,2.625801e-02,2.724904e-02,2.825791e-02,2.928457e-02,3.032899e-02,3.139113e-02,3.247094e-02,3.356839e-02,3.468344e-02,3.581603e-02,3.696614e-02,3.813372e-02,3.931872e-02,4.052109e-02,4.174080e-02,4.297780e-02,4.423204e-02,4.550347e-02,4.679204e-02,4.809772e-02,4.942044e-02,5.076015e-02,5.211681e-02,5.349037e-02,5.488077e-02,5.628797e-02,5.771190e-02,5.915252e-02,6.060976e-02,6.208358e-02,6.357392e-02,6.508073e-02,6.660394e-02,6.814350e-02,6.969935e-02,7.127143e-02,7.285969e-02,7.446406e-02,7.608448e-02,7.772089e-02,7.937323e-02,8.104144e-02,8.272546e-02,8.442521e-02,8.614064e-02,8.787169e-02,8.961828e-02,9.138035e-02,9.315784e-02,9.495067e-02,9.675878e-02,9.858211e-02,1.004206e-01,1.022741e-01,1.041427e-01,1.060261e-01,1.079245e-01,1.098376e-01,1.117655e-01,1.137079e-01,1.156650e-01,1.176366e-01,1.196226e-01,1.216229e-01,1.236375e-01,1.256663e-01,1.277092e-01,1.297662e-01,1.318372e-01,1.339220e-01,1.360206e-01,1.381330e-01,1.402590e-01,1.423986e-01,1.445517e-01,1.467182e-01,1.488980e-01,1.510910e-01,1.532972e-01,1.555165e-01,1.577488e-01,1.599940e-01,1.622521e-01,1.645228e-01,1.668063e-01,1.691023e-01,1.714107e-01,1.737316e-01,1.760648e-01,1.784102e-01,1.807677e-01,1.831373e-01,1.855188e-01,1.879122e-01,1.903174e-01,1.927342e-01,1.951627e-01,1.976026e-01,2.000540e-01,2.025166e-01,2.049905e-01,2.074755e-01,2.099715e-01,2.124785e-01,2.149964e-01,2.175249e-01,2.200642e-01,2.226140e-01,2.251742e-01,2.277449e-01,2.303258e-01,2.329168e-01,2.355180e-01,2.381291e-01,2.407501e-01,2.433809e-01,2.460214e-01,2.486714e-01,2.513309e-01,2.539998e-01,2.566780e-01,2.593654e-01,2.620618e-01,2.647673e-01,2.674816e-01,2.702046e-01,2.729363e-01,2.756766e-01,2.784254e-01,2.811825e-01,2.839479e-01,2.867214e-01,2.895030e-01,2.922925e-01,2.950898e-01,2.978949e-01,3.007076e-01,3.035278e-01,3.063555e-01,3.091904e-01,3.120325e-01,3.148817e-01,3.177379e-01,3.206010e-01,3.234709e-01,3.263474e-01,3.292304e-01,3.321199e-01,3.350158e-01,3.379178e-01,3.408260e-01,3.437402e-01,3.466602e-01,3.495861e-01,3.525176e-01,3.554547e-01,3.583972e-01,3.613451e-01,3.642982e-01,3.672565e-01,3.702197e-01,3.731879e-01,3.761608e-01,3.791384e-01,3.821205e-01,3.851071e-01,3.880981e-01,3.910932e-01,3.940925e-01,3.970957e-01,4.001029e-01,4.031138e-01,4.061284e-01,4.091465e-01,4.121680e-01,4.151928e-01,4.182209e-01,4.212520e-01,4.242861e-01,4.273231e-01,4.303628e-01,4.334051e-01,4.364499e-01,4.394972e-01,4.425467e-01,4.455984e-01,4.486521e-01,4.517078e-01,4.547653e-01,4.578245e-01,4.608853e-01,4.639475e-01,4.670112e-01,4.700760e-01,4.731420e-01,4.762090e-01,4.792770e-01,4.823456e-01,4.854150e-01,4.884849e-01,4.915553e-01,4.946259e-01,4.976968e-01,5.007677e-01,5.038387e-01,5.069094e-01,5.099800e-01,5.130501e-01,5.161197e-01,5.191888e-01,5.222571e-01,5.253246e-01,5.283911e-01,5.314566e-01,5.345208e-01,5.375838e-01,5.406453e-01,5.437053e-01,5.467637e-01,5.498203e-01,5.528750e-01,5.559277e-01,5.589784e-01,5.620267e-01,5.650728e-01,5.681164e-01,5.711574e-01,5.741958e-01,5.772313e-01,5.802639e-01,5.832935e-01,5.863200e-01,5.893432e-01,5.923630e-01,5.953794e-01,5.983921e-01,6.014012e-01,6.044064e-01,6.074077e-01,6.104049e-01,6.133979e-01,6.163867e-01,6.193711e-01,6.223510e-01,6.253263e-01,6.282968e-01,6.312625e-01,6.342233e-01,6.371790e-01,6.401295e-01,6.430747e-01,6.460145e-01,6.489489e-01,6.518776e-01,6.548005e-01,6.577177e-01,6.606289e-01,6.635340e-01,6.664329e-01,6.693256e-01,6.722119e-01,6.750917e-01,6.779649e-01,6.808314e-01,6.836910e-01,6.865438e-01,6.893894e-01,6.922280e-01,6.950593e-01,6.978832e-01,7.006997e-01,7.035086e-01,7.063098e-01,7.091032e-01,7.118888e-01,7.146664e-01,7.174358e-01,7.201971e-01,7.229500e-01,7.256946e-01,7.284306e-01,7.311580e-01,7.338767e-01,7.365866e-01,7.392875e-01,7.419794e-01,7.446622e-01,7.473358e-01,7.500000e-01,7.526548e-01,7.553001e-01,7.579357e-01,7.605616e-01,7.631777e-01,7.657838e-01,7.683800e-01,7.709660e-01,7.735417e-01,7.761072e-01,7.786622e-01,7.812068e-01,7.837407e-01,7.862639e-01,7.887763e-01,7.912779e-01,7.937684e-01,7.962478e-01,7.987161e-01,8.011731e-01,8.036188e-01,8.060530e-01,8.084756e-01,8.108867e-01,8.132859e-01,8.156734e-01,8.180490e-01,8.204125e-01,8.227640e-01,8.251033e-01,8.274304e-01,8.297451e-01,8.320473e-01,8.343370e-01,8.366141e-01,8.388785e-01,8.411302e-01,8.433689e-01,8.455947e-01,8.478075e-01,8.500072e-01,8.521936e-01,8.543668e-01,8.565266e-01,8.586729e-01,8.608057e-01,8.629249e-01,8.650304e-01,8.671222e-01,8.692001e-01,8.712640e-01,8.733140e-01,8.753499e-01,8.773716e-01,8.793791e-01,8.813722e-01,8.833510e-01,8.853153e-01,8.872651e-01,8.892003e-01,8.911208e-01,8.930265e-01,8.949175e-01,8.967935e-01,8.986545e-01,9.005005e-01,9.023315e-01,9.041472e-01,9.059477e-01,9.077328e-01,9.095026e-01,9.112570e-01,9.129958e-01,9.147190e-01,9.164266e-01,9.181185e-01,9.197946e-01,9.214549e-01,9.230993e-01,9.247277e-01,9.263401e-01,9.279365e-01,9.295166e-01,9.310806e-01,9.326283e-01,9.341597e-01,9.356747e-01,9.371733e-01,9.386554e-01,9.401209e-01,9.415699e-01,9.430022e-01,9.444177e-01,9.458165e-01,9.471985e-01,9.485636e-01,9.499118e-01,9.512431e-01,9.525573e-01,9.538544e-01,9.551344e-01,9.563972e-01,9.576429e-01,9.588712e-01,9.600823e-01,9.612760e-01,9.624523e-01,9.636111e-01,9.647525e-01,9.658763e-01,9.669825e-01,9.680712e-01,9.691422e-01,9.701954e-01,9.712310e-01,9.722487e-01,9.732487e-01,9.742308e-01,9.751950e-01,9.761413e-01,9.770696e-01,9.779800e-01,9.788723e-01,9.797465e-01,9.806026e-01,9.814406e-01,9.822605e-01,9.830621e-01,9.838456e-01,9.846107e-01,9.853576e-01,9.860862e-01,9.867965e-01,9.874883e-01,9.881618e-01,9.888169e-01,9.894536e-01,9.900718e-01,9.906714e-01,9.912526e-01,9.918153e-01,9.923594e-01,9.928849e-01,9.933918e-01,9.938801e-01,9.943498e-01,9.948009e-01,9.952333e-01,9.956469e-01,9.960419e-01,9.964182e-01,9.967758e-01,9.971146e-01,9.974347e-01,9.977360e-01,9.980185e-01,9.982822e-01,9.985272e-01,9.987533e-01,9.989606e-01,9.991491e-01,9.993188e-01,9.994696e-01,9.996016e-01,9.997147e-01,9.998090e-01,9.998845e-01,9.999411e-01,9.999788e-01,9.999976e-01,9.999976e-01,9.999788e-01,9.999411e-01,9.998845e-01,9.998090e-01,9.997147e-01,9.996016e-01,9.994696e-01,9.993188e-01,9.991491e-01,9.989606e-01,9.987533e-01,9.985272e-01,9.982822e-01,9.980185e-01,9.977360e-01,9.974347e-01,9.971146e-01,9.967758e-01,9.964182e-01,9.960419e-01,9.956469e-01,9.952333e-01,9.948009e-01,9.943498e-01,9.938801e-01,9.933918e-01,9.928849e-01,9.923594e-01,9.918153e-01,9.912526e-01,9.906714e-01,9.900718e-01,9.894536e-01,9.888169e-01,9.881618e-01,9.874883e-01,9.867965e-01,9.860862e-01,9.853576e-01,9.846107e-01,9.838456e-01,9.830621e-01,9.822605e-01,9.814406e-01,9.806026e-01,9.797465e-01,9.788723e-01,9.779800e-01,9.770696e-01,9.761413e-01,9.751950e-01,9.742308e-01,9.732487e-01,9.722487e-01,9.712310e-01,9.701954e-01,9.691422e-01,9.680712e-01,9.669825e-01,9.658763e-01,9.647525e-01,9.636111e-01,9.624523e-01,9.612760e-01,9.600823e-01,9.588712e-01,9.576429e-01,9.563972e-01,9.551344e-01,9.538544e-01,9.525573e-01,9.512431e-01,9.499118e-01,9.485636e-01,9.471985e-01,9.458165e-01,9.444177e-01,9.430022e-01,9.415699e-01,9.401209e-01,9.386554e-01,9.371733e-01,9.356747e-01,9.341597e-01,9.326283e-01,9.310806e-01,9.295166e-01,9.279365e-01,9.263401e-01,9.247277e-01,9.230993e-01,9.214549e-01,9.197946e-01,9.181185e-01,9.164266e-01,9.147190e-01,9.129958e-01,9.112570e-01,9.095026e-01,9.077328e-01,9.059477e-01,9.041472e-01,9.023315e-01,9.005005e-01,8.986545e-01,8.967935e-01,8.949175e-01,8.930265e-01,8.911208e-01,8.892003e-01,8.872651e-01,8.853153e-01,8.833510e-01,8.813722e-01,8.793791e-01,8.773716e-01,8.753499e-01,8.733140e-01,8.712640e-01,8.692001e-01,8.671222e-01,8.650304e-01,8.629249e-01,8.608057e-01,8.586729e-01,8.565266e-01,8.543668e-01,8.521936e-01,8.500072e-01,8.478075e-01,8.455947e-01,8.433689e-01,8.411302e-01,8.388785e-01,8.366141e-01,8.343370e-01,8.320473e-01,8.297451e-01,8.274304e-01,8.251033e-01,8.227640e-01,8.204125e-01,8.180490e-01,8.156734e-01,8.132859e-01,8.108867e-01,8.084756e-01,8.060530e-01,8.036188e-01,8.011731e-01,7.987161e-01,7.962478e-01,7.937684e-01,7.912779e-01,7.887763e-01,7.862639e-01,7.837407e-01,7.812068e-01,7.786622e-01,7.761072e-01,7.735417e-01,7.709660e-01,7.683800e-01,7.657838e-01,7.631777e-01,7.605616e-01,7.579357e-01,7.553001e-01,7.526548e-01,7.500000e-01,7.473358e-01,7.446622e-01,7.419794e-01,7.392875e-01,7.365866e-01,7.338767e-01,7.311580e-01,7.284306e-01,7.256946e-01,7.229500e-01,7.201971e-01,7.174358e-01,7.146664e-01,7.118888e-01,7.091032e-01,7.063098e-01,7.035086e-01,7.006997e-01,6.978832e-01,6.950593e-01,6.922280e-01,6.893894e-01,6.865438e-01,6.836910e-01,6.808314e-01,6.779649e-01,6.750917e-01,6.722119e-01,6.693256e-01,6.664329e-01,6.635340e-01,6.606289e-01,6.577177e-01,6.548005e-01,6.518776e-01,6.489489e-01,6.460145e-01,6.430747e-01,6.401295e-01,6.371790e-01,6.342233e-01,6.312625e-01,6.282968e-01,6.253263e-01,6.223510e-01,6.193711e-01,6.163867e-01,6.133979e-01,6.104049e-01,6.074077e-01,6.044064e-01,6.014012e-01,5.983921e-01,5.953794e-01,5.923630e-01,5.893432e-01,5.863200e-01,5.832935e-01,5.802639e-01,5.772313e-01,5.741958e-01,5.711574e-01,5.681164e-01,5.650728e-01,5.620267e-01,5.589784e-01,5.559277e-01,5.528750e-01,5.498203e-01,5.467637e-01,5.437053e-01,5.406453e-01,5.375838e-01,5.345208e-01,5.314566e-01,5.283911e-01,5.253246e-01,5.222571e-01,5.191888e-01,5.161197e-01,5.130501e-01,5.099800e-01,5.069094e-01,5.038387e-01,5.007677e-01,4.976968e-01,4.946259e-01,4.915553e-01,4.884849e-01,4.854150e-01,4.823456e-01,4.792770e-01,4.762090e-01,4.731420e-01,4.700760e-01,4.670112e-01,4.639475e-01,4.608853e-01,4.578245e-01,4.547653e-01,4.517078e-01,4.486521e-01,4.455984e-01,4.425467e-01,4.394972e-01,4.364499e-01,4.334051e-01,4.303628e-01,4.273231e-01,4.242861e-01,4.212520e-01,4.182209e-01,4.151928e-01,4.121680e-01,4.091465e-01,4.061284e-01,4.031138e-01,4.001029e-01,3.970957e-01,3.940925e-01,3.910932e-01,3.880981e-01,3.851071e-01,3.821205e-01,3.791384e-01,3.761608e-01,3.731879e-01,3.702197e-01,3.672565e-01,3.642982e-01,3.613451e-01,3.583972e-01,3.554547e-01,3.525176e-01,3.495861e-01,3.466602e-01,3.437402e-01,3.408260e-01,3.379178e-01,3.350158e-01,3.321199e-01,3.292304e-01,3.263474e-01,3.234709e-01,3.206010e-01,3.177379e-01,3.148817e-01,3.120325e-01,3.091904e-01,3.063555e-01,3.035278e-01,3.007076e-01,2.978949e-01,2.950898e-01,2.922925e-01,2.895030e-01,2.867214e-01,2.839479e-01,2.811825e-01,2.784254e-01,2.756766e-01,2.729363e-01,2.702046e-01,2.674816e-01,2.647673e-01,2.620618e-01,2.593654e-01,2.566780e-01,2.539998e-01,2.513309e-01,2.486714e-01,2.460214e-01,2.433809e-01,2.407501e-01,2.381291e-01,2.355180e-01,2.329168e-01,2.303258e-01,2.277449e-01,2.251742e-01,2.226140e-01,2.200642e-01,2.175249e-01,2.149964e-01,2.124785e-01,2.099715e-01,2.074755e-01,2.049905e-01,2.025166e-01,2.000540e-01,1.976026e-01,1.951627e-01,1.927342e-01,1.903174e-01,1.879122e-01,1.855188e-01,1.831373e-01,1.807677e-01,1.784102e-01,1.760648e-01,1.737316e-01,1.714107e-01,1.691023e-01,1.668063e-01,1.645228e-01,1.622521e-01,1.599940e-01,1.577488e-01,1.555165e-01,1.532972e-01,1.510910e-01,1.488980e-01,1.467182e-01,1.445517e-01,1.423986e-01,1.402590e-01,1.381330e-01,1.360206e-01,1.339220e-01,1.318372e-01,1.297662e-01,1.277092e-01,1.256663e-01,1.236375e-01,1.216229e-01,1.196226e-01,1.176366e-01,1.156650e-01,1.137079e-01,1.117655e-01,1.098376e-01,1.079245e-01,1.060261e-01,1.041427e-01,1.022741e-01,1.004206e-01,9.858211e-02,9.675878e-02,9.495067e-02,9.315784e-02,9.138035e-02,8.961828e-02,8.787169e-02,8.614064e-02,8.442521e-02,8.272546e-02,8.104144e-02,7.937323e-02,7.772089e-02,7.608448e-02,7.446406e-02,7.285969e-02,7.127143e-02,6.969935e-02,6.814350e-02,6.660394e-02,6.508073e-02,6.357392e-02,6.208358e-02,6.060976e-02,5.915252e-02,5.771190e-02,5.628797e-02,5.488077e-02,5.349037e-02,5.211681e-02,5.076015e-02,4.942044e-02,4.809772e-02,4.679204e-02,4.550347e-02,4.423204e-02,4.297780e-02,4.174080e-02,4.052109e-02,3.931872e-02,3.813372e-02,3.696614e-02,3.581603e-02,3.468344e-02,3.356839e-02,3.247094e-02,3.139113e-02,3.032899e-02,2.928457e-02,2.825791e-02,2.724904e-02,2.625801e-02,2.528485e-02,2.432960e-02,2.339229e-02,2.247296e-02,2.157164e-02,2.068837e-02,1.982318e-02,1.897611e-02,1.814718e-02,1.733643e-02,1.654388e-02,1.576958e-02,1.501354e-02,1.427579e-02,1.355637e-02,1.285530e-02,1.217260e-02,1.150831e-02,1.086244e-02,1.023503e-02,9.626091e-03,9.035651e-03,8.463732e-03,7.910355e-03,7.375542e-03,6.859311e-03,6.361684e-03,5.882678e-03,5.422311e-03,4.980602e-03,4.557566e-03,4.153220e-03,3.767578e-03,3.400657e-03,3.052468e-03,2.723026e-03,2.412342e-03,2.120429e-03,1.847298e-03,1.592958e-03,1.357420e-03,1.140693e-03,9.427834e-04,7.637002e-04,6.034497e-04,4.620380e-04,3.394703e-04,2.357514e-04,1.508852e-04,8.487479e-05,3.772272e-05,9.430769e-06,0.000000e+00};

static Float hannwin_960[]  = {0.000000e+00,1.073151e-05,4.292559e-05,9.658086e-05,1.716950e-04,2.682648e-04,3.862861e-04,5.257539e-04,6.866621e-04,8.690039e-04,1.072771e-03,1.297956e-03,1.544548e-03,1.812536e-03,2.101910e-03,2.412656e-03,2.744762e-03,3.098214e-03,3.472995e-03,3.869090e-03,4.286482e-03,4.725153e-03,5.185085e-03,5.666256e-03,6.168648e-03,6.692238e-03,7.237003e-03,7.802921e-03,8.389967e-03,8.998116e-03,9.627342e-03,1.027762e-02,1.094891e-02,1.164120e-02,1.235446e-02,1.308864e-02,1.384373e-02,1.461969e-02,1.541648e-02,1.623407e-02,1.707243e-02,1.793152e-02,1.881130e-02,1.971174e-02,2.063280e-02,2.157443e-02,2.253660e-02,2.351926e-02,2.452238e-02,2.554591e-02,2.658981e-02,2.765402e-02,2.873852e-02,2.984324e-02,3.096814e-02,3.211318e-02,3.327830e-02,3.446346e-02,3.566860e-02,3.689367e-02,3.813862e-02,3.940340e-02,4.068795e-02,4.199222e-02,4.331614e-02,4.465967e-02,4.602275e-02,4.740531e-02,4.880730e-02,5.022866e-02,5.166933e-02,5.312924e-02,5.460833e-02,5.610655e-02,5.762381e-02,5.916007e-02,6.071525e-02,6.228929e-02,6.388211e-02,6.549366e-02,6.712386e-02,6.877264e-02,7.043993e-02,7.212566e-02,7.382976e-02,7.555215e-02,7.729276e-02,7.905152e-02,8.082834e-02,8.262316e-02,8.443590e-02,8.626647e-02,8.811480e-02,8.998082e-02,9.186443e-02,9.376557e-02,9.568414e-02,9.762007e-02,9.957327e-02,1.015437e-01,1.035312e-01,1.055357e-01,1.075571e-01,1.095954e-01,1.116505e-01,1.137222e-01,1.158105e-01,1.179153e-01,1.200365e-01,1.221740e-01,1.243277e-01,1.264975e-01,1.286834e-01,1.308853e-01,1.331029e-01,1.353363e-01,1.375854e-01,1.398500e-01,1.421301e-01,1.444256e-01,1.467363e-01,1.490622e-01,1.514031e-01,1.537590e-01,1.561298e-01,1.585153e-01,1.609155e-01,1.633302e-01,1.657594e-01,1.682030e-01,1.706607e-01,1.731327e-01,1.756186e-01,1.781185e-01,1.806322e-01,1.831596e-01,1.857006e-01,1.882551e-01,1.908230e-01,1.934041e-01,1.959984e-01,1.986058e-01,2.012261e-01,2.038592e-01,2.065051e-01,2.091635e-01,2.118344e-01,2.145177e-01,2.172132e-01,2.199209e-01,2.226406e-01,2.253722e-01,2.281156e-01,2.308707e-01,2.336373e-01,2.364154e-01,2.392048e-01,2.420053e-01,2.448170e-01,2.476396e-01,2.504730e-01,2.533171e-01,2.561719e-01,2.590370e-01,2.619126e-01,2.647983e-01,2.676942e-01,2.706000e-01,2.735157e-01,2.764411e-01,2.793761e-01,2.823205e-01,2.852744e-01,2.882374e-01,2.912095e-01,2.941906e-01,2.971805e-01,3.001791e-01,3.031863e-01,3.062019e-01,3.092259e-01,3.122581e-01,3.152983e-01,3.183464e-01,3.214023e-01,3.244659e-01,3.275371e-01,3.306156e-01,3.337014e-01,3.367944e-01,3.398944e-01,3.430012e-01,3.461147e-01,3.492349e-01,3.523616e-01,3.554946e-01,3.586337e-01,3.617790e-01,3.649302e-01,3.680872e-01,3.712498e-01,3.744180e-01,3.775916e-01,3.807704e-01,3.839543e-01,3.871432e-01,3.903370e-01,3.935355e-01,3.967385e-01,3.999460e-01,4.031578e-01,4.063737e-01,4.095936e-01,4.128175e-01,4.160450e-01,4.192762e-01,4.225109e-01,4.257488e-01,4.289900e-01,4.322342e-01,4.354813e-01,4.387312e-01,4.419837e-01,4.452387e-01,4.484960e-01,4.517556e-01,4.550172e-01,4.582808e-01,4.615461e-01,4.648131e-01,4.680816e-01,4.713515e-01,4.746226e-01,4.778949e-01,4.811680e-01,4.844420e-01,4.877166e-01,4.909917e-01,4.942673e-01,4.975431e-01,5.008190e-01,5.040948e-01,5.073705e-01,5.106459e-01,5.139208e-01,5.171951e-01,5.204687e-01,5.237414e-01,5.270131e-01,5.302836e-01,5.335528e-01,5.368206e-01,5.400868e-01,5.433512e-01,5.466139e-01,5.498745e-01,5.531329e-01,5.563891e-01,5.596429e-01,5.628941e-01,5.661426e-01,5.693883e-01,5.726310e-01,5.758706e-01,5.791069e-01,5.823398e-01,5.855692e-01,5.887949e-01,5.920168e-01,5.952348e-01,5.984486e-01,6.016583e-01,6.048636e-01,6.080643e-01,6.112605e-01,6.144518e-01,6.176383e-01,6.208197e-01,6.239959e-01,6.271668e-01,6.303322e-01,6.334920e-01,6.366461e-01,6.397944e-01,6.429366e-01,6.460727e-01,6.492026e-01,6.523260e-01,6.554429e-01,6.585531e-01,6.616565e-01,6.647530e-01,6.678424e-01,6.709246e-01,6.739994e-01,6.770668e-01,6.801266e-01,6.831786e-01,6.862228e-01,6.892590e-01,6.922871e-01,6.953069e-01,6.983184e-01,7.013213e-01,7.043156e-01,7.073011e-01,7.102777e-01,7.132453e-01,7.162037e-01,7.191529e-01,7.220926e-01,7.250228e-01,7.279434e-01,7.308541e-01,7.337550e-01,7.366458e-01,7.395265e-01,7.423969e-01,7.452568e-01,7.481063e-01,7.509451e-01,7.537731e-01,7.565902e-01,7.593964e-01,7.621913e-01,7.649751e-01,7.677474e-01,7.705083e-01,7.732575e-01,7.759951e-01,7.787207e-01,7.814344e-01,7.841361e-01,7.868255e-01,7.895026e-01,7.921673e-01,7.948194e-01,7.974589e-01,8.000857e-01,8.026995e-01,8.053004e-01,8.078881e-01,8.104626e-01,8.130238e-01,8.155716e-01,8.181058e-01,8.206264e-01,8.231332e-01,8.256261e-01,8.281051e-01,8.305699e-01,8.330206e-01,8.354570e-01,8.378790e-01,8.402864e-01,8.426793e-01,8.450575e-01,8.474208e-01,8.497693e-01,8.521027e-01,8.544210e-01,8.567241e-01,8.590119e-01,8.612842e-01,8.635411e-01,8.657823e-01,8.680079e-01,8.702176e-01,8.724115e-01,8.745894e-01,8.767512e-01,8.788968e-01,8.810262e-01,8.831392e-01,8.852357e-01,8.873158e-01,8.893792e-01,8.914258e-01,8.934557e-01,8.954687e-01,8.974647e-01,8.994437e-01,9.014055e-01,9.033501e-01,9.052773e-01,9.071872e-01,9.090796e-01,9.109544e-01,9.128116e-01,9.146510e-01,9.164727e-01,9.182765e-01,9.200623e-01,9.218301e-01,9.235798e-01,9.253113e-01,9.270246e-01,9.287195e-01,9.303960e-01,9.320541e-01,9.336936e-01,9.353144e-01,9.369166e-01,9.385001e-01,9.400647e-01,9.416104e-01,9.431372e-01,9.446449e-01,9.461336e-01,9.476031e-01,9.490534e-01,9.504844e-01,9.518961e-01,9.532884e-01,9.546612e-01,9.560145e-01,9.573483e-01,9.586624e-01,9.599568e-01,9.612315e-01,9.624863e-01,9.637214e-01,9.649365e-01,9.661316e-01,9.673068e-01,9.684619e-01,9.695968e-01,9.707116e-01,9.718063e-01,9.728806e-01,9.739347e-01,9.749684e-01,9.759817e-01,9.769746e-01,9.779470e-01,9.788990e-01,9.798303e-01,9.807411e-01,9.816312e-01,9.825006e-01,9.833493e-01,9.841773e-01,9.849845e-01,9.857709e-01,9.865364e-01,9.872811e-01,9.880048e-01,9.887076e-01,9.893894e-01,9.900501e-01,9.906899e-01,9.913086e-01,9.919062e-01,9.924827e-01,9.930380e-01,9.935722e-01,9.940852e-01,9.945770e-01,9.950475e-01,9.954968e-01,9.959249e-01,9.963316e-01,9.967171e-01,9.970812e-01,9.974240e-01,9.977454e-01,9.980454e-01,9.983241e-01,9.985814e-01,9.988173e-01,9.990318e-01,9.992248e-01,9.993965e-01,9.995467e-01,9.996754e-01,9.997827e-01,9.998685e-01,9.999329e-01,9.999759e-01,9.999973e-01,9.999973e-01,9.999759e-01,9.999329e-01,9.998685e-01,9.997827e-01,9.996754e-01,9.995467e-01,9.993965e-01,9.992248e-01,9.990318e-01,9.988173e-01,9.985814e-01,9.983241e-01,9.980454e-01,9.977454e-01,9.974240e-01,9.970812e-01,9.967171e-01,9.963316e-01,9.959249e-01,9.954968e-01,9.950475e-01,9.945770e-01,9.940852e-01,9.935722e-01,9.930380e-01,9.924827e-01,9.919062e-01,9.913086e-01,9.906899e-01,9.900501e-01,9.893894e-01,9.887076e-01,9.880048e-01,9.872811e-01,9.865364e-01,9.857709e-01,9.849845e-01,9.841773e-01,9.833493e-01,9.825006e-01,9.816312e-01,9.807411e-01,9.798303e-01,9.788990e-01,9.779470e-01,9.769746e-01,9.759817e-01,9.749684e-01,9.739347e-01,9.728806e-01,9.718063e-01,9.707116e-01,9.695968e-01,9.684619e-01,9.673068e-01,9.661316e-01,9.649365e-01,9.637214e-01,9.624863e-01,9.612315e-01,9.599568e-01,9.586624e-01,9.573483e-01,9.560145e-01,9.546612e-01,9.532884e-01,9.518961e-01,9.504844e-01,9.490534e-01,9.476031e-01,9.461336e-01,9.446449e-01,9.431372e-01,9.416104e-01,9.400647e-01,9.385001e-01,9.369166e-01,9.353144e-01,9.336936e-01,9.320541e-01,9.303960e-01,9.287195e-01,9.270246e-01,9.253113e-01,9.235798e-01,9.218301e-01,9.200623e-01,9.182765e-01,9.164727e-01,9.146510e-01,9.128116e-01,9.109544e-01,9.090796e-01,9.071872e-01,9.052773e-01,9.033501e-01,9.014055e-01,8.994437e-01,8.974647e-01,8.954687e-01,8.934557e-01,8.914258e-01,8.893792e-01,8.873158e-01,8.852357e-01,8.831392e-01,8.810262e-01,8.788968e-01,8.767512e-01,8.745894e-01,8.724115e-01,8.702176e-01,8.680079e-01,8.657823e-01,8.635411e-01,8.612842e-01,8.590119e-01,8.567241e-01,8.544210e-01,8.521027e-01,8.497693e-01,8.474208e-01,8.450575e-01,8.426793e-01,8.402864e-01,8.378790e-01,8.354570e-01,8.330206e-01,8.305699e-01,8.281051e-01,8.256261e-01,8.231332e-01,8.206264e-01,8.181058e-01,8.155716e-01,8.130238e-01,8.104626e-01,8.078881e-01,8.053004e-01,8.026995e-01,8.000857e-01,7.974589e-01,7.948194e-01,7.921673e-01,7.895026e-01,7.868255e-01,7.841361e-01,7.814344e-01,7.787207e-01,7.759951e-01,7.732575e-01,7.705083e-01,7.677474e-01,7.649751e-01,7.621913e-01,7.593964e-01,7.565902e-01,7.537731e-01,7.509451e-01,7.481063e-01,7.452568e-01,7.423969e-01,7.395265e-01,7.366458e-01,7.337550e-01,7.308541e-01,7.279434e-01,7.250228e-01,7.220926e-01,7.191529e-01,7.162037e-01,7.132453e-01,7.102777e-01,7.073011e-01,7.043156e-01,7.013213e-01,6.983184e-01,6.953069e-01,6.922871e-01,6.892590e-01,6.862228e-01,6.831786e-01,6.801266e-01,6.770668e-01,6.739994e-01,6.709246e-01,6.678424e-01,6.647530e-01,6.616565e-01,6.585531e-01,6.554429e-01,6.523260e-01,6.492026e-01,6.460727e-01,6.429366e-01,6.397944e-01,6.366461e-01,6.334920e-01,6.303322e-01,6.271668e-01,6.239959e-01,6.208197e-01,6.176383e-01,6.144518e-01,6.112605e-01,6.080643e-01,6.048636e-01,6.016583e-01,5.984486e-01,5.952348e-01,5.920168e-01,5.887949e-01,5.855692e-01,5.823398e-01,5.791069e-01,5.758706e-01,5.726310e-01,5.693883e-01,5.661426e-01,5.628941e-01,5.596429e-01,5.563891e-01,5.531329e-01,5.498745e-01,5.466139e-01,5.433512e-01,5.400868e-01,5.368206e-01,5.335528e-01,5.302836e-01,5.270131e-01,5.237414e-01,5.204687e-01,5.171951e-01,5.139208e-01,5.106459e-01,5.073705e-01,5.040948e-01,5.008190e-01,4.975431e-01,4.942673e-01,4.909917e-01,4.877166e-01,4.844420e-01,4.811680e-01,4.778949e-01,4.746226e-01,4.713515e-01,4.680816e-01,4.648131e-01,4.615461e-01,4.582808e-01,4.550172e-01,4.517556e-01,4.484960e-01,4.452387e-01,4.419837e-01,4.387312e-01,4.354813e-01,4.322342e-01,4.289900e-01,4.257488e-01,4.225109e-01,4.192762e-01,4.160450e-01,4.128175e-01,4.095936e-01,4.063737e-01,4.031578e-01,3.999460e-01,3.967385e-01,3.935355e-01,3.903370e-01,3.871432e-01,3.839543e-01,3.807704e-01,3.775916e-01,3.744180e-01,3.712498e-01,3.680872e-01,3.649302e-01,3.617790e-01,3.586337e-01,3.554946e-01,3.523616e-01,3.492349e-01,3.461147e-01,3.430012e-01,3.398944e-01,3.367944e-01,3.337014e-01,3.306156e-01,3.275371e-01,3.244659e-01,3.214023e-01,3.183464e-01,3.152983e-01,3.122581e-01,3.092259e-01,3.062019e-01,3.031863e-01,3.001791e-01,2.971805e-01,2.941906e-01,2.912095e-01,2.882374e-01,2.852744e-01,2.823205e-01,2.793761e-01,2.764411e-01,2.735157e-01,2.706000e-01,2.676942e-01,2.647983e-01,2.619126e-01,2.590370e-01,2.561719e-01,2.533171e-01,2.504730e-01,2.476396e-01,2.448170e-01,2.420053e-01,2.392048e-01,2.364154e-01,2.336373e-01,2.308707e-01,2.281156e-01,2.253722e-01,2.226406e-01,2.199209e-01,2.172132e-01,2.145177e-01,2.118344e-01,2.091635e-01,2.065051e-01,2.038592e-01,2.012261e-01,1.986058e-01,1.959984e-01,1.934041e-01,1.908230e-01,1.882551e-01,1.857006e-01,1.831596e-01,1.806322e-01,1.781185e-01,1.756186e-01,1.731327e-01,1.706607e-01,1.682030e-01,1.657594e-01,1.633302e-01,1.609155e-01,1.585153e-01,1.561298e-01,1.537590e-01,1.514031e-01,1.490622e-01,1.467363e-01,1.444256e-01,1.421301e-01,1.398500e-01,1.375854e-01,1.353363e-01,1.331029e-01,1.308853e-01,1.286834e-01,1.264975e-01,1.243277e-01,1.221740e-01,1.200365e-01,1.179153e-01,1.158105e-01,1.137222e-01,1.116505e-01,1.095954e-01,1.075571e-01,1.055357e-01,1.035312e-01,1.015437e-01,9.957327e-02,9.762007e-02,9.568414e-02,9.376557e-02,9.186443e-02,8.998082e-02,8.811480e-02,8.626647e-02,8.443590e-02,8.262316e-02,8.082834e-02,7.905152e-02,7.729276e-02,7.555215e-02,7.382976e-02,7.212566e-02,7.043993e-02,6.877264e-02,6.712386e-02,6.549366e-02,6.388211e-02,6.228929e-02,6.071525e-02,5.916007e-02,5.762381e-02,5.610655e-02,5.460833e-02,5.312924e-02,5.166933e-02,5.022866e-02,4.880730e-02,4.740531e-02,4.602275e-02,4.465967e-02,4.331614e-02,4.199222e-02,4.068795e-02,3.940340e-02,3.813862e-02,3.689367e-02,3.566860e-02,3.446346e-02,3.327830e-02,3.211318e-02,3.096814e-02,2.984324e-02,2.873852e-02,2.765402e-02,2.658981e-02,2.554591e-02,2.452238e-02,2.351926e-02,2.253660e-02,2.157443e-02,2.063280e-02,1.971174e-02,1.881130e-02,1.793152e-02,1.707243e-02,1.623407e-02,1.541648e-02,1.461969e-02,1.384373e-02,1.308864e-02,1.235446e-02,1.164120e-02,1.094891e-02,1.027762e-02,9.627342e-03,8.998116e-03,8.389967e-03,7.802921e-03,7.237003e-03,6.692238e-03,6.168648e-03,5.666256e-03,5.185085e-03,4.725153e-03,4.286482e-03,3.869090e-03,3.472995e-03,3.098214e-03,2.744762e-03,2.412656e-03,2.101910e-03,1.812536e-03,1.544548e-03,1.297956e-03,1.072771e-03,8.690039e-04,6.866621e-04,5.257539e-04,3.862861e-04,2.682648e-04,1.716950e-04,9.658086e-05,4.292559e-05,1.073151e-05,0.000000e+00};

static Float hannwin_256[]  = {0.000000e+00,1.517740e-04,6.070039e-04,1.365413e-03,2.426542e-03,3.789745e-03,5.454196e-03,7.418883e-03,9.682615e-03,1.224402e-02,1.510153e-02,1.825343e-02,2.169779e-02,2.543253e-02,2.945537e-02,3.376389e-02,3.835545e-02,4.322727e-02,4.837640e-02,5.379971e-02,5.949390e-02,6.545553e-02,7.168096e-02,7.816643e-02,8.490798e-02,9.190154e-02,9.914286e-02,1.066275e-01,1.143510e-01,1.223086e-01,1.304955e-01,1.389068e-01,1.475372e-01,1.563817e-01,1.654347e-01,1.746908e-01,1.841445e-01,1.937899e-01,2.036212e-01,2.136324e-01,2.238175e-01,2.341703e-01,2.446844e-01,2.553535e-01,2.661712e-01,2.771308e-01,2.882257e-01,2.994492e-01,3.107945e-01,3.222546e-01,3.338226e-01,3.454915e-01,3.572542e-01,3.691036e-01,3.810324e-01,3.930335e-01,4.050995e-01,4.172231e-01,4.293969e-01,4.416136e-01,4.538658e-01,4.661460e-01,4.784467e-01,4.907605e-01,5.030800e-01,5.153975e-01,5.277057e-01,5.399971e-01,5.522642e-01,5.644996e-01,5.766958e-01,5.888455e-01,6.009412e-01,6.129756e-01,6.249415e-01,6.368315e-01,6.486384e-01,6.603551e-01,6.719745e-01,6.834894e-01,6.948929e-01,7.061782e-01,7.173382e-01,7.283663e-01,7.392558e-01,7.500000e-01,7.605924e-01,7.710267e-01,7.812964e-01,7.913953e-01,8.013173e-01,8.110564e-01,8.206067e-01,8.299623e-01,8.391176e-01,8.480670e-01,8.568051e-01,8.653266e-01,8.736263e-01,8.816991e-01,8.895403e-01,8.971449e-01,9.045085e-01,9.116265e-01,9.184946e-01,9.251086e-01,9.314645e-01,9.375585e-01,9.433868e-01,9.489460e-01,9.542326e-01,9.592435e-01,9.639755e-01,9.684259e-01,9.725919e-01,9.764710e-01,9.800608e-01,9.833592e-01,9.863641e-01,9.890738e-01,9.914865e-01,9.936009e-01,9.954156e-01,9.969296e-01,9.981418e-01,9.990517e-01,9.996585e-01,9.999621e-01,9.999621e-01,9.996585e-01,9.990517e-01,9.981418e-01,9.969296e-01,9.954156e-01,9.936009e-01,9.914865e-01,9.890738e-01,9.863641e-01,9.833592e-01,9.800608e-01,9.764710e-01,9.725919e-01,9.684259e-01,9.639755e-01,9.592435e-01,9.542326e-01,9.489460e-01,9.433868e-01,9.375585e-01,9.314645e-01,9.251086e-01,9.184946e-01,9.116265e-01,9.045085e-01,8.971449e-01,8.895403e-01,8.816991e-01,8.736263e-01,8.653266e-01,8.568051e-01,8.480670e-01,8.391176e-01,8.299623e-01,8.206067e-01,8.110564e-01,8.013173e-01,7.913953e-01,7.812964e-01,7.710267e-01,7.605924e-01,7.500000e-01,7.392558e-01,7.283663e-01,7.173382e-01,7.061782e-01,6.948929e-01,6.834894e-01,6.719745e-01,6.603551e-01,6.486384e-01,6.368315e-01,6.249415e-01,6.129756e-01,6.009412e-01,5.888455e-01,5.766958e-01,5.644996e-01,5.522642e-01,5.399971e-01,5.277057e-01,5.153975e-01,5.030800e-01,4.907605e-01,4.784467e-01,4.661460e-01,4.538658e-01,4.416136e-01,4.293969e-01,4.172231e-01,4.050995e-01,3.930335e-01,3.810324e-01,3.691036e-01,3.572542e-01,3.454915e-01,3.338226e-01,3.222546e-01,3.107945e-01,2.994492e-01,2.882257e-01,2.771308e-01,2.661712e-01,2.553535e-01,2.446844e-01,2.341703e-01,2.238175e-01,2.136324e-01,2.036212e-01,1.937899e-01,1.841445e-01,1.746908e-01,1.654347e-01,1.563817e-01,1.475372e-01,1.389068e-01,1.304955e-01,1.223086e-01,1.143510e-01,1.066275e-01,9.914286e-02,9.190154e-02,8.490798e-02,7.816643e-02,7.168096e-02,6.545553e-02,5.949390e-02,5.379971e-02,4.837640e-02,4.322727e-02,3.835545e-02,3.376389e-02,2.945537e-02,2.543253e-02,2.169779e-02,1.825343e-02,1.510153e-02,1.224402e-02,9.682615e-03,7.418883e-03,5.454196e-03,3.789745e-03,2.426542e-03,1.365413e-03,6.070039e-04,1.517740e-04,0.000000e+00};

static Float hannwin_240[]  = {0.000000e+00,1.727742e-04,6.909775e-04,1.554252e-03,2.762000e-03,4.313388e-03,6.207344e-03,8.442558e-03,1.101749e-02,1.393035e-02,1.717913e-02,2.076159e-02,2.467525e-02,2.891740e-02,3.348512e-02,3.837525e-02,4.358440e-02,4.910898e-02,5.494517e-02,6.108894e-02,6.753603e-02,7.428200e-02,8.132219e-02,8.865172e-02,9.626553e-02,1.041584e-01,1.123248e-01,1.207591e-01,1.294555e-01,1.384080e-01,1.476104e-01,1.570563e-01,1.667392e-01,1.766525e-01,1.867892e-01,1.971423e-01,2.077048e-01,2.184693e-01,2.294283e-01,2.405744e-01,2.518997e-01,2.633965e-01,2.750568e-01,2.868725e-01,2.988356e-01,3.109376e-01,3.231704e-01,3.355253e-01,3.479939e-01,3.605676e-01,3.732376e-01,3.859952e-01,3.988316e-01,4.117379e-01,4.247053e-01,4.377246e-01,4.507870e-01,4.638834e-01,4.770048e-01,4.901421e-01,5.032862e-01,5.164280e-01,5.295584e-01,5.426684e-01,5.557490e-01,5.687910e-01,5.817855e-01,5.947234e-01,6.075959e-01,6.203940e-01,6.331089e-01,6.457319e-01,6.582541e-01,6.706669e-01,6.829618e-01,6.951303e-01,7.071639e-01,7.190543e-01,7.307933e-01,7.423729e-01,7.537849e-01,7.650216e-01,7.760751e-01,7.869377e-01,7.976021e-01,8.080609e-01,8.183067e-01,8.283325e-01,8.381315e-01,8.476967e-01,8.570217e-01,8.660999e-01,8.749251e-01,8.834912e-01,8.917923e-01,8.998226e-01,9.075766e-01,9.150489e-01,9.222344e-01,9.291281e-01,9.357252e-01,9.420211e-01,9.480116e-01,9.536925e-01,9.590598e-01,9.641099e-01,9.688392e-01,9.732446e-01,9.773228e-01,9.810712e-01,9.844871e-01,9.875682e-01,9.903123e-01,9.927176e-01,9.947824e-01,9.965052e-01,9.978849e-01,9.989205e-01,9.996113e-01,9.999568e-01,9.999568e-01,9.996113e-01,9.989205e-01,9.978849e-01,9.965052e-01,9.947824e-01,9.927176e-01,9.903123e-01,9.875682e-01,9.844871e-01,9.810712e-01,9.773228e-01,9.732446e-01,9.688392e-01,9.641099e-01,9.590598e-01,9.536925e-01,9.480116e-01,9.420211e-01,9.357252e-01,9.291281e-01,9.222344e-01,9.150489e-01,9.075766e-01,8.998226e-01,8.917923e-01,8.834912e-01,8.749251e-01,8.660999e-01,8.570217e-01,8.476967e-01,8.381315e-01,8.283325e-01,8.183067e-01,8.080609e-01,7.976021e-01,7.869377e-01,7.760751e-01,7.650216e-01,7.537849e-01,7.423729e-01,7.307933e-01,7.190543e-01,7.071639e-01,6.951303e-01,6.829618e-01,6.706669e-01,6.582541e-01,6.457319e-01,6.331089e-01,6.203940e-01,6.075959e-01,5.947234e-01,5.817855e-01,5.687910e-01,5.557490e-01,5.426684e-01,5.295584e-01,5.164280e-01,5.032862e-01,4.901421e-01,4.770048e-01,4.638834e-01,4.507870e-01,4.377246e-01,4.247053e-01,4.117379e-01,3.988316e-01,3.859952e-01,3.732376e-01,3.605676e-01,3.479939e-01,3.355253e-01,3.231704e-01,3.109376e-01,2.988356e-01,2.868725e-01,2.750568e-01,2.633965e-01,2.518997e-01,2.405744e-01,2.294283e-01,2.184693e-01,2.077048e-01,1.971423e-01,1.867892e-01,1.766525e-01,1.667392e-01,1.570563e-01,1.476104e-01,1.384080e-01,1.294555e-01,1.207591e-01,1.123248e-01,1.041584e-01,9.626553e-02,8.865172e-02,8.132219e-02,7.428200e-02,6.753603e-02,6.108894e-02,5.494517e-02,4.910898e-02,4.358440e-02,3.837525e-02,3.348512e-02,2.891740e-02,2.467525e-02,2.076159e-02,1.717913e-02,1.393035e-02,1.101749e-02,8.442558e-03,6.207344e-03,4.313388e-03,2.762000e-03,1.554252e-03,6.909775e-04,1.727742e-04,0.000000e+00};






/*******************************************************************/


#endif /*TABLES_H_*/
