/*******************************************************************************
 This software module was originally developed by
 
 Coding Technologies, Fraunhofer IIS, Philips
 
 and edited by
 
 -
 
 in the course of development of ISO/IEC 23003 for reference purposes and its
 performance may not have been optimized. This software module is an
 implementation of one or more tools as specified by ISO/IEC 23003. ISO/IEC gives
 You a royalty-free, worldwide, non-exclusive, copyright license to copy,
 distribute, and make derivative works of this software module or modifications
 thereof for use in implementations of ISO/IEC 23003 in products that satisfy
 conformance criteria (if any). Those intending to use this software module in
 products are advised that its use may infringe existing patents. ISO/IEC have no
 liability for use of this software module or modifications thereof. Copyright is
 not released for products that do not conform to audiovisual and image-coding
 related ITU Recommendations and/or ISO/IEC International Standards.
 
 Coding Technologies, Fraunhofer IIS, Philips retain full right to
 modify and use the code for its (their) own purpose, assign or donate the code
 to a third party and to inhibit third parties from using the code for products
 that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
 International Standards. This copyright notice must be included in all copies or
 derivative works.
 
 Copyright (c) ISO/IEC 2007.
 *******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "qmflib.h"
#include "qmflib_const.h"

const double QMFlib_PolyphaseFilterbankCoefficients[10*QMFLIB_MAX_NUM_QMF_BANDS] = {
  +0.00000000000000, -0.00027626432523, -0.00055252865047, -0.00055714895392, -0.00056176925738, -0.00052826053317, -0.00049475180896, -0.00049113730304,
  -0.00048752279712, -0.00048845096105, -0.00048937912498, -0.00049672527997, -0.00050407143497, -0.00051336393235, -0.00052265642972, -0.00053465649654,
  -0.00054665656337, -0.00055721840975, -0.00056778025613, -0.00057743665232, -0.00058709304852, -0.00060018389395, -0.00061327473938, -0.00062226204628,
  -0.00063124935319, -0.00064264134470, -0.00065403333621, -0.00066590120692, -0.00067776907764, -0.00068596527018, -0.00069416146273, -0.00070496755509,
  -0.00071577364744, -0.00072063897983, -0.00072550431222, -0.00073479924882, -0.00074409418541, -0.00074657699536, -0.00074905980532, -0.00075859849901,
  -0.00076813719270, -0.00077031102609, -0.00077248485949, -0.00077795904413, -0.00078343322877, -0.00078071008902, -0.00077798694927, -0.00077917671013,
  -0.00078036647100, -0.00078025571678, -0.00078014496257, -0.00077797134784, -0.00077579773310, -0.00076943854534, -0.00076307935757, -0.00075803974979,
  -0.00075300014201, -0.00074246792863, -0.00073193571525, -0.00072673745701, -0.00072153919876, -0.00070666647624, -0.00069179375372, -0.00067841763133,
  -0.00066504150893, -0.00064960049959, -0.00063415949025, -0.00061438569177, -0.00059461189330, -0.00057553476618, -0.00055645763906, -0.00053550743007,
  -0.00051455722108, -0.00048759488456, -0.00046063254803, -0.00043507234662, -0.00040951214522, -0.00037981486639, -0.00035011758756, -0.00031990785252,
  -0.00028969811748, -0.00024976592594, -0.00020983373440, -0.00017723591395, -0.00014463809349, -0.00010318576711, -0.00006173344072, -0.00002411923327,
  +0.00001349497418, +0.00006146664346, +0.00010943831274, +0.00015687000981, +0.00020430170688, +0.00024962740864, +0.00029495311041, +0.00034880356600,
  +0.00040265402160, +0.00045669643556, +0.00051073884952, +0.00056733823171, +0.00062393761391, +0.00068487010128, +0.00074580258865, +0.00080332346064,
  +0.00086084433262, +0.00092472158139, +0.00098859883015, +0.00105680717161, +0.00112501551307, +0.00119140198891, +0.00125778846475, +0.00132401897373,
  +0.00139024948272, +0.00146728573371, +0.00154432198471, +0.00161556515501, +0.00168680832531, +0.00176081743377, +0.00183482654224, +0.00190947030797,
  +0.00198411407369, +0.00206513621463, +0.00214615835557, +0.00222394191652, +0.00230172547746, +0.00238214358436, +0.00246256169126, +0.00254136878014,
  +0.00262017586902, +0.00270361115184, +0.00278704643465, +0.00286699560315, +0.00294694477165, +0.00302974341845, +0.00311254206525, +0.00319325170686,
  +0.00327396134847, +0.00335792438338, +0.00344188741828, +0.00352135711530, +0.00360082681231, +0.00368060955168, +0.00376039229104, +0.00384056776403,
  +0.00392074323703, +0.00400135927819, +0.00408197531935, +0.00415420112103, +0.00422642692270, +0.00429974944525, +0.00437307196781, +0.00444702862303,
  +0.00452098527825, +0.00459081566972, +0.00466064606118, +0.00472695107308, +0.00479325608498, +0.00485350822121, +0.00491376035745, +0.00497653130879,
  +0.00503930226013, +0.00509001882522, +0.00514073539032, +0.00519342600178, +0.00524611661324, +0.00529664236653, +0.00534716811982, +0.00538342285644,
  +0.00541967759307, +0.00545364080407, +0.00548760401507, +0.00551758773298, +0.00554757145088, +0.00557068687567, +0.00559380230045, +0.00560793331071,
  +0.00562206432097, +0.00563379200631, +0.00564551969164, +0.00564221982158, +0.00563891995151, +0.00563276568542, +0.00562661141932, +0.00560916214281,
  +0.00559171286630, +0.00556607463015, +0.00554043639400, +0.00550790735085, +0.00547537830770, +0.00542963794870, +0.00538389758970, +0.00532773673121,
  +0.00527157587272, +0.00520490170893, +0.00513822754514, +0.00506109816072, +0.00498396877629, +0.00489745784115, +0.00481094690600, +0.00470744996035,
  +0.00460395301471, +0.00449206959459, +0.00438018617447, +0.00425267520359, +0.00412516423270, +0.00398540252258, +0.00384564081246, +0.00369288273376,
  +0.00354012465507, +0.00337465661803, +0.00320918858098, +0.00302693218361, +0.00284467578623, +0.00264776489472, +0.00245085400321, +0.00223913581086,
  +0.00202741761850, +0.00180294293809, +0.00157846825768, +0.00133435058140, +0.00109023290512, +0.00083672966496, +0.00058322642480, +0.00030541547193,
  +0.00002760451905, -0.00025941178380, -0.00054642808664, -0.00085162081945, -0.00115681355227, -0.00148038040560, -0.00180394725893, -0.00214330981171,
  -0.00248267236449, -0.00283802510174, -0.00319337783900, -0.00356674512211, -0.00394011240522, -0.00433118601461, -0.00472225962400, -0.00512799036744,
  -0.00553372111088, -0.00595647521887, -0.00637922932685, -0.00682040550601, -0.00726158168517, -0.00772070251122, -0.00817982333726, -0.00865617814906,
  -0.00913253296085, -0.00962377725536, -0.01011502154986, -0.01062328817654, -0.01113155480321, -0.01165827719915, -0.01218499959508, -0.01272841079930,
  +0.01327182200351, +0.01383114430572, +0.01439046660792, +0.01496551097108, +0.01554055533423, +0.01613651331706, +0.01673247129989, +0.01733790471716,
  +0.01794333813443, +0.01856529063571, +0.01918724313698, +0.01982021123626, +0.02045317933555, +0.02109996718045, +0.02174675502535, +0.02240738597699,
  +0.02306801692862, +0.02374205806574, +0.02441609920285, +0.02510184197876, +0.02578758475467, +0.02648676385898, +0.02718594296329, +0.02789658016357,
  +0.02860721736385, +0.02932874155332, +0.03005026574279, +0.03077601330834, +0.03150176087389, +0.03223858448863, +0.03297540810337, +0.03371875149011,
  +0.03446209487686, +0.03521592546614, +0.03596975605542, +0.03672552054897, +0.03748128504252, +0.03824332649498, +0.03900536794745, +0.03977014250164,
  +0.04053491705584, +0.04129991325976, +0.04206490946367, +0.04283733183836, +0.04360975421304, +0.04437929738859, +0.04514884056413, +0.04591657164528,
  +0.04668430272642, +0.04745043736657, +0.04821657200672, +0.04897757378343, +0.04973857556014, +0.05049709555615, +0.05125561555216, +0.05200934510212,
  +0.05276307465207, +0.05350417574398, +0.05424527683589, +0.05498132082863, +0.05571736482138, +0.05643950491718, +0.05716164501299, +0.05787660668779,
  +0.05859156836260, +0.05928765819011, +0.05998374801761, +0.06066463259484, +0.06134551717207, +0.06201564899189, +0.06268578081172, +0.06332868530926,
  +0.06397158980681, +0.06459815022531, +0.06522471064380, +0.06583073093242, +0.06643675122104, +0.06702217486666, +0.06760759851228, +0.06815599067370,
  +0.06870438283512, +0.06923370365320, +0.06976302447127, +0.07026294777196, +0.07076287107266, +0.07123156919184, +0.07170026731102, +0.07213426282092,
  +0.07256825833083, +0.07296514191943, +0.07336202550803, +0.07373119487572, +0.07410036424342, +0.07442281002768, +0.07474525581194, +0.07502949471607,
  +0.07531373362019, +0.07555728474301, +0.07580083586584, +0.07600004189990, +0.07619924793396, +0.07634923248757, +0.07649921704119, +0.07660428304182,
  +0.07670934904245, +0.07676337330604, +0.07681739756964, +0.07682019935444, +0.07682300113923, +0.07677174677835, +0.07672049241746, +0.07661278212470,
  +0.07650507183194, +0.07633995200865, +0.07617483218536, +0.07595270391799, +0.07573057565061, +0.07544410058966, +0.07515762552870, +0.07481203250217,
  +0.07446643947564, +0.07405352002592, +0.07364060057620, +0.07315903242460, +0.07267746427299, +0.07213005037601, +0.07158263647903, +0.07096797191498,
  +0.07035330735093, +0.06965985433522, +0.06896640131951, +0.06820945173559, +0.06745250215166, +0.06661078450837, +0.06576906686508, +0.06485677373071,
  +0.06394448059633, +0.06295237925010, +0.06196027790387, +0.06088846749238, +0.05981665708090, +0.05866596313978, +0.05751526919867, +0.05628063631438,
  +0.05504600343009, +0.05372769280188, +0.05240938217366, +0.05100362490406, +0.04959786763445, +0.04811409907573, +0.04663033051701, +0.04505360436830,
  +0.04347687821958, +0.04181135303042, +0.04014582784127, +0.03839381976130, +0.03664181168133, +0.03480010237412, +0.03295839306691, +0.03102039683408,
  +0.02908240060125, +0.02705657839517, +0.02503075618909, +0.02291523173766, +0.02079970728622, +0.01858491655425, +0.01637012582228, +0.01406625455043,
  +0.01176238327857, +0.00936303474737, +0.00696368621617, +0.00447012318060, +0.00197656014503, -0.00061606476900, -0.00320868968304, -0.00588993229835,
  -0.00857117491366, -0.01135002882462, -0.01412888273558, -0.01700614783065, -0.01988341292573, -0.02285307090319, -0.02582272888064, -0.02888792816698,
  -0.03195312745332, -0.03511539233077, -0.03827765720822, -0.04152916968339, -0.04478068215856, -0.04813054991895, -0.05148041767934, -0.05492547518135,
  -0.05837053268336, -0.06190575899848, -0.06544098531359, -0.06906765769744, -0.07269433008129, -0.07641581176204, -0.08013729344279, -0.08394602354936,
  -0.08775475365593, -0.09165404447254, -0.09555333528914, -0.09954314420189, -0.10353295311463, -0.10760782314597, -0.11168269317730, -0.11584524582265,
  -0.12000779846800, -0.12425404175339, -0.12850028503878, -0.13282773057906, -0.13715517611934, -0.14156591261902, -0.14597664911870, -0.15046867811238,
  -0.15496070710605, -0.15952829633637, -0.16409588556669, -0.16873835139187, -0.17338081721706, -0.17809903603424, -0.18281725485142, -0.18760696471205,
  -0.19239667457267, -0.19726084612685, -0.20212501768103, -0.20704930153079, -0.21197358538056, -0.21696942751102, -0.22196526964149, -0.22701717835470,
  -0.23206908706791, -0.23718538776383, -0.24230168845974, -0.24747485970848, -0.25264803095722, -0.25787668045162, -0.26310532994603, -0.26838436700114,
  -0.27366340405625, -0.27899241148355, -0.28432141891085, -0.28969654530865, -0.29507167170646, -0.30049076461281, -0.30590985751916, -0.31136887444186,
  -0.31682789136456, -0.32231963204281, -0.32781137272105, -0.33334182105385, -0.33887226938665, -0.34443184083987, -0.34999141229310, -0.35557520130332,
  +0.36115899031355, +0.36676927247208, +0.37237955463061, +0.37800727801052, +0.38363500139043, +0.38927808877359, +0.39492117615675, +0.40057647191650,
  +0.40623176767625, +0.41190072868017, +0.41756968968409, +0.42324084087891, +0.42891199207373, +0.43458368375519, +0.44025537543665, +0.44592751450245,
  +0.45159965356824, +0.45726523104791, +0.46293080852757, +0.46858806499436, +0.47424532146115, +0.47988531528607, +0.48552530911099, +0.49114806728403,
  +0.49677082545707, +0.50237628773070, +0.50798175000434, +0.51355262351413, +0.51912349702391, +0.52467379329623, +0.53022408956855, +0.53573971722089,
  +0.54125534487322, +0.54673023536192, +0.55220512585061, +0.55764201993216, +0.56307891401370, +0.56846566359147, +0.57385241316923, +0.57919636835801,
  +0.58454032354679, +0.58982631608587, +0.59511230862496, +0.60034533125838, +0.60557835389180, +0.61074467354735, +0.61591099320291, +0.62101763138173,
  +0.62612426956055, +0.63116114016670, +0.63619801077286, +0.64116249018373, +0.64612696959461, +0.65101429992066, +0.65590163024671, +0.66070780913149,
  +0.66551398801627, +0.67024015351670, +0.67496631901712, +0.67960082418155, +0.68423532934598, +0.68878178350815, +0.69332823767032, +0.69778355480286,
  +0.70223887193539, +0.70658995728317, +0.71094104263095, +0.71519365306328, +0.71944626349561, +0.72359557676278, +0.72774489002994, +0.73178303292882,
  +0.73582117582769, +0.73975198109629, +0.74368278636488, +0.74749826598863, +0.75131374561237, +0.75501091084740, +0.75870807608242, +0.76228778129591,
  +0.76586748650939, +0.76932278732133, +0.77277808813327, +0.77610342001772, +0.77942875190216, +0.78263203197068, +0.78583531203920, +0.78890444810172,
  +0.79197358416424, +0.79491011277062, +0.79784664137700, +0.80064760828102, +0.80344857518505, +0.80610903781498, +0.80876950044491, +0.81129431375354,
  +0.81381912706217, +0.81619836376342, +0.81857760046468, +0.82080979475938, +0.82304198905409, +0.82513476189384, +0.82722753473360, +0.82916569022440,
  +0.83110384571520, +0.83289879094961, +0.83469373618402, +0.83633273498633, +0.83797173378865, +0.83946293651793, +0.84095413924722, +0.84228898368363,
  +0.84362382812005, +0.84480283755106, +0.84598184698206, +0.84700671234485, +0.84803157770763, +0.84890604877515, +0.84978051984268, +0.85048883616805,
  +0.85119715249343, +0.85175092800745, +0.85230470352147, +0.85270339924582, +0.85310209497017, +0.85333707618062, +0.85357205739107, +0.85365530872522,
  +0.85373856005937, +0.85365530872522, +0.85357205739107, +0.85333707618062, +0.85310209497017, +0.85270339924582, +0.85230470352147, +0.85175092800745,
  +0.85119715249343, +0.85048883616805, +0.84978051984268, +0.84890604877515, +0.84803157770763, +0.84700671234485, +0.84598184698206, +0.84480283755106,
  +0.84362382812005, +0.84228898368363, +0.84095413924722, +0.83946293651793, +0.83797173378865, +0.83633273498633, +0.83469373618402, +0.83289879094961,
  +0.83110384571520, +0.82916569022440, +0.82722753473360, +0.82513476189384, +0.82304198905409, +0.82080979475938, +0.81857760046468, +0.81619836376342,
  +0.81381912706217, +0.81129431375354, +0.80876950044491, +0.80610903781498, +0.80344857518505, +0.80064760828102, +0.79784664137700, +0.79491011277062,
  +0.79197358416424, +0.78890444810172, +0.78583531203920, +0.78263203197068, +0.77942875190216, +0.77610342001772, +0.77277808813327, +0.76932278732133,
  +0.76586748650939, +0.76228778129591, +0.75870807608242, +0.75501091084740, +0.75131374561237, +0.74749826598863, +0.74368278636488, +0.73975198109629,
  +0.73582117582769, +0.73178303292882, +0.72774489002994, +0.72359557676278, +0.71944626349561, +0.71519365306328, +0.71094104263095, +0.70658995728317,
  +0.70223887193539, +0.69778355480286, +0.69332823767032, +0.68878178350815, +0.68423532934598, +0.67960082418155, +0.67496631901712, +0.67024015351670,
  +0.66551398801627, +0.66070780913149, +0.65590163024671, +0.65101429992066, +0.64612696959461, +0.64116249018373, +0.63619801077286, +0.63116114016670,
  +0.62612426956055, +0.62101763138173, +0.61591099320291, +0.61074467354735, +0.60557835389180, +0.60034533125838, +0.59511230862496, +0.58982631608587,
  +0.58454032354679, +0.57919636835801, +0.57385241316923, +0.56846566359147, +0.56307891401370, +0.55764201993216, +0.55220512585061, +0.54673023536192,
  +0.54125534487322, +0.53573971722089, +0.53022408956855, +0.52467379329623, +0.51912349702391, +0.51355262351413, +0.50798175000434, +0.50237628773070,
  +0.49677082545707, +0.49114806728403, +0.48552530911099, +0.47988531528607, +0.47424532146115, +0.46858806499436, +0.46293080852757, +0.45726523104791,
  +0.45159965356824, +0.44592751450245, +0.44025537543665, +0.43458368375519, +0.42891199207373, +0.42324084087891, +0.41756968968409, +0.41190072868017,
  +0.40623176767625, +0.40057647191650, +0.39492117615675, +0.38927808877359, +0.38363500139043, +0.37800727801052, +0.37237955463061, +0.36676927247208,
  -0.36115899031355, -0.35557520130332, -0.34999141229310, -0.34443184083987, -0.33887226938665, -0.33334182105385, -0.32781137272105, -0.32231963204281,
  -0.31682789136456, -0.31136887444186, -0.30590985751916, -0.30049076461281, -0.29507167170646, -0.28969654530865, -0.28432141891085, -0.27899241148355,
  -0.27366340405625, -0.26838436700114, -0.26310532994603, -0.25787668045162, -0.25264803095722, -0.24747485970848, -0.24230168845974, -0.23718538776383,
  -0.23206908706791, -0.22701717835470, -0.22196526964149, -0.21696942751102, -0.21197358538056, -0.20704930153079, -0.20212501768103, -0.19726084612685,
  -0.19239667457267, -0.18760696471205, -0.18281725485142, -0.17809903603424, -0.17338081721706, -0.16873835139187, -0.16409588556669, -0.15952829633637,
  -0.15496070710605, -0.15046867811238, -0.14597664911870, -0.14156591261902, -0.13715517611934, -0.13282773057906, -0.12850028503878, -0.12425404175339,
  -0.12000779846800, -0.11584524582265, -0.11168269317730, -0.10760782314597, -0.10353295311463, -0.09954314420189, -0.09555333528914, -0.09165404447254,
  -0.08775475365593, -0.08394602354936, -0.08013729344279, -0.07641581176204, -0.07269433008129, -0.06906765769744, -0.06544098531359, -0.06190575899848,
  -0.05837053268336, -0.05492547518135, -0.05148041767934, -0.04813054991895, -0.04478068215856, -0.04152916968339, -0.03827765720822, -0.03511539233077,
  -0.03195312745332, -0.02888792816698, -0.02582272888064, -0.02285307090319, -0.01988341292573, -0.01700614783065, -0.01412888273558, -0.01135002882462,
  -0.00857117491366, -0.00588993229835, -0.00320868968304, -0.00061606476900, +0.00197656014503, +0.00447012318060, +0.00696368621617, +0.00936303474737,
  +0.01176238327857, +0.01406625455043, +0.01637012582228, +0.01858491655425, +0.02079970728622, +0.02291523173766, +0.02503075618909, +0.02705657839517,
  +0.02908240060125, +0.03102039683408, +0.03295839306691, +0.03480010237412, +0.03664181168133, +0.03839381976130, +0.04014582784127, +0.04181135303042,
  +0.04347687821958, +0.04505360436830, +0.04663033051701, +0.04811409907573, +0.04959786763445, +0.05100362490406, +0.05240938217366, +0.05372769280188,
  +0.05504600343009, +0.05628063631438, +0.05751526919867, +0.05866596313978, +0.05981665708090, +0.06088846749238, +0.06196027790387, +0.06295237925010,
  +0.06394448059633, +0.06485677373071, +0.06576906686508, +0.06661078450837, +0.06745250215166, +0.06820945173559, +0.06896640131951, +0.06965985433522,
  +0.07035330735093, +0.07096797191498, +0.07158263647903, +0.07213005037601, +0.07267746427299, +0.07315903242460, +0.07364060057620, +0.07405352002592,
  +0.07446643947564, +0.07481203250217, +0.07515762552870, +0.07544410058966, +0.07573057565061, +0.07595270391799, +0.07617483218536, +0.07633995200865,
  +0.07650507183194, +0.07661278212470, +0.07672049241746, +0.07677174677835, +0.07682300113923, +0.07682019935444, +0.07681739756964, +0.07676337330604,
  +0.07670934904245, +0.07660428304182, +0.07649921704119, +0.07634923248757, +0.07619924793396, +0.07600004189990, +0.07580083586584, +0.07555728474301,
  +0.07531373362019, +0.07502949471607, +0.07474525581194, +0.07442281002768, +0.07410036424342, +0.07373119487572, +0.07336202550803, +0.07296514191943,
  +0.07256825833083, +0.07213426282092, +0.07170026731102, +0.07123156919184, +0.07076287107266, +0.07026294777196, +0.06976302447127, +0.06923370365320,
  +0.06870438283512, +0.06815599067370, +0.06760759851228, +0.06702217486666, +0.06643675122104, +0.06583073093242, +0.06522471064380, +0.06459815022531,
  +0.06397158980681, +0.06332868530926, +0.06268578081172, +0.06201564899189, +0.06134551717207, +0.06066463259484, +0.05998374801761, +0.05928765819011,
  +0.05859156836260, +0.05787660668779, +0.05716164501299, +0.05643950491718, +0.05571736482138, +0.05498132082863, +0.05424527683589, +0.05350417574398,
  +0.05276307465207, +0.05200934510212, +0.05125561555216, +0.05049709555615, +0.04973857556014, +0.04897757378343, +0.04821657200672, +0.04745043736657,
  +0.04668430272642, +0.04591657164528, +0.04514884056413, +0.04437929738859, +0.04360975421304, +0.04283733183836, +0.04206490946367, +0.04129991325976,
  +0.04053491705584, +0.03977014250164, +0.03900536794745, +0.03824332649498, +0.03748128504252, +0.03672552054897, +0.03596975605542, +0.03521592546614,
  +0.03446209487686, +0.03371875149011, +0.03297540810337, +0.03223858448863, +0.03150176087389, +0.03077601330834, +0.03005026574279, +0.02932874155332,
  +0.02860721736385, +0.02789658016357, +0.02718594296329, +0.02648676385898, +0.02578758475467, +0.02510184197876, +0.02441609920285, +0.02374205806574,
  +0.02306801692862, +0.02240738597699, +0.02174675502535, +0.02109996718045, +0.02045317933555, +0.01982021123626, +0.01918724313698, +0.01856529063571,
  +0.01794333813443, +0.01733790471716, +0.01673247129989, +0.01613651331706, +0.01554055533423, +0.01496551097108, +0.01439046660792, +0.01383114430572,
  -0.01327182200351, -0.01272841079930, -0.01218499959508, -0.01165827719915, -0.01113155480321, -0.01062328817654, -0.01011502154986, -0.00962377725536,
  -0.00913253296085, -0.00865617814906, -0.00817982333726, -0.00772070251122, -0.00726158168517, -0.00682040550601, -0.00637922932685, -0.00595647521887,
  -0.00553372111088, -0.00512799036744, -0.00472225962400, -0.00433118601461, -0.00394011240522, -0.00356674512211, -0.00319337783900, -0.00283802510174,
  -0.00248267236449, -0.00214330981171, -0.00180394725893, -0.00148038040560, -0.00115681355227, -0.00085162081945, -0.00054642808664, -0.00025941178380,
  +0.00002760451905, +0.00030541547193, +0.00058322642480, +0.00083672966496, +0.00109023290512, +0.00133435058140, +0.00157846825768, +0.00180294293809,
  +0.00202741761850, +0.00223913581086, +0.00245085400321, +0.00264776489472, +0.00284467578623, +0.00302693218361, +0.00320918858098, +0.00337465661803,
  +0.00354012465507, +0.00369288273376, +0.00384564081246, +0.00398540252258, +0.00412516423270, +0.00425267520359, +0.00438018617447, +0.00449206959459,
  +0.00460395301471, +0.00470744996035, +0.00481094690600, +0.00489745784115, +0.00498396877629, +0.00506109816072, +0.00513822754514, +0.00520490170893,
  +0.00527157587272, +0.00532773673121, +0.00538389758970, +0.00542963794870, +0.00547537830770, +0.00550790735085, +0.00554043639400, +0.00556607463015,
  +0.00559171286630, +0.00560916214281, +0.00562661141932, +0.00563276568542, +0.00563891995151, +0.00564221982158, +0.00564551969164, +0.00563379200631,
  +0.00562206432097, +0.00560793331071, +0.00559380230045, +0.00557068687567, +0.00554757145088, +0.00551758773298, +0.00548760401507, +0.00545364080407,
  +0.00541967759307, +0.00538342285644, +0.00534716811982, +0.00529664236653, +0.00524611661324, +0.00519342600178, +0.00514073539032, +0.00509001882522,
  +0.00503930226013, +0.00497653130879, +0.00491376035745, +0.00485350822121, +0.00479325608498, +0.00472695107308, +0.00466064606118, +0.00459081566972,
  +0.00452098527825, +0.00444702862303, +0.00437307196781, +0.00429974944525, +0.00422642692270, +0.00415420112103, +0.00408197531935, +0.00400135927819,
  +0.00392074323703, +0.00384056776403, +0.00376039229104, +0.00368060955168, +0.00360082681231, +0.00352135711530, +0.00344188741828, +0.00335792438338,
  +0.00327396134847, +0.00319325170686, +0.00311254206525, +0.00302974341845, +0.00294694477165, +0.00286699560315, +0.00278704643465, +0.00270361115184,
  +0.00262017586902, +0.00254136878014, +0.00246256169126, +0.00238214358436, +0.00230172547746, +0.00222394191652, +0.00214615835557, +0.00206513621463,
  +0.00198411407369, +0.00190947030797, +0.00183482654224, +0.00176081743377, +0.00168680832531, +0.00161556515501, +0.00154432198471, +0.00146728573371,
  +0.00139024948272, +0.00132401897373, +0.00125778846475, +0.00119140198891, +0.00112501551307, +0.00105680717161, +0.00098859883015, +0.00092472158139,
  +0.00086084433262, +0.00080332346064, +0.00074580258865, +0.00068487010128, +0.00062393761391, +0.00056733823171, +0.00051073884952, +0.00045669643556,
  +0.00040265402160, +0.00034880356600, +0.00029495311041, +0.00024962740864, +0.00020430170688, +0.00015687000981, +0.00010943831274, +0.00006146664346,
  +0.00001349497418, -0.00002411923327, -0.00006173344072, -0.00010318576711, -0.00014463809349, -0.00017723591395, -0.00020983373440, -0.00024976592594,
  -0.00028969811748, -0.00031990785252, -0.00035011758756, -0.00037981486639, -0.00040951214522, -0.00043507234662, -0.00046063254803, -0.00048759488456,
  -0.00051455722108, -0.00053550743007, -0.00055645763906, -0.00057553476618, -0.00059461189330, -0.00061438569177, -0.00063415949025, -0.00064960049959,
  -0.00066504150893, -0.00067841763133, -0.00069179375372, -0.00070666647624, -0.00072153919876, -0.00072673745701, -0.00073193571525, -0.00074246792863,
  -0.00075300014201, -0.00075803974979, -0.00076307935757, -0.00076943854534, -0.00077579773310, -0.00077797134784, -0.00078014496257, -0.00078025571678,
  -0.00078036647100, -0.00077917671013, -0.00077798694927, -0.00078071008902, -0.00078343322877, -0.00077795904413, -0.00077248485949, -0.00077031102609,
  -0.00076813719270, -0.00075859849901, -0.00074905980532, -0.00074657699536, -0.00074409418541, -0.00073479924882, -0.00072550431222, -0.00072063897983,
  -0.00071577364744, -0.00070496755509, -0.00069416146273, -0.00068596527018, -0.00067776907764, -0.00066590120692, -0.00065403333621, -0.00064264134470,
  -0.00063124935319, -0.00062226204628, -0.00061327473938, -0.00060018389395, -0.00058709304852, -0.00057743665232, -0.00056778025613, -0.00055721840975,
  -0.00054665656337, -0.00053465649654, -0.00052265642972, -0.00051336393235, -0.00050407143497, -0.00049672527997, -0.00048937912498, -0.00048845096105,
  -0.00048752279712, -0.00049113730304, -0.00049475180896, -0.00052826053317, -0.00056176925738, -0.00055714895392, -0.00055252865047, -0.00027626432523
};
const double QMFlib_PolyphaseLdFilterbankCoefficients[10*QMFLIB_MAX_NUM_QMF_BANDS] = {
 -7.949261006e-004f,	-1.232074328e-003f,	-1.601053943e-003f,	-1.980720409e-003f,
-2.397504954e-003f,	-2.838709204e-003f,	-3.314755401e-003f,	-3.825180949e-003f,
-4.365307414e-003f,	-4.937260936e-003f,	-5.537381515e-003f,	-6.164241938e-003f,
-6.816579194e-003f,	-7.490102146e-003f,	-8.183711451e-003f,	-8.894930051e-003f,
-9.620004582e-003f,	-1.035696814e-002f,	-1.110238617e-002f,	-1.185358556e-002f,
-1.260769257e-002f,	-1.336080675e-002f,	-1.411033177e-002f,	-1.485316243e-002f,
-1.558550942e-002f,	-1.630436835e-002f,	-1.700613959e-002f,	-1.768770556e-002f,
-1.834568069e-002f,	-1.897612496e-002f,	-1.957605813e-002f,	-2.014213322e-002f,
-2.067061749e-002f,	-2.115814832e-002f,	-2.160130855e-002f,	-2.199696217e-002f,
-2.234169111e-002f,	-2.263170795e-002f,	-2.286416556e-002f,	-2.303589449e-002f,
-2.314344724e-002f,	-2.318352524e-002f,	-2.315297728e-002f,	-2.304918235e-002f,
-2.286864521e-002f,	-2.260790764e-002f,	-2.226444264e-002f,	-2.183518668e-002f,
-2.131692018e-002f,	-2.070614963e-002f,	-1.999981322e-002f,	-1.919566223e-002f,
-1.828936159e-002f,	-1.727711874e-002f,	-1.615648495e-002f,	-1.492335807e-002f,
-1.357419760e-002f,	-1.210370330e-002f,	-1.050755165e-002f,	-8.785746152e-003f,
-6.927329556e-003f,	-4.929378451e-003f,	-2.800333941e-003f,	-4.685580750e-004f,
2.210315256e-003f,	5.183294908e-003f,	8.350964449e-003f,	1.166118536e-002f,
1.513166797e-002f,	1.877264877e-002f,	2.258899222e-002f,	2.659061475e-002f,
3.078087745e-002f,	3.516391225e-002f,	3.974674894e-002f,	4.453308211e-002f,
4.952626098e-002f,	5.473026728e-002f,	6.014835645e-002f,	6.578414516e-002f,
7.163950999e-002f,	7.771656495e-002f,	8.401794441e-002f,	9.054515924e-002f,
9.729889691e-002f,	1.042804039e-001f,	1.114900795e-001f,	1.189284255e-001f,
1.265947533e-001f,	1.344885599e-001f,	1.426090972e-001f,	1.509550308e-001f,
1.595243495e-001f,	1.683151599e-001f,	1.773250462e-001f,	1.865511419e-001f,
1.959902227e-001f,	2.056386276e-001f,	2.154925974e-001f,	2.255475565e-001f,
2.357989865e-001f,	2.462418809e-001f,	2.568709555e-001f,	2.676805359e-001f,
2.786645734e-001f,	2.898168394e-001f,	3.011307517e-001f,	3.125994749e-001f,
3.242157193e-001f,	3.359722797e-001f,	3.478614117e-001f,	3.598752336e-001f,
3.720056632e-001f,	3.842444358e-001f,	3.965831242e-001f,	4.090129567e-001f,
4.215250931e-001f,	4.341108982e-001f,	4.467608232e-001f,	4.594659377e-001f,
4.722166595e-001f,	4.850038204e-001f,	4.978178236e-001f,	5.106483456e-001f,
5.234865376e-001f,	5.363218471e-001f,	5.491440357e-001f,	5.619439924e-001f,
-5.746001351e-001f,	-5.872559277e-001f,	-5.998618924e-001f,	-6.123980151e-001f,
-6.248504862e-001f,	-6.372102969e-001f,	-6.494654464e-001f,	-6.616044278e-001f,
-6.736174464e-001f,	-6.854929931e-001f,	-6.972201619e-001f,	-7.087881676e-001f,
-7.201859882e-001f,	-7.314035334e-001f,	-7.424295079e-001f,	-7.532534422e-001f,
-7.638649113e-001f,	-7.742538112e-001f,	-7.844095212e-001f,	-7.943222348e-001f,
-8.039818519e-001f,	-8.133789940e-001f,	-8.225037152e-001f,	-8.313468549e-001f,
-8.398991601e-001f,	-8.481519811e-001f,	-8.560963550e-001f,	-8.637239864e-001f,
-8.710266607e-001f,	-8.779965198e-001f,	-8.846258145e-001f,	-8.909071891e-001f,
-8.968337036e-001f,	-9.023985431e-001f,	-9.075955881e-001f,	-9.124187297e-001f,
-9.168621400e-001f,	-9.209204531e-001f,	-9.245886140e-001f,	-9.278619263e-001f,
-9.307362243e-001f,	-9.332075223e-001f,	-9.352724511e-001f,	-9.369278288e-001f,
-9.381709879e-001f,	-9.389996917e-001f,	-9.394121231e-001f,	-9.394068064e-001f,
-9.389829175e-001f,	-9.381397977e-001f,	-9.368773370e-001f,	-9.351961242e-001f,
-9.330966719e-001f,	-9.305803205e-001f,	-9.276488081e-001f,	-9.243040559e-001f,
-9.205488097e-001f,	-9.163856478e-001f,	-9.118180055e-001f,	-9.068503558e-001f,
-9.014858673e-001f,	-8.957295449e-001f,	-8.895882559e-001f,	-8.830582442e-001f,
-8.761259906e-001f,	-8.688044202e-001f,	-8.611140377e-001f,	-8.530684189e-001f,
-8.446723286e-001f,	-8.359322523e-001f,	-8.268555006e-001f,	-8.174491261e-001f,
-8.077214933e-001f,	-7.976809998e-001f,	-7.873360272e-001f,	-7.766956605e-001f,
-7.657692341e-001f,	-7.545663749e-001f,	-7.430967641e-001f,	-7.313705249e-001f,
-7.193979757e-001f,	-7.071895815e-001f,	-6.947561323e-001f,	-6.821083135e-001f,
-6.692573320e-001f,	-6.562143182e-001f,	-6.429904539e-001f,	-6.295973685e-001f,
-6.160464555e-001f,	-6.023493419e-001f,	-5.885176369e-001f,	-5.745630487e-001f,
-5.604973281e-001f,	-5.463322649e-001f,	-5.320795533e-001f,	-5.177509558e-001f,
-5.033582842e-001f,	-4.889131974e-001f,	-4.744274511e-001f,	-4.599125196e-001f,
-4.453800290e-001f,	-4.308413091e-001f,	-4.163077444e-001f,	-4.017905892e-001f,
-3.873008819e-001f,	-3.728496915e-001f,	-3.584479879e-001f,	-3.441060828e-001f,
-3.298346837e-001f,	-3.156442070e-001f,	-3.015447422e-001f,	-2.875462384e-001f,
-2.736584402e-001f,	-2.598909820e-001f,	-2.462531686e-001f,	-2.327540108e-001f,
-2.194025591e-001f,	-2.062071989e-001f,	-1.931765200e-001f,	-1.803186074e-001f,
-1.676410590e-001f,	-1.551517472e-001f,	-1.428578337e-001f,	-1.307662173e-001f,
-1.188837988e-001f,	-1.072167301e-001f,	-9.577112136e-002f,	-8.455282024e-002f,
7.355793886e-002f,	6.280513609e-002f,	5.229589453e-002f,	4.203381031e-002f,
3.202301124e-002f,	2.226720137e-002f,	1.277000586e-002f,	3.534672953e-003f,
-5.435672411e-003f,	-1.413857082e-002f,	-2.257147752e-002f,	-3.073254830e-002f,
-3.861994968e-002f,	-4.623245159e-002f,	-5.356875686e-002f,	-6.062844792e-002f,
-6.741087925e-002f,	-7.391592258e-002f,	-8.014393008e-002f,	-8.609517876e-002f,
-9.177059647e-002f,	-9.717118786e-002f,	-1.022983899e-001f,	-1.071535873e-001f,
-1.117390940e-001f,	-1.160565564e-001f,	-1.201089958e-001f,	-1.238986105e-001f,
-1.274286534e-001f,	-1.307022038e-001f,	-1.337226599e-001f,	-1.364936502e-001f,
-1.390190837e-001f,	-1.413030335e-001f,	-1.433497699e-001f,	-1.451636222e-001f,
-1.467494079e-001f,	-1.481116975e-001f,	-1.492556249e-001f,	-1.501862836e-001f,
-1.509089024e-001f,	-1.514289034e-001f,	-1.517517580e-001f,	-1.518832057e-001f,
-1.518289202e-001f,	-1.515947694e-001f,	-1.511866739e-001f,	-1.506105955e-001f,
-1.498725981e-001f,	-1.489787144e-001f,	-1.479352186e-001f,	-1.467481852e-001f,
-1.454239120e-001f,	-1.439685961e-001f,	-1.423884130e-001f,	-1.406896927e-001f,
-1.388785954e-001f,	-1.369612022e-001f,	-1.349437727e-001f,	-1.328323917e-001f,
-1.306331212e-001f,	-1.283520432e-001f,	-1.259952254e-001f,	-1.235680808e-001f,
-1.210755702e-001f,	-1.185237142e-001f,	-1.159184451e-001f,	-1.132654367e-001f,
-1.105698782e-001f,	-1.078369136e-001f,	-1.050716119e-001f,	-1.022789199e-001f,
-9.946367410e-002f,	-9.663069107e-002f,	-9.378454803e-002f,	-9.092970207e-002f,
-8.807051084e-002f,	-8.521107267e-002f,	-8.235562753e-002f,	-7.950789958e-002f,
-7.667177990e-002f,	-7.385092587e-002f,	-7.104866703e-002f,	-6.826847016e-002f,
-6.551341011e-002f,	-6.278658930e-002f,	-6.009091369e-002f,	-5.742919825e-002f,
-5.480383115e-002f,	-5.221738079e-002f,	-4.967213639e-002f,	-4.717023345e-002f,
-4.471364025e-002f,	-4.230438144e-002f,	-3.994384829e-002f,	-3.763371362e-002f,
-3.537544042e-002f,	-3.317035188e-002f,	-3.101971216e-002f,	-2.892453070e-002f,
-2.688575425e-002f,	-2.490421725e-002f,	-2.298058501e-002f,	-2.111545692e-002f,
-1.930927680e-002f,	-1.756239270e-002f,	-1.587511450e-002f,	-1.424750749e-002f,
-1.267955528e-002f,	-1.117125833e-002f,	-9.722405441e-003f,	-8.332704661e-003f,
-7.001789873e-003f,	-5.729226041e-003f,	-4.514503360e-003f,	-3.356946762e-003f,
-2.255849987e-003f,	-1.210459262e-003f,	-2.199474641e-004f,	7.167268628e-004f,
1.600440186e-003f,	2.432366606e-003f,	3.213605482e-003f,	3.945301463e-003f,
4.628665379e-003f,	5.264976587e-003f,	5.855653555e-003f,	6.401634331e-003f,
-6.903046246e-003f,	-7.364537203e-003f,	-7.785917437e-003f,	-8.168780818e-003f,
-8.514510536e-003f,	-8.824526582e-003f,	-9.100444687e-003f,	-9.343819822e-003f,
-9.556089248e-003f,	-9.738929904e-003f,	-9.893728066e-003f,	-1.002221842e-002f,
-1.012567517e-002f,	-1.020575952e-002f,	-1.026389876e-002f,	-1.030162959e-002f,
-1.032037850e-002f,	-1.032154668e-002f,	-1.030658039e-002f,	-1.027682792e-002f,
-1.023360328e-002f,	-1.017821017e-002f,	-1.011195225e-002f,	-1.003602654e-002f,
-9.951564927e-003f,	-9.859735322e-003f,	-9.761689935e-003f,	-9.658335268e-003f,
-9.550506542e-003f,	-9.439239790e-003f,	-9.325311663e-003f,	-9.209571053e-003f,
-9.092729858e-003f,	-8.975504153e-003f,	-8.858564025e-003f,	-8.742547510e-003f,
-8.627917216e-003f,	-8.515236113e-003f,	-8.404834687e-003f,	-8.297046057e-003f,
-8.192181772e-003f,	-8.090558376e-003f,	-7.992340269e-003f,	-7.897787592e-003f,
-7.806979112e-003f,	-7.720005214e-003f,	-7.636899169e-003f,	-7.557692588e-003f,
-7.482361735e-003f,	-7.410882580e-003f,	-7.343084197e-003f,	-7.278918614e-003f,
-7.218206313e-003f,	-7.160843298e-003f,	-7.106600273e-003f,	-7.055249360e-003f,
-7.006591540e-003f,	-6.960450953e-003f,	-6.916554770e-003f,	-6.874623603e-003f,
-6.834443173e-003f,	-6.795786363e-003f,	-6.758476537e-003f,	-6.722125943e-003f,
-6.686140904e-003f,	-6.650228698e-003f,	-6.614354299e-003f,	-6.578320579e-003f,
-6.541865504e-003f,	-6.504729307e-003f,	-6.466690242e-003f,	-6.427556829e-003f,
-6.387124476e-003f,	-6.345262304e-003f,	-6.301766583e-003f,	-6.256542736e-003f,
-6.209372065e-003f,	-6.160215935e-003f,	-6.108902434e-003f,	-6.055355267e-003f,
-5.999473903e-003f,	-5.941211676e-003f,	-5.880495927e-003f,	-5.817286139e-003f,
-5.751536864e-003f,	-5.683230954e-003f,	-5.612376000e-003f,	-5.538957988e-003f,
-5.462963107e-003f,	-5.384396218e-003f,	-5.303337109e-003f,	-5.219739773e-003f,
-5.133623038e-003f,	-5.045046347e-003f,	-4.954008598e-003f,	-4.860588886e-003f,
-4.764720830e-003f,	-4.666469548e-003f,	-4.565946029e-003f,	-4.463150894e-003f,
-4.358150755e-003f,	-4.250967472e-003f,	-4.141634862e-003f,	-4.030165356e-003f,
-3.916597676e-003f,	-3.800994685e-003f,	-3.683451013e-003f,	-3.563914930e-003f,
-3.442490008e-003f,	-3.319256439e-003f,	-3.194250476e-003f,	-3.067525877e-003f,
-2.939139106e-003f,	-2.809151899e-003f,	-2.677703006e-003f,	-2.544830774e-003f,
-2.410617951e-003f,	-2.275190769e-003f,	-2.138586520e-003f,	-2.000881763e-003f,
-1.862161138e-003f,	-1.722850651e-003f,	-1.583005323e-003f,	-1.442635274e-003f,
-1.301735673e-003f,	-1.160531185e-003f,	-1.018710155e-003f,	-8.753658739e-004f,
7.250868880e-004f,	5.901514303e-004f,	4.571251178e-004f,	3.254504485e-004f,
1.951832638e-004f,	6.661818102e-005f,	-6.002729636e-005f,	-1.845163192e-004f,
-3.065712812e-004f,	-4.259661821e-004f,	-5.424773586e-004f,	-6.558084462e-004f,
-7.659101270e-004f,	-8.724859431e-004f,	-9.753531169e-004f,	-1.074300123e-003f,
-1.169143931e-003f,	-1.259725653e-003f,	-1.345834917e-003f,	-1.427339711e-003f,
-1.504079804e-003f,	-1.575880974e-003f,	-1.642633581e-003f,	-1.704200291e-003f,
-1.760514313e-003f,	-1.811458673e-003f,	-1.856981580e-003f,	-1.897029046e-003f,
-1.931585943e-003f,	-1.960627085e-003f,	-1.984178530e-003f,	-2.002288841e-003f,
-2.014916352e-003f,	-2.022189227e-003f,	-2.024254777e-003f,	-2.021156707e-003f,
-2.013111787e-003f,	-2.000212633e-003f,	-1.982687042e-003f,	-1.960693892e-003f,
-1.934407806e-003f,	-1.904123564e-003f,	-1.870072199e-003f,	-1.832519954e-003f,
-1.791756667e-003f,	-1.747978721e-003f,	-1.701541034e-003f,	-1.652689459e-003f,
-1.601690869e-003f,	-1.548954091e-003f,	-1.494709798e-003f,	-1.439190572e-003f,
-1.382763831e-003f,	-1.325642967e-003f,	-1.268184237e-003f,	-1.210596702e-003f,
-1.153025111e-003f,	-1.095962010e-003f,	-1.039553844e-003f,	-9.838346247e-004f,
-9.290281182e-004f,	-8.749810533e-004f,	-8.215803922e-004f,	-7.706114369e-004f,
-7.240453976e-004f,	-6.849432724e-004f,	-6.499492789e-004f,	-6.169265466e-004f,
-5.864023580e-004f,	-5.585564629e-004f,	-5.332623457e-004f,	-5.106711356e-004f,
-4.907668697e-004f,	-4.734587422e-004f,	-4.585871522e-004f,	-4.460035978e-004f,
-4.356377129e-004f,	-4.273247733e-004f,	-4.208333622e-004f,	-4.159437129e-004f,
-4.123958509e-004f,	-4.100224176e-004f,	-4.085466401e-004f,	-4.077080867e-004f,
-4.073254607e-004f,	-4.070933270e-004f,	-4.067607615e-004f,	-4.061488057e-004f,
-4.050555465e-004f,	-4.033838275e-004f,	-4.008810861e-004f,	-3.973769462e-004f,
-3.928186164e-004f,	-3.870561869e-004f,	-3.799993670e-004f,	-3.715971708e-004f,
-3.617549303e-004f,	-3.505340233e-004f,	-3.378810709e-004f,	-3.237820254e-004f,
-3.083797395e-004f,	-2.916580376e-004f,	-2.737128656e-004f,	-2.546266898e-004f,
-2.344785058e-004f,	-2.134575242e-004f,	-1.916264055e-004f,	-1.692851861e-004f,
-1.466953561e-004f,	-1.236855725e-004f,	-1.005737421e-004f,	-7.750656629e-005f,
-5.466984383e-005f,	-3.255925659e-005f,	-1.096860209e-005f,	9.881411052e-006f,
2.951496819e-005f,	4.810106298e-005f,	6.513783951e-005f,	8.051456872e-005f,
9.429776657e-005f,	1.058298512e-004f,	1.155823149e-004f,	1.229659418e-004f,
1.266886375e-004f,	1.279376783e-004f,	1.216914975e-004f,	9.386301158e-005f,
};


struct QMFLIB_POLYPHASE_ANA_FILTERBANK
{
  double *X; 
};

struct QMFLIB_POLYPHASE_SYN_FILTERBANK
{
  double *V; 
};

static struct M
{
  int resolution;
  double real[QMFLIB_MAX_NUM_QMF_BANDS][2*QMFLIB_MAX_NUM_QMF_BANDS];
  double imag[QMFLIB_MAX_NUM_QMF_BANDS][2*QMFLIB_MAX_NUM_QMF_BANDS];

} M;  

static struct N
{
  int resolution;
  double real[2*QMFLIB_MAX_NUM_QMF_BANDS][QMFLIB_MAX_NUM_QMF_BANDS];
  double imag[2*QMFLIB_MAX_NUM_QMF_BANDS][QMFLIB_MAX_NUM_QMF_BANDS];

} N;  


void
QMFlib_InitSynFilterbank(int resolution,
                         int LdMode)
{
  int l,k;
  double gain;

  N.resolution = resolution;

#ifdef PARTIALLY_COMPLEX

  gain = sqrt(2.0) / 64.0;

  for ( l=0; l<2*resolution; l++ ) {
    for ( k=0; k<resolution; k++ ) {
      N.real[l][k] = gain * cos((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-resolution));
    }
  }

#else
  
  gain = 1.0 / 64.0;
 if(LdMode==0){
  for ( l=0; l<2*resolution; l++ ) {
    for ( k=0; k<resolution; k++ ) {
      N.real[l][k] = gain * cos((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-255*resolution/64.0));
      N.imag[l][k] = gain * sin((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-255*resolution/64.0));
    	}
  	}
  }
  else {
    for ( l=0; l<2*resolution; l++ ) {
      for ( k=0; k<resolution; k++ ) {
        N.real[l][k] = gain * cos((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-(4*resolution-1)));/*255*/
        N.imag[l][k] = gain * sin((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-(4*resolution-1)));
      }
    }
  }

#endif
}


void
QMFlib_OpenSynFilterbank(QMFLIB_POLYPHASE_SYN_FILTERBANK **selfPtr)
{
  QMFLIB_POLYPHASE_SYN_FILTERBANK *self;

  self = calloc(1, sizeof(QMFLIB_POLYPHASE_SYN_FILTERBANK));
  if (self != NULL) {
    self->V = calloc(20 * N.resolution, sizeof(double));
  }
  *selfPtr = self;
}


void
QMFlib_CloseSynFilterbank(QMFLIB_POLYPHASE_SYN_FILTERBANK *self)
{
  if (self != NULL) {
    free(self->V);
  }
  free(self);
}


void
QMFlib_CalculateSynFilterbank(QMFLIB_POLYPHASE_SYN_FILTERBANK *self,
                          float  *Sr,
                          float  *Si,
                          float *timeSig,
			  int LdMode)
{
  int i,j,k,l;
  double   U[10 * QMFLIB_MAX_NUM_QMF_BANDS];
  double   W[10 * QMFLIB_MAX_NUM_QMF_BANDS];
  double  *V = self->V;
  double   realAccu;
  const double* C;
  int resolution = N.resolution;

  if (LdMode==0){
	C = QMFlib_PolyphaseFilterbankCoefficients;
  }else{
	C = QMFlib_PolyphaseLdFilterbankCoefficients;
  }
  
  for ( l=20*resolution-1; l>=2*resolution; l-- ) {
    V[l] = V[l-2*resolution];
  }

  
  for ( l=0; l<2*resolution; l++ ) {
    realAccu = 0.0;
    for ( k=0; k<resolution; k++ ) {
      realAccu = realAccu 
#ifdef PARTIALLY_COMPLEX
      + Sr[k] * N.real[l][k]; 
#else
      + Sr[k] * N.real[l][k] 
      - Si[k] * N.imag[l][k];
#endif
    }
    V[l] = realAccu;
  }

  
  for ( i=0; i<5; i++ ) {
    for ( j=0; j<resolution; j++ ) {
      U[2*resolution*i+j]            = V[4*resolution*i+j];
      U[2*resolution*i+resolution+j] = V[4*resolution*i+3*resolution+j];
    }
  }

  
  for ( k=0; k<10*resolution; k++ ) {
	  if(LdMode==0){
		W[k] = U[k] * C[k*QMFLIB_MAX_NUM_QMF_BANDS/resolution];
	  }else{
		W[k] = U[k] *C[k*64/resolution];
	  }
  }

  
  for ( i=0; i<resolution; i++ ) {
    realAccu = 0.0;
    for ( j=0; j<10; j++ ) {
      realAccu = realAccu + W[resolution*j+i];
    }
    timeSig[i] = (float) realAccu;
  }
}


void
QMFlib_InitAnaFilterbank(int resolution, int LdMode)
{
  int k,l;
  double gain;

  M.resolution = resolution;

#ifdef PARTIALLY_COMPLEX
  
  gain = sqrt(2.0) * 64.0 / resolution;
  
  for ( k=0; k<resolution; k++ ) {
    for ( l=0; l<2*resolution; l++ ) {
      M.real[k][l] = gain * cos((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-3*resolution));
    }
  }

#else

  gain = 64.0 / resolution;
  
  for ( k=0; k<resolution; k++ ) {
    for ( l=0; l<2*resolution; l++ ) {
		if(LdMode==0){
			M.real[k][l] = gain * cos((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-resolution/64.0));
			M.imag[k][l] = gain * sin((QMFLIB_PI/2/resolution) * (k+0.5) * (2*l-resolution/64.0));
		}else{
	    	M.real[k][l] = gain * cos((QMFLIB_PI/(2*resolution)) * (k+0.5) * (2*l+(2*resolution+1))); /*(QMFLIB_PI/128) * (k+0.5) * (2*l+129)*/
        	M.imag[k][l] = gain * sin((QMFLIB_PI/(2*resolution)) * (k+0.5) * (2*l+(2*resolution+1))); /*(QMFLIB_PI/128) * (k+0.5) * (2*l+129) */
		}
    }
  }
  
#endif  
}


void
QMFlib_OpenAnaFilterbank(QMFLIB_POLYPHASE_ANA_FILTERBANK **selfPtr)
{
  QMFLIB_POLYPHASE_ANA_FILTERBANK *self;

  self = calloc(1, sizeof(QMFLIB_POLYPHASE_ANA_FILTERBANK));
  if (self != NULL) {
    self->X = calloc(10 * M.resolution, sizeof(double));
  }
  *selfPtr = self;
}


void
QMFlib_CloseAnaFilterbank(QMFLIB_POLYPHASE_ANA_FILTERBANK *self)
{
  if (self != NULL) {
    free(self->X);
  }
  free(self);
}


void
QMFlib_CalculateAnaFilterbank(QMFLIB_POLYPHASE_ANA_FILTERBANK *self,
                              float * timeSig,
                              float * Sr,
                              float * Si,
                              int LdMode)
{
  int i,j,k,l;
  float   Z[10 * QMFLIB_MAX_NUM_QMF_BANDS];
  float   Y[2 * QMFLIB_MAX_NUM_QMF_BANDS];
  double *X = self->X;
  int resolution = M.resolution;
  const double* C;
  if (LdMode==0){
	C = QMFlib_PolyphaseFilterbankCoefficients;
  }else{
	C = QMFlib_PolyphaseLdFilterbankCoefficients;
  }
 

  
  for ( i=10*resolution-1; i>=resolution; i-- ) {
    X[i] = X[i-resolution];
  }

  
  for ( i=resolution-1; i>=0; i-- ) {
    X[i] = timeSig[resolution-1-i];
  }

  
  for ( i=0; i<10*resolution; i++ ) {
	  if(LdMode==1){
		Z[i] = (float) (X[i] * C[i*64/resolution]);
	  }else{
		Z[i] = (float) (X[i] * C[i*QMFLIB_MAX_NUM_QMF_BANDS/resolution]);
	  }
  }

  
  for ( i=0; i<2*resolution; i++ ) {
    Y[i] = 0.0f;
    for ( j=0; j<5; j++ ) {
      Y[i] += Z[i + j * 2 * resolution];
    }
  }
#ifdef PARTIALLY_COMPLEX
  
  for ( k=0; k<resolution; k++ ) {
    Sr[k] = 0.0f;
    for ( l=0; l<2*resolution; l++ ) {
      Sr[k] += (float) (Y[l] * M.real[k][l]);
    }
  }
#else
  
  for ( k=0; k<resolution; k++ ) {
    Sr[k] = 0.0f;
    Si[k] = 0.0f;
    for ( l=0; l<2*resolution; l++ ) {
      Sr[k] += (float) (Y[l] * M.real[k][l]);
      Si[k] += (float) (Y[l] * M.imag[k][l]);
    }
  }
#endif
}

void
QMFlib_GetFilterbankPrototype(int resolution,
                              float * prototype,
                              int LdMode)
{
  const double* C;
  int i;

  if (LdMode==0){
	C = QMFlib_PolyphaseFilterbankCoefficients;
  }else{
	C = QMFlib_PolyphaseLdFilterbankCoefficients;
  }

  for ( i=0; i<10*resolution; i++ ) {
	prototype[i] = (float) C[i*QMFLIB_MAX_NUM_QMF_BANDS/resolution];
  }
 

  for ( i=2*resolution; i<4*resolution; i++ ) {
    prototype[i] = -prototype[i];
  }

  for ( i=6*resolution; i<8*resolution; i++ ) {
    prototype[i] = -prototype[i];
  }
}
