@echo off
setlocal enabledelayedexpansion

set currentDir3da=%~dp0
set mhasDir=%currentDir3da%..\example
set compilerVS09="%VS90COMNTOOLS%\..\IDE\devenv.com"
set compilerVS11="%VS110COMNTOOLS%\..\IDE\devenv.com"
set compilerVS11x="MSBuild"
set platform=VS11
set target=Win32
set buildMode=Debug
set executeDecoding=1
set checkout=0
set vcmTool=vcmSVN
set verbose=0

:: loop over arguments
:parseFlags
if "%1"=="" goto endParseFlags

if "%1"=="Release" set buildMode=Release
if "%1"=="VS2008" set platform=VS09
if "%1"=="VS2012x" set platform=VS11x
if "%1"=="x64" set target=x64
if "%1"=="nDec" set executeDecoding=0
if "%1"=="co" set checkout=1
if "%1"=="GIT" set vcmTool=vcmGIT
if "%1"=="v" set verbose=1

shift
GOTO parseFlags
:endParseFlags

:: set compiler specific options
if "%platform%"=="VS11" (
  :: Visual Studio 2012 Professional
  set compile=%compilerVS11%
  set vsVersion=2012
  set vsVersionPostfix=_VS!vsVersion!
  set vsProjExt=vcxproj
) else (
  if "%platform%"=="VS11x" (
    :: Visual Studio 2012 Express
    set compile=%compilerVS11x%
    set vsVersion=2012
    set vsVersionPostfix=_VS!vsVersion!
    set vsProjExt=vcxproj
  ) else (
    :: Visual Studio 2008 Professional
    set compile=%compilerVS09%
    set vsVersion=2008
    set vsVersionPostfix=
    set vsProjExt=vcproj
  )
)

if "%platform%"=="VS11x" (
  :: Visual Studio Express
  set buildCommand=/t:Rebuild
  set buildSettingCO=/p:Configuration=%buildMode% /p:Platform=%target%
  set buildSettingDRC=/p:Configuration=%buildMode% /p:Platform=%target%
  set buildSettingAFsp=/p:Configuration=Release /p:Platform=%target%
  set buildSettingHOA=/p:Configuration=Release /p:Platform=%target%
) else (
  :: Visual Studio Professional
  set buildCommand=/Rebuild
  set buildSettingCO="%buildMode%|%target%"
  set buildSettingDRC="%buildMode%|%target%"
  set buildSettingAFsp="Release|%target%"
  set buildSettingHOA="Release|%target%"
)

set flagsCO=%buildCommand% %buildSettingCO%
set flagsDRC=%buildCommand% %buildSettingDRC%
set flagsAFsp=%buildCommand% %buildSettingAFsp%
set flagsHOA=%buildCommand% %buildSettingHOA%

:: set directories and libtsplite library
if "%target%"=="x64" (
  set buildOutDir=x64\%buildMode%
  set libtsplite=libtsplite_x64.lib
) else (
  set buildOutDir="%buildMode%"
  set libtsplite=libtsplite.lib
)
set buildOutDirWin32="%target%_%buildMode%"
if "%platform%"=="VS11x" (
  set buildDirCleanString=%currentDir3da%executables_%target%_%buildMode%_VS%vsVersion%express
) else (
  set buildDirCleanString=%currentDir3da%executables_%target%_%buildMode%_VS%vsVersion%
)
set buildDir="%buildDirCleanString%"
set buildDirAFsp="%currentDir3da%\..\tools\AFsp\lib"

:: echo flags and options
echo ******************** MPEG-H 3D Audio Coder - Edition 3.0 (CD) *****************
echo *                                                                             *
echo *                               Windows compiler                              *
echo *                                                                             *
echo *                                  %DATE%                                 *
echo *                                                                             *
echo *    This software may only be used in the development of the MPEG 3D Audio   *
echo *    standard, ISO/IEC 23008-3 or in conforming implementations or products.  *
echo *                                                                             *
echo *******************************************************************************
echo.
if "%platform%"=="VS11x" (
  echo Using %platform% compiler [Microsoft Visual Studio %vsVersion% Express].
  echo.
  if "%target%"=="x64" (
    echo x64 build is not supported with Microsoft Visual Studio %vsVersion% Express.
    goto BUILDERROR
  )
  echo Setting environment for using Microsoft Visual Studio %vsVersion% Express.
  call "%VS110COMNTOOLS%\VsDevCmd.bat"
  echo.
) else (
  echo Using %platform% compiler [Microsoft Visual Studio %vsVersion%].
  echo.
)
echo compile flags CO:   %flagsCO%
if not "%platform%"=="VS09" (
  echo compile flags HOA:  %flagsHOA%
)
echo compile flags DRC:  %flagsDRC%
echo compile flags AFsp: %flagsAFsp%
echo.

:: create output directories
if not exist %buildDir% (
  mkdir %buildDir%
) else (
  del /s /f %buildDir%\*.exe >nul 2>&1
)
if not exist %buildDirAFsp% (
  mkdir %buildDirAFsp%
) else (
  del /s /f %buildDirAFsp%\%libtsplite% >nul 2>&1
)

:: checkout IsoLib
if %checkout% EQU 1 (
  if "%vcmTool%"=="vcmGIT" (
    echo downloading IsoLib from GitHub...
  ) else (
    echo downloading IsoLib from SVN...
  )
  echo.
  call %currentDir3da%\..\tools\IsoLib\scripts\checkout.bat -p v %vcmTool% > coIsoLib.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type coIsoLib.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
)

:: check add-on libraries
if not exist %currentDir3da%\..\tools\AFsp\MSVC\MSVC.sln (
  echo AFsp MSVC.sln is not existing.
  echo Please download http://www.mmsp.ece.mcgill.ca/Documents/Downloads/AFsp/
  exit /b 1
)
if not exist %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\scripts\compile.bat (
  echo MPEG-D DRC is not existing.
  echo Please add MPEG-D DRC reference software as in ISO/IEC 23003-4.
  exit /b 1
)
if not exist %currentDir3da%\..\tools\IsoLib\libisomediafile\w32\libisomediafile\VS%vsVersion%\libisomedia.%vsProjExt% (
  echo ISOBMFF is not existing.
  echo Please download https://github.com/MPEGGroup/isobmff/archive/master.zip.
  exit /b 1
)

:: compile AFsp library
if "%target%"=="x64" (
  echo Compiling libtsplite
  echo Compiling ResampAudio

  call "%currentDir3da%..\tools\AFsp\scripts\compile.bat" VS%vsVersion% %target% > libtsplite.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type libtsplite.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  copy %currentDir3da%\..\tools\AFsp\MSVC\bin\ResampAudio.exe %buildDir%\ >> libtsplite.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type libtsplite.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
) else (
  echo Compiling libtsplite
    if "%platform%"=="VS11x" (
      if not exist %currentDir3da%\..\tools\AFsp\MSVC\libtsplite\libtsplite.vcxproj (
        echo Please use Visual Studio %vsVersion% Express to now upgrade:
        echo.  %currentDir3da%..\tools\AFsp\MSVC\libtsplite\libtsplite.vcproj
        echo.
        pause
      )
      %compile% %currentDir3da%\..\tools\AFsp\MSVC\libtsplite\libtsplite.vcxproj %flagsAFsp% > libtsplite.log
      copy %currentDir3da%\..\tools\AFsp\MSVC\lib\%libtsplite% %buildDirAFsp%\%libtsplite% >> libtsplite.log
      if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type libtsplite.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
    ) else (
      if "%platform%"=="VS11" (
        %compile% %currentDir3da%\..\tools\AFsp\MSVC\MSVC.sln /upgrade > AFspUpgrade.log
        if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type AFspUpgrade.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
      )
      %compile% %currentDir3da%\..\tools\AFsp\MSVC\MSVC.sln /Project libtsp %flagsAFsp% > libtsplite.log
      copy %currentDir3da%\..\tools\AFsp\MSVC\lib\%libtsplite% %buildDirAFsp%\%libtsplite% >> libtsplite.log
      if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type libtsplite.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
    )

  echo Compiling ResampAudio
    if "%platform%"=="VS11x" (
      if not exist %currentDir3da%\..\tools\AFsp\MSVC\ResampAudio\ResampAudio.vcxproj (
        echo Please use Visual Studio %vsVersion% Express to now upgrade:
        echo.  %currentDir3da%..\tools\AFsp\MSVC\ResampAudio\ResampAudio.vcproj
        echo.
        pause
      )
      %compile% %currentDir3da%\..\tools\AFsp\MSVC\ResampAudio\ResampAudio.vcxproj %flagsAFsp% > ResampAudio.log
      copy %currentDir3da%\..\tools\AFsp\MSVC\bin\ResampAudio.exe %buildDir%\ >> ResampAudio.log
      if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type ResampAudio.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
    ) else (
      %compile% %currentDir3da%\..\tools\AFsp\MSVC\MSVC.sln /Project ResampAudio %flagsAFsp% > ResampAudio.log
      copy %currentDir3da%\..\tools\AFsp\MSVC\bin\ResampAudio.exe %buildDir%\ >> ResampAudio.log
      if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type ResampAudio.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
    )
)

:: compile MPEG-H 3D Audio modules
echo Compiling ascParser
  %compile% %currentDir3da%\..\modules\ascParser\ascParserCmdl\make\ascParserCmdl%vsVersionPostfix%.sln %flagsCO% > ascParser.log
  copy %currentDir3da%\..\modules\ascParser\ascParserCmdl\make\%buildOutDir%\ascParserCmdl.exe %buildDir%\ >> ascParser.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type ascParser.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling core Encoder
  %compile% %currentDir3da%\..\modules\coreCoder\mpegD_usac\usacEncDec\win32\usacEnc\usacEnc%vsVersionPostfix%.sln %flagsCO% > coreEnc.log
  copy %currentDir3da%\..\modules\coreCoder\mpegD_usac\usacEncDec\win32\usacEnc\bin\%buildOutDirWin32%\usacEnc.exe %buildDir%\ >> coreEnc.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type coreEnc.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling core Decoder
  %compile% %currentDir3da%\..\modules\coreCoder\mpegD_usac\usacEncDec\win32\usacDec\usacDec%vsVersionPostfix%.sln %flagsCO% > coreDec.log
  copy %currentDir3da%\..\modules\coreCoder\mpegD_usac\usacEncDec\3DAudioCoreDecoder\make\bin\%buildOutDirWin32%\3DAudioCoreDecoder.exe %buildDir%\ >> coreDec.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type coreDec.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling Format Converter
  %compile% %currentDir3da%\..\modules\formatConverter\formatConverterCmdl\make\formatConverterCmdl%vsVersionPostfix%.sln %flagsCO% > formatConverter.log
  copy %currentDir3da%\..\modules\formatConverter\formatConverterCmdl\make\%buildOutDir%\formatConverterCmdl.exe %buildDir%\ >> formatConverter.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type formatConverter.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling Mixer
  %compile% %currentDir3da%\..\modules\mixer\mixerCmdl\make\mixerCmdl%vsVersionPostfix%.sln %flagsCO% > mixer.log
  copy %currentDir3da%\..\modules\mixer\mixerCmdl\make\%buildOutDir%\mixerCmdl.exe %buildDir%\ >> mixer.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type mixer.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling OAM Encoder
  %compile% %currentDir3da%\..\modules\oamCoder\oamEncoder\oamEncoderCmdl\make\oamEncoderCmdl%vsVersionPostfix%.sln %flagsCO% > oamEncoder.log
  copy %currentDir3da%\..\modules\oamCoder\oamEncoder\oamEncoderCmdl\make\%buildOutDir%\oamEncoderCmdl.exe %buildDir%\ >> oamEncoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type oamEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling OAM Decoder
  %compile% %currentDir3da%\..\modules\oamCoder\oamDecoder\make\oamDecoder%vsVersionPostfix%.sln %flagsCO% > oamDecoder.log
  copy %currentDir3da%\..\modules\oamCoder\oamDecoder\make\%buildOutDir%\oamDecoder.exe %buildDir%\ >> oamDecoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type oamDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling gVBAP Renderer
  %compile% %currentDir3da%\..\modules\gVBAPRenderer\gVBAPRendererCmdl\make\gVBAPRendererCmdl%vsVersionPostfix%.sln %flagsCO% > gVBAPRenderer.log
  copy %currentDir3da%\..\modules\gVBAPRenderer\gVBAPRendererCmdl\make\%buildOutDir%\gVBAPRendererCmdl.exe %buildDir%\ >> gVBAPRenderer.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type gVBAPRenderer.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling SAOC Decoder
  %compile% %currentDir3da%\..\modules\saocCoder\saocDecoderCmdl\make\saocDecoderCmdl%vsVersionPostfix%.sln %flagsCO% > saocDecoder.log
  copy %currentDir3da%\..\modules\saocCoder\saocDecoderCmdl\bin\%buildOutDirWin32%\saocDecoderCmdl.exe %buildDir%\ >> saocDecoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type saocDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling SAOC Encoder
  %compile% %currentDir3da%\..\modules\saocCoder\saocEncoderCmdl\make\saocEncoderCmdl%vsVersionPostfix%.sln %flagsCO% > saocEncoder.log
  copy %currentDir3da%\..\modules\saocCoder\saocEncoderCmdl\bin\%buildOutDirWin32%\saocEncoderCmdl.exe %buildDir%\ >> saocEncoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type saocEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling 3D-Audio Decoder
  %compile% %currentDir3da%\..\modules\3DAudioCoder\3DAudioDecoder\make\3DAudioDecoder%vsVersionPostfix%.sln %flagsCO% > 3DAudioDecoder.log
  copy %currentDir3da%\..\modules\3DAudioCoder\3DAudioDecoder\make\%buildOutDir%\3DAudioDecoder.exe %buildDir%\ >> 3DAudioDecoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type 3DAudioDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling 3D-Audio Encoder
  %compile% %currentDir3da%\..\modules\3DAudioCoder\3DAudioEncoder\make\3DAudioEncoder%vsVersionPostfix%.sln %flagsCO% > 3DAudioEncoder.log
  copy %currentDir3da%\..\modules\3DAudioCoder\3DAudioEncoder\make\%buildOutDir%\3DAudioEncoder.exe %buildDir%\ >> 3DAudioEncoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type 3DAudioEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling 3D-Audio dmxMatrixEncoder
  %compile% %currentDir3da%\..\modules\dmxMatrixCoder\dmxMatrixEncoder\dmxMatrixEncCmdl\make\dmxMatrixEncoderCmdl%vsVersionPostfix%.sln %flagsCO% > dmxMatrixEncoder.log
  copy %currentDir3da%\..\modules\dmxMatrixCoder\dmxMatrixEncoder\dmxMatrixEncCmdl\make\%buildOutDir%\dmxMatrixEncoderCmdl.exe %buildDir%\ >> dmxMatrixEncoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type dmxMatrixEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling 3D-Audio dmxMatrixDecoder
  %compile% %currentDir3da%\..\modules\dmxMatrixCoder\dmxMatrixDecoder\dmxMatrixDecCmdl\make\dmxMatrixDecoderCmdl%vsVersionPostfix%.sln %flagsCO% > dmxMatrixDecoder.log
  copy %currentDir3da%\..\modules\dmxMatrixCoder\dmxMatrixDecoder\dmxMatrixDecCmdl\make\%buildOutDir%\dmxMatrixDecoderCmdl.exe %buildDir%\ >> dmxMatrixDecoder.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type dmxMatrixDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling binauralParametrization_FD
  %compile% %currentDir3da%\..\modules\binaural\parametrization\parametrization_FD\binauralParametrizationCmdl\make\binauralParametrizationCmdl%vsVersionPostfix%.sln %flagsCO% > binauralParametrization_FD.log
  copy %currentDir3da%\..\modules\binaural\parametrization\parametrization_FD\binauralParametrizationCmdl\bin\%buildOutDirWin32%\binauralParametrizationFdCmdl.exe %buildDir%\ >> binauralParametrization_FD.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type binauralParametrization_FD.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling binauralParametrization_TD
  %compile% %currentDir3da%\..\modules\binaural\parametrization\parametrization_TD\binauralParametrizationCmdl\make\binauralParametrizationCmdl%vsVersionPostfix%.sln %flagsCO% > binauralParametrization_TD.log
  copy %currentDir3da%\..\modules\binaural\parametrization\parametrization_TD\binauralParametrizationCmdl\bin\%buildOutDirWin32%\binauralParametrizationTdCmdl.exe %buildDir%\ >> binauralParametrization_TD.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type binauralParametrization_TD.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling binauralRenderer_FD
  %compile% %currentDir3da%\..\modules\binaural\renderer\renderer_FD\binauralRendererCmdl\make\binauralRendererCmdl%vsVersionPostfix%.sln %flagsCO% > binauralRenderer_FD.log
  copy %currentDir3da%\..\modules\binaural\renderer\renderer_FD\binauralRendererCmdl\bin\%buildOutDirWin32%\binauralRendererFdCmdl.exe %buildDir%\ >> binauralRenderer_FD.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type binauralRenderer_FD.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling binauralRenderer_TD
  %compile% %currentDir3da%\..\modules\binaural\renderer\renderer_TD\binauralRendererCmdl\make\binauralRendererCmdl%vsVersionPostfix%.sln %flagsCO% > binauralRenderer_TD.log
  copy %currentDir3da%\..\modules\binaural\renderer\renderer_TD\binauralRendererCmdl\bin\%buildOutDirWin32%\BinauralRendererTdCmdl.exe %buildDir%\ >> binauralRenderer_TD.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type binauralRenderer_TD.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling binauralBitstreamWriter
  %compile% %currentDir3da%\..\modules\binaural\interface\bitstreamWriterCmdl\make\bitstreamWriterCmdl%vsVersionPostfix%.sln %flagsCO% > binauralBitstreamWriter.log
  copy %currentDir3da%\..\modules\binaural\interface\bitstreamWriterCmdl\bin\%buildOutDirWin32%\bitstreamWriterCmdl.exe %buildDir%\ >> binauralBitstreamWriter.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type binauralBitstreamWriter.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling domainSwitcher
  %compile% %currentDir3da%\..\modules\domainSwitcher\domainSwitcherCmdl\make\domainSwitcherCmdl%vsVersionPostfix%.sln %flagsCO% > domainSwitcher.log
  copy %currentDir3da%\..\modules\domainSwitcher\domainSwitcherCmdl\make\%buildOutDir%\domainSwitcherCmdl.exe %buildDir%\ >> domainSwitcher.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type domainSwitcher.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling dynamicObjectPriorityGenerator
  %compile% %currentDir3da%\..\modules\dynamicObjectPriorityGenerator\DynamicObjectPriorityGeneratorCmdl\make\DynamicObjectPriorityGeneratorCmdl%vsVersionPostfix%.sln %flagsCO% > dynamicObjectPriorityGenerator.log
  copy %currentDir3da%\..\modules\dynamicObjectPriorityGenerator\DynamicObjectPriorityGeneratorCmdl\make\%buildOutDir%\DynamicObjectPriorityGeneratorCmdl.exe %buildDir%\ >> dynamicObjectPriorityGenerator.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type dynamicObjectPriorityGenerator.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling localSetupInformationInterface
  %compile% %currentDir3da%\..\modules\decoderInterfaces\localSetupInformationInterface\localSetupInformationInterfaceExample\make\localSetupInformationInterface%vsVersionPostfix%.sln %flagsCO% > localSetupInformationInterface.log
  copy %currentDir3da%\..\modules\decoderInterfaces\localSetupInformationInterface\localSetupInformationInterfaceExample\bin\%buildOutDirWin32%\localSetupInterfaceExample.exe %buildDir%\ >> localSetupInformationInterface.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type localSetupInformationInterface.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling Separator
  %compile% %currentDir3da%\..\tools\separator\separatorCmdl\make\separatorCmdl%vsVersionPostfix%.sln %flagsCO% > separator.log
  copy %currentDir3da%\..\tools\separator\separatorCmdl\make\%buildOutDir%\separatorCmdl.exe %buildDir%\ >> separator.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type separator.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling wavM2N
  %compile% %currentDir3da%\..\tools\wavM2N\wavM2NCmdl\make\wavM2NCmdl%vsVersionPostfix%.sln %flagsCO% > wavM2N.log
  copy %currentDir3da%\..\tools\wavM2N\wavM2NCmdl\make\%buildOutDir%\wavM2NCmdl.exe %buildDir%\ >> wavM2N.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type wavM2N.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling cicp2geometry
  %compile% %currentDir3da%\..\tools\cicp2geometry\cicp2geometryCmdl\make\cicp2geometryCmdl%vsVersionPostfix%.sln %flagsCO% > cicp2geometry.log
  copy %currentDir3da%\..\tools\cicp2geometry\cicp2geometryCmdl\make\%buildOutDir%\cicp2geometryCmdl.exe %buildDir%\ >> cicp2geometry.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type cicp2geometry.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

echo Compiling wavCutter
  %compile% %currentDir3da%\..\tools\wavCutter\wavCutterCmdl\make\wavCutterCmdl%vsVersionPostfix%.sln %flagsCO% > wavCutter.log
  copy %currentDir3da%\..\tools\wavCutter\wavCutterCmdl\make\%buildOutDir%\wavCutterCmdl.exe %buildDir%\ >> wavCutter.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type wavCutter.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

:: compile VS2012 only projects
if not "%platform%"=="VS09" (
  echo Compiling IarFormatConverter
    %compile% %currentDir3da%\..\modules\iarFormatConverter\iarFormatConverterCmdl\make\iarFormatConverterCmdl%vsVersionPostfix%.sln %flagsCO% > iarFormatConverterCmdl.log
    copy %currentDir3da%\..\modules\iarFormatConverter\iarFormatConverterCmdl\make\%buildOutDir%\iarFormatConverterCmdl.exe %buildDir%\ >> iarFormatConverterCmdl.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type iarFormatConverterCmdl.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling HOA Decoder
    %compile% %currentDir3da%\..\modules\hoaCoder\hoaDec\VS2012\hoaReferenceDecoder.sln %flagsHOA% > hoaDecCmd.log
    copy %currentDir3da%\..\modules\hoaCoder\hoaDec\bin\Release\hoaReferenceDecoder.exe %buildDir%\ >> hoaDecCmd.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type hoaDecCmd.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling HOA Encoder
    %compile% %currentDir3da%\..\modules\hoaCoder\hoaEnc\VS2012\hoaReferenceEncoder.sln %flagsHOA% > hoaEncCmd.log
    copy %currentDir3da%\..\modules\hoaCoder\hoaEnc\bin\Release\hoaReferenceEncoder.exe %buildDir%\ >> hoaEncCmd.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type hoaEncCmd.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling hoaMatrixDecCmdl
    %compile% %currentDir3da%\..\modules\hoaMatrixCoder\hoaMatrixDecoder\hoaMatrixDecCmdl\make\hoaMatrixDecoderCmdl%vsVersionPostfix%.sln %flagsHOA% > hoaMatrixDecCmdl.log
    copy %currentDir3da%\..\modules\hoaMatrixCoder\hoaMatrixDecoder\hoaMatrixDecCmdl\make\Release\hoaMatrixDecoderCmdl.exe %buildDir%\ >> hoaMatrixDecCmdl.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type hoaMatrixDecCmdl.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling hoaMatrixEncCmdl
    %compile% %currentDir3da%\..\modules\hoaMatrixCoder\hoaMatrixEncoder\hoaMatrixEncCmdl\make\hoaMatrixEncoderCmdl%vsVersionPostfix%.sln %flagsHOA% > hoaMatrixEncCmdl.log
    copy %currentDir3da%\..\modules\hoaMatrixCoder\hoaMatrixEncoder\hoaMatrixEncCmdl\make\Release\hoaMatrixEncoderCmdl.exe %buildDir%\ >> hoaMatrixEncCmdl.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type hoaMatrixEncCmdl.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling earconEncoder
    %compile% %currentDir3da%\..\modules\earconCoder\make\earconEncoder%vsVersionPostfix%.sln %flagsCO% > earconEncoder.log
    copy %currentDir3da%\..\modules\earconCoder\make\earconEncoder\%buildOutDir%\earconEncoder.exe %buildDir%\ >> earconEncoder.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type earconEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling earconDecoder
    %compile% %currentDir3da%\..\modules\earconCoder\make\earconDecoder%vsVersionPostfix%.sln %flagsCO% > earconDecoder.log
    copy %currentDir3da%\..\modules\earconCoder\make\earconDecoder\%buildOutDir%\earconDecoder.exe %buildDir%\ >> earconDecoder.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type earconDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling prodmetadataEncoder
    %compile% %currentDir3da%\..\tools\prodmetadata\make\prodmetadataEncoder%vsVersionPostfix%.sln %flagsCO% > prodmetadataEncoder.log
    copy %currentDir3da%\..\tools\prodmetadata\make\prodmetadataEncoder\%buildOutDir%\prodmetadataEncoder.exe %buildDir%\ >> prodmetadataEncoder.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type prodmetadataEncoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling prodmetadataDecoder
    %compile% %currentDir3da%\..\tools\prodmetadata\make\prodmetadataDecoder%vsVersionPostfix%.sln %flagsCO% > prodmetadataDecoder.log
    copy %currentDir3da%\..\tools\prodmetadata\make\prodmetadataDecoder\%buildOutDir%\prodmetadataDecoder.exe %buildDir%\ >> prodmetadataDecoder.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type prodmetadataDecoder.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  echo Compiling ssnrcd
    %compile% %currentDir3da%\..\tools\ssnrcd\make\ssnrcd%vsVersionPostfix%.sln %flagsCO% > ssnrcd.log
    copy %currentDir3da%\..\tools\ssnrcd\make\%buildOutDir%\ssnrcd\ssnrcd.exe %buildDir%\ >> ssnrcd.log
    if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type ssnrcd.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
)

:: compile DRC decoder
echo Compiling drcCoder
  cd %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\scripts\
  if "%platform%"=="VS11x" (
    call compile MPEGH %target% %buildMode% %buildCommand% silent VS%vsVersion%x > DrcTool.log
  ) else (
    call compile MPEGH %target% %buildMode% %buildCommand% silent VS%vsVersion% > DrcTool.log
  )
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type DrcTool.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\drcTool\drcToolDecoder\make\%buildMode%\drcToolDecoder.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\drcTool\drcToolEncoder\make\%buildMode%\drcToolEncoderCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\loudnessNormalizer\loudnessNormalizerCmdl\make\%buildMode%\loudnessNormalizerCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\peakLimiter\peakLimiterCmdl\make\%buildMode%\peakLimiterCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\uniDrcModules\uniDrcBitstreamDecoderCmdl\make\%buildMode%\uniDrcBitstreamDecoderCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\uniDrcModules\uniDrcGainDecoderCmdl\make\%buildMode%\uniDrcGainDecoderCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\uniDrcModules\uniDrcInterfaceDecoderCmdl\make\%buildMode%\uniDrcInterfaceDecoderCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\uniDrcModules\uniDrcInterfaceEncoderCmdl\make\%buildMode%\uniDrcInterfaceEncoderCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\modules\uniDrcModules\uniDrcSelectionProcessCmdl\make\%buildMode%\uniDrcSelectionProcessCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\tools\dmx\dmxCmdl\make\%buildMode%\dmxCmdl.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\tools\fftlib\make\example\%buildOutDirWin32%\fftlib_example.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\tools\qmflib\make\example\%buildMode%\qmflib_example.exe %buildDir%\ >> DrcTool.log
  copy %currentDir3da%\..\modules\drcCoder\MPEG_D_DRC_refsoft\scripts\DrcTool.log %currentDir3da%\DrcTool.log 1>nul
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type DrcTool.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))

:: perform example decoding of mhas bitstreams
if %executeDecoding% EQU 1 (
  cd %currentDir3da%
  echo.
  echo Decoding example__C2_3_FD.mhas
  %buildDir%\3DAudioDecoder.exe -if "%mhasDir%\example__C2_3_FD.mhas" -of "%mhasDir%\example__C2_3_FD.wav" > decoding.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type decoding.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
  echo Decoding example__C6_3_FD.mhas
  %buildDir%\3DAudioDecoder.exe -if "%mhasDir%\example__C6_3_FD.mhas" -of "%mhasDir%\example__C6_3_FD.wav" >> decoding.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type decoding.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
  echo Decoding example__C19_3_FD.mhas
  %buildDir%\3DAudioDecoder.exe -if "%mhasDir%\example__C19_3_FD.mhas" -of "%mhasDir%\example__C19_3_FD.wav" >> decoding.log
  if %errorlevel% NEQ 0 ( if %verbose% EQU 1 ( type decoding.log 2>nul & goto BUILDERROR ) else ( goto BUILDERROR ))
)

goto END

:BUILDERROR
echo.
echo       Build failed. Check corresponding log file for more information.
exit /B 1

:RUNERROR
echo.
echo       Decoding failed. Check corresponding log file for more information.
exit /B 1

:END
echo.
echo All executables are collected in:
echo %buildDirCleanString%\
if %executeDecoding% NEQ 0 (
  echo.
  echo All decoded .wav files are collected in:
  echo %mhasDir%\
)
echo.
echo       Build successful.
exit /B 0
