/*******************************************************************************
This software module was originally developed by

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips

and edited by

-

in the course of development of ISO/IEC 23003 for reference purposes and its
performance may not have been optimized. This software module is an
implementation of one or more tools as specified by ISO/IEC 23003. ISO/IEC gives
You a royalty-free, worldwide, non-exclusive, copyright license to copy,
distribute, and make derivative works of this software module or modifications
thereof for use in implementations of ISO/IEC 23003 in products that satisfy
conformance criteria (if any). Those intending to use this software module in
products are advised that its use may infringe existing patents. ISO/IEC have no
liability for use of this software module or modifications thereof. Copyright is
not released for products that do not conform to audiovisual and image-coding
related ITU Recommendations and/or ISO/IEC International Standards.

#ifdef NOT_PUBLISHED

Assurance that the originally developed software module can be used (1) in
ISO/IEC 23003 once ISO/IEC 23003 has been adopted; and (2) to develop ISO/IEC
23003:
Agere Systems, Coding Technologies, Fraunhofer IIS, Philips grant(s) ISO/IEC all
rights necessary to include the originally developed software module or
modifications thereof in ISO/IEC 23003 and to permit ISO/IEC to offer You a
royalty-free, worldwide, non-exclusive, copyright license to copy, distribute,
and make derivative works for use in implementations of ISO/IEC 23003 in
products that satisfy conformance criteria (if any), and to the extent that such
originally developed software module or portions of it are included in ISO/IEC
23003. To the extent that Agere Systems, Coding Technologies, Fraunhofer IIS,
Philips own(s) patent rights that would be required to make, use, or sell the
originally developed software module or portions thereof included in ISO/IEC
23003 in a conforming product, Agere Systems, Coding Technologies, Fraunhofer
IIS, Philips will assure the ISO/IEC that it is (they are) willing to negotiate
licenses under reasonable and non-discriminatory terms and conditions with
applicants throughout the world. ISO/IEC gives You a free license to this
software module or modifications thereof for the sole purpose of developing
ISO/IEC 23003.

#endif

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips retain full right to
modify and use the code for its (their) own purpose, assign or donate the code
to a third party and to inhibit third parties from using the code for products
that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
International Standards. This copyright notice must be included in all copies or
derivative works.

Copyright (c) ISO/IEC 2007.
*******************************************************************************/






#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "error.h"
#include "saoc_kernels.h"


typedef unsigned int BIT_BUF_WORD;

char *errorMessage = "No error";

int FreqResBinTable[] = {0, 28, 20, 14, 10, 7, 5, 4};
int FreqResStrideTable[] = {1, 2, 5, 28};
int FreqResBinTable_Ld[] = {0, 23, 15, 12, 9, 7, 5, 4};
int FreqResStrideTable_Ld[] = {1, 2, 5, 23};


static int kernels_4_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 0, -1}, { 0, -1}, { 0,  1}, { 0,  1}, { 0,  1}, { 0,  1}, { 0,  1}, { 0,  1}, { 1,  1},
  { 1,  1}, { 1,  1}, { 1,  1}, { 1,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1},
  { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1},
  { 2,  1}, { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}
};

static int kernels_5_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 0, -1}, { 0, -1}, { 0,  1}, { 0,  1}, { 0,  1}, { 0,  1}, { 1,  1}, { 1,  1}, { 1,  1},
  { 1,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}
};

static int kernels_7_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 0, -1}, { 0, -1}, { 0,  1}, { 0,  1}, { 0,  1}, { 0,  1}, { 1,  1}, { 1,  1}, { 2,  1},
  { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1},
  { 5,  1}, { 5,  1}, { 5,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}
};

static int kernels_10_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 0, -1}, { 0, -1}, { 0,  1}, { 0,  1}, { 1,  1}, { 1,  1}, { 2,  1}, { 2,  1}, { 3,  1},
  { 3,  1}, { 4,  1}, { 4,  1}, { 5,  1}, { 5,  1}, { 6,  1}, { 6,  1}, { 7,  1}, { 7,  1},
  { 7,  1}, { 7,  1}, { 7,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}, { 9,  1}
};

static int kernels_14_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 0, -1}, { 0, -1}, { 0,  1}, { 0,  1}, { 1,  1}, { 1,  1}, { 2,  1}, { 3,  1}, { 4,  1},
  { 4,  1}, { 5,  1}, { 6,  1}, { 6,  1}, { 7,  1}, { 7,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {12,  1}, {12,  1}, {12,  1}, {12,  1}, {12,  1}, {12,  1},
  {12,  1}, {12,  1}, {12,  1}, {12,  1}, {12,  1}, {12,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}
};

static int kernels_20_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 1, -1}, { 0, -1}, { 0,  1}, { 1,  1}, { 2,  1}, { 3,  1}, { 4,  1}, { 5,  1}, { 6,  1},
  { 7,  1}, { 8,  1}, { 9,  1}, {10,  1}, {11,  1}, {12,  1}, {13,  1}, {14,  1}, {14,  1},
  {15,  1}, {15,  1}, {15,  1}, {16,  1}, {16,  1}, {16,  1}, {16,  1}, {17,  1}, {17,  1},
  {17,  1}, {17,  1}, {17,  1}, {18,  1}, {18,  1}, {18,  1}, {18,  1}, {18,  1}, {18,  1},
  {18,  1}, {18,  1}, {18,  1}, {18,  1}, {18,  1}, {18,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1},
  {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}
};

static int kernels_28_to_71[SAOC_MAX_HYBRID_BANDS][2] = {
  { 1, -1}, { 0, -1}, { 0,  1}, { 1,  1}, { 2,  1}, { 3,  1}, { 4,  1}, { 5,  1}, { 6,  1},
  { 7,  1}, { 8,  1}, { 9,  1}, {10,  1}, {11,  1}, {12,  1}, {13,  1}, {14,  1}, {15,  1},
  {16,  1}, {17,  1}, {17,  1}, {18,  1}, {18,  1}, {19,  1}, {19,  1}, {20,  1}, {20,  1},
  {21,  1}, {21,  1}, {21,  1}, {22,  1}, {22,  1}, {22,  1}, {23,  1}, {23,  1}, {23,  1},
  {23,  1}, {24,  1}, {24,  1}, {24,  1}, {24,  1}, {24,  1}, {25,  1}, {25,  1}, {25,  1},
  {25,  1}, {25,  1}, {25,  1}, {26,  1}, {26,  1}, {26,  1}, {26,  1}, {26,  1}, {26,  1},
  {26,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1},
  {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}, {27,  1}
};

static int kernels_4_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 0,  1},
  { 1,  1}, { 1,  1}, { 1,  1}, { 1,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1},
  { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1},
  { 2,  1}, { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}
};

static int kernels_5_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 1,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1},
  { 3,  1}, { 3,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}, { 4,  1}
};

static int kernels_7_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 2,  1}, { 2,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 4,  1},
  { 4,  1}, { 4,  1}, { 4,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1}, { 5,  1},
  { 5,  1}, { 5,  1}, { 5,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}, { 6,  1}
};

static int kernels_9_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 2,  1}, { 3,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 5,  1}, { 5,  1}, { 6,  1}, { 6,  1},
  { 6,  1}, { 6,  1}, { 6,  1}, { 7,  1}, { 7,  1}, { 7,  1}, { 7,  1}, { 7,  1}, { 7,  1},
  { 7,  1}, { 7,  1}, { 7,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1},
  { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}
};

static int kernels_12_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 2,  1}, { 3,  1}, { 4,  1}, { 4,  1}, { 5,  1}, { 5,  1}, { 6,  1}, { 6,  1}, { 6,  1},
  { 7,  1}, { 7,  1}, { 7,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 8,  1}, { 9,  1}, { 9,  1},
  { 9,  1}, { 9,  1}, { 9,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1},
  {10,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1}, {10,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1},
  {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}
};
static int kernels_15_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 2,  1}, { 3,  1}, { 4,  1}, { 5,  1}, { 6,  1}, { 7,  1}, { 8,  1}, { 9,  1}, { 9,  1},
  {10,  1}, {10,  1}, {10,  1}, {11,  1}, {11,  1}, {11,  1}, {11,  1}, {12,  1}, {12,  1},
  {12,  1}, {12,  1}, {12,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1},
  {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {13,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1},
  {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}, {14,  1}
};

static int kernels_23_to_64[SAOC_MAX_NUM_QMF_BANDS][2] = {
  { 0,  1}, { 1,  1},
  { 2,  1}, { 3,  1}, { 4,  1}, { 5,  1}, { 6,  1}, { 7,  1}, { 8,  1}, { 9,  1}, {10,  1},
  {11,  1}, {12,  1}, {12,  1}, {13,  1}, {13,  1}, {14,  1}, {14,  1}, {15,  1}, {15,  1},
  {16,  1}, {16,  1}, {16,  1}, {17,  1}, {17,  1}, {17,  1}, {18,  1}, {18,  1}, {18,  1},
  {18,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {19,  1}, {20,  1}, {20,  1}, {20,  1},
  {20,  1}, {20,  1}, {20,  1}, {21,  1}, {21,  1}, {21,  1}, {21,  1}, {21,  1}, {21,  1},
  {21,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1},
  {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}, {22,  1}
};

void SAOC_GetKernels(int nNumBins,
                     int hybridBands,
                     int LdMode,
                     int kernels[SAOC_MAX_HYBRID_BANDS][2]) {
  int i;

  if(LdMode==0)
  {
    switch(nNumBins){
    case 4:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_4_to_71[i][0];
        kernels[i][1] = kernels_4_to_71[i][1];
      }
      break;
    case 5:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_5_to_71[i][0];
        kernels[i][1] = kernels_5_to_71[i][1];
      }
      break;
    case 7:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_7_to_71[i][0];
        kernels[i][1] = kernels_7_to_71[i][1];
      }
      break;
    case 10:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_10_to_71[i][0];
        kernels[i][1] = kernels_10_to_71[i][1];
      }
      break;
    case 14:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_14_to_71[i][0];
        kernels[i][1] = kernels_14_to_71[i][1];
      }
      break;
    case 20:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_20_to_71[i][0];
        kernels[i][1] = kernels_20_to_71[i][1];
      }
      break;
    case 28:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_28_to_71[i][0];
        kernels[i][1] = kernels_28_to_71[i][1];
      }
      break;

    default:
      myexit("unsupported numParameterBands");
      break;
    }
  }
  else
  {
    switch(nNumBins){
    case 4:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_4_to_64[i][0];
        kernels[i][1] = kernels_4_to_64[i][1];
      }
      break;
    case 5:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_5_to_64[i][0];
        kernels[i][1] = kernels_5_to_64[i][1];
      }
      break;
    case 7:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_7_to_64[i][0];
        kernels[i][1] = kernels_7_to_64[i][1];
      }
      break;
    case 9:
	  for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_9_to_64[i][0];
        kernels[i][1] = kernels_9_to_64[i][1];
      }
      break;
    case 12:
	  for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_12_to_64[i][0];
        kernels[i][1] = kernels_12_to_64[i][1];
      }
      break;
    case 15:
	  for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_15_to_64[i][0];
        kernels[i][1] = kernels_15_to_64[i][1];
      }
      break;
    case 23:
      for(i=0; i < hybridBands; i++){
        kernels[i][0] = kernels_23_to_64[i][0];
        kernels[i][1] = kernels_23_to_64[i][1];
      }
     break;

    default:
      myexit("unsupported numParameterBands");
      break;
    }
  }
}

