/***********************************************************************************
 
 This software module was originally developed by 
 
 Fraunhofer IIS
 
 in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
 performance may not have been optimized. This software module is an implementation
 of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
 you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
 and make derivative works of this software module or modifications  thereof for use
 in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
 and which satisfy any specified conformance criteria. Those intending to use this 
 software module in products are advised that its use may infringe existing patents. 
 ISO/IEC have no liability for use of this software module or modifications thereof. 
 Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
 standard.
  
 Fraunhofer IIS retains full right to modify and use the code for its own purpose,
 assign or donate the code to a third party and to inhibit third parties from using 
 the code for products that do not conform to MPEG-related ITU Recommendations and/or 
 ISO/IEC International Standards.
 
 This copyright notice must be included in all copies or derivative works. 
 
 Copyright (c) ISO/IEC 2013.
 
 ***********************************************************************************/

#ifndef __SAOC_DMX_TABLES_H__
#define __SAOC_DMX_TABLES_H__

#include "saoc_const.h"

static float Decoder_Downmix_matrix_22_to_10_output[10][22] = {
	{0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_22_to_9_output[9][22] = {
	{0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.5000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.5000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_22_to_8_output[8][22] = {
	{0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	1.0000f,	0.5000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.5000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.5000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f},
};

static float Decoder_Downmix_matrix_22_to_7_output[7][22] = {
	{0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_22_to_5_output[5][22] = {
	{0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	0.8165f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	1.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_22_to_2_output[2][22] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.5000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.5000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f,	1.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.5000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.5000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f,	0.0000f,	1.0000f},
};

static float Decoder_Downmix_matrix_14_to_10_output[10][14] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	1.0000f},
};

static float Decoder_Downmix_matrix_14_to_8_output[8][14] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.5000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.7071f,	0.5000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_14_to_7_output[7][14] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f,	0.7071f,	0.7071f},
};

static float Decoder_Downmix_matrix_14_to_5_output[5][14] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	1.0000f,	0.7071f,	0.0000f},
};

static float Decoder_Downmix_matrix_14_to_2_output[2][14] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f},
};

static float Decoder_Downmix_matrix_12_to_10_output[10][12] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_12_to_9_output[9][12] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.5000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_12_to_8_output[8][12] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_12_to_7_output[7][12] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.5000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.5000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_12_to_5_output[5][12] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.7071f},
};

static float Decoder_Downmix_matrix_12_to_2_output[2][12] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f},
};

static float Decoder_Downmix_matrix_11_to_9_output[9][11] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.5000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.5000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.5000f,	0.0000f},
};

static float Decoder_Downmix_matrix_11_to_8_output[8][11] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f,	1.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.5000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.5000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_11_to_7_output[7][11] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.5000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.5000f,	0.7071f},
};

static float Decoder_Downmix_matrix_11_to_5_output[5][11] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_11_to_2_output[2][11] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f,	0.7071f},
};

static float Decoder_Downmix_matrix_10_to_9_output[9][10] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.5000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.5000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.5000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.5000f},
};

static float Decoder_Downmix_matrix_10_to_8_output[8][10] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_10_to_7_output[7][10] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.7071f},
};

static float Decoder_Downmix_matrix_10_to_5_output[5][10] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
};

static float Decoder_Downmix_matrix_10_to_2_output[2][10] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f},
};

static float Decoder_Downmix_matrix_9_to_8_output[8][9] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_9_to_7_output[7][9] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f},
};

static float Decoder_Downmix_matrix_9_to_5_output[5][9] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
};

static float Decoder_Downmix_matrix_9_to_2_output[2][9] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	1.0000f},
};

static float Decoder_Downmix_matrix_8_to_7_output[7][8] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_8_to_5_output[5][8] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	0.0000f,	0.7071f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_8_to_2_output[2][8] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f,	0.7071f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f,	0.7071f},
};

static float Decoder_Downmix_matrix_7_to_5_output[5][7] = {
	{1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f,	0.0000f},
	{0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f,	0.7071f},
	{0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f,	0.0000f},
	{0.0000f,	0.0000f,	0.0000f,	0.0000f,	1.0000f,	0.0000f,	0.0000f},
};

static float Decoder_Downmix_matrix_7_to_2_output[2][7] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f,	1.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f,	0.0000f,	1.0000f},
};

static float Decoder_Downmix_matrix_5_to_2_output[2][5] = {
	{1.0000f,	0.0000f,	0.7071f,	1.0000f,	0.0000f},
	{0.0000f,	1.0000f,	0.7071f,	0.0000f,	1.0000f},
};

#endif
