/***********************************************************************************
 
 This software module was originally developed by 
 
 Fraunhofer IIS
 
 in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
 performance may not have been optimized. This software module is an implementation
 of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
 you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
 and make derivative works of this software module or modifications  thereof for use
 in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
 and which satisfy any specified conformance criteria. Those intending to use this 
 software module in products are advised that its use may infringe existing patents. 
 ISO/IEC have no liability for use of this software module or modifications thereof. 
 Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
 standard.
 
 Fraunhofer IIS retains full right to modify and use the code for its own purpose,
 assign or donate the code to a third party and to inhibit third parties from using 
 the code for products that do not conform to MPEG-related ITU Recommendations and/or 
 ISO/IEC International Standards.
 
 This copyright notice must be included in all copies or derivative works. 
 
 Copyright (c) ISO/IEC 2013.
 
 ***********************************************************************************/
/**
 * @file oam_encode_rapV4.h
 * @brief RAP-V4 object metadata encoder
 * @author Christian Borss <christian.borss@iis.fraunhofer.de>
 *
 * @date 05.08.2013 - first version
 *
 * @version 0.1
 */


#ifndef  __OAM_ENCODE_RAPV4_H__
#define  __OAM_ENCODE_RAPV4_H__


#include "oam_common.h"
#include "oam_bitbuf_write.h"


#define OAM_MAX_IFRAME_PERIOD 64

/*helper functions*/
StructOamPolChunk* create_pol_chunk(int num_objects);
StructOamPolChunk* destroy_pol_chunk(StructOamPolChunk* p);

int realloc_pol_chunk(StructOamPolChunk* p, int num_points);

void encode_chunk(OamPBS* pbs,
                         const StructOamMultidata* chunk,
                         StructOamMultidata* chunk_i,
                         StructOamMultidata* chunk_d,
                         StructOamMultidata** first,
                         StructOamMultidata** last,
                         StructOamPolChunk* pol_dframe,
                         const unsigned int iframe_period,
                         const DYNAMIC_OBJECT_PRIO hasDynamicObjectPriority,
                         const unsigned int hasUniformSpread);
void repeat_chunk(StructOamMultidata* chunk, int num_samples, int iframe_period, StructOamMultidata* last);


#endif	/* __OAM_ENCODE_RAPV4_H__ */
