/***********************************************************************************
 
This software module was originally developed by 
 
Samsung Electronics
 
in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
performance may not have been optimized. This software module is an implementation
of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
and make derivative works of this software module or modifications  thereof for use
in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
and which satisfy any specified conformance criteria. Those intending to use this 
software module in products are advised that its use may infringe existing patents. 
ISO/IEC have no liability for use of this software module or modifications thereof. 
Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
standard.
 
Samsung Electronics retains full right to modify and use the code for 
their own purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for products that do not conform to MPEG-related ITU 
Recommendations and/or ISO/IEC International Standards.
 
This copyright notice must be included in all copies or derivative works. 
 
Copyright (c) ISO/IEC 2013.
 
***********************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#define SAMSUNG 1
/* TABLE : SPATIAL COLORATION FILTERS FOR HORIZONTAL CHANNELS */
float COLOR_180_110[71]	= {	1.2207277f,	1.2207277f,	1.2207277f,	1.2207277f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.85933852f,	0.90390807f,
							0.88763344f,	0.80779493f,	0.80421317f,	0.85141277f,	0.83064753f,	0.81076753f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f };
float COLOR_090_030[71]	= { 0.82575887f,	0.82575887f,	0.82575887f,	0.82575887f,	1.1754434f,	1.1754434f,	1.1754434f,
							1.1585163f,	1.1585163f,	1.26f,		1.208599f,	0.97740591f,	0.84453988f,	0.94619727f,	
							1.0500977f,	1.0856131f,	0.99716073f,	0.89153987f,	0.94386107f,	0.99713677f,	1.1471872f,
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,	
							1.26f,		1.1031394f,	0.95639628f,	0.79763001f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.87519455f,	0.98095393f,	
							1.0163895f,	1.0274936f,	1.0639353f,	1.1517589f,	1.22469f,	1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f };
float COLOR_060_110[71]	= { 1.0478644f,	1.0478644f,	1.0478644f,	1.0478644f,	1.01643f,	1.01643f,	1.01643f,	
							1.0149473f,	1.0149473f,	0.92721885f,	0.81262708f,	1.0512857f,	1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		
							1.26f,		1.26f,		1.26f,		1.1467814f,	1.0131826f,	0.90711004f,	0.81770629f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.82704854f,	1.0166014f,	1.2003248f,	
							1.2016704f,	1.0472132f,	0.92362517f,	0.8078649f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.89757115f,	1.0443652f,	1.1831371f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.2404966f,	1.226367f,	
							1.2287724f,	1.223058f,	1.1695373f,	1.1292651f,	1.0702422f,	0.96692592f,	0.96692592f,	0.99395496f };
float COLOR_135_110[71]	= { 1.0402648f,	1.0402648f,	1.0402648f,	1.0402648f,	0.9288547f,	0.9288547f,	0.9288547f,	
							0.90169001f,	0.90169001f,	1.0003462f,	0.90693218f,	1.0171721f,	0.97543412f,	0.91973215f,	
							0.86256438f,	0.79612881f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.82225895f,	0.84583306f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.80314553f,	0.825122f,	0.82577235f,	0.82158899f,	
							0.81514698f,	0.84100527f,	0.89222193f,	0.88660526f,	0.85831517f,	0.86586368f,	0.84102261f,	
							0.86726952f,	0.89460015f,	0.80968457f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f };
float COLOR_090_110[71]	= { 0.9383601f,	0.9383601f,	0.9383601f,	0.9383601f,	1.0755285f,	1.0755285f,	1.0755285f,	
							0.98411781f,	0.98411781f,	1.0241666f,	0.87535268f,	0.97889137f,	1.2534994f,	1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.233322f,	1.1852934f,	1.0953486f,	
							1.0236902f,	0.98883402f,	0.92739761f,	0.9255684f,	0.97202152f,	1.030863f,	1.1947373f,	
							1.26f,		1.26f,		1.218715f,	1.2225702f,	1.1719567f,	1.0976481f,	1.0299088f,	
							0.98753756f,	0.99518955f,	1.0115879f,	0.97977269f,	0.99019438f,	1.0341145f,	1.0767646f,	
							1.1670161f,	1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		
							1.26f,		1.26f,		1.26f,		1.26f,		1.1744785f,	1.0516917f,	1.0516917f,	0.97151875f };
float COLOR_060_030[71]	= { 0.92212301f,	0.92212301f,	0.92212301f,	0.92212301f,	1.1108547f,	1.1108547f,	1.1108547f,	
							1.1948091f,	1.1948091f,	1.26f,		1.1219938f,	1.0496904f,	0.90018034f,	1.0997185f,	
							1.1820639f,	1.26f,		1.1002132f,	0.98295653f,	1.0519516f,	1.1632811f,	1.26f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		
							1.26f,		1.26f,		1.26f,		1.26f,		1.1482208f,	0.95546353f,	0.81616014f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	0.79365081f,	
							0.79365081f,	0.79365081f,	0.79365081f,	0.80474436f,	0.87647426f,	0.93920386f,	0.99611974f,	
							0.97187245f,	0.93501246f,	0.95474315f,	1.0320153f,	1.1006937f,	1.1356862f,	1.1986256f,	
							1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f,		1.26f		};


/* TABLE : SPATIAL COLORATION FILTERS FOR HORIZONTAL CHANNELS, ERB bands for STFT */
float COLOR_180_110_StftErb[58]	= {	1.257512901000000f,  1.158560317000000f,  0.975947998000000f,  0.812670539000000f,  0.793650794000000f,  0.793650794000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.839215000000000f,  0.895853000000000f,  0.921032000000000f,  0.915816000000000f,  0.907476000000000f,  0.902366000000000f,
                                    0.900041000000000f,  0.903678000000000f,  0.895045000000000f,  0.827595000000000f,  0.816390000000000f,  0.793651000000000f,
                                    0.848212000000000f,  0.843676000000000f,  0.807275000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f };
float COLOR_090_030_StftErb[58]	= { 1.016393000000000f,  0.940154000000000f,  0.924468000000000f,  1.019364000000000f,  1.163062000000000f,  1.255373000000000f,
                                    1.221591000000000f,  1.164189000000000f,  1.151248000000000f,  1.174002000000000f,  1.235628000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.222760000000000f,  1.160128000000000f,
                                    1.089699000000000f,  1.037545000000000f,  0.986758000000000f,  0.929318000000000f,  0.883289000000000f,  0.858581000000000f,
                                    0.849521000000000f,  0.850360000000000f,  0.867297000000000f,  0.902004000000000f,  0.943387000000000f,  0.977346000000000f,
                                    1.008207000000000f,  1.043796000000000f,  1.063373000000000f,  1.056064000000000f,  1.075206000000000f,  1.002088000000000f,
                                    0.893956000000000f,  0.944609000000000f,  1.002863000000000f,  1.199923000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  0.922395000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.976107000000000f,  1.153876000000000f,  1.260000000000000f,  1.260000000000000f };
float COLOR_060_110_StftErb[58]	= { 0.975283000000000f,  1.020111000000000f,  1.052661000000000f,  1.034273000000000f,  1.007329000000000f,  1.010088000000000f,
                                    1.044259000000000f,  1.060160000000000f,  1.028108000000000f,  0.966481000000000f,  0.915263000000000f,  0.914371000000000f,
                                    0.942626000000000f,  0.931554000000000f,  0.880058000000000f,  0.825000000000000f,  0.814011000000000f,  0.864691000000000f,
                                    0.936597000000000f,  0.997666000000000f,  1.042468000000000f,  1.071918000000000f,  1.103262000000000f,  1.176045000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.119248000000000f,  0.912938000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  1.102116000000000f,
                                    1.092848000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  1.114079000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.231165000000000f,  0.976335000000000f };
float COLOR_135_110_StftErb[58]	= { 1.057872000000000f,  1.025689000000000f,  0.972375000000000f,  0.940191000000000f,  0.931031000000000f,  0.925814000000000f,
                                    0.911691000000000f,  0.895357000000000f,  0.894999000000000f,  0.915049000000000f,  0.954878000000000f,  0.998400000000000f,
                                    1.002731000000000f,  0.959758000000000f,  0.919532000000000f,  0.906200000000000f,  0.917664000000000f,  0.949673000000000f,
                                    0.993391000000000f,  1.029246000000000f,  1.031808000000000f,  1.001631000000000f,  0.968710000000000f,  0.959278000000000f,
                                    0.972360000000000f,  0.976487000000000f,  0.950306000000000f,  0.916408000000000f,  0.910758000000000f,  0.928637000000000f,
                                    0.934616000000000f,  0.908980000000000f,  0.866561000000000f,  0.794462000000000f,  0.807225000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.836434000000000f,  0.793651000000000f,
                                    0.793651000000000f,  0.815618000000000f,  0.818016000000000f,  0.899999000000000f,  0.856971000000000f,  0.802702000000000f,
                                    0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f };
float COLOR_090_110_StftErb[58]	= { 0.967818000000000f,  1.000571000000000f,  1.036720000000000f,  1.045700000000000f,  1.043259000000000f,  1.048451000000000f,
                                    1.054614000000000f,  1.033851000000000f,  0.988836000000000f,  0.963343000000000f,  1.003832000000000f,  1.075405000000000f,
                                    1.061876000000000f,  0.946306000000000f,  0.851115000000000f,  0.840038000000000f,  0.892063000000000f,  0.941460000000000f,
                                    0.956656000000000f,  0.960650000000000f,  0.976646000000000f,  1.011122000000000f,  1.066606000000000f,  1.143043000000000f,
                                    1.234495000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.186579000000000f,  1.047277000000000f,  0.958699000000000f,  0.937138000000000f,  1.092959000000000f,
                                    1.260000000000000f,  1.207313000000000f,  1.021066000000000f,  1.008149000000000f,  1.047784000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.067507000000000f };
float COLOR_060_030_StftErb[58]	= { 1.024233000000000f,  0.958515000000000f,  0.938683000000000f,  1.008225000000000f,  1.123006000000000f,  1.209438000000000f,
                                    1.209597000000000f,  1.193814000000000f,  1.196971000000000f,  1.177826000000000f,  1.126607000000000f,  1.132111000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.115775000000000f,  1.065528000000000f,
                                    1.066851000000000f,  1.077524000000000f,  1.053261000000000f,  0.985194000000000f,  0.913645000000000f,  0.883370000000000f,
                                    0.901514000000000f,  0.939630000000000f,  0.976639000000000f,  1.021141000000000f,  1.085708000000000f,  1.146713000000000f,
                                    1.170319000000000f,  1.167112000000000f,  1.176141000000000f,  1.260000000000000f,  1.229941000000000f,  1.094809000000000f,
                                    0.991888000000000f,  1.054892000000000f,  1.176083000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,  1.260000000000000f,
                                    1.260000000000000f,  1.260000000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,  0.793651000000000f,
                                    0.992957000000000f,  1.034704000000000f,  1.260000000000000f,  1.260000000000000f };


/* TABLE : REQUIRED OUTPUT CHANNELS FOR ELEVATION RENDERING FOR isPossibleElev */
/* bool REQOUT[13][6]	= { { 1, 1, 1, 0, 1, 1 },	// CH_U_000
						{ 1, 1, 0, 0, 1, 1 },	// CH_U_L045
						{ 1, 1, 0, 0, 1, 1 },	// CH_U_R045
						{ 1, 1, 0, 0, 1, 1 },	// CH_U_L030
						{ 1, 1, 0, 0, 1, 1 },	// CH_U_R030
						{ 1, 0, 0, 0, 1, 1 },	// CH_U_L090
						{ 0, 1, 0, 0, 1, 1 },	// CH_U_R090
						{ 1, 0, 0, 0, 1, 1 },	// CH_U_L110
						{ 0, 1, 0, 0, 1, 1 },	// CH_U_R110
						{ 1, 0, 0, 0, 1, 1 },	// CH_U_L135
						{ 0, 1, 0, 0, 1, 1 },	// CH_U_R135
						{ 1, 1, 0, 0, 1, 1 },	// CH_U_180
						{ 1, 1, 1, 0, 1, 1 } }; // IAR_CH_T_000
						*/
/* TABLE : INITIAL SPATIAL LOCALIZATION PANNING COEFFICIENTS G_VH */
float GVH[13][6]	= { { 0.49146774f,	0.49146774f,	0.34746769f,	0.0f, 	0.44507593f,	0.44507593f },	/* CH_U_0000 */
						{ 0.70918131f,	0.27444959f,	0.0f,			0.0f,	0.56982642f,	0.31150770f },	/* CH_U_L045 */
						{ 0.27444959f,	0.70918131f,	0.0f,			0.0f,	0.31150770f,	0.56982642f },	/* CH_U_R045 */
						{ 0.70918131f,	0.27444959f,	0.0f,		 	0.0f,	0.56982642f,	0.31150770f },	/* CH_U_L030 */
						{ 0.27444959f,	0.70918131f,	0.0f,		 	0.0f,	0.31150770f,	0.56982642f },	/* CH_U_R030 */
						{ 0.56040317f,	0.0f,			0.0f,		 	0.0f,	0.81550622f,	0.14456093f },	/* CH_U_L090 */
						{ 0.0f,			0.56040317f,	0.0f, 			0.0f,	0.14456093f,	0.81550622f },	/* CH_U_R090 */
						{ 0.34278116f,	0.0f,		 	0.0f,		 	0.0f,	0.91200900f,	0.22525696f },	/* CH_U_L110 */
						{ 0.0f, 			0.34278116f,	0.0f,		 	0.0f,	0.22525696f,	0.91200900f },	/* CH_U_R110 */
						{ 0.34278116f,	0.0f,		 	0.0f,		 	0.0f,	0.91200900f,	0.22525696f },	/* CH_U_L135 */
						{ 0.0f, 			0.34278116f,	0.0f,		 	0.0f,	0.22525696f,	0.91200900f },	/* CH_U_R135 */
						{ 0.22851810f,	0.22851810f,	0.0f,		 	0.0f,	0.66916323f,	0.66916323f },	/* CH_U_180 */
						{ 0.45328009f,	0.45328009f,	0.33519593f,	0.0f,	0.48822021f,	0.48822021f } };	/* IAR_CH_T_000 */

/* TABLE : INITIAL SPATIAL LOCALIZATION PANNING COEFFICIENTS G_VL */
float GVL[13][6]	= { { 0.61940062f,	0.61940062f,	0.43791625f,	0.0f,	0.0f,			0.0f		   },	/* CH_U_000 */
						{ 1.0f,			0.0f,			0.0f,			0.0f,	0.0f,			0.0f		   },	/* CH_U_L045 */
						{ 0.0f,			1.0f,			0.0f,			0.0f,	0.0f,			0.0f		   },	/* CH_U_R045 */
						{ 1.0f,			0.0f,			0.0f,			0.0f,	0.0f,			0.0f		   },	/* CH_U_L030 */
						{ 0.0f,			1.0f,			0.0f,			0.0f,	0.0f,			0.0f		   },	/* CH_U_R030 */
						{ 0.36730000f,	0.0f,			0.0f,			0.0f,	0.93010002f,	0.0f		   },	/* CH_U_L090 */
						{ 0.0f,			0.36730000f,	0.0f,			0.0f,	0.0f,			0.93010002f },	/* CH_U_R090 */
						{ 0.0f,			0.0f,			0.0f,			0.0f,	1.0f,			0.0f		   },	/* CH_U_L110 */
						{ 0.0f,			0.0f,			0.0f,			0.0f,	0.0f,			1.0f		   },	/* CH_U_R110 */
						{ 0.34278116f,	0.0f,			0.0f,			0.0f,	0.91200900f,	0.22525696f },	/* CH_U_L135 */
						{ 0.0f,			0.34278116f,	0.0f,			0.0f,	0.22525696f,	0.91200900f },	/* CH_U_R135 */
                        { 0.22851810f,	0.22851810f,	0.0f,		 	0.0f, 	0.66916323f,	0.66916323f },	/* CH_U_180 */
						{ 0.45328009f,	0.45328009f,	0.33519593f,	0.0f,	0.48822021f,	0.48822021f } };	/* IAR_CH_T_000 */



/* TABLE : SPATIAL ELEVATION FILTER INITIAL VALUES (FOR THE 35 DEGREE IN ELEVATION */
float EQVF[71]	= {	0.841395f,	0.841395f,	0.874312f,	0.874312f,	0.926119f,	0.926119f,	0.944061f,	
					0.944061f,	0.944061f,	0.908518f,	0.908518f,	0.944061f,	0.944061f,	0.944061f,	
					0.980995f,	0.980995f,	0.980995f,	0.980995f,	0.887153f,	0.875087f,	0.933012f,	
					0.922109f,	0.912036f,	0.902688f,	0.893979f,	0.885822f,	0.878166f,	0.90502f,	
					0.897936f,	0.7943f,	0.788618f,	0.783206f,	0.778048f,	0.773116f,	0.659052f,	
					0.655171f,	0.651447f,	0.647865f,	0.644418f,	0.641096f,	0.637889f,	0.634793f,
					0.631798f,	0.628901f,	0.626093f,	0.623373f,	0.620731f,	0.618168f,	0.615676f,	
					0.613254f,	0.610896f,	0.608602f,	0.606366f,	0.604187f,	0.602061f,	0.599987f,	
					0.597962f,	0.595984f,	0.594051f,	0.592162f,	0.590313f,	0.588505f,	0.586734f,	
					0.585001f,	0.583302f,	0.581638f,	0.580006f,	0.578407f,	0.576837f,	0.575697f,	0.573327f };
float EQVB[71]	= { 0.819093f,	0.819093f,	0.922571f,	0.922571f,	0.980995f,	0.980995f,	0.887837f,	
					0.887837f,	0.887837f,	0.958665f,	0.958665f,	0.936843f,	0.936843f,	0.936843f,	
					0.962351f,	0.962351f,	0.962351f,	0.962351f,	0.916638f,	0.899232f,	0.863327f,	
					0.849236f,	0.836276f,	0.824301f,	0.816315f,	0.805907f,	0.796173f,	0.802272f,	
					0.793493f,	0.785196f,	0.777344f,	0.738062f,	0.731266f,	0.724785f,	0.545115f,	
					0.540626f,	0.536328f,	0.532204f,	0.528244f,	0.524436f,	0.520767f,	0.517232f,	
					0.513818f,	0.510523f,	0.507335f,	0.504251f,	0.501262f,	0.498367f,	0.495557f,	
					0.49283f,	0.490179f,	0.487604f,	0.485097f,	0.482659f,	0.480282f,	0.477968f,	
					0.475711f,	0.47351f,	0.47136f,	0.469263f,	0.467213f,	0.465211f,	0.463252f,	
					0.461338f,	0.459463f,	0.45763f,	0.455833f,	0.454074f,	0.45235f,	0.451098f,	0.448501f };
float EQVFC[71]	= { 0.68508532f,	0.68508532f,	0.71188768f,	0.71188768f,	0.83f,		0.83f,		0.76867877f,	
					0.76867877f,	0.76867877f,	0.76867877f,	0.76867877f,	0.79875133f,	0.79875133f,	0.79875133f,	
					0.83f,		0.83f,		0.83f,		0.83f,		0.72234319f,	0.71251848f,	0.7596824f,	
					0.75080472f,	0.74260266f,	0.73499156f,	0.72790004f,	0.72125921f,	0.71502508f,	0.7368906f,	
					0.7311221f,	0.64673932f,	0.6421129f,	0.63770643f,	0.63350663f,	0.62949109f,	0.53661741f,	
					0.53345677f,	0.53042478f,	0.52750816f,	0.52470193f,	0.52199696f,	0.51938578f,	0.51686507f,	
					0.5144257f,	0.51206767f,	0.50978102f,	0.50756575f,	0.50541522f,	0.5033286f,	0.50129925f,	
					0.49932717f,	0.49740738f,	0.49553988f,	0.49371886f,	0.49194432f,	0.49021294f,	0.48852472f,	
					0.48687551f,	0.48526614f,	0.48369163f,	0.48215364f,	0.48064802f,	0.4791756f,	0.47773389f,	
					0.47632289f,	0.47493928f,	0.47358472f,	0.47225589f,	0.47095362f,	0.46967542f,	0.46874665f,	0.46681773f };
float EQVBC[71]	= { 0.770312f,	0.770312f,	0.940445f,	0.940445f,	1.015469f,	1.015469f,	1.0f,	
					1.0f,			1.0f,			0.887837f,	0.887837f,	0.838172f,	0.838172f,	0.838172f,	
					0.922571f,	0.922571f,	0.922571f,	0.922571f,	0.916638f,	0.899232f,	0.830823f,	
					0.817263f,	0.804791f,	0.793266f,	0.813189f,	0.802821f,	0.793123f,	0.78401f,	
					0.775431f,	0.815915f,	0.807755f,	0.710275f,	0.703734f,	0.697497f,	0.483973f,	
					0.479988f,	0.476172f,	0.47251f,	0.468995f,	0.465614f,	0.462356f,	0.459218f,	
					0.456187f,	0.453261f,	0.450431f,	0.447693f,	0.445039f,	0.442469f,	0.439974f,	
					0.437553f,	0.435199f,	0.432913f,	0.430687f,	0.428522f,	0.426412f,	0.424358f,	
					0.422354f,	0.4204f,		0.418491f,	0.416629f,	0.414809f,	0.413032f,	0.411293f,	
					0.409593f,	0.407929f,	0.406301f,	0.404705f,	0.403144f,	0.401613f,	0.400502f,	0.398196f };
float EQVOG[71]	= { 0.62528018f,	0.62528018f,	0.62528018f,	0.62528018f,	0.67516235f,	0.67516235f,	0.72902365f,	
					0.72902365f,	0.72902365f,	0.70157643f,	0.70157643f,	0.72902365f,	0.72902365f,	0.72902365f,	
					0.64974255f,	0.64974255f,	0.64974255f,	0.64974255f,	0.63446387f,	0.62583427f,	0.66726037f,	
					0.65946291f,	0.65225907f,	0.64557314f,	0.61527373f,	0.60966047f,	0.60439092f,	0.64724144f,	
					0.6421749f,	0.56805749f,	0.56399394f,	0.53903577f,	0.53548544f,	0.53209122f,	0.48977268f,	
					0.48688833f,	0.48412123f,	0.48145865f,	0.47889724f,	0.47642896f,	0.39127933f,	0.38937988f,	
					0.38754274f,	0.3857659f,	0.38404333f,	0.38237503f,	0.3807543f,	0.37918248f,	0.37765354f,	
					0.37616815f,	0.37472162f,	0.37331462f,	0.37194246f,	0.37060648f,	0.36930199f,	0.36803033f,	
					0.36678748f,	0.36557478f,	0.36438888f,	0.36322978f,	0.36209614f,	0.36098729f,	0.35990055f,	
					0.35883726f,	0.35779541f,	0.356775f,	0.35577402f,	0.35479247f,	0.35382968f,	0.3531302f,	0.35167697f };
float EQVS[71]	= { 0.877674f,	0.877674f,	0.901571f,	0.901571f,	1.0f,			1.0f,			0.905038f,	
					0.905038f,	0.905038f,	1.039122f,	1.039122f,	1.023293f,	1.023293f,	1.023293f,	
					0.940445f,	0.940445f,	0.940445f,	0.940445f,	0.9525f,	0.934412f,	0.917998f,	
					0.903015f,	0.889235f,	0.876501f,	0.864685f,	0.853661f,	0.843349f,	0.866273f,	
					0.856795f,	0.815915f,	0.807755f,	0.769886f,	0.762797f,	0.756036f,	0.566441f,	
					0.561776f,	0.557311f,	0.553025f,	0.54891f,	0.544953f,	0.54114f,	0.537467f,	
					0.53392f,	0.530496f,	0.527183f,	0.523978f,	0.520873f,	0.517864f,	0.514944f,	
					0.51211f,	0.509356f,	0.50668f,	0.504075f,	0.501541f,	0.499072f,	0.496667f,	
					0.494321f,	0.492034f,	0.489801f,	0.487622f,	0.485492f,	0.483411f,	0.481376f,	
					0.479386f,	0.477439f,	0.475533f,	0.473666f,	0.471838f,	0.470046f,	0.468746f,	0.466048f };
float EQBTM[71]	= { 0.922571f,	0.922571f,	1.143756f,	1.143756f,	1.117721f,	1.117721f,	1.023293f,	
					1.023293f,	1.023293f,	0.922571f,	0.922571f,	0.940445f,	0.940445f,	0.940445f,	
					0.940445f,	0.940445f,	0.940445f,	0.940445f,	0.829592f,	0.813839f,	0.883436f,	
					0.869017f,	0.855756f,	0.843501f,	0.922978f,	0.91121f,	0.900203f,	0.93538f,	
					0.925145f,	1.003794f,	0.993756f,	0.84093f,	0.833186f,	0.825802f,	0.691546f,	
					0.685851f,	0.6804f,	0.675167f,	0.670144f,	0.665313f,	0.660658f,	0.656173f,	
					0.651843f,	0.647662f,	0.643618f,	0.639706f,	0.635914f,	0.632241f,	0.628675f,	
					0.625216f,	0.621853f,	0.618586f,	0.615406f,	0.612313f,	0.609298f,	0.606362f,	
					0.603498f,	0.600706f,	0.59798f,	0.595319f,	0.592718f,	0.590178f,	0.587694f,	
					0.585265f,	0.582887f,	0.58056f,	0.578281f,	0.57605f,	0.573862f,	0.572275f,	0.56898f };
float EQVBA[71]	= { 0.877674f,	0.877674f,	0.988553f,	0.988553f,	1.051155f,	1.051155f,	0.951335f,	
					0.951335f,	0.951335f,	1.027228f,	1.027228f,	0.860994f,	0.860994f,	0.860994f,	
					0.992354f,	0.992354f,	0.992354f,	0.992354f,	0.90963f,	0.892357f,	0.856726f,	
					0.842743f,	0.829882f,	0.817998f,	0.874698f,	0.863545f,	0.853114f,	0.917603f,	
					0.907563f,	0.918991f,	0.909801f,	0.790848f,	0.783566f,	0.776621f,	0.584101f,	
					0.579291f,	0.574686f,	0.570266f,	0.566024f,	0.561943f,	0.558012f,	0.554224f,	
					0.550566f,	0.547035f,	0.543619f,	0.540315f,	0.537112f,	0.53401f,	0.530998f,	
					0.528077f,	0.525236f,	0.522477f,	0.519791f,	0.517178f,	0.514632f,	0.512152f,	
					0.509733f,	0.507375f,	0.505072f,	0.502825f,	0.500628f,	0.498483f,	0.496384f,	
					0.494332f,	0.492324f,	0.490359f,	0.488434f,	0.486549f,	0.484701f,	0.48336f,	0.480578f };


/* TABLE : SPATIAL ELEVATION FILTER INITIAL VALUES (FOR THE 35 DEGREE IN ELEVATION f, ERB bands for STFT */
float EQVF_StftErb[58]	= { 0.841395000000000f,  0.841395000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.944061000000000f,
                            0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.908518000000000f,
                            0.908518000000000f,  0.908518000000000f,  0.908518000000000f,  0.908518000000000f,  0.908518000000000f,  0.908518000000000f,
                            0.908518000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,
                            0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.980995000000000f,  0.980995000000000f,
                            0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,
                            0.929311000000000f,  0.881628000000000f,  0.870100000000000f,  0.926766000000000f,  0.913913000000000f,  0.902215000000000f,
                            0.889454000000000f,  0.876028000000000f,  0.897706000000000f,  0.789863000000000f,  0.779856000000000f,  0.660004000000000f,
                            0.650985000000000f,  0.641943000000000f,  0.632968000000000f,  0.624467000000000f,  0.616092000000000f,  0.607606000000000f,
                            0.599370000000000f,  0.591397000000000f,  0.583481000000000f,  0.576447000000000f };
float EQVB_StftErb[58]	= { 0.819093000000000f,  0.819093000000000f,  0.922571000000000f,  0.980995000000000f,  0.980995000000000f,  0.887837000000000f,
                            0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.958665000000000f,
                            0.958665000000000f,  0.958665000000000f,  0.958665000000000f,  0.958665000000000f,  0.958665000000000f,  0.958665000000000f,
                            0.958665000000000f,  0.936843000000000f,  0.936843000000000f,  0.936843000000000f,  0.936843000000000f,  0.936843000000000f,
                            0.936843000000000f,  0.936843000000000f,  0.936843000000000f,  0.936843000000000f,  0.962351000000000f,  0.962351000000000f,
                            0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,
                            0.892125000000000f,  0.908657000000000f,  0.892065000000000f,  0.855247000000000f,  0.838687000000000f,  0.826864000000000f,
                            0.810537000000000f,  0.793461000000000f,  0.793209000000000f,  0.779063000000000f,  0.733647000000000f,  0.546217000000000f,
                            0.535796000000000f,  0.525406000000000f,  0.515151000000000f,  0.505491000000000f,  0.496025000000000f,  0.486487000000000f,
                            0.477280000000000f,  0.468415000000000f,  0.459661000000000f,  0.451922000000000f };
#if SAMSUNG
float EQVFC_StftErb[58]	= { 0.685085320000000f,	0.685085320000000f,  0.830000000000000f,  0.830000000000000f,  0.830000000000000f,  0.768678770000000f,
							0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,
							0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,  0.768678770000000f,
							0.768678770000000f,  0.798751330000000f,  0.798751330000000f,  0.798751330000000f,  0.798751330000000f,  0.798751330000000f, 
							0.798751330000000f,  0.798751330000000f,  0.798751330000000f,  0.798751330000000f,  0.830000000000000f,  0.830000000000000f,
							0.830000000000000f,  0.830000000000000f,  0.830000000000000f,  0.830000000000000f,  0.830000000000000f,  0.830000000000000f,
							0.786271450000000f,  0.717844590000000f,  0.708457290000000f,  0.754596160000000f,  0.744131520000000f,  0.734606440000000f,
							0.724215670000000f,  0.713284570000000f,  0.730935350000000f,  0.643126330000000f,  0.634979050000000f,  0.537391800000000f,
							0.530048790000000f,  0.522685860000000f,  0.515378540000000f,  0.508457170000000f,  0.501637890000000f,  0.494728970000000f,
							0.488022570000000f,  0.481530310000000f,  0.475085360000000f,  0.469358360000000f };
#else
float EQVFC_StftErb[58]	= { 0.825404000000000f,  0.825404000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  0.926119000000000f,
                            0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,
                            0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,
                            0.926119000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,
                            0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  0.962351000000000f,  1.000000000000000f,  1.000000000000000f,
                            1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,
                            0.947315000000000f,  0.864873000000000f,  0.853563000000000f,  0.909152000000000f,  0.896544000000000f,  0.885068000000000f,
                            0.872549000000000f,  0.859379000000000f,  0.880645000000000f,  0.774851000000000f,  0.765035000000000f,  0.647460000000000f,
                            0.638613000000000f,  0.629742000000000f,  0.620938000000000f,  0.612599000000000f,  0.604383000000000f,  0.596059000000000f,
                            0.587979000000000f,  0.580157000000000f,  0.572392000000000f,  0.565492000000000f };
#endif
float EQVBC_StftErb[58]	= { 0.770312000000000f,  0.770312000000000f,  0.940445000000000f,  1.015469000000000f,  1.015469000000000f,  1.000000000000000f,
                            1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  1.000000000000000f,  0.887837000000000f,
                            0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.887837000000000f,  0.887837000000000f,
                            0.887837000000000f,  0.838172000000000f,  0.838172000000000f,  0.838172000000000f,  0.838172000000000f,  0.838172000000000f,
                            0.838172000000000f,  0.838172000000000f,  0.838172000000000f,  0.838172000000000f,  0.922571000000000f,  0.922571000000000f,
                            0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,
                            0.855249000000000f,  0.908657000000000f,  0.892065000000000f,  0.823047000000000f,  0.807111000000000f,  0.823697000000000f,
                            0.807432000000000f,  0.790422000000000f,  0.775153000000000f,  0.809542000000000f,  0.706025000000000f,  0.484952000000000f,
                            0.475700000000000f,  0.466475000000000f,  0.457370000000000f,  0.448794000000000f,  0.440390000000000f,  0.431921000000000f,
                            0.423747000000000f,  0.415876000000000f,  0.408104000000000f,  0.401233000000000f };
#if SAMSUNG
float EQVOG_StftErb[58]	= { 0.625280180000000f,  0.625280180000000f,  0.625280180000000f,  0.675162350000000f,  0.675162350000000f,  0.729023650000000f,
							0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.701576430000000f,
							0.701576430000000f,  0.701576430000000f,  0.701576430000000f,  0.701576430000000f,  0.701576430000000f,  0.701576430000000f,
							0.701576430000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,
							0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.729023650000000f,  0.649742550000000f,  0.649742550000000f,
							0.649742550000000f,  0.649742550000000f,  0.649742550000000f,  0.649742550000000f,  0.649742550000000f,  0.649742550000000f,
							0.615511580000000f,  0.630512880000000f,  0.622267190000000f,  0.662793480000000f,  0.653601080000000f,  0.620942600000000f,
							0.612159570000000f,  0.602919600000000f,  0.642010750000000f,  0.564885040000000f,  0.536730300000000f,  0.490480200000000f,
							0.483778190000000f,  0.477058090000000f,  0.388260310000000f,  0.383046370000000f,  0.377908810000000f,  0.372703580000000f,
							0.367651780000000f,  0.362760780000000f,  0.357905960000000f,  0.353590490000000f };
#else
float EQVOG_StftErb[58]	= { 0.933254000000000f,  0.933254000000000f,  0.933254000000000f,  1.007705000000000f,  1.007705000000000f,  1.088095000000000f,
                            1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.047129000000000f,
                            1.047129000000000f,  1.047129000000000f,  1.047129000000000f,  1.047129000000000f,  1.047129000000000f,  1.047129000000000f,
                            1.047129000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,
                            1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  1.088095000000000f,  0.969765000000000f,  0.969765000000000f,
                            0.969765000000000f,  0.969765000000000f,  0.969765000000000f,  0.969765000000000f,  0.969765000000000f,  0.969765000000000f,
                            0.918674000000000f,  0.941064000000000f,  0.928757000000000f,  0.989244000000000f,  0.975524000000000f,  0.926780000000000f,
                            0.913671000000000f,  0.899880000000000f,  0.958225000000000f,  0.843112000000000f,  0.801090000000000f,  0.732060000000000f,
                            0.722057000000000f,  0.712027000000000f,  0.579493000000000f,  0.571711000000000f,  0.564043000000000f,  0.556274000000000f,
                            0.548734000000000f,  0.541434000000000f,  0.534188000000000f,  0.527747000000000f };
#endif
float EQVS_StftErb[58]	= { 0.877674000000000f,  0.877674000000000f,  0.901571000000000f,  1.000000000000000f,  1.000000000000000f,  0.905038000000000f,
                            0.905038000000000f,  0.905038000000000f,  0.905038000000000f,  0.905038000000000f,  0.905038000000000f,  1.039122000000000f,
                            1.039122000000000f,  1.039122000000000f,  1.039122000000000f,  1.039122000000000f,  1.039122000000000f,  1.039122000000000f,
                            1.039122000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,
                            1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  0.940445000000000f,  0.940445000000000f,
                            0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,
                            0.871818000000000f,  0.944205000000000f,  0.926965000000000f,  0.909407000000000f,  0.891798000000000f,  0.875859000000000f,
                            0.858564000000000f,  0.840476000000000f,  0.856488000000000f,  0.809542000000000f,  0.765280000000000f,  0.567586000000000f,
                            0.556758000000000f,  0.545961000000000f,  0.535305000000000f,  0.525267000000000f,  0.515431000000000f,  0.505519000000000f,
                            0.495952000000000f,  0.486740000000000f,  0.477644000000000f,  0.469602000000000f };
float EQBTM_StftErb[58]	= { 0.922571000000000f,  0.922571000000000f,  1.143756000000000f,  1.117721000000000f,  1.117721000000000f,  1.023293000000000f,
                            1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  1.023293000000000f,  0.922571000000000f,
                            0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,  0.922571000000000f,
                            0.922571000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,
                            0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,
                            0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,  0.940445000000000f,
                            0.871818000000000f,  0.822369000000000f,  0.807353000000000f,  0.875168000000000f,  0.858223000000000f,  0.934905000000000f,
                            0.916444000000000f,  0.897137000000000f,  0.924814000000000f,  0.995954000000000f,  0.835899000000000f,  0.692945000000000f,
                            0.679725000000000f,  0.666543000000000f,  0.653533000000000f,  0.641279000000000f,  0.629270000000000f,  0.617170000000000f,
                            0.605490000000000f,  0.594243000000000f,  0.583138000000000f,  0.573319000000000f };
#if SAMSUNG
float EQVBA_StftErb[58]	= { 0.877674000000000f,  0.877674000000000f,  0.988553000000000f,  1.051155000000000f,  1.051155000000000f,  0.951335000000000f, 
							0.951335000000000f,  0.951335000000000f,  0.951335000000000f,  0.951335000000000f,  0.951335000000000f,  1.027228000000000f, 
							1.027228000000000f,  1.027228000000000f,  1.027228000000000f,  1.027228000000000f,  1.027228000000000f,  1.027228000000000f, 
							1.027228000000000f,  0.860994000000000f,  0.860994000000000f,  0.860994000000000f,  0.860994000000000f,  0.860994000000000f, 
							0.860994000000000f,  0.860994000000000f,  0.860994000000000f,  0.860994000000000f,  0.992354000000000f,  0.992354000000000f, 
							0.992354000000000f,  0.992354000000000f,  0.992354000000000f,  0.992354000000000f,  0.992354000000000f,  0.992354000000000f, 
							0.919939000000000f,  0.901709000000000f,  0.885244000000000f,  0.848708000000000f,  0.832275000000000f,  0.886001000000000f, 
							0.868506000000000f,  0.850208000000000f,  0.907238000000000f,  0.911813000000000f,  0.786116000000000f,  0.585282000000000f, 
							0.574116000000000f,  0.562982000000000f,  0.551994000000000f,  0.541644000000000f,  0.531501000000000f,  0.521280000000000f, 
							0.511415000000000f,  0.501916000000000f,  0.492536000000000f,  0.484243000000000f };
#else
float EQVBA_StftErb[58]	= { 0.908518000000000f,  0.908518000000000f,  0.926119000000000f,  0.926119000000000f,  0.926119000000000f,  0.944061000000000f,
                            0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,
                            0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,  0.944061000000000f,
                            0.944061000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,
                            0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  0.980995000000000f,  1.019374000000000f,  1.019374000000000f,
                            1.019374000000000f,  1.019374000000000f,  1.019374000000000f,  1.019374000000000f,  1.019374000000000f,  1.019374000000000f,
                            0.944987000000000f,  0.857827000000000f,  0.842164000000000f,  0.892123000000000f,  0.874849000000000f,  0.859213000000000f,
                            0.842247000000000f,  0.824503000000000f,  0.840210000000000f,  0.735483000000000f,  0.722471000000000f,  0.608180000000000f,
                            0.596577000000000f,  0.585007000000000f,  0.573589000000000f,  0.562834000000000f,  0.552294000000000f,  0.541674000000000f,
                            0.531423000000000f,  0.521552000000000f,  0.511805000000000f,  0.503188000000000f };
#endif

int	is4GVH[71];
int	is4GVH_StftErb[58];
int topIn[13];
int midOut[6];
int D2;
int	   elv;
