/***********************************************************************************
 
 This software module was originally developed by 
 
 Fraunhofer IIS
 
 in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
 performance may not have been optimized. This software module is an implementation
 of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
 you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
 and make derivative works of this software module or modifications  thereof for use
 in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
 and which satisfy any specified conformance criteria. Those intending to use this 
 software module in products are advised that its use may infringe existing patents. 
 ISO/IEC have no liability for use of this software module or modifications thereof. 
 Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
 standard.
 
 Fraunhofer IIS retains full right to modify and use the code for its own purpose,
 assign or donate the code to a third party and to inhibit third parties from using 
 the code for products that do not conform to MPEG-related ITU Recommendations and/or 
 ISO/IEC International Standards.
 
 This copyright notice must be included in all copies or derivative works. 
 
 Copyright (c) ISO/IEC 2013.
 
 ***********************************************************************************/

/*
 *  File formatConverter_main.h
 *  of formatConverter cmdl app.
 *  
 */   

/**************************************************************************************************************************************************************************************/

#include "iarFormatConverter_api.h"
#include "gVBAPRenderer.h"

int iarReadAngleDeviationsFromFile( char* filename, float *azimuthDeviation, float *elevationDeviation, int numOutputChans );
int iarReadDistancesFromFile( char* filename, float *distance, int numOutputChans );
int iarReadDmxMtxFromFile( char* filename, float **dmxMtx, int numInputChans, int numOutputChans );
int iarReadEqParamsFromFile( char *filename, int numCh, int *numEQs, iar_eqParamsStruct **eqParams, int **eqMap );
const char *iarFormatConverterCmdlGetInfo( void );
int FormatConverterFrame(FILE * fpR3T, int* rendering3DType);

/*
static float trim_5_1[7] = {
	0.5, *//* relative radii */
	/*1.0,
	2.0,
	1.0,
	0.8,
	1.3,
	34.0*/ /* reference radius [m] */
/*};*/

static float iarF_bands_nrm_77[77] = {
	0.002083300000000f,
	0.005875000000000f,
	0.009791700000000f,
	0.013542000000000f,
	0.016917000000000f,
	0.020083000000000f,
	0.004583300000000f,
	0.000833330000000f,
	0.032792000000000f,
	0.014000000000000f,
	0.019708000000000f,
	0.027208000000000f,
	0.035333000000000f,
	0.042833000000000f,
	0.048417000000000f,
	0.029625000000000f,
	0.056750000000000f,
	0.072375000000000f,
	0.088000000000000f,
	0.103620000000000f,
	0.119250000000000f,
	0.134870000000000f,
	0.150500000000000f,
	0.166120000000000f,
	0.181750000000000f,
	0.197370000000000f,
	0.213000000000000f,
	0.228620000000000f,
	0.244250000000000f,
	0.259880000000000f,
	0.275500000000000f,
	0.291130000000000f,
	0.306750000000000f,
	0.322380000000000f,
	0.338000000000000f,
	0.353630000000000f,
	0.369250000000000f,
	0.384880000000000f,
	0.400500000000000f,
	0.416130000000000f,
	0.431750000000000f,
	0.447380000000000f,
	0.463000000000000f,
	0.478630000000000f,
	0.494250000000000f,
	0.509870000000000f,
	0.525500000000000f,
	0.541120000000000f,
	0.556750000000000f,
	0.572370000000000f,
	0.588000000000000f,
	0.603620000000000f,
	0.619250000000000f,
	0.634870000000000f,
	0.650500000000000f,
	0.666120000000000f,
	0.681750000000000f,
	0.697370000000000f,
	0.713000000000000f,
	0.728620000000000f,
	0.744250000000000f,
	0.759870000000000f,
	0.775500000000000f,
	0.791120000000000f,
	0.806750000000000f,
	0.822370000000000f,
	0.838000000000000f,
	0.853620000000000f,
	0.869250000000000f,
	0.884870000000000f,
	0.900500000000000f,
	0.916120000000000f,
	0.931750000000000f,
	0.947370000000000f,
	0.963000000000000f,
	0.974540000000000f,
	0.999040000000000f
};

/**************************************************************************************************************************************************************************************/

static float iarF_bands_nrm_71[71] = {
	0.004583300000000f,
	0.000833330000000f,
	0.002083300000000f,
	0.005875000000000f,
	0.009791700000000f,
	0.014292000000000f,
	0.019792000000000f,
	0.027000000000000f,
	0.035417000000000f,
	0.042625000000000f,
	0.056750000000000f,
	0.072375000000000f,
	0.088000000000000f,
	0.103620000000000f,
	0.119250000000000f,
	0.134870000000000f,
	0.150500000000000f,
	0.166120000000000f,
	0.181750000000000f,
	0.197370000000000f,
	0.213000000000000f,
	0.228620000000000f,
	0.244250000000000f,
	0.259880000000000f,
	0.275500000000000f,
	0.291130000000000f,
	0.306750000000000f,
	0.322380000000000f,
	0.338000000000000f,
	0.353630000000000f,
	0.369250000000000f,
	0.384880000000000f,
	0.400500000000000f,
	0.416130000000000f,
	0.431750000000000f,
	0.447380000000000f,
	0.463000000000000f,
	0.478630000000000f,
	0.494250000000000f,
	0.509870000000000f,
	0.525500000000000f,
	0.541120000000000f,
	0.556750000000000f,
	0.572370000000000f,
	0.588000000000000f,
	0.603620000000000f,
	0.619250000000000f,
	0.634870000000000f,
	0.650500000000000f,
	0.666120000000000f,
	0.681750000000000f,
	0.697370000000000f,
	0.713000000000000f,
	0.728620000000000f,
	0.744250000000000f,
	0.759870000000000f,
	0.775500000000000f,
	0.791120000000000f,
	0.806750000000000f,
	0.822370000000000f,
	0.838000000000000f,
	0.853620000000000f,
	0.869250000000000f,
	0.884870000000000f,
	0.900500000000000f,
	0.916120000000000f,
	0.931750000000000f,
	0.947370000000000f,
	0.963000000000000f,
	0.974540000000000f,
	0.999040000000000f
};

/**************************************************************************************************************************************************************************************/

static float iarF_bands_nrm_64[64] = {
	0.0078125000000000f,
	0.0234380000000000f,
	0.0390620000000000f,
	0.0546880000000000f,
	0.0703120000000000f,
	0.0859380000000000f,
	0.1015600000000000f,
	0.1171900000000000f,
	0.1328100000000000f,
	0.1484400000000000f,
	0.1640600000000000f,
	0.1796900000000000f,
	0.1953100000000000f,
	0.2109400000000000f,
	0.2265600000000000f,
	0.2421900000000000f,
	0.2578100000000000f,
	0.2734400000000000f,
	0.2890600000000000f,
	0.3046900000000000f,
	0.3203100000000000f,
	0.3359400000000000f,
	0.3515600000000000f,
	0.3671900000000000f,
	0.3828100000000000f,
	0.3984400000000000f,
	0.4140600000000000f,
	0.4296900000000000f,
	0.4453100000000000f,
	0.4609400000000000f,
	0.4765600000000000f,
	0.4921900000000000f,
	0.5078100000000000f,
	0.5234400000000000f,
	0.5390600000000000f,
	0.5546900000000000f,
	0.5703100000000000f,
	0.5859400000000000f,
	0.6015600000000000f,
	0.6171900000000000f,
	0.6328100000000000f,
	0.6484400000000000f,
	0.6640600000000000f,
	0.6796900000000000f,
	0.6953100000000000f,
	0.7109400000000000f,
	0.7265600000000000f,
	0.7421900000000000f,
	0.7578100000000000f,
	0.7734400000000000f,
	0.7890600000000000f,
	0.8046900000000000f,
	0.8203100000000000f,
	0.8359400000000000f,
	0.8515600000000000f,
	0.8671900000000000f,
	0.8828100000000000f,
	0.8984400000000000f,
	0.9140600000000000f,
	0.9296900000000000f,
	0.9453100000000000f,
	0.9609400000000000f,
	0.9765600000000000f,
	0.9921900000000000f
};

/**************************************************************************************************************************************************************************************/

static float iarF_bands_nrm_stft_erb_58[58]={
	0.000000000000000f,
	0.003891050583658f,
	0.007782101167315f,
	0.011673151750973f,
	0.015564202334630f,
	0.019455252918288f,
	0.023346303501946f,
	0.027237354085603f,
	0.031128404669261f,
	0.035019455252918f,
	0.038910505836576f,
	0.042801556420233f,
	0.046692607003891f,
	0.050583657587549f,
	0.054474708171206f,
	0.058365758754864f,
	0.062256809338521f,
	0.066147859922179f,
	0.070038910505837f,
	0.073929961089494f,
	0.077821011673152f,
	0.081712062256809f,
	0.085603112840467f,
	0.089494163424125f,
	0.093385214007782f,
	0.097276264591440f,
	0.101167315175097f,
	0.105058365758755f,
	0.108949416342412f,
	0.112840466926070f,
	0.116731517509728f,
	0.120622568093385f,
	0.124513618677043f,
	0.132295719844358f,
	0.143968871595331f,
	0.157587548638132f,
	0.173151750972763f,
	0.188715953307393f,
	0.204280155642023f,
	0.221789883268482f,
	0.241245136186770f,
	0.260700389105058f,
	0.284046692607004f,
	0.311284046692607f,
	0.338521400778210f,
	0.365758754863813f,
	0.394941634241245f,
	0.428015564202335f,
	0.464980544747082f,
	0.505836575875486f,
	0.550583657587549f,
	0.597276264591440f,
	0.647859922178988f,
	0.704280155642023f,
	0.764591439688716f,
	0.828793774319066f,
	0.898832684824903f,
	0.966926070038911f
};

/**************************************************************************************************************************************************************************************/

static int iar_erb_freq_idx_256_58[58] = {
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	36,
	39,
	43,
	47,
	51,
	55,
	60,
	65,
	70,
	77,
	84,
	91,
	98,
	106,
	115,
	125,
	136,
	148,
	160,
	174,
	189,
	205,
	222,
	241,
	257
};

static float iar_stftWindow_512[512] = {
	0.003067956762966f,
	0.009203754782060f,
	0.015339206284988f,
	0.021474080275470f,
	0.027608145778966f,
	0.033741171851378f,
	0.039872927587740f,
	0.046003182130915f,
	0.052131704680283f,
	0.058258264500436f,
	0.064382630929857f,
	0.070504573389614f,
	0.076623861392031f,
	0.082740264549376f,
	0.088853552582525f,
	0.094963495329639f,
	0.101069862754828f,
	0.107172424956809f,
	0.113270952177564f,
	0.119365214810991f,
	0.125454983411546f,
	0.131540028702883f,
	0.137620121586486f,
	0.143695033150294f,
	0.149764534677322f,
	0.155828397654265f,
	0.161886393780112f,
	0.167938294974731f,
	0.173983873387464f,
	0.180022901405700f,
	0.186055151663447f,
	0.192080397049892f,
	0.198098410717954f,
	0.204108966092817f,
	0.210111836880470f,
	0.216106797076220f,
	0.222093620973204f,
	0.228072083170886f,
	0.234041958583543f,
	0.240003022448742f,
	0.245955050335795f,
	0.251897818154217f,
	0.257831102162159f,
	0.263754678974831f,
	0.269668325572915f,
	0.275571819310958f,
	0.281464937925758f,
	0.287347459544730f,
	0.293219162694259f,
	0.299079826308040f,
	0.304929229735402f,
	0.310767152749611f,
	0.316593375556166f,
	0.322407678801070f,
	0.328209843579093f,
	0.333999651442009f,
	0.339776884406827f,
	0.345541324963989f,
	0.351292756085567f,
	0.357030961233430f,
	0.362755724367397f,
	0.368466829953372f,
	0.374164062971458f,
	0.379847208924051f,
	0.385516053843919f,
	0.391170384302254f,
	0.396809987416710f,
	0.402434650859418f,
	0.408044162864979f,
	0.413638312238435f,
	0.419216888363224f,
	0.424779681209109f,
	0.430326481340083f,
	0.435857079922255f,
	0.441371268731717f,
	0.446868840162374f,
	0.452349587233771f,
	0.457813303598877f,
	0.463259783551860f,
	0.468688822035828f,
	0.474100214650550f,
	0.479493757660153f,
	0.484869248000791f,
	0.490226483288291f,
	0.495565261825773f,
	0.500885382611241f,
	0.506186645345155f,
	0.511468850437970f,
	0.516731799017650f,
	0.521975292937154f,
	0.527199134781901f,
	0.532403127877198f,
	0.537587076295645f,
	0.542750784864516f,
	0.547894059173100f,
	0.553016705580027f,
	0.558118531220556f,
	0.563199344013834f,
	0.568258952670131f,
	0.573297166698042f,
	0.578313796411656f,
	0.583308652937698f,
	0.588281548222645f,
	0.593232295039800f,
	0.598160706996342f,
	0.603066598540348f,
	0.607949784967774f,
	0.612810082429410f,
	0.617647307937804f,
	0.622461279374150f,
	0.627251815495144f,
	0.632018735939809f,
	0.636761861236284f,
	0.641481012808583f,
	0.646176012983316f,
	0.650846684996381f,
	0.655492852999615f,
	0.660114342067420f,
	0.664710978203345f,
	0.669282588346636f,
	0.673829000378756f,
	0.678350043129861f,
	0.682845546385248f,
	0.687315340891759f,
	0.691759258364158f,
	0.696177131491463f,
	0.700568793943248f,
	0.704934080375905f,
	0.709272826438866f,
	0.713584868780794f,
	0.717870045055732f,
	0.722128193929215f,
	0.726359155084346f,
	0.730562769227828f,
	0.734738878095963f,
	0.738887324460615f,
	0.743007952135122f,
	0.747100605980180f,
	0.751165131909686f,
	0.755201376896537f,
	0.759209188978388f,
	0.763188417263381f,
	0.767138911935820f,
	0.771060524261814f,
	0.774953106594874f,
	0.778816512381476f,
	0.782650596166576f,
	0.786455213599086f,
	0.790230221437310f,
	0.793975477554337f,
	0.797690840943391f,
	0.801376171723140f,
	0.805031331142964f,
	0.808656181588175f,
	0.812250586585204f,
	0.815814410806734f,
	0.819347520076797f,
	0.822849781375826f,
	0.826321062845664f,
	0.829761233794523f,
	0.833170164701913f,
	0.836547727223512f,
	0.839893794195999f,
	0.843208239641845f,
	0.846490938774052f,
	0.849741768000852f,
	0.852960604930364f,
	0.856147328375194f,
	0.859301818357008f,
	0.862423956111041f,
	0.865513624090569f,
	0.868570705971341f,
	0.871595086655951f,
	0.874586652278176f,
	0.877545290207261f,
	0.880470889052161f,
	0.883363338665732f,
	0.886222530148881f,
	0.889048355854665f,
	0.891840709392343f,
	0.894599485631383f,
	0.897324580705418f,
	0.900015892016160f,
	0.902673318237259f,
	0.905296759318119f,
	0.907886116487666f,
	0.910441292258067f,
	0.912962190428398f,
	0.915448716088268f,
	0.917900775621390f,
	0.920318276709110f,
	0.922701128333879f,
	0.925049240782678f,
	0.927362525650401f,
	0.929640895843181f,
	0.931884265581668f,
	0.934092550404259f,
	0.936265667170278f,
	0.938403534063108f,
	0.940506070593268f,
	0.942573197601447f,
	0.944604837261480f,
	0.946600913083284f,
	0.948561349915730f,
	0.950486073949482f,
	0.952375012719766f,
	0.954228095109106f,
	0.956045251349996f,
	0.957826413027533f,
	0.959571513081985f,
	0.961280485811321f,
	0.962953266873684f,
	0.964589793289813f,
	0.966190003445413f,
	0.967753837093476f,
	0.969281235356549f,
	0.970772140728950f,
	0.972226497078936f,
	0.973644249650812f,
	0.975025345066994f,
	0.976369731330021f,
	0.977677357824510f,
	0.978948175319062f,
	0.980182135968117f,
	0.981379193313755f,
	0.982539302287441f,
	0.983662419211730f,
	0.984748501801904f,
	0.985797509167567f,
	0.986809401814185f,
	0.987784141644572f,
	0.988721691960324f,
	0.989622017463201f,
	0.990485084256457f,
	0.991310859846115f,
	0.992099313142192f,
	0.992850414459865f,
	0.993564135520595f,
	0.994240449453188f,
	0.994879330794806f,
	0.995480755491927f,
	0.996044700901252f,
	0.996571145790555f,
	0.997060070339483f,
	0.997511456140303f,
	0.997925286198596f,
	0.998301544933893f,
	0.998640218180265f,
	0.998941293186857f,
	0.999204758618364f,
	0.999430604555462f,
	0.999618822495179f,
	0.999769405351215f,
	0.999882347454213f,
	0.999957644551964f,
	0.999995293809576f,
	0.999995293809576f,
	0.999957644551964f,
	0.999882347454213f,
	0.999769405351215f,
	0.999618822495179f,
	0.999430604555462f,
	0.999204758618364f,
	0.998941293186857f,
	0.998640218180265f,
	0.998301544933893f,
	0.997925286198596f,
	0.997511456140303f,
	0.997060070339483f,
	0.996571145790555f,
	0.996044700901252f,
	0.995480755491927f,
	0.994879330794806f,
	0.994240449453188f,
	0.993564135520595f,
	0.992850414459865f,
	0.992099313142192f,
	0.991310859846115f,
	0.990485084256457f,
	0.989622017463201f,
	0.988721691960324f,
	0.987784141644572f,
	0.986809401814186f,
	0.985797509167567f,
	0.984748501801904f,
	0.983662419211730f,
	0.982539302287441f,
	0.981379193313755f,
	0.980182135968117f,
	0.978948175319062f,
	0.977677357824510f,
	0.976369731330021f,
	0.975025345066994f,
	0.973644249650812f,
	0.972226497078936f,
	0.970772140728950f,
	0.969281235356549f,
	0.967753837093476f,
	0.966190003445413f,
	0.964589793289813f,
	0.962953266873684f,
	0.961280485811321f,
	0.959571513081985f,
	0.957826413027533f,
	0.956045251349997f,
	0.954228095109106f,
	0.952375012719766f,
	0.950486073949482f,
	0.948561349915730f,
	0.946600913083284f,
	0.944604837261480f,
	0.942573197601447f,
	0.940506070593268f,
	0.938403534063108f,
	0.936265667170278f,
	0.934092550404259f,
	0.931884265581668f,
	0.929640895843181f,
	0.927362525650401f,
	0.925049240782678f,
	0.922701128333879f,
	0.920318276709111f,
	0.917900775621391f,
	0.915448716088268f,
	0.912962190428398f,
	0.910441292258067f,
	0.907886116487666f,
	0.905296759318119f,
	0.902673318237259f,
	0.900015892016160f,
	0.897324580705418f,
	0.894599485631383f,
	0.891840709392343f,
	0.889048355854665f,
	0.886222530148881f,
	0.883363338665732f,
	0.880470889052161f,
	0.877545290207261f,
	0.874586652278176f,
	0.871595086655951f,
	0.868570705971341f,
	0.865513624090569f,
	0.862423956111041f,
	0.859301818357008f,
	0.856147328375195f,
	0.852960604930364f,
	0.849741768000853f,
	0.846490938774052f,
	0.843208239641845f,
	0.839893794196000f,
	0.836547727223512f,
	0.833170164701913f,
	0.829761233794523f,
	0.826321062845664f,
	0.822849781375826f,
	0.819347520076797f,
	0.815814410806734f,
	0.812250586585204f,
	0.808656181588175f,
	0.805031331142964f,
	0.801376171723140f,
	0.797690840943391f,
	0.793975477554337f,
	0.790230221437310f,
	0.786455213599086f,
	0.782650596166576f,
	0.778816512381476f,
	0.774953106594874f,
	0.771060524261814f,
	0.767138911935820f,
	0.763188417263381f,
	0.759209188978388f,
	0.755201376896536f,
	0.751165131909687f,
	0.747100605980180f,
	0.743007952135122f,
	0.738887324460615f,
	0.734738878095964f,
	0.730562769227828f,
	0.726359155084346f,
	0.722128193929215f,
	0.717870045055732f,
	0.713584868780794f,
	0.709272826438866f,
	0.704934080375905f,
	0.700568793943248f,
	0.696177131491463f,
	0.691759258364158f,
	0.687315340891759f,
	0.682845546385248f,
	0.678350043129861f,
	0.673829000378756f,
	0.669282588346636f,
	0.664710978203345f,
	0.660114342067420f,
	0.655492852999616f,
	0.650846684996381f,
	0.646176012983317f,
	0.641481012808583f,
	0.636761861236284f,
	0.632018735939809f,
	0.627251815495144f,
	0.622461279374150f,
	0.617647307937804f,
	0.612810082429410f,
	0.607949784967774f,
	0.603066598540348f,
	0.598160706996342f,
	0.593232295039800f,
	0.588281548222645f,
	0.583308652937699f,
	0.578313796411656f,
	0.573297166698042f,
	0.568258952670132f,
	0.563199344013834f,
	0.558118531220556f,
	0.553016705580028f,
	0.547894059173100f,
	0.542750784864516f,
	0.537587076295646f,
	0.532403127877198f,
	0.527199134781901f,
	0.521975292937155f,
	0.516731799017650f,
	0.511468850437971f,
	0.506186645345155f,
	0.500885382611241f,
	0.495565261825773f,
	0.490226483288291f,
	0.484869248000791f,
	0.479493757660153f,
	0.474100214650550f,
	0.468688822035828f,
	0.463259783551860f,
	0.457813303598877f,
	0.452349587233771f,
	0.446868840162374f,
	0.441371268731717f,
	0.435857079922256f,
	0.430326481340083f,
	0.424779681209109f,
	0.419216888363224f,
	0.413638312238435f,
	0.408044162864979f,
	0.402434650859419f,
	0.396809987416710f,
	0.391170384302254f,
	0.385516053843919f,
	0.379847208924051f,
	0.374164062971458f,
	0.368466829953373f,
	0.362755724367397f,
	0.357030961233430f,
	0.351292756085567f,
	0.345541324963989f,
	0.339776884406827f,
	0.333999651442009f,
	0.328209843579093f,
	0.322407678801070f,
	0.316593375556166f,
	0.310767152749612f,
	0.304929229735403f,
	0.299079826308041f,
	0.293219162694259f,
	0.287347459544730f,
	0.281464937925758f,
	0.275571819310958f,
	0.269668325572915f,
	0.263754678974832f,
	0.257831102162159f,
	0.251897818154217f,
	0.245955050335795f,
	0.240003022448742f,
	0.234041958583544f,
	0.228072083170886f,
	0.222093620973204f,
	0.216106797076219f,
	0.210111836880470f,
	0.204108966092817f,
	0.198098410717954f,
	0.192080397049892f,
	0.186055151663447f,
	0.180022901405700f,
	0.173983873387464f,
	0.167938294974731f,
	0.161886393780112f,
	0.155828397654265f,
	0.149764534677321f,
	0.143695033150295f,
	0.137620121586486f,
	0.131540028702883f,
	0.125454983411546f,
	0.119365214810992f,
	0.113270952177564f,
	0.107172424956809f,
	0.101069862754828f,
	0.094963495329639f,
	0.088853552582525f,
	0.082740264549376f,
	0.076623861392032f,
	0.070504573389614f,
	0.064382630929858f,
	0.058258264500436f,
	0.052131704680284f,
	0.046003182130915f,
	0.039872927587740f,
	0.033741171851378f,
	0.027608145778966f,
	0.021474080275470f,
	0.015339206284988f,
	0.009203754782060f,
	0.003067956762966f
};


