/***********************************************************************************

This software module was originally developed by 

Qualcomm Technologies, Inc. (QTI)

in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
performance may not have been optimized. This software module is an implementation
of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
and make derivative works of this software module or modifications  thereof for use
in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
and which satisfy any specified conformance criteria. Those intending to use this 
software module in products are advised that its use may infringe existing patents. 
ISO/IEC have no liability for use of this software module or modifications thereof. 
Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
standard.

Qualcomm Technologies retains full right to modify and use the code for its own purpose,
assign or donate the code to a third party and to inhibit third parties from using 
the code for products that do not conform to MPEG-related ITU Recommendations and/or 
ISO/IEC International Standards.

This copyright notice must be included in all copies or derivative works. 

Copyright (c) ISO/IEC 2013.

***********************************************************************************/

#ifndef __DSHTSCRNADAPTPOSITIONS_H__
#define __DSHTSCRNADAPTPOSITIONS_H__

double grid_9_phi[9] = {0, 0, -1.95667942727269, 1.9566815253489953, -1.9566791599152682, -3.1415917540819702, 1.9566812507671485, 0.68712379101387899, -0.68712087708857106};
double grid_9_theta[9] = {0, 2.3610733150061671, 1.2075889335853642, 1.2075889894841485, 2.4151776845598061, 1.561038501933844, 2.4151783625562291, 1.3256677641026944, 1.3256665421238991};
double grid_16_phi[16] = {0, 0, 1.1199072143842541, -0.25283206761953059, 1.1555864736912382, 2.0404806503273885, -1.3811807642374985, 0.27069230802673072, -2.2041727525805497, 2.2972674270043059, -2.8029312950237175, 3.0109557927046922, 2.1549186720308278, -0.63528835273694195, -1.4197304618717392, -2.4680925715206734};
double grid_16_theta[16] = {0, 0.85409818863632792, 2.0319685423894973, 2.6051062661793396, 1.0786216554390071, 1.7366084406133893, 2.031967715462581, 1.7366087405865966, 1.568880335483622, 0.91708666721662102, 0.91708666818899376, 1.7634756450513951, 2.649852440772297, 1.5688805497050156, 0.9539624791512642, 2.4581224958506436};
double grid_25_phi[25] = {0, 0, -2.0075880138492339, 1.9276369669112781, -1.4120839053194234, -2.100006175493637, 2.512927496453961, 1.6676331498289434, 1.4423830639369737, -0.60062073466117805, 0.3299675689448513, -1.1862145332794831, 2.9833320914282715, -2.6922159250284547, 0.50760153771871175, 2.2089772698907897, 0.95231919226543216, -1.71564542075923, 0.93440177618880027, -0.38653513687375668, 2.6759584547436308, -2.6284169845585934, 0.16501224362526468, -1.0250435815649399, -3.131208441254711};
double grid_25_theta[25] = {0, 0.82321774533319825, 1.7391204894633929, 0.72429674273994771, 1.3362806270693923, 0.87163113546364468, 1.263704711105748, 1.4401469137149676, 2.2483127283141995, 1.4339531375235086, 2.8880647673355835, 2.0039138515816148, 1.8026603024380241, 1.3965540912954197, 2.1707813063132386, 1.9528050527151923, 1.5801904155369548, 2.5846089646347332, 0.87459739681912019, 2.1729351879335654, 2.6127174117549123, 2.193906731524593, 1.5167401797043514, 0.71530725725824373, 0.76255325423626896};
double grid_36_phi[36] = {0, 0, -1.1966599630554615, 0.18406599747336536, 0.12428154683222747, -2.8402248036352944, -1.8470115638029652, 0.69875799446836151, 2.2802386851449756, -2.2848211828079643, -2.3756882382539866, 2.8834109929535341, -1.1850355599101792, -2.7684633546114035, 0.76348760519111825, -0.46491378554963514, -2.2750418313703262, 1.7621377896639376, 2.8044856040751931, -1.6917545089558328, -1.0320973553955308, 0.50941535981159136, -1.957373233655417, -0.56700308640883235, 2.319618678324856, 2.8532333761406887, -3.07101272740625, 2.113131633677114, -1.5087705028191181, -0.65403737076662594, 1.4642266112564566, 1.373127114428192, 1.1127512868348539, 2.1139494380902688, 0.057137211221880833, 1.4579253900608249};
double grid_36_theta[36] = {0, 2.0248960467929242, 1.2470569949639712, 2.7461774883429015, 0.62357491034199319, 1.7644942598534343, 1.0705154639359444, 2.2343247596267686, 2.1841279974690817, 2.1588391544043852, 0.62415080735382789, 1.2374850299974198, 0.60342237761283968, 1.1339418738436677, 1.0606552024629443, 1.6346070038425577, 1.5225300519923401, 1.7191884713200647, 0.6250605684627718, 1.6965725988019149, 1.8123138763277964, 1.6346198179431879, 2.811188384822044, 1.028623912176994, 1.5271492719422461, 1.861841365253325, 2.4118972956904865, 2.7846870527727492, 2.2774222120121914, 2.3454208825407692, 2.2782405356547186, 0.57995443337421126, 1.6934602576430546, 0.97218159855797581, 1.2641064461429883, 1.1888624055652925};
double grid_49_phi[49] = {0, 0, 3.0244540295069258, 2.0806419072027, -2.2137335040588226, -2.0359769150607856, 1.6780136740229217, 0.96436344160653853, -3.03551866605995, -2.7020642933121772, 0.58105480421465494, -2.801031471006719, 0.55013631783060124, -1.9843616809284499, -0.51211612191747757, -1.1411043928840654, -2.4876472822134241, -1.6228231892197291, -0.57506334264306236, 2.2862036370291512, -0.087406301767844502, 0.54702847519489795, 1.8789653676082025, 2.7467165444607504, -0.76025011091500028, -1.0197847569940277, 1.1621070501253024, 1.5071478802928686, 1.0627057289674062, -2.6813494967255509, -1.0837693899817351, 2.9135198453440339, 2.9390986540873132, -1.5396600257997648, 0.47323777576517545, -1.9552169119553673, 1.2949937100575726, 0.88793611146402718, 2.4275482063873759, -0.016077637698628695, 1.9719898613754872, -1.3534124149206748, 2.6511833626108405, -0.57647016923299355, 1.8575170656023261, -0.77915520916058723, -2.0112146620977085, 3.0877677327523765, -0.0044579564567208147};
double grid_49_theta[49] = {0, 0.8506515960037816, 1.8791606902778986, 1.5023646989725044, 2.0664725571308979, 1.589574625721184, 1.1447526696496846, 1.8305375728214783, 1.3914764723718234, 1.8204139579839311, 0.49661252037226933, 2.3519677386905151, 1.1129471902374708, 1.046844962404661, 1.5770416969685599, 2.3593026947179574, 1.3426145681626067, 1.9889060655238218, 2.0834838827321027, 0.99865641810413541, 2.4383718273750548, 2.1955953954905851, 2.0174830039258453, 2.3604629882853478, 0.52303252920748711, 1.323604390764497, 0.85065262571219746, 1.6526145926803086, 1.3447562275825364, 0.86170768497892591, 1.8198915940128007, 0.99683746647575333, 0.50167544005999321, 1.4354149966276353, 1.628299859672282, 2.5461652166561266, 2.2368324607541208, 2.7177182231902481, 1.9278664727342714, 1.3701543106230316, 2.5358800774004604, 0.88912967353356787, 1.4583622126352138, 1.0423212330346345, 0.56716857332897597, 2.8467699115236123, 0.51969383289437121, 2.885875037016489, 1.8974895482919498};
double grid_64_phi[64] = {0, 0, 2.7997548961872059, -2.4084549958552781, -2.7276503160256742, 0.23457943374352078, 1.5038137228962218, 2.5667587057064587, 1.1717034100327393, 2.3712371835680628, -2.853099240686082, -0.23972489775428762, 0.98712643568300362, 3.0269646990513603, -0.41923243283141121, -1.70918852166369, -0.33656925315043679, -1.6550944330257462, -1.4435415211563125, 0.67566648547789221, -0.55697820730345571, 1.0910182028259436, 2.8366193950588339, 0.94063485125190527, -2.9398325070297791, 0.13421723375174344, 1.8025226385356672, -1.1259847551045683, -1.8223892354060249, 2.2232656532265871, -1.0983273568850667, 1.6856638584436514, -1.901103278601213, 2.4698365912121378, -0.87690611912869765, 0.15640926899633228, 2.5781172925546363, -2.7380184138242929, -0.91878021427992385, 0.60312574637159022, -0.66644477378086153, 1.607162397218312, -0.21063525603898253, 1.9165743595957265, 2.8820279363652013, 0.70671459288609184, 2.0581640396594967, -2.8478974969554067, -0.53458513232393823, -1.1734302858362571, -1.3617234550398067, 1.0997234790746595, -2.2703452160085478, -2.5015623544027354, 1.450028295802815, 0.54206697434387796, 2.3362311919865824, -2.2615329060498608, -1.9214295410245237, -3.0155716946391764, -1.9958355385766045, 0.46883442643152634, 1.5460205889580727, -1.7089836344374556};
double grid_64_theta[64] = {0, 0.88530886664409192, 1.3722189937109981, 2.1394893082538102, 1.710055891460363, 1.7838776416449202, 0.4399422480095232, 1.887190970416776, 2.1583954972390478, 1.4712687464362064, 0.92478110749341869, 2.6504489086304721, 1.2788520677888422, 1.77579339960542, 2.2019816286614344, 0.93880463922836177, 1.3396545256736223, 1.6077368564403001, 2.0928933978727553, 1.9911048412188994, 0.93373397605241504, 1.7110905780190631, 2.2923061144080403, 2.9284613322406807, 2.1202708892026472, 1.3363264458061384, 0.86161022338521731, 0.81324853038612532, 2.9066658899168281, 2.2743907029882831, 2.522521711232427, 2.0836334156003131, 2.4464246122931885, 0.54279086062070148, 1.2897760408002186, 2.2335410588641702, 2.7326063908507807, 2.5701017674704039, 2.0827724311248006, 1.5139744172697585, 1.6946894617606452, 2.5420704447390934, 1.7848484072954058, 1.3419743904211074, 0.9207158454583354, 2.4811861658305334, 1.8034352822854776, 0.46631191512212666, 0.4630295735877854, 1.6829667237449497, 1.2582942237528814, 0.82712547993234908, 0.8332774085172906, 1.2732799188933503, 1.2158800943932597, 1.0246176043423745, 1.0174035543162048, 1.6715550097069234, 1.9691664088170693, 1.3558627266884182, 1.3023006359369407, 0.52780100116219053, 1.6594277826130737, 0.46128038356985557};
double grid_81_phi[81] = {0, 0, -2.4427089433987188, -0.46313961981479096, 2.9799253965769381, -0.86686869096867358, -1.2308969552557039, -2.4480978061328829, 3.0242421845277434, -3.0044013008695463, 1.4307708726015826, -0.96029914143540873, 1.193679712172629, -1.6363305081309549, 0.63510559872255845, -1.2607597332603147, 2.5804798340488833, 0.13992144929421621, 1.887573700388447, 1.0156192290636523, -1.6751915456800872, 1.7787056883454746, -1.8311695176775244, 1.3334907257650963, 0.30525892850805891, -2.0077413688968062, -2.3852682780018988, 1.6835607439144955, 0.78931001509865317, 0.65851963447832118, -1.8570324597292434, -1.4537911655725637, -2.0372614085363994, 1.6308902976922606, -1.4495734644885743, -2.7201989316938442, 2.1027807287068607, 2.3417285611313243, -0.56333967058312928, -0.54291210801612377, 0.55527150812782622, -0.11864112572269692, -1.4256424482010612, 0.09361683060668867, 2.3417189720144691, -1.0271895864135787, 3.0446885715186447, 1.0633571192450344, 0.77219812843707247, 0.47498880466239429, 1.287598848805668, 2.1434728197040482, 0.54109074388413125, -3.1115936869962382, -0.37570121409885743, -0.13022553429862604, -0.90902696003089267, 2.1246278439047122, 1.6274454411805443, 2.8313995782567543, 1.2085116158788873, -1.1123348489299723, 2.8737909924849685, 1.7549325053885472, -1.5898654621704924, -0.47016427446224601, 1.2518115346915073, -0.25433331804004428, -2.3753182207978196, -2.8286890813920067, 2.6967317626391933, -2.4411445856371055, 2.535738890442246, -2.3862670760728024, 2.7597392279368775, -0.54876684866044567, -1.9669219637887627, 2.1516334256160277, -2.8142283782850592, 0.32733912469334875, -2.9000724830913223};
double grid_81_theta[81] = {0, 2.3419361742880653, 2.5944897529144129, 2.6955727683210093, 1.9848952959766331, 1.5826398337897605, 1.3558728693698994, 0.45410309067673627, 2.7501972407538195, 2.3386938762447453, 1.5285917404982057, 2.0395080190411852, 1.1442949795729429, 1.3828345019778223, 0.42211875323772086, 1.7494699242679153, 1.1862109433235153, 1.5432501416541238, 1.4919136402641122, 1.5541457181887575, 1.7796399845244937, 0.81098992591863184, 2.4086492201058989, 2.6380179383219602, 1.9182951091801284, 2.0249276667131419, 0.90994686103975009, 1.8676625116273924, 1.9037052330718867, 0.83546851238869446, 0.73632169773851497, 2.1340087913769308, 1.5697862530971418, 1.1730238983527541, 0.98828285260314874, 1.5524711725608702, 1.8431631764776346, 1.5207978418429307, 1.8448380233770989, 2.2671107573363427, 1.5662352493965745, 1.1693638122161143, 0.39974989903501457, 0.77523358276206844, 0.76039665645967902, 0.72712823576685393, 1.2421525168374274, 2.2759175512955401, 1.2207933818319199, 2.6663377743589853, 3.0645159553950352, 2.622545650626992, 2.260617734433052, 1.6203647712778833, 0.45351320199264578, 1.9610354263919212, 1.1126002557443333, 1.1450189347534399, 2.2608997689837431, 0.43022489789308582, 0.74168618671642694, 2.4545976422507492, 0.86750495599139388, 0.40706983670724406, 2.8184395458875651, 0.87973292646829049, 1.9128796362253455, 1.5760769189731105, 1.325597751476876, 1.9552624494806334, 2.3410207187280543, 2.1989146195192508, 1.9325029872918085, 1.7859490402018203, 1.5806049786423053, 1.3186797557099654, 1.1390615428205764, 2.2261995653092423, 1.1661199285908028, 1.1694672898408636, 0.77111656525235583};
double grid_100_phi[100] = {0, 0, 0.52709885465529738, 2.8005083811623859, 1.1356700750197177, 2.6923915574099415, -0.045332480357245193, -0.0103631585770891, -1.1354450798311049, -0.55285545587709539, 1.7482077112509198, -1.7285305571255343, -2.9666450719534647, 0.87939780821442104, 1.7495765709740316, 2.3218642706630179, -0.075197349711897343, -2.1924823131804141, -0.90386312673317371, 0.47831971789669064, 2.9910328566056652, -1.3118419758047843, -2.7175560242793724, -0.14725541578570525, 3.0692263110352962, -0.51791924846426374, -2.7430000561751262, -0.69781069313468813, 0.028144143203600622, -1.7029220732931816, -1.7627486923359712, 1.4585899288707782, -2.6962127843075798, -1.1098266734015279, -1.116950677337474, 1.6145784462725852, 2.1797684987793025, -1.520334926565593, -2.2461507913699923, 2.0156689967139245, -2.526833636679453, -2.9171700755417302, 2.905290244181769, -2.7335883344636303, 2.2889897632918981, 0.28299931467769862, -0.75803113963911284, -0.73016705636609547, 1.9150820280071605, 0.67265732983691096, 2.2821659553738733, 2.5653575183592543, 0.4277730876723459, -2.0457271985094758, -3.0837112606746548, -1.0739187282790765, 1.9708206223323297, -0.53709233247829002, -0.26743715882562796, -1.6578194303160732, 2.0283676762387923, -2.3036214757852447, 2.5063245026600196, 1.6566401985767782, 1.0379849719755052, 1.2491406410436623, 1.2930454350042653, 0.60850302949148183, -3.117975716115573, 1.3637350704787363, -0.41831902948601024, -1.0739655538293826, 2.6007768720313194, 1.4900191627888939, 2.2984585330564564, -2.7964438012092141, -1.8967002430570052, 0.46538096177242655, 0.98629291419640097, 0.89236815651074242, -1.4756332997098258, -2.5163865725225834, -0.4391971890434031, -1.3109752536049304, -1.653032835912962, -2.3158635351281744, -2.1275279988764968, -3.0238854063784806, -0.88332768075594048, 0.58559204733957781, -2.0955702666808387, 2.8504561952010627, 0.13695490828600279, 1.6059026141157031, 0.86882915666787341, 3.1399011363072002, 0.21861221049044524, 1.2090090358305015, 2.6136903631357402, -1.9174260399622325};
double grid_100_theta[100] = {0, 2.5486569469972773, 1.30697796548225, 1.689599959920449, 0.75280063334600389, 1.0314692231634686, 2.1800437816081315, 0.36780619796281799, 1.7657618799708181, 1.3366764903702126, 2.0934252306313956, 2.0333225085644036, 2.0372495927987444, 2.5310044040693009, 0.66742887108163995, 1.5925483863040713, 1.8001946824932329, 2.4234152394177557, 1.4500502405204565, 2.8457469883939348, 1.3424279638371583, 1.4259944274433443, 1.0637891335561731, 1.4137041205932899, 2.4045113213587714, 0.66478483242120956, 2.7072011990654339, 1.0023161971539216, 0.76340284214574061, 1.3866775054446687, 2.748993786138338, 2.3822352498472541, 2.3386466701035022, 0.76340311563313845, 2.4621003221814552, 2.7561338540493088, 2.1055239101766832, 1.7273282581605058, 0.73997834496607862, 1.7854178914052403, 2.0122904303902902, 1.3741947570739645, 2.04588111015372, 1.7086660184857039, 1.188779778875825, 1.9295349327737734, 1.7791524837049653, 2.7813099643965824, 1.0409690826565527, 2.0227456196418383, 0.41518353521738871, 2.309779874209986, 2.3158972490422718, 0.39541406476234742, 3.0681872530630621, 1.134378357893387, 1.4181968434510317, 2.396909057654717, 1.0481930234870585, 2.3831049650450953, 2.4515585994077185, 1.7097152474823354, 1.9078324731528906, 1.7067797247289718, 2.1884178173492006, 0.36607664782161553, 1.5885907261747216, 0.60113170004908256, 1.6987105064084591, 1.9634283066966687, 1.6656920618428608, 0.39607210516292701, 2.6969600787725674, 0.98562558772461772, 0.8011508626154451, 0.70921360039989767, 1.0434594995698285, 0.94164186999466981, 1.7957660923848093, 1.441784546133992, 1.0643689865830011, 1.411245230975372, 2.0372468190155404, 2.0934086549088633, 0.7083543117386315, 1.0908792061502992, 2.0634955240194901, 0.3720836417322495, 2.1222446002417241, 1.6683355655000758, 1.3901637623200322, 0.68489445065026811, 1.1691401580468308, 1.342437403598727, 1.0515355779873858, 1.0026224773749517, 1.5469858026700491, 1.2361091249388199, 1.3881199319182544, 1.7103037730776831};
double grid_121_phi[121] = {0, 0, -2.1047856016053821, -1.907889489994979, 2.5488235250910272, 1.9884994871527286, -2.6550275374619772, 3.0825013002469714, -0.68697423244565303, -2.6197361568751143, 1.019179822818062, -2.086687479336204, 0.21676919510042042, 0.2313320281678353, 0.42285103807783753, 0.13894286390984439, 2.4125611413726111, -0.095546349858238039, -2.2894945445253709, -0.95736829044367133, -1.0394926812837442, -2.6503260264371997, -1.7103282634528878, -0.97193152235560865, 3.1188456742447008, -2.106178060128479, 1.9044050378642918, -0.037021663421038936, -1.0477413388910402, -2.4633629793442342, 0.59972360579958794, -2.2574954905342071, -0.36627136739130151, 1.1715087793045027, 2.7386343021198751, -0.88849995404047932, -1.9497900750771304, -3.0003847220732265, -1.1685929188254955, 1.1999319680687663, -2.3077150656883707, -1.3890221412907588, -0.5839202845287943, 0.861641186190788, 2.7256387885654378, 0.80940221524832223, -1.8943831411899759, 1.0469908887493753, -2.1229842896422007, -0.17860844441607759, -0.30321575632768777, -2.8485008643348579, 2.1963895097333426, 2.5398942713959638, -2.8008481720077261, -1.7337948366098423, 0.57292613193088293, -2.0954998885777112, 0.096353478127152864, -2.3749329516377506, 0.88216233184895165, 2.8983448162307042, -0.18063947150003523, 2.6933712585999463, -1.5688704174680987, 0.2534120148132778, 1.8255091971008863, 1.5243584382206892, 2.9119469562333782, 2.3151385705936955, 2.1221095590340555, 1.4284803185737249, 3.0638478845907922, 2.1824120496870658, 0.63418932554181884, -1.5595217716436338, 3.0955929919683363, 1.56941626777013, -1.5493922301455145, 0.52140898441355432, -0.79273818331722645, 0.033591738027747446, -0.52528355201699961, -0.73073049067501117, 1.8807166069434251, -1.1886780947764675, 3.1244599724717723, -1.026067019358226, -0.50424180258910367, -1.3359807701310833, 1.0819587615592028, 2.0893275274886181, 0.55609020695025035, 2.1356394744641145, -0.42302142328771897, -1.5684410706583041, 0.87430908750797376, 1.5433265131555336, -0.038369321766945769, 2.5475448053883865, 1.1869919614453692, 1.806395662383367, 1.2341972499820355, -2.973240500392162, 3.1089059075950529, -2.7815675722191084, 0.55534827093079075, 1.9987095910890209, -1.2377671378322261, -1.5468137082798477, -0.44826591689161127, 1.5311331624771169, 1.0195005570661542, -1.008404471520888, 1.5031137649555553, -2.628935180003741, 3.1183313606991949, 1.5071432398482205, -2.1228183688718634, 2.2942933395964689, -2.464031978447232};
double grid_121_theta[121] = {0, 0.36731449608103617, 1.5774845504240924, 1.3095806079384125, 2.5080517321123068, 2.4431084665411742, 2.5151022020303779, 2.4423291929473407, 1.5363320680430614, 1.2435325362064917, 0.33270231430838781, 0.68866167843848836, 2.0789649377657304, 1.3826777722803072, 0.90337585420238664, 2.4272206014750983, 1.5619811724228869, 1.8798615668906853, 3.1009222645990344, 2.128818400798008, 2.7941200335083058, 1.8723035263443555, 1.5706134013208763, 2.4645808403101612, 0.35075556948878495, 2.4427516150585564, 2.0816979639450461, 1.5650830907519291, 0.6863449791695303, 2.1887112659162145, 0.60356299219344667, 1.26340017615194, 1.5723047282329006, 1.0974460195896798, 1.5504506216575822, 1.2502060139923588, 0.99695629945010178, 1.8384459612391952, 0.99476725907991825, 1.7568776477907366, 1.841294275852432, 1.5946587224201536, 2.195679819072871, 1.3386687743450407, 0.94287569390775094, 0.99795217533946889, 1.8397949820717623, 2.8606471870745818, 2.773150954076729, 1.2704599808053865, 0.94300118450506143, 2.1817153219556884, 1.8714717239303229, 0.62648388565476398, 1.5617214389631437, 2.2055899790432481, 2.2371868516373259, 2.1013972057328316, 1.0719435911393758, 0.95095725604528125, 2.0049182493196769, 1.8292537717027679, 2.1957010698444974, 2.1831995896485994, 0.59220155151669385, 1.7371513653883606, 1.7451676511358578, 0.90725304460085598, 1.2713516501191027, 0.95061513214907267, 0.35555213712301836, 2.5768768039520067, 2.1094985926398824, 1.2533075307137358, 2.5769148914803628, 0.9153394876852099, 0.67971462969376539, 2.2668461043651158, 2.5349695676644233, 1.2249714168075612, 1.8431778264148417, 0.71074439265942835, 1.2357820454697197, 0.9406943144654254, 1.0573957972955157, 1.8721080378695176, 2.7761904325833324, 1.5789342677835918, 0.62353875256871716, 2.2130909852990062, 0.74724773584710846, 1.5600009920850793, 1.554543621491828, 2.7812219040935426, 2.5131472444110337, 1.2416033205527925, 1.6695744015155025, 1.9146987896829502, 2.7825663274003594, 1.8768756601132728, 1.4321240230144681, 1.3852744520475466, 2.0844635657389561, 1.2792224928967959, 1.5517952141800295, 0.93535208056225183, 1.8907144382938674, 0.72834164798713397, 1.3079061975118231, 1.9046989455740695, 1.8866152982759137, 0.57503077994052609, 2.357006269872183, 0.33991010687015666, 1.239555986025608, 0.61599374689948694, 1.0041875452072613, 1.5775576190012695, 0.34082461356711669, 2.1925768022132219, 1.5464749855448825};
double grid_144_phi[144] = {0, 0, 2.0545826126064228, -2.5782169261032899, 1.6573274510230536, 0.44961508712468634, -1.6187837886203589, 1.9120189381557464, 0.01618429426926964, 2.6663819699674556, 2.4877365254724055, 1.3735128448847642, 1.0461519569413755, -3.060866808055033, 1.2820178151139094, 0.53680416517557583, 0.7244431348453666, -1.2903904523736793, -2.2353776169814035, -2.8756163951747613, -2.1113782811582036, 1.3201704274166275, -0.14230517194139852, -0.23584153164337127, -2.1158592157542717, -1.7359318052373465, -1.7729421304447432, 1.6969367823982073, -1.146269096915133, 0.96128904942507143, -2.939642811395788, -0.92881077390886424, 1.9653185527688493, -0.73697206240637148, 0.83337808075276232, -1.7517281705732493, -2.4524098563276553, 0.71483932043632303, 0.850508593992784, -2.3438717359047354, 2.0031386896408661, 1.4833871963547909, 2.6108775930139831, 1.315310734406391, -0.35646307995128301, 0.14428035331953132, 0.55628754069723951, -1.1827815263298977, 3.0518103764897475, -2.120563267425541, -0.28529098872038688, -0.18312762571936692, 2.2210067213418614, 0.84011982747610359, 2.2199851924408676, 1.662829350145298, -2.3027355024760929, -0.65382026486351696, -0.88584859123396131, 0.32996413261072888, 1.6517135792622295, 0.63080706274821619, -2.0410614982265773, 2.1961855953899976, -1.8693109695932379, -0.60201384335926822, -2.0571548729386011, -1.1996482138496898, 3.0822566305333745, -2.1760739931545503, 1.9654584676598159, 0.0740221418189657, -0.49693525156346896, -0.76890630675357918, -0.85397615525877069, 2.8735621913427862, -2.7821155519965557, 0.39351985357442676, 1.0719595456946622, -1.181743718647128, -1.20201323798579, -1.7742304526835846, -2.9467975917084597, -0.072920081179722568, -2.0179890871583117, 2.73396514598288, 1.9492210203850784, -0.57835398959195727, -0.29663255725049614, 3.0991248626258994, 1.5156740798376473, -2.8234458409956034, 1.4310238111483617, 2.7923318836471887, -2.7396762295842256, 2.8746419606730425, -1.441567693871757, -0.92575045465290229, -1.4687740367687085, 0.096829618795422609, 3.078269391536165, -2.3669592992251096, -2.924522464566321, -0.51045323601142134, -1.4571519518966205, -2.7309168150067351, -0.19156326335783116, 2.7842263802266332, -1.4688271274360716, -2.3751619143938365, 2.5287567629549241, 2.2041447141630268, 1.8054449933949535, 1.2594660951374907, 1.1290265192902695, -0.16060370075349145, -1.1816516988591226, 2.9867332984412789, 2.5931546393128428, 1.0841170120678201, 2.2824847257236693, 0.94190606526781961, -3.0655881177148316, 0.21182146594060952, 2.4680498933083963, -0.58335922742864676, -2.6214963713248172, -1.4837676947750995, 2.2657600671147615, -0.88476913194414131, 0.41333076994180096, -1.4532027326078161, 0.3650130292261155, 1.9761288625726738, -2.7010314601889087, 0.84219863609754375, 2.4685867318823336, 1.6734863200204348, -1.7558871620406071, 0.37522174984654216, -2.5016041464892984, 3.0392351767125381, 0.66455451968231449, -1.0426120978728519};
double grid_144_theta[144] = {0, 2.4249759618149138, 2.8599782074344584, 1.4007469425816836, 1.1898986134809717, 2.6108487413460137, 0.5402424091824245, 2.0174766477239241, 1.1911870224873404, 0.81228335251642603, 2.0511392640187665, 1.3569246151893664, 1.2674908302613268, 2.0750491297874354, 1.898833494252532, 1.4286337231988984, 2.084692366601145, 2.9385274175057168, 0.33587584584618124, 1.4463532487050417, 0.97437034451800808, 1.0676929687075818, 0.3393441098143668, 0.97914913953990823, 2.1807731834432253, 1.7719290211265752, 0.81908227948028589, 1.4985439961628433, 2.0908609226120243, 1.836206923017313, 2.9331766734830684, 0.93932849873076985, 1.0355715508981036, 2.1890080837486909, 1.5052377332945828, 1.4502703044725302, 2.1097383522550586, 1.1843469173673027, 0.62923372305875613, 1.8229680728384892, 0.302206428120388, 0.51657599979419522, 2.3543210554213396, 2.3839118243002613, 1.621092989282706, 0.88614389483495226, 0.87913240316244723, 1.7675852931085529, 0.63891922317502714, 2.717597281506575, 2.186283213940249, 0.65438782056812683, 2.5308479510703119, 2.3936375424938059, 1.5300818540350918, 1.8364862299334599, 1.5173790362184421, 1.7016958963335489, 1.2674780736293232, 0.58743316197153106, 0.87109366120872422, 2.9728163566939996, 1.8945118083125001, 2.2188682659618015, 2.4173307815654459, 1.4086874119902808, 1.293587455302651, 0.71476819071476094, 2.3938853571832412, 0.65342392183876941, 1.3488466042550045, 2.1076486158834706, 2.4428462241742386, 0.54344870470677331, 2.6688983171826433, 1.2672653421345084, 2.2994724665403492, 1.9875257443377967, 2.6915818490097818, 0.29930696681369451, 1.4494970877161315, 1.1322749255581901, 1.7412102669588396, 1.525413329174182, 1.6019828164411445, 1.8542109202831776, 1.6844585481315577, 0.80896674440070626, 1.2969051399883509, 1.4997043829378498, 2.1155867418677818, 2.6220858109180165, 1.6465416788336915, 1.5604529868970667, 1.9742036343990823, 2.1266859123120558, 0.95951574170735277, 1.573059909979925, 1.6140323828576282, 1.7855534186589048, 0.32785359205355702, 1.1787253213012354, 0.87455655741628602, 1.9583821190303479, 2.2782724704527495, 1.1312972087627124, 1.8766190110061316, 2.661869121896538, 2.6033288322786694, 2.4357899885623691, 1.4031516977127922, 1.8738744111630314, 2.3122107342144158, 0.77441676126533532, 1.5778855696788616, 2.7381643816220702, 1.1443988616322038, 0.9751747416706058, 1.1064979580445529, 2.1395937727710299, 0.88911559360878489, 0.96080361840313522, 1.1977269124049221, 1.4286719363796117, 1.7064055984455573, 1.1084780333060065, 1.6950731579256975, 1.288562278730077, 1.212010687118005, 1.9065734578678257, 2.2954037196782133, 1.9412570568215155, 1.1455401656421074, 0.66790244401021293, 0.58649169343009488, 0.31882729002936805, 0.54064311801921883, 2.5989464462103218, 2.091732931921753, 1.6837972725736239, 0.87944371116766862, 1.8098238702018898, 1.7671807416509659, 2.3862842283358865};
double grid_900_phi[900] = {0, 0, -2.9621555192955209, 0.67121197749091965, 1.0189461927000814, -1.9214492647814663, 2.1162437185140059, -3.0286947811767111, -2.6244586792973403, 1.7985622254399058, -2.9922347954728332, -1.8676361750648265, -2.1493653413936578, 1.3539821741228635, -0.43087300311065607, -0.67314115116145623, -1.7986222235999241, 2.8287401565248107, 1.7370618610481579, -2.9896739139744053, 3.0349975812091992, 0.34734811564301815, -1.1493471044489525, 3.0536796439350482, 0.36428910727539004, -2.8249535890705539, -0.048085284452274391, -1.6430435626401165, -1.6609317746155408, 0.64700293894066829, -2.1391985804273008, 1.4841308959415449, 1.6082025240109261, -0.62332180862456532, 1.9215511448477378, 0.19083406129685299, 0.099257674885199751, -1.9985789447974154, 1.5129328053183277, -0.40034424049330281, 2.5947235539986009, 2.911703466831201, -0.38473562189489996, -0.10693524225703127, -3.0911122983241803, 0.42896727711634325, 3.0500911472173726, 2.9939123185252408, -2.6416462767745035, 2.5025491846005661, -1.5676863130940042, -3.08292815817956, 2.1704214615601574, 1.4805632712659642, 0.92894621952920364, 1.5868245146741751, -2.7404782657620816, 2.3714300341199843, -2.9234951884361728, 1.0889649191538464, 0.12666478247055374, 2.7203179129824999, -0.70778428231648227, -1.0541808954953134, -2.2719532242001925, -0.71772084091848998, -2.7041872674523604, -0.75274767181355073, 1.9717406544396752, -0.26833652620671616, -0.19823526943771055, 2.4231843515390805, 2.9826543475356178, 0.92550097291212619, 1.727020897743307, 0.53488273312320089, -2.2902231744584984, -2.7741258471883223, -3.0416312866531463, -2.3331658756716678, 0.74017673356559144, -2.8422632150496514, -0.88556049204097742, 2.9519203846126887, 2.505321202911504, 2.6685443676926091, 1.7403441753012634, -0.90084234996652213, 0.059575803351821659, 2.5728812351619927, 2.7292155936826155, 2.0601172239781036, -1.8695196498915954, 1.6492525751247198, 2.1762527296938794, 1.2464595536763126, 1.9095626305118634, -1.0341792649240134, 1.1876297611789455, -0.42968277501796004, -0.11519048077478539, 2.3168297233956054, -1.2741596223579621, 3.0737131247714102, -2.5510790445782181, 2.4035663832734775, -1.7685455764086506, 1.4155538981689624, 1.137922861570605, 2.2637302484582351, 0.70752571255153351, -0.4058034422759258, 2.2100184402041037, -1.3493523628950488, 0.47728831751788287, 2.2272491590001779, 3.0384429240805351, -2.8531844574100376, 1.1335747343618567, 0.24772744120082427, 3.1007042887895628, 1.5429492571906664, 1.8258140453503973, -2.9947320207167456, -2.4810139569096634, -2.5985312023746325, -0.34816902444480702, -0.90522685475665865, -2.1506083237248803, 2.9671884039059204, 2.5251356108062537, -3.0042999191842368, -1.606751452757172, -0.16309152241198452, -1.5388441526499712, 0.23935615918687589, 0.96819258624970694, -2.566695605616018, -0.13922129348280735, 1.2727331822375851, -1.9242347484994273, -1.3115308031958073, -2.6060939190108998, 2.5040104212111616, 0.22922263989974404, 0.035054491437398395, 2.7262667508195322, 2.6374408570105645, -2.0803667503041128, -2.9800113886927018, 1.4147973430609566, -1.8945265528841029, 1.4551988467828214, -1.6949609881094883, 2.5676346900574902, 2.1092040966117791, -0.17793937861579326, 2.2443418376892925, 2.2562018905352823, 1.4050735518962791, 1.8250511895030497, 1.1861143427273753, -0.073366994283369097, 1.9867125905154059, 1.2220586669383531, -1.1794151730153959, -1.0542348714005692, -0.79650575125299639, 1.0495794092151478, 0.23956058484788625, 2.9350536773458078, 2.9860603466416484, -2.0742393204847716, -0.75464746180900444, 1.1541576017368957, -3.0174864151421383, 1.8120354311390197, -2.9506631721469203, -2.5125925782957275, 1.7055705947991922, 2.3945638519421335, -2.3479949929670831, -2.0122096183452869, 0.091829587512878633, -0.10258103939922339, -0.31911049197967023, -0.21043188479691133, 2.1963307327517416, 1.9946481877735602, 1.1806431242475439, -1.929159697912717, -0.85841307880747231, 3.0313371092280845, -3.0568372982070553, 0.70440646211671853, -2.0110874589879328, -2.5338708952929374, 0.96563868258126551, 1.8271276295054337, 0.15226424354211521, 1.6814836143695606, 0.81866129063056703, -2.7452484833935458, 1.8088186899915328, 2.9504841999534226, -1.0768941587491618, -1.656977805235178, -2.3440144257947333, 2.3703806831722898, -3.0068080287597772, -2.6441342447033698, -1.4709230310392511, 2.5157295069293131, -2.8717925046141444, 0.52824554179760508, -1.0103961634414882, -2.8287269416835032, 1.4241253613424161, 1.3814243788216989, -0.049875741132654944, 0.32443703592016487, 2.4960854921675493, -0.68259211475062909, -0.57731304227623548, -1.1218672991117558, -1.524651374484735, -0.15704531344843659, 0.77173211786128482, -1.4842316641627544, -0.90966675359072313, 0.098189866825202018, 1.3870467945659239, -2.3795415386371817, 2.5446263212283236, -3.1175986213559104, 1.6727151091614565, 1.7158747131746508, 1.0063836605319487, -2.0828196324738855, -2.2551031511456632, -1.1327082980079579, -2.3310875765432462, 1.2356670616033076, 1.3526597192828254, 1.3505737216709801, 1.6041888610549992, -2.3494721614981646, -2.3400590811226643, 1.4774110861344931, -1.179923513187481, -0.0037307483016371904, 1.5512792231157064, 0.62516792591535741, 0.43340794468265115, 0.71109385299382044, -0.05933463487735112, 3.1056517957401852, -1.7282606746274964, -2.9028111127075298, -1.8878224609520069, -1.9690190219670431, 2.7447155215211714, -1.4290753854792833, -1.1451020566580286, 2.9178223307469038, 0.66250477566129473, 0.69980180331036734, 1.9178356615483876, -2.1566477108705291, 0.73198558594407503, -2.7816461539809492, 0.59746693804729323, -1.4652871497020556, -0.033952338041558845, -0.95779842452870811, -2.4667991689251543, -2.2475903578351777, -0.51562408381627023, 0.42010865697483479, 2.091044491851155, 1.9777402652690812, -1.0948803707138757, -0.14001113817021679, 1.0167139177204687, 1.290579345488386, 0.98021934881706874, 0.45376587452661399, -2.0958418202432507, 1.822522563996033, -2.6839088916224765, -2.4681823900368465, -0.85119873860285111, 2.478219106073043, 1.2669178181486542, -1.51410352471675, -2.900961731615558, -2.1696425143194622, 2.1711163221830687, -0.25567728470121853, 0.033061358061274748, 1.5125172922531867, 1.5469300206003183, 2.792579644062259, -1.8918589574038611, 2.3943004402536765, -0.38576763636397732, -0.80105233751208305, 0.47159909867992938, 2.819827432041663, 1.6710373194268557, -1.7337140338229182, -2.0137987714814587, 2.8581276674506668, 1.8680123177415273, 1.7972687397658991, 1.6066670933159628, 1.6870368575436498, -1.27893042116575, 1.1405130142006275, 0.66932216971556624, 1.4639731687025517, -1.7655303598425698, 2.0657190012225444, -1.7723463828285941, -2.8449760088494842, -0.74027089458543427, 0.44124637913789899, 1.7403910074548485, 2.8439679442362866, -2.6813303194057876, -2.2372884403521138, -0.99640335148974457, -1.2113368149202786, -2.4390217643275975, -1.1528078017291787, -1.6494624357997767, 2.0298219979517476, -1.5499312771255305, -0.69966112738248287, 2.8011793261993811, -1.525868033473289, 1.044761553335283, -1.119221044448711, -0.5961949467453882, -2.3122028525041696, -2.0686168206537481, -1.9389216066208141, -1.7155573625844516, -1.9621905762712555, 2.4777290195216333, 0.086766872862184125, 1.8894092174480774, 2.1688264978353171, 2.4901292481684503, 2.2109748927075015, 2.8104819689609974, 2.1220212286079665, 1.2730304301854687, 0.82954546179197886, 1.8182607704911291, -0.98295289464345093, -2.9279972697379155, 1.2393663115641138, 2.9013323199337022, 2.7599571516639396, -0.51075751515139245, 2.0459136055161391, -1.821145771439675, -2.1826606474281451, -1.7796613983249057, -2.7104775521708491, -2.1592064774129072, 0.1906685185297301, 1.0691926213792291, 2.7875155518678252, 1.1434764845348302, -1.8621975366625543, -2.0475359857685591, 1.6396484445049777, 0.19755717617985491, 0.24232510025846596, 1.6064860622306656, 2.4553367419265824, -2.7201798447376793, 2.636474927589338, 2.1245493358754013, -1.8347508452047565, -1.3670460380058658, 1.5211493477653966, -0.91550722751579217, 1.5395775244089058, -1.3912413775358612, 2.4112760478657327, -2.9325420522997989, -2.1619438060503944, -2.5843220727414011, -1.4999543617587738, -2.141255237123751, 2.0611115796112607, -1.1146139805604001, 1.996930224862326, -0.5463315653392905, -0.0022142220195277792, 2.650971275678768, -1.5107578537289752, 2.6039544961422316, 0.29010137047508344, 0.48990480148982291, -0.65453434488318107, -2.9287487440470099, 0.75813700575619791, -1.2459187663383877, 1.3251618675651973, 1.6136910103000284, -0.90467569865183495, -3.1376554374757091, 2.3810606490228365, -0.29456066696338878, -2.4350976902193744, -0.11467745076189638, 0.55813170040269788, -2.3725910780008479, -0.77985145694723268, 1.8892344467226974, 1.6173823650447146, -3.1150293374030262, -0.79398939105534816, 2.5431970715307264, 2.1833304766451871, -1.3316237628411249, 2.3385597802364666, -0.32417388789038309, -2.5931344814188919, -1.212952708871641, -0.89321325188579481, -1.6743081284979267, -2.8092281663366006, -2.8333613266224376, -0.40779595833605858, -2.861354419550727, -0.25707467000200163, -0.16140444020881062, -0.2270292366843627, 0.79676738287353188, 1.8200183498721749, 1.7836097540717202, 1.4630580677903955, 1.011095323523536, 0.30236358573426614, 0.04118203020874505, 0.85874669753228794, -0.28098674115413097, 2.9190357703716465, 0.13972183739246435, -0.54818690522062419, -1.7665007250062856, -2.4070806670574409, -0.95138611890708458, 1.2197435305593456, 0.41534637658528079, 0.81606015177912294, -2.1722022279163467, -0.54779231640205939, 0.54066885319018021, -1.5585090534643917, 0.55090493300779897, -3.1278845571707246, 2.9434032299837671, 2.6704769782560058, -1.3849658203195074, -0.19113240341395515, -0.52725178563990982, -3.0928960448308067, -1.1383078982219836, 3.0902002362440069, 0.72568637947435799, 1.1535906326963641, -0.5164228473577519, -0.21947721376994922, 1.0034701153421548, 0.75080889073898249, 3.0308149327898599, 2.6908714076076734, -2.4618434291015219, 2.2737718947910754, -2.9604824823609732, -2.8167621952603286, -0.4188310495198363, 0.94486651652199694, -2.4487593735797555, -0.39295893274148441, -1.3611500341542884, -0.23690020423415231, -2.4744056549296314, 1.0342747672261501, -2.5184301845106694, 0.94433174391512942, -0.80524778816770981, 1.3494692065601117, -1.245700797585342, -0.75308118251199208, 2.0575929099138728, 2.3099079489921914, -1.3791896423322632, -1.4715908574130709, -0.033814169013510982, -1.4460536110428497, -1.3474485603929947, -1.7247313387733256, -1.4607116609349819, 2.2688717419516071, 0.44674917987020973, 0.036526733474088573, 0.17112473806656306, -1.337494062736027, 2.151090163447567, 2.0708319678433895, -2.1350026800977324, -2.8420180354982012, -2.0194173461974918, 1.9020720805556184, -1.849219850127076, 2.2610748927327302, 0.77941333971534932, -0.49506216489262006, -1.8215476748975923, -2.5192646087133905, 2.6606933116508293, -2.6653971956337408, 0.062154669163159829, 1.5310926209368059, 0.35501448353157528, -1.4800208101618597, -2.9924489185625842, -1.9891370915054603, -2.3384839538487929, -0.63372696851448684, 2.3579168126489654, 2.1242822379736879, -0.20244048739436529, 1.9944953452242664, -2.0810580035665813, 2.0767208022252315, -1.277446769591736, -1.5099412076485166, -2.7528176381559364, 1.1733600054337783, 0.9121475073100711, 3.0294166019582964, 1.286009613189619, 0.2880494547370821, 2.791831682122369, -1.4260820854015768, 2.6962584801415499, 3.009259722896747, -1.557141068590935, -2.817721586505102, -1.2310014542236907, 0.73296862311451649, 2.8450477654546567, -2.3469766843871231, -3.0241756249185512, -3.0554218880474688, 2.8048079514489501, 1.0934832484317807, -2.8950249319126922, -0.85780190009715707, 1.1395748979027418, -1.7125599954392157, -2.6352886529945945, -2.2106376928430511, 2.8804939211635423, -1.9704117063502931, 2.6779683786624546, 2.7903595345165182, 0.20593711102586668, -2.2272258213748231, -1.0070475874236753, -0.53286116403447448, 0.90723193317054673, -1.6260170984462234, -1.1999494652796283, 2.3372996418352514, 0.32974587717629361, -1.8061820738758199, -2.1476876056086058, -1.9927566696135905, -2.7370014452674307, -2.2958456384766177, -1.6855892668028813, 3.0114910461693603, -1.1362666478607912, -3.1312930798982848, 1.8598441373029582, 1.4173755415399902, -3.0598050745252712, -2.9581629804969127, -1.401243471601463, -0.01863316992538944, -0.92133092173991682, 0.8023074212727096, -1.6837299985677829, 0.9108125785099932, 2.2715983912274136, -0.063941072563974993, -0.48760228311832476, -0.77219444240327517, -0.70524477235572014, 0.68503210700118444, 2.2657878282294321, -0.63696437315821974, 1.026634375196573, 3.1307034945886656, 2.4563301730667115, 0.85671026486852053, 1.1421138016501986, 0.96821789878621256, 1.4181217210821291, -0.38727286361723345, -2.5526693627441719, 0.88688375203810355, -2.8411945320298382, 2.2687305058385308, -0.71983171849776573, 0.8501385249468697, 2.3058760991414267, 2.2835039038065625, -1.8582230489208578, 1.6727976179942847, 1.6361516535795702, -1.8766607036937337, 0.61264418560259759, -0.87666499726734948, -2.9992438348089072, -1.1307234691093881, 1.9279965497578335, 0.66491653610103651, 0.22856096896527725, 1.4852696461106809, -2.3526639776409071, -0.83659399916655119, 0.77568407661437189, 2.9821295087831183, 2.8687611724845552, -1.2793889657936002, -0.64266158872093682, -0.4076605590639929, 1.2936795992503236, 0.54988119438093619, 0.35459966141674693, 1.2895192134626279, 2.7775670946099091, -2.2147525220337707, 0.47648127315049643, -2.7080878342473742, -1.2044531969541454, 0.67086601389884037, -0.93611504971328552, 1.8065248713182847, -1.6814006177924135, -2.174485415355127, 1.7407316924970548, -0.61930985801625082, 0.87590229160315358, -1.0343669202248702, -1.70003441732163, -0.51729328887574355, -2.160088197087132, -0.40059392473575445, 2.3118810310297278, -0.73016248035527043, -3.0847379294899069, -1.6155808896472985, -1.6508797591221267, 0.29554327227756561, 1.8671266574131626, 2.4846198219809237, -1.5604509189312978, 2.5056769362903619, 0.065205351582426158, 2.766939372819424, 0.89667095323815427, 0.79832337705147016, -0.46212062807200111, 2.5908456255584391, 1.2585427774966935, -0.51322272553564674, -1.3213055785117838, -2.6237687449195937, -1.083646539932192, 0.56651245464294031, 1.7339912448868029, 1.7522679708661471, 1.5813588865599904, -0.33582797418114974, 0.33237299341056048, 1.5287300529230448, -1.439910777444724, 0.94013300271432598, 1.3476198647950626, -0.23085899441080868, 1.9450447891927209, 0.27760062791718126, 0.31383230393872708, -0.085762995257396224, -0.34080146494746222, -2.664376511087569, 2.1151519303356299, 1.1568006853141222, -0.93153728679005354, -0.95667250731559095, 2.5604674237380149, -2.8047750288846718, -1.7424627357506313, 2.8908572719597316, -2.8715214607998902, 2.5559978939113721, 2.028703130119879, 2.6348002677434463, -0.67603481543992361, -2.2002120586409366, -1.8254989730262097, -1.6034661732983724, 1.3713328347628391, 0.63990874303833312, 1.7786300248853575, 0.54841484941308416, -1.9490960977036653, -0.78872720259589846, -0.41978029070031558, -2.554775686943378, -2.2386122424029029, -2.82961772826294, -2.2271710704372216, 0.14594186066859244, -0.32934327921436196, -2.6000283578181649, 2.6819838029351137, 2.2777444134666909, -2.4727603854346092, -1.1185940748948304, -1.9272422438092354, -0.11534070699200531, 1.3537349101138134, 1.5363157184762273, -1.0978406447222737, 2.2750414735589333, -2.575300738428024, 1.0675262509922092, 0.33962918086317884, 0.14339870133634597, 0.40491799600393841, -2.3566015669017544, 0.65312997197306, -0.2684217907248283, 0.72594215461498013, 3.1032147560028638, -2.0962207128497568, 1.9203233714632253, 1.6039980101265636, -2.0727630761425262, -2.1147244830534024, -1.3865631680564845, 1.3176884110437559, -1.2367904582038336, 0.45105564151805433, -1.0389020989877147, 1.4459330010827407, -1.8204863164612648, -0.76243603741041255, 1.1834686924493631, -0.97014601630158459, 0.41716999237597308, -1.613090121383431, -1.9232389192384269, 0.14524386446948945, 2.6749470487053619, -2.0482033188956286, -0.86744584835705263, 3.1317492688185529, -1.3416415592383233, -0.45806526921762419, -0.9296650646713156, -0.19052560968617541, 1.9436014248998708, 0.26594480726317515, 0.88083490311589208, -0.24208185639099339, 0.98646117337752404, -0.0026308933854419761, -3.1042607950638859, -0.64017836914218551, 0.273103084799591, -2.3728140841874623, -1.0186484658168193, -2.5621963951786326, 0.56749339646996733, 2.8520650487682868, -0.45581321597347796, 2.6183634894485541, -1.2747756159660322, 2.9259126467369914, 0.53738486111052408, -0.81773601922041816, -2.7789791876524408, -1.7473937072455392, 0.38409964469902663, -0.0047779288079801427, 2.0017996857898486, -2.4708545088772569, 2.7872227249767074, 1.9565856624563114, -0.45474023282110149, 1.1440425959596934, 2.5356412078880686, 0.86175128071107909, -2.6844937815908478, 0.55659188601262843, 2.0222290137269159, 2.6428473193011572, -0.34160828292723966, 2.3493994233451652, -0.82712083402944425, -0.63406147118364453, 2.6430934025297668, 0.11241877986765605, 1.418710342478974, 1.138479893852596, -0.19599549664372901, 1.1409595653234996, -0.62506774007614374, 0.36512596558841026, -0.2836915916333933, -1.766427250342941, 0.60516002854033246, 2.6757831039003315, 1.0902567919989017, 0.062461792206415623, 0.46999860042273289, -1.3009514733470975, 1.7453933817172143, 0.55635173384192127, -1.2816237910588837, -0.58417443678805969, -1.4276056094181451, 3.1287111817421449, -1.5244404941271195, -1.5417221567424593, -2.6045646498003849, 0.57585332287272029, 2.958767728491051, -2.4329605210811889, -2.4903045086663287, -2.3991564486102592, 2.4380111382036391, -0.15931393934805246, 0.012241113596277204, 2.2535841422253546, 1.224113586232737, 2.9538177603249745, 0.73370427985514663, -3.1113698040603341, -1.1517485667960319, 0.93851008104888056, 1.6833634460025855, 0.6579855439821285, -0.39166931788112203, -2.2719053432696645, 0.11420002506351719, -2.7208284659882067, -2.0061379580358087, 2.1209872438047563, 0.18162778577181549, -0.65602180608649796, 2.9098959673131457, -2.5155491383763158, 2.228326086438507, 3.1393817597307878, -1.2380706655940079, 0.084439816439495274, -0.93588874871118855, -1.0308991658079454, -0.87524982302759258, 2.7910237165847001, -0.57587299391175295, 0.27067344152660988, 0.87821471614628321, -0.51040056706674142, -2.2460356592291508, -2.4283015962117651, 0.4236032583906138, 2.3442758812388194, 2.4112679990938677, -1.2763126553874646, 2.0040916246083436, 0.21576099484177069, 1.6759142833310254, -1.4106351424292967, 1.247288612901579, -0.084399505065457389};
double grid_900_theta[900] = {0, 1.6486248195973523, 1.5181501289649058, 1.5713783702497603, 1.2372211110292644, 0.89759283137898283, 1.567517561937283, 1.3099351884793307, 2.2502284857562738, 1.6751236694171796, 2.105204333708405, 2.729947452026094, 2.6814498055639957, 0.58163896213261346, 0.44104612351606121, 1.7952028569268652, 1.1424871457513599, 0.43492601541238973, 1.7874130794357719, 2.837147003334171, 1.7186361268631403, 1.524985178039991, 1.6183122217822916, 1.0154580107253712, 1.4100336307951906, 0.63386010015687355, 2.3807002924658835, 1.8508472732642298, 0.83186233431109879, 0.21581643963083574, 0.323404573338407, 1.1290279026035999, 1.5703131145680922, 2.0455587327584426, 1.4516405503248966, 1.945764327980672, 1.7356503015968312, 0.4369705434734501, 0.6709924907644218, 1.3248827773620309, 1.5803100903850609, 1.188528119161361, 0.94779992019132142, 2.1608534783136344, 2.0018570645830884, 1.9677778619415269, 2.0377929502736452, 1.8359985063596744, 1.1829720947067031, 0.87225769725959668, 1.4091981482607985, 2.2286375749929839, 1.9618639444321186, 1.5698794660174393, 1.1561574002110691, 0.55332099929663325, 2.7367459872875739, 1.4200820787245416, 2.5188231467039248, 1.5525038147187653, 1.4816454371200447, 1.5776561774140618, 0.37995081211523329, 0.99681349794917451, 0.66100343306427889, 1.5485008542331373, 1.9096920801304962, 1.2954928497978475, 1.0046887439746506, 1.8548136013616379, 2.0676576470226675, 1.725335216051084, 1.5179993373887035, 2.5338625436891098, 0.22089248325433264, 0.87821102141705931, 1.2126562502767717, 1.222853868474493, 0.13885044120407075, 2.4949651698218114, 2.6111292317692154, 1.0149357136748878, 1.9666510306119724, 1.9547722855967546, 1.4806948320143589, 1.1873894850576525, 2.8782248893753053, 1.8406732469423674, 0.48254052646345058, 2.2659747642934098, 2.2410807170919558, 2.6900384584022499, 0.67504828002113526, 2.4456582877023649, 0.81033540167754126, 1.0818523221040424, 0.33215259403313047, 1.6679995483631322, 2.0034190005937109, 2.4075033217524924, 0.96866662076740706, 1.9453633081080179, 0.93269780351349696, 1.5998760180202691, 1.6120457093496474, 2.0506158724558037, 1.8308220124541479, 1.6800933046375153, 1.0078333664393031, 2.9267286435816962, 2.7379405664830037, 0.56838482891501174, 1.6386460514022534, 0.26639211546665043, 0.3276618592265832, 0.927635749941085, 1.1414602527270536, 2.0676196847965249, 2.2227680826048264, 2.4037263925045118, 0.88557946856022529, 1.6803575320859245, 0.54978036537238673, 2.4072410203646641, 2.2016959763439017, 1.3933277407454896, 1.7651096848436136, 2.7999676921231456, 1.429945621134471, 0.71368691112269167, 0.99957717598385454, 1.1858333258306633, 1.6285463365363355, 0.39049904163212013, 2.7496104220442339, 1.1099791043597018, 1.7512762387742762, 1.7395547160537228, 1.0942983265913058, 0.95091986669415451, 0.55495047978224465, 1.4609603762112524, 2.1232138579511988, 2.6072915195467985, 1.5679531572563854, 2.119649856818953, 1.9014472355828973, 1.8076425582415858, 1.1023280609983872, 1.0631344108524665, 0.45913003034399513, 1.4585386853059672, 2.4641220668619717, 1.3845189027923441, 1.3783539386663712, 2.0754709454232874, 1.3505273697005273, 2.275719987850807, 1.3825004689351665, 1.8998355574367025, 2.1069371626520543, 2.9058938174364881, 2.8292633037510009, 1.5640431058107866, 1.562448748456154, 1.0486354953456418, 1.5395388643368841, 1.7577094608170718, 1.9871482156925786, 2.6642321600622969, 0.94483052388285116, 0.53009696636092363, 2.1137568548950711, 2.0071594937594308, 0.50937745491854547, 0.56295010654083666, 1.2252351878622296, 2.2946766023684306, 1.1419349136004504, 0.43720301664277761, 1.5309386090988844, 2.0143599883628056, 1.2200244949246661, 2.4680195555157822, 1.5627949640462195, 2.7341479779923992, 0.64200895859130425, 2.1648740452876267, 1.3402244021362137, 0.25468063721762202, 2.1476425243427428, 1.3806691848602888, 0.33915412900358666, 1.8844031048400529, 2.2214727975757276, 2.3558138331808696, 0.34167084542046222, 0.70466774094845253, 2.3833025327928135, 1.3525173179183159, 1.2291091064150899, 0.79048679613094741, 2.1607005079010997, 1.8934431058164789, 2.6652922159655805, 0.36694024829510186, 1.1659706800380958, 2.1366978005555266, 1.8356918203218306, 0.82677471496867028, 2.3785104412176263, 0.50927618743829717, 0.45969620187209759, 1.1414402724285106, 1.0952116376513037, 1.9188735867988402, 1.9443725854617517, 0.90898761222586677, 2.1230621172068513, 0.72320752612093131, 1.7721932003230048, 2.3860781493028953, 0.83926586733976571, 1.7053872723989638, 1.9918523768068637, 1.1995223104421242, 1.9393193538601792, 0.67237301183616749, 1.6504521009391444, 1.0194949371677628, 1.1371240558946116, 1.0295154283295807, 1.4653474324869156, 1.1257727085895264, 1.6814915332345866, 1.4564425032340507, 0.66032269838172752, 0.95298477141451787, 0.88406948206631164, 1.7044475601437301, 1.8633359675790275, 1.6148504290539285, 2.1194031693294209, 2.3515317839664442, 1.1497260820409378, 2.5648685730854366, 1.3268939309256464, 2.2582977455719493, 1.7913942894971024, 1.4981133789505472, 0.60237508074695156, 1.2374250802261906, 0.44059368177842595, 1.8423496759125035, 0.55587716289679245, 1.305133619958573, 1.4763177684172899, 1.6064105466011869, 1.2667771328032424, 2.2684540162389046, 2.4810084676537207, 2.5855157553839261, 1.1134726258505485, 1.1741530831721336, 1.0667740835876471, 1.1136742468647414, 0.88828055776659443, 0.66848057528437155, 2.4325963624402576, 1.2315476607604088, 1.6936135328600039, 1.2232213847358344, 2.2015481144206235, 1.9020976836307266, 0.89875628859642687, 1.3663919342084525, 1.5305750717484754, 1.2606033218558688, 2.2159647250721286, 1.861004836298326, 2.0950507380972452, 2.3668606211151881, 1.8164028085926989, 2.3174070603226764, 1.4615463344026971, 2.193324603473803, 0.77105967652174612, 1.5344996693433823, 0.99851865065869483, 1.3070619431782746, 1.8218057021058818, 0.80377094567336671, 1.6136626155163833, 1.2359185889915123, 1.8678539112715808, 1.7312069661405682, 0.77061408012099042, 1.4653963917621635, 1.0175903376167446, 1.3927048849282371, 0.33549791637527138, 1.4612890344557796, 0.87092365573969821, 1.8074888855217079, 2.4987396707711405, 0.82124071589431669, 0.92635551762569313, 0.55613306129674456, 1.9926672979816562, 1.6792758444292868, 1.9531815817463261, 1.7807228079780137, 1.86940143061466, 1.7812183971239099, 1.452525886659499, 2.0125101624437014, 2.3247485613205354, 1.1507546728557025, 0.75608073213234506, 1.9734971229471563, 2.0105851677670588, 2.8491221915199345, 0.90437583698166857, 1.4829266431031201, 2.6282049934121021, 1.4206489202772188, 1.7144700209142325, 1.3405741267276472, 0.62227115234815777, 0.83533369121268275, 3.0519865899295784, 2.0461021349641131, 0.79725793563567948, 2.7246461509942677, 2.6111221602934238, 1.5062804035002451, 1.9729502809214838, 2.5294656493094183, 1.6722490752940167, 2.4586057474337037, 1.5293451533717757, 2.7840850793342637, 2.4902422801053272, 1.5911925378362155, 0.99913227805629157, 0.65937317764086001, 1.1190978367390461, 0.46401407162082409, 2.0262898323218788, 0.59683698111997807, 1.861653771934511, 1.1122540548606008, 1.1392208889094597, 2.1593524148086276, 1.2586736240328129, 1.6672722403589435, 1.0210166933534586, 1.8961771141528698, 2.151002132863248, 0.77441035141637082, 1.34275089768083, 0.26238425425677669, 0.129902224779046, 1.7524579945244052, 1.4643958908424461, 2.2940387332458601, 1.4546351269434767, 0.22736082148763281, 2.3117957683098966, 2.174068394395829, 2.5068434544768641, 0.99246764204721227, 1.2271431908704424, 1.3654275140620169, 1.2369749776061911, 1.1542075990688745, 1.930708574047231, 2.2346110112856246, 0.77412121638863296, 0.89821874188405293, 1.443030133570596, 1.7902044366118552, 1.9363627595259583, 2.0354615495315, 0.80354553567076492, 2.8102745648350682, 2.3915633340539033, 0.84096008440415881, 2.3449401217423067, 1.7141933001633114, 1.9025200100615172, 2.1033424074233422, 2.2781903632456855, 1.3926586685336593, 0.54551079973787364, 1.8691327525920398, 0.63040427241335817, 2.5583340724759669, 1.6706299138922762, 1.29618847630144, 0.78804933629526375, 1.8276771742670486, 2.7165020636344321, 0.93032784709918048, 0.87836763526083894, 2.4892757131404899, 2.8909989196068482, 2.6579509437753739, 0.96531004361567907, 1.8557470436024326, 1.6516216450040508, 1.2656869677857703, 2.0103052534232919, 1.3463856985861051, 0.47272407181392584, 2.3411650540771838, 0.96081848730223718, 1.3989922629127014, 1.5685314009654274, 1.6886186674423191, 2.1603873828648403, 1.1149655359759396, 1.8816579450078459, 1.9957535671148914, 1.1175334550470613, 1.1013039915320681, 2.3520062072561765, 2.0401881449780239, 2.4778087311427868, 2.5247619431367205, 1.2887953696338261, 1.5306190365378245, 1.9961870149725689, 1.3813827898140003, 1.1391976276783344, 2.6355792568413143, 1.3497792755633122, 2.9544080138403173, 1.4528906374181048, 0.38227920715258534, 2.1903253240288851, 2.2876107314762488, 0.76662358282410781, 1.3565402910606972, 2.512129539274373, 2.758135020736157, 0.78947175753644649, 1.8703879501889391, 2.0232212599782531, 2.5871827944707873, 2.2745453558022604, 1.2711422487726136, 2.0829056910592287, 0.35966714649248832, 0.76091230960291023, 2.5154449799761851, 0.89816173714500624, 2.2984804475971479, 1.7806454036314434, 2.3385202391808133, 1.5500726110144494, 1.6220566485361776, 2.5090124463594896, 2.5448496130185307, 1.7504034556638652, 2.0365355133140275, 2.1196035577489605, 1.6361923133571805, 2.7069417249586594, 1.2290925831025241, 0.51723872491831369, 0.88757551955467939, 0.97532909961086078, 1.7479464214433085, 1.9184382917763645, 2.3477494828284029, 1.454209747663908, 1.0136894085282511, 1.6045986396617464, 1.4660102835268425, 1.0081700368560118, 2.1706808758179936, 0.54129396850219402, 1.0188651026810422, 0.24987769677478111, 0.93688800279097972, 2.401365855877839, 1.8602043610558376, 1.3438153660384413, 1.6902776312583934, 1.1998503370908775, 1.6766138038950456, 2.4028449849323641, 2.0746670877754791, 1.0881580084235773, 2.4722368924493026, 2.0730531794053619, 0.59425620823516367, 1.3474382132939788, 1.6972584614861053, 2.4797028736887112, 0.5706208323730837, 2.3870914246702877, 1.8774486963396548, 1.9848094966824548, 1.1763363376167519, 0.98248884568739725, 1.3451308710769925, 2.2942039914318562, 2.41743114038306, 1.0468110641202197, 1.5862581654585126, 0.92817315307912762, 2.0734189283629147, 0.70944426199731159, 1.7505046921951091, 2.2207680558861238, 1.7478034160165932, 0.76164813182466951, 1.4370600838465857, 0.8901695110447585, 1.5830184874701549, 2.0549713040745194, 1.9057546717850826, 2.8453006517124368, 0.79774040001064273, 0.80055560636372347, 1.0570929509217368, 1.6543856821186018, 0.24511810925638744, 1.0086943498592733, 0.66876793749845653, 1.3169192152398661, 1.6426326055056957, 1.903959939335135, 2.3793872511331822, 1.3367094142159759, 2.7148325274851555, 1.3499847694213558, 1.4806947849604377, 2.4431286872382842, 1.3235108031487233, 1.2349608858336074, 1.8068939290512356, 0.75439115857496319, 1.5645410144200267, 0.38411250099305017, 3.1022426174993791, 1.2657108599605074, 1.674133548142003, 2.1493316884310611, 0.74921171979504564, 0.38838556356396725, 3.0299326816438441, 2.2846469852868454, 2.3080595572631828, 0.50370684867972382, 2.2889237052618325, 2.4821484062795891, 2.3314684471936005, 0.77865861817350557, 1.7651063486205887, 1.4347799144866147, 0.23060447727639422, 1.7693553078724662, 2.1888985717802023, 2.0914337316585754, 0.879846546525901, 1.0499319814821102, 1.5225143492991706, 1.3112308572290161, 2.206459876221663, 1.5581407217901706, 1.6888922493805769, 0.99271853798710818, 1.8187531602010416, 1.1019255902376643, 1.225343598451617, 1.9492883880794258, 0.46068082845867764, 2.1933008664004348, 0.47641246966247186, 1.6366550429641304, 1.2067113823177, 1.7075628885479626, 1.2063872409224705, 0.77697161764123901, 1.0967850269699293, 0.43676558142564481, 2.0750200726064385, 1.3924124800816422, 0.68236854466583186, 1.2251833987267291, 1.5637858643456548, 1.4589131144610654, 2.718573744517732, 1.9797050574753166, 1.554307938897135, 1.7766017475013585, 2.6778864131464473, 2.0293550622103136, 1.7297522626337893, 1.9535219804155066, 1.5245484156551679, 2.031709420970981, 2.0776357022774388, 1.0511817132496086, 2.6033913667442974, 2.0979427405270634, 0.37132740930612407, 1.2135218609835339, 1.6507750764047673, 0.76799564566663991, 1.3380077424770667, 0.91125924318953067, 1.8871705438780826, 2.6640456750511703, 2.7983531795594914, 1.0741607376943347, 1.2727818809148743, 2.404679353807142, 1.4773961101843947, 0.49354059655197857, 2.1362868675871503, 0.33711179749419262, 1.1665850246883136, 1.7443467760817546, 1.0206342765729999, 1.8985763836417355, 2.9959836580869377, 1.2384190055548885, 1.4377691081345787, 1.2588160299798143, 0.69642987358873942, 0.9008370864834695, 1.6724183647957245, 1.8441562690349127, 0.57218779244551787, 1.3534636050892941, 1.8908879219722812, 1.5063484607032269, 1.7730756354557593, 2.410407992002455, 2.9091695577545074, 2.1806859345703526, 0.51034392933734773, 1.9760973074735748, 0.82619215197024432, 1.9106700624885951, 2.7762093131118224, 2.2352416283565324, 2.1150163837144165, 2.0706019344681281, 1.4474683011916893, 0.96409616986374702, 2.7310116440019372, 1.3348669589692859, 2.4295859464719456, 2.6361603676750178, 0.70656535186489222, 2.9280497722335026, 0.88504394111300833, 2.3897751606687736, 1.6778332263967402, 0.79073826781890733, 0.58428288110118154, 1.3828070665212275, 2.8039598891666944, 0.30460671260339978, 0.72270913217900667, 0.71456779175860985, 1.5590859066743905, 0.9622594240799982, 2.4143521365171061, 0.99427123484439417, 1.3382257363615215, 0.73628819707723481, 1.0735140463683497, 1.8225779784323819, 1.9903475765118546, 1.7817649400591622, 1.0330918514039431, 1.1274925616184619, 1.7276576890659201, 1.923230211883759, 2.4639635318410633, 1.1383102654248576, 1.0390738413780398, 0.58832222925415456, 1.4172161469460143, 0.66301661470812256, 1.566429451167811, 1.1121583464026694, 0.89036754344129054, 2.3005416678978654, 1.6488180467957347, 2.1188923059321372, 1.4350702381193061, 0.58279225851348171, 1.7872404230011232, 1.7274946143543941, 1.8817325772011113, 1.3187043506212484, 1.8976274912520561, 0.8452387049608413, 2.0891995271099102, 0.71304678142258104, 0.6928573000109709, 1.6646340244342903, 0.68845426743027793, 1.4634064160215563, 1.2530647778776274, 1.8196581097102063, 1.2609951964243593, 1.4356528315645207, 1.6046403627292118, 1.7075928670276292, 1.1196454001590534, 2.1420200340868902, 2.2657486023324442, 2.1909476553307536, 2.0533330886158341, 1.9712318508507476, 2.5786789447990159, 0.77363792521387909, 2.2323737966143087, 1.7858260050453771, 1.3369529551828023, 3.0385617073779256, 2.1936488190072927, 2.8451666931162705, 1.828606943400237, 0.88075514492276308, 1.949982771353715, 0.68904501191049772, 2.5169231985746929, 2.6095187116188558, 2.020230508221073, 0.12728065537155708, 0.67921782147190735, 2.1213249247851365, 1.683062698161323, 2.4995570220081427, 1.5698580483442253, 2.6829279486524786, 2.2355709492897873, 0.61009714488520672, 0.46290568510858354, 2.4430108871399545, 0.45423140152742292, 1.016646558458562, 2.4618480383066803, 1.7642839860022619, 2.9883458508894849, 1.1442579896470468, 2.8568754161223993, 0.63397347137667093, 1.992844934479588, 2.2026853153088117, 2.2235483326208705, 0.11693144419597257, 1.8711141375228157, 2.3002433196325605, 0.70371077871176613, 2.0642064318926607, 0.98496329422483897, 0.57448657111887491, 2.234434276780676, 1.358705192224585, 1.173197134325783, 2.3428048183031449, 2.1688294653093059, 1.3067371340432137, 1.2897459293114848, 2.6074241383449834, 2.2015253630944898, 2.3662635862671899, 1.6559802751453101, 0.26530524338776895, 1.3505568762359883, 1.9920647588782212, 0.18525809371461488, 2.5549296273285083, 2.9564288637231808, 1.2262583512833083, 0.78212808482455121, 1.8304747726958182, 0.89163582177996414, 0.82755760563205416, 1.0504922249892177, 2.5996927766863145, 1.0907336184106187, 2.5475605116236015, 2.6074077406975746, 1.7933760538214847, 0.92497355423461514, 2.2842153802432024, 1.5526051776323218, 2.6242445451802738, 0.3405134847359883, 2.4084902934350048, 2.7877011977490023, 1.3341572857343691, 1.6312839721847956, 2.2830620558510009, 0.34468629265539663, 1.0951262237226618, 2.2490308586254262, 0.44985979641519847, 1.9484943762338609, 1.115650161455447, 2.3150659292338496, 1.6068353188615234, 0.63298963933703889, 2.8218783631677042, 1.2551636381763189, 1.7821870935659485, 1.5393174479126503, 2.5677166410359495, 1.4665783194389879, 1.6461546160023532, 0.83930021212611827, 2.2214430227849347, 2.7253996839754162, 0.66984546497962782, 2.3306253984160796, 1.2490770705870582, 2.5690689476372106, 2.6209744696621371, 1.2695252052468362, 1.4626954068153601, 0.88103533348397933, 1.9694565654147536, 0.92510672404925942, 0.99092378285606852, 1.3232962853288242, 2.1039869446003401, 1.2629332286711492, 1.201490221979409, 2.8485676822025159, 2.0041539595050981, 1.6582448739745752, 0.59033735647345664, 0.63494615309611824, 1.7706017104032195, 1.8006339501131781, 2.9603062218932061, 2.0907588516819771, 1.0516483073484837, 2.4105976650066405, 2.541190397753446, 0.22429678085191695, 2.3316931048954599, 0.55769204033111031, 1.2071723212456571, 1.2217572205193628, 1.5216816659580235, 2.5987874318456896, 1.3568047020631686, 0.82998817844813721, 1.4614298316941674, 0.44831066576749445, 0.14270361173483126, 1.568963205734248, 2.1216418792621461, 1.7168363859196778, 0.69479934733168258, 1.4178625452438129, 1.6083745895744035, 1.4351281442027124, 0.99924289251056908, 2.351547885366907, 0.11677943144413128, 1.9168727961967029, 1.3101884592834341, 1.4805200211859899, 1.8525595468928782, 2.4788877826160616, 1.9229814341700253, 0.80770318058780888, 1.5882223459681746, 1.1102406877897695, 2.9200403692892021, 1.3549950859075011, 2.1738778896925828, 2.2755710230977741, 1.4476068109195068, 1.5078681902707984, 0.88440328769338028, 1.2338594308699946, 2.0926423980387456, 2.1659868331908538, 1.0827846086661819, 1.5771857567933567, 1.7749162816594084, 1.6937326795209735, 0.9996199139742592, 2.6393196515881452, 2.687316663028156, 1.4354669304171399};

double * pPhiGridSA[]= {grid_900_phi, grid_9_phi, grid_16_phi, grid_25_phi, grid_36_phi, grid_49_phi, grid_64_phi, grid_81_phi, grid_100_phi, grid_121_phi, grid_144_phi};
double * pThetaGridSA[]= {grid_900_theta, grid_9_theta, grid_16_theta, grid_25_theta, grid_36_theta, grid_49_theta, grid_64_theta, grid_81_theta, grid_100_theta, grid_121_theta, grid_144_theta};

#endif //__DSHTSCRNADAPTPOSITIONS_H__