/**************************************************************************************
  This software module was originally developed by  
 Deutsche Thomson OHG (DTO)
  in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
 performance may not have been optimized. This software module is an implementation
 of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
 you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
 and make derivative works of this software module or modifications  thereof for use
 in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
 and which satisfy any specified conformance criteria. 
  In no event shall the above provision be qualified, deemed, or construed as granting 
 to use and any third party, either expressly, by implication or by way of estoppel,
 any license or any authorization or other right to license, sell, distribute, under 
 any patent or patent application and any intellectual property rights other than the 
 copyrights owned by Company which are embodied in such software module and expressly 
 licensed hereunder. 
 Those intending to use this software module in products are advised that its use 
 may implement third party intellectual property rights, and in particular existing 
 patents or patent application which licenses to use are not of Company or ISO/IEC 
 responsibility, which hereby fully disclaim any warranty and liability of infringement 
 of free enjoyment with respect to the software module and its use.
 The software modules is provided as is, without warranty of any kind. 
 DTO and ISO/IEC have no liability for use of this software module or modifications
 thereof.
 Copyright hereunder is not released licensed for products that do not conform to the 
 ISO/IEC 23008-3 standard.
 DTO retains full right to modify and use the code for its own  purpose, assign or 
 donate the code to a third party and to inhibit third parties from  using the code 
 for products that do not conform to MPEG-related ITU Recommendations  and/or 
 ISO/IEC International Standards.
 This copyright notice must be included in all copies or derivative works. 
 This copyright license shall be construed according to the laws of Germany. 
  Copyright (c) ISO/IEC 2015.
*****************************************************************************************/

/*
 $Rev: 203 $
 $Author: technicolor-ks $
 $Date: 2016-01-19 14:45:41 +0100 (Di, 19 Jan 2016) $
 $Id: TabulatedValues.cpp 203 2016-01-19 13:45:41Z technicolor-ks $
*/


#include "TabulatedValues.h"
#include <cmath>

// constructor
TabulatedValues::TabulatedValues()
{
}


unsigned char TabulatedValues::ucCodedInvModeMatElems[7][19208] ={
	{106, 239, 180, 145, 248, 91, 12, 64},
	{3, 235, 9, 154, 248, 91, 236, 63, 0, 0, 0, 9, 183, 213, 113, 190, 94, 88, 210, 186, 81, 143, 248, 63, 0, 0, 0, 230, 99, 176, 97, 190, 165, 238, 193, 147, 248, 91, 236, 63, 0, 0, 128, 34, 184, 6, 114, 62, 202, 41, 171, 212, 139, 95, 224, 191, 123, 47, 159, 208, 189, 39, 247, 63, 188, 152, 166, 140, 248, 91, 236, 63, 112, 161, 27, 37, 147, 13, 244, 63, 246, 196, 144, 208, 139, 95, 224, 191, 109, 72, 227, 199, 189, 39, 231, 191, 72, 75, 97, 140, 248, 91, 236, 63, 134, 162, 76, 37, 147, 13, 244, 191, 244, 193, 104, 208, 139, 95, 224, 191, 164, 178, 170, 199, 189, 39, 231, 191},
	{96, 121, 74, 2, 230, 116, 217, 63, 121, 179, 75, 231, 33, 182, 148, 62, 35, 166, 96, 21, 148, 173, 231, 63, 59, 252, 25, 169, 141, 219, 169, 191, 144, 151, 96, 219, 211, 205, 180, 62, 104, 196, 147, 1, 19, 213, 157, 62, 67, 245, 157, 148, 135, 178, 234, 63, 108, 24, 16, 148, 11, 35, 176, 63, 31, 93, 70, 43, 213, 229, 204, 63, 65, 135, 75, 10, 32, 182, 216, 63, 54, 8, 1, 235, 49, 244, 136, 190, 244, 214, 238, 87, 48, 198, 217, 191, 70, 202, 92, 12, 30, 134, 217, 63, 208, 103, 87, 199, 177, 101, 134, 190, 214, 220, 220, 185, 239, 245, 172, 190, 166, 127, 232, 161, 156, 211, 193, 63, 164, 74, 103, 196, 223, 33, 239, 191, 250, 105, 53, 79, 61, 114, 204, 63, 143, 205, 101, 49, 32, 182, 216, 63, 41, 191, 180, 199, 247, 105, 223, 191, 92, 26, 151, 146, 48, 198, 201, 63, 141, 248, 163, 84, 27, 134, 201, 191, 137, 43, 132, 88, 17, 211, 219, 63, 99, 248, 118, 138, 245, 24, 220, 191, 54, 105, 78, 235, 152, 8, 213, 191, 136, 52, 209, 101, 79, 5, 220, 191, 233, 21, 124, 20, 52, 125, 226, 191, 134, 179, 205, 90, 32, 182, 216, 63, 186, 22, 160, 162, 243, 105, 223, 63, 15, 168, 231, 149, 49, 198, 201, 63, 30, 39, 195, 210, 34, 134, 201, 191, 136, 181, 154, 91, 33, 211, 219, 191, 141, 199, 114, 207, 238, 24, 220, 63, 220, 116, 65, 98, 153, 8, 213, 191, 232, 104, 14, 11, 79, 5, 220, 191, 102, 44, 250, 245, 48, 125, 226, 191, 71, 31, 172, 239, 229, 116, 217, 63, 234, 46, 11, 197, 63, 28, 223, 191, 226, 93, 242, 242, 247, 75, 225, 191, 187, 105, 102, 95, 16, 208, 194, 191, 173, 186, 248, 76, 86, 207, 177, 63, 28, 104, 246, 59, 6, 201, 229, 63, 40, 223, 118, 246, 170, 210, 206, 63, 197, 21, 254, 211, 195, 240, 219, 63, 5, 198, 223, 192, 129, 162, 199, 191, 92, 250, 189, 241, 229, 116, 217, 63, 126, 3, 61, 239, 104, 163, 161, 190, 203, 29, 99, 247, 151, 141, 173, 63, 153, 250, 205, 183, 64, 169, 231, 191, 152, 172, 47, 115, 236, 147, 193, 62, 48, 27, 138, 149, 34, 153, 117, 62, 112, 207, 84, 61, 246, 125, 204, 191, 96, 99, 76, 189, 52, 45, 170, 63, 148, 34, 140, 24, 43, 192, 234, 63, 203, 101, 101, 34, 230, 116, 217, 63, 146, 192, 194, 20, 62, 28, 223, 63, 78, 36, 92, 159, 249, 75, 225, 191, 219, 75, 40, 58, 26, 208, 194, 191, 212, 3, 120, 4, 96, 207, 177, 191, 163, 249, 43, 194, 3, 201, 229, 191, 56, 64, 124, 248, 175, 210, 206, 63, 67, 56, 4, 76, 196, 240, 219, 63, 57, 57, 28, 88, 127, 162, 199, 191, 97, 172, 82, 13, 230, 116, 217, 63, 106, 234, 229, 167, 66, 28, 223, 63, 116, 28, 195, 69, 5, 35, 194, 63, 62, 100, 139, 25, 129, 87, 225, 63, 71, 109, 66, 227, 81, 206, 229, 63, 105, 139, 159, 163, 208, 27, 176, 63, 248, 147, 124, 8, 174, 104, 210, 191, 41, 187, 13, 198, 50, 143, 219, 63, 254, 55, 235, 157, 192, 213, 190, 63, 196, 205, 187, 227, 229, 116, 217, 63, 224, 68, 220, 33, 59, 28, 223, 191, 15, 120, 122, 55, 9, 35, 194, 63, 73, 70, 227, 162, 131, 87, 225, 63, 62, 16, 230, 79, 79, 206, 229, 191, 189, 72, 193, 217, 195, 27, 176, 191, 58, 224, 242, 124, 175, 104, 210, 191, 247, 150, 240, 150, 57, 143, 219, 63, 18, 54, 102, 46, 236, 213, 190, 63},
	{243, 200, 249, 26, 54, 73, 203, 63, 128, 195, 158, 156, 203, 172, 34, 191, 82, 216, 28, 215, 217, 163, 215, 63, 176, 233, 56, 182, 128, 109, 55, 63, 128, 64, 48, 72, 249, 6, 3, 63, 0, 184, 32, 103, 78, 11, 241, 190, 97, 51, 196, 154, 0, 132, 222, 63, 184, 136, 141, 85, 132, 160, 60, 63, 128, 152, 155, 211, 215, 114, 29, 63, 28, 153, 127, 107, 231, 175, 189, 191, 90, 132, 228, 3, 150, 224, 189, 63, 43, 145, 99, 143, 61, 245, 187, 63, 255, 10, 6, 178, 229, 169, 227, 63, 48, 218, 133, 36, 43, 181, 154, 191, 208, 188, 149, 88, 121, 58, 200, 191, 226, 127, 29, 112, 29, 70, 176, 63, 144, 183, 62, 196, 53, 73, 203, 63, 64, 112, 104, 40, 51, 174, 34, 63, 4, 156, 192, 22, 189, 23, 207, 63, 149, 113, 236, 180, 30, 207, 209, 63, 64, 180, 231, 206, 115, 235, 2, 63, 0, 72, 96, 222, 5, 97, 241, 190, 250, 144, 165, 17, 51, 22, 178, 63, 177, 52, 179, 180, 179, 45, 218, 63, 35, 104, 77, 121, 148, 7, 206, 63, 76, 56, 124, 224, 164, 195, 179, 63, 190, 251, 135, 250, 87, 255, 197, 191, 0, 203, 222, 157, 136, 75, 174, 191, 218, 91, 140, 42, 211, 39, 211, 191, 35, 243, 19, 92, 36, 111, 212, 63, 61, 152, 207, 5, 255, 63, 222, 63, 211, 12, 219, 53, 203, 10, 173, 63, 13, 50, 98, 219, 53, 73, 203, 63, 160, 1, 25, 63, 8, 13, 211, 63, 84, 67, 180, 216, 10, 4, 197, 191, 67, 187, 10, 179, 64, 126, 194, 63, 243, 153, 47, 21, 150, 163, 208, 63, 60, 11, 141, 153, 197, 243, 210, 191, 169, 47, 99, 194, 17, 208, 184, 191, 150, 120, 118, 31, 160, 96, 194, 191, 23, 96, 232, 155, 170, 63, 202, 191, 1, 219, 236, 239, 156, 162, 196, 191, 202, 5, 87, 128, 101, 171, 222, 191, 20, 241, 207, 210, 2, 29, 157, 63, 36, 22, 161, 226, 72, 220, 187, 63, 146, 217, 250, 189, 201, 189, 194, 63, 147, 230, 55, 162, 52, 17, 208, 63, 224, 79, 220, 95, 171, 173, 212, 191, 68, 252, 187, 15, 65, 148, 207, 63, 83, 169, 237, 216, 117, 241, 171, 191, 229, 158, 213, 235, 44, 123, 215, 191, 250, 22, 214, 250, 246, 9, 203, 63, 57, 60, 85, 136, 34, 238, 174, 191, 132, 153, 105, 34, 66, 220, 186, 63, 100, 254, 181, 205, 107, 116, 213, 63, 42, 119, 72, 70, 188, 253, 217, 191, 132, 62, 3, 245, 115, 238, 187, 63, 144, 54, 42, 8, 187, 161, 197, 191, 171, 216, 71, 128, 2, 177, 149, 63, 12, 73, 248, 70, 52, 215, 193, 191, 41, 172, 98, 135, 248, 116, 193, 191, 182, 227, 161, 175, 150, 105, 219, 63, 52, 49, 119, 84, 209, 134, 196, 191, 60, 178, 226, 235, 122, 132, 169, 63, 166, 126, 64, 9, 65, 148, 207, 63, 141, 94, 147, 122, 232, 7, 214, 63, 175, 106, 153, 19, 174, 209, 201, 63, 219, 9, 17, 131, 150, 108, 195, 63, 87, 131, 108, 236, 173, 132, 209, 63, 219, 64, 255, 134, 35, 73, 215, 63, 234, 98, 61, 190, 198, 74, 183, 191, 58, 55, 61, 115, 206, 135, 196, 63, 47, 253, 223, 186, 2, 2, 208, 191, 197, 16, 30, 188, 87, 41, 187, 191, 47, 223, 118, 160, 23, 39, 215, 63, 120, 229, 207, 76, 216, 13, 136, 63, 77, 123, 137, 18, 225, 254, 194, 191, 188, 99, 169, 90, 230, 240, 177, 191, 0, 230, 131, 26, 119, 27, 209, 191, 217, 118, 237, 108, 75, 247, 200, 191, 32, 109, 56, 136, 53, 73, 203, 63, 87, 141, 213, 187, 127, 201, 212, 63, 91, 153, 65, 68, 110, 15, 175, 191, 1, 195, 222, 181, 156, 34, 197, 191, 192, 223, 64, 150, 36, 195, 212, 191, 14, 6, 166, 164, 158, 152, 190, 191, 83, 207, 87, 224, 56, 6, 204, 191, 57, 17, 30, 122, 126, 14, 175, 63, 236, 80, 155, 236, 120, 88, 206, 191, 91, 107, 177, 110, 122, 60, 198, 191, 50, 116, 219, 97, 148, 110, 208, 63, 13, 38, 246, 183, 105, 137, 220, 191, 50, 229, 120, 151, 133, 116, 194, 63, 103, 101, 241, 54, 23, 173, 130, 63, 69, 1, 203, 102, 212, 200, 151, 63, 130, 141, 163, 208, 53, 4, 216, 63, 190, 219, 6, 188, 53, 73, 203, 63, 65, 146, 153, 174, 127, 201, 212, 191, 60, 216, 151, 203, 78, 9, 197, 191, 17, 39, 197, 249, 216, 14, 176, 63, 4, 7, 163, 251, 107, 124, 191, 191, 219, 29, 15, 141, 208, 173, 212, 63, 197, 217, 132, 17, 26, 208, 184, 191, 245, 185, 9, 18, 137, 202, 175, 191, 180, 111, 217, 231, 104, 174, 211, 191, 149, 106, 109, 156, 199, 6, 224, 63, 41, 217, 252, 147, 154, 180, 202, 63, 136, 50, 42, 247, 235, 40, 152, 63, 128, 39, 44, 225, 52, 227, 187, 63, 194, 233, 240, 203, 210, 161, 172, 191, 16, 183, 168, 49, 141, 150, 214, 63, 63, 55, 100, 244, 145, 69, 195, 191, 218, 31, 217, 198, 53, 73, 203, 63, 1, 138, 99, 51, 119, 255, 184, 63, 250, 108, 99, 203, 97, 92, 175, 191, 71, 55, 240, 129, 161, 117, 214, 63, 228, 65, 121, 119, 158, 135, 202, 63, 23, 134, 194, 168, 28, 128, 162, 191, 101, 64, 225, 84, 56, 6, 204, 191, 155, 217, 93, 154, 158, 154, 192, 191, 37, 44, 13, 11, 180, 3, 214, 63, 235, 200, 102, 77, 147, 175, 219, 63, 233, 78, 238, 78, 180, 129, 196, 63, 121, 139, 198, 84, 58, 124, 173, 191, 236, 237, 127, 33, 29, 129, 194, 63, 123, 111, 83, 65, 216, 195, 213, 191, 42, 120, 201, 110, 116, 114, 197, 191, 41, 196, 232, 116, 139, 176, 209, 63, 178, 95, 105, 30, 54, 73, 203, 63, 63, 63, 36, 131, 8, 13, 211, 191, 160, 68, 192, 68, 200, 177, 81, 63, 195, 84, 133, 66, 92, 254, 203, 191, 80, 32, 18, 185, 63, 56, 217, 63, 160, 73, 49, 74, 158, 132, 88, 191, 200, 48, 42, 63, 233, 131, 206, 191, 168, 19, 4, 228, 80, 105, 84, 191, 74, 0, 142, 248, 73, 150, 191, 191, 59, 195, 103, 190, 208, 95, 203, 191, 27, 241, 36, 242, 212, 220, 171, 191, 250, 96, 44, 54, 163, 43, 221, 63, 130, 40, 129, 161, 225, 197, 190, 63, 118, 45, 232, 130, 239, 176, 206, 63, 100, 162, 76, 242, 93, 113, 193, 191, 41, 145, 176, 70, 166, 62, 213, 63, 11, 39, 82, 202, 53, 73, 203, 63, 36, 128, 185, 238, 68, 24, 204, 63, 208, 32, 59, 15, 39, 185, 204, 63, 107, 77, 151, 222, 211, 235, 200, 191, 148, 31, 150, 225, 232, 141, 208, 191, 105, 63, 28, 222, 164, 17, 211, 63, 223, 222, 22, 192, 33, 113, 154, 63, 23, 221, 253, 60, 85, 240, 208, 191, 86, 8, 252, 54, 233, 132, 159, 191, 2, 127, 11, 36, 158, 212, 201, 63, 178, 145, 59, 130, 235, 47, 224, 191, 243, 157, 39, 105, 39, 138, 211, 63, 238, 188, 101, 182, 12, 233, 207, 191, 30, 203, 125, 229, 214, 81, 116, 63, 100, 91, 48, 128, 2, 63, 164, 63, 168, 26, 51, 25, 57, 167, 174, 63, 117, 95, 132, 101, 53, 73, 203, 63, 117, 219, 47, 215, 118, 255, 184, 191, 69, 89, 55, 211, 189, 183, 204, 63, 19, 205, 39, 246, 147, 181, 209, 191, 137, 248, 205, 1, 35, 234, 196, 63, 128, 234, 202, 53, 244, 246, 192, 191, 142, 247, 110, 204, 23, 113, 154, 63, 24, 97, 132, 75, 165, 15, 216, 191, 53, 204, 22, 206, 217, 240, 201, 63, 110, 198, 122, 245, 109, 136, 190, 191, 23, 33, 61, 42, 178, 70, 210, 63, 156, 10, 218, 244, 192, 51, 214, 191, 1, 173, 99, 7, 31, 232, 207, 191, 109, 224, 222, 21, 58, 128, 207, 191, 128, 88, 141, 90, 172, 42, 213, 63, 84, 236, 51, 208, 224, 52, 184, 191, 117, 0, 19, 49, 65, 148, 207, 63, 247, 61, 254, 149, 118, 241, 171, 63, 222, 63, 25, 212, 228, 236, 180, 191, 119, 226, 100, 105, 208, 149, 218, 191, 63, 220, 40, 249, 66, 105, 190, 191, 219, 77, 89, 157, 200, 239, 151, 191, 236, 86, 115, 185, 14, 102, 207, 191, 194, 34, 40, 41, 5, 198, 198, 63, 196, 112, 65, 183, 12, 111, 220, 63, 144, 28, 103, 20, 163, 223, 199, 63, 249, 242, 91, 61, 100, 153, 110, 63, 170, 44, 115, 237, 149, 228, 189, 63, 72, 218, 50, 230, 74, 115, 197, 63, 165, 41, 165, 40, 70, 93, 208, 63, 44, 39, 71, 65, 231, 4, 196, 191, 75, 193, 98, 141, 86, 115, 213, 191, 41, 3, 148, 160, 53, 73, 203, 63, 129, 231, 92, 144, 194, 147, 194, 63, 112, 167, 231, 191, 57, 217, 212, 191, 156, 242, 104, 97, 23, 161, 184, 191, 20, 172, 100, 193, 125, 166, 181, 191, 6, 119, 156, 132, 67, 85, 210, 191, 58, 157, 57, 0, 104, 82, 212, 63, 207, 125, 65, 223, 41, 75, 200, 63, 238, 226, 184, 148, 88, 99, 162, 191, 206, 46, 118, 85, 165, 94, 206, 63, 49, 169, 137, 8, 36, 137, 208, 63, 235, 174, 126, 200, 70, 84, 224, 63, 148, 252, 142, 145, 195, 93, 193, 191, 229, 33, 30, 58, 110, 100, 205, 191, 128, 235, 141, 29, 106, 25, 148, 63, 58, 96, 5, 201, 240, 229, 167, 63, 1, 116, 118, 223, 53, 73, 203, 63, 136, 49, 18, 148, 68, 24, 204, 191, 96, 48, 147, 154, 134, 4, 68, 63, 229, 155, 15, 220, 130, 3, 211, 63, 59, 58, 134, 239, 135, 64, 217, 191, 32, 4, 122, 43, 90, 230, 70, 191, 165, 8, 233, 139, 233, 131, 206, 191, 238, 119, 76, 125, 159, 197, 82, 63, 164, 121, 167, 96, 62, 44, 191, 63, 230, 126, 164, 254, 176, 230, 226, 191, 56, 48, 216, 26, 246, 67, 168, 191, 141, 19, 237, 178, 188, 45, 201, 63, 234, 131, 169, 127, 2, 218, 190, 63, 241, 110, 101, 220, 27, 62, 196, 191, 221, 89, 218, 9, 7, 162, 193, 191, 224, 251, 241, 122, 23, 8, 184, 191, 124, 138, 94, 170, 64, 148, 207, 63, 75, 202, 171, 90, 232, 7, 214, 191, 69, 8, 121, 131, 29, 155, 207, 63, 63, 43, 99, 20, 78, 212, 170, 63, 192, 228, 2, 83, 99, 50, 184, 191, 200, 9, 210, 165, 55, 129, 220, 191, 251, 161, 142, 6, 107, 77, 81, 63, 0, 208, 37, 144, 74, 91, 177, 63, 213, 0, 215, 241, 166, 104, 211, 191, 90, 243, 29, 134, 161, 134, 209, 63, 16, 142, 117, 227, 0, 132, 191, 191, 223, 192, 229, 255, 242, 56, 205, 191, 136, 129, 143, 174, 215, 94, 208, 191, 26, 132, 137, 143, 21, 155, 140, 191, 186, 34, 214, 110, 38, 249, 207, 191, 146, 2, 237, 181, 247, 121, 183, 191, 126, 120, 227, 146, 53, 73, 203, 63, 107, 200, 117, 116, 195, 147, 194, 191, 228, 97, 243, 245, 125, 86, 210, 191, 216, 162, 87, 210, 105, 89, 199, 191, 15, 85, 244, 95, 211, 136, 196, 63, 66, 104, 228, 168, 186, 31, 208, 63, 168, 23, 250, 160, 39, 144, 200, 63, 34, 147, 115, 248, 77, 60, 212, 63, 151, 34, 160, 160, 166, 191, 162, 63, 193, 202, 75, 180, 1, 168, 208, 191, 124, 217, 119, 251, 15, 161, 210, 191, 4, 215, 111, 105, 66, 194, 222, 191, 84, 21, 14, 249, 90, 64, 172, 191, 66, 62, 168, 67, 52, 222, 208, 191, 134, 198, 126, 223, 22, 166, 153, 191, 230, 141, 153, 86, 251, 74, 152, 63},
	{198, 4, 3, 213, 109, 6, 195, 63, 30, 127, 123, 105, 147, 77, 105, 63, 187, 8, 171, 242, 253, 46, 209, 63, 176, 172, 146, 162, 186, 10, 74, 191, 70, 156, 206, 189, 32, 215, 130, 63, 136, 110, 241, 15, 46, 202, 112, 191, 253, 216, 153, 220, 137, 83, 213, 63, 240, 176, 71, 108, 196, 89, 88, 191, 112, 115, 72, 25, 81, 168, 83, 63, 31, 81, 180, 87, 12, 122, 137, 191, 11, 102, 119, 165, 75, 192, 148, 63, 67, 74, 136, 80, 119, 228, 135, 63, 251, 115, 161, 198, 200, 239, 216, 63, 234, 254, 241, 45, 232, 47, 65, 63, 2, 122, 189, 158, 143, 116, 119, 63, 60, 60, 107, 181, 162, 144, 120, 63, 192, 44, 122, 30, 210, 123, 109, 63, 82, 217, 210, 111, 38, 130, 179, 63, 146, 188, 122, 117, 132, 34, 193, 63, 130, 31, 237, 202, 46, 212, 176, 63, 7, 138, 231, 43, 40, 165, 216, 63, 96, 229, 54, 12, 164, 113, 199, 63, 6, 148, 170, 67, 249, 107, 147, 63, 8, 225, 13, 117, 231, 19, 132, 63, 224, 249, 107, 218, 78, 248, 109, 63, 193, 140, 251, 199, 217, 132, 193, 63, 84, 232, 41, 245, 167, 11, 101, 63, 143, 161, 203, 73, 214, 210, 195, 63, 153, 57, 242, 179, 53, 129, 198, 63, 126, 110, 94, 149, 63, 84, 107, 63, 176, 215, 94, 243, 107, 121, 101, 63, 133, 25, 76, 245, 25, 48, 176, 63, 136, 80, 226, 97, 97, 121, 209, 63, 126, 162, 215, 174, 66, 55, 192, 63, 126, 157, 68, 143, 6, 160, 119, 191, 28, 131, 100, 31, 42, 165, 125, 63, 176, 193, 236, 79, 32, 186, 112, 191, 212, 91, 75, 154, 151, 196, 179, 191, 237, 207, 20, 160, 104, 112, 207, 63, 29, 168, 89, 180, 140, 187, 204, 63, 72, 184, 46, 85, 252, 8, 188, 63, 100, 180, 159, 248, 240, 102, 151, 191, 208, 65, 7, 64, 210, 243, 136, 63, 7, 253, 84, 173, 18, 64, 184, 191, 224, 113, 111, 177, 170, 180, 207, 63, 22, 76, 152, 36, 160, 51, 189, 191, 0, 193, 182, 77, 220, 8, 88, 63, 136, 127, 153, 109, 114, 141, 213, 63, 154, 230, 68, 37, 111, 33, 213, 63, 104, 83, 173, 60, 35, 196, 128, 191, 88, 39, 198, 229, 89, 6, 195, 63, 207, 167, 25, 49, 206, 138, 206, 191, 176, 200, 168, 209, 207, 69, 168, 191, 72, 126, 199, 5, 115, 23, 189, 191, 109, 5, 165, 188, 10, 249, 203, 63, 226, 95, 245, 244, 126, 167, 181, 63, 16, 150, 112, 154, 17, 3, 195, 191, 232, 102, 107, 126, 74, 97, 160, 63, 153, 130, 100, 135, 15, 77, 199, 191, 6, 221, 34, 203, 129, 7, 177, 63, 206, 238, 43, 243, 24, 43, 182, 191, 216, 9, 72, 42, 64, 67, 198, 63, 107, 220, 244, 135, 64, 223, 184, 63, 82, 46, 218, 167, 102, 188, 178, 63, 124, 28, 85, 212, 170, 147, 184, 63, 70, 117, 72, 31, 177, 207, 210, 63, 210, 247, 197, 185, 225, 40, 213, 191, 94, 140, 35, 200, 141, 81, 196, 191, 224, 185, 108, 175, 57, 121, 184, 191, 180, 143, 154, 251, 254, 214, 199, 191, 32, 103, 71, 129, 52, 92, 103, 63, 84, 159, 79, 4, 219, 238, 174, 191, 192, 195, 67, 87, 68, 45, 86, 191, 32, 70, 86, 91, 202, 118, 195, 191, 201, 133, 158, 221, 34, 137, 178, 63, 219, 205, 185, 19, 26, 251, 192, 63, 37, 74, 108, 69, 178, 32, 194, 63, 244, 194, 212, 38, 34, 7, 197, 63, 10, 241, 206, 241, 44, 209, 166, 191, 63, 51, 229, 90, 83, 60, 179, 191, 84, 67, 79, 118, 132, 162, 206, 63, 52, 235, 122, 84, 8, 32, 187, 63, 200, 17, 83, 103, 19, 6, 181, 191, 65, 118, 132, 43, 91, 140, 186, 191, 78, 109, 180, 102, 127, 111, 169, 191, 113, 239, 108, 195, 116, 209, 191, 191, 38, 150, 46, 67, 35, 226, 205, 63, 36, 103, 20, 223, 217, 7, 166, 191, 133, 158, 107, 83, 243, 238, 176, 191, 45, 186, 24, 147, 68, 63, 202, 191, 92, 106, 56, 138, 244, 238, 183, 63, 234, 29, 118, 230, 201, 245, 167, 63, 170, 182, 144, 227, 53, 219, 175, 191, 35, 195, 195, 73, 109, 136, 212, 191, 204, 18, 140, 253, 177, 170, 201, 63, 63, 248, 171, 195, 103, 13, 199, 191, 155, 204, 61, 66, 118, 107, 204, 191, 8, 5, 142, 83, 59, 25, 182, 191, 4, 72, 44, 179, 89, 133, 206, 63, 5, 41, 64, 242, 143, 192, 183, 191, 46, 74, 200, 174, 109, 88, 193, 63, 76, 65, 100, 176, 20, 10, 204, 191, 238, 13, 95, 178, 112, 202, 173, 63, 147, 162, 219, 80, 33, 175, 162, 63, 8, 54, 213, 88, 122, 23, 179, 191, 250, 101, 137, 14, 11, 131, 188, 191, 139, 178, 124, 16, 175, 77, 193, 191, 54, 140, 217, 105, 208, 215, 146, 63, 233, 11, 29, 167, 97, 94, 203, 191, 4, 73, 93, 171, 179, 116, 201, 63, 84, 99, 33, 10, 137, 213, 162, 191, 175, 11, 244, 6, 187, 34, 196, 63, 121, 13, 194, 35, 33, 95, 191, 191, 36, 73, 191, 76, 107, 68, 98, 191, 74, 36, 38, 100, 243, 80, 193, 191, 194, 216, 69, 128, 220, 212, 193, 191, 1, 5, 170, 15, 92, 104, 192, 63, 108, 73, 247, 184, 214, 163, 206, 63, 132, 93, 53, 138, 162, 177, 145, 63, 16, 144, 56, 238, 7, 99, 217, 63, 52, 114, 170, 118, 41, 166, 192, 63, 28, 102, 137, 149, 239, 41, 187, 63, 118, 56, 189, 164, 33, 90, 199, 63, 201, 219, 213, 218, 207, 110, 151, 191, 115, 170, 180, 213, 92, 115, 195, 63, 33, 127, 226, 190, 86, 118, 194, 63, 201, 237, 140, 231, 151, 116, 197, 191, 4, 220, 88, 194, 165, 177, 196, 63, 210, 152, 119, 163, 58, 242, 183, 191, 97, 151, 150, 152, 69, 180, 195, 63, 112, 79, 227, 169, 128, 16, 208, 191, 13, 123, 55, 14, 115, 230, 170, 63, 12, 64, 232, 224, 205, 236, 192, 191, 106, 197, 102, 80, 255, 157, 187, 191, 128, 145, 34, 90, 65, 57, 128, 63, 101, 226, 240, 205, 28, 30, 208, 63, 137, 23, 220, 130, 81, 81, 198, 191, 198, 138, 49, 13, 123, 156, 182, 191, 112, 215, 255, 206, 77, 45, 188, 191, 120, 108, 163, 7, 74, 51, 199, 191, 55, 57, 203, 245, 34, 155, 199, 63, 129, 239, 88, 186, 191, 118, 182, 191, 188, 185, 182, 247, 83, 131, 135, 191, 78, 19, 139, 4, 99, 97, 196, 63, 180, 111, 96, 151, 108, 70, 150, 191, 152, 249, 7, 155, 142, 73, 186, 191, 86, 134, 183, 229, 56, 96, 176, 191, 114, 71, 146, 244, 221, 235, 172, 191, 75, 255, 198, 35, 176, 89, 211, 63, 134, 165, 37, 196, 114, 154, 189, 191, 139, 13, 120, 200, 14, 75, 194, 63, 152, 190, 133, 236, 126, 21, 194, 63, 173, 225, 2, 124, 27, 69, 181, 63, 138, 30, 49, 60, 23, 213, 200, 191, 245, 217, 201, 239, 133, 213, 203, 191, 150, 255, 121, 80, 143, 101, 182, 63, 60, 241, 37, 47, 134, 197, 191, 191, 242, 33, 242, 141, 94, 206, 192, 191, 154, 89, 154, 2, 41, 19, 181, 63, 61, 236, 150, 115, 209, 28, 204, 63, 112, 239, 92, 107, 65, 243, 198, 191, 62, 34, 82, 183, 191, 183, 169, 191, 95, 60, 119, 235, 16, 35, 196, 191, 229, 38, 40, 75, 110, 107, 184, 63, 67, 171, 186, 214, 222, 219, 179, 63, 35, 190, 215, 251, 32, 246, 180, 63, 13, 242, 216, 120, 223, 41, 159, 191, 16, 162, 17, 37, 219, 143, 205, 63, 17, 177, 224, 110, 247, 8, 196, 63, 80, 52, 168, 43, 128, 30, 192, 191, 222, 66, 53, 221, 163, 92, 193, 63, 62, 85, 185, 169, 190, 175, 212, 63, 129, 119, 83, 74, 52, 179, 171, 191, 233, 30, 195, 92, 60, 67, 165, 63, 62, 32, 15, 132, 17, 254, 197, 191, 80, 43, 198, 178, 92, 213, 194, 63, 246, 192, 91, 194, 70, 96, 208, 63, 16, 166, 221, 251, 75, 27, 162, 63, 139, 132, 254, 81, 177, 94, 162, 191, 218, 223, 231, 89, 123, 161, 177, 191, 243, 132, 125, 134, 141, 53, 180, 63, 149, 102, 239, 230, 73, 73, 196, 191, 177, 25, 62, 0, 4, 17, 144, 191, 36, 94, 121, 31, 151, 142, 209, 191, 225, 32, 183, 24, 154, 116, 210, 191, 230, 178, 38, 186, 108, 24, 170, 191, 219, 36, 119, 243, 214, 246, 202, 191, 216, 217, 248, 179, 44, 185, 170, 191, 39, 38, 77, 204, 47, 237, 136, 63, 36, 36, 252, 106, 221, 245, 181, 191, 22, 107, 151, 215, 149, 71, 180, 63, 128, 199, 201, 138, 172, 108, 107, 191, 215, 101, 193, 126, 43, 209, 195, 191, 28, 93, 29, 119, 183, 103, 195, 63, 163, 143, 123, 8, 118, 132, 195, 191, 30, 252, 10, 42, 9, 62, 184, 63, 236, 194, 175, 23, 77, 162, 189, 63, 234, 115, 7, 62, 108, 108, 190, 63, 126, 189, 90, 215, 100, 141, 166, 191, 202, 184, 43, 6, 239, 189, 212, 63, 174, 165, 230, 89, 237, 19, 195, 63, 68, 179, 196, 46, 140, 147, 201, 63, 135, 132, 217, 59, 253, 106, 196, 191, 162, 131, 67, 28, 19, 3, 147, 63, 111, 156, 58, 155, 9, 188, 174, 63, 132, 144, 145, 28, 43, 248, 209, 191, 86, 62, 205, 224, 67, 34, 160, 63, 181, 42, 113, 222, 240, 10, 171, 191, 214, 94, 86, 243, 31, 117, 196, 191, 114, 231, 121, 55, 201, 41, 195, 191, 53, 40, 9, 141, 243, 111, 181, 191, 0, 27, 76, 223, 94, 37, 200, 63, 120, 20, 92, 20, 2, 2, 190, 63, 104, 41, 40, 156, 94, 221, 150, 63, 56, 116, 105, 154, 133, 253, 210, 63, 61, 248, 120, 246, 234, 112, 179, 191, 214, 212, 88, 52, 1, 155, 188, 191, 18, 54, 56, 51, 246, 192, 205, 63, 225, 164, 101, 126, 99, 18, 165, 63, 144, 192, 89, 141, 26, 83, 78, 63, 239, 48, 172, 91, 127, 158, 181, 191, 183, 244, 17, 238, 148, 139, 180, 63, 21, 179, 116, 170, 224, 47, 205, 191, 216, 163, 52, 175, 161, 197, 145, 63, 134, 21, 162, 24, 157, 12, 199, 63, 183, 13, 98, 112, 152, 234, 194, 63, 139, 210, 125, 56, 28, 102, 195, 191, 57, 6, 103, 21, 246, 125, 164, 63, 216, 95, 216, 67, 3, 53, 203, 63, 110, 124, 59, 170, 249, 201, 209, 191, 188, 177, 158, 213, 12, 103, 174, 191, 236, 248, 213, 189, 21, 133, 196, 191, 138, 53, 183, 122, 125, 55, 179, 63, 129, 71, 39, 255, 85, 194, 182, 63, 77, 204, 15, 88, 99, 19, 211, 191, 114, 60, 119, 68, 29, 33, 191, 191, 151, 128, 115, 239, 169, 98, 193, 63, 83, 203, 189, 15, 246, 119, 176, 191, 37, 33, 246, 63, 209, 85, 199, 191, 54, 68, 4, 174, 206, 80, 152, 63, 77, 252, 72, 129, 48, 21, 177, 191, 15, 100, 69, 130, 212, 231, 199, 191, 242, 197, 231, 95, 71, 161, 197, 191, 30, 237, 168, 77, 48, 123, 203, 63, 44, 20, 169, 8, 230, 141, 168, 63, 193, 237, 66, 123, 48, 150, 186, 63, 48, 99, 156, 62, 179, 243, 139, 191, 6, 255, 68, 128, 90, 212, 165, 191, 4, 6, 248, 179, 187, 60, 161, 191, 106, 136, 118, 61, 122, 245, 195, 191, 41, 231, 11, 248, 107, 251, 193, 63, 48, 127, 243, 199, 49, 74, 147, 63, 132, 127, 207, 42, 77, 80, 206, 191, 75, 241, 3, 205, 141, 13, 178, 63, 137, 186, 201, 64, 189, 55, 128, 63, 221, 186, 181, 119, 194, 109, 168, 191, 155, 21, 14, 242, 171, 142, 210, 63, 200, 124, 151, 233, 191, 232, 192, 191, 248, 253, 2, 183, 222, 44, 87, 63, 131, 41, 83, 36, 90, 137, 145, 63, 196, 122, 201, 200, 236, 222, 135, 63, 197, 145, 223, 155, 215, 255, 161, 63, 59, 80, 202, 129, 70, 17, 212, 191, 164, 17, 211, 0, 129, 73, 198, 63, 187, 131, 36, 198, 51, 71, 161, 191, 16, 185, 233, 225, 64, 180, 117, 63, 160, 250, 98, 208, 249, 102, 193, 63, 197, 103, 152, 119, 180, 77, 176, 63, 156, 69, 96, 60, 251, 251, 166, 191, 157, 182, 128, 66, 4, 249, 200, 191, 132, 236, 59, 109, 91, 61, 195, 63, 172, 74, 254, 137, 231, 205, 220, 191, 140, 246, 167, 26, 104, 142, 157, 63, 246, 192, 209, 186, 238, 2, 178, 63, 20, 86, 145, 152, 114, 233, 193, 191, 121, 205, 85, 249, 182, 132, 193, 63, 140, 7, 41, 11, 2, 201, 200, 191, 176, 91, 13, 165, 190, 255, 185, 191, 87, 225, 95, 240, 255, 142, 181, 63, 62, 115, 68, 72, 45, 64, 195, 191, 154, 157, 207, 162, 54, 11, 200, 63, 27, 103, 120, 80, 8, 134, 175, 191, 219, 224, 131, 163, 125, 217, 176, 191, 5, 110, 205, 235, 66, 164, 197, 191, 102, 125, 165, 143, 36, 106, 191, 63, 16, 201, 202, 10, 124, 195, 195, 63, 118, 24, 137, 109, 35, 168, 137, 63, 34, 78, 196, 190, 146, 255, 195, 63, 236, 248, 135, 223, 224, 35, 160, 191, 63, 31, 145, 229, 170, 55, 198, 63, 41, 22, 226, 146, 108, 171, 199, 191, 200, 61, 84, 148, 126, 52, 209, 63, 170, 89, 126, 208, 12, 250, 186, 191, 0, 64, 199, 183, 51, 247, 102, 63, 182, 235, 208, 100, 14, 253, 216, 191, 246, 122, 79, 46, 171, 49, 180, 191, 152, 181, 17, 94, 9, 211, 188, 191, 229, 193, 127, 96, 85, 178, 175, 191, 184, 212, 117, 149, 98, 157, 199, 63, 204, 24, 120, 56, 2, 44, 190, 191, 130, 181, 69, 0, 45, 75, 194, 63, 40, 216, 254, 190, 222, 150, 160, 63, 144, 5, 93, 101, 34, 80, 174, 191, 88, 144, 72, 134, 60, 87, 207, 191, 73, 220, 81, 38, 88, 64, 180, 191, 254, 22, 91, 155, 92, 128, 150, 191, 1, 121, 254, 134, 243, 7, 191, 191, 129, 48, 220, 243, 147, 15, 186, 63, 63, 121, 175, 59, 92, 2, 208, 63, 212, 92, 60, 214, 62, 86, 186, 63, 143, 179, 211, 60, 173, 150, 171, 63, 246, 133, 26, 145, 149, 15, 159, 191, 130, 196, 189, 205, 104, 22, 191, 63, 108, 46, 22, 148, 190, 71, 194, 63, 251, 73, 98, 222, 102, 78, 192, 191, 185, 176, 0, 139, 120, 39, 208, 191, 51, 15, 25, 177, 130, 242, 209, 191, 129, 99, 15, 75, 86, 168, 197, 191, 128, 144, 230, 122, 47, 80, 111, 191, 83, 102, 162, 0, 164, 146, 138, 63, 134, 97, 254, 27, 46, 238, 158, 191, 224, 142, 73, 75, 218, 149, 197, 191, 102, 55, 37, 159, 7, 225, 182, 191, 150, 44, 42, 51, 13, 188, 177, 63, 105, 228, 0, 190, 172, 113, 212, 63, 203, 254, 41, 5, 7, 90, 194, 63, 183, 131, 111, 222, 53, 83, 185, 191, 28, 9, 254, 157, 132, 200, 168, 63, 247, 172, 177, 20, 146, 226, 203, 191, 235, 246, 115, 67, 212, 114, 201, 63, 140, 173, 137, 114, 245, 148, 160, 191, 166, 245, 85, 117, 191, 141, 196, 191, 99, 198, 88, 108, 190, 120, 181, 191, 156, 211, 157, 200, 211, 134, 198, 63, 68, 44, 67, 149, 35, 229, 208, 191, 22, 118, 253, 180, 187, 212, 180, 63, 143, 87, 55, 140, 7, 234, 189, 63, 194, 56, 200, 252, 10, 85, 191, 191, 119, 246, 58, 188, 124, 137, 204, 63, 47, 22, 197, 58, 110, 205, 179, 63, 212, 101, 158, 5, 100, 164, 178, 191, 131, 238, 86, 222, 120, 51, 208, 63, 24, 28, 74, 76, 236, 85, 92, 191, 116, 230, 86, 182, 91, 185, 187, 191, 90, 199, 6, 206, 21, 172, 195, 63, 140, 120, 108, 180, 15, 113, 195, 63, 238, 72, 95, 86, 39, 83, 208, 63, 9, 216, 125, 143, 111, 128, 177, 191, 163, 206, 19, 97, 244, 159, 160, 191, 106, 191, 0, 110, 140, 142, 187, 191, 101, 221, 24, 139, 74, 138, 192, 63, 192, 237, 160, 93, 175, 246, 182, 63, 227, 136, 172, 250, 162, 250, 191, 191, 242, 118, 198, 107, 157, 42, 196, 63, 166, 149, 222, 196, 153, 15, 192, 63, 75, 59, 37, 241, 185, 76, 187, 191, 34, 86, 142, 201, 66, 44, 131, 191, 66, 78, 205, 9, 37, 141, 199, 191, 61, 130, 95, 24, 28, 47, 181, 63, 171, 98, 107, 206, 182, 168, 195, 63, 192, 24, 224, 153, 181, 51, 208, 191, 254, 139, 130, 52, 47, 24, 179, 63, 62, 240, 116, 175, 59, 174, 197, 63, 21, 87, 237, 44, 78, 124, 184, 63, 74, 210, 47, 209, 168, 109, 193, 191, 192, 22, 149, 163, 200, 150, 137, 63, 196, 223, 241, 242, 150, 196, 167, 63, 21, 72, 213, 159, 21, 192, 214, 191, 100, 147, 79, 137, 39, 26, 208, 63, 170, 118, 88, 103, 7, 153, 162, 63, 228, 188, 58, 222, 177, 4, 189, 191, 250, 103, 231, 31, 108, 227, 202, 63, 67, 199, 89, 248, 187, 201, 184, 63, 201, 62, 232, 77, 237, 1, 174, 191, 192, 112, 32, 122, 39, 26, 136, 191, 1, 54, 24, 101, 150, 16, 193, 63, 234, 88, 51, 114, 237, 173, 197, 63, 101, 196, 23, 24, 84, 15, 183, 191, 14, 14, 116, 222, 185, 81, 188, 191, 195, 77, 247, 165, 118, 68, 204, 191, 183, 215, 41, 232, 141, 161, 193, 191, 22, 197, 7, 227, 87, 98, 181, 191, 62, 43, 108, 229, 225, 110, 191, 63, 232, 135, 241, 53, 50, 176, 179, 191, 117, 77, 121, 19, 240, 2, 186, 63, 4, 218, 88, 95, 223, 235, 204, 63, 94, 192, 81, 204, 36, 203, 178, 191, 234, 98, 206, 107, 226, 214, 194, 63, 157, 12, 206, 10, 116, 84, 164, 63, 126, 73, 164, 142, 181, 202, 159, 63, 24, 75, 255, 79, 228, 17, 205, 63, 32, 48, 141, 134, 153, 97, 204, 63, 150, 32, 216, 67, 150, 138, 164, 191, 167, 35, 86, 81, 235, 170, 183, 191, 18, 68, 180, 174, 12, 131, 198, 63, 70, 0, 10, 32, 19, 181, 174, 191, 24, 79, 244, 205, 255, 243, 210, 191, 119, 78, 161, 161, 193, 92, 177, 63, 100, 171, 16, 58, 93, 2, 184, 191, 30, 82, 113, 102, 77, 153, 211, 191, 169, 136, 169, 52, 124, 251, 193, 63, 157, 28, 85, 229, 14, 246, 200, 63, 213, 134, 144, 248, 61, 223, 122, 191, 49, 132, 31, 162, 95, 142, 195, 63, 139, 66, 179, 150, 200, 251, 208, 63, 111, 52, 119, 108, 243, 115, 142, 191, 94, 95, 181, 205, 119, 17, 196, 191, 54, 109, 202, 100, 66, 114, 115, 63, 91, 192, 96, 41, 214, 199, 183, 191, 20, 61, 216, 144, 55, 204, 179, 63, 146, 74, 151, 57, 221, 9, 162, 63, 238, 244, 250, 42, 234, 218, 201, 191, 145, 53, 110, 15, 205, 81, 151, 191, 181, 211, 235, 32, 95, 37, 190, 191, 0, 42, 38, 61, 180, 156, 126, 191, 70, 182, 82, 177, 5, 208, 208, 191, 138, 94, 103, 29, 230, 89, 178, 191, 28, 132, 114, 185, 195, 180, 187, 63, 55, 109, 173, 203, 226, 152, 211, 191, 71, 183, 194, 72, 59, 21, 198, 63, 202, 116, 239, 21, 242, 9, 184, 63, 28, 57, 244, 238, 203, 204, 193, 191, 225, 153, 19, 137, 218, 192, 193, 63, 13, 166, 172, 170, 215, 5, 199, 63, 246, 148, 62, 192, 210, 131, 211, 191, 152, 93, 129, 120, 39, 175, 194, 63, 185, 10, 245, 37, 242, 82, 193, 191, 78, 248, 113, 53, 11, 217, 202, 191, 144, 79, 206, 131, 152, 76, 153, 191, 154, 69, 90, 150, 220, 217, 147, 63, 172, 24, 240, 175, 219, 98, 208, 63, 123, 83, 8, 25, 80, 81, 198, 63, 62, 42, 68, 106, 165, 10, 156, 63, 69, 52, 53, 210, 132, 197, 176, 191, 46, 106, 42, 254, 122, 8, 148, 63, 49, 110, 248, 38, 36, 77, 176, 191, 72, 195, 101, 34, 111, 149, 210, 191, 19, 106, 73, 62, 134, 150, 179, 191, 75, 165, 236, 250, 153, 104, 102, 191, 26, 156, 158, 82, 9, 105, 197, 63, 191, 87, 16, 209, 14, 128, 135, 63, 150, 214, 105, 237, 105, 230, 195, 191, 7, 159, 192, 76, 101, 209, 186, 191, 16, 4, 213, 184, 224, 21, 177, 63, 190, 39, 123, 247, 197, 66, 217, 63, 152, 233, 55, 220, 58, 104, 132, 63, 148, 53, 237, 150, 157, 47, 205, 63, 234, 21, 196, 20, 147, 147, 192, 191, 6, 61, 149, 91, 53, 40, 187, 191, 40, 186, 122, 237, 215, 252, 194, 63, 101, 147, 201, 232, 16, 175, 194, 63, 211, 249, 194, 116, 117, 130, 195, 63, 182, 107, 35, 194, 144, 74, 197, 63, 218, 45, 20, 150, 62, 17, 188, 63, 204, 131, 1, 214, 202, 145, 195, 63, 242, 154, 109, 201, 227, 149, 204, 63, 246, 57, 15, 92, 96, 84, 163, 63, 216, 66, 69, 9, 251, 148, 196, 63, 20, 93, 241, 69, 69, 160, 157, 191, 233, 191, 155, 48, 242, 97, 177, 63, 203, 218, 239, 208, 166, 198, 205, 63, 75, 180, 128, 220, 254, 246, 196, 63, 133, 236, 97, 4, 56, 17, 184, 191, 100, 223, 148, 75, 21, 244, 182, 63, 46, 203, 234, 210, 215, 220, 169, 191, 102, 36, 6, 77, 102, 12, 193, 191, 192, 129, 7, 154, 168, 160, 157, 191, 48, 55, 196, 125, 144, 70, 109, 191, 40, 29, 251, 98, 247, 8, 211, 63, 164, 250, 27, 149, 32, 15, 202, 191, 92, 39, 96, 197, 242, 4, 183, 191, 26, 136, 196, 74, 196, 42, 183, 63, 252, 41, 222, 94, 250, 13, 198, 191, 146, 9, 221, 31, 65, 41, 214, 191, 48, 126, 167, 77, 223, 199, 158, 63, 10, 4, 3, 164, 55, 212, 194, 63, 82, 124, 147, 1, 0, 100, 180, 191, 31, 59, 99, 194, 110, 11, 195, 191, 88, 218, 46, 25, 4, 65, 200, 63, 104, 73, 7, 244, 169, 115, 191, 191, 12, 97, 253, 29, 110, 41, 186, 63, 224, 229, 187, 123, 209, 77, 49, 191, 189, 166, 66, 29, 15, 94, 208, 191, 41, 148, 112, 21, 194, 101, 195, 63, 230, 62, 240, 199, 6, 115, 198, 191, 229, 102, 104, 92, 208, 193, 203, 63, 222, 118, 190, 175, 156, 163, 173, 191, 79, 106, 130, 146, 118, 193, 192, 63, 8, 112, 75, 209, 127, 7, 193, 63, 171, 108, 138, 206, 69, 109, 202, 191, 139, 105, 129, 178, 204, 34, 178, 63, 139, 123, 157, 57, 74, 24, 197, 191, 219, 202, 253, 92, 89, 251, 208, 63, 109, 17, 204, 67, 150, 40, 201, 191, 131, 222, 242, 153, 56, 77, 196, 63, 98, 181, 152, 89, 209, 16, 180, 191, 88, 17, 214, 139, 74, 177, 191, 63, 208, 210, 25, 50, 244, 67, 189, 63, 216, 75, 105, 41, 38, 231, 169, 191, 124, 175, 110, 191, 35, 117, 178, 63, 38, 236, 84, 79, 93, 213, 194, 63, 10, 167, 221, 80, 117, 38, 175, 63, 88, 22, 178, 245, 135, 25, 204, 191, 77, 149, 81, 222, 159, 63, 192, 191, 79, 92, 96, 22, 61, 69, 174, 191, 34, 94, 179, 79, 142, 18, 189, 191, 153, 146, 234, 49, 211, 243, 200, 63, 121, 148, 89, 41, 162, 201, 205, 63, 125, 136, 41, 51, 149, 57, 172, 63, 50, 131, 55, 62, 113, 95, 160, 63, 150, 92, 77, 175, 65, 187, 188, 63, 44, 189, 93, 133, 194, 212, 198, 63, 15, 0, 91, 255, 163, 183, 188, 191, 196, 135, 74, 71, 255, 225, 209, 191, 164, 148, 210, 184, 112, 45, 186, 191, 34, 9, 153, 106, 110, 135, 129, 191, 26, 246, 192, 91, 112, 243, 184, 191, 56, 227, 217, 54, 151, 149, 192, 191, 49, 16, 174, 217, 235, 52, 176, 191, 16, 248, 54, 176, 214, 40, 183, 191, 233, 3, 245, 236, 133, 10, 160, 63, 72, 169, 109, 194, 231, 210, 217, 63, 82, 125, 131, 35, 75, 26, 180, 63, 120, 161, 96, 117, 196, 96, 146, 191, 5, 173, 133, 88, 153, 14, 178, 63, 94, 63, 67, 119, 24, 251, 192, 63, 140, 79, 233, 53, 215, 115, 182, 191, 17, 133, 110, 109, 114, 86, 193, 191, 235, 95, 3, 2, 164, 104, 195, 191, 143, 160, 113, 59, 29, 186, 194, 63, 111, 1, 219, 207, 167, 188, 189, 63, 28, 14, 117, 69, 56, 206, 134, 63, 75, 108, 238, 50, 217, 227, 204, 63, 149, 29, 69, 72, 197, 80, 179, 63, 82, 227, 149, 126, 201, 213, 191, 191, 112, 231, 115, 20, 147, 31, 203, 191, 11, 214, 106, 22, 242, 140, 182, 191, 101, 222, 145, 103, 86, 237, 192, 63, 20, 182, 221, 45, 167, 197, 194, 191, 182, 155, 169, 40, 134, 30, 195, 191, 100, 110, 30, 210, 18, 122, 104, 63, 142, 210, 148, 217, 80, 105, 209, 63, 132, 79, 93, 183, 181, 202, 210, 63, 132, 238, 44, 92, 103, 109, 188, 63, 116, 168, 106, 193, 24, 233, 185, 191, 246, 14, 183, 52, 56, 72, 183, 191, 98, 214, 179, 2, 243, 159, 204, 191, 116, 3, 1, 71, 110, 110, 187, 63, 222, 156, 176, 228, 1, 27, 183, 63, 110, 248, 174, 234, 130, 148, 202, 191, 242, 27, 72, 104, 39, 212, 194, 63, 210, 202, 11, 107, 192, 46, 168, 63, 102, 131, 216, 183, 186, 114, 145, 63, 179, 182, 199, 118, 60, 214, 207, 63, 67, 212, 54, 79, 159, 184, 186, 63, 63, 92, 253, 252, 233, 49, 135, 63, 142, 251, 252, 112, 206, 47, 197, 191, 241, 124, 116, 224, 140, 205, 143, 63, 91, 222, 165, 154, 69, 142, 209, 63, 62, 154, 13, 122, 228, 132, 196, 63, 161, 173, 49, 248, 95, 106, 160, 63, 27, 123, 117, 189, 169, 210, 167, 191, 48, 87, 174, 23, 18, 32, 166, 191, 31, 108, 247, 11, 191, 107, 208, 191, 219, 58, 54, 202, 236, 226, 168, 63, 215, 250, 174, 197, 245, 69, 208, 63, 2, 225, 43, 24, 64, 131, 198, 63, 90, 213, 118, 225, 143, 52, 184, 63, 106, 182, 145, 153, 111, 20, 167, 191, 200, 49, 176, 26, 137, 210, 200, 191, 76, 90, 80, 2, 205, 68, 186, 63, 197, 32, 243, 106, 112, 3, 184, 191, 136, 152, 24, 68, 56, 7, 208, 191, 160, 54, 58, 57, 36, 223, 177, 191, 27, 148, 76, 60, 103, 180, 200, 63, 185, 175, 90, 10, 76, 88, 193, 63, 137, 126, 232, 25, 50, 4, 193, 191, 196, 181, 22, 65, 225, 217, 197, 63, 165, 91, 244, 180, 221, 162, 179, 63, 59, 96, 198, 0, 123, 103, 187, 191, 207, 39, 164, 161, 252, 240, 202, 191, 105, 124, 102, 253, 201, 73, 186, 63, 84, 61, 9, 97, 193, 210, 190, 63, 180, 167, 52, 65, 135, 202, 163, 191, 36, 157, 66, 2, 186, 244, 72, 191, 174, 40, 161, 245, 126, 232, 201, 191, 80, 157, 227, 78, 104, 153, 204, 191, 207, 98, 182, 111, 105, 57, 163, 191, 51, 175, 38, 230, 171, 178, 188, 63, 198, 8, 107, 41, 64, 29, 178, 191, 100, 113, 97, 192, 172, 157, 183, 191, 146, 43, 200, 90, 156, 208, 170, 63, 58, 79, 16, 176, 162, 44, 180, 191, 39, 84, 52, 90, 156, 133, 203, 191, 52, 143, 163, 251, 47, 157, 212, 191, 224, 161, 251, 184, 179, 244, 199, 191, 235, 224, 181, 42, 160, 98, 178, 191, 233, 29, 82, 70, 9, 118, 204, 191, 156, 176, 126, 113, 238, 167, 208, 191, 181, 12, 130, 24, 170, 20, 139, 63, 23, 201, 105, 119, 10, 90, 194, 63, 232, 76, 251, 198, 25, 144, 116, 191, 113, 57, 31, 18, 17, 231, 197, 63, 29, 15, 51, 122, 131, 70, 198, 191, 122, 150, 105, 246, 72, 3, 137, 191, 140, 86, 129, 137, 110, 153, 97, 63, 113, 55, 160, 45, 155, 144, 182, 63, 190, 193, 36, 19, 220, 123, 209, 191, 70, 246, 45, 133, 196, 232, 194, 63, 148, 29, 65, 36, 11, 17, 149, 63, 229, 184, 158, 12, 77, 178, 149, 191, 245, 70, 246, 160, 205, 120, 159, 191, 217, 139, 169, 199, 133, 136, 161, 191, 100, 167, 192, 145, 184, 226, 208, 191, 50, 135, 137, 132, 250, 61, 209, 63, 164, 95, 83, 67, 211, 113, 194, 191, 62, 18, 228, 152, 190, 186, 160, 191, 48, 60, 105, 216, 16, 94, 178, 191, 40, 122, 72, 169, 37, 151, 145, 191, 240, 250, 97, 142, 243, 185, 180, 191, 137, 180, 54, 97, 113, 78, 199, 191, 158, 239, 218, 168, 209, 64, 202, 191, 86, 98, 45, 79, 19, 68, 198, 63, 39, 109, 178, 170, 209, 105, 207, 191, 172, 122, 26, 138, 102, 171, 196, 63},
	{198, 8, 29, 231, 243, 232, 184, 63, 188, 85, 148, 210, 254, 132, 109, 63, 127, 34, 9, 142, 186, 113, 197, 63, 23, 210, 163, 218, 119, 64, 116, 191, 250, 133, 220, 25, 175, 143, 115, 191, 57, 179, 199, 234, 119, 188, 87, 63, 71, 72, 7, 123, 1, 108, 202, 63, 120, 126, 8, 19, 115, 41, 96, 191, 6, 131, 41, 157, 98, 138, 64, 63, 38, 208, 174, 158, 22, 131, 132, 191, 231, 239, 147, 53, 167, 71, 132, 191, 62, 204, 162, 141, 149, 26, 132, 63, 181, 151, 224, 12, 54, 55, 206, 63, 189, 103, 186, 188, 54, 37, 120, 63, 209, 163, 13, 127, 177, 67, 147, 191, 127, 158, 20, 217, 158, 29, 141, 191, 147, 137, 222, 7, 185, 60, 120, 63, 103, 187, 82, 234, 252, 173, 144, 191, 142, 255, 34, 22, 129, 59, 113, 191, 148, 137, 198, 181, 12, 207, 134, 191, 163, 210, 242, 130, 2, 22, 210, 63, 188, 37, 244, 161, 157, 240, 136, 191, 112, 127, 25, 99, 162, 26, 105, 63, 144, 107, 159, 226, 53, 138, 82, 191, 108, 221, 15, 136, 37, 130, 129, 191, 34, 157, 250, 81, 4, 201, 130, 191, 196, 218, 242, 191, 3, 40, 153, 63, 22, 144, 66, 179, 192, 224, 149, 191, 128, 168, 56, 210, 248, 98, 194, 191, 167, 44, 97, 54, 21, 94, 154, 63, 170, 38, 10, 219, 35, 156, 215, 63, 106, 54, 105, 155, 114, 237, 189, 191, 60, 74, 47, 91, 191, 193, 155, 191, 42, 113, 201, 110, 221, 66, 203, 63, 79, 251, 18, 50, 154, 18, 165, 191, 210, 152, 147, 148, 11, 119, 182, 191, 207, 145, 85, 107, 221, 94, 185, 63, 60, 153, 178, 192, 138, 224, 87, 191, 34, 239, 213, 1, 99, 118, 177, 191, 161, 0, 41, 155, 169, 42, 196, 63, 170, 172, 227, 113, 244, 44, 133, 63, 148, 159, 165, 205, 212, 137, 113, 191, 113, 241, 208, 118, 119, 238, 169, 191, 193, 70, 152, 87, 207, 175, 195, 191, 20, 85, 200, 96, 85, 106, 197, 63, 112, 161, 62, 176, 106, 188, 130, 63, 63, 53, 72, 151, 204, 201, 113, 63, 204, 162, 95, 170, 39, 136, 131, 63, 100, 107, 65, 27, 179, 192, 191, 63, 48, 95, 25, 240, 245, 236, 114, 191, 152, 190, 77, 254, 180, 80, 199, 191, 234, 45, 171, 64, 13, 144, 196, 63, 130, 157, 95, 122, 81, 240, 137, 191, 40, 26, 75, 161, 137, 120, 114, 63, 5, 99, 121, 78, 202, 1, 82, 191, 52, 240, 195, 124, 224, 112, 138, 63, 157, 154, 61, 33, 8, 215, 172, 191, 98, 95, 76, 236, 229, 105, 195, 63, 33, 242, 172, 15, 157, 8, 166, 63, 217, 2, 74, 170, 41, 143, 199, 191, 162, 68, 247, 1, 22, 154, 193, 63, 125, 17, 159, 73, 243, 7, 143, 63, 152, 3, 101, 160, 19, 69, 179, 191, 67, 12, 207, 151, 48, 108, 162, 191, 45, 139, 4, 126, 119, 70, 191, 191, 151, 243, 12, 147, 58, 105, 159, 63, 66, 19, 45, 69, 200, 153, 128, 191, 16, 56, 42, 22, 182, 251, 191, 191, 84, 110, 151, 49, 11, 112, 132, 191, 211, 141, 42, 246, 192, 95, 200, 63, 121, 54, 42, 81, 80, 157, 203, 191, 178, 98, 58, 29, 79, 10, 201, 63, 213, 252, 145, 77, 202, 136, 185, 63, 101, 41, 130, 47, 217, 147, 195, 191, 114, 134, 104, 233, 225, 142, 167, 63, 2, 219, 231, 188, 72, 169, 176, 63, 26, 73, 255, 107, 7, 150, 192, 191, 145, 187, 127, 58, 199, 184, 185, 191, 150, 123, 98, 199, 199, 84, 181, 191, 92, 75, 230, 255, 125, 238, 165, 63, 18, 58, 240, 225, 217, 26, 192, 191, 38, 19, 225, 31, 104, 77, 179, 63, 52, 102, 119, 224, 190, 105, 185, 191, 91, 249, 233, 50, 131, 25, 177, 63, 245, 25, 212, 43, 237, 88, 190, 191, 184, 100, 119, 253, 211, 106, 166, 191, 134, 46, 197, 49, 225, 46, 187, 191, 221, 184, 234, 195, 31, 204, 194, 191, 27, 129, 249, 3, 117, 46, 196, 63, 118, 191, 28, 105, 222, 55, 176, 63, 190, 254, 120, 171, 160, 83, 168, 63, 158, 173, 105, 42, 201, 24, 195, 63, 53, 14, 164, 130, 62, 227, 148, 63, 58, 4, 106, 19, 104, 34, 178, 191, 151, 202, 53, 7, 71, 40, 164, 63, 92, 171, 211, 109, 218, 82, 193, 191, 86, 197, 65, 68, 241, 63, 153, 63, 100, 146, 93, 68, 10, 240, 181, 63, 228, 95, 134, 174, 100, 64, 200, 63, 205, 202, 151, 151, 247, 50, 193, 63, 180, 24, 233, 36, 68, 100, 211, 63, 11, 120, 84, 221, 243, 140, 160, 191, 54, 160, 250, 20, 63, 4, 180, 63, 90, 64, 100, 67, 47, 32, 179, 63, 16, 247, 138, 208, 6, 91, 186, 63, 105, 32, 152, 91, 168, 204, 188, 191, 128, 11, 174, 204, 41, 95, 57, 191, 174, 243, 204, 181, 120, 124, 187, 63, 29, 16, 38, 58, 53, 81, 186, 63, 239, 51, 85, 201, 120, 170, 129, 63, 223, 35, 47, 204, 114, 206, 196, 191, 91, 106, 68, 106, 147, 177, 178, 63, 25, 35, 85, 200, 166, 228, 143, 63, 127, 162, 82, 107, 205, 38, 161, 191, 157, 24, 137, 31, 87, 94, 198, 63, 158, 179, 178, 126, 164, 103, 193, 191, 212, 8, 90, 100, 68, 22, 152, 63, 76, 165, 29, 218, 196, 219, 131, 63, 58, 158, 175, 30, 255, 27, 155, 191, 12, 30, 219, 59, 169, 169, 164, 63, 227, 39, 68, 197, 172, 120, 196, 191, 72, 41, 43, 95, 139, 145, 200, 63, 51, 129, 243, 163, 228, 206, 169, 191, 208, 12, 162, 17, 21, 86, 149, 63, 56, 218, 75, 65, 136, 155, 107, 191, 199, 23, 26, 23, 223, 6, 149, 191, 153, 148, 159, 184, 82, 180, 164, 63, 68, 18, 205, 234, 128, 145, 164, 191, 201, 68, 34, 229, 185, 198, 181, 63, 140, 14, 236, 215, 78, 64, 206, 191, 32, 147, 85, 49, 197, 255, 184, 63, 28, 190, 159, 230, 26, 65, 156, 191, 218, 88, 66, 158, 176, 209, 141, 191, 120, 97, 255, 157, 160, 119, 129, 63, 86, 96, 156, 199, 93, 240, 193, 191, 228, 108, 99, 33, 226, 10, 137, 63, 64, 6, 105, 217, 21, 183, 135, 191, 188, 102, 117, 179, 190, 61, 141, 63, 20, 59, 151, 167, 2, 54, 139, 191, 234, 199, 219, 197, 72, 216, 216, 63, 66, 30, 166, 154, 30, 241, 160, 191, 88, 84, 36, 133, 141, 172, 158, 191, 242, 28, 148, 80, 30, 63, 195, 191, 184, 197, 20, 29, 231, 220, 190, 63, 140, 110, 226, 56, 78, 80, 186, 63, 130, 166, 174, 178, 1, 218, 132, 63, 41, 170, 109, 42, 186, 1, 194, 63, 86, 205, 72, 124, 216, 200, 187, 63, 228, 81, 152, 216, 51, 235, 140, 63, 195, 48, 79, 165, 165, 98, 148, 63, 66, 249, 181, 190, 27, 7, 189, 63, 170, 50, 221, 110, 181, 96, 200, 63, 118, 31, 169, 112, 237, 68, 176, 63, 98, 82, 24, 168, 110, 104, 144, 63, 96, 145, 224, 7, 28, 93, 161, 63, 8, 255, 67, 251, 74, 172, 125, 63, 240, 203, 119, 150, 12, 14, 146, 63, 234, 162, 65, 179, 181, 186, 204, 63, 212, 235, 157, 58, 144, 68, 195, 63, 30, 220, 16, 182, 131, 78, 170, 63, 190, 142, 12, 193, 5, 146, 147, 63, 196, 223, 176, 219, 91, 77, 160, 63, 85, 221, 32, 57, 1, 69, 168, 63, 132, 108, 121, 184, 235, 147, 109, 63, 133, 192, 80, 238, 185, 159, 177, 191, 255, 33, 183, 15, 145, 94, 201, 63, 157, 82, 226, 161, 42, 179, 203, 63, 222, 168, 170, 79, 21, 180, 185, 63, 251, 48, 241, 107, 182, 188, 153, 63, 163, 236, 29, 169, 221, 216, 148, 63, 160, 167, 94, 143, 121, 67, 117, 191, 182, 51, 234, 111, 58, 159, 165, 63, 125, 221, 115, 80, 150, 181, 197, 63, 245, 190, 176, 192, 66, 255, 163, 191, 74, 61, 35, 132, 76, 252, 192, 191, 77, 104, 101, 99, 34, 57, 206, 63, 6, 50, 196, 33, 113, 23, 207, 63, 180, 3, 168, 165, 50, 76, 182, 191, 120, 204, 232, 86, 0, 238, 162, 63, 101, 249, 29, 195, 5, 222, 163, 63, 107, 236, 201, 61, 44, 133, 184, 63, 141, 251, 152, 41, 91, 101, 167, 191, 42, 212, 236, 77, 18, 32, 161, 191, 158, 10, 140, 194, 184, 21, 196, 191, 161, 248, 188, 42, 120, 193, 185, 63, 76, 230, 62, 180, 49, 189, 154, 63, 198, 87, 217, 58, 87, 32, 185, 191, 58, 151, 233, 21, 34, 26, 177, 63, 195, 195, 36, 44, 236, 156, 195, 63, 83, 56, 18, 96, 37, 142, 193, 191, 140, 185, 88, 39, 66, 107, 173, 191, 10, 244, 52, 255, 231, 36, 150, 63, 143, 5, 167, 136, 31, 107, 177, 63, 140, 143, 41, 21, 92, 138, 192, 63, 23, 115, 150, 176, 106, 27, 179, 191, 178, 220, 201, 67, 53, 187, 193, 191, 47, 137, 159, 60, 189, 87, 202, 63, 169, 123, 15, 162, 101, 95, 187, 63, 143, 131, 186, 184, 154, 109, 177, 191, 252, 252, 195, 61, 26, 182, 157, 191, 143, 171, 20, 75, 221, 23, 181, 63, 41, 203, 44, 142, 15, 128, 189, 191, 77, 80, 194, 11, 67, 109, 188, 191, 163, 54, 214, 170, 148, 59, 172, 63, 154, 176, 4, 249, 51, 188, 187, 63, 185, 26, 222, 236, 112, 11, 204, 191, 27, 135, 182, 90, 93, 45, 202, 191, 110, 104, 83, 255, 254, 95, 157, 63, 52, 189, 44, 135, 214, 53, 189, 63, 142, 103, 138, 119, 183, 166, 177, 191, 254, 224, 87, 143, 182, 244, 178, 191, 24, 0, 11, 19, 116, 203, 148, 191, 64, 230, 169, 76, 230, 253, 178, 63, 240, 31, 111, 86, 199, 183, 99, 63, 5, 223, 2, 164, 243, 95, 148, 63, 161, 134, 6, 27, 128, 45, 155, 63, 191, 242, 79, 225, 214, 136, 185, 63, 43, 251, 19, 67, 90, 232, 193, 191, 239, 22, 254, 176, 52, 220, 182, 63, 50, 170, 196, 222, 158, 3, 168, 191, 101, 16, 197, 70, 191, 61, 182, 63, 88, 162, 1, 64, 212, 140, 196, 191, 251, 153, 133, 73, 139, 45, 157, 191, 160, 36, 116, 106, 152, 211, 170, 191, 204, 79, 193, 125, 68, 243, 190, 191, 79, 174, 67, 127, 57, 234, 181, 63, 201, 178, 169, 46, 255, 101, 186, 63, 8, 81, 211, 49, 224, 15, 131, 191, 106, 68, 156, 128, 139, 215, 190, 191, 66, 174, 6, 57, 172, 55, 117, 63, 86, 179, 79, 166, 204, 136, 197, 191, 236, 160, 251, 80, 152, 200, 182, 63, 156, 112, 221, 187, 156, 88, 182, 191, 206, 66, 245, 187, 243, 50, 193, 63, 124, 117, 237, 148, 55, 147, 162, 63, 142, 111, 7, 235, 176, 118, 191, 63, 254, 20, 245, 128, 220, 161, 179, 191, 210, 23, 22, 115, 84, 25, 167, 63, 164, 119, 212, 172, 189, 162, 180, 191, 55, 187, 58, 167, 143, 128, 194, 63, 44, 32, 115, 83, 7, 76, 166, 63, 41, 85, 51, 117, 9, 202, 180, 191, 168, 79, 15, 143, 232, 234, 197, 191, 251, 121, 5, 83, 96, 248, 164, 191, 235, 215, 6, 66, 196, 42, 209, 191, 203, 151, 183, 85, 94, 169, 199, 63, 54, 215, 37, 187, 95, 164, 187, 63, 0, 109, 246, 112, 45, 7, 154, 191, 19, 168, 194, 159, 109, 171, 173, 63, 101, 167, 62, 69, 136, 227, 198, 63, 209, 196, 159, 104, 199, 67, 165, 63, 140, 242, 212, 59, 231, 52, 182, 191, 210, 125, 102, 25, 172, 55, 184, 63, 192, 247, 55, 55, 240, 185, 182, 63, 239, 120, 232, 184, 69, 198, 186, 191, 170, 43, 211, 15, 107, 63, 183, 63, 196, 192, 84, 243, 165, 10, 186, 63, 52, 74, 36, 115, 91, 215, 188, 191, 120, 224, 142, 150, 65, 153, 144, 63, 71, 242, 235, 144, 205, 252, 192, 191, 201, 108, 8, 111, 237, 89, 142, 63, 214, 154, 232, 222, 123, 115, 180, 63, 24, 116, 202, 241, 224, 167, 199, 191, 11, 227, 69, 215, 160, 63, 179, 63, 12, 30, 33, 166, 21, 197, 182, 63, 7, 188, 226, 143, 117, 105, 182, 63, 186, 188, 154, 81, 108, 174, 166, 191, 141, 252, 59, 205, 40, 6, 175, 191, 46, 85, 151, 239, 250, 68, 166, 63, 61, 196, 52, 98, 207, 107, 195, 191, 254, 11, 234, 21, 243, 176, 196, 63, 2, 220, 170, 100, 166, 139, 108, 63, 28, 82, 35, 18, 32, 51, 189, 191, 67, 200, 73, 166, 220, 183, 151, 63, 173, 254, 132, 193, 49, 120, 161, 63, 14, 210, 92, 118, 124, 169, 179, 63, 251, 135, 60, 70, 72, 2, 173, 191, 14, 92, 61, 69, 157, 115, 144, 191, 171, 223, 193, 170, 252, 189, 188, 63, 100, 187, 236, 50, 35, 125, 199, 63, 156, 26, 123, 211, 116, 104, 149, 63, 176, 219, 221, 123, 87, 121, 170, 191, 162, 206, 1, 127, 24, 67, 168, 63, 174, 213, 72, 157, 232, 20, 210, 191, 68, 27, 7, 152, 95, 113, 178, 191, 176, 34, 101, 77, 180, 84, 134, 191, 193, 211, 174, 35, 166, 64, 206, 63, 95, 141, 40, 200, 83, 205, 198, 191, 142, 196, 80, 13, 112, 22, 185, 63, 36, 243, 27, 115, 215, 121, 186, 63, 146, 187, 244, 67, 146, 203, 185, 191, 206, 203, 155, 154, 227, 115, 183, 191, 109, 252, 9, 241, 167, 196, 192, 191, 88, 168, 224, 200, 176, 118, 193, 191, 38, 239, 213, 114, 227, 19, 90, 191, 249, 199, 247, 4, 228, 87, 192, 63, 65, 209, 62, 248, 214, 67, 146, 191, 174, 126, 147, 56, 223, 159, 178, 63, 206, 135, 175, 91, 211, 102, 201, 63, 174, 198, 213, 152, 245, 115, 167, 63, 78, 188, 122, 11, 127, 199, 187, 63, 172, 214, 239, 4, 51, 230, 174, 191, 121, 209, 167, 195, 23, 152, 149, 63, 220, 186, 233, 20, 154, 166, 182, 63, 181, 102, 179, 45, 28, 52, 161, 63, 213, 36, 128, 40, 36, 175, 185, 191, 0, 125, 247, 248, 30, 240, 195, 191, 228, 241, 30, 137, 104, 34, 183, 63, 133, 72, 59, 96, 172, 183, 188, 191, 16, 119, 102, 81, 10, 11, 172, 191, 86, 239, 13, 84, 169, 220, 86, 63, 28, 92, 157, 103, 194, 17, 199, 191, 33, 134, 203, 58, 123, 119, 183, 191, 136, 166, 0, 170, 176, 33, 182, 191, 156, 167, 1, 40, 38, 146, 192, 191, 34, 164, 92, 230, 197, 34, 180, 63, 235, 238, 139, 55, 217, 70, 174, 63, 26, 58, 242, 246, 68, 253, 198, 191, 121, 135, 151, 2, 163, 254, 163, 63, 118, 42, 142, 171, 139, 54, 183, 63, 90, 230, 75, 251, 155, 112, 172, 191, 251, 92, 68, 132, 78, 10, 194, 63, 108, 91, 36, 141, 61, 152, 186, 63, 84, 20, 31, 94, 150, 242, 167, 63, 71, 61, 170, 115, 66, 80, 186, 63, 39, 92, 148, 18, 227, 126, 188, 191, 38, 43, 178, 61, 100, 13, 184, 191, 144, 134, 223, 189, 43, 45, 186, 191, 138, 188, 36, 78, 15, 222, 193, 63, 232, 45, 56, 25, 159, 169, 193, 63, 64, 211, 161, 175, 90, 158, 133, 191, 32, 165, 12, 205, 50, 222, 190, 63, 88, 44, 30, 78, 79, 202, 152, 191, 38, 238, 185, 119, 141, 118, 178, 191, 163, 216, 79, 201, 173, 184, 202, 191, 132, 78, 67, 163, 225, 26, 161, 191, 94, 145, 129, 164, 72, 86, 191, 63, 163, 182, 0, 215, 106, 126, 165, 191, 73, 168, 175, 50, 102, 25, 151, 63, 62, 46, 22, 167, 129, 248, 185, 63, 107, 120, 4, 53, 26, 247, 164, 191, 72, 137, 59, 63, 208, 38, 189, 63, 202, 16, 60, 2, 195, 65, 194, 63, 35, 206, 66, 164, 83, 128, 184, 191, 223, 113, 103, 161, 245, 35, 188, 191, 172, 104, 226, 92, 204, 114, 177, 191, 240, 4, 65, 82, 158, 152, 139, 191, 42, 9, 254, 192, 190, 39, 199, 191, 64, 49, 83, 59, 0, 90, 187, 191, 38, 150, 167, 148, 195, 92, 171, 63, 91, 85, 21, 96, 152, 209, 193, 63, 11, 26, 200, 70, 180, 32, 187, 191, 60, 149, 104, 199, 83, 37, 196, 191, 250, 46, 156, 194, 85, 222, 196, 63, 51, 210, 222, 40, 102, 158, 155, 63, 148, 150, 232, 238, 106, 193, 178, 191, 72, 11, 250, 218, 92, 135, 165, 191, 42, 70, 177, 209, 213, 223, 204, 63, 244, 161, 121, 224, 140, 205, 195, 63, 154, 131, 23, 226, 91, 167, 182, 191, 182, 236, 6, 37, 167, 55, 184, 63, 56, 234, 9, 65, 71, 122, 179, 191, 174, 186, 211, 33, 237, 130, 192, 63, 122, 31, 182, 117, 224, 110, 177, 191, 210, 84, 185, 83, 245, 82, 174, 63, 37, 96, 25, 39, 180, 46, 190, 191, 153, 26, 75, 1, 24, 157, 183, 63, 166, 118, 236, 7, 58, 148, 191, 191, 208, 77, 123, 130, 108, 86, 29, 63, 73, 216, 41, 202, 233, 55, 160, 191, 224, 164, 28, 204, 22, 184, 192, 63, 164, 239, 253, 143, 182, 248, 195, 191, 124, 237, 207, 224, 242, 55, 152, 63, 162, 133, 39, 75, 195, 123, 195, 191, 182, 12, 122, 202, 31, 255, 141, 63, 78, 103, 215, 1, 164, 146, 160, 63, 152, 80, 22, 54, 198, 22, 100, 63, 94, 102, 193, 182, 24, 92, 180, 191, 3, 40, 119, 100, 46, 151, 200, 63, 61, 182, 157, 95, 29, 137, 183, 191, 18, 132, 81, 128, 4, 45, 172, 191, 219, 164, 133, 191, 209, 183, 191, 191, 53, 89, 159, 180, 154, 211, 152, 63, 32, 167, 48, 152, 66, 107, 171, 63, 239, 181, 204, 254, 34, 207, 162, 191, 99, 121, 94, 3, 42, 67, 182, 63, 196, 7, 120, 85, 247, 163, 150, 191, 191, 33, 127, 19, 63, 132, 141, 63, 40, 46, 72, 177, 127, 38, 218, 63, 120, 91, 75, 210, 27, 40, 196, 191, 250, 244, 219, 245, 255, 70, 192, 191, 124, 61, 23, 90, 151, 184, 152, 63, 231, 171, 150, 227, 183, 10, 161, 191, 192, 221, 40, 234, 239, 73, 113, 191, 105, 69, 229, 9, 196, 13, 179, 191, 92, 44, 90, 176, 38, 210, 161, 63, 84, 66, 26, 251, 247, 94, 185, 63, 12, 228, 140, 209, 149, 204, 161, 63, 48, 195, 117, 241, 231, 11, 171, 63, 161, 73, 177, 203, 138, 110, 196, 191, 176, 33, 182, 80, 215, 85, 183, 191, 74, 58, 243, 188, 53, 21, 161, 63, 136, 205, 8, 137, 4, 5, 182, 191, 61, 71, 68, 115, 254, 44, 188, 191, 55, 11, 158, 24, 198, 102, 196, 63, 5, 185, 167, 159, 247, 235, 191, 63, 117, 204, 213, 230, 211, 13, 181, 191, 111, 61, 26, 223, 208, 149, 159, 191, 161, 127, 149, 188, 64, 127, 187, 191, 82, 29, 65, 115, 95, 82, 178, 63, 87, 207, 60, 101, 209, 131, 192, 63, 23, 23, 184, 128, 57, 46, 193, 191, 88, 135, 142, 217, 121, 181, 193, 191, 101, 236, 233, 91, 151, 211, 189, 63, 225, 86, 86, 100, 96, 45, 143, 63, 239, 228, 244, 109, 23, 154, 155, 191, 2, 53, 114, 200, 128, 86, 122, 63, 97, 34, 106, 242, 33, 68, 195, 63, 128, 132, 7, 57, 164, 118, 158, 191, 82, 113, 47, 241, 76, 204, 192, 191, 21, 7, 143, 109, 174, 239, 180, 63, 7, 195, 96, 78, 115, 221, 194, 63, 77, 150, 94, 159, 131, 158, 197, 191, 244, 123, 197, 168, 251, 135, 182, 63, 35, 229, 177, 241, 223, 59, 207, 63, 224, 172, 22, 24, 1, 73, 189, 191, 146, 163, 35, 183, 109, 148, 180, 63, 174, 76, 159, 255, 77, 69, 173, 63, 107, 144, 96, 93, 143, 84, 193, 191, 8, 114, 216, 242, 138, 88, 158, 63, 180, 157, 194, 26, 65, 76, 106, 191, 118, 58, 21, 20, 196, 168, 146, 191, 75, 68, 75, 74, 111, 22, 185, 63, 170, 204, 157, 65, 194, 132, 182, 191, 50, 74, 228, 104, 161, 19, 194, 63, 199, 24, 113, 224, 37, 57, 164, 63, 140, 127, 40, 220, 137, 239, 163, 191, 247, 254, 161, 101, 77, 176, 197, 191, 113, 204, 252, 17, 14, 75, 191, 63, 72, 138, 90, 13, 56, 190, 178, 63, 104, 250, 106, 248, 77, 35, 166, 191, 39, 116, 242, 28, 242, 250, 155, 63, 173, 59, 15, 28, 242, 121, 182, 191, 65, 88, 230, 221, 51, 143, 202, 191, 74, 248, 106, 107, 54, 7, 175, 63, 36, 7, 160, 41, 199, 108, 181, 63, 115, 204, 86, 94, 41, 141, 182, 191, 93, 164, 67, 8, 34, 78, 151, 191, 221, 55, 169, 75, 174, 63, 127, 63, 57, 22, 201, 160, 39, 208, 174, 63, 135, 46, 37, 212, 255, 115, 194, 191, 24, 129, 81, 193, 1, 48, 200, 191, 21, 163, 58, 105, 0, 150, 170, 191, 168, 34, 172, 105, 55, 165, 181, 63, 235, 84, 129, 3, 53, 169, 195, 191, 194, 229, 102, 120, 171, 72, 179, 191, 130, 203, 56, 170, 45, 42, 157, 63, 192, 133, 156, 255, 50, 87, 156, 191, 21, 131, 20, 145, 40, 223, 178, 63, 91, 32, 87, 48, 92, 168, 166, 63, 42, 222, 154, 188, 166, 23, 192, 191, 214, 209, 117, 212, 79, 153, 165, 191, 233, 86, 252, 237, 128, 242, 199, 191, 193, 211, 4, 173, 228, 195, 160, 63, 198, 152, 42, 18, 245, 188, 186, 191, 150, 120, 117, 47, 86, 167, 198, 191, 206, 182, 125, 20, 215, 57, 178, 63, 74, 122, 112, 93, 100, 195, 170, 63, 249, 39, 2, 55, 40, 81, 186, 63, 6, 132, 209, 165, 8, 223, 170, 191, 30, 86, 137, 123, 223, 3, 180, 63, 128, 116, 167, 170, 94, 101, 195, 191, 140, 92, 169, 13, 247, 235, 188, 63, 115, 112, 141, 109, 131, 128, 175, 191, 116, 68, 125, 11, 59, 68, 169, 191, 219, 104, 104, 108, 109, 211, 193, 191, 249, 94, 96, 203, 163, 179, 188, 63, 183, 116, 144, 115, 30, 14, 194, 191, 24, 86, 72, 208, 88, 94, 192, 63, 108, 46, 106, 152, 57, 51, 148, 63, 251, 30, 21, 196, 174, 235, 188, 191, 241, 20, 24, 196, 101, 184, 146, 63, 192, 88, 254, 50, 60, 27, 190, 63, 38, 197, 144, 125, 87, 179, 176, 191, 251, 168, 141, 38, 198, 135, 192, 63, 224, 94, 84, 19, 13, 227, 197, 191, 235, 18, 132, 162, 56, 44, 157, 63, 143, 6, 132, 86, 196, 241, 164, 63, 168, 163, 41, 80, 17, 136, 166, 191, 6, 202, 77, 225, 244, 153, 194, 63, 173, 179, 48, 43, 201, 201, 155, 63, 21, 139, 218, 217, 191, 55, 177, 191, 53, 112, 14, 138, 253, 80, 152, 63, 113, 102, 197, 55, 118, 55, 192, 191, 126, 214, 110, 49, 232, 186, 204, 63, 15, 154, 138, 57, 135, 155, 190, 191, 110, 134, 92, 171, 216, 90, 211, 191, 162, 147, 95, 183, 48, 68, 193, 63, 216, 114, 211, 202, 14, 100, 183, 63, 208, 218, 224, 110, 197, 91, 146, 191, 67, 111, 114, 101, 226, 72, 161, 191, 64, 77, 129, 136, 44, 175, 176, 63, 174, 14, 39, 196, 62, 88, 167, 63, 34, 228, 30, 46, 235, 18, 175, 191, 82, 155, 163, 79, 66, 80, 186, 63, 16, 20, 80, 230, 124, 41, 188, 63, 211, 88, 37, 151, 234, 45, 183, 63, 30, 39, 199, 127, 7, 77, 187, 63, 39, 61, 74, 162, 33, 158, 195, 63, 49, 37, 4, 142, 120, 238, 189, 63, 130, 8, 95, 207, 82, 148, 162, 191, 171, 189, 74, 35, 18, 165, 191, 63, 150, 200, 62, 167, 224, 188, 99, 63, 119, 57, 96, 8, 118, 36, 185, 63, 205, 181, 144, 125, 84, 54, 201, 63, 0, 49, 223, 224, 246, 6, 159, 63, 229, 44, 63, 52, 46, 225, 189, 191, 186, 63, 15, 139, 219, 88, 157, 63, 224, 210, 184, 76, 218, 203, 49, 63, 71, 230, 75, 55, 10, 230, 189, 191, 88, 168, 22, 104, 255, 202, 109, 191, 252, 83, 35, 200, 230, 250, 195, 63, 252, 8, 61, 120, 127, 101, 183, 63, 222, 92, 69, 35, 21, 21, 185, 191, 88, 242, 92, 245, 26, 24, 181, 191, 249, 159, 134, 20, 188, 38, 187, 191, 138, 150, 197, 33, 236, 96, 139, 63, 115, 202, 149, 203, 249, 228, 194, 191, 64, 113, 141, 76, 113, 90, 195, 191, 230, 209, 218, 120, 0, 147, 161, 191, 228, 175, 205, 232, 183, 146, 181, 63, 4, 236, 216, 218, 139, 67, 182, 63, 145, 198, 226, 73, 240, 215, 195, 191, 180, 209, 48, 172, 196, 205, 149, 191, 158, 120, 1, 218, 236, 35, 189, 63, 82, 16, 254, 3, 58, 16, 205, 191, 75, 190, 157, 124, 184, 61, 185, 191, 238, 175, 29, 69, 169, 126, 193, 63, 203, 97, 186, 88, 14, 78, 194, 191, 120, 191, 189, 84, 246, 211, 194, 191, 65, 113, 116, 41, 52, 81, 186, 63, 209, 156, 80, 94, 172, 223, 179, 191, 190, 14, 142, 63, 196, 128, 146, 191, 0, 145, 192, 71, 45, 110, 196, 63, 76, 166, 19, 45, 7, 130, 196, 191, 246, 71, 85, 221, 3, 236, 132, 63, 102, 137, 99, 254, 109, 73, 189, 191, 229, 140, 99, 179, 75, 34, 147, 191, 61, 2, 170, 25, 114, 187, 187, 63, 43, 54, 249, 52, 60, 207, 201, 191, 177, 132, 221, 160, 193, 121, 148, 63, 56, 162, 125, 128, 7, 197, 174, 63, 245, 27, 20, 237, 76, 162, 132, 63, 163, 51, 80, 15, 208, 229, 194, 191, 34, 156, 88, 171, 234, 90, 143, 191, 48, 24, 212, 145, 144, 83, 160, 63, 136, 97, 104, 38, 50, 121, 199, 191, 169, 228, 127, 142, 239, 135, 162, 63, 196, 115, 179, 227, 193, 199, 191, 63, 162, 222, 229, 58, 62, 165, 162, 191, 145, 92, 229, 218, 211, 3, 187, 63, 231, 186, 154, 24, 213, 109, 163, 63, 11, 7, 242, 144, 50, 61, 184, 191, 98, 136, 149, 60, 35, 7, 149, 191, 235, 222, 187, 81, 199, 230, 174, 191, 110, 186, 5, 211, 109, 237, 183, 191, 8, 22, 153, 181, 222, 23, 181, 63, 155, 228, 146, 165, 103, 220, 195, 63, 235, 31, 233, 201, 179, 196, 194, 63, 123, 154, 181, 22, 94, 64, 175, 191, 56, 114, 175, 207, 246, 136, 168, 191, 134, 194, 217, 129, 17, 119, 207, 63, 144, 7, 213, 207, 45, 72, 190, 63, 68, 116, 129, 57, 236, 92, 203, 191, 35, 72, 100, 172, 133, 225, 164, 63, 62, 247, 214, 30, 96, 175, 194, 191, 216, 214, 247, 57, 76, 154, 184, 63, 46, 229, 75, 48, 242, 232, 192, 191, 170, 87, 113, 191, 164, 253, 113, 63, 254, 183, 155, 35, 94, 185, 185, 191, 9, 99, 211, 255, 11, 148, 198, 63, 78, 0, 2, 139, 175, 131, 140, 191, 9, 194, 137, 115, 214, 151, 186, 191, 205, 146, 175, 147, 216, 178, 136, 191, 30, 138, 215, 56, 88, 76, 157, 191, 224, 145, 225, 223, 226, 106, 186, 191, 206, 79, 149, 43, 122, 150, 160, 63, 182, 220, 7, 93, 0, 190, 186, 63, 96, 226, 238, 44, 242, 76, 156, 191, 246, 5, 117, 12, 5, 1, 181, 63, 100, 108, 242, 98, 4, 130, 119, 63, 72, 181, 250, 228, 178, 81, 200, 63, 23, 46, 84, 225, 166, 52, 183, 191, 150, 174, 140, 82, 217, 155, 164, 191, 70, 107, 37, 250, 172, 92, 194, 191, 220, 216, 19, 135, 222, 131, 165, 63, 29, 39, 22, 4, 150, 104, 182, 63, 223, 104, 139, 252, 110, 239, 153, 63, 248, 38, 234, 146, 201, 249, 155, 63, 148, 14, 199, 122, 217, 146, 166, 63, 72, 255, 175, 236, 249, 34, 205, 191, 204, 182, 15, 62, 25, 230, 207, 63, 24, 181, 137, 86, 242, 211, 133, 191, 79, 216, 73, 107, 198, 126, 195, 63, 42, 110, 233, 64, 244, 210, 197, 63, 126, 65, 72, 232, 164, 193, 189, 191, 65, 34, 57, 7, 63, 206, 146, 191, 228, 158, 8, 255, 109, 237, 167, 63, 64, 230, 190, 37, 167, 131, 84, 191, 195, 151, 20, 140, 173, 61, 199, 191, 109, 201, 127, 164, 101, 88, 188, 191, 246, 122, 244, 6, 57, 165, 194, 63, 176, 6, 91, 30, 214, 136, 185, 63, 161, 10, 236, 148, 157, 67, 197, 63, 188, 137, 26, 150, 58, 40, 149, 191, 16, 200, 52, 30, 99, 63, 165, 191, 137, 65, 174, 82, 196, 232, 180, 191, 172, 31, 252, 103, 228, 243, 167, 191, 141, 41, 39, 101, 90, 17, 188, 191, 127, 152, 93, 244, 48, 195, 133, 63, 195, 180, 121, 125, 18, 91, 198, 191, 200, 121, 242, 161, 59, 45, 199, 191, 30, 91, 238, 251, 228, 148, 147, 63, 50, 213, 16, 238, 70, 56, 191, 191, 221, 81, 151, 83, 163, 74, 176, 63, 203, 15, 153, 171, 207, 248, 158, 63, 34, 253, 21, 241, 141, 27, 175, 63, 190, 154, 57, 130, 75, 51, 188, 63, 152, 139, 252, 247, 218, 50, 196, 63, 103, 193, 47, 24, 19, 201, 173, 63, 234, 237, 175, 89, 82, 123, 171, 63, 44, 166, 79, 117, 177, 113, 184, 63, 181, 47, 64, 123, 10, 62, 176, 63, 79, 35, 201, 146, 167, 89, 148, 191, 24, 207, 99, 154, 51, 198, 187, 63, 82, 122, 26, 172, 231, 221, 168, 191, 216, 226, 245, 229, 215, 79, 194, 63, 63, 107, 54, 132, 197, 241, 196, 63, 92, 173, 181, 19, 229, 220, 189, 63, 100, 74, 75, 81, 168, 16, 197, 63, 8, 34, 71, 151, 146, 55, 152, 63, 144, 135, 172, 182, 60, 56, 184, 63, 72, 37, 237, 208, 20, 103, 171, 191, 249, 157, 101, 201, 20, 128, 194, 191, 250, 138, 69, 175, 143, 8, 196, 191, 192, 226, 221, 227, 234, 17, 170, 63, 197, 171, 13, 26, 184, 140, 155, 191, 189, 7, 69, 162, 13, 46, 209, 191, 230, 104, 185, 180, 248, 94, 185, 63, 85, 191, 30, 142, 229, 24, 164, 63, 140, 105, 63, 118, 79, 9, 194, 63, 131, 20, 232, 91, 228, 3, 183, 191, 233, 91, 30, 74, 157, 114, 162, 191, 145, 33, 145, 152, 30, 41, 176, 63, 193, 204, 178, 102, 10, 145, 191, 63, 51, 251, 145, 123, 222, 159, 198, 191, 98, 46, 153, 99, 60, 38, 170, 63, 241, 141, 119, 9, 21, 215, 165, 63, 199, 220, 14, 38, 29, 218, 180, 191, 16, 238, 226, 149, 141, 136, 180, 63, 16, 65, 103, 212, 117, 13, 162, 63, 104, 33, 196, 123, 238, 251, 202, 191, 167, 229, 15, 41, 136, 4, 190, 63, 130, 15, 228, 21, 182, 161, 144, 191, 116, 119, 161, 251, 57, 176, 153, 191, 113, 161, 108, 44, 59, 149, 183, 63, 6, 71, 179, 154, 143, 20, 192, 191, 60, 14, 218, 63, 180, 241, 168, 63, 154, 180, 241, 156, 173, 130, 176, 191, 229, 99, 126, 132, 202, 238, 196, 191, 95, 195, 138, 122, 212, 64, 194, 63, 90, 101, 106, 60, 30, 126, 169, 191, 211, 239, 182, 254, 176, 54, 139, 63, 28, 79, 16, 102, 88, 227, 169, 191, 8, 208, 97, 172, 45, 137, 178, 191, 140, 176, 71, 213, 23, 105, 133, 63, 248, 229, 19, 229, 124, 54, 197, 191, 150, 188, 166, 115, 251, 250, 180, 63, 54, 32, 5, 187, 168, 4, 196, 191, 38, 171, 249, 166, 108, 69, 147, 63, 177, 123, 193, 124, 61, 231, 200, 63, 57, 154, 87, 112, 180, 21, 203, 191, 162, 143, 75, 112, 3, 85, 179, 63, 204, 14, 180, 212, 87, 128, 177, 63, 254, 232, 7, 0, 104, 22, 185, 63, 113, 168, 165, 243, 2, 122, 197, 191, 38, 108, 124, 85, 94, 156, 151, 191, 98, 150, 132, 30, 186, 47, 152, 191, 204, 197, 236, 195, 238, 179, 167, 63, 119, 60, 143, 246, 160, 242, 171, 63, 118, 6, 101, 65, 204, 194, 187, 191, 55, 38, 181, 54, 5, 120, 136, 63, 73, 14, 140, 209, 242, 18, 200, 191, 136, 129, 115, 70, 67, 250, 200, 63, 140, 145, 119, 151, 87, 242, 152, 191, 64, 62, 86, 106, 31, 99, 193, 63, 235, 109, 56, 200, 8, 0, 177, 63, 40, 36, 238, 234, 73, 101, 150, 63, 195, 246, 187, 175, 55, 188, 177, 63, 231, 49, 127, 117, 214, 240, 174, 63, 133, 99, 207, 65, 207, 101, 180, 191, 194, 50, 180, 109, 22, 60, 175, 191, 135, 187, 111, 155, 227, 146, 163, 191, 36, 0, 77, 83, 80, 101, 183, 191, 24, 120, 115, 15, 108, 212, 184, 63, 248, 180, 47, 12, 35, 67, 139, 191, 126, 8, 222, 93, 10, 187, 194, 63, 200, 122, 235, 67, 192, 247, 171, 191, 102, 190, 61, 58, 100, 133, 203, 63, 182, 153, 44, 40, 177, 129, 199, 191, 142, 210, 175, 126, 227, 115, 171, 63, 167, 83, 35, 61, 134, 61, 195, 191, 126, 90, 254, 128, 250, 181, 130, 63, 29, 16, 234, 232, 184, 210, 191, 191, 8, 165, 209, 225, 52, 201, 181, 191, 120, 171, 28, 94, 9, 216, 171, 191, 139, 222, 80, 252, 220, 227, 172, 191, 121, 173, 64, 252, 156, 46, 162, 191, 8, 52, 107, 158, 169, 32, 171, 63, 76, 80, 113, 180, 151, 244, 193, 191, 101, 232, 7, 171, 172, 55, 184, 63, 178, 117, 7, 165, 235, 231, 193, 191, 121, 93, 55, 19, 229, 231, 157, 191, 59, 23, 160, 224, 228, 221, 180, 63, 54, 206, 35, 152, 105, 244, 194, 191, 42, 70, 18, 18, 153, 12, 176, 63, 197, 158, 5, 148, 63, 236, 181, 191, 27, 13, 51, 134, 113, 129, 166, 191, 121, 204, 102, 251, 39, 217, 179, 191, 26, 97, 187, 38, 96, 232, 139, 191, 65, 127, 180, 10, 159, 241, 184, 63, 19, 35, 25, 88, 18, 209, 186, 63, 203, 6, 222, 87, 0, 124, 183, 63, 20, 252, 47, 94, 251, 27, 168, 191, 49, 116, 122, 164, 214, 251, 169, 63, 22, 19, 25, 40, 5, 113, 199, 191, 33, 127, 226, 123, 9, 175, 193, 63, 251, 99, 162, 121, 10, 114, 133, 63, 180, 164, 122, 46, 30, 25, 179, 63, 182, 30, 230, 185, 176, 245, 184, 191, 168, 144, 243, 33, 66, 245, 163, 63, 108, 217, 67, 250, 147, 155, 178, 63, 171, 237, 185, 82, 107, 166, 161, 63, 94, 30, 236, 229, 172, 215, 192, 63, 99, 40, 17, 114, 18, 171, 191, 191, 241, 154, 156, 208, 169, 131, 185, 63, 161, 164, 29, 60, 26, 147, 197, 191, 226, 150, 245, 245, 80, 2, 186, 191, 40, 255, 248, 166, 162, 107, 211, 191, 184, 36, 186, 109, 127, 156, 144, 63, 34, 100, 225, 55, 159, 96, 176, 191, 164, 247, 201, 128, 183, 77, 183, 191, 134, 30, 8, 4, 183, 224, 189, 191, 210, 188, 164, 40, 210, 98, 203, 63, 160, 218, 188, 85, 2, 48, 74, 191, 181, 37, 60, 246, 127, 218, 187, 63, 134, 77, 250, 46, 20, 233, 184, 63, 2, 64, 97, 253, 75, 156, 179, 63, 48, 81, 57, 56, 38, 30, 139, 191, 125, 246, 35, 218, 44, 3, 195, 63, 60, 167, 3, 33, 172, 13, 195, 63, 208, 148, 5, 151, 250, 123, 130, 191, 1, 230, 43, 49, 30, 233, 186, 191, 105, 25, 169, 205, 219, 254, 150, 191, 33, 145, 132, 120, 38, 20, 184, 63, 101, 182, 204, 105, 188, 62, 198, 63, 22, 232, 185, 42, 4, 201, 158, 191, 14, 209, 56, 124, 196, 34, 182, 191, 129, 254, 180, 219, 29, 75, 133, 63, 247, 36, 218, 9, 184, 250, 192, 191, 218, 32, 181, 100, 197, 197, 117, 191, 167, 197, 216, 188, 205, 163, 145, 63, 245, 126, 68, 172, 11, 60, 199, 63, 20, 169, 237, 117, 231, 92, 174, 191, 59, 28, 190, 145, 27, 248, 191, 191, 125, 241, 114, 143, 85, 169, 144, 63, 29, 179, 64, 196, 156, 244, 187, 63, 127, 115, 179, 14, 201, 64, 165, 63, 222, 249, 39, 41, 208, 209, 178, 191, 72, 212, 37, 218, 176, 46, 115, 191, 12, 251, 147, 240, 10, 117, 184, 191, 50, 59, 225, 84, 87, 239, 179, 63, 171, 68, 4, 11, 22, 235, 186, 191, 120, 113, 153, 143, 90, 252, 196, 191, 118, 220, 243, 5, 82, 128, 185, 63, 80, 19, 50, 188, 55, 226, 131, 63, 112, 16, 0, 230, 205, 3, 174, 191, 10, 163, 115, 222, 228, 223, 210, 63, 100, 212, 107, 154, 163, 212, 198, 63, 92, 225, 41, 199, 155, 248, 197, 191, 188, 42, 53, 100, 94, 29, 128, 191, 244, 103, 201, 193, 62, 245, 194, 191, 161, 251, 192, 177, 25, 133, 184, 63, 223, 125, 51, 23, 239, 61, 171, 191, 178, 22, 102, 169, 131, 18, 196, 191, 28, 46, 129, 185, 119, 161, 148, 191, 250, 248, 145, 152, 57, 102, 133, 63, 65, 41, 123, 112, 134, 169, 188, 63, 34, 205, 96, 6, 191, 135, 199, 63, 179, 190, 67, 245, 24, 218, 165, 63, 183, 67, 17, 251, 47, 55, 134, 191, 16, 122, 112, 226, 119, 211, 60, 63, 88, 229, 147, 236, 36, 21, 156, 191, 145, 20, 24, 36, 228, 213, 199, 191, 41, 51, 154, 216, 100, 157, 197, 191, 6, 45, 116, 104, 11, 167, 172, 191, 91, 250, 118, 148, 147, 42, 164, 63, 52, 244, 77, 93, 77, 52, 122, 191, 101, 0, 175, 110, 215, 221, 118, 63, 0, 177, 142, 102, 221, 236, 121, 63, 55, 53, 64, 55, 23, 213, 169, 63, 94, 64, 98, 10, 53, 155, 208, 63, 153, 215, 125, 8, 1, 120, 196, 63, 3, 124, 220, 139, 54, 2, 180, 63, 47, 149, 166, 12, 155, 211, 176, 191, 65, 153, 179, 152, 253, 128, 149, 191, 153, 133, 40, 112, 115, 24, 128, 63, 162, 95, 99, 73, 201, 7, 155, 191, 19, 61, 9, 136, 255, 99, 146, 191, 185, 148, 11, 231, 190, 228, 180, 191, 84, 38, 168, 16, 105, 213, 188, 191, 67, 42, 194, 137, 88, 142, 206, 191, 84, 100, 240, 21, 80, 179, 180, 191, 105, 230, 118, 19, 138, 193, 195, 191, 197, 155, 164, 219, 100, 78, 147, 63, 238, 5, 109, 126, 1, 92, 183, 63, 75, 71, 162, 246, 92, 174, 176, 63, 124, 154, 177, 126, 230, 103, 145, 191, 214, 141, 221, 129, 95, 154, 184, 63, 139, 36, 241, 62, 111, 249, 179, 191, 255, 173, 169, 51, 143, 186, 183, 63, 100, 45, 202, 105, 183, 16, 189, 63, 51, 165, 188, 148, 167, 167, 190, 191, 170, 82, 69, 189, 251, 8, 182, 191, 112, 20, 110, 142, 102, 60, 150, 191, 55, 28, 99, 88, 59, 7, 193, 63, 211, 97, 9, 13, 104, 187, 172, 63, 5, 229, 56, 206, 204, 158, 193, 191, 75, 247, 82, 188, 179, 106, 197, 191, 230, 112, 194, 8, 94, 175, 132, 191, 169, 220, 68, 4, 129, 128, 185, 191, 201, 234, 196, 163, 57, 84, 167, 63, 61, 86, 171, 156, 243, 48, 179, 63, 34, 144, 142, 143, 129, 78, 164, 191, 66, 5, 167, 45, 176, 59, 180, 191, 34, 123, 38, 51, 220, 88, 202, 191, 13, 114, 235, 128, 235, 228, 181, 191, 206, 126, 129, 152, 187, 110, 179, 63, 91, 177, 193, 19, 56, 101, 179, 191, 8, 136, 91, 102, 15, 92, 184, 191, 252, 200, 140, 125, 4, 58, 171, 63, 127, 233, 32, 45, 81, 24, 163, 191, 67, 6, 12, 233, 249, 154, 190, 191, 182, 186, 109, 61, 135, 6, 139, 191, 20, 62, 37, 189, 96, 117, 198, 191, 226, 204, 70, 185, 236, 147, 199, 191, 248, 164, 27, 15, 156, 123, 190, 191, 10, 142, 129, 146, 166, 221, 178, 63, 62, 10, 141, 241, 61, 211, 181, 63, 72, 233, 239, 103, 133, 38, 199, 191, 47, 33, 142, 253, 87, 151, 174, 191, 218, 161, 213, 181, 211, 48, 200, 63, 240, 5, 114, 204, 59, 100, 193, 191, 45, 46, 254, 1, 176, 13, 191, 191, 89, 246, 215, 166, 166, 55, 184, 63, 16, 210, 96, 182, 25, 72, 192, 63, 42, 250, 63, 26, 128, 167, 115, 63, 10, 18, 16, 203, 142, 174, 186, 191, 245, 12, 222, 52, 161, 71, 198, 191, 73, 174, 66, 23, 86, 137, 132, 63, 191, 43, 144, 20, 238, 196, 185, 191, 64, 2, 124, 197, 40, 49, 144, 191, 31, 170, 17, 166, 124, 58, 147, 191, 34, 163, 224, 155, 26, 233, 192, 63, 162, 15, 80, 239, 221, 38, 145, 191, 138, 68, 13, 80, 147, 113, 189, 191, 234, 134, 19, 213, 255, 54, 156, 191, 122, 245, 96, 5, 45, 125, 184, 63, 252, 44, 99, 64, 226, 192, 96, 63, 104, 113, 55, 175, 133, 216, 196, 63, 170, 48, 134, 137, 195, 41, 154, 63, 200, 242, 137, 171, 133, 137, 156, 63, 195, 53, 55, 196, 183, 205, 195, 63, 49, 222, 92, 192, 198, 52, 167, 191, 194, 175, 123, 26, 39, 249, 185, 63, 177, 16, 173, 47, 250, 211, 154, 63, 188, 0, 234, 133, 33, 252, 115, 63, 153, 25, 154, 35, 184, 136, 160, 63, 58, 55, 96, 14, 254, 21, 200, 191, 61, 127, 193, 77, 192, 54, 203, 191, 216, 135, 248, 224, 250, 36, 191, 191, 250, 9, 134, 55, 148, 208, 195, 191, 126, 117, 69, 81, 88, 180, 161, 191, 112, 80, 115, 214, 201, 170, 182, 63, 19, 173, 152, 45, 121, 223, 160, 191, 232, 239, 158, 59, 158, 41, 169, 63, 2, 38, 185, 95, 203, 136, 192, 63, 12, 41, 78, 236, 15, 139, 207, 191, 164, 67, 113, 78, 41, 231, 139, 63, 152, 98, 134, 33, 84, 198, 204, 63, 81, 18, 26, 215, 242, 232, 184, 63, 102, 202, 88, 238, 73, 154, 166, 63, 23, 93, 63, 140, 87, 201, 165, 191, 96, 119, 5, 175, 200, 248, 195, 191, 30, 104, 19, 116, 13, 209, 182, 191, 98, 119, 8, 56, 16, 23, 159, 191, 78, 165, 48, 158, 82, 143, 179, 191, 201, 193, 213, 251, 166, 51, 183, 63, 188, 146, 225, 71, 177, 249, 193, 63, 74, 222, 13, 105, 77, 213, 188, 63, 135, 182, 13, 159, 74, 22, 178, 63, 0, 239, 243, 129, 189, 65, 30, 191, 168, 82, 236, 87, 15, 85, 184, 63, 202, 2, 87, 2, 3, 174, 182, 63, 164, 230, 246, 184, 203, 134, 185, 191, 210, 56, 126, 245, 10, 43, 188, 191, 83, 39, 174, 4, 166, 95, 197, 191, 77, 38, 178, 235, 96, 184, 191, 191, 135, 48, 41, 26, 135, 180, 161, 63, 59, 218, 122, 8, 4, 32, 160, 63, 177, 206, 3, 107, 247, 228, 159, 63, 52, 35, 104, 66, 86, 14, 193, 191, 202, 145, 226, 164, 253, 226, 175, 191, 253, 2, 69, 14, 17, 135, 184, 63, 137, 177, 141, 248, 29, 135, 173, 63, 117, 179, 112, 108, 217, 151, 200, 63, 168, 78, 207, 74, 30, 38, 211, 63, 96, 222, 131, 198, 210, 37, 154, 191, 51, 39, 110, 110, 209, 55, 200, 191, 3, 124, 166, 112, 96, 143, 186, 63, 53, 140, 98, 116, 201, 131, 174, 191, 152, 188, 240, 224, 91, 137, 193, 191, 48, 12, 86, 28, 97, 4, 165, 63, 224, 146, 40, 213, 52, 223, 187, 63, 2, 182, 167, 128, 107, 8, 148, 191, 170, 192, 54, 111, 211, 18, 193, 191, 254, 248, 113, 156, 77, 80, 186, 63, 30, 191, 146, 36, 170, 47, 130, 191, 250, 1, 36, 225, 18, 146, 193, 191, 250, 170, 115, 59, 116, 232, 188, 191, 81, 88, 139, 186, 175, 177, 135, 63, 9, 205, 92, 38, 82, 125, 130, 63, 196, 11, 148, 13, 101, 232, 179, 63, 247, 60, 14, 247, 30, 156, 201, 63, 145, 64, 137, 142, 44, 32, 182, 63, 2, 55, 13, 211, 176, 232, 132, 191, 169, 155, 245, 51, 155, 118, 145, 191, 38, 139, 37, 98, 59, 24, 150, 191, 74, 131, 197, 217, 222, 128, 133, 63, 121, 92, 103, 209, 79, 107, 203, 191, 118, 174, 193, 24, 74, 159, 197, 191, 224, 124, 54, 230, 85, 51, 167, 191, 232, 133, 187, 136, 184, 54, 135, 63, 29, 131, 138, 165, 191, 42, 148, 63, 216, 170, 52, 4, 114, 178, 152, 63, 21, 132, 23, 79, 5, 214, 130, 63, 220, 9, 46, 103, 196, 118, 191, 191, 251, 55, 192, 207, 198, 186, 190, 63, 77, 82, 239, 179, 72, 154, 205, 63, 140, 53, 76, 163, 119, 51, 194, 63, 203, 70, 62, 67, 83, 253, 156, 63, 90, 198, 172, 38, 175, 17, 117, 191, 124, 158, 223, 164, 112, 63, 190, 191, 196, 13, 150, 161, 31, 105, 118, 63, 78, 179, 216, 113, 23, 220, 184, 63, 106, 68, 30, 67, 62, 241, 164, 191, 69, 5, 2, 27, 234, 79, 183, 63, 174, 240, 36, 45, 9, 121, 203, 63, 18, 96, 144, 147, 37, 127, 166, 191, 123, 237, 89, 198, 100, 58, 208, 191, 253, 85, 30, 237, 12, 96, 194, 191, 232, 171, 132, 165, 1, 82, 184, 63, 102, 169, 232, 47, 95, 154, 184, 63, 111, 80, 245, 58, 174, 82, 172, 63, 144, 24, 147, 16, 207, 120, 195, 191, 97, 123, 85, 217, 237, 239, 162, 191, 212, 203, 248, 108, 24, 137, 148, 191, 223, 158, 138, 42, 244, 203, 185, 191, 110, 59, 68, 184, 234, 188, 197, 63, 74, 44, 177, 223, 226, 127, 174, 63, 20, 211, 14, 252, 201, 113, 134, 191, 0, 224, 17, 243, 219, 106, 209, 190, 247, 78, 156, 78, 233, 89, 164, 63, 156, 54, 0, 224, 254, 73, 199, 63, 238, 206, 112, 132, 125, 196, 195, 191, 239, 17, 234, 232, 165, 38, 182, 191, 40, 82, 154, 141, 150, 59, 142, 63, 208, 238, 212, 41, 17, 252, 82, 63, 146, 68, 89, 216, 16, 221, 85, 191, 14, 157, 93, 41, 220, 223, 133, 191, 120, 91, 17, 84, 180, 103, 178, 191, 204, 28, 47, 39, 43, 71, 207, 191, 253, 117, 152, 245, 202, 246, 189, 63, 125, 11, 131, 103, 223, 124, 188, 63, 104, 252, 93, 105, 77, 90, 175, 191, 102, 144, 145, 221, 70, 31, 134, 191, 64, 1, 232, 217, 192, 120, 125, 63, 122, 2, 64, 12, 155, 45, 156, 63, 198, 137, 252, 205, 106, 255, 196, 63, 232, 158, 184, 203, 198, 148, 179, 63, 250, 198, 213, 118, 154, 35, 168, 63, 42, 61, 64, 204, 146, 128, 208, 63, 59, 142, 212, 79, 22, 234, 167, 191, 76, 81, 10, 184, 40, 233, 208, 191, 0, 7, 221, 114, 177, 237, 100, 191, 172, 50, 80, 235, 54, 120, 177, 63, 108, 249, 96, 214, 3, 90, 180, 63, 48, 97, 65, 61, 189, 185, 187, 191, 150, 120, 161, 7, 21, 233, 184, 63, 7, 136, 217, 176, 178, 213, 191, 191, 104, 123, 184, 4, 87, 155, 188, 191, 150, 222, 97, 240, 255, 124, 137, 63, 236, 188, 222, 65, 196, 151, 134, 191, 235, 13, 229, 52, 250, 138, 198, 63, 194, 249, 46, 164, 66, 100, 157, 63, 164, 175, 218, 42, 255, 50, 144, 191, 173, 19, 242, 17, 78, 36, 186, 191, 48, 44, 179, 13, 248, 232, 182, 63, 139, 102, 184, 31, 77, 39, 156, 63, 146, 170, 14, 235, 162, 139, 191, 191, 40, 9, 56, 224, 131, 211, 167, 63, 236, 228, 141, 233, 255, 67, 103, 63, 143, 218, 109, 208, 187, 89, 198, 63, 144, 70, 33, 153, 135, 19, 67, 63, 230, 135, 215, 183, 96, 93, 135, 63, 207, 102, 49, 228, 195, 35, 198, 191, 79, 248, 141, 233, 103, 53, 157, 191, 243, 192, 233, 234, 214, 8, 146, 191, 6, 170, 196, 110, 212, 92, 189, 191, 20, 35, 100, 231, 72, 250, 85, 191, 62, 19, 53, 112, 3, 105, 198, 191, 81, 42, 235, 224, 82, 30, 168, 63, 93, 108, 95, 155, 123, 135, 173, 63, 156, 15, 39, 45, 108, 171, 139, 63, 105, 13, 238, 108, 9, 9, 178, 191, 93, 100, 36, 179, 38, 51, 207, 63, 152, 95, 193, 226, 136, 91, 197, 63, 185, 190, 20, 15, 21, 202, 188, 63, 224, 219, 251, 103, 224, 135, 179, 63, 32, 154, 194, 137, 235, 122, 199, 63, 181, 47, 58, 210, 159, 204, 183, 63, 24, 85, 22, 141, 123, 234, 195, 191, 4, 82, 60, 202, 167, 36, 201, 191, 88, 194, 175, 93, 80, 192, 187, 63, 136, 40, 246, 217, 220, 94, 185, 63, 191, 210, 88, 218, 29, 147, 178, 191, 203, 47, 189, 82, 250, 16, 192, 191, 145, 36, 98, 100, 84, 139, 183, 63, 135, 125, 3, 225, 213, 37, 186, 191, 67, 38, 39, 180, 194, 186, 192, 63, 160, 93, 176, 242, 10, 227, 172, 63, 124, 171, 97, 0, 148, 129, 195, 191, 180, 33, 212, 91, 107, 227, 148, 63, 9, 249, 58, 75, 122, 92, 179, 191, 34, 49, 146, 241, 36, 115, 198, 63, 207, 7, 94, 19, 11, 49, 189, 191, 65, 152, 46, 117, 37, 53, 172, 63, 191, 90, 94, 25, 30, 43, 193, 63, 93, 213, 14, 134, 4, 171, 169, 191, 102, 74, 213, 30, 246, 60, 164, 191, 227, 154, 146, 37, 122, 205, 148, 191, 14, 200, 250, 122, 122, 158, 194, 63, 40, 142, 130, 184, 57, 160, 200, 191, 253, 227, 86, 45, 88, 188, 155, 63, 148, 188, 211, 56, 137, 99, 188, 191, 49, 255, 224, 16, 99, 123, 164, 191, 64, 57, 43, 193, 141, 11, 175, 63, 244, 88, 5, 64, 31, 186, 172, 63, 93, 25, 37, 109, 204, 39, 161, 191, 21, 188, 133, 168, 132, 49, 146, 191, 152, 3, 110, 254, 160, 128, 197, 63, 36, 240, 9, 135, 40, 126, 188, 191, 250, 17, 10, 24, 162, 204, 188, 63, 216, 218, 115, 250, 237, 253, 140, 63, 220, 13, 53, 240, 109, 164, 171, 63, 71, 176, 37, 71, 60, 41, 198, 191, 120, 118, 76, 96, 243, 205, 122, 191, 9, 180, 66, 72, 8, 145, 176, 191, 15, 158, 61, 5, 60, 6, 202, 63, 90, 26, 90, 7, 84, 74, 197, 191, 42, 93, 191, 252, 202, 136, 185, 63, 14, 129, 46, 110, 172, 56, 192, 63, 109, 218, 15, 173, 35, 89, 189, 191, 60, 77, 77, 152, 166, 222, 151, 63, 150, 174, 242, 145, 127, 82, 160, 63, 3, 35, 37, 12, 135, 209, 200, 191, 160, 26, 168, 135, 103, 223, 162, 63, 154, 126, 243, 188, 27, 234, 156, 191, 95, 64, 68, 101, 169, 131, 186, 191, 84, 160, 21, 211, 158, 1, 183, 191, 66, 60, 17, 232, 95, 180, 164, 191, 240, 96, 100, 118, 61, 225, 191, 63, 70, 133, 247, 36, 4, 27, 174, 63, 64, 246, 117, 181, 80, 109, 147, 63, 186, 54, 180, 149, 59, 101, 201, 63, 226, 138, 42, 128, 190, 202, 148, 191, 42, 115, 130, 246, 190, 70, 163, 191, 200, 163, 113, 28, 103, 199, 197, 63, 121, 231, 176, 176, 232, 171, 169, 63, 42, 145, 46, 92, 189, 157, 130, 63, 186, 126, 217, 234, 65, 197, 184, 191, 92, 139, 222, 196, 11, 122, 64, 191, 45, 160, 167, 151, 8, 192, 197, 191, 132, 85, 107, 86, 210, 8, 177, 63, 234, 31, 91, 127, 128, 4, 175, 63, 25, 25, 228, 171, 47, 218, 128, 63, 126, 19, 4, 21, 33, 157, 181, 191, 169, 244, 55, 59, 76, 5, 208, 191, 109, 239, 172, 18, 126, 158, 180, 191, 156, 65, 119, 19, 193, 27, 186, 191, 51, 34, 155, 241, 190, 83, 167, 63, 110, 198, 105, 199, 233, 16, 198, 63, 23, 12, 35, 25, 70, 82, 197, 63, 171, 174, 71, 81, 246, 3, 193, 191, 244, 120, 94, 44, 36, 75, 195, 191, 68, 108, 204, 183, 159, 58, 190, 63, 139, 219, 23, 137, 42, 133, 184, 63, 189, 214, 66, 61, 1, 62, 182, 63, 70, 2, 209, 89, 184, 20, 194, 63, 136, 135, 3, 96, 84, 125, 146, 63, 157, 5, 183, 239, 217, 220, 152, 63, 48, 37, 73, 105, 125, 0, 198, 63, 81, 36, 223, 53, 216, 84, 191, 63, 190, 5, 159, 255, 34, 54, 159, 63, 55, 69, 39, 163, 101, 189, 168, 191, 101, 49, 229, 204, 139, 11, 146, 191, 195, 184, 255, 182, 192, 255, 168, 63, 197, 121, 169, 146, 36, 86, 204, 63, 75, 182, 185, 98, 13, 92, 178, 63, 247, 160, 58, 18, 85, 55, 155, 63, 61, 197, 227, 85, 247, 209, 186, 191, 87, 143, 23, 203, 243, 25, 136, 191, 134, 168, 131, 144, 8, 149, 147, 191, 148, 63, 207, 34, 148, 23, 171, 191, 136, 93, 21, 39, 78, 244, 175, 63, 48, 27, 115, 90, 241, 98, 206, 63, 182, 138, 172, 105, 89, 120, 164, 191, 42, 14, 117, 238, 70, 225, 156, 63, 157, 206, 55, 119, 93, 13, 201, 191, 78, 175, 237, 57, 236, 161, 166, 191, 110, 93, 243, 216, 3, 178, 147, 63, 168, 198, 130, 85, 130, 140, 125, 63, 250, 229, 212, 177, 24, 206, 169, 191, 182, 85, 179, 100, 164, 118, 166, 191, 24, 193, 18, 243, 202, 201, 191, 63, 159, 140, 189, 34, 97, 239, 178, 63, 181, 51, 51, 142, 17, 101, 202, 191, 210, 17, 94, 171, 59, 98, 153, 63, 145, 85, 64, 83, 101, 190, 197, 191, 28, 134, 180, 221, 61, 142, 192, 191, 231, 104, 27, 157, 25, 242, 158, 63, 90, 57, 4, 207, 156, 164, 179, 63, 147, 11, 212, 72, 104, 22, 185, 63, 74, 246, 119, 49, 134, 127, 195, 63, 231, 248, 84, 252, 67, 209, 145, 191, 46, 13, 149, 180, 228, 98, 179, 63, 53, 106, 246, 179, 63, 137, 196, 63, 229, 80, 233, 211, 13, 111, 165, 191, 178, 57, 12, 251, 69, 65, 187, 191, 117, 192, 254, 59, 158, 202, 145, 191, 165, 26, 47, 231, 20, 125, 189, 191, 82, 26, 171, 47, 123, 187, 146, 191, 59, 244, 135, 220, 176, 161, 165, 191, 193, 245, 154, 44, 9, 17, 192, 191, 20, 153, 100, 98, 100, 199, 173, 63, 94, 127, 237, 186, 220, 106, 178, 191, 52, 18, 49, 86, 157, 129, 162, 63, 82, 85, 171, 111, 6, 117, 202, 191, 57, 116, 126, 3, 138, 185, 204, 191, 49, 73, 86, 165, 253, 115, 161, 63, 166, 20, 35, 64, 126, 163, 192, 191, 221, 60, 188, 191, 58, 98, 184, 63, 239, 87, 202, 114, 48, 155, 179, 63, 225, 200, 24, 209, 212, 181, 162, 63, 113, 224, 112, 161, 81, 249, 178, 63, 149, 233, 54, 78, 189, 1, 179, 63, 138, 26, 11, 58, 180, 248, 176, 191, 148, 152, 222, 208, 197, 236, 187, 191, 199, 3, 190, 195, 164, 0, 167, 63, 60, 14, 139, 23, 173, 143, 173, 63, 250, 24, 129, 234, 154, 47, 162, 63, 199, 222, 233, 226, 81, 1, 178, 63, 237, 34, 38, 217, 140, 121, 176, 191, 156, 139, 63, 20, 41, 244, 128, 191, 44, 143, 15, 95, 102, 35, 193, 191, 88, 248, 163, 166, 142, 91, 195, 63, 13, 88, 75, 123, 77, 51, 161, 191, 144, 172, 204, 26, 170, 80, 202, 63, 65, 109, 118, 124, 42, 81, 186, 63, 52, 121, 198, 65, 212, 25, 191, 63, 252, 62, 54, 166, 8, 57, 186, 63, 142, 1, 165, 213, 244, 194, 180, 191, 38, 83, 202, 3, 94, 73, 191, 191, 186, 104, 74, 121, 241, 141, 195, 63, 183, 188, 184, 215, 116, 96, 134, 191, 135, 74, 148, 113, 117, 237, 182, 191, 30, 148, 8, 85, 231, 60, 177, 191, 228, 24, 136, 251, 193, 197, 124, 191, 154, 120, 216, 139, 126, 117, 198, 191, 235, 210, 49, 230, 92, 207, 176, 63, 165, 235, 87, 246, 242, 6, 185, 191, 26, 250, 129, 171, 123, 120, 158, 191, 73, 2, 167, 137, 4, 93, 185, 191, 22, 225, 133, 136, 112, 134, 188, 63, 244, 160, 30, 106, 8, 92, 180, 63, 144, 128, 88, 249, 170, 17, 116, 63, 231, 190, 240, 9, 145, 66, 190, 191, 61, 1, 232, 26, 59, 183, 173, 191, 16, 70, 35, 40, 34, 76, 184, 191, 107, 219, 23, 80, 79, 31, 166, 63, 22, 244, 149, 84, 234, 173, 165, 191, 167, 64, 6, 72, 20, 133, 200, 63, 191, 21, 3, 8, 14, 165, 176, 191, 130, 221, 204, 247, 205, 248, 152, 63, 38, 60, 143, 100, 144, 176, 202, 63, 11, 12, 173, 55, 233, 192, 178, 63, 0, 221, 138, 35, 34, 48, 119, 191, 228, 213, 173, 192, 163, 70, 181, 191, 30, 197, 27, 55, 247, 50, 182, 63, 134, 191, 90, 244, 241, 41, 172, 191, 26, 252, 125, 246, 229, 52, 189, 191, 38, 144, 210, 17, 102, 251, 211, 63, 99, 250, 180, 154, 125, 140, 189, 191, 126, 151, 165, 62, 79, 218, 193, 191, 106, 233, 67, 227, 26, 133, 184, 63, 109, 68, 140, 251, 41, 157, 136, 63, 37, 190, 190, 218, 97, 23, 169, 63, 245, 235, 55, 238, 49, 90, 196, 63, 202, 242, 193, 204, 197, 212, 149, 63, 5, 147, 169, 40, 250, 206, 125, 63, 98, 156, 100, 55, 213, 158, 179, 191, 26, 204, 97, 250, 188, 8, 187, 63, 164, 115, 146, 45, 226, 122, 198, 63, 53, 56, 102, 141, 65, 68, 168, 63, 52, 50, 61, 157, 212, 131, 147, 63, 46, 17, 37, 85, 4, 37, 91, 63, 148, 247, 90, 5, 85, 148, 181, 191, 103, 22, 197, 104, 72, 234, 182, 191, 204, 91, 38, 10, 169, 5, 192, 63, 118, 84, 147, 182, 232, 9, 200, 63, 95, 156, 252, 175, 15, 239, 164, 63, 188, 187, 214, 140, 48, 248, 167, 63, 113, 105, 67, 52, 95, 185, 122, 191, 107, 56, 105, 114, 127, 175, 103, 191, 254, 190, 0, 190, 74, 72, 150, 63, 103, 245, 114, 25, 52, 172, 195, 191, 99, 81, 200, 105, 27, 18, 179, 191, 71, 141, 254, 49, 12, 184, 196, 63, 116, 99, 214, 239, 67, 168, 203, 63, 167, 52, 3, 105, 209, 134, 141, 63, 21, 239, 255, 105, 227, 34, 181, 63, 42, 43, 233, 211, 19, 29, 169, 63, 186, 36, 141, 173, 244, 78, 164, 191, 192, 11, 199, 210, 133, 47, 101, 63, 59, 249, 111, 58, 248, 234, 166, 63, 124, 149, 76, 44, 27, 148, 193, 191, 161, 101, 234, 120, 111, 108, 198, 191, 224, 61, 37, 145, 5, 165, 149, 63, 32, 62, 202, 247, 219, 164, 195, 63, 193, 236, 186, 77, 134, 186, 199, 63, 201, 250, 143, 218, 75, 154, 184, 63, 180, 241, 92, 245, 232, 208, 195, 63, 30, 3, 43, 113, 139, 45, 172, 63, 143, 130, 195, 252, 200, 132, 152, 63, 251, 54, 179, 51, 251, 110, 161, 63, 166, 181, 212, 50, 141, 146, 191, 63, 46, 203, 125, 29, 111, 185, 174, 191, 254, 52, 86, 78, 60, 68, 138, 63, 228, 211, 8, 181, 193, 97, 195, 191, 31, 34, 208, 196, 100, 128, 194, 191, 217, 157, 16, 11, 96, 88, 161, 63, 235, 196, 242, 205, 69, 205, 176, 191, 237, 32, 12, 158, 201, 66, 192, 191, 66, 1, 177, 167, 60, 201, 111, 191, 114, 100, 90, 115, 97, 16, 195, 191, 232, 121, 54, 80, 87, 44, 164, 191, 229, 42, 146, 209, 229, 217, 165, 191, 181, 86, 162, 240, 62, 58, 198, 191, 134, 72, 120, 124, 99, 249, 122, 63, 157, 85, 159, 151, 233, 1, 201, 191, 149, 226, 128, 111, 238, 202, 117, 63, 75, 194, 7, 35, 158, 138, 135, 191, 215, 11, 23, 32, 141, 223, 148, 63, 132, 219, 103, 16, 241, 115, 170, 191, 158, 178, 31, 192, 227, 202, 194, 63, 212, 73, 145, 200, 92, 171, 145, 63, 10, 44, 93, 159, 3, 240, 195, 191, 114, 128, 138, 251, 73, 55, 188, 191, 48, 57, 197, 156, 87, 175, 143, 191, 15, 147, 155, 72, 118, 124, 180, 191, 196, 111, 25, 57, 248, 74, 180, 63, 158, 150, 171, 73, 5, 40, 193, 63, 219, 66, 9, 166, 171, 232, 208, 63, 46, 159, 78, 254, 190, 230, 197, 191, 93, 43, 118, 14, 33, 145, 194, 63, 94, 145, 91, 98, 46, 158, 184, 63},
	{120, 50, 169, 17, 232, 51, 177, 63, 190, 82, 250, 141, 154, 116, 76, 63, 235, 22, 11, 190, 234, 89, 190, 63, 110, 24, 158, 220, 165, 205, 80, 191, 170, 146, 4, 63, 242, 212, 97, 63, 58, 45, 155, 18, 35, 36, 122, 191, 92, 140, 2, 33, 230, 33, 195, 63, 20, 169, 162, 31, 246, 240, 101, 63, 64, 87, 92, 156, 1, 178, 68, 63, 2, 182, 126, 200, 255, 80, 117, 191, 0, 61, 249, 211, 95, 211, 28, 63, 128, 36, 184, 148, 12, 51, 254, 62, 121, 66, 247, 237, 204, 130, 198, 63, 36, 233, 84, 51, 232, 106, 131, 191, 152, 115, 186, 170, 13, 69, 74, 63, 118, 183, 131, 211, 57, 181, 109, 191, 104, 231, 119, 228, 79, 122, 114, 63, 110, 135, 54, 215, 158, 148, 127, 191, 240, 27, 196, 77, 48, 48, 141, 63, 40, 119, 133, 96, 83, 44, 116, 63, 44, 131, 237, 166, 67, 17, 202, 63, 67, 167, 184, 237, 149, 108, 129, 63, 55, 18, 67, 139, 153, 135, 146, 191, 21, 177, 115, 158, 233, 53, 120, 63, 198, 119, 206, 133, 189, 44, 138, 63, 114, 206, 139, 162, 241, 146, 115, 191, 116, 228, 131, 88, 241, 191, 115, 63, 230, 1, 235, 175, 93, 26, 120, 191, 244, 92, 245, 116, 218, 241, 158, 63, 104, 170, 213, 214, 158, 88, 157, 63, 75, 106, 2, 13, 146, 76, 203, 63, 142, 252, 51, 254, 179, 7, 162, 63, 22, 23, 12, 224, 69, 202, 120, 191, 134, 245, 102, 77, 242, 37, 108, 191, 182, 15, 165, 113, 94, 213, 128, 63, 92, 0, 178, 213, 167, 255, 101, 63, 5, 109, 90, 185, 139, 70, 200, 63, 125, 16, 166, 221, 191, 196, 188, 191, 87, 95, 192, 87, 65, 76, 172, 63, 99, 24, 151, 245, 154, 130, 180, 191, 218, 76, 91, 88, 171, 152, 133, 63, 10, 136, 84, 252, 199, 102, 183, 191, 98, 251, 246, 165, 69, 126, 212, 63, 35, 135, 102, 169, 163, 45, 169, 191, 182, 188, 1, 109, 141, 223, 178, 191, 166, 79, 193, 108, 194, 174, 186, 191, 65, 187, 37, 221, 222, 207, 202, 63, 128, 51, 189, 180, 234, 183, 50, 191, 160, 216, 150, 172, 138, 160, 141, 191, 174, 17, 104, 73, 232, 51, 177, 63, 120, 219, 4, 145, 157, 18, 85, 191, 242, 181, 191, 175, 98, 23, 180, 63, 190, 27, 3, 184, 231, 191, 182, 63, 74, 204, 100, 137, 52, 56, 100, 63, 94, 20, 164, 119, 156, 126, 115, 63, 118, 89, 17, 197, 244, 176, 147, 63, 124, 255, 127, 68, 109, 70, 192, 63, 107, 146, 168, 47, 187, 139, 179, 63, 40, 87, 84, 204, 252, 212, 125, 191, 148, 241, 203, 87, 41, 124, 114, 191, 48, 35, 37, 90, 249, 150, 112, 191, 114, 8, 191, 105, 77, 211, 168, 191, 108, 14, 10, 47, 127, 46, 183, 63, 19, 97, 146, 212, 84, 195, 192, 63, 131, 10, 77, 125, 74, 69, 173, 63, 114, 193, 118, 140, 122, 108, 113, 63, 164, 224, 22, 119, 248, 248, 77, 191, 140, 91, 112, 229, 222, 154, 130, 63, 97, 92, 129, 112, 80, 232, 139, 191, 240, 215, 65, 143, 124, 76, 179, 191, 3, 222, 215, 28, 104, 175, 148, 63, 238, 177, 14, 218, 109, 61, 192, 63, 198, 170, 77, 62, 196, 125, 192, 63, 129, 107, 185, 14, 234, 110, 173, 63, 236, 179, 216, 111, 167, 10, 105, 63, 164, 74, 59, 108, 29, 42, 100, 63, 183, 24, 159, 215, 29, 192, 149, 63, 204, 52, 129, 167, 202, 37, 145, 63, 176, 56, 25, 238, 248, 197, 123, 191, 54, 248, 246, 36, 15, 178, 177, 191, 196, 113, 58, 197, 236, 136, 168, 191, 77, 95, 243, 230, 232, 227, 182, 63, 53, 132, 21, 172, 66, 109, 194, 63, 6, 152, 107, 205, 100, 243, 186, 63, 182, 198, 207, 180, 117, 38, 160, 63, 111, 206, 22, 216, 3, 134, 202, 63, 135, 159, 43, 16, 241, 23, 192, 191, 128, 61, 244, 10, 169, 119, 61, 63, 31, 32, 84, 41, 198, 236, 154, 191, 158, 44, 225, 102, 157, 49, 173, 191, 234, 250, 58, 160, 50, 255, 192, 191, 146, 60, 91, 24, 191, 247, 183, 63, 164, 4, 61, 199, 188, 180, 180, 191, 197, 36, 96, 109, 19, 221, 173, 191, 38, 97, 213, 5, 148, 57, 174, 63, 232, 215, 159, 199, 123, 15, 214, 63, 221, 173, 63, 255, 216, 28, 186, 63, 206, 214, 11, 145, 241, 35, 136, 191, 193, 6, 160, 115, 15, 230, 178, 63, 146, 177, 27, 246, 8, 134, 137, 63, 199, 171, 138, 166, 143, 14, 164, 191, 157, 172, 139, 228, 248, 230, 190, 191, 208, 109, 67, 220, 126, 2, 155, 191, 212, 136, 13, 211, 120, 177, 100, 191, 149, 198, 42, 59, 126, 17, 175, 191, 108, 106, 152, 8, 200, 19, 181, 63, 24, 164, 190, 69, 205, 69, 193, 63, 213, 120, 187, 183, 81, 232, 168, 63, 88, 116, 252, 108, 205, 182, 146, 63, 87, 124, 195, 216, 89, 178, 134, 191, 74, 47, 232, 110, 29, 82, 178, 63, 0, 80, 0, 113, 143, 216, 174, 63, 8, 2, 250, 165, 64, 169, 186, 191, 58, 55, 150, 221, 6, 138, 192, 191, 136, 237, 202, 107, 34, 156, 176, 191, 210, 175, 153, 47, 96, 123, 161, 191, 213, 199, 34, 113, 49, 211, 135, 63, 87, 26, 92, 211, 148, 224, 134, 63, 186, 173, 117, 203, 233, 2, 150, 63, 20, 183, 215, 217, 216, 249, 190, 191, 245, 253, 28, 129, 218, 82, 163, 191, 44, 82, 111, 67, 152, 159, 191, 63, 208, 247, 53, 117, 98, 65, 192, 63, 174, 196, 68, 78, 3, 177, 176, 63, 196, 220, 138, 153, 178, 56, 164, 63, 95, 84, 49, 56, 148, 225, 137, 191, 237, 38, 89, 31, 125, 5, 157, 191, 86, 184, 219, 116, 182, 51, 142, 63, 232, 73, 69, 248, 66, 9, 184, 191, 38, 123, 184, 19, 117, 181, 148, 63, 212, 78, 106, 2, 238, 190, 188, 63, 79, 75, 111, 255, 238, 52, 138, 63, 91, 101, 27, 39, 139, 58, 192, 191, 21, 173, 8, 120, 64, 0, 192, 191, 122, 35, 161, 168, 193, 151, 197, 191, 183, 157, 125, 195, 125, 93, 185, 191, 98, 69, 8, 207, 146, 5, 151, 191, 83, 1, 151, 201, 38, 127, 190, 63, 171, 99, 18, 180, 203, 38, 164, 191, 115, 134, 177, 1, 47, 107, 177, 191, 175, 164, 226, 212, 81, 152, 170, 63, 76, 141, 146, 134, 70, 109, 186, 63, 223, 38, 92, 176, 126, 122, 186, 191, 151, 59, 192, 48, 206, 67, 168, 191, 62, 138, 238, 30, 108, 194, 168, 63, 41, 159, 57, 50, 221, 131, 175, 63, 126, 58, 45, 167, 174, 129, 160, 63, 194, 52, 132, 77, 148, 112, 178, 63, 186, 252, 174, 159, 20, 127, 187, 63, 67, 230, 146, 246, 126, 228, 129, 63, 28, 88, 225, 50, 109, 141, 174, 191, 33, 71, 109, 52, 73, 138, 190, 191, 187, 15, 160, 155, 136, 174, 152, 63, 142, 170, 41, 63, 200, 78, 181, 191, 53, 188, 54, 40, 9, 169, 139, 191, 23, 82, 198, 133, 135, 221, 177, 191, 172, 157, 60, 189, 175, 127, 119, 191, 172, 21, 78, 95, 95, 178, 151, 191, 47, 175, 0, 30, 255, 190, 186, 191, 3, 210, 57, 236, 134, 35, 148, 191, 199, 12, 68, 190, 36, 89, 175, 63, 24, 42, 145, 149, 164, 223, 136, 191, 130, 129, 134, 192, 45, 157, 195, 63, 39, 249, 163, 58, 70, 27, 195, 63, 44, 178, 209, 136, 45, 169, 118, 63, 196, 72, 42, 250, 108, 223, 187, 63, 92, 232, 255, 253, 93, 155, 157, 191, 172, 23, 216, 185, 204, 114, 183, 63, 153, 102, 62, 30, 138, 141, 147, 63, 211, 91, 26, 14, 68, 110, 177, 63, 51, 69, 79, 174, 179, 245, 161, 63, 215, 155, 174, 193, 52, 60, 179, 191, 187, 165, 139, 118, 179, 78, 195, 191, 129, 36, 81, 250, 95, 128, 149, 63, 223, 166, 142, 106, 109, 94, 139, 63, 116, 18, 239, 132, 249, 157, 164, 63, 246, 147, 65, 129, 18, 168, 189, 63, 86, 195, 204, 11, 37, 2, 161, 63, 25, 82, 17, 146, 162, 216, 165, 191, 42, 51, 15, 133, 45, 144, 123, 63, 108, 98, 171, 215, 14, 231, 193, 191, 158, 137, 16, 203, 26, 52, 158, 191, 235, 219, 251, 241, 216, 88, 187, 191, 87, 64, 191, 225, 168, 72, 164, 191, 94, 68, 228, 228, 228, 21, 163, 191, 160, 158, 6, 229, 117, 21, 192, 191, 107, 12, 222, 120, 220, 2, 162, 63, 167, 109, 6, 223, 40, 207, 186, 191, 41, 14, 119, 38, 44, 219, 163, 63, 88, 248, 105, 75, 219, 156, 176, 191, 143, 108, 210, 211, 22, 147, 147, 63, 217, 135, 11, 192, 74, 29, 192, 191, 114, 234, 108, 251, 209, 211, 118, 63, 205, 180, 49, 131, 146, 206, 178, 63, 189, 139, 139, 72, 235, 158, 147, 63, 239, 73, 137, 103, 110, 152, 181, 63, 130, 37, 228, 42, 247, 30, 178, 63, 11, 234, 31, 121, 58, 59, 182, 191, 251, 115, 88, 230, 111, 81, 173, 191, 31, 100, 218, 97, 200, 5, 176, 191, 224, 99, 247, 5, 132, 27, 187, 63, 58, 123, 68, 243, 89, 140, 183, 63, 115, 164, 62, 128, 131, 81, 155, 191, 10, 109, 30, 168, 255, 5, 174, 63, 12, 253, 105, 86, 60, 28, 153, 191, 94, 75, 137, 126, 116, 144, 163, 191, 179, 60, 82, 27, 21, 51, 190, 191, 12, 25, 185, 155, 165, 93, 130, 191, 6, 205, 100, 238, 187, 32, 179, 63, 130, 177, 211, 230, 221, 64, 128, 63, 38, 241, 86, 182, 13, 103, 166, 63, 70, 177, 133, 104, 135, 208, 184, 63, 160, 252, 253, 160, 137, 148, 172, 191, 132, 252, 9, 10, 54, 53, 170, 63, 104, 37, 63, 126, 191, 138, 162, 63, 143, 201, 106, 82, 143, 150, 178, 191, 224, 103, 101, 65, 154, 42, 166, 191, 220, 66, 216, 87, 195, 220, 171, 191, 148, 188, 230, 36, 237, 157, 136, 191, 99, 20, 15, 128, 73, 129, 192, 191, 230, 52, 209, 246, 125, 28, 181, 191, 79, 187, 44, 244, 107, 212, 179, 63, 111, 254, 217, 93, 222, 79, 177, 63, 62, 90, 81, 87, 247, 27, 150, 191, 131, 149, 19, 189, 12, 221, 176, 63, 253, 236, 212, 25, 146, 52, 183, 63, 163, 133, 169, 155, 169, 5, 165, 191, 139, 39, 64, 86, 28, 208, 170, 63, 139, 72, 129, 162, 31, 45, 137, 191, 100, 103, 212, 227, 255, 6, 181, 63, 237, 150, 181, 159, 218, 218, 192, 63, 135, 33, 238, 159, 226, 141, 113, 63, 104, 200, 156, 249, 232, 77, 205, 191, 252, 153, 133, 234, 172, 94, 199, 191, 234, 208, 201, 18, 117, 10, 180, 191, 74, 169, 231, 21, 66, 172, 178, 63, 229, 64, 240, 91, 181, 54, 192, 191, 208, 228, 154, 142, 236, 110, 177, 191, 93, 122, 78, 79, 97, 54, 166, 63, 198, 124, 141, 242, 67, 39, 156, 63, 234, 78, 128, 29, 201, 220, 172, 63, 206, 5, 154, 43, 102, 52, 182, 63, 28, 127, 45, 224, 81, 76, 185, 191, 15, 21, 18, 230, 157, 95, 167, 191, 210, 163, 190, 108, 14, 112, 98, 63, 79, 148, 51, 204, 62, 32, 178, 63, 229, 92, 247, 228, 175, 1, 188, 191, 24, 90, 185, 82, 6, 58, 94, 191, 220, 30, 104, 76, 246, 194, 173, 191, 37, 33, 9, 86, 187, 16, 188, 63, 188, 8, 170, 157, 243, 140, 69, 191, 180, 202, 101, 35, 176, 189, 180, 191, 54, 134, 134, 249, 207, 17, 128, 63, 149, 162, 163, 243, 51, 51, 180, 191, 107, 226, 106, 90, 15, 200, 142, 63, 91, 167, 23, 111, 237, 104, 132, 191, 191, 18, 248, 105, 242, 20, 186, 63, 129, 44, 41, 46, 22, 135, 135, 63, 158, 90, 83, 201, 191, 205, 167, 63, 220, 103, 238, 88, 166, 147, 76, 191, 116, 71, 42, 133, 120, 149, 193, 63, 238, 60, 237, 81, 212, 45, 193, 191, 148, 111, 250, 18, 246, 114, 80, 63, 228, 20, 22, 89, 136, 183, 182, 191, 202, 93, 210, 205, 83, 36, 142, 191, 242, 216, 21, 55, 131, 108, 180, 63, 166, 244, 20, 220, 190, 231, 129, 191, 243, 124, 205, 62, 189, 135, 174, 63, 42, 40, 86, 231, 73, 93, 137, 191, 154, 173, 236, 70, 144, 110, 172, 191, 226, 168, 30, 59, 173, 149, 192, 63, 244, 116, 136, 178, 86, 245, 152, 63, 242, 46, 104, 225, 132, 3, 153, 191, 72, 115, 237, 19, 91, 139, 153, 63, 238, 254, 103, 66, 143, 242, 189, 191, 174, 138, 88, 234, 211, 155, 130, 191, 240, 90, 46, 244, 193, 94, 172, 191, 103, 74, 191, 117, 53, 79, 146, 191, 190, 136, 199, 128, 178, 35, 192, 191, 220, 138, 124, 38, 45, 90, 128, 63, 108, 137, 222, 122, 157, 229, 187, 191, 154, 185, 253, 6, 6, 119, 204, 63, 128, 58, 177, 19, 53, 62, 73, 191, 233, 84, 115, 215, 75, 254, 195, 63, 10, 34, 52, 133, 122, 194, 181, 191, 231, 223, 77, 238, 167, 63, 192, 63, 204, 235, 14, 27, 123, 120, 158, 63, 155, 84, 70, 183, 27, 230, 161, 191, 96, 64, 117, 54, 9, 105, 151, 191, 50, 185, 91, 164, 192, 198, 165, 191, 28, 59, 11, 80, 170, 254, 176, 191, 62, 198, 202, 234, 213, 164, 188, 63, 131, 2, 52, 198, 123, 28, 145, 191, 178, 107, 125, 228, 174, 6, 191, 63, 225, 116, 173, 25, 112, 228, 178, 63, 76, 245, 91, 1, 69, 49, 189, 63, 88, 249, 245, 63, 152, 157, 170, 63, 1, 30, 113, 129, 104, 50, 140, 191, 71, 128, 93, 166, 214, 169, 146, 191, 44, 99, 205, 147, 127, 23, 186, 63, 6, 100, 87, 165, 121, 31, 165, 191, 71, 70, 168, 222, 105, 177, 113, 191, 197, 124, 23, 169, 119, 187, 189, 191, 68, 130, 246, 112, 167, 89, 188, 191, 25, 206, 237, 93, 42, 21, 150, 191, 158, 127, 119, 254, 157, 239, 142, 191, 84, 45, 167, 49, 15, 139, 181, 191, 85, 30, 164, 8, 42, 119, 113, 63, 53, 224, 224, 149, 7, 198, 192, 191, 245, 183, 199, 154, 229, 37, 163, 63, 53, 242, 131, 107, 9, 249, 161, 63, 75, 161, 142, 50, 217, 8, 195, 191, 37, 16, 171, 187, 229, 224, 143, 191, 183, 155, 124, 225, 3, 114, 190, 191, 161, 39, 36, 118, 206, 38, 160, 191, 218, 76, 254, 142, 150, 81, 120, 63, 186, 213, 186, 227, 94, 99, 152, 191, 189, 51, 101, 152, 158, 211, 159, 63, 16, 190, 157, 113, 119, 139, 185, 63, 8, 131, 174, 129, 183, 72, 182, 63, 72, 148, 159, 168, 55, 211, 173, 63, 81, 91, 251, 105, 52, 167, 177, 191, 0, 124, 169, 126, 100, 206, 54, 63, 119, 237, 40, 65, 1, 46, 184, 191, 237, 86, 105, 143, 161, 51, 176, 63, 82, 212, 159, 170, 13, 18, 112, 191, 255, 193, 151, 198, 197, 59, 187, 63, 21, 111, 246, 11, 115, 134, 163, 63, 207, 237, 44, 129, 109, 50, 195, 63, 248, 212, 204, 130, 99, 185, 165, 191, 157, 133, 136, 219, 212, 226, 204, 191, 102, 232, 217, 219, 62, 193, 194, 63, 36, 34, 31, 197, 193, 189, 173, 63, 0, 92, 98, 48, 37, 159, 11, 63, 75, 91, 206, 154, 139, 144, 181, 63, 15, 122, 23, 26, 26, 179, 180, 63, 128, 109, 108, 205, 138, 85, 132, 63, 236, 253, 214, 138, 132, 114, 119, 63, 194, 243, 6, 29, 86, 127, 192, 63, 116, 10, 247, 134, 183, 255, 142, 63, 120, 232, 162, 94, 151, 148, 161, 191, 35, 17, 28, 183, 166, 51, 185, 191, 5, 45, 97, 255, 170, 179, 157, 191, 33, 242, 124, 144, 208, 166, 177, 63, 161, 92, 223, 166, 217, 33, 184, 63, 215, 106, 134, 40, 181, 10, 160, 191, 109, 36, 180, 104, 45, 67, 176, 63, 159, 39, 99, 12, 145, 198, 189, 63, 42, 73, 14, 182, 93, 20, 176, 191, 249, 82, 192, 247, 172, 100, 174, 191, 220, 54, 16, 131, 144, 240, 157, 191, 84, 96, 172, 215, 122, 57, 166, 191, 193, 140, 100, 190, 9, 188, 161, 63, 172, 140, 48, 134, 209, 208, 177, 191, 227, 40, 130, 175, 121, 65, 174, 191, 130, 168, 192, 102, 138, 31, 175, 63, 50, 111, 70, 123, 98, 254, 166, 191, 228, 225, 15, 187, 5, 44, 161, 63, 88, 122, 7, 250, 187, 186, 190, 191, 21, 218, 187, 94, 64, 207, 181, 191, 245, 246, 63, 217, 24, 136, 146, 191, 128, 23, 31, 201, 154, 162, 170, 191, 28, 152, 161, 169, 23, 170, 180, 63, 87, 172, 18, 246, 139, 45, 155, 63, 129, 151, 137, 181, 218, 166, 168, 63, 44, 35, 123, 3, 31, 155, 112, 63, 134, 9, 252, 166, 235, 233, 181, 63, 131, 81, 8, 219, 14, 2, 185, 191, 195, 3, 0, 32, 29, 132, 193, 191, 63, 46, 2, 106, 14, 86, 183, 63, 92, 101, 171, 37, 234, 181, 151, 191, 128, 72, 136, 10, 154, 71, 189, 63, 27, 184, 117, 81, 210, 201, 149, 63, 54, 137, 44, 155, 163, 77, 183, 191, 150, 67, 191, 62, 102, 49, 105, 63, 131, 186, 172, 1, 6, 232, 166, 191, 124, 58, 55, 115, 202, 166, 168, 63, 6, 236, 53, 99, 55, 196, 172, 63, 75, 20, 226, 16, 63, 131, 117, 63, 12, 233, 32, 157, 171, 62, 195, 191, 134, 12, 193, 4, 121, 178, 192, 63, 147, 127, 59, 221, 9, 72, 182, 63, 233, 239, 54, 110, 40, 50, 184, 191, 6, 162, 192, 218, 131, 211, 168, 63, 50, 250, 236, 231, 254, 27, 195, 191, 35, 71, 222, 143, 171, 125, 169, 63, 196, 83, 90, 166, 44, 186, 188, 191, 1, 47, 41, 110, 87, 122, 164, 63, 195, 33, 80, 173, 169, 240, 194, 191, 80, 84, 180, 165, 78, 186, 120, 191, 13, 135, 210, 33, 179, 107, 181, 191, 193, 21, 75, 61, 150, 11, 187, 63, 244, 52, 191, 251, 255, 103, 178, 63, 16, 22, 5, 188, 155, 181, 133, 191, 90, 46, 92, 221, 187, 224, 150, 63, 209, 20, 212, 18, 196, 35, 191, 191, 97, 244, 170, 241, 63, 205, 147, 63, 253, 134, 86, 226, 237, 177, 132, 191, 11, 249, 42, 243, 58, 144, 177, 191, 250, 54, 209, 170, 98, 251, 171, 191, 39, 164, 195, 232, 189, 210, 192, 63, 203, 187, 58, 1, 193, 87, 165, 191, 91, 252, 89, 214, 72, 141, 152, 63, 53, 91, 15, 29, 172, 236, 118, 63, 192, 200, 225, 0, 141, 79, 171, 191, 214, 64, 206, 165, 147, 124, 184, 63, 68, 115, 217, 211, 157, 201, 177, 63, 49, 63, 1, 164, 67, 114, 194, 191, 123, 172, 114, 107, 49, 68, 175, 63, 57, 154, 192, 125, 212, 121, 156, 191, 66, 92, 221, 118, 116, 240, 130, 191, 124, 56, 46, 11, 8, 115, 138, 63, 126, 134, 135, 138, 39, 161, 164, 63, 187, 131, 171, 112, 190, 110, 183, 63, 1, 254, 44, 219, 10, 39, 181, 191, 159, 96, 102, 95, 101, 92, 181, 191, 116, 42, 64, 195, 220, 218, 193, 63, 95, 83, 161, 195, 19, 55, 175, 191, 223, 49, 34, 233, 108, 207, 170, 63, 205, 240, 219, 13, 21, 214, 147, 63, 146, 181, 233, 21, 115, 20, 150, 191, 3, 55, 213, 144, 246, 213, 145, 191, 178, 140, 127, 121, 95, 146, 177, 63, 25, 156, 159, 19, 132, 243, 177, 191, 108, 207, 202, 252, 121, 68, 183, 191, 252, 220, 19, 124, 214, 97, 180, 63, 237, 198, 41, 161, 222, 19, 184, 63, 251, 178, 194, 78, 165, 11, 193, 191, 251, 60, 201, 208, 247, 30, 200, 63, 17, 160, 200, 196, 109, 58, 167, 191, 149, 74, 132, 58, 77, 182, 151, 63, 219, 190, 149, 213, 54, 73, 160, 63, 106, 55, 9, 254, 233, 47, 128, 191, 141, 86, 194, 24, 22, 190, 151, 191, 29, 50, 158, 233, 49, 95, 167, 191, 4, 9, 123, 230, 131, 16, 186, 191, 202, 223, 214, 214, 140, 6, 190, 63, 124, 8, 152, 181, 21, 215, 166, 63, 140, 187, 201, 134, 95, 14, 188, 191, 240, 158, 28, 109, 230, 252, 167, 191, 124, 27, 113, 29, 236, 113, 183, 63, 206, 0, 123, 176, 75, 128, 178, 63, 39, 228, 84, 46, 165, 75, 170, 191, 248, 1, 17, 155, 238, 61, 159, 191, 178, 228, 74, 157, 28, 123, 188, 191, 167, 211, 30, 246, 170, 96, 186, 63, 219, 49, 245, 50, 198, 217, 150, 63, 125, 38, 5, 208, 92, 119, 177, 191, 64, 211, 241, 6, 161, 65, 177, 63, 46, 201, 152, 190, 48, 224, 178, 63, 69, 74, 242, 100, 228, 21, 193, 191, 131, 5, 12, 197, 2, 0, 178, 191, 23, 175, 99, 152, 187, 204, 165, 63, 213, 113, 4, 122, 173, 167, 178, 63, 243, 112, 103, 247, 235, 172, 176, 63, 198, 22, 173, 107, 241, 9, 173, 191, 251, 97, 39, 218, 92, 251, 151, 191, 187, 214, 44, 239, 2, 54, 193, 63, 67, 166, 166, 10, 147, 100, 183, 63, 135, 238, 177, 3, 106, 231, 171, 191, 220, 121, 53, 82, 162, 176, 167, 191, 45, 137, 115, 58, 66, 142, 164, 63, 117, 201, 172, 223, 95, 214, 184, 191, 109, 172, 236, 83, 54, 99, 165, 191, 120, 229, 249, 187, 61, 114, 157, 63, 159, 1, 30, 174, 78, 219, 162, 191, 199, 197, 248, 206, 61, 169, 185, 191, 170, 9, 151, 113, 139, 196, 184, 191, 164, 61, 183, 19, 106, 135, 170, 63, 201, 93, 153, 175, 37, 1, 183, 63, 97, 85, 74, 1, 31, 143, 136, 191, 243, 126, 165, 134, 111, 251, 175, 191, 19, 131, 25, 83, 215, 186, 132, 191, 178, 113, 236, 10, 215, 9, 179, 63, 127, 163, 62, 90, 40, 51, 101, 63, 42, 230, 35, 166, 14, 90, 140, 63, 33, 207, 80, 197, 164, 252, 184, 63, 30, 26, 185, 106, 19, 173, 193, 63, 0, 170, 210, 246, 43, 100, 191, 63, 188, 206, 124, 193, 147, 100, 131, 191, 208, 188, 40, 244, 35, 122, 206, 191, 150, 27, 6, 195, 219, 26, 179, 63, 240, 39, 180, 22, 89, 35, 183, 63, 94, 33, 125, 72, 179, 191, 126, 63, 90, 192, 174, 22, 164, 32, 174, 63, 224, 79, 110, 220, 198, 58, 146, 63, 190, 75, 201, 250, 104, 62, 170, 191, 144, 221, 129, 140, 53, 56, 179, 63, 185, 87, 246, 104, 147, 70, 161, 191, 3, 130, 126, 184, 46, 34, 168, 191, 16, 33, 54, 247, 255, 251, 178, 63, 136, 75, 171, 220, 242, 226, 160, 63, 72, 48, 246, 58, 123, 98, 188, 63, 72, 103, 47, 126, 19, 183, 169, 63, 59, 112, 185, 48, 143, 225, 158, 63, 150, 48, 132, 17, 29, 11, 177, 63, 97, 35, 78, 136, 22, 57, 188, 63, 56, 150, 101, 66, 61, 244, 185, 63, 95, 100, 5, 223, 90, 191, 138, 63, 129, 51, 91, 169, 45, 180, 150, 63, 177, 210, 51, 250, 244, 245, 177, 63, 179, 154, 182, 207, 99, 95, 183, 63, 87, 176, 128, 218, 28, 107, 179, 63, 101, 223, 0, 251, 247, 41, 194, 63, 222, 5, 208, 136, 73, 1, 155, 63, 214, 229, 207, 167, 161, 227, 97, 63, 0, 112, 204, 232, 19, 221, 65, 191, 90, 22, 50, 73, 143, 173, 165, 63, 231, 202, 24, 255, 0, 24, 183, 63, 56, 215, 15, 235, 242, 141, 185, 63, 142, 217, 54, 119, 241, 62, 144, 63, 228, 229, 178, 165, 92, 207, 192, 63, 37, 199, 204, 123, 151, 103, 173, 63, 222, 190, 63, 0, 82, 93, 148, 191, 146, 158, 249, 221, 91, 250, 149, 191, 170, 212, 52, 29, 156, 151, 116, 191, 176, 46, 196, 62, 97, 51, 101, 63, 160, 181, 128, 235, 97, 91, 171, 63, 200, 29, 21, 65, 13, 163, 185, 63, 169, 75, 142, 226, 206, 17, 176, 63, 198, 253, 30, 171, 250, 209, 152, 191, 184, 222, 226, 63, 174, 25, 180, 63, 126, 57, 15, 92, 94, 255, 170, 63, 10, 147, 100, 90, 32, 130, 133, 191, 200, 20, 120, 245, 62, 144, 144, 191, 60, 168, 56, 154, 229, 20, 98, 191, 58, 33, 112, 98, 168, 144, 203, 191, 160, 90, 134, 146, 198, 183, 180, 63, 224, 95, 28, 208, 111, 23, 112, 191, 3, 30, 232, 109, 32, 155, 191, 63, 29, 11, 168, 233, 94, 1, 194, 63, 234, 30, 72, 56, 220, 141, 200, 63, 114, 99, 209, 136, 146, 41, 200, 191, 194, 5, 180, 88, 122, 22, 182, 63, 250, 155, 46, 243, 148, 141, 186, 63, 174, 225, 139, 209, 80, 205, 173, 63, 182, 18, 0, 247, 75, 240, 205, 191, 249, 99, 12, 107, 245, 103, 164, 191, 226, 162, 107, 207, 196, 129, 115, 63, 115, 63, 123, 179, 195, 168, 178, 63, 30, 145, 172, 230, 105, 95, 157, 191, 146, 104, 160, 166, 38, 23, 183, 191, 4, 127, 198, 53, 140, 138, 181, 191, 61, 190, 237, 179, 114, 222, 162, 63, 146, 84, 192, 214, 95, 174, 169, 63, 134, 151, 21, 107, 192, 199, 166, 63, 56, 52, 77, 243, 45, 226, 192, 63, 183, 215, 165, 223, 182, 219, 174, 63, 57, 179, 131, 30, 60, 181, 166, 191, 134, 91, 93, 174, 197, 229, 179, 191, 84, 140, 86, 65, 82, 104, 168, 191, 133, 32, 228, 153, 81, 107, 156, 63, 75, 200, 36, 222, 199, 149, 190, 191, 216, 193, 60, 67, 202, 215, 188, 191, 204, 153, 22, 226, 63, 142, 164, 191, 112, 242, 201, 79, 224, 3, 167, 63, 112, 64, 180, 235, 31, 140, 185, 63, 204, 21, 46, 157, 13, 158, 185, 63, 134, 149, 70, 50, 90, 169, 142, 63, 200, 11, 212, 223, 161, 140, 185, 191, 203, 17, 73, 90, 228, 183, 163, 63, 226, 134, 78, 200, 22, 2, 192, 63, 91, 110, 19, 121, 220, 115, 176, 63, 93, 116, 113, 250, 190, 253, 149, 63, 9, 99, 231, 163, 109, 113, 153, 191, 240, 115, 230, 112, 98, 94, 184, 191, 184, 240, 66, 31, 175, 56, 193, 191, 216, 196, 76, 177, 225, 202, 177, 191, 93, 182, 60, 162, 73, 231, 114, 63, 60, 197, 181, 71, 201, 119, 179, 63, 134, 151, 98, 34, 252, 248, 172, 63, 3, 162, 164, 8, 179, 101, 180, 191, 107, 223, 221, 222, 11, 64, 182, 191, 96, 27, 118, 212, 230, 231, 156, 191, 84, 242, 191, 87, 225, 21, 113, 191, 107, 11, 56, 132, 225, 36, 189, 63, 62, 219, 146, 148, 30, 223, 178, 63, 40, 212, 7, 62, 212, 165, 190, 63, 6, 217, 118, 91, 31, 140, 201, 63, 238, 242, 28, 96, 137, 173, 165, 191, 72, 144, 131, 48, 77, 186, 163, 191, 112, 226, 85, 7, 252, 19, 136, 191, 114, 94, 123, 121, 176, 35, 185, 191, 236, 122, 241, 13, 95, 91, 168, 191, 82, 207, 249, 114, 114, 96, 153, 63, 83, 235, 219, 183, 235, 208, 162, 191, 251, 182, 101, 55, 200, 250, 155, 63, 102, 60, 153, 234, 163, 26, 100, 63, 162, 130, 44, 151, 131, 85, 179, 63, 135, 201, 45, 122, 240, 203, 175, 63, 131, 98, 179, 44, 46, 162, 173, 63, 28, 170, 77, 193, 189, 78, 185, 63, 182, 232, 22, 51, 203, 106, 187, 63, 249, 117, 149, 8, 36, 150, 171, 63, 114, 59, 49, 220, 141, 9, 162, 191, 87, 218, 207, 10, 225, 37, 186, 63, 240, 80, 16, 82, 163, 38, 171, 63, 45, 202, 81, 55, 71, 10, 190, 63, 1, 24, 121, 206, 26, 52, 192, 63, 134, 119, 130, 124, 123, 27, 112, 63, 235, 228, 200, 180, 254, 145, 182, 191, 84, 83, 27, 30, 239, 165, 78, 191, 99, 125, 99, 61, 185, 23, 176, 63, 45, 218, 152, 137, 115, 88, 133, 191, 30, 250, 11, 244, 141, 163, 181, 63, 54, 218, 14, 150, 101, 63, 195, 63, 94, 73, 221, 106, 24, 63, 165, 63, 240, 138, 192, 16, 76, 238, 170, 191, 188, 48, 194, 67, 74, 171, 168, 191, 186, 230, 128, 149, 128, 40, 185, 191, 78, 36, 78, 225, 10, 75, 130, 63, 172, 226, 232, 147, 209, 46, 150, 191, 0, 2, 255, 22, 98, 145, 176, 191, 80, 242, 243, 137, 232, 255, 159, 63, 237, 221, 127, 58, 60, 26, 193, 63, 57, 204, 201, 193, 216, 152, 177, 63, 198, 87, 82, 165, 148, 92, 178, 191, 84, 229, 54, 117, 20, 87, 168, 191, 57, 145, 53, 90, 155, 105, 155, 63, 91, 131, 104, 73, 75, 170, 182, 191, 92, 51, 25, 95, 24, 235, 169, 191, 116, 88, 63, 84, 173, 162, 141, 191, 223, 238, 142, 221, 218, 110, 185, 191, 112, 224, 147, 183, 238, 174, 182, 191, 234, 132, 82, 191, 113, 75, 193, 191, 62, 121, 16, 54, 9, 77, 185, 63, 181, 104, 68, 213, 226, 166, 183, 63, 46, 164, 77, 187, 204, 212, 169, 191, 143, 71, 59, 186, 44, 0, 164, 191, 0, 253, 71, 145, 19, 142, 138, 63, 76, 251, 14, 137, 177, 68, 171, 63, 102, 180, 233, 76, 238, 162, 148, 191, 8, 76, 75, 210, 165, 25, 168, 191, 162, 205, 93, 200, 184, 250, 162, 191, 199, 247, 95, 95, 212, 223, 191, 191, 194, 163, 53, 231, 40, 21, 196, 191, 242, 236, 113, 229, 247, 244, 154, 191, 83, 242, 123, 167, 148, 112, 178, 63, 18, 243, 213, 148, 2, 242, 184, 191, 172, 178, 186, 58, 212, 193, 175, 63, 211, 10, 169, 154, 25, 233, 165, 191, 164, 150, 137, 61, 229, 36, 178, 63, 246, 21, 41, 15, 231, 53, 189, 191, 240, 94, 63, 253, 227, 239, 145, 191, 227, 154, 75, 167, 99, 130, 169, 191, 240, 121, 71, 81, 233, 195, 179, 191, 246, 188, 229, 160, 215, 44, 162, 63, 31, 115, 232, 68, 234, 171, 187, 63, 54, 34, 200, 143, 146, 121, 150, 191, 148, 137, 144, 152, 233, 88, 182, 191, 242, 204, 214, 31, 158, 149, 133, 191, 156, 85, 124, 19, 129, 152, 184, 191, 201, 253, 142, 107, 164, 24, 184, 63, 249, 166, 0, 82, 99, 255, 183, 191, 184, 219, 134, 16, 191, 122, 168, 63, 190, 117, 199, 86, 10, 116, 172, 63, 223, 232, 22, 23, 192, 169, 184, 63, 33, 65, 143, 184, 48, 166, 178, 191, 136, 108, 99, 32, 207, 94, 166, 63, 58, 49, 206, 69, 164, 38, 166, 191, 83, 24, 199, 50, 2, 76, 195, 63, 158, 75, 95, 142, 171, 167, 106, 191, 236, 146, 85, 122, 245, 186, 169, 63, 159, 167, 168, 99, 159, 27, 195, 191, 161, 126, 199, 69, 70, 82, 163, 63, 73, 39, 128, 50, 149, 171, 171, 191, 100, 139, 77, 226, 35, 195, 192, 63, 227, 132, 39, 18, 173, 227, 158, 63, 86, 210, 169, 91, 138, 31, 177, 63, 134, 141, 229, 120, 205, 31, 175, 63, 66, 151, 145, 197, 222, 182, 188, 63, 163, 233, 16, 115, 189, 147, 148, 191, 135, 243, 79, 27, 219, 215, 177, 191, 134, 247, 144, 206, 4, 122, 183, 63, 156, 241, 8, 118, 192, 217, 187, 63, 112, 94, 203, 248, 158, 213, 183, 191, 62, 28, 145, 202, 250, 84, 169, 191, 222, 164, 32, 234, 242, 106, 186, 191, 120, 29, 193, 91, 246, 15, 63, 63, 111, 91, 74, 87, 171, 179, 173, 63, 54, 79, 195, 39, 77, 135, 102, 63, 120, 153, 125, 250, 123, 11, 187, 63, 75, 105, 78, 185, 131, 203, 107, 191, 83, 114, 253, 101, 182, 177, 177, 191, 220, 38, 137, 44, 198, 187, 160, 191, 16, 168, 26, 108, 123, 210, 173, 63, 231, 113, 77, 129, 170, 23, 179, 63, 233, 236, 153, 226, 204, 199, 176, 191, 136, 73, 97, 62, 78, 20, 54, 63, 8, 194, 240, 169, 216, 103, 189, 63, 199, 206, 21, 50, 10, 166, 190, 191, 103, 25, 126, 187, 231, 119, 119, 63, 150, 244, 33, 227, 118, 15, 183, 191, 218, 249, 101, 192, 118, 220, 112, 191, 179, 243, 93, 12, 28, 214, 179, 63, 128, 160, 20, 245, 168, 46, 196, 191, 96, 195, 254, 169, 20, 236, 34, 63, 111, 229, 176, 42, 233, 28, 174, 63, 225, 154, 211, 126, 158, 21, 100, 63, 149, 251, 197, 178, 39, 159, 187, 191, 222, 53, 185, 254, 89, 216, 120, 63, 64, 15, 39, 161, 100, 241, 19, 191, 24, 130, 185, 22, 0, 100, 194, 191, 113, 72, 176, 96, 247, 33, 120, 63, 192, 183, 198, 141, 52, 40, 189, 63, 67, 247, 208, 132, 68, 104, 134, 191, 0, 106, 100, 22, 97, 221, 182, 63, 101, 221, 59, 204, 123, 212, 142, 63, 82, 154, 37, 178, 178, 68, 176, 191, 144, 135, 14, 183, 127, 202, 133, 63, 57, 217, 178, 98, 110, 151, 178, 191, 88, 54, 57, 85, 12, 87, 185, 191, 116, 30, 163, 43, 187, 67, 113, 63, 29, 48, 234, 227, 93, 46, 194, 63, 28, 15, 18, 144, 232, 71, 110, 191, 200, 255, 77, 70, 242, 140, 177, 191, 21, 108, 230, 23, 224, 186, 139, 191, 70, 199, 209, 135, 33, 234, 189, 63, 220, 101, 61, 91, 114, 82, 118, 63, 70, 190, 21, 121, 119, 104, 146, 63, 142, 16, 180, 188, 5, 236, 142, 63, 41, 118, 141, 107, 5, 148, 194, 191, 56, 113, 207, 154, 219, 150, 167, 63, 90, 186, 110, 11, 109, 154, 194, 191, 113, 2, 167, 120, 162, 176, 180, 63, 48, 84, 72, 209, 57, 168, 139, 63, 242, 2, 243, 167, 246, 17, 185, 191, 236, 157, 239, 98, 60, 124, 188, 191, 0, 44, 116, 77, 241, 83, 157, 191, 130, 217, 145, 98, 47, 246, 150, 63, 246, 234, 85, 55, 191, 208, 157, 63, 32, 10, 110, 224, 20, 96, 98, 191, 193, 2, 212, 144, 241, 56, 204, 63, 161, 194, 58, 236, 30, 127, 166, 191, 234, 235, 187, 15, 53, 10, 192, 191, 137, 82, 143, 106, 75, 128, 178, 63, 195, 105, 107, 120, 8, 233, 180, 191, 34, 167, 75, 12, 128, 186, 182, 191, 151, 157, 134, 213, 147, 25, 163, 63, 146, 158, 180, 131, 40, 145, 165, 191, 18, 38, 22, 18, 25, 110, 192, 63, 26, 231, 95, 173, 125, 165, 165, 63, 205, 136, 34, 227, 250, 142, 176, 191, 50, 53, 217, 118, 17, 4, 164, 191, 254, 235, 217, 209, 38, 93, 132, 63, 148, 28, 23, 18, 61, 234, 183, 63, 165, 186, 225, 97, 26, 56, 191, 191, 6, 37, 243, 243, 217, 134, 157, 63, 14, 199, 46, 176, 45, 188, 176, 63, 125, 120, 111, 209, 248, 123, 181, 63, 100, 42, 40, 83, 212, 41, 167, 191, 88, 211, 144, 128, 55, 86, 159, 63, 7, 19, 2, 65, 40, 41, 152, 191, 130, 25, 95, 195, 74, 235, 190, 191, 169, 156, 132, 89, 43, 254, 162, 63, 209, 249, 67, 31, 204, 69, 183, 191, 202, 224, 95, 195, 220, 208, 150, 191, 241, 49, 156, 74, 22, 252, 183, 191, 2, 225, 26, 89, 209, 112, 187, 63, 232, 214, 50, 235, 108, 138, 104, 191, 149, 203, 146, 121, 113, 29, 131, 63, 47, 5, 2, 83, 184, 176, 177, 191, 38, 159, 189, 39, 218, 72, 164, 63, 72, 252, 112, 51, 228, 176, 183, 63, 86, 43, 74, 150, 220, 149, 172, 63, 5, 64, 57, 126, 182, 39, 181, 63, 38, 99, 30, 186, 27, 148, 154, 191, 30, 194, 138, 1, 215, 255, 178, 63, 80, 40, 18, 213, 115, 241, 192, 191, 228, 34, 128, 193, 28, 11, 157, 63, 227, 36, 220, 203, 209, 163, 134, 63, 28, 160, 29, 61, 236, 61, 178, 191, 153, 161, 31, 107, 150, 61, 191, 191, 102, 130, 12, 129, 167, 77, 185, 63, 172, 216, 231, 32, 126, 4, 145, 191, 2, 221, 18, 60, 228, 164, 162, 191, 17, 119, 23, 61, 185, 84, 204, 191, 224, 79, 100, 178, 53, 192, 153, 191, 189, 3, 166, 70, 30, 237, 181, 63, 137, 231, 192, 30, 110, 3, 170, 63, 55, 85, 237, 107, 39, 224, 187, 63, 5, 4, 19, 14, 4, 105, 180, 63, 122, 20, 252, 66, 28, 206, 186, 191, 90, 27, 78, 21, 164, 84, 118, 63, 216, 34, 213, 70, 85, 120, 178, 63, 21, 64, 190, 148, 225, 100, 179, 191, 78, 147, 11, 164, 232, 137, 155, 63, 138, 104, 200, 176, 73, 24, 184, 191, 149, 231, 90, 85, 187, 220, 192, 63, 55, 111, 123, 171, 33, 196, 153, 191, 203, 120, 15, 4, 116, 84, 177, 191, 242, 35, 7, 156, 174, 207, 169, 191, 170, 162, 202, 183, 168, 37, 163, 63, 147, 171, 145, 68, 47, 187, 191, 191, 11, 115, 8, 199, 64, 192, 177, 63, 62, 45, 67, 58, 133, 223, 168, 63, 197, 84, 59, 247, 105, 49, 175, 191, 174, 102, 164, 212, 227, 239, 177, 63, 108, 93, 198, 49, 167, 246, 149, 63, 129, 110, 227, 128, 91, 122, 174, 63, 54, 148, 102, 241, 45, 50, 176, 63, 184, 204, 96, 136, 80, 105, 179, 191, 155, 156, 113, 221, 127, 248, 179, 191, 143, 233, 141, 46, 6, 120, 170, 63, 43, 235, 107, 249, 160, 192, 165, 63, 136, 145, 137, 135, 126, 176, 177, 63, 58, 160, 161, 120, 222, 188, 136, 191, 115, 254, 145, 8, 55, 152, 155, 63, 26, 67, 29, 158, 62, 176, 191, 191, 94, 238, 93, 88, 100, 75, 108, 63, 59, 104, 57, 211, 149, 254, 157, 63, 169, 41, 103, 236, 30, 198, 176, 63, 143, 184, 212, 102, 88, 25, 186, 191, 216, 108, 221, 146, 65, 123, 149, 191, 157, 39, 45, 12, 113, 169, 171, 63, 148, 123, 103, 43, 114, 97, 164, 191, 250, 10, 251, 57, 113, 70, 160, 191, 74, 188, 134, 13, 231, 144, 153, 191, 71, 66, 88, 125, 170, 72, 181, 191, 87, 14, 16, 238, 3, 206, 193, 63, 161, 21, 225, 146, 45, 243, 210, 191, 104, 34, 10, 213, 24, 102, 138, 191, 206, 224, 88, 208, 213, 124, 182, 191, 206, 73, 96, 23, 50, 51, 204, 63, 235, 209, 216, 181, 215, 254, 164, 191, 216, 139, 75, 232, 243, 149, 168, 191, 220, 47, 123, 93, 16, 5, 160, 191, 86, 184, 119, 196, 30, 185, 145, 191, 202, 192, 80, 41, 250, 225, 173, 191, 196, 206, 8, 137, 33, 101, 167, 63, 230, 76, 200, 167, 27, 169, 162, 191, 250, 189, 82, 174, 135, 82, 178, 63, 223, 162, 139, 200, 78, 28, 186, 191, 237, 212, 172, 109, 15, 230, 178, 63, 243, 221, 23, 255, 7, 160, 189, 191, 203, 91, 190, 101, 245, 73, 171, 191, 238, 13, 186, 6, 111, 236, 117, 191, 119, 31, 24, 53, 155, 153, 114, 63, 115, 89, 54, 174, 110, 100, 188, 63, 235, 109, 189, 73, 254, 81, 163, 191, 158, 5, 112, 76, 140, 80, 125, 63, 26, 113, 132, 249, 52, 243, 191, 191, 218, 202, 154, 2, 13, 107, 191, 63, 187, 178, 40, 195, 135, 41, 144, 191, 100, 153, 107, 153, 197, 33, 145, 63, 187, 50, 167, 172, 60, 150, 181, 63, 29, 117, 94, 247, 247, 12, 114, 191, 252, 101, 17, 42, 119, 69, 192, 63, 141, 41, 42, 62, 20, 122, 143, 63, 125, 99, 145, 20, 18, 8, 148, 191, 174, 15, 236, 60, 92, 246, 194, 191, 76, 10, 95, 141, 104, 116, 116, 63, 148, 160, 228, 128, 248, 60, 190, 191, 93, 208, 58, 190, 117, 71, 162, 191, 53, 227, 42, 201, 87, 31, 123, 191, 114, 244, 227, 179, 158, 219, 143, 191, 108, 187, 230, 93, 240, 75, 150, 191, 60, 126, 160, 246, 120, 146, 191, 63, 57, 151, 75, 73, 247, 40, 186, 191, 16, 115, 217, 198, 8, 253, 155, 63, 32, 190, 33, 157, 174, 15, 172, 63, 138, 129, 10, 70, 38, 201, 92, 191, 2, 111, 58, 52, 161, 24, 181, 63, 199, 239, 189, 100, 135, 64, 171, 191, 121, 61, 192, 84, 163, 108, 145, 63, 161, 62, 146, 66, 151, 154, 182, 191, 139, 49, 156, 211, 197, 13, 128, 63, 232, 26, 91, 184, 159, 143, 197, 191, 174, 185, 108, 118, 113, 32, 147, 191, 175, 181, 189, 66, 249, 90, 191, 63, 59, 1, 37, 95, 229, 235, 201, 63, 200, 141, 22, 232, 141, 191, 168, 191, 115, 110, 100, 251, 129, 252, 177, 63, 238, 13, 39, 188, 229, 51, 168, 191, 193, 235, 4, 223, 208, 25, 178, 63, 2, 97, 104, 77, 94, 52, 167, 63, 114, 112, 136, 190, 188, 217, 134, 191, 231, 5, 224, 158, 216, 71, 151, 63, 93, 183, 64, 249, 151, 93, 155, 63, 124, 47, 80, 206, 251, 57, 125, 191, 193, 61, 50, 52, 132, 106, 192, 63, 10, 172, 57, 47, 67, 242, 167, 191, 94, 61, 49, 59, 85, 120, 178, 63, 130, 240, 56, 46, 107, 206, 172, 191, 139, 136, 152, 26, 33, 9, 176, 191, 180, 199, 22, 215, 34, 58, 183, 63, 212, 178, 229, 78, 127, 204, 186, 191, 81, 27, 171, 50, 110, 120, 176, 63, 75, 10, 61, 202, 22, 79, 138, 191, 153, 165, 185, 104, 163, 67, 185, 191, 92, 214, 189, 152, 171, 225, 163, 63, 127, 15, 68, 88, 187, 173, 183, 191, 18, 104, 231, 30, 200, 49, 192, 63, 158, 173, 233, 120, 42, 239, 136, 191, 165, 253, 159, 105, 214, 175, 179, 63, 114, 74, 111, 52, 212, 143, 147, 63, 45, 15, 56, 254, 151, 20, 176, 191, 58, 117, 56, 89, 84, 117, 142, 191, 124, 21, 145, 21, 154, 186, 175, 191, 109, 189, 211, 3, 235, 155, 193, 63, 254, 74, 168, 171, 67, 249, 175, 191, 130, 191, 116, 40, 227, 166, 165, 191, 187, 189, 160, 229, 51, 84, 175, 191, 24, 102, 242, 80, 14, 58, 176, 63, 165, 172, 200, 40, 81, 172, 158, 63, 44, 233, 108, 73, 113, 78, 146, 63, 42, 139, 5, 20, 45, 198, 175, 191, 148, 134, 41, 82, 144, 131, 128, 191, 222, 29, 59, 204, 14, 200, 183, 63, 60, 194, 223, 181, 82, 189, 184, 191, 234, 81, 95, 191, 163, 195, 173, 191, 38, 200, 41, 170, 159, 63, 177, 63, 8, 134, 141, 64, 27, 134, 122, 191, 128, 112, 214, 242, 160, 118, 183, 191, 52, 144, 11, 159, 87, 23, 159, 63, 112, 80, 175, 229, 180, 124, 161, 191, 70, 26, 106, 123, 235, 193, 181, 63, 85, 142, 91, 24, 38, 135, 177, 191, 168, 194, 139, 38, 93, 53, 156, 63, 169, 109, 106, 166, 200, 101, 200, 63, 9, 188, 191, 184, 122, 20, 190, 191, 160, 33, 206, 159, 26, 195, 99, 63, 181, 109, 162, 145, 147, 248, 172, 63, 36, 3, 251, 219, 105, 32, 192, 63, 168, 214, 22, 20, 3, 238, 146, 63, 37, 29, 124, 17, 253, 106, 140, 191, 210, 107, 71, 60, 15, 43, 167, 191, 46, 226, 236, 180, 229, 220, 165, 63, 52, 132, 114, 156, 117, 190, 205, 191, 114, 162, 135, 167, 34, 147, 202, 63, 80, 69, 91, 131, 200, 109, 142, 191, 53, 220, 23, 233, 87, 201, 178, 63, 190, 159, 42, 214, 189, 87, 181, 63, 151, 224, 83, 193, 170, 190, 177, 63, 215, 62, 49, 236, 18, 10, 178, 191, 78, 222, 215, 76, 236, 61, 187, 191, 216, 156, 205, 98, 46, 211, 183, 63, 144, 76, 109, 179, 232, 222, 115, 191, 71, 240, 36, 242, 139, 105, 182, 191, 83, 87, 161, 225, 19, 46, 141, 191, 178, 48, 212, 138, 187, 149, 171, 63, 83, 198, 23, 151, 43, 93, 194, 191, 153, 45, 38, 81, 187, 206, 161, 63, 81, 131, 27, 169, 119, 103, 181, 191, 44, 203, 6, 58, 84, 93, 164, 191, 56, 10, 139, 179, 192, 42, 139, 191, 73, 48, 115, 212, 213, 114, 178, 63, 222, 207, 194, 145, 48, 62, 149, 63, 28, 163, 228, 30, 100, 225, 182, 63, 101, 223, 18, 119, 234, 213, 182, 191, 81, 9, 13, 89, 102, 253, 171, 191, 86, 103, 236, 182, 64, 180, 183, 191, 219, 48, 211, 160, 239, 204, 168, 63, 188, 177, 107, 18, 11, 33, 133, 191, 179, 141, 22, 130, 145, 222, 191, 63, 163, 27, 144, 187, 206, 217, 179, 191, 159, 168, 63, 73, 113, 176, 171, 191, 234, 177, 228, 233, 108, 127, 163, 63, 118, 34, 12, 254, 114, 18, 178, 63, 194, 118, 232, 238, 200, 126, 160, 63, 204, 6, 86, 43, 122, 208, 186, 191, 180, 237, 125, 221, 171, 148, 143, 191, 13, 184, 193, 234, 89, 68, 180, 63, 206, 49, 39, 232, 40, 67, 133, 63, 4, 118, 217, 254, 140, 216, 185, 63, 153, 5, 220, 104, 46, 54, 193, 191, 28, 255, 46, 18, 196, 114, 164, 63, 31, 168, 177, 41, 162, 255, 205, 63, 95, 90, 56, 153, 134, 160, 194, 191, 145, 105, 82, 14, 77, 228, 176, 63, 189, 23, 63, 195, 231, 42, 146, 63, 86, 51, 88, 252, 85, 192, 175, 63, 13, 169, 150, 239, 195, 55, 188, 191, 68, 147, 31, 8, 153, 24, 186, 63, 196, 168, 222, 144, 73, 237, 151, 191, 125, 170, 240, 0, 225, 72, 176, 63, 186, 94, 208, 163, 102, 197, 172, 191, 180, 107, 226, 22, 175, 116, 170, 191, 20, 74, 81, 163, 60, 142, 165, 63, 39, 65, 77, 152, 17, 229, 134, 63, 174, 32, 55, 208, 62, 32, 178, 63, 19, 207, 170, 59, 177, 51, 132, 191, 216, 10, 110, 191, 110, 19, 184, 191, 216, 203, 52, 78, 119, 126, 180, 63, 69, 102, 225, 19, 171, 42, 120, 191, 53, 142, 180, 48, 229, 120, 146, 63, 239, 73, 72, 16, 253, 87, 172, 63, 100, 185, 73, 237, 186, 92, 193, 191, 132, 58, 183, 54, 177, 67, 172, 63, 43, 249, 193, 249, 194, 98, 138, 191, 51, 42, 123, 148, 14, 210, 148, 63, 95, 133, 7, 122, 222, 105, 151, 191, 246, 174, 150, 0, 75, 162, 126, 63, 217, 136, 20, 104, 129, 187, 193, 63, 154, 236, 77, 212, 135, 246, 185, 191, 156, 186, 12, 80, 238, 254, 161, 63, 229, 183, 152, 250, 173, 86, 135, 191, 221, 235, 99, 220, 125, 146, 158, 63, 50, 154, 143, 65, 186, 172, 162, 191, 100, 165, 89, 234, 250, 176, 138, 63, 130, 67, 44, 185, 21, 67, 176, 191, 61, 166, 151, 123, 225, 117, 182, 191, 96, 26, 25, 55, 54, 209, 193, 63, 227, 110, 173, 3, 201, 60, 178, 191, 60, 224, 5, 17, 215, 197, 153, 63, 81, 249, 84, 179, 228, 102, 141, 191, 113, 48, 4, 118, 139, 64, 161, 63, 50, 185, 31, 188, 46, 60, 167, 191, 216, 97, 115, 219, 241, 134, 162, 63, 132, 248, 211, 171, 176, 172, 129, 191, 29, 10, 204, 33, 28, 189, 187, 63, 72, 220, 11, 24, 209, 158, 125, 63, 38, 19, 146, 139, 130, 83, 196, 191, 170, 229, 74, 249, 129, 222, 193, 63, 132, 10, 39, 202, 109, 97, 167, 191, 241, 217, 248, 214, 219, 206, 142, 63, 164, 234, 248, 169, 100, 241, 164, 63, 12, 39, 199, 76, 82, 70, 189, 191, 240, 70, 206, 92, 191, 225, 80, 63, 167, 57, 141, 100, 172, 122, 131, 63, 2, 110, 139, 239, 4, 57, 135, 63, 238, 75, 199, 52, 190, 228, 187, 191, 104, 117, 247, 168, 247, 71, 175, 191, 243, 141, 62, 70, 239, 2, 191, 63, 224, 243, 48, 89, 10, 76, 179, 63, 45, 249, 216, 52, 2, 190, 192, 191, 147, 223, 33, 114, 208, 178, 205, 63, 39, 113, 172, 250, 168, 107, 187, 191, 238, 43, 99, 66, 15, 118, 139, 191, 105, 200, 5, 42, 213, 26, 179, 63, 134, 249, 228, 61, 143, 211, 172, 63, 153, 149, 193, 2, 183, 73, 179, 191, 70, 237, 40, 3, 211, 232, 182, 63, 155, 50, 143, 155, 239, 152, 179, 63, 103, 183, 65, 44, 159, 245, 177, 191, 183, 100, 216, 250, 12, 22, 111, 63, 143, 85, 86, 250, 17, 19, 190, 191, 228, 236, 230, 41, 157, 21, 167, 63, 35, 5, 44, 26, 243, 194, 181, 63, 98, 75, 181, 120, 70, 91, 192, 191, 83, 209, 224, 141, 15, 192, 166, 63, 92, 251, 69, 208, 148, 152, 178, 63, 160, 92, 53, 172, 45, 102, 175, 63, 85, 255, 13, 156, 151, 127, 178, 191, 158, 37, 89, 38, 151, 72, 90, 191, 178, 181, 134, 156, 152, 121, 175, 63, 18, 170, 30, 189, 197, 30, 195, 191, 15, 128, 36, 222, 137, 49, 187, 63, 95, 16, 38, 196, 89, 200, 152, 63, 38, 148, 14, 184, 26, 102, 184, 191, 129, 185, 69, 151, 16, 232, 163, 63, 202, 230, 22, 46, 134, 53, 173, 63, 188, 173, 65, 214, 79, 137, 118, 63, 89, 35, 78, 141, 212, 26, 164, 191, 159, 124, 34, 24, 238, 119, 163, 63, 122, 188, 153, 188, 72, 78, 193, 191, 225, 108, 41, 36, 227, 212, 194, 63, 174, 26, 233, 40, 224, 64, 150, 191, 30, 236, 69, 170, 246, 148, 177, 191, 58, 109, 129, 248, 143, 128, 163, 63, 254, 230, 78, 99, 139, 66, 187, 191, 247, 88, 47, 204, 132, 159, 122, 63, 248, 134, 40, 103, 128, 240, 152, 191, 102, 96, 151, 95, 4, 195, 180, 63, 135, 149, 237, 61, 23, 255, 170, 191, 0, 145, 182, 60, 141, 234, 112, 63, 244, 182, 69, 143, 229, 78, 167, 63, 232, 68, 106, 83, 106, 177, 157, 63, 91, 203, 8, 49, 120, 3, 175, 63, 177, 227, 98, 27, 44, 42, 185, 191, 52, 212, 4, 161, 180, 88, 193, 63, 80, 185, 162, 90, 9, 205, 112, 63, 202, 69, 118, 64, 171, 244, 170, 63, 154, 89, 117, 55, 4, 149, 178, 191, 188, 149, 59, 21, 20, 128, 174, 63, 201, 158, 66, 127, 18, 230, 200, 191, 6, 151, 101, 14, 137, 165, 194, 63, 136, 110, 118, 9, 25, 250, 156, 191, 197, 204, 33, 137, 85, 120, 178, 63, 70, 180, 62, 252, 190, 9, 187, 63, 32, 104, 98, 15, 222, 36, 171, 191, 116, 82, 150, 208, 180, 217, 162, 191, 160, 99, 251, 144, 105, 19, 174, 191, 68, 100, 199, 253, 22, 240, 187, 191, 110, 27, 124, 130, 59, 19, 162, 191, 28, 236, 206, 14, 168, 203, 165, 63, 39, 210, 31, 214, 9, 7, 183, 191, 189, 59, 172, 122, 64, 153, 174, 191, 204, 179, 93, 52, 126, 152, 178, 63, 1, 226, 73, 43, 154, 27, 122, 191, 46, 191, 112, 141, 8, 6, 183, 63, 148, 116, 230, 138, 154, 234, 94, 191, 147, 223, 26, 127, 106, 129, 185, 63, 126, 239, 246, 33, 77, 64, 183, 63, 211, 4, 25, 200, 56, 152, 182, 63, 157, 19, 87, 225, 186, 197, 178, 63, 24, 201, 149, 236, 92, 108, 156, 191, 219, 41, 175, 140, 34, 128, 186, 63, 64, 110, 7, 208, 142, 147, 163, 191, 58, 209, 9, 236, 192, 190, 161, 191, 152, 31, 225, 253, 59, 127, 153, 191, 134, 119, 129, 188, 6, 251, 188, 191, 91, 210, 89, 133, 223, 159, 151, 63, 38, 170, 24, 242, 110, 224, 130, 191, 27, 183, 158, 95, 90, 27, 192, 191, 227, 160, 195, 218, 190, 91, 166, 191, 27, 116, 0, 144, 23, 126, 168, 191, 111, 32, 30, 208, 95, 159, 180, 191, 182, 251, 237, 155, 210, 170, 164, 191, 255, 55, 160, 83, 250, 86, 143, 63, 198, 144, 28, 70, 139, 94, 171, 191, 214, 20, 33, 30, 105, 80, 177, 63, 172, 167, 152, 242, 200, 163, 169, 191, 185, 15, 158, 242, 149, 149, 185, 191, 108, 162, 122, 150, 220, 32, 209, 191, 162, 132, 254, 125, 71, 119, 173, 63, 163, 88, 119, 112, 194, 53, 176, 63, 233, 192, 253, 184, 71, 36, 198, 191, 186, 13, 238, 199, 152, 75, 192, 63, 232, 248, 49, 226, 108, 154, 137, 63, 218, 201, 140, 53, 76, 7, 159, 63, 14, 67, 14, 46, 115, 60, 159, 191, 234, 118, 84, 238, 15, 118, 199, 63, 248, 24, 240, 155, 230, 195, 170, 63, 50, 127, 229, 12, 101, 233, 163, 191, 237, 83, 12, 63, 214, 90, 176, 63, 157, 223, 116, 174, 160, 156, 170, 63, 26, 102, 120, 204, 246, 30, 178, 63, 189, 194, 28, 56, 200, 214, 160, 63, 235, 174, 218, 100, 63, 182, 181, 191, 197, 187, 47, 120, 144, 148, 180, 191, 238, 19, 207, 250, 135, 138, 166, 191, 14, 197, 129, 176, 58, 1, 174, 191, 90, 3, 0, 237, 235, 141, 161, 63, 157, 91, 128, 173, 240, 80, 192, 63, 97, 176, 217, 165, 128, 169, 164, 63, 166, 86, 147, 54, 47, 49, 166, 63, 84, 39, 99, 131, 244, 183, 182, 63, 25, 178, 204, 33, 147, 46, 169, 63, 179, 254, 12, 212, 72, 158, 168, 63, 71, 205, 102, 23, 31, 233, 186, 191, 50, 62, 43, 208, 212, 5, 181, 191, 160, 118, 135, 90, 29, 174, 135, 191, 168, 123, 93, 49, 156, 16, 162, 191, 206, 89, 38, 129, 42, 158, 185, 191, 176, 158, 143, 135, 243, 49, 186, 191, 22, 245, 175, 83, 28, 213, 129, 191, 225, 149, 116, 236, 33, 207, 181, 191, 172, 201, 137, 252, 231, 126, 161, 63, 125, 98, 128, 136, 90, 186, 184, 63, 173, 135, 207, 10, 174, 25, 160, 63, 104, 68, 46, 5, 167, 84, 139, 191, 63, 227, 203, 166, 121, 120, 139, 63, 17, 102, 53, 251, 208, 51, 183, 63, 245, 204, 188, 253, 81, 33, 193, 63, 83, 70, 29, 243, 0, 216, 179, 63, 195, 89, 145, 185, 141, 225, 147, 191, 44, 230, 254, 89, 1, 61, 186, 63, 170, 234, 198, 33, 238, 169, 168, 63, 231, 241, 46, 73, 113, 68, 176, 191, 72, 204, 61, 220, 130, 159, 169, 191, 136, 240, 100, 212, 100, 74, 114, 191, 112, 194, 71, 62, 236, 9, 141, 63, 14, 111, 119, 246, 27, 177, 183, 191, 40, 156, 86, 209, 16, 162, 126, 63, 3, 254, 230, 255, 133, 84, 187, 191, 149, 16, 92, 90, 83, 57, 209, 191, 242, 63, 18, 192, 210, 144, 177, 63, 215, 40, 111, 152, 14, 236, 191, 63, 58, 25, 81, 235, 67, 31, 174, 191, 142, 201, 142, 148, 11, 41, 188, 191, 19, 134, 159, 249, 102, 152, 187, 63, 130, 173, 33, 171, 153, 11, 169, 63, 56, 11, 97, 217, 255, 88, 153, 191, 33, 41, 236, 51, 105, 75, 115, 191, 106, 207, 211, 165, 138, 18, 138, 63, 178, 140, 117, 68, 131, 85, 179, 63, 7, 192, 130, 170, 126, 211, 166, 191, 250, 95, 169, 41, 167, 203, 188, 63, 92, 221, 75, 166, 212, 195, 168, 63, 12, 239, 160, 70, 68, 177, 165, 191, 62, 172, 136, 45, 254, 246, 181, 191, 249, 188, 134, 173, 156, 184, 187, 63, 62, 176, 49, 12, 45, 220, 182, 63, 128, 211, 55, 69, 132, 172, 89, 191, 4, 115, 245, 9, 86, 62, 138, 191, 164, 199, 42, 28, 193, 1, 181, 191, 180, 207, 49, 235, 151, 229, 189, 191, 36, 100, 153, 156, 250, 186, 176, 63, 38, 183, 221, 153, 213, 123, 192, 63, 222, 80, 12, 86, 28, 251, 120, 63, 233, 112, 45, 23, 188, 21, 142, 191, 52, 80, 63, 65, 138, 190, 73, 191, 128, 119, 236, 164, 199, 89, 161, 191, 117, 56, 56, 251, 180, 200, 192, 191, 204, 91, 107, 129, 209, 250, 190, 191, 46, 77, 132, 202, 221, 222, 106, 191, 63, 28, 99, 151, 16, 148, 192, 63, 139, 53, 106, 167, 23, 163, 147, 63, 48, 198, 229, 102, 37, 43, 155, 191, 44, 13, 197, 107, 60, 46, 134, 191, 248, 157, 48, 33, 137, 174, 144, 63, 12, 69, 152, 112, 38, 134, 121, 63, 137, 90, 48, 83, 216, 188, 173, 191, 162, 141, 128, 103, 22, 43, 198, 191, 175, 78, 132, 214, 140, 9, 184, 191, 205, 31, 93, 29, 118, 78, 173, 191, 24, 255, 255, 221, 237, 173, 186, 63, 42, 41, 167, 18, 74, 214, 151, 63, 145, 135, 233, 79, 138, 202, 164, 191, 227, 191, 218, 26, 79, 88, 161, 191, 122, 1, 56, 4, 67, 153, 122, 191, 8, 60, 253, 251, 45, 193, 146, 191, 85, 102, 106, 213, 199, 195, 187, 63, 54, 79, 108, 164, 237, 196, 160, 191, 176, 154, 49, 139, 86, 18, 177, 191, 117, 50, 100, 210, 166, 98, 195, 191, 166, 196, 67, 99, 88, 167, 166, 191, 48, 150, 97, 66, 59, 62, 193, 191, 243, 168, 175, 59, 69, 92, 173, 63, 246, 221, 253, 102, 199, 112, 178, 63, 180, 32, 152, 149, 119, 228, 114, 63, 220, 19, 22, 148, 229, 37, 193, 191, 152, 253, 165, 243, 149, 9, 139, 63, 68, 172, 49, 71, 209, 118, 161, 63, 96, 194, 43, 208, 208, 166, 177, 63, 146, 163, 184, 20, 253, 246, 184, 191, 105, 64, 176, 101, 96, 189, 155, 63, 12, 249, 144, 131, 21, 249, 174, 63, 71, 232, 241, 164, 109, 60, 190, 191, 197, 64, 8, 206, 181, 252, 168, 191, 217, 181, 82, 221, 150, 92, 172, 191, 235, 157, 141, 248, 7, 179, 157, 63, 84, 224, 189, 192, 215, 68, 174, 191, 153, 143, 20, 47, 101, 33, 142, 191, 109, 51, 19, 68, 245, 216, 177, 191, 78, 171, 104, 205, 40, 36, 172, 63, 105, 83, 141, 90, 103, 38, 173, 191, 242, 78, 155, 157, 126, 91, 161, 191, 214, 170, 226, 239, 211, 39, 164, 191, 132, 89, 17, 72, 236, 143, 192, 191, 102, 26, 7, 188, 142, 129, 187, 63, 156, 168, 68, 129, 180, 44, 126, 191, 55, 160, 68, 19, 102, 56, 169, 63, 188, 207, 135, 209, 123, 63, 178, 63, 227, 9, 3, 170, 88, 163, 147, 63, 132, 103, 96, 179, 73, 253, 169, 191, 186, 176, 107, 146, 235, 148, 159, 63, 21, 26, 167, 0, 97, 214, 181, 191, 48, 170, 246, 151, 170, 138, 180, 191, 201, 208, 152, 231, 1, 131, 195, 63, 160, 8, 46, 89, 179, 125, 183, 63, 180, 73, 140, 124, 231, 239, 143, 63, 174, 41, 226, 27, 28, 240, 179, 63, 19, 238, 86, 242, 185, 1, 142, 191, 233, 109, 119, 100, 156, 12, 178, 63, 121, 97, 214, 14, 32, 152, 147, 63, 20, 186, 81, 251, 108, 89, 177, 63, 163, 255, 155, 58, 202, 105, 166, 63, 53, 237, 153, 151, 63, 25, 178, 191, 141, 67, 171, 210, 143, 52, 166, 63, 33, 167, 40, 167, 197, 44, 192, 63, 182, 201, 81, 130, 198, 54, 204, 63, 60, 178, 126, 7, 230, 42, 173, 191, 60, 240, 110, 155, 37, 193, 146, 191, 253, 96, 94, 72, 8, 19, 179, 191, 211, 89, 101, 184, 99, 41, 179, 191, 102, 52, 239, 112, 189, 217, 162, 191, 160, 255, 135, 21, 112, 168, 171, 63, 177, 215, 164, 121, 255, 163, 157, 63, 36, 210, 34, 218, 23, 96, 192, 63, 76, 21, 147, 184, 123, 9, 166, 191, 5, 73, 30, 82, 95, 33, 194, 63, 15, 210, 136, 69, 137, 50, 191, 63, 46, 148, 198, 127, 232, 51, 177, 63, 184, 182, 140, 8, 197, 1, 181, 63, 17, 232, 30, 223, 172, 209, 179, 63, 89, 68, 43, 155, 250, 173, 162, 63, 40, 179, 79, 137, 23, 206, 168, 63, 229, 196, 6, 214, 172, 107, 190, 63, 4, 233, 221, 30, 62, 255, 153, 63, 124, 163, 115, 237, 203, 233, 168, 63, 152, 64, 3, 162, 140, 164, 171, 191, 58, 66, 147, 166, 59, 116, 153, 191, 84, 160, 168, 182, 36, 37, 184, 63, 12, 103, 248, 54, 197, 63, 181, 63, 18, 106, 12, 233, 66, 117, 171, 191, 204, 152, 206, 185, 116, 222, 160, 63, 75, 111, 45, 140, 176, 134, 181, 191, 180, 151, 193, 23, 2, 211, 174, 191, 129, 61, 22, 160, 79, 37, 164, 191, 78, 21, 87, 166, 17, 54, 159, 191, 163, 82, 160, 87, 91, 70, 189, 63, 43, 96, 11, 70, 129, 159, 91, 191, 241, 19, 103, 205, 255, 160, 183, 191, 200, 231, 225, 121, 103, 148, 108, 63, 10, 206, 21, 100, 217, 126, 183, 191, 31, 65, 144, 117, 141, 80, 185, 191, 208, 34, 183, 240, 134, 80, 131, 63, 197, 13, 182, 249, 49, 87, 115, 191, 237, 88, 36, 90, 77, 182, 181, 191, 64, 42, 31, 125, 171, 207, 146, 191, 204, 166, 53, 62, 189, 186, 181, 63, 223, 209, 142, 76, 118, 255, 177, 191, 85, 134, 144, 47, 130, 118, 179, 191, 4, 83, 51, 248, 141, 94, 159, 191, 184, 214, 56, 63, 85, 251, 165, 191, 122, 176, 28, 27, 116, 165, 193, 191, 181, 201, 169, 149, 19, 174, 144, 191, 141, 27, 24, 63, 194, 56, 161, 63, 12, 91, 210, 20, 173, 137, 209, 63, 124, 20, 82, 224, 142, 129, 189, 191, 80, 199, 254, 188, 152, 146, 175, 191, 46, 252, 10, 161, 22, 157, 166, 191, 83, 32, 102, 150, 108, 76, 177, 191, 107, 96, 118, 20, 42, 159, 207, 191, 181, 0, 10, 135, 193, 80, 189, 63, 220, 56, 183, 26, 92, 133, 187, 191, 112, 119, 229, 143, 217, 41, 110, 191, 218, 166, 204, 47, 19, 232, 195, 191, 64, 249, 157, 166, 153, 15, 192, 63, 79, 115, 145, 248, 46, 46, 182, 63, 64, 220, 189, 190, 7, 202, 116, 63, 73, 100, 233, 156, 170, 23, 179, 63, 13, 118, 200, 176, 134, 211, 192, 63, 192, 103, 193, 171, 249, 222, 133, 191, 180, 131, 68, 168, 26, 27, 132, 63, 255, 87, 211, 63, 52, 249, 136, 63, 54, 124, 89, 146, 52, 162, 151, 191, 207, 227, 53, 68, 95, 76, 180, 191, 220, 31, 51, 226, 76, 239, 125, 191, 124, 10, 182, 128, 114, 194, 194, 191, 58, 193, 59, 242, 127, 221, 195, 191, 200, 113, 192, 122, 50, 135, 117, 191, 47, 93, 129, 22, 23, 19, 189, 191, 137, 127, 92, 217, 48, 209, 148, 63, 4, 110, 180, 154, 68, 115, 130, 191, 158, 77, 139, 193, 212, 182, 161, 63, 86, 177, 75, 61, 121, 119, 162, 191, 76, 188, 132, 232, 229, 254, 162, 191, 87, 248, 194, 145, 87, 21, 167, 63, 200, 172, 137, 217, 71, 214, 86, 191, 221, 189, 140, 159, 27, 119, 166, 63, 45, 100, 183, 99, 125, 65, 178, 63, 58, 40, 138, 195, 89, 100, 116, 63, 2, 207, 210, 192, 10, 225, 188, 63, 198, 112, 139, 25, 39, 188, 137, 63, 226, 120, 171, 1, 223, 113, 197, 63, 163, 143, 5, 79, 46, 168, 198, 63, 150, 86, 230, 144, 57, 178, 141, 63, 46, 58, 88, 33, 63, 76, 192, 63, 64, 194, 52, 214, 37, 160, 144, 63, 226, 107, 124, 57, 118, 11, 186, 63, 155, 239, 7, 53, 82, 134, 169, 191, 142, 26, 161, 42, 179, 31, 120, 63, 104, 243, 108, 207, 63, 230, 173, 191, 26, 61, 26, 117, 25, 105, 90, 63, 168, 213, 49, 165, 9, 74, 166, 191, 47, 140, 165, 143, 137, 45, 176, 63, 200, 23, 74, 183, 178, 229, 208, 63, 233, 2, 28, 42, 121, 76, 177, 191, 180, 74, 79, 254, 113, 124, 144, 63, 119, 82, 156, 133, 43, 77, 163, 63, 248, 211, 175, 210, 38, 213, 173, 191, 69, 150, 165, 182, 50, 40, 184, 191, 200, 18, 128, 139, 97, 102, 117, 63, 134, 168, 9, 213, 217, 48, 154, 191, 22, 72, 35, 45, 119, 172, 190, 191, 64, 75, 140, 161, 94, 156, 176, 191, 128, 229, 19, 120, 116, 95, 163, 191, 116, 73, 11, 149, 81, 145, 140, 63, 114, 196, 16, 249, 214, 32, 187, 191, 134, 203, 24, 114, 237, 123, 178, 63, 183, 128, 2, 98, 200, 229, 186, 63, 66, 219, 230, 211, 39, 47, 157, 63, 233, 158, 226, 90, 227, 33, 174, 63, 141, 236, 228, 148, 171, 2, 189, 63, 61, 217, 10, 182, 150, 80, 174, 63, 226, 68, 102, 105, 89, 18, 178, 191, 113, 136, 152, 94, 112, 120, 156, 63, 107, 207, 105, 62, 214, 191, 176, 191, 220, 79, 115, 122, 99, 81, 115, 191, 210, 60, 152, 212, 36, 234, 174, 63, 209, 147, 224, 141, 89, 171, 178, 191, 55, 116, 67, 175, 39, 106, 172, 191, 53, 154, 163, 147, 209, 197, 163, 191, 100, 210, 228, 175, 133, 68, 167, 191, 180, 248, 171, 221, 88, 251, 192, 191, 42, 65, 114, 165, 135, 47, 192, 191, 166, 209, 16, 185, 191, 66, 138, 191, 132, 100, 108, 41, 109, 213, 179, 191, 155, 70, 25, 18, 186, 5, 182, 191, 124, 14, 166, 182, 43, 159, 169, 63, 195, 15, 209, 92, 49, 10, 166, 191, 147, 159, 183, 153, 47, 123, 169, 63, 123, 39, 114, 0, 71, 229, 182, 191, 108, 84, 52, 235, 82, 62, 178, 191, 9, 144, 37, 132, 240, 241, 190, 191, 163, 7, 119, 113, 91, 202, 188, 191, 4, 107, 135, 138, 238, 24, 129, 191, 158, 119, 56, 205, 57, 9, 189, 191, 194, 81, 225, 63, 88, 49, 158, 63, 223, 72, 154, 41, 39, 169, 185, 63, 71, 12, 104, 132, 225, 140, 157, 63, 37, 136, 45, 69, 185, 68, 178, 63, 150, 237, 235, 235, 16, 159, 176, 63, 190, 168, 211, 130, 186, 113, 159, 191, 194, 238, 55, 207, 69, 198, 177, 63, 204, 32, 70, 107, 126, 91, 179, 191, 101, 62, 165, 234, 26, 33, 165, 191, 13, 169, 195, 163, 91, 98, 164, 191, 228, 64, 103, 15, 56, 38, 170, 63, 6, 244, 141, 132, 185, 72, 144, 63, 115, 44, 52, 240, 11, 211, 201, 63, 64, 188, 95, 102, 39, 67, 181, 191, 210, 130, 191, 212, 234, 154, 188, 63, 80, 199, 27, 107, 239, 108, 90, 63, 210, 13, 78, 218, 173, 20, 199, 63, 80, 76, 141, 233, 71, 210, 139, 191, 95, 251, 68, 243, 155, 174, 181, 63, 131, 9, 147, 69, 179, 229, 174, 63, 208, 255, 170, 240, 170, 23, 179, 63, 197, 46, 126, 106, 139, 34, 166, 191, 30, 195, 32, 130, 84, 41, 182, 63, 228, 220, 149, 200, 93, 20, 183, 191, 196, 248, 164, 138, 225, 28, 177, 63, 251, 40, 82, 172, 118, 140, 178, 191, 196, 36, 85, 119, 249, 38, 149, 63, 44, 74, 182, 177, 239, 10, 192, 191, 232, 85, 38, 192, 113, 88, 170, 63, 164, 188, 72, 206, 131, 242, 177, 191, 207, 122, 232, 248, 144, 237, 188, 63, 14, 221, 81, 207, 139, 70, 167, 191, 108, 106, 130, 51, 36, 252, 171, 191, 220, 196, 174, 26, 184, 65, 184, 191, 80, 79, 63, 214, 215, 167, 182, 63, 43, 124, 132, 96, 42, 226, 149, 191, 70, 25, 212, 29, 253, 232, 173, 63, 253, 26, 205, 149, 105, 158, 193, 191, 100, 43, 109, 130, 102, 240, 190, 63, 232, 231, 130, 67, 170, 77, 116, 63, 211, 146, 150, 62, 71, 7, 183, 191, 84, 155, 35, 10, 176, 166, 136, 63, 239, 215, 136, 237, 115, 22, 179, 63, 108, 202, 59, 76, 156, 50, 152, 191, 136, 92, 108, 150, 110, 55, 126, 191, 114, 38, 175, 196, 212, 241, 159, 191, 117, 116, 234, 214, 199, 94, 192, 63, 185, 139, 223, 218, 230, 199, 197, 191, 155, 102, 16, 211, 251, 91, 176, 63, 137, 10, 76, 105, 1, 2, 171, 63, 70, 71, 238, 109, 104, 109, 168, 191, 66, 141, 132, 179, 28, 131, 187, 63, 114, 79, 236, 176, 181, 43, 160, 63, 233, 163, 141, 82, 234, 151, 158, 191, 194, 106, 250, 134, 251, 198, 157, 191, 122, 183, 204, 189, 85, 92, 150, 63, 150, 141, 222, 191, 204, 163, 196, 63, 114, 103, 124, 4, 74, 209, 180, 191, 249, 167, 90, 69, 158, 238, 195, 63, 226, 51, 131, 225, 164, 56, 201, 191, 38, 7, 218, 196, 175, 40, 160, 63, 48, 33, 175, 94, 15, 228, 158, 63, 214, 122, 129, 200, 78, 113, 181, 63, 71, 186, 156, 173, 221, 30, 161, 63, 164, 234, 213, 99, 88, 57, 122, 191, 165, 98, 250, 232, 186, 103, 180, 191, 83, 75, 60, 88, 136, 38, 183, 63, 36, 35, 180, 203, 180, 134, 122, 63, 192, 167, 110, 204, 163, 95, 110, 63, 105, 21, 3, 240, 255, 103, 178, 63, 94, 97, 99, 253, 39, 127, 187, 191, 249, 61, 220, 135, 37, 156, 157, 191, 51, 78, 38, 115, 182, 52, 172, 63, 52, 83, 31, 104, 187, 75, 187, 191, 123, 36, 117, 148, 106, 104, 170, 63, 152, 241, 19, 118, 158, 252, 178, 191, 118, 222, 104, 147, 204, 247, 153, 191, 78, 125, 48, 231, 23, 150, 178, 191, 60, 64, 242, 157, 162, 158, 135, 63, 242, 174, 250, 227, 2, 238, 177, 63, 161, 172, 125, 205, 229, 55, 181, 63, 163, 5, 72, 176, 82, 2, 177, 63, 75, 135, 168, 182, 97, 86, 167, 191, 44, 0, 43, 41, 213, 96, 169, 63, 187, 111, 58, 26, 238, 173, 193, 191, 225, 143, 204, 157, 250, 144, 192, 63, 138, 106, 56, 92, 115, 209, 133, 191, 11, 30, 66, 48, 55, 241, 176, 63, 93, 35, 214, 222, 124, 126, 182, 191, 124, 219, 238, 198, 234, 252, 169, 63, 16, 246, 44, 8, 44, 25, 171, 63, 73, 82, 143, 130, 244, 238, 160, 63, 253, 45, 40, 223, 225, 209, 183, 63, 119, 217, 167, 114, 50, 2, 176, 191, 120, 202, 35, 173, 89, 25, 187, 63, 33, 251, 208, 13, 224, 174, 186, 191, 75, 51, 116, 88, 168, 35, 140, 191, 7, 3, 169, 99, 36, 70, 182, 191, 96, 101, 160, 250, 127, 226, 163, 191, 230, 184, 18, 248, 120, 121, 181, 191, 146, 36, 73, 149, 123, 219, 133, 63, 81, 187, 28, 167, 119, 160, 181, 191, 46, 147, 81, 212, 249, 185, 173, 63, 52, 187, 181, 209, 226, 37, 167, 63, 16, 72, 28, 127, 141, 250, 181, 63, 56, 82, 75, 223, 34, 188, 161, 191, 88, 45, 219, 4, 50, 207, 193, 191, 33, 20, 105, 108, 173, 104, 163, 63, 166, 4, 21, 97, 157, 48, 148, 191, 13, 14, 204, 3, 41, 250, 176, 63, 111, 70, 47, 114, 110, 105, 186, 63, 42, 151, 161, 254, 111, 191, 154, 63, 42, 87, 252, 143, 45, 207, 177, 191, 27, 65, 87, 33, 152, 46, 141, 191, 189, 89, 200, 252, 53, 113, 195, 191, 240, 148, 4, 255, 116, 57, 167, 63, 98, 59, 131, 232, 242, 69, 193, 191, 105, 59, 166, 18, 81, 57, 176, 63, 228, 35, 30, 92, 208, 166, 177, 63, 253, 42, 63, 236, 211, 84, 149, 63, 34, 55, 244, 41, 3, 55, 176, 63, 127, 147, 49, 39, 88, 229, 184, 191, 157, 180, 102, 171, 215, 229, 160, 191, 205, 215, 100, 108, 84, 207, 161, 63, 202, 137, 244, 194, 44, 137, 137, 191, 18, 222, 221, 154, 28, 228, 189, 191, 25, 218, 153, 6, 108, 99, 182, 63, 218, 157, 245, 102, 195, 208, 167, 63, 202, 72, 165, 106, 225, 102, 175, 191, 176, 11, 205, 122, 134, 20, 145, 63, 82, 158, 252, 244, 76, 31, 179, 191, 171, 9, 42, 167, 2, 71, 166, 191, 147, 41, 185, 148, 210, 204, 189, 63, 223, 183, 81, 35, 235, 133, 174, 191, 229, 46, 201, 94, 116, 3, 170, 191, 239, 33, 61, 29, 11, 159, 180, 63, 157, 215, 127, 26, 114, 152, 169, 191, 115, 134, 145, 85, 171, 214, 142, 191, 130, 53, 16, 33, 217, 192, 173, 191, 202, 41, 41, 195, 115, 85, 176, 63, 50, 99, 211, 50, 188, 181, 178, 63, 76, 247, 229, 233, 174, 91, 185, 191, 181, 236, 229, 137, 234, 168, 168, 63, 252, 232, 92, 14, 98, 24, 162, 63, 90, 73, 50, 66, 50, 70, 188, 191, 171, 102, 188, 228, 75, 239, 180, 63, 248, 241, 66, 73, 165, 181, 123, 191, 238, 112, 225, 53, 148, 3, 139, 191, 91, 251, 19, 127, 133, 92, 120, 191, 192, 249, 108, 46, 149, 138, 193, 63, 54, 170, 244, 16, 111, 43, 162, 191, 209, 126, 3, 116, 98, 203, 183, 191, 254, 124, 130, 237, 100, 51, 181, 63, 139, 34, 118, 249, 2, 4, 160, 191, 244, 40, 169, 63, 162, 90, 195, 191, 87, 238, 92, 216, 232, 101, 176, 63, 116, 44, 25, 218, 213, 142, 189, 191, 32, 85, 84, 142, 103, 193, 180, 63, 92, 216, 103, 54, 72, 169, 136, 191, 14, 43, 227, 208, 17, 1, 131, 191, 65, 99, 42, 25, 234, 26, 177, 63, 164, 91, 253, 206, 37, 33, 191, 63, 188, 80, 132, 38, 103, 253, 204, 191, 142, 29, 33, 170, 2, 83, 156, 63, 123, 220, 215, 73, 109, 246, 192, 63, 245, 162, 223, 105, 198, 184, 158, 191, 105, 30, 69, 19, 201, 79, 154, 191, 176, 166, 148, 151, 237, 123, 178, 63, 150, 63, 90, 32, 199, 22, 137, 63, 209, 221, 245, 233, 210, 221, 187, 63, 171, 146, 20, 165, 225, 123, 173, 191, 255, 69, 21, 31, 109, 154, 146, 191, 182, 175, 130, 185, 211, 72, 152, 63, 122, 196, 250, 204, 115, 148, 187, 63, 134, 3, 111, 159, 101, 130, 189, 191, 143, 230, 189, 218, 5, 11, 153, 63, 186, 82, 60, 2, 234, 72, 142, 63, 122, 110, 144, 198, 216, 53, 157, 191, 65, 60, 187, 116, 53, 62, 155, 63, 34, 71, 137, 237, 185, 58, 177, 63, 208, 112, 22, 237, 216, 49, 195, 191, 130, 83, 111, 81, 253, 224, 176, 63, 237, 73, 12, 34, 177, 105, 134, 191, 103, 27, 241, 43, 14, 196, 137, 191, 214, 58, 124, 182, 51, 237, 161, 63, 45, 43, 119, 147, 136, 229, 168, 191, 229, 9, 140, 201, 140, 15, 158, 63, 226, 94, 222, 122, 40, 158, 82, 63, 56, 246, 133, 79, 141, 225, 197, 191, 89, 67, 102, 45, 246, 111, 190, 63, 42, 36, 63, 100, 118, 195, 163, 191, 146, 84, 69, 139, 210, 205, 102, 191, 94, 73, 83, 255, 158, 186, 141, 63, 156, 156, 167, 1, 24, 89, 149, 191, 136, 86, 66, 249, 16, 64, 173, 63, 16, 218, 166, 199, 107, 89, 176, 191, 13, 254, 245, 213, 164, 120, 132, 63, 210, 116, 27, 69, 77, 119, 168, 191, 78, 152, 70, 44, 229, 238, 197, 191, 251, 94, 73, 94, 237, 47, 196, 63, 224, 157, 45, 202, 14, 246, 168, 191, 207, 61, 172, 70, 125, 174, 108, 63, 21, 245, 63, 177, 55, 34, 114, 63, 212, 96, 148, 199, 93, 20, 166, 191, 119, 216, 100, 124, 130, 55, 171, 63, 132, 98, 136, 200, 32, 204, 157, 191, 213, 144, 228, 13, 103, 28, 174, 63, 230, 110, 182, 107, 27, 27, 160, 191, 236, 130, 172, 80, 70, 22, 146, 63, 31, 22, 155, 6, 248, 159, 194, 191, 163, 71, 148, 128, 168, 176, 182, 191, 144, 30, 99, 187, 119, 137, 205, 63, 166, 29, 181, 148, 146, 45, 153, 191, 50, 97, 214, 203, 79, 233, 194, 191, 244, 47, 181, 233, 249, 120, 136, 63, 45, 241, 239, 99, 57, 141, 146, 63, 17, 199, 3, 18, 213, 26, 179, 63, 226, 150, 37, 222, 211, 114, 192, 191, 141, 54, 84, 22, 20, 1, 146, 63, 199, 120, 67, 115, 228, 91, 119, 63, 230, 103, 83, 105, 59, 39, 106, 191, 103, 148, 121, 95, 231, 114, 162, 191, 148, 82, 190, 11, 3, 7, 180, 191, 152, 131, 48, 87, 159, 36, 107, 191, 45, 206, 158, 80, 88, 187, 193, 191, 13, 216, 105, 154, 129, 26, 196, 63, 43, 172, 234, 99, 134, 182, 83, 63, 92, 14, 189, 115, 101, 51, 187, 63, 24, 56, 238, 245, 82, 30, 164, 191, 112, 180, 185, 161, 61, 232, 92, 63, 149, 92, 200, 24, 153, 8, 168, 191, 20, 128, 174, 9, 162, 138, 130, 191, 211, 255, 194, 239, 156, 200, 139, 63, 67, 232, 104, 8, 1, 233, 175, 63, 60, 15, 166, 20, 195, 244, 95, 63, 128, 45, 30, 74, 240, 227, 176, 63, 14, 192, 250, 66, 119, 130, 178, 63, 36, 79, 12, 130, 28, 29, 97, 191, 17, 229, 47, 117, 215, 201, 188, 63, 92, 4, 77, 143, 52, 255, 100, 191, 56, 103, 97, 167, 175, 15, 197, 63, 0, 57, 205, 66, 116, 144, 200, 191, 132, 137, 167, 105, 136, 93, 105, 191, 238, 70, 142, 58, 104, 125, 187, 191, 148, 5, 220, 82, 96, 42, 109, 63, 103, 20, 36, 95, 162, 34, 181, 191, 189, 126, 100, 247, 58, 59, 168, 63, 56, 195, 73, 30, 128, 72, 119, 191, 216, 17, 131, 220, 35, 161, 177, 63, 223, 120, 146, 142, 28, 59, 138, 63, 238, 250, 108, 226, 87, 112, 180, 63, 32, 40, 213, 25, 84, 228, 152, 63, 196, 58, 68, 107, 58, 14, 205, 191, 15, 202, 60, 133, 159, 185, 187, 191, 230, 156, 1, 225, 69, 123, 168, 191, 157, 93, 105, 254, 26, 67, 134, 63, 22, 210, 120, 15, 8, 44, 137, 191, 132, 156, 25, 181, 158, 169, 176, 191, 26, 51, 38, 39, 219, 104, 172, 191, 179, 9, 206, 247, 9, 190, 161, 63, 69, 223, 57, 139, 232, 216, 165, 191, 249, 249, 29, 163, 190, 205, 167, 63, 30, 52, 238, 200, 76, 56, 183, 191, 124, 21, 20, 122, 242, 122, 167, 191, 64, 161, 12, 188, 45, 233, 192, 191, 81, 31, 242, 89, 88, 201, 178, 63, 148, 57, 223, 13, 253, 89, 173, 63, 32, 134, 92, 133, 188, 185, 125, 191, 18, 10, 171, 42, 38, 157, 189, 63, 22, 230, 200, 62, 162, 75, 190, 63, 236, 159, 221, 33, 0, 19, 58, 191, 103, 213, 143, 141, 2, 56, 181, 191, 27, 199, 73, 89, 53, 243, 148, 191, 246, 193, 137, 165, 62, 197, 180, 63, 88, 223, 183, 219, 172, 67, 195, 63, 152, 6, 234, 96, 83, 6, 150, 191, 85, 212, 33, 185, 124, 80, 175, 191, 40, 136, 217, 102, 148, 65, 144, 63, 254, 14, 33, 53, 165, 20, 187, 191, 175, 33, 216, 86, 59, 105, 138, 191, 72, 160, 39, 182, 159, 16, 139, 63, 106, 120, 235, 23, 170, 242, 195, 63, 54, 139, 240, 182, 212, 30, 153, 191, 60, 147, 60, 198, 23, 172, 186, 191, 94, 128, 234, 186, 17, 175, 133, 63, 183, 101, 181, 95, 198, 166, 182, 63, 251, 170, 27, 2, 30, 142, 160, 63, 168, 200, 152, 9, 141, 209, 175, 191, 86, 9, 155, 51, 8, 76, 114, 63, 12, 115, 216, 114, 243, 91, 173, 191, 29, 121, 8, 35, 128, 54, 189, 63, 248, 246, 187, 140, 115, 136, 160, 191, 150, 70, 94, 118, 22, 138, 189, 191, 159, 71, 23, 234, 238, 25, 156, 63, 92, 24, 204, 5, 6, 188, 170, 63, 73, 253, 6, 35, 155, 139, 143, 191, 253, 62, 232, 117, 169, 65, 187, 63, 26, 225, 129, 42, 196, 237, 148, 63, 34, 194, 88, 36, 63, 54, 109, 191, 204, 34, 57, 241, 64, 196, 150, 63, 197, 178, 106, 160, 210, 209, 190, 191, 251, 58, 160, 7, 55, 246, 198, 63, 45, 55, 134, 226, 244, 255, 193, 191, 72, 140, 97, 31, 156, 236, 184, 191, 210, 216, 175, 178, 31, 149, 167, 63, 132, 183, 62, 119, 127, 180, 161, 63, 77, 127, 121, 133, 237, 31, 171, 191, 199, 220, 170, 48, 185, 184, 162, 191, 154, 140, 12, 24, 71, 59, 144, 63, 90, 192, 21, 132, 45, 186, 160, 63, 24, 236, 168, 93, 20, 15, 134, 63, 68, 77, 238, 122, 238, 76, 198, 63, 185, 147, 37, 65, 48, 74, 168, 63, 31, 20, 107, 225, 145, 118, 192, 191, 49, 227, 32, 230, 195, 168, 178, 63, 141, 253, 76, 182, 85, 217, 176, 191, 212, 53, 145, 134, 120, 186, 186, 191, 217, 180, 246, 233, 49, 18, 157, 191, 61, 189, 236, 81, 62, 29, 159, 63, 70, 210, 31, 92, 130, 97, 190, 63, 161, 114, 195, 107, 229, 147, 181, 63, 51, 118, 43, 135, 115, 195, 173, 63, 164, 101, 73, 134, 229, 28, 163, 191, 93, 189, 142, 48, 253, 183, 144, 63, 124, 223, 193, 98, 253, 83, 178, 191, 162, 43, 145, 149, 61, 246, 194, 191, 58, 77, 47, 59, 100, 7, 153, 191, 159, 74, 41, 229, 128, 54, 179, 191, 166, 178, 153, 193, 77, 206, 178, 63, 124, 67, 146, 110, 244, 111, 154, 63, 83, 240, 153, 160, 164, 187, 140, 191, 21, 44, 79, 56, 202, 212, 162, 191, 220, 138, 21, 9, 196, 211, 188, 63, 218, 222, 25, 249, 12, 6, 193, 63, 11, 135, 191, 247, 60, 185, 159, 191, 32, 56, 43, 26, 168, 77, 173, 63, 18, 140, 93, 62, 134, 160, 189, 191, 41, 170, 97, 108, 179, 219, 176, 191, 192, 59, 64, 74, 119, 214, 105, 191, 26, 14, 101, 137, 89, 82, 81, 191, 175, 103, 147, 77, 212, 251, 168, 63, 97, 53, 78, 50, 191, 61, 169, 63, 163, 117, 249, 119, 30, 135, 190, 191, 183, 81, 193, 74, 105, 101, 178, 191, 13, 20, 190, 119, 149, 214, 184, 63, 212, 80, 42, 104, 29, 1, 162, 191, 76, 115, 219, 75, 240, 142, 186, 63, 106, 49, 116, 174, 212, 70, 186, 63, 219, 71, 158, 234, 127, 192, 135, 191, 183, 174, 118, 81, 91, 33, 126, 191, 7, 161, 89, 170, 76, 197, 168, 63, 126, 182, 219, 31, 161, 34, 163, 63, 47, 165, 3, 79, 171, 141, 157, 191, 191, 49, 205, 235, 145, 91, 196, 191, 83, 66, 20, 187, 82, 222, 195, 63, 54, 65, 139, 188, 25, 222, 173, 63, 0, 168, 83, 237, 226, 95, 177, 191, 18, 203, 215, 71, 136, 35, 153, 191, 151, 7, 164, 26, 18, 54, 173, 191, 138, 0, 172, 9, 111, 233, 194, 191, 232, 226, 159, 101, 38, 160, 170, 63, 88, 82, 221, 250, 178, 234, 109, 63, 119, 212, 21, 228, 13, 235, 142, 63, 40, 140, 111, 193, 255, 103, 178, 63, 169, 207, 66, 53, 106, 222, 183, 63, 62, 85, 49, 219, 219, 162, 179, 191, 183, 132, 234, 172, 204, 132, 157, 63, 56, 246, 133, 65, 98, 170, 169, 63, 216, 168, 180, 71, 250, 157, 191, 191, 127, 216, 62, 146, 219, 103, 124, 63, 190, 73, 13, 1, 34, 254, 166, 191, 142, 67, 130, 101, 0, 46, 179, 191, 220, 41, 249, 205, 243, 26, 174, 191, 229, 61, 133, 163, 246, 36, 181, 191, 82, 177, 114, 95, 142, 78, 179, 63, 39, 208, 173, 252, 129, 103, 177, 63, 232, 45, 219, 82, 253, 204, 158, 63, 95, 7, 113, 78, 44, 90, 191, 63, 180, 194, 37, 126, 89, 9, 174, 191, 170, 249, 174, 11, 54, 169, 174, 191, 186, 70, 140, 55, 239, 250, 184, 63, 113, 207, 18, 181, 180, 108, 176, 63, 193, 103, 245, 71, 38, 76, 162, 63, 166, 5, 203, 28, 69, 193, 181, 191, 178, 1, 203, 145, 197, 243, 140, 63, 231, 71, 168, 255, 224, 130, 183, 191, 172, 181, 82, 225, 4, 186, 188, 63, 9, 66, 108, 11, 223, 160, 160, 63, 138, 223, 164, 58, 212, 231, 137, 63, 66, 119, 131, 229, 148, 188, 188, 63, 13, 229, 162, 175, 247, 193, 183, 191, 100, 47, 43, 130, 61, 45, 156, 191, 216, 162, 32, 80, 228, 9, 191, 191, 239, 209, 182, 191, 113, 59, 172, 63, 48, 243, 187, 230, 77, 157, 151, 191, 12, 105, 102, 57, 108, 156, 139, 63, 31, 95, 173, 222, 50, 251, 187, 191, 17, 192, 37, 154, 231, 225, 166, 191, 172, 237, 90, 122, 218, 229, 175, 63, 118, 84, 120, 168, 166, 45, 180, 63, 208, 88, 6, 184, 145, 219, 185, 191, 86, 64, 251, 197, 132, 87, 192, 191, 144, 100, 80, 50, 238, 201, 181, 63, 154, 132, 83, 184, 135, 185, 167, 191, 210, 99, 133, 133, 133, 223, 187, 63, 218, 117, 57, 37, 91, 182, 145, 191, 151, 234, 202, 221, 81, 141, 185, 63, 74, 163, 36, 127, 185, 251, 149, 63, 218, 159, 135, 25, 104, 251, 183, 63, 185, 217, 206, 141, 83, 224, 187, 63, 241, 146, 18, 215, 203, 26, 175, 191, 149, 116, 96, 3, 105, 212, 163, 191, 204, 11, 69, 83, 15, 230, 178, 63, 158, 100, 194, 178, 22, 8, 165, 63, 7, 237, 65, 155, 222, 215, 189, 191, 214, 246, 17, 238, 206, 15, 160, 63, 123, 34, 151, 38, 156, 128, 158, 63, 213, 169, 224, 72, 105, 64, 183, 191, 120, 180, 88, 150, 110, 81, 192, 63, 217, 2, 220, 192, 216, 16, 176, 191, 179, 225, 107, 5, 76, 107, 123, 191, 17, 131, 109, 175, 212, 84, 128, 63, 238, 5, 138, 246, 19, 144, 176, 191, 85, 148, 136, 125, 189, 21, 191, 63, 94, 119, 103, 27, 164, 254, 186, 191, 34, 125, 107, 34, 204, 249, 183, 63, 211, 40, 133, 59, 143, 162, 135, 63, 148, 62, 66, 30, 172, 101, 132, 191, 17, 62, 56, 223, 239, 139, 95, 191, 159, 71, 212, 121, 243, 23, 149, 191, 116, 69, 138, 154, 212, 79, 187, 63, 187, 87, 79, 220, 63, 86, 195, 191, 8, 179, 186, 213, 140, 17, 177, 63, 104, 188, 50, 11, 184, 50, 189, 191, 215, 8, 66, 194, 71, 61, 156, 191, 228, 127, 220, 128, 10, 176, 153, 63, 193, 37, 254, 74, 32, 172, 129, 191, 124, 161, 107, 62, 169, 89, 131, 191, 43, 189, 112, 120, 219, 198, 150, 63, 214, 115, 218, 147, 119, 14, 160, 63, 236, 177, 98, 106, 127, 124, 193, 191, 223, 94, 190, 47, 100, 113, 196, 63, 52, 69, 128, 39, 141, 185, 148, 191, 214, 171, 63, 86, 100, 136, 185, 63, 196, 61, 121, 76, 4, 25, 166, 63, 7, 62, 57, 206, 85, 68, 170, 191, 19, 147, 31, 94, 80, 182, 124, 63, 161, 107, 102, 212, 33, 96, 125, 191, 7, 19, 243, 89, 125, 123, 175, 191, 90, 23, 41, 87, 19, 115, 164, 63, 66, 218, 50, 114, 240, 198, 152, 63, 203, 252, 75, 225, 94, 203, 197, 191, 127, 149, 235, 199, 110, 78, 197, 63, 124, 80, 131, 134, 240, 22, 191, 191, 95, 255, 153, 222, 74, 185, 104, 191, 178, 182, 168, 230, 90, 168, 185, 191, 187, 106, 83, 246, 1, 195, 172, 63, 113, 19, 253, 68, 101, 133, 149, 63, 152, 106, 123, 28, 108, 191, 113, 191, 168, 52, 42, 116, 59, 91, 151, 191, 190, 82, 19, 100, 189, 81, 160, 63, 235, 206, 77, 67, 63, 32, 178, 63, 133, 190, 240, 238, 74, 207, 179, 63, 137, 125, 29, 75, 192, 254, 166, 191, 34, 173, 200, 220, 234, 240, 181, 191, 238, 71, 199, 51, 225, 114, 191, 191, 154, 30, 104, 13, 193, 129, 174, 191, 1, 99, 89, 248, 114, 164, 166, 191, 99, 207, 25, 11, 129, 67, 176, 63, 217, 113, 109, 27, 97, 150, 143, 63, 13, 232, 37, 199, 124, 223, 184, 63, 167, 66, 15, 215, 37, 16, 189, 63, 238, 87, 163, 226, 221, 177, 148, 191, 138, 184, 191, 138, 167, 72, 177, 63, 39, 112, 160, 97, 42, 226, 152, 63, 112, 104, 231, 122, 215, 28, 135, 191, 251, 28, 102, 74, 31, 205, 175, 63, 94, 217, 8, 89, 33, 69, 156, 191, 224, 112, 248, 216, 191, 221, 186, 191, 43, 103, 249, 192, 249, 231, 113, 63, 108, 220, 170, 148, 244, 188, 177, 63, 202, 25, 165, 136, 253, 147, 144, 191, 237, 183, 41, 165, 50, 120, 180, 191, 198, 17, 51, 69, 90, 96, 105, 191, 214, 153, 200, 122, 96, 146, 178, 191, 144, 78, 10, 84, 89, 159, 186, 191, 236, 17, 11, 215, 81, 77, 162, 191, 29, 63, 118, 35, 98, 99, 163, 63, 108, 95, 247, 236, 196, 133, 147, 63, 143, 14, 14, 150, 158, 185, 189, 191, 44, 34, 16, 5, 242, 44, 168, 191, 45, 138, 203, 84, 122, 135, 179, 191, 176, 91, 1, 99, 137, 247, 165, 63, 105, 163, 24, 16, 217, 126, 135, 63, 43, 152, 153, 2, 92, 139, 139, 63, 70, 242, 30, 85, 48, 227, 195, 63, 142, 241, 91, 31, 65, 216, 188, 63, 236, 80, 154, 73, 9, 70, 208, 63, 188, 28, 245, 211, 188, 150, 135, 191, 108, 204, 224, 90, 245, 73, 157, 63, 110, 71, 174, 252, 60, 111, 199, 63, 44, 234, 172, 124, 38, 180, 118, 191, 93, 79, 255, 243, 98, 185, 184, 191, 128, 219, 144, 18, 58, 63, 176, 63, 66, 172, 43, 156, 73, 239, 178, 63, 27, 161, 200, 52, 16, 118, 176, 191, 128, 77, 179, 200, 91, 139, 56, 63, 200, 196, 49, 103, 204, 230, 136, 63, 65, 189, 210, 35, 39, 31, 184, 191, 164, 40, 5, 196, 114, 253, 168, 191, 114, 49, 181, 74, 112, 228, 178, 63, 14, 183, 170, 53, 128, 118, 82, 191, 164, 247, 63, 251, 246, 129, 152, 63, 29, 77, 1, 209, 0, 176, 191, 63, 211, 194, 34, 209, 224, 60, 139, 191, 106, 201, 116, 46, 193, 215, 87, 191, 48, 233, 106, 239, 228, 27, 177, 191, 10, 253, 152, 184, 78, 137, 173, 63, 135, 64, 60, 61, 242, 38, 193, 63, 2, 166, 181, 210, 188, 126, 130, 191, 56, 15, 239, 103, 48, 112, 62, 191, 6, 161, 127, 167, 84, 78, 105, 63, 77, 183, 217, 135, 247, 20, 173, 191, 97, 91, 248, 241, 148, 131, 182, 191, 47, 6, 190, 174, 63, 146, 178, 63, 240, 80, 121, 211, 203, 30, 195, 63, 81, 242, 161, 147, 105, 174, 144, 191, 242, 45, 143, 111, 77, 113, 122, 191, 176, 95, 210, 134, 178, 170, 111, 191, 71, 205, 128, 128, 163, 20, 124, 63, 138, 249, 208, 107, 38, 124, 164, 63, 57, 205, 197, 155, 40, 161, 188, 191, 227, 149, 149, 126, 8, 42, 180, 191, 242, 58, 236, 73, 178, 9, 183, 63, 73, 171, 146, 151, 194, 193, 194, 63, 112, 1, 51, 87, 70, 211, 118, 191, 159, 118, 160, 30, 43, 142, 141, 191, 30, 63, 23, 24, 53, 63, 129, 191, 252, 182, 238, 254, 59, 79, 129, 191, 96, 15, 29, 45, 211, 13, 62, 63, 191, 254, 82, 101, 66, 12, 186, 63, 57, 177, 53, 29, 42, 189, 160, 63, 160, 189, 150, 158, 87, 154, 191, 191, 223, 113, 54, 197, 95, 187, 179, 191, 118, 196, 150, 181, 48, 172, 185, 63, 178, 156, 173, 177, 6, 72, 195, 63, 192, 128, 125, 234, 191, 191, 168, 191, 176, 176, 26, 165, 8, 125, 192, 63, 130, 244, 99, 90, 105, 11, 160, 191, 32, 12, 192, 240, 174, 107, 135, 63, 240, 79, 168, 231, 69, 112, 139, 63, 219, 182, 236, 184, 1, 88, 182, 63, 98, 209, 25, 126, 158, 98, 179, 191, 125, 158, 23, 100, 208, 30, 184, 63, 186, 255, 26, 215, 240, 254, 170, 63, 44, 25, 206, 223, 170, 68, 168, 191, 134, 72, 112, 18, 32, 90, 203, 191, 183, 25, 109, 206, 98, 21, 188, 63, 172, 26, 59, 116, 248, 22, 189, 63, 230, 215, 137, 145, 75, 128, 178, 63, 231, 157, 136, 116, 195, 18, 177, 63, 117, 83, 152, 10, 117, 143, 186, 191, 193, 205, 200, 212, 42, 188, 155, 191, 174, 36, 233, 126, 104, 30, 167, 191, 39, 27, 81, 185, 104, 170, 189, 191, 98, 139, 36, 20, 140, 100, 181, 63, 140, 119, 136, 91, 122, 187, 169, 63, 208, 181, 153, 206, 77, 123, 156, 191, 202, 65, 72, 242, 104, 232, 99, 191, 183, 70, 32, 96, 142, 25, 182, 63, 98, 115, 195, 37, 50, 91, 194, 63, 194, 202, 78, 37, 108, 26, 161, 191, 168, 214, 42, 57, 179, 92, 176, 191, 72, 113, 186, 2, 16, 56, 176, 63, 70, 141, 143, 172, 219, 43, 154, 63, 200, 194, 77, 102, 4, 216, 150, 63, 67, 97, 135, 188, 216, 75, 148, 63, 169, 214, 170, 166, 158, 59, 187, 191, 88, 61, 88, 143, 159, 159, 191, 191, 71, 35, 141, 0, 141, 79, 163, 191, 138, 168, 120, 185, 132, 104, 167, 63, 92, 70, 4, 135, 69, 193, 185, 191, 241, 231, 50, 141, 202, 204, 178, 191, 8, 237, 42, 151, 93, 105, 67, 63, 68, 38, 250, 46, 222, 66, 59, 191, 242, 116, 35, 14, 195, 254, 175, 191, 144, 192, 106, 56, 96, 3, 161, 191, 62, 217, 219, 181, 11, 172, 191, 63, 208, 236, 237, 160, 8, 151, 174, 63, 204, 198, 193, 2, 252, 136, 177, 63, 240, 178, 90, 112, 185, 87, 141, 191, 76, 108, 20, 211, 6, 29, 185, 63, 176, 123, 104, 197, 101, 226, 186, 63, 214, 47, 95, 113, 207, 236, 113, 63, 63, 147, 240, 12, 208, 75, 134, 191, 32, 1, 111, 48, 97, 204, 187, 63, 101, 198, 234, 13, 94, 187, 158, 63, 233, 174, 116, 145, 255, 150, 177, 63, 160, 154, 90, 149, 22, 52, 198, 63, 7, 233, 42, 141, 2, 94, 192, 191, 96, 190, 0, 20, 189, 35, 90, 191, 43, 229, 161, 240, 102, 215, 157, 191, 231, 10, 166, 67, 83, 101, 157, 191, 170, 222, 60, 141, 148, 161, 199, 191, 172, 68, 249, 98, 100, 248, 192, 191, 19, 85, 46, 55, 125, 48, 162, 191, 230, 106, 95, 166, 250, 108, 164, 63, 146, 124, 56, 226, 30, 169, 122, 191, 210, 2, 38, 30, 88, 201, 178, 63, 159, 55, 176, 64, 18, 9, 185, 191, 232, 62, 121, 183, 44, 9, 181, 63, 254, 8, 154, 111, 83, 154, 148, 63, 95, 253, 43, 46, 86, 16, 161, 191, 54, 31, 32, 24, 153, 232, 193, 191, 172, 128, 54, 52, 197, 119, 131, 63, 215, 197, 123, 31, 32, 119, 162, 63, 246, 48, 18, 73, 223, 126, 179, 191, 20, 129, 164, 137, 187, 50, 171, 63, 9, 200, 242, 214, 67, 201, 177, 191, 211, 109, 175, 58, 151, 186, 181, 191, 108, 203, 223, 143, 218, 254, 176, 191, 88, 255, 227, 61, 105, 200, 142, 63, 157, 221, 30, 113, 150, 153, 192, 191, 197, 64, 77, 181, 156, 185, 168, 191, 239, 200, 0, 14, 77, 226, 168, 63, 247, 102, 83, 63, 60, 180, 186, 63, 147, 34, 56, 205, 213, 179, 172, 191, 5, 144, 222, 242, 21, 56, 154, 63, 32, 4, 112, 1, 86, 161, 182, 191, 174, 211, 201, 201, 86, 4, 103, 191, 202, 239, 246, 250, 62, 156, 192, 191, 252, 237, 182, 196, 160, 29, 184, 191, 43, 86, 210, 64, 254, 159, 162, 63, 190, 85, 182, 97, 227, 82, 154, 191, 222, 75, 20, 21, 231, 231, 184, 63, 90, 221, 77, 166, 225, 232, 188, 63, 226, 105, 98, 163, 224, 162, 116, 191, 146, 42, 120, 53, 200, 158, 187, 63, 55, 34, 94, 22, 96, 14, 167, 191, 7, 7, 155, 176, 118, 91, 154, 191, 37, 229, 28, 130, 218, 226, 168, 191, 124, 31, 145, 193, 6, 156, 186, 191, 232, 243, 109, 116, 192, 143, 179, 63, 156, 0, 239, 237, 65, 138, 164, 63, 137, 119, 113, 14, 142, 238, 179, 63, 128, 19, 191, 53, 7, 107, 194, 191, 143, 237, 63, 195, 125, 20, 193, 63, 255, 86, 49, 178, 51, 147, 144, 63, 62, 75, 146, 82, 149, 35, 180, 63, 231, 55, 157, 48, 76, 110, 176, 63, 42, 130, 49, 149, 133, 20, 185, 63, 74, 111, 89, 241, 244, 139, 175, 191, 160, 192, 184, 28, 121, 255, 88, 191, 142, 182, 199, 80, 158, 246, 187, 191, 242, 168, 52, 67, 154, 240, 200, 63, 99, 121, 90, 38, 167, 155, 143, 63, 186, 135, 153, 168, 102, 9, 157, 191, 178, 21, 103, 100, 213, 26, 179, 63, 227, 231, 89, 147, 243, 150, 174, 63, 247, 91, 215, 37, 109, 67, 144, 63, 241, 236, 118, 85, 205, 57, 189, 191, 118, 204, 92, 216, 51, 198, 189, 191, 216, 202, 213, 248, 234, 77, 135, 63, 205, 218, 143, 192, 147, 34, 181, 191, 213, 51, 48, 251, 48, 38, 152, 191, 55, 143, 248, 245, 254, 40, 179, 63, 56, 234, 73, 142, 2, 137, 195, 63, 178, 231, 70, 185, 187, 224, 162, 191, 196, 140, 58, 212, 220, 221, 171, 191, 185, 80, 88, 34, 133, 223, 153, 191, 173, 224, 167, 208, 10, 232, 186, 63, 232, 68, 80, 3, 180, 174, 146, 63, 244, 35, 0, 217, 244, 209, 137, 191, 176, 131, 103, 227, 121, 170, 195, 191, 107, 54, 65, 101, 27, 231, 167, 63, 33, 30, 82, 242, 32, 221, 184, 63, 168, 63, 136, 3, 214, 137, 154, 191, 250, 166, 49, 107, 45, 55, 180, 63, 143, 102, 174, 86, 50, 214, 167, 63, 132, 114, 142, 76, 78, 85, 177, 191, 145, 46, 40, 211, 101, 58, 115, 191, 176, 122, 58, 234, 213, 36, 177, 191, 79, 150, 44, 0, 217, 48, 188, 63, 138, 146, 81, 52, 10, 242, 165, 191, 193, 29, 206, 145, 208, 20, 191, 191, 168, 131, 153, 18, 69, 20, 176, 63, 52, 74, 209, 191, 49, 51, 167, 63, 24, 118, 139, 117, 47, 213, 173, 63, 131, 6, 164, 46, 83, 149, 187, 191, 6, 110, 144, 229, 232, 121, 152, 191, 31, 161, 81, 101, 95, 42, 150, 63, 102, 218, 0, 230, 97, 143, 163, 191, 29, 119, 189, 132, 114, 193, 192, 63, 145, 209, 193, 25, 255, 125, 186, 191, 218, 237, 166, 115, 142, 125, 184, 63, 13, 49, 204, 204, 162, 168, 178, 63, 211, 64, 253, 85, 19, 71, 198, 191, 254, 15, 21, 241, 22, 66, 151, 63, 223, 223, 0, 219, 228, 195, 185, 63, 126, 160, 37, 107, 129, 240, 179, 191, 98, 33, 230, 114, 25, 115, 183, 191, 187, 244, 10, 119, 185, 67, 193, 63, 52, 187, 199, 64, 187, 40, 122, 63, 46, 42, 159, 215, 133, 135, 168, 191, 8, 140, 137, 111, 26, 131, 159, 63, 184, 190, 255, 204, 30, 76, 176, 191, 208, 180, 104, 39, 237, 123, 178, 63, 220, 213, 10, 41, 96, 140, 173, 191, 22, 28, 138, 70, 25, 35, 176, 63, 173, 52, 102, 68, 207, 233, 182, 63, 0, 104, 30, 141, 21, 21, 183, 191, 61, 170, 153, 167, 168, 104, 178, 191, 196, 80, 117, 167, 28, 91, 147, 191, 83, 166, 55, 84, 133, 175, 186, 63, 160, 239, 163, 5, 98, 21, 166, 63, 4, 170, 65, 62, 4, 153, 182, 191, 106, 164, 158, 70, 91, 133, 191, 191, 148, 165, 102, 236, 6, 131, 135, 191, 183, 124, 26, 180, 177, 71, 181, 191, 24, 192, 189, 154, 0, 242, 148, 63, 185, 181, 228, 5, 23, 136, 170, 63, 254, 184, 155, 70, 231, 7, 135, 191, 128, 178, 172, 129, 35, 234, 176, 191, 104, 52, 240, 177, 71, 81, 194, 191, 108, 243, 57, 41, 158, 100, 177, 191, 229, 23, 217, 24, 222, 6, 176, 63, 176, 158, 121, 147, 190, 89, 174, 191, 191, 143, 198, 203, 58, 164, 181, 191, 247, 210, 134, 122, 90, 223, 148, 63, 90, 135, 208, 138, 64, 246, 162, 191, 25, 105, 29, 165, 117, 228, 174, 191, 167, 191, 216, 60, 215, 220, 163, 191, 197, 165, 74, 149, 173, 124, 188, 191, 218, 247, 229, 103, 214, 23, 190, 191, 231, 182, 243, 238, 55, 214, 170, 63, 83, 199, 162, 98, 159, 129, 179, 63, 72, 194, 80, 7, 173, 185, 147, 63, 191, 158, 137, 168, 27, 120, 190, 191, 6, 153, 6, 33, 98, 31, 166, 191, 227, 110, 200, 164, 24, 231, 161, 191, 75, 119, 78, 238, 230, 133, 184, 191, 40, 228, 120, 51, 95, 24, 176, 191, 205, 75, 1, 151, 65, 164, 195, 191, 37, 96, 127, 119, 71, 65, 162, 191, 47, 28, 90, 34, 212, 234, 159, 191, 162, 128, 144, 22, 88, 112, 161, 63, 32, 114, 250, 4, 58, 114, 194, 63, 227, 46, 207, 58, 89, 168, 187, 63, 95, 2, 52, 122, 4, 168, 171, 63, 40, 132, 18, 187, 221, 3, 163, 191, 40, 137, 224, 82, 250, 134, 169, 191, 115, 139, 125, 172, 250, 116, 166, 191, 125, 128, 104, 64, 40, 10, 196, 191, 130, 71, 90, 84, 68, 62, 194, 191, 95, 2, 60, 27, 239, 221, 169, 191, 197, 14, 195, 177, 131, 85, 179, 63, 224, 172, 179, 238, 189, 231, 176, 63, 243, 208, 31, 52, 106, 76, 188, 63, 60, 193, 156, 203, 254, 118, 148, 191, 218, 48, 154, 215, 58, 239, 147, 191, 55, 143, 237, 73, 65, 224, 192, 63, 128, 205, 87, 152, 69, 168, 183, 63, 86, 216, 208, 17, 113, 27, 164, 191, 193, 46, 87, 230, 243, 79, 160, 191, 124, 140, 210, 51, 116, 119, 144, 191, 62, 215, 86, 170, 216, 146, 171, 191, 157, 87, 113, 169, 238, 45, 197, 63, 170, 38, 14, 2, 23, 70, 170, 63, 177, 147, 167, 5, 243, 62, 166, 191, 105, 96, 207, 217, 69, 55, 180, 191, 136, 219, 40, 123, 34, 40, 147, 63, 103, 212, 200, 190, 104, 74, 139, 63, 49, 135, 36, 239, 0, 192, 165, 191, 109, 94, 59, 49, 206, 223, 180, 191, 226, 231, 157, 209, 192, 2, 196, 63, 12, 229, 111, 202, 168, 210, 96, 191, 72, 134, 203, 125, 165, 189, 163, 191, 145, 29, 244, 196, 238, 125, 190, 191, 195, 0, 36, 106, 131, 247, 167, 63, 226, 238, 20, 4, 89, 52, 115, 63, 84, 39, 104, 20, 196, 3, 102, 191, 44, 156, 65, 126, 82, 64, 160, 63, 185, 116, 220, 55, 248, 248, 177, 191, 126, 237, 226, 244, 231, 49, 185, 191, 25, 203, 159, 25, 178, 84, 188, 63, 129, 160, 151, 242, 20, 208, 175, 191, 79, 188, 233, 235, 230, 225, 128, 191, 7, 42, 249, 52, 133, 87, 195, 191, 220, 12, 50, 223, 28, 187, 177, 63, 44, 11, 170, 127, 98, 96, 144, 63, 177, 17, 189, 0, 239, 42, 146, 191, 144, 148, 81, 71, 194, 86, 188, 191, 11, 98, 182, 26, 193, 197, 171, 63, 36, 156, 63, 157, 125, 15, 121, 191, 80, 191, 145, 68, 184, 128, 165, 191, 17, 111, 177, 8, 248, 205, 176, 191, 56, 11, 140, 52, 70, 99, 184, 63, 102, 137, 25, 108, 225, 50, 188, 191, 24, 175, 169, 40, 104, 123, 177, 63, 152, 127, 175, 185, 67, 92, 196, 191, 88, 113, 1, 238, 247, 91, 191, 63, 156, 108, 65, 184, 70, 233, 154, 63, 157, 160, 185, 91, 233, 139, 144, 191, 110, 81, 157, 55, 154, 90, 97, 191, 91, 64, 215, 48, 247, 30, 178, 63, 145, 202, 125, 178, 253, 120, 151, 191, 111, 141, 135, 157, 14, 202, 189, 191, 77, 107, 105, 145, 19, 137, 154, 63, 98, 77, 105, 91, 214, 143, 151, 191, 110, 28, 34, 168, 245, 210, 170, 63, 37, 157, 156, 59, 232, 52, 193, 63, 161, 52, 146, 9, 150, 105, 172, 191, 76, 3, 49, 84, 40, 66, 80, 63, 20, 157, 150, 42, 85, 137, 112, 191, 124, 50, 150, 216, 12, 119, 166, 63, 92, 106, 22, 141, 218, 153, 178, 191, 253, 21, 156, 115, 122, 8, 193, 191, 59, 142, 252, 202, 237, 254, 181, 63, 30, 2, 9, 194, 185, 128, 129, 191, 203, 68, 180, 213, 117, 213, 117, 191, 42, 79, 201, 16, 209, 247, 101, 63, 107, 94, 55, 31, 180, 45, 138, 63, 77, 123, 1, 254, 254, 132, 174, 191, 251, 118, 198, 103, 147, 144, 187, 63, 59, 117, 222, 86, 35, 96, 189, 63, 100, 241, 218, 15, 121, 37, 188, 191, 121, 79, 242, 167, 253, 3, 137, 63, 240, 147, 25, 90, 132, 70, 71, 63, 70, 168, 231, 255, 240, 37, 98, 191, 120, 249, 2, 150, 87, 118, 124, 63, 13, 147, 219, 56, 43, 168, 144, 191, 23, 145, 239, 234, 135, 222, 150, 191, 123, 71, 40, 110, 57, 76, 182, 63, 120, 87, 255, 72, 129, 118, 192, 191, 63, 235, 150, 233, 50, 151, 185, 191, 161, 248, 1, 170, 117, 132, 192, 63, 200, 178, 130, 211, 129, 214, 94, 63, 186, 109, 156, 130, 144, 19, 154, 191, 99, 113, 102, 5, 240, 45, 117, 191, 138, 179, 41, 191, 131, 3, 112, 63, 24, 80, 57, 83, 97, 218, 155, 63, 124, 219, 177, 53, 226, 24, 180, 63, 223, 194, 247, 128, 12, 1, 156, 191, 162, 249, 177, 249, 254, 249, 188, 63, 225, 201, 92, 182, 205, 48, 191, 191, 184, 71, 91, 55, 229, 49, 203, 63, 227, 80, 92, 64, 119, 19, 168, 63, 98, 109, 156, 105, 40, 250, 194, 191, 237, 52, 150, 250, 226, 79, 180, 191, 238, 179, 41, 30, 94, 223, 162, 63, 170, 123, 164, 203, 243, 169, 195, 191, 148, 81, 108, 2, 9, 169, 181, 63, 150, 129, 89, 177, 195, 176, 114, 191, 7, 71, 27, 156, 111, 228, 178, 63, 218, 104, 15, 2, 213, 171, 173, 191, 132, 118, 29, 229, 72, 220, 187, 63, 81, 167, 162, 29, 7, 245, 154, 191, 239, 210, 89, 32, 145, 101, 159, 63, 83, 119, 117, 6, 76, 53, 186, 191, 145, 87, 161, 3, 91, 220, 186, 63, 81, 150, 203, 220, 84, 208, 172, 191, 179, 124, 201, 162, 232, 171, 146, 191, 63, 26, 170, 62, 148, 202, 116, 63, 98, 170, 62, 39, 161, 122, 176, 63, 155, 190, 113, 209, 162, 225, 194, 191, 201, 67, 47, 33, 233, 6, 178, 63, 167, 130, 160, 52, 185, 148, 177, 191, 192, 30, 198, 194, 121, 104, 169, 191, 48, 181, 179, 216, 116, 68, 152, 63, 146, 46, 31, 10, 98, 63, 135, 191, 165, 111, 29, 15, 76, 44, 137, 63, 154, 41, 170, 220, 9, 63, 183, 63, 41, 57, 219, 142, 97, 23, 197, 191, 14, 188, 185, 223, 147, 201, 145, 63, 20, 59, 190, 5, 71, 250, 181, 191, 78, 104, 141, 143, 100, 17, 178, 191, 49, 54, 9, 254, 91, 245, 165, 63, 182, 55, 50, 83, 130, 177, 130, 191, 144, 90, 144, 146, 160, 71, 107, 191, 188, 83, 150, 128, 19, 62, 162, 191, 14, 114, 248, 82, 119, 217, 148, 63, 98, 70, 129, 21, 65, 127, 189, 63, 94, 31, 168, 185, 192, 102, 195, 191, 111, 183, 204, 231, 57, 234, 172, 191, 213, 124, 77, 120, 248, 228, 181, 191, 18, 80, 1, 77, 191, 69, 188, 191, 216, 221, 166, 84, 237, 55, 178, 63, 86, 4, 218, 133, 91, 178, 100, 191, 183, 20, 143, 5, 152, 54, 111, 191, 224, 254, 81, 131, 34, 118, 197, 191, 78, 138, 251, 236, 206, 219, 163, 63, 58, 149, 208, 215, 253, 123, 180, 191, 85, 44, 69, 134, 27, 45, 192, 63, 116, 120, 218, 71, 166, 167, 177, 63, 32, 135, 238, 181, 184, 227, 98, 63, 129, 95, 19, 18, 160, 116, 195, 191, 81, 127, 18, 1, 127, 96, 159, 63, 25, 70, 6, 7, 128, 196, 187, 191, 54, 154, 240, 85, 70, 131, 193, 63, 24, 205, 24, 87, 186, 164, 180, 191, 59, 201, 174, 200, 67, 212, 109, 191, 232, 23, 226, 29, 246, 139, 145, 191, 159, 122, 2, 169, 196, 168, 178, 63, 10, 181, 30, 67, 154, 66, 27, 63, 221, 11, 70, 77, 183, 107, 191, 191, 46, 222, 247, 241, 111, 246, 159, 191, 191, 106, 121, 33, 218, 54, 130, 63, 220, 191, 207, 69, 162, 0, 73, 191, 133, 33, 164, 78, 238, 35, 195, 63, 159, 11, 94, 222, 64, 223, 176, 63, 66, 72, 226, 158, 187, 138, 132, 63, 52, 52, 210, 222, 239, 42, 114, 191, 242, 136, 101, 20, 65, 21, 135, 191, 15, 170, 123, 110, 130, 158, 113, 63, 217, 70, 218, 250, 108, 94, 197, 191, 41, 201, 167, 253, 195, 49, 187, 191, 121, 200, 194, 48, 186, 7, 146, 191, 7, 247, 147, 159, 197, 70, 74, 63, 3, 128, 237, 156, 175, 9, 117, 191, 138, 111, 233, 44, 44, 43, 116, 63, 240, 142, 87, 75, 28, 206, 107, 191, 183, 135, 66, 25, 32, 24, 137, 191, 46, 154, 3, 180, 200, 93, 197, 63, 250, 13, 107, 38, 151, 180, 195, 63, 231, 199, 228, 44, 26, 17, 166, 63, 107, 66, 88, 98, 219, 43, 144, 63, 98, 140, 218, 158, 125, 59, 106, 63, 88, 116, 195, 203, 239, 165, 80, 63, 136, 115, 163, 112, 80, 59, 113, 63, 252, 217, 46, 223, 6, 94, 111, 191, 174, 112, 52, 246, 207, 13, 129, 191, 50, 156, 214, 142, 181, 62, 146, 63, 187, 66, 132, 198, 156, 184, 193, 191, 90, 33, 45, 42, 73, 21, 199, 191, 12, 160, 246, 124, 84, 69, 176, 191, 164, 71, 161, 4, 42, 253, 120, 191, 139, 84, 176, 17, 81, 170, 136, 63, 0, 239, 251, 149, 103, 19, 93, 63, 100, 1, 59, 63, 130, 99, 171, 191, 233, 174, 78, 168, 247, 40, 182, 191, 110, 94, 191, 233, 181, 111, 144, 191, 71, 209, 61, 5, 181, 136, 146, 63, 146, 220, 171, 22, 64, 126, 135, 191, 226, 168, 56, 219, 88, 159, 185, 191, 195, 139, 136, 59, 202, 43, 173, 63, 90, 10, 206, 70, 233, 54, 203, 63, 105, 83, 144, 253, 129, 109, 184, 63, 127, 117, 105, 164, 89, 186, 173, 63, 210, 151, 87, 184, 164, 71, 180, 63, 158, 254, 46, 60, 3, 3, 167, 191, 81, 102, 96, 150, 91, 114, 145, 191, 7, 68, 66, 255, 148, 112, 178, 63, 128, 156, 147, 254, 114, 221, 65, 191, 162, 67, 201, 55, 61, 4, 164, 191, 142, 24, 51, 131, 90, 231, 189, 63, 234, 134, 37, 65, 120, 251, 115, 63, 208, 53, 91, 175, 113, 25, 121, 191, 111, 105, 211, 191, 226, 234, 173, 191, 218, 189, 205, 115, 52, 67, 181, 191, 21, 234, 119, 207, 203, 102, 192, 63, 32, 54, 96, 251, 247, 241, 95, 191, 116, 124, 30, 183, 249, 216, 83, 191, 48, 93, 183, 213, 213, 198, 109, 63, 42, 93, 4, 97, 98, 198, 180, 63, 206, 144, 210, 234, 78, 47, 172, 191, 140, 143, 23, 238, 180, 73, 188, 191, 162, 29, 67, 86, 195, 226, 192, 63, 112, 253, 83, 79, 226, 183, 115, 191, 128, 239, 168, 254, 109, 205, 69, 191, 32, 130, 182, 209, 86, 220, 127, 63, 128, 175, 57, 82, 217, 20, 96, 191, 176, 145, 75, 86, 253, 34, 128, 63, 20, 38, 112, 100, 31, 245, 192, 63, 144, 167, 57, 215, 104, 248, 161, 191, 14, 162, 106, 65, 186, 142, 193, 191, 8, 89, 147, 27, 96, 241, 192, 63, 143, 118, 4, 229, 59, 133, 137, 191, 152, 252, 55, 152, 245, 81, 140, 63, 120, 77, 20, 16, 255, 170, 112, 63, 140, 157, 205, 177, 53, 15, 128, 63, 0, 142, 95, 159, 86, 140, 89, 63, 42, 62, 1, 53, 5, 216, 188, 191, 172, 61, 140, 174, 188, 7, 160, 191, 4, 82, 183, 87, 244, 16, 194, 63, 144, 144, 94, 123, 28, 105, 130, 191, 98, 244, 55, 47, 103, 159, 195, 191, 214, 117, 161, 247, 243, 254, 191, 63, 6, 161, 197, 231, 212, 84, 182, 191, 128, 218, 56, 149, 154, 185, 62, 63, 252, 147, 29, 110, 211, 166, 171, 63, 116, 129, 57, 71, 77, 36, 169, 191, 222, 163, 93, 255, 93, 168, 146, 63, 167, 107, 9, 22, 120, 131, 154, 191, 28, 42, 205, 195, 128, 148, 178, 63, 53, 203, 166, 84, 221, 91, 190, 191, 164, 15, 29, 80, 18, 221, 162, 191, 19, 122, 137, 168, 174, 161, 170, 63, 182, 68, 67, 241, 15, 239, 149, 63, 146, 71, 55, 151, 68, 244, 194, 191, 66, 46, 29, 252, 98, 243, 179, 63}};

double TabulatedValues::m_cdN3DCorrectionInverseFactor = 1.0/sqrt(4.0*static_cast<double>(OWN_PI));
double TabulatedValues::m_cdN3DCorrectionFactor        = sqrt(4.0*static_cast<double>(OWN_PI));

unsigned char TabulatedValues::ucWeightingCdbk256x8[8192] = {37,73,18,62,37,73,18,62,37,73,18,62,37,73,18,62,37,73,18,62,37,73,18,62,37,73,18,62,37,73,18,62,229,122,75,63,186,23,236,62,214,194,195,62,242,189,119,62,25,152,91,62,37,73,29,62,26,49,19,62,121,38,9,62,193,244,14,63,81,217,155,62,49,87,148,62,182,85,141,62,251,23,136,62,231,149,131,62,140,229,100,62,231,52,95,62,103,15,77,63,174,167,144,62,255,245,132,62,59,166,122,62,108,242,101,62,232,20,91,62,140,100,79,62,140,120,68,62,117,80,194,62,232,178,182,62,148,142,156,62,194,48,148,62,9,157,140,62,198,116,135,62,197,128,131,62,146,204,127,62,136,71,21,63,37,177,253,62,10,173,213,62,202,117,188,62,225,22,45,62,50,201,17,62,60,37,4,62,166,228,235,61,177,238,251,62,222,3,228,62,136,32,220,62,153,215,131,62,195,33,122,62,251,154,107,62,244,103,89,62,79,57,83,62,121,89,4,63,40,130,246,62,39,96,156,62,18,20,142,62,107,212,122,62,12,251,108,62,73,60,94,62,144,145,84,62,120,138,213,62,130,155,152,62,72,47,139,62,207,87,132,62,170,91,128,62,245,93,120,62,138,122,114,62,121,9,110,62,96,174,71,63,237,6,27,63,236,247,72,62,26,44,51,62,19,221,42,62,126,43,33,62,215,232,25,62,90,111,6,62,39,64,7,63,77,1,180,62,25,162,163,62,126,35,145,62,74,215,131,62,241,244,118,62,75,168,105,62,120,73,95,62,237,151,32,63,68,210,208,62,238,106,189,62,100,255,165,62,40,37,145,62,87,61,68,62,37,34,45,62,105,239,13,62,179,88,183,62,71,102,180,62,138,158,178,62,191,244,174,62,253,237,172,62,42,16,126,62,93,164,114,62,13,134,105,62,18,77,39,63,224,30,28,63,158,110,19,63,33,18,129,62,119,220,10,62,150,194,218,61,116,108,186,61,146,58,157,61,213,63,212,62,126,153,201,62,217,1,188,62,68,46,179,62,45,123,138,62,227,168,130,62,62,36,120,62,169,238,105,62,105,6,12,63,73,97,249,62,29,105,193,62,115,105,176,62,230,214,166,62,36,205,152,62,39,194,0,62,202,12,192,61,101,68,173,62,199,206,155,62,197,205,147,62,19,38,143,62,31,87,138,62,107,8,133,62,108,159,129,62,89,207,125,62,200,42,63,63,149,206,0,63,224,48,224,62,22,147,150,62,224,185,83,62,171,203,13,62,130,178,5,62,237,170,244,61,175,54,229,62,240,152,177,62,160,64,162,62,169,79,151,62,131,166,142,62,207,48,136,62,214,113,130,62,172,220,122,62,79,149,25,63,79,32,226,62,125,81,143,62,103,114,135,62,45,63,127,62,61,45,114,62,252,218,99,62,92,67,79,62,236,247,224,62,172,230,203,62,190,7,157,62,122,78,145,62,223,164,136,62,132,91,130,62,177,126,120,62,13,38,113,62,109,11,56,63,91,186,17,63,117,131,228,62,83,37,195,62,247,133,15,62,166,184,230,61,59,211,194,61,83,226,165,61,245,56,247,62,162,227,211,62,130,201,197,62,73,190,182,62,34,85,137,62,129,114,116,62,30,119,102,62,58,5,87,62,113,244,8,63,94,80,246,62,117,68,197,62,78,115,161,62,186,104,145,62,98,107,107,62,131,219,48,62,42,187,23,62,134,202,180,62,218,148,171,62,214,56,165,62,61,177,155,62,136,83,144,62,135,41,137,62,145,159,131,62,241,172,126,62,221,230,44,63,218,185,36,63,165,8,207,62,35,12,117,62,195,74,70,62,23,43,34,62,50,81,13,62,240,147,253,61,205,217,16,63,188,160,214,62,143,190,193,62,105,85,178,62,244,53,131,62,187,160,104,62,120,97,89,62,255,158,72,62,175,11,62,63,68,156,238,62,202,107,217,62,105,6,170,62,26,9,145,62,1,220,122,62,78,82,1,62,0,161,189,61,43,228,202,62,171,225,194,62,64,197,188,62,204,183,167,62,92,66,161,62,128,220,152,62,254,137,142,62,255,93,133,62,158,194,24,63,84,91,249,62,232,107,240,62,162,18,82,62,248,228,75,62,87,224,58,62,157,21,54,62,79,19,52,62,6,177,204,62,19,116,200,62,16,146,193,62,56,69,180,62,70,27,163,62,222,233,155,62,223,122,97,62,25,168,88,62,46,201,248,62,18,69,229,62,59,113,208,62,228,61,190,62,42,238,121,62,217,2,93,62,204,193,72,62,77,215,57,62,122,73,128,62,66,139,124,62,193,104,121,62,20,8,117,62,41,213,114,62,128,106,111,62,206,148,107,62,40,178,104,62,240,100,76,63,241,200,216,62,41,60,129,62,46,40,114,62,213,174,87,62,149,159,72,62,193,96,55,62,243,240,43,62,4,3,21,63,235,157,183,62,51,248,169,62,123,40,161,62,137,86,153,62,225,251,141,62,154,83,132,62,213,8,115,62,186,27,41,63,253,40,204,62,125,13,193,62,88,159,128,62,26,174,119,62,191,170,107,62,109,24,103,62,64,236,87,62,29,159,219,62,156,4,193,62,106,82,175,62,32,50,162,62,55,246,147,62,146,252,136,62,187,85,130,62,144,25,121,62,178,66,2,63,52,188,254,62,98,184,220,62,209,159,212,62,190,85,83,62,185,98,74,62,20,134,40,62,151,76,30,62,206,169,231,62,110,90,216,62,36,193,200,62,95,27,152,62,38,95,139,62,10,90,131,62,154,34,118,62,70,245,105,62,169,156,250,62,151,215,232,62,157,74,159,62,185,152,148,62,9,65,138,62,116,224,130,62,148,178,122,62,73,83,110,62,32,3,204,62,15,157,173,62,173,182,163,62,89,161,154,62,182,56,147,62,199,168,141,62,184,30,136,62,147,81,131,62,4,119,22,63,150,123,13,63,103,192,157,62,208,139,138,62,16,84,106,62,235,105,72,62,8,255,49,62,208,0,34,62,197,208,0,63,112,8,192,62,71,197,181,62,178,50,174,62,87,186,163,62,55,75,118,62,33,228,101,62,144,77,90,62,5,61,37,63,136,234,226,62,228,130,198,62,71,115,165,62,113,12,115,62,40,24,95,62,225,248,73,62,175,185,56,62,229,221,204,62,119,91,177,62,2,252,171,62,140,173,167,62,250,120,160,62,30,174,155,62,143,71,149,62,229,222,119,62,87,168,35,63,159,0,19,63,13,206,6,63,170,180,79,62,167,124,53,62,75,201,33,62,143,231,22,62,215,81,15,62,85,130,215,62,28,107,198,62,180,5,185,62,151,165,174,62,183,154,165,62,138,23,134,62,111,4,124,62,193,139,109,62,149,39,1,63,49,10,226,62,132,70,191,62,149,30,178,62,117,58,161,62,71,107,143,62,174,157,76,62,175,45,35,62,238,84,172,62,210,69,167,62,13,234,162,62,132,121,158,62,50,112,153,62,255,186,146,62,239,30,138,62,143,156,131,62,174,200,64,63,41,215,239,62,113,253,214,62,94,4,189,62,236,239,71,62,99,210,42,62,62,148,17,62,47,22,249,61,37,178,244,62,11,158,190,62,38,145,179,62,28,37,169,62,168,149,157,62,179,43,144,62,213,139,123,62,161,237,99,62,220,222,30,63,39,100,175,62,185,215,156,62,46,49,141,62,228,2,134,62,102,19,122,62,164,7,111,62,13,67,99,62,55,232,233,62,15,117,223,62,16,206,177,62,38,191,163,62,212,70,139,62,70,1,130,62,199,190,115,62,129,135,101,62,50,78,21,63,148,220,10,63,249,251,218,62,243,6,195,62,188,222,133,62,235,244,92,62,140,202,59,62,7,82,40,62,228,110,248,62,164,101,234,62,181,96,196,62,1,200,181,62,220,51,160,62,202,128,135,62,135,117,114,62,122,160,92,62,184,133,18,63,189,181,3,63,193,168,180,62,87,27,166,62,171,5,132,62,188,12,100,62,71,95,69,62,68,73,58,62,243,34,189,62,37,179,177,62,127,185,171,62,97,173,166,62,204,109,161,62,160,157,153,62,124,244,134,62,15,73,125,62,246,15,42,63,92,50,26,63,5,205,195,62,92,38,173,62,14,112,75,62,26,84,41,62,128,55,18,62,1,158,2,62,147,98,24,63,192,108,203,62,64,235,185,62,42,248,176,62,45,113,169,62,114,103,157,62,65,57,116,62,234,139,80,62,89,50,51,63,167,45,238,62,179,141,217,62,34,147,187,62,152,184,160,62,221,68,146,62,54,136,246,61,80,102,204,61,83,244,205,62,178,1,191,62,55,96,183,62,255,128,176,62,148,93,169,62,83,252,159,62,244,74,145,62,15,132,137,62,223,95,8,63,146,220,251,62,92,121,233,62,225,41,142,62,65,29,119,62,34,35,68,62,42,113,41,62,47,111,14,62,7,82,223,62,55,166,184,62,207,104,176,62,41,165,173,62,106,24,167,62,222,179,162,62,73,82,155,62,242,212,67,62,94,168,1,63,10,63,237,62,253,119,227,62,178,32,169,62,252,56,156,62,205,29,139,62,133,233,122,62,136,52,76,62,205,204,76,62,205,204,76,62,205,204,76,62,205,204,76,62,205,204,76,62,205,204,76,62,205,204,76,62,205,204,76,62,221,29,63,63,190,37,193,62,167,110,180,62,84,74,171,62,106,215,98,62,115,230,74,62,106,182,53,62,174,219,43,62,21,141,9,63,251,116,204,62,91,52,156,62,151,135,143,62,135,115,134,62,30,68,127,62,201,43,115,62,88,165,101,62,72,109,45,63,28,84,146,62,153,221,135,62,27,43,130,62,222,108,124,62,250,61,115,62,81,76,109,62,57,195,101,62,227,76,204,62,84,135,196,62,227,58,190,62,58,153,144,62,213,21,137,62,115,94,132,62,16,223,111,62,89,168,107,62,238,216,27,63,59,134,227,62,65,185,205,62,140,88,183,62,2,7,90,62,179,249,62,62,109,104,41,62,203,15,1,62,232,251,1,63,48,32,231,62,204,32,201,62,237,120,151,62,229,158,135,62,178,192,115,62,27,90,100,62,12,77,85,62,82,213,8,63,213,200,249,62,84,164,178,62,120,154,159,62,244,186,141,62,36,94,123,62,107,160,97,62,167,205,77,62,121,3,202,62,71,14,156,62,104,156,150,62,77,244,146,62,179,94,142,62,46,7,139,62,21,5,134,62,229,197,130,62,166,197,43,63,148,148,33,63,101,24,126,62,255,151,99,62,9,174,78,62,185,1,67,62,92,100,54,62,154,45,46,62,17,215,246,62,1,170,196,62,107,200,180,62,253,14,159,62,153,250,141,62,7,76,133,62,155,165,126,62,75,253,114,62,233,88,31,63,99,241,189,62,15,9,176,62,227,134,164,62,235,84,139,62,226,37,104,62,145,90,79,62,152,152,62,62,38,199,200,62,81,8,192,62,142,119,179,62,211,124,173,62,95,137,141,62,225,140,136,62,192,227,129,62,154,60,121,62,135,44,44,63,94,177,19,63,213,36,3,63,9,194,156,62,195,163,31,62,212,228,7,62,173,4,234,61,99,22,217,61,178,158,227,62,165,121,210,62,4,197,193,62,243,252,158,62,198,133,149,62,4,155,141,62,130,154,132,62,225,91,121,62,132,23,245,62,246,134,230,62,99,241,207,62,120,109,193,62,51,38,173,62,227,78,160,62,226,117,33,62,189,208,8,62,31,246,162,62,75,173,155,62,133,228,150,62,4,161,147,62,148,90,144,62,230,107,140,62,146,36,136,62,237,252,132,62,236,119,55,63,217,222,13,63,229,57,197,62,20,132,159,62,95,75,84,62,210,105,37,62,58,232,12,62,30,97,254,61,57,185,1,63,255,65,183,62,130,168,163,62,193,206,153,62,203,236,145,62,54,78,138,62,103,66,130,62,239,116,117,62,159,136,22,63,167,197,227,62,80,158,195,62,61,7,134,62,15,191,116,62,228,141,99,62,117,124,80,62,106,126,63,62,13,36,252,62,42,65,207,62,223,43,169,62,197,96,157,62,33,14,150,62,62,135,142,62,86,254,134,62,90,133,125,62,240,31,40,63,102,227,1,63,72,1,234,62,198,2,210,62,85,53,86,62,206,195,51,62,133,255,34,62,56,61,12,62,123,72,229,62,111,49,212,62,155,40,199,62,82,46,180,62,9,118,165,62,137,117,132,62,134,161,114,62,171,19,99,62,213,37,17,63,116,76,7,63,39,226,204,62,150,77,144,62,7,60,121,62,98,42,96,62,200,161,78,62,231,128,66,62,152,226,193,62,211,206,184,62,180,18,176,62,40,183,159,62,251,54,147,62,189,117,137,62,97,173,130,62,78,52,124,62,19,81,50,63,181,241,25,63,209,6,192,62,36,12,115,62,149,65,105,62,164,226,92,62,162,202,26,62,40,92,3,62,120,224,20,63,53,158,221,62,45,139,198,62,223,200,183,62,22,218,166,62,178,174,133,62,3,187,103,62,131,115,76,62,124,176,45,63,36,114,218,62,66,244,184,62,222,43,168,62,182,205,155,62,91,15,140,62,69,106,97,62,66,155,56,62,83,119,214,62,123,139,202,62,97,97,190,62,96,165,179,62,177,220,168,62,20,235,151,62,53,19,136,62,124,235,124,62,175,196,25,63,197,246,234,62,60,184,214,62,64,240,138,62,6,217,116,62,20,32,81,62,193,142,48,62,66,49,29,62,20,154,230,62,200,234,212,62,175,197,186,62,136,127,177,62,160,12,164,62,155,136,155,62,6,248,131,62,113,64,83,62,163,123,4,63,164,55,246,62,112,243,201,62,82,113,185,62,168,194,137,62,108,136,128,62,117,247,111,62,41,125,95,62,222,111,148,62,215,42,144,62,244,162,140,62,246,83,138,62,44,9,135,62,123,86,132,62,144,5,130,62,30,177,125,62,144,212,63,63,108,105,7,63,152,201,159,62,76,62,146,62,75,97,129,62,178,222,80,62,247,120,33,62,173,195,6,62,144,81,8,63,141,97,192,62,248,28,179,62,173,0,168,62,195,156,159,62,201,128,147,62,95,179,121,62,96,57,94,62,156,219,59,63,181,78,183,62,254,235,170,62,204,136,158,62,240,59,139,62,20,9,107,62,103,124,83,62,101,255,67,62,18,65,213,62,37,104,201,62,35,199,170,62,179,69,161,62,109,219,154,62,85,148,149,62,88,86,143,62,69,152,136,62,14,106,16,63,86,93,0,63,113,34,236,62,238,137,217,62,111,186,109,62,225,115,74,62,124,69,60,62,125,139,40,62,63,14,3,63,166,226,218,62,119,200,202,62,179,211,164,62,32,16,150,62,191,40,138,62,30,13,127,62,69,156,108,62,150,189,11,63,209,87,218,62,57,155,173,62,247,202,161,62,11,56,152,62,199,143,138,62,209,67,110,62,67,121,81,62,245,202,219,62,220,147,174,62,12,202,166,62,140,159,159,62,47,234,153,62,10,133,148,62,239,124,140,62,181,172,132,62,0,96,37,63,21,255,6,63,143,238,181,62,66,43,132,62,138,219,107,62,57,11,92,62,244,200,74,62,20,157,63,62,190,39,255,62,152,219,208,62,54,197,194,62,236,218,183,62,32,18,169,62,135,134,154,62,229,228,134,62,112,173,96,62,208,181,21,63,63,117,238,62,229,50,220,62,33,164,167,62,135,69,144,62,7,38,120,62,244,55,91,62,133,80,68,62,246,11,213,62,8,225,190,62,106,11,176,62,152,223,169,62,179,1,160,62,210,132,152,62,138,154,128,62,142,91,111,62,136,237,24,63,195,12,18,63,156,206,9,63,145,252,143,62,194,106,104,62,53,191,54,62,33,98,22,62,76,250,6,62,48,67,234,62,190,185,214,62,98,230,196,62,180,192,185,62,71,8,151,62,185,187,142,62,101,76,136,62,210,139,125,62,73,140,232,62,223,50,223,62,153,175,211,62,0,43,193,62,125,41,165,62,195,244,144,62,167,105,98,62,212,11,77,62,250,216,172,62,236,181,166,62,111,10,163,62,40,29,160,62,3,24,156,62,46,9,153,62,176,123,149,62,192,56,142,62,36,116,43,63,84,119,253,62,156,33,216,62,191,109,173,62,151,107,157,62,49,6,65,62,104,163,23,62,57,205,8,62,15,34,243,62,175,209,193,62,203,36,178,62,4,50,166,62,56,84,159,62,70,79,154,62,58,21,149,62,137,89,142,62,36,205,20,63,59,180,197,62,89,201,184,62,25,245,168,62,212,66,149,62,73,0,133,62,252,45,116,62,176,36,91,62,172,65,229,62,218,11,216,62,161,148,174,62,162,230,164,62,64,230,155,62,234,151,147,62,191,173,138,62,83,120,126,62,65,245,12,63,140,63,231,62,243,160,209,62,62,198,195,62,16,116,172,62,157,202,106,62,248,75,83,62,26,159,55,62,223,77,255,62,225,23,243,62,241,135,223,62,152,45,207,62,49,234,147,62,222,15,130,62,204,141,103,62,100,255,79,62,169,208,12,63,246,97,4,63,173,188,197,62,205,194,179,62,84,37,161,62,187,125,136,62,166,52,93,62,150,64,62,62,211,190,196,62,110,18,187,62,95,230,176,62,5,245,167,62,66,220,159,62,144,249,153,62,132,132,147,62,173,103,140,62,193,163,39,63,248,82,8,63,230,149,209,62,152,113,172,62,28,208,103,62,164,48,68,62,10,4,51,62,26,17,29,62,178,160,14,63,32,200,210,62,192,204,197,62,27,80,188,62,0,37,177,62,140,146,165,62,40,253,149,62,224,175,50,62,69,235,30,63,126,230,241,62,246,108,207,62,159,28,195,62,191,209,171,62,160,14,133,62,61,252,59,62,185,251,32,62,152,182,201,62,150,140,197,62,133,148,190,62,150,163,185,62,101,232,179,62,151,247,173,62,168,209,163,62,109,42,102,62,18,230,11,63,51,218,254,62,201,37,252,62,210,253,157,62,38,110,149,62,65,67,142,62,155,89,65,62,220,160,30,62,119,28,220,62,54,236,206,62,162,106,197,62,87,25,189,62,50,97,180,62,137,36,164,62,72,73,138,62,224,200,118,62,115,40,12,63,98,254,226,62,197,10,213,62,157,235,177,62,192,110,162,62,180,249,149,62,37,99,92,62,127,28,67,62,13,194,37,63,203,24,11,63,252,30,4,63,208,30,229,62,243,161,213,62,231,44,201,62,198,100,161,62,115,193,148,62,95,35,69,63,124,1,232,62,208,74,218,62,90,127,138,62,211,14,114,62,109,195,19,62,114,83,9,62,57,162,255,61,82,217,13,63,232,236,166,62,29,55,155,62,203,25,150,62,100,176,141,62,127,167,136,62,223,84,132,62,167,111,120,62,47,179,67,63,108,18,169,62,120,228,143,62,201,190,135,62,225,82,121,62,16,31,99,62,32,50,87,62,163,24,69,62,223,242,209,62,115,124,195,62,113,154,161,62,12,136,151,62,48,101,145,62,239,10,140,62,215,158,135,62,95,250,130,62,60,107,19,63,7,198,234,62,109,115,212,62,3,238,197,62,169,225,102,62,118,156,41,62,57,229,22,62,138,210,0,62,3,98,242,62,27,106,223,62,64,150,209,62,76,226,163,62,141,84,149,62,240,123,131,62,189,68,96,62,112,228,76,62,226,33,18,63,134,255,249,62,140,194,160,62,230,111,143,62,137,60,130,62,30,142,117,62,6,245,101,62,252,225,87,62,92,207,241,62,212,136,154,62,242,16,147,62,120,47,141,62,113,92,137,62,102,96,134,62,159,92,130,62,201,119,125,62,22,13,56,63,51,92,29,63,113,161,152,62,212,241,111,62,81,126,76,62,202,82,50,62,104,26,32,62,200,121,15,62,228,6,4,63,177,206,207,62,138,15,179,62,4,208,154,62,11,163,133,62,137,184,118,62,25,209,106,62,122,224,95,62,248,148,26,63,145,28,208,62,237,99,193,62,51,51,172,62,72,11,136,62,7,56,118,62,182,173,91,62,87,57,11,62,205,168,196,62,16,110,188,62,7,99,179,62,181,21,172,62,19,157,163,62,102,238,145,62,246,12,135,62,126,147,126,62,85,26,33,63,226,46,25,63,247,121,12,63,7,62,132,62,86,77,61,62,192,149,16,62,224,158,0,62,39,82,227,61,108,24,223,62,42,14,210,62,171,166,199,62,15,197,189,62,53,31,142,62,231,102,132,62,48,4,120,62,84,206,98,62,217,158,4,63,65,163,232,62,6,43,220,62,202,28,179,62,27,213,160,62,134,230,144,62,92,253,13,62,209,87,245,61,100,181,179,62,186,87,160,62,182,107,153,62,97,7,148,62,216,127,144,62,186,106,141,62,96,41,138,62,58,56,134,62,103,187,59,63,69,229,7,63,132,173,208,62,131,124,122,62,255,232,81,62,73,146,67,62,139,204,30,62,132,213,10,62,82,138,235,62,103,89,184,62,35,39,172,62,5,223,161,62,139,134,153,62,142,47,145,62,115,10,136,62,8,194,126,62,45,126,27,63,213,143,219,62,175,40,166,62,146,227,149,62,56,22,135,62,229,185,109,62,3,206,89,62,151,140,73,62,100,239,227,62,80,223,213,62,54,97,163,62,168,192,152,62,11,125,145,62,171,162,139,62,147,175,134,62,226,36,128,62,60,125,36,63,238,26,18,63,113,254,242,62,150,152,211,62,15,171,32,62,52,222,9,62,213,215,247,61,101,14,220,61,47,64,239,62,104,134,226,62,153,103,210,62,144,57,196,62,33,49,137,62,229,195,128,62,191,23,112,62,134,30,98,62,56,213,253,62,102,132,238,62,229,43,198,62,113,146,173,62,130,53,158,62,238,4,105,62,80,4,73,62,26,131,60,62,230,85,187,62,29,235,178,62,194,40,168,62,180,40,159,62,112,107,150,62,34,159,143,62,48,53,138,62,158,28,133,62,234,118,43,63,246,197,24,63,16,104,236,62,114,249,127,62,179,235,81,62,206,125,36,62,9,97,16,62,146,211,255,61,129,45,11,63,87,210,220,62,70,43,203,62,97,14,183,62,192,93,147,62,104,153,124,62,65,194,106,62,97,132,90,62,174,231,62,63,109,224,211,62,203,146,184,62,146,132,175,62,162,0,166,62,210,48,149,62,4,174,41,62,141,134,232,61,97,48,205,62,238,103,196,62,64,75,186,62,114,28,177,62,154,235,158,62,5,192,152,62,154,70,148,62,11,22,142,62,22,204,37,63,133,73,242,62,44,68,235,62,73,169,99,62,65,50,91,62,199,112,73,62,181,206,67,62,255,173,58,62,185,235,229,62,149,186,189,62,124,206,185,62,178,207,175,62,43,241,171,62,165,46,164,62,156,102,93,62,176,126,77,62,93,207,1,63,84,26,239,62,233,30,226,62,113,89,168,62,235,155,131,62,185,55,108,62,89,248,93,62,10,222,77,62,186,232,135,62,244,35,134,62,194,72,132,62,143,17,131,62,54,179,129,62,22,14,128,62,53,183,125,62,81,253,121,62,129,85,76,63,113,225,222,62,172,123,168,62,58,244,143,62,211,212,118,62,47,17,74,62,155,199,42,62,41,121,12,62,33,107,11,63,101,177,180,62,49,0,172,62,90,251,164,62,127,8,159,62,99,29,153,62,58,50,144,62,199,238,134,62,100,104,50,63,198,110,219,62,25,78,158,62,31,179,141,62,63,188,129,62,19,156,112,62,244,155,92,62,157,61,74,62,39,46,218,62,244,179,202,62,212,12,186,62,218,229,170,62,189,7,154,62,255,131,144,62,152,0,138,62,116,213,130,62,216,107,10,63,110,122,249,62,94,153,221,62,22,86,196,62,193,21,123,62,21,181,99,62,173,240,83,62,26,216,71,62,204,59,241,62,238,202,227,62,240,81,213,62,191,93,160,62,106,121,147,62,179,108,139,62,46,211,131,62,232,93,116,62,14,180,253,62,2,113,235,62,167,197,185,62,134,49,161,62,40,79,145,62,226,119,134,62,93,62,126,62,102,179,111,62,90,162,202,62,164,127,176,62,176,100,165,62,137,9,160,62,122,40,155,62,203,214,150,62,160,34,146,62,179,120,139,62,226,161,30,63,230,88,20,63,167,20,154,62,54,115,133,62,77,109,117,62,113,250,106,62,203,98,87,62,124,17,71,62,209,192,5,63,127,85,207,62,182,107,195,62,243,187,183,62,167,20,166,62,51,2,141,62,180,216,112,62,85,125,91,62,60,75,33,63,124,9,231,62,33,36,209,62,184,84,189,62,157,99,138,62,168,24,108,62,1,252,84,62,173,67,60,62,43,207,203,62,21,50,186,62,8,79,179,62,33,2,174,62,132,244,166,62,153,106,162,62,187,174,153,62,135,84,120,62,40,215,33,63,169,179,15,63,242,180,237,62,138,128,130,62,104,35,99,62,105,193,70,62,26,71,47,62,209,116,33,62,143,123,212,62,109,17,205,62,206,110,198,62,176,212,190,62,137,6,156,62,138,115,143,62,182,209,132,62,156,135,123,62,190,117,250,62,130,78,208,62,91,179,202,62,171,251,180,62,248,148,174,62,218,105,154,62,111,253,104,62,169,168,40,62,44,131,178,62,32,66,171,62,111,255,161,62,246,234,153,62,70,98,149,62,125,188,144,62,131,140,141,62,61,90,137,62,162,135,52,63,71,200,234,62,72,158,216,62,101,208,188,62,231,212,104,62,108,181,68,62,214,23,47,62,230,161,19,62,241,9,235,62,146,47,194,62,180,0,182,62,200,77,172,62,9,4,162,62,138,52,151,62,60,22,137,62,2,242,126,62,26,119,26,63,4,101,201,62,169,72,168,62,26,81,149,62,48,75,140,62,226,252,132,62,254,186,119,62,146,207,98,62,170,170,240,62,134,66,219,62,103,121,184,62,38,125,171,62,157,88,156,62,53,63,140,62,1,6,125,62,120,183,102,62,129,49,16,63,239,83,5,63,11,204,250,62,17,89,178,62,198,41,142,62,255,20,91,62,157,101,66,62,134,173,43,62,16,238,4,63,115,213,236,62,235,55,188,62,148,26,175,62,10,101,165,62,212,225,151,62,91,219,120,62,42,189,85,62,135,174,22,63,202,8,14,63,142,138,171,62,117,201,160,62,243,35,142,62,125,136,125,62,239,195,95,62,111,77,74,62,221,13,190,62,52,210,183,62,158,189,178,62,235,1,171,62,116,62,154,62,233,5,146,62,210,152,140,62,29,197,135,62,195,154,32,63,50,160,24,63,19,170,192,62,180,61,162,62,15,115,97,62,220,147,74,62,187,143,52,62,62,160,31,62,176,157,21,63,164,193,206,62,199,234,199,62,20,246,190,62,186,228,181,62,229,149,169,62,129,171,72,62,166,184,50,62,170,138,39,63,189,204,224,62,6,6,212,62,72,145,193,62,52,200,178,62,188,66,165,62,144,53,22,62,248,47,245,61,79,92,203,62,195,143,196,62,32,233,190,62,108,169,184,62,84,136,177,62,55,146,172,62,184,144,162,62,117,210,153,62,202,163,12,63,182,160,1,63,253,170,244,62,88,237,143,62,215,90,124,62,54,177,104,62,244,174,90,62,208,123,74,62,238,248,227,62,255,198,197,62,215,134,186,62,82,246,177,62,136,222,170,62,117,175,163,62,21,53,152,62,24,251,116,62,172,73,8,63,216,51,253,62,51,169,229,62,71,78,173,62,240,145,155,62,163,221,130,62,176,125,102,62,7,81,77,62,70,227,33,63,134,51,24,63,51,110,12,63,122,129,224,62,35,197,206,62,214,16,182,62,11,114,166,62,183,219,153,62,232,122,69,63,23,92,211,62,181,251,199,62,5,159,168,62,15,2,145,62,215,35,79,62,34,172,25,62,167,203,253,61,108,227,14,63,115,211,211,62,113,7,169,62,142,130,156,62,160,126,148,62,83,179,141,62,136,187,134,62,100,146,123,62,245,212,47,63,111,34,163,62,82,255,157,62,190,140,145,62,246,112,137,62,60,246,122,62,33,92,109,62,33,87,89,62,33,144,207,62,246,254,199,62,117,28,191,62,32,15,159,62,126,161,146,62,199,5,138,62,179,25,129,62,170,13,119,62,19,232,21,63,83,249,218,62,194,22,206,62,146,252,186,62,150,170,130,62,7,116,82,62,33,87,58,62,203,128,248,61,189,85,6,63,33,210,251,62,21,171,210,62,206,145,152,62,169,214,141,62,24,96,132,62,106,225,116,62,237,147,97,62,30,77,8,63,99,174,253,62,73,65,166,62,242,200,153,62,140,58,146,62,202,51,138,62,250,44,128,62,235,117,109,62,62,20,190,62,169,6,166,62,8,4,160,62,227,39,156,62,149,228,151,62,143,246,146,62,228,49,142,62,143,73,136,62,73,148,44,63,242,239,24,63,172,194,143,62,157,171,130,62,172,206,113,62,62,254,92,62,11,63,70,62,166,31,57,62,55,90,1,63,248,63,202,62,136,232,188,62,55,140,172,62,75,5,152,62,255,236,141,62,108,16,135,62,28,92,124,62,88,173,25,63,158,252,198,62,60,241,183,62,236,164,170,62,67,202,158,62,28,48,115,62,140,27,76,62,116,168,46,62,116,42,203,62,198,121,192,62,139,28,186,62,21,22,178,62,119,69,152,62,248,244,143,62,78,29,138,62,47,168,130,62,122,157,38,63,76,139,11,63,154,249,1,63,35,241,171,62,252,55,77,62,168,23,41,62,63,157,14,62,126,176,250,61,115,134,224,62,147,73,213,62,33,39,203,62,195,55,171,62,6,254,159,62,158,182,149,62,217,77,140,62,149,56,130,62,227,202,4,63,165,167,245,62,66,198,221,62,217,214,200,62,242,115,179,62,136,31,169,62,216,53,83,62,28,254,33,62,25,186,156,62,11,146,153,62,4,198,151,62,49,214,149,62,185,201,147,62,226,226,145,62,218,173,142,62,33,85,139,62,45,173,57,63,81,247,10,63,208,25,217,62,48,176,163,62,1,127,131,62,232,134,50,62,4,168,241,61,48,51,201,61,30,151,254,62,184,140,174,62,34,16,166,62,123,36,160,62,144,255,153,62,108,209,147,62,144,51,140,62,204,211,129,62,107,59,21,63,18,199,218,62,54,70,193,62,94,154,149,62,104,110,138,62,25,83,128,62,179,192,109,62,79,59,90,62,143,8,248,62,189,63,233,62,167,234,172,62,91,89,163,62,161,114,153,62,69,2,145,62,216,198,136,62,28,52,122,62,118,56,23,63,127,253,9,63,221,113,248,62,148,55,199,62,205,253,94,62,145,142,59,62,251,92,36,62,150,119,21,62,160,103,243,62,108,85,223,62,129,82,203,62,248,122,190,62,248,148,174,62,196,183,114,62,52,153,94,62,203,53,78,62,61,172,22,63,99,41,11,63,215,146,210,62,106,1,160,62,226,65,142,62,127,33,121,62,216,119,93,62,142,219,67,62,124,45,201,62,196,76,189,62,253,84,176,62,126,249,159,62,165,198,151,62,59,66,145,62,119,224,138,62,49,209,130,62,81,161,43,63,136,133,29,63,178,116,173,62,226,104,139,62,247,0,125,62,37,44,87,62,35,242,34,62,5,94,9,62,181,63,28,63,22,37,215,62,159,28,203,62,9,252,191,62,240,49,156,62,132,224,142,62,11,225,129,62,171,220,76,62,86,212,52,63,105,20,217,62,197,219,193,62,80,54,181,62,100,79,164,62,13,155,148,62,63,64,121,62,79,232,248,61,137,116,220,62,89,24,204,62,24,229,194,62,255,54,185,62,211,210,165,62,104,145,156,62,37,166,149,62,245,171,139,62,148,153,31,63,162,241,248,62,84,112,229,62,102,183,153,62,13,155,129,62,64,126,94,62,221,29,73,62,49,213,52,62,95,87,230,62,59,102,215,62,97,86,203,62,111,173,189,62,136,94,175,62,56,182,155,62,221,187,121,62,127,117,99,62,17,13,13,63,222,191,238,62,17,215,217,62,138,107,200,62,150,13,143,62,251,158,133,62,129,181,120,62,198,52,83,62,165,225,149,62,114,243,146,62,55,69,145,62,171,212,143,62,32,165,141,62,63,209,139,62,107,244,136,62,112,136,135,62,99,171,54,63,240,251,250,62,42,102,192,62,29,255,144,62,174,117,116,62,191,204,88,62,67,143,64,62,210,33,32,62,98,125,14,63,167,55,204,62,139,174,191,62,220,0,174,62,251,22,158,62,185,232,147,62,145,198,137,62,112,188,114,62,186,177,52,63,96,136,219,62,72,128,188,62,138,102,169,62,122,155,142,62,147,2,103,62,121,64,70,62,208,174,47,62,75,136,224,62,194,71,212,62,120,5,179,62,147,7,170,62,174,42,163,62,243,196,156,62,224,214,149,62,9,52,141,62,250,214,19,63,132,157,251,62,139,25,239,62,119,74,222,62,232,113,143,62,246,40,120,62,83,62,67,62,89,39,25,62,186,93,2,63,81,140,231,62,132,185,211,62,69,74,173,62,195,158,162,62,88,171,150,62,93,215,137,62,85,66,117,62,185,142,26,63,209,17,237,62,109,7,174,62,255,180,159,62,168,145,150,62,163,237,141,62,191,251,129,62,238,37,94,62,39,121,223,62,67,204,184,62,205,148,175,62,165,71,169,62,57,51,162,62,22,219,154,62,62,157,147,62,145,176,138,62,6,98,39,63,238,144,6,63,31,104,162,62,88,201,148,62,6,17,135,62,44,235,108,62,233,210,80,62,52,149,54,62,84,115,1,63,233,52,205,62,101,135,193,62,248,2,185,62,237,4,176,62,29,103,167,62,48,68,156,62,112,12,90,62,87,76,25,63,126,101,248,62,22,240,198,62,10,70,169,62,142,235,154,62,111,164,138,62,46,167,113,62,106,129,70,62,52,176,205,62,254,230,188,62,10,49,182,62,184,48,178,62,237,230,172,62,28,34,167,62,139,50,131,62,15,19,123,62,94,173,26,63,234,124,12,63,126,240,1,63,123,14,155,62,220,76,132,62,162,222,90,62,208,191,45,62,252,8,11,62,133,51,242,62,217,249,223,62,254,197,211,62,204,106,193,62,127,88,157,62,210,189,141,62,97,238,132,62,40,143,114,62,187,48,255,62,31,222,231,62,17,151,217,62,121,242,199,62,239,204,181,62,60,246,146,62,166,51,108,62,171,175,77,62,76,148,184,62,227,36,177,62,155,168,170,62,88,62,164,62,174,238,158,62,2,23,153,62,50,81,147,62,242,21,139,62,67,26,40,63,129,189,2,63,117,25,230,62,216,64,179,62,136,4,149,62,221,147,124,62,105,232,31,62,116,129,250,61,74,208,2,63,227,27,195,62,101,47,183,62,249,204,176,62,190,55,168,62,245,42,156,62,67,155,144,62,167,40,123,62,60,49,34,63,155,187,186,62,98,136,175,62,168,22,163,62,242,173,151,62,9,229,135,62,164,106,120,62,250,157,85,62,143,177,244,62,243,187,221,62,85,57,188,62,160,109,175,62,234,172,164,62,0,147,151,62,45,92,142,62,101,110,131,62,192,40,8,63,191,88,253,62,140,118,230,62,247,131,202,62,141,84,175,62,217,174,111,62,139,4,64,62,21,51,39,62,2,7,2,63,173,243,249,62,253,36,211,62,92,205,202,62,179,239,150,62,114,16,146,62,137,8,132,62,178,3,128,62,109,230,14,63,122,249,8,63,112,95,178,62,143,189,170,62,155,110,157,62,131,99,152,62,217,196,113,62,37,4,99,62,68,44,191,62,159,188,184,62,6,234,178,62,16,191,173,62,23,33,168,62,82,96,162,62,153,131,155,62,87,154,147,62,31,91,36,63,240,102,20,63,220,91,220,62,116,214,158,62,108,68,135,62,144,225,72,62,25,141,39,62,194,29,11,62,157,166,30,63,122,134,214,62,252,230,194,62,222,201,186,62,232,54,177,62,251,214,166,62,122,115,147,62,169,238,20,62,237,196,27,63,73,145,230,62,225,52,218,62,114,201,191,62,150,226,166,62,248,203,150,62,195,45,123,62,22,147,24,62,114,131,213,62,230,172,206,62,0,101,202,62,86,176,197,62,215,185,192,62,199,15,183,62,187,77,160,62,77,229,66,62,173,249,17,63,55,203,6,63,156,4,236,62,28,134,170,62,175,104,150,62,180,103,128,62,157,40,98,62,82,11,43,62,223,16,239,62,66,2,220,62,124,129,207,62,236,54,187,62,6,139,176,62,28,96,166,62,124,206,146,62,119,37,129,62,220,176,13,63,100,170,232,62,38,125,206,62,183,49,190,62,243,4,171,62,194,130,153,62,30,190,136,62,122,10,75,62};
unsigned char TabulatedValues::ucCodedVVecVqMatElems[7][ 19208]={
	{109, 155, 66, 80, 215, 13, 210, 63},
	{109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 90, 8, 45, 69, 136, 217, 63, 47, 191, 70, 45, 69, 136, 217, 191, 154, 116, 87, 120, 67, 69, 223, 63, 240, 71, 126, 152, 215, 216, 196, 191, 194, 64, 67, 147, 215, 216, 196, 191, 109, 62, 109, 221, 215, 216, 196, 191, 0, 0, 0, 0, 0, 0, 0, 128, 227, 38, 74, 85, 111, 123, 221, 63, 25, 46, 118, 119, 111, 123, 205, 191, 210, 234, 44, 66, 111, 123, 205, 191},
	{109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 203, 200, 157, 195, 20, 219, 191, 57, 85, 45, 36, 194, 20, 219, 63, 37, 118, 124, 234, 16, 62, 211, 191, 3, 15, 123, 65, 57, 126, 157, 190, 61, 207, 233, 225, 14, 62, 211, 63, 57, 48, 72, 105, 18, 62, 211, 63, 66, 233, 23, 140, 13, 62, 211, 191, 154, 116, 87, 120, 67, 69, 223, 63, 103, 191, 1, 41, 32, 56, 214, 191, 71, 76, 100, 150, 32, 56, 198, 63, 18, 195, 144, 95, 32, 56, 198, 63, 39, 128, 19, 237, 106, 96, 215, 191, 163, 123, 133, 206, 54, 135, 115, 63, 238, 80, 84, 217, 107, 96, 215, 191, 59, 2, 22, 39, 231, 90, 190, 63, 44, 205, 201, 222, 240, 90, 190, 63, 0, 0, 0, 0, 0, 0, 0, 128, 51, 56, 69, 85, 228, 0, 214, 63, 251, 43, 145, 184, 224, 0, 198, 191, 218, 171, 233, 50, 232, 0, 198, 191, 48, 140, 90, 115, 220, 68, 191, 191, 208, 186, 9, 232, 225, 68, 223, 191, 1, 255, 5, 111, 229, 68, 191, 191, 202, 106, 154, 192, 167, 115, 215, 63, 217, 1, 11, 245, 170, 115, 215, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 205, 207, 49, 3, 78, 213, 63, 82, 217, 77, 70, 9, 78, 213, 191, 6, 179, 161, 129, 59, 131, 197, 63, 157, 24, 54, 157, 128, 124, 176, 62, 82, 225, 199, 105, 63, 131, 197, 191, 230, 143, 109, 139, 111, 34, 224, 63, 125, 89, 206, 171, 109, 34, 224, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 184, 151, 125, 240, 129, 131, 213, 191, 141, 114, 109, 143, 128, 131, 213, 63, 46, 144, 76, 20, 50, 21, 224, 63, 189, 159, 75, 220, 148, 151, 68, 190, 241, 118, 190, 3, 49, 21, 224, 191, 16, 244, 219, 96, 71, 226, 196, 63, 179, 218, 243, 200, 72, 226, 196, 191, 155, 103, 140, 26, 96, 47, 228, 63, 43, 122, 117, 39, 163, 198, 196, 63, 67, 139, 114, 199, 102, 21, 201, 191, 193, 8, 227, 18, 103, 21, 201, 191, 126, 119, 43, 227, 221, 79, 203, 63, 196, 61, 11, 64, 230, 45, 212, 191, 227, 109, 54, 59, 227, 79, 203, 63, 184, 81, 11, 76, 100, 158, 208, 191, 103, 194, 126, 3, 98, 158, 208, 191, 0, 0, 0, 0, 0, 0, 0, 128, 56, 209, 125, 134, 221, 122, 225, 191, 142, 213, 241, 253, 218, 122, 193, 191, 206, 16, 154, 195, 224, 122, 193, 191, 80, 188, 218, 46, 114, 34, 202, 63, 73, 80, 13, 114, 6, 213, 133, 191, 82, 94, 10, 185, 122, 34, 202, 63, 39, 63, 6, 107, 200, 115, 201, 63, 101, 189, 90, 11, 212, 115, 201, 63, 0, 0, 0, 0, 0, 0, 0, 0, 235, 177, 109, 174, 105, 79, 209, 63, 73, 138, 169, 88, 198, 228, 213, 191, 222, 12, 107, 140, 192, 228, 213, 191, 170, 203, 77, 209, 120, 27, 198, 191, 168, 230, 121, 252, 166, 122, 225, 63, 76, 170, 248, 181, 112, 27, 198, 191, 158, 41, 161, 224, 153, 179, 185, 63, 11, 19, 107, 37, 202, 179, 185, 63},
	{109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 71, 42, 203, 127, 52, 217, 63, 102, 157, 2, 69, 25, 252, 175, 191, 168, 82, 108, 60, 163, 55, 217, 63, 48, 26, 21, 77, 122, 128, 219, 63, 143, 229, 164, 52, 122, 128, 219, 191, 34, 54, 112, 101, 121, 126, 192, 63, 76, 229, 240, 24, 128, 52, 217, 191, 109, 231, 232, 158, 100, 142, 210, 63, 118, 218, 246, 75, 121, 126, 192, 191, 234, 33, 119, 140, 26, 252, 175, 63, 133, 140, 103, 54, 36, 162, 200, 63, 29, 223, 23, 77, 100, 142, 210, 191, 39, 22, 165, 19, 163, 55, 217, 191, 240, 158, 74, 69, 37, 162, 200, 191, 154, 116, 87, 120, 67, 69, 223, 63, 216, 39, 170, 188, 165, 138, 212, 63, 227, 22, 198, 189, 167, 212, 203, 191, 31, 221, 85, 90, 154, 224, 218, 191, 194, 172, 176, 227, 171, 141, 205, 63, 113, 15, 180, 191, 46, 165, 180, 191, 161, 79, 192, 180, 164, 212, 203, 191, 213, 162, 146, 44, 49, 165, 180, 191, 134, 97, 102, 32, 15, 173, 78, 63, 211, 83, 135, 208, 72, 4, 211, 63, 8, 168, 31, 208, 72, 4, 211, 63, 117, 97, 102, 148, 176, 243, 183, 191, 202, 186, 36, 123, 189, 144, 219, 191, 56, 161, 13, 90, 46, 172, 78, 63, 116, 184, 182, 22, 176, 22, 210, 63, 72, 92, 84, 102, 43, 63, 216, 191, 0, 0, 0, 0, 0, 0, 0, 128, 103, 254, 121, 152, 204, 147, 215, 63, 146, 12, 64, 119, 251, 103, 200, 63, 164, 164, 253, 136, 31, 243, 206, 63, 104, 11, 64, 74, 204, 59, 198, 63, 86, 140, 203, 217, 13, 235, 203, 191, 95, 213, 247, 36, 222, 28, 181, 63, 244, 28, 19, 105, 246, 183, 221, 63, 164, 108, 104, 82, 16, 130, 210, 191, 84, 79, 210, 153, 29, 125, 208, 191, 74, 161, 152, 28, 228, 105, 215, 191, 124, 202, 145, 154, 44, 110, 222, 191, 207, 92, 71, 46, 215, 72, 192, 191, 252, 9, 251, 4, 110, 43, 217, 63, 181, 185, 27, 190, 180, 181, 174, 63, 32, 21, 117, 203, 195, 222, 206, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 248, 7, 134, 128, 254, 213, 63, 227, 151, 242, 217, 81, 178, 177, 191, 203, 232, 34, 148, 199, 11, 212, 63, 81, 231, 178, 247, 159, 115, 219, 191, 193, 202, 100, 247, 140, 194, 196, 191, 18, 90, 227, 178, 146, 134, 209, 63, 229, 69, 68, 194, 206, 173, 224, 63, 147, 213, 119, 241, 1, 225, 213, 191, 149, 103, 1, 84, 113, 157, 203, 63, 96, 242, 225, 229, 77, 102, 193, 191, 160, 247, 108, 51, 64, 175, 188, 191, 125, 243, 155, 64, 230, 178, 224, 191, 133, 59, 139, 83, 48, 176, 187, 191, 234, 106, 88, 22, 54, 48, 203, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 102, 156, 213, 136, 20, 217, 191, 225, 55, 202, 8, 114, 188, 190, 63, 232, 91, 212, 38, 72, 165, 218, 63, 13, 126, 180, 162, 221, 76, 196, 191, 244, 56, 222, 152, 150, 93, 219, 63, 0, 205, 29, 13, 147, 89, 168, 191, 83, 108, 239, 209, 243, 164, 91, 191, 15, 203, 116, 191, 188, 59, 217, 63, 15, 143, 34, 17, 219, 109, 198, 191, 225, 230, 236, 4, 4, 100, 155, 191, 225, 166, 44, 64, 22, 71, 216, 191, 144, 248, 231, 105, 137, 89, 84, 191, 85, 249, 51, 118, 18, 79, 224, 191, 75, 253, 40, 0, 217, 90, 213, 63, 155, 103, 140, 26, 96, 47, 228, 63, 240, 146, 174, 252, 39, 200, 183, 63, 242, 20, 214, 43, 47, 99, 192, 191, 157, 140, 54, 144, 238, 140, 216, 63, 250, 10, 176, 175, 41, 167, 186, 191, 203, 34, 95, 151, 14, 137, 210, 191, 241, 183, 2, 103, 52, 99, 192, 191, 83, 37, 38, 52, 14, 137, 210, 191, 176, 188, 252, 136, 81, 47, 212, 191, 207, 135, 235, 14, 12, 174, 161, 63, 184, 30, 74, 7, 12, 174, 161, 63, 251, 12, 194, 228, 240, 246, 209, 191, 224, 102, 233, 48, 198, 222, 218, 63, 116, 57, 210, 137, 81, 47, 212, 191, 42, 242, 200, 190, 9, 205, 83, 63, 54, 213, 71, 251, 221, 56, 208, 63, 0, 0, 0, 0, 0, 0, 0, 128, 7, 237, 62, 29, 231, 80, 225, 63, 146, 92, 45, 223, 7, 73, 200, 191, 235, 254, 242, 113, 208, 189, 221, 191, 121, 11, 96, 191, 45, 126, 199, 63, 15, 204, 123, 190, 136, 155, 180, 63, 61, 30, 228, 123, 21, 2, 181, 191, 203, 239, 164, 121, 194, 239, 197, 191, 254, 173, 213, 34, 153, 76, 84, 191, 21, 198, 193, 66, 2, 108, 214, 191, 141, 221, 80, 150, 175, 214, 223, 191, 237, 183, 61, 9, 62, 15, 202, 63, 222, 140, 146, 132, 165, 12, 208, 63, 156, 175, 56, 190, 54, 154, 91, 63, 128, 139, 138, 76, 108, 220, 179, 63, 54, 221, 19, 52, 248, 194, 218, 63, 0, 0, 0, 0, 0, 0, 0, 0, 45, 195, 125, 129, 5, 224, 211, 63, 225, 142, 21, 12, 204, 99, 209, 191, 117, 14, 185, 242, 50, 246, 191, 63, 74, 242, 251, 207, 81, 81, 210, 191, 248, 122, 251, 231, 83, 19, 212, 191, 46, 201, 5, 191, 213, 11, 218, 191, 154, 88, 169, 60, 74, 37, 221, 63, 149, 230, 200, 236, 252, 238, 196, 191, 68, 239, 122, 162, 102, 185, 164, 191, 58, 238, 140, 131, 23, 43, 209, 63, 233, 129, 83, 156, 173, 68, 224, 63, 148, 49, 121, 13, 147, 109, 168, 191, 196, 203, 35, 247, 163, 173, 196, 63, 126, 25, 230, 143, 150, 53, 214, 191, 151, 218, 95, 103, 210, 192, 168, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 13, 147, 10, 242, 121, 183, 191, 131, 121, 155, 5, 1, 191, 171, 191, 165, 216, 194, 73, 17, 132, 192, 191, 36, 190, 120, 172, 129, 86, 183, 191, 250, 168, 212, 164, 162, 217, 214, 63, 139, 109, 9, 133, 251, 74, 218, 63, 187, 0, 44, 19, 253, 108, 200, 191, 214, 96, 94, 118, 224, 153, 197, 63, 208, 161, 248, 137, 166, 14, 208, 191, 65, 75, 253, 197, 123, 70, 203, 63, 48, 213, 93, 219, 9, 248, 134, 63, 128, 98, 186, 101, 205, 212, 225, 191, 228, 226, 114, 187, 101, 109, 210, 63, 240, 116, 1, 232, 201, 32, 193, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 188, 39, 203, 24, 229, 217, 191, 204, 47, 34, 213, 21, 31, 196, 63, 210, 101, 160, 58, 235, 15, 217, 63, 110, 255, 163, 255, 201, 249, 199, 63, 156, 13, 72, 130, 25, 113, 200, 63, 23, 78, 251, 164, 251, 156, 190, 191, 203, 70, 15, 228, 7, 165, 101, 63, 142, 115, 121, 225, 240, 153, 225, 191, 29, 171, 43, 89, 71, 55, 214, 63, 240, 242, 223, 99, 101, 161, 177, 63, 48, 199, 70, 17, 153, 185, 208, 63, 200, 4, 123, 173, 4, 171, 101, 191, 22, 152, 106, 91, 14, 48, 197, 191, 54, 107, 139, 189, 92, 227, 219, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 154, 96, 120, 127, 211, 109, 191, 89, 52, 119, 236, 26, 38, 196, 191, 12, 112, 70, 170, 112, 251, 165, 63, 92, 222, 233, 99, 178, 56, 214, 191, 242, 141, 165, 224, 6, 71, 112, 63, 194, 159, 25, 226, 128, 167, 186, 191, 128, 236, 105, 144, 166, 147, 215, 63, 15, 56, 179, 252, 123, 122, 205, 63, 223, 70, 4, 168, 212, 51, 186, 191, 190, 52, 249, 91, 3, 111, 168, 191, 212, 132, 21, 22, 6, 159, 224, 63, 161, 133, 28, 203, 128, 91, 209, 63, 65, 186, 254, 250, 185, 192, 207, 191, 32, 149, 63, 242, 230, 28, 215, 191, 176, 104, 7, 252, 30, 226, 231, 63, 219, 39, 84, 127, 236, 110, 202, 191, 58, 88, 144, 100, 111, 92, 213, 63, 161, 193, 244, 32, 229, 123, 204, 191, 195, 126, 156, 235, 210, 65, 213, 191, 217, 93, 35, 79, 4, 148, 198, 63, 92, 181, 195, 91, 111, 92, 213, 63, 54, 170, 139, 181, 6, 148, 198, 63, 33, 69, 145, 143, 96, 146, 97, 191, 59, 108, 45, 86, 33, 183, 208, 191, 234, 32, 247, 86, 33, 183, 208, 191, 13, 226, 108, 41, 109, 195, 201, 63, 209, 243, 99, 136, 152, 163, 210, 191, 96, 9, 167, 206, 223, 145, 97, 191, 181, 235, 126, 253, 18, 85, 210, 191, 66, 173, 242, 115, 116, 0, 93, 191, 0, 0, 0, 0, 0, 0, 0, 128, 91, 22, 191, 233, 169, 135, 217, 63, 156, 146, 62, 39, 124, 225, 92, 191, 71, 90, 197, 245, 46, 127, 227, 63, 192, 182, 217, 9, 152, 97, 147, 63, 61, 141, 125, 118, 207, 142, 198, 63, 89, 239, 106, 61, 237, 253, 72, 191, 215, 110, 91, 104, 56, 3, 216, 191, 239, 119, 213, 177, 248, 79, 209, 63, 113, 135, 191, 80, 172, 49, 202, 191, 31, 76, 42, 51, 244, 152, 210, 191, 236, 173, 28, 104, 7, 63, 215, 63, 216, 244, 149, 100, 202, 249, 213, 191, 225, 107, 89, 129, 42, 139, 215, 191, 118, 111, 240, 234, 153, 85, 163, 63, 116, 106, 18, 141, 248, 246, 220, 191, 0, 0, 0, 0, 0, 0, 0, 0, 241, 191, 109, 136, 119, 69, 225, 63, 251, 236, 238, 222, 87, 121, 212, 63, 78, 235, 155, 89, 174, 43, 210, 191, 207, 200, 186, 168, 189, 230, 214, 191, 112, 31, 53, 107, 150, 136, 193, 63, 49, 132, 216, 111, 100, 170, 222, 63, 217, 105, 71, 40, 142, 116, 201, 191, 234, 150, 218, 107, 124, 42, 75, 191, 162, 184, 74, 9, 33, 172, 176, 191, 178, 9, 12, 236, 151, 159, 219, 63, 113, 27, 22, 125, 237, 123, 208, 191, 247, 54, 226, 108, 125, 124, 188, 63, 242, 166, 156, 57, 234, 212, 74, 63, 133, 225, 26, 107, 192, 254, 224, 191, 138, 247, 146, 97, 237, 99, 185, 191, 0, 0, 0, 0, 0, 0, 0, 128, 243, 194, 138, 136, 162, 47, 208, 63, 213, 2, 185, 100, 120, 122, 218, 191, 195, 2, 56, 16, 214, 71, 173, 63, 216, 104, 28, 32, 157, 126, 216, 191, 141, 57, 236, 104, 240, 224, 225, 63, 73, 35, 15, 159, 215, 55, 205, 191, 83, 108, 185, 243, 21, 237, 216, 63, 86, 52, 185, 13, 216, 221, 225, 63, 239, 30, 0, 6, 101, 255, 206, 63, 79, 157, 178, 96, 30, 231, 195, 191, 126, 195, 113, 226, 183, 127, 224, 191, 172, 27, 196, 247, 231, 70, 175, 63, 8, 230, 63, 203, 210, 213, 200, 191, 10, 74, 76, 151, 202, 242, 193, 191, 113, 92, 59, 163, 252, 136, 176, 63},
	{108,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,107,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,108,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,110,155,66,80,215,13,210,63,109,155,66,80,215,13,210,63,79,67,137,199,132,28,160,188,242,40,125,185,157,112,208,63,79,67,137,199,132,28,160,188,245,40,125,185,157,112,208,191,0,0,0,0,0,0,0,128,110,155,66,80,215,13,210,63,85,181,173,194,75,54,221,63,107,155,66,80,215,13,210,63,0,0,0,0,0,0,0,128,110,155,66,80,215,13,210,191,85,181,173,194,75,54,221,191,111,155,66,80,215,13,210,191,202,51,214,228,232,80,198,63,102,93,255,20,175,153,218,63,103,93,255,20,175,153,218,63,202,51,214,228,232,80,198,63,79,67,137,199,132,28,144,60,242,40,125,185,157,112,208,191,79,67,137,199,132,28,144,60,242,40,125,185,157,112,208,63,164,232,107,57,95,34,130,60,110,155,66,80,215,13,210,191,82,181,173,194,75,54,221,191,109,155,66,80,215,13,210,191,164,232,107,57,95,34,130,60,110,155,66,80,215,13,210,63,83,181,173,194,75,54,221,63,111,155,66,80,215,13,210,63,202,51,214,228,232,80,198,191,102,93,255,20,175,153,218,191,103,93,255,20,175,153,218,191,202,51,214,228,232,80,198,191,198,51,214,228,232,80,198,63,70,35,25,122,40,63,129,60,200,51,214,228,232,80,198,191,70,35,25,122,40,63,129,60,99,93,255,20,175,153,218,63,111,155,66,80,215,13,210,63,70,35,25,122,40,63,129,60,111,155,66,80,215,13,210,191,99,93,255,20,175,153,218,191,112,155,66,80,215,13,210,191,70,35,25,122,40,63,129,60,111,155,66,80,215,13,210,63,82,181,173,194,75,54,221,63,239,40,125,185,157,112,208,63,239,40,125,185,157,112,208,191,82,181,173,194,75,54,221,191,198,51,214,228,232,80,198,63,70,35,25,122,40,63,129,60,200,51,214,228,232,80,198,191,70,35,25,122,40,63,129,60,99,93,255,20,175,153,218,63,111,155,66,80,215,13,210,63,70,35,25,122,40,63,129,60,112,155,66,80,215,13,210,191,99,93,255,20,175,153,218,191,112,155,66,80,215,13,210,191,70,35,25,122,40,63,129,60,111,155,66,80,215,13,210,63,82,181,173,194,75,54,221,63,239,40,125,185,157,112,208,63,239,40,125,185,157,112,208,191,82,181,173,194,75,54,221,191,83,181,173,194,75,54,221,63,103,93,255,20,175,153,218,63,83,181,173,194,75,54,221,63,99,93,255,20,175,153,218,63,240,40,125,185,157,112,208,63,111,155,66,80,215,13,210,63,200,51,214,228,232,80,198,63,108,155,66,80,215,13,210,63,240,40,125,185,157,112,208,63,108,155,66,80,215,13,210,63,200,51,214,228,232,80,198,63,108,155,66,80,215,13,210,63,181,48,209,42,180,157,104,60,177,181,180,0,132,87,125,60,177,198,232,148,190,238,166,188,181,48,209,42,180,157,104,60,83,181,173,194,75,54,221,191,102,93,255,20,175,153,218,191,83,181,173,194,75,54,221,191,103,93,255,20,175,153,218,191,240,40,125,185,157,112,208,191,111,155,66,80,215,13,210,191,206,51,214,228,232,80,198,191,110,155,66,80,215,13,210,191,240,40,125,185,157,112,208,191,109,155,66,80,215,13,210,191,202,51,214,228,232,80,198,191,110,155,66,80,215,13,210,191,135,228,28,32,71,118,130,188,68,136,135,0,163,1,150,188,69,136,135,0,163,1,150,188,135,228,28,32,71,118,130,188,195,163,153,49,204,211,176,188,155,116,87,120,67,69,223,63,193,163,153,49,204,211,176,188,158,116,87,120,67,69,223,191,0,0,0,0,0,0,0,128,197,8,228,106,197,78,215,63,195,8,228,106,197,78,215,63,190,8,228,106,197,78,215,63,0,0,0,0,0,0,0,128,192,8,228,106,197,78,215,191,195,8,228,106,197,78,215,191,197,8,228,106,197,78,215,191,233,50,208,94,254,163,99,60,193,59,128,58,224,231,139,60,66,220,240,230,104,207,181,188,233,50,208,94,254,163,99,60,195,163,153,49,204,211,160,188,156,116,87,120,67,69,223,63,193,163,153,49,204,211,160,188,155,116,87,120,67,69,223,191,249,48,206,128,111,81,133,188,197,8,228,106,197,78,215,63,199,8,228,106,197,78,215,63,192,8,228,106,197,78,215,63,249,48,206,128,111,81,133,188,192,8,228,106,197,78,215,191,197,8,228,106,197,78,215,191,197,8,228,106,197,78,215,191,92,76,56,142,253,117,125,60,208,44,224,43,232,237,164,60,210,44,224,43,232,237,164,60,92,76,56,142,253,117,125,60,209,226,68,167,186,181,153,188,96,193,254,99,84,70,132,60,212,226,68,167,186,181,153,60,100,193,254,99,84,70,132,188,0,0,0,0,0,0,0,128,198,8,228,106,197,78,215,63,201,152,153,32,90,3,146,60,195,8,228,106,197,78,215,191,0,0,0,0,0,0,0,128,199,8,228,106,197,78,215,63,201,152,153,32,90,3,146,188,199,8,228,106,197,78,215,191,197,8,228,106,197,78,215,63,152,116,87,120,67,69,223,63,154,116,87,120,67,69,223,191,197,8,228,106,197,78,215,191,209,226,68,167,186,181,137,60,97,193,254,99,84,70,132,188,212,226,68,167,186,181,137,188,96,193,254,99,84,70,132,60,70,35,25,122,40,63,145,60,198,8,228,106,197,78,215,191,200,152,153,32,90,3,146,188,198,8,228,106,197,78,215,63,70,35,25,122,40,63,145,188,199,8,228,106,197,78,215,191,201,152,153,32,90,3,146,60,199,8,228,106,197,78,215,63,197,8,228,106,197,78,215,191,152,116,87,120,67,69,223,191,154,116,87,120,67,69,223,63,197,8,228,106,197,78,215,63,247,28,26,46,58,243,200,191,155,103,140,26,96,47,212,191,244,28,26,46,58,243,200,191,154,103,140,26,96,47,212,191,93,40,120,137,17,162,215,63,35,153,62,110,183,184,152,60,154,103,140,26,96,47,212,191,31,153,62,110,183,184,184,60,93,40,120,137,17,162,215,63,33,153,62,110,183,184,184,60,154,103,140,26,96,47,212,191,35,153,62,110,183,184,152,60,10,187,204,152,126,84,224,63,35,6,94,119,139,149,171,191,56,6,94,119,139,149,171,191,10,187,204,152,126,84,224,63,247,28,26,46,58,243,200,191,155,103,140,26,96,47,212,191,244,28,26,46,58,243,200,191,155,103,140,26,96,47,212,191,93,40,120,137,17,162,215,63,35,153,62,110,183,184,152,60,154,103,140,26,96,47,212,191,33,153,62,110,183,184,184,60,93,40,120,137,17,162,215,63,33,153,62,110,183,184,184,60,154,103,140,26,96,47,212,191,35,153,62,110,183,184,152,60,10,187,204,152,126,84,224,63,35,6,94,119,139,149,171,191,56,6,94,119,139,149,171,191,10,187,204,152,126,84,224,63,194,8,228,106,197,78,215,63,189,33,227,156,16,103,144,60,197,8,228,106,197,78,215,191,187,33,227,156,16,103,144,60,154,116,87,120,67,69,223,63,199,8,228,106,197,78,215,63,44,68,235,221,132,133,123,60,197,8,228,106,197,78,215,191,154,116,87,120,67,69,223,191,197,8,228,106,197,78,215,191,44,68,235,221,132,133,123,60,198,8,228,106,197,78,215,63,212,226,68,167,186,181,121,60,69,35,25,122,40,63,129,60,201,43,209,89,121,245,170,60,212,226,68,167,186,181,121,188,194,8,228,106,197,78,215,191,189,33,227,156,16,103,144,188,197,8,228,106,197,78,215,63,189,33,227,156,16,103,144,188,154,116,87,120,67,69,223,191,199,8,228,106,197,78,215,191,51,68,235,221,132,133,123,188,199,8,228,106,197,78,215,63,154,116,87,120,67,69,223,63,198,8,228,106,197,78,215,63,47,68,235,221,132,133,123,188,198,8,228,106,197,78,215,191,31,170,115,253,75,72,147,188,231,180,37,183,188,222,153,188,232,180,37,183,188,222,153,60,31,170,115,253,75,72,147,60,126,204,164,215,154,130,222,63,152,116,87,120,67,69,207,63,124,204,164,215,154,130,222,63,131,116,87,120,67,69,207,63,219,82,42,100,134,83,195,63,212,226,68,167,186,181,121,60,214,139,243,142,13,15,218,191,205,226,68,167,186,181,121,60,219,82,42,100,134,83,195,63,117,70,92,82,3,127,166,188,214,139,243,142,13,15,218,191,121,70,92,82,3,127,166,188,164,2,197,34,53,206,177,191,183,227,64,238,100,76,217,191,188,227,64,238,100,76,217,191,164,2,197,34,53,206,177,191,126,204,164,215,154,130,222,63,145,116,87,120,67,69,207,63,124,204,164,215,154,130,222,63,152,116,87,120,67,69,207,63,219,82,42,100,134,83,195,63,197,13,139,168,148,17,160,60,208,139,243,142,13,15,218,191,193,13,139,168,148,17,160,60,219,82,42,100,134,83,195,63,27,170,115,253,75,72,147,188,214,139,243,142,13,15,218,191,30,170,115,253,75,72,147,188,164,2,197,34,53,206,177,191,183,227,64,238,100,76,217,191,188,227,64,238,100,76,217,191,164,2,197,34,53,206,177,191,99,91,116,142,253,119,185,188,220,121,222,26,27,206,226,63,97,91,116,142,253,119,185,188,218,121,222,26,27,206,226,191,0,0,0,0,0,0,0,128,24,102,121,2,223,17,205,63,167,61,158,46,146,79,209,191,17,102,121,2,223,17,205,63,0,0,0,0,0,0,0,128,20,102,121,2,223,17,205,191,164,61,158,46,146,79,209,63,25,102,121,2,223,17,205,191,157,69,180,93,38,115,155,191,6,96,230,230,143,62,215,191,8,96,230,230,143,62,215,191,157,69,180,93,38,115,155,191,99,91,116,142,253,119,169,60,220,121,222,26,27,206,226,191,97,91,116,142,253,119,169,60,220,121,222,26,27,206,226,63,187,219,160,69,139,40,130,60,34,102,121,2,223,17,205,191,155,61,158,46,146,79,209,63,29,102,121,2,223,17,205,191,187,219,160,69,139,40,130,60,15,102,121,2,223,17,205,63,162,61,158,46,146,79,209,191,21,102,121,2,223,17,205,63,157,69,180,93,38,115,155,63,6,96,230,230,143,62,215,63,8,96,230,230,143,62,215,63,157,69,180,93,38,115,155,63,149,163,228,22,169,197,175,188,63,78,225,134,180,208,150,60,152,163,228,22,169,197,175,60,66,78,225,134,180,208,150,188,0,0,0,0,0,0,0,128,205,230,68,94,50,205,225,63,120,201,110,148,103,1,145,60,203,230,68,94,50,205,225,191,0,0,0,0,0,0,0,128,205,230,68,94,50,205,225,63,120,201,110,148,103,1,145,188,205,230,68,94,50,205,225,191,98,24,250,79,144,69,120,60,236,10,195,140,102,104,147,60,26,69,41,210,67,86,190,60,98,24,250,79,144,69,120,188,149,163,228,22,169,197,159,188,66,78,225,134,180,208,150,60,152,163,228,22,169,197,159,60,63,78,225,134,180,208,150,188,116,95,162,230,71,253,151,188,205,230,68,94,50,205,225,63,123,201,110,148,103,1,145,60,205,230,68,94,50,205,225,191,116,95,162,230,71,253,151,60,205,230,68,94,50,205,225,63,121,201,110,148,103,1,145,188,205,230,68,94,50,205,225,191,73,146,251,59,44,52,146,60,98,144,36,211,153,28,173,60,100,144,36,211,153,28,173,188,73,146,251,59,44,52,146,188,0,85,104,100,7,232,133,60,88,125,63,139,153,193,206,191,242,84,104,100,7,232,133,60,94,125,63,139,153,193,206,63,0,0,0,0,0,0,0,128,82,152,226,214,114,132,198,63,87,90,211,40,78,83,219,191,93,152,226,214,114,132,198,63,0,0,0,0,0,0,0,128,97,152,226,214,114,132,198,191,87,90,211,40,78,83,219,63,84,152,226,214,114,132,198,191,146,108,219,200,111,141,225,63,200,223,184,251,38,2,195,63,192,223,184,251,38,2,195,63,146,108,219,200,111,141,225,63,0,85,104,100,7,232,117,188,89,125,63,139,153,193,206,63,242,84,104,100,7,232,117,188,88,125,63,139,153,193,206,191,241,114,231,221,117,52,150,60,82,152,226,214,114,132,198,191,85,90,211,40,78,83,219,63,95,152,226,214,114,132,198,191,241,114,231,221,117,52,150,60,96,152,226,214,114,132,198,63,87,90,211,40,78,83,219,191,83,152,226,214,114,132,198,63,146,108,219,200,111,141,225,191,200,223,184,251,38,2,195,191,192,223,184,251,38,2,195,191,146,108,219,200,111,141,225,191,53,13,124,15,25,36,212,191,25,143,229,245,50,194,147,188,54,13,124,15,25,36,212,63,24,143,229,245,50,194,147,188,68,0,211,109,196,28,201,63,62,102,141,14,167,98,210,191,24,143,229,245,50,194,147,188,56,102,141,14,167,98,210,63,68,0,211,109,196,28,201,191,58,102,141,14,167,98,210,63,24,143,229,245,50,194,147,188,62,102,141,14,167,98,210,191,245,203,136,88,50,107,222,63,160,248,76,100,251,80,212,191,162,248,76,100,251,80,212,63,245,203,136,88,50,107,222,191,53,13,124,15,25,36,212,191,25,143,229,245,50,194,147,188,54,13,124,15,25,36,212,63,25,143,229,245,50,194,147,188,68,0,211,109,196,28,201,63,62,102,141,14,167,98,210,191,24,143,229,245,50,194,147,188,58,102,141,14,167,98,210,63,68,0,211,109,196,28,201,191,58,102,141,14,167,98,210,63,24,143,229,245,50,194,147,188,62,102,141,14,167,98,210,191,245,203,136,88,50,107,222,63,160,248,76,100,251,80,212,191,162,248,76,100,251,80,212,63,245,203,136,88,50,107,222,191,249,174,28,56,12,220,195,191,140,46,124,67,224,225,216,191,236,174,28,56,12,220,195,191,137,46,124,67,224,225,216,191,157,246,141,132,86,33,228,63,83,152,226,214,114,132,198,63,60,208,82,15,240,223,196,191,94,152,226,214,114,132,198,63,157,246,141,132,86,33,228,63,94,152,226,214,114,132,198,63,59,208,82,15,240,223,196,191,81,152,226,214,114,132,198,63,251,174,31,21,140,92,131,60,245,173,179,33,173,247,100,60,3,106,130,87,49,99,144,188,251,174,31,21,140,92,131,60,249,174,28,56,12,220,195,63,140,46,124,67,224,225,216,63,236,174,28,56,12,220,195,63,140,46,124,67,224,225,216,63,157,246,141,132,86,33,228,191,84,152,226,214,114,132,198,191,65,208,82,15,240,223,196,63,97,152,226,214,114,132,198,191,157,246,141,132,86,33,228,191,95,152,226,214,114,132,198,191,61,208,82,15,240,223,196,63,82,152,226,214,114,132,198,191,121,134,175,31,210,10,157,188,239,132,141,178,131,115,127,188,226,132,141,178,131,115,127,188,121,134,175,31,210,10,157,188,250,159,40,1,179,205,220,63,62,78,225,134,180,208,134,60,252,159,40,1,179,205,220,191,47,78,225,134,180,208,134,60,106,102,221,205,121,191,213,63,103,151,231,238,224,162,131,60,139,22,17,27,65,3,147,188,102,151,231,238,224,162,131,188,106,102,221,205,121,191,213,191,123,164,10,209,132,46,177,60,139,22,17,27,65,3,147,188,123,164,10,209,132,46,177,188,96,114,199,69,1,1,198,191,234,3,173,186,46,152,225,191,235,3,173,186,46,152,225,63,96,114,199,69,1,1,198,63,250,159,40,1,179,205,220,63,56,78,225,134,180,208,134,60,252,159,40,1,179,205,220,191,62,78,225,134,180,208,134,60,106,102,221,205,121,191,213,63,67,125,161,42,153,139,168,60,135,22,17,27,65,3,147,188,65,125,161,42,153,139,168,188,106,102,221,205,121,191,213,191,26,99,91,102,81,116,157,60,138,22,17,27,65,3,147,188,28,99,91,102,81,116,157,188,96,114,199,69,1,1,198,191,234,3,173,186,46,152,225,191,235,3,173,186,46,152,225,63,96,114,199,69,1,1,198,63,114,170,84,104,17,201,222,63,1,40,72,10,103,33,171,191,111,170,84,104,17,201,222,63,211,40,72,10,103,33,171,191,106,29,27,219,242,242,181,63,24,102,121,2,223,17,205,191,131,26,219,10,218,199,224,191,14,102,121,2,223,17,205,191,106,29,27,219,242,242,181,63,15,102,121,2,223,17,205,191,131,26,219,10,218,199,224,191,21,102,121,2,223,17,205,191,52,155,10,188,139,181,86,188,90,87,212,26,227,58,147,188,30,213,139,131,51,215,196,60,52,155,10,188,139,181,86,188,114,170,84,104,17,201,222,191,119,40,72,10,103,33,171,63,111,170,84,104,17,201,222,191,30,40,72,10,103,33,171,63,106,29,27,219,242,242,181,191,14,102,121,2,223,17,205,63,134,26,219,10,218,199,224,63,7,102,121,2,223,17,205,63,106,29,27,219,242,242,181,191,20,102,121,2,223,17,205,63,133,26,219,10,218,199,224,63,25,102,121,2,223,17,205,63,104,244,7,205,40,8,113,60,7,131,62,168,84,216,172,60,11,131,62,168,84,216,172,60,104,244,7,205,40,8,113,60,49,163,79,164,215,210,192,188,81,105,164,33,122,5,224,63,49,163,79,164,215,210,192,188,73,105,164,33,122,5,224,191,0,0,0,0,0,0,0,128,100,151,231,238,224,162,131,60,148,44,6,210,25,231,227,191,95,151,231,238,224,162,131,60,0,0,0,0,0,0,0,128,116,164,10,209,132,46,177,60,148,44,6,210,25,231,227,63,119,164,10,209,132,46,177,60,1,82,192,46,75,235,70,188,239,128,53,28,62,34,151,188,35,102,55,116,159,20,194,60,1,82,192,46,75,235,70,188,49,163,79,164,215,210,176,188,79,105,164,33,122,5,224,63,49,163,79,164,215,210,176,188,81,105,164,33,122,5,224,191,202,142,127,50,89,0,123,188,59,125,161,42,153,139,168,60,149,44,6,210,25,231,227,191,57,125,161,42,153,139,168,60,202,142,127,50,89,0,123,188,17,99,91,102,81,116,157,60,148,44,6,210,25,231,227,63,21,99,91,102,81,116,157,60,128,61,16,99,120,48,97,188,179,32,40,149,174,89,177,188,182,32,40,149,174,89,177,188,128,61,16,99,120,48,97,188,235,96,49,11,110,67,187,188,130,158,242,16,102,29,159,60,235,96,49,11,110,67,187,60,127,158,242,16,102,29,159,188,0,0,0,0,0,0,0,128,165,129,168,117,217,44,217,63,111,244,159,75,117,164,140,188,162,129,168,117,217,44,217,191,0,0,0,0,0,0,0,128,165,129,168,117,217,44,217,63,109,244,159,75,117,164,140,60,165,129,168,117,217,44,217,191,50,8,195,71,109,59,179,191,112,44,242,236,151,84,226,191,113,44,242,236,151,84,226,63,50,8,195,71,109,59,179,63,235,96,49,11,110,67,171,60,127,158,242,16,102,29,159,188,235,96,49,11,110,67,171,188,130,158,242,16,102,29,159,60,100,184,198,125,110,43,151,60,174,129,168,117,217,44,217,191,93,244,159,75,117,164,140,60,174,129,168,117,217,44,217,63,100,184,198,125,110,43,151,188,162,129,168,117,217,44,217,191,102,244,159,75,117,164,140,188,162,129,168,117,217,44,217,63,50,8,195,71,109,59,179,63,112,44,242,236,151,84,226,63,113,44,242,236,151,84,226,191,50,8,195,71,109,59,179,191,206,115,132,163,28,91,121,60,38,233,99,248,194,20,219,191,167,115,132,163,28,91,121,60,40,233,99,248,194,20,219,63,0,0,0,0,0,0,0,128,207,52,187,120,213,233,218,63,153,103,140,26,96,47,212,191,214,52,187,120,213,233,218,63,0,0,0,0,0,0,0,128,217,52,187,120,213,233,218,191,153,103,140,26,96,47,212,63,207,52,187,120,213,233,218,191,93,219,163,195,87,185,133,60,243,97,51,14,27,151,134,60,183,139,196,208,224,167,177,188,93,219,163,195,87,185,133,60,206,115,132,163,28,91,105,60,38,233,99,248,194,20,219,191,167,115,132,163,28,91,105,60,38,233,99,248,194,20,219,63,81,106,185,84,95,195,162,188,207,52,187,120,213,233,218,63,158,103,140,26,96,47,212,191,217,52,187,120,213,233,218,63,81,106,185,84,95,195,162,188,217,52,187,120,213,233,218,191,155,103,140,26,96,47,212,63,207,52,187,120,213,233,218,191,134,228,186,210,1,75,160,60,118,137,166,74,84,241,160,60,114,137,166,74,84,241,160,60,134,228,186,210,1,75,160,60,101,68,83,63,158,153,160,60,71,177,131,73,159,159,146,188,102,68,83,63,158,153,160,188,74,177,131,73,159,159,146,60,0,0,0,0,0,0,0,128,49,187,30,39,217,7,195,191,96,213,107,30,204,139,160,188,34,187,30,39,217,7,195,63,0,0,0,0,0,0,0,128,37,187,30,39,217,7,195,191,96,213,107,30,204,139,160,60,50,187,30,39,217,7,195,63,96,213,117,130,128,47,230,63,227,56,199,67,15,102,212,191,233,56,199,67,15,102,212,63,96,213,117,130,128,47,230,191,101,68,83,63,158,153,144,188,72,177,131,73,159,159,146,60,102,68,83,63,158,153,144,60,71,177,131,73,159,159,146,188,10,26,198,128,218,207,149,60,49,187,30,39,217,7,195,63,95,213,107,30,204,139,160,60,36,187,30,39,217,7,195,191,10,26,198,128,218,207,149,188,37,187,30,39,217,7,195,63,96,213,107,30,204,139,160,188,50,187,30,39,217,7,195,191,96,213,117,130,128,47,230,191,227,56,199,67,15,102,212,63,233,56,199,67,15,102,212,191,96,213,117,130,128,47,230,63,31,216,162,1,245,83,155,191,218,238,74,58,146,79,212,63,86,216,162,1,245,83,155,191,217,238,74,58,146,79,212,63,175,132,134,153,40,176,164,191,169,10,163,221,37,16,213,191,217,238,74,58,146,79,212,63,173,10,163,221,37,16,213,191,175,132,134,153,40,176,164,191,175,10,163,221,37,16,213,191,217,238,74,58,146,79,212,63,169,10,163,221,37,16,213,191,251,83,21,209,248,133,215,63,72,30,26,39,141,185,209,191,68,30,26,39,141,185,209,191,251,83,21,209,248,133,215,63,31,216,162,1,245,83,155,191,218,238,74,58,146,79,212,63,86,216,162,1,245,83,155,191,218,238,74,58,146,79,212,63,175,132,134,153,40,176,164,191,169,10,163,221,37,16,213,191,217,238,74,58,146,79,212,63,175,10,163,221,37,16,213,191,175,132,134,153,40,176,164,191,175,10,163,221,37,16,213,191,217,238,74,58,146,79,212,63,169,10,163,221,37,16,213,191,251,83,21,209,248,133,215,63,72,30,26,39,141,185,209,191,68,30,26,39,141,185,209,191,251,83,21,209,248,133,215,63,88,158,148,39,30,25,222,191,111,170,12,191,44,34,158,188,88,158,148,39,30,25,222,63,107,170,12,191,44,34,158,188,204,48,83,149,33,198,227,63,50,187,30,39,217,7,195,191,216,13,232,242,184,71,137,188,35,187,30,39,217,7,195,63,204,48,83,149,33,198,227,191,35,187,30,39,217,7,195,63,215,13,232,242,184,71,137,188,48,187,30,39,217,7,195,191,174,147,139,87,218,120,136,60,232,101,230,201,67,128,118,188,43,108,138,202,6,150,161,188,174,147,139,87,218,120,136,188,88,158,148,39,30,25,222,63,109,170,12,191,44,34,158,60,88,158,148,39,30,25,222,191,111,170,12,191,44,34,158,60,204,48,83,149,33,198,227,191,50,187,30,39,217,7,195,63,223,13,232,242,184,71,137,60,37,187,30,39,217,7,195,191,204,48,83,149,33,198,227,63,36,187,30,39,217,7,195,191,217,13,232,242,184,71,137,60,49,187,30,39,217,7,195,63,195,174,168,193,163,90,162,188,109,204,108,215,50,224,144,60,114,204,108,215,50,224,144,188,195,174,168,193,163,90,162,60,50,5,121,227,158,252,166,191,35,233,99,248,194,20,203,191,16,5,121,227,158,252,166,191,16,233,99,248,194,20,203,191,69,118,94,215,146,2,225,63,164,20,82,24,237,175,125,60,73,66,83,36,77,145,214,63,172,20,82,24,237,175,125,60,69,118,94,215,146,2,225,63,25,210,71,117,239,249,169,188,73,66,83,36,77,145,214,63,15,210,71,117,239,249,169,188,164,33,228,71,185,177,211,191,252,247,138,50,196,122,212,191,247,247,138,50,196,122,212,191,164,33,228,71,185,177,211,191,50,5,121,227,158,252,166,191,28,233,99,248,194,20,203,191,16,5,121,227,158,252,166,191,35,233,99,248,194,20,203,191,69,118,94,215,146,2,225,63,230,76,51,47,244,141,162,60,69,66,83,36,77,145,214,63,237,76,51,47,244,141,162,60,69,118,94,215,146,2,225,63,131,143,61,210,241,67,150,188,72,66,83,36,77,145,214,63,122,143,61,210,241,67,150,188,164,33,228,71,185,177,211,191,252,247,138,50,196,122,212,191,247,247,138,50,196,122,212,191,164,33,228,71,185,177,211,191,53,0,70,111,53,122,224,63,86,202,110,154,234,113,102,188,54,0,70,111,53,122,224,191,4,203,110,154,234,113,102,188,155,251,50,19,165,1,204,63,164,129,168,117,217,44,217,191,190,124,234,202,229,195,155,188,162,129,168,117,217,44,217,63,155,251,50,19,165,1,204,191,162,129,168,117,217,44,217,63,190,124,234,202,229,195,155,188,162,129,168,117,217,44,217,191,190,199,217,222,71,210,111,188,234,30,30,67,88,84,158,188,129,74,192,104,82,111,208,188,190,199,217,222,71,210,111,60,53,0,70,111,53,122,224,191,184,202,110,154,234,113,102,60,54,0,70,111,53,122,224,63,111,202,110,154,234,113,102,60,155,251,50,19,165,1,204,191,155,129,168,117,217,44,217,63,194,124,234,202,229,195,155,60,154,129,168,117,217,44,217,191,155,251,50,19,165,1,204,63,165,129,168,117,217,44,217,191,191,124,234,202,229,195,155,60,165,129,168,117,217,44,217,63,208,85,35,231,181,221,135,60,50,151,86,50,66,191,182,60,50,151,86,50,66,191,182,188,208,85,35,231,181,221,135,188,99,235,0,112,223,128,222,63,253,157,118,50,55,8,216,191,97,235,0,112,223,128,222,63,17,158,118,50,55,8,216,191,214,61,196,213,127,122,168,63,202,230,68,94,50,205,209,191,216,230,68,94,50,205,177,63,197,230,68,94,50,205,209,191,214,61,196,213,127,122,168,63,199,230,68,94,50,205,209,191,219,230,68,94,50,205,177,63,202,230,68,94,50,205,209,191,112,16,245,158,22,199,132,63,62,22,190,55,231,248,212,63,65,22,190,55,231,248,212,63,112,16,245,158,22,199,132,63,99,235,0,112,223,128,222,63,5,158,118,50,55,8,216,191,97,235,0,112,223,128,222,63,253,157,118,50,55,8,216,191,214,61,196,213,127,122,168,63,202,230,68,94,50,205,209,191,154,230,68,94,50,205,177,63,199,230,68,94,50,205,209,191,214,61,196,213,127,122,168,63,199,230,68,94,50,205,209,191,197,230,68,94,50,205,177,63,202,230,68,94,50,205,209,191,112,16,245,158,22,199,132,63,62,22,190,55,231,248,212,63,65,22,190,55,231,248,212,63,112,16,245,158,22,199,132,63},
	{109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186, 159, 85, 245, 102, 152, 219, 191, 225, 235, 66, 150, 7, 163, 161, 63, 90, 169, 164, 50, 199, 27, 162, 63, 14, 196, 74, 135, 122, 55, 194, 191, 44, 68, 21, 17, 242, 101, 218, 191, 21, 162, 71, 55, 214, 177, 207, 63, 26, 232, 59, 33, 193, 102, 211, 63, 220, 133, 84, 228, 161, 169, 211, 191, 23, 114, 85, 25, 244, 85, 201, 191, 30, 248, 113, 98, 192, 45, 190, 63, 25, 39, 100, 137, 221, 112, 208, 191, 205, 228, 94, 132, 58, 168, 196, 191, 210, 119, 65, 84, 111, 222, 210, 63, 92, 191, 226, 113, 164, 251, 203, 191, 43, 232, 123, 102, 181, 205, 215, 191, 238, 7, 228, 189, 203, 92, 222, 63, 122, 218, 222, 183, 107, 53, 184, 63, 40, 88, 242, 127, 255, 203, 222, 191, 244, 58, 242, 50, 24, 16, 218, 191, 94, 201, 102, 86, 232, 111, 206, 63, 79, 217, 119, 76, 234, 202, 194, 191, 154, 136, 184, 81, 31, 198, 204, 191, 215, 253, 139, 30, 51, 226, 214, 63, 54, 130, 86, 24, 150, 9, 193, 63, 26, 110, 233, 37, 144, 133, 151, 191, 111, 47, 185, 162, 9, 183, 194, 63, 19, 84, 103, 36, 192, 188, 215, 191, 146, 106, 16, 22, 139, 49, 203, 191, 154, 150, 181, 186, 175, 161, 215, 63, 171, 112, 175, 226, 88, 205, 208, 63, 159, 4, 21, 244, 30, 214, 219, 63, 254, 169, 20, 178, 133, 29, 214, 63, 138, 18, 181, 31, 23, 61, 155, 63, 86, 165, 157, 46, 46, 213, 220, 63, 154, 116, 87, 120, 67, 69, 223, 63, 247, 121, 104, 172, 18, 111, 203, 191, 238, 62, 103, 170, 43, 229, 195, 63, 148, 51, 1, 28, 141, 219, 220, 191, 53, 195, 214, 78, 164, 98, 217, 63, 38, 156, 70, 58, 179, 19, 184, 191, 89, 104, 18, 51, 205, 255, 205, 63, 141, 162, 214, 14, 114, 66, 211, 191, 45, 238, 113, 78, 202, 255, 209, 191, 207, 195, 5, 8, 202, 88, 209, 191, 176, 20, 122, 219, 242, 95, 217, 63, 100, 237, 252, 229, 57, 118, 196, 63, 33, 19, 112, 91, 133, 191, 217, 63, 253, 242, 92, 173, 234, 117, 202, 63, 168, 255, 214, 104, 242, 137, 206, 63, 12, 119, 75, 92, 152, 231, 159, 191, 69, 50, 139, 120, 191, 35, 152, 63, 136, 201, 167, 214, 64, 126, 178, 191, 248, 207, 171, 150, 176, 91, 217, 63, 130, 84, 48, 176, 193, 97, 175, 191, 223, 42, 74, 63, 174, 234, 189, 191, 111, 57, 135, 172, 59, 233, 159, 191, 217, 195, 0, 220, 68, 148, 221, 191, 184, 56, 241, 89, 179, 34, 208, 63, 160, 241, 191, 85, 185, 212, 149, 63, 80, 37, 206, 188, 70, 242, 193, 191, 86, 184, 50, 139, 241, 78, 215, 191, 12, 154, 102, 140, 202, 76, 221, 191, 128, 62, 216, 108, 150, 77, 212, 191, 111, 108, 185, 148, 67, 223, 213, 191, 98, 112, 181, 116, 145, 82, 212, 191, 161, 156, 4, 202, 77, 40, 218, 63, 240, 188, 221, 188, 248, 155, 174, 191, 251, 157, 136, 119, 244, 158, 209, 63, 212, 140, 15, 254, 166, 225, 194, 63, 193, 247, 251, 28, 96, 79, 199, 63, 0, 0, 0, 0, 0, 0, 0, 128, 6, 202, 129, 5, 251, 25, 220, 63, 25, 192, 158, 136, 98, 171, 197, 63, 36, 93, 136, 121, 240, 174, 199, 63, 214, 253, 234, 211, 139, 30, 210, 63, 16, 125, 79, 217, 132, 77, 221, 191, 168, 124, 159, 15, 117, 238, 189, 191, 240, 217, 186, 192, 179, 220, 210, 63, 5, 36, 251, 20, 65, 168, 208, 191, 38, 153, 163, 172, 230, 9, 209, 191, 168, 36, 245, 164, 226, 87, 202, 191, 131, 183, 111, 64, 246, 145, 220, 191, 204, 39, 243, 238, 3, 181, 186, 63, 65, 122, 196, 226, 92, 98, 218, 191, 175, 48, 193, 28, 227, 182, 211, 63, 32, 22, 177, 6, 6, 229, 219, 63, 239, 47, 48, 59, 11, 57, 212, 191, 161, 152, 31, 125, 182, 134, 183, 191, 249, 76, 94, 170, 153, 68, 209, 191, 228, 241, 230, 144, 127, 242, 173, 191, 160, 140, 57, 63, 82, 39, 207, 63, 27, 55, 23, 154, 154, 62, 219, 63, 4, 90, 189, 97, 78, 153, 174, 191, 174, 122, 2, 105, 43, 152, 214, 63, 210, 183, 9, 31, 155, 68, 213, 191, 75, 35, 234, 178, 249, 183, 220, 191, 181, 253, 245, 226, 92, 203, 212, 191, 119, 62, 115, 112, 61, 142, 182, 191, 85, 211, 39, 155, 100, 150, 151, 63, 191, 21, 160, 59, 144, 188, 209, 63, 237, 92, 123, 81, 82, 57, 164, 63, 107, 237, 79, 7, 243, 235, 170, 63, 104, 251, 207, 84, 150, 114, 203, 63, 208, 127, 130, 228, 253, 179, 202, 191, 51, 30, 35, 214, 68, 195, 221, 63, 226, 47, 159, 28, 106, 37, 170, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 77, 132, 232, 56, 97, 213, 191, 109, 207, 33, 51, 85, 222, 157, 63, 89, 124, 17, 36, 101, 118, 167, 63, 107, 85, 188, 29, 213, 21, 211, 63, 209, 44, 156, 208, 15, 64, 204, 63, 79, 85, 220, 164, 223, 95, 213, 63, 65, 206, 95, 117, 245, 27, 215, 191, 64, 167, 168, 66, 233, 244, 215, 63, 28, 119, 105, 182, 231, 220, 199, 63, 227, 27, 30, 152, 189, 211, 206, 191, 196, 14, 145, 160, 222, 101, 191, 191, 154, 38, 240, 195, 139, 124, 211, 63, 243, 188, 232, 238, 143, 153, 218, 63, 169, 111, 207, 247, 135, 232, 219, 191, 9, 126, 140, 220, 251, 53, 225, 63, 98, 183, 15, 239, 14, 138, 201, 191, 5, 51, 161, 35, 120, 228, 189, 191, 220, 144, 54, 53, 200, 124, 192, 63, 38, 126, 195, 30, 186, 7, 221, 191, 229, 147, 106, 49, 4, 166, 221, 63, 212, 234, 233, 89, 58, 143, 164, 63, 89, 141, 179, 138, 148, 62, 215, 191, 73, 154, 25, 248, 156, 102, 225, 191, 159, 44, 128, 157, 115, 126, 209, 191, 75, 235, 111, 61, 223, 124, 161, 63, 51, 249, 30, 42, 104, 47, 174, 191, 209, 104, 93, 103, 190, 4, 164, 191, 221, 182, 89, 39, 162, 62, 209, 191, 66, 248, 148, 133, 99, 22, 177, 63, 238, 240, 53, 126, 62, 44, 176, 63, 24, 64, 115, 137, 55, 81, 219, 63, 8, 135, 149, 178, 58, 29, 213, 191, 120, 107, 18, 125, 61, 252, 172, 63, 57, 146, 148, 138, 15, 244, 186, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 161, 48, 115, 144, 20, 161, 211, 191, 19, 125, 125, 146, 112, 50, 178, 191, 163, 9, 248, 54, 129, 111, 176, 63, 131, 14, 155, 41, 253, 92, 175, 63, 46, 115, 179, 141, 110, 80, 220, 191, 84, 188, 2, 65, 43, 211, 213, 191, 58, 250, 110, 37, 143, 248, 216, 191, 216, 54, 110, 75, 212, 99, 216, 63, 119, 105, 229, 51, 80, 252, 214, 191, 103, 217, 195, 83, 7, 20, 182, 63, 203, 152, 141, 171, 65, 69, 222, 191, 153, 233, 5, 224, 252, 138, 195, 191, 20, 93, 253, 144, 56, 154, 212, 63, 250, 94, 68, 99, 155, 235, 159, 63, 208, 219, 147, 204, 88, 139, 164, 191, 97, 213, 58, 97, 89, 19, 196, 191, 53, 163, 1, 215, 219, 242, 197, 63, 218, 0, 163, 199, 249, 70, 193, 63, 5, 89, 4, 34, 171, 224, 203, 63, 170, 104, 71, 13, 7, 93, 161, 191, 94, 23, 236, 7, 214, 223, 211, 63, 98, 20, 49, 122, 138, 153, 208, 191, 248, 36, 25, 181, 134, 220, 161, 63, 214, 27, 164, 156, 51, 221, 181, 191, 219, 76, 160, 59, 29, 154, 163, 63, 184, 102, 239, 141, 252, 154, 211, 191, 191, 162, 180, 104, 40, 59, 225, 63, 175, 61, 144, 181, 248, 67, 213, 63, 177, 203, 89, 80, 184, 43, 225, 191, 94, 47, 142, 241, 108, 109, 223, 63, 221, 161, 169, 232, 193, 118, 190, 191, 177, 211, 55, 93, 163, 221, 219, 63, 156, 214, 100, 137, 99, 99, 146, 63, 231, 157, 62, 74, 155, 7, 216, 63, 155, 103, 140, 26, 96, 47, 228, 63, 119, 2, 146, 160, 2, 17, 193, 191, 239, 155, 176, 49, 59, 29, 204, 191, 207, 181, 91, 218, 169, 98, 223, 63, 159, 30, 56, 230, 185, 184, 211, 63, 11, 229, 130, 145, 253, 240, 209, 191, 43, 75, 240, 186, 66, 2, 185, 191, 113, 117, 144, 215, 201, 72, 166, 63, 25, 77, 212, 41, 237, 94, 95, 191, 68, 31, 172, 19, 163, 206, 152, 191, 151, 190, 91, 170, 66, 176, 211, 63, 94, 124, 190, 119, 248, 103, 203, 191, 48, 140, 106, 227, 212, 222, 212, 63, 50, 241, 250, 235, 202, 176, 194, 191, 177, 249, 212, 164, 92, 252, 182, 191, 0, 123, 56, 229, 86, 240, 211, 191, 106, 51, 37, 7, 74, 11, 212, 191, 196, 140, 52, 104, 131, 220, 210, 191, 221, 203, 41, 83, 225, 162, 211, 63, 139, 229, 168, 102, 109, 59, 211, 191, 206, 22, 28, 32, 146, 184, 208, 191, 192, 12, 33, 108, 80, 240, 211, 191, 122, 132, 244, 187, 143, 255, 224, 63, 148, 177, 247, 255, 124, 63, 176, 191, 45, 44, 40, 145, 220, 17, 212, 191, 214, 75, 238, 30, 202, 101, 206, 191, 153, 45, 239, 60, 212, 234, 202, 63, 103, 16, 200, 2, 64, 125, 224, 63, 30, 129, 161, 107, 97, 94, 181, 63, 64, 234, 71, 164, 95, 225, 194, 63, 107, 221, 119, 107, 128, 144, 181, 63, 85, 153, 82, 37, 164, 47, 214, 63, 67, 12, 207, 134, 74, 71, 211, 191, 78, 124, 107, 100, 47, 159, 142, 191, 200, 98, 220, 23, 211, 84, 205, 191, 200, 12, 12, 126, 187, 139, 199, 191, 0, 0, 0, 0, 0, 0, 0, 128, 72, 211, 38, 179, 71, 144, 219, 191, 2, 49, 175, 120, 250, 211, 190, 63, 45, 150, 215, 243, 131, 111, 216, 191, 248, 97, 221, 96, 4, 114, 224, 63, 248, 122, 150, 146, 149, 57, 201, 63, 157, 120, 217, 207, 75, 13, 192, 191, 204, 40, 182, 225, 16, 250, 217, 191, 121, 72, 199, 119, 100, 112, 213, 63, 103, 171, 21, 78, 153, 34, 213, 63, 174, 224, 241, 184, 81, 230, 215, 191, 7, 189, 12, 54, 197, 230, 212, 191, 221, 204, 27, 230, 17, 150, 200, 63, 34, 67, 59, 94, 10, 246, 216, 191, 26, 220, 231, 48, 143, 134, 213, 63, 205, 77, 132, 57, 206, 209, 175, 191, 122, 8, 13, 141, 49, 116, 161, 191, 153, 216, 133, 41, 102, 28, 159, 63, 168, 39, 100, 225, 211, 79, 223, 191, 37, 106, 207, 246, 244, 204, 144, 63, 179, 76, 134, 174, 81, 169, 192, 191, 81, 70, 115, 181, 144, 21, 175, 191, 107, 57, 160, 110, 25, 46, 192, 63, 171, 165, 109, 100, 208, 17, 218, 63, 217, 177, 212, 186, 179, 153, 160, 191, 253, 24, 103, 90, 96, 109, 210, 63, 103, 99, 163, 139, 67, 84, 225, 63, 242, 197, 125, 199, 247, 160, 199, 63, 253, 242, 235, 85, 80, 31, 161, 191, 52, 138, 78, 218, 127, 189, 219, 191, 122, 234, 98, 211, 182, 99, 173, 191, 206, 89, 21, 244, 127, 45, 185, 63, 143, 169, 228, 41, 212, 9, 174, 191, 180, 45, 192, 80, 191, 210, 208, 191, 149, 89, 201, 78, 156, 23, 212, 63, 216, 215, 239, 9, 105, 202, 165, 63, 0, 0, 0, 0, 0, 0, 0, 0, 62, 83, 244, 235, 254, 59, 220, 63, 186, 37, 11, 9, 124, 7, 215, 191, 207, 199, 97, 58, 240, 91, 179, 63, 222, 88, 189, 10, 48, 28, 199, 63, 102, 120, 249, 60, 216, 187, 219, 63, 76, 92, 119, 159, 218, 233, 214, 191, 1, 233, 211, 241, 47, 238, 173, 63, 11, 101, 57, 122, 113, 77, 172, 191, 127, 169, 190, 82, 148, 139, 171, 191, 117, 46, 239, 78, 85, 201, 125, 63, 52, 82, 82, 146, 25, 38, 219, 63, 142, 193, 50, 223, 12, 36, 192, 191, 51, 83, 87, 235, 42, 19, 213, 63, 174, 134, 24, 24, 128, 169, 146, 63, 94, 83, 117, 176, 46, 210, 212, 63, 33, 24, 115, 242, 175, 139, 182, 191, 25, 165, 116, 77, 68, 185, 223, 191, 57, 196, 22, 87, 246, 179, 194, 63, 223, 183, 54, 94, 101, 180, 224, 191, 21, 93, 151, 161, 253, 56, 207, 191, 255, 209, 58, 201, 7, 66, 210, 63, 13, 220, 219, 204, 184, 17, 165, 191, 224, 180, 97, 194, 60, 180, 197, 63, 209, 88, 80, 104, 29, 103, 164, 191, 25, 236, 103, 91, 192, 228, 218, 63, 17, 240, 86, 155, 254, 195, 206, 63, 123, 118, 44, 76, 169, 230, 159, 191, 182, 3, 114, 200, 103, 17, 212, 191, 206, 128, 34, 73, 12, 141, 178, 63, 209, 106, 152, 195, 247, 188, 211, 191, 242, 241, 0, 220, 164, 96, 195, 191, 154, 145, 56, 157, 100, 248, 212, 191, 137, 156, 26, 20, 226, 57, 198, 191, 5, 233, 39, 240, 83, 145, 223, 63, 156, 152, 149, 223, 74, 87, 221, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 245, 125, 206, 55, 230, 203, 63, 228, 24, 41, 123, 31, 29, 146, 63, 73, 78, 59, 31, 113, 233, 165, 63, 195, 47, 219, 158, 237, 10, 220, 191, 63, 112, 115, 145, 4, 62, 209, 63, 189, 210, 42, 29, 159, 242, 207, 63, 39, 84, 231, 106, 192, 217, 197, 63, 70, 89, 64, 95, 148, 133, 199, 191, 57, 143, 150, 14, 54, 135, 182, 191, 76, 99, 76, 99, 48, 73, 214, 63, 88, 151, 68, 50, 184, 46, 166, 63, 236, 110, 251, 73, 17, 71, 217, 191, 229, 40, 157, 140, 165, 223, 210, 63, 56, 147, 95, 81, 236, 121, 226, 191, 170, 250, 118, 129, 248, 104, 211, 191, 232, 56, 114, 115, 29, 173, 222, 191, 233, 176, 105, 59, 53, 166, 185, 63, 247, 102, 13, 107, 160, 60, 225, 63, 190, 14, 33, 72, 43, 12, 153, 191, 160, 157, 11, 20, 211, 191, 226, 63, 187, 219, 97, 99, 241, 124, 128, 63, 240, 215, 248, 63, 161, 136, 215, 191, 129, 140, 155, 57, 219, 140, 215, 63, 14, 229, 123, 102, 87, 68, 217, 63, 70, 53, 215, 57, 83, 207, 162, 191, 48, 133, 137, 196, 88, 41, 87, 63, 251, 38, 133, 133, 158, 83, 208, 63, 57, 50, 32, 165, 97, 124, 201, 191, 122, 213, 135, 44, 32, 122, 207, 191, 240, 149, 156, 0, 186, 156, 180, 191, 26, 41, 27, 194, 190, 218, 188, 191, 206, 53, 107, 44, 220, 248, 147, 63, 240, 242, 88, 134, 0, 83, 182, 63, 90, 180, 180, 245, 228, 117, 220, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 200, 25, 55, 214, 137, 254, 209, 191, 252, 228, 168, 151, 80, 59, 178, 191, 106, 155, 41, 178, 76, 50, 185, 63, 12, 0, 28, 102, 126, 112, 195, 191, 36, 117, 101, 47, 20, 237, 209, 63, 50, 16, 216, 35, 67, 106, 225, 191, 162, 12, 193, 225, 166, 152, 225, 63, 214, 23, 57, 21, 153, 148, 225, 191, 249, 173, 97, 187, 170, 157, 217, 63, 175, 182, 182, 9, 65, 175, 202, 191, 172, 45, 184, 177, 163, 25, 209, 191, 253, 243, 171, 223, 38, 208, 213, 63, 164, 149, 105, 177, 181, 46, 225, 63, 175, 70, 195, 155, 125, 213, 178, 63, 38, 196, 41, 227, 108, 147, 177, 63, 70, 75, 87, 16, 250, 250, 179, 63, 37, 249, 108, 55, 158, 8, 208, 191, 146, 38, 195, 128, 113, 227, 165, 191, 43, 80, 26, 115, 206, 94, 210, 63, 52, 246, 192, 96, 39, 3, 180, 191, 198, 255, 16, 131, 255, 185, 185, 191, 141, 182, 67, 94, 191, 187, 223, 191, 235, 14, 76, 67, 4, 18, 176, 191, 103, 142, 87, 247, 37, 144, 202, 63, 223, 142, 221, 3, 98, 62, 177, 191, 193, 68, 147, 147, 26, 181, 194, 63, 45, 226, 139, 55, 171, 49, 177, 63, 237, 8, 49, 216, 144, 233, 223, 63, 84, 7, 118, 26, 146, 97, 189, 191, 193, 150, 156, 91, 119, 229, 193, 63, 4, 74, 1, 42, 194, 175, 193, 191, 22, 162, 21, 124, 136, 122, 223, 191, 27, 30, 120, 104, 6, 39, 167, 63, 100, 56, 49, 154, 61, 148, 186, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 16, 62, 200, 221, 20, 129, 201, 63, 161, 207, 206, 159, 63, 224, 186, 63, 40, 111, 7, 234, 32, 112, 179, 63, 180, 159, 45, 105, 65, 196, 187, 63, 131, 242, 153, 95, 83, 183, 173, 191, 0, 35, 109, 155, 133, 149, 202, 63, 126, 188, 78, 243, 156, 212, 199, 63, 74, 25, 14, 155, 121, 208, 195, 191, 61, 153, 67, 127, 219, 41, 219, 191, 37, 194, 162, 184, 208, 61, 170, 191, 222, 213, 139, 6, 155, 96, 226, 191, 214, 129, 97, 83, 245, 57, 144, 63, 210, 50, 236, 74, 23, 35, 171, 63, 219, 90, 117, 211, 187, 164, 201, 63, 125, 36, 82, 59, 204, 1, 214, 63, 60, 196, 28, 41, 31, 76, 217, 191, 165, 158, 7, 30, 0, 232, 201, 63, 227, 187, 11, 31, 138, 138, 218, 63, 208, 16, 169, 202, 7, 104, 209, 63, 186, 15, 15, 253, 105, 228, 203, 191, 183, 225, 237, 33, 67, 136, 222, 191, 84, 254, 183, 170, 38, 213, 177, 191, 224, 222, 124, 11, 174, 51, 213, 191, 241, 148, 25, 50, 78, 192, 178, 191, 135, 166, 9, 253, 65, 143, 163, 191, 164, 43, 16, 198, 154, 171, 221, 63, 104, 34, 143, 222, 217, 152, 216, 191, 247, 94, 25, 26, 145, 100, 210, 191, 28, 91, 7, 93, 173, 147, 216, 63, 143, 197, 122, 153, 134, 162, 227, 63, 5, 98, 133, 188, 229, 22, 216, 191, 117, 130, 136, 139, 69, 80, 200, 63, 30, 75, 75, 124, 57, 188, 139, 191, 14, 65, 125, 118, 115, 121, 192, 191, 176, 104, 7, 252, 30, 226, 231, 63, 243, 254, 38, 94, 166, 89, 213, 63, 188, 166, 210, 215, 212, 242, 210, 191, 121, 76, 113, 86, 214, 186, 219, 191, 25, 253, 216, 84, 30, 226, 182, 63, 111, 219, 29, 20, 87, 225, 201, 63, 139, 255, 152, 49, 97, 48, 213, 191, 142, 130, 95, 116, 207, 58, 208, 63, 20, 147, 210, 219, 243, 119, 210, 63, 103, 50, 97, 174, 123, 92, 211, 63, 154, 133, 102, 161, 128, 169, 182, 63, 251, 175, 131, 196, 130, 66, 211, 191, 253, 41, 54, 226, 18, 172, 190, 63, 77, 152, 7, 22, 51, 69, 213, 191, 102, 232, 137, 18, 71, 21, 213, 191, 53, 168, 251, 219, 222, 38, 178, 63, 250, 56, 237, 185, 82, 140, 171, 191, 62, 224, 99, 193, 43, 106, 196, 63, 243, 221, 119, 24, 28, 80, 182, 63, 226, 235, 92, 84, 55, 129, 193, 63, 250, 254, 247, 147, 147, 1, 207, 63, 171, 242, 180, 42, 202, 39, 178, 63, 121, 30, 149, 163, 160, 165, 224, 191, 22, 254, 158, 65, 162, 144, 212, 191, 76, 179, 67, 15, 95, 238, 168, 191, 221, 65, 107, 238, 17, 189, 209, 63, 90, 128, 199, 220, 16, 160, 175, 63, 191, 33, 47, 199, 59, 25, 223, 191, 118, 20, 41, 68, 216, 171, 203, 63, 239, 212, 252, 4, 53, 129, 194, 63, 177, 199, 80, 222, 131, 146, 203, 63, 30, 5, 169, 49, 162, 235, 195, 63, 116, 101, 13, 3, 158, 24, 193, 63, 39, 10, 9, 173, 244, 1, 211, 191, 19, 34, 203, 197, 106, 88, 210, 191, 237, 197, 100, 137, 165, 133, 212, 191, 0, 0, 0, 0, 0, 0, 0, 128, 136, 77, 107, 124, 192, 228, 143, 191, 60, 217, 212, 1, 5, 7, 180, 191, 220, 89, 117, 215, 132, 11, 226, 63, 117, 132, 11, 146, 25, 115, 227, 63, 65, 250, 91, 176, 13, 85, 214, 63, 17, 197, 142, 207, 194, 216, 144, 191, 119, 81, 191, 112, 50, 164, 207, 63, 12, 20, 125, 71, 189, 117, 196, 191, 27, 133, 200, 105, 143, 43, 193, 191, 79, 203, 59, 143, 101, 62, 220, 191, 247, 149, 36, 233, 191, 215, 200, 63, 84, 247, 212, 194, 79, 218, 205, 63, 116, 184, 99, 55, 159, 185, 164, 63, 2, 166, 31, 14, 100, 90, 172, 63, 218, 111, 81, 130, 1, 144, 217, 191, 84, 32, 36, 9, 81, 178, 210, 63, 200, 131, 57, 193, 253, 153, 179, 63, 147, 10, 158, 164, 149, 122, 226, 191, 227, 188, 153, 96, 24, 207, 169, 63, 135, 94, 165, 141, 103, 206, 196, 191, 131, 104, 17, 71, 114, 247, 216, 191, 208, 214, 154, 69, 92, 219, 200, 191, 30, 124, 210, 24, 121, 1, 188, 63, 45, 182, 85, 46, 123, 180, 211, 63, 208, 97, 110, 45, 125, 155, 207, 63, 208, 123, 235, 141, 170, 74, 225, 191, 46, 248, 33, 6, 45, 225, 209, 191, 93, 99, 47, 171, 26, 113, 152, 63, 202, 226, 53, 143, 47, 254, 215, 63, 137, 44, 103, 208, 106, 8, 165, 63, 128, 189, 202, 222, 226, 117, 191, 63, 6, 125, 239, 249, 194, 192, 199, 191, 153, 46, 45, 115, 123, 91, 189, 191, 133, 109, 209, 47, 47, 78, 206, 191, 79, 226, 79, 192, 243, 224, 141, 191, 0, 0, 0, 0, 0, 0, 0, 0, 185, 204, 29, 67, 74, 98, 224, 191, 19, 241, 1, 124, 239, 97, 211, 191, 176, 202, 115, 107, 51, 162, 199, 191, 20, 28, 240, 228, 108, 209, 216, 63, 68, 101, 72, 203, 150, 63, 204, 191, 27, 78, 80, 46, 80, 20, 221, 191, 180, 133, 253, 117, 215, 98, 184, 191, 225, 89, 5, 184, 249, 140, 181, 63, 61, 59, 63, 191, 193, 54, 180, 63, 104, 102, 150, 3, 126, 249, 143, 63, 163, 22, 210, 125, 38, 128, 215, 63, 212, 135, 0, 210, 217, 148, 209, 191, 71, 154, 166, 111, 82, 151, 215, 63, 18, 48, 67, 185, 39, 28, 152, 63, 73, 143, 133, 34, 39, 26, 172, 191, 123, 35, 17, 171, 23, 6, 135, 191, 220, 93, 115, 14, 149, 209, 200, 63, 151, 52, 145, 76, 81, 16, 212, 63, 155, 58, 250, 135, 70, 45, 198, 63, 176, 203, 130, 143, 249, 193, 195, 63, 144, 7, 163, 25, 207, 165, 168, 191, 6, 68, 253, 196, 73, 93, 186, 63, 73, 23, 213, 187, 99, 161, 205, 63, 229, 233, 3, 96, 194, 215, 114, 191, 181, 253, 82, 125, 244, 106, 212, 191, 130, 134, 158, 72, 15, 86, 222, 191, 252, 197, 223, 142, 85, 197, 179, 63, 200, 238, 24, 65, 139, 60, 225, 63, 174, 243, 247, 249, 53, 42, 193, 191, 35, 252, 169, 205, 45, 248, 224, 63, 241, 176, 236, 158, 75, 113, 213, 191, 209, 136, 11, 72, 136, 39, 187, 63, 253, 197, 254, 97, 117, 145, 208, 191, 145, 62, 69, 22, 20, 55, 217, 63, 240, 76, 84, 252, 251, 238, 220, 191, 0, 0, 0, 0, 0, 0, 0, 128, 119, 224, 217, 175, 236, 103, 219, 63, 101, 175, 192, 11, 77, 255, 220, 191, 211, 18, 52, 114, 42, 102, 157, 63, 253, 73, 9, 185, 164, 2, 188, 63, 50, 148, 25, 251, 253, 16, 214, 191, 150, 116, 180, 172, 83, 205, 210, 63, 183, 131, 100, 196, 112, 134, 194, 191, 94, 197, 69, 188, 168, 133, 209, 63, 177, 95, 147, 142, 15, 76, 210, 63, 98, 203, 85, 208, 62, 9, 180, 63, 115, 24, 70, 69, 100, 198, 214, 191, 6, 141, 116, 140, 130, 70, 185, 191, 105, 121, 27, 189, 66, 130, 200, 191, 117, 28, 162, 1, 213, 138, 208, 191, 167, 82, 143, 30, 129, 75, 186, 63, 166, 146, 2, 117, 146, 30, 224, 63, 36, 129, 134, 179, 77, 214, 211, 63, 147, 41, 104, 200, 225, 15, 176, 191, 218, 68, 236, 130, 176, 45, 202, 63, 5, 159, 195, 127, 82, 68, 225, 191, 96, 124, 85, 23, 109, 139, 153, 63, 56, 100, 84, 228, 167, 233, 146, 63, 3, 107, 197, 12, 151, 167, 168, 191, 131, 14, 252, 15, 185, 97, 221, 63, 252, 243, 238, 37, 191, 135, 213, 191, 80, 211, 193, 232, 52, 224, 197, 191, 228, 143, 110, 58, 244, 185, 153, 63, 25, 84, 122, 207, 174, 150, 168, 191, 84, 148, 157, 226, 214, 7, 181, 191, 184, 118, 122, 159, 141, 215, 180, 191, 20, 224, 117, 7, 48, 200, 171, 191, 17, 107, 210, 5, 105, 26, 226, 191, 79, 209, 108, 87, 7, 65, 213, 63, 113, 10, 180, 3, 180, 30, 224, 63, 7, 24, 161, 213, 216, 11, 196, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 73, 204, 209, 76, 34, 224, 63, 130, 54, 28, 44, 161, 242, 130, 63, 42, 120, 78, 214, 145, 196, 161, 63, 73, 50, 113, 106, 61, 88, 225, 63, 244, 101, 12, 53, 40, 54, 213, 191, 236, 193, 135, 213, 180, 246, 180, 63, 91, 69, 30, 107, 172, 110, 181, 63, 132, 88, 119, 181, 177, 159, 181, 191, 34, 39, 216, 24, 173, 74, 119, 63, 228, 29, 25, 84, 189, 108, 219, 191, 120, 40, 46, 94, 86, 155, 176, 63, 195, 21, 46, 97, 35, 234, 218, 63, 114, 199, 215, 66, 69, 68, 160, 63, 102, 68, 34, 160, 141, 10, 227, 191, 14, 55, 10, 161, 52, 110, 201, 191, 170, 118, 217, 23, 153, 140, 218, 63, 224, 143, 33, 209, 251, 81, 178, 191, 11, 148, 150, 24, 212, 12, 210, 191, 74, 99, 71, 71, 148, 179, 221, 63, 121, 234, 32, 182, 4, 189, 225, 63, 86, 73, 56, 31, 148, 99, 124, 191, 72, 107, 78, 148, 33, 136, 208, 191, 143, 164, 228, 0, 119, 68, 183, 63, 47, 150, 250, 71, 107, 213, 222, 191, 244, 108, 124, 214, 89, 161, 161, 63, 58, 21, 52, 3, 225, 141, 127, 63, 104, 209, 18, 75, 20, 84, 170, 63, 100, 208, 45, 232, 58, 247, 180, 191, 3, 177, 68, 177, 166, 26, 182, 191, 31, 136, 240, 142, 232, 137, 164, 191, 6, 23, 15, 236, 132, 197, 226, 191, 152, 243, 103, 182, 121, 193, 206, 63, 247, 223, 58, 244, 186, 251, 189, 63, 24, 250, 138, 136, 43, 234, 201, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 228, 87, 100, 151, 29, 160, 202, 63, 26, 140, 218, 8, 246, 18, 169, 191, 162, 79, 152, 172, 149, 174, 186, 63, 90, 191, 206, 254, 151, 49, 208, 63, 154, 167, 41, 161, 215, 207, 216, 63, 24, 174, 118, 64, 211, 131, 221, 191, 27, 32, 190, 147, 154, 221, 210, 191, 44, 131, 242, 49, 143, 146, 211, 63, 59, 159, 255, 254, 201, 107, 203, 191, 204, 75, 64, 48, 196, 223, 213, 63, 82, 21, 1, 198, 197, 101, 187, 63, 46, 170, 150, 158, 199, 10, 224, 191, 107, 134, 119, 151, 226, 165, 219, 63, 219, 12, 136, 105, 193, 70, 188, 63, 121, 140, 188, 57, 198, 121, 166, 191, 21, 104, 117, 33, 105, 54, 203, 63, 48, 46, 240, 99, 20, 51, 207, 63, 231, 200, 125, 168, 127, 242, 201, 191, 186, 113, 184, 44, 235, 248, 145, 63, 38, 3, 27, 251, 52, 179, 188, 191, 209, 74, 33, 201, 244, 100, 151, 191, 159, 128, 223, 207, 11, 55, 226, 191, 15, 76, 131, 20, 102, 169, 168, 63, 248, 74, 174, 203, 86, 192, 213, 191, 184, 116, 141, 71, 218, 7, 181, 63, 229, 145, 144, 46, 197, 70, 112, 191, 176, 233, 156, 183, 30, 205, 223, 191, 159, 5, 158, 68, 50, 189, 218, 63, 23, 252, 37, 104, 98, 175, 222, 63, 116, 88, 46, 235, 223, 220, 201, 191, 42, 188, 65, 105, 230, 46, 165, 63, 56, 245, 100, 101, 162, 225, 160, 63, 218, 125, 142, 35, 40, 56, 180, 63, 80, 6, 23, 216, 179, 210, 223, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 119, 37, 187, 38, 153, 181, 63, 130, 183, 11, 39, 190, 10, 192, 63, 178, 147, 140, 121, 139, 90, 194, 63, 72, 96, 20, 160, 163, 123, 200, 191, 249, 221, 56, 225, 131, 224, 189, 63, 69, 77, 51, 193, 67, 164, 222, 63, 234, 48, 119, 236, 149, 102, 218, 191, 241, 15, 30, 248, 192, 241, 215, 63, 104, 26, 153, 147, 173, 165, 226, 63, 191, 210, 147, 40, 155, 197, 170, 63, 11, 90, 139, 160, 202, 118, 217, 191, 209, 61, 14, 136, 209, 20, 177, 63, 213, 202, 119, 207, 62, 211, 206, 63, 33, 249, 31, 169, 58, 123, 215, 63, 217, 94, 66, 63, 9, 83, 221, 191, 195, 2, 41, 58, 190, 187, 194, 63, 187, 234, 187, 175, 218, 81, 215, 191, 187, 141, 56, 26, 79, 105, 185, 191, 202, 13, 205, 102, 165, 37, 206, 63, 36, 247, 106, 101, 249, 241, 216, 191, 61, 151, 214, 92, 147, 109, 199, 63, 43, 178, 184, 161, 90, 99, 209, 191, 230, 145, 147, 85, 202, 188, 221, 63, 155, 105, 197, 48, 182, 171, 185, 63, 18, 247, 193, 88, 171, 224, 181, 63, 242, 123, 169, 174, 86, 208, 208, 191, 236, 134, 115, 207, 35, 233, 176, 191, 46, 170, 131, 43, 212, 26, 226, 191, 224, 26, 118, 99, 252, 243, 188, 63, 119, 16, 158, 30, 55, 76, 203, 63, 10, 163, 50, 161, 157, 45, 213, 191, 61, 90, 162, 214, 155, 91, 214, 191, 141, 170, 51, 94, 48, 44, 146, 191, 224, 58, 131, 8, 3, 154, 100, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 11, 73, 251, 213, 139, 219, 63, 184, 78, 157, 201, 251, 127, 192, 191, 197, 5, 238, 108, 57, 60, 176, 63, 234, 227, 44, 76, 124, 81, 186, 191, 95, 67, 88, 70, 51, 23, 216, 63, 233, 200, 208, 36, 1, 109, 178, 63, 241, 163, 202, 123, 104, 210, 196, 63, 202, 212, 54, 58, 162, 68, 201, 191, 244, 44, 141, 72, 210, 166, 214, 191, 249, 124, 229, 88, 1, 110, 190, 191, 164, 14, 186, 144, 130, 46, 224, 191, 248, 44, 155, 36, 34, 232, 196, 63, 13, 172, 211, 111, 166, 202, 208, 191, 69, 198, 140, 238, 225, 10, 173, 191, 144, 148, 91, 73, 199, 196, 178, 63, 228, 230, 206, 11, 3, 128, 209, 63, 0, 68, 36, 64, 111, 140, 197, 63, 208, 99, 220, 101, 43, 147, 206, 191, 42, 31, 225, 206, 110, 48, 214, 191, 115, 152, 133, 215, 134, 152, 175, 63, 138, 141, 9, 137, 141, 219, 227, 63, 44, 1, 8, 157, 149, 25, 199, 63, 82, 64, 13, 162, 121, 85, 176, 191, 205, 186, 232, 217, 137, 57, 192, 63, 152, 116, 2, 100, 105, 88, 149, 63, 169, 251, 133, 10, 233, 225, 226, 191, 179, 149, 23, 82, 163, 150, 144, 191, 142, 57, 207, 43, 229, 29, 182, 63, 162, 89, 123, 110, 205, 64, 141, 63, 215, 84, 57, 156, 123, 67, 226, 63, 85, 63, 113, 73, 95, 1, 203, 63, 78, 213, 76, 102, 13, 135, 202, 191, 135, 227, 79, 156, 206, 152, 154, 191, 8, 135, 39, 56, 12, 214, 221, 191, 36, 233, 99, 248, 194, 20, 235, 63, 180, 48, 195, 189, 167, 254, 195, 191, 206, 67, 18, 34, 20, 120, 161, 63, 69, 9, 87, 217, 165, 50, 211, 63, 18, 99, 206, 38, 17, 66, 197, 191, 235, 167, 147, 55, 156, 56, 202, 63, 57, 120, 125, 151, 252, 192, 203, 191, 231, 158, 145, 194, 76, 163, 214, 191, 202, 67, 34, 95, 132, 248, 212, 191, 254, 123, 20, 170, 137, 192, 211, 191, 199, 180, 219, 14, 145, 96, 197, 191, 240, 56, 154, 253, 11, 142, 148, 63, 206, 132, 128, 239, 144, 241, 192, 191, 26, 210, 52, 238, 98, 232, 192, 191, 249, 146, 180, 140, 198, 74, 205, 191, 70, 85, 124, 40, 37, 125, 211, 63, 150, 145, 254, 237, 220, 214, 211, 63, 168, 102, 220, 250, 244, 247, 207, 63, 65, 58, 137, 198, 159, 144, 197, 191, 35, 14, 240, 210, 93, 44, 209, 63, 204, 115, 208, 20, 77, 239, 194, 63, 52, 82, 45, 167, 15, 125, 211, 63, 27, 200, 111, 55, 171, 72, 220, 63, 86, 246, 154, 32, 30, 248, 208, 191, 52, 131, 226, 121, 204, 236, 211, 63, 126, 127, 138, 172, 180, 197, 180, 63, 82, 133, 10, 129, 180, 99, 211, 191, 232, 11, 50, 167, 244, 162, 216, 63, 254, 167, 166, 15, 97, 51, 215, 191, 96, 162, 20, 105, 47, 87, 214, 191, 135, 45, 15, 27, 7, 52, 215, 191, 176, 111, 56, 235, 210, 42, 183, 191, 196, 144, 113, 180, 187, 82, 209, 63, 91, 210, 225, 241, 103, 74, 212, 191, 84, 242, 145, 63, 114, 34, 174, 63, 18, 214, 166, 68, 252, 166, 170, 191, 0, 0, 0, 0, 0, 0, 0, 128, 55, 246, 102, 236, 21, 231, 219, 63, 36, 24, 187, 95, 132, 161, 197, 191, 179, 117, 56, 205, 28, 40, 230, 191, 116, 10, 25, 192, 180, 62, 224, 63, 54, 230, 209, 104, 217, 42, 213, 191, 255, 22, 79, 232, 164, 80, 187, 63, 171, 40, 159, 191, 92, 238, 181, 63, 138, 8, 171, 251, 120, 224, 193, 191, 109, 118, 69, 71, 103, 229, 197, 191, 17, 55, 0, 115, 109, 141, 215, 191, 103, 108, 64, 120, 202, 206, 220, 63, 21, 109, 40, 193, 57, 73, 202, 63, 166, 67, 85, 34, 252, 179, 218, 63, 27, 43, 123, 233, 69, 139, 209, 191, 48, 93, 149, 68, 104, 243, 188, 63, 88, 199, 43, 142, 2, 228, 175, 63, 18, 228, 12, 111, 161, 30, 171, 191, 133, 243, 189, 193, 181, 189, 222, 191, 38, 41, 78, 207, 60, 187, 157, 191, 69, 25, 90, 154, 246, 133, 202, 63, 184, 211, 237, 59, 28, 72, 188, 63, 43, 188, 84, 193, 156, 42, 208, 63, 172, 200, 182, 93, 148, 35, 210, 191, 91, 20, 177, 224, 132, 92, 174, 63, 113, 150, 14, 48, 73, 89, 219, 191, 86, 181, 93, 42, 208, 222, 210, 63, 196, 33, 58, 47, 233, 193, 214, 63, 61, 140, 27, 25, 213, 123, 80, 63, 190, 148, 64, 63, 198, 217, 188, 191, 229, 106, 42, 194, 234, 8, 89, 63, 213, 132, 108, 17, 107, 67, 189, 63, 120, 187, 1, 98, 207, 160, 186, 63, 195, 126, 184, 140, 235, 3, 192, 63, 211, 194, 143, 13, 195, 15, 221, 191, 22, 33, 42, 237, 88, 14, 171, 191, 0, 0, 0, 0, 0, 0, 0, 0, 189, 200, 148, 140, 39, 247, 192, 63, 51, 100, 124, 124, 186, 67, 183, 63, 29, 255, 43, 59, 137, 203, 212, 63, 234, 137, 82, 188, 250, 19, 226, 63, 31, 47, 67, 123, 232, 201, 209, 191, 145, 187, 20, 158, 162, 59, 200, 191, 75, 55, 16, 66, 27, 116, 181, 63, 140, 1, 188, 86, 183, 42, 176, 191, 63, 165, 158, 244, 242, 135, 171, 191, 58, 149, 19, 215, 168, 70, 151, 63, 128, 181, 147, 217, 213, 147, 183, 191, 17, 24, 136, 91, 68, 46, 218, 191, 102, 245, 52, 103, 64, 121, 178, 63, 95, 190, 174, 42, 101, 160, 133, 63, 119, 89, 220, 128, 174, 132, 209, 191, 50, 82, 19, 197, 250, 52, 179, 63, 196, 89, 123, 146, 11, 69, 215, 63, 207, 144, 62, 244, 97, 46, 221, 63, 115, 106, 221, 56, 6, 191, 217, 63, 93, 62, 55, 104, 64, 54, 192, 63, 217, 230, 38, 156, 33, 185, 206, 191, 163, 166, 231, 209, 70, 2, 200, 191, 102, 45, 250, 68, 93, 60, 192, 63, 4, 114, 204, 72, 17, 111, 161, 63, 244, 186, 58, 212, 93, 187, 195, 191, 191, 78, 122, 81, 134, 62, 227, 63, 145, 138, 199, 93, 3, 197, 193, 191, 228, 196, 49, 249, 213, 243, 224, 191, 87, 135, 149, 104, 236, 121, 195, 63, 70, 169, 242, 5, 227, 184, 224, 191, 216, 161, 146, 84, 121, 90, 224, 191, 64, 96, 153, 46, 241, 65, 208, 63, 102, 153, 129, 127, 7, 137, 199, 191, 186, 108, 226, 254, 169, 202, 195, 191, 143, 145, 93, 212, 51, 109, 134, 63, 0, 0, 0, 0, 0, 0, 0, 128, 0, 32, 226, 217, 86, 8, 226, 191, 173, 212, 109, 96, 93, 172, 219, 191, 222, 75, 115, 16, 17, 89, 180, 191, 61, 245, 84, 74, 211, 13, 209, 63, 25, 173, 106, 97, 54, 124, 201, 63, 115, 217, 184, 80, 116, 14, 219, 63, 223, 78, 145, 148, 78, 29, 209, 63, 137, 137, 39, 22, 197, 65, 222, 191, 78, 216, 251, 244, 55, 115, 222, 191, 21, 168, 232, 133, 67, 99, 200, 63, 66, 72, 231, 205, 167, 90, 214, 191, 42, 71, 235, 2, 182, 55, 207, 191, 163, 250, 212, 246, 193, 27, 207, 191, 10, 225, 247, 83, 156, 59, 216, 191, 189, 11, 228, 65, 1, 31, 148, 191, 19, 51, 93, 150, 83, 170, 178, 63, 28, 63, 123, 6, 232, 152, 193, 191, 193, 97, 158, 137, 168, 137, 195, 191, 87, 8, 215, 52, 40, 180, 179, 191, 119, 54, 199, 181, 107, 199, 216, 63, 226, 178, 163, 76, 7, 141, 115, 191, 154, 76, 204, 73, 170, 213, 170, 191, 62, 49, 126, 8, 39, 21, 179, 191, 91, 97, 117, 71, 185, 196, 174, 63, 85, 45, 178, 49, 216, 136, 210, 63, 215, 93, 252, 251, 102, 117, 216, 63, 220, 65, 65, 61, 49, 20, 178, 191, 172, 155, 151, 95, 111, 242, 183, 63, 113, 53, 121, 106, 146, 16, 198, 63, 186, 158, 72, 188, 79, 81, 196, 63, 239, 116, 227, 82, 241, 109, 193, 191, 215, 167, 84, 5, 155, 148, 202, 63, 34, 171, 97, 169, 4, 247, 225, 63, 132, 43, 134, 144, 57, 51, 221, 63, 116, 65, 76, 19, 41, 106, 198, 191, 0, 0, 0, 0, 0, 0, 0, 0, 140, 252, 37, 135, 92, 31, 218, 63, 30, 235, 41, 58, 228, 51, 163, 63, 115, 98, 100, 40, 89, 232, 132, 63, 194, 228, 83, 237, 162, 95, 176, 63, 52, 188, 114, 13, 120, 137, 202, 63, 135, 111, 126, 3, 64, 85, 197, 63, 48, 96, 106, 32, 81, 6, 205, 191, 43, 49, 30, 63, 234, 22, 209, 191, 98, 115, 46, 183, 15, 107, 210, 191, 119, 77, 69, 165, 160, 161, 178, 191, 77, 140, 28, 236, 9, 94, 208, 63, 60, 243, 25, 139, 51, 129, 93, 63, 39, 130, 41, 200, 170, 227, 160, 63, 175, 99, 28, 186, 22, 36, 215, 191, 133, 148, 230, 176, 74, 162, 198, 191, 195, 155, 60, 51, 128, 228, 226, 191, 86, 10, 74, 102, 129, 162, 219, 63, 164, 108, 202, 13, 194, 145, 144, 63, 189, 85, 82, 228, 170, 44, 225, 63, 12, 170, 2, 81, 52, 161, 211, 191, 77, 215, 184, 175, 154, 225, 209, 191, 185, 140, 129, 208, 74, 64, 38, 63, 32, 0, 63, 113, 41, 177, 203, 191, 9, 222, 247, 198, 199, 188, 227, 191, 27, 38, 23, 13, 6, 88, 203, 63, 42, 146, 203, 255, 211, 99, 190, 63, 36, 88, 5, 204, 34, 133, 117, 191, 193, 15, 168, 126, 173, 251, 201, 63, 93, 120, 27, 12, 108, 20, 194, 191, 209, 160, 171, 252, 71, 86, 200, 63, 148, 40, 122, 144, 176, 82, 164, 63, 42, 192, 209, 199, 250, 21, 196, 191, 135, 163, 131, 98, 141, 31, 197, 191, 54, 52, 18, 160, 186, 28, 224, 63, 182, 163, 82, 34, 244, 184, 218, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 41, 198, 168, 65, 2, 195, 63, 199, 183, 212, 199, 141, 36, 114, 63, 185, 11, 218, 210, 104, 145, 154, 63, 108, 201, 201, 28, 193, 18, 227, 191, 9, 252, 162, 83, 96, 123, 176, 191, 147, 209, 214, 184, 134, 151, 177, 191, 151, 29, 151, 69, 84, 58, 204, 191, 187, 0, 125, 7, 189, 120, 206, 63, 37, 238, 142, 62, 129, 23, 157, 63, 128, 99, 24, 40, 209, 107, 222, 63, 144, 102, 141, 206, 166, 183, 139, 63, 35, 166, 127, 6, 118, 140, 216, 191, 18, 197, 74, 117, 218, 153, 202, 191, 35, 86, 100, 88, 134, 81, 222, 191, 72, 175, 106, 88, 56, 101, 227, 63, 230, 10, 230, 18, 153, 231, 214, 63, 115, 150, 61, 2, 15, 231, 166, 63, 227, 215, 119, 220, 84, 155, 224, 191, 245, 233, 119, 16, 152, 86, 224, 63, 253, 85, 197, 103, 107, 74, 215, 63, 215, 152, 179, 151, 197, 97, 75, 63, 34, 242, 255, 149, 24, 99, 183, 191, 180, 81, 78, 178, 45, 57, 225, 191, 255, 153, 221, 105, 140, 205, 224, 63, 111, 248, 199, 151, 252, 149, 158, 191, 32, 73, 99, 253, 146, 113, 105, 191, 234, 253, 105, 47, 98, 92, 196, 191, 170, 107, 17, 188, 61, 18, 144, 63, 38, 235, 2, 186, 56, 90, 194, 63, 229, 204, 241, 250, 242, 68, 146, 63, 228, 54, 100, 251, 63, 168, 218, 191, 153, 214, 67, 175, 211, 112, 205, 191, 98, 196, 83, 18, 43, 165, 194, 63, 98, 80, 108, 246, 229, 107, 216, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 172, 252, 1, 114, 187, 5, 225, 63, 48, 127, 105, 44, 43, 255, 156, 191, 254, 2, 61, 73, 86, 235, 183, 63, 242, 223, 82, 147, 107, 37, 214, 191, 47, 112, 57, 151, 101, 223, 224, 191, 46, 66, 205, 124, 80, 105, 197, 191, 180, 23, 15, 190, 30, 117, 196, 191, 210, 224, 20, 191, 103, 228, 195, 63, 7, 29, 154, 109, 178, 87, 143, 63, 253, 124, 183, 173, 75, 194, 221, 191, 41, 177, 21, 244, 254, 172, 198, 63, 0, 39, 94, 71, 62, 226, 226, 63, 102, 10, 104, 26, 19, 88, 170, 63, 4, 223, 241, 178, 185, 27, 192, 63, 184, 209, 89, 149, 6, 71, 160, 191, 100, 245, 158, 34, 132, 9, 202, 191, 152, 5, 79, 188, 244, 162, 200, 191, 37, 0, 22, 28, 13, 10, 190, 63, 161, 98, 153, 97, 154, 143, 215, 191, 193, 203, 199, 179, 171, 4, 190, 191, 37, 230, 231, 122, 5, 68, 150, 63, 233, 29, 41, 54, 192, 74, 220, 191, 22, 183, 215, 119, 234, 239, 138, 63, 171, 75, 167, 18, 77, 88, 221, 63, 243, 163, 19, 237, 207, 202, 181, 191, 66, 178, 228, 37, 190, 131, 152, 191, 130, 169, 31, 194, 1, 89, 188, 191, 181, 29, 164, 80, 119, 81, 200, 63, 222, 91, 45, 50, 122, 210, 199, 63, 100, 88, 136, 115, 140, 125, 188, 191, 84, 216, 92, 165, 134, 120, 206, 63, 59, 113, 35, 22, 108, 189, 220, 63, 101, 123, 149, 16, 190, 5, 190, 63, 125, 65, 87, 42, 113, 4, 208, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 225, 199, 77, 1, 121, 131, 144, 191, 69, 250, 100, 193, 57, 6, 185, 63, 149, 15, 220, 122, 200, 101, 198, 63, 233, 245, 206, 236, 255, 254, 206, 63, 168, 182, 186, 149, 210, 157, 206, 63, 150, 199, 153, 189, 24, 249, 223, 63, 209, 9, 128, 131, 219, 243, 209, 63, 148, 144, 197, 136, 145, 65, 209, 191, 57, 122, 215, 131, 44, 1, 215, 191, 26, 22, 111, 189, 171, 166, 133, 191, 125, 247, 105, 230, 150, 117, 199, 63, 184, 71, 30, 56, 73, 157, 201, 191, 6, 230, 244, 224, 213, 238, 209, 63, 52, 63, 236, 112, 163, 132, 221, 63, 107, 96, 226, 215, 120, 131, 207, 63, 122, 63, 94, 237, 114, 110, 212, 63, 235, 192, 118, 141, 126, 38, 218, 63, 42, 112, 176, 94, 38, 137, 216, 191, 141, 111, 19, 173, 205, 38, 132, 63, 79, 130, 107, 160, 50, 244, 221, 191, 242, 197, 119, 105, 211, 26, 168, 63, 164, 103, 98, 101, 243, 62, 219, 191, 124, 15, 174, 165, 53, 49, 211, 191, 90, 252, 179, 222, 156, 178, 181, 191, 247, 154, 171, 215, 227, 49, 191, 191, 52, 231, 242, 50, 59, 145, 128, 63, 144, 84, 174, 165, 88, 233, 226, 63, 123, 253, 55, 202, 99, 250, 225, 191, 51, 249, 46, 208, 26, 71, 226, 191, 177, 31, 139, 61, 87, 162, 214, 191, 197, 39, 206, 135, 131, 179, 180, 63, 30, 10, 101, 16, 200, 195, 158, 63, 115, 130, 163, 116, 149, 155, 138, 191, 134, 12, 207, 77, 67, 159, 183, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 36, 188, 224, 239, 199, 212, 63, 40, 84, 17, 227, 74, 129, 199, 191, 111, 61, 96, 148, 128, 105, 196, 63, 222, 110, 40, 212, 65, 167, 204, 63, 0, 73, 105, 3, 99, 106, 194, 191, 210, 119, 176, 146, 23, 226, 191, 191, 53, 229, 151, 47, 225, 172, 118, 191, 179, 1, 182, 133, 53, 234, 177, 63, 76, 119, 255, 12, 147, 183, 228, 63, 70, 25, 50, 206, 127, 10, 206, 63, 79, 106, 21, 170, 252, 81, 221, 191, 123, 169, 145, 228, 83, 191, 208, 191, 208, 212, 57, 52, 71, 57, 208, 191, 128, 17, 183, 95, 0, 218, 190, 191, 83, 252, 49, 144, 88, 241, 188, 191, 144, 44, 18, 11, 253, 245, 190, 191, 62, 34, 227, 214, 171, 221, 217, 191, 204, 98, 35, 20, 202, 74, 177, 63, 232, 164, 43, 20, 86, 60, 217, 191, 68, 123, 242, 248, 13, 100, 192, 63, 189, 44, 45, 186, 173, 246, 209, 191, 242, 19, 23, 15, 10, 46, 197, 63, 213, 34, 159, 207, 91, 127, 186, 63, 6, 54, 9, 107, 141, 149, 208, 191, 224, 227, 107, 34, 253, 16, 179, 191, 141, 63, 128, 167, 182, 87, 217, 63, 190, 15, 157, 145, 92, 47, 158, 63, 153, 157, 45, 231, 1, 192, 216, 63, 52, 44, 57, 161, 191, 6, 170, 191, 196, 76, 83, 192, 86, 79, 208, 63, 47, 84, 57, 106, 53, 3, 204, 63, 129, 72, 215, 159, 79, 204, 163, 63, 71, 228, 44, 116, 67, 229, 171, 191, 30, 236, 44, 82, 31, 181, 185, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 78, 178, 119, 26, 128, 163, 180, 63, 41, 112, 223, 94, 179, 155, 193, 63, 231, 55, 253, 195, 144, 4, 158, 63, 13, 130, 129, 229, 128, 58, 177, 191, 88, 200, 97, 94, 150, 38, 219, 63, 247, 108, 12, 3, 94, 239, 210, 191, 114, 248, 199, 66, 173, 250, 215, 191, 182, 227, 135, 16, 127, 13, 216, 63, 187, 112, 194, 76, 228, 210, 196, 191, 197, 19, 128, 200, 126, 222, 156, 191, 207, 110, 250, 46, 119, 178, 209, 191, 196, 224, 32, 187, 7, 233, 191, 63, 24, 179, 137, 222, 192, 3, 212, 191, 58, 118, 154, 8, 33, 121, 200, 191, 176, 215, 245, 26, 144, 89, 213, 191, 33, 226, 163, 189, 198, 208, 211, 63, 239, 63, 244, 27, 30, 162, 179, 63, 12, 190, 145, 145, 127, 104, 214, 191, 105, 162, 113, 47, 188, 226, 185, 191, 143, 13, 50, 18, 110, 158, 202, 63, 212, 84, 176, 96, 54, 5, 231, 191, 115, 43, 67, 228, 194, 133, 208, 63, 140, 150, 231, 49, 92, 166, 212, 63, 194, 168, 120, 8, 245, 9, 85, 191, 168, 223, 130, 142, 45, 209, 121, 63, 209, 60, 23, 239, 73, 59, 229, 63, 154, 188, 55, 71, 95, 190, 217, 63, 170, 68, 24, 48, 18, 191, 196, 63, 123, 220, 236, 192, 37, 144, 217, 191, 95, 237, 76, 51, 154, 35, 215, 63, 143, 185, 40, 113, 147, 132, 212, 63, 49, 155, 65, 41, 78, 58, 219, 191, 209, 243, 101, 9, 138, 133, 100, 191, 41, 21, 248, 224, 54, 216, 204, 191, 30, 177, 49, 210, 116, 240, 237, 63, 83, 73, 121, 149, 93, 94, 201, 191, 91, 190, 205, 197, 139, 98, 212, 63, 235, 14, 18, 204, 26, 201, 189, 191, 18, 31, 88, 128, 105, 232, 214, 191, 149, 226, 172, 132, 191, 255, 209, 191, 136, 12, 243, 100, 192, 1, 192, 63, 251, 241, 12, 182, 106, 240, 198, 63, 122, 105, 211, 244, 13, 255, 181, 63, 99, 196, 141, 223, 139, 26, 163, 63, 20, 245, 33, 111, 5, 241, 214, 191, 17, 84, 74, 34, 179, 38, 212, 63, 246, 90, 194, 232, 66, 146, 213, 191, 65, 207, 59, 15, 57, 109, 204, 63, 93, 175, 192, 145, 128, 165, 187, 63, 250, 4, 28, 71, 135, 24, 188, 191, 44, 219, 27, 150, 188, 110, 181, 63, 93, 86, 1, 189, 234, 224, 205, 191, 205, 203, 24, 253, 124, 254, 214, 191, 155, 4, 231, 105, 243, 32, 202, 191, 184, 221, 212, 0, 169, 13, 212, 191, 11, 144, 79, 89, 234, 25, 188, 191, 72, 71, 194, 87, 211, 217, 211, 191, 30, 9, 121, 86, 27, 152, 169, 63, 144, 134, 6, 242, 224, 107, 179, 63, 214, 175, 44, 47, 43, 193, 212, 191, 194, 87, 162, 122, 174, 203, 216, 63, 190, 135, 26, 238, 164, 127, 205, 191, 134, 2, 75, 94, 217, 25, 208, 63, 50, 50, 155, 20, 20, 209, 213, 63, 199, 118, 108, 13, 190, 46, 208, 63, 237, 131, 242, 43, 48, 161, 211, 191, 190, 115, 11, 247, 178, 148, 201, 191, 1, 97, 91, 85, 48, 135, 173, 191, 27, 209, 100, 139, 39, 169, 212, 63, 92, 154, 190, 93, 16, 28, 210, 63, 0, 0, 0, 0, 0, 0, 0, 128, 232, 55, 38, 86, 251, 222, 215, 191, 29, 10, 173, 118, 234, 52, 160, 191, 101, 142, 163, 6, 25, 165, 231, 63, 154, 245, 186, 111, 39, 9, 206, 63, 239, 227, 199, 104, 151, 182, 203, 191, 32, 248, 36, 16, 226, 200, 190, 63, 0, 60, 90, 111, 134, 137, 214, 191, 18, 163, 129, 89, 107, 150, 212, 63, 194, 71, 37, 116, 201, 215, 212, 63, 140, 253, 209, 175, 227, 166, 197, 191, 105, 158, 163, 59, 147, 84, 187, 63, 134, 38, 114, 215, 110, 191, 188, 63, 180, 155, 229, 11, 237, 96, 212, 63, 58, 144, 35, 108, 89, 233, 212, 191, 172, 143, 152, 227, 88, 101, 216, 63, 129, 102, 80, 144, 99, 35, 210, 191, 224, 62, 237, 89, 59, 181, 174, 191, 85, 232, 33, 27, 58, 2, 204, 191, 214, 134, 21, 34, 62, 202, 165, 191, 135, 62, 238, 29, 26, 241, 174, 63, 137, 249, 113, 190, 167, 211, 215, 63, 132, 248, 20, 83, 197, 189, 210, 191, 195, 79, 100, 35, 192, 242, 217, 191, 29, 74, 102, 132, 35, 49, 211, 191, 207, 123, 152, 101, 86, 187, 113, 63, 249, 142, 84, 1, 216, 210, 182, 63, 122, 114, 228, 211, 179, 150, 217, 191, 5, 158, 107, 197, 197, 148, 153, 191, 107, 96, 131, 123, 34, 16, 203, 191, 168, 211, 104, 54, 123, 224, 165, 191, 45, 226, 12, 42, 160, 137, 178, 63, 198, 113, 67, 253, 53, 59, 196, 63, 67, 184, 63, 176, 35, 112, 208, 63, 29, 190, 241, 15, 95, 108, 166, 191, 215, 47, 237, 111, 42, 40, 154, 191, 0, 0, 0, 0, 0, 0, 0, 0, 163, 18, 132, 213, 209, 248, 214, 63, 139, 120, 127, 137, 95, 98, 214, 63, 167, 0, 36, 100, 42, 120, 222, 191, 194, 145, 222, 209, 5, 27, 228, 63, 178, 231, 173, 195, 156, 209, 212, 63, 16, 60, 200, 210, 149, 223, 205, 63, 87, 248, 125, 143, 161, 82, 150, 191, 167, 73, 180, 195, 102, 197, 75, 191, 107, 208, 146, 30, 49, 153, 132, 191, 200, 16, 117, 230, 23, 220, 153, 63, 167, 214, 175, 223, 222, 116, 218, 191, 118, 193, 150, 106, 63, 37, 222, 191, 89, 188, 194, 215, 202, 28, 210, 191, 52, 185, 88, 157, 197, 195, 134, 191, 183, 209, 187, 55, 79, 4, 183, 63, 107, 111, 15, 131, 254, 244, 146, 63, 121, 201, 97, 219, 164, 58, 211, 191, 180, 127, 168, 104, 4, 47, 224, 63, 245, 191, 192, 31, 30, 133, 209, 191, 118, 244, 149, 234, 60, 36, 203, 191, 117, 231, 192, 51, 248, 47, 180, 63, 46, 253, 43, 48, 178, 104, 210, 63, 143, 251, 138, 253, 184, 198, 179, 191, 67, 104, 101, 123, 156, 17, 127, 63, 177, 200, 207, 200, 182, 126, 217, 63, 24, 138, 85, 153, 120, 197, 224, 191, 121, 123, 163, 200, 127, 200, 202, 63, 132, 216, 208, 23, 116, 66, 206, 63, 208, 146, 212, 255, 247, 159, 186, 191, 229, 249, 116, 124, 79, 16, 206, 63, 51, 55, 7, 95, 177, 138, 227, 191, 254, 148, 33, 150, 7, 129, 197, 191, 86, 190, 8, 203, 56, 215, 148, 63, 100, 157, 182, 23, 127, 97, 222, 191, 177, 240, 16, 247, 25, 252, 219, 63, 0, 0, 0, 0, 0, 0, 0, 128, 162, 43, 1, 29, 209, 160, 208, 63, 108, 184, 218, 110, 216, 41, 161, 63, 119, 235, 166, 78, 187, 78, 196, 63, 34, 83, 201, 71, 151, 161, 220, 63, 7, 192, 236, 253, 238, 99, 200, 63, 48, 240, 124, 90, 110, 177, 208, 63, 77, 242, 157, 244, 49, 138, 210, 191, 21, 36, 182, 143, 226, 202, 220, 63, 90, 138, 226, 15, 171, 216, 218, 63, 230, 109, 216, 117, 183, 117, 212, 63, 117, 24, 139, 151, 78, 32, 134, 63, 164, 215, 192, 171, 244, 186, 218, 191, 105, 141, 57, 99, 219, 213, 184, 191, 136, 169, 151, 91, 136, 111, 207, 191, 13, 35, 187, 207, 52, 1, 181, 191, 16, 86, 147, 99, 199, 43, 218, 191, 178, 255, 141, 178, 167, 108, 202, 191, 176, 201, 117, 161, 55, 96, 208, 191, 226, 89, 116, 222, 193, 161, 194, 191, 177, 232, 93, 190, 151, 200, 203, 63, 130, 10, 214, 58, 177, 103, 148, 191, 91, 193, 245, 157, 71, 166, 187, 63, 73, 29, 60, 2, 45, 139, 172, 191, 182, 26, 249, 198, 209, 241, 215, 191, 247, 91, 59, 240, 37, 125, 178, 63, 3, 224, 169, 11, 200, 35, 226, 191, 247, 65, 20, 40, 230, 102, 194, 63, 236, 183, 165, 142, 69, 123, 188, 191, 161, 124, 155, 201, 171, 171, 205, 191, 234, 250, 186, 200, 97, 52, 200, 191, 223, 235, 141, 100, 217, 129, 206, 191, 242, 124, 65, 23, 200, 249, 217, 63, 5, 237, 184, 223, 164, 94, 224, 63, 3, 78, 183, 149, 134, 54, 179, 191, 133, 11, 5, 140, 105, 163, 160, 191, 0, 0, 0, 0, 0, 0, 0, 0, 110, 125, 236, 219, 140, 0, 227, 191, 46, 24, 17, 234, 148, 66, 164, 63, 136, 229, 34, 130, 249, 254, 159, 191, 243, 141, 139, 83, 212, 10, 198, 63, 152, 165, 236, 56, 11, 241, 192, 191, 107, 18, 229, 47, 33, 248, 208, 63, 79, 38, 20, 125, 254, 164, 221, 63, 96, 148, 58, 167, 237, 79, 224, 63, 129, 76, 117, 194, 124, 241, 224, 63, 148, 9, 206, 71, 68, 18, 201, 191, 122, 249, 27, 90, 170, 194, 209, 63, 253, 114, 187, 15, 196, 36, 116, 63, 116, 250, 114, 138, 31, 179, 167, 63, 136, 167, 68, 233, 14, 189, 226, 191, 105, 220, 197, 232, 203, 37, 163, 63, 160, 110, 164, 136, 116, 47, 184, 191, 8, 243, 19, 83, 16, 26, 203, 191, 47, 223, 157, 233, 49, 72, 166, 63, 234, 109, 161, 205, 255, 148, 204, 191, 212, 73, 229, 51, 146, 36, 207, 63, 177, 18, 220, 139, 149, 66, 174, 63, 19, 164, 242, 13, 166, 115, 65, 191, 133, 69, 147, 187, 24, 178, 215, 191, 201, 159, 171, 227, 179, 217, 182, 191, 18, 52, 171, 156, 10, 6, 202, 191, 178, 37, 42, 140, 51, 200, 210, 191, 85, 77, 155, 243, 18, 184, 144, 63, 204, 121, 207, 76, 211, 249, 219, 191, 45, 205, 91, 59, 133, 248, 212, 63, 254, 159, 90, 192, 137, 58, 218, 191, 68, 138, 220, 152, 243, 48, 188, 63, 6, 144, 65, 107, 87, 77, 176, 63, 56, 80, 98, 170, 31, 189, 211, 191, 246, 30, 173, 248, 27, 34, 224, 63, 161, 162, 105, 44, 64, 132, 224, 63, 0, 0, 0, 0, 0, 0, 0, 128, 176, 60, 14, 141, 246, 158, 216, 63, 162, 207, 10, 102, 213, 188, 222, 63, 175, 124, 186, 79, 117, 156, 107, 63, 219, 99, 86, 178, 88, 141, 162, 63, 182, 123, 153, 65, 105, 139, 163, 191, 159, 237, 99, 164, 33, 117, 213, 191, 45, 121, 36, 54, 231, 238, 199, 191, 111, 180, 71, 124, 113, 62, 184, 63, 127, 115, 216, 228, 116, 215, 187, 63, 84, 206, 51, 227, 224, 178, 161, 63, 120, 89, 47, 227, 243, 124, 193, 191, 44, 59, 180, 254, 111, 133, 162, 63, 195, 99, 175, 121, 109, 210, 189, 63, 53, 40, 192, 11, 137, 150, 208, 191, 6, 11, 233, 222, 126, 117, 220, 191, 84, 137, 71, 227, 71, 244, 206, 63, 49, 249, 201, 25, 114, 62, 224, 191, 211, 138, 157, 157, 130, 29, 117, 63, 137, 85, 99, 185, 251, 244, 214, 191, 3, 35, 223, 111, 122, 106, 207, 63, 22, 96, 76, 99, 81, 57, 225, 191, 143, 36, 5, 49, 112, 18, 98, 191, 255, 255, 93, 99, 72, 120, 210, 191, 73, 90, 130, 112, 161, 177, 215, 63, 226, 122, 170, 52, 252, 111, 177, 191, 116, 239, 163, 47, 177, 194, 180, 191, 204, 120, 252, 155, 51, 85, 87, 191, 87, 75, 187, 207, 165, 25, 170, 63, 98, 223, 208, 235, 91, 18, 191, 191, 56, 98, 230, 48, 141, 165, 181, 63, 40, 56, 60, 135, 135, 188, 155, 63, 223, 153, 124, 115, 185, 109, 222, 63, 248, 153, 82, 196, 27, 181, 186, 191, 76, 225, 203, 45, 90, 189, 223, 63, 209, 61, 195, 100, 79, 235, 206, 63},
	{109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 109, 155, 66, 80, 215, 13, 210, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 94, 155, 72, 158, 219, 171, 63, 234, 60, 217, 174, 204, 58, 219, 63, 201, 136, 235, 17, 212, 3, 214, 191, 175, 81, 150, 14, 94, 241, 219, 191, 218, 175, 108, 17, 204, 79, 220, 63, 0, 45, 217, 13, 44, 213, 216, 63, 84, 20, 143, 29, 191, 15, 170, 191, 217, 196, 53, 109, 137, 201, 201, 191, 68, 51, 9, 64, 44, 91, 192, 63, 14, 142, 213, 3, 203, 170, 189, 191, 197, 81, 24, 138, 65, 84, 205, 63, 121, 101, 155, 132, 254, 202, 216, 191, 90, 26, 161, 144, 95, 165, 206, 191, 85, 141, 129, 22, 250, 9, 212, 191, 47, 37, 253, 214, 141, 135, 210, 191, 58, 168, 72, 169, 198, 137, 220, 191, 229, 40, 201, 33, 89, 164, 205, 191, 85, 200, 25, 53, 68, 216, 211, 63, 56, 202, 90, 148, 148, 62, 156, 191, 32, 178, 184, 159, 153, 98, 202, 63, 122, 195, 231, 49, 177, 223, 218, 63, 105, 20, 242, 60, 140, 240, 192, 63, 222, 149, 224, 159, 9, 135, 197, 191, 126, 49, 154, 224, 32, 213, 217, 191, 222, 31, 53, 216, 11, 146, 213, 63, 103, 139, 231, 24, 84, 26, 223, 63, 210, 37, 78, 19, 21, 160, 218, 63, 100, 48, 177, 84, 47, 21, 197, 191, 172, 220, 14, 17, 33, 200, 218, 191, 159, 110, 46, 48, 213, 191, 183, 63, 2, 217, 59, 60, 201, 49, 168, 63, 164, 61, 176, 150, 43, 248, 222, 191, 56, 67, 149, 255, 16, 117, 204, 63, 110, 219, 206, 100, 42, 66, 208, 191, 168, 60, 6, 196, 120, 168, 215, 63, 77, 168, 60, 246, 125, 244, 195, 63, 120, 62, 54, 0, 239, 47, 211, 63, 206, 74, 12, 82, 146, 135, 127, 191, 81, 125, 176, 120, 223, 99, 208, 63, 119, 223, 165, 1, 250, 181, 215, 191, 58, 140, 171, 22, 35, 69, 205, 63, 28, 139, 48, 6, 73, 112, 205, 191, 5, 9, 79, 11, 57, 29, 208, 63, 212, 201, 104, 128, 250, 137, 185, 191, 146, 204, 0, 235, 80, 24, 204, 191, 235, 34, 146, 205, 210, 59, 123, 63, 58, 175, 191, 236, 84, 230, 96, 191, 154, 116, 87, 120, 67, 69, 223, 63, 111, 26, 148, 72, 107, 159, 212, 63, 189, 190, 12, 51, 52, 251, 194, 191, 23, 7, 122, 8, 22, 27, 161, 63, 205, 254, 23, 91, 8, 191, 205, 191, 49, 215, 138, 237, 31, 202, 130, 191, 196, 118, 250, 68, 177, 216, 201, 63, 214, 126, 73, 208, 253, 15, 192, 191, 166, 189, 190, 136, 73, 79, 182, 63, 43, 163, 74, 148, 69, 230, 190, 191, 246, 208, 68, 130, 61, 126, 219, 63, 194, 63, 180, 140, 153, 4, 214, 191, 58, 203, 20, 76, 248, 164, 203, 63, 11, 255, 245, 225, 38, 74, 207, 63, 210, 31, 172, 216, 108, 255, 104, 191, 35, 244, 195, 155, 36, 46, 214, 191, 116, 7, 82, 58, 97, 75, 188, 63, 180, 33, 235, 120, 208, 100, 201, 191, 119, 172, 11, 17, 128, 173, 206, 191, 10, 49, 24, 32, 79, 238, 208, 63, 80, 154, 138, 15, 31, 218, 215, 191, 80, 23, 176, 167, 141, 74, 210, 191, 59, 218, 201, 237, 56, 4, 203, 191, 66, 180, 21, 201, 175, 52, 214, 191, 161, 250, 76, 231, 6, 23, 219, 63, 81, 27, 127, 140, 251, 154, 190, 63, 26, 125, 125, 178, 105, 159, 212, 63, 57, 85, 60, 90, 248, 113, 164, 191, 98, 79, 6, 9, 144, 8, 188, 63, 159, 187, 78, 243, 144, 92, 212, 63, 178, 31, 180, 254, 15, 214, 190, 191, 254, 11, 218, 76, 139, 250, 208, 63, 0, 17, 152, 241, 214, 106, 219, 63, 219, 217, 192, 164, 210, 225, 176, 63, 23, 228, 122, 143, 60, 193, 156, 191, 214, 233, 140, 227, 160, 227, 217, 191, 118, 231, 212, 212, 62, 82, 211, 191, 130, 78, 68, 213, 208, 128, 220, 191, 33, 36, 125, 165, 43, 220, 197, 191, 42, 214, 111, 147, 191, 237, 184, 63, 219, 170, 178, 151, 25, 181, 217, 191, 9, 175, 26, 113, 5, 180, 211, 63, 242, 223, 72, 68, 91, 17, 172, 63, 38, 221, 98, 227, 199, 136, 207, 63, 231, 112, 72, 248, 215, 95, 218, 63, 33, 48, 77, 162, 221, 235, 221, 191, 175, 70, 138, 184, 86, 36, 219, 63, 202, 149, 74, 218, 242, 64, 222, 191, 231, 163, 198, 30, 252, 17, 196, 191, 0, 0, 0, 0, 0, 0, 0, 128, 13, 54, 179, 147, 163, 129, 215, 63, 226, 105, 100, 210, 100, 151, 221, 191, 146, 121, 150, 92, 135, 115, 206, 191, 64, 201, 33, 77, 232, 125, 208, 191, 204, 118, 180, 169, 205, 12, 204, 191, 220, 111, 25, 244, 165, 96, 168, 191, 62, 9, 5, 42, 122, 57, 209, 63, 44, 23, 49, 217, 160, 152, 222, 191, 204, 121, 146, 124, 219, 107, 219, 191, 235, 220, 170, 235, 77, 232, 200, 63, 121, 212, 53, 118, 250, 237, 212, 191, 9, 139, 233, 249, 67, 233, 215, 63, 161, 186, 221, 102, 24, 195, 197, 191, 162, 128, 212, 215, 32, 66, 219, 63, 42, 236, 96, 2, 155, 93, 194, 63, 244, 49, 123, 56, 1, 45, 216, 191, 244, 30, 41, 237, 9, 199, 151, 191, 184, 8, 133, 188, 251, 221, 214, 63, 139, 170, 249, 169, 159, 62, 209, 191, 164, 234, 9, 60, 16, 37, 212, 63, 138, 19, 85, 213, 109, 169, 213, 63, 213, 64, 226, 98, 191, 27, 193, 191, 169, 147, 122, 164, 156, 82, 212, 191, 42, 185, 12, 235, 110, 163, 198, 63, 66, 219, 236, 201, 129, 191, 207, 63, 104, 126, 205, 32, 232, 174, 194, 63, 63, 106, 119, 219, 154, 183, 159, 63, 116, 224, 205, 21, 34, 167, 205, 63, 132, 140, 39, 166, 111, 67, 213, 191, 158, 246, 236, 70, 172, 93, 204, 63, 104, 110, 18, 18, 102, 148, 217, 191, 18, 176, 160, 123, 18, 118, 205, 191, 231, 254, 22, 221, 224, 221, 142, 63, 247, 144, 56, 143, 175, 201, 219, 63, 17, 197, 178, 68, 45, 79, 186, 191, 49, 52, 52, 23, 76, 200, 186, 63, 135, 106, 64, 54, 67, 59, 192, 63, 213, 67, 158, 54, 37, 36, 214, 191, 234, 105, 76, 155, 167, 163, 222, 63, 143, 248, 55, 35, 146, 207, 187, 191, 86, 224, 122, 132, 205, 242, 180, 63, 138, 75, 29, 20, 45, 105, 219, 191, 189, 183, 255, 37, 240, 163, 214, 63, 9, 250, 108, 126, 52, 1, 179, 191, 114, 97, 203, 1, 32, 220, 185, 63, 131, 178, 88, 131, 91, 123, 186, 191, 248, 84, 186, 255, 170, 151, 191, 191, 170, 229, 35, 140, 199, 157, 221, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 2, 13, 192, 59, 121, 189, 191, 14, 206, 238, 217, 102, 165, 221, 191, 249, 133, 54, 183, 60, 246, 217, 63, 41, 204, 97, 159, 6, 6, 220, 63, 157, 111, 144, 191, 15, 173, 184, 191, 123, 93, 96, 226, 249, 149, 222, 63, 163, 190, 29, 25, 97, 130, 188, 63, 138, 240, 245, 45, 54, 72, 217, 63, 167, 245, 209, 135, 154, 33, 189, 63, 240, 30, 194, 91, 62, 51, 198, 63, 67, 125, 176, 209, 226, 18, 217, 63, 230, 61, 60, 163, 107, 74, 211, 63, 3, 168, 56, 94, 245, 221, 221, 191, 38, 24, 220, 137, 17, 81, 202, 191, 150, 150, 242, 201, 48, 4, 224, 63, 94, 4, 100, 91, 220, 66, 168, 63, 91, 15, 145, 23, 23, 60, 216, 191, 232, 96, 111, 145, 139, 120, 216, 191, 211, 103, 47, 247, 206, 87, 164, 191, 138, 239, 65, 204, 90, 111, 212, 63, 206, 180, 22, 231, 53, 112, 208, 191, 103, 112, 128, 33, 243, 157, 200, 191, 209, 137, 241, 187, 167, 108, 193, 191, 110, 244, 47, 101, 155, 82, 221, 191, 124, 169, 238, 169, 93, 209, 204, 63, 213, 226, 230, 35, 167, 162, 177, 63, 22, 193, 137, 85, 97, 58, 220, 63, 33, 36, 126, 55, 44, 7, 208, 63, 106, 5, 4, 135, 93, 41, 219, 191, 89, 37, 249, 173, 102, 184, 197, 191, 210, 125, 157, 83, 47, 124, 169, 191, 141, 109, 19, 146, 190, 22, 161, 191, 115, 136, 203, 1, 209, 69, 220, 63, 9, 166, 54, 174, 73, 150, 190, 63, 98, 152, 171, 173, 121, 167, 198, 63, 223, 22, 228, 199, 66, 41, 183, 63, 194, 12, 74, 135, 213, 96, 222, 191, 59, 16, 192, 38, 14, 69, 145, 191, 229, 76, 105, 149, 27, 76, 192, 191, 57, 24, 155, 34, 77, 194, 193, 191, 55, 192, 159, 15, 138, 175, 220, 191, 73, 182, 112, 10, 110, 212, 215, 191, 141, 254, 226, 250, 15, 230, 181, 191, 76, 167, 140, 40, 230, 156, 167, 191, 232, 50, 144, 23, 214, 153, 186, 63, 132, 129, 108, 13, 249, 194, 110, 191, 97, 115, 237, 32, 27, 229, 113, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 4, 21, 141, 219, 231, 162, 191, 159, 199, 3, 173, 75, 167, 176, 63, 40, 2, 232, 79, 228, 105, 215, 63, 197, 102, 30, 178, 149, 197, 146, 63, 44, 3, 203, 205, 181, 41, 218, 63, 244, 4, 78, 227, 185, 133, 204, 191, 247, 77, 160, 31, 187, 201, 148, 191, 186, 227, 246, 84, 41, 125, 188, 63, 70, 56, 204, 69, 229, 19, 208, 63, 46, 94, 153, 122, 199, 90, 199, 63, 96, 49, 236, 180, 14, 253, 204, 63, 140, 203, 222, 10, 125, 188, 219, 191, 67, 244, 9, 29, 223, 99, 107, 63, 38, 169, 25, 180, 96, 200, 223, 63, 67, 22, 46, 179, 181, 190, 194, 191, 143, 188, 179, 166, 13, 233, 217, 63, 135, 229, 219, 128, 152, 65, 208, 63, 79, 232, 109, 66, 147, 6, 216, 63, 214, 122, 33, 124, 52, 22, 168, 63, 119, 47, 184, 110, 89, 65, 209, 191, 95, 207, 99, 131, 87, 245, 217, 191, 217, 154, 253, 169, 227, 229, 202, 191, 1, 208, 21, 103, 200, 217, 212, 191, 15, 11, 196, 20, 110, 68, 204, 191, 231, 57, 61, 227, 50, 207, 223, 63, 98, 40, 90, 24, 95, 188, 182, 191, 53, 217, 165, 209, 186, 175, 202, 63, 147, 228, 170, 37, 75, 178, 206, 191, 115, 55, 11, 214, 231, 134, 205, 63, 32, 26, 55, 13, 130, 213, 188, 63, 253, 234, 9, 131, 145, 183, 183, 63, 205, 171, 171, 95, 105, 177, 194, 191, 125, 84, 182, 214, 175, 65, 157, 191, 21, 223, 90, 167, 64, 25, 222, 63, 107, 225, 180, 52, 214, 87, 224, 191, 14, 65, 159, 4, 4, 86, 212, 191, 30, 85, 47, 51, 21, 254, 205, 191, 33, 226, 28, 121, 28, 26, 108, 191, 214, 156, 67, 39, 31, 33, 222, 191, 23, 61, 29, 29, 14, 180, 224, 191, 219, 238, 50, 170, 138, 95, 173, 63, 188, 19, 19, 149, 113, 152, 208, 191, 93, 13, 255, 249, 253, 99, 222, 63, 103, 18, 113, 211, 75, 82, 203, 63, 225, 15, 41, 201, 147, 67, 219, 191, 253, 71, 147, 64, 68, 117, 141, 191, 166, 68, 103, 66, 1, 65, 88, 63, 155, 103, 140, 26, 96, 47, 228, 63, 52, 244, 240, 146, 245, 155, 184, 63, 148, 224, 18, 110, 222, 54, 205, 191, 184, 238, 253, 216, 228, 230, 211, 191, 48, 9, 15, 117, 229, 241, 185, 191, 114, 125, 184, 220, 232, 41, 212, 191, 109, 241, 146, 63, 111, 175, 195, 191, 8, 142, 236, 98, 211, 48, 208, 191, 114, 152, 123, 23, 55, 66, 210, 191, 132, 104, 113, 149, 89, 125, 208, 191, 15, 201, 172, 97, 178, 159, 218, 63, 82, 146, 234, 102, 84, 172, 195, 63, 104, 132, 242, 238, 23, 181, 192, 191, 28, 75, 129, 236, 111, 28, 180, 191, 69, 255, 100, 80, 197, 46, 212, 191, 169, 149, 34, 10, 190, 143, 196, 63, 133, 135, 58, 162, 35, 22, 209, 191, 197, 130, 198, 191, 72, 103, 196, 191, 223, 79, 76, 162, 148, 117, 182, 191, 225, 196, 63, 247, 136, 119, 163, 191, 179, 252, 177, 102, 196, 23, 206, 63, 2, 191, 39, 205, 191, 20, 129, 63, 42, 106, 249, 82, 40, 197, 193, 191, 96, 235, 203, 35, 183, 179, 196, 63, 107, 84, 72, 154, 209, 66, 217, 63, 93, 166, 94, 200, 69, 143, 208, 191, 17, 49, 2, 94, 229, 155, 184, 63, 184, 39, 254, 252, 212, 199, 211, 191, 169, 14, 70, 204, 180, 36, 209, 191, 65, 52, 58, 113, 66, 245, 181, 63, 95, 69, 45, 26, 57, 129, 208, 191, 9, 0, 94, 121, 254, 169, 162, 191, 239, 52, 252, 223, 185, 93, 218, 63, 232, 116, 150, 126, 251, 20, 211, 191, 37, 28, 5, 243, 43, 252, 211, 191, 79, 14, 236, 82, 75, 82, 213, 63, 178, 113, 119, 214, 199, 118, 167, 63, 115, 75, 201, 200, 90, 32, 222, 63, 10, 56, 172, 154, 232, 146, 201, 191, 36, 145, 70, 240, 161, 199, 209, 191, 92, 47, 29, 23, 160, 189, 212, 63, 137, 249, 2, 87, 29, 217, 174, 63, 250, 12, 60, 18, 59, 108, 211, 191, 185, 81, 123, 138, 199, 40, 179, 191, 185, 229, 229, 216, 81, 228, 214, 63, 148, 139, 89, 227, 241, 160, 225, 63, 134, 221, 103, 122, 134, 111, 217, 63, 178, 30, 10, 79, 121, 63, 226, 63, 111, 178, 34, 96, 198, 229, 203, 191, 0, 0, 0, 0, 0, 0, 0, 128, 240, 130, 48, 199, 5, 85, 225, 63, 36, 189, 29, 99, 6, 21, 212, 63, 57, 204, 247, 210, 177, 159, 162, 191, 168, 37, 107, 191, 35, 138, 209, 63, 218, 55, 141, 27, 4, 216, 130, 63, 241, 134, 255, 64, 0, 135, 166, 191, 243, 115, 191, 29, 164, 200, 195, 191, 24, 58, 72, 223, 181, 103, 200, 191, 251, 254, 85, 235, 78, 75, 206, 63, 146, 236, 211, 21, 195, 123, 216, 63, 93, 116, 207, 129, 233, 121, 224, 63, 233, 216, 203, 207, 44, 162, 215, 63, 137, 162, 166, 54, 122, 88, 200, 191, 220, 208, 184, 127, 195, 92, 120, 191, 17, 18, 244, 12, 246, 32, 205, 191, 7, 205, 92, 171, 247, 116, 200, 191, 165, 147, 37, 222, 137, 150, 149, 63, 129, 108, 163, 160, 223, 20, 217, 191, 238, 58, 237, 241, 177, 224, 212, 191, 206, 43, 213, 98, 235, 45, 225, 191, 58, 148, 78, 240, 40, 85, 220, 191, 36, 145, 237, 57, 142, 134, 192, 63, 72, 8, 4, 117, 139, 34, 224, 63, 101, 217, 21, 220, 60, 237, 213, 63, 174, 236, 72, 96, 197, 94, 193, 63, 254, 160, 242, 38, 54, 141, 203, 63, 119, 125, 213, 182, 86, 47, 119, 191, 167, 211, 125, 81, 143, 184, 189, 63, 122, 86, 56, 162, 162, 245, 222, 191, 148, 20, 241, 221, 4, 70, 191, 191, 174, 117, 2, 131, 100, 14, 223, 191, 48, 212, 206, 238, 63, 225, 220, 191, 171, 133, 56, 188, 138, 161, 114, 63, 160, 142, 249, 24, 126, 145, 172, 191, 200, 57, 49, 130, 72, 90, 200, 63, 239, 153, 194, 16, 92, 128, 194, 191, 86, 238, 9, 173, 150, 138, 208, 191, 178, 163, 147, 191, 19, 78, 209, 63, 134, 216, 7, 161, 248, 78, 203, 63, 191, 196, 195, 50, 211, 143, 201, 63, 28, 240, 238, 84, 194, 131, 189, 63, 91, 99, 19, 74, 231, 129, 187, 191, 116, 199, 31, 146, 181, 134, 217, 63, 195, 204, 211, 134, 200, 235, 193, 191, 138, 24, 126, 21, 45, 170, 203, 191, 179, 214, 35, 91, 213, 178, 201, 191, 88, 65, 171, 27, 32, 22, 209, 63, 170, 253, 214, 130, 142, 64, 213, 191, 0, 0, 0, 0, 0, 0, 0, 0, 72, 13, 59, 75, 115, 193, 211, 63, 216, 208, 34, 69, 194, 223, 222, 63, 214, 237, 52, 104, 166, 56, 210, 191, 225, 74, 109, 47, 125, 106, 190, 191, 15, 23, 138, 4, 59, 226, 212, 191, 174, 67, 100, 220, 141, 83, 220, 191, 45, 191, 75, 7, 123, 225, 198, 191, 204, 40, 109, 101, 148, 139, 224, 63, 228, 192, 30, 172, 180, 240, 212, 63, 137, 145, 230, 244, 86, 59, 169, 63, 207, 187, 162, 162, 218, 99, 203, 63, 84, 75, 56, 67, 156, 129, 201, 63, 205, 112, 92, 204, 134, 190, 209, 191, 23, 46, 61, 240, 180, 43, 210, 63, 105, 72, 68, 8, 69, 175, 198, 191, 40, 155, 91, 150, 5, 62, 193, 63, 95, 246, 6, 237, 44, 10, 221, 191, 224, 171, 250, 44, 31, 175, 197, 63, 174, 178, 245, 191, 142, 149, 171, 191, 148, 168, 199, 69, 174, 203, 204, 63, 224, 28, 153, 66, 182, 27, 197, 63, 59, 152, 219, 36, 124, 52, 215, 191, 42, 81, 56, 41, 79, 103, 200, 63, 71, 207, 154, 230, 95, 17, 124, 63, 169, 6, 136, 84, 11, 179, 205, 191, 89, 213, 190, 178, 249, 7, 203, 191, 1, 207, 214, 117, 56, 57, 225, 191, 69, 16, 191, 143, 140, 124, 209, 191, 21, 72, 139, 226, 131, 98, 200, 63, 234, 176, 207, 221, 223, 115, 210, 191, 149, 75, 249, 223, 70, 34, 214, 63, 166, 224, 143, 223, 134, 185, 189, 63, 189, 29, 188, 221, 10, 33, 225, 191, 184, 102, 241, 30, 128, 94, 212, 63, 160, 71, 85, 64, 248, 157, 191, 191, 49, 105, 251, 82, 153, 104, 210, 191, 110, 93, 76, 26, 37, 69, 147, 191, 212, 115, 109, 159, 161, 117, 177, 63, 199, 14, 202, 118, 27, 199, 224, 63, 45, 248, 92, 58, 104, 129, 191, 191, 215, 104, 11, 16, 196, 30, 211, 191, 247, 252, 155, 231, 171, 52, 211, 63, 80, 59, 14, 48, 57, 41, 197, 63, 67, 136, 146, 21, 43, 244, 192, 191, 47, 220, 234, 248, 183, 222, 66, 63, 217, 247, 155, 32, 241, 243, 181, 191, 105, 183, 150, 188, 108, 202, 161, 63, 88, 75, 58, 218, 26, 92, 223, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 12, 86, 100, 106, 125, 198, 63, 175, 202, 242, 43, 97, 191, 152, 191, 100, 24, 125, 211, 131, 3, 194, 191, 224, 250, 36, 101, 187, 82, 186, 63, 136, 108, 171, 74, 57, 13, 219, 191, 101, 106, 206, 158, 183, 196, 192, 63, 112, 8, 168, 84, 0, 131, 198, 191, 229, 107, 69, 252, 218, 162, 224, 191, 107, 104, 255, 253, 84, 24, 176, 63, 192, 185, 119, 73, 241, 16, 199, 191, 30, 26, 114, 3, 58, 43, 219, 63, 118, 113, 172, 68, 45, 200, 191, 63, 182, 29, 207, 158, 124, 222, 226, 191, 215, 226, 250, 59, 223, 106, 173, 63, 204, 220, 177, 222, 48, 34, 224, 191, 194, 85, 25, 129, 87, 120, 220, 63, 4, 78, 108, 154, 66, 177, 216, 191, 3, 73, 5, 31, 217, 108, 200, 63, 195, 163, 224, 161, 172, 45, 165, 191, 76, 19, 102, 128, 112, 25, 212, 63, 207, 166, 196, 68, 222, 174, 208, 191, 166, 141, 201, 113, 124, 107, 200, 63, 83, 101, 149, 36, 7, 142, 172, 191, 121, 47, 239, 42, 26, 159, 166, 191, 255, 104, 53, 253, 211, 174, 181, 191, 213, 227, 191, 146, 81, 90, 226, 191, 82, 58, 42, 234, 130, 2, 154, 191, 240, 32, 106, 111, 31, 54, 208, 191, 112, 196, 121, 75, 12, 28, 174, 63, 165, 176, 104, 91, 6, 69, 204, 63, 178, 174, 125, 232, 108, 45, 163, 63, 164, 6, 54, 21, 170, 73, 226, 63, 147, 23, 61, 99, 235, 146, 226, 63, 77, 68, 70, 25, 8, 157, 165, 63, 40, 21, 213, 2, 207, 216, 200, 191, 8, 251, 172, 172, 104, 84, 147, 63, 202, 32, 49, 20, 41, 32, 218, 63, 37, 101, 239, 46, 184, 105, 155, 191, 220, 76, 56, 28, 105, 4, 164, 191, 101, 243, 226, 212, 59, 27, 204, 63, 48, 17, 129, 44, 42, 111, 226, 63, 38, 187, 212, 122, 209, 3, 216, 191, 17, 74, 248, 209, 244, 142, 174, 191, 141, 14, 236, 231, 19, 90, 133, 191, 129, 139, 12, 19, 131, 70, 146, 63, 212, 248, 39, 196, 227, 38, 89, 63, 162, 222, 214, 59, 141, 117, 123, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 164, 198, 108, 185, 170, 183, 63, 230, 58, 121, 148, 12, 116, 181, 191, 10, 152, 152, 58, 199, 85, 224, 191, 18, 161, 221, 41, 119, 70, 150, 191, 140, 127, 155, 171, 40, 251, 186, 191, 167, 112, 213, 60, 139, 200, 212, 191, 85, 146, 5, 97, 43, 232, 170, 63, 199, 229, 175, 190, 42, 134, 208, 191, 13, 149, 52, 174, 223, 240, 208, 63, 139, 141, 173, 130, 171, 173, 212, 191, 44, 236, 199, 35, 185, 82, 221, 63, 77, 174, 50, 204, 231, 136, 217, 63, 45, 38, 7, 216, 172, 149, 127, 63, 86, 71, 76, 0, 130, 177, 216, 63, 38, 125, 110, 27, 210, 43, 211, 63, 181, 184, 57, 44, 27, 16, 170, 191, 48, 111, 126, 197, 165, 115, 223, 63, 154, 62, 175, 99, 247, 134, 225, 191, 64, 209, 200, 111, 228, 134, 180, 63, 160, 100, 255, 248, 254, 159, 223, 191, 125, 82, 18, 252, 155, 201, 210, 63, 243, 248, 41, 253, 10, 32, 215, 63, 16, 203, 221, 13, 254, 247, 211, 191, 191, 38, 197, 24, 138, 251, 210, 191, 25, 24, 177, 68, 54, 36, 217, 63, 246, 78, 37, 133, 154, 129, 142, 191, 176, 157, 145, 162, 255, 188, 208, 63, 13, 133, 187, 241, 200, 156, 219, 63, 133, 164, 176, 197, 84, 183, 209, 63, 83, 214, 113, 238, 187, 51, 207, 191, 109, 9, 152, 27, 50, 143, 189, 191, 138, 245, 238, 142, 191, 104, 136, 191, 97, 52, 146, 75, 56, 50, 177, 191, 239, 149, 196, 23, 242, 191, 208, 191, 213, 108, 230, 47, 82, 132, 210, 191, 244, 130, 57, 252, 134, 237, 203, 191, 238, 134, 15, 239, 202, 23, 220, 63, 135, 142, 229, 247, 100, 54, 130, 191, 154, 199, 85, 135, 76, 185, 209, 63, 168, 237, 185, 209, 240, 154, 205, 191, 138, 97, 207, 68, 206, 7, 193, 191, 126, 75, 216, 159, 44, 202, 223, 191, 19, 2, 191, 167, 242, 110, 200, 191, 141, 136, 240, 167, 159, 227, 189, 63, 145, 58, 253, 80, 45, 139, 206, 63, 130, 126, 246, 216, 108, 175, 131, 63, 23, 210, 137, 143, 58, 99, 110, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 83, 4, 80, 48, 29, 156, 191, 233, 133, 121, 241, 37, 224, 216, 191, 180, 242, 133, 167, 61, 153, 165, 191, 113, 168, 74, 242, 144, 23, 218, 63, 62, 37, 48, 244, 132, 240, 174, 191, 111, 199, 207, 64, 178, 34, 207, 191, 81, 208, 103, 63, 42, 128, 164, 63, 158, 81, 71, 218, 244, 194, 192, 63, 118, 211, 250, 236, 175, 234, 213, 63, 42, 213, 197, 189, 35, 133, 196, 191, 77, 211, 236, 14, 246, 69, 116, 191, 0, 87, 177, 168, 85, 85, 183, 191, 209, 9, 25, 89, 62, 169, 204, 63, 226, 38, 12, 119, 142, 104, 220, 191, 9, 100, 142, 175, 227, 203, 201, 63, 217, 64, 5, 65, 107, 194, 178, 63, 193, 55, 44, 215, 82, 133, 166, 191, 70, 254, 142, 21, 150, 74, 193, 63, 177, 155, 125, 119, 250, 55, 169, 191, 134, 241, 6, 111, 181, 138, 193, 63, 63, 50, 29, 46, 100, 239, 154, 191, 33, 252, 237, 19, 71, 27, 200, 63, 207, 131, 28, 219, 149, 182, 219, 191, 184, 27, 201, 30, 64, 238, 208, 63, 204, 132, 0, 1, 142, 179, 215, 63, 165, 121, 13, 35, 86, 31, 220, 191, 205, 127, 35, 175, 145, 166, 210, 191, 210, 4, 208, 188, 23, 22, 198, 191, 76, 158, 174, 149, 115, 112, 209, 63, 100, 60, 162, 118, 203, 15, 165, 63, 211, 34, 41, 193, 236, 22, 192, 63, 75, 124, 115, 11, 166, 84, 218, 63, 60, 237, 47, 70, 3, 46, 202, 191, 245, 86, 195, 180, 230, 116, 226, 191, 64, 28, 251, 197, 223, 28, 212, 63, 60, 221, 188, 225, 55, 112, 221, 63, 97, 222, 80, 119, 241, 239, 187, 191, 187, 2, 76, 15, 201, 162, 119, 63, 109, 242, 198, 140, 16, 61, 226, 63, 186, 228, 83, 37, 22, 217, 213, 191, 102, 199, 170, 84, 5, 168, 201, 191, 75, 235, 31, 143, 159, 222, 173, 191, 87, 170, 124, 243, 36, 69, 227, 63, 248, 144, 158, 231, 69, 94, 213, 191, 182, 238, 99, 41, 188, 45, 226, 191, 166, 71, 79, 203, 254, 111, 151, 63, 202, 42, 93, 148, 55, 172, 78, 63, 176, 104, 7, 252, 30, 226, 231, 63, 78, 13, 16, 148, 236, 255, 201, 191, 114, 130, 179, 95, 71, 104, 210, 63, 248, 30, 221, 86, 199, 113, 179, 191, 110, 96, 138, 221, 210, 58, 213, 63, 106, 41, 69, 173, 115, 131, 149, 63, 227, 130, 254, 86, 148, 46, 213, 191, 152, 20, 133, 8, 251, 96, 208, 63, 201, 53, 171, 129, 46, 52, 200, 191, 160, 199, 252, 58, 161, 204, 207, 63, 220, 217, 226, 247, 184, 41, 210, 63, 130, 194, 127, 22, 252, 134, 193, 63, 157, 140, 106, 179, 136, 91, 213, 191, 252, 122, 60, 153, 115, 228, 212, 191, 176, 252, 22, 105, 252, 162, 124, 63, 71, 144, 182, 132, 245, 105, 192, 63, 52, 219, 93, 152, 161, 166, 205, 191, 20, 129, 9, 9, 56, 25, 213, 63, 27, 186, 225, 121, 58, 13, 213, 63, 70, 105, 199, 164, 248, 214, 211, 191, 28, 147, 251, 70, 78, 131, 154, 63, 45, 60, 136, 169, 218, 2, 210, 63, 217, 103, 132, 205, 57, 83, 213, 63, 247, 190, 234, 3, 109, 60, 192, 63, 61, 47, 65, 136, 9, 35, 207, 63, 104, 195, 44, 181, 113, 144, 207, 191, 70, 235, 3, 30, 245, 255, 201, 191, 35, 27, 139, 188, 131, 41, 183, 63, 148, 212, 3, 188, 124, 109, 205, 191, 176, 49, 59, 195, 99, 95, 203, 191, 158, 6, 214, 223, 182, 191, 207, 63, 60, 136, 181, 102, 204, 201, 211, 191, 108, 220, 75, 36, 215, 170, 209, 63, 90, 115, 171, 55, 242, 192, 194, 191, 8, 172, 132, 14, 119, 97, 176, 63, 24, 182, 5, 183, 144, 228, 192, 191, 147, 89, 71, 253, 32, 26, 208, 63, 47, 220, 222, 166, 75, 32, 217, 191, 183, 102, 67, 3, 197, 241, 211, 63, 13, 74, 127, 214, 53, 171, 202, 191, 245, 106, 138, 22, 83, 200, 189, 191, 249, 125, 251, 205, 4, 140, 206, 191, 244, 146, 200, 243, 38, 123, 191, 191, 190, 222, 119, 80, 179, 209, 212, 191, 46, 180, 124, 210, 245, 110, 198, 63, 33, 255, 110, 136, 114, 7, 226, 191, 91, 248, 161, 246, 97, 203, 207, 63, 241, 136, 193, 233, 43, 105, 227, 191, 13, 250, 107, 52, 247, 11, 211, 63, 0, 0, 0, 0, 0, 0, 0, 128, 252, 89, 212, 106, 34, 212, 217, 63, 236, 50, 233, 98, 11, 221, 205, 63, 161, 231, 157, 152, 147, 209, 203, 63, 221, 5, 205, 133, 15, 46, 160, 191, 177, 175, 139, 88, 47, 49, 202, 63, 176, 32, 38, 179, 227, 163, 122, 63, 76, 110, 181, 95, 167, 152, 197, 191, 110, 88, 250, 20, 88, 17, 216, 63, 173, 13, 219, 179, 220, 210, 209, 63, 85, 76, 238, 121, 7, 176, 224, 63, 203, 156, 62, 160, 249, 243, 220, 191, 133, 184, 132, 239, 57, 135, 128, 191, 95, 53, 104, 70, 29, 123, 164, 191, 109, 18, 213, 23, 43, 126, 217, 191, 136, 51, 40, 165, 69, 9, 202, 63, 179, 141, 82, 24, 28, 212, 208, 63, 14, 237, 17, 54, 147, 66, 111, 63, 156, 66, 67, 94, 159, 95, 177, 63, 186, 176, 222, 35, 47, 13, 190, 191, 42, 83, 111, 42, 152, 252, 225, 63, 58, 230, 96, 40, 157, 205, 204, 63, 41, 39, 145, 243, 189, 37, 129, 63, 8, 30, 154, 192, 194, 235, 220, 191, 18, 152, 225, 26, 179, 36, 221, 63, 201, 210, 15, 140, 198, 206, 196, 191, 75, 34, 228, 196, 101, 135, 196, 63, 59, 0, 85, 181, 138, 173, 156, 191, 214, 91, 142, 47, 123, 197, 196, 191, 118, 89, 176, 168, 139, 70, 214, 191, 106, 140, 103, 184, 134, 120, 194, 191, 2, 102, 121, 155, 85, 175, 198, 191, 104, 227, 76, 42, 140, 151, 227, 191, 56, 25, 97, 123, 75, 62, 138, 191, 10, 164, 169, 52, 89, 144, 217, 191, 227, 220, 8, 76, 202, 221, 205, 191, 31, 145, 118, 81, 215, 196, 182, 63, 27, 5, 180, 117, 251, 241, 215, 63, 195, 77, 115, 183, 129, 30, 192, 63, 191, 140, 94, 240, 237, 247, 214, 191, 137, 163, 46, 237, 123, 242, 206, 191, 253, 210, 251, 219, 120, 77, 179, 63, 31, 239, 56, 166, 210, 6, 216, 63, 10, 68, 234, 188, 203, 248, 182, 63, 27, 51, 173, 45, 13, 186, 198, 191, 155, 126, 161, 30, 1, 163, 213, 63, 253, 92, 222, 126, 136, 34, 209, 191, 0, 250, 5, 82, 76, 48, 219, 191, 67, 86, 187, 47, 102, 224, 202, 191, 0, 0, 0, 0, 0, 0, 0, 0, 208, 3, 130, 183, 66, 60, 225, 63, 241, 160, 81, 152, 157, 202, 216, 191, 193, 191, 180, 34, 31, 95, 170, 191, 181, 155, 255, 4, 56, 35, 195, 63, 35, 105, 106, 252, 151, 153, 144, 63, 148, 25, 155, 12, 242, 248, 222, 191, 72, 73, 46, 179, 109, 24, 191, 63, 51, 79, 90, 94, 8, 59, 207, 63, 70, 156, 120, 206, 101, 95, 203, 191, 193, 104, 84, 58, 177, 88, 189, 63, 93, 157, 146, 7, 53, 131, 217, 191, 235, 137, 104, 105, 54, 212, 205, 63, 204, 188, 7, 4, 222, 124, 215, 191, 129, 151, 13, 154, 57, 55, 115, 191, 23, 175, 113, 189, 15, 73, 213, 63, 109, 142, 71, 240, 119, 163, 180, 63, 180, 14, 92, 254, 68, 50, 223, 63, 184, 74, 184, 48, 58, 36, 204, 191, 198, 167, 211, 32, 211, 193, 179, 191, 125, 165, 130, 6, 84, 14, 221, 191, 126, 242, 78, 4, 94, 85, 208, 191, 234, 211, 145, 197, 113, 133, 218, 63, 85, 33, 145, 181, 182, 236, 214, 191, 104, 186, 118, 10, 73, 21, 144, 63, 154, 255, 133, 72, 248, 57, 195, 191, 125, 154, 81, 24, 44, 149, 215, 191, 98, 95, 107, 26, 57, 203, 189, 63, 243, 5, 242, 63, 226, 188, 196, 191, 90, 88, 191, 25, 46, 1, 213, 63, 172, 63, 139, 215, 74, 18, 200, 63, 160, 22, 155, 43, 212, 203, 223, 63, 239, 128, 132, 88, 6, 61, 209, 63, 51, 30, 25, 41, 117, 119, 200, 191, 104, 36, 73, 123, 45, 199, 168, 191, 205, 41, 219, 48, 87, 80, 209, 63, 122, 49, 179, 92, 225, 23, 222, 63, 169, 86, 81, 21, 104, 60, 167, 63, 201, 208, 60, 250, 98, 37, 176, 191, 32, 32, 208, 50, 146, 177, 209, 63, 97, 158, 64, 71, 177, 33, 209, 63, 136, 41, 124, 204, 217, 223, 223, 191, 159, 71, 54, 234, 251, 205, 182, 63, 160, 180, 104, 32, 193, 58, 204, 63, 137, 47, 195, 185, 135, 234, 210, 191, 96, 36, 109, 76, 183, 226, 87, 191, 126, 5, 145, 53, 235, 52, 201, 191, 13, 131, 85, 214, 4, 197, 182, 191, 84, 130, 235, 2, 79, 160, 218, 191, 0, 0, 0, 0, 0, 0, 0, 128, 158, 84, 226, 133, 88, 10, 208, 63, 246, 35, 242, 77, 185, 171, 222, 191, 64, 61, 110, 23, 177, 187, 226, 63, 152, 80, 220, 17, 216, 18, 216, 63, 38, 139, 174, 78, 20, 149, 226, 63, 222, 13, 216, 195, 76, 7, 194, 63, 27, 220, 116, 23, 83, 133, 224, 191, 101, 116, 16, 32, 162, 21, 225, 191, 170, 87, 208, 108, 1, 38, 193, 191, 178, 29, 5, 245, 167, 106, 134, 191, 141, 94, 198, 21, 75, 58, 188, 191, 193, 121, 138, 112, 44, 87, 161, 191, 246, 23, 130, 63, 113, 48, 215, 63, 36, 57, 160, 180, 235, 206, 148, 63, 72, 60, 28, 116, 47, 105, 201, 191, 172, 47, 114, 191, 7, 155, 202, 63, 58, 164, 206, 154, 150, 235, 177, 63, 239, 43, 47, 122, 86, 190, 174, 191, 233, 175, 162, 201, 228, 211, 210, 63, 32, 196, 55, 11, 4, 186, 195, 63, 52, 192, 138, 213, 61, 164, 150, 191, 131, 24, 153, 105, 137, 29, 214, 63, 114, 213, 191, 59, 125, 219, 179, 191, 188, 162, 55, 12, 152, 138, 168, 191, 79, 77, 73, 151, 58, 39, 225, 191, 203, 186, 255, 134, 137, 49, 206, 191, 168, 206, 118, 244, 125, 97, 188, 191, 208, 29, 108, 16, 56, 117, 225, 191, 117, 56, 246, 100, 130, 243, 168, 191, 217, 47, 193, 190, 75, 21, 225, 191, 44, 182, 161, 152, 73, 84, 209, 191, 203, 175, 140, 92, 30, 150, 171, 191, 85, 242, 210, 13, 94, 105, 171, 191, 253, 186, 44, 26, 59, 159, 182, 63, 38, 48, 144, 72, 63, 92, 184, 63, 91, 132, 219, 183, 4, 7, 203, 191, 42, 173, 204, 42, 82, 170, 162, 191, 61, 201, 52, 255, 134, 203, 208, 63, 62, 177, 80, 35, 61, 191, 225, 63, 87, 23, 193, 166, 230, 4, 186, 63, 153, 2, 77, 103, 81, 118, 197, 191, 72, 151, 98, 184, 5, 119, 173, 191, 222, 133, 224, 156, 34, 187, 174, 191, 175, 32, 145, 40, 228, 192, 177, 63, 2, 166, 38, 112, 18, 145, 132, 191, 121, 9, 61, 65, 106, 237, 177, 63, 128, 246, 197, 231, 10, 77, 131, 191, 161, 77, 6, 27, 38, 10, 224, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 135, 138, 126, 135, 209, 205, 191, 222, 112, 41, 185, 137, 179, 225, 63, 35, 189, 57, 66, 63, 224, 201, 191, 238, 171, 61, 236, 105, 45, 227, 191, 79, 25, 68, 163, 156, 231, 198, 63, 195, 178, 121, 168, 180, 238, 214, 191, 209, 146, 21, 216, 219, 233, 206, 63, 97, 76, 110, 211, 33, 89, 225, 63, 15, 35, 70, 152, 10, 22, 152, 63, 235, 234, 112, 112, 234, 236, 195, 63, 36, 98, 197, 12, 244, 244, 212, 63, 8, 50, 144, 141, 241, 110, 214, 191, 32, 215, 199, 195, 163, 200, 225, 191, 189, 66, 243, 16, 249, 143, 195, 63, 186, 34, 193, 231, 68, 25, 210, 63, 254, 148, 90, 55, 56, 22, 183, 191, 52, 89, 165, 74, 94, 56, 209, 191, 50, 12, 245, 216, 130, 30, 182, 63, 6, 112, 165, 152, 15, 50, 163, 191, 143, 172, 49, 83, 242, 68, 204, 63, 223, 63, 111, 58, 212, 255, 216, 63, 69, 6, 191, 133, 126, 175, 195, 191, 253, 180, 156, 186, 172, 6, 112, 191, 202, 1, 26, 40, 129, 137, 220, 63, 224, 149, 81, 62, 176, 134, 201, 191, 226, 208, 48, 92, 17, 232, 195, 191, 162, 12, 93, 40, 202, 44, 224, 191, 147, 162, 102, 204, 89, 157, 201, 63, 117, 152, 110, 46, 123, 108, 224, 63, 171, 90, 241, 208, 230, 129, 207, 191, 72, 82, 140, 178, 208, 210, 152, 191, 80, 169, 9, 27, 16, 47, 179, 63, 249, 143, 81, 106, 6, 223, 226, 63, 189, 250, 41, 63, 145, 176, 175, 191, 56, 8, 217, 147, 199, 84, 203, 191, 55, 127, 100, 148, 33, 64, 125, 191, 18, 203, 142, 175, 81, 97, 193, 191, 223, 225, 236, 232, 66, 253, 162, 191, 197, 133, 65, 229, 65, 211, 176, 63, 25, 181, 209, 65, 232, 64, 198, 63, 229, 15, 188, 134, 162, 13, 226, 191, 80, 182, 131, 120, 39, 134, 208, 191, 134, 102, 177, 76, 238, 84, 168, 63, 34, 210, 176, 33, 170, 51, 29, 191, 54, 17, 62, 117, 198, 34, 163, 191, 3, 252, 78, 160, 240, 238, 65, 191, 178, 216, 248, 120, 161, 99, 130, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 66, 117, 243, 34, 122, 196, 191, 114, 159, 196, 175, 108, 78, 116, 191, 79, 193, 88, 220, 19, 180, 201, 63, 113, 159, 149, 199, 167, 185, 119, 191, 100, 117, 127, 189, 254, 196, 224, 191, 234, 33, 90, 4, 1, 215, 185, 191, 140, 8, 225, 175, 88, 23, 184, 191, 33, 94, 188, 140, 122, 168, 216, 63, 33, 157, 238, 77, 231, 57, 197, 63, 124, 243, 214, 215, 155, 92, 216, 63, 0, 204, 79, 146, 133, 3, 226, 63, 1, 139, 248, 219, 219, 217, 199, 63, 104, 120, 115, 167, 64, 160, 134, 63, 27, 131, 181, 25, 124, 76, 191, 191, 230, 78, 185, 204, 169, 229, 213, 191, 205, 27, 152, 24, 248, 86, 225, 191, 225, 47, 99, 11, 17, 43, 226, 63, 227, 24, 9, 236, 61, 214, 211, 63, 124, 126, 194, 112, 46, 59, 184, 63, 87, 125, 168, 187, 157, 162, 225, 191, 4, 9, 30, 238, 200, 158, 213, 63, 241, 11, 72, 234, 241, 2, 218, 191, 56, 249, 52, 202, 141, 141, 194, 191, 25, 251, 84, 113, 240, 154, 160, 191, 163, 191, 21, 141, 24, 115, 197, 191, 238, 123, 204, 38, 193, 255, 193, 63, 30, 82, 252, 79, 235, 124, 145, 191, 242, 203, 249, 86, 246, 170, 223, 191, 62, 20, 71, 79, 187, 68, 166, 191, 128, 149, 35, 135, 33, 6, 215, 63, 84, 0, 36, 4, 183, 56, 185, 63, 143, 237, 100, 244, 129, 158, 205, 63, 86, 75, 123, 127, 147, 158, 185, 191, 3, 221, 103, 202, 68, 215, 186, 191, 151, 241, 156, 212, 68, 7, 215, 63, 138, 125, 255, 143, 186, 109, 170, 191, 215, 212, 110, 227, 38, 101, 219, 191, 238, 159, 227, 241, 220, 99, 144, 191, 86, 210, 122, 11, 36, 175, 184, 63, 38, 128, 174, 87, 114, 144, 218, 63, 175, 138, 1, 28, 188, 209, 200, 63, 170, 5, 95, 146, 192, 41, 226, 191, 94, 241, 116, 144, 143, 84, 195, 191, 131, 193, 112, 211, 90, 165, 158, 63, 177, 27, 70, 147, 56, 203, 167, 63, 59, 98, 63, 240, 33, 64, 114, 191, 216, 223, 186, 37, 159, 111, 122, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 40, 50, 213, 42, 34, 162, 63, 102, 191, 211, 197, 127, 213, 216, 63, 123, 16, 128, 114, 139, 61, 202, 63, 81, 48, 31, 3, 142, 53, 216, 191, 137, 141, 23, 10, 68, 183, 144, 191, 16, 73, 17, 155, 237, 131, 204, 191, 225, 170, 89, 24, 18, 49, 179, 191, 4, 30, 105, 221, 112, 21, 201, 191, 129, 179, 49, 200, 7, 210, 219, 63, 65, 132, 170, 17, 123, 191, 215, 63, 148, 151, 191, 169, 102, 239, 191, 63, 200, 232, 171, 166, 123, 33, 201, 63, 78, 187, 104, 80, 201, 219, 217, 63, 172, 118, 45, 207, 143, 188, 220, 191, 38, 179, 12, 182, 253, 205, 209, 191, 187, 168, 191, 199, 133, 228, 121, 63, 225, 170, 23, 49, 24, 185, 204, 191, 91, 150, 9, 135, 154, 75, 214, 191, 236, 27, 108, 117, 251, 16, 187, 191, 94, 222, 175, 39, 50, 176, 216, 63, 168, 111, 219, 253, 86, 112, 177, 191, 205, 147, 198, 119, 152, 247, 218, 191, 182, 125, 223, 122, 203, 11, 224, 191, 249, 162, 45, 23, 242, 128, 205, 63, 59, 151, 251, 226, 47, 131, 217, 63, 185, 213, 171, 90, 0, 30, 173, 191, 226, 29, 255, 150, 143, 179, 207, 191, 158, 178, 186, 175, 218, 80, 219, 63, 225, 178, 180, 35, 226, 7, 203, 63, 150, 246, 63, 89, 237, 1, 196, 191, 122, 177, 189, 253, 136, 44, 200, 191, 239, 12, 22, 102, 16, 211, 153, 63, 102, 84, 1, 242, 52, 235, 215, 191, 47, 199, 194, 75, 212, 38, 217, 63, 98, 72, 38, 174, 193, 103, 208, 63, 103, 23, 100, 173, 56, 38, 216, 63, 130, 121, 174, 206, 165, 121, 174, 63, 227, 231, 161, 166, 104, 152, 133, 63, 110, 53, 59, 21, 39, 84, 218, 191, 5, 143, 59, 176, 154, 92, 203, 191, 119, 210, 227, 49, 74, 167, 214, 63, 171, 105, 238, 44, 245, 22, 208, 191, 170, 170, 87, 239, 48, 222, 210, 191, 77, 180, 8, 5, 14, 167, 203, 191, 243, 46, 105, 76, 232, 156, 216, 63, 253, 205, 233, 62, 40, 125, 146, 191, 38, 16, 169, 14, 57, 77, 81, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 23, 82, 187, 93, 68, 171, 63, 125, 86, 232, 63, 186, 66, 190, 191, 85, 155, 181, 76, 23, 79, 212, 191, 251, 208, 31, 117, 148, 58, 161, 191, 234, 44, 186, 188, 237, 232, 220, 191, 97, 69, 244, 173, 197, 42, 214, 63, 32, 231, 147, 129, 119, 173, 161, 63, 13, 170, 197, 76, 71, 113, 198, 191, 239, 34, 198, 18, 192, 188, 215, 63, 100, 51, 212, 29, 46, 233, 170, 63, 250, 184, 121, 159, 10, 250, 204, 191, 21, 84, 129, 38, 226, 49, 213, 63, 60, 159, 97, 166, 58, 40, 121, 191, 45, 153, 72, 249, 77, 79, 196, 63, 20, 191, 211, 255, 57, 83, 206, 63, 253, 94, 107, 104, 22, 74, 221, 191, 191, 143, 187, 132, 26, 50, 202, 191, 241, 29, 48, 90, 217, 228, 203, 191, 195, 56, 55, 156, 184, 164, 159, 63, 146, 203, 237, 248, 217, 145, 185, 63, 38, 251, 23, 107, 155, 236, 218, 63, 100, 23, 241, 143, 182, 116, 177, 191, 183, 129, 207, 18, 209, 197, 220, 191, 106, 141, 27, 235, 132, 86, 214, 63, 135, 36, 78, 41, 79, 191, 139, 63, 108, 118, 70, 137, 7, 143, 196, 63, 9, 37, 117, 14, 219, 163, 213, 191, 2, 58, 228, 245, 97, 78, 115, 63, 165, 164, 27, 101, 171, 70, 215, 191, 158, 184, 77, 226, 138, 136, 176, 191, 45, 255, 163, 17, 175, 74, 193, 63, 32, 110, 11, 211, 215, 112, 208, 63, 222, 10, 154, 202, 177, 170, 170, 63, 138, 69, 117, 198, 253, 145, 224, 63, 226, 6, 55, 139, 22, 59, 186, 63, 154, 122, 113, 60, 128, 136, 225, 191, 134, 206, 215, 103, 65, 178, 211, 63, 182, 119, 88, 250, 195, 107, 119, 63, 133, 160, 215, 115, 144, 239, 223, 191, 187, 144, 131, 52, 246, 19, 178, 63, 40, 175, 92, 110, 66, 48, 186, 191, 187, 179, 126, 109, 212, 205, 200, 63, 36, 22, 135, 191, 147, 107, 226, 63, 99, 227, 72, 222, 135, 132, 220, 63, 7, 245, 79, 135, 214, 250, 226, 191, 248, 199, 20, 166, 3, 5, 160, 191, 219, 5, 190, 252, 212, 236, 96, 191, 36, 233, 99, 248, 194, 20, 235, 63, 24, 168, 84, 198, 233, 51, 215, 191, 244, 230, 190, 144, 121, 230, 172, 63, 245, 180, 237, 126, 201, 93, 211, 63, 247, 134, 100, 185, 12, 5, 203, 191, 165, 69, 163, 245, 62, 61, 212, 63, 181, 237, 107, 203, 177, 221, 189, 191, 222, 110, 238, 16, 23, 199, 191, 63, 74, 244, 46, 193, 180, 45, 204, 63, 35, 46, 203, 43, 213, 152, 193, 63, 242, 178, 104, 8, 48, 151, 179, 63, 116, 216, 55, 217, 105, 36, 214, 191, 106, 214, 21, 60, 120, 167, 196, 191, 105, 60, 84, 78, 58, 93, 207, 191, 243, 15, 46, 18, 139, 77, 212, 63, 231, 89, 32, 238, 88, 229, 213, 191, 12, 191, 102, 131, 157, 19, 197, 63, 151, 28, 131, 135, 90, 239, 186, 191, 185, 199, 84, 102, 123, 174, 205, 191, 139, 144, 90, 32, 225, 221, 210, 191, 163, 93, 230, 38, 242, 165, 209, 191, 244, 236, 106, 65, 73, 113, 213, 191, 196, 72, 25, 91, 156, 173, 194, 191, 58, 133, 194, 254, 197, 218, 213, 191, 160, 195, 14, 184, 173, 129, 149, 63, 75, 146, 26, 156, 26, 0, 194, 63, 242, 216, 244, 249, 233, 51, 215, 191, 112, 172, 75, 121, 251, 246, 210, 63, 158, 16, 119, 34, 198, 105, 197, 63, 202, 63, 43, 129, 23, 53, 215, 191, 172, 148, 168, 81, 31, 175, 193, 63, 200, 236, 33, 107, 241, 248, 210, 191, 126, 34, 237, 35, 70, 212, 176, 63, 192, 6, 17, 173, 134, 176, 208, 63, 130, 148, 178, 144, 125, 164, 211, 63, 37, 205, 19, 73, 39, 80, 190, 191, 81, 75, 217, 150, 124, 177, 214, 191, 131, 216, 177, 140, 115, 67, 206, 63, 61, 230, 81, 77, 220, 236, 142, 191, 209, 241, 84, 168, 5, 60, 201, 63, 19, 143, 156, 3, 165, 114, 193, 191, 30, 2, 66, 197, 241, 249, 214, 191, 153, 238, 180, 24, 166, 202, 209, 63, 58, 50, 219, 130, 169, 2, 208, 191, 105, 63, 145, 25, 66, 12, 177, 191, 129, 120, 106, 156, 70, 126, 224, 63, 156, 169, 153, 29, 230, 147, 156, 63, 171, 84, 190, 151, 44, 231, 226, 63, 92, 57, 215, 48, 148, 130, 158, 63, 0, 0, 0, 0, 0, 0, 0, 128, 84, 0, 228, 169, 17, 62, 142, 63, 130, 34, 123, 211, 186, 246, 220, 191, 150, 237, 86, 17, 161, 235, 176, 63, 249, 27, 81, 101, 122, 109, 206, 191, 73, 78, 166, 7, 127, 75, 145, 191, 213, 47, 144, 47, 128, 228, 168, 63, 10, 60, 191, 115, 76, 192, 206, 63, 158, 32, 204, 135, 229, 192, 212, 63, 107, 236, 145, 37, 87, 221, 215, 191, 168, 35, 186, 217, 228, 18, 226, 63, 81, 41, 23, 167, 46, 252, 194, 63, 246, 199, 157, 90, 183, 159, 215, 191, 211, 34, 22, 85, 150, 154, 194, 63, 246, 24, 234, 213, 79, 96, 134, 63, 140, 85, 29, 226, 36, 157, 178, 191, 228, 151, 151, 16, 106, 200, 211, 63, 90, 3, 128, 234, 68, 103, 152, 191, 2, 154, 122, 158, 97, 53, 212, 63, 1, 97, 10, 214, 55, 61, 200, 63, 182, 130, 153, 105, 172, 145, 214, 191, 103, 152, 227, 166, 12, 254, 196, 63, 120, 89, 119, 49, 248, 35, 193, 191, 73, 149, 55, 29, 44, 241, 196, 63, 27, 113, 86, 130, 237, 65, 222, 63, 20, 51, 66, 57, 9, 116, 203, 191, 253, 232, 175, 133, 131, 8, 120, 63, 223, 202, 61, 222, 252, 246, 132, 63, 1, 148, 178, 178, 201, 25, 200, 191, 143, 116, 41, 137, 188, 120, 131, 63, 182, 130, 95, 201, 32, 167, 200, 63, 105, 133, 87, 103, 189, 206, 209, 63, 43, 79, 99, 249, 76, 14, 229, 191, 160, 208, 225, 171, 226, 98, 128, 191, 72, 84, 162, 215, 24, 10, 186, 63, 150, 52, 195, 155, 89, 208, 202, 63, 25, 19, 111, 42, 228, 177, 157, 63, 17, 110, 230, 124, 235, 133, 220, 191, 52, 159, 184, 228, 135, 186, 214, 191, 73, 161, 205, 147, 118, 194, 214, 191, 149, 202, 139, 122, 41, 24, 203, 63, 100, 44, 201, 89, 147, 241, 143, 191, 57, 124, 226, 94, 104, 134, 200, 63, 216, 193, 35, 59, 120, 19, 211, 191, 203, 201, 182, 3, 117, 185, 197, 191, 64, 248, 95, 34, 66, 224, 220, 191, 147, 131, 149, 31, 220, 227, 209, 191, 221, 217, 86, 80, 98, 149, 226, 63, 245, 136, 158, 197, 43, 169, 221, 63, 0, 0, 0, 0, 0, 0, 0, 0, 80, 75, 137, 66, 97, 125, 225, 63, 227, 221, 82, 146, 191, 254, 194, 191, 139, 52, 1, 172, 250, 134, 206, 63, 142, 36, 73, 195, 7, 190, 174, 191, 214, 250, 36, 88, 139, 10, 210, 63, 104, 187, 168, 220, 77, 48, 179, 191, 148, 204, 22, 203, 245, 84, 181, 63, 9, 235, 139, 234, 141, 70, 214, 191, 210, 17, 233, 115, 167, 198, 196, 191, 28, 117, 114, 143, 175, 24, 200, 63, 56, 119, 11, 229, 184, 76, 221, 63, 14, 163, 186, 99, 54, 62, 176, 63, 235, 158, 201, 91, 188, 29, 199, 191, 126, 58, 27, 239, 202, 118, 207, 191, 188, 67, 236, 225, 67, 197, 216, 191, 39, 27, 134, 214, 220, 42, 179, 191, 151, 139, 171, 255, 25, 254, 174, 191, 233, 153, 113, 19, 50, 179, 185, 63, 72, 117, 92, 55, 194, 33, 169, 191, 237, 159, 58, 120, 1, 40, 227, 63, 122, 26, 160, 93, 109, 128, 201, 63, 194, 161, 255, 49, 12, 158, 184, 191, 126, 247, 196, 17, 189, 187, 218, 63, 205, 243, 212, 164, 249, 216, 153, 63, 167, 54, 225, 108, 250, 225, 189, 63, 104, 216, 21, 74, 66, 238, 215, 191, 192, 222, 58, 228, 236, 111, 220, 63, 74, 135, 25, 105, 95, 163, 195, 63, 252, 195, 97, 138, 107, 199, 212, 63, 71, 94, 131, 195, 32, 93, 194, 63, 68, 167, 122, 51, 116, 99, 212, 63, 23, 32, 95, 29, 10, 50, 220, 63, 37, 119, 177, 86, 160, 226, 217, 63, 189, 22, 238, 65, 122, 59, 209, 191, 94, 152, 195, 132, 167, 255, 217, 191, 144, 241, 251, 120, 93, 169, 218, 191, 219, 110, 228, 171, 155, 23, 180, 191, 88, 189, 146, 130, 228, 131, 129, 191, 174, 194, 54, 13, 234, 250, 212, 191, 27, 32, 55, 3, 241, 114, 217, 191, 43, 156, 16, 29, 126, 117, 221, 191, 123, 175, 202, 72, 133, 85, 206, 191, 147, 60, 21, 64, 83, 147, 188, 63, 228, 229, 80, 115, 253, 54, 221, 191, 168, 239, 98, 75, 39, 25, 102, 63, 211, 177, 241, 100, 240, 79, 212, 191, 72, 127, 110, 139, 195, 98, 197, 63, 141, 246, 85, 109, 240, 81, 190, 191, 0, 0, 0, 0, 0, 0, 0, 128, 117, 51, 178, 35, 83, 188, 223, 63, 120, 52, 55, 248, 1, 237, 219, 63, 113, 149, 154, 30, 26, 190, 190, 63, 90, 83, 232, 160, 209, 44, 225, 191, 69, 62, 137, 199, 148, 191, 160, 191, 0, 51, 61, 39, 29, 90, 198, 63, 166, 27, 170, 33, 81, 117, 217, 63, 185, 203, 82, 76, 127, 72, 210, 191, 181, 239, 9, 156, 222, 106, 185, 63, 211, 214, 12, 52, 39, 144, 157, 191, 173, 247, 248, 52, 45, 208, 205, 63, 62, 63, 3, 153, 155, 254, 166, 191, 254, 130, 237, 240, 12, 103, 225, 63, 156, 43, 210, 49, 135, 243, 56, 191, 125, 52, 199, 32, 52, 9, 219, 63, 194, 186, 245, 147, 26, 14, 194, 63, 146, 2, 157, 163, 37, 212, 181, 191, 74, 27, 195, 108, 217, 158, 182, 63, 205, 113, 124, 156, 240, 148, 222, 63, 207, 25, 14, 61, 243, 145, 214, 191, 28, 169, 42, 127, 161, 221, 163, 63, 205, 175, 146, 171, 1, 169, 220, 191, 69, 22, 29, 9, 210, 38, 197, 63, 170, 19, 200, 232, 254, 227, 191, 191, 54, 89, 93, 215, 187, 46, 217, 191, 45, 214, 194, 44, 92, 222, 221, 191, 191, 133, 120, 129, 113, 213, 155, 63, 75, 254, 157, 251, 217, 121, 215, 191, 30, 216, 108, 82, 196, 94, 184, 191, 42, 249, 28, 214, 209, 68, 217, 63, 105, 82, 214, 185, 48, 58, 220, 191, 162, 176, 153, 223, 238, 35, 194, 191, 175, 101, 65, 33, 186, 50, 150, 191, 142, 251, 105, 85, 252, 51, 143, 191, 105, 244, 80, 248, 144, 64, 206, 191, 250, 40, 192, 188, 159, 12, 217, 63, 246, 106, 27, 236, 44, 133, 185, 63, 212, 247, 147, 63, 115, 156, 209, 191, 107, 78, 137, 170, 195, 56, 213, 63, 35, 187, 180, 148, 237, 10, 208, 191, 166, 167, 227, 68, 219, 72, 212, 191, 58, 11, 103, 8, 216, 213, 147, 191, 254, 125, 97, 152, 29, 62, 183, 191, 108, 144, 243, 122, 234, 117, 198, 63, 59, 17, 15, 237, 218, 132, 157, 63, 13, 111, 169, 121, 56, 87, 199, 63, 196, 174, 135, 13, 142, 2, 156, 63, 84, 156, 227, 11, 76, 226, 222, 191, 0, 0, 0, 0, 0, 0, 0, 0, 152, 54, 183, 227, 13, 148, 201, 63, 16, 176, 37, 226, 203, 116, 221, 63, 243, 27, 115, 133, 159, 235, 209, 191, 113, 122, 196, 249, 37, 49, 212, 191, 22, 51, 45, 157, 139, 226, 198, 191, 50, 103, 188, 181, 198, 11, 217, 63, 121, 171, 100, 153, 181, 93, 218, 191, 97, 196, 51, 81, 179, 27, 225, 63, 228, 195, 212, 175, 37, 78, 186, 191, 164, 193, 170, 177, 207, 151, 150, 191, 244, 20, 163, 54, 0, 222, 160, 63, 41, 112, 164, 55, 53, 139, 206, 191, 96, 125, 63, 82, 57, 7, 158, 191, 8, 164, 98, 106, 90, 105, 210, 191, 14, 16, 184, 204, 241, 83, 151, 191, 124, 127, 227, 43, 54, 48, 223, 191, 61, 237, 91, 238, 42, 85, 219, 63, 100, 102, 131, 168, 162, 201, 206, 191, 24, 201, 75, 181, 171, 59, 211, 191, 88, 3, 170, 165, 231, 82, 186, 63, 180, 121, 67, 82, 69, 17, 196, 191, 165, 79, 67, 48, 168, 148, 193, 63, 61, 23, 143, 158, 90, 241, 85, 191, 12, 122, 218, 190, 241, 216, 163, 191, 77, 93, 4, 113, 0, 243, 212, 191, 13, 121, 94, 252, 141, 40, 138, 191, 161, 18, 134, 4, 135, 31, 227, 63, 168, 203, 156, 146, 67, 23, 208, 191, 61, 4, 157, 237, 45, 96, 172, 191, 230, 216, 6, 99, 235, 8, 202, 191, 114, 103, 76, 8, 176, 96, 200, 63, 73, 216, 88, 153, 223, 161, 151, 63, 157, 48, 247, 16, 124, 39, 227, 63, 190, 124, 189, 11, 12, 50, 201, 191, 150, 193, 4, 135, 205, 203, 96, 63, 246, 27, 222, 181, 205, 153, 187, 63, 59, 150, 98, 52, 99, 209, 144, 191, 13, 68, 160, 7, 171, 157, 221, 191, 120, 30, 134, 218, 226, 109, 226, 63, 72, 12, 119, 117, 10, 77, 98, 191, 122, 176, 234, 163, 186, 202, 194, 63, 31, 160, 51, 233, 40, 193, 205, 191, 184, 169, 154, 26, 25, 225, 205, 191, 165, 204, 182, 156, 234, 245, 149, 63, 254, 230, 56, 85, 151, 68, 114, 191, 80, 222, 203, 109, 179, 148, 125, 191, 22, 74, 2, 61, 63, 128, 100, 63, 48, 5, 255, 131, 150, 28, 224, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 216, 30, 173, 208, 60, 210, 63, 221, 222, 15, 238, 252, 56, 225, 191, 115, 66, 156, 191, 211, 16, 214, 63, 174, 155, 241, 219, 11, 196, 220, 63, 245, 153, 218, 42, 202, 156, 214, 63, 1, 147, 189, 88, 163, 154, 225, 191, 118, 48, 93, 62, 163, 153, 211, 191, 199, 34, 67, 170, 6, 17, 221, 191, 199, 12, 77, 179, 163, 232, 110, 63, 61, 231, 179, 199, 127, 18, 190, 191, 210, 173, 128, 108, 73, 151, 194, 63, 18, 135, 108, 84, 203, 126, 195, 63, 58, 160, 152, 118, 16, 14, 215, 191, 95, 235, 215, 48, 130, 240, 175, 63, 180, 139, 18, 173, 105, 212, 178, 63, 25, 149, 162, 59, 205, 223, 217, 191, 5, 92, 141, 204, 85, 56, 182, 191, 183, 89, 192, 18, 216, 255, 207, 191, 192, 96, 216, 155, 45, 22, 160, 191, 247, 93, 155, 94, 135, 81, 183, 63, 127, 108, 67, 42, 80, 5, 136, 63, 253, 176, 205, 122, 26, 189, 186, 63, 48, 11, 140, 9, 100, 158, 137, 63, 244, 115, 185, 99, 18, 172, 224, 63, 18, 199, 2, 180, 112, 92, 178, 191, 175, 75, 128, 168, 58, 158, 227, 63, 29, 104, 0, 38, 196, 116, 222, 191, 229, 197, 97, 193, 225, 132, 191, 191, 82, 33, 187, 73, 125, 81, 219, 63, 84, 89, 249, 141, 203, 226, 207, 63, 74, 22, 11, 14, 174, 82, 141, 63, 255, 19, 44, 68, 110, 209, 227, 191, 180, 197, 24, 74, 244, 41, 221, 63, 181, 199, 238, 12, 108, 172, 137, 63, 214, 136, 29, 238, 54, 64, 163, 63, 142, 88, 137, 44, 94, 121, 126, 191, 51, 116, 70, 125, 11, 54, 201, 191, 137, 167, 229, 108, 228, 98, 168, 191, 36, 232, 99, 31, 157, 243, 144, 191, 52, 199, 64, 46, 49, 18, 182, 191, 145, 51, 112, 170, 96, 228, 217, 63, 221, 215, 160, 33, 73, 176, 180, 191, 105, 13, 96, 202, 253, 116, 112, 63, 46, 165, 245, 214, 14, 129, 78, 63, 175, 147, 151, 92, 4, 247, 135, 63, 174, 149, 78, 131, 9, 175, 39, 63, 181, 25, 5, 75, 38, 213, 134, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 3, 193, 42, 228, 3, 206, 63, 99, 160, 241, 249, 188, 14, 192, 63, 67, 205, 28, 196, 202, 104, 212, 63, 228, 41, 143, 216, 227, 27, 163, 63, 154, 120, 44, 199, 13, 101, 207, 63, 13, 222, 147, 88, 186, 136, 211, 63, 15, 183, 43, 114, 122, 73, 194, 63, 148, 195, 21, 138, 100, 109, 220, 191, 234, 245, 153, 23, 4, 143, 177, 63, 82, 205, 212, 213, 4, 68, 215, 191, 54, 53, 240, 124, 24, 185, 222, 63, 108, 28, 92, 122, 180, 156, 226, 191, 196, 101, 111, 234, 62, 147, 135, 63, 95, 10, 54, 200, 151, 2, 215, 191, 81, 104, 160, 230, 39, 40, 203, 63, 10, 178, 177, 213, 16, 23, 191, 63, 99, 146, 138, 89, 220, 3, 220, 63, 13, 225, 47, 78, 42, 220, 195, 63, 247, 58, 242, 128, 203, 71, 184, 63, 183, 68, 249, 167, 221, 107, 219, 191, 145, 155, 7, 96, 144, 232, 225, 191, 93, 30, 79, 55, 128, 46, 215, 63, 207, 127, 187, 122, 241, 5, 135, 191, 38, 129, 137, 122, 142, 40, 215, 63, 126, 136, 192, 250, 160, 234, 219, 191, 174, 181, 223, 253, 80, 149, 165, 63, 229, 196, 248, 18, 226, 11, 216, 191, 131, 65, 159, 82, 156, 168, 219, 63, 100, 104, 68, 143, 125, 219, 218, 191, 37, 159, 9, 198, 134, 94, 220, 191, 197, 2, 68, 144, 220, 11, 178, 191, 65, 92, 161, 158, 195, 44, 161, 63, 81, 51, 132, 10, 213, 198, 188, 191, 21, 230, 221, 230, 255, 192, 197, 63, 140, 7, 17, 78, 25, 1, 220, 63, 29, 177, 99, 228, 92, 27, 150, 63, 20, 195, 70, 88, 237, 37, 196, 63, 15, 19, 224, 91, 146, 26, 153, 191, 29, 97, 99, 198, 13, 240, 198, 191, 176, 142, 32, 216, 153, 64, 215, 63, 109, 171, 38, 239, 37, 223, 202, 191, 49, 130, 62, 233, 20, 162, 219, 191, 155, 176, 131, 107, 22, 4, 193, 63, 203, 81, 109, 35, 13, 43, 55, 63, 127, 97, 210, 77, 35, 139, 187, 191, 64, 170, 232, 122, 165, 197, 92, 63, 60, 147, 135, 87, 142, 146, 131, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 241, 73, 217, 11, 130, 153, 191, 181, 10, 50, 142, 248, 167, 147, 63, 188, 219, 180, 127, 135, 242, 190, 191, 206, 53, 176, 35, 187, 193, 181, 191, 42, 125, 30, 133, 154, 24, 200, 191, 121, 92, 201, 57, 61, 153, 166, 191, 205, 20, 127, 151, 157, 164, 186, 63, 55, 73, 60, 22, 36, 223, 200, 63, 177, 148, 63, 40, 214, 223, 211, 63, 147, 252, 23, 209, 138, 141, 224, 191, 220, 12, 116, 213, 220, 21, 209, 63, 201, 163, 35, 95, 159, 129, 192, 63, 145, 107, 231, 231, 164, 71, 223, 63, 231, 28, 70, 129, 103, 131, 197, 63, 124, 56, 153, 245, 224, 221, 204, 63, 253, 75, 48, 43, 5, 215, 198, 63, 34, 58, 54, 5, 189, 220, 215, 191, 202, 115, 115, 253, 15, 151, 208, 63, 47, 243, 246, 222, 242, 152, 194, 191, 142, 196, 240, 25, 155, 83, 225, 63, 121, 174, 231, 90, 55, 204, 194, 191, 135, 19, 208, 223, 78, 233, 225, 63, 34, 90, 184, 63, 204, 7, 209, 191, 131, 180, 154, 1, 225, 76, 145, 63, 133, 167, 147, 66, 182, 50, 202, 191, 24, 134, 229, 196, 234, 154, 220, 63, 35, 148, 108, 101, 51, 162, 135, 63, 180, 137, 157, 156, 219, 236, 226, 191, 44, 240, 19, 93, 165, 158, 150, 191, 214, 179, 246, 240, 73, 96, 211, 63, 183, 94, 209, 223, 61, 135, 199, 63, 200, 179, 6, 247, 211, 90, 217, 191, 39, 231, 233, 70, 189, 226, 221, 191, 27, 240, 176, 39, 102, 40, 199, 63, 35, 9, 105, 58, 163, 23, 217, 191, 0, 18, 72, 111, 84, 244, 185, 63, 176, 123, 107, 65, 64, 64, 161, 63, 29, 119, 67, 24, 98, 53, 141, 63, 106, 74, 113, 99, 229, 22, 197, 191, 112, 244, 94, 239, 132, 251, 221, 63, 156, 202, 215, 190, 57, 27, 219, 191, 124, 169, 39, 46, 41, 166, 217, 191, 164, 170, 111, 88, 56, 28, 209, 191, 76, 79, 85, 7, 189, 5, 176, 191, 26, 148, 143, 44, 211, 229, 181, 63, 144, 231, 166, 212, 147, 90, 131, 63, 190, 19, 134, 87, 79, 164, 58, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 230, 64, 39, 210, 102, 188, 191, 21, 160, 85, 93, 228, 137, 193, 63, 38, 160, 81, 8, 195, 104, 209, 63, 61, 150, 53, 186, 59, 115, 162, 63, 230, 70, 173, 97, 80, 209, 181, 63, 212, 163, 236, 100, 39, 165, 219, 63, 16, 12, 177, 125, 74, 46, 180, 191, 68, 217, 137, 214, 170, 98, 214, 63, 115, 201, 168, 182, 0, 135, 226, 63, 216, 157, 170, 90, 247, 181, 208, 191, 50, 124, 237, 128, 224, 31, 212, 191, 67, 239, 2, 78, 64, 24, 197, 191, 8, 217, 99, 209, 128, 47, 138, 191, 80, 74, 85, 90, 68, 219, 212, 63, 142, 239, 253, 14, 87, 233, 218, 191, 196, 68, 14, 10, 19, 216, 165, 63, 67, 248, 151, 70, 67, 4, 205, 191, 89, 205, 127, 230, 17, 8, 188, 63, 221, 211, 52, 88, 207, 95, 185, 63, 135, 77, 236, 127, 143, 48, 150, 191, 184, 159, 1, 213, 157, 109, 203, 191, 224, 90, 48, 152, 90, 170, 211, 63, 232, 120, 107, 171, 136, 184, 228, 191, 57, 127, 41, 233, 60, 211, 217, 63, 8, 12, 174, 88, 61, 106, 201, 63, 108, 49, 198, 202, 160, 201, 152, 63, 46, 15, 106, 62, 22, 147, 215, 191, 141, 59, 123, 154, 242, 231, 200, 63, 245, 252, 207, 253, 182, 5, 216, 191, 214, 86, 162, 75, 1, 236, 167, 63, 140, 108, 130, 251, 220, 1, 208, 191, 199, 121, 96, 93, 10, 34, 147, 63, 60, 69, 155, 212, 234, 59, 188, 63, 151, 44, 167, 51, 21, 87, 221, 191, 229, 242, 205, 189, 241, 216, 177, 191, 50, 120, 97, 76, 218, 71, 225, 191, 155, 68, 27, 164, 23, 131, 221, 191, 148, 243, 186, 18, 102, 154, 138, 63, 2, 213, 242, 242, 99, 51, 222, 63, 108, 7, 233, 232, 230, 193, 178, 191, 1, 254, 158, 61, 226, 44, 203, 63, 69, 15, 37, 31, 232, 4, 201, 63, 54, 138, 137, 147, 208, 249, 214, 191, 183, 139, 11, 70, 229, 164, 213, 63, 149, 17, 48, 126, 198, 233, 223, 63, 16, 36, 49, 180, 241, 130, 157, 63, 111, 7, 252, 167, 95, 105, 113, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 166, 214, 11, 66, 186, 3, 119, 191, 195, 53, 168, 199, 18, 154, 215, 63, 163, 139, 126, 37, 74, 75, 214, 63, 12, 48, 223, 9, 162, 198, 217, 191, 162, 227, 136, 37, 216, 110, 212, 191, 174, 102, 179, 165, 0, 236, 174, 63, 197, 59, 102, 164, 121, 211, 155, 191, 232, 20, 43, 85, 162, 103, 165, 191, 172, 158, 156, 109, 175, 170, 212, 63, 162, 41, 191, 151, 22, 110, 181, 63, 148, 111, 38, 234, 201, 98, 201, 191, 255, 59, 51, 198, 80, 81, 219, 63, 153, 0, 173, 112, 226, 100, 204, 191, 226, 5, 204, 56, 142, 12, 203, 63, 161, 117, 43, 0, 8, 68, 183, 191, 115, 49, 61, 64, 134, 129, 211, 63, 183, 147, 133, 19, 97, 173, 207, 63, 35, 197, 32, 246, 172, 231, 215, 191, 19, 177, 78, 194, 195, 213, 78, 63, 238, 228, 111, 142, 88, 73, 208, 191, 130, 226, 14, 108, 42, 244, 213, 191, 187, 132, 141, 75, 210, 154, 182, 191, 93, 105, 141, 115, 14, 41, 215, 191, 134, 9, 166, 113, 49, 182, 182, 191, 133, 28, 210, 104, 207, 83, 214, 191, 108, 129, 15, 99, 247, 41, 218, 63, 66, 6, 247, 101, 30, 68, 193, 63, 155, 191, 44, 91, 163, 175, 198, 63, 139, 129, 88, 117, 163, 131, 182, 191, 140, 150, 107, 224, 48, 171, 188, 191, 242, 4, 248, 31, 159, 177, 189, 63, 173, 24, 98, 77, 117, 150, 213, 191, 146, 203, 174, 220, 176, 42, 201, 63, 166, 69, 148, 142, 176, 36, 211, 191, 120, 23, 42, 98, 102, 41, 220, 191, 129, 234, 69, 208, 28, 223, 225, 63, 129, 253, 42, 123, 49, 62, 188, 191, 53, 112, 236, 217, 34, 227, 107, 191, 167, 156, 171, 150, 63, 44, 209, 63, 214, 48, 23, 144, 138, 111, 219, 63, 167, 206, 231, 37, 64, 113, 198, 63, 205, 185, 170, 224, 150, 102, 208, 63, 228, 77, 92, 83, 209, 233, 216, 63, 108, 14, 165, 73, 62, 31, 225, 191, 66, 11, 60, 176, 227, 226, 222, 191, 238, 9, 5, 103, 66, 221, 163, 63, 242, 44, 125, 144, 190, 116, 59, 63, 30, 177, 49, 210, 116, 240, 237, 63, 58, 119, 96, 112, 240, 105, 209, 191, 162, 40, 114, 13, 69, 164, 212, 191, 37, 212, 182, 142, 108, 10, 190, 63, 36, 108, 108, 138, 198, 1, 193, 191, 53, 123, 95, 120, 104, 214, 160, 191, 197, 101, 92, 86, 49, 52, 206, 63, 141, 133, 112, 103, 96, 124, 212, 191, 177, 38, 248, 175, 30, 35, 209, 63, 59, 174, 176, 170, 49, 69, 212, 191, 49, 57, 31, 235, 183, 74, 195, 191, 228, 47, 85, 181, 124, 60, 214, 63, 140, 198, 173, 72, 93, 171, 200, 63, 10, 37, 96, 68, 32, 91, 181, 63, 94, 67, 253, 78, 0, 111, 134, 191, 52, 21, 142, 61, 237, 172, 214, 63, 57, 196, 46, 255, 140, 156, 211, 63, 66, 173, 83, 168, 139, 111, 207, 191, 226, 108, 128, 172, 73, 128, 186, 191, 170, 134, 82, 85, 104, 155, 123, 191, 137, 58, 11, 51, 72, 32, 217, 63, 35, 225, 142, 22, 46, 150, 187, 63, 240, 50, 95, 93, 49, 183, 202, 191, 187, 94, 252, 21, 239, 189, 214, 63, 77, 136, 60, 48, 90, 151, 202, 191, 49, 104, 151, 83, 158, 53, 212, 63, 208, 89, 107, 20, 234, 105, 209, 191, 180, 102, 40, 165, 100, 200, 193, 191, 248, 255, 45, 112, 232, 135, 211, 63, 55, 90, 50, 17, 133, 88, 208, 191, 195, 215, 17, 151, 234, 65, 212, 191, 78, 197, 63, 5, 62, 242, 132, 191, 196, 205, 184, 229, 5, 193, 196, 191, 231, 18, 83, 149, 179, 197, 203, 63, 117, 69, 209, 66, 208, 105, 185, 191, 53, 79, 172, 19, 179, 244, 212, 63, 190, 138, 250, 92, 96, 130, 199, 63, 69, 62, 197, 157, 49, 254, 161, 191, 38, 239, 165, 40, 65, 84, 211, 191, 192, 79, 244, 23, 93, 96, 210, 63, 204, 242, 92, 96, 32, 189, 213, 63, 103, 192, 199, 2, 239, 251, 202, 191, 98, 144, 28, 191, 231, 186, 199, 63, 183, 120, 217, 73, 147, 65, 179, 63, 74, 128, 224, 29, 233, 102, 210, 191, 83, 53, 130, 4, 42, 166, 218, 191, 98, 254, 168, 153, 16, 183, 201, 191, 19, 91, 4, 235, 87, 237, 224, 191, 130, 85, 107, 254, 158, 81, 212, 191, 0, 0, 0, 0, 0, 0, 0, 128, 29, 183, 239, 189, 196, 84, 216, 191, 240, 124, 140, 92, 89, 114, 168, 63, 72, 200, 205, 81, 236, 100, 202, 191, 70, 12, 234, 190, 112, 179, 208, 63, 88, 164, 14, 249, 240, 223, 201, 191, 241, 74, 92, 69, 248, 151, 161, 63, 238, 222, 187, 139, 183, 114, 165, 63, 181, 137, 165, 145, 122, 85, 208, 191, 2, 218, 28, 230, 220, 194, 182, 191, 3, 241, 203, 230, 192, 120, 223, 63, 223, 130, 74, 19, 168, 60, 206, 63, 33, 236, 140, 157, 70, 178, 212, 191, 246, 146, 6, 240, 103, 250, 199, 63, 43, 223, 246, 169, 93, 65, 217, 63, 209, 249, 173, 150, 84, 202, 184, 191, 205, 42, 120, 91, 242, 90, 190, 191, 198, 92, 195, 89, 131, 64, 144, 63, 225, 88, 105, 240, 237, 111, 216, 191, 136, 66, 87, 24, 216, 197, 212, 63, 51, 145, 184, 231, 16, 254, 133, 191, 186, 97, 38, 10, 242, 189, 218, 191, 220, 169, 236, 4, 209, 243, 187, 63, 101, 10, 129, 20, 134, 30, 203, 63, 51, 183, 75, 29, 6, 91, 216, 63, 123, 100, 54, 111, 158, 233, 171, 63, 92, 14, 44, 34, 188, 86, 195, 191, 181, 84, 176, 179, 68, 174, 154, 63, 35, 174, 169, 3, 186, 58, 179, 63, 142, 93, 234, 31, 104, 225, 214, 63, 238, 11, 213, 149, 143, 216, 167, 63, 146, 224, 159, 111, 208, 224, 222, 63, 214, 100, 255, 108, 47, 20, 226, 191, 133, 239, 224, 138, 33, 132, 133, 63, 116, 148, 93, 135, 32, 147, 216, 63, 5, 59, 78, 221, 63, 250, 190, 191, 82, 35, 104, 140, 123, 225, 191, 191, 69, 103, 218, 247, 209, 18, 221, 63, 253, 133, 122, 186, 167, 75, 192, 63, 177, 212, 98, 103, 140, 25, 203, 63, 184, 107, 86, 142, 145, 35, 189, 191, 128, 148, 143, 24, 70, 61, 184, 191, 36, 12, 164, 139, 80, 4, 213, 191, 68, 76, 71, 184, 6, 58, 217, 191, 78, 62, 158, 199, 222, 97, 189, 191, 16, 59, 30, 14, 81, 86, 225, 63, 88, 71, 122, 3, 231, 28, 205, 191, 33, 208, 72, 127, 40, 11, 231, 191, 110, 235, 125, 162, 215, 14, 184, 191, 0, 0, 0, 0, 0, 0, 0, 0, 77, 232, 49, 221, 79, 108, 209, 63, 52, 43, 210, 162, 78, 192, 221, 63, 225, 250, 96, 97, 55, 143, 181, 63, 12, 146, 197, 44, 97, 101, 180, 191, 105, 100, 167, 36, 179, 127, 155, 191, 38, 32, 95, 222, 142, 11, 217, 63, 89, 94, 53, 102, 78, 174, 196, 191, 142, 125, 167, 249, 118, 108, 215, 191, 224, 96, 177, 184, 130, 138, 210, 63, 16, 44, 237, 128, 28, 12, 208, 63, 5, 94, 247, 49, 14, 158, 212, 191, 209, 42, 217, 231, 190, 120, 196, 191, 104, 175, 202, 136, 85, 103, 195, 63, 250, 121, 77, 66, 168, 220, 127, 63, 217, 2, 212, 206, 97, 250, 209, 63, 133, 159, 145, 149, 167, 248, 188, 191, 38, 12, 25, 181, 130, 37, 218, 191, 214, 214, 223, 220, 115, 246, 185, 63, 2, 9, 12, 74, 13, 153, 143, 63, 116, 147, 112, 71, 109, 245, 225, 191, 115, 220, 45, 193, 183, 235, 134, 191, 142, 91, 105, 188, 0, 92, 211, 191, 164, 158, 135, 54, 180, 126, 211, 191, 219, 131, 181, 137, 92, 176, 160, 63, 65, 43, 160, 33, 44, 40, 202, 63, 186, 154, 147, 181, 219, 214, 199, 191, 75, 141, 98, 178, 111, 53, 200, 191, 0, 91, 171, 69, 38, 53, 205, 63, 156, 127, 14, 165, 36, 242, 194, 63, 127, 217, 36, 251, 230, 81, 208, 191, 55, 9, 197, 199, 156, 96, 184, 191, 248, 253, 58, 254, 145, 171, 226, 63, 89, 184, 230, 1, 146, 45, 211, 63, 209, 150, 48, 94, 94, 87, 180, 63, 40, 51, 111, 0, 4, 84, 222, 63, 64, 101, 239, 176, 92, 1, 189, 63, 163, 255, 183, 112, 74, 193, 188, 63, 197, 132, 66, 48, 48, 246, 176, 63, 173, 103, 246, 240, 97, 216, 217, 191, 245, 236, 181, 1, 15, 49, 221, 63, 63, 2, 73, 51, 245, 49, 196, 191, 226, 27, 95, 235, 203, 49, 194, 191, 153, 156, 20, 215, 153, 55, 182, 191, 86, 23, 131, 77, 167, 201, 225, 191, 160, 110, 129, 17, 243, 75, 113, 191, 232, 117, 186, 168, 65, 86, 218, 191, 50, 72, 60, 189, 86, 17, 209, 191, 11, 18, 199, 139, 69, 131, 222, 63, 0, 0, 0, 0, 0, 0, 0, 128, 116, 93, 117, 160, 115, 97, 227, 63, 155, 79, 83, 229, 179, 100, 177, 63, 187, 64, 169, 234, 25, 194, 221, 191, 39, 233, 132, 235, 216, 173, 212, 63, 204, 218, 41, 212, 176, 183, 222, 191, 149, 24, 166, 81, 13, 15, 176, 63, 193, 75, 184, 63, 206, 67, 198, 63, 76, 187, 62, 11, 70, 56, 212, 63, 1, 210, 198, 18, 55, 163, 169, 63, 3, 176, 104, 186, 41, 174, 171, 191, 246, 177, 212, 66, 199, 65, 212, 191, 165, 193, 116, 100, 60, 207, 149, 191, 164, 175, 103, 203, 83, 22, 216, 63, 247, 10, 184, 129, 76, 63, 145, 191, 225, 255, 91, 33, 79, 149, 226, 191, 215, 94, 176, 155, 67, 205, 183, 191, 113, 199, 41, 77, 184, 192, 156, 63, 111, 146, 6, 90, 188, 181, 173, 191, 10, 148, 7, 124, 138, 147, 217, 63, 224, 236, 149, 79, 149, 82, 225, 63, 143, 165, 211, 146, 160, 132, 163, 191, 120, 29, 236, 50, 40, 235, 200, 63, 165, 223, 65, 47, 57, 33, 205, 191, 33, 91, 255, 141, 11, 70, 205, 191, 36, 143, 178, 71, 150, 60, 202, 63, 151, 159, 104, 191, 141, 61, 226, 191, 238, 109, 100, 192, 22, 30, 182, 63, 138, 2, 171, 72, 214, 185, 207, 63, 241, 225, 67, 13, 201, 32, 189, 191, 152, 143, 56, 58, 217, 170, 201, 63, 3, 67, 144, 88, 77, 193, 215, 191, 69, 109, 117, 85, 41, 236, 208, 191, 213, 170, 209, 186, 144, 0, 163, 63, 5, 216, 87, 26, 23, 51, 178, 191, 207, 14, 17, 12, 221, 25, 218, 63, 53, 185, 230, 114, 92, 75, 219, 191, 240, 188, 253, 4, 243, 15, 201, 191, 193, 250, 67, 252, 7, 46, 150, 63, 57, 96, 201, 173, 210, 232, 210, 191, 181, 156, 91, 254, 175, 105, 219, 63, 255, 55, 206, 8, 17, 229, 214, 191, 193, 24, 219, 49, 195, 169, 165, 63, 111, 152, 123, 129, 60, 105, 176, 191, 164, 140, 97, 51, 138, 225, 211, 63, 233, 31, 40, 207, 206, 221, 174, 191, 122, 238, 202, 125, 17, 123, 213, 63, 93, 67, 23, 131, 9, 180, 173, 191, 250, 226, 243, 172, 217, 31, 159, 191, 0, 0, 0, 0, 0, 0, 0, 0, 46, 199, 114, 50, 65, 249, 219, 63, 58, 116, 69, 239, 139, 166, 221, 191, 183, 25, 104, 129, 157, 65, 176, 191, 15, 183, 16, 196, 51, 218, 223, 63, 230, 114, 173, 63, 162, 205, 134, 63, 56, 205, 29, 185, 51, 42, 225, 63, 197, 45, 224, 235, 120, 117, 214, 63, 150, 141, 215, 154, 169, 61, 212, 63, 107, 201, 99, 61, 103, 141, 181, 63, 241, 202, 151, 59, 95, 120, 176, 191, 1, 184, 38, 185, 219, 177, 179, 191, 163, 168, 197, 138, 136, 99, 214, 191, 65, 69, 182, 47, 205, 233, 168, 191, 125, 153, 206, 5, 76, 104, 120, 63, 2, 195, 157, 45, 117, 112, 171, 63, 67, 241, 88, 99, 25, 102, 215, 191, 73, 212, 129, 148, 104, 103, 226, 191, 220, 126, 185, 244, 54, 11, 217, 63, 79, 37, 60, 122, 201, 68, 225, 191, 17, 69, 111, 23, 5, 166, 208, 191, 246, 239, 179, 27, 44, 119, 211, 63, 100, 165, 155, 22, 40, 48, 201, 191, 42, 131, 220, 212, 252, 214, 105, 63, 228, 15, 74, 201, 85, 131, 188, 191, 204, 150, 76, 172, 45, 0, 209, 191, 10, 220, 235, 39, 167, 155, 156, 191, 26, 122, 59, 90, 226, 187, 196, 191, 152, 188, 197, 202, 225, 235, 199, 191, 62, 19, 203, 166, 215, 163, 190, 191, 92, 251, 77, 122, 126, 73, 197, 63, 241, 190, 128, 57, 27, 243, 213, 63, 223, 81, 215, 84, 44, 46, 177, 63, 116, 123, 254, 190, 250, 37, 209, 63, 78, 63, 192, 250, 214, 53, 163, 63, 109, 1, 59, 177, 85, 15, 119, 191, 169, 101, 212, 159, 210, 71, 204, 191, 69, 115, 206, 4, 213, 107, 169, 63, 108, 182, 184, 2, 146, 42, 225, 63, 168, 157, 69, 183, 7, 93, 216, 63, 67, 10, 141, 85, 21, 243, 120, 63, 26, 165, 91, 5, 166, 162, 211, 63, 253, 234, 244, 116, 241, 36, 182, 191, 187, 19, 40, 231, 201, 251, 216, 191, 119, 191, 5, 164, 42, 183, 174, 63, 252, 192, 4, 115, 163, 252, 140, 63, 32, 56, 102, 39, 243, 73, 149, 191, 31, 148, 99, 94, 28, 114, 128, 191, 239, 189, 153, 233, 254, 37, 225, 191, 0, 0, 0, 0, 0, 0, 0, 128, 86, 148, 25, 21, 125, 42, 196, 63, 109, 121, 58, 76, 99, 126, 219, 191, 13, 170, 126, 196, 95, 46, 215, 191, 1, 83, 68, 244, 11, 218, 153, 63, 159, 146, 252, 185, 67, 144, 222, 191, 40, 78, 122, 167, 128, 222, 202, 191, 61, 59, 50, 226, 25, 242, 174, 63, 189, 144, 253, 229, 60, 182, 224, 191, 50, 139, 236, 37, 126, 13, 213, 63, 47, 169, 163, 90, 41, 11, 144, 191, 45, 240, 14, 157, 195, 241, 143, 63, 254, 56, 15, 179, 37, 142, 214, 191, 92, 145, 107, 171, 53, 248, 209, 191, 148, 98, 213, 37, 78, 142, 225, 191, 192, 175, 1, 50, 237, 127, 184, 63, 10, 80, 67, 108, 189, 68, 226, 63, 141, 193, 203, 57, 27, 140, 187, 191, 225, 187, 228, 6, 209, 93, 212, 191, 124, 43, 222, 67, 32, 198, 189, 63, 75, 24, 145, 155, 174, 55, 177, 63, 56, 126, 175, 190, 148, 22, 203, 191, 3, 10, 72, 175, 17, 14, 217, 191, 31, 125, 134, 249, 13, 214, 166, 63, 206, 213, 246, 122, 46, 132, 144, 191, 62, 224, 203, 79, 151, 36, 203, 63, 95, 74, 198, 20, 133, 244, 193, 63, 171, 173, 58, 92, 22, 218, 201, 63, 13, 15, 100, 9, 28, 227, 212, 63, 102, 169, 25, 206, 20, 59, 188, 63, 29, 147, 44, 209, 41, 80, 215, 63, 5, 213, 189, 100, 205, 71, 189, 191, 7, 150, 2, 99, 211, 80, 130, 191, 174, 44, 119, 69, 67, 226, 184, 63, 9, 1, 134, 129, 179, 192, 221, 191, 86, 6, 254, 20, 29, 131, 161, 191, 94, 165, 177, 12, 62, 201, 200, 63, 95, 162, 142, 195, 182, 11, 97, 191, 29, 37, 151, 63, 226, 149, 219, 63, 8, 240, 21, 116, 63, 235, 226, 63, 141, 243, 39, 30, 78, 59, 162, 191, 201, 164, 113, 83, 133, 255, 196, 63, 127, 155, 150, 150, 141, 102, 223, 63, 72, 91, 193, 208, 138, 128, 211, 191, 124, 190, 155, 86, 235, 204, 157, 191, 23, 94, 202, 175, 57, 60, 80, 191, 5, 40, 4, 166, 189, 99, 144, 191, 173, 243, 79, 253, 139, 119, 69, 191, 9, 230, 7, 56, 188, 0, 224, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 79, 58, 124, 76, 38, 213, 191, 57, 137, 232, 100, 219, 109, 172, 191, 25, 52, 183, 68, 195, 151, 202, 191, 246, 205, 132, 180, 226, 254, 205, 63, 236, 24, 136, 146, 51, 232, 205, 191, 144, 57, 8, 93, 239, 252, 208, 191, 240, 212, 14, 64, 176, 149, 215, 63, 212, 176, 129, 54, 141, 126, 209, 63, 0, 221, 128, 238, 251, 31, 102, 191, 77, 140, 212, 174, 180, 246, 179, 63, 208, 92, 166, 29, 239, 227, 172, 191, 201, 63, 221, 195, 231, 152, 198, 63, 145, 105, 25, 77, 198, 19, 168, 191, 166, 247, 174, 17, 133, 235, 166, 191, 186, 161, 209, 75, 125, 82, 218, 191, 15, 188, 150, 106, 68, 73, 191, 63, 78, 192, 233, 31, 162, 70, 183, 63, 104, 55, 49, 61, 76, 51, 204, 63, 62, 96, 81, 221, 132, 158, 153, 191, 96, 155, 17, 250, 29, 232, 155, 191, 70, 19, 228, 90, 5, 160, 214, 191, 204, 208, 96, 184, 116, 188, 173, 191, 154, 143, 124, 194, 145, 124, 133, 63, 183, 96, 11, 152, 137, 203, 183, 63, 18, 216, 240, 76, 202, 18, 180, 63, 102, 78, 13, 210, 222, 240, 207, 63, 147, 128, 134, 3, 87, 216, 171, 63, 155, 112, 149, 246, 249, 205, 168, 63, 182, 101, 167, 27, 210, 138, 191, 191, 159, 255, 14, 177, 149, 10, 206, 191, 106, 243, 203, 214, 141, 56, 128, 191, 25, 5, 255, 83, 160, 189, 190, 191, 182, 35, 20, 155, 50, 196, 201, 63, 236, 225, 62, 153, 184, 36, 144, 63, 139, 32, 98, 180, 41, 151, 196, 63, 46, 209, 77, 225, 246, 31, 102, 191, 194, 183, 176, 87, 56, 232, 218, 63, 196, 42, 149, 208, 82, 213, 173, 191, 78, 49, 216, 85, 75, 240, 143, 191, 246, 167, 34, 112, 223, 126, 194, 191, 39, 51, 165, 162, 112, 167, 192, 191, 23, 167, 39, 112, 200, 160, 182, 63, 195, 41, 55, 76, 96, 162, 144, 191, 13, 63, 95, 26, 209, 237, 58, 63, 76, 173, 186, 108, 85, 23, 116, 63, 247, 171, 104, 153, 243, 196, 13, 191, 82, 228, 159, 47, 51, 2, 139, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 172, 201, 219, 5, 245, 211, 191, 158, 170, 27, 52, 253, 251, 192, 191, 77, 122, 134, 106, 147, 235, 226, 191, 16, 208, 153, 184, 252, 40, 159, 191, 223, 8, 140, 170, 218, 216, 224, 63, 188, 170, 55, 118, 55, 77, 224, 63, 92, 108, 73, 86, 143, 53, 201, 191, 105, 243, 13, 49, 169, 227, 217, 63, 202, 121, 27, 128, 199, 126, 136, 63, 58, 64, 123, 220, 16, 22, 211, 63, 183, 119, 107, 154, 254, 160, 205, 63, 131, 102, 238, 96, 99, 149, 209, 63, 54, 133, 151, 211, 219, 156, 128, 63, 61, 125, 71, 3, 178, 107, 196, 191, 142, 119, 38, 26, 15, 183, 174, 63, 164, 156, 234, 172, 138, 240, 226, 63, 148, 42, 174, 239, 48, 166, 195, 63, 51, 137, 22, 142, 231, 59, 223, 191, 92, 78, 213, 196, 222, 30, 182, 63, 30, 28, 65, 97, 230, 150, 200, 191, 37, 37, 44, 168, 218, 180, 146, 191, 180, 198, 20, 111, 127, 29, 209, 191, 135, 230, 194, 167, 80, 1, 164, 63, 58, 214, 137, 57, 181, 106, 221, 63, 30, 141, 244, 96, 111, 212, 197, 191, 10, 109, 28, 166, 158, 31, 199, 191, 161, 242, 93, 98, 98, 156, 216, 191, 7, 5, 127, 31, 226, 127, 210, 191, 169, 254, 48, 139, 71, 72, 216, 191, 186, 14, 120, 162, 10, 54, 223, 63, 128, 162, 211, 72, 168, 44, 167, 63, 58, 216, 6, 108, 208, 73, 211, 191, 67, 36, 127, 174, 79, 44, 184, 191, 7, 143, 189, 5, 200, 40, 163, 191, 87, 177, 16, 60, 123, 113, 181, 191, 142, 234, 78, 150, 188, 9, 153, 63, 83, 174, 144, 26, 183, 197, 207, 63, 82, 160, 249, 18, 6, 134, 161, 191, 178, 137, 45, 167, 140, 31, 169, 63, 170, 73, 96, 108, 24, 18, 201, 191, 178, 29, 45, 214, 204, 242, 196, 63, 47, 161, 16, 154, 69, 206, 194, 191, 70, 130, 123, 1, 226, 5, 137, 63, 197, 71, 186, 121, 72, 79, 106, 191, 210, 175, 147, 37, 232, 191, 162, 63, 251, 141, 103, 173, 110, 167, 68, 191, 19, 199, 168, 57, 60, 107, 138, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 244, 138, 208, 194, 88, 94, 100, 191, 240, 109, 200, 0, 21, 19, 219, 191, 38, 44, 243, 22, 39, 13, 207, 191, 204, 207, 204, 83, 125, 205, 222, 63, 87, 116, 202, 24, 21, 58, 192, 63, 13, 189, 135, 152, 109, 75, 180, 63, 246, 174, 55, 218, 162, 51, 192, 191, 214, 175, 4, 16, 253, 99, 194, 191, 112, 54, 87, 87, 90, 54, 194, 63, 167, 157, 203, 240, 191, 226, 225, 63, 198, 225, 107, 86, 177, 106, 211, 63, 235, 228, 66, 251, 62, 182, 223, 191, 110, 163, 191, 232, 194, 169, 220, 63, 218, 36, 241, 50, 195, 224, 225, 63, 171, 45, 231, 214, 155, 131, 185, 191, 143, 171, 4, 142, 149, 72, 174, 191, 53, 62, 23, 49, 172, 220, 214, 191, 144, 232, 90, 22, 8, 214, 195, 63, 20, 194, 234, 6, 96, 228, 196, 191, 96, 128, 225, 197, 90, 126, 223, 63, 83, 70, 105, 51, 121, 55, 213, 63, 47, 218, 172, 145, 136, 10, 226, 191, 177, 204, 37, 9, 162, 111, 151, 191, 190, 54, 35, 249, 23, 108, 191, 191, 110, 127, 133, 49, 64, 120, 227, 191, 133, 32, 228, 159, 109, 189, 189, 63, 92, 174, 238, 118, 97, 87, 199, 63, 208, 153, 61, 131, 108, 234, 226, 63, 36, 248, 23, 201, 97, 142, 193, 191, 248, 235, 134, 166, 159, 124, 220, 191, 141, 113, 69, 161, 28, 167, 194, 191, 39, 143, 150, 108, 17, 188, 168, 191, 203, 101, 20, 33, 196, 82, 221, 191, 107, 8, 242, 24, 183, 226, 212, 191, 203, 220, 22, 28, 4, 160, 225, 191, 49, 58, 7, 149, 43, 254, 167, 191, 215, 129, 182, 66, 84, 70, 163, 191, 230, 193, 2, 38, 189, 61, 145, 63, 151, 94, 72, 157, 242, 209, 213, 63, 168, 81, 60, 33, 149, 52, 222, 63, 110, 211, 18, 118, 65, 20, 217, 63, 11, 153, 148, 138, 44, 239, 215, 191, 241, 195, 136, 155, 89, 188, 208, 63, 56, 230, 154, 122, 36, 178, 74, 191, 173, 173, 59, 92, 38, 27, 204, 191, 211, 181, 132, 63, 15, 205, 112, 191, 192, 97, 123, 248, 174, 130, 79, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 111, 148, 168, 18, 44, 197, 63, 205, 70, 208, 226, 229, 40, 127, 63, 158, 120, 251, 93, 71, 95, 171, 191, 149, 54, 58, 192, 29, 127, 130, 63, 213, 184, 251, 74, 46, 146, 211, 63, 140, 21, 48, 100, 209, 149, 190, 63, 101, 159, 16, 143, 206, 156, 192, 63, 72, 254, 112, 16, 30, 226, 221, 191, 42, 185, 167, 75, 224, 100, 222, 63, 45, 105, 132, 5, 47, 27, 223, 63, 51, 224, 200, 12, 106, 231, 207, 191, 87, 117, 149, 1, 199, 125, 152, 191, 153, 130, 16, 214, 237, 168, 145, 191, 247, 44, 87, 228, 145, 163, 196, 191, 92, 99, 204, 52, 206, 197, 219, 63, 40, 136, 203, 203, 232, 105, 213, 63, 107, 220, 87, 134, 229, 184, 186, 191, 226, 89, 44, 139, 107, 141, 162, 63, 77, 247, 51, 71, 210, 111, 197, 63, 24, 231, 214, 93, 136, 8, 204, 191, 254, 202, 16, 108, 92, 81, 197, 191, 152, 110, 92, 14, 35, 61, 225, 191, 194, 101, 192, 135, 255, 94, 217, 191, 140, 227, 247, 64, 221, 59, 164, 63, 66, 79, 248, 154, 188, 234, 195, 191, 121, 137, 243, 216, 171, 105, 203, 191, 57, 149, 64, 241, 69, 70, 150, 63, 141, 70, 56, 78, 199, 107, 219, 191, 98, 248, 12, 112, 228, 4, 171, 63, 104, 134, 84, 120, 218, 71, 167, 63, 75, 53, 242, 19, 103, 231, 209, 63, 9, 153, 123, 124, 188, 147, 213, 191, 243, 116, 97, 232, 199, 193, 195, 63, 194, 75, 7, 86, 235, 180, 207, 191, 93, 91, 224, 63, 213, 191, 204, 63, 37, 40, 228, 162, 6, 28, 197, 191, 121, 204, 147, 164, 104, 156, 215, 63, 3, 197, 26, 21, 188, 220, 149, 63, 174, 72, 61, 44, 61, 123, 204, 63, 54, 90, 206, 112, 84, 230, 210, 63, 188, 10, 126, 33, 243, 122, 210, 191, 186, 251, 247, 31, 172, 195, 174, 63, 12, 164, 43, 239, 251, 68, 216, 191, 43, 10, 29, 178, 185, 49, 188, 63, 198, 19, 39, 116, 0, 94, 192, 63, 96, 98, 89, 9, 30, 83, 145, 191, 71, 52, 154, 38, 30, 176, 121, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 224, 150, 248, 138, 0, 202, 162, 63, 201, 94, 108, 82, 57, 233, 214, 191, 16, 71, 25, 37, 44, 71, 222, 191, 186, 140, 176, 10, 145, 122, 215, 63, 179, 224, 159, 80, 23, 33, 183, 63, 216, 190, 203, 244, 131, 11, 146, 191, 134, 245, 19, 143, 255, 38, 166, 63, 33, 12, 73, 239, 76, 171, 128, 63, 191, 165, 207, 215, 54, 228, 228, 63, 236, 201, 79, 177, 255, 7, 156, 63, 146, 17, 189, 48, 217, 147, 218, 191, 192, 216, 213, 140, 140, 99, 215, 191, 8, 175, 14, 74, 83, 42, 217, 191, 161, 243, 104, 177, 27, 91, 170, 191, 54, 164, 224, 236, 57, 221, 177, 63, 77, 199, 43, 237, 141, 230, 165, 191, 149, 74, 251, 38, 212, 6, 221, 63, 241, 11, 70, 207, 85, 186, 221, 63, 215, 50, 63, 220, 234, 31, 173, 191, 250, 39, 102, 90, 102, 82, 214, 191, 20, 38, 234, 148, 161, 196, 208, 63, 150, 51, 19, 114, 65, 31, 170, 191, 185, 70, 112, 9, 240, 82, 230, 191, 39, 57, 95, 227, 6, 19, 144, 191, 188, 177, 200, 243, 61, 126, 188, 191, 61, 56, 88, 230, 34, 53, 170, 63, 86, 212, 120, 55, 165, 13, 177, 63, 119, 80, 70, 22, 72, 232, 194, 191, 93, 57, 93, 48, 220, 119, 132, 191, 136, 2, 192, 50, 6, 88, 202, 63, 172, 117, 102, 69, 155, 230, 209, 191, 68, 89, 197, 127, 29, 175, 147, 191, 111, 72, 52, 20, 21, 110, 214, 63, 200, 217, 180, 226, 158, 220, 218, 63, 217, 152, 226, 215, 252, 73, 196, 191, 78, 227, 113, 201, 158, 138, 229, 63, 236, 149, 191, 163, 228, 24, 210, 63, 85, 252, 57, 103, 131, 162, 115, 191, 158, 175, 73, 196, 211, 217, 218, 191, 164, 132, 195, 20, 133, 75, 188, 63, 111, 27, 146, 31, 60, 213, 210, 191, 218, 139, 74, 35, 181, 255, 220, 63, 40, 17, 193, 244, 69, 152, 214, 191, 69, 82, 185, 237, 161, 81, 222, 191, 57, 8, 201, 6, 206, 75, 225, 63, 81, 75, 32, 81, 144, 45, 165, 191, 143, 88, 89, 80, 9, 103, 94, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 189, 170, 119, 49, 63, 95, 169, 191, 50, 80, 236, 150, 18, 149, 197, 63, 127, 169, 24, 165, 158, 138, 147, 191, 215, 251, 91, 184, 29, 249, 168, 63, 195, 80, 166, 226, 3, 104, 199, 63, 209, 186, 218, 142, 94, 17, 216, 191, 38, 16, 177, 179, 243, 155, 166, 191, 9, 123, 108, 244, 228, 1, 201, 63, 199, 48, 52, 159, 31, 53, 202, 63, 25, 111, 247, 154, 15, 242, 197, 191, 244, 134, 5, 96, 222, 160, 168, 63, 204, 60, 131, 228, 182, 32, 186, 63, 18, 214, 160, 164, 234, 64, 130, 63, 10, 15, 81, 40, 47, 127, 221, 191, 147, 40, 12, 116, 233, 191, 209, 191, 154, 90, 118, 140, 0, 72, 202, 63, 74, 134, 155, 0, 88, 89, 165, 191, 88, 170, 84, 130, 12, 144, 200, 191, 187, 176, 2, 220, 48, 125, 160, 191, 240, 173, 34, 44, 214, 201, 201, 63, 118, 48, 2, 30, 116, 129, 190, 191, 211, 98, 23, 237, 208, 232, 200, 63, 148, 210, 220, 244, 54, 215, 199, 191, 173, 9, 236, 98, 30, 10, 217, 191, 220, 242, 71, 46, 86, 160, 222, 191, 162, 91, 249, 196, 220, 26, 205, 191, 169, 187, 223, 138, 155, 114, 217, 63, 248, 244, 123, 69, 23, 66, 205, 63, 94, 38, 34, 222, 62, 248, 217, 63, 255, 87, 180, 190, 196, 4, 174, 191, 157, 167, 38, 79, 211, 52, 178, 63, 172, 104, 144, 142, 113, 64, 214, 191, 153, 185, 155, 181, 238, 29, 179, 191, 59, 245, 159, 34, 97, 75, 142, 191, 210, 83, 251, 82, 49, 165, 220, 63, 62, 219, 189, 183, 134, 244, 222, 191, 41, 69, 34, 81, 68, 58, 205, 191, 160, 103, 180, 251, 32, 237, 124, 191, 25, 51, 214, 55, 200, 249, 169, 63, 123, 137, 121, 149, 194, 113, 222, 63, 148, 226, 5, 163, 18, 31, 194, 63, 77, 112, 45, 57, 117, 125, 177, 63, 88, 76, 239, 147, 204, 59, 183, 63, 3, 122, 193, 10, 205, 236, 226, 63, 58, 200, 200, 20, 230, 104, 208, 191, 67, 41, 96, 10, 57, 231, 166, 191, 131, 105, 109, 33, 121, 60, 93, 63, 177, 179, 197, 60, 18, 70, 240, 63, 224, 238, 67, 95, 233, 99, 118, 63, 34, 232, 148, 179, 84, 188, 193, 63, 64, 141, 9, 248, 106, 95, 210, 191, 64, 170, 31, 63, 109, 151, 213, 63, 173, 73, 233, 81, 18, 49, 212, 191, 12, 118, 142, 10, 192, 234, 211, 63, 84, 237, 175, 164, 108, 60, 164, 63, 100, 110, 39, 97, 195, 9, 192, 191, 177, 200, 181, 145, 7, 176, 146, 63, 115, 69, 148, 148, 193, 206, 213, 191, 45, 145, 114, 93, 131, 14, 194, 191, 125, 190, 0, 50, 158, 53, 213, 63, 166, 106, 225, 230, 169, 7, 213, 63, 76, 228, 240, 246, 82, 83, 212, 191, 101, 38, 232, 99, 127, 64, 196, 191, 176, 81, 44, 147, 11, 104, 155, 191, 74, 147, 206, 199, 180, 118, 211, 63, 40, 82, 199, 217, 58, 87, 213, 63, 168, 187, 245, 11, 42, 110, 210, 63, 13, 191, 197, 231, 146, 133, 212, 191, 111, 72, 94, 96, 245, 222, 202, 63, 181, 132, 117, 179, 155, 218, 212, 63, 130, 181, 54, 159, 187, 152, 196, 191, 174, 56, 251, 190, 99, 77, 216, 191, 118, 85, 171, 25, 246, 235, 138, 63, 190, 229, 228, 235, 125, 102, 118, 63, 55, 147, 150, 156, 181, 139, 209, 191, 229, 83, 58, 91, 251, 251, 159, 191, 49, 173, 169, 20, 44, 62, 160, 63, 108, 75, 116, 168, 231, 143, 145, 63, 212, 129, 189, 247, 24, 75, 210, 63, 116, 5, 197, 87, 222, 88, 214, 191, 16, 7, 31, 205, 188, 245, 201, 191, 77, 252, 28, 185, 241, 241, 210, 191, 214, 180, 246, 121, 9, 253, 218, 191, 134, 185, 152, 104, 143, 129, 192, 63, 88, 152, 78, 4, 108, 35, 198, 191, 25, 13, 106, 52, 197, 221, 204, 63, 164, 23, 225, 151, 121, 89, 181, 191, 170, 177, 4, 226, 140, 225, 218, 191, 192, 200, 220, 112, 48, 70, 184, 63, 136, 38, 34, 180, 232, 84, 206, 191, 48, 118, 255, 149, 114, 223, 212, 63, 237, 140, 28, 147, 55, 170, 218, 191, 56, 89, 62, 34, 164, 200, 209, 63, 4, 62, 183, 64, 252, 7, 216, 191, 219, 151, 240, 22, 32, 106, 219, 63, 5, 238, 189, 82, 4, 44, 198, 63, 0, 0, 0, 0, 0, 0, 0, 128, 134, 245, 230, 248, 0, 176, 224, 191, 71, 19, 207, 88, 108, 243, 218, 63, 21, 215, 249, 70, 193, 34, 184, 191, 25, 238, 102, 3, 30, 71, 141, 191, 95, 250, 155, 221, 162, 17, 153, 63, 29, 83, 89, 111, 94, 39, 148, 191, 92, 251, 205, 254, 169, 177, 208, 191, 230, 190, 216, 194, 13, 139, 218, 191, 186, 82, 179, 106, 144, 151, 218, 63, 177, 43, 126, 135, 99, 244, 211, 63, 71, 84, 12, 105, 221, 246, 222, 191, 56, 192, 193, 169, 45, 20, 180, 63, 48, 226, 152, 151, 10, 239, 166, 63, 8, 17, 47, 171, 92, 60, 144, 191, 211, 169, 13, 35, 162, 8, 203, 63, 195, 46, 52, 36, 135, 40, 215, 191, 97, 206, 248, 237, 165, 229, 133, 63, 12, 211, 126, 121, 52, 120, 176, 63, 174, 35, 73, 254, 39, 88, 197, 63, 225, 50, 65, 28, 91, 133, 215, 63, 68, 3, 83, 46, 3, 44, 213, 63, 4, 212, 40, 236, 166, 107, 163, 63, 41, 10, 227, 14, 89, 226, 221, 191, 117, 245, 55, 100, 43, 18, 201, 63, 252, 108, 54, 70, 2, 198, 206, 63, 32, 102, 174, 99, 227, 134, 202, 191, 232, 247, 143, 56, 9, 174, 141, 191, 123, 240, 4, 195, 96, 87, 204, 63, 93, 224, 44, 255, 70, 130, 221, 63, 250, 253, 74, 49, 126, 129, 203, 191, 75, 90, 86, 54, 131, 42, 208, 63, 252, 155, 239, 57, 105, 43, 214, 191, 98, 23, 92, 124, 141, 45, 134, 63, 201, 97, 132, 150, 205, 170, 194, 191, 195, 210, 89, 53, 215, 130, 120, 191, 213, 105, 96, 209, 207, 54, 192, 63, 72, 210, 63, 70, 213, 45, 217, 191, 227, 53, 62, 137, 24, 221, 208, 63, 163, 95, 69, 195, 7, 28, 220, 63, 162, 145, 181, 154, 175, 9, 150, 191, 242, 55, 102, 105, 194, 229, 186, 191, 174, 170, 102, 155, 102, 248, 208, 191, 9, 169, 202, 51, 247, 230, 186, 191, 19, 122, 88, 9, 183, 102, 155, 191, 10, 219, 159, 106, 172, 41, 227, 191, 209, 78, 124, 0, 101, 239, 190, 191, 212, 23, 51, 152, 162, 145, 234, 63, 255, 43, 38, 35, 43, 158, 217, 191, 0, 0, 0, 0, 0, 0, 0, 0, 80, 146, 201, 107, 95, 136, 195, 191, 98, 1, 25, 224, 142, 174, 195, 191, 9, 35, 63, 28, 217, 41, 204, 191, 177, 24, 113, 212, 126, 188, 193, 63, 34, 79, 8, 105, 50, 127, 209, 191, 59, 111, 218, 214, 1, 141, 218, 63, 173, 116, 149, 114, 146, 255, 122, 63, 12, 91, 54, 17, 70, 182, 201, 63, 167, 237, 229, 23, 233, 156, 123, 63, 242, 251, 78, 96, 79, 24, 210, 63, 56, 218, 8, 87, 202, 74, 161, 63, 143, 168, 57, 155, 54, 9, 203, 191, 37, 201, 137, 242, 140, 131, 213, 63, 48, 27, 9, 205, 220, 158, 206, 63, 8, 16, 65, 121, 236, 183, 166, 191, 49, 53, 187, 147, 67, 59, 147, 63, 180, 133, 151, 183, 215, 54, 218, 63, 80, 108, 181, 154, 191, 248, 201, 191, 241, 129, 151, 146, 72, 193, 176, 63, 101, 40, 29, 13, 242, 156, 212, 63, 22, 252, 212, 5, 172, 14, 199, 191, 129, 94, 158, 22, 168, 171, 215, 63, 101, 145, 166, 61, 70, 229, 169, 63, 89, 29, 194, 90, 232, 250, 161, 63, 231, 202, 96, 128, 228, 71, 128, 191, 223, 210, 154, 79, 1, 186, 186, 63, 67, 151, 156, 149, 116, 152, 217, 191, 57, 65, 28, 5, 205, 32, 165, 191, 41, 237, 50, 124, 241, 195, 188, 191, 213, 218, 163, 170, 142, 207, 123, 191, 247, 40, 0, 248, 111, 216, 218, 191, 17, 228, 66, 51, 244, 224, 228, 63, 216, 7, 228, 39, 250, 186, 211, 191, 37, 254, 15, 71, 229, 40, 208, 63, 130, 112, 63, 45, 48, 196, 219, 191, 9, 62, 129, 219, 149, 124, 208, 63, 121, 205, 65, 249, 41, 236, 193, 191, 157, 185, 125, 252, 98, 205, 164, 191, 5, 69, 184, 30, 81, 19, 195, 63, 138, 203, 156, 68, 38, 244, 217, 191, 24, 101, 9, 122, 184, 118, 206, 63, 58, 28, 55, 247, 219, 55, 201, 63, 238, 233, 170, 148, 77, 192, 201, 191, 152, 25, 3, 64, 35, 126, 225, 191, 18, 77, 70, 227, 160, 58, 120, 63, 188, 86, 15, 243, 64, 140, 220, 191, 32, 193, 121, 60, 8, 127, 216, 63, 128, 121, 213, 27, 165, 163, 202, 191, 0, 0, 0, 0, 0, 0, 0, 128, 59, 0, 24, 239, 219, 119, 221, 63, 24, 184, 58, 126, 171, 223, 220, 191, 146, 158, 87, 150, 69, 150, 199, 191, 157, 65, 183, 129, 70, 74, 194, 63, 201, 95, 30, 119, 84, 29, 170, 63, 169, 252, 93, 44, 12, 22, 186, 191, 96, 78, 69, 237, 48, 34, 222, 191, 49, 124, 95, 165, 11, 55, 217, 63, 77, 209, 66, 82, 179, 205, 190, 191, 89, 54, 148, 191, 119, 42, 181, 191, 195, 229, 250, 200, 141, 8, 211, 63, 87, 238, 72, 54, 218, 92, 148, 63, 24, 32, 190, 188, 166, 222, 177, 191, 213, 43, 147, 166, 140, 121, 67, 63, 211, 140, 236, 219, 245, 211, 225, 63, 78, 15, 208, 252, 84, 230, 198, 191, 11, 134, 102, 119, 22, 245, 170, 63, 91, 1, 253, 96, 168, 162, 144, 191, 25, 83, 221, 225, 1, 154, 172, 63, 126, 188, 41, 225, 160, 247, 227, 191, 223, 149, 126, 235, 58, 148, 143, 63, 189, 71, 27, 67, 95, 66, 204, 63, 169, 167, 206, 93, 55, 9, 204, 63, 134, 113, 36, 33, 30, 206, 213, 191, 65, 32, 88, 39, 125, 175, 222, 63, 72, 170, 196, 208, 255, 187, 219, 191, 185, 135, 82, 139, 18, 50, 165, 191, 210, 179, 206, 191, 198, 230, 221, 63, 147, 153, 136, 13, 30, 26, 181, 191, 129, 85, 177, 247, 214, 168, 222, 191, 215, 86, 123, 16, 196, 138, 172, 191, 151, 136, 233, 11, 36, 193, 217, 191, 14, 218, 194, 189, 198, 43, 160, 63, 224, 16, 116, 116, 25, 16, 152, 63, 35, 122, 194, 13, 68, 222, 225, 191, 115, 188, 236, 0, 183, 69, 207, 63, 198, 211, 59, 5, 71, 98, 212, 63, 114, 246, 128, 239, 95, 91, 206, 63, 206, 34, 99, 142, 153, 78, 220, 191, 157, 26, 44, 126, 182, 130, 226, 191, 213, 154, 237, 213, 37, 221, 204, 191, 191, 132, 101, 247, 219, 137, 157, 63, 88, 114, 120, 95, 26, 175, 131, 63, 128, 113, 248, 159, 24, 51, 220, 63, 16, 118, 12, 71, 78, 40, 187, 63, 7, 82, 208, 59, 53, 14, 224, 63, 211, 231, 65, 184, 203, 150, 186, 63, 134, 15, 97, 109, 146, 2, 222, 63, 0, 0, 0, 0, 0, 0, 0, 0, 145, 245, 22, 206, 117, 130, 227, 63, 44, 204, 214, 152, 0, 31, 116, 63, 53, 46, 30, 142, 221, 104, 203, 63, 225, 181, 103, 151, 5, 59, 216, 191, 24, 165, 148, 199, 253, 96, 194, 63, 148, 42, 16, 24, 110, 190, 209, 63, 37, 227, 80, 14, 83, 85, 183, 63, 156, 231, 213, 110, 200, 238, 209, 191, 235, 90, 36, 251, 200, 226, 155, 63, 199, 84, 85, 245, 85, 21, 193, 191, 202, 27, 115, 137, 245, 71, 190, 63, 157, 113, 71, 175, 150, 76, 204, 191, 55, 142, 168, 10, 88, 57, 165, 191, 238, 107, 35, 250, 202, 172, 205, 63, 235, 148, 134, 70, 187, 81, 181, 191, 170, 133, 70, 152, 191, 251, 197, 63, 191, 33, 72, 68, 46, 237, 209, 63, 80, 217, 205, 122, 240, 111, 212, 191, 86, 206, 235, 35, 116, 63, 225, 191, 184, 147, 143, 149, 128, 166, 220, 63, 160, 15, 105, 105, 51, 91, 214, 191, 147, 218, 175, 40, 84, 215, 189, 63, 215, 2, 44, 141, 31, 28, 116, 191, 131, 35, 54, 228, 57, 6, 205, 191, 15, 103, 213, 255, 51, 17, 183, 63, 198, 228, 86, 78, 182, 243, 163, 191, 86, 43, 123, 30, 211, 145, 220, 191, 77, 145, 101, 101, 81, 56, 183, 63, 67, 206, 159, 191, 101, 244, 196, 191, 223, 107, 197, 243, 119, 212, 171, 63, 224, 150, 61, 149, 100, 10, 214, 63, 227, 51, 204, 61, 249, 193, 193, 63, 254, 146, 235, 9, 76, 178, 216, 191, 252, 118, 175, 56, 65, 147, 195, 63, 122, 129, 13, 155, 180, 35, 134, 63, 35, 7, 45, 14, 135, 204, 209, 63, 222, 22, 11, 2, 6, 151, 187, 191, 135, 41, 166, 108, 16, 108, 192, 191, 119, 19, 60, 7, 144, 187, 208, 191, 136, 173, 162, 30, 226, 187, 135, 191, 201, 71, 37, 19, 191, 129, 217, 63, 13, 236, 70, 224, 199, 170, 196, 63, 178, 6, 103, 173, 172, 163, 213, 191, 171, 160, 11, 89, 172, 53, 190, 63, 47, 152, 98, 81, 69, 179, 160, 191, 41, 103, 101, 91, 66, 185, 165, 191, 104, 103, 210, 241, 220, 52, 147, 63, 43, 179, 135, 187, 158, 155, 171, 63, 0, 0, 0, 0, 0, 0, 0, 128, 80, 35, 146, 147, 199, 249, 215, 63, 53, 213, 46, 222, 3, 22, 222, 63, 104, 240, 45, 112, 69, 220, 182, 191, 237, 62, 146, 154, 161, 42, 166, 191, 110, 243, 172, 115, 193, 141, 160, 63, 3, 78, 40, 158, 186, 4, 212, 191, 45, 1, 253, 1, 253, 167, 172, 191, 117, 37, 246, 250, 143, 126, 213, 191, 172, 115, 105, 133, 96, 192, 210, 191, 231, 198, 67, 50, 221, 109, 169, 191, 93, 66, 82, 162, 62, 70, 164, 191, 99, 225, 62, 151, 51, 249, 225, 191, 134, 162, 93, 225, 26, 53, 224, 191, 47, 199, 201, 131, 239, 76, 137, 63, 239, 6, 134, 29, 251, 83, 207, 191, 249, 108, 4, 36, 179, 204, 221, 63, 17, 203, 248, 50, 14, 42, 196, 63, 142, 43, 156, 26, 147, 2, 226, 63, 54, 42, 102, 66, 208, 15, 205, 63, 38, 72, 36, 229, 246, 172, 199, 191, 173, 134, 25, 123, 141, 144, 220, 63, 112, 232, 97, 62, 9, 131, 227, 63, 83, 236, 64, 88, 7, 60, 189, 191, 219, 15, 116, 68, 103, 203, 169, 191, 98, 129, 251, 116, 37, 242, 199, 63, 7, 227, 204, 222, 225, 88, 213, 63, 207, 14, 185, 190, 161, 120, 174, 191, 182, 57, 28, 195, 223, 224, 208, 63, 182, 171, 145, 195, 205, 145, 208, 63, 149, 142, 208, 189, 230, 184, 212, 191, 150, 113, 131, 38, 42, 169, 204, 191, 182, 17, 232, 113, 81, 243, 156, 191, 122, 94, 36, 29, 251, 55, 168, 63, 162, 45, 32, 208, 66, 169, 184, 63, 200, 198, 59, 240, 50, 35, 186, 63, 252, 90, 89, 111, 228, 155, 219, 191, 215, 200, 169, 114, 154, 2, 124, 63, 17, 104, 207, 82, 223, 97, 225, 191, 198, 14, 170, 29, 136, 48, 219, 63, 108, 206, 154, 209, 52, 5, 187, 63, 216, 109, 118, 30, 24, 218, 215, 63, 101, 79, 142, 237, 185, 103, 201, 63, 237, 224, 147, 13, 44, 186, 225, 191, 245, 177, 169, 157, 233, 167, 182, 191, 213, 192, 205, 25, 117, 1, 108, 63, 82, 66, 124, 20, 81, 165, 169, 191, 44, 120, 133, 143, 137, 184, 98, 63, 240, 119, 115, 119, 51, 132, 226, 191, 0, 0, 0, 0, 0, 0, 0, 0, 12, 194, 90, 255, 79, 142, 191, 63, 30, 72, 103, 69, 67, 247, 216, 63, 214, 98, 29, 206, 186, 123, 229, 63, 130, 89, 0, 205, 100, 144, 206, 63, 172, 82, 166, 149, 204, 130, 228, 63, 4, 84, 186, 221, 58, 242, 211, 191, 173, 190, 164, 192, 168, 81, 223, 63, 120, 254, 65, 115, 188, 233, 223, 63, 106, 64, 27, 53, 116, 176, 223, 191, 243, 195, 210, 182, 234, 206, 126, 191, 87, 208, 240, 152, 58, 105, 164, 191, 246, 148, 96, 146, 9, 125, 214, 191, 236, 142, 218, 154, 174, 26, 205, 63, 155, 33, 154, 167, 182, 206, 229, 191, 92, 5, 122, 17, 214, 35, 178, 63, 190, 110, 43, 242, 92, 127, 218, 191, 202, 66, 226, 96, 167, 60, 216, 191, 38, 51, 2, 52, 232, 61, 210, 191, 237, 180, 141, 20, 238, 46, 185, 63, 168, 199, 183, 184, 218, 36, 166, 63, 3, 47, 106, 5, 138, 166, 200, 191, 160, 239, 110, 118, 103, 217, 185, 63, 167, 121, 50, 76, 248, 133, 174, 191, 209, 172, 97, 77, 160, 34, 90, 191, 19, 4, 3, 230, 168, 235, 225, 63, 131, 42, 177, 255, 48, 89, 184, 63, 137, 222, 224, 60, 25, 226, 227, 191, 113, 196, 3, 204, 50, 166, 226, 63, 33, 16, 77, 136, 14, 10, 191, 191, 13, 133, 218, 245, 203, 173, 225, 63, 19, 146, 43, 203, 111, 167, 168, 63, 8, 151, 12, 234, 56, 29, 104, 63, 51, 31, 79, 195, 44, 84, 228, 191, 78, 151, 236, 54, 80, 170, 228, 191, 67, 234, 244, 32, 148, 58, 141, 63, 110, 184, 86, 90, 204, 190, 139, 63, 76, 171, 15, 17, 198, 69, 95, 63, 214, 27, 181, 13, 226, 142, 200, 191, 220, 180, 96, 217, 216, 68, 227, 63, 216, 67, 34, 127, 165, 175, 145, 63, 143, 108, 156, 81, 55, 50, 164, 191, 120, 193, 151, 168, 117, 161, 228, 191, 27, 115, 14, 132, 250, 58, 209, 191, 0, 7, 132, 103, 72, 12, 100, 63, 47, 246, 218, 129, 143, 37, 240, 190, 162, 196, 190, 139, 175, 109, 130, 63, 91, 252, 16, 201, 243, 60, 38, 63, 113, 192, 91, 187, 23, 140, 223, 63}};


unsigned char TabulatedValues::ucDecorrCoef[72]    = {15, 199, 4, 70, 168, 227, 213, 191, 186, 224, 24, 181, 165, 164, 218, 63, 248, 194, 100, 170, 96, 84, 194, 191, 78, 58, 140, 29, 181, 3, 225, 63, 249, 97, 41, 55, 246, 17, 238, 63, 245, 75, 125, 98, 6, 101, 195, 63, 41, 2, 73, 52, 37, 32, 225, 63, 29, 51, 144, 69, 167, 121, 226, 191, 132, 202, 46, 176, 109, 25, 238, 63};
unsigned char TabulatedValues::ucInvDecorrCoef[56] = {43, 57, 249, 32, 181, 57, 240, 63, 233, 231, 66, 42, 196, 80, 205, 63, 6, 129, 149, 67, 139, 108, 239, 63, 193, 200, 17, 36, 186, 150, 196, 63, 210, 49, 116, 130, 223, 107, 224, 63, 145, 212, 69, 5, 91, 50, 239, 63, 171, 170, 170, 170, 170, 42, 236, 191};

//unsigned int TabulatedValues::uiCicpSpeakerdAzimuths[34] = {30, 330, 0, 110, 250, 22, 338, 135, 225, 180, 90, 270, 60, 300, 30, 330, 0, 135, 225, 180, 90, 270, 0, 45, 315, 0, 110, 250, 45, 315, 45, 315, 150, 210};
//unsigned int TabulatedValues::uiCicpSpeakerInclinations[34] = {90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 55, 55, 55, 55, 55, 55, 55, 55, 0, 105, 105, 105, 55, 55, 55, 55, 90, 90, 90, 90};

unsigned int TabulatedValues::uiCicpSpeakerdAzimuths[51] = {30, 330, 0, 110, 250, 22, 338, 135, 225, 180, 90, 270, 60, 300, 30, 330, 0, 135, 225, 180, 90, 270, 0, 45, 315, 0, 110, 250, 45, 315, 45, 315, 150, 210, 22, 338, 60, 300, 22, 338, 30, 330, 60, 300, 90, 270, 110, 250, 135, 225, 180};
unsigned int TabulatedValues::uiCicpSpeakerInclinations[51] = {90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 55, 55, 55, 55, 55, 55, 55, 55, 0, 105, 105, 105, 55, 55, 55, 55, 90, 90, 90, 90, 55, 55, 55, 55, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105};

unsigned char TabulatedValues::ucAzimuths[9][800] = {
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 222, 98, 61, 82, 193, 0, 64, 202, 148, 23, 55, 82, 193, 0, 192},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 70, 78, 22, 143, 78, 255, 191, 53, 251, 128, 73, 145, 78, 255, 63, 1, 157, 137, 206, 142, 78, 255, 191, 156, 82, 137, 219, 250, 33, 9, 192, 70, 220, 203, 255, 144, 78, 255, 63, 40, 169, 86, 8, 235, 252, 229, 63, 226, 208, 239, 235, 228, 252, 229, 191},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 91, 197, 211, 35, 235, 241, 63, 152, 148, 115, 141, 102, 46, 208, 191, 230, 66, 3, 62, 72, 125, 242, 63, 47, 55, 234, 132, 231, 82, 0, 64, 191, 58, 68, 0, 81, 25, 246, 191, 112, 58, 144, 212, 5, 83, 209, 63, 198, 138, 248, 82, 37, 162, 1, 192, 77, 50, 169, 190, 205, 96, 2, 64, 142, 126, 40, 62, 103, 108, 6, 192, 128, 242, 154, 253, 111, 22, 8, 64, 24, 76, 47, 0, 70, 61, 1, 64, 184, 29, 81, 61, 72, 84, 228, 191, 75, 252, 237, 73, 55, 183, 246, 191, 101, 116, 113, 81, 167, 190, 3, 192},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 151, 250, 77, 138, 15, 0, 192, 249, 28, 55, 220, 153, 215, 254, 63, 206, 224, 8, 75, 229, 151, 246, 191, 74, 37, 169, 9, 208, 204, 0, 192, 78, 233, 51, 187, 121, 26, 4, 64, 60, 218, 3, 25, 160, 174, 250, 63, 5, 158, 126, 67, 0, 20, 247, 63, 134, 106, 149, 249, 72, 56, 227, 191, 243, 245, 86, 75, 48, 30, 213, 63, 195, 154, 39, 23, 188, 250, 242, 191, 107, 85, 46, 55, 221, 221, 7, 64, 12, 36, 190, 128, 168, 137, 5, 192, 114, 214, 124, 148, 69, 62, 224, 63, 116, 78, 94, 70, 252, 171, 1, 64, 232, 66, 68, 25, 102, 121, 238, 63, 190, 22, 219, 156, 72, 115, 251, 191, 69, 196, 193, 141, 158, 230, 237, 63, 185, 43, 232, 222, 253, 188, 216, 191, 244, 160, 4, 232, 92, 104, 5, 64, 214, 112, 231, 123, 255, 6, 5, 192, 60, 177, 231, 6, 31, 31, 197, 63, 238, 188, 60, 25, 148, 102, 240, 191, 90, 47, 225, 2, 183, 12, 9, 192},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 23, 220, 234, 132, 37, 243, 191, 151, 19, 186, 127, 121, 143, 199, 63, 136, 5, 36, 91, 234, 208, 191, 63, 128, 54, 39, 200, 199, 184, 6, 192, 127, 225, 93, 255, 91, 141, 253, 191, 216, 236, 193, 185, 57, 92, 230, 63, 119, 44, 158, 199, 237, 61, 2, 64, 42, 242, 10, 84, 80, 71, 2, 192, 130, 87, 198, 213, 104, 1, 3, 192, 108, 76, 93, 200, 57, 17, 7, 64, 142, 148, 230, 216, 231, 245, 242, 191, 235, 215, 129, 29, 208, 37, 6, 192, 145, 79, 230, 142, 125, 110, 232, 63, 158, 75, 25, 192, 37, 193, 221, 191, 214, 35, 182, 33, 73, 51, 2, 192, 251, 111, 26, 101, 183, 49, 252, 63, 152, 216, 252, 37, 150, 111, 6, 64, 165, 54, 13, 45, 109, 17, 251, 191, 235, 99, 59, 132, 120, 131, 240, 191, 68, 17, 207, 112, 33, 77, 224, 63, 63, 218, 137, 152, 102, 81, 255, 191, 133, 108, 27, 168, 227, 36, 226, 191, 156, 196, 212, 60, 148, 142, 2, 64, 22, 10, 51, 5, 108, 211, 6, 64, 19, 122, 238, 30, 111, 145, 8, 192, 65, 74, 214, 142, 177, 231, 0, 64, 0, 113, 236, 137, 236, 35, 248, 191, 87, 190, 185, 199, 223, 237, 228, 191, 94, 120, 20, 226, 120, 109, 247, 63, 218, 132, 27, 35, 84, 248, 245, 63, 16, 154, 24, 75, 212, 205, 241, 63, 86, 246, 175, 82, 94, 233, 0, 64, 123, 77, 42, 171, 22, 65, 173, 63, 204, 27, 229, 146, 169, 83, 247, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 230, 71, 244, 20, 50, 8, 64, 55, 251, 144, 149, 39, 165, 0, 64, 224, 239, 79, 233, 185, 181, 1, 192, 191, 198, 204, 67, 174, 73, 0, 192, 67, 181, 194, 221, 36, 217, 250, 63, 16, 15, 101, 184, 16, 220, 238, 63, 16, 0, 169, 2, 190, 72, 8, 192, 162, 184, 91, 226, 211, 157, 5, 192, 217, 35, 169, 62, 0, 152, 226, 63, 54, 83, 24, 48, 131, 104, 6, 192, 209, 147, 173, 122, 183, 154, 225, 63, 90, 95, 176, 8, 242, 191, 255, 191, 47, 122, 108, 89, 65, 99, 224, 191, 217, 36, 12, 174, 246, 65, 242, 191, 50, 184, 72, 158, 179, 230, 3, 192, 252, 57, 206, 114, 21, 247, 249, 191, 255, 248, 56, 61, 235, 102, 226, 191, 171, 74, 232, 33, 37, 74, 2, 64, 154, 164, 142, 103, 66, 96, 182, 191, 178, 43, 94, 220, 65, 129, 225, 63, 0, 26, 67, 253, 61, 16, 254, 63, 122, 186, 14, 134, 70, 249, 5, 64, 43, 33, 101, 10, 248, 83, 232, 191, 127, 250, 67, 210, 9, 81, 240, 191, 202, 211, 235, 143, 253, 151, 242, 63, 92, 127, 129, 24, 71, 29, 248, 63, 86, 253, 242, 184, 215, 0, 241, 63, 141, 168, 108, 93, 103, 115, 5, 192, 236, 9, 102, 146, 30, 87, 241, 191, 48, 255, 31, 126, 227, 78, 7, 64, 87, 46, 184, 39, 70, 131, 7, 64, 205, 75, 28, 141, 114, 162, 248, 191, 90, 42, 137, 24, 135, 73, 222, 63, 92, 243, 86, 135, 145, 72, 255, 191, 84, 145, 19, 83, 75, 184, 244, 63, 240, 156, 245, 253, 248, 105, 236, 63, 139, 45, 223, 100, 158, 107, 3, 64, 130, 63, 115, 0, 168, 118, 144, 191, 176, 107, 170, 61, 69, 141, 255, 63, 218, 90, 193, 198, 147, 167, 245, 191, 40, 231, 112, 159, 159, 53, 5, 64, 153, 53, 127, 145, 113, 114, 226, 191, 205, 97, 136, 208, 99, 184, 253, 63, 211, 73, 187, 231, 214, 238, 232, 191, 19, 144, 119, 182, 247, 22, 0, 192, 50, 134, 174, 145, 191, 179, 8, 64, 194, 137, 4, 147, 129, 66, 114, 191},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 132, 31, 229, 229, 101, 6, 64, 156, 176, 136, 13, 132, 68, 3, 192, 225, 8, 50, 84, 58, 210, 5, 192, 49, 14, 31, 234, 178, 6, 206, 63, 47, 216, 113, 250, 158, 15, 248, 63, 56, 220, 205, 201, 184, 136, 4, 64, 152, 60, 43, 19, 76, 191, 242, 63, 48, 223, 83, 51, 75, 248, 2, 64, 202, 233, 215, 177, 37, 211, 6, 192, 64, 32, 242, 49, 78, 175, 206, 191, 74, 209, 200, 45, 138, 150, 239, 63, 156, 147, 164, 68, 57, 55, 8, 64, 72, 189, 27, 69, 180, 212, 218, 191, 251, 231, 51, 16, 214, 88, 251, 191, 133, 178, 199, 195, 89, 138, 213, 191, 37, 50, 218, 76, 68, 123, 250, 191, 32, 141, 124, 254, 190, 24, 247, 191, 144, 47, 68, 82, 15, 159, 229, 63, 100, 127, 30, 246, 195, 210, 225, 191, 100, 166, 199, 128, 207, 116, 241, 63, 227, 208, 103, 130, 101, 177, 6, 64, 45, 90, 115, 66, 174, 25, 238, 63, 228, 72, 203, 231, 198, 132, 7, 192, 84, 252, 194, 194, 7, 46, 193, 63, 18, 247, 108, 250, 33, 215, 252, 63, 193, 127, 47, 151, 8, 4, 242, 191, 209, 107, 106, 157, 129, 40, 253, 191, 24, 109, 183, 128, 63, 201, 1, 64, 200, 249, 225, 180, 191, 146, 241, 191, 213, 8, 129, 170, 122, 248, 250, 63, 195, 145, 126, 69, 235, 106, 254, 191, 20, 195, 205, 175, 57, 194, 3, 64, 189, 61, 234, 107, 157, 15, 236, 191, 174, 180, 144, 11, 56, 5, 196, 63, 158, 49, 134, 245, 251, 159, 4, 64, 225, 196, 185, 50, 118, 231, 5, 192, 163, 105, 145, 195, 165, 102, 237, 191, 140, 84, 129, 93, 206, 76, 227, 63, 77, 83, 127, 253, 131, 83, 229, 191, 39, 158, 246, 234, 239, 182, 249, 63, 214, 55, 9, 152, 24, 246, 202, 191, 121, 13, 45, 224, 73, 170, 254, 63, 120, 198, 166, 169, 100, 14, 7, 64, 174, 167, 1, 236, 103, 157, 230, 63, 84, 32, 65, 181, 30, 119, 0, 64, 21, 69, 158, 123, 126, 200, 6, 192, 239, 74, 136, 71, 82, 27, 225, 191, 174, 215, 220, 213, 94, 198, 242, 191, 58, 121, 153, 136, 158, 201, 245, 191, 214, 77, 148, 165, 119, 152, 241, 63, 26, 24, 171, 192, 170, 41, 2, 192, 30, 132, 168, 31, 51, 3, 4, 192, 153, 246, 203, 222, 80, 51, 247, 63, 90, 142, 225, 214, 156, 88, 225, 63, 219, 209, 171, 250, 153, 176, 2, 64, 246, 126, 114, 144, 158, 23, 2, 192, 68, 76, 4, 231, 44, 190, 254, 191, 157, 191, 121, 13, 228, 31, 8, 192, 213, 24, 230, 62, 241, 238, 255, 191, 233, 201, 48, 28, 98, 1, 222, 63, 3, 72, 200, 21, 128, 188, 248, 63, 241, 237, 52, 57, 255, 87, 251, 191},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 90, 140, 252, 170, 138, 3, 192, 151, 135, 37, 92, 20, 164, 221, 191, 208, 138, 86, 32, 227, 214, 7, 64, 136, 96, 180, 104, 99, 189, 235, 191, 138, 27, 121, 1, 193, 177, 243, 191, 42, 0, 118, 77, 180, 149, 3, 192, 144, 215, 237, 226, 165, 49, 8, 64, 65, 91, 154, 140, 3, 9, 8, 192, 119, 74, 158, 255, 111, 228, 246, 63, 84, 241, 218, 67, 197, 186, 238, 191, 213, 225, 218, 229, 79, 25, 243, 63, 135, 233, 29, 230, 104, 46, 250, 191, 236, 162, 0, 250, 200, 82, 228, 63, 191, 119, 231, 101, 18, 44, 244, 191, 215, 209, 121, 156, 210, 164, 4, 64, 95, 33, 93, 48, 242, 232, 193, 63, 78, 84, 255, 122, 128, 51, 254, 63, 31, 70, 224, 242, 249, 63, 240, 63, 230, 180, 115, 166, 149, 205, 250, 191, 157, 114, 138, 24, 148, 117, 252, 63, 134, 182, 125, 104, 120, 76, 253, 191, 228, 226, 10, 95, 250, 85, 245, 63, 108, 67, 176, 190, 92, 137, 211, 63, 137, 231, 241, 180, 218, 15, 0, 192, 152, 162, 241, 136, 7, 21, 3, 192, 53, 19, 255, 99, 221, 239, 250, 63, 158, 32, 168, 19, 7, 66, 233, 63, 229, 118, 187, 196, 151, 18, 229, 63, 80, 92, 34, 171, 103, 182, 253, 191, 237, 144, 117, 134, 186, 66, 247, 191, 170, 136, 152, 181, 79, 76, 0, 192, 62, 59, 191, 108, 32, 24, 250, 63, 166, 11, 242, 241, 115, 49, 247, 191, 225, 233, 81, 168, 247, 194, 5, 192, 223, 163, 227, 179, 126, 210, 0, 64, 108, 88, 17, 47, 220, 187, 2, 64, 222, 52, 182, 234, 224, 6, 226, 191, 115, 3, 145, 54, 137, 95, 225, 191, 87, 232, 249, 192, 200, 196, 225, 63, 32, 138, 240, 202, 67, 95, 190, 191, 197, 1, 173, 116, 110, 207, 246, 191, 31, 151, 207, 201, 69, 247, 183, 63, 144, 204, 9, 40, 215, 187, 2, 64, 103, 2, 7, 89, 94, 111, 240, 191, 152, 107, 137, 174, 133, 91, 8, 64, 229, 4, 50, 193, 130, 3, 241, 63, 164, 109, 117, 217, 216, 181, 232, 63, 113, 110, 127, 113, 55, 102, 222, 63, 46, 205, 31, 64, 1, 154, 244, 63, 73, 243, 227, 19, 213, 37, 1, 64, 44, 210, 36, 137, 157, 80, 225, 63, 19, 182, 32, 59, 139, 228, 8, 192, 69, 208, 231, 26, 125, 11, 216, 191, 64, 87, 117, 245, 58, 171, 192, 191, 190, 122, 16, 181, 191, 22, 237, 191, 17, 239, 13, 226, 60, 255, 0, 64, 208, 80, 30, 59, 4, 10, 250, 63, 233, 42, 116, 210, 180, 166, 6, 64, 49, 147, 176, 70, 16, 86, 243, 63, 112, 175, 101, 160, 31, 204, 241, 191, 60, 25, 194, 33, 134, 253, 6, 64, 104, 76, 85, 27, 52, 20, 252, 63, 187, 254, 80, 196, 22, 112, 249, 191, 203, 6, 164, 229, 43, 23, 222, 191, 233, 22, 36, 136, 107, 7, 244, 63, 85, 248, 208, 64, 255, 70, 208, 191, 57, 91, 223, 214, 166, 0, 3, 192, 48, 12, 185, 189, 39, 161, 6, 192, 74, 245, 52, 26, 232, 146, 5, 64, 98, 243, 0, 208, 118, 135, 3, 192, 127, 40, 173, 120, 49, 73, 4, 64, 170, 8, 90, 49, 19, 23, 3, 192, 67, 209, 11, 41, 242, 19, 6, 64, 225, 4, 132, 126, 127, 143, 225, 191, 252, 27, 68, 42, 131, 120, 255, 191, 163, 2, 224, 149, 139, 54, 1, 64, 242, 172, 1, 43, 138, 131, 6, 192, 183, 150, 208, 204, 31, 243, 212, 63, 2, 65, 183, 51, 89, 51, 7, 192},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 29, 208, 106, 254, 221, 224, 63, 124, 33, 42, 240, 112, 103, 6, 64, 192, 22, 116, 98, 180, 43, 242, 63, 81, 209, 184, 149, 4, 138, 5, 64, 185, 111, 41, 161, 209, 53, 167, 191, 234, 247, 95, 153, 71, 57, 133, 191, 147, 117, 196, 117, 200, 42, 242, 191, 145, 8, 205, 236, 253, 176, 225, 191, 222, 0, 39, 166, 168, 248, 251, 63, 112, 218, 79, 168, 15, 168, 251, 191, 159, 9, 87, 105, 176, 187, 7, 192, 131, 143, 78, 223, 6, 36, 236, 63, 143, 230, 162, 0, 68, 254, 251, 63, 10, 253, 33, 147, 45, 147, 2, 64, 92, 43, 194, 45, 34, 64, 179, 191, 178, 88, 193, 42, 52, 138, 1, 192, 25, 35, 44, 93, 114, 236, 236, 191, 163, 124, 89, 78, 202, 156, 222, 63, 244, 15, 99, 162, 162, 237, 7, 64, 10, 160, 249, 2, 78, 253, 244, 191, 26, 159, 74, 3, 142, 189, 5, 192, 173, 175, 122, 245, 67, 217, 194, 191, 197, 90, 47, 134, 198, 141, 8, 64, 227, 238, 67, 99, 203, 146, 224, 191, 46, 150, 113, 3, 170, 241, 5, 192, 162, 0, 58, 23, 119, 84, 230, 191, 105, 155, 136, 122, 209, 209, 156, 63, 69, 228, 70, 55, 43, 63, 251, 191, 109, 101, 10, 249, 55, 52, 252, 191, 59, 102, 172, 100, 98, 86, 247, 63, 232, 67, 29, 2, 216, 145, 5, 192, 254, 206, 39, 157, 217, 193, 241, 191, 79, 141, 102, 172, 7, 223, 241, 191, 113, 19, 121, 53, 80, 213, 249, 63, 110, 221, 120, 119, 42, 112, 1, 64, 115, 13, 73, 183, 74, 83, 248, 191, 145, 140, 246, 231, 29, 248, 1, 192, 90, 148, 35, 17, 23, 32, 0, 64, 154, 196, 191, 141, 244, 54, 4, 192, 153, 146, 186, 67, 93, 86, 7, 192, 60, 48, 193, 207, 8, 62, 7, 64, 186, 252, 137, 143, 99, 222, 5, 192, 104, 189, 113, 221, 217, 79, 2, 64, 53, 49, 85, 40, 169, 28, 210, 63, 234, 47, 67, 133, 202, 65, 232, 191, 223, 175, 118, 77, 135, 93, 231, 191, 118, 43, 119, 13, 45, 164, 254, 63, 18, 14, 34, 170, 104, 134, 229, 63, 200, 0, 115, 57, 224, 65, 2, 64, 171, 52, 159, 41, 218, 133, 4, 64, 190, 88, 106, 95, 162, 96, 219, 63, 82, 22, 177, 56, 166, 93, 0, 192, 145, 60, 55, 207, 112, 171, 8, 192, 38, 84, 136, 103, 197, 46, 241, 191, 17, 50, 115, 52, 123, 136, 255, 63, 211, 166, 93, 66, 220, 47, 225, 191, 233, 9, 185, 190, 176, 29, 209, 191, 27, 24, 190, 170, 109, 134, 250, 191, 76, 172, 13, 213, 24, 58, 0, 64, 22, 227, 166, 24, 209, 109, 2, 192, 188, 180, 96, 220, 243, 12, 4, 64, 243, 4, 34, 39, 153, 129, 250, 63, 4, 253, 69, 33, 150, 155, 240, 63, 44, 49, 150, 229, 122, 252, 243, 63, 218, 93, 249, 104, 80, 176, 244, 63, 207, 217, 101, 88, 219, 120, 227, 63, 47, 130, 147, 64, 157, 241, 8, 192, 178, 212, 129, 221, 219, 209, 245, 63, 189, 245, 187, 45, 189, 197, 218, 191, 196, 164, 43, 129, 246, 46, 241, 191, 163, 138, 204, 26, 100, 206, 4, 64, 49, 119, 105, 85, 30, 215, 247, 63, 85, 132, 53, 58, 62, 99, 2, 64, 47, 93, 122, 237, 29, 95, 6, 192, 226, 235, 163, 90, 226, 88, 254, 191, 29, 151, 191, 58, 205, 200, 221, 63, 160, 0, 88, 40, 182, 143, 239, 63, 8, 147, 6, 170, 71, 142, 236, 63, 187, 70, 178, 169, 49, 156, 247, 191, 205, 159, 136, 72, 143, 33, 4, 192, 94, 240, 219, 134, 206, 27, 220, 191, 98, 147, 1, 48, 193, 249, 244, 191, 106, 93, 23, 143, 210, 114, 250, 191, 227, 254, 10, 118, 227, 134, 2, 192, 180, 253, 67, 102, 45, 5, 1, 192, 91, 250, 249, 212, 234, 48, 8, 192, 4, 242, 143, 105, 56, 68, 236, 191, 161, 224, 131, 136, 43, 189, 226, 63, 226, 233, 14, 88, 186, 195, 0, 192, 162, 141, 72, 250, 187, 205, 6, 64, 85, 186, 14, 10, 189, 135, 193, 63, 114, 1, 131, 240, 198, 177, 249, 63, 146, 100, 182, 205, 114, 205, 235, 63, 188, 230, 168, 124, 132, 30, 9, 64, 141, 7, 72, 35, 124, 251, 203, 63, 49, 94, 215, 219, 25, 88, 243, 63, 148, 78, 60, 126, 214, 232, 4, 64, 108, 47, 98, 237, 198, 173, 254, 191}
};

unsigned char TabulatedValues::ucInclinations[9][800] = {
    {0, 0, 0, 0, 0, 0, 0, 0, 205, 173, 121, 36, 244, 145, 254, 63, 65, 85, 14, 35, 244, 145, 254, 63, 204, 48, 46, 55, 244, 145, 254, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 67, 71, 251, 103, 122, 227, 2, 64, 166, 43, 12, 198, 72, 82, 243, 63, 117, 129, 13, 213, 72, 82, 243, 63, 252, 180, 137, 173, 72, 82, 3, 64, 162, 164, 25, 130, 3, 250, 248, 63, 151, 124, 137, 8, 73, 82, 3, 64, 150, 235, 194, 102, 239, 53, 245, 63, 70, 45, 189, 30, 238, 53, 245, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 252, 129, 120, 185, 197, 84, 235, 63, 107, 130, 32, 185, 120, 65, 0, 64, 109, 194, 62, 244, 65, 215, 4, 64, 252, 226, 237, 199, 8, 66, 241, 63, 231, 69, 166, 238, 37, 201, 251, 63, 88, 132, 35, 74, 120, 65, 0, 64, 96, 70, 44, 63, 38, 201, 251, 63, 171, 213, 67, 68, 34, 26, 249, 63, 114, 96, 105, 35, 198, 88, 237, 63, 197, 4, 239, 35, 198, 88, 237, 63, 169, 156, 236, 60, 50, 55, 252, 63, 10, 190, 34, 214, 229, 50, 5, 64, 71, 4, 197, 125, 34, 26, 249, 63, 184, 26, 50, 82, 220, 134, 238, 63, 92, 236, 137, 32, 60, 170, 3, 64},
    {0, 0, 0, 0, 0, 0, 0, 0, 152, 44, 182, 189, 204, 87, 234, 63, 212, 199, 160, 1, 112, 211, 251, 63, 89, 91, 213, 92, 112, 45, 231, 63, 160, 169, 120, 203, 103, 97, 245, 63, 1, 188, 159, 250, 102, 228, 235, 63, 75, 1, 96, 110, 34, 56, 244, 63, 58, 117, 125, 125, 215, 10, 247, 63, 246, 81, 58, 98, 139, 252, 1, 64, 155, 143, 90, 216, 120, 241, 246, 63, 76, 125, 99, 179, 193, 26, 7, 64, 0, 91, 68, 252, 3, 8, 0, 64, 240, 76, 76, 84, 178, 215, 252, 63, 90, 87, 83, 26, 73, 88, 246, 63, 114, 17, 235, 150, 194, 93, 1, 64, 66, 1, 206, 130, 176, 62, 255, 63, 36, 241, 194, 190, 117, 72, 249, 63, 210, 111, 0, 119, 71, 173, 4, 64, 200, 39, 16, 174, 179, 252, 235, 63, 170, 4, 4, 216, 43, 98, 1, 64, 187, 106, 233, 98, 216, 230, 4, 64, 162, 250, 242, 248, 30, 141, 1, 64, 232, 191, 197, 89, 145, 68, 248, 63, 237, 127, 144, 11, 204, 227, 230, 63, 153, 230, 12, 21, 214, 102, 232, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 206, 51, 214, 178, 252, 50, 0, 64, 135, 228, 25, 9, 242, 243, 243, 63, 176, 141, 43, 231, 43, 248, 5, 64, 190, 204, 208, 94, 83, 244, 227, 63, 187, 205, 64, 85, 94, 59, 252, 63, 113, 121, 183, 210, 212, 32, 241, 63, 150, 235, 217, 168, 229, 223, 1, 64, 236, 66, 123, 25, 24, 121, 1, 64, 213, 237, 107, 118, 77, 69, 1, 64, 252, 105, 43, 29, 11, 249, 227, 63, 84, 14, 82, 26, 189, 204, 243, 63, 216, 177, 48, 114, 60, 79, 227, 63, 129, 147, 251, 59, 160, 36, 242, 63, 214, 145, 238, 150, 113, 248, 240, 63, 179, 15, 117, 172, 89, 39, 250, 63, 157, 191, 199, 120, 72, 92, 248, 63, 185, 173, 63, 197, 203, 129, 251, 63, 4, 35, 114, 5, 127, 0, 228, 63, 163, 77, 50, 79, 41, 37, 251, 63, 84, 163, 206, 213, 60, 255, 252, 63, 250, 89, 55, 28, 103, 39, 250, 63, 93, 165, 253, 85, 80, 125, 6, 64, 180, 240, 234, 88, 62, 117, 240, 63, 112, 162, 49, 19, 52, 111, 248, 63, 250, 165, 225, 43, 26, 202, 253, 63, 111, 105, 50, 207, 144, 75, 3, 64, 87, 7, 106, 1, 10, 71, 6, 64, 242, 53, 254, 34, 41, 56, 2, 64, 202, 241, 14, 6, 108, 195, 2, 64, 227, 119, 136, 44, 214, 57, 2, 64, 250, 101, 144, 153, 252, 142, 226, 63, 70, 113, 122, 200, 105, 24, 251, 63, 83, 139, 114, 149, 28, 28, 239, 63, 252, 140, 77, 174, 199, 57, 244, 63, 147, 140, 245, 149, 148, 5, 243, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 217, 11, 36, 178, 137, 56, 235, 63, 252, 193, 202, 204, 10, 17, 254, 63, 87, 7, 12, 145, 175, 9, 248, 63, 106, 171, 151, 195, 34, 136, 0, 64, 1, 98, 128, 205, 229, 110, 249, 63, 36, 119, 226, 44, 232, 80, 242, 63, 38, 225, 21, 196, 225, 73, 253, 63, 204, 216, 95, 213, 124, 67, 246, 63, 3, 145, 235, 98, 106, 32, 253, 63, 44, 29, 114, 225, 127, 200, 223, 63, 248, 97, 55, 118, 212, 208, 2, 64, 162, 235, 131, 182, 161, 206, 241, 63, 121, 42, 216, 128, 224, 191, 240, 63, 109, 136, 14, 19, 144, 59, 249, 63, 40, 109, 89, 23, 218, 223, 2, 64, 212, 67, 214, 105, 89, 123, 245, 63, 132, 218, 163, 42, 143, 210, 255, 63, 174, 158, 16, 153, 249, 170, 0, 64, 22, 84, 246, 77, 254, 244, 239, 63, 74, 130, 176, 22, 201, 129, 3, 64, 192, 10, 151, 81, 148, 144, 1, 64, 94, 199, 16, 33, 206, 35, 0, 64, 254, 212, 80, 107, 58, 226, 2, 64, 31, 23, 246, 182, 174, 188, 224, 63, 237, 206, 50, 204, 123, 45, 245, 63, 230, 23, 246, 218, 139, 56, 235, 63, 195, 68, 199, 255, 27, 113, 250, 63, 1, 243, 40, 27, 31, 132, 245, 63, 144, 72, 182, 254, 27, 147, 235, 63, 252, 205, 232, 165, 70, 30, 253, 63, 128, 27, 190, 175, 23, 230, 239, 63, 87, 115, 8, 167, 185, 13, 224, 63, 32, 66, 43, 183, 117, 247, 246, 63, 65, 251, 85, 39, 132, 13, 250, 63, 173, 1, 126, 222, 139, 94, 4, 64, 172, 143, 204, 106, 8, 229, 1, 64, 68, 195, 66, 13, 227, 189, 5, 64, 89, 45, 183, 131, 138, 216, 254, 63, 237, 150, 41, 237, 38, 236, 245, 63, 122, 26, 120, 126, 123, 73, 4, 64, 198, 90, 183, 18, 192, 115, 236, 63, 217, 216, 143, 157, 115, 85, 247, 63, 97, 246, 124, 7, 89, 173, 240, 63, 176, 138, 56, 181, 62, 38, 226, 63, 136, 216, 169, 77, 47, 198, 6, 64, 214, 218, 6, 246, 84, 161, 224, 63, 254, 160, 194, 166, 69, 22, 7, 64, 221, 166, 38, 0, 30, 92, 254, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 226, 11, 163, 66, 115, 84, 236, 63, 48, 5, 79, 231, 155, 244, 245, 63, 246, 187, 8, 146, 172, 29, 1, 64, 93, 120, 2, 145, 99, 92, 251, 63, 126, 227, 46, 72, 195, 138, 252, 63, 143, 24, 213, 135, 3, 40, 220, 63, 230, 241, 179, 40, 239, 49, 254, 63, 142, 205, 195, 219, 100, 68, 1, 64, 116, 32, 217, 24, 81, 138, 247, 63, 150, 146, 148, 140, 206, 151, 237, 63, 79, 75, 178, 142, 30, 52, 5, 64, 107, 51, 249, 149, 45, 118, 244, 63, 133, 32, 252, 86, 166, 105, 252, 63, 13, 243, 75, 139, 168, 157, 1, 64, 94, 52, 218, 6, 176, 10, 238, 63, 60, 78, 123, 149, 57, 111, 245, 63, 77, 194, 47, 72, 74, 185, 249, 63, 189, 5, 207, 228, 62, 190, 0, 64, 66, 20, 255, 191, 144, 219, 255, 63, 185, 228, 73, 19, 38, 225, 237, 63, 172, 94, 145, 131, 160, 96, 251, 63, 76, 109, 142, 150, 164, 86, 2, 64, 51, 152, 140, 34, 125, 109, 7, 64, 40, 74, 126, 149, 80, 246, 0, 64, 200, 70, 216, 214, 151, 97, 245, 63, 37, 215, 106, 154, 79, 146, 235, 63, 59, 233, 48, 200, 33, 6, 234, 63, 107, 187, 204, 11, 218, 64, 7, 64, 252, 73, 189, 192, 243, 49, 2, 64, 189, 139, 233, 220, 31, 46, 4, 64, 86, 217, 6, 255, 71, 171, 0, 64, 7, 110, 47, 17, 71, 146, 3, 64, 29, 224, 93, 240, 138, 94, 225, 63, 186, 107, 166, 51, 236, 162, 244, 63, 50, 194, 80, 198, 74, 222, 1, 64, 138, 91, 76, 189, 96, 220, 5, 64, 222, 106, 245, 131, 145, 143, 4, 64, 14, 136, 165, 151, 132, 169, 0, 64, 229, 119, 18, 61, 61, 57, 248, 63, 124, 52, 114, 178, 114, 29, 251, 63, 186, 66, 130, 7, 41, 86, 4, 64, 94, 108, 26, 52, 189, 142, 252, 63, 225, 217, 110, 35, 186, 120, 245, 63, 158, 225, 164, 19, 129, 118, 237, 63, 251, 60, 236, 33, 120, 217, 3, 64, 3, 230, 93, 244, 222, 218, 252, 63, 128, 209, 75, 238, 13, 216, 221, 63, 186, 251, 232, 202, 70, 162, 221, 63, 109, 218, 235, 131, 110, 237, 250, 63, 180, 58, 188, 31, 249, 33, 244, 63, 133, 237, 191, 218, 207, 119, 234, 63, 5, 122, 66, 98, 53, 170, 234, 63, 189, 206, 164, 195, 90, 95, 244, 63, 80, 108, 148, 175, 62, 116, 243, 63, 225, 230, 216, 109, 213, 100, 240, 63, 199, 244, 9, 243, 72, 71, 240, 63, 202, 127, 66, 119, 176, 190, 250, 63, 108, 4, 228, 162, 180, 129, 255, 63, 209, 223, 79, 29, 157, 177, 245, 63, 238, 139, 14, 49, 57, 214, 244, 63, 145, 52, 217, 236, 190, 227, 224, 63, 232, 89, 134, 37, 4, 141, 250, 63, 228, 1, 110, 40, 158, 133, 221, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 192, 23, 111, 8, 73, 188, 2, 64, 161, 152, 244, 215, 131, 193, 4, 64, 85, 106, 159, 116, 136, 144, 5, 64, 24, 67, 227, 145, 33, 194, 255, 63, 22, 149, 119, 37, 126, 82, 249, 63, 108, 163, 247, 191, 167, 177, 245, 63, 210, 5, 222, 104, 6, 16, 221, 63, 94, 178, 52, 105, 103, 0, 6, 64, 252, 156, 142, 34, 165, 181, 2, 64, 25, 2, 230, 156, 28, 117, 248, 63, 110, 177, 141, 148, 233, 80, 0, 64, 107, 226, 163, 64, 8, 79, 242, 63, 50, 103, 28, 18, 23, 32, 246, 63, 169, 203, 11, 96, 254, 3, 219, 63, 138, 15, 225, 44, 212, 253, 251, 63, 124, 181, 123, 83, 184, 250, 242, 63, 178, 58, 127, 15, 39, 177, 248, 63, 48, 64, 86, 214, 224, 222, 247, 63, 36, 109, 141, 230, 199, 221, 248, 63, 130, 252, 194, 198, 103, 121, 252, 63, 113, 151, 38, 37, 161, 243, 233, 63, 61, 32, 223, 225, 233, 68, 3, 64, 84, 213, 26, 38, 169, 26, 5, 64, 31, 22, 96, 54, 86, 177, 254, 63, 101, 99, 202, 70, 13, 51, 0, 64, 70, 111, 40, 225, 72, 30, 237, 63, 89, 122, 246, 21, 242, 225, 253, 63, 245, 72, 84, 158, 147, 117, 254, 63, 199, 130, 49, 118, 40, 188, 234, 63, 103, 232, 99, 133, 242, 143, 231, 63, 38, 185, 130, 51, 115, 18, 1, 64, 159, 51, 172, 48, 216, 29, 249, 63, 198, 159, 13, 181, 180, 196, 242, 63, 127, 25, 100, 92, 3, 160, 239, 63, 125, 27, 34, 3, 236, 214, 248, 63, 80, 155, 194, 171, 152, 125, 253, 63, 45, 175, 40, 30, 48, 85, 248, 63, 153, 38, 13, 224, 116, 132, 253, 63, 230, 90, 249, 246, 10, 35, 2, 64, 213, 2, 96, 177, 76, 15, 249, 63, 108, 129, 41, 212, 182, 181, 242, 63, 246, 209, 187, 153, 128, 149, 217, 63, 244, 42, 151, 168, 182, 206, 232, 63, 28, 109, 111, 94, 43, 85, 232, 63, 243, 188, 19, 111, 162, 68, 231, 63, 154, 95, 71, 81, 219, 223, 243, 63, 107, 167, 217, 66, 20, 53, 2, 64, 234, 66, 34, 164, 94, 136, 243, 63, 174, 176, 39, 230, 168, 84, 5, 64, 91, 239, 243, 240, 32, 132, 8, 64, 7, 174, 205, 54, 249, 250, 4, 64, 58, 46, 49, 192, 190, 21, 2, 64, 27, 170, 67, 156, 3, 237, 249, 63, 194, 53, 183, 60, 92, 6, 221, 63, 87, 105, 234, 174, 102, 96, 255, 63, 35, 23, 255, 236, 53, 205, 241, 63, 139, 17, 225, 95, 255, 81, 242, 63, 150, 141, 58, 158, 82, 22, 2, 64, 45, 12, 152, 2, 206, 136, 219, 63, 177, 241, 122, 171, 228, 187, 231, 63, 6, 114, 178, 22, 4, 163, 3, 64, 9, 59, 227, 192, 153, 194, 235, 63, 135, 31, 246, 164, 110, 13, 218, 63, 179, 184, 90, 8, 42, 140, 6, 64, 106, 169, 140, 170, 197, 38, 236, 63, 21, 91, 108, 173, 39, 155, 254, 63, 236, 132, 111, 110, 156, 55, 249, 63, 186, 232, 227, 252, 165, 53, 245, 63, 217, 219, 57, 71, 193, 72, 255, 63, 50, 144, 17, 18, 105, 186, 2, 64, 113, 64, 76, 140, 96, 151, 1, 64, 47, 115, 157, 64, 136, 235, 254, 63, 158, 212, 255, 76, 63, 147, 252, 63, 157, 157, 50, 114, 40, 74, 249, 63, 193, 190, 138, 241, 79, 25, 245, 63, 26, 187, 168, 152, 152, 57, 242, 63, 28, 251, 186, 183, 65, 207, 1, 64, 129, 46, 200, 94, 109, 168, 242, 63, 113, 187, 57, 85, 35, 182, 242, 63, 254, 52, 165, 165, 252, 172, 232},
    {0, 0, 0, 0, 0, 0, 0, 0, 178, 156, 224, 64, 166, 99, 4, 64, 14, 108, 37, 186, 97, 233, 244, 63, 91, 230, 178, 247, 153, 8, 251, 63, 50, 34, 148, 90, 241, 22, 232, 63, 253, 20, 69, 223, 229, 128, 240, 63, 58, 215, 78, 203, 186, 112, 1, 64, 202, 12, 225, 1, 35, 138, 215, 63, 100, 248, 111, 135, 143, 64, 252, 63, 208, 141, 55, 227, 6, 99, 245, 63, 254, 118, 49, 186, 85, 191, 0, 64, 209, 9, 100, 151, 62, 68, 0, 64, 32, 225, 182, 131, 73, 76, 0, 64, 178, 19, 172, 60, 127, 63, 4, 64, 130, 117, 182, 202, 147, 91, 229, 63, 181, 147, 71, 4, 20, 123, 249, 63, 88, 221, 123, 240, 152, 205, 252, 63, 13, 107, 111, 135, 39, 99, 3, 64, 10, 122, 137, 225, 103, 51, 247, 63, 82, 189, 62, 255, 22, 196, 6, 64, 216, 169, 158, 190, 149, 122, 245, 63, 202, 91, 98, 136, 223, 208, 246, 63, 77, 108, 39, 193, 71, 5, 241, 63, 172, 178, 66, 54, 136, 158, 246, 63, 7, 200, 128, 110, 112, 60, 3, 64, 170, 7, 68, 215, 234, 69, 229, 63, 151, 108, 45, 26, 89, 168, 5, 64, 87, 111, 112, 181, 124, 9, 240, 63, 159, 15, 22, 204, 203, 109, 232, 63, 76, 189, 127, 192, 212, 47, 246, 63, 151, 248, 66, 116, 240, 253, 5, 64, 94, 199, 203, 90, 209, 14, 3, 64, 100, 243, 167, 98, 140, 181, 2, 64, 253, 225, 233, 94, 204, 109, 232, 63, 94, 236, 89, 167, 97, 178, 3, 64, 94, 82, 244, 231, 143, 12, 6, 64, 58, 61, 121, 235, 28, 216, 0, 64, 166, 24, 164, 244, 34, 163, 251, 63, 153, 20, 236, 16, 231, 173, 231, 63, 234, 117, 212, 89, 18, 145, 252, 63, 248, 163, 164, 185, 43, 25, 0, 64, 60, 122, 63, 164, 179, 252, 245, 63, 76, 234, 92, 234, 246, 93, 0, 64, 14, 236, 210, 45, 178, 86, 251, 63, 58, 175, 6, 242, 61, 5, 243, 63, 241, 11, 140, 5, 96, 223, 254, 63, 143, 194, 65, 152, 104, 119, 252, 63, 92, 250, 72, 112, 31, 64, 6, 64, 34, 131, 98, 50, 207, 167, 240, 63, 96, 233, 99, 65, 149, 46, 0, 64, 150, 42, 102, 246, 93, 146, 218, 63, 238, 134, 229, 222, 109, 122, 2, 64, 110, 67, 12, 35, 245, 134, 2, 64, 230, 23, 34, 203, 118, 78, 217, 63, 136, 71, 47, 194, 165, 139, 8, 64, 149, 19, 199, 235, 105, 38, 242, 63, 16, 154, 94, 44, 239, 176, 246, 63, 207, 231, 240, 167, 222, 44, 3, 64, 62, 91, 60, 12, 102, 197, 240, 63, 103, 110, 254, 85, 153, 16, 3, 64, 64, 120, 69, 193, 202, 156, 3, 64, 253, 139, 22, 96, 254, 90, 251, 63, 243, 3, 231, 87, 123, 134, 254, 63, 52, 253, 178, 65, 248, 78, 251, 63, 247, 252, 91, 51, 225, 129, 1, 64, 19, 72, 142, 191, 204, 109, 215, 63, 159, 99, 250, 27, 222, 106, 249, 63, 18, 151, 9, 140, 120, 60, 227, 63, 187, 85, 102, 17, 235, 45, 251, 63, 122, 216, 212, 204, 51, 106, 255, 63, 126, 38, 45, 184, 172, 166, 250, 63, 215, 22, 162, 208, 62, 89, 217, 63, 235, 144, 71, 206, 95, 147, 5, 64, 174, 24, 44, 172, 62, 138, 239, 63, 141, 14, 67, 34, 7, 163, 233, 63, 54, 18, 115, 184, 224, 177, 230, 63, 164, 165, 149, 150, 2, 178, 240, 63, 9, 124, 133, 33, 238, 33, 238, 63, 127, 239, 224, 57, 117, 187, 252, 63, 18, 97, 24, 172, 140, 17, 247, 63, 172, 2, 68, 198, 167, 7, 241, 63, 148, 205, 26, 225, 117, 148, 246, 63, 10, 106, 108, 15, 72, 76, 0, 64, 176, 249, 111, 9, 77, 191, 0, 64, 131, 188, 92, 169, 214, 170, 230, 63, 230, 212, 36, 193, 61, 116, 241, 63, 71, 217, 248, 240, 9, 130, 0, 64, 67, 118, 39, 232, 55, 208, 215, 63, 214, 52, 129, 96, 91, 250, 0, 64, 79, 57, 73, 162, 128, 177, 250, 63, 80, 251, 115, 91, 28, 62, 246, 63, 56, 39, 88, 196, 167, 234, 229, 63, 198, 5, 116, 79, 204, 180, 242, 63, 147, 35, 150, 164, 159, 122, 245, 63, 154, 148, 96, 248, 22, 211, 240, 63, 108, 245, 232, 221, 189, 10, 240, 63, 186, 129, 93, 47, 116, 192, 248, 63, 251, 99, 158, 92, 26, 199, 243, 63, 1, 60, 232, 62, 189, 53, 246, 63, 64, 129, 57, 125, 103, 93, 251, 63}
};

unsigned char TabulatedValues::ucSearchGridAzimuths[3][8*900] = {
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 210, 87, 75, 218, 118, 251, 63, 119, 184, 214, 10, 4, 133, 6, 192, 65, 176, 140, 222, 57, 205, 1, 192, 43, 16, 183, 81, 230, 8, 217, 191, 16, 5, 161, 195, 20, 180, 252, 191, 206, 188, 255, 87, 27, 223, 3, 64, 77, 46, 65, 76, 96, 23, 235, 191, 29, 230, 46, 181, 210, 135, 194, 191, 213, 149, 145, 90, 207, 237, 238, 191, 136, 118, 218, 229, 90, 55, 218, 63, 102, 65, 238, 133, 159, 216, 241, 191, 204, 46, 84, 20, 188, 189, 201, 63, 156, 27, 85, 6, 37, 148, 4, 192, 34, 169, 55, 57, 71, 162, 4, 192, 250, 7, 59, 241, 127, 209, 253, 191, 241, 233, 213, 234, 177, 130, 244, 191, 42, 125, 215, 48, 217, 161, 249, 191, 81, 62, 224, 82, 174, 162, 251, 63, 59, 35, 232, 218, 215, 239, 253, 191, 68, 144, 16, 106, 12, 167, 7, 192, 26, 69, 210, 199, 7, 15, 244, 63, 178, 68, 150, 66, 148, 52, 3, 192, 189, 97, 53, 19, 68, 109, 246, 63, 198, 211, 185, 241, 113, 138, 235, 191, 28, 8, 22, 139, 151, 111, 245, 63, 162, 155, 165, 147, 70, 0, 245, 191, 60, 239, 108, 146, 101, 230, 186, 191, 130, 151, 197, 41, 248, 206, 3, 192, 46, 162, 218, 99, 81, 114, 241, 63, 135, 248, 34, 229, 134, 135, 245, 191, 36, 150, 64, 202, 201, 106, 8, 64, 73, 7, 43, 59, 13, 158, 252, 191, 60, 102, 158, 65, 107, 234, 7, 64, 191, 61, 95, 231, 19, 220, 228, 63, 14, 1, 14, 118, 143, 50, 248, 191, 173, 12, 138, 139, 214, 137, 7, 192, 7, 143, 117, 27, 234, 244, 7, 192, 221, 232, 77, 224, 154, 134, 178, 63, 18, 193, 255, 179, 166, 248, 243, 191, 246, 192, 1, 51, 48, 10, 178, 63, 1, 252, 17, 153, 91, 90, 1, 192, 134, 184, 242, 238, 113, 129, 221, 63, 133, 41, 131, 248, 94, 215, 1, 192, 241, 79, 151, 81, 244, 181, 247, 63, 126, 27, 186, 50, 152, 83, 235, 191, 226, 31, 70, 170, 102, 200, 211, 191, 127, 128, 113, 80, 2, 197, 241, 63, 209, 55, 74, 63, 46, 138, 0, 64, 98, 254, 126, 139, 142, 87, 4, 192, 13, 186, 208, 156, 185, 198, 240, 63, 85, 137, 17, 234, 138, 15, 243, 63, 70, 154, 237, 129, 151, 134, 242, 63, 56, 241, 68, 130, 207, 93, 5, 64, 138, 89, 151, 35, 162, 22, 7, 64, 27, 237, 249, 232, 224, 102, 5, 192, 246, 215, 22, 171, 24, 115, 1, 64, 203, 248, 8, 25, 187, 215, 245, 63, 64, 231, 251, 251, 126, 210, 237, 63, 76, 146, 15, 253, 251, 47, 249, 191, 132, 59, 117, 184, 111, 232, 247, 63, 190, 3, 204, 134, 94, 15, 3, 64, 245, 229, 58, 125, 128, 10, 6, 192, 236, 229, 128, 109, 100, 77, 6, 192, 249, 129, 44, 234, 239, 194, 247, 63, 142, 163, 133, 224, 80, 195, 218, 191, 0, 173, 181, 60, 32, 19, 7, 192, 137, 116, 209, 246, 196, 182, 5, 192, 113, 171, 14, 119, 60, 146, 226, 63, 181, 61, 76, 93, 47, 233, 243, 191, 176, 238, 191, 131, 40, 66, 224, 191, 240, 20, 172, 169, 23, 211, 202, 191, 204, 179, 158, 134, 103, 21, 236, 63, 253, 150, 31, 150, 211, 75, 235, 191, 225, 58, 56, 110, 52, 189, 225, 191, 215, 150, 110, 152, 223, 90, 6, 192, 233, 95, 124, 220, 151, 120, 8, 192, 135, 192, 84, 216, 11, 106, 254, 63, 110, 201, 134, 220, 140, 175, 249, 191, 0, 161, 51, 57, 81, 187, 4, 64, 74, 246, 8, 43, 185, 92, 177, 191, 251, 3, 2, 236, 93, 96, 255, 63, 244, 103, 158, 218, 159, 136, 7, 64, 220, 140, 213, 212, 202, 61, 1, 192, 6, 120, 101, 2, 252, 174, 194, 191, 0, 254, 218, 159, 54, 145, 228, 191, 188, 11, 180, 54, 214, 154, 246, 63, 113, 185, 181, 99, 125, 133, 252, 63, 251, 14, 209, 191, 109, 214, 248, 191, 111, 144, 147, 118, 68, 166, 235, 191, 154, 122, 177, 59, 240, 120, 6, 192, 145, 173, 64, 200, 229, 184, 247, 191, 126, 50, 138, 227, 108, 173, 249, 63, 132, 228, 245, 156, 143, 159, 209, 63, 90, 211, 147, 138, 95, 146, 219, 191, 37, 156, 21, 213, 75, 94, 247, 191, 165, 110, 200, 168, 20, 117, 225, 63, 134, 126, 216, 199, 90, 82, 234, 191, 246, 28, 234, 143, 54, 44, 5, 192, 250, 148, 100, 218, 47, 45, 255, 63, 48, 84, 187, 152, 143, 217, 7, 192, 242, 141, 84, 200, 62, 111, 241, 191, 228, 206, 214, 105, 8, 108, 2, 64, 254, 241, 223, 153, 18, 52, 1, 192, 145, 201, 87, 236, 123, 189, 240, 191, 15, 39, 184, 106, 26, 136, 228, 191, 108, 104, 73, 166, 57, 107, 249, 63, 191, 134, 61, 47, 221, 99, 235, 63, 11, 238, 21, 222, 117, 192, 5, 64, 156, 17, 216, 130, 81, 107, 8, 64, 254, 145, 85, 204, 234, 20, 5, 64, 186, 174, 250, 5, 51, 122, 189, 63, 56, 132, 127, 132, 131, 73, 251, 63, 44, 50, 63, 68, 174, 111, 1, 192, 228, 106, 58, 87, 188, 190, 8, 192, 164, 91, 150, 231, 62, 34, 251, 191, 196, 120, 63, 104, 17, 51, 0, 64, 109, 28, 111, 4, 244, 151, 245, 191, 8, 0, 207, 193, 39, 102, 228, 191, 115, 6, 48, 87, 91, 239, 235, 191, 73, 152, 97, 251, 123, 160, 241, 63, 72, 82, 99, 56, 232, 192, 251, 191, 95, 175, 179, 94, 172, 28, 162, 63, 33, 52, 205, 56, 145, 170, 235, 191, 59, 137, 61, 28, 176, 27, 238, 63, 184, 19, 20, 50, 182, 187, 240, 63, 132, 82, 42, 46, 94, 198, 242, 191, 158, 213, 186, 235, 156, 67, 199, 63, 207, 229, 40, 251, 29, 93, 6, 64, 198, 244, 76, 56, 120, 138, 242, 63, 120, 129, 254, 61, 176, 149, 4, 64, 33, 215, 215, 224, 39, 74, 3, 192, 160, 154, 223, 121, 255, 207, 250, 63, 199, 116, 12, 193, 137, 93, 228, 191, 87, 124, 16, 25, 171, 138, 6, 64, 40, 63, 153, 241, 14, 225, 3, 192, 215, 9, 37, 173, 178, 119, 217, 191, 114, 163, 168, 218, 125, 223, 7, 64, 31, 116, 194, 79, 100, 48, 1, 192, 220, 173, 190, 13, 225, 104, 5, 192, 159, 216, 163, 118, 50, 38, 249, 63, 161, 34, 189, 41, 125, 148, 0, 192, 45, 86, 143, 241, 230, 181, 3, 64, 3, 39, 150, 61, 235, 85, 253, 63, 73, 199, 146, 233, 197, 33, 255, 63, 233, 61, 93, 159, 102, 217, 251, 191, 193, 59, 72, 36, 252, 113, 251, 63, 93, 172, 77, 80, 121, 59, 254, 191, 254, 135, 235, 109, 53, 83, 230, 63, 236, 101, 191, 114, 68, 93, 247, 63, 177, 219, 76, 186, 159, 135, 4, 192, 30, 17, 98, 63, 225, 243, 5, 192, 240, 154, 236, 147, 152, 152, 247, 191, 205, 126, 14, 227, 6, 34, 5, 64, 125, 196, 26, 175, 105, 16, 228, 63, 46, 115, 187, 83, 110, 11, 238, 63, 110, 114, 171, 132, 0, 192, 245, 191, 113, 152, 135, 223, 253, 53, 207, 191, 144, 251, 218, 93, 5, 161, 227, 191, 169, 146, 135, 1, 48, 123, 253, 191, 14, 163, 198, 242, 12, 198, 198, 191, 160, 117, 46, 85, 222, 104, 1, 192, 113, 7, 150, 74, 190, 99, 7, 192, 8, 234, 217, 18, 143, 195, 250, 191, 26, 27, 183, 71, 224, 195, 243, 63, 71, 14, 130, 185, 125, 97, 232, 63, 169, 139, 81, 171, 244, 46, 246, 191, 127, 228, 165, 45, 19, 129, 205, 63, 222, 92, 197, 35, 138, 214, 1, 192, 189, 108, 100, 163, 253, 244, 232, 63, 208, 241, 187, 203, 21, 0, 200, 191, 239, 128, 94, 18, 156, 171, 255, 191, 162, 51, 86, 69, 68, 44, 241, 191, 89, 129, 191, 207, 200, 183, 228, 63, 14, 231, 255, 81, 18, 116, 2, 64, 4, 118, 35, 134, 231, 215, 5, 64, 188, 157, 47, 191, 226, 194, 217, 63, 22, 11, 220, 223, 224, 240, 1, 192, 3, 48, 210, 125, 247, 167, 237, 63, 147, 209, 72, 66, 9, 91, 249, 63, 252, 134, 222, 231, 204, 192, 102, 191, 84, 157, 1, 12, 39, 248, 6, 64, 163, 162, 68, 154, 80, 42, 2, 64, 117, 123, 56, 207, 46, 104, 3, 64, 84, 101, 198, 192, 36, 155, 1, 64, 235, 191, 15, 66, 85, 46, 241, 191, 20, 128, 99, 99, 123, 2, 5, 64, 70, 206, 217, 116, 111, 21, 5, 64, 87, 146, 228, 206, 114, 121, 217, 191, 188, 193, 148, 12, 89, 91, 2, 64, 208, 100, 15, 171, 183, 110, 230, 63, 246, 252, 5, 136, 185, 182, 220, 63, 234, 202, 214, 149, 222, 221, 250, 191, 146, 161, 137, 125, 14, 95, 212, 63, 78, 208, 161, 116, 42, 156, 176, 191, 208, 49, 36, 1, 9, 156, 242, 191, 255, 110, 13, 104, 53, 238, 7, 192, 219, 92, 254, 191, 129, 219, 255, 191, 112, 45, 97, 106, 55, 18, 5, 64, 230, 250, 72, 140, 162, 250, 211, 63, 88, 26, 30, 5, 22, 3, 8, 64, 192, 246, 233, 209, 40, 79, 237, 63, 125, 0, 108, 47, 123, 224, 226, 63, 208, 37, 54, 222, 216, 186, 2, 64, 112, 224, 99, 135, 39, 81, 3, 64, 191, 138, 58, 106, 161, 252, 3, 192, 234, 139, 109, 185, 175, 220, 247, 191, 244, 32, 209, 144, 240, 147, 2, 192, 92, 221, 66, 234, 150, 245, 0, 64, 136, 6, 73, 231, 248, 179, 200, 63, 50, 7, 208, 243, 160, 190, 226, 191, 175, 134, 7, 71, 118, 164, 214, 63, 249, 244, 67, 15, 195, 72, 255, 63, 247, 74, 236, 29, 227, 125, 224, 63, 153, 185, 235, 54, 132, 186, 202, 191, 224, 72, 191, 235, 24, 61, 4, 64, 117, 83, 35, 11, 169, 62, 165, 191, 164, 156, 9, 143, 66, 25, 208, 191, 80, 69, 215, 38, 45, 219, 7, 64, 174, 84, 219, 81, 217, 88, 243, 63, 88, 203, 60, 153, 5, 212, 244, 63, 116, 159, 16, 127, 70, 50, 3, 192, 141, 168, 149, 187, 171, 132, 241, 191, 161, 162, 170, 31, 159, 124, 253, 63, 212, 181, 27, 178, 126, 141, 255, 191, 60, 205, 95, 153, 232, 234, 0, 64, 166, 162, 147, 0, 147, 176, 228, 191, 239, 55, 59, 232, 182, 95, 242, 191, 176, 199, 223, 98, 246, 184, 7, 64, 184, 1, 204, 94, 91, 225, 8, 64, 44, 233, 159, 25, 219, 96, 0, 192, 160, 212, 245, 180, 92, 176, 254, 191, 194, 115, 165, 80, 228, 230, 2, 64, 121, 54, 77, 246, 84, 37, 219, 63, 46, 103, 99, 200, 140, 19, 9, 192, 90, 117, 12, 9, 77, 11, 255, 63, 72, 88, 204, 175, 176, 145, 1, 192, 98, 229, 110, 93, 99, 114, 2, 192, 172, 93, 12, 157, 38, 118, 238, 191, 185, 225, 248, 162, 53, 5, 2, 64, 151, 106, 159, 81, 120, 100, 253, 63, 191, 118, 183, 222, 224, 182, 0, 64, 249, 59, 216, 45, 22, 57, 7, 64, 16, 190, 237, 108, 142, 91, 246, 63, 32, 90, 173, 213, 36, 164, 232, 63, 129, 83, 67, 56, 141, 111, 222, 63, 159, 210, 78, 24, 182, 100, 241, 63, 78, 84, 75, 194, 137, 26, 230, 191, 253, 140, 121, 22, 135, 35, 238, 63, 81, 202, 178, 146, 76, 96, 199, 63, 87, 81, 93, 253, 59, 57, 224, 191, 0, 3, 19, 14, 136, 93, 8, 192, 125, 169, 64, 159, 141, 238, 7, 64, 21, 0, 134, 35, 151, 238, 254, 63, 179, 74, 113, 153, 72, 96, 220, 191},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 11, 153, 6, 253, 98, 214, 191, 85, 249, 185, 206, 219, 15, 189, 191, 82, 190, 111, 63, 56, 3, 1, 64, 116, 213, 167, 140, 121, 133, 244, 191, 156, 71, 206, 123, 4, 149, 198, 191, 172, 60, 212, 212, 123, 104, 0, 64, 105, 101, 90, 55, 60, 153, 2, 192, 136, 133, 204, 173, 71, 229, 5, 64, 82, 48, 87, 84, 32, 83, 214, 191, 236, 4, 38, 244, 54, 126, 210, 191, 20, 211, 98, 127, 38, 247, 7, 64, 222, 21, 173, 207, 248, 214, 242, 63, 72, 56, 195, 14, 181, 193, 226, 191, 163, 220, 175, 132, 126, 245, 6, 64, 106, 234, 141, 192, 152, 148, 249, 63, 217, 68, 153, 14, 43, 193, 8, 64, 44, 209, 174, 90, 169, 92, 1, 192, 56, 9, 198, 41, 243, 140, 233, 63, 12, 142, 23, 25, 208, 75, 229, 191, 78, 125, 178, 10, 131, 202, 229, 63, 186, 193, 241, 182, 252, 58, 248, 63, 94, 195, 113, 150, 231, 36, 232, 191, 125, 23, 122, 230, 111, 153, 8, 64, 223, 144, 208, 185, 235, 17, 4, 64, 141, 22, 122, 182, 232, 230, 227, 63, 247, 222, 254, 34, 205, 197, 226, 191, 81, 144, 123, 135, 108, 236, 225, 191, 122, 125, 219, 191, 214, 124, 2, 64, 32, 176, 205, 122, 72, 152, 223, 63, 230, 230, 158, 238, 15, 201, 245, 63, 222, 164, 104, 152, 7, 169, 225, 191, 55, 23, 127, 53, 88, 189, 8, 64, 69, 145, 204, 0, 78, 127, 253, 191, 112, 31, 243, 255, 240, 168, 1, 192, 158, 224, 38, 194, 106, 122, 223, 63, 233, 185, 81, 226, 52, 60, 8, 192, 122, 4, 67, 80, 142, 204, 241, 63, 63, 240, 187, 94, 58, 167, 177, 191, 214, 165, 171, 132, 34, 209, 6, 64, 211, 183, 254, 109, 238, 172, 223, 63, 85, 224, 52, 96, 247, 71, 4, 64, 236, 208, 182, 136, 221, 186, 245, 63, 242, 170, 30, 85, 24, 8, 191, 191, 136, 64, 115, 159, 87, 209, 223, 191, 132, 54, 135, 10, 195, 224, 3, 64, 202, 192, 115, 241, 129, 211, 5, 192, 135, 11, 144, 8, 94, 255, 243, 63, 226, 190, 118, 16, 68, 207, 186, 63, 20, 92, 196, 56, 185, 43, 5, 64, 209, 239, 97, 209, 174, 50, 4, 192, 73, 217, 171, 100, 0, 94, 214, 191, 135, 78, 2, 77, 176, 218, 252, 63, 166, 11, 116, 101, 119, 102, 192, 63, 234, 88, 100, 239, 105, 48, 247, 63, 178, 13, 164, 241, 182, 30, 237, 191, 220, 115, 11, 116, 77, 16, 250, 191, 244, 21, 220, 25, 206, 38, 245, 63, 24, 26, 5, 82, 65, 183, 232, 63, 200, 187, 15, 183, 132, 116, 3, 64, 166, 218, 57, 14, 91, 120, 168, 63, 217, 8, 165, 111, 41, 105, 228, 191, 83, 74, 145, 36, 211, 49, 249, 63, 160, 136, 6, 104, 73, 215, 4, 192, 176, 164, 21, 8, 149, 56, 214, 63, 107, 124, 165, 160, 33, 225, 234, 63, 230, 92, 165, 208, 206, 255, 6, 64, 183, 82, 242, 43, 149, 68, 215, 191, 64, 163, 56, 146, 197, 227, 234, 63, 108, 110, 142, 75, 75, 79, 0, 64, 74, 169, 113, 99, 51, 190, 228, 63, 238, 222, 146, 185, 97, 26, 1, 64, 228, 146, 179, 129, 193, 50, 7, 64, 173, 132, 60, 84, 135, 161, 249, 63, 251, 107, 149, 201, 29, 32, 229, 63, 122, 89, 56, 68, 20, 47, 234, 191, 221, 34, 110, 253, 193, 202, 246, 191, 59, 23, 171, 17, 13, 221, 251, 191, 5, 43, 159, 112, 129, 27, 254, 191, 48, 152, 134, 238, 97, 99, 2, 192, 41, 221, 168, 81, 174, 125, 2, 64, 97, 81, 160, 95, 1, 59, 223, 63, 218, 100, 252, 217, 180, 199, 244, 191, 230, 182, 22, 49, 153, 189, 1, 64, 138, 251, 95, 134, 152, 44, 8, 64, 171, 40, 199, 167, 218, 14, 250, 191, 94, 5, 144, 48, 66, 160, 199, 191, 150, 154, 183, 211, 182, 22, 251, 63, 4, 27, 225, 30, 69, 115, 244, 63, 51, 94, 120, 163, 119, 229, 184, 63, 172, 48, 144, 20, 182, 128, 224, 191, 115, 215, 167, 207, 246, 215, 1, 64, 100, 11, 14, 162, 42, 140, 251, 63, 221, 92, 137, 162, 75, 208, 228, 191, 114, 2, 168, 100, 83, 8, 249, 63, 152, 115, 26, 42, 141, 100, 1, 192, 88, 249, 109, 147, 209, 20, 255, 191, 238, 254, 123, 100, 136, 196, 7, 192, 120, 1, 189, 17, 134, 93, 232, 191, 253, 203, 238, 196, 66, 74, 239, 63, 143, 98, 72, 237, 97, 0, 9, 64, 158, 152, 253, 103, 227, 54, 252, 63, 185, 44, 197, 144, 61, 148, 181, 191, 94, 226, 253, 72, 127, 250, 3, 64, 3, 28, 236, 126, 136, 65, 206, 63, 63, 129, 200, 174, 181, 76, 242, 63, 51, 133, 188, 86, 16, 176, 245, 63, 215, 76, 253, 225, 189, 170, 253, 63, 249, 83, 36, 162, 252, 33, 7, 64, 80, 224, 49, 208, 119, 152, 1, 64, 201, 67, 88, 53, 187, 180, 229, 63, 230, 104, 189, 212, 217, 150, 6, 192, 25, 92, 233, 126, 49, 201, 194, 191, 24, 60, 237, 138, 67, 103, 4, 64, 148, 146, 100, 236, 173, 92, 220, 191, 90, 10, 231, 41, 25, 102, 183, 63, 61, 42, 65, 38, 5, 238, 234, 191, 172, 24, 232, 9, 251, 54, 5, 64, 42, 198, 183, 195, 173, 100, 248, 63, 11, 187, 116, 171, 23, 22, 254, 63, 74, 169, 158, 230, 145, 24, 9, 64, 217, 163, 237, 121, 73, 249, 215, 63, 52, 116, 158, 28, 73, 151, 243, 63, 137, 171, 208, 162, 225, 168, 249, 191, 40, 49, 169, 135, 106, 30, 1, 64, 199, 156, 237, 68, 251, 65, 250, 191, 37, 88, 152, 188, 202, 201, 246, 191, 245, 128, 72, 96, 48, 28, 228, 191, 123, 193, 29, 118, 214, 45, 252, 191, 99, 180, 98, 233, 13, 153, 195, 63, 139, 37, 136, 84, 175, 152, 4, 192, 38, 152, 102, 239, 40, 37, 1, 64, 193, 2, 175, 6, 76, 84, 8, 64, 206, 70, 43, 62, 167, 54, 244, 191, 191, 113, 241, 211, 94, 244, 3, 192, 43, 155, 232, 145, 110, 50, 226, 191, 32, 1, 89, 251, 203, 36, 250, 191, 57, 88, 43, 47, 213, 251, 239, 191, 0, 250, 69, 26, 214, 53, 254, 191, 17, 186, 194, 163, 161, 72, 3, 192, 219, 25, 240, 47, 216, 164, 6, 192, 198, 28, 99, 241, 32, 30, 246, 63, 97, 154, 220, 60, 110, 46, 245, 191, 129, 216, 84, 46, 163, 165, 243, 191, 97, 128, 82, 209, 119, 217, 242, 191, 90, 136, 79, 156, 144, 133, 3, 192, 64, 41, 183, 226, 74, 49, 233, 191, 37, 146, 105, 91, 212, 223, 137, 191, 198, 173, 16, 180, 47, 173, 5, 192, 149, 250, 10, 1, 5, 126, 238, 63, 46, 212, 38, 166, 157, 51, 6, 64, 173, 19, 222, 143, 250, 80, 255, 191, 220, 141, 75, 165, 248, 170, 228, 63, 121, 56, 109, 119, 40, 218, 215, 191, 118, 238, 64, 113, 164, 24, 0, 192, 165, 63, 83, 117, 158, 63, 234, 63, 186, 5, 191, 233, 180, 213, 197, 63, 66, 98, 119, 200, 104, 144, 241, 191, 10, 206, 216, 109, 94, 43, 2, 192, 247, 93, 221, 126, 64, 112, 247, 191, 177, 245, 167, 113, 89, 192, 242, 63, 36, 242, 138, 137, 187, 201, 204, 63, 96, 182, 21, 53, 132, 195, 225, 63, 0, 119, 4, 146, 207, 236, 0, 192, 184, 176, 163, 133, 242, 188, 3, 192, 181, 133, 89, 81, 129, 20, 112, 191, 181, 212, 33, 104, 79, 74, 212, 63, 205, 227, 164, 142, 79, 183, 233, 63, 226, 251, 70, 59, 224, 222, 237, 63, 216, 115, 72, 147, 63, 0, 253, 191, 49, 238, 162, 184, 24, 122, 245, 191, 186, 102, 135, 7, 198, 138, 4, 64, 195, 142, 27, 46, 72, 89, 252, 191, 138, 101, 16, 52, 26, 231, 5, 64, 198, 5, 35, 133, 172, 40, 247, 191, 5, 184, 15, 145, 88, 250, 244, 63, 20, 204, 109, 46, 76, 16, 3, 64, 193, 122, 178, 237, 1, 216, 4, 192, 254, 42, 96, 245, 159, 157, 2, 192, 203, 27, 159, 221, 66, 95, 7, 192, 20, 19, 228, 233, 224, 252, 2, 64, 250, 113, 3, 153, 148, 224, 242, 191, 218, 34, 219, 134, 148, 186, 6, 192, 91, 57, 37, 213, 27, 189, 245, 63, 212, 31, 181, 39, 48, 77, 253, 191, 13, 10, 61, 212, 137, 0, 245, 63, 82, 213, 84, 218, 65, 137, 5, 192, 104, 198, 44, 127, 239, 242, 255, 63, 99, 144, 197, 155, 254, 211, 248, 191, 11, 37, 88, 89, 76, 101, 5, 64, 212, 4, 62, 1, 82, 71, 0, 64, 14, 160, 195, 129, 162, 64, 253, 191, 53, 105, 180, 88, 231, 104, 243, 63, 157, 252, 16, 203, 60, 250, 199, 63, 121, 82, 121, 222, 128, 25, 246, 63, 65, 6, 62, 133, 113, 70, 253, 63, 223, 130, 92, 19, 41, 75, 1, 64, 174, 40, 164, 89, 35, 96, 3, 64, 62, 149, 162, 195, 6, 17, 243, 191, 78, 39, 126, 211, 40, 152, 234, 191, 32, 5, 229, 166, 10, 134, 2, 192, 255, 73, 169, 131, 17, 214, 5, 192, 118, 221, 146, 117, 183, 80, 3, 64, 241, 18, 144, 106, 187, 12, 252, 63, 152, 189, 15, 101, 133, 14, 207, 191, 22, 206, 228, 58, 47, 148, 248, 63, 171, 99, 101, 168, 9, 135, 1, 64, 15, 243, 74, 122, 39, 7, 1, 64, 246, 178, 193, 81, 138, 175, 245, 191, 249, 141, 27, 142, 230, 99, 4, 192, 186, 235, 208, 69, 212, 152, 210, 63, 10, 147, 251, 119, 199, 38, 4, 192, 111, 142, 233, 131, 112, 82, 248, 63, 253, 150, 243, 126, 7, 46, 1, 192, 203, 213, 104, 162, 57, 25, 255, 63, 41, 58, 119, 26, 163, 218, 8, 192, 62, 250, 19, 163, 231, 88, 3, 64, 20, 241, 233, 24, 228, 109, 2, 192, 40, 131, 133, 144, 220, 206, 235, 63, 39, 199, 166, 218, 170, 55, 6, 192, 108, 39, 95, 157, 36, 30, 198, 63, 84, 173, 73, 65, 153, 143, 236, 63, 51, 173, 218, 29, 20, 162, 7, 64, 104, 178, 159, 129, 148, 150, 245, 63, 23, 148, 166, 83, 201, 142, 0, 192, 156, 185, 202, 19, 9, 37, 0, 64, 41, 174, 60, 165, 66, 195, 236, 191, 15, 53, 46, 115, 195, 34, 4, 64, 141, 226, 239, 112, 28, 24, 252, 191, 86, 165, 151, 59, 31, 44, 241, 191, 134, 2, 92, 242, 38, 252, 1, 64, 148, 116, 30, 93, 41, 68, 156, 191, 0, 111, 30, 117, 21, 174, 240, 63, 124, 136, 76, 214, 86, 188, 250, 191, 192, 240, 189, 199, 77, 219, 249, 191, 170, 33, 56, 88, 189, 85, 7, 64, 12, 211, 179, 210, 207, 15, 1, 64, 138, 69, 131, 251, 170, 66, 243, 63, 95, 151, 20, 214, 27, 208, 250, 63, 59, 2, 210, 70, 222, 31, 8, 192, 12, 52, 106, 214, 234, 27, 253, 63, 168, 218, 130, 22, 51, 205, 237, 191, 141, 254, 19, 79, 95, 24, 235, 191, 181, 99, 0, 165, 57, 251, 165, 191, 21, 200, 147, 223, 130, 142, 2, 192, 124, 200, 243, 29, 133, 14, 183, 191, 125, 9, 37, 43, 21, 48, 248, 191, 138, 30, 58, 193, 142, 62, 4, 192, 251, 148, 71, 110, 0, 19, 217, 63, 192, 127, 36, 55, 8, 129, 255, 63, 244, 40, 216, 114, 138, 243, 4, 64, 144, 130, 31, 218, 182, 71, 2, 64, 169, 243, 231, 240, 140, 106, 229, 191, 103, 2, 207, 247, 122, 211, 3, 192, 101, 204, 166, 46, 240, 17, 8, 192, 155, 150, 215, 107, 123, 229, 0, 192, 199, 13, 201, 159, 106, 138, 248, 191, 125, 254, 92, 125, 6, 112, 4, 64, 101, 112, 141, 138, 37, 217, 2, 64, 238, 126, 146, 77, 171, 14, 250, 63, 175, 11, 122, 28, 246, 84, 205, 191, 50, 68, 169, 224, 20, 2, 9, 64, 229, 139, 193, 102, 42, 30, 2, 64, 87, 71, 5, 128, 99, 102, 242, 63, 227, 10, 238, 75, 116, 176, 8, 192, 191, 186, 0, 130, 144, 182, 5, 192, 86, 249, 163, 216, 109, 31, 3, 192, 145, 115, 133, 182, 51, 74, 251, 63, 82, 229, 160, 33, 31, 151, 6, 64, 7, 61, 38, 145, 214, 38, 249, 63, 232, 233, 142, 13, 67, 148, 1, 192, 44, 225, 192, 13, 131, 137, 4, 192, 148, 42, 36, 170, 65, 4, 187, 191, 16, 239, 133, 69, 216, 255, 244, 63, 96, 101, 254, 123, 173, 127, 2, 64, 144, 210, 64, 136, 166, 68, 219, 63, 197, 187, 201, 64, 236, 237, 6, 192, 104, 82, 95, 217, 196, 224, 222, 63, 86, 59, 53, 74, 53, 26, 8, 192, 149, 76, 143, 0, 5, 57, 240, 191, 120, 242, 217, 143, 240, 185, 231, 63, 100, 244, 66, 113, 155, 31, 220, 191, 62, 134, 76, 116, 189, 236, 215, 191, 177, 119, 10, 247, 54, 190, 249, 191, 88, 153, 218, 149, 66, 221, 254, 191, 130, 165, 48, 100, 234, 243, 208, 63, 84, 242, 123, 202, 185, 146, 240, 191, 206, 52, 109, 73, 197, 113, 213, 63, 242, 131, 6, 138, 193, 219, 238, 63, 233, 168, 130, 71, 44, 7, 181, 63, 90, 22, 222, 12, 133, 202, 204, 191, 206, 252, 180, 252, 216, 139, 4, 64, 173, 97, 142, 253, 118, 217, 7, 64, 138, 40, 168, 35, 227, 0, 224, 63, 77, 10, 96, 228, 9, 32, 248, 63, 119, 111, 127, 91, 211, 189, 8, 192, 216, 20, 235, 54, 180, 215, 5, 64, 75, 154, 216, 156, 64, 68, 5, 192, 53, 55, 56, 14, 50, 12, 206, 191, 194, 42, 231, 211, 158, 245, 239, 191, 116, 243, 29, 121, 33, 86, 232, 191, 18, 222, 28, 206, 177, 191, 253, 63, 161, 30, 226, 240, 91, 12, 254, 63, 234, 58, 249, 13, 85, 126, 0, 192, 93, 121, 225, 92, 77, 69, 6, 64, 181, 253, 128, 245, 200, 151, 2, 192, 151, 79, 28, 173, 133, 44, 240, 63, 194, 234, 101, 145, 103, 174, 246, 191, 12, 70, 108, 209, 33, 145, 246, 63, 127, 185, 108, 109, 25, 188, 8, 192, 255, 237, 155, 212, 68, 177, 5, 192, 93, 134, 35, 8, 216, 166, 242, 63, 28, 103, 72, 148, 229, 187, 4, 64, 163, 96, 156, 173, 188, 51, 236, 63, 139, 150, 1, 117, 221, 116, 241, 191, 247, 213, 17, 54, 150, 74, 7, 64, 75, 17, 57, 1, 122, 119, 211, 191, 134, 129, 0, 242, 158, 181, 5, 64, 221, 76, 216, 206, 87, 115, 5, 192, 40, 243, 3, 134, 58, 154, 250, 63, 173, 89, 54, 145, 34, 91, 7, 192, 139, 80, 185, 52, 8, 91, 255, 63, 170, 174, 176, 99, 182, 116, 239, 191, 205, 175, 73, 127, 121, 30, 241, 191, 75, 230, 173, 179, 138, 232, 4, 64, 215, 219, 20, 78, 159, 130, 248, 63, 160, 20, 155, 186, 187, 83, 251, 191, 133, 69, 186, 184, 33, 103, 8, 192, 166, 240, 197, 184, 44, 245, 252, 63, 215, 188, 203, 199, 218, 19, 239, 63, 226, 241, 84, 23, 12, 61, 7, 192, 148, 153, 52, 62, 119, 155, 222, 191, 136, 183, 233, 198, 77, 3, 237, 63, 48, 131, 21, 48, 97, 53, 0, 64, 58, 134, 255, 24, 174, 160, 5, 192, 163, 74, 53, 167, 122, 123, 2, 192, 69, 59, 122, 230, 156, 180, 227, 63, 65, 202, 136, 42, 37, 223, 232, 63, 47, 50, 6, 190, 210, 139, 242, 63, 47, 75, 254, 153, 194, 215, 226, 191, 243, 98, 203, 161, 223, 35, 254, 191, 11, 163, 86, 132, 217, 133, 0, 64, 42, 220, 9, 135, 239, 57, 7, 64, 68, 193, 87, 200, 10, 200, 244, 191, 95, 153, 112, 81, 111, 140, 223, 63, 90, 33, 66, 193, 173, 125, 0, 192, 59, 125, 91, 43, 142, 109, 243, 191, 255, 180, 111, 165, 155, 76, 1, 192, 32, 130, 40, 219, 140, 25, 231, 63, 20, 175, 181, 22, 26, 28, 251, 63, 58, 254, 156, 162, 196, 172, 242, 191, 140, 53, 233, 156, 115, 192, 247, 63, 145, 121, 4, 115, 104, 159, 253, 63, 190, 24, 35, 63, 199, 230, 233, 63, 60, 204, 191, 180, 102, 129, 243, 191, 43, 165, 181, 246, 2, 94, 255, 191, 137, 43, 63, 189, 217, 151, 206, 63, 226, 81, 192, 196, 55, 155, 8, 64, 73, 56, 167, 244, 184, 139, 227, 191, 251, 212, 140, 218, 41, 28, 229, 191, 202, 67, 243, 240, 200, 233, 223, 63, 143, 45, 23, 162, 215, 102, 223, 63, 214, 45, 38, 70, 248, 235, 255, 191, 6, 106, 248, 101, 242, 6, 7, 192, 171, 153, 110, 9, 164, 12, 5, 192, 138, 177, 65, 17, 57, 33, 6, 192, 153, 144, 255, 253, 148, 68, 245, 191, 122, 156, 161, 52, 26, 119, 4, 64, 79, 48, 174, 44, 172, 165, 240, 63, 139, 49, 217, 246, 240, 79, 226, 63, 137, 19, 15, 119, 250, 185, 2, 64, 226, 112, 121, 117, 185, 124, 5, 64, 219, 94, 159, 21, 58, 73, 237, 191, 91, 114, 88, 152, 153, 99, 253, 63, 255, 3, 17, 36, 232, 61, 7, 64, 149, 91, 186, 62, 222, 192, 248, 63, 200, 233, 47, 151, 204, 159, 3, 192, 142, 109, 221, 20, 11, 226, 7, 192, 58, 125, 255, 141, 156, 49, 242, 191, 228, 100, 162, 140, 125, 208, 254, 63, 194, 23, 80, 97, 65, 223, 248, 63, 140, 251, 118, 120, 31, 3, 198, 63, 189, 64, 111, 99, 186, 204, 7, 64, 167, 4, 76, 100, 192, 97, 188, 191, 80, 116, 184, 182, 27, 78, 5, 64, 93, 3, 241, 153, 5, 179, 235, 191, 190, 95, 200, 37, 119, 205, 4, 64, 7, 148, 153, 174, 148, 224, 238, 191, 28, 1, 109, 210, 120, 242, 0, 192, 81, 151, 101, 69, 86, 172, 237, 191, 51, 154, 39, 126, 226, 31, 7, 192, 39, 8, 175, 37, 81, 94, 231, 191, 55, 192, 153, 163, 6, 228, 201, 63, 233, 128, 149, 238, 36, 56, 243, 191, 70, 131, 69, 184, 44, 222, 255, 191, 46, 20, 66, 111, 62, 32, 238, 63, 119, 236, 191, 171, 167, 208, 250, 191, 101, 30, 5, 133, 111, 143, 193, 191, 208, 201, 82, 194, 245, 8, 243, 63, 77, 90, 116, 127, 102, 119, 252, 63, 46, 8, 175, 153, 225, 149, 3, 64, 5, 152, 225, 192, 100, 0, 248, 191, 217, 189, 255, 150, 24, 238, 7, 192, 124, 179, 148, 224, 197, 78, 250, 191, 108, 117, 33, 76, 87, 100, 2, 192, 10, 141, 150, 116, 89, 255, 209, 191, 207, 240, 45, 130, 143, 24, 213, 191, 252, 68, 91, 237, 195, 14, 242, 191, 117, 218, 38, 157, 158, 190, 234, 191, 82, 205, 42, 143, 124, 38, 7, 64, 119, 124, 232, 90, 230, 207, 6, 192, 14, 255, 21, 193, 246, 144, 213, 191, 253, 17, 205, 146, 107, 29, 219, 191, 65, 243, 48, 128, 172, 80, 240, 63, 144, 62, 199, 37, 128, 142, 5, 192, 5, 205, 138, 39, 188, 187, 255, 191, 240, 65, 236, 14, 237, 200, 211, 63, 89, 67, 112, 225, 90, 34, 233, 63, 50, 185, 10, 227, 68, 30, 242, 63, 238, 54, 244, 174, 225, 66, 7, 192, 82, 80, 62, 65, 240, 35, 0, 192, 74, 209, 202, 196, 221, 123, 217, 63, 225, 11, 246, 219, 141, 175, 228, 63, 49, 177, 202, 235, 74, 149, 223, 63, 41, 126, 128, 55, 47, 0, 156, 63, 171, 210, 248, 219, 193, 42, 8, 64, 128, 73, 151, 161, 124, 115, 212, 63, 63, 16, 137, 254, 1, 16, 241, 63, 138, 244, 179, 226, 129, 159, 2, 64, 210, 181, 17, 74, 55, 253, 1, 192, 211, 32, 238, 149, 70, 106, 251, 191, 60, 222, 177, 98, 75, 44, 1, 192, 108, 89, 139, 145, 6, 191, 2, 64, 127, 16, 231, 167, 16, 88, 6, 64, 69, 157, 40, 91, 6, 217, 226, 191, 210, 234, 128, 66, 72, 207, 2, 192, 222, 136, 84, 158, 142, 84, 8, 192, 67, 85, 174, 15, 4, 185, 225, 191, 167, 126, 96, 89, 185, 70, 255, 191, 97, 217, 75, 222, 35, 194, 6, 64, 37, 187, 40, 180, 193, 173, 254, 63, 233, 77, 119, 60, 107, 31, 1, 192, 192, 99, 54, 115, 227, 10, 250, 191, 248, 25, 140, 146, 118, 78, 255, 63, 17, 28, 14, 253, 39, 114, 241, 63, 137, 142, 224, 250, 91, 83, 242, 191, 118, 211, 144, 220, 58, 81, 232, 191, 22, 23, 200, 136, 138, 82, 248, 191, 241, 134, 171, 140, 81, 72, 5, 192, 236, 189, 186, 16, 203, 11, 6, 192, 241, 113, 36, 213, 147, 30, 252, 63, 138, 245, 198, 43, 210, 238, 243, 191, 179, 233, 175, 184, 20, 189, 230, 191, 26, 92, 119, 97, 85, 16, 185, 191, 233, 23, 105, 24, 245, 31, 172, 191, 193, 134, 167, 105, 45, 26, 9, 64, 166, 255, 102, 224, 238, 129, 241, 191, 185, 120, 166, 172, 175, 33, 238, 191, 172, 124, 170, 209, 175, 97, 247, 191, 131, 68, 30, 205, 162, 110, 225, 63, 234, 20, 65, 55, 105, 155, 0, 64, 244, 207, 4, 117, 137, 8, 246, 191, 239, 120, 97, 101, 248, 232, 213, 63, 153, 40, 209, 133, 233, 21, 3, 192, 43, 213, 39, 15, 122, 177, 250, 191, 217, 125, 218, 9, 157, 8, 192, 63, 230, 214, 145, 198, 43, 150, 222, 191, 46, 23, 103, 247, 146, 33, 234, 63, 252, 163, 204, 13, 80, 152, 196, 191, 211, 103, 103, 171, 162, 52, 248, 191, 244, 71, 195, 40, 5, 42, 4, 192, 206, 24, 147, 81, 142, 21, 247, 191, 196, 80, 68, 16, 73, 61, 240, 63, 130, 130, 149, 147, 247, 13, 230, 63, 221, 143, 117, 189, 53, 189, 7, 64, 225, 221, 108, 30, 180, 110, 252, 191, 164, 155, 247, 144, 206, 217, 241, 191, 221, 145, 19, 2, 156, 233, 248, 63, 239, 56, 193, 176, 166, 70, 217, 63, 127, 119, 155, 250, 144, 110, 210, 63, 240, 239, 113, 208, 63, 60, 2, 192, 7, 250, 135, 6, 147, 147, 224, 191, 246, 108, 28, 47, 146, 10, 254, 191},
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 82, 200, 151, 126, 178, 7, 192, 63, 57, 128, 138, 145, 122, 229, 63, 48, 125, 224, 133, 154, 77, 240, 63, 229, 141, 146, 149, 65, 190, 254, 191, 143, 16, 203, 47, 17, 238, 0, 64, 65, 194, 85, 84, 196, 58, 8, 192, 143, 72, 42, 49, 228, 254, 4, 192, 178, 93, 33, 47, 233, 198, 252, 63, 146, 18, 228, 203, 24, 240, 7, 192, 235, 173, 75, 120, 214, 225, 253, 191, 120, 136, 195, 116, 230, 49, 1, 192, 70, 152, 83, 54, 233, 169, 245, 63, 149, 187, 69, 92, 108, 147, 219, 191, 98, 145, 186, 79, 95, 138, 229, 191, 15, 135, 195, 24, 40, 199, 252, 191, 116, 63, 233, 132, 66, 161, 6, 64, 176, 74, 197, 96, 1, 203, 251, 63, 140, 203, 49, 40, 218, 234, 7, 192, 101, 220, 213, 207, 172, 71, 8, 64, 50, 229, 64, 151, 243, 58, 214, 63, 205, 196, 21, 202, 185, 99, 242, 191, 176, 75, 217, 151, 239, 109, 8, 64, 133, 91, 130, 66, 131, 80, 215, 63, 242, 52, 110, 68, 129, 153, 6, 192, 104, 98, 72, 104, 162, 158, 168, 191, 1, 21, 247, 11, 232, 73, 250, 191, 158, 198, 77, 50, 45, 147, 250, 191, 83, 80, 229, 129, 63, 180, 228, 63, 215, 173, 52, 37, 20, 29, 1, 192, 118, 213, 208, 9, 0, 191, 247, 63, 154, 139, 223, 145, 50, 187, 249, 63, 112, 162, 221, 147, 64, 242, 227, 191, 246, 101, 203, 105, 172, 190, 254, 63, 204, 205, 29, 34, 64, 109, 200, 63, 119, 73, 130, 115, 243, 104, 185, 63, 191, 16, 102, 234, 45, 250, 255, 191, 60, 52, 126, 7, 249, 52, 248, 63, 107, 226, 3, 115, 61, 159, 217, 191, 214, 173, 52, 108, 254, 193, 4, 64, 197, 132, 237, 47, 43, 75, 7, 64, 174, 68, 105, 40, 130, 159, 216, 191, 60, 166, 72, 168, 27, 96, 187, 191, 168, 134, 172, 21, 153, 186, 8, 192, 15, 53, 145, 42, 51, 116, 219, 63, 32, 241, 248, 47, 150, 102, 8, 64, 114, 66, 57, 77, 136, 243, 7, 64, 244, 197, 114, 113, 23, 34, 5, 192, 92, 237, 195, 129, 56, 5, 4, 64, 80, 2, 82, 62, 62, 21, 249, 191, 202, 99, 250, 60, 214, 169, 8, 192, 202, 127, 95, 237, 5, 93, 1, 64, 255, 239, 219, 28, 99, 176, 247, 63, 81, 221, 19, 108, 237, 185, 237, 63, 55, 68, 48, 26, 162, 99, 249, 63, 135, 198, 118, 222, 127, 236, 5, 192, 70, 97, 74, 79, 176, 248, 2, 64, 21, 198, 2, 114, 81, 99, 7, 192, 229, 28, 164, 122, 102, 108, 241, 63, 182, 11, 34, 53, 141, 54, 192, 63, 204, 220, 183, 9, 54, 195, 5, 64, 7, 130, 37, 57, 43, 166, 230, 191, 157, 134, 99, 201, 236, 221, 240, 191, 72, 218, 223, 207, 245, 44, 2, 192, 141, 225, 108, 178, 145, 247, 230, 191, 109, 189, 31, 239, 44, 162, 5, 192, 247, 137, 18, 73, 130, 22, 232, 191, 83, 49, 176, 237, 63, 140, 255, 63, 113, 83, 24, 247, 108, 44, 209, 191, 25, 9, 147, 247, 197, 95, 201, 191, 134, 80, 48, 122, 174, 98, 3, 64, 103, 128, 239, 225, 121, 220, 7, 64, 70, 92, 98, 55, 180, 157, 237, 63, 153, 14, 53, 170, 224, 161, 251, 63, 32, 178, 190, 100, 194, 29, 225, 63, 116, 185, 22, 135, 96, 82, 2, 192, 15, 76, 101, 228, 104, 49, 6, 192, 72, 83, 181, 200, 66, 85, 8, 192, 96, 57, 225, 222, 82, 170, 2, 192, 9, 148, 253, 29, 135, 175, 231, 63, 183, 24, 26, 127, 244, 188, 6, 192, 230, 66, 254, 244, 130, 86, 236, 191, 58, 117, 66, 111, 136, 157, 7, 64, 162, 215, 195, 215, 229, 10, 4, 64, 107, 81, 25, 202, 45, 89, 5, 64, 143, 63, 75, 34, 115, 216, 251, 63, 238, 167, 254, 85, 179, 211, 236, 191, 63, 217, 14, 62, 184, 128, 174, 63, 78, 26, 204, 193, 66, 149, 4, 64, 235, 204, 52, 252, 110, 213, 5, 64, 80, 76, 55, 189, 30, 123, 0, 64, 105, 56, 184, 111, 141, 233, 253, 191, 63, 18, 16, 171, 86, 99, 250, 63, 114, 237, 238, 48, 247, 104, 1, 64, 108, 57, 173, 146, 127, 241, 243, 63, 28, 101, 123, 139, 145, 141, 254, 63, 160, 204, 144, 142, 255, 139, 240, 191, 90, 81, 128, 16, 136, 0, 243, 63, 150, 211, 150, 46, 236, 127, 219, 191, 252, 251, 188, 147, 31, 125, 189, 191, 45, 20, 163, 5, 222, 136, 2, 64, 26, 148, 62, 51, 245, 98, 244, 191, 243, 110, 33, 232, 246, 150, 8, 64, 132, 203, 79, 33, 156, 104, 4, 192, 142, 101, 15, 3, 129, 58, 3, 64, 234, 145, 66, 114, 246, 75, 252, 191, 176, 198, 37, 216, 27, 166, 246, 63, 81, 16, 61, 154, 238, 52, 242, 63, 170, 192, 192, 154, 30, 28, 2, 64, 38, 157, 143, 246, 12, 164, 230, 63, 16, 122, 75, 0, 175, 248, 217, 191, 83, 222, 225, 37, 30, 174, 1, 64, 8, 162, 214, 128, 242, 150, 245, 191, 145, 35, 160, 76, 228, 139, 222, 63, 26, 152, 207, 1, 104, 209, 1, 64, 17, 130, 237, 41, 187, 78, 8, 64, 192, 64, 112, 95, 82, 211, 6, 192, 59, 127, 186, 66, 31, 35, 242, 63, 53, 192, 35, 101, 136, 181, 207, 63, 75, 88, 215, 12, 62, 206, 8, 64, 173, 87, 112, 143, 235, 175, 248, 63, 251, 183, 213, 201, 136, 54, 253, 63, 110, 25, 202, 15, 54, 245, 7, 192, 192, 197, 110, 216, 29, 217, 3, 192, 69, 173, 30, 186, 202, 201, 4, 192, 120, 31, 94, 187, 102, 72, 214, 191, 92, 129, 20, 79, 158, 247, 236, 191, 221, 58, 7, 35, 114, 52, 1, 192, 92, 197, 30, 70, 205, 188, 7, 64, 211, 5, 147, 76, 122, 51, 4, 64, 134, 44, 98, 101, 206, 8, 8, 192, 219, 71, 230, 2, 65, 181, 249, 191, 99, 213, 129, 217, 46, 224, 196, 191, 253, 91, 212, 11, 27, 159, 248, 191, 251, 226, 230, 253, 56, 163, 206, 63, 66, 130, 197, 4, 111, 251, 238, 63, 254, 66, 167, 180, 151, 136, 4, 192, 77, 46, 53, 219, 0, 210, 193, 191, 54, 233, 35, 120, 29, 93, 244, 63, 245, 27, 42, 96, 170, 201, 254, 191, 253, 194, 54, 185, 7, 252, 244, 191, 122, 166, 195, 196, 71, 217, 4, 192, 157, 143, 159, 157, 54, 8, 4, 64, 197, 163, 239, 222, 42, 87, 205, 63, 53, 99, 154, 140, 169, 242, 161, 63, 93, 137, 55, 241, 100, 207, 5, 64, 234, 244, 143, 151, 122, 25, 5, 64, 138, 239, 161, 82, 151, 164, 0, 192, 63, 36, 1, 54, 16, 215, 7, 192, 204, 161, 238, 137, 2, 163, 246, 63, 68, 167, 32, 19, 251, 79, 254, 191, 2, 191, 1, 150, 126, 72, 247, 63, 75, 209, 190, 105, 143, 30, 251, 191, 228, 249, 110, 14, 132, 138, 4, 64, 102, 75, 188, 101, 166, 223, 0, 64, 129, 166, 233, 177, 183, 198, 198, 191, 68, 92, 79, 126, 105, 244, 1, 64, 229, 45, 168, 147, 179, 12, 2, 64, 190, 231, 157, 103, 46, 123, 246, 63, 95, 16, 71, 224, 104, 51, 253, 63, 48, 74, 117, 8, 83, 250, 242, 63, 38, 138, 13, 233, 45, 200, 178, 191, 175, 10, 45, 36, 147, 201, 255, 63, 132, 178, 132, 99, 141, 141, 243, 63, 238, 29, 200, 113, 226, 222, 242, 191, 202, 125, 111, 98, 37, 222, 240, 191, 23, 164, 22, 161, 249, 124, 233, 191, 29, 37, 82, 199, 19, 203, 240, 63, 245, 136, 170, 214, 235, 169, 206, 63, 100, 163, 33, 108, 253, 122, 7, 64, 155, 170, 101, 155, 115, 227, 7, 64, 144, 121, 236, 200, 10, 152, 0, 192, 166, 84, 15, 111, 18, 38, 232, 191, 117, 60, 30, 246, 109, 119, 242, 63, 50, 71, 233, 234, 207, 35, 8, 192, 49, 247, 62, 221, 24, 254, 252, 63, 166, 15, 15, 75, 245, 154, 7, 192, 168, 158, 63, 35, 202, 25, 4, 192, 165, 232, 90, 100, 4, 74, 251, 63, 182, 51, 194, 23, 17, 40, 3, 64, 21, 185, 79, 153, 177, 200, 2, 192, 205, 234, 59, 91, 1, 25, 0, 192, 169, 72, 44, 211, 36, 130, 183, 63, 74, 203, 104, 65, 192, 66, 186, 191, 234, 61, 183, 105, 78, 108, 212, 191, 8, 131, 158, 151, 110, 239, 202, 191, 148, 242, 226, 216, 21, 146, 1, 64, 177, 53, 216, 55, 20, 234, 255, 63, 89, 63, 110, 11, 234, 227, 242, 63, 227, 189, 52, 143, 214, 221, 254, 191, 249, 249, 125, 180, 30, 120, 235, 191, 83, 73, 154, 171, 45, 64, 8, 64, 60, 240, 7, 29, 103, 116, 8, 192, 94, 60, 188, 107, 127, 138, 230, 63, 198, 253, 141, 5, 181, 22, 0, 192, 37, 142, 156, 26, 94, 69, 4, 192, 200, 12, 46, 24, 131, 230, 238, 63, 97, 128, 101, 46, 234, 59, 253, 63, 68, 137, 46, 13, 101, 125, 195, 63, 92, 162, 199, 92, 91, 231, 250, 63, 78, 77, 184, 41, 121, 50, 234, 63, 16, 141, 60, 214, 68, 246, 5, 192, 224, 131, 222, 221, 235, 240, 252, 63, 65, 81, 209, 117, 151, 154, 7, 64, 29, 76, 145, 94, 245, 58, 241, 191, 90, 237, 186, 40, 251, 130, 250, 191, 242, 31, 161, 162, 138, 192, 2, 192, 105, 92, 202, 37, 138, 246, 2, 64, 222, 252, 38, 94, 241, 13, 8, 192, 136, 224, 217, 218, 47, 39, 5, 192, 204, 242, 147, 150, 230, 136, 247, 191, 180, 191, 174, 202, 54, 32, 4, 64, 182, 185, 65, 89, 110, 249, 6, 192, 152, 233, 200, 49, 99, 231, 224, 63, 209, 194, 223, 42, 149, 42, 240, 191, 10, 194, 62, 151, 59, 161, 6, 192, 242, 234, 197, 172, 55, 201, 246, 63, 34, 251, 14, 115, 80, 26, 246, 63, 132, 153, 14, 42, 80, 137, 169, 191, 171, 217, 184, 142, 147, 195, 212, 63, 154, 9, 167, 171, 251, 247, 3, 64, 216, 144, 43, 107, 203, 215, 229, 191, 171, 46, 132, 51, 89, 121, 226, 191, 128, 48, 2, 32, 43, 243, 241, 191, 7, 106, 243, 214, 248, 100, 248, 191, 46, 36, 160, 146, 15, 26, 196, 191, 204, 149, 239, 141, 7, 178, 232, 63, 88, 68, 148, 179, 105, 191, 247, 191, 219, 199, 157, 115, 253, 27, 237, 191, 39, 22, 208, 154, 248, 34, 185, 63, 152, 234, 202, 250, 87, 49, 246, 63, 154, 92, 255, 18, 77, 9, 3, 192, 69, 187, 113, 11, 101, 91, 4, 64, 1, 58, 198, 139, 215, 240, 8, 192, 246, 249, 21, 235, 112, 195, 250, 63, 102, 229, 17, 11, 57, 116, 251, 63, 112, 106, 211, 192, 37, 26, 240, 63, 96, 137, 231, 86, 157, 169, 0, 192, 164, 55, 90, 133, 115, 10, 2, 192, 204, 161, 125, 188, 146, 31, 242, 191, 206, 235, 74, 62, 17, 166, 2, 192, 60, 74, 37, 211, 74, 197, 243, 63, 252, 250, 142, 132, 126, 164, 245, 63, 50, 159, 214, 48, 243, 155, 245, 63, 91, 107, 109, 240, 193, 170, 249, 63, 244, 249, 131, 15, 184, 203, 2, 192, 136, 9, 65, 229, 112, 184, 2, 192, 183, 32, 155, 206, 121, 163, 247, 63, 26, 191, 78, 122, 247, 224, 242, 191, 185, 148, 62, 62, 242, 143, 110, 191, 160, 240, 163, 41, 10, 210, 248, 63, 75, 17, 138, 42, 96, 1, 228, 63, 161, 68, 15, 173, 244, 188, 219, 63, 200, 215, 95, 229, 71, 193, 230, 63, 94, 251, 162, 248, 27, 97, 174, 191, 253, 189, 251, 247, 95, 216, 8, 64, 211, 206, 71, 170, 244, 166, 251, 191, 139, 90, 92, 8, 245, 56, 7, 192, 247, 22, 39, 83, 133, 52, 254, 191, 66, 206, 8, 23, 26, 129, 255, 191, 94, 14, 78, 105, 45, 245, 5, 64, 16, 111, 194, 38, 126, 221, 246, 191, 110, 219, 190, 136, 86, 82, 242, 191, 134, 197, 240, 59, 179, 87, 7, 64, 42, 23, 29, 55, 61, 51, 229, 63, 151, 203, 92, 192, 198, 100, 230, 63, 223, 62, 87, 114, 116, 175, 254, 63, 30, 117, 217, 131, 208, 64, 1, 192, 13, 190, 24, 9, 109, 108, 231, 63, 140, 35, 227, 178, 207, 64, 6, 192, 26, 87, 235, 251, 114, 30, 227, 63, 154, 130, 51, 240, 208, 113, 247, 191, 49, 192, 5, 107, 51, 98, 161, 191, 36, 91, 176, 225, 72, 166, 238, 191, 11, 171, 226, 51, 1, 188, 3, 192, 253, 167, 77, 167, 16, 251, 1, 192, 192, 170, 32, 20, 254, 127, 224, 191, 38, 76, 158, 107, 15, 227, 218, 63, 107, 218, 215, 136, 117, 186, 0, 64, 84, 2, 245, 249, 210, 164, 255, 63, 169, 249, 147, 71, 161, 132, 241, 191, 27, 39, 194, 141, 226, 235, 193, 191, 140, 245, 31, 208, 117, 68, 240, 63, 82, 64, 28, 135, 54, 166, 244, 63, 90, 108, 194, 247, 244, 93, 239, 63, 72, 125, 200, 5, 128, 10, 221, 63, 95, 69, 92, 183, 72, 196, 0, 192, 71, 92, 137, 107, 13, 41, 253, 63, 121, 178, 151, 57, 165, 120, 5, 192, 197, 43, 174, 104, 214, 190, 3, 192, 41, 67, 22, 35, 5, 61, 235, 191, 164, 63, 231, 137, 100, 211, 3, 64, 185, 176, 58, 158, 75, 69, 244, 63, 22, 171, 22, 158, 196, 57, 248, 191, 12, 228, 161, 108, 43, 53, 7, 192, 62, 27, 216, 136, 109, 91, 1, 192, 99, 180, 252, 59, 114, 94, 1, 64, 208, 203, 7, 66, 4, 93, 208, 191, 240, 223, 68, 23, 107, 237, 160, 63, 99, 202, 13, 85, 69, 51, 248, 63, 19, 221, 122, 177, 57, 192, 248, 63, 35, 200, 21, 255, 51, 87, 6, 64, 156, 27, 235, 229, 13, 69, 254, 191, 232, 128, 61, 253, 134, 39, 3, 64, 213, 118, 130, 189, 106, 176, 216, 191, 196, 245, 255, 130, 56, 162, 233, 191, 223, 208, 105, 252, 173, 46, 222, 63, 96, 220, 71, 175, 1, 143, 6, 64, 116, 87, 213, 160, 145, 188, 250, 63, 182, 43, 62, 237, 74, 189, 251, 191, 26, 231, 193, 135, 66, 28, 0, 192, 112, 242, 219, 9, 114, 221, 6, 64, 175, 153, 83, 226, 96, 227, 253, 63, 200, 174, 182, 221, 156, 193, 252, 63, 128, 159, 213, 141, 232, 180, 249, 63, 210, 190, 36, 92, 26, 254, 250, 63, 47, 67, 204, 190, 127, 118, 244, 191, 27, 119, 10, 147, 138, 63, 242, 63, 216, 80, 173, 83, 22, 107, 229, 63, 128, 200, 28, 33, 111, 108, 247, 63, 55, 231, 57, 195, 156, 63, 252, 191, 26, 208, 7, 175, 151, 134, 0, 64, 95, 236, 118, 225, 135, 91, 252, 191, 29, 78, 31, 200, 130, 194, 6, 192, 115, 154, 77, 150, 76, 176, 231, 191, 90, 11, 248, 115, 97, 61, 220, 63, 74, 86, 180, 61, 164, 216, 251, 63, 8, 240, 250, 67, 114, 192, 6, 64, 255, 247, 124, 79, 93, 115, 5, 192, 217, 63, 88, 123, 247, 229, 1, 192, 110, 190, 8, 72, 137, 226, 239, 191, 218, 95, 72, 182, 162, 97, 243, 191, 109, 39, 192, 215, 29, 131, 3, 192, 242, 1, 240, 151, 230, 113, 242, 191, 65, 217, 27, 185, 50, 100, 250, 191, 171, 59, 207, 80, 19, 61, 0, 64, 160, 211, 36, 189, 132, 204, 248, 191, 246, 124, 140, 187, 159, 99, 230, 191, 175, 15, 226, 180, 208, 104, 6, 64, 72, 121, 92, 153, 244, 105, 248, 191, 89, 23, 251, 227, 87, 183, 240, 63, 80, 111, 110, 83, 84, 232, 241, 191, 30, 251, 201, 108, 7, 20, 227, 191, 92, 201, 137, 53, 100, 127, 2, 192, 136, 78, 197, 249, 134, 140, 0, 192, 86, 27, 159, 169, 210, 5, 255, 191, 79, 101, 235, 70, 236, 114, 251, 191, 197, 171, 25, 242, 33, 101, 255, 191, 130, 144, 153, 151, 99, 210, 3, 64, 186, 187, 81, 145, 90, 54, 182, 63, 6, 53, 219, 40, 5, 59, 254, 63, 12, 53, 247, 180, 193, 89, 1, 64, 143, 146, 29, 226, 200, 235, 3, 64, 137, 165, 195, 154, 19, 176, 1, 64, 59, 123, 117, 248, 221, 123, 6, 64, 200, 79, 18, 68, 230, 249, 0, 64, 179, 89, 7, 40, 85, 94, 244, 63, 244, 34, 158, 236, 162, 139, 234, 63, 32, 191, 13, 155, 152, 23, 253, 63, 168, 17, 0, 161, 89, 116, 239, 191, 193, 105, 34, 213, 137, 108, 7, 192, 137, 233, 254, 196, 113, 212, 243, 63, 99, 139, 39, 184, 237, 53, 7, 64, 63, 16, 70, 106, 100, 20, 6, 64, 215, 93, 248, 36, 32, 88, 224, 191, 236, 16, 209, 243, 7, 94, 0, 64, 67, 80, 153, 191, 105, 35, 253, 191, 180, 194, 23, 201, 22, 118, 1, 192, 69, 37, 252, 58, 126, 121, 252, 191, 109, 237, 216, 218, 14, 175, 5, 192, 253, 101, 174, 11, 14, 70, 1, 192, 136, 33, 187, 117, 211, 103, 200, 63, 60, 44, 223, 184, 105, 27, 241, 63, 220, 232, 34, 244, 212, 76, 6, 64, 130, 39, 141, 255, 173, 75, 242, 63, 215, 132, 234, 164, 143, 203, 253, 191, 154, 18, 2, 140, 90, 97, 0, 192, 223, 96, 225, 1, 0, 60, 250, 63, 208, 43, 100, 181, 141, 73, 201, 63, 139, 21, 78, 70, 130, 4, 207, 63, 33, 43, 172, 186, 42, 180, 249, 63, 86, 239, 249, 150, 135, 164, 3, 64, 241, 23, 131, 166, 237, 194, 5, 192, 235, 194, 181, 42, 128, 23, 5, 64, 66, 150, 226, 184, 19, 255, 0, 64, 148, 103, 199, 179, 35, 91, 253, 191, 250, 200, 149, 170, 107, 223, 245, 191, 233, 190, 207, 178, 160, 86, 248, 63, 155, 210, 45, 208, 213, 75, 237, 191, 227, 226, 207, 10, 28, 162, 248, 63, 120, 188, 149, 81, 134, 66, 246, 191, 14, 177, 185, 24, 75, 74, 3, 64, 202, 45, 134, 155, 216, 117, 7, 192, 174, 53, 182, 49, 169, 75, 1, 192, 193, 10, 6, 13, 177, 172, 4, 192, 156, 241, 19, 37, 208, 255, 247, 191, 144, 174, 254, 108, 74, 33, 1, 192, 184, 178, 94, 17, 40, 125, 0, 64, 163, 189, 34, 120, 117, 213, 241, 191, 132, 215, 130, 27, 109, 243, 255, 63, 161, 243, 188, 85, 140, 123, 225, 191, 181, 89, 30, 101, 143, 35, 98, 191, 218, 103, 157, 109, 48, 53, 5, 64, 191, 14, 95, 109, 16, 44, 248, 191, 213, 159, 73, 24, 230, 212, 4, 64, 224, 198, 173, 86, 5, 145, 210, 63, 157, 86, 35, 171, 153, 90, 223, 63, 188, 57, 172, 2, 242, 241, 228, 191, 89, 16, 79, 210, 19, 110, 7, 192, 9, 135, 179, 137, 168, 66, 232, 63, 47, 86, 46, 132, 72, 239, 243, 191, 181, 148, 49, 238, 220, 51, 245, 63, 183, 103, 49, 170, 173, 209, 249, 63, 54, 66, 102, 115, 26, 243, 236, 191, 19, 153, 16, 24, 235, 25, 9, 192, 211, 195, 138, 134, 105, 12, 3, 64, 202, 236, 210, 251, 20, 218, 210, 191, 117, 117, 112, 127, 20, 123, 3, 192, 47, 106, 156, 92, 128, 91, 189, 191, 7, 229, 2, 3, 55, 220, 225, 63, 55, 92, 246, 7, 17, 251, 2, 192, 47, 113, 234, 10, 139, 244, 232, 191, 5, 105, 50, 230, 77, 58, 254, 63, 44, 232, 175, 84, 204, 224, 249, 63, 248, 207, 81, 128, 148, 235, 8, 192, 130, 132, 126, 112, 92, 104, 233, 191, 62, 15, 204, 180, 119, 88, 4, 64, 204, 104, 12, 248, 117, 119, 1, 64, 92, 170, 255, 183, 84, 78, 245, 191, 66, 218, 126, 212, 94, 181, 2, 64, 25, 53, 173, 213, 67, 191, 212, 191, 173, 151, 126, 74, 189, 190, 4, 192, 68, 44, 131, 25, 65, 104, 243, 191, 109, 129, 38, 245, 51, 149, 236, 191, 127, 53, 245, 81, 247, 201, 250, 191, 140, 87, 235, 157, 76, 121, 6, 192, 160, 193, 220, 87, 185, 170, 6, 192, 111, 163, 31, 56, 84, 25, 218, 191, 44, 226, 49, 201, 13, 228, 6, 192, 63, 120, 18, 81, 233, 115, 208, 191, 184, 33, 16, 148, 230, 168, 196, 191, 128, 200, 101, 69, 75, 15, 205, 191, 55, 195, 126, 79, 30, 127, 233, 63, 80, 34, 173, 143, 203, 30, 253, 63, 197, 8, 169, 97, 170, 137, 252, 63, 111, 240, 148, 147, 175, 104, 247, 63, 8, 193, 58, 74, 114, 45, 240, 63, 192, 183, 14, 204, 236, 89, 211, 63, 23, 224, 219, 161, 207, 21, 165, 63, 176, 95, 174, 90, 218, 122, 235, 63, 137, 118, 247, 207, 175, 251, 209, 191, 152, 205, 12, 109, 47, 90, 7, 64, 252, 158, 17, 185, 103, 226, 193, 63, 185, 147, 192, 67, 191, 138, 225, 191, 83, 50, 164, 67, 150, 67, 252, 191, 188, 195, 62, 130, 179, 65, 3, 192, 161, 96, 82, 77, 193, 113, 238, 191, 210, 40, 212, 202, 17, 132, 243, 63, 81, 137, 252, 247, 8, 149, 218, 63, 97, 185, 238, 45, 42, 29, 234, 63, 166, 151, 201, 143, 171, 96, 1, 192, 63, 77, 126, 192, 131, 135, 225, 191, 98, 93, 77, 196, 40, 77, 225, 63, 67, 100, 114, 48, 167, 239, 248, 191, 119, 39, 207, 97, 3, 161, 225, 63, 146, 177, 181, 86, 232, 5, 9, 192, 180, 196, 29, 254, 22, 140, 7, 64, 194, 164, 178, 8, 35, 93, 5, 64, 255, 153, 133, 235, 209, 40, 246, 191, 94, 53, 239, 206, 6, 119, 200, 191, 173, 151, 2, 35, 63, 223, 224, 191, 251, 206, 19, 72, 64, 190, 8, 192, 74, 69, 186, 87, 130, 54, 242, 191, 108, 19, 198, 230, 186, 184, 8, 64, 38, 215, 95, 164, 210, 56, 231, 63, 0, 114, 134, 115, 27, 117, 242, 63, 60, 225, 9, 53, 137, 134, 224, 191, 16, 248, 173, 79, 212, 23, 204, 191, 197, 134, 254, 173, 54, 14, 240, 63, 146, 163, 232, 93, 160, 6, 232, 63, 178, 124, 68, 230, 27, 63, 8, 64, 224, 84, 171, 150, 231, 134, 5, 64, 131, 232, 190, 247, 218, 177, 3, 192, 113, 136, 181, 81, 175, 48, 2, 64, 96, 248, 144, 112, 17, 175, 7, 192, 170, 4, 42, 158, 186, 136, 6, 192, 226, 43, 15, 191, 32, 206, 218, 191, 120, 132, 113, 180, 88, 60, 238, 63, 82, 99, 138, 39, 15, 151, 3, 192, 100, 237, 50, 57, 61, 38, 217, 191, 111, 69, 26, 66, 69, 199, 245, 191, 214, 250, 204, 242, 190, 82, 206, 191, 140, 174, 39, 49, 149, 203, 3, 192, 124, 7, 197, 178, 99, 140, 240, 63, 78, 220, 125, 185, 190, 37, 4, 192, 135, 21, 150, 52, 247, 55, 238, 63, 172, 105, 107, 2, 151, 196, 233, 191, 238, 39, 210, 5, 109, 151, 245, 63, 188, 174, 163, 245, 99, 238, 243, 191, 136, 231, 67, 181, 61, 25, 232, 191, 18, 126, 132, 69, 243, 117, 0, 64, 2, 137, 205, 4, 177, 122, 2, 64, 188, 200, 140, 40, 41, 17, 246, 191, 103, 232, 218, 218, 162, 139, 247, 191, 97, 224, 27, 60, 23, 80, 161, 191, 98, 17, 123, 28, 9, 35, 247, 191, 18, 226, 190, 56, 38, 143, 245, 191, 6, 175, 102, 227, 127, 152, 251, 191, 27, 160, 201, 48, 19, 95, 247, 191, 113, 1, 84, 58, 166, 38, 2, 64, 253, 171, 67, 223, 137, 151, 220, 63, 215, 222, 102, 203, 161, 179, 162, 63, 121, 39, 196, 88, 106, 231, 197, 63, 254, 185, 160, 44, 96, 102, 245, 191, 105, 9, 118, 194, 110, 53, 1, 64, 128, 48, 203, 89, 16, 145, 0, 64, 11, 35, 255, 72, 124, 20, 1, 192, 4, 219, 168, 243, 115, 188, 6, 192, 142, 37, 23, 72, 196, 39, 0, 192, 219, 239, 73, 34, 227, 110, 254, 63, 152, 142, 182, 141, 103, 150, 253, 191, 18, 192, 240, 110, 174, 22, 2, 64, 18, 152, 132, 62, 244, 240, 232, 63, 75, 217, 236, 55, 25, 175, 223, 191, 214, 163, 188, 44, 15, 37, 253, 191, 108, 39, 3, 52, 116, 39, 4, 192, 91, 207, 49, 147, 25, 73, 5, 64, 184, 198, 208, 195, 187, 82, 5, 192, 226, 237, 178, 158, 188, 210, 175, 63, 203, 32, 225, 249, 90, 127, 248, 63, 238, 246, 23, 171, 142, 184, 214, 63, 187, 182, 16, 77, 42, 174, 247, 191, 57, 106, 1, 15, 137, 240, 7, 192, 151, 108, 52, 106, 129, 211, 255, 191, 190, 2, 64, 19, 55, 181, 2, 192, 58, 157, 139, 199, 125, 71, 228, 191, 126, 32, 104, 125, 3, 221, 2, 64, 192, 144, 156, 175, 135, 254, 0, 64, 105, 95, 95, 228, 145, 233, 201, 191, 3, 51, 124, 243, 115, 233, 255, 63, 30, 46, 19, 189, 1, 166, 0, 192, 143, 215, 195, 203, 31, 157, 0, 64, 10, 112, 28, 6, 108, 112, 244, 191, 224, 186, 155, 28, 184, 40, 248, 191, 138, 218, 253, 64, 197, 5, 6, 192, 255, 91, 28, 36, 21, 198, 242, 63, 38, 202, 32, 248, 79, 48, 237, 63, 113, 246, 122, 197, 62, 60, 8, 64, 60, 219, 239, 208, 126, 147, 244, 63, 86, 125, 238, 250, 102, 111, 210, 63, 203, 55, 85, 217, 171, 85, 6, 64, 73, 97, 227, 114, 59, 209, 246, 191, 60, 42, 78, 247, 239, 145, 5, 64, 168, 23, 248, 194, 246, 18, 8, 64, 119, 180, 205, 192, 12, 234, 248, 191, 98, 46, 122, 157, 177, 138, 6, 192, 208, 129, 179, 148, 46, 178, 243, 191, 4, 172, 40, 157, 122, 116, 231, 63, 43, 124, 33, 103, 168, 194, 6, 64, 113, 86, 63, 182, 155, 198, 2, 192, 150, 21, 115, 253, 130, 49, 8, 192, 239, 43, 229, 7, 129, 113, 8, 192, 160, 69, 184, 38, 63, 112, 6, 64, 63, 208, 107, 74, 232, 126, 241, 63, 108, 91, 221, 212, 2, 41, 7, 192, 120, 165, 107, 248, 28, 115, 235, 191, 103, 91, 93, 227, 178, 59, 242, 63, 230, 150, 77, 79, 165, 102, 251, 191, 172, 13, 161, 55, 18, 21, 5, 192, 193, 134, 144, 208, 98, 175, 1, 192, 50, 203, 157, 101, 64, 11, 7, 64, 139, 225, 230, 108, 206, 134, 255, 191, 125, 158, 112, 175, 122, 108, 5, 64, 79, 164, 6, 5, 168, 82, 6, 64, 205, 196, 113, 178, 37, 92, 202, 63, 144, 228, 124, 197, 91, 209, 1, 192, 149, 1, 88, 238, 221, 28, 240, 191, 24, 197, 26, 219, 50, 13, 225, 191, 226, 86, 91, 67, 11, 8, 237, 63, 115, 3, 73, 129, 42, 4, 250, 191, 184, 168, 227, 53, 254, 50, 243, 191, 80, 20, 149, 39, 202, 178, 2, 64, 5, 162, 157, 115, 142, 26, 213, 63, 140, 176, 158, 44, 31, 230, 252, 191, 119, 232, 224, 214, 118, 46, 1, 192, 29, 5, 78, 209, 84, 226, 255, 191, 15, 58, 132, 3, 97, 229, 5, 192, 217, 94, 111, 81, 228, 93, 2, 192, 12, 131, 118, 115, 44, 248, 250, 191, 46, 244, 27, 158, 136, 23, 8, 64, 246, 143, 193, 239, 37, 46, 242, 191, 128, 213, 226, 98, 227, 12, 9, 192, 4, 250, 21, 237, 235, 193, 253, 63, 99, 8, 209, 249, 145, 173, 246, 63, 94, 196, 57, 21, 123, 122, 8, 192, 234, 198, 75, 90, 81, 170, 7, 192, 73, 48, 68, 70, 126, 107, 246, 191, 193, 42, 205, 221, 146, 20, 147, 191, 202, 83, 53, 252, 138, 123, 237, 191, 77, 138, 246, 156, 128, 172, 233, 63, 185, 72, 242, 221, 142, 240, 250, 191, 28, 140, 175, 107, 96, 37, 237, 63, 95, 190, 255, 198, 59, 44, 2, 64, 58, 143, 136, 47, 113, 94, 176, 191, 74, 174, 220, 52, 224, 52, 223, 191, 252, 204, 136, 30, 209, 181, 232, 191, 71, 43, 30, 124, 93, 145, 230, 191, 64, 246, 8, 116, 200, 235, 229, 63, 186, 92, 111, 94, 85, 32, 2, 64, 112, 208, 237, 27, 3, 98, 228, 191, 228, 178, 166, 42, 24, 109, 240, 63, 144, 217, 21, 70, 174, 11, 9, 64, 18, 255, 11, 111, 144, 166, 3, 64, 216, 63, 56, 165, 43, 106, 235, 63, 135, 93, 38, 31, 25, 70, 242, 63, 47, 9, 86, 26, 164, 251, 238, 63, 59, 184, 220, 102, 160, 176, 246, 63, 118, 80, 247, 30, 20, 201, 216, 191, 39, 230, 51, 234, 221, 107, 4, 192, 13, 112, 203, 8, 90, 97, 236, 63, 47, 35, 229, 50, 196, 186, 6, 192, 186, 28, 240, 45, 92, 38, 2, 64, 195, 72, 50, 135, 220, 8, 231, 191, 115, 237, 54, 181, 85, 52, 235, 63, 27, 134, 19, 43, 111, 114, 2, 64, 162, 25, 217, 177, 157, 68, 2, 64, 170, 157, 124, 23, 72, 187, 253, 191, 98, 203, 97, 111, 199, 195, 250, 63, 173, 186, 54, 91, 173, 45, 250, 63, 208, 216, 192, 95, 205, 6, 254, 191, 63, 237, 167, 250, 199, 154, 227, 63, 80, 245, 153, 192, 163, 13, 236, 191, 254, 222, 57, 141, 115, 254, 7, 192, 211, 79, 10, 126, 113, 23, 242, 191, 245, 43, 0, 233, 18, 217, 254, 63, 42, 244, 35, 11, 255, 70, 229, 63, 49, 137, 108, 95, 124, 65, 205, 63, 3, 151, 188, 26, 170, 195, 247, 63, 77, 143, 211, 125, 65, 210, 2, 192, 242, 103, 78, 199, 96, 197, 234, 191, 33, 198, 162, 105, 103, 210, 232, 63, 194, 71, 69, 183, 102, 219, 7, 64, 163, 216, 190, 14, 57, 243, 6, 64, 254, 37, 111, 144, 96, 120, 244, 191, 92, 117, 62, 9, 175, 144, 228, 191, 154, 33, 67, 80, 28, 23, 218, 191, 58, 133, 36, 97, 233, 178, 244, 63, 55, 166, 81, 114, 160, 152, 225, 63, 86, 73, 61, 199, 194, 177, 214, 63, 138, 43, 22, 230, 222, 161, 244, 63, 197, 92, 206, 24, 117, 56, 6, 64, 210, 242, 150, 43, 208, 183, 1, 192, 237, 158, 85, 79, 171, 126, 222, 63, 180, 77, 86, 244, 41, 170, 5, 192, 244, 176, 39, 183, 112, 69, 243, 191, 87, 48, 182, 0, 188, 119, 229, 63, 180, 251, 121, 140, 167, 244, 237, 191, 240, 143, 155, 159, 134, 231, 252, 63, 35, 72, 142, 85, 4, 231, 250, 191, 76, 162, 4, 156, 88, 101, 1, 192, 85, 43, 166, 121, 9, 218, 251, 63, 124, 165, 72, 232, 98, 209, 227, 191, 252, 169, 29, 62, 100, 7, 236, 63, 133, 225, 230, 83, 196, 140, 240, 191, 119, 136, 7, 74, 87, 51, 251, 191, 210, 43, 197, 167, 170, 141, 224, 191, 251, 183, 23, 82, 220, 71, 1, 192, 177, 216, 109, 179, 84, 163, 217, 191, 160, 31, 100, 123, 187, 126, 2, 64, 82, 140, 188, 180, 125, 93, 231, 191, 134, 30, 95, 20, 139, 173, 8, 192, 100, 62, 209, 88, 107, 217, 249, 191, 32, 237, 240, 228, 0, 106, 250, 191, 182, 9, 63, 84, 46, 234, 210, 63, 239, 68, 177, 51, 192, 223, 253, 63, 22, 54, 115, 91, 128, 224, 3, 64, 77, 43, 253, 97, 155, 247, 248, 191, 44, 171, 125, 89, 160, 11, 4, 64, 138, 25, 146, 68, 76, 177, 176, 63, 132, 49, 34, 28, 177, 34, 6, 64, 230, 202, 109, 72, 135, 177, 236, 63, 218, 47, 130, 119, 221, 139, 233, 63, 15, 20, 24, 102, 98, 147, 221, 191, 181, 16, 118, 69, 13, 186, 4, 64, 226, 113, 95, 192, 253, 34, 244, 63, 178, 170, 183, 16, 82, 108, 224, 191, 3, 176, 123, 81, 17, 36, 245, 191, 174, 146, 189, 119, 122, 253, 4, 192, 203, 234, 22, 193, 157, 86, 241, 191, 198, 250, 46, 186, 222, 32, 226, 63, 36, 109, 133, 154, 109, 190, 251, 63, 147, 44, 203, 35, 74, 9, 252, 63, 227, 57, 208, 249, 62, 77, 249, 63, 122, 40, 140, 157, 52, 126, 213, 191, 34, 104, 49, 96, 153, 69, 213, 63, 31, 120, 219, 164, 173, 117, 248, 63, 68, 135, 36, 226, 223, 9, 247, 191, 192, 139, 145, 206, 145, 21, 238, 63, 122, 193, 235, 216, 217, 143, 245, 63, 235, 173, 125, 155, 201, 140, 205, 191, 63, 104, 237, 72, 231, 30, 255, 63, 5, 55, 144, 108, 53, 196, 209, 63, 46, 23, 118, 22, 212, 21, 212, 63, 180, 103, 214, 75, 144, 244, 181, 191, 24, 53, 152, 242, 176, 207, 213, 191, 67, 208, 218, 161, 164, 80, 5, 192, 4, 231, 118, 198, 212, 235, 0, 64, 247, 161, 118, 111, 65, 130, 242, 63, 64, 146, 184, 72, 39, 207, 237, 191, 155, 227, 124, 169, 15, 157, 238, 191, 217, 108, 59, 88, 214, 123, 4, 64, 180, 147, 237, 227, 45, 112, 6, 192, 46, 195, 8, 155, 32, 225, 251, 191, 64, 196, 3, 199, 121, 32, 7, 64, 112, 46, 95, 62, 224, 248, 6, 192, 42, 244, 23, 6, 175, 114, 4, 64, 255, 66, 233, 180, 200, 58, 0, 64, 230, 153, 171, 41, 18, 20, 5, 64, 36, 179, 232, 195, 19, 162, 229, 191, 113, 5, 161, 199, 8, 154, 1, 192, 109, 119, 64, 105, 62, 53, 253, 191, 193, 240, 104, 37, 204, 167, 249, 191, 64, 204, 211, 178, 250, 240, 245, 63, 127, 197, 120, 230, 33, 122, 228, 63, 120, 15, 201, 193, 68, 117, 252, 63, 185, 214, 91, 76, 157, 140, 225, 63, 27, 96, 198, 99, 127, 47, 255, 191, 172, 173, 147, 212, 64, 61, 233, 191, 239, 11, 4, 39, 174, 221, 218, 191, 76, 77, 64, 60, 46, 112, 4, 192, 148, 93, 12, 137, 173, 232, 1, 192, 179, 145, 152, 158, 14, 163, 6, 192, 94, 0, 241, 16, 63, 209, 1, 192, 238, 48, 88, 15, 57, 174, 194, 63, 103, 132, 88, 213, 245, 19, 213, 191, 73, 3, 236, 170, 219, 204, 4, 192, 110, 16, 144, 236, 179, 116, 5, 64, 157, 227, 35, 16, 210, 56, 2, 64, 187, 73, 210, 152, 54, 200, 3, 192, 67, 195, 146, 230, 194, 229, 241, 191, 207, 21, 138, 246, 251, 213, 254, 191, 75, 157, 109, 244, 247, 134, 189, 191, 250, 70, 230, 239, 229, 168, 245, 63, 109, 250, 114, 202, 191, 148, 248, 63, 217, 211, 20, 90, 193, 144, 241, 191, 138, 213, 175, 241, 72, 51, 2, 64, 218, 77, 7, 70, 55, 154, 4, 192, 224, 32, 250, 103, 150, 20, 241, 63, 156, 198, 36, 8, 124, 188, 213, 63, 38, 165, 67, 126, 227, 90, 194, 63, 132, 133, 153, 43, 45, 234, 217, 63, 246, 92, 28, 236, 81, 218, 2, 192, 143, 44, 181, 211, 112, 230, 228, 63, 232, 153, 44, 151, 210, 45, 209, 191, 223, 125, 155, 10, 235, 58, 231, 63, 177, 249, 11, 66, 98, 211, 8, 64, 160, 25, 119, 93, 15, 197, 0, 192, 60, 221, 226, 255, 164, 185, 254, 63, 145, 123, 69, 209, 249, 169, 249, 63, 170, 27, 195, 206, 4, 149, 0, 192, 116, 30, 118, 171, 244, 234, 0, 192, 134, 64, 74, 220, 92, 47, 246, 191, 168, 4, 124, 113, 64, 21, 245, 63, 90, 216, 159, 202, 228, 201, 243, 191, 22, 196, 63, 123, 24, 222, 220, 63, 42, 94, 174, 206, 87, 159, 240, 191, 86, 184, 125, 164, 138, 34, 247, 63, 39, 68, 128, 66, 182, 32, 253, 191, 151, 6, 191, 66, 224, 101, 232, 191, 240, 142, 30, 222, 124, 239, 242, 63, 7, 133, 139, 168, 111, 11, 239, 191, 228, 38, 136, 196, 233, 178, 218, 63, 232, 122, 77, 150, 55, 207, 249, 191, 247, 95, 72, 44, 150, 197, 254, 191, 156, 169, 235, 215, 89, 151, 194, 63, 30, 197, 101, 163, 74, 102, 5, 64, 27, 185, 241, 107, 184, 98, 0, 192, 20, 211, 183, 203, 29, 194, 235, 191, 225, 199, 134, 143, 210, 13, 9, 64, 244, 32, 190, 35, 93, 119, 245, 191, 201, 71, 174, 253, 240, 80, 221, 191, 162, 231, 31, 243, 208, 191, 237, 191, 225, 135, 83, 167, 36, 99, 200, 191, 143, 118, 198, 206, 253, 24, 255, 63, 136, 32, 111, 94, 61, 5, 209, 63, 213, 219, 193, 173, 204, 47, 236, 63, 158, 191, 19, 204, 137, 252, 206, 191, 159, 196, 205, 5, 23, 145, 239, 63, 249, 111, 151, 33, 98, 141, 101, 191, 78, 111, 8, 175, 134, 213, 8, 192, 77, 80, 226, 88, 87, 124, 228, 191, 76, 169, 105, 92, 133, 122, 209, 63, 52, 150, 88, 243, 133, 251, 2, 192, 107, 220, 108, 85, 98, 76, 240, 191, 67, 197, 217, 210, 96, 127, 4, 192, 100, 26, 81, 233, 231, 40, 226, 63, 12, 50, 244, 122, 7, 209, 6, 64, 251, 51, 236, 49, 11, 44, 221, 191, 158, 198, 161, 142, 104, 242, 4, 64, 113, 255, 196, 29, 123, 101, 244, 191, 100, 129, 197, 227, 68, 104, 7, 64, 252, 185, 122, 188, 65, 50, 225, 63, 120, 3, 106, 186, 228, 42, 234, 191, 228, 218, 185, 112, 89, 59, 6, 192, 80, 177, 157, 26, 83, 245, 251, 191, 113, 205, 24, 173, 22, 149, 216, 63, 33, 246, 144, 127, 5, 146, 115, 191, 65, 226, 188, 141, 175, 3, 0, 64, 106, 106, 102, 94, 79, 196, 3, 192, 47, 139, 147, 109, 59, 76, 6, 64, 91, 40, 129, 196, 44, 78, 255, 63, 117, 23, 9, 199, 118, 26, 221, 191, 146, 11, 238, 155, 255, 77, 242, 63, 78, 39, 242, 65, 254, 72, 4, 64, 31, 22, 254, 107, 119, 147, 235, 63, 6, 252, 49, 224, 215, 121, 5, 192, 22, 149, 116, 201, 153, 207, 225, 63, 228, 213, 183, 103, 134, 45, 0, 64, 7, 194, 165, 34, 141, 36, 5, 64, 254, 197, 205, 252, 232, 220, 213, 191, 232, 17, 196, 236, 145, 203, 2, 64, 6, 229, 127, 28, 198, 119, 234, 191, 148, 101, 76, 72, 59, 74, 228, 191, 21, 28, 97, 39, 14, 37, 5, 64, 218, 224, 252, 38, 122, 199, 188, 63, 64, 27, 183, 157, 9, 179, 246, 63, 217, 1, 116, 177, 54, 55, 242, 63, 138, 193, 31, 100, 97, 22, 201, 191, 4, 247, 49, 209, 94, 65, 242, 63, 94, 44, 173, 15, 142, 0, 228, 191, 100, 217, 71, 76, 57, 94, 215, 63, 148, 204, 13, 199, 0, 40, 210, 191, 55, 199, 111, 56, 73, 67, 252, 191, 64, 171, 109, 144, 120, 93, 227, 63, 197, 135, 211, 248, 0, 104, 5, 64, 214, 8, 30, 27, 177, 113, 241, 63, 88, 93, 141, 245, 253, 250, 175, 63, 106, 207, 126, 2, 117, 20, 222, 63, 62, 87, 251, 125, 178, 208, 244, 191, 160, 21, 82, 156, 33, 237, 251, 63, 252, 144, 189, 38, 162, 205, 225, 63, 159, 249, 197, 242, 135, 129, 244, 191, 246, 62, 165, 150, 142, 177, 226, 191, 228, 151, 192, 250, 120, 215, 246, 191, 58, 178, 97, 186, 153, 7, 9, 64, 190, 149, 47, 183, 27, 100, 248, 191, 161, 163, 43, 218, 228, 170, 248, 191, 202, 174, 185, 253, 37, 214, 4, 192, 26, 0, 161, 242, 99, 109, 226, 63, 89, 162, 50, 106, 142, 171, 7, 64, 201, 5, 116, 1, 180, 118, 3, 192, 4, 109, 46, 197, 36, 236, 3, 192, 7, 38, 166, 239, 120, 49, 3, 192, 106, 242, 206, 251, 11, 129, 3, 64, 247, 253, 165, 47, 102, 100, 196, 191, 247, 68, 128, 116, 222, 17, 137, 63, 11, 35, 109, 31, 87, 7, 2, 64, 148, 87, 183, 32, 248, 149, 243, 63, 146, 132, 183, 52, 107, 161, 7, 64, 1, 56, 221, 101, 129, 122, 231, 63, 199, 155, 17, 218, 21, 228, 8, 192, 72, 169, 185, 231, 143, 109, 242, 191, 177, 71, 34, 75, 70, 8, 238, 63, 182, 206, 61, 130, 14, 239, 250, 63, 190, 155, 20, 179, 55, 14, 229, 63, 214, 88, 201, 47, 28, 17, 217, 191, 94, 155, 103, 181, 220, 44, 2, 192, 213, 165, 217, 124, 54, 60, 189, 63, 195, 143, 251, 182, 65, 196, 5, 192, 98, 57, 200, 14, 146, 12, 0, 192, 50, 255, 250, 40, 200, 247, 0, 64, 228, 168, 247, 75, 148, 63, 199, 63, 240, 86, 83, 113, 33, 254, 228, 191, 92, 250, 114, 137, 119, 71, 7, 64, 66, 117, 6, 58, 216, 31, 4, 192, 208, 157, 144, 160, 156, 211, 1, 64, 14, 159, 29, 47, 116, 29, 9, 64, 188, 207, 173, 47, 35, 207, 243, 191, 0, 127, 22, 10, 217, 157, 181, 63, 217, 21, 13, 246, 204, 242, 237, 191, 162, 230, 169, 31, 144, 126, 240, 191, 45, 119, 183, 234, 11, 2, 236, 191, 184, 187, 8, 62, 4, 84, 6, 64, 205, 4, 112, 51, 141, 109, 226, 191, 232, 41, 208, 178, 182, 82, 209, 63, 206, 218, 150, 191, 85, 26, 236, 63, 21, 43, 237, 145, 51, 85, 224, 191, 225, 79, 48, 139, 225, 247, 1, 192, 219, 110, 36, 99, 41, 109, 3, 192, 1, 18, 81, 215, 80, 28, 219, 63, 74, 199, 149, 182, 19, 193, 2, 64, 4, 255, 111, 224, 70, 74, 3, 64, 226, 194, 165, 209, 198, 107, 244, 191, 242, 10, 143, 48, 97, 8, 0, 64, 176, 133, 76, 104, 14, 158, 203, 63, 130, 229, 220, 126, 139, 208, 250, 63, 115, 39, 181, 39, 246, 145, 246, 191, 38, 94, 145, 231, 228, 244, 243, 63, 131, 2, 14, 186, 52, 155, 181, 191}
};

unsigned char TabulatedValues::ucSearchGridInclinations[3][8*900] = {
    {0, 0, 0, 0, 0, 0, 0, 0, 72, 237, 75, 17, 95, 83, 234, 63, 134, 202, 195, 216, 107, 102, 6, 64, 126, 144, 231, 196, 81, 41, 251, 63, 8, 252, 14, 73, 215, 92, 246, 63, 16, 165, 34, 136, 43, 128, 2, 64, 205, 67, 103, 115, 168, 74, 244, 63, 175, 57, 37, 96, 24, 231, 218, 63, 3, 76, 98, 132, 61, 231, 248, 63, 237, 59, 224, 34, 137, 197, 3, 64, 52, 64, 82, 138, 81, 46, 4, 64, 8, 91, 201, 14, 160, 161, 6, 64, 40, 12, 101, 208, 184, 86, 239, 63, 157, 44, 178, 11, 74, 171, 4, 64, 29, 65, 63, 48, 101, 176, 251, 63, 116, 101, 23, 175, 86, 208, 4, 64, 215, 240, 249, 33, 155, 208, 240, 63, 133, 51, 198, 55, 193, 218, 248, 63, 211, 197, 123, 11, 123, 40, 241, 63, 24, 161, 151, 227, 50, 217, 247, 63, 10, 48, 136, 129, 77, 195, 227, 63, 64, 219, 180, 213, 85, 63, 244, 63, 108, 89, 32, 180, 90, 7, 248, 63, 211, 143, 234, 88, 191, 82, 237, 63, 91, 115, 123, 207, 172, 198, 2, 64, 24, 142, 169, 44, 99, 49, 245, 63, 40, 14, 32, 132, 99, 227, 244, 63, 138, 47, 250, 176, 138, 100, 245, 63, 60, 77, 232, 53, 209, 177, 240, 63, 23, 104, 188, 147, 63, 145, 245, 63, 25, 248, 65, 39, 129, 43, 4, 64, 219, 245, 28, 109, 101, 226, 241, 63, 56, 141, 107, 229, 112, 67, 243, 63, 179, 198, 15, 102, 216, 191, 4, 64, 208, 229, 50, 120, 100, 220, 206, 63, 196, 203, 103, 168, 116, 213, 236, 63, 138, 251, 2, 39, 211, 70, 248, 63, 119, 67, 46, 189, 158, 234, 227, 63, 203, 150, 78, 120, 252, 116, 4, 64, 41, 198, 132, 28, 26, 113, 243, 63, 184, 16, 96, 99, 247, 88, 252, 63, 156, 214, 223, 93, 60, 148, 0, 64, 191, 102, 132, 118, 104, 42, 2, 64, 139, 135, 193, 111, 249, 190, 251, 63, 84, 61, 234, 105, 168, 6, 0, 64, 70, 124, 236, 0, 228, 190, 235, 63, 169, 54, 181, 236, 153, 220, 252, 63, 149, 13, 185, 11, 12, 124, 236, 63, 99, 216, 223, 5, 172, 80, 2, 64, 238, 206, 159, 169, 45, 174, 250, 63, 93, 186, 40, 227, 137, 194, 241, 63, 203, 14, 52, 26, 217, 154, 246, 63, 182, 36, 82, 73, 82, 170, 237, 63, 125, 71, 227, 202, 121, 14, 8, 64, 96, 25, 245, 118, 227, 30, 229, 63, 211, 192, 144, 122, 149, 169, 245, 63, 36, 164, 65, 120, 198, 58, 1, 64, 209, 158, 86, 227, 249, 229, 253, 63, 123, 163, 134, 79, 204, 71, 251, 63, 132, 9, 254, 80, 187, 134, 243, 63, 34, 247, 183, 14, 111, 39, 3, 64, 243, 55, 103, 229, 30, 19, 248, 63, 184, 62, 217, 239, 11, 93, 0, 64, 86, 229, 196, 33, 52, 224, 217, 63, 201, 219, 59, 168, 214, 0, 241, 63, 26, 224, 252, 254, 203, 157, 4, 64, 81, 35, 102, 97, 43, 83, 253, 63, 40, 61, 48, 48, 98, 175, 247, 63, 70, 232, 222, 189, 110, 178, 244, 63, 212, 160, 197, 69, 20, 131, 1, 64, 156, 76, 56, 118, 209, 234, 2, 64, 247, 217, 251, 177, 17, 173, 7, 64, 10, 163, 37, 17, 238, 185, 251, 63, 196, 250, 180, 64, 57, 114, 249, 63, 234, 42, 148, 195, 186, 252, 5, 64, 35, 62, 139, 11, 68, 255, 231, 63, 74, 144, 159, 25, 105, 138, 6, 64, 59, 129, 237, 75, 0, 56, 250, 63, 12, 12, 54, 77, 139, 129, 4, 64, 75, 30, 37, 51, 0, 57, 255, 63, 244, 232, 197, 178, 215, 126, 7, 64, 88, 173, 217, 169, 175, 64, 205, 63, 95, 231, 108, 114, 247, 120, 247, 63, 205, 21, 254, 6, 44, 193, 5, 64, 249, 243, 134, 141, 24, 210, 249, 63, 162, 155, 206, 181, 27, 159, 1, 64, 156, 72, 49, 139, 61, 66, 1, 64, 168, 80, 3, 60, 91, 101, 241, 63, 1, 9, 171, 252, 162, 233, 235, 63, 127, 26, 33, 50, 166, 185, 244, 63, 184, 4, 49, 8, 120, 114, 235, 63, 187, 94, 134, 222, 2, 229, 2, 64, 164, 167, 104, 208, 253, 139, 228, 63, 223, 203, 50, 235, 135, 101, 251, 63, 255, 163, 191, 17, 206, 152, 254, 63, 63, 10, 248, 112, 86, 164, 245, 63, 156, 87, 89, 111, 11, 115, 1, 64, 104, 9, 69, 254, 71, 10, 245, 63, 30, 122, 198, 66, 102, 197, 227, 63, 94, 231, 148, 210, 65, 68, 248, 63, 200, 143, 149, 119, 172, 196, 229, 63, 168, 163, 43, 211, 8, 250, 234, 63, 56, 4, 84, 3, 148, 88, 207, 63, 149, 140, 210, 232, 52, 51, 250, 63, 62, 179, 116, 21, 1, 18, 6, 64, 51, 245, 46, 196, 64, 160, 250, 63, 165, 183, 60, 173, 221, 59, 247, 63, 95, 210, 247, 54, 101, 147, 228, 63, 50, 234, 220, 121, 206, 134, 1, 64, 9, 21, 208, 70, 227, 159, 236, 63, 167, 136, 42, 164, 11, 211, 252, 63, 12, 240, 99, 71, 183, 116, 4, 64, 19, 226, 39, 88, 113, 153, 2, 64, 56, 5, 20, 253, 45, 195, 254, 63, 159, 51, 200, 206, 119, 37, 8, 64, 247, 251, 216, 13, 235, 59, 2, 64, 159, 159, 35, 1, 247, 111, 251, 63, 18, 26, 31, 201, 255, 138, 2, 64, 26, 12, 254, 25, 117, 213, 4, 64, 156, 163, 32, 32, 104, 117, 243, 63, 232, 234, 224, 247, 82, 90, 0, 64, 222, 237, 54, 66, 193, 152, 250, 63, 250, 36, 52, 14, 79, 57, 1, 64, 102, 194, 67, 97, 139, 134, 253, 63, 226, 146, 175, 201, 157, 127, 241, 63, 154, 215, 100, 85, 140, 170, 224, 63, 92, 82, 50, 34, 136, 74, 0, 64, 4, 239, 35, 160, 52, 10, 1, 64, 17, 50, 12, 148, 225, 63, 240, 63, 96, 171, 252, 74, 17, 13, 242, 63, 196, 143, 200, 42, 168, 166, 242, 63, 35, 166, 182, 132, 157, 154, 250, 63, 54, 204, 215, 3, 69, 74, 1, 64, 142, 128, 59, 81, 207, 67, 241, 63, 95, 51, 193, 206, 189, 212, 254, 63, 39, 42, 149, 169, 183, 177, 251, 63, 164, 130, 242, 162, 177, 12, 3, 64, 19, 66, 192, 85, 197, 197, 241, 63, 3, 228, 169, 13, 143, 36, 223, 63, 70, 135, 202, 57, 71, 26, 240, 63, 86, 239, 62, 122, 77, 64, 235, 63, 20, 56, 177, 98, 118, 32, 1, 64, 179, 36, 95, 123, 36, 98, 253, 63, 98, 149, 174, 70, 250, 115, 247, 63, 160, 50, 209, 85, 196, 87, 244, 63, 178, 175, 0, 144, 66, 107, 254, 63, 195, 24, 2, 161, 208, 201, 247, 63, 246, 236, 215, 190, 227, 218, 2, 64, 56, 46, 16, 61, 116, 205, 2, 64, 41, 46, 179, 135, 230, 46, 242, 63, 150, 96, 145, 135, 34, 188, 254, 63, 218, 78, 243, 144, 69, 109, 228, 63, 71, 17, 215, 198, 176, 175, 254, 63, 208, 233, 229, 140, 154, 228, 251, 63, 176, 185, 178, 174, 68, 68, 254, 63, 57, 16, 29, 23, 139, 209, 248, 63, 34, 197, 54, 152, 129, 105, 208, 63, 32, 17, 167, 235, 144, 133, 255, 63, 199, 10, 241, 65, 76, 19, 248, 63, 61, 45, 171, 11, 73, 94, 239, 63, 33, 171, 147, 45, 40, 126, 254, 63, 16, 78, 243, 105, 219, 97, 255, 63, 250, 101, 124, 134, 149, 23, 4, 64, 68, 11, 143, 130, 20, 196, 0, 64, 113, 248, 238, 41, 66, 247, 234, 63, 172, 193, 227, 246, 127, 13, 230, 63, 211, 80, 140, 61, 145, 182, 255, 63, 89, 45, 86, 102, 5, 116, 236, 63, 241, 198, 117, 116, 132, 242, 250, 63, 143, 228, 223, 99, 232, 86, 222, 63, 62, 66, 194, 189, 157, 36, 246, 63, 103, 95, 214, 58, 148, 227, 5, 64, 84, 93, 103, 136, 209, 16, 247, 63, 83, 230, 209, 126, 100, 247, 246, 63, 32, 159, 219, 227, 189, 239, 4, 64, 185, 118, 70, 166, 121, 121, 228, 63, 90, 19, 76, 39, 83, 34, 248, 63, 60, 68, 127, 234, 147, 10, 248, 63, 32, 105, 21, 108, 45, 18, 231, 63, 4, 241, 26, 247, 183, 205, 239, 63, 9, 122, 50, 68, 97, 166, 244, 63, 242, 44, 23, 98, 83, 8, 250, 63, 140, 90, 206, 114, 160, 130, 255, 63, 211, 31, 221, 214, 230, 216, 3, 64, 51, 213, 60, 147, 57, 135, 235, 63, 180, 195, 233, 158, 62, 26, 247, 63, 224, 129, 53, 125, 194, 175, 254, 63, 220, 32, 245, 3, 50, 194, 244, 63, 140, 77, 149, 227, 19, 235, 0, 64, 160, 113, 105, 248, 90, 138, 0, 64, 192, 254, 134, 149, 95, 203, 5, 64, 26, 109, 20, 162, 197, 53, 252, 63, 112, 125, 90, 136, 147, 32, 241, 63, 250, 207, 43, 173, 57, 228, 217, 63, 9, 193, 107, 175, 27, 49, 1, 64, 107, 11, 225, 210, 61, 227, 220, 63, 146, 222, 168, 142, 58, 134, 222, 63, 59, 162, 194, 122, 150, 209, 253, 63, 83, 66, 53, 191, 215, 187, 0, 64, 114, 247, 251, 125, 79, 175, 2, 64, 167, 71, 190, 1, 133, 35, 244, 63, 154, 67, 27, 117, 20, 134, 231, 63, 224, 28, 16, 184, 87, 121, 232, 63, 212, 29, 190, 196, 45, 49, 229, 63, 202, 194, 41, 100, 11, 23, 2, 64, 43, 153, 107, 204, 107, 65, 253, 63, 227, 131, 171, 166, 157, 36, 255, 63, 211, 203, 13, 200, 163, 161, 6, 64, 155, 207, 121, 108, 64, 130, 252, 63, 112, 117, 105, 213, 212, 217, 235, 63, 96, 45, 137, 148, 128, 85, 228, 63, 224, 107, 252, 167, 75, 181, 219, 63, 47, 183, 155, 233, 219, 210, 234, 63, 32, 176, 85, 253, 249, 248, 240, 63, 116, 239, 255, 138, 85, 86, 255, 63, 106, 116, 247, 69, 175, 9, 244, 63, 195, 200, 3, 156, 8, 73, 241, 63, 203, 150, 31, 33, 155, 133, 246, 63, 153, 32, 238, 195, 157, 182, 228, 63, 250, 44, 198, 98, 255, 37, 249, 63, 9, 15, 141, 143, 28, 248, 253, 63, 231, 220, 251, 156, 205, 222, 0, 64, 136, 161, 29, 180, 146, 7, 249, 63, 132, 218, 34, 208, 77, 90, 243, 63, 84, 229, 194, 87, 137, 4, 1, 64, 152, 155, 28, 23, 8, 195, 234, 63, 14, 122, 223, 213, 2, 194, 0, 64, 53, 63, 199, 67, 151, 27, 251, 63, 237, 55, 19, 147, 241, 119, 231, 63, 159, 99, 43, 182, 2, 136, 3, 64, 38, 165, 107, 148, 235, 77, 0, 64, 42, 204, 47, 23, 246, 153, 243, 63, 105, 70, 90, 157, 153, 152, 250, 63, 188, 51, 219, 239, 16, 62, 244, 63, 50, 188, 37, 75, 10, 40, 3, 64, 162, 150, 138, 186, 238, 174, 246, 63, 197, 15, 33, 91, 200, 45, 221, 63, 110, 189, 117, 52, 22, 133, 205, 63, 52, 77, 160, 50, 8, 227, 242, 63, 124, 210, 254, 140, 79, 30, 2, 64, 234, 246, 155, 194, 15, 14, 241, 63, 183, 184, 62, 159, 139, 30, 251, 63, 139, 206, 85, 143, 117, 3, 244, 63, 140, 25, 102, 57, 187, 163, 1, 64, 140, 26, 178, 18, 162, 175, 219, 63, 148, 98, 99, 118, 92, 61, 3, 64, 235, 56, 83, 33, 79, 143, 219, 63, 252, 232, 3, 207, 26, 12, 6, 64, 192, 82, 231, 132, 187, 10, 3, 64, 237, 14, 97, 230, 103, 44, 253, 63, 212, 141, 141, 101, 246, 66, 247, 63, 245, 90, 113, 147, 236, 146, 4, 64, 161, 174, 46, 112, 208, 228, 240, 63, 92, 123, 29, 62, 244, 208, 238, 63, 37, 93, 56, 233, 171, 145, 205, 63, 246, 186, 207, 251, 62, 155, 249, 63},
    {0, 0, 0, 0, 0, 0, 0, 0, 122, 33, 53, 246, 121, 8, 241, 63, 59, 167, 66, 86, 228, 99, 238, 63, 3, 84, 56, 117, 116, 54, 6, 64, 182, 34, 158, 176, 31, 230, 248, 63, 78, 167, 254, 158, 198, 193, 221, 63, 28, 137, 159, 127, 7, 205, 252, 63, 156, 44, 173, 190, 148, 42, 246, 63, 107, 196, 145, 63, 197, 190, 0, 64, 80, 116, 24, 124, 150, 16, 236, 63, 138, 174, 73, 179, 114, 100, 233, 63, 202, 230, 12, 192, 55, 170, 244, 63, 206, 12, 198, 252, 197, 132, 227, 63, 150, 19, 3, 120, 26, 83, 5, 64, 1, 246, 161, 184, 131, 100, 214, 63, 34, 91, 1, 225, 198, 175, 3, 64, 217, 157, 165, 56, 27, 111, 224, 63, 53, 47, 163, 227, 60, 249, 210, 63, 220, 55, 56, 50, 88, 8, 0, 64, 169, 122, 89, 180, 193, 157, 247, 63, 126, 142, 176, 244, 210, 198, 254, 63, 25, 1, 202, 60, 181, 219, 255, 63, 141, 28, 163, 3, 19, 174, 250, 63, 54, 213, 205, 105, 166, 149, 0, 64, 228, 131, 155, 193, 121, 76, 241, 63, 4, 116, 38, 215, 19, 53, 234, 63, 242, 173, 187, 234, 255, 80, 1, 64, 106, 140, 244, 200, 71, 114, 198, 63, 202, 25, 135, 221, 165, 129, 0, 64, 24, 142, 58, 141, 144, 222, 222, 63, 216, 116, 219, 255, 159, 77, 237, 63, 231, 29, 206, 224, 151, 195, 251, 63, 196, 119, 173, 53, 160, 56, 236, 63, 60, 130, 59, 143, 164, 53, 0, 64, 25, 197, 188, 206, 139, 156, 254, 63, 196, 87, 138, 160, 217, 118, 243, 63, 21, 85, 179, 128, 60, 97, 244, 63, 29, 87, 58, 5, 92, 209, 241, 63, 59, 10, 228, 5, 113, 161, 245, 63, 232, 218, 106, 209, 173, 242, 1, 64, 215, 50, 191, 98, 234, 0, 253, 63, 56, 75, 55, 211, 25, 35, 247, 63, 159, 189, 166, 247, 163, 120, 239, 63, 50, 72, 127, 20, 128, 143, 0, 64, 90, 126, 131, 241, 170, 153, 7, 64, 226, 202, 90, 157, 152, 102, 250, 63, 93, 54, 108, 96, 229, 187, 244, 63, 249, 199, 209, 190, 93, 89, 249, 63, 246, 163, 46, 194, 58, 65, 247, 63, 92, 8, 126, 73, 51, 159, 2, 64, 95, 147, 33, 10, 82, 85, 225, 63, 19, 243, 71, 249, 106, 150, 242, 63, 172, 27, 219, 18, 180, 0, 4, 64, 211, 170, 163, 192, 41, 197, 7, 64, 132, 183, 133, 129, 9, 10, 238, 63, 124, 157, 15, 142, 146, 45, 243, 63, 35, 248, 129, 59, 231, 138, 238, 63, 147, 28, 85, 142, 27, 236, 213, 63, 146, 240, 223, 109, 217, 64, 227, 63, 148, 96, 113, 15, 137, 76, 2, 64, 42, 156, 244, 144, 48, 136, 0, 64, 12, 243, 54, 103, 154, 166, 246, 63, 63, 74, 131, 253, 31, 67, 4, 64, 56, 106, 138, 191, 218, 213, 244, 63, 247, 167, 168, 137, 188, 203, 253, 63, 193, 127, 145, 240, 88, 207, 248, 63, 218, 206, 7, 192, 12, 40, 238, 63, 169, 205, 178, 42, 204, 19, 5, 64, 253, 90, 50, 52, 181, 228, 251, 63, 28, 97, 142, 192, 237, 31, 6, 64, 190, 32, 82, 115, 234, 66, 241, 63, 215, 155, 160, 129, 72, 227, 245, 63, 244, 128, 109, 98, 206, 206, 243, 63, 182, 51, 50, 231, 194, 214, 7, 64, 49, 105, 13, 193, 111, 219, 229, 63, 221, 90, 133, 53, 90, 60, 240, 63, 75, 128, 157, 124, 169, 175, 228, 63, 47, 90, 190, 238, 207, 64, 246, 63, 194, 157, 5, 139, 169, 213, 6, 64, 40, 68, 236, 14, 9, 148, 234, 63, 160, 223, 183, 138, 254, 159, 251, 63, 208, 156, 88, 72, 9, 57, 4, 64, 47, 211, 221, 208, 160, 131, 241, 63, 20, 15, 139, 133, 65, 176, 255, 63, 16, 36, 143, 90, 125, 128, 246, 63, 224, 186, 11, 156, 22, 62, 246, 63, 123, 223, 178, 81, 186, 224, 241, 63, 72, 220, 199, 160, 167, 108, 240, 63, 229, 2, 103, 224, 59, 142, 246, 63, 182, 161, 74, 68, 227, 109, 244, 63, 113, 17, 220, 16, 30, 158, 232, 63, 220, 5, 92, 190, 52, 218, 240, 63, 63, 195, 148, 2, 47, 119, 241, 63, 160, 163, 202, 178, 159, 185, 0, 64, 153, 193, 201, 136, 160, 203, 1, 64, 215, 146, 165, 141, 122, 185, 2, 64, 193, 174, 99, 153, 59, 69, 211, 63, 74, 147, 186, 177, 230, 45, 247, 63, 231, 118, 109, 74, 134, 18, 252, 63, 205, 62, 124, 12, 97, 6, 3, 64, 208, 20, 201, 57, 121, 23, 241, 63, 233, 74, 203, 32, 107, 45, 4, 64, 62, 33, 195, 105, 255, 128, 3, 64, 99, 20, 68, 155, 106, 114, 248, 63, 27, 212, 238, 93, 236, 16, 252, 63, 49, 237, 186, 11, 92, 188, 250, 63, 130, 238, 37, 203, 78, 140, 2, 64, 45, 103, 64, 80, 183, 224, 1, 64, 53, 53, 230, 179, 62, 90, 6, 64, 250, 113, 116, 24, 135, 242, 240, 63, 206, 117, 162, 23, 229, 49, 254, 63, 150, 240, 67, 209, 115, 124, 234, 63, 246, 110, 9, 142, 162, 169, 0, 64, 193, 178, 130, 230, 4, 7, 243, 63, 10, 169, 166, 243, 78, 142, 254, 63, 202, 186, 34, 61, 73, 94, 5, 64, 161, 188, 181, 36, 238, 90, 252, 63, 6, 172, 65, 53, 140, 124, 254, 63, 114, 116, 78, 73, 10, 249, 2, 64, 221, 175, 12, 101, 87, 125, 5, 64, 230, 159, 31, 66, 42, 236, 255, 63, 137, 99, 28, 209, 100, 196, 232, 63, 180, 34, 13, 42, 96, 131, 6, 64, 152, 176, 36, 40, 203, 20, 250, 63, 20, 47, 208, 88, 167, 129, 246, 63, 174, 201, 16, 174, 77, 11, 228, 63, 146, 207, 40, 120, 49, 32, 3, 64, 174, 84, 251, 188, 39, 164, 241, 63, 250, 14, 140, 120, 190, 172, 6, 64, 173, 103, 225, 205, 170, 112, 4, 64, 93, 96, 73, 84, 28, 246, 3, 64, 217, 207, 6, 212, 66, 42, 4, 64, 159, 168, 177, 119, 158, 94, 5, 64, 253, 104, 36, 177, 221, 182, 2, 64, 26, 127, 240, 143, 92, 246, 250, 63, 142, 248, 52, 232, 169, 95, 1, 64, 81, 15, 148, 138, 117, 153, 230, 63, 131, 231, 119, 190, 54, 143, 0, 64, 28, 61, 119, 71, 248, 212, 2, 64, 46, 255, 67, 88, 154, 179, 244, 63, 28, 57, 233, 103, 33, 41, 247, 63, 190, 189, 255, 51, 140, 39, 245, 63, 165, 130, 223, 143, 237, 105, 232, 63, 190, 170, 49, 87, 17, 49, 238, 63, 188, 238, 214, 11, 140, 115, 241, 63, 51, 148, 32, 81, 197, 112, 6, 64, 161, 50, 216, 184, 150, 0, 250, 63, 153, 190, 39, 170, 255, 145, 244, 63, 22, 168, 62, 1, 61, 221, 226, 63, 154, 169, 192, 254, 253, 205, 246, 63, 194, 192, 57, 35, 201, 161, 246, 63, 229, 113, 213, 193, 101, 61, 243, 63, 172, 137, 139, 224, 225, 0, 240, 63, 129, 87, 203, 89, 77, 164, 248, 63, 175, 206, 212, 140, 200, 213, 248, 63, 177, 235, 83, 66, 180, 160, 254, 63, 81, 201, 221, 8, 119, 153, 221, 63, 142, 28, 29, 172, 169, 94, 1, 64, 174, 0, 98, 123, 79, 149, 211, 63, 164, 239, 223, 157, 164, 215, 7, 64, 132, 206, 182, 245, 96, 66, 4, 64, 74, 10, 71, 192, 52, 46, 1, 64, 94, 164, 100, 181, 138, 65, 5, 64, 61, 107, 116, 182, 216, 209, 253, 63, 4, 47, 79, 169, 239, 159, 236, 63, 206, 157, 35, 67, 134, 175, 255, 63, 100, 155, 111, 71, 230, 178, 0, 64, 214, 57, 20, 95, 231, 38, 240, 63, 20, 143, 138, 35, 188, 214, 244, 63, 150, 54, 63, 168, 254, 112, 249, 63, 142, 242, 106, 232, 97, 161, 0, 64, 166, 34, 26, 29, 255, 159, 248, 63, 50, 129, 38, 136, 122, 153, 214, 63, 133, 234, 69, 17, 16, 245, 246, 63, 203, 45, 102, 252, 97, 10, 255, 63, 123, 222, 144, 67, 19, 16, 251, 63, 13, 36, 63, 101, 43, 183, 6, 64, 208, 204, 1, 176, 186, 232, 246, 63, 26, 58, 249, 51, 9, 34, 251, 63, 60, 121, 206, 98, 240, 228, 237, 63, 127, 7, 38, 145, 124, 44, 234, 63, 105, 16, 9, 134, 130, 119, 254, 63, 55, 236, 241, 106, 101, 139, 253, 63, 56, 230, 142, 150, 218, 206, 6, 64, 218, 34, 209, 1, 114, 120, 254, 63, 159, 193, 246, 84, 121, 150, 249, 63, 83, 49, 244, 157, 144, 156, 241, 63, 232, 239, 194, 87, 19, 199, 1, 64, 95, 85, 43, 57, 26, 57, 251, 63, 19, 31, 248, 199, 61, 151, 5, 64, 57, 254, 199, 167, 95, 122, 252, 63, 156, 142, 41, 10, 117, 238, 3, 64, 110, 17, 86, 139, 251, 54, 242, 63, 94, 147, 100, 6, 74, 177, 220, 63, 180, 235, 248, 221, 128, 208, 244, 63, 177, 197, 84, 105, 95, 238, 248, 63, 7, 164, 53, 60, 3, 225, 250, 63, 247, 38, 155, 81, 6, 147, 251, 63, 10, 156, 251, 31, 112, 252, 2, 64, 131, 188, 192, 35, 162, 24, 5, 64, 101, 144, 23, 47, 216, 119, 5, 64, 70, 196, 7, 205, 97, 10, 5, 64, 38, 71, 104, 68, 143, 226, 230, 63, 243, 155, 112, 86, 73, 238, 241, 63, 55, 7, 36, 198, 180, 12, 2, 64, 36, 241, 241, 81, 208, 78, 247, 63, 187, 103, 89, 102, 222, 195, 247, 63, 49, 177, 85, 108, 94, 216, 2, 64, 107, 109, 18, 149, 117, 141, 1, 64, 34, 109, 134, 190, 221, 57, 253, 63, 29, 157, 48, 209, 36, 132, 245, 63, 8, 254, 0, 150, 99, 0, 9, 64, 91, 205, 219, 173, 79, 169, 239, 63, 201, 36, 120, 85, 106, 101, 253, 63, 83, 193, 251, 177, 245, 35, 253, 63, 161, 103, 117, 188, 230, 35, 222, 63, 253, 85, 156, 138, 53, 164, 1, 64, 229, 119, 149, 201, 197, 235, 228, 63, 31, 60, 120, 214, 193, 113, 6, 64, 176, 155, 3, 53, 182, 22, 255, 63, 8, 231, 107, 143, 193, 44, 252, 63, 212, 1, 253, 157, 28, 244, 241, 63, 118, 37, 179, 113, 7, 90, 232, 63, 126, 232, 43, 83, 246, 154, 243, 63, 6, 104, 23, 222, 124, 51, 3, 64, 46, 156, 117, 59, 251, 50, 245, 63, 200, 155, 23, 94, 56, 244, 232, 63, 63, 66, 218, 57, 208, 184, 246, 63, 169, 202, 237, 249, 216, 138, 5, 64, 211, 144, 20, 230, 82, 145, 239, 63, 140, 80, 105, 208, 105, 113, 1, 64, 82, 119, 141, 188, 60, 107, 0, 64, 189, 10, 51, 43, 128, 62, 254, 63, 207, 92, 107, 156, 248, 111, 236, 63, 106, 197, 124, 94, 1, 77, 249, 63, 136, 251, 93, 150, 94, 57, 198, 63, 22, 205, 177, 89, 157, 245, 220, 63, 50, 10, 224, 17, 141, 191, 237, 63, 240, 108, 41, 233, 46, 230, 252, 63, 219, 240, 72, 249, 129, 53, 252, 63, 212, 69, 212, 180, 109, 127, 222, 63, 230, 149, 159, 46, 29, 213, 4, 64, 54, 39, 238, 178, 214, 43, 4, 64, 100, 227, 55, 229, 118, 239, 241, 63, 226, 109, 203, 78, 136, 245, 210, 63, 61, 99, 143, 151, 210, 159, 3, 64, 193, 209, 88, 208, 47, 122, 236, 63, 28, 24, 117, 247, 187, 16, 254, 63, 130, 1, 118, 223, 242, 202, 2, 64, 229, 68, 107, 168, 214, 138, 254, 63, 203, 162, 80, 224, 52, 147, 248, 63, 58, 95, 223, 225, 243, 238, 249, 63, 111, 57, 161, 121, 167, 62, 249, 63, 129, 92, 127, 250, 111, 211, 249, 63, 56, 198, 150, 252, 28, 148, 228, 63, 230, 237, 177, 226, 237, 121, 0, 64, 54, 44, 189, 214, 191, 210, 2, 64, 140, 102, 198, 212, 8, 246, 238, 63, 24, 89, 121, 222, 76, 92, 247, 63, 173, 87, 210, 29, 90, 201, 6, 64, 46, 100, 183, 16, 100, 23, 242, 63, 114, 228, 45, 78, 47, 56, 1, 64, 2, 183, 64, 161, 176, 7, 244, 63, 111, 4, 155, 226, 151, 49, 233, 63, 52, 73, 28, 113, 233, 4, 232, 63, 136, 134, 110, 125, 238, 195, 246, 63, 227, 110, 47, 192, 147, 152, 236, 63, 126, 93, 185, 149, 71, 128, 221, 63, 140, 201, 122, 6, 14, 60, 239, 63, 70, 73, 168, 4, 35, 56, 2, 64, 144, 140, 10, 141, 142, 66, 214, 63, 118, 111, 199, 85, 216, 243, 226, 63, 169, 113, 189, 118, 186, 81, 248, 63, 24, 34, 189, 45, 206, 212, 4, 64, 30, 22, 50, 124, 157, 54, 237, 63, 103, 56, 62, 202, 67, 46, 244, 63, 116, 25, 247, 58, 35, 241, 3, 64, 63, 215, 105, 75, 162, 90, 4, 64, 220, 203, 29, 148, 58, 206, 197, 63, 33, 225, 2, 116, 239, 15, 3, 64, 144, 174, 208, 178, 255, 26, 254, 63, 6, 230, 21, 226, 4, 69, 253, 63, 77, 65, 136, 228, 130, 170, 1, 64, 74, 95, 160, 201, 192, 95, 0, 64, 11, 225, 129, 127, 191, 192, 251, 63, 82, 174, 118, 224, 130, 227, 1, 64, 92, 27, 230, 94, 108, 130, 228, 63, 140, 225, 38, 207, 212, 135, 241, 63, 135, 52, 206, 255, 9, 23, 243, 63, 200, 10, 63, 125, 101, 224, 243, 63, 92, 194, 41, 147, 178, 124, 249, 63, 133, 126, 21, 56, 43, 44, 250, 63, 142, 117, 20, 91, 5, 198, 1, 64, 238, 139, 70, 96, 33, 75, 1, 64, 142, 192, 91, 252, 84, 38, 214, 63, 34, 87, 26, 219, 150, 54, 4, 64, 79, 85, 48, 91, 187, 23, 238, 63, 92, 36, 142, 67, 202, 216, 247, 63, 126, 127, 83, 91, 253, 132, 5, 64, 194, 19, 254, 48, 200, 232, 220, 63, 183, 198, 149, 198, 245, 249, 248, 63, 240, 88, 95, 7, 208, 31, 252, 63, 182, 225, 111, 50, 217, 87, 228, 63, 74, 4, 163, 43, 178, 236, 245, 63, 197, 8, 102, 24, 36, 55, 4, 64, 168, 19, 79, 50, 99, 247, 0, 64, 161, 71, 222, 108, 61, 54, 2, 64, 174, 49, 30, 201, 200, 101, 0, 64, 50, 224, 116, 188, 114, 223, 2, 64, 0, 80, 86, 35, 24, 14, 246, 63, 123, 174, 76, 32, 86, 45, 254, 63, 26, 156, 190, 61, 128, 85, 225, 63, 126, 107, 101, 174, 135, 14, 4, 64, 118, 183, 216, 88, 64, 162, 242, 63, 9, 3, 126, 251, 47, 166, 4, 64, 169, 107, 240, 166, 199, 66, 251, 63, 239, 123, 132, 13, 2, 212, 255, 63, 187, 147, 71, 31, 91, 94, 254, 63, 80, 232, 248, 159, 249, 145, 240, 63, 154, 64, 97, 94, 137, 205, 243, 63, 143, 168, 42, 111, 10, 136, 249, 63, 107, 72, 164, 184, 254, 140, 254, 63, 115, 251, 206, 101, 117, 154, 2, 64, 202, 105, 223, 92, 248, 41, 233, 63, 80, 148, 114, 142, 3, 95, 246, 63, 94, 241, 224, 94, 114, 134, 0, 64, 80, 95, 28, 51, 194, 7, 0, 64, 146, 3, 39, 63, 5, 87, 244, 63, 169, 177, 69, 174, 183, 134, 5, 64, 80, 248, 0, 55, 110, 85, 248, 63, 116, 84, 236, 63, 83, 193, 1, 64, 253, 117, 114, 159, 108, 226, 1, 64, 25, 207, 212, 45, 218, 159, 243, 63, 115, 101, 33, 52, 61, 70, 252, 63, 25, 103, 35, 33, 104, 210, 253, 63, 183, 116, 2, 233, 136, 177, 214, 63, 125, 66, 239, 200, 100, 109, 254, 63, 233, 236, 85, 180, 173, 118, 251, 63, 167, 207, 157, 248, 57, 117, 250, 63, 114, 112, 156, 114, 231, 52, 240, 63, 13, 192, 199, 76, 0, 107, 252, 63, 240, 161, 91, 46, 84, 236, 227, 63, 232, 19, 144, 159, 92, 55, 0, 64, 225, 127, 125, 52, 254, 91, 232, 63, 116, 222, 163, 212, 70, 50, 1, 64, 4, 209, 142, 108, 52, 223, 249, 63, 174, 139, 160, 121, 96, 140, 231, 63, 123, 184, 29, 66, 45, 236, 232, 63, 69, 29, 148, 163, 108, 222, 240, 63, 145, 254, 237, 183, 46, 99, 228, 63, 58, 221, 82, 221, 246, 211, 254, 63, 61, 119, 133, 127, 246, 173, 248, 63, 58, 110, 203, 188, 254, 75, 240, 63, 123, 122, 187, 212, 201, 99, 253, 63, 109, 104, 216, 1, 92, 12, 242, 63, 124, 179, 135, 11, 162, 94, 2, 64, 190, 216, 151, 90, 109, 145, 5, 64, 254, 146, 101, 18, 224, 130, 253, 63, 134, 69, 176, 147, 207, 212, 248, 63, 229, 93, 85, 249, 142, 71, 245, 63, 227, 233, 32, 224, 130, 156, 242, 63, 180, 250, 66, 56, 188, 82, 0, 64, 155, 44, 232, 134, 206, 248, 224, 63, 130, 11, 89, 233, 98, 158, 0, 64, 52, 81, 196, 134, 20, 246, 249, 63, 173, 213, 26, 184, 122, 105, 0, 64, 238, 147, 57, 98, 34, 23, 3, 64, 131, 28, 192, 93, 39, 227, 243, 63, 79, 242, 186, 111, 98, 98, 198, 63, 75, 111, 101, 225, 138, 7, 254, 63, 247, 235, 199, 195, 55, 30, 5, 64, 131, 152, 231, 175, 35, 85, 238, 63, 210, 68, 180, 95, 44, 104, 230, 63, 236, 192, 86, 173, 172, 45, 222, 63, 246, 200, 10, 74, 1, 142, 241, 63, 152, 231, 192, 46, 19, 89, 248, 63, 158, 42, 85, 200, 61, 92, 1, 64, 166, 35, 180, 85, 59, 190, 252, 63, 18, 111, 29, 156, 12, 145, 228, 63, 175, 110, 27, 108, 213, 198, 7, 64, 198, 21, 101, 176, 2, 65, 1, 64, 162, 121, 223, 153, 21, 113, 198, 63, 112, 93, 66, 159, 25, 20, 221, 63, 194, 25, 15, 7, 71, 72, 237, 63, 99, 123, 180, 9, 64, 168, 245, 63, 52, 92, 209, 92, 175, 74, 245, 63, 12, 226, 9, 252, 205, 188, 1, 64, 114, 91, 171, 137, 26, 69, 4, 64, 206, 105, 200, 171, 58, 26, 244, 63, 219, 2, 36, 49, 55, 203, 247, 63, 153, 48, 191, 106, 33, 192, 251, 63, 205, 59, 124, 119, 16, 151, 239, 63, 2, 250, 144, 185, 100, 58, 247, 63, 210, 177, 93, 217, 97, 168, 247, 63, 178, 73, 3, 14, 181, 190, 3, 64, 112, 33, 58, 1, 89, 178, 249, 63, 154, 35, 39, 102, 175, 64, 3, 64, 79, 157, 215, 110, 4, 127, 254, 63, 16, 86, 157, 12, 73, 133, 231, 63, 123, 48, 228, 23, 113, 165, 255, 63, 163, 187, 21, 235, 78, 204, 233, 63, 228, 42, 35, 99, 57, 135, 249, 63, 87, 95, 213, 155, 13, 175, 1, 64, 36, 220, 73, 26, 76, 148, 244, 63, 110, 248, 42, 50, 71, 211, 229, 63, 77, 11, 136, 75, 40, 143, 232, 63, 215, 97, 249, 151, 3, 153, 2, 64, 168, 82, 202, 49, 147, 169, 227, 63, 26, 250, 122, 75, 142, 47, 0, 64, 61, 144, 152, 28, 203, 110, 249, 63, 219, 72, 255, 182, 139, 113, 6, 64, 101, 145, 143, 200, 225, 120, 242, 63, 123, 206, 20, 234, 75, 13, 242, 63, 190, 81, 42, 151, 211, 54, 246, 63, 216, 51, 81, 228, 152, 248, 210, 63, 31, 128, 71, 236, 121, 1, 241, 63, 241, 34, 153, 228, 138, 35, 221, 63, 66, 194, 132, 73, 202, 150, 234, 63, 130, 38, 1, 132, 59, 155, 7, 64, 178, 216, 162, 19, 153, 232, 242, 63, 134, 78, 177, 12, 37, 106, 247, 63, 174, 77, 177, 212, 99, 160, 242, 63, 4, 0, 167, 37, 124, 233, 251, 63, 249, 244, 79, 74, 155, 26, 243, 63, 20, 218, 91, 218, 37, 37, 231, 63, 201, 140, 9, 84, 117, 208, 243, 63, 124, 16, 187, 186, 106, 165, 253, 63, 202, 235, 99, 143, 87, 178, 2, 64, 206, 64, 164, 35, 207, 53, 251, 63, 245, 2, 92, 201, 83, 225, 251, 63, 190, 41, 123, 46, 16, 22, 246, 63, 66, 230, 226, 59, 7, 226, 1, 64, 205, 176, 176, 141, 100, 121, 1, 64, 52, 180, 209, 231, 30, 185, 1, 64, 222, 64, 246, 143, 131, 106, 250, 63, 82, 43, 35, 56, 12, 208, 224, 63, 117, 56, 112, 102, 215, 160, 241, 63, 201, 32, 24, 104, 165, 91, 249, 63, 197, 44, 103, 47, 165, 210, 247, 63, 229, 211, 159, 26, 190, 41, 252, 63, 221, 205, 28, 57, 206, 204, 245, 63, 149, 30, 120, 214, 236, 8, 238, 63, 12, 187, 47, 8, 240, 150, 250, 63, 196, 7, 144, 232, 201, 91, 224, 63, 118, 189, 218, 85, 102, 160, 243, 63, 89, 81, 101, 158, 176, 102, 248, 63, 82, 201, 110, 169, 88, 225, 243, 63, 137, 131, 242, 200, 114, 76, 234, 63, 38, 59, 27, 12, 157, 6, 244, 63, 233, 41, 210, 121, 212, 29, 198, 63, 21, 172, 11, 217, 253, 203, 254, 63, 49, 193, 243, 108, 32, 245, 243, 63, 81, 26, 201, 171, 126, 64, 246, 63, 2, 186, 124, 164, 178, 220, 239, 63, 32, 54, 111, 232, 102, 111, 3, 64, 199, 0, 22, 19, 186, 23, 251, 63, 102, 171, 202, 48, 69, 131, 251, 63, 52, 110, 205, 61, 247, 214, 227, 63, 228, 228, 215, 42, 141, 100, 0, 64, 154, 27, 221, 71, 210, 80, 0, 64, 198, 187, 19, 6, 203, 146, 2, 64, 211, 102, 236, 151, 204, 230, 211, 63, 234, 71, 6, 10, 89, 50, 228, 63, 69, 42, 182, 5, 217, 240, 245, 63, 84, 129, 172, 58, 24, 94, 244, 63, 146, 165, 65, 37, 91, 210, 234, 63, 59, 175, 150, 28, 27, 143, 255, 63, 215, 162, 107, 147, 179, 82, 254, 63, 212, 11, 127, 166, 163, 225, 0, 64, 161, 207, 69, 175, 33, 246, 255, 63, 152, 4, 250, 138, 167, 185, 248, 63, 169, 99, 156, 178, 238, 45, 234, 63, 157, 99, 248, 97, 217, 155, 233, 63, 242, 31, 38, 14, 189, 55, 227, 63, 76, 144, 158, 103, 112, 170, 3, 64, 139, 40, 237, 132, 146, 242, 250, 63, 80, 208, 31, 62, 210, 14, 252, 63, 129, 170, 191, 195, 101, 247, 237, 63, 214, 189, 147, 129, 201, 164, 235, 63, 113, 54, 184, 22, 214, 121, 1, 64, 64, 46, 232, 217, 80, 87, 0, 64, 182, 104, 246, 47, 2, 223, 248, 63, 225, 56, 138, 90, 66, 248, 2, 64, 8, 4, 59, 236, 66, 43, 3, 64},
    {0, 0, 0, 0, 0, 0, 0, 0, 100, 182, 56, 107, 196, 96, 250, 63, 197, 40, 37, 202, 87, 74, 248, 63, 254, 212, 93, 165, 93, 36, 249, 63, 227, 169, 28, 93, 168, 203, 243, 63, 96, 178, 252, 153, 20, 185, 236, 63, 16, 210, 134, 75, 141, 20, 249, 63, 134, 95, 166, 153, 126, 245, 244, 63, 111, 206, 214, 202, 119, 0, 2, 64, 213, 111, 14, 122, 78, 205, 250, 63, 140, 102, 165, 94, 117, 215, 0, 64, 60, 1, 146, 176, 238, 214, 5, 64, 118, 26, 166, 244, 155, 115, 5, 64, 240, 11, 14, 80, 201, 156, 226, 63, 28, 220, 33, 133, 25, 58, 220, 63, 136, 252, 130, 161, 38, 185, 252, 63, 190, 163, 241, 153, 160, 71, 242, 63, 55, 13, 24, 237, 211, 213, 219, 63, 157, 232, 9, 117, 62, 153, 252, 63, 10, 30, 202, 32, 122, 178, 6, 64, 232, 158, 105, 152, 136, 127, 251, 63, 98, 16, 169, 219, 86, 102, 248, 63, 73, 90, 52, 91, 155, 228, 249, 63, 80, 109, 40, 230, 80, 63, 240, 63, 96, 104, 168, 108, 127, 143, 246, 63, 194, 55, 13, 250, 148, 72, 228, 63, 181, 191, 77, 152, 172, 11, 3, 64, 101, 248, 200, 7, 18, 157, 253, 63, 15, 126, 20, 194, 157, 158, 234, 63, 23, 169, 19, 131, 223, 159, 203, 63, 244, 96, 119, 24, 169, 178, 212, 63, 82, 67, 223, 143, 127, 16, 242, 63, 55, 204, 248, 164, 0, 32, 249, 63, 45, 245, 153, 229, 77, 93, 0, 64, 2, 22, 19, 113, 235, 57, 247, 63, 15, 104, 166, 198, 217, 33, 255, 63, 51, 106, 42, 64, 57, 197, 251, 63, 6, 42, 98, 76, 83, 247, 219, 63, 151, 59, 118, 62, 197, 120, 229, 63, 110, 219, 124, 72, 184, 50, 245, 63, 219, 225, 187, 59, 243, 72, 249, 63, 126, 202, 162, 15, 54, 4, 243, 63, 187, 240, 139, 127, 96, 84, 238, 63, 114, 112, 102, 140, 109, 73, 1, 64, 24, 53, 253, 162, 205, 3, 0, 64, 125, 78, 173, 163, 4, 124, 255, 63, 170, 142, 235, 99, 102, 77, 0, 64, 73, 29, 69, 248, 63, 96, 253, 63, 212, 136, 173, 37, 116, 237, 242, 63, 110, 65, 109, 249, 136, 233, 235, 63, 125, 210, 133, 91, 19, 140, 246, 63, 89, 218, 217, 239, 63, 212, 1, 64, 166, 153, 136, 114, 203, 99, 255, 63, 61, 79, 83, 238, 57, 30, 249, 63, 116, 245, 238, 230, 158, 127, 242, 63, 24, 105, 133, 61, 206, 180, 225, 63, 249, 223, 134, 20, 219, 228, 5, 64, 37, 31, 92, 252, 167, 184, 246, 63, 100, 2, 252, 191, 140, 38, 4, 64, 17, 30, 114, 61, 14, 215, 248, 63, 229, 43, 139, 216, 209, 180, 247, 63, 91, 54, 101, 103, 20, 62, 249, 63, 138, 232, 7, 54, 29, 81, 216, 63, 239, 229, 188, 107, 229, 229, 239, 63, 242, 192, 241, 171, 240, 38, 229, 63, 116, 38, 236, 212, 168, 198, 248, 63, 123, 115, 89, 72, 25, 142, 254, 63, 104, 86, 225, 181, 86, 186, 244, 63, 176, 124, 32, 129, 52, 19, 240, 63, 49, 99, 224, 6, 81, 173, 253, 63, 26, 75, 170, 23, 144, 138, 0, 64, 89, 57, 121, 25, 249, 154, 251, 63, 73, 242, 86, 172, 185, 73, 248, 63, 255, 161, 173, 185, 89, 69, 4, 64, 38, 58, 193, 115, 52, 70, 204, 63, 6, 35, 255, 255, 77, 26, 236, 63, 220, 168, 131, 61, 10, 103, 243, 63, 24, 41, 206, 55, 207, 144, 243, 63, 19, 218, 0, 236, 217, 197, 193, 63, 162, 89, 136, 76, 176, 245, 3, 64, 136, 160, 0, 185, 151, 227, 4, 64, 194, 106, 28, 59, 45, 61, 240, 63, 73, 248, 49, 18, 103, 119, 255, 63, 102, 62, 220, 77, 191, 70, 255, 63, 230, 185, 109, 16, 237, 176, 247, 63, 137, 253, 222, 29, 140, 255, 242, 63, 132, 51, 83, 197, 154, 6, 7, 64, 104, 213, 99, 202, 101, 115, 253, 63, 220, 237, 9, 169, 241, 225, 222, 63, 174, 156, 145, 96, 183, 32, 2, 64, 116, 217, 28, 186, 187, 237, 1, 64, 50, 143, 30, 226, 50, 133, 5, 64, 174, 45, 189, 217, 254, 153, 229, 63, 240, 251, 214, 74, 181, 144, 3, 64, 192, 223, 31, 130, 68, 238, 233, 63, 199, 157, 104, 97, 68, 79, 241, 63, 218, 216, 41, 244, 252, 65, 213, 63, 23, 102, 95, 75, 32, 176, 250, 63, 68, 225, 125, 138, 0, 7, 0, 64, 174, 129, 255, 25, 145, 66, 3, 64, 249, 135, 29, 36, 81, 255, 238, 63, 210, 152, 178, 70, 53, 32, 255, 63, 51, 135, 100, 16, 169, 216, 237, 63, 6, 212, 112, 152, 23, 153, 249, 63, 144, 5, 21, 113, 240, 202, 249, 63, 119, 217, 102, 75, 169, 103, 0, 64, 123, 153, 196, 5, 12, 75, 253, 63, 219, 88, 90, 132, 169, 225, 250, 63, 79, 202, 74, 225, 21, 32, 240, 63, 62, 153, 3, 181, 240, 105, 7, 64, 94, 125, 59, 98, 77, 231, 5, 64, 228, 112, 119, 97, 53, 48, 226, 63, 28, 224, 7, 236, 228, 55, 250, 63, 116, 219, 245, 131, 145, 12, 209, 63, 47, 149, 97, 114, 105, 248, 212, 63, 218, 29, 19, 43, 49, 175, 237, 63, 111, 88, 114, 211, 107, 67, 242, 63, 158, 34, 118, 48, 124, 138, 0, 64, 248, 10, 235, 161, 58, 200, 1, 64, 37, 182, 34, 231, 212, 58, 3, 64, 17, 53, 239, 192, 170, 86, 236, 63, 81, 87, 94, 148, 190, 226, 250, 63, 16, 60, 40, 254, 204, 151, 225, 63, 125, 114, 128, 148, 7, 66, 3, 64, 6, 14, 177, 199, 18, 157, 1, 64, 122, 200, 113, 7, 18, 75, 246, 63, 89, 25, 36, 167, 227, 61, 252, 63, 61, 52, 28, 118, 85, 102, 6, 64, 156, 75, 221, 168, 14, 225, 246, 63, 246, 93, 219, 238, 133, 214, 230, 63, 216, 183, 21, 70, 137, 252, 239, 63, 155, 49, 143, 93, 44, 249, 242, 63, 84, 27, 119, 154, 134, 14, 250, 63, 159, 121, 59, 177, 239, 253, 216, 63, 175, 93, 187, 191, 51, 255, 5, 64, 30, 126, 7, 115, 121, 194, 241, 63, 43, 194, 188, 59, 58, 5, 252, 63, 88, 218, 112, 83, 55, 213, 251, 63, 90, 111, 76, 246, 62, 130, 241, 63, 168, 45, 18, 128, 239, 109, 238, 63, 87, 14, 50, 130, 39, 194, 225, 63, 88, 68, 201, 252, 23, 96, 247, 63, 222, 131, 18, 140, 87, 252, 0, 64, 177, 187, 252, 167, 187, 219, 4, 64, 202, 55, 193, 12, 86, 22, 249, 63, 98, 17, 240, 251, 10, 245, 0, 64, 213, 94, 190, 239, 83, 108, 254, 63, 17, 22, 104, 154, 26, 236, 252, 63, 250, 55, 183, 191, 34, 163, 241, 63, 49, 209, 93, 58, 153, 2, 241, 63, 182, 23, 60, 236, 98, 98, 221, 63, 127, 112, 21, 169, 44, 86, 247, 63, 89, 49, 84, 161, 133, 182, 3, 64, 161, 253, 2, 75, 253, 38, 246, 63, 93, 40, 14, 220, 188, 13, 246, 63, 56, 33, 211, 130, 144, 154, 0, 64, 119, 119, 83, 150, 194, 155, 245, 63, 194, 97, 85, 174, 172, 52, 2, 64, 209, 127, 204, 207, 184, 30, 246, 63, 65, 127, 47, 248, 185, 101, 254, 63, 117, 138, 2, 223, 1, 219, 0, 64, 118, 78, 252, 65, 69, 63, 7, 64, 85, 17, 139, 204, 84, 162, 6, 64, 148, 221, 79, 16, 82, 6, 249, 63, 153, 185, 68, 66, 202, 255, 248, 63, 221, 242, 94, 3, 54, 199, 240, 63, 101, 247, 19, 129, 243, 161, 248, 63, 17, 68, 161, 244, 147, 31, 252, 63, 36, 69, 107, 237, 91, 203, 255, 63, 30, 90, 99, 243, 88, 80, 5, 64, 78, 220, 10, 57, 13, 60, 238, 63, 204, 83, 199, 233, 141, 246, 224, 63, 222, 194, 155, 90, 249, 232, 0, 64, 223, 107, 252, 162, 169, 14, 0, 64, 90, 60, 198, 242, 209, 76, 224, 63, 106, 236, 27, 241, 175, 3, 226, 63, 85, 109, 92, 54, 144, 154, 243, 63, 234, 140, 16, 104, 127, 91, 2, 64, 60, 49, 65, 139, 93, 69, 242, 63, 153, 94, 140, 92, 34, 251, 219, 63, 10, 55, 164, 123, 185, 126, 248, 63, 16, 29, 3, 197, 104, 29, 0, 64, 101, 83, 160, 103, 56, 133, 243, 63, 67, 161, 102, 9, 129, 190, 3, 64, 131, 233, 206, 74, 53, 1, 249, 63, 14, 55, 159, 249, 136, 223, 5, 64, 252, 111, 28, 95, 86, 139, 228, 63, 179, 193, 195, 123, 169, 81, 1, 64, 122, 158, 135, 36, 143, 113, 245, 63, 77, 139, 241, 3, 176, 76, 208, 63, 96, 104, 44, 52, 95, 46, 1, 64, 100, 30, 57, 146, 56, 23, 246, 63, 216, 235, 23, 133, 179, 180, 213, 63, 93, 77, 188, 222, 131, 38, 254, 63, 190, 84, 180, 135, 147, 197, 1, 64, 85, 207, 71, 236, 180, 216, 2, 64, 177, 246, 196, 100, 239, 221, 213, 63, 8, 111, 189, 92, 163, 140, 230, 63, 133, 141, 22, 235, 0, 17, 3, 64, 142, 185, 251, 50, 233, 163, 245, 63, 43, 76, 116, 79, 110, 170, 243, 63, 241, 171, 41, 247, 170, 75, 233, 63, 37, 22, 15, 89, 29, 73, 1, 64, 89, 24, 133, 255, 138, 75, 254, 63, 36, 216, 174, 185, 132, 82, 5, 64, 140, 222, 128, 243, 242, 123, 215, 63, 108, 188, 45, 223, 208, 167, 242, 63, 166, 145, 54, 4, 245, 23, 1, 64, 81, 18, 221, 98, 254, 94, 253, 63, 184, 103, 62, 63, 240, 116, 234, 63, 60, 203, 113, 123, 48, 7, 3, 64, 204, 186, 53, 147, 253, 75, 224, 63, 110, 181, 72, 158, 169, 107, 221, 63, 62, 175, 6, 224, 86, 67, 242, 63, 66, 147, 94, 163, 252, 133, 241, 63, 9, 89, 71, 202, 180, 179, 254, 63, 73, 193, 156, 109, 38, 28, 255, 63, 214, 85, 95, 48, 109, 22, 237, 63, 84, 61, 198, 253, 7, 252, 0, 64, 137, 34, 29, 28, 132, 36, 231, 63, 75, 75, 217, 65, 231, 90, 252, 63, 45, 166, 7, 36, 176, 22, 3, 64, 163, 242, 155, 23, 68, 219, 234, 63, 185, 125, 31, 42, 68, 73, 251, 63, 141, 134, 13, 153, 160, 222, 255, 63, 148, 189, 98, 78, 62, 49, 243, 63, 231, 68, 21, 187, 115, 7, 255, 63, 93, 148, 17, 104, 20, 132, 229, 63, 176, 94, 82, 118, 64, 104, 250, 63, 124, 43, 89, 236, 217, 79, 240, 63, 233, 254, 120, 254, 168, 49, 242, 63, 156, 114, 118, 43, 229, 120, 240, 63, 35, 241, 60, 38, 16, 114, 247, 63, 18, 241, 97, 62, 42, 3, 242, 63, 40, 229, 123, 170, 99, 231, 250, 63, 96, 80, 126, 167, 150, 77, 247, 63, 73, 100, 75, 17, 93, 33, 229, 63, 233, 246, 89, 235, 217, 126, 238, 63, 26, 186, 27, 21, 76, 74, 236, 63, 111, 7, 9, 206, 106, 69, 251, 63, 40, 102, 35, 96, 57, 208, 253, 63, 183, 125, 75, 103, 109, 214, 249, 63, 10, 120, 26, 166, 137, 244, 0, 64, 145, 31, 93, 229, 239, 207, 2, 64, 172, 149, 27, 45, 71, 101, 242, 63, 102, 133, 127, 208, 217, 132, 4, 64, 114, 98, 105, 33, 245, 58, 245, 63, 123, 229, 142, 104, 254, 16, 2, 64, 114, 25, 250, 14, 141, 169, 252, 63, 183, 174, 4, 188, 69, 248, 247, 63, 246, 120, 247, 26, 168, 70, 227, 63, 139, 37, 173, 61, 126, 204, 243, 63, 42, 1, 132, 215, 175, 50, 220, 63, 74, 114, 93, 167, 67, 122, 253, 63, 6, 133, 103, 231, 190, 201, 225, 63, 88, 29, 106, 202, 211, 225, 244, 63, 5, 178, 93, 97, 255, 158, 247, 63, 21, 160, 153, 139, 219, 179, 249, 63, 132, 94, 75, 25, 184, 68, 244, 63, 191, 206, 33, 56, 203, 37, 2, 64, 220, 95, 173, 247, 26, 217, 3, 64, 102, 85, 101, 226, 34, 175, 4, 64, 66, 79, 16, 172, 200, 208, 241, 63, 212, 140, 75, 190, 84, 201, 242, 63, 71, 171, 147, 179, 129, 17, 241, 63, 104, 231, 74, 22, 156, 209, 241, 63, 23, 247, 40, 89, 203, 108, 236, 63, 206, 113, 27, 96, 49, 100, 229, 63, 80, 101, 232, 20, 245, 117, 3, 64, 112, 230, 230, 81, 107, 180, 243, 63, 216, 37, 251, 128, 10, 25, 251, 63, 246, 84, 51, 150, 80, 146, 243, 63, 109, 14, 0, 66, 197, 156, 1, 64, 121, 220, 15, 251, 253, 110, 254, 63, 92, 18, 83, 140, 156, 194, 236, 63, 134, 24, 239, 201, 189, 220, 245, 63, 140, 184, 83, 73, 60, 125, 248, 63, 68, 153, 137, 99, 110, 43, 244, 63, 5, 50, 186, 182, 75, 186, 1, 64, 25, 150, 217, 1, 173, 198, 253, 63, 230, 180, 28, 246, 169, 194, 0, 64, 51, 10, 15, 159, 84, 239, 2, 64, 129, 74, 52, 100, 252, 15, 253, 63, 217, 215, 124, 182, 12, 138, 2, 64, 125, 146, 189, 104, 126, 98, 247, 63, 12, 117, 11, 197, 237, 139, 1, 64, 142, 155, 189, 87, 133, 172, 232, 63, 158, 215, 120, 134, 79, 141, 248, 63, 249, 205, 160, 98, 221, 243, 239, 63, 26, 192, 188, 200, 185, 233, 244, 63, 151, 96, 99, 188, 29, 38, 253, 63, 28, 140, 164, 216, 125, 184, 233, 63, 37, 187, 6, 228, 143, 209, 249, 63, 204, 202, 3, 146, 82, 198, 243, 63, 191, 223, 105, 200, 186, 226, 253, 63, 222, 229, 98, 19, 6, 179, 251, 63, 236, 157, 254, 219, 222, 168, 232, 63, 229, 183, 164, 124, 67, 114, 247, 63, 220, 161, 76, 206, 12, 72, 240, 63, 134, 240, 219, 234, 132, 72, 246, 63, 203, 78, 173, 64, 204, 120, 213, 63, 26, 219, 79, 156, 112, 97, 247, 63, 95, 223, 86, 73, 155, 222, 235, 63, 6, 48, 51, 119, 121, 235, 252, 63, 88, 112, 121, 57, 107, 253, 3, 64, 104, 28, 29, 156, 154, 71, 234, 63, 245, 124, 149, 83, 180, 164, 237, 63, 224, 205, 207, 143, 215, 203, 225, 63, 8, 61, 202, 26, 247, 225, 255, 63, 204, 149, 12, 89, 80, 222, 250, 63, 23, 0, 140, 84, 59, 64, 255, 63, 23, 28, 248, 50, 215, 125, 252, 63, 136, 94, 121, 121, 17, 233, 253, 63, 74, 228, 170, 220, 222, 127, 252, 63, 56, 188, 188, 200, 139, 61, 247, 63, 187, 129, 148, 237, 158, 25, 0, 64, 166, 91, 18, 198, 21, 153, 2, 64, 151, 38, 90, 187, 125, 105, 242, 63, 242, 156, 52, 56, 208, 49, 232, 63, 23, 238, 28, 184, 113, 147, 255, 63, 186, 14, 43, 173, 173, 21, 0, 64, 118, 22, 87, 147, 0, 203, 6, 64, 231, 31, 100, 152, 165, 240, 236, 63, 96, 235, 167, 73, 17, 186, 247, 63, 107, 28, 239, 86, 144, 6, 5, 64, 140, 3, 187, 92, 250, 186, 246, 63, 249, 200, 220, 29, 120, 110, 251, 63, 72, 139, 2, 219, 253, 114, 245, 63, 217, 139, 18, 49, 165, 233, 227, 63, 135, 44, 160, 184, 13, 187, 234, 63, 244, 159, 252, 241, 119, 106, 8, 64, 186, 146, 207, 203, 106, 94, 0, 64, 210, 3, 1, 19, 35, 131, 233, 63, 144, 138, 253, 71, 19, 204, 5, 64, 170, 145, 226, 3, 148, 227, 4, 64, 80, 58, 250, 122, 185, 25, 248, 63, 143, 17, 83, 80, 52, 145, 255, 63, 103, 29, 129, 124, 88, 60, 4, 64, 246, 118, 18, 63, 136, 193, 250, 63, 22, 226, 119, 125, 57, 171, 3, 64, 52, 114, 160, 159, 50, 120, 248, 63, 134, 45, 232, 101, 206, 69, 6, 64, 207, 89, 1, 37, 4, 236, 3, 64, 38, 85, 122, 78, 134, 117, 249, 63, 235, 38, 84, 65, 228, 248, 239, 63, 138, 119, 58, 199, 149, 25, 229, 63, 201, 24, 29, 34, 211, 231, 241, 63, 8, 178, 159, 19, 104, 178, 221, 63, 128, 81, 144, 113, 215, 53, 0, 64, 130, 132, 94, 222, 73, 25, 227, 63, 183, 240, 46, 119, 85, 201, 253, 63, 197, 131, 103, 232, 202, 203, 241, 63, 48, 148, 204, 174, 63, 58, 242, 63, 42, 34, 17, 143, 90, 70, 1, 64, 144, 240, 56, 244, 134, 35, 244, 63, 207, 236, 29, 168, 37, 173, 250, 63, 124, 248, 169, 153, 21, 86, 240, 63, 32, 93, 75, 208, 189, 86, 254, 63, 241, 48, 50, 155, 64, 53, 1, 64, 190, 140, 160, 55, 248, 199, 232, 63, 193, 107, 131, 93, 232, 123, 245, 63, 69, 42, 193, 83, 231, 202, 208, 63, 47, 68, 141, 215, 162, 160, 192, 63, 126, 137, 225, 100, 17, 10, 252, 63, 158, 10, 185, 98, 42, 110, 247, 63, 203, 98, 184, 250, 48, 90, 2, 64, 85, 92, 157, 123, 47, 70, 247, 63, 139, 45, 87, 206, 40, 26, 205, 63, 170, 96, 159, 199, 142, 126, 2, 64, 26, 148, 105, 248, 125, 100, 1, 64, 190, 91, 233, 240, 3, 14, 4, 64, 217, 202, 29, 128, 75, 194, 239, 63, 30, 195, 4, 230, 96, 162, 243, 63, 115, 71, 95, 133, 202, 216, 245, 63, 110, 159, 44, 70, 166, 202, 243, 63, 90, 186, 44, 99, 162, 119, 242, 63, 4, 60, 122, 172, 46, 228, 254, 63, 165, 6, 230, 188, 123, 224, 1, 64, 230, 236, 112, 219, 153, 197, 232, 63, 18, 123, 33, 59, 53, 190, 236, 63, 101, 64, 237, 195, 166, 22, 247, 63, 176, 110, 70, 104, 173, 164, 252, 63, 108, 179, 85, 132, 87, 251, 254, 63, 182, 6, 156, 16, 160, 72, 0, 64, 6, 176, 145, 32, 165, 182, 233, 63, 94, 250, 37, 59, 113, 123, 6, 64, 11, 152, 16, 245, 235, 33, 3, 64, 125, 59, 120, 31, 37, 233, 234, 63, 22, 177, 111, 247, 111, 194, 2, 64, 107, 148, 51, 244, 85, 109, 251, 63, 105, 50, 115, 210, 184, 112, 254, 63, 164, 98, 33, 47, 165, 211, 0, 64, 226, 158, 129, 222, 187, 57, 2, 64, 208, 124, 189, 116, 84, 72, 246, 63, 170, 165, 143, 16, 211, 116, 225, 63, 141, 62, 196, 190, 247, 231, 253, 63, 2, 197, 168, 148, 69, 44, 228, 63, 212, 54, 172, 218, 119, 119, 4, 64, 155, 47, 190, 110, 230, 186, 250, 63, 8, 171, 178, 32, 48, 189, 244, 63, 169, 185, 224, 61, 179, 55, 233, 63, 113, 246, 177, 107, 42, 62, 253, 63, 118, 156, 22, 111, 101, 187, 5, 64, 146, 43, 187, 231, 62, 197, 237, 63, 213, 236, 105, 113, 150, 27, 236, 63, 233, 82, 149, 98, 9, 234, 3, 64, 170, 220, 163, 10, 196, 32, 7, 64, 188, 25, 207, 200, 123, 67, 5, 64, 179, 140, 122, 227, 209, 227, 238, 63, 248, 188, 222, 207, 35, 177, 253, 63, 170, 135, 106, 209, 10, 109, 250, 63, 8, 208, 89, 250, 64, 64, 244, 63, 180, 112, 179, 235, 26, 21, 0, 64, 196, 171, 243, 186, 203, 138, 245, 63, 208, 65, 30, 119, 28, 65, 222, 63, 136, 101, 110, 190, 180, 186, 2, 64, 158, 94, 139, 105, 6, 191, 238, 63, 201, 18, 9, 182, 69, 98, 246, 63, 70, 84, 222, 97, 180, 24, 249, 63, 28, 71, 1, 2, 149, 4, 251, 63, 160, 195, 32, 46, 121, 72, 1, 64, 188, 240, 18, 26, 230, 214, 241, 63, 133, 19, 129, 92, 69, 27, 254, 63, 11, 36, 218, 74, 155, 238, 255, 63, 232, 206, 153, 194, 106, 225, 241, 63, 22, 90, 41, 239, 240, 158, 241, 63, 245, 59, 97, 161, 232, 208, 2, 64, 175, 240, 130, 41, 78, 82, 0, 64, 32, 3, 80, 98, 141, 210, 3, 64, 56, 169, 191, 99, 182, 50, 4, 64, 40, 4, 189, 228, 231, 158, 244, 63, 46, 10, 9, 99, 106, 125, 248, 63, 221, 28, 160, 203, 97, 240, 255, 63, 76, 34, 24, 215, 36, 26, 246, 63, 156, 242, 168, 74, 39, 58, 242, 63, 9, 50, 209, 147, 170, 21, 5, 64, 216, 206, 85, 39, 178, 152, 245, 63, 54, 224, 51, 171, 160, 162, 7, 64, 115, 1, 198, 64, 10, 63, 247, 63, 127, 80, 42, 53, 67, 119, 216, 63, 244, 111, 146, 72, 201, 133, 1, 64, 95, 90, 237, 218, 6, 77, 2, 64, 238, 76, 18, 46, 46, 136, 232, 63, 4, 254, 156, 151, 99, 180, 245, 63, 234, 253, 51, 95, 215, 24, 4, 64, 212, 28, 0, 24, 169, 16, 6, 64, 126, 130, 119, 70, 90, 67, 233, 63, 181, 77, 78, 234, 27, 237, 253, 63, 152, 109, 193, 160, 142, 47, 0, 64, 21, 53, 152, 228, 140, 178, 4, 64, 224, 131, 227, 213, 68, 50, 2, 64, 37, 173, 48, 65, 153, 86, 244, 63, 106, 3, 126, 117, 202, 169, 0, 64, 80, 96, 232, 89, 201, 4, 215, 63, 84, 201, 155, 197, 100, 89, 232, 63, 170, 20, 31, 158, 161, 31, 4, 64, 160, 205, 241, 174, 189, 189, 236, 63, 203, 102, 135, 183, 73, 99, 2, 64, 147, 234, 229, 8, 134, 125, 252, 63, 138, 134, 98, 25, 74, 181, 2, 64, 222, 183, 43, 240, 24, 205, 248, 63, 85, 142, 27, 172, 241, 243, 249, 63, 187, 247, 18, 30, 117, 18, 4, 64, 7, 57, 41, 29, 218, 91, 4, 64, 101, 27, 206, 13, 167, 1, 252, 63, 78, 156, 150, 33, 211, 74, 0, 64, 226, 34, 200, 181, 242, 244, 0, 64, 237, 94, 189, 253, 215, 45, 250, 63, 141, 0, 39, 16, 209, 167, 5, 64, 113, 231, 2, 252, 92, 170, 243, 63, 249, 246, 247, 57, 56, 141, 224, 63, 58, 246, 166, 198, 4, 103, 236, 63, 5, 78, 53, 95, 229, 53, 239, 63, 221, 37, 180, 170, 150, 247, 251, 63, 111, 45, 169, 89, 236, 177, 254, 63, 91, 151, 127, 225, 48, 200, 2, 64, 183, 218, 187, 112, 113, 68, 247, 63, 3, 227, 158, 98, 18, 56, 240, 63, 71, 218, 136, 159, 111, 172, 249, 63, 67, 143, 245, 50, 199, 116, 247, 63, 178, 168, 145, 231, 118, 33, 240, 63, 1, 135, 93, 239, 141, 93, 1, 64, 181, 165, 135, 186, 71, 82, 225, 63, 233, 207, 112, 126, 69, 77, 240, 63, 241, 224, 210, 11, 254, 251, 207, 63, 130, 16, 128, 140, 252, 250, 237, 63, 154, 207, 69, 77, 255, 53, 3, 64, 74, 200, 233, 165, 101, 195, 253, 63, 63, 245, 143, 138, 68, 128, 245, 63, 114, 164, 182, 142, 96, 11, 251, 63, 248, 101, 94, 68, 150, 50, 243, 63, 165, 5, 252, 254, 104, 211, 250, 63, 15, 35, 157, 202, 6, 57, 3, 64, 124, 170, 224, 14, 235, 152, 0, 64, 196, 244, 48, 95, 24, 105, 241, 63, 129, 70, 200, 34, 36, 199, 3, 64, 158, 81, 195, 231, 156, 149, 0, 64, 110, 20, 122, 152, 37, 4, 227, 63, 43, 167, 55, 95, 27, 143, 245, 63, 214, 18, 15, 125, 248, 39, 251, 63, 102, 82, 210, 117, 110, 214, 3, 64, 157, 173, 174, 158, 134, 66, 226, 63, 223, 42, 140, 99, 195, 24, 3, 64, 125, 37, 235, 164, 7, 10, 254, 63, 110, 169, 80, 154, 199, 193, 255, 63, 218, 144, 50, 13, 70, 210, 242, 63, 111, 48, 157, 114, 140, 112, 239, 63, 206, 217, 193, 242, 167, 133, 245, 63, 126, 107, 76, 159, 135, 90, 2, 64, 196, 55, 66, 35, 230, 86, 3, 64, 254, 203, 87, 245, 188, 191, 240, 63, 44, 132, 250, 61, 80, 97, 249, 63, 116, 0, 48, 47, 152, 179, 237, 63, 6, 207, 193, 169, 92, 150, 0, 64, 59, 160, 243, 115, 196, 179, 230, 63, 135, 143, 71, 53, 17, 2, 252, 63, 92, 66, 224, 10, 34, 196, 1, 64, 186, 13, 250, 182, 0, 247, 251, 63, 241, 226, 39, 231, 107, 95, 232, 63, 49, 33, 232, 182, 50, 254, 246, 63, 110, 172, 58, 197, 68, 124, 236, 63, 252, 92, 138, 49, 11, 84, 249, 63, 142, 191, 137, 203, 148, 112, 0, 64, 33, 66, 88, 156, 248, 125, 254, 63, 164, 35, 243, 252, 44, 195, 6, 64, 35, 204, 23, 224, 22, 135, 233, 63, 198, 197, 126, 202, 38, 158, 233, 63, 232, 167, 80, 76, 218, 233, 240, 63, 132, 184, 250, 30, 93, 120, 250, 63, 219, 238, 116, 187, 7, 96, 207, 63, 149, 227, 196, 175, 156, 35, 240, 63, 112, 106, 133, 4, 140, 102, 229, 63, 11, 222, 14, 226, 25, 18, 245, 63, 254, 215, 127, 32, 57, 72, 250, 63, 178, 106, 133, 178, 158, 118, 254, 63, 66, 23, 225, 46, 252, 8, 3, 64, 199, 1, 37, 105, 41, 99, 245, 63, 124, 83, 189, 29, 250, 183, 5, 64, 135, 52, 44, 161, 137, 153, 245, 63, 144, 52, 204, 3, 237, 176, 247, 63, 221, 220, 156, 13, 135, 139, 3, 64, 200, 210, 246, 169, 25, 45, 245, 63, 156, 233, 135, 88, 102, 194, 243, 63, 37, 219, 201, 155, 9, 233, 252, 63, 147, 18, 79, 237, 248, 35, 232, 63, 114, 244, 162, 40, 92, 8, 249, 63, 170, 254, 111, 153, 76, 149, 216, 63, 146, 86, 211, 147, 100, 209, 8, 64, 4, 143, 219, 7, 90, 64, 244, 63, 100, 128, 102, 66, 64, 201, 250, 63, 255, 138, 240, 207, 212, 49, 1, 64, 161, 150, 73, 219, 138, 249, 231, 63, 173, 186, 111, 31, 79, 219, 216, 63, 100, 239, 133, 88, 77, 61, 8, 64, 42, 178, 165, 255, 244, 70, 2, 64, 44, 83, 221, 237, 231, 118, 2, 64, 101, 56, 59, 211, 93, 30, 224, 63, 22, 28, 73, 59, 183, 79, 2, 64, 154, 80, 166, 159, 112, 219, 3, 64, 192, 209, 226, 237, 216, 166, 2, 64, 98, 184, 121, 122, 197, 234, 232, 63, 53, 153, 148, 39, 224, 61, 252, 63, 207, 215, 154, 200, 219, 244, 246, 63, 7, 77, 27, 144, 114, 132, 205, 63, 97, 15, 229, 130, 71, 79, 252, 63, 229, 116, 32, 65, 221, 130, 1, 64, 112, 204, 185, 155, 65, 187, 0, 64, 36, 121, 218, 241, 179, 39, 236, 63, 159, 215, 55, 122, 133, 204, 240, 63, 250, 227, 158, 1, 56, 92, 248, 63, 237, 223, 20, 53, 205, 250, 244, 63, 76, 119, 130, 111, 212, 166, 1, 64, 81, 121, 42, 247, 36, 238, 248, 63, 86, 235, 24, 225, 179, 5, 251, 63, 185, 51, 217, 170, 89, 196, 239, 63, 68, 246, 232, 233, 156, 25, 253, 63, 232, 35, 75, 186, 124, 161, 241, 63, 5, 103, 155, 227, 1, 155, 243, 63, 10, 97, 84, 5, 73, 48, 255, 63, 2, 243, 7, 113, 203, 123, 221, 63, 160, 211, 27, 83, 225, 139, 1, 64, 153, 215, 38, 186, 138, 125, 222, 63, 166, 212, 197, 50, 189, 47, 250, 63, 98, 63, 44, 152, 176, 78, 243, 63, 37, 212, 162, 118, 45, 82, 251, 63, 207, 45, 33, 181, 92, 77, 243, 63, 16, 15, 246, 148, 243, 220, 232, 63, 210, 64, 217, 116, 110, 140, 241, 63, 228, 117, 15, 160, 247, 243, 219, 63, 9, 27, 179, 31, 164, 153, 0, 64, 240, 226, 7, 79, 82, 71, 246, 63, 104, 21, 229, 142, 246, 213, 229, 63, 135, 34, 82, 232, 89, 154, 243, 63, 165, 252, 148, 83, 68, 5, 249, 63, 112, 13, 37, 71, 181, 87, 247, 63, 76, 190, 99, 151, 163, 191, 5, 64, 11, 81, 217, 53, 223, 172, 255, 63, 45, 159, 87, 0, 114, 222, 248, 63, 123, 142, 56, 244, 245, 108, 252, 63, 19, 239, 54, 182, 79, 108, 5, 64, 160, 82, 193, 129, 30, 60, 0, 64, 38, 27, 99, 181, 16, 173, 251, 63, 150, 109, 158, 67, 160, 65, 255, 63, 94, 133, 38, 225, 140, 100, 248, 63, 26, 93, 112, 222, 240, 64, 0, 64, 204, 68, 146, 119, 255, 158, 0, 64, 17, 247, 136, 234, 163, 209, 240, 63, 17, 216, 86, 218, 190, 211, 4, 64, 8, 142, 27, 52, 150, 200, 0, 64, 96, 1, 197, 9, 212, 195, 215, 63, 66, 124, 30, 230, 149, 106, 243, 63, 181, 93, 99, 32, 147, 105, 250, 63, 214, 121, 179, 154, 107, 147, 232, 63, 157, 189, 123, 206, 122, 104, 245, 63, 229, 167, 245, 36, 9, 41, 237, 63, 246, 228, 126, 189, 217, 49, 254, 63, 0, 41, 203, 45, 247, 79, 5, 64, 208, 236, 230, 253, 6, 99, 6, 64, 223, 181, 112, 43, 195, 47, 241, 63, 52, 136, 151, 136, 80, 93, 244, 63, 165, 190, 111, 135, 200, 60, 3, 64, 100, 172, 135, 26, 106, 163, 247, 63, 223, 25, 92, 76, 43, 150, 223, 63, 236, 73, 185, 145, 29, 23, 1, 64, 79, 85, 85, 92, 61, 147, 213, 63, 114, 162, 16, 15, 85, 170, 242, 63, 125, 119, 66, 42, 216, 232, 251, 63, 39, 236, 112, 155, 132, 84, 240, 63, 241, 47, 75, 161, 145, 96, 254, 63, 182, 171, 182, 71, 198, 247, 7, 64, 64, 166, 121, 114, 144, 208, 243, 63, 147, 49, 42, 46, 26, 1, 247, 63, 11, 26, 7, 71, 28, 36, 244, 63, 114, 172, 96, 77, 39, 73, 230, 63, 186, 13, 47, 76, 168, 211, 236, 63, 96, 112, 96, 194, 57, 194, 250, 63, 70, 126, 3, 1, 170, 129, 253, 63, 123, 42, 247, 197, 92, 79, 226, 63, 217, 244, 2, 116, 201, 167, 245, 63, 138, 91, 148, 177, 19, 65, 254, 63, 214, 154, 241, 215, 0, 26, 248, 63, 216, 222, 185, 142, 132, 94, 252, 63, 49, 87, 61, 252, 131, 72, 3, 64, 91, 152, 104, 176, 250, 69, 7, 64, 105, 157, 158, 119, 11, 114, 1, 64, 213, 233, 198, 202, 188, 84, 224, 63, 169, 0, 213, 53, 24, 158, 255, 63, 233, 145, 29, 134, 42, 112, 234, 63, 79, 91, 125, 197, 26, 146, 254, 63, 197, 83, 117, 58, 173, 53, 6, 64, 190, 151, 227, 92, 198, 225, 1, 64, 250, 117, 180, 181, 141, 235, 0, 64, 125, 153, 60, 191, 151, 144, 0, 64, 249, 214, 121, 133, 212, 40, 247, 63, 220, 111, 248, 53, 224, 217, 238, 63, 61, 222, 255, 161, 28, 217, 5, 64, 128, 139, 212, 116, 157, 91, 245, 63, 128, 88, 183, 193, 202, 111, 3, 64, 128, 103, 49, 63, 219, 22, 5, 64, 225, 226, 215, 240, 46, 156, 230, 63, 215, 108, 230, 91, 165, 108, 7, 64, 103, 78, 211, 171, 71, 82, 236, 63, 154, 236, 126, 112, 66, 30, 3, 64, 53, 66, 56, 167, 103, 216, 250, 63, 237, 74, 255, 86, 186, 77, 233, 63, 195, 38, 62, 3, 114, 178, 226, 63, 145, 46, 118, 77, 250, 31, 246, 63, 71, 34, 186, 133, 130, 110, 6, 64, 220, 131, 49, 39, 173, 126, 211, 63, 10, 87, 231, 230, 110, 32, 231, 63, 243, 25, 12, 70, 189, 221, 230, 63, 225, 34, 77, 16, 4, 242, 248, 63, 216, 31, 150, 70, 212, 202, 238, 63, 24, 243, 90, 218, 151, 80, 3, 64, 161, 83, 160, 232, 17, 209, 239, 63, 124, 105, 197, 99, 95, 105, 245, 63, 178, 20, 220, 67, 172, 143, 231, 63, 213, 45, 143, 16, 29, 45, 241, 63, 20, 110, 188, 134, 71, 41, 253, 63, 15, 169, 76, 179, 118, 216, 255, 63, 130, 106, 43, 244, 27, 130, 252, 63, 86, 180, 56, 82, 139, 135, 240, 63, 39, 39, 234, 163, 53, 10, 242, 63, 123, 137, 147, 99, 124, 164, 251, 63, 178, 132, 235, 10, 141, 197, 254, 63, 41, 90, 30, 131, 50, 182, 3, 64, 167, 54, 43, 211, 132, 54, 242, 63, 123, 144, 109, 228, 11, 160, 240, 63, 77, 1, 197, 35, 137, 211, 226, 63, 176, 240, 167, 214, 234, 172, 246, 63, 89, 8, 156, 158, 110, 55, 229, 63, 148, 28, 4, 84, 24, 16, 249, 63, 209, 93, 220, 140, 102, 203, 241, 63, 170, 1, 16, 19, 228, 125, 236, 63, 43, 167, 213, 99, 130, 103, 2, 64, 45, 173, 64, 8, 143, 97, 250, 63, 228, 203, 45, 207, 125, 243, 0, 64, 52, 247, 194, 53, 12, 246, 246, 63, 29, 173, 85, 243, 59, 166, 226, 63, 131, 16, 238, 105, 137, 152, 252, 63, 45, 177, 138, 100, 209, 163, 251, 63, 89, 88, 110, 158, 147, 27, 254, 63, 202, 45, 176, 187, 105, 25, 245, 63, 145, 176, 238, 164, 174, 92, 254, 63, 188, 216, 99, 10, 50, 12, 235, 63, 188, 11, 222, 61, 174, 182, 0, 64, 39, 76, 215, 123, 71, 209, 230, 63, 130, 241, 138, 18, 227, 43, 230, 63, 248, 16, 108, 73, 87, 162, 250, 63, 40, 243, 108, 62, 209, 7, 230, 63, 66, 27, 153, 216, 28, 106, 247, 63, 8, 16, 12, 167, 141, 12, 244, 63, 75, 180, 113, 210, 81, 29, 253, 63, 58, 228, 144, 76, 9, 45, 244, 63, 173, 171, 127, 26, 111, 248, 246, 63, 121, 55, 124, 95, 155, 172, 249, 63, 197, 67, 236, 229, 76, 82, 251, 63, 171, 204, 140, 75, 17, 234, 241, 63, 112, 61, 78, 102, 219, 34, 1, 64, 241, 205, 159, 205, 64, 32, 2, 64, 210, 37, 119, 144, 15, 135, 1, 64, 138, 50, 251, 229, 57, 109, 0, 64, 217, 204, 195, 104, 42, 138, 255, 63, 80, 93, 54, 109, 34, 161, 4, 64, 28, 165, 119, 82, 164, 193, 232, 63, 26, 63, 7, 203, 230, 219, 1, 64, 119, 66, 0, 74, 190, 146, 252, 63, 161, 207, 44, 200, 40, 100, 245, 63, 101, 135, 192, 112, 249, 78, 8, 64, 222, 92, 132, 192, 151, 140, 1, 64, 163, 210, 84, 193, 230, 194, 6, 64, 217, 71, 178, 90, 249, 65, 253, 63, 166, 67, 231, 105, 37, 47, 236, 63, 119, 164, 107, 34, 33, 51, 255, 63, 162, 20, 244, 31, 168, 12, 230, 63, 76, 96, 67, 161, 168, 34, 4, 64, 212, 159, 165, 88, 75, 224, 4, 64, 26, 135, 217, 156, 110, 41, 0, 64, 9, 253, 29, 134, 187, 74, 192, 63, 116, 161, 66, 3, 39, 188, 229, 63, 116, 34, 193, 51, 121, 248, 0, 64, 196, 134, 219, 38, 211, 237, 250, 63, 213, 24, 128, 192, 23, 255, 3, 64, 107, 3, 16, 121, 35, 30, 249, 63, 229, 228, 167, 237, 162, 118, 5, 64, 208, 178, 152, 5, 115, 226, 1, 64, 42, 71, 149, 114, 234, 133, 227, 63, 55, 32, 171, 42, 63, 160, 221, 63, 238, 77, 192, 74, 73, 139, 3, 64, 1, 25, 152, 149, 32, 18, 221, 63, 69, 186, 130, 46, 47, 68, 240, 63, 216, 253, 97, 98, 221, 177, 3, 64, 160, 199, 75, 216, 129, 58, 252, 63, 59, 169, 149, 222, 33, 232, 7, 64, 74, 136, 59, 119, 225, 78, 242, 63, 209, 239, 135, 127, 225, 218, 6, 64, 70, 5, 195, 187, 130, 73, 228, 63, 238, 108, 185, 94, 177, 226, 255, 63, 222, 11, 133, 122, 25, 159, 1, 64, 172, 116, 77, 181, 211, 201, 1, 64, 195, 28, 178, 24, 56, 239, 189, 63, 92, 230, 187, 96, 21, 240, 253, 63, 136, 80, 53, 248, 229, 102, 2, 64, 127, 28, 141, 119, 204, 132, 230, 63, 232, 95, 105, 169, 126, 131, 0, 64, 114, 152, 14, 190, 209, 132, 239, 63, 191, 75, 94, 169, 49, 98, 226, 63, 226, 172, 254, 19, 31, 224, 1, 64, 231, 40, 216, 167, 65, 189, 245, 63, 226, 10, 187, 91, 106, 197, 242, 63, 147, 47, 220, 115, 16, 190, 2, 64, 75, 214, 64, 67, 195, 89, 1, 64, 48, 243, 114, 50, 101, 232, 244, 63, 217, 171, 168, 160, 204, 162, 244, 63, 4, 241, 199, 47, 1, 220, 4, 64, 96, 113, 94, 84, 185, 156, 1, 64, 181, 221, 101, 154, 27, 238, 2, 64, 127, 31, 73, 44, 229, 126, 250, 63, 205, 178, 243, 215, 194, 250, 208, 63, 210, 36, 237, 134, 225, 155, 245, 63, 95, 86, 238, 75, 127, 223, 255, 63, 224, 106, 233, 134, 137, 182, 199, 63, 200, 168, 199, 241, 126, 112, 4, 64, 205, 33, 21, 45, 196, 166, 7, 64, 202, 86, 179, 19, 193, 158, 243, 63, 146, 88, 51, 122, 49, 7, 233, 63, 237, 26, 78, 234, 159, 73, 253, 63, 194, 149, 207, 216, 71, 136, 236, 63, 23, 221, 119, 22, 90, 123, 234, 63, 213, 126, 112, 239, 208, 206, 240, 63, 8, 31, 252, 185, 43, 204, 4, 64, 167, 138, 59, 24, 165, 115, 241, 63, 1, 9, 208, 103, 103, 97, 4, 64, 16, 17, 237, 150, 248, 219, 4, 64, 41, 124, 201, 22, 171, 177, 252, 63, 32, 72, 163, 35, 98, 153, 237, 63, 110, 81, 153, 182, 18, 70, 2, 64, 92, 127, 216, 134, 120, 215, 248, 63, 157, 11, 146, 236, 115, 254, 4, 64, 171, 111, 50, 18, 249, 202, 213, 63, 88, 75, 24, 143, 150, 68, 3, 64, 226, 208, 26, 73, 54, 77, 6, 64, 25, 48, 95, 79, 181, 88, 245, 63, 220, 92, 240, 56, 189, 25, 250, 63, 215, 242, 4, 10, 182, 67, 2, 64, 10, 103, 149, 24, 87, 15, 214, 63, 207, 23, 62, 19, 163, 133, 241, 63, 148, 237, 11, 228, 3, 254, 1, 64, 29, 221, 88, 190, 128, 202, 220, 63, 99, 212, 101, 112, 8, 45, 255, 63, 249, 166, 211, 251, 179, 217, 241, 63, 88, 37, 49, 73, 65, 133, 2, 64, 110, 22, 137, 243, 152, 181, 249, 63, 242, 25, 245, 124, 115, 65, 228, 63, 46, 195, 152, 246, 52, 147, 6, 64, 218, 135, 145, 119, 38, 21, 244, 63, 50, 129, 35, 157, 214, 131, 252, 63, 251, 38, 15, 85, 11, 161, 248, 63, 174, 39, 181, 5, 175, 138, 4, 64, 162, 53, 240, 211, 26, 119, 247, 63, 148, 59, 254, 56, 166, 86, 250, 63, 251, 112, 83, 30, 140, 219, 234, 63, 54, 79, 102, 235, 131, 197, 1, 64, 12, 160, 121, 89, 158, 205, 5, 64, 234, 195, 174, 193, 95, 111, 229, 63, 107, 100, 203, 237, 30, 165, 2, 64, 170, 173, 5, 61, 56, 252, 243, 63, 235, 42, 58, 5, 116, 141, 4, 64, 112, 204, 118, 118, 193, 247, 4, 64, 192, 185, 95, 169, 249, 79, 244, 63, 144, 128, 132, 76, 51, 103, 247, 63, 132, 228, 253, 2, 113, 49, 236, 63, 230, 148, 53, 227, 228, 130, 255, 63, 145, 61, 163, 106, 121, 154, 237, 63, 226, 64, 6, 203, 165, 181, 239, 63, 70, 125, 198, 185, 56, 44, 245, 63, 200, 39, 114, 27, 247, 212, 0, 64, 213, 201, 34, 121, 249, 52, 244, 63, 113, 216, 157, 207, 77, 57, 243, 63, 196, 4, 92, 218, 221, 201, 6, 64, 84, 201, 1, 223, 129, 8, 0, 64, 228, 175, 231, 198, 43, 136, 250, 63, 142, 35, 245, 42, 11, 228, 226, 63, 80, 154, 72, 152, 122, 81, 228, 63, 158, 198, 134, 117, 98, 84, 252, 63, 181, 218, 124, 139, 101, 207, 252, 63, 194, 105, 73, 7, 181, 174, 7, 64, 115, 95, 222, 198, 223, 185, 0, 64, 180, 73, 239, 44, 141, 211, 240, 63, 207, 35, 184, 109, 231, 72, 3, 64, 15, 21, 154, 161, 91, 84, 4, 64, 57, 180, 45, 197, 193, 181, 204, 63, 118, 173, 238, 182, 78, 167, 2, 64, 176, 197, 78, 250, 156, 216, 225, 63, 30, 47, 134, 236, 147, 80, 243, 63, 55, 133, 156, 76, 81, 140, 243, 63, 110, 102, 227, 223, 206, 88, 248, 63, 184, 67, 168, 16, 81, 202, 4, 64, 175, 185, 230, 216, 120, 181, 245, 63, 39, 11, 80, 94, 67, 143, 234, 63, 91, 103, 72, 63, 4, 98, 247, 63, 14, 215, 250, 55, 31, 177, 220, 63, 21, 10, 182, 168, 28, 68, 194, 63, 58, 24, 148, 41, 121, 26, 249, 63, 9, 10, 170, 96, 31, 249, 0, 64, 194, 185, 33, 110, 41, 120, 251, 63, 140, 75, 66, 215, 203, 59, 230, 63, 92, 186, 224, 162, 144, 175, 246, 63, 35, 8, 95, 254, 230, 187, 249, 63, 151, 183, 206, 237, 72, 246, 246, 63, 160, 252, 2, 59, 204, 249, 239, 63, 212, 7, 117, 86, 248, 207, 2, 64, 125, 228, 229, 190, 65, 229, 189, 63, 81, 28, 36, 207, 130, 171, 254, 63, 238, 128, 131, 44, 136, 246, 244, 63, 167, 18, 1, 195, 53, 176, 247, 63, 133, 194, 188, 122, 21, 164, 253, 63, 205, 81, 38, 30, 195, 212, 3, 64, 253, 52, 41, 46, 136, 196, 254, 63, 138, 254, 47, 87, 180, 216, 233, 63, 247, 90, 171, 213, 91, 105, 249, 63, 1, 238, 75, 189, 139, 195, 241, 63, 108, 198, 8, 32, 62, 92, 7, 64, 51, 106, 195, 83, 15, 174, 245, 63, 47, 209, 77, 23, 26, 100, 1, 64, 13, 113, 159, 148, 94, 52, 2, 64, 179, 219, 101, 194, 101, 41, 247, 63, 192, 68, 62, 101, 58, 32, 248, 63, 59, 198, 163, 31, 8, 77, 236, 63, 48, 42, 247, 98, 227, 189, 243, 63, 58, 101, 46, 76, 187, 189, 0, 64, 121, 248, 160, 231, 240, 83, 1, 64, 165, 85, 45, 244, 21, 83, 241, 63, 199, 79, 210, 33, 39, 60, 249, 63, 98, 215, 109, 157, 14, 102, 252, 63, 49, 88, 43, 112, 135, 25, 251, 63, 147, 100, 222, 230, 226, 252, 239, 63, 239, 22, 26, 159, 83, 29, 5, 64, 64, 157, 237, 224, 159, 127, 5, 64, 21, 25, 10, 44, 172, 247, 246, 63}
};

unsigned char TabulatedValues::ucParPermIdxVectorTableOrderTwo[4][9] = {
  {0, 1, 2, 3, 4, 5, 6, 7, 8},
  {0, 1, 3, 7, 2, 5, 6, 8, 4},
  {0, 1, 3, 7, 5, 4, 6, 2, 8},
  {0, 1, 2, 3, 4, 5, 6, 7, 8}
 };

unsigned char TabulatedValues::ucParPermIdxVectorTableOrderOne[4][4] = {
  {0,	1,	2,	3,	},
  {0,	1,	3,	2,	},
  {0,	1,	2,	3,	},
  {0,	1,	2,	3,	}
 };

bool TabulatedValues::getSubBandConfiguration(  const std::vector<unsigned int> p_vunSubbandWidths,
                                                std::vector< std::vector< unsigned int> > &p_rvvuiQMFSubBandIndices)
// convert subband widths to QMF indices
{
  unsigned int uiNoOfSubBands = p_vunSubbandWidths.size();  
  p_rvvuiQMFSubBandIndices.resize(uiNoOfSubBands);

    unsigned int uiRunningQMFIdx=0;

    for (unsigned int uiSubBandIdx=0; uiSubBandIdx < uiNoOfSubBands; uiSubBandIdx++)
    {
        unsigned int uiCurrBandWdth = p_vunSubbandWidths[uiSubBandIdx];

        p_rvvuiQMFSubBandIndices[uiSubBandIdx].resize( uiCurrBandWdth );
        for (unsigned int uiQMFIdx=0; uiQMFIdx < uiCurrBandWdth; uiQMFIdx++)
        {
            p_rvvuiQMFSubBandIndices[uiSubBandIdx][uiQMFIdx] = uiRunningQMFIdx;
            uiRunningQMFIdx++;
        }
    }

    return false;
}

 bool TabulatedValues::getPARPermIdxVectorTable(std::vector<std::vector<unsigned int> > & p_rvvuiPARPermIdxVectorTable,
                                                std::vector<std::vector<unsigned int> > & p_rvvuiPARInversePermIdxVectorTable,
                                                unsigned int unHoaOrder)
 {
    switch(unHoaOrder)
    {
    case 1:
       {
          unsigned int uiNoOfPermutations = 4;
          unsigned int uiNoOfDecorrFilts  = 4;

          p_rvvuiPARPermIdxVectorTable.resize(uiNoOfPermutations);
          p_rvvuiPARInversePermIdxVectorTable.resize(uiNoOfPermutations);

          for (unsigned int uiIdx=0; uiIdx < uiNoOfPermutations; uiIdx++)
          {
             p_rvvuiPARPermIdxVectorTable[uiIdx].resize(uiNoOfDecorrFilts);
             p_rvvuiPARInversePermIdxVectorTable[uiIdx].resize(uiNoOfDecorrFilts);

             for(unsigned int uiDecorrIdx=0; uiDecorrIdx < uiNoOfDecorrFilts; uiDecorrIdx++)
             {
                p_rvvuiPARPermIdxVectorTable[uiIdx][uiDecorrIdx] = ucParPermIdxVectorTableOrderOne[uiIdx][uiDecorrIdx];
                p_rvvuiPARInversePermIdxVectorTable[uiIdx][ucParPermIdxVectorTableOrderOne[uiIdx][uiDecorrIdx]] = uiDecorrIdx;
             }
          }
       }
       break;

    case 2:
       {
          unsigned int uiNoOfPermutations = 4;
          unsigned int uiNoOfDecorrFilts  = 9;

          p_rvvuiPARPermIdxVectorTable.resize(uiNoOfPermutations);
          p_rvvuiPARInversePermIdxVectorTable.resize(uiNoOfPermutations);

          for (unsigned int uiIdx=0; uiIdx < uiNoOfPermutations; uiIdx++)
          {
             p_rvvuiPARPermIdxVectorTable[uiIdx].resize(uiNoOfDecorrFilts);
             p_rvvuiPARInversePermIdxVectorTable[uiIdx].resize(uiNoOfDecorrFilts);

             for(unsigned int uiDecorrIdx=0; uiDecorrIdx < uiNoOfDecorrFilts; uiDecorrIdx++)
             {
                p_rvvuiPARPermIdxVectorTable[uiIdx][uiDecorrIdx] = ucParPermIdxVectorTableOrderTwo[uiIdx][uiDecorrIdx];
                p_rvvuiPARInversePermIdxVectorTable[uiIdx][ucParPermIdxVectorTableOrderTwo[uiIdx][uiDecorrIdx]] = uiDecorrIdx;
             }
          }
       }
       break;
    default:
       return true;
    }
    return false;
 }

bool TabulatedValues::getDirections(    std::vector< std::vector<FLOAT> > & p_rvvFDirections_ria,
                                        unsigned int p_uiOrder)
{
    // check if order is between 1 and 9
	if ( (p_uiOrder > 9) & (p_uiOrder!= 29))
	{
		std::cout << "No directions for order " << p_uiOrder << " available!" << std::endl;
		return true;
	}

    unsigned int uiNoOfDirs = (p_uiOrder+1)*(p_uiOrder+1);

    p_rvvFDirections_ria.resize(uiNoOfDirs);

    if (p_uiOrder == 0)
    {
        p_rvvFDirections_ria[0].assign( 3, static_cast<FLOAT>(0.0));
        p_rvvFDirections_ria[0][0] = static_cast<FLOAT>(1.0);
    }
    else
    {
        // choose correct table to extract directions
        unsigned int uiDirGridTableIdx = 3;

        switch(p_uiOrder)
        {
            case 15:
                uiDirGridTableIdx = 0;
                break;
            case 21:
                uiDirGridTableIdx = 1;
                break;
            case 29:
                uiDirGridTableIdx = 2;
                break;
            default:
                ;
        }

        double *pdTmpInclin;
        double *pdTmpAzim;

        if (uiDirGridTableIdx > 2)
        {
            pdTmpInclin = (double *)(ucInclinations[p_uiOrder-1]);
            pdTmpAzim   = (double *)(ucAzimuths[p_uiOrder-1]);
        }
        else
        {
            pdTmpAzim   = (double *)(ucSearchGridAzimuths[uiDirGridTableIdx]);
            pdTmpInclin = (double *)(ucSearchGridInclinations[uiDirGridTableIdx]);
        }

        for( unsigned int uiDirIdx=0; uiDirIdx < uiNoOfDirs; uiDirIdx++)
        {
            p_rvvFDirections_ria[uiDirIdx].resize(3);

            p_rvvFDirections_ria[uiDirIdx][0] = static_cast<FLOAT>(1.0);
            p_rvvFDirections_ria[uiDirIdx][1] = static_cast<FLOAT>(*pdTmpInclin);
            p_rvvFDirections_ria[uiDirIdx][2] = static_cast<FLOAT>(*pdTmpAzim);

            pdTmpInclin++;
            pdTmpAzim++;
        }
    }

    return false;

}

bool TabulatedValues::getModeMat(std::vector<std::vector<FLOAT> > & p_rvvFModeMat, int p_iOrder)
{
	// check if order is between -1 and 9
	if (p_iOrder < -1 || p_iOrder > 9)
	{
		std::cout << "No mode matrix for order " << p_iOrder << " available!" << std::endl;
		return true;
	}
	
	unsigned int uiMatDim = (p_iOrder+1)*(p_iOrder+1);

	// resize output vector to matrix dimension
	p_rvvFModeMat.resize(uiMatDim);
    for (unsigned int uiRowIdx=0; uiRowIdx < uiMatDim; uiRowIdx++)
	{
		// init row elements by zero
		p_rvvFModeMat[uiRowIdx].assign(uiMatDim, static_cast<FLOAT>(0.0) );
    }

	if (p_iOrder == 0)
	{
        p_rvvFModeMat[0][0] = static_cast<FLOAT>(1.0);
    }
    else
    {
        if (p_iOrder > 0)
        {
		    // set double pointers to beginning of unsigned int arrays
		    double *pdTmpAzim   = (double *)(ucAzimuths[p_iOrder-1]);
            double *pdTmpInclin = (double *)(ucInclinations[p_iOrder-1]);

            // compute mode matrix column-wise
			for (unsigned int uiDirIdx=0; uiDirIdx < uiMatDim; uiDirIdx++)
			{
				double dTmpAzim   = *pdTmpAzim;
                double dTmpInclin = *pdTmpInclin;

                // order index corresponds to n in description
                // degree index corresponds to m in description
                for (int iOrderIdx=0; iOrderIdx <= p_iOrder; iOrderIdx++)
                {
                    for (int iDegreeIdx=-iOrderIdx; iDegreeIdx <= iOrderIdx; iDegreeIdx++)
                    {
                        // subtract 1 due to c++ array adressing
                        int iRowIdx = iOrderIdx*(iOrderIdx+1)+iDegreeIdx;

                        p_rvvFModeMat[iRowIdx][uiDirIdx] = static_cast<FLOAT>(sphericalHarmonics( iOrderIdx, iDegreeIdx, dTmpInclin, dTmpAzim));
                    }
			    }

                pdTmpAzim++;
                pdTmpInclin++;
		    }
        }
	}

	return false;
}



bool TabulatedValues::getInvModeMat(std::vector<std::vector<FLOAT> > & p_rvvFInvModeMat, int p_iOrder)
{
	// check if order is between -1 and 6
	if (p_iOrder < -1 || p_iOrder > 6)
	{
		std::cout << "No inverse mode matrix for order " << p_iOrder << " available!" << std::endl;
		return true;
	}

	unsigned int uiMatDim = (p_iOrder+1)*(p_iOrder+1);

	// resize output vector to matrix dimension
	p_rvvFInvModeMat.resize(uiMatDim);

	if (p_iOrder >= 0)
	{
		// set double pointer to beginning of unsigned int array
		double *pdTmpVal = (double *)(ucCodedInvModeMatElems[p_iOrder]);

		for (unsigned int uiRowIdx=0; uiRowIdx < uiMatDim; uiRowIdx++)
		{
			// init row elements by zero
			p_rvvFInvModeMat[uiRowIdx].assign(uiMatDim, static_cast<FLOAT>(0.0) );

			for (unsigned int uiColIdx=0; uiColIdx < uiMatDim; uiColIdx++)
			{
				double dTmpVal = *pdTmpVal;
				p_rvvFInvModeMat[uiRowIdx][uiColIdx] = static_cast<FLOAT>(dTmpVal*m_cdN3DCorrectionInverseFactor);
				pdTmpVal++;
			}
		}
	}

	return false;
}


bool TabulatedValues::getTransposeModeMatForFineGrid(std::vector<std::vector<FLOAT> > & p_rvvFTransposeModeMatForFineGrid, 
                                                        unsigned int p_uiOrder, 
                                                        unsigned int uiDirGridTableIdx)
{
    // this function has only be tested to provide correct values for orders less than 10
    if ( p_uiOrder > 9)
	{
		std::cout << "No mode matrix for fine grid for order " << p_uiOrder << " available!" << std::endl;
		return true;
	}

    unsigned int uiNoOfDirs = 900; // default: 900 directions

    switch(uiDirGridTableIdx)
    {
        case 0:
            uiNoOfDirs = 256;
            break;
        case 1:
            uiNoOfDirs = 484;
            break;
        case 2:
            uiNoOfDirs = 900;
            break;
        case 3:
            std::cout << "This case is reserved so far!" << std::endl;
            return true;
        default:
            std::cout << "No such direction grid index allowed!" << std::endl;
            return true;
    }

    // consider that a transpose matrix is constructed (i.e. numbers of rows and columns are interchanged)
    unsigned int uiNoOfRows = uiNoOfDirs;
	unsigned int uiNoOfCols = (p_uiOrder+1)*(p_uiOrder+1);

	// resize output vector to matrix dimension
	p_rvvFTransposeModeMatForFineGrid.resize(uiNoOfRows);

    for (unsigned int uiRowIdx=0; uiRowIdx < uiNoOfRows; uiRowIdx++)
	{
		// resize row vectors
		p_rvvFTransposeModeMatForFineGrid[uiRowIdx].resize(uiNoOfCols);
	}

    // set double pointers to beginning of unsigned int arrays
	double *pdTmpAzim   = (double *)(ucSearchGridAzimuths[uiDirGridTableIdx]);
    double *pdTmpInclin = (double *)(ucSearchGridInclinations[uiDirGridTableIdx]);

    // compute transpose mode matrix row-wise
	for (unsigned int uiDirIdx=0; uiDirIdx < uiNoOfDirs; uiDirIdx++)
	{
		double dTmpAzim   = *pdTmpAzim;
        double dTmpInclin = *pdTmpInclin;

        // order index corresponds to n in description
        // degree index corresponds to m in description
        for (int iOrderIdx=0; iOrderIdx <= static_cast<int>(p_uiOrder); iOrderIdx++)
        {
            for (int iDegreeIdx=-iOrderIdx; iDegreeIdx <= iOrderIdx; iDegreeIdx++)
            {
                // subtract 1 due to c++ array adressing
                int iColIdx = iOrderIdx*(iOrderIdx+1)+iDegreeIdx;

                p_rvvFTransposeModeMatForFineGrid[uiDirIdx][iColIdx] = static_cast<FLOAT>(sphericalHarmonics( iOrderIdx, iDegreeIdx, dTmpInclin, dTmpAzim));
            }
	    }

        pdTmpAzim++;
        pdTmpInclin++;
    }
		
    return false;
}


bool TabulatedValues::getInvDecorrCoef(std::vector<FLOAT> & p_invDecorrCoef)
{
	unsigned int uiNoOfElems = 7;

	p_invDecorrCoef.assign(uiNoOfElems, static_cast<FLOAT>(0.0));

	FLOAT *pdTmpVal = (FLOAT *)(ucInvDecorrCoef);

	for (unsigned int uiElemIdx=0; uiElemIdx < uiNoOfElems; ++uiElemIdx)
	{
		FLOAT dTmpVal = *pdTmpVal;
		p_invDecorrCoef[uiElemIdx] = static_cast<FLOAT>(dTmpVal);
		pdTmpVal++;
	}	

	return false;
}

bool TabulatedValues::getDecorrCoef(std::vector<FLOAT> & p_decorrCoef)
{
	unsigned int uiNoOfElems = 9;

	p_decorrCoef.assign(uiNoOfElems, static_cast<FLOAT>(0.0));
	
	FLOAT *pdTmpVal = (FLOAT *)(ucDecorrCoef);

	for (unsigned int uiElemIdx=0; uiElemIdx < uiNoOfElems; ++uiElemIdx)
	{
		FLOAT dTmpVal = *pdTmpVal;
		p_decorrCoef[uiElemIdx] = static_cast<FLOAT>(dTmpVal);
		pdTmpVal++;
	}	

	return false;
}

bool TabulatedValues::getWeightingCdbk256x8(std::vector<std::vector<FLOAT> > & p_weightingCdbk256x8)
{
	unsigned int uiRowDim = 256;
	unsigned int uiColDim = 8;

	// resize output vector to matrix dimension
	p_weightingCdbk256x8.resize(uiRowDim);	

	// set float pointer to beginning of unsigned int array
	float *pdTmpVal = (float *)(ucWeightingCdbk256x8);

	for (unsigned int uiRowIdx=0; uiRowIdx < uiRowDim; ++uiRowIdx)
	{
		// init row elements by zero
		p_weightingCdbk256x8[uiRowIdx].assign(uiColDim, static_cast<FLOAT>(0.0) );

		for (unsigned int uiColIdx=0; uiColIdx < uiColDim; ++uiColIdx)
		{
			double dTmpVal = *pdTmpVal;			
			p_weightingCdbk256x8[uiRowIdx][uiColIdx] = static_cast<FLOAT>(dTmpVal);
			pdTmpVal++;
		}
	}
	

	return false;
}

bool TabulatedValues::getVVecVqMat(std::vector<std::vector<FLOAT> > & p_rvvFModeMat, unsigned int p_uiOrder)
{
	// check if order is above 6
	if (p_uiOrder > 6)
	{
		std::cout << "No VVec-VQ matrix for order " << p_uiOrder << " available!" << std::endl;
		return true;
	}	

	unsigned int uiColDim = (p_uiOrder+1)*(p_uiOrder+1);
	unsigned int uiRowDim = uiColDim;
	if (4==p_uiOrder)
		uiRowDim = 32;
	
	// resize output vector to matrix dimension
	p_rvvFModeMat.resize(uiRowDim);

	if (p_uiOrder >= 0)
	{
		// set double pointer to beginning of unsigned int array
		double *pdTmpVal = (double *)(ucCodedVVecVqMatElems[p_uiOrder]);

		for (unsigned int uiRowIdx=0; uiRowIdx < uiRowDim; uiRowIdx++)
		{
			// init row elements by zero
			p_rvvFModeMat[uiRowIdx].assign(uiColDim, static_cast<FLOAT>(0.0) );
		}
		for (unsigned int uiColIdx=0; uiColIdx < uiColDim; uiColIdx++)
		{
			for (unsigned int uiRowIdx=0; uiRowIdx < uiRowDim; uiRowIdx++)
			{
				double dTmpVal = *pdTmpVal;
				p_rvvFModeMat[uiRowIdx][uiColIdx] = static_cast<FLOAT>(dTmpVal * m_cdN3DCorrectionFactor);
				pdTmpVal++;
			}
		}
	}

	return false;
}
bool TabulatedValues::getDictCicpSpeakerPoints(std::vector<std::vector<FLOAT> > & p_rvvFModeMat, unsigned int p_uiOrder)
{
	// this function has only be tested to provide correct values for orders less than 10
    if ( p_uiOrder > 9)
	{
		std::cout << "No CICP Speaker Positions for order " << p_uiOrder << " available!" << std::endl;
		return true;
	}

    unsigned int uiNoOfDirs = 34; 

    unsigned int uiNoOfRows = uiNoOfDirs;
	unsigned int uiNoOfCols = (p_uiOrder+1)*(p_uiOrder+1);

	// resize output vector to matrix dimension
	p_rvvFModeMat.resize(uiNoOfRows);

    for (unsigned int uiRowIdx=0; uiRowIdx < uiNoOfRows; uiRowIdx++)
	{
		// resize row vectors
		p_rvvFModeMat[uiRowIdx].resize(uiNoOfCols);
	}
	    
	// set pointers to beginning of unsigned int arrays
	unsigned int *puiTmpAzim   = (unsigned int *)(uiCicpSpeakerdAzimuths);
    unsigned int *puiTmpInclin = (unsigned int *)(uiCicpSpeakerInclinations);

    // compute transpose mode matrix row-wise
	for (unsigned int uiDirIdx=0; uiDirIdx < uiNoOfDirs; uiDirIdx++)
	{
		double dTmpAzim   = *puiTmpAzim*(OWN_PI/180);
        double dTmpInclin = *puiTmpInclin*(OWN_PI/180);
		unsigned int iColIdx = 0;
        // order index corresponds to n in description
        // degree index corresponds to m in description
        for (int iOrderIdx=0; iOrderIdx <= static_cast<int>(p_uiOrder); iOrderIdx++)
        {			
            for (int iDegreeIdx=-iOrderIdx; iDegreeIdx <= iOrderIdx; iDegreeIdx++)
            { 
                p_rvvFModeMat[uiDirIdx][iColIdx++] = static_cast<FLOAT>(sphericalHarmonics( iOrderIdx, iDegreeIdx, dTmpInclin, dTmpAzim));
            }
	    }

        puiTmpAzim++;
        puiTmpInclin++;
    }
		
    return false;
}

bool TabulatedValues::getDict2DPoints(std::vector<std::vector<FLOAT> > & p_rvvFModeMat, unsigned int p_uiOrder)
{
		// this function has only be tested to provide correct values for orders less than 10
    if ( p_uiOrder > 9)
	{
		std::cout << "No horizontal-only codebook for order " << p_uiOrder << " available!" << std::endl;
		return true;
	}

	unsigned int uiNoOfDirs = 64; 
    unsigned int uiNoOfRows = uiNoOfDirs;
	unsigned int uiNoOfCols = (p_uiOrder+1)*(p_uiOrder+1);

	// resize output vector to matrix dimension
	p_rvvFModeMat.resize(uiNoOfRows);
	  for (unsigned int uiRowIdx=0; uiRowIdx < uiNoOfRows; uiRowIdx++)
	{
		// resize row vectors
		p_rvvFModeMat[uiRowIdx].resize(uiNoOfCols);
	}

	double dInclin = OWN_PI*0.5;
	double dStepSize = 2*OWN_PI/uiNoOfDirs;
	double dOffset = dStepSize*0.745;
	for (unsigned int uiDirIdx=0; uiDirIdx < uiNoOfDirs; uiDirIdx++)
	{
		double dTmpAzim   = dStepSize*uiDirIdx + dOffset;         
		unsigned int iColIdx = 0;
        // order index corresponds to n in description
        // degree index corresponds to m in description
        for (int iOrderIdx=0; iOrderIdx <= static_cast<int>(p_uiOrder); iOrderIdx++)
        {			
            for (int iDegreeIdx=-iOrderIdx; iDegreeIdx <= iOrderIdx; iDegreeIdx++)
            { 
                p_rvvFModeMat[uiDirIdx][iColIdx++] = static_cast<FLOAT>(sphericalHarmonics( iOrderIdx, iDegreeIdx, dInclin, dTmpAzim));
            }
	    }
	}
	return false;
}


// obsolete function
bool TabulatedValues::readDoubleMatFromFile(const std::string & p_rsMatName, std::vector<std::vector<double> > & p_rvvdMat )
{
	std::fstream fsMat;

	fsMat.open(p_rsMatName, std::fstream::in | std::fstream::binary);

	if ( fsMat.fail() )
	{
		std::cout << "Could not open matrix!" << std::endl;
		return true;
	}

	// read number of rows
	double dTmpRead;
	unsigned int uiNoOfRows;
	fsMat.read( reinterpret_cast<char *>(&dTmpRead), sizeof(double) );
	
	if ( fsMat.fail() )
	{
		std::cout << "Could not read number of rows!" << std::endl;
		return true;
	}
	
	uiNoOfRows = static_cast<unsigned int>(dTmpRead);

	// read number of columns
	unsigned int uiNoOfColumns;
	fsMat.read( reinterpret_cast<char *>(&dTmpRead), sizeof(double) );

	if ( fsMat.fail() )
	{
		std::cout << "Could not read number of columns!" << std::endl;
		return true;
	}

	uiNoOfColumns = static_cast<unsigned int>(dTmpRead);

	p_rvvdMat.resize( uiNoOfRows);

	// read elements row-wise
	for (unsigned int uiRowIdx=0; uiRowIdx < uiNoOfRows; uiRowIdx++)
	{
		p_rvvdMat[uiRowIdx].assign(uiNoOfColumns, 0.0);

		for (unsigned int uiColIdx=0; uiColIdx< uiNoOfColumns; uiColIdx++)
		{
			fsMat.read( reinterpret_cast<char *>(&(p_rvvdMat[uiRowIdx][uiColIdx])), sizeof(double) );

			if ( fsMat.fail() )
			{
				std::cout << "Could not read matrix element!" << std::endl;
				return true;
			}
		}
	}

	fsMat.close();

	return false;
}



bool TabulatedValues::writeDoubleMatToUnsignedCharTxtFile(const std::string & p_rsMatName, const std::vector<std::vector<double> > & p_rvvdMat )
{
	std::ofstream fsoMat;

	fsoMat.open(p_rsMatName, std::fstream::out );

	if ( fsoMat.fail() )
	{
		std::cout << "Could not open matrix!" << std::endl;
		return true;
	}

	for (unsigned int uiRowIdx=0; uiRowIdx < p_rvvdMat.size(); uiRowIdx++)
	{
		for(unsigned int uiColIdx=0; uiColIdx < p_rvvdMat[uiRowIdx].size(); uiColIdx++)
		{
			unsigned char *pucVal = (unsigned char *) &(p_rvvdMat[uiRowIdx][uiColIdx]);
			// conversion from double to 8 unsigned char of size of 1 Byte
			// each double value has a size of 64 Bit = 8 Byte
			for (unsigned int uiByteIdx=0; uiByteIdx < 8; uiByteIdx++)
			{
				unsigned char ucVal = *pucVal;
				fsoMat << static_cast<unsigned int>(ucVal) << ", ";
				pucVal++;
			}
		}
	}

	return false;

}
