/*******************************************************************************
This software module was originally developed by

Fraunhofer IIS, VoiceAge Corp.


Initial author:

and edited by:

-

in the course of development of ISO/IEC 23003 for reference purposes and its
performance may not have been optimized. This software module is an
implementation of one or more tools as specified by ISO/IEC 23003. ISO/IEC gives
You a royalty-free, worldwide, non-exclusive, copyright license to copy,
distribute, and make derivative works of this software module or modifications
thereof for use in implementations of ISO/IEC 23003 in products that satisfy
conformance criteria (if any). Those intending to use this software module in
products are advised that its use may infringe existing patents. ISO/IEC have no
liability for use of this software module or modifications thereof. Copyright is
not released for products that do not conform to audiovisual and image-coding
related ITU Recommendations and/or ISO/IEC International Standards.

Assurance that the originally developed software module can be used (1) in
ISO/IEC 23003 once ISO/IEC 23003 has been adopted; and (2) to develop ISO/IEC
23003:s
Fraunhofer IIS, VoiceAge Corp. grant(s) ISO/IEC all
rights necessary to include the originally developed software module or
modifications thereof in ISO/IEC 23003 and to permit ISO/IEC to offer You a
royalty-free, worldwide, non-exclusive, copyright license to copy, distribute,
and make derivative works for use in implementations of ISO/IEC 23003 in
products that satisfy conformance criteria (if any), and to the extent that such
originally developed software module or portions of it are included in ISO/IEC
23003. To the extent that Fraunhofer IIS, VoiceAge Corp.
own(s) patent rights that would be required to make, use, or sell the
originally developed software module or portions thereof included in ISO/IEC
23003 in a conforming product, Fraunhofer IIS, VoiceAge Corp. 
will assure the ISO/IEC that it is (they are) willing to negotiate
licenses under reasonable and non-discriminatory terms and conditions with
applicants throughout the world. ISO/IEC gives You a free license to this
software module or modifications thereof for the sole purpose of developing
ISO/IEC 23003.

Fraunhofer IIS, VoiceAge Corp. retain full right to
modify and use the code for its (their) own purpose, assign or donate the code
to a third party and to inhibit third parties from using the code for products
that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
International Standards. This copyright notice must be included in all copies or
derivative works.

Copyright (c) ISO/IEC 2008.
$Id: cplx_pred.c,v 1.2 2011-02-01 17:17:36 mul Exp $
*******************************************************************************/

#include "aac_tools.h"
#include "cplx_pred.h"

static void calcPredCoef(int nmdct,
                         double *mdctMid,
                         double *mdctSide,
                         float *ppredCoef,
                         float *ppredCoefQ,
                         int *ppredCoefQInt)
{
  int imdct;
  float emid = 0.0f;
  float cov = 0.0f;
  float eps = 1.0e-6f;
  const float k_delta = 0.1f;
  const float k_max = 3.0f;
  int signPredCoef;
  float absPredCoef;

  for (imdct = 0; imdct < nmdct; imdct++) {
    emid += mdctMid[imdct]*mdctMid[imdct];
    cov += mdctMid[imdct]*mdctSide[imdct];
  }

  *ppredCoef = cov/(emid + eps);

  signPredCoef = *ppredCoef > 0 ? 1 : -1;
  absPredCoef = min(fabs(*ppredCoef), k_max);

  *ppredCoefQInt = signPredCoef * (int)(absPredCoef/k_delta + 0.5f);
  *ppredCoefQ = *ppredCoefQInt*k_delta;
}

static void calcMdctRes(int nmdct,
                        float predCoefQ,
                        double *mdctMid,
                        double *mdctSide)
{
  int imdct;
  float mdctRes;

  for (imdct = 0; imdct < nmdct; imdct++) {
    mdctRes = mdctSide[imdct] - predCoefQ*mdctMid[imdct];
    mdctSide[imdct] = mdctRes;
  }
}

void ComplexPrediction(int num_sfb,
                       int *sfb_offset,
                       int num_window_groups,
                       double *mdctMid,
                       double *mdctSide,
                       int predCoefQInt[MAX_SHORT_WINDOWS][SFB_NUM_MAX])
{
  int group, sfb;
  int group_offset;
  float predCoef, predCoefQ;
  const int sfb_per_pred_band = 2;

  for (group = 0; group < num_window_groups; group++) {
    group_offset = sfb_offset[num_sfb]*group;
    for (sfb = 0; sfb < num_sfb; sfb += sfb_per_pred_band) {
      int sfbStart  = sfb;
      int sfbStop   = min(sfb + sfb_per_pred_band, num_sfb);
      int mdctStart = sfb_offset[sfbStart] + group_offset;
      int mdctEnd   = sfb_offset[sfbStop]  + group_offset;

      calcPredCoef(mdctEnd - mdctStart, &mdctMid[mdctStart], &mdctSide[mdctStart],
                   &predCoef, &predCoefQ, &predCoefQInt[group][sfb]);

      calcMdctRes(mdctEnd - mdctStart, predCoefQ, &mdctMid[mdctStart], &mdctSide[mdctStart]);
    }
  }
}

