/************************************************************************

This software module was originally developed by Fraunhofer IIS and 
VoiceAge Corp. in the course of development of the ISO/IEC 23008-3 for 
reference purposes and its  performance may not have been optimized. 
This software module is an implementation of one or more tools as 
specified by the ISO/IEC 23008-3 standard. ISO/IEC gives you a 
royalty-free, worldwide, non-exclusive,copyright license to copy, 
distribute, and make derivative works of this software module or 
modifications thereof for use in implementations or products claiming 
conformance to the ISO/IEC 23008-3 standard and which satisfy any specified 
conformance criteria. 
Those intending to use this software module in products are advised that 
its use may infringe existing patents.

ISO/IEC have no liability for use of this software module or 
modifications thereof. Copyright is not released for products that do
not conform to the ISO/IEC 23008-3 standard.

Fraunhofer IIS and VoiceAge Corp. retain full right to modify and use the 
code for its own purpose, assign or donate the code to a third party and 
to inhibit third parties from using the code for products that do not 
conform to MPEG-related ITU Recommendations and/or ISO/IEC International 
Standards.

This copyright notice must be included in all copies or derivative works.

Copyright (c) ISO/IEC 2008.

*************************************************************************/

#ifndef __INCLUDED_TCX_MDCT_H
#define __INCLUDED_TCX_MDCT_H

typedef struct T_TCX_MDCT *HANDLE_TCX_MDCT;
typedef struct T_TCX_DCT4 *HANDLE_TCX_DCT4;

typedef enum {

  TCX_MDCT_NO_ERROR = 0, 
  TCX_MDCT_FATAL_ERROR 

} TCX_MDCT_ERROR;

typedef enum {

  TCX_DCT_NO_ERROR = 0, 
  TCX_DCT_FATAL_ERROR 

} TCX_DCT_ERROR;

int 
TCX_MDCT_Open(HANDLE_TCX_MDCT *phTcxMdct);

int 
TCX_MDCT_Close(HANDLE_TCX_MDCT *phTcxMdct);

int 
TCX_MDCT_Apply(HANDLE_TCX_MDCT hTcxMdct, float *x, float *y, int l, int m, int r);

int 
TCX_MDCT_ApplyInverse(HANDLE_TCX_MDCT hTcxMdct, float *x, float *y, int l, int m, int r);

int
TCX_DCT4_Open(HANDLE_TCX_DCT4 *phDct4, int nLines);

int
TCX_DCT4_Close(HANDLE_TCX_DCT4 *phDct4);

int
TCX_DCT4_Apply(HANDLE_TCX_DCT4 hDct4, float *pIn, float *pOut);

HANDLE_TCX_DCT4
TCX_MDCT_DCT4_GetHandle(HANDLE_TCX_MDCT hTcxMdct, int nCoeff);

#endif
