/************************************************************************

This software module was originally developed by Fraunhofer IIS and 
VoiceAge Corp. in the course of development of the ISO/IEC 23008-3 for 
reference purposes and its  performance may not have been optimized. 
This software module is an implementation of one or more tools as 
specified by the ISO/IEC 23008-3 standard. ISO/IEC gives you a 
royalty-free, worldwide, non-exclusive,copyright license to copy, 
distribute, and make derivative works of this software module or 
modifications thereof for use in implementations or products claiming 
conformance to the ISO/IEC 23008-3 standard and which satisfy any specified 
conformance criteria. 
Those intending to use this software module in products are advised that 
its use may infringe existing patents.

ISO/IEC have no liability for use of this software module or 
modifications thereof. Copyright is not released for products that do
not conform to the ISO/IEC 23008-3 standard.

Fraunhofer IIS and VoiceAge Corp. retain full right to modify and use the 
code for its own purpose, assign or donate the code to a third party and 
to inhibit third parties from using the code for products that do not 
conform to MPEG-related ITU Recommendations and/or ISO/IEC International 
Standards.

This copyright notice must be included in all copies or derivative works.

Copyright (c) ISO/IEC 2008.

*************************************************************************/


/* Include these files to ensure the declarations match the definition,
 * Also, some table declaration need constants */
#include "cnst.h"
#include "acelp_plus.h"

const int NBITS_CORE_768[8] = { /* bitrate w/o BWE  * 60ms = bits per superframe */
  4*(2+2+(9+6+6)+3+(3*20)+(3*7)+46), /*2+(9+6+6)+3+(3xICB_NBITS])+(3x7)+NBITS_LPC*/
  4*(2+2+(9+6+6)+3+(3*28)+(3*7)+46),
  4*(2+2+(9+6+6)+3+(3*36)+(3*7)+46),
  4*(2+2+(9+6+6)+3+(3*44)+(3*7)+46),
  4*(2+2+(9+6+6)+3+(3*52)+(3*7)+46),
  4*(2+2+(9+6+6)+3+(3*64)+(3*7)+46),

  4*(2+2+(9+6+6)+3+(3*12)+(3*7)+46),
  4*(2+2+(9+6+6)+3+(3*16)+(3*7)+46),
};

const int NBITS_CORE_1024[8] = { /* bitrate w/o BWE  * 80ms = bits per superframe */
  (int)(9.6*80),  /* 768 = 4*192 */
  (int)(11.2*80),
  (int)(12.8*80),
  (int)(14.4*80),
  (int)(16.0*80), /* 1280 */
  (int)(18.4*80),


  (int)(8.00*80),
  (int)(8.80*80)

};


const int NBITS_CORE_ACELP_PLUS[8] = {
  (int)(9.6*80),
  (int)(11.2*80),
  (int)(12.8*80),
  (int)(14.4*80),
  (int)(16.0*80),
  (int)(18.4*80),
  (int)(8.00*80),
  (int)(8.80*80)

};


const int NBITS_ACELP_PLUS_REDUCED[] = {
  146,
  178,
  210,
  242,
  274,
  322,
  354,
  418};

const int NBITS_ACELP_PLUS_STANDARD[] = {
  192,
  224,
  256,
  288,
  320,
  368,
  400,
  464};


const int *NBITS_ACELP_PLUS[2] = {
  &NBITS_ACELP_PLUS_STANDARD[0],
  &NBITS_ACELP_PLUS_REDUCED[0]};

const int NBITS_CORE_AMR_WB_ACELP_PLUS[9] = {
   (int) (6.6 * 80),
   (int) (8.85 * 80),
   (int) (12.65 * 80),
   (int) (14.25 * 80),
   (int) (15.85 * 80),
   (int) (18.25 * 80),
   (int) (19.85 * 80),
   (int) (23.05 * 80),
   (int) (23.85 * 80)
};


const short isfIndex_acelpPlus[16] =      /* ISF possiblities RTP/3GP payload */
{
  0,
  240, /*  6000 Hz */
  256, /*  6400 Hz */
  294, /*  7350 Hz */
  320, /*  8000 Hz */
  384, /*  9600 Hz */
  441, /* 11025 Hz */
  480, /* 12000 Hz */
  512, /* 12800 Hz */
  576, /* 14400 Hz */
  640, /* 16000 Hz */
  683, /* 17075 Hz */
  768, /* 19200 Hz */
  800,  /* 20000 Hz */
  882, /* 22050 Hz */
  960  /* 24000 Hz */
};

/* TABLES: |--------------------------------------------------------------------------------------------> */

/* sine window shapes: */
const float sineWindow64[64] =
{
  0.01227154F, 0.03680722F, 0.06132074F, 0.08579731F, 0.11022221F, 0.13458071F, 0.15885814F, 0.18303989F,
  0.20711138F, 0.23105811F, 0.25486566F, 0.27851969F, 0.30200595F, 0.32531029F, 0.34841868F, 0.37131719F,
  0.39399204F, 0.41642956F, 0.43861624F, 0.46053871F, 0.48218377F, 0.50353838F, 0.52458968F, 0.54532499F,
  0.56573181F, 0.58579786F, 0.60551104F, 0.62485949F, 0.64383154F, 0.66241578F, 0.68060100F, 0.69837625F,
  0.71573083F, 0.73265427F, 0.74913639F, 0.76516727F, 0.78073723F, 0.79583690F, 0.81045720F, 0.82458930F,
  0.83822471F, 0.85135519F, 0.86397286F, 0.87607009F, 0.88763962F, 0.89867447F, 0.90916798F, 0.91911385F,
  0.92850608F, 0.93733901F, 0.94560733F, 0.95330604F, 0.96043052F, 0.96697647F, 0.97293995F, 0.97831737F,
  0.98310549F, 0.98730142F, 0.99090264F, 0.99390697F, 0.99631261F, 0.99811811F, 0.99932238F, 0.99992470F
};

const float sineWindow96[96] =
{
  0.008181F, 0.024541F, 0.040895F, 0.057237F, 0.073565F, 0.089872F, 0.106156F, 0.122411F,
  0.138633F, 0.154818F, 0.170962F, 0.187060F, 0.203108F, 0.219101F, 0.235036F, 0.250908F,
  0.266713F, 0.282446F, 0.298104F, 0.313682F, 0.329176F, 0.344581F, 0.359895F, 0.375112F,
  0.390229F, 0.405241F, 0.420145F, 0.434936F, 0.449611F, 0.464166F, 0.478596F, 0.492898F,
  0.507068F, 0.521103F, 0.534998F, 0.548749F, 0.562354F, 0.575808F, 0.589108F, 0.602251F,
  0.615232F, 0.628048F, 0.640696F, 0.653173F, 0.665475F, 0.677598F, 0.689541F, 0.701298F,
  0.712868F, 0.724247F, 0.735432F, 0.746420F, 0.757209F, 0.767795F, 0.778175F, 0.788346F,
  0.798307F, 0.808054F, 0.817585F, 0.826897F, 0.835987F, 0.844854F, 0.853494F, 0.861906F,
  0.870087F, 0.878035F, 0.885748F, 0.893224F, 0.900461F, 0.907457F, 0.914210F, 0.920718F,
  0.926979F, 0.932993F, 0.938756F, 0.944269F, 0.949528F, 0.954533F, 0.959283F, 0.963776F,
  0.968011F, 0.971987F, 0.975702F, 0.979156F, 0.982349F, 0.985278F, 0.987943F, 0.990344F,
  0.992480F, 0.994350F, 0.995953F, 0.997290F, 0.998361F, 0.999163F, 0.999699F, 0.999967F
};

const float sineWindow128[128] =
{
  0.006136F, 0.018407F, 0.030675F, 0.042938F, 0.055195F, 0.067444F, 0.079682F, 0.091909F,
  0.104122F, 0.116319F, 0.128498F, 0.140658F, 0.152797F, 0.164913F, 0.177004F, 0.189069F,
  0.201105F, 0.213110F, 0.225084F, 0.237024F, 0.248928F, 0.260794F, 0.272621F, 0.284408F,
  0.296151F, 0.307850F, 0.319502F, 0.331106F, 0.342661F, 0.354164F, 0.365613F, 0.377007F,
  0.388345F, 0.399624F, 0.410843F, 0.422000F, 0.433094F, 0.444122F, 0.455084F, 0.465977F,
  0.476799F, 0.487550F, 0.498228F, 0.508830F, 0.519356F, 0.529804F, 0.540172F, 0.550458F,
  0.560662F, 0.570781F, 0.580814F, 0.590760F, 0.600617F, 0.610383F, 0.620057F, 0.629638F,
  0.639124F, 0.648514F, 0.657807F, 0.667000F, 0.676093F, 0.685084F, 0.693971F, 0.702755F,
  0.711432F, 0.720003F, 0.728464F, 0.736817F, 0.745058F, 0.753187F, 0.761202F, 0.769103F,
  0.776888F, 0.784557F, 0.792107F, 0.799537F, 0.806848F, 0.814036F, 0.821103F, 0.828045F,
  0.834863F, 0.841555F, 0.848120F, 0.854558F, 0.860867F, 0.867046F, 0.873095F, 0.879012F,
  0.884797F, 0.890449F, 0.895966F, 0.901349F, 0.906596F, 0.911706F, 0.916679F, 0.921514F,
  0.926210F, 0.930767F, 0.935184F, 0.939459F, 0.943593F, 0.947586F, 0.951435F, 0.955141F,
  0.958703F, 0.962121F, 0.965394F, 0.968522F, 0.971504F, 0.974339F, 0.977028F, 0.979570F,
  0.981964F, 0.984210F, 0.986308F, 0.988258F, 0.990058F, 0.991710F, 0.993212F, 0.994565F,
  0.995767F, 0.996820F, 0.997723F, 0.998476F, 0.999078F, 0.999529F, 0.999831F, 0.999981F
};

const float sineWindow192[192] =
{
  0.004091F, 0.012272F, 0.020452F, 0.028630F, 0.036807F, 0.044982F, 0.053153F, 0.061321F,
  0.069484F, 0.077643F, 0.085797F, 0.093945F, 0.102087F, 0.110222F, 0.118350F, 0.126469F,
  0.134581F, 0.142683F, 0.150776F, 0.158858F, 0.166930F, 0.174991F, 0.183040F, 0.191077F,
  0.199101F, 0.207111F, 0.215108F, 0.223091F, 0.231058F, 0.239010F, 0.246946F, 0.254866F,
  0.262768F, 0.270653F, 0.278520F, 0.286368F, 0.294197F, 0.302006F, 0.309795F, 0.317563F,
  0.325310F, 0.333036F, 0.340739F, 0.348419F, 0.356076F, 0.363709F, 0.371317F, 0.378901F,
  0.386459F, 0.393992F, 0.401498F, 0.408978F, 0.416430F, 0.423854F, 0.431249F, 0.438616F,
  0.445954F, 0.453261F, 0.460539F, 0.467785F, 0.475000F, 0.482184F, 0.489335F, 0.496453F,
  0.503538F, 0.510590F, 0.517607F, 0.524590F, 0.531537F, 0.538449F, 0.545325F, 0.552164F,
  0.558967F, 0.565732F, 0.572459F, 0.579148F, 0.585798F, 0.592409F, 0.598980F, 0.605511F,
  0.612002F, 0.618451F, 0.624859F, 0.631226F, 0.637550F, 0.643832F, 0.650070F, 0.656265F,
  0.662416F, 0.668522F, 0.674584F, 0.680601F, 0.686572F, 0.692497F, 0.698376F, 0.704208F,
  0.709993F, 0.715731F, 0.721420F, 0.727062F, 0.732654F, 0.738198F, 0.743692F, 0.749136F,
  0.754531F, 0.759874F, 0.765167F, 0.770409F, 0.775599F, 0.780737F, 0.785823F, 0.790857F,
  0.795837F, 0.800764F, 0.805638F, 0.810457F, 0.815223F, 0.819933F, 0.824589F, 0.829190F,
  0.833735F, 0.838225F, 0.842658F, 0.847035F, 0.851355F, 0.855618F, 0.859824F, 0.863973F,
  0.868063F, 0.872096F, 0.876070F, 0.879986F, 0.883842F, 0.887640F, 0.891378F, 0.895056F,
  0.898674F, 0.902233F, 0.905731F, 0.909168F, 0.912544F, 0.915860F, 0.919114F, 0.922306F,
  0.925437F, 0.928506F, 0.931513F, 0.934457F, 0.937339F, 0.940158F, 0.942914F, 0.945607F,
  0.948237F, 0.950803F, 0.953306F, 0.955745F, 0.958120F, 0.960431F, 0.962677F, 0.964859F,
  0.966976F, 0.969029F, 0.971017F, 0.972940F, 0.974798F, 0.976590F, 0.978317F, 0.979979F,
  0.981575F, 0.983105F, 0.984570F, 0.985969F, 0.987301F, 0.988568F, 0.989768F, 0.990903F,
  0.991970F, 0.992972F, 0.993907F, 0.994775F, 0.995577F, 0.996313F, 0.996981F, 0.997583F,
  0.998118F, 0.998586F, 0.998988F, 0.999322F, 0.999590F, 0.999791F, 0.999925F, 0.999992F
};

const float sineWindow256[256] = {
  0.00306796F, 0.00920375F, 0.01533921F, 0.02147408F, 0.02760815F, 0.03374117F, 0.03987293F, 0.04600318F,
  0.05213170F, 0.05825826F, 0.06438263F, 0.07050457F, 0.07662386F, 0.08274026F, 0.08885355F, 0.09496350F,
  0.10106986F, 0.10717242F, 0.11327095F, 0.11936521F, 0.12545498F, 0.13154003F, 0.13762012F, 0.14369503F,
  0.14976453F, 0.15582840F, 0.16188639F, 0.16793829F, 0.17398387F, 0.18002290F, 0.18605515F, 0.19208040F,
  0.19809841F, 0.20410897F, 0.21011184F, 0.21610680F, 0.22209362F, 0.22807208F, 0.23404196F, 0.24000302F,
  0.24595505F, 0.25189782F, 0.25783110F, 0.26375468F, 0.26966833F, 0.27557182F, 0.28146494F, 0.28734746F,
  0.29321916F, 0.29907983F, 0.30492923F, 0.31076715F, 0.31659338F, 0.32240768F, 0.32820984F, 0.33399965F,
  0.33977688F, 0.34554132F, 0.35129276F, 0.35703096F, 0.36275572F, 0.36846683F, 0.37416406F, 0.37984721F,
  0.38551605F, 0.39117038F, 0.39680999F, 0.40243465F, 0.40804416F, 0.41363831F, 0.41921689F, 0.42477968F,
  0.43032648F, 0.43585708F, 0.44137127F, 0.44686884F, 0.45234959F, 0.45781330F, 0.46325978F, 0.46868882F,
  0.47410021F, 0.47949376F, 0.48486925F, 0.49022648F, 0.49556526F, 0.50088538F, 0.50618665F, 0.51146885F,
  0.51673180F, 0.52197529F, 0.52719913F, 0.53240313F, 0.53758708F, 0.54275078F, 0.54789406F, 0.55301671F,
  0.55811853F, 0.56319934F, 0.56825895F, 0.57329717F, 0.57831380F, 0.58330865F, 0.58828155F, 0.59323230F,
  0.59816071F, 0.60306660F, 0.60794978F, 0.61281008F, 0.61764731F, 0.62246128F, 0.62725182F, 0.63201874F,
  0.63676186F, 0.64148101F, 0.64617601F, 0.65084668F, 0.65549285F, 0.66011434F, 0.66471098F, 0.66928259F,
  0.67382900F, 0.67835004F, 0.68284555F, 0.68731534F, 0.69175926F, 0.69617713F, 0.70056879F, 0.70493408F,
  0.70927283F, 0.71358487F, 0.71787005F, 0.72212819F, 0.72635916F, 0.73056277F, 0.73473888F, 0.73888732F,
  0.74300795F, 0.74710061F, 0.75116513F, 0.75520138F, 0.75920919F, 0.76318842F, 0.76713891F, 0.77106052F,
  0.77495311F, 0.77881651F, 0.78265060F, 0.78645521F, 0.79023022F, 0.79397548F, 0.79769084F, 0.80137617F,
  0.80503133F, 0.80865618F, 0.81225059F, 0.81581441F, 0.81934752F, 0.82284978F, 0.82632106F, 0.82976123F,
  0.83317016F, 0.83654773F, 0.83989379F, 0.84320824F, 0.84649094F, 0.84974177F, 0.85296060F, 0.85614733F,
  0.85930182F, 0.86242396F, 0.86551362F, 0.86857071F, 0.87159509F, 0.87458665F, 0.87754529F, 0.88047089F,
  0.88336334F, 0.88622253F, 0.88904836F, 0.89184071F, 0.89459949F, 0.89732458F, 0.90001589F, 0.90267332F,
  0.90529676F, 0.90788612F, 0.91044129F, 0.91296219F, 0.91544872F, 0.91790078F, 0.92031828F, 0.92270113F,
  0.92504924F, 0.92736253F, 0.92964090F, 0.93188427F, 0.93409255F, 0.93626567F, 0.93840353F, 0.94050607F,
  0.94257320F, 0.94460484F, 0.94660091F, 0.94856135F, 0.95048607F, 0.95237501F, 0.95422810F, 0.95604525F,
  0.95782641F, 0.95957151F, 0.96128049F, 0.96295327F, 0.96458979F, 0.96619000F, 0.96775384F, 0.96928124F,
  0.97077214F, 0.97222650F, 0.97364425F, 0.97502535F, 0.97636973F, 0.97767736F, 0.97894818F, 0.98018214F,
  0.98137919F, 0.98253930F, 0.98366242F, 0.98474850F, 0.98579751F, 0.98680940F, 0.98778414F, 0.98872169F,
  0.98962202F, 0.99048508F, 0.99131086F, 0.99209931F, 0.99285041F, 0.99356414F, 0.99424045F, 0.99487933F,
  0.99548076F, 0.99604470F, 0.99657115F, 0.99706007F, 0.99751146F, 0.99792529F, 0.99830154F, 0.99864022F,
  0.99894129F, 0.99920476F, 0.99943060F, 0.99961882F, 0.99976941F, 0.99988235F, 0.99995764F, 0.99999529F
};

const float sineWindow384[384] =
{
  0.00204531F, 0.00613588F, 0.01022636F, 0.01431666F, 0.01840673F, 0.02249649F, 0.02658587F, 0.03067480F,
  0.03476323F, 0.03885107F, 0.04293826F, 0.04702473F, 0.05111041F, 0.05519524F, 0.05927915F, 0.06336207F,
  0.06744392F, 0.07152465F, 0.07560417F, 0.07968244F, 0.08375937F, 0.08783490F, 0.09190896F, 0.09598148F,
  0.10005239F, 0.10412163F, 0.10818913F, 0.11225482F, 0.11631863F, 0.12038049F, 0.12444034F, 0.12849811F,
  0.13255373F, 0.13660713F, 0.14065824F, 0.14470700F, 0.14875334F, 0.15279719F, 0.15683848F, 0.16087714F,
  0.16491312F, 0.16894634F, 0.17297673F, 0.17700422F, 0.18102875F, 0.18505026F, 0.18906866F, 0.19308391F,
  0.19709592F, 0.20110463F, 0.20510998F, 0.20911190F, 0.21311032F, 0.21710517F, 0.22109639F, 0.22508391F,
  0.22906766F, 0.23304759F, 0.23702361F, 0.24099566F, 0.24496368F, 0.24892761F, 0.25288736F, 0.25684289F,
  0.26079412F, 0.26474098F, 0.26868342F, 0.27262136F, 0.27655473F, 0.28048348F, 0.28440754F, 0.28832683F,
  0.29224131F, 0.29615089F, 0.30005551F, 0.30395512F, 0.30784964F, 0.31173901F, 0.31562316F, 0.31950203F,
  0.32337556F, 0.32724367F, 0.33110631F, 0.33496340F, 0.33881489F, 0.34266072F, 0.34650081F, 0.35033510F,
  0.35416353F, 0.35798603F, 0.36180254F, 0.36561300F, 0.36941734F, 0.37321550F, 0.37700741F, 0.38079302F,
  0.38457225F, 0.38834505F, 0.39211135F, 0.39587109F, 0.39962420F, 0.40337063F, 0.40711031F, 0.41084317F,
  0.41456916F, 0.41828822F, 0.42200027F, 0.42570526F, 0.42940313F, 0.43309382F, 0.43677726F, 0.44045339F,
  0.44412214F, 0.44778347F, 0.45143731F, 0.45508359F, 0.45872225F, 0.46235324F, 0.46597650F, 0.46959195F,
  0.47319955F, 0.47679923F, 0.48039093F, 0.48397460F, 0.48755016F, 0.49111757F, 0.49467676F, 0.49822767F,
  0.50177024F, 0.50530442F, 0.50883014F, 0.51234735F, 0.51585599F, 0.51935599F, 0.52284730F, 0.52632987F,
  0.52980362F, 0.53326852F, 0.53672449F, 0.54017147F, 0.54360942F, 0.54703827F, 0.55045797F, 0.55386846F,
  0.55726968F, 0.56066158F, 0.56404409F, 0.56741717F, 0.57078075F, 0.57413478F, 0.57747920F, 0.58081396F,
  0.58413900F, 0.58745427F, 0.59075970F, 0.59405525F, 0.59734086F, 0.60061648F, 0.60388204F, 0.60713751F,
  0.61038281F, 0.61361789F, 0.61684271F, 0.62005721F, 0.62326133F, 0.62645503F, 0.62963824F, 0.63281091F,
  0.63597300F, 0.63912444F, 0.64226519F, 0.64539520F, 0.64851440F, 0.65162275F, 0.65472020F, 0.65780669F,
  0.66088218F, 0.66394661F, 0.66699992F, 0.67004208F, 0.67307302F, 0.67609270F, 0.67910107F, 0.68209808F,
  0.68508367F, 0.68805780F, 0.69102041F, 0.69397146F, 0.69691090F, 0.69983868F, 0.70275474F, 0.70565905F,
  0.70855155F, 0.71143220F, 0.71430093F, 0.71715772F, 0.72000251F, 0.72283525F, 0.72565589F, 0.72846439F,
  0.73126070F, 0.73404478F, 0.73681657F, 0.73957603F, 0.74232312F, 0.74505779F, 0.74777998F, 0.75048967F,
  0.75318680F, 0.75587132F, 0.75854320F, 0.76120239F, 0.76384883F, 0.76648250F, 0.76910334F, 0.77171131F,
  0.77430637F, 0.77688847F, 0.77945757F, 0.78201362F, 0.78455660F, 0.78708644F, 0.78960312F, 0.79210658F,
  0.79459678F, 0.79707370F, 0.79953727F, 0.80198746F, 0.80442424F, 0.80684755F, 0.80925737F, 0.81165364F,
  0.81403633F, 0.81640540F, 0.81876081F, 0.82110251F, 0.82343048F, 0.82574467F, 0.82804505F, 0.83033156F,
  0.83260418F, 0.83486287F, 0.83710760F, 0.83933831F, 0.84155498F, 0.84375756F, 0.84594603F, 0.84812034F,
  0.85028047F, 0.85242636F, 0.85455799F, 0.85667532F, 0.85877831F, 0.86086694F, 0.86294116F, 0.86500094F,
  0.86704625F, 0.86907704F, 0.87109330F, 0.87309498F, 0.87508205F, 0.87705448F, 0.87901223F, 0.88095527F,
  0.88288357F, 0.88479710F, 0.88669582F, 0.88857971F, 0.89044872F, 0.89230284F, 0.89414203F, 0.89596625F,
  0.89777548F, 0.89956969F, 0.90134885F, 0.90311292F, 0.90486188F, 0.90659570F, 0.90831436F, 0.91001781F,
  0.91170603F, 0.91337900F, 0.91503669F, 0.91667906F, 0.91830609F, 0.91991776F, 0.92151404F, 0.92309490F,
  0.92466030F, 0.92621024F, 0.92774468F, 0.92926360F, 0.93076696F, 0.93225475F, 0.93372694F, 0.93518351F,
  0.93662443F, 0.93804967F, 0.93945922F, 0.94085305F, 0.94223114F, 0.94359346F, 0.94493999F, 0.94627071F,
  0.94758559F, 0.94888462F, 0.95016777F, 0.95143502F, 0.95268635F, 0.95392174F, 0.95514117F, 0.95634461F,
  0.95753206F, 0.95870347F, 0.95985885F, 0.96099817F, 0.96212140F, 0.96322854F, 0.96431956F, 0.96539444F,
  0.96645317F, 0.96749573F, 0.96852209F, 0.96953226F, 0.97052619F, 0.97150389F, 0.97246533F, 0.97341050F,
  0.97433938F, 0.97525196F, 0.97614822F, 0.97702814F, 0.97789172F, 0.97873893F, 0.97956977F, 0.98038421F,
  0.98118225F, 0.98196387F, 0.98272906F, 0.98347780F, 0.98421009F, 0.98492591F, 0.98562525F, 0.98630810F,
  0.98697444F, 0.98762427F, 0.98825757F, 0.98887433F, 0.98947455F, 0.99005821F, 0.99062530F, 0.99117582F,
  0.99170975F, 0.99222709F, 0.99272783F, 0.99321195F, 0.99367945F, 0.99413033F, 0.99456457F, 0.99498217F,
  0.99538312F, 0.99576741F, 0.99613505F, 0.99648601F, 0.99682030F, 0.99713791F, 0.99743883F, 0.99772307F,
  0.99799061F, 0.99824144F, 0.99847558F, 0.99869301F, 0.99889373F, 0.99907773F, 0.99924501F, 0.99939558F,
  0.99952942F, 0.99964653F, 0.99974692F, 0.99983058F, 0.99989751F, 0.99994771F, 0.99998118F, 0.99999791F
};

const float sineWindow512[512] =
{
  0.00153398F, 0.00460193F, 0.00766983F, 0.01073766F, 0.01380539F, 0.01687299F, 0.01994043F, 0.02300768F,
  0.02607472F, 0.02914151F, 0.03220803F, 0.03527424F, 0.03834012F, 0.04140564F, 0.04447077F, 0.04753548F,
  0.05059975F, 0.05366354F, 0.05672682F, 0.05978957F, 0.06285176F, 0.06591335F, 0.06897433F, 0.07203465F,
  0.07509430F, 0.07815324F, 0.08121145F, 0.08426889F, 0.08732554F, 0.09038136F, 0.09343634F, 0.09649043F,
  0.09954362F, 0.10259587F, 0.10564715F, 0.10869744F, 0.11174671F, 0.11479493F, 0.11784206F, 0.12088809F,
  0.12393298F, 0.12697670F, 0.13001922F, 0.13306053F, 0.13610058F, 0.13913934F, 0.14217680F, 0.14521292F,
  0.14824768F, 0.15128104F, 0.15431297F, 0.15734346F, 0.16037246F, 0.16339995F, 0.16642590F, 0.16945029F,
  0.17247308F, 0.17549425F, 0.17851377F, 0.18153161F, 0.18454774F, 0.18756213F, 0.19057475F, 0.19358559F,
  0.19659460F, 0.19960176F, 0.20260704F, 0.20561041F, 0.20861185F, 0.21161133F, 0.21460881F, 0.21760427F,
  0.22059769F, 0.22358903F, 0.22657826F, 0.22956537F, 0.23255031F, 0.23553306F, 0.23851359F, 0.24149189F,
  0.24446790F, 0.24744162F, 0.25041301F, 0.25338204F, 0.25634868F, 0.25931292F, 0.26227471F, 0.26523403F,
  0.26819086F, 0.27114516F, 0.27409691F, 0.27704608F, 0.27999264F, 0.28293657F, 0.28587783F, 0.28881641F,
  0.29175226F, 0.29468537F, 0.29761571F, 0.30054324F, 0.30346795F, 0.30638980F, 0.30930876F, 0.31222481F,
  0.31513793F, 0.31804808F, 0.32095523F, 0.32385937F, 0.32676045F, 0.32965846F, 0.33255337F, 0.33544515F,
  0.33833377F, 0.34121920F, 0.34410143F, 0.34698041F, 0.34985613F, 0.35272856F, 0.35559766F, 0.35846342F,
  0.36132581F, 0.36418479F, 0.36704035F, 0.36989245F, 0.37274107F, 0.37558618F, 0.37842775F, 0.38126577F,
  0.38410020F, 0.38693101F, 0.38975817F, 0.39258167F, 0.39540148F, 0.39821756F, 0.40102990F, 0.40383846F,
  0.40664322F, 0.40944415F, 0.41224123F, 0.41503442F, 0.41782372F, 0.42060907F, 0.42339047F, 0.42616789F,
  0.42894129F, 0.43171066F, 0.43447596F, 0.43723717F, 0.43999427F, 0.44274723F, 0.44549602F, 0.44824061F,
  0.45098099F, 0.45371712F, 0.45644898F, 0.45917655F, 0.46189979F, 0.46461869F, 0.46733321F, 0.47004333F,
  0.47274903F, 0.47545028F, 0.47814706F, 0.48083933F, 0.48352708F, 0.48621028F, 0.48888890F, 0.49156292F,
  0.49423231F, 0.49689705F, 0.49955711F, 0.50221247F, 0.50486311F, 0.50750899F, 0.51015010F, 0.51278640F,
  0.51541788F, 0.51804450F, 0.52066625F, 0.52328310F, 0.52589503F, 0.52850200F, 0.53110400F, 0.53370100F,
  0.53629298F, 0.53887991F, 0.54146177F, 0.54403853F, 0.54661017F, 0.54917666F, 0.55173799F, 0.55429412F,
  0.55684504F, 0.55939071F, 0.56193112F, 0.56446624F, 0.56699605F, 0.56952052F, 0.57203963F, 0.57455336F,
  0.57706167F, 0.57956456F, 0.58206199F, 0.58455394F, 0.58704039F, 0.58952132F, 0.59199669F, 0.59446650F,
  0.59693071F, 0.59938930F, 0.60184225F, 0.60428953F, 0.60673113F, 0.60916701F, 0.61159716F, 0.61402156F,
  0.61644017F, 0.61885299F, 0.62125998F, 0.62366112F, 0.62605639F, 0.62844577F, 0.63082923F, 0.63320676F,
  0.63557832F, 0.63794390F, 0.64030348F, 0.64265703F, 0.64500454F, 0.64734597F, 0.64968131F, 0.65201053F,
  0.65433362F, 0.65665055F, 0.65896129F, 0.66126584F, 0.66356416F, 0.66585623F, 0.66814204F, 0.67042156F,
  0.67269477F, 0.67496165F, 0.67722217F, 0.67947632F, 0.68172407F, 0.68396541F, 0.68620031F, 0.68842875F,
  0.69065071F, 0.69286617F, 0.69507511F, 0.69727751F, 0.69947334F, 0.70166259F, 0.70384524F, 0.70602126F,
  0.70819064F, 0.71035335F, 0.71250937F, 0.71465869F, 0.71680128F, 0.71893712F, 0.72106620F, 0.72318849F,
  0.72530397F, 0.72741263F, 0.72951444F, 0.73160938F, 0.73369744F, 0.73577859F, 0.73785281F, 0.73992010F,
  0.74198041F, 0.74403374F, 0.74608007F, 0.74811938F, 0.75015165F, 0.75217685F, 0.75419498F, 0.75620600F,
  0.75820991F, 0.76020668F, 0.76219630F, 0.76417874F, 0.76615399F, 0.76812203F, 0.77008284F, 0.77203640F,
  0.77398269F, 0.77592170F, 0.77785340F, 0.77977779F, 0.78169483F, 0.78360452F, 0.78550683F, 0.78740175F,
  0.78928925F, 0.79116933F, 0.79304196F, 0.79490713F, 0.79676481F, 0.79861499F, 0.80045766F, 0.80229280F,
  0.80412038F, 0.80594039F, 0.80775282F, 0.80955764F, 0.81135485F, 0.81314441F, 0.81492633F, 0.81670057F,
  0.81846713F, 0.82022598F, 0.82197712F, 0.82372051F, 0.82545615F, 0.82718403F, 0.82890411F, 0.83061640F,
  0.83232087F, 0.83401750F, 0.83570628F, 0.83738720F, 0.83906024F, 0.84072537F, 0.84238260F, 0.84403190F,
  0.84567325F, 0.84730664F, 0.84893206F, 0.85054948F, 0.85215890F, 0.85376030F, 0.85535366F, 0.85693898F,
  0.85851622F, 0.86008539F, 0.86164646F, 0.86319942F, 0.86474426F, 0.86628095F, 0.86780950F, 0.86932987F,
  0.87084206F, 0.87234606F, 0.87384184F, 0.87532940F, 0.87680872F, 0.87827979F, 0.87974259F, 0.88119711F,
  0.88264334F, 0.88408126F, 0.88551086F, 0.88693212F, 0.88834503F, 0.88974959F, 0.89114576F, 0.89253356F,
  0.89391295F, 0.89528392F, 0.89664647F, 0.89800058F, 0.89934624F, 0.90068343F, 0.90201214F, 0.90333237F,
  0.90464409F, 0.90594730F, 0.90724198F, 0.90852812F, 0.90980571F, 0.91107473F, 0.91233518F, 0.91358705F,
  0.91483031F, 0.91606497F, 0.91729100F, 0.91850839F, 0.91971715F, 0.92091724F, 0.92210867F, 0.92329142F,
  0.92446547F, 0.92563083F, 0.92678747F, 0.92793539F, 0.92907458F, 0.93020502F, 0.93132671F, 0.93243963F,
  0.93354377F, 0.93463913F, 0.93572569F, 0.93680344F, 0.93787238F, 0.93893248F, 0.93998375F, 0.94102618F,
  0.94205974F, 0.94308444F, 0.94410026F, 0.94510719F, 0.94610523F, 0.94709437F, 0.94807459F, 0.94904588F,
  0.95000825F, 0.95096167F, 0.95190614F, 0.95284165F, 0.95376819F, 0.95468575F, 0.95559433F, 0.95649392F,
  0.95738450F, 0.95826607F, 0.95913862F, 0.96000215F, 0.96085663F, 0.96170208F, 0.96253847F, 0.96336580F,
  0.96418406F, 0.96499325F, 0.96579336F, 0.96658437F, 0.96736629F, 0.96813910F, 0.96890280F, 0.96965739F,
  0.97040284F, 0.97113916F, 0.97186634F, 0.97258437F, 0.97329325F, 0.97399296F, 0.97468351F, 0.97536489F,
  0.97603708F, 0.97670009F, 0.97735390F, 0.97799851F, 0.97863392F, 0.97926012F, 0.97987710F, 0.98048486F,
  0.98108339F, 0.98167269F, 0.98225274F, 0.98282355F, 0.98338511F, 0.98393741F, 0.98448046F, 0.98501423F,
  0.98553874F, 0.98605396F, 0.98655991F, 0.98705657F, 0.98754394F, 0.98802202F, 0.98849079F, 0.98895026F,
  0.98940043F, 0.98984128F, 0.99027281F, 0.99069503F, 0.99110791F, 0.99151147F, 0.99190570F, 0.99229059F,
  0.99266614F, 0.99303235F, 0.99338921F, 0.99373672F, 0.99407488F, 0.99440368F, 0.99472312F, 0.99503320F,
  0.99533391F, 0.99562526F, 0.99590723F, 0.99617983F, 0.99644305F, 0.99669690F, 0.99694136F, 0.99717644F,
  0.99740213F, 0.99761844F, 0.99782535F, 0.99802287F, 0.99821100F, 0.99838974F, 0.99855907F, 0.99871901F,
  0.99886955F, 0.99901069F, 0.99914242F, 0.99926475F, 0.99937767F, 0.99948119F, 0.99957530F, 0.99966000F,
  0.99973529F, 0.99980117F, 0.99985764F, 0.99990470F, 0.99994235F, 0.99997059F, 0.99998941F, 0.99999882F
};

const float sineWindow1024[1024] =
{
  0.000767F, 0.002301F, 0.003835F, 0.005369F, 0.006903F, 0.008437F, 0.009971F, 0.011505F,
  0.013038F, 0.014572F, 0.016106F, 0.017640F, 0.019174F, 0.020707F, 0.022241F, 0.023774F,
  0.025308F, 0.026841F, 0.028375F, 0.029908F, 0.031441F, 0.032975F, 0.034508F, 0.036041F,
  0.037574F, 0.039107F, 0.040639F, 0.042172F, 0.043705F, 0.045237F, 0.046769F, 0.048302F,
  0.049834F, 0.051366F, 0.052898F, 0.054429F, 0.055961F, 0.057493F, 0.059024F, 0.060555F,
  0.062086F, 0.063617F, 0.065148F, 0.066679F, 0.068209F, 0.069739F, 0.071270F, 0.072800F,
  0.074329F, 0.075859F, 0.077389F, 0.078918F, 0.080447F, 0.081976F, 0.083505F, 0.085033F,
  0.086561F, 0.088090F, 0.089617F, 0.091145F, 0.092673F, 0.094200F, 0.095727F, 0.097254F,
  0.098780F, 0.100307F, 0.101833F, 0.103359F, 0.104884F, 0.106410F, 0.107935F, 0.109460F,
  0.110984F, 0.112509F, 0.114033F, 0.115557F, 0.117080F, 0.118604F, 0.120127F, 0.121649F,
  0.123172F, 0.124694F, 0.126216F, 0.127737F, 0.129259F, 0.130780F, 0.132300F, 0.133821F,
  0.135341F, 0.136860F, 0.138380F, 0.139899F, 0.141418F, 0.142936F, 0.144454F, 0.145972F,
  0.147489F, 0.149006F, 0.150523F, 0.152039F, 0.153555F, 0.155071F, 0.156586F, 0.158101F,
  0.159615F, 0.161129F, 0.162643F, 0.164157F, 0.165670F, 0.167182F, 0.168694F, 0.170206F,
  0.171718F, 0.173229F, 0.174739F, 0.176249F, 0.177759F, 0.179268F, 0.180777F, 0.182286F,
  0.183794F, 0.185301F, 0.186809F, 0.188315F, 0.189822F, 0.191328F, 0.192833F, 0.194338F,
  0.195843F, 0.197347F, 0.198850F, 0.200353F, 0.201856F, 0.203358F, 0.204860F, 0.206361F,
  0.207862F, 0.209362F, 0.210862F, 0.212361F, 0.213860F, 0.215358F, 0.216856F, 0.218353F,
  0.219850F, 0.221346F, 0.222841F, 0.224337F, 0.225831F, 0.227325F, 0.228819F, 0.230312F,
  0.231804F, 0.233296F, 0.234788F, 0.236278F, 0.237769F, 0.239258F, 0.240748F, 0.242236F,
  0.243724F, 0.245212F, 0.246698F, 0.248185F, 0.249670F, 0.251155F, 0.252640F, 0.254124F,
  0.255607F, 0.257090F, 0.258572F, 0.260054F, 0.261534F, 0.263015F, 0.264494F, 0.265973F,
  0.267452F, 0.268930F, 0.270407F, 0.271883F, 0.273359F, 0.274834F, 0.276309F, 0.277783F,
  0.279256F, 0.280729F, 0.282201F, 0.283672F, 0.285143F, 0.286613F, 0.288082F, 0.289551F,
  0.291019F, 0.292486F, 0.293952F, 0.295418F, 0.296883F, 0.298348F, 0.299812F, 0.301275F,
  0.302737F, 0.304199F, 0.305660F, 0.307120F, 0.308579F, 0.310038F, 0.311496F, 0.312953F,
  0.314410F, 0.315866F, 0.317321F, 0.318775F, 0.320229F, 0.321682F, 0.323134F, 0.324585F,
  0.326035F, 0.327485F, 0.328934F, 0.330382F, 0.331830F, 0.333277F, 0.334723F, 0.336168F,
  0.337612F, 0.339055F, 0.340498F, 0.341940F, 0.343381F, 0.344821F, 0.346261F, 0.347700F,
  0.349138F, 0.350575F, 0.352011F, 0.353446F, 0.354881F, 0.356314F, 0.357747F, 0.359179F,
  0.360611F, 0.362041F, 0.363470F, 0.364899F, 0.366327F, 0.367754F, 0.369180F, 0.370605F,
  0.372029F, 0.373453F, 0.374875F, 0.376297F, 0.377718F, 0.379138F, 0.380557F, 0.381975F,
  0.383392F, 0.384808F, 0.386224F, 0.387638F, 0.389052F, 0.390464F, 0.391876F, 0.393287F,
  0.394697F, 0.396106F, 0.397514F, 0.398921F, 0.400327F, 0.401732F, 0.403137F, 0.404540F,
  0.405942F, 0.407344F, 0.408744F, 0.410144F, 0.411542F, 0.412940F, 0.414337F, 0.415732F,
  0.417127F, 0.418520F, 0.419913F, 0.421305F, 0.422696F, 0.424085F, 0.425474F, 0.426862F,
  0.428248F, 0.429634F, 0.431019F, 0.432402F, 0.433785F, 0.435167F, 0.436547F, 0.437927F,
  0.439305F, 0.440683F, 0.442059F, 0.443435F, 0.444809F, 0.446183F, 0.447555F, 0.448926F,
  0.450296F, 0.451665F, 0.453034F, 0.454401F, 0.455766F, 0.457131F, 0.458495F, 0.459858F,
  0.461219F, 0.462580F, 0.463939F, 0.465298F, 0.466655F, 0.468011F, 0.469366F, 0.470720F,
  0.472073F, 0.473425F, 0.474775F, 0.476125F, 0.477473F, 0.478821F, 0.480167F, 0.481512F,
  0.482856F, 0.484198F, 0.485540F, 0.486880F, 0.488220F, 0.489558F, 0.490895F, 0.492231F,
  0.493565F, 0.494899F, 0.496231F, 0.497563F, 0.498893F, 0.500221F, 0.501549F, 0.502876F,
  0.504201F, 0.505525F, 0.506848F, 0.508170F, 0.509490F, 0.510810F, 0.512128F, 0.513445F,
  0.514760F, 0.516075F, 0.517388F, 0.518700F, 0.520011F, 0.521321F, 0.522629F, 0.523937F,
  0.525243F, 0.526547F, 0.527851F, 0.529153F, 0.530454F, 0.531754F, 0.533052F, 0.534350F,
  0.535645F, 0.536940F, 0.538234F, 0.539526F, 0.540817F, 0.542106F, 0.543395F, 0.544682F,
  0.545968F, 0.547252F, 0.548536F, 0.549818F, 0.551098F, 0.552378F, 0.553656F, 0.554932F,
  0.556208F, 0.557482F, 0.558755F, 0.560026F, 0.561297F, 0.562565F, 0.563833F, 0.565099F,
  0.566364F, 0.567628F, 0.568890F, 0.570151F, 0.571410F, 0.572669F, 0.573925F, 0.575181F,
  0.576435F, 0.577688F, 0.578939F, 0.580189F, 0.581438F, 0.582686F, 0.583932F, 0.585176F,
  0.586419F, 0.587661F, 0.588902F, 0.590141F, 0.591378F, 0.592615F, 0.593850F, 0.595083F,
  0.596315F, 0.597546F, 0.598775F, 0.600003F, 0.601230F, 0.602455F, 0.603678F, 0.604900F,
  0.606121F, 0.607341F, 0.608559F, 0.609775F, 0.610990F, 0.612204F, 0.613416F, 0.614627F,
  0.615836F, 0.617044F, 0.618250F, 0.619455F, 0.620659F, 0.621861F, 0.623061F, 0.624260F,
  0.625458F, 0.626654F, 0.627849F, 0.629042F, 0.630234F, 0.631424F, 0.632613F, 0.633800F,
  0.634986F, 0.636170F, 0.637353F, 0.638534F, 0.639714F, 0.640892F, 0.642069F, 0.643245F,
  0.644418F, 0.645590F, 0.646761F, 0.647930F, 0.649098F, 0.650264F, 0.651429F, 0.652592F,
  0.653753F, 0.654913F, 0.656072F, 0.657229F, 0.658384F, 0.659538F, 0.660690F, 0.661841F,
  0.662990F, 0.664138F, 0.665284F, 0.666428F, 0.667571F, 0.668713F, 0.669852F, 0.670990F,
  0.672127F, 0.673262F, 0.674396F, 0.675527F, 0.676658F, 0.677786F, 0.678913F, 0.680039F,
  0.681163F, 0.682285F, 0.683406F, 0.684525F, 0.685642F, 0.686758F, 0.687872F, 0.688985F,
  0.690096F, 0.691205F, 0.692313F, 0.693419F, 0.694524F, 0.695626F, 0.696728F, 0.697827F,
  0.698925F, 0.700021F, 0.701116F, 0.702209F, 0.703300F, 0.704390F, 0.705478F, 0.706564F,
  0.707649F, 0.708732F, 0.709813F, 0.710893F, 0.711971F, 0.713047F, 0.714122F, 0.715195F,
  0.716266F, 0.717336F, 0.718404F, 0.719470F, 0.720535F, 0.721597F, 0.722659F, 0.723718F,
  0.724776F, 0.725832F, 0.726886F, 0.727939F, 0.728990F, 0.730039F, 0.731086F, 0.732132F,
  0.733176F, 0.734218F, 0.735259F, 0.736298F, 0.737335F, 0.738370F, 0.739404F, 0.740436F,
  0.741466F, 0.742494F, 0.743521F, 0.744546F, 0.745569F, 0.746591F, 0.747610F, 0.748628F,
  0.749644F, 0.750659F, 0.751671F, 0.752682F, 0.753691F, 0.754698F, 0.755704F, 0.756708F,
  0.757710F, 0.758710F, 0.759708F, 0.760705F, 0.761700F, 0.762693F, 0.763684F, 0.764673F,
  0.765661F, 0.766647F, 0.767631F, 0.768613F, 0.769593F, 0.770572F, 0.771549F, 0.772524F,
  0.773497F, 0.774468F, 0.775438F, 0.776405F, 0.777371F, 0.778335F, 0.779297F, 0.780258F,
  0.781216F, 0.782173F, 0.783128F, 0.784081F, 0.785032F, 0.785981F, 0.786929F, 0.787874F,
  0.788818F, 0.789760F, 0.790700F, 0.791638F, 0.792575F, 0.793509F, 0.794442F, 0.795372F,
  0.796301F, 0.797228F, 0.798153F, 0.799076F, 0.799998F, 0.800917F, 0.801835F, 0.802750F,
  0.803664F, 0.804576F, 0.805486F, 0.806394F, 0.807300F, 0.808205F, 0.809107F, 0.810008F,
  0.810906F, 0.811803F, 0.812698F, 0.813591F, 0.814482F, 0.815371F, 0.816258F, 0.817143F,
  0.818026F, 0.818908F, 0.819787F, 0.820665F, 0.821540F, 0.822414F, 0.823285F, 0.824155F,
  0.825023F, 0.825889F, 0.826753F, 0.827615F, 0.828475F, 0.829333F, 0.830189F, 0.831043F,
  0.831895F, 0.832746F, 0.833594F, 0.834440F, 0.835285F, 0.836127F, 0.836968F, 0.837806F,
  0.838643F, 0.839477F, 0.840310F, 0.841140F, 0.841969F, 0.842796F, 0.843620F, 0.844443F,
  0.845264F, 0.846082F, 0.846899F, 0.847714F, 0.848526F, 0.849337F, 0.850146F, 0.850953F,
  0.851757F, 0.852560F, 0.853361F, 0.854159F, 0.854956F, 0.855751F, 0.856543F, 0.857334F,
  0.858123F, 0.858909F, 0.859694F, 0.860476F, 0.861257F, 0.862035F, 0.862812F, 0.863586F,
  0.864359F, 0.865129F, 0.865898F, 0.866664F, 0.867428F, 0.868190F, 0.868951F, 0.869709F,
  0.870465F, 0.871219F, 0.871971F, 0.872721F, 0.873469F, 0.874215F, 0.874958F, 0.875700F,
  0.876440F, 0.877177F, 0.877913F, 0.878646F, 0.879378F, 0.880107F, 0.880834F, 0.881559F,
  0.882283F, 0.883004F, 0.883723F, 0.884439F, 0.885154F, 0.885867F, 0.886578F, 0.887286F,
  0.887993F, 0.888697F, 0.889399F, 0.890099F, 0.890797F, 0.891493F, 0.892187F, 0.892879F,
  0.893569F, 0.894256F, 0.894942F, 0.895625F, 0.896307F, 0.896986F, 0.897663F, 0.898338F,
  0.899011F, 0.899681F, 0.900350F, 0.901016F, 0.901681F, 0.902343F, 0.903003F, 0.903661F,
  0.904317F, 0.904971F, 0.905622F, 0.906272F, 0.906919F, 0.907564F, 0.908207F, 0.908848F,
  0.909487F, 0.910124F, 0.910758F, 0.911391F, 0.912021F, 0.912649F, 0.913275F, 0.913899F,
  0.914520F, 0.915140F, 0.915757F, 0.916372F, 0.916985F, 0.917596F, 0.918205F, 0.918811F,
  0.919416F, 0.920018F, 0.920618F, 0.921216F, 0.921812F, 0.922405F, 0.922997F, 0.923586F,
  0.924173F, 0.924758F, 0.925340F, 0.925921F, 0.926499F, 0.927075F, 0.927649F, 0.928221F,
  0.928791F, 0.929358F, 0.929923F, 0.930486F, 0.931047F, 0.931606F, 0.932162F, 0.932716F,
  0.933269F, 0.933818F, 0.934366F, 0.934912F, 0.935455F, 0.935996F, 0.936535F, 0.937072F,
  0.937606F, 0.938138F, 0.938668F, 0.939196F, 0.939722F, 0.940245F, 0.940766F, 0.941285F,
  0.941802F, 0.942317F, 0.942829F, 0.943339F, 0.943847F, 0.944353F, 0.944856F, 0.945358F,
  0.945857F, 0.946353F, 0.946848F, 0.947340F, 0.947830F, 0.948318F, 0.948804F, 0.949287F,
  0.949768F, 0.950247F, 0.950724F, 0.951199F, 0.951671F, 0.952141F, 0.952609F, 0.953074F,
  0.953537F, 0.953998F, 0.954457F, 0.954914F, 0.955368F, 0.955820F, 0.956270F, 0.956717F,
  0.957163F, 0.957606F, 0.958047F, 0.958485F, 0.958921F, 0.959355F, 0.959787F, 0.960217F,
  0.960644F, 0.961069F, 0.961492F, 0.961912F, 0.962330F, 0.962746F, 0.963160F, 0.963571F,
  0.963980F, 0.964387F, 0.964792F, 0.965194F, 0.965594F, 0.965992F, 0.966388F, 0.966781F,
  0.967172F, 0.967560F, 0.967947F, 0.968331F, 0.968713F, 0.969092F, 0.969470F, 0.969845F,
  0.970217F, 0.970588F, 0.970956F, 0.971322F, 0.971685F, 0.972047F, 0.972406F, 0.972762F,
  0.973117F, 0.973469F, 0.973819F, 0.974166F, 0.974512F, 0.974855F, 0.975195F, 0.975534F,
  0.975870F, 0.976204F, 0.976535F, 0.976864F, 0.977191F, 0.977516F, 0.977838F, 0.978158F,
  0.978476F, 0.978791F, 0.979104F, 0.979415F, 0.979724F, 0.980030F, 0.980334F, 0.980635F,
  0.980935F, 0.981232F, 0.981526F, 0.981819F, 0.982109F, 0.982396F, 0.982682F, 0.982965F,
  0.983246F, 0.983524F, 0.983800F, 0.984074F, 0.984346F, 0.984615F, 0.984882F, 0.985146F,
  0.985408F, 0.985668F, 0.985926F, 0.986181F, 0.986434F, 0.986685F, 0.986933F, 0.987179F,
  0.987423F, 0.987664F, 0.987903F, 0.988140F, 0.988374F, 0.988607F, 0.988836F, 0.989064F,
  0.989289F, 0.989511F, 0.989732F, 0.989950F, 0.990166F, 0.990379F, 0.990590F, 0.990799F,
  0.991006F, 0.991210F, 0.991411F, 0.991611F, 0.991808F, 0.992003F, 0.992195F, 0.992385F,
  0.992573F, 0.992759F, 0.992942F, 0.993122F, 0.993301F, 0.993477F, 0.993651F, 0.993822F,
  0.993991F, 0.994158F, 0.994322F, 0.994484F, 0.994644F, 0.994802F, 0.994957F, 0.995109F,
  0.995260F, 0.995408F, 0.995553F, 0.995697F, 0.995838F, 0.995976F, 0.996113F, 0.996247F,
  0.996378F, 0.996507F, 0.996634F, 0.996759F, 0.996881F, 0.997001F, 0.997119F, 0.997234F,
  0.997347F, 0.997457F, 0.997565F, 0.997671F, 0.997774F, 0.997876F, 0.997974F, 0.998071F,
  0.998165F, 0.998257F, 0.998346F, 0.998433F, 0.998518F, 0.998600F, 0.998680F, 0.998758F,
  0.998833F, 0.998906F, 0.998976F, 0.999044F, 0.999110F, 0.999174F, 0.999235F, 0.999294F,
  0.999350F, 0.999404F, 0.999456F, 0.999506F, 0.999553F, 0.999597F, 0.999640F, 0.999680F,
  0.999717F, 0.999753F, 0.999786F, 0.999816F, 0.999844F, 0.999870F, 0.999894F, 0.999915F,
  0.999934F, 0.999950F, 0.999964F, 0.999976F, 0.999986F, 0.999993F, 0.999997F, 1.000000F
};

/* KBD window shapes: */
const float kbdWindow64[64] =
{
  0.000062F, 0.000287F, 0.000716F, 0.001451F, 0.002613F, 0.004347F, 0.006823F, 0.010231F,
  0.014781F, 0.020698F, 0.028215F, 0.037570F, 0.048994F, 0.062705F, 0.078899F, 0.097740F,
  0.119352F, 0.143809F, 0.171132F, 0.201280F, 0.234147F, 0.269561F, 0.307287F, 0.347026F,
  0.388424F, 0.431078F, 0.474547F, 0.518363F, 0.562046F, 0.605114F, 0.647102F, 0.687569F,
  0.726119F, 0.762404F, 0.796139F, 0.827106F, 0.855161F, 0.880230F, 0.902315F, 0.921481F,
  0.937855F, 0.951617F, 0.962983F, 0.972201F, 0.979534F, 0.985248F, 0.989605F, 0.992852F,
  0.995212F, 0.996883F, 0.998032F, 0.998799F, 0.999294F, 0.999602F, 0.999786F, 0.999891F,
  0.999948F, 0.999977F, 0.999991F, 0.999997F, 0.999999F, 1.000000F, 1.000000F, 1.000000F
};

const float kbdWindow96[96] =
{
  0.000051F, 0.000166F, 0.000355F, 0.000643F, 0.001058F, 0.001636F, 0.002413F, 0.003434F,
  0.004745F, 0.006400F, 0.008454F, 0.010968F, 0.014006F, 0.017634F, 0.021922F, 0.026939F,
  0.032755F, 0.039440F, 0.047061F, 0.055684F, 0.065368F, 0.076169F, 0.088136F, 0.101309F,
  0.115721F, 0.131394F, 0.148339F, 0.166557F, 0.186035F, 0.206749F, 0.228661F, 0.251721F,
  0.275863F, 0.301013F, 0.327081F, 0.353968F, 0.381563F, 0.409748F, 0.438395F, 0.467369F,
  0.496534F, 0.525746F, 0.554862F, 0.583741F, 0.612241F, 0.640227F, 0.667568F, 0.694143F,
  0.719837F, 0.744549F, 0.768186F, 0.790671F, 0.811940F, 0.831942F, 0.850642F, 0.868017F,
  0.884062F, 0.898783F, 0.912199F, 0.924343F, 0.935258F, 0.944996F, 0.953620F, 0.961197F,
  0.967800F, 0.973506F, 0.978394F, 0.982543F, 0.986032F, 0.988937F, 0.991330F, 0.993282F,
  0.994855F, 0.996108F, 0.997095F, 0.997861F, 0.998448F, 0.998892F, 0.999222F, 0.999463F,
  0.999637F, 0.999760F, 0.999844F, 0.999902F, 0.999940F, 0.999964F, 0.999979F, 0.999989F,
  0.999994F, 0.999997F, 0.999999F, 0.999999F, 1.000000F, 1.000000F, 1.000000F, 1.000000F
};

const float kbdWindow128[128] =
{
  0.000044F, 0.000119F, 0.000231F, 0.000389F, 0.000606F, 0.000892F, 0.001262F, 0.001730F,
  0.002314F, 0.003031F, 0.003902F, 0.004947F, 0.006189F, 0.007651F, 0.009360F, 0.011340F,
  0.013620F, 0.016227F, 0.019190F, 0.022539F, 0.026303F, 0.030512F, 0.035195F, 0.040381F,
  0.046099F, 0.052375F, 0.059236F, 0.066706F, 0.074808F, 0.083563F, 0.092988F, 0.103099F,
  0.113909F, 0.125427F, 0.137659F, 0.150608F, 0.164272F, 0.178647F, 0.193722F, 0.209486F,
  0.225920F, 0.243003F, 0.260711F, 0.279012F, 0.297874F, 0.317259F, 0.337126F, 0.357432F,
  0.378127F, 0.399163F, 0.420486F, 0.442041F, 0.463771F, 0.485618F, 0.507521F, 0.529420F,
  0.551256F, 0.572968F, 0.594497F, 0.615784F, 0.636772F, 0.657406F, 0.677634F, 0.697406F,
  0.716676F, 0.735399F, 0.753536F, 0.771052F, 0.787915F, 0.804098F, 0.819577F, 0.834336F,
  0.848360F, 0.861640F, 0.874171F, 0.885955F, 0.896995F, 0.907299F, 0.916880F, 0.925754F,
  0.933939F, 0.941459F, 0.948339F, 0.954605F, 0.960288F, 0.965417F, 0.970025F, 0.974146F,
  0.977812F, 0.981056F, 0.983913F, 0.986415F, 0.988594F, 0.990480F, 0.992103F, 0.993491F,
  0.994671F, 0.995667F, 0.996503F, 0.997198F, 0.997773F, 0.998244F, 0.998627F, 0.998937F,
  0.999184F, 0.999380F, 0.999534F, 0.999654F, 0.999746F, 0.999816F, 0.999868F, 0.999907F,
  0.999936F, 0.999956F, 0.999971F, 0.999981F, 0.999988F, 0.999992F, 0.999995F, 0.999997F,
  0.999999F, 0.999999F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F,
};

const float kbdWindow192[192] =
{
  0.000036F, 0.000079F, 0.000137F, 0.000212F, 0.000307F, 0.000425F, 0.000569F, 0.000744F,
  0.000952F, 0.001199F, 0.001488F, 0.001825F, 0.002215F, 0.002663F, 0.003174F, 0.003755F,
  0.004411F, 0.005150F, 0.005979F, 0.006903F, 0.007932F, 0.009071F, 0.010329F, 0.011715F,
  0.013235F, 0.014899F, 0.016715F, 0.018691F, 0.020836F, 0.023160F, 0.025670F, 0.028375F,
  0.031285F, 0.034408F, 0.037752F, 0.041326F, 0.045138F, 0.049197F, 0.053510F, 0.058085F,
  0.062928F, 0.068048F, 0.073450F, 0.079141F, 0.085125F, 0.091409F, 0.097997F, 0.104893F,
  0.112100F, 0.119622F, 0.127459F, 0.135614F, 0.144088F, 0.152880F, 0.161990F, 0.171415F,
  0.181155F, 0.191206F, 0.201563F, 0.212223F, 0.223179F, 0.234426F, 0.245955F, 0.257760F,
  0.269831F, 0.282159F, 0.294733F, 0.307543F, 0.320577F, 0.333821F, 0.347264F, 0.360891F,
  0.374688F, 0.388640F, 0.402731F, 0.416946F, 0.431268F, 0.445681F, 0.460167F, 0.474709F,
  0.489290F, 0.503891F, 0.518495F, 0.533085F, 0.547642F, 0.562148F, 0.576585F, 0.590937F,
  0.605185F, 0.619314F, 0.633305F, 0.647143F, 0.660812F, 0.674297F, 0.687582F, 0.700655F,
  0.713500F, 0.726106F, 0.738460F, 0.750551F, 0.762369F, 0.773902F, 0.785144F, 0.796085F,
  0.806718F, 0.817037F, 0.827037F, 0.836713F, 0.846062F, 0.855080F, 0.863767F, 0.872121F,
  0.880143F, 0.887833F, 0.895192F, 0.902224F, 0.908931F, 0.915318F, 0.921390F, 0.927151F,
  0.932608F, 0.937767F, 0.942636F, 0.947223F, 0.951534F, 0.955580F, 0.959368F, 0.962908F,
  0.966209F, 0.969281F, 0.972134F, 0.974777F, 0.977221F, 0.979475F, 0.981550F, 0.983455F,
  0.985199F, 0.986793F, 0.988245F, 0.989565F, 0.990762F, 0.991844F, 0.992820F, 0.993697F,
  0.994483F, 0.995187F, 0.995813F, 0.996370F, 0.996863F, 0.997299F, 0.997682F, 0.998018F,
  0.998312F, 0.998567F, 0.998789F, 0.998981F, 0.999146F, 0.999287F, 0.999408F, 0.999511F,
  0.999597F, 0.999670F, 0.999732F, 0.999783F, 0.999825F, 0.999860F, 0.999889F, 0.999912F,
  0.999931F, 0.999947F, 0.999959F, 0.999969F, 0.999976F, 0.999982F, 0.999987F, 0.999990F,
  0.999993F, 0.999995F, 0.999996F, 0.999998F, 0.999998F, 0.999999F, 0.999999F, 1.000000F,
  1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F
};

const float kbdWindow256[256] =
{
  0.000031F, 0.000061F, 0.000099F, 0.000146F, 0.000202F, 0.000269F, 0.000349F, 0.000442F, 0.000551F,
  0.000676F, 0.000819F, 0.000983F, 0.001168F, 0.001377F, 0.001611F, 0.001873F, 0.002166F,
  0.002490F, 0.002849F, 0.003245F, 0.003681F, 0.004159F, 0.004682F, 0.005253F, 0.005874F,
  0.006549F, 0.007281F, 0.008073F, 0.008927F, 0.009848F, 0.010839F, 0.011903F, 0.013044F,
  0.014264F, 0.015568F, 0.016960F, 0.018442F, 0.020019F, 0.021694F, 0.023471F, 0.025354F,
  0.027346F, 0.029451F, 0.031673F, 0.034015F, 0.036481F, 0.039075F, 0.041800F, 0.044659F,
  0.047657F, 0.050795F, 0.054079F, 0.057510F, 0.061092F, 0.064828F, 0.068720F, 0.072772F,
  0.076986F, 0.081363F, 0.085908F, 0.090621F, 0.095505F, 0.100561F, 0.105791F, 0.111197F,
  0.116779F, 0.122538F, 0.128476F, 0.134592F, 0.140888F, 0.147363F, 0.154016F, 0.160849F,
  0.167859F, 0.175047F, 0.182410F, 0.189948F, 0.197659F, 0.205541F, 0.213592F, 0.221809F,
  0.230190F, 0.238732F, 0.247431F, 0.256285F, 0.265289F, 0.274439F, 0.283732F, 0.293163F,
  0.302727F, 0.312419F, 0.322235F, 0.332168F, 0.342214F, 0.352366F, 0.362619F, 0.372967F,
  0.383403F, 0.393920F, 0.404513F, 0.415174F, 0.425896F, 0.436673F, 0.447498F, 0.458362F,
  0.469259F, 0.480182F, 0.491122F, 0.502073F, 0.513027F, 0.523976F, 0.534913F, 0.545831F,
  0.556721F, 0.567576F, 0.578389F, 0.589153F, 0.599859F, 0.610502F, 0.621074F, 0.631567F,
  0.641975F, 0.652292F, 0.662510F, 0.672623F, 0.682625F, 0.692511F, 0.702273F, 0.711907F,
  0.721407F, 0.730768F, 0.739985F, 0.749053F, 0.757968F, 0.766725F, 0.775321F, 0.783752F,
  0.792015F, 0.800105F, 0.808022F, 0.815761F, 0.823321F, 0.830700F, 0.837896F, 0.844907F,
  0.851733F, 0.858373F, 0.864825F, 0.871091F, 0.877169F, 0.883061F, 0.888766F, 0.894285F,
  0.899620F, 0.904772F, 0.909742F, 0.914532F, 0.919145F, 0.923581F, 0.927845F, 0.931937F,
  0.935862F, 0.939622F, 0.943220F, 0.946660F, 0.949944F, 0.953077F, 0.956063F, 0.958904F,
  0.961604F, 0.964169F, 0.966601F, 0.968906F, 0.971086F, 0.973146F, 0.975090F, 0.976923F,
  0.978648F, 0.980271F, 0.981794F, 0.983223F, 0.984560F, 0.985811F, 0.986979F, 0.988068F,
  0.989083F, 0.990026F, 0.990901F, 0.991713F, 0.992464F, 0.993158F, 0.993798F, 0.994388F,
  0.994931F, 0.995429F, 0.995885F, 0.996303F, 0.996684F, 0.997032F, 0.997349F, 0.997636F,
  0.997896F, 0.998132F, 0.998345F, 0.998537F, 0.998709F, 0.998864F, 0.999002F, 0.999126F,
  0.999236F, 0.999334F, 0.999421F, 0.999498F, 0.999566F, 0.999626F, 0.999679F, 0.999725F,
  0.999765F, 0.999800F, 0.999830F, 0.999856F, 0.999879F, 0.999898F, 0.999915F, 0.999929F,
  0.999941F, 0.999951F, 0.999960F, 0.999967F, 0.999973F, 0.999979F, 0.999983F, 0.999986F,
  0.999989F, 0.999991F, 0.999993F, 0.999995F, 0.999996F, 0.999997F, 0.999998F, 0.999998F,
  0.999999F, 0.999999F, 0.999999F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F,
  1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F, 1.000000F
};

const float kbdWindow384[384] =
{
  0.00011104F, 0.00018417F, 0.00026043F, 0.00034310F, 0.00043356F, 0.00053270F, 0.00064125F, 0.00075983F,
  0.00088905F, 0.00102953F, 0.00118185F, 0.00134661F, 0.00152443F, 0.00171593F, 0.00192173F, 0.00214249F,
  0.00237884F, 0.00263146F, 0.00290101F, 0.00318820F, 0.00349371F, 0.00381826F, 0.00416256F, 0.00452736F,
  0.00491339F, 0.00532141F, 0.00575218F, 0.00620648F, 0.00668508F, 0.00718877F, 0.00771837F, 0.00827467F,
  0.00885849F, 0.00947066F, 0.01011199F, 0.01078334F, 0.01148554F, 0.01221943F, 0.01298587F, 0.01378571F,
  0.01461982F, 0.01548905F, 0.01639427F, 0.01733634F, 0.01831614F, 0.01933452F, 0.02039236F, 0.02149053F,
  0.02262989F, 0.02381130F, 0.02503563F, 0.02630372F, 0.02761645F, 0.02897464F, 0.03037916F, 0.03183083F,
  0.03333048F, 0.03487894F, 0.03647701F, 0.03812552F, 0.03982523F, 0.04157696F, 0.04338145F, 0.04523949F,
  0.04715180F, 0.04911914F, 0.05114221F, 0.05322172F, 0.05535837F, 0.05755282F, 0.05980572F, 0.06211773F,
  0.06448944F, 0.06692147F, 0.06941439F, 0.07196876F, 0.07458512F, 0.07726398F, 0.08000583F, 0.08281114F,
  0.08568035F, 0.08861388F, 0.09161213F, 0.09467546F, 0.09780422F, 0.10099871F, 0.10425922F, 0.10758602F,
  0.11097932F, 0.11443933F, 0.11796621F, 0.12156011F, 0.12522113F, 0.12894935F, 0.13274481F, 0.13660753F,
  0.14053749F, 0.14453463F, 0.14859886F, 0.15273008F, 0.15692812F, 0.16119280F, 0.16552390F, 0.16992117F,
  0.17438430F, 0.17891298F, 0.18350685F, 0.18816552F, 0.19288854F, 0.19767546F, 0.20252578F, 0.20743896F,
  0.21241444F, 0.21745160F, 0.22254980F, 0.22770838F, 0.23292661F, 0.23820376F, 0.24353905F, 0.24893166F,
  0.25438074F, 0.25988543F, 0.26544479F, 0.27105790F, 0.27672376F, 0.28244137F, 0.28820968F, 0.29402762F,
  0.29989409F, 0.30580796F, 0.31176805F, 0.31777317F, 0.32382211F, 0.32991361F, 0.33604640F, 0.34221917F,
  0.34843060F, 0.35467933F, 0.36096397F, 0.36728314F, 0.37363540F, 0.38001930F, 0.38643339F, 0.39287616F,
  0.39934612F, 0.40584174F, 0.41236146F, 0.41890373F, 0.42546698F, 0.43204961F, 0.43865002F, 0.44526659F,
  0.45189768F, 0.45854167F, 0.46519689F, 0.47186168F, 0.47853439F, 0.48521334F, 0.49189684F, 0.49858322F,
  0.50527078F, 0.51195784F, 0.51864270F, 0.52532369F, 0.53199909F, 0.53866724F, 0.54532644F, 0.55197501F,
  0.55861128F, 0.56523357F, 0.57184024F, 0.57842962F, 0.58500008F, 0.59154998F, 0.59807770F, 0.60458164F,
  0.61106020F, 0.61751180F, 0.62393489F, 0.63032792F, 0.63668936F, 0.64301771F, 0.64931147F, 0.65556920F,
  0.66178942F, 0.66797074F, 0.67411175F, 0.68021108F, 0.68626738F, 0.69227934F, 0.69824565F, 0.70416505F,
  0.71003632F, 0.71585824F, 0.72162963F, 0.72734935F, 0.73301629F, 0.73862937F, 0.74418753F, 0.74968977F,
  0.75513511F, 0.76052259F, 0.76585131F, 0.77112039F, 0.77632900F, 0.78147633F, 0.78656162F, 0.79158413F,
  0.79654319F, 0.80143812F, 0.80626833F, 0.81103323F, 0.81573229F, 0.82036500F, 0.82493091F, 0.82942959F,
  0.83386065F, 0.83822376F, 0.84251861F, 0.84674492F, 0.85090248F, 0.85499108F, 0.85901058F, 0.86296086F,
  0.86684184F, 0.87065349F, 0.87439580F, 0.87806881F, 0.88167259F, 0.88520724F, 0.88867291F, 0.89206978F,
  0.89539805F, 0.89865798F, 0.90184984F, 0.90497395F, 0.90803065F, 0.91102032F, 0.91394337F, 0.91680024F,
  0.91959139F, 0.92231732F, 0.92497856F, 0.92757565F, 0.93010919F, 0.93257976F, 0.93498801F, 0.93733458F,
  0.93962016F, 0.94184543F, 0.94401113F, 0.94611798F, 0.94816676F, 0.95015824F, 0.95209322F, 0.95397250F,
  0.95579692F, 0.95756732F, 0.95928456F, 0.96094951F, 0.96256305F, 0.96412606F, 0.96563946F, 0.96710415F,
  0.96852105F, 0.96989109F, 0.97121520F, 0.97249432F, 0.97372938F, 0.97492132F, 0.97607111F, 0.97717967F,
  0.97824796F, 0.97927693F, 0.98026752F, 0.98122067F, 0.98213733F, 0.98301843F, 0.98386490F, 0.98467767F,
  0.98545766F, 0.98620578F, 0.98692294F, 0.98761003F, 0.98826794F, 0.98889756F, 0.98949974F, 0.99007536F,
  0.99062525F, 0.99115025F, 0.99165118F, 0.99212886F, 0.99258407F, 0.99301761F, 0.99343024F, 0.99382272F,
  0.99419578F, 0.99455016F, 0.99488656F, 0.99520567F, 0.99550819F, 0.99579477F, 0.99606605F, 0.99632268F,
  0.99656526F, 0.99679440F, 0.99701067F, 0.99721465F, 0.99740689F, 0.99758791F, 0.99775825F, 0.99791839F,
  0.99806883F, 0.99821004F, 0.99834246F, 0.99846655F, 0.99858272F, 0.99869138F, 0.99879293F, 0.99888774F,
  0.99897617F, 0.99905858F, 0.99913530F, 0.99920666F, 0.99927296F, 0.99933449F, 0.99939154F, 0.99944439F,
  0.99949327F, 0.99953845F, 0.99958015F, 0.99961859F, 0.99965400F, 0.99968656F, 0.99971647F, 0.99974391F,
  0.99976905F, 0.99979205F, 0.99981307F, 0.99983225F, 0.99984971F, 0.99986560F, 0.99988004F, 0.99989312F,
  0.99990497F, 0.99991568F, 0.99992534F, 0.99993404F, 0.99994186F, 0.99994887F, 0.99995515F, 0.99996076F,
  0.99996576F, 0.99997021F, 0.99997416F, 0.99997765F, 0.99998074F, 0.99998346F, 0.99998584F, 0.99998793F,
  0.99998975F, 0.99999134F, 0.99999271F, 0.99999390F, 0.99999492F, 0.99999579F, 0.99999654F, 0.99999717F,
  0.99999770F, 0.99999815F, 0.99999853F, 0.99999884F, 0.99999909F, 0.99999930F, 0.99999947F, 0.99999960F,
  0.99999971F, 0.99999979F, 0.99999986F, 0.99999991F, 0.99999994F, 0.99999997F, 0.99999998F, 0.99999999F
};

const float kbdWindow512[512] =
{
  0.00009616F, 0.00015332F, 0.00020977F, 0.00026861F, 0.00033101F, 0.00039762F, 0.00046888F, 0.00054514F,
  0.00062669F, 0.00071382F, 0.00080680F, 0.00090587F, 0.00101131F, 0.00112335F, 0.00124226F, 0.00136829F,
  0.00150171F, 0.00164276F, 0.00179173F, 0.00194888F, 0.00211448F, 0.00228881F, 0.00247214F, 0.00266476F,
  0.00286695F, 0.00307901F, 0.00330123F, 0.00353391F, 0.00377735F, 0.00403184F, 0.00429771F, 0.00457526F,
  0.00486480F, 0.00516666F, 0.00548116F, 0.00580861F, 0.00614935F, 0.00650371F, 0.00687202F, 0.00725461F,
  0.00765182F, 0.00806400F, 0.00849149F, 0.00893463F, 0.00939377F, 0.00986927F, 0.01036146F, 0.01087072F,
  0.01139738F, 0.01194182F, 0.01250438F, 0.01308543F, 0.01368533F, 0.01430445F, 0.01494313F, 0.01560176F,
  0.01628069F, 0.01698030F, 0.01770093F, 0.01844297F, 0.01920678F, 0.01999272F, 0.02080116F, 0.02163247F,
  0.02248700F, 0.02336514F, 0.02426722F, 0.02519363F, 0.02614473F, 0.02712086F, 0.02812239F, 0.02914969F,
  0.03020309F, 0.03128296F, 0.03238965F, 0.03352350F, 0.03468486F, 0.03587407F, 0.03709148F, 0.03833742F,
  0.03961223F, 0.04091624F, 0.04224976F, 0.04361314F, 0.04500668F, 0.04643071F, 0.04788553F, 0.04937144F,
  0.05088876F, 0.05243779F, 0.05401880F, 0.05563209F, 0.05727794F, 0.05895663F, 0.06066843F, 0.06241360F,
  0.06419241F, 0.06600510F, 0.06785191F, 0.06973310F, 0.07164890F, 0.07359952F, 0.07558520F, 0.07760613F,
  0.07966253F, 0.08175460F, 0.08388252F, 0.08604647F, 0.08824664F, 0.09048318F, 0.09275625F, 0.09506601F,
  0.09741259F, 0.09979612F, 0.10221674F, 0.10467455F, 0.10716965F, 0.10970216F, 0.11227214F, 0.11487969F,
  0.11752486F, 0.12020772F, 0.12292832F, 0.12568669F, 0.12848287F, 0.13131686F, 0.13418869F, 0.13709835F,
  0.14004582F, 0.14303109F, 0.14605413F, 0.14911488F, 0.15221330F, 0.15534933F, 0.15852287F, 0.16173386F,
  0.16498219F, 0.16826776F, 0.17159044F, 0.17495011F, 0.17834663F, 0.18177984F, 0.18524958F, 0.18875568F,
  0.19229796F, 0.19587621F, 0.19949022F, 0.20313979F, 0.20682468F, 0.21054465F, 0.21429945F, 0.21808881F,
  0.22191246F, 0.22577012F, 0.22966150F, 0.23358627F, 0.23754413F, 0.24153475F, 0.24555779F, 0.24961290F,
  0.25369971F, 0.25781786F, 0.26196696F, 0.26614663F, 0.27035645F, 0.27459602F, 0.27886492F, 0.28316270F,
  0.28748893F, 0.29184316F, 0.29622491F, 0.30063373F, 0.30506912F, 0.30953060F, 0.31401766F, 0.31852980F,
  0.32306649F, 0.32762722F, 0.33221144F, 0.33681862F, 0.34144819F, 0.34609959F, 0.35077227F, 0.35546564F,
  0.36017911F, 0.36491210F, 0.36966401F, 0.37443423F, 0.37922215F, 0.38402715F, 0.38884860F, 0.39368588F,
  0.39853833F, 0.40340533F, 0.40828621F, 0.41318033F, 0.41808703F, 0.42300563F, 0.42793547F, 0.43287588F,
  0.43782617F, 0.44278566F, 0.44775368F, 0.45272952F, 0.45771249F, 0.46270190F, 0.46769705F, 0.47269723F,
  0.47770175F, 0.48270989F, 0.48772095F, 0.49273422F, 0.49774898F, 0.50276453F, 0.50778016F, 0.51279515F,
  0.51780878F, 0.52282035F, 0.52782913F, 0.53283443F, 0.53783552F, 0.54283170F, 0.54782225F, 0.55280647F,
  0.55778366F, 0.56275310F, 0.56771410F, 0.57266596F, 0.57760798F, 0.58253947F, 0.58745973F, 0.59236810F,
  0.59726387F, 0.60214638F, 0.60701494F, 0.61186890F, 0.61670759F, 0.62153034F, 0.62633651F, 0.63112545F,
  0.63589651F, 0.64064907F, 0.64538248F, 0.65009613F, 0.65478941F, 0.65946169F, 0.66411239F, 0.66874090F,
  0.67334664F, 0.67792903F, 0.68248750F, 0.68702148F, 0.69153043F, 0.69601379F, 0.70047104F, 0.70490164F,
  0.70930507F, 0.71368083F, 0.71802841F, 0.72234733F, 0.72663711F, 0.73089727F, 0.73512736F, 0.73932693F,
  0.74349554F, 0.74763276F, 0.75173817F, 0.75581137F, 0.75985197F, 0.76385958F, 0.76783382F, 0.77177433F,
  0.77568078F, 0.77955280F, 0.78339009F, 0.78719232F, 0.79095919F, 0.79469042F, 0.79838571F, 0.80204481F,
  0.80566745F, 0.80925340F, 0.81280242F, 0.81631429F, 0.81978881F, 0.82322579F, 0.82662503F, 0.82998638F,
  0.83330967F, 0.83659475F, 0.83984150F, 0.84304979F, 0.84621952F, 0.84935058F, 0.85244289F, 0.85549639F,
  0.85851100F, 0.86148669F, 0.86442341F, 0.86732113F, 0.87017986F, 0.87299959F, 0.87578032F, 0.87852208F,
  0.88122490F, 0.88388884F, 0.88651393F, 0.88910026F, 0.89164790F, 0.89415695F, 0.89662749F, 0.89905965F,
  0.90145353F, 0.90380929F, 0.90612705F, 0.90840698F, 0.91064923F, 0.91285397F, 0.91502139F, 0.91715168F,
  0.91924503F, 0.92130167F, 0.92332180F, 0.92530566F, 0.92725347F, 0.92916549F, 0.93104197F, 0.93288317F,
  0.93468935F, 0.93646079F, 0.93819778F, 0.93990060F, 0.94156955F, 0.94320494F, 0.94480707F, 0.94637627F,
  0.94791285F, 0.94941714F, 0.95088948F, 0.95233021F, 0.95373967F, 0.95511821F, 0.95646619F, 0.95778396F,
  0.95907189F, 0.96033034F, 0.96155968F, 0.96276030F, 0.96393256F, 0.96507684F, 0.96619354F, 0.96728303F,
  0.96834570F, 0.96938195F, 0.97039217F, 0.97137675F, 0.97233608F, 0.97327057F, 0.97418060F, 0.97506659F,
  0.97592893F, 0.97676801F, 0.97758424F, 0.97837802F, 0.97914975F, 0.97989982F, 0.98062863F, 0.98133659F,
  0.98202408F, 0.98269150F, 0.98333925F, 0.98396772F, 0.98457730F, 0.98516837F, 0.98574133F, 0.98629655F,
  0.98683441F, 0.98735531F, 0.98785960F, 0.98834767F, 0.98881988F, 0.98927660F, 0.98971820F, 0.99014502F,
  0.99055744F, 0.99095580F, 0.99134045F, 0.99171173F, 0.99206999F, 0.99241555F, 0.99274876F, 0.99306994F,
  0.99337941F, 0.99367750F, 0.99396450F, 0.99424075F, 0.99450653F, 0.99476215F, 0.99500791F, 0.99524408F,
  0.99547097F, 0.99568885F, 0.99589798F, 0.99609866F, 0.99629112F, 0.99647565F, 0.99665249F, 0.99682189F,
  0.99698410F, 0.99713935F, 0.99728788F, 0.99742992F, 0.99756568F, 0.99769540F, 0.99781929F, 0.99793754F,
  0.99805037F, 0.99815797F, 0.99826054F, 0.99835827F, 0.99845134F, 0.99853992F, 0.99862419F, 0.99870433F,
  0.99878049F, 0.99885283F, 0.99892151F, 0.99898669F, 0.99904849F, 0.99910708F, 0.99916258F, 0.99921513F,
  0.99926485F, 0.99931187F, 0.99935632F, 0.99939830F, 0.99943793F, 0.99947532F, 0.99951057F, 0.99954378F,
  0.99957506F, 0.99960449F, 0.99963216F, 0.99965817F, 0.99968259F, 0.99970551F, 0.99972700F, 0.99974714F,
  0.99976599F, 0.99978363F, 0.99980013F, 0.99981553F, 0.99982991F, 0.99984333F, 0.99985582F, 0.99986746F,
  0.99987829F, 0.99988835F, 0.99989769F, 0.99990635F, 0.99991438F, 0.99992182F, 0.99992869F, 0.99993505F,
  0.99994091F, 0.99994632F, 0.99995130F, 0.99995588F, 0.99996009F, 0.99996395F, 0.99996749F, 0.99997072F,
  0.99997368F, 0.99997639F, 0.99997885F, 0.99998109F, 0.99998313F, 0.99998498F, 0.99998665F, 0.99998817F,
  0.99998953F, 0.99999076F, 0.99999187F, 0.99999287F, 0.99999376F, 0.99999455F, 0.99999526F, 0.99999589F,
  0.99999645F, 0.99999694F, 0.99999738F, 0.99999776F, 0.99999810F, 0.99999839F, 0.99999865F, 0.99999887F,
  0.99999906F, 0.99999923F, 0.99999937F, 0.99999949F, 0.99999959F, 0.99999967F, 0.99999975F, 0.99999980F,
  0.99999985F, 0.99999989F, 0.99999992F, 0.99999995F, 0.99999996F, 0.99999998F, 0.99999999F, 1.00000000F
};

/* <----------------------------------------------------------------------------------------------------| */

/* Initial LSF memory */
const float lsf_init[M] = {
    375.0,  750.0, 1125.0, 1500.0, 1875.0, 2250.0, 2625.0, 3000.0,
   3375.0, 3750.0, 4125.0, 4500.0, 4875.0, 5250.0, 5625.0, 6000.0};

const float lag_window[17] = {
 1.0001f,
 0.999566371183f,  0.998266612613f,  0.996104103033f,  0.993084457421f,
 0.989215493202f,  0.984507262707f,  0.978971838951f,  0.972623467445f,
 0.965478420258f,  0.957554817200f,  0.948872864246f,  0.939454317093f,
 0.929322779179f,  0.918503403664f,  0.907022833824f,  0.894909143448f,
};
/* For bass post filter */
const float filt_lp[1+L_FILT] = {
  0.088250f,  0.086410f,  0.081074f,  0.072768f,  0.062294f,  0.050623f,  0.038774f,  0.027692f,
  0.018130f,  0.010578f,  0.005221f,  0.001946f,  0.000385f
};
const float filt_lp2[1+2*(L_FILT)+1] = {
  0.044123f,  0.043891f,  0.043203f,  0.042075f,  0.040535f,  0.038622f,  0.036382f,  0.033870f,
  0.031145f,  0.028270f,  0.025310f,  0.022328f,  0.019386f,  0.016541f,  0.013845f,  0.011341f,
  0.009064f,  0.007041f,  0.005288f,  0.003812f,  0.002610f,  0.001670f,  0.000972f,  0.000490f,
  0.000192f,  0.000041f
};

/* 1/4 resolution interpolation filter (-3 dB at 0.856*fs/2) */
const float inter4_2[PIT_FIR_SIZE2] = {
  /* cut-off frequency at 0.94*fs/2 */
   0.940000f,
   0.856390f,   0.632268f,   0.337560f,   0.059072f,
  -0.131059f,  -0.199393f,  -0.158569f,  -0.056359f,
   0.047606f,   0.106749f,   0.103705f,   0.052062f,
  -0.015182f,  -0.063705f,  -0.073660f,  -0.046497f,
  -0.000983f,   0.038227f,   0.053143f,   0.040059f,
   0.009308f,  -0.021674f,  -0.037767f,  -0.033186f,
  -0.013028f,   0.010702f,   0.025901f,   0.026318f,
   0.013821f,  -0.003645f,  -0.016813f,  -0.019855f,
  -0.012766f,  -0.000530f,   0.010080f,   0.014122f,
   0.010657f,   0.002594f,  -0.005363f,  -0.009344f,
  -0.008101f,  -0.003182f,   0.002330f,   0.005635f,
   0.005562f,   0.002844f,  -0.000627f,  -0.002993f,
  -0.003362f,  -0.002044f,  -0.000116f,   0.001315f,
   0.001692f,   0.001151f,   0.000259f,  -0.000417f,
  -0.000618f,  -0.000434f,  -0.000133f,   0.000063f,
   0.000098f,   0.000048f,   0.000007f,   0.000000f
};
