/************************************************************************

This software module was originally developed by Fraunhofer IIS and 
VoiceAge Corp. in the course of development of the ISO/IEC 23008-3 for 
reference purposes and its  performance may not have been optimized. 
This software module is an implementation of one or more tools as 
specified by the ISO/IEC 23008-3 standard. ISO/IEC gives you a 
royalty-free, worldwide, non-exclusive,copyright license to copy, 
distribute, and make derivative works of this software module or 
modifications thereof for use in implementations or products claiming 
conformance to the ISO/IEC 23008-3 standard and which satisfy any specified 
conformance criteria. 
Those intending to use this software module in products are advised that 
its use may infringe existing patents.

ISO/IEC have no liability for use of this software module or 
modifications thereof. Copyright is not released for products that do
not conform to the ISO/IEC 23008-3 standard.

Fraunhofer IIS and VoiceAge Corp. retain full right to modify and use the 
code for its own purpose, assign or donate the code to a third party and 
to inhibit third parties from using the code for products that do not 
conform to MPEG-related ITU Recommendations and/or ISO/IEC International 
Standards.

This copyright notice must be included in all copies or derivative works.

Copyright (c) ISO/IEC 2008.

*************************************************************************/

/*
 *===================================================================
 *  3GPP AMR Wideband Floating-point Speech Codec
 *===================================================================
 */
#include "typedef.h"

#define UP_SAMP         4
#define L_INTERPOL1     4
#define L_INTERPOL2     16
#define NB_QUA_GAIN7B   128   /* Number of quantization level        */

const UWord8 E_ROM_tipos[36] = {
   0, 1, 2, 3, /* starting point &ipos[0], 1st iter */
   1, 2, 3, 0, /* starting point &ipos[4], 2nd iter */
   2, 3, 0, 1, /* starting point &ipos[8], 3rd iter */
   3, 0, 1, 2, /* starting point &ipos[12], 4th iter */
   0, 1, 2, 3,
   1, 2, 3, 0,
   2, 3, 0, 1,
   3, 0, 1, 2,
   0, 1, 2, 3 /* end point for 24 pulses &ipos[35], 4th iter */
};
/* moved to prePostFiltlib */
/*
 * Chebyshev polynomial grid points
 *
 * grid[0] = 1.0;
 * grid[grid_points + 1] = -1.0;
 * for (i = 1; i < grid_points; i++)
 *   grid[i] = cos((6.283185307*i)/(2.0*grid_points));
 *
 */
const Float32 E_ROM_grid[101] = {
   1.00000F, 0.999507F, 0.998027F, 0.995562F, 0.992115F,
   0.987688F, 0.982287F, 0.975917F, 0.968583F, 0.960294F,
   0.951057F, 0.940881F, 0.929776F, 0.917755F, 0.904827F,
   0.891007F, 0.876307F, 0.860742F, 0.844328F, 0.827081F,
   0.809017F, 0.790155F, 0.770513F, 0.750111F, 0.728969F,
   0.707107F, 0.684547F, 0.661312F, 0.637424F, 0.612907F,
   0.587785F, 0.562083F, 0.535827F, 0.509041F, 0.481754F,
   0.453990F, 0.425779F, 0.397148F, 0.368124F, 0.338738F,
   0.309017F, 0.278991F, 0.248690F, 0.218143F, 0.187381F,
   0.156434F, 0.125333F, 0.0941082F, 0.0627904F, 0.0314107F,
   -8.09643e-008F,
   -0.0314108F, -0.0627906F, -0.0941084F, -0.125333F, -0.156435F,
   -0.187381F, -0.218143F, -0.248690F, -0.278991F, -0.309017F,
   -0.338738F, -0.368125F, -0.397148F, -0.425779F, -0.453991F,
   -0.481754F, -0.509041F, -0.535827F, -0.562083F, -0.587785F,
   -0.612907F, -0.637424F, -0.661312F, -0.684547F, -0.707107F,
   -0.728969F, -0.750111F, -0.770513F, -0.790155F, -0.809017F,
   -0.827081F, -0.844328F, -0.860742F, -0.876307F, -0.891007F,
   -0.904827F, -0.917755F, -0.929777F, -0.940881F, -0.951057F,
   -0.960294F, -0.968583F, -0.975917F, -0.982287F, -0.987688F,
   -0.992115F, -0.995562F, -0.998027F, -0.999507F, -1.00000F
};
/* 16-byte align end */
/* weighting of the correlation function in open loop LTP search */
const Float32 E_ROM_corrweight[64+199+64]= {
   0.28560302801398F, 0.28627687061174F, 0.28695071320950F, 0.28762455580726F,
   0.28829839840502F, 0.28897224100278F, 0.28964608360054F, 0.29031992619830F,
   0.29099376879606F, 0.29166761139382F, 0.29234145399158F, 0.29301529658934F,
   0.29368913918710F, 0.29436298178486F, 0.29503682438262F, 0.29571066698038F,
   0.29638450957814F, 0.29705835217590F, 0.29773219477366F, 0.29840603737142F,
   0.29907987996918F, 0.29975372256694F, 0.30042756516470F, 0.30110140776246F,
   0.30177525036022F, 0.30244909295798F, 0.30312293555574F, 0.30379677815350F,
   0.30447062075126F, 0.30514446334902F, 0.30581830594678F, 0.30649214854454F,
   0.30716599114230F, 0.30783983374006F, 0.30851367633782F, 0.30918751893558F,
   0.30986136153334F, 0.31053520413110F, 0.31120904672886F, 0.31188288932662F,
   0.31255673192438F, 0.31323057452214F, 0.31390441711990F, 0.31457825971766F,
   0.31525210231542F, 0.31592594491318F, 0.31659978751094F, 0.31727363010870F,
   0.31794747270646F, 0.31862131530422F, 0.31929515790198F, 0.31996900049974F,
   0.32064284309750F, 0.32131668569526F, 0.32199052829302F, 0.32266437089078F,
   0.32333821348854F, 0.32401205608630F, 0.32468589868406F, 0.32535974128182F,
   0.32603358387958F, 0.32670742647734F, 0.32738126907510F, 0.32805511167286F,
   0.32872895427062F, 0.32940279686838F, 0.33008397607000F, 0.33077263774882F,
   0.33146893201434F, 0.33217301337469F, 0.33288504090694F, 0.33360517843561F,
   0.33433359471985F, 0.33507046364991F, 0.33581596445331F, 0.33657028191132F,
   0.33733360658650F, 0.33810613506181F, 0.33888807019203F, 0.33967962136837F,
   0.34048100479698F, 0.34129244379225F, 0.34211416908597F, 0.34294641915312F,
   0.34378944055574F, 0.34464348830569F, 0.34550882624786F, 0.34638572746505F,
   0.34727447470606F, 0.34817536083854F, 0.34908868932841F, 0.35001477474762F,
   0.35095394331240F, 0.35190653345404F, 0.35287289642476F, 0.35385339694105F,
   0.35484841386753F, 0.35585834094415F, 0.35688358756025F, 0.35792457957894F,
   0.35898176021598F, 0.36005559097716F, 0.36114655265930F, 0.36225514641972F,
   0.36338189491998F, 0.36452734355021F, 0.36569206174066F, 0.36687664436818F,
   0.36808171326584F, 0.36930791884477F, 0.37055594183846F, 0.37182649518049F,
   0.37312032602824F, 0.37443821794611F, 0.37578099326358F, 0.37714951562500F,
   0.37854469274995F, 0.37996747942529F, 0.38141888075233F, 0.38289995567554F,
   0.38441182082240F, 0.38595565468744F, 0.38753270219810F, 0.38914427970450F,
   0.39079178044081F, 0.39247668051248F, 0.39420054547049F, 0.39596503754272F,
   0.39777192360213F, 0.39962308396279F, 0.40152052210853F, 0.40346637547426F,
   0.40546292741845F, 0.40751262054712F, 0.40961807157476F, 0.41178208793838F,
   0.41400768641652F, 0.41629811404829F, 0.41865687169900F, 0.42108774068111F,
   0.42359481291430F, 0.42618252519967F, 0.42885569829436F, 0.43161958160963F,
   0.43447990452326F, 0.43744293550645F, 0.44051555052483F, 0.44370531250000F,
   0.44702056402976F, 0.45047053608887F, 0.45406547610287F, 0.45781679965235F,
   0.46173727119116F, 0.46584122063850F, 0.47014480466210F, 0.47466632408736F,
   0.47942661240838F, 0.48444951522162F, 0.49000000000000F, 0.50000000000000F,
   0.50000000000000F, 0.50000000000000F, 0.50000000000000F, 0.50000000000000F,
   0.50000000000000F, 0.50000000000000F, 0.49000000000000F, 0.48444951522162F,
   0.47942661240838F, 0.47466632408736F, 0.47014480466210F, 0.46584122063850F,
   0.46173727119116F, 0.45781679965235F, 0.45406547610287F, 0.45047053608887F,
   0.44702056402976F, 0.44370531250000F, 0.44051555052483F, 0.43744293550645F,
   0.43447990452326F, 0.43161958160963F, 0.42885569829436F, 0.42618252519967F,
   0.42359481291430F, 0.42108774068111F, 0.41865687169900F, 0.41629811404829F,
   0.41400768641652F, 0.41178208793838F, 0.40961807157476F, 0.40751262054712F,
   0.40546292741845F, 0.40346637547426F, 0.40152052210853F, 0.39962308396279F,
   0.39777192360213F, 0.39596503754272F, 0.39420054547049F, 0.39247668051248F,
   0.39079178044081F, 0.38914427970450F, 0.38753270219810F, 0.38595565468744F,
   0.38441182082240F, 0.38289995567554F, 0.38141888075233F, 0.37996747942529F,
   0.37854469274995F, 0.37714951562500F, 0.37578099326358F, 0.37443821794611F,
   0.37312032602824F, 0.37182649518049F, 0.37055594183846F, 0.36930791884477F,
   0.36808171326584F, 0.36687664436818F, 0.36569206174066F, 0.36452734355021F,
   0.36338189491998F, 0.36225514641972F, 0.36114655265930F, 0.36005559097716F,
   0.35898176021598F, 0.35792457957894F, 0.35688358756025F, 0.35585834094415F,
   0.35484841386753F, 0.35385339694105F, 0.35287289642476F, 0.35190653345404F,
   0.35095394331240F, 0.35001477474762F, 0.34908868932841F, 0.34817536083854F,
   0.34727447470606F, 0.34638572746505F, 0.34550882624786F, 0.34464348830569F,
   0.34378944055574F, 0.34294641915312F, 0.34211416908597F, 0.34129244379225F,
   0.34048100479698F, 0.33967962136837F, 0.33888807019203F, 0.33810613506181F,
   0.33733360658650F, 0.33657028191132F, 0.33581596445331F, 0.33507046364991F,
   0.33433359471985F, 0.33360517843561F, 0.33288504090694F, 0.33217301337469F,
   0.33146893201434F, 0.33077263774882F, 0.33008397607000F, 0.32940279686838F,
   0.32872895427062F, 0.32806230648432F, 0.32740271564992F
  ,0.32805511167286F, 0.32738126907510F, 0.32670742647734F, 0.32603358387958F,
   0.32535974128182F, 0.32468589868406F, 0.32401205608630F, 0.32333821348854F,
   0.32266437089078F, 0.32199052829302F, 0.32131668569526F, 0.32064284309750F,
   0.31996900049974F, 0.31929515790198F, 0.31862131530422F, 0.31794747270646F,
   0.31727363010870F, 0.31659978751094F, 0.31592594491318F, 0.31525210231542F,
   0.31457825971766F, 0.31390441711990F, 0.31323057452214F, 0.31255673192438F,
   0.31188288932662F, 0.31120904672886F, 0.31053520413110F, 0.30986136153334F,
   0.30918751893558F, 0.30851367633782F, 0.30783983374006F, 0.30716599114230F,
   0.30649214854454F, 0.30581830594678F, 0.30514446334902F, 0.30447062075126F,
   0.30379677815350F, 0.30312293555574F, 0.30244909295798F, 0.30177525036022F,
   0.30110140776246F, 0.30042756516470F, 0.29975372256694F, 0.29907987996918F,
   0.29840603737142F, 0.29773219477366F, 0.29705835217590F, 0.29638450957814F,
   0.29571066698038F, 0.29503682438262F, 0.29436298178486F, 0.29368913918710F,
   0.29301529658934F, 0.29234145399158F, 0.29166761139382F, 0.29099376879606F,
   0.29031992619830F, 0.28964608360054F, 0.28897224100278F, 0.28829839840502F,
   0.28762455580726F, 0.28695071320950F, 0.28627687061174F, 0.28560302801398F
};

/*
 * 1/4 resolution interpolation filter (-3 dB at 0.791*fs/2)
 */
const Float32 E_ROM_inter4_1[UP_SAMP * L_INTERPOL1 + 1] = {
   /* cut-off frequency at 0.9*fs/2 */
   0.900000F,
   0.818959F, 0.604850F, 0.331379F, 0.083958F,
   -0.075795F, -0.130717F, -0.105685F, -0.046774F,
   0.004467F, 0.027789F, 0.025642F, 0.012571F,
   0.001927F, -0.001571F, -0.000753F, 0.000000f
};

const Word16 E_ROM_inter4_2[UP_SAMP * 2 * L_INTERPOL2] = {
   0, 1, 2, 1,
   -2, -7, -10, -7,
   4, 19, 28, 22,
   -2, -33, -55, -49,
   -10, 47, 91, 92,
   38, -52, -133, -153,
   -88, 43, 175, 231,
   165, -9, -209, -325,
   -275, -60, 226, 431,
   424, 175, -213, -544,
   -619, -355, 153, 656,
   871, 626, -16, -762,
   -1207, -1044, -249, 853,
   1699, 1749, 780, -923,
   -2598, -3267, -2147, 968,
   5531, 10359, 14031, 15401,
   14031, 10359, 5531, 968,
   -2147, -3267, -2598, -923,
   780, 1749, 1699, 853,
   -249, -1044, -1207, -762,
   -16, 626, 871, 656,
   153, -355, -619, -544,
   -213, 175, 424, 431,
   226, -60, -275, -325,
   -209, -9, 165, 231,
   175, 43, -88, -153,
   -133, -52, 38, 92,
   91, 47, -10, -49,
   -55, -33, -2, 22,
   28, 19, 4, -7,
   -10, -7, -2, 1,
   2, 1, 0, 0
};

const Float32 E_ROM_qua_gain7b[NB_QUA_GAIN7B * 2] = {
   0.012445F, 0.215546F,
   0.028326F, 0.965442F,
   0.053042F, 0.525819F,
   0.065409F, 1.495322F,
   0.078212F, 2.323725F,
   0.100504F, 0.751276F,
   0.112617F, 3.427530F,
   0.113124F, 0.309583F,
   0.121763F, 1.140685F,
   0.143515F, 7.519609F,
   0.162430F, 0.568752F,
   0.164940F, 1.904113F,
   0.165429F, 4.947562F,
   0.194985F, 0.855463F,
   0.213527F, 1.281019F,
   0.223544F, 0.414672F,
   0.243135F, 2.781766F,
   0.257180F, 1.659565F,
   0.269488F, 0.636749F,
   0.286539F, 1.003938F,
   0.328124F, 2.225436F,
   0.328761F, 0.330278F,
   0.336807F, 11.500983F,
   0.339794F, 3.805726F,
   0.344454F, 1.494626F,
   0.346165F, 0.738748F,
   0.363605F, 1.141454F,
   0.398729F, 0.517614F,
   0.415276F, 2.928666F,
   0.416282F, 0.862935F,
   0.423421F, 1.873310F,
   0.444151F, 0.202244F,
   0.445842F, 1.301113F,
   0.455671F, 5.519512F,
   0.484764F, 0.387607F,
   0.488696F, 0.967884F,
   0.488730F, 0.666771F,
   0.508189F, 1.516224F,
   0.508792F, 2.348662F,
   0.531504F, 3.883870F,
   0.548649F, 1.112861F,
   0.551182F, 0.514986F,
   0.564397F, 1.742030F,
   0.566598F, 0.796454F,
   0.589255F, 3.081743F,
   0.598816F, 1.271936F,
   0.617654F, 0.333501F,
   0.619073F, 2.040522F,
   0.625282F, 0.950244F,
   0.630798F, 0.594883F,
   0.638918F, 4.863197F,
   0.650102F, 1.464846F,
   0.668412F, 0.747138F,
   0.669490F, 2.583027F,
   0.683757F, 1.125479F,
   0.691216F, 1.739274F,
   0.718441F, 3.297789F,
   0.722608F, 0.902743F,
   0.728827F, 2.194941F,
   0.729586F, 0.633849F,
   0.730907F, 7.432957F,
   0.731017F, 0.431076F,
   0.731543F, 1.387847F,
   0.759183F, 1.045210F,
   0.768606F, 1.789648F,
   0.771245F, 4.085637F,
   0.772613F, 0.778145F,
   0.786483F, 1.283204F,
   0.792467F, 2.412891F,
   0.802393F, 0.544588F,
   0.807156F, 0.255978F,
   0.814280F, 1.544409F,
   0.817839F, 0.938798F,
   0.826959F, 2.910633F,
   0.830453F, 0.684066F,
   0.833431F, 1.171532F,
   0.841208F, 1.908628F,
   0.846440F, 5.333522F,
   0.868280F, 0.841519F,
   0.868662F, 1.435230F,
   0.871449F, 3.675784F,
   0.881317F, 2.245058F,
   0.882020F, 0.480249F,
   0.882476F, 1.105804F,
   0.902856F, 0.684850F,
   0.904419F, 1.682113F,
   0.909384F, 2.787801F,
   0.916558F, 7.500981F,
   0.918444F, 0.950341F,
   0.919721F, 1.296319F,
   0.940272F, 4.682978F,
   0.940273F, 1.991736F,
   0.950291F, 3.507281F,
   0.957455F, 1.116284F,
   0.957723F, 0.793034F,
   0.958217F, 1.497824F,
   0.962628F, 2.514156F,
   0.968507F, 0.588605F,
   0.974739F, 0.339933F,
   0.991738F, 1.750201F,
   0.997210F, 0.936131F,
   1.002422F, 1.250008F,
   1.006040F, 2.167232F,
   1.008848F, 3.129940F,
   1.014404F, 5.842819F,
   1.027798F, 4.287319F,
   1.039404F, 1.489295F,
   1.039628F, 8.947958F,
   1.043214F, 0.765733F,
   1.045089F, 2.537806F,
   1.058994F, 1.031496F,
   1.060415F, 0.478612F,
   1.072132F, 12.8F,
   1.074778F, 1.910049F,
   1.076570F, 15.9999F,
   1.107853F, 3.843067F,
   1.110673F, 1.228576F,
   1.110969F, 2.758471F,
   1.140058F, 1.603077F,
   1.155384F, 0.668935F,
   1.176229F, 6.717108F,
   1.179008F, 2.011940F,
   1.187735F, 0.963552F,
   1.199569F, 4.891432F,
   1.206311F, 3.316329F,
   1.215323F, 2.507536F,
   1.223150F, 1.387102F,
   1.296012F, 9.684225F
};
