/***********************************************************************************
 
 This software module was originally developed by 
 
 Qualcomm Techonologies, Inc. (QTI) and Fraunhofer IIS
 
 in the course of development of the ISO/IEC 23008-3 for reference purposes and its 
 performance may not have been optimized. This software module is an implementation
 of one or more tools as specified by the ISO/IEC 23008-3 standard. ISO/IEC gives 
 you a royalty-free, worldwide, non-exclusive, copyright license to copy, distribute, 
 and make derivative works of this software module or modifications  thereof for use
 in implementations or products claiming conformance to the ISO/IEC 23008-3 standard 
 and which satisfy any specified conformance criteria. Those intending to use this 
 software module in products are advised that its use may infringe existing patents. 
 ISO/IEC have no liability for use of this software module or modifications thereof. 
 Copyright is not released for products that do not conform to the ISO/IEC 23008-3 
 standard.
 
 Qualcomm Techonologies, Inc. (QTI) and Fraunhofer IIS 
 retain full right to modify and use the code for its own purpose,
 assign or donate the code to a third party and to inhibit third parties from using 
 the code for products that do not conform to MPEG-related ITU Recommendations and/or 
 ISO/IEC International Standards.
 
 This copyright notice must be included in all copies or derivative works. 
 
 Copyright (c) ISO/IEC 2015.
 
 ***********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <math.h>
#include <float.h>
#include <string.h>
#include "buffers.h"
#include "proto_func.h"
#include "int3gpp.h"
#include "att_proto.h"
#include "dec_TBE.h"

static const float interpol_frac[NB_SUBFR * 2] = {
  0.7f, 0.3f, 0.5f, 0.5f, 0.3f, 0.7f, 0.1f, 0.9f
};

static const float ap_filt1[AP_NUM] = {
  0.06056541924291f, 0.42943401549235f, 0.80873048306552f
};

static const float ap_filt2[AP_NUM] = {
  0.22063024829630f, 0.63593943961708f, 0.94151583095682f
};

static const float recip_order[15] = {
  0.0000000f, 1.0000000f, 0.5000000f, 0.3333333f, 0.2500000f,
  0.2000000f, 0.1666667f, 0.1428571f, 0.1250000f, 0.1111111f,
  0.1000000f, 0.0909091f, 0.0833333f, 0.0769231f, 0.0714286f
};

static const float wac[LPC_WHTN_ORDER + 1] = {
  1.000030000f, 0.999876638f, 0.999506642f, 0.998890286f, 0.998028026f
};

static float GainFrame5bit[32] = {
  0.001011f, 0.003713f, 0.015517f, 0.060132f, 0.120586f, 0.195489f, 0.281113f,
  0.379025f, 0.492374f, 0.620740f, 0.764047f, 0.924080f, 1.098318f, 1.290460f,
  1.498303f, 1.724956f, 1.972520f, 2.246851f, 2.565094f, 2.935901f, 3.376749f,
  3.924642f, 4.601801f, 5.425421f, 6.469817f, 7.949088f, 10.28801f, 13.60010f,
  15.98213f, 26.88470f, 52.42506f, 104.3400f
};

static const float SubGain5bit[128] = {
  0.21132f, 0.8919f,  0.25073f, 0.24781f, 0.49109f, 0.36892f, 0.36424f, 0.68769f, 0.31642f, 0.39282f, 0.50357f,
  0.69143f, 0.14538f, 0.20545f, 0.61508f, 0.72523f, 0.55597f, 0.40693f, 0.5515f,  0.4636f,  0.32782f, 0.35346f,
  0.71621f, 0.48607f, 0.47823f, 0.75732f, 0.28454f, 0.30591f, 0.93541f, 0.20099f, 0.17145f, 0.15627f, 0.46125f,
  0.40196f, 0.53871f, 0.57318f, 0.81196f, 0.33227f, 0.32905f, 0.32359f, 0.27682f, 0.63987f, 0.274f,   0.64008f,
  0.55515f, 0.50701f, 0.48201f, 0.44507f, 0.47378f, 0.47841f, 0.60912f, 0.41031f, 0.66645f, 0.45733f, 0.47489f,
  0.33369f, 0.28321f, 0.30804f, 0.31331f, 0.83754f, 0.72424f, 0.24507f, 0.26089f, 0.56661f, 0.50327f, 0.28639f,
  0.75435f, 0.26554f, 0.55363f, 0.61005f, 0.4572f,  0.31771f, 0.11637f, 0.11819f, 0.15457f, 0.96163f, 0.49218f,
  0.58968f, 0.40155f, 0.49174f, 0.33193f, 0.70435f, 0.4566f,  0.40953f, 0.41897f, 0.52221f, 0.45016f, 0.58571f,
  0.30084f, 0.55935f, 0.69881f, 0.28529f, 0.35628f, 0.51005f, 0.57418f, 0.52403f, 0.19211f, 0.20635f, 0.90755f,
  0.24599f, 0.7371f,  0.23927f, 0.56338f, 0.24211f, 0.64261f, 0.38355f, 0.435f,   0.49054f, 0.7583f,  0.53387f,
  0.27663f, 0.20498f, 0.53563f, 0.46946f, 0.44187f, 0.54153f, 0.47413f, 0.49108f, 0.51251f, 0.50223f, 0.6421f,
  0.52116f, 0.34328f, 0.43333f, 0.4512f,  0.57399f, 0.51208f, 0.44725f
};

static const float subwin_tbe[TBE_OVERLAP_LEN + 1] = {
  0.000000000f, 0.007312931f, 0.033416940f, 0.077119580f, 0.136556101f, 0.209438491f,
  0.293364150f, 0.385224703f, 0.481317588f, 0.577845599f, 0.671497772f, 0.758927143f,
  0.836651580f, 0.901448444f, 0.951083203f, 0.984171147f, 1.000000000f
};

static const float subwin_tbe_fb[2*TBE_OVERLAP_LEN + 1] = {
  0.000000000f, 0.002057320f, 0.007312931f, 0.017743483f, 0.033416940f, 0.053210367f,
  0.077119580f, 0.104915089f, 0.136556101f, 0.171354547f, 0.209438491f, 0.250082925f,
  0.293364150f, 0.338401147f, 0.385224703f, 0.432854509f, 0.481317588f, 0.529597392f,
  0.577845599f, 0.625078725f, 0.671497772f, 0.716039678f, 0.758927143f, 0.799044170f,
  0.836651580f, 0.870644917f, 0.901448444f, 0.927953529f, 0.951083203f, 0.969773527f,
  0.984171147f, 0.993264992f, 1.000000000f
};

static const float win_flatten[L_FRAME_TBE / 2] = {
  0.000088034f, 0.000476116f, 0.001169363f, 0.002150485f, 0.003429115f, 0.005010492f, 0.006898746f, 0.009062795f,
  0.011521152f, 0.014280317f, 0.017346705f, 0.020672203f, 0.024285616f, 0.028196360f, 0.032413006f, 0.036865973f,
  0.041598847f, 0.046624415f, 0.051953217f, 0.057488784f, 0.063295004f, 0.069388114f, 0.075780325f, 0.082343259f,
  0.089166444f, 0.096269593f, 0.103666288f, 0.111191524f, 0.118965557f, 0.127011578f, 0.135344218f, 0.143757482f,
  0.152407144f, 0.161319848f, 0.170510936f, 0.179729455f, 0.189171151f, 0.198866047f, 0.208829871f, 0.218763164f,
  0.228905716f, 0.239290834f, 0.249934286f, 0.260485032f, 0.271230554f, 0.282207315f, 0.293430784f, 0.304495752f,
  0.315740588f, 0.327204751f, 0.338903073f, 0.350374111f, 0.362009827f, 0.373852485f, 0.385915952f, 0.397681021f,
  0.409595440f, 0.421704067f, 0.434019475f, 0.445963724f, 0.458042003f, 0.470301524f, 0.482753259f, 0.494760120f,
  0.506885848f, 0.519179745f, 0.531650889f, 0.543603194f, 0.555659506f, 0.567870932f, 0.580244380f, 0.592025487f,
  0.603896179f, 0.615909077f, 0.628068660f, 0.639563560f, 0.651134210f, 0.662834422f, 0.674666017f, 0.685762445f,
  0.696921498f, 0.708197860f, 0.719590484f, 0.730179986f, 0.740819828f, 0.751565232f, 0.762412100f, 0.772391076f,
  0.782409064f, 0.792521481f, 0.802721036f, 0.811991726f, 0.821291165f, 0.830674628f, 0.840131507f, 0.848602932f,
  0.857094007f, 0.865659523f, 0.874285468f, 0.881874298f, 0.889474928f, 0.897141336f, 0.904856044f, 0.911487394f,
  0.918124024f, 0.924818762f, 0.931550652f, 0.937158805f, 0.942767102f, 0.948426913f, 0.954113807f, 0.958642835f,
  0.963168312f, 0.967739839f, 0.972329565f, 0.975733870f, 0.979132398f, 0.982572706f, 0.986023587f, 0.988268182f,
  0.990506116f, 0.992782769f, 0.995064351f, 0.996124740f, 0.997178979f, 0.998271140f, 0.999365251f, 0.999935699f
};

static float tbeExcFilterCB1_7b[1280] = {
  0.09278f,  -0.04927f, -0.12850f, 0.04224f,  0.19906f,  -0.11443f, -0.17523f, 0.22302f,  0.13816f,  -0.28557f,
  0.00011f,  -0.11068f, -0.30536f, -0.28212f, -0.08996f, -0.23144f, -0.02353f, 0.01956f,  0.08163f,  0.15772f,
  -0.06270f, -0.05202f, -0.09499f, 0.09656f,  0.09493f,  -0.07314f, 0.26034f,  0.12844f,  0.08331f,  -0.13683f,
  0.07668f,  -0.02219f, 0.29456f,  0.17219f,  0.13650f,  -0.02633f, 0.02025f,  -0.07030f, -0.07750f, -0.36374f,
  0.07061f,  -0.08168f, -0.02593f, -0.19450f, -0.14380f, 0.01913f,  0.15810f,  0.13042f,  0.18332f,  0.03253f,
  -0.04266f, 0.05446f,  0.04855f,  0.21232f,  0.34886f,  -0.04787f, -0.14493f, 0.01559f,  0.20742f,  0.02468f,
  0.29098f,  0.06383f,  0.16620f,  0.15719f,  0.14352f,  0.19807f,  0.09548f,  -0.05796f, 0.10414f,  -0.13189f,
  -0.11786f, -0.08787f, 0.21436f,  0.22915f,  -0.07895f, -0.16376f, -0.24403f, -0.12381f, 0.00463f,  0.18062f,
  0.19711f,  -0.20348f, 0.03503f,  -0.24203f, 0.14650f,  0.01923f,  -0.25212f, 0.07296f,  -0.13447f, 0.06531f,
  -0.20131f, 0.09759f,  -0.08098f, -0.04882f, -0.10880f, -0.08122f, 0.14914f,  -0.10339f, 0.24513f,  -0.19795f,
  -0.02871f, 0.24279f,  0.05725f,  0.07613f,  0.41804f,  0.19693f,  -0.01821f, 0.02656f,  -0.18997f, -0.10614f,
  -0.08732f, -0.00701f, 0.29408f,  -0.07048f, -0.21163f, 0.21397f,  0.09863f,  -0.24706f, 0.16062f,  -0.04952f,
  -0.10538f, -0.08600f, 0.17400f,  0.18545f,  -0.10238f, 0.14518f,  0.24527f,  -0.11161f, -0.05530f, -0.04299f,
  -0.25925f, -0.21043f, 0.19050f,  0.21659f,  -0.08269f, -0.15606f, 0.20488f,  0.19390f,  -0.09604f, -0.07044f,
  0.08850f,  -0.01086f, -0.01367f, -0.06393f, 0.25061f,  -0.31779f, 0.27489f,  -0.04085f, -0.00347f, 0.00237f,
  0.13072f,  0.15224f,  0.11707f,  0.17535f,  0.16650f,  0.14625f,  0.19130f,  0.15279f,  0.17186f,  0.15160f,
  0.13914f,  0.13684f,  -0.11358f, 0.00496f,  0.19564f,  -0.11009f, -0.05058f, 0.10552f,  -0.01550f, -0.16635f,
  -0.17303f, 0.30944f,  -0.16285f, -0.12656f, 0.08875f,  0.01211f,  -0.22898f, 0.21767f,  -0.01427f, 0.01698f,
  0.07809f,  -0.09757f, 0.16756f,  -0.11494f, 0.23395f,  -0.19899f, 0.18347f,  -0.13230f, 0.04415f,  0.00773f,
  0.04403f,  -0.20143f, -0.07105f, -0.07592f, -0.06155f, -0.08754f, 0.09564f,  0.16468f,  0.30223f,  0.18032f,
  -0.05453f, -0.09441f, 0.07789f,  0.00663f,  -0.14208f, 0.21035f,  -0.11962f, 0.26739f,  -0.19667f, 0.23282f,
  0.08878f,  0.06016f,  -0.03346f, -0.10331f, 0.03731f,  -0.18329f, 0.12412f,  -0.15104f, -0.10267f, 0.17931f,
  0.13982f,  0.16001f,  0.10645f,  -0.09327f, -0.15898f, -0.17531f, -0.24699f, -0.12977f, -0.03232f, 0.10249f,
  0.17369f,  -0.22144f, 0.05599f,  0.04504f,  -0.19557f, 0.20916f,  -0.18563f, 0.05508f,  0.11578f,  -0.19359f,
  0.11344f,  -0.14198f, 0.17441f,  -0.24905f, 0.07004f,  -0.21457f, -0.06794f, 0.12604f,  -0.01816f, -0.11586f,
  -0.28752f, 0.01574f,  -0.05318f, -0.16036f, -0.02890f, 0.33425f,  -0.24830f, -0.03269f, 0.23887f,  -0.08670f,
  -0.20272f, 0.11303f,  0.01556f,  -0.09528f, 0.12476f,  -0.06551f, 0.18028f,  -0.15544f, 0.13792f,  -0.09292f,
  0.32678f,  -0.34258f, 0.28105f,  -0.16207f, 0.15352f,  -0.04954f, 0.10858f,  -0.16012f, 0.13098f,  -0.18598f,
  0.28576f,  -0.13167f, -0.05888f, 0.41716f,  0.15788f,  -0.02090f, 0.05537f,  0.05957f,  -0.11597f, -0.14661f,
  -0.17519f, -0.20084f, -0.34181f, -0.14418f, 0.04831f,  0.10175f,  0.14236f,  0.29364f,  0.19556f,  0.13918f,
  -0.01579f, -0.17416f, 0.11269f,  -0.07107f, 0.06136f,  0.12149f,  0.38782f,  0.13322f,  0.17157f,  0.14254f,
  0.60481f,  -0.16148f, -0.15186f, 0.01878f,  -0.06836f, -0.10740f, -0.00005f, -0.05971f, 0.05391f,  -0.02553f,
  -0.10493f, -0.14194f, 0.38099f,  -0.29010f, 0.22174f,  -0.09632f, 0.06112f,  0.02876f,  -0.02286f, 0.07233f,
  0.24364f,  -0.21663f, -0.01911f, 0.00960f,  -0.11763f, -0.24622f, 0.06394f,  0.28675f,  -0.21145f, -0.06453f,
  -0.01379f, 0.17444f,  -0.27516f, 0.24924f,  -0.32361f, 0.20715f,  -0.16383f, 0.12124f,  0.00005f,  -0.04997f,
  -0.11352f, 0.00839f,  0.22710f,  -0.09127f, -0.06364f, 0.32364f,  -0.00851f, -0.10246f, 0.07668f,  0.15470f,
  0.22745f,  0.42787f,  0.08653f,  0.20847f,  -0.02817f, -0.01357f, -0.23705f, -0.11736f, -0.08144f, -0.11707f,
  -0.06226f, 0.07085f,  -0.28589f, -0.14047f, -0.13638f, 0.02360f,  0.10832f,  0.14287f,  -0.09800f, -0.16612f,
  0.20420f,  0.14631f,  -0.08956f, 0.14235f,  -0.09600f, 0.04706f,  -0.11978f, -0.18188f, 0.05349f,  -0.11259f,
  -0.09417f, 0.15147f,  -0.09651f, -0.14957f, -0.00021f, 0.05522f,  -0.12538f, 0.01834f,  0.25829f,  0.12862f,
  0.16162f,  -0.06564f, 0.00670f,  0.18043f,  -0.06129f, 0.03649f,  0.03095f,  0.02585f,  -0.02912f, 0.06451f,
  -0.28975f, -0.34500f, 0.01568f,  0.24021f,  0.18663f,  0.21627f,  0.01571f,  0.03578f,  0.11493f,  0.08829f,
  -0.12705f, 0.04453f,  -0.13477f, 0.09100f,  -0.01383f, 0.00159f,  -0.06496f, -0.05362f, -0.03940f, -0.02151f,
  -0.12755f, 0.14558f,  0.15106f,  -0.02064f, -0.29887f, 0.16319f,  0.06857f,  0.02120f,  -0.20260f, 0.02590f,
  -0.17117f, -0.06328f, -0.03136f, -0.29652f, -0.18930f, -0.09838f, 0.02780f,  0.09643f,  0.10744f,  0.02357f,
  0.05300f,  0.18895f,  0.16667f,  -0.00416f, 0.18340f,  0.07217f,  0.19257f,  -0.04169f, 0.12714f,  -0.01619f,
  -0.07520f, -0.14532f, -0.07175f, 0.07690f,  0.24361f,  0.11323f,  -0.12563f, -0.23458f, -0.08666f, 0.05998f,
  -0.05859f, 0.04079f,  0.18985f,  0.09698f,  -0.19533f, -0.24503f, -0.00954f, 0.12981f,  0.21652f,  0.07806f,
  -0.12002f, 0.28904f,  0.01626f,  -0.24498f, -0.02720f, 0.21280f,  -0.02151f, -0.16347f, -0.09670f, 0.20795f,
  0.50418f,  0.08574f,  0.22471f,  -0.04306f, 0.13474f,  -0.08671f, -0.05666f, -0.03676f, -0.08459f, -0.06769f,
  0.02286f,  0.12102f,  0.29062f,  0.12411f,  0.08985f,  -0.16048f, -0.12923f, -0.07103f, 0.14190f,  0.04790f,
  -0.10845f, -0.02732f, 0.03072f,  0.00040f,  -0.12867f, 0.03644f,  -0.08572f, -0.11518f, -0.06929f, -0.19148f,
  -0.02748f, -0.17042f, 0.00163f,  0.22631f,  0.01420f,  -0.11956f, -0.05735f, 0.21573f,  0.14477f,  -0.12457f,
  -0.01568f, 0.11073f,  -0.03985f, 0.04661f,  0.05849f,  -0.15079f, -0.10682f, 0.05741f,  -0.18892f, -0.14861f,
  0.19846f,  0.08849f,  -0.18109f, 0.07191f,  0.11123f,  0.11135f,  -0.22693f, -0.13385f, 0.14867f,  0.24480f,
  -0.06086f, 0.07105f,  0.25679f,  0.21256f,  0.15673f,  0.00614f,  -0.14847f, -0.27092f, -0.16918f, -0.08032f,
  0.12908f,  -0.03723f, 0.03004f,  -0.20515f, -0.02586f, -0.09931f, 0.06400f,  -0.34729f, -0.24735f, -0.01626f,
  0.03513f,  -0.15752f, -0.21218f, -0.01513f, 0.10926f,  0.26235f,  0.13124f,  -0.05397f, -0.12931f, -0.16400f,
  0.32126f,  -0.43877f, 0.29727f,  -0.06329f, -0.01772f, -0.02293f, 0.01030f,  0.01445f,  -0.11286f, 0.15418f,
  -0.01192f, -0.07969f, -0.12374f, -0.17855f, -0.23807f, 0.00419f,  -0.02184f, 0.06684f,  0.17852f,  0.29893f,
  0.10326f,  0.19906f,  0.19395f,  0.15637f,  0.10550f,  0.11203f,  0.17639f,  -0.15675f, -0.11169f, -0.08789f,
  -0.00384f, -0.20679f, 0.14551f,  -0.33019f, -0.05396f, -0.11720f, -0.03656f, -0.19987f, 0.31038f,  -0.07446f,
  -0.06342f, -0.07330f, 0.17837f,  -0.02925f, -0.33740f, -0.07286f, 0.06349f,  0.08309f,  -0.04134f, -0.18000f,
  0.18227f,  0.01978f,  -0.13399f, 0.13816f,  -0.07183f, -0.09984f, 0.19717f,  -0.38523f, 0.24609f,  -0.14978f,
  -0.15414f, 0.11149f,  -0.03078f, 0.18451f,  -0.00297f, 0.07744f,  -0.19722f, 0.13131f,  -0.32475f, -0.17452f,
  0.16210f,  0.19069f,  -0.01805f, -0.19237f, -0.31834f, -0.15308f, -0.24636f, -0.04185f, -0.09914f, 0.15125f,
  0.03948f,  -0.06088f, 0.02126f,  0.10788f,  0.09653f,  0.02821f,  0.15783f,  0.31781f,  -0.08155f, -0.08660f,
  -0.09290f, -0.12616f, 0.15252f,  -0.00540f, -0.13055f, -0.06022f, 0.32783f,  -0.01737f, -0.14561f, 0.16336f,
  0.14679f,  -0.56493f, -0.10632f, 0.04228f,  -0.05807f, 0.04268f,  0.09777f,  -0.03118f, 0.08026f,  -0.02373f,
  0.11382f,  -0.10601f, 0.11797f,  -0.15816f, 0.18875f,  -0.24262f, 0.22059f,  -0.24190f, 0.16014f,  -0.16597f,
  -0.24762f, -0.13850f, -0.03060f, 0.01652f,  0.24780f,  0.00461f,  0.04798f,  -0.13205f, -0.17872f, -0.27586f,
  0.17452f,  -0.07422f, -0.18426f, -0.22858f, 0.17663f,  0.17637f,  0.01567f,  0.04839f,  0.17465f,  0.04414f,
  0.21046f,  0.20266f,  -0.06857f, 0.13902f,  0.09125f,  0.15126f,  0.00066f,  0.25658f,  -0.11583f, 0.09393f,
  0.09252f,  -0.15663f, 0.25566f,  -0.29825f, 0.20961f,  0.02225f,  -0.07936f, 0.18718f,  -0.09630f, 0.05259f,
  -0.00489f, 0.30066f,  0.21130f,  -0.02953f, -0.13884f, -0.01595f, 0.07737f,  0.24748f,  0.00024f,  -0.24767f,
  0.08320f,  0.13200f,  -0.32829f, 0.23837f,  -0.14868f, 0.02548f,  0.02908f,  -0.06391f, 0.17978f,  -0.17895f,
  -0.28483f, 0.09445f,  0.03269f,  -0.28991f, 0.28999f,  -0.15826f, -0.07588f, 0.15063f,  0.02107f,  -0.09693f,
  0.00589f,  -0.23991f, -0.25147f, 0.07970f,  0.00099f,  -0.33922f, -0.00358f, 0.05907f,  -0.00584f, -0.06714f,
  -0.31410f, -0.18801f, -0.19762f, -0.01455f, -0.15881f, -0.02694f, -0.11556f, 0.15593f,  0.03082f,  0.07944f,
  -0.17182f, -0.12576f, -0.20700f, 0.01487f,  -0.31320f, 0.07076f,  0.14413f,  -0.04814f, 0.07926f,  0.29518f,
  -0.12083f, 0.22381f,  -0.09037f, -0.00754f, -0.10236f, -0.30394f, -0.04741f, -0.19619f, 0.00410f,  -0.02265f,
  -0.13500f, -0.13959f, -0.07177f, 0.04913f,  0.17050f,  0.29018f,  0.21969f,  0.12795f,  -0.08954f, -0.11920f,
  -0.02099f, -0.01349f, 0.18666f,  -0.11731f, -0.06940f, -0.01206f, 0.04575f,  -0.28522f, 0.06272f,  0.21929f,
  0.05285f,  -0.24949f, -0.07622f, 0.00994f,  0.12521f,  -0.20135f, -0.23649f, -0.01020f, 0.28374f,  -0.08653f,
  0.02941f,  -0.11032f, 0.10028f,  -0.09118f, 0.02639f,  0.03435f,  -0.09569f, 0.18350f,  -0.23319f, 0.21404f,
  0.24015f,  0.21260f,  -0.30559f, -0.05484f, 0.21301f,  -0.21983f, -0.07878f, 0.03676f,  -0.08183f, -0.06813f,
  -0.19167f, 0.12845f,  -0.02812f, -0.08852f, -0.00023f, 0.05442f,  -0.23315f, 0.25718f,  -0.17648f, 0.04466f,
  -0.27951f, -0.40209f, 0.03651f,  -0.23924f, -0.03780f, -0.03813f, 0.14600f,  0.03969f,  0.01548f,  0.10721f,
  0.05164f,  0.30330f,  0.16359f,  -0.30310f, 0.18994f,  0.09423f,  -0.17393f, -0.10583f, 0.15986f,  -0.17391f,
  0.28887f,  0.21200f,  0.14820f,  0.07474f,  -0.05620f, 0.07817f,  0.09121f,  -0.01250f, 0.02490f,  0.10721f,
  -0.10861f, -0.17472f, -0.16074f, 0.01766f,  0.13904f,  -0.01032f, -0.18168f, -0.07163f, 0.08660f,  0.25212f,
  0.06583f,  0.17320f,  0.18612f,  0.02844f,  -0.00684f, 0.05076f,  0.06633f,  -0.01868f, -0.36337f, -0.00145f,
  -0.20373f, 0.17958f,  0.01276f,  -0.19623f, 0.25943f,  -0.20367f, 0.04363f,  0.12020f,  -0.23678f, 0.23433f,
  -0.31519f, 0.45586f,  -0.19958f, 0.15573f,  -0.01105f, 0.05693f,  -0.00513f, -0.04786f, 0.04476f,  -0.07665f,
  0.03913f,  0.01571f,  0.12931f,  -0.04987f, -0.03622f, 0.12222f,  -0.12841f, -0.06675f, 0.12739f,  -0.27043f,
  0.19196f,  0.01555f,  -0.18623f, -0.10338f, 0.10205f,  0.24427f,  -0.05114f, -0.19983f, -0.06205f, 0.23172f,
  -0.04826f, 0.06662f,  -0.05736f, 0.11138f,  0.14769f,  0.16176f,  0.18896f,  0.17452f,  0.16037f,  0.16983f,
  -0.58447f, 0.14411f,  0.15819f,  -0.02144f, -0.05763f, 0.03507f,  0.07015f,  0.04073f,  0.00249f,  0.06873f,
  -0.02660f, -0.16384f, 0.28281f,  -0.21409f, 0.01775f,  0.19542f,  -0.24404f, 0.14437f,  0.01253f,  -0.14766f,
  -0.15907f, 0.18067f,  -0.22955f, 0.29121f,  -0.16690f, 0.04491f,  0.15167f,  -0.15487f, 0.01232f,  0.11974f,
  -0.10455f, -0.17684f, 0.00579f,  -0.06413f, -0.27576f, -0.13528f, -0.10478f, -0.08135f, -0.18969f, 0.04317f,
  -0.05531f, 0.07263f,  0.32632f,  0.25261f,  0.13853f,  0.22197f,  0.05991f,  0.10931f,  -0.02463f, -0.03771f,
  -0.20395f, -0.07239f, -0.09158f, 0.08176f,  0.07971f,  0.00478f,  0.08317f,  -0.05277f, -0.01755f, 0.30809f,
  0.08477f,  0.14641f,  -0.23790f, -0.10917f, 0.17376f,  0.00504f,  -0.17479f, -0.04727f, 0.13627f,  -0.02987f,
  -0.02589f, -0.05581f, -0.02698f, 0.18784f,  -0.07125f, -0.21985f, 0.14818f,  -0.04534f, -0.01314f, -0.27353f,
  0.10683f,  0.10494f,  0.03292f,  0.07779f,  0.04558f,  0.19903f,  -0.18060f, -0.25146f, -0.21800f, -0.08735f,
  -0.01506f, 0.02393f,  -0.05870f, 0.18272f,  -0.04665f, 0.25365f,  0.03352f,  0.07832f,  0.31578f,  -0.18382f,
  -0.13469f, 0.00802f,  -0.06824f, -0.14264f, 0.09786f,  0.14645f,  0.03437f,  0.25509f,  0.12065f,  -0.00470f,
  -0.17372f, 0.16471f,  -0.14580f, 0.20169f,  -0.19102f, 0.23891f,  -0.15672f, 0.17025f,  -0.14625f, 0.17294f,
  -0.15096f, -0.13882f, -0.24174f, -0.21843f, -0.16274f, -0.04953f, -0.15773f, -0.11578f, 0.05515f,  0.00516f,
  0.17293f,  -0.16682f, -0.18541f, 0.17506f,  0.00449f,  -0.19161f, 0.13069f,  -0.01691f, -0.16014f, 0.14568f,
  0.25916f,  -0.21056f, 0.25340f,  0.02887f,  -0.19870f, 0.19963f,  -0.21138f, 0.09373f,  -0.10720f, -0.05951f,
  0.04409f,  0.16961f,  0.14393f,  0.18203f,  -0.00318f, -0.15294f, 0.14754f,  -0.08258f, -0.39253f, 0.05379f,
  -0.29088f, 0.21829f,  -0.18293f, -0.05882f, 0.23213f,  -0.21198f, 0.21960f,  -0.17126f, 0.10365f,  0.07923f,
  0.17379f,  0.04236f,  -0.20095f, 0.24801f,  -0.04809f, -0.17663f, 0.21640f,  -0.13220f, -0.05155f, 0.19464f,
  0.30500f,  -0.09919f, -0.29554f, 0.13626f,  -0.13423f, 0.12329f,  -0.27827f, 0.21269f,  -0.14658f, 0.06335f,
  0.14760f,  0.19249f,  0.04762f,  -0.09385f, -0.16885f, -0.22736f, -0.04003f, 0.12119f,  0.21066f,  0.20016f,
  0.16428f,  -0.23129f, 0.09663f,  0.16263f,  -0.18679f, 0.07950f,  0.09320f,  -0.21933f, 0.16027f,  0.06644f,
  0.33437f,  0.09924f,  -0.07450f, -0.33940f, -0.21713f, 0.03763f,  0.16516f,  0.02988f,  0.01462f,  -0.08174f,
  0.05556f,  0.15790f,  -0.10683f, -0.23347f, -0.02877f, 0.17658f,  0.27350f,  -0.04794f, -0.19388f, -0.06425f,
  0.19943f,  0.08925f,  0.13219f,  -0.00961f, -0.05766f, -0.26293f, -0.24305f, -0.23162f, -0.16636f, -0.25138f,
  0.27138f,  -0.13496f, -0.01964f, 0.30839f,  -0.36682f, 0.11144f,  0.11409f,  -0.07192f, -0.13701f, 0.09785f,
  -0.23936f, -0.16826f, 0.22517f,  -0.12862f, 0.14949f,  0.15623f,  0.08161f,  -0.08912f, 0.05373f,  -0.14484f,
  0.01871f,  0.10768f,  0.03986f,  0.20721f,  0.07845f,  -0.16446f, -0.10902f, 0.16222f,  -0.18383f, 0.00369f,
  0.21345f,  -0.22268f, 0.07646f,  0.10230f,  -0.22599f, 0.20325f,  -0.10195f, -0.10515f, 0.20697f,  -0.13575f,
  -0.04869f, -0.07865f, -0.12637f, -0.00702f, -0.06357f, -0.11804f, -0.19936f, -0.23968f, -0.09776f, 0.05790f,
  -0.07910f, 0.02530f,  -0.05950f, 0.08575f,  0.01864f,  0.07607f,  -0.15311f, 0.29688f,  -0.13386f, 0.16496f,
  -0.09440f, 0.25161f,  -0.35154f, 0.16061f,  0.06074f,  -0.17220f, 0.10420f,  0.15929f,  -0.18229f, 0.19977f
};

static float tbeExcFilterCB2_4b[96] = {
  -0.20232f, 0.19847f,  -0.096441f,  0.20558f,   0.1712f,   0.14251f,   0.18595f,  -0.059879f,  0.22704f,   0.098489f,
  -0.21216f, 0.1781f,   0.14201f,    0.13805f,   0.18921f,  0.10948f,   0.21574f,  -0.19181f,   -0.15192f,  -0.20135f,
  -0.16245f, 0.15589f,  -0.20001f,   0.15736f,   0.11894f,  -0.22244f,  0.10315f,  0.20449f,    0.19699f,   0.16757f,
  -0.18169f, -0.1969f,  0.21968f,    -0.17568f,  0.08214f,  -0.073996f, -0.17077f, 0.094474f,   -0.016721f, -0.21172f,
  -0.22251f, 0.20939f,  0.17044f,    0.1361f,    -0.21435f, 0.22042f,   -0.11153f, -0.1802f,    0.10768f,   -0.21295f,
  -0.17889f, -0.2272f,  0.16925f,    0.12479f,   0.19545f,  0.18475f,   0.06574f,  -0.22264f,   -0.15453f,  -0.17849f,
  0.15459f,  -0.24222f, -0.0084513f, -0.081542f, -0.17888f, -0.22024f,  -0.19043f, 0.14675f,    -0.20002f,  -0.19699f,
  0.063592f, -0.17998f, 0.019109f,   0.1948f,    0.21405f,  -0.15812f,  0.19539f,  0.19374f,    -0.18862f,  0.13162f,
  0.18746f,  0.17667f,  -0.21274f,   -0.12737f,  0.2333f,   0.18153f,   -0.21589f, -0.0058148f, 0.043154f,  0.1992f,
  -0.11754f, -0.19539f, -0.15312f,   0.1694f,    0.18711f,  -0.20856f
};

static const float tbeLSFCB1_7b[128 * LPC_ORDER] = {
  0.04864f,  0.097476f, 0.14699f, 0.19811f, 0.25074f, 0.32976f, 0.36053f, 0.38823f, 0.42603f, 0.46205f,
  0.078258f, 0.11627f,  0.15307f, 0.2182f,  0.26242f, 0.29803f, 0.34483f, 0.379f,   0.41075f, 0.43858f,
  0.048724f, 0.099256f, 0.15056f, 0.20264f, 0.26402f, 0.34633f, 0.37125f, 0.40096f, 0.43365f, 0.46697f,
  0.055234f, 0.09483f,  0.13869f, 0.18f,    0.22943f, 0.27291f, 0.31784f, 0.36125f, 0.41255f, 0.45768f,
  0.066955f, 0.11182f,  0.15389f, 0.19033f, 0.22682f, 0.26791f, 0.34946f, 0.38512f, 0.42342f, 0.46221f,
  0.14499f,  0.1748f,   0.21495f, 0.24694f, 0.28636f, 0.31766f, 0.35518f, 0.39053f, 0.4296f,  0.46383f,
  0.053712f, 0.093501f, 0.14021f, 0.18292f, 0.2327f,  0.27472f, 0.32114f, 0.36421f, 0.4071f,  0.45041f,
  0.066898f, 0.11273f,  0.16787f, 0.20781f, 0.24622f, 0.28312f, 0.32727f, 0.37084f, 0.40917f, 0.45845f,
  0.082957f, 0.12982f,  0.17424f, 0.21286f, 0.24847f, 0.27936f, 0.31235f, 0.34285f, 0.37285f, 0.40878f,
  0.050453f, 0.087648f, 0.14344f, 0.18596f, 0.23016f, 0.27458f, 0.32064f, 0.36275f, 0.41255f, 0.4558f,
  0.051327f, 0.098449f, 0.15099f, 0.19838f, 0.24737f, 0.2934f,  0.33846f, 0.38268f, 0.42641f, 0.46512f,
  0.05992f,  0.098888f, 0.14664f, 0.19564f, 0.24687f, 0.2953f,  0.34024f, 0.37436f, 0.4127f,  0.46074f,
  0.064031f, 0.10319f,  0.14764f, 0.19739f, 0.28187f, 0.31927f, 0.3543f,  0.39228f, 0.4299f,  0.46405f,
  0.05498f,  0.10968f,  0.16474f, 0.21945f, 0.27381f, 0.32726f, 0.37935f, 0.4227f,  0.44562f, 0.46469f,
  0.062601f, 0.099835f, 0.1538f,  0.20029f, 0.2468f,  0.31243f, 0.34783f, 0.37527f, 0.4072f,  0.44755f,
  0.074256f, 0.12069f,  0.16331f, 0.20117f, 0.24158f, 0.2817f,  0.32371f, 0.3614f,  0.3963f,  0.43522f,
  0.062513f, 0.093121f, 0.14336f, 0.21052f, 0.249f,   0.28973f, 0.32993f, 0.3629f,  0.39997f, 0.43306f,
  0.025216f, 0.043257f, 0.13114f, 0.17096f, 0.22462f, 0.26778f, 0.31784f, 0.36167f, 0.41032f, 0.45643f,
  0.056889f, 0.093219f, 0.1666f,  0.21076f, 0.25352f, 0.29067f, 0.32129f, 0.34992f, 0.37958f, 0.41368f,
  0.056254f, 0.095794f, 0.14664f, 0.19128f, 0.2395f,  0.2838f,  0.32869f, 0.36962f, 0.41141f, 0.45676f,
  0.058042f, 0.097978f, 0.15892f, 0.19464f, 0.23194f, 0.2935f,  0.32952f, 0.35889f, 0.40646f, 0.46064f,
  0.072914f, 0.1154f,   0.15946f, 0.20074f, 0.2373f,  0.26943f, 0.30625f, 0.33507f, 0.36892f, 0.45515f,
  0.056726f, 0.097439f, 0.14751f, 0.19242f, 0.24069f, 0.28525f, 0.33185f, 0.37655f, 0.42171f, 0.46229f,
  0.057682f, 0.099927f, 0.15032f, 0.19308f, 0.27116f, 0.30672f, 0.33711f, 0.36787f, 0.39748f, 0.42756f,
  0.059562f, 0.091735f, 0.1341f,  0.17118f, 0.21142f, 0.24863f, 0.29472f, 0.35438f, 0.41296f, 0.4628f,
  0.076592f, 0.11714f,  0.16126f, 0.19883f, 0.26108f, 0.2992f,  0.3282f,  0.36076f, 0.40563f, 0.46238f,
  0.081288f, 0.13113f,  0.18743f, 0.23964f, 0.28014f, 0.311f,   0.34508f, 0.38208f, 0.41473f, 0.44881f,
  0.047304f, 0.091933f, 0.14034f, 0.18718f, 0.23665f, 0.28615f, 0.34071f, 0.37923f, 0.41879f, 0.45996f,
  0.073207f, 0.11332f,  0.15612f, 0.19594f, 0.23554f, 0.27743f, 0.32333f, 0.36004f, 0.40608f, 0.4578f,
  0.044135f, 0.090759f, 0.13707f, 0.17933f, 0.23073f, 0.27435f, 0.32164f, 0.36583f, 0.41077f, 0.45869f,
  0.061503f, 0.099996f, 0.1528f,  0.20125f, 0.23896f, 0.27336f, 0.33323f, 0.37198f, 0.4063f,  0.46365f,
  0.065593f, 0.10711f,  0.16066f, 0.20394f, 0.24858f, 0.29493f, 0.33799f, 0.37688f, 0.41802f, 0.46047f,
  0.1059f,   0.15367f,  0.18936f, 0.22616f, 0.26279f, 0.28926f, 0.3175f,  0.35417f, 0.40672f, 0.45639f,
  0.057113f, 0.089617f, 0.12791f, 0.16286f, 0.21899f, 0.29084f, 0.35171f, 0.38775f, 0.42141f, 0.45997f,
  0.053929f, 0.092518f, 0.13694f, 0.1872f,  0.23374f, 0.27702f, 0.32099f, 0.36716f, 0.41372f, 0.45724f,
  0.077925f, 0.13348f,  0.17623f, 0.21205f, 0.24834f, 0.28115f, 0.32721f, 0.38949f, 0.43806f, 0.4682f,
  0.060914f, 0.096059f, 0.14495f, 0.19642f, 0.26599f, 0.30276f, 0.33096f, 0.36561f, 0.428f,   0.46364f,
  0.05613f,  0.085034f, 0.13865f, 0.22254f, 0.26806f, 0.30525f, 0.34751f, 0.38395f, 0.41763f, 0.45029f,
  0.064602f, 0.10449f,  0.14634f, 0.18852f, 0.23804f, 0.2827f,  0.32807f, 0.3707f,  0.41459f, 0.45941f,
  0.058853f, 0.13554f,  0.23094f, 0.26372f, 0.28659f, 0.31606f, 0.34768f, 0.38237f, 0.41999f, 0.459f,
  0.05125f,  0.089764f, 0.17961f, 0.22403f, 0.2602f,  0.29763f, 0.34402f, 0.37597f, 0.40581f, 0.42963f,
  0.050346f, 0.092015f, 0.14275f, 0.18846f, 0.23657f, 0.28188f, 0.33198f, 0.37714f, 0.43739f, 0.47361f,
  0.090389f, 0.13874f,  0.18458f, 0.22703f, 0.29216f, 0.32995f, 0.3617f,  0.3935f,  0.43168f, 0.46435f,
  0.062889f, 0.10177f,  0.15493f, 0.19945f, 0.25233f, 0.29641f, 0.32735f, 0.35234f, 0.38123f, 0.45544f,
  0.033993f, 0.10547f,  0.16782f, 0.19104f, 0.21646f, 0.2844f,  0.2997f,  0.3822f,  0.42213f, 0.4468f,
  0.048248f, 0.091496f, 0.13816f, 0.18174f, 0.22617f, 0.27066f, 0.31573f, 0.36917f, 0.41195f, 0.45331f,
  0.074263f, 0.11464f,  0.15112f, 0.19072f, 0.24866f, 0.3139f,  0.3564f,  0.39229f, 0.42873f, 0.45959f,
  0.082441f, 0.12775f,  0.17752f, 0.21919f, 0.26654f, 0.31239f, 0.35872f, 0.39247f, 0.42209f, 0.45135f,
  0.06041f,  0.099001f, 0.1455f,  0.18432f, 0.22311f, 0.25934f, 0.30034f, 0.339f,   0.38092f, 0.42745f,
  0.098797f, 0.15514f,  0.19949f, 0.23451f, 0.27097f, 0.30414f, 0.34261f, 0.38031f, 0.41939f, 0.45784f,
  0.050761f, 0.10016f,  0.15511f, 0.20496f, 0.28976f, 0.35413f, 0.36998f, 0.40295f, 0.43271f, 0.46698f,
  0.06635f,  0.10749f,  0.15417f, 0.20038f, 0.24819f, 0.29304f, 0.33287f, 0.36759f, 0.40764f, 0.45054f,
  0.069487f, 0.12266f,  0.1735f,  0.22063f, 0.26539f, 0.3029f,  0.34334f, 0.38586f, 0.42719f, 0.4649f,
  0.042813f, 0.091028f, 0.13746f, 0.18144f, 0.22793f, 0.27297f, 0.31582f, 0.36022f, 0.40902f, 0.45234f,
  0.052359f, 0.093423f, 0.14274f, 0.18587f, 0.23586f, 0.28088f, 0.32701f, 0.37263f, 0.41803f, 0.46095f,
  0.070718f, 0.11038f,  0.14953f, 0.18253f, 0.21624f, 0.26049f, 0.32113f, 0.3672f,  0.41231f, 0.45706f,
  0.097556f, 0.12551f,  0.1721f,  0.2097f,  0.25496f, 0.29517f, 0.33522f, 0.37297f, 0.41498f, 0.45778f,
  0.064392f, 0.10609f,  0.15365f, 0.19776f, 0.24462f, 0.28831f, 0.33764f, 0.3811f,  0.4242f,  0.46355f,
  0.073186f, 0.12058f,  0.16666f, 0.21015f, 0.25381f, 0.29592f, 0.3378f,  0.3776f,  0.4159f,  0.4579f,
  0.091626f, 0.11604f,  0.15985f, 0.19528f, 0.24234f, 0.28384f, 0.32961f, 0.37044f, 0.41356f, 0.45836f,
  0.057081f, 0.095632f, 0.14173f, 0.18279f, 0.22838f, 0.28121f, 0.32571f, 0.36764f, 0.41234f, 0.45558f,
  0.054602f, 0.093851f, 0.14172f, 0.18519f, 0.23076f, 0.27183f, 0.32759f, 0.36943f, 0.41137f, 0.45868f,
  0.092356f, 0.14423f,  0.18907f, 0.23602f, 0.2752f,  0.30097f, 0.32923f, 0.3666f,  0.43299f, 0.47154f,
  0.020284f, 0.067152f, 0.1739f,  0.19172f, 0.22009f, 0.2837f,  0.29809f, 0.38033f, 0.42259f, 0.44582f,
  0.11677f,  0.17269f,  0.20934f, 0.24439f, 0.27788f, 0.31092f, 0.34639f, 0.38046f, 0.42032f, 0.45872f,
  0.043648f, 0.096081f, 0.15832f, 0.21033f, 0.26148f, 0.30301f, 0.35086f, 0.39177f, 0.4316f,  0.4681f,
  0.086671f, 0.12893f,  0.16953f, 0.21426f, 0.28242f, 0.30587f, 0.34046f, 0.36881f, 0.40498f, 0.4608f,
  0.05893f,  0.10354f,  0.1605f,  0.21739f, 0.26171f, 0.29623f, 0.33495f, 0.37639f, 0.42006f, 0.46177f,
  0.058451f, 0.10759f,  0.16289f, 0.21735f, 0.27477f, 0.31757f, 0.35144f, 0.37944f, 0.40977f, 0.45046f,
  0.13913f,  0.16306f,  0.20118f, 0.22876f, 0.26581f, 0.2942f,  0.33234f, 0.36722f, 0.40766f, 0.44982f,
  0.064312f, 0.10151f,  0.14697f, 0.18944f, 0.23353f, 0.27556f, 0.32105f, 0.35401f, 0.39019f, 0.43029f,
  0.066387f, 0.1139f,   0.16282f, 0.1981f,  0.23374f, 0.26839f, 0.31431f, 0.37408f, 0.42376f, 0.46234f,
  0.0619f,   0.10224f,  0.15369f, 0.1959f,  0.23929f, 0.28086f, 0.32217f, 0.36659f, 0.40559f, 0.44546f,
  0.057058f, 0.088951f, 0.12949f, 0.17176f, 0.26222f, 0.30829f, 0.34607f, 0.38467f, 0.42381f, 0.45859f,
  0.049937f, 0.094674f, 0.14351f, 0.19269f, 0.24155f, 0.30233f, 0.35801f, 0.38773f, 0.42523f, 0.4617f,
  0.096405f, 0.12953f,  0.17659f, 0.21641f, 0.26497f, 0.30357f, 0.34612f, 0.38552f, 0.42775f, 0.46475f,
  0.069274f, 0.12394f,  0.18428f, 0.22001f, 0.26097f, 0.29437f, 0.32684f, 0.35971f, 0.392f,   0.426f,
  0.07173f,  0.11545f,  0.16149f, 0.2073f,  0.25003f, 0.29488f, 0.34333f, 0.38752f, 0.43048f, 0.46536f,
  0.025897f, 0.054595f, 0.13747f, 0.18048f, 0.23646f, 0.27848f, 0.33024f, 0.37767f, 0.4258f,  0.46747f,
  0.062263f, 0.10497f,  0.17325f, 0.2122f,  0.24606f, 0.27739f, 0.31206f, 0.35079f, 0.39653f, 0.44881f,
  0.080856f, 0.1174f,   0.15965f, 0.20324f, 0.24789f, 0.29084f, 0.33559f, 0.3797f,  0.42412f, 0.46362f,
  0.076273f, 0.1152f,   0.15864f, 0.19365f, 0.23081f, 0.26163f, 0.29772f, 0.34594f, 0.40989f, 0.45981f,
  0.05974f,  0.097397f, 0.14663f, 0.18948f, 0.23014f, 0.26658f, 0.31188f, 0.35323f, 0.39598f, 0.45568f,
  0.089729f, 0.12058f,  0.1664f,  0.20761f, 0.25415f, 0.29671f, 0.34251f, 0.38499f, 0.42675f, 0.46417f,
  0.10149f,  0.15478f,  0.20253f, 0.24714f, 0.28616f, 0.32199f, 0.35857f, 0.39359f, 0.43249f, 0.46541f,
  0.068134f, 0.10965f,  0.16946f, 0.21258f, 0.25223f, 0.29539f, 0.32954f, 0.36661f, 0.40406f, 0.44434f,
  0.059349f, 0.099026f, 0.14925f, 0.20131f, 0.2487f,  0.28452f, 0.3177f,  0.35592f, 0.41204f, 0.45923f,
  0.065178f, 0.10281f,  0.14506f, 0.19004f, 0.23703f, 0.28249f, 0.34337f, 0.37726f, 0.40877f, 0.44441f,
  0.058248f, 0.1002f,   0.14662f, 0.19279f, 0.24515f, 0.29091f, 0.34616f, 0.40158f, 0.4391f,  0.46714f,
  0.055435f, 0.10999f,  0.16531f, 0.22018f, 0.27454f, 0.32777f, 0.37764f, 0.40848f, 0.42345f, 0.4524f,
  0.094702f, 0.11922f,  0.16528f, 0.20083f, 0.24884f, 0.28901f, 0.33374f, 0.37321f, 0.4154f,  0.45969f,
  0.065859f, 0.11153f,  0.16175f, 0.19725f, 0.2667f,  0.2972f,  0.3296f,  0.39005f, 0.41908f, 0.44839f,
  0.068448f, 0.12152f,  0.17471f, 0.22659f, 0.27381f, 0.31568f, 0.35792f, 0.39513f, 0.43529f, 0.46713f,
  0.03068f,  0.069976f, 0.14897f, 0.19635f, 0.2515f,  0.29365f, 0.34592f, 0.39015f, 0.43145f, 0.46917f,
  0.0625f,   0.10732f,  0.16161f, 0.22149f, 0.27042f, 0.30207f, 0.32751f, 0.35529f, 0.3954f,  0.44926f,
  0.073237f, 0.11547f,  0.15621f, 0.20002f, 0.24426f, 0.28741f, 0.33136f, 0.37513f, 0.41916f, 0.46057f,
  0.072788f, 0.11042f,  0.14969f, 0.172f,   0.28589f, 0.29948f, 0.3576f,  0.37192f, 0.43892f, 0.46426f,
  0.060735f, 0.1061f,   0.15458f, 0.20272f, 0.25444f, 0.3012f,  0.34733f, 0.38491f, 0.42641f, 0.46586f,
  0.061916f, 0.10486f,  0.16011f, 0.20586f, 0.24633f, 0.28864f, 0.32991f, 0.36585f, 0.43974f, 0.46804f,
  0.04931f,  0.07895f,  0.14f,    0.19322f, 0.2453f,  0.29023f, 0.32821f, 0.35684f, 0.39085f, 0.45545f,
  0.071672f, 0.1113f,   0.17002f, 0.20712f, 0.28395f, 0.3044f,  0.35077f, 0.37205f, 0.43674f, 0.46667f,
  0.05397f,  0.08745f,  0.13262f, 0.1732f,  0.21461f, 0.25479f, 0.33363f, 0.37275f, 0.4197f,  0.45941f,
  0.047444f, 0.0917f,   0.13765f, 0.18167f, 0.22432f, 0.27282f, 0.31944f, 0.36299f, 0.40694f, 0.45558f,
  0.056411f, 0.10184f,  0.17531f, 0.20875f, 0.24522f, 0.27875f, 0.33244f, 0.38745f, 0.42799f, 0.46691f,
  0.061397f, 0.1026f,   0.15555f, 0.19894f, 0.24395f, 0.28636f, 0.32936f, 0.37276f, 0.41652f, 0.45946f,
  0.067086f, 0.10131f,  0.1415f,  0.17384f, 0.26202f, 0.29564f, 0.32718f, 0.35501f, 0.4041f,  0.45262f,
  0.06752f,  0.10817f,  0.14602f, 0.18037f, 0.23122f, 0.29473f, 0.33742f, 0.37734f, 0.42715f, 0.46179f,
  0.056339f, 0.097771f, 0.15026f, 0.19271f, 0.23301f, 0.2775f,  0.32642f, 0.37017f, 0.41986f, 0.46119f,
  0.078862f, 0.1313f,   0.17098f, 0.21256f, 0.25355f, 0.31264f, 0.37304f, 0.40151f, 0.44291f, 0.47174f,
  0.057228f, 0.087987f, 0.13248f, 0.17724f, 0.22664f, 0.29933f, 0.33536f, 0.36461f, 0.3966f,  0.4468f,
  0.071459f, 0.1196f,   0.17572f, 0.21851f, 0.25563f, 0.28666f, 0.31849f, 0.35939f, 0.42121f, 0.46212f,
  0.084105f, 0.11778f,  0.1555f,  0.18993f, 0.23727f, 0.29898f, 0.33703f, 0.36576f, 0.39955f, 0.44998f,
  0.059197f, 0.11086f,  0.16253f, 0.21338f, 0.26115f, 0.30845f, 0.35535f, 0.39323f, 0.43047f, 0.46691f,
  0.081157f, 0.14149f,  0.19367f, 0.23526f, 0.27272f, 0.31008f, 0.35214f, 0.39291f, 0.43546f, 0.46809f,
  0.059251f, 0.10234f,  0.18619f, 0.23621f, 0.27276f, 0.30402f, 0.33806f, 0.37437f, 0.42053f, 0.46013f,
  0.057636f, 0.11668f,  0.17332f, 0.21085f, 0.25074f, 0.28787f, 0.35466f, 0.38723f, 0.41556f, 0.45072f,
  0.077062f, 0.11305f,  0.16977f, 0.21412f, 0.25478f, 0.31383f, 0.34803f, 0.37685f, 0.41875f, 0.45695f,
  0.079259f, 0.12789f,  0.17309f, 0.21644f, 0.25272f, 0.28551f, 0.31874f, 0.34827f, 0.38158f, 0.45512f,
  0.057262f, 0.09683f,  0.14579f, 0.18805f, 0.23294f, 0.27595f, 0.31965f, 0.366f,   0.4105f,  0.45759f,
  0.050687f, 0.083651f, 0.16807f, 0.20719f, 0.26005f, 0.29982f, 0.33047f, 0.36335f, 0.40416f, 0.45711f,
  0.074028f, 0.12257f,  0.16312f, 0.20115f, 0.24125f, 0.28368f, 0.36765f, 0.39595f, 0.43793f, 0.4697f,
  0.077292f, 0.13171f,  0.18313f, 0.223f,   0.26128f, 0.29794f, 0.33419f, 0.37304f, 0.41163f, 0.45407f,
  0.094223f, 0.12981f,  0.17293f, 0.20371f, 0.23887f, 0.27876f, 0.32559f, 0.36707f, 0.41258f, 0.45899f,
  0.050304f, 0.095738f, 0.15217f, 0.19473f, 0.24594f, 0.28693f, 0.33484f, 0.38731f, 0.41925f, 0.44441f,
  0.045328f, 0.086714f, 0.13202f, 0.1828f,  0.22775f, 0.27262f, 0.31975f, 0.36471f, 0.40814f, 0.45356f,
  0.066427f, 0.10038f,  0.1371f,  0.17293f, 0.22457f, 0.27187f, 0.31852f, 0.38646f, 0.4289f,  0.46181f,
  0.037658f, 0.091131f, 0.15119f, 0.19697f, 0.25015f, 0.28876f, 0.31699f, 0.374f,   0.41923f, 0.45872f,
  0.05842f,  0.088421f, 0.12705f, 0.16466f, 0.2148f,  0.26252f, 0.3135f,  0.35408f, 0.39721f, 0.4461f
};

static const float tbeLSFCB2_7b[128 * LPC_ORDER] = {
  -0.0033738f,  -0.0050967f,  -0.0024505f,  0.00060316f,  -0.0033366f,  -0.0073075f,  0.0079901f,   0.00067571f,
  -0.0049741f,  0.0128f,      0.012948f,    0.0019886f,   -0.016026f,   0.016136f,    0.0058878f,   -0.0057473f,
  -0.0017062f,  0.00060323f,  -0.00091923f, -0.004685f,   -0.00042571f, 0.0071852f,   0.010713f,    0.0027249f,
  -0.0011414f,  -0.010949f,   0.011049f,    0.0018291f,   -0.0077171f,  0.0076406f,   -0.0031981f,  -0.00066035f,
  0.0075435f,   0.0024433f,   0.014231f,    0.0046099f,   0.0026582f,   0.0097726f,   0.0039738f,   0.0040919f,
  -0.009001f,   -0.020644f,   0.011804f,    0.0029131f,   -0.00053975f, -0.0054943f,  -8.404e-05f,  -0.0068575f,
  -0.0067836f,  -2.4111e-05f, -0.0064573f,  0.00063911f,  -0.00090323f, 0.0032965f,   -0.0013877f,  0.0038653f,
  -0.0036528f,  -0.0019372f,  -0.0016732f,  0.001742f,    -0.0030982f,  0.0034804f,   -0.0021024f,  -0.01048f,
  0.00088063f,  0.012339f,    0.0090208f,   -0.0030284f,  -0.0093708f,  0.01209f,     -0.0074407f,  0.00014694f,
  -0.0068791f,  0.00403f,     -0.0081366f,  0.0040376f,   -0.0073091f,  0.0078825f,   -0.0050438f,  0.013234f,
  0.0013473f,   -0.011654f,   -0.0095678f,  -0.0018554f,  0.0087327f,   0.0032954f,   -0.00063261f, 0.000127f,
  0.00098068f,  0.006501f,    0.0062845f,   -0.0053147f,  0.0013231f,   0.010573f,    0.00084207f,  -0.0040486f,
  0.0089903f,   0.0071709f,   -0.0035341f,  -0.0035714f,  -0.0044538f,  -0.0091488f,  -0.011355f,   -0.013066f,
  -0.0067915f,  0.0001877f,   0.0060965f,   0.0064312f,   0.0077401f,   0.0052215f,   -0.0024544f,  -0.012369f,
  0.0034858f,   -0.010718f,   0.0066813f,   -0.0051359f,  0.0046463f,   -0.0075307f,  0.012822f,    0.0014509f,
  0.00020442f,  0.00098089f,  -0.00066787f, -0.00022403f, -0.00024465f, 0.00072329f,  0.0015561f,   0.007021f,
  0.0078274f,   0.0029962f,   8.7354e-05f,  -0.0013362f,  -0.0021026f,  0.0021692f,   -0.0071229f,  -0.00066704f,
  -0.0028859f,  0.0031259f,   0.00022861f,  -0.0020446f,  0.0037583f,   -0.0017132f,  -0.0046239f,  -0.0035781f,
  -0.0023725f,  -0.0075864f,  -0.0079794f,  -0.0017857f,  -0.0092832f,  -0.015374f,   -0.00044906f, -0.0021464f,
  0.0016412f,   -0.00023684f, 0.0058154f,   0.0081492f,   -0.00065767f, -0.0071293f,  0.00087856f,  -0.0016193f,
  -0.0016057f,  -0.0085544f,  0.0034142f,   -0.0038018f,  -0.0098703f,  0.0049896f,   -0.0049545f,  -0.0098551f,
  -0.013514f,   0.0095388f,   -0.00035402f, 0.0052045f,   -0.0006775f,  -0.0013306f,  0.015984f,    0.0019703f,
  -0.0018453f,  0.0016527f,   -0.0026987f,  -0.013263f,   -0.00053254f, 2.3233e-05f,  -0.0036359f,  -0.0014428f,
  -0.0091627f,  -0.016943f,   0.0026512f,   0.0064622f,   0.0056695f,   0.00078286f,  0.006311f,    0.012849f,
  -0.0031077f,  -0.014646f,   0.0040316f,   0.0026372f,   -0.0036854f,  0.00077623f,  0.0063404f,   0.0028549f,
  0.0066521f,   -0.0036089f,  -0.0085443f,  0.0096154f,   -0.0065373f,  0.010192f,    0.0015831f,   0.004353f,
  0.0087702f,   -0.0035687f,  0.0033821f,   -0.00082867f, -0.0083511f,  -0.014438f,   -0.004046f,   -0.0084023f,
  -0.0038481f,  -0.0019046f,  -0.0082494f,  0.005146f,    -0.0033451f,  -0.0013179f,  -0.0030447f,  -0.005207f,
  -0.0057024f,  -0.0072138f,  -0.0087169f,  -0.0059023f,  0.0096995f,   0.012958f,    0.0021319f,   -0.0081139f,
  -0.012495f,   0.010252f,    -0.0011931f,  -0.0086508f,  0.0055046f,   -0.0039656f,  0.0094165f,   0.0023278f,
  0.0078144f,   0.0097683f,   0.0033428f,   -0.0067261f,  -0.012963f,   0.0043509f,   0.0011054f,   -0.0043085f,
  -0.0084031f,  0.0080916f,   0.0028109f,   -0.002951f,   -0.0011123f,  -0.0049717f,  -0.0025641f,  0.00022739f,
  -0.0013617f,  -0.0041082f,  -0.001386f,   -0.0024722f,  -0.0097288f,  -0.0070537f,  0.0033394f,   0.0030676f,
  -0.00091359f, -0.0049612f,  -0.0019545f,  0.0037784f,   0.0052258f,   0.0038691f,   -0.0032903f,  0.0027699f,
  0.00015955f,  -0.002362f,   0.0012543f,   -0.0064367f,  0.0016557f,   -0.00244f,    0.00023255f,  -0.0021582f,
  -0.0014599f,  0.0055184f,   0.0038763f,   -0.00039f,    0.0040944f,   0.0020866f,   -0.0013672f,  0.00086545f,
  -0.0012045f,  0.00082487f,  0.0046211f,   0.00035764f,  0.0036488f,   -0.0023281f,  0.0062446f,   0.0002166f,
  -0.0077984f,  0.0099815f,   -0.0018084f,  0.011112f,    0.0016611f,   1.2939e-06f,  -0.0012793f,  0.0035609f,
  0.0056211f,   -0.00055932f, 0.0039973f,   -0.0013747f,  -0.00074038f, 0.0017153f,   0.00058725f,  -0.0087604f,
  -0.010308f,   0.01259f,     0.0046192f,   -0.00022474f, -0.0052043f,  -0.011733f,   -0.0085437f,  0.0046128f,
  -0.0062325f,  0.008712f,    0.0013666f,   -0.011404f,   0.0048839f,   -0.0064933f,  0.0091219f,   0.0069683f,
  0.00018313f,  0.0016146f,   -0.018098f,   -0.00013665f, 0.001461f,    -0.0019136f,  0.0065345f,   0.0025556f,
  0.0029345f,   -0.0003172f,  -0.0021112f,  -0.00089155f, -0.00040805f, -0.0048584f,  -0.0014724f,  -0.0021233f,
  -0.0012732f,  -0.0040992f,  0.0045024f,   0.0021897f,   0.0019116f,   0.00042001f,  -0.0062558f,  -0.00093906f,
  0.008905f,    0.0059639f,   0.0024639f,   -0.006447f,   -0.011492f,   0.00095248f,  -0.009657f,   0.0050772f,
  0.0043933f,   -0.0018623f,  -0.010253f,   -0.0008817f,  -0.0048324f,  0.0093389f,   -0.00057209f, -0.013414f,
  0.0059907f,   0.0065995f,   -0.0040104f,  -0.015324f,   -0.008929f,   -0.0015683f,  -0.005418f,   -0.004256f,
  -0.0060551f,  -0.0034064f,  -0.0020447f,  -0.00048279f, -0.0081048f,  -0.014294f,   0.0039009f,   0.0039858f,
  -0.00012485f, 0.010313f,    0.010851f,    0.0057907f,   0.0017927f,   0.002824f,    -0.0026145f,  -0.0060108f,
  0.00024983f,  -0.0043173f,  -0.0082835f,  0.011647f,    0.0045482f,   0.0006986f,   -0.0061951f,  -0.017344f,
  -0.00076767f, -0.0090626f,  0.0076257f,   -0.0017522f,  -0.015359f,   0.0045376f,   -0.0027351f,  0.011736f,
  0.0038797f,   -0.0044323f,  -0.0069917f,  0.016168f,    0.0036334f,   -0.0045517f,  -0.010851f,   -0.008884f,
  -0.0034533f,  -0.004087f,   -0.0017564f,  -0.00098347f, 0.002366f,    0.0069382f,   0.0061931f,   -0.0026869f,
  -0.0061947f,  -0.0051338f,  -0.0066191f,  0.019446f,    0.0098203f,   0.0033385f,   -0.0094474f,  0.0089512f,
  0.0022903f,   -0.013195f,   0.0025569f,   0.0016783f,   -0.01106f,    0.0054979f,   -0.0032161f,  -0.0046311f,
  -0.0048953f,  -0.0074269f,  0.0020489f,   -0.00081186f, -0.0057533f,  -0.012657f,   0.013805f,    0.0073024f,
  -0.0023251f,  -0.016808f,   -0.001411f,   0.0004398f,   -0.00046747f, -0.0011374f,  0.0025923f,   0.0034523f,
  0.0036291f,   0.0052291f,   0.018561f,    0.014016f,    -0.0047295f,  5.2778e-05f,  0.01646f,     0.0067787f,
  0.0010021f,   0.0064695f,   0.00089286f,  -0.0054405f,  -0.0052415f,  0.010473f,    -0.00076958f, 0.00165f,
  -0.00062799f, -0.00044603f, -0.00052052f, -0.0025466f,  -0.005282f,   -0.0069465f,  -0.0052091f,  -0.0014461f,
  0.0021252f,   0.0038824f,   0.010478f,    -0.00187f,    -0.0076088f,  0.0032848f,   -0.0081481f,  -0.00023053f,
  0.00088363f,  -0.0045f,     0.015303f,    0.009348f,    0.0075455f,   0.0030336f,   0.0069181f,   0.005116f,
  0.0037474f,   0.0046312f,   0.0029691f,   -0.00083478f, 0.0013032f,   -0.0010091f,  8.7022e-05f,  0.00099763f,
  0.0025599f,   0.0032442f,   0.0038488f,   0.006216f,    0.0014355f,   -0.0045636f,  -0.00062864f, -0.00035939f,
  -0.00034916f, -0.0042912f,  -0.0025538f,  -0.0027637f,  -0.0054442f,  0.00083401f,  0.00098642f,  0.0029542f,
  -0.0099825f,  0.010445f,    -0.0053459f,  0.0036095f,   0.0011218f,   -0.0038479f,  -0.0053149f,  0.0046879f,
  0.0044914f,   -0.0022383f,  3.69e-05f,    0.0007688f,   0.0078989f,   -7.2548e-05f, -0.0094804f,  -0.001316f,
  0.0030737f,   0.00034295f,  0.0053075f,   0.0073394f,   0.0029704f,   -0.0066892f,  0.012774f,    0.0093008f,
  0.004004f,    0.003768f,    -0.0032167f,  -0.0019804f,  -0.004346f,   -0.012448f,   -0.00091205f, 0.0032467f,
  0.0016083f,   0.018181f,    0.012223f,    0.0083492f,   0.004264f,    -0.0012959f,  -0.0049639f,  -0.0021676f,
  -0.0055553f,  -0.0092209f,  0.0038384f,   0.010748f,    0.0048703f,   -0.0024465f,  -0.011367f,   -0.013529f,
  0.013385f,    0.0075372f,   0.00070678f,  0.0012527f,   0.00059284f,  0.0010384f,   0.00027204f,  0.0020407f,
  0.00071194f,  -0.00041039f, -0.0057402f,  -0.0058471f,  0.0021655f,   0.0029959f,   -0.007696f,   -0.0016448f,
  0.0001009f,   0.0011753f,   -0.00011241f, -2.1215e-05f, -0.00053122f, -0.00011623f, -0.0056771f,  0.0013054f,
  -0.0031828f,  0.01111f,     0.00040909f,  -0.0072058f,  0.0025313f,   -0.0018997f,  -0.0042289f,  -0.0070607f,
  -0.0021148f,  -0.0027145f,  0.0026941f,   -0.0018134f,  -0.012179f,   -0.0041855f,  0.0022514f,   -0.0029309f,
  -0.0058465f,  -0.0026506f,  0.0017931f,   0.0040927f,   0.0018938f,   0.0055681f,   0.0019182f,   -0.00086854f,
  -0.0067963f,  0.011922f,    -8.557e-05f,  -0.011312f,   -0.0026047f,  0.00019297f,  0.00064723f,  -0.00016162f,
  0.0016615f,   0.0036853f,   0.0005688f,   -0.0086656f,  -0.016717f,   -0.0057689f,  0.00074488f,  -0.003134f,
  -0.0057727f,  -0.01117f,    0.01268f,     0.0098299f,   0.010244f,    0.0084946f,   0.003526f,    -0.0029917f,
  -0.0041405f,  -0.003387f,   -0.0018398f,  -0.0046195f,  0.0016856f,   0.0013487f,   0.00080411f,  -0.0030705f,
  -0.0032835f,  0.004371f,    -0.0041434f,  0.003322f,    0.0038775f,   0.0086454f,   0.0026552f,   0.0015221f,
  0.0041733f,   -0.0048055f,  0.011272f,    -0.0019034f,  0.00013987f,  0.00053783f,  -0.0026667f,  -0.0012909f,
  0.0097443f,   -0.0012903f,  -0.016452f,   -0.00023452f, 0.0021603f,   -0.00093709f, 0.0034403f,   -0.00024351f,
  0.00062884f,  0.00089931f,  9.8444e-05f,  0.0013993f,   -0.0027756f,  -0.0029791f,  -0.0055777f,  0.0050009f,
  0.006798f,    -0.0013463f,  0.0074198f,   0.0069706f,   -0.0074253f,  0.0084734f,   0.0061445f,   -0.0026503f,
  -0.0097634f,  0.00081694f,  -0.0026763f,  -0.00036725f, -0.0013198f,  1.8214e-05f,  0.0027414f,   0.00037503f,
  -0.0012112f,  0.0010477f,   0.0022313f,   -0.00086024f, -0.0015458f,  -0.0040319f,  -0.0021435f,  -0.0063012f,
  0.0016416f,   -0.0001169f,  0.0072679f,   0.0010038f,   -0.0055345f,  -0.007117f,   -0.0010916f,  -0.0051307f,
  0.0042598f,   -0.0019813f,  -0.00063583f, 0.0031618f,   -0.0023306f,  0.0040729f,   -0.0022001f,  -0.00040755f,
  -0.00094126f, -0.0015579f,  6.7219e-05f,  -0.00060206f, 0.0023368f,   0.0010126f,   -0.0026323f,  -0.0022936f,
  0.0059458f,   0.0068403f,   0.0024864f,   -0.0071466f,  0.0066331f,   -0.0073453f,  0.0097246f,   -0.0042282f,
  0.0041505f,   0.0021008f,   -0.016807f,   0.0057933f,   -0.0045235f,  -0.0034402f,  -0.0048236f,  -0.0014792f,
  -0.00084557f, 0.0014749f,   -0.0031378f,  -0.0033945f,  0.0055424f,   -0.0066581f,  -0.0078276f,  0.011428f,
  0.0048686f,   -0.0072984f,  0.0040955f,   0.0041175f,   -0.0028428f,  -0.013834f,   0.0092732f,   0.0053051f,
  -0.00070057f, 0.00038323f,  -0.0035408f,  0.0028325f,   -0.0026307f,  -0.0045628f,  -0.00060193f, -0.0036339f,
  0.0013137f,   0.003022f,    0.0048401f,   0.0042219f,   0.0016667f,   -0.00089837f, -0.0018689f,  -0.0040325f,
  2.5023e-05f,  0.0031603f,   -0.0016944f,  -0.0013884f,  -0.016079f,   0.0035148f,   0.0071317f,   -0.0053233f,
  -0.011536f,   0.0064096f,   0.0028535f,   -0.00095704f, 0.0038693f,   0.0015512f,   -0.0027401f,  -0.0059966f,
  0.0014556f,   0.004416f,    0.0015389f,   -0.00043946f, -0.0015584f,  -0.0022047f,  -0.0029493f,  -0.0034837f,
  0.0045074f,   0.0012865f,   -0.0059786f,  -0.0092433f,  -0.0026688f,  -0.00035238f, -0.00034899f, 0.010248f,
  0.0022422f,   -0.0093553f,  -0.0033307f,  0.019279f,    0.013139f,    0.0053231f,   0.0029928f,   -0.0015028f,
  -0.0023552f,  0.003732f,    0.0025918f,   -0.0018276f,  -0.0035293f,  -0.0093155f,  3.1412e-05f,  0.01754f,
  0.008525f,    -8.2226e-05f, -0.0062365f,  0.0056609f,   0.00827f,     0.0011755f,   0.0021698f,   -0.0093478f,
  0.010831f,    0.00067315f,  -0.011426f,   0.010883f,    2.9322e-05f,  -0.011718f,   0.010417f,    0.0039614f,
  -0.016596f,   0.0048786f,   0.013883f,    0.0033902f,   -0.0021154f,  -0.006671f,   -0.00086168f, -0.001721f,
  -0.0052314f,  -0.013446f,   0.0067297f,   0.00086282f,  -0.00182f,    0.0071465f,   0.0034009f,   0.0072851f,
  0.0068965f,   -0.0023447f,  0.001996f,    0.011471f,    0.0066253f,   0.011287f,    0.0046972f,   -0.0027611f,
  -0.0095801f,  -0.0048864f,  0.0091495f,   0.003263f,    -0.005048f,   -0.012876f,   0.0058693f,   -0.00019421f,
  -0.00082205f, 0.0032631f,   -3.1582e-05f, -0.0038511f,  0.001328f,    -0.0040632f,  0.0025636f,   -0.0059073f,
  0.015318f,    0.0097693f,   -0.0017351f,  0.0030436f,   -0.0034414f,  -0.0065228f,  -0.012452f,   0.0025574f,
  0.0058775f,   5.0117e-05f,  0.010086f,    -0.0021564f,  -0.0035046f,  -0.0035807f,  -0.0049792f,  -0.0009847f,
  0.0029104f,   0.002844f,    0.002851f,    0.0046049f,   -0.005083f,   0.013272f,    -0.00037764f, 0.0030381f,
  0.0045864f,   -0.0014359f,  0.00127f,     -0.0071798f,  -0.009631f,   0.0096003f,   0.0080796f,   0.0028473f,
  -0.007346f,   0.005922f,    -0.0048908f,  -0.0093382f,  0.0068859f,   -0.0049879f,  -0.010212f,   0.0039635f,
  0.0051743f,   0.00012155f,  0.00050895f,  0.0023222f,   0.00083639f,  0.0038706f,   -0.0040472f,  0.0011418f,
  0.00067945f,  -5.1034e-05f, 0.0058772f,   0.0041806f,   -0.010246f,   0.0029443f,   0.013231f,    0.0036318f,
  -0.0038918f,  -0.0042087f,  0.011177f,    0.002187f,    -0.00066852f, -0.0067408f,  0.0016934f,   0.003308f,
  -0.0031393f,  -0.010722f,   -0.018724f,   0.010936f,    0.002685f,    -0.0055206f,  0.0090267f,   0.0032456f,
  0.0055789f,   0.0025694f,   0.0020443f,   -0.0021888f,  -0.005704f,   -0.013772f,   0.0032975f,   0.0064957f,
  0.0028365f,   0.011491f,    -0.0030089f,  -0.0082227f,  0.0006653f,   0.002544f,    -0.0030917f,  -0.012054f,
  -0.00010141f, -0.013176f,   0.0088397f,   0.001606f,    -0.0064244f,  -0.006928f,   -0.012502f,   -0.0070182f,
  -0.006828f,   -0.01022f,    0.0043518f,   -0.002241f,   0.0051323f,   -0.0061539f,  -0.013731f,   -0.001688f,
  0.0041423f,   -0.0052924f,  -0.0092637f,  0.014572f,    0.0092165f,   0.0022399f,   -0.00061931f, 0.00049278f,
  0.0023238f,   0.0059074f,   -0.00044415f, 9.4963e-05f,  0.00058929f,  0.0032814f,   -0.00020717f, 0.0041754f,
  0.0018861f,   -0.00047415f, 0.0047244f,   0.0016429f,   0.0028664f,   -0.0038686f,  -0.0046533f,  0.00070258f,
  0.0056519f,   -0.0016846f,  0.0045442f,   0.0031646f,   -0.0023324f,  0.011487f,    0.003523f,    -0.0082215f,
  -0.0061449f,  0.0015652f,   0.0005054f,   0.0073582f,   -0.0078761f,  0.00066592f,  -0.008553f,   0.0050735f,
  0.0033514f,   0.0037976f,   0.0073806f,   0.0033915f,   0.0014908f,   0.0036037f,   0.015007f,    0.0020241f,
  -0.0082223f,  -0.0046228f,  0.0028488f,   0.0070459f,   -0.00017514f, -0.0044093f,  -0.0054484f,  -0.0046528f,
  0.0048854f,   0.010659f,    -0.0036224f,  -0.001242f,   -0.0013521f,  -0.0066935f,  0.0076969f,   -0.0029588f,
  0.01064f,     0.0059621f,   0.00092722f,  -0.0022485f,  0.0060932f,   0.00066526f,  0.00029612f,  -0.0028998f,
  0.0025088f,   -0.0025396f,  -0.0015091f,  0.0010893f,   -0.0020664f,  -0.0053192f,  -0.014732f,   -0.017149f,
  0.0082359f,   0.0027278f,   -0.0051352f,  -0.010332f,   -0.00059401f, -0.0053366f,  0.0023232f,   0.0025058f,
  0.0016223f,   -0.0042095f,  0.001494f,    0.0016244f,   0.0039923f,   -0.0022333f,  0.0055181f,   -0.001276f,
  0.0052582f,   -0.0023304f,  0.01093f,     0.0058848f,   -0.0070247f,  -0.013607f,   -0.0033371f,  -0.0017745f,
  0.00053698f,  -0.0019928f,  0.010626f,    0.0054223f,   -0.012939f,   -0.0058982f,  0.010445f,    -0.0049987f,
  0.011234f,    0.0042429f,   -0.004099f,   0.0015575f,   0.0013182f,   0.0063017f,   0.00032155f,  0.0050266f,
  -0.0024505f,  0.001821f,    0.00075802f,  -0.0032266f,  0.0010825f,   -0.0011322f,  -0.0067547f,  -0.0037179f,
  0.0031508f,   -0.0001822f,  -0.0036987f,  -0.0020448f,  -0.012945f,   -0.018785f,   -0.00087844f, -0.007388f,
  -0.0044264f,  0.0081175f,   0.0050855f,   0.0014143f,   0.0020873f,   0.011096f,    0.010582f,    0.0032735f,
  -0.0034876f,  -0.0047622f,  0.0023574f,   0.0020282f,   0.00070882f,  -0.0021287f,  -0.00040972f, 0.003986f,
  0.0061966f,   0.0032577f,   -0.0039454f,  0.0033122f,   0.011697f,    0.013076f,    0.0054376f,   0.0038713f,
  0.0023382f,   -0.0013054f,  -0.0068595f,  -0.0089939f,  -0.014485f,   -0.0055215f,  -0.0045505f,  0.0038067f,
  -0.0014983f,  -0.0042546f,  -0.0040662f,  0.0014215f,   0.0014455f,   0.00010565f,  0.00064726f,  -0.00035887f,
  0.0014164f,   -0.0037665f,  -0.010614f,   0.0014526f,   -0.0067998f,  0.0035637f,   0.0078572f,   -3.0133e-05f,
  -0.0078522f,  -0.00014697f, 0.00031466f,  -0.00045723f, -0.0012963f,  0.00012077f,  -0.0051145f,  -0.0041483f,
  0.017735f,    0.01511f,     0.0063414f,   0.0010338f,   0.0021606f,   0.011486f,    0.0020718f,   -0.0059667f,
  -0.016966f,   0.011328f,    0.0040945f,   0.0030702f,   0.0062471f,   -0.0034135f,  -0.001849f,   -0.0011964f,
  -0.0028555f,  -0.0006517f,  0.0017533f,   -0.0033169f,  -0.0020561f,  0.0045762f,   -0.0049433f,  0.0003183f,
  0.0041923f,   -0.00079647f, 0.00042123f,  -0.0055307f,  0.006671f,    -0.00079251f, -0.0014758f,  -0.0004687f,
  -0.0011362f,  -0.00042724f, -0.0041451f,  -0.010959f,   -0.014114f,   0.0078211f,   0.0091115f,   0.0030067f,
  0.0010824f,   0.0030073f,   -0.0045863f,  -0.013546f,   -0.0070224f,  -0.016627f,   0.0066542f,   -0.0080025f,
  0.0095175f,   0.00021064f,  -0.0060474f,  0.0080393f,   0.00040446f,  -0.0076692f,  -0.0007001f,  -0.00255f,
  7.6797e-05f,  0.0009393f,   -0.0034742f,  0.0050465f,   0.0039907f,   -0.0021429f,  0.0031874f,   -0.00063982f,
  -0.0051911f,  0.0012867f,   0.0044422f,   0.0019897f,   -0.002951f,   -0.00070294f, 0.0033843f,   0.0052617f,
  0.00065565f,  -0.0039809f,  -0.0012687f,  0.00066928f,  -0.0036139f,  -0.0020267f,  0.016359f,    0.0065587f,
  -0.0024386f,  -0.0052983f,  -0.0092574f,  0.0046492f,   -0.0022368f,  -0.0075483f,  0.019209f,    0.0092911f,
  0.00078057f,  -0.005449f,   0.0094804f,   0.0068358f,   0.0055816f,   -0.00054304f, 0.00060813f,  -0.0018283f,
  -0.0031752f,  -0.0080716f,  4.8925e-05f,  0.014022f,    -0.0030176f,  0.0028409f,   0.0049171f,   0.00029681f
};

static const float gaus_dico[256] = {
  0.02164473f,  0.35885197f,  -0.16274954f, -0.08241354f, 0.07313631f,  -0.00054929f, -0.13080014f, 0.07226136f,
  -0.13965981f, -0.04834007f, -0.02745908f, -0.02867859f, 0.11216793f,  0.16604294f,  -0.00134274f, 0.06818508f,
  -0.17387933f, 0.09406016f,  -0.08150196f, 0.05083200f,  -0.01952806f, -0.10203217f, -0.03067050f, -0.05153965f,
  0.06250680f,  0.00859049f,  -0.12008808f, -0.11361376f, 0.17176038f,  0.01174004f,  -0.02275130f, -0.09895785f,
  -0.10167463f, -0.22059087f, -0.05334539f, -0.00629700f, -0.16706355f, 0.07795000f,  0.08731710f,  0.09669208f,
  0.15378080f,  0.01794813f,  -0.01549965f, -0.24923822f, 0.19985947f,  -0.10477958f, 0.06674605f,  -0.11186616f,
  -0.17927034f, 0.08443811f,  0.25542912f,  0.03167623f,  0.19633667f,  0.19163096f,  0.01907267f,  0.12298489f,
  -0.03147158f, 0.05562247f,  0.30200079f,  -0.04257871f, 0.08275045f,  -0.03386311f, -0.02265750f, 0.18742503f,
  -0.13598505f, -0.32004824f, -0.00438390f, -0.15576170f, 0.06006401f,  -0.00952147f, 0.18848655f,  0.06630960f,
  0.07121546f,  -0.00733249f, 0.08277771f,  0.22764891f,  0.06772452f,  -0.09509693f, -0.00172236f, 0.08452052f,
  0.17020901f,  -0.03737585f, 0.02349647f,  0.10855560f,  0.06854416f,  0.07084806f,  0.09390105f,  0.00124924f,
  0.03026483f,  -0.15169589f, 0.01347072f,  -0.15377805f, 0.14992996f,  0.11630810f,  0.03483583f,  -0.03914850f,
  -0.20075595f, 0.12728901f,  -0.04495851f, -0.11576717f, -0.15281813f, 0.06055827f,  -0.03471978f, -0.03617816f,
  0.17230885f,  0.03094525f,  -0.15618153f, 0.21792564f,  0.08106838f,  -0.22098514f, -0.10796417f, 0.07131225f,
  0.22092983f,  -0.01539366f, -0.02876964f, -0.30910203f, 0.02143815f,  -0.11630868f, -0.00922897f, 0.07431208f,
  0.15533504f,  0.11425125f,  0.07125455f,  -0.11914105f, -0.04275274f, -0.05072749f, -0.22143129f, 0.19787727f,
  -0.20946717f, -0.16564523f, 0.05962536f,  -0.22325630f, -0.04333350f, -0.04707248f, 0.16608582f,  0.00948954f,
  0.11283893f,  -0.04097161f, -0.09076904f, 0.26722300f,  0.00987607f,  -0.05807892f, 0.07872546f,  0.08040629f,
  0.12927419f,  -0.05647410f, 0.09603068f,  -0.02356448f, -0.02160797f, -0.11687102f, 0.07936122f,  -0.05764586f,
  -0.10510305f, -0.02326054f, 0.12021790f,  0.09782617f,  -0.22600858f, -0.02555378f, -0.03561033f, -0.01337216f,
  0.11311363f,  -0.03096960f, -0.22801498f, 0.05643769f,  0.13053033f,  0.04452197f,  -0.09299882f, -0.11475921f,
  0.02257649f,  -0.21770498f, -0.11454470f, -0.09435777f, 0.00638951f,  -0.36990553f, 0.04266735f,  0.06915011f,
  0.07644624f,  -0.24336053f, -0.03421960f, -0.10622191f, -0.17223521f, 0.04054553f,  0.13831380f,  0.02925055f,
  0.16207848f,  -0.12994884f, -0.09751288f, -0.05397306f, -0.09323815f, 0.13425350f,  -0.00046960f, 0.31072289f,
  0.13740718f,  0.05835414f,  -0.04803475f, 0.15423043f,  -0.09652353f, 0.14896898f,  -0.16368309f, 0.05875925f,
  -0.03678078f, -0.19627908f, 0.07034992f,  -0.27213186f, -0.04338680f, 0.01567988f,  -0.09158870f, 0.11987700f,
  0.07083926f,  0.01099900f,  -0.01084446f, 0.04508050f,  -0.10655984f, -0.13945042f, 0.05837287f,  0.08458713f,
  -0.04212087f, -0.15749574f, 0.11632511f,  0.07976698f,  0.06725866f,  -0.09567240f, 0.03796997f,  -0.09355708f,
  -0.13569611f, -0.19498724f, 0.14951572f,  -0.16023041f, 0.04185898f,  0.06099325f,  0.03425207f,  0.16211477f,
  0.03998571f,  -0.03629408f, -0.10099959f, 0.19540504f,  0.11653102f,  0.23601755f,  0.04943547f,  -0.26040605f,
  0.02153429f,  0.22880882f,  -0.13646534f, 0.03881640f,  -0.02896636f, 0.09774253f,  -0.13509314f, -0.08713179f,
  0.13485038f,  0.06968338f,  0.19561967f,  0.07884958f,  -0.10365590f, -0.10321335f, -0.09081125f, -0.00147976f
};

static int _TBE_randomSign(
                    short                    *seed,
                    short                    *scaled_abs_seed
) {
  int sign  = 1;
  short tmp = *seed;

  tmp              = E_UTIL_random(&tmp);
  *seed            = tmp;
  *scaled_abs_seed = ABS((short)((float)tmp * 0.0078f));
  if (tmp < 0) {
    sign = -1;
  }
  return sign;
}

static void _TBE_gammaShaping(
                    const float              *input,
                    float                    *output,
                    const float               gamma,
                    const int                 lpc_order
) {
  int i;
  float gain;

  output[0] = input[0];
  gain      = gamma;

  for (i = 1; i <= lpc_order; i++) {
    output[i] = gain * input[i];
    gain     *= gamma;
  }
}

static void _TBE_genRandVec(
                    float                    *output,
                    const int                 length,
                    short                    *seed
) {
  int i;
  short idx1, idx2, tmp;
  float gain1 = 563.154f;
  float gain2 = 225.261f;

  _TBE_randomSign(&seed[0], &idx1);
  _TBE_randomSign(&seed[1], &idx2);

  while (idx2 == idx1) {
    _TBE_randomSign(&seed[1], &idx2);
  }

  if (_TBE_randomSign(&seed[0], &tmp) < 0) {
    gain1 = -gain1;
  }

  if (_TBE_randomSign(&seed[1], &tmp) < 0) {
    gain2 = -gain2;
  }

  for (i = 0; i < length; i++, idx1++, idx2++) {
    idx1 &= 0x00ff;
    idx2 &= 0x00ff;
    output[i] = gain1 * gaus_dico[idx1] + gain2 * gaus_dico[idx2];
  }
}

static float _TBE_vecSum(
                    const float              *input,
                    const int                 length
) {
  int i;
  float acc = 0.0f;

  for (i = 0; i < length; i++) {
    acc += input[i];
  }

  return acc;
}

static float _TBE_vecMac(
                    const float              *input_a,
                    const float              *input_b,
                    const int                 length
) {
  int i;
  float mac = 0.0f;

  for (i = 0; i < length; i++) {
    mac += input_a[i] * input_b[i];
  }

  return mac;
}

static float _TBE_mean(
                    const float              *input,
                    const int                 length
) {
  float retVal = 0.0f;

  retVal  = _TBE_vecSum(input,
                        length);
  retVal /= (float)length;

  return retVal;
}

static void _TBE_convertLspLsf(
                    const float              *in,
                    float                    *out,
                    const int                 len,
                    const TBE_LSP2LSF_DIR     conv_dir
) {
  int i;
  float tmp;

  if (conv_dir == TBE_LSF2LSP) {
    tmp = 2.0f * (float)PI;
    for (i = 0; i < len; i++) {
      out[i] = (float)cos(in[i] * tmp);
    }
  }
  else {
    tmp = 0.5f * (float)(PI_INV);
    for (i = 0; i < len; i++) {
      out[i] = (float)(acos(in[i]) * tmp);
    }
  }
}

static void _TBE_shiftLsf(
                    float                    *lsf,
                    const int                 order
) {
  int i;
  int exit    = 0;
  float delta = 0.0f;

  do {
    exit = 1;

    for (i = 0; i <= order; i++) {
      if (i == 0) {
        delta = lsf[0];
      } else if (i == order) {
        delta = 0.5f - lsf[i - 1];
      } else {
        delta = lsf[i] - lsf[i - 1];
      }

      if (delta < 0.0234952f) {
        exit   = 0;
        delta -= (0.0234952f * 1.001f);

        if (i == 0) {
          lsf[i]     -= delta;
        } else if (i == order) {
          lsf[i - 1] += delta;
        } else {
          delta      *= 0.5f;
          lsf[i - 1] += delta;
          lsf[i]     -= delta;
        }
      }
    }
  } while (exit == 0);
}

static void _TBE_interpolation(
                    const float              *in,
                    float                    *state,
                    const int                 length,
                    float                    *out
) {
  int i, j;
  const int apL         = AP_NUM;
  const int apM1        = AP_NUM - 1;
  const int apM2        = AP_NUM - 2;
  const int apM1t2      = (2 * AP_NUM) - 1;
  float tmp[AP_NUM - 1] = {0};

  for (i = 0; i < length; i++) {
    tmp[0]   = state[0] + ap_filt2[0] * in[i];
    state[0] = in[i] - ap_filt2[0] * tmp[0];

    for (j = 1; j < apL - 1; j++) {
      tmp[j]   = state[j]   + ap_filt2[j] * tmp[j - 1];
      state[j] = tmp[j - 1] - ap_filt2[j] * tmp[j];
    }
    out[2 * i + 1] = state[apM1] + ap_filt2[apM1] * tmp[apM2];
    state[apM1]    = tmp[apM2]   - ap_filt2[apM1] * out[2 * i + 1];
  }

  for (i = 0; i < length; i++) {
    tmp[0]     = state[apL] + ap_filt1[0] * in[i];
    state[apL] = in[i]      - ap_filt1[0] * tmp[0];

    for (j = 1; j < apL - 1; j++) {
      tmp[j]         = state[apL + j] + ap_filt1[j] * tmp[j - 1];
      state[apL + j] = tmp[j - 1]     - ap_filt1[j] * tmp[j];
    }
    out[2 * i]    = state[apM1t2] + ap_filt1[apM1] * tmp[apM2];
    state[apM1t2] = tmp[apM2]     - ap_filt1[apM1] * out[2 * i];
  }
}

static void _TBE_nonLinearity(
                    const HTBE_BITSTREAM      tbe_bitstream,
                    const float              *input,
                    float                    *output,
                    float                    *old_tbe_exc_extended,
                    const int                 length
) {
  int i;
  TBE_NL_LEVEL nl_level;
  float* p_out;
  float inEner, outEner, temp;
  float temp_buff[524], temp_buff1[524];
  float a, b;
  float lpf_num[3] = {1.0f, 2.0f, 1.0f}, lpf_den[3] = {1.0f, 0.94f, 0.33f};
  float hpf_num[3] = {1.0f, -2.0f, 1.0f}, hpf_den[3] = {1.0f, 0.94f, 0.33f};

  nl_level = tbe_bitstream->tbe_nlConfig;
  if(tbe_bitstream->tbe_heMode == 1) {
      nl_level = NL_HARMONIC;
      if (tbe_bitstream->idxSubGains % 2 == 1) {
          nl_level = NL_SMOOTH;
      } 
  }
  if (tbe_bitstream->tbe_heMode == 0 && tbe_bitstream->idxMixConfig <= 1 && tbe_bitstream->tbe_nlConfig == NL_HARMONIC) {
      nl_level = NL_HYBRID;
  }

  p_out = output + NL_BUFF_OFFSET;
  mvr2r(old_tbe_exc_extended, output, NL_BUFF_OFFSET);

  if (nl_level == NL_HARMONIC) {
    inEner = _TBE_vecMac(input,
                         input,
                         length);

    for (i = 0; i < length; i++) {
      *p_out++ = (input[i] * input[i]) * (input[i] > 0 ? 1.0f : -1.0f);
    }
    outEner = _TBE_vecMac(output + NL_BUFF_OFFSET,
                          output + NL_BUFF_OFFSET,
                          length);
    temp = 0.0f;
    if (outEner != 0.0f)  {
      temp = (float)sqrt(inEner / outEner);
    }
    p_out   = output + NL_BUFF_OFFSET;

    for (i = 0; i < length; i++) {
      *p_out++ *= temp;
    }
  } else if (nl_level == NL_SMOOTH) {
    for (i = 0; i < length; i++) {
      *p_out++ = (float)fabs(input[i]);
    }
  } else if (nl_level == NL_HYBRID) {
    a      = 0.57f;
    b      = 0.098f;
    inEner = _TBE_vecMac(input,
                         input,
                         length);

    for (i = 0; i < length; i++) {
      *p_out++ = (input[i] * input[i]) * (input[i] > 0 ? 1.0f : -1.0f);
    }
    outEner      = _TBE_vecMac(output + NL_BUFF_OFFSET,
                               output + NL_BUFF_OFFSET,
                               length);
    temp = 0.0f;
    if (outEner != 0.0f)  {
      temp = (float)sqrt(inEner / outEner);
    }
    p_out        = output + NL_BUFF_OFFSET;
    *p_out      *= temp;
    temp_buff[0] = lpf_num[0] * p_out[0];

    p_out++;

    *p_out      *= temp;
    temp_buff[1] = lpf_num[0] * (*p_out) + lpf_num[1] * p_out[-1] - lpf_den[1] * temp_buff[0];

    p_out++;

    for (i = 2; i < length; i++) {
      *p_out      *= temp;
      temp_buff[i] = lpf_num[0] * p_out[0] + lpf_num[1] * p_out[-1] + lpf_num[2] * p_out[-2] -
                     lpf_den[1] * temp_buff[i - 1] - lpf_den[2] * temp_buff[i - 2];
      p_out++;
    }

    i             = 0;
    p_out         = output + NL_BUFF_OFFSET;
    temp_buff1[i] = hpf_num[0] * ((float)fabs(input[i]));
    *p_out++      = a* temp_buff[i] + b* temp_buff1[i];
    i++;

    temp_buff1[i] = hpf_num[0] * ((float)fabs(input[i])) + hpf_num[1] * ((float)fabs(input[i - 1])) -
                    hpf_den[1] * temp_buff1[i - 1];
    *p_out++ = a* temp_buff[i] + b* temp_buff1[i];

    i++;
    for (i = 2; i < length; i++) {
      temp_buff1[i] = hpf_num[0] * ((float)fabs(input[i])) + hpf_num[1] * ((float)fabs(input[i - 1])) +
                      hpf_num[2] * ((float)fabs(input[i - 2])) - hpf_den[1] * temp_buff1[i - 1] -
                      hpf_den[2] * temp_buff1[i - 2];
      *p_out++ = a* temp_buff[i] + b* temp_buff1[i];
    }
  }
  mvr2r(output + 2 * L_DIV_1024, old_tbe_exc_extended, NL_BUFF_OFFSET);
}

static void _TBE_convertLsfKernel (
                    float                    *set11,
                    float                    *set12,
                    float                    *set13,
                    float                    *set21,
                    float                    *set22,
                    float                    *set23,
                    const float              *p,
                    const float              *q,
                    const int                 length
) {
  int i;

  for (i = 0; i < length; i++) {
    set11[i + 1] = set11[i] - 2 * p[i] * set12[i] + set13[i];
    set21[i + 1] = set21[i] - 2 * q[i] * set22[i] + set23[i];
    set13[i]     = set12[i];
    set12[i]     = set11[i];
    set23[i]     = set22[i];
    set22[i]     = set21[i];
  }
}

static void _TBE_convertLsfLpc(
                    float                    *lpc,
                    float                    *lsf,
                    const int                 order
) {
  int i, j;
  int orderRS1       = order >> 1;
  float tmp          = 0.0f;
  float* plpc        = &(lpc[1]);
  float p[LPC_ORDER] = {0.0f};
  float q[LPC_ORDER] = {0.0f};
  float set_a[3][LPC_ORDER];
  float set_b[3][LPC_ORDER];

  memset(set_a, 0, sizeof(set_a));
  memset(set_b, 0, sizeof(set_b));

  if ((lsf[0] <= 0.0f) || (lsf[order - 1] >= 0.5f)) {
    if (lsf[0] <= 0.0f) {
      lsf[0] = 0.022f;
    }
    if (lsf[order - 1] >= 0.5f) {
      lsf[order - 1] = 0.499f;
    }

    tmp = (lsf[order - 1] - lsf[0]) * recip_order[order];
    for (i = 1; i < order; i++) {
      lsf[i] = lsf[i - 1] + tmp;
    }
  }

  for (i = 0; i < orderRS1; i++) {
    p[i] = (float)cos(6.2832f * lsf[2 * i]);
    q[i] = (float)cos(6.2832f * lsf[2 * i + 1]);
  }

  set_a[0][0] = 0.25f;
  set_b[0][0] = 0.25f;
  _TBE_convertLsfKernel(set_a[0],
                        set_a[1],
                        set_a[2],
                        set_b[0],
                        set_b[1],
                        set_b[2],
                        p,
                        q,
                        orderRS1);

  set_a[0][0] =  0.25f;
  set_b[0][0] = -0.25f;
  _TBE_convertLsfKernel(set_a[0],
                        set_a[1],
                        set_a[2],
                        set_b[0],
                        set_b[1],
                        set_b[2],
                        p,
                        q,
                        orderRS1);

  plpc[0] = 2 * (set_a[0][orderRS1] + set_b[0][orderRS1]);
  for (j = 2; j <= order; j++) {
    set_a[0][0] = 0.0f;
    set_b[0][0] = 0.0f;
    _TBE_convertLsfKernel(set_a[0],
                          set_a[1],
                          set_a[2],
                          set_b[0],
                          set_b[1],
                          set_b[2],
                          p,
                          q,
                          orderRS1);
    plpc[j - 1] = 2.0f * (set_a[0][orderRS1] + set_b[0][orderRS1]);
  }
}

static void _TBE_decimateAllpassSteep(
                    const float              *in,
                    float                    *state,
                    const int                 N,
                    float                    *out
) {
  int n, k;
  float temp[AP_NUM];

  for (k = 0; k < N / 2; k++) {
    temp[0] = state[0] + ap_filt1[0] * in[2 * k];
    state[0] = in[2 * k] - ap_filt1[0] * temp[0];
    for (n = 1; n < AP_NUM - 1; n++) {
      temp[n] = state[n] + ap_filt1[n] * temp[n - 1];
      state[n] = temp[n - 1] - ap_filt1[n] * temp[n];
    }
    out[k] = state[AP_NUM - 1] + ap_filt1[AP_NUM - 1] * temp[AP_NUM - 2];
    state[AP_NUM - 1] = temp[AP_NUM - 2] - ap_filt1[AP_NUM - 1] * out[k];
  }
  temp[0] = state[AP_NUM] + ap_filt2[0] * state[2 * AP_NUM];
  state[AP_NUM] = state[2 * AP_NUM] - ap_filt2[0] * temp[0];
  for (n = 1; n < AP_NUM - 1; n++) {
    temp[n] = state[AP_NUM + n] + ap_filt2[n] * temp[n - 1];
    state[AP_NUM + n] = temp[n - 1] - ap_filt2[n] * temp[n];
  }
  temp[AP_NUM - 1]      = state[2 * AP_NUM - 1] + ap_filt2[AP_NUM - 1] * temp[AP_NUM - 2];
  state[2 * AP_NUM - 1] = temp[AP_NUM - 2] - ap_filt2[AP_NUM - 1] * temp[AP_NUM - 1];
  out[0] = (float)((out[0] + temp[AP_NUM - 1]) * 0.5);
  for (k = 1; k < N / 2; k++) {
    temp[0] = state[AP_NUM] + ap_filt2[0] * in[2 * k - 1];
    state[AP_NUM] = in[2 * k - 1] - ap_filt2[0] * temp[0];
    for (n = 1; n < AP_NUM - 1; n++) {
      temp[n] = state[AP_NUM + n] + ap_filt2[n] * temp[n - 1];
      state[AP_NUM + n] = temp[n - 1] - ap_filt2[n] * temp[n];
    }
    temp[AP_NUM - 1] = state[2 * AP_NUM - 1] + ap_filt2[AP_NUM - 1] * temp[AP_NUM - 2];
    state[2 * AP_NUM - 1] = temp[AP_NUM - 2] - ap_filt2[AP_NUM - 1] * temp[AP_NUM - 1];
    out[k] = (float)((out[k] + temp[AP_NUM - 1]) * 0.5);
  }
  state[2 * AP_NUM] = in[N - 1];
}

static void _TBE_genNlExc(
                    const float              *tbe_exc_extended,
                    float                    *exc,
                    float                    *mem_gen_exc
) {
  int i;
  float excFB[2 * L_FRAME_TBE];

  for (i = 0; i < 2 * L_FRAME_TBE; i++) {
    excFB[i] = ((i % 2) == 0) ? (-tbe_exc_extended[i]) : (tbe_exc_extended[i]);
  }

  _TBE_decimateAllpassSteep(excFB,
                            mem_gen_exc,
                            2 * L_FRAME_TBE,
                            exc);
}

static void _TBE_autocorrelation(
                    const float              *x,
                    float                    *rxx,
                    const int                 order,
                    const int                 length,
                    const float              *window
) {
  int i;
  int lag;
  int lengthRS1         = length >> 1;
  float t[L_FRAME_1024] = {0.0f};

  for (i = 0; i < lengthRS1; i++) {
    t[i]             = x[i]             * window[i];
    t[i + lengthRS1] = x[i + lengthRS1] * window[lengthRS1 - 1 - i];
  }

  for (lag = 0; lag <= order; lag++) {
    rxx[lag] = t[0] * t[lag];
    for (i = 1; i < length - lag; i++) {
      rxx[lag] += t[i] * t[lag + i];
    }
  }
}

static void _TBE_levinsondurbin(
                    float                    *lpc,
                    const float              *rxx,
                    const int                 order
) {
  int i, j;
  float tmp[24] = {0.0f};
  float acc;
  float mem;
  float norm;

  tmp[0] = (-rxx[1]) / rxx[0];
  lpc[0] = 1.0f;
  lpc[1] = tmp[0];
  norm   = rxx[0] + rxx[1] * tmp[0];

  for (i = 2; i <= order; i++) {
    acc = 0.0f;

    for (j = 0; j < i; j++) {
      acc += rxx[i - j] * lpc[j];
    }
    tmp[i - 1] = (-acc) / norm;

    for (j = 1; j <= i / 2; j++) {
      mem         = lpc[j] + tmp[i - 1] * lpc[i - j];
      lpc[i - j] += tmp[i - 1] * lpc[j];
      lpc[j]      = mem;
    }
    lpc[i] = tmp[i - 1];
    norm  += tmp[i - 1] * acc;

    if (norm <= 0.0f) {
      norm = 0.01f;
    }
  }
}

static void _TBE_genNmodExc(
                    const float              *excWhtnd,
                    const float              *voice_factors,
                    float                    *mem_csfilt,
                    short                    *tbe_seed,
                    const float              *lpc_sf,
                    float                    *wn_ana_mem,
                    float                    *wn_syn_mem,
                    float                    *White_exc
) {
  int i, k;
  float excTmp2[L_FRAME_TBE], excNoisyEnv[L_FRAME_TBE], varEnvShape;
  float csfilt_num2[1] = {0.2f};
  float csfilt_den2[2] = {1.0f, -0.8f};
  float wn_lpc_temp[LPC_ORDER + 1];

  for (k = 0; k < L_FRAME_TBE; k++) {
      excTmp2[k] = (float)(fabs(excWhtnd[k]));
  }
  varEnvShape = _TBE_mean(voice_factors,
                          4);
  varEnvShape = 1.09875f - 0.49875f * varEnvShape;
  varEnvShape = MIN(MAX(varEnvShape, 0.6f), 0.999f);
  csfilt_num2[0] = 1.0f - varEnvShape;
  csfilt_den2[1] = -varEnvShape;

  if (*mem_csfilt == 0) {
    float tmp_scale = 0;

    for (i = 0; i < L_SUBFR_TBE / 4; i++) {
      tmp_scale += excTmp2[i];
    }
    *mem_csfilt = varEnvShape*(tmp_scale / (L_SUBFR_TBE / 4));
  }

  for (k = 0; k < L_FRAME_TBE; k++) {
    excNoisyEnv[k] = *mem_csfilt + csfilt_num2[0] * excTmp2[k];
    *mem_csfilt = -csfilt_den2[1] * excNoisyEnv[k];
  }
  _TBE_genRandVec(White_exc,
                  256,
                  tbe_seed);

  for (i = 0; i < NB_SUBFR; i++) {
    _TBE_gammaShaping(lpc_sf + i * (LPC_ORDER + 1),
                      wn_lpc_temp,
                      0.55f,
                      LPC_ORDER);
    firfilt(White_exc + i * L_SUBFR,
            White_exc + i * L_SUBFR,
            wn_lpc_temp,
            wn_ana_mem,
            LPC_ORDER,
            L_SUBFR);
    _TBE_gammaShaping(lpc_sf + i * (LPC_ORDER + 1),
                      wn_lpc_temp,
                      0.7f,
                      LPC_ORDER);
    E_UTIL_synthesisPlus(wn_lpc_temp,
                         LPC_ORDER,
                         White_exc + i * L_SUBFR,
                         White_exc + i * L_SUBFR,
                         L_SUBFR,
                         wn_syn_mem,
                         1);
  }

  for (k = 0; k < L_FRAME_TBE; k++) {
    White_exc[k] *= excNoisyEnv[k];
  }
}

static void _TBE_genExc(
                    float                    *excWhtnd,
                    float                    *White_exc,
                    const float              *voice_factors,
                    const float               pow1,
                    const float               pow2,
                    float                    *excTBE
) {
  int i, j, k;
  float temp1, temp2;

  for (i = 0, k = 0; i < NB_SUBFR; i++) {
    temp1 = (float)sqrt(voice_factors[i]);
    temp2 = (float)sqrt((pow1 * (1.0f - voice_factors[i])) / pow2);

    for (j = 0; j < L_SUBFR_TBE; j++, k++) {
      excTBE[k] = temp1 * excWhtnd[k] + temp2 * White_exc[k];
    }
  }
}

static void _TBE_lpcSyn(
                    float                    *excWhtnd,
                    float                    *lpc_sf,
                    const float              *hbEnerTarget,
                    const int                 tbe_heMode,
                    const int                 tbe_hrConfig,
                    float                    *state_lpc_syn,
                    float                    *excitation
) {
  int i;
  float zero_mem[LPC_ORDER];
  float syn_ener_sf[4], tmp[80];

  set_zero(zero_mem, LPC_ORDER);
  if (tbe_heMode == 1 || tbe_hrConfig != 1) {
    E_UTIL_synthesisPlus(lpc_sf,
                         LPC_ORDER,
                         excWhtnd,
                         excitation,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 64,
                         excitation + 64,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + 2 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 128,
                         excitation + 128,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + 3 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 192,
                         excitation + 192,
                         64,
                         state_lpc_syn,
                         1);
  } else {
    E_UTIL_synthesisPlus(lpc_sf,
                         LPC_ORDER,
                         excWhtnd,
                         tmp,
                         64,
                         zero_mem,
                         1);

    syn_ener_sf[0] = 0.125f * _TBE_vecMac(tmp,
                                          tmp,
                                          64);

    E_UTIL_synthesisPlus(lpc_sf + (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 64,
                         tmp,
                         64,
                         zero_mem,
                         1);

    syn_ener_sf[1] = 0.125f * _TBE_vecMac(tmp,
                                          tmp,
                                          64);

    E_UTIL_synthesisPlus(lpc_sf + 2 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 128,
                         tmp,
                         64,
                         zero_mem,
                         1);

    syn_ener_sf[2] = 0.125f * _TBE_vecMac(tmp,
                                          tmp,
                                          64);

    E_UTIL_synthesisPlus(lpc_sf + 3 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 192,
                         tmp,
                         64,
                         zero_mem,
                         1);

    syn_ener_sf[3] = 0.125f * _TBE_vecMac(tmp,
                                          tmp,
                                          64);

    tmp[0] = (float)(hbEnerTarget[0]) / (syn_ener_sf[0] + syn_ener_sf[1] + syn_ener_sf[2] + syn_ener_sf[3]);

    for (i = 0; i < L_FRAME_TBE; i++) {
      excWhtnd[i] = excWhtnd[i] * (float)sqrt(tmp[0]);
    }

    E_UTIL_synthesisPlus(lpc_sf,
                         LPC_ORDER,
                         excWhtnd,
                         excitation,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 64,
                         excitation + 64,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + 2 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 128,
                         excitation + 128,
                         64,
                         state_lpc_syn,
                         1);

    E_UTIL_synthesisPlus(lpc_sf + 3 * (LPC_ORDER + 1),
                         LPC_ORDER,
                         excWhtnd + 192,
                         excitation + 192,
                         64,
                         state_lpc_syn,
                         1);
  }
}

static void _TBE_dequantizeParams(
                    const HTBE_BITSTREAM      tbe_bitstream,
                    float                    *Q_lsf,
                    float                    *Q_subgain,
                    float                    *Q_framegrain,
                    float                    *Q_hbEnerTarget,
                    float                    *Q_resSubGain,
                    float                    *Q_mixFactors,
                    float                    *Q_ExcResp
) {
  int i, j;
  float lsf_diff[LPC_ORDER];
  float filt_pow;

  if (tbe_bitstream->tbe_heMode == 0) {
    *Q_mixFactors = tbe_bitstream->idxMixConfig * 0.25f + 0.25f;

    if (tbe_bitstream->tbe_hrConfig == 1) {
      *Q_hbEnerTarget  = tbe_bitstream->idxShbFrGain * 0.0625f;
      *Q_hbEnerTarget  = (float)pow(10.0, *Q_hbEnerTarget);
      mvr2r(SubGain5bit + tbe_bitstream->idxResSubGains * NB_SUBFR, Q_resSubGain, NB_SUBFR);
    } else {
      set_zero(Q_ExcResp, RESP_ORDER + 1);
      Q_ExcResp[0] = 1.0f;
      mvr2r(tbeExcFilterCB1_7b + 10 * tbe_bitstream->idxShbExcResp[0], Q_ExcResp,     10);
      mvr2r(tbeExcFilterCB2_4b + 6 *  tbe_bitstream->idxShbExcResp[1], Q_ExcResp + 10, 6);

      filt_pow = (float)sqrt(_TBE_vecMac(Q_ExcResp,
                                         Q_ExcResp,
                                         RESP_ORDER + 1));

      if (filt_pow < 1e-6) {
        filt_pow = 1.0f;
      }
      for (i = 0; i < RESP_ORDER + 1; i++) {
        Q_ExcResp[i] = Q_ExcResp[i] / filt_pow;
      }
    }
  } else {
    *Q_hbEnerTarget = 0;
    *Q_mixFactors = 0;
    set_zero(Q_resSubGain, NB_SUBFR);
  }

  mvr2r(tbeLSFCB1_7b + tbe_bitstream->lsf_idx[0] * LPC_ORDER, Q_lsf, LPC_ORDER);
  mvr2r(tbeLSFCB2_7b + tbe_bitstream->lsf_idx[1] * LPC_ORDER, lsf_diff, LPC_ORDER);
  for (i = 0; i < LPC_ORDER; i++) {
    Q_lsf[i] = Q_lsf[i] + lsf_diff[i];
  }

  _TBE_shiftLsf(Q_lsf,
                LPC_ORDER);

  j = tbe_bitstream->idxSubGains * NUM_SUBGAINS;
  for (i = 0; i < NUM_SUBGAINS; i++) {
    Q_subgain[i] = SubGain5bit[j++];
  }

  for (i = NUM_SUBFR - 1; i >= 0; i--) {
    Q_subgain[i] = Q_subgain[i * NUM_SUBGAINS / NUM_SUBFR];
  }

  *Q_framegrain = GainFrame5bit[tbe_bitstream->idxFrameGain];
}

static void _TBE_scaleShaping(
                    const int                 length,
                    float                    *output,
                    float                    *overlap,
                    const float              *subgain,
                    const float               frame_gain,
                    const float              *subwin
) {
  int i, j, k, l_lahead, l_frame;
  int join_length, num_join;
  float mod_syn[L_FRAME_TBE + TBE_LAHEAD];

  l_frame = L_FRAME_TBE;
  l_lahead = TBE_LAHEAD;

  set_zero(mod_syn, l_frame + l_lahead);

  num_join = NUM_SUBFR / NUM_SUBGAINS;
  join_length = num_join * length;
  for (k = 0, j = 0; k < length; k++) {
    mod_syn[j] = output[j] * subwin[k + 1] * subgain[0];
    j++;
  }
  for (i = 0; i < NUM_SUBGAINS - 1; i++) {
    for (k = 0; k < join_length - length; k++) {
      mod_syn[j] = output[j] * subgain[i * num_join];
      j++;
    }

    for (k = 0; k < length; k++) {
      mod_syn[j] = output[j] * (subwin[length - k - 1] * subgain[i * num_join] + subwin[k + 1] * subgain[(i + 1) * num_join]);
      j++;
    }
  }
  for (k = 0; k < join_length - length; k++) {
    mod_syn[j] = output[j] * subgain[(NUM_SUBGAINS - 1) * num_join];
    j++;
  }
  for (k = 0; k < length; k++) {
    mod_syn[j] = output[j] * subwin[length - k - 1] * subgain[(NUM_SUBGAINS - 1) * num_join];
    j++;
  }
  for (i = 0; i < l_lahead; i++) {
    output[i] = mod_syn[i] * frame_gain;
    output[i] += overlap[i];
  }

  for (; i < l_frame; i++) {
    output[i] = mod_syn[i] * frame_gain;
  }

  for (; i < l_frame + l_lahead; i++) {
    overlap[i - l_frame] = mod_syn[i] * frame_gain;
  }
}

static void _TBE_genSynth(
                    const float              *input_synspeech,
                    float                    *output_synspeech,
                    float                    *state_lsyn_filt_local
) {
  int i;
  float speech_buf[2 * L_FRAME_TBE] = {0};

  _TBE_interpolation(input_synspeech,
                     state_lsyn_filt_local,
                     L_FRAME_TBE,
                     speech_buf);

  for (i = 0; i < 2 * L_FRAME_TBE; i++) {
    output_synspeech[i] = ((i % 2) == 0) ? (-speech_buf[i]) : (speech_buf[i]);
  }
}

static void _TBE_interpolateCode(
                    const float              *input_code,
                    float                    *output_code,
                    const int                 length
) {
  int i;

  for (i = 0; i < 2 * length; i += 2) {
    output_code[i] = input_code[i/2];
  }
  for (i = 1; i < 2 * length - 1; i += 2) {
    output_code[i] = 0.5f * (output_code[i-1] + output_code[i+1]);
  }
  output_code[i] = 0.5f * input_code[i/2];
}

static void _TBE_reset_data(
                    HTBE_DEC_DATA             tbeDecData,
                    const TBE_FRAME_CLASS     tbeFrmClass
) {
  int sFidx = (TBE_CLASS_ACELP_SECOND == tbeFrmClass) ? 1 : 0;

  tbeDecData->tbe_bitstream[sFidx].tbe_heMode       = 0;
  tbeDecData->tbe_bitstream[sFidx].idxFrameGain     = 0;
  tbeDecData->tbe_bitstream[sFidx].idxSubGains      = 0;
  tbeDecData->tbe_bitstream[sFidx].lsf_idx[0]       = 0;
  tbeDecData->tbe_bitstream[sFidx].lsf_idx[1]       = 0;
  tbeDecData->tbe_bitstream[sFidx].idxMixConfig     = 0;
  tbeDecData->tbe_bitstream[sFidx].idxShbFrGain     = 0;
  tbeDecData->tbe_bitstream[sFidx].idxResSubGains   = 0;
  tbeDecData->tbe_bitstream[sFidx].idxShbExcResp[0] = 0;
  tbeDecData->tbe_bitstream[sFidx].idxShbExcResp[1] = 0;
  tbeDecData->tbe_bitstream[sFidx].tbe_hrConfig     = 1;
  tbeDecData->tbe_bitstream[sFidx].tbe_nlConfig     = NL_SMOOTH;
}

static void _TBE_reset_memory(
                    HTBE_DEC_DATA             tbeDecData
) {
  set_zero(tbeDecData->tbe_memory.old_tbe_exc_extended,            NL_BUFF_OFFSET);
  set_zero(tbeDecData->tbe_memory.old_tbe_exc,                     TBE_PIT_MAX * 2);
  set_zero(tbeDecData->tbe_memory.mem_csfilt,                      2);
  set_zero(tbeDecData->tbe_memory.mem_gen_exc_filt_down,           (2 * AP_NUM + 1));
  set_zero(tbeDecData->tbe_memory.state_lpc_syn,                   LPC_ORDER);
  set_zero(tbeDecData->tbe_memory.state_syn_exc,                   TBE_LAHEAD);
  set_zero(tbeDecData->tbe_memory.mem_resp_excWhtnd,               RESP_ORDER);
  set_zero(tbeDecData->tbe_memory.mem_whtn_filt,                   LPC_WHTN_ORDER);
  set_zero(tbeDecData->tbe_memory.syn_overlap,                     TBE_LAHEAD);
  set_zero(tbeDecData->tbe_memory.gen_synth_state_lsyn_filt_local, (2 * AP_NUM + 1));
  set_zero(tbeDecData->tbe_memory.wn_ana_mem,                      LPC_ORDER);
  set_zero(tbeDecData->tbe_memory.wn_syn_mem,                      LPC_ORDER);
}

void TBE_apply(
                    HTBE_DEC_DATA             tbeDecData,
                    const TBE_FRAME_CLASS     tbeFrmClass,
                    float                    *tbe_exc_extended,
                    const float              *voice_factors,
                    float                    *synth,
                    float                    *pitch_buf,
                    const int                 first_frame,
                    float                    *cur_sub_Aq,
                    const int                 L_frame
) {
  HTBE_BITSTREAM tbe_bitstream = NULL;
  int i, j, k;
  float shaped_excitation[L_FRAME_TBE + TBE_LAHEAD];
  float lsf[LPC_ORDER], subGain[NUM_SUBFR], frameGain;
  float prev_pow, curr_pow, scale;
  float vf_modified[NB_SUBFR];
  float lsp_1[LPC_ORDER], lsp_2[LPC_ORDER], lsp_temp[LPC_ORDER];
  float lpc_sf[4 * (LPC_ORDER + 1)];
  const float* ptr_lsp_interp_coef;
  float hbEnerTarget;
  float resSubGain[NB_SUBFR];
  float mixFactors;
  float temp;
  float excWhtnd[L_FRAME_TBE];
  float White_exc[L_FRAME_TBE];
  float pow1, pow2;
  float ExcResp[RESP_ORDER + 1];
  float Rxx[LPC_WHTN_ORDER+1];
  float lpc_whtn[LPC_WHTN_ORDER + 1];
  float *tbe_exc_buf = &(tbeDecData->tbe_excitation[(TBE_PIT_MAX << 1)]);
  int tmp;
  int sFidx = (TBE_CLASS_ACELP_SECOND == tbeFrmClass) ? 1 : 0;

  mvr2r(&tbeDecData->tbe_excitation[2*L_DIV_1024], tbeDecData->tbe_memory.old_tbe_exc, 2 * TBE_PIT_MAX);

  tbe_bitstream = &tbeDecData->tbe_bitstream[sFidx];
  frameGain     = 0.0f;
  mixFactors    = 0.0f;
  hbEnerTarget  = 0.0f;

  _TBE_nonLinearity(tbe_bitstream,
                    tbe_exc_buf,
                    tbe_exc_extended,
                    tbeDecData->tbe_memory.old_tbe_exc_extended,
                    2 * L_frame);

  _TBE_dequantizeParams(tbe_bitstream,
                        lsf,
                        subGain,
                        &frameGain,
                        &hbEnerTarget,
                        resSubGain,
                        &mixFactors,
                        ExcResp);

  mvr2r(voice_factors, vf_modified, NB_SUBFR);
  if (_TBE_mean(voice_factors, 4) > 0.4f) {
    for (i = 1; i < NB_SUBFR; i++) {
      vf_modified[i] = 0.8f * voice_factors[i] + 0.2f * voice_factors[i - 1];
    }
  }

  _TBE_convertLspLsf(lsf,
                     lsp_2,
                     LPC_ORDER,
                     TBE_LSF2LSP);

  if (!first_frame) {
    mvr2r(tbeDecData->lsp_prev_interp, lsp_1, LPC_ORDER);
  } else {
    mvr2r(lsp_2, lsp_1, LPC_ORDER);
  }

  ptr_lsp_interp_coef = interpol_frac;
  for (j = 0; j < 4; j++) {
    for (i = 0; i < LPC_ORDER; i++) {
      lsp_temp[i] = lsp_1[i] * (*ptr_lsp_interp_coef) + lsp_2[i] * (*(ptr_lsp_interp_coef + 1));
    }
    ptr_lsp_interp_coef += 2;

    _TBE_convertLspLsf(lsp_temp,
                       lsp_temp,
                       LPC_ORDER,
                       TBE_LSP2LSF);

    _TBE_convertLsfLpc(lpc_sf + j * (LPC_ORDER + 1),
                       lsp_temp,
                       LPC_ORDER);

    lpc_sf[j * (LPC_ORDER + 1)] = 1.0f;
  }

  mvr2r(lsp_2, tbeDecData->lsp_prev_interp, LPC_ORDER);
  mvr2r(tbeDecData->tbe_memory.state_syn_exc, shaped_excitation, TBE_LAHEAD);

  _TBE_genNlExc(tbe_exc_extended,
                excWhtnd,
                tbeDecData->tbe_memory.mem_gen_exc_filt_down);

  if (tbe_bitstream->tbe_heMode == 0 && tbe_bitstream->tbe_hrConfig == 0) {
    firfilt(excWhtnd,
            excWhtnd,
            ExcResp,
            tbeDecData->tbe_memory.mem_resp_excWhtnd,
            RESP_ORDER,
            L_FRAME_TBE);
  } else {
    mvr2r(excWhtnd + L_FRAME_TBE - RESP_ORDER, tbeDecData->tbe_memory.mem_resp_excWhtnd, RESP_ORDER);
  }

  _TBE_autocorrelation(excWhtnd,
                       Rxx,
                       LPC_WHTN_ORDER,
                       L_FRAME_TBE,
                       win_flatten);

  Rxx[0] = MAX(Rxx[0], 1.0e-8f);
  for (i = 0; i <= LPC_WHTN_ORDER; i++) {
    Rxx[i] = Rxx[i] * wac[i];
  }

  Rxx[0] += 1.0e-8f;
  _TBE_levinsondurbin(lpc_whtn,
                      Rxx,
                      LPC_WHTN_ORDER);

  firfilt(excWhtnd,
          excWhtnd,
          lpc_whtn,
          tbeDecData->tbe_memory.mem_whtn_filt,
          LPC_WHTN_ORDER,
          L_FRAME_TBE);

  if (tbe_bitstream->tbe_heMode == 0 && tbe_bitstream->tbe_hrConfig == 1) {
    for (i = 0; i < L_FRAME_TBE; i++) {
      tmp = (i / 64) & 0xff;
      excWhtnd[i] *= resSubGain[tmp];
    }
  }

  _TBE_genNmodExc(excWhtnd,
                  vf_modified,
                  tbeDecData->tbe_memory.mem_csfilt,
                  tbeDecData->tbe_seed,
                  lpc_sf,
                  tbeDecData->tbe_memory.wn_ana_mem,
                  tbeDecData->tbe_memory.wn_syn_mem,
                  White_exc);

  for (k = 0, pow1 = 0.00001f, pow2 = 0.00001f; k < L_FRAME_TBE; k++) {
    pow1 += excWhtnd[k]  * excWhtnd[k];
    pow2 += White_exc[k] * White_exc[k];
  }

  if (tbe_bitstream->tbe_heMode == 0) {
    for (i = 0; i < NB_SUBFR; i++) {
      vf_modified[i] *= mixFactors;
    }
  }

  _TBE_genExc(excWhtnd,
              White_exc,
              vf_modified,
              pow1,
              pow2,
              excWhtnd);

  _TBE_lpcSyn(excWhtnd,
              lpc_sf,
              &hbEnerTarget,
              tbe_bitstream->tbe_heMode,
              tbe_bitstream->tbe_hrConfig,
              tbeDecData->tbe_memory.state_lpc_syn,
              shaped_excitation + TBE_LAHEAD);

  prev_pow = _TBE_vecMac(shaped_excitation,
                         shaped_excitation,
                         TBE_LAHEAD + 10);

  curr_pow = _TBE_vecMac(shaped_excitation + TBE_LAHEAD + 10,
                         shaped_excitation + TBE_LAHEAD + 10,
                         TBE_LAHEAD + 10);

  if (voice_factors[0] > 0.75f) {
    curr_pow *= 0.25;
  }

  scale = (float)sqrt(curr_pow / prev_pow);
  if ((prev_pow) == 0) {
    scale = 0;
  }
  for (i = 0; i < TBE_LAHEAD; i++) {
    shaped_excitation[i] *= scale;
  }
  for (; i < TBE_LAHEAD + 10; i++) {
    temp = (i - (TBE_LAHEAD - 1)) / 10.0f;
    shaped_excitation[i] *= (temp * 1.0f + (1.0f - temp) * scale);
  }

  mvr2r(shaped_excitation + L_FRAME_TBE, tbeDecData->tbe_memory.state_syn_exc, TBE_LAHEAD);

  _TBE_scaleShaping(TBE_OVERLAP_LEN,
                    shaped_excitation,
                    tbeDecData->tbe_memory.syn_overlap,
                    subGain,
                    frameGain,
                    subwin_tbe);

  _TBE_genSynth(shaped_excitation,
                synth,
                tbeDecData->tbe_memory.gen_synth_state_lsyn_filt_local);

  mvr2r(synth, tbeDecData->old_tbe_synth, 2 * L_FRAME_TBE);
}

void TBE_genTransition(
                    HTBE_DEC_DATA             tbeDecData,
                    int                       length,
                    float                    *output
) {
  int i;
  float syn_overlap[2 * L_FRAME_TBE] = {0.0f};
  float* input = NULL;
  float* old_hb_synth = NULL;
  float* state_lsyn_filt_local = NULL;

  input                 = tbeDecData->tbe_memory.syn_overlap;
  old_hb_synth          = tbeDecData->old_tbe_synth;
  state_lsyn_filt_local = tbeDecData->tbe_memory.gen_synth_state_lsyn_filt_local;

  _TBE_interpolation(input,
                     state_lsyn_filt_local,
                     TBE_OVERLAP_LEN,
                     syn_overlap);

  for (i = 0; i < 2 * TBE_OVERLAP_LEN; i++) {
    syn_overlap[i] = ((i % 2) == 0) ? (-syn_overlap[i]) : (syn_overlap[i]);
    output[i] = subwin_tbe_fb[i] * old_hb_synth[2 * L_FRAME_TBE - 1 - i] + subwin_tbe_fb[2 * TBE_OVERLAP_LEN - i] * syn_overlap[i];
  }

  for (; i < length; i++) {
    output[i] = old_hb_synth[2 * L_FRAME_TBE - 1 - i];
  }
}

void TBE_data(
                    HANDLE_BUFFER             hVm,
                    HANDLE_RESILIENCE         hResilience,
                    HANDLE_ESC_INSTANCE_DATA  hEscInstanceData,
                    HTBE_DEC_DATA             tbeDecData,
                    const TBE_FRAME_CLASS     tbeFrmClass
) {
  int sFidx = (TBE_CLASS_ACELP_SECOND == tbeFrmClass) ? 1 : 0;

  tbeDecData->tbe_bitstream[sFidx].tbe_heMode = GetBits(1,
                                                        TBE_DATA,
                                                        hResilience,
                                                        hEscInstanceData,
                                                        hVm);
  tbeDecData->tbe_bitstream[sFidx].idxFrameGain = GetBits(5,
                                                          TBE_DATA,
                                                          hResilience,
                                                          hEscInstanceData,
                                                          hVm);
  tbeDecData->tbe_bitstream[sFidx].idxSubGains = GetBits(5,
                                                         TBE_DATA,
                                                         hResilience,
                                                         hEscInstanceData,
                                                         hVm);
  tbeDecData->tbe_bitstream[sFidx].lsf_idx[0] = GetBits(7,
                                                        TBE_DATA,
                                                        hResilience,
                                                        hEscInstanceData,
                                                        hVm);
  tbeDecData->tbe_bitstream[sFidx].lsf_idx[1] = GetBits(7,
                                                        TBE_DATA,
                                                        hResilience,
                                                        hEscInstanceData,
                                                        hVm);

  if (tbeDecData->tbe_bitstream[sFidx].tbe_heMode == 0) {
    tbeDecData->tbe_bitstream[sFidx].tbe_hrConfig = GetBits(1,
                                                            TBE_DATA,
                                                            hResilience,
                                                            hEscInstanceData,
                                                            hVm);
    tbeDecData->tbe_bitstream[sFidx].tbe_nlConfig = GetBits(1,
                                                            TBE_DATA,
                                                            hResilience,
                                                            hEscInstanceData,
                                                            hVm);
    tbeDecData->tbe_bitstream[sFidx].idxMixConfig = GetBits(2,
                                                            TBE_DATA,
                                                            hResilience,
                                                            hEscInstanceData,
                                                            hVm);

    if (tbeDecData->tbe_bitstream[sFidx].tbe_hrConfig == 1) {
      tbeDecData->tbe_bitstream[sFidx].idxShbFrGain = GetBits(6,
                                                              TBE_DATA,
                                                              hResilience,
                                                              hEscInstanceData,
                                                              hVm);
      tbeDecData->tbe_bitstream[sFidx].idxResSubGains = GetBits(5,
                                                                TBE_DATA,
                                                                hResilience,
                                                                hEscInstanceData,
                                                                hVm);
    } else {
      tbeDecData->tbe_bitstream[sFidx].idxShbExcResp[0] = GetBits(7,
                                                                  TBE_DATA,
                                                                  hResilience,
                                                                  hEscInstanceData,
                                                                  hVm);
      tbeDecData->tbe_bitstream[sFidx].idxShbExcResp[1] = GetBits(4,
                                                                  TBE_DATA,
                                                                  hResilience,
                                                                  hEscInstanceData,
                                                                  hVm);
    }
  } else {
    tbeDecData->tbe_bitstream[sFidx].tbe_nlConfig = 1;
  }
}

void TBE_reset(
                    HTBE_DEC_DATA             tbeDecData
) {
  _TBE_reset_memory(tbeDecData);
}

void TBE_init(
                    HTBE_DEC_DATA             tbeDecData
) {
  int i;

  tbeDecData->tbe_seed[0] = 23;
  tbeDecData->tbe_seed[1] = 59;

  for (i = 0; i < LPC_ORDER; i++) {
    tbeDecData->lsp_prev_interp[i] = (float)cos((float)i * (float)PI / (float)10.0f);
  }

  set_zero(tbeDecData->old_tbe_synth,    2 * L_DIV_1024);
  set_zero(tbeDecData->tbe_synth_buffer, 2 * L_DIV_1024);

  _TBE_reset_memory(tbeDecData);

  _TBE_reset_data(tbeDecData,
                  TBE_CLASS_ACELP_FIRST);

  _TBE_reset_data(tbeDecData,
                  TBE_CLASS_ACELP_SECOND);
}

void TBE_mixPastExc(
                    HTBE_DEC_DATA             tbeDecData,
                    float                    *error,
                    const int                 sFrameIdx,
                    const int                 T0,
                    const int                 T0_frac
) {
  int i;
  int offset     = T0 * 2 + (int)((float)T0_frac * 0.5f + 4 + 0.5f) - 4;
  float *tbe_exc = &(tbeDecData->tbe_excitation[(sFrameIdx << 1) + (TBE_PIT_MAX << 1)]);

  if (sFrameIdx == 0) {
    memset(tbeDecData->tbe_excitation, 0, sizeof(tbeDecData->tbe_excitation));
    mvr2r(tbeDecData->tbe_memory.old_tbe_exc, tbeDecData->tbe_excitation, 2 * TBE_PIT_MAX );
  }

  for (i = 0; i < L_SUBFR * 2; i++) {
    tbe_exc[i] = tbe_exc[i - offset + (int)*error];
  }
  *error += (float)offset - (float)T0 * 2 - 0.5f * (float)T0_frac;
}

void TBE_prepExc(
                    HTBE_DEC_DATA             tbeDecData,
                    const int                 L_frame,
                    const int                 i_subfr,
                    const float               gain_pit,
                    const float               gain_code,
                    const float              *code,
                    const float              *code_formSharp,
                    const float               voice_fac,
                    float                    *voice_factors,
                    const float              *exc,
                    const float              *exc2
) {
  int i;
  float tmp_code[L_SUBFR * 2]    = {0.0f};
  float tmp_code_preInt[L_SUBFR] = {0.0f};
  float tmp                      = 1.0f;
  float voice_fac_proc           = 0.95f * voice_fac - 0.05f;
  float *tbe_exc                 = &(tbeDecData->tbe_excitation[(TBE_PIT_MAX << 1)]);

  *voice_factors = 1.0f / (1.0f + (float)exp(-4.0f * voice_fac_proc));
  *voice_factors = MIN(MAX(0.0f, *voice_factors), 1.0f);

  for (i = 0; i < L_SUBFR; i++) {
    tmp_code_preInt[i] = gain_code * code[i];
  }
  _TBE_interpolateCode(tmp_code_preInt,
                       tmp_code,
                       L_SUBFR);

  for (i = 0; i < L_SUBFR * 2; i++) {
    tbe_exc[i + i_subfr * 2] = gain_pit * tbe_exc[i + i_subfr * 2] + tmp_code[i];
  }
}
