/************************************************************************

This software module was originally developed by Fraunhofer IIS and
University of Erlangen (UER) in the course of development of the ISO/IEC 23008-3 for
reference purposes and its  performance may not have been optimized.
This software module is an implementation of one or more tools as
specified by the ISO/IEC 23008-3 standard. ISO/IEC gives you a
royalty-free, worldwide, non-exclusive,copyright license to copy,
distribute, and make derivative works of this software module or
modifications thereof for use in implementations or products claiming
conformance to the ISO/IEC 23008-3 standard and which satisfy any specified
conformance criteria.
Those intending to use this software module in products are advised that
its use may infringe existing patents.

ISO/IEC have no liability for use of this software module or
modifications thereof. Copyright is not released for products that do
not conform to the ISO/IEC 23008-3 standard.

Fraunhofer IIS and University of Erlangen (UER) retain full right to modify and use the
code for its own purpose, assign or donate the code to a third party and
to inhibit third parties from using the code for products that do not
conform to MPEG-related ITU Recommendations and/or ISO/IEC International
Standards.

This copyright notice must be included in all copies or derivative works.

Copyright (c) ISO/IEC 1996.

*************************************************************************/

/* CREATED BY :  Bernhard Grill -- August-96  */

#include <stdio.h>
#include <string.h>

#include "allHandles.h"
#include "tf_mainHandle.h"

#include "nok_ltp_common.h"      /* structs */
#include "obj_descr.h"           /* structs */
#include "tf_mainStruct.h"       /* structs */

#include "ntt_tvq.h"
#include "tf_main.h"
#include "psych.h"
#include "common_m4a.h"

/* dummy psychoacoustic module */

extern const short  sfb_96_1024[];

extern const short sfb_96_128[] ;

extern const short sfb_64_1024[] ;

extern const short sfb_64_128[] ;

extern const short sfb_48_1024[] ; 

extern const short sfb_48_960[] ; 

extern const short sfb_48_512[] ;

extern const short sfb_48_480[] ;

extern const short sfb_32_512[] ;

extern const short sfb_32_480[] ;

extern const short sfb_24_512[] ;

extern const short sfb_24_480[] ;

extern const short sfb_48_480[] ; 

extern const short sfb_48_128[] ;

extern const short sfb_48_120[] ;

extern const short sfb_32_1024[] ;

extern const short sfb_24_1024[] ;

extern const short sfb_24_960[] ;

extern const short sfb_24_128[] ;

extern const short sfb_24_120[] ;

extern const short sfb_16_1024[] ;

extern const short sfb_16_960[] ;

extern const short sfb_16_128[] ;

extern const short sfb_16_120[] ;

extern const short sfb_8_1024[] ;

extern const short sfb_8_128[] ;

extern const short sfb_8_960[] ;

extern const short sfb_8_120[] ;

extern const short sfb_32_960[] ;

extern const short sfb_32_120[] ;

extern const short sfb_48_512[] ; 

extern const short sfb_48_480[] ; 

extern const short sfb_32_512[] ; 

extern const short sfb_32_480[] ; 

extern const short sfb_24_512[] ; 

extern const short sfb_24_480[] ; 

extern const short sfb_8_768[];
extern const short sfb_8_96[];

extern const short sfb_16_768[];
extern const short sfb_16_96[];

extern const short sfb_24_768[];
extern const short sfb_24_96[];

extern const short sfb_32_768[];

extern const short sfb_48_768[];
extern const short sfb_48_96[];

extern const short sfb_64_768[];
extern const short sfb_64_96[];

extern const short sfb_96_768[];
extern const short sfb_96_96[];


static SR_INFO sr_info_aac[MAX_SAMPLING_RATES+1] =
{
  { 8000, 40, 15,
    sfb_8_1024,
    sfb_8_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 11025 ,43, 15,
    sfb_16_1024,
    sfb_16_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 12000 ,43, 15,
    sfb_16_1024,
    sfb_16_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 16000 ,43, 15,
    sfb_16_1024,
    sfb_16_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 22050 ,47, 15,
    sfb_24_1024,
    sfb_24_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 24000 ,47, 15,
    sfb_24_1024,
    sfb_24_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.05, 0.05, 0.05, 0.05, 
      0.15, 0.15, 0.15, 0.15, 0.15,   0.15, 0.20, 0.20, 0.20, 0.20, 
      0.20, 0.20, 0.20, 0.25, 0.30,   0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07,   0.10, 0.12, 0.15, 0.15, 0.20, 
      0.25, 0.30, 0.40, 0.90 , 0.90
    },
    { 0 },
    { 0 }
  },
  { 32000 ,51, 14,
    sfb_32_1024,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 44100 ,49, 14,
    sfb_48_1024,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 48000, 49, 14,
    sfb_48_1024,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 96000, 41, 12,
    sfb_96_1024,
    sfb_96_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { -1, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 }
  }
};


static SR_INFO sr_info_768[MAX_SAMPLING_RATES+3] =
{
  { 8000, 37, 14,
    sfb_8_768,
    sfb_8_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 11025, 39, 14,
    sfb_16_768,
    sfb_16_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 12000, 39, 14,
    sfb_16_768,
    sfb_16_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 16000, 39, 14,
    sfb_16_768,
    sfb_16_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 22050, 43, 14,
    sfb_24_768,
    sfb_24_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 24000, 43, 14,
    sfb_24_768,
    sfb_24_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.04, 0.04, 0.04,   0.04, 0.05, 0.05, 0.05, 0.05, 
      0.15, 0.15, 0.15, 0.15, 0.15,   0.15, 0.20, 0.20, 0.20, 0.20, 
      0.20, 0.20, 0.20, 0.25, 0.30,   0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07,   0.10, 0.12, 0.15, 0.15, 0.20, 
      0.25, 0.30, 0.40, 0.90 , 0.90
    },
    { 0 },
    { 0 }
  },
  { 32000, 43, 12,
    sfb_32_768,
    sfb_48_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 44100, 43, 12,
    sfb_48_768,
    sfb_48_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 48000, 43, 12,
    sfb_48_768,
    sfb_48_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 64000, 41, 12,
    sfb_64_768,
    sfb_64_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 88200, 37, 12,
    sfb_96_768,
    sfb_96_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 96000, 37, 12,
    sfb_96_768,
    sfb_96_96,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { -1, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 }
  }
};


static SR_INFO sr_info_960[MAX_SAMPLING_RATES+1] =
{
  { 8000  ,40, 15,
    sfb_8_960,
    sfb_8_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 11025 ,43, 15,
    sfb_16_960,
    sfb_16_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 12000 ,43, 15,
    sfb_16_960,
    sfb_16_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 16000 ,42, 15,
    sfb_16_960,
    sfb_16_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 24000 ,46, 15,
    sfb_24_960,
    sfb_24_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 32000 ,49, 14,
    sfb_32_960,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 44100 ,49, 14,
    sfb_48_960,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 48000, 49, 14,
    sfb_48_960,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 
      0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { -1 , 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 }
  }
};

static SR_INFO sr_info_480[MAX_SAMPLING_RATES+1] =
{
  { 22050 ,30, 15,
    sfb_24_480,
    sfb_24_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.06, 0.06,
      0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.20, 0.20, 0.20,
      0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25,
      0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 24000 ,30, 15,
    sfb_24_480,
    sfb_24_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.06, 0.06,
      0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.20, 0.20, 0.20,
      0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25,
      0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 32000, 37, 14,
    sfb_32_480,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05,
      0.05, 0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 44100, 35, 14,
    sfb_48_480,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05,
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 1.00
    },
    { 0 },
    { 0 }
  },

  { 48000, 35, 14,
    sfb_48_480,
    sfb_48_120,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { -1 , 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 }
  }
};

static SR_INFO sr_info_512[MAX_SAMPLING_RATES+1] =
{
  { 22050, 31, 15,
    sfb_24_512,
    sfb_24_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04,
      0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.15, 0.15, 0.15, 0.20, 0.20,
      0.20, 0.25, 0.30, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 0.90, 0.90
    },
    { 0 },
    { 0 }
  },
  { 24000, 31, 15,
    sfb_24_512,
    sfb_24_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04,
      0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.15, 0.15, 0.15, 0.20, 0.20,
      0.20, 0.25, 0.30, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 0.90, 0.90
    },
    { 0 },
    { 0 }
  },
  { 32000 ,37, 14,
    sfb_32_512,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05,
      0.05, 0.06, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40,
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { 44100, 36, 14,
    sfb_48_512,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05,
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30,
      0.40, 1.00
    },
    { 0 },
    { 0 }
  },

  { 48000, 36, 14,
    sfb_48_512,
    sfb_48_128,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.40, 1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 0.40, 1.00
    },
    { 0 },
    { 0 }
  },
  { -1 , 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 }
  }
};

static SR_INFO sr_info_NOT_aac[MAX_SAMPLING_RATES+1] =
{
  { 8000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
  },
  { 11025, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 12000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 16000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 22050, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 24000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 32000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
 },
  { 44100, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
   },
  { 48000, 37, 13,
    NULL,
    NULL,
    { /* fixed_ratio_long[NSFB_LONG] */
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.05, 0.05,
      0.05, 0.06, 0.06, 0.06, 0.09, 0.09, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.20, 0.20, 0.20, 0.20, 0.20, 0.25, 0.30, 0.30, 0.30, 0.40, 
      1.00
    },
    { /* fixed_ratio_short[NSFB_SHORT] */
      0.04, 0.04, 0.04, 0.05, 0.07, 0.10, 0.12, 0.15, 0.15, 0.20, 0.25, 0.30, 
      0.40, 1.00
    },
    { 0 },
    { 0 } 
  },
  { 96000, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
  },
  { -1, 0, 0,
    0,
    0,
    { 0 },
    { 0 },
    { 0 },
    { 0 } 
  }
};



void EncTf_psycho_acoustic_init( void )
{
}

int EncTf_psycho_acoustic ( double          sampling_rate, 
                            int             no_of_chan,         /* no of audio channels */
                            int             frameLength, 
                            int             windowLength,
                            CH_PSYCH_OUTPUT p_chpo_long[],
                            CH_PSYCH_OUTPUT p_chpo_short[][MAX_SHORT_WINDOWS] )
{ 
  int             ch,i,j,k;
  SR_INFO*        p_sri = NULL;
  long sampling_rate_mapped = 0;

  switch (frameLength) {
  case 480:
    p_sri = &sr_info_480[0];
    break;
  case 512:
    p_sri = &sr_info_512[0];
    break;
  case 768:
    p_sri = &sr_info_768[0];
    break;
  case 960:
    p_sri = &sr_info_960[0];
    break;
  case 1024:
    p_sri = &sr_info_aac[0];
    break;
  default:
    CommonWarning("\n illegal frameLength in EncTf_psycho_acoustic %d",frameLength);
    return -1;
  }   
 

  /* map samplingrates */
  if(((long)sampling_rate >= 0) && ((long)sampling_rate < 9391)){
    sampling_rate_mapped = 8000;
  } else if(((long)sampling_rate >=  9391) && ((long)sampling_rate < 11502)){
    sampling_rate_mapped = 11025;
  } else if(((long)sampling_rate >= 11502) && ((long)sampling_rate < 13856)){
    sampling_rate_mapped = 12000;
  } else if(((long)sampling_rate >= 13856) && ((long)sampling_rate < 18783)){
    sampling_rate_mapped = 16000;
  } else if (((long)sampling_rate >= 18783) && ((long)sampling_rate < 23004)){
    sampling_rate_mapped = 22050;
  } else if (((long)sampling_rate >= 23004) && ((long)sampling_rate < 27713)){
    sampling_rate_mapped = 24000;
  } else if (((long)sampling_rate >= 27713) && ((long)sampling_rate < 37566)){
    sampling_rate_mapped = 32000;
  } else if (((long)sampling_rate >= 37566) && ((long)sampling_rate < 46009)){
    sampling_rate_mapped = 44100;
  } else if (((long)sampling_rate >= 46009) && ((long)sampling_rate < 55426)){
    sampling_rate_mapped = 48000;
  } else if (((long)sampling_rate >= 55426) && ((long)sampling_rate < 75132)){
    sampling_rate_mapped = 64000;
  } else if (((long)sampling_rate >= 75132) && ((long)sampling_rate < 92017)){
    sampling_rate_mapped = 88200;
  } else if ((long)sampling_rate >= 92017){
    sampling_rate_mapped = 96000;
  } else {
    CommonExit(-1, "Invalid sampling frequency.");
  }


  /* find correct sampling rate depending parameters */
  while( p_sri->sampling_rate != sampling_rate_mapped ) {
    if( p_sri->sampling_rate == -1 ) {
      CommonWarning("Encode: unknown sampling rate in psychoacoustic module %f", sampling_rate );
      return -1;
    }
    p_sri++;
  }

  j=0;
  for (i=0;i<p_sri->num_cb_long; i++) {
    k = p_sri->cb_offset_long[i];
    p_sri->cb_width_long[i] = k - j;
    j = k;
  }
  j=0;
  for (i=0;i<p_sri->num_cb_short; i++) {
    k = p_sri->cb_offset_short[i];
    p_sri->cb_width_short[i] = k - j;
    j = k;
  }


  for( ch=0; ch<no_of_chan; ch++ ) {
    int i;
    p_chpo_long[ch].p_ratio   = p_sri->fixed_ratio_long;
    p_chpo_long[ch].cb_width  = p_sri->cb_width_long;
    p_chpo_long[ch].no_of_cb  = p_sri->num_cb_long;
    for( i=0; i<MAX_SHORT_WINDOWS; i++ ) {
      p_chpo_short[ch][i].p_ratio  = p_sri->fixed_ratio_short;
      p_chpo_short[ch][i].cb_width = p_sri->cb_width_short;
      p_chpo_short[ch][i].no_of_cb = p_sri->num_cb_short;
    }
  }
  return 0;
}


int EncTf_psycho_acoustic_long_sfb_offset ( double          sampling_rate, 
                            int             frameLength, 
                            int             windowLength,
                            int            *swb_offset
) {
int i,k;
int nr_of_sfb = 0;
int sfb_width_table[NSFB_LONG+1];
CH_PSYCH_OUTPUT chpo_long[1];
CH_PSYCH_OUTPUT chpo_short[1][MAX_SHORT_WINDOWS];

  EncTf_psycho_acoustic(sampling_rate, 1, frameLength, windowLength, chpo_long, chpo_short);
  
  memcpy( (char*)sfb_width_table, (char*)chpo_long[0].cb_width, (NSFB_LONG+1)*sizeof(int) );
  nr_of_sfb = chpo_long[0].no_of_cb;
  /* p_ratio[i_ch]   = chpo_long[i_ch].p_ratio; */

  swb_offset[0] = 0;
  k=0;
  for(i = 0; i < nr_of_sfb; i++ ) {
    swb_offset[i] = k;
    k += sfb_width_table[i];
  }
  swb_offset[i] = k;
  
  return nr_of_sfb;
}

