/****************************************************************************

SC 29 Software Copyright Licencing Disclaimer:

This software module was originally developed by
  Coding Technologies

and edited by
  -

in the course of development of the ISO/IEC 13818-7 and ISO/IEC 14496-3 
standards for reference purposes and its performance may not have been 
optimized. This software module is an implementation of one or more tools as 
specified by the ISO/IEC 13818-7 and ISO/IEC 14496-3 standards.
ISO/IEC gives users free license to this software module or modifications 
thereof for use in products claiming conformance to audiovisual and 
image-coding related ITU Recommendations and/or ISO/IEC International 
Standards. ISO/IEC gives users the same free license to this software module or 
modifications thereof for research purposes and further ISO/IEC standardisation.
Those intending to use this software module in products are advised that its 
use may infringe existing patents. ISO/IEC have no liability for use of this 
software module or modifications thereof. Copyright is not released for 
products that do not conform to audiovisual and image-coding related ITU 
Recommendations and/or ISO/IEC International Standards.
The original developer retains full right to modify and use the code for its 
own purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for products that do not conform to audiovisual and 
image-coding related ITU Recommendations and/or ISO/IEC International Standards.
This copyright notice must be included in all copies or derivative works.
Copyright (c) ISO/IEC 2002.

 $Id: ct_polyphase_enc.c,v 1.1.1.1 2009-05-29 14:10:18 mul Exp $

*******************************************************************************/
/*!
  \file
  \brief  Polyphase Filterbank $Revision: 1.1.1.1 $
*/

/* 20060107 */

#include <math.h>
#include "ct_polyphase_enc.h"

#ifndef PI
#define PI 3.14159265358979323846
#endif

const double sbrEncoderFilterbankCoefficients[640] = {
                  0,  -0.00055252865047,  -0.00056176925738,  -0.00049475180896,
  -0.00048752279712,  -0.00048937912498,  -0.00050407143497,  -0.00052265642972,
  -0.00054665656337,  -0.00056778025613,  -0.00058709304852,  -0.00061327473938,
  -0.00063124935319,  -0.00065403333621,  -0.00067776907764,  -0.00069416146273,
  -0.00071577364744,  -0.00072550431222,  -0.00074409418541,  -0.00074905980532,
  -0.00076813719270,  -0.00077248485949,  -0.00078343322877,  -0.00077798694927,
  -0.00078036647100,  -0.00078014496257,  -0.00077579773310,  -0.00076307935757,
  -0.00075300014201,  -0.00073193571525,  -0.00072153919876,  -0.00069179375372,
  -0.00066504150893,  -0.00063415949025,  -0.00059461189330,  -0.00055645763906,
  -0.00051455722108,  -0.00046063254803,  -0.00040951214522,  -0.00035011758756,
  -0.00028969811748,  -0.00020983373440,  -0.00014463809349,  -0.00006173344072,
   0.00001349497418,   0.00010943831274,   0.00020430170688,   0.00029495311041,
   0.00040265402160,   0.00051073884952,   0.00062393761391,   0.00074580258865,
   0.00086084433262,   0.00098859883015,   0.00112501551307,   0.00125778846475,
   0.00139024948272,   0.00154432198471,   0.00168680832531,   0.00183482654224,
   0.00198411407369,   0.00214615835557,   0.00230172547746,   0.00246256169126,
   0.00262017586902,   0.00278704643465,   0.00294694477165,   0.00311254206525,
   0.00327396134847,   0.00344188741828,   0.00360082681231,   0.00376039229104,
   0.00392074323703,   0.00408197531935,   0.00422642692270,   0.00437307196781,
   0.00452098527825,   0.00466064606118,   0.00479325608498,   0.00491376035745,
   0.00503930226013,   0.00514073539032,   0.00524611661324,   0.00534716811982,
   0.00541967759307,   0.00548760401507,   0.00554757145088,   0.00559380230045,
   0.00562206432097,   0.00564551969164,   0.00563891995151,   0.00562661141932,
   0.00559171286630,   0.00554043639400,   0.00547537830770,   0.00538389758970,
   0.00527157587272,   0.00513822754514,   0.00498396877629,   0.00481094690600,
   0.00460395301471,   0.00438018617447,   0.00412516423270,   0.00384564081246,
   0.00354012465507,   0.00320918858098,   0.00284467578623,   0.00245085400321,
   0.00202741761850,   0.00157846825768,   0.00109023290512,   0.00058322642480,
   0.00002760451905,  -0.00054642808664,  -0.00115681355227,  -0.00180394725893,
  -0.00248267236449,  -0.00319337783900,  -0.00394011240522,  -0.00472225962400,
  -0.00553372111088,  -0.00637922932685,  -0.00726158168517,  -0.00817982333726,
  -0.00913253296085,  -0.01011502154986,  -0.01113155480321,  -0.01218499959508,
   0.01327182200351,   0.01439046660792,   0.01554055533423,   0.01673247129989,
   0.01794333813443,   0.01918724313698,   0.02045317933555,   0.02174675502535,
   0.02306801692862,   0.02441609920285,   0.02578758475467,   0.02718594296329,
   0.02860721736385,   0.03005026574279,   0.03150176087389,   0.03297540810337,
   0.03446209487686,   0.03596975605542,   0.03748128504252,   0.03900536794745,
   0.04053491705584,   0.04206490946367,   0.04360975421304,   0.04514884056413,
   0.04668430272642,   0.04821657200672,   0.04973857556014,   0.05125561555216,
   0.05276307465207,   0.05424527683589,   0.05571736482138,   0.05716164501299,
   0.05859156836260,   0.05998374801761,   0.06134551717207,   0.06268578081172,
   0.06397158980681,   0.06522471064380,   0.06643675122104,   0.06760759851228,
   0.06870438283512,   0.06976302447127,   0.07076287107266,   0.07170026731102,
   0.07256825833083,   0.07336202550803,   0.07410036424342,   0.07474525581194,
   0.07531373362019,   0.07580083586584,   0.07619924793396,   0.07649921704119,
   0.07670934904245,   0.07681739756964,   0.07682300113923,   0.07672049241746,
   0.07650507183194,   0.07617483218536,   0.07573057565061,   0.07515762552870,
   0.07446643947564,   0.07364060057620,   0.07267746427299,   0.07158263647903,
   0.07035330735093,   0.06896640131951,   0.06745250215166,   0.06576906686508,
   0.06394448059633,   0.06196027790387,   0.05981665708090,   0.05751526919867,
   0.05504600343009,   0.05240938217366,   0.04959786763445,   0.04663033051701,
   0.04347687821958,   0.04014582784127,   0.03664181168133,   0.03295839306691,
   0.02908240060125,   0.02503075618909,   0.02079970728622,   0.01637012582228,
   0.01176238327857,   0.00696368621617,   0.00197656014503,  -0.00320868968304,
  -0.00857117491366,  -0.01412888273558,  -0.01988341292573,  -0.02582272888064,
  -0.03195312745332,  -0.03827765720822,  -0.04478068215856,  -0.05148041767934,
  -0.05837053268336,  -0.06544098531359,  -0.07269433008129,  -0.08013729344279,
  -0.08775475365593,  -0.09555333528914,  -0.10353295311463,  -0.11168269317730,
  -0.12000779846800,  -0.12850028503878,  -0.13715517611934,  -0.14597664911870,
  -0.15496070710605,  -0.16409588556669,  -0.17338081721706,  -0.18281725485142,
  -0.19239667457267,  -0.20212501768103,  -0.21197358538056,  -0.22196526964149,
  -0.23206908706791,  -0.24230168845974,  -0.25264803095722,  -0.26310532994603,
  -0.27366340405625,  -0.28432141891085,  -0.29507167170646,  -0.30590985751916,
  -0.31682789136456,  -0.32781137272105,  -0.33887226938665,  -0.34999141229310,
   0.36115899031355,   0.37237955463061,   0.38363500139043,   0.39492117615675,
   0.40623176767625,   0.41756968968409,   0.42891199207373,   0.44025537543665,
   0.45159965356824,   0.46293080852757,   0.47424532146115,   0.48552530911099,
   0.49677082545707,   0.50798175000434,   0.51912349702391,   0.53022408956855,
   0.54125534487322,   0.55220512585061,   0.56307891401370,   0.57385241316923,
   0.58454032354679,   0.59511230862496,   0.60557835389180,   0.61591099320291,
   0.62612426956055,   0.63619801077286,   0.64612696959461,   0.65590163024671,
   0.66551398801627,   0.67496631901712,   0.68423532934598,   0.69332823767032,
   0.70223887193539,   0.71094104263095,   0.71944626349561,   0.72774489002994,
   0.73582117582769,   0.74368278636488,   0.75131374561237,   0.75870807608242,
   0.76586748650939,   0.77277808813327,   0.77942875190216,   0.78583531203920,
   0.79197358416424,   0.79784664137700,   0.80344857518505,   0.80876950044491,
   0.81381912706217,   0.81857760046468,   0.82304198905409,   0.82722753473360,
   0.83110384571520,   0.83469373618402,   0.83797173378865,   0.84095413924722,
   0.84362382812005,   0.84598184698206,   0.84803157770763,   0.84978051984268,
   0.85119715249343,   0.85230470352147,   0.85310209497017,   0.85357205739107,
   0.85373856005937,   0.85357205739107,   0.85310209497017,   0.85230470352147,
   0.85119715249343,   0.84978051984268,   0.84803157770763,   0.84598184698206,
   0.84362382812005,   0.84095413924722,   0.83797173378865,   0.83469373618402,
   0.83110384571520,   0.82722753473360,   0.82304198905409,   0.81857760046468,
   0.81381912706217,   0.80876950044491,   0.80344857518505,   0.79784664137700,
   0.79197358416424,   0.78583531203920,   0.77942875190216,   0.77277808813327,
   0.76586748650939,   0.75870807608242,   0.75131374561237,   0.74368278636488,
   0.73582117582769,   0.72774489002994,   0.71944626349561,   0.71094104263095,
   0.70223887193539,   0.69332823767032,   0.68423532934598,   0.67496631901712,
   0.66551398801627,   0.65590163024671,   0.64612696959461,   0.63619801077286,
   0.62612426956055,   0.61591099320291,   0.60557835389180,   0.59511230862496,
   0.58454032354679,   0.57385241316923,   0.56307891401370,   0.55220512585061,
   0.54125534487322,   0.53022408956855,   0.51912349702391,   0.50798175000434,
   0.49677082545707,   0.48552530911099,   0.47424532146115,   0.46293080852757,
   0.45159965356824,   0.44025537543665,   0.42891199207373,   0.41756968968409,
   0.40623176767625,   0.39492117615675,   0.38363500139043,   0.37237955463061,
  -0.36115899031355,  -0.34999141229310,  -0.33887226938665,  -0.32781137272105,
  -0.31682789136456,  -0.30590985751916,  -0.29507167170646,  -0.28432141891085,
  -0.27366340405625,  -0.26310532994603,  -0.25264803095722,  -0.24230168845974,
  -0.23206908706791,  -0.22196526964149,  -0.21197358538056,  -0.20212501768103,
  -0.19239667457267,  -0.18281725485142,  -0.17338081721706,  -0.16409588556669,
  -0.15496070710605,  -0.14597664911870,  -0.13715517611934,  -0.12850028503878,
  -0.12000779846800,  -0.11168269317730,  -0.10353295311463,  -0.09555333528914,
  -0.08775475365593,  -0.08013729344279,  -0.07269433008129,  -0.06544098531359,
  -0.05837053268336,  -0.05148041767934,  -0.04478068215856,  -0.03827765720822,
  -0.03195312745332,  -0.02582272888064,  -0.01988341292573,  -0.01412888273558,
  -0.00857117491366,  -0.00320868968304,   0.00197656014503,   0.00696368621617,
   0.01176238327857,   0.01637012582228,   0.02079970728622,   0.02503075618909,
   0.02908240060125,   0.03295839306691,   0.03664181168133,   0.04014582784127,
   0.04347687821958,   0.04663033051701,   0.04959786763445,   0.05240938217366,
   0.05504600343009,   0.05751526919867,   0.05981665708090,   0.06196027790387,
   0.06394448059633,   0.06576906686508,   0.06745250215166,   0.06896640131951,
   0.07035330735093,   0.07158263647903,   0.07267746427299,   0.07364060057620,
   0.07446643947564,   0.07515762552870,   0.07573057565061,   0.07617483218536,
   0.07650507183194,   0.07672049241746,   0.07682300113923,   0.07681739756964,
   0.07670934904245,   0.07649921704119,   0.07619924793396,   0.07580083586584,
   0.07531373362019,   0.07474525581194,   0.07410036424342,   0.07336202550803,
   0.07256825833083,   0.07170026731102,   0.07076287107266,   0.06976302447127,
   0.06870438283512,   0.06760759851228,   0.06643675122104,   0.06522471064380,
   0.06397158980681,   0.06268578081172,   0.06134551717207,   0.05998374801761,
   0.05859156836260,   0.05716164501299,   0.05571736482138,   0.05424527683589,
   0.05276307465207,   0.05125561555216,   0.04973857556014,   0.04821657200672,
   0.04668430272642,   0.04514884056413,   0.04360975421304,   0.04206490946367,
   0.04053491705584,   0.03900536794745,   0.03748128504252,   0.03596975605542,
   0.03446209487686,   0.03297540810337,   0.03150176087389,   0.03005026574279,
   0.02860721736385,   0.02718594296329,   0.02578758475467,   0.02441609920285,
   0.02306801692862,   0.02174675502535,   0.02045317933555,   0.01918724313698,
   0.01794333813443,   0.01673247129989,   0.01554055533423,   0.01439046660792,
  -0.01327182200351,  -0.01218499959508,  -0.01113155480321,  -0.01011502154986,
  -0.00913253296085,  -0.00817982333726,  -0.00726158168517,  -0.00637922932685,
  -0.00553372111088,  -0.00472225962400,  -0.00394011240522,  -0.00319337783900,
  -0.00248267236449,  -0.00180394725893,  -0.00115681355227,  -0.00054642808664,
   0.00002760451905,   0.00058322642480,   0.00109023290512,   0.00157846825768,
   0.00202741761850,   0.00245085400321,   0.00284467578623,   0.00320918858098,
   0.00354012465507,   0.00384564081246,   0.00412516423270,   0.00438018617447,
   0.00460395301471,   0.00481094690600,   0.00498396877629,   0.00513822754514,
   0.00527157587272,   0.00538389758970,   0.00547537830770,   0.00554043639400,
   0.00559171286630,   0.00562661141932,   0.00563891995151,   0.00564551969164,
   0.00562206432097,   0.00559380230045,   0.00554757145088,   0.00548760401507,
   0.00541967759307,   0.00534716811982,   0.00524611661324,   0.00514073539032,
   0.00503930226013,   0.00491376035745,   0.00479325608498,   0.00466064606118,
   0.00452098527825,   0.00437307196781,   0.00422642692270,   0.00408197531935,
   0.00392074323703,   0.00376039229104,   0.00360082681231,   0.00344188741828,
   0.00327396134847,   0.00311254206525,   0.00294694477165,   0.00278704643465,
   0.00262017586902,   0.00246256169126,   0.00230172547746,   0.00214615835557,
   0.00198411407369,   0.00183482654224,   0.00168680832531,   0.00154432198471,
   0.00139024948272,   0.00125778846475,   0.00112501551307,   0.00098859883015,
   0.00086084433262,   0.00074580258865,   0.00062393761391,   0.00051073884952,
   0.00040265402160,   0.00029495311041,   0.00020430170688,   0.00010943831274,
   0.00001349497418,  -0.00006173344072,  -0.00014463809349,  -0.00020983373440,
  -0.00028969811748,  -0.00035011758756,  -0.00040951214522,  -0.00046063254803,
  -0.00051455722108,  -0.00055645763906,  -0.00059461189330,  -0.00063415949025,
  -0.00066504150893,  -0.00069179375372,  -0.00072153919876,  -0.00073193571525,
  -0.00075300014201,  -0.00076307935757,  -0.00077579773310,  -0.00078014496257,
  -0.00078036647100,  -0.00077798694927,  -0.00078343322877,  -0.00077248485949,
  -0.00076813719270,  -0.00074905980532,  -0.00074409418541,  -0.00072550431222,
  -0.00071577364744,  -0.00069416146273,  -0.00067776907764,  -0.00065403333621,
  -0.00063124935319,  -0.00061327473938,  -0.00058709304852,  -0.00056778025613,
  -0.00054665656337,  -0.00052265642972,  -0.00050407143497,  -0.00048937912498,
  -0.00048752279712,  -0.00049475180896,  -0.00056176925738,  -0.00055252865047
};



void
InitEncAnaFilterbank(struct SBR_ENCODER_ANA_FILTERBANK * filterbank)
{
  int i, k, l;
  
  for ( i=0; i<640; i++ ) {
    filterbank->X[i] = 0.0f;
  }

  for ( k=0; k<64; k++ ) {
    for ( l=0; l<128; l++ ) {
      filterbank->Mr[k][l] = cos((PI/128)*(k+0.5)*(2*l+1));
      filterbank->Mi[k][l] = sin((PI/128)*(k+0.5)*(2*l+1));
    }
  }

}

void
CalculateEncAnaFilterbank( struct SBR_ENCODER_ANA_FILTERBANK * filterbank,
                           float * timeSig,
                           float * Sr,
                           float * Si)
{
  int i,j,k,l;
  float   Z[640];
  float   Y[128];
  const double* C = sbrEncoderFilterbankCoefficients;


  /* shift input buffer */
  for ( i=639; i>=64; i-- ) {
    filterbank->X[i] = filterbank->X[i-64];
  }

  /* add new samples to input buffer in reverse order */
  for ( i=64; i>=0; i-- ) {
    filterbank->X[i] = timeSig[639-i];
  }

  /* window signal */
  for ( i=0; i<640; i++ ) {
    Z[i] = (float) (filterbank->X[i] * C[i]);
  }

  /* create array Y */
  for ( i=0; i<128; i++ ) {
    Y[i] = 0.0f;
    for ( j=0; j<5; j++ ) {
      Y[i] = Y[i] + Z[i + j * 128];
    }
  }

  /* Calculate 64 subband samples by matrixing */
  for ( k=0; k<64; k++ ) {
    Sr[k] = 0.0f;
    Si[k] = 0.0f;
    for ( l=0; l<128; l++ ) {
      Sr[k] = Sr[k] + (float) (Y[l] * filterbank->Mr[k][l]);
      Si[k] = Si[k] + (float) (Y[l] * filterbank->Mi[k][l]);
    }
  }
}

