/************************* MPEG-2 AAC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS in the course of 
development of the MPEG-2 AAC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 AAC/MPEG-4 Audio tools as specified by the MPEG-2 AAC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 AAC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 AAC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 AAC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 AAC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

#ifndef TRANSFORM_H
#define TRANSFORM_H 
#ifndef HAS_Float
typedef	double	Float;
#define HAS_Float
#endif
#define TRANS_DATATYPE	double /* :-) beginner like! */

void Transform(Float* data, int n, int param);
void ITransform(Float* date, int n, int param);

void CompFFT(TRANS_DATATYPE *data, int nn, int isign);
void FFT(TRANS_DATATYPE *data, int nn, int isign);

void MDCT(double* data, int N, int b, int isign);

#ifdef AAC_ELD
void LDFB(double* data, int N, int b, int isign, int modoff);
#endif

#endif
