/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by

Y.B. Thomas Kim and S.H. Park (Samsung AIT)

and edited by

Y.B. Thomas Kim (Samsung AIT) on 1997-11-06
Markus Werner       (SEED / Software Development Karlsruhe) 

in the course of development of the MPEG-2 AAC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 AAC/MPEG-4 Audio tools
as specified by the MPEG-2 AAC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 AAC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 AAC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
AAC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 AAC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 2000.

$Id: sam_model.h,v 1.1.1.1 2009-05-29 14:10:17 mul Exp $
Decoder frame work
**********************************************************************/

#ifndef	_sam_model_h_
#define	_sam_model_h_

/* THE FIXED SOURCE MODEL */

#define No_of_symbols2 2		/* Number of samples */
#define No_of_symbols32 32		/* Number of samples */
#define No_of_symbols64 64		/* Number of samples */

#define N_REGION2   1016 
#define N_SCFREGION    8 
#define N_CSIREGION    8 


#define Max_frequency 16383		/* Maximum allowed frequency count */
					/* 2^14 - 1 */

static int AModelScf[N_SCFREGION][No_of_symbols64] = {
{
  	 1,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  1874,   973,   333,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  4399,  3559,  2699,  1985,  1146,   570,   212,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  8039,  7263,  6360,  5461,  4629,  3764,  2780,  1858,
  1032,   486,   223,    82,    50,    35,    12,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  9487,  8888,  8275,  7659,  6917,  6253,  5599,  4825,
  3959,  3073,  2099,  1293,   581,   140,    51,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  2216,  1870,  1593,  1416,  1164,   975,   814,   626,
   444,   318,   228,   151,   105,    67,    47,    41,
    32,    27,    24,    21,    18,    15,    13,    12,
    10,     9,     7,     6,     4,     3,     1,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
  3114,  2463,  2057,  1772,  1539,  1341,  1169,  1038,
   916,   778,   677,   601,   514,   444,   368,   307,
   258,   201,   151,   115,    79,    55,    34,    22,
    15,    11,     9,     7,     5,     3,     1,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 15198, 14992, 14803, 14460, 14082, 13670, 13223, 12828,
 12176, 11506, 10750,  9978,  9188,  8415,  7693,  6852,
  6148,  5530,  4894,  4327,  3675,  3228,  2936,  2593,
  2301,  1975,  1717,  1580,  1373,  1270,  1236,  1099,
   910,   738,   669,   566,   549,   498,   463,   429,
   412,   377,   360,   343,   326,   309,   291,   274,
   257,   240,   223,   206,   188,   171,   154,   137,
   120,   103,    85,    68,    51,    34,    17,     0,
},
};


static int AModelCBand[N_CSIREGION][No_of_symbols32] = {
{
 16118, 15193,  6930,  4771,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 15697, 13230,  7423,  4023,  2020,   555,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 14919, 10988,  7685,  4918,  3709,  2144,  1504,  1098,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 14014, 10158,  8436,  5961,  5333,  3398,  2771,  2184,
  1305,   523,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 14723, 11895, 11011,  7912,  7673,  4871,  4580,  2893,
  2380,  1175,  1093,    64,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 12399,  9374,  8022,  6211,  5658,  4141,  3948,  3201,
  2802,  1960,  1818,  1108,  1043,    22,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 12719,  8193,  5677,  4734,  3845,  3124,  2959,  2657,
  2389,  2085,  2013,  1705,  1672,  1371,  1355,   759,
   408,   119,    16,    12,     8,     4,    0,      0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
{
 16376, 16368, 16360, 16352, 16343, 16177, 15575, 15305,
 12404, 11215,  8987,  5083,  3409,  1539,  1100,   128,
    48,    40,    32,    24,    16,     8,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
},
};

static int AModelSpectrum[N_REGION2] = {
 14592, 14848, 12032, 15104, 12032, 14080, 11264, 15104,
 12288, 13824, 11520, 14592, 12032, 14080, 11264, 10240,
 10240,  9472, 10496,  9728,  9984,  8960, 10752,  9984,
 10240,  9216, 10240,  9472,  9728,  8704, 15616, 15616,
 13056, 15616, 13056, 15104, 13056, 15616, 12800, 15104,
 12544, 15872, 14080, 15360, 13056, 14080, 14848, 10240,
 15104,  9728, 11264,  9216, 14848,  9472, 11008,  9216,
 12544,  8960, 10496,  8960, 12288, 11264,  7424,  8704,
  6656,  7168,  5632,  9984,  8704,  6656,  7424,  6400,
  7168,  7680, 11264,  9216,  6400,  7680,  7936,  7168,
 11008,  9216, 10496,  9984,  9216,  4864,  6656,  8192,
  6144,  8960,  9472,  7936, 11264,  8960, 13824, 10240,
 12544,  9472,  5120,  4608,  6144,  5120,  8448,  8704,
  4096,  7680, 12288,  9728,  4608,  8704, 12544, 14592,
 14848, 11776, 14848, 12032, 13312, 10752, 14848, 12288,
 13568, 11264, 13824, 11008, 12544,  9472,  7680,  7424,
  7168,  7424,  7168,  7424,  6912,  7424,  7680,  7680,
  6656,  7680,  7168,  7424,  6912,  6656,  6656,  6144,
  6144,  6144,  5888,  5888,  6144,  6656,  5888,  5888,
  6400,  6144,  5632,  5888,  5632,  5376,  5888,  6144,
  5632,  7168,  5888,  6400,  5888,  5376,  7168,  5376,
  5632,  3840,  6144,  5120,  5888,  6656,  6656,  7680,
  6144,  7168,  6912,  5376,  4864,  5376,  5120,  5632,
  5376,  5888,  5632,  6912,  6144,  5120,  5120, 13824,
 15616, 15616, 12800, 15616, 13056, 15616, 13824, 15616,
 13568, 15360, 13568, 16128, 15104, 16128, 15616, 15360,
 15616, 11008, 15616, 10496, 13568, 11264, 15616, 11008,
 13312, 11008, 14336, 11008, 14080, 10752, 14592, 13312,
  9216, 10752,  7168,  7936,  5632, 13568,  9472,  6656,
 10752,  8704, 11008, 10752, 13568,  9728,  6656,  9728,
  9472,  9984, 13568, 11520, 14336, 12800, 11776,  6144,
  5632, 10496,  9472, 12544, 11264,  8960, 13824, 12288,
 15360, 13056, 15104, 13312,  5888,  6656,  7168,  6400,
 10496, 10752,  9216,  9984, 15360, 13824,  7424, 12544,
 13312, 14336,  9984, 14592,  9984, 12032,  8704, 14336,
  9472, 11520,  8192, 13056,  8192, 10496,  7680, 11008,
  8960,  6656,  6656,  6912,  6144,  5888,  7680,  7168,
  6912,  7168,  6912,  6656,  6144,  7424,  6912,  6144,
  6400,  6912,  6656,  7424,  7680,  7936,  6912,  7680,
  4608,  5120,  6656,  4864,  7168,  6912,  6400,  8192,
  7680, 12288, 10496, 11520,  9472,  4864,  5888,  5120,
  4864,  7680,  7936,  4352,  6400,  8448,  7680,  5376,
  6656, 12544, 10752, 11008, 10240, 14336, 14848, 11520,
 14848, 11520, 13824, 11520, 14848, 11520, 13824, 11008,
 14848, 10240, 13824,  9984, 11008, 12288,  9472, 12032,
  9728, 11520,  9216, 12288,  9472, 11008,  9216, 11520,
  9472, 10240,  9472, 10752, 10496,  8960,  8704,  7680,
  6912,  6400,  9728,  8960,  7936,  7424,  8704,  6912,
  6144,  8448,  8448,  7424,  7424,  7936,  7936, 10496,
  9728, 10752,  8448,  8960,  6144,  6656,  7424,  8192,
  7168,  6656,  7680, 10496, 10240, 12032,  8960, 12032,
  9728,  7424,  5888,  7424,  7168,  7680,  8448,  5888,
  8704,  8960,  8960,  5120,  6656,  6400,  6400,  6400,
  6912,  5888,  6912,  6656,  4096,  6400,  5632,  6144,
  7680,  6400,  6656,  5888,  6912,  5888,  5376,  5376,
  5376,  5888,  5120,  6400,  5888,  5632,  5632,  4608,
  4864,  4608,  5632,  5376,  5376,  4864,  5632,  5632,
  7168,  5120,  5888,  5632,  5120,  5120,  5120,  5376,
  5120,  4864,  4864,  5376,  6144,  5632,  7936,  6656,
  7680,  6144,  5888,  5632,  5632,  4864,  5120,  4864,
  4352,  5376,  5632,  5376,  4608,  4864, 12288, 11008,
 10240,  9984, 15616, 15616, 13568, 15872, 13568, 16128,
 15104, 15872, 12800, 16128, 14848, 16128, 15616, 16128,
 15104, 16128, 16128, 12800, 16128, 13568, 15872, 14080,
 16128, 11520, 15360, 12288, 16128, 14080, 15872, 13312,
 16128, 14592,  9728, 12032,  7680,  9216,  5376, 14080,
 12544,  6912,  9728,  8960, 14848, 14592, 15872, 11008,
  8704, 10240, 12032,  9472, 15872, 14080, 15872, 15616,
 14592,  6656, 13056,  9472, 10240, 15360, 14336, 11264,
 15616, 14336, 16128, 15104, 16128, 14848,  7680,  6912,
  6144,  6144, 15104, 14848,  4608, 12032, 16128, 15104,
  6912, 13568, 15360, 15872, 12288, 15872, 12544, 14848,
 12544, 15616, 11264, 14592, 11776, 15360, 11520, 15360,
 12544, 15616, 12544,  8448, 11264,  9728, 10240,  7424,
 11008, 10240, 10240,  9216,  8704,  8448,  8960, 11520,
  9472,  7936,  8448, 11008,  9984, 12800, 11520, 13312,
 10752, 13568,  6144,  6144,  7936,  7680, 11776, 10752,
  9216, 12288, 11008, 15872, 15616, 15616, 14848,  7680,
 11008,  9728,  6400, 13312, 13568,  7168,  9728, 13056,
 10752,  7168, 11008, 13568, 15104, 10496, 15104, 10752,
 12544,  9984, 15104,  9728, 12032,  9216, 13312,  8960,
 11520,  8192, 13056,  9984,  7168,  9216,  7168,  7168,
  6400,  9984, 10240,  6912,  7424,  8192,  6912,  6656,
  8960,  7424,  5888,  7680,  9216,  8448, 11008,  8448,
 10240,  8192,  8960,  6912,  5376,  6912,  5120,  6656,
  6656,  8192, 10752,  8704, 14080, 12032, 12800, 10752,
  5888,  5888,  5632,  6400,  9472,  8960,  5376,  6400,
  9472,  8704,  5120,  6912, 12032, 10240, 10496,  9216,
 11520,  9472,  8960,  9472,  9472,  9728,  9216, 15104,
 15360, 13312, 15360, 13312, 14848, 12288, 15360, 12800,
 14848, 12544, 15360, 12288, 14592, 12032, 13568, 14336,
 11264, 14592, 11264, 13312, 11008, 14336, 11776, 13312,
 11520, 13824, 10752, 13056, 10240, 12544, 12544,  9728,
 10496,  8192,  8960,  7936, 11520,  9728,  8192,  9728,
  8960,  9472,  8448, 11264,  9216,  7424,  9472,  9216,
  9216, 12288, 10240, 12288, 10496,  8704,  7680,  7168,
  9472,  7424,  8960,  8960,  9472, 13056, 11264, 14080,
 11008, 13312, 11264,  7680,  7168,  8448,  6912, 10496,
 10752,  7424,  9728, 12800, 10752,  8192,  9216, 10496,
 11776,  9728, 12032,  9728, 11520,  9728, 11776,  9472,
 11008,  9728, 12032,  8960, 10752,  8960, 10240, 10240,
  8448,  9216,  8192,  8192,  6912,  9216,  7936,  7168,
  8448,  8704,  7424,  7168,  7936,  7168,  6400,  7680,
  8448,  8448, 10496,  8704,  8960,  8448,  7168,  6656,
  6656,  8448,  8448,  7168,  7168,  7936,  9984,  9472,
 11520,  9984, 10752,  8960,  7168,  7424,  6656,  6656,
  6912,  7424,  6144,  8192,  8960,  7936,  6400,  7168,
  7168,  7680,  6912,  7680,  7168,  7680,  6400,  6656,
  7936,  7936,  6400,  8192,  6656,  7936,  5888,  6912,
  6656,  6400,  6144,  6400,  6144,  5632,  6400,  6656,
  6400,  5888,  6144,  5888,  6144,  5632,  5888,  5120,
  5632,  6144,  6656,  7168,  7168,  7168,  5888,  5888,
  5376,  5376,  5632,  5632,  5376,  5120,  5888,  6912,
  6656,  8960,  7168,  7424,  6656,  5632,  5632,  5376,
  5120,  6144,  5376,  4864,  5888,  6400,  5632,  5120,
  5120, 12800, 11008, 10496, 10240, 10240,  9472,  9472,
  9984,  9472,  9728,  9472, 15616, 15872, 13056, 15872,
 13568, 15872, 14080, 15872, 13312, 15872, 13568, 16128,
 15616, 16128, 15360, 11776, 10496, 10752,  9984, 11520,
  9472,  9216,  9472,  9216,  9472,  8960, 10240,  9472,
  8960,  8960,  8704,  8704,  8704,  8704,  8704,  8704,
  8704,  8448,  8192,  8704,  8448,  8192, 15104, 15360,
 13312, 15360, 12800, 14592, 11776, 15616, 13312, 14592,
 12032, 15360, 11520, 14080, 11520, 12544, 11008, 10752,
 10496,  9984,  9728,  9472,  9472,  9472,  8704,  8704,
  8704,  8960,  8960,  8960,  8704,  8960,  8704,  8960,
  8704,  8704,  8704,  8704,  8704,  8192,  8448,  8704,
};

static int small_step_offset_tbl[16][4][8] = {
/* sign_coded_vector = 0 */
{ {    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {    1,    2,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {    3,    4,    5,    6,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {    7,    8,    9,   10,   11,   12,   13,   14, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 1 */
{ {   15,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   16,   17,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   18,   19,   20,   21,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 2 */
{ {   22,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   23,   24,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   25,   25,   26,   26,   27,   27,   28,   28, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 3 */
{ {   29,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   30,   31,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 4 */
{ {   32,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   33,   33,   34,   34,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   35,   36,   35,   36,   37,   38,   37,   38, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 5 */
{ {   39,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   40,   40,   41,   41,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 6 */
{ {   42,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   43,   43,   43,   43,   44,   44,   44,   44, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 7 */
{ {   45,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 8 */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   46,   46,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   47,   48,   47,   48,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   49,   50,   51,   52,   49,   50,   51,   52, }, /* bit_position = 3 */
 },
/* sign_coded_vector = 9 */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   53,   53,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   54,   55,   54,   55,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = a */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   56,   56,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   57,   57,   58,   58,   57,   57,   58,   58, }, /* bit_position = 3 */
 },
/* sign_coded_vector = b */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   59,   59,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = c */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   60,   60,   60,   60,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   61,   62,   61,   62,   61,   62,   61,   62, }, /* bit_position = 3 */
 },
/* sign_coded_vector = d */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   63,   63,   63,   63,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
/* sign_coded_vector = e */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   64,   64,   64,   64,   64,   64,   64,   64, }, /* bit_position = 3 */
 },
/* sign_coded_vector = f */
{ {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 0 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 1 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 2 */
  {   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* bit_position = 3 */
 },
};

static int large_step_offset[10][8] = {
{   0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* Model No = 0 */
{  15,   -1,   -1,   -1,   -1,   -1,   -1,   -1, }, /* Model No = 1 */
{  30,   45,   -1,   -1,  110,   -1,   -1,   -1, }, /* Model No = 2 */
{ 111,  126,   -1,   -1,  191,   -1,   -1,   -1, }, /* Model No = 3 */
{ 192,  207,  272,   -1,  337,  338,   -1,   -1, }, /* Model No = 4 */
{ 341,  356,  421,   -1,  486,  487,   -1,   -1, }, /* Model No = 5 */
{ 490,  505,  570,  635,  700,  701,  704,   -1, }, /* Model No = 6 */
{ 711,  726,  791,  856,  921,  922,  925,   -1, }, /* Model No = 7 */
{ 932,  505,  570,  635,  947,  948,  951,  958, }, /* Model No = 8 */
{ 974,  726,  791,  856,  989,  990,  993, 1000, }, /* Model No = 9 */
};

static int * model_offset_tbl[32] = {
     NULL,
     large_step_offset[0],     large_step_offset[1],
     large_step_offset[2],     large_step_offset[3],
     large_step_offset[4],     large_step_offset[5],
     large_step_offset[6],     large_step_offset[7],
     large_step_offset[8],     large_step_offset[9],
     large_step_offset[8],     large_step_offset[9],
     large_step_offset[8],     large_step_offset[9],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
     large_step_offset[8],     large_step_offset[8],
	 NULL,
};

static int	AModelStereoInfo[4]={
	13926, 4096, 1638, 0
};

static int AModelMsUsed[2]={
	11469, 0
};

static int AModelNoiseFlag[2]={
	8192, 0
};
	 
static int  AModelNoiseMode[4]={
	12288, 8192, 4096, 0
};

static int  AModelNoiseNrg[512]={
	0
};

#endif /* #ifndef _sam_model_h */

