/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/* in the course of development of the                                       */
/* MPEG-2 AAC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 AAC/MPEG-4 Audio tools as specified by the MPEG-2 AAC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 AAC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 AAC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 AAC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 AAC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/


#include <stdio.h>
#include <string.h>

#include "allHandles.h"

#include "nok_ltp_common.h"      /* structs */
#include "tf_mainStruct.h"       /* structs */
#include "tns.h"                 /* structs */

#include "common_m4a.h"
#include "ntt_conf.h"





double tvqtab_20b19s48bs[] = {
0.1174, 0.2629, 0.4047, 0.5952, 0.7249, 0.8803, 1.0465, 1.1687, 1.3174, 1.4778, 1.6125, 1.7790, 1.8951, 2.0787, 2.2225, 2.3546, 
2.5002, 2.6572, 2.8355, 2.9783, 0.1828, 0.3386, 0.4116, 0.5621, 0.7210, 0.8888, 1.0088, 1.1501, 1.3288, 1.4473, 1.5727, 1.7789, 
1.8824, 2.0304, 2.1998, 2.3585, 2.4955, 2.6511, 2.8140, 2.9605, 0.1293, 0.3249, 0.4623, 0.6582, 0.7948, 0.9477, 1.1068, 1.2104, 
1.3098, 1.4293, 1.5690, 1.7570, 1.8739, 2.0543, 2.2133, 2.3630, 2.5169, 2.6593, 2.8147, 2.9676, 0.1359, 0.3157, 0.4770, 0.6340, 
0.6863, 0.7970, 1.0202, 1.2062, 1.3237, 1.4243, 1.5710, 1.7880, 1.9209, 2.0588, 2.1726, 2.3476, 2.5309, 2.6718, 2.8079, 2.9564, 
0.1311, 0.2912, 0.4227, 0.6131, 0.7523, 0.9053, 1.0771, 1.2221, 1.3648, 1.5340, 1.6759, 1.8169, 1.9020, 2.0612, 2.2039, 2.3483, 
2.4994, 2.6446, 2.8030, 2.9602, 0.1264, 0.2699, 0.3763, 0.5810, 0.7562, 0.9114, 1.0854, 1.2163, 1.3730, 1.5429, 1.6488, 1.7651, 
1.8514, 2.0338, 2.1947, 2.3444, 2.4975, 2.6497, 2.8091, 2.9622, 0.1437, 0.2588, 0.3554, 0.5655, 0.7454, 0.9205, 1.0799, 1.1710, 
1.3025, 1.4460, 1.5693, 1.7406, 1.8593, 2.0314, 2.1916, 2.3495, 2.5033, 2.6480, 2.8094, 2.9634, 0.1114, 0.2943, 0.4312, 0.5984, 
0.7299, 0.8952, 1.0942, 1.2548, 1.3628, 1.4482, 1.5589, 1.7495, 1.8897, 2.0738, 2.2136, 2.3605, 2.5199, 2.6703, 2.8201, 2.9603, 
0.0948, 0.2009, 0.3228, 0.5200, 0.6759, 0.8336, 1.0034, 1.1690, 1.3346, 1.4869, 1.6169, 1.7833, 1.8962, 2.0733, 2.2408, 2.3867, 
2.5308, 2.6702, 2.8220, 2.9715, 0.1354, 0.2516, 0.3765, 0.5569, 0.6437, 0.7706, 0.9587, 1.1167, 1.2847, 1.4480, 1.5884, 1.7576, 
1.8759, 2.0557, 2.2131, 2.3606, 2.5117, 2.6561, 2.8135, 2.9681, 0.1457, 0.3447, 0.4823, 0.6299, 0.7071, 0.8266, 1.0111, 1.1590, 
1.3168, 1.4711, 1.6095, 1.7785, 1.8965, 2.0814, 2.2277, 2.3749, 2.5471, 2.6981, 2.8343, 2.9631, 0.1308, 0.2559, 0.3849, 0.5877, 
0.6716, 0.7929, 0.9911, 1.1467, 1.2875, 1.4331, 1.5804, 1.7507, 1.8768, 2.0533, 2.2073, 2.3571, 2.5075, 2.6526, 2.8114, 2.9668, 
0.1100, 0.2342, 0.3655, 0.5678, 0.7011, 0.8539, 1.0156, 1.1344, 1.2878, 1.4475, 1.5857, 1.7553, 1.8788, 2.0568, 2.2090, 2.3575, 
2.5091, 2.6533, 2.8127, 2.9664, 0.1276, 0.2569, 0.3779, 0.5755, 0.7111, 0.8433, 1.0120, 1.1497, 1.2934, 1.4561, 1.5821, 1.7393, 
1.8597, 2.0338, 2.1981, 2.3514, 2.5005, 2.6466, 2.8099, 2.9643, 0.1449, 0.2648, 0.3846, 0.5961, 0.7299, 0.8612, 1.0124, 1.1361, 
1.2760, 1.4033, 1.5325, 1.7194, 1.8567, 2.0380, 2.1982, 2.3487, 2.5037, 2.6505, 2.8093, 2.9663, 0.1191, 0.2724, 0.3804, 0.5620, 
0.7344, 0.8313, 1.0047, 1.1589, 1.2462, 1.4182, 1.5826, 1.7253, 1.8671, 2.0428, 2.1839, 2.3524, 2.4969, 2.6468, 2.8092, 2.9619, 
0.1605, 0.3428, 0.4476, 0.5915, 0.7067, 0.8606, 1.0336, 1.1538, 1.3018, 1.4734, 1.6169, 1.7796, 1.9074, 2.1093, 2.2537, 2.3646, 
2.5005, 2.6536, 2.8113, 2.9592, 0.1980, 0.3043, 0.3485, 0.5137, 0.6684, 0.8360, 1.0340, 1.1800, 1.3348, 1.4823, 1.6125, 1.7743, 
1.8685, 2.0274, 2.1877, 2.3437, 2.5005, 2.6494, 2.8088, 2.9660, 0.1522, 0.2816, 0.3968, 0.5617, 0.7004, 0.8729, 1.0133, 1.1174, 
1.2474, 1.4405, 1.6196, 1.7822, 1.8452, 2.0062, 2.1803, 2.3318, 2.4840, 2.6414, 2.8079, 2.9638, 0.0838, 0.2169, 0.3715, 0.6054, 
0.7642, 0.8653, 0.9821, 1.1144, 1.2896, 1.4547, 1.6024, 1.7732, 1.8876, 2.0665, 2.2032, 2.3498, 2.5070, 2.6526, 2.8113, 2.9673, 
0.1750, 0.3555, 0.4484, 0.5662, 0.6469, 0.7965, 1.0043, 1.1502, 1.3020, 1.4691, 1.6097, 1.7740, 1.8883, 2.0712, 2.2111, 2.3544, 
2.5066, 2.6538, 2.8130, 2.9669, 0.1553, 0.2518, 0.3129, 0.4940, 0.6681, 0.8400, 1.0047, 1.1351, 1.2916, 1.4545, 1.6012, 1.7689, 
1.8857, 2.0635, 2.2054, 2.3529, 2.5061, 2.6522, 2.8115, 2.9686, 0.1510, 0.2829, 0.3730, 0.5356, 0.6720, 0.8278, 1.0133, 1.1413, 
1.2788, 1.4408, 1.5875, 1.7644, 1.8764, 2.0482, 2.1994, 2.3476, 2.5006, 2.6488, 2.8092, 2.9658, 0.1242, 0.2415, 0.3427, 0.5296, 
0.6996, 0.8341, 0.9758, 1.1223, 1.2826, 1.4479, 1.5923, 1.7595, 1.8802, 2.0585, 2.1987, 2.3476, 2.5022, 2.6495, 2.8098, 2.9672, 
0.1370, 0.2369, 0.3319, 0.4979, 0.6176, 0.7802, 0.9803, 1.1446, 1.3162, 1.4684, 1.6044, 1.7707, 1.8874, 2.0630, 2.2188, 2.3651, 
2.5155, 2.6591, 2.8162, 2.9694, 0.1082, 0.2604, 0.3933, 0.5205, 0.6302, 0.8223, 1.0015, 1.1183, 1.2792, 1.4528, 1.5918, 1.7571, 
1.8807, 2.0589, 2.1995, 2.3482, 2.5029, 2.6504, 2.8099, 2.9670, 0.1655, 0.3502, 0.4789, 0.6442, 0.7489, 0.8833, 1.0259, 1.1458, 
1.2760, 1.4114, 1.5562, 1.7398, 1.8638, 2.0451, 2.2086, 2.3589, 2.5122, 2.6577, 2.8144, 2.9662, 0.1398, 0.2609, 0.3662, 0.5390, 
0.6898, 0.8598, 1.0172, 1.1053, 1.2365, 1.4228, 1.5771, 1.7457, 1.8741, 2.0544, 2.2075, 2.3562, 2.5101, 2.6536, 2.8122, 2.9669, 
0.0999, 0.2563, 0.3139, 0.4686, 0.6594, 0.8453, 1.0207, 1.1550, 1.2962, 1.4475, 1.5626, 1.7421, 1.8998, 2.0971, 2.2265, 2.3679, 
2.5087, 2.6455, 2.7782, 2.9457, 0.1138, 0.2129, 0.3229, 0.5337, 0.6762, 0.8288, 1.0247, 1.1512, 1.2682, 1.4174, 1.5696, 1.7451, 
1.8698, 2.0503, 2.2105, 2.3574, 2.5101, 2.6545, 2.8123, 2.9678, 0.1464, 0.2629, 0.3682, 0.5432, 0.6492, 0.8349, 1.0660, 1.1853, 
1.2746, 1.4003, 1.5387, 1.7244, 1.8658, 2.0481, 2.2015, 2.3521, 2.5052, 2.6515, 2.8106, 2.9670, 0.1281, 0.2253, 0.3181, 0.5448, 
0.7380, 0.8919, 1.0314, 1.1421, 1.2714, 1.4252, 1.5776, 1.7548, 1.8818, 2.0600, 2.2127, 2.3616, 2.5133, 2.6548, 2.8141, 2.9675, 
0.1671, 0.2982, 0.3779, 0.5418, 0.6953, 0.8556, 1.0118, 1.1498, 1.3094, 1.4649, 1.6072, 1.7726, 1.8847, 2.0659, 2.2223, 2.3653, 
2.5163, 2.6591, 2.8135, 2.9657, 0.1584, 0.3130, 0.4545, 0.6120, 0.7032, 0.8315, 1.0019, 1.0994, 1.2239, 1.4114, 1.5721, 1.7441, 
1.8778, 2.0618, 2.1931, 2.3407, 2.4986, 2.6482, 2.8099, 2.9659, 0.1343, 0.3271, 0.4606, 0.6457, 0.8085, 0.9335, 1.0208, 1.1017, 
1.2672, 1.4591, 1.6018, 1.7899, 1.9118, 2.0595, 2.2023, 2.3582, 2.5120, 2.6632, 2.8272, 2.9739, 0.1772, 0.3363, 0.4214, 0.5756, 
0.7270, 0.8934, 1.0098, 1.0963, 1.2554, 1.4493, 1.5827, 1.7606, 1.8920, 2.0618, 2.1981, 2.3514, 2.5063, 2.6505, 2.8097, 2.9658, 
0.1629, 0.3196, 0.4220, 0.5608, 0.6796, 0.8588, 1.0070, 1.1124, 1.3047, 1.4725, 1.5731, 1.7454, 1.8934, 2.0498, 2.1861, 2.3488, 
2.5041, 2.6429, 2.8095, 2.9683, 0.1960, 0.3317, 0.4323, 0.6092, 0.6915, 0.8002, 0.9693, 1.1223, 1.2892, 1.4404, 1.5735, 1.7424, 
1.8701, 2.0495, 2.2010, 2.3498, 2.5061, 2.6522, 2.8101, 2.9654, 0.1468, 0.3363, 0.4748, 0.6645, 0.7704, 0.8472, 0.9688, 1.1161, 
1.2929, 1.4648, 1.6101, 1.7753, 1.8918, 2.0788, 2.2212, 2.3697, 2.5156, 2.6535, 2.8097, 2.9669, 0.2093, 0.3679, 0.4453, 0.6130, 
0.7225, 0.8482, 1.0341, 1.1537, 1.2889, 1.4605, 1.5785, 1.7303, 1.8466, 2.0314, 2.1931, 2.3403, 2.4949, 2.6475, 2.8109, 2.9672, 
0.0990, 0.2279, 0.3506, 0.5357, 0.6608, 0.8117, 0.9930, 1.1395, 1.3025, 1.4607, 1.5989, 1.7658, 1.8830, 2.0620, 2.2171, 2.3647, 
2.5148, 2.6583, 2.8151, 2.9689, 0.1526, 0.2818, 0.3926, 0.5601, 0.6776, 0.7982, 0.9554, 1.0972, 1.2681, 1.4457, 1.5934, 1.7644, 
1.8867, 2.0678, 2.2277, 2.3753, 2.5217, 2.6610, 2.8151, 2.9671, 0.1664, 0.2865, 0.3753, 0.5542, 0.7075, 0.8239, 0.9482, 1.1018, 
1.2804, 1.4409, 1.5888, 1.7569, 1.8760, 2.0564, 2.2125, 2.3592, 2.5109, 2.6547, 2.8128, 2.9673, 0.1497, 0.2776, 0.4040, 0.6093, 
0.6903, 0.8241, 0.9759, 1.0756, 1.2293, 1.4062, 1.5640, 1.7444, 1.8690, 2.0471, 2.2058, 2.3548, 2.5082, 2.6541, 2.8123, 2.9663, 
0.1856, 0.3246, 0.4160, 0.5572, 0.6681, 0.8443, 1.0393, 1.1434, 1.2551, 1.4226, 1.5953, 1.7619, 1.8762, 2.0626, 2.2266, 2.3616, 
2.5056, 2.6552, 2.8174, 2.9657, 0.1963, 0.3169, 0.3824, 0.5766, 0.6988, 0.8159, 1.0130, 1.1110, 1.2497, 1.4341, 1.5718, 1.7518, 
1.8737, 2.0510, 2.2107, 2.3543, 2.5119, 2.6529, 2.8120, 2.9667, 0.1856, 0.3454, 0.4117, 0.5668, 0.7447, 0.8623, 0.9852, 1.1690, 
1.2915, 1.3994, 1.5688, 1.7447, 1.8442, 2.0565, 2.2031, 2.3417, 2.5085, 2.6514, 2.8045, 2.9678, 0.1660, 0.2923, 0.4013, 0.5757, 
0.6739, 0.8321, 1.0109, 1.1455, 1.2546, 1.3844, 1.5564, 1.7446, 1.8702, 2.0453, 2.2067, 2.3576, 2.5086, 2.6522, 2.8103, 2.9659, 
0.1399, 0.3315, 0.4603, 0.6454, 0.7743, 0.9153, 1.0794, 1.2339, 1.3972, 1.5176, 1.5984, 1.7353, 1.8565, 2.0569, 2.2083, 2.3508, 
2.5053, 2.6524, 2.8188, 2.9722, 0.1288, 0.3059, 0.4501, 0.6671, 0.7666, 0.8348, 0.9684, 1.1432, 1.3353, 1.5161, 1.6186, 1.7363, 
1.8551, 2.0594, 2.2070, 2.3614, 2.5017, 2.6432, 2.8081, 2.9672, 0.1283, 0.3108, 0.4497, 0.6447, 0.7964, 0.8913, 0.9786, 1.1139, 
1.3089, 1.4954, 1.6582, 1.7989, 1.8601, 2.0313, 2.2017, 2.3570, 2.5284, 2.6688, 2.8041, 2.9530, 0.1353, 0.3106, 0.4598, 0.6512, 
0.7234, 0.8098, 0.9998, 1.1857, 1.3597, 1.4860, 1.5771, 1.7548, 1.9111, 2.1113, 2.2261, 2.3281, 2.4854, 2.6665, 2.8452, 2.9846, 
0.1604, 0.3143, 0.4318, 0.6003, 0.7132, 0.8728, 1.0448, 1.1722, 1.3083, 1.4632, 1.5988, 1.7629, 1.8779, 2.0539, 2.2067, 2.3572, 
2.5069, 2.6503, 2.8111, 2.9627, 0.1028, 0.2826, 0.4500, 0.6391, 0.7665, 0.9555, 1.1078, 1.1585, 1.2412, 1.4131, 1.5947, 1.7693, 
1.8957, 2.0951, 2.2557, 2.3628, 2.5030, 2.6596, 2.8153, 2.9674, 0.1349, 0.3392, 0.4855, 0.6061, 0.6773, 0.8411, 1.0665, 1.1875, 
1.2882, 1.4453, 1.6329, 1.8118, 1.8896, 2.0350, 2.2010, 2.3721, 2.5096, 2.6424, 2.8095, 2.9693, 0.2062, 0.3369, 0.3912, 0.5671, 
0.7037, 0.8188, 1.0099, 1.1641, 1.3288, 1.4701, 1.5703, 1.7315, 1.8461, 2.0220, 2.1849, 2.3378, 2.4970, 2.6473, 2.8072, 2.9652, 
0.1611, 0.2965, 0.3994, 0.5760, 0.7066, 0.8527, 1.0117, 1.1601, 1.3263, 1.4822, 1.6103, 1.7697, 1.8850, 2.0370, 2.1847, 2.3501, 
2.5087, 2.6489, 2.8095, 2.9630, 0.1740, 0.3077, 0.3979, 0.5763, 0.6674, 0.7658, 0.9572, 1.1408, 1.3099, 1.4713, 1.6110, 1.7712, 
1.8662, 2.0278, 2.1799, 2.3338, 2.4943, 2.6458, 2.8068, 2.9654, 0.1644, 0.2687, 0.3549, 0.5580, 0.7462, 0.8957, 0.9979, 1.1157, 
1.2975, 1.4555, 1.5783, 1.7220, 1.8323, 2.0177, 2.1885, 2.3429, 2.5006, 2.6499, 2.8095, 2.9659, 0.1396, 0.3211, 0.4387, 0.5910, 
0.7217, 0.8955, 1.0590, 1.1835, 1.3460, 1.5024, 1.6307, 1.8283, 1.9458, 2.0646, 2.1776, 2.3532, 2.5179, 2.6556, 2.8191, 2.9694, 
0.1820, 0.2880, 0.3636, 0.5345, 0.6327, 0.7978, 1.0031, 1.1387, 1.2978, 1.4558, 1.5979, 1.7627, 1.8847, 2.0610, 2.1793, 2.3540, 
2.5294, 2.6627, 2.8095, 2.9644, 0.1252, 0.2473, 0.3853, 0.5624, 0.7105, 0.8498, 0.9762, 1.1477, 1.3090, 1.4242, 1.5993, 1.7636, 
1.8327, 2.0352, 2.2026, 2.3320, 2.5015, 2.6514, 2.8022, 2.9628, 0.2073, 0.3438, 0.3918, 0.5472, 0.7194, 0.8508, 1.0187, 1.1760, 
1.2857, 1.4605, 1.6015, 1.7364, 1.8728, 2.0492, 2.1888, 2.3526, 2.5016, 2.6466, 2.8089, 2.9626, 0.1434, 0.2665, 0.3690, 0.5565, 
0.6735, 0.8049, 1.0074, 1.1739, 1.3292, 1.4451, 1.5527, 1.7176, 1.8464, 2.0366, 2.1979, 2.3497, 2.5038, 2.6518, 2.8105, 2.9653, 
0.0561, 0.0312, 0.0155, -0.0042, 0.0325, 0.0171, 0.0047, 0.0264, 0.0483, 0.0216, -0.0111, -0.0329, 0.0229, 0.0045, -0.0032, 0.0015, 
0.0081, 0.0198, 0.0181, 0.0193, 0.0423, 0.0088, -0.0058, -0.0414, -0.0039, 0.0202, 0.0252, 0.0543, 0.0252, -0.0252, -0.0090, -0.0030, 
0.0404, 0.0114, 0.0680, 0.1005, 0.0661, 0.0072, -0.0267, -0.0069, -0.0397, -0.0683, -0.0203, -0.0272, 0.0078, 0.0040, -0.0156, 0.0067, 
0.0163, 0.0187, 0.0435, 0.0378, 0.0811, 0.0438, -0.0306, -0.0252, -0.0009, 0.0161, 0.0134, 0.0158, 0.0200, -0.0239, -0.0162, -0.0100, 
0.0278, 0.0185, 0.0115, 0.0347, 0.0359, 0.0240, 0.0296, 0.0116, 0.0473, 0.0197, 0.0079, 0.0177, 0.0266, 0.0430, 0.0641, 0.0436, 
-0.0128, 0.0234, 0.0498, -0.0345, -0.0268, 0.0514, 0.0364, 0.0499, 0.0485, 0.0428, 0.0564, 0.0481, 0.0919, 0.0574, 0.0130, 0.0282, 
0.0017, -0.0071, 0.0073, 0.0156, -0.0074, 0.0132, 0.0242, -0.0196, 0.0217, 0.0452, 0.0326, 0.0172, 0.0195, 0.0434, 0.0361, -0.0285, 
-0.0001, 0.0035, 0.0074, -0.0221, -0.0314, -0.0046, 0.0049, 0.0143, -0.0005, -0.0231, 0.0000, -0.0433, -0.0190, -0.0067, -0.0218, 0.0094, 
0.0235, 0.0337, 0.0322, -0.0196, 0.0049, -0.0037, 0.0272, -0.0061, -0.0058, 0.0210, 0.0170, 0.0165, 0.0121, -0.0081, 0.0233, 0.0268, 
0.0422, -0.0014, -0.0065, 0.0172, 0.0130, 0.0054, 0.0201, 0.0062, 0.0431, 0.0160, 0.0193, 0.0402, 0.0449, 0.0152, -0.0066, 0.0082, 
-0.0388, -0.0291, 0.0236, -0.0205, -0.0011, -0.0001, -0.0203, 0.0054, 0.0064, -0.0207, -0.0137, -0.0211, 0.0169, -0.0032, -0.0093, -0.0004, 
0.0357, 0.0354, -0.0014, -0.0013, -0.0215, -0.0158, 0.0584, 0.0477, 0.0426, 0.0422, 0.0241, 0.0117, -0.0025, -0.0027, 0.0182, 0.0029, 
0.0412, 0.0151, 0.0549, 0.0632, 0.0653, 0.0757, 0.0695, 0.0421, 0.0022, 0.0325, 0.0862, 0.0287, 0.0114, 0.0130, 0.0068, -0.0033, 
-0.0203, -0.0141, 0.0073, -0.0058, 0.0333, 0.0088, 0.0676, 0.0589, 0.0051, -0.0155, -0.0006, 0.0127, -0.0292, -0.0195, 0.0575, 0.0156, 
0.0006, 0.0107, -0.0123, 0.0147, 0.0253, 0.0278, 0.0644, 0.0385, 0.0303, -0.0152, -0.0222, 0.0136, 0.0206, 0.0226, 0.0215, 0.0208, 
-0.0255, -0.0425, 0.0049, 0.0131, 0.0372, 0.0390, -0.0150, -0.0178, 0.0075, 0.0045, 0.0157, 0.0020, 0.0357, 0.0057, 0.0122, 0.0176, 
0.0198, 0.0277, 0.0226, 0.0208, 0.0567, 0.0520, 0.0237, -0.0588, -0.0326, -0.0352, -0.0394, 0.0085, 0.0105, 0.0036, 0.0152, 0.0020, 
0.0395, 0.0105, 0.0280, 0.0407, 0.0652, 0.0661, 0.0186, -0.0080, 0.0320, 0.0601, 0.0632, -0.0162, -0.0058, 0.0000, -0.0441, -0.0256, 
-0.0027, -0.0019, 0.0170, 0.0029, 0.0321, 0.0081, 0.0478, 0.0260, 0.0004, 0.0197, 0.0281, 0.0243, 0.0268, 0.0004, 0.0397, 0.0076, 
-0.0044, 0.0231, 0.0238, 0.0318, -0.0023, -0.0106, 0.0283, 0.0012, 0.0055, -0.0158, 0.0285, 0.0320, 0.0307, 0.0348, 0.0273, 0.0219, 
0.4987, 0.4924, 0.4713, 0.4427, 0.4144, 0.4168, 0.3813, 0.3695, 0.3672, 0.3619, 0.3276, 0.3173, 0.3115, 0.2780, 0.3223, 0.2951, 
0.2826, 0.2568, 0.2145, 0.2527, 0.3519, 0.3181, 0.2607, 0.2060, 0.1473, 0.1563, 0.1073, 0.0633, 0.0178, 0.0178, -0.0300, -0.0538, 
-0.0466, -0.0529, 0.0389, -0.0240, -0.0405, -0.1279, -0.1221, 0.0012, 
};

double tvqtab_20b19s48sc[] = {
0.1567, 0.2930, 0.4518, 0.6063, 0.7601, 0.9216, 1.0670, 1.2147, 1.3665, 1.5191, 1.6681, 1.8001, 1.9483, 2.1034, 2.2565, 2.3958, 
2.5371, 2.6784, 2.8201, 2.9648, 0.1363, 0.2451, 0.3925, 0.5240, 0.6463, 0.8015, 0.9244, 1.0729, 1.2474, 1.4157, 1.5815, 1.7372, 
1.8908, 2.0462, 2.2112, 2.3506, 2.4974, 2.6530, 2.7995, 2.9567, 0.1649, 0.2806, 0.4123, 0.5608, 0.7206, 0.8699, 0.9973, 1.1528, 
1.3042, 1.4500, 1.6105, 1.7487, 1.8897, 2.0482, 2.2069, 2.3509, 2.4990, 2.6508, 2.7986, 2.9581, 0.1559, 0.2632, 0.4053, 0.5361, 
0.7076, 0.8445, 0.9292, 1.0251, 1.1718, 1.3625, 1.5449, 1.7128, 1.8790, 2.0404, 2.2004, 2.3505, 2.5068, 2.6627, 2.8200, 2.9759, 
0.1529, 0.2209, 0.3506, 0.4867, 0.6205, 0.7836, 0.8989, 1.0645, 1.2688, 1.3758, 1.4801, 1.6433, 1.8303, 2.0000, 2.1712, 2.3409, 
2.5026, 2.6545, 2.8170, 2.9744, 0.1433, 0.2288, 0.3578, 0.4937, 0.6217, 0.7847, 0.9273, 1.0626, 1.2336, 1.3957, 1.5397, 1.7040, 
1.8573, 2.0034, 2.1756, 2.3409, 2.5000, 2.6518, 2.8070, 2.9664, 0.1664, 0.2349, 0.3465, 0.4486, 0.5634, 0.7389, 0.9071, 1.0751, 
1.2430, 1.3872, 1.5295, 1.7175, 1.8303, 1.9659, 2.1052, 2.2759, 2.4874, 2.6327, 2.7668, 2.9633, 0.1458, 0.2419, 0.3502, 0.4939, 
0.6698, 0.8162, 0.9193, 1.0387, 1.2036, 1.3958, 1.5755, 1.7351, 1.8583, 1.9894, 2.1630, 2.3414, 2.4937, 2.6384, 2.7951, 2.9633, 
0.1491, 0.2608, 0.4017, 0.5588, 0.7190, 0.8763, 1.0197, 1.1674, 1.3192, 1.4770, 1.6349, 1.7749, 1.9286, 2.0907, 2.2376, 2.3789, 
2.5253, 2.6725, 2.8259, 2.9750, 0.1812, 0.2982, 0.4199, 0.5490, 0.6944, 0.7986, 0.8602, 0.9987, 1.2019, 1.4017, 1.5757, 1.7307, 
1.8879, 2.0500, 2.1715, 2.3190, 2.4852, 2.6498, 2.8074, 2.9718, 0.1640, 0.2604, 0.3885, 0.5396, 0.6878, 0.8403, 0.9959, 1.1211, 
1.2562, 1.4133, 1.5712, 1.7299, 1.8956, 2.0557, 2.2103, 2.3572, 2.5108, 2.6634, 2.8211, 2.9763, 0.1566, 0.2970, 0.4632, 0.5803, 
0.6433, 0.7481, 0.9195, 1.1048, 1.2769, 1.4439, 1.6033, 1.7564, 1.9081, 2.0646, 2.2041, 2.3490, 2.4886, 2.6269, 2.7689, 2.9472, 
0.1467, 0.2153, 0.3610, 0.5554, 0.7325, 0.8634, 0.9628, 1.1097, 1.3069, 1.4554, 1.5611, 1.6825, 1.8505, 2.0227, 2.1789, 2.3352, 
2.4982, 2.6573, 2.8150, 2.9725, 0.1285, 0.2004, 0.3540, 0.5039, 0.6163, 0.7581, 0.9083, 1.0782, 1.2559, 1.4238, 1.5749, 1.7240, 
1.8709, 2.0279, 2.1951, 2.3786, 2.5410, 2.6805, 2.8318, 2.9801, 0.1463, 0.2438, 0.3903, 0.5417, 0.6666, 0.7941, 0.9412, 1.1156, 
1.2950, 1.4665, 1.6099, 1.7220, 1.8562, 2.0184, 2.1976, 2.3507, 2.5054, 2.6602, 2.8182, 2.9738, 0.1344, 0.1615, 0.2467, 0.4187, 
0.6347, 0.8100, 0.9542, 1.1096, 1.2665, 1.4258, 1.5829, 1.7285, 1.8835, 2.0436, 2.1891, 2.3415, 2.4915, 2.6198, 2.7569, 2.9449, 
0.1870, 0.3036, 0.4315, 0.5350, 0.6405, 0.7804, 0.9596, 1.1519, 1.3195, 1.4341, 1.5404, 1.6821, 1.8442, 2.0090, 2.1585, 2.3114, 
2.4752, 2.6417, 2.8005, 2.9638, 0.1751, 0.2719, 0.3828, 0.5296, 0.7036, 0.9034, 1.0637, 1.1863, 1.3125, 1.4169, 1.5111, 1.6425, 
1.8131, 1.9929, 2.1476, 2.3055, 2.4739, 2.6423, 2.8053, 2.9703, 0.1547, 0.3035, 0.4669, 0.5746, 0.6720, 0.8425, 1.0330, 1.1782, 
1.2909, 1.4494, 1.6306, 1.7793, 1.8982, 2.0380, 2.2171, 2.3780, 2.4998, 2.6364, 2.8080, 2.9789, 0.1600, 0.2923, 0.4369, 0.5654, 
0.6968, 0.8422, 0.9896, 1.1608, 1.3081, 1.4465, 1.5856, 1.7046, 1.8411, 1.9932, 2.1526, 2.3165, 2.4797, 2.6425, 2.8061, 2.9680, 
0.1562, 0.2721, 0.4059, 0.5534, 0.7148, 0.8458, 0.9977, 1.1582, 1.3127, 1.5004, 1.6237, 1.7315, 1.9120, 2.0342, 2.1649, 2.3464, 
2.4693, 2.6224, 2.7995, 2.9671, 0.0886, 0.1482, 0.3145, 0.5203, 0.7025, 0.8746, 1.0101, 1.1515, 1.3107, 1.4647, 1.6207, 1.7669, 
1.9143, 2.0666, 2.1859, 2.3295, 2.4918, 2.6541, 2.8129, 2.9723, 0.1526, 0.2884, 0.4275, 0.5815, 0.7543, 0.9188, 1.0653, 1.2176, 
1.3491, 1.4997, 1.6900, 1.8325, 1.9063, 1.9897, 2.1563, 2.3462, 2.4988, 2.6451, 2.7962, 2.9644, 0.1488, 0.2703, 0.4265, 0.5861, 
0.7440, 0.8934, 1.0286, 1.1766, 1.3575, 1.5352, 1.6460, 1.6996, 1.8178, 2.0112, 2.2095, 2.3733, 2.4985, 2.6320, 2.7964, 2.9644, 
0.1572, 0.2429, 0.3593, 0.5062, 0.6562, 0.8095, 0.9610, 1.1180, 1.2825, 1.4421, 1.6008, 1.7497, 1.9010, 2.0565, 2.2080, 2.3977, 
2.5566, 2.6866, 2.8352, 2.9804, 0.1483, 0.2405, 0.3764, 0.5123, 0.6309, 0.7726, 0.9575, 1.1598, 1.2968, 1.3939, 1.5335, 1.6989, 
1.8671, 2.0255, 2.1687, 2.3193, 2.4833, 2.6474, 2.8075, 2.9693, 0.1400, 0.2833, 0.4514, 0.5880, 0.7017, 0.8380, 1.0121, 1.1987, 
1.3348, 1.4524, 1.6014, 1.7690, 1.9371, 2.0673, 2.2007, 2.3651, 2.5405, 2.6912, 2.8146, 2.9573, 0.1470, 0.2935, 0.4763, 0.6216, 
0.7255, 0.8457, 0.9767, 1.1172, 1.2633, 1.4177, 1.5811, 1.7440, 1.8958, 2.0268, 2.1556, 2.3108, 2.4760, 2.6424, 2.8053, 2.9671, 
0.1452, 0.2348, 0.3705, 0.5244, 0.6837, 0.8371, 0.9823, 1.1497, 1.3086, 1.4343, 1.5756, 1.7340, 1.8896, 2.0430, 2.1931, 2.3458, 
2.5031, 2.6589, 2.8180, 2.9747, 0.1752, 0.2676, 0.3921, 0.5289, 0.6385, 0.8015, 1.0014, 1.1711, 1.3076, 1.4502, 1.5964, 1.7216, 
1.8779, 2.0451, 2.1952, 2.3347, 2.4832, 2.6366, 2.7888, 2.9543, 0.1758, 0.2815, 0.3937, 0.5605, 0.6842, 0.7915, 0.9867, 1.1111, 
1.2982, 1.4349, 1.5369, 1.7311, 1.8721, 2.0534, 2.1813, 2.3100, 2.4778, 2.6298, 2.7919, 2.9531, 0.1484, 0.2614, 0.4060, 0.5621, 
0.6949, 0.8380, 1.0034, 1.1408, 1.3059, 1.4644, 1.5745, 1.7082, 1.8647, 2.0263, 2.1836, 2.3269, 2.4801, 2.6403, 2.7939, 2.9558, 
0.1859, 0.2648, 0.4050, 0.5544, 0.7034, 0.8530, 0.9523, 1.0875, 1.2349, 1.3468, 1.4844, 1.6538, 1.8288, 1.9979, 2.1465, 2.3027, 
2.4674, 2.6434, 2.8068, 2.9675, 0.1523, 0.2676, 0.4172, 0.5676, 0.6782, 0.7917, 0.9380, 1.0911, 1.2527, 1.4017, 1.5428, 1.7005, 
1.8617, 2.0219, 2.1783, 2.3305, 2.4898, 2.6492, 2.8090, 2.9696, 0.1429, 0.2452, 0.3811, 0.5172, 0.6436, 0.7800, 0.9157, 1.0533, 
1.2193, 1.3916, 1.5431, 1.6877, 1.8483, 2.0113, 2.1709, 2.3314, 2.4933, 2.6543, 2.8159, 2.9774, 0.1429, 0.2755, 0.4623, 0.6348, 
0.7367, 0.8006, 0.9024, 1.0820, 1.2703, 1.4362, 1.5970, 1.7439, 1.8992, 2.0596, 2.2391, 2.3879, 2.5199, 2.6538, 2.8044, 2.9714, 
0.1755, 0.2674, 0.3797, 0.5093, 0.6128, 0.7680, 0.9463, 1.0888, 1.2435, 1.3842, 1.5028, 1.6530, 1.8138, 1.9719, 2.1481, 2.3143, 
2.4863, 2.6430, 2.8036, 2.9727, 0.1028, 0.2019, 0.4564, 0.5772, 0.6168, 0.7817, 1.0249, 1.1519, 1.2362, 1.3784, 1.5467, 1.7077, 
1.8748, 2.0347, 2.1629, 2.3126, 2.4791, 2.6330, 2.7958, 2.9645, 0.1552, 0.2539, 0.3842, 0.4973, 0.6185, 0.7823, 0.9783, 1.2079, 
1.3287, 1.4312, 1.5682, 1.6595, 1.7912, 1.9505, 2.1305, 2.3021, 2.4812, 2.6502, 2.8077, 2.9730, 0.1440, 0.2506, 0.4179, 0.5561, 
0.6573, 0.7961, 0.9659, 1.1313, 1.2651, 1.3966, 1.5404, 1.6910, 1.8500, 2.0157, 2.1777, 2.3340, 2.4927, 2.6505, 2.8105, 2.9723, 
0.1231, 0.2362, 0.3920, 0.5375, 0.6822, 0.8390, 0.9828, 1.1363, 1.2963, 1.4559, 1.6114, 1.7592, 1.9089, 2.0622, 2.2153, 2.3634, 
2.5155, 2.6669, 2.8236, 2.9771, 0.1644, 0.3065, 0.4254, 0.5421, 0.7221, 0.8851, 0.9748, 1.1407, 1.3215, 1.4231, 1.5704, 1.7570, 
1.8728, 2.0114, 2.1897, 2.3369, 2.4832, 2.6524, 2.7991, 2.9625, 0.1541, 0.2444, 0.3696, 0.4892, 0.5840, 0.7198, 0.9029, 1.0817, 
1.2504, 1.4125, 1.5675, 1.7227, 1.8809, 2.0445, 2.2064, 2.3566, 2.5114, 2.6657, 2.8226, 2.9783, 0.1685, 0.2822, 0.4073, 0.5310, 
0.6780, 0.8260, 0.9442, 1.0943, 1.2424, 1.3927, 1.5633, 1.7210, 1.8769, 2.0336, 2.1866, 2.3397, 2.4986, 2.6565, 2.8165, 2.9738, 
0.1595, 0.2721, 0.4006, 0.5180, 0.6605, 0.8306, 0.9808, 1.1277, 1.3003, 1.4401, 1.5503, 1.6986, 1.8766, 2.0486, 2.2281, 2.3824, 
2.5148, 2.6498, 2.7995, 2.9672, 0.1576, 0.2128, 0.3353, 0.4837, 0.5821, 0.6951, 0.8633, 1.0130, 1.2138, 1.4012, 1.5417, 1.7026, 
1.8413, 2.0040, 2.1891, 2.3420, 2.5054, 2.6629, 2.8164, 2.9719, 0.1623, 0.2444, 0.3882, 0.5410, 0.6619, 0.8141, 0.9687, 1.1125, 
1.2987, 1.4352, 1.5293, 1.6206, 1.7733, 1.9671, 2.1671, 2.3417, 2.5032, 2.6485, 2.8044, 2.9750, 0.1645, 0.2494, 0.4065, 0.5624, 
0.7081, 0.8553, 0.9783, 1.1170, 1.2605, 1.3666, 1.5037, 1.6825, 1.8595, 2.0285, 2.2063, 2.3573, 2.5120, 2.6642, 2.8209, 2.9768, 
0.1412, 0.2599, 0.4089, 0.5763, 0.7575, 0.9404, 1.0963, 1.2039, 1.2875, 1.4104, 1.5831, 1.7469, 1.9057, 2.0655, 2.2198, 2.3592, 
2.5008, 2.6519, 2.8075, 2.9645, 0.1506, 0.2249, 0.3354, 0.4702, 0.6394, 0.8209, 0.9874, 1.1137, 1.2158, 1.3713, 1.5632, 1.7234, 
1.8511, 2.0006, 2.1659, 2.3298, 2.4952, 2.6518, 2.8204, 2.9774, 0.1427, 0.2519, 0.4087, 0.5698, 0.7300, 0.8871, 1.0136, 1.1402, 
1.2784, 1.4188, 1.5715, 1.7279, 1.8821, 2.0373, 2.1915, 2.3442, 2.5019, 2.6578, 2.8168, 2.9741, 0.1546, 0.2464, 0.3871, 0.5358, 
0.6887, 0.8628, 1.0297, 1.1593, 1.2707, 1.3877, 1.5348, 1.7029, 1.8544, 2.0102, 2.1646, 2.3194, 2.4850, 2.6470, 2.8099, 2.9710, 
0.1563, 0.2624, 0.3977, 0.5517, 0.7151, 0.8666, 0.9931, 1.1265, 1.2623, 1.4190, 1.5703, 1.7052, 1.8638, 2.0244, 2.1786, 2.3330, 
2.4926, 2.6513, 2.8121, 2.9714, 0.1756, 0.3055, 0.4336, 0.5642, 0.6999, 0.8519, 1.0053, 1.1666, 1.3314, 1.4941, 1.6493, 1.7804, 
1.9026, 2.0410, 2.1964, 2.3556, 2.5057, 2.6603, 2.8194, 2.9720, 0.1584, 0.3036, 0.4517, 0.5956, 0.7302, 0.8717, 1.0275, 1.1963, 
1.3597, 1.5018, 1.6108, 1.7443, 1.9113, 2.0817, 2.2230, 2.3474, 2.4890, 2.6508, 2.8187, 2.9778, 0.1863, 0.2831, 0.4032, 0.5544, 
0.7006, 0.8505, 1.0197, 1.1847, 1.3216, 1.4270, 1.5489, 1.6950, 1.8516, 2.0187, 2.1520, 2.3037, 2.4735, 2.6409, 2.8040, 2.9682, 
0.1365, 0.2121, 0.3269, 0.4585, 0.6069, 0.7824, 0.9466, 1.1138, 1.2820, 1.4431, 1.6006, 1.7496, 1.9023, 2.0596, 2.2231, 2.3686, 
2.5198, 2.6706, 2.8259, 2.9791, 0.1418, 0.2012, 0.3235, 0.4318, 0.5561, 0.7305, 0.9193, 1.0594, 1.2154, 1.3873, 1.5191, 1.6691, 
1.8355, 2.0049, 2.1635, 2.3106, 2.4786, 2.6498, 2.7995, 2.9615, 0.1298, 0.2535, 0.4368, 0.6313, 0.8039, 0.9111, 0.9697, 1.0732, 
1.2481, 1.4316, 1.5946, 1.7482, 1.8986, 2.0577, 2.2190, 2.3698, 2.5216, 2.6719, 2.8290, 2.9839, 0.1640, 0.2683, 0.3859, 0.5464, 
0.7210, 0.8791, 0.9947, 1.1248, 1.2728, 1.4200, 1.5777, 1.6956, 1.8111, 1.9719, 2.1449, 2.3340, 2.5168, 2.6671, 2.8300, 2.9820, 
0.1600, 0.2608, 0.4067, 0.5504, 0.6802, 0.8170, 0.9717, 1.1255, 1.2888, 1.4648, 1.6376, 1.8126, 1.9239, 2.0146, 2.1353, 2.3044, 
2.4523, 2.6180, 2.7863, 2.9651, 0.1642, 0.2736, 0.3797, 0.5014, 0.6611, 0.8243, 0.9655, 1.1203, 1.2834, 1.4431, 1.6040, 1.7534, 
1.9015, 2.0469, 2.1684, 2.3180, 2.4840, 2.6484, 2.8086, 2.9696, 0.1500, 0.2730, 0.4163, 0.5685, 0.7419, 0.9107, 1.0222, 1.1298, 
1.2903, 1.4624, 1.6191, 1.7762, 1.9303, 2.0511, 2.1871, 2.3528, 2.5078, 2.6608, 2.8287, 2.9768, 0.1448, 0.2603, 0.3473, 0.4684, 
0.6635, 0.8312, 0.9606, 1.1240, 1.2812, 1.3949, 1.5717, 1.7249, 1.9085, 2.0455, 2.1565, 2.2900, 2.4086, 2.6323, 2.8375, 2.9776, 
0.0383, 0.0567, 0.0096, 0.0058, 0.0176, 0.0025, 0.0011, -0.0004, 0.0199, 0.0127, -0.0218, -0.0168, 0.0079, 0.0142, -0.0017, 0.0067, 
0.0106, 0.0125, 0.0100, 0.0094, 0.0081, 0.0043, -0.0335, -0.0402, -0.0120, 0.0213, 0.0420, 0.0507, 0.0238, -0.0191, -0.0249, -0.0022, 
0.0109, 0.0117, 0.0497, 0.0557, 0.0464, 0.0350, 0.0275, 0.0190, -0.0261, -0.0480, -0.0460, -0.0140, 0.0035, 0.0071, 0.0125, 0.0034, 
-0.0005, 0.0004, 0.0096, 0.0340, 0.0524, 0.0495, -0.0303, -0.0281, -0.0080, 0.0009, -0.0004, 0.0039, 0.0102, -0.0001, -0.0296, -0.0006, 
0.0327, 0.0346, 0.0448, 0.0414, 0.0344, 0.0273, 0.0219, 0.0264, 0.0257, 0.0208, -0.0120, -0.0134, 0.0141, 0.0377, 0.0392, 0.0162, 
0.0104, 0.0071, 0.0110, 0.0152, -0.0102, 0.0115, 0.0289, 0.0372, 0.0476, 0.0562, 0.0607, 0.0667, 0.0618, 0.0449, 0.0256, -0.0128, 
-0.0182, 0.0032, 0.0050, 0.0107, -0.0177, 0.0338, 0.0173, 0.0015, 0.0224, 0.0144, 0.0340, 0.0447, 0.0526, 0.0358, -0.0029, -0.0166, 
-0.0123, -0.0052, 0.0066, -0.0246, -0.0336, -0.0143, -0.0047, 0.0054, -0.0163, 0.0226, 0.0214, -0.0236, -0.0324, -0.0239, -0.0003, 0.0098, 
-0.0045, -0.0015, 0.0045, 0.0126, 0.0129, 0.0104, -0.0208, -0.0085, 0.0011, 0.0066, 0.0228, 0.0289, 0.0096, 0.0184, 0.0142, 0.0422, 
0.0419, -0.0037, 0.0150, 0.0267, 0.0238, 0.0191, 0.0134, 0.0177, 0.0218, 0.0207, 0.0410, 0.0594, 0.0599, 0.0113, -0.0264, -0.0092, 
-0.0428, -0.0164, -0.0020, -0.0084, -0.0008, 0.0143, 0.0203, 0.0009, -0.0134, -0.0132, -0.0215, -0.0289, -0.0202, -0.0083, 0.0009, 0.0297, 
0.0171, -0.0150, -0.0062, 0.0079, -0.0259, 0.0130, 0.0487, 0.0691, 0.0466, 0.0350, 0.0465, 0.0052, -0.0155, 0.0023, 0.0134, 0.0146, 
0.0142, 0.0110, 0.0290, 0.0326, 0.0437, 0.0669, 0.0835, 0.0498, -0.0035, 0.0321, 0.0540, 0.0382, 0.0055, 0.0101, 0.0146, -0.0031, 
-0.0324, -0.0381, -0.0189, 0.0044, 0.0177, 0.0185, 0.0471, 0.0252, -0.0066, -0.0072, -0.0129, -0.0052, -0.0373, -0.0028, 0.0375, 0.0295, 
-0.0016, -0.0017, -0.0022, 0.0084, 0.0219, 0.0322, 0.0421, 0.0369, 0.0094, -0.0019, 0.0096, 0.0242, 0.0324, 0.0310, 0.0363, 0.0306, 
-0.0433, -0.0333, 0.0010, 0.0338, 0.0340, 0.0181, -0.0051, -0.0337, -0.0170, 0.0115, 0.0188, 0.0132, 0.0110, 0.0114, 0.0232, 0.0250, 
0.0232, 0.0203, 0.0150, 0.0128, 0.0552, 0.0672, -0.0093, -0.0535, -0.0220, -0.0204, -0.0284, -0.0194, -0.0177, -0.0228, -0.0217, -0.0114, 
-0.0043, -0.0033, -0.0012, 0.0158, 0.0533, 0.0514, 0.0011, -0.0072, 0.0209, 0.0653, 0.0635, 0.0541, 0.0327, -0.0325, -0.0418, -0.0221, 
-0.0020, 0.0078, 0.0096, 0.0202, 0.0285, 0.0278, 0.0574, 0.0428, -0.0096, -0.0110, 0.0260, 0.0358, 0.0146, 0.0620, 0.0578, 0.0008, 
-0.0285, 0.0054, 0.0183, 0.0136, 0.0081, 0.0010, -0.0056, 0.0145, -0.0033, -0.0204, 0.0380, 0.0141, 0.0198, 0.0573, 0.0310, -0.0055, 
0.4989, 0.4993, 0.4990, 0.4995, 0.4999, 0.4985, 0.4973, 0.4990, 0.4977, 0.4971, 0.4977, 0.4995, 0.4969, 0.4986, 0.4996, 0.4996, 
0.4999, 0.4989, 0.4937, 0.4906, 0.2664, 0.3126, 0.3112, 0.3132, 0.2987, 0.2609, 0.2724, 0.2535, 0.2363, 0.2679, 0.2746, 0.2536, 
0.2708, 0.2690, 0.2831, 0.2939, 0.2620, 0.2428, 0.2456, 0.2665, 
};

double tvqtab_cdmdct_0[] = {
-165.2, 44.8, 83.7, -31.8, -54.7, 79.8, 104.3, -11322.7, -46.7, -5.7, 139.8, -38.4, -59.7, -101.2, -5.6, 134.4, 
34.0, 113.0, -738.8, 80.1, 17.2, 4.2, 148.2, 54.7, 54.2, -11.9, 74.7, 35.2, 73.9, 90.0, 9523.9, 73.2, 
1.1, -47.8, -5.7, -966.6, 60.0, 120.8, -189.5, -59.4, 395.5, 136.0, 5816.1, -64.1, -89.2, 17.3, 371.2, -9.6, 
11.2, -10.6, -31.9, 27.1, -41.5, 31.5, -496.7, -138.5, -2108.3, -272.2, -99.2, 262.8, -1136.4, -142.9, 73.5, -92.0, 
-544.9, -28.6, -79.1, -85.1, 136.3, -5.4, -122.4, -81.2, -6.2, 5.8, -123.2, 11554.5, 4.3, -71.2, -22.1, -203.1, 
-56.0, 14.4, 30.0, -2.6, 29.7, -150.0, 96.5, 71.3, 24.7, -130.8, -7.1, 5682.9, -7.6, 43.1, 15.6, 35.9, 
-219.7, -84.9, -1051.1, 647.5, 209.2, -93.8, -105.8, -18.2, 51.5, 22.9, -38.3, 88.0, 4.6, -38.3, -118.2, 328.6, 
12156.2, -111.0, -47.0, 109.5, -3.2, 116.4, -156.3, 51.0, 69.1, -74.3, 15.4, 184.4, -165.6, -97.8, 23.8, 12.2, 
-12330.6, -72.9, 57.2, 42.0, -55.7, 61.3, -107.8, 98.3, 167.9, 32.8, 146.0, 6.3, 58.7, 728.0, -3068.5, -263.4, 
-353.1, -398.7, 2696.7, 95.2, -202.9, -28.2, -5.6, 45.7, 22.5, 13.1, -66.7, 42.0, -269.3, -467.2, -208.8, 2168.0, 
17.8, -3857.2, -214.1, 221.1, -3488.2, 83.3, -162.9, -260.7, 3.5, -46.1, 32.8, -73.8, -1.0, -53.0, 397.9, 227.4, 
-961.9, 286.9, -229.0, 364.3, -7050.2, 4.7, 168.8, -40.4, 51.1, -143.8, -141.4, -56.7, -159.6, 79.5, -8.1, 23.2, 
2.3, -51.7, 54.7, 186.3, 6.3, 44.6, -91.9, 54.7, -329.7, -636.1, 207.9, 115.0, -178.2, -103.3, 65.0, -120.6, 
-4683.1, -975.1, -77.1, 85.8, 53.5, 42.0, 184.9, -51.3, 355.2, -112.8, -321.5, 79.8, 14.4, 32.5, 1394.3, -151.4, 
48.1, -35.6, 293.8, 4278.1, -118.0, 173.6, 21.0, -36.7, -7.3, 37.1, 975.2, 253.8, 213.2, 476.8, -1456.0, -23.3, 
255.3, -5356.6, 89.0, 351.0, 429.9, 175.9, 381.5, 39.8, -315.5, 43.2, 57.3, 196.0, 9.8, 33.2, 1035.0, 92.4, 
1186.0, 31.7, 145.9, -27.5, -2680.3, 260.6, 3250.2, -8.1, -326.9, 12.0, -191.2, 237.9, -30.4, -41.6, 28.7, 10.7, 
-20.2, 11.9, -456.6, 146.7, 50.0, -546.0, -1884.2, 295.5, 144.6, -204.4, 166.4, 6474.3, -373.7, 49.0, 117.0, -49.0, 
-2.2, 9.8, -7.6, -70.1, 88.3, -27.5, 201.1, 102.2, 58.5, 34.0, 95.8, 36.3, 953.3, 23.7, 296.6, 91.9, 
50.3, -338.5, 6794.1, 7.0, 0.2, 77.2, 27.9, 96.8, 99.2, 11.7, -48.9, 7.5, 138.1, 39.4, 426.9, 26.0, 
-1.2, -408.9, -306.6, -234.8, 89.0, -555.9, 22.0, 106.6, 98.0, 11.5, -4.6, -15.3, -52.1, 58.4, 11645.8, -104.3, 
-52.0, -66.8, 162.1, -38.7, -2503.0, -167.9, -131.7, 159.9, 75.5, -314.6, 3624.7, -25.9, 229.1, -144.9, 30.6, -191.3, 
51.7, -35.8, -69.2, -178.6, -196.6, 202.2, 165.9, -165.6, 14.1, -8789.4, -46.0, 49.4, -14.4, 112.4, -30.6, 82.4, 
-160.4, 21.3, 74.0, 50.2, 82.7, 53.1, 59.1, -15.9, -285.9, 91.9, 145.8, 240.5, -331.2, -1859.9, 19.9, 343.1, 
-63.4, 3389.2, 541.5, 485.4, 129.3, 214.5, 29.4, 19.0, 33.4, -15.1, -1094.3, -528.6, 266.3, -185.5, -478.7, -185.8, 
-123.0, 3966.6, -17.5, 4279.8, -15.7, -47.5, 239.8, 76.4, 9.8, -3.7, -2.0, 29.3, 49.4, -109.1, 182.2, -47.5, 
158.0, -80.9, 542.0, -328.9, -213.5, 492.4, -408.5, 2968.7, 99.5, -651.8, -379.6, 728.1, -230.4, 192.2, 84.5, -130.0, 
-20.3, -78.7, -502.3, -74.0, -11514.1, -172.9, -882.0, -26.7, -401.2, 120.3, 23.1, -233.7, 3403.0, -332.7, 47.4, 23.8, 
190.7, -735.1, 131.1, -83.0, -30.7, -147.3, -263.5, 306.2, -54.8, 11629.9, 308.2, -528.0, -308.5, 1931.8, 659.7, 126.0, 
-4247.4, -208.0, 347.9, 207.5, 76.0, -238.6, 184.0, -58.0, -52.3, -23.7, 194.3, 165.8, 46.6, 400.7, -1299.6, -120.9, 
-3467.8, -4196.2, -49.0, -28.7, -107.2, -172.7, -355.4, 210.5, -72.0, -118.8, 41.6, -159.4, 77.6, -97.3, -136.3, 47.9, 
-402.7, 132.7, -101.5, -288.8, -71.0, 517.2, -413.7, -1414.0, -374.7, -86.5, -285.7, 322.6, -473.0, 351.9, 436.9, -71.8, 
62.9, -4541.1, -314.8, 271.7, 25.2, 250.9, -436.7, 500.3, 94.6, -66.5, 311.2, 3960.3, 3911.6, 528.5, 309.7, -213.5, 
74.9, 52.6, 28.3, -52.8, -48.6, -101.2, -18.1, -283.0, 671.4, -38.7, 282.7, 39.6, 692.1, -48.2, -87.8, 112.4, 
43.7, 7489.0, -30.8, -63.6, 87.2, -13.4, 59.8, 25.1, -82.8, 4.7, -162.0, 26.4, -94.8, -86.0, 190.6, -353.1, 
-4033.6, 182.3, -237.9, -49.0, -181.6, 453.2, -508.9, -56.1, -86.6, -51.4, 90.5, -4.4, -19.8, 53.4, -97.7, -284.1, 
180.3, 263.8, 3747.0, 0.8, 1019.4, -1791.3, 15.8, 252.2, 83.0, -3434.4, 132.8, -87.3, 93.9, 199.1, -149.5, -30.6, 
14.1, 31.4, -17.3, 828.3, 76.8, -403.0, 21.1, 541.3, 7.4, -0.4, 10.4, 165.8, -24.5, 49.6, 54.0, -88.5, 
96.7, -12001.5, -61.2, 2.8, 43.7, -39.3, 292.9, -87.4, -132.9, -36.3, 538.9, 45.2, 83.6, -75.6, 37.8, -16.5, 
10805.3, 65.4, -23.6, 17.0, 17.1, -73.1, 21.4, 10.9, 64.0, 19.7, 46.0, 84.1, -112.2, -55.3, 244.2, 134.2, 

};

double tvqtab_cdmdct_1[] = {
235.3, 67.3, 50.9, -70.8, 141.0, -11826.5, -180.2, -63.5, 101.1, -67.7, -52.8, -26.3, 3.1, 9.5, -213.3, 91.1, 
-19.6, -208.5, 185.1, 155.8, -2551.4, -264.8, 68.9, -3066.5, -340.7, 139.4, 130.4, 26.9, 60.2, 35.7, -4.1, 74.7, 
-35.7, 10.4, -215.4, -28.2, 182.3, 258.3, 272.9, -157.2, 625.1, -205.8, 260.9, -388.8, -46.3, -37.3, 40.9, -162.9, 
-59.8, -66.2, -57.3, -204.2, -46.2, 54.2, 121.4, -154.5, -12125.0, 83.4, 421.2, 168.3, -209.8, 227.0, -229.9, -47.0, 
6981.7, -61.2, 43.9, -60.2, -68.3, 50.4, 34.3, -0.2, 16.8, 10.1, -144.3, -9.7, -127.6, -128.7, -320.2, 195.7, 
3358.8, 295.2, -171.2, -205.5, -2008.6, -196.7, 25.4, -112.9, -50.6, -304.3, -65.0, -49.7, -54.0, -35.7, -2190.0, 54.1, 
-279.0, 491.8, 37.6, -327.2, -11.3, -341.2, 158.5, 133.3, -158.6, 2.8, -11.8, -38.9, 6211.1, -519.8, -58.8, -26.8, 
17.3, -57.9, 341.8, -294.8, 20.2, 38.5, 378.2, 101.3, 66.0, 85.5, 1894.5, 3096.2, -1994.1, 40.0, -103.1, -369.4, 
-93.3, -65.3, 151.1, 34.0, 12.1, -27.7, -488.9, -136.9, 39.4, 1058.2, 385.7, 370.2, -8.0, -8.6, -44.9, 18.7, 
-73.3, 50.5, -4.0, -61.6, -14.4, 1.7, 5132.2, -25.8, 147.1, 42.4, 18.2, 2672.9, 182.8, -251.4, -329.7, 378.2, 
-4.6, 165.2, -55.1, 9383.7, 117.1, -95.3, -115.3, 18.8, -0.1, 59.2, 70.4, -45.5, 21.6, -8.3, 29.7, -51.5, 
294.9, -117.1, -209.5, -44.2, -214.8, -80.8, 47.6, -433.9, 371.7, 5001.4, -330.3, 27.5, 37.4, -44.0, -255.9, -153.2, 
63.1, -12.2, -152.5, 552.9, 216.9, -145.0, -903.1, 512.9, 1342.8, -240.9, -920.2, 98.8, -132.1, -192.2, -158.8, 3771.8, 
-21.2, -158.4, -48.4, 107.4, 60.7, -10.7, -13.8, -227.2, 240.3, 478.1, 319.2, 496.1, 4.8, -5600.1, 492.0, 159.7, 
-55.6, -26.9, -318.6, 121.0, 149.8, 91.1, 126.5, -130.8, -63.2, 89.2, -228.1, -49.0, 132.7, -101.9, 95.8, -197.4, 
356.8, 2654.8, -358.9, 114.0, 103.3, 85.6, 22.1, -37.8, 106.3, 1.2, -15.0, -49.8, -72.9, 170.8, -66.0, 36.2, 
2617.9, -162.5, 503.6, 1981.6, -9.4, 127.7, 23.1, -66.9, -122.5, -198.8, 101.7, 56.8, 41.2, 89.5, -60.9, 30.3, 
5664.6, 159.7, 213.8, -162.9, -59.2, 84.3, -33.3, -259.1, -103.3, 42.4, -1.0, -180.8, 44.4, 743.2, 4688.1, 28.2, 
-81.9, 51.3, 69.5, 61.2, -106.5, -11.6, -37.0, -126.5, -27.4, 164.2, -136.7, -88.4, -1042.2, -313.7, -154.2, -414.9, 
650.3, -2755.9, -161.8, 364.9, 103.8, 27.5, -94.9, -172.6, -75.1, 108.1, -7700.0, -310.2, 161.1, -56.1, -341.6, -34.1, 
-54.2, -3008.6, -3909.4, -85.6, -62.9, -56.7, 108.9, 40.0, 267.7, -151.7, 144.4, -63.7, -221.4, -67.8, 193.4, 55.7, 
572.8, -265.8, -565.6, -407.7, -63.3, 231.6, -3415.5, 601.0, 575.7, 1192.1, -742.8, 47.0, -427.7, 29.6, 58.8, 46.8, 
-87.6, 101.1, -843.8, 314.8, -1669.2, -178.3, -315.2, -230.1, 558.0, -233.4, 130.9, 5.3, 42.9, -227.1, 63.8, -7070.4, 
-35.4, 27.3, -70.9, -14.2, 30.6, 127.3, 499.7, 11.2, 343.1, 789.6, 860.6, 325.5, -3560.6, 3198.6, -27.2, 19.0, 
3.2, -363.7, 52.9, 257.5, -150.4, 128.9, -159.8, -58.2, 1.2, 17.3, -15.3, 28.7, -376.5, -186.5, 121.6, -72.7, 
-1971.3, -21.1, -60.6, 3407.0, -171.8, 35.7, -15.5, 65.3, 173.8, -58.9, 2.5, 70.6, -48.5, -24.8, 306.4, 156.2, 
476.7, -327.6, -2828.6, -905.5, -580.4, -214.9, -1765.9, 76.6, -4029.4, -5.1, -172.3, -113.0, 51.4, -152.0, 15.0, -37.4, 
27.1, -56.2, 266.6, -408.0, 589.2, 298.9, 941.4, -136.0, 297.5, -16.5, 62.7, -49.7, 3.1, 97.1, -11428.2, 64.4, 
11.5, 64.0, 32.8, -114.3, 2.9, 10.0, -32.2, 117.6, -48.1, 68.9, 293.1, 14.3, -49.9, 2192.6, 578.3, -4411.8, 
-44.1, 134.5, -64.7, 55.5, -10.8, -3.7, -90.7, 3.1, -46.5, 92.6, 431.0, 139.3, -407.1, 15.0, -167.1, -108.2, 
28.8, -7.1, 121.0, -63.5, 79.6, -35.6, -14.0, 45.6, -201.3, 5649.4, -13.3, -12.9, 43.6, 26.2, 155.9, -306.9, 
-134.7, 22.8, 556.0, -21.0, 6.7, -62.4, -23.1, 790.1, 199.2, -93.1, 72.3, -203.9, -26.1, -374.6, -437.6, 219.8, 
-139.7, -9142.4, 30.3, -176.5, 119.9, -146.4, -595.0, -391.8, 2816.7, 122.3, 3753.5, -33.5, 242.4, 245.3, 233.1, -340.0, 
17.7, -215.5, 40.5, -58.3, 6.6, 29.7, -254.2, -2.6, 675.4, -347.6, 506.2, 227.3, -682.7, -375.4, 5715.8, 196.7, 
236.8, 214.0, 21.2, 229.6, -232.8, -41.2, -54.1, 2.8, -74.8, -148.1, -103.5, -55.2, 298.6, -263.6, 393.1, -462.4, 
-10807.7, 112.1, -283.5, 173.9, 368.5, 172.3, 46.9, 208.0, 51.4, 226.4, 72.3, 108.1, -76.5, 37.0, 543.5, -277.6, 
-291.0, -178.8, -246.0, 228.4, -58.2, -42.1, -36.1, -25.6, -78.7, 315.2, 193.4, 11.3, 47.5, 46.0, 44.7, 12181.0, 
-7.5, -10.0, -31.3, 106.0, 255.7, 78.9, 571.9, -518.5, -102.9, 20.3, -9260.7, 53.2, 55.9, 133.6, 125.5, 202.7, 
-66.6, -62.6, -7.3, 2.2, -0.6, 56.8, -6.7, -14.7, -340.4, -160.4, -419.5, -241.2, 5816.2, 60.8, -128.6, -76.2, 
350.0, 99.9, -81.6, 133.1, -103.3, -19.4, 56.0, -81.0, -87.3, -14.7, 276.2, 194.7, -148.2, 129.3, -495.4, -270.1, 

};

double tvqtab_cdmdct_2[] = {
16384.0, -534.0, 296.2, 242.6, -1011.7, -156.3, -25.8, -720.0, 135.3, -288.9, -197.1, 339.2, 12.6, 484.7, 68.3, 1615.2, 
-524.1, -7.6, -264.3, -165.0, 453.1, -8874.0, -37.8, 918.3, -257.6, 183.8, -144.9, 115.8, 63.6, 352.4, 137.9, 322.3, 
-630.2, -5343.0, 15.7, 337.7, -1005.3, 4231.3, -2785.4, 214.0, -3.1, 311.3, -296.8, 99.8, -496.3, 186.7, -33.9, -685.2, 
642.6, 633.4, 4888.4, 149.2, -252.5, -238.4, -191.4, 45.6, 154.2, -498.2, -4264.6, -1516.9, 985.7, -939.2, -419.5, 1279.1, 
581.1, -1809.0, -951.5, 1015.2, 239.0, -72.0, -104.5, 882.2, -73.4, 24.2, -187.9, 141.5, -9608.0, 337.9, 253.2, 433.7, 
-533.1, -1421.2, -2313.7, 877.7, -1429.2, 233.8, -356.3, -704.4, 218.4, -766.8, -226.7, -7255.4, -139.7, 229.3, -439.2, -523.0, 
230.3, -173.3, 1689.0, -806.6, 2720.0, -1824.9, -651.9, 677.9, -425.0, -7670.7, -637.7, 168.6, -751.9, -37.3, -471.9, 193.0, 
137.8, 293.0, 367.1, -910.5, -542.0, -4284.2, 5243.1, -45.2, 609.0, -135.9, -740.3, 2550.1, 3678.4, 1197.0, 774.5, -1783.1, 
355.6, -191.8, -292.4, -293.4, -196.9, 199.3, -2391.9, 429.2, 819.6, -838.5, -374.1, -704.7, -329.2, 310.2, 404.0, -204.9, 
94.1, 1035.5, -487.3, 1144.9, -0.1, -8832.0, 1367.5, 120.2, -1549.2, -274.8, -263.5, 590.7, 723.8, 420.4, -272.4, 346.6, 
-478.9, 3294.9, 1890.3, -1243.6, -200.1, 96.6, 232.9, -3382.5, 953.2, -1167.4, -113.3, -594.2, -9768.3, 80.5, -315.6, 12.5, 
281.2, -97.8, -37.7, 427.1, 310.7, -30.2, -90.6, 92.8, 909.2, -684.6, -954.4, -92.3, 141.0, 576.4, -24.4, 56.3, 
-1025.6, 115.2, -8990.2, 176.6, 144.3, 86.6, -190.4, -1808.1, -673.0, 452.2, -29.0, 3351.3, 152.2, 2705.2, 2093.3, -1395.5, 
27.3, -76.7, 835.9, -54.8, -363.6, 690.4, -316.8, -151.5, -539.3, 492.3, 2115.0, 777.4, -3297.1, -266.9, -272.8, -464.7, 
262.5, 0.4, 11.9, 441.1, -267.7, -33.5, 361.3, 4513.6, -476.3, 12.5, -138.8, -965.3, 2941.0, -760.6, -5805.6, 289.6, 
469.5, 1712.9, -169.3, 150.8, -1835.6, 734.9, 90.0, 551.8, -236.2, -323.6, -172.4, -5589.5, -2574.5, -1050.4, 1301.2, -3543.8, 
329.1, -598.6, -274.4, 1067.0, 973.2, 856.7, 549.2, -31.2, -82.9, -907.1, 671.3, -115.7, 2434.7, 2131.6, -931.5, -1369.2, 
-355.6, 242.4, -267.9, 182.5, 177.8, -134.0, 85.2, 806.1, 117.7, -121.4, -738.8, -6574.0, -813.8, -615.8, -632.4, 390.3, 
1416.5, -18.8, 247.7, 2109.5, -2071.1, -3397.0, 1029.1, 474.4, -52.4, 620.7, 63.1, 518.2, -206.5, 288.5, 1795.3, -2903.0, 
-2856.7, 1327.6, 260.8, 496.6, 695.4, -1262.8, 409.0, -521.2, -2073.0, 1709.0, 1929.4, 69.5, -1172.1, -1298.6, 3453.2, -77.8, 
-1448.3, 1117.8, 1309.2, 3500.7, -3781.1, 337.1, 350.8, 620.7, -166.5, 507.2, -305.0, -15.5, -51.0, -343.1, 310.0, 21.2, 
1445.3, 1738.2, -576.0, 1721.7, -32.2, -54.2, -1286.9, 76.5, -1713.8, -455.4, 3055.5, 1436.6, 345.3, -55.0, 94.7, -580.7, 
-39.9, 1640.6, 2128.0, 625.4, -2599.5, -178.5, -715.7, -315.2, -671.3, -1472.1, 4815.1, -753.8, 83.8, 317.6, 136.0, 559.3, 
-192.3, 690.0, -2273.6, -2537.7, 1253.0, -3324.6, 591.0, -267.2, -299.1, -485.2, -423.5, -38.2, 674.1, -2357.8, 1102.6, -3306.7, 
-757.9, -302.3, 564.8, 2143.9, -754.7, 2681.0, 611.6, -525.9, -124.6, -189.3, 111.3, 427.3, -505.8, -420.1, 127.8, -364.7, 
-7157.5, -47.4, 226.7, -380.5, 195.8, -1269.0, -18.3, -204.7, -492.2, -4261.3, 1940.7, 1797.6, 341.4, 601.3, 611.3, 27.5, 
252.7, 151.2, 390.8, -54.1, -1216.6, 2894.2, -3176.0, -1731.3, -1433.6, -12834.3, -93.1, -374.5, 287.0, -1899.4, 35.7, -715.3, 
-307.9, 10.6, 78.9, 1096.8, 34.3, 103.6, 2076.4, 615.2, 1465.3, 758.0, 1855.5, 683.3, -272.6, -279.2, 818.5, -796.5, 
85.7, 57.3, 161.8, -7.5, 271.7, -197.5, -6743.0, 2581.4, -1422.1, 175.0, -1154.1, -129.1, -379.4, -4225.6, -2308.9, 247.6, 
246.7, -478.2, 234.3, 327.2, -193.4, -380.8, 165.5, -322.4, -1003.3, -706.7, 135.4, 2359.3, -8970.6, 625.4, 316.8, -108.1, 
625.2, 1014.1, 934.6, -815.1, -137.6, -365.9, -392.8, -204.2, -130.7, -195.9, 1439.7, 3056.3, 603.4, -90.0, 1303.7, -1332.6, 
167.8, -600.4, 2072.0, -1718.3, 213.6, 125.0, -37.1, 21.4, 106.7, -3498.4, 2942.1, -421.4, 1483.0, 5828.9, 478.7, 7218.4, 
129.5, 141.4, 732.8, 36.2, 296.8, -233.7, 72.8, 121.4, -214.2, -431.6, 2.4, 741.3, 1486.1, 1177.2, 1714.4, -4432.8, 
-852.9, -2584.9, -89.8, -780.6, -722.0, -88.5, -1466.4, 32.9, 161.5, -65.6, -642.8, 207.1, 735.6, -5723.4, -841.8, -361.4, 

};

double tvqtab_cdmdct_3[] = {
210.8, -13952.3, -184.9, -354.0, 562.2, 506.7, -239.0, -758.3, -199.4, 205.1, 32.8, -1105.2, -674.6, 577.5, -224.6, -325.9, 
-1149.9, -413.1, 83.5, -336.7, -1688.0, -1187.9, -3898.7, -171.5, 897.3, -485.8, 695.3, 643.6, -319.2, 221.8, -3611.9, 3212.0, 
-1658.3, -2700.4, -331.7, 418.3, -46.9, 126.0, 865.1, 463.8, -6325.3, 271.8, 176.6, -314.8, -18.7, -555.5, 795.3, -474.9, 
628.7, -2206.3, 55.7, -4269.0, -392.4, 3219.7, -539.8, 14.4, -774.7, -262.6, -302.9, 46.9, 70.7, -63.6, 120.8, 59.4, 
811.7, 4138.9, -9.2, 112.3, 767.6, -710.4, -7343.7, 108.3, 660.1, -256.2, -137.4, -77.8, -77.4, 276.4, -25.0, 325.9, 
46.3, -578.7, 2070.7, 1799.3, 1214.2, -141.8, 3251.9, -1072.7, 343.9, -593.7, -29.0, 191.1, 1221.3, -369.9, -22.8, -530.7, 
1110.2, -1079.3, -47.4, -3613.6, -3544.2, 1237.2, -241.0, 877.9, -36.2, 125.9, 253.3, 8498.6, -447.2, -525.9, 685.6, 502.4, 
-196.4, 1546.3, 755.3, 382.0, 305.2, -797.4, -1413.0, 849.4, -216.3, 375.9, -12034.9, -438.0, -444.1, 250.6, 80.4, 1147.9, 
193.8, 413.3, 66.6, -56.1, 1401.0, -1495.1, -445.3, -475.5, 3884.2, 4137.2, 298.4, 3.6, 326.0, 225.8, 367.8, -384.3, 
147.0, -7.4, 358.0, -281.7, 447.3, 423.2, 1928.4, -3456.7, -2995.4, 482.0, 292.9, -1031.8, 47.7, -3246.4, 248.2, 666.6, 
-548.3, -470.8, 430.4, -840.3, -332.0, 156.3, -5991.7, -387.9, -641.7, -316.6, -231.9, -198.8, -307.8, 452.8, 12.6, -418.5, 
88.7, -41.0, 358.8, -388.4, -428.7, 4450.3, 384.5, 737.2, -4.5, 4933.9, 1082.1, 5421.3, 346.1, 127.0, 3133.9, -586.4, 
76.3, 585.8, -319.0, 147.0, -67.0, -700.3, 206.2, 93.4, -4386.2, 443.2, 682.7, 2974.0, -303.0, -58.5, -133.6, 609.8, 
-339.1, -79.9, 112.4, 577.4, 3997.3, -635.8, 275.0, -193.2, 573.9, 1187.4, 1662.3, 1321.8, 527.8, 102.2, -1280.8, -539.2, 
-4552.8, -744.6, 694.4, -49.0, 94.7, -22.0, -5.5, -577.7, -254.2, 114.7, -531.6, -3841.1, 900.7, 3404.9, -573.8, 117.5, 
-2.0, 259.8, -324.1, -48.6, -1858.6, -3521.6, 94.6, -161.4, 908.1, -404.0, -416.5, 361.2, -792.0, -303.6, -1569.0, 128.5, 
-2026.6, 78.6, -476.9, -975.5, -358.2, -1236.6, 3351.7, -75.0, 44.7, 636.2, 67.4, 6.3, 2449.2, -374.2, -126.5, -3959.9, 
-30.5, -640.4, 1339.6, 1507.5, -493.6, -403.1, 22.8, -368.6, -1413.1, -2039.5, -1884.3, -1548.5, -654.6, 2228.7, 545.6, 1654.6, 
-4512.5, -9067.5, -617.7, -460.9, 264.7, 1549.6, 54.8, -82.9, 204.5, 22.0, 90.4, 120.8, 421.4, -36.4, -445.4, 524.9, 
811.8, 1014.5, 6359.0, -1291.6, -175.5, -279.3, 1966.0, 183.8, -1376.2, -322.4, 91.9, 124.1, 987.5, -377.8, 466.0, 2217.7, 
-1671.1, -1155.7, -88.9, -108.4, -170.5, -2132.2, 3481.2, -207.9, 1148.2, -640.2, 202.6, 191.0, 324.0, 103.3, -949.2, 3242.5, 
-123.1, 129.5, -2247.7, 125.2, 18.2, -309.1, -693.2, -63.8, 5058.6, 1085.2, 1284.9, -674.8, 395.6, 253.9, -412.8, -290.1, 
37.7, -810.0, 1208.4, -624.7, -8533.2, 66.8, 103.7, 136.0, 296.5, 275.6, 86.2, -373.8, -81.1, 5.0, -404.3, 6575.4, 
-38.4, 417.6, 183.3, 1674.7, -342.1, 1390.6, 97.2, -6.6, 764.7, 417.9, 339.4, -160.5, -22.0, -560.2, 16.2, 4354.3, 
-714.5, -186.2, -792.8, 5761.3, -2868.7, 426.0, 264.2, -267.9, -69.1, 165.6, -718.6, -826.1, 2625.5, 3479.2, 511.1, 528.3, 
172.0, 259.7, -380.7, 507.4, 278.7, 803.8, 373.8, 870.7, 598.0, -1202.7, 5005.8, -1061.1, 1246.4, 27.8, -6.3, 358.0, 
-147.8, -604.8, -50.5, -175.6, -131.6, -2995.7, -1675.1, -1108.7, 1871.5, -2505.2, -282.2, 145.1, 399.2, 1227.1, -1103.3, 1568.9, 
-203.0, -65.6, 104.0, 427.1, -180.8, 102.3, -109.7, -2583.3, 1662.1, 1983.7, 60.0, 3970.3, 4094.5, 844.5, -1026.5, 114.6, 
-830.2, -38.5, 568.2, -555.8, -49.7, 242.7, 853.8, -1240.9, 151.6, 418.9, 485.3, 58.5, 56.9, 156.0, 37.8, -305.9, 
-437.6, 548.6, 651.9, -6621.1, 284.5, -295.6, -333.5, 1616.7, 1988.0, 1497.3, -51.3, 2570.1, -275.8, 8445.6, -1183.1, 849.5, 
-337.1, 48.2, -161.5, -270.5, 431.1, 24.4, 507.4, 17.2, -571.8, 580.6, -2151.6, 674.3, -1505.0, -43.4, -348.7, 2831.3, 
459.9, -784.6, 1878.2, -188.4, -91.6, -819.7, 1119.6, 344.8, 709.9, 160.9, 1134.7, -777.8, -431.3, 63.0, 120.6, -343.5, 
15.8, -248.1, 143.5, 528.9, 761.2, -6620.7, 476.2, -192.8, 669.9, 546.6, 467.6, -65.3, 2492.2, 916.1, -781.6, 1232.8, 
-125.6, -52.2, -361.1, 669.9, -600.5, 359.3, 125.0, -195.9, -437.1, -282.8, 216.6, 6506.1, 1893.6, -117.7, -55.5, 7375.8, 

};

double tvqtab_fcdl[] = {
2.59553, 1.59708, -0.21402, -0.17514, -0.09628, -0.26982, -0.31846, -0.28922, -0.32107, 1.15714, 1.03967, -0.03709, 2.80202, -0.48079, 2.15678, -0.37126, 
-0.36071, -0.16559, 0.19375, -0.32843, -0.30811, 0.27793, -0.21060, -0.07445, 2.20740, -0.43946, -0.33630, 1.40869, 0.01180, 0.04888, -0.50163, -0.30720, 
-0.34648, -0.36553, 0.08881, 0.66861, -0.54780, 3.10285, 2.92300, -0.42525, -0.30431, -0.12124, 0.36265, -0.59101, -0.40694, -0.37653, -0.02823, 8.00000, 
0.61080, -0.29440, 0.84234, 0.50441, 0.15898, -0.19708, -0.26828, -0.42775, -0.55847, 8.00000, 0.26906, 0.09807, 0.58163, 0.69724, -0.38205, -0.32305, 
-0.04204, -0.18015, -0.15310, -0.52465, -0.51120, -0.46322, 8.00000, 0.60858, 8.00000, -0.37894, -0.41379, -0.57177, -0.46141, -0.54807, -0.34090, -0.46601, 
-0.40139, 2.77429, -0.30628, -0.29932, -0.00875, 1.00366, 0.35027, -0.14719, -0.12343, -0.01017, -0.42826, -0.25287, 0.58890, 0.00455, -0.18978, 0.72595, 
-0.41718, -0.42836, 0.44293, -0.26096, 0.67149, -0.15131, -0.48094, 0.40551, 0.63479, 0.10576, 0.60523, 0.00965, 0.58750, 0.17574, 0.22913, -0.07386, 
-0.25141, -0.28609, 1.54175, -0.38932, -0.26886, -0.37004, 1.26474, -0.04734, -0.30997, -0.45256, 2.71793, -0.29703, -0.34868, -0.27166, 0.80891, -0.39427, 
-0.36544, 1.05681, -0.26354, -0.07337, 1.69802, 0.38677, -0.19213, 0.04237, -0.07601, -0.16281, 0.82683, 0.70298, 1.21216, -0.23461, -0.02006, -0.24785, 
-0.44380, -0.46604, -0.44381, -0.40097, 1.97582, 0.05232, 0.71883, 0.61561, -0.18440, 0.68805, 0.00106, -0.01607, -0.38766, 8.00000, -0.06823, -0.22391, 
-0.52152, -0.42881, -0.48120, -0.45930, -0.46120, 1.54307, -0.31462, 0.33229, 0.72907, -0.31141, -0.38468, -0.36775, -0.35870, 0.70000, 0.88654, 2.10076, 
-0.19640, -0.23175, -0.15172, -0.15909, -0.51999, -0.53691, -0.52863, -0.47530, 0.54786, -0.32601, -0.47710, 2.06467, 1.01919, -0.28684, -0.14439, -0.05744, 
-0.57224, 0.42109, 0.52420, -0.28560, -0.18840, -0.15752, -0.24585, -0.44169, 8.00000, -0.43055, -0.40749, -0.43133, 0.20221, -0.25994, -0.31787, -0.30064, 
0.67370, 0.05431, 0.32692, -0.42540, -0.45128, -0.45458, -0.16592, -0.37830, 1.42145, -0.42477, -0.43237, -0.33452, -0.32365, -0.35176, -0.52165, -0.47377, 
0.32662, -0.34749, -0.24129, -0.18172, -0.46545, 0.29674, -0.31146, 0.41441, -0.12466, -0.07952, -0.26585, 0.07241, -0.26056, -0.29530, -0.24943, -0.22879, 
0.34838, -0.37770, 0.48323, -0.31334, -0.09970, -0.15367, -0.36403, -0.40947, 1.43126, -0.48284, -0.33652, 0.15962, -0.50425, -0.42948, -0.31036, 0.28637, 
0.32368, 0.02942, -0.44723, 2.90793, -0.35379, -0.37063, -0.16951, -0.00506, -0.41686, -0.31531, 0.32330, 0.63998, -0.13565, -0.25397, -0.57783, -0.55613, 
-0.52567, -0.35549, -0.35857, 0.13331, -0.52690, 2.92107, -0.39287, 2.50676, 0.83325, -0.34838, -0.35037, 1.58353, -0.14216, -0.14513, 1.25833, 0.02395, 
-0.54618, -0.51853, -0.52250, 0.69150, -0.34809, -0.32408, 0.91424, -0.39755, -0.23708, 0.06298, 0.32884, -0.27221, -0.26031, -0.34193, 1.87043, -0.21861, 
1.45874, -0.01490, 2.71047, -0.44695, -0.35421, -0.35093, -0.21284, 0.18185, -0.54924, -0.36134, 2.97081, 2.32648, 0.01315, 0.14583, -0.51477, -0.40314, 
1.23469, 0.20710, 0.00622, -0.15786, -0.37564, 0.82963, 0.77552, 0.72145, -0.21951, -0.21676, 1.59584, -0.35791, 0.89497, -0.26614, -0.12674, -0.13373, 
-0.42762, 1.49492, -0.31584, 0.65560, -0.06384, -0.07354, -0.38684, 0.71379, -0.43055, -0.24995, -0.29525, 0.42418, -0.55264, -0.52329, -0.57869, -0.60007, 
-0.61091, -0.56922, -0.46465, 0.55867, -0.28994, -0.14188, 0.53955, -0.11240, -0.40785, -0.46448, 1.26074, 1.48856, 0.10128, -0.10592, -0.42700, 0.70964, 
-0.30237, 1.50654, 0.06170, -0.27741, -0.43966, 1.39518, -0.39417, -0.44686, -0.35716, -0.39151, -0.43383, 0.96260, 1.83882, -0.37505, -0.23500, -0.05237, 

};

double tvqtab_pcdl[] = {
1.28888, 0.26874, 3.16758, 1.37315, 0.49535, 0.94071, 1.44487, 0.37004, -0.70932, -0.05462, -0.02234, -0.20001, 0.19604, 0.26626, 0.75466, -0.81913, 
0.03708, -0.29647, -1.78632, -0.18008, -2.19075, 0.13333, 2.93822, -0.22869, 0.54111, 0.51598, 0.29629, -1.60571, 0.48978, -0.40555, -0.16435, -1.43562, 
0.12102, 0.11090, 0.83013, 0.16508, -0.07873, 2.78031, 0.15479, -0.28546, 3.06554, -1.41708, -1.88582, 0.14353, -1.66046, 0.26375, 0.08646, -0.41044, 
-0.23005, 0.47026, -0.11899, -0.14149, 0.03797, 0.01927, 3.72378, 0.16278, 0.28207, 0.15989, -0.17563, 0.48802, -0.19166, 0.05232, 0.68887, 0.24894, 
-0.48014, 0.01794, -0.09456, -0.03353, -3.71716, -0.37879, -0.08722, 0.69099, 0.52234, 0.74945, -0.62316, 0.58827, 0.30028, 1.00850, 0.24395, 0.06055, 
0.12958, -0.22199, 0.96387, 3.13907, -1.96687, 0.53834, -0.69258, -0.04179, -0.39869, -0.03142, -0.02278, 0.45226, -0.46875, 0.03839, 2.35515, -0.02039, 
-0.03662, -0.33315, -0.37160, -3.22201, 1.50588, -0.78015, 1.43802, -0.42078, -1.56427, -0.32711, -1.81516, -0.15170, -1.39942, -0.70676, 0.03549, 0.97029, 
0.17778, 2.40233, -0.12070, 1.79612, -0.09612, -3.32378, -0.06238, -0.47122, 0.11414, -0.06499, 1.95345, -0.03737, -0.08911, 1.86812, 0.03298, 0.34190, 
-0.94450, 0.26631, -1.20479, -0.70412, 0.30736, 1.66473, 0.25032, -1.62769, 0.26336, -2.39109, 1.66663, -1.01706, 0.27057, 0.28062, 4.60481, 0.14478, 
-0.04332, -0.26043, -0.15716, -0.52842, 1.15402, 0.02068, -0.02468, -2.63793, -0.06035, 2.17716, 0.55198, 1.33668, 0.18469, 0.73687, -1.59535, 0.47395, 
0.08763, -1.03259, 0.29432, 0.23395, -0.21428, 0.13532, -4.58495, 0.55890, 1.19783, -1.80950, -1.87625, 1.93644, 0.23550, 0.60058, 1.07984, -0.13744, 
-0.89547, -0.85010, 0.80741, -0.42413, 0.23718, -1.82628, 2.62266, 0.48302, 0.57730, 0.00497, -0.88499, 0.11386, 0.50195, -1.61181, 2.29405, 0.76792, 
0.77194, 0.45336, -0.15374, -1.68579, 0.40538, -0.73821, -0.52721, 0.27069, 0.31311, 0.67546, 0.05131, -0.53788, 0.75649, -1.92602, 0.44063, -3.20197, 
0.24121, -1.52231, 0.38234, -0.34155, -2.34677, 0.44454, -0.12667, -0.01386, 0.83684, -3.42385, 0.27861, -0.62057, -2.29400, -0.00411, 0.10751, -2.09740, 
0.55445, -1.90704, 0.46176, -0.22817, -1.05712, -0.31803, 0.08838, 0.10400, 0.07782, 0.28709, 0.77533, 0.53770, -3.49315, -0.15122, -0.71822, -0.55433, 
-0.12964, -0.15924, 0.08426, 4.31671, 0.35474, -0.38120, 0.08329, -0.50720, 0.22773, 0.10575, 0.37323, 0.11307, -0.26726, 1.19933, -0.20520, 3.97109, 
0.23754, 0.42287, -0.17526, 1.63630, -0.89320, 0.98569, -0.17186, -0.66099, 0.34743, 0.31512, 0.56153, 0.03641, -0.22790, -0.32669, 0.49296, 1.50705, 
0.11747, 3.64671, -0.08886, 0.95113, -0.10827, 0.24228, -0.21880, 0.09239, -0.05516, -0.36735, 0.06542, -0.10454, -0.64008, -0.07052, -0.50515, 2.55652, 
-0.94717, -1.30125, 0.09405, 0.74533, -1.13331, 0.37229, -0.38024, 0.17472, 0.61134, 0.20712, -0.10988, -0.49257, -0.11187, -0.17222, -1.73824, -0.13261, 
-0.52195, 0.62213, -0.08559, 0.17988, 3.15089, -0.24704, 0.01548, 3.74936, 0.08098, -0.20425, -0.05489, -0.31726, 0.69418, 0.32569, -0.16340, 0.50865, 
-0.17257, 0.28592, 2.00649, 0.53473, 2.57991, 0.33445, -0.33589, -0.71256, 0.51466, 2.46521, -0.09483, 1.08439, 0.03998, 0.11961, 1.85047, 0.00631, 
-0.45111, -0.71269, 0.15621, 1.16161, -0.02632, 2.00056, -0.32356, -0.56487, 0.10923, 1.26427, -0.26740, 2.41749, -0.16922, -0.88480, -0.05440, 0.16837, 
2.56225, 0.18940, -0.22447, -0.39572, 0.49943, 0.11457, 0.35493, 0.89878, -0.26616, -0.43364, 0.35580, 0.05177, 0.50149, -0.24278, 0.17047, -0.12116, 
5.45574, -0.15218, 0.06203, 0.23433, -0.99429, 0.12958, -0.62800, -3.51385, -0.24958, 0.06293, -0.89521, 0.24260, 3.72107, 1.23981, -0.88335, 0.46989, 
-0.30010, -0.42813, 0.41867, 1.06390, 0.31391, -0.57627, -1.12063, 0.44526, 1.91996, 0.34752, -0.52400, -0.67460, -2.59639, 0.11581, -0.20243, 0.28307, 
-0.03832, -0.01316, -0.03846, -0.00700, 0.04931, -0.09357, 0.06964, -0.00049, 0.21041, -0.08892, 0.10125, -0.03012, -0.03539, -2.37631, 0.28491, 2.48990, 
-0.34378, -0.73052, 0.52019, -0.10068, 1.15802, 0.73050, 0.86786, -0.15069, 2.34520, -0.69111, 0.57534, 1.29397, 0.15267, -0.16541, -0.12218, -0.03125, 
-0.01363, -1.54460, -0.27404, -0.62664, 0.46486, -0.44052, 0.17302, 0.77978, -0.03625, -0.33463, -1.59515, -0.42669, -0.36370, 3.45674, 0.35785, 0.34057, 
0.26874, -0.66518, 0.12284, 0.01668, -0.36273, 0.00005, 0.05147, -0.29728, -0.00085, 5.10734, 0.41718, -0.05075, -0.20474, 1.11663, -1.48530, -1.60090, 
-0.02503, -0.24016, -0.09167, 2.05302, 0.41858, -0.52989, -1.22133, -0.80464, 3.29150, 0.29576, -1.01545, 0.85362, 0.25387, 1.69078, 0.05201, -0.34140, 
0.10775, -0.30053, -0.19873, 0.20553, 0.38424, 0.27950, 0.33175, 0.10667, -0.43378, 5.02110, 0.06324, -1.11640, -0.34474, -0.03852, 2.47664, 0.30992, 
0.34303, -3.08380, -0.26944, -0.15003, -3.87998, 0.08673, -0.92651, -0.28277, 0.79120, 0.06152, 0.05675, -0.04378, -0.15055, -0.49744, 0.06965, -0.24747, 
-0.30479, 0.44796, -0.38039, 0.30899, -2.49186, 0.15352, -0.07609, 2.77728, 0.03771, -0.07037, 1.44405, -0.08627, 0.01465, 0.65797, -0.20831, -0.02516, 
3.82295, 0.58679, -0.28911, 0.00076, 2.25478, -2.67418, 1.08246, 0.20249, 0.62566, -0.04001, -0.20703, -0.15767, 1.76926, 0.21839, 0.42140, -0.18353, 
-0.23904, 0.25714, -0.23697, 0.07767, 0.53228, 0.22643, 0.19622, -0.06400, 0.10897, 0.79608, -1.20257, -1.10434, 0.30441, 0.49781, 3.11769, -0.29082, 
-0.31973, -1.36087, 1.16280, 0.16043, -1.01046, 2.64181, -0.19644, -0.27073, -0.77847, -0.42009, 0.04065, -2.44680, -0.45823, 0.51819, 0.08004, -1.72072, 
-0.52000, 0.59359, 0.37168, 0.78352, -2.06255, 0.44180, -1.32138, 2.39634, -0.89775, 1.60514, -1.52266, -0.22682, -0.10606, -0.57980, -3.31681, 0.85384, 
-0.27833, 0.29965, -1.55139, -0.12387, 0.08035, -0.41261, 0.26349, -0.21486, -0.91388, -0.98165, -1.13409, -1.47777, 0.23383, 1.12170, -0.27391, -2.83883, 
0.37536, -0.83449, -0.30317, 0.03241, -2.27905, 0.39328, -0.10539, 2.62031, -0.21607, -0.11414, -3.28750, 0.16852, 0.05213, 2.18937, 0.84015, 1.33077, 
-0.05358, 1.34090, -0.09204, 0.09985, 0.93062, 0.59825, 0.12392, 1.59708, 0.93370, -0.90451, -0.12543, -2.01707, 0.37513, 1.94555, 0.23099, -0.70055, 
2.13905, 0.10191, 1.24373, 0.51358, 1.63431, -0.08351, 0.30739, -1.16675, -0.35279, -0.37096, 0.08120, 1.07058, 0.15907, -0.09428, -0.14151, -0.46180, 
-0.21325, 0.45456, 0.66027, 3.37816, -1.32206, -0.48210, 1.43573, 1.74563, 2.01948, -1.56545, 0.17182, 0.45271, 0.06280, -0.91456, -2.38980, -2.35197, 
-0.22554, 0.33998, -0.79031, 0.06321, -0.01377, 1.07176, 1.19673, 0.28610, 1.24864, -0.63868, -1.07630, -0.28812, 1.14537, 1.80661, -0.15262, 2.16631, 
1.67133, -0.29882, -0.05193, -1.29291, -0.85556, -0.03597, 4.35258, -0.32884, 0.79375, 0.41554, 0.35156, -0.57719, -0.11980, -0.05545, 0.43083, -0.10895, 
-2.37948, -0.49303, 2.75568, -0.04768, -2.33369, -0.07613, 0.21686, 1.41341, -0.42804, -2.70242, 0.61944, -0.06463, -0.43017, -0.19030, -2.07550, -0.07512, 
-0.02184, 0.48180, 0.88869, 4.23426, 0.32367, -0.16813, -0.09710, -0.93254, 0.52898, 0.05603, -0.15532, 0.52294, -1.60824, -0.18328, 3.23327, 0.11350, 
-1.45172, -0.04930, -0.23632, -0.25873, -0.05867, -2.59416, 0.83120, 0.31796, -0.30826, 0.23730, 2.77116, 0.02446, 0.55313, -0.22707, -0.51455, 1.30626, 
-0.77779, 2.71737, 0.50610, -1.37105, 0.15878, 0.48821, 0.25587, 1.37404, -0.12972, 0.16455, 2.06360, 0.25143, 0.28128, 2.95291, 0.08582, 0.09976, 
-0.25123, -0.30165, -0.04632, -1.39750, -0.14369, 0.86661, 0.47791, -3.43773, -0.08283, 0.40818, -0.40507, 1.10291, -0.01820, -0.15582, 1.34311, 0.06751, 
-0.14121, -0.53351, 0.03831, 0.50430, 2.10788, -0.58678, 0.39477, -3.04864, -0.45931, 2.01978, 0.04376, -0.52536, -0.31599, -0.12492, -0.10121, 0.11121, 
-0.03452, -0.03057, -0.09894, 0.03226, 0.01192, -0.48283, -4.65939, -0.11003, -0.36130, 0.07900, -1.31754, 0.05740, -0.29710, 0.08453, -0.30721, 0.86434, 
2.45968, 2.51238, 1.23547, -0.50231, 1.50294, -0.24216, 2.28121, -0.90775, 1.04895, 0.21859, -2.06629, 0.08329, 0.34822, 0.15810, 0.36466, 0.70677, 
-0.91800, 2.47546, 3.79165, -0.24031, -0.37853, -0.32197, -0.37636, -0.02901, -0.12627, -0.04525, -0.82218, -2.26543, -0.84347, -1.03939, 0.26653, -2.47079, 
1.23837, 0.75649, 0.24064, -0.62543, -2.94637, 0.47164, 1.58428, 0.23203, -0.59003, 0.33250, -0.13853, 0.14422, -0.17463, -0.12583, 0.85598, -0.17722, 
1.54264, 0.05216, -0.08885, 0.88151, 0.46255, -0.48946, -0.06676, 0.36942, 0.58086, 0.11589, -1.18536, -0.12857, -2.80603, 0.00658, 1.06034, -0.58457, 
-0.15610, -0.18171, -0.63499, 2.66530, 0.46641, 0.59787, 0.30223, -0.53096, 1.29943, -0.98973, -0.00976, 1.04356, 0.16697, 1.99034, 0.23572, 2.65679, 
-0.00325, 1.03831, -0.07010, -0.77931, 0.13381, 0.49307, 0.04619, -1.68299, 0.19455, 0.52731, 0.14125, 0.99717, 0.43132, -0.97925, -0.15630, 1.87910, 
0.19313, 0.23078, 0.30029, 1.58470, 0.36806, -0.91846, -0.10561, 2.76858, -0.03141, -0.27603, -1.25022, 0.76867, 0.37696, -1.86725, 0.45545, 2.35843, 
0.57733, -0.51505, 0.19081, -0.02002, 0.89507, -0.17124, 0.07392, 0.07283, -0.47206, -0.03043, -0.34827, -4.29424, -0.29000, 0.04272, -1.72027, -0.11905, 
0.27361, -1.60983, 0.11950, -0.37867, 3.50315, 0.36605, -0.13280, 4.18273, 0.04841, 0.61437, 0.60526, -0.23885, -0.05236, -0.82974, -0.29851, 0.51121, 
0.03186, -0.24892, 0.25614, -0.17325, 3.12521, -0.12148, 0.07243, -0.33320, -0.04557, -0.77374, -0.02997, 2.20189, 0.23390, 0.05403, 3.47503, -0.14415, 
0.23471, 0.75477, 0.00188, 0.06228, -1.11961, 0.43678, 0.61581, -3.07064, -0.02222, -0.20063, -0.19664, -0.17430, 1.29354, 0.31722, 0.80714, -0.31437, 
3.21672, 0.05728, 0.42811, -0.01624, 0.46690, -0.14758, 0.79094, -0.49991, -0.04883, 0.18854, -0.04220, -0.24325, 0.33396, 0.58096, 0.07173, 0.18625, 
4.80098, -0.04774, 0.12902, 0.04455, -0.58451, 0.22529, 0.18288, -3.31484, 0.20874, 0.14390, -2.33226, -0.00004, 1.40060, 2.53879, 2.23308, -0.40397, 
-0.91191, 0.30424, -0.59309, -0.28013, -0.53681, -0.72096, 0.14981, -0.34273, -0.10960, -2.08103, -0.55452, 1.22105, -2.32346, 0.71767, -0.04973, 0.88489, 
-0.06296, 0.00779, 0.37141, -0.07311, -0.43599, -0.69232, 0.37183, 0.59265, -0.20391, 0.76627, -0.04811, 0.81816, -0.06811, -3.60488, -0.30926, 1.26190, 
-0.25378, -2.67757, 0.01421, 0.15661, -0.18735, -0.29123, -0.14430, -0.17479, -0.20360, 1.97977, -0.22341, -0.17369, -2.54577, -0.41017, -0.15575, 0.64521, 
-0.20741, -0.06303, 2.55173, 0.08849, -1.31680, -0.08520, -3.59554, -0.16002, 0.25380, 0.42032, -2.50621, 0.13451, -0.06898, 2.41402, 0.09969, -0.09772, 
1.45985, 0.45849, 0.19057, -0.22542, -0.16274, -0.19255, -0.08500, 0.15240, -0.06344, 3.54373, -0.19634, 0.42005, -0.00046, 1.30750, 0.44001, 0.29739, 
0.12153, 0.45681, -0.24122, 3.97823, 1.01631, -0.57180, -1.04740, 0.76204, 0.79817, 0.02734, -0.85256, 0.27437, -0.36512, 0.45476, -0.34809, -0.26607, 
0.39011, -0.04813, 0.28325, -0.40521, -0.26705, 0.11646, -1.00205, -0.09658, 0.39184, 6.38045, 0.18221, -3.14360, 0.56642, -0.41265, 2.10605, 0.00959, 
0.32737, -0.30618, -0.46143, 0.62372, -3.41695, -0.29748, 0.93423, 0.29680, -0.22186, -0.04393, 0.41990, -0.02121, -0.03490, 0.24145, 0.08292, -0.34821, 
-0.98374, 0.76693, -2.30082, 0.11379, -2.00866, 0.10299, -1.80156, 0.49759, 0.09801, 0.02398, 0.87932, -0.29853, -0.23085, 0.60271, 0.28300, 0.17743, 
-0.06550, 0.11407, 0.04950, -2.70490, 0.93988, -0.84697, -0.47967, -0.45333, -0.34552, -0.60481, 0.77467, 1.79495, 2.31525, -1.35283, 1.51663, 0.46045, 
-0.94423, 0.66598, 0.14087, -1.23472, 0.07825, 0.23723, -0.01891, 0.01146, 0.05543, -0.00939, -0.25309, -0.05408, -0.08464, -0.08331, 0.28796, -0.23134, 
0.14456, -1.82728, 0.54162, -1.45394, 0.65876, 2.88044, 0.04801, 1.52839, 0.41770, 0.24366, 0.00192, -1.51934, -0.28914, 0.27953, -0.43474, 0.33590, 
0.34038, 0.09476, -0.16812, 0.55648, 1.58963, 0.62054, -1.19708, 0.95618, -0.19293, 0.13055, -0.46467, -1.08598, 1.02940, -0.00537, -1.63945, 1.27057, 
1.17362, 0.77949, -0.25979, 1.31919, 1.09939, -0.59425, -1.04889, 0.33754, -0.36973, -1.00160, 0.18249, 0.95907, 0.72926, 2.32241, 0.60848, -2.12186, 
-0.24255, -0.65101, -0.00988, -0.04139, -0.76083, 0.14922, 0.57784, 3.97886, -0.30668, -0.34279, -0.84522, 0.11366, -0.12785, 1.33400, 0.11998, 0.17243, 
-1.82888, 0.49492, 0.09101, -0.99747, 0.39561, -1.90151, 0.17180, 1.22115, 0.41649, 2.03242, -0.20785, -2.41295, -0.75000, 1.09243, 0.65831, -2.08726, 

};

double tvqtab_scmdct_0[] = {
128.3, -932.2, -269.6, -417.6, -94.2, 340.3, -83.8, -8130.1, 144.4, 249.0, 156.5, -315.9, -95.4, 404.7, -662.3, -283.8, 
94.0, 208.8, -97.2, -56.2, 97.9, 396.1, 182.0, -135.0, -38.2, 306.2, 91.3, 106.5, 201.2, -4276.0, 1196.9, 392.1, 
-5216.8, 598.6, 376.6, 131.8, 56.3, -2237.0, 894.1, -832.2, -256.5, -506.3, 481.2, 321.3, 393.9, -91.1, 103.8, 452.0, 
170.5, 235.3, 269.0, 459.0, 166.1, -664.0, -17.3, 339.0, 2617.0, 85.4, -167.7, -1804.1, 4414.1, 498.8, 1432.6, -1359.2, 
632.5, -4937.2, -415.2, 174.3, -1008.8, 300.0, 112.1, 70.0, 158.0, -152.1, 275.7, -391.9, 50.5, 136.0, -80.0, -413.4, 
9.0, 468.8, 46.9, 325.5, 301.2, 137.9, -1784.8, 45.9, -823.1, 4.9, 144.8, 154.0, 322.9, 156.4, 51.7, -162.2, 
275.2, 319.9, -146.4, -2.5, 221.7, 35.6, -16.2, 688.0, 148.6, 348.9, 8192.0, -112.7, -629.1, 218.2, 373.9, 72.8, 
-3885.1, -446.4, -519.5, 566.8, 662.8, -1059.8, 5754.8, 251.3, -416.1, -798.9, -728.2, 697.9, -679.3, -473.4, -192.3, -159.6, 
-119.9, -81.8, -66.8, -37.8, -143.7, -33.9, -20.0, 40.0, -93.6, -47.5, -192.2, -117.1, 754.0, 275.7, -345.7, 129.0, 
259.6, -803.1, -85.8, 374.0, -198.4, 323.5, 470.0, 1314.9, 956.8, -319.2, -30.2, 1585.1, -12.5, -123.9, -8192.0, -343.6, 
-109.5, -101.9, 130.0, -686.1, 384.0, -180.1, -413.2, -23.9, 2396.1, 355.6, -207.3, 1833.8, -10.6, -1321.6, 7373.0, -158.0, 
144.5, -284.1, 93.2, -317.0, -545.6, -237.8, -271.6, -132.6, 91.9, -17.1, -94.0, 374.0, 460.8, -193.5, -409.3, 92.1, 
-235.6, 88.2, 96.8, -121.1, -651.8, -2127.6, 655.4, 7212.4, -323.1, -477.9, 1955.8, 303.2, -420.9, 1250.9, -27.1, -552.6, 
59.2, -45.7, 71.2, -178.6, 107.9, -89.2, 88.7, -236.6, -200.7, 253.5, -280.3, 265.6, -188.0, -223.3, -172.2, 338.6, 
-353.3, -490.6, 53.3, 1929.3, -386.0, 7211.5, 669.8, -267.0, -1117.5, -390.9, -264.1, 583.9, 1183.9, 1311.3, -79.4, -333.2, 
24.9, 159.3, -210.4, 116.9, -194.3, 52.0, -82.0, -105.1, 239.1, 134.9, -69.0, -116.3, 14.3, 348.3, 868.3, -63.9, 
321.9, -2221.2, 53.3, 215.6, -7890.4, -3.5, 233.1, 163.6, 499.4, 131.0, -0.4, -131.6, 13.7, -230.4, 221.1, -61.7, 
-189.2, -252.0, 117.3, 426.7, 89.1, -323.3, 209.5, 16.4, -221.0, -173.4, 59.4, -119.5, 116.1, -19.6, 45.3, 96.6, 
152.0, -19.0, 195.5, 141.4, 2.7, -32.6, 125.8, -104.3, -8192.0, 12.6, -132.6, 264.3, -136.2, -180.6, 76.3, -98.8, 
141.3, -164.8, -325.5, 128.1, -3222.5, 377.5, 4063.5, 834.4, 1458.5, 2100.7, 378.5, 73.9, -311.6, -200.6, -139.7, -125.7, 
581.7, 259.8, 151.5, 82.0, -30.6, -35.4, -247.7, 402.0, 6035.4, -166.7, -100.8, -75.2, 284.6, -53.3, -318.5, 232.8, 
1721.7, -4502.2, -852.4, 1847.9, 46.2, -228.1, 1950.1, -221.0, -671.4, 1833.4, -4362.2, 1558.5, -1244.3, 20.6, 34.9, 294.9, 
144.0, 202.0, -90.3, -813.7, -142.5, 117.9, 260.1, -37.7, 1205.4, -476.0, -1403.6, 36.6, -7301.4, 1080.6, -901.3, 97.1, 
-380.6, 996.1, -699.1, 1045.8, -514.7, 920.1, 283.0, -1027.7, -166.3, 371.3, 190.4, 89.6, -808.9, -141.1, 118.3, 169.7, 
-481.7, -209.4, 92.2, 27.4, 374.3, -135.2, 477.0, 15.8, -147.3, 4031.9, 1435.8, -46.5, -5117.2, 81.0, 885.1, -1175.5, 
-1107.2, -887.5, -763.1, 504.5, -304.1, 419.4, -131.7, -258.4, 44.3, -169.2, -284.9, -656.5, -168.8, 249.9, 92.2, 434.8, 
399.3, 2742.8, -2269.8, -422.2, 55.0, 2056.7, 41.7, 644.4, -94.3, -222.1, 403.9, 173.3, 78.1, 285.3, 213.0, -356.7, 
-415.1, -64.4, 8192.0, 27.7, 129.3, -171.8, 124.2, -475.3, -119.8, 553.9, 168.1, 405.4, 231.8, -115.4, 357.8, -11.8, 
-4373.6, -4707.6, -234.2, -154.3, -32.1, 544.7, -566.6, -793.3, 514.2, 542.4, -440.2, -49.7, 595.3, -94.0, 102.5, 178.9, 
-85.8, -285.5, -218.5, 143.9, 31.4, 98.4, 180.4, -214.9, 3.5, 262.8, -484.5, -88.0, 290.0, -8192.0, -278.4, 297.9, 
146.5, -0.5, -588.2, -248.6, -199.9, -520.7, 497.6, 475.9, 118.3, -89.0, 107.1, -91.6, -86.8, 91.8, -77.5, 233.9, 
-58.3, 394.4, -145.9, -215.6, 265.4, -149.4, -72.8, 135.5, -110.7, -1113.0, -290.1, 4806.1, 1204.9, -730.4, -5190.0, 400.1, 
-593.0, -1403.1, -340.4, 677.9, 29.2, -122.1, 20.3, 320.7, 79.6, 181.3, 373.8, 20.0, -197.5, -354.6, -208.2, 129.6, 
-98.4, 103.4, 252.8, -91.8, 378.7, 137.0, -1140.0, -592.3, -251.4, -532.3, 1373.9, 238.4, 1098.1, -27.9, 403.4, 32.6, 
8140.6, -375.4, -137.7, -83.2, -147.7, 168.8, 57.0, 360.3, 179.8, -195.7, -220.1, -226.8, 170.5, 230.1, -163.0, -56.9, 
-987.2, 30.1, 866.7, 526.6, 8093.1, 70.7, -55.7, -699.4, -1164.6, -316.1, 1375.7, 189.0, 22.1, -498.7, 347.6, -16.3, 
22.9, -76.5, 0.5, 97.8, -269.5, 74.0, -329.3, 416.5, 51.1, -208.5, -687.8, -355.3, 630.7, -1598.8, -450.4, -489.3, 
168.0, 1335.9, -243.7, 841.0, -433.4, -23.2, 561.6, 413.4, 17.6, -575.4, 49.2, -282.7, -210.0, -28.5, 12.3, 228.6, 
70.7, 7983.5, 43.6, -92.4, -191.5, 124.7, -265.7, -638.3, -890.3, 548.5, -274.7, 1330.1, -126.0, 104.6, 497.7, 85.7, 
217.6, 21.2, 8192.0, 370.7, -722.8, 0.7, -477.6, 20.6, 1.1, -385.2, 46.2, -386.8, -204.8, -104.7, -154.2, -134.7, 
131.3, -264.4, -509.6, -312.1, -3520.7, 1720.9, -920.1, -958.3, 633.2, -725.3, -1123.3, -240.1, 2405.0, -1595.2, -2771.2, -464.0, 
-995.5, -2664.6, -962.0, -1557.6, 529.4, 176.4, -432.5, 26.9, -311.8, 68.5, -222.6, 162.7, 4052.0, -508.5, -260.2, -5318.8, 
-1135.5, -686.1, -738.4, 27.0, 225.8, -2268.9, 219.7, 608.7, 276.7, 586.2, -316.9, 43.1, -28.4, 8192.0, 415.8, -84.4, 
174.8, -61.7, -40.6, -286.4, 148.3, 101.6, -161.0, -82.4, 110.8, 268.8, -79.3, 121.3, -311.8, -137.4, -670.6, -884.3, 
113.8, -261.8, -146.9, -241.6, -489.4, 155.7, -64.0, 8192.0, -116.1, -97.0, -146.1, 357.8, 7.3, 254.2, 220.7, -1634.1, 
353.3, -134.5, -26.2, -222.5, -382.3, 4.3, 112.5, -157.4, 1862.8, -495.5, 6418.9, -149.9, 340.6, -2238.5, 196.6, -164.2, 
-1437.8, 435.9, 710.5, -514.6, 169.9, -348.1, -74.0, 106.0, 138.6, -177.7, 21.5, 283.2, -545.6, 89.3, -63.1, 431.0, 
764.4, -249.3, -414.9, -587.9, -41.7, 270.5, -359.4, -10.9, -27.3, -261.0, 142.7, 77.9, 14.5, 19.9, 345.9, 52.0, 
-78.3, 81.0, 122.3, 102.6, 3.7, 8192.0, -30.7, -356.9, -97.6, 73.5, -216.4, -302.7, -153.8, 42.4, 2.2, 98.0, 
-583.8, 365.0, -4062.4, 1.6, 1181.0, 833.6, 650.5, -1345.9, -5367.4, 231.7, 93.2, -2805.4, 366.5, -317.6, -158.5, 116.1, 
-199.2, -92.6, 223.6, 817.0, 174.4, -114.9, 17.9, -1200.2, 148.8, -180.4, -170.0, -80.1, -1043.0, -79.6, -359.2, -298.3, 
-661.8, -1090.7, 128.3, -837.1, -1261.5, -8192.0, 216.3, 141.4, -51.2, 582.6, 205.0, 182.4, -69.7, 335.1, 110.7, 118.4, 
-108.0, -75.7, 274.5, -77.5, 18.7, -89.6, 179.5, -99.4, 709.8, -1626.7, -165.6, 1293.3, 19.2, -1666.5, 133.5, 138.4, 
-806.8, -440.8, 518.5, 696.7, 75.0, 129.9, -23.3, -8192.0, 38.3, -374.9, -127.1, -946.8, 129.2, -201.0, -42.1, 251.4, 
293.0, 430.6, -511.5, 637.0, -710.9, 4344.6, -134.9, 5527.1, -120.1, 713.5, 394.8, -680.5, 404.0, 66.3, 336.9, 478.0, 
-302.1, -30.3, 27.7, 318.0, -498.2, 23.0, 85.9, -151.9, -74.7, -77.4, -225.1, 242.8, 780.9, -393.0, 656.9, 715.2, 

};

double tvqtab_scmdct_1[] = {
-561.2, -713.8, -16.7, 1735.2, 215.0, -8119.3, -300.0, -116.6, -321.4, 830.9, 355.2, -58.3, 280.3, 464.6, 167.6, 47.9, 
-11.4, 96.1, 137.8, -252.5, 137.8, -303.4, -98.5, 14.5, -225.3, 160.7, -12.0, -58.6, -775.0, 315.3, -620.2, -992.4, 
-12.8, -1335.7, 143.6, -1198.4, -1288.1, 8015.5, 204.3, 158.9, -591.5, 731.1, 144.8, 179.3, 93.2, 145.5, 38.9, 257.6, 
101.6, -67.5, 50.9, 11.4, 99.4, -210.4, -40.0, -58.5, -3915.0, -782.6, -1029.4, 4961.0, 534.9, -181.7, 606.6, 369.6, 
-1139.2, -1963.3, -426.4, -941.3, 259.0, 276.8, 121.6, 84.6, 202.0, 449.1, 144.5, 205.4, -366.1, -335.5, 20.2, 82.8, 
-357.4, 119.7, -107.2, -358.5, -1610.2, -1283.8, -1449.3, 437.8, -267.9, 5562.3, -2744.8, -305.7, 278.0, 2618.1, 326.5, -169.6, 
-2019.1, -1045.5, 321.3, 281.7, -564.1, 159.5, 358.6, -793.5, -231.2, -47.2, 172.5, 195.9, -473.5, 609.3, -268.5, -18.1, 
203.1, 1157.9, -332.0, 8192.0, 246.5, -60.8, -900.1, 285.3, 878.8, -932.6, 72.4, 223.6, 206.3, 117.7, 195.7, -205.6, 
50.3, -217.2, -262.4, 197.6, 33.2, -89.9, 313.1, 270.3, -78.6, 208.8, 135.8, -92.0, -182.8, 3165.2, 500.3, -3345.9, 
631.5, -220.1, -219.9, 4608.3, -3178.4, -399.9, -312.2, 378.8, -559.3, 196.1, 354.2, 24.5, 397.2, 24.5, -122.3, -579.3, 
-29.6, -351.2, 29.0, 306.0, -518.6, 329.2, 259.0, -361.8, 3560.4, -556.8, 901.4, -1009.7, -3115.6, -1781.1, 20.4, -448.8, 
-2473.8, -1018.8, -3821.8, -655.0, -247.1, 231.3, -350.5, -76.9, -2524.5, -11.8, 601.6, -42.9, 503.4, 11.8, -98.8, 563.1, 
-855.1, -613.3, 877.7, -836.3, 99.3, 803.3, -350.6, -103.9, 556.6, -2584.9, 501.2, 24.7, 7101.9, 42.6, 83.8, -947.8, 
630.4, 491.2, -69.0, 3.7, -182.6, -165.1, 372.6, 64.4, 120.3, -103.6, 51.5, 3.1, -483.5, -39.7, 254.2, 315.2, 
-684.1, -186.1, 1408.0, 467.3, 516.3, 647.9, -1823.9, -209.9, -1533.2, 214.2, -735.8, -223.6, 7325.9, 349.4, 210.1, 66.3, 
160.8, 63.6, -153.7, -434.8, -205.1, 214.0, 479.9, 138.6, -90.4, -36.2, 260.9, -82.0, 326.0, 510.6, 664.5, 933.7, 
-171.2, 614.6, 264.1, 528.9, 97.5, -301.1, 157.0, 6638.7, -70.2, 209.6, 74.7, -734.7, 91.6, -496.3, -258.8, 4242.0, 
-162.9, -179.7, 101.5, 346.6, 250.4, -181.2, 165.0, -184.0, 536.5, 1332.9, 164.0, 1325.0, -231.2, -62.0, -8136.5, 13.3, 
-8.8, -183.4, -21.5, -156.9, -748.1, 78.5, -84.0, -435.3, 12.9, -236.0, -118.6, 182.9, -26.3, 52.5, -93.9, 402.3, 
-43.3, -265.1, 249.3, 96.7, 2532.6, -1240.8, 4875.4, -395.9, 744.2, 4754.6, -212.9, 538.6, 38.7, -791.5, 311.9, -400.0, 
-141.9, -34.1, 122.9, 20.4, 310.5, 289.0, -264.0, 34.3, -295.5, 13.5, -98.2, 85.9, 155.5, -421.3, -420.2, -1113.5, 
-854.1, -4737.3, -4964.8, -42.6, 36.0, 271.0, 402.8, 216.0, -361.4, -1031.3, 896.6, 303.3, -882.9, 146.9, 407.8, -57.6, 
140.3, -62.1, -208.2, -299.0, 62.6, -104.0, -54.0, -22.0, 125.0, 541.0, 167.3, 62.6, -37.3, -320.7, -479.8, -1002.0, 
6982.4, 428.5, 429.6, 1185.6, 270.6, -38.5, -2430.0, -216.1, -258.1, 1022.9, 7.5, 31.9, 145.5, -95.5, 57.1, -248.5, 
-362.5, 386.9, -647.1, -296.8, -215.8, 657.7, 158.0, -170.8, -936.6, -6447.3, 1963.8, -43.3, 621.1, -589.6, 790.4, 34.8, 
192.0, -681.5, -75.1, -1008.5, -592.1, 372.8, -407.7, -232.1, 84.5, 48.0, 735.8, -190.7, -189.0, -36.1, -20.3, 69.0, 
-379.5, 24.9, -290.1, -187.7, -903.0, -538.2, -466.7, 82.9, 323.1, -2047.7, 296.0, 732.5, -316.9, 625.5, -87.2, 19.2, 
117.0, -8038.9, 371.8, 126.6, -22.1, -100.3, -177.6, -126.4, 260.5, 0.5, 0.6, 34.8, -285.4, 103.3, -347.5, 389.4, 
1747.9, 2234.3, -277.5, -109.8, -171.4, -878.5, -34.1, -6668.5, -277.8, -71.8, -929.3, 77.1, -55.3, -834.8, 1929.4, 4.5, 
18.3, 59.5, -95.9, 305.9, 158.7, 59.7, 248.2, -149.5, 128.0, -65.1, -1.6, 213.8, -739.1, -212.2, 400.8, 70.1, 
-189.8, 683.7, 40.3, -532.0, 3.0, -695.0, -1249.8, -1958.4, -1494.0, 142.9, -97.3, -2738.4, -112.9, 159.0, -7679.3, 260.8, 
-267.6, -203.5, 147.6, 1002.2, -304.2, 317.3, 792.7, 427.9, 3208.6, -221.6, -1632.8, 444.5, -382.3, -171.5, 130.6, 5996.9, 
1416.9, 299.8, -641.1, -1334.1, -135.0, -295.7, 999.2, -588.2, -109.4, 0.8, 45.1, 241.5, 716.0, 75.3, 181.6, -63.4, 
608.0, 302.1, -2.8, 186.6, -4161.7, -205.9, -505.0, -5407.0, 132.5, 913.8, 441.8, -43.6, 281.5, -884.0, 369.0, 306.5, 
236.6, 16.9, 321.3, -136.0, -285.3, -57.0, 117.7, 172.7, -341.1, -286.4, 518.2, -36.8, -165.2, 38.2, -128.0, 2036.2, 
4768.2, 651.6, -1323.6, -21.5, 3555.3, 2592.6, 672.9, -1588.3, 776.8, 1531.6, 170.8, -1284.5, -351.6, 29.5, 637.3, -571.3, 
401.2, -84.3, -197.4, -192.6, 304.2, -91.6, -144.7, -112.9, 135.2, -150.4, 49.5, 492.3, 566.2, 193.6, -8192.0, -1008.5, 
311.0, -703.7, 143.8, -322.4, -345.2, 493.5, -122.1, -583.3, -72.1, 189.9, -399.4, -105.0, 209.0, -118.6, 97.1, 220.5, 
479.3, -14.2, 198.2, -104.4, 202.3, 83.1, 12.5, 226.3, -529.2, 317.2, -3662.3, -2057.5, -4863.5, 1738.0, 495.1, 783.9, 
9.1, 105.2, -514.3, 84.7, 258.6, 538.8, 134.0, -14.6, 359.9, -259.7, -39.4, -164.9, 525.2, 19.7, -3801.9, 78.5, 
-237.3, -526.4, 466.5, 20.8, 1203.4, -1301.8, 348.1, -1694.5, -83.5, -667.8, -69.4, -248.8, -806.8, -32.7, 7341.0, -343.4, 
80.0, -278.2, 174.6, -342.1, -312.2, 498.4, -382.4, -16.3, 252.4, 246.8, 1.9, 111.2, 321.4, 77.7, 248.6, -645.2, 
-2744.0, -226.8, 5684.9, -3196.3, 201.0, -1143.2, -68.9, 48.0, 625.6, -12.2, -1007.2, -911.8, -619.4, 413.5, -113.2, 45.1, 
334.9, 15.2, -7.5, 363.2, -1040.0, -165.1, 230.6, -309.3, 510.4, -149.2, -171.9, 454.3, 482.8, 2739.8, -178.6, 648.8, 
19.1, -422.0, 129.6, 155.7, -32.2, 218.2, 255.1, -766.4, -511.5, -441.8, -7895.9, -95.4, 88.4, -507.1, -117.5, -160.8, 
110.5, 478.6, -43.8, 375.2, -422.4, -239.4, 273.0, 43.8, 459.8, 2520.3, -3700.9, -219.0, 604.4, -398.3, -3011.9, -165.8, 
611.0, -3859.3, 549.1, -468.7, -54.6, 378.4, 259.5, -6.5, 291.0, 215.1, 225.0, -25.2, 51.5, 94.8, -151.8, -382.5, 
-18.1, -1051.7, -4932.4, 174.7, -7985.6, -471.4, 536.2, -173.5, 565.7, 67.8, 802.8, -1040.1, 832.5, -106.7, -361.2, 453.6, 
40.1, -622.4, -140.1, -63.5, 383.0, -80.7, -149.3, -162.5, -72.1, 84.6, -199.5, 84.3, -575.8, -136.0, 87.8, -713.6, 
350.8, -1145.1, -210.1, 1038.6, -18.8, -1098.0, 210.8, 210.4, -802.5, -696.9, 212.9, 381.2, -524.5, 73.2, -33.8, 8192.0, 
130.9, -435.1, -880.7, -549.6, 133.0, -97.3, 76.1, 177.6, -12.0, 261.0, -168.5, 177.8, -3820.4, 4929.0, 586.4, 357.3, 
208.7, -1327.9, 525.2, -426.1, -290.0, -84.7, -283.1, -992.5, -777.0, 727.9, 522.5, -130.6, -31.9, 58.6, 655.4, -233.7, 
-2.1, 1969.1, -24.5, 122.3, -1434.3, -529.6, -127.7, 399.8, -253.6, 580.2, 3009.4, 2563.5, -2683.8, 34.2, -168.6, 349.0, 
322.5, -399.6, 626.4, -743.8, -938.8, 151.5, 8.4, -310.6, 199.1, 116.5, 181.6, -192.6, -90.0, 93.5, 178.1, -6795.7, 
77.2, 689.1, 269.7, 216.1, -74.9, 2728.3, 143.0, 1142.2, 181.9, 3492.9, 5593.3, 631.0, -296.2, -136.5, 464.6, -234.4, 
639.1, -401.2, 206.2, -0.4, 244.2, -132.8, 323.2, -611.7, -270.7, -438.0, 756.8, 194.9, 30.6, -370.5, -55.2, -210.9, 

};

double tvqtab_scmdct_2[] = {
613.0, -1918.4, -968.9, 892.6, 419.0, 79.3, -77.8, -240.8, 162.1, 493.8, -1223.7, 720.0, 181.3, -1005.3, -10.1, 1160.7, 
464.2, -1110.3, 138.9, -7755.7, -603.2, -621.0, 779.9, -144.7, 199.2, 449.8, -147.5, -650.1, 474.8, -258.1, 635.7, -975.8, 
768.7, -1061.6, 606.4, -437.7, -535.1, 214.6, -934.9, -8192.0, -104.9, 84.0, -393.5, -261.4, 26.9, 1021.8, -110.7, -818.0, 
-2191.5, 516.5, -512.3, -7841.8, -1863.1, 930.8, 296.5, -854.1, 321.5, -104.4, 745.6, 1428.2, -71.9, -406.6, 549.5, 1065.5, 
1224.3, -899.9, -418.3, 4.0, -588.7, 125.3, -942.3, -1317.2, -5741.3, 1175.1, -3780.8, -1979.1, 3997.5, 2363.4, 1948.9, -1075.8, 
270.2, 1113.4, -1514.8, 36.5, -215.7, 1244.3, 1454.6, -629.9, 526.6, -31.9, 960.9, -292.7, 1256.4, 1770.9, -1638.3, -1141.1, 
1869.4, 1185.6, 515.5, -381.0, -1273.0, -942.5, -988.9, -595.9, -954.0, -663.4, -547.1, 731.1, -360.1, -93.3, 7036.1, -1416.0, 
1070.4, -2318.2, 314.9, 440.7, 72.7, -60.8, -1731.8, 1086.1, -535.5, -152.7, -523.3, 1189.4, 100.9, -560.4, -269.2, -1528.7, 
-482.0, -672.3, 204.8, -1138.3, -85.9, -914.3, -266.2, 1683.5, -411.3, -522.6, 427.8, 436.3, 166.2, 8119.0, -1297.1, 173.8, 
1996.2, 1353.1, 2318.5, 4260.0, -3061.5, 2192.3, 702.0, -2385.7, 1653.8, 1494.3, -1128.3, 807.4, -1586.9, 1139.7, -1618.1, 217.8, 
-808.5, 827.0, -756.3, 1528.0, 493.9, -1344.4, -4055.4, -118.7, 164.0, 620.7, -359.6, 201.5, -932.1, 8192.0, -101.1, -1723.8, 
-94.3, -950.4, 198.0, 903.7, -602.2, -198.7, -514.4, 1396.4, -756.6, -429.0, 370.1, -249.4, -59.5, 221.6, -1645.2, 1282.2, 
-959.2, -2799.8, 2031.5, 1081.8, 3374.3, 3582.4, 603.2, 777.2, -1314.0, 2646.5, 340.0, -1727.3, 1645.3, 173.9, -558.3, -807.2, 
-645.4, -2908.5, -525.6, 2070.0, 269.2, -86.7, 3020.5, -6239.7, -474.0, -489.6, 511.5, -707.2, 247.4, 1316.2, -45.1, -823.5, 
-8016.4, -1546.4, 236.2, -143.7, 143.7, -385.4, -375.3, -1493.8, 716.5, 334.3, -156.9, 658.5, -48.5, -1005.8, -2546.6, 320.7, 
896.7, -1018.5, -8192.0, -1013.5, -380.1, 657.3, 94.6, -263.9, 421.1, -783.9, -149.0, -427.7, 555.6, 264.4, 393.1, -322.4, 
255.5, -175.0, -628.9, 673.4, 1279.4, -641.0, -1016.1, -1884.3, -513.2, -335.3, -37.1, -805.8, 1171.8, 262.9, -1791.4, -8099.1, 
815.1, -783.7, 296.2, -601.5, -192.0, 86.9, -3.9, 974.0, 2015.1, 161.7, -1157.0, -490.5, -1972.9, -985.8, 381.7, 525.7, 
-2340.4, -5661.8, 4040.0, -2018.0, 620.7, -1192.3, 82.4, -2415.0, -531.9, -408.1, 1410.8, -124.5, 1669.3, 1686.0, 351.5, -150.9, 
-46.5, 775.2, -550.0, -189.9, 1333.1, 33.9, -1745.5, -417.2, 65.0, 22.3, 770.3, -610.0, 1222.8, 625.5, 923.8, 611.1, 
778.8, -72.4, -793.9, -8138.9, -652.8, -443.5, -326.3, 372.0, -835.5, -932.2, -438.0, 636.3, 552.6, -645.1, 1783.7, -1578.1, 
-1400.0, -98.5, 3057.0, 3613.4, 2282.3, 2572.4, 3484.4, -3571.9, 481.7, -3392.1, 1297.0, 1167.4, 161.0, -1064.2, -313.3, 1599.9, 
-6.9, 470.8, 653.7, 136.3, 2168.9, 1038.2, 856.7, 363.0, -785.2, -384.5, -166.7, 305.1, -465.8, -565.9, -1368.1, -287.8, 
52.2, 207.1, 2756.1, 487.7, 422.8, -1724.3, -646.7, 219.3, 52.2, -7309.5, -398.8, 871.1, 614.9, -965.9, -94.9, -1695.4, 
3931.0, -7212.4, -30.7, -853.7, -141.4, -138.3, -196.0, 295.3, -78.4, 364.0, 388.5, -1395.2, -1237.0, 1038.9, 703.5, 87.8, 
546.8, -9.3, -696.1, -777.8, -78.2, -475.6, 224.0, -268.8, 2059.0, 2976.1, 2990.4, -3869.7, -1417.0, 1535.6, -2343.5, -983.8, 
-969.7, 1746.4, 149.8, 2876.3, -1391.5, -262.8, -1512.9, 980.8, -1948.6, -752.1, -564.2, 1323.3, 1.1, -518.9, 2387.7, 617.5, 
263.7, 78.7, 663.8, -310.6, -2441.4, -1218.3, -481.4, 1743.2, 514.8, -483.3, 1094.8, 655.3, 269.5, 146.2, -913.0, -744.6, 
7872.2, 2233.3, 401.5, 948.2, -1182.8, 1871.3, 459.9, -672.7, 23.6, 461.8, 754.2, -411.9, 451.3, 245.3, -8192.0, -294.2, 
-192.5, -819.3, -791.4, -1601.9, -430.8, -131.7, 573.7, 1347.4, -345.2, 46.1, 1877.7, -798.3, -42.5, -84.7, 96.0, 1252.6, 
381.9, 3174.6, -608.4, -2156.8, -3019.3, 781.0, 4767.2, -1575.8, 920.3, -660.6, -779.4, -2567.7, 1139.5, 647.3, 98.2, 2453.2, 
-1062.3, -608.9, -1438.9, 1269.2, -1554.3, -979.2, -244.0, 1879.8, -502.3, -843.6, 631.9, 843.7, 708.5, -992.0, -471.3, -1323.4, 
788.6, -952.4, 833.7, 1104.1, 555.9, 27.4, 1181.2, -183.5, 291.0, 803.2, -106.9, -517.0, -504.5, 108.5, 8192.0, 2984.5, 
433.6, 246.0, -1589.2, -817.6, -708.4, -1522.4, -1661.6, 1227.3, -1094.2, -491.1, 237.0, -887.9, 1532.3, 1569.8, -299.8, -219.7, 
-517.8, 407.6, 414.2, 122.3, 7957.8, -501.4, -406.0, 202.0, -4188.3, 247.2, 437.9, 1234.2, -3749.7, -5089.5, -159.7, -401.0, 
1524.7, -1408.0, -3081.6, -60.8, 1318.4, -63.0, -1692.2, -71.0, -575.4, -1530.1, -6.8, 838.7, -913.4, -431.7, 1032.4, -2078.2, 
656.5, 1578.5, -2239.9, 764.9, 1307.3, -4063.0, 2133.6, -4375.1, -2720.8, -82.3, -4.4, 1379.8, 1452.4, -794.8, -1084.7, -720.3, 
-1685.5, -105.5, 1770.7, 1205.6, -635.2, 799.4, 1327.4, -776.7, 406.0, 353.4, 1207.9, 100.3, -554.4, -363.5, 812.3, -219.5, 
368.2, -818.0, -1283.4, 115.5, 949.7, -348.7, 864.5, -336.3, 326.9, -779.5, 7874.7, -142.3, 1076.4, -848.0, -246.6, -3475.1, 
-8192.0, -3.9, -103.4, -300.1, -451.7, -318.6, 197.6, 139.9, -167.5, -386.7, 1758.9, 755.7, 75.4, -465.2, 329.6, 557.2, 
-219.0, 526.8, 896.1, 435.7, -509.5, 65.4, -407.4, -1614.7, 246.7, -2.2, -202.0, 763.1, -8192.0, 985.9, 776.4, 51.7, 
74.6, 180.7, -360.0, 463.2, 226.0, -83.2, 1488.2, -1249.9, -1186.7, 167.1, -211.1, -562.4, 75.1, 1007.6, 400.6, -2326.2, 
336.0, 441.6, 215.6, 104.9, -216.9, 860.4, -1256.2, 505.1, 596.4, -7828.0, 542.6, -218.9, -1139.2, 175.8, -1623.0, 383.9, 
66.5, -230.2, -732.1, 505.2, 417.1, 587.0, 210.5, -1437.0, 572.1, -128.0, 823.0, -312.2, 59.7, 100.7, -720.4, 695.3, 
-790.7, -1235.8, 891.5, 1663.5, 347.7, 7774.4, -121.7, -516.7, -906.6, 929.5, -315.7, -397.6, -1038.2, -1197.8, -92.7, -929.0, 
-1050.2, -1276.6, -428.5, -141.9, 88.4, -1400.9, 34.3, 763.6, -203.7, -854.5, -713.6, 13.7, -7944.3, 265.6, -520.4, -532.2, 
1207.4, -1606.8, 480.2, -31.7, -2769.1, -386.9, -52.8, -45.7, -4196.5, -786.1, -474.8, 2859.1, -3151.7, 3652.5, -2296.0, 1179.6, 
-1717.4, 1482.6, -2578.0, -401.3, 1222.3, 522.7, 124.4, 2285.2, -180.0, -849.8, -180.3, 1514.7, -1489.2, -946.0, 1162.9, 1043.9, 

};

double tvqtab_scmdct_3[] = {
-1587.4, -8151.2, 466.2, 476.5, 1310.7, -36.4, -835.2, -385.1, -329.8, -983.2, -724.4, -861.8, -354.7, -992.7, 197.9, 554.3, 
-77.3, 207.1, -977.7, -660.0, -331.6, 602.2, 706.1, -1584.4, -495.0, 61.2, -263.6, 1248.6, -1573.1, -713.3, 2527.9, -6633.3, 
-696.5, 247.3, 1391.3, -289.7, -324.9, 489.0, -1072.0, -459.6, -211.1, -736.0, 385.2, -1296.0, -37.3, 1785.9, -258.4, -459.0, 
433.0, -524.1, 264.9, -41.6, 7135.3, 1978.2, 105.5, -52.2, -396.5, -306.8, -1282.4, 412.9, -21.3, 1616.7, -46.3, -844.6, 
-1902.3, 1368.5, -133.6, 211.3, 1114.3, 457.7, 2710.2, -1426.3, 1621.1, -382.5, 941.6, 1426.9, -4604.8, 2534.3, -1221.5, 267.8, 
-4996.4, -1924.1, 763.4, 1417.4, 254.9, -620.3, 325.2, 358.6, 669.7, -799.6, 529.5, -319.1, -364.0, -423.1, -2416.2, -1041.0, 
-357.9, 860.6, 339.1, 143.7, -188.7, 1506.9, -903.6, -898.6, 6330.3, -3820.3, 829.1, -11.5, 220.8, -477.8, 1134.2, 253.0, 
383.0, -1115.3, -1149.9, 848.9, -1113.5, 107.8, -868.4, 295.0, -8192.0, -591.2, -299.6, 524.8, 1471.7, 73.1, -869.7, -211.1, 
-162.2, 139.5, -1121.5, -1009.6, 91.9, 160.0, -270.5, 67.1, -275.7, -861.7, -722.4, -488.8, -623.8, 698.3, 697.8, -264.1, 
-818.4, 786.0, -608.1, -61.4, 1509.7, 7783.9, -37.6, 2065.4, -638.7, 198.9, 35.8, -824.1, 791.2, 739.0, 605.3, -1152.7, 
-372.9, 424.6, 1346.8, -18.8, -625.8, 604.6, -384.4, 284.6, 3029.7, -1750.6, 4506.6, -870.0, 513.2, 2301.4, 927.1, 2530.7, 
228.1, -2474.1, 1344.5, -78.5, 153.2, -1658.2, -537.2, -280.5, 642.4, 2369.1, 500.4, -584.8, -170.5, -303.1, 1704.0, 136.9, 
-1569.8, -1288.6, 201.5, -1157.1, -466.5, 797.8, 371.5, -1819.5, 537.5, 131.8, -3898.4, 5382.6, 1775.5, -542.9, -1048.7, -370.1, 
-635.7, -952.7, -997.7, -41.5, 726.0, 11.2, -81.3, 13.6, -2450.0, 1788.6, -1971.3, 614.4, -787.8, -345.9, -1830.9, 4736.7, 
154.9, 76.6, 1477.9, 576.4, 1549.4, -873.6, -1628.5, -5.8, -1817.4, 1087.2, -119.7, -4009.5, -362.6, -2510.0, -3032.0, -1122.4, 
1489.3, 5731.5, 4239.4, 396.9, 1859.3, -1909.5, 302.0, -790.5, 1461.5, -1084.0, -510.0, -1498.7, 788.4, -259.0, 965.0, -536.7, 
428.1, 622.7, -227.5, -1693.9, -98.6, 217.7, -852.7, -1826.4, 727.1, -471.3, -3938.0, 4596.7, 155.4, 2508.6, -1160.6, -959.7, 
1337.4, -1124.4, 782.0, 747.3, 169.4, -577.7, 2942.3, -638.7, 1307.7, 1236.2, -449.5, -649.7, 294.4, 1321.4, -699.9, 364.8, 
-3489.7, -557.6, 1321.0, -1750.9, -324.9, -704.9, 5375.6, 2709.4, 343.7, -3100.4, -1881.5, 172.9, -1917.0, 847.7, 679.8, -268.1, 
974.4, 27.3, -60.4, -1128.4, 12.1, -2983.5, -354.1, 945.0, 254.3, 1387.7, 1209.8, 598.9, 277.1, -934.4, -7093.7, 1923.9, 
1015.7, -357.3, -390.3, 1251.3, -946.7, 480.0, 208.4, 1134.5, 750.0, -716.6, -726.8, 794.7, -336.0, 75.3, 807.0, -2576.3, 
1188.4, -248.5, 718.0, -1366.1, -3130.4, -1170.6, -101.4, 1117.5, 1004.6, 7.1, -1020.9, 63.7, -483.1, -1065.0, 878.5, -1709.5, 
-6818.4, 1088.2, 363.8, -686.1, -1432.5, -405.5, 343.5, -391.3, -945.3, 2896.2, 362.4, -2761.9, 2342.6, 805.7, -619.8, 490.8, 
-2910.0, -798.1, -59.8, 409.3, -1168.1, 149.5, 550.7, 4936.1, -563.9, -328.6, -320.0, 616.0, 1443.7, 381.4, -1751.2, -738.3, 
1408.8, -324.5, -250.1, -42.1, -718.3, 654.3, 608.0, 324.9, -863.8, 596.2, -2048.1, -1469.7, 1793.5, -211.2, -15.2, 394.4, 
992.8, -6976.7, 1115.8, -1024.9, 823.3, 216.9, -1298.7, 2454.0, -2586.3, -2557.9, -1035.1, -2009.8, -1809.3, -5664.7, -661.2, -987.2, 
-261.8, -731.4, 806.3, 972.9, -2113.7, 1892.0, 1078.4, 1751.2, -443.4, 1183.3, 1097.3, 570.2, -57.2, -956.0, -1259.4, 53.0, 
1515.5, 941.4, -381.6, 1674.6, -81.4, 121.6, 2131.6, -556.5, 1081.9, 1872.4, -816.3, -1076.9, 496.7, 7226.8, -416.5, -382.9, 
508.1, 1137.3, -1334.6, 790.6, 1024.6, 613.2, -441.6, -1065.9, -406.3, 380.5, 681.0, -1482.5, -2079.6, -1901.1, -3583.9, -3315.9, 
-447.2, -63.2, -691.0, -1701.2, 578.3, -2632.7, 663.9, 30.6, 1611.2, 3718.7, 867.1, 1683.5, 50.0, -1270.9, -1571.8, -1539.7, 
321.7, -618.9, 1318.2, -2858.6, -95.2, 109.2, 1145.3, 1812.0, -278.3, 2607.3, -359.3, 1530.9, -1664.7, 678.0, 2133.4, -1815.8, 
1561.3, 56.1, -134.9, -12.2, -342.6, 6635.7, 2642.9, 2408.3, 757.9, -357.8, 798.2, 492.1, -1311.4, 742.9, 4154.7, 105.9, 
571.6, 2169.7, 903.3, 334.5, -3191.2, -1928.7, -1051.4, 1526.9, 245.2, -1750.8, -1104.9, 1049.2, 5111.9, -1193.6, -521.4, -734.0, 
-1838.4, 1235.6, 1095.1, 2725.7, 2497.5, -1924.5, 1151.5, 603.4, -1416.1, 2696.4, -268.5, -1621.3, 399.0, -529.9, 2481.5, -123.4, 
2178.4, 857.2, -991.2, 3837.0, -385.4, -212.5, -3028.1, 4468.3, 1330.4, 2003.6, -5625.7, -1541.8, 709.1, -203.4, 722.3, 468.9, 
1065.2, 1010.1, 1321.9, 653.3, -1503.7, -890.1, 126.5, 595.1, 1292.0, -120.9, 867.1, 309.0, -1041.5, -1233.9, 4458.3, 1747.7, 
3786.4, 166.8, 659.1, -7165.8, 736.4, 760.8, -157.3, -832.6, -726.2, -558.5, -1335.9, -1448.4, 1227.1, 310.8, -1051.7, -528.0, 
-791.4, 629.3, 33.1, -1012.9, -632.4, -129.1, -499.5, 1025.3, -1451.7, 246.9, 244.9, 149.8, 5.9, 156.5, -51.5, -109.4, 
478.2, 306.5, 7042.5, 253.4, 122.7, 110.6, -2.7, -947.8, -1074.1, 318.6, 81.2, 44.4, -1188.6, 980.2, -1001.7, 1166.1, 
-1751.7, 1177.9, -1175.2, -2322.5, -4825.7, 1590.5, 258.0, 229.3, -92.0, 167.1, 71.5, -2142.2, -2665.3, 1556.1, -2104.4, 374.6, 
1627.4, -847.9, 1737.1, 110.3, 594.9, 1048.1, -177.5, -207.9, 121.0, -145.1, -561.2, 420.7, -152.6, -871.5, -1213.1, -294.2, 
-868.6, 807.8, -220.4, 981.4, 89.8, -313.7, -7218.6, 424.1, -315.4, -975.3, -199.4, -893.3, 283.3, -108.3, 775.2, 785.3, 
2464.9, -3039.7, -673.7, 188.1, 1483.1, 1089.5, -446.4, 283.0, 648.4, 2184.9, -1143.1, 576.4, 1052.9, 281.0, -2367.4, 1505.7, 
-702.3, 628.9, 4176.2, 1901.7, -1451.3, -460.0, -4274.9, 174.8, 9.6, 362.4, 362.1, 802.5, 497.8, -914.2, -1697.2, -45.5, 
-1122.9, 648.9, 720.2, 916.9, -371.9, 588.3, 162.3, -6838.7, -849.4, -560.4, 316.3, 180.4, -229.1, -2966.6, -638.9, 437.5, 
3819.9, 685.6, -662.9, 1849.7, 1157.1, -2943.1, 2673.0, -153.4, -1106.0, -1384.2, 869.4, 1226.8, -513.6, -352.0, 1064.3, 4032.2, 
375.9, -824.9, -1518.7, 1262.0, -2905.1, 160.0, -315.9, -3058.0, -125.4, -618.8, 379.6, -840.3, -975.8, -1430.1, 1370.9, 583.0, 
-452.9, -73.0, -374.4, -1129.0, 7405.0, 175.4, 123.6, -458.8, 1692.4, -318.4, -1535.9, 521.6, -277.1, -690.6, 899.4, 3196.9, 

};

void ntt_get_cdbk( char *name,
                   double *codev_l,
                   int cb_size,
                   int cb_len,
                   int cb_len_mx )
{
  /* Variables */
  int	 i_cb, i_cv, index, index2;
  double *cbptr = NULL;

  if        (strcmp(name, "./tables/tf_vq_tbls/cdmdct_0" ) == 0) {
    cbptr = tvqtab_cdmdct_0;
  } else if (strcmp(name, "./tables/tf_vq_tbls/cdmdct_1" ) == 0) {
    cbptr = tvqtab_cdmdct_1;
  } else if (strcmp(name, "./tables/tf_vq_tbls/cdmdct_2" ) == 0) {
    cbptr = tvqtab_cdmdct_2;
  } else if (strcmp(name, "./tables/tf_vq_tbls/cdmdct_3" ) == 0) {
    cbptr = tvqtab_cdmdct_3;
  } else if (strcmp(name, "./tables/tf_vq_tbls/scmdct_0" ) == 0) {
    cbptr = tvqtab_scmdct_0;
  } else if (strcmp(name, "./tables/tf_vq_tbls/scmdct_1" ) == 0) {
    cbptr = tvqtab_scmdct_1;
  } else if (strcmp(name, "./tables/tf_vq_tbls/scmdct_2" ) == 0) {
    cbptr = tvqtab_scmdct_2;
  } else if (strcmp(name, "./tables/tf_vq_tbls/scmdct_3" ) == 0) {
    cbptr = tvqtab_scmdct_3;
  } else if (strcmp(name, "./tables/tf_vq_tbls/fcdl" ) == 0) {
    cbptr = tvqtab_fcdl;
  } else if (strcmp(name, "./tables/tf_vq_tbls/pcdl" ) == 0) {
    cbptr = tvqtab_pcdl;
  } else {
    CommonExit ( 1, "%s: Codebook name error 1.\n", name);
  }

  /* Main operation */
  index2 = 0;
  for ( i_cb=0; i_cb<cb_size; i_cb++ ){
    ntt_zerod( cb_len_mx-cb_len, &codev_l[cb_len+i_cb*cb_len_mx] );
    for ( i_cv=0; i_cv<cb_len; i_cv++ ){
      index = i_cb*cb_len_mx  + i_cv;
      codev_l[index] = cbptr[index2++];
    }
  }
}

void ntt_get_code( char *name,
                   int nstage,
                   int csize[],
                   int cdim[],
                   double code[][ntt_N_PR_MAX],
                   double fgcode[][ntt_MA_NP][ntt_N_PR_MAX] )
{
  int     i, j, k, off_code;
  int i_mode, i_ma, readCnt;

  double *pTab = NULL;

  if        (strcmp(name, "./tables/tf_vq_tbls/20b19s48bs" ) == 0) {
    pTab = tvqtab_20b19s48bs;
  } else if (strcmp(name, "./tables/tf_vq_tbls/20b19s48sc" ) == 0) {
    pTab = tvqtab_20b19s48sc;
  } else {
    CommonExit ( 1, "%s: Codebook name error 2.\n", name);
  }

  readCnt = 0;
  off_code = 0;
  for( i=0; i<nstage; i++ ) {
    for( j=0; j<csize[i]; j++ ) {
      for( k=0; k<cdim[i]; k++ ){
        code[off_code+j][k] = pTab[readCnt++];
      }
    }
    off_code += csize[i];
  }

  for(i_mode=0; i_mode<ntt_N_MODE; i_mode++){
    for(i_ma=0; i_ma<ntt_MA_NP; i_ma++){
      for(k=0; k<ntt_N_PR; k++){
        fgcode[i_mode][i_ma][k] = pTab[readCnt++];
      }
    }
  }
}



