/****************************************************************************
 
SC 29 Software Copyright Licencing Disclaimer:

This software module was originally developed by
  Coding Technologies

and edited by
  -

in the course of development of the ISO/IEC 13818-7 and ISO/IEC 14496-3 
standards for reference purposes and its performance may not have been 
optimized. This software module is an implementation of one or more tools as 
specified by the ISO/IEC 13818-7 and ISO/IEC 14496-3 standards.
ISO/IEC gives users free license to this software module or modifications 
thereof for use in products claiming conformance to audiovisual and 
image-coding related ITU Recommendations and/or ISO/IEC International 
Standards. ISO/IEC gives users the same free license to this software module or 
modifications thereof for research purposes and further ISO/IEC standardisation.
Those intending to use this software module in products are advised that its 
use may infringe existing patents. ISO/IEC have no liability for use of this 
software module or modifications thereof. Copyright is not released for 
products that do not conform to audiovisual and image-coding related ITU 
Recommendations and/or ISO/IEC International Standards.
The original developer retains full right to modify and use the code for its 
own purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for products that do not conform to audiovisual and 
image-coding related ITU Recommendations and/or ISO/IEC International Standards.
This copyright notice must be included in all copies or derivative works.
Copyright (c) ISO/IEC 2002.

 $Id: ct_envcalc.c,v 1.17.4.1 2012-04-19 09:15:33 frd Exp $

*******************************************************************************/
/*!
  \file
  \brief  Envelope calculation $Revision: 1.17.4.1 $
*/

#include <stdlib.h>
#include <math.h>
#include <string.h>

#ifdef SONY_PVC
#include "sony_pvcprepro.h"
#endif  /* SONY_PVC */

#include "ct_envcalc.h"
#include "ct_hfgen.h"
#include "ct_freqsca.h"


#ifdef HUAWEI_TFPP_DEC

extern int td_fd_mode[5+4];  /* 0:ACELP; 1-3:TCX;  4:FD */
extern float tf_class;	 

#define  MAX_T_NUM          8 
#define  MAX_F_NUM          50
#define  MAX_SPEC_NUM       2
#define  SQR(x)				((x)*(x))

/* 
   Controlled_TF_postprocess() provides functionality as described in ISO/IEC 23003-3, 
   Annex E (informative) Adaptive Time/Frequency Post Processing. This functionality is 
   informative only.
*/

void Controlled_TF_postprocess(
			float **Real,        
			float **Imag,        
			int i_spec,          
			int noSubframes,     
			int Start_HB,        
			int End_HB,          
			int OutSampRate      
			)
{
  static float f_control[MAX_SPEC_NUM]={0,0};     
  static float t_control[MAX_SPEC_NUM]={0,0};     
  static float T_energy_0_sm[MAX_SPEC_NUM]={1,1}; 
  static float T_energy_1_sm[MAX_SPEC_NUM]={1,1}; 
  static float T_energy_min[2]={100,100}; 
  static float gain_t_mem[MAX_SPEC_NUM]={1,1};
  static float F_energy_sm[64]={1}; 
  static float T_energy_sm[MAX_SPEC_NUM]={1,1}; 
  static short NoiseLikeFlag=0, NoiseLikeFlag_old=0, First=1;
  static short noiselike_flag=0;   
  float T_energy_0[MAX_T_NUM]={1}; 
  float F_energy_0[MAX_F_NUM]={1}; 
  float gain_t[MAX_T_NUM];
  float ff_control, tt_control;
  float gain_f[MAX_F_NUM], gain_n;
  float *ptrReal, *ptrImag;
  float energy, energy1, gain, gain1, tiltcomp;
  int k, l;
  int noSubbands=(End_HB-Start_HB);      
  
  if (noSubframes>MAX_T_NUM || noSubbands>MAX_F_NUM || i_spec>=MAX_SPEC_NUM) {
    printf(" Error: memory size is not enough ! noSubframes>MAX_T_NUM || noSubbands>MAX_F_NUM || i_spec>=MAX_SPEC_NUM !!!!\n");
    exit(0);
  }
  
  /************/
  /*  Initial */
  /************/
  if (First) {
    for (k=0; k<64; k++) {
      F_energy_sm[k]=1;
    }
    f_control[0]=0.05f; 
    t_control[0]=0.05f; 
    f_control[1]=0.1f;  
    t_control[1]=0.1f;	
    First=0;
  }
  
  /**************************************/
  /* calculate current TF energy arrays */
  /**************************************/
  for (k = 0; k < noSubbands; k++) {
    F_energy_0[k]=1;
  }
  
  for (l=0;l<noSubframes;l++) {
    T_energy_0[l]=1;
    ptrReal = *(Real+l) + Start_HB; 
    ptrImag = *(Imag+l) + Start_HB;

    for (k = 0; k < noSubbands; k++) {
      energy = SQR(*ptrReal) + SQR(*ptrImag); 
      T_energy_0[l] += energy; 
      F_energy_0[k] += energy;
      ptrReal++;
      ptrImag++;
    }
    T_energy_0[l] *= (1.f/noSubbands); 
  }
 
  for (k = 0; k < noSubbands; k++) {
    F_energy_0[k] *= (1.f/noSubframes);   
    F_energy_sm[k+Start_HB] = (F_energy_sm[k+Start_HB] + F_energy_0[k])/2; 
  }
  
  /*************************************/
  /* noise like signal NoiseLikeFlag   */
  /*************************************/
  if (i_spec==0) {
    NoiseLikeFlag_old=NoiseLikeFlag;
    if (tf_class<0.7) NoiseLikeFlag = 0;
    if (tf_class>1.5) NoiseLikeFlag = 1;
    if (noiselike_flag) NoiseLikeFlag = 2;
  }
  
  /********************************/
  /* estimate gain in F direction */
  /********************************/
  if (noiselike_flag==1) {
    for (k = 0; k < noSubbands; k++) {
      gain_f[k] = 1;
    }
  }
  else {
    energy=1;
    energy1=1;
    for (k = 0; k < noSubbands/2; k++) {
      energy  += F_energy_sm[k+Start_HB];   
      energy1 += F_energy_sm[k+noSubbands/2+Start_HB];  
    }
    if (energy1>=energy) {
      tiltcomp=0;
    }
    else {
      if (i_spec==0) {
        tiltcomp=8*f_control[i_spec]*(float)sqrt((energy-energy1)/(energy+energy1));
      } else {
        tiltcomp=4*f_control[i_spec]*(float)sqrt((energy-energy1)/(energy+energy1));
      }
      if (tiltcomp>1) {
        tiltcomp=1;
      }
      tiltcomp *= (1.f/noSubbands);  
    }
    
    if (NoiseLikeFlag==0) {
      ff_control=f_control[i_spec];
    }
    else {
      ff_control=f_control[i_spec]*0.7f;
    }
    for (k = 0; k < noSubbands; k++) {
      gain_f[k] = (float)pow(F_energy_sm[k+Start_HB],ff_control); /* initial gain in F */
    }
    if (tiltcomp>0) {
      for (k = 0; k < noSubbands; k++) {
        gain_f[k] *= (1+k*tiltcomp);  
      }
    }
  }
  
  /********************************/
  /* estimate gain in T direction */
  /********************************/
  if (NoiseLikeFlag ==0) {
    tt_control=t_control[i_spec];
  } else { 
    tt_control=t_control[i_spec]*0.5f;
  }
  if (NoiseLikeFlag_old==0 && NoiseLikeFlag>0) {
    T_energy_1_sm[i_spec] = 0.2f*T_energy_1_sm[i_spec] + 0.8f*T_energy_0_sm[i_spec];
  }
  if (NoiseLikeFlag_old>0 && NoiseLikeFlag==0) {
    T_energy_1_sm[i_spec] *= 8;
  }
  
  for (l=0;l<noSubframes;l++) {
    if ( (T_energy_0[l]>T_energy_sm[i_spec]*8) || (T_energy_0[l]<T_energy_sm[i_spec]/16) ) {
      T_energy_sm[i_spec] = T_energy_0[l];
    }
    else if ( (T_energy_0[l]>T_energy_sm[i_spec]*4) || (T_energy_0[l]<T_energy_sm[i_spec]/8) ) {
      T_energy_sm[i_spec] = (T_energy_sm[i_spec] + T_energy_0[l])/2;
    }
    else {
      T_energy_sm[i_spec] = (3*T_energy_sm[i_spec] + T_energy_0[l])/4;
    }
    gain_t[l] = (float)pow(T_energy_sm[i_spec],tt_control); /* initial gain in T */
  }
	
	
  /*****************************/
  /* Apply two dimension gains */
  /*****************************/
  if (noiselike_flag==0) {
    for (l=0;l<noSubframes;l++) {
      ptrReal = *(Real+l) + Start_HB; 
      ptrImag = *(Imag+l) + Start_HB;
      
      energy1=1;
      for (k = 0; k < noSubbands; k++) {
        energy = SQR(ptrReal[k]) + SQR(ptrImag[k]); 
        energy1 += energy*SQR(gain_f[k]);
      }
      energy1 *= (1.f/noSubbands);
      T_energy_0_sm[i_spec] = (31*T_energy_0_sm[i_spec] + T_energy_0[l])/32;
      T_energy_1_sm[i_spec] = (31*T_energy_1_sm[i_spec] + T_energy_0[l]*SQR(gain_t[l]))/32;	
      gain_n =(float)sqrt(T_energy_0[l]*T_energy_0_sm[i_spec]/(energy1*T_energy_1_sm[i_spec]+1)); /* normalization gain */
      gain1 = gain_t[l]*gain_n;
      
      /* apply gains */
      for (k = 0; k < noSubbands; k++) {
	
        gain = gain_f[k]*gain1;  
        if (gain<0.6f) {
          gain=0.6f;
        }
        if (gain>1.1f) {
          gain=1.1f;
        }
        (*ptrReal) *= gain;
        (*ptrImag) *= gain;
        ptrReal++;
        ptrImag++;
      }
    }
  }	
  else {
    for (l=0;l<noSubframes;l++) {
      T_energy_0_sm[i_spec] = (31*T_energy_0_sm[i_spec] + T_energy_0[l])/32;
      T_energy_1_sm[i_spec] = (31*T_energy_1_sm[i_spec] + T_energy_0[l]*SQR(gain_t[l]))/32;
    }
  }
}

#endif /* HUAWEI_TFPP_DEC */

#ifdef SONY_PVC_DEC
extern	float	LastEnvNoiseLevel[8][MAX_NUM_NOISE_VALUES];
extern	int nNfb_global;
float	PrevLastEnvNoiseLevel[8][MAX_NUM_NOISE_VALUES];
int     Prev_nNfb;
static float QMapped_sony[MAX_NUM_CHANNELS][64][48];

#endif /* SONY_PVC_DEC */

static const float limGains[4] = { 0.70795f, 1.0f, 1.41254f, 1e10f };

static const int smoothLengths[2] = { 4, 0 };

typedef const float FIR_FILTER[5];
static FIR_FILTER fir_0 = {1.0f};
static FIR_FILTER fir_1 = {0.33333333333333f,0.66666666666666f};
static FIR_FILTER fir_2 = {0.12500000000000f,0.37500000000000f,0.50000000000000f};
static FIR_FILTER fir_3 = {0.05857864376269f,0.20000000000000f,0.34142135623731f,0.40000000000000f};
static FIR_FILTER fir_4 = {0.03183050093751f,0.11516383427084f,0.21816949906249f,0.30150283239582f,0.33333333333333f};
static FIR_FILTER *fir_table[5] = {&fir_0,&fir_1,&fir_2,&fir_3,&fir_4};

extern struct PATCH Patch[MAX_NUM_CHANNELS];

static void
createLimiterBands (int limSbc[4][12 + 1],
                    int gateMode[4],
                    int *freqTable,
                    int noBands,
                    int ch,
                    int xOverQmf[MAX_NUM_PATCHES],
                    int bPatchingMode,
                    int bSbr41
                    );

static const float rP[512][2] = {
  {-0.99948153278296f, -0.59483417516607f},
  {0.97113454393991f, -0.67528515225647f},
  {0.14130051758487f, -0.95090983575689f},
  {-0.47005496701697f, -0.37340549728647f},
  {0.80705063769351f, 0.29653668284408f},
  {-0.38981478896926f, 0.89572605717087f},
  {-0.01053049862020f, -0.66959058036166f},
  {-0.91266367957293f, -0.11522938140034f},
  {0.54840422910309f, 0.75221367176302f},
  {0.40009252867955f, -0.98929400334421f},
  {-0.99867974711855f, -0.88147068645358f},
  {-0.95531076805040f, 0.90908757154593f},
  {-0.45725933317144f, -0.56716323646760f},
  {-0.72929675029275f, -0.98008272727324f},
  {0.75622801399036f, 0.20950329995549f},
  {0.07069442601050f, -0.78247898470706f},
  {0.74496252926055f, -0.91169004445807f},
  {-0.96440182703856f, -0.94739918296622f},
  {0.30424629369539f, -0.49438267012479f},
  {0.66565033746925f, 0.64652935542491f},
  {0.91697008020594f, 0.17514097332009f},
  {-0.70774918760427f, 0.52548653416543f},
  {-0.70051415345560f, -0.45340028808763f},
  {-0.99496513054797f, -0.90071908066973f},
  {0.98164490790123f, -0.77463155528697f},
  {-0.54671580548181f, -0.02570928536004f},
  {-0.01689629065389f, 0.00287506445732f},
  {-0.86110349531986f, 0.42548583726477f},
  {-0.98892980586032f, -0.87881132267556f},
  {0.51756627678691f, 0.66926784710139f},
  {-0.99635026409640f, -0.58107730574765f},
  {-0.99969370862163f, 0.98369989360250f},
  {0.55266258627194f, 0.59449057465591f},
  {0.34581177741673f, 0.94879421061866f},
  {0.62664209577999f, -0.74402970906471f},
  {-0.77149701404973f, -0.33883658042801f},
  {-0.91592244254432f, 0.03687901376713f},
  {-0.76285492357887f, -0.91371867919124f},
  {0.79788337195331f, -0.93180971199849f},
  {0.54473080610200f, -0.11919206037186f},
  {-0.85639281671058f, 0.42429854760451f},
  {-0.92882402971423f, 0.27871809078609f},
  {-0.11708371046774f, -0.99800843444966f},
  {0.21356749817493f, -0.90716295627033f},
  {-0.76191692573909f, 0.99768118356265f},
  {0.98111043100884f, -0.95854459734407f},
  {-0.85913269895572f, 0.95766566168880f},
  {-0.93307242253692f, 0.49431757696466f},
  {0.30485754879632f, -0.70540034357529f},
  {0.85289650925190f, 0.46766131791044f},
  {0.91328082618125f, -0.99839597361769f},
  {-0.05890199924154f, 0.70741827819497f},
  {0.28398686150148f, 0.34633555702188f},
  {0.95258164539612f, -0.54893416026939f},
  {-0.78566324168507f, -0.75568541079691f},
  {-0.95789495447877f, -0.20423194696966f},
  {0.82411158711197f, 0.96654618432562f},
  {-0.65185446735885f, -0.88734990773289f},
  {-0.93643603134666f, 0.99870790442385f},
  {0.91427159529618f, -0.98290505544444f},
  {-0.70395684036886f, 0.58796798221039f},
  {0.00563771969365f, 0.61768196727244f},
  {0.89065051931895f, 0.52783352697585f},
  {-0.68683707712762f, 0.80806944710339f},
  {0.72165342518718f, -0.69259857349564f},
  {-0.62928247730667f, 0.13627037407335f},
  {0.29938434065514f, -0.46051329682246f},
  {-0.91781958879280f, -0.74012716684186f},
  {0.99298717043688f, 0.40816610075661f},
  {0.82368298622748f, -0.74036047190173f},
  {-0.98512833386833f, -0.99972330709594f},
  {-0.95915368242257f, -0.99237800466040f},
  {-0.21411126572790f, -0.93424819052545f},
  {-0.68821476106884f, -0.26892306315457f},
  {0.91851997982317f, 0.09358228901785f},
  {-0.96062769559127f, 0.36099095133739f},
  {0.51646184922287f, -0.71373332873917f},
  {0.61130721139669f, 0.46950141175917f},
  {0.47336129371299f, -0.27333178296162f},
  {0.90998308703519f, 0.96715662938132f},
  {0.44844799194357f, 0.99211574628306f},
  {0.66614891079092f, 0.96590176169121f},
  {0.74922239129237f, -0.89879858826087f},
  {-0.99571588506485f, 0.52785521494349f},
  {0.97401082477563f, -0.16855870075190f},
  {0.72683747733879f, -0.48060774432251f},
  {0.95432193457128f, 0.68849603408441f},
  {-0.72962208425191f, -0.76608443420917f},
  {-0.85359479233537f, 0.88738125901579f},
  {-0.81412430338535f, -0.97480768049637f},
  {-0.87930772356786f, 0.74748307690436f},
  {-0.71573331064977f, -0.98570608178923f},
  {0.83524300028228f, 0.83702537075163f},
  {-0.48086065601423f, -0.98848504923531f},
  {0.97139128574778f, 0.80093621198236f},
  {0.51992825347895f, 0.80247631400510f},
  {-0.00848591195325f, -0.76670128000486f},
  {-0.70294374303036f, 0.55359910445577f},
  {-0.95894428168140f, -0.43265504344783f},
  {0.97079252950321f, 0.09325857238682f},
  {-0.92404293670797f, 0.85507704027855f},
  {-0.69506469500450f, 0.98633412625459f},
  {0.26559203620024f, 0.73314307966524f},
  {0.28038443336943f, 0.14537913654427f},
  {-0.74138124825523f, 0.99310339807762f},
  {-0.01752795995444f, -0.82616635284178f},
  {-0.55126773094930f, -0.98898543862153f},
  {0.97960898850996f, -0.94021446752851f},
  {-0.99196309146936f, 0.67019017358456f},
  {-0.67684928085260f, 0.12631491649378f},
  {0.09140039465500f, -0.20537731453108f},
  {-0.71658965751996f, -0.97788200391224f},
  {0.81014640078925f, 0.53722648362443f},
  {0.40616991671205f, -0.26469008598449f},
  {-0.67680188682972f, 0.94502052337695f},
  {0.86849774348749f, -0.18333598647899f},
  {-0.99500381284851f, -0.02634122068550f},
  {0.84329189340667f, 0.10406957462213f},
  {-0.09215968531446f, 0.69540012101253f},
  {0.99956173327206f, -0.12358542001404f},
  {-0.79732779473535f, -0.91582524736159f},
  {0.96349973642406f, 0.96640458041000f},
  {-0.79942778496547f, 0.64323902822857f},
  {-0.11566039853896f, 0.28587846253726f},
  {-0.39922954514662f, 0.94129601616966f},
  {0.99089197565987f, -0.92062625581587f},
  {0.28631285179909f, -0.91035047143603f},
  {-0.83302725605608f, -0.67330410892084f},
  {0.95404443402072f, 0.49162765398743f},
  {-0.06449863579434f, 0.03250560813135f},
  {-0.99575054486311f, 0.42389784469507f},
  {-0.65501142790847f, 0.82546114655624f},
  {-0.81254441908887f, -0.51627234660629f},
  {-0.99646369485481f, 0.84490533520752f},
  {0.00287840603348f, 0.64768261158166f},
  {0.70176989408455f, -0.20453028573322f},
  {0.96361882270190f, 0.40706967140989f},
  {-0.68883758192426f, 0.91338958840772f},
  {-0.34875585502238f, 0.71472290693300f},
  {0.91980081243087f, 0.66507455644919f},
  {-0.99009048343881f, 0.85868021604848f},
  {0.68865791458395f, 0.55660316809678f},
  {-0.99484402129368f, -0.20052559254934f},
  {0.94214511408023f, -0.99696425367461f},
  {-0.67414626793544f, 0.49548221180078f},
  {-0.47339353684664f, -0.85904328834047f},
  {0.14323651387360f, -0.94145598222488f},
  {-0.29268293575672f, 0.05759224927952f},
  {0.43793861458754f, -0.78904969892724f},
  {-0.36345126374441f, 0.64874435357162f},
  {-0.08750604656825f, 0.97686944362527f},
  {-0.96495267812511f, -0.53960305946511f},
  {0.55526940659947f, 0.78891523734774f},
  {0.73538215752630f, 0.96452072373404f},
  {-0.30889773919437f, -0.80664389776860f},
  {0.03574995626194f, -0.97325616900959f},
  {0.98720684660488f, 0.48409133691962f},
  {-0.81689296271203f, -0.90827703628298f},
  {0.67866860118215f, 0.81284503870856f},
  {-0.15808569732583f, 0.85279555024382f},
  {0.80723395114371f, -0.24717418514605f},
  {0.47788757329038f, -0.46333147839295f},
  {0.96367554763201f, 0.38486749303242f},
  {-0.99143875716818f, -0.24945277239809f},
  {0.83081876925833f, -0.94780851414763f},
  {-0.58753191905341f, 0.01290772389163f},
  {0.95538108220960f, -0.85557052096538f},
  {-0.96490920476211f, -0.64020970923102f},
  {-0.97327101028521f, 0.12378128133110f},
  {0.91400366022124f, 0.57972471346930f},
  {-0.99925837363824f, 0.71084847864067f},
  {-0.86875903507313f, -0.20291699203564f},
  {-0.26240034795124f, -0.68264554369108f},
  {-0.24664412953388f, -0.87642273115183f},
  {0.02416275806869f, 0.27192914288905f},
  {0.82068619590515f, -0.85087787994476f},
  {0.88547373760759f, -0.89636802901469f},
  {-0.18173078152226f, -0.26152145156800f},
  {0.09355476558534f, 0.54845123045604f},
  {-0.54668414224090f, 0.95980774020221f},
  {0.37050990604091f, -0.59910140383171f},
  {-0.70373594262891f, 0.91227665827081f},
  {-0.34600785879594f, -0.99441426144200f},
  {-0.68774481731008f, -0.30238837956299f},
  {-0.26843291251234f, 0.83115668004362f},
  {0.49072334613242f, -0.45359708737775f},
  {0.38975993093975f, 0.95515358099121f},
  {-0.97757125224150f, 0.05305894580606f},
  {-0.17325552859616f, -0.92770672250494f},
  {0.99948035025744f, 0.58285545563426f},
  {-0.64946246527458f, 0.68645507104960f},
  {-0.12016920576437f, -0.57147322153312f},
  {-0.58947456517751f, -0.34847132454388f},
  {-0.41815140454465f, 0.16276422358861f},
  {0.99885650204884f, 0.11136095490444f},
  {-0.56649614128386f, -0.90494866361587f},
  {0.94138021032330f, 0.35281916733018f},
  {-0.75725076534641f, 0.53650549640587f},
  {0.20541973692630f, -0.94435144369918f},
  {0.99980371023351f, 0.79835913565599f},
  {0.29078277605775f, 0.35393777921520f},
  {-0.62858772103030f, 0.38765693387102f},
  {0.43440904467688f, -0.98546330463232f},
  {-0.98298583762390f, 0.21021524625209f},
  {0.19513029146934f, -0.94239832251867f},
  {-0.95476662400101f, 0.98364554179143f},
  {0.93379635304810f, -0.70881994583682f},
  {-0.85235410573336f, -0.08342347966410f},
  {-0.86425093011245f, -0.45795025029466f},
  {0.38879779059045f, 0.97274429344593f},
  {0.92045124735495f, -0.62433652524220f},
  {0.89162532251878f, 0.54950955570563f},
  {-0.36834336949252f, 0.96458298020975f},
  {0.93891760988045f, -0.89968353740388f},
  {0.99267657565094f, -0.03757034316958f},
  {-0.94063471614176f, 0.41332338538963f},
  {0.99740224117019f, -0.16830494996370f},
  {-0.35899413170555f, -0.46633226649613f},
  {0.05237237274947f, -0.25640361602661f},
  {0.36703583957424f, -0.38653265641875f},
  {0.91653180367913f, -0.30587628726597f},
  {0.69000803499316f, 0.90952171386132f},
  {-0.38658751133527f, 0.99501571208985f},
  {-0.29250814029851f, 0.37444994344615f},
  {-0.60182204677608f, 0.86779651036123f},
  {-0.97418588163217f, 0.96468523666475f},
  {0.88461574003963f, 0.57508405276414f},
  {0.05198933055162f, 0.21269661669964f},
  {-0.53499621979720f, 0.97241553731237f},
  {-0.49429560226497f, 0.98183865291903f},
  {-0.98935142339139f, -0.40249159006933f},
  {-0.98081380091130f, -0.72856895534041f},
  {-0.27338148835532f, 0.99950922447209f},
  {0.06310802338302f, -0.54539587529618f},
  {-0.20461677199539f, -0.14209977628489f},
  {0.66223843141647f, 0.72528579940326f},
  {-0.84764345483665f, 0.02372316801261f},
  {-0.89039863483811f, 0.88866581484602f},
  {0.95903308477986f, 0.76744927173873f},
  {0.73504123909879f, -0.03747203173192f},
  {-0.31744434966056f, -0.36834111883652f},
  {-0.34110827591623f, 0.40211222807691f},
  {0.47803883714199f, -0.39423219786288f},
  {0.98299195879514f, 0.01989791390047f},
  {-0.30963073129751f, -0.18076720599336f},
  {0.99992588229018f, -0.26281872094289f},
  {-0.93149731080767f, -0.98313162570490f},
  {0.99923472302773f, -0.80142993767554f},
  {-0.26024169633417f, -0.75999759855752f},
  {-0.35712514743563f, 0.19298963768574f},
  {-0.99899084509530f, 0.74645156992493f},
  {0.86557171579452f, 0.55593866696299f},
  {0.33408042438752f, 0.86185953874709f},
  {0.99010736374716f, 0.04602397576623f},
  {-0.66694269691195f, -0.91643611810148f},
  {0.64016792079480f, 0.15649530836856f},
  {0.99570534804836f, 0.45844586038111f},
  {-0.63431466947340f, 0.21079116459234f},
  {-0.07706847005931f, -0.89581437101329f},
  {0.98590090577724f, 0.88241721133981f},
  {0.80099335254678f, -0.36851896710853f},
  {0.78368131392666f, 0.45506999802597f},
  {0.08707806671691f, 0.80938994918745f},
  {-0.86811883080712f, 0.39347308654705f},
  {-0.39466529740375f, -0.66809432114456f},
  {0.97875325649683f, -0.72467840967746f},
  {-0.95038560288864f, 0.89563219587625f},
  {0.17005239424212f, 0.54683053962658f},
  {-0.76910792026848f, -0.96226617549298f},
  {0.99743281016846f, 0.42697157037567f},
  {0.95437383549973f, 0.97002324109952f},
  {0.99578905365569f, -0.54106826257356f},
  {0.28058259829990f, -0.85361420634036f},
  {0.85256524470573f, -0.64567607735589f},
  {-0.50608540105128f, -0.65846015480300f},
  {-0.97210735183243f, -0.23095213067791f},
  {0.95424048234441f, -0.99240147091219f},
  {-0.96926570524023f, 0.73775654896574f},
  {0.30872163214726f, 0.41514960556126f},
  {-0.24523839572639f, 0.63206633394807f},
  {-0.33813265086024f, -0.38661779441897f},
  {-0.05826828420146f, -0.06940774188029f},
  {-0.22898461455054f, 0.97054853316316f},
  {-0.18509915019881f, 0.47565762892084f},
  {-0.10488238045009f, -0.87769947402394f},
  {-0.71886586182037f, 0.78030982480538f},
  {0.99793873738654f, 0.90041310491497f},
  {0.57563307626120f, -0.91034337352097f},
  {0.28909646383717f, 0.96307783970534f},
  {0.42188998312520f, 0.48148651230437f},
  {0.93335049681047f, -0.43537023883588f},
  {-0.97087374418267f, 0.86636445711364f},
  {0.36722871286923f, 0.65291654172961f},
  {-0.81093025665696f, 0.08778370229363f},
  {-0.26240603062237f, -0.92774095379098f},
  {0.83996497984604f, 0.55839849139647f},
  {-0.99909615720225f, -0.96024605713970f},
  {0.74649464155061f, 0.12144893606462f},
  {-0.74774595569805f, -0.26898062008959f},
  {0.95781667469567f, -0.79047927052628f},
  {0.95472308713099f, -0.08588776019550f},
  {0.48708332746299f, 0.99999041579432f},
  {0.46332038247497f, 0.10964126185063f},
  {-0.76497004940162f, 0.89210929242238f},
  {0.57397389364339f, 0.35289703373760f},
  {0.75374316974495f, 0.96705214651335f},
  {-0.59174397685714f, -0.89405370422752f},
  {0.75087906691890f, -0.29612672982396f},
  {-0.98607857336230f, 0.25034911730023f},
  {-0.40761056640505f, -0.90045573444695f},
  {0.66929266740477f, 0.98629493401748f},
  {-0.97463695257310f, -0.00190223301301f},
  {0.90145509409859f, 0.99781390365446f},
  {-0.87259289048043f, 0.99233587353666f},
  {-0.91529461447692f, -0.15698707534206f},
  {-0.03305738840705f, -0.37205262859764f},
  {0.07223051368337f, -0.88805001733626f},
  {0.99498012188353f, 0.97094358113387f},
  {-0.74904939500519f, 0.99985483641521f},
  {0.04585228574211f, 0.99812337444082f},
  {-0.89054954257993f, -0.31791913188064f},
  {-0.83782144651251f, 0.97637632547466f},
  {0.33454804933804f, -0.86231516800408f},
  {-0.99707579362824f, 0.93237990079441f},
  {-0.22827527843994f, 0.18874759397997f},
  {0.67248046289143f, -0.03646211390569f},
  {-0.05146538187944f, -0.92599700120679f},
  {0.99947295749905f, 0.93625229707912f},
  {0.66951124390363f, 0.98905825623893f},
  {-0.99602956559179f, -0.44654715757688f},
  {0.82104905483590f, 0.99540741724928f},
  {0.99186510988782f, 0.72023001312947f},
  {-0.65284592392918f, 0.52186723253637f},
  {0.93885443798188f, -0.74895312615259f},
  {0.96735248738388f, 0.90891816978629f},
  {-0.22225968841114f, 0.57124029781228f},
  {-0.44132783753414f, -0.92688840659280f},
  {-0.85694974219574f, 0.88844532719844f},
  {0.91783042091762f, -0.46356892383970f},
  {0.72556974415690f, -0.99899555770747f},
  {-0.99711581834508f, 0.58211560180426f},
  {0.77638976371966f, 0.94321834873819f},
  {0.07717324253925f, 0.58638399856595f},
  {-0.56049829194163f, 0.82522301569036f},
  {0.98398893639988f, 0.39467440420569f},
  {0.47546946844938f, 0.68613044836811f},
  {0.65675089314631f, 0.18331637134880f},
  {0.03273375457980f, -0.74933109564108f},
  {-0.38684144784738f, 0.51337349030406f},
  {-0.97346267944545f, -0.96549364384098f},
  {-0.53282156061942f, -0.91423265091354f},
  {0.99817310731176f, 0.61133572482148f},
  {-0.50254500772635f, -0.88829338134294f},
  {0.01995873238855f, 0.85223515096765f},
  {0.99930381973804f, 0.94578896296649f},
  {0.82907767600783f, -0.06323442598128f},
  {-0.58660709669728f, 0.96840773806582f},
  {-0.17573736667267f, -0.48166920859485f},
  {0.83434292401346f, -0.13023450646997f},
  {0.05946491307025f, 0.20511047074866f},
  {0.81505484574602f, -0.94685947861369f},
  {-0.44976380954860f, 0.40894572671545f},
  {-0.89746474625671f, 0.99846578838537f},
  {0.39677256130792f, -0.74854668609359f},
  {-0.07588948563079f, 0.74096214084170f},
  {0.76343198951445f, 0.41746629422634f},
  {-0.74490104699626f, 0.94725911744610f},
  {0.64880119792759f, 0.41336660830571f},
  {0.62319537462542f, -0.93098313552599f},
  {0.42215817594807f, -0.07712787385208f},
  {0.02704554141885f, -0.05417518053666f},
  {0.80001773566818f, 0.91542195141039f},
  {-0.79351832348816f, -0.36208897989136f},
  {0.63872359151636f, 0.08128252493444f},
  {0.52890520960295f, 0.60048872455592f},
  {0.74238552914587f, 0.04491915291044f},
  {0.99096131449250f, -0.19451182854402f},
  {-0.80412329643109f, -0.88513818199457f},
  {-0.64612616129736f, 0.72198674804544f},
  {0.11657770663191f, -0.83662833815041f},
  {-0.95053182488101f, -0.96939905138082f},
  {-0.62228872928622f, 0.82767262846661f},
  {0.03004475787316f, -0.99738896333384f},
  {-0.97987214341034f, 0.36526129686425f},
  {-0.99986980746200f, -0.36021610299715f},
  {0.89110648599879f, -0.97894250343044f},
  {0.10407960510582f, 0.77357793811619f},
  {0.95964737821728f, -0.35435818285502f},
  {0.50843233159162f, 0.96107691266205f},
  {0.17006334670615f, -0.76854025314829f},
  {0.25872675063360f, 0.99893303933816f},
  {-0.01115998681937f, 0.98496019742444f},
  {-0.79598702973261f, 0.97138411318894f},
  {-0.99264708948101f, -0.99542822402536f},
  {-0.99829663752818f, 0.01877138824311f},
  {-0.70801016548184f, 0.33680685948117f},
  {-0.70467057786826f, 0.93272777501857f},
  {0.99846021905254f, -0.98725746254433f},
  {-0.63364968534650f, -0.16473594423746f},
  {-0.16258217500792f, -0.95939125400802f},
  {-0.43645594360633f, -0.94805030113284f},
  {-0.99848471702976f, 0.96245166923809f},
  {-0.16796458968998f, -0.98987511890470f},
  {-0.87979225745213f, -0.71725725041680f},
  {0.44183099021786f, -0.93568974498761f},
  {0.93310180125532f, -0.99913308068246f},
  {-0.93941931782002f, -0.56409379640356f},
  {-0.88590003188677f, 0.47624600491382f},
  {0.99971463703691f, -0.83889954253462f},
  {-0.75376385639978f, 0.00814643438625f},
  {0.93887685615875f, -0.11284528204636f},
  {0.85126435782309f, 0.52349251543547f},
  {0.39701421446381f, 0.81779634174316f},
  {-0.37024464187437f, -0.87071656222959f},
  {-0.36024828242896f, 0.34655735648287f},
  {-0.93388812549209f, -0.84476541096429f},
  {-0.65298804552119f, -0.18439575450921f},
  {0.11960319006843f, 0.99899346780168f},
  {0.94292565553160f, 0.83163906518293f},
  {0.75081145286948f, -0.35533223142265f},
  {0.56721979748394f, -0.24076836414499f},
  {0.46857766746029f, -0.30140233457198f},
  {0.97312313923635f, -0.99548191630031f},
  {-0.38299976567017f, 0.98516909715427f},
  {0.41025800019463f, 0.02116736935734f},
  {0.09638062008048f, 0.04411984381457f},
  {-0.85283249275397f, 0.91475563922421f},
  {0.88866808958124f, -0.99735267083226f},
  {-0.48202429536989f, -0.96805608884164f},
  {0.27572582416567f, 0.58634753335832f},
  {-0.65889129659168f, 0.58835634138583f},
  {0.98838086953732f, 0.99994349600236f},
  {-0.20651349620689f, 0.54593044066355f},
  {-0.62126416356920f, -0.59893681700392f},
  {0.20320105410437f, -0.86879180355289f},
  {-0.97790548600584f, 0.96290806999242f},
  {0.11112534735126f, 0.21484763313301f},
  {-0.41368337314182f, 0.28216837680365f},
  {0.24133038992960f, 0.51294362630238f},
  {-0.66393410674885f, -0.08249679629081f},
  {-0.53697829178752f, -0.97649903936228f},
  {-0.97224737889348f, 0.22081333579837f},
  {0.87392477144549f, -0.12796173740361f},
  {0.19050361015753f, 0.01602615387195f},
  {-0.46353441212724f, -0.95249041539006f},
  {-0.07064096339021f, -0.94479803205886f},
  {-0.92444085484466f, -0.10457590187436f},
  {-0.83822593578728f, -0.01695043208885f},
  {0.75214681811150f, -0.99955681042665f},
  {-0.42102998829339f, 0.99720941999394f},
  {-0.72094786237696f, -0.35008961934255f},
  {0.78843311019251f, 0.52851398958271f},
  {0.97394027897442f, -0.26695944086561f},
  {0.99206463477946f, -0.57010120849429f},
  {0.76789609461795f, -0.76519356730966f},
  {-0.82002421836409f, -0.73530179553767f},
  {0.81924990025724f, 0.99698425250579f},
  {-0.26719850873357f, 0.68903369776193f},
  {-0.43311260380975f, 0.85321815947490f},
  {0.99194979673836f, 0.91876249766422f},
  {-0.80692001248487f, -0.32627540663214f},
  {0.43080003649976f, -0.21919095636638f},
  {0.67709491937357f, -0.95478075822906f},
  {0.56151770568316f, -0.70693811747778f},
  {0.10831862810749f, -0.08628837174592f},
  {0.91229417540436f, -0.65987351408410f},
  {-0.48972893932274f, 0.56289246362686f},
  {-0.89033658689697f, -0.71656563987082f},
  {0.65269447475094f, 0.65916004833932f},
  {0.67439478141121f, -0.81684380846796f},
  {-0.47770832416973f, -0.16789556203025f},
  {-0.99715979260878f, -0.93565784007648f},
  {-0.90889593602546f, 0.62034397054380f},
  {-0.06618622548177f, -0.23812217221359f},
  {0.99430266919728f, 0.18812555317553f},
  {0.97686402381843f, -0.28664534366620f},
  {0.94813650221268f, -0.97506640027128f},
  {-0.95434497492853f, -0.79607978501983f},
  {-0.49104783137150f, 0.32895214359663f},
  {0.99881175120751f, 0.88993983831354f},
  {0.50449166760303f, -0.85995072408434f},
  {0.47162891065108f, -0.18680204049569f},
  {-0.62081581361840f, 0.75000676218956f},
  {-0.43867015250812f, 0.99998069244322f},
  {0.98630563232075f, -0.53578899600662f},
  {-0.61510362277374f, -0.89515019899997f},
  {-0.03841517601843f, -0.69888815681179f},
  {-0.30102157304644f, -0.07667808922205f},
  {0.41881284182683f, 0.02188098922282f},
  {-0.86135454941237f, 0.98947480909359f},
  {0.67226861393788f, -0.13494389011014f},
  {-0.70737398842068f, -0.76547349325992f},
  {0.94044946687963f, 0.09026201157416f},
  {-0.82386352534327f, 0.08924768823676f},
  {-0.32070666698656f, 0.50143421908753f},
  {0.57593163224487f, -0.98966422921509f},
  {-0.36326018419965f, 0.07440243123228f},
  {0.99979044674350f, -0.14130287347405f},
  {-0.92366023326932f, -0.97979298068180f},
  {-0.44607178518598f, -0.54233252016394f},
  {0.44226800932956f, 0.71326756742752f},
  {0.03671907158312f, 0.63606389366675f},
  {0.52175424682195f, -0.85396826735705f},
  {-0.94701139690956f, -0.01826348194255f},
  {-0.98759606946049f, 0.82288714303073f},
  {0.87434794743625f, 0.89399495655433f},
  {-0.93412041758744f, 0.41374052024363f},
  {0.96063943315511f, 0.93116709541280f},
  {0.97534253457837f, 0.86150930812689f},
  {0.99642466504163f, 0.70190043427512f},
  {-0.94705089665984f, -0.29580042814306f},
  {0.91599807087376f, -0.98147830385781f}
};

static const int freqInv[64]=
{ 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1,
  1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1
};

static const float hPhase [2][8] = {
  { 1.0f, 0.0f, -1.0f,  0.0f},
  { 0.0f, 1.0f,  0.0f, -1.0f}
};

static int prevSbrPatchingMode; 

static void apply_inter_tes(
                float *codecQmfReal,
                float *codecQmfImag,
                float *qmfReal,
                float *qmfImag,
                int nbSubsample,
                int lowSubband,
                int nbSubband,
                int gamma_idx
                );

static const float q_gamma_table[4] = {0.0f, 1.0f, 2.0f, 4.0f};

#ifdef LOW_POWER_SBR
/*******************************************************************************
 Functionname:  aliasingReduction
 *******************************************************************************
 Description:   
 Arguments:     
                 
 Return:        none
*******************************************************************************/
static
void aliasingReduction(float* degreeAlias,
                       float* nrg_gain,
                       float* nrg_est,
                       int* dontUseTheseGainValues,
                       int noSubbands,
                       int lowSubband)
{
  float est_total, ref_total, newGain, bst;
  int group, grouping = 0, index = 0, noGroups, k;
  int groupVector[64];

  /* Calculate grouping*/
  for (k = 0; k < noSubbands-1; k++ ){
    if (degreeAlias[k + lowSubband + 1] && dontUseTheseGainValues[k] == 0) {
      if(grouping==0){
        groupVector[index] = k + lowSubband;
        grouping = 1;
        index++;
      }
    }
    else{
      if(grouping){
        if(dontUseTheseGainValues[k])
          groupVector[index] = k + lowSubband;
        else
          groupVector[index] = k + lowSubband + 1;
        grouping = 0;
        index++;
      }
    }
  }        

  if(grouping){
    groupVector[index] = noSubbands + lowSubband;
    index++;
  }
  noGroups = (int) (index/2.0f);



  /*Calculate new gain*/
  for (group = 0; group < noGroups; group ++) {

    int startGroup = groupVector[2*group]   - lowSubband;
    int stopGroup  = groupVector[2*group+1] - lowSubband;

    est_total = ref_total = 0;
    
    for(k = startGroup; k < stopGroup; k++){
      est_total += nrg_est[k];
      ref_total += nrg_est[k]*nrg_gain[k]*nrg_gain[k];
    }
    
    newGain = ref_total/(est_total+EPS);
    bst = EPS;

    for(k = startGroup; k < stopGroup; k++){
      float alpha;
      if(k < noSubbands - 1){
        alpha = degreeAlias[k+lowSubband + 1] > degreeAlias[k+lowSubband ] ? 
                    degreeAlias[k+lowSubband + 1] : degreeAlias[k+lowSubband ];
      }
      else{
        alpha = degreeAlias[k+lowSubband];
      }

      nrg_gain[k] = alpha*newGain + (1.0f-alpha)*nrg_gain[k]*nrg_gain[k];
      bst += nrg_gain[k] * nrg_est[k];
    }

    bst = ref_total / bst;
    for(k = startGroup; k < stopGroup; k++){
      nrg_gain[k] = (float) (sqrt(bst*nrg_gain[k]));

    }
  }
}
#endif




/*******************************************************************************
 Functionname:  calculateSbrEnvelope
 *******************************************************************************
 Description:   
 Arguments:     
                 
 Return:        none
*******************************************************************************/
void calculateSbrEnvelope(SBR_FRAME_DATA *frameData,
                          float aBufR[][64],
                          float aBufI[][64],
			  float codecBufR[][64],
			  float codecBufI[][64],
                          int freqBandTable1[2][MAX_FREQ_COEFFS + 1],
                          const int *nSfb,
                          int freqBandTable2[MAX_NOISE_COEFFS + 1],
                          int nNBands,
                          int reset,
#ifdef LOW_POWER_SBR
                          float *degreeAlias,
#endif
                          int ch,
                          int el,
                          int xOverQmf[MAX_NUM_PATCHES],
                          int bSbr41
#ifdef SONY_PVC_DEC
                          ,int	sbr_mode
                          ,float *pvcDecOut
                          ,int varlen
                          ,int prev_sbr_mode
#endif /* SONY_PVC_DEC */
                          )
{
  int n, c, li, ui, i, j, k = 0, l, m = 0, kk = 0, o,hF[64], next = -1,
      ui2,flag,tmp,noNoiseFlag, smooth_length;

#ifdef SONY_PVC_DEC
  float *ptrReal, *ptrImag, nrg = 0, p_ref, p_est, avg_gain,g_max, p_adj, boost_gain,sb_gain,sb_noise, temp[64];
  float env_tmp[64][48];
  int	t;
  int start_pos;
  int stop_pos;
  
  static int firstFlag = 1;
  int SlotId;
  
  float noise_level_sony[64][48];
  float nrg_est_sony[64][48];
  float nrg_ref_sony[64][48];
  float nrg_gain_sony[64][48];
  float nrg_tone_sony[64][48];
  
  float nrg_tone[64];
  float noise_level[64];
  float nrg_est[64];
  float nrg_ref[64];
  float nrg_gain[64];
  static int sUp_sony[MAXNRELEMENTS][MAX_NUM_CHANNELS];
  
  float pvcDecOutTmp[64][16];
  
#else /* SONY_PVC_DEC */
  float *ptrReal, *ptrImag, nrg = 0, p_ref, p_est, avg_gain,
    g_max, p_adj, boost_gain,sb_gain,sb_noise,nrg_tone[64],
    noise_level[64],nrg_est[64],nrg_ref[64],nrg_gain[64],temp[64];
#endif /* SONY_PVC_DEC */    
  
  const float *smoothFilter;
 
  float *sfb_nrg        = frameData->iEnvelope;
  float *nL             = frameData->sbrNoiseFloorLevel;
  const int *frame_info = frameData->frameInfo;

  const int *pvc_frame_info = frameData->pvc_frameInfo;
  int int_mode          = frameData->sbr_header.interpolFreq;
#ifdef LOW_POWER_SBR
  int smoothingLength   = 1;  /* no smoothing! */
#else
  int smoothingLength   = frameData->sbr_header.smoothingLength;
#endif
  int limiterBand       = frameData->sbr_header.limiterBands;
  int limiterGains      = frameData->sbr_header.limiterGains;
  int* addHarmonics     = frameData->addHarmonics;

  int lowSubband        = freqBandTable1[LOW_RES][0];
  int highSubband       = freqBandTable1[LOW_RES][nSfb[LOW_RES]];
  int noSubbands        = highSubband - lowSubband;
  int maxSmoothLength   = smoothLengths[0];
  int nEnv              = frame_info[0];
  int sEnv              = frame_info[2 * (nEnv + 1)];
  int p                 = frameData->p;

  static int masterInit[MAXNRELEMENTS] = {0};


  static int init[MAXNRELEMENTS][MAX_NUM_CHANNELS];
  static int harm_index[MAXNRELEMENTS][MAX_NUM_CHANNELS];
  static int phase_index[MAXNRELEMENTS][MAX_NUM_CHANNELS];
  static int hFp[MAXNRELEMENTS][MAX_NUM_CHANNELS][64];
  static int sUp[MAXNRELEMENTS][MAX_NUM_CHANNELS];
  static float fBuf[MAXNRELEMENTS][MAX_NUM_CHANNELS][5][64];
  static float fBufN[MAXNRELEMENTS][MAX_NUM_CHANNELS][5][64];
  static int limSbc[MAXNRELEMENTS][MAX_NUM_CHANNELS][4][12 + 1];
  static int gateMode[MAXNRELEMENTS][MAX_NUM_CHANNELS][4];

#ifdef SONY_PVC_DEC
  static int hFp_for_varlen[MAXNRELEMENTS][64];
  static int hF_for_varlen[MAXNRELEMENTS][64];
  int BandLoopEnd;
#endif /* SONY_PVC_DEC */


#ifdef LOW_POWER_SBR
  int tone_count;
  int dontUseTheseGainValues[64];
#endif

#if AAC_ELD
  int rate = frameData->rate;
#else
  int rate;
  if (bSbr41) {
    rate = frameData->rate;
  } else {
    rate = 2;
  }
#endif



  if(masterInit[el] == 0){
    for(i=0;i<MAX_NUM_CHANNELS;i++){
      init[el][i] = 0;
      harm_index[el][i] = 0;
      phase_index[el][i] = 0;
      sUp[el][i] = 1;
#ifdef SONY_PVC_DEC
      sUp_sony[el][i] = 1;
#endif /* SONY_PVC_DEC */
    }
    masterInit[el] = 1;
  }


  if(init[el][ch] == 0){
    init[el][ch] = 1;
    memset(hFp[el][ch],0,64*sizeof(int));
    frameData->prevEnvIsShort = -1;
  }

  if(reset){
    sUp[el][ch] = 1;
    sUp_sony[el][ch]=1;
    phase_index[el][ch] = 0;
    createLimiterBands (limSbc[el][ch],
                        gateMode[el][ch],
                        freqBandTable1[LOW_RES],
                        nSfb[LOW_RES],
                        ch,
                        xOverQmf,
                        frameData->sbrPatchingMode,
                        bSbr41
                        );
  }

  if(frameData->sbrPatchingMode != prevSbrPatchingMode) {
    createLimiterBands (limSbc[el][ch],
                        gateMode[el][ch],
                        freqBandTable1[LOW_RES],
                        nSfb[LOW_RES],
                        ch    
                        , xOverQmf,
                        frameData->sbrPatchingMode,
                        bSbr41
                        );

    prevSbrPatchingMode = frameData->sbrPatchingMode;
  }

  /* Mapping. */  
  memset(hF,0,64*sizeof(int));
  for(i = 0; i < nSfb[HI]; i++) {
    li = freqBandTable1[HI][i]-lowSubband;
    ui = freqBandTable1[HI][i+1]-lowSubband;
    tmp = (int)((float)(ui - li)/2.0f)+li;
    
    hF[tmp] = addHarmonics[i]; 
  }

#ifdef SONY_PVC_DEC
  if(sbr_mode == USE_PVC_SBR){
    /* Speech */
    for(t = 0; t < 16; t++){
      for(c = 0; c < 64; c++){
        pvcDecOutTmp[c][t] = pvcDecOut[64*t+c];
      }
    }
    /* copy varlen timeslots to the start of QMapped (frame_info[1]==varlen)*/
    for(t = 0; t < frame_info[1] ; t++) {
      for (c =0 ; c<64; c++) {
        QMapped_sony[ch][c][t] = QMapped_sony[ch][c][t + 16];
      }
    }
    
    /* build QMapped: QMapped should be calculated with legacy frame-info and applied with PVC-frame info */
    for (i = 0; i < nEnv; i++) {

      if (frame_info[1+i] == frame_info[2*nEnv+4+kk]) 
        kk++, next++;

      /* use legacy frame-info here: */
      start_pos = frame_info[i+1];
      stop_pos = frame_info[i+2];

      for(t = start_pos; t < stop_pos; t++) {
        
        BandLoopEnd = nSfb[frame_info[nEnv+2+i]];

        for (c = 0, o = 0,j = 0; j <  BandLoopEnd; j++) {

          li = freqBandTable1[frame_info[nEnv+2+i]][j];
          ui = freqBandTable1[frame_info[nEnv+2+i]][j + 1];          
          ui2 = freqBandTable2[o+1];

          for (k = 0; k < ui - li; k++) {
            o = (k+li>=ui2) ? o+1 : o;	
            ui2 = freqBandTable2[o+1];

            QMapped_sony[ch][c][t] = nL[next*nNBands+o];
            c++;
          }
        }
      }
    }
    /* now QMapped can be adressed with pvc-frame info */
    kk=0; next=-1; /* reset used vars */
  }
#endif /* SONY_PVC_DEC */

  /* Envelope adjustment. */
  for (i = 0; i < nEnv; i++) {

    if (frame_info[1+i] == frame_info[2*nEnv+4+kk])
      kk++, next++;

#ifdef SONY_PVC_DEC
    if(sbr_mode == USE_PVC_SBR){
      
      start_pos = pvc_frame_info[i+1];
      stop_pos = pvc_frame_info[i+2];
      
      /* Copy PVC Envelope Data */
      for(t = start_pos; t < stop_pos; t++){
        for(c = 0; c < 64; c++){
          env_tmp[c][t] = pvcDecOutTmp[c][t];
        }
      }
    }
#endif /* SONY_PVC_DEC */

    noNoiseFlag = (i==sEnv || i==frameData->prevEnvIsShort) ? 1:0;

#ifdef SONY_PVC_DEC
    if((prev_sbr_mode == USE_ORIG_SBR) && (sbr_mode == USE_PVC_SBR)){
      noNoiseFlag = 0;
    }
#endif /* SONY_PVC_DEC */

    smooth_length = (noNoiseFlag ? 0 : smoothLengths[smoothingLength]);
    smoothFilter  = *fir_table[smooth_length];


#ifdef SONY_PVC_DEC
    if(sbr_mode == USE_PVC_SBR){

      /* PVC */
      for(t = start_pos; t < stop_pos; t++){
            
        if(t < frameData->sin_len_for_cur_top){
          /* Use FrameInfo of previos frame */
          BandLoopEnd = nSfb[frameData->frameInfoPrev[frameData->frameInfoPrev[0]+2+frameData->PrevVarlenEnvId]];
        }else{
          /* Use FrameInfo of current frame */
          BandLoopEnd = nSfb[pvc_frame_info[nEnv+2+i]];
        }
        for (c = 0, o = 0,j = 0; j <  BandLoopEnd; j++) {
          double tmp;
              
          if(t < frameData->sin_len_for_cur_top){
            /* Use FrameInfo of previos frame */
            li = freqBandTable1[frameData->frameInfoPrev[frameData->frameInfoPrev[0]+2+frameData->PrevVarlenEnvId]][j];
            ui = freqBandTable1[frameData->frameInfoPrev[frameData->frameInfoPrev[0]+2+frameData->PrevVarlenEnvId]][j + 1];
            ui2 = freqBandTable2[o+1];
          }else{
            /* Use FrameInfo of current frame */
            li = freqBandTable1[pvc_frame_info[nEnv+2+i]][j];
            ui = freqBandTable1[pvc_frame_info[nEnv+2+i]][j + 1];
            ui2 = freqBandTable2[o+1];
          }
              
          /* calculate E_curr for each time slot */
          for (flag = 0,k = li; k < ui; k++){ /* Calculate the average energy over the current envelope, */
            if(t < frameData->sin_len_for_cur_top){
              /* process the area of previous frame's varlen */
              flag = (hF_for_varlen[c] && (t >= frameData->sin_start_for_cur_top || hFp_for_varlen[c+lowSubband])) ? 1 : flag;
            }else{
              flag = (hF[c] && (t >= frameData->bs_sin_pos || hFp[ch][c+lowSubband])) ? 1 : flag;
            }
            nrg_ref_sony[c][t] = env_tmp[k][t];
            for (nrg = 0,l = 0; l < rate; l++){
              nrg += (aBufR[rate*t+l][k]*aBufR[rate*t+l][k])+(aBufI[rate*t+l][k]*aBufI[rate*t+l][k]);
            }
            nrg_est_sony[c][t] = nrg/rate;
            c++;
          }
              
          if(!int_mode){									/* If no interpolation is used,             */
            for(nrg = 0,k= c - (ui-li); k < c; k++){    /* average the energy in all the QMF bands, */
              nrg += nrg_est_sony[k][t];              /* for the whole scalefactor band.          */
            }
            nrg /= (ui - li);
          }
          c -= (ui-li);
              
          for (k = 0; k < ui - li; k++) {
            o = (k+li>=ui2) ? o+1 : o;	
            ui2 = freqBandTable2[o+1];
            nrg_est_sony[c][t] = (!int_mode) ? nrg : nrg_est_sony[c][t];    /* If no interpolation is used, use the averaged energy from above, otherwise do nothing. */ 
            nrg_tone_sony[c][t] = 0.0f;

            tmp = QMapped_sony[ch][c][t]/(1+QMapped_sony[ch][c][t]);
            
            if(flag){
                nrg_gain_sony[c][t]=(float)sqrt(nrg_ref_sony[c][t]*tmp/(nrg_est_sony[c][t]+1));    
                /* Calculate SM */
                nrg_tone_sony[c][t]=(float)( (hF[c] && (t >= frameData->bs_sin_pos || hFp[el][ch][c+lowSubband])) ? sqrt(nrg_ref_sony[c][t]*tmp/QMapped_sony[ch][c][t]) : nrg_tone_sony[c][t]);
              
                if(t < frameData->sin_len_for_cur_top){
                  nrg_tone_sony[c][t]=(float)( (hF_for_varlen[c] && (t >= frameData->sin_start_for_cur_top || hFp_for_varlen[c+lowSubband])) ? sqrt(nrg_ref_sony[c][t]*tmp/PrevLastEnvNoiseLevel[0][o]) : nrg_tone_sony[c][t]);
                }

            }else{
              if(noNoiseFlag){
                nrg_gain_sony[c][t] = (float)sqrt (nrg_ref_sony[c][t] /(nrg_est_sony[c][t] + 1));
              }else{
                nrg_gain_sony[c][t] = (float)sqrt(nrg_ref_sony[c][t]*tmp/((nrg_est_sony[c][t]+1)*QMapped_sony[ch][c][t]));  
              }
            }

            /* Qm */
            noise_level_sony[c][t]=(float)sqrt(nrg_ref_sony[c][t]*tmp);
            c++;
          }
        }
        /* PVC Limiter. */
        for (c = 0; c < gateMode[el][ch][limiterBand]; c++) {     
          p_ref = p_est = 0.0f;
          for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {   /*Calculate the average gain for the current limiter band.*/
            p_ref += nrg_ref_sony[k][t];
            p_est += nrg_est_sony[k][t];
          }
          avg_gain = (float) sqrt ((p_ref + EPS) / (p_est + EPS));  /* "average gain" (not equal to average of nrg_gain) */
          g_max = avg_gain * limGains[limiterGains];                /* maximum gain allowed is calculated from table. */
          g_max > 1.0e5f ? g_max = 1.0e5f : 0;                      /* upper limit, +100 dB */
          for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
            if(g_max <= nrg_gain_sony[k][t]) {
              noise_level_sony[k][t] = noise_level_sony[k][t] * (g_max / nrg_gain_sony[k][t]);        
              nrg_gain_sony[k][t] =  g_max;        /* gains with noise supression */
            }
          }
          p_adj = 0;
          for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
            p_adj += nrg_gain_sony[k][t]*nrg_gain_sony[k][t]*nrg_est_sony[k][t];
            if (nrg_tone_sony[k][t]){
              p_adj += nrg_tone_sony[k][t]*nrg_tone_sony[k][t];
            }
            else if (!noNoiseFlag){
              p_adj += noise_level_sony[k][t]*noise_level_sony[k][t];
            }
          }
          boost_gain = (float) sqrt ((p_ref + EPS) / (p_adj + EPS));
          boost_gain = boost_gain > 1.584893192f ? 1.584893192f : boost_gain;
              
              
          for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
            nrg_gain_sony[k][t] *= boost_gain;
            noise_level_sony[k][t] *= boost_gain;
            nrg_tone_sony[k][t] *= boost_gain;
          }
        }
      }
          
      /* Application. */
      if (sUp_sony[ch]) {
        /* Initial vaule of Smoothing Filter is set to gain of the top time slot of the first frame */
        for (n = 0; n < maxSmoothLength; n++) {
          for(c = 0; c < noSubbands; c++){
            fBuf[el][ch][n][c] = nrg_gain_sony[c][start_pos];
            fBufN[el][ch][n][c] = noise_level_sony[c][start_pos];
          }
        }
        sUp_sony[el][ch] = 0;
        sUp[el][ch] = 0;
      }
      for (l = rate*pvc_frame_info[1+i]; l < rate*pvc_frame_info[2+i]; l++) {
        ptrReal = *(aBufR + l) + lowSubband; 
        ptrImag = *(aBufI + l) + lowSubband;
        /* calculate time slot ID, because the unit of l is QMF sample */
        SlotId = (int)l/rate;
            
        for (k = 0; k < noSubbands; k++) {
          fBuf[el][ch][maxSmoothLength][k]  = nrg_gain_sony[k][SlotId];
          fBufN[el][ch][maxSmoothLength][k] = noise_level_sony[k][SlotId];
          c = 0, sb_gain = 0, sb_noise = 0;
          for (n = maxSmoothLength - smooth_length; n <= maxSmoothLength; n++){
            sb_gain  += fBuf[el][ch][n][k] * smoothFilter[c];
            sb_noise += fBufN[el][ch][n][k] * smoothFilter[c++];
          }
          phase_index[el][ch] = (phase_index[el][ch] + 1) & 511;
          sb_noise = (nrg_tone_sony[k][SlotId] != 0 || noNoiseFlag) ? 0: sb_noise;
              
          /* final HF calculation */
              
          *ptrReal = *ptrReal*sb_gain + sb_noise * rP[phase_index[el][ch]][0]
            + nrg_tone_sony[k][SlotId]*hPhase[0][harm_index[el][ch]];
          *ptrImag = *ptrImag*sb_gain + sb_noise * rP[phase_index[el][ch]][1]
            + nrg_tone_sony[k][SlotId]*freqInv[k+lowSubband]*hPhase[1][harm_index[el][ch]];
              
          ptrReal++; 
          ptrImag++; 
        }
            
        harm_index[el][ch] = (harm_index[el][ch] + 1) & 3;
            
        /* Revise input ring buffers for envelope and noise smoothing filter */
        memcpy(temp,fBuf[ch][0],64*sizeof(float));
        for (n = 0; n < maxSmoothLength; n++){
          memcpy(fBuf[ch][n],fBuf[ch][n+1],64*sizeof(float));
        }
        memcpy(fBuf[ch][maxSmoothLength],temp,64*sizeof(float));
            
        memcpy(temp,fBufN[ch][0],64*sizeof(float));
        for (n = 0; n < maxSmoothLength; n++){
          memcpy(fBufN[ch][n],fBufN[ch][n+1],64*sizeof(float));
        }
        memcpy(fBufN[ch][maxSmoothLength],temp,64*sizeof(float));
      }
    } else if(sbr_mode == USE_ORIG_SBR){
      /* SBR */
      for (c = 0, o = 0,j = 0; j <  nSfb[frame_info[nEnv+2+i]]; j++) {
        double tmp;
        li = freqBandTable1[frame_info[nEnv+2+i]][j];
        ui = freqBandTable1[frame_info[nEnv+2+i]][j + 1];
        ui2 = freqBandTable2[o+1];
        for (flag = 0,k = li; k < ui; k++){                               /* Calculate the average energy over the current envelope, */
          for (nrg = 0,l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++){
            nrg += (aBufR[l][k]*aBufR[l][k])+(aBufI[l][k]*aBufI[l][k]);
          }
          flag = (hF[c] && (i >= sEnv || hFp[el][ch][c+lowSubband])) ? 1 : flag;

          nrg_est[c++] = nrg / (rate*frame_info[2+i] - rate*frame_info[1+i]);
        }
        if(!int_mode){                                /* If no interpolation is used,             */
          for(nrg = 0,k= c - (ui-li); k < c; k++){    /* average the energy in all the QMF bands, */
            nrg += nrg_est[k];                        /* for the whole scalefactor band.          */
          }
          nrg /= (ui - li);
        }
        c -= (ui-li);
            
        for (k = 0; k < ui - li; k++) {
          o = (k+li>=ui2) ? o+1 : o;	
          ui2 = freqBandTable2[o+1];               
          nrg_ref[c] = sfb_nrg[m];                       
          nrg_est[c] = (!int_mode) ? nrg : nrg_est[c];    /* If no interpolation is used, use the averaged energy from above, otherwise do nothing. */ 
          nrg_tone[c] = 0;       
          tmp = nL[next*nNBands+o]/(1+nL[next*nNBands+o]); 
          
          if(flag){                                                     /* Calculate levels and gain, dependent on whether a synthetic,*/
            nrg_gain[c]=(float)sqrt(nrg_ref[c]*tmp/(nrg_est[c]+1));    /* sine is present or not. */
            nrg_tone[c]=(float)( (hF[c] && (i >= sEnv || hFp[el][ch][c+lowSubband])) ? sqrt(nrg_ref[c]*tmp/nL[next*nNBands+o]) : nrg_tone[c]);
          }else{
            if(noNoiseFlag)
              nrg_gain[c] = (float) sqrt (nrg_ref[c] /(nrg_est[c] + 1));
            else
              nrg_gain[c] = (float)sqrt(nrg_ref[c]*tmp/((nrg_est[c]+1)*(nL[next*nNBands+o])));
          }
          noise_level[c]=(float)sqrt(nrg_ref[c]*tmp);
          c++;
        }
        m++;
      }


      /* SBR Limiter. */
      for (c = 0; c < gateMode[el][ch][limiterBand]; c++) {     
        p_ref = p_est = 0;
        for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {   /*Calculate the average gain for the current limiter band.*/
          p_ref += nrg_ref[k];
          p_est += nrg_est[k];
        }
        avg_gain = (float) sqrt ((p_ref + EPS) / (p_est + EPS));  /* "average gain" (not equal to average of nrg_gain) */
        g_max = avg_gain * limGains[limiterGains];                /* maximum gain allowed is calculated from table. */
        g_max > 1.0e5f ? g_max = 1.0e5f : 0;                      /* upper limit, +100 dB */
        for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
          if(g_max <= nrg_gain[k]) {
            noise_level[k] = noise_level[k] * (g_max / nrg_gain[k]);        
            nrg_gain[k] =  g_max;        /* gains with noise supression */
          }
        }
        p_adj = 0;
        for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
          p_adj += nrg_gain[k]*nrg_gain[k]*nrg_est[k];
          if (nrg_tone[k])
            p_adj += nrg_tone[k]*nrg_tone[k];
          else if (!noNoiseFlag)
            p_adj += noise_level[k]*noise_level[k];
        }
        boost_gain = (float) sqrt ((p_ref + EPS) / (p_adj + EPS));
        boost_gain = boost_gain > 1.584893192f ? 1.584893192f : boost_gain;
        for (k = limSbc[el][ch][limiterBand][c]; k < limSbc[el][ch][limiterBand][c + 1]; k++) {
          nrg_gain[k] *= boost_gain;
          noise_level[k] *= boost_gain;
          nrg_tone[k] *= boost_gain;
        }
      }

      /* Application. */
      if (sUp[ch]) {
        for (n = 0; n < maxSmoothLength; n++) {
          memcpy(fBuf[ch][n],nrg_gain,noSubbands*sizeof(float));
          memcpy(fBufN[ch][n],noise_level,noSubbands*sizeof(float));
        }
        sUp[el][ch] = 0;
        sUp_sony[el][ch] = 0;
      }

      for (l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++) {
        ptrReal = *(aBufR + l) + lowSubband; 
        ptrImag = *(aBufI + l) + lowSubband;

#ifdef LOW_POWER_SBR
        tone_count = 0;
#endif

        for (k = 0; k < noSubbands; k++) {
          fBuf[el][ch][maxSmoothLength][k]  = nrg_gain[k];
          fBufN[el][ch][maxSmoothLength][k] = noise_level[k];
          c = 0, sb_gain = 0, sb_noise = 0;
          for (n = maxSmoothLength - smooth_length; n <= maxSmoothLength; n++){
            sb_gain  += fBuf[el][ch][n][k] * smoothFilter[c];
            sb_noise += fBufN[el][ch][n][k] * smoothFilter[c++];
          }

          phase_index[el][ch] = (phase_index[el][ch] + 1) & 511;
          sb_noise = (nrg_tone[k] != 0 || noNoiseFlag) ? 0: sb_noise;
 
          *ptrReal = *ptrReal*sb_gain + sb_noise * rP[phase_index[el][ch]][0];
          *ptrImag = *ptrImag*sb_gain + sb_noise * rP[phase_index[el][ch]][1];
               
          ptrReal++; 
          ptrImag++; 
        }

        memcpy(temp,fBuf[ch][0],64*sizeof(float));
        for (n = 0; n < maxSmoothLength; n++)
          memcpy(fBuf[ch][n],fBuf[ch][n+1],64*sizeof(float));
        memcpy(fBuf[ch][maxSmoothLength],temp,64*sizeof(float));
        memcpy(temp,fBufN[ch][0],64*sizeof(float));
        for (n = 0; n < maxSmoothLength; n++)
          memcpy(fBufN[ch][n],fBufN[ch][n+1],64*sizeof(float));
        memcpy(fBufN[ch][maxSmoothLength],temp,64*sizeof(float));
      } 

      apply_inter_tes(
                      *(codecBufR + rate*frame_info[1+i]), 
                      *(codecBufI + rate*frame_info[1+i]), 
                      *(aBufR + rate*frame_info[1+i]), 
                      *(aBufI + rate*frame_info[1+i]), 
                      rate*frame_info[2+i] - rate*frame_info[1+i], 
                      lowSubband, 
                      noSubbands,
                      frameData->interTesGamma[i]
                      );

      for (l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++) {
        ptrReal = *(aBufR + l) + lowSubband; 
        ptrImag = *(aBufI + l) + lowSubband;

        for (k = 0; k < noSubbands; k++) {
          *ptrReal += nrg_tone[k]*hPhase[0][harm_index[el][ch]];
          *ptrImag += nrg_tone[k]*freqInv[k+lowSubband]*hPhase[1][harm_index[el][ch]];

#ifdef LOW_POWER_SBR
          {
            int indexMinus1 = (harm_index[ch] - 1) & 3;
            int indexPlus1  = (harm_index[ch] + 1) & 3;

            if(k == 0){
              *(ptrReal-1) -= (0.00815f*freqInv[lowSubband - 1]*nrg_tone[0]*hPhase[0][indexPlus1]);
              if(k < noSubbands - 1){
                *(ptrReal)   -= (0.00815f*freqInv[lowSubband]*nrg_tone[1]*hPhase[0][indexPlus1]);
              }
            }
            if(k > 0 && k < noSubbands - 1 && tone_count < 16){
              *(ptrReal) -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k - 1]*hPhase [0][indexMinus1]);
              *(ptrReal) -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k + 1]*hPhase [0][indexPlus1 ]);
            }
           
            if(k == noSubbands - 1 && tone_count < 16){
              if( k > 0){
                *(ptrReal)   -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k - 1]*hPhase [0][indexMinus1]);
              }
              if(k + lowSubband + 1< 63){
                *(ptrReal+1) -= (0.00815f*freqInv[k + lowSubband + 1]*nrg_tone[k]*hPhase[0][indexMinus1]);
              }
            }

            if(nrg_tone[k])
              tone_count++;
          }
#endif

          ptrReal++; 
          ptrImag++;
        }
        harm_index[el][ch] = (harm_index[el][ch] + 1) & 3;
      }
    }
  }

  for(i = 0; i < 64; i++){
    hFp_for_varlen[el][i] = hFp[el][0][i];
    hF_for_varlen[el][i] = hF[i];
  }
	
  memcpy(&hFp[el][ch][0]+lowSubband, hF,(64-lowSubband)*sizeof(int));

  if (sEnv == nEnv){
    frameData->prevEnvIsShort = 0;
  }else{
    frameData->prevEnvIsShort = -1;
  }


  for(i = 0; i < LENGTH_FRAME_INFO; i++){
    frameData->frameInfoPrev[i] = frameData->frameInfo[i];
  }

  if(frameData->frameInfo[0] == 1){
    frameData->PrevVarlenEnvId = 0;
  }else if(frameData->frameInfo[0] == 2){
    frameData->PrevVarlenEnvId = 1;
  }


#else /* SONY_PVC_DEC */

  /* Estimate levels. */
  for (c = 0, o = 0,j = 0; j <  nSfb[frame_info[nEnv+2+i]]; j++) {
    double tmp;
    li = freqBandTable1[frame_info[nEnv+2+i]][j];
    ui = freqBandTable1[frame_info[nEnv+2+i]][j + 1];
    ui2 = freqBandTable2[o+1];
    for (flag = 0,k = li; k < ui; k++){                               /* Calculate the average energy over the current envelope, */
      for (nrg = 0,l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++){
        nrg += (aBufR[l][k]*aBufR[l][k])+(aBufI[l][k]*aBufI[l][k]);
      }
      flag = (hF[c] && (i >= sEnv || hFp[ch][c+lowSubband])) ? 1 : flag;
      nrg_est[c++] = nrg / (rate*frame_info[2+i] - rate*frame_info[1+i]);
    }

    if(!int_mode){                                /* If no interpolation is used,             */
      for(nrg = 0,k= c - (ui-li); k < c; k++){    /* average the energy in all the QMF bands, */
        nrg += nrg_est[k];                        /* for the whole scalefactor band.          */
      }
      nrg /= (ui - li);
    }
      c -= (ui-li);
      
      for (k = 0; k < ui - li; k++) {



        o = (k+li>=ui2) ? o+1 : o;
        ui2 = freqBandTable2[o+1];                    
        nrg_ref[c] = sfb_nrg[m];                       
        nrg_est[c] = (!int_mode) ? nrg : nrg_est[c];    /* If no interpolation is used, use the averaged energy from above, otherwise do nothing. */ 
        nrg_tone[c] = 0;       
        tmp = nL[next*nNBands+o]/(1+nL[next*nNBands+o]); 

#ifdef LOW_POWER_SBR
        nrg_est[c] *= 2.0f;

        if(flag)
          dontUseTheseGainValues[k + li - lowSubband] = 1;
        else
          dontUseTheseGainValues[k + li - lowSubband] = 0;
#endif

        if(flag){                                                     /* Calculate levels and gain, dependent on whether a synthetic,*/
          nrg_gain[c]=(float)sqrt(nrg_ref[c]*tmp/(nrg_est[c]+1));    /* sine is present or not. */
          nrg_tone[c]=(float)( (hF[c] && (i >= sEnv || hFp[ch][c+lowSubband])) ? sqrt(nrg_ref[c]*tmp/nL[next*nNBands+o]) : nrg_tone[c]);
        }
        else{
          if(noNoiseFlag)
            nrg_gain[c] = (float) sqrt (nrg_ref[c] /(nrg_est[c] + 1));
          else
            nrg_gain[c] = (float)sqrt(nrg_ref[c]*tmp/((nrg_est[c]+1)*(nL[next*nNBands+o])));
        }
        noise_level[c]=(float)sqrt(nrg_ref[c]*tmp);
        c++;
      }
      m++;
    }          

 
    /* Limiter. */
    for (c = 0; c < gateMode[ch][limiterBand]; c++) {     
      p_ref = p_est = 0;
      for (k = limSbc[ch][limiterBand][c]; k < limSbc[ch][limiterBand][c + 1]; k++) {   /*Calculate the average gain for the current limiter band.*/
        p_ref += nrg_ref[k];
        p_est += nrg_est[k];
      }
      avg_gain = (float) sqrt ((p_ref + EPS) / (p_est + EPS));  /* "average gain" (not equal to average of nrg_gain) */
      g_max = avg_gain * limGains[limiterGains];                /* maximum gain allowed is calculated from table. */
      g_max > 1.0e5f ? g_max = 1.0e5f : 0;                      /* upper limit, +100 dB */
      for (k = limSbc[ch][limiterBand][c]; k < limSbc[ch][limiterBand][c + 1]; k++) {
        if(g_max <= nrg_gain[k]) {
          noise_level[k] = noise_level[k] * (g_max / nrg_gain[k]);        
          nrg_gain[k] =  g_max;        /* gains with noise supression */
        }
      }
      p_adj = 0;
      for (k = limSbc[ch][limiterBand][c]; k < limSbc[ch][limiterBand][c + 1]; k++) {
        p_adj += nrg_gain[k]*nrg_gain[k]*nrg_est[k];
        if (nrg_tone[k])
          p_adj += nrg_tone[k]*nrg_tone[k];
        else if (!noNoiseFlag)
          p_adj += noise_level[k]*noise_level[k];
      }
      boost_gain = (float) sqrt ((p_ref + EPS) / (p_adj + EPS));
      boost_gain = boost_gain > 1.584893192f ? 1.584893192f : boost_gain;
      for (k = limSbc[ch][limiterBand][c]; k < limSbc[ch][limiterBand][c + 1]; k++) {
        nrg_gain[k] *= boost_gain;
        noise_level[k] *= boost_gain;
        nrg_tone[k] *= boost_gain;
      }
    }


#ifdef LOW_POWER_SBR
       
    aliasingReduction(degreeAlias,
                      nrg_gain,
                      nrg_est,
                      dontUseTheseGainValues,
                      noSubbands,
                      lowSubband);
    
#endif


    /* Application. */
    if (sUp[ch]) {
      for (n = 0; n < maxSmoothLength; n++) {
        memcpy(fBuf[ch][n],nrg_gain,noSubbands*sizeof(float));
        memcpy(fBufN[ch][n],noise_level,noSubbands*sizeof(float));
      }
      sUp[ch] = 0;
    }


    for (l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++) {
      ptrReal = *(aBufR + l) + lowSubband; 
      ptrImag = *(aBufI + l) + lowSubband;

#ifdef LOW_POWER_SBR
      tone_count = 0;
#endif

      for (k = 0; k < noSubbands; k++) {
        fBuf[ch][maxSmoothLength][k]  = nrg_gain[k];
        fBufN[ch][maxSmoothLength][k] = noise_level[k];
        c = 0, sb_gain = 0, sb_noise = 0;
        for (n = maxSmoothLength - smooth_length; n <= maxSmoothLength; n++){
          sb_gain  += fBuf[ch][n][k] * smoothFilter[c];
          sb_noise += fBufN[ch][n][k] * smoothFilter[c++];
        }

        phase_index[ch] = (phase_index[ch] + 1) & 511;
        sb_noise = (nrg_tone[k] != 0 || noNoiseFlag) ? 0: sb_noise;
 
        *ptrReal = *ptrReal*sb_gain + sb_noise * rP[phase_index[ch]][0];
	*ptrImag = *ptrImag*sb_gain + sb_noise * rP[phase_index[ch]][1];
               
	ptrReal++; 
	ptrImag++; 
      }

      memcpy(temp,fBuf[ch][0],64*sizeof(float));
      for (n = 0; n < maxSmoothLength; n++)
	memcpy(fBuf[ch][n],fBuf[ch][n+1],64*sizeof(float));
      memcpy(fBuf[ch][maxSmoothLength],temp,64*sizeof(float));
      memcpy(temp,fBufN[ch][0],64*sizeof(float));
      for (n = 0; n < maxSmoothLength; n++)
	memcpy(fBufN[ch][n],fBufN[ch][n+1],64*sizeof(float));
      memcpy(fBufN[ch][maxSmoothLength],temp,64*sizeof(float));
    } 

    apply_inter_tes(
		    *(codecBufR + rate*frame_info[1+i]), 
		    *(codecBufI + rate*frame_info[1+i]), 
		    *(aBufR + rate*frame_info[1+i]), 
		    *(aBufI + rate*frame_info[1+i]), 
		    rate*frame_info[2+i] - rate*frame_info[1+i], 
		    lowSubband, 
		    noSubbands,
		    frameData->interTesGamma[i]
		    );
    
    for (l = rate*frame_info[1+i]; l < rate*frame_info[2+i]; l++) {
      ptrReal = *(aBufR + l) + lowSubband; 
      ptrImag = *(aBufI + l) + lowSubband;
      
      for (k = 0; k < noSubbands; k++) {

 	*ptrReal += nrg_tone[k]*hPhase[0][harm_index[ch]];
	*ptrImag += nrg_tone[k]*freqInv[k+lowSubband]*hPhase[1][harm_index[ch]];

#ifdef LOW_POWER_SBR
        {
          int indexMinus1 = (harm_index[ch] - 1) & 3;
          int indexPlus1  = (harm_index[ch] + 1) & 3;

          if(k == 0){
            *(ptrReal-1) -= (0.00815f*freqInv[lowSubband - 1]*nrg_tone[0]*hPhase[0][indexPlus1]);
            if(k < noSubbands - 1){
            *(ptrReal)   -= (0.00815f*freqInv[lowSubband]*nrg_tone[1]*hPhase[0][indexPlus1]);
          }
             
          }
          if(k > 0 && k < noSubbands - 1 && tone_count < 16){
            *(ptrReal) -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k - 1]*hPhase [0][indexMinus1]);
            *(ptrReal) -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k + 1]*hPhase [0][indexPlus1 ]);
          }
           
          if(k == noSubbands - 1 && tone_count < 16){
            if( k > 0){
              *(ptrReal)   -= (0.00815f*freqInv[k + lowSubband]*nrg_tone[k - 1]*hPhase [0][indexMinus1]);
            }
            if(k + lowSubband + 1< 63){
              *(ptrReal+1) -= (0.00815f*freqInv[k + lowSubband + 1]*nrg_tone[k]*hPhase[0][indexMinus1]);
            }
          }

          if(nrg_tone[k])
            tone_count++;
        }
#endif

        ptrReal++; 
        ptrImag++; 
      }
      harm_index[ch] = (harm_index[ch] + 1) & 3;
    }



  }  
  memcpy(&hFp[ch][0]+lowSubband, hF,(64-lowSubband)*sizeof(int));

  if (sEnv == nEnv)
    frameData->prevEnvIsShort = 0;
  else
    frameData->prevEnvIsShort = -1;
#endif /* SONY_PVC_DEC */

#ifdef SONY_PVC_DEC
  for(i = 0; i < nNfb_global; i++){
    PrevLastEnvNoiseLevel[0][i] = LastEnvNoiseLevel[0][i];
    Prev_nNfb = nNfb_global;
  }
#endif /* SONY_PVC_DEC */


}

/*******************************************************************************
 Functionname:  createLimiterBands
 *******************************************************************************
 Description:   
 Arguments:     
                 
 Return:        none
*******************************************************************************/
static void
createLimiterBands ( int limSbc[4][12 + 1],
                     int gateMode[4],
                     int *freqTable,
                     int noBands,
                     int ch,
                     int xOverQmf[MAX_NUM_PATCHES],
                     int bPatchingMode,
                     int bSbr41
                     )
{
  int i, j, k, isPatchBorder[2];
  int patchBorders[MAX_NUM_PATCHES+1];
  int workLimiterBandTable[32 + MAX_NUM_PATCHES + 1];
  
  double nOctaves;
  int noPatches;
  
  int lowSubband = freqTable[0];
  int highSubband = freqTable[noBands];

  const double log2 = log(2.0);
  const double limiterBandsPerOctave[4] = {0, 1.2, 2.0, 3.0};

  if(!bPatchingMode && (xOverQmf!= NULL))
  {  
    noPatches=0;
    if (bSbr41) {
      for(i=1; i<MAX_NUM_PATCHES; i++) if(xOverQmf[i] != 0) noPatches++;
    } else {
      for(i=1; i<4; i++) if(xOverQmf[i] != 0) noPatches++;
    }
    for (i = 0; i < noPatches; i++) {
      patchBorders[i] = xOverQmf[i] - lowSubband;
    }
  }
  else
  {
    noPatches = Patch[ch].noOfPatches;
    for (i = 0; i < noPatches; i++) {
      patchBorders[i] = Patch[ch].targetStartBand[i] - lowSubband;
    }
  }
  patchBorders[i] = highSubband - lowSubband;

  /* First band: 1 limiter band. */
  limSbc[0][0] = freqTable[0] - lowSubband;
  limSbc[0][1] = freqTable[noBands] - lowSubband;
  gateMode[0] = 1;

  /* Next three bands: 1.2, 2, 3 limiter bands/octave plus bandborders at patchborders. */
  for (i = 1; i < 4; i++) {

    for (k = 0; k <= noBands; k++) {
      workLimiterBandTable[k] = freqTable[k] - lowSubband;
    }
    
    for (k = 1; k < noPatches; k++) {
      workLimiterBandTable[noBands+k] = patchBorders[k];
    }

    gateMode[i] = noBands + noPatches - 1;
    shellsort(workLimiterBandTable, gateMode[i] + 1);

    for (j = 1; j <= gateMode[i]; j++) {
      
      nOctaves = log( (double) (workLimiterBandTable[j] + lowSubband) / (workLimiterBandTable[j-1] + lowSubband) ) / log2;     
      
      if (nOctaves * limiterBandsPerOctave[i] < 0.49) { 
        
        if (workLimiterBandTable[j] == workLimiterBandTable[j-1]) {
          workLimiterBandTable[j] = highSubband;
          shellsort(workLimiterBandTable, gateMode[i] + 1);
          gateMode[i]--;
          j--;
          continue;
        }        

        isPatchBorder[0] = isPatchBorder[1] = 0;

        for (k = 0; k <= noPatches; k++) {
          if (workLimiterBandTable[j-1] == patchBorders[k]) {
            isPatchBorder[0] = 1;
            break;
          }
        }

        for (k = 0; k <= noPatches; k++) {
          if (workLimiterBandTable[j] == patchBorders[k]) {
            isPatchBorder[1] = 1;
            break;
          }
        }

        if (!isPatchBorder[1]) {
          workLimiterBandTable[j] = highSubband;
          shellsort(workLimiterBandTable, gateMode[i] + 1);
          gateMode[i]--;
          j--;
        } else if (!isPatchBorder[0]) {
          workLimiterBandTable[j-1] = highSubband;
          shellsort(workLimiterBandTable, gateMode[i] + 1);
          gateMode[i]--;
          j--;
        } 
      }
    }

    for (k = 0; k <= gateMode[i]; k++) {
      limSbc[i][k] = workLimiterBandTable[k];
    }
  }
}

static void apply_inter_tes(
		float *codecQmfReal,
		float *codecQmfImag,
		float *qmfReal,
		float *qmfImag,
		int nbSubsample,
		int lowSubband,
		int nbSubband,
		int gamma_idx
		)
{
  int highSubband = lowSubband + nbSubband;
  float subsample_power_high[TIMESLOT_BUFFER_SIZE], subsample_power_low[TIMESLOT_BUFFER_SIZE];
  float total_power_high = 0.0f;
  float total_power_low = 0.0f, total_power_high_after = 1.0e-6f; 
  float gain[TIMESLOT_BUFFER_SIZE];
  float gain_adj, gain_adj_2;
  float gamma = q_gamma_table[gamma_idx];
  int i, j;

  if(gamma > 0){

    for(i = 0; i < nbSubsample; i++) {
      memcpy(&qmfReal[64 * i], &codecQmfReal[64 * i], lowSubband * sizeof(float));
      memcpy(&qmfImag[64 * i], &codecQmfImag[64 * i], lowSubband * sizeof(float));
    } 

    for(i = 0; i < nbSubsample; i++) {
      subsample_power_low[i] = 0.0f;
      for(j = 0; j < lowSubband; j++) {
	subsample_power_low[i] += qmfReal[64*i+j] * qmfReal[64*i+j];
	subsample_power_low[i] += qmfImag[64*i+j] * qmfImag[64*i+j];
      }
      subsample_power_high[i] = 0.0f;
      for(j = lowSubband; j < highSubband; j++) {
	subsample_power_high[i] += qmfReal[64*i+j] * qmfReal[64*i+j];
	subsample_power_high[i] += qmfImag[64*i+j] * qmfImag[64*i+j];
      }
      total_power_low += subsample_power_low[i];
      total_power_high += subsample_power_high[i];
    }

    for(i = 0; i < nbSubsample; i++) {  
      gain[i] = (float)sqrt(subsample_power_low[i] * nbSubsample / (total_power_low + 1.0e-6f));
    }

    for(i = 0; i < nbSubsample; i++) {  
      gain[i] = 1.0f + gamma * (gain[i] - 1.0f);
    }

    for(i = 0; i < nbSubsample; i++) {  
  
      if(gain[i] < 0.2f) {
	gain[i] = 0.2f;
      }

      subsample_power_high[i] *= gain[i] * gain[i];
      total_power_high_after += subsample_power_high[i];
    }

    gain_adj_2 = total_power_high / total_power_high_after;
    gain_adj = (float)sqrt(gain_adj_2);

    for(i = 0; i < nbSubsample; i++) {  
      gain[i] *= gain_adj;

      for(j = lowSubband; j < highSubband; j++) {
	qmfReal[64*i+j] *= gain[i];
	qmfImag[64*i+j] *= gain[i];
      }
    }

  }

}

