/***********************************************************************
MPEG-4 Audio RM Module
Parametric based codec - SSC (SinuSoidal Coding) bit stream Encoder

This software was originally developed by:
* Werner Oomen, Philips PDSL-Eindhoven <werner.oomen@philips.com>

And edited by:
*

in the course of development of the MPEG-4 Audio standard ISO-14496-1, 2 and 3. 
This software module is an implementation of a part of one or more MPEG-4 Audio
tools as specified by the MPEG-4 Audio standard. ISO/IEC gives users of the 
MPEG-4 Audio standards free licence to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the 
MPEG-4 Audio standards. Those intending to use this software module in hardware
or software products are advised that this use may infringe existing patents.
The original developers of this software of this module and their company, 
the subsequent editors and their companies, and ISO/EIC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio conforming products. The 
original developer retains full right to use this code for his/her own purpose,
assign or donate the code to a third party and to inhibit third party from
using the code for non MPEG-4 Audio conforming products. This copyright notice
must be included in all copies of derivative works.

Copyright  2001.

Source file: hufNoiRelLag.c

Required libraries: <none>

Authors:
WO:	Werner Oomen,  Philips PDSL-Eindhoven <werner.oomen@philips.com>

Changes:
28 Nov 2002	AR	Initial version
************************************************************************/

#include "HuffmanDecoder.h"

/*********************************************************************
* Definition of hufNoiRelLag huffman decoder
* (Automatically generated - casting needed to avoid warnings on MSVC)
**********************************************************************/
static const HUFFMAN_LUT _hufNoiRelLag_[] =
                    {{     1, {(PHUFFMAN_LUT)      0}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 2}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 6}},
                     {     3, {(PHUFFMAN_LUT)     -4}},
                     {     3, {(PHUFFMAN_LUT)      4}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 328}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 10}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 134}},
                     {     5, {(PHUFFMAN_LUT)     12}},
                     {     5, {(PHUFFMAN_LUT)    -12}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 12}},
                     {     6, {(PHUFFMAN_LUT)     16}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 14}},
                     {     7, {(PHUFFMAN_LUT)    -20}},
                     {     8, {(PHUFFMAN_LUT)     24}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 16}},
                     {     9, {(PHUFFMAN_LUT)     28}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 18}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 20}},
                     {    10, {(PHUFFMAN_LUT)    -32}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 28}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 48}},
                     {    -4, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 68}},
                     {    -4, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 84}},
                     {    -4, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 100}},
                     {    -4, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 116}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 132}},
                     {    13, {(PHUFFMAN_LUT)    -56}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 36}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 38}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 40}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 42}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 44}},
                     {    16, {(PHUFFMAN_LUT)    164}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 46}},
                     {    16, {(PHUFFMAN_LUT)    176}},
                     {    17, {(PHUFFMAN_LUT)    120}},
                     {    17, {(PHUFFMAN_LUT)    128}},
                     {    17, {(PHUFFMAN_LUT)    132}},
                     {    17, {(PHUFFMAN_LUT)    136}},
                     {    17, {(PHUFFMAN_LUT)    140}},
                     {    17, {(PHUFFMAN_LUT)    144}},
                     {    17, {(PHUFFMAN_LUT)    148}},
                     {    17, {(PHUFFMAN_LUT)    152}},
                     {    17, {(PHUFFMAN_LUT)    156}},
                     {    17, {(PHUFFMAN_LUT)    160}},
                     {    17, {(PHUFFMAN_LUT)    168}},
                     {    17, {(PHUFFMAN_LUT)    172}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 56}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 58}},
                     {    16, {(PHUFFMAN_LUT)    192}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 60}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 62}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 64}},
                     {    16, {(PHUFFMAN_LUT)    220}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 66}},
                     {    17, {(PHUFFMAN_LUT)    180}},
                     {    17, {(PHUFFMAN_LUT)    184}},
                     {    17, {(PHUFFMAN_LUT)    188}},
                     {    17, {(PHUFFMAN_LUT)    196}},
                     {    17, {(PHUFFMAN_LUT)    200}},
                     {    17, {(PHUFFMAN_LUT)    204}},
                     {    17, {(PHUFFMAN_LUT)    208}},
                     {    17, {(PHUFFMAN_LUT)    212}},
                     {    17, {(PHUFFMAN_LUT)    216}},
                     {    17, {(PHUFFMAN_LUT)    224}},
                     {    17, {(PHUFFMAN_LUT)    228}},
                     {    17, {(PHUFFMAN_LUT)    232}},
                     {    17, {(PHUFFMAN_LUT)    236}},
                     {    17, {(PHUFFMAN_LUT)    240}},
                     {    17, {(PHUFFMAN_LUT)    244}},
                     {    17, {(PHUFFMAN_LUT)    248}},
                     {    17, {(PHUFFMAN_LUT)    252}},
                     {    17, {(PHUFFMAN_LUT)    256}},
                     {    17, {(PHUFFMAN_LUT)    260}},
                     {    17, {(PHUFFMAN_LUT)    264}},
                     {    17, {(PHUFFMAN_LUT)    268}},
                     {    17, {(PHUFFMAN_LUT)    272}},
                     {    17, {(PHUFFMAN_LUT)    276}},
                     {    17, {(PHUFFMAN_LUT)    280}},
                     {    17, {(PHUFFMAN_LUT)    284}},
                     {    17, {(PHUFFMAN_LUT)    288}},
                     {    17, {(PHUFFMAN_LUT)    292}},
                     {    17, {(PHUFFMAN_LUT)    296}},
                     {    17, {(PHUFFMAN_LUT)    300}},
                     {    17, {(PHUFFMAN_LUT)    304}},
                     {    17, {(PHUFFMAN_LUT)    308}},
                     {    17, {(PHUFFMAN_LUT)    312}},
                     {    17, {(PHUFFMAN_LUT)    316}},
                     {    17, {(PHUFFMAN_LUT)    320}},
                     {    17, {(PHUFFMAN_LUT)    324}},
                     {    17, {(PHUFFMAN_LUT)    328}},
                     {    17, {(PHUFFMAN_LUT)    332}},
                     {    17, {(PHUFFMAN_LUT)    336}},
                     {    17, {(PHUFFMAN_LUT)    340}},
                     {    17, {(PHUFFMAN_LUT)    344}},
                     {    17, {(PHUFFMAN_LUT)    348}},
                     {    17, {(PHUFFMAN_LUT)    352}},
                     {    17, {(PHUFFMAN_LUT)    356}},
                     {    17, {(PHUFFMAN_LUT)    360}},
                     {    17, {(PHUFFMAN_LUT)    364}},
                     {    17, {(PHUFFMAN_LUT)    368}},
                     {    17, {(PHUFFMAN_LUT)    372}},
                     {    17, {(PHUFFMAN_LUT)    376}},
                     {    17, {(PHUFFMAN_LUT)    380}},
                     {    17, {(PHUFFMAN_LUT)    384}},
                     {    17, {(PHUFFMAN_LUT)    388}},
                     {    17, {(PHUFFMAN_LUT)    392}},
                     {    17, {(PHUFFMAN_LUT)    396}},
                     {    17, {(PHUFFMAN_LUT)    400}},
                     {    17, {(PHUFFMAN_LUT)    404}},
                     {    17, {(PHUFFMAN_LUT)    408}},
                     {    17, {(PHUFFMAN_LUT)    412}},
                     {    17, {(PHUFFMAN_LUT)    416}},
                     {    17, {(PHUFFMAN_LUT)    420}},
                     {    17, {(PHUFFMAN_LUT)    424}},
                     {    17, {(PHUFFMAN_LUT)    428}},
                     {    17, {(PHUFFMAN_LUT)    432}},
                     {    17, {(PHUFFMAN_LUT)    436}},
                     {    17, {(PHUFFMAN_LUT)    440}},
                     {    17, {(PHUFFMAN_LUT)    444}},
                     {    17, {(PHUFFMAN_LUT)    448}},
                     {    17, {(PHUFFMAN_LUT)    452}},
                     {    17, {(PHUFFMAN_LUT)    456}},
                     {    17, {(PHUFFMAN_LUT)    460}},
                     {    17, {(PHUFFMAN_LUT)    464}},
                     {    17, {(PHUFFMAN_LUT)    468}},
                     {    17, {(PHUFFMAN_LUT)    472}},
                     {    17, {(PHUFFMAN_LUT)    476}},
                     {    17, {(PHUFFMAN_LUT)    480}},
                     {    17, {(PHUFFMAN_LUT)    484}},
                     {    17, {(PHUFFMAN_LUT)    488}},
                     {    14, {(PHUFFMAN_LUT)    -68}},
                     {    14, {(PHUFFMAN_LUT)    -64}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 136}},
                     {     6, {(PHUFFMAN_LUT)    -16}},
                     {     7, {(PHUFFMAN_LUT)     20}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 138}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 142}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 170}},
                     {     9, {(PHUFFMAN_LUT)    -24}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 200}},
                     {    10, {(PHUFFMAN_LUT)     32}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 144}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 146}},
                     {    11, {(PHUFFMAN_LUT)     36}},
                     {    13, {(PHUFFMAN_LUT)     60}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 150}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 158}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 160}},
                     {    14, {(PHUFFMAN_LUT)     72}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 152}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 154}},
                     {    15, {(PHUFFMAN_LUT)    -92}},
                     {    17, {(PHUFFMAN_LUT)    492}},
                     {    17, {(PHUFFMAN_LUT)    496}},
                     {    17, {(PHUFFMAN_LUT)    500}},
                     {    17, {(PHUFFMAN_LUT)    504}},
                     {    14, {(PHUFFMAN_LUT)    -80}},
                     {    14, {(PHUFFMAN_LUT)    -76}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 164}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 168}},
                     {    15, {(PHUFFMAN_LUT)     80}},
                     {    15, {(PHUFFMAN_LUT)     92}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 166}},
                     {    16, {(PHUFFMAN_LUT)   -156}},
                     {    17, {(PHUFFMAN_LUT)    508}},
                     {    17, {(PHUFFMAN_LUT)    512}},
                     {    16, {(PHUFFMAN_LUT)    -96}},
                     {    16, {(PHUFFMAN_LUT)    -88}},
                     {    11, {(PHUFFMAN_LUT)    -36}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 174}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 176}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 192}},
                     {    12, {(PHUFFMAN_LUT)    -48}},
                     {    12, {(PHUFFMAN_LUT)    -44}},
                     {    13, {(PHUFFMAN_LUT)    -52}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 180}},
                     {    13, {(PHUFFMAN_LUT)     48}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 182}},
                     {    14, {(PHUFFMAN_LUT)    -72}},
                     {    14, {(PHUFFMAN_LUT)     64}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 184}},
                     {    14, {(PHUFFMAN_LUT)     56}},
                     {    16, {(PHUFFMAN_LUT)    108}},
                     {    16, {(PHUFFMAN_LUT)    116}},
                     {    16, {(PHUFFMAN_LUT)    124}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 188}},
                     {    18, {(PHUFFMAN_LUT)   -512}},
                     {    18, {(PHUFFMAN_LUT)   -508}},
                     {    18, {(PHUFFMAN_LUT)   -504}},
                     {    18, {(PHUFFMAN_LUT)   -500}},
                     {    12, {(PHUFFMAN_LUT)     44}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 194}},
                     {    13, {(PHUFFMAN_LUT)     52}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 196}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 198}},
                     {    14, {(PHUFFMAN_LUT)    -60}},
                     {    15, {(PHUFFMAN_LUT)     68}},
                     {    15, {(PHUFFMAN_LUT)     88}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 202}},
                     {    10, {(PHUFFMAN_LUT)    -28}},
                     {    12, {(PHUFFMAN_LUT)    -40}},
                     {    12, {(PHUFFMAN_LUT)     40}},
                     {    -6, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 206}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 270}},
                     {    18, {(PHUFFMAN_LUT)   -496}},
                     {    18, {(PHUFFMAN_LUT)   -492}},
                     {    18, {(PHUFFMAN_LUT)   -488}},
                     {    18, {(PHUFFMAN_LUT)   -484}},
                     {    18, {(PHUFFMAN_LUT)   -480}},
                     {    18, {(PHUFFMAN_LUT)   -476}},
                     {    18, {(PHUFFMAN_LUT)   -472}},
                     {    18, {(PHUFFMAN_LUT)   -468}},
                     {    18, {(PHUFFMAN_LUT)   -464}},
                     {    18, {(PHUFFMAN_LUT)   -460}},
                     {    18, {(PHUFFMAN_LUT)   -456}},
                     {    18, {(PHUFFMAN_LUT)   -452}},
                     {    18, {(PHUFFMAN_LUT)   -448}},
                     {    18, {(PHUFFMAN_LUT)   -444}},
                     {    18, {(PHUFFMAN_LUT)   -440}},
                     {    18, {(PHUFFMAN_LUT)   -436}},
                     {    18, {(PHUFFMAN_LUT)   -432}},
                     {    18, {(PHUFFMAN_LUT)   -428}},
                     {    18, {(PHUFFMAN_LUT)   -424}},
                     {    18, {(PHUFFMAN_LUT)   -420}},
                     {    18, {(PHUFFMAN_LUT)   -416}},
                     {    18, {(PHUFFMAN_LUT)   -412}},
                     {    18, {(PHUFFMAN_LUT)   -408}},
                     {    18, {(PHUFFMAN_LUT)   -404}},
                     {    18, {(PHUFFMAN_LUT)   -400}},
                     {    18, {(PHUFFMAN_LUT)   -396}},
                     {    18, {(PHUFFMAN_LUT)   -392}},
                     {    18, {(PHUFFMAN_LUT)   -388}},
                     {    18, {(PHUFFMAN_LUT)   -384}},
                     {    18, {(PHUFFMAN_LUT)   -380}},
                     {    18, {(PHUFFMAN_LUT)   -376}},
                     {    18, {(PHUFFMAN_LUT)   -372}},
                     {    18, {(PHUFFMAN_LUT)   -368}},
                     {    18, {(PHUFFMAN_LUT)   -364}},
                     {    18, {(PHUFFMAN_LUT)   -360}},
                     {    18, {(PHUFFMAN_LUT)   -356}},
                     {    18, {(PHUFFMAN_LUT)   -352}},
                     {    18, {(PHUFFMAN_LUT)   -348}},
                     {    18, {(PHUFFMAN_LUT)   -344}},
                     {    18, {(PHUFFMAN_LUT)   -340}},
                     {    18, {(PHUFFMAN_LUT)   -336}},
                     {    18, {(PHUFFMAN_LUT)   -332}},
                     {    18, {(PHUFFMAN_LUT)   -328}},
                     {    18, {(PHUFFMAN_LUT)   -324}},
                     {    18, {(PHUFFMAN_LUT)   -320}},
                     {    18, {(PHUFFMAN_LUT)   -316}},
                     {    18, {(PHUFFMAN_LUT)   -312}},
                     {    18, {(PHUFFMAN_LUT)   -308}},
                     {    18, {(PHUFFMAN_LUT)   -304}},
                     {    18, {(PHUFFMAN_LUT)   -300}},
                     {    18, {(PHUFFMAN_LUT)   -296}},
                     {    18, {(PHUFFMAN_LUT)   -292}},
                     {    18, {(PHUFFMAN_LUT)   -288}},
                     {    18, {(PHUFFMAN_LUT)   -284}},
                     {    18, {(PHUFFMAN_LUT)   -280}},
                     {    18, {(PHUFFMAN_LUT)   -276}},
                     {    18, {(PHUFFMAN_LUT)   -272}},
                     {    18, {(PHUFFMAN_LUT)   -268}},
                     {    18, {(PHUFFMAN_LUT)   -264}},
                     {    18, {(PHUFFMAN_LUT)   -260}},
                     {    18, {(PHUFFMAN_LUT)   -256}},
                     {    18, {(PHUFFMAN_LUT)   -252}},
                     {    18, {(PHUFFMAN_LUT)   -248}},
                     {    18, {(PHUFFMAN_LUT)   -244}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 278}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 286}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 296}},
                     {    -2, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 306}},
                     {    -3, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 314}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 322}},
                     {    15, {(PHUFFMAN_LUT)     76}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 326}},
                     {    18, {(PHUFFMAN_LUT)   -240}},
                     {    18, {(PHUFFMAN_LUT)   -236}},
                     {    18, {(PHUFFMAN_LUT)   -232}},
                     {    18, {(PHUFFMAN_LUT)   -228}},
                     {    18, {(PHUFFMAN_LUT)   -224}},
                     {    18, {(PHUFFMAN_LUT)   -220}},
                     {    18, {(PHUFFMAN_LUT)   -216}},
                     {    18, {(PHUFFMAN_LUT)   -212}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 290}},
                     {    17, {(PHUFFMAN_LUT)   -200}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 292}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 294}},
                     {    18, {(PHUFFMAN_LUT)   -208}},
                     {    18, {(PHUFFMAN_LUT)   -204}},
                     {    18, {(PHUFFMAN_LUT)   -196}},
                     {    18, {(PHUFFMAN_LUT)   -192}},
                     {    18, {(PHUFFMAN_LUT)   -188}},
                     {    18, {(PHUFFMAN_LUT)   -184}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 300}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 302}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 304}},
                     {    17, {(PHUFFMAN_LUT)   -160}},
                     {    18, {(PHUFFMAN_LUT)   -180}},
                     {    18, {(PHUFFMAN_LUT)   -176}},
                     {    18, {(PHUFFMAN_LUT)   -172}},
                     {    18, {(PHUFFMAN_LUT)   -168}},
                     {    18, {(PHUFFMAN_LUT)   -164}},
                     {    18, {(PHUFFMAN_LUT)   -152}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 310}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 312}},
                     {    17, {(PHUFFMAN_LUT)   -132}},
                     {    17, {(PHUFFMAN_LUT)   -128}},
                     {    18, {(PHUFFMAN_LUT)   -148}},
                     {    18, {(PHUFFMAN_LUT)   -144}},
                     {    18, {(PHUFFMAN_LUT)   -140}},
                     {    18, {(PHUFFMAN_LUT)   -136}},
                     {    18, {(PHUFFMAN_LUT)   -124}},
                     {    18, {(PHUFFMAN_LUT)   -120}},
                     {    18, {(PHUFFMAN_LUT)   -116}},
                     {    18, {(PHUFFMAN_LUT)   -112}},
                     {    18, {(PHUFFMAN_LUT)   -108}},
                     {    18, {(PHUFFMAN_LUT)   -104}},
                     {    18, {(PHUFFMAN_LUT)   -100}},
                     {    18, {(PHUFFMAN_LUT)    112}},
                     {    16, {(PHUFFMAN_LUT)    -84}},
                     {    -1, {(PHUFFMAN_LUT) _hufNoiRelLag_ + 324}},
                     {    17, {(PHUFFMAN_LUT)     84}},
                     {    17, {(PHUFFMAN_LUT)    100}},
                     {    16, {(PHUFFMAN_LUT)     96}},
                     {    16, {(PHUFFMAN_LUT)    104}},
                     {     4, {(PHUFFMAN_LUT)     -8}},
                     {     4, {(PHUFFMAN_LUT)      8}}};

const HUFFMAN_DECODER hufNoiRelLag = {(PHUFFMAN_LUT)_hufNoiRelLag_, 1};
/*********************************************************************/
