/***********************************************************************
MPEG-4 Audio RM Module
Parametric based codec - SSC (SinuSoidal Coding) bit stream Encoder

This software was originally developed by:
* Arno Peters, Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
* Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
* Werner Oomen, Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

And edited by:
*

in the course of development of the MPEG-4 Audio standard ISO-14496-1, 2 and 3. 
This software module is an implementation of a part of one or more MPEG-4 Audio
tools as specified by the MPEG-4 Audio standard. ISO/IEC gives users of the 
MPEG-4 Audio standards free licence to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the 
MPEG-4 Audio standards. Those intending to use this software module in hardware
or software products are advised that this use may infringe existing patents.
The original developers of this software of this module and their company, 
the subsequent editors and their companies, and ISO/EIC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio conforming products. The 
original developer retains full right to use this code for his/her own purpose,
assign or donate the code to a third party and to inhibit third party from
using the code for non MPEG-4 Audio conforming products. This copyright notice
must be included in all copies of derivative works.

Copyright  2001.

Source file: hufFreqSinAbs.c

Required libraries: <none>

Authors:
AP:	Arno Peters,   Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
JD:	Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
WO:	Werner Oomen,  Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

Changes:
07 Nov 2001	JD	Initial version
03 Dec 2001 JD  Improved huffman table
************************************************************************/

#include "HuffmanDecoder.h"

/*********************************************************************
* Definition of hufFreqSinAbs huffman decoder
* (Automatically generated - casting needed to avoid warnings on MSVC)
**********************************************************************/
static const HUFFMAN_LUT _hufFreqSinAbs_[] =
                    {{    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 130}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 136}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 138}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 140}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 142}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 146}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 148}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 150}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 154}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 156}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 160}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 162}},
                     {     7, {(PHUFFMAN_LUT)   1688}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 166}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 172}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 174}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 176}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 178}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 180}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 184}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 188}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 190}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 192}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 194}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 196}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 204}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 206}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 210}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 212}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 214}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 228}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 232}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 234}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 236}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 238}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 240}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 242}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 246}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 250}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 252}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 254}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 256}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 258}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 260}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 270}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 274}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 276}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 284}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 286}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 288}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 290}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 292}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 298}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 308}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 310}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 314}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 318}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 322}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 324}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 326}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 332}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 334}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 336}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 338}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 342}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 346}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 348}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 352}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 354}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 358}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 364}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 366}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 370}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 378}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 382}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 386}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 388}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 392}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 394}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 398}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 406}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 412}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 416}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 420}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 422}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 426}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 430}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 432}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 434}},
                     {    -4, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 436}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 552}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 556}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 560}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 564}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 568}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 572}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 576}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 580}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 582}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 584}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 590}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 594}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 598}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 604}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 620}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 630}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 634}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 638}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 642}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 646}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 652}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 656}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 660}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 664}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 670}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 676}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 680}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 684}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 688}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 690}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 700}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 706}},
                     {     8, {(PHUFFMAN_LUT)   2304}},
                     {     8, {(PHUFFMAN_LUT)   2384}},
                     {     8, {(PHUFFMAN_LUT)   2440}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 132}},
                     {    10, {(PHUFFMAN_LUT)   3048}},
                     {    10, {(PHUFFMAN_LUT)   3128}},
                     {    10, {(PHUFFMAN_LUT)   3184}},
                     {    10, {(PHUFFMAN_LUT)   3264}},
                     {     8, {(PHUFFMAN_LUT)    520}},
                     {     8, {(PHUFFMAN_LUT)    624}},
                     {     8, {(PHUFFMAN_LUT)    712}},
                     {     8, {(PHUFFMAN_LUT)   1136}},
                     {     8, {(PHUFFMAN_LUT)   1360}},
                     {     8, {(PHUFFMAN_LUT)   1432}},
                     {     8, {(PHUFFMAN_LUT)   1568}},
                     {     8, {(PHUFFMAN_LUT)   1736}},
                     {     8, {(PHUFFMAN_LUT)   1760}},
                     {     8, {(PHUFFMAN_LUT)   1856}},
                     {     8, {(PHUFFMAN_LUT)   2176}},
                     {     8, {(PHUFFMAN_LUT)   2216}},
                     {     8, {(PHUFFMAN_LUT)   2272}},
                     {     8, {(PHUFFMAN_LUT)    208}},
                     {     9, {(PHUFFMAN_LUT)    328}},
                     {     9, {(PHUFFMAN_LUT)    336}},
                     {     9, {(PHUFFMAN_LUT)    352}},
                     {     9, {(PHUFFMAN_LUT)    976}},
                     {     8, {(PHUFFMAN_LUT)    400}},
                     {     8, {(PHUFFMAN_LUT)   1696}},
                     {     8, {(PHUFFMAN_LUT)   1792}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 158}},
                     {     9, {(PHUFFMAN_LUT)   1848}},
                     {     9, {(PHUFFMAN_LUT)   2680}},
                     {     8, {(PHUFFMAN_LUT)   2224}},
                     {     8, {(PHUFFMAN_LUT)   2328}},
                     {     8, {(PHUFFMAN_LUT)   2616}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 164}},
                     {     9, {(PHUFFMAN_LUT)   2728}},
                     {     9, {(PHUFFMAN_LUT)   3000}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 168}},
                     {     8, {(PHUFFMAN_LUT)    480}},
                     {     9, {(PHUFFMAN_LUT)   3144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 170}},
                     {    10, {(PHUFFMAN_LUT)   3336}},
                     {    10, {(PHUFFMAN_LUT)   2768}},
                     {     8, {(PHUFFMAN_LUT)    528}},
                     {     8, {(PHUFFMAN_LUT)   1728}},
                     {     8, {(PHUFFMAN_LUT)   1744}},
                     {     8, {(PHUFFMAN_LUT)   1984}},
                     {     8, {(PHUFFMAN_LUT)   2336}},
                     {     8, {(PHUFFMAN_LUT)   2360}},
                     {     8, {(PHUFFMAN_LUT)   2376}},
                     {     8, {(PHUFFMAN_LUT)   2472}},
                     {     8, {(PHUFFMAN_LUT)   2936}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 182}},
                     {     9, {(PHUFFMAN_LUT)    176}},
                     {     9, {(PHUFFMAN_LUT)    312}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 186}},
                     {     8, {(PHUFFMAN_LUT)    896}},
                     {     9, {(PHUFFMAN_LUT)    728}},
                     {     9, {(PHUFFMAN_LUT)   1168}},
                     {     8, {(PHUFFMAN_LUT)   1584}},
                     {     8, {(PHUFFMAN_LUT)   1880}},
                     {     8, {(PHUFFMAN_LUT)   1968}},
                     {     8, {(PHUFFMAN_LUT)   2008}},
                     {     8, {(PHUFFMAN_LUT)   2072}},
                     {     8, {(PHUFFMAN_LUT)   2128}},
                     {     8, {(PHUFFMAN_LUT)   2208}},
                     {     8, {(PHUFFMAN_LUT)   2408}},
                     {     9, {(PHUFFMAN_LUT)   2688}},
                     {     9, {(PHUFFMAN_LUT)   2904}},
                     {     9, {(PHUFFMAN_LUT)   2960}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 200}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 202}},
                     {    10, {(PHUFFMAN_LUT)   3176}},
                     {    11, {(PHUFFMAN_LUT)   2992}},
                     {    11, {(PHUFFMAN_LUT)   3096}},
                     {     8, {(PHUFFMAN_LUT)    368}},
                     {     8, {(PHUFFMAN_LUT)    984}},
                     {     8, {(PHUFFMAN_LUT)   1008}},
                     {     8, {(PHUFFMAN_LUT)   1184}},
                     {     8, {(PHUFFMAN_LUT)   1264}},
                     {     8, {(PHUFFMAN_LUT)   1600}},
                     {     8, {(PHUFFMAN_LUT)   2264}},
                     {     8, {(PHUFFMAN_LUT)   2312}},
                     {     8, {(PHUFFMAN_LUT)   2352}},
                     {     8, {(PHUFFMAN_LUT)   2520}},
                     {     8, {(PHUFFMAN_LUT)   2576}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 216}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 218}},
                     {     9, {(PHUFFMAN_LUT)    240}},
                     {    11, {(PHUFFMAN_LUT)   3208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 222}},
                     {    11, {(PHUFFMAN_LUT)   3304}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 224}},
                     {    12, {(PHUFFMAN_LUT)   3296}},
                     {    12, {(PHUFFMAN_LUT)   3312}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 226}},
                     {    12, {(PHUFFMAN_LUT)   3344}},
                     {    13, {(PHUFFMAN_LUT)   3328}},
                     {    13, {(PHUFFMAN_LUT)   3360}},
                     {     8, {(PHUFFMAN_LUT)    184}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 230}},
                     {     9, {(PHUFFMAN_LUT)    376}},
                     {     9, {(PHUFFMAN_LUT)   1152}},
                     {     8, {(PHUFFMAN_LUT)    568}},
                     {     8, {(PHUFFMAN_LUT)    904}},
                     {     8, {(PHUFFMAN_LUT)   1544}},
                     {     8, {(PHUFFMAN_LUT)   1752}},
                     {     8, {(PHUFFMAN_LUT)   1800}},
                     {     8, {(PHUFFMAN_LUT)   1824}},
                     {     8, {(PHUFFMAN_LUT)   1888}},
                     {     8, {(PHUFFMAN_LUT)   2104}},
                     {     8, {(PHUFFMAN_LUT)   2320}},
                     {     8, {(PHUFFMAN_LUT)   2456}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 244}},
                     {     8, {(PHUFFMAN_LUT)   2624}},
                     {     9, {(PHUFFMAN_LUT)   2544}},
                     {     9, {(PHUFFMAN_LUT)   2760}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 248}},
                     {     8, {(PHUFFMAN_LUT)    584}},
                     {     9, {(PHUFFMAN_LUT)   2784}},
                     {     9, {(PHUFFMAN_LUT)   2840}},
                     {     8, {(PHUFFMAN_LUT)    752}},
                     {     8, {(PHUFFMAN_LUT)   1256}},
                     {     8, {(PHUFFMAN_LUT)   1312}},
                     {     8, {(PHUFFMAN_LUT)   1416}},
                     {     8, {(PHUFFMAN_LUT)   1480}},
                     {     8, {(PHUFFMAN_LUT)   1536}},
                     {     8, {(PHUFFMAN_LUT)   1648}},
                     {     8, {(PHUFFMAN_LUT)   1720}},
                     {     8, {(PHUFFMAN_LUT)   1872}},
                     {     8, {(PHUFFMAN_LUT)   2088}},
                     {     8, {(PHUFFMAN_LUT)   2296}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 262}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 264}},
                     {     9, {(PHUFFMAN_LUT)    280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 266}},
                     {    10, {(PHUFFMAN_LUT)   3024}},
                     {    11, {(PHUFFMAN_LUT)   3384}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 268}},
                     {    12, {(PHUFFMAN_LUT)   3392}},
                     {    12, {(PHUFFMAN_LUT)   3400}},
                     {     9, {(PHUFFMAN_LUT)    408}},
                     {     9, {(PHUFFMAN_LUT)    432}},
                     {     9, {(PHUFFMAN_LUT)    488}},
                     {     9, {(PHUFFMAN_LUT)    744}},
                     {     8, {(PHUFFMAN_LUT)    640}},
                     {     8, {(PHUFFMAN_LUT)    648}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 278}},
                     {     8, {(PHUFFMAN_LUT)    920}},
                     {     9, {(PHUFFMAN_LUT)    760}},
                     {     9, {(PHUFFMAN_LUT)    816}},
                     {     9, {(PHUFFMAN_LUT)    936}},
                     {     9, {(PHUFFMAN_LUT)    944}},
                     {     9, {(PHUFFMAN_LUT)    952}},
                     {     9, {(PHUFFMAN_LUT)   2424}},
                     {     8, {(PHUFFMAN_LUT)    992}},
                     {     8, {(PHUFFMAN_LUT)   1336}},
                     {     8, {(PHUFFMAN_LUT)   1344}},
                     {     8, {(PHUFFMAN_LUT)   1472}},
                     {     8, {(PHUFFMAN_LUT)   1488}},
                     {     8, {(PHUFFMAN_LUT)   1504}},
                     {     8, {(PHUFFMAN_LUT)   1560}},
                     {     8, {(PHUFFMAN_LUT)   2288}},
                     {     9, {(PHUFFMAN_LUT)   2720}},
                     {     9, {(PHUFFMAN_LUT)   2952}},
                     {     9, {(PHUFFMAN_LUT)   2984}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 296}},
                     {    10, {(PHUFFMAN_LUT)   3080}},
                     {    10, {(PHUFFMAN_LUT)   3136}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 300}},
                     {     8, {(PHUFFMAN_LUT)    840}},
                     {    10, {(PHUFFMAN_LUT)   3192}},
                     {    10, {(PHUFFMAN_LUT)   3272}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 304}},
                     {    10, {(PHUFFMAN_LUT)    304}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 306}},
                     {    11, {(PHUFFMAN_LUT)   3072}},
                     {    12, {(PHUFFMAN_LUT)   3424}},
                     {    12, {(PHUFFMAN_LUT)   3480}},
                     {     8, {(PHUFFMAN_LUT)    856}},
                     {     8, {(PHUFFMAN_LUT)   1608}},
                     {     8, {(PHUFFMAN_LUT)   2032}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 312}},
                     {     9, {(PHUFFMAN_LUT)    384}},
                     {     9, {(PHUFFMAN_LUT)    392}},
                     {     9, {(PHUFFMAN_LUT)    440}},
                     {     9, {(PHUFFMAN_LUT)    448}},
                     {     9, {(PHUFFMAN_LUT)    616}},
                     {     9, {(PHUFFMAN_LUT)    768}},
                     {     9, {(PHUFFMAN_LUT)    864}},
                     {     9, {(PHUFFMAN_LUT)   1016}},
                     {     9, {(PHUFFMAN_LUT)   1384}},
                     {     9, {(PHUFFMAN_LUT)   2592}},
                     {     8, {(PHUFFMAN_LUT)   1576}},
                     {     8, {(PHUFFMAN_LUT)   1616}},
                     {     8, {(PHUFFMAN_LUT)   1840}},
                     {     8, {(PHUFFMAN_LUT)   2024}},
                     {     8, {(PHUFFMAN_LUT)   2144}},
                     {     8, {(PHUFFMAN_LUT)   2432}},
                     {     9, {(PHUFFMAN_LUT)   2600}},
                     {     9, {(PHUFFMAN_LUT)   2648}},
                     {     9, {(PHUFFMAN_LUT)   2656}},
                     {     9, {(PHUFFMAN_LUT)   2824}},
                     {     8, {(PHUFFMAN_LUT)    696}},
                     {     8, {(PHUFFMAN_LUT)   1000}},
                     {     8, {(PHUFFMAN_LUT)   1864}},
                     {     8, {(PHUFFMAN_LUT)   1960}},
                     {     8, {(PHUFFMAN_LUT)   1976}},
                     {     8, {(PHUFFMAN_LUT)   2416}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 340}},
                     {     8, {(PHUFFMAN_LUT)    632}},
                     {     9, {(PHUFFMAN_LUT)    168}},
                     {     9, {(PHUFFMAN_LUT)    296}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 344}},
                     {     8, {(PHUFFMAN_LUT)   1376}},
                     {     9, {(PHUFFMAN_LUT)    720}},
                     {     9, {(PHUFFMAN_LUT)   1640}},
                     {     8, {(PHUFFMAN_LUT)   1400}},
                     {     8, {(PHUFFMAN_LUT)   1496}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 350}},
                     {     8, {(PHUFFMAN_LUT)   1912}},
                     {     9, {(PHUFFMAN_LUT)   1664}},
                     {     9, {(PHUFFMAN_LUT)   2392}},
                     {     8, {(PHUFFMAN_LUT)   2064}},
                     {     8, {(PHUFFMAN_LUT)   2152}},
                     {     8, {(PHUFFMAN_LUT)   2184}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 356}},
                     {     9, {(PHUFFMAN_LUT)   2528}},
                     {     9, {(PHUFFMAN_LUT)   2632}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 360}},
                     {     8, {(PHUFFMAN_LUT)    576}},
                     {     9, {(PHUFFMAN_LUT)   2848}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 362}},
                     {    10, {(PHUFFMAN_LUT)   2968}},
                     {    10, {(PHUFFMAN_LUT)   3016}},
                     {     8, {(PHUFFMAN_LUT)   1520}},
                     {     8, {(PHUFFMAN_LUT)   1528}},
                     {     8, {(PHUFFMAN_LUT)   1656}},
                     {     8, {(PHUFFMAN_LUT)   1920}},
                     {     8, {(PHUFFMAN_LUT)   2000}},
                     {     8, {(PHUFFMAN_LUT)   2056}},
                     {     8, {(PHUFFMAN_LUT)   2120}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 372}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 374}},
                     {     9, {(PHUFFMAN_LUT)    272}},
                     {    10, {(PHUFFMAN_LUT)   3064}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 376}},
                     {    11, {(PHUFFMAN_LUT)   3152}},
                     {    11, {(PHUFFMAN_LUT)   3240}},
                     {     9, {(PHUFFMAN_LUT)    472}},
                     {     9, {(PHUFFMAN_LUT)    664}},
                     {     9, {(PHUFFMAN_LUT)   1048}},
                     {     9, {(PHUFFMAN_LUT)   1096}},
                     {     9, {(PHUFFMAN_LUT)   1104}},
                     {     9, {(PHUFFMAN_LUT)   1144}},
                     {     9, {(PHUFFMAN_LUT)   1208}},
                     {     9, {(PHUFFMAN_LUT)   1352}},
                     {     8, {(PHUFFMAN_LUT)   1456}},
                     {     8, {(PHUFFMAN_LUT)   1672}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 390}},
                     {     8, {(PHUFFMAN_LUT)   1928}},
                     {     9, {(PHUFFMAN_LUT)   1808}},
                     {     9, {(PHUFFMAN_LUT)   2568}},
                     {     8, {(PHUFFMAN_LUT)   2200}},
                     {     8, {(PHUFFMAN_LUT)   2280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 396}},
                     {     8, {(PHUFFMAN_LUT)    592}},
                     {     9, {(PHUFFMAN_LUT)   2800}},
                     {     9, {(PHUFFMAN_LUT)   2816}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 402}},
                     {     9, {(PHUFFMAN_LUT)    232}},
                     {     9, {(PHUFFMAN_LUT)    600}},
                     {     9, {(PHUFFMAN_LUT)    656}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 404}},
                     {    10, {(PHUFFMAN_LUT)    464}},
                     {    11, {(PHUFFMAN_LUT)   3320}},
                     {    11, {(PHUFFMAN_LUT)   3376}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 408}},
                     {     8, {(PHUFFMAN_LUT)    688}},
                     {     9, {(PHUFFMAN_LUT)    680}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 410}},
                     {    10, {(PHUFFMAN_LUT)    824}},
                     {    10, {(PHUFFMAN_LUT)   2880}},
                     {     9, {(PHUFFMAN_LUT)    888}},
                     {     9, {(PHUFFMAN_LUT)    968}},
                     {     9, {(PHUFFMAN_LUT)   1032}},
                     {     9, {(PHUFFMAN_LUT)   1112}},
                     {     9, {(PHUFFMAN_LUT)   1160}},
                     {     9, {(PHUFFMAN_LUT)   1224}},
                     {     9, {(PHUFFMAN_LUT)   1232}},
                     {     9, {(PHUFFMAN_LUT)   1936}},
                     {     8, {(PHUFFMAN_LUT)   1704}},
                     {     8, {(PHUFFMAN_LUT)   2160}},
                     {     9, {(PHUFFMAN_LUT)   2448}},
                     {     9, {(PHUFFMAN_LUT)   2480}},
                     {     9, {(PHUFFMAN_LUT)   2512}},
                     {     9, {(PHUFFMAN_LUT)   2560}},
                     {     9, {(PHUFFMAN_LUT)   2584}},
                     {     9, {(PHUFFMAN_LUT)   2664}},
                     {     9, {(PHUFFMAN_LUT)   2792}},
                     {     9, {(PHUFFMAN_LUT)   3008}},
                     {     8, {(PHUFFMAN_LUT)   1056}},
                     {     8, {(PHUFFMAN_LUT)   1064}},
                     {     8, {(PHUFFMAN_LUT)   1832}},
                     {     8, {(PHUFFMAN_LUT)   2048}},
                     {     8, {(PHUFFMAN_LUT)   2080}},
                     {     8, {(PHUFFMAN_LUT)   2112}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {    10, {(PHUFFMAN_LUT)   3120}},
                     {    10, {(PHUFFMAN_LUT)   3120}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 452}},
                     {    11, {(PHUFFMAN_LUT)    160}},
                     {     9, {(PHUFFMAN_LUT)    192}},
                     {     9, {(PHUFFMAN_LUT)    192}},
                     {     9, {(PHUFFMAN_LUT)    192}},
                     {     9, {(PHUFFMAN_LUT)    192}},
                     {    13, {(PHUFFMAN_LUT)   3408}},
                     {    13, {(PHUFFMAN_LUT)   3408}},
                     {    -6, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 460}},
                     {    14, {(PHUFFMAN_LUT)    136}},
                     {    12, {(PHUFFMAN_LUT)    152}},
                     {    12, {(PHUFFMAN_LUT)    152}},
                     {    12, {(PHUFFMAN_LUT)    152}},
                     {    12, {(PHUFFMAN_LUT)    152}},
                     {    20, {(PHUFFMAN_LUT)   3488}},
                     {    20, {(PHUFFMAN_LUT)   3496}},
                     {    20, {(PHUFFMAN_LUT)   3504}},
                     {    20, {(PHUFFMAN_LUT)   3512}},
                     {    20, {(PHUFFMAN_LUT)   3520}},
                     {    20, {(PHUFFMAN_LUT)   3528}},
                     {    20, {(PHUFFMAN_LUT)   3536}},
                     {    20, {(PHUFFMAN_LUT)   3544}},
                     {    20, {(PHUFFMAN_LUT)   3552}},
                     {    20, {(PHUFFMAN_LUT)   3560}},
                     {    20, {(PHUFFMAN_LUT)   3568}},
                     {    20, {(PHUFFMAN_LUT)   3576}},
                     {    20, {(PHUFFMAN_LUT)   3584}},
                     {    20, {(PHUFFMAN_LUT)   3592}},
                     {    20, {(PHUFFMAN_LUT)   3600}},
                     {    20, {(PHUFFMAN_LUT)   3608}},
                     {    20, {(PHUFFMAN_LUT)   3616}},
                     {    20, {(PHUFFMAN_LUT)   3624}},
                     {    20, {(PHUFFMAN_LUT)   3632}},
                     {    20, {(PHUFFMAN_LUT)   3640}},
                     {    20, {(PHUFFMAN_LUT)   3648}},
                     {    20, {(PHUFFMAN_LUT)   3656}},
                     {    20, {(PHUFFMAN_LUT)   3664}},
                     {    20, {(PHUFFMAN_LUT)   3672}},
                     {    20, {(PHUFFMAN_LUT)   3680}},
                     {    20, {(PHUFFMAN_LUT)   3688}},
                     {    20, {(PHUFFMAN_LUT)   3696}},
                     {    20, {(PHUFFMAN_LUT)   3704}},
                     {    20, {(PHUFFMAN_LUT)   3712}},
                     {    20, {(PHUFFMAN_LUT)   3720}},
                     {    20, {(PHUFFMAN_LUT)   3728}},
                     {    20, {(PHUFFMAN_LUT)   3736}},
                     {    20, {(PHUFFMAN_LUT)   3744}},
                     {    20, {(PHUFFMAN_LUT)   3752}},
                     {    20, {(PHUFFMAN_LUT)   3760}},
                     {    20, {(PHUFFMAN_LUT)   3768}},
                     {    20, {(PHUFFMAN_LUT)   3776}},
                     {    20, {(PHUFFMAN_LUT)   3784}},
                     {    20, {(PHUFFMAN_LUT)   3792}},
                     {    20, {(PHUFFMAN_LUT)   3800}},
                     {    20, {(PHUFFMAN_LUT)   3808}},
                     {    20, {(PHUFFMAN_LUT)   3816}},
                     {    20, {(PHUFFMAN_LUT)   3824}},
                     {    20, {(PHUFFMAN_LUT)   3832}},
                     {    20, {(PHUFFMAN_LUT)   3840}},
                     {    20, {(PHUFFMAN_LUT)   3848}},
                     {    20, {(PHUFFMAN_LUT)   3856}},
                     {    20, {(PHUFFMAN_LUT)   3864}},
                     {    20, {(PHUFFMAN_LUT)   3872}},
                     {    20, {(PHUFFMAN_LUT)   3880}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 524}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 526}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 528}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 530}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 532}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 534}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 536}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 538}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 540}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 542}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 544}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 546}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 548}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 550}},
                     {    21, {(PHUFFMAN_LUT)      0}},
                     {    21, {(PHUFFMAN_LUT)      8}},
                     {    21, {(PHUFFMAN_LUT)     16}},
                     {    21, {(PHUFFMAN_LUT)     24}},
                     {    21, {(PHUFFMAN_LUT)     32}},
                     {    21, {(PHUFFMAN_LUT)     40}},
                     {    21, {(PHUFFMAN_LUT)     48}},
                     {    21, {(PHUFFMAN_LUT)     56}},
                     {    21, {(PHUFFMAN_LUT)     64}},
                     {    21, {(PHUFFMAN_LUT)     72}},
                     {    21, {(PHUFFMAN_LUT)     80}},
                     {    21, {(PHUFFMAN_LUT)     88}},
                     {    21, {(PHUFFMAN_LUT)     96}},
                     {    21, {(PHUFFMAN_LUT)    104}},
                     {    21, {(PHUFFMAN_LUT)    112}},
                     {    21, {(PHUFFMAN_LUT)    120}},
                     {    21, {(PHUFFMAN_LUT)    128}},
                     {    21, {(PHUFFMAN_LUT)    144}},
                     {    21, {(PHUFFMAN_LUT)   3216}},
                     {    21, {(PHUFFMAN_LUT)   3280}},
                     {    21, {(PHUFFMAN_LUT)   3352}},
                     {    21, {(PHUFFMAN_LUT)   3416}},
                     {    21, {(PHUFFMAN_LUT)   3432}},
                     {    21, {(PHUFFMAN_LUT)   3440}},
                     {    21, {(PHUFFMAN_LUT)   3448}},
                     {    21, {(PHUFFMAN_LUT)   3456}},
                     {    21, {(PHUFFMAN_LUT)   3464}},
                     {    21, {(PHUFFMAN_LUT)   3472}},
                     {     9, {(PHUFFMAN_LUT)    360}},
                     {     9, {(PHUFFMAN_LUT)    424}},
                     {     9, {(PHUFFMAN_LUT)    512}},
                     {     9, {(PHUFFMAN_LUT)    560}},
                     {     9, {(PHUFFMAN_LUT)    800}},
                     {     9, {(PHUFFMAN_LUT)   1024}},
                     {     9, {(PHUFFMAN_LUT)   1120}},
                     {     9, {(PHUFFMAN_LUT)   1200}},
                     {     8, {(PHUFFMAN_LUT)   1368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 562}},
                     {     9, {(PHUFFMAN_LUT)   1680}},
                     {     9, {(PHUFFMAN_LUT)   1816}},
                     {     8, {(PHUFFMAN_LUT)   1776}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 566}},
                     {     9, {(PHUFFMAN_LUT)   1944}},
                     {     9, {(PHUFFMAN_LUT)   2136}},
                     {     8, {(PHUFFMAN_LUT)   2368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 570}},
                     {     9, {(PHUFFMAN_LUT)   2400}},
                     {     9, {(PHUFFMAN_LUT)   2488}},
                     {     9, {(PHUFFMAN_LUT)   2608}},
                     {     9, {(PHUFFMAN_LUT)   2672}},
                     {     9, {(PHUFFMAN_LUT)   2744}},
                     {     9, {(PHUFFMAN_LUT)   2776}},
                     {     9, {(PHUFFMAN_LUT)   2864}},
                     {     9, {(PHUFFMAN_LUT)   2928}},
                     {     9, {(PHUFFMAN_LUT)   3032}},
                     {     9, {(PHUFFMAN_LUT)   3088}},
                     {     8, {(PHUFFMAN_LUT)    848}},
                     {     8, {(PHUFFMAN_LUT)    912}},
                     {     8, {(PHUFFMAN_LUT)   1328}},
                     {     8, {(PHUFFMAN_LUT)   1624}},
                     {     8, {(PHUFFMAN_LUT)   1784}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 586}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 588}},
                     {     9, {(PHUFFMAN_LUT)    704}},
                     {    10, {(PHUFFMAN_LUT)    456}},
                     {    10, {(PHUFFMAN_LUT)   1280}},
                     {     9, {(PHUFFMAN_LUT)    736}},
                     {     9, {(PHUFFMAN_LUT)    784}},
                     {     9, {(PHUFFMAN_LUT)    880}},
                     {     9, {(PHUFFMAN_LUT)   1296}},
                     {     8, {(PHUFFMAN_LUT)   1072}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 596}},
                     {     9, {(PHUFFMAN_LUT)   1512}},
                     {     9, {(PHUFFMAN_LUT)   2232}},
                     {     9, {(PHUFFMAN_LUT)   2240}},
                     {     9, {(PHUFFMAN_LUT)   2344}},
                     {     9, {(PHUFFMAN_LUT)   2552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 602}},
                     {    10, {(PHUFFMAN_LUT)   2712}},
                     {    10, {(PHUFFMAN_LUT)   2888}},
                     {     9, {(PHUFFMAN_LUT)   2872}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 608}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 612}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 616}},
                     {    10, {(PHUFFMAN_LUT)   2912}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 610}},
                     {    11, {(PHUFFMAN_LUT)   2920}},
                     {    11, {(PHUFFMAN_LUT)   2944}},
                     {    10, {(PHUFFMAN_LUT)   2976}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 614}},
                     {    11, {(PHUFFMAN_LUT)   3104}},
                     {    11, {(PHUFFMAN_LUT)   3160}},
                     {    10, {(PHUFFMAN_LUT)   3112}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 618}},
                     {    11, {(PHUFFMAN_LUT)   3168}},
                     {    11, {(PHUFFMAN_LUT)   3200}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 622}},
                     {     8, {(PHUFFMAN_LUT)   1080}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 624}},
                     {     9, {(PHUFFMAN_LUT)    872}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 626}},
                     {    10, {(PHUFFMAN_LUT)   3232}},
                     {    12, {(PHUFFMAN_LUT)   3224}},
                     {    12, {(PHUFFMAN_LUT)   3248}},
                     {    12, {(PHUFFMAN_LUT)   3288}},
                     {    12, {(PHUFFMAN_LUT)   3368}},
                     {     9, {(PHUFFMAN_LUT)    928}},
                     {     9, {(PHUFFMAN_LUT)    960}},
                     {     9, {(PHUFFMAN_LUT)   1128}},
                     {     9, {(PHUFFMAN_LUT)   1176}},
                     {     9, {(PHUFFMAN_LUT)   1216}},
                     {     9, {(PHUFFMAN_LUT)   1240}},
                     {     9, {(PHUFFMAN_LUT)   1248}},
                     {     9, {(PHUFFMAN_LUT)   1272}},
                     {     9, {(PHUFFMAN_LUT)   1304}},
                     {     9, {(PHUFFMAN_LUT)   1424}},
                     {     9, {(PHUFFMAN_LUT)   1552}},
                     {     9, {(PHUFFMAN_LUT)   2504}},
                     {     8, {(PHUFFMAN_LUT)   1992}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 644}},
                     {     9, {(PHUFFMAN_LUT)   2640}},
                     {     9, {(PHUFFMAN_LUT)   2696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 650}},
                     {     9, {(PHUFFMAN_LUT)    200}},
                     {     9, {(PHUFFMAN_LUT)    216}},
                     {     9, {(PHUFFMAN_LUT)    264}},
                     {    10, {(PHUFFMAN_LUT)   3256}},
                     {    10, {(PHUFFMAN_LUT)   2704}},
                     {     9, {(PHUFFMAN_LUT)    504}},
                     {     9, {(PHUFFMAN_LUT)    536}},
                     {     9, {(PHUFFMAN_LUT)    552}},
                     {     9, {(PHUFFMAN_LUT)    672}},
                     {     9, {(PHUFFMAN_LUT)    808}},
                     {     9, {(PHUFFMAN_LUT)   1088}},
                     {     9, {(PHUFFMAN_LUT)   1440}},
                     {     9, {(PHUFFMAN_LUT)   1712}},
                     {     9, {(PHUFFMAN_LUT)   1768}},
                     {     9, {(PHUFFMAN_LUT)   1896}},
                     {     9, {(PHUFFMAN_LUT)   2040}},
                     {     9, {(PHUFFMAN_LUT)   2096}},
                     {     9, {(PHUFFMAN_LUT)   2168}},
                     {     9, {(PHUFFMAN_LUT)   2536}},
                     {     9, {(PHUFFMAN_LUT)   2736}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 668}},
                     {    10, {(PHUFFMAN_LUT)   2808}},
                     {    10, {(PHUFFMAN_LUT)   2832}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 674}},
                     {     9, {(PHUFFMAN_LUT)    224}},
                     {     9, {(PHUFFMAN_LUT)    256}},
                     {     9, {(PHUFFMAN_LUT)    416}},
                     {    10, {(PHUFFMAN_LUT)   2856}},
                     {    10, {(PHUFFMAN_LUT)   3040}},
                     {     9, {(PHUFFMAN_LUT)    544}},
                     {     9, {(PHUFFMAN_LUT)    608}},
                     {     9, {(PHUFFMAN_LUT)    776}},
                     {     9, {(PHUFFMAN_LUT)    832}},
                     {     9, {(PHUFFMAN_LUT)   1288}},
                     {     9, {(PHUFFMAN_LUT)   1392}},
                     {     9, {(PHUFFMAN_LUT)   1408}},
                     {     9, {(PHUFFMAN_LUT)   1592}},
                     {     9, {(PHUFFMAN_LUT)   2016}},
                     {     9, {(PHUFFMAN_LUT)   2464}},
                     {     9, {(PHUFFMAN_LUT)   2496}},
                     {     9, {(PHUFFMAN_LUT)   2752}},
                     {     8, {(PHUFFMAN_LUT)   1464}},
                     {     8, {(PHUFFMAN_LUT)   2256}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 694}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 698}},
                     {     9, {(PHUFFMAN_LUT)    792}},
                     {    10, {(PHUFFMAN_LUT)   3056}},
                     {    10, {(PHUFFMAN_LUT)    248}},
                     {    10, {(PHUFFMAN_LUT)    288}},
                     {    10, {(PHUFFMAN_LUT)    320}},
                     {    10, {(PHUFFMAN_LUT)    344}},
                     {    10, {(PHUFFMAN_LUT)    496}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqSinAbs_ + 704}},
                     {     9, {(PHUFFMAN_LUT)   1192}},
                     {     9, {(PHUFFMAN_LUT)   1320}},
                     {     9, {(PHUFFMAN_LUT)   1448}},
                     {    10, {(PHUFFMAN_LUT)   1040}},
                     {    10, {(PHUFFMAN_LUT)   2896}},
                     {     9, {(PHUFFMAN_LUT)   1632}},
                     {     9, {(PHUFFMAN_LUT)   1904}},
                     {     9, {(PHUFFMAN_LUT)   1952}},
                     {     9, {(PHUFFMAN_LUT)   2248}}};

const HUFFMAN_DECODER hufFreqSinAbs = {(PHUFFMAN_LUT)_hufFreqSinAbs_, 7};
/*********************************************************************/
