/***********************************************************************
MPEG-4 Audio RM Module
Parametric based codec - SSC (SinuSoidal Coding) bit stream Encoder

This software was originally developed by:
* Arno Peters, Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
* Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
* Werner Oomen, Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

And edited by:
*

in the course of development of the MPEG-4 Audio standard ISO-14496-1, 2 and 3. 
This software module is an implementation of a part of one or more MPEG-4 Audio
tools as specified by the MPEG-4 Audio standard. ISO/IEC gives users of the 
MPEG-4 Audio standards free licence to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the 
MPEG-4 Audio standards. Those intending to use this software module in hardware
or software products are advised that this use may infringe existing patents.
The original developers of this software of this module and their company, 
the subsequent editors and their companies, and ISO/EIC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio conforming products. The 
original developer retains full right to use this code for his/her own purpose,
assign or donate the code to a third party and to inhibit third party from
using the code for non MPEG-4 Audio conforming products. This copyright notice
must be included in all copies of derivative works.

Copyright  2001.

Source file: hufFreqContAbs.c

Required libraries: <none>

Authors:
AP:	Arno Peters,   Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
JD:	Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
WO:	Werner Oomen,  Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

Changes:
07 Nov 2001	JD	Initial version
03 Dec 2001 JD  Improved huffman table
************************************************************************/

#include "HuffmanDecoder.h"

/*********************************************************************
* Definition of hufFreqContAbs huffman decoder
* (Automatically generated - casting needed to avoid warnings on MSVC)
**********************************************************************/
static const HUFFMAN_LUT _hufFreqContAbs_[] =
                    {{    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 128}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 134}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 142}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 146}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 152}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 162}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 164}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 166}},
                     {     7, {(PHUFFMAN_LUT)   2376}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 168}},
                     {     7, {(PHUFFMAN_LUT)   1536}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 170}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 176}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 180}},
                     {     7, {(PHUFFMAN_LUT)   2464}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 182}},
                     {    -4, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 184}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 300}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 302}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 308}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 312}},
                     {     7, {(PHUFFMAN_LUT)   2600}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 314}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 318}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 322}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 330}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 332}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 334}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 342}},
                     {     7, {(PHUFFMAN_LUT)   3032}},
                     {     7, {(PHUFFMAN_LUT)   2552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 344}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 346}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 348}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 350}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 356}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 358}},
                     {     7, {(PHUFFMAN_LUT)   2056}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 360}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 366}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 372}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 374}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 380}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 382}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 384}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 388}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 390}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 394}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 404}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 406}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 414}},
                     {     7, {(PHUFFMAN_LUT)   1832}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 422}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 426}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 434}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 440}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 442}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 446}},
                     {     7, {(PHUFFMAN_LUT)   2696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 448}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 450}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 454}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 456}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 462}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 466}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 468}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 470}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 482}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 484}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 486}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 490}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 496}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 498}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 500}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 502}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 526}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 532}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 534}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 536}},
                     {     7, {(PHUFFMAN_LUT)   2144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 544}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 548}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 556}},
                     {     7, {(PHUFFMAN_LUT)   2368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 558}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 566}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 568}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 574}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 578}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 586}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 588}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 594}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 602}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 604}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 612}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 614}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 620}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 624}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 630}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 634}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 644}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 652}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 654}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 656}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 664}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 668}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 674}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 678}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 686}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 690}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 692}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 700}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 702}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 710}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 712}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 720}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 728}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 732}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 736}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 740}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 750}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 758}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 762}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 766}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 772}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 130}},
                     {     8, {(PHUFFMAN_LUT)   1760}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 132}},
                     {     9, {(PHUFFMAN_LUT)   1640}},
                     {    10, {(PHUFFMAN_LUT)   3344}},
                     {    10, {(PHUFFMAN_LUT)    376}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 138}},
                     {     9, {(PHUFFMAN_LUT)   2944}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 140}},
                     {     9, {(PHUFFMAN_LUT)   3288}},
                     {    10, {(PHUFFMAN_LUT)    304}},
                     {    10, {(PHUFFMAN_LUT)   3280}},
                     {    10, {(PHUFFMAN_LUT)    216}},
                     {    10, {(PHUFFMAN_LUT)    472}},
                     {     8, {(PHUFFMAN_LUT)    792}},
                     {     8, {(PHUFFMAN_LUT)   1768}},
                     {     8, {(PHUFFMAN_LUT)   3320}},
                     {     8, {(PHUFFMAN_LUT)    696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 148}},
                     {     8, {(PHUFFMAN_LUT)   1608}},
                     {     9, {(PHUFFMAN_LUT)   1472}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 150}},
                     {    10, {(PHUFFMAN_LUT)    536}},
                     {    10, {(PHUFFMAN_LUT)    664}},
                     {     9, {(PHUFFMAN_LUT)   3232}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 156}},
                     {     9, {(PHUFFMAN_LUT)   2808}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 160}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 158}},
                     {    10, {(PHUFFMAN_LUT)   3328}},
                     {    11, {(PHUFFMAN_LUT)   3408}},
                     {    11, {(PHUFFMAN_LUT)   3400}},
                     {    10, {(PHUFFMAN_LUT)    544}},
                     {    10, {(PHUFFMAN_LUT)    208}},
                     {     8, {(PHUFFMAN_LUT)   2024}},
                     {     8, {(PHUFFMAN_LUT)   2848}},
                     {     8, {(PHUFFMAN_LUT)   2064}},
                     {     8, {(PHUFFMAN_LUT)   1344}},
                     {     8, {(PHUFFMAN_LUT)   1816}},
                     {     8, {(PHUFFMAN_LUT)   1824}},
                     {     8, {(PHUFFMAN_LUT)    944}},
                     {     8, {(PHUFFMAN_LUT)   2896}},
                     {     9, {(PHUFFMAN_LUT)    760}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 174}},
                     {     9, {(PHUFFMAN_LUT)    408}},
                     {     9, {(PHUFFMAN_LUT)    992}},
                     {    10, {(PHUFFMAN_LUT)    336}},
                     {    10, {(PHUFFMAN_LUT)    984}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 178}},
                     {     8, {(PHUFFMAN_LUT)   1976}},
                     {     9, {(PHUFFMAN_LUT)   1360}},
                     {     9, {(PHUFFMAN_LUT)   1552}},
                     {     8, {(PHUFFMAN_LUT)   2096}},
                     {     8, {(PHUFFMAN_LUT)   1736}},
                     {     8, {(PHUFFMAN_LUT)   2448}},
                     {     8, {(PHUFFMAN_LUT)   3024}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {     8, {(PHUFFMAN_LUT)   3152}},
                     {    10, {(PHUFFMAN_LUT)   3264}},
                     {    10, {(PHUFFMAN_LUT)   3264}},
                     {    11, {(PHUFFMAN_LUT)    456}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 200}},
                     {     9, {(PHUFFMAN_LUT)    584}},
                     {     9, {(PHUFFMAN_LUT)    584}},
                     {     9, {(PHUFFMAN_LUT)    584}},
                     {     9, {(PHUFFMAN_LUT)    584}},
                     {    13, {(PHUFFMAN_LUT)    144}},
                     {    13, {(PHUFFMAN_LUT)    144}},
                     {    13, {(PHUFFMAN_LUT)   3416}},
                     {    13, {(PHUFFMAN_LUT)   3416}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 298}},
                     {    13, {(PHUFFMAN_LUT)    152}},
                     {    13, {(PHUFFMAN_LUT)    152}},
                     {    15, {(PHUFFMAN_LUT)   3448}},
                     {    15, {(PHUFFMAN_LUT)   3448}},
                     {    16, {(PHUFFMAN_LUT)    104}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 212}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 214}},
                     {    17, {(PHUFFMAN_LUT)    112}},
                     {    18, {(PHUFFMAN_LUT)     96}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 216}},
                     {    -5, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 218}},
                     {    19, {(PHUFFMAN_LUT)     80}},
                     {    24, {(PHUFFMAN_LUT)   3824}},
                     {    24, {(PHUFFMAN_LUT)   3832}},
                     {    24, {(PHUFFMAN_LUT)   3840}},
                     {    24, {(PHUFFMAN_LUT)   3848}},
                     {    24, {(PHUFFMAN_LUT)   3856}},
                     {    24, {(PHUFFMAN_LUT)   3864}},
                     {    24, {(PHUFFMAN_LUT)   3872}},
                     {    24, {(PHUFFMAN_LUT)   3880}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 250}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 252}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 254}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 256}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 258}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 260}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 262}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 264}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 266}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 268}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 270}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 272}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 274}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 276}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 278}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 282}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 284}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 286}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 288}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 290}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 292}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 294}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 296}},
                     {    25, {(PHUFFMAN_LUT)      0}},
                     {    25, {(PHUFFMAN_LUT)      8}},
                     {    25, {(PHUFFMAN_LUT)     16}},
                     {    25, {(PHUFFMAN_LUT)     24}},
                     {    25, {(PHUFFMAN_LUT)     32}},
                     {    25, {(PHUFFMAN_LUT)     40}},
                     {    25, {(PHUFFMAN_LUT)     48}},
                     {    25, {(PHUFFMAN_LUT)     56}},
                     {    25, {(PHUFFMAN_LUT)     64}},
                     {    25, {(PHUFFMAN_LUT)     72}},
                     {    25, {(PHUFFMAN_LUT)     88}},
                     {    25, {(PHUFFMAN_LUT)   3504}},
                     {    25, {(PHUFFMAN_LUT)   3512}},
                     {    25, {(PHUFFMAN_LUT)   3536}},
                     {    25, {(PHUFFMAN_LUT)   3552}},
                     {    25, {(PHUFFMAN_LUT)   3560}},
                     {    25, {(PHUFFMAN_LUT)   3568}},
                     {    25, {(PHUFFMAN_LUT)   3576}},
                     {    25, {(PHUFFMAN_LUT)   3584}},
                     {    25, {(PHUFFMAN_LUT)   3592}},
                     {    25, {(PHUFFMAN_LUT)   3600}},
                     {    25, {(PHUFFMAN_LUT)   3608}},
                     {    25, {(PHUFFMAN_LUT)   3616}},
                     {    25, {(PHUFFMAN_LUT)   3624}},
                     {    25, {(PHUFFMAN_LUT)   3632}},
                     {    25, {(PHUFFMAN_LUT)   3640}},
                     {    25, {(PHUFFMAN_LUT)   3648}},
                     {    25, {(PHUFFMAN_LUT)   3656}},
                     {    25, {(PHUFFMAN_LUT)   3664}},
                     {    25, {(PHUFFMAN_LUT)   3672}},
                     {    25, {(PHUFFMAN_LUT)   3680}},
                     {    25, {(PHUFFMAN_LUT)   3688}},
                     {    25, {(PHUFFMAN_LUT)   3696}},
                     {    25, {(PHUFFMAN_LUT)   3704}},
                     {    25, {(PHUFFMAN_LUT)   3712}},
                     {    25, {(PHUFFMAN_LUT)   3720}},
                     {    25, {(PHUFFMAN_LUT)   3728}},
                     {    25, {(PHUFFMAN_LUT)   3736}},
                     {    25, {(PHUFFMAN_LUT)   3744}},
                     {    25, {(PHUFFMAN_LUT)   3752}},
                     {    25, {(PHUFFMAN_LUT)   3760}},
                     {    25, {(PHUFFMAN_LUT)   3768}},
                     {    25, {(PHUFFMAN_LUT)   3776}},
                     {    25, {(PHUFFMAN_LUT)   3784}},
                     {    25, {(PHUFFMAN_LUT)   3792}},
                     {    25, {(PHUFFMAN_LUT)   3800}},
                     {    25, {(PHUFFMAN_LUT)   3808}},
                     {    25, {(PHUFFMAN_LUT)   3816}},
                     {    15, {(PHUFFMAN_LUT)   3488}},
                     {    15, {(PHUFFMAN_LUT)   3528}},
                     {     8, {(PHUFFMAN_LUT)   3184}},
                     {     8, {(PHUFFMAN_LUT)   1656}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 304}},
                     {     8, {(PHUFFMAN_LUT)   3120}},
                     {     9, {(PHUFFMAN_LUT)   1320}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 306}},
                     {    10, {(PHUFFMAN_LUT)    192}},
                     {    10, {(PHUFFMAN_LUT)   3432}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 310}},
                     {     8, {(PHUFFMAN_LUT)   2904}},
                     {     9, {(PHUFFMAN_LUT)    344}},
                     {     9, {(PHUFFMAN_LUT)   1432}},
                     {     8, {(PHUFFMAN_LUT)   2168}},
                     {     8, {(PHUFFMAN_LUT)   2208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 316}},
                     {     8, {(PHUFFMAN_LUT)   2480}},
                     {     9, {(PHUFFMAN_LUT)    296}},
                     {     9, {(PHUFFMAN_LUT)   1272}},
                     {     8, {(PHUFFMAN_LUT)   1872}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 320}},
                     {     9, {(PHUFFMAN_LUT)   3224}},
                     {     9, {(PHUFFMAN_LUT)    728}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 324}},
                     {     8, {(PHUFFMAN_LUT)   1072}},
                     {     9, {(PHUFFMAN_LUT)   1680}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 326}},
                     {    10, {(PHUFFMAN_LUT)   1304}},
                     {    10, {(PHUFFMAN_LUT)   3352}},
                     {     8, {(PHUFFMAN_LUT)   1888}},
                     {     8, {(PHUFFMAN_LUT)   2216}},
                     {     8, {(PHUFFMAN_LUT)   2664}},
                     {     8, {(PHUFFMAN_LUT)    784}},
                     {     8, {(PHUFFMAN_LUT)   2792}},
                     {     8, {(PHUFFMAN_LUT)   1648}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 336}},
                     {     8, {(PHUFFMAN_LUT)   1784}},
                     {     9, {(PHUFFMAN_LUT)    568}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 338}},
                     {    10, {(PHUFFMAN_LUT)    400}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 340}},
                     {    11, {(PHUFFMAN_LUT)   3480}},
                     {    11, {(PHUFFMAN_LUT)   1216}},
                     {     8, {(PHUFFMAN_LUT)    912}},
                     {     8, {(PHUFFMAN_LUT)   2584}},
                     {     8, {(PHUFFMAN_LUT)   2072}},
                     {     8, {(PHUFFMAN_LUT)   2560}},
                     {     8, {(PHUFFMAN_LUT)   3000}},
                     {     8, {(PHUFFMAN_LUT)   2040}},
                     {     8, {(PHUFFMAN_LUT)   1384}},
                     {     8, {(PHUFFMAN_LUT)   1864}},
                     {     8, {(PHUFFMAN_LUT)   3128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 352}},
                     {     9, {(PHUFFMAN_LUT)   1408}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 354}},
                     {    10, {(PHUFFMAN_LUT)    736}},
                     {    10, {(PHUFFMAN_LUT)    712}},
                     {     8, {(PHUFFMAN_LUT)   2352}},
                     {     8, {(PHUFFMAN_LUT)   2688}},
                     {     8, {(PHUFFMAN_LUT)   1544}},
                     {     8, {(PHUFFMAN_LUT)   1152}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 362}},
                     {     8, {(PHUFFMAN_LUT)   2640}},
                     {     9, {(PHUFFMAN_LUT)    752}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 364}},
                     {    10, {(PHUFFMAN_LUT)    744}},
                     {    10, {(PHUFFMAN_LUT)   1104}},
                     {     8, {(PHUFFMAN_LUT)   1912}},
                     {     8, {(PHUFFMAN_LUT)   2392}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 370}},
                     {     8, {(PHUFFMAN_LUT)   2384}},
                     {     9, {(PHUFFMAN_LUT)   1016}},
                     {     9, {(PHUFFMAN_LUT)   1368}},
                     {     8, {(PHUFFMAN_LUT)   3064}},
                     {     8, {(PHUFFMAN_LUT)   2160}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 376}},
                     {     8, {(PHUFFMAN_LUT)   2768}},
                     {     9, {(PHUFFMAN_LUT)   1000}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 378}},
                     {    10, {(PHUFFMAN_LUT)   3424}},
                     {    10, {(PHUFFMAN_LUT)    288}},
                     {     8, {(PHUFFMAN_LUT)   2728}},
                     {     8, {(PHUFFMAN_LUT)   3040}},
                     {     8, {(PHUFFMAN_LUT)    688}},
                     {     8, {(PHUFFMAN_LUT)   2424}},
                     {     8, {(PHUFFMAN_LUT)   2800}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 386}},
                     {     9, {(PHUFFMAN_LUT)   1568}},
                     {     9, {(PHUFFMAN_LUT)   1504}},
                     {     8, {(PHUFFMAN_LUT)   2112}},
                     {     8, {(PHUFFMAN_LUT)   1696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 392}},
                     {     8, {(PHUFFMAN_LUT)   2960}},
                     {     9, {(PHUFFMAN_LUT)   3136}},
                     {     9, {(PHUFFMAN_LUT)   1440}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 396}},
                     {     8, {(PHUFFMAN_LUT)   3192}},
                     {     9, {(PHUFFMAN_LUT)   1160}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 398}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 400}},
                     {    10, {(PHUFFMAN_LUT)    880}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 402}},
                     {    11, {(PHUFFMAN_LUT)    320}},
                     {    12, {(PHUFFMAN_LUT)   3440}},
                     {    12, {(PHUFFMAN_LUT)    160}},
                     {     8, {(PHUFFMAN_LUT)   2312}},
                     {     8, {(PHUFFMAN_LUT)   2832}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 410}},
                     {     9, {(PHUFFMAN_LUT)   1416}},
                     {     9, {(PHUFFMAN_LUT)    632}},
                     {     9, {(PHUFFMAN_LUT)   1856}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 412}},
                     {    10, {(PHUFFMAN_LUT)   3312}},
                     {    11, {(PHUFFMAN_LUT)    432}},
                     {    11, {(PHUFFMAN_LUT)    496}},
                     {     8, {(PHUFFMAN_LUT)   1616}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 416}},
                     {    10, {(PHUFFMAN_LUT)    872}},
                     {    10, {(PHUFFMAN_LUT)    552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 420}},
                     {    10, {(PHUFFMAN_LUT)   1024}},
                     {    11, {(PHUFFMAN_LUT)    360}},
                     {    11, {(PHUFFMAN_LUT)    264}},
                     {     8, {(PHUFFMAN_LUT)   3056}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 424}},
                     {     9, {(PHUFFMAN_LUT)   1328}},
                     {     9, {(PHUFFMAN_LUT)   2912}},
                     {     9, {(PHUFFMAN_LUT)   2920}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 430}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 432}},
                     {     9, {(PHUFFMAN_LUT)    576}},
                     {    10, {(PHUFFMAN_LUT)    184}},
                     {    10, {(PHUFFMAN_LUT)    392}},
                     {    10, {(PHUFFMAN_LUT)   1056}},
                     {    10, {(PHUFFMAN_LUT)   1312}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 436}},
                     {     8, {(PHUFFMAN_LUT)   2176}},
                     {     9, {(PHUFFMAN_LUT)   1144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 438}},
                     {    10, {(PHUFFMAN_LUT)   1168}},
                     {    10, {(PHUFFMAN_LUT)   1200}},
                     {     8, {(PHUFFMAN_LUT)   3160}},
                     {     8, {(PHUFFMAN_LUT)   2104}},
                     {     8, {(PHUFFMAN_LUT)   2488}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 444}},
                     {     9, {(PHUFFMAN_LUT)   1064}},
                     {     9, {(PHUFFMAN_LUT)   1944}},
                     {     8, {(PHUFFMAN_LUT)   1080}},
                     {     8, {(PHUFFMAN_LUT)   2400}},
                     {     8, {(PHUFFMAN_LUT)   1744}},
                     {     8, {(PHUFFMAN_LUT)   2200}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 452}},
                     {     8, {(PHUFFMAN_LUT)   2680}},
                     {     9, {(PHUFFMAN_LUT)    768}},
                     {     9, {(PHUFFMAN_LUT)   3048}},
                     {     8, {(PHUFFMAN_LUT)   2360}},
                     {     8, {(PHUFFMAN_LUT)   2928}},
                     {     8, {(PHUFFMAN_LUT)   1880}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 458}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 460}},
                     {     9, {(PHUFFMAN_LUT)   1008}},
                     {    10, {(PHUFFMAN_LUT)    624}},
                     {    10, {(PHUFFMAN_LUT)    384}},
                     {     8, {(PHUFFMAN_LUT)   1752}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 464}},
                     {     9, {(PHUFFMAN_LUT)    640}},
                     {     9, {(PHUFFMAN_LUT)    840}},
                     {     8, {(PHUFFMAN_LUT)   1840}},
                     {     8, {(PHUFFMAN_LUT)   2536}},
                     {     8, {(PHUFFMAN_LUT)   2736}},
                     {     8, {(PHUFFMAN_LUT)   2232}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 474}},
                     {     9, {(PHUFFMAN_LUT)   1808}},
                     {     9, {(PHUFFMAN_LUT)   3016}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 478}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 476}},
                     {    10, {(PHUFFMAN_LUT)   1176}},
                     {    11, {(PHUFFMAN_LUT)    808}},
                     {    11, {(PHUFFMAN_LUT)    440}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 480}},
                     {    10, {(PHUFFMAN_LUT)    928}},
                     {    11, {(PHUFFMAN_LUT)   3368}},
                     {    11, {(PHUFFMAN_LUT)    272}},
                     {     8, {(PHUFFMAN_LUT)   2672}},
                     {     8, {(PHUFFMAN_LUT)   2528}},
                     {     8, {(PHUFFMAN_LUT)   1672}},
                     {     8, {(PHUFFMAN_LUT)   2120}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 488}},
                     {     8, {(PHUFFMAN_LUT)   1464}},
                     {     9, {(PHUFFMAN_LUT)    904}},
                     {     9, {(PHUFFMAN_LUT)   1848}},
                     {     9, {(PHUFFMAN_LUT)   1712}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 494}},
                     {     9, {(PHUFFMAN_LUT)    648}},
                     {     9, {(PHUFFMAN_LUT)   1592}},
                     {    10, {(PHUFFMAN_LUT)    888}},
                     {    10, {(PHUFFMAN_LUT)    480}},
                     {     8, {(PHUFFMAN_LUT)   2256}},
                     {     8, {(PHUFFMAN_LUT)   2136}},
                     {     8, {(PHUFFMAN_LUT)   2408}},
                     {     8, {(PHUFFMAN_LUT)   2784}},
                     {     8, {(PHUFFMAN_LUT)   2616}},
                     {     8, {(PHUFFMAN_LUT)   2008}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 506}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 510}},
                     {     8, {(PHUFFMAN_LUT)   1920}},
                     {     8, {(PHUFFMAN_LUT)   1920}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 508}},
                     {    10, {(PHUFFMAN_LUT)   3248}},
                     {    11, {(PHUFFMAN_LUT)   1208}},
                     {    11, {(PHUFFMAN_LUT)    328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 512}},
                     {    10, {(PHUFFMAN_LUT)   1392}},
                     {    11, {(PHUFFMAN_LUT)   3304}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 514}},
                     {    13, {(PHUFFMAN_LUT)   3496}},
                     {    13, {(PHUFFMAN_LUT)   3472}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 518}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 524}},
                     {    15, {(PHUFFMAN_LUT)    128}},
                     {    15, {(PHUFFMAN_LUT)    136}},
                     {    15, {(PHUFFMAN_LUT)    120}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 522}},
                     {    16, {(PHUFFMAN_LUT)   3544}},
                     {    16, {(PHUFFMAN_LUT)   3520}},
                     {    14, {(PHUFFMAN_LUT)   3456}},
                     {    14, {(PHUFFMAN_LUT)   3464}},
                     {     8, {(PHUFFMAN_LUT)   1960}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 528}},
                     {     9, {(PHUFFMAN_LUT)   1256}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 530}},
                     {    10, {(PHUFFMAN_LUT)   1088}},
                     {    10, {(PHUFFMAN_LUT)    560}},
                     {     8, {(PHUFFMAN_LUT)   1456}},
                     {     8, {(PHUFFMAN_LUT)   2512}},
                     {     8, {(PHUFFMAN_LUT)   2760}},
                     {     8, {(PHUFFMAN_LUT)   2984}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 538}},
                     {     8, {(PHUFFMAN_LUT)   2656}},
                     {     9, {(PHUFFMAN_LUT)   1424}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 540}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 542}},
                     {    10, {(PHUFFMAN_LUT)    656}},
                     {    11, {(PHUFFMAN_LUT)    960}},
                     {    11, {(PHUFFMAN_LUT)   1224}},
                     {     8, {(PHUFFMAN_LUT)   2648}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 546}},
                     {     9, {(PHUFFMAN_LUT)   1248}},
                     {     9, {(PHUFFMAN_LUT)   3176}},
                     {     8, {(PHUFFMAN_LUT)   2416}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 550}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 552}},
                     {     9, {(PHUFFMAN_LUT)   3208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 554}},
                     {    10, {(PHUFFMAN_LUT)    720}},
                     {    11, {(PHUFFMAN_LUT)    256}},
                     {    11, {(PHUFFMAN_LUT)   3296}},
                     {     8, {(PHUFFMAN_LUT)   2504}},
                     {     8, {(PHUFFMAN_LUT)   2184}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 560}},
                     {     8, {(PHUFFMAN_LUT)   2592}},
                     {    10, {(PHUFFMAN_LUT)   1352}},
                     {    10, {(PHUFFMAN_LUT)   1296}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 564}},
                     {    10, {(PHUFFMAN_LUT)   1480}},
                     {    11, {(PHUFFMAN_LUT)    368}},
                     {    11, {(PHUFFMAN_LUT)    968}},
                     {     8, {(PHUFFMAN_LUT)   3088}},
                     {     8, {(PHUFFMAN_LUT)   1192}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 570}},
                     {     8, {(PHUFFMAN_LUT)   2328}},
                     {     9, {(PHUFFMAN_LUT)   1576}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 572}},
                     {    10, {(PHUFFMAN_LUT)    936}},
                     {    10, {(PHUFFMAN_LUT)    512}},
                     {     8, {(PHUFFMAN_LUT)   2632}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 576}},
                     {     9, {(PHUFFMAN_LUT)   1720}},
                     {     9, {(PHUFFMAN_LUT)   3200}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 580}},
                     {     8, {(PHUFFMAN_LUT)   2296}},
                     {     9, {(PHUFFMAN_LUT)   2992}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 582}},
                     {    10, {(PHUFFMAN_LUT)   3384}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 584}},
                     {    11, {(PHUFFMAN_LUT)    608}},
                     {    11, {(PHUFFMAN_LUT)    224}},
                     {     8, {(PHUFFMAN_LUT)   2288}},
                     {     8, {(PHUFFMAN_LUT)   3072}},
                     {     8, {(PHUFFMAN_LUT)   2456}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 590}},
                     {     9, {(PHUFFMAN_LUT)   1448}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 592}},
                     {    10, {(PHUFFMAN_LUT)   3336}},
                     {    10, {(PHUFFMAN_LUT)    856}},
                     {     9, {(PHUFFMAN_LUT)   2952}},
                     {     9, {(PHUFFMAN_LUT)   3144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 598}},
                     {     9, {(PHUFFMAN_LUT)   2712}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 600}},
                     {    10, {(PHUFFMAN_LUT)   1112}},
                     {    11, {(PHUFFMAN_LUT)    248}},
                     {    11, {(PHUFFMAN_LUT)   1032}},
                     {     8, {(PHUFFMAN_LUT)   2128}},
                     {     8, {(PHUFFMAN_LUT)   2936}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 608}},
                     {     9, {(PHUFFMAN_LUT)    776}},
                     {     9, {(PHUFFMAN_LUT)   1792}},
                     {     9, {(PHUFFMAN_LUT)    592}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 610}},
                     {    10, {(PHUFFMAN_LUT)    680}},
                     {    11, {(PHUFFMAN_LUT)    176}},
                     {    11, {(PHUFFMAN_LUT)    312}},
                     {     8, {(PHUFFMAN_LUT)   2744}},
                     {     8, {(PHUFFMAN_LUT)   2224}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 616}},
                     {     8, {(PHUFFMAN_LUT)   1664}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 618}},
                     {     9, {(PHUFFMAN_LUT)    352}},
                     {    10, {(PHUFFMAN_LUT)    528}},
                     {    10, {(PHUFFMAN_LUT)   1280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 622}},
                     {     8, {(PHUFFMAN_LUT)   2304}},
                     {     9, {(PHUFFMAN_LUT)   1800}},
                     {     9, {(PHUFFMAN_LUT)    704}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 626}},
                     {     8, {(PHUFFMAN_LUT)   2624}},
                     {     9, {(PHUFFMAN_LUT)   3008}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 628}},
                     {    10, {(PHUFFMAN_LUT)   3272}},
                     {    10, {(PHUFFMAN_LUT)   1240}},
                     {     9, {(PHUFFMAN_LUT)   2816}},
                     {     9, {(PHUFFMAN_LUT)   3168}},
                     {     9, {(PHUFFMAN_LUT)   1584}},
                     {     9, {(PHUFFMAN_LUT)   1984}},
                     {     8, {(PHUFFMAN_LUT)   2440}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 636}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 640}},
                     {    10, {(PHUFFMAN_LUT)   1488}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 642}},
                     {    10, {(PHUFFMAN_LUT)   3376}},
                     {    11, {(PHUFFMAN_LUT)    976}},
                     {    11, {(PHUFFMAN_LUT)   3392}},
                     {    11, {(PHUFFMAN_LUT)   1048}},
                     {    11, {(PHUFFMAN_LUT)    280}},
                     {     8, {(PHUFFMAN_LUT)   2000}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 646}},
                     {     9, {(PHUFFMAN_LUT)   3096}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 648}},
                     {    10, {(PHUFFMAN_LUT)    920}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 650}},
                     {    11, {(PHUFFMAN_LUT)    800}},
                     {    11, {(PHUFFMAN_LUT)    672}},
                     {     8, {(PHUFFMAN_LUT)   2704}},
                     {     8, {(PHUFFMAN_LUT)   2432}},
                     {     8, {(PHUFFMAN_LUT)   1336}},
                     {     8, {(PHUFFMAN_LUT)   1968}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 658}},
                     {     8, {(PHUFFMAN_LUT)   2320}},
                     {     9, {(PHUFFMAN_LUT)   2864}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 660}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 662}},
                     {    10, {(PHUFFMAN_LUT)    520}},
                     {    11, {(PHUFFMAN_LUT)    864}},
                     {    11, {(PHUFFMAN_LUT)   3360}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 666}},
                     {     8, {(PHUFFMAN_LUT)   2264}},
                     {     9, {(PHUFFMAN_LUT)   3216}},
                     {     9, {(PHUFFMAN_LUT)   2872}},
                     {     8, {(PHUFFMAN_LUT)   2192}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 670}},
                     {     9, {(PHUFFMAN_LUT)   1184}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 672}},
                     {    10, {(PHUFFMAN_LUT)   3256}},
                     {    10, {(PHUFFMAN_LUT)   1128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 676}},
                     {     8, {(PHUFFMAN_LUT)   1928}},
                     {     9, {(PHUFFMAN_LUT)   1688}},
                     {     9, {(PHUFFMAN_LUT)   2720}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 680}},
                     {     8, {(PHUFFMAN_LUT)   2272}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 682}},
                     {     9, {(PHUFFMAN_LUT)   1904}},
                     {    11, {(PHUFFMAN_LUT)    464}},
                     {    11, {(PHUFFMAN_LUT)    816}},
                     {    11, {(PHUFFMAN_LUT)    240}},
                     {    11, {(PHUFFMAN_LUT)   1096}},
                     {     9, {(PHUFFMAN_LUT)   2344}},
                     {     9, {(PHUFFMAN_LUT)   1896}},
                     {     9, {(PHUFFMAN_LUT)   1936}},
                     {     9, {(PHUFFMAN_LUT)   1376}},
                     {     8, {(PHUFFMAN_LUT)   2880}},
                     {     8, {(PHUFFMAN_LUT)   2752}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 696}},
                     {     9, {(PHUFFMAN_LUT)   1728}},
                     {     9, {(PHUFFMAN_LUT)    848}},
                     {     9, {(PHUFFMAN_LUT)   3080}},
                     {    10, {(PHUFFMAN_LUT)   1136}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 698}},
                     {    11, {(PHUFFMAN_LUT)    200}},
                     {    11, {(PHUFFMAN_LUT)    824}},
                     {     8, {(PHUFFMAN_LUT)   2152}},
                     {     8, {(PHUFFMAN_LUT)   2496}},
                     {     8, {(PHUFFMAN_LUT)   2824}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 704}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 706}},
                     {     9, {(PHUFFMAN_LUT)   1632}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 708}},
                     {    10, {(PHUFFMAN_LUT)   1400}},
                     {    11, {(PHUFFMAN_LUT)    488}},
                     {    11, {(PHUFFMAN_LUT)   1232}},
                     {     8, {(PHUFFMAN_LUT)   2472}},
                     {     8, {(PHUFFMAN_LUT)   2608}},
                     {     9, {(PHUFFMAN_LUT)   2032}},
                     {     9, {(PHUFFMAN_LUT)   2976}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 716}},
                     {     9, {(PHUFFMAN_LUT)   2840}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 718}},
                     {    10, {(PHUFFMAN_LUT)   3240}},
                     {    11, {(PHUFFMAN_LUT)    232}},
                     {    11, {(PHUFFMAN_LUT)    504}},
                     {     8, {(PHUFFMAN_LUT)   2544}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 722}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 724}},
                     {     9, {(PHUFFMAN_LUT)   1600}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 726}},
                     {    10, {(PHUFFMAN_LUT)   1560}},
                     {    11, {(PHUFFMAN_LUT)   1040}},
                     {    11, {(PHUFFMAN_LUT)    424}},
                     {     8, {(PHUFFMAN_LUT)   1952}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 730}},
                     {     9, {(PHUFFMAN_LUT)   1704}},
                     {     9, {(PHUFFMAN_LUT)   1776}},
                     {     8, {(PHUFFMAN_LUT)   2048}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 734}},
                     {     9, {(PHUFFMAN_LUT)   2248}},
                     {     9, {(PHUFFMAN_LUT)    832}},
                     {     9, {(PHUFFMAN_LUT)   1528}},
                     {     9, {(PHUFFMAN_LUT)   1520}},
                     {     9, {(PHUFFMAN_LUT)   2240}},
                     {     9, {(PHUFFMAN_LUT)   1264}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 744}},
                     {     9, {(PHUFFMAN_LUT)   2576}},
                     {     9, {(PHUFFMAN_LUT)   2336}},
                     {     9, {(PHUFFMAN_LUT)   2568}},
                     {    10, {(PHUFFMAN_LUT)   1512}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 746}},
                     {    11, {(PHUFFMAN_LUT)    616}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 748}},
                     {    12, {(PHUFFMAN_LUT)    448}},
                     {    12, {(PHUFFMAN_LUT)    168}},
                     {     9, {(PHUFFMAN_LUT)   2088}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 754}},
                     {     9, {(PHUFFMAN_LUT)   2888}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 756}},
                     {    10, {(PHUFFMAN_LUT)    952}},
                     {    10, {(PHUFFMAN_LUT)   1288}},
                     {    10, {(PHUFFMAN_LUT)    416}},
                     {    10, {(PHUFFMAN_LUT)    896}},
                     {     9, {(PHUFFMAN_LUT)   3112}},
                     {     9, {(PHUFFMAN_LUT)   1992}},
                     {     9, {(PHUFFMAN_LUT)   2968}},
                     {     9, {(PHUFFMAN_LUT)   2776}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 764}},
                     {     8, {(PHUFFMAN_LUT)   2520}},
                     {     9, {(PHUFFMAN_LUT)   2856}},
                     {     9, {(PHUFFMAN_LUT)   3104}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 768}},
                     {     8, {(PHUFFMAN_LUT)   1624}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 770}},
                     {     9, {(PHUFFMAN_LUT)    600}},
                     {    10, {(PHUFFMAN_LUT)   1120}},
                     {    10, {(PHUFFMAN_LUT)   1496}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqContAbs_ + 774}},
                     {     8, {(PHUFFMAN_LUT)   2280}},
                     {     9, {(PHUFFMAN_LUT)   2016}},
                     {     9, {(PHUFFMAN_LUT)   2080}}};

const HUFFMAN_DECODER hufFreqContAbs = {(PHUFFMAN_LUT)_hufFreqContAbs_, 7};
/*********************************************************************/
