/***********************************************************************
MPEG-4 Audio RM Module
Parametric based codec - SSC (SinuSoidal Coding) bit stream Encoder

This software was originally developed by:
* Arno Peters, Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
* Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
* Werner Oomen, Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

And edited by:
*

in the course of development of the MPEG-4 Audio standard ISO-14496-1, 2 and 3. 
This software module is an implementation of a part of one or more MPEG-4 Audio
tools as specified by the MPEG-4 Audio standard. ISO/IEC gives users of the 
MPEG-4 Audio standards free licence to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the 
MPEG-4 Audio standards. Those intending to use this software module in hardware
or software products are advised that this use may infringe existing patents.
The original developers of this software of this module and their company, 
the subsequent editors and their companies, and ISO/EIC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio conforming products. The 
original developer retains full right to use this code for his/her own purpose,
assign or donate the code to a third party and to inhibit third party from
using the code for non MPEG-4 Audio conforming products. This copyright notice
must be included in all copies of derivative works.

Copyright  2001.

Source file: hufFreqBirthRel.c

Required libraries: <none>

Authors:
AP:	Arno Peters,   Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
JD:	Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
WO:	Werner Oomen,  Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

Changes:
07 Nov 2001	JD	Initial version
03 Dec 2001 JD  Improved huffman table
************************************************************************/

#include "HuffmanDecoder.h"

/*********************************************************************
* Definition of hufFreqBirthRel huffman decoder
* (Automatically generated - casting needed to avoid warnings on MSVC)
**********************************************************************/
static const HUFFMAN_LUT _hufFreqBirthRel_[] =
                    {{    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 32}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 54}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 94}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 106}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 118}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 134}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 148}},
                     {     5, {(PHUFFMAN_LUT)     80}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 152}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 156}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 336}},
                     {     5, {(PHUFFMAN_LUT)     72}},
                     {     5, {(PHUFFMAN_LUT)     56}},
                     {     5, {(PHUFFMAN_LUT)     64}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 370}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 412}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 428}},
                     {     5, {(PHUFFMAN_LUT)     48}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 460}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 474}},
                     {     5, {(PHUFFMAN_LUT)     40}},
                     {     5, {(PHUFFMAN_LUT)     16}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 478}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 484}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 492}},
                     {     5, {(PHUFFMAN_LUT)     32}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 612}},
                     {     5, {(PHUFFMAN_LUT)     24}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 630}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 660}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 666}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 680}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 34}},
                     {     6, {(PHUFFMAN_LUT)    192}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 38}},
                     {     8, {(PHUFFMAN_LUT)    608}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 42}},
                     {     8, {(PHUFFMAN_LUT)    600}},
                     {    10, {(PHUFFMAN_LUT)   1256}},
                     {    10, {(PHUFFMAN_LUT)   1280}},
                     {    10, {(PHUFFMAN_LUT)   1288}},
                     {    10, {(PHUFFMAN_LUT)   1328}},
                     {     9, {(PHUFFMAN_LUT)    912}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 44}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 46}},
                     {    10, {(PHUFFMAN_LUT)      0}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 48}},
                     {    11, {(PHUFFMAN_LUT)   1512}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 50}},
                     {    12, {(PHUFFMAN_LUT)   1808}},
                     {    14, {(PHUFFMAN_LUT)   2968}},
                     {    14, {(PHUFFMAN_LUT)   3024}},
                     {    14, {(PHUFFMAN_LUT)   3072}},
                     {    14, {(PHUFFMAN_LUT)   3104}},
                     {     6, {(PHUFFMAN_LUT)    184}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 56}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 60}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 66}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 78}},
                     {     8, {(PHUFFMAN_LUT)    648}},
                     {     9, {(PHUFFMAN_LUT)    920}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 62}},
                     {    10, {(PHUFFMAN_LUT)   1472}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 64}},
                     {    11, {(PHUFFMAN_LUT)   1576}},
                     {    11, {(PHUFFMAN_LUT)   1608}},
                     {    11, {(PHUFFMAN_LUT)   1656}},
                     {    11, {(PHUFFMAN_LUT)   1696}},
                     {    11, {(PHUFFMAN_LUT)   1752}},
                     {    11, {(PHUFFMAN_LUT)   1768}},
                     {    11, {(PHUFFMAN_LUT)   1776}},
                     {    11, {(PHUFFMAN_LUT)   1784}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 74}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 76}},
                     {    12, {(PHUFFMAN_LUT)   1856}},
                     {    12, {(PHUFFMAN_LUT)   1904}},
                     {    12, {(PHUFFMAN_LUT)   1936}},
                     {    12, {(PHUFFMAN_LUT)   1952}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 82}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 86}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 90}},
                     {    10, {(PHUFFMAN_LUT)   1096}},
                     {    12, {(PHUFFMAN_LUT)   1960}},
                     {    12, {(PHUFFMAN_LUT)   2000}},
                     {    12, {(PHUFFMAN_LUT)   2008}},
                     {    12, {(PHUFFMAN_LUT)   2024}},
                     {    12, {(PHUFFMAN_LUT)   2056}},
                     {    12, {(PHUFFMAN_LUT)   2072}},
                     {    12, {(PHUFFMAN_LUT)   2112}},
                     {    12, {(PHUFFMAN_LUT)   2128}},
                     {    12, {(PHUFFMAN_LUT)   2144}},
                     {    12, {(PHUFFMAN_LUT)   2160}},
                     {    12, {(PHUFFMAN_LUT)   2184}},
                     {    12, {(PHUFFMAN_LUT)   2272}},
                     {     7, {(PHUFFMAN_LUT)    424}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 98}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 102}},
                     {     7, {(PHUFFMAN_LUT)    344}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 100}},
                     {     8, {(PHUFFMAN_LUT)    520}},
                     {     9, {(PHUFFMAN_LUT)    944}},
                     {     9, {(PHUFFMAN_LUT)    800}},
                     {     8, {(PHUFFMAN_LUT)    696}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 104}},
                     {     9, {(PHUFFMAN_LUT)    896}},
                     {     9, {(PHUFFMAN_LUT)    976}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 108}},
                     {     6, {(PHUFFMAN_LUT)    200}},
                     {     7, {(PHUFFMAN_LUT)    368}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 110}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 114}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 116}},
                     {     9, {(PHUFFMAN_LUT)    784}},
                     {     9, {(PHUFFMAN_LUT)    888}},
                     {    10, {(PHUFFMAN_LUT)   1120}},
                     {    10, {(PHUFFMAN_LUT)   1272}},
                     {    10, {(PHUFFMAN_LUT)   1320}},
                     {    10, {(PHUFFMAN_LUT)   1336}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 120}},
                     {     6, {(PHUFFMAN_LUT)    176}},
                     {     7, {(PHUFFMAN_LUT)    392}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 122}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 126}},
                     {     9, {(PHUFFMAN_LUT)    848}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 130}},
                     {    10, {(PHUFFMAN_LUT)   1432}},
                     {    10, {(PHUFFMAN_LUT)   1048}},
                     {    10, {(PHUFFMAN_LUT)   1152}},
                     {    10, {(PHUFFMAN_LUT)   1192}},
                     {    10, {(PHUFFMAN_LUT)   1208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 132}},
                     {    11, {(PHUFFMAN_LUT)   1424}},
                     {    11, {(PHUFFMAN_LUT)   1488}},
                     {     7, {(PHUFFMAN_LUT)    376}},
                     {     7, {(PHUFFMAN_LUT)    408}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 138}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 146}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 140}},
                     {     8, {(PHUFFMAN_LUT)    592}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 142}},
                     {     9, {(PHUFFMAN_LUT)    808}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 144}},
                     {    10, {(PHUFFMAN_LUT)   1216}},
                     {    11, {(PHUFFMAN_LUT)   1640}},
                     {    11, {(PHUFFMAN_LUT)   1688}},
                     {     8, {(PHUFFMAN_LUT)    560}},
                     {     8, {(PHUFFMAN_LUT)    656}},
                     {     6, {(PHUFFMAN_LUT)    168}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 150}},
                     {     7, {(PHUFFMAN_LUT)    384}},
                     {     7, {(PHUFFMAN_LUT)    400}},
                     {     6, {(PHUFFMAN_LUT)    160}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 154}},
                     {     7, {(PHUFFMAN_LUT)    320}},
                     {     7, {(PHUFFMAN_LUT)    336}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 164}},
                     {     8, {(PHUFFMAN_LUT)    512}},
                     {     7, {(PHUFFMAN_LUT)    352}},
                     {     7, {(PHUFFMAN_LUT)    352}},
                     {     7, {(PHUFFMAN_LUT)    360}},
                     {     7, {(PHUFFMAN_LUT)    360}},
                     {     8, {(PHUFFMAN_LUT)    568}},
                     {     8, {(PHUFFMAN_LUT)    584}},
                     {    10, {(PHUFFMAN_LUT)   1240}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 168}},
                     {     9, {(PHUFFMAN_LUT)    840}},
                     {     9, {(PHUFFMAN_LUT)    840}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 170}},
                     {    11, {(PHUFFMAN_LUT)   1296}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 172}},
                     {    12, {(PHUFFMAN_LUT)   1552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 174}},
                     {    13, {(PHUFFMAN_LUT)   1584}},
                     {    14, {(PHUFFMAN_LUT)   3120}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 176}},
                     {    -7, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 178}},
                     {    15, {(PHUFFMAN_LUT)   2064}},
                     {    22, {(PHUFFMAN_LUT)   2912}},
                     {    22, {(PHUFFMAN_LUT)   2928}},
                     {    22, {(PHUFFMAN_LUT)   2952}},
                     {    22, {(PHUFFMAN_LUT)   2976}},
                     {    22, {(PHUFFMAN_LUT)   2984}},
                     {    22, {(PHUFFMAN_LUT)   2992}},
                     {    22, {(PHUFFMAN_LUT)   3000}},
                     {    22, {(PHUFFMAN_LUT)   3008}},
                     {    22, {(PHUFFMAN_LUT)   3016}},
                     {    22, {(PHUFFMAN_LUT)   3032}},
                     {    22, {(PHUFFMAN_LUT)   3040}},
                     {    22, {(PHUFFMAN_LUT)   3048}},
                     {    22, {(PHUFFMAN_LUT)   3056}},
                     {    22, {(PHUFFMAN_LUT)   3064}},
                     {    22, {(PHUFFMAN_LUT)   3080}},
                     {    22, {(PHUFFMAN_LUT)   3088}},
                     {    22, {(PHUFFMAN_LUT)   3096}},
                     {    22, {(PHUFFMAN_LUT)   3112}},
                     {    22, {(PHUFFMAN_LUT)   3128}},
                     {    22, {(PHUFFMAN_LUT)   3136}},
                     {    22, {(PHUFFMAN_LUT)   3144}},
                     {    22, {(PHUFFMAN_LUT)   3152}},
                     {    22, {(PHUFFMAN_LUT)   3160}},
                     {    22, {(PHUFFMAN_LUT)   3168}},
                     {    22, {(PHUFFMAN_LUT)   3176}},
                     {    22, {(PHUFFMAN_LUT)   3184}},
                     {    22, {(PHUFFMAN_LUT)   3192}},
                     {    22, {(PHUFFMAN_LUT)   3200}},
                     {    22, {(PHUFFMAN_LUT)   3208}},
                     {    22, {(PHUFFMAN_LUT)   3216}},
                     {    22, {(PHUFFMAN_LUT)   3224}},
                     {    22, {(PHUFFMAN_LUT)   3232}},
                     {    22, {(PHUFFMAN_LUT)   3240}},
                     {    22, {(PHUFFMAN_LUT)   3248}},
                     {    22, {(PHUFFMAN_LUT)   3256}},
                     {    22, {(PHUFFMAN_LUT)   3264}},
                     {    22, {(PHUFFMAN_LUT)   3272}},
                     {    22, {(PHUFFMAN_LUT)   3280}},
                     {    22, {(PHUFFMAN_LUT)   3288}},
                     {    22, {(PHUFFMAN_LUT)   3296}},
                     {    22, {(PHUFFMAN_LUT)   3304}},
                     {    22, {(PHUFFMAN_LUT)   3312}},
                     {    22, {(PHUFFMAN_LUT)   3320}},
                     {    22, {(PHUFFMAN_LUT)   3328}},
                     {    22, {(PHUFFMAN_LUT)   3336}},
                     {    22, {(PHUFFMAN_LUT)   3344}},
                     {    22, {(PHUFFMAN_LUT)   3352}},
                     {    22, {(PHUFFMAN_LUT)   3360}},
                     {    22, {(PHUFFMAN_LUT)   3368}},
                     {    22, {(PHUFFMAN_LUT)   3376}},
                     {    22, {(PHUFFMAN_LUT)   3384}},
                     {    22, {(PHUFFMAN_LUT)   3392}},
                     {    22, {(PHUFFMAN_LUT)   3400}},
                     {    22, {(PHUFFMAN_LUT)   3408}},
                     {    22, {(PHUFFMAN_LUT)   3416}},
                     {    22, {(PHUFFMAN_LUT)   3424}},
                     {    22, {(PHUFFMAN_LUT)   3432}},
                     {    22, {(PHUFFMAN_LUT)   3440}},
                     {    22, {(PHUFFMAN_LUT)   3448}},
                     {    22, {(PHUFFMAN_LUT)   3456}},
                     {    22, {(PHUFFMAN_LUT)   3464}},
                     {    22, {(PHUFFMAN_LUT)   3472}},
                     {    22, {(PHUFFMAN_LUT)   3480}},
                     {    22, {(PHUFFMAN_LUT)   3488}},
                     {    22, {(PHUFFMAN_LUT)   3496}},
                     {    22, {(PHUFFMAN_LUT)   3504}},
                     {    22, {(PHUFFMAN_LUT)   3512}},
                     {    22, {(PHUFFMAN_LUT)   3520}},
                     {    22, {(PHUFFMAN_LUT)   3528}},
                     {    22, {(PHUFFMAN_LUT)   3536}},
                     {    22, {(PHUFFMAN_LUT)   3544}},
                     {    22, {(PHUFFMAN_LUT)   3552}},
                     {    22, {(PHUFFMAN_LUT)   3560}},
                     {    22, {(PHUFFMAN_LUT)   3568}},
                     {    22, {(PHUFFMAN_LUT)   3576}},
                     {    22, {(PHUFFMAN_LUT)   3584}},
                     {    22, {(PHUFFMAN_LUT)   3592}},
                     {    22, {(PHUFFMAN_LUT)   3600}},
                     {    22, {(PHUFFMAN_LUT)   3608}},
                     {    22, {(PHUFFMAN_LUT)   3616}},
                     {    22, {(PHUFFMAN_LUT)   3624}},
                     {    22, {(PHUFFMAN_LUT)   3632}},
                     {    22, {(PHUFFMAN_LUT)   3640}},
                     {    22, {(PHUFFMAN_LUT)   3648}},
                     {    22, {(PHUFFMAN_LUT)   3656}},
                     {    22, {(PHUFFMAN_LUT)   3664}},
                     {    22, {(PHUFFMAN_LUT)   3672}},
                     {    22, {(PHUFFMAN_LUT)   3680}},
                     {    22, {(PHUFFMAN_LUT)   3688}},
                     {    22, {(PHUFFMAN_LUT)   3696}},
                     {    22, {(PHUFFMAN_LUT)   3704}},
                     {    22, {(PHUFFMAN_LUT)   3712}},
                     {    22, {(PHUFFMAN_LUT)   3720}},
                     {    22, {(PHUFFMAN_LUT)   3728}},
                     {    22, {(PHUFFMAN_LUT)   3736}},
                     {    22, {(PHUFFMAN_LUT)   3744}},
                     {    22, {(PHUFFMAN_LUT)   3752}},
                     {    22, {(PHUFFMAN_LUT)   3760}},
                     {    22, {(PHUFFMAN_LUT)   3768}},
                     {    22, {(PHUFFMAN_LUT)   3776}},
                     {    22, {(PHUFFMAN_LUT)   3784}},
                     {    22, {(PHUFFMAN_LUT)   3792}},
                     {    22, {(PHUFFMAN_LUT)   3800}},
                     {    22, {(PHUFFMAN_LUT)   3808}},
                     {    22, {(PHUFFMAN_LUT)   3816}},
                     {    22, {(PHUFFMAN_LUT)   3824}},
                     {    22, {(PHUFFMAN_LUT)   3832}},
                     {    22, {(PHUFFMAN_LUT)   3840}},
                     {    22, {(PHUFFMAN_LUT)   3848}},
                     {    22, {(PHUFFMAN_LUT)   3856}},
                     {    22, {(PHUFFMAN_LUT)   3864}},
                     {    22, {(PHUFFMAN_LUT)   3872}},
                     {    22, {(PHUFFMAN_LUT)   3880}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 306}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 308}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 310}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 312}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 314}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 316}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 318}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 320}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 322}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 324}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 326}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 330}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 332}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 334}},
                     {    23, {(PHUFFMAN_LUT)   2168}},
                     {    23, {(PHUFFMAN_LUT)   2296}},
                     {    23, {(PHUFFMAN_LUT)   2360}},
                     {    23, {(PHUFFMAN_LUT)   2392}},
                     {    23, {(PHUFFMAN_LUT)   2400}},
                     {    23, {(PHUFFMAN_LUT)   2504}},
                     {    23, {(PHUFFMAN_LUT)   2520}},
                     {    23, {(PHUFFMAN_LUT)   2536}},
                     {    23, {(PHUFFMAN_LUT)   2544}},
                     {    23, {(PHUFFMAN_LUT)   2560}},
                     {    23, {(PHUFFMAN_LUT)   2576}},
                     {    23, {(PHUFFMAN_LUT)   2584}},
                     {    23, {(PHUFFMAN_LUT)   2616}},
                     {    23, {(PHUFFMAN_LUT)   2632}},
                     {    23, {(PHUFFMAN_LUT)   2648}},
                     {    23, {(PHUFFMAN_LUT)   2656}},
                     {    23, {(PHUFFMAN_LUT)   2664}},
                     {    23, {(PHUFFMAN_LUT)   2744}},
                     {    23, {(PHUFFMAN_LUT)   2752}},
                     {    23, {(PHUFFMAN_LUT)   2760}},
                     {    23, {(PHUFFMAN_LUT)   2776}},
                     {    23, {(PHUFFMAN_LUT)   2792}},
                     {    23, {(PHUFFMAN_LUT)   2800}},
                     {    23, {(PHUFFMAN_LUT)   2816}},
                     {    23, {(PHUFFMAN_LUT)   2832}},
                     {    23, {(PHUFFMAN_LUT)   2848}},
                     {    23, {(PHUFFMAN_LUT)   2856}},
                     {    23, {(PHUFFMAN_LUT)   2872}},
                     {    23, {(PHUFFMAN_LUT)   2896}},
                     {    23, {(PHUFFMAN_LUT)   2904}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 338}},
                     {     6, {(PHUFFMAN_LUT)    152}},
                     {     8, {(PHUFFMAN_LUT)    576}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 342}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 348}},
                     {     8, {(PHUFFMAN_LUT)    536}},
                     {     9, {(PHUFFMAN_LUT)    856}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 344}},
                     {    11, {(PHUFFMAN_LUT)   1360}},
                     {    11, {(PHUFFMAN_LUT)   1376}},
                     {    11, {(PHUFFMAN_LUT)   1456}},
                     {    11, {(PHUFFMAN_LUT)   1464}},
                     {    11, {(PHUFFMAN_LUT)   1544}},
                     {    11, {(PHUFFMAN_LUT)   1560}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 356}},
                     {    11, {(PHUFFMAN_LUT)   1672}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 360}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 362}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 366}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 368}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 358}},
                     {    12, {(PHUFFMAN_LUT)   1648}},
                     {    13, {(PHUFFMAN_LUT)   1592}},
                     {    13, {(PHUFFMAN_LUT)   1832}},
                     {    12, {(PHUFFMAN_LUT)   1840}},
                     {    12, {(PHUFFMAN_LUT)   1864}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 364}},
                     {    12, {(PHUFFMAN_LUT)   1896}},
                     {    13, {(PHUFFMAN_LUT)   1872}},
                     {    13, {(PHUFFMAN_LUT)   1928}},
                     {    12, {(PHUFFMAN_LUT)   1920}},
                     {    12, {(PHUFFMAN_LUT)   1968}},
                     {    12, {(PHUFFMAN_LUT)   1992}},
                     {    12, {(PHUFFMAN_LUT)   2016}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 374}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 390}},
                     {     7, {(PHUFFMAN_LUT)    328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 406}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 378}},
                     {     9, {(PHUFFMAN_LUT)    760}},
                     {     9, {(PHUFFMAN_LUT)    952}},
                     {     9, {(PHUFFMAN_LUT)    720}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 380}},
                     {    10, {(PHUFFMAN_LUT)   1000}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 384}},
                     {    12, {(PHUFFMAN_LUT)   2080}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 386}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 388}},
                     {    13, {(PHUFFMAN_LUT)   2040}},
                     {    13, {(PHUFFMAN_LUT)   2048}},
                     {    13, {(PHUFFMAN_LUT)   2096}},
                     {    13, {(PHUFFMAN_LUT)   2136}},
                     {    13, {(PHUFFMAN_LUT)   2208}},
                     {    13, {(PHUFFMAN_LUT)   2216}},
                     {     9, {(PHUFFMAN_LUT)    792}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 394}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 396}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 404}},
                     {    10, {(PHUFFMAN_LUT)   1016}},
                     {    10, {(PHUFFMAN_LUT)   1024}},
                     {    10, {(PHUFFMAN_LUT)   1128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 398}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 400}},
                     {    11, {(PHUFFMAN_LUT)   1344}},
                     {    13, {(PHUFFMAN_LUT)   2232}},
                     {    13, {(PHUFFMAN_LUT)   2256}},
                     {    13, {(PHUFFMAN_LUT)   2264}},
                     {    13, {(PHUFFMAN_LUT)   2312}},
                     {    10, {(PHUFFMAN_LUT)   1072}},
                     {    10, {(PHUFFMAN_LUT)   1168}},
                     {     8, {(PHUFFMAN_LUT)    552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 408}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 410}},
                     {     9, {(PHUFFMAN_LUT)    752}},
                     {    10, {(PHUFFMAN_LUT)   1184}},
                     {    10, {(PHUFFMAN_LUT)   1224}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 414}},
                     {     6, {(PHUFFMAN_LUT)    136}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 416}},
                     {     7, {(PHUFFMAN_LUT)    304}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 420}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 422}},
                     {     9, {(PHUFFMAN_LUT)    872}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 424}},
                     {    10, {(PHUFFMAN_LUT)    968}},
                     {    10, {(PHUFFMAN_LUT)    984}},
                     {    10, {(PHUFFMAN_LUT)   1104}},
                     {    10, {(PHUFFMAN_LUT)   1112}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 426}},
                     {    10, {(PHUFFMAN_LUT)   1136}},
                     {    11, {(PHUFFMAN_LUT)   1416}},
                     {    11, {(PHUFFMAN_LUT)   1248}},
                     {     7, {(PHUFFMAN_LUT)    280}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 432}},
                     {     7, {(PHUFFMAN_LUT)    288}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 448}},
                     {     9, {(PHUFFMAN_LUT)    736}},
                     {     9, {(PHUFFMAN_LUT)    744}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 436}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 440}},
                     {    10, {(PHUFFMAN_LUT)   1200}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 438}},
                     {    11, {(PHUFFMAN_LUT)   1496}},
                     {    11, {(PHUFFMAN_LUT)   1520}},
                     {    11, {(PHUFFMAN_LUT)   1536}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 444}},
                     {    11, {(PHUFFMAN_LUT)   1680}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 446}},
                     {    12, {(PHUFFMAN_LUT)   1616}},
                     {    12, {(PHUFFMAN_LUT)   1664}},
                     {    12, {(PHUFFMAN_LUT)   1744}},
                     {    12, {(PHUFFMAN_LUT)   1800}},
                     {     8, {(PHUFFMAN_LUT)    544}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 450}},
                     {     9, {(PHUFFMAN_LUT)    768}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 452}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 454}},
                     {    10, {(PHUFFMAN_LUT)   1032}},
                     {    12, {(PHUFFMAN_LUT)   1824}},
                     {    12, {(PHUFFMAN_LUT)   1880}},
                     {    12, {(PHUFFMAN_LUT)   2088}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 458}},
                     {    13, {(PHUFFMAN_LUT)   2416}},
                     {    13, {(PHUFFMAN_LUT)   1392}},
                     {     6, {(PHUFFMAN_LUT)    144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 462}},
                     {     7, {(PHUFFMAN_LUT)    312}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 464}},
                     {     9, {(PHUFFMAN_LUT)    688}},
                     {     9, {(PHUFFMAN_LUT)    832}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 468}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 470}},
                     {    10, {(PHUFFMAN_LUT)   1264}},
                     {    10, {(PHUFFMAN_LUT)    880}},
                     {    10, {(PHUFFMAN_LUT)   1144}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 472}},
                     {    11, {(PHUFFMAN_LUT)   1232}},
                     {    11, {(PHUFFMAN_LUT)   1352}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 476}},
                     {     6, {(PHUFFMAN_LUT)    120}},
                     {     7, {(PHUFFMAN_LUT)    248}},
                     {     7, {(PHUFFMAN_LUT)    296}},
                     {     6, {(PHUFFMAN_LUT)    128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 480}},
                     {     7, {(PHUFFMAN_LUT)    256}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 482}},
                     {     8, {(PHUFFMAN_LUT)    488}},
                     {     8, {(PHUFFMAN_LUT)    504}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 486}},
                     {     6, {(PHUFFMAN_LUT)      8}},
                     {     7, {(PHUFFMAN_LUT)    272}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 488}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 490}},
                     {     8, {(PHUFFMAN_LUT)    496}},
                     {     9, {(PHUFFMAN_LUT)    776}},
                     {     9, {(PHUFFMAN_LUT)    672}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 496}},
                     {     7, {(PHUFFMAN_LUT)    264}},
                     {    -4, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 506}},
                     {     7, {(PHUFFMAN_LUT)    224}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 498}},
                     {     8, {(PHUFFMAN_LUT)    472}},
                     {    10, {(PHUFFMAN_LUT)   1064}},
                     {    10, {(PHUFFMAN_LUT)    864}},
                     {    10, {(PHUFFMAN_LUT)   1040}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 502}},
                     {    12, {(PHUFFMAN_LUT)   1160}},
                     {    12, {(PHUFFMAN_LUT)   1312}},
                     {    12, {(PHUFFMAN_LUT)   1384}},
                     {    12, {(PHUFFMAN_LUT)   1568}},
                     {    11, {(PHUFFMAN_LUT)   1408}},
                     {    11, {(PHUFFMAN_LUT)   1440}},
                     {    11, {(PHUFFMAN_LUT)   1448}},
                     {    11, {(PHUFFMAN_LUT)   1504}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 522}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 526}},
                     {    11, {(PHUFFMAN_LUT)   1712}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 528}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 530}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 534}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 542}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 548}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 556}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 568}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 582}},
                     {    -3, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 596}},
                     {    12, {(PHUFFMAN_LUT)   1600}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 524}},
                     {    13, {(PHUFFMAN_LUT)   1624}},
                     {    13, {(PHUFFMAN_LUT)   1760}},
                     {    12, {(PHUFFMAN_LUT)   1632}},
                     {    12, {(PHUFFMAN_LUT)   1704}},
                     {    12, {(PHUFFMAN_LUT)   1720}},
                     {    12, {(PHUFFMAN_LUT)   1728}},
                     {    12, {(PHUFFMAN_LUT)   1792}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 532}},
                     {    13, {(PHUFFMAN_LUT)   1816}},
                     {    13, {(PHUFFMAN_LUT)   1888}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 536}},
                     {    12, {(PHUFFMAN_LUT)   1984}},
                     {    13, {(PHUFFMAN_LUT)   1912}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 538}},
                     {    14, {(PHUFFMAN_LUT)   1944}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 540}},
                     {    15, {(PHUFFMAN_LUT)   2152}},
                     {    15, {(PHUFFMAN_LUT)   2176}},
                     {    13, {(PHUFFMAN_LUT)   2032}},
                     {    13, {(PHUFFMAN_LUT)   2104}},
                     {    13, {(PHUFFMAN_LUT)   2120}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 546}},
                     {    14, {(PHUFFMAN_LUT)   2192}},
                     {    14, {(PHUFFMAN_LUT)   2200}},
                     {    13, {(PHUFFMAN_LUT)   2224}},
                     {    13, {(PHUFFMAN_LUT)   2240}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 552}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 554}},
                     {    14, {(PHUFFMAN_LUT)   2248}},
                     {    14, {(PHUFFMAN_LUT)   2280}},
                     {    14, {(PHUFFMAN_LUT)   2288}},
                     {    14, {(PHUFFMAN_LUT)   2304}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 560}},
                     {    13, {(PHUFFMAN_LUT)   2336}},
                     {    13, {(PHUFFMAN_LUT)   2344}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 564}},
                     {    15, {(PHUFFMAN_LUT)   2320}},
                     {    15, {(PHUFFMAN_LUT)   2328}},
                     {    15, {(PHUFFMAN_LUT)   2352}},
                     {    15, {(PHUFFMAN_LUT)   2368}},
                     {    14, {(PHUFFMAN_LUT)   2376}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 566}},
                     {    15, {(PHUFFMAN_LUT)   2384}},
                     {    15, {(PHUFFMAN_LUT)   2432}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 572}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 574}},
                     {    13, {(PHUFFMAN_LUT)   2456}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 578}},
                     {    14, {(PHUFFMAN_LUT)   2408}},
                     {    14, {(PHUFFMAN_LUT)   2424}},
                     {    14, {(PHUFFMAN_LUT)   2440}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 576}},
                     {    15, {(PHUFFMAN_LUT)   2448}},
                     {    15, {(PHUFFMAN_LUT)   2464}},
                     {    15, {(PHUFFMAN_LUT)   2472}},
                     {    15, {(PHUFFMAN_LUT)   2480}},
                     {    15, {(PHUFFMAN_LUT)   2488}},
                     {    15, {(PHUFFMAN_LUT)   2512}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 586}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 588}},
                     {    13, {(PHUFFMAN_LUT)   2608}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 592}},
                     {    14, {(PHUFFMAN_LUT)   2496}},
                     {    14, {(PHUFFMAN_LUT)   2528}},
                     {    15, {(PHUFFMAN_LUT)   2552}},
                     {    15, {(PHUFFMAN_LUT)   2568}},
                     {    15, {(PHUFFMAN_LUT)   2592}},
                     {    15, {(PHUFFMAN_LUT)   2600}},
                     {    15, {(PHUFFMAN_LUT)   2624}},
                     {    15, {(PHUFFMAN_LUT)   2640}},
                     {    15, {(PHUFFMAN_LUT)   2672}},
                     {    15, {(PHUFFMAN_LUT)   2680}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 604}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 606}},
                     {    14, {(PHUFFMAN_LUT)   2712}},
                     {    14, {(PHUFFMAN_LUT)   2720}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 608}},
                     {    14, {(PHUFFMAN_LUT)   2768}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 610}},
                     {    14, {(PHUFFMAN_LUT)   2840}},
                     {    15, {(PHUFFMAN_LUT)   2688}},
                     {    15, {(PHUFFMAN_LUT)   2696}},
                     {    15, {(PHUFFMAN_LUT)   2704}},
                     {    15, {(PHUFFMAN_LUT)   2728}},
                     {    15, {(PHUFFMAN_LUT)   2736}},
                     {    15, {(PHUFFMAN_LUT)   2784}},
                     {    15, {(PHUFFMAN_LUT)   2808}},
                     {    15, {(PHUFFMAN_LUT)   2824}},
                     {     7, {(PHUFFMAN_LUT)    240}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 616}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 620}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 626}},
                     {     8, {(PHUFFMAN_LUT)    528}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 618}},
                     {     9, {(PHUFFMAN_LUT)    632}},
                     {     9, {(PHUFFMAN_LUT)    728}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 622}},
                     {     8, {(PHUFFMAN_LUT)    448}},
                     {    10, {(PHUFFMAN_LUT)    992}},
                     {    10, {(PHUFFMAN_LUT)   1008}},
                     {    10, {(PHUFFMAN_LUT)   1056}},
                     {    10, {(PHUFFMAN_LUT)    928}},
                     {     8, {(PHUFFMAN_LUT)    464}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 628}},
                     {     9, {(PHUFFMAN_LUT)    680}},
                     {     9, {(PHUFFMAN_LUT)    704}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 632}},
                     {     6, {(PHUFFMAN_LUT)    112}},
                     {     8, {(PHUFFMAN_LUT)    440}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 636}},
                     {     8, {(PHUFFMAN_LUT)    456}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 642}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 638}},
                     {     9, {(PHUFFMAN_LUT)    712}},
                     {    10, {(PHUFFMAN_LUT)    936}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 640}},
                     {    11, {(PHUFFMAN_LUT)   1304}},
                     {    11, {(PHUFFMAN_LUT)   1400}},
                     {    10, {(PHUFFMAN_LUT)    904}},
                     {    10, {(PHUFFMAN_LUT)    960}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 646}},
                     {    10, {(PHUFFMAN_LUT)   1080}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 648}},
                     {    11, {(PHUFFMAN_LUT)   1368}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 650}},
                     {    12, {(PHUFFMAN_LUT)   1480}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 654}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 656}},
                     {    14, {(PHUFFMAN_LUT)   2920}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 658}},
                     {    15, {(PHUFFMAN_LUT)   2864}},
                     {    15, {(PHUFFMAN_LUT)   2880}},
                     {    15, {(PHUFFMAN_LUT)   2888}},
                     {    15, {(PHUFFMAN_LUT)   2936}},
                     {    15, {(PHUFFMAN_LUT)   2944}},
                     {    15, {(PHUFFMAN_LUT)   2960}},
                     {     6, {(PHUFFMAN_LUT)    104}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 662}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 664}},
                     {     7, {(PHUFFMAN_LUT)    232}},
                     {     8, {(PHUFFMAN_LUT)    480}},
                     {     8, {(PHUFFMAN_LUT)    432}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 668}},
                     {     6, {(PHUFFMAN_LUT)     88}},
                     {     7, {(PHUFFMAN_LUT)    216}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 670}},
                     {     9, {(PHUFFMAN_LUT)    640}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 674}},
                     {     9, {(PHUFFMAN_LUT)    624}},
                     {     9, {(PHUFFMAN_LUT)    616}},
                     {    -2, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 676}},
                     {    10, {(PHUFFMAN_LUT)    824}},
                     {    12, {(PHUFFMAN_LUT)   1528}},
                     {    12, {(PHUFFMAN_LUT)   1736}},
                     {    12, {(PHUFFMAN_LUT)   1848}},
                     {    12, {(PHUFFMAN_LUT)   1976}},
                     {     6, {(PHUFFMAN_LUT)     96}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 682}},
                     {     7, {(PHUFFMAN_LUT)    208}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 684}},
                     {     8, {(PHUFFMAN_LUT)    416}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 686}},
                     {     9, {(PHUFFMAN_LUT)    664}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 688}},
                     {    10, {(PHUFFMAN_LUT)    816}},
                     {    -1, {(PHUFFMAN_LUT) _hufFreqBirthRel_ + 690}},
                     {    11, {(PHUFFMAN_LUT)   1088}},
                     {    11, {(PHUFFMAN_LUT)   1176}}};

const HUFFMAN_DECODER hufFreqBirthRel = {(PHUFFMAN_LUT)_hufFreqBirthRel_, 5};
/*********************************************************************/
