/***********************************************************************
MPEG-4 Audio RM Module
Parametric based codec - SSC (SinuSoidal Coding) bit stream Encoder

This software was originally developed by:
* Arno Peters, Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
* Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
* Werner Oomen, Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

And edited by:
*

in the course of development of the MPEG-4 Audio standard ISO-14496-1, 2 and 3. 
This software module is an implementation of a part of one or more MPEG-4 Audio
tools as specified by the MPEG-4 Audio standard. ISO/IEC gives users of the 
MPEG-4 Audio standards free licence to this software module or modifications 
thereof for use in hardware or software products claiming conformance to the 
MPEG-4 Audio standards. Those intending to use this software module in hardware
or software products are advised that this use may infringe existing patents.
The original developers of this software of this module and their company, 
the subsequent editors and their companies, and ISO/EIC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio conforming products. The 
original developer retains full right to use this code for his/her own purpose,
assign or donate the code to a third party and to inhibit third party from
using the code for non MPEG-4 Audio conforming products. This copyright notice
must be included in all copies of derivative works.

Copyright  2001.

Source file: hufFineItd.c

Required libraries: <none>

Authors:
AP:	Arno Peters,   Philips CE - ASA-labs Eindhoven <arno.peters@philips.com>
JD:	Jan Dasselaar, Philips CE - ASA-labs Eindhoven <jan.dasselaar@philips.com>
WO:	Werner Oomen,  Philips CE - ASA-labs Eindhoven <werner.oomen@philips.com>

Changes:
21 Nov 2002	AR	Initial version
************************************************************************/

#include "HuffmanDecoder.h"

/*********************************************************************
* Definition of hufFineItd huffman decoder
* (Automatically generated - casting needed to avoid warnings on MSVC)
**********************************************************************/
static const HUFFMAN_LUT _hufFineItd_[] =
                    {{    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 4}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 20}},
                     {     2, {(PHUFFMAN_LUT)      0}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 64}},
                     {     3, {(PHUFFMAN_LUT)     -1}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 6}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 8}},
                     {     4, {(PHUFFMAN_LUT)      2}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 10}},
                     {     5, {(PHUFFMAN_LUT)      4}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 14}},
                     {     7, {(PHUFFMAN_LUT)    -32}},
                     {     7, {(PHUFFMAN_LUT)    -12}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 16}},
                     {     8, {(PHUFFMAN_LUT)    -22}},
                     {     8, {(PHUFFMAN_LUT)     19}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 18}},
                     {     8, {(PHUFFMAN_LUT)     20}},
                     {     9, {(PHUFFMAN_LUT)    -30}},
                     {     9, {(PHUFFMAN_LUT)     28}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 24}},
                     {     4, {(PHUFFMAN_LUT)     -2}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 34}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 46}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 28}},
                     {     6, {(PHUFFMAN_LUT)     -8}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 32}},
                     {     6, {(PHUFFMAN_LUT)     -7}},
                     {     7, {(PHUFFMAN_LUT)     32}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 30}},
                     {     8, {(PHUFFMAN_LUT)    -19}},
                     {     8, {(PHUFFMAN_LUT)    -16}},
                     {     7, {(PHUFFMAN_LUT)     12}},
                     {     7, {(PHUFFMAN_LUT)     11}},
                     {     5, {(PHUFFMAN_LUT)     -4}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 36}},
                     {     6, {(PHUFFMAN_LUT)      7}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 38}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 42}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 44}},
                     {     8, {(PHUFFMAN_LUT)    -18}},
                     {     8, {(PHUFFMAN_LUT)     16}},
                     {     9, {(PHUFFMAN_LUT)     29}},
                     {     9, {(PHUFFMAN_LUT)    -27}},
                     {     9, {(PHUFFMAN_LUT)     26}},
                     {     9, {(PHUFFMAN_LUT)     24}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 50}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 56}},
                     {     6, {(PHUFFMAN_LUT)      6}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 60}},
                     {     7, {(PHUFFMAN_LUT)    -11}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 52}},
                     {     9, {(PHUFFMAN_LUT)    -28}},
                     {     9, {(PHUFFMAN_LUT)    -25}},
                     {     9, {(PHUFFMAN_LUT)    -29}},
                     {     9, {(PHUFFMAN_LUT)    -26}},
                     {     7, {(PHUFFMAN_LUT)    -10}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 58}},
                     {     8, {(PHUFFMAN_LUT)     17}},
                     {     8, {(PHUFFMAN_LUT)     15}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 62}},
                     {     7, {(PHUFFMAN_LUT)    -31}},
                     {     8, {(PHUFFMAN_LUT)    -17}},
                     {     8, {(PHUFFMAN_LUT)     18}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 68}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 78}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 92}},
                     {     4, {(PHUFFMAN_LUT)      1}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 70}},
                     {     5, {(PHUFFMAN_LUT)      3}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 72}},
                     {     6, {(PHUFFMAN_LUT)     -6}},
                     {     7, {(PHUFFMAN_LUT)     10}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 74}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 76}},
                     {     8, {(PHUFFMAN_LUT)    -15}},
                     {     9, {(PHUFFMAN_LUT)     25}},
                     {     9, {(PHUFFMAN_LUT)    -24}},
                     {     5, {(PHUFFMAN_LUT)     -3}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 80}},
                     {     7, {(PHUFFMAN_LUT)     31}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 84}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 88}},
                     {     7, {(PHUFFMAN_LUT)     -9}},
                     {     8, {(PHUFFMAN_LUT)     14}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 86}},
                     {     9, {(PHUFFMAN_LUT)    -20}},
                     {     9, {(PHUFFMAN_LUT)    -23}},
                     {     8, {(PHUFFMAN_LUT)    -14}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 90}},
                     {     9, {(PHUFFMAN_LUT)    -21}},
                     {     9, {(PHUFFMAN_LUT)     21}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 96}},
                     {     6, {(PHUFFMAN_LUT)      5}},
                     {     6, {(PHUFFMAN_LUT)     -5}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 346}},
                     {     7, {(PHUFFMAN_LUT)      9}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 98}},
                     {     9, {(PHUFFMAN_LUT)     27}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 102}},
                     {     9, {(PHUFFMAN_LUT)     23}},
                     {     9, {(PHUFFMAN_LUT)     22}},
                     {    -3, {(PHUFFMAN_LUT) _hufFineItd_ + 104}},
                     {    10, {(PHUFFMAN_LUT)     30}},
                     {    13, {(PHUFFMAN_LUT)    -33}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 112}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 114}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 116}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 120}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 124}},
                     {    -2, {(PHUFFMAN_LUT) _hufFineItd_ + 128}},
                     {    13, {(PHUFFMAN_LUT)     33}},
                     {    14, {(PHUFFMAN_LUT)    -57}},
                     {    14, {(PHUFFMAN_LUT)    -45}},
                     {    14, {(PHUFFMAN_LUT)    -43}},
                     {    14, {(PHUFFMAN_LUT)     42}},
                     {    15, {(PHUFFMAN_LUT)    -52}},
                     {    15, {(PHUFFMAN_LUT)    -50}},
                     {    15, {(PHUFFMAN_LUT)    -41}},
                     {    15, {(PHUFFMAN_LUT)    -40}},
                     {    15, {(PHUFFMAN_LUT)    -37}},
                     {    15, {(PHUFFMAN_LUT)    -35}},
                     {    15, {(PHUFFMAN_LUT)    -34}},
                     {    15, {(PHUFFMAN_LUT)     36}},
                     {    15, {(PHUFFMAN_LUT)     37}},
                     {    15, {(PHUFFMAN_LUT)     38}},
                     {    15, {(PHUFFMAN_LUT)     39}},
                     {    15, {(PHUFFMAN_LUT)     43}},
                     {    15, {(PHUFFMAN_LUT)     45}},
                     {    15, {(PHUFFMAN_LUT)     46}},
                     {    15, {(PHUFFMAN_LUT)     57}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 132}},
                     {    -7, {(PHUFFMAN_LUT) _hufFineItd_ + 134}},
                     {    16, {(PHUFFMAN_LUT)    -58}},
                     {    23, {(PHUFFMAN_LUT)     34}},
                     {    23, {(PHUFFMAN_LUT)     35}},
                     {    23, {(PHUFFMAN_LUT)     40}},
                     {    23, {(PHUFFMAN_LUT)     41}},
                     {    23, {(PHUFFMAN_LUT)     44}},
                     {    23, {(PHUFFMAN_LUT)     47}},
                     {    23, {(PHUFFMAN_LUT)     48}},
                     {    23, {(PHUFFMAN_LUT)     49}},
                     {    23, {(PHUFFMAN_LUT)     50}},
                     {    23, {(PHUFFMAN_LUT)     51}},
                     {    23, {(PHUFFMAN_LUT)     52}},
                     {    23, {(PHUFFMAN_LUT)     53}},
                     {    23, {(PHUFFMAN_LUT)     54}},
                     {    23, {(PHUFFMAN_LUT)     55}},
                     {    23, {(PHUFFMAN_LUT)     56}},
                     {    23, {(PHUFFMAN_LUT)     58}},
                     {    23, {(PHUFFMAN_LUT)     59}},
                     {    23, {(PHUFFMAN_LUT)     60}},
                     {    23, {(PHUFFMAN_LUT)     61}},
                     {    23, {(PHUFFMAN_LUT)     62}},
                     {    23, {(PHUFFMAN_LUT)     63}},
                     {    23, {(PHUFFMAN_LUT)     64}},
                     {    23, {(PHUFFMAN_LUT)     65}},
                     {    23, {(PHUFFMAN_LUT)     66}},
                     {    23, {(PHUFFMAN_LUT)     67}},
                     {    23, {(PHUFFMAN_LUT)     68}},
                     {    23, {(PHUFFMAN_LUT)     69}},
                     {    23, {(PHUFFMAN_LUT)     70}},
                     {    23, {(PHUFFMAN_LUT)     71}},
                     {    23, {(PHUFFMAN_LUT)     72}},
                     {    23, {(PHUFFMAN_LUT)     73}},
                     {    23, {(PHUFFMAN_LUT)     74}},
                     {    23, {(PHUFFMAN_LUT)     75}},
                     {    23, {(PHUFFMAN_LUT)     76}},
                     {    23, {(PHUFFMAN_LUT)     77}},
                     {    23, {(PHUFFMAN_LUT)     78}},
                     {    23, {(PHUFFMAN_LUT)     79}},
                     {    23, {(PHUFFMAN_LUT)     80}},
                     {    23, {(PHUFFMAN_LUT)     81}},
                     {    23, {(PHUFFMAN_LUT)     82}},
                     {    23, {(PHUFFMAN_LUT)     83}},
                     {    23, {(PHUFFMAN_LUT)     84}},
                     {    23, {(PHUFFMAN_LUT)     85}},
                     {    23, {(PHUFFMAN_LUT)     86}},
                     {    23, {(PHUFFMAN_LUT)     87}},
                     {    23, {(PHUFFMAN_LUT)     88}},
                     {    23, {(PHUFFMAN_LUT)     89}},
                     {    23, {(PHUFFMAN_LUT)     90}},
                     {    23, {(PHUFFMAN_LUT)     91}},
                     {    23, {(PHUFFMAN_LUT)     92}},
                     {    23, {(PHUFFMAN_LUT)     93}},
                     {    23, {(PHUFFMAN_LUT)     94}},
                     {    23, {(PHUFFMAN_LUT)     95}},
                     {    23, {(PHUFFMAN_LUT)     96}},
                     {    23, {(PHUFFMAN_LUT)     97}},
                     {    23, {(PHUFFMAN_LUT)     98}},
                     {    23, {(PHUFFMAN_LUT)     99}},
                     {    23, {(PHUFFMAN_LUT)    100}},
                     {    23, {(PHUFFMAN_LUT)    101}},
                     {    23, {(PHUFFMAN_LUT)    102}},
                     {    23, {(PHUFFMAN_LUT)    103}},
                     {    23, {(PHUFFMAN_LUT)    104}},
                     {    23, {(PHUFFMAN_LUT)    105}},
                     {    23, {(PHUFFMAN_LUT)    106}},
                     {    23, {(PHUFFMAN_LUT)    107}},
                     {    23, {(PHUFFMAN_LUT)    108}},
                     {    23, {(PHUFFMAN_LUT)    109}},
                     {    23, {(PHUFFMAN_LUT)    110}},
                     {    23, {(PHUFFMAN_LUT)    111}},
                     {    23, {(PHUFFMAN_LUT)    112}},
                     {    23, {(PHUFFMAN_LUT)    113}},
                     {    23, {(PHUFFMAN_LUT)    114}},
                     {    23, {(PHUFFMAN_LUT)    115}},
                     {    23, {(PHUFFMAN_LUT)    116}},
                     {    23, {(PHUFFMAN_LUT)    117}},
                     {    23, {(PHUFFMAN_LUT)    118}},
                     {    23, {(PHUFFMAN_LUT)    119}},
                     {    23, {(PHUFFMAN_LUT)    120}},
                     {    23, {(PHUFFMAN_LUT)    121}},
                     {    23, {(PHUFFMAN_LUT)    122}},
                     {    23, {(PHUFFMAN_LUT)    123}},
                     {    23, {(PHUFFMAN_LUT)    124}},
                     {    23, {(PHUFFMAN_LUT)    125}},
                     {    23, {(PHUFFMAN_LUT)    126}},
                     {    23, {(PHUFFMAN_LUT)    127}},
                     {    23, {(PHUFFMAN_LUT)    128}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 262}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 264}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 266}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 268}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 270}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 272}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 274}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 276}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 278}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 280}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 282}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 284}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 286}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 288}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 290}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 292}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 294}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 296}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 298}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 300}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 302}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 304}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 306}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 308}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 310}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 312}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 314}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 316}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 318}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 320}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 322}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 324}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 326}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 328}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 330}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 332}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 334}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 336}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 338}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 340}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 342}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 344}},
                     {    24, {(PHUFFMAN_LUT)   -128}},
                     {    24, {(PHUFFMAN_LUT)   -127}},
                     {    24, {(PHUFFMAN_LUT)   -126}},
                     {    24, {(PHUFFMAN_LUT)   -125}},
                     {    24, {(PHUFFMAN_LUT)   -124}},
                     {    24, {(PHUFFMAN_LUT)   -123}},
                     {    24, {(PHUFFMAN_LUT)   -122}},
                     {    24, {(PHUFFMAN_LUT)   -121}},
                     {    24, {(PHUFFMAN_LUT)   -120}},
                     {    24, {(PHUFFMAN_LUT)   -119}},
                     {    24, {(PHUFFMAN_LUT)   -118}},
                     {    24, {(PHUFFMAN_LUT)   -117}},
                     {    24, {(PHUFFMAN_LUT)   -116}},
                     {    24, {(PHUFFMAN_LUT)   -115}},
                     {    24, {(PHUFFMAN_LUT)   -114}},
                     {    24, {(PHUFFMAN_LUT)   -113}},
                     {    24, {(PHUFFMAN_LUT)   -112}},
                     {    24, {(PHUFFMAN_LUT)   -111}},
                     {    24, {(PHUFFMAN_LUT)   -110}},
                     {    24, {(PHUFFMAN_LUT)   -109}},
                     {    24, {(PHUFFMAN_LUT)   -108}},
                     {    24, {(PHUFFMAN_LUT)   -107}},
                     {    24, {(PHUFFMAN_LUT)   -106}},
                     {    24, {(PHUFFMAN_LUT)   -105}},
                     {    24, {(PHUFFMAN_LUT)   -104}},
                     {    24, {(PHUFFMAN_LUT)   -103}},
                     {    24, {(PHUFFMAN_LUT)   -102}},
                     {    24, {(PHUFFMAN_LUT)   -101}},
                     {    24, {(PHUFFMAN_LUT)   -100}},
                     {    24, {(PHUFFMAN_LUT)    -99}},
                     {    24, {(PHUFFMAN_LUT)    -98}},
                     {    24, {(PHUFFMAN_LUT)    -97}},
                     {    24, {(PHUFFMAN_LUT)    -96}},
                     {    24, {(PHUFFMAN_LUT)    -95}},
                     {    24, {(PHUFFMAN_LUT)    -94}},
                     {    24, {(PHUFFMAN_LUT)    -93}},
                     {    24, {(PHUFFMAN_LUT)    -92}},
                     {    24, {(PHUFFMAN_LUT)    -91}},
                     {    24, {(PHUFFMAN_LUT)    -90}},
                     {    24, {(PHUFFMAN_LUT)    -89}},
                     {    24, {(PHUFFMAN_LUT)    -88}},
                     {    24, {(PHUFFMAN_LUT)    -87}},
                     {    24, {(PHUFFMAN_LUT)    -86}},
                     {    24, {(PHUFFMAN_LUT)    -85}},
                     {    24, {(PHUFFMAN_LUT)    -84}},
                     {    24, {(PHUFFMAN_LUT)    -83}},
                     {    24, {(PHUFFMAN_LUT)    -82}},
                     {    24, {(PHUFFMAN_LUT)    -81}},
                     {    24, {(PHUFFMAN_LUT)    -80}},
                     {    24, {(PHUFFMAN_LUT)    -79}},
                     {    24, {(PHUFFMAN_LUT)    -78}},
                     {    24, {(PHUFFMAN_LUT)    -77}},
                     {    24, {(PHUFFMAN_LUT)    -76}},
                     {    24, {(PHUFFMAN_LUT)    -75}},
                     {    24, {(PHUFFMAN_LUT)    -74}},
                     {    24, {(PHUFFMAN_LUT)    -73}},
                     {    24, {(PHUFFMAN_LUT)    -72}},
                     {    24, {(PHUFFMAN_LUT)    -71}},
                     {    24, {(PHUFFMAN_LUT)    -70}},
                     {    24, {(PHUFFMAN_LUT)    -69}},
                     {    24, {(PHUFFMAN_LUT)    -68}},
                     {    24, {(PHUFFMAN_LUT)    -67}},
                     {    24, {(PHUFFMAN_LUT)    -66}},
                     {    24, {(PHUFFMAN_LUT)    -65}},
                     {    24, {(PHUFFMAN_LUT)    -64}},
                     {    24, {(PHUFFMAN_LUT)    -63}},
                     {    24, {(PHUFFMAN_LUT)    -62}},
                     {    24, {(PHUFFMAN_LUT)    -61}},
                     {    24, {(PHUFFMAN_LUT)    -60}},
                     {    24, {(PHUFFMAN_LUT)    -59}},
                     {    24, {(PHUFFMAN_LUT)    -56}},
                     {    24, {(PHUFFMAN_LUT)    -55}},
                     {    24, {(PHUFFMAN_LUT)    -54}},
                     {    24, {(PHUFFMAN_LUT)    -53}},
                     {    24, {(PHUFFMAN_LUT)    -51}},
                     {    24, {(PHUFFMAN_LUT)    -49}},
                     {    24, {(PHUFFMAN_LUT)    -48}},
                     {    24, {(PHUFFMAN_LUT)    -47}},
                     {    24, {(PHUFFMAN_LUT)    -46}},
                     {    24, {(PHUFFMAN_LUT)    -44}},
                     {    24, {(PHUFFMAN_LUT)    -42}},
                     {    24, {(PHUFFMAN_LUT)    -39}},
                     {    24, {(PHUFFMAN_LUT)    -38}},
                     {    24, {(PHUFFMAN_LUT)    -36}},
                     {    -1, {(PHUFFMAN_LUT) _hufFineItd_ + 348}},
                     {     7, {(PHUFFMAN_LUT)      8}},
                     {     8, {(PHUFFMAN_LUT)    -13}},
                     {     8, {(PHUFFMAN_LUT)     13}}};

const HUFFMAN_DECODER hufFineItd = {(PHUFFMAN_LUT)_hufFineItd_, 2};
/*********************************************************************/
