/*******************************************************************************
This software module was originally developed by

Institute for Infocomm Research and Fraunhofer IIS

and edited by

-

in the course of development of ISO/IEC 14496 for reference purposes and its
performance may not have been optimized. This software module is an
implementation of one or more tools as specified by ISO/IEC 14496. ISO/IEC gives
You a royalty-free, worldwide, non-exclusive, copyright license to copy,
distribute, and make derivative works of this software module or modifications
thereof for use in implementations of ISO/IEC 14496 in products that satisfy
conformance criteria (if any). Those intending to use this software module in
products are advised that its use may infringe existing patents. ISO/IEC have no
liability for use of this software module or modifications thereof. Copyright is
not released for products that do not conform to audiovisual and image-coding
related ITU Recommendations and/or ISO/IEC International Standards.

#ifdef NOT_PUBLISHED

Assurance that the originally developed software module can be used (1) in
ISO/IEC 14496 once ISO/IEC 14496 has been adopted; and (2) to develop ISO/IEC
14496:
Institute for Infocomm Research and Fraunhofer IIS grant ISO/IEC all
rights necessary to include the originally developed software module or
modifications thereof in ISO/IEC 14496 and to permit ISO/IEC to offer You a
royalty-free, worldwide, non-exclusive, copyright license to copy, distribute,
and make derivative works for use in implementations of ISO/IEC 14496 in
products that satisfy conformance criteria (if any), and to the extent that such
originally developed software module or portions of it are included in ISO/IEC
14496. To the extent that Institute for Infocomm Research and Fraunhofer IIS 
own patent rights that would be required to make, use, or sell the
originally developed software module or portions thereof included in ISO/IEC
14496 in a conforming product, Institute for Infocomm Research and Fraunhofer IIS 
will assure the ISO/IEC that they are willing to negotiate
licenses under reasonable and non-discriminatory terms and conditions with
applicants throughout the world. ISO/IEC gives You a free license to this
software module or modifications thereof for the sole purpose of developing
ISO/IEC 14496.

#endif

Institute for Infocomm Research and Fraunhofer IIS retain full right to
modify and use the code for their own purpose, assign or donate the code
to a third party and to inhibit third parties from using the code for products
that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
International Standards. This copyright notice must be included in all copies or
derivative works.

Copyright (c) ISO/IEC 2005.
*******************************************************************************/



#include <float.h>
#include <math.h>
#include <stdio.h>
#include "int_mdct_defs.h"


#define MAX_INV_QUANT_TABLE 1025
#define MAX_THR_TABLE       48


/* sin(0,...,pi/4) and +-1 */
static int sineDataCompact[515] = {
-1647099, 0, 1647099, 3294193, 4941281, 6588356, 8235416, 9882456, 
11529474, 13176464, 14823423, 16470347, 18117233, 19764076, 21410872, 23057618, 
24704310, 26350943, 27997515, 29644021, 31290457, 32936819, 34583104, 36229307, 
37875426, 39521455, 41167391, 42813230, 44458968, 46104602, 47750128, 49395541, 
51040837, 52686014, 54331067, 55975992, 57620785, 59265442, 60909960, 62554335, 
64198563, 65842639, 67486561, 69130324, 70773924, 72417357, 74060620, 75703709, 
77346620, 78989349, 80631892, 82274245, 83916404, 85558366, 87200127, 88841683, 
90483029, 92124163, 93765079, 95405776, 97046247, 98686491, 100326502, 101966277, 
103605812, 105245103, 106884147, 108522939, 110161476, 111799753, 113437768, 115075515, 
116712992, 118350194, 119987118, 121623759, 123260114, 124896179, 126531950, 128167423, 
129802595, 131437462, 133072019, 134706263, 136340190, 137973796, 139607077, 141240030, 
142872651, 144504935, 146136880, 147768480, 149399733, 151030634, 152661180, 154291367, 
155921191, 157550647, 159179733, 160808445, 162436778, 164064728, 165692293, 167319468, 
168946249, 170572633, 172198615, 173824192, 175449360, 177074115, 178698453, 180322371, 
181945865, 183568930, 185191564, 186813762, 188435520, 190056834, 191677702, 193298119, 
194918080, 196537583, 198156624, 199775198, 201393302, 203010932, 204628085, 206244756, 
207860942, 209476638, 211091842, 212706549, 214320755, 215934457, 217547651, 219160334, 
220772500, 222384147, 223995270, 225605867, 227215933, 228825464, 230434456, 232042906, 
233650811, 235258165, 236864966, 238471210, 240076892, 241682010, 243286558, 244890535, 
246493935, 248096755, 249698991, 251300640, 252901697, 254502159, 256102022, 257701283, 
259299937, 260897982, 262495412, 264092224, 265688415, 267283981, 268878918, 270473223, 
272066891, 273659918, 275252302, 276844038, 278435122, 280025552, 281615322, 283204430, 
284792871, 286380643, 287967740, 289554160, 291139898, 292724951, 294309316, 295892988, 
297475964, 299058239, 300639811, 302220676, 303800829, 305380268, 306958988, 308536985, 
310114257, 311690799, 313266607, 314841679, 316416009, 317989595, 319562433, 321134518, 
322705848, 324276419, 325846226, 327415267, 328983538, 330551034, 332117752, 333683689, 
335248841, 336813204, 338376774, 339939549, 341501523, 343062693, 344623057, 346182609, 
347741347, 349299266, 350856364, 352412636, 353968079, 355522689, 357076462, 358629395, 
360181484, 361732726, 363283116, 364832652, 366381329, 367929144, 369476093, 371022173, 
372567379, 374111709, 375655159, 377197725, 378739403, 380280190, 381820082, 383359076, 
384897167, 386434353, 387970630, 389505993, 391040440, 392573967, 394106570, 395638246, 
397168991, 398698801, 400227673, 401755603, 403282588, 404808624, 406333708, 407857835, 
409381002, 410903207, 412424444, 413944711, 415464004, 416982319, 418499653, 420016002, 
421531363, 423045732, 424559105, 426071480, 427582852, 429093217, 430602573, 432110916, 
433618242, 435124548, 436629829, 438134084, 439637307, 441139496, 442640647, 444140756, 
445639820, 447137835, 448634799, 450130706, 451625555, 453119340, 454612060, 456103710, 
457594286, 459083786, 460572205, 462059541, 463545789, 465030947, 466515010, 467997976, 
469479840, 470960600, 472440251, 473918791, 475396216, 476872522, 478347705, 479821764, 
481294693, 482766489, 484237150, 485706671, 487175049, 488642281, 490108363, 491573292, 
493037064, 494499676, 495961124, 497421405, 498880516, 500338453, 501795212, 503250791, 
504705185, 506158392, 507610408, 509061229, 510510853, 511959275, 513406493, 514852502, 
516297300, 517740883, 519183248, 520624391, 522064309, 523502998, 524940456, 526376678, 
527811662, 529245404, 530677900, 532109148, 533539144, 534967884, 536395365, 537821584, 
539246538, 540670223, 542092635, 543513772, 544933630, 546352205, 547769495, 549185496, 
550600205, 552013618, 553425732, 554836544, 556246051, 557654248, 559061133, 560466703, 
561870954, 563273883, 564675486, 566075761, 567474703, 568872310, 570268579, 571663506, 
573057087, 574449320, 575840202, 577229728, 578617896, 580004702, 581390144, 582774218, 
584156920, 585538248, 586918198, 588296766, 589673951, 591049748, 592424154, 593797166, 
595168781, 596538995, 597907806, 599275210, 600641203, 602005783, 603368947, 604730691, 
606091012, 607449906, 608807372, 610163404, 611518001, 612871159, 614222875, 615573145, 
616921967, 618269338, 619615253, 620959711, 622302707, 623644239, 624984303, 626322897, 
627660017, 628995660, 630329823, 631662503, 632993696, 634323400, 635651611, 636978327, 
638303543, 639627258, 640949467, 642270169, 643589359, 644907034, 646223192, 647537830, 
648850943, 650162530, 651472587, 652781111, 654088099, 655393548, 656697454, 657999816, 
659300629, 660599890, 661897597, 663193747, 664488336, 665781362, 667072820, 668362709, 
669651026, 670937767, 672222928, 673506508, 674788504, 676068911, 677347728, 678624950, 
679900576, 681174602, 682447025, 683717842, 684987051, 686254647, 687520629, 688784993, 
690047736, 691308855, 692568348, 693826211, 695082441, 696337036, 697589992, 698841307, 
700090977, 701339000, 702585372, 703830092, 705073155, 706314559, 707554301, 708792378, 
710028787, 711263525, 712496590, 713727978, 714957687, 716185713, 717412054, 718636707, 
719859669, 721080937, 722300508, 723518380, 724734549, 725949013, 727161768, 728372813, 
729582143, 730789757, 731995651, 733199822, 734402269, 735602987, 736801974, 737999228, 
739194745, 740388522, 741580558, 742770848, 743959390, 745146182, 746331221, 747514503, 
748696026, 749875788, 751053785, 752230015, 753404474, 754577161, 755748072, 756917205, 
758084557, 759250125, 760413906
};

/* (1-cos)/sin (0,...,pi/4) == tan(0,...,pi/8) */
static int sineDataCompact_cs[515] = {
-823550, 0, 823550, 1647101, 2470653, 3294209, 4117769, 4941333, 
5764903, 6588480, 7412065, 8235658, 9059261, 9882875, 10706500, 11530138, 
12353790, 13177456, 14001138, 14824836, 15648551, 16472285, 17296039, 18119812, 
18943607, 19767425, 20591265, 21415130, 22239020, 23062936, 23886880, 24710851, 
25534852, 26358882, 27182944, 28007038, 28831164, 29655325, 30479520, 31303752, 
32128020, 32952326, 33776671, 34601055, 35425481, 36249948, 37074458, 37899011, 
38723609, 39548253, 40372944, 41197681, 42022468, 42847304, 43672190, 44497128, 
45322119, 46147163, 46972261, 47797414, 48622624, 49447892, 50273217, 51098602, 
51924047, 52749553, 53575122, 54400754, 55226449, 56052210, 56878038, 57703932, 
58529894, 59355926, 60182027, 61008200, 61834444, 62660762, 63487153, 64313620, 
65140162, 65966781, 66793478, 67620255, 68447111, 69274047, 70101066, 70928168, 
71755353, 72582623, 73409979, 74237422, 75064952, 75892571, 76720280, 77548080, 
78375971, 79203955, 80032033, 80860205, 81688474, 82516838, 83345301, 84173862, 
85002523, 85831284, 86660147, 87489113, 88318182, 89147356, 89976635, 90806021, 
91635515, 92465117, 93294829, 94124652, 94954586, 95784632, 96614793, 97445068, 
98275458, 99105965, 99936590, 100767333, 101598196, 102429179, 103260284, 104091512, 
104922863, 105754339, 106585941, 107417669, 108249525, 109081509, 109913623, 110745868, 
111578245, 112410754, 113243397, 114076174, 114909088, 115742138, 116575326, 117408652, 
118242119, 119075726, 119909475, 120743367, 121577403, 122411583, 123245910, 124080383, 
124915004, 125749775, 126584695, 127419766, 128254990, 129090366, 129925897, 130761582, 
131597424, 132433423, 133269580, 134105896, 134942372, 135779010, 136615810, 137452774, 
138289901, 139127195, 139964654, 140802281, 141640077, 142478042, 143316178, 144154485, 
144992965, 145831619, 146670447, 147509452, 148348633, 149187992, 150027529, 150867247, 
151707146, 152547227, 153387491, 154227939, 155068572, 155909392, 156750399, 157591594, 
158432979, 159274554, 160116320, 160958280, 161800432, 162642780, 163485323, 164328063, 
165171001, 166014138, 166857475, 167701013, 168544753, 169388696, 170232844, 171077197, 
171921756, 172766522, 173611498, 174456682, 175302078, 176147685, 176993505, 177839539, 
178685788, 179532253, 180378935, 181225835, 182072955, 182920295, 183767856, 184615640, 
185463648, 186311880, 187160339, 188009024, 188857937, 189707079, 190556451, 191406055, 
192255890, 193105960, 193956264, 194806803, 195657579, 196508594, 197359847, 198211340, 
199063074, 199915050, 200767270, 201619735, 202472445, 203325401, 204178606, 205032059, 
205885762, 206739717, 207593924, 208448384, 209303098, 210158069, 211013296, 211868780, 
212724524, 213580528, 214436793, 215293321, 216150112, 217007167, 217864489, 218722077, 
219579933, 220438059, 221296454, 222155121, 223014061, 223873274, 224732763, 225592527, 
226452568, 227312888, 228173487, 229034367, 229895528, 230756972, 231618701, 232480714, 
233343014, 234205601, 235068477, 235931643, 236795100, 237658849, 238522891, 239387228, 
240251860, 241116790, 241982017, 242847543, 243713370, 244579498, 245445929, 246312664, 
247179704, 248047050, 248914703, 249782666, 250650937, 251519520, 252388415, 253257624, 
254127147, 254996985, 255867141, 256737615, 257608408, 258479521, 259350957, 260222715, 
261094797, 261967205, 262839939, 263713002, 264586393, 265460114, 266334167, 267208552, 
268083271, 268958326, 269833716, 270709444, 271585511, 272461918, 273338666, 274215756, 
275093191, 275970970, 276849095, 277727567, 278606389, 279485560, 280365082, 281244956, 
282125184, 283005767, 283886706, 284768003, 285649658, 286531673, 287414049, 288296787, 
289179889, 290063356, 290947189, 291831390, 292715959, 293600899, 294486209, 295371892, 
296257949, 297144381, 298031190, 298918376, 299805941, 300693886, 301582213, 302470922, 
303360016, 304249495, 305139361, 306029615, 306920258, 307811292, 308702717, 309594536, 
310486750, 311379359, 312272365, 313165770, 314059575, 314953781, 315848389, 316743401, 
317638818, 318534642, 319430873, 320327513, 321224564, 322122027, 323019902, 323918192, 
324816898, 325716021, 326615563, 327515524, 328415907, 329316712, 330217941, 331119595, 
332021676, 332924185, 333827123, 334730492, 335634293, 336538528, 337443197, 338348303, 
339253846, 340159828, 341066251, 341973115, 342880423, 343788175, 344696373, 345605018, 
346514112, 347423657, 348333652, 349244101, 350155004, 351066363, 351978180, 352890454, 
353803189, 354716385, 355630045, 356544168, 357458757, 358373814, 359289339, 360205334, 
361121800, 362038740, 362956154, 363874044, 364792411, 365711256, 366630582, 367550390, 
368470680, 369391456, 370312717, 371234466, 372156704, 373079432, 374002652, 374926366, 
375850574, 376775279, 377700482, 378626184, 379552387, 380479093, 381406302, 382334016, 
383262238, 384190968, 385120208, 386049959, 386980223, 387911001, 388842296, 389774108, 
390706439, 391639290, 392572664, 393506561, 394440984, 395375933, 396311410, 397247417, 
398183956, 399121027, 400058633, 400996775, 401935455, 402874673, 403814433, 404754734, 
405695580, 406636971, 407578909, 408521396, 409464433, 410408022, 411352164, 412296861, 
413242115, 414187927, 415134299, 416081232, 417028728, 417976789, 418925416, 419874612, 
420824376, 421774712, 422725621, 423677104, 424629163, 425581800, 426535017, 427488814, 
428443194, 429398159, 430353709, 431309847, 432266574, 433223893, 434181804, 435140309, 
436099411, 437059110, 438019409, 438980309, 439941811, 440903918, 441866632, 442829953, 
443793884, 444758426, 445723581
};

/* (int)(0.5 + (1<<12) * pow((double)quant,(double)4/(double)3)) */
static int invQuantCompact[MAX_INV_QUANT_TABLE] = {
  0, 4096, 10321, 17722, 26008, 35020, 44658, 54848, 65536, 76680, 88246, 
  100204, 112530, 125204, 138207, 151524, 165140, 179043, 193222, 207666, 
  222365, 237312, 252497, 267915, 283558, 299419, 315494, 331776, 348260, 
  364942, 381817, 398880, 416128, 433556, 451161, 468940, 486889, 505005, 
  523285, 541726, 560325, 579080, 597988, 617046, 636253, 655607, 675104, 
  694742, 714521, 734437, 754490, 774676, 794995, 815445, 836023, 856729, 
  877561, 898517, 919596, 940797, 962118, 983557, 1005114, 1026788, 1048576, 
  1070478, 1092493, 1114619, 1136855, 1159201, 1181655, 1204216, 1226883, 
  1249656, 1272533, 1295513, 1318595, 1341779, 1365063, 1388447, 1411930, 
  1435511, 1459190, 1482964, 1506835, 1530800, 1554860, 1579013, 1603258, 
  1627596, 1652025, 1676545, 1701154, 1725853, 1750641, 1775517, 1800480, 
  1825530, 1850666, 1875888, 1901195, 1926586, 1952062, 1977620, 2003262, 
  2028986, 2054792, 2080679, 2106646, 2132694, 2158822, 2185029, 2211315, 
  2237679, 2264122, 2290641, 2317238, 2343911, 2370660, 2397485, 2424385, 
  2451360, 2478409, 2505533, 2532730, 2560000, 2587343, 2614758, 2642246, 
  2669805, 2697436, 2725137, 2752909, 2780751, 2808663, 2836645, 2864696, 
  2892815, 2921003, 2949260, 2977584, 3005975, 3034434, 3062960, 3091552, 
  3120211, 3148935, 3177726, 3206581, 3235502, 3264487, 3293537, 3322651, 
  3351829, 3381071, 3410376, 3439744, 3469175, 3498668, 3528224, 3557841, 
  3587521, 3617262, 3647064, 3676928, 3706852, 3736836, 3766881, 3796986, 
  3827151, 3857375, 3887658, 3918001, 3948403, 3978863, 4009381, 4039958, 
  4070593, 4101285, 4132035, 4162842, 4193707, 4224628, 4255606, 4286640, 
  4317731, 4348878, 4380080, 4411339, 4442653, 4474022, 4505446, 4536925, 
  4568459, 4600047, 4631689, 4663386, 4695137, 4726941, 4758799,
  4790711, 4822675, 4854693, 4886764, 4918887, 4951063, 4983291, 5015571, 
  5047904, 5080288, 5112724, 5145211, 5177750, 5210340, 5242981, 5275673, 
  5308416, 5341209, 5374053, 5406947, 5439891, 5472885, 5505929, 5539022, 
  5572165, 5605357, 5638599, 5671889, 5705229, 5738617, 5772054, 5805540, 
  5839073, 5872655, 5906285, 5939963, 5973689, 6007463, 6041284, 6075152, 
  6109068, 6143030, 6177040, 6211097, 6245200, 6279351, 6313547, 6347790, 
  6382079, 6416414, 6450796, 6485223, 6519696, 6554214, 6588778, 6623388, 
  6658043, 6692742, 6727487, 6762277, 6797112, 6831991, 6866915, 6901883, 
  6936896, 6971953, 7007054, 7042199, 7077388, 7112621, 7147897, 7183217, 
  7218581, 7253988, 7289438, 7324931, 7360467, 7396047, 7431669, 7467334, 
  7503041, 7538791, 7574584, 7610418, 7646295, 7682214, 7718176, 7754179, 
  7790224, 7826310, 7862439, 7898609, 7934820, 7971073, 8007367, 8043702, 
  8080078, 8116495, 8152954, 8189452, 8225992, 8262572, 8299193, 8335854, 
  8372556, 8409298, 8446080, 8482902, 8519764, 8556666, 8593608, 8630590, 
  8667611, 8704672, 8741772, 8778912, 8816091, 8853309, 8890567, 8927863, 
  8965199, 9002573, 9039986, 9077438, 9114929, 9152458, 9190026, 9227632, 
  9265277, 9302960, 9340681, 9378440, 9416237, 9454072, 9491946, 9529856, 
  9567805, 9605791, 9643815, 9681877, 9719976, 9758112, 9796285, 9834496, 
  9872744, 9911029, 9949351, 9987710, 10026106, 10064538, 10103007, 10141513, 
  10180056, 10218635, 10257251, 10295902, 10334591, 10373315, 10412076, 
  10450872, 10489705, 10528574, 10567479, 10606419, 10645395, 10684407, 
  10723455, 10762538, 10801657, 10840811, 10880000, 10919225, 10958485, 
  10997781, 11037111, 11076477, 11115877, 11155313, 11194783, 11234288, 
  11273828, 11313403, 11353012, 11392656, 11432334, 11472047, 11511794, 
  11551576, 11591392, 11631242, 11671126, 11711044, 11750997, 11790983, 
  11831003, 11871058, 11911145, 11951267, 11991423, 12031612,
  12071834, 12112091, 12152380, 12192703, 12233060, 12273450, 12313873, 
  12354329, 12394818, 12435341, 12475896, 12516485, 12557106, 12597761, 
  12638448, 12679168, 12719920, 12760706, 12801523, 12842374, 12883257, 
  12924172, 12965120, 13006100, 13047113, 13088158, 13129235, 13170344, 
  13211485, 13252658, 13293864, 13335101, 13376370, 13417671, 13459004, 
  13500369, 13541765, 13583193, 13624652, 13666143, 13707666, 13749220, 
  13790806, 13832423, 13874071, 13915750, 13957461, 13999203, 14040976, 
  14082780, 14124615, 14166482, 14208379, 14250307, 14292266, 14334256, 
  14376276, 14418327, 14460409, 14502522, 14544665, 14586839, 14629043, 
  14671278, 14713543, 14755838, 14798164, 14840520, 14882906, 14925323, 
  14967770, 15010246, 15052753, 15095290, 15137857, 15180454, 15223081, 
  15265737, 15308424, 15351140, 15393886, 15436662, 15479467, 15522302, 
  15565166, 15608060, 15650984, 15693937, 15736919, 15779931, 15822972, 
  15866042, 15909142, 15952271, 15995429, 16038616, 16081832, 16125077, 
  16168351, 16211655, 16254987, 16298348, 16341738, 16385157, 16428604, 
  16472080, 16515585, 16559119, 16602681, 16646272, 16689892, 16733540, 
  16777216, 16820921, 16864654, 16908416, 16952206, 16996024, 17039871, 
  17083745, 17127648, 17171580, 17215539, 17259526, 17303541, 17347585, 
  17391656, 17435755, 17479883, 17524038, 17568221, 17612431, 17656670, 
  17700936, 17745230, 17789551, 17833900, 17878277, 17922681, 17967113, 
  18011572, 18056059, 18100573, 18145115, 18189684, 18234280, 18278903, 
  18323554, 18368232, 18412937, 18457670, 18502429, 18547216, 18592029, 
  18636870, 18681737, 18726632, 18771553, 18816502, 18861477, 18906479, 
  18951508, 18996563, 19041645, 19086754, 19131890, 19177052, 19222241, 
  19267457, 19312699, 19357967, 19403262, 19448584, 19493932, 19539306, 
  19584707, 19630134, 19675587, 19721067, 19766572, 19812104, 19857662, 
  19903247, 19948857, 19994494, 20040156, 20085845, 20131559, 20177300, 
  20223066, 20268859, 20314677, 20360521, 20406391, 20452287, 20498208, 
  20544156, 20590128, 20636127, 20682151,
  20728201, 20774277, 20820378, 20866504, 20912656, 20958834, 21005037, 
  21051265, 21097519, 21143798, 21190103, 21236433, 21282788, 21329168, 
  21375574, 21422004, 21468460, 21514941, 21561448, 21607979, 21654535, 
  21701117, 21747723, 21794354, 21841011, 21887692, 21934398, 21981129, 
  22027885, 22074666, 22121472, 22168302, 22215157, 22262037, 22308941, 
  22355870, 22402824, 22449802, 22496805, 22543833, 22590885, 22637962, 
  22685063, 22732188, 22779338, 22826513, 22873711, 22920935, 22968182, 
  23015454, 23062750, 23110070, 23157415, 23204784, 23252177, 23299594, 
  23347035, 23394500, 23441990, 23489503, 23537041, 23584602, 23632188, 
  23679798, 23727431, 23775088, 23822770, 23870475, 23918204, 23965957, 
  24013733, 24061534, 24109358, 24157206, 24205077, 24252973, 24300892, 
  24348834, 24396800, 24444790, 24492803, 24540840, 24588901, 24636985, 
  24685092, 24733223, 24781377, 24829555, 24877756, 24925980, 24974228, 
  25022499, 25070793, 25119111, 25167452, 25215816, 25264203, 25312613, 
  25361047, 25409504, 25457984, 25506486, 25555012, 25603562, 25652134, 
  25700729, 25749347, 25797988, 25846652, 25895339, 25944048, 25992781, 
  26041537, 26090315, 26139116, 26187940, 26236787, 26285656, 26334548, 
  26383463, 26432401, 26481361, 26530344, 26579349, 26628377, 26677428, 
  26726501, 26775597, 26824715, 26873856, 26923019, 26972205, 27021413, 
  27070644, 27119897, 27169172, 27218469, 27267789, 27317132, 27366496, 
  27415883, 27465292, 27514724, 27564177, 27613653, 27663151, 27712671, 
  27762213, 27811777, 27861364, 27910972, 27960603, 28010255, 28059930, 
  28109627, 28159345, 28209086, 28258848, 28308632, 28358439, 28408267, 
  28458117, 28507989, 28557882, 28607798, 28657735, 28707694, 28757675, 
  28807677, 28857701, 28907747, 28957815, 29007904, 29058015, 29108147, 
  29158301, 29208477, 29258674, 29308893, 29359133, 29409395, 29459678, 
  29509983, 29560309, 29610656, 29661025, 29711415, 29761827, 29812260, 
  29862715, 29913190, 29963688, 30014206, 30064745, 30115306, 30165888, 
  30216492, 30267116, 30317762, 30368429,
  30419117, 30469826, 30520556, 30571307, 30622079, 30672873, 30723687, 
  30774523, 30825379, 30876257, 30927155, 30978075, 31029015, 31079976, 
  31130958, 31181961, 31232985, 31284030, 31335095, 31386182, 31437289, 
  31488417, 31539565, 31590735, 31641925, 31693136, 31744367, 31795620, 
  31846893, 31898186, 31949500, 32000835, 32052191, 32103567, 32154963, 
  32206380, 32257818, 32309276, 32360755, 32412254, 32463773, 32515313, 
  32566874, 32618455, 32670056, 32721677, 32773320, 32824982, 32876665, 
  32928368, 32980091, 33031835, 33083598, 33135383, 33187187, 33239012, 
  33290856, 33342721, 33394607, 33446512, 33498437, 33550383, 33602349, 
  33654335, 33706341, 33758367, 33810413, 33862479, 33914565, 33966671, 
  34018797, 34070943, 34123109, 34175295, 34227501, 34279727, 34331973, 
  34384238, 34436524, 34488829, 34541154, 34593499, 34645864, 34698248, 
  34750653, 34803077, 34855521, 34907984, 34960468, 35012971, 35065494, 
  35118036, 35170598, 35223180, 35275781, 35328402, 35381043, 35433703, 
  35486383, 35539082, 35591801, 35644539, 35697297, 35750074, 35802871, 
  35855687, 35908523, 35961378, 36014253, 36067147, 36120061, 36172994, 
  36225946, 36278917, 36331908, 36384919, 36437948, 36490997, 36544065, 
  36597153, 36650259, 36703385, 36756530, 36809695, 36862878, 36916081, 
  36969303, 37022544, 37075804, 37129084, 37182382, 37235700, 37289037, 
  37342393, 37395767, 37449161, 37502574, 37556006, 37609457, 37662927, 
  37716416, 37769924, 37823451, 37876997, 37930562, 37984145, 38037748, 
  38091369, 38145010, 38198669, 38252347, 38306044, 38359760, 38413494, 
  38467248, 38521020, 38574811, 38628620, 38682449, 38736296, 38790162, 
  38844046, 38897950, 38951872, 39005812, 39059772, 39113749, 39167746, 
  39221761, 39275795, 39329847, 39383918, 39438008, 39492116, 39546242, 
  39600387, 39654551, 39708733, 39762934, 39817153, 39871391, 39925647, 
  39979921, 40034214, 40088525, 40142855, 40197203, 40251569, 40305954, 
  40360357, 40414779, 40469219, 40523677, 40578153, 40632648, 40687161, 
  40741692, 40796242, 40850810, 40905396,
  40960000, 41014622, 41069263, 41123922, 41178599, 41233294, 41288007, 
  41342739, 41397488, 41452256, 41507042, 41561845, 41616667, 41671507, 
  41726365, 41781241, 41836135, 41891047, 41945977, 42000925, 42055892, 
  42110876, 42165877, 42220897, 42275935
};

/* (int) ( pow(((double)quant+1-0.4054),4.0/3.0) * pow(2.0,res/4.0) * (1<<12) ) */
static int thrCompact[4][MAX_THR_TABLE] = {
  {2047, 7630, 14603, 22554, 31286, 40680, 50653, 61145, 72109, 83508, 
   95310, 107489, 120025, 132897, 146088, 159585, 173373, 187441, 201778, 
   216375, 231223, 246312, 261637, 277189, 292963, 308952, 325150, 341553, 
   358155, 374952, 391940, 409113, 426469, 444003, 461711, 479592, 497640, 
   515854, 534230, 552765, 571457, 590304, 609302, 628449, 647743, 667182, 
   686763, 706485},
  {2435, 9074, 17366, 26821, 37206, 48377, 60237, 72714, 85753, 99308, 
   113343, 127827, 142734, 158042, 173729, 189779, 206176, 222906, 239956, 
   257315, 274972, 292916, 311140, 329635, 348393, 367407, 386671, 406177, 
   425921, 445896, 466097, 486520, 507159, 528011, 549071, 570334, 591797, 
   613457, 635310, 657353, 679581, 701993, 724586, 747356, 770301, 793417, 
   816704, 840158},
  {2896, 10791, 20652, 31896, 44245, 57530, 71635, 86473, 101978, 118098, 
   134788, 152013, 169741, 187944, 206600, 225687, 245186, 265082, 285358, 
   306001, 326998, 348338, 370010, 392005, 414312, 436924, 459832, 483029, 
   506508, 530263, 554286, 578573, 603118, 627915, 652959, 678245, 703770, 
   729528, 755516, 781729, 808163, 834816, 861683, 888761, 916047, 943538, 
   971230, 999121},
  {3444, 12833, 24559, 37931, 52617, 68416, 85189, 102834, 121273, 140443, 
   160292, 180775, 201857, 223505, 245690, 268389, 291578, 315237, 339350, 
   363899, 388869, 414246, 440019, 466175, 492703, 519593, 546835, 574422, 
   602343, 630592, 659161, 688044, 717232, 746721, 776503, 806574, 836928, 
   867560, 898465, 929637, 961073, 992769, 1024719, 1056921, 1089370, 1122062, 
   1154994, 1188162}
};


/* interpolate value between v0 = data[0] and v8 = data[8], 
   using additionally vm8 = data[-8] and v16 = data[16] */
static int interpolateValue1to7(int vm8,
                                int v0,
                                int v8,
                                int v16,
                                int l)
{
  int value;
  int d1, d2, d3;

  d1 = 2*(v8-v0); /* 1 add, 1 shift */
  d2 = v8-vm8;
  d3 = v16-v0;


  if (l==1) {
    value = v0 + ( ( 8*d2 - d2 + d1 + 64 ) >> 7 ); /* 4 adds, 2 shifts */
  } else if (l==2) {
    value = v0 + ( ( 2*d2 + d2 + d1 + 16 ) >> 5 ); /* 4 adds, 2 shifts */
  } else if (l==3) {
    value = v0 + ( ( 16*d2 - d2 + 8*d1 + d1 + 64 ) >> 7 ); /* 5 adds, 3 shifts */
  } else if (l==4) {
    value = v0 + ( ( d2 + d1 + 4 ) >> 3 ); /* 3 adds, 1 shifts */
  } else if (l==5) { 
    value = v8 - ( ( 16*d3 - d3 + 8*d1 + d1 + 64 ) >> 7 ); /* 5 adds, 3 shifts */
  } else if (l==6) {
    value = v8 - ( ( 2*d3 + d3 + d1 + 16 ) >> 5 ); /* 4 adds, 2 shifts */
  } else if (l==7) {
    value = v8 - ( ( 8*d3 - d3 + d1 + 64 ) >> 7 ); /* 4 adds, 2 shifts */
  }


  return value;
}


static int interpolateFromCompactTable(int index, int* compactTable)
{
  int j,k;
  int value;

  j = index%8;
  k = index/8;

  if (j == 0) {
    value = compactTable[k+1];
    return value;
  }
  value = interpolateValue1to7(compactTable[k],
                               compactTable[k+1],
                               compactTable[k+2],
                               compactTable[k+3],
                               j);
  return value;
}


int sineDataFunction(int index)
{
  return interpolateFromCompactTable(index, sineDataCompact);
}


int sineDataFunction_cs(int index)
{
  return interpolateFromCompactTable(index, sineDataCompact_cs);
}


static int multShiftINT32(int x, int y, int shift)
{
  return ( (int)(( (INT64) x * y) >> shift) );
}

static int multShiftRoundINT32(int x, int y, int shift)
{
  return ( ( multShiftINT32(x, y, shift-1) + 1 ) >> 1);
}


static int invQuantMantissa(int quant, int res)
{
  int k,l;
  int value;
  int pow_2_quat[4] = {0, 1276901417, 1518500250, 1805811301}; /* (int)(pow(2.0,res/4.0)*(1<<SHIFT)+0.5) */

  if (quant < MAX_INV_QUANT_TABLE) {
    value = invQuantCompact[quant];
    if (res > 0) {
      value = multShiftRoundINT32(value,
                                  pow_2_quat[res],
                                  SHIFT);
    }

  } else {
  
    l = quant%8;
    k = quant/8;
    
    if (l == 0) {
      value = invQuantMantissa(k, res)<<4; /* 8^(4/3) = 16 = 2^4 */
    } else {

      value = interpolateValue1to7(invQuantMantissa(k-1, res)<<4,
                                   invQuantMantissa(k, res)<<4,
                                   invQuantMantissa(k+1, res)<<4,
                                   invQuantMantissa(k+2, res)<<4,
                                   l);
    }
  }
  return value;
}


static int thrMantissa(int quant, int res)
{ 
  int value;
  int invQuant0;
  int invQuant1;

  if (quant < MAX_THR_TABLE) {

    value = thrCompact[res][quant];     

  } else {

    invQuant0 = invQuantMantissa(quant,res);
    invQuant1 = invQuantMantissa(quant+1,res);
    value = invQuant1+(((invQuant0-invQuant1)*13)>>5);
  }

  return value;
}


int thrFunction(int abs_quant_aac, int overall_scale)
{
  int scale;
  int overall_scale_int;
  int overall_scale_res;
  int thr_new;

	overall_scale_int = (int)floor((double)overall_scale/4);
  overall_scale_res = overall_scale - overall_scale_int*4;
  
  thr_new = thrMantissa(abs_quant_aac,overall_scale_res); 

  scale = 12 + overall_scale_int;
  if (scale >= 0) {
    thr_new <<= scale;
  } else {
    thr_new >>= -scale;
  } 

  return thr_new; 
}


int invQuantFunction(int abs_quant_aac, int overall_scale)
{
  int value;
  int overall_scale_int;
  int overall_scale_res;
  int scale;

  overall_scale_int = (int)floor((double)overall_scale/4);
  overall_scale_res = overall_scale - overall_scale_int*4;
  
  value = invQuantMantissa(abs_quant_aac,overall_scale_res);

  scale = 12 + overall_scale_int;
  if (scale >= 0) {
    value <<= scale;
  } else {
    value >>= -scale; 
  } 

  return value;
}



