
/*

This software module was originally developed by

    Kazuyuki Iijima (Sony Corporation)

    and edited by 

    Yuji Maeda (Sony Corporation)

    and

    Christian Mittendorf (Robert Bosch GmbH Germany)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/

#ifdef _MSC_VER
#pragma warning(disable:4305)
#endif

static CbLsp	cbLsp =
{
  {
    /*****************************************************************************
     *
     * modified LSP enhancement layer - table
     *
     * 16 bits signed; scale_factor 8; 
     * quantized with: fixed_value = (original_value * 2^15 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^15)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
{
-0.0056762695312500,
0.0074577331542969,
0.0251388549804688,
-0.0039939880371094,
-0.0016098022460938,
-0.0021629333496094,
-0.0011863708496094,
0.0001754760742188,
-0.0034942626953125,
-0.0015144348144531
},
{
0.0016975402832031,
0.0055046081542969,
0.0068092346191406,
0.0264930725097656,
0.0096664428710938,
0.0030746459960938,
0.0091896057128906,
0.0045166015625000,
0.0026969909667969,
0.0165519714355469
},
{
0.0021095275878906,
0.0084877014160156,
0.0009536743164062,
0.0014877319335938,
0.0126495361328125,
0.0171546936035156,
-0.0002555847167969,
-0.0108070373535156,
-0.0006446838378906,
0.0123977661132812
},
{
0.0046501159667969,
0.0047073364257812,
0.0042953491210938,
0.0024375915527344,
0.0047225952148438,
0.0057334899902344,
0.0210342407226562,
0.0155944824218750,
0.0009841918945312,
0.0165023803710938
},
{
-0.0027313232421875,
-0.0035209655761719,
0.0070800781250000,
-0.0083503723144531,
0.0038261413574219,
-0.0032463073730469,
-0.0064582824707031,
0.0096092224121094,
-0.0135078430175781,
-0.0074501037597656
},
{
0.0148200988769531,
-0.0153846740722656,
-0.0044670104980469,
0.0067825317382812,
0.0070190429687500,
-0.0007667541503906,
0.0016136169433594,
-0.0009689331054688,
-0.0063323974609375,
0.0004196166992188
},
{
0.0020294189453125,
-0.0025711059570312,
0.0000991821289062,
-0.0059089660644531,
0.0020256042480469,
0.0034179687500000,
-0.0051841735839844,
-0.0083503723144531,
-0.0031166076660156,
0.0099792480468750
},
{
0.0044250488281250,
-0.0024871826171875,
-0.0016937255859375,
0.0033531188964844,
-0.0010070800781250,
0.0039443969726562,
0.0057449340820312,
-0.0024299621582031,
-0.0028953552246094,
0.0220260620117188
},
{
-0.0010833740234375,
-0.0029258728027344,
0.0110397338867188,
0.0006217956542969,
0.0017662048339844,
0.0020294189453125,
-0.0067710876464844,
-0.0066490173339844,
0.0054855346679688,
0.0134849548339844
},
{
0.0000534057617188,
0.0047607421875000,
0.0060348510742188,
0.0056152343750000,
0.0298500061035156,
-0.0001564025878906,
-0.0049285888671875,
-0.0028152465820312,
0.0024337768554688,
0.0113639831542969
},
{
0.0065727233886719,
-0.0047035217285156,
-0.0027809143066406,
-0.0090827941894531,
0.0082397460937500,
0.0036277770996094,
-0.0013961791992188,
0.0087471008300781,
0.0079612731933594,
0.0105514526367188
},
{
0.0024147033691406,
-0.0057868957519531,
-0.0052871704101562,
-0.0003967285156250,
0.0180892944335938,
0.0047149658203125,
-0.0021095275878906,
0.0079231262207031,
-0.0074882507324219,
-0.0000724792480469
},
{
-0.0033912658691406,
-0.0044631958007812,
0.0069046020507812,
-0.0077285766601562,
0.0049591064453125,
0.0053863525390625,
0.0085258483886719,
-0.0099067687988281,
-0.0013923645019531,
-0.0002784729003906
},
{
-0.0012016296386719,
-0.0041389465332031,
0.0056953430175781,
-0.0030670166015625,
0.0162315368652344,
0.0022163391113281,
-0.0014648437500000,
-0.0046348571777344,
0.0157737731933594,
0.0074806213378906
},
{
-0.0013999938964844,
-0.0043830871582031,
0.0032157897949219,
-0.0146179199218750,
-0.0028648376464844,
0.0067634582519531,
-0.0005378723144531,
0.0052642822265625,
0.0111999511718750,
0.0047798156738281
},
{
-0.0054779052734375,
-0.0096549987792969,
-0.0051536560058594,
0.0098762512207031,
0.0121574401855469,
0.0020904541015625,
-0.0012283325195312,
0.0038909912109375,
0.0087471008300781,
0.0008964538574219
},
{
-0.0122108459472656,
-0.0122947692871094,
0.0281639099121094,
0.0011329650878906,
-0.0020713806152344,
0.0024833679199219,
-0.0025863647460938,
-0.0012321472167969,
0.0070533752441406,
0.0003929138183594
},
{
0.0010643005371094,
-0.0036354064941406,
-0.0003356933593750,
0.0172576904296875,
0.0053176879882812,
0.0037574768066406,
-0.0014038085937500,
-0.0006179809570312,
0.0142555236816406,
0.0033149719238281
},
{
0.0005340576171875,
0.0047416687011719,
0.0060081481933594,
0.0047531127929688,
0.0041503906250000,
0.0488166809082031,
-0.0100860595703125,
0.0051765441894531,
0.0054283142089844,
0.0145950317382812
},
{
0.0010528564453125,
0.0043754577636719,
-0.0018920898437500,
0.0099220275878906,
0.0031127929687500,
0.0219764709472656,
-0.0015602111816406,
0.0089759826660156,
0.0006866455078125,
0.0145263671875000
},
{
-0.0070152282714844,
0.0032424926757812,
0.0066947937011719,
0.0037651062011719,
-0.0065650939941406,
-0.0005187988281250,
-0.0069694519042969,
0.0043830871582031,
0.0075454711914062,
0.0085296630859375
},
{
-0.0060768127441406,
-0.0037727355957031,
0.0076522827148438,
0.0049400329589844,
-0.0006790161132812,
0.0014610290527344,
0.0014114379882812,
0.0090599060058594,
0.0078010559082031,
-0.0062751770019531
},
{
0.0025787353515625,
0.0026931762695312,
0.0016860961914062,
-0.0015487670898438,
0.0022201538085938,
0.0123901367187500,
-0.0091400146484375,
-0.0057640075683594,
0.0003890991210938,
-0.0031814575195312
},
{
0.0036544799804688,
0.0028343200683594,
-0.0050277709960938,
0.0014495849609375,
0.0005455017089844,
0.0070533752441406,
0.0023574829101562,
0.0107307434082031,
0.0024642944335938,
-0.0026359558105469
},
{
-0.0055465698242188,
-0.0050392150878906,
0.0020370483398438,
-0.0008621215820312,
-0.0006446838378906,
0.0018997192382812,
-0.0027770996093750,
-0.0124893188476562,
0.0262336730957031,
0.0185203552246094
},
{
-0.0077743530273438,
0.0034599304199219,
0.0028839111328125,
0.0019187927246094,
0.0076293945312500,
-0.0026016235351562,
-0.0019493103027344,
-0.0046386718750000,
0.0017356872558594,
0.0093650817871094
},
{
0.0024948120117188,
-0.0040245056152344,
0.0003051757812500,
-0.0035552978515625,
0.0050239562988281,
0.0279769897460938,
-0.0023765563964844,
-0.0037651062011719,
0.0084838867187500,
0.0069274902343750
},
{
-0.0070114135742188,
0.0035629272460938,
-0.0053176879882812,
0.0043678283691406,
0.0038604736328125,
0.0041427612304688,
0.0001144409179688,
-0.0044441223144531,
0.0121231079101562,
0.0226287841796875
},
{
-0.0024795532226562,
-0.0038146972656250,
0.0016746520996094,
0.0001068115234375,
0.0032615661621094,
0.0050926208496094,
0.0011787414550781,
0.0138435363769531,
0.0311431884765625,
0.0848617553710938
},
{
-0.0002822875976562,
0.0023803710937500,
0.0037422180175781,
-0.0010566711425781,
0.0079956054687500,
0.0036201477050781,
-0.0009613037109375,
0.0073776245117188,
0.0107994079589844,
0.0068435668945312
},
{
-0.0014877319335938,
-0.0031433105468750,
0.0000381469726562,
-0.0019149780273438,
0.0006866455078125,
0.0039062500000000,
-0.0137100219726562,
0.0050048828125000,
0.0017280578613281,
0.0497741699218750
},
{
-0.0016822814941406,
-0.0026283264160156,
-0.0028533935546875,
0.0012931823730469,
0.0047225952148438,
0.0061111450195312,
-0.0009765625000000,
0.0048561096191406,
0.0154724121093750,
0.0043449401855469
},
{
-0.0018615722656250,
0.0032310485839844,
0.0059165954589844,
-0.0049247741699219,
-0.0051498413085938,
-0.0090026855468750,
0.0042762756347656,
0.0075340270996094,
0.0097541809082031,
0.0052986145019531
},
{
-0.0001068115234375,
-0.0051116943359375,
-0.0022811889648438,
0.0162620544433594,
0.0010185241699219,
-0.0022239685058594,
0.0012931823730469,
0.0079078674316406,
-0.0217247009277344,
-0.0041465759277344
},
{
0.0023040771484375,
-0.0056114196777344,
-0.0004615783691406,
-0.0030899047851562,
-0.0007781982421875,
0.0021209716796875,
0.0320472717285156,
0.0362968444824219,
-0.0040664672851562,
0.0020179748535156
},
{
-0.0037765502929688,
0.0041275024414062,
-0.0005455017089844,
0.0098037719726562,
0.0112724304199219,
0.0032272338867188,
0.0126113891601562,
0.0100326538085938,
-0.0097923278808594,
-0.0036354064941406
},
{
0.0023345947265625,
-0.0033187866210938,
0.0031127929687500,
-0.0094680786132812,
-0.0094718933105469,
-0.0005378723144531,
0.0008354187011719,
-0.0038757324218750,
-0.0316505432128906,
-0.0162010192871094
},
{
0.0070419311523438,
-0.0037002563476562,
-0.0021171569824219,
0.0075569152832031,
0.0002670288085938,
0.0001373291015625,
-0.0019302368164062,
-0.0124206542968750,
-0.0159873962402344,
-0.0121383666992188
},
{
0.0010566711425781,
-0.0055732727050781,
0.0058403015136719,
-0.0050125122070312,
-0.0002937316894531,
-0.0032081604003906,
0.0200004577636719,
-0.0020942687988281,
-0.0125312805175781,
-0.0031852722167969
},
{
-0.0034751892089844,
-0.0029563903808594,
0.0033493041992188,
0.0004196166992188,
-0.0018882751464844,
0.0038375854492188,
0.0008010864257812,
0.0027770996093750,
-0.0124168395996094,
0.0292701721191406
},
{
-0.0016593933105469,
0.0026016235351562,
0.0041084289550781,
0.0008506774902344,
0.0072822570800781,
-0.0077667236328125,
0.0091590881347656,
-0.0056762695312500,
0.0006484985351562,
0.0005569458007812
},
{
-0.0045700073242188,
-0.0027809143066406,
0.0007629394531250,
0.0066986083984375,
0.0025062561035156,
-0.0021438598632812,
0.0111770629882812,
-0.0072326660156250,
-0.0028991699218750,
0.0021705627441406
},
{
-0.0015335083007812,
-0.0031776428222656,
-0.0065917968750000,
-0.0066757202148438,
-0.0015640258789062,
0.0070533752441406,
0.0064811706542969,
-0.0021629333496094,
0.0022659301757812,
-0.0059242248535156
},
{
-0.0091934204101562,
-0.0037841796875000,
-0.0029907226562500,
-0.0002098083496094,
0.0006904602050781,
0.0007858276367188,
0.0077743530273438,
-0.0049362182617188,
-0.0200424194335938,
0.0043029785156250
},
{
0.0006980895996094,
-0.0049743652343750,
-0.0009574890136719,
-0.0001640319824219,
-0.0067672729492188,
0.0022430419921875,
0.0129966735839844,
-0.0252571105957031,
-0.0097923278808594,
-0.0030937194824219
},
{
-0.0036926269531250,
-0.0029182434082031,
0.0020217895507812,
-0.0016174316406250,
-0.0000038146972656,
0.0034942626953125,
0.0036048889160156,
-0.0054092407226562,
-0.0008201599121094,
-0.0423355102539062
},
{
-0.0014762878417969,
-0.0031013488769531,
-0.0019340515136719,
-0.0120124816894531,
-0.0022392272949219,
-0.0012741088867188,
0.0084342956542969,
0.0036354064941406,
-0.0006752014160156,
0.0086822509765625
},
{
-0.0180168151855469,
-0.0084152221679688,
0.0014762878417969,
-0.0078659057617188,
0.0072059631347656,
0.0009231567382812,
-0.0017547607421875,
0.0011253356933594,
-0.0001907348632812,
0.0038375854492188
},
{
0.0005645751953125,
-0.0040855407714844,
0.0193481445312500,
0.0022544860839844,
-0.0083503723144531,
0.0010337829589844,
-0.0033988952636719,
0.0040969848632812,
0.0040397644042969,
-0.0010261535644531
},
{
0.0023269653320312,
-0.0048866271972656,
0.0074348449707031,
0.0113754272460938,
-0.0011444091796875,
0.0083084106445312,
0.0047149658203125,
-0.0058326721191406,
0.0042610168457031,
0.0090026855468750
},
{
-0.0036773681640625,
-0.0051269531250000,
0.0030822753906250,
0.0029449462890625,
0.0008316040039062,
0.0153007507324219,
0.0047187805175781,
0.0427284240722656,
0.0210762023925781,
0.0229530334472656
},
{
-0.0048980712890625,
-0.0034408569335938,
-0.0059738159179688,
0.0035667419433594,
0.0071754455566406,
0.0092315673828125,
0.0081367492675781,
0.0049591064453125,
-0.0019378662109375,
-0.0023078918457031
},
{
0.0009651184082031,
-0.0046920776367188,
0.0065345764160156,
-0.0005455017089844,
-0.0158729553222656,
-0.0001754760742188,
0.0037078857421875,
-0.0124549865722656,
0.0082778930664062,
-0.0058097839355469
},
{
0.0011177062988281,
-0.0037574768066406,
0.0008544921875000,
0.0046463012695312,
-0.0048141479492188,
0.0014953613281250,
-0.0000801086425781,
-0.0058708190917969,
0.0148315429687500,
-0.0184707641601562
},
{
0.0043296813964844,
0.0029640197753906,
0.0005416870117188,
-0.0060348510742188,
-0.0094451904296875,
0.0080528259277344,
0.0028686523437500,
-0.0075492858886719,
-0.0031242370605469,
-0.0115890502929688
},
{
-0.0062408447265625,
-0.0124359130859375,
-0.0077819824218750,
0.0054435729980469,
-0.0065879821777344,
0.0045738220214844,
0.0026855468750000,
-0.0014610290527344,
-0.0067481994628906,
-0.0069999694824219
},
{
0.0003204345703125,
0.0038032531738281,
0.0017776489257812,
0.0041236877441406,
-0.0026664733886719,
-0.0016174316406250,
-0.0075607299804688,
-0.0166816711425781,
0.0205650329589844,
-0.0089340209960938
},
{
0.0035362243652344,
0.0053558349609375,
0.0006599426269531,
0.0050811767578125,
0.0027275085449219,
0.0058631896972656,
0.0154953002929688,
-0.0117530822753906,
-0.0096893310546875,
0.0010108947753906
},
{
-0.0017890930175781,
0.0037612915039062,
0.0023269653320312,
-0.0049819946289062,
-0.0013961791992188,
0.0105819702148438,
0.0036430358886719,
0.0038948059082031,
0.0068092346191406,
0.0175743103027344
},
{
-0.0001716613769531,
0.0030937194824219,
-0.0074501037597656,
0.0062446594238281,
0.0039558410644531,
0.0004806518554688,
0.0014343261718750,
-0.0042266845703125,
-0.0132102966308594,
0.0012931823730469
},
{
-0.0017776489257812,
0.0039062500000000,
-0.0009765625000000,
-0.0008926391601562,
-0.0021324157714844,
-0.0022926330566406,
0.0085945129394531,
-0.0166511535644531,
0.0290985107421875,
0.0101699829101562
},
{
0.0009536743164062,
-0.0031280517578125,
-0.0040473937988281,
-0.0016403198242188,
-0.0000038146972656,
-0.0047607421875000,
0.0082092285156250,
-0.0091972351074219,
0.0129966735839844,
-0.0354042053222656
},
{
-0.0035209655761719,
0.0028457641601562,
-0.0037384033203125,
-0.0012130737304688,
-0.0074272155761719,
-0.0023307800292969,
-0.0071029663085938,
-0.0001564025878906,
0.0089378356933594,
0.0155296325683594
},
{
-0.0048828125000000,
-0.0033531188964844,
-0.0063591003417969,
0.0039482116699219,
-0.0017280578613281,
-0.0016250610351562,
-0.0027656555175781,
-0.0131759643554688,
0.0025711059570312,
0.0048942565917969
},
{
0.0100479125976562,
0.0046310424804688,
0.0131530761718750,
0.0015029907226562,
-0.0017623901367188,
0.0008697509765625,
0.0014572143554688,
-0.0048561096191406,
-0.0021286010742188,
-0.0051155090332031
},
{
0.0062065124511719,
0.0031051635742188,
0.0012664794921875,
0.0041389465332031,
0.0020103454589844,
0.0037269592285156,
-0.0054740905761719,
-0.0023841857910156,
-0.0113105773925781,
0.0032806396484375
},
{
0.0025024414062500,
0.0029373168945312,
0.0014839172363281,
-0.0065650939941406,
0.0066070556640625,
0.0029029846191406,
0.0005340576171875,
-0.0038452148437500,
-0.0146064758300781,
-0.0204277038574219
},
{
-0.0007858276367188,
0.0103492736816406,
0.0010032653808594,
0.0016059875488281,
-0.0002250671386719,
-0.0016784667968750,
0.0018196105957031,
0.0022621154785156,
0.0023498535156250,
0.0021972656250000
},
{
0.0022697448730469,
-0.0026702880859375,
-0.0004081726074219,
-0.0053634643554688,
-0.0057563781738281,
-0.0081291198730469,
-0.0001907348632812,
0.0013008117675781,
0.0005455017089844,
0.0160751342773438
},
{
0.0099601745605469,
-0.0044059753417969,
-0.0033035278320312,
0.0064048767089844,
-0.0000038146972656,
0.0058898925781250,
-0.0026397705078125,
0.0102233886718750,
0.0034065246582031,
-0.0059471130371094
},
{
0.0028915405273438,
0.0030250549316406,
-0.0044708251953125,
-0.0058708190917969,
-0.0076560974121094,
-0.0024642944335938,
0.0012321472167969,
0.0001144409179688,
0.0076942443847656,
0.0159950256347656
},
{
0.0088195800781250,
0.0037422180175781,
-0.0006599426269531,
0.0024909973144531,
-0.0041465759277344,
-0.0051269531250000,
0.0081367492675781,
-0.0024795532226562,
0.0001068115234375,
0.0036926269531250
},
{
-0.0012130737304688,
0.0038108825683594,
0.0109214782714844,
-0.0064697265625000,
0.0011711120605469,
0.0025978088378906,
-0.0035324096679688,
-0.0062904357910156,
-0.0001487731933594,
-0.0029792785644531
},
{
0.0048980712890625,
0.0030479431152344,
0.0033988952636719,
-0.0030555725097656,
0.0059661865234375,
-0.0079917907714844,
-0.0060386657714844,
0.0032348632812500,
-0.0046234130859375,
-0.0012474060058594
},
{
0.0068969726562500,
0.0044326782226562,
0.0002517700195312,
-0.0181083679199219,
0.0126037597656250,
0.0038452148437500,
-0.0006599426269531,
-0.0016136169433594,
-0.0046348571777344,
0.0045051574707031
},
{
0.0100746154785156,
0.0040779113769531,
-0.0034408569335938,
0.0008850097656250,
0.0112648010253906,
0.0026245117187500,
0.0019912719726562,
0.0010223388671875,
0.0011177062988281,
0.0006675720214844
},
{
0.0030403137207031,
-0.0043869018554688,
0.0058135986328125,
-0.0154914855957031,
0.0129013061523438,
-0.0010948181152344,
-0.0018463134765625,
-0.0001716613769531,
-0.0119934082031250,
-0.0119667053222656
},
{
0.0017929077148438,
-0.0025405883789062,
-0.0004043579101562,
-0.0070571899414062,
0.0046615600585938,
-0.0031623840332031,
-0.0011177062988281,
0.0048751831054688,
0.0063209533691406,
-0.0223617553710938
},
{
-0.0040779113769531,
-0.0069427490234375,
-0.0134429931640625,
-0.0219192504882812,
0.0105857849121094,
-0.0015487670898438,
-0.0016975402832031,
-0.0001678466796875,
0.0053443908691406,
0.0070190429687500
},
{
0.0039176940917969,
0.0031700134277344,
-0.0013198852539062,
0.0036239624023438,
0.0044975280761719,
-0.0037460327148438,
0.0073013305664062,
0.0008468627929688,
0.0070724487304688,
0.0078773498535156
},
{
-0.0004920959472656,
0.0027961730957031,
0.0072288513183594,
0.0002212524414062,
-0.0055465698242188,
0.0028457641601562,
0.0051879882812500,
0.0053520202636719,
-0.0069770812988281,
-0.0115318298339844
},
{
0.0011444091796875,
0.0034370422363281,
0.0042533874511719,
0.0082931518554688,
-0.0032920837402344,
-0.0066871643066406,
0.0024108886718750,
0.0230331420898438,
-0.0103187561035156,
-0.0033340454101562
},
{
-0.0027542114257812,
0.0033798217773438,
0.0018501281738281,
-0.0044517517089844,
-0.0008163452148438,
0.0040321350097656,
-0.0127830505371094,
0.0083618164062500,
-0.0216674804687500,
-0.0114784240722656
},
{
-0.0031433105468750,
0.0217590332031250,
-0.0040893554687500,
0.0082626342773438,
0.0013198852539062,
-0.0012779235839844,
0.0020141601562500,
0.0011596679687500,
-0.0014343261718750,
-0.0032730102539062
},
{
0.0040931701660156,
0.0049781799316406,
0.0041770935058594,
0.0010261535644531,
-0.0120162963867188,
0.0023574829101562,
-0.0031509399414062,
0.0103683471679688,
0.0085754394531250,
0.0241699218750000
},
{
0.0037345886230469,
-0.0039596557617188,
-0.0045509338378906,
-0.0010337829589844,
-0.0039978027343750,
-0.0023651123046875,
0.0001106262207031,
0.0219879150390625,
0.0177536010742188,
0.0106735229492188
},
{
0.0007667541503906,
-0.0027809143066406,
-0.0077056884765625,
-0.0055503845214844,
-0.0003814697265625,
-0.0016937255859375,
-0.0071792602539062,
0.0041084289550781,
-0.0123977661132812,
-0.0035400390625000
},
{
-0.0021781921386719,
0.0036239624023438,
-0.0057220458984375,
0.0004959106445312,
-0.0029106140136719,
0.0040893554687500,
-0.0072288513183594,
0.0181999206542969,
-0.0058517456054688,
-0.0129547119140625
},
{
-0.0006027221679688,
0.0033378601074219,
0.0017738342285156,
-0.0072708129882812,
0.0016822814941406,
0.0002746582031250,
-0.0072364807128906,
-0.0135955810546875,
0.0039138793945312,
0.0155639648437500
},
{
-0.0000762939453125,
0.0037460327148438,
-0.0012741088867188,
-0.0003852844238281,
0.0109596252441406,
-0.0020751953125000,
-0.0091514587402344,
-0.0073013305664062,
-0.0038261413574219,
-0.0043220520019531
},
{
-0.0039863586425781,
0.0027809143066406,
-0.0052528381347656,
-0.0083427429199219,
0.0033340454101562,
0.0088424682617188,
-0.0033264160156250,
-0.0001983642578125,
-0.0050926208496094,
-0.0055885314941406
},
{
-0.0026588439941406,
0.0085258483886719,
-0.0094070434570312,
-0.0006752014160156,
0.0020027160644531,
0.0043754577636719,
0.0049171447753906,
-0.0102996826171875,
-0.0016174316406250,
0.0003280639648438
},
{
0.0026588439941406,
0.0052604675292969,
0.0068626403808594,
0.0024490356445312,
0.0000534057617188,
-0.0048675537109375,
-0.0008201599121094,
0.0093116760253906,
0.0625076293945312,
0.0410041809082031
},
{
-0.0021133422851562,
-0.0030288696289062,
-0.0015945434570312,
-0.0001525878906250,
0.0039749145507812,
-0.0014572143554688,
-0.0067787170410156,
0.0281524658203125,
0.0023574829101562,
-0.0040588378906250
},
{
0.0069503784179688,
0.0070495605468750,
-0.0148048400878906,
-0.0022201538085938,
-0.0045471191406250,
0.0064849853515625,
-0.0020599365234375,
0.0024375915527344,
0.0164108276367188,
0.0120735168457031
},
{
0.0006332397460938,
0.0030250549316406,
-0.0071105957031250,
-0.0006523132324219,
0.0057373046875000,
-0.0006675720214844,
-0.0046958923339844,
-0.0030212402343750,
0.0128517150878906,
0.0061721801757812
},
{
0.0003318786621094,
0.0042762756347656,
-0.0060195922851562,
-0.0043334960937500,
-0.0094108581542969,
-0.0104293823242188,
-0.0280418395996094,
-0.0043945312500000,
-0.0085487365722656,
-0.0326881408691406
},
{
0.0032615661621094,
0.0037002563476562,
-0.0016021728515625,
0.0011482238769531,
0.0001373291015625,
0.0022201538085938,
-0.0309143066406250,
0.0016250610351562,
-0.0318756103515625,
-0.0360450744628906
},
{
0.0036315917968750,
0.0058593750000000,
0.0016479492187500,
-0.0100746154785156,
-0.0004386901855469,
-0.0055923461914062,
0.0223007202148438,
0.0008888244628906,
-0.0047950744628906,
-0.0098342895507812
},
{
-0.0084838867187500,
0.0053367614746094,
-0.0042076110839844,
-0.0017166137695312,
0.0067253112792969,
-0.0038070678710938,
0.0064315795898438,
0.0073242187500000,
-0.0028076171875000,
-0.0001792907714844
},
{
-0.0001907348632812,
0.0045356750488281,
-0.0044174194335938,
-0.0044250488281250,
-0.0126838684082031,
-0.0598983764648438,
-0.0093078613281250,
-0.0033836364746094,
-0.0178184509277344,
-0.0068016052246094
},
{
0.0006980895996094,
-0.0031585693359375,
-0.0062522888183594,
0.0023880004882812,
0.0009040832519531,
0.0015068054199219,
-0.0097770690917969,
0.0006370544433594,
-0.0047607421875000,
-0.0449600219726562
},
{
-0.0003318786621094,
0.0032081604003906,
-0.0037574768066406,
0.0023078918457031,
-0.0084342956542969,
-0.0064735412597656,
0.0209770202636719,
0.0009078979492188,
0.0004844665527344,
0.0165901184082031
},
{
-0.0044441223144531,
0.0040092468261719,
-0.0032348632812500,
-0.0015335083007812,
-0.0061073303222656,
-0.0012664794921875,
0.0094108581542969,
0.0009613037109375,
-0.0128746032714844,
0.0032310485839844
},
{
0.0009651184082031,
-0.0040435791015625,
0.0015907287597656,
0.0015754699707031,
0.0002593994140625,
-0.0059890747070312,
-0.0149536132812500,
-0.0410766601562500,
0.0051918029785156,
-0.0193138122558594
},
{
-0.0006332397460938,
-0.0040817260742188,
-0.0007362365722656,
-0.0006484985351562,
0.0004234313964844,
-0.0028228759765625,
-0.0137481689453125,
-0.0092582702636719,
-0.0453033447265625,
-0.0196266174316406
},
{
-0.0000381469726562,
0.0023498535156250,
-0.0025138854980469,
-0.0072555541992188,
0.0011215209960938,
0.0009307861328125,
0.0092735290527344,
-0.0001258850097656,
0.0039863586425781,
-0.0050888061523438
},
{
-0.0040321350097656,
-0.0027694702148438,
-0.0011520385742188,
-0.0040473937988281,
0.0060844421386719,
-0.0062370300292969,
-0.0019607543945312,
-0.0019493103027344,
-0.0091361999511719,
0.0010147094726562
},
{
-0.0035858154296875,
-0.0061950683593750,
-0.0022201538085938,
-0.0029983520507812,
-0.0017852783203125,
-0.0177764892578125,
-0.0038261413574219,
-0.0600776672363281,
-0.0249061584472656,
-0.0080375671386719
},
{
0.0003700256347656,
-0.0040702819824219,
0.0002403259277344,
-0.0006294250488281,
-0.0046195983886719,
-0.0061416625976562,
0.0008544921875000,
-0.0071525573730469,
-0.0120162963867188,
-0.0728263854980469
},
{
0.0008277893066406,
-0.0054626464843750,
-0.0082130432128906,
-0.0041007995605469,
0.0031776428222656,
-0.0068931579589844,
0.0145759582519531,
-0.0067214965820312,
-0.0075569152832031,
-0.0004615783691406
},
{
0.0007972717285156,
0.0039062500000000,
-0.0020408630371094,
-0.0058631896972656,
0.0058135986328125,
-0.0152397155761719,
0.0130882263183594,
-0.0056495666503906,
0.0109710693359375,
-0.0009040832519531
},
{
0.0001144409179688,
-0.0061264038085938,
0.0021018981933594,
0.0053443908691406,
-0.0158958435058594,
-0.0045623779296875,
-0.0111579895019531,
0.0023384094238281,
-0.0106163024902344,
-0.0130882263183594
},
{
-0.0008430480957031,
0.0038223266601562,
-0.0035400390625000,
0.0020065307617188,
-0.0065727233886719,
0.0058174133300781,
-0.0088768005371094,
-0.0077323913574219,
-0.0095329284667969,
-0.0023155212402344
},
{
-0.0095977783203125,
0.0041236877441406,
-0.0025672912597656,
0.0058746337890625,
0.0001258850097656,
-0.0001258850097656,
-0.0047988891601562,
0.0050964355468750,
-0.0098304748535156,
-0.0008506774902344
},
{
-0.0217552185058594,
0.0089111328125000,
-0.0075721740722656,
0.0067863464355469,
0.0007514953613281,
0.0014114379882812,
0.0035514831542969,
-0.0015602111816406,
0.0020599365234375,
-0.0020599365234375
},
{
0.0016708374023438,
0.0059165954589844,
-0.0064086914062500,
-0.0034408569335938,
-0.0331840515136719,
-0.0010833740234375,
-0.0003471374511719,
-0.0067329406738281,
-0.0091247558593750,
-0.0051460266113281
},
{
0.0022163391113281,
0.0040664672851562,
-0.0011749267578125,
0.0010108947753906,
-0.0074005126953125,
0.0002746582031250,
-0.0022277832031250,
-0.0013122558593750,
0.0021514892578125,
-0.0406875610351562
},
{
-0.0017585754394531,
-0.0041770935058594,
-0.0139656066894531,
-0.0022392272949219,
-0.0128021240234375,
-0.0064811706542969,
0.0024681091308594,
-0.0041198730468750,
0.0081329345703125,
0.0000915527343750
},
{
-0.0078201293945312,
0.0042495727539062,
-0.0114173889160156,
-0.0029983520507812,
-0.0052375793457031,
-0.0015182495117188,
0.0009841918945312,
-0.0014228820800781,
0.0141830444335938,
-0.0001335144042969
},
{
0.0028266906738281,
0.0038452148437500,
-0.0028381347656250,
-0.0052223205566406,
-0.0060119628906250,
-0.0081863403320312,
-0.0274124145507812,
-0.0809364318847656,
-0.0011749267578125,
-0.0097312927246094
},
{
0.0009269714355469,
0.0036201477050781,
-0.0035934448242188,
-0.0010223388671875,
0.0004653930664062,
0.0031166076660156,
0.0054893493652344,
-0.0084877014160156,
-0.0577583312988281,
-0.0181427001953125
},
{
-0.0063209533691406,
0.0030059814453125,
0.0000610351562500,
-0.0034408569335938,
-0.0044670104980469,
0.0071105957031250,
0.0012359619140625,
-0.0097694396972656,
0.0015144348144531,
-0.0145454406738281
},
{
-0.0031242370605469,
0.0026931762695312,
-0.0051460266113281,
-0.0001335144042969,
-0.0011062622070312,
-0.0081024169921875,
-0.0024299621582031,
-0.0089378356933594,
-0.0040359497070312,
-0.0033950805664062
},
{
-0.0036468505859375,
-0.0078315734863281,
-0.0062599182128906,
-0.0045585632324219,
-0.0070571899414062,
-0.0162162780761719,
-0.0414085388183594,
-0.0572242736816406,
0.0134162902832031,
-0.0145606994628906
},
{
-0.0015907287597656,
0.0049095153808594,
0.0036773681640625,
-0.0013542175292969,
0.0013694763183594,
-0.0035667419433594,
-0.0112724304199219,
-0.0054397583007812,
0.0011024475097656,
-0.0550308227539062
},
{
0.0058784484863281,
-0.0029983520507812,
-0.0081291198730469,
-0.0016517639160156,
-0.0030593872070312,
-0.0035552978515625,
-0.0085754394531250,
-0.0088348388671875,
0.0187835693359375,
0.0003662109375000
},
{
0.0007705688476562,
0.0044937133789062,
-0.0113067626953125,
0.0031776428222656,
-0.0037956237792969,
-0.0204429626464844,
0.0002632141113281,
-0.0185317993164062,
0.0047912597656250,
-0.0165901184082031
},
{
0.0056762695312500,
-0.0074577331542969,
-0.0251388549804688,
0.0039939880371094,
0.0016098022460938,
0.0021629333496094,
0.0011863708496094,
-0.0001754760742188,
0.0034942626953125,
0.0015144348144531
},
{
-0.0016975402832031,
-0.0055046081542969,
-0.0068092346191406,
-0.0264930725097656,
-0.0096664428710938,
-0.0030746459960938,
-0.0091896057128906,
-0.0045166015625000,
-0.0026969909667969,
-0.0165519714355469
},
{
-0.0021095275878906,
-0.0084877014160156,
-0.0009536743164062,
-0.0014877319335938,
-0.0126495361328125,
-0.0171546936035156,
0.0002555847167969,
0.0108070373535156,
0.0006446838378906,
-0.0123977661132812
},
{
-0.0046501159667969,
-0.0047073364257812,
-0.0042953491210938,
-0.0024375915527344,
-0.0047225952148438,
-0.0057334899902344,
-0.0210342407226562,
-0.0155944824218750,
-0.0009841918945312,
-0.0165023803710938
},
{
0.0027313232421875,
0.0035209655761719,
-0.0070800781250000,
0.0083503723144531,
-0.0038261413574219,
0.0032463073730469,
0.0064582824707031,
-0.0096092224121094,
0.0135078430175781,
0.0074501037597656
},
{
-0.0148200988769531,
0.0153846740722656,
0.0044670104980469,
-0.0067825317382812,
-0.0070190429687500,
0.0007667541503906,
-0.0016136169433594,
0.0009689331054688,
0.0063323974609375,
-0.0004196166992188
},
{
-0.0020294189453125,
0.0025711059570312,
-0.0000991821289062,
0.0059089660644531,
-0.0020256042480469,
-0.0034179687500000,
0.0051841735839844,
0.0083503723144531,
0.0031166076660156,
-0.0099792480468750
},
{
-0.0044250488281250,
0.0024871826171875,
0.0016937255859375,
-0.0033531188964844,
0.0010070800781250,
-0.0039443969726562,
-0.0057449340820312,
0.0024299621582031,
0.0028953552246094,
-0.0220260620117188
},
{
0.0010833740234375,
0.0029258728027344,
-0.0110397338867188,
-0.0006217956542969,
-0.0017662048339844,
-0.0020294189453125,
0.0067710876464844,
0.0066490173339844,
-0.0054855346679688,
-0.0134849548339844
},
{
-0.0000534057617188,
-0.0047607421875000,
-0.0060348510742188,
-0.0056152343750000,
-0.0298500061035156,
0.0001564025878906,
0.0049285888671875,
0.0028152465820312,
-0.0024337768554688,
-0.0113639831542969
},
{
-0.0065727233886719,
0.0047035217285156,
0.0027809143066406,
0.0090827941894531,
-0.0082397460937500,
-0.0036277770996094,
0.0013961791992188,
-0.0087471008300781,
-0.0079612731933594,
-0.0105514526367188
},
{
-0.0024147033691406,
0.0057868957519531,
0.0052871704101562,
0.0003967285156250,
-0.0180892944335938,
-0.0047149658203125,
0.0021095275878906,
-0.0079231262207031,
0.0074882507324219,
0.0000724792480469
},
{
0.0033912658691406,
0.0044631958007812,
-0.0069046020507812,
0.0077285766601562,
-0.0049591064453125,
-0.0053863525390625,
-0.0085258483886719,
0.0099067687988281,
0.0013923645019531,
0.0002784729003906
},
{
0.0012016296386719,
0.0041389465332031,
-0.0056953430175781,
0.0030670166015625,
-0.0162315368652344,
-0.0022163391113281,
0.0014648437500000,
0.0046348571777344,
-0.0157737731933594,
-0.0074806213378906
},
{
0.0013999938964844,
0.0043830871582031,
-0.0032157897949219,
0.0146179199218750,
0.0028648376464844,
-0.0067634582519531,
0.0005378723144531,
-0.0052642822265625,
-0.0111999511718750,
-0.0047798156738281
},
{
0.0054779052734375,
0.0096549987792969,
0.0051536560058594,
-0.0098762512207031,
-0.0121574401855469,
-0.0020904541015625,
0.0012283325195312,
-0.0038909912109375,
-0.0087471008300781,
-0.0008964538574219
},
{
0.0122108459472656,
0.0122947692871094,
-0.0281639099121094,
-0.0011329650878906,
0.0020713806152344,
-0.0024833679199219,
0.0025863647460938,
0.0012321472167969,
-0.0070533752441406,
-0.0003929138183594
},
{
-0.0010643005371094,
0.0036354064941406,
0.0003356933593750,
-0.0172576904296875,
-0.0053176879882812,
-0.0037574768066406,
0.0014038085937500,
0.0006179809570312,
-0.0142555236816406,
-0.0033149719238281
},
{
-0.0005340576171875,
-0.0047416687011719,
-0.0060081481933594,
-0.0047531127929688,
-0.0041503906250000,
-0.0488166809082031,
0.0100860595703125,
-0.0051765441894531,
-0.0054283142089844,
-0.0145950317382812
},
{
-0.0010528564453125,
-0.0043754577636719,
0.0018920898437500,
-0.0099220275878906,
-0.0031127929687500,
-0.0219764709472656,
0.0015602111816406,
-0.0089759826660156,
-0.0006866455078125,
-0.0145263671875000
},
{
0.0070152282714844,
-0.0032424926757812,
-0.0066947937011719,
-0.0037651062011719,
0.0065650939941406,
0.0005187988281250,
0.0069694519042969,
-0.0043830871582031,
-0.0075454711914062,
-0.0085296630859375
},
{
0.0060768127441406,
0.0037727355957031,
-0.0076522827148438,
-0.0049400329589844,
0.0006790161132812,
-0.0014610290527344,
-0.0014114379882812,
-0.0090599060058594,
-0.0078010559082031,
0.0062751770019531
},
{
-0.0025787353515625,
-0.0026931762695312,
-0.0016860961914062,
0.0015487670898438,
-0.0022201538085938,
-0.0123901367187500,
0.0091400146484375,
0.0057640075683594,
-0.0003890991210938,
0.0031814575195312
},
{
-0.0036544799804688,
-0.0028343200683594,
0.0050277709960938,
-0.0014495849609375,
-0.0005455017089844,
-0.0070533752441406,
-0.0023574829101562,
-0.0107307434082031,
-0.0024642944335938,
0.0026359558105469
},
{
0.0055465698242188,
0.0050392150878906,
-0.0020370483398438,
0.0008621215820312,
0.0006446838378906,
-0.0018997192382812,
0.0027770996093750,
0.0124893188476562,
-0.0262336730957031,
-0.0185203552246094
},
{
0.0077743530273438,
-0.0034599304199219,
-0.0028839111328125,
-0.0019187927246094,
-0.0076293945312500,
0.0026016235351562,
0.0019493103027344,
0.0046386718750000,
-0.0017356872558594,
-0.0093650817871094
},
{
-0.0024948120117188,
0.0040245056152344,
-0.0003051757812500,
0.0035552978515625,
-0.0050239562988281,
-0.0279769897460938,
0.0023765563964844,
0.0037651062011719,
-0.0084838867187500,
-0.0069274902343750
},
{
0.0070114135742188,
-0.0035629272460938,
0.0053176879882812,
-0.0043678283691406,
-0.0038604736328125,
-0.0041427612304688,
-0.0001144409179688,
0.0044441223144531,
-0.0121231079101562,
-0.0226287841796875
},
{
0.0024795532226562,
0.0038146972656250,
-0.0016746520996094,
-0.0001068115234375,
-0.0032615661621094,
-0.0050926208496094,
-0.0011787414550781,
-0.0138435363769531,
-0.0311431884765625,
-0.0848617553710938
},
{
0.0002822875976562,
-0.0023803710937500,
-0.0037422180175781,
0.0010566711425781,
-0.0079956054687500,
-0.0036201477050781,
0.0009613037109375,
-0.0073776245117188,
-0.0107994079589844,
-0.0068435668945312
},
{
0.0014877319335938,
0.0031433105468750,
-0.0000381469726562,
0.0019149780273438,
-0.0006866455078125,
-0.0039062500000000,
0.0137100219726562,
-0.0050048828125000,
-0.0017280578613281,
-0.0497741699218750
},
{
0.0016822814941406,
0.0026283264160156,
0.0028533935546875,
-0.0012931823730469,
-0.0047225952148438,
-0.0061111450195312,
0.0009765625000000,
-0.0048561096191406,
-0.0154724121093750,
-0.0043449401855469
},
{
0.0018615722656250,
-0.0032310485839844,
-0.0059165954589844,
0.0049247741699219,
0.0051498413085938,
0.0090026855468750,
-0.0042762756347656,
-0.0075340270996094,
-0.0097541809082031,
-0.0052986145019531
},
{
0.0001068115234375,
0.0051116943359375,
0.0022811889648438,
-0.0162620544433594,
-0.0010185241699219,
0.0022239685058594,
-0.0012931823730469,
-0.0079078674316406,
0.0217247009277344,
0.0041465759277344
},
{
-0.0023040771484375,
0.0056114196777344,
0.0004615783691406,
0.0030899047851562,
0.0007781982421875,
-0.0021209716796875,
-0.0320472717285156,
-0.0362968444824219,
0.0040664672851562,
-0.0020179748535156
},
{
0.0037765502929688,
-0.0041275024414062,
0.0005455017089844,
-0.0098037719726562,
-0.0112724304199219,
-0.0032272338867188,
-0.0126113891601562,
-0.0100326538085938,
0.0097923278808594,
0.0036354064941406
},
{
-0.0023345947265625,
0.0033187866210938,
-0.0031127929687500,
0.0094680786132812,
0.0094718933105469,
0.0005378723144531,
-0.0008354187011719,
0.0038757324218750,
0.0316505432128906,
0.0162010192871094
},
{
-0.0070419311523438,
0.0037002563476562,
0.0021171569824219,
-0.0075569152832031,
-0.0002670288085938,
-0.0001373291015625,
0.0019302368164062,
0.0124206542968750,
0.0159873962402344,
0.0121383666992188
},
{
-0.0010566711425781,
0.0055732727050781,
-0.0058403015136719,
0.0050125122070312,
0.0002937316894531,
0.0032081604003906,
-0.0200004577636719,
0.0020942687988281,
0.0125312805175781,
0.0031852722167969
},
{
0.0034751892089844,
0.0029563903808594,
-0.0033493041992188,
-0.0004196166992188,
0.0018882751464844,
-0.0038375854492188,
-0.0008010864257812,
-0.0027770996093750,
0.0124168395996094,
-0.0292701721191406
},
{
0.0016593933105469,
-0.0026016235351562,
-0.0041084289550781,
-0.0008506774902344,
-0.0072822570800781,
0.0077667236328125,
-0.0091590881347656,
0.0056762695312500,
-0.0006484985351562,
-0.0005569458007812
},
{
0.0045700073242188,
0.0027809143066406,
-0.0007629394531250,
-0.0066986083984375,
-0.0025062561035156,
0.0021438598632812,
-0.0111770629882812,
0.0072326660156250,
0.0028991699218750,
-0.0021705627441406
},
{
0.0015335083007812,
0.0031776428222656,
0.0065917968750000,
0.0066757202148438,
0.0015640258789062,
-0.0070533752441406,
-0.0064811706542969,
0.0021629333496094,
-0.0022659301757812,
0.0059242248535156
},
{
0.0091934204101562,
0.0037841796875000,
0.0029907226562500,
0.0002098083496094,
-0.0006904602050781,
-0.0007858276367188,
-0.0077743530273438,
0.0049362182617188,
0.0200424194335938,
-0.0043029785156250
},
{
-0.0006980895996094,
0.0049743652343750,
0.0009574890136719,
0.0001640319824219,
0.0067672729492188,
-0.0022430419921875,
-0.0129966735839844,
0.0252571105957031,
0.0097923278808594,
0.0030937194824219
},
{
0.0036926269531250,
0.0029182434082031,
-0.0020217895507812,
0.0016174316406250,
0.0000038146972656,
-0.0034942626953125,
-0.0036048889160156,
0.0054092407226562,
0.0008201599121094,
0.0423355102539062
},
{
0.0014762878417969,
0.0031013488769531,
0.0019340515136719,
0.0120124816894531,
0.0022392272949219,
0.0012741088867188,
-0.0084342956542969,
-0.0036354064941406,
0.0006752014160156,
-0.0086822509765625
},
{
0.0180168151855469,
0.0084152221679688,
-0.0014762878417969,
0.0078659057617188,
-0.0072059631347656,
-0.0009231567382812,
0.0017547607421875,
-0.0011253356933594,
0.0001907348632812,
-0.0038375854492188
},
{
-0.0005645751953125,
0.0040855407714844,
-0.0193481445312500,
-0.0022544860839844,
0.0083503723144531,
-0.0010337829589844,
0.0033988952636719,
-0.0040969848632812,
-0.0040397644042969,
0.0010261535644531
},
{
-0.0023269653320312,
0.0048866271972656,
-0.0074348449707031,
-0.0113754272460938,
0.0011444091796875,
-0.0083084106445312,
-0.0047149658203125,
0.0058326721191406,
-0.0042610168457031,
-0.0090026855468750
},
{
0.0036773681640625,
0.0051269531250000,
-0.0030822753906250,
-0.0029449462890625,
-0.0008316040039062,
-0.0153007507324219,
-0.0047187805175781,
-0.0427284240722656,
-0.0210762023925781,
-0.0229530334472656
},
{
0.0048980712890625,
0.0034408569335938,
0.0059738159179688,
-0.0035667419433594,
-0.0071754455566406,
-0.0092315673828125,
-0.0081367492675781,
-0.0049591064453125,
0.0019378662109375,
0.0023078918457031
},
{
-0.0009651184082031,
0.0046920776367188,
-0.0065345764160156,
0.0005455017089844,
0.0158729553222656,
0.0001754760742188,
-0.0037078857421875,
0.0124549865722656,
-0.0082778930664062,
0.0058097839355469
},
{
-0.0011177062988281,
0.0037574768066406,
-0.0008544921875000,
-0.0046463012695312,
0.0048141479492188,
-0.0014953613281250,
0.0000801086425781,
0.0058708190917969,
-0.0148315429687500,
0.0184707641601562
},
{
-0.0043296813964844,
-0.0029640197753906,
-0.0005416870117188,
0.0060348510742188,
0.0094451904296875,
-0.0080528259277344,
-0.0028686523437500,
0.0075492858886719,
0.0031242370605469,
0.0115890502929688
},
{
0.0062408447265625,
0.0124359130859375,
0.0077819824218750,
-0.0054435729980469,
0.0065879821777344,
-0.0045738220214844,
-0.0026855468750000,
0.0014610290527344,
0.0067481994628906,
0.0069999694824219
},
{
-0.0003204345703125,
-0.0038032531738281,
-0.0017776489257812,
-0.0041236877441406,
0.0026664733886719,
0.0016174316406250,
0.0075607299804688,
0.0166816711425781,
-0.0205650329589844,
0.0089340209960938
},
{
-0.0035362243652344,
-0.0053558349609375,
-0.0006599426269531,
-0.0050811767578125,
-0.0027275085449219,
-0.0058631896972656,
-0.0154953002929688,
0.0117530822753906,
0.0096893310546875,
-0.0010108947753906
},
{
0.0017890930175781,
-0.0037612915039062,
-0.0023269653320312,
0.0049819946289062,
0.0013961791992188,
-0.0105819702148438,
-0.0036430358886719,
-0.0038948059082031,
-0.0068092346191406,
-0.0175743103027344
},
{
0.0001716613769531,
-0.0030937194824219,
0.0074501037597656,
-0.0062446594238281,
-0.0039558410644531,
-0.0004806518554688,
-0.0014343261718750,
0.0042266845703125,
0.0132102966308594,
-0.0012931823730469
},
{
0.0017776489257812,
-0.0039062500000000,
0.0009765625000000,
0.0008926391601562,
0.0021324157714844,
0.0022926330566406,
-0.0085945129394531,
0.0166511535644531,
-0.0290985107421875,
-0.0101699829101562
},
{
-0.0009536743164062,
0.0031280517578125,
0.0040473937988281,
0.0016403198242188,
0.0000038146972656,
0.0047607421875000,
-0.0082092285156250,
0.0091972351074219,
-0.0129966735839844,
0.0354042053222656
},
{
0.0035209655761719,
-0.0028457641601562,
0.0037384033203125,
0.0012130737304688,
0.0074272155761719,
0.0023307800292969,
0.0071029663085938,
0.0001564025878906,
-0.0089378356933594,
-0.0155296325683594
},
{
0.0048828125000000,
0.0033531188964844,
0.0063591003417969,
-0.0039482116699219,
0.0017280578613281,
0.0016250610351562,
0.0027656555175781,
0.0131759643554688,
-0.0025711059570312,
-0.0048942565917969
},
{
-0.0100479125976562,
-0.0046310424804688,
-0.0131530761718750,
-0.0015029907226562,
0.0017623901367188,
-0.0008697509765625,
-0.0014572143554688,
0.0048561096191406,
0.0021286010742188,
0.0051155090332031
},
{
-0.0062065124511719,
-0.0031051635742188,
-0.0012664794921875,
-0.0041389465332031,
-0.0020103454589844,
-0.0037269592285156,
0.0054740905761719,
0.0023841857910156,
0.0113105773925781,
-0.0032806396484375
},
{
-0.0025024414062500,
-0.0029373168945312,
-0.0014839172363281,
0.0065650939941406,
-0.0066070556640625,
-0.0029029846191406,
-0.0005340576171875,
0.0038452148437500,
0.0146064758300781,
0.0204277038574219
},
{
0.0007858276367188,
-0.0103492736816406,
-0.0010032653808594,
-0.0016059875488281,
0.0002250671386719,
0.0016784667968750,
-0.0018196105957031,
-0.0022621154785156,
-0.0023498535156250,
-0.0021972656250000
},
{
-0.0022697448730469,
0.0026702880859375,
0.0004081726074219,
0.0053634643554688,
0.0057563781738281,
0.0081291198730469,
0.0001907348632812,
-0.0013008117675781,
-0.0005455017089844,
-0.0160751342773438
},
{
-0.0099601745605469,
0.0044059753417969,
0.0033035278320312,
-0.0064048767089844,
0.0000038146972656,
-0.0058898925781250,
0.0026397705078125,
-0.0102233886718750,
-0.0034065246582031,
0.0059471130371094
},
{
-0.0028915405273438,
-0.0030250549316406,
0.0044708251953125,
0.0058708190917969,
0.0076560974121094,
0.0024642944335938,
-0.0012321472167969,
-0.0001144409179688,
-0.0076942443847656,
-0.0159950256347656
},
{
-0.0088195800781250,
-0.0037422180175781,
0.0006599426269531,
-0.0024909973144531,
0.0041465759277344,
0.0051269531250000,
-0.0081367492675781,
0.0024795532226562,
-0.0001068115234375,
-0.0036926269531250
},
{
0.0012130737304688,
-0.0038108825683594,
-0.0109214782714844,
0.0064697265625000,
-0.0011711120605469,
-0.0025978088378906,
0.0035324096679688,
0.0062904357910156,
0.0001487731933594,
0.0029792785644531
},
{
-0.0048980712890625,
-0.0030479431152344,
-0.0033988952636719,
0.0030555725097656,
-0.0059661865234375,
0.0079917907714844,
0.0060386657714844,
-0.0032348632812500,
0.0046234130859375,
0.0012474060058594
},
{
-0.0068969726562500,
-0.0044326782226562,
-0.0002517700195312,
0.0181083679199219,
-0.0126037597656250,
-0.0038452148437500,
0.0006599426269531,
0.0016136169433594,
0.0046348571777344,
-0.0045051574707031
},
{
-0.0100746154785156,
-0.0040779113769531,
0.0034408569335938,
-0.0008850097656250,
-0.0112648010253906,
-0.0026245117187500,
-0.0019912719726562,
-0.0010223388671875,
-0.0011177062988281,
-0.0006675720214844
},
{
-0.0030403137207031,
0.0043869018554688,
-0.0058135986328125,
0.0154914855957031,
-0.0129013061523438,
0.0010948181152344,
0.0018463134765625,
0.0001716613769531,
0.0119934082031250,
0.0119667053222656
},
{
-0.0017929077148438,
0.0025405883789062,
0.0004043579101562,
0.0070571899414062,
-0.0046615600585938,
0.0031623840332031,
0.0011177062988281,
-0.0048751831054688,
-0.0063209533691406,
0.0223617553710938
},
{
0.0040779113769531,
0.0069427490234375,
0.0134429931640625,
0.0219192504882812,
-0.0105857849121094,
0.0015487670898438,
0.0016975402832031,
0.0001678466796875,
-0.0053443908691406,
-0.0070190429687500
},
{
-0.0039176940917969,
-0.0031700134277344,
0.0013198852539062,
-0.0036239624023438,
-0.0044975280761719,
0.0037460327148438,
-0.0073013305664062,
-0.0008468627929688,
-0.0070724487304688,
-0.0078773498535156
},
{
0.0004920959472656,
-0.0027961730957031,
-0.0072288513183594,
-0.0002212524414062,
0.0055465698242188,
-0.0028457641601562,
-0.0051879882812500,
-0.0053520202636719,
0.0069770812988281,
0.0115318298339844
},
{
-0.0011444091796875,
-0.0034370422363281,
-0.0042533874511719,
-0.0082931518554688,
0.0032920837402344,
0.0066871643066406,
-0.0024108886718750,
-0.0230331420898438,
0.0103187561035156,
0.0033340454101562
},
{
0.0027542114257812,
-0.0033798217773438,
-0.0018501281738281,
0.0044517517089844,
0.0008163452148438,
-0.0040321350097656,
0.0127830505371094,
-0.0083618164062500,
0.0216674804687500,
0.0114784240722656
},
{
0.0031433105468750,
-0.0217590332031250,
0.0040893554687500,
-0.0082626342773438,
-0.0013198852539062,
0.0012779235839844,
-0.0020141601562500,
-0.0011596679687500,
0.0014343261718750,
0.0032730102539062
},
{
-0.0040931701660156,
-0.0049781799316406,
-0.0041770935058594,
-0.0010261535644531,
0.0120162963867188,
-0.0023574829101562,
0.0031509399414062,
-0.0103683471679688,
-0.0085754394531250,
-0.0241699218750000
},
{
-0.0037345886230469,
0.0039596557617188,
0.0045509338378906,
0.0010337829589844,
0.0039978027343750,
0.0023651123046875,
-0.0001106262207031,
-0.0219879150390625,
-0.0177536010742188,
-0.0106735229492188
},
{
-0.0007667541503906,
0.0027809143066406,
0.0077056884765625,
0.0055503845214844,
0.0003814697265625,
0.0016937255859375,
0.0071792602539062,
-0.0041084289550781,
0.0123977661132812,
0.0035400390625000
},
{
0.0021781921386719,
-0.0036239624023438,
0.0057220458984375,
-0.0004959106445312,
0.0029106140136719,
-0.0040893554687500,
0.0072288513183594,
-0.0181999206542969,
0.0058517456054688,
0.0129547119140625
},
{
0.0006027221679688,
-0.0033378601074219,
-0.0017738342285156,
0.0072708129882812,
-0.0016822814941406,
-0.0002746582031250,
0.0072364807128906,
0.0135955810546875,
-0.0039138793945312,
-0.0155639648437500
},
{
0.0000762939453125,
-0.0037460327148438,
0.0012741088867188,
0.0003852844238281,
-0.0109596252441406,
0.0020751953125000,
0.0091514587402344,
0.0073013305664062,
0.0038261413574219,
0.0043220520019531
},
{
0.0039863586425781,
-0.0027809143066406,
0.0052528381347656,
0.0083427429199219,
-0.0033340454101562,
-0.0088424682617188,
0.0033264160156250,
0.0001983642578125,
0.0050926208496094,
0.0055885314941406
},
{
0.0026588439941406,
-0.0085258483886719,
0.0094070434570312,
0.0006752014160156,
-0.0020027160644531,
-0.0043754577636719,
-0.0049171447753906,
0.0102996826171875,
0.0016174316406250,
-0.0003280639648438
},
{
-0.0026588439941406,
-0.0052604675292969,
-0.0068626403808594,
-0.0024490356445312,
-0.0000534057617188,
0.0048675537109375,
0.0008201599121094,
-0.0093116760253906,
-0.0625076293945312,
-0.0410041809082031
},
{
0.0021133422851562,
0.0030288696289062,
0.0015945434570312,
0.0001525878906250,
-0.0039749145507812,
0.0014572143554688,
0.0067787170410156,
-0.0281524658203125,
-0.0023574829101562,
0.0040588378906250
},
{
-0.0069503784179688,
-0.0070495605468750,
0.0148048400878906,
0.0022201538085938,
0.0045471191406250,
-0.0064849853515625,
0.0020599365234375,
-0.0024375915527344,
-0.0164108276367188,
-0.0120735168457031
},
{
-0.0006332397460938,
-0.0030250549316406,
0.0071105957031250,
0.0006523132324219,
-0.0057373046875000,
0.0006675720214844,
0.0046958923339844,
0.0030212402343750,
-0.0128517150878906,
-0.0061721801757812
},
{
-0.0003318786621094,
-0.0042762756347656,
0.0060195922851562,
0.0043334960937500,
0.0094108581542969,
0.0104293823242188,
0.0280418395996094,
0.0043945312500000,
0.0085487365722656,
0.0326881408691406
},
{
-0.0032615661621094,
-0.0037002563476562,
0.0016021728515625,
-0.0011482238769531,
-0.0001373291015625,
-0.0022201538085938,
0.0309143066406250,
-0.0016250610351562,
0.0318756103515625,
0.0360450744628906
},
{
-0.0036315917968750,
-0.0058593750000000,
-0.0016479492187500,
0.0100746154785156,
0.0004386901855469,
0.0055923461914062,
-0.0223007202148438,
-0.0008888244628906,
0.0047950744628906,
0.0098342895507812
},
{
0.0084838867187500,
-0.0053367614746094,
0.0042076110839844,
0.0017166137695312,
-0.0067253112792969,
0.0038070678710938,
-0.0064315795898438,
-0.0073242187500000,
0.0028076171875000,
0.0001792907714844
},
{
0.0001907348632812,
-0.0045356750488281,
0.0044174194335938,
0.0044250488281250,
0.0126838684082031,
0.0598983764648438,
0.0093078613281250,
0.0033836364746094,
0.0178184509277344,
0.0068016052246094
},
{
-0.0006980895996094,
0.0031585693359375,
0.0062522888183594,
-0.0023880004882812,
-0.0009040832519531,
-0.0015068054199219,
0.0097770690917969,
-0.0006370544433594,
0.0047607421875000,
0.0449600219726562
},
{
0.0003318786621094,
-0.0032081604003906,
0.0037574768066406,
-0.0023078918457031,
0.0084342956542969,
0.0064735412597656,
-0.0209770202636719,
-0.0009078979492188,
-0.0004844665527344,
-0.0165901184082031
},
{
0.0044441223144531,
-0.0040092468261719,
0.0032348632812500,
0.0015335083007812,
0.0061073303222656,
0.0012664794921875,
-0.0094108581542969,
-0.0009613037109375,
0.0128746032714844,
-0.0032310485839844
},
{
-0.0009651184082031,
0.0040435791015625,
-0.0015907287597656,
-0.0015754699707031,
-0.0002593994140625,
0.0059890747070312,
0.0149536132812500,
0.0410766601562500,
-0.0051918029785156,
0.0193138122558594
},
{
0.0006332397460938,
0.0040817260742188,
0.0007362365722656,
0.0006484985351562,
-0.0004234313964844,
0.0028228759765625,
0.0137481689453125,
0.0092582702636719,
0.0453033447265625,
0.0196266174316406
},
{
0.0000381469726562,
-0.0023498535156250,
0.0025138854980469,
0.0072555541992188,
-0.0011215209960938,
-0.0009307861328125,
-0.0092735290527344,
0.0001258850097656,
-0.0039863586425781,
0.0050888061523438
},
{
0.0040321350097656,
0.0027694702148438,
0.0011520385742188,
0.0040473937988281,
-0.0060844421386719,
0.0062370300292969,
0.0019607543945312,
0.0019493103027344,
0.0091361999511719,
-0.0010147094726562
},
{
0.0035858154296875,
0.0061950683593750,
0.0022201538085938,
0.0029983520507812,
0.0017852783203125,
0.0177764892578125,
0.0038261413574219,
0.0600776672363281,
0.0249061584472656,
0.0080375671386719
},
{
-0.0003700256347656,
0.0040702819824219,
-0.0002403259277344,
0.0006294250488281,
0.0046195983886719,
0.0061416625976562,
-0.0008544921875000,
0.0071525573730469,
0.0120162963867188,
0.0728263854980469
},
{
-0.0008277893066406,
0.0054626464843750,
0.0082130432128906,
0.0041007995605469,
-0.0031776428222656,
0.0068931579589844,
-0.0145759582519531,
0.0067214965820312,
0.0075569152832031,
0.0004615783691406
},
{
-0.0007972717285156,
-0.0039062500000000,
0.0020408630371094,
0.0058631896972656,
-0.0058135986328125,
0.0152397155761719,
-0.0130882263183594,
0.0056495666503906,
-0.0109710693359375,
0.0009040832519531
},
{
-0.0001144409179688,
0.0061264038085938,
-0.0021018981933594,
-0.0053443908691406,
0.0158958435058594,
0.0045623779296875,
0.0111579895019531,
-0.0023384094238281,
0.0106163024902344,
0.0130882263183594
},
{
0.0008430480957031,
-0.0038223266601562,
0.0035400390625000,
-0.0020065307617188,
0.0065727233886719,
-0.0058174133300781,
0.0088768005371094,
0.0077323913574219,
0.0095329284667969,
0.0023155212402344
},
{
0.0095977783203125,
-0.0041236877441406,
0.0025672912597656,
-0.0058746337890625,
-0.0001258850097656,
0.0001258850097656,
0.0047988891601562,
-0.0050964355468750,
0.0098304748535156,
0.0008506774902344
},
{
0.0217552185058594,
-0.0089111328125000,
0.0075721740722656,
-0.0067863464355469,
-0.0007514953613281,
-0.0014114379882812,
-0.0035514831542969,
0.0015602111816406,
-0.0020599365234375,
0.0020599365234375
},
{
-0.0016708374023438,
-0.0059165954589844,
0.0064086914062500,
0.0034408569335938,
0.0331840515136719,
0.0010833740234375,
0.0003471374511719,
0.0067329406738281,
0.0091247558593750,
0.0051460266113281
},
{
-0.0022163391113281,
-0.0040664672851562,
0.0011749267578125,
-0.0010108947753906,
0.0074005126953125,
-0.0002746582031250,
0.0022277832031250,
0.0013122558593750,
-0.0021514892578125,
0.0406875610351562
},
{
0.0017585754394531,
0.0041770935058594,
0.0139656066894531,
0.0022392272949219,
0.0128021240234375,
0.0064811706542969,
-0.0024681091308594,
0.0041198730468750,
-0.0081329345703125,
-0.0000915527343750
},
{
0.0078201293945312,
-0.0042495727539062,
0.0114173889160156,
0.0029983520507812,
0.0052375793457031,
0.0015182495117188,
-0.0009841918945312,
0.0014228820800781,
-0.0141830444335938,
0.0001335144042969
},
{
-0.0028266906738281,
-0.0038452148437500,
0.0028381347656250,
0.0052223205566406,
0.0060119628906250,
0.0081863403320312,
0.0274124145507812,
0.0809364318847656,
0.0011749267578125,
0.0097312927246094
},
{
-0.0009269714355469,
-0.0036201477050781,
0.0035934448242188,
0.0010223388671875,
-0.0004653930664062,
-0.0031166076660156,
-0.0054893493652344,
0.0084877014160156,
0.0577583312988281,
0.0181427001953125
},
{
0.0063209533691406,
-0.0030059814453125,
-0.0000610351562500,
0.0034408569335938,
0.0044670104980469,
-0.0071105957031250,
-0.0012359619140625,
0.0097694396972656,
-0.0015144348144531,
0.0145454406738281
},
{
0.0031242370605469,
-0.0026931762695312,
0.0051460266113281,
0.0001335144042969,
0.0011062622070312,
0.0081024169921875,
0.0024299621582031,
0.0089378356933594,
0.0040359497070312,
0.0033950805664062
},
{
0.0036468505859375,
0.0078315734863281,
0.0062599182128906,
0.0045585632324219,
0.0070571899414062,
0.0162162780761719,
0.0414085388183594,
0.0572242736816406,
-0.0134162902832031,
0.0145606994628906
},
{
0.0015907287597656,
-0.0049095153808594,
-0.0036773681640625,
0.0013542175292969,
-0.0013694763183594,
0.0035667419433594,
0.0112724304199219,
0.0054397583007812,
-0.0011024475097656,
0.0550308227539062
},
{
-0.0058784484863281,
0.0029983520507812,
0.0081291198730469,
0.0016517639160156,
0.0030593872070312,
0.0035552978515625,
0.0085754394531250,
0.0088348388671875,
-0.0187835693359375,
-0.0003662109375000
},
{
-0.0007705688476562,
-0.0044937133789062,
0.0113067626953125,
-0.0031776428222656,
0.0037956237792969,
0.0204429626464844,
-0.0002632141113281,
0.0185317993164062,
-0.0047912597656250,
0.0165901184082031
},
  },
};




