
/*

This software module was originally developed by

    Kazuyuki Iijima (Sony Corporation)

    and edited by 

    Yuji Maeda (Sony Corporation)

    and

    Christian Mittendorf (Robert Bosch GmbH Germany)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/



static CbCELPL1 cbL1 =
{
  /*****************************************************************************
   *
   * modified celp gain-table (enhancement layer)
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^1 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^1)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
  {
    14.5000000,
    175.5000000,
    761.5000000,
    410.0000000,
    8478.0000000,
    1285.5000000,
    3835.0000000,
    2151.5000000
  },
  {
    /*****************************************************************************
     *
     * modified enhancement layer - table
     *
     * 16 bits signed; scale_factor 1; 
     * quantized with: fixed_value = (original_value * 2^15 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^15)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1119995117187500,  0.0000000000000000,  -0.1096191406250000,  0.2098693847656250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0574340820312500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1798095703125000,  0.0000000000000000,  0.1545104980468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.3419189453125000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0188903808593750,  -0.1875915527343750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2947082519531250,  0.2541809082031250,  0.5142517089843750,  -0.5509338378906250,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0951538085937500,  
0.0000000000000000,  0.0000000000000000,  -0.1668395996093750,  0.0000000000000000,  
0.2821044921875000,  0.0000000000000000,  0.0788574218750000,  0.0000000000000000,  
0.0511169433593750,  0.0000000000000000,  0.1693725585937500,  -0.0239868164062500,  
0.1653747558593750,  0.0811767578125000,  0.0000000000000000,  0.4871826171875000,  
-0.4308471679687500,  -0.4705505371093750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0314331054687500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0851135253906250,  0.0356445312500000,  
0.1595153808593750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.2304382324218750,  0.0000000000000000,  -0.2811584472656250,  

},
{
0.0337219238281250,  0.0898742675781250,  0.2282104492187500,  0.0000000000000000,  
0.0886840820312500,  0.0165405273437500,  -0.0164184570312500,  -0.0342712402343750,  
0.2005310058593750,  -0.2835998535156250,  0.2507019042968750,  0.1830749511718750,  
0.1700439453125000,  0.0000000000000000,  0.0524902343750000,  -0.0747680664062500,  
0.3669738769531250,  0.1197509765625000,  -0.2456970214843750,  -0.0879821777343750,  
0.0674743652343750,  0.0000000000000000,  0.0953063964843750,  -0.0091247558593750,  
0.1697692871093750,  0.0794982910156250,  0.2706298828125000,  0.0744018554687500,  
0.0718078613281250,  0.2123718261718750,  -0.0073852539062500,  -0.0205993652343750,  
-0.0607910156250000,  -0.1734008789062500,  -0.1296691894531250,  0.3720703125000000,  
-0.1282348632812500,  0.0000000000000000,  0.2076721191406250,  -0.1754760742187500,  

},
{
0.0016479492187500,  0.2747497558593750,  0.0000000000000000,  0.0641784667968750,  
0.0000000000000000,  0.0081176757812500,  -0.2183837890625000,  -0.0258178710937500,  
0.1218261718750000,  0.0000000000000000,  0.1319580078125000,  0.1556396484375000,  
-0.1936340332031250,  0.0000000000000000,  0.0494079589843750,  -0.0973815917968750,  
0.0000000000000000,  0.1943359375000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1968383789062500,  -0.0499572753906250,  -0.0765991210937500,  
-0.1460571289062500,  -0.2546691894531250,  -0.1415405273437500,  -0.2164306640625000,  
-0.1304626464843750,  0.1287841796875000,  0.4989318847656250,  -0.1414794921875000,  
0.0000000000000000,  0.0000000000000000,  -0.3280029296875000,  0.0000000000000000,  
0.2528991699218750,  0.0000000000000000,  0.0000000000000000,  -0.2325134277343750,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.9314575195312500,  
0.0000000000000000,  -0.1989135742187500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0701904296875000,  
0.0000000000000000,  0.0954895019531250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1596069335937500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.2308959960937500,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  -0.0162353515625000,  0.0000000000000000,  0.2114868164062500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0018005371093750,  0.0000000000000000,  -0.2507934570312500,  
0.0000000000000000,  0.0000000000000000,  0.0510864257812500,  0.0000000000000000,  
-0.7395019531250000,  0.0000000000000000,  0.0000000000000000,  0.0217285156250000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.3108215332031250,  
-0.1152954101562500,  0.0002746582031250,  -0.1178588867187500,  -0.2335815429687500,  
0.0000000000000000,  0.0000000000000000,  -0.4047241210937500,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0640258789062500,  0.0000000000000000,  0.0000000000000000,  -0.6044006347656250,  
0.0000000000000000,  0.0000000000000000,  0.0242614746093750,  -0.3111877441406250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.3110351562500000,  -0.3361206054687500,  0.0000000000000000,  
-0.0507507324218750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0827941894531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.5525512695312500,  0.0000000000000000,  
0.0932617187500000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  -0.0375366210937500,  0.0000000000000000,  0.0000000000000000,  
0.1481933593750000,  0.4690856933593750,  0.0000000000000000,  -0.2331237792968750,  
0.0000000000000000,  0.4915771484375000,  0.2299194335937500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1456909179687500,  0.0000000000000000,  0.1072387695312500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0591735839843750,  0.0000000000000000,  
0.0000000000000000,  -0.1321411132812500,  0.0000000000000000,  0.0000000000000000,  
-0.4956054687500000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.2661437988281250,  -0.1938781738281250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
-0.2314147949218750,  -0.0289611816406250,  0.0000000000000000,  0.0519104003906250,  
-0.1350402832031250,  0.0000000000000000,  0.0000000000000000,  -0.2584228515625000,  
-0.2218933105468750,  0.0000000000000000,  0.0305175781250000,  0.1116638183593750,  
-0.0492553710937500,  0.1553344726562500,  -0.1925659179687500,  -0.1773376464843750,  
0.0000000000000000,  -0.0163269042968750,  0.4125061035156250,  0.0000000000000000,  
0.0000000000000000,  0.1052856445312500,  -0.0500488281250000,  0.0000000000000000,  
0.0858764648437500,  -0.1254882812500000,  -0.0783386230468750,  0.1887207031250000,  
0.0155029296875000,  0.3080444335937500,  0.0000000000000000,  -0.0551147460937500,  
0.1691589355468750,  -0.0323791503906250,  -0.1389465332031250,  0.0000000000000000,  
-0.3927612304687500,  -0.1152954101562500,  0.3249206542968750,  0.1760864257812500,  

},
{
-0.1688537597656250,  -0.2828369140625000,  0.0000000000000000,  0.1774597167968750,  
-0.0139160156250000,  0.0000000000000000,  0.0000000000000000,  0.0947570800781250,  
0.1614990234375000,  0.2606201171875000,  0.0902404785156250,  0.3503417968750000,  
-0.0267639160156250,  0.0435180664062500,  -0.0390319824218750,  0.1517333984375000,  
0.1212768554687500,  0.1753540039062500,  -0.0187377929687500,  0.4882202148437500,  
-0.2728576660156250,  0.0123291015625000,  -0.1892700195312500,  0.0000000000000000,  
0.0000000000000000,  0.0948791503906250,  -0.1460876464843750,  -0.1042785644531250,  
0.0535278320312500,  0.0000000000000000,  0.0987243652343750,  -0.1964416503906250,  
0.2416076660156250,  0.1355895996093750,  -0.1137695312500000,  0.0221252441406250,  
-0.1393127441406250,  0.0000000000000000,  -0.0463562011718750,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.4666748046875000,  
0.0000000000000000,  0.1254882812500000,  -0.0966186523437500,  -0.0039978027343750,  
0.6174316406250000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2257385253906250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.4578247070312500,  0.0000000000000000,  0.2356872558593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1829528808593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1210937500000000,  
0.0000000000000000,  -0.1077880859375000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0307922363281250,  0.0000000000000000,  -0.2045288085937500,  
-0.0242004394531250,  0.2179565429687500,  0.0127868652343750,  0.2252502441406250,  
0.1992187500000000,  0.0307006835937500,  -0.3080139160156250,  0.3248596191406250,  
-0.3361816406250000,  0.0224304199218750,  0.0000000000000000,  -0.2410278320312500,  
-0.0960693359375000,  0.0130004882812500,  0.0150756835937500,  0.0683898925781250,  
0.4192810058593750,  0.2367248535156250,  0.1171264648437500,  -0.0229797363281250,  
-0.1381225585937500,  0.0000000000000000,  0.1923828125000000,  0.0000000000000000,  
0.0000000000000000,  -0.1694641113281250,  -0.0481872558593750,  -0.0810241699218750,  
0.0000000000000000,  0.0974121093750000,  0.0000000000000000,  0.0000000000000000,  
-0.1325988769531250,  -0.0815124511718750,  -0.2403564453125000,  0.0000000000000000,  

},
{
0.0000000000000000,  -0.0881652832031250,  -0.0063171386718750,  0.0073242187500000,  
0.1232910156250000,  0.1633911132812500,  0.0000000000000000,  -0.3849487304687500,  
0.0000000000000000,  -0.1417541503906250,  0.1145019531250000,  -0.4457702636718750,  
0.1273803710937500,  -0.0731506347656250,  0.0358276367187500,  0.0000000000000000,  
0.0428161621093750,  0.0939025878906250,  0.1998291015625000,  0.0000000000000000,  
0.3090209960937500,  0.0000000000000000,  -0.0857849121093750,  0.0000000000000000,  
0.0798034667968750,  0.2545471191406250,  0.1844787597656250,  0.0000000000000000,  
0.0898132324218750,  0.0000000000000000,  -0.0104064941406250,  0.0000000000000000,  
0.3312988281250000,  0.1414794921875000,  0.1691894531250000,  -0.3450927734375000,  
0.0105590820312500,  0.0057678222656250,  0.0419311523437500,  0.0324707031250000,  

},
{
0.0000000000000000,  -0.5397949218750000,  0.4343566894531250,  0.2229003906250000,  
0.1210021972656250,  0.0455627441406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1192321777343750,  -0.0671386718750000,  
0.0000000000000000,  0.0000000000000000,  0.0361328125000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1225280761718750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.5415954589843750,  
0.0000000000000000,  0.0000000000000000,  -0.1486206054687500,  0.0000000000000000,  
0.3210754394531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
-0.0366516113281250,  -0.2205505371093750,  -0.2565002441406250,  0.0000000000000000,  
0.0841674804687500,  0.1419982910156250,  -0.1100158691406250,  -0.1472473144531250,  
-0.1317443847656250,  -0.2439880371093750,  0.0286254882812500,  -0.2283325195312500,  
0.0057983398437500,  0.1476440429687500,  0.0978698730468750,  0.0000000000000000,  
-0.0747375488281250,  -0.2562255859375000,  0.0338439941406250,  -0.3089294433593750,  
-0.0068664550781250,  0.4151306152343750,  0.1624145507812500,  0.1584777832031250,  
0.1982727050781250,  -0.0280761718750000,  0.1357421875000000,  0.0179138183593750,  
-0.0037231445312500,  -0.0470886230468750,  0.1832580566406250,  -0.1315002441406250,  
0.0586242675781250,  0.0968322753906250,  0.2212524414062500,  0.1760864257812500,  
0.0000000000000000,  -0.2559814453125000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  -0.1215515136718750,  0.0000000000000000,  -0.0781860351562500,  
0.6021728515625000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1953125000000000,  0.0000000000000000,  0.0000000000000000,  -0.3546447753906250,  
0.0828552246093750,  0.0000000000000000,  0.0000000000000000,  -0.0505676269531250,  
0.0000000000000000,  0.2043151855468750,  0.0000000000000000,  -0.0847473144531250,  
0.0000000000000000,  -0.3590087890625000,  0.2514953613281250,  0.0000000000000000,  
-0.4263000488281250,  0.0000000000000000,  0.0807800292968750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0713195800781250,  
0.0000000000000000,  0.0000000000000000,  0.0934448242187500,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1119995117187500,  0.0000000000000000,  0.1096191406250000,  -0.2098693847656250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0574340820312500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1798095703125000,  0.0000000000000000,  -0.1545104980468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.3419189453125000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0188903808593750,  0.1875915527343750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2947082519531250,  -0.2541809082031250,  -0.5142517089843750,  0.5509338378906250,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0951538085937500,  
0.0000000000000000,  0.0000000000000000,  0.1668395996093750,  0.0000000000000000,  
-0.2821044921875000,  0.0000000000000000,  -0.0788574218750000,  0.0000000000000000,  
-0.0511169433593750,  0.0000000000000000,  -0.1693725585937500,  0.0239868164062500,  
-0.1653747558593750,  -0.0811767578125000,  0.0000000000000000,  -0.4871826171875000,  
0.4308471679687500,  0.4705505371093750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0314331054687500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0851135253906250,  -0.0356445312500000,  
-0.1595153808593750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.2304382324218750,  0.0000000000000000,  0.2811584472656250,  

},
{
-0.0337219238281250,  -0.0898742675781250,  -0.2282104492187500,  0.0000000000000000,  
-0.0886840820312500,  -0.0165405273437500,  0.0164184570312500,  0.0342712402343750,  
-0.2005310058593750,  0.2835998535156250,  -0.2507019042968750,  -0.1830749511718750,  
-0.1700439453125000,  0.0000000000000000,  -0.0524902343750000,  0.0747680664062500,  
-0.3669738769531250,  -0.1197509765625000,  0.2456970214843750,  0.0879821777343750,  
-0.0674743652343750,  0.0000000000000000,  -0.0953063964843750,  0.0091247558593750,  
-0.1697692871093750,  -0.0794982910156250,  -0.2706298828125000,  -0.0744018554687500,  
-0.0718078613281250,  -0.2123718261718750,  0.0073852539062500,  0.0205993652343750,  
0.0607910156250000,  0.1734008789062500,  0.1296691894531250,  -0.3720703125000000,  
0.1282348632812500,  0.0000000000000000,  -0.2076721191406250,  0.1754760742187500,  

},
{
-0.0016479492187500,  -0.2747497558593750,  0.0000000000000000,  -0.0641784667968750,  
0.0000000000000000,  -0.0081176757812500,  0.2183837890625000,  0.0258178710937500,  
-0.1218261718750000,  0.0000000000000000,  -0.1319580078125000,  -0.1556396484375000,  
0.1936340332031250,  0.0000000000000000,  -0.0494079589843750,  0.0973815917968750,  
0.0000000000000000,  -0.1943359375000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1968383789062500,  0.0499572753906250,  0.0765991210937500,  
0.1460571289062500,  0.2546691894531250,  0.1415405273437500,  0.2164306640625000,  
0.1304626464843750,  -0.1287841796875000,  -0.4989318847656250,  0.1414794921875000,  
0.0000000000000000,  0.0000000000000000,  0.3280029296875000,  0.0000000000000000,  
-0.2528991699218750,  0.0000000000000000,  0.0000000000000000,  0.2325134277343750,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.9314575195312500,  
0.0000000000000000,  0.1989135742187500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0701904296875000,  
0.0000000000000000,  -0.0954895019531250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1596069335937500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.2308959960937500,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0162353515625000,  0.0000000000000000,  -0.2114868164062500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0018005371093750,  0.0000000000000000,  0.2507934570312500,  
0.0000000000000000,  0.0000000000000000,  -0.0510864257812500,  0.0000000000000000,  
0.7395019531250000,  0.0000000000000000,  0.0000000000000000,  -0.0217285156250000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.3108215332031250,  
0.1152954101562500,  -0.0002746582031250,  0.1178588867187500,  0.2335815429687500,  
0.0000000000000000,  0.0000000000000000,  0.4047241210937500,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0640258789062500,  0.0000000000000000,  0.0000000000000000,  0.6044006347656250,  
0.0000000000000000,  0.0000000000000000,  -0.0242614746093750,  0.3111877441406250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.3110351562500000,  0.3361206054687500,  0.0000000000000000,  
0.0507507324218750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0827941894531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.5525512695312500,  0.0000000000000000,  
-0.0932617187500000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0375366210937500,  0.0000000000000000,  0.0000000000000000,  
-0.1481933593750000,  -0.4690856933593750,  0.0000000000000000,  0.2331237792968750,  
0.0000000000000000,  -0.4915771484375000,  -0.2299194335937500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1456909179687500,  0.0000000000000000,  -0.1072387695312500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0591735839843750,  0.0000000000000000,  
0.0000000000000000,  0.1321411132812500,  0.0000000000000000,  0.0000000000000000,  
0.4956054687500000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.2661437988281250,  0.1938781738281250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.2314147949218750,  0.0289611816406250,  0.0000000000000000,  -0.0519104003906250,  
0.1350402832031250,  0.0000000000000000,  0.0000000000000000,  0.2584228515625000,  
0.2218933105468750,  0.0000000000000000,  -0.0305175781250000,  -0.1116638183593750,  
0.0492553710937500,  -0.1553344726562500,  0.1925659179687500,  0.1773376464843750,  
0.0000000000000000,  0.0163269042968750,  -0.4125061035156250,  0.0000000000000000,  
0.0000000000000000,  -0.1052856445312500,  0.0500488281250000,  0.0000000000000000,  
-0.0858764648437500,  0.1254882812500000,  0.0783386230468750,  -0.1887207031250000,  
-0.0155029296875000,  -0.3080444335937500,  0.0000000000000000,  0.0551147460937500,  
-0.1691589355468750,  0.0323791503906250,  0.1389465332031250,  0.0000000000000000,  
0.3927612304687500,  0.1152954101562500,  -0.3249206542968750,  -0.1760864257812500,  

},
{
0.1688537597656250,  0.2828369140625000,  0.0000000000000000,  -0.1774597167968750,  
0.0139160156250000,  0.0000000000000000,  0.0000000000000000,  -0.0947570800781250,  
-0.1614990234375000,  -0.2606201171875000,  -0.0902404785156250,  -0.3503417968750000,  
0.0267639160156250,  -0.0435180664062500,  0.0390319824218750,  -0.1517333984375000,  
-0.1212768554687500,  -0.1753540039062500,  0.0187377929687500,  -0.4882202148437500,  
0.2728576660156250,  -0.0123291015625000,  0.1892700195312500,  0.0000000000000000,  
0.0000000000000000,  -0.0948791503906250,  0.1460876464843750,  0.1042785644531250,  
-0.0535278320312500,  0.0000000000000000,  -0.0987243652343750,  0.1964416503906250,  
-0.2416076660156250,  -0.1355895996093750,  0.1137695312500000,  -0.0221252441406250,  
0.1393127441406250,  0.0000000000000000,  0.0463562011718750,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.4666748046875000,  
0.0000000000000000,  -0.1254882812500000,  0.0966186523437500,  0.0039978027343750,  
-0.6174316406250000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2257385253906250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.4578247070312500,  0.0000000000000000,  -0.2356872558593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1829528808593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1210937500000000,  
0.0000000000000000,  0.1077880859375000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  -0.0307922363281250,  0.0000000000000000,  0.2045288085937500,  
0.0242004394531250,  -0.2179565429687500,  -0.0127868652343750,  -0.2252502441406250,  
-0.1992187500000000,  -0.0307006835937500,  0.3080139160156250,  -0.3248596191406250,  
0.3361816406250000,  -0.0224304199218750,  0.0000000000000000,  0.2410278320312500,  
0.0960693359375000,  -0.0130004882812500,  -0.0150756835937500,  -0.0683898925781250,  
-0.4192810058593750,  -0.2367248535156250,  -0.1171264648437500,  0.0229797363281250,  
0.1381225585937500,  0.0000000000000000,  -0.1923828125000000,  0.0000000000000000,  
0.0000000000000000,  0.1694641113281250,  0.0481872558593750,  0.0810241699218750,  
0.0000000000000000,  -0.0974121093750000,  0.0000000000000000,  0.0000000000000000,  
0.1325988769531250,  0.0815124511718750,  0.2403564453125000,  0.0000000000000000,  

},
{
0.0000000000000000,  0.0881652832031250,  0.0063171386718750,  -0.0073242187500000,  
-0.1232910156250000,  -0.1633911132812500,  0.0000000000000000,  0.3849487304687500,  
0.0000000000000000,  0.1417541503906250,  -0.1145019531250000,  0.4457702636718750,  
-0.1273803710937500,  0.0731506347656250,  -0.0358276367187500,  0.0000000000000000,  
-0.0428161621093750,  -0.0939025878906250,  -0.1998291015625000,  0.0000000000000000,  
-0.3090209960937500,  0.0000000000000000,  0.0857849121093750,  0.0000000000000000,  
-0.0798034667968750,  -0.2545471191406250,  -0.1844787597656250,  0.0000000000000000,  
-0.0898132324218750,  0.0000000000000000,  0.0104064941406250,  0.0000000000000000,  
-0.3312988281250000,  -0.1414794921875000,  -0.1691894531250000,  0.3450927734375000,  
-0.0105590820312500,  -0.0057678222656250,  -0.0419311523437500,  -0.0324707031250000,  

},
{
0.0000000000000000,  0.5397949218750000,  -0.4343566894531250,  -0.2229003906250000,  
-0.1210021972656250,  -0.0455627441406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1192321777343750,  0.0671386718750000,  
0.0000000000000000,  0.0000000000000000,  -0.0361328125000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1225280761718750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.5415954589843750,  
0.0000000000000000,  0.0000000000000000,  0.1486206054687500,  0.0000000000000000,  
-0.3210754394531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0366516113281250,  0.2205505371093750,  0.2565002441406250,  0.0000000000000000,  
-0.0841674804687500,  -0.1419982910156250,  0.1100158691406250,  0.1472473144531250,  
0.1317443847656250,  0.2439880371093750,  -0.0286254882812500,  0.2283325195312500,  
-0.0057983398437500,  -0.1476440429687500,  -0.0978698730468750,  0.0000000000000000,  
0.0747375488281250,  0.2562255859375000,  -0.0338439941406250,  0.3089294433593750,  
0.0068664550781250,  -0.4151306152343750,  -0.1624145507812500,  -0.1584777832031250,  
-0.1982727050781250,  0.0280761718750000,  -0.1357421875000000,  -0.0179138183593750,  
0.0037231445312500,  0.0470886230468750,  -0.1832580566406250,  0.1315002441406250,  
-0.0586242675781250,  -0.0968322753906250,  -0.2212524414062500,  -0.1760864257812500,  
0.0000000000000000,  0.2559814453125000,  0.0000000000000000,  0.0000000000000000,  

},
{
0.0000000000000000,  0.1215515136718750,  0.0000000000000000,  0.0781860351562500,  
-0.6021728515625000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1953125000000000,  0.0000000000000000,  0.0000000000000000,  0.3546447753906250,  
-0.0828552246093750,  0.0000000000000000,  0.0000000000000000,  0.0505676269531250,  
0.0000000000000000,  -0.2043151855468750,  0.0000000000000000,  0.0847473144531250,  
0.0000000000000000,  0.3590087890625000,  -0.2514953613281250,  0.0000000000000000,  
0.4263000488281250,  0.0000000000000000,  -0.0807800292968750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0713195800781250,  
0.0000000000000000,  0.0000000000000000,  -0.0934448242187500,  0.0000000000000000,  

},
  },
};
