
/*

This software module was originally developed by

    Kazuyuki Iijima (Sony Corporation)

    and edited by 

    Yuji Maeda (Sony Corporation)

    and

    Christian Mittendorf (Robert Bosch GmbH Germany)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/



static CbCELPL0 cb =
{
  /*****************************************************************************
   *
   * modified celp gain-table
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^2 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^2)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
/*
  {
    16.2500000,
    41.0000000,
    191.0000000,
    81.2500000,
    814.2500000,
    607.0000000,
    376.2500000,
    517.2500000,
    4692.0000000,
    2850.5000000,
    1784.2500000,
    2009.2500000,
    1033.0000000,
    1171.7500000,
    1573.5000000,
    1432.2500000
  },
*/

  {
    16.2500000,
    41.0000000,
    81.2500000,
    191.0000000,
    376.2500000,
    517.2500000,
    607.0000000,
    814.2500000,
    1033.0000000,
    1171.7500000,
    1432.2500000,
    1573.5000000,
    1784.2500000,
    2009.2500000,
    2850.5000000,
    4692.0000000
  },

  {
    /*****************************************************************************
     *
     * modified base layer - table
     *
     * 16 bits signed; scale_factor 1; 
     * quantized with: fixed_value = (original_value * 2^15 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^15)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0496826171875000,  
0.0000000000000000,  -0.2944335937500000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0441284179687500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0270385742187500,  
0.0000000000000000,  -0.1791076660156250,  0.1657409667968750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1658325195312500,  0.0129089355468750,  0.0000000000000000,  0.0000000000000000,  
-0.3220520019531250,  0.0000000000000000,  0.0000000000000000,  -0.0341186523437500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0778198242187500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0007934570312500,  0.0000000000000000,  
0.0106811523437500,  0.0000000000000000,  0.0000000000000000,  -0.0103454589843750,  
0.1671752929687500,  -0.0165100097656250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0631713867187500,  -0.4985046386718750,  0.2789001464843750,  0.0000000000000000,  
0.0797424316406250,  -0.4874267578125000,  0.0000000000000000,  0.0000000000000000,  
0.2918395996093750,  0.0000000000000000,  0.1101684570312500,  0.0000000000000000,  
-0.0035400390625000,  -0.1001586914062500,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0450134277343750,  
0.0643005371093750,  0.0000000000000000,  0.0230407714843750,  0.0000000000000000,  
0.0000000000000000,  -0.1206970214843750,  -0.0798034667968750,  -0.0294494628906250,  
-0.0124206542968750,  -0.0216064453125000,  0.0556945800781250,  0.0000000000000000,  
-0.1784362792968750,  0.1057434082031250,  0.0128173828125000,  -0.2130432128906250,  
0.0000000000000000,  0.0000000000000000,  -0.0704345703125000,  0.0697326660156250,  
-0.0899963378906250,  0.0000000000000000,  0.0000000000000000,  0.1963500976562500,  
-0.2209777832031250,  -0.1159057617187500,  0.1088867187500000,  0.0359802246093750,  
0.0000000000000000,  0.1508789062500000,  0.0000000000000000,  0.0000000000000000,  
-0.1520080566406250,  0.1132812500000000,  -0.0813903808593750,  -0.1967468261718750,  
0.1621093750000000,  -0.3013000488281250,  0.0000000000000000,  0.0983276367187500,  
-0.1961059570312500,  0.0000000000000000,  0.0204162597656250,  0.1586608886718750,  
0.0000000000000000,  0.0000000000000000,  0.0125732421875000,  -0.0660095214843750,  
0.0810852050781250,  0.0000000000000000,  0.0000000000000000,  0.0487365722656250,  
0.0673522949218750,  0.0662841796875000,  -0.2226867675781250,  0.0000000000000000,  
0.1666870117187500,  -0.0296325683593750,  -0.1062927246093750,  0.0228576660156250,  
0.0000000000000000,  0.0624694824218750,  -0.0931701660156250,  0.0000000000000000,  
0.0000000000000000,  -0.3496704101562500,  -0.0909729003906250,  0.0000000000000000,  
-0.1378479003906250,  0.1181335449218750,  -0.0284118652343750,  0.1432189941406250,  
0.3074645996093750,  0.0685119628906250,  -0.0833129882812500,  0.1909179687500000
},
{
0.0000000000000000,  -0.1130065917968750,  0.1259765625000000,  0.0206298828125000,  
0.0000000000000000,  -0.0266723632812500,  0.1428222656250000,  -0.1467285156250000,  
0.0603637695312500,  -0.2733154296875000,  0.0367736816406250,  0.2491149902343750,  
0.0000000000000000,  0.0000000000000000,  -0.0142211914062500,  -0.1100769042968750,  
0.2214355468750000,  0.0000000000000000,  0.0000000000000000,  -0.0188293457031250,  
0.0000000000000000,  0.0000000000000000,  0.0697937011718750,  0.0000000000000000,  
0.0459594726562500,  -0.0531616210937500,  0.0585632324218750,  0.0000000000000000,  
0.0300903320312500,  0.1636962890625000,  -0.1058349609375000,  0.0000000000000000,  
0.0150451660156250,  0.1465759277343750,  0.0000000000000000,  0.0313720703125000,  
0.0167846679687500,  0.0838012695312500,  0.0000000000000000,  0.0000000000000000,  
0.0035400390625000,  0.1996459960937500,  0.0000000000000000,  0.0146484375000000,  
0.0558166503906250,  -0.1047668457031250,  0.0304870605468750,  -0.3253784179687500,  
-0.2486572265625000,  -0.0300598144531250,  -0.0942077636718750,  0.1268615722656250,  
-0.0094299316406250,  0.0987243652343750,  -0.3122253417968750,  0.1635131835937500,  
-0.1252441406250000,  -0.0963134765625000,  0.0000000000000000,  0.1367492675781250,  
-0.0672302246093750,  0.0000000000000000,  0.1531677246093750,  0.0000000000000000,  
0.2123413085937500,  0.0000000000000000,  0.0000000000000000,  -0.1616516113281250,  
0.0000000000000000,  -0.0169982910156250,  -0.1339416503906250,  0.0000000000000000,  
0.1817626953125000,  0.0190124511718750,  -0.1109313964843750,  -0.1201782226562500,  
0.0104980468750000,  -0.0685119628906250,  0.1741943359375000,  0.0595092773437500
},
{
0.0000000000000000,  0.0000000000000000,  0.0327453613281250,  -0.0742797851562500,  
-0.2077636718750000,  0.0621032714843750,  0.0000000000000000,  -0.1198730468750000,  
0.0000000000000000,  -0.0766296386718750,  -0.0682983398437500,  0.0952758789062500,  
0.1432495117187500,  -0.3714294433593750,  0.0000000000000000,  0.0000000000000000,  
-0.0401611328125000,  0.0000000000000000,  0.0168457031250000,  0.0000000000000000,  
-0.0534667968750000,  0.0810241699218750,  0.0211486816406250,  -0.0289306640625000,  
0.1712646484375000,  0.1179199218750000,  -0.0059814453125000,  0.0603332519531250,  
0.0000000000000000,  0.0975646972656250,  -0.0692443847656250,  0.0236816406250000,  
-0.0673217773437500,  0.0184631347656250,  -0.0274963378906250,  -0.0609436035156250,  
-0.0425720214843750,  0.0153198242187500,  -0.2906188964843750,  0.0808410644531250,  
0.1203308105468750,  -0.0663146972656250,  -0.0197448730468750,  0.0099182128906250,  
-0.0971984863281250,  -0.0462341308593750,  0.0060729980468750,  -0.3410034179687500,  
-0.0422363281250000,  -0.2033081054687500,  -0.0482788085937500,  0.0000000000000000,  
0.0000000000000000,  -0.0928344726562500,  0.1301574707031250,  0.1326293945312500,  
0.2268676757812500,  0.1526184082031250,  -0.0240783691406250,  0.0512390136718750,  
0.0417785644531250,  0.0199890136718750,  -0.1842651367187500,  0.0669555664062500,  
-0.0506896972656250,  0.0000000000000000,  0.1550292968750000,  0.1044921875000000,  
-0.0589599609375000,  0.0029907226562500,  -0.0896606445312500,  0.3612060546875000,  
0.1961364746093750,  0.0000000000000000,  0.0000000000000000,  0.0280151367187500,  
0.0000000000000000,  -0.0360717773437500,  0.0000000000000000,  -0.0516662597656250
},
{
-0.1413574218750000,  0.0000000000000000,  0.0102539062500000,  -0.0847778320312500,  
-0.1496887207031250,  -0.1135253906250000,  0.0017395019531250,  0.0059509277343750,  
0.1977233886718750,  0.1418151855468750,  0.1839599609375000,  -0.1191406250000000,  
0.1057739257812500,  0.0000000000000000,  0.0963134765625000,  -0.0574340820312500,  
0.0381164550781250,  -0.0767822265625000,  -0.0032348632812500,  -0.0234985351562500,  
0.0742797851562500,  -0.2411499023437500,  0.2185363769531250,  -0.0595703125000000,  
-0.2491760253906250,  0.0000000000000000,  -0.2307128906250000,  0.0000000000000000,  
0.0000000000000000,  -0.1662902832031250,  0.0000000000000000,  0.0809326171875000,  
0.0000000000000000,  0.0212402343750000,  0.0000000000000000,  0.0000000000000000,  
-0.0619506835937500,  -0.0347900390625000,  0.1238098144531250,  -0.0704345703125000,  
0.0548095703125000,  -0.1223144531250000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0532836914062500,  0.0000000000000000,  0.0415344238281250,  
0.0000000000000000,  0.0439453125000000,  -0.2519226074218750,  0.0796508789062500,  
-0.1629333496093750,  -0.0141296386718750,  -0.0756225585937500,  -0.1310424804687500,  
-0.1164550781250000,  -0.1257629394531250,  0.0000000000000000,  -0.1996459960937500,  
0.0000000000000000,  -0.1323852539062500,  -0.0175781250000000,  0.0000000000000000,  
0.0000000000000000,  0.2268371582031250,  0.0000000000000000,  0.1541442871093750,  
-0.0474243164062500,  -0.2461547851562500,  0.2409362792968750,  -0.0834960937500000,  
0.2156677246093750,  0.0088195800781250,  0.0913085937500000,  0.0000000000000000,  
0.0000000000000000,  0.1385803222656250,  0.0003356933593750,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0744628906250000,  0.0000000000000000,  
0.0836486816406250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1264038085937500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1628112792968750,  0.0000000000000000,  0.3162841796875000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1559448242187500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.4265441894531250,  
-0.0027465820312500,  -0.0667419433593750,  0.0866699218750000,  0.0000000000000000,  
0.3223876953125000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1327514648437500,  -0.0968017578125000,  0.0583190917968750,  
0.0864257812500000,  0.0000000000000000,  0.0000000000000000,  -0.1399841308593750,  
0.0000000000000000,  0.0761718750000000,  -0.1229553222656250,  -0.0094299316406250,  
0.1069030761718750,  0.2070617675781250,  0.0000000000000000,  0.0206298828125000,  
0.0071716308593750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.3469238281250000,  0.0000000000000000,  
-0.2492065429687500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0309143066406250,  -0.1531066894531250,  0.0000000000000000,  
0.0043640136718750,  0.0000000000000000,  0.0087280273437500,  -0.3212280273437500,  
0.0000000000000000,  0.0000000000000000,  0.2817687988281250,  0.0000000000000000
},
{
0.0854797363281250,  0.1010742187500000,  0.0000000000000000,  0.1079406738281250,  
-0.0883483886718750,  0.0992126464843750,  -0.0885314941406250,  -0.0371398925781250,  
0.0000000000000000,  -0.1012268066406250,  -0.0757141113281250,  -0.0676269531250000,  
-0.0191040039062500,  0.0319213867187500,  0.0220642089843750,  -0.0156860351562500,  
0.0000000000000000,  -0.0354003906250000,  0.0000000000000000,  0.2140502929687500,  
0.0000000000000000,  -0.1569824218750000,  -0.1673278808593750,  0.0904846191406250,  
0.1525573730468750,  -0.1159362792968750,  -0.2019042968750000,  -0.1455993652343750,  
-0.1316833496093750,  -0.1017150878906250,  0.2379455566406250,  -0.0148925781250000,  
0.0000000000000000,  0.1173400878906250,  0.0509643554687500,  0.0753173828125000,  
0.1687622070312500,  0.2376403808593750,  0.0000000000000000,  -0.0603637695312500,  
0.1952209472656250,  -0.0664062500000000,  0.0000000000000000,  0.0159301757812500,  
-0.1114501953125000,  0.0198974609375000,  -0.0527343750000000,  0.0651550292968750,  
-0.1091918945312500,  0.0000000000000000,  -0.0021667480468750,  0.0000000000000000,  
-0.3459167480468750,  0.0392456054687500,  -0.2726135253906250,  -0.0888366699218750,  
-0.0115051269531250,  0.0258483886718750,  0.0000000000000000,  -0.0352478027343750,  
0.1065368652343750,  -0.0319824218750000,  -0.0475769042968750,  0.1701354980468750,  
0.1323242187500000,  0.2491455078125000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0177307128906250,  0.0000000000000000,  -0.0233154296875000,  
0.0000000000000000,  -0.0113525390625000,  -0.1217041015625000,  -0.1143798828125000,  
0.0000000000000000,  0.2871704101562500,  0.0000000000000000,  -0.0711364746093750
},
{
-0.1799316406250000,  0.0641784667968750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0343322753906250,  0.0000000000000000,  0.0365295410156250,  0.0000000000000000,  
0.0000000000000000,  0.0445251464843750,  0.0000000000000000,  0.2170715332031250,  
-0.1505126953125000,  0.0000000000000000,  0.1028747558593750,  0.0560607910156250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0079040527343750,  
0.0000000000000000,  -0.5242309570312500,  0.0000000000000000,  0.0601501464843750,  
0.3502502441406250,  0.0000000000000000,  -0.0111999511718750,  -0.2929382324218750,  
0.0000000000000000,  0.1187133789062500,  0.0921630859375000,  0.0000000000000000,  
0.0000000000000000,  -0.1197204589843750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0804138183593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1607055664062500,  -0.0688781738281250,  
0.0000000000000000,  0.0805358886718750,  0.0000000000000000,  0.2094116210937500,  
0.0000000000000000,  -0.0886535644531250,  0.0258178710937500,  0.0000000000000000,  
0.0000000000000000,  0.2348632812500000,  -0.2011108398437500,  -0.0089416503906250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.2477111816406250,  
0.0000000000000000,  0.2963867187500000,  0.1034545898437500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
-0.0325012207031250,  -0.1602783203125000,  -0.0633239746093750,  0.1124877929687500,  
0.0928344726562500,  -0.0787353515625000,  0.0169677734375000,  -0.1665954589843750,  
0.1504821777343750,  -0.0578308105468750,  -0.1103515625000000,  0.0049438476562500,  
-0.0119628906250000,  0.1531372070312500,  -0.0491333007812500,  -0.0030822753906250,  
0.0851745605468750,  0.2481689453125000,  0.0011596679687500,  -0.1272583007812500,  
0.2011108398437500,  0.1812438964843750,  0.0000000000000000,  0.1507263183593750,  
0.0000000000000000,  0.0790100097656250,  0.1156005859375000,  -0.0060119628906250,  
0.0000000000000000,  0.1571655273437500,  0.0889587402343750,  -0.1495971679687500,  
0.0000000000000000,  -0.0595703125000000,  -0.1932373046875000,  -0.1981811523437500,  
-0.1408081054687500,  0.1547241210937500,  0.0000000000000000,  0.1903686523437500,  
-0.0417785644531250,  0.0065002441406250,  -0.0918579101562500,  -0.0176696777343750,  
0.0227355957031250,  0.0756835937500000,  0.0000000000000000,  0.0342102050781250,  
-0.2475585937500000,  0.0000000000000000,  0.0000000000000000,  -0.2177124023437500,  
-0.1518249511718750,  0.0000000000000000,  0.0000000000000000,  0.1622924804687500,  
0.0407714843750000,  0.0000000000000000,  -0.0157470703125000,  -0.1531066894531250,  
0.0000000000000000,  0.0000000000000000,  0.2582397460937500,  0.0000000000000000,  
0.0000000000000000,  0.0172119140625000,  0.0000000000000000,  0.1401367187500000,  
-0.2834472656250000,  0.0000000000000000,  -0.0438842773437500,  0.0543212890625000,  
0.0430297851562500,  0.0000000000000000,  -0.0368652343750000,  -0.0964355468750000,  
0.0327148437500000,  0.0871887207031250,  0.1620178222656250,  -0.1140747070312500
},
{
0.0259094238281250,  0.0000000000000000,  0.0437927246093750,  -0.0168457031250000,  
0.0000000000000000,  -0.2573852539062500,  0.0512695312500000,  0.0337524414062500,  
0.1148681640625000,  -0.0603332519531250,  0.0029907226562500,  0.0000000000000000,  
-0.1816711425781250,  0.0000000000000000,  0.4531555175781250,  0.1235046386718750,  
-0.0969238281250000,  0.0000000000000000,  0.0039672851562500,  0.0000000000000000,  
0.1175842285156250,  -0.1003723144531250,  -0.1736755371093750,  0.1730346679687500,  
0.0552062988281250,  -0.0385742187500000,  -0.0100402832031250,  0.0000000000000000,  
-0.0520629882812500,  0.0000000000000000,  -0.0260009765625000,  -0.3400878906250000,  
0.1066589355468750,  -0.1074829101562500,  -0.0892333984375000,  0.1408386230468750,  
-0.0688476562500000,  0.0292968750000000,  -0.0215148925781250,  -0.0860290527343750,  
0.0081176757812500,  -0.1030578613281250,  -0.0615234375000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0410156250000000,  0.0727233886718750,  
0.2294311523437500,  -0.0296325683593750,  0.0492248535156250,  0.0521850585937500,  
-0.0954284667968750,  -0.0747985839843750,  -0.0633850097656250,  0.0913085937500000,  
-0.3093566894531250,  0.0000000000000000,  -0.0080871582031250,  0.0634460449218750,  
0.0000000000000000,  -0.2561340332031250,  0.0000000000000000,  0.0637512207031250,  
0.0136108398437500,  -0.0101928710937500,  0.0000000000000000,  -0.0797424316406250,  
0.0000000000000000,  -0.0046691894531250,  0.1019897460937500,  0.0000000000000000,  
0.1495361328125000,  -0.0591125488281250,  -0.2225952148437500,  0.0509033203125000,  
0.0000000000000000,  0.0602111816406250,  0.0000000000000000,  -0.0071716308593750
},
{
0.0000000000000000,  -0.0932006835937500,  0.0369262695312500,  0.0016784667968750,  
0.0000000000000000,  0.3087768554687500,  0.1166381835937500,  -0.0355224609375000,  
0.1428833007812500,  0.0453186035156250,  -0.0939025878906250,  0.0572814941406250,  
-0.1816101074218750,  0.0000000000000000,  -0.1034240722656250,  -0.1106262207031250,  
0.0657958984375000,  0.0000000000000000,  -0.1072082519531250,  0.0000000000000000,  
-0.1369934082031250,  0.1587829589843750,  0.1341552734375000,  0.0000000000000000,  
-0.0502624511718750,  0.0000000000000000,  -0.0135192871093750,  -0.0550842285156250,  
0.0000000000000000,  0.1469116210937500,  0.2415161132812500,  -0.0212402343750000,  
0.0000000000000000,  -0.0296936035156250,  0.0000000000000000,  0.0000000000000000,  
-0.0876770019531250,  0.1019592285156250,  0.0885009765625000,  0.0000000000000000,  
0.1325378417968750,  -0.1549072265625000,  0.0357055664062500,  0.0194702148437500,  
-0.0797119140625000,  -0.0326843261718750,  0.0000000000000000,  0.0000000000000000,  
-0.0729980468750000,  0.0000000000000000,  0.1193847656250000,  -0.2339172363281250,  
0.0789184570312500,  -0.0098266601562500,  -0.0821228027343750,  -0.0061645507812500,  
-0.3167724609375000,  -0.2840270996093750,  0.1418762207031250,  0.1161499023437500,  
-0.0322570800781250,  0.0388793945312500,  0.0530700683593750,  0.0000000000000000,  
-0.0180664062500000,  0.2197875976562500,  -0.0465087890625000,  0.1745300292968750,  
0.0000000000000000,  -0.0240783691406250,  0.1811828613281250,  0.2265930175781250,  
0.1616821289062500,  -0.0912780761718750,  0.0000000000000000,  0.0506286621093750,  
-0.1477355957031250,  0.0086364746093750,  0.1026916503906250,  -0.0708618164062500
},
{
0.0000000000000000,  0.0000000000000000,  -0.0346069335937500,  0.0000000000000000,  
0.1072998046875000,  0.0000000000000000,  -0.1255798339843750,  0.1398925781250000,  
0.0320129394531250,  -0.0223083496093750,  0.0000000000000000,  0.0000000000000000,  
0.0119628906250000,  -0.1647033691406250,  0.1003417968750000,  0.0000000000000000,  
0.1392822265625000,  -0.3493652343750000,  0.0000000000000000,  0.0370483398437500,  
0.0000000000000000,  -0.0748596191406250,  -0.0264587402343750,  0.0000000000000000,  
0.0654602050781250,  -0.0310668945312500,  0.0000000000000000,  0.0397644042968750,  
0.0000000000000000,  0.0367736816406250,  -0.0591430664062500,  -0.0527648925781250,  
0.0113220214843750,  0.0000000000000000,  0.0000000000000000,  0.0605468750000000,  
0.0080871582031250,  0.0143127441406250,  -0.1399841308593750,  -0.1123962402343750,  
-0.1248168945312500,  0.0000000000000000,  -0.0239868164062500,  0.1757507324218750,  
-0.1065979003906250,  0.2338562011718750,  -0.0209045410156250,  0.0613708496093750,  
-0.0483703613281250,  0.0000000000000000,  0.1589355468750000,  0.1430664062500000,  
0.0709228515625000,  -0.0758056640625000,  -0.0299987792968750,  0.0000000000000000,  
-0.0043029785156250,  -0.2903747558593750,  -0.0853271484375000,  0.1387939453125000,  
0.1037597656250000,  -0.1370239257812500,  0.0683898925781250,  -0.0052795410156250,  
0.0097961425781250,  0.1730346679687500,  -0.0053710937500000,  -0.0147094726562500,  
0.3054199218750000,  -0.0396728515625000,  0.1122741699218750,  0.1734924316406250,  
0.2089233398437500,  0.1918029785156250,  -0.2239685058593750,  -0.0018310546875000,  
0.1479492187500000,  -0.0351562500000000,  0.0574645996093750,  -0.2572021484375000
},
{
0.1541137695312500,  -0.0717773437500000,  0.0000000000000000,  -0.0789489746093750,  
-0.0010070800781250,  -0.1705017089843750,  -0.2387390136718750,  0.0942687988281250,  
0.0083312988281250,  0.0470581054687500,  -0.0419311523437500,  0.0000000000000000,  
0.0194702148437500,  0.0639038085937500,  0.0738830566406250,  -0.0444030761718750,  
0.2045593261718750,  0.1248474121093750,  0.1248168945312500,  -0.2107238769531250,  
0.0950012207031250,  0.0000000000000000,  -0.0581970214843750,  -0.0414428710937500,  
0.0000000000000000,  -0.0170288085937500,  0.0000000000000000,  0.0000000000000000,  
0.0053710937500000,  0.3947448730468750,  -0.0616149902343750,  -0.1294860839843750,  
0.0000000000000000,  0.0000000000000000,  0.0056457519531250,  -0.0735168457031250,  
-0.0125732421875000,  0.0000000000000000,  -0.0915222167968750,  0.0165100097656250,  
0.0000000000000000,  -0.1382446289062500,  0.0572509765625000,  0.0000000000000000,  
0.0000000000000000,  -0.2709655761718750,  -0.0263061523437500,  -0.0545959472656250,  
0.2909851074218750,  -0.0105895996093750,  -0.1304626464843750,  0.0986022949218750,  
0.0000000000000000,  0.0057678222656250,  -0.0934143066406250,  -0.1051330566406250,  
-0.0609741210937500,  -0.0238647460937500,  0.0395812988281250,  0.0000000000000000,  
0.1136169433593750,  -0.0033264160156250,  0.0824890136718750,  -0.0425109863281250,  
-0.1133728027343750,  0.1153869628906250,  -0.0187377929687500,  -0.2017211914062500,  
0.0000000000000000,  0.0237731933593750,  0.0968017578125000,  -0.1911010742187500,  
-0.0570373535156250,  0.0568847656250000,  -0.1136169433593750,  0.2980041503906250,  
0.0000000000000000,  0.0813903808593750,  0.0941162109375000,  0.1894836425781250
},
{
0.0000000000000000,  0.0000000000000000,  -0.1902160644531250,  0.0000000000000000,  
0.1308288574218750,  0.1643981933593750,  0.0719604492187500,  0.0435485839843750,  
-0.0977172851562500,  0.1361694335937500,  -0.0349731445312500,  -0.0027770996093750,  
0.0133056640625000,  0.1008605957031250,  -0.0208740234375000,  0.1473388671875000,  
0.1177673339843750,  0.1206665039062500,  0.3084716796875000,  -0.0050964355468750,  
-0.2295532226562500,  0.0251464843750000,  -0.1903991699218750,  -0.0555419921875000,  
0.0000000000000000,  0.0727233886718750,  0.1097106933593750,  0.0043029785156250,  
-0.1696777343750000,  0.0212707519531250,  -0.1813049316406250,  -0.0979003906250000,  
-0.1094360351562500,  -0.0817565917968750,  0.1054992675781250,  0.0625610351562500,  
0.0000000000000000,  -0.1906127929687500,  -0.1638793945312500,  -0.0272216796875000,  
0.0000000000000000,  0.1944580078125000,  -0.0663146972656250,  0.1296081542968750,  
0.0000000000000000,  -0.1119995117187500,  0.1488952636718750,  0.0453491210937500,  
0.0136413574218750,  -0.0032653808593750,  -0.0991821289062500,  0.0774536132812500,  
0.0308227539062500,  -0.1459655761718750,  -0.0398559570312500,  -0.0879516601562500,  
-0.0431213378906250,  0.0000000000000000,  0.0789489746093750,  0.0315246582031250,  
0.2088623046875000,  -0.0014038085937500,  0.1322021484375000,  0.0000000000000000,  
0.0000000000000000,  -0.0576782226562500,  0.0654296875000000,  0.1890563964843750,  
-0.0814819335937500,  0.1391296386718750,  -0.0572509765625000,  0.0000000000000000,  
0.0863037109375000,  -0.2783508300781250,  0.0000000000000000,  -0.0629882812500000,  
0.0000000000000000,  -0.2671203613281250,  -0.0125732421875000,  -0.0348815917968750
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.2827758789062500,  
0.0000000000000000,  -0.1308898925781250,  0.0000000000000000,  0.0000000000000000,  
0.4769897460937500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1079101562500000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0318298339843750,  0.0000000000000000,  0.0000000000000000,  
-0.0591430664062500,  -0.1050109863281250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0401306152343750,  0.1065673828125000,  
0.1963195800781250,  0.3825378417968750,  -0.4754028320312500,  0.0000000000000000,  
0.1185607910156250,  0.0000000000000000,  0.0000000000000000,  0.1897888183593750,  
-0.1654968261718750,  0.1061096191406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0658264160156250,  0.0000000000000000,  0.0000000000000000,  
-0.1636352539062500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0417785644531250,  0.0000000000000000,  0.1519775390625000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0300903320312500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1986083984375000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1884460449218750,  0.0617065429687500,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0305175781250000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1255798339843750,  -0.0125427246093750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1444091796875000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0168457031250000,  -0.0520324707031250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0760803222656250,  0.1503601074218750,  -0.0339965820312500,  
0.0401916503906250,  0.0000000000000000,  0.2156066894531250,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1465148925781250,  0.0000000000000000,  
0.0000000000000000,  -0.1666564941406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.6423034667968750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.3960876464843750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0307922363281250,  0.0000000000000000,  0.0000000000000000,  
-0.1321716308593750,  0.0000000000000000,  0.0000000000000000,  0.1377258300781250,  
0.0000000000000000,  0.0000000000000000,  0.1829833984375000,  0.0000000000000000,  
0.0000000000000000,  -0.0232849121093750,  0.0000000000000000,  0.1828918457031250,  
-0.0393981933593750,  0.0000000000000000,  -0.2142944335937500,  0.2501220703125000,  
0.0000000000000000,  0.1618041992187500,  0.0000000000000000,  -0.1258544921875000,  
-0.0778808593750000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1642761230468750,  -0.2254943847656250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.4199218750000000,  
0.0000000000000000,  0.0000000000000000,  -0.1119689941406250,  0.0000000000000000,  
0.0000000000000000,  -0.0501403808593750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0908508300781250,  0.0000000000000000,  0.1234130859375000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1947937011718750,  0.4165039062500000,  0.0000000000000000,  
-0.1975097656250000,  0.0000000000000000,  0.3974609375000000,  0.1255493164062500,  
0.0000000000000000,  0.0000000000000000,  -0.0317993164062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0972595214843750,  0.1632995605468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2727050781250000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1521301269531250,  0.0000000000000000,  
0.0592956542968750,  -0.2478332519531250,  0.1280212402343750,  0.0000000000000000,  
0.0000000000000000,  -0.2204589843750000,  0.0000000000000000,  -0.0256042480468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0073547363281250,  -0.0312500000000000,  0.1298522949218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  -0.0107421875000000,  -0.2812500000000000,  -0.0765686035156250,  
0.0000000000000000,  0.0351257324218750,  0.0000000000000000,  0.0356445312500000,  
0.0000000000000000,  0.2005004882812500,  -0.0253295898437500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0887451171875000,  0.2464599609375000,  
0.0000000000000000,  0.1774902343750000,  0.1569213867187500,  0.0000000000000000,  
0.2246093750000000,  -0.0217590332031250,  -0.2372741699218750,  -0.0084228515625000,  
0.0012817382812500,  -0.0270080566406250,  0.0000000000000000,  0.1945190429687500,  
0.1217041015625000,  0.0000000000000000,  -0.0446472167968750,  0.0945739746093750,  
0.0000000000000000,  0.0344543457031250,  -0.0090332031250000,  0.0507507324218750,  
-0.2881469726562500,  -0.0419311523437500,  0.0120544433593750,  -0.0849304199218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2062072753906250,  -0.0131835937500000,  -0.0839843750000000,  0.0081787109375000,  
0.0744323730468750,  0.0008239746093750,  0.0248413085937500,  0.0000000000000000,  
0.2503051757812500,  0.0426635742187500,  0.1091003417968750,  0.1759338378906250,  
0.0000000000000000,  0.1806030273437500,  -0.1318359375000000,  0.1579895019531250,  
-0.0104675292968750,  -0.1089477539062500,  0.0000000000000000,  0.0000000000000000,  
-0.0110473632812500,  0.0000000000000000,  -0.0993652343750000,  0.3004150390625000,  
-0.1174316406250000,  0.0000000000000000,  -0.1823425292968750,  0.0238342285156250,  
-0.1925048828125000,  0.1644592285156250,  -0.0172119140625000,  -0.0650634765625000,  
0.0000000000000000,  0.0393371582031250,  0.0000000000000000,  0.1047973632812500
},
{
0.3504943847656250,  0.1432189941406250,  -0.0446777343750000,  0.0000000000000000,  
0.0356750488281250,  -0.0113830566406250,  -0.0810852050781250,  -0.0393066406250000,  
-0.0975646972656250,  0.0000000000000000,  0.0908203125000000,  0.0249938964843750,  
-0.1562805175781250,  0.0000000000000000,  0.0088500976562500,  -0.1851196289062500,  
0.1071777343750000,  0.0000000000000000,  -0.1401367187500000,  -0.1122436523437500,  
-0.1531066894531250,  0.2405700683593750,  0.0777893066406250,  -0.0685119628906250,  
0.0000000000000000,  0.0000000000000000,  -0.0873107910156250,  0.0000000000000000,  
0.0000000000000000,  0.1210937500000000,  0.0000000000000000,  -0.0032043457031250,  
0.2493591308593750,  0.0000000000000000,  -0.0055541992187500,  -0.1743164062500000,  
-0.0528564453125000,  -0.0877075195312500,  -0.0015563964843750,  -0.2397155761718750,  
0.1626586914062500,  -0.1221313476562500,  0.0000000000000000,  0.0744018554687500,  
0.0636291503906250,  0.0039062500000000,  -0.2432556152343750,  0.0197448730468750,  
0.0462951660156250,  -0.0329284667968750,  -0.0836791992187500,  0.2604980468750000,  
0.1513366699218750,  -0.0003356933593750,  0.0107116699218750,  0.0684509277343750,  
0.0095825195312500,  0.0976867675781250,  0.0000000000000000,  -0.1468505859375000,  
0.1484375000000000,  -0.0932312011718750,  -0.0211486816406250,  -0.0082702636718750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1912231445312500,  
-0.0216369628906250,  0.1444091796875000,  -0.1869812011718750,  0.0225830078125000,  
-0.1005554199218750,  0.0168762207031250,  0.0344848632812500,  0.0000000000000000,  
0.1265258789062500,  -0.1885986328125000,  0.0653381347656250,  0.0988464355468750
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1943664550781250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2472839355468750,  -0.3882446289062500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1639404296875000,  
0.0000000000000000,  0.0000000000000000,  0.1376037597656250,  0.0000000000000000,  
0.2537231445312500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2099914550781250,  0.0000000000000000,  -0.0728149414062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0300598144531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0357055664062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.4316406250000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1035766601562500,  0.1644592285156250,  
0.3491516113281250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1980590820312500,  
0.0000000000000000,  0.0000000000000000,  -0.3410339355468750,  -0.2253417968750000,  
-0.0288085937500000,  -0.0015563964843750,  0.0000000000000000,  0.1674499511718750,  
-0.0859069824218750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.2237243652343750,  -0.0009155273437500,  
0.0235595703125000,  -0.1020812988281250,  -0.0001220703125000,  0.1624450683593750,  
0.0000000000000000,  0.0000000000000000,  -0.1167297363281250,  0.0262756347656250,  
0.1492919921875000,  -0.0928039550781250,  0.0000000000000000,  0.0000000000000000,  
-0.1768493652343750,  0.1221923828125000,  0.0861206054687500,  -0.1103515625000000,  
-0.0950012207031250,  -0.0561218261718750,  0.0000000000000000,  -0.1023254394531250,  
-0.0647888183593750,  0.1358947753906250,  0.0799255371093750,  -0.0721740722656250,  
0.0000000000000000,  -0.0174865722656250,  0.0000000000000000,  0.2692565917968750,  
0.1296997070312500,  0.1262512207031250,  0.3501281738281250,  0.1721801757812500,  
0.0000000000000000,  0.1383361816406250,  -0.0526428222656250,  0.0000000000000000,  
0.0000000000000000,  0.0440673828125000,  0.0240783691406250,  0.0596618652343750,  
0.0000000000000000,  -0.0286560058593750,  0.0803833007812500,  0.1778259277343750,  
-0.0793762207031250,  0.0000000000000000,  0.1172790527343750,  0.1042785644531250,  
-0.1354675292968750,  0.2549743652343750,  0.0000000000000000,  -0.0556030273437500,  
0.0003967285156250,  -0.0588378906250000,  0.0768127441406250,  0.2038574218750000,  
-0.0521240234375000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0701904296875000,  -0.0308532714843750,  0.0000000000000000,  -0.1104736328125000,  
0.1854553222656250,  -0.2934570312500000,  0.0000000000000000,  -0.0680541992187500,  
0.0000000000000000,  0.0874328613281250,  0.0545349121093750,  0.0000000000000000,  
-0.0785827636718750,  -0.0144958496093750,  -0.2933654785156250,  0.0513610839843750
},
{
-0.1943969726562500,  0.0928955078125000,  -0.0492553710937500,  0.1534118652343750,  
0.0000000000000000,  0.0000000000000000,  -0.0057373046875000,  -0.1223144531250000,  
0.1419677734375000,  0.0545043945312500,  0.0000000000000000,  0.0000000000000000,  
-0.1032409667968750,  -0.0024414062500000,  -0.0121154785156250,  0.0235900878906250,  
0.1539306640625000,  -0.0725097656250000,  -0.1216735839843750,  0.0911254882812500,  
-0.0789794921875000,  0.0000000000000000,  -0.0667724609375000,  0.2192687988281250,  
-0.0785217285156250,  0.0011596679687500,  0.2337646484375000,  0.1960754394531250,  
0.1427917480468750,  0.0000000000000000,  -0.1510314941406250,  -0.2319335937500000,  
0.0000000000000000,  0.0000000000000000,  0.1473388671875000,  -0.1262817382812500,  
-0.0224304199218750,  0.0035095214843750,  0.1013183593750000,  -0.0697021484375000,  
-0.0138854980468750,  0.1358642578125000,  0.0000000000000000,  0.0000000000000000,  
-0.0206909179687500,  0.0768432617187500,  -0.0910339355468750,  0.0446472167968750,  
0.2806091308593750,  0.0774230957031250,  0.0372619628906250,  0.1104125976562500,  
0.1616210937500000,  0.1584472656250000,  0.0474853515625000,  0.0299377441406250,  
-0.0698547363281250,  0.0000000000000000,  -0.0113525390625000,  0.0000000000000000,  
-0.0061950683593750,  -0.0155029296875000,  0.0104675292968750,  0.1745910644531250,  
-0.2995605468750000,  -0.2489318847656250,  0.0000000000000000,  0.0155944824218750,  
0.2120971679687500,  -0.0388793945312500,  0.0763244628906250,  -0.0066223144531250,  
-0.0526428222656250,  -0.2512207031250000,  -0.0290832519531250,  0.0000000000000000,  
-0.1296691894531250,  0.0472717285156250,  -0.0476379394531250,  -0.0396118164062500
},
{
-0.1257324218750000,  -0.0748291015625000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.2306213378906250,  -0.0077209472656250,  0.1608581542968750,  
-0.1341247558593750,  0.0000000000000000,  0.0422058105468750,  0.0507812500000000,  
-0.0136718750000000,  0.0000000000000000,  -0.1982421875000000,  0.0000000000000000,  
0.2528686523437500,  0.2098388671875000,  -0.0676574707031250,  -0.0683898925781250,  
-0.1692504882812500,  -0.1269226074218750,  0.0944213867187500,  0.0027160644531250,  
0.0588378906250000,  -0.0482788085937500,  -0.0912780761718750,  -0.2062072753906250,  
0.0000000000000000,  0.2488403320312500,  -0.1951293945312500,  0.0580444335937500,  
-0.0998229980468750,  0.0700073242187500,  0.1668701171875000,  0.2571716308593750,  
0.0033569335937500,  0.0523376464843750,  -0.0135803222656250,  0.2482910156250000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.2254028320312500,  
-0.0473632812500000,  0.2592163085937500,  0.0000000000000000,  0.0000000000000000,  
0.0701904296875000,  -0.0210266113281250,  -0.1016845703125000,  -0.1107788085937500,  
0.0000000000000000,  -0.0042114257812500,  0.0335388183593750,  -0.1218261718750000,  
-0.0278625488281250,  0.0288696289062500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1010437011718750,  0.0000000000000000,  0.0000000000000000,  
-0.1659545898437500,  0.1153869628906250,  -0.1265563964843750,  0.0000000000000000,  
-0.0609436035156250,  -0.2192077636718750,  0.0864257812500000,  -0.0575866699218750,  
-0.1118164062500000,  0.0076599121093750,  0.0044860839843750,  0.0000000000000000,  
0.0898132324218750,  0.0537414550781250,  -0.0090026855468750,  -0.1192016601562500
},
{
-0.1558532714843750,  0.0000000000000000,  0.0000000000000000,  0.1694946289062500,  
0.0000000000000000,  -0.2198486328125000,  0.0000000000000000,  0.0000000000000000,  
-0.0948486328125000,  0.3344116210937500,  0.0863037109375000,  -0.0874328613281250,  
-0.1450500488281250,  -0.0948791503906250,  -0.1706848144531250,  -0.0979003906250000,  
-0.0513305664062500,  -0.0334777832031250,  -0.1319274902343750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1302490234375000,  0.0000000000000000,  
-0.0652770996093750,  0.0331115722656250,  0.0000000000000000,  -0.1297912597656250,  
0.1043090820312500,  0.0884399414062500,  0.0000000000000000,  0.0816650390625000,  
-0.0173034667968750,  -0.1463623046875000,  0.0054321289062500,  0.0000000000000000,  
0.0429992675781250,  0.0000000000000000,  0.1841430664062500,  0.0010986328125000,  
0.0000000000000000,  -0.0108032226562500,  0.2126159667968750,  -0.0853271484375000,  
0.2739257812500000,  0.2162170410156250,  0.0000000000000000,  0.0926818847656250,  
0.0865783691406250,  0.0000000000000000,  0.1363220214843750,  0.0827331542968750,  
-0.1616516113281250,  -0.0349731445312500,  -0.1916198730468750,  -0.0863647460937500,  
0.1804199218750000,  -0.1420898437500000,  0.0306701660156250,  -0.0835876464843750,  
0.0000000000000000,  -0.0097656250000000,  0.0367736816406250,  -0.1834716796875000,  
-0.1778259277343750,  0.0084533691406250,  0.0858764648437500,  -0.0255737304687500,  
0.1094665527343750,  0.0387573242187500,  -0.0292663574218750,  -0.1726989746093750,  
-0.0259704589843750,  -0.0722656250000000,  0.1203613281250000,  0.0000000000000000,  
-0.2112426757812500,  0.0000000000000000,  0.1365661621093750,  0.0000000000000000
},
{
0.0622863769531250,  -0.0611572265625000,  0.1772155761718750,  -0.0002136230468750,  
0.0000000000000000,  0.0028381347656250,  0.0000000000000000,  -0.0245361328125000,  
0.0000000000000000,  0.0654602050781250,  -0.0944824218750000,  -0.0135192871093750,  
0.0433959960937500,  0.1435852050781250,  0.0000000000000000,  -0.0308837890625000,  
-0.0326538085937500,  -0.0944213867187500,  -0.1015930175781250,  0.1085815429687500,  
-0.1783752441406250,  0.0845031738281250,  0.2039794921875000,  0.4196472167968750,  
-0.0048522949218750,  -0.1473693847656250,  0.0000000000000000,  0.0000000000000000,  
0.1523437500000000,  -0.0192260742187500,  -0.0120239257812500,  -0.0423278808593750,  
0.0265502929687500,  -0.1614074707031250,  0.0000000000000000,  0.0519409179687500,  
0.1844787597656250,  -0.0868835449218750,  0.0194702148437500,  0.0000000000000000,  
0.0036621093750000,  0.0890808105468750,  0.0672912597656250,  0.1717529296875000,  
-0.0891723632812500,  0.0000000000000000,  0.1185302734375000,  0.0371093750000000,  
-0.0837097167968750,  -0.2599182128906250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0726013183593750,  0.1168823242187500,  0.1003112792968750,  
-0.1683654785156250,  0.0000000000000000,  -0.1157836914062500,  0.0381469726562500,  
0.0000000000000000,  -0.1558837890625000,  0.0000000000000000,  0.2052917480468750,  
0.1187133789062500,  0.0000000000000000,  0.2716674804687500,  0.0908813476562500,  
0.0000000000000000,  -0.0815124511718750,  0.0115356445312500,  0.0650634765625000,  
-0.2391052246093750,  0.0632324218750000,  -0.2196655273437500,  0.0952453613281250,  
0.1067810058593750,  0.0000000000000000,  -0.0213928222656250,  0.0000000000000000
},
{
-0.0330810546875000,  -0.2994079589843750,  -0.0858154296875000,  0.0093688964843750,  
-0.0514221191406250,  0.0425720214843750,  0.0664062500000000,  0.0266723632812500,  
0.0286254882812500,  0.0682678222656250,  0.0000000000000000,  0.0000000000000000,  
0.0801391601562500,  -0.0392761230468750,  -0.0642089843750000,  -0.0363769531250000,  
0.1667785644531250,  0.0409240722656250,  -0.0085144042968750,  0.0000000000000000,  
0.3039550781250000,  0.1350708007812500,  -0.0924072265625000,  -0.1901245117187500,  
-0.2654418945312500,  0.0000000000000000,  -0.0146484375000000,  -0.0910339355468750,  
0.0703735351562500,  0.0548400878906250,  0.0065612792968750,  -0.1265563964843750,  
-0.0098571777343750,  0.0138854980468750,  -0.1438293457031250,  0.0000000000000000,  
-0.0487670898437500,  -0.3825683593750000,  0.0000000000000000,  -0.0925598144531250,  
-0.0394592285156250,  0.1537780761718750,  -0.1284484863281250,  -0.0719299316406250,  
0.1151123046875000,  0.0974731445312500,  -0.0401916503906250,  -0.1860656738281250,  
-0.0029602050781250,  0.0000000000000000,  0.1010437011718750,  0.0000000000000000,  
0.0872497558593750,  -0.1065368652343750,  -0.0288696289062500,  -0.0714721679687500,  
-0.0654602050781250,  0.0861206054687500,  0.0670471191406250,  -0.0239562988281250,  
-0.0397033691406250,  -0.1949157714843750,  -0.1396789550781250,  0.0000000000000000,  
0.1854553222656250,  -0.0799560546875000,  -0.0702209472656250,  0.0850524902343750,  
-0.1761169433593750,  0.0109558105468750,  0.0916137695312500,  -0.0820617675781250,  
-0.0793762207031250,  0.1764526367187500,  -0.0542297363281250,  0.0350646972656250,  
0.0000000000000000,  -0.0275268554687500,  -0.0681152343750000,  -0.2101135253906250
},
{
-0.0520629882812500,  0.1105651855468750,  -0.2188415527343750,  0.1588439941406250,  
-0.0218811035156250,  0.0249938964843750,  0.0000000000000000,  -0.1647644042968750,  
-0.1047058105468750,  -0.3046875000000000,  0.0000000000000000,  -0.0273132324218750,  
-0.0247802734375000,  0.0731811523437500,  0.0000000000000000,  -0.0070190429687500,  
-0.2096862792968750,  0.0000000000000000,  0.1771545410156250,  0.0000000000000000,  
0.0000000000000000,  -0.0324096679687500,  0.1995544433593750,  0.0779113769531250,  
-0.0948791503906250,  -0.0155944824218750,  -0.2529296875000000,  0.0368957519531250,  
0.1247863769531250,  0.0968627929687500,  0.0500793457031250,  0.0000000000000000,  
-0.0419616699218750,  0.2106323242187500,  0.0451354980468750,  0.1477050781250000,  
0.0039367675781250,  -0.1110229492187500,  0.0000000000000000,  -0.1824645996093750,  
0.0000000000000000,  0.0000000000000000,  0.0627746582031250,  0.0504455566406250,  
0.1082763671875000,  -0.1377258300781250,  0.0504150390625000,  0.0000000000000000,  
-0.1687011718750000,  0.0000000000000000,  0.0000000000000000,  0.0678100585937500,  
-0.0097045898437500,  0.0403442382812500,  0.1416015625000000,  0.2568359375000000,  
-0.0484619140625000,  0.0000000000000000,  0.1679382324218750,  -0.2054443359375000,  
0.0000000000000000,  0.0000000000000000,  0.0902709960937500,  -0.0928344726562500,  
0.0000000000000000,  0.1070556640625000,  0.2855529785156250,  0.0690307617187500,  
0.1433410644531250,  0.1450805664062500,  0.0183715820312500,  0.0138854980468750,  
0.0792846679687500,  0.0000000000000000,  0.0504150390625000,  0.1575012207031250,  
-0.0438232421875000,  0.0000000000000000,  0.0351867675781250,  -0.0802001953125000
},
{
0.0000000000000000,  0.0000000000000000,  -0.1257934570312500,  0.0690002441406250,  
0.0688171386718750,  0.1657409667968750,  0.0050354003906250,  0.0070800781250000,  
0.0000000000000000,  -0.0464782714843750,  0.0903625488281250,  0.2444152832031250,  
0.0512390136718750,  0.0000000000000000,  0.0803833007812500,  0.1829528808593750,  
-0.1535949707031250,  0.0633544921875000,  0.1416931152343750,  0.1108398437500000,  
0.3108520507812500,  -0.0863037109375000,  0.1137695312500000,  0.0000000000000000,  
-0.1000976562500000,  -0.0080566406250000,  -0.0848999023437500,  0.0838317871093750,  
-0.1459350585937500,  0.1260375976562500,  0.1209106445312500,  0.0472106933593750,  
-0.0647583007812500,  0.0000000000000000,  0.0923767089843750,  0.0000000000000000,  
0.0000000000000000,  -0.1694030761718750,  0.0552978515625000,  -0.1038208007812500,  
-0.0311584472656250,  0.0899658203125000,  0.1787109375000000,  -0.1145629882812500,  
0.1808471679687500,  0.0000000000000000,  -0.0253906250000000,  -0.1517944335937500,  
0.0555114746093750,  0.1106567382812500,  0.1473999023437500,  0.0231323242187500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.2225646972656250,  
0.0000000000000000,  -0.2252502441406250,  -0.0513305664062500,  0.0778808593750000,  
0.0691833496093750,  -0.1203308105468750,  -0.0932922363281250,  -0.0023498535156250,  
0.0000000000000000,  -0.2256774902343750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.2520141601562500,  -0.0533752441406250,  0.1610107421875000,  
0.0278015136718750,  -0.0400695800781250,  0.1939697265625000,  0.0030822753906250,  
0.2298583984375000,  0.0529479980468750,  0.0000000000000000,  0.0000000000000000
},
{
0.2768554687500000,  -0.0542602539062500,  0.1054077148437500,  0.0000000000000000,  
0.2206420898437500,  0.1395263671875000,  0.0000000000000000,  -0.1615600585937500,  
0.0734558105468750,  0.1222839355468750,  -0.0140380859375000,  0.0000000000000000,  
-0.0937805175781250,  0.2207946777343750,  -0.0638122558593750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0161743164062500,  0.0722961425781250,  
0.0105285644531250,  -0.0276489257812500,  -0.1580505371093750,  -0.0141601562500000,  
-0.1448974609375000,  0.2468261718750000,  -0.1613464355468750,  -0.0677185058593750,  
0.1746215820312500,  -0.0439453125000000,  -0.1048583984375000,  -0.0092468261718750,  
0.0233459472656250,  0.0135803222656250,  0.1167297363281250,  0.0000000000000000,  
0.0000000000000000,  0.0474548339843750,  -0.1882324218750000,  0.2225952148437500,  
-0.1319885253906250,  -0.0049133300781250,  -0.0751953125000000,  0.0000000000000000,  
-0.1085510253906250,  0.1457519531250000,  0.2121887207031250,  0.0438842773437500,  
0.0000000000000000,  0.0675659179687500,  0.0957641601562500,  0.2488403320312500,  
0.1099853515625000,  0.0068969726562500,  0.0000000000000000,  -0.1307983398437500,  
-0.0029907226562500,  -0.0401916503906250,  0.0000000000000000,  0.0000000000000000,  
0.1913452148437500,  0.0269470214843750,  -0.0560913085937500,  0.1325073242187500,  
0.0523071289062500,  0.0000000000000000,  0.0165710449218750,  -0.2363891601562500,  
0.0000000000000000,  -0.1732482910156250,  0.0000000000000000,  0.0000000000000000,  
0.0184631347656250,  0.0388183593750000,  -0.1906433105468750,  0.1471557617187500,  
0.0000000000000000,  -0.0123901367187500,  -0.1647949218750000,  0.0000000000000000
},
{
-0.0334777832031250,  0.0000000000000000,  -0.1197509765625000,  -0.2448425292968750,  
0.0000000000000000,  0.0803833007812500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1905517578125000,  0.0000000000000000,  
-0.3349304199218750,  -0.0864562988281250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1666564941406250,  0.0000000000000000,  0.0635375976562500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1042175292968750,  
-0.3026733398437500,  0.0470581054687500,  0.1401672363281250,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1633300781250000,  
0.0000000000000000,  0.0000000000000000,  -0.2514038085937500,  0.0000000000000000,  
0.0000000000000000,  -0.3923339843750000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1187133789062500,  -0.1371765136718750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0624694824218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1550292968750000,  0.0000000000000000,  0.0000000000000000,  -0.1382751464843750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.3800964355468750,  
0.0407714843750000,  0.0812377929687500,  -0.1132812500000000,  -0.0144348144531250,  
0.0000000000000000,  -0.1123352050781250,  0.1224670410156250,  0.0000000000000000,  
0.0000000000000000,  -0.0872192382812500,  0.0000000000000000,  0.0009155273437500,  
0.0000000000000000,  0.0000000000000000,  -0.0434265136718750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.2817077636718750,  0.0000000000000000
},
{
-0.0344238281250000,  0.0000000000000000,  0.1029052734375000,  0.0700378417968750,  
-0.1011047363281250,  -0.2195739746093750,  0.0390625000000000,  0.0000000000000000,  
0.0437011718750000,  0.0127563476562500,  0.0000000000000000,  -0.0903930664062500,  
-0.0918884277343750,  0.0374145507812500,  0.1679077148437500,  0.1311950683593750,  
0.2954101562500000,  0.2130737304687500,  0.0020141601562500,  0.2103881835937500,  
0.0000000000000000,  -0.0499572753906250,  0.1026000976562500,  0.1629028320312500,  
0.0348510742187500,  0.0142517089843750,  0.0422363281250000,  -0.0874328613281250,  
0.0000000000000000,  0.0000000000000000,  0.0310668945312500,  0.0563659667968750,  
0.0112304687500000,  0.3649597167968750,  0.0000000000000000,  0.2394714355468750,  
0.1431884765625000,  -0.1396484375000000,  -0.1210021972656250,  -0.0739746093750000,  
-0.0312500000000000,  0.1293945312500000,  -0.0574340820312500,  -0.0368652343750000,  
0.0000000000000000,  -0.1024475097656250,  0.0000000000000000,  -0.0826416015625000,  
0.0000000000000000,  -0.0545959472656250,  -0.1744995117187500,  -0.0639038085937500,  
0.0598449707031250,  0.0241394042968750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1008911132812500,  0.0403747558593750,  
0.0696105957031250,  0.0286865234375000,  -0.2024841308593750,  0.1224975585937500,  
0.0000000000000000,  0.1328430175781250,  0.0851135253906250,  0.0000000000000000,  
0.1345214843750000,  0.0925598144531250,  0.2343750000000000,  0.1045532226562500,  
0.1844177246093750,  0.0454711914062500,  0.1197509765625000,  0.1296997070312500,  
-0.0874023437500000,  0.0000000000000000,  -0.0649414062500000,  0.1555786132812500
},
{
0.0000000000000000,  0.0000000000000000,  -0.0984802246093750,  0.0000000000000000,  
-0.1207885742187500,  0.0020446777343750,  0.2895812988281250,  -0.0784301757812500,  
-0.0755310058593750,  -0.0726623535156250,  -0.0978088378906250,  -0.1431274414062500,  
-0.2469177246093750,  0.0000000000000000,  -0.0697021484375000,  -0.0017700195312500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0402221679687500,  
0.1549377441406250,  0.0852966308593750,  0.1460876464843750,  0.0000000000000000,  
-0.1073608398437500,  -0.0215759277343750,  -0.0157165527343750,  0.0578613281250000,  
-0.3126831054687500,  0.0171813964843750,  0.1982116699218750,  0.1072998046875000,  
0.1810913085937500,  0.1367187500000000,  0.0297851562500000,  0.3801574707031250,  
0.0000000000000000,  -0.0751037597656250,  0.0000000000000000,  -0.0592956542968750,  
-0.0144348144531250,  0.1640319824218750,  0.0000000000000000,  0.1023559570312500,  
0.0189208984375000,  0.0944519042968750,  -0.0714111328125000,  -0.0501708984375000,  
0.0602111816406250,  0.0000000000000000,  0.0000000000000000,  0.0000915527343750,  
-0.0180969238281250,  0.0000000000000000,  -0.0210266113281250,  0.0000000000000000,  
0.1577453613281250,  -0.0703430175781250,  -0.1086730957031250,  0.1401367187500000,  
-0.0526123046875000,  0.0783386230468750,  -0.0864562988281250,  0.0000000000000000,  
0.2343139648437500,  0.0957336425781250,  0.0194091796875000,  0.0000000000000000,  
-0.0273437500000000,  -0.1098937988281250,  -0.0372619628906250,  -0.0264282226562500,  
0.1945495605468750,  0.0935974121093750,  -0.0104064941406250,  0.0288391113281250,  
-0.1619567871093750,  -0.1459045410156250,  0.2076721191406250,  -0.0000610351562500
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0496826171875000,  
0.0000000000000000,  0.2944335937500000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0441284179687500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0270385742187500,  
0.0000000000000000,  0.1791076660156250,  -0.1657409667968750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1658325195312500,  -0.0129089355468750,  0.0000000000000000,  0.0000000000000000,  
0.3220520019531250,  0.0000000000000000,  0.0000000000000000,  0.0341186523437500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0778198242187500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0007934570312500,  0.0000000000000000,  
-0.0106811523437500,  0.0000000000000000,  0.0000000000000000,  0.0103454589843750,  
-0.1671752929687500,  0.0165100097656250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0631713867187500,  0.4985046386718750,  -0.2789001464843750,  0.0000000000000000,  
-0.0797424316406250,  0.4874267578125000,  0.0000000000000000,  0.0000000000000000,  
-0.2918395996093750,  0.0000000000000000,  -0.1101684570312500,  0.0000000000000000,  
0.0035400390625000,  0.1001586914062500,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0450134277343750,  
-0.0643005371093750,  0.0000000000000000,  -0.0230407714843750,  0.0000000000000000,  
0.0000000000000000,  0.1206970214843750,  0.0798034667968750,  0.0294494628906250,  
0.0124206542968750,  0.0216064453125000,  -0.0556945800781250,  0.0000000000000000,  
0.1784362792968750,  -0.1057434082031250,  -0.0128173828125000,  0.2130432128906250,  
0.0000000000000000,  0.0000000000000000,  0.0704345703125000,  -0.0697326660156250,  
0.0899963378906250,  0.0000000000000000,  0.0000000000000000,  -0.1963500976562500,  
0.2209777832031250,  0.1159057617187500,  -0.1088867187500000,  -0.0359802246093750,  
0.0000000000000000,  -0.1508789062500000,  0.0000000000000000,  0.0000000000000000,  
0.1520080566406250,  -0.1132812500000000,  0.0813903808593750,  0.1967468261718750,  
-0.1621093750000000,  0.3013000488281250,  0.0000000000000000,  -0.0983276367187500,  
0.1961059570312500,  0.0000000000000000,  -0.0204162597656250,  -0.1586608886718750,  
0.0000000000000000,  0.0000000000000000,  -0.0125732421875000,  0.0660095214843750,  
-0.0810852050781250,  0.0000000000000000,  0.0000000000000000,  -0.0487365722656250,  
-0.0673522949218750,  -0.0662841796875000,  0.2226867675781250,  0.0000000000000000,  
-0.1666870117187500,  0.0296325683593750,  0.1062927246093750,  -0.0228576660156250,  
0.0000000000000000,  -0.0624694824218750,  0.0931701660156250,  0.0000000000000000,  
0.0000000000000000,  0.3496704101562500,  0.0909729003906250,  0.0000000000000000,  
0.1378479003906250,  -0.1181335449218750,  0.0284118652343750,  -0.1432189941406250,  
-0.3074645996093750,  -0.0685119628906250,  0.0833129882812500,  -0.1909179687500000
},
{
0.0000000000000000,  0.1130065917968750,  -0.1259765625000000,  -0.0206298828125000,  
0.0000000000000000,  0.0266723632812500,  -0.1428222656250000,  0.1467285156250000,  
-0.0603637695312500,  0.2733154296875000,  -0.0367736816406250,  -0.2491149902343750,  
0.0000000000000000,  0.0000000000000000,  0.0142211914062500,  0.1100769042968750,  
-0.2214355468750000,  0.0000000000000000,  0.0000000000000000,  0.0188293457031250,  
0.0000000000000000,  0.0000000000000000,  -0.0697937011718750,  0.0000000000000000,  
-0.0459594726562500,  0.0531616210937500,  -0.0585632324218750,  0.0000000000000000,  
-0.0300903320312500,  -0.1636962890625000,  0.1058349609375000,  0.0000000000000000,  
-0.0150451660156250,  -0.1465759277343750,  0.0000000000000000,  -0.0313720703125000,  
-0.0167846679687500,  -0.0838012695312500,  0.0000000000000000,  0.0000000000000000,  
-0.0035400390625000,  -0.1996459960937500,  0.0000000000000000,  -0.0146484375000000,  
-0.0558166503906250,  0.1047668457031250,  -0.0304870605468750,  0.3253784179687500,  
0.2486572265625000,  0.0300598144531250,  0.0942077636718750,  -0.1268615722656250,  
0.0094299316406250,  -0.0987243652343750,  0.3122253417968750,  -0.1635131835937500,  
0.1252441406250000,  0.0963134765625000,  0.0000000000000000,  -0.1367492675781250,  
0.0672302246093750,  0.0000000000000000,  -0.1531677246093750,  0.0000000000000000,  
-0.2123413085937500,  0.0000000000000000,  0.0000000000000000,  0.1616516113281250,  
0.0000000000000000,  0.0169982910156250,  0.1339416503906250,  0.0000000000000000,  
-0.1817626953125000,  -0.0190124511718750,  0.1109313964843750,  0.1201782226562500,  
-0.0104980468750000,  0.0685119628906250,  -0.1741943359375000,  -0.0595092773437500
},
{
0.0000000000000000,  0.0000000000000000,  -0.0327453613281250,  0.0742797851562500,  
0.2077636718750000,  -0.0621032714843750,  0.0000000000000000,  0.1198730468750000,  
0.0000000000000000,  0.0766296386718750,  0.0682983398437500,  -0.0952758789062500,  
-0.1432495117187500,  0.3714294433593750,  0.0000000000000000,  0.0000000000000000,  
0.0401611328125000,  0.0000000000000000,  -0.0168457031250000,  0.0000000000000000,  
0.0534667968750000,  -0.0810241699218750,  -0.0211486816406250,  0.0289306640625000,  
-0.1712646484375000,  -0.1179199218750000,  0.0059814453125000,  -0.0603332519531250,  
0.0000000000000000,  -0.0975646972656250,  0.0692443847656250,  -0.0236816406250000,  
0.0673217773437500,  -0.0184631347656250,  0.0274963378906250,  0.0609436035156250,  
0.0425720214843750,  -0.0153198242187500,  0.2906188964843750,  -0.0808410644531250,  
-0.1203308105468750,  0.0663146972656250,  0.0197448730468750,  -0.0099182128906250,  
0.0971984863281250,  0.0462341308593750,  -0.0060729980468750,  0.3410034179687500,  
0.0422363281250000,  0.2033081054687500,  0.0482788085937500,  0.0000000000000000,  
0.0000000000000000,  0.0928344726562500,  -0.1301574707031250,  -0.1326293945312500,  
-0.2268676757812500,  -0.1526184082031250,  0.0240783691406250,  -0.0512390136718750,  
-0.0417785644531250,  -0.0199890136718750,  0.1842651367187500,  -0.0669555664062500,  
0.0506896972656250,  0.0000000000000000,  -0.1550292968750000,  -0.1044921875000000,  
0.0589599609375000,  -0.0029907226562500,  0.0896606445312500,  -0.3612060546875000,  
-0.1961364746093750,  0.0000000000000000,  0.0000000000000000,  -0.0280151367187500,  
0.0000000000000000,  0.0360717773437500,  0.0000000000000000,  0.0516662597656250
},
{
0.1413574218750000,  0.0000000000000000,  -0.0102539062500000,  0.0847778320312500,  
0.1496887207031250,  0.1135253906250000,  -0.0017395019531250,  -0.0059509277343750,  
-0.1977233886718750,  -0.1418151855468750,  -0.1839599609375000,  0.1191406250000000,  
-0.1057739257812500,  0.0000000000000000,  -0.0963134765625000,  0.0574340820312500,  
-0.0381164550781250,  0.0767822265625000,  0.0032348632812500,  0.0234985351562500,  
-0.0742797851562500,  0.2411499023437500,  -0.2185363769531250,  0.0595703125000000,  
0.2491760253906250,  0.0000000000000000,  0.2307128906250000,  0.0000000000000000,  
0.0000000000000000,  0.1662902832031250,  0.0000000000000000,  -0.0809326171875000,  
0.0000000000000000,  -0.0212402343750000,  0.0000000000000000,  0.0000000000000000,  
0.0619506835937500,  0.0347900390625000,  -0.1238098144531250,  0.0704345703125000,  
-0.0548095703125000,  0.1223144531250000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0532836914062500,  0.0000000000000000,  -0.0415344238281250,  
0.0000000000000000,  -0.0439453125000000,  0.2519226074218750,  -0.0796508789062500,  
0.1629333496093750,  0.0141296386718750,  0.0756225585937500,  0.1310424804687500,  
0.1164550781250000,  0.1257629394531250,  0.0000000000000000,  0.1996459960937500,  
0.0000000000000000,  0.1323852539062500,  0.0175781250000000,  0.0000000000000000,  
0.0000000000000000,  -0.2268371582031250,  0.0000000000000000,  -0.1541442871093750,  
0.0474243164062500,  0.2461547851562500,  -0.2409362792968750,  0.0834960937500000,  
-0.2156677246093750,  -0.0088195800781250,  -0.0913085937500000,  0.0000000000000000,  
0.0000000000000000,  -0.1385803222656250,  -0.0003356933593750,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0744628906250000,  0.0000000000000000,  
-0.0836486816406250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1264038085937500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.1628112792968750,  0.0000000000000000,  -0.3162841796875000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1559448242187500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.4265441894531250,  
0.0027465820312500,  0.0667419433593750,  -0.0866699218750000,  0.0000000000000000,  
-0.3223876953125000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1327514648437500,  0.0968017578125000,  -0.0583190917968750,  
-0.0864257812500000,  0.0000000000000000,  0.0000000000000000,  0.1399841308593750,  
0.0000000000000000,  -0.0761718750000000,  0.1229553222656250,  0.0094299316406250,  
-0.1069030761718750,  -0.2070617675781250,  0.0000000000000000,  -0.0206298828125000,  
-0.0071716308593750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.3469238281250000,  0.0000000000000000,  
0.2492065429687500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0309143066406250,  0.1531066894531250,  0.0000000000000000,  
-0.0043640136718750,  0.0000000000000000,  -0.0087280273437500,  0.3212280273437500,  
0.0000000000000000,  0.0000000000000000,  -0.2817687988281250,  0.0000000000000000
},
{
-0.0854797363281250,  -0.1010742187500000,  0.0000000000000000,  -0.1079406738281250,  
0.0883483886718750,  -0.0992126464843750,  0.0885314941406250,  0.0371398925781250,  
0.0000000000000000,  0.1012268066406250,  0.0757141113281250,  0.0676269531250000,  
0.0191040039062500,  -0.0319213867187500,  -0.0220642089843750,  0.0156860351562500,  
0.0000000000000000,  0.0354003906250000,  0.0000000000000000,  -0.2140502929687500,  
0.0000000000000000,  0.1569824218750000,  0.1673278808593750,  -0.0904846191406250,  
-0.1525573730468750,  0.1159362792968750,  0.2019042968750000,  0.1455993652343750,  
0.1316833496093750,  0.1017150878906250,  -0.2379455566406250,  0.0148925781250000,  
0.0000000000000000,  -0.1173400878906250,  -0.0509643554687500,  -0.0753173828125000,  
-0.1687622070312500,  -0.2376403808593750,  0.0000000000000000,  0.0603637695312500,  
-0.1952209472656250,  0.0664062500000000,  0.0000000000000000,  -0.0159301757812500,  
0.1114501953125000,  -0.0198974609375000,  0.0527343750000000,  -0.0651550292968750,  
0.1091918945312500,  0.0000000000000000,  0.0021667480468750,  0.0000000000000000,  
0.3459167480468750,  -0.0392456054687500,  0.2726135253906250,  0.0888366699218750,  
0.0115051269531250,  -0.0258483886718750,  0.0000000000000000,  0.0352478027343750,  
-0.1065368652343750,  0.0319824218750000,  0.0475769042968750,  -0.1701354980468750,  
-0.1323242187500000,  -0.2491455078125000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0177307128906250,  0.0000000000000000,  0.0233154296875000,  
0.0000000000000000,  0.0113525390625000,  0.1217041015625000,  0.1143798828125000,  
0.0000000000000000,  -0.2871704101562500,  0.0000000000000000,  0.0711364746093750
},
{
0.1799316406250000,  -0.0641784667968750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0343322753906250,  0.0000000000000000,  -0.0365295410156250,  0.0000000000000000,  
0.0000000000000000,  -0.0445251464843750,  0.0000000000000000,  -0.2170715332031250,  
0.1505126953125000,  0.0000000000000000,  -0.1028747558593750,  -0.0560607910156250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.0079040527343750,  
0.0000000000000000,  0.5242309570312500,  0.0000000000000000,  -0.0601501464843750,  
-0.3502502441406250,  0.0000000000000000,  0.0111999511718750,  0.2929382324218750,  
0.0000000000000000,  -0.1187133789062500,  -0.0921630859375000,  0.0000000000000000,  
0.0000000000000000,  0.1197204589843750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0804138183593750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1607055664062500,  0.0688781738281250,  
0.0000000000000000,  -0.0805358886718750,  0.0000000000000000,  -0.2094116210937500,  
0.0000000000000000,  0.0886535644531250,  -0.0258178710937500,  0.0000000000000000,  
0.0000000000000000,  -0.2348632812500000,  0.2011108398437500,  0.0089416503906250,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.2477111816406250,  
0.0000000000000000,  -0.2963867187500000,  -0.1034545898437500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0325012207031250,  0.1602783203125000,  0.0633239746093750,  -0.1124877929687500,  
-0.0928344726562500,  0.0787353515625000,  -0.0169677734375000,  0.1665954589843750,  
-0.1504821777343750,  0.0578308105468750,  0.1103515625000000,  -0.0049438476562500,  
0.0119628906250000,  -0.1531372070312500,  0.0491333007812500,  0.0030822753906250,  
-0.0851745605468750,  -0.2481689453125000,  -0.0011596679687500,  0.1272583007812500,  
-0.2011108398437500,  -0.1812438964843750,  0.0000000000000000,  -0.1507263183593750,  
0.0000000000000000,  -0.0790100097656250,  -0.1156005859375000,  0.0060119628906250,  
0.0000000000000000,  -0.1571655273437500,  -0.0889587402343750,  0.1495971679687500,  
0.0000000000000000,  0.0595703125000000,  0.1932373046875000,  0.1981811523437500,  
0.1408081054687500,  -0.1547241210937500,  0.0000000000000000,  -0.1903686523437500,  
0.0417785644531250,  -0.0065002441406250,  0.0918579101562500,  0.0176696777343750,  
-0.0227355957031250,  -0.0756835937500000,  0.0000000000000000,  -0.0342102050781250,  
0.2475585937500000,  0.0000000000000000,  0.0000000000000000,  0.2177124023437500,  
0.1518249511718750,  0.0000000000000000,  0.0000000000000000,  -0.1622924804687500,  
-0.0407714843750000,  0.0000000000000000,  0.0157470703125000,  0.1531066894531250,  
0.0000000000000000,  0.0000000000000000,  -0.2582397460937500,  0.0000000000000000,  
0.0000000000000000,  -0.0172119140625000,  0.0000000000000000,  -0.1401367187500000,  
0.2834472656250000,  0.0000000000000000,  0.0438842773437500,  -0.0543212890625000,  
-0.0430297851562500,  0.0000000000000000,  0.0368652343750000,  0.0964355468750000,  
-0.0327148437500000,  -0.0871887207031250,  -0.1620178222656250,  0.1140747070312500
},
{
-0.0259094238281250,  0.0000000000000000,  -0.0437927246093750,  0.0168457031250000,  
0.0000000000000000,  0.2573852539062500,  -0.0512695312500000,  -0.0337524414062500,  
-0.1148681640625000,  0.0603332519531250,  -0.0029907226562500,  0.0000000000000000,  
0.1816711425781250,  0.0000000000000000,  -0.4531555175781250,  -0.1235046386718750,  
0.0969238281250000,  0.0000000000000000,  -0.0039672851562500,  0.0000000000000000,  
-0.1175842285156250,  0.1003723144531250,  0.1736755371093750,  -0.1730346679687500,  
-0.0552062988281250,  0.0385742187500000,  0.0100402832031250,  0.0000000000000000,  
0.0520629882812500,  0.0000000000000000,  0.0260009765625000,  0.3400878906250000,  
-0.1066589355468750,  0.1074829101562500,  0.0892333984375000,  -0.1408386230468750,  
0.0688476562500000,  -0.0292968750000000,  0.0215148925781250,  0.0860290527343750,  
-0.0081176757812500,  0.1030578613281250,  0.0615234375000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0410156250000000,  -0.0727233886718750,  
-0.2294311523437500,  0.0296325683593750,  -0.0492248535156250,  -0.0521850585937500,  
0.0954284667968750,  0.0747985839843750,  0.0633850097656250,  -0.0913085937500000,  
0.3093566894531250,  0.0000000000000000,  0.0080871582031250,  -0.0634460449218750,  
0.0000000000000000,  0.2561340332031250,  0.0000000000000000,  -0.0637512207031250,  
-0.0136108398437500,  0.0101928710937500,  0.0000000000000000,  0.0797424316406250,  
0.0000000000000000,  0.0046691894531250,  -0.1019897460937500,  0.0000000000000000,  
-0.1495361328125000,  0.0591125488281250,  0.2225952148437500,  -0.0509033203125000,  
0.0000000000000000,  -0.0602111816406250,  0.0000000000000000,  0.0071716308593750
},
{
0.0000000000000000,  0.0932006835937500,  -0.0369262695312500,  -0.0016784667968750,  
0.0000000000000000,  -0.3087768554687500,  -0.1166381835937500,  0.0355224609375000,  
-0.1428833007812500,  -0.0453186035156250,  0.0939025878906250,  -0.0572814941406250,  
0.1816101074218750,  0.0000000000000000,  0.1034240722656250,  0.1106262207031250,  
-0.0657958984375000,  0.0000000000000000,  0.1072082519531250,  0.0000000000000000,  
0.1369934082031250,  -0.1587829589843750,  -0.1341552734375000,  0.0000000000000000,  
0.0502624511718750,  0.0000000000000000,  0.0135192871093750,  0.0550842285156250,  
0.0000000000000000,  -0.1469116210937500,  -0.2415161132812500,  0.0212402343750000,  
0.0000000000000000,  0.0296936035156250,  0.0000000000000000,  0.0000000000000000,  
0.0876770019531250,  -0.1019592285156250,  -0.0885009765625000,  0.0000000000000000,  
-0.1325378417968750,  0.1549072265625000,  -0.0357055664062500,  -0.0194702148437500,  
0.0797119140625000,  0.0326843261718750,  0.0000000000000000,  0.0000000000000000,  
0.0729980468750000,  0.0000000000000000,  -0.1193847656250000,  0.2339172363281250,  
-0.0789184570312500,  0.0098266601562500,  0.0821228027343750,  0.0061645507812500,  
0.3167724609375000,  0.2840270996093750,  -0.1418762207031250,  -0.1161499023437500,  
0.0322570800781250,  -0.0388793945312500,  -0.0530700683593750,  0.0000000000000000,  
0.0180664062500000,  -0.2197875976562500,  0.0465087890625000,  -0.1745300292968750,  
0.0000000000000000,  0.0240783691406250,  -0.1811828613281250,  -0.2265930175781250,  
-0.1616821289062500,  0.0912780761718750,  0.0000000000000000,  -0.0506286621093750,  
0.1477355957031250,  -0.0086364746093750,  -0.1026916503906250,  0.0708618164062500
},
{
0.0000000000000000,  0.0000000000000000,  0.0346069335937500,  0.0000000000000000,  
-0.1072998046875000,  0.0000000000000000,  0.1255798339843750,  -0.1398925781250000,  
-0.0320129394531250,  0.0223083496093750,  0.0000000000000000,  0.0000000000000000,  
-0.0119628906250000,  0.1647033691406250,  -0.1003417968750000,  0.0000000000000000,  
-0.1392822265625000,  0.3493652343750000,  0.0000000000000000,  -0.0370483398437500,  
0.0000000000000000,  0.0748596191406250,  0.0264587402343750,  0.0000000000000000,  
-0.0654602050781250,  0.0310668945312500,  0.0000000000000000,  -0.0397644042968750,  
0.0000000000000000,  -0.0367736816406250,  0.0591430664062500,  0.0527648925781250,  
-0.0113220214843750,  0.0000000000000000,  0.0000000000000000,  -0.0605468750000000,  
-0.0080871582031250,  -0.0143127441406250,  0.1399841308593750,  0.1123962402343750,  
0.1248168945312500,  0.0000000000000000,  0.0239868164062500,  -0.1757507324218750,  
0.1065979003906250,  -0.2338562011718750,  0.0209045410156250,  -0.0613708496093750,  
0.0483703613281250,  0.0000000000000000,  -0.1589355468750000,  -0.1430664062500000,  
-0.0709228515625000,  0.0758056640625000,  0.0299987792968750,  0.0000000000000000,  
0.0043029785156250,  0.2903747558593750,  0.0853271484375000,  -0.1387939453125000,  
-0.1037597656250000,  0.1370239257812500,  -0.0683898925781250,  0.0052795410156250,  
-0.0097961425781250,  -0.1730346679687500,  0.0053710937500000,  0.0147094726562500,  
-0.3054199218750000,  0.0396728515625000,  -0.1122741699218750,  -0.1734924316406250,  
-0.2089233398437500,  -0.1918029785156250,  0.2239685058593750,  0.0018310546875000,  
-0.1479492187500000,  0.0351562500000000,  -0.0574645996093750,  0.2572021484375000
},
{
-0.1541137695312500,  0.0717773437500000,  0.0000000000000000,  0.0789489746093750,  
0.0010070800781250,  0.1705017089843750,  0.2387390136718750,  -0.0942687988281250,  
-0.0083312988281250,  -0.0470581054687500,  0.0419311523437500,  0.0000000000000000,  
-0.0194702148437500,  -0.0639038085937500,  -0.0738830566406250,  0.0444030761718750,  
-0.2045593261718750,  -0.1248474121093750,  -0.1248168945312500,  0.2107238769531250,  
-0.0950012207031250,  0.0000000000000000,  0.0581970214843750,  0.0414428710937500,  
0.0000000000000000,  0.0170288085937500,  0.0000000000000000,  0.0000000000000000,  
-0.0053710937500000,  -0.3947448730468750,  0.0616149902343750,  0.1294860839843750,  
0.0000000000000000,  0.0000000000000000,  -0.0056457519531250,  0.0735168457031250,  
0.0125732421875000,  0.0000000000000000,  0.0915222167968750,  -0.0165100097656250,  
0.0000000000000000,  0.1382446289062500,  -0.0572509765625000,  0.0000000000000000,  
0.0000000000000000,  0.2709655761718750,  0.0263061523437500,  0.0545959472656250,  
-0.2909851074218750,  0.0105895996093750,  0.1304626464843750,  -0.0986022949218750,  
0.0000000000000000,  -0.0057678222656250,  0.0934143066406250,  0.1051330566406250,  
0.0609741210937500,  0.0238647460937500,  -0.0395812988281250,  0.0000000000000000,  
-0.1136169433593750,  0.0033264160156250,  -0.0824890136718750,  0.0425109863281250,  
0.1133728027343750,  -0.1153869628906250,  0.0187377929687500,  0.2017211914062500,  
0.0000000000000000,  -0.0237731933593750,  -0.0968017578125000,  0.1911010742187500,  
0.0570373535156250,  -0.0568847656250000,  0.1136169433593750,  -0.2980041503906250,  
0.0000000000000000,  -0.0813903808593750,  -0.0941162109375000,  -0.1894836425781250
},
{
0.0000000000000000,  0.0000000000000000,  0.1902160644531250,  0.0000000000000000,  
-0.1308288574218750,  -0.1643981933593750,  -0.0719604492187500,  -0.0435485839843750,  
0.0977172851562500,  -0.1361694335937500,  0.0349731445312500,  0.0027770996093750,  
-0.0133056640625000,  -0.1008605957031250,  0.0208740234375000,  -0.1473388671875000,  
-0.1177673339843750,  -0.1206665039062500,  -0.3084716796875000,  0.0050964355468750,  
0.2295532226562500,  -0.0251464843750000,  0.1903991699218750,  0.0555419921875000,  
0.0000000000000000,  -0.0727233886718750,  -0.1097106933593750,  -0.0043029785156250,  
0.1696777343750000,  -0.0212707519531250,  0.1813049316406250,  0.0979003906250000,  
0.1094360351562500,  0.0817565917968750,  -0.1054992675781250,  -0.0625610351562500,  
0.0000000000000000,  0.1906127929687500,  0.1638793945312500,  0.0272216796875000,  
0.0000000000000000,  -0.1944580078125000,  0.0663146972656250,  -0.1296081542968750,  
0.0000000000000000,  0.1119995117187500,  -0.1488952636718750,  -0.0453491210937500,  
-0.0136413574218750,  0.0032653808593750,  0.0991821289062500,  -0.0774536132812500,  
-0.0308227539062500,  0.1459655761718750,  0.0398559570312500,  0.0879516601562500,  
0.0431213378906250,  0.0000000000000000,  -0.0789489746093750,  -0.0315246582031250,  
-0.2088623046875000,  0.0014038085937500,  -0.1322021484375000,  0.0000000000000000,  
0.0000000000000000,  0.0576782226562500,  -0.0654296875000000,  -0.1890563964843750,  
0.0814819335937500,  -0.1391296386718750,  0.0572509765625000,  0.0000000000000000,  
-0.0863037109375000,  0.2783508300781250,  0.0000000000000000,  0.0629882812500000,  
0.0000000000000000,  0.2671203613281250,  0.0125732421875000,  0.0348815917968750
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.2827758789062500,  
0.0000000000000000,  0.1308898925781250,  0.0000000000000000,  0.0000000000000000,  
-0.4769897460937500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1079101562500000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0318298339843750,  0.0000000000000000,  0.0000000000000000,  
0.0591430664062500,  0.1050109863281250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0401306152343750,  -0.1065673828125000,  
-0.1963195800781250,  -0.3825378417968750,  0.4754028320312500,  0.0000000000000000,  
-0.1185607910156250,  0.0000000000000000,  0.0000000000000000,  -0.1897888183593750,  
0.1654968261718750,  -0.1061096191406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0658264160156250,  0.0000000000000000,  0.0000000000000000,  
0.1636352539062500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0417785644531250,  0.0000000000000000,  -0.1519775390625000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0300903320312500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1986083984375000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1884460449218750,  -0.0617065429687500,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  -0.0305175781250000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1255798339843750,  0.0125427246093750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1444091796875000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0168457031250000,  0.0520324707031250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0760803222656250,  -0.1503601074218750,  0.0339965820312500,  
-0.0401916503906250,  0.0000000000000000,  -0.2156066894531250,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1465148925781250,  0.0000000000000000,  
0.0000000000000000,  0.1666564941406250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.6423034667968750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.3960876464843750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0307922363281250,  0.0000000000000000,  0.0000000000000000,  
0.1321716308593750,  0.0000000000000000,  0.0000000000000000,  -0.1377258300781250,  
0.0000000000000000,  0.0000000000000000,  -0.1829833984375000,  0.0000000000000000,  
0.0000000000000000,  0.0232849121093750,  0.0000000000000000,  -0.1828918457031250,  
0.0393981933593750,  0.0000000000000000,  0.2142944335937500,  -0.2501220703125000,  
0.0000000000000000,  -0.1618041992187500,  0.0000000000000000,  0.1258544921875000,  
0.0778808593750000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1642761230468750,  0.2254943847656250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.4199218750000000,  
0.0000000000000000,  0.0000000000000000,  0.1119689941406250,  0.0000000000000000,  
0.0000000000000000,  0.0501403808593750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0908508300781250,  0.0000000000000000,  -0.1234130859375000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1947937011718750,  -0.4165039062500000,  0.0000000000000000,  
0.1975097656250000,  0.0000000000000000,  -0.3974609375000000,  -0.1255493164062500,  
0.0000000000000000,  0.0000000000000000,  0.0317993164062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0972595214843750,  -0.1632995605468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2727050781250000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1521301269531250,  0.0000000000000000,  
-0.0592956542968750,  0.2478332519531250,  -0.1280212402343750,  0.0000000000000000,  
0.0000000000000000,  0.2204589843750000,  0.0000000000000000,  0.0256042480468750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.0073547363281250,  0.0312500000000000,  -0.1298522949218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0107421875000000,  0.2812500000000000,  0.0765686035156250,  
0.0000000000000000,  -0.0351257324218750,  0.0000000000000000,  -0.0356445312500000,  
0.0000000000000000,  -0.2005004882812500,  0.0253295898437500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0887451171875000,  -0.2464599609375000,  
0.0000000000000000,  -0.1774902343750000,  -0.1569213867187500,  0.0000000000000000,  
-0.2246093750000000,  0.0217590332031250,  0.2372741699218750,  0.0084228515625000,  
-0.0012817382812500,  0.0270080566406250,  0.0000000000000000,  -0.1945190429687500,  
-0.1217041015625000,  0.0000000000000000,  0.0446472167968750,  -0.0945739746093750,  
0.0000000000000000,  -0.0344543457031250,  0.0090332031250000,  -0.0507507324218750,  
0.2881469726562500,  0.0419311523437500,  -0.0120544433593750,  0.0849304199218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2062072753906250,  0.0131835937500000,  0.0839843750000000,  -0.0081787109375000,  
-0.0744323730468750,  -0.0008239746093750,  -0.0248413085937500,  0.0000000000000000,  
-0.2503051757812500,  -0.0426635742187500,  -0.1091003417968750,  -0.1759338378906250,  
0.0000000000000000,  -0.1806030273437500,  0.1318359375000000,  -0.1579895019531250,  
0.0104675292968750,  0.1089477539062500,  0.0000000000000000,  0.0000000000000000,  
0.0110473632812500,  0.0000000000000000,  0.0993652343750000,  -0.3004150390625000,  
0.1174316406250000,  0.0000000000000000,  0.1823425292968750,  -0.0238342285156250,  
0.1925048828125000,  -0.1644592285156250,  0.0172119140625000,  0.0650634765625000,  
0.0000000000000000,  -0.0393371582031250,  0.0000000000000000,  -0.1047973632812500
},
{
-0.3504943847656250,  -0.1432189941406250,  0.0446777343750000,  0.0000000000000000,  
-0.0356750488281250,  0.0113830566406250,  0.0810852050781250,  0.0393066406250000,  
0.0975646972656250,  0.0000000000000000,  -0.0908203125000000,  -0.0249938964843750,  
0.1562805175781250,  0.0000000000000000,  -0.0088500976562500,  0.1851196289062500,  
-0.1071777343750000,  0.0000000000000000,  0.1401367187500000,  0.1122436523437500,  
0.1531066894531250,  -0.2405700683593750,  -0.0777893066406250,  0.0685119628906250,  
0.0000000000000000,  0.0000000000000000,  0.0873107910156250,  0.0000000000000000,  
0.0000000000000000,  -0.1210937500000000,  0.0000000000000000,  0.0032043457031250,  
-0.2493591308593750,  0.0000000000000000,  0.0055541992187500,  0.1743164062500000,  
0.0528564453125000,  0.0877075195312500,  0.0015563964843750,  0.2397155761718750,  
-0.1626586914062500,  0.1221313476562500,  0.0000000000000000,  -0.0744018554687500,  
-0.0636291503906250,  -0.0039062500000000,  0.2432556152343750,  -0.0197448730468750,  
-0.0462951660156250,  0.0329284667968750,  0.0836791992187500,  -0.2604980468750000,  
-0.1513366699218750,  0.0003356933593750,  -0.0107116699218750,  -0.0684509277343750,  
-0.0095825195312500,  -0.0976867675781250,  0.0000000000000000,  0.1468505859375000,  
-0.1484375000000000,  0.0932312011718750,  0.0211486816406250,  0.0082702636718750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1912231445312500,  
0.0216369628906250,  -0.1444091796875000,  0.1869812011718750,  -0.0225830078125000,  
0.1005554199218750,  -0.0168762207031250,  -0.0344848632812500,  0.0000000000000000,  
-0.1265258789062500,  0.1885986328125000,  -0.0653381347656250,  -0.0988464355468750
},
{
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1943664550781250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.2472839355468750,  0.3882446289062500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1639404296875000,  
0.0000000000000000,  0.0000000000000000,  -0.1376037597656250,  0.0000000000000000,  
-0.2537231445312500,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.2099914550781250,  0.0000000000000000,  0.0728149414062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0300598144531250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0357055664062500,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.4316406250000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1035766601562500,  -0.1644592285156250,  
-0.3491516113281250,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1980590820312500,  
0.0000000000000000,  0.0000000000000000,  0.3410339355468750,  0.2253417968750000,  
0.0288085937500000,  0.0015563964843750,  0.0000000000000000,  -0.1674499511718750,  
0.0859069824218750,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000
},
{
0.0000000000000000,  0.0000000000000000,  -0.2237243652343750,  0.0009155273437500,  
-0.0235595703125000,  0.1020812988281250,  0.0001220703125000,  -0.1624450683593750,  
0.0000000000000000,  0.0000000000000000,  0.1167297363281250,  -0.0262756347656250,  
-0.1492919921875000,  0.0928039550781250,  0.0000000000000000,  0.0000000000000000,  
0.1768493652343750,  -0.1221923828125000,  -0.0861206054687500,  0.1103515625000000,  
0.0950012207031250,  0.0561218261718750,  0.0000000000000000,  0.1023254394531250,  
0.0647888183593750,  -0.1358947753906250,  -0.0799255371093750,  0.0721740722656250,  
0.0000000000000000,  0.0174865722656250,  0.0000000000000000,  -0.2692565917968750,  
-0.1296997070312500,  -0.1262512207031250,  -0.3501281738281250,  -0.1721801757812500,  
0.0000000000000000,  -0.1383361816406250,  0.0526428222656250,  0.0000000000000000,  
0.0000000000000000,  -0.0440673828125000,  -0.0240783691406250,  -0.0596618652343750,  
0.0000000000000000,  0.0286560058593750,  -0.0803833007812500,  -0.1778259277343750,  
0.0793762207031250,  0.0000000000000000,  -0.1172790527343750,  -0.1042785644531250,  
0.1354675292968750,  -0.2549743652343750,  0.0000000000000000,  0.0556030273437500,  
-0.0003967285156250,  0.0588378906250000,  -0.0768127441406250,  -0.2038574218750000,  
0.0521240234375000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
-0.0701904296875000,  0.0308532714843750,  0.0000000000000000,  0.1104736328125000,  
-0.1854553222656250,  0.2934570312500000,  0.0000000000000000,  0.0680541992187500,  
0.0000000000000000,  -0.0874328613281250,  -0.0545349121093750,  0.0000000000000000,  
0.0785827636718750,  0.0144958496093750,  0.2933654785156250,  -0.0513610839843750
},
{
0.1943969726562500,  -0.0928955078125000,  0.0492553710937500,  -0.1534118652343750,  
0.0000000000000000,  0.0000000000000000,  0.0057373046875000,  0.1223144531250000,  
-0.1419677734375000,  -0.0545043945312500,  0.0000000000000000,  0.0000000000000000,  
0.1032409667968750,  0.0024414062500000,  0.0121154785156250,  -0.0235900878906250,  
-0.1539306640625000,  0.0725097656250000,  0.1216735839843750,  -0.0911254882812500,  
0.0789794921875000,  0.0000000000000000,  0.0667724609375000,  -0.2192687988281250,  
0.0785217285156250,  -0.0011596679687500,  -0.2337646484375000,  -0.1960754394531250,  
-0.1427917480468750,  0.0000000000000000,  0.1510314941406250,  0.2319335937500000,  
0.0000000000000000,  0.0000000000000000,  -0.1473388671875000,  0.1262817382812500,  
0.0224304199218750,  -0.0035095214843750,  -0.1013183593750000,  0.0697021484375000,  
0.0138854980468750,  -0.1358642578125000,  0.0000000000000000,  0.0000000000000000,  
0.0206909179687500,  -0.0768432617187500,  0.0910339355468750,  -0.0446472167968750,  
-0.2806091308593750,  -0.0774230957031250,  -0.0372619628906250,  -0.1104125976562500,  
-0.1616210937500000,  -0.1584472656250000,  -0.0474853515625000,  -0.0299377441406250,  
0.0698547363281250,  0.0000000000000000,  0.0113525390625000,  0.0000000000000000,  
0.0061950683593750,  0.0155029296875000,  -0.0104675292968750,  -0.1745910644531250,  
0.2995605468750000,  0.2489318847656250,  0.0000000000000000,  -0.0155944824218750,  
-0.2120971679687500,  0.0388793945312500,  -0.0763244628906250,  0.0066223144531250,  
0.0526428222656250,  0.2512207031250000,  0.0290832519531250,  0.0000000000000000,  
0.1296691894531250,  -0.0472717285156250,  0.0476379394531250,  0.0396118164062500
},
{
0.1257324218750000,  0.0748291015625000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.2306213378906250,  0.0077209472656250,  -0.1608581542968750,  
0.1341247558593750,  0.0000000000000000,  -0.0422058105468750,  -0.0507812500000000,  
0.0136718750000000,  0.0000000000000000,  0.1982421875000000,  0.0000000000000000,  
-0.2528686523437500,  -0.2098388671875000,  0.0676574707031250,  0.0683898925781250,  
0.1692504882812500,  0.1269226074218750,  -0.0944213867187500,  -0.0027160644531250,  
-0.0588378906250000,  0.0482788085937500,  0.0912780761718750,  0.2062072753906250,  
0.0000000000000000,  -0.2488403320312500,  0.1951293945312500,  -0.0580444335937500,  
0.0998229980468750,  -0.0700073242187500,  -0.1668701171875000,  -0.2571716308593750,  
-0.0033569335937500,  -0.0523376464843750,  0.0135803222656250,  -0.2482910156250000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.2254028320312500,  
0.0473632812500000,  -0.2592163085937500,  0.0000000000000000,  0.0000000000000000,  
-0.0701904296875000,  0.0210266113281250,  0.1016845703125000,  0.1107788085937500,  
0.0000000000000000,  0.0042114257812500,  -0.0335388183593750,  0.1218261718750000,  
0.0278625488281250,  -0.0288696289062500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1010437011718750,  0.0000000000000000,  0.0000000000000000,  
0.1659545898437500,  -0.1153869628906250,  0.1265563964843750,  0.0000000000000000,  
0.0609436035156250,  0.2192077636718750,  -0.0864257812500000,  0.0575866699218750,  
0.1118164062500000,  -0.0076599121093750,  -0.0044860839843750,  0.0000000000000000,  
-0.0898132324218750,  -0.0537414550781250,  0.0090026855468750,  0.1192016601562500
},
{
0.1558532714843750,  0.0000000000000000,  0.0000000000000000,  -0.1694946289062500,  
0.0000000000000000,  0.2198486328125000,  0.0000000000000000,  0.0000000000000000,  
0.0948486328125000,  -0.3344116210937500,  -0.0863037109375000,  0.0874328613281250,  
0.1450500488281250,  0.0948791503906250,  0.1706848144531250,  0.0979003906250000,  
0.0513305664062500,  0.0334777832031250,  0.1319274902343750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.1302490234375000,  0.0000000000000000,  
0.0652770996093750,  -0.0331115722656250,  0.0000000000000000,  0.1297912597656250,  
-0.1043090820312500,  -0.0884399414062500,  0.0000000000000000,  -0.0816650390625000,  
0.0173034667968750,  0.1463623046875000,  -0.0054321289062500,  0.0000000000000000,  
-0.0429992675781250,  0.0000000000000000,  -0.1841430664062500,  -0.0010986328125000,  
0.0000000000000000,  0.0108032226562500,  -0.2126159667968750,  0.0853271484375000,  
-0.2739257812500000,  -0.2162170410156250,  0.0000000000000000,  -0.0926818847656250,  
-0.0865783691406250,  0.0000000000000000,  -0.1363220214843750,  -0.0827331542968750,  
0.1616516113281250,  0.0349731445312500,  0.1916198730468750,  0.0863647460937500,  
-0.1804199218750000,  0.1420898437500000,  -0.0306701660156250,  0.0835876464843750,  
0.0000000000000000,  0.0097656250000000,  -0.0367736816406250,  0.1834716796875000,  
0.1778259277343750,  -0.0084533691406250,  -0.0858764648437500,  0.0255737304687500,  
-0.1094665527343750,  -0.0387573242187500,  0.0292663574218750,  0.1726989746093750,  
0.0259704589843750,  0.0722656250000000,  -0.1203613281250000,  0.0000000000000000,  
0.2112426757812500,  0.0000000000000000,  -0.1365661621093750,  0.0000000000000000
},
{
-0.0622863769531250,  0.0611572265625000,  -0.1772155761718750,  0.0002136230468750,  
0.0000000000000000,  -0.0028381347656250,  0.0000000000000000,  0.0245361328125000,  
0.0000000000000000,  -0.0654602050781250,  0.0944824218750000,  0.0135192871093750,  
-0.0433959960937500,  -0.1435852050781250,  0.0000000000000000,  0.0308837890625000,  
0.0326538085937500,  0.0944213867187500,  0.1015930175781250,  -0.1085815429687500,  
0.1783752441406250,  -0.0845031738281250,  -0.2039794921875000,  -0.4196472167968750,  
0.0048522949218750,  0.1473693847656250,  0.0000000000000000,  0.0000000000000000,  
-0.1523437500000000,  0.0192260742187500,  0.0120239257812500,  0.0423278808593750,  
-0.0265502929687500,  0.1614074707031250,  0.0000000000000000,  -0.0519409179687500,  
-0.1844787597656250,  0.0868835449218750,  -0.0194702148437500,  0.0000000000000000,  
-0.0036621093750000,  -0.0890808105468750,  -0.0672912597656250,  -0.1717529296875000,  
0.0891723632812500,  0.0000000000000000,  -0.1185302734375000,  -0.0371093750000000,  
0.0837097167968750,  0.2599182128906250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0726013183593750,  -0.1168823242187500,  -0.1003112792968750,  
0.1683654785156250,  0.0000000000000000,  0.1157836914062500,  -0.0381469726562500,  
0.0000000000000000,  0.1558837890625000,  0.0000000000000000,  -0.2052917480468750,  
-0.1187133789062500,  0.0000000000000000,  -0.2716674804687500,  -0.0908813476562500,  
0.0000000000000000,  0.0815124511718750,  -0.0115356445312500,  -0.0650634765625000,  
0.2391052246093750,  -0.0632324218750000,  0.2196655273437500,  -0.0952453613281250,  
-0.1067810058593750,  0.0000000000000000,  0.0213928222656250,  0.0000000000000000
},
{
0.0330810546875000,  0.2994079589843750,  0.0858154296875000,  -0.0093688964843750,  
0.0514221191406250,  -0.0425720214843750,  -0.0664062500000000,  -0.0266723632812500,  
-0.0286254882812500,  -0.0682678222656250,  0.0000000000000000,  0.0000000000000000,  
-0.0801391601562500,  0.0392761230468750,  0.0642089843750000,  0.0363769531250000,  
-0.1667785644531250,  -0.0409240722656250,  0.0085144042968750,  0.0000000000000000,  
-0.3039550781250000,  -0.1350708007812500,  0.0924072265625000,  0.1901245117187500,  
0.2654418945312500,  0.0000000000000000,  0.0146484375000000,  0.0910339355468750,  
-0.0703735351562500,  -0.0548400878906250,  -0.0065612792968750,  0.1265563964843750,  
0.0098571777343750,  -0.0138854980468750,  0.1438293457031250,  0.0000000000000000,  
0.0487670898437500,  0.3825683593750000,  0.0000000000000000,  0.0925598144531250,  
0.0394592285156250,  -0.1537780761718750,  0.1284484863281250,  0.0719299316406250,  
-0.1151123046875000,  -0.0974731445312500,  0.0401916503906250,  0.1860656738281250,  
0.0029602050781250,  0.0000000000000000,  -0.1010437011718750,  0.0000000000000000,  
-0.0872497558593750,  0.1065368652343750,  0.0288696289062500,  0.0714721679687500,  
0.0654602050781250,  -0.0861206054687500,  -0.0670471191406250,  0.0239562988281250,  
0.0397033691406250,  0.1949157714843750,  0.1396789550781250,  0.0000000000000000,  
-0.1854553222656250,  0.0799560546875000,  0.0702209472656250,  -0.0850524902343750,  
0.1761169433593750,  -0.0109558105468750,  -0.0916137695312500,  0.0820617675781250,  
0.0793762207031250,  -0.1764526367187500,  0.0542297363281250,  -0.0350646972656250,  
0.0000000000000000,  0.0275268554687500,  0.0681152343750000,  0.2101135253906250
},
{
0.0520629882812500,  -0.1105651855468750,  0.2188415527343750,  -0.1588439941406250,  
0.0218811035156250,  -0.0249938964843750,  0.0000000000000000,  0.1647644042968750,  
0.1047058105468750,  0.3046875000000000,  0.0000000000000000,  0.0273132324218750,  
0.0247802734375000,  -0.0731811523437500,  0.0000000000000000,  0.0070190429687500,  
0.2096862792968750,  0.0000000000000000,  -0.1771545410156250,  0.0000000000000000,  
0.0000000000000000,  0.0324096679687500,  -0.1995544433593750,  -0.0779113769531250,  
0.0948791503906250,  0.0155944824218750,  0.2529296875000000,  -0.0368957519531250,  
-0.1247863769531250,  -0.0968627929687500,  -0.0500793457031250,  0.0000000000000000,  
0.0419616699218750,  -0.2106323242187500,  -0.0451354980468750,  -0.1477050781250000,  
-0.0039367675781250,  0.1110229492187500,  0.0000000000000000,  0.1824645996093750,  
0.0000000000000000,  0.0000000000000000,  -0.0627746582031250,  -0.0504455566406250,  
-0.1082763671875000,  0.1377258300781250,  -0.0504150390625000,  0.0000000000000000,  
0.1687011718750000,  0.0000000000000000,  0.0000000000000000,  -0.0678100585937500,  
0.0097045898437500,  -0.0403442382812500,  -0.1416015625000000,  -0.2568359375000000,  
0.0484619140625000,  0.0000000000000000,  -0.1679382324218750,  0.2054443359375000,  
0.0000000000000000,  0.0000000000000000,  -0.0902709960937500,  0.0928344726562500,  
0.0000000000000000,  -0.1070556640625000,  -0.2855529785156250,  -0.0690307617187500,  
-0.1433410644531250,  -0.1450805664062500,  -0.0183715820312500,  -0.0138854980468750,  
-0.0792846679687500,  0.0000000000000000,  -0.0504150390625000,  -0.1575012207031250,  
0.0438232421875000,  0.0000000000000000,  -0.0351867675781250,  0.0802001953125000
},
{
0.0000000000000000,  0.0000000000000000,  0.1257934570312500,  -0.0690002441406250,  
-0.0688171386718750,  -0.1657409667968750,  -0.0050354003906250,  -0.0070800781250000,  
0.0000000000000000,  0.0464782714843750,  -0.0903625488281250,  -0.2444152832031250,  
-0.0512390136718750,  0.0000000000000000,  -0.0803833007812500,  -0.1829528808593750,  
0.1535949707031250,  -0.0633544921875000,  -0.1416931152343750,  -0.1108398437500000,  
-0.3108520507812500,  0.0863037109375000,  -0.1137695312500000,  0.0000000000000000,  
0.1000976562500000,  0.0080566406250000,  0.0848999023437500,  -0.0838317871093750,  
0.1459350585937500,  -0.1260375976562500,  -0.1209106445312500,  -0.0472106933593750,  
0.0647583007812500,  0.0000000000000000,  -0.0923767089843750,  0.0000000000000000,  
0.0000000000000000,  0.1694030761718750,  -0.0552978515625000,  0.1038208007812500,  
0.0311584472656250,  -0.0899658203125000,  -0.1787109375000000,  0.1145629882812500,  
-0.1808471679687500,  0.0000000000000000,  0.0253906250000000,  0.1517944335937500,  
-0.0555114746093750,  -0.1106567382812500,  -0.1473999023437500,  -0.0231323242187500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.2225646972656250,  
0.0000000000000000,  0.2252502441406250,  0.0513305664062500,  -0.0778808593750000,  
-0.0691833496093750,  0.1203308105468750,  0.0932922363281250,  0.0023498535156250,  
0.0000000000000000,  0.2256774902343750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.2520141601562500,  0.0533752441406250,  -0.1610107421875000,  
-0.0278015136718750,  0.0400695800781250,  -0.1939697265625000,  -0.0030822753906250,  
-0.2298583984375000,  -0.0529479980468750,  0.0000000000000000,  0.0000000000000000
},
{
-0.2768554687500000,  0.0542602539062500,  -0.1054077148437500,  0.0000000000000000,  
-0.2206420898437500,  -0.1395263671875000,  0.0000000000000000,  0.1615600585937500,  
-0.0734558105468750,  -0.1222839355468750,  0.0140380859375000,  0.0000000000000000,  
0.0937805175781250,  -0.2207946777343750,  0.0638122558593750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  -0.0161743164062500,  -0.0722961425781250,  
-0.0105285644531250,  0.0276489257812500,  0.1580505371093750,  0.0141601562500000,  
0.1448974609375000,  -0.2468261718750000,  0.1613464355468750,  0.0677185058593750,  
-0.1746215820312500,  0.0439453125000000,  0.1048583984375000,  0.0092468261718750,  
-0.0233459472656250,  -0.0135803222656250,  -0.1167297363281250,  0.0000000000000000,  
0.0000000000000000,  -0.0474548339843750,  0.1882324218750000,  -0.2225952148437500,  
0.1319885253906250,  0.0049133300781250,  0.0751953125000000,  0.0000000000000000,  
0.1085510253906250,  -0.1457519531250000,  -0.2121887207031250,  -0.0438842773437500,  
0.0000000000000000,  -0.0675659179687500,  -0.0957641601562500,  -0.2488403320312500,  
-0.1099853515625000,  -0.0068969726562500,  0.0000000000000000,  0.1307983398437500,  
0.0029907226562500,  0.0401916503906250,  0.0000000000000000,  0.0000000000000000,  
-0.1913452148437500,  -0.0269470214843750,  0.0560913085937500,  -0.1325073242187500,  
-0.0523071289062500,  0.0000000000000000,  -0.0165710449218750,  0.2363891601562500,  
0.0000000000000000,  0.1732482910156250,  0.0000000000000000,  0.0000000000000000,  
-0.0184631347656250,  -0.0388183593750000,  0.1906433105468750,  -0.1471557617187500,  
0.0000000000000000,  0.0123901367187500,  0.1647949218750000,  0.0000000000000000
},
{
0.0334777832031250,  0.0000000000000000,  0.1197509765625000,  0.2448425292968750,  
0.0000000000000000,  -0.0803833007812500,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1905517578125000,  0.0000000000000000,  
0.3349304199218750,  0.0864562988281250,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.1666564941406250,  0.0000000000000000,  -0.0635375976562500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.1042175292968750,  
0.3026733398437500,  -0.0470581054687500,  -0.1401672363281250,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  -0.1633300781250000,  
0.0000000000000000,  0.0000000000000000,  0.2514038085937500,  0.0000000000000000,  
0.0000000000000000,  0.3923339843750000,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  -0.1187133789062500,  0.1371765136718750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0624694824218750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  
0.1550292968750000,  0.0000000000000000,  0.0000000000000000,  0.1382751464843750,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.3800964355468750,  
-0.0407714843750000,  -0.0812377929687500,  0.1132812500000000,  0.0144348144531250,  
0.0000000000000000,  0.1123352050781250,  -0.1224670410156250,  0.0000000000000000,  
0.0000000000000000,  0.0872192382812500,  0.0000000000000000,  -0.0009155273437500,  
0.0000000000000000,  0.0000000000000000,  0.0434265136718750,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.2817077636718750,  0.0000000000000000
},
{
0.0344238281250000,  0.0000000000000000,  -0.1029052734375000,  -0.0700378417968750,  
0.1011047363281250,  0.2195739746093750,  -0.0390625000000000,  0.0000000000000000,  
-0.0437011718750000,  -0.0127563476562500,  0.0000000000000000,  0.0903930664062500,  
0.0918884277343750,  -0.0374145507812500,  -0.1679077148437500,  -0.1311950683593750,  
-0.2954101562500000,  -0.2130737304687500,  -0.0020141601562500,  -0.2103881835937500,  
0.0000000000000000,  0.0499572753906250,  -0.1026000976562500,  -0.1629028320312500,  
-0.0348510742187500,  -0.0142517089843750,  -0.0422363281250000,  0.0874328613281250,  
0.0000000000000000,  0.0000000000000000,  -0.0310668945312500,  -0.0563659667968750,  
-0.0112304687500000,  -0.3649597167968750,  0.0000000000000000,  -0.2394714355468750,  
-0.1431884765625000,  0.1396484375000000,  0.1210021972656250,  0.0739746093750000,  
0.0312500000000000,  -0.1293945312500000,  0.0574340820312500,  0.0368652343750000,  
0.0000000000000000,  0.1024475097656250,  0.0000000000000000,  0.0826416015625000,  
0.0000000000000000,  0.0545959472656250,  0.1744995117187500,  0.0639038085937500,  
-0.0598449707031250,  -0.0241394042968750,  0.0000000000000000,  0.0000000000000000,  
0.0000000000000000,  0.0000000000000000,  0.1008911132812500,  -0.0403747558593750,  
-0.0696105957031250,  -0.0286865234375000,  0.2024841308593750,  -0.1224975585937500,  
0.0000000000000000,  -0.1328430175781250,  -0.0851135253906250,  0.0000000000000000,  
-0.1345214843750000,  -0.0925598144531250,  -0.2343750000000000,  -0.1045532226562500,  
-0.1844177246093750,  -0.0454711914062500,  -0.1197509765625000,  -0.1296997070312500,  
0.0874023437500000,  0.0000000000000000,  0.0649414062500000,  -0.1555786132812500
},
{
0.0000000000000000,  0.0000000000000000,  0.0984802246093750,  0.0000000000000000,  
0.1207885742187500,  -0.0020446777343750,  -0.2895812988281250,  0.0784301757812500,  
0.0755310058593750,  0.0726623535156250,  0.0978088378906250,  0.1431274414062500,  
0.2469177246093750,  0.0000000000000000,  0.0697021484375000,  0.0017700195312500,  
0.0000000000000000,  0.0000000000000000,  0.0000000000000000,  0.0402221679687500,  
-0.1549377441406250,  -0.0852966308593750,  -0.1460876464843750,  0.0000000000000000,  
0.1073608398437500,  0.0215759277343750,  0.0157165527343750,  -0.0578613281250000,  
0.3126831054687500,  -0.0171813964843750,  -0.1982116699218750,  -0.1072998046875000,  
-0.1810913085937500,  -0.1367187500000000,  -0.0297851562500000,  -0.3801574707031250,  
0.0000000000000000,  0.0751037597656250,  0.0000000000000000,  0.0592956542968750,  
0.0144348144531250,  -0.1640319824218750,  0.0000000000000000,  -0.1023559570312500,  
-0.0189208984375000,  -0.0944519042968750,  0.0714111328125000,  0.0501708984375000,  
-0.0602111816406250,  0.0000000000000000,  0.0000000000000000,  -0.0000915527343750,  
0.0180969238281250,  0.0000000000000000,  0.0210266113281250,  0.0000000000000000,  
-0.1577453613281250,  0.0703430175781250,  0.1086730957031250,  -0.1401367187500000,  
0.0526123046875000,  -0.0783386230468750,  0.0864562988281250,  0.0000000000000000,  
-0.2343139648437500,  -0.0957336425781250,  -0.0194091796875000,  0.0000000000000000,  
0.0273437500000000,  0.1098937988281250,  0.0372619628906250,  0.0264282226562500,  
-0.1945495605468750,  -0.0935974121093750,  0.0104064941406250,  -0.0288391113281250,  
0.1619567871093750,  0.1459045410156250,  -0.2076721191406250,  0.0000610351562500
},
  },
};
