
/*

This software module was originally developed by

    Masayuki Nishiguchi (Sony Corporation)

    and edited by 

    Yuji Maeda (Sony Corporation)

    and

    Christian Mittendorf (Robert Bosch GmbH Germany)

    and

    Akira Inoue (Sony Corporation)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/



static cbook4k cb4k =
{
{
  /*****************************************************************************
   *
   * modifed shape3 - table
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^6 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^6)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
{
-90.20312500,  13.40625000
},
{
-27.62500000,  18.76562500
},
{
10.06250000,  30.76562500
},
{
6.93750000,  0.71875000
},
{
-42.54687500,  49.21875000
},
{
-1.89062500,  2.68750000
},
{
-69.67187500,  106.43750000
},
{
-18.64062500,  35.90625000
},
{
-182.23437500,  33.39062500
},
{
-37.28125000,  -2.78125000
},
{
-51.92187500,  27.62500000
},
{
-3.04687500,  -0.23437500
},
{
-38.26562500,  8.85937500
},
{
0.70312500,  -0.17187500
},
{
-112.93750000,  59.14062500
},
{
-31.40625000,  29.95312500
},
{
-18.26562500,  55.95312500
},
{
6.51562500,  4.43750000
},
{
-10.68750000,  136.82812500
},
{
-6.85937500,  39.75000000
},
{
-33.23437500,  220.81250000
},
{
7.82812500,  68.20312500
},
{
-53.89062500,  404.42187500
},
{
-56.00000000,  150.82812500
},
{
-53.14062500,  14.32812500
},
{
-2.68750000,  -7.23437500
},
{
-13.25000000,  94.79687500
},
{
5.93750000,  20.07812500
},
{
-64.98437500,  59.73437500
},
{
-17.17187500,  12.65625000
},
{
-67.62500000,  250.79687500
},
{
-40.04687500,  76.10937500
},
{
15.15625000,  5.96875000
},
{
6.06250000,  -3.12500000
},
{
121.15625000,  16.26562500
},
{
35.21875000,  28.40625000
},
{
10.90625000,  9.34375000
},
{
11.64062500,  -6.79687500
},
{
26.31250000,  41.48437500
},
{
13.15625000,  2.14062500
},
{
-75.60937500,  31.32812500
},
{
-0.78125000,  9.79687500
},
{
20.10937500,  -2.20312500
},
{
10.95312500,  -1.98437500
},
{
-2.64062500,  16.50000000
},
{
3.78125000,  -6.42187500
},
{
-13.03125000,  22.70312500
},
{
0.28125000,  1.45312500
},
{
71.64062500,  45.26562500
},
{
24.31250000,  5.43750000
},
{
147.59375000,  96.76562500
},
{
53.76562500,  15.25000000
},
{
45.15625000,  67.07812500
},
{
26.59375000,  14.03125000
},
{
82.68750000,  176.03125000
},
{
4.28125000,  47.54687500
},
{
4.76562500,  12.92187500
},
{
8.25000000,  -12.35937500
},
{
64.20312500,  0.45312500
},
{
25.53125000,  -7.17187500
},
{
-3.28125000,  26.48437500
},
{
-1.29687500,  -3.81250000
},
{
34.26562500,  111.75000000
},
{
16.73437500,  19.75000000
},
{
90.20312500,  -13.40625000
},
{
27.62500000,  -18.76562500
},
{
-10.06250000,  -30.76562500
},
{
-6.93750000,  -0.71875000
},
{
42.54687500,  -49.21875000
},
{
1.89062500,  -2.68750000
},
{
69.67187500,  -106.43750000
},
{
18.64062500,  -35.90625000
},
{
182.23437500,  -33.39062500
},
{
37.28125000,  2.78125000
},
{
51.92187500,  -27.62500000
},
{
3.04687500,  0.23437500
},
{
38.26562500,  -8.85937500
},
{
-0.70312500,  0.17187500
},
{
112.93750000,  -59.14062500
},
{
31.40625000,  -29.95312500
},
{
18.26562500,  -55.95312500
},
{
-6.51562500,  -4.43750000
},
{
10.68750000,  -136.82812500
},
{
6.85937500,  -39.75000000
},
{
33.23437500,  -220.81250000
},
{
-7.82812500,  -68.20312500
},
{
53.89062500,  -404.42187500
},
{
56.00000000,  -150.82812500
},
{
53.14062500,  -14.32812500
},
{
2.68750000,  7.23437500
},
{
13.25000000,  -94.79687500
},
{
-5.93750000,  -20.07812500
},
{
64.98437500,  -59.73437500
},
{
17.17187500,  -12.65625000
},
{
67.62500000,  -250.79687500
},
{
40.04687500,  -76.10937500
},
{
-15.15625000,  -5.96875000
},
{
-6.06250000,  3.12500000
},
{
-121.15625000,  -16.26562500
},
{
-35.21875000,  -28.40625000
},
{
-10.90625000,  -9.34375000
},
{
-11.64062500,  6.79687500
},
{
-26.31250000,  -41.48437500
},
{
-13.15625000,  -2.14062500
},
{
75.60937500,  -31.32812500
},
{
0.78125000,  -9.79687500
},
{
-20.10937500,  2.20312500
},
{
-10.95312500,  1.98437500
},
{
2.64062500,  -16.50000000
},
{
-3.78125000,  6.42187500
},
{
13.03125000,  -22.70312500
},
{
-0.28125000,  -1.45312500
},
{
-71.64062500,  -45.26562500
},
{
-24.31250000,  -5.43750000
},
{
-147.59375000,  -96.76562500
},
{
-53.76562500,  -15.25000000
},
{
-45.15625000,  -67.07812500
},
{
-26.59375000,  -14.03125000
},
{
-82.68750000,  -176.03125000
},
{
-4.28125000,  -47.54687500
},
{
-4.76562500,  -12.92187500
},
{
-8.25000000,  12.35937500
},
{
-64.20312500,  -0.45312500
},
{
-25.53125000,  7.17187500
},
{
3.28125000,  -26.48437500
},
{
1.29687500,  3.81250000
},
{
-34.26562500,  -111.75000000
},
{
-16.73437500,  -19.75000000
},
},
{
  /*****************************************************************************
   *
   * modifed shape4 - table
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^6 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^6)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
{
-57.93750000,  71.79687500,  2.71875000,  85.40625000
},
{
-103.78125000,  98.31250000,  -38.07812500,  -6.90625000
},
{
-86.76562500,  59.67187500,  28.95312500,  131.45312500
},
{
-6.64062500,  9.79687500,  -87.79687500,  55.56250000
},
{
-122.14062500,  110.54687500,  -165.62500000,  35.28125000
},
{
-61.32812500,  44.26562500,  1.12500000,  21.21875000
},
{
-172.45312500,  112.45312500,  -82.62500000,  225.53125000
},
{
-37.89062500,  67.96875000,  -5.20312500,  144.64062500
},
{
-23.67187500,  -3.35937500,  3.03125000,  -1.40625000
},
{
-24.29687500,  36.32812500,  -38.87500000,  40.93750000
},
{
-10.73437500,  10.26562500,  -49.92187500,  10.15625000
},
{
-59.12500000,  62.18750000,  -196.46875000,  -92.21875000
},
{
-18.65625000,  16.,  -33.04687500,  0.39062500
},
{
67.59375000,  76.85937500,  119.37500000,  -5.09375000
},
{
-12.39062500,  31.46875000,  -26.12500000,  108.42187500
},
{
-10.20312500,  11.78125000,  -35.71875000,  -4.96875000
},
{
-88.64062500,  17.43750000,  -128.84375000,  35.09375000
},
{
-182.62500000,  131.79687500,  -258.67187500,  -39.85937500
},
{
19.48437500,  28.98437500,  -74.20312500,  28.71875000
},
{
15.70312500,  119.29687500,  -278.71875000,  7.42187500
},
{
-20.32812500,  16.90625000,  -43.07812500,  64.43750000
},
{
-149.59375000,  26.18750000,  -133.31250000,  14.87500000
},
{
-32.12500000,  35.26562500,  -114.98437500,  68.50000000
},
{
-43.54687500,  16.23437500,  -92.17187500,  0.17187500
},
{
-16.71875000,  64.23437500,  -20.96875000,  -22.81250000
},
{
-17.43750000,  194.92187500,  -156.17187500,  -10.15625000
},
{
-26.92187500,  105.07812500,  -94.06250000,  -84.79687500
},
{
19.64062500,  200.98437500,  -315.65625000,  -148.71875000
},
{
-11.40625000,  -34.39062500,  41.81250000,  -8.87500000
},
{
-6.65625000,  35.14062500,  -40.87500000,  44.15625000
},
{
-3.68750000,  3.07812500,  -14.39062500,  -37.60937500
},
{
-5.42187500,  59.82812500,  -128.40625000,  -136.28125000
},
{
-204.03125000,  163.87500000,  -132.07812500,  152.39062500
},
{
-79.,  34.23437500,  -67.96875000,  14.14062500
},
{
-27.78125000,  245.79687500,  -74.28125000,  162.28125000
},
{
-34.93750000,  79.73437500,  -44.68750000,  62.35937500
},
{
-114.57812500,  145.35937500,  -243.71875000,  255.57812500
},
{
-94.17187500,  211.59375000,  -44.60937500,  120.89062500
},
{
-0.95312500,  189.81250000,  -198.98437500,  361.98437500
},
{
22.62500000,  233.21875000,  -101.84375000,  215.10937500
},
{
-130.23437500,  39.06250000,  17.89062500,  58.01562500
},
{
-25.51562500,  -17.84375000,  -3.92187500,  -32.89062500
},
{
-57.87500000,  44.03125000,  -65.71875000,  84.71875000
},
{
10.64062500,  16.34375000,  -73.42187500,  -67.51562500
},
{
-79.85937500,  140.14062500,  -159.18750000,  31.95312500
},
{
-50.73437500,  30.67187500,  -24.71875000,  40.70312500
},
{
-46.17187500,  124.84375000,  -223.40625000,  89.35937500
},
{
-24.68750000,  70.89062500,  -12.89062500,  108.20312500
},
{
-77.46875000,  81.76562500,  -8.95312500,  31.31250000
},
{
-76.40625000,  224.65625000,  -169.,  -68.01562500
},
{
-42.82812500,  40.62500000,  -57.57812500,  65.35937500
},
{
-85.39062500,  19.,  -138.85937500,  -61.01562500
},
{
-108.50000000,  84.06250000,  -84.59375000,  121.32812500
},
{
-50.37500000,  72.15625000,  -30.54687500,  28.37500000
},
{
5.23437500,  163.98437500,  -234.93750000,  98.60937500
},
{
-1.40625000,  70.07812500,  -20.,  59.07812500
},
{
4.53125000,  -6.21875000,  11.35937500,  -40.39062500
},
{
16.75000000,  61.06250000,  -61.89062500,  -139.03125000
},
{
-30.,  21.,  -122.18750000,  -32.92187500
},
{
70.34375000,  137.92187500,  -270.23437500,  -102.37500000
},
{
-15.10937500,  25.78125000,  28.25000000,  -67.09375000
},
{
-7.50000000,  7.70312500,  -11.71875000,  -19.64062500
},
{
15.17187500,  5.75000000,  -92.53125000,  86.62500000
},
{
-7.21875000,  31.70312500,  -125.35937500,  -32.84375000
},
{
-12.21875000,  7.34375000,  4.20312500,  13.32812500
},
{
-10.32812500,  12.54687500,  -3.48437500,  1.92187500
},
{
-33.10937500,  4.15625000,  9.92187500,  69.43750000
},
{
-9.84375000,  -16.43750000,  -4.92187500,  14.71875000
},
{
-56.18750000,  7.39062500,  -45.64062500,  29.92187500
},
{
-4.32812500,  -5.56250000,  11.85937500,  7.46875000
},
{
-35.65625000,  37.82812500,  -78.95312500,  166.18750000
},
{
-19.93750000,  12.78125000,  -17.96875000,  42.70312500
},
{
5.54687500,  -8.31250000,  26.79687500,  -15.67187500
},
{
-0.82812500,  -20.59375000,  25.95312500,  9.09375000
},
{
9.87500000,  -32.92187500,  -3.39062500,  -23.87500000
},
{
3.29687500,  -8.60937500,  -37.29687500,  -21.64062500
},
{
-9.62500000,  -4.56250000,  7.82812500,  8.23437500
},
{
-39.20312500,  5.68750000,  93.54687500,  40.64062500
},
{
6.10937500,  2.59375000,  -3.68750000,  -50.70312500
},
{
6.84375000,  -16.39062500,  24.68750000,  -2.50000000
},
{
-83.03125000,  5.07812500,  17.34375000,  4.60937500
},
{
-66.75000000,  10.20312500,  -112.87500000,  49.96875000
},
{
-0.01562500,  -2.07812500,  -5.70312500,  4.18750000
},
{
-26.76562500,  16.75000000,  -79.96875000,  -1.56250000
},
{
-3.09375000,  -4.48437500,  0.75000000,  3.29687500
},
{
-41.34375000,  -18.70312500,  -21.32812500,  9.75000000
},
{
-10.51562500,  23.57812500,  -18.01562500,  26.85937500
},
{
-3.68750000,  -23.93750000,  -13.42187500,  4.98437500
},
{
34.95312500,  0.90625000,  79.14062500,  -117.87500000
},
{
-22.92187500,  4.87500000,  -48.89062500,  -16.17187500
},
{
54.28125000,  -26.57812500,  -19.48437500,  -24.26562500
},
{
110.45312500,  12.70312500,  -186.85937500,  -115.57812500
},
{
-0.95312500,  -3.78125000,  0.90625000,  -35.75000000
},
{
-9.18750000,  2.04687500,  15.89062500,  18.87500000
},
{
61.53125000,  72.,  -6.96875000,  -160.45312500
},
{
13.64062500,  0.84375000,  -40.43750000,  -60.81250000
},
{
-117.56250000,  34.71875000,  -36.04687500,  83.20312500
},
{
-14.25000000,  9.81250000,  -14.67187500,  10.87500000
},
{
53.18750000,  26.51562500,  -17.21875000,  165.15625000
},
{
-17.75000000,  -9.96875000,  -21.51562500,  48.54687500
},
{
26.10937500,  39.51562500,  -57.71875000,  145.78125000
},
{
-10.89062500,  50.12500000,  28.21875000,  79.96875000
},
{
47.42187500,  60.04687500,  -242.64062500,  365.21875000
},
{
-57.82812500,  45.06250000,  -145.06250000,  126.78125000
},
{
-21.96875000,  -4.82812500,  -18.53125000,  11.40625000
},
{
0.96875000,  -0.96875000,  0.12500000,  0.50000000
},
{
25.57812500,  -20.39062500,  -27.17187500,  43.07812500
},
{
4.28125000,  0.28125000,  -22.81250000,  0.64062500
},
{
-36.62500000,  4.14062500,  -26.12500000,  9.82812500
},
{
-17.32812500,  62.35937500,  26.07812500,  31.50000000
},
{
6.40625000,  14.42187500,  -161.50000000,  108.35937500
},
{
-6.29687500,  2.31250000,  -25.50000000,  57.71875000
},
{
-20.28125000,  -12.60937500,  3.93750000,  15.84375000
},
{
5.07812500,  62.48437500,  -49.79687500,  -50.45312500
},
{
16.76562500,  21.37500000,  -37.23437500,  76.62500000
},
{
-19.17187500,  3.98437500,  -22.46875000,  -10.40625000
},
{
-10.46875000,  0.21875000,  -41.93750000,  49.01562500
},
{
-4.48437500,  1.60937500,  0.98437500,  2.10937500
},
{
3.98437500,  54.53125000,  -181.42187500,  149.95312500
},
{
8.15625000,  0.56250000,  -43.48437500,  65.93750000
},
{
28.67187500,  -38.32812500,  22.01562500,  -16.29687500
},
{
3.40625000,  -16.,  -12.70312500,  -35.59375000
},
{
-0.84375000,  2.90625000,  -6.37500000,  -13.81250000
},
{
62.01562500,  66.37500000,  -79.64062500,  -72.93750000
},
{
0.40625000,  -15.48437500,  26.07812500,  -13.46875000
},
{
-0.29687500,  -2.14062500,  3.82812500,  -0.84375000
},
{
16.95312500,  97.89062500,  -5.87500000,  24.03125000
},
{
-1.68750000,  -2.03125000,  -26.96875000,  -16.56250000
},
{
-17.51562500,  9.92187500,  -3.68750000,  15.43750000
},
{
-27.14062500,  18.14062500,  12.04687500,  16.34375000
},
{
-22.17187500,  15.92187500,  -11.87500000,  22.14062500
},
{
-5.56250000,  2.25000000,  -6.40625000,  4.21875000
},
{
-70.57812500,  6.84375000,  -11.28125000,  26.
},
{
-11.92187500,  49.31250000,  86.39062500,  151.25000000
},
{
-37.67187500,  27.04687500,  30.21875000,  125.43750000
},
{
26.06250000,  -16.25000000,  25.45312500,  44.81250000
},
{
-106.62500000,  72.65625000,  -4.92187500,  -44.45312500
},
{
-12.65625000,  60.78125000,  84.62500000,  61.73437500
},
{
-17.,  -3.89062500,  -6.06250000,  -4.84375000
},
{
-26.78125000,  -11.01562500,  -37.46875000,  -8.12500000
},
{
19.42187500,  130.39062500,  103.07812500,  4.71875000
},
{
9.29687500,  201.84375000,  212.37500000,  144.34375000
},
{
-0.23437500,  -11.62500000,  12.64062500,  -58.68750000
},
{
40.67187500,  44.01562500,  138.,  10.96875000
},
{
-56.07812500,  45.78125000,  4.28125000,  -21.25000000
},
{
-178.90625000,  111.82812500,  -18.28125000,  -7.40625000
},
{
-7.59375000,  2.15625000,  -3.15625000,  -11.34375000
},
{
-3.09375000,  51.14062500,  -80.92187500,  33.75000000
},
{
-10.14062500,  -38.50000000,  6.40625000,  28.67187500
},
{
-47.07812500,  -3.45312500,  -17.07812500,  39.70312500
},
{
5.62500000,  7.15625000,  -9.32812500,  -29.92187500
},
{
-2.01562500,  1.17187500,  -1.17187500,  2.37500000
},
{
-87.48437500,  159.07812500,  -23.85937500,  -203.15625000
},
{
-86.54687500,  44.32812500,  -27.65625000,  -26.01562500
},
{
-32.70312500,  28.92187500,  -69.51562500,  -82.76562500
},
{
-0.53125000,  118.25000000,  -134.54687500,  -54.78125000
},
{
-14.96875000,  36.87500000,  -23.68750000,  -70.14062500
},
{
18.89062500,  37.,  115.59375000,  24.06250000
},
{
96.89062500,  85.43750000,  -27.26562500,  -121.10937500
},
{
28.65625000,  3.18750000,  -56.57812500,  -28.79687500
},
{
-65.50000000,  31.29687500,  -19.73437500,  148.21875000
},
{
0.75000000,  1.57812500,  -22.89062500,  22.51562500
},
{
-31.04687500,  82.21875000,  17.90625000,  73.12500000
},
{
5.29687500,  6.95312500,  -1.04687500,  19.18750000
},
{
-147.46875000,  153.85937500,  -55.21875000,  73.54687500
},
{
-27.65625000,  44.67187500,  15.50000000,  49.62500000
},
{
94.06250000,  160.34375000,  -12.09375000,  166.35937500
},
{
-0.18750000,  16.06250000,  -19.50000000,  156.42187500
},
{
-32.04687500,  -6.56250000,  -0.78125000,  14.93750000
},
{
10.18750000,  -10.68750000,  28.93750000,  28.57812500
},
{
-1.45312500,  2.90625000,  -6.71875000,  17.98437500
},
{
1.46875000,  -4.07812500,  -37.40625000,  36.14062500
},
{
-31.34375000,  7.87500000,  -26.37500000,  28.98437500
},
{
3.32812500,  17.93750000,  74.25000000,  116.53125000
},
{
-12.71875000,  3.59375000,  -69.87500000,  107.78125000
},
{
-2.57812500,  1.48437500,  -55.60937500,  34.03125000
},
{
-30.67187500,  -32.12500000,  3.23437500,  34.56250000
},
{
-43.26562500,  83.28125000,  -22.03125000,  -22.54687500
},
{
0.39062500,  5.17187500,  2.46875000,  16.37500000
},
{
-12.92187500,  -10.15625000,  -34.51562500,  9.71875000
},
{
-81.85937500,  0.51562500,  -24.95312500,  155.64062500
},
{
-15.18750000,  -18.25000000,  -5.70312500,  31.92187500
},
{
-21.87500000,  25.78125000,  -69.65625000,  63.92187500
},
{
25.46875000,  4.76562500,  -58.25000000,  55.82812500
},
{
-79.54687500,  26.45312500,  43.89062500,  -40.62500000
},
{
-4.03125000,  -7.57812500,  -27.06250000,  4.12500000
},
{
9.06250000,  -42.73437500,  -31.46875000,  39.96875000
},
{
1.95312500,  2.10937500,  -185.01562500,  46.39062500
},
{
-29.03125000,  -16.62500000,  -15.32812500,  26.15625000
},
{
-43.32812500,  1.15625000,  -71.53125000,  25.32812500
},
{
20.,  55.54687500,  -53.39062500,  -41.12500000
},
{
-33.64062500,  51.68750000,  -249.37500000,  37.98437500
},
{
-66.26562500,  14.96875000,  6.50000000,  -13.51562500
},
{
-48.87500000,  -41.79687500,  -9.53125000,  -13.40625000
},
{
16.03125000,  -37.84375000,  -3.29687500,  -8.92187500
},
{
-3.56250000,  -49.39062500,  15.75000000,  -31.54687500
},
{
-0.31250000,  -0.98437500,  -0.84375000,  -0.64062500
},
{
-15.40625000,  -23.71875000,  22.67187500,  35.85937500
},
{
0.14062500,  21.68750000,  -0.45312500,  -51.35937500
},
{
-7.12500000,  -6.92187500,  -1.73437500,  9.37500000
},
{
-36.79687500,  0.59375000,  136.07812500,  -108.04687500
},
{
-24.48437500,  -13.12500000,  29.98437500,  -1.82812500
},
{
56.20312500,  0.75000000,  -52.10937500,  -93.95312500
},
{
26.46875000,  -36.28125000,  4.92187500,  -24.67187500
},
{
-2.81250000,  27.62500000,  -19.10937500,  -73.09375000
},
{
-79.90625000,  50.95312500,  133.03125000,  30.46875000
},
{
99.78125000,  2.79687500,  -19.51562500,  -261.01562500
},
{
17.53125000,  12.70312500,  -15.07812500,  -82.76562500
},
{
-164.,  103.35937500,  -33.29687500,  -152.42187500
},
{
-123.12500000,  18.53125000,  -6.35937500,  6.14062500
},
{
-24.98437500,  0.31250000,  -58.82812500,  -44.54687500
},
{
-13.15625000,  -1.92187500,  7.43750000,  -10.93750000
},
{
-14.06250000,  7.70312500,  -1.81250000,  -47.51562500
},
{
-16.32812500,  -6.35937500,  -5.18750000,  9.20312500
},
{
-11.67187500,  80.64062500,  -47.21875000,  -169.15625000
},
{
71.45312500,  26.43750000,  5.29687500,  -13.59375000
},
{
-60.64062500,  55.60937500,  79.29687500,  -305.78125000
},
{
-41.43750000,  19.15625000,  6.26562500,  -77.62500000
},
{
109.96875000,  24.45312500,  -23.17187500,  -188.70312500
},
{
14.04687500,  -14.34375000,  -9.62500000,  -36.39062500
},
{
124.,  49.40625000,  54.79687500,  -102.06250000
},
{
62.03125000,  2.92187500,  60.73437500,  26.90625000
},
{
198.76562500,  202.73437500,  -14.71875000,  -307.84375000
},
{
187.56250000,  88.42187500,  38.87500000,  -73.28125000
},
{
-5.50000000,  4.15625000,  -14.23437500,  21.84375000
},
{
-17.01562500,  -33.73437500,  -10.92187500,  -3.79687500
},
{
41.07812500,  -9.15625000,  -17.96875000,  33.45312500
},
{
-2.01562500,  -13.95312500,  6.20312500,  12.56250000
},
{
-43.04687500,  4.51562500,  -30.34375000,  53.67187500
},
{
-4.48437500,  3.32812500,  10.67187500,  10.95312500
},
{
56.48437500,  71.87500000,  -107.53125000,  97.17187500
},
{
-21.79687500,  0.35937500,  -15.46875000,  102.48437500
},
{
-34.65625000,  -40.20312500,  9.46875000,  -43.20312500
},
{
-10.57812500,  -61.73437500,  23.90625000,  1.34375000
},
{
2.03125000,  -50.04687500,  -16.12500000,  -21.31250000
},
{
-4.31250000,  -58.48437500,  -14.35937500,  7.14062500
},
{
-7.32812500,  1.98437500,  6.68750000,  -0.70312500
},
{
-25.04687500,  6.04687500,  15.93750000,  1.25000000
},
{
27.34375000,  27.82812500,  -24.92187500,  -59.54687500
},
{
2.45312500,  -3.17187500,  -4.96875000,  10.73437500
},
{
-36.56250000,  1.98437500,  -34.85937500,  -42.65625000
},
{
-8.21875000,  1.04687500,  0.59375000,  10.28125000
},
{
39.95312500,  -28.04687500,  15.40625000,  -1.76562500
},
{
10.62500000,  -25.59375000,  -5.51562500,  -4.15625000
},
{
-17.18750000,  0.20312500,  -26.98437500,  24.14062500
},
{
13.10937500,  -44.81250000,  -1.31250000,  9.26562500
},
{
-0.14062500,  90.40625000,  -8.82812500,  31.62500000
},
{
-2.31250000,  0.01562500,  -1.29687500,  10.23437500
},
{
-22.89062500,  3.53125000,  -4.98437500,  -79.60937500
},
{
-30.84375000,  -33.09375000,  -21.15625000,  -15.73437500
},
{
49.21875000,  35.81250000,  0.21875000,  -43.
},
{
12.18750000,  -44.12500000,  -39.07812500,  -2.17187500
},
{
14.96875000,  78.50000000,  20.67187500,  3.93750000
},
{
0.17187500,  -0.39062500,  0.10937500,  5.53125000
},
{
144.31250000,  213.04687500,  -4.57812500,  -76.35937500
},
{
22.85937500,  60.73437500,  -33.81250000,  26.53125000
},
{
-11.06250000,  59.93750000,  -98.65625000,  -54.78125000
},
{
-30.78125000,  272.98437500,  -194.75000000,  -5.48437500
},
{
-13.57812500,  3.25000000,  -2.62500000,  28.84375000
},
{
-16.73437500,  85.28125000,  -37.76562500,  8.89062500
},
{
-22.87500000,  17.73437500,  -38.48437500,  27.07812500
},
{
-18.54687500,  48.35937500,  -90.48437500,  30.50000000
},
{
-64.98437500,  52.06250000,  -11.46875000,  61.09375000
},
{
35.54687500,  169.07812500,  6.17187500,  75.10937500
},
{
1.34375000,  -9.75000000,  -17.92187500,  -3.84375000
},
{
-17.45312500,  70.34375000,  -65.60937500,  -43.18750000
},
{
2.59375000,  0.81250000,  -1.84375000,  2.70312500
},
{
7.01562500,  53.50000000,  -50.53125000,  10.87500000
},
{
-4.85937500,  -26.68750000,  42.82812500,  -32.54687500
},
{
-43.51562500,  64.89062500,  57.82812500,  43.12500000
},
{
-17.73437500,  4.71875000,  8.59375000,  -24.81250000
},
{
-18.50000000,  15.17187500,  0.14062500,  66.25000000
},
{
-12.62500000,  1.06250000,  -22.25000000,  0.40625000
},
{
-80.25000000,  96.67187500,  -49.73437500,  -55.68750000
},
{
-0.10937500,  -2.93750000,  -15.,  5.06250000
},
{
11.68750000,  19.56250000,  -118.45312500,  25.06250000
},
{
-0.21875000,  -14.25000000,  34.45312500,  -27.95312500
},
{
-21.95312500,  11.73437500,  -21.51562500,  8.65625000
},
{
-10.12500000,  -8.03125000,  -16.28125000,  13.06250000
},
{
2.23437500,  14.89062500,  -8.04687500,  24.21875000
},
{
-13.79687500,  -11.32812500,  9.56250000,  -59.90625000
},
{
-10.34375000,  37.,  -41.42187500,  21.10937500
},
{
26.96875000,  66.01562500,  15.20312500,  -24.53125000
},
{
73.04687500,  200.60937500,  -145.67187500,  -42.34375000
},
{
-56.57812500,  2.71875000,  194.12500000,  -79.93750000
},
{
-22.39062500,  -26.45312500,  23.76562500,  -32.32812500
},
{
-4.17187500,  16.62500000,  69.68750000,  -33.81250000
},
{
-16.64062500,  50.26562500,  -34.34375000,  26.70312500
},
{
-101.29687500,  1.15625000,  -42.10937500,  81.45312500
},
{
31.60937500,  55.98437500,  -86.59375000,  -22.15625000
},
{
12.17187500,  55.79687500,  -9.17187500,  78.17187500
},
{
134.75000000,  81.46875000,  -8.78125000,  49.03125000
},
{
-1.71875000,  44.50000000,  -93.,  99.92187500
},
{
35.81250000,  50.79687500,  -45.70312500,  38.46875000
},
{
16.15625000,  166.35937500,  -154.70312500,  125.62500000
},
{
227.93750000,  179.65625000,  -20.59375000,  134.39062500
},
{
6.45312500,  34.46875000,  14.59375000,  -51.18750000
},
{
2.18750000,  26.65625000,  -0.34375000,  21.64062500
},
{
3.21875000,  25.32812500,  -3.26562500,  9.43750000
},
{
93.04687500,  160.85937500,  1.12500000,  -32.79687500
},
{
0.29687500,  17.62500000,  -30.23437500,  -121.39062500
},
{
-21.40625000,  17.87500000,  34.42187500,  5.90625000
},
{
-43.67187500,  10.45312500,  -46.93750000,  59.71875000
},
{
116.20312500,  29.18750000,  -64.46875000,  14.14062500
},
{
-6.25000000,  0.40625000,  8.65625000,  -47.96875000
},
{
-56.82812500,  35.67187500,  -58.01562500,  -79.
},
{
-6.76562500,  14.07812500,  3.46875000,  -11.12500000
},
{
-10.92187500,  131.50000000,  12.03125000,  -0.71875000
},
{
17.39062500,  44.07812500,  42.06250000,  -43.10937500
},
{
-4.59375000,  10.89062500,  6.25000000,  1.53125000
},
{
23.81250000,  31.07812500,  -55.50000000,  62.50000000
},
{
80.62500000,  77.,  33.93750000,  24.07812500
},
{
-16.62500000,  26.70312500,  44.92187500,  -239.85937500
},
{
-11.87500000,  99.81250000,  -7.68750000,  -54.21875000
},
{
-31.65625000,  69.81250000,  -24.39062500,  -79.01562500
},
{
0.17187500,  299.40625000,  -104.57812500,  -97.92187500
},
{
60.70312500,  40.67187500,  153.50000000,  -265.50000000
},
{
15.39062500,  27.21875000,  5.29687500,  -103.62500000
},
{
33.07812500,  5.46875000,  18.34375000,  -87.45312500
},
{
42.15625000,  187.45312500,  -64.45312500,  -90.60937500
},
{
-3.62500000,  4.75000000,  -17.51562500,  2.21875000
},
{
-58.90625000,  63.32812500,  -96.92187500,  35.46875000
},
{
-0.03125000,  -36.26562500,  -9.32812500,  16.51562500
},
{
-7.04687500,  10.64062500,  -10.48437500,  9.35937500
},
{
9.51562500,  5.92187500,  18.71875000,  22.68750000
},
{
-55.96875000,  -15.45312500,  24.46875000,  24.25000000
},
{
8.29687500,  18.65625000,  -17.28125000,  28.92187500
},
{
17.43750000,  11.18750000,  25.79687500,  37.54687500
},
{
-1.26562500,  -33.98437500,  27.89062500,  -6.70312500
},
{
-37.50000000,  8.26562500,  20.93750000,  23.40625000
},
{
56.46875000,  -28.06250000,  8.53125000,  -5.60937500
},
{
28.89062500,  -18.26562500,  -0.57812500,  8.78125000
},
{
-55.31250000,  -17.21875000,  37.60937500,  -6.10937500
},
{
-199.43750000,  9.25000000,  117.35937500,  38.01562500
},
{
-11.17187500,  109.28125000,  53.60937500,  -123.65625000
},
{
-39.31250000,  -25.26562500,  31.29687500,  -20.78125000
},
{
-10.21875000,  -11.01562500,  4.,  0.89062500
},
{
-2.79687500,  10.20312500,  -16.98437500,  -11.60937500
},
{
51.87500000,  -4.96875000,  10.56250000,  3.95312500
},
{
-2.40625000,  -7.39062500,  -9.60937500,  7.45312500
},
{
-11.48437500,  -14.75000000,  20.96875000,  -5.59375000
},
{
-7.85937500,  -11.59375000,  28.17187500,  21.76562500
},
{
4.84375000,  17.68750000,  74.48437500,  8.46875000
},
{
2.09375000,  -0.06250000,  4.50000000,  0.18750000
},
{
18.28125000,  12.93750000,  61.84375000,  -27.10937500
},
{
-29.32812500,  9.93750000,  2.81250000,  11.31250000
},
{
228.57812500,  7.39062500,  34.42187500,  -83.03125000
},
{
77.48437500,  50.31250000,  -28.92187500,  11.18750000
},
{
-47.37500000,  37.,  104.10937500,  -16.21875000
},
{
-80.26562500,  16.95312500,  33.92187500,  97.14062500
},
{
74.57812500,  112.09375000,  191.06250000,  -103.57812500
},
{
26.48437500,  31.50000000,  75.17187500,  -12.35937500
},
{
-10.93750000,  3.21875000,  -10.79687500,  15.60937500
},
{
-14.54687500,  3.04687500,  -7.95312500,  3.96875000
},
{
-3.28125000,  5.53125000,  0.37500000,  79.78125000
},
{
22.82812500,  -4.73437500,  7.18750000,  20.28125000
},
{
27.60937500,  5.03125000,  19.93750000,  116.20312500
},
{
-16.76562500,  1.20312500,  47.21875000,  -3.84375000
},
{
-5.12500000,  61.07812500,  -80.68750000,  203.93750000
},
{
77.53125000,  24.29687500,  21.03125000,  76.40625000
},
{
2.56250000,  -12.89062500,  2.31250000,  -10.37500000
},
{
-11.12500000,  23.96875000,  29.40625000,  1.56250000
},
{
25.60937500,  -23.07812500,  24.23437500,  11.23437500
},
{
7.15625000,  25.06250000,  26.39062500,  10.64062500
},
{
-7.68750000,  10.82812500,  31.81250000,  -11.75000000
},
{
-46.14062500,  53.46875000,  202.81250000,  24.15625000
},
{
-26.31250000,  21.85937500,  -11.60937500,  41.59375000
},
{
2.65625000,  15.23437500,  43.03125000,  53.15625000
},
{
15.64062500,  -17.54687500,  15.07812500,  9.76562500
},
{
-20.28125000,  -11.03125000,  5.98437500,  -14.26562500
},
{
61.82812500,  13.03125000,  -0.68750000,  43.76562500
},
{
9.03125000,  12.60937500,  9.20312500,  4.90625000
},
{
23.29687500,  -35.93750000,  38.10937500,  4.29687500
},
{
5.98437500,  -21.67187500,  13.48437500,  -9.64062500
},
{
48.59375000,  11.92187500,  -50.10937500,  59.
},
{
5.46875000,  5.39062500,  3.96875000,  4.25000000
},
{
-22.96875000,  -6.48437500,  22.60937500,  -39.95312500
},
{
-11.07812500,  7.62500000,  6.64062500,  -5.57812500
},
{
103.89062500,  1.92187500,  44.,  9.
},
{
10.43750000,  111.43750000,  -11.01562500,  -27.42187500
},
{
6.31250000,  27.28125000,  141.20312500,  -31.50000000
},
{
1.21875000,  -9.04687500,  65.50000000,  12.64062500
},
{
24.51562500,  73.96875000,  40.15625000,  9.70312500
},
{
14.81250000,  33.03125000,  -7.51562500,  7.35937500
},
{
-3.59375000,  -6.31250000,  -14.23437500,  -7.75000000
},
{
5.68750000,  95.53125000,  -53.20312500,  12.06250000
},
{
3.42187500,  -21.65625000,  -9.21875000,  6.12500000
},
{
2.06250000,  6.39062500,  -0.18750000,  5.10937500
},
{
-6.48437500,  -21.12500000,  8.23437500,  13.10937500
},
{
19.71875000,  19.51562500,  17.06250000,  68.20312500
},
{
-4.93750000,  -2.14062500,  4.43750000,  -9.
},
{
16.43750000,  12.70312500,  12.25000000,  10.65625000
},
{
-17.70312500,  11.06250000,  -0.92187500,  -12.53125000
},
{
-17.53125000,  -0.01562500,  28.17187500,  34.18750000
},
{
-2.18750000,  -13.56250000,  -10.90625000,  -20.10937500
},
{
0.46875000,  -2.98437500,  -3.54687500,  -5.03125000
},
{
-6.87500000,  -19.32812500,  39.15625000,  7.51562500
},
{
-7.21875000,  3.46875000,  181.75000000,  108.03125000
},
{
-10.65625000,  35.34375000,  -51.96875000,  -115.68750000
},
{
10.82812500,  19.53125000,  1.07812500,  20.68750000
},
{
-13.07812500,  -10.46875000,  8.78125000,  -20.62500000
},
{
-52.18750000,  -11.92187500,  0.23437500,  8.78125000
},
{
0.31250000,  -6.70312500,  -2.15625000,  2.73437500
},
{
-0.84375000,  4.73437500,  -10.04687500,  6.85937500
},
{
10.81250000,  -24.82812500,  15.78125000,  -1.51562500
},
{
3.35937500,  0.79687500,  7.75000000,  5.48437500
},
{
-6.31250000,  -8.89062500,  59.71875000,  -12.82812500
},
{
8.21875000,  45.20312500,  26.64062500,  87.68750000
},
{
-23.68750000,  4.09375000,  23.48437500,  -61.31250000
},
{
-19.17187500,  -7.31250000,  17.64062500,  13.06250000
},
{
-12.70312500,  2.15625000,  -0.26562500,  -1.92187500
},
{
-3.26562500,  11.71875000,  -75.39062500,  -50.76562500
},
{
-12.32812500,  -2.81250000,  27.32812500,  -29.32812500
},
{
-5.60937500,  27.71875000,  30.23437500,  50.81250000
},
{
-1.46875000,  65.84375000,  76.71875000,  -28.64062500
},
{
-60.65625000,  124.32812500,  -86.10937500,  60.23437500
},
{
-5.73437500,  -0.73437500,  -5.34375000,  19.56250000
},
{
-2.09375000,  3.57812500,  -2.32812500,  -3.75000000
},
{
3.90625000,  6.15625000,  -13.01562500,  11.18750000
},
{
33.14062500,  -3.15625000,  4.15625000,  36.10937500
},
{
-65.78125000,  1.81250000,  -11.68750000,  63.54687500
},
{
12.28125000,  -26.51562500,  2.29687500,  36.01562500
},
{
87.87500000,  19.50000000,  -81.25000000,  60.56250000
},
{
79.15625000,  5.50000000,  -12.,  154.59375000
},
{
3.18750000,  -5.96875000,  -2.40625000,  -3.71875000
},
{
-2.87500000,  -13.73437500,  -1.48437500,  -7.26562500
},
{
-27.75000000,  -21.03125000,  -10.14062500,  -0.67187500
},
{
-8.42187500,  27.43750000,  -64.98437500,  -6.95312500
},
{
5.84375000,  -10.67187500,  -9.78125000,  -18.64062500
},
{
-3.57812500,  28.65625000,  -7.70312500,  39.84375000
},
{
-19.78125000,  2.32812500,  -45.89062500,  17.01562500
},
{
50.51562500,  143.01562500,  -146.53125000,  49.12500000
},
{
17.95312500,  -23.40625000,  2.71875000,  0.68750000
},
{
-5.48437500,  5.18750000,  -0.34375000,  -2.57812500
},
{
33.15625000,  -1.82812500,  9.64062500,  5.90625000
},
{
-30.37500000,  38.17187500,  -53.57812500,  6.29687500
},
{
-23.37500000,  0.29687500,  0.90625000,  33.82812500
},
{
57.39062500,  3.60937500,  -23.45312500,  79.45312500
},
{
10.92187500,  54.82812500,  31.92187500,  40.45312500
},
{
55.60937500,  184.34375000,  -50.42187500,  92.73437500
},
{
-10.28125000,  -17.14062500,  -6.95312500,  -43.50000000
},
{
-53.90625000,  27.26562500,  -38.01562500,  -31.26562500
},
{
-104.98437500,  57.85937500,  -32.51562500,  26.46875000
},
{
-110.03125000,  142.71875000,  -213.60937500,  -40.84375000
},
{
5.68750000,  16.54687500,  9.84375000,  -79.14062500
},
{
-3.56250000,  93.79687500,  -61.64062500,  56.06250000
},
{
13.23437500,  70.93750000,  -98.84375000,  11.59375000
},
{
51.29687500,  250.15625000,  -269.17187500,  25.56250000
},
{
4.45312500,  -5.65625000,  5.03125000,  -10.50000000
},
{
-7.39062500,  3.10937500,  -12.28125000,  -3.35937500
},
{
-5.76562500,  3.57812500,  12.46875000,  -17.18750000
},
{
2.84375000,  -31.53125000,  -9.98437500,  -7.25000000
},
{
-8.76562500,  1.73437500,  0.85937500,  -26.03125000
},
{
9.10937500,  -33.73437500,  22.09375000,  11.73437500
},
{
-69.04687500,  53.84375000,  59.21875000,  -114.09375000
},
{
0.60937500,  8.09375000,  -0.23437500,  -23.35937500
},
{
-15.87500000,  15.46875000,  47.26562500,  -27.48437500
},
{
-36.04687500,  -3.12500000,  14.81250000,  -9.75000000
},
{
-43.17187500,  36.85937500,  19.,  -115.68750000
},
{
-3.60937500,  11.75000000,  9.01562500,  -21.14062500
},
{
-11.75000000,  19.70312500,  36.34375000,  -158.04687500
},
{
-20.54687500,  11.56250000,  87.93750000,  19.56250000
},
{
-84.17187500,  124.34375000,  26.42187500,  -300.37500000
},
{
15.71875000,  88.93750000,  70.68750000,  -128.59375000
},
{
-46.,  28.90625000,  35.34375000,  -28.87500000
},
{
-27.06250000,  -21.12500000,  20.95312500,  14.93750000
},
{
-3.03125000,  21.34375000,  51.67187500,  -7.81250000
},
{
1.,  -4.57812500,  3.,  -5.54687500
},
{
-7.12500000,  13.23437500,  17.51562500,  -31.23437500
},
{
-0.84375000,  -8.42187500,  8.20312500,  0.48437500
},
{
37.29687500,  142.71875000,  141.89062500,  -114.50000000
},
{
-31.68750000,  54.93750000,  31.29687500,  3.35937500
},
{
-148.98437500,  11.06250000,  177.95312500,  -115.34375000
},
{
-113.43750000,  62.,  91.70312500,  3.56250000
},
{
26.67187500,  28.84375000,  73.17187500,  -71.89062500
},
{
-14.89062500,  -4.09375000,  14.81250000,  1.50000000
},
{
-3.65625000,  61.25000000,  119.71875000,  -127.48437500
},
{
3.09375000,  11.42187500,  16.53125000,  -25.53125000
},
{
12.68750000,  178.03125000,  159.81250000,  -222.93750000
},
{
-19.65625000,  53.01562500,  71.45312500,  -77.98437500
},
{
1.17187500,  -17.95312500,  0.98437500,  -1.14062500
},
{
-47.53125000,  -48.29687500,  14.10937500,  1.04687500
},
{
38.31250000,  -41.59375000,  26.17187500,  24.43750000
},
{
25.18750000,  -54.03125000,  0.82812500,  -8.48437500
},
{
2.57812500,  -41.54687500,  11.64062500,  32.48437500
},
{
4.45312500,  -16.37500000,  7.,  5.68750000
},
{
-10.78125000,  6.15625000,  -22.51562500,  33.21875000
},
{
19.84375000,  -18.79687500,  0.31250000,  30.95312500
},
{
-4.98437500,  -15.42187500,  10.76562500,  -3.75000000
},
{
3.31250000,  -8.18750000,  5.53125000,  1.14062500
},
{
-38.65625000,  -9.46875000,  -1.65625000,  -18.01562500
},
{
-7.84375000,  -1.25000000,  -1.65625000,  -0.20312500
},
{
-20.42187500,  -47.34375000,  3.75000000,  -30.59375000
},
{
-2.79687500,  34.35937500,  30.57812500,  21.45312500
},
{
-62.93750000,  14.60937500,  -36.89062500,  -150.29687500
},
{
-1.21875000,  1.43750000,  -36.82812500,  -4.03125000
},
{
35.17187500,  -14.71875000,  42.15625000,  22.09375000
},
{
2.85937500,  -32.43750000,  13.90625000,  3.98437500
},
{
198.56250000,  4.15625000,  54.93750000,  22.65625000
},
{
40.90625000,  -36.96875000,  29.65625000,  -18.18750000
},
{
-0.51562500,  -1.,  9.92187500,  3.07812500
},
{
30.01562500,  -48.03125000,  -13.07812500,  18.31250000
},
{
23.59375000,  52.23437500,  59.71875000,  41.28125000
},
{
5.12500000,  28.75000000,  -8.87500000,  41.06250000
},
{
-30.43750000,  27.06250000,  63.65625000,  -12.09375000
},
{
-17.20312500,  5.28125000,  7.14062500,  3.93750000
},
{
41.45312500,  22.23437500,  24.31250000,  57.06250000
},
{
-44.54687500,  35.92187500,  -62.82812500,  12.15625000
},
{
-15.26562500,  10.96875000,  22.48437500,  -16.14062500
},
{
8.,  2.96875000,  -19.60937500,  17.70312500
},
{
48.35937500,  36.96875000,  67.14062500,  -62.39062500
},
{
87.54687500,  106.26562500,  -51.21875000,  75.39062500
},
{
57.93750000,  -71.79687500,  -2.71875000,  -85.40625000
},
{
103.78125000,  -98.31250000,  38.07812500,  6.90625000
},
{
86.76562500,  -59.67187500,  -28.95312500,  -131.45312500
},
{
6.64062500,  -9.79687500,  87.79687500,  -55.56250000
},
{
122.14062500,  -110.54687500,  165.62500000,  -35.28125000
},
{
61.32812500,  -44.26562500,  -1.12500000,  -21.21875000
},
{
172.45312500,  -112.45312500,  82.62500000,  -225.53125000
},
{
37.89062500,  -67.96875000,  5.20312500,  -144.64062500
},
{
23.67187500,  3.35937500,  -3.03125000,  1.40625000
},
{
24.29687500,  -36.32812500,  38.87500000,  -40.93750000
},
{
10.73437500,  -10.26562500,  49.92187500,  -10.15625000
},
{
59.12500000,  -62.18750000,  196.46875000,  92.21875000
},
{
18.65625000,  -16.,  33.04687500,  -0.39062500
},
{
-67.59375000,  -76.85937500,  -119.37500000,  5.09375000
},
{
12.39062500,  -31.46875000,  26.12500000,  -108.42187500
},
{
10.20312500,  -11.78125000,  35.71875000,  4.96875000
},
{
88.64062500,  -17.43750000,  128.84375000,  -35.09375000
},
{
182.62500000,  -131.79687500,  258.67187500,  39.85937500
},
{
-19.48437500,  -28.98437500,  74.20312500,  -28.71875000
},
{
-15.70312500,  -119.29687500,  278.71875000,  -7.42187500
},
{
20.32812500,  -16.90625000,  43.07812500,  -64.43750000
},
{
149.59375000,  -26.18750000,  133.31250000,  -14.87500000
},
{
32.12500000,  -35.26562500,  114.98437500,  -68.50000000
},
{
43.54687500,  -16.23437500,  92.17187500,  -0.17187500
},
{
16.71875000,  -64.23437500,  20.96875000,  22.81250000
},
{
17.43750000,  -194.92187500,  156.17187500,  10.15625000
},
{
26.92187500,  -105.07812500,  94.06250000,  84.79687500
},
{
-19.64062500,  -200.98437500,  315.65625000,  148.71875000
},
{
11.40625000,  34.39062500,  -41.81250000,  8.87500000
},
{
6.65625000,  -35.14062500,  40.87500000,  -44.15625000
},
{
3.68750000,  -3.07812500,  14.39062500,  37.60937500
},
{
5.42187500,  -59.82812500,  128.40625000,  136.28125000
},
{
204.03125000,  -163.87500000,  132.07812500,  -152.39062500
},
{
79.,  -34.23437500,  67.96875000,  -14.14062500
},
{
27.78125000,  -245.79687500,  74.28125000,  -162.28125000
},
{
34.93750000,  -79.73437500,  44.68750000,  -62.35937500
},
{
114.57812500,  -145.35937500,  243.71875000,  -255.57812500
},
{
94.17187500,  -211.59375000,  44.60937500,  -120.89062500
},
{
0.95312500,  -189.81250000,  198.98437500,  -361.98437500
},
{
-22.62500000,  -233.21875000,  101.84375000,  -215.10937500
},
{
130.23437500,  -39.06250000,  -17.89062500,  -58.01562500
},
{
25.51562500,  17.84375000,  3.92187500,  32.89062500
},
{
57.87500000,  -44.03125000,  65.71875000,  -84.71875000
},
{
-10.64062500,  -16.34375000,  73.42187500,  67.51562500
},
{
79.85937500,  -140.14062500,  159.18750000,  -31.95312500
},
{
50.73437500,  -30.67187500,  24.71875000,  -40.70312500
},
{
46.17187500,  -124.84375000,  223.40625000,  -89.35937500
},
{
24.68750000,  -70.89062500,  12.89062500,  -108.20312500
},
{
77.46875000,  -81.76562500,  8.95312500,  -31.31250000
},
{
76.40625000,  -224.65625000,  169.,  68.01562500
},
{
42.82812500,  -40.62500000,  57.57812500,  -65.35937500
},
{
85.39062500,  -19.,  138.85937500,  61.01562500
},
{
108.50000000,  -84.06250000,  84.59375000,  -121.32812500
},
{
50.37500000,  -72.15625000,  30.54687500,  -28.37500000
},
{
-5.23437500,  -163.98437500,  234.93750000,  -98.60937500
},
{
1.40625000,  -70.07812500,  20.,  -59.07812500
},
{
-4.53125000,  6.21875000,  -11.35937500,  40.39062500
},
{
-16.75000000,  -61.06250000,  61.89062500,  139.03125000
},
{
30.,  -21.,  122.18750000,  32.92187500
},
{
-70.34375000,  -137.92187500,  270.23437500,  102.37500000
},
{
15.10937500,  -25.78125000,  -28.25000000,  67.09375000
},
{
7.50000000,  -7.70312500,  11.71875000,  19.64062500
},
{
-15.17187500,  -5.75000000,  92.53125000,  -86.62500000
},
{
7.21875000,  -31.70312500,  125.35937500,  32.84375000
},
{
12.21875000,  -7.34375000,  -4.20312500,  -13.32812500
},
{
10.32812500,  -12.54687500,  3.48437500,  -1.92187500
},
{
33.10937500,  -4.15625000,  -9.92187500,  -69.43750000
},
{
9.84375000,  16.43750000,  4.92187500,  -14.71875000
},
{
56.18750000,  -7.39062500,  45.64062500,  -29.92187500
},
{
4.32812500,  5.56250000,  -11.85937500,  -7.46875000
},
{
35.65625000,  -37.82812500,  78.95312500,  -166.18750000
},
{
19.93750000,  -12.78125000,  17.96875000,  -42.70312500
},
{
-5.54687500,  8.31250000,  -26.79687500,  15.67187500
},
{
0.82812500,  20.59375000,  -25.95312500,  -9.09375000
},
{
-9.87500000,  32.92187500,  3.39062500,  23.87500000
},
{
-3.29687500,  8.60937500,  37.29687500,  21.64062500
},
{
9.62500000,  4.56250000,  -7.82812500,  -8.23437500
},
{
39.20312500,  -5.68750000,  -93.54687500,  -40.64062500
},
{
-6.10937500,  -2.59375000,  3.68750000,  50.70312500
},
{
-6.84375000,  16.39062500,  -24.68750000,  2.50000000
},
{
83.03125000,  -5.07812500,  -17.34375000,  -4.60937500
},
{
66.75000000,  -10.20312500,  112.87500000,  -49.96875000
},
{
0.01562500,  2.07812500,  5.70312500,  -4.18750000
},
{
26.76562500,  -16.75000000,  79.96875000,  1.56250000
},
{
3.09375000,  4.48437500,  -0.75000000,  -3.29687500
},
{
41.34375000,  18.70312500,  21.32812500,  -9.75000000
},
{
10.51562500,  -23.57812500,  18.01562500,  -26.85937500
},
{
3.68750000,  23.93750000,  13.42187500,  -4.98437500
},
{
-34.95312500,  -0.90625000,  -79.14062500,  117.87500000
},
{
22.92187500,  -4.87500000,  48.89062500,  16.17187500
},
{
-54.28125000,  26.57812500,  19.48437500,  24.26562500
},
{
-110.45312500,  -12.70312500,  186.85937500,  115.57812500
},
{
0.95312500,  3.78125000,  -0.90625000,  35.75000000
},
{
9.18750000,  -2.04687500,  -15.89062500,  -18.87500000
},
{
-61.53125000,  -72.,  6.96875000,  160.45312500
},
{
-13.64062500,  -0.84375000,  40.43750000,  60.81250000
},
{
117.56250000,  -34.71875000,  36.04687500,  -83.20312500
},
{
14.25000000,  -9.81250000,  14.67187500,  -10.87500000
},
{
-53.18750000,  -26.51562500,  17.21875000,  -165.15625000
},
{
17.75000000,  9.96875000,  21.51562500,  -48.54687500
},
{
-26.10937500,  -39.51562500,  57.71875000,  -145.78125000
},
{
10.89062500,  -50.12500000,  -28.21875000,  -79.96875000
},
{
-47.42187500,  -60.04687500,  242.64062500,  -365.21875000
},
{
57.82812500,  -45.06250000,  145.06250000,  -126.78125000
},
{
21.96875000,  4.82812500,  18.53125000,  -11.40625000
},
{
-0.96875000,  0.96875000,  -0.12500000,  -0.50000000
},
{
-25.57812500,  20.39062500,  27.17187500,  -43.07812500
},
{
-4.28125000,  -0.28125000,  22.81250000,  -0.64062500
},
{
36.62500000,  -4.14062500,  26.12500000,  -9.82812500
},
{
17.32812500,  -62.35937500,  -26.07812500,  -31.50000000
},
{
-6.40625000,  -14.42187500,  161.50000000,  -108.35937500
},
{
6.29687500,  -2.31250000,  25.50000000,  -57.71875000
},
{
20.28125000,  12.60937500,  -3.93750000,  -15.84375000
},
{
-5.07812500,  -62.48437500,  49.79687500,  50.45312500
},
{
-16.76562500,  -21.37500000,  37.23437500,  -76.62500000
},
{
19.17187500,  -3.98437500,  22.46875000,  10.40625000
},
{
10.46875000,  -0.21875000,  41.93750000,  -49.01562500
},
{
4.48437500,  -1.60937500,  -0.98437500,  -2.10937500
},
{
-3.98437500,  -54.53125000,  181.42187500,  -149.95312500
},
{
-8.15625000,  -0.56250000,  43.48437500,  -65.93750000
},
{
-28.67187500,  38.32812500,  -22.01562500,  16.29687500
},
{
-3.40625000,  16.,  12.70312500,  35.59375000
},
{
0.84375000,  -2.90625000,  6.37500000,  13.81250000
},
{
-62.01562500,  -66.37500000,  79.64062500,  72.93750000
},
{
-0.40625000,  15.48437500,  -26.07812500,  13.46875000
},
{
0.29687500,  2.14062500,  -3.82812500,  0.84375000
},
{
-16.95312500,  -97.89062500,  5.87500000,  -24.03125000
},
{
1.68750000,  2.03125000,  26.96875000,  16.56250000
},
{
17.51562500,  -9.92187500,  3.68750000,  -15.43750000
},
{
27.14062500,  -18.14062500,  -12.04687500,  -16.34375000
},
{
22.17187500,  -15.92187500,  11.87500000,  -22.14062500
},
{
5.56250000,  -2.25000000,  6.40625000,  -4.21875000
},
{
70.57812500,  -6.84375000,  11.28125000,  -26.
},
{
11.92187500,  -49.31250000,  -86.39062500,  -151.25000000
},
{
37.67187500,  -27.04687500,  -30.21875000,  -125.43750000
},
{
-26.06250000,  16.25000000,  -25.45312500,  -44.81250000
},
{
106.62500000,  -72.65625000,  4.92187500,  44.45312500
},
{
12.65625000,  -60.78125000,  -84.62500000,  -61.73437500
},
{
17.,  3.89062500,  6.06250000,  4.84375000
},
{
26.78125000,  11.01562500,  37.46875000,  8.12500000
},
{
-19.42187500,  -130.39062500,  -103.07812500,  -4.71875000
},
{
-9.29687500,  -201.84375000,  -212.37500000,  -144.34375000
},
{
0.23437500,  11.62500000,  -12.64062500,  58.68750000
},
{
-40.67187500,  -44.01562500,  -138.,  -10.96875000
},
{
56.07812500,  -45.78125000,  -4.28125000,  21.25000000
},
{
178.90625000,  -111.82812500,  18.28125000,  7.40625000
},
{
7.59375000,  -2.15625000,  3.15625000,  11.34375000
},
{
3.09375000,  -51.14062500,  80.92187500,  -33.75000000
},
{
10.14062500,  38.50000000,  -6.40625000,  -28.67187500
},
{
47.07812500,  3.45312500,  17.07812500,  -39.70312500
},
{
-5.62500000,  -7.15625000,  9.32812500,  29.92187500
},
{
2.01562500,  -1.17187500,  1.17187500,  -2.37500000
},
{
87.48437500,  -159.07812500,  23.85937500,  203.15625000
},
{
86.54687500,  -44.32812500,  27.65625000,  26.01562500
},
{
32.70312500,  -28.92187500,  69.51562500,  82.76562500
},
{
0.53125000,  -118.25000000,  134.54687500,  54.78125000
},
{
14.96875000,  -36.87500000,  23.68750000,  70.14062500
},
{
-18.89062500,  -37.,  -115.59375000,  -24.06250000
},
{
-96.89062500,  -85.43750000,  27.26562500,  121.10937500
},
{
-28.65625000,  -3.18750000,  56.57812500,  28.79687500
},
{
65.50000000,  -31.29687500,  19.73437500,  -148.21875000
},
{
-0.75000000,  -1.57812500,  22.89062500,  -22.51562500
},
{
31.04687500,  -82.21875000,  -17.90625000,  -73.12500000
},
{
-5.29687500,  -6.95312500,  1.04687500,  -19.18750000
},
{
147.46875000,  -153.85937500,  55.21875000,  -73.54687500
},
{
27.65625000,  -44.67187500,  -15.50000000,  -49.62500000
},
{
-94.06250000,  -160.34375000,  12.09375000,  -166.35937500
},
{
0.18750000,  -16.06250000,  19.50000000,  -156.42187500
},
{
32.04687500,  6.56250000,  0.78125000,  -14.93750000
},
{
-10.18750000,  10.68750000,  -28.93750000,  -28.57812500
},
{
1.45312500,  -2.90625000,  6.71875000,  -17.98437500
},
{
-1.46875000,  4.07812500,  37.40625000,  -36.14062500
},
{
31.34375000,  -7.87500000,  26.37500000,  -28.98437500
},
{
-3.32812500,  -17.93750000,  -74.25000000,  -116.53125000
},
{
12.71875000,  -3.59375000,  69.87500000,  -107.78125000
},
{
2.57812500,  -1.48437500,  55.60937500,  -34.03125000
},
{
30.67187500,  32.12500000,  -3.23437500,  -34.56250000
},
{
43.26562500,  -83.28125000,  22.03125000,  22.54687500
},
{
-0.39062500,  -5.17187500,  -2.46875000,  -16.37500000
},
{
12.92187500,  10.15625000,  34.51562500,  -9.71875000
},
{
81.85937500,  -0.51562500,  24.95312500,  -155.64062500
},
{
15.18750000,  18.25000000,  5.70312500,  -31.92187500
},
{
21.87500000,  -25.78125000,  69.65625000,  -63.92187500
},
{
-25.46875000,  -4.76562500,  58.25000000,  -55.82812500
},
{
79.54687500,  -26.45312500,  -43.89062500,  40.62500000
},
{
4.03125000,  7.57812500,  27.06250000,  -4.12500000
},
{
-9.06250000,  42.73437500,  31.46875000,  -39.96875000
},
{
-1.95312500,  -2.10937500,  185.01562500,  -46.39062500
},
{
29.03125000,  16.62500000,  15.32812500,  -26.15625000
},
{
43.32812500,  -1.15625000,  71.53125000,  -25.32812500
},
{
-20.,  -55.54687500,  53.39062500,  41.12500000
},
{
33.64062500,  -51.68750000,  249.37500000,  -37.98437500
},
{
66.26562500,  -14.96875000,  -6.50000000,  13.51562500
},
{
48.87500000,  41.79687500,  9.53125000,  13.40625000
},
{
-16.03125000,  37.84375000,  3.29687500,  8.92187500
},
{
3.56250000,  49.39062500,  -15.75000000,  31.54687500
},
{
0.31250000,  0.98437500,  0.84375000,  0.64062500
},
{
15.40625000,  23.71875000,  -22.67187500,  -35.85937500
},
{
-0.14062500,  -21.68750000,  0.45312500,  51.35937500
},
{
7.12500000,  6.92187500,  1.73437500,  -9.37500000
},
{
36.79687500,  -0.59375000,  -136.07812500,  108.04687500
},
{
24.48437500,  13.12500000,  -29.98437500,  1.82812500
},
{
-56.20312500,  -0.75000000,  52.10937500,  93.95312500
},
{
-26.46875000,  36.28125000,  -4.92187500,  24.67187500
},
{
2.81250000,  -27.62500000,  19.10937500,  73.09375000
},
{
79.90625000,  -50.95312500,  -133.03125000,  -30.46875000
},
{
-99.78125000,  -2.79687500,  19.51562500,  261.01562500
},
{
-17.53125000,  -12.70312500,  15.07812500,  82.76562500
},
{
164.,  -103.35937500,  33.29687500,  152.42187500
},
{
123.12500000,  -18.53125000,  6.35937500,  -6.14062500
},
{
24.98437500,  -0.31250000,  58.82812500,  44.54687500
},
{
13.15625000,  1.92187500,  -7.43750000,  10.93750000
},
{
14.06250000,  -7.70312500,  1.81250000,  47.51562500
},
{
16.32812500,  6.35937500,  5.18750000,  -9.20312500
},
{
11.67187500,  -80.64062500,  47.21875000,  169.15625000
},
{
-71.45312500,  -26.43750000,  -5.29687500,  13.59375000
},
{
60.64062500,  -55.60937500,  -79.29687500,  305.78125000
},
{
41.43750000,  -19.15625000,  -6.26562500,  77.62500000
},
{
-109.96875000,  -24.45312500,  23.17187500,  188.70312500
},
{
-14.04687500,  14.34375000,  9.62500000,  36.39062500
},
{
-124.,  -49.40625000,  -54.79687500,  102.06250000
},
{
-62.03125000,  -2.92187500,  -60.73437500,  -26.90625000
},
{
-198.76562500,  -202.73437500,  14.71875000,  307.84375000
},
{
-187.56250000,  -88.42187500,  -38.87500000,  73.28125000
},
{
5.50000000,  -4.15625000,  14.23437500,  -21.84375000
},
{
17.01562500,  33.73437500,  10.92187500,  3.79687500
},
{
-41.07812500,  9.15625000,  17.96875000,  -33.45312500
},
{
2.01562500,  13.95312500,  -6.20312500,  -12.56250000
},
{
43.04687500,  -4.51562500,  30.34375000,  -53.67187500
},
{
4.48437500,  -3.32812500,  -10.67187500,  -10.95312500
},
{
-56.48437500,  -71.87500000,  107.53125000,  -97.17187500
},
{
21.79687500,  -0.35937500,  15.46875000,  -102.48437500
},
{
34.65625000,  40.20312500,  -9.46875000,  43.20312500
},
{
10.57812500,  61.73437500,  -23.90625000,  -1.34375000
},
{
-2.03125000,  50.04687500,  16.12500000,  21.31250000
},
{
4.31250000,  58.48437500,  14.35937500,  -7.14062500
},
{
7.32812500,  -1.98437500,  -6.68750000,  0.70312500
},
{
25.04687500,  -6.04687500,  -15.93750000,  -1.25000000
},
{
-27.34375000,  -27.82812500,  24.92187500,  59.54687500
},
{
-2.45312500,  3.17187500,  4.96875000,  -10.73437500
},
{
36.56250000,  -1.98437500,  34.85937500,  42.65625000
},
{
8.21875000,  -1.04687500,  -0.59375000,  -10.28125000
},
{
-39.95312500,  28.04687500,  -15.40625000,  1.76562500
},
{
-10.62500000,  25.59375000,  5.51562500,  4.15625000
},
{
17.18750000,  -0.20312500,  26.98437500,  -24.14062500
},
{
-13.10937500,  44.81250000,  1.31250000,  -9.26562500
},
{
0.14062500,  -90.40625000,  8.82812500,  -31.62500000
},
{
2.31250000,  -0.01562500,  1.29687500,  -10.23437500
},
{
22.89062500,  -3.53125000,  4.98437500,  79.60937500
},
{
30.84375000,  33.09375000,  21.15625000,  15.73437500
},
{
-49.21875000,  -35.81250000,  -0.21875000,  43.
},
{
-12.18750000,  44.12500000,  39.07812500,  2.17187500
},
{
-14.96875000,  -78.50000000,  -20.67187500,  -3.93750000
},
{
-0.17187500,  0.39062500,  -0.10937500,  -5.53125000
},
{
-144.31250000,  -213.04687500,  4.57812500,  76.35937500
},
{
-22.85937500,  -60.73437500,  33.81250000,  -26.53125000
},
{
11.06250000,  -59.93750000,  98.65625000,  54.78125000
},
{
30.78125000,  -272.98437500,  194.75000000,  5.48437500
},
{
13.57812500,  -3.25000000,  2.62500000,  -28.84375000
},
{
16.73437500,  -85.28125000,  37.76562500,  -8.89062500
},
{
22.87500000,  -17.73437500,  38.48437500,  -27.07812500
},
{
18.54687500,  -48.35937500,  90.48437500,  -30.50000000
},
{
64.98437500,  -52.06250000,  11.46875000,  -61.09375000
},
{
-35.54687500,  -169.07812500,  -6.17187500,  -75.10937500
},
{
-1.34375000,  9.75000000,  17.92187500,  3.84375000
},
{
17.45312500,  -70.34375000,  65.60937500,  43.18750000
},
{
-2.59375000,  -0.81250000,  1.84375000,  -2.70312500
},
{
-7.01562500,  -53.50000000,  50.53125000,  -10.87500000
},
{
4.85937500,  26.68750000,  -42.82812500,  32.54687500
},
{
43.51562500,  -64.89062500,  -57.82812500,  -43.12500000
},
{
17.73437500,  -4.71875000,  -8.59375000,  24.81250000
},
{
18.50000000,  -15.17187500,  -0.14062500,  -66.25000000
},
{
12.62500000,  -1.06250000,  22.25000000,  -0.40625000
},
{
80.25000000,  -96.67187500,  49.73437500,  55.68750000
},
{
0.10937500,  2.93750000,  15.,  -5.06250000
},
{
-11.68750000,  -19.56250000,  118.45312500,  -25.06250000
},
{
0.21875000,  14.25000000,  -34.45312500,  27.95312500
},
{
21.95312500,  -11.73437500,  21.51562500,  -8.65625000
},
{
10.12500000,  8.03125000,  16.28125000,  -13.06250000
},
{
-2.23437500,  -14.89062500,  8.04687500,  -24.21875000
},
{
13.79687500,  11.32812500,  -9.56250000,  59.90625000
},
{
10.34375000,  -37.,  41.42187500,  -21.10937500
},
{
-26.96875000,  -66.01562500,  -15.20312500,  24.53125000
},
{
-73.04687500,  -200.60937500,  145.67187500,  42.34375000
},
{
56.57812500,  -2.71875000,  -194.12500000,  79.93750000
},
{
22.39062500,  26.45312500,  -23.76562500,  32.32812500
},
{
4.17187500,  -16.62500000,  -69.68750000,  33.81250000
},
{
16.64062500,  -50.26562500,  34.34375000,  -26.70312500
},
{
101.29687500,  -1.15625000,  42.10937500,  -81.45312500
},
{
-31.60937500,  -55.98437500,  86.59375000,  22.15625000
},
{
-12.17187500,  -55.79687500,  9.17187500,  -78.17187500
},
{
-134.75000000,  -81.46875000,  8.78125000,  -49.03125000
},
{
1.71875000,  -44.50000000,  93.,  -99.92187500
},
{
-35.81250000,  -50.79687500,  45.70312500,  -38.46875000
},
{
-16.15625000,  -166.35937500,  154.70312500,  -125.62500000
},
{
-227.93750000,  -179.65625000,  20.59375000,  -134.39062500
},
{
-6.45312500,  -34.46875000,  -14.59375000,  51.18750000
},
{
-2.18750000,  -26.65625000,  0.34375000,  -21.64062500
},
{
-3.21875000,  -25.32812500,  3.26562500,  -9.43750000
},
{
-93.04687500,  -160.85937500,  -1.12500000,  32.79687500
},
{
-0.29687500,  -17.62500000,  30.23437500,  121.39062500
},
{
21.40625000,  -17.87500000,  -34.42187500,  -5.90625000
},
{
43.67187500,  -10.45312500,  46.93750000,  -59.71875000
},
{
-116.20312500,  -29.18750000,  64.46875000,  -14.14062500
},
{
6.25000000,  -0.40625000,  -8.65625000,  47.96875000
},
{
56.82812500,  -35.67187500,  58.01562500,  79.
},
{
6.76562500,  -14.07812500,  -3.46875000,  11.12500000
},
{
10.92187500,  -131.50000000,  -12.03125000,  0.71875000
},
{
-17.39062500,  -44.07812500,  -42.06250000,  43.10937500
},
{
4.59375000,  -10.89062500,  -6.25000000,  -1.53125000
},
{
-23.81250000,  -31.07812500,  55.50000000,  -62.50000000
},
{
-80.62500000,  -77.,  -33.93750000,  -24.07812500
},
{
16.62500000,  -26.70312500,  -44.92187500,  239.85937500
},
{
11.87500000,  -99.81250000,  7.68750000,  54.21875000
},
{
31.65625000,  -69.81250000,  24.39062500,  79.01562500
},
{
-0.17187500,  -299.40625000,  104.57812500,  97.92187500
},
{
-60.70312500,  -40.67187500,  -153.50000000,  265.50000000
},
{
-15.39062500,  -27.21875000,  -5.29687500,  103.62500000
},
{
-33.07812500,  -5.46875000,  -18.34375000,  87.45312500
},
{
-42.15625000,  -187.45312500,  64.45312500,  90.60937500
},
{
3.62500000,  -4.75000000,  17.51562500,  -2.21875000
},
{
58.90625000,  -63.32812500,  96.92187500,  -35.46875000
},
{
0.03125000,  36.26562500,  9.32812500,  -16.51562500
},
{
7.04687500,  -10.64062500,  10.48437500,  -9.35937500
},
{
-9.51562500,  -5.92187500,  -18.71875000,  -22.68750000
},
{
55.96875000,  15.45312500,  -24.46875000,  -24.25000000
},
{
-8.29687500,  -18.65625000,  17.28125000,  -28.92187500
},
{
-17.43750000,  -11.18750000,  -25.79687500,  -37.54687500
},
{
1.26562500,  33.98437500,  -27.89062500,  6.70312500
},
{
37.50000000,  -8.26562500,  -20.93750000,  -23.40625000
},
{
-56.46875000,  28.06250000,  -8.53125000,  5.60937500
},
{
-28.89062500,  18.26562500,  0.57812500,  -8.78125000
},
{
55.31250000,  17.21875000,  -37.60937500,  6.10937500
},
{
199.43750000,  -9.25000000,  -117.35937500,  -38.01562500
},
{
11.17187500,  -109.28125000,  -53.60937500,  123.65625000
},
{
39.31250000,  25.26562500,  -31.29687500,  20.78125000
},
{
10.21875000,  11.01562500,  -4.,  -0.89062500
},
{
2.79687500,  -10.20312500,  16.98437500,  11.60937500
},
{
-51.87500000,  4.96875000,  -10.56250000,  -3.95312500
},
{
2.40625000,  7.39062500,  9.60937500,  -7.45312500
},
{
11.48437500,  14.75000000,  -20.96875000,  5.59375000
},
{
7.85937500,  11.59375000,  -28.17187500,  -21.76562500
},
{
-4.84375000,  -17.68750000,  -74.48437500,  -8.46875000
},
{
-2.09375000,  0.06250000,  -4.50000000,  -0.18750000
},
{
-18.28125000,  -12.93750000,  -61.84375000,  27.10937500
},
{
29.32812500,  -9.93750000,  -2.81250000,  -11.31250000
},
{
-228.57812500,  -7.39062500,  -34.42187500,  83.03125000
},
{
-77.48437500,  -50.31250000,  28.92187500,  -11.18750000
},
{
47.37500000,  -37.,  -104.10937500,  16.21875000
},
{
80.26562500,  -16.95312500,  -33.92187500,  -97.14062500
},
{
-74.57812500,  -112.09375000,  -191.06250000,  103.57812500
},
{
-26.48437500,  -31.50000000,  -75.17187500,  12.35937500
},
{
10.93750000,  -3.21875000,  10.79687500,  -15.60937500
},
{
14.54687500,  -3.04687500,  7.95312500,  -3.96875000
},
{
3.28125000,  -5.53125000,  -0.37500000,  -79.78125000
},
{
-22.82812500,  4.73437500,  -7.18750000,  -20.28125000
},
{
-27.60937500,  -5.03125000,  -19.93750000,  -116.20312500
},
{
16.76562500,  -1.20312500,  -47.21875000,  3.84375000
},
{
5.12500000,  -61.07812500,  80.68750000,  -203.93750000
},
{
-77.53125000,  -24.29687500,  -21.03125000,  -76.40625000
},
{
-2.56250000,  12.89062500,  -2.31250000,  10.37500000
},
{
11.12500000,  -23.96875000,  -29.40625000,  -1.56250000
},
{
-25.60937500,  23.07812500,  -24.23437500,  -11.23437500
},
{
-7.15625000,  -25.06250000,  -26.39062500,  -10.64062500
},
{
7.68750000,  -10.82812500,  -31.81250000,  11.75000000
},
{
46.14062500,  -53.46875000,  -202.81250000,  -24.15625000
},
{
26.31250000,  -21.85937500,  11.60937500,  -41.59375000
},
{
-2.65625000,  -15.23437500,  -43.03125000,  -53.15625000
},
{
-15.64062500,  17.54687500,  -15.07812500,  -9.76562500
},
{
20.28125000,  11.03125000,  -5.98437500,  14.26562500
},
{
-61.82812500,  -13.03125000,  0.68750000,  -43.76562500
},
{
-9.03125000,  -12.60937500,  -9.20312500,  -4.90625000
},
{
-23.29687500,  35.93750000,  -38.10937500,  -4.29687500
},
{
-5.98437500,  21.67187500,  -13.48437500,  9.64062500
},
{
-48.59375000,  -11.92187500,  50.10937500,  -59.
},
{
-5.46875000,  -5.39062500,  -3.96875000,  -4.25000000
},
{
22.96875000,  6.48437500,  -22.60937500,  39.95312500
},
{
11.07812500,  -7.62500000,  -6.64062500,  5.57812500
},
{
-103.89062500,  -1.92187500,  -44.,  -9.
},
{
-10.43750000,  -111.43750000,  11.01562500,  27.42187500
},
{
-6.31250000,  -27.28125000,  -141.20312500,  31.50000000
},
{
-1.21875000,  9.04687500,  -65.50000000,  -12.64062500
},
{
-24.51562500,  -73.96875000,  -40.15625000,  -9.70312500
},
{
-14.81250000,  -33.03125000,  7.51562500,  -7.35937500
},
{
3.59375000,  6.31250000,  14.23437500,  7.75000000
},
{
-5.68750000,  -95.53125000,  53.20312500,  -12.06250000
},
{
-3.42187500,  21.65625000,  9.21875000,  -6.12500000
},
{
-2.06250000,  -6.39062500,  0.18750000,  -5.10937500
},
{
6.48437500,  21.12500000,  -8.23437500,  -13.10937500
},
{
-19.71875000,  -19.51562500,  -17.06250000,  -68.20312500
},
{
4.93750000,  2.14062500,  -4.43750000,  9.
},
{
-16.43750000,  -12.70312500,  -12.25000000,  -10.65625000
},
{
17.70312500,  -11.06250000,  0.92187500,  12.53125000
},
{
17.53125000,  0.01562500,  -28.17187500,  -34.18750000
},
{
2.18750000,  13.56250000,  10.90625000,  20.10937500
},
{
-0.46875000,  2.98437500,  3.54687500,  5.03125000
},
{
6.87500000,  19.32812500,  -39.15625000,  -7.51562500
},
{
7.21875000,  -3.46875000,  -181.75000000,  -108.03125000
},
{
10.65625000,  -35.34375000,  51.96875000,  115.68750000
},
{
-10.82812500,  -19.53125000,  -1.07812500,  -20.68750000
},
{
13.07812500,  10.46875000,  -8.78125000,  20.62500000
},
{
52.18750000,  11.92187500,  -0.23437500,  -8.78125000
},
{
-0.31250000,  6.70312500,  2.15625000,  -2.73437500
},
{
0.84375000,  -4.73437500,  10.04687500,  -6.85937500
},
{
-10.81250000,  24.82812500,  -15.78125000,  1.51562500
},
{
-3.35937500,  -0.79687500,  -7.75000000,  -5.48437500
},
{
6.31250000,  8.89062500,  -59.71875000,  12.82812500
},
{
-8.21875000,  -45.20312500,  -26.64062500,  -87.68750000
},
{
23.68750000,  -4.09375000,  -23.48437500,  61.31250000
},
{
19.17187500,  7.31250000,  -17.64062500,  -13.06250000
},
{
12.70312500,  -2.15625000,  0.26562500,  1.92187500
},
{
3.26562500,  -11.71875000,  75.39062500,  50.76562500
},
{
12.32812500,  2.81250000,  -27.32812500,  29.32812500
},
{
5.60937500,  -27.71875000,  -30.23437500,  -50.81250000
},
{
1.46875000,  -65.84375000,  -76.71875000,  28.64062500
},
{
60.65625000,  -124.32812500,  86.10937500,  -60.23437500
},
{
5.73437500,  0.73437500,  5.34375000,  -19.56250000
},
{
2.09375000,  -3.57812500,  2.32812500,  3.75000000
},
{
-3.90625000,  -6.15625000,  13.01562500,  -11.18750000
},
{
-33.14062500,  3.15625000,  -4.15625000,  -36.10937500
},
{
65.78125000,  -1.81250000,  11.68750000,  -63.54687500
},
{
-12.28125000,  26.51562500,  -2.29687500,  -36.01562500
},
{
-87.87500000,  -19.50000000,  81.25000000,  -60.56250000
},
{
-79.15625000,  -5.50000000,  12.,  -154.59375000
},
{
-3.18750000,  5.96875000,  2.40625000,  3.71875000
},
{
2.87500000,  13.73437500,  1.48437500,  7.26562500
},
{
27.75000000,  21.03125000,  10.14062500,  0.67187500
},
{
8.42187500,  -27.43750000,  64.98437500,  6.95312500
},
{
-5.84375000,  10.67187500,  9.78125000,  18.64062500
},
{
3.57812500,  -28.65625000,  7.70312500,  -39.84375000
},
{
19.78125000,  -2.32812500,  45.89062500,  -17.01562500
},
{
-50.51562500,  -143.01562500,  146.53125000,  -49.12500000
},
{
-17.95312500,  23.40625000,  -2.71875000,  -0.68750000
},
{
5.48437500,  -5.18750000,  0.34375000,  2.57812500
},
{
-33.15625000,  1.82812500,  -9.64062500,  -5.90625000
},
{
30.37500000,  -38.17187500,  53.57812500,  -6.29687500
},
{
23.37500000,  -0.29687500,  -0.90625000,  -33.82812500
},
{
-57.39062500,  -3.60937500,  23.45312500,  -79.45312500
},
{
-10.92187500,  -54.82812500,  -31.92187500,  -40.45312500
},
{
-55.60937500,  -184.34375000,  50.42187500,  -92.73437500
},
{
10.28125000,  17.14062500,  6.95312500,  43.50000000
},
{
53.90625000,  -27.26562500,  38.01562500,  31.26562500
},
{
104.98437500,  -57.85937500,  32.51562500,  -26.46875000
},
{
110.03125000,  -142.71875000,  213.60937500,  40.84375000
},
{
-5.68750000,  -16.54687500,  -9.84375000,  79.14062500
},
{
3.56250000,  -93.79687500,  61.64062500,  -56.06250000
},
{
-13.23437500,  -70.93750000,  98.84375000,  -11.59375000
},
{
-51.29687500,  -250.15625000,  269.17187500,  -25.56250000
},
{
-4.45312500,  5.65625000,  -5.03125000,  10.50000000
},
{
7.39062500,  -3.10937500,  12.28125000,  3.35937500
},
{
5.76562500,  -3.57812500,  -12.46875000,  17.18750000
},
{
-2.84375000,  31.53125000,  9.98437500,  7.25000000
},
{
8.76562500,  -1.73437500,  -0.85937500,  26.03125000
},
{
-9.10937500,  33.73437500,  -22.09375000,  -11.73437500
},
{
69.04687500,  -53.84375000,  -59.21875000,  114.09375000
},
{
-0.60937500,  -8.09375000,  0.23437500,  23.35937500
},
{
15.87500000,  -15.46875000,  -47.26562500,  27.48437500
},
{
36.04687500,  3.12500000,  -14.81250000,  9.75000000
},
{
43.17187500,  -36.85937500,  -19.,  115.68750000
},
{
3.60937500,  -11.75000000,  -9.01562500,  21.14062500
},
{
11.75000000,  -19.70312500,  -36.34375000,  158.04687500
},
{
20.54687500,  -11.56250000,  -87.93750000,  -19.56250000
},
{
84.17187500,  -124.34375000,  -26.42187500,  300.37500000
},
{
-15.71875000,  -88.93750000,  -70.68750000,  128.59375000
},
{
46.,  -28.90625000,  -35.34375000,  28.87500000
},
{
27.06250000,  21.12500000,  -20.95312500,  -14.93750000
},
{
3.03125000,  -21.34375000,  -51.67187500,  7.81250000
},
{
-1.,  4.57812500,  -3.,  5.54687500
},
{
7.12500000,  -13.23437500,  -17.51562500,  31.23437500
},
{
0.84375000,  8.42187500,  -8.20312500,  -0.48437500
},
{
-37.29687500,  -142.71875000,  -141.89062500,  114.50000000
},
{
31.68750000,  -54.93750000,  -31.29687500,  -3.35937500
},
{
148.98437500,  -11.06250000,  -177.95312500,  115.34375000
},
{
113.43750000,  -62.,  -91.70312500,  -3.56250000
},
{
-26.67187500,  -28.84375000,  -73.17187500,  71.89062500
},
{
14.89062500,  4.09375000,  -14.81250000,  -1.50000000
},
{
3.65625000,  -61.25000000,  -119.71875000,  127.48437500
},
{
-3.09375000,  -11.42187500,  -16.53125000,  25.53125000
},
{
-12.68750000,  -178.03125000,  -159.81250000,  222.93750000
},
{
19.65625000,  -53.01562500,  -71.45312500,  77.98437500
},
{
-1.17187500,  17.95312500,  -0.98437500,  1.14062500
},
{
47.53125000,  48.29687500,  -14.10937500,  -1.04687500
},
{
-38.31250000,  41.59375000,  -26.17187500,  -24.43750000
},
{
-25.18750000,  54.03125000,  -0.82812500,  8.48437500
},
{
-2.57812500,  41.54687500,  -11.64062500,  -32.48437500
},
{
-4.45312500,  16.37500000,  -7.,  -5.68750000
},
{
10.78125000,  -6.15625000,  22.51562500,  -33.21875000
},
{
-19.84375000,  18.79687500,  -0.31250000,  -30.95312500
},
{
4.98437500,  15.42187500,  -10.76562500,  3.75000000
},
{
-3.31250000,  8.18750000,  -5.53125000,  -1.14062500
},
{
38.65625000,  9.46875000,  1.65625000,  18.01562500
},
{
7.84375000,  1.25000000,  1.65625000,  0.20312500
},
{
20.42187500,  47.34375000,  -3.75000000,  30.59375000
},
{
2.79687500,  -34.35937500,  -30.57812500,  -21.45312500
},
{
62.93750000,  -14.60937500,  36.89062500,  150.29687500
},
{
1.21875000,  -1.43750000,  36.82812500,  4.03125000
},
{
-35.17187500,  14.71875000,  -42.15625000,  -22.09375000
},
{
-2.85937500,  32.43750000,  -13.90625000,  -3.98437500
},
{
-198.56250000,  -4.15625000,  -54.93750000,  -22.65625000
},
{
-40.90625000,  36.96875000,  -29.65625000,  18.18750000
},
{
0.51562500,  1.,  -9.92187500,  -3.07812500
},
{
-30.01562500,  48.03125000,  13.07812500,  -18.31250000
},
{
-23.59375000,  -52.23437500,  -59.71875000,  -41.28125000
},
{
-5.12500000,  -28.75000000,  8.87500000,  -41.06250000
},
{
30.43750000,  -27.06250000,  -63.65625000,  12.09375000
},
{
17.20312500,  -5.28125000,  -7.14062500,  -3.93750000
},
{
-41.45312500,  -22.23437500,  -24.31250000,  -57.06250000
},
{
44.54687500,  -35.92187500,  62.82812500,  -12.15625000
},
{
15.26562500,  -10.96875000,  -22.48437500,  16.14062500
},
{
-8.,  -2.96875000,  19.60937500,  -17.70312500
},
{
-48.35937500,  -36.96875000,  -67.14062500,  62.39062500
},
{
-87.54687500,  -106.26562500,  51.21875000,  -75.39062500
},
  },
{
  /*****************************************************************************
   *
   * modifed shape5 - table
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^5 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^5)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
{
-12.87500000,  -31.06250000,  -23.09375000,  -10.75000000
},
{
7.37500000,  -51.90625000,  -21.75000000,  -21.37500000
},
{
-68.43750000,  25.65625000,  -52.93750000,  41.90625000
},
{
-22.09375000,  47.12500000,  1.90625000,  34.59375000
},
{
37.43750000,  10.50000000,  2.90625000,  11.56250000
},
{
-25.09375000,  14.34375000,  -26.34375000,  4.56250000
},
{
39.34375000,  114.53125000,  13.62500000,  83.53125000
},
{
-177.43750000,  70.18750000,  -31.53125000,  29.59375000
},
{
33.40625000,  -4.53125000,  -5.78125000,  23.87500000
},
{
-1.62500000,  7.31250000,  -70.25000000,  40.84375000
},
{
1.68750000,  22.59375000,  -25.87500000,  70.25000000
},
{
-162.18750000,  83.84375000,  -103.56250000,  131.56250000
},
{
59.68750000,  53.34375000,  -48.65625000,  141.75000000
},
{
-116.68750000,  139.,  -87.21875000,  55.81250000
},
{
21.28125000,  83.84375000,  -99.93750000,  319.96875000
},
{
-631.46875000,  451.18750000,  -125.65625000,  530.90625000
},
{
-25.65625000,  47.62500000,  -63.37500000,  62.50000000
},
{
1.43750000,  8.21875000,  -30.03125000,  -43.25000000
},
{
-175.65625000,  117.18750000,  -254.03125000,  -9.53125000
},
{
-48.46875000,  67.46875000,  -63.40625000,  7.06250000
},
{
-66.40625000,  -36.75000000,  23.90625000,  -0.12500000
},
{
8.15625000,  30.59375000,  -23.87500000,  7.40625000
},
{
-45.87500000,  32.15625000,  -33.28125000,  -36.46875000
},
{
-25.71875000,  41.68750000,  -12.78125000,  -27.37500000
},
{
-38.65625000,  -37.96875000,  -44.56250000,  -13.90625000
},
{
0.21875000,  0.09375000,  3.65625000,  -12.12500000
},
{
-58.65625000,  2.81250000,  -54.62500000,  -67.78125000
},
{
-14.09375000,  55.18750000,  -20.21875000,  6.28125000
},
{
35.43750000,  20.09375000,  -22.96875000,  -3.28125000
},
{
-73.56250000,  41.37500000,  -27.68750000,  -71.56250000
},
{
-18.87500000,  64.93750000,  37.93750000,  93.71875000
},
{
-126.65625000,  227.37500000,  -86.68750000,  9.56250000
},
{
-12.06250000,  34.68750000,  -46.50000000,  2.84375000
},
{
20.93750000,  0.75000000,  -44.75000000,  5.40625000
},
{
-69.40625000,  55.87500000,  -303.62500000,  53.18750000
},
{
-41.96875000,  66.31250000,  -117.75000000,  74.75000000
},
{
1.25000000,  3.93750000,  -8.84375000,  -1.78125000
},
{
27.03125000,  -25.21875000,  -18.,  -9.75000000
},
{
34.46875000,  80.18750000,  -133.06250000,  -2.
},
{
-33.03125000,  -4.84375000,  -41.25000000,  52.50000000
},
{
9.65625000,  0.96875000,  0.03125000,  -21.31250000
},
{
1.12500000,  -58.21875000,  -22.56250000,  5.31250000
},
{
-15.,  -3.53125000,  -66.78125000,  -26.90625000
},
{
-28.31250000,  27.,  -3.43750000,  63.21875000
},
{
30.21875000,  -14.59375000,  2.12500000,  11.71875000
},
{
-8.56250000,  13.53125000,  -12.37500000,  38.53125000
},
{
54.15625000,  50.21875000,  43.37500000,  129.21875000
},
{
-145.56250000,  115.84375000,  -73.25000000,  147.53125000
},
{
-86.75000000,  143.93750000,  -147.81250000,  -27.09375000
},
{
61.81250000,  38.03125000,  -152.53125000,  -98.81250000
},
{
-144.37500000,  57.43750000,  -437.28125000,  -231.84375000
},
{
-83.06250000,  198.59375000,  -267.53125000,  21.87500000
},
{
-25.93750000,  26.96875000,  33.65625000,  -93.43750000
},
{
14.75000000,  0.68750000,  -31.84375000,  -27.90625000
},
{
-73.40625000,  77.31250000,  -146.03125000,  -217.28125000
},
{
15.50000000,  62.31250000,  -68.71875000,  -70.53125000
},
{
24.06250000,  14.,  -94.46875000,  -103.06250000
},
{
13.62500000,  -27.37500000,  -52.84375000,  -50.68750000
},
{
35.56250000,  30.84375000,  -184.53125000,  -247.21875000
},
{
12.,  45.87500000,  -87.90625000,  -10.12500000
},
{
6.75000000,  2.68750000,  13.90625000,  -8.09375000
},
{
-14.87500000,  -4.62500000,  -4.93750000,  2.18750000
},
{
41.18750000,  5.56250000,  -74.87500000,  -50.06250000
},
{
-48.15625000,  58.03125000,  26.31250000,  43.43750000
},
{
34.50000000,  68.56250000,  -30.96875000,  -42.68750000
},
{
5.71875000,  7.50000000,  -1.71875000,  -6.81250000
},
{
52.37500000,  19.12500000,  -12.81250000,  41.34375000
},
{
87.03125000,  16.09375000,  18.71875000,  31.71875000
},
{
-6.75000000,  3.,  -26.53125000,  14.40625000
},
{
8.78125000,  11.71875000,  -29.71875000,  36.28125000
},
{
5.21875000,  65.,  -125.43750000,  95.81250000
},
{
-39.87500000,  -38.37500000,  -51.46875000,  19.37500000
},
{
-18.21875000,  -24.53125000,  -0.12500000,  -14.06250000
},
{
-15.15625000,  17.62500000,  -20.03125000,  -13.56250000
},
{
4.34375000,  -4.68750000,  1.84375000,  4.65625000
},
{
-44.31250000,  -24.65625000,  -16.75000000,  35.62500000
},
{
-10.,  19.53125000,  -10.90625000,  11.03125000
},
{
-57.31250000,  56.50000000,  -149.90625000,  1.90625000
},
{
-19.81250000,  7.68750000,  20.34375000,  122.93750000
},
{
-195.71875000,  31.59375000,  -30.50000000,  96.84375000
},
{
63.87500000,  87.12500000,  20.28125000,  12.31250000
},
{
-0.46875000,  12.46875000,  -49.46875000,  -15.43750000
},
{
-76.28125000,  22.68750000,  -43.81250000,  -3.09375000
},
{
-2.68750000,  12.06250000,  7.03125000,  6.96875000
},
{
-23.03125000,  33.40625000,  -2.46875000,  -4.15625000
},
{
-91.12500000,  113.03125000,  -128.50000000,  54.37500000
},
{
30.46875000,  7.81250000,  -18.71875000,  13.90625000
},
{
-89.15625000,  32.46875000,  -6.21875000,  17.18750000
},
{
-2.06250000,  13.59375000,  -4.93750000,  -12.65625000
},
{
-43.75000000,  96.68750000,  -11.84375000,  -30.68750000
},
{
-16.34375000,  12.06250000,  -1.25000000,  3.34375000
},
{
-74.37500000,  132.62500000,  58.21875000,  -3.90625000
},
{
-25.28125000,  83.84375000,  -66.87500000,  -121.93750000
},
{
-229.31250000,  169.50000000,  -117.09375000,  -166.03125000
},
{
-95.87500000,  11.71875000,  -13.46875000,  47.96875000
},
{
-251.53125000,  126.75000000,  -21.,  -94.93750000
},
{
-33.09375000,  295.21875000,  -81.,  -5.09375000
},
{
-8.90625000,  97.56250000,  12.96875000,  -16.18750000
},
{
21.65625000,  112.46875000,  -50.43750000,  112.50000000
},
{
-14.12500000,  3.37500000,  -59.50000000,  19.59375000
},
{
48.53125000,  61.06250000,  -46.09375000,  32.31250000
},
{
134.84375000,  11.31250000,  -54.84375000,  29.93750000
},
{
147.15625000,  104.43750000,  -271.40625000,  164.56250000
},
{
72.43750000,  9.18750000,  -210.81250000,  70.87500000
},
{
-26.,  87.06250000,  1.09375000,  10.21875000
},
{
-10.21875000,  -8.93750000,  -11.21875000,  -11.03125000
},
{
6.43750000,  4.96875000,  -11.46875000,  7.09375000
},
{
-25.84375000,  -61.84375000,  -0.40625000,  -11.06250000
},
{
40.43750000,  -13.34375000,  -31.15625000,  -8.84375000
},
{
0.31250000,  4.28125000,  -23.18750000,  -0.37500000
},
{
47.34375000,  24.53125000,  -96.53125000,  72.15625000
},
{
-17.09375000,  32.53125000,  -40.50000000,  31.06250000
},
{
85.12500000,  227.09375000,  108.43750000,  -102.50000000
},
{
134.59375000,  2.71875000,  -124.65625000,  -75.56250000
},
{
-14.18750000,  16.12500000,  -132.71875000,  -88.40625000
},
{
-30.50000000,  72.28125000,  -35.46875000,  49.68750000
},
{
61.40625000,  104.40625000,  117.06250000,  -56.12500000
},
{
3.71875000,  28.81250000,  -23.12500000,  -16.34375000
},
{
9.87500000,  43.96875000,  -75.53125000,  40.87500000
},
{
36.59375000,  -43.03125000,  -59.75000000,  -8.03125000
},
{
51.40625000,  80.46875000,  25.50000000,  -39.62500000
},
{
17.56250000,  -25.62500000,  -38.31250000,  -18.90625000
},
{
33.81250000,  4.43750000,  -53.18750000,  -80.53125000
},
{
-8.87500000,  10.68750000,  8.71875000,  -6.53125000
},
{
-12.84375000,  -11.75000000,  -3.03125000,  -38.03125000
},
{
-95.18750000,  74.31250000,  -19.59375000,  -16.34375000
},
{
2.59375000,  -2.06250000,  -2.71875000,  2.40625000
},
{
-57.87500000,  65.81250000,  33.78125000,  -15.21875000
},
{
7.25000000,  23.81250000,  47.28125000,  -7.87500000
},
{
-2.18750000,  -46.03125000,  8.53125000,  -23.
},
{
50.25000000,  9.53125000,  28.34375000,  10.09375000
},
{
40.84375000,  17.56250000,  13.93750000,  45.25000000
},
{
-46.71875000,  33.28125000,  0.21875000,  -3.68750000
},
{
-6.25000000,  -0.90625000,  15.,  14.31250000
},
{
4.43750000,  -3.81250000,  12.78125000,  23.21875000
},
{
-55.78125000,  96.68750000,  -0.84375000,  98.84375000
},
{
3.62500000,  -6.56250000,  4.90625000,  -5.68750000
},
{
-13.06250000,  -1.09375000,  2.37500000,  -9.34375000
},
{
1.46875000,  26.96875000,  2.09375000,  6.81250000
},
{
-98.43750000,  83.78125000,  37.28125000,  28.
},
{
3.09375000,  13.40625000,  -14.18750000,  22.40625000
},
{
-72.78125000,  48.68750000,  50.43750000,  63.46875000
},
{
2.53125000,  72.75000000,  11.56250000,  154.03125000
},
{
-288.03125000,  131.50000000,  112.68750000,  267.96875000
},
{
-1.75000000,  43.59375000,  18.90625000,  -57.65625000
},
{
12.25000000,  -1.65625000,  -9.25000000,  -46.06250000
},
{
-64.46875000,  58.93750000,  -10.21875000,  22.62500000
},
{
-2.96875000,  11.21875000,  25.15625000,  3.03125000
},
{
-189.46875000,  54.78125000,  85.68750000,  -105.75000000
},
{
-23.40625000,  37.15625000,  44.03125000,  -37.87500000
},
{
-21.21875000,  4.28125000,  19.65625000,  -42.78125000
},
{
-18.,  158.40625000,  121.25000000,  -22.78125000
},
{
-6.50000000,  -56.18750000,  22.40625000,  -53.40625000
},
{
-42.50000000,  -58.06250000,  -6.06250000,  -37.53125000
},
{
57.40625000,  -9.75000000,  -17.75000000,  -29.50000000
},
{
-72.84375000,  -5.62500000,  41.25000000,  -9.84375000
},
{
-19.37500000,  15.96875000,  -4.31250000,  -73.46875000
},
{
-20.18750000,  16.65625000,  75.25000000,  -38.06250000
},
{
-57.96875000,  -42.31250000,  46.87500000,  5.
},
{
-203.06250000,  81.28125000,  142.93750000,  -24.25000000
},
{
-30.90625000,  186.12500000,  73.93750000,  80.71875000
},
{
-14.15625000,  42.25000000,  17.,  -24.25000000
},
{
-3.96875000,  97.28125000,  -67.46875000,  8.93750000
},
{
-19.65625000,  -19.25000000,  -17.87500000,  2.40625000
},
{
-7.53125000,  67.65625000,  74.78125000,  -58.87500000
},
{
-7.90625000,  -3.46875000,  1.96875000,  -20.43750000
},
{
22.40625000,  -0.87500000,  -15.56250000,  -0.84375000
},
{
-16.12500000,  7.12500000,  10.90625000,  11.78125000
},
{
30.37500000,  52.87500000,  13.37500000,  74.46875000
},
{
0.37500000,  0.31250000,  -1.25000000,  -1.18750000
},
{
30.43750000,  11.15625000,  -12.25000000,  -20.
},
{
-61.71875000,  -37.21875000,  16.81250000,  34.
},
{
1.46875000,  13.62500000,  9.50000000,  -18.25000000
},
{
-6.31250000,  17.96875000,  7.15625000,  22.37500000
},
{
3.34375000,  13.25000000,  34.09375000,  19.75000000
},
{
-131.84375000,  71.25000000,  100.18750000,  102.43750000
},
{
165.65625000,  124.81250000,  -1.87500000,  -84.84375000
},
{
49.,  31.71875000,  -9.65625000,  -196.75000000
},
{
-109.15625000,  43.78125000,  -109.81250000,  -87.34375000
},
{
-23.03125000,  60.84375000,  -52.71875000,  -33.34375000
},
{
-168.96875000,  140.59375000,  97.15625000,  -266.28125000
},
{
-34.43750000,  102.65625000,  8.21875000,  -76.43750000
},
{
-75.84375000,  18.62500000,  30.12500000,  -40.56250000
},
{
-10.78125000,  26.93750000,  11.71875000,  -3.03125000
},
{
16.21875000,  18.81250000,  24.75000000,  -27.65625000
},
{
33.40625000,  -8.,  16.15625000,  -37.
},
{
42.93750000,  37.09375000,  -116.56250000,  -140.53125000
},
{
1.25000000,  -32.75000000,  -22.50000000,  -38.75000000
},
{
-32.18750000,  44.21875000,  136.50000000,  -83.62500000
},
{
22.75000000,  -1.93750000,  10.53125000,  -21.56250000
},
{
17.37500000,  24.87500000,  -7.18750000,  -43.59375000
},
{
-54.96875000,  31.59375000,  89.62500000,  34.81250000
},
{
42.84375000,  178.15625000,  16.50000000,  0.18750000
},
{
94.68750000,  35.75000000,  27.15625000,  -0.90625000
},
{
105.56250000,  94.06250000,  86.34375000,  60.71875000
},
{
126.68750000,  54.71875000,  101.18750000,  123.34375000
},
{
6.71875000,  51.78125000,  -31.28125000,  -8.81250000
},
{
3.87500000,  1.46875000,  2.62500000,  -2.31250000
},
{
30.59375000,  30.37500000,  -17.40625000,  28.28125000
},
{
62.96875000,  20.03125000,  78.53125000,  29.03125000
},
{
-0.12500000,  27.09375000,  -1.68750000,  -7.96875000
},
{
1.06250000,  5.37500000,  2.18750000,  2.21875000
},
{
20.21875000,  8.78125000,  22.25000000,  32.59375000
},
{
32.15625000,  1.71875000,  27.25000000,  97.78125000
},
{
33.90625000,  -19.93750000,  -4.18750000,  -24.78125000
},
{
15.09375000,  67.59375000,  50.46875000,  33.40625000
},
{
28.78125000,  6.46875000,  102.31250000,  6.18750000
},
{
-29.34375000,  32.31250000,  206.65625000,  152.46875000
},
{
113.96875000,  15.59375000,  143.31250000,  -31.65625000
},
{
103.09375000,  57.15625000,  -54.03125000,  -42.90625000
},
{
46.,  -9.81250000,  20.25000000,  -14.93750000
},
{
100.75000000,  27.03125000,  -7.37500000,  77.12500000
},
{
4.37500000,  54.25000000,  87.,  -114.84375000
},
{
-3.40625000,  21.06250000,  -53.68750000,  -42.
},
{
-14.46875000,  -28.34375000,  -38.43750000,  -58.37500000
},
{
-11.46875000,  15.43750000,  22.12500000,  -23.53125000
},
{
9.87500000,  24.31250000,  138.15625000,  -34.09375000
},
{
21.59375000,  0.46875000,  18.34375000,  11.75000000
},
{
98.84375000,  20.25000000,  56.78125000,  -35.75000000
},
{
2.59375000,  9.62500000,  11.46875000,  -0.18750000
},
{
46.65625000,  0.06250000,  54.90625000,  -83.56250000
},
{
-55.56250000,  35.31250000,  2.81250000,  -36.31250000
},
{
-9.37500000,  8.25000000,  -8.93750000,  -3.37500000
},
{
-55.28125000,  114.18750000,  59.18750000,  21.06250000
},
{
190.43750000,  423.12500000,  46.15625000,  79.
},
{
63.37500000,  6.,  32.90625000,  -125.15625000
},
{
45.18750000,  252.15625000,  78.21875000,  150.50000000
},
{
-10.09375000,  74.06250000,  75.65625000,  36.21875000
},
{
-10.84375000,  214.21875000,  -32.75000000,  -104.46875000
},
{
19.87500000,  48.25000000,  -5.06250000,  -18.65625000
},
{
124.81250000,  86.37500000,  -63.87500000,  17.40625000
},
{
15.93750000,  10.78125000,  -42.59375000,  24.18750000
},
{
6.59375000,  154.78125000,  -51.03125000,  33.96875000
},
{
11.81250000,  17.46875000,  -17.18750000,  -2.53125000
},
{
-48.59375000,  126.90625000,  -2.90625000,  57.59375000
},
{
6.09375000,  11.03125000,  -2.15625000,  2.56250000
},
{
-6.12500000,  40.37500000,  -29.93750000,  -46.40625000
},
{
2.15625000,  0.28125000,  5.96875000,  7.96875000
},
{
16.50000000,  14.71875000,  -0.78125000,  -12.15625000
},
{
5.65625000,  25.75000000,  123.25000000,  51.65625000
},
{
490.12500000,  308.81250000,  351.78125000,  -104.87500000
},
{
448.78125000,  106.50000000,  37.59375000,  -376.68750000
},
{
103.62500000,  55.03125000,  148.56250000,  -11.37500000
},
{
142.65625000,  10.75000000,  -33.09375000,  -12.21875000
},
{
143.28125000,  221.09375000,  240.84375000,  -432.40625000
},
{
38.37500000,  4.,  46.21875000,  -176.34375000
},
{
-7.78125000,  58.81250000,  -64.37500000,  -206.56250000
},
{
47.09375000,  13.12500000,  -7.18750000,  -74.46875000
},
{
87.62500000,  150.59375000,  158.12500000,  10.65625000
},
{
117.31250000,  79.50000000,  7.84375000,  -29.37500000
},
{
42.28125000,  26.71875000,  1.28125000,  -0.15625000
},
{
30.37500000,  1.12500000,  4.37500000,  -5.71875000
},
{
-105.46875000,  53.06250000,  61.18750000,  -180.90625000
},
{
-18.96875000,  16.31250000,  2.56250000,  -30.87500000
},
{
-3.12500000,  17.21875000,  1.31250000,  -41.
},
{
-7.65625000,  2.37500000,  5.25000000,  2.21875000
},
{
12.87500000,  31.06250000,  23.09375000,  10.75000000
},
{
-7.37500000,  51.90625000,  21.75000000,  21.37500000
},
{
68.43750000,  -25.65625000,  52.93750000,  -41.90625000
},
{
22.09375000,  -47.12500000,  -1.90625000,  -34.59375000
},
{
-37.43750000,  -10.50000000,  -2.90625000,  -11.56250000
},
{
25.09375000,  -14.34375000,  26.34375000,  -4.56250000
},
{
-39.34375000,  -114.53125000,  -13.62500000,  -83.53125000
},
{
177.43750000,  -70.18750000,  31.53125000,  -29.59375000
},
{
-33.40625000,  4.53125000,  5.78125000,  -23.87500000
},
{
1.62500000,  -7.31250000,  70.25000000,  -40.84375000
},
{
-1.68750000,  -22.59375000,  25.87500000,  -70.25000000
},
{
162.18750000,  -83.84375000,  103.56250000,  -131.56250000
},
{
-59.68750000,  -53.34375000,  48.65625000,  -141.75000000
},
{
116.68750000,  -139.,  87.21875000,  -55.81250000
},
{
-21.28125000,  -83.84375000,  99.93750000,  -319.96875000
},
{
631.46875000,  -451.18750000,  125.65625000,  -530.90625000
},
{
25.65625000,  -47.62500000,  63.37500000,  -62.50000000
},
{
-1.43750000,  -8.21875000,  30.03125000,  43.25000000
},
{
175.65625000,  -117.18750000,  254.03125000,  9.53125000
},
{
48.46875000,  -67.46875000,  63.40625000,  -7.06250000
},
{
66.40625000,  36.75000000,  -23.90625000,  0.12500000
},
{
-8.15625000,  -30.59375000,  23.87500000,  -7.40625000
},
{
45.87500000,  -32.15625000,  33.28125000,  36.46875000
},
{
25.71875000,  -41.68750000,  12.78125000,  27.37500000
},
{
38.65625000,  37.96875000,  44.56250000,  13.90625000
},
{
-0.21875000,  -0.09375000,  -3.65625000,  12.12500000
},
{
58.65625000,  -2.81250000,  54.62500000,  67.78125000
},
{
14.09375000,  -55.18750000,  20.21875000,  -6.28125000
},
{
-35.43750000,  -20.09375000,  22.96875000,  3.28125000
},
{
73.56250000,  -41.37500000,  27.68750000,  71.56250000
},
{
18.87500000,  -64.93750000,  -37.93750000,  -93.71875000
},
{
126.65625000,  -227.37500000,  86.68750000,  -9.56250000
},
{
12.06250000,  -34.68750000,  46.50000000,  -2.84375000
},
{
-20.93750000,  -0.75000000,  44.75000000,  -5.40625000
},
{
69.40625000,  -55.87500000,  303.62500000,  -53.18750000
},
{
41.96875000,  -66.31250000,  117.75000000,  -74.75000000
},
{
-1.25000000,  -3.93750000,  8.84375000,  1.78125000
},
{
-27.03125000,  25.21875000,  18.,  9.75000000
},
{
-34.46875000,  -80.18750000,  133.06250000,  2.
},
{
33.03125000,  4.84375000,  41.25000000,  -52.50000000
},
{
-9.65625000,  -0.96875000,  -0.03125000,  21.31250000
},
{
-1.12500000,  58.21875000,  22.56250000,  -5.31250000
},
{
15.,  3.53125000,  66.78125000,  26.90625000
},
{
28.31250000,  -27.,  3.43750000,  -63.21875000
},
{
-30.21875000,  14.59375000,  -2.12500000,  -11.71875000
},
{
8.56250000,  -13.53125000,  12.37500000,  -38.53125000
},
{
-54.15625000,  -50.21875000,  -43.37500000,  -129.21875000
},
{
145.56250000,  -115.84375000,  73.25000000,  -147.53125000
},
{
86.75000000,  -143.93750000,  147.81250000,  27.09375000
},
{
-61.81250000,  -38.03125000,  152.53125000,  98.81250000
},
{
144.37500000,  -57.43750000,  437.28125000,  231.84375000
},
{
83.06250000,  -198.59375000,  267.53125000,  -21.87500000
},
{
25.93750000,  -26.96875000,  -33.65625000,  93.43750000
},
{
-14.75000000,  -0.68750000,  31.84375000,  27.90625000
},
{
73.40625000,  -77.31250000,  146.03125000,  217.28125000
},
{
-15.50000000,  -62.31250000,  68.71875000,  70.53125000
},
{
-24.06250000,  -14.,  94.46875000,  103.06250000
},
{
-13.62500000,  27.37500000,  52.84375000,  50.68750000
},
{
-35.56250000,  -30.84375000,  184.53125000,  247.21875000
},
{
-12.,  -45.87500000,  87.90625000,  10.12500000
},
{
-6.75000000,  -2.68750000,  -13.90625000,  8.09375000
},
{
14.87500000,  4.62500000,  4.93750000,  -2.18750000
},
{
-41.18750000,  -5.56250000,  74.87500000,  50.06250000
},
{
48.15625000,  -58.03125000,  -26.31250000,  -43.43750000
},
{
-34.50000000,  -68.56250000,  30.96875000,  42.68750000
},
{
-5.71875000,  -7.50000000,  1.71875000,  6.81250000
},
{
-52.37500000,  -19.12500000,  12.81250000,  -41.34375000
},
{
-87.03125000,  -16.09375000,  -18.71875000,  -31.71875000
},
{
6.75000000,  -3.,  26.53125000,  -14.40625000
},
{
-8.78125000,  -11.71875000,  29.71875000,  -36.28125000
},
{
-5.21875000,  -65.,  125.43750000,  -95.81250000
},
{
39.87500000,  38.37500000,  51.46875000,  -19.37500000
},
{
18.21875000,  24.53125000,  0.12500000,  14.06250000
},
{
15.15625000,  -17.62500000,  20.03125000,  13.56250000
},
{
-4.34375000,  4.68750000,  -1.84375000,  -4.65625000
},
{
44.31250000,  24.65625000,  16.75000000,  -35.62500000
},
{
10.,  -19.53125000,  10.90625000,  -11.03125000
},
{
57.31250000,  -56.50000000,  149.90625000,  -1.90625000
},
{
19.81250000,  -7.68750000,  -20.34375000,  -122.93750000
},
{
195.71875000,  -31.59375000,  30.50000000,  -96.84375000
},
{
-63.87500000,  -87.12500000,  -20.28125000,  -12.31250000
},
{
0.46875000,  -12.46875000,  49.46875000,  15.43750000
},
{
76.28125000,  -22.68750000,  43.81250000,  3.09375000
},
{
2.68750000,  -12.06250000,  -7.03125000,  -6.96875000
},
{
23.03125000,  -33.40625000,  2.46875000,  4.15625000
},
{
91.12500000,  -113.03125000,  128.50000000,  -54.37500000
},
{
-30.46875000,  -7.81250000,  18.71875000,  -13.90625000
},
{
89.15625000,  -32.46875000,  6.21875000,  -17.18750000
},
{
2.06250000,  -13.59375000,  4.93750000,  12.65625000
},
{
43.75000000,  -96.68750000,  11.84375000,  30.68750000
},
{
16.34375000,  -12.06250000,  1.25000000,  -3.34375000
},
{
74.37500000,  -132.62500000,  -58.21875000,  3.90625000
},
{
25.28125000,  -83.84375000,  66.87500000,  121.93750000
},
{
229.31250000,  -169.50000000,  117.09375000,  166.03125000
},
{
95.87500000,  -11.71875000,  13.46875000,  -47.96875000
},
{
251.53125000,  -126.75000000,  21.,  94.93750000
},
{
33.09375000,  -295.21875000,  81.,  5.09375000
},
{
8.90625000,  -97.56250000,  -12.96875000,  16.18750000
},
{
-21.65625000,  -112.46875000,  50.43750000,  -112.50000000
},
{
14.12500000,  -3.37500000,  59.50000000,  -19.59375000
},
{
-48.53125000,  -61.06250000,  46.09375000,  -32.31250000
},
{
-134.84375000,  -11.31250000,  54.84375000,  -29.93750000
},
{
-147.15625000,  -104.43750000,  271.40625000,  -164.56250000
},
{
-72.43750000,  -9.18750000,  210.81250000,  -70.87500000
},
{
26.,  -87.06250000,  -1.09375000,  -10.21875000
},
{
10.21875000,  8.93750000,  11.21875000,  11.03125000
},
{
-6.43750000,  -4.96875000,  11.46875000,  -7.09375000
},
{
25.84375000,  61.84375000,  0.40625000,  11.06250000
},
{
-40.43750000,  13.34375000,  31.15625000,  8.84375000
},
{
-0.31250000,  -4.28125000,  23.18750000,  0.37500000
},
{
-47.34375000,  -24.53125000,  96.53125000,  -72.15625000
},
{
17.09375000,  -32.53125000,  40.50000000,  -31.06250000
},
{
-85.12500000,  -227.09375000,  -108.43750000,  102.50000000
},
{
-134.59375000,  -2.71875000,  124.65625000,  75.56250000
},
{
14.18750000,  -16.12500000,  132.71875000,  88.40625000
},
{
30.50000000,  -72.28125000,  35.46875000,  -49.68750000
},
{
-61.40625000,  -104.40625000,  -117.06250000,  56.12500000
},
{
-3.71875000,  -28.81250000,  23.12500000,  16.34375000
},
{
-9.87500000,  -43.96875000,  75.53125000,  -40.87500000
},
{
-36.59375000,  43.03125000,  59.75000000,  8.03125000
},
{
-51.40625000,  -80.46875000,  -25.50000000,  39.62500000
},
{
-17.56250000,  25.62500000,  38.31250000,  18.90625000
},
{
-33.81250000,  -4.43750000,  53.18750000,  80.53125000
},
{
8.87500000,  -10.68750000,  -8.71875000,  6.53125000
},
{
12.84375000,  11.75000000,  3.03125000,  38.03125000
},
{
95.18750000,  -74.31250000,  19.59375000,  16.34375000
},
{
-2.59375000,  2.06250000,  2.71875000,  -2.40625000
},
{
57.87500000,  -65.81250000,  -33.78125000,  15.21875000
},
{
-7.25000000,  -23.81250000,  -47.28125000,  7.87500000
},
{
2.18750000,  46.03125000,  -8.53125000,  23.
},
{
-50.25000000,  -9.53125000,  -28.34375000,  -10.09375000
},
{
-40.84375000,  -17.56250000,  -13.93750000,  -45.25000000
},
{
46.71875000,  -33.28125000,  -0.21875000,  3.68750000
},
{
6.25000000,  0.90625000,  -15.,  -14.31250000
},
{
-4.43750000,  3.81250000,  -12.78125000,  -23.21875000
},
{
55.78125000,  -96.68750000,  0.84375000,  -98.84375000
},
{
-3.62500000,  6.56250000,  -4.90625000,  5.68750000
},
{
13.06250000,  1.09375000,  -2.37500000,  9.34375000
},
{
-1.46875000,  -26.96875000,  -2.09375000,  -6.81250000
},
{
98.43750000,  -83.78125000,  -37.28125000,  -28.
},
{
-3.09375000,  -13.40625000,  14.18750000,  -22.40625000
},
{
72.78125000,  -48.68750000,  -50.43750000,  -63.46875000
},
{
-2.53125000,  -72.75000000,  -11.56250000,  -154.03125000
},
{
288.03125000,  -131.50000000,  -112.68750000,  -267.96875000
},
{
1.75000000,  -43.59375000,  -18.90625000,  57.65625000
},
{
-12.25000000,  1.65625000,  9.25000000,  46.06250000
},
{
64.46875000,  -58.93750000,  10.21875000,  -22.62500000
},
{
2.96875000,  -11.21875000,  -25.15625000,  -3.03125000
},
{
189.46875000,  -54.78125000,  -85.68750000,  105.75000000
},
{
23.40625000,  -37.15625000,  -44.03125000,  37.87500000
},
{
21.21875000,  -4.28125000,  -19.65625000,  42.78125000
},
{
18.,  -158.40625000,  -121.25000000,  22.78125000
},
{
6.50000000,  56.18750000,  -22.40625000,  53.40625000
},
{
42.50000000,  58.06250000,  6.06250000,  37.53125000
},
{
-57.40625000,  9.75000000,  17.75000000,  29.50000000
},
{
72.84375000,  5.62500000,  -41.25000000,  9.84375000
},
{
19.37500000,  -15.96875000,  4.31250000,  73.46875000
},
{
20.18750000,  -16.65625000,  -75.25000000,  38.06250000
},
{
57.96875000,  42.31250000,  -46.87500000,  -5.
},
{
203.06250000,  -81.28125000,  -142.93750000,  24.25000000
},
{
30.90625000,  -186.12500000,  -73.93750000,  -80.71875000
},
{
14.15625000,  -42.25000000,  -17.,  24.25000000
},
{
3.96875000,  -97.28125000,  67.46875000,  -8.93750000
},
{
19.65625000,  19.25000000,  17.87500000,  -2.40625000
},
{
7.53125000,  -67.65625000,  -74.78125000,  58.87500000
},
{
7.90625000,  3.46875000,  -1.96875000,  20.43750000
},
{
-22.40625000,  0.87500000,  15.56250000,  0.84375000
},
{
16.12500000,  -7.12500000,  -10.90625000,  -11.78125000
},
{
-30.37500000,  -52.87500000,  -13.37500000,  -74.46875000
},
{
-0.37500000,  -0.31250000,  1.25000000,  1.18750000
},
{
-30.43750000,  -11.15625000,  12.25000000,  20.
},
{
61.71875000,  37.21875000,  -16.81250000,  -34.
},
{
-1.46875000,  -13.62500000,  -9.50000000,  18.25000000
},
{
6.31250000,  -17.96875000,  -7.15625000,  -22.37500000
},
{
-3.34375000,  -13.25000000,  -34.09375000,  -19.75000000
},
{
131.84375000,  -71.25000000,  -100.18750000,  -102.43750000
},
{
-165.65625000,  -124.81250000,  1.87500000,  84.84375000
},
{
-49.,  -31.71875000,  9.65625000,  196.75000000
},
{
109.15625000,  -43.78125000,  109.81250000,  87.34375000
},
{
23.03125000,  -60.84375000,  52.71875000,  33.34375000
},
{
168.96875000,  -140.59375000,  -97.15625000,  266.28125000
},
{
34.43750000,  -102.65625000,  -8.21875000,  76.43750000
},
{
75.84375000,  -18.62500000,  -30.12500000,  40.56250000
},
{
10.78125000,  -26.93750000,  -11.71875000,  3.03125000
},
{
-16.21875000,  -18.81250000,  -24.75000000,  27.65625000
},
{
-33.40625000,  8.,  -16.15625000,  37.
},
{
-42.93750000,  -37.09375000,  116.56250000,  140.53125000
},
{
-1.25000000,  32.75000000,  22.50000000,  38.75000000
},
{
32.18750000,  -44.21875000,  -136.50000000,  83.62500000
},
{
-22.75000000,  1.93750000,  -10.53125000,  21.56250000
},
{
-17.37500000,  -24.87500000,  7.18750000,  43.59375000
},
{
54.96875000,  -31.59375000,  -89.62500000,  -34.81250000
},
{
-42.84375000,  -178.15625000,  -16.50000000,  -0.18750000
},
{
-94.68750000,  -35.75000000,  -27.15625000,  0.90625000
},
{
-105.56250000,  -94.06250000,  -86.34375000,  -60.71875000
},
{
-126.68750000,  -54.71875000,  -101.18750000,  -123.34375000
},
{
-6.71875000,  -51.78125000,  31.28125000,  8.81250000
},
{
-3.87500000,  -1.46875000,  -2.62500000,  2.31250000
},
{
-30.59375000,  -30.37500000,  17.40625000,  -28.28125000
},
{
-62.96875000,  -20.03125000,  -78.53125000,  -29.03125000
},
{
0.12500000,  -27.09375000,  1.68750000,  7.96875000
},
{
-1.06250000,  -5.37500000,  -2.18750000,  -2.21875000
},
{
-20.21875000,  -8.78125000,  -22.25000000,  -32.59375000
},
{
-32.15625000,  -1.71875000,  -27.25000000,  -97.78125000
},
{
-33.90625000,  19.93750000,  4.18750000,  24.78125000
},
{
-15.09375000,  -67.59375000,  -50.46875000,  -33.40625000
},
{
-28.78125000,  -6.46875000,  -102.31250000,  -6.18750000
},
{
29.34375000,  -32.31250000,  -206.65625000,  -152.46875000
},
{
-113.96875000,  -15.59375000,  -143.31250000,  31.65625000
},
{
-103.09375000,  -57.15625000,  54.03125000,  42.90625000
},
{
-46.,  9.81250000,  -20.25000000,  14.93750000
},
{
-100.75000000,  -27.03125000,  7.37500000,  -77.12500000
},
{
-4.37500000,  -54.25000000,  -87.,  114.84375000
},
{
3.40625000,  -21.06250000,  53.68750000,  42.
},
{
14.46875000,  28.34375000,  38.43750000,  58.37500000
},
{
11.46875000,  -15.43750000,  -22.12500000,  23.53125000
},
{
-9.87500000,  -24.31250000,  -138.15625000,  34.09375000
},
{
-21.59375000,  -0.46875000,  -18.34375000,  -11.75000000
},
{
-98.84375000,  -20.25000000,  -56.78125000,  35.75000000
},
{
-2.59375000,  -9.62500000,  -11.46875000,  0.18750000
},
{
-46.65625000,  -0.06250000,  -54.90625000,  83.56250000
},
{
55.56250000,  -35.31250000,  -2.81250000,  36.31250000
},
{
9.37500000,  -8.25000000,  8.93750000,  3.37500000
},
{
55.28125000,  -114.18750000,  -59.18750000,  -21.06250000
},
{
-190.43750000,  -423.12500000,  -46.15625000,  -79.
},
{
-63.37500000,  -6.,  -32.90625000,  125.15625000
},
{
-45.18750000,  -252.15625000,  -78.21875000,  -150.50000000
},
{
10.09375000,  -74.06250000,  -75.65625000,  -36.21875000
},
{
10.84375000,  -214.21875000,  32.75000000,  104.46875000
},
{
-19.87500000,  -48.25000000,  5.06250000,  18.65625000
},
{
-124.81250000,  -86.37500000,  63.87500000,  -17.40625000
},
{
-15.93750000,  -10.78125000,  42.59375000,  -24.18750000
},
{
-6.59375000,  -154.78125000,  51.03125000,  -33.96875000
},
{
-11.81250000,  -17.46875000,  17.18750000,  2.53125000
},
{
48.59375000,  -126.90625000,  2.90625000,  -57.59375000
},
{
-6.09375000,  -11.03125000,  2.15625000,  -2.56250000
},
{
6.12500000,  -40.37500000,  29.93750000,  46.40625000
},
{
-2.15625000,  -0.28125000,  -5.96875000,  -7.96875000
},
{
-16.50000000,  -14.71875000,  0.78125000,  12.15625000
},
{
-5.65625000,  -25.75000000,  -123.25000000,  -51.65625000
},
{
-490.12500000,  -308.81250000,  -351.78125000,  104.87500000
},
{
-448.78125000,  -106.50000000,  -37.59375000,  376.68750000
},
{
-103.62500000,  -55.03125000,  -148.56250000,  11.37500000
},
{
-142.65625000,  -10.75000000,  33.09375000,  12.21875000
},
{
-143.28125000,  -221.09375000,  -240.84375000,  432.40625000
},
{
-38.37500000,  -4.,  -46.21875000,  176.34375000
},
{
7.78125000,  -58.81250000,  64.37500000,  206.56250000
},
{
-47.09375000,  -13.12500000,  7.18750000,  74.46875000
},
{
-87.62500000,  -150.59375000,  -158.12500000,  -10.65625000
},
{
-117.31250000,  -79.50000000,  -7.84375000,  29.37500000
},
{
-42.28125000,  -26.71875000,  -1.28125000,  0.15625000
},
{
-30.37500000,  -1.12500000,  -4.37500000,  5.71875000
},
{
105.46875000,  -53.06250000,  -61.18750000,  180.90625000
},
{
18.96875000,  -16.31250000,  -2.56250000,  30.87500000
},
{
3.12500000,  -17.21875000,  -1.31250000,  41.
},
{
7.65625000,  -2.37500000,  -5.25000000,  -2.21875000
},
  },
{
  /*****************************************************************************
   *
   * modifed shape6 - table
   *
   * 16 bits signed; scale_factor 1; 
   * quantized with: fixed_value = (original_value * 2^6 * scale factor +- 0.5)
   *                 float_value = fixed_value / (scale_factor * 2^6)
   * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
   *
   *****************************************************************************/
{
-58.87500000,  14.79687500,  -80.14062500,  49.35937500
},
{
29.,  10.07812500,  -24.76562500,  11.62500000
},
{
-67.76562500,  40.48437500,  28.,  16.65625000
},
{
-77.57812500,  -13.21875000,  -14.85937500,  -14.01562500
},
{
-135.79687500,  53.06250000,  -78.90625000,  -35.75000000
},
{
-42.53125000,  -44.06250000,  -33.12500000,  6.04687500
},
{
-22.48437500,  -33.01562500,  -5.71875000,  -21.43750000
},
{
-47.53125000,  4.14062500,  27.21875000,  -82.28125000
},
{
12.14062500,  5.28125000,  7.60937500,  4.45312500
},
{
129.20312500,  67.89062500,  -51.01562500,  -72.14062500
},
{
-23.01562500,  0.79687500,  142.48437500,  112.98437500
},
{
-2.06250000,  1.96875000,  1.96875000,  2.12500000
},
{
-14.04687500,  -11.04687500,  -42.56250000,  -38.21875000
},
{
20.28125000,  34.31250000,  -71.45312500,  -7.89062500
},
{
-17.39062500,  13.57812500,  11.45312500,  83.76562500
},
{
10.21875000,  -12.29687500,  -18.14062500,  -12.59375000
},
{
-16.03125000,  150.57812500,  -92.43750000,  64.95312500
},
{
42.01562500,  6.32812500,  1.34375000,  -29.65625000
},
{
-102.85937500,  235.23437500,  71.62500000,  85.62500000
},
{
-79.98437500,  56.40625000,  134.68750000,  -86.84375000
},
{
-23.18750000,  20.35937500,  -7.57812500,  -11.53125000
},
{
6.09375000,  19.42187500,  -1.34375000,  -9.81250000
},
{
-31.32812500,  58.62500000,  -40.79687500,  -60.95312500
},
{
4.42187500,  103.28125000,  108.28125000,  -247.46875000
},
{
37.51562500,  88.48437500,  82.06250000,  60.70312500
},
{
364.,  79.32812500,  118.50000000,  -102.01562500
},
{
-26.92187500,  62.39062500,  4.42187500,  20.51562500
},
{
8.71875000,  -29.32812500,  32.92187500,  -33.87500000
},
{
-0.01562500,  5.92187500,  -13.85937500,  9.35937500
},
{
22.87500000,  90.25000000,  -5.84375000,  -54.14062500
},
{
0.59375000,  -23.21875000,  -52.95312500,  18.35937500
},
{
5.09375000,  11.50000000,  -1.53125000,  -37.54687500
},
{
58.87500000,  -14.79687500,  80.14062500,  -49.35937500
},
{
-29.,  -10.07812500,  24.76562500,  -11.62500000
},
{
67.76562500,  -40.48437500,  -28.,  -16.65625000
},
{
77.57812500,  13.21875000,  14.85937500,  14.01562500
},
{
135.79687500,  -53.06250000,  78.90625000,  35.75000000
},
{
42.53125000,  44.06250000,  33.12500000,  -6.04687500
},
{
22.48437500,  33.01562500,  5.71875000,  21.43750000
},
{
47.53125000,  -4.14062500,  -27.21875000,  82.28125000
},
{
-12.14062500,  -5.28125000,  -7.60937500,  -4.45312500
},
{
-129.20312500,  -67.89062500,  51.01562500,  72.14062500
},
{
23.01562500,  -0.79687500,  -142.48437500,  -112.98437500
},
{
2.06250000,  -1.96875000,  -1.96875000,  -2.12500000
},
{
14.04687500,  11.04687500,  42.56250000,  38.21875000
},
{
-20.28125000,  -34.31250000,  71.45312500,  7.89062500
},
{
17.39062500,  -13.57812500,  -11.45312500,  -83.76562500
},
{
-10.21875000,  12.29687500,  18.14062500,  12.59375000
},
{
16.03125000,  -150.57812500,  92.43750000,  -64.95312500
},
{
-42.01562500,  -6.32812500,  -1.34375000,  29.65625000
},
{
102.85937500,  -235.23437500,  -71.62500000,  -85.62500000
},
{
79.98437500,  -56.40625000,  -134.68750000,  86.84375000
},
{
23.18750000,  -20.35937500,  7.57812500,  11.53125000
},
{
-6.09375000,  -19.42187500,  1.34375000,  9.81250000
},
{
31.32812500,  -58.62500000,  40.79687500,  60.95312500
},
{
-4.42187500,  -103.28125000,  -108.28125000,  247.46875000
},
{
-37.51562500,  -88.48437500,  -82.06250000,  -60.70312500
},
{
-364.,  -79.32812500,  -118.50000000,  102.01562500
},
{
26.92187500,  -62.39062500,  -4.42187500,  -20.51562500
},
{
-8.71875000,  29.32812500,  -32.92187500,  33.87500000
},
{
0.01562500,  -5.92187500,  13.85937500,  -9.35937500
},
{
-22.87500000,  -90.25000000,  5.84375000,  54.14062500
},
{
-0.59375000,  23.21875000,  52.95312500,  -18.35937500
},
{
-5.09375000,  -11.50000000,  1.53125000,  37.54687500
},
  },
  };
