/*

This software module was originally developed by

    Masayuki Nishiguchi (Sony Corporation)

    and edited by 

    Christian Mittendorf (Robert Bosch GmbH Germany)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/

#ifdef _MSC_VER
#pragma warning(disable:4305)
#endif

static cbook_lpc cba_lpc =
{
  {
    /*****************************************************************************
     *
     * modifed gain-table
     *
     * 16 bits signed; scale_factor 1; 
     * quantized with: fixed_value = (original_value * 2^2 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^2)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
    14.2500,  24.5000,  51.5000,  38.0000,  
    156.2500,  120.0000,  69.5000,  91.0000,  
    1136.0000,  946.7500,  615.0000,  769.2500,  
    206.5000,  277.5000,  485.0000,  370.5000,  
    6657.0000,  5553.0000,  4463.2500,  5034.5000,  
    3160.5000,  3422.7500,  4025.7500,  3693.5000,  
    1340.5000,  1543.0000,  2001.2500,  1781.2500,  
    2879.7500,  2672.0000,  2238.5000,  2464.0000,  
  },
  {
    /*****************************************************************************
     *
     * modifed shape1 - table
     *
     * 16 bits signed; scale_factor 4; 
     * quantized with: fixed_value = (original_value * 2^15 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^15)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
{
0.0588226318359375,  0.0938644409179688,  0.0471191406250000,  0.0131225585937500,  
0.0426788330078125,  0.0564575195312500,  0.0210723876953125,  0.0014114379882812,  
0.0190811157226562,  0.0325317382812500,  0.0293960571289062,  0.0225677490234375,  
0.0312042236328125,  0.0520477294921875,  0.0502243041992188,  0.0356445312500000,  
0.0302963256835938,  0.0361099243164062,  0.0250930786132812,  0.0183258056640625,  
0.0260467529296875,  0.0368957519531250,  0.0418319702148438,  0.0410079956054688,  
0.0441589355468750,  0.0469207763671875,  0.0527420043945312,  0.0442276000976562,  
0.0356674194335938,  0.0351791381835938,  0.0401916503906250,  0.0298385620117188,  
0.0169296264648438,  0.0129013061523438,  0.0198059082031250,  0.0248565673828125,  
0.0325698852539062,  0.0432586669921875,  0.0569152832031250,  0.0633010864257812,  
0.0512008666992188,  0.0231933593750000,  0.0185317993164062,  0.0071563720703125
},
{
0.0488739013671875,  0.0794143676757812,  0.0612411499023438,  0.0558776855468750,  
0.0706863403320312,  0.0556869506835938,  0.0205307006835938,  -0.0006790161132812,  
0.0041732788085938,  0.0217132568359375,  0.0311355590820312,  0.0283660888671875,  
0.0217285156250000,  0.0331954956054688,  0.0454559326171875,  0.0646972656250000,  
0.0736236572265625,  0.0670089721679688,  0.0448379516601562,  0.0348358154296875,  
0.0419616699218750,  0.0551376342773438,  0.0671997070312500,  0.0678329467773438,  
0.0561599731445312,  0.0473709106445312,  0.0432739257812500,  0.0421600341796875,  
0.0400314331054688,  0.0390625000000000,  0.0401458740234375,  0.0278549194335938,  
0.0107879638671875,  0.0067214965820312,  0.0155487060546875,  0.0250015258789062,  
0.0302505493164062,  0.0308914184570312,  0.0352706909179688,  0.0418930053710938,  
0.0420227050781250,  0.0532913208007812,  0.0915527343750000,  0.0854339599609375
},
{
0.0246810913085938,  0.0422286987304688,  0.0417861938476562,  0.0420455932617188,  
0.0494384765625000,  0.0505523681640625,  0.0423355102539062,  0.0280456542968750,  
0.0193786621093750,  0.0234756469726562,  0.0345611572265625,  0.0341949462890625,  
0.0296554565429688,  0.0458602905273438,  0.0489654541015625,  0.0491714477539062,  
0.0487670898437500,  0.0560989379882812,  0.0503692626953125,  0.0362243652343750,  
0.0376052856445312,  0.0484695434570312,  0.0480651855468750,  0.0379028320312500,  
0.0324935913085938,  0.0329513549804688,  0.0372390747070312,  0.0518569946289062,  
0.0843200683593750,  0.1017150878906250,  0.1166534423828125,  0.1223678588867188,  
0.0999984741210938,  0.0721817016601562,  0.0401535034179688,  0.0205764770507812,  
0.0156173706054688,  0.0158691406250000,  0.0269699096679688,  0.0351715087890625,  
0.0241394042968750,  -0.0051803588867188,  -0.0063400268554688,  0.0053405761718750
},
{
0.0323181152343750,  0.0694732666015625,  0.0861740112304688,  0.0842208862304688,  
0.0790328979492188,  0.0686874389648438,  0.0532608032226562,  0.0337295532226562,  
0.0205307006835938,  0.0152969360351562,  0.0172576904296875,  0.0173873901367188,  
0.0174636840820312,  0.0312423706054688,  0.0309143066406250,  0.0252685546875000,  
0.0274047851562500,  0.0300903320312500,  0.0219345092773438,  0.0142211914062500,  
0.0160293579101562,  0.0241928100585938,  0.0248184204101562,  0.0241241455078125,  
0.0227890014648438,  0.0261611938476562,  0.0268936157226562,  0.0234832763671875,  
0.0220947265625000,  0.0190277099609375,  0.0138320922851562,  0.0070190429687500,  
0.0022277832031250,  0.0054550170898438,  0.0183181762695312,  0.0246734619140625,  
0.0308914184570312,  0.0338897705078125,  0.0381317138671875,  0.0401000976562500,  
0.0283126831054688,  -0.0030136108398438,  -0.0011749267578125,  0.0105056762695312
},
{
0.1064605712890625,  0.0673294067382812,  -0.0167160034179688,  0.0073013305664062,  
0.0220489501953125,  0.0187759399414062,  0.0207672119140625,  0.0179367065429688,  
0.0197753906250000,  0.0286865234375000,  0.0371704101562500,  0.0274047851562500,  
0.0123138427734375,  0.0237503051757812,  0.0299987792968750,  0.0385894775390625,  
0.0397338867187500,  0.0357742309570312,  0.0218200683593750,  0.0090789794921875,  
0.0118103027343750,  0.0242538452148438,  0.0368499755859375,  0.0375137329101562,  
0.0385437011718750,  0.0423202514648438,  0.0441970825195312,  0.0453491210937500,  
0.0468063354492188,  0.0419540405273438,  0.0294036865234375,  0.0158309936523438,  
0.0036087036132812,  0.0078887939453125,  0.0216293334960938,  0.0251083374023438,  
0.0333251953125000,  0.0396118164062500,  0.0495758056640625,  0.0513916015625000,  
0.0324096679687500,  0.0040893554687500,  -0.0049209594726562,  -0.0065689086914062
},
{
0.0169754028320312,  0.0413513183593750,  0.0649032592773438,  0.0790328979492188,  
0.0720443725585938,  0.0367050170898438,  -0.0104064941406250,  -0.0328369140625000,  
-0.0215988159179688,  0.0033111572265625,  0.0226135253906250,  0.0252685546875000,  
0.0160675048828125,  0.0220108032226562,  0.0204238891601562,  0.0163421630859375,  
0.0216674804687500,  0.0307312011718750,  0.0288619995117188,  0.0179061889648438,  
0.0176315307617188,  0.0226593017578125,  0.0253143310546875,  0.0213088989257812,  
0.0152435302734375,  0.0154190063476562,  0.0183639526367188,  0.0165557861328125,  
0.0151901245117188,  0.0162048339843750,  0.0193328857421875,  0.0161514282226562,  
0.0121765136718750,  0.0132217407226562,  0.0135726928710938,  0.0118255615234375,  
0.0136947631835938,  0.0118637084960938,  0.0224609375000000,  0.0319137573242188,  
0.0220260620117188,  -0.0056152343750000,  -0.0094757080078125,  -0.0011596679687500
},
{
0.0101165771484375,  0.0360412597656250,  0.0760421752929688,  0.1185531616210938,  
0.1243896484375000,  0.0810470581054688,  0.0241317749023438,  -0.0060119628906250,  
0.0116043090820312,  0.0443954467773438,  0.0631179809570312,  0.0530395507812500,  
0.0333480834960938,  0.0309753417968750,  0.0283660888671875,  0.0251617431640625,  
0.0313339233398438,  0.0409240722656250,  0.0373153686523438,  0.0230560302734375,  
0.0234146118164062,  0.0318069458007812,  0.0357666015625000,  0.0262985229492188,  
0.0199203491210938,  0.0236587524414062,  0.0298690795898438,  0.0338821411132812,  
0.0358657836914062,  0.0379562377929688,  0.0266189575195312,  0.0116958618164062,  
-0.0001296997070312,  0.0016708374023438,  0.0142974853515625,  0.0239257812500000,  
0.0314025878906250,  0.0301132202148438,  0.0380554199218750,  0.0410919189453125,  
0.0258789062500000,  -0.0080642700195312,  -0.0174789428710938,  -0.0109405517578125
},
{
0.0433044433593750,  0.0860214233398438,  0.0872421264648438,  0.0617980957031250,  
0.0336914062500000,  0.0145187377929688,  0.0032730102539062,  -0.0009918212890625,  
0.0121307373046875,  0.0347290039062500,  0.0570144653320312,  0.0543136596679688,  
0.0342178344726562,  0.0289459228515625,  0.0211029052734375,  0.0155868530273438,  
0.0223999023437500,  0.0256729125976562,  0.0203933715820312,  0.0152130126953125,  
0.0205535888671875,  0.0317916870117188,  0.0342864990234375,  0.0314407348632812,  
0.0302658081054688,  0.0334091186523438,  0.0355224609375000,  0.0333633422851562,  
0.0281143188476562,  0.0225906372070312,  0.0159912109375000,  0.0090408325195312,  
0.0042114257812500,  0.0108642578125000,  0.0284042358398438,  0.0395431518554688,  
0.0448074340820312,  0.0386886596679688,  0.0403442382812500,  0.0429382324218750,  
0.0319976806640625,  0.0030288696289062,  -0.0050506591796875,  0.0001907348632812
},
{
0.0610809326171875,  0.1101150512695312,  0.1034164428710938,  0.0596618652343750,  
0.0428466796875000,  0.0743789672851562,  0.1180114746093750,  0.1061401367187500,  
0.0626525878906250,  0.0371475219726562,  0.0426025390625000,  0.0562667846679688,  
0.0695571899414062,  0.0928192138671875,  0.0886535644531250,  0.0743713378906250,  
0.0695419311523438,  0.0688171386718750,  0.0622024536132812,  0.0537567138671875,  
0.0547027587890625,  0.0628356933593750,  0.0670623779296875,  0.0638504028320312,  
0.0631637573242188,  0.0652923583984375,  0.0728607177734375,  0.0761413574218750,  
0.0754165649414062,  0.0642929077148438,  0.0573730468750000,  0.0456695556640625,  
0.0391998291015625,  0.0397567749023438,  0.0551681518554688,  0.0689163208007812,  
0.0800933837890625,  0.0852661132812500,  0.0931320190429688,  0.0966644287109375,  
0.0816802978515625,  0.0534362792968750,  0.0491409301757812,  0.0317001342773438
},
{
0.0384216308593750,  0.0778579711914062,  0.0879516601562500,  0.0750732421875000,  
0.0706710815429688,  0.0670013427734375,  0.0608291625976562,  0.0579071044921875,  
0.0566635131835938,  0.0561523437500000,  0.0575942993164062,  0.0508651733398438,  
0.0498046875000000,  0.0701980590820312,  0.0784149169921875,  0.0801696777343750,  
0.0847930908203125,  0.0767059326171875,  0.0604248046875000,  0.0489425659179688,  
0.0524063110351562,  0.0662765502929688,  0.0772628784179688,  0.0877304077148438,  
0.1031570434570312,  0.1278610229492188,  0.1333694458007812,  0.1086196899414062,  
0.0762252807617188,  0.0555191040039062,  0.0419540405273438,  0.0306930541992188,  
0.0234146118164062,  0.0244293212890625,  0.0346679687500000,  0.0430679321289062,  
0.0552902221679688,  0.0751190185546875,  0.1135559082031250,  0.1684265136718750,  
0.1822891235351562,  0.1308135986328125,  0.0706634521484375,  0.0224151611328125
},
{
0.0223388671875000,  0.0483627319335938,  0.0572280883789062,  0.0603332519531250,  
0.0645828247070312,  0.0668106079101562,  0.0586166381835938,  0.0523681640625000,  
0.0529022216796875,  0.0555191040039062,  0.0610427856445312,  0.0525054931640625,  
0.0376815795898438,  0.0528030395507812,  0.0621490478515625,  0.0661468505859375,  
0.0695037841796875,  0.0723495483398438,  0.0610504150390625,  0.0481948852539062,  
0.0474319458007812,  0.0527877807617188,  0.0520019531250000,  0.0502014160156250,  
0.0523986816406250,  0.0557937622070312,  0.0599670410156250,  0.0589599609375000,  
0.0588073730468750,  0.0543212890625000,  0.0336990356445312,  0.0228500366210938,  
0.0429077148437500,  0.1064758300781250,  0.1744537353515625,  0.2002258300781250,  
0.1936111450195312,  0.1571273803710938,  0.1092376708984375,  0.0617065429687500,  
0.0284881591796875,  -0.0064315795898438,  -0.0106887817382812,  -0.0058517456054688
},
{
0.0177307128906250,  0.0373535156250000,  0.0514602661132812,  0.0715103149414062,  
0.1014099121093750,  0.1200408935546875,  0.1146011352539062,  0.0878601074218750,  
0.0622024536132812,  0.0465469360351562,  0.0412902832031250,  0.0326385498046875,  
0.0287094116210938,  0.0515518188476562,  0.0714645385742188,  0.0857086181640625,  
0.0970382690429688,  0.1046447753906250,  0.0938491821289062,  0.0814666748046875,  
0.0805511474609375,  0.0877304077148438,  0.0861129760742188,  0.0762100219726562,  
0.0625762939453125,  0.0567550659179688,  0.0584106445312500,  0.0626525878906250,  
0.0648880004882812,  0.0617599487304688,  0.0595092773437500,  0.0483856201171875,  
0.0416412353515625,  0.0442810058593750,  0.0549545288085938,  0.0631866455078125,  
0.0678939819335938,  0.0694503784179688,  0.0801544189453125,  0.0881729125976562,  
0.0831527709960938,  0.0611495971679688,  0.0537796020507812,  0.0433273315429688
},
{
0.0403671264648438,  0.0693893432617188,  0.0474319458007812,  0.0228042602539062,  
0.0257186889648438,  0.0500106811523438,  0.0721359252929688,  0.0824508666992188,  
0.0763854980468750,  0.0677413940429688,  0.0671463012695312,  0.0602111816406250,  
0.0473327636718750,  0.0622634887695312,  0.0756225585937500,  0.0811843872070312,  
0.0755157470703125,  0.0753555297851562,  0.0680770874023438,  0.0615386962890625,  
0.0578308105468750,  0.0568618774414062,  0.0584869384765625,  0.0573654174804688,  
0.0559921264648438,  0.0619125366210938,  0.0658187866210938,  0.0681152343750000,  
0.0665283203125000,  0.0535812377929688,  0.0437545776367188,  0.0320663452148438,  
0.0250473022460938,  0.0266418457031250,  0.0374145507812500,  0.0411148071289062,  
0.0379486083984375,  0.0353088378906250,  0.0447463989257812,  0.0548171997070312,  
0.0720977783203125,  0.1140441894531250,  0.1838760375976562,  0.1852874755859375
},
{
0.0571060180664062,  0.0548858642578125,  0.0057983398437500,  0.0476531982421875,  
0.0937194824218750,  0.0363464355468750,  -0.0043945312500000,  0.0200958251953125,  
0.0386276245117188,  0.0354843139648438,  0.0264739990234375,  0.0192184448242188,  
0.0183792114257812,  0.0313186645507812,  0.0300521850585938,  0.0274353027343750,  
0.0369567871093750,  0.0413360595703125,  0.0319519042968750,  0.0254669189453125,  
0.0270385742187500,  0.0378112792968750,  0.0412826538085938,  0.0427780151367188,  
0.0394210815429688,  0.0382232666015625,  0.0428695678710938,  0.0434417724609375,  
0.0376510620117188,  0.0348510742187500,  0.0304412841796875,  0.0193634033203125,  
0.0056762695312500,  0.0031433105468750,  0.0179367065429688,  0.0266876220703125,  
0.0392608642578125,  0.0501403808593750,  0.0633316040039062,  0.0636978149414062,  
0.0517196655273438,  0.0161209106445312,  0.0050735473632812,  0.0079193115234375
},
{
0.0294570922851562,  0.0599212646484375,  0.0805130004882812,  0.0921173095703125,  
0.1051635742187500,  0.1046371459960938,  0.0863723754882812,  0.0599594116210938,  
0.0498657226562500,  0.0634078979492188,  0.0952529907226562,  0.1230087280273438,  
0.1308135986328125,  0.1261672973632812,  0.0956268310546875,  0.0715484619140625,  
0.0668563842773438,  0.0697097778320312,  0.0644760131835938,  0.0606460571289062,  
0.0643539428710938,  0.0703048706054688,  0.0696105957031250,  0.0632019042968750,  
0.0552825927734375,  0.0528793334960938,  0.0578994750976562,  0.0677261352539062,  
0.0795440673828125,  0.0795593261718750,  0.0769424438476562,  0.0658035278320312,  
0.0556488037109375,  0.0554351806640625,  0.0662841796875000,  0.0753250122070312,  
0.0806655883789062,  0.0830459594726562,  0.0929718017578125,  0.0995178222656250,  
0.0852813720703125,  0.0462493896484375,  0.0330581665039062,  0.0279846191406250
},
{
0.0405807495117188,  0.0797882080078125,  0.0872955322265625,  0.0696258544921875,  
0.0503921508789062,  0.0371093750000000,  0.0342254638671875,  0.0443496704101562,  
0.0638504028320312,  0.0755462646484375,  0.0723190307617188,  0.0555419921875000,  
0.0426940917968750,  0.0592880249023438,  0.0720748901367188,  0.0788803100585938,  
0.0924682617187500,  0.1041030883789062,  0.1004714965820312,  0.0903244018554688,  
0.0857315063476562,  0.0795898437500000,  0.0639114379882812,  0.0519332885742188,  
0.0446395874023438,  0.0456314086914062,  0.0532302856445312,  0.0611877441406250,  
0.0777282714843750,  0.0839614868164062,  0.0747604370117188,  0.0548934936523438,  
0.0365600585937500,  0.0327377319335938,  0.0437622070312500,  0.0513992309570312,  
0.0516967773437500,  0.0500488281250000,  0.0598831176757812,  0.0730590820312500,  
0.0679321289062500,  0.0414276123046875,  0.0323486328125000,  0.0213394165039062
},
  },
  {
    /*****************************************************************************
     *
     * modifed shape2 - table
     *
     * 16 bits signed; scale_factor 4; 
     * quantized with: fixed_value = (original_value * 2^15 * scale factor +- 0.5)
     *                 float_value = fixed_value / (scale_factor * 2^15)
     * 09.09.98 Christian Mittendorf, Robert Bosch GmbH Germany
     *
     *****************************************************************************/
{
0.0387039184570312,  0.0729904174804688,  0.0752334594726562,  0.0595397949218750,  
0.0691452026367188,  0.0725555419921875,  0.0526580810546875,  0.0332412719726562,  
0.0279235839843750,  0.0313644409179688,  0.0359268188476562,  0.0471572875976562,  
0.0543594360351562,  0.0464630126953125,  0.0614089965820312,  0.0731964111328125,  
0.0574340820312500,  0.0440292358398438,  0.0514755249023438,  0.0607681274414062,  
0.0593490600585938,  0.0491561889648438,  0.0389633178710938,  0.0431671142578125,  
0.0477905273437500,  0.0519714355468750,  0.0546188354492188,  0.0593490600585938,  
0.0690841674804688,  0.0666809082031250,  0.0596847534179688,  0.0631027221679688,  
0.0694580078125000,  0.0691375732421875,  0.0589447021484375,  0.0484085083007812,  
0.0417709350585938,  0.0399856567382812,  0.0313720703125000,  0.0311737060546875,  
0.0492095947265625,  0.0785751342773438,  0.0799942016601562,  0.0570755004882812
},
{
0.0554809570312500,  0.1009368896484375,  0.0834503173828125,  0.0512924194335938,  
0.0854263305664062,  0.1392364501953125,  0.1154479980468750,  0.0734100341796875,  
0.0701980590820312,  0.0777511596679688,  0.0820693969726562,  0.0799102783203125,  
0.0786972045898438,  0.0653228759765625,  0.0631484985351562,  0.0706787109375000,  
0.0687332153320312,  0.0640106201171875,  0.0685653686523438,  0.0744400024414062,  
0.0737762451171875,  0.0691070556640625,  0.0716629028320312,  0.0795974731445312,  
0.0868148803710938,  0.0827255249023438,  0.0742034912109375,  0.0734176635742188,  
0.0715255737304688,  0.0737991333007812,  0.0730590820312500,  0.0792160034179688,  
0.0899734497070312,  0.0980758666992188,  0.1072769165039062,  0.1080932617187500,  
0.1041641235351562,  0.1143112182617188,  0.1145401000976562,  0.1022262573242188,  
0.0933685302734375,  0.1047363281250000,  0.0867004394531250,  0.0511550903320312
},
{
0.0225753784179688,  0.0568084716796875,  0.1048812866210938,  0.1419830322265625,  
0.1448440551757812,  0.1308975219726562,  0.1180572509765625,  0.0992355346679688,  
0.0718383789062500,  0.0486679077148438,  0.0356369018554688,  0.0444183349609375,  
0.0705566406250000,  0.0791473388671875,  0.0843048095703125,  0.0822982788085938,  
0.0698013305664062,  0.0650558471679688,  0.0690917968750000,  0.0744934082031250,  
0.0683670043945312,  0.0603561401367188,  0.0625839233398438,  0.0696105957031250,  
0.0680770874023438,  0.0624008178710938,  0.0587539672851562,  0.0591812133789062,  
0.0617980957031250,  0.0684204101562500,  0.0804595947265625,  0.0933761596679688,  
0.1053924560546875,  0.1039047241210938,  0.0900573730468750,  0.0760269165039062,  
0.0647506713867188,  0.0589904785156250,  0.0497283935546875,  0.0456008911132812,  
0.0608901977539062,  0.0882263183593750,  0.0803680419921875,  0.0578231811523438
},
{
0.0067214965820312,  0.0292510986328125,  0.0727386474609375,  0.1196823120117188,  
0.1493148803710938,  0.1611862182617188,  0.1626358032226562,  0.1578216552734375,  
0.1400299072265625,  0.1222229003906250,  0.1075820922851562,  0.1091766357421875,  
0.1176071166992188,  0.1019210815429688,  0.0966262817382812,  0.0937423706054688,  
0.0904464721679688,  0.0845718383789062,  0.0906753540039062,  0.0971145629882812,  
0.0916290283203125,  0.0849151611328125,  0.0804519653320312,  0.0846557617187500,  
0.0931243896484375,  0.0916900634765625,  0.0877761840820312,  0.0845794677734375,  
0.0828475952148438,  0.0875930786132812,  0.0958404541015625,  0.1076507568359375,  
0.1229400634765625,  0.1251678466796875,  0.1124114990234375,  0.1005935668945312,  
0.0917282104492188,  0.0887451171875000,  0.0837478637695312,  0.0862197875976562,  
0.1073379516601562,  0.1376495361328125,  0.1215057373046875,  0.0870590209960938
},
{
0.0561523437500000,  0.1115570068359375,  0.1195449829101562,  0.0714721679687500,  
0.0210189819335938,  0.0158920288085938,  0.0390396118164062,  0.0587539672851562,  
0.0543212890625000,  0.0367507934570312,  0.0233459472656250,  0.0277862548828125,  
0.0347442626953125,  0.0228958129882812,  0.0218505859375000,  0.0283355712890625,  
0.0312805175781250,  0.0300140380859375,  0.0311584472656250,  0.0357284545898438,  
0.0335388183593750,  0.0266189575195312,  0.0228576660156250,  0.0299758911132812,  
0.0388336181640625,  0.0383529663085938,  0.0354232788085938,  0.0315399169921875,  
0.0286178588867188,  0.0282287597656250,  0.0326766967773438,  0.0454559326171875,  
0.0552673339843750,  0.0539550781250000,  0.0441513061523438,  0.0367355346679688,  
0.0334625244140625,  0.0272445678710938,  0.0147933959960938,  0.0083694458007812,  
0.0223464965820312,  0.0511245727539062,  0.0569381713867188,  0.0559692382812500
},
{
0.0396423339843750,  0.0811386108398438,  0.0924453735351562,  0.0786056518554688,  
0.0559463500976562,  0.0413589477539062,  0.0407104492187500,  0.0507202148437500,  
0.0699844360351562,  0.0975952148437500,  0.1210632324218750,  0.1203460693359375,  
0.0906066894531250,  0.0454483032226562,  0.0342102050781250,  0.0426788330078125,  
0.0469360351562500,  0.0453414916992188,  0.0535049438476562,  0.0626068115234375,  
0.0606231689453125,  0.0527343750000000,  0.0526733398437500,  0.0616912841796875,  
0.0724792480468750,  0.0739517211914062,  0.0730361938476562,  0.0721817016601562,  
0.0676574707031250,  0.0717391967773438,  0.0729598999023438,  0.0763702392578125,  
0.0830383300781250,  0.0828094482421875,  0.0709381103515625,  0.0580368041992188,  
0.0547637939453125,  0.0555953979492188,  0.0507888793945312,  0.0385437011718750,  
0.0485305786132812,  0.0769348144531250,  0.0680618286132812,  0.0419692993164062
},
{
0.0290985107421875,  0.0607833862304688,  0.0936584472656250,  0.1178054809570312,  
0.0991821289062500,  0.0645523071289062,  0.0385589599609375,  0.0259094238281250,  
0.0239868164062500,  0.0292816162109375,  0.0417861938476562,  0.0558929443359375,  
0.0656967163085938,  0.0484924316406250,  0.0401229858398438,  0.0377273559570312,  
0.0332641601562500,  0.0310745239257812,  0.0398788452148438,  0.0502243041992188,  
0.0480194091796875,  0.0399551391601562,  0.0394439697265625,  0.0445709228515625,  
0.0458984375000000,  0.0426254272460938,  0.0441589355468750,  0.0437316894531250,  
0.0384521484375000,  0.0362091064453125,  0.0405731201171875,  0.0488967895507812,  
0.0602493286132812,  0.0603103637695312,  0.0484466552734375,  0.0399551391601562,  
0.0349273681640625,  0.0354461669921875,  0.0316696166992188,  0.0341415405273438,  
0.0652008056640625,  0.1235427856445312,  0.1305541992187500,  0.0909500122070312
},
{
0.0275726318359375,  0.0648040771484375,  0.1003875732421875,  0.1176452636718750,  
0.1095046997070312,  0.0887908935546875,  0.0760116577148438,  0.0867233276367188,  
0.1068191528320312,  0.1198043823242188,  0.1069030761718750,  0.0897979736328125,  
0.0781478881835938,  0.0542755126953125,  0.0499191284179688,  0.0555191040039062,  
0.0581359863281250,  0.0594329833984375,  0.0736160278320312,  0.0850906372070312,  
0.0838394165039062,  0.0714874267578125,  0.0630645751953125,  0.0585784912109375,  
0.0619049072265625,  0.0663986206054688,  0.0718460083007812,  0.0801544189453125,  
0.0795059204101562,  0.0764007568359375,  0.0701065063476562,  0.0772171020507812,  
0.0900955200195312,  0.0969848632812500,  0.0972824096679688,  0.0940322875976562,  
0.0825119018554688,  0.0729827880859375,  0.0622100830078125,  0.0627288818359375,  
0.0758514404296875,  0.0968704223632812,  0.0807342529296875,  0.0529251098632812
},
{
0.0735473632812500,  0.1288833618164062,  0.1055068969726562,  0.0539703369140625,  
0.0416717529296875,  0.0738372802734375,  0.1173858642578125,  0.1170806884765625,  
0.0773696899414062,  0.0594482421875000,  0.0715637207031250,  0.0971679687500000,  
0.1062698364257812,  0.0777816772460938,  0.0617752075195312,  0.0685043334960938,  
0.0762329101562500,  0.0739517211914062,  0.0784454345703125,  0.0853347778320312,  
0.0847625732421875,  0.0732040405273438,  0.0666885375976562,  0.0642471313476562,  
0.0656204223632812,  0.0686111450195312,  0.0742874145507812,  0.0754852294921875,  
0.0766143798828125,  0.0812911987304688,  0.0870056152343750,  0.0974655151367188,  
0.1131515502929688,  0.1164779663085938,  0.1001739501953125,  0.0862579345703125,  
0.0780639648437500,  0.0715942382812500,  0.0616149902343750,  0.0542373657226562,  
0.0674209594726562,  0.0973510742187500,  0.0889816284179688,  0.0527038574218750
},
{
0.0338058471679688,  0.0697326660156250,  0.0913696289062500,  0.0903778076171875,  
0.0824127197265625,  0.0818328857421875,  0.0892868041992188,  0.0969696044921875,  
0.0904312133789062,  0.0770874023437500,  0.0654144287109375,  0.0737686157226562,  
0.0891952514648438,  0.0809478759765625,  0.0787734985351562,  0.0808181762695312,  
0.0745773315429688,  0.0731582641601562,  0.0869903564453125,  0.1083221435546875,  
0.1193847656250000,  0.1193389892578125,  0.1167221069335938,  0.1082916259765625,  
0.0892105102539062,  0.0664443969726562,  0.0518188476562500,  0.0521926879882812,  
0.0574111938476562,  0.0726089477539062,  0.0924835205078125,  0.1253433227539062,  
0.1541213989257812,  0.1620788574218750,  0.1392440795898438,  0.1046981811523438,  
0.0666885375976562,  0.0472030639648438,  0.0396804809570312,  0.0435638427734375,  
0.0652999877929688,  0.0944519042968750,  0.0825042724609375,  0.0539016723632812
},
{
0.0489578247070312,  0.1052169799804688,  0.1370849609375000,  0.1364974975585938,  
0.1000671386718750,  0.0744094848632812,  0.0716171264648438,  0.0807723999023438,  
0.0771484375000000,  0.0727615356445312,  0.0632629394531250,  0.0738220214843750,  
0.0859451293945312,  0.0806198120117188,  0.0791397094726562,  0.0807266235351562,  
0.0765609741210938,  0.0728607177734375,  0.0812911987304688,  0.0911102294921875,  
0.0856323242187500,  0.0775833129882812,  0.0756301879882812,  0.0819320678710938,  
0.0954895019531250,  0.1043548583984375,  0.1050109863281250,  0.0996398925781250,  
0.0876083374023438,  0.0829391479492188,  0.0853729248046875,  0.0797576904296875,  
0.0839691162109375,  0.0912322998046875,  0.1033020019531250,  0.1349945068359375,  
0.1736755371093750,  0.1913833618164062,  0.1822967529296875,  0.1357498168945312,  
0.0917205810546875,  0.0831069946289062,  0.0682525634765625,  0.0441360473632812
},
{
0.0506820678710938,  0.1029586791992188,  0.1274719238281250,  0.1109771728515625,  
0.0750198364257812,  0.0643844604492188,  0.0959777832031250,  0.1454162597656250,  
0.1613998413085938,  0.1315765380859375,  0.0859146118164062,  0.0684738159179688,  
0.0800170898437500,  0.0820999145507812,  0.0900344848632812,  0.0967559814453125,  
0.0964584350585938,  0.0896224975585938,  0.0919723510742188,  0.0959930419921875,  
0.0943374633789062,  0.0853195190429688,  0.0825958251953125,  0.0854263305664062,  
0.0833282470703125,  0.0784912109375000,  0.0750045776367188,  0.0779495239257812,  
0.0808486938476562,  0.0849456787109375,  0.0888900756835938,  0.1039123535156250,  
0.1186065673828125,  0.1202316284179688,  0.1100082397460938,  0.0997390747070312,  
0.0901947021484375,  0.0846328735351562,  0.0777130126953125,  0.0764312744140625,  
0.0911407470703125,  0.1169128417968750,  0.0997619628906250,  0.0615158081054688
},
{
0.0711059570312500,  0.1019821166992188,  0.0554809570312500,  0.0267639160156250,  
0.0365219116210938,  0.0506439208984375,  0.0484237670898438,  0.0328750610351562,  
0.0279922485351562,  0.0328521728515625,  0.0393524169921875,  0.0435028076171875,  
0.0500793457031250,  0.0362396240234375,  0.0316696166992188,  0.0350036621093750,  
0.0364151000976562,  0.0372695922851562,  0.0470046997070312,  0.0521087646484375,  
0.0462112426757812,  0.0365753173828125,  0.0343093872070312,  0.0391769409179688,  
0.0436325073242188,  0.0449905395507812,  0.0402069091796875,  0.0351715087890625,  
0.0377883911132812,  0.0479736328125000,  0.0528869628906250,  0.0609130859375000,  
0.0644378662109375,  0.0597229003906250,  0.0463409423828125,  0.0408706665039062,  
0.0371322631835938,  0.0325622558593750,  0.0207748413085938,  0.0257263183593750,  
0.0544433593750000,  0.0967025756835938,  0.0861663818359375,  0.0387420654296875
},
{
0.0707321166992188,  0.0953674316406250,  0.0417709350585938,  0.0389480590820312,  
0.1041183471679688,  0.1041793823242188,  0.0552978515625000,  0.0426864624023438,  
0.0397186279296875,  0.0435104370117188,  0.0652542114257812,  0.0888290405273438,  
0.0812606811523438,  0.0557022094726562,  0.0505828857421875,  0.0627212524414062,  
0.0600433349609375,  0.0556488037109375,  0.0663223266601562,  0.0753631591796875,  
0.0743103027343750,  0.0624237060546875,  0.0620956420898438,  0.0604324340820312,  
0.0672302246093750,  0.0735778808593750,  0.0774536132812500,  0.0783920288085938,  
0.0807952880859375,  0.0803222656250000,  0.0759277343750000,  0.0693588256835938,  
0.0753784179687500,  0.0792999267578125,  0.0656585693359375,  0.0577774047851562,  
0.0502014160156250,  0.0425262451171875,  0.0284194946289062,  0.0191345214843750,  
0.0415954589843750,  0.1064910888671875,  0.1641769409179688,  0.1730728149414062
},
{
0.0561981201171875,  0.1138076782226562,  0.1392059326171875,  0.1166610717773438,  
0.0715637207031250,  0.0510101318359375,  0.0580520629882812,  0.0685958862304688,  
0.0643463134765625,  0.0488357543945312,  0.0376586914062500,  0.0534591674804688,  
0.0892791748046875,  0.1057128906250000,  0.1046981811523438,  0.0942230224609375,  
0.0783538818359375,  0.0660781860351562,  0.0695037841796875,  0.0800323486328125,  
0.0775146484375000,  0.0666885375976562,  0.0645599365234375,  0.0665435791015625,  
0.0644149780273438,  0.0634765625000000,  0.0644989013671875,  0.0685195922851562,  
0.0699081420898438,  0.0776138305664062,  0.0837173461914062,  0.0893783569335938,  
0.0971908569335938,  0.0955657958984375,  0.0837783813476562,  0.0701293945312500,  
0.0570449829101562,  0.0504837036132812,  0.0423583984375000,  0.0400085449218750,  
0.0601730346679688,  0.1101455688476562,  0.1153869628906250,  0.0832443237304688
},
{
0.0278244018554688,  0.0633010864257812,  0.0994033813476562,  0.1174392700195312,  
0.1054077148437500,  0.0795593261718750,  0.0577392578125000,  0.0480499267578125,  
0.0415496826171875,  0.0427093505859375,  0.0533218383789062,  0.0833663940429688,  
0.1077728271484375,  0.1040191650390625,  0.1009140014648438,  0.1053924560546875,  
0.1053543090820312,  0.1032104492187500,  0.0986404418945312,  0.0896759033203125,  
0.0752716064453125,  0.0620880126953125,  0.0633544921875000,  0.0730590820312500,  
0.0851135253906250,  0.0916213989257812,  0.0875549316406250,  0.0825729370117188,  
0.0796051025390625,  0.0790023803710938,  0.0871582031250000,  0.1053695678710938,  
0.1223831176757812,  0.1273269653320312,  0.1166763305664062,  0.0937805175781250,  
0.0652389526367188,  0.0453414916992188,  0.0315170288085938,  0.0318145751953125,  
0.0568084716796875,  0.0992660522460938,  0.0926971435546875,  0.0627517700195312
},
  },
    };
