/*******************************************************************************
This software module was originally developed by

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips

and edited by

-

in the course of development of ISO/IEC 23003 for reference purposes and its
performance may not have been optimized. This software module is an
implementation of one or more tools as specified by ISO/IEC 23003. ISO/IEC gives
You a royalty-free, worldwide, non-exclusive, copyright license to copy,
distribute, and make derivative works of this software module or modifications
thereof for use in implementations of ISO/IEC 23003 in products that satisfy
conformance criteria (if any). Those intending to use this software module in
products are advised that its use may infringe existing patents. ISO/IEC have no
liability for use of this software module or modifications thereof. Copyright is
not released for products that do not conform to audiovisual and image-coding
related ITU Recommendations and/or ISO/IEC International Standards.

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips retain full right to
modify and use the code for its (their) own purpose, assign or donate the code
to a third party and to inhibit third parties from using the code for products
that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
International Standards. This copyright notice must be included in all copies or
derivative works.

Copyright (c) ISO/IEC 2008.
*******************************************************************************/
/*******************************************************************************
This software module was further modified in light of the JAME project that 
was initiated by Yonsei University and LG Electronics.

The JAME project aims at making a better MPEG Reference Software especially
for the encoder in direction to simplification, quality improvement and 
efficient implementation being still compliant with the ISO/IEC specification. 
Those intending to participate in this project can use this software module 
under consideration of above mentioned ISO/IEC copyright notice. 

Any voluntary contributions to this software module in the course of this 
project can be recognized by proudly listing up their authors here:

- Henney Oh, LG Electronics (henney.oh@lge.com)
- Sungyong Yoon, LG Electronics (sungyong.yoon@lge.com)

Copyright (c) JAME 2010.
*******************************************************************************/
                                                                  
#include "sac_huff_tab.h"                                       


const HUFF_CPC_TABLE huffCPCTab =
{
  {
    { 0xfe, 0x76, 0x3a, 0x3e, 0x7e, 0x1c, 0x3e, 0x02, 0x03, 0x06, 0x0e, 0x00, 0x02, 0x04, 0x06, 0x05, 0x1e, 0x1e, 0x3f, 0x77, 0x3fe, 0x3fc, 0x7fe, 0xffe, 0xfff, 0x3fd },
    {    8,    8,    7,    7,    7,    6,    6,    4,    4,    4,    4,    3,    3,    3,    3,    3,    5,    6,    7,    8,   10,   10,   11,   12,   12,   10 }
  },    
  {
    {
      { 0x0002, 0x0003, 0x0000, 0x0002, 0x000e, 0x000c, 0x001e, 0x001a, 0x003e, 0x0036, 0x007e, 0x006e, 0x00fe, 0x00de, 0x01fe, 0x01be, 0x03fe, 0x037e, 0x07fe, 0x06fe, 0x0ffe, 0x0dfe, 0x1ffe, 0x3ffe, 0x3fff, 0x0dff },
      {      2,      2,      2,      3,      5,      5,      6,      6,      7,      7,      8,      8,      9,      9,     10,     10,     11,     11,     12,     12,     13,     13,     14,     15,     15,     13 }
    },
    {
      { 0x0000, 0x0002, 0x0006, 0x000e, 0x001e, 0x003e, 0x007e, 0x01fe, 0x01fc, 0x03fe, 0x03fa, 0x07f6, 0x0ffe, 0x07f7, 0x0ffc, 0x1ffe, 0x1ffa, 0x3ffe, 0x3ff6, 0x7ffe, 0xfffe, 0xffff, 0xffde, 0x1ffbe, 0x1ffbf, 0x7fee },
      {      1,      2,      3,      4,      5,      6,      7,      9,      9,     10,     10,     11,     12,     11,     12,     13,     13,     14,     14,     15,     16,     16,     16,     17,     17,     15 }
    }
  },
  { /* escape */
    { 
      { 0x0, 0x0, 0x0, 0x4fff },
      {   0,   0,   0,      0 }
    },
    {
      { 0x0, 0x0, 0x0, 0x0 },
      {   0,   0,   0,   0 }
    },
    {
      { 0x0, 0x0, 0x0, 0x0 },
      {   0,   0,   0,   0 }
    },
    {
      { 0x0, 0x0, 0x0, 0x0 },
      {   0,   0,   0,   0 }
    }
  },
  {
    { /* lav3 */
      {
        { 0x0002, 0x0002, 0x0006, 0x0076, 0x0002, 0x0006, 0x001e, 0x01de, 0x00ee, 0x003a, 0x001c, 0x0007, 0x01df, 0x001f, 0x0000, 0x0003, },
        {      2,      3,      5,      8,      4,      4,      6,     10,      9,      7,      6,      5,     10,      6,      3,      2, }
      },
      {
        { 0x0002, 0x000e, 0x01fe, 0x03fe, 0x0000, 0x0004, 0x00fe, 0x001e, 0x000a, 0x0016, 0x003e, 0x0006, 0x007e, 0x03ff, 0x0017, 0x0003, },
        {      2,      5,     10,     11,      2,      4,      9,      6,      5,      6,      7,      4,      8,     11,      6,      2, }
      },
      {
        { 0x0000, 0x000c, 0x00d2, 0x034e, 0x000e, 0x001e, 0x0068, 0x006a, 0x006e, 0x006f, 0x006b, 0x001f, 0x01a6, 0x034f, 0x0036, 0x0002, },
        {      1,      4,      8,     10,      4,      5,      7,      7,      7,      7,      7,      5,      9,     10,      6,      2, }
      },
      {
        { 0x0000, 0x000e, 0x00fc, 0x07fe, 0x000c, 0x001e, 0x00fe, 0x01fe, 0x00fd, 0x007c, 0x007d, 0x001a, 0x07ff, 0x03fe, 0x001b, 0x0002, },
        {      1,      4,      8,     11,      4,      5,      8,      9,      8,      7,      7,      5,     11,     10,      5,      2, }
      }
    },
    { /* lav6 */
      {
        { 0x0006, 0x0002, 0x000e, 0x005e, 0x00ba, 0x00fe, 0x02ee, 0x0006, 0x000a, 0x0016, 0x0024, 0x00fa, 0x017e, 0x5dfe, 0x005c, 0x0026, 0x001e, 0x00fe, 0x01f2, 0x0bbe, 0x0fbe, 0x00ff, 0x007e, 0x01fe, 0x017f, 0x03ee, 0x03fe, 0x03ff, 0x0fbf, 0x07de, 0x05de, 0x01f3, 0x00f8, 0x004a, 0x004b, 0x2efe, 0x177e, 0x01f6, 0x003e, 0x0027, 0x0010, 0x001e, 0x5dff, 0x0176, 0x00be, 0x007e, 0x0011, 0x000e, 0x0000, },
        {      3,      3,      5,      7,      8,      9,     10,      4,      4,      5,      6,      8,      9,     15,      7,      6,      6,      8,      9,     12,     12,      9,      8,      9,      9,     10,     10,     10,     12,     11,     11,      9,      8,      7,      7,     14,     13,      9,      7,      6,      5,      5,     15,      9,      8,      7,      5,      4,      2, }
      },
      {
        { 0x0006, 0x001e, 0x00be, 0x077e, 0x17fe, 0xbffe, 0xbfff, 0x0004, 0x000a, 0x005e, 0x00d2, 0x0bfe, 0x2ffe, 0x006a, 0x001f, 0x000e, 0x0036, 0x03be, 0x07fe, 0x01de, 0x003e, 0x002c, 0x002d, 0x007e, 0x01fe, 0x00d3, 0x00ee, 0x002e, 0x003c, 0x003d, 0x00fe, 0x03fe, 0x017e, 0x0076, 0x001c, 0x006b, 0x0068, 0x0ffe, 0x05fe, 0x006e, 0x003a, 0x0002, 0x02fe, 0x5ffe, 0x0fff, 0x077f, 0x006f, 0x000c, 0x0000, },
        {      3,      5,      8,     11,     13,     16,     16,      3,      4,      7,      9,     12,     14,      8,      5,      5,      7,     10,     12,      9,      7,      6,      6,      8,     10,      9,      8,      6,      7,      7,      9,     11,      9,      7,      5,      8,      8,     13,     11,      8,      6,      3,     10,     15,     13,     11,      8,      5,      2, }
      },
      {
        { 0x0000, 0x000c, 0x003a, 0x03ae, 0x0efe, 0x77fe, 0xeffe, 0x0002, 0x0006, 0x007e, 0x01de, 0x075e, 0x3bfe, 0x075f, 0x003c, 0x003e, 0x0074, 0x01d4, 0x03be, 0x01fe, 0x00fe, 0x00ee, 0x003e, 0x007e, 0x00e6, 0x00e7, 0x0072, 0x0038, 0x00ee, 0x01d6, 0x03be, 0x01ff, 0x0076, 0x0076, 0x001e, 0x077e, 0x01de, 0x077e, 0x03aa, 0x00fe, 0x003d, 0x000d, 0x077f, 0xefff, 0x1dfe, 0x03ab, 0x00ff, 0x001c, 0x0002, },
        {      2,      4,      7,     10,     12,     15,     16,      3,      4,      7,      9,     11,     14,     11,      6,      6,      7,      9,     11,     10,      9,      8,      7,      8,      9,      9,      8,      7,      9,      9,     10,     10,      8,      7,      6,     11,     10,     12,     10,      8,      6,      4,     12,     16,     13,     10,      8,      5,      2, }
      },
      {
        { 0x0000, 0x000e, 0x007a, 0x01ee, 0x07fe, 0x1ffe, 0x3ffe, 0x000c, 0x000d, 0x001e, 0x00f6, 0x03fe, 0x03ba, 0x0f7e, 0x001c, 0x003e, 0x0016, 0x0074, 0x01de, 0x017a, 0x01df, 0x01fe, 0x002e, 0x0076, 0x00fe, 0x00be, 0x01fc, 0x0075, 0x01dc, 0x00bc, 0x03de, 0x00bf, 0x007e, 0x0078, 0x007e, 0x0f7f, 0x03bb, 0x07be, 0x00ff, 0x003e, 0x000a, 0x0006, 0x3fff, 0x0ffe, 0x017b, 0x01fd, 0x0079, 0x0004, 0x0002, },
        {      2,      4,      7,      9,     11,     13,     14,      4,      4,      6,      8,     10,     11,     12,      6,      6,      6,      8,     10,     10,     10,      9,      7,      8,      9,      9,      9,      8,     10,      9,     10,      9,      8,      7,      7,     12,     11,     11,      9,      7,      5,      4,     14,     12,     10,      9,      7,      4,      2, }
      }
    },
    { /* lav9 */
      {
        { 0x0000, 0x000a, 0x000a, 0x0010, 0x0026, 0x003e, 0x009e, 0x0064, 0x00ce, 0x019e, 0x0002, 0x0008, 0x0012, 0x0026, 0x004e, 0x00e8, 0x007e, 0x00fe, 0x027e, 0x6ffe, 0x0011, 0x003e, 0x001e, 0x007e, 0x001a, 0x00ee, 0x01de, 0x03fe, 0x13ba, 0x1bfe, 0x005c, 0x002c, 0x002d, 0x0018, 0x00e6, 0x01df, 0x007a, 0x0dfe, 0x033e, 0x033f, 0x03ae, 0x013e, 0x00ff, 0x003c, 0x01d6, 0x03ff, 0x02fe, 0x037e, 0x04fe, 0x02ff, 0x0276, 0x013a, 0x01be, 0x01bc, 0x017e, 0x009c, 0x007e, 0x009f, 0x0065, 0x007f, 0x09de, 0x09fe, 0x09ff, 0x06fe, 0x007b, 0x01ce, 0x00ea, 0x005e, 0x006e, 0x007c, 0x13bb, 0x09dc, 0x09df, 0x0066, 0x01fe, 0x00e9, 0x001b, 0x0072, 0x000e, 0x0012, 0xdffe, 0x37fe, 0x03af, 0x01cf, 0x009e, 0x00fe, 0x0076, 0x0038, 0x000e, 0x001e, 0xdfff, 0x01bd, 0x00be, 0x005d, 0x007d, 0x0036, 0x001a, 0x000c, 0x000b, 0x0006, },
        {      3,      4,      5,      6,      7,      8,      9,      9,     10,     11,      4,      4,      5,      6,      7,      8,      8,      9,     10,     16,      6,      6,      6,      7,      7,      8,      9,     10,     14,     14,      8,      7,      7,      7,      8,      9,      9,     13,     12,     12,     10,      9,      9,      8,      9,     10,     11,     11,     11,     11,     11,     10,     10,     10,     10,      9,      9,      9,      9,      9,     13,     12,     12,     12,      9,      9,      8,      8,      8,      8,     14,     13,     13,      9,      9,      8,      7,      7,      6,      6,     17,     15,     10,      9,      8,      8,      7,      6,      5,      5,     17,     10,      9,      8,      8,      7,      6,      5,      4,      3, }
      },
      {
        { 0x0004, 0x0014, 0x00f6, 0x03d2, 0x0ffe, 0x0f5e, 0x66fe, 0xcdfe, 0x3dffe, 0x7bffe, 0x0002, 0x0006, 0x006e, 0x017e, 0x07be, 0x07ae, 0x3dfe, 0x3d6e, 0x1effe, 0x03de, 0x0018, 0x0015, 0x005a, 0x0178, 0x066e, 0x0b7e, 0x337e, 0x3d6f, 0x03d6, 0x01ea, 0x002e, 0x002c, 0x003a, 0x00f6, 0x01e6, 0x07ac, 0x2dfe, 0x01ea, 0x017a, 0x00cc, 0x0064, 0x006f, 0x007e, 0x00f7, 0x05e6, 0x19be, 0x05e7, 0x00f2, 0x00b6, 0x003b, 0x00ce, 0x00fe, 0x0078, 0x02fe, 0x03d2, 0x0cde, 0x01e8, 0x01e8, 0x00ca, 0x007e, 0x01fe, 0x00cb, 0x016e, 0x07fe, 0x0f5a, 0x0fff, 0x03d7, 0x01ee, 0x003e, 0x003c, 0x017b, 0x019a, 0x02de, 0x7bfe, 0x0f5f, 0x05be, 0x02f2, 0x007f, 0x001c, 0x001a, 0x02ff, 0x03fe, 0xcdff, 0x1eb6, 0x1efe, 0x0f7e, 0x0336, 0x00be, 0x0036, 0x000e, 0x01e7, 0x7bfff, 0xf7fe, 0x2dff, 0x16fe, 0x03d3, 0x03d3, 0x00cf, 0x003e, 0x0000, },
        {      3,      5,      8,     10,     12,     13,     15,     16,     18,     19,      3,      4,      7,      9,     11,     12,     14,     15,     17,     10,      5,      5,      7,      9,     11,     12,     14,     15,     10,      9,      6,      6,      7,      9,     10,     12,     14,     10,      9,      8,      7,      7,      8,      9,     11,     13,     11,      9,      8,      7,      8,      8,      8,     10,     11,     12,     10,      9,      8,      7,      9,      8,      9,     11,     13,     12,     10,      9,      7,      6,      9,      9,     10,     15,     13,     11,     10,      8,      6,      5,     10,     10,     16,     14,     13,     12,     10,      8,      6,      4,     10,     19,     16,     14,     13,     11,     10,      8,      6,      2, }
      },
      {
        { 0x0006, 0x0004, 0x003a, 0x00be, 0x03b6, 0x0ece, 0x09fe, 0x13fe, 0x1d9fe, 0x1d9ff, 0x0000, 0x000e, 0x001c, 0x003e, 0x01d8, 0x0772, 0x0f7e, 0x0efe, 0x767e, 0x027e, 0x003e, 0x000a, 0x0008, 0x003a, 0x016e, 0x03b2, 0x0ffe, 0x0eff, 0x077e, 0x01de, 0x001c, 0x003c, 0x007e, 0x00fa, 0x007e, 0x03b8, 0x077e, 0x02de, 0x009e, 0x01ee, 0x00f8, 0x005a, 0x00f6, 0x002c, 0x004c, 0x02df, 0x03fe, 0x01da, 0x005c, 0x004e, 0x01de, 0x005e, 0x00bc, 0x01fe, 0x00ee, 0x00be, 0x005d, 0x00f9, 0x00bf, 0x002d, 0x03be, 0x004d, 0x00bf, 0x03ba, 0x077f, 0x016c, 0x00fe, 0x00fb, 0x007a, 0x002c, 0x013e, 0x03bb, 0x07fe, 0x1d9e, 0x0766, 0x016d, 0x0076, 0x0012, 0x000a, 0x003f, 0x03be, 0x07be, 0x13ff, 0x04fe, 0x0773, 0x03b7, 0x007f, 0x001e, 0x0006, 0x0006, 0x1ffe, 0xecfe, 0x3b3e, 0x1fff, 0x0f7f, 0x03de, 0x00bd, 0x002e, 0x001e, 0x0002, },
        {      3,      4,      7,      9,     11,     13,     14,     15,     18,     18,      3,      4,      6,      8,     10,     12,     13,     14,     16,     12,      6,      5,      6,      8,     10,     11,     13,     14,     12,     11,      7,      7,      8,      9,      9,     11,     13,     11,     10,     10,      9,      8,      9,      8,      9,     11,     11,     10,      9,      9,     10,      9,      9,     10,     10,     10,      9,      9,      9,      8,     11,      9,     10,     11,     12,     10,      9,      9,      8,      7,     11,     11,     12,     14,     12,     10,      9,      7,      6,      6,     12,     12,     15,     13,     12,     11,      9,      7,      5,      4,     14,     17,     15,     14,     13,     11,      9,      7,      5,      2, }
      },
      {
        { 0x0004, 0x000c, 0x001e, 0x007e, 0x03ce, 0x057e, 0x1ffe, 0x1eb6, 0x3dfe, 0x5ede, 0x000d, 0x000e, 0x003e, 0x002e, 0x01e2, 0x015e, 0x07ae, 0x0f5a, 0x17b6, 0x0fbe, 0x002c, 0x000e, 0x002a, 0x00fe, 0x017a, 0x03de, 0x079e, 0x07fe, 0x1efe, 0x1fff, 0x00be, 0x005c, 0x002f, 0x00f2, 0x0054, 0x03c6, 0x03fe, 0x0ff6, 0x03ee, 0x057f, 0x03fe, 0x01ee, 0x01ec, 0x007c, 0x01e6, 0x01f6, 0x015f, 0x01fe, 0x03c7, 0x07be, 0x05ee, 0x02f2, 0x00fa, 0x03da, 0x02f3, 0x00aa, 0x015e, 0x01ea, 0x00ae, 0x00fe, 0x07de, 0x07fe, 0x07af, 0x05ef, 0x07ac, 0x00ab, 0x00bf, 0x00ac, 0x00f0, 0x00f4, 0x1eb7, 0x0bda, 0x07ff, 0x0f7e, 0x07fa, 0x0178, 0x0056, 0x005d, 0x0014, 0x002d, 0x2f6e, 0x0fbf, 0x1ffc, 0x0ff7, 0x02be, 0x03db, 0x00ad, 0x007e, 0x0014, 0x0006, 0x5edf, 0x3dff, 0x1ffd, 0x05ec, 0x079f, 0x03fc, 0x00ae, 0x0016, 0x0004, 0x0000, },
        {      3,      4,      6,      8,     10,     11,     13,     13,     14,     15,      4,      4,      6,      7,      9,     10,     11,     12,     13,     13,      6,      5,      6,      8,      9,     10,     11,     12,     13,     13,      8,      7,      7,      8,      8,     10,     11,     12,     11,     11,     10,      9,      9,      8,      9,     10,     10,     10,     10,     11,     11,     10,      9,     10,     10,      9,      9,      9,      9,      9,     12,     11,     11,     11,     11,      9,      8,      8,      8,      8,     13,     12,     12,     12,     11,      9,      8,      7,      6,      6,     14,     13,     13,     12,     10,     10,      8,      7,      5,      4,     15,     14,     13,     11,     11,     10,      8,      6,      4,      2, }
      }
    },
    { /* lav12 */
      {
        { 0x000e, 0x0004, 0x0004, 0x0002, 0x000a, 0x0032, 0x00be, 0x0362, 0x0042, 0x03de, 0x007e, 0x062e, 0x0d8e, 0x001a, 0x0006, 0x0016, 0x002e, 0x0066, 0x00fe, 0x0028, 0x00f6, 0x033e, 0x007e, 0x036e, 0x00ce, 0x27fe, 0x0003, 0x0000, 0x0030, 0x007e, 0x0016, 0x005e, 0x018e, 0x0024, 0x019e, 0x037e, 0x00de, 0x7ffe, 0x13fe, 0x007c, 0x003c, 0x002e, 0x001a, 0x007e, 0x01f6, 0x0062, 0x01bc, 0x0022, 0x00f2, 0x2ffe, 0x2fff, 0x04fc, 0x006e, 0x0030, 0x0029, 0x0016, 0x001e, 0x007a, 0x01b6, 0x0026, 0x00fa, 0x07be, 0x1ffe, 0x363e, 0x0f7e, 0x004e, 0x0025, 0x03fe, 0x0023, 0x0020, 0x002a, 0x0056, 0x00f6, 0x05fe, 0x07fe, 0x07fc, 0x18be, 0x013e, 0x0c5e, 0x06c6, 0x07de, 0x06fe, 0x01fe, 0x0316, 0x036f, 0x06ff, 0x07df, 0x0043, 0x03df, 0x009e, 0x01ee, 0x0bfe, 0x07fd, 0x03de, 0x02fe, 0x015e, 0x015f, 0x01f6, 0x007f, 0x007c, 0x00fb, 0x01ee, 0x01f7, 0x017e, 0x17fe, 0x363f, 0x1b1e, 0x0ffe, 0x18bf, 0x00df, 0x003e, 0x01bd, 0x018f, 0x0188, 0x00fe, 0x00fa, 0x0189, 0x7ffc, 0x04fd, 0x04fe, 0x0f7f, 0x00f3, 0x002e, 0x01b2, 0x0078, 0x01be, 0x00be, 0x00ce, 0x00da, 0x00fa, 0xfffa, 0x7fff, 0x09fe, 0x00ae, 0x03ee, 0x01b0, 0x002f, 0x01b3, 0x007a, 0x0017, 0x006e, 0x0006, 0x000e, 0x4ffe, 0xfffb, 0x00cf, 0x033f, 0x018a, 0x03ff, 0x017e, 0x0036, 0x000e, 0x007c, 0x0032, 0x000e, 0x001e, 0x4fff, 0x007f, 0x02fe, 0x0066, 0x02ff, 0x0063, 0x01fe, 0x00c6, 0x005e, 0x0016, 0x000a, 0x000a, 0x0004, },
        {      4,      4,      5,      6,      7,      8,      9,     10,     10,     11,     10,     11,     12,      5,      4,      5,      6,      7,      8,      8,      9,     10,      9,     10,     10,     17,      6,      5,      6,      7,      7,      8,      9,      9,      9,     10,     10,     16,     16,      8,      7,      7,      7,      8,      9,      9,      9,      9,     10,     15,     15,     14,      9,      8,      8,      8,      8,      9,      9,      9,     10,     13,     14,     14,     14,     10,      9,     10,      9,      9,      8,      9,     10,     12,     12,     12,     13,     12,     12,     11,     11,     11,     10,     10,     10,     11,     11,     10,     11,     11,     11,     13,     12,     12,     11,     11,     11,     10,      9,      9,     10,     10,     10,     10,     14,     14,     13,     13,     13,     10,      9,      9,      9,      9,      9,      9,      9,     16,     14,     14,     14,     10,      9,      9,      9,      9,      8,      8,      8,      8,     17,     16,     15,     10,     10,      9,      9,      9,      8,      7,      7,      6,      6,     18,     17,     10,     10,      9,     10,      9,      8,      7,      7,      6,      5,      5,     18,     10,     10,      9,     10,      9,      9,      8,      7,      6,      5,      4,      3, }
      },
      {
        { 0x0002, 0x0014, 0x00fe, 0x03fe, 0x057a, 0x077c, 0x3eee, 0x5dfe, 0x57be, 0x177fe, 0x7defe, 0xfbdfe, 0xfbdff, 0x0000, 0x0006, 0x007c, 0x01f6, 0x02b2, 0x0fbe, 0x15ee, 0x2ebe, 0xfbde, 0xdbfe, 0x15ef6, 0x3ef7c, 0x03b0, 0x001a, 0x0016, 0x006c, 0x01f4, 0x01de, 0x0fba, 0x1b7e, 0x2eba, 0x7dee, 0x77de, 0x15ef7, 0x01ce, 0x0174, 0x0038, 0x0039, 0x0038, 0x01b6, 0x00ee, 0x0dbe, 0x175c, 0x07ba, 0x6dfc, 0xaf7a, 0x0766, 0x0076, 0x003e, 0x000a, 0x000b, 0x00da, 0x0158, 0x00ef, 0x0bbc, 0x0bbd, 0x07bb, 0x5d76, 0x05d6, 0x02f6, 0x01da, 0x01be, 0x003a, 0x003e, 0x003f, 0x03b2, 0x05fe, 0x0566, 0x03dc, 0x3ef6, 0x0dba, 0x00f6, 0x015a, 0x00fe, 0x007e, 0x00bc, 0x00de, 0x017e, 0x02bc, 0x01cf, 0x0fbc, 0x1f76, 0x0af6, 0x0567, 0x02fe, 0x03b6, 0x01f5, 0x00ee, 0x01fa, 0x003c, 0x03fc, 0x0074, 0x0767, 0x0bbe, 0x0efa, 0x0dbb, 0x07dc, 0x00ea, 0x00ee, 0x00ae, 0x005c, 0x015b, 0x0176, 0x017a, 0x02be, 0x0396, 0x1df6, 0x177e, 0x0fbf, 0x0397, 0x02bf, 0x01bf, 0x001c, 0x001e, 0x03ff, 0x01fb, 0x03b1, 0x06de, 0x3bee, 0x2ebf, 0x175e, 0x03de, 0x05d4, 0x03b7, 0x0076, 0x006e, 0x0004, 0x00ff, 0x00e6, 0x00eb, 0xbbfe, 0x57bc, 0x2efe, 0x3ef4, 0x077e, 0x05d5, 0x007a, 0x00be, 0x002a, 0x001e, 0x02f7, 0x02ee, 0x3ef7e, 0xdbff, 0x57bf, 0x6dfd, 0x3ef5, 0x03df, 0x05ff, 0x03fd, 0x00ef, 0x003a, 0x000c, 0x01ca, 0x3ef7d, 0x177ff, 0x77df, 0x5d77, 0x6dfe, 0x3eef, 0x077f, 0x06dc, 0x00e4, 0x00fc, 0x0006, 0x0004, },
        {      3,      5,      8,     10,     11,     12,     14,     15,     15,     17,     19,     20,     20,      3,      4,      7,      9,     10,     12,     13,     14,     16,     16,     17,     18,     10,      5,      5,      7,      9,     10,     12,     13,     14,     15,     16,     17,     10,      9,      6,      6,      7,      9,     10,     12,     13,     13,     15,     16,     11,      9,      8,      6,      6,      8,      9,     10,     12,     12,     13,     15,     11,     10,      9,      9,      7,      7,      8,     10,     11,     11,     12,     14,     12,     10,      9,      9,      8,      8,      8,      9,     10,     10,     12,     13,     12,     11,     10,     10,      9,      8,      9,      8,     10,      9,     11,     12,     13,     12,     11,     10,      9,      8,      7,      9,      9,      9,     10,     11,     14,     13,     12,     11,     10,      9,      7,      6,     10,      9,     10,     11,     15,     14,     13,     12,     11,     10,      8,      7,      5,      9,      9,     10,     16,     15,     14,     14,     12,     11,      9,      8,      6,      5,     10,     10,     18,     16,     15,     15,     14,     12,     11,     10,      8,      6,      4,     10,     18,     17,     16,     15,     15,     14,     12,     11,      9,      8,      5,      3, }
      },
      {
        { 0x0006, 0x0008, 0x0078, 0x017a, 0x05fe, 0x06be, 0x0d7e, 0x3d5e, 0xa3fe, 0x17f7e, 0x17f4e, 0xf57e, 0x1eafe, 0x000e, 0x000a, 0x002e, 0x00bc, 0x03d6, 0x037a, 0x17f6, 0x1ffe, 0xbfbc, 0x28fe, 0xbfae, 0x3d5fe, 0x0ffe, 0x003e, 0x000e, 0x0016, 0x00b2, 0x03de, 0x037e, 0x0fce, 0x2fea, 0x0d7f, 0x5fd2, 0x17f4f, 0x056e, 0x0bea, 0x003c, 0x0079, 0x002a, 0x006c, 0x00a0, 0x035a, 0x051e, 0x056f, 0x1eae, 0xbfa6, 0x07be, 0x07fa, 0x05be, 0x01ee, 0x00b6, 0x0052, 0x00fe, 0x02f6, 0x03d6, 0x05bf, 0x06fa, 0x1fff, 0x07bf, 0x037c, 0x05ff, 0x0286, 0x03d2, 0x0166, 0x03d7, 0x01ee, 0x0144, 0x00ae, 0x07a8, 0x07ee, 0x035e, 0x03f6, 0x015e, 0x02be, 0x05f4, 0x014c, 0x02f7, 0x015a, 0x03fc, 0x03df, 0x01e8, 0x03fe, 0x05f6, 0x01ae, 0x02ce, 0x037b, 0x0146, 0x01f8, 0x03d7, 0x07a9, 0x03de, 0x01bc, 0x05f7, 0x03f2, 0x02bf, 0x01e9, 0x00ac, 0x05fc, 0x01ac, 0x03d3, 0x00da, 0x07aa, 0x037f, 0x0142, 0x03d4, 0x028e, 0x0d6e, 0x0b7a, 0x01fa, 0x0145, 0x02cf, 0x00db, 0x01e8, 0x006e, 0x1eae, 0x05bc, 0x02b6, 0x07fb, 0x1ade, 0x0f56, 0x0287, 0x0beb, 0x014d, 0x00f6, 0x006a, 0x00f6, 0x003e, 0x07ef, 0x0f56, 0x06b6, 0xbfbe, 0x2fe8, 0x0fcf, 0x0df6, 0x07fe, 0x014e, 0x016e, 0x0034, 0x0017, 0x003f, 0x0df7, 0x1eaf, 0xa3ff, 0xbfaf, 0x147e, 0x5fd6, 0x0a3e, 0x07e6, 0x014f, 0x017c, 0x0058, 0x000c, 0x0009, 0x1adf, 0x3d5ff, 0x51fe, 0x7abe, 0x17f7f, 0xbfbd, 0x2fee, 0x0b7b, 0x07aa, 0x017e, 0x005a, 0x0004, 0x0000, },
        {      3,      4,      7,      9,     11,     12,     13,     15,     17,     17,     17,     17,     18,      4,      4,      6,      8,     10,     11,     13,     14,     16,     15,     16,     19,     13,      6,      5,      6,      8,     10,     11,     13,     14,     13,     15,     17,     12,     12,      7,      7,      7,      8,      9,     11,     12,     12,     14,     16,     12,     12,     11,      9,      8,      8,      9,     10,     11,     11,     12,     14,     12,     11,     11,     11,     10,      9,     10,     10,     10,      9,     11,     12,     11,     11,     10,     11,     11,     10,     10,     10,     11,     10,     10,     11,     11,     10,     10,     11,     10,     10,     11,     11,     11,     10,     11,     11,     11,     10,      9,     11,     10,     10,      9,     12,     11,     10,     11,     11,     13,     12,     10,     10,     10,      9,      9,      8,     13,     11,     11,     12,     14,     13,     11,     12,     10,      9,      8,      8,      7,     12,     12,     12,     16,     14,     13,     13,     12,     10,      9,      7,      6,      6,     13,     13,     17,     16,     14,     15,     13,     12,     10,      9,      7,      5,      4,     14,     19,     16,     16,     17,     16,     14,     12,     11,      9,      7,      4,      2, }
      },
      {
        { 0x0002, 0x0008, 0x007e, 0x009a, 0x03be, 0x06fe, 0x09e6, 0x17be, 0x2ffa, 0x4f7e, 0x387e, 0x4f7f, 0x7ffe, 0x000a, 0x000c, 0x003a, 0x004e, 0x01d8, 0x037e, 0x05be, 0x09ee, 0x17bf, 0x1fde, 0x13de, 0x27be, 0x77fe, 0x002c, 0x000e, 0x0036, 0x004a, 0x01d9, 0x02fe, 0x05bf, 0x0b7a, 0x0fae, 0x1f4e, 0x3bfe, 0x3bfc, 0x387f, 0x00e0, 0x006e, 0x005a, 0x003e, 0x01de, 0x02f6, 0x04ce, 0x073e, 0x0ede, 0x1f4f, 0x133e, 0x17fe, 0x1db8, 0x012e, 0x007e, 0x01fe, 0x01fc, 0x01f6, 0x038e, 0x039e, 0x05fe, 0x0e1e, 0x09e4, 0x0b7b, 0x0e76, 0x133f, 0x07d2, 0x03ea, 0x03b4, 0x03b5, 0x03b6, 0x0098, 0x038f, 0x04f6, 0x04ca, 0x05ee, 0x06ff, 0x099e, 0x07fe, 0x0efe, 0x073f, 0x070e, 0x0738, 0x00fe, 0x03e8, 0x03fe, 0x0264, 0x027a, 0x0386, 0x03fe, 0x0fea, 0x03fc, 0x1db9, 0x0e72, 0x0bde, 0x07f4, 0x077e, 0x073a, 0x07f6, 0x01c6, 0x017e, 0x025a, 0x0278, 0x026e, 0x0266, 0x2ffb, 0x1dba, 0x0feb, 0x0faf, 0x0e73, 0x0fa6, 0x025b, 0x013e, 0x01c2, 0x016e, 0x013f, 0x017a, 0x01be, 0x7f76, 0x07fa, 0x1fdf, 0x1dbb, 0x1f7e, 0x04cb, 0x026f, 0x07de, 0x0136, 0x00be, 0x00e2, 0x00e6, 0x00ee, 0x77ff, 0x3fba, 0x0ffe, 0x17fc, 0x09e7, 0x05bc, 0x0e77, 0x07d6, 0x012c, 0x00bc, 0x0072, 0x0024, 0x002e, 0x3ffe, 0x1ffe, 0x3bfd, 0x17ff, 0x09e5, 0x07fb, 0x0edf, 0x07dc, 0x03ff, 0x00b6, 0x007c, 0x001a, 0x0006, 0x7fff, 0x7f77, 0x3efe, 0x1c3e, 0x3eff, 0x1fdc, 0x0fbe, 0x07dd, 0x012f, 0x00de, 0x001e, 0x001e, 0x0000, },
        {      3,      4,      7,      8,     10,     11,     12,     13,     14,     15,     14,     15,     16,      4,      4,      6,      7,      9,     10,     11,     12,     13,     13,     13,     14,     15,      6,      5,      6,      7,      9,     10,     11,     12,     12,     13,     14,     14,     14,      8,      7,      7,      7,      9,     10,     11,     11,     12,     13,     13,     13,     13,      9,      8,      9,      9,      9,     10,     10,     11,     12,     12,     12,     12,     13,     11,     10,     10,     10,     10,      8,     10,     11,     11,     11,     11,     12,     12,     12,     11,     11,     11,      9,     10,     10,     10,     10,     10,     11,     12,     11,     13,     12,     12,     11,     11,     11,     11,      9,      9,     10,     10,     10,     10,     14,     13,     12,     12,     12,     12,     10,      9,      9,      9,      9,      9,      9,     15,     12,     13,     13,     13,     11,     10,     11,      9,      8,      8,      8,      8,     15,     14,     13,     13,     12,     11,     12,     11,      9,      8,      7,      6,      6,     15,     14,     14,     13,     12,     12,     12,     11,     10,      8,      7,      5,      4,     16,     15,     14,     13,     14,     13,     12,     11,      9,      8,      6,      5,      2, }
      }
    }
  }
};
