/*******************************************************************************
This software module was originally developed by

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips

and edited by

-

in the course of development of ISO/IEC 23003 for reference purposes and its
performance may not have been optimized. This software module is an
implementation of one or more tools as specified by ISO/IEC 23003. ISO/IEC gives
You a royalty-free, worldwide, non-exclusive, copyright license to copy,
distribute, and make derivative works of this software module or modifications
thereof for use in implementations of ISO/IEC 23003 in products that satisfy
conformance criteria (if any). Those intending to use this software module in
products are advised that its use may infringe existing patents. ISO/IEC have no
liability for use of this software module or modifications thereof. Copyright is
not released for products that do not conform to audiovisual and image-coding
related ITU Recommendations and/or ISO/IEC International Standards.

Agere Systems, Coding Technologies, Fraunhofer IIS, Philips retain full right to
modify and use the code for its (their) own purpose, assign or donate the code
to a third party and to inhibit third parties from using the code for products
that do not conform to MPEG-related ITU Recommendations and/or ISO/IEC
International Standards. This copyright notice must be included in all copies or
derivative works.

Copyright (c) ISO/IEC 2008.
*******************************************************************************/


#include "sac_dec.h"
#include "sac_hrtf.h"

static const float KemarImpulseLeft1[] =
{
  -1.905778e-003f,  2.492171e-003f, -3.430400e-003f,  2.931965e-003f, -2.931965e-003f,  3.137203e-003f, -4.603186e-003f,  1.371280e-001f,
   3.792204e-001f, -1.507323e-001f, -2.810582e-001f, -2.849870e-002f, -7.535151e-002f,  2.632025e-001f,  1.777944e-001f,  1.832478e-001f,
   5.856894e-001f,  3.248325e-001f, -3.021390e-001f, -1.812248e-001f,  4.433132e-002f, -3.508390e-001f, -4.013274e-001f, -1.452202e-001f,
  -1.041141e-001f, -1.816646e-001f, -2.398348e-002f,  9.376425e-002f, -1.935097e-003f,  5.424136e-002f,  1.480936e-001f,  1.250776e-001f,
   5.303925e-002f,  6.655562e-002f,  3.550610e-002f, -3.228094e-002f, -8.414741e-003f,  4.943294e-002f,  1.650697e-002f, -3.418672e-002f,
  -3.368828e-002f, -4.371560e-002f, -9.089093e-002f, -1.532245e-001f, -1.627241e-001f, -9.959887e-002f, -4.057840e-002f, -9.352970e-003f,
   1.395616e-002f,  3.796895e-002f,  5.811156e-002f,  7.048445e-002f,  6.890119e-002f,  4.717532e-002f,  3.075632e-002f,  1.964417e-002f,
   7.359233e-003f, -6.274406e-003f, -9.118413e-003f, -1.791431e-002f, -2.917306e-002f, -2.732592e-002f, -3.005265e-002f, -3.644433e-002f,
  -2.527354e-002f, -1.756247e-002f, -1.826614e-002f, -1.298861e-002f, -3.078564e-003f,  9.089093e-004f,  5.101620e-003f,  1.504098e-002f,
   2.169654e-002f,  1.677084e-002f,  4.603186e-003f,  1.465983e-004f, -1.290065e-003f, -2.052376e-003f, -4.720464e-003f, -5.042981e-003f,
  -1.143467e-002f, -1.841274e-002f, -1.527554e-002f, -1.078963e-002f, -1.017392e-002f, -5.922570e-003f, -6.157127e-004f, -1.641901e-003f,
  -5.365497e-003f, -5.863931e-005f,  9.323650e-003f,  1.034984e-002f,  8.180184e-003f,  4.603186e-003f, -8.795896e-004f, -4.456587e-003f,
  -3.547678e-003f, -5.834611e-003f, -8.561339e-003f, -9.528888e-003f, -1.410275e-002f, -1.577397e-002f, -9.558207e-003f, -1.759179e-003f,
   2.756048e-003f,  1.817819e-003f, -1.319384e-003f, -3.019924e-003f, -3.489039e-003f, -4.163391e-003f, -2.521490e-003f, -2.140335e-003f,
  -4.779104e-003f, -4.397948e-003f, -2.638769e-003f, -1.348704e-003f, -5.277538e-004f, -1.465983e-004f, -2.111015e-003f, -4.456587e-003f,
  -4.661825e-003f, -2.257613e-003f,  1.231425e-003f,  3.430400e-003f,  2.550810e-003f,  1.026188e-003f, -1.759179e-004f, -1.290065e-003f
};

static const float KemarImpulseRight1[] =
{
  -2.931965e-005f, -5.863931e-005f,  2.931965e-005f, -2.931965e-005f, -5.863931e-005f,  0.000000e+000f,  2.931965e-005f,  0.000000e+000f,
   8.795896e-005f, -1.172786e-004f,  2.931965e-004f, -4.691145e-004f,  7.329914e-004f, -1.026188e-003f,  9.968683e-004f, -7.623110e-004f,
   1.729860e-003f,  5.101620e-003f,  8.429401e-002f,  7.705205e-002f, -7.024989e-002f,  6.215767e-003f, -5.863931e-004f, -5.388952e-002f,
   8.332646e-002f,  9.361766e-002f,  6.359433e-002f,  1.722823e-001f,  1.911935e-001f, -2.562538e-002f, -5.781836e-002f,  5.151463e-002f,
  -7.725729e-002f, -1.774132e-001f, -6.623310e-002f, -4.101820e-002f, -1.090984e-001f, -5.670421e-002f,  5.951890e-003f, -4.192711e-003f,
   1.495302e-003f,  4.526955e-002f,  5.391884e-002f,  3.767576e-002f,  5.142667e-002f,  4.573866e-002f,  1.037916e-002f,  9.001134e-003f,
   2.184314e-002f, -4.397948e-004f, -2.014260e-002f, -1.920437e-002f, -2.216566e-002f, -3.714800e-002f, -4.755648e-002f, -4.606118e-002f,
  -4.034384e-002f, -3.128407e-002f, -1.970281e-002f, -1.117079e-002f, -4.749784e-003f, -2.931965e-004f,  1.964417e-003f,  2.814687e-003f,
   1.465983e-003f,  2.374892e-003f,  5.453456e-003f,  2.580130e-003f, -1.612581e-003f, -1.553942e-003f, -5.189579e-003f, -1.175718e-002f,
  -1.237289e-002f, -1.240221e-002f, -1.401479e-002f, -9.499568e-003f, -3.489039e-003f, -2.726728e-003f, -3.166523e-003f, -1.202106e-003f,
  -2.345572e-004f, -8.795896e-004f,  2.345572e-004f,  2.052376e-003f,  2.638769e-004f, -3.401080e-003f, -5.365497e-003f, -4.544546e-003f,
  -5.336177e-003f, -6.802160e-003f, -5.394816e-003f, -5.218898e-003f, -6.508963e-003f, -5.834611e-003f, -3.782235e-003f, -3.195842e-003f,
  -2.228294e-003f, -5.863931e-005f, -4.397948e-004f, -2.785367e-003f, -2.609449e-003f, -1.378024e-003f, -1.993737e-003f, -2.668089e-003f,
  -2.257613e-003f, -3.195842e-003f, -4.309989e-003f, -4.456587e-003f, -4.691145e-003f, -4.339309e-003f, -3.723596e-003f, -4.046112e-003f,
  -4.368629e-003f, -2.844006e-003f, -1.436663e-003f, -1.172786e-003f, -1.583261e-003f, -1.700540e-003f, -1.114147e-003f, -1.172786e-003f,
  -1.847138e-003f, -2.198974e-003f, -2.844006e-003f, -4.075432e-003f, -4.925702e-003f, -4.867063e-003f, -4.544546e-003f, -3.664957e-003f
};

static const float KemarImpulseLeft2[] =
{
  -2.931965e-005f, -5.863931e-005f,  2.931965e-005f, -2.931965e-005f, -5.863931e-005f,  0.000000e+000f,  2.931965e-005f,  0.000000e+000f,
   8.795896e-005f, -1.172786e-004f,  2.931965e-004f, -4.691145e-004f,  7.329914e-004f, -1.026188e-003f,  9.968683e-004f, -7.623110e-004f,
   1.729860e-003f,  5.101620e-003f,  8.429401e-002f,  7.705205e-002f, -7.024989e-002f,  6.215767e-003f, -5.863931e-004f, -5.388952e-002f,
   8.332646e-002f,  9.361766e-002f,  6.359433e-002f,  1.722823e-001f,  1.911935e-001f, -2.562538e-002f, -5.781836e-002f,  5.151463e-002f,
  -7.725729e-002f, -1.774132e-001f, -6.623310e-002f, -4.101820e-002f, -1.090984e-001f, -5.670421e-002f,  5.951890e-003f, -4.192711e-003f,
   1.495302e-003f,  4.526955e-002f,  5.391884e-002f,  3.767576e-002f,  5.142667e-002f,  4.573866e-002f,  1.037916e-002f,  9.001134e-003f,
   2.184314e-002f, -4.397948e-004f, -2.014260e-002f, -1.920437e-002f, -2.216566e-002f, -3.714800e-002f, -4.755648e-002f, -4.606118e-002f,
  -4.034384e-002f, -3.128407e-002f, -1.970281e-002f, -1.117079e-002f, -4.749784e-003f, -2.931965e-004f,  1.964417e-003f,  2.814687e-003f,
   1.465983e-003f,  2.374892e-003f,  5.453456e-003f,  2.580130e-003f, -1.612581e-003f, -1.553942e-003f, -5.189579e-003f, -1.175718e-002f,
  -1.237289e-002f, -1.240221e-002f, -1.401479e-002f, -9.499568e-003f, -3.489039e-003f, -2.726728e-003f, -3.166523e-003f, -1.202106e-003f,
  -2.345572e-004f, -8.795896e-004f,  2.345572e-004f,  2.052376e-003f,  2.638769e-004f, -3.401080e-003f, -5.365497e-003f, -4.544546e-003f,
  -5.336177e-003f, -6.802160e-003f, -5.394816e-003f, -5.218898e-003f, -6.508963e-003f, -5.834611e-003f, -3.782235e-003f, -3.195842e-003f,
  -2.228294e-003f, -5.863931e-005f, -4.397948e-004f, -2.785367e-003f, -2.609449e-003f, -1.378024e-003f, -1.993737e-003f, -2.668089e-003f,
  -2.257613e-003f, -3.195842e-003f, -4.309989e-003f, -4.456587e-003f, -4.691145e-003f, -4.339309e-003f, -3.723596e-003f, -4.046112e-003f,
  -4.368629e-003f, -2.844006e-003f, -1.436663e-003f, -1.172786e-003f, -1.583261e-003f, -1.700540e-003f, -1.114147e-003f, -1.172786e-003f,
  -1.847138e-003f, -2.198974e-003f, -2.844006e-003f, -4.075432e-003f, -4.925702e-003f, -4.867063e-003f, -4.544546e-003f, -3.664957e-003f
};

static const float KemarImpulseRight2[] =
{
  -1.905778e-003f,  2.492171e-003f, -3.430400e-003f,  2.931965e-003f, -2.931965e-003f,  3.137203e-003f, -4.603186e-003f,  1.371280e-001f,
   3.792204e-001f, -1.507323e-001f, -2.810582e-001f, -2.849870e-002f, -7.535151e-002f,  2.632025e-001f,  1.777944e-001f,  1.832478e-001f,
   5.856894e-001f,  3.248325e-001f, -3.021390e-001f, -1.812248e-001f,  4.433132e-002f, -3.508390e-001f, -4.013274e-001f, -1.452202e-001f,
  -1.041141e-001f, -1.816646e-001f, -2.398348e-002f,  9.376425e-002f, -1.935097e-003f,  5.424136e-002f,  1.480936e-001f,  1.250776e-001f,
   5.303925e-002f,  6.655562e-002f,  3.550610e-002f, -3.228094e-002f, -8.414741e-003f,  4.943294e-002f,  1.650697e-002f, -3.418672e-002f,
  -3.368828e-002f, -4.371560e-002f, -9.089093e-002f, -1.532245e-001f, -1.627241e-001f, -9.959887e-002f, -4.057840e-002f, -9.352970e-003f,
   1.395616e-002f,  3.796895e-002f,  5.811156e-002f,  7.048445e-002f,  6.890119e-002f,  4.717532e-002f,  3.075632e-002f,  1.964417e-002f,
   7.359233e-003f, -6.274406e-003f, -9.118413e-003f, -1.791431e-002f, -2.917306e-002f, -2.732592e-002f, -3.005265e-002f, -3.644433e-002f,
  -2.527354e-002f, -1.756247e-002f, -1.826614e-002f, -1.298861e-002f, -3.078564e-003f,  9.089093e-004f,  5.101620e-003f,  1.504098e-002f,
   2.169654e-002f,  1.677084e-002f,  4.603186e-003f,  1.465983e-004f, -1.290065e-003f, -2.052376e-003f, -4.720464e-003f, -5.042981e-003f,
  -1.143467e-002f, -1.841274e-002f, -1.527554e-002f, -1.078963e-002f, -1.017392e-002f, -5.922570e-003f, -6.157127e-004f, -1.641901e-003f,
  -5.365497e-003f, -5.863931e-005f,  9.323650e-003f,  1.034984e-002f,  8.180184e-003f,  4.603186e-003f, -8.795896e-004f, -4.456587e-003f,
  -3.547678e-003f, -5.834611e-003f, -8.561339e-003f, -9.528888e-003f, -1.410275e-002f, -1.577397e-002f, -9.558207e-003f, -1.759179e-003f,
   2.756048e-003f,  1.817819e-003f, -1.319384e-003f, -3.019924e-003f, -3.489039e-003f, -4.163391e-003f, -2.521490e-003f, -2.140335e-003f,
  -4.779104e-003f, -4.397948e-003f, -2.638769e-003f, -1.348704e-003f, -5.277538e-004f, -1.465983e-004f, -2.111015e-003f, -4.456587e-003f,
  -4.661825e-003f, -2.257613e-003f,  1.231425e-003f,  3.430400e-003f,  2.550810e-003f,  1.026188e-003f, -1.759179e-004f, -1.290065e-003f
};

static const float KemarImpulseLeft3[] =
{
   1.465983e-004f, -1.759179e-004f,  5.570734e-004f, -7.036717e-004f,  1.143467e-003f, -1.641901e-003f,  2.169654e-003f, -2.961285e-003f,
   3.518359e-003f, -4.016793e-003f,  4.720464e-003f,  8.795896e-004f,  1.560099e-001f,  1.778530e-001f, -1.982595e-001f, -7.417873e-003f,
   5.717333e-003f, -1.503805e-001f,  2.135937e-001f,  1.755075e-001f,  6.837343e-002f,  3.455321e-001f,  3.245393e-001f, -1.916333e-001f,
  -1.497941e-001f,  1.330819e-001f, -2.394536e-001f, -3.969588e-001f, -5.940162e-002f, -4.002133e-002f, -2.150890e-001f, -3.744120e-002f,
   8.831080e-002f,  2.345572e-003f,  3.178251e-002f,  1.234944e-001f,  9.634438e-002f,  3.984541e-002f,  7.233159e-002f,  4.524023e-002f,
  -2.653429e-002f, -5.600054e-003f,  3.562338e-002f, -1.721064e-002f, -4.975545e-002f, -3.216366e-002f, -3.620977e-002f, -6.259746e-002f,
  -7.948558e-002f, -7.101220e-002f, -5.998801e-002f, -3.902446e-002f, -7.417873e-003f,  3.342441e-003f,  5.688013e-003f,  1.996668e-002f,
   3.840875e-002f,  4.031452e-002f,  2.723796e-002f,  2.040648e-002f,  1.621377e-002f,  4.427268e-003f, -7.153996e-003f, -6.596922e-003f,
  -1.389752e-002f, -2.401280e-002f, -2.049444e-002f, -2.157927e-002f, -2.700340e-002f, -2.157927e-002f, -1.589125e-002f, -1.773839e-002f,
  -1.310589e-002f, -2.140335e-003f,  2.228294e-003f,  4.603186e-003f,  1.032052e-002f,  1.609649e-002f,  1.228494e-002f,  3.283801e-003f,
  -9.968683e-004f, -1.759179e-004f, -3.049244e-003f, -8.971814e-003f, -8.004266e-003f, -9.118413e-003f, -1.158126e-002f, -8.561339e-003f,
  -4.837743e-003f, -5.130940e-003f, -4.309989e-003f, -1.465983e-004f, -1.759179e-003f, -7.212635e-003f, -3.987473e-003f,  1.729860e-003f,
   1.671220e-003f,  4.691145e-004f,  1.055508e-003f, -1.084827e-003f, -4.251350e-003f, -3.489039e-003f, -4.485907e-003f, -5.717333e-003f,
  -5.248218e-003f, -6.333045e-003f, -7.036717e-003f, -3.752916e-003f,  7.329914e-004f,  2.169654e-003f,  3.518359e-004f, -1.290065e-003f,
  -9.675486e-004f, -2.785367e-003f, -5.922570e-003f, -5.424136e-003f, -4.632505e-003f, -5.629374e-003f, -4.749784e-003f, -2.433531e-003f,
  -1.495302e-003f, -7.916307e-004f, -6.157127e-004f, -1.553942e-003f, -1.700540e-003f, -1.114147e-003f, -1.641901e-003f, -1.700540e-003f
};

static const float KemarImpulseRight3[] =
{
   1.465983e-004f, -1.759179e-004f,  5.570734e-004f, -7.036717e-004f,  1.143467e-003f, -1.641901e-003f,  2.169654e-003f, -2.961285e-003f,
   3.518359e-003f, -4.016793e-003f,  4.720464e-003f,  8.795896e-004f,  1.560099e-001f,  1.778530e-001f, -1.982595e-001f, -7.417873e-003f,
   5.717333e-003f, -1.503805e-001f,  2.135937e-001f,  1.755075e-001f,  6.837343e-002f,  3.455321e-001f,  3.245393e-001f, -1.916333e-001f,
  -1.497941e-001f,  1.330819e-001f, -2.394536e-001f, -3.969588e-001f, -5.940162e-002f, -4.002133e-002f, -2.150890e-001f, -3.744120e-002f,
   8.831080e-002f,  2.345572e-003f,  3.178251e-002f,  1.234944e-001f,  9.634438e-002f,  3.984541e-002f,  7.233159e-002f,  4.524023e-002f,
  -2.653429e-002f, -5.600054e-003f,  3.562338e-002f, -1.721064e-002f, -4.975545e-002f, -3.216366e-002f, -3.620977e-002f, -6.259746e-002f,
  -7.948558e-002f, -7.101220e-002f, -5.998801e-002f, -3.902446e-002f, -7.417873e-003f,  3.342441e-003f,  5.688013e-003f,  1.996668e-002f,
   3.840875e-002f,  4.031452e-002f,  2.723796e-002f,  2.040648e-002f,  1.621377e-002f,  4.427268e-003f, -7.153996e-003f, -6.596922e-003f,
  -1.389752e-002f, -2.401280e-002f, -2.049444e-002f, -2.157927e-002f, -2.700340e-002f, -2.157927e-002f, -1.589125e-002f, -1.773839e-002f,
  -1.310589e-002f, -2.140335e-003f,  2.228294e-003f,  4.603186e-003f,  1.032052e-002f,  1.609649e-002f,  1.228494e-002f,  3.283801e-003f,
  -9.968683e-004f, -1.759179e-004f, -3.049244e-003f, -8.971814e-003f, -8.004266e-003f, -9.118413e-003f, -1.158126e-002f, -8.561339e-003f,
  -4.837743e-003f, -5.130940e-003f, -4.309989e-003f, -1.465983e-004f, -1.759179e-003f, -7.212635e-003f, -3.987473e-003f,  1.729860e-003f,
   1.671220e-003f,  4.691145e-004f,  1.055508e-003f, -1.084827e-003f, -4.251350e-003f, -3.489039e-003f, -4.485907e-003f, -5.717333e-003f,
  -5.248218e-003f, -6.333045e-003f, -7.036717e-003f, -3.752916e-003f,  7.329914e-004f,  2.169654e-003f,  3.518359e-004f, -1.290065e-003f,
  -9.675486e-004f, -2.785367e-003f, -5.922570e-003f, -5.424136e-003f, -4.632505e-003f, -5.629374e-003f, -4.749784e-003f, -2.433531e-003f,
  -1.495302e-003f, -7.916307e-004f, -6.157127e-004f, -1.553942e-003f, -1.700540e-003f, -1.114147e-003f, -1.641901e-003f, -1.700540e-003f
};

static const float KemarImpulseLeft4[] =
{
   6.538283e-003f, -1.155194e-002f,  1.524622e-002f, -6.743521e-004f,  3.948771e-001f,  1.884961e-001f, -6.531246e-001f, -1.362778e-001f,
   3.948185e-001f,  6.482576e-002f,  8.775373e-002f,  6.032812e-001f,  1.519638e-001f, -4.109150e-001f,  1.852123e-001f,  4.709616e-001f,
  -8.570135e-002f, -2.937243e-001f, -1.071927e-001f, -2.309509e-001f, -1.506151e-001f, -1.524622e-003f, -2.257613e-001f, -2.858666e-001f,
  -6.080896e-002f,  8.757781e-002f,  3.840875e-002f,  3.706004e-002f,  1.320850e-001f,  1.093623e-001f,  5.743720e-002f,  6.916506e-002f,
   1.615513e-002f, -8.836944e-002f, -4.808423e-002f, -1.422003e-002f, -5.386021e-002f, -9.411609e-002f, -8.561339e-002f, -4.966749e-002f,
  -2.559606e-002f,  4.779104e-003f,  5.981210e-003f, -8.971814e-003f, -7.505832e-003f,  1.331112e-002f,  1.999600e-002f,  2.040648e-002f,
   2.348504e-002f,  2.240022e-002f,  9.763445e-003f, -4.867063e-003f, -3.870194e-003f,  1.847138e-003f, -1.553942e-002f, -2.374892e-002f,
  -2.629973e-002f, -3.474379e-002f, -3.486107e-002f, -1.574465e-002f, -2.931965e-005f, -4.896382e-003f, -1.026188e-002f, -3.518359e-003f,
   7.564471e-003f,  6.655562e-003f,  1.222630e-002f,  1.943893e-002f,  1.266609e-002f, -2.668089e-003f, -2.931965e-003f, -1.231425e-003f,
  -8.561339e-003f, -6.596922e-003f,  2.961285e-003f, -5.189579e-003f, -1.559806e-002f, -1.020324e-002f, -3.664957e-003f, -3.782235e-003f,
   6.743521e-004f,  5.336177e-003f, -2.492171e-003f, -7.593791e-003f, -3.752916e-003f,  5.863931e-004f,  2.961285e-003f,  7.623110e-003f,
   4.896382e-003f, -4.456587e-003f, -9.352970e-003f, -5.570734e-003f, -9.968683e-004f,  7.329914e-004f, -2.345572e-003f, -8.913175e-003f,
  -1.498234e-002f, -1.401479e-002f, -3.811555e-003f,  4.485907e-003f,  2.697408e-003f, -4.808423e-003f, -8.766577e-003f, -8.913175e-003f,
  -4.222030e-003f,  2.052376e-003f,  2.873326e-003f, -3.635637e-003f, -1.032052e-002f, -1.169854e-002f, -6.978078e-003f, -8.209503e-004f,
   2.345572e-003f,  5.570734e-004f, -3.723596e-003f, -4.691145e-003f, -7.916307e-004f,  3.723596e-003f,  2.785367e-003f, -2.052376e-004f,
  -2.228294e-003f, -4.075432e-003f, -4.397948e-003f, -6.450324e-004f,  2.198974e-003f,  8.502700e-004f, -1.348704e-003f, -2.023056e-003f
};

static const float KemarImpulseRight4[] =
{
   0.000000e+000f,  0.000000e+000f,  2.931965e-005f,  2.931965e-005f,  2.931965e-005f,  2.931965e-005f,  0.000000e+000f,  0.000000e+000f,
   0.000000e+000f,  0.000000e+000f, -2.931965e-005f,  2.931965e-005f,  0.000000e+000f,  0.000000e+000f,  8.795896e-005f,  2.931965e-005f,
   2.931965e-005f,  5.863931e-005f,  8.795896e-005f, -1.172786e-004f,  1.172786e-004f,  3.225162e-004f, -5.863931e-005f,  2.931965e-004f,
   4.104752e-004f,  2.931965e-004f,  4.984341e-003f,  3.242754e-002f,  2.606517e-002f, -1.594989e-002f, -5.160259e-003f,  1.864730e-002f,
   9.822084e-003f,  2.316253e-003f,  2.131539e-002f,  6.567603e-002f,  8.663958e-002f,  6.054509e-002f,  3.905378e-002f,  2.096355e-002f,
   3.342441e-003f, -8.150864e-003f, -2.650497e-002f, -1.287133e-002f,  1.342840e-002f,  1.876458e-002f,  2.627041e-002f,  2.706204e-002f,
   7.212635e-003f, -1.656560e-002f, -2.410076e-002f, -3.025788e-002f, -4.137003e-002f, -4.389152e-002f, -3.644433e-002f, -3.087360e-002f,
  -2.380756e-002f, -9.089093e-003f, -8.795896e-004f,  3.664957e-003f,  9.763445e-003f,  1.404411e-002f,  1.090691e-002f,  3.723596e-003f,
   4.104752e-004f, -2.726728e-003f, -7.359233e-003f, -9.294330e-003f, -9.294330e-003f, -1.108283e-002f, -1.392684e-002f, -1.383888e-002f,
  -1.348704e-002f, -1.375092e-002f, -1.480643e-002f, -1.334044e-002f, -9.352970e-003f, -6.626242e-003f, -2.492171e-003f, -5.570734e-004f,
  -1.465983e-004f,  8.795896e-005f, -3.518359e-004f, -1.612581e-003f, -3.694276e-003f, -3.547678e-003f, -3.137203e-003f, -4.280670e-003f,
  -5.453456e-003f, -5.570734e-003f, -4.896382e-003f, -4.456587e-003f, -3.811555e-003f, -4.837743e-003f, -5.013661e-003f, -3.811555e-003f,
  -2.286933e-003f, -1.759179e-003f, -2.580130e-003f, -2.316253e-003f, -3.107883e-003f, -3.518359e-003f, -2.785367e-003f, -2.404212e-003f,
  -2.873326e-003f, -3.547678e-003f, -4.134071e-003f, -5.482775e-003f, -6.039849e-003f, -5.277538e-003f, -4.339309e-003f, -3.958153e-003f,
  -3.489039e-003f, -2.931965e-003f, -2.902646e-003f, -2.873326e-003f, -3.518359e-003f, -3.870194e-003f, -3.342441e-003f, -2.404212e-003f,
  -1.759179e-003f, -9.968683e-004f, -2.931965e-004f, -1.172786e-004f, -5.277538e-004f, -1.407343e-003f, -2.140335e-003f, -2.844006e-003f
};

static const float KemarImpulseLeft5[] =
{
   0.000000e+000f,  0.000000e+000f,  2.931965e-005f,  2.931965e-005f,  2.931965e-005f,  2.931965e-005f,  0.000000e+000f,  0.000000e+000f,
   0.000000e+000f,  0.000000e+000f, -2.931965e-005f,  2.931965e-005f,  0.000000e+000f,  0.000000e+000f,  8.795896e-005f,  2.931965e-005f,
   2.931965e-005f,  5.863931e-005f,  8.795896e-005f, -1.172786e-004f,  1.172786e-004f,  3.225162e-004f, -5.863931e-005f,  2.931965e-004f,
   4.104752e-004f,  2.931965e-004f,  4.984341e-003f,  3.242754e-002f,  2.606517e-002f, -1.594989e-002f, -5.160259e-003f,  1.864730e-002f,
   9.822084e-003f,  2.316253e-003f,  2.131539e-002f,  6.567603e-002f,  8.663958e-002f,  6.054509e-002f,  3.905378e-002f,  2.096355e-002f,
   3.342441e-003f, -8.150864e-003f, -2.650497e-002f, -1.287133e-002f,  1.342840e-002f,  1.876458e-002f,  2.627041e-002f,  2.706204e-002f,
   7.212635e-003f, -1.656560e-002f, -2.410076e-002f, -3.025788e-002f, -4.137003e-002f, -4.389152e-002f, -3.644433e-002f, -3.087360e-002f,
  -2.380756e-002f, -9.089093e-003f, -8.795896e-004f,  3.664957e-003f,  9.763445e-003f,  1.404411e-002f,  1.090691e-002f,  3.723596e-003f,
   4.104752e-004f, -2.726728e-003f, -7.359233e-003f, -9.294330e-003f, -9.294330e-003f, -1.108283e-002f, -1.392684e-002f, -1.383888e-002f,
  -1.348704e-002f, -1.375092e-002f, -1.480643e-002f, -1.334044e-002f, -9.352970e-003f, -6.626242e-003f, -2.492171e-003f, -5.570734e-004f,
  -1.465983e-004f,  8.795896e-005f, -3.518359e-004f, -1.612581e-003f, -3.694276e-003f, -3.547678e-003f, -3.137203e-003f, -4.280670e-003f,
  -5.453456e-003f, -5.570734e-003f, -4.896382e-003f, -4.456587e-003f, -3.811555e-003f, -4.837743e-003f, -5.013661e-003f, -3.811555e-003f,
  -2.286933e-003f, -1.759179e-003f, -2.580130e-003f, -2.316253e-003f, -3.107883e-003f, -3.518359e-003f, -2.785367e-003f, -2.404212e-003f,
  -2.873326e-003f, -3.547678e-003f, -4.134071e-003f, -5.482775e-003f, -6.039849e-003f, -5.277538e-003f, -4.339309e-003f, -3.958153e-003f,
  -3.489039e-003f, -2.931965e-003f, -2.902646e-003f, -2.873326e-003f, -3.518359e-003f, -3.870194e-003f, -3.342441e-003f, -2.404212e-003f,
  -1.759179e-003f, -9.968683e-004f, -2.931965e-004f, -1.172786e-004f, -5.277538e-004f, -1.407343e-003f, -2.140335e-003f, -2.844006e-003f
};

static const float KemarImpulseRight5[] =
{
   6.538283e-003f, -1.155194e-002f,  1.524622e-002f, -6.743521e-004f,  3.948771e-001f,  1.884961e-001f, -6.531246e-001f, -1.362778e-001f,
   3.948185e-001f,  6.482576e-002f,  8.775373e-002f,  6.032812e-001f,  1.519638e-001f, -4.109150e-001f,  1.852123e-001f,  4.709616e-001f,
  -8.570135e-002f, -2.937243e-001f, -1.071927e-001f, -2.309509e-001f, -1.506151e-001f, -1.524622e-003f, -2.257613e-001f, -2.858666e-001f,
  -6.080896e-002f,  8.757781e-002f,  3.840875e-002f,  3.706004e-002f,  1.320850e-001f,  1.093623e-001f,  5.743720e-002f,  6.916506e-002f,
   1.615513e-002f, -8.836944e-002f, -4.808423e-002f, -1.422003e-002f, -5.386021e-002f, -9.411609e-002f, -8.561339e-002f, -4.966749e-002f,
  -2.559606e-002f,  4.779104e-003f,  5.981210e-003f, -8.971814e-003f, -7.505832e-003f,  1.331112e-002f,  1.999600e-002f,  2.040648e-002f,
   2.348504e-002f,  2.240022e-002f,  9.763445e-003f, -4.867063e-003f, -3.870194e-003f,  1.847138e-003f, -1.553942e-002f, -2.374892e-002f,
  -2.629973e-002f, -3.474379e-002f, -3.486107e-002f, -1.574465e-002f, -2.931965e-005f, -4.896382e-003f, -1.026188e-002f, -3.518359e-003f,
   7.564471e-003f,  6.655562e-003f,  1.222630e-002f,  1.943893e-002f,  1.266609e-002f, -2.668089e-003f, -2.931965e-003f, -1.231425e-003f,
  -8.561339e-003f, -6.596922e-003f,  2.961285e-003f, -5.189579e-003f, -1.559806e-002f, -1.020324e-002f, -3.664957e-003f, -3.782235e-003f,
   6.743521e-004f,  5.336177e-003f, -2.492171e-003f, -7.593791e-003f, -3.752916e-003f,  5.863931e-004f,  2.961285e-003f,  7.623110e-003f,
   4.896382e-003f, -4.456587e-003f, -9.352970e-003f, -5.570734e-003f, -9.968683e-004f,  7.329914e-004f, -2.345572e-003f, -8.913175e-003f,
  -1.498234e-002f, -1.401479e-002f, -3.811555e-003f,  4.485907e-003f,  2.697408e-003f, -4.808423e-003f, -8.766577e-003f, -8.913175e-003f,
  -4.222030e-003f,  2.052376e-003f,  2.873326e-003f, -3.635637e-003f, -1.032052e-002f, -1.169854e-002f, -6.978078e-003f, -8.209503e-004f,
   2.345572e-003f,  5.570734e-004f, -3.723596e-003f, -4.691145e-003f, -7.916307e-004f,  3.723596e-003f,  2.785367e-003f, -2.052376e-004f,
  -2.228294e-003f, -4.075432e-003f, -4.397948e-003f, -6.450324e-004f,  2.198974e-003f,  8.502700e-004f, -1.348704e-003f, -2.023056e-003f
};

const HRTF_DATA SpatialDecKemarHRTF =
{
  44100,
  128,
  {
    {
      {
         2.387203e-001f,  4.162548e-001f,  5.510036e-001f,  5.952277e-001f,  6.157891e-001f,  7.654630e-001f,  8.069170e-001f,
         7.879894e-001f,  7.783799e-001f,  1.129648e+000f,  2.262661e+000f,  3.187522e+000f,  2.520083e+000f,  1.809052e+000f,
         1.821461e+000f,  2.357194e+000f,  2.526584e+000f,  1.696232e+000f,  1.621996e+000f,  1.348401e+000f,  8.216626e-001f,
         6.082978e-001f,  4.490433e-001f,  1.083321e+000f,  1.500758e+000f,  1.262397e+000f,  1.004169e+000f,  4.953084e-001f
      },
      {
         1.817223e-001f,  3.339259e-001f,  4.504033e-001f,  4.881924e-001f,  4.589720e-001f,  4.740727e-001f,  4.474174e-001f,
         3.381000e-001f,  3.356560e-001f,  6.579395e-001f,  1.029466e+000f,  1.255456e+000f,  1.126207e+000f,  8.261765e-001f,
         7.471920e-001f,  7.155281e-001f,  6.880614e-001f,  5.432821e-001f,  4.591528e-001f,  3.253192e-001f,  1.796228e-001f,
         8.942509e-002f,  1.169639e-001f,  2.542874e-001f,  3.100640e-001f,  6.442513e-001f,  2.971157e-001f,  1.355788e-001f
      },
      {
         9.977788e-001f,  9.987864e-001f,  9.983265e-001f,  9.976719e-001f,  9.903477e-001f,  9.966089e-001f,  9.936592e-001f,
         9.964507e-001f,  9.863121e-001f,  9.668220e-001f,  9.862945e-001f,  9.961028e-001f,  9.810934e-001f,  9.823802e-001f,
         9.761278e-001f,  9.932449e-001f,  9.964748e-001f,  9.297402e-001f,  9.529164e-001f,  9.716006e-001f,  9.339225e-001f,
         9.290465e-001f,  7.240560e-001f,  8.091687e-001f,  4.053196e-001f,  8.130705e-001f,  7.214655e-001f,  7.218246e-001f
      },
      {
         1.411718e-001f,  3.115071e-001f,  4.981376e-001f,  7.171891e-001f,  1.084564e+000f,  1.384061e+000f,  1.704243e+000f,
         1.958607e+000f,  1.928450e+000f,  2.705688e+000f,  3.394141e+000f,  3.758880e+000f,  4.249024e+000f,  4.897312e+000f,
         5.660209e+000f,  6.173727e+000f,  6.490025e+000f,  7.203449e+000f,  8.378263e+000f,  9.357760e+000f,  1.047480e+001f,
         1.150874e+001f,  1.316981e+001f,  1.463255e+001f,  1.775695e+001f,  2.097116e+001f,  2.393945e+001f,  2.601838e+001f
      },
      KemarImpulseLeft1,
      KemarImpulseRight1
    },
    {
      {
         1.817223e-001f,  3.339259e-001f,  4.504033e-001f,  4.881924e-001f,  4.589720e-001f,  4.740727e-001f,  4.474174e-001f,
         3.381000e-001f,  3.356560e-001f,  6.579395e-001f,  1.029466e+000f,  1.255456e+000f,  1.126207e+000f,  8.261765e-001f,
         7.471920e-001f,  7.155281e-001f,  6.880614e-001f,  5.432821e-001f,  4.591528e-001f,  3.253192e-001f,  1.796228e-001f,
         8.942509e-002f,  1.169639e-001f,  2.542874e-001f,  3.100640e-001f,  6.442513e-001f,  2.971157e-001f,  1.355788e-001f
      },
      {
         2.387203e-001f,  4.162548e-001f,  5.510036e-001f,  5.952277e-001f,  6.157891e-001f,  7.654630e-001f,  8.069170e-001f,
         7.879894e-001f,  7.783799e-001f,  1.129648e+000f,  2.262661e+000f,  3.187522e+000f,  2.520083e+000f,  1.809052e+000f,
         1.821461e+000f,  2.357194e+000f,  2.526584e+000f,  1.696232e+000f,  1.621996e+000f,  1.348401e+000f,  8.216626e-001f,
         6.082978e-001f,  4.490433e-001f,  1.083321e+000f,  1.500758e+000f,  1.262397e+000f,  1.004169e+000f,  4.953084e-001f
      },
      {
         9.977788e-001f,  9.987864e-001f,  9.983265e-001f,  9.976719e-001f,  9.903477e-001f,  9.966089e-001f,  9.936592e-001f,
         9.964507e-001f,  9.863121e-001f,  9.668220e-001f,  9.862945e-001f,  9.961028e-001f,  9.810934e-001f,  9.823802e-001f,
         9.761278e-001f,  9.932449e-001f,  9.964748e-001f,  9.297402e-001f,  9.529164e-001f,  9.716006e-001f,  9.339225e-001f,
         9.290465e-001f,  7.240560e-001f,  8.091687e-001f,  4.053196e-001f,  8.130705e-001f,  7.214655e-001f,  7.218246e-001f
      },
      {
        -1.411718e-001f, -3.115071e-001f, -4.981376e-001f, -7.171891e-001f, -1.084564e+000f, -1.384061e+000f, -1.704243e+000f,
        -1.958607e+000f, -1.928450e+000f, -2.705688e+000f, -3.394141e+000f, -3.758880e+000f, -4.249024e+000f, -4.897312e+000f,
        -5.660209e+000f, -6.173727e+000f, -6.490025e+000f, -7.203449e+000f, -8.378263e+000f, -9.357760e+000f, -1.047480e+001f,
        -1.150874e+001f, -1.316981e+001f, -1.463255e+001f, -1.775695e+001f, -2.097116e+001f, -2.393945e+001f, -2.601838e+001f
      },
      KemarImpulseLeft2,
      KemarImpulseRight2
    },
    {
      {
         2.071892e-001f,  3.724251e-001f,  4.947739e-001f,  5.302822e-001f,  5.189158e-001f,  5.867681e-001f,  5.801120e-001f,
         5.521454e-001f,  5.865600e-001f,  8.539292e-001f,  1.641312e+000f,  2.250541e+000f,  1.876722e+000f,  1.455980e+000f,
         1.442388e+000f,  1.526579e+000f,  1.544215e+000f,  1.074946e+000f,  8.907665e-001f,  6.951283e-001f,  3.871567e-001f,
         2.688445e-001f,  2.292882e-001f,  5.598465e-001f,  8.013566e-001f,  1.635350e+000f,  8.563501e-001f,  3.792483e-001f
      },
      {
         2.071892e-001f,  3.724251e-001f,  4.947739e-001f,  5.302822e-001f,  5.189158e-001f,  5.867681e-001f,  5.801120e-001f,
         5.521454e-001f,  5.865600e-001f,  8.539292e-001f,  1.641312e+000f,  2.250541e+000f,  1.876722e+000f,  1.455980e+000f,
         1.442388e+000f,  1.526579e+000f,  1.544215e+000f,  1.074946e+000f,  8.907665e-001f,  6.951283e-001f,  3.871567e-001f,
         2.688445e-001f,  2.292882e-001f,  5.598465e-001f,  8.013566e-001f,  1.635350e+000f,  8.563501e-001f,  3.792483e-001f
      },
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      KemarImpulseLeft3,
      KemarImpulseRight3
    },
    {
      {
         2.502824e-001f,  4.428893e-001f,  5.825083e-001f,  6.308962e-001f,  7.085657e-001f,  9.267583e-001f,  9.638747e-001f,
         9.810586e-001f,  1.140060e+000f,  1.243897e+000f,  1.579500e+000f,  2.344382e+000f,  2.394683e+000f,  1.917987e+000f,
         1.540392e+000f,  1.082793e+000f,  5.741153e-001f,  6.959617e-001f,  9.430776e-001f,  9.366873e-001f,  1.218178e+000f,
         1.833342e+000f,  2.033943e+000f,  7.192378e-001f,  1.767479e+000f,  2.870279e+000f,  8.659582e-001f,  3.723312e-001f
      },
      {
         1.337592e-001f,  2.761632e-001f,  3.968120e-001f,  4.605694e-001f,  4.559324e-001f,  4.274949e-001f,  4.654225e-001f,
         4.465855e-001f,  3.974667e-001f,  4.221716e-001f,  3.770393e-001f,  2.514178e-001f,  1.590889e-001f,  2.492666e-001f,
         3.347739e-001f,  4.076641e-001f,  4.412268e-001f,  3.470198e-001f,  2.414723e-001f,  1.108812e-001f,  2.118401e-002f,
         1.428967e-002f,  8.564881e-002f,  1.266620e-001f,  1.217435e-001f,  5.712448e-002f,  3.475773e-002f,  3.079471e-002f
      },
      {
         9.912678e-001f,  9.963487e-001f,  9.938882e-001f,  9.903200e-001f,  9.600061e-001f,  9.923907e-001f,  9.765615e-001f,
         9.697533e-001f,  9.514849e-001f,  8.963590e-001f,  8.511819e-001f,  8.035888e-001f,  6.890041e-001f,  8.801028e-001f,
         9.134347e-001f,  8.937091e-001f,  7.957618e-001f,  6.277516e-001f,  6.554546e-001f,  6.534512e-001f,  6.624642e-001f,
         6.303150e-001f,  5.938157e-001f,  8.282659e-001f,  1.066249e-001f,  3.245954e-001f,  3.809198e-001f,  3.942419e-001f
      },
      {
         3.026852e-001f,  5.663373e-001f,  8.961913e-001f,  1.324449e+000f,  2.095054e+000f,  2.682424e+000f,  3.199355e+000f,
         4.069215e+000f,  4.904351e+000f,  6.342136e+000f,  8.063613e+000f,  9.913350e+000f,  1.262810e+001f,  1.473773e+001f,
         1.622540e+001f,  1.751989e+001f,  1.936644e+001f,  2.251860e+001f,  2.530549e+001f,  2.833891e+001f,  3.124231e+001f,
         4.235039e+001f,  4.462840e+001f,  4.686767e+001f,  5.053357e+001f,  5.546453e+001f,  6.101682e+001f,  6.981119e+001f
      },
      KemarImpulseLeft4,
      KemarImpulseRight4
    },
    {
      {
         1.337592e-001f,  2.761632e-001f,  3.968120e-001f,  4.605694e-001f,  4.559324e-001f,  4.274949e-001f,  4.654225e-001f,
         4.465855e-001f,  3.974667e-001f,  4.221716e-001f,  3.770393e-001f,  2.514178e-001f,  1.590889e-001f,  2.492666e-001f,
         3.347739e-001f,  4.076641e-001f,  4.412268e-001f,  3.470198e-001f,  2.414723e-001f,  1.108812e-001f,  2.118401e-002f,
         1.428967e-002f,  8.564881e-002f,  1.266620e-001f,  1.217435e-001f,  5.712448e-002f,  3.475773e-002f,  3.079471e-002f
      },
      {
         2.502824e-001f,  4.428893e-001f,  5.825083e-001f,  6.308962e-001f,  7.085657e-001f,  9.267583e-001f,  9.638747e-001f,
         9.810586e-001f,  1.140060e+000f,  1.243897e+000f,  1.579500e+000f,  2.344382e+000f,  2.394683e+000f,  1.917987e+000f,
         1.540392e+000f,  1.082793e+000f,  5.741153e-001f,  6.959617e-001f,  9.430776e-001f,  9.366873e-001f,  1.218178e+000f,
         1.833342e+000f,  2.033943e+000f,  7.192378e-001f,  1.767479e+000f,  2.870279e+000f,  8.659582e-001f,  3.723312e-001f
      },
      {
         9.912678e-001f,  9.963487e-001f,  9.938882e-001f,  9.903200e-001f,  9.600061e-001f,  9.923907e-001f,  9.765615e-001f,
         9.697533e-001f,  9.514849e-001f,  8.963590e-001f,  8.511819e-001f,  8.035888e-001f,  6.890041e-001f,  8.801028e-001f,
         9.134347e-001f,  8.937091e-001f,  7.957618e-001f,  6.277516e-001f,  6.554546e-001f,  6.534512e-001f,  6.624642e-001f,
         6.303150e-001f,  5.938157e-001f,  8.282659e-001f,  1.066249e-001f,  3.245954e-001f,  3.809198e-001f,  3.942419e-001f
      },
      {
        -3.026852e-001f, -5.663373e-001f, -8.961913e-001f, -1.324449e+000f, -2.095054e+000f, -2.682424e+000f, -3.199355e+000f,
        -4.069215e+000f, -4.904351e+000f, -6.342136e+000f, -8.063613e+000f, -9.913350e+000f, -1.262810e+001f, -1.473773e+001f,
        -1.622540e+001f, -1.751989e+001f, -1.936644e+001f, -2.251860e+001f, -2.530549e+001f, -2.833891e+001f, -3.124231e+001f,
        -4.235039e+001f, -4.462840e+001f, -4.686767e+001f, -5.053357e+001f, -5.546453e+001f, -6.101682e+001f, -6.981119e+001f
      },
      KemarImpulseLeft5,
      KemarImpulseRight5
    }
  },
  0,
  NULL,
  NULL
};

static const float VastImpulseLeft1[] =
{
  -3.480098e-004f, -1.385612e-004f, -5.785955e-004f, -4.765207e-004f, -1.903690e-003f, -8.041058e-003f, -9.692631e-003f, -8.412877e-003f,
  -8.088132e-003f,  5.267787e-004f,  7.607004e-003f,  5.853831e-003f,  8.583726e-003f,  2.336297e-003f, -7.777735e-003f, -9.505275e-003f,
  -1.833216e-002f, -1.700389e-002f, -1.602503e-002f, -1.555062e-002f, -1.385029e-002f, -1.201534e-002f, -1.039085e-002f, -1.591023e-002f,
  -9.658550e-003f, -1.499949e-002f, -6.254670e-003f, -5.579799e-003f, -5.141956e-003f, -5.999955e-003f, -3.752746e-003f, -5.280951e-003f,
  -8.178975e-003f, -3.355461e-003f, -7.266450e-003f, -5.968699e-003f, -3.535541e-003f, -6.481644e-003f, -2.527510e-003f, -8.849875e-003f,
  -5.351483e-003f, -1.169454e-002f, -3.543332e-003f, -8.786165e-003f, -4.669912e-003f, -3.136656e-003f, -4.439372e-003f, -4.853064e-003f,
  -5.996848e-003f, -5.817985e-003f, -7.177828e-003f, -5.095881e-003f, -5.384627e-003f, -4.800515e-003f, -3.933776e-004f, -7.900731e-003f,
   1.326283e-003f, -8.730996e-003f, -1.365509e-003f, -7.623229e-003f, -4.293250e-003f, -4.570544e-003f, -5.199105e-003f,  5.050148e-004f,
  -6.399546e-003f,  3.263058e-003f, -7.319394e-003f,  1.596328e-004f, -7.579756e-003f, -1.488710e-003f, -2.598844e-003f,  2.716084e-003f,
  -1.461919e-003f,  8.051245e-003f, -1.051166e-002f,  3.207127e-002f, -5.276336e-002f,  5.539832e-001f,  3.796011e-001f,  1.361159e-001f,
   5.819942e-001f, -2.654365e-001f, -3.227713e-001f, -2.250405e-001f, -3.360484e-001f, -2.443359e-001f,  4.532888e-002f,  2.195477e-001f,
   5.263245e-002f,  1.860567e-001f, -7.004846e-002f,  9.570802e-002f, -1.109185e-002f, -1.574482e-001f, -1.024281e-001f,  1.572919e-001f,
   1.414477e-001f, -6.551531e-002f,  4.412056e-002f, -8.205481e-002f, -4.142849e-002f, -7.028174e-002f, -4.997111e-002f, -3.996032e-002f,
   6.924048e-003f,  3.183521e-002f, -5.989302e-003f,  5.060769e-002f,  1.254241e-002f, -3.683495e-002f, -6.347208e-004f, -9.366624e-004f,
  -4.347311e-003f, -3.756099e-002f,  2.887942e-002f, -2.380290e-002f,  2.996977e-003f, -7.108536e-003f,  2.653958e-003f,  2.621515e-002f,
  -6.314341e-003f,  6.384630e-003f, -2.203183e-002f,  1.671217e-002f, -1.752082e-002f, -9.366260e-003f, -6.036146e-003f, -1.158602e-002f,
  -9.870078e-003f,  1.609572e-003f,  8.342424e-003f, -1.295660e-002f,  4.168864e-003f, -2.074037e-002f, -2.460206e-002f, -2.493907e-002f,
  -3.148470e-002f,  9.866247e-004f, -7.062114e-003f,  3.635058e-003f,  1.965747e-002f,  1.778351e-002f,  6.574664e-003f,  1.014366e-002f,
   1.321847e-002f, -1.729767e-002f, -1.227538e-002f, -7.122720e-003f,  6.107424e-003f, -4.367918e-003f, -1.337146e-002f,  7.683369e-003f,
   9.903624e-005f, -1.680723e-003f, -1.376827e-002f,  7.385273e-003f,  2.197156e-003f, -4.472535e-003f, -5.532216e-003f,  2.057544e-003f,
   4.259989e-003f, -4.695800e-003f,  1.356795e-003f, -6.628592e-004f, -5.342849e-003f, -3.855569e-003f, -7.713304e-004f,  3.374469e-003f,
  -8.533655e-003f, -7.038841e-003f, -2.632464e-004f,  7.943522e-004f,  2.071584e-003f, -2.314710e-003f,  2.620030e-003f, -2.650699e-003f,
  -2.587753e-003f,  2.521488e-004f, -4.224827e-003f,  8.773939e-003f,  9.372496e-003f,  1.163866e-002f,  1.651810e-002f,  7.364333e-003f,
   3.009950e-003f, -3.174926e-003f, -7.645159e-003f, -1.413824e-002f, -1.424826e-003f,  2.368240e-003f,  6.974704e-003f,  9.015045e-003f,
   3.630313e-003f,  4.917226e-003f, -3.966273e-003f, -6.242846e-004f, -1.727340e-003f,  8.085912e-003f,  8.338925e-003f,  6.101348e-003f,
   1.377587e-002f,  6.683220e-004f, -2.674362e-003f, -5.330921e-003f, -3.847489e-003f, -3.232213e-003f, -1.114413e-003f,  4.099601e-003f,
   5.038450e-003f,  4.599544e-003f, -1.228663e-003f,  1.273721e-003f,  1.901599e-003f, -2.878539e-003f,  8.267706e-004f, -1.276723e-003f,
   1.831627e-003f, -7.106917e-004f,  6.549362e-004f,  9.276135e-004f, -1.660487e-003f,  7.389122e-004f, -3.760627e-003f,  4.651221e-004f,
  -2.023785e-003f, -3.305624e-003f, -2.868582e-003f, -1.186147e-003f,  2.665149e-003f, -1.069271e-003f,  1.845958e-004f,  1.393009e-003f,
  -2.511376e-003f, -5.101122e-003f, -5.843643e-003f, -5.644478e-003f, -7.123571e-003f, -7.024964e-003f, -6.783779e-003f, -3.052880e-003f,
   2.449211e-003f,  2.796591e-004f, -7.137130e-004f, -2.252075e-004f, -5.038676e-003f, -6.910750e-003f, -8.239798e-003f, -8.486010e-003f,
  -7.531624e-003f, -5.297513e-003f, -2.152726e-003f, -6.181810e-004f, -1.526876e-003f, -3.273917e-003f, -1.399358e-003f, -2.565234e-003f,
  -3.738175e-003f, -4.168086e-003f, -1.556128e-003f, -2.904320e-003f, -4.432416e-003f, -2.037895e-003f,  1.195734e-004f,  8.813178e-003f,
   2.279387e-002f,  3.201563e-002f,  3.112241e-002f,  2.126826e-002f,  1.001361e-002f,  5.782622e-003f,  2.715138e-003f, -1.886949e-004f,
   1.149324e-003f,  6.393793e-003f,  7.994291e-003f,  7.229959e-003f,  2.647044e-003f, -5.880603e-003f, -1.369668e-002f, -1.900422e-002f,
  -2.095235e-002f, -2.096732e-002f, -1.088237e-002f,  4.602758e-004f,  9.250813e-003f,  9.921527e-003f,  6.254499e-003f,  2.570831e-003f,
  -1.095987e-003f, -1.509864e-003f, -2.259217e-003f, -2.106811e-003f, -2.442938e-003f, -5.753140e-004f,  6.006343e-003f,  7.046023e-003f,
   1.967839e-002f,  2.956605e-002f,  3.525814e-002f,  3.007134e-002f,  1.132526e-002f,  2.540978e-003f, -7.018247e-003f, -1.349448e-002f,
  -1.053586e-002f,  2.829442e-003f,  1.083374e-002f,  1.223751e-002f,  1.002269e-002f,  5.520581e-003f,  4.540453e-003f,  5.577917e-003f,
   1.517131e-003f, -8.584783e-003f, -8.334973e-003f, -9.926312e-003f, -9.715057e-003f,  3.435668e-003f, -3.809657e-003f, -5.291782e-003f,
   7.313527e-003f,  1.633336e-002f, -9.690736e-003f,  7.268388e-003f, -2.618348e-003f, -2.181218e-002f, -9.890420e-004f, -1.520540e-002f,
  -3.960131e-003f, -6.020200e-003f, -1.133590e-002f, -1.350046e-002f, -1.524110e-002f, -1.672689e-002f, -3.266624e-003f,  1.030919e-002f,
  -4.660519e-003f, -9.946608e-003f, -3.797052e-003f, -9.070552e-003f, -1.319483e-002f, -1.547630e-002f, -6.406327e-003f, -1.006497e-002f,
  -6.087066e-003f, -2.972508e-003f,  2.080019e-003f,  5.679445e-003f, -4.152279e-003f,  9.851567e-003f, -9.429617e-004f,  4.271790e-003f,
   2.523125e-003f,  1.538391e-003f,  1.232631e-003f, -5.555827e-003f, -1.907756e-003f, -7.924115e-003f,  2.845126e-003f, -3.307291e-003f,
  -1.758426e-004f,  1.061545e-002f,  2.832765e-002f,  4.420471e-002f,  3.114989e-002f,  5.641152e-003f, -2.313044e-002f, -2.373588e-002f,
  -1.503230e-002f, -1.457393e-003f,  3.876726e-003f,  1.527846e-003f,  3.759153e-003f, -2.237134e-003f, -9.826955e-004f, -8.513015e-003f,
  -1.221933e-002f, -1.999607e-002f, -2.239452e-002f, -1.258371e-002f, -3.587978e-003f,  8.127785e-003f,  1.045296e-003f, -3.282155e-003f,
  -1.116080e-002f, -7.776828e-003f, -1.814960e-004f,  1.737594e-003f,  2.651348e-003f, -7.473916e-004f,  3.621380e-004f, -5.191195e-003f,
  -4.508938e-003f, -7.478654e-003f, -4.990853e-003f,  2.075134e-003f, -4.183285e-005f,  1.473890e-003f, -2.309376e-004f,  1.361390e-003f,
   6.818975e-004f,  1.700807e-003f,  4.397541e-003f,  9.712123e-003f,  1.525537e-002f,  1.016784e-002f,  9.152021e-003f,  4.945231e-003f,
   3.941587e-003f,  4.597561e-003f,  4.009221e-003f,  4.228134e-003f,  2.892190e-003f,  5.602226e-003f,  4.118240e-003f,  7.288115e-004f,
  -4.987728e-003f, -9.074888e-003f, -8.912196e-003f, -1.124522e-002f, -8.830368e-003f, -5.290907e-003f, -1.160864e-003f,  1.484380e-003f,
   1.565801e-003f,  9.066803e-004f, -8.212651e-004f,  1.074112e-003f,  5.919990e-003f,  9.120904e-003f,  1.463751e-002f,  1.682314e-002f,
   1.756202e-002f,  1.453291e-002f,  9.710981e-003f,  3.838366e-003f,  1.817062e-003f, -6.838090e-004f, -1.952579e-004f, -1.847961e-003f,
  -3.344954e-003f,  2.505234e-003f, -4.562807e-003f, -3.838944e-003f, -8.450511e-003f, -9.959126e-003f, -9.659551e-003f, -9.528471e-003f,
  -4.677339e-004f,  4.677887e-003f,  2.353427e-003f, -5.816317e-003f, -4.705401e-003f, -1.004914e-003f,  4.054432e-003f,  1.282423e-003f,
  -1.664158e-003f,  2.515196e-003f, -8.607492e-004f, -1.836389e-003f, -8.141857e-003f, -7.806599e-003f, -1.229247e-002f, -1.921556e-002f,
  -9.492841e-003f, -2.303488e-003f,  2.378429e-003f, -7.060429e-003f, -6.960362e-003f, -1.997860e-003f, -1.624586e-003f, -1.498476e-003f,
  -8.896564e-004f,  1.152999e-002f,  1.385147e-002f,  2.311223e-002f,  1.538624e-002f,  4.157096e-003f, -3.050370e-003f, -1.070516e-002f,
  -2.834858e-003f, -4.679216e-004f,  7.926357e-003f,  3.972234e-003f,  7.075478e-003f,  7.109465e-003f,  5.236342e-003f,  7.092363e-003f,
   1.108368e-003f,  4.186488e-003f, -3.729418e-004f, -4.986639e-005f,  3.339917e-003f,  1.057751e-002f,  1.395403e-002f,  5.739766e-003f,
  -4.000709e-003f, -1.441077e-002f, -8.610737e-003f, -1.562842e-003f,  4.487037e-003f,  2.907726e-003f, -5.464700e-004f, -3.627135e-004f,
  -6.449524e-004f,  6.094863e-003f,  4.552768e-003f,  3.384514e-003f, -2.195399e-003f, -1.948572e-003f,  3.294912e-004f,  1.952928e-003f,
   4.539778e-003f,  1.304731e-003f,  1.051150e-003f, -1.947985e-003f, -3.843454e-004f, -4.937722e-004f, -8.544683e-006f, -2.484298e-004f,
  -2.629158e-003f, -3.851857e-004f, -1.936971e-003f,  1.221714e-003f,  1.099519e-003f,  1.029632e-003f,  2.196103e-003f,  1.509556e-003f,
   2.172970e-003f, -3.527035e-004f, -2.021018e-003f, -5.882659e-003f, -3.351599e-003f, -1.299274e-003f,  1.121713e-003f,  5.320722e-003f,
   1.429994e-003f, -1.765667e-003f, -4.993608e-003f, -6.800312e-003f, -6.844194e-003f, -4.993520e-003f, -6.625686e-003f, -9.267049e-003f,
  -9.671674e-003f, -1.055739e-002f, -4.582465e-003f, -6.314963e-003f, -7.368447e-003f, -1.136130e-002f, -8.040475e-003f, -1.576111e-003f,
  -2.172325e-003f, -2.002904e-003f, -5.005424e-003f, -2.299181e-003f, -1.136651e-003f, -5.983075e-003f, -1.250868e-002f, -7.147515e-003f,
  -3.884615e-003f, -4.298971e-003f, -3.137839e-003f, -9.502210e-003f, -1.390544e-002f, -6.071366e-003f, -1.462643e-003f,  1.874722e-003f,
   6.491259e-003f,  8.009711e-003f,  1.195548e-002f,  7.763790e-003f,  1.027847e-003f, -4.355532e-003f, -3.106491e-003f, -1.190421e-003f,
   3.364663e-003f,  6.451858e-003f,  6.429419e-003f,  5.552164e-003f,  4.558645e-003f,  6.095584e-003f,  7.195132e-003f,  5.935000e-003f,
   6.515506e-003f,  4.757994e-003f,  5.182457e-003f,  4.190463e-003f,  1.410244e-003f,  1.212224e-003f, -1.432655e-003f, -1.529757e-004f,
   1.531029e-003f,  4.198377e-003f,  5.780171e-003f,  5.445862e-003f,  6.159367e-003f,  5.047295e-003f,  3.039591e-003f,  5.185090e-003f,
   3.382380e-003f,  3.453757e-004f,  2.429642e-003f,  1.573377e-003f,  3.332293e-003f,  4.417069e-003f,  1.382351e-003f,  3.560712e-003f,
  -1.096767e-003f, -2.170277e-003f, -2.249307e-003f, -5.173690e-003f, -6.539021e-003f, -3.126263e-003f, -5.169155e-003f, -2.542285e-003f,
   2.880301e-004f,  3.834187e-003f,  7.021064e-003f,  1.303725e-003f, -7.878813e-003f,  2.104808e-002f,  4.649189e-002f,  4.369723e-002f,
   2.702861e-002f, -5.871484e-003f, -2.693138e-002f, -5.010447e-002f, -3.818486e-002f, -1.997713e-003f,  2.436050e-002f,  1.222350e-002f,
  -1.129702e-002f, -1.209880e-002f, -2.473757e-003f, -7.896043e-004f, -7.107313e-003f, -1.198760e-002f, -2.001565e-002f, -1.617067e-002f,
  -1.755122e-003f,  1.325690e-002f,  1.921867e-002f,  1.829163e-002f,  2.386425e-002f,  2.994617e-002f,  2.226411e-002f, -2.719817e-003f,
  -2.214421e-002f, -2.567758e-002f, -1.785392e-002f, -9.442479e-003f,  8.505174e-004f,  3.251113e-003f, -2.758171e-003f, -2.950712e-003f,
  -4.824390e-003f, -3.509842e-003f, -6.897769e-003f, -6.279058e-003f, -6.272977e-003f, -7.739448e-005f,  9.491712e-003f,  5.134654e-003f,
   4.094684e-003f, -5.895389e-003f, -9.750659e-003f, -7.430598e-003f, -3.480615e-003f, -3.168147e-003f, -4.150668e-003f, -4.664104e-003f,
  -9.676712e-003f, -2.127917e-003f, -6.573837e-003f, -6.433275e-003f, -8.348643e-003f, -9.809144e-003f, -7.006294e-003f, -4.842275e-003f,
  -3.080290e-003f, -3.124122e-003f,  9.214438e-003f,  1.263970e-002f,  1.282911e-002f,  5.747048e-003f,  5.969672e-003f, -8.393515e-004f,
  -1.275603e-002f, -1.449678e-002f, -1.022603e-002f, -1.919197e-003f, -7.219529e-003f, -7.733721e-003f, -2.550192e-003f,  7.085115e-003f,
   1.332551e-002f,  2.491380e-002f,  2.459724e-002f,  2.143003e-002f,  1.299736e-002f,  6.685655e-003f,  5.426022e-003f, -4.852473e-003f,
  -1.250353e-003f,  1.075887e-003f,  7.129981e-003f,  1.667089e-003f, -1.360531e-003f, -2.990867e-003f, -4.642371e-003f, -6.366874e-003f,
  -7.884421e-003f, -4.228995e-003f, -2.153883e-003f,  5.562127e-003f,  1.334213e-002f,  1.249207e-002f,  7.489213e-003f, -2.394686e-003f,
  -4.903310e-003f, -2.065380e-003f,  2.163497e-003f, -9.762001e-004f, -2.801935e-003f, -1.056422e-002f, -1.146225e-002f, -4.184225e-003f,
   3.556911e-003f,  1.531824e-002f,  5.016942e-003f, -6.758864e-003f, -2.060457e-002f, -1.411491e-002f,  1.010517e-002f,  3.323200e-002f,
   3.223342e-002f,  5.844176e-003f, -2.397877e-002f, -3.201550e-002f, -1.189995e-002f,  1.065328e-002f,  1.166377e-002f,  1.162804e-003f,
  -1.554740e-002f, -1.607595e-002f, -6.620658e-003f, -9.671792e-004f, -3.476080e-003f, -1.495370e-002f, -1.232202e-002f, -6.394503e-003f,
   5.993651e-004f, -5.659640e-003f, -1.132631e-002f, -1.692402e-002f, -1.700140e-002f,  2.876984e-003f,  2.918795e-005f, -2.397195e-003f,
  -5.566198e-003f, -1.012363e-002f, -2.132952e-003f,  3.179064e-003f,  6.304983e-003f,  5.266425e-003f, -1.995495e-003f, -7.593126e-004f,
   1.938945e-002f,  2.433314e-002f,  2.614908e-002f,  1.277196e-002f,  6.751997e-005f, -1.488852e-002f, -2.054141e-002f, -1.294987e-002f,
  -7.933016e-003f, -5.176559e-003f, -7.749480e-003f,  2.621360e-003f,  9.532255e-003f,  2.086618e-002f,  1.662690e-002f,  9.585351e-003f,
  -2.616685e-003f, -6.962415e-003f, -3.262193e-003f, -1.081907e-003f,  2.017838e-003f, -5.557060e-003f, -3.724293e-003f, -6.537878e-004f,
   3.081035e-003f,  1.063272e-002f,  1.083288e-002f,  1.101158e-002f,  7.918454e-003f,  8.914020e-003f,  2.337007e-003f,  1.726984e-002f,
   4.518665e-002f,  4.965799e-002f,  5.049472e-002f,  5.296045e-003f, -1.055505e-002f, -2.466904e-002f, -1.914149e-002f, -1.683121e-003f,
   5.340539e-003f,  1.526690e-002f, -8.855211e-003f,  3.017454e-004f, -1.819600e-002f, -1.015333e-002f, -6.268346e-003f, -6.786574e-003f,
   1.481443e-003f, -6.583935e-003f,  1.319767e-002f,  9.717386e-003f,  1.558433e-002f, -3.690364e-003f, -4.587106e-003f, -1.028352e-003f,
  -6.574178e-003f, -2.899465e-003f, -1.628501e-002f, -4.180475e-003f, -1.217743e-002f, -8.895445e-003f, -1.599614e-002f, -1.575077e-002f,
   1.146018e-003f, -3.261984e-003f,  2.551115e-003f, -1.035568e-002f, -5.258217e-003f, -7.738996e-003f, -1.091618e-003f,  5.209540e-003f,
   8.073657e-003f,  2.113775e-002f,  9.112544e-003f,  8.219035e-003f, -5.932317e-003f, -7.020483e-003f, -9.904678e-003f, -1.363728e-002f,
  -1.335399e-003f,  4.411168e-003f,  2.524877e-002f,  2.796144e-002f,  2.201193e-002f,  4.996831e-003f, -5.597258e-003f, -1.870385e-002f,
  -2.118208e-002f, -3.165283e-003f,  9.956775e-003f,  2.285735e-002f,  1.189789e-002f,  6.056841e-003f, -7.457853e-003f, -8.609511e-003f,
  -3.340516e-003f, -5.051646e-003f, -5.629956e-003f, -1.123899e-002f, -1.974615e-004f,  9.462738e-003f,  9.312271e-003f,  2.411789e-003f,
  -1.031169e-002f, -1.407702e-002f, -1.712757e-002f, -6.446459e-003f, -2.080787e-003f, -1.446603e-004f, -2.885294e-003f, -6.884294e-003f,
   3.556827e-004f,  1.186077e-003f,  3.631700e-003f, -2.822231e-003f, -2.006443e-003f,  6.216313e-003f,  1.626661e-002f,  2.917015e-002f,
   2.919096e-002f,  1.371082e-002f, -5.681566e-003f, -1.748967e-002f, -2.045860e-002f, -1.503597e-002f, -6.102344e-003f, -3.637922e-003f,
   7.156793e-004f,  9.284270e-003f,  1.191137e-002f,  9.135630e-003f, -5.923455e-004f, -1.000016e-002f, -1.080695e-002f, -2.786031e-003f,
   1.592053e-003f,  8.115871e-003f,  1.849646e-002f,  2.421513e-002f,  2.633475e-002f,  1.804213e-002f, -3.759278e-005f, -1.252312e-002f,
  -1.329006e-002f, -9.355280e-003f, -3.069901e-003f, -1.521297e-003f, -1.719576e-003f,  1.399722e-003f,  1.380539e-003f, -5.560709e-003f,
  -1.116585e-002f, -1.245707e-002f, -8.741699e-003f, -6.868324e-003f, -2.392899e-003f, -3.349530e-003f, -6.836914e-003f, -1.281584e-002f,
  -1.463374e-002f, -9.508638e-003f, -3.125790e-003f, -2.253127e-003f, -5.707657e-003f, -7.191689e-003f, -8.511537e-004f, -6.099223e-004f,
   2.133227e-004f,  1.581879e-003f, -3.158057e-003f,  1.869993e-003f,  2.929213e-003f,  7.994749e-004f, -1.158999e-004f,  2.856257e-003f,
   4.751645e-003f,  1.006164e-002f,  8.484090e-003f,  3.244495e-003f,  3.201845e-003f, -6.035891e-006f,  2.291713e-004f, -1.107425e-004f,
  -1.479977e-003f, -7.300160e-003f, -1.669175e-002f, -1.344562e-002f, -7.699610e-003f,  1.576860e-004f, -2.703301e-003f, -2.824953e-003f,
  -3.315456e-003f,  5.464970e-003f,  1.904685e-002f,  2.291541e-002f,  2.024488e-002f,  6.002588e-003f, -1.100561e-003f, -7.681356e-004f,
   6.069497e-003f,  3.264641e-003f, -1.624882e-003f, -8.380032e-003f, -1.411298e-002f, -6.844290e-003f, -9.925453e-004f,  4.293844e-003f,
   3.222064e-003f,  1.368315e-003f, -3.921032e-003f, -8.115034e-003f, -1.095698e-002f, -1.269907e-002f, -8.725203e-003f, -5.514165e-003f,
   2.736548e-003f,  6.259580e-003f,  6.349918e-003f,  3.077092e-003f, -3.623243e-003f, -3.811154e-003f, -8.863625e-003f, -5.386152e-003f,
  -2.577359e-003f, -5.456821e-004f, -1.885803e-003f, -8.374008e-003f, -8.630391e-003f, -1.181691e-002f, -9.243410e-003f, -1.010275e-002f
};

static const float VastImpulseRight1[] =
{
  -9.425826e-005f,  6.616779e-005f, -1.100457e-004f,  8.904754e-005f, -1.072724e-004f,  9.168382e-005f, -1.171015e-004f,  9.919523e-005f,
  -1.409664e-004f,  8.476379e-005f, -1.873483e-004f,  2.220883e-005f, -3.195359e-004f, -2.039320e-004f, -1.870228e-003f, -2.918860e-003f,
  -3.072169e-003f, -3.390270e-003f, -2.782252e-003f,  3.446587e-005f,  7.117085e-004f,  2.045732e-003f,  2.114950e-003f, -3.624785e-004f,
  -1.162663e-003f, -4.176042e-003f, -6.728463e-003f, -6.747275e-003f, -7.907395e-003f, -7.351195e-003f, -6.793452e-003f, -6.482896e-003f,
  -6.305883e-003f, -5.657889e-003f, -6.857803e-003f, -6.735359e-003f, -5.176604e-003f, -5.515004e-003f, -4.526726e-003f, -3.880237e-003f,
  -3.401378e-003f, -3.722215e-003f, -3.541927e-003f, -3.868414e-003f, -3.874779e-003f, -4.158833e-003f, -4.888140e-003f, -4.928714e-003f,
  -4.645965e-003f, -5.899533e-003f, -5.194402e-003f, -6.166920e-003f, -4.734855e-003f, -5.732609e-003f, -4.050295e-003f, -4.702392e-003f,
  -3.380102e-003f, -4.269104e-003f, -3.763733e-003f, -4.540954e-003f, -3.301295e-003f, -4.404146e-003f, -3.063096e-003f, -3.483532e-003f,
  -2.725886e-003f, -3.003575e-003f, -2.073826e-003f, -4.264655e-003f, -2.182316e-003f, -4.853157e-003f, -2.957030e-003f, -4.617156e-003f,
  -2.255561e-003f, -3.515330e-003f, -1.293710e-003f, -2.957167e-003f, -1.353874e-003f, -2.524375e-003f, -1.309328e-003f, -3.240731e-003f,
  -1.126098e-004f, -3.739274e-003f,  2.108798e-003f, -5.506160e-003f,  7.613062e-003f, -1.486856e-002f,  8.711053e-002f,  1.688075e-001f,
   4.323065e-002f,  1.839338e-001f,  1.115861e-001f, -4.959827e-002f, -3.179425e-002f, -9.906949e-002f, -9.162086e-002f, -5.980906e-002f,
  -5.968784e-002f,  4.596103e-002f,  7.035081e-002f,  1.936383e-002f,  3.832211e-002f,  4.594383e-002f, -2.218013e-002f, -1.998648e-002f,
  -1.528041e-002f, -4.373536e-003f,  5.569748e-002f,  2.859600e-002f,  2.776686e-002f,  1.849577e-002f,  2.814226e-004f, -2.477902e-002f,
  -2.367042e-002f, -2.324031e-002f, -2.812198e-002f, -1.355809e-002f, -1.635205e-002f,  5.789032e-003f,  1.489505e-002f,  2.606761e-003f,
   6.356865e-003f, -4.029882e-003f, -5.023325e-003f, -1.354503e-002f, -4.031042e-003f, -2.763343e-003f,  2.932075e-003f,  3.613855e-003f,
   1.562928e-004f,  5.873785e-003f,  2.191934e-003f,  3.636675e-004f, -4.959756e-003f, -7.931339e-003f, -9.952645e-003f, -9.693582e-003f,
  -7.976899e-003f, -1.445005e-002f, -2.403460e-003f, -2.514161e-003f,  9.156522e-005f,  2.996281e-003f,  5.869832e-004f, -1.383041e-003f,
  -8.434000e-003f, -1.125990e-002f, -8.088460e-003f, -2.621143e-003f, -8.840445e-003f, -7.577378e-004f,  5.687327e-003f,  1.419280e-003f,
   3.706378e-003f,  2.428946e-003f,  1.398976e-003f, -4.353630e-003f, -1.006245e-002f, -4.319189e-003f, -3.100939e-003f, -3.463835e-003f,
  -4.507996e-003f,  1.749905e-003f, -1.847958e-005f, -4.888594e-004f, -7.899573e-004f,  7.455954e-004f,  1.409014e-003f, -2.039858e-003f,
  -1.093731e-003f,  1.075897e-003f,  1.280058e-003f,  1.273280e-003f,  1.721201e-003f,  2.237030e-003f, -5.453162e-004f, -1.015451e-003f,
  -1.866212e-003f, -1.588212e-003f, -3.854691e-003f, -3.188660e-003f, -1.006334e-003f, -3.973061e-004f,  1.278205e-003f,  1.563653e-003f,
   9.480089e-004f, -1.566624e-003f, -9.567683e-004f, -1.669309e-003f, -1.300094e-003f,  1.626456e-003f,  1.813935e-003f,  5.656316e-003f,
   5.088572e-003f,  2.743312e-003f,  2.429848e-003f, -3.162002e-004f, -3.136008e-003f, -3.699323e-003f, -2.791932e-003f, -3.982719e-004f,
   1.898857e-003f,  2.016325e-003f,  4.386045e-003f,  5.018647e-003f,  3.504238e-003f,  3.956260e-003f,  4.366855e-003f,  3.219293e-003f,
   7.236933e-004f,  1.117105e-004f,  1.438293e-004f, -1.860590e-003f, -1.337128e-003f, -1.884212e-003f, -2.195660e-004f, -1.060450e-003f,
  -2.020313e-003f, -1.968349e-004f,  5.516331e-004f, -1.253764e-004f,  3.440840e-004f,  3.133912e-003f,  4.117543e-003f,  5.785497e-003f,
   4.837451e-003f,  2.848269e-003f,  1.753120e-003f, -1.356054e-003f, -2.346630e-003f, -3.372076e-003f, -2.550575e-003f, -2.570015e-003f,
  -2.989697e-003f, -1.809807e-003f, -2.085215e-003f, -1.669710e-003f, -3.433810e-003f, -2.786520e-003f, -4.601255e-003f, -6.755036e-003f,
  -5.410991e-003f, -3.827005e-003f, -1.771642e-003f, -1.661238e-003f, -7.316570e-004f, -4.979644e-004f, -7.832972e-005f, -1.368180e-003f,
  -3.727749e-003f, -4.889175e-003f, -7.114242e-003f, -6.537846e-003f, -4.505444e-003f, -3.208853e-003f, -2.186957e-003f, -1.782774e-003f,
  -6.329440e-004f, -1.149419e-004f,  2.064697e-004f, -5.605330e-004f,  1.629753e-004f, -1.963734e-004f, -6.287901e-004f,  6.412798e-004f,
   8.960689e-004f,  1.013105e-003f,  2.283672e-003f,  9.077912e-003f,  1.628289e-002f,  1.783938e-002f,  1.767395e-002f,  1.291843e-002f,
   6.344620e-003f,  1.974998e-003f, -4.280097e-004f, -1.482670e-003f, -1.634384e-003f, -6.209097e-004f,  3.121500e-003f,  7.025459e-003f,
   6.175810e-003f,  2.803363e-003f, -1.325805e-003f, -6.884389e-003f, -1.163663e-002f, -1.345771e-002f, -1.006806e-002f, -3.465910e-003f,
   2.563513e-003f,  7.173965e-003f,  7.614677e-003f,  6.696038e-003f,  3.518256e-003f,  7.636033e-004f, -1.691008e-003f, -3.027508e-003f,
  -2.814181e-003f, -1.210239e-003f,  2.385788e-003f,  4.249596e-003f,  4.609249e-003f,  3.155871e-003f, -1.676136e-004f, -2.410126e-003f,
  -3.822113e-003f, -3.757523e-003f, -3.448472e-003f, -1.867627e-003f, -1.362961e-003f, -1.211277e-003f, -1.201829e-003f, -1.455855e-003f,
  -2.067926e-003f, -3.304940e-003f, -4.408274e-003f, -4.749945e-003f, -4.448832e-003f, -3.845795e-003f, -2.675373e-003f,  3.492750e-004f,
   3.964102e-003f,  7.715830e-003f,  9.602611e-003f,  9.550049e-003f,  8.152571e-003f,  4.728492e-003f,  2.364873e-003f,  1.446631e-003f,
  -2.204295e-004f,  1.342786e-003f,  2.782909e-003f,  8.050972e-003f,  8.163127e-003f,  5.347697e-003f,  7.838077e-003f,  1.356571e-003f,
  -1.679593e-003f, -4.549935e-003f, -4.637194e-003f, -6.028813e-003f, -7.557611e-003f, -6.611729e-003f, -6.930193e-003f, -6.119652e-003f,
  -6.429397e-003f, -3.245662e-003f, -1.130528e-003f, -2.932497e-003f, -5.157000e-003f, -5.913087e-003f, -3.681538e-003f, -5.902063e-003f,
  -4.141588e-003f, -5.961879e-003f, -7.347766e-003f, -6.579483e-003f, -4.983840e-003f, -2.264325e-003f, -1.842695e-003f, -8.314661e-005f,
  -2.504719e-003f, -1.565107e-003f,  1.774183e-003f,  4.731290e-003f,  1.419044e-002f,  2.610197e-002f,  2.873778e-002f,  1.469628e-002f,
  -4.071437e-003f, -2.142637e-002f, -2.306541e-002f, -1.605518e-002f, -8.648883e-003f, -5.333585e-004f,  3.276069e-003f,  4.349338e-003f,
   3.234852e-003f,  4.999281e-004f, -5.600713e-003f, -1.052463e-002f, -1.485317e-002f, -1.290729e-002f, -6.118992e-003f,  1.925282e-003f,
   6.817489e-003f,  3.365444e-003f, -2.265249e-003f, -6.011673e-003f, -5.000078e-003f, -4.075195e-003f, -2.343689e-003f, -2.398785e-003f,
  -3.588497e-003f, -2.090667e-003f, -3.183565e-003f,  8.097097e-004f,  1.564704e-003f,  3.591697e-003f,  4.252905e-003f,  5.176278e-003f,
   5.687869e-003f,  6.782414e-004f,  2.196622e-002f,  6.912849e-002f,  6.437941e-002f,  7.280722e-002f,  1.135784e-002f, -6.407349e-003f,
  -2.389096e-002f, -4.760356e-002f, -3.274695e-002f, -1.133611e-002f,  4.566562e-002f,  1.340449e-002f,  4.768403e-003f, -2.714360e-002f,
  -2.015364e-002f, -9.659426e-003f, -1.614678e-004f,  4.798920e-003f, -1.611963e-003f,  7.354242e-003f, -6.735190e-003f, -1.357734e-003f,
  -2.710885e-003f, -5.617648e-003f, -4.971476e-003f, -1.432956e-002f, -1.154087e-002f, -1.525537e-002f,  5.143650e-003f,  3.024163e-003f,
  -6.253617e-003f, -6.466410e-003f, -1.334011e-002f,  3.571903e-003f, -5.004107e-003f,  4.729611e-004f, -9.196817e-003f, -3.567550e-003f,
   8.509365e-005f, -2.366943e-003f,  6.157313e-003f,  1.501385e-003f,  3.832204e-003f, -3.521140e-003f, -2.221883e-003f, -4.799148e-003f,
  -7.186067e-003f, -5.442242e-004f, -1.074316e-002f, -1.731675e-003f, -2.372674e-003f, -3.421302e-003f,  9.075750e-003f,  3.729333e-004f,
  -7.887095e-004f, -1.417529e-002f, -8.074957e-003f, -8.354862e-003f, -2.459384e-003f,  2.371098e-003f, -1.318528e-003f,  1.138562e-002f,
   3.412887e-003f,  2.491732e-003f, -9.184992e-003f, -6.287523e-004f,  3.080848e-003f,  2.310364e-003f,  2.250441e-003f, -2.076472e-003f,
   5.295712e-003f,  6.529968e-004f,  1.065674e-003f, -5.292768e-003f, -6.605616e-003f, -3.080181e-003f, -4.681293e-003f,  1.978280e-003f,
   1.008808e-004f,  7.794800e-004f,  1.538635e-003f,  8.882210e-003f,  1.354837e-002f,  1.509274e-002f,  2.621140e-002f,  2.018289e-002f,
   2.378810e-002f,  5.417351e-003f,  1.138083e-003f, -3.225893e-003f, -3.321632e-003f,  1.170990e-003f, -5.199837e-003f,  1.367483e-002f,
   1.675449e-002f,  2.668064e-002f,  8.425313e-003f, -9.917736e-003f, -1.896151e-002f, -1.580530e-002f, -9.881777e-004f, -2.849560e-004f,
   4.132186e-003f,  2.872911e-004f,  4.588909e-003f,  3.830192e-003f,  2.365246e-003f,  3.887450e-004f, -5.397566e-003f, -6.759040e-003f,
  -1.032009e-002f, -4.875841e-003f, -2.116048e-003f,  4.136235e-003f,  3.197588e-003f, -2.513260e-003f, -3.812202e-003f, -4.864810e-003f,
  -1.131553e-003f, -3.974859e-003f, -6.737590e-003f, -7.706752e-003f, -3.796317e-003f, -1.231349e-003f, -2.531011e-003f, -4.021243e-003f,
  -4.508307e-003f, -2.113889e-003f, -1.284051e-003f, -7.498387e-004f, -2.324348e-003f, -2.726761e-003f, -5.833994e-003f, -6.205138e-003f,
  -1.779353e-003f,  1.158530e-003f,  4.626294e-003f, -1.121713e-003f, -4.408675e-003f, -5.633235e-003f, -2.114433e-003f,  1.907226e-003f,
  -4.598686e-004f, -3.255828e-003f, -4.714138e-003f, -3.013592e-003f,  1.719241e-003f,  1.363636e-002f,  2.795202e-002f,  3.991978e-002f,
   3.291107e-002f,  1.208271e-002f, -1.021038e-002f, -2.283135e-002f, -1.879423e-002f, -1.179569e-002f, -1.272208e-003f,  3.820492e-003f,
   4.990929e-003f,  3.837207e-003f, -3.943076e-005f, -3.203257e-003f, -9.187559e-003f, -7.957606e-003f,  2.992155e-004f,  4.212724e-003f,
   8.154239e-003f,  6.780591e-003f,  6.463680e-004f, -5.344396e-003f, -8.966923e-003f, -1.015653e-002f, -1.110237e-002f,  4.115134e-004f,
   5.619623e-003f,  7.524645e-003f,  6.310826e-003f,  2.389433e-003f, -8.927522e-004f, -2.132378e-003f, -3.531057e-003f, -7.586911e-003f,
  -4.537287e-003f, -4.762270e-003f, -1.086237e-003f, -4.126143e-005f, -6.945636e-004f, -3.183255e-003f, -5.063108e-003f, -4.227836e-003f,
  -5.982353e-003f, -2.733901e-003f, -3.578860e-003f, -1.826610e-003f, -3.308035e-005f, -2.478144e-003f,  7.703392e-004f, -4.498539e-003f,
  -1.634503e-003f,  2.063077e-003f,  5.915095e-004f, -8.262305e-004f,  1.309327e-003f, -1.160361e-003f,  5.538192e-003f,  3.704331e-003f,
   1.129068e-003f,  7.593574e-003f, -3.158329e-003f, -4.678013e-003f, -2.147930e-003f, -2.044004e-003f,  1.573997e-003f, -1.244916e-003f,
  -8.377785e-004f,  5.509191e-003f, -3.012212e-003f, -4.264108e-003f, -2.090123e-003f, -5.242522e-003f, -5.802170e-003f, -3.316741e-003f,
  -2.501717e-003f,  1.942690e-002f,  2.693505e-002f,  2.754587e-002f,  1.184239e-002f, -4.570487e-003f, -7.423234e-003f, -2.283494e-002f,
  -9.960883e-003f,  1.471935e-002f,  1.947216e-002f, -6.674390e-004f, -5.587875e-003f, -1.396133e-003f, -1.470211e-003f,  3.775210e-004f,
  -7.717539e-003f, -1.069949e-002f, -9.217913e-003f,  1.315533e-005f,  1.185266e-002f,  1.958836e-002f,  2.233218e-002f,  1.519618e-002f,
   6.860711e-003f, -2.205688e-003f, -7.038145e-003f, -8.519212e-003f, -9.802746e-003f, -9.561379e-003f, -6.640595e-003f, -7.458339e-004f,
   4.249955e-003f,  6.847249e-003f,  4.053891e-003f, -3.195957e-003f, -4.255088e-003f, -3.189802e-003f, -8.997346e-004f, -4.573556e-005f,
   6.326514e-004f, -2.549979e-003f, -3.411059e-003f, -4.017377e-003f, -4.203306e-003f,  8.692362e-004f,  7.703599e-003f,  8.172526e-003f,
   1.013443e-002f,  8.506341e-003f,  2.493607e-003f, -3.713936e-003f, -8.560527e-003f, -1.111025e-002f, -6.716491e-003f, -4.810841e-004f,
   9.287923e-004f,  2.405005e-003f,  5.757606e-003f,  8.129968e-003f,  3.057392e-003f,  5.733737e-003f,  2.218021e-003f, -2.326483e-003f,
  -4.180046e-003f, -2.530374e-003f,  6.272107e-003f,  6.754450e-003f, -1.212046e-003f, -2.937928e-003f, -1.544625e-003f, -5.780796e-003f,
  -1.253977e-002f, -1.558520e-002f, -1.548275e-002f, -1.323653e-002f, -1.334604e-002f, -9.795822e-003f, -5.253087e-003f,  6.227105e-004f,
   4.310900e-003f,  2.868428e-003f,  2.943973e-003f,  1.625852e-003f,  3.774293e-003f,  4.777176e-003f,  2.254709e-003f, -3.122231e-003f,
  -5.210861e-003f, -5.533020e-003f, -7.623342e-003f, -7.800625e-003f, -6.415791e-003f, -4.717219e-003f, -4.170348e-003f, -5.103504e-003f,
  -5.734589e-003f, -3.477197e-003f, -1.090475e-004f,  6.675409e-004f,  1.085198e-003f,  3.144856e-004f, -1.623663e-003f, -2.227144e-003f,
  -7.230352e-004f,  6.007492e-003f,  7.014660e-003f,  1.682065e-002f,  6.633051e-003f, -1.059353e-002f, -1.356886e-002f, -2.038045e-002f,
  -1.205905e-003f,  1.415431e-002f,  2.497985e-002f,  1.661445e-002f,  1.680626e-003f, -1.050039e-002f, -1.612428e-002f, -7.736436e-003f,
  -4.554609e-003f,  2.823420e-003f, -5.871795e-003f, -1.978950e-003f,  2.827857e-003f,  3.509747e-003f,  6.231951e-003f, -2.958205e-004f,
  -1.024095e-003f, -6.092046e-003f,  1.482318e-003f, -1.955006e-003f, -6.134571e-003f,  1.121848e-002f,  3.160678e-002f,  3.341525e-002f,
   1.636587e-002f, -1.149872e-003f, -1.178816e-002f, -2.190232e-002f, -3.655811e-002f, -9.010702e-003f,  1.414090e-002f,  9.270342e-003f,
   1.299724e-002f,  3.767733e-002f,  5.456098e-002f,  5.105040e-002f,  3.162403e-002f, -5.776132e-003f, -1.547152e-002f, -1.416034e-002f,
  -1.845814e-002f, -1.707987e-002f, -1.025895e-002f, -6.560037e-003f, -5.333793e-003f,  6.423245e-003f,  1.509504e-002f,  9.233545e-003f,
  -6.989801e-003f, -2.082963e-002f, -2.009976e-002f, -1.280433e-002f, -2.904677e-003f,  3.007400e-003f,  6.017519e-003f,  6.200286e-003f,
   6.394397e-003f,  3.101357e-003f,  2.384645e-003f,  1.209916e-003f, -5.327937e-003f, -6.446292e-004f,  4.212674e-003f,  6.052362e-003f,
   5.728605e-003f, -1.381310e-003f, -1.193556e-002f, -1.857854e-002f, -1.848983e-002f, -1.400612e-002f, -6.425959e-003f, -2.207022e-003f,
   2.488595e-003f,  1.102593e-002f,  1.669805e-002f,  1.959747e-002f,  1.432826e-002f,  4.713574e-003f, -5.201374e-004f,  3.956734e-003f,
   4.752607e-003f, -8.872475e-004f, -1.160585e-002f, -9.094740e-003f, -1.157170e-003f,  1.028196e-003f, -3.355672e-003f, -4.645041e-003f,
  -3.378581e-003f, -1.391349e-003f,  8.086678e-003f,  1.023136e-002f,  1.530635e-002f,  9.349386e-003f,  5.274212e-003f,  3.911121e-003f,
  -3.325870e-004f,  1.356946e-004f, -6.167720e-003f, -1.074285e-002f, -1.099897e-002f, -6.530234e-003f, -8.084217e-004f, -7.444729e-004f,
   2.424027e-003f, -9.743559e-004f, -3.938132e-003f, -5.105782e-003f, -4.798640e-003f, -6.995721e-003f, -1.662002e-003f,  1.145246e-002f,
   2.391312e-002f,  3.291821e-002f,  1.424875e-002f,  1.454179e-003f, -9.912500e-003f, -1.781797e-002f, -7.389766e-003f,  6.157999e-003f,
   1.340184e-002f,  6.792184e-003f, -3.226463e-004f, -1.264094e-002f, -1.260476e-002f, -1.405039e-002f, -1.236599e-002f, -7.838052e-003f,
  -6.022691e-003f,  2.639444e-003f,  3.018098e-003f,  7.461685e-003f,  1.052752e-004f, -1.876039e-003f,  1.217095e-003f,  3.611730e-003f,
   1.068549e-002f,  5.363835e-003f, -3.057025e-003f, -8.374062e-003f, -1.022964e-002f, -1.101414e-002f, -5.946426e-003f,  2.006321e-004f,
  -2.858846e-003f, -2.467083e-003f, -1.331008e-003f,  5.245284e-004f,  4.271083e-003f,  2.579684e-003f, -4.805535e-003f, -1.189540e-002f,
  -9.882396e-003f, -1.008906e-002f, -8.378453e-003f, -6.132548e-003f, -3.979636e-003f, -2.357911e-003f, -2.237999e-003f,  3.705580e-004f,
  -3.521531e-003f, -6.328813e-003f, -5.124452e-003f, -1.479488e-003f,  2.145498e-003f,  3.582078e-003f,  2.565887e-003f, -1.042768e-003f,
  -1.835324e-003f, -4.528994e-003f, -5.196200e-003f,  1.653470e-004f,  3.762344e-003f,  1.167561e-002f,  1.694077e-002f,  1.795353e-002f,
   1.606443e-002f,  1.109777e-002f,  6.737662e-003f,  4.950920e-003f,  3.074996e-003f, -2.669256e-003f, -5.948311e-003f, -4.616186e-003f,
  -2.081613e-003f, -5.275973e-004f, -2.121258e-003f, -2.964895e-003f, -4.908949e-003f, -5.696769e-003f, -3.688917e-003f, -7.845459e-004f,
   7.606762e-003f,  1.023164e-002f,  1.199153e-002f,  1.176133e-002f,  1.200235e-002f,  7.472409e-003f,  6.771260e-004f, -1.545542e-003f,
  -3.784999e-003f, -2.545717e-003f, -6.655736e-003f, -8.702795e-003f, -5.450038e-003f,  1.304360e-003f,  5.630628e-003f,  9.164895e-004f,
  -5.794262e-004f, -2.637979e-003f, -2.356995e-003f, -2.163361e-003f, -3.611858e-003f, -7.436876e-004f, -4.200000e-004f,  1.318194e-003f,
   4.508161e-003f,  7.610564e-003f,  3.216428e-003f, -6.869788e-003f, -1.534132e-002f, -1.704274e-002f, -9.172295e-003f, -1.828904e-003f,
   5.622878e-003f,  5.214712e-003f,  1.660263e-003f, -8.976869e-004f, -2.028698e-003f,  3.803651e-004f, -8.960388e-004f, -2.653160e-003f,
  -3.293046e-003f, -8.902246e-004f, -1.708794e-003f,  4.699806e-004f,  4.306851e-003f,  3.432795e-003f, -1.343117e-003f, -5.652824e-003f,
  -4.127518e-003f, -2.198738e-003f, -2.735688e-003f, -4.623329e-003f, -1.006583e-002f, -1.129411e-002f, -5.070045e-003f, -1.602768e-003f,
   3.670825e-004f,  3.110136e-004f, -1.333053e-004f, -7.542883e-004f, -4.641735e-003f, -2.115751e-003f,  3.777400e-003f,  7.085805e-003f,
   1.042458e-002f,  9.647515e-003f,  1.027984e-002f,  5.083776e-003f, -2.806242e-003f, -6.567234e-003f, -7.280463e-003f, -4.361973e-003f
};

static const float VastImpulseLeft2[] =
{
   6.826828e-005f, -4.202022e-005f,  5.738742e-005f, -4.813978e-005f,  5.064329e-005f, -5.327138e-005f,  6.652424e-005f, -4.365462e-005f,
   8.560401e-005f, -1.595059e-005f,  4.139232e-005f, -7.529171e-005f, -6.436691e-006f, -1.555043e-004f, -1.569660e-004f, -6.293824e-004f,
  -2.370362e-003f, -3.583997e-003f, -3.647151e-003f, -3.752488e-003f, -2.192337e-003f,  2.539592e-004f,  8.973776e-004f,  2.164715e-003f,
   1.438216e-003f, -1.013244e-003f, -2.720711e-003f, -5.338704e-003f, -7.011504e-003f, -7.353889e-003f, -8.286744e-003f, -8.609986e-003f,
  -8.623344e-003f, -8.041087e-003f, -8.352482e-003f, -7.578687e-003f, -8.422400e-003f, -7.611941e-003f, -6.400786e-003f, -5.905903e-003f,
  -5.590073e-003f, -4.843232e-003f, -4.892914e-003f, -5.092035e-003f, -4.804131e-003f, -4.689329e-003f, -5.630770e-003f, -5.084360e-003f,
  -6.708481e-003f, -5.825256e-003f, -7.052200e-003f, -6.627143e-003f, -7.994665e-003f, -6.811149e-003f, -6.952447e-003f, -6.325547e-003f,
  -5.441318e-003f, -5.078086e-003f, -5.216204e-003f, -4.849196e-003f, -5.238617e-003f, -4.592145e-003f, -4.663327e-003f, -3.996407e-003f,
  -4.540010e-003f, -3.153464e-003f, -4.316671e-003f, -2.856818e-003f, -4.143369e-003f, -3.986005e-003f, -4.418718e-003f, -4.714118e-003f,
  -4.400247e-003f, -4.702702e-003f, -3.601426e-003f, -3.818405e-003f, -2.637571e-003f, -2.886538e-003f, -2.565475e-003f, -2.765043e-003f,
  -2.952870e-003f, -2.204517e-003f, -1.802044e-003f, -2.327577e-003f, -5.074347e-005f, -3.892308e-003f,  4.676558e-003f, -7.665910e-003f,
   1.385555e-001f,  1.588312e-001f,  9.673901e-002f,  1.806885e-001f,  7.132337e-002f, -4.167721e-002f, -4.398597e-002f, -9.965422e-002f,
  -9.563979e-002f, -4.475543e-002f,  9.037091e-003f,  2.021372e-002f,  3.588121e-002f,  1.047460e-002f,  1.996161e-002f,  5.919404e-002f,
   3.312601e-004f, -1.426869e-002f,  6.997188e-004f,  5.096312e-002f,  3.009592e-002f,  3.742979e-002f,  2.105219e-002f, -3.938232e-003f,
  -2.240118e-003f, -2.289534e-002f, -1.770540e-002f, -3.190443e-002f, -2.216228e-002f, -2.944878e-002f, -1.683323e-002f,  3.672218e-003f,
  -2.327577e-003f,  1.747169e-003f, -3.171355e-003f,  3.691649e-003f, -4.327651e-003f, -3.265101e-003f, -3.488065e-003f, -5.700728e-003f,
   1.641799e-003f, -2.036513e-004f,  9.909160e-003f,  3.234693e-003f,  3.113898e-003f, -4.326749e-003f, -8.066101e-003f, -4.876406e-003f,
  -1.240509e-002f, -8.138846e-003f, -1.494065e-002f, -1.020442e-002f, -7.846035e-003f, -1.666630e-003f, -1.210072e-003f, -2.090672e-003f,
  -6.116250e-004f, -6.305422e-003f, -4.839630e-003f, -1.224496e-002f, -4.599785e-003f, -6.127184e-003f, -5.877554e-003f,  6.443150e-004f,
   2.055398e-003f,  1.530908e-003f,  9.666776e-004f,  3.163791e-003f, -2.172886e-003f, -6.244179e-003f, -6.454336e-003f, -4.634493e-003f,
  -1.651830e-003f, -5.518831e-003f, -9.953609e-004f,  1.211389e-003f,  1.702778e-003f, -1.199146e-003f, -4.642859e-005f,  3.055146e-003f,
   1.081091e-004f, -2.836357e-004f, -2.238565e-003f,  9.200863e-004f,  7.555091e-004f,  2.359949e-003f,  1.740937e-003f, -1.473433e-003f,
  -2.036451e-003f, -3.968696e-003f, -1.454996e-003f, -2.219996e-003f, -2.419323e-003f, -1.784677e-003f, -8.276729e-004f,  1.682312e-004f,
  -9.423532e-004f,  2.065549e-004f, -1.457817e-003f, -1.583560e-003f, -1.384245e-003f, -1.818459e-003f,  8.861431e-004f,  2.675362e-003f,
   4.305988e-003f,  5.667920e-003f,  4.844790e-003f,  2.726878e-003f,  1.725356e-003f, -6.856822e-004f, -3.898012e-003f, -3.029259e-003f,
  -1.332645e-003f,  1.377239e-003f,  3.465872e-003f,  4.045175e-003f,  5.012765e-003f,  4.660241e-003f,  4.124726e-003f,  3.923911e-003f,
   4.147002e-003f,  3.384084e-003f,  2.449479e-004f,  1.004323e-003f, -6.357642e-004f, -1.428327e-003f, -1.050573e-003f, -8.477577e-004f,
  -2.758970e-004f, -9.441874e-004f,  3.534250e-004f,  8.126385e-004f,  1.638218e-003f,  2.803893e-004f,  9.892581e-004f,  2.899150e-003f,
   3.698480e-003f,  3.970854e-003f,  2.559316e-003f,  1.364581e-003f, -7.795353e-006f, -5.564444e-004f, -1.568396e-003f, -2.360868e-003f,
  -1.794127e-003f, -2.172807e-003f, -2.497306e-003f, -3.796500e-003f, -4.361536e-003f, -4.029624e-003f, -3.368501e-003f, -2.628331e-003f,
  -5.517511e-003f, -7.083821e-003f, -6.059992e-003f, -4.911447e-003f, -4.053525e-003f, -3.886881e-003f, -3.318018e-003f, -2.592965e-003f,
  -1.827342e-003f, -3.093851e-003f, -4.897615e-003f, -4.868942e-003f, -5.217863e-003f, -5.251597e-003f, -4.595860e-003f, -5.241992e-003f,
  -6.208453e-003f, -5.703964e-003f, -4.876240e-003f, -3.619383e-003f, -2.797001e-003f, -2.287318e-003f, -1.649404e-003f, -1.239087e-003f,
  -1.398867e-003f, -6.974788e-004f,  8.303932e-004f,  1.164229e-003f,  3.183991e-003f,  1.103147e-002f,  1.984734e-002f,  2.137146e-002f,
   1.964984e-002f,  1.394773e-002f,  5.985367e-003f,  2.879839e-003f, -1.863411e-004f, -2.629626e-003f, -1.563749e-003f,  3.573494e-003f,
   5.835226e-003f,  5.456475e-003f,  2.756644e-003f, -2.029354e-003f, -3.430956e-003f, -6.625041e-003f, -1.020034e-002f, -1.153447e-002f,
  -7.148693e-003f, -9.631979e-005f,  6.575871e-003f,  9.508814e-003f,  6.641352e-003f,  3.446595e-003f,  8.949160e-004f,  1.023140e-003f,
   1.063179e-003f, -6.683158e-005f, -5.747655e-004f,  9.163483e-004f,  4.338141e-003f,  4.764820e-003f,  3.754514e-003f,  2.525556e-004f,
  -3.109045e-003f, -4.738366e-003f, -4.530336e-003f, -2.145983e-003f,  8.004936e-004f,  4.082893e-003f,  6.114962e-003f,  7.779334e-003f,
   7.694095e-003f,  7.236718e-003f,  6.454342e-003f,  4.367381e-003f,  3.526614e-003f,  3.285248e-003f,  4.239586e-003f,  5.487273e-003f,
   6.064085e-003f,  5.439477e-003f,  4.765638e-003f,  5.589000e-003f,  4.224057e-003f,  2.227756e-003f,  1.775224e-003f,  1.058439e-003f,
   8.085103e-004f,  1.473311e-003f,  7.792155e-004f,  2.821271e-003f,  2.538192e-003f,  5.100086e-003f,  4.785110e-003f, -1.108573e-003f,
  -2.096588e-003f, -6.429605e-003f, -9.456885e-003f, -9.582523e-003f, -9.012293e-003f, -5.576761e-003f, -3.834332e-003f, -3.289745e-003f,
  -4.599404e-003f, -3.828111e-003f, -3.945161e-003f, -4.919930e-003f, -4.962473e-003f, -6.345925e-003f, -9.616014e-003f, -1.074484e-002f,
  -6.645985e-003f, -3.789821e-003f, -4.243810e-004f,  8.906587e-004f, -4.794424e-004f, -3.566678e-003f, -8.049544e-003f, -7.656806e-003f,
  -4.725202e-003f, -1.963273e-003f, -3.407828e-003f, -3.949335e-003f, -2.231807e-003f,  1.680300e-003f,  8.931305e-003f,  2.174550e-002f,
   2.947041e-002f,  2.088293e-002f,  2.131740e-003f, -1.518173e-002f, -2.122954e-002f, -1.651074e-002f, -7.063767e-003f, -2.750386e-003f,
  -8.519327e-004f, -1.195813e-003f, -1.454251e-003f, -1.494970e-003f, -4.281002e-003f, -1.062208e-002f, -1.677041e-002f, -1.503748e-002f,
  -8.043725e-003f,  7.021382e-004f,  5.077724e-003f,  1.917450e-003f, -2.077122e-003f, -6.692776e-003f, -3.909243e-003f, -4.839648e-003f,
  -3.597834e-003f, -5.335921e-003f, -4.338892e-003f, -3.898896e-003f, -2.267604e-003f, -6.672527e-004f,  1.468151e-004f,  2.587711e-003f,
   2.384562e-003f,  2.758862e-003f, -2.877821e-004f, -3.425787e-003f, -4.083475e-003f, -5.106135e-003f, -1.386030e-003f,  3.443925e-004f,
   5.642809e-003f,  4.321593e-003f,  6.581225e-003f,  3.154906e-003f,  3.837514e-003f,  2.367382e-003f,  9.950257e-004f, -4.758877e-004f,
  -9.706084e-004f, -1.557332e-003f,  3.790643e-003f, -6.048366e-004f,  2.555833e-002f,  7.765418e-002f,  8.887491e-002f,  8.817295e-002f,
   1.155893e-002f, -2.849232e-002f, -5.433069e-002f, -5.984078e-002f, -3.023953e-002f,  9.292353e-003f,  3.848165e-002f,  3.025013e-002f,
   1.136823e-002f, -1.061084e-002f, -2.316026e-002f, -2.340923e-002f, -1.661109e-002f, -2.974880e-005f, -6.067155e-003f,  8.426285e-003f,
   7.494452e-003f,  8.815546e-003f,  1.222447e-003f, -1.676518e-002f, -1.154442e-002f, -1.657255e-002f, -1.957215e-004f, -1.067765e-002f,
   1.447697e-003f, -9.673315e-004f, -3.514806e-003f, -8.713163e-003f, -1.452291e-002f, -7.282468e-003f, -8.448757e-003f,  4.457562e-003f,
   6.794801e-004f, -1.241932e-003f, -2.578862e-003f, -6.836882e-003f, -6.933328e-004f, -7.294449e-003f,  1.407264e-003f, -7.100210e-003f,
   4.187694e-003f,  1.799934e-004f, -5.087400e-004f,  2.422202e-003f, -1.429489e-004f, -9.884191e-003f, -2.105284e-002f, -1.971913e-002f,
  -9.456718e-003f,  5.931094e-003f,  1.162865e-002f,  1.330691e-002f, -9.884731e-004f, -1.420639e-002f, -2.326739e-002f, -1.338748e-002f,
  -5.037678e-003f,  5.323275e-003f,  1.532845e-002f,  1.762769e-002f,  3.783661e-003f, -4.263367e-003f,  9.085638e-004f,  6.375915e-003f,
   9.685912e-003f,  1.134775e-002f,  5.560841e-003f,  7.584417e-003f,  7.124271e-003f,  6.160402e-003f,  2.833890e-003f,  1.180269e-003f,
  -1.059497e-003f,  1.393673e-004f,  1.115475e-002f,  1.455675e-002f,  8.558598e-003f,  3.624801e-004f, -6.422655e-003f, -5.403927e-003f,
   2.608298e-003f,  1.400608e-002f,  1.469468e-002f,  1.109640e-002f, -2.092863e-003f, -7.024594e-003f, -2.286165e-003f,  4.632561e-003f,
   5.946372e-003f,  3.947728e-003f,  1.138802e-002f,  1.588026e-002f,  1.826633e-002f,  7.857540e-003f, -3.676142e-003f, -9.790028e-003f,
  -6.804383e-003f, -5.382796e-003f,  1.907272e-003f,  2.916788e-003f,  1.543097e-003f,  4.242258e-003f,  5.254306e-003f,  7.332284e-004f,
  -4.477756e-003f, -9.898641e-003f, -8.849707e-003f, -5.510071e-003f,  8.830105e-004f,  1.471996e-003f,  2.670756e-003f,  2.652481e-003f,
  -1.247591e-003f, -3.761776e-003f, -5.830082e-003f, -4.828332e-003f, -4.187442e-003f,  2.489701e-003f,  3.042757e-003f,  7.164323e-003f,
  -2.629405e-003f, -7.411725e-003f, -9.980007e-003f, -1.113289e-002f, -7.068878e-003f, -5.342003e-003f, -4.382325e-004f, -1.412826e-003f,
  -3.363700e-003f, -5.532376e-003f, -7.380669e-003f, -6.107726e-003f, -4.482345e-003f,  7.971571e-004f,  4.718848e-003f,  4.842424e-003f,
  -1.112024e-003f, -5.816840e-003f,  3.147146e-003f,  2.039180e-002f,  4.213341e-002f,  3.780227e-002f,  1.005355e-002f, -1.812533e-002f,
  -3.088913e-002f, -2.497468e-002f, -9.518519e-003f, -1.761852e-003f,  1.697345e-003f,  2.584749e-003f,  3.938466e-004f,  4.259961e-004f,
   4.688570e-004f, -2.677231e-003f, -8.337052e-003f, -1.159065e-002f, -1.085524e-002f, -4.482185e-003f,  2.740429e-003f,  3.322540e-003f,
  -2.219017e-003f, -5.842202e-003f, -1.007701e-003f,  5.139793e-003f,  9.350488e-003f,  8.977398e-003f,  3.572759e-003f,  3.057542e-003f,
   3.468978e-004f, -1.211499e-003f, -4.180918e-003f, -5.985272e-003f, -5.899784e-003f, -5.715554e-003f, -2.657610e-003f, -8.330457e-004f,
  -2.779254e-004f, -3.892842e-003f, -2.003248e-003f, -3.253341e-003f, -4.333080e-003f, -3.586384e-003f, -8.487039e-003f, -2.913442e-003f,
  -6.285144e-004f, -2.488978e-003f, -3.666021e-003f, -2.067787e-003f, -8.592575e-003f, -6.988217e-003f, -2.878800e-003f, -1.979928e-003f,
  -1.006109e-003f, -1.268654e-003f, -2.971304e-003f,  2.944542e-005f, -3.575492e-003f, -2.976387e-003f, -9.044334e-004f,  4.263273e-003f,
  -2.557577e-003f, -7.344241e-003f, -4.092227e-003f, -2.019175e-003f,  5.418656e-003f,  8.289934e-003f,  8.687765e-003f,  2.037911e-002f,
   6.551067e-002f,  5.151490e-002f,  2.703028e-002f, -7.709253e-003f, -4.073521e-002f, -6.023743e-002f, -4.764074e-002f, -2.970047e-004f,
   3.006836e-002f,  1.760801e-002f, -2.154904e-002f, -2.626635e-003f,  2.021565e-002f,  2.145159e-002f,  1.045033e-002f, -4.544319e-003f,
  -1.452799e-003f,  5.767290e-003f,  2.622408e-002f,  2.297581e-002f,  7.982112e-003f, -1.205945e-002f, -2.204576e-002f, -4.936656e-003f,
  -2.901368e-003f, -1.833736e-003f, -5.517081e-003f,  3.981589e-003f,  4.910828e-003f,  7.428709e-003f,  1.091125e-002f,  5.036062e-003f,
   6.385271e-004f, -9.896348e-004f,  9.309567e-003f,  1.432572e-002f,  9.630696e-003f, -2.352189e-004f, -8.656841e-003f, -2.716132e-003f,
  -2.697315e-003f, -3.475152e-003f, -8.334844e-003f, -9.573250e-003f, -8.291999e-003f,  4.138017e-004f,  9.846156e-003f,  6.816436e-003f,
   7.689466e-003f,  6.668233e-004f, -1.567302e-003f, -7.479618e-003f, -1.438478e-002f, -1.246655e-002f, -1.109608e-002f, -8.518648e-003f,
  -3.113921e-003f, -8.254468e-004f,  7.446146e-003f,  1.688079e-002f,  1.764990e-002f,  6.354614e-003f, -8.500538e-003f, -1.785789e-002f,
  -9.864503e-003f, -7.341928e-003f, -7.833324e-003f, -1.265803e-003f, -4.006187e-003f, -7.721929e-003f, -8.261005e-003f, -1.821379e-003f,
   9.006517e-003f,  9.904131e-003f,  5.028566e-003f,  3.203771e-003f,  6.782279e-003f,  4.743756e-003f, -2.936426e-003f, -1.070886e-002f,
  -1.218915e-002f, -6.928712e-003f, -3.212976e-003f, -6.733057e-003f, -1.391026e-002f, -1.596394e-002f, -1.328412e-002f, -6.799961e-003f,
  -3.403086e-003f, -4.486918e-003f, -2.406085e-003f, -2.502827e-004f,  2.833413e-003f,  7.595324e-004f, -8.006260e-003f, -1.204381e-002f,
  -1.206061e-002f, -9.354620e-003f, -6.361839e-003f, -3.086613e-003f, -4.418694e-003f, -3.465261e-004f,  1.971850e-003f,  5.747622e-003f,
   2.235814e-002f,  2.816762e-002f,  1.760378e-002f,  2.835953e-003f, -1.204648e-002f, -1.392376e-002f,  2.719761e-003f,  1.801003e-002f,
   1.445891e-002f,  3.783332e-003f, -1.426803e-002f, -1.248308e-002f, -1.876048e-003f,  5.075183e-003f,  3.881875e-003f, -6.143995e-003f,
  -8.524128e-003f, -1.202905e-002f, -5.284110e-003f, -5.118821e-003f, -1.076453e-002f, -7.892532e-003f, -6.701145e-003f,  5.054614e-003f,
   8.382043e-003f,  1.330461e-002f, -1.271741e-004f, -4.117658e-004f, -1.110070e-002f, -2.600422e-003f, -1.346134e-002f,  3.170583e-002f,
   5.635067e-002f,  1.961218e-002f,  3.330320e-002f,  1.022648e-002f,  1.373457e-002f, -1.868771e-002f, -2.053704e-003f, -9.858762e-003f,
  -1.360815e-003f, -1.957109e-002f,  3.739666e-003f,  4.619084e-002f,  2.522441e-002f,  4.033207e-002f,  2.435599e-002f,  1.810839e-002f,
  -7.501735e-003f, -8.827187e-003f, -1.318710e-002f, -2.057500e-002f, -1.600299e-002f, -1.145532e-002f,  5.344167e-003f,  5.002315e-003f,
   4.356150e-003f, -3.201154e-004f, -1.045238e-002f, -7.147832e-003f, -1.165973e-002f,  4.078614e-003f,  9.499337e-003f,  1.639731e-002f,
   5.024309e-003f,  4.373545e-003f,  8.090684e-003f,  2.058926e-003f,  6.250083e-003f, -3.600239e-003f,  1.286831e-003f, -3.126039e-003f,
   2.141613e-003f,  3.002349e-006f,  4.445767e-003f,  1.585683e-003f, -1.255326e-002f, -9.178004e-003f, -1.507701e-002f, -1.182019e-002f,
  -1.389588e-002f, -1.372493e-002f, -6.560472e-003f, -1.702696e-003f, -1.689126e-003f, -8.882623e-003f, -3.976781e-003f, -1.258736e-003f,
   1.617553e-002f,  1.461047e-002f,  1.524378e-002f,  1.759975e-002f,  2.675743e-003f, -6.919423e-004f, -1.184995e-002f, -7.616867e-003f,
  -8.765738e-003f, -7.533387e-003f, -5.765769e-003f, -3.233702e-003f, -4.090324e-003f, -1.004303e-002f, -5.747121e-004f,  1.106143e-003f,
   7.969497e-003f,  9.454433e-003f,  1.254865e-002f,  1.127487e-002f, -1.008826e-003f, -2.709250e-003f, -3.795541e-003f,  4.368505e-003f,
   1.621723e-003f,  8.144279e-004f,  4.826926e-003f, -4.920232e-004f, -6.537271e-003f, -8.397906e-003f, -5.811177e-003f,  3.859643e-003f,
   2.692343e-002f,  3.160383e-002f,  1.750492e-002f, -6.668995e-004f, -1.270232e-002f, -4.267182e-003f,  6.196222e-003f,  2.691803e-003f,
  -1.239450e-002f, -2.613680e-002f, -2.669926e-002f, -1.677974e-002f, -2.240461e-003f, -9.170289e-004f, -1.863540e-003f, -2.297525e-003f,
   2.076987e-003f,  1.041126e-002f,  8.571174e-003f, -2.065491e-003f, -1.072798e-002f, -1.269204e-002f, -8.519778e-003f, -1.427532e-003f,
   1.855057e-003f, -3.085413e-003f, -1.075381e-002f, -9.515030e-003f, -4.335403e-003f,  3.954320e-004f,  1.839790e-004f, -1.022790e-003f,
  -1.552559e-003f,  3.082096e-003f,  3.737126e-003f,  6.624255e-003f,  6.749351e-003f,  1.047333e-003f, -3.352206e-003f, -9.180338e-003f,
  -1.156800e-002f, -1.421199e-002f, -8.172442e-003f, -5.826398e-003f, -5.797158e-003f, -6.147165e-003f, -9.525969e-003f, -7.075186e-003f,
  -8.399141e-003f, -9.556283e-003f, -9.991499e-003f, -4.706270e-003f,  4.744309e-003f,  1.073794e-002f,  1.432086e-002f,  9.478765e-003f,
   4.574436e-003f,  2.382264e-003f,  9.512983e-003f,  1.997022e-002f,  2.593773e-002f,  1.988670e-002f,  1.607851e-003f, -1.223544e-002f,
  -1.698887e-002f, -1.040220e-002f, -7.536199e-003f, -4.599790e-003f, -1.907271e-003f,  8.935766e-003f,  1.594882e-002f,  1.448228e-002f,
   4.824579e-003f, -4.036907e-003f, -5.232045e-003f, -6.376488e-004f,  1.096934e-002f,  1.375132e-002f,  1.710173e-002f,  1.288458e-002f,
   1.151718e-002f,  1.031494e-002f,  6.489837e-003f, -8.855726e-004f, -1.060362e-002f, -1.491774e-002f, -1.647360e-002f, -5.031443e-003f,
   4.751366e-003f,  1.015093e-002f,  1.043778e-002f,  4.909820e-003f,  7.385378e-003f,  5.380230e-003f,  6.479885e-003f,  2.727940e-004f,
  -1.424714e-003f, -8.167126e-004f, -1.077649e-003f,  7.523182e-004f, -4.209971e-003f, -2.188337e-003f, -4.389509e-003f, -3.779352e-003f,
  -8.457736e-004f,  4.608854e-003f,  4.123786e-003f, -1.596144e-003f, -8.008412e-003f, -1.188701e-002f, -6.466493e-003f,  1.131970e-003f,
   7.913635e-003f,  5.666581e-003f,  1.868590e-003f, -1.979372e-003f, -3.882060e-003f, -4.232484e-003f, -6.272597e-003f, -4.912388e-003f,
  -2.503433e-003f,  3.004145e-003f,  1.604031e-003f, -2.683808e-003f, -6.902641e-003f, -9.253363e-003f, -8.001343e-003f, -9.098767e-003f,
  -7.901382e-003f, -6.185355e-003f, -1.019219e-002f, -1.493866e-002f, -1.573042e-002f, -1.128656e-002f, -4.851530e-003f, -1.244352e-003f,
  -3.644242e-003f, -4.422193e-003f, -9.248184e-004f,  2.396696e-003f,  6.598049e-003f,  7.831689e-003f,  6.315236e-003f,  4.337583e-003f
};

static const float VastImpulseRight2[] =
{
   7.147228e-004f, -1.083345e-003f,  6.168442e-004f, -1.431390e-003f,  4.355595e-004f, -5.269021e-003f, -8.064653e-003f, -7.821043e-003f,
  -7.375424e-003f, -5.287364e-003f,  6.268462e-003f,  5.703426e-003f,  7.084014e-003f,  7.133598e-003f, -3.247700e-003f, -4.979576e-003f,
  -1.341776e-002f, -2.013400e-002f, -1.410223e-002f, -1.749049e-002f, -1.049977e-002f, -9.283137e-003f, -7.878784e-003f, -9.547541e-003f,
  -7.361239e-003f, -1.127072e-002f, -1.033906e-002f, -3.889947e-003f, -7.505371e-003f, -4.238191e-003f, -3.357905e-003f, -1.733163e-003f,
  -5.178418e-003f, -3.167645e-003f, -4.573377e-003f, -3.609364e-003f, -4.031338e-003f, -3.782355e-003f, -4.174925e-003f, -3.084759e-003f,
  -8.866453e-003f, -4.111012e-003f, -9.506023e-003f, -2.429747e-003f, -8.444440e-003f, -9.256981e-004f, -6.825532e-003f,  3.252683e-004f,
  -7.216674e-003f, -2.023958e-003f, -9.084544e-003f, -1.065016e-003f, -9.343010e-003f, -4.733420e-004f, -4.933123e-003f, -6.481814e-004f,
  -4.725344e-003f,  2.124546e-003f, -9.946168e-003f,  3.664995e-003f, -1.195723e-002f,  1.911197e-003f, -1.092121e-002f,  5.330753e-003f,
  -8.472840e-003f,  6.505471e-003f, -8.262839e-003f,  5.283985e-003f, -9.437382e-003f,  3.935043e-003f, -1.129954e-002f,  1.062205e-002f,
  -1.261568e-002f,  1.922159e-002f, -2.234253e-002f,  3.802946e-002f, -5.260962e-002f,  1.809640e-001f,  6.249903e-001f, -5.272836e-002f,
   5.188638e-001f,  2.092010e-001f, -4.871819e-001f, -1.413894e-001f, -3.230826e-001f, -2.582286e-001f, -1.464120e-001f, -4.810134e-002f,
   3.361625e-001f,  2.177821e-001f,  5.596220e-004f,  1.366107e-001f, -1.054757e-002f, -2.202704e-001f, -7.536483e-002f, -1.997994e-002f,
  -4.121144e-002f,  1.626148e-001f,  7.026459e-002f, -5.285296e-002f,  5.775158e-002f, -3.441332e-002f, -9.348831e-002f, -6.192145e-002f,
  -1.893442e-003f, -1.448755e-002f, -1.254662e-002f,  4.511284e-002f,  2.820763e-003f,  4.606444e-002f, -3.886541e-002f,  1.897321e-002f,
  -8.801623e-003f, -2.989641e-002f, -2.377311e-002f, -2.213402e-002f,  9.984591e-003f,  7.283641e-003f,  2.505186e-002f, -7.885008e-003f,
   5.836352e-003f,  9.614456e-003f, -2.485212e-002f,  1.064673e-002f, -1.602267e-002f,  6.595762e-003f, -2.032810e-002f,  4.543768e-003f,
  -2.124027e-002f,  8.662990e-003f,  1.630964e-002f, -1.733855e-002f,  2.531566e-002f, -1.097512e-002f,  2.682668e-003f, -2.453646e-002f,
  -2.646449e-002f, -1.245175e-002f, -1.379280e-002f, -2.018507e-002f,  5.161600e-004f,  3.535149e-002f, -8.020385e-003f,  1.410121e-002f,
   9.573213e-003f, -7.381544e-005f, -8.251582e-003f, -3.231783e-002f,  1.026736e-002f, -5.278590e-003f, -1.606578e-003f, -8.141088e-003f,
   1.177580e-002f,  8.707032e-004f, -5.973943e-003f,  6.025350e-003f, -4.201620e-003f,  4.927937e-003f, -8.110544e-003f, -9.002749e-004f,
   2.673486e-003f, -4.420518e-003f,  2.174450e-004f, -5.655851e-003f,  6.236167e-003f, -7.704183e-003f,  1.422541e-003f, -4.511880e-003f,
  -8.134171e-004f, -4.761395e-003f, -6.262502e-003f,  1.448120e-003f, -3.601794e-003f,  4.857202e-003f,  4.554759e-004f,  2.189546e-003f,
  -4.466780e-003f, -8.378461e-004f, -8.627584e-004f, -6.271179e-003f,  1.084678e-002f,  4.845097e-003f,  1.697831e-002f,  1.192281e-002f,
   2.226184e-003f,  3.157133e-003f, -6.575873e-003f, -8.986287e-003f, -7.000221e-003f, -7.824639e-004f,  4.632861e-003f,  1.016391e-002f,
   5.848879e-003f,  8.997337e-003f,  4.091111e-003f, -6.189593e-003f, -4.133109e-003f,  1.492707e-003f,  2.729120e-003f,  3.571287e-003f,
   9.548417e-003f,  1.122151e-002f,  2.606184e-004f,  4.341647e-004f, -2.295780e-003f, -2.111519e-003f, -1.797632e-003f, -2.494790e-003f,
   3.024444e-003f,  3.875119e-003f, -7.113897e-004f,  1.536647e-003f,  1.076905e-003f, -3.067350e-003f, -1.801027e-003f, -1.485831e-003f,
  -1.168383e-003f,  2.375746e-003f, -8.871284e-004f,  6.341022e-005f,  3.197810e-004f, -1.923192e-003f, -2.746630e-003f, -4.975523e-003f,
  -3.132954e-003f, -4.283517e-003f, -3.192410e-003f, -4.247022e-003f, -8.910939e-004f,  2.929329e-005f, -5.268320e-003f, -2.096566e-003f,
  -1.741816e-003f, -4.084502e-003f, -4.121281e-003f, -4.989477e-003f, -4.013713e-003f, -3.641498e-003f, -2.287757e-003f, -4.175215e-003f,
  -1.796037e-003f, -1.886781e-003f, -4.648785e-003f, -1.850520e-003f, -4.518642e-003f, -4.220202e-003f, -6.168066e-003f, -5.376089e-003f,
  -4.140414e-003f, -4.510939e-003f, -5.190485e-003f, -8.762506e-004f,  7.675092e-005f, -4.568629e-003f, -3.553629e-004f, -6.306767e-004f,
  -9.748428e-004f, -1.221607e-003f, -1.297047e-003f, -5.748154e-004f, -4.452367e-003f, -2.980153e-003f, -2.797808e-003f, -8.245509e-004f,
   9.122001e-004f,  8.355005e-003f,  2.319620e-002f,  2.532005e-002f,  2.695830e-002f,  2.173192e-002f,  1.144380e-002f,  5.455866e-003f,
  -1.409681e-003f, -2.090332e-003f, -4.225459e-003f, -4.005024e-003f,  1.382889e-003f,  6.413411e-003f,  7.734126e-003f, -6.617333e-004f,
  -4.715157e-003f, -1.369692e-002f, -1.661368e-002f, -7.323028e-003f,  1.587348e-002f,  3.189538e-002f,  3.929185e-002f,  3.463962e-002f,
   2.084590e-002f,  9.344889e-003f, -5.630418e-003f, -1.371037e-002f, -7.160124e-003f,  5.982817e-003f,  1.139301e-002f,  1.163933e-002f,
   9.702675e-003f,  5.293074e-003f,  4.912983e-003f,  1.720458e-003f, -8.460404e-003f, -1.283332e-002f, -9.683421e-003f, -5.722290e-003f,
  -1.759767e-003f,  1.394095e-003f,  3.339729e-003f,  3.404994e-003f,  1.450466e-003f, -6.478857e-004f, -5.202487e-003f,  2.089091e-003f,
  -4.097266e-003f, -6.557945e-003f, -1.085577e-002f, -1.328171e-002f, -7.067584e-003f, -6.537016e-003f, -3.914444e-003f,  4.180643e-003f,
   3.383384e-004f,  3.001410e-003f,  8.448187e-003f,  8.002428e-003f, -4.853545e-003f, -5.341832e-003f, -9.730024e-003f, -1.671541e-002f,
  -1.162553e-002f, -7.641285e-003f,  4.038883e-003f, -5.563179e-003f,  5.564695e-003f, -3.504173e-004f, -3.424062e-003f, -7.311092e-003f,
  -1.516305e-002f, -6.470228e-003f, -1.386278e-002f,  1.975590e-003f, -1.395220e-002f, -5.780063e-003f,  1.529671e-003f, -4.591301e-003f,
  -6.451894e-004f, -7.226735e-003f,  5.993305e-003f, -6.561630e-003f,  3.131310e-003f,  2.593661e-003f,  8.276501e-003f,  1.797055e-003f,
  -2.579148e-004f,  7.104573e-003f, -1.083235e-002f, -6.842821e-004f, -8.992365e-003f, -4.333236e-003f, -4.359723e-003f, -5.679024e-003f,
  -5.969346e-004f, -3.264387e-003f,  1.562900e-002f,  1.886657e-002f,  4.490441e-002f,  3.417005e-002f,  1.302891e-002f, -1.616210e-002f,
  -3.736574e-002f, -2.458104e-002f, -1.685712e-002f,  3.619726e-003f,  2.777056e-003f,  1.060790e-002f,  2.408094e-003f,  5.336197e-003f,
   2.291653e-004f, -1.271850e-002f, -1.276978e-002f, -2.384506e-002f, -1.496873e-002f, -7.494699e-003f,  1.086838e-002f,  1.002628e-002f,
   4.726642e-003f, -1.966827e-003f, -4.904383e-003f,  1.593786e-004f, -5.293987e-003f,  1.666041e-003f, -2.058852e-003f,  5.129442e-003f,
   1.509610e-003f,  3.638454e-003f,  4.973985e-003f,  4.061086e-003f,  9.861357e-003f,  1.329528e-003f,  4.333391e-003f, -4.030475e-004f,
   2.196254e-003f,  3.252326e-003f,  8.357304e-004f,  3.586340e-003f,  1.536186e-003f,  8.749535e-003f,  6.719653e-003f,  9.834549e-003f,
   5.625906e-003f,  4.802702e-003f,  3.390085e-003f, -4.309364e-003f, -2.878903e-003f, -6.585292e-003f, -2.486617e-003f, -3.875404e-003f,
  -4.122855e-003f, -4.987924e-003f, -3.217573e-003f, -2.167689e-003f, -5.550796e-003f, -7.129569e-003f, -1.888431e-003f, -1.014787e-003f,
  -2.906619e-003f, -2.595325e-003f, -5.116226e-003f, -8.746258e-004f, -3.041030e-003f, -3.373707e-004f,  1.596749e-003f,  2.662462e-003f,
  -4.409367e-003f, -1.040640e-002f, -8.902596e-003f, -8.680306e-003f, -4.230386e-003f, -2.762944e-003f, -2.195737e-003f, -5.184700e-003f,
  -7.556724e-003f, -2.577929e-003f, -7.146765e-003f, -8.498235e-003f, -1.840229e-003f,  2.868941e-003f,  1.156330e-002f,  1.191277e-002f,
   9.841357e-003f,  1.188095e-002f,  7.205851e-003f, -8.623108e-005f,  3.320860e-003f,  7.663007e-003f,  8.091407e-003f,  1.440832e-002f,
   5.759280e-003f, -2.233658e-003f, -6.771601e-003f, -8.668117e-003f, -6.835925e-003f, -6.966576e-003f, -3.030736e-003f, -5.303336e-003f,
  -6.903934e-004f,  4.106790e-003f,  1.072926e-002f,  1.913001e-002f,  2.086112e-002f,  1.489374e-002f,  5.448616e-003f, -2.325145e-003f,
  -5.170397e-003f, -4.387473e-003f, -2.624027e-003f, -2.897258e-004f,  4.587237e-003f,  6.805811e-003f,  8.817927e-003f,  4.892115e-003f,
   2.674090e-003f, -2.358430e-003f, -5.711660e-003f, -7.134959e-003f, -4.765990e-003f,  1.499736e-003f,  4.174850e-003f,  6.606585e-003f,
   2.965610e-003f, -1.131580e-003f, -2.229106e-003f,  8.529698e-005f,  2.746635e-004f,  9.699915e-004f,  3.742427e-004f,  3.784026e-003f,
   9.935423e-003f,  1.272334e-002f,  1.304815e-002f,  2.531539e-003f, -4.443378e-003f, -7.512329e-003f, -4.858766e-003f, -1.355432e-003f,
  -9.792272e-004f,  8.376019e-005f, -1.100387e-003f,  1.285765e-003f, -2.676483e-003f, -1.999854e-003f, -4.217291e-003f, -5.732940e-003f,
  -6.864865e-003f, -3.763788e-003f, -8.845300e-004f,  3.190703e-003f,  3.682428e-003f, -1.478087e-004f, -2.523983e-003f, -2.333970e-003f,
  -2.171845e-003f, -2.558671e-003f, -4.117329e-003f, -7.446754e-003f, -6.136237e-003f, -4.261544e-003f, -2.066686e-003f,  5.668961e-004f,
  -3.963008e-005f,  1.143911e-003f,  4.966125e-004f, -8.300147e-004f,  2.735109e-003f, -1.333334e-004f, -1.550850e-003f, -5.168400e-003f,
  -4.722682e-003f, -2.993271e-003f,  1.813301e-003f,  4.639544e-003f,  1.917192e-003f, -1.206391e-003f, -3.084890e-003f, -1.434579e-003f,
  -1.802473e-003f, -3.649282e-003f, -6.124610e-003f, -5.685334e-003f, -3.472492e-003f, -1.884136e-003f,  1.274614e-003f,  2.454636e-003f,
   3.741423e-003f,  3.246944e-003f,  2.736203e-003f,  1.170753e-003f,  9.005528e-005f, -8.620002e-004f, -4.010106e-003f, -6.072538e-003f,
  -6.003406e-003f, -3.198660e-003f, -2.296872e-003f, -8.865578e-004f,  8.507931e-004f,  9.908909e-005f,  1.316519e-004f, -1.319271e-003f,
  -2.645399e-003f, -5.746249e-003f, -4.406239e-003f, -2.968147e-003f, -9.937151e-004f,  7.199597e-004f,  1.489200e-004f, -5.363340e-004f,
  -4.852346e-003f, -3.920124e-003f, -4.418915e-003f, -1.548533e-003f,  4.894937e-003f,  9.834259e-003f,  1.154728e-002f,  9.034938e-003f,
   2.731841e-003f, -1.918017e-003f, -3.762576e-003f, -2.552683e-003f, -4.043146e-005f,  4.957403e-004f,  1.588688e-003f,  4.081166e-003f,
   2.068998e-003f,  2.467886e-003f,  1.490548e-003f, -2.688356e-003f, -4.817192e-003f, -7.097452e-003f, -4.445194e-003f, -2.437318e-003f,
  -3.367474e-003f,  4.537534e-004f,  1.108646e-003f,  2.807948e-003f,  6.877561e-003f,  7.635634e-003f,  1.314005e-002f,  3.154518e-003f,
  -1.449621e-003f, -1.731778e-003f, -1.288880e-003f, -4.243944e-003f, -7.030650e-003f, -1.900485e-003f, -6.850064e-003f, -1.766861e-003f,
  -4.381080e-003f,  5.586766e-003f,  6.349185e-003f, -3.194477e-003f, -7.071086e-005f, -1.924213e-003f, -2.253035e-003f, -5.262599e-003f,
   4.859871e-004f, -1.199783e-003f, -2.789451e-004f,  2.860019e-003f,  1.277520e-003f,  3.328526e-003f,  1.602170e-003f,  2.375164e-002f,
   5.030152e-002f,  5.714664e-002f,  3.778434e-002f, -9.032506e-004f, -2.283514e-002f, -4.966294e-002f, -5.966789e-002f, -2.585472e-002f,
   1.634769e-002f,  1.048965e-002f, -8.994766e-003f,  3.108408e-003f,  8.456068e-003f,  2.389939e-002f,  2.105371e-002f,  9.166787e-003f,
  -1.663383e-003f, -1.197210e-002f, -1.054484e-002f, -9.948110e-003f, -3.153593e-004f, -9.465583e-003f, -7.971252e-003f, -4.600021e-003f,
   3.638804e-003f,  1.079383e-002f,  9.278141e-004f, -5.040905e-003f, -1.324209e-002f, -7.863030e-003f, -2.001483e-003f,  4.607813e-003f,
   4.056717e-003f,  5.180718e-004f, -1.285696e-003f, -5.365319e-003f,  1.819309e-003f, -1.128788e-003f, -2.554535e-003f, -3.566666e-003f,
  -5.366122e-003f, -2.123867e-003f,  1.235381e-003f,  1.036353e-003f, -3.444783e-003f, -3.577516e-003f, -6.242875e-003f, -2.713510e-003f,
  -2.730346e-003f, -3.115631e-003f, -5.171327e-003f, -8.075353e-003f, -4.270504e-003f, -5.252937e-003f, -5.018333e-003f, -1.001102e-002f,
  -9.303709e-003f, -8.382646e-003f, -1.478711e-003f,  1.068196e-002f,  1.374995e-002f,  9.289669e-003f, -2.723098e-003f, -2.883658e-003f,
  -5.098384e-003f,  1.402953e-004f,  1.025985e-002f,  2.373944e-002f,  2.556697e-002f,  1.231556e-002f,  4.703003e-004f, -9.556703e-003f,
  -1.239275e-002f, -1.273192e-002f, -4.619659e-003f, -1.162195e-003f,  4.681555e-003f,  1.120265e-002f,  1.382540e-002f,  1.831552e-002f,
   1.281088e-002f,  7.635045e-003f,  2.829859e-003f,  3.462915e-003f,  1.245451e-003f, -1.250369e-003f, -2.138904e-004f, -3.085845e-003f,
   1.708851e-003f, -9.134173e-004f,  4.584240e-003f,  6.776733e-003f,  1.774621e-003f, -3.610377e-003f, -9.926635e-003f, -1.564239e-002f,
  -1.605362e-002f, -7.914798e-003f, -6.771511e-003f, -3.148726e-003f, -2.961622e-003f, -1.118248e-003f,  3.693736e-005f,  6.840805e-003f,
   1.986846e-002f,  2.180732e-002f,  1.336102e-002f, -1.125860e-002f, -3.071703e-002f, -2.862345e-002f, -8.009505e-003f,  1.277336e-002f,
   1.420295e-002f,  8.175498e-003f, -6.348738e-003f, -1.582671e-002f, -1.346025e-002f, -5.949626e-003f, -2.955907e-003f, -8.388498e-004f,
   7.793572e-005f, -4.155744e-003f, -2.112771e-003f, -6.141463e-003f, -5.539749e-003f, -7.872186e-003f, -1.035232e-002f, -7.037515e-003f,
  -2.659815e-003f,  2.915105e-003f, -6.577677e-004f, -6.486508e-003f, -8.067424e-003f, -2.786614e-003f, -9.444871e-004f, -4.046926e-003f,
  -3.598744e-003f, -2.086026e-003f,  3.984472e-003f,  6.851869e-003f,  5.452359e-003f,  4.493006e-003f,  1.853793e-003f, -6.374970e-003f,
  -1.079482e-002f, -8.073160e-003f, -6.505900e-003f, -3.389843e-003f,  5.106703e-003f,  1.560149e-002f,  2.340934e-002f,  2.101239e-002f,
   1.240175e-002f,  1.660910e-003f, -1.450076e-002f, -1.691727e-002f, -9.052035e-003f, -1.646523e-003f, -2.903796e-003f, -2.007141e-006f,
   8.377476e-003f,  1.156682e-002f,  1.997357e-002f,  2.335409e-002f,  2.909012e-002f,  3.515843e-002f,  2.783396e-002f,  2.689493e-002f,
   8.873599e-003f,  4.676856e-003f,  5.960226e-004f, -1.172506e-002f, -8.727366e-003f, -9.786468e-004f,  1.803613e-002f,  1.230676e-002f,
   2.243199e-003f, -1.080470e-002f, -1.657535e-002f, -5.361096e-003f, -3.292946e-003f, -2.028530e-003f,  3.144877e-004f,  3.074594e-003f,
   3.893656e-003f, -2.036196e-003f, -7.364448e-003f, -9.751755e-003f, -4.923632e-003f, -4.432208e-003f,  5.373178e-004f,  4.428352e-003f,
   4.868526e-003f, -2.949835e-003f, -8.781573e-003f, -7.240998e-003f, -7.993857e-003f, -1.338050e-003f, -4.438563e-003f, -6.419342e-003f,
  -9.369148e-003f, -6.881495e-003f,  8.734830e-004f,  5.275868e-003f,  6.523101e-003f,  2.461541e-003f,  2.548962e-004f, -1.620739e-003f,
  -1.159594e-004f, -1.534255e-003f, -1.529768e-003f,  1.051188e-003f,  3.090002e-003f,  1.359907e-003f, -2.807669e-003f,  8.110814e-003f,
   1.359645e-002f,  1.536403e-002f,  4.799194e-003f, -4.726855e-003f, -3.465611e-003f, -4.222817e-003f, -8.742038e-003f, -1.369816e-002f,
  -4.307796e-003f,  4.908754e-003f,  7.020917e-003f,  3.100744e-003f, -5.836959e-003f, -9.932510e-003f, -6.252525e-003f, -6.922010e-003f,
   1.505718e-003f, -2.524971e-003f, -5.969746e-003f, -2.785523e-003f,  4.676936e-003f,  1.790843e-002f,  1.580430e-002f,  9.160150e-003f,
  -2.748858e-003f, -8.524763e-003f, -1.278859e-002f, -1.121170e-002f, -1.970299e-003f, -4.423934e-003f,  1.193514e-003f, -3.624213e-003f,
  -2.418657e-003f, -3.302884e-004f,  1.038359e-003f,  7.385568e-003f,  1.099264e-002f,  2.442077e-002f,  1.328817e-002f,  6.404743e-003f,
  -1.239234e-002f, -2.091111e-002f, -2.067710e-002f, -1.350107e-002f,  5.661132e-003f,  6.177708e-003f,  9.250800e-003f,  2.148720e-003f,
   9.980534e-004f, -2.935981e-003f, -5.189429e-003f, -5.295795e-004f, -3.153991e-003f,  4.175042e-003f,  1.557669e-003f,  6.683657e-003f,
   6.699537e-003f,  3.701358e-004f, -4.122208e-003f, -1.313209e-002f, -7.899105e-003f, -4.261055e-003f, -3.337215e-003f, -8.393028e-003f,
  -7.254093e-003f, -6.515719e-003f,  1.527659e-003f,  1.782852e-002f,  2.138165e-002f,  1.633942e-002f,  1.604467e-003f, -5.882598e-003f,
  -2.853574e-003f,  2.291737e-003f, -9.777355e-004f, -8.709606e-003f, -4.905956e-003f, -5.860499e-004f,  8.686950e-003f,  9.951357e-003f,
   6.316993e-003f, -2.796747e-004f, -6.736447e-003f, -4.814185e-003f, -2.860952e-003f,  3.449735e-003f,  3.740316e-004f, -3.437807e-004f,
  -1.640664e-003f, -8.705450e-004f,  4.219432e-003f,  5.369851e-003f,  2.399511e-003f, -7.148542e-003f, -9.375116e-003f, -8.659131e-003f,
  -7.406770e-004f,  4.415288e-003f,  5.303052e-003f,  5.850579e-003f,  5.217141e-003f,  5.510308e-003f,  2.068967e-003f, -6.941663e-003f,
  -1.206547e-002f, -1.293321e-002f, -1.118803e-002f, -5.452414e-003f, -3.914490e-004f,  4.303760e-003f,  8.259882e-003f,  7.622158e-003f,
   2.689689e-003f, -2.347222e-003f, -4.371783e-003f,  2.981920e-003f,  4.795542e-003f,  6.610071e-003f,  5.754341e-003f,  6.987668e-003f,
   7.314436e-003f,  2.420866e-003f, -1.165484e-003f, -5.923891e-003f, -1.097523e-002f, -7.730168e-003f, -5.209967e-003f, -2.672200e-003f,
  -1.597043e-004f, -1.300565e-003f, -3.046519e-004f,  1.502428e-004f,  7.180786e-004f,  8.334275e-004f, -3.986518e-004f, -4.884523e-003f,
  -5.338056e-003f, -4.646201e-003f, -1.743899e-003f, -1.763040e-003f, -3.177058e-003f, -4.408345e-003f, -7.132693e-003f, -3.925838e-003f,
  -1.384209e-003f,  1.645238e-003f,  4.045820e-004f, -5.015566e-003f, -6.382576e-003f, -7.644765e-003f, -5.645684e-003f, -5.072384e-003f
};

static const float VastImpulseLeft3[] =
{
  -4.407532e-005f,  1.471632e-004f, -5.886366e-005f,  1.633994e-004f, -1.560378e-004f,  9.553484e-005f, -3.116908e-004f,  3.049894e-005f,
  -5.995254e-004f, -1.583931e-004f, -3.118315e-003f, -5.817062e-003f, -6.162263e-003f, -5.569772e-003f, -5.178346e-003f,  1.410924e-003f,
   2.754689e-003f,  4.350000e-003f,  5.037269e-003f, -2.505263e-004f, -4.624754e-003f, -7.220264e-003f, -1.293051e-002f, -1.135546e-002f,
  -1.273636e-002f, -1.246961e-002f, -1.207660e-002f, -9.412213e-003f, -9.767485e-003f, -8.128101e-003f, -9.676894e-003f, -1.108067e-002f,
  -8.566429e-003f, -6.619360e-003f, -6.681183e-003f, -3.140062e-003f, -3.554229e-003f, -3.269175e-003f, -4.164862e-003f, -2.426742e-003f,
  -6.342517e-003f, -5.358074e-003f, -7.720523e-003f, -7.496936e-003f, -6.277157e-003f, -6.922109e-003f, -7.320319e-003f, -7.742585e-003f,
  -6.125393e-003f, -6.698904e-003f, -4.651457e-003f, -3.575344e-003f, -4.779543e-003f, -4.645015e-003f, -5.069782e-003f, -5.853625e-003f,
  -4.487252e-003f, -5.773845e-003f, -4.638602e-003f, -4.875311e-003f, -2.877452e-003f, -4.744836e-003f, -7.964746e-004f, -6.778970e-003f,
  -2.464646e-003f, -7.465642e-003f, -3.577756e-003f, -7.259258e-003f, -2.283105e-003f, -5.790919e-003f, -1.337213e-004f, -4.226391e-003f,
   9.177312e-004f, -5.898268e-003f,  1.451138e-003f, -8.334927e-003f,  6.400828e-003f, -8.256831e-003f,  1.180195e-002f, -1.408769e-002f,
   2.216825e-002f, -3.233449e-002f,  1.209817e-001f,  3.785075e-001f,  1.144562e-001f,  2.401647e-001f,  2.788152e-001f, -1.792012e-001f,
  -1.255204e-001f, -1.630370e-001f, -2.629488e-001f, -8.753336e-002f,  3.389883e-003f,  7.375268e-002f,  7.005932e-002f,  6.922218e-002f,
  -7.375950e-003f,  1.092690e-001f,  1.591894e-002f, -1.037116e-001f, -6.934183e-002f,  1.526360e-003f,  7.903450e-002f,  8.257950e-002f,
   9.771103e-002f,  1.960334e-002f, -3.307072e-002f, -6.001338e-002f, -8.451489e-002f, -5.963552e-002f, -8.534695e-002f, -4.495735e-002f,
   3.239976e-003f,  5.283527e-002f,  6.298099e-002f,  2.498337e-002f,  2.013240e-002f, -2.032567e-002f, -7.811439e-003f, -1.630766e-002f,
  -6.600369e-003f, -9.036742e-003f, -9.683532e-003f,  6.061614e-003f,  1.142411e-002f,  1.673107e-002f, -4.951785e-003f, -3.376051e-003f,
  -6.221648e-003f, -5.302868e-003f, -1.805978e-003f, -1.494934e-002f, -1.052801e-002f, -3.030652e-002f, -9.960241e-003f, -5.811095e-003f,
  -1.514426e-003f, -2.373381e-003f, -3.481488e-003f, -3.682624e-003f, -7.336740e-003f, -1.145569e-002f, -1.191975e-002f,  2.601808e-004f,
  -8.431515e-003f, -2.280040e-003f,  1.569268e-002f,  2.627253e-003f,  4.637307e-003f,  5.508018e-003f,  3.826734e-003f, -8.300436e-003f,
  -1.427897e-002f, -7.757521e-003f, -3.434558e-003f, -2.110630e-003f, -5.058769e-003f,  4.926832e-003f,  1.439554e-004f, -5.097280e-003f,
  -5.563323e-003f,  1.334253e-003f,  4.664673e-003f, -1.406596e-003f,  2.427584e-004f,  7.649555e-004f,  3.840365e-004f,  7.833054e-004f,
   1.628487e-003f, -4.950013e-004f, -6.701796e-003f, -4.067669e-003f, -1.218028e-003f,  2.411567e-003f, -3.145623e-003f, -2.897589e-003f,
  -6.456792e-004f, -1.175098e-004f,  1.685406e-003f,  2.241091e-003f,  1.516213e-003f, -3.177732e-003f, -2.177258e-003f, -1.787026e-003f,
  -2.050320e-003f,  4.745273e-003f,  3.175109e-003f,  7.671906e-003f,  9.394359e-003f,  3.900991e-003f,  2.708379e-003f,  4.558893e-004f,
  -5.414223e-003f, -6.893979e-003f, -2.556861e-003f,  2.401909e-004f,  3.505698e-003f,  4.018144e-003f,  3.892435e-003f,  4.729023e-003f,
   1.308013e-003f,  1.947517e-003f,  2.610015e-003f,  4.376722e-003f,  1.575390e-003f,  5.022224e-003f,  9.293431e-003f,  4.643139e-003f,
   4.085740e-003f, -2.496507e-004f, -2.186901e-003f, -3.640628e-003f, -4.493577e-003f, -2.781580e-003f,  2.129562e-004f,  6.644750e-004f,
   3.073834e-005f,  3.305984e-003f,  1.344670e-003f, -9.834352e-004f, -1.008614e-003f, -1.172235e-003f,  1.246792e-003f,  1.212721e-003f,
   3.379269e-003f,  1.988188e-003f,  1.355367e-003f, -4.570005e-004f, -3.677904e-003f, -3.238861e-003f, -4.170606e-003f, -1.960986e-003f,
  -6.260835e-004f,  1.077386e-003f,  4.104346e-004f, -2.896727e-003f, -2.724457e-003f, -4.388977e-003f, -5.826317e-003f, -4.420918e-003f,
  -1.992886e-003f,  6.383258e-004f,  1.789447e-003f,  1.654596e-004f, -4.062213e-003f, -3.611902e-003f, -2.935371e-003f, -4.157130e-003f,
  -3.559746e-003f, -3.879561e-003f, -4.924526e-003f, -4.059683e-003f, -3.868273e-003f, -3.907944e-003f, -3.955175e-003f, -3.021897e-003f,
  -3.379835e-004f,  1.606110e-003f,  4.522581e-004f, -2.335090e-004f,  3.066109e-004f, -9.420606e-004f, -1.255661e-003f, -1.087629e-003f,
   2.877828e-004f,  8.915608e-004f,  7.837533e-003f,  2.109010e-002f,  3.045399e-002f,  3.072114e-002f,  2.365193e-002f,  1.335865e-002f,
   3.951853e-003f, -6.830873e-004f, -3.144514e-003f, -1.874359e-003f,  3.787325e-003f,  8.722979e-003f,  1.225489e-002f,  9.525533e-003f,
   2.502745e-003f, -3.452921e-003f, -9.265521e-003f, -1.491120e-002f, -2.032602e-002f, -1.596413e-002f, -6.303827e-003f,  4.580170e-003f,
   1.076889e-002f,  9.549722e-003f,  5.639323e-003f, -6.201652e-005f,  1.970318e-004f,  2.308161e-003f,  1.645804e-003f, -4.362494e-004f,
   5.557216e-006f,  4.424224e-003f,  5.413345e-003f,  4.732487e-003f,  7.240760e-004f, -4.043376e-003f, -8.958315e-003f, -1.082781e-002f,
  -8.522853e-003f, -6.913119e-003f, -5.157671e-003f, -4.331409e-003f, -3.151716e-003f, -2.789231e-003f, -2.425338e-003f, -2.343020e-003f,
  -4.318916e-003f, -5.764460e-003f, -7.138462e-003f, -5.899116e-003f, -3.907498e-003f, -7.137558e-003f, -5.913046e-003f, -3.927327e-003f,
  -5.557439e-003f, -6.438483e-003f, -3.263603e-003f, -6.988357e-003f, -8.130184e-003f, -2.480335e-004f, -2.666449e-003f, -2.965978e-003f,
   3.032120e-003f, -6.342900e-004f, -5.157196e-003f, -6.083162e-003f, -6.850594e-003f, -7.906633e-003f, -1.521585e-003f, -4.913476e-003f,
   2.118390e-003f,  6.984083e-003f, -2.469163e-003f, -5.075681e-003f, -1.941858e-002f, -2.085971e-002f, -2.143810e-002f, -2.083534e-002f,
  -5.565729e-003f, -5.296824e-003f, -1.488138e-004f,  6.515674e-003f,  3.965222e-003f, -7.162397e-003f, -7.249524e-003f, -2.470278e-003f,
  -1.503141e-003f,  3.248260e-003f, -2.626477e-003f, -6.228810e-003f, -7.181648e-003f, -5.827773e-003f, -4.666533e-003f, -2.021806e-003f,
   1.014660e-002f,  3.749786e-002f,  5.936675e-002f,  7.722218e-002f,  6.336470e-002f,  4.282787e-002f,  2.893824e-002f, -3.704548e-003f,
  -2.798372e-002f, -2.954072e-002f, -1.296015e-002f,  3.978561e-003f,  1.072431e-002f,  9.739071e-003f,  1.107510e-002f,  1.076039e-002f,
   8.221126e-004f, -1.119623e-004f, -6.808420e-003f, -3.628025e-003f, -1.242741e-003f,  2.612695e-003f,  1.070407e-002f,  1.263542e-002f,
   1.468759e-002f,  4.148538e-003f, -1.747366e-004f, -7.121097e-003f, -5.954631e-003f, -3.695365e-003f, -8.049458e-003f, -1.066460e-002f,
  -8.250979e-003f,  4.146860e-004f,  2.659261e-003f,  1.593521e-003f,  5.313269e-004f, -1.373818e-003f,  1.301078e-003f, -2.293277e-003f,
  -3.899532e-004f, -2.089716e-003f,  1.068414e-004f, -4.836341e-003f, -5.502035e-003f, -5.044011e-003f, -6.653684e-003f, -6.332434e-004f,
  -2.975789e-003f, -2.482289e-003f, -3.417765e-003f, -3.948098e-003f, -3.691369e-003f, -5.544974e-003f, -6.388330e-003f, -7.027011e-003f,
  -4.106430e-003f, -3.939358e-003f, -3.496204e-003f, -4.788799e-003f, -9.532476e-003f, -9.271120e-003f, -1.317934e-002f, -1.026689e-002f,
  -8.672871e-003f, -4.930504e-003f, -3.712555e-003f, -4.128560e-003f, -4.622034e-003f, -6.796293e-003f, -4.335356e-003f, -5.736277e-003f,
  -2.546149e-003f, -3.042671e-003f, -3.675545e-003f, -4.464365e-003f, -4.563546e-003f, -4.708837e-003f, -7.052025e-003f, -5.204155e-003f,
  -7.123571e-003f, -2.227911e-003f, -1.923878e-003f, -3.803106e-003f, -4.851183e-003f, -4.156966e-003f, -3.408369e-003f, -2.650395e-003f,
  -3.903942e-003f, -4.014331e-003f,  3.981671e-004f,  8.706686e-003f,  1.140635e-002f,  9.506373e-003f,  1.088609e-002f,  1.221705e-002f,
   1.338695e-002f,  1.250322e-002f,  6.096462e-003f,  6.223441e-003f,  1.424700e-002f,  2.061324e-002f,  2.113804e-002f,  3.933866e-003f,
  -1.360212e-002f, -1.742111e-002f, -9.079923e-003f,  5.220033e-003f,  1.960087e-002f,  2.041243e-002f,  1.416367e-002f,  2.670874e-003f,
  -5.849939e-003f, -9.789108e-003f, -1.051742e-002f, -4.055961e-003f,  6.573574e-003f,  7.338371e-003f,  9.333031e-003f,  1.282616e-002f,
   5.568697e-003f,  1.378220e-003f,  1.487570e-003f,  2.786174e-004f,  3.099740e-003f,  3.416137e-003f,  2.693159e-003f, -1.928935e-003f,
  -1.024743e-003f, -3.557927e-003f, -3.318456e-003f, -3.252949e-003f, -4.040490e-003f, -4.671909e-003f, -9.689360e-004f,  3.172309e-003f,
   6.248623e-003f,  1.141092e-002f, -9.872350e-003f, -1.594378e-002f, -1.382567e-002f, -3.620235e-003f, -2.496739e-003f, -1.199631e-003f,
  -4.258811e-003f, -6.175514e-003f,  2.504902e-003f,  4.134779e-003f, -5.913068e-004f, -1.418147e-002f, -2.320732e-002f, -2.039972e-002f,
  -9.384265e-003f, -6.608490e-004f, -2.856142e-003f, -6.171378e-003f, -7.547302e-003f, -4.651492e-003f,  1.048612e-002f,  2.387578e-002f,
   3.723029e-002f,  2.705639e-002f,  7.893217e-003f, -1.005339e-002f, -1.598129e-002f, -1.429215e-002f, -5.920662e-003f,  2.186157e-003f,
   2.733813e-003f,  1.041148e-002f,  1.084932e-002f,  1.095530e-002f,  7.663242e-003f,  9.151376e-004f, -4.507258e-003f, -6.127177e-003f,
  -1.814519e-003f,  5.974369e-003f,  1.601883e-002f,  1.667560e-002f,  1.411727e-002f,  5.335568e-003f, -1.507692e-003f,  9.862592e-004f,
   1.840218e-003f,  6.708353e-003f,  3.923212e-003f,  2.751277e-003f,  1.482972e-003f,  1.816996e-003f, -2.015988e-003f, -4.226396e-003f,
  -6.466533e-003f, -5.451556e-003f, -5.737947e-004f, -3.417572e-003f,  3.260732e-003f,  5.225004e-003f,  7.027390e-003f, -4.827294e-004f,
  -1.047020e-002f, -1.046072e-002f, -5.027549e-003f,  6.321160e-003f,  7.716052e-003f,  7.230590e-003f,  7.155292e-004f, -3.278631e-003f,
  -5.071247e-003f, -4.835237e-003f, -4.936921e-004f, -1.860596e-003f,  2.942585e-003f, -1.178981e-003f, -3.910510e-003f, -7.557618e-003f,
  -1.094962e-002f, -5.771782e-003f, -4.538275e-003f,  1.788087e-003f,  8.152142e-004f,  2.793569e-003f,  2.618913e-004f, -4.232765e-003f,
  -5.346500e-003f, -8.795842e-003f, -6.855664e-003f, -8.837451e-003f, -4.964129e-003f, -4.908904e-003f, -2.802471e-003f, -2.726992e-003f,
  -5.364840e-003f, -3.547928e-003f, -4.958799e-003f, -3.040142e-003f,  1.172124e-004f,  5.599873e-003f,  8.457927e-003f,  7.267957e-003f,
   6.974535e-003f,  1.909767e-003f,  4.573410e-004f, -1.473866e-003f,  2.671390e-004f,  1.086995e-003f,  2.298348e-003f,  1.953429e-003f,
   4.765421e-004f,  3.035782e-005f, -1.358479e-003f, -4.823145e-003f, -5.807824e-003f, -4.341658e-003f, -2.909952e-003f,  1.020168e-004f,
   6.085060e-003f,  6.543689e-003f,  4.993114e-003f,  4.951374e-003f,  1.801565e-003f,  1.233780e-003f, -4.990785e-003f, -7.147761e-003f,
  -8.853683e-003f, -6.650726e-003f, -4.236545e-003f, -2.219896e-005f,  3.216850e-004f, -2.670115e-003f, -1.770526e-003f, -4.735295e-003f,
  -8.167960e-003f, -7.236737e-003f, -3.842135e-003f,  2.046764e-003f,  3.792737e-003f,  5.461967e-003f, -2.812141e-003f,  1.299174e-002f,
   2.473524e-002f,  2.731882e-002f,  2.233598e-002f,  7.194315e-003f,  9.797509e-003f,  1.178522e-002f,  2.748068e-002f,  3.537146e-002f,
   2.589272e-002f, -4.406840e-003f, -2.816202e-002f, -1.979748e-002f, -4.142588e-003f,  8.848838e-003f,  4.093987e-003f, -1.091937e-003f,
   4.445207e-003f,  8.449983e-003f,  1.505689e-002f,  8.644344e-003f, -2.274715e-004f, -1.099707e-002f, -8.568365e-003f, -3.949686e-003f,
  -7.176403e-004f,  1.228892e-003f, -3.173868e-003f,  2.387542e-003f,  1.503513e-003f,  8.833823e-004f, -5.866085e-003f, -1.000003e-002f,
  -9.927270e-003f, -8.991557e-003f, -1.363557e-003f, -1.182315e-003f,  3.399852e-003f, -2.566609e-003f, -5.347641e-003f, -2.037949e-003f,
  -1.226686e-003f, -3.443865e-004f, -7.532381e-003f, -9.530204e-003f, -1.247713e-002f, -8.513191e-003f, -6.407300e-003f, -8.587912e-003f,
  -1.246469e-002f, -1.753800e-002f, -1.149900e-002f, -6.382089e-003f, -1.895189e-003f, -5.282457e-003f, -8.595327e-003f, -1.140588e-002f,
  -1.183398e-002f, -7.963088e-003f, -3.273222e-003f,  3.460899e-003f,  2.159941e-003f,  1.799490e-003f, -6.901104e-004f,  7.699350e-004f,
  -2.616904e-003f, -7.027124e-003f, -5.833341e-003f, -6.391955e-003f, -6.845725e-003f, -1.091699e-002f, -1.077215e-002f, -7.791098e-003f,
  -2.905412e-003f, -2.516913e-003f, -1.075147e-003f, -1.875829e-003f, -2.812799e-003f, -4.179168e-003f, -3.851555e-003f, -2.575371e-003f,
  -3.337005e-003f,  1.713576e-003f,  4.812275e-004f, -3.481826e-003f, -9.225192e-003f, -1.361363e-002f, -1.008254e-002f, -5.977864e-003f,
  -3.166522e-003f, -2.756831e-003f,  3.036663e-003f,  1.670565e-004f,  6.412377e-005f,  2.009050e-003f, -6.893178e-004f, -7.698942e-003f,
  -6.639674e-003f, -4.833766e-003f, -6.353585e-003f,  1.378473e-003f, -1.887455e-003f, -4.273058e-003f,  5.305799e-003f,  2.074533e-002f,
   3.574851e-002f,  7.067380e-002f,  4.453263e-002f,  3.942464e-002f,  1.962511e-002f,  2.036087e-002f,  3.432850e-002f,  2.926897e-002f,
   4.633366e-002f,  1.878545e-002f,  2.972866e-003f, -2.912336e-002f, -8.029973e-003f,  5.694340e-003f,  1.450451e-002f,  3.383993e-003f,
  -2.002009e-002f, -1.565938e-002f, -1.140330e-002f,  1.879992e-002f,  8.507826e-004f, -5.147410e-003f, -1.648485e-002f, -1.688311e-002f,
   1.123824e-002f,  2.749508e-003f,  9.992656e-003f, -6.909623e-003f, -1.364950e-002f, -1.493484e-002f, -4.958398e-003f,  3.632685e-003f,
  -6.044398e-003f,  1.798287e-003f, -9.468188e-003f, -3.214377e-003f, -1.664227e-002f, -2.255771e-002f, -2.536483e-002f, -2.153378e-002f,
  -5.791524e-003f, -5.053370e-003f,  5.408006e-003f, -9.767205e-003f, -2.309080e-003f,  1.146496e-003f,  1.397545e-003f,  5.802354e-004f,
  -1.583850e-002f, -1.259103e-002f, -1.273188e-002f,  6.601680e-003f,  1.167219e-002f,  3.655284e-003f, -3.825660e-003f, -1.102736e-002f,
  -1.233226e-003f,  2.366763e-003f,  1.233662e-002f,  4.329038e-003f,  9.689504e-003f,  7.985687e-003f,  1.649618e-003f,  6.339099e-003f,
  -5.737208e-003f, -3.032363e-003f, -1.429352e-002f, -1.165518e-002f, -1.400306e-002f, -1.092382e-002f, -1.340776e-003f,  4.555866e-003f,
   1.727009e-002f,  1.055395e-002f,  9.173880e-003f,  2.111171e-003f, -9.550980e-004f,  1.620080e-003f,  1.394933e-003f,  5.326075e-003f,
  -8.763903e-003f, -1.241742e-002f, -1.421528e-002f, -6.735478e-003f,  3.188656e-003f, -2.395927e-004f, -3.447729e-003f, -1.377339e-002f,
  -1.002541e-002f, -9.289527e-003f,  3.977940e-003f,  1.797898e-002f,  4.266451e-002f,  4.882814e-002f,  3.672285e-002f,  5.908747e-003f,
  -1.594626e-002f, -1.705415e-002f, -4.956972e-003f,  1.820915e-002f,  2.127735e-002f,  1.778010e-002f,  5.067227e-003f,  9.277030e-003f,
   8.032438e-003f,  9.357247e-003f,  3.589103e-003f, -7.649220e-004f,  6.292564e-003f,  1.372827e-002f,  2.616448e-002f,  1.992509e-002f,
   4.081790e-003f, -1.567006e-002f, -1.836898e-002f, -9.047654e-003f, -8.367263e-004f,  7.020779e-003f,  4.818595e-003f,  3.359217e-003f,
  -4.121405e-003f,  3.679156e-003f, -2.433215e-004f, -2.100625e-003f, -1.076198e-002f, -2.167879e-002f, -1.143803e-002f, -5.617605e-003f,
   2.097176e-003f,  2.152447e-003f,  6.965940e-003f,  4.762845e-003f,  5.382116e-003f,  5.486613e-003f, -3.636072e-003f, -3.018540e-003f,
  -8.044913e-003f, -1.080203e-003f,  3.793512e-003f,  4.412777e-003f,  3.559818e-003f, -1.251522e-003f, -3.596216e-003f, -7.344898e-003f,
  -5.122099e-004f, -5.260240e-003f, -7.894419e-003f, -1.033272e-002f, -6.057914e-003f,  5.984444e-003f,  6.191242e-003f,  8.010483e-003f,
   2.728894e-003f,  9.884252e-004f, -2.287719e-003f, -2.759909e-003f,  5.963530e-004f, -2.130313e-003f, -6.684395e-004f, -2.395753e-003f,
   1.005892e-003f,  4.107869e-004f,  1.496963e-003f,  7.232548e-004f, -3.909534e-003f, -9.822958e-003f, -1.537218e-002f, -1.177064e-002f,
  -1.223239e-002f, -7.630307e-003f, -3.702092e-003f, -4.791239e-003f, -2.990296e-003f, -8.301501e-003f, -8.913337e-003f, -8.008295e-003f,
  -2.654290e-004f,  5.279543e-003f,  4.769253e-003f,  4.926244e-003f,  2.847670e-003f,  4.101337e-003f, -1.691498e-004f, -8.400558e-003f,
  -1.028863e-002f, -8.384028e-003f, -1.835037e-003f,  9.694467e-004f, -1.808983e-003f, -4.858394e-003f, -3.915398e-003f, -1.718302e-005f,
   5.012722e-003f,  5.690931e-003f,  1.391570e-003f, -2.292907e-003f, -4.656981e-003f, -3.668685e-003f, -4.882797e-003f,  8.393247e-004f,
   1.307166e-003f,  2.202280e-003f,  1.742281e-003f,  9.936566e-004f, -1.331995e-003f,  4.276231e-004f, -2.460017e-003f, -2.571850e-003f,
  -7.461848e-004f, -1.979941e-003f,  2.605876e-003f, -1.655896e-003f, -7.146336e-003f, -6.138913e-003f, -4.436894e-003f, -4.632230e-003f,
  -3.273384e-003f, -6.758389e-003f, -7.216814e-003f, -4.335509e-003f, -4.831324e-003f, -4.624392e-003f, -4.061620e-003f, -1.426999e-003f,
  -3.485692e-006f, -1.993136e-003f, -5.266549e-003f, -1.103580e-002f, -5.272718e-003f, -1.663705e-003f,  1.240944e-003f,  3.915766e-004f,
  -2.267902e-003f, -3.393427e-003f, -3.257292e-003f, -7.503507e-004f,  2.124517e-003f,  3.388329e-003f, -9.155754e-004f, -1.091565e-002f,
  -1.520749e-002f, -1.822004e-002f, -1.500687e-002f, -1.129687e-002f, -4.506040e-003f, -1.801908e-003f,  9.648925e-003f,  2.720221e-002f,
   2.614998e-002f,  2.244398e-002f, -3.263200e-004f, -1.003072e-002f, -1.879182e-002f, -7.738415e-003f,  1.334219e-002f,  3.322010e-002f
};

static const float VastImpulseRight3[] =
{
  -1.422465e-004f,  2.464512e-004f, -1.763397e-004f,  2.748711e-004f, -3.236529e-004f,  2.224418e-004f, -4.649247e-004f,  1.329177e-004f,
  -6.973312e-004f, -4.991882e-004f, -4.711187e-003f, -4.694468e-003f, -5.013265e-003f, -5.189376e-003f, -2.437212e-003f,  3.086842e-003f,
   2.389184e-003f,  5.736766e-003f,  2.466525e-003f, -1.586711e-003f, -3.215757e-003f, -1.014813e-002f, -1.190385e-002f, -1.123832e-002f,
  -1.219548e-002f, -9.371679e-003f, -8.458270e-003f, -6.528286e-003f, -6.928598e-003f, -4.203138e-003f, -1.046522e-002f, -7.001016e-003f,
  -6.463117e-003f, -6.179627e-003f, -4.224584e-003f, -2.246638e-003f, -2.516373e-003f, -3.636748e-003f, -1.945715e-003f, -3.718251e-003f,
  -2.723863e-003f, -4.412316e-003f, -6.600540e-003f, -4.317167e-003f, -6.283921e-003f, -5.332238e-003f, -6.949566e-003f, -5.456967e-003f,
  -5.444004e-003f, -4.952993e-003f, -2.635561e-003f, -5.144258e-003f, -1.159197e-003f, -6.141009e-003f, -2.810971e-003f, -6.162869e-003f,
  -1.731915e-003f, -6.502052e-003f, -2.266924e-003f, -4.059385e-003f, -3.096082e-003f, -1.306099e-003f, -3.082879e-003f, -4.034821e-003f,
  -2.190135e-003f, -6.900982e-003f, -2.063810e-003f, -7.722813e-003f,  1.513757e-003f, -7.356796e-003f,  3.654173e-003f, -7.377210e-003f,
   4.177389e-003f, -6.298833e-003f,  1.511752e-003f, -5.422790e-003f,  3.778520e-003f, -4.718395e-003f,  7.899521e-003f, -1.092210e-002f,
   2.221511e-002f, -3.649481e-002f,  2.917413e-001f,  2.113836e-001f,  4.086287e-002f,  4.045840e-001f, -2.615126e-002f, -1.461896e-001f,
  -1.392469e-001f, -2.004606e-001f, -1.557164e-001f, -1.107148e-001f, -2.004529e-002f,  1.529778e-001f,  1.505145e-001f, -4.814251e-003f,
   1.132755e-001f,  3.023533e-002f, -1.013882e-001f, -5.137758e-002f, -9.056010e-002f, -2.755478e-002f,  1.203761e-001f,  1.159612e-001f,
  -8.667227e-003f,  6.599544e-002f, -3.203513e-002f, -8.770371e-002f, -2.593269e-002f, -4.379817e-002f, -3.292228e-002f, -8.020419e-002f,
   2.032442e-002f,  2.561287e-002f,  6.354611e-002f,  1.811483e-002f, -1.964987e-004f,  1.122266e-002f, -3.369536e-002f,  5.943126e-003f,
  -3.461441e-002f,  2.899183e-003f,  8.404093e-003f,  7.620271e-003f,  1.312170e-002f,  6.086740e-003f,  2.255618e-002f, -3.051761e-002f,
   5.049442e-003f, -2.390119e-002f, -1.881166e-003f, -2.925507e-003f, -1.768915e-002f, -1.172224e-002f, -1.128742e-002f,  2.637382e-003f,
  -1.475871e-002f,  1.603876e-002f, -5.884644e-003f, -3.758270e-003f, -6.684549e-003f, -1.975905e-002f,  1.276473e-002f, -1.587011e-002f,
  -5.582558e-003f,  2.904619e-003f,  1.498731e-002f, -1.930630e-003f,  3.145612e-003f,  9.813708e-003f, -5.827218e-003f, -5.834387e-003f,
  -2.631428e-002f,  4.916697e-004f, -3.153601e-003f, -4.926213e-003f, -1.561144e-003f,  1.755028e-003f,  2.696536e-003f, -5.958184e-003f,
   4.512413e-003f, -2.785513e-003f,  2.942186e-003f, -3.714348e-003f, -4.669327e-003f,  5.554242e-003f, -1.605091e-003f,  4.194486e-003f,
  -2.228895e-003f,  3.142933e-003f, -3.752067e-003f, -2.291406e-003f, -1.054547e-003f, -1.042522e-003f,  4.866788e-004f, -4.613046e-003f,
  -2.412626e-004f,  3.251486e-004f,  3.701341e-003f,  3.287985e-003f, -2.408885e-003f, -3.489200e-003f, -1.547382e-003f, -1.467411e-003f,
  -5.170974e-004f,  3.781329e-003f,  3.225565e-003f,  9.220893e-003f,  5.681869e-003f,  3.236437e-003f,  2.168259e-003f, -2.241060e-003f,
  -5.755072e-003f, -3.484154e-003f, -1.280393e-003f,  3.567285e-003f,  4.239501e-003f,  3.781492e-003f,  6.286887e-003f,  2.544819e-003f,
  -1.028660e-003f, -1.105606e-003f,  2.896011e-003f, -1.779404e-004f, -1.407012e-003f,  6.262135e-003f,  5.241851e-003f,  4.636422e-003f,
   3.123711e-003f,  7.906045e-004f,  1.350552e-003f, -8.416766e-004f, -4.959142e-004f, -7.097489e-004f,  1.012181e-003f, -4.183907e-003f,
  -8.310073e-004f, -1.168849e-003f, -1.822807e-003f, -1.567010e-004f, -1.822465e-003f,  1.532891e-003f,  1.147303e-003f,  1.387460e-003f,
   2.167028e-004f,  6.815928e-004f,  1.017074e-003f, -2.199629e-003f, -1.358187e-004f, -1.287397e-003f, -9.903794e-005f, -1.822900e-003f,
  -1.971153e-003f,  7.509860e-004f, -1.525980e-003f, -2.333841e-003f, -4.338717e-003f, -3.496075e-003f, -4.803284e-003f, -2.934311e-003f,
  -1.233237e-003f,  7.856083e-004f,  3.187867e-003f,  1.295580e-003f,  2.249068e-004f, -8.664509e-004f, -3.002414e-003f, -5.312501e-003f,
  -5.922434e-003f, -7.623674e-003f, -7.774357e-003f, -5.837902e-003f, -4.217076e-003f, -1.367088e-003f, -2.176734e-003f, -1.519555e-003f,
   1.952052e-003f,  1.533488e-003f,  1.713257e-003f,  2.440517e-003f,  1.676686e-003f, -9.162429e-004f, -1.820830e-003f, -1.965739e-003f,
  -1.795292e-003f, -5.748975e-005f,  7.394138e-003f,  2.062377e-002f,  2.680124e-002f,  2.621582e-002f,  2.261749e-002f,  1.232275e-002f,
   3.450851e-003f, -1.431220e-003f, -3.997973e-003f, -2.763534e-003f, -2.363303e-003f,  1.497107e-003f,  8.089654e-003f,  8.318852e-003f,
   4.299996e-003f, -1.367908e-003f, -7.302270e-003f, -1.328993e-002f, -1.529630e-002f, -1.282699e-002f, -6.686162e-003f,  8.187751e-004f,
   5.074782e-003f,  6.844558e-003f,  5.845416e-003f,  3.702484e-003f,  3.663919e-004f, -3.227829e-003f, -4.944088e-003f, -5.331965e-003f,
  -3.918860e-003f, -1.165374e-003f,  1.653123e-003f,  3.471328e-003f,  2.028845e-003f, -4.838806e-004f, -3.420085e-003f, -5.063831e-003f,
  -5.917284e-003f, -6.343646e-003f, -5.854531e-003f, -3.497593e-003f, -2.073249e-003f, -9.948503e-004f, -5.775080e-005f,  4.721900e-004f,
  -1.017286e-003f, -2.401130e-003f, -4.138496e-003f, -4.602027e-003f, -5.542451e-003f, -5.768522e-003f, -3.920790e-003f, -2.850592e-003f,
  -5.056472e-003f, -3.630319e-003f, -2.058664e-003f, -4.103870e-003f, -1.678904e-003f,  1.208161e-003f, -9.521825e-004f,  4.636221e-004f,
   1.426406e-003f, -1.206788e-003f, -5.295193e-003f, -4.275822e-003f, -3.449148e-003f, -8.912108e-003f,  6.717234e-004f,  2.773966e-003f,
   4.687593e-003f,  3.859088e-003f,  6.738260e-004f, -1.534762e-002f, -1.417031e-002f, -1.624494e-002f, -2.298297e-002f, -6.920803e-003f,
  -6.109622e-003f,  4.300023e-004f,  1.275469e-003f,  3.145960e-003f,  2.929506e-003f,  2.252188e-002f,  3.653800e-002f,  4.625096e-002f,
   4.467211e-002f,  1.123144e-002f,  3.710959e-003f, -2.397584e-002f, -2.206084e-002f, -1.920583e-002f, -5.860431e-003f,  1.773196e-002f,
   6.980279e-003f,  9.949493e-003f, -2.529909e-003f,  1.558009e-002f,  2.226925e-002f,  3.123513e-002f,  2.583936e-002f,  6.226435e-003f,
  -3.155088e-003f, -2.295140e-002f, -1.310740e-002f, -1.309663e-002f, -3.675174e-003f, -5.518773e-003f, -8.239244e-003f, -5.716716e-003f,
  -7.040020e-003f,  2.475083e-003f, -1.191819e-002f, -1.380428e-002f, -2.307729e-002f, -1.659138e-002f,  1.598567e-003f,  9.475032e-003f,
   1.643554e-002f,  4.373770e-003f,  3.321454e-003f, -1.583917e-003f,  1.435755e-003f,  1.710977e-003f, -1.579358e-004f, -2.624561e-004f,
  -2.422808e-003f,  4.124348e-003f,  5.395097e-003f,  1.291592e-002f,  1.318657e-002f,  8.238633e-003f,  3.670923e-003f, -6.169700e-004f,
  -9.471878e-004f, -2.433747e-003f, -6.243237e-004f, -3.327829e-003f, -2.824476e-003f,  1.654480e-003f,  2.216709e-003f,  3.847351e-003f,
  -2.102203e-004f,  1.097801e-003f,  1.734899e-004f,  1.829072e-004f, -2.779269e-003f, -6.657241e-003f, -5.240475e-003f, -4.447512e-003f,
  -2.068890e-003f, -4.053296e-003f, -8.286761e-004f, -3.632765e-003f, -5.665591e-003f, -7.645250e-003f, -1.035599e-002f, -8.122823e-003f,
  -6.619041e-003f, -4.243972e-003f, -2.330570e-003f, -9.097177e-004f, -1.445954e-003f, -1.454878e-003f, -2.160119e-003f, -5.227146e-003f,
  -6.460462e-003f, -5.740744e-003f, -1.697935e-004f, -1.084170e-003f, -3.773434e-003f, -7.958726e-003f, -8.001774e-003f,  1.180708e-003f,
  -2.587884e-004f,  6.923708e-003f,  4.172649e-003f,  6.125463e-003f,  8.762434e-004f, -4.262420e-003f,  1.315004e-003f, -3.833161e-003f,
   8.120161e-003f,  1.005964e-002f,  6.161710e-003f, -6.953754e-003f, -9.969091e-003f, -5.604636e-003f,  4.408898e-003f,  1.719839e-002f,
   9.851915e-003f,  3.505801e-003f, -6.022891e-003f, -8.491830e-003f, -4.694385e-003f,  3.334838e-003f,  7.246932e-003f,  3.470325e-003f,
   2.923187e-003f, -6.822112e-003f, -2.183220e-003f,  1.749983e-003f,  2.238507e-003f,  2.586870e-003f, -4.727848e-004f,  2.388741e-003f,
   1.468344e-003f,  4.246307e-003f,  1.435634e-003f,  3.982668e-003f,  8.151576e-004f,  1.302405e-003f,  2.893466e-003f,  1.000991e-003f,
   1.648044e-004f, -1.462933e-003f,  3.460433e-003f,  5.477891e-003f,  5.383729e-003f,  2.500834e-003f,  1.611084e-003f,  2.884665e-003f,
   1.720326e-003f,  2.271711e-003f, -1.306856e-003f, -1.243437e-003f, -3.721422e-003f, -3.567519e-003f, -3.230526e-003f,  1.964491e-003f,
   7.027847e-003f,  2.698938e-003f, -2.301103e-003f, -1.174506e-002f, -7.881173e-003f, -5.532157e-003f, -4.207246e-003f, -4.449796e-003f,
  -8.291855e-003f, -6.160437e-003f,  3.805376e-004f,  4.794676e-003f,  6.759437e-003f,  4.809331e-004f, -5.778646e-003f, -3.024294e-003f,
   1.386775e-002f,  2.580151e-002f,  2.180218e-002f,  4.677685e-003f, -5.422995e-003f, -7.996101e-003f, -3.136780e-003f,  7.570144e-003f,
   9.449814e-003f,  6.672936e-003f, -1.753226e-003f, -6.725054e-003f, -7.917767e-003f, -3.799545e-003f,  3.739905e-003f, -1.492832e-003f,
  -7.607220e-003f, -1.265526e-002f, -7.373623e-003f, -1.536305e-003f, -8.015180e-004f, -1.828153e-003f, -7.665172e-003f, -1.082099e-003f,
   6.599111e-004f,  1.081766e-002f,  1.006875e-002f,  1.142988e-002f,  5.891890e-003f,  2.658154e-003f,  2.952380e-003f,  7.620099e-003f,
   1.240092e-002f,  8.227778e-003f,  3.350004e-003f, -3.193799e-003f, -3.868089e-003f, -3.410450e-003f, -1.365377e-003f,  6.382938e-004f,
  -8.110324e-005f,  2.198732e-003f,  2.647938e-003f,  2.702350e-003f,  2.112277e-003f, -2.224176e-003f, -5.640795e-003f, -1.325108e-002f,
  -9.470742e-003f, -4.905301e-003f,  5.974732e-003f,  9.534679e-003f,  9.759573e-003f,  5.781837e-003f,  3.398061e-003f,  2.805547e-003f,
  -5.494848e-004f, -1.685131e-003f, -2.572144e-003f, -5.056126e-004f,  8.886467e-004f, -5.280312e-004f, -2.968925e-003f, -5.588654e-003f,
  -4.223335e-003f, -2.955076e-003f, -3.597805e-004f,  7.997313e-004f,  7.605420e-004f, -8.763100e-004f, -3.779720e-003f, -3.515878e-003f,
  -4.393279e-003f, -2.986589e-003f, -5.201620e-003f, -4.850957e-003f, -3.973717e-003f, -3.022444e-003f, -3.786743e-003f, -3.209707e-003f,
  -2.356197e-003f, -3.182946e-003f, -2.067358e-003f, -9.985624e-004f,  2.595761e-003f,  2.715773e-003f,  1.536954e-003f,  1.314679e-003f,
  -1.341664e-003f, -2.686670e-003f, -4.813719e-003f, -2.931102e-003f, -1.736655e-003f, -1.489840e-004f,  1.400046e-003f,  1.003594e-003f,
  -1.040192e-003f, -6.190839e-003f, -8.274367e-003f, -6.649402e-003f, -7.187831e-003f, -5.264772e-003f,  3.264690e-003f,  2.986134e-003f,
   4.234842e-003f,  5.276132e-003f,  3.896821e-003f,  3.275110e-003f, -1.500593e-003f, -5.823132e-004f, -1.017670e-003f, -1.725560e-003f,
  -4.897574e-003f, -4.414696e-003f, -2.249110e-003f, -2.395393e-003f,  9.411922e-004f,  4.162795e-003f,  5.158871e-003f,  1.921638e-003f,
   8.783444e-004f, -6.050836e-004f, -4.614778e-004f,  1.388460e-003f, -1.187864e-003f, -1.475137e-003f, -6.259696e-003f, -4.724155e-003f,
  -8.378216e-004f,  8.417531e-003f,  2.034792e-002f,  2.609824e-002f,  2.369007e-002f,  3.158034e-002f,  5.041176e-002f,  3.656724e-002f,
   1.987342e-002f, -5.894167e-003f, -1.395256e-002f, -2.392631e-002f, -3.706321e-002f, -7.619675e-003f,  1.580496e-002f,  7.343916e-003f,
  -1.656097e-003f,  1.058968e-002f,  7.128574e-003f, -5.290989e-005f, -6.917117e-004f, -5.608212e-003f, -8.211661e-003f, -1.048007e-002f,
  -7.604408e-003f, -4.171558e-003f,  1.727439e-003f,  5.146265e-003f,  3.861881e-004f,  7.221198e-004f,  2.275263e-003f, -1.851123e-003f,
  -9.987663e-003f, -7.422439e-003f, -4.492642e-003f, -4.792241e-003f, -2.027861e-003f,  9.415420e-005f,  3.341350e-003f,  4.236341e-004f,
  -1.650115e-003f, -4.919296e-003f, -5.541949e-003f, -6.860037e-003f, -9.735819e-003f, -7.450641e-003f, -6.935863e-003f, -3.747819e-003f,
  -5.479884e-003f, -6.778363e-003f, -8.591970e-003f, -1.038703e-002f, -1.053335e-002f, -1.209044e-002f, -9.807857e-003f, -9.152492e-003f,
  -5.892788e-003f, -4.952703e-003f, -4.749899e-003f, -2.812358e-003f, -4.056599e-003f, -2.380117e-003f, -2.342176e-003f,  3.041126e-003f,
   4.542756e-003f,  3.519061e-003f,  2.653215e-003f, -2.116950e-003f, -2.975563e-003f, -7.962652e-003f, -9.546760e-003f, -9.931379e-003f,
  -5.885289e-003f, -1.315076e-003f, -1.145377e-003f, -1.544145e-003f, -1.357446e-003f,  1.717114e-004f,  6.375260e-004f, -9.654603e-004f,
  -1.403764e-003f, -6.328003e-004f, -1.794636e-003f, -7.786876e-003f, -5.331312e-003f, -3.792604e-003f, -3.036083e-003f, -4.799850e-003f,
  -8.243038e-003f, -3.629143e-003f, -8.936556e-003f, -5.361189e-003f,  1.294556e-003f,  1.876603e-003f,  1.218818e-002f,  1.286919e-002f,
   7.536210e-003f, -3.723663e-003f, -6.284092e-003f, -5.659088e-003f, -9.802393e-003f,  2.534802e-002f,  5.302355e-002f,  6.313333e-002f,
   4.006036e-002f,  1.424759e-002f, -4.056265e-003f, -2.231546e-002f, -1.272482e-002f, -6.149569e-003f,  3.786764e-003f, -1.518302e-002f,
  -1.479388e-002f,  5.281124e-003f,  1.795179e-002f,  2.799957e-002f,  9.431058e-003f,  2.982985e-003f,  1.836578e-003f,  6.305704e-003f,
   1.259800e-002f,  9.112326e-003f, -3.677047e-003f, -1.939429e-002f, -3.914889e-003f,  8.541163e-003f,  1.026816e-002f,  1.136126e-003f,
  -5.712922e-003f, -6.650879e-003f, -1.098962e-002f,  2.295186e-003f,  8.580227e-003f,  5.575950e-003f, -7.968647e-003f, -5.809536e-003f,
  -4.955480e-003f, -5.097519e-003f,  1.809301e-003f, -9.499012e-003f, -9.512942e-003f, -1.043177e-002f, -7.030847e-003f, -5.297233e-003f,
  -2.462341e-003f, -2.055896e-003f, -2.070349e-003f,  5.290117e-003f,  1.692665e-003f,  3.430724e-003f, -8.498939e-003f, -2.100661e-003f,
  -2.597807e-003f, -1.328869e-003f,  3.932749e-003f, -5.611343e-004f,  9.897747e-003f,  5.817314e-003f,  9.676915e-003f,  4.926563e-003f,
  -2.830994e-003f, -1.592406e-002f, -2.045218e-002f, -1.826441e-002f, -1.567948e-002f, -7.075292e-003f, -6.762216e-003f,  3.783129e-003f,
   7.996362e-003f,  5.958146e-003f,  2.876838e-003f, -3.118966e-003f,  1.464815e-003f,  3.117119e-003f,  2.963767e-003f,  1.998577e-003f,
   5.324530e-003f,  7.755837e-003f,  3.400926e-003f,  1.147164e-004f, -6.615994e-003f, -5.489830e-003f, -5.953985e-003f, -4.037089e-003f,
  -4.576037e-003f, -2.554600e-003f,  4.025159e-003f,  1.176369e-002f,  2.230902e-002f,  1.467259e-002f,  2.877001e-003f, -1.023438e-002f,
  -7.480842e-003f,  5.359668e-004f,  9.318185e-003f,  2.267515e-002f,  2.086927e-002f,  1.776794e-002f,  6.931422e-003f,  9.323300e-004f,
  -7.746099e-004f,  3.514416e-003f,  2.384220e-003f, -5.157827e-003f, -4.266343e-003f, -4.748724e-003f,  4.009407e-003f,  6.757247e-003f,
   7.908442e-003f,  3.896086e-003f, -4.918522e-003f, -1.284947e-003f,  2.007680e-003f,  8.977712e-003f,  7.147341e-003f,  2.053433e-003f,
  -9.898091e-004f,  1.369946e-003f,  8.638718e-003f,  8.301385e-003f,  9.697646e-003f,  1.784808e-003f, -2.582031e-003f, -3.568617e-003f,
  -3.082899e-003f, -1.270020e-003f, -1.601795e-003f,  1.540086e-003f,  2.996042e-004f, -2.216920e-004f, -7.466957e-003f, -9.086111e-003f,
  -6.988764e-003f, -7.126802e-003f, -2.817460e-003f, -2.447787e-003f,  5.696023e-004f, -3.182594e-004f, -3.985042e-003f, -3.095251e-003f,
   6.044223e-004f,  2.559519e-003f,  3.423646e-003f,  4.437924e-003f,  2.502301e-003f, -1.792679e-003f, -6.337515e-003f, -8.938389e-003f,
  -8.343226e-003f, -4.293475e-003f, -1.586257e-003f, -7.795943e-004f,  4.778988e-005f,  1.792327e-003f,  7.444896e-004f, -6.034346e-004f,
  -3.104700e-003f, -2.627864e-003f, -5.023460e-003f, -4.241714e-003f, -3.038817e-003f, -4.535645e-003f, -3.254885e-003f, -5.231000e-003f,
  -3.190130e-003f, -5.234278e-003f, -2.876128e-003f, -2.368518e-003f, -3.078977e-003f, -3.075032e-004f, -9.246181e-004f, -5.116873e-004f,
  -3.670152e-003f, -3.848384e-003f, -3.780018e-003f, -4.671126e-003f, -4.519794e-003f, -2.171164e-003f,  9.612724e-004f,  9.346973e-004f,
   1.502488e-003f,  5.085301e-004f, -3.268095e-003f, -4.458338e-003f, -6.283548e-004f,  5.301334e-003f,  8.419348e-003f,  8.862677e-003f,
   6.240064e-003f,  8.630960e-004f, -1.736809e-003f, -1.309307e-003f, -1.154797e-003f, -4.011789e-003f, -4.027453e-003f, -6.010909e-004f,
   3.717716e-003f,  4.689050e-003f,  7.696046e-004f, -2.588598e-003f, -5.980038e-003f, -4.498432e-003f,  1.333893e-005f,  3.105884e-003f,
   6.168186e-003f,  5.587583e-003f,  4.216258e-003f,  2.095712e-003f,  3.306668e-003f,  2.252906e-003f, -5.014886e-004f, -6.097506e-003f,
  -8.797676e-003f, -5.215108e-003f, -2.037842e-003f, -6.953657e-004f, -1.455062e-003f,  6.119019e-003f,  2.778705e-003f,  2.380852e-003f,
   4.138217e-004f, -5.155035e-003f, -6.240538e-003f, -1.320857e-002f, -1.224693e-002f, -5.679282e-003f, -2.167454e-003f, -3.863829e-003f,
  -6.774166e-004f, -2.904829e-003f, -4.025631e-003f,  1.060032e-003f,  6.575309e-005f,  2.025184e-003f, -5.078190e-003f, -8.256737e-003f,
  -9.038488e-003f, -6.404349e-003f,  1.930190e-003f,  2.745608e-003f,  5.182720e-003f,  2.876312e-003f, -4.851961e-004f, -7.023439e-003f,
  -8.549473e-003f, -8.125068e-003f, -1.002981e-002f, -3.762645e-003f,  1.516623e-002f,  2.934409e-002f,  3.184707e-002f,  1.325663e-002f,
  -1.834959e-003f, -6.108490e-003f, -8.777231e-003f, -3.704030e-003f,  4.231644e-003f,  1.010262e-002f,  2.807830e-003f, -4.165246e-003f
};

static const float VastImpulseLeft4[] =
{
  -9.066710e-004f, -5.606867e-004f, -9.908412e-003f, -1.364886e-002f, -1.233017e-002f, -4.712828e-003f,  3.902346e-003f,  1.357280e-002f,
   4.841977e-003f,  5.506016e-003f, -8.768955e-003f, -1.419911e-002f, -9.738824e-003f, -1.261094e-002f, -1.452950e-002f, -1.554388e-002f,
  -2.027612e-002f, -1.342161e-002f, -1.626453e-002f, -1.319419e-002f, -2.087440e-002f, -8.918939e-003f, -1.633637e-002f, -6.020428e-003f,
  -1.127498e-002f, -8.637501e-003f, -1.650305e-002f, -9.226230e-003f, -1.085589e-002f, -1.116000e-003f, -5.928576e-003f, -2.465416e-003f,
  -7.907040e-003f,  4.605723e-003f, -8.069312e-003f,  3.562601e-003f, -1.055938e-002f, -1.439954e-003f, -1.328865e-002f, -1.055288e-003f,
  -7.474425e-003f, -7.769291e-004f, -6.639518e-003f, -5.453124e-003f, -8.817663e-003f, -3.885365e-003f, -1.040841e-002f, -6.356293e-003f,
  -7.934597e-003f, -4.444252e-003f, -6.073044e-003f, -2.444751e-003f, -9.452713e-003f, -1.418537e-003f, -6.276080e-003f, -3.701673e-003f,
  -2.474131e-003f, -8.024813e-003f,  6.562968e-004f, -1.043565e-002f,  6.757398e-003f, -8.993397e-003f,  1.134843e-002f, -1.537995e-002f,
   7.379976e-003f, -1.786029e-002f,  1.654813e-002f, -2.006842e-002f,  2.957628e-002f, -3.404859e-002f,  5.337118e-002f, -7.500799e-002f,
   1.203256e-001f, -2.083814e-001f,  6.633801e-001f,  7.105959e-001f,  2.031238e-001f,  3.231037e-001f, -4.932112e-001f, -3.415653e-001f,
  -2.516185e-001f, -2.247206e-001f,  3.449164e-001f,  2.684186e-001f, -2.128533e-001f, -1.466790e-001f,  9.948016e-002f,  1.227760e-001f,
  -4.017381e-002f,  1.942057e-002f, -1.786712e-001f, -3.340631e-003f, -3.322509e-002f, -1.723072e-002f, -9.372181e-002f, -6.380806e-002f,
  -6.649147e-002f,  2.043823e-002f,  1.529957e-001f,  1.584071e-002f, -1.298628e-002f, -3.052960e-002f, -1.588065e-003f,  2.678427e-002f,
  -1.125063e-002f,  1.715160e-002f, -4.734825e-002f,  6.516205e-003f, -2.027402e-003f,  1.045932e-002f,  2.354393e-002f, -4.595417e-002f,
  -1.645654e-002f, -1.969445e-002f,  3.386844e-002f, -1.154099e-002f, -1.530219e-003f, -2.896013e-002f, -9.042677e-003f, -4.338928e-004f,
  -5.399407e-003f, -1.181991e-003f, -3.695861e-002f, -1.522401e-002f, -1.807677e-002f, -1.369113e-002f,  2.023261e-002f,  2.995719e-003f,
   2.167880e-002f, -1.457824e-002f, -6.686910e-003f, -1.833551e-002f, -1.243358e-002f, -3.571373e-002f,  6.135138e-003f,  3.215496e-002f,
   1.946769e-003f,  5.102307e-003f,  1.566077e-003f,  2.092250e-002f,  1.827447e-002f, -1.345890e-002f,  9.812533e-004f, -1.305407e-002f,
  -1.162649e-002f, -1.529974e-002f,  1.617662e-002f,  3.239852e-003f, -1.801665e-002f, -1.790101e-002f, -4.822350e-003f,  1.250160e-002f,
   2.622712e-003f,  6.029550e-003f, -4.482819e-003f, -1.262209e-002f, -6.581861e-003f,  2.327218e-003f,  9.745941e-003f, -3.760294e-003f,
  -9.402498e-003f, -2.304179e-003f,  4.954499e-003f,  6.864970e-003f, -4.551803e-003f, -2.232079e-003f, -1.232857e-002f, -2.671699e-004f,
   5.952565e-004f,  4.522152e-003f, -4.472070e-003f, -7.634234e-003f, -6.501395e-003f, -1.042089e-002f,  1.250187e-004f, -4.473079e-003f,
   7.830453e-003f,  7.600054e-003f,  4.299594e-003f,  1.696220e-002f,  6.426360e-003f, -1.007766e-003f, -8.599812e-003f, -9.571394e-003f,
  -4.961417e-003f,  4.026741e-003f,  3.623790e-003f,  8.269066e-003f,  3.239932e-003f, -4.407746e-003f, -3.870761e-003f,  2.840438e-003f,
   3.053329e-003f,  4.576994e-004f,  2.489191e-003f,  6.940094e-003f, -2.037878e-003f,  9.685776e-004f, -3.840582e-003f,  1.862697e-004f,
   3.729442e-003f,  7.341811e-004f,  1.025821e-002f,  7.108358e-003f,  1.171662e-003f, -4.020661e-003f,  1.048266e-003f, -3.515430e-003f,
  -2.156252e-003f, -2.803444e-003f, -4.148071e-003f, -1.646057e-003f, -7.919938e-003f, -5.314055e-003f, -1.690790e-003f, -1.203273e-003f,
  -2.521275e-003f, -7.692308e-003f, -9.302737e-004f, -4.898479e-003f, -8.086463e-004f, -4.580353e-003f, -3.301916e-003f, -9.901841e-004f,
  -6.626845e-003f, -2.538474e-003f, -5.716668e-003f, -3.824823e-003f, -7.910959e-003f, -6.095775e-003f, -6.780077e-004f,  1.107779e-002f,
   2.240753e-002f,  2.792091e-002f,  3.051520e-002f,  1.772291e-002f,  7.791417e-003f,  4.567360e-003f, -3.956459e-003f, -1.769527e-003f,
  -1.504740e-003f,  1.588248e-003f,  1.073433e-003f,  1.039450e-003f, -1.527762e-003f,  1.878415e-003f,  3.841729e-003f, -5.666006e-003f,
  -3.953274e-003f, -4.691203e-003f, -8.668327e-004f, -8.272059e-004f,  3.000018e-004f,  1.113994e-003f, -1.029730e-003f,  2.202525e-003f,
   1.495020e-003f,  1.819188e-003f,  4.826462e-004f, -1.295584e-003f,  1.458526e-003f, -1.348987e-005f,  1.867163e-003f,  3.957040e-003f,
   1.457600e-002f,  2.733427e-002f,  3.581927e-002f,  3.813048e-002f,  2.870702e-002f,  1.899539e-002f,  1.506627e-002f,  9.636238e-003f,
   4.705949e-003f, -1.633962e-003f,  3.763104e-003f,  8.648097e-003f,  9.547614e-003f,  9.821933e-004f, -1.222005e-002f, -1.929614e-002f,
  -2.386792e-002f, -1.762580e-002f, -1.432443e-002f, -1.117574e-002f, -4.670771e-003f,  1.003081e-003f,  8.894028e-003f,  7.647719e-003f,
  -2.296569e-003f, -6.379023e-003f, -1.033687e-002f, -6.969644e-003f, -1.752426e-003f, -2.641580e-003f,  1.740022e-003f, -1.487721e-003f,
  -2.920445e-003f,  7.959503e-003f, -3.466285e-003f, -1.671881e-003f, -1.083385e-002f, -1.416691e-002f, -1.488554e-002f, -1.294008e-002f,
  -6.329103e-003f,  3.890771e-003f,  6.347976e-003f, -1.346832e-003f,  2.205936e-003f, -5.575288e-003f, -5.310744e-003f, -8.993577e-003f,
  -4.695363e-003f, -5.044345e-003f, -7.722614e-005f,  1.071303e-002f,  5.609267e-003f,  8.113120e-003f, -5.748287e-003f, -5.528010e-003f,
  -3.276129e-003f, -7.845732e-003f, -4.579193e-003f, -1.261414e-002f, -5.154146e-003f, -5.552513e-003f,  6.338511e-003f,  3.402695e-003f,
   4.923445e-003f, -2.773232e-003f, -8.241386e-003f, -6.635961e-003f, -2.932411e-003f, -2.962100e-003f, -1.282553e-002f, -1.242562e-002f,
  -1.351429e-002f,  8.763605e-005f, -2.078722e-003f, -8.957160e-004f,  9.345464e-005f, -1.887126e-003f, -2.781392e-003f, -6.898096e-003f,
  -8.757742e-004f, -5.961758e-003f, -3.617030e-003f,  1.648140e-003f,  1.477948e-003f,  5.693980e-003f,  2.669316e-003f,  2.373450e-003f,
  -3.256214e-003f, -2.998854e-003f, -2.357915e-003f,  2.063833e-003f,  2.958224e-003f,  4.163638e-003f,  8.686852e-003f,  1.042145e-002f,
   2.136455e-002f,  3.364554e-002f,  5.383133e-002f,  4.610644e-002f,  1.187303e-002f, -1.706729e-002f, -3.070150e-002f, -2.163053e-002f,
  -4.462088e-003f,  1.019719e-002f,  7.544859e-003f,  5.631228e-003f,  2.716729e-003f,  1.583322e-003f, -7.039596e-004f, -8.849638e-003f,
  -1.511354e-002f, -1.518809e-002f, -2.229944e-003f,  9.226802e-003f,  1.873517e-002f,  1.301081e-002f,  5.350948e-004f, -6.674295e-003f,
  -7.975797e-003f, -1.526580e-003f, -1.506768e-003f,  8.082373e-004f,  3.566852e-003f,  1.906432e-003f,  5.122401e-003f,  5.234509e-004f,
   1.872440e-003f,  1.055144e-003f, -5.814922e-004f,  3.499291e-004f, -6.119125e-004f,  4.034941e-004f, -8.079891e-003f, -8.108004e-003f,
  -7.817143e-003f, -8.042766e-004f,  1.515392e-003f,  2.345985e-003f,  4.675726e-003f,  4.503244e-003f,  7.099784e-003f,  4.076375e-003f,
   1.311697e-003f, -3.943994e-003f, -8.233274e-003f, -1.008710e-002f, -9.246778e-003f, -5.790002e-003f, -5.223786e-003f, -4.591769e-003f,
  -6.527624e-003f, -8.506297e-003f, -9.659054e-003f, -1.008818e-002f, -1.108576e-002f, -1.217410e-002f, -9.963335e-003f, -5.722118e-003f,
  -2.910300e-003f, -3.382006e-004f, -2.362476e-003f, -3.769082e-003f,  7.987626e-003f,  1.962502e-003f, -1.529364e-003f, -5.661021e-003f,
  -9.072733e-003f, -6.944579e-005f,  4.897097e-003f,  1.110299e-002f,  1.357534e-002f,  1.162067e-002f, -1.204323e-003f, -5.576690e-003f,
  -5.726369e-003f, -7.322713e-003f, -5.069865e-003f, -7.190958e-003f,  4.256760e-004f,  8.218540e-004f,  6.212720e-003f,  5.061947e-003f,
   4.956384e-003f,  8.211419e-003f,  4.673266e-003f,  7.232053e-003f,  6.146789e-003f, -1.238843e-003f, -8.372822e-003f, -1.299455e-002f,
   1.078171e-003f,  3.531948e-003f,  1.281739e-002f,  6.895736e-003f,  5.833586e-003f,  8.773055e-003f,  6.012789e-004f,  6.737042e-003f,
  -1.864962e-002f, -2.091641e-002f, -2.366630e-002f, -1.589349e-002f, -3.479585e-003f,  2.360705e-003f,  1.368024e-002f,  1.732487e-002f,
   1.136452e-002f,  1.571240e-002f,  2.103759e-002f,  1.683898e-002f,  1.507698e-002f,  1.636565e-002f,  1.107498e-002f,  9.109805e-003f,
   7.183347e-003f,  1.212317e-002f,  2.147238e-002f,  2.561582e-002f,  1.475321e-002f, -5.524435e-003f, -1.591536e-002f, -2.418931e-002f,
  -1.900463e-002f, -1.187742e-002f, -6.326449e-003f, -1.746023e-003f,  8.041573e-004f,  4.560592e-003f,  2.232063e-003f, -3.890774e-003f,
  -9.104157e-003f, -9.320817e-003f, -6.677675e-003f, -6.925765e-003f, -3.006927e-003f, -5.798641e-003f, -4.448881e-003f, -6.341603e-003f,
  -2.190452e-003f, -6.347125e-004f, -2.053863e-003f, -4.836795e-003f, -8.105411e-003f, -7.268590e-003f, -9.373750e-003f, -8.396468e-003f,
  -8.320411e-003f, -5.245063e-003f, -4.240913e-003f, -3.426063e-003f, -4.076852e-003f, -7.682975e-003f, -9.760134e-003f, -1.242480e-002f,
  -7.998147e-003f, -7.187585e-003f, -4.266050e-003f, -2.697951e-003f, -4.028798e-003f, -2.707436e-003f, -6.723627e-003f, -8.479886e-003f,
  -1.127111e-002f, -6.536366e-003f, -4.352181e-003f, -1.130606e-003f,  4.434998e-005f, -9.024584e-004f,  3.130339e-003f,  2.856611e-003f,
   5.171165e-003f,  3.779723e-003f,  2.650491e-003f,  1.981773e-003f,  5.240489e-004f,  1.702993e-003f, -1.339738e-003f, -2.839756e-003f,
  -9.346946e-003f, -5.800498e-003f,  2.688231e-003f,  1.079888e-002f,  2.220295e-002f,  1.600521e-002f,  1.425501e-002f,  9.267801e-003f,
  -6.450523e-003f, -1.400642e-002f, -1.883757e-002f, -9.648297e-003f, -1.261577e-003f,  8.753959e-003f,  1.245182e-002f,  9.462377e-003f,
   8.112876e-003f, -3.367439e-003f,  1.228508e-003f,  1.488499e-003f, -2.259097e-003f,  8.410720e-004f,  1.303214e-002f,  1.250615e-002f,
   1.481150e-002f,  1.040146e-002f,  1.774263e-003f,  5.376146e-004f, -1.015588e-002f, -1.273336e-002f, -1.707375e-002f, -9.883815e-003f,
  -1.273363e-002f, -6.391114e-003f, -7.975139e-004f, -6.993703e-003f, -3.043422e-003f, -7.613605e-003f, -5.235474e-003f, -6.786135e-003f,
  -3.988994e-003f, -4.884324e-003f, -1.415046e-003f,  6.605745e-004f, -4.852477e-003f, -1.452609e-003f, -8.501068e-003f, -9.503348e-003f,
  -1.322724e-002f, -9.989388e-003f, -9.185414e-003f, -6.995815e-003f, -6.929397e-003f, -5.015719e-003f,  1.253407e-003f,  9.282470e-004f,
   3.476264e-003f,  2.018984e-003f, -3.172489e-003f, -6.662739e-003f, -2.901175e-003f,  1.051586e-003f,  8.367438e-003f,  2.080690e-002f,
   2.152489e-002f,  1.877304e-002f,  1.517411e-002f,  1.615611e-002f,  1.341790e-002f,  5.334680e-003f,  5.834952e-003f,  1.276779e-003f,
   7.563280e-003f,  6.814276e-003f,  1.126565e-002f,  1.269867e-002f,  1.119295e-002f,  1.480035e-002f,  4.216746e-003f, -1.095958e-003f,
  -9.112335e-003f, -1.077822e-002f, -8.381323e-003f, -1.390222e-002f, -1.569305e-002f, -8.766105e-003f, -2.140633e-004f, -3.034550e-003f,
  -2.191232e-003f, -2.830334e-003f, -1.818824e-003f, -4.004837e-003f, -1.188606e-002f, -1.225675e-002f, -1.247268e-002f, -5.615391e-003f,
  -4.647642e-003f,  4.416520e-003f,  1.183979e-002f,  1.610272e-002f,  2.042928e-002f,  1.275866e-002f,  5.192322e-003f, -2.755909e-003f,
   2.787250e-004f,  2.937007e-004f,  8.030354e-004f, -3.453818e-003f, -3.641919e-003f, -2.206129e-003f, -1.964158e-003f,  2.814913e-003f,
   6.373293e-003f,  1.008363e-002f,  4.072965e-003f,  3.088331e-003f,  9.646028e-004f,  1.783356e-005f, -2.083718e-003f, -4.917172e-003f,
  -5.043613e-003f, -3.372436e-003f,  5.453269e-003f,  1.209742e-002f,  1.213969e-002f,  6.575061e-003f, -9.744147e-004f, -1.572421e-003f,
  -3.685301e-003f, -6.150142e-004f,  4.204505e-003f,  1.077101e-002f,  1.011195e-002f,  5.075940e-003f,  1.813212e-003f,  5.496771e-004f,
   6.794753e-003f,  6.922383e-003f,  1.529200e-003f, -1.827759e-003f, -2.608333e-003f, -1.297756e-003f,  3.671070e-003f,  2.045476e-003f,
  -2.886142e-003f, -4.224823e-003f, -3.270295e-003f, -1.998449e-003f, -2.593676e-003f, -4.664476e-003f, -8.005795e-003f, -3.405397e-003f,
   2.343245e-003f,  1.748647e-003f,  2.345075e-003f, -2.926031e-003f, -4.698353e-003f, -6.794371e-004f,  2.871131e-003f,  6.669096e-003f,
   4.004710e-003f, -1.152508e-002f, -1.667036e-002f, -1.908539e-002f, -9.685437e-003f, -4.626279e-003f, -4.039551e-003f, -5.374291e-004f,
   1.243538e-003f,  6.440856e-003f,  2.398343e-003f,  1.770326e-003f,  1.243849e-003f, -2.668319e-003f, -1.881418e-003f, -5.199980e-003f,
  -6.732529e-003f, -6.488420e-003f, -6.295555e-003f, -5.208668e-003f,  4.783747e-004f,  8.922493e-003f,  7.100772e-003f,  9.536109e-003f,
   3.621366e-003f,  3.116906e-003f, -4.178445e-003f, -5.281540e-003f, -2.392608e-003f,  2.140018e-003f,  6.495503e-003f,  4.464511e-003f,
   4.439695e-003f, -2.205412e-004f, -3.778410e-003f, -4.303002e-005f,  1.085553e-002f,  1.022212e-002f,  1.293842e-002f,  1.267760e-002f,
   5.815119e-003f,  9.335761e-005f, -6.441516e-003f, -5.493971e-003f, -1.994978e-003f, -1.091285e-003f,  2.911838e-003f,  9.268030e-003f,
   5.161273e-003f,  6.974908e-003f,  1.618169e-002f,  1.333092e-002f,  1.176774e-002f,  2.555280e-003f, -4.240622e-003f, -6.706087e-003f,
  -2.988060e-003f, -1.628523e-003f, -5.936189e-003f,  1.562347e-003f, -1.206901e-003f, -2.743585e-003f, -7.085631e-003f, -7.219772e-003f,
  -5.183780e-003f, -9.158028e-004f,  2.039440e-003f, -5.266648e-004f,  5.093882e-003f,  8.409602e-004f,  1.186964e-003f, -5.404300e-003f,
  -6.948072e-003f, -7.754953e-003f, -6.847460e-003f,  6.787278e-004f, -1.845106e-004f,  4.612197e-003f,  4.755430e-003f,  5.425412e-003f,
   1.007627e-003f, -1.723447e-003f, -4.417955e-003f, -9.142639e-003f, -5.349759e-003f, -2.900391e-003f,  7.773209e-004f,  8.374879e-004f,
   2.363981e-003f, -2.817509e-006f, -4.966737e-003f, -9.055190e-003f, -1.016996e-002f, -6.241110e-003f, -9.742465e-003f, -9.255850e-003f,
  -7.079615e-003f, -3.185624e-003f, -1.531089e-003f, -7.917759e-004f,  2.203391e-003f, -2.275709e-003f,  1.562745e-003f, -3.258969e-004f,
  -3.171448e-003f, -3.003638e-003f,  3.526051e-003f,  1.293795e-002f,  1.409895e-002f,  1.530842e-002f,  7.949597e-003f,  5.900653e-003f,
   2.492422e-003f,  3.712672e-003f,  2.958383e-003f,  2.057124e-003f, -1.004803e-003f, -3.307988e-003f, -1.224195e-003f,  1.244688e-003f,
   5.308927e-003f,  3.475195e-003f,  2.430489e-003f,  2.619262e-003f,  2.032473e-003f, -3.599009e-003f, -5.717765e-003f, -8.365494e-004f,
   7.754153e-003f,  1.659091e-002f,  1.672668e-002f,  1.286013e-002f,  2.031418e-003f, -2.361684e-003f, -5.449916e-003f, -4.094469e-003f,
  -5.329010e-003f, -6.986544e-003f, -6.096633e-003f, -1.755178e-003f,  4.903784e-003f,  4.760883e-003f,  3.863129e-003f,  3.814920e-003f,
  -1.371091e-003f,  1.935169e-003f, -2.421021e-003f,  6.711078e-003f,  5.434529e-002f,  3.418041e-002f,  2.829409e-002f, -6.627975e-003f,
  -2.472292e-002f, -1.752369e-002f, -2.516887e-002f, -6.058686e-003f,  1.021328e-002f,  1.268091e-002f, -6.780463e-003f,  1.461557e-002f,
   3.723197e-003f, -7.988465e-003f, -1.181574e-002f, -1.444149e-002f, -4.617468e-003f,  3.165579e-003f,  2.429817e-002f,  8.859555e-003f,
   8.426778e-003f, -2.711715e-003f, -6.805149e-003f,  1.670532e-002f, -3.933377e-003f, -5.347434e-003f, -1.414785e-002f, -1.008570e-002f,
  -1.129879e-002f, -1.570527e-002f, -5.486899e-003f, -9.835529e-003f, -5.552656e-003f, -1.793765e-002f, -1.275360e-002f, -1.176848e-002f,
  -6.202328e-003f, -7.113960e-003f, -6.279387e-003f, -1.468537e-004f, -1.381283e-002f, -2.886952e-003f, -8.791800e-003f,  9.704888e-004f,
  -4.981648e-003f,  8.701077e-004f,  7.477836e-003f,  1.483073e-003f,  4.620182e-003f, -1.261061e-003f,  8.859049e-003f,  6.910450e-003f,
   1.018854e-002f,  4.875832e-003f,  6.284964e-003f,  4.821868e-003f,  4.934513e-003f,  7.398263e-003f,  2.079406e-003f,  4.433264e-003f,
   1.987447e-003f, -1.085559e-003f, -1.187713e-002f, -1.187316e-002f, -7.706392e-003f, -8.792932e-003f, -4.604365e-004f, -3.317011e-003f,
  -1.213267e-003f, -3.177107e-004f,  2.341050e-003f,  4.622887e-003f,  4.883137e-003f, -1.438546e-004f, -7.893155e-003f,  8.847748e-004f,
   2.096676e-003f,  3.206407e-003f,  1.670192e-003f,  1.751345e-003f,  3.027809e-003f,  2.129130e-002f,  4.641917e-002f,  5.402475e-002f,
   3.873910e-002f, -9.464479e-003f, -3.361040e-002f, -3.328821e-002f, -1.851963e-002f,  1.719751e-003f,  9.500720e-003f,  3.959636e-003f,
  -3.691313e-003f, -3.031675e-003f, -2.639054e-003f, -3.888715e-005f, -4.650790e-003f, -7.010904e-003f,  2.274919e-003f,  9.583452e-003f,
   1.505746e-002f,  1.150257e-002f,  1.683829e-003f, -8.088300e-003f, -1.350620e-002f, -8.982209e-003f, -7.634595e-003f, -5.137401e-003f,
  -6.470794e-003f, -5.161243e-003f,  1.824433e-004f,  9.594217e-003f,  1.270168e-002f,  5.718425e-003f, -1.276880e-003f, -2.617255e-003f,
   3.135116e-003f,  2.394677e-003f,  3.691311e-003f, -3.159923e-003f, -2.339603e-003f,  1.505942e-003f, -2.099275e-004f, -7.670386e-004f,
  -1.017435e-002f, -1.955824e-002f, -1.920224e-002f, -9.025214e-003f,  6.180384e-004f,  6.166002e-003f,  3.327870e-003f, -7.413893e-003f,
  -1.430018e-002f, -5.523448e-003f,  7.981949e-003f,  1.519207e-002f,  9.956791e-003f,  2.233076e-003f,  7.775808e-003f,  6.232479e-003f,
   8.578866e-003f,  8.905187e-003f, -4.284601e-004f, -7.748762e-003f, -5.576542e-003f,  2.208494e-003f,  3.813962e-003f,  2.032082e-003f
};

static const float VastImpulseRight4[] =
{
  -2.020806e-005f, -1.693529e-006f, -2.429788e-005f, -1.489460e-005f, -2.350645e-005f, -2.616330e-005f, -1.532653e-005f, -1.205898e-005f,
  -1.562136e-005f, -1.538176e-005f,  7.778216e-006f, -1.637418e-005f, -1.519846e-007f,  5.728227e-006f,  1.572402e-005f,  8.333756e-006f,
   2.117874e-005f,  3.264924e-006f,  1.487877e-005f, -1.399517e-005f, -4.888771e-005f, -4.608100e-005f, -1.138474e-004f, -1.274029e-004f,
  -4.772842e-004f, -1.036967e-003f, -1.467270e-003f, -1.632910e-003f, -1.485572e-003f, -1.071679e-003f, -4.697050e-004f,  2.203003e-004f,
   4.548307e-004f, -4.109673e-004f, -1.626078e-003f, -3.015419e-003f, -3.804476e-003f, -4.158855e-003f, -4.219617e-003f, -3.847193e-003f,
  -3.355863e-003f, -3.234944e-003f, -3.424992e-003f, -4.004525e-003f, -4.885350e-003f, -5.797056e-003f, -6.654151e-003f, -6.922090e-003f,
  -6.825656e-003f, -6.652242e-003f, -6.300406e-003f, -5.847815e-003f, -5.296949e-003f, -4.905270e-003f, -4.520887e-003f, -4.355188e-003f,
  -4.151477e-003f, -4.160575e-003f, -4.114763e-003f, -3.933181e-003f, -3.847744e-003f, -3.778196e-003f, -3.718676e-003f, -3.491785e-003f,
  -3.228824e-003f, -3.037475e-003f, -3.098149e-003f, -3.330910e-003f, -3.542485e-003f, -3.923820e-003f, -4.021102e-003f, -3.979443e-003f,
  -3.849578e-003f, -3.552978e-003f, -3.536419e-003f, -3.036963e-003f, -3.062804e-003f, -2.918549e-003f, -3.141861e-003f, -3.358592e-003f,
  -3.144273e-003f, -3.201260e-003f, -3.194722e-003f, -2.039131e-003f, -2.036865e-003f, -2.371653e-003f, -1.842210e-003f, -1.840783e-003f,
  -1.938662e-003f, -2.917595e-003f, -1.815176e-003f, -1.468669e-003f, -4.433007e-004f, -1.218669e-003f,  1.316187e-003f, -2.275722e-003f,
   1.643804e-002f,  4.960119e-002f,  5.576629e-002f,  6.138461e-002f,  5.107095e-002f,  4.137830e-002f,  1.297952e-002f, -3.274883e-002f,
  -3.574045e-002f,  4.775414e-003f,  3.605013e-002f,  5.774781e-002f,  6.089888e-002f,  5.393137e-002f,  4.351306e-002f,  3.216676e-003f,
  -2.466457e-002f, -4.142521e-002f, -4.589879e-002f, -3.503615e-002f, -1.938159e-002f, -9.794782e-004f,  2.513329e-002f,  2.383823e-002f,
   1.090159e-002f,  8.302815e-003f, -1.500920e-003f, -1.065386e-002f, -1.396388e-002f, -1.665984e-002f, -1.154572e-002f, -2.950657e-003f,
   1.947322e-003f,  6.609115e-003f,  8.407296e-003f,  3.748622e-003f, -2.101957e-003f, -4.450394e-003f, -6.778593e-003f, -5.735159e-003f,
  -6.767814e-003f, -5.738737e-003f, -2.196575e-003f,  2.095176e-003f,  2.620453e-003f,  1.927162e-003f, -1.936000e-004f, -2.752464e-003f,
  -5.073776e-003f, -6.836515e-003f, -5.433013e-003f, -5.802310e-003f, -6.402005e-003f, -6.295760e-003f, -3.166379e-003f, -1.368472e-003f,
  -1.152288e-003f, -9.077952e-004f, -2.942992e-003f, -6.319407e-003f, -7.598691e-003f, -4.958859e-003f, -1.532733e-003f,  7.135555e-005f,
  -7.377200e-004f,  1.849725e-003f,  3.102470e-003f,  1.174296e-003f, -2.650145e-004f, -1.522420e-003f, -3.148417e-003f, -3.391792e-003f,
  -2.809364e-003f, -1.116946e-003f,  1.435539e-003f,  1.936879e-003f,  7.024553e-004f,  2.838732e-004f, -7.697650e-004f, -9.277222e-004f,
  -4.647623e-004f, -4.976900e-005f, -6.728270e-005f, -8.104370e-004f, -6.330745e-004f, -7.007905e-004f, -1.131784e-003f, -1.810140e-003f,
  -1.644309e-003f, -1.902109e-003f, -1.577780e-003f, -1.414684e-003f, -8.130615e-004f, -5.730787e-004f, -9.969946e-004f, -5.314782e-004f,
  -5.025733e-004f, -7.454532e-004f, -7.338432e-004f, -5.564650e-004f, -1.051857e-003f, -1.237706e-003f, -1.102061e-003f, -7.918510e-004f,
  -4.830664e-004f, -1.915628e-004f,  6.835825e-004f,  1.199377e-003f,  8.412999e-004f,  5.261633e-005f, -6.768290e-004f, -5.657777e-004f,
  -2.115182e-004f,  1.748780e-003f,  4.302246e-003f,  5.561652e-003f,  5.007455e-003f,  3.702861e-003f,  3.122786e-003f,  1.899867e-003f,
   4.568544e-004f, -8.468344e-004f, -2.688345e-003f, -3.814061e-003f, -3.103638e-003f, -2.034526e-003f, -4.722178e-004f, -1.076864e-003f,
  -2.004609e-003f, -1.905657e-003f, -3.065352e-003f, -3.002064e-003f, -3.165571e-003f, -3.178229e-003f, -2.554708e-003f, -2.756279e-003f,
  -2.395251e-003f, -1.358492e-003f,  5.415022e-004f, -4.537356e-004f, -2.580060e-003f, -4.495800e-003f, -5.143043e-003f, -5.788250e-003f,
  -5.360631e-003f, -5.852535e-003f, -5.876124e-003f, -4.174791e-003f, -2.715294e-003f, -9.226566e-004f, -1.767513e-003f, -3.347950e-003f,
  -5.761783e-003f, -6.907721e-003f, -6.584515e-003f, -6.858826e-003f, -7.606467e-003f, -6.583716e-003f, -4.880472e-003f, -2.205582e-003f,
  -6.093226e-004f,  1.393072e-003f,  1.887270e-003f,  2.352889e-003f,  3.508204e-003f,  5.114495e-003f,  7.022947e-003f,  7.108831e-003f,
   7.933988e-003f,  6.848612e-003f,  6.174081e-003f,  4.747913e-003f,  3.278624e-003f,  1.784170e-003f,  9.383400e-004f,  8.691937e-004f,
   1.749617e-004f,  7.216755e-004f,  1.147898e-003f,  3.506942e-003f,  7.194677e-003f,  1.057633e-002f,  1.316888e-002f,  1.387199e-002f,
   1.371116e-002f,  1.204997e-002f,  1.032240e-002f,  7.572175e-003f,  5.132820e-003f,  4.961750e-003f,  6.586029e-003f,  9.248158e-003f,
   9.234325e-003f,  7.673239e-003f,  4.516251e-003f,  2.037127e-003f,  2.098458e-004f, -3.842082e-004f, -9.652283e-005f, -5.572437e-005f,
   1.213642e-003f,  2.161468e-003f,  3.327602e-003f,  2.956726e-003f,  2.392510e-003f,  9.244967e-004f, -1.709940e-004f, -2.757791e-004f,
  -2.027205e-005f,  1.037486e-003f,  7.640887e-004f,  6.361639e-004f, -5.027630e-005f, -8.010962e-004f, -1.255129e-003f, -1.931100e-003f,
  -2.505492e-003f, -2.979790e-003f, -2.765754e-003f, -2.580403e-003f, -2.205409e-003f, -2.362701e-003f, -2.237537e-003f, -2.155473e-003f,
  -2.409982e-003f, -2.143117e-003f, -2.030385e-003f, -1.542519e-003f, -2.389169e-003f, -2.521460e-003f, -1.920551e-003f, -7.666378e-004f,
  -4.840675e-004f, -1.574089e-003f, -2.272208e-003f, -2.923738e-003f, -3.084582e-003f, -2.595490e-003f, -1.363776e-003f, -6.818747e-004f,
  -1.953450e-004f, -1.035586e-004f,  8.271224e-005f, -1.093548e-004f, -5.593919e-004f, -1.306596e-003f, -2.771787e-003f, -3.349582e-003f,
  -3.330174e-003f, -2.963424e-003f, -3.285062e-003f, -3.416219e-003f, -3.638213e-003f, -2.813098e-003f, -2.182132e-003f, -2.135315e-003f,
  -2.465779e-003f, -2.876024e-003f, -3.385197e-003f, -4.500493e-003f, -5.184548e-003f, -5.747150e-003f, -5.047393e-003f, -3.937177e-003f,
  -2.657458e-003f, -1.500029e-003f, -9.362650e-004f, -2.804304e-004f, -7.538376e-004f,  3.645048e-004f,  4.751238e-003f,  1.320579e-002f,
   2.425516e-002f,  2.465361e-002f,  1.413860e-002f, -1.375107e-003f, -1.114288e-002f, -1.181154e-002f, -5.823731e-003f, -1.778847e-004f,
   3.342175e-003f,  4.444211e-003f,  3.291331e-003f,  3.514312e-003f,  3.084300e-003f,  5.169163e-004f, -3.838310e-003f, -7.713320e-003f,
  -6.162510e-003f, -1.072267e-003f,  3.781221e-003f,  5.419472e-003f,  2.713739e-003f, -1.034577e-003f, -3.222670e-003f, -3.620631e-003f,
  -3.119535e-003f, -3.943832e-003f, -4.580241e-003f, -4.546013e-003f, -2.931973e-003f, -1.340643e-003f,  1.035472e-003f,  9.659547e-004f,
   7.445789e-004f, -4.308980e-004f, -1.383492e-003f, -3.676626e-004f, -4.742007e-004f, -8.052747e-004f, -2.157828e-003f, -1.906925e-003f,
  -1.683196e-003f, -2.013065e-004f,  9.620501e-004f,  2.876729e-004f,  2.389067e-003f,  1.083627e-003f,  3.935344e-004f, -1.729877e-003f,
  -6.053331e-003f, -7.488248e-003f, -7.868797e-003f, -5.074771e-003f, -3.174843e-003f, -2.727538e-004f, -2.291785e-003f, -9.235645e-004f,
  -3.446763e-003f, -2.619320e-003f, -3.809228e-003f, -3.929856e-003f, -3.581939e-003f, -2.776405e-003f, -1.694644e-003f, -1.249320e-004f,
  -1.710443e-004f, -3.081520e-006f, -2.960571e-003f, -2.802041e-003f, -4.561071e-003f, -1.213586e-003f, -3.263744e-003f, -1.175026e-003f,
  -4.818939e-003f, -3.252272e-003f, -5.409185e-003f, -9.780736e-004f, -2.758060e-003f,  2.914822e-003f, -2.094922e-003f,  8.382872e-003f,
  -5.060887e-003f,  5.971145e-002f,  1.243720e-001f,  6.492430e-002f,  6.348458e-002f, -3.727712e-002f, -3.718611e-002f, -4.771646e-002f,
  -6.782643e-002f,  1.107577e-003f,  4.280223e-002f,  3.247638e-002f, -2.823539e-002f, -1.898412e-002f,  7.142096e-003f,  2.430881e-002f,
   1.984269e-002f,  1.523078e-002f, -2.228261e-002f, -3.247051e-002f, -3.551600e-003f, -1.683212e-002f,  4.655300e-003f, -5.508242e-003f,
  -9.364433e-003f,  5.101370e-003f,  5.019899e-003f,  2.099917e-002f, -7.502001e-004f,  2.261115e-002f,  6.525833e-003f, -1.416709e-003f,
  -4.573871e-003f, -8.652685e-003f,  4.460514e-003f, -2.164661e-002f, -8.008262e-003f, -6.553721e-003f,  2.139012e-002f,  1.852326e-002f,
   1.484330e-003f, -6.882416e-003f, -1.013491e-002f,  5.828135e-003f, -8.112619e-003f, -9.678811e-003f, -1.928618e-002f, -7.078570e-003f,
  -2.630394e-003f, -3.677420e-003f,  8.576243e-004f, -8.048330e-003f,  1.919231e-004f, -9.212336e-004f,  6.233802e-003f,  2.045251e-003f,
   1.816174e-003f, -3.181080e-003f, -9.955677e-003f, -9.118384e-003f, -1.826999e-002f, -5.120996e-003f, -1.076738e-003f,  3.431965e-003f,
  -6.177946e-003f, -4.184273e-003f,  5.083080e-003f,  3.141695e-003f, -5.346046e-003f, -1.906766e-002f, -1.197863e-002f, -1.180285e-002f,
  -6.803536e-003f, -3.550634e-003f, -6.149798e-003f,  1.469349e-003f,  7.002690e-005f,  5.456218e-003f,  1.393722e-002f,  3.877732e-002f,
   1.384329e-002f, -1.323065e-003f, -2.164160e-002f, -2.425782e-002f, -1.120865e-002f, -1.858127e-002f, -1.620499e-002f, -1.251174e-002f,
   2.382699e-002f,  2.667411e-002f,  1.248871e-002f, -2.006622e-002f, -1.298517e-002f,  8.134906e-003f,  9.735023e-003f,  1.491715e-002f,
   5.243150e-003f,  9.232828e-004f, -4.875561e-003f, -7.420507e-003f, -3.832266e-003f,  1.090205e-003f,  5.315703e-003f,  2.745812e-003f,
   5.571993e-003f,  4.647272e-003f,  9.420056e-003f,  4.358564e-003f, -2.338349e-003f, -6.983645e-003f, -5.700464e-003f, -1.061979e-003f,
   1.493812e-003f,  6.322349e-003f,  7.003175e-003f,  4.282119e-003f, -1.611948e-003f, -4.163331e-003f, -7.977398e-003f, -8.241810e-003f,
  -4.740177e-003f,  3.851803e-003f,  1.421103e-002f,  1.315794e-002f,  1.022365e-002f,  3.846260e-003f, -2.558850e-003f, -7.563033e-003f,
  -1.038598e-002f, -1.037235e-002f, -8.248698e-003f, -3.008119e-003f, -3.707999e-003f,  1.449839e-003f, -2.619879e-003f, -4.099252e-003f,
  -7.618743e-003f,  8.836655e-003f,  2.932831e-002f,  5.531430e-002f,  4.205904e-002f,  3.875226e-003f, -2.034281e-002f, -3.848924e-002f,
  -3.134465e-002f, -2.292413e-002f, -7.662025e-003f,  3.024057e-003f,  5.159737e-003f, -2.134056e-003f, -6.340474e-003f, -6.985151e-003f,
  -1.157032e-002f, -1.219252e-002f, -1.572568e-002f, -1.339016e-002f, -2.356930e-003f,  1.384921e-003f,  4.384750e-003f, -1.914586e-003f,
  -3.374474e-003f, -7.211205e-003f,  1.391734e-003f,  5.859253e-003f,  5.984872e-003f,  1.074268e-002f,  7.174744e-003f,  4.569772e-003f,
  -8.008088e-004f, -8.166087e-003f, -1.162132e-002f, -1.176012e-002f, -6.817659e-003f,  3.825133e-004f,  9.730655e-003f,  1.021211e-002f,
   1.408986e-002f,  1.630782e-002f,  1.046561e-002f,  7.070415e-003f, -2.088261e-003f, -2.202238e-003f, -9.168328e-003f, -3.850813e-003f,
  -1.498407e-003f,  3.967683e-003f,  7.961304e-003f,  2.479352e-003f, -1.457680e-003f, -9.174084e-003f, -3.342688e-003f, -2.934798e-003f,
   2.260843e-003f, -6.038979e-004f, -5.959632e-003f, -3.454108e-004f, -2.323537e-003f,  5.199472e-003f,  9.270864e-003f,  1.526728e-002f,
   1.532585e-002f,  7.585268e-003f,  2.011229e-003f, -5.463326e-003f, -6.323218e-003f, -1.063439e-002f, -7.155663e-003f, -6.329831e-003f,
  -2.502716e-003f,  6.254420e-004f, -1.661096e-003f,  1.059966e-003f, -8.992030e-004f, -9.009354e-004f, -2.420376e-003f,  5.862086e-003f,
   1.502503e-002f,  2.062812e-002f,  1.980736e-002f,  1.167950e-002f,  5.670952e-003f, -5.061589e-003f, -9.628558e-003f, -8.302456e-003f,
  -7.811086e-003f, -6.737607e-003f, -5.988250e-003f,  1.949971e-003f,  8.402013e-003f,  1.329117e-002f,  8.851533e-003f,  2.403367e-004f,
  -5.671706e-003f, -9.110485e-003f, -2.977250e-003f,  1.506925e-003f,  2.970859e-003f,  3.316734e-003f,  5.212598e-003f,  6.465304e-003f,
   8.718600e-003f,  3.766008e-003f, -2.986230e-003f, -9.830457e-003f, -1.598992e-002f, -1.568420e-002f, -1.181856e-002f, -6.188387e-003f,
  -3.813181e-003f,  7.157616e-004f,  1.606409e-003f, -5.886973e-004f, -1.690472e-003f, -5.945773e-003f, -5.617249e-003f, -5.387075e-003f,
  -4.123156e-003f, -4.048954e-003f,  8.581252e-004f,  1.550519e-003f, -6.705138e-004f, -8.176133e-005f, -1.220553e-003f, -1.096693e-003f,
  -3.017348e-003f, -4.415481e-003f, -3.291629e-003f, -2.834946e-003f, -2.992599e-003f, -3.820011e-003f, -8.239777e-004f,  3.467091e-005f,
   4.913114e-003f,  7.142602e-003f,  1.240514e-002f,  1.052552e-002f,  1.320151e-002f,  6.444272e-002f,  4.553482e-002f,  6.287926e-002f,
   4.364088e-002f, -2.016818e-002f, -2.137300e-002f, -3.979582e-002f, -2.242792e-002f, -3.463684e-002f,  2.160395e-003f,  2.222747e-002f,
   2.145570e-002f,  1.804729e-002f, -2.317480e-003f,  2.822104e-003f, -1.383935e-002f,  6.430218e-003f, -1.204540e-002f, -1.252301e-003f,
   1.331715e-002f, -4.267521e-003f,  3.275786e-003f, -7.904337e-003f, -7.784578e-004f, -1.225519e-002f,  7.258618e-005f, -1.972310e-003f,
  -2.355014e-003f,  6.255149e-003f, -1.198422e-002f, -4.492848e-003f, -1.146542e-002f, -6.808790e-003f, -1.400108e-002f, -1.537283e-002f,
  -9.310250e-003f, -1.234348e-002f, -4.369806e-003f, -5.781196e-003f,  4.684577e-003f,  5.211184e-003f,  7.798156e-003f,  5.923517e-003f,
  -2.300710e-003f,  5.638289e-003f, -9.647221e-003f, -9.933832e-003f, -7.887883e-003f, -9.247550e-003f, -6.613640e-003f, -2.529275e-003f,
   1.650224e-002f,  5.031820e-003f,  7.531866e-003f,  6.145367e-003f, -1.998624e-003f, -2.581316e-003f, -1.359339e-002f, -6.722062e-003f,
  -1.313163e-002f, -2.030379e-003f,  2.944965e-003f,  1.091099e-002f,  6.322344e-003f, -2.126577e-003f,  5.232637e-003f, -2.715994e-003f,
   9.724638e-003f, -1.504305e-004f,  4.383334e-003f,  9.768665e-003f,  2.132977e-002f,  2.245163e-002f,  9.487591e-003f,  1.012523e-002f,
  -1.371515e-002f, -8.189393e-003f, -6.700569e-003f,  2.266161e-003f,  6.658567e-003f, -1.719260e-004f,  6.245500e-003f, -1.575582e-003f,
   3.438290e-003f, -1.123586e-002f, -5.275930e-004f,  8.602852e-004f,  9.259065e-003f,  2.675891e-002f,  7.198368e-003f,  8.939592e-003f,
  -1.135793e-002f, -1.395156e-002f, -5.940149e-003f,  4.664586e-003f,  1.882030e-002f,  3.181034e-002f,  3.161137e-002f, -7.021753e-003f,
  -2.976776e-002f, -4.384991e-002f, -3.012408e-002f, -1.280537e-002f,  5.425369e-003f,  2.061819e-002f,  9.147931e-003f,  1.108479e-003f,
  -1.267270e-002f, -9.770328e-003f, -5.670889e-003f,  9.833170e-004f,  5.049528e-003f,  4.698257e-003f,  1.076321e-002f,  1.336499e-002f,
   1.023960e-002f,  4.161994e-006f, -7.907382e-003f, -9.667535e-003f, -8.799816e-003f, -7.139452e-003f, -3.821180e-003f, -5.819555e-003f,
  -4.352310e-003f, -1.614793e-003f,  2.431751e-004f,  1.183992e-004f,  8.182873e-004f,  3.265751e-004f, -2.448819e-003f, -3.638101e-003f,
  -5.116716e-003f, -1.451613e-003f,  5.443038e-003f,  3.764677e-003f, -3.186199e-003f, -1.169000e-002f, -1.691492e-002f, -1.608397e-002f,
  -9.832301e-003f, -5.370985e-003f,  1.196321e-003f,  4.074772e-003f,  3.101385e-003f, -9.838972e-004f, -1.055782e-003f,  2.850270e-003f,
  -1.917164e-003f,  2.099545e-003f,  1.214921e-002f,  1.119473e-002f,  7.946712e-003f,  3.884913e-003f, -5.634195e-003f, -4.332344e-003f,
   1.354050e-003f, -1.146001e-003f,  5.321182e-003f,  1.208537e-002f,  6.968884e-003f,  3.392930e-003f, -2.778773e-003f, -7.265521e-003f,
  -7.278698e-003f, -7.272725e-003f, -5.547075e-003f, -2.039730e-003f,  5.510473e-004f,  2.753763e-003f,  1.688893e-003f, -1.255516e-003f,
  -1.174772e-003f, -1.552618e-003f, -1.794617e-003f,  2.201925e-003f,  3.766159e-003f,  6.860749e-003f,  1.071182e-002f,  6.533860e-003f,
   2.270778e-003f,  1.070895e-003f,  9.218415e-004f,  8.658912e-004f,  5.611598e-003f,  4.373596e-003f,  1.852367e-003f,  1.223765e-003f,
  -2.486232e-003f, -1.323006e-003f, -3.203691e-003f, -1.286634e-003f, -5.015319e-003f, -6.629389e-003f, -3.429737e-003f,  2.159837e-003f,
   7.782016e-003f,  9.103975e-003f,  4.890522e-003f, -9.081202e-004f, -2.398742e-003f, -7.490047e-003f, -8.008367e-003f, -5.802048e-003f,
  -5.169300e-003f, -2.619722e-003f,  9.194687e-004f,  6.129307e-003f,  9.783107e-003f,  8.598933e-003f,  5.907687e-003f,  1.279473e-003f,
   7.582453e-004f,  8.167945e-004f,  4.928653e-003f,  8.647365e-003f,  8.657042e-003f,  4.077560e-003f,  5.692082e-004f,  8.009771e-004f,
   1.518994e-003f,  1.908716e-003f, -8.915551e-004f, -9.699819e-004f, -1.576528e-003f, -2.519656e-004f, -2.721697e-003f, -4.831559e-003f,
  -3.044251e-003f, -1.022549e-003f,  1.618874e-003f,  4.806658e-005f, -5.755525e-004f, -7.812337e-004f,  2.058622e-003f,  5.687101e-003f,
   1.160824e-002f,  1.058050e-002f,  3.283729e-003f, -2.803096e-003f, -1.003340e-002f, -7.937884e-003f, -5.467372e-003f, -4.165016e-003f,
  -6.995743e-003f, -8.551494e-003f, -3.469368e-003f, -1.819404e-003f, -1.013410e-003f, -2.591788e-003f, -4.141082e-003f, -5.226140e-003f,
  -1.802833e-003f,  6.034666e-004f,  3.516574e-003f,  4.603001e-003f, -1.589086e-003f, -4.267695e-003f, -3.027812e-003f,  8.971527e-003f,
   1.962202e-002f,  2.068538e-002f,  1.142162e-002f, -5.869588e-003f, -1.715764e-002f, -1.844026e-002f, -1.052824e-002f, -1.667215e-003f,
   5.846674e-004f,  5.286294e-004f,  3.343044e-005f, -1.062696e-003f, -3.472999e-003f, -5.714546e-003f, -2.309477e-003f,  1.322056e-003f
};

static const float VastImpulseLeft5[] =
{
  -2.305207e-005f, -1.906311e-005f, -4.131514e-005f, -2.027320e-005f, -2.928557e-005f, -3.989340e-005f, -5.662326e-006f, -1.445395e-005f,
   5.125997e-006f, -1.044455e-005f,  1.998364e-006f, -9.275118e-006f,  2.483038e-006f, -1.822575e-005f, -5.428896e-006f, -1.528098e-005f,
   7.511274e-007f, -1.978181e-005f, -1.027582e-005f, -6.764331e-005f, -7.106176e-005f, -1.605342e-004f, -1.675278e-004f, -7.317881e-004f,
  -1.476963e-003f, -2.010107e-003f, -2.109718e-003f, -1.786058e-003f, -9.498959e-004f, -1.860965e-004f,  4.943157e-004f,  4.491782e-004f,
  -7.864952e-004f, -1.910405e-003f, -3.173218e-003f, -4.260341e-003f, -5.170157e-003f, -5.776571e-003f, -5.872823e-003f, -5.471250e-003f,
  -4.579683e-003f, -4.506842e-003f, -4.297996e-003f, -5.228200e-003f, -6.240377e-003f, -7.014276e-003f, -7.482271e-003f, -7.874143e-003f,
  -8.059082e-003f, -7.803106e-003f, -7.509455e-003f, -6.755441e-003f, -6.500938e-003f, -6.211448e-003f, -5.793094e-003f, -5.725605e-003f,
  -5.438115e-003f, -5.209129e-003f, -5.029065e-003f, -5.332894e-003f, -5.360504e-003f, -5.216338e-003f, -5.011289e-003f, -4.388566e-003f,
  -4.397322e-003f, -4.192331e-003f, -4.424881e-003f, -4.411216e-003f, -4.823851e-003f, -4.710743e-003f, -4.944280e-003f, -4.975535e-003f,
  -4.759246e-003f, -4.649963e-003f, -4.188013e-003f, -4.041081e-003f, -4.086983e-003f, -4.073917e-003f, -4.218614e-003f, -3.899160e-003f,
  -4.218691e-003f, -3.503362e-003f, -3.665563e-003f, -2.002772e-003f, -3.014181e-003f, -2.474749e-003f, -3.198632e-003f, -2.780609e-003f,
  -3.441494e-003f, -2.043823e-003f, -2.321237e-003f,  8.747933e-005f, -1.807796e-003f,  2.784335e-003f, -4.524330e-003f,  2.675555e-002f,
   7.411713e-002f,  7.089615e-002f,  8.224249e-002f,  5.787592e-002f,  3.551070e-002f, -6.900331e-003f, -4.113175e-002f, -3.263822e-002f,
   7.820116e-003f,  2.920838e-002f,  2.350718e-002f,  5.761755e-002f,  6.755927e-002f,  6.380940e-002f,  5.461030e-002f,  1.797638e-002f,
  -3.506062e-002f, -5.291077e-002f, -4.827493e-002f, -3.244372e-002f, -2.985382e-003f,  7.868622e-003f,  1.157096e-002f,  1.783763e-002f,
   1.305827e-002f,  3.608832e-003f, -2.468928e-003f, -8.367863e-003f, -1.447442e-002f, -9.522146e-003f, -2.594095e-003f, -7.805207e-004f,
   3.389384e-005f, -3.445623e-003f, -3.062270e-003f, -2.297985e-003f, -2.383555e-004f, -1.881126e-003f, -3.060216e-003f, -5.477614e-003f,
  -6.384190e-003f, -3.127935e-003f, -1.574833e-003f, -1.270130e-003f, -3.525193e-003f, -3.454496e-003f, -3.652951e-003f, -3.556760e-003f,
  -4.847636e-003f, -6.404757e-003f, -7.313164e-003f, -5.784855e-003f, -3.088763e-003f, -1.093913e-003f, -2.206453e-003f, -3.835171e-003f,
  -4.003203e-003f, -4.700793e-003f, -7.057618e-003f, -7.388591e-003f, -5.079266e-003f, -4.202682e-003f, -3.243608e-003f, -1.951586e-003f,
   8.529536e-004f,  2.649769e-003f,  1.889159e-003f,  1.957862e-004f,  2.700918e-004f, -1.419783e-003f, -3.069526e-003f, -2.096717e-003f,
  -1.082994e-003f, -1.445936e-003f, -8.910668e-004f, -1.409213e-004f, -8.058025e-004f, -1.240678e-003f, -5.609465e-004f, -3.014823e-004f,
  -1.626665e-003f, -3.767364e-003f, -3.677386e-003f, -1.755617e-003f,  1.270007e-004f,  5.438316e-004f, -3.857766e-004f, -6.984864e-004f,
  -1.110390e-003f, -5.115261e-004f, -5.815441e-005f, -9.372354e-004f, -2.615877e-003f, -3.610812e-003f, -2.502170e-003f, -2.419571e-003f,
  -2.147945e-003f, -2.100280e-003f, -3.233815e-003f, -3.558872e-003f, -3.235421e-003f, -1.944045e-003f, -1.196453e-003f, -6.326993e-004f,
  -3.407689e-004f, -2.347798e-005f,  6.237111e-004f,  5.996878e-004f,  4.822950e-004f, -1.738652e-004f,  9.761731e-005f,  5.530701e-004f,
   2.356856e-003f,  4.127853e-003f,  3.947408e-003f,  3.520437e-003f,  2.890632e-003f,  2.341139e-003f,  4.950778e-004f, -3.749872e-005f,
  -4.709889e-004f, -6.373153e-004f, -9.817690e-004f, -1.777217e-003f, -2.193641e-003f, -2.907770e-003f, -3.204899e-003f, -2.751033e-003f,
  -1.776856e-003f, -3.897754e-004f,  2.494100e-004f,  1.295631e-003f, -1.664852e-003f, -5.686154e-003f, -8.089103e-003f, -8.542420e-003f,
  -6.056448e-003f, -5.179598e-003f, -3.263009e-003f, -3.064775e-004f,  3.395209e-003f,  4.527492e-003f,  3.050133e-003f, -6.329190e-004f,
  -4.165075e-003f, -5.379839e-003f, -4.301964e-003f, -2.146471e-003f, -3.733766e-005f,  5.742805e-004f,  4.375355e-004f, -1.414794e-003f,
  -2.605813e-003f, -3.825430e-003f, -4.632708e-003f, -5.245221e-003f, -5.058463e-003f, -3.546147e-003f, -8.394250e-004f,  1.747095e-003f,
   1.646601e-003f,  1.457661e-003f,  1.202467e-003f,  1.772328e-003f,  1.686570e-003f,  1.672008e-003f,  1.508297e-003f,  2.330384e-003f,
   2.994517e-003f,  3.299648e-003f,  3.692325e-003f,  3.485938e-003f,  3.085120e-003f,  3.206366e-003f,  3.738499e-003f,  3.457080e-003f,
   2.440706e-003f,  2.144913e-003f,  3.210450e-003f,  6.737660e-003f,  1.090009e-002f,  1.422796e-002f,  1.495045e-002f,  1.407477e-002f,
   1.192011e-002f,  9.922201e-003f,  8.381329e-003f,  6.567629e-003f,  5.663351e-003f,  7.086741e-003f,  9.295832e-003f,  1.012258e-002f,
   8.157024e-003f,  5.002449e-003f,  1.875768e-003f,  7.787856e-004f, -3.443541e-004f, -1.464699e-003f, -2.657069e-003f, -1.820274e-003f,
   3.324543e-004f,  1.988708e-003f,  2.597837e-003f,  2.145629e-003f,  1.555352e-003f,  1.174320e-003f,  9.672041e-004f,  1.141811e-003f,
   9.157601e-004f,  1.167879e-003f,  1.826425e-003f,  2.412792e-003f,  1.479149e-003f,  2.776773e-004f, -1.193766e-003f, -2.778039e-003f,
  -4.034133e-003f, -4.592431e-003f, -3.750669e-003f, -2.405544e-003f, -6.732084e-004f,  1.435483e-004f,  4.478697e-004f,  6.152201e-004f,
   2.303552e-004f, -1.094660e-003f, -3.409348e-003f, -5.290141e-003f, -5.633660e-003f, -4.414204e-003f, -3.636994e-003f, -2.355497e-003f,
   2.771306e-004f,  3.157045e-003f,  4.401665e-003f,  3.659808e-003f,  1.896390e-003f,  5.216102e-004f, -4.950443e-004f, -1.367818e-003f,
  -3.166943e-003f, -3.558177e-003f, -3.164107e-003f, -2.634077e-003f, -2.930872e-003f, -3.974493e-003f, -3.965151e-003f, -3.455715e-003f,
  -2.450527e-003f, -2.332055e-003f, -1.394646e-003f, -1.508317e-003f, -2.013671e-003f, -3.169930e-003f, -4.731630e-003f, -5.537854e-003f,
  -6.154115e-003f, -5.703582e-003f, -5.106561e-003f, -4.788254e-003f, -4.184156e-003f, -3.902923e-003f, -2.671774e-003f, -2.399530e-003f,
  -2.131566e-003f, -2.296937e-003f, -2.094284e-003f, -3.140978e-003f, -3.151900e-003f, -3.325161e-003f, -1.701540e-003f,  3.938557e-003f,
   1.374362e-002f,  2.721583e-002f,  3.376689e-002f,  2.192419e-002f,  2.541024e-003f, -1.199761e-002f, -1.371062e-002f, -6.939052e-003f,
   2.360484e-003f,  4.081291e-003f,  3.712171e-003f,  2.687436e-003f,  3.116487e-003f,  2.280017e-003f, -7.242128e-004f, -7.071667e-003f,
  -1.059856e-002f, -6.827916e-003f,  1.385155e-004f,  6.065667e-003f,  7.821043e-003f,  5.421696e-003f,  8.824738e-004f, -1.921538e-003f,
  -9.939316e-004f, -1.999455e-004f,  1.441506e-003f,  1.237984e-003f,  1.468772e-003f,  1.361153e-003f,  1.302464e-003f,  3.361626e-004f,
  -1.555404e-003f, -2.057937e-003f, -2.257663e-003f, -1.559493e-003f,  1.091681e-003f,  9.483266e-004f,  8.093203e-004f, -3.378732e-004f,
  -2.681458e-003f, -4.691100e-003f, -4.347431e-003f, -3.806799e-003f, -3.109025e-003f, -2.434054e-003f, -2.630849e-003f, -1.659821e-003f,
  -9.542193e-004f, -1.443280e-003f, -4.326922e-003f, -6.306115e-003f, -8.896290e-003f, -7.098729e-003f, -4.348304e-003f, -2.344719e-003f,
  -3.441573e-003f, -4.063974e-003f, -4.922459e-003f, -2.531117e-003f, -2.822892e-003f, -2.423770e-003f, -3.661362e-003f, -3.054402e-003f,
  -5.405392e-003f, -2.169811e-003f, -3.276251e-003f, -4.872151e-004f, -1.993036e-003f,  2.884644e-003f,  1.536508e-003f,  3.974583e-003f,
   1.650166e-003f,  1.000214e-003f, -3.636579e-004f, -1.691224e-003f, -2.414571e-003f, -3.423321e-003f, -2.712111e-003f, -3.052082e-003f,
  -1.360555e-003f,  2.053039e-003f,  2.043096e-003f,  5.461671e-003f,  2.138036e-003f,  4.000201e-003f, -2.807537e-003f, -3.030565e-003f,
  -3.679688e-003f, -6.955612e-004f,  3.389652e-003f, -1.298517e-003f,  1.875992e-003f, -1.790926e-003f,  4.222321e-003f,  1.096338e-003f,
   6.511338e-003f,  4.274752e-003f,  4.301397e-003f,  5.124741e-005f,  4.532111e-003f, -4.689996e-003f,  1.345023e-002f, -1.732207e-002f,
   1.379343e-001f,  1.506652e-001f,  9.733836e-002f,  1.645298e-002f, -1.219486e-001f, -9.779642e-002f, -1.166095e-001f, -2.317714e-002f,
   5.155893e-002f,  9.625822e-002f,  8.947574e-003f,  4.662767e-004f,  2.728636e-002f, -1.591296e-002f, -2.516734e-002f, -4.166315e-002f,
  -2.552878e-002f, -3.207296e-002f,  1.981822e-002f,  4.038757e-002f,  8.059489e-003f,  1.233916e-002f, -2.847166e-002f,  7.365109e-003f,
   1.476338e-002f,  1.927401e-002f, -8.515347e-003f, -1.431732e-002f,  3.857763e-003f, -2.419959e-002f,  1.241759e-002f, -1.828546e-003f,
   1.495248e-003f, -1.698999e-002f, -1.147503e-002f, -7.647205e-003f, -8.270204e-003f,  6.649876e-003f, -1.436399e-002f, -2.599993e-003f,
  -7.966356e-003f, -1.670095e-003f, -1.313619e-003f, -9.126770e-003f, -4.940611e-003f, -1.614492e-002f,  6.368060e-003f, -6.063059e-003f,
  -8.552417e-003f, -1.208314e-002f, -1.052606e-002f, -9.934212e-003f, -1.367330e-002f, -1.489392e-003f, -7.291475e-003f,  4.136342e-003f,
  -1.163369e-002f, -1.205820e-002f, -1.113726e-002f, -1.729222e-002f, -3.759006e-003f, -1.154173e-002f, -1.634112e-003f, -4.455392e-003f,
   8.114719e-003f, -5.163718e-004f, -6.125653e-003f, -1.201845e-002f, -1.851544e-002f, -1.369343e-002f, -1.635805e-002f, -5.618128e-003f,
   2.245454e-003f,  6.948984e-003f,  1.072291e-002f,  1.280388e-002f,  4.553784e-003f,  3.536001e-002f,  3.378885e-002f,  1.975142e-002f,
  -1.061971e-002f, -3.827881e-002f, -2.357519e-002f, -1.463171e-002f, -7.486295e-003f,  2.995409e-003f,  2.794565e-002f,  3.079748e-002f,
   1.990109e-002f, -3.032846e-003f, -1.937066e-002f, -1.496395e-002f, -5.250161e-003f,  1.417674e-002f,  2.042946e-002f,  2.659274e-002f,
   1.663472e-002f,  7.943908e-003f, -1.341192e-004f, -1.564636e-002f, -1.385445e-002f, -7.275168e-003f,  2.447696e-003f,  1.762409e-003f,
   4.632092e-003f,  4.700719e-003f, -3.331389e-003f, -6.776211e-003f, -1.326205e-002f, -6.673397e-003f, -4.822436e-003f, -9.800725e-004f,
  -2.400147e-003f, -1.969665e-003f, -2.225859e-003f, -3.795263e-003f, -1.471176e-003f, -6.730343e-003f, -6.299047e-003f, -9.561931e-003f,
  -7.504871e-003f, -5.359032e-003f, -7.620174e-003f, -4.623292e-003f, -5.071192e-003f,  1.444267e-003f,  1.614160e-003f,  9.860744e-003f,
   7.705972e-003f,  1.417310e-002f,  3.943672e-002f,  5.872096e-002f,  6.344870e-002f,  1.998286e-002f, -2.413125e-002f, -4.890770e-002f,
  -4.442838e-002f, -2.168266e-002f,  6.508413e-003f,  2.590806e-002f,  1.809334e-002f,  5.560950e-003f, -4.779092e-003f, -4.952842e-003f,
  -5.402810e-003f, -9.363928e-003f, -4.219857e-003f,  6.560995e-003f,  1.707817e-002f,  1.657187e-002f,  1.957341e-002f,  5.705201e-003f,
  -5.339145e-003f, -2.564758e-003f,  1.674254e-003f,  5.417406e-003f,  6.906714e-004f, -4.166763e-003f, -1.011008e-002f, -1.587230e-002f,
  -1.927539e-002f, -1.371449e-002f, -5.104169e-003f, -3.735067e-003f, -4.589688e-003f, -1.205243e-003f,  1.437668e-003f, -1.719726e-003f,
  -4.827590e-003f, -4.596681e-003f, -4.342751e-003f, -5.617998e-003f, -7.776098e-003f, -4.962755e-003f,  2.569113e-003f,  7.129460e-003f,
   6.205047e-003f,  6.835842e-003f,  2.475544e-003f, -1.576050e-003f, -6.819049e-003f, -8.971804e-003f, -4.759110e-003f, -2.411090e-003f,
  -2.398269e-003f, -5.445053e-003f, -3.461814e-003f, -5.802225e-003f, -4.788872e-003f, -2.688864e-003f, -1.571464e-003f, -1.465800e-003f,
   3.953393e-004f,  4.876631e-003f,  6.021210e-003f,  4.213690e-003f, -1.731877e-004f,  3.598557e-003f,  2.298119e-003f,  3.082707e-003f,
   3.710897e-003f,  2.674429e-003f,  8.142542e-004f, -1.683771e-003f, -2.691854e-003f, -7.642677e-004f, -8.417722e-005f,  1.382480e-003f,
   4.389121e-003f,  1.653293e-002f,  1.931303e-002f,  1.895568e-002f,  1.171049e-002f,  4.399351e-003f,  5.451725e-003f,  3.908764e-003f,
   6.628964e-003f,  1.845366e-003f, -1.804159e-003f, -1.902385e-002f, -1.518162e-002f, -7.396960e-003f, -3.891297e-003f, -4.944116e-003f,
  -1.245719e-002f, -8.188373e-003f, -4.555073e-003f,  2.851048e-003f, -3.556951e-003f, -4.979828e-003f, -4.618408e-003f, -3.968188e-003f,
   7.766460e-003f,  1.061914e-002f,  1.099982e-002f,  4.884445e-003f,  7.985965e-003f,  7.737454e-003f,  8.150322e-003f,  1.045313e-002f,
   3.395055e-003f, -7.540380e-004f, -5.085721e-003f, -3.188146e-003f, -5.055161e-003f, -5.233996e-003f, -8.735596e-003f, -2.800558e-003f,
   7.125906e-003f,  1.220296e-002f,  1.624477e-002f,  8.968571e-003f,  5.556507e-003f,  6.075393e-004f,  9.722288e-004f,  3.238022e-003f,
   1.137513e-003f,  5.146446e-003f,  2.557965e-003f,  2.380614e-002f,  3.681158e-002f,  9.261093e-003f,  1.889287e-002f, -2.251861e-002f,
  -2.756743e-002f, -9.311861e-003f,  1.273874e-003f,  2.781218e-002f,  1.836675e-002f,  3.582206e-002f,  6.263734e-003f,  5.510695e-003f,
  -4.156918e-003f, -5.160304e-004f,  2.168992e-002f,  2.200940e-002f,  2.067422e-002f,  1.431443e-002f, -3.334585e-003f, -1.736472e-002f,
  -7.750573e-003f, -2.378454e-002f, -2.583548e-002f, -1.431193e-002f, -2.198745e-003f, -4.726977e-003f, -5.310843e-003f, -3.534106e-003f,
  -2.156644e-002f, -1.785778e-002f, -9.718762e-003f, -1.562209e-002f, -1.481872e-002f, -1.332914e-002f, -1.099895e-002f, -7.099420e-003f,
  -8.016509e-003f, -1.346530e-002f, -1.161694e-002f, -5.407176e-003f, -5.667446e-003f,  3.341404e-003f,  4.224616e-003f,  5.281735e-003f,
   1.808070e-003f, -3.550661e-003f, -1.409637e-003f, -5.430046e-003f, -3.207697e-003f, -1.147579e-002f,  9.867772e-003f,  5.594587e-004f,
   1.274247e-002f,  1.264492e-002f,  2.004878e-003f,  2.398799e-003f, -1.313243e-003f,  2.008089e-002f,  5.990926e-003f,  2.514038e-002f,
   1.114303e-002f,  1.269620e-002f,  1.591009e-003f, -1.321256e-002f, -6.530392e-003f, -1.942408e-002f, -2.823206e-003f, -9.952259e-003f,
   9.506478e-003f,  5.078826e-003f,  4.135217e-003f,  4.920387e-003f, -1.001093e-002f, -6.060908e-003f, -1.417391e-002f, -9.428463e-004f,
  -1.203425e-004f,  1.588247e-002f,  2.332631e-002f,  1.679431e-002f,  1.759854e-002f,  1.891997e-003f,  3.873598e-005f, -7.312599e-003f,
  -5.105836e-003f, -3.601458e-003f, -2.810233e-004f,  4.872128e-003f, -3.143608e-003f,  8.193513e-003f, -1.632563e-003f,  2.244336e-003f,
  -1.791284e-004f, -6.016036e-003f, -5.995740e-003f, -9.782060e-003f, -8.806057e-004f,  2.142437e-003f,  2.111867e-002f,  2.388162e-002f,
   1.702982e-002f, -1.993341e-003f, -1.890206e-002f, -1.806037e-002f, -1.802886e-002f, -6.359690e-003f, -6.010675e-003f,  1.077883e-003f,
   1.875957e-003f,  8.968818e-004f,  5.227399e-003f, -7.898524e-004f,  5.309997e-003f, -5.589772e-003f, -4.412394e-003f, -1.147466e-002f,
  -1.551085e-002f, -1.248692e-002f, -1.082860e-002f, -1.564090e-003f,  6.587576e-004f,  6.715445e-003f,  3.289677e-003f, -2.080494e-003f,
  -1.401512e-002f, -1.462800e-002f, -1.013740e-002f, -9.336317e-003f, -4.098057e-003f, -2.421236e-003f,  3.465650e-003f,  2.006566e-003f,
  -9.292678e-003f, -1.263269e-002f,  7.040851e-003f,  1.728620e-002f,  1.500315e-002f,  9.594604e-003f, -8.808912e-004f,  1.372514e-003f,
  -9.711487e-003f, -1.510333e-002f, -1.019990e-002f, -6.276855e-003f, -1.715188e-004f, -2.807214e-004f,  1.814646e-003f,  3.826184e-003f,
   2.467231e-003f, -1.300304e-003f,  2.489433e-003f,  7.701137e-003f,  1.516268e-002f,  2.599624e-002f,  2.564351e-002f,  1.791075e-002f,
   2.527349e-003f, -9.546734e-003f, -1.102686e-002f, -4.208721e-004f,  5.875866e-003f,  1.351407e-002f,  1.564695e-002f,  1.528344e-002f,
   1.182484e-002f,  6.632326e-003f,  1.048439e-003f, -3.279584e-003f, -2.030882e-003f, -2.196426e-003f,  2.380408e-003f,  1.287275e-003f,
   1.496846e-003f, -1.542773e-003f,  1.584886e-003f,  3.422609e-003f,  1.767836e-003f,  1.022539e-003f, -6.181826e-003f, -5.653528e-003f,
  -7.855555e-003f, -4.913388e-003f,  2.401732e-004f, -2.475683e-003f, -2.102571e-003f, -1.751729e-003f,  3.347514e-003f,  4.076071e-003f,
   8.075811e-003f,  4.676900e-003f,  2.296462e-003f,  4.309791e-003f,  3.482312e-003f,  4.894311e-003f,  2.026361e-003f, -5.287595e-004f,
  -3.769645e-003f, -4.044662e-003f, -1.313937e-003f,  8.322551e-004f,  3.096729e-003f,  6.208878e-004f, -7.136391e-004f, -5.187228e-003f,
  -8.195867e-003f, -5.347856e-003f, -4.213466e-003f, -2.576268e-003f, -2.400073e-003f, -3.637912e-003f, -7.488567e-003f, -8.348513e-003f,
  -7.785458e-003f, -7.095016e-003f, -5.175463e-003f, -2.328974e-003f,  1.904866e-004f,  5.115732e-003f,  6.022634e-003f,  7.081949e-003f,
   6.453935e-003f,  2.805695e-003f,  6.810397e-004f,  9.672767e-005f,  6.118923e-004f, -2.529442e-003f, -4.052056e-004f,  2.434171e-003f,
   9.159142e-003f,  1.618299e-002f,  1.741769e-002f,  1.020889e-002f, -2.429531e-003f, -6.617406e-003f, -7.025729e-003f, -2.847993e-003f,
  -4.148445e-003f, -8.183533e-003f, -8.804976e-003f, -3.942194e-003f,  2.825833e-003f,  3.934627e-003f,  3.821260e-003f, -1.433291e-003f,
  -5.557297e-003f, -3.945636e-003f, -4.958884e-004f, -1.266560e-003f, -2.504892e-003f, -5.163099e-003f, -6.485362e-003f, -2.995274e-003f,
  -4.878509e-003f, -4.672309e-003f, -3.980248e-003f, -1.694009e-003f,  4.279669e-003f,  6.430233e-003f,  2.703493e-003f, -1.153988e-003f,
  -1.635068e-003f, -3.600855e-003f, -3.886199e-004f, -1.740992e-003f, -2.717670e-003f,  2.533254e-003f,  5.913671e-003f,  9.795196e-003f
};

static const float VastImpulseRight5[] =
{
  -6.353634e-004f, -9.125725e-004f, -7.957857e-003f, -1.125276e-002f, -9.356337e-003f, -4.004475e-003f,  2.923527e-003f,  8.496713e-003f,
   5.163023e-003f,  6.106874e-003f, -5.615887e-003f, -1.286161e-002f, -8.632543e-003f, -1.084733e-002f, -8.424267e-003f, -1.276744e-002f,
  -1.893759e-002f, -1.446957e-002f, -1.562183e-002f, -1.238981e-002f, -1.240230e-002f, -6.891051e-003f, -1.049099e-002f, -6.370553e-003f,
  -8.012640e-003f, -5.492120e-003f, -8.803345e-003f, -1.042983e-002f, -1.060821e-002f, -3.594796e-003f, -4.217256e-003f, -3.062013e-003f,
  -3.960588e-003f, -1.654916e-004f, -3.953987e-003f, -1.958709e-005f, -4.803374e-003f, -2.129814e-003f, -7.459946e-003f, -5.426444e-003f,
  -5.445648e-003f, -1.240596e-003f, -3.208736e-003f, -3.853187e-003f, -7.052467e-003f, -4.406393e-003f, -6.749711e-003f, -4.758405e-003f,
  -4.410283e-003f, -4.217097e-003f, -3.697473e-003f, -5.414263e-003f, -6.292464e-003f, -1.264805e-003f, -4.376141e-003f, -3.137361e-003f,
  -3.852461e-003f, -4.446722e-003f, -4.041541e-004f, -5.023964e-003f, -2.961650e-004f, -2.428150e-003f,  4.656889e-003f, -6.625661e-003f,
   4.308222e-004f, -8.079915e-003f,  6.679412e-003f, -6.289480e-003f,  1.315020e-002f, -1.188952e-002f,  2.443349e-002f, -3.385840e-002f,
   6.039114e-002f, -1.147424e-001f,  5.157493e-001f,  5.822400e-001f,  1.443588e-001f,  2.330720e-001f, -3.356049e-001f, -1.569153e-001f,
  -2.784377e-001f, -3.969739e-001f,  3.623629e-001f,  2.967618e-001f, -1.662662e-001f, -1.746710e-001f, -1.208661e-001f,  1.586173e-001f,
   1.601242e-001f,  3.813658e-002f,  9.695321e-004f, -4.166533e-002f, -1.244255e-001f, -1.122463e-001f,  6.624279e-003f, -5.532645e-002f,
  -3.471114e-002f, -9.419564e-002f, -3.626612e-002f,  1.678363e-001f,  7.416722e-002f, -1.583825e-003f, -5.084598e-002f,  3.125795e-002f,
  -1.826332e-002f,  4.978000e-004f, -1.297226e-002f, -3.256180e-002f,  1.510610e-002f, -4.937610e-002f,  3.400043e-002f,  3.944064e-003f,
   2.762212e-002f, -1.354595e-002f, -3.640598e-002f,  3.642399e-003f, -1.616153e-003f,  1.572531e-002f, -2.981488e-002f, -5.684446e-003f,
  -1.848977e-002f, -1.088411e-002f,  4.109108e-003f, -1.092469e-002f,  5.335809e-004f, -4.519473e-002f,  1.215504e-002f,  2.227928e-003f,
   2.864853e-002f, -3.241064e-003f, -2.592134e-002f,  4.461049e-003f, -2.203080e-002f, -1.286690e-002f, -3.088832e-003f,  3.922107e-002f,
   4.635585e-004f, -1.091405e-002f, -6.022677e-003f,  1.823871e-002f,  3.348375e-002f, -2.380441e-002f,  4.450401e-003f, -1.138512e-002f,
  -8.502606e-003f, -1.210551e-002f, -2.049679e-003f,  1.419309e-002f, -1.498696e-002f, -1.169918e-002f, -1.627017e-002f,  1.290835e-002f,
   3.579606e-003f,  2.734026e-003f,  2.877382e-003f, -1.623726e-002f, -3.277493e-003f, -1.033790e-002f,  1.031340e-002f,  2.538447e-003f,
  -4.862401e-003f, -7.951640e-003f, -8.511229e-003f,  7.236401e-003f, -2.149407e-003f,  2.544044e-003f, -1.418571e-002f, -3.952514e-003f,
  -1.896583e-004f,  3.123400e-004f,  1.457137e-003f, -7.340380e-003f, -3.014308e-003f, -1.212704e-002f, -2.857609e-003f, -7.640329e-004f,
   9.994444e-003f,  9.848384e-003f, -2.575437e-004f,  1.329964e-002f,  2.992099e-003f, -6.204394e-004f, -5.881309e-003f, -1.065337e-002f,
  -2.061245e-003f, -8.713579e-004f,  1.905847e-003f,  9.833787e-003f,  5.536117e-003f, -3.774895e-003f, -6.369173e-003f,  5.263162e-004f,
   6.190988e-003f,  4.751659e-003f,  2.434462e-003f,  3.233844e-003f,  4.708912e-004f, -1.628231e-003f,  1.470769e-003f,  6.004815e-003f,
   6.360794e-003f,  1.271708e-003f,  5.941939e-003f,  6.257531e-003f, -2.241855e-003f, -3.740618e-003f, -5.504880e-003f, -4.274030e-003f,
  -1.379918e-003f, -2.645241e-003f,  2.556375e-003f,  1.019867e-002f,  1.176323e-002f,  1.453777e-002f,  1.493531e-002f,  1.055388e-002f,
   6.481065e-003f, -4.371572e-003f, -7.140869e-003f, -3.970091e-003f, -3.484195e-004f, -8.075707e-004f, -1.494459e-003f, -1.551450e-003f,
  -3.532361e-003f,  2.066647e-004f,  7.529776e-004f, -1.007336e-003f, -3.333731e-003f, -8.304128e-003f, -5.167194e-003f, -6.548471e-004f,
   1.267414e-003f,  3.537060e-003f,  4.431965e-003f,  3.581375e-003f,  2.829195e-003f,  8.805827e-003f,  9.212656e-003f,  8.829796e-003f,
   3.076655e-003f, -2.268539e-003f, -3.211129e-003f, -4.193437e-003f, -2.960654e-003f, -4.871493e-004f,  1.157257e-003f, -2.105144e-003f,
   1.150080e-003f,  2.702250e-003f,  3.961567e-003f,  2.854443e-003f, -6.705183e-005f,  1.883132e-003f, -2.900633e-003f, -4.371169e-003f,
  -4.613140e-003f, -4.551397e-003f, -4.135470e-003f, -4.771132e-003f,  5.292435e-004f, -1.454763e-004f,  1.223365e-003f,  2.810049e-004f,
   2.349262e-003f,  1.126182e-002f,  1.912305e-002f,  2.692232e-002f,  2.325365e-002f,  1.848563e-002f,  1.595124e-002f,  1.521266e-002f,
   1.233795e-002f,  1.481946e-004f, -5.250243e-003f, -5.075416e-003f,  1.744326e-003f,  5.666381e-003f, -7.856718e-004f, -7.333984e-003f,
  -1.557300e-002f, -1.208152e-002f, -1.045024e-002f, -1.161152e-002f, -1.139149e-002f, -4.134048e-003f,  7.021826e-003f,  4.998705e-003f,
   5.919652e-003f,  2.907189e-003f, -1.132342e-003f, -2.747844e-003f, -1.145201e-002f, -1.430547e-003f, -2.395873e-005f,  3.326199e-003f,
   8.065634e-003f,  1.878797e-003f,  4.216983e-003f, -8.939731e-004f, -2.324781e-003f, -9.754395e-003f, -1.435512e-002f, -1.225135e-002f,
  -1.093165e-003f,  4.680148e-003f, -3.305020e-003f, -3.705529e-003f, -2.248459e-003f,  4.412620e-004f, -3.480574e-003f, -1.203113e-003f,
   1.667458e-003f, -7.763865e-004f,  4.137731e-004f, -1.428148e-003f,  4.414901e-003f, -1.894468e-003f,  2.974284e-003f, -4.423264e-003f,
  -1.431997e-002f, -7.062758e-006f, -6.274664e-003f, -1.979189e-003f, -4.136160e-004f, -1.420722e-003f,  8.019684e-003f,  2.906733e-006f,
  -4.221725e-003f,  1.832630e-003f,  3.520054e-003f, -5.881244e-003f, -9.530017e-003f, -1.172253e-002f, -9.307432e-003f, -4.927952e-003f,
  -1.419989e-002f, -1.432223e-003f, -8.864226e-004f, -3.012129e-003f, -1.982264e-003f, -5.701457e-003f,  2.499805e-003f,  6.505634e-004f,
  -5.203441e-005f, -1.546689e-003f,  3.900515e-003f,  6.136055e-003f,  4.162045e-003f,  4.408231e-003f, -5.426947e-004f,  1.719183e-003f,
  -3.544096e-004f, -2.860392e-003f,  1.412143e-004f, -3.605229e-004f,  1.309814e-003f, -2.180052e-003f, -2.562672e-004f, -2.490747e-004f,
   3.321949e-003f,  1.407373e-002f,  2.822289e-002f,  4.667633e-002f,  4.000233e-002f,  1.248557e-002f, -1.301201e-002f, -2.568851e-002f,
  -2.089682e-002f, -5.808218e-003f,  3.494451e-003f,  3.839096e-003f,  6.950202e-003f,  3.767494e-003f,  3.355046e-003f,  1.954157e-003f,
  -4.640467e-003f, -1.147344e-002f, -1.702759e-002f, -1.272024e-002f, -3.048955e-004f,  1.134741e-002f,  1.006192e-002f,  4.238103e-003f,
  -3.765989e-003f, -6.195740e-003f, -3.365509e-003f, -2.357250e-003f,  5.730868e-004f, -1.102306e-004f, -1.917981e-003f, -3.125446e-004f,
   5.368341e-004f,  3.855457e-003f,  4.177495e-003f,  1.044096e-003f, -1.632052e-003f, -2.359473e-003f, -1.234469e-004f, -2.179078e-003f,
  -6.304165e-003f, -6.337791e-003f, -2.958054e-003f,  2.582800e-003f,  3.634135e-003f,  3.726151e-003f, -1.109347e-003f, -1.097374e-003f,
   3.529598e-003f,  1.421338e-002f,  1.986732e-003f, -1.160551e-003f, -7.594817e-003f, -5.198628e-003f, -2.980808e-003f, -1.149071e-002f,
  -3.571380e-003f,  3.600616e-004f,  4.200628e-003f, -8.045208e-003f, -9.647961e-003f, -6.194856e-003f,  3.961330e-003f,  6.674952e-003f,
   1.263428e-002f,  1.573046e-002f,  8.597439e-003f,  4.668913e-003f, -4.051748e-003f, -2.849943e-003f, -3.836911e-003f, -3.978937e-003f,
  -6.689731e-003f, -4.923100e-003f,  1.403264e-003f,  5.568969e-003f,  4.567420e-003f,  3.276658e-003f,  6.564602e-003f, -2.552508e-003f,
   7.089563e-003f, -3.099030e-003f,  2.236764e-003f, -5.223099e-003f, -1.480585e-002f, -2.373412e-003f, -3.752572e-003f,  1.779229e-003f,
  -6.573139e-003f, -5.547200e-003f, -3.653592e-003f, -6.539706e-003f, -3.522886e-003f,  2.119114e-003f,  8.719308e-003f,  8.254774e-003f,
   7.591448e-003f,  3.621348e-003f, -4.126188e-003f, -1.290916e-002f, -1.624693e-002f, -5.699137e-003f, -2.589990e-003f, -2.570572e-004f,
  -2.082031e-004f,  3.656353e-004f, -1.224192e-003f, -2.480458e-003f, -3.022850e-003f, -4.564227e-003f, -1.847182e-003f, -6.010304e-003f,
  -7.651469e-003f, -5.247004e-003f, -2.163161e-004f, -1.777623e-003f, -6.602344e-003f, -1.718509e-003f,  2.747789e-003f,  5.694299e-003f,
  -5.325201e-003f, -1.051914e-002f, -9.914488e-003f, -4.698581e-003f, -2.874146e-003f,  2.105740e-003f,  9.770013e-003f,  1.574350e-002f,
   1.603700e-002f,  1.312261e-002f,  8.336180e-003f, -1.689871e-003f, -6.799466e-003f, -6.828929e-003f, -4.094025e-003f, -1.050848e-003f,
   4.604337e-003f,  7.178384e-003f,  1.398659e-002f,  1.311616e-002f,  1.475324e-002f,  1.988563e-002f,  1.962605e-002f,  1.341026e-002f,
   1.181300e-002f,  1.677661e-003f, -1.253133e-002f, -2.381854e-002f, -2.861381e-002f, -2.434469e-002f, -1.065793e-002f,  3.986304e-003f,
   1.252846e-002f,  1.238214e-002f,  2.324295e-003f, -5.452887e-003f, -1.154224e-002f, -1.492770e-002f, -1.619839e-002f, -1.254357e-002f,
  -8.459273e-003f, -2.315255e-003f, -7.895372e-005f,  2.035585e-004f, -1.443347e-003f, -2.022991e-003f, -3.407437e-003f, -5.122141e-003f,
  -3.448220e-003f, -6.606433e-003f, -6.581832e-003f, -6.430212e-003f, -7.563897e-003f, -4.454785e-003f, -1.461634e-003f,  9.128814e-004f,
   3.655300e-003f,  2.773531e-003f,  4.560508e-003f,  3.285058e-004f,  7.781094e-004f,  7.605311e-003f,  4.876156e-003f,  9.389936e-003f,
   1.862067e-003f, -7.782097e-003f, -1.062132e-002f, -1.270758e-002f,  6.792188e-004f,  3.172193e-003f,  1.096647e-002f,  1.594274e-002f,
   1.202176e-002f,  5.042063e-003f, -8.479824e-003f, -1.348302e-002f, -1.358003e-002f, -1.096732e-002f, -6.475851e-003f,  4.601491e-003f,
   6.646259e-003f,  1.044867e-002f,  1.004299e-002f,  3.393583e-003f,  2.059276e-003f, -4.286123e-003f, -5.595739e-003f, -5.167650e-003f,
  -6.424150e-003f, -3.138866e-003f, -1.633308e-003f,  3.643559e-003f,  2.379002e-004f,  6.180979e-006f, -9.317323e-004f, -3.590790e-003f,
  -6.405221e-003f, -8.438698e-003f, -4.559361e-003f, -3.251065e-003f,  1.775300e-003f,  3.254659e-003f,  3.121127e-003f, -4.789600e-004f,
  -2.751907e-003f, -4.889804e-003f, -5.109976e-003f,  2.049833e-003f,  8.354407e-003f,  1.046352e-002f,  1.411079e-002f,  9.708400e-003f,
   4.547218e-003f, -7.467233e-004f, -4.802957e-003f, -7.199998e-003f, -1.031487e-002f, -8.593906e-003f, -4.105041e-003f, -1.667103e-003f,
   1.273121e-004f, -3.433494e-003f, -2.721929e-003f, -4.135565e-003f, -2.109477e-003f,  7.883668e-003f,  6.575703e-003f,  8.008463e-003f,
   2.452348e-003f, -3.053565e-003f, -1.189630e-002f, -1.278164e-002f, -7.670660e-003f, -8.958079e-004f,  7.593069e-003f,  1.803910e-002f,
   2.086514e-002f,  1.383324e-002f,  8.108694e-003f, -8.176612e-003f, -7.837095e-003f, -5.104728e-003f,  1.562824e-004f,  1.368577e-002f,
   1.987455e-002f,  1.785929e-002f,  8.593421e-003f,  1.765762e-003f, -1.009024e-002f, -1.299471e-002f, -1.452326e-002f, -1.220556e-002f,
  -8.172857e-003f, -8.581465e-003f, -4.020507e-004f, -1.248812e-003f, -1.055984e-003f, -4.426173e-003f, -4.425393e-003f, -1.561027e-003f,
  -4.099367e-003f, -4.806305e-003f, -2.721184e-003f,  5.239801e-003f,  9.614321e-003f,  1.417691e-002f,  1.229376e-002f,  2.467317e-004f,
  -8.415900e-003f, -1.219805e-002f, -6.549904e-003f,  1.286480e-003f,  6.708512e-003f,  8.943118e-003f,  7.896743e-003f,  4.391022e-003f,
   4.078800e-003f,  1.218457e-003f, -5.371092e-003f, -5.702614e-003f, -6.861932e-003f, -3.430664e-003f,  1.701523e-005f,  2.586025e-003f,
   7.515080e-003f,  6.459921e-003f,  3.875904e-003f,  5.422009e-003f,  5.387880e-003f,  4.047748e-003f,  2.443837e-003f, -1.946906e-003f,
  -3.738009e-003f, -2.500525e-003f, -1.600114e-003f,  2.367340e-003f,  1.406047e-003f, -3.014487e-003f, -2.703488e-003f, -7.740277e-004f,
  -3.313198e-003f, -7.611467e-004f, -1.915413e-004f, -3.301329e-003f, -1.834544e-003f, -2.598572e-003f, -1.635257e-003f,  1.917924e-003f,
   1.643507e-003f,  1.260141e-003f,  3.878655e-004f, -1.782649e-003f, -3.712935e-003f, -2.915450e-003f, -1.692676e-003f,  3.219336e-004f,
   1.609245e-003f,  3.346357e-003f,  6.841274e-003f,  9.307955e-003f,  1.169531e-002f,  1.478560e-002f,  1.863198e-002f,  1.342282e-002f,
   5.969678e-003f, -2.496876e-003f, -2.645403e-003f, -1.169431e-003f, -2.248023e-003f,  2.736785e-003f,  1.037235e-003f,  1.920364e-003f,
  -1.125918e-003f, -3.453170e-003f, -3.624537e-003f, -4.354157e-003f, -6.165035e-004f, -6.233183e-004f,  4.018495e-003f,  9.823409e-003f,
   1.759784e-002f,  1.376727e-002f,  5.816494e-003f, -3.939510e-003f, -1.019999e-002f, -7.146254e-003f, -5.673457e-003f, -3.842199e-003f,
   8.859917e-004f, -5.480213e-003f, -6.095204e-003f, -1.573259e-003f,  4.063653e-003f,  9.323382e-003f,  4.582433e-003f,  3.058289e-003f,
  -1.666988e-003f, -9.666137e-003f, -8.191481e-003f,  2.640574e-004f, -3.915231e-003f, -5.136722e-003f, -6.668444e-003f,  5.118591e-004f,
   1.443498e-002f,  1.128007e-002f,  6.585117e-003f,  5.950618e-003f,  9.363232e-004f, -5.879024e-003f, -7.845773e-003f, -1.813372e-003f,
   1.718198e-003f,  2.637807e-004f, -7.352567e-004f,  6.337588e-003f,  1.240125e-002f,  1.021917e-002f,  7.611147e-003f,  6.728157e-003f,
   6.312822e-003f,  4.901440e-003f, -1.401130e-003f, -3.771821e-003f, -6.842867e-003f, -6.121451e-003f, -2.335135e-003f,  1.204910e-003f,
  -1.167224e-003f,  1.456329e-003f, -2.124780e-003f, -5.671258e-003f, -2.970464e-003f, -6.767715e-003f, -6.366080e-003f, -4.971202e-003f,
  -2.612784e-003f, -1.005305e-003f,  1.677140e-003f,  8.574831e-004f, -1.339400e-003f, -6.957285e-003f, -6.791898e-003f, -8.724450e-004f,
   3.432933e-003f,  4.055235e-003f,  1.729393e-003f, -3.893561e-003f, -5.235818e-003f, -4.520204e-003f, -6.156896e-003f, -2.512864e-003f,
   8.851042e-004f, -9.265652e-003f, -7.995040e-003f, -8.466022e-003f, -4.051740e-003f, -4.121420e-003f, -8.716839e-003f,  2.536561e-004f,
   8.036343e-003f,  9.744578e-003f,  6.556352e-003f,  2.413202e-003f, -1.698931e-003f, -4.243935e-003f, -9.963604e-003f, -1.674537e-002f,
  -1.040117e-002f, -7.655329e-003f, -5.537898e-003f, -3.375480e-004f, -7.562708e-004f,  3.826280e-003f,  6.130396e-004f, -3.008925e-003f,
  -3.078204e-003f, -3.615389e-003f, -3.566749e-003f, -3.062368e-004f,  1.573996e-003f,  4.963693e-003f,  9.434647e-003f,  9.916099e-003f,
   8.017902e-003f,  7.446977e-003f,  5.346479e-003f,  2.789687e-003f, -2.379326e-003f, -3.724557e-003f, -7.598468e-004f,  4.012921e-003f,
   4.775694e-003f,  6.173384e-003f,  1.399137e-004f, -1.388664e-003f, -3.075673e-003f, -3.785758e-003f, -3.504035e-003f, -4.071056e-003f,
  -3.608499e-003f,  2.573620e-003f,  1.057743e-002f,  1.504995e-002f,  1.092227e-002f, -6.891941e-004f, -9.471327e-003f, -1.448158e-002f,
  -7.968914e-003f,  1.819842e-003f,  6.786323e-003f,  1.026326e-002f,  7.721651e-003f,  1.001930e-002f,  4.700550e-002f,  3.896147e-002f,
   2.237500e-002f,  7.532463e-003f, -2.693275e-002f, -2.615043e-002f, -3.180307e-002f, -1.654896e-002f,  2.500896e-002f,  3.685708e-002f,
   2.307255e-002f,  1.472417e-002f,  1.732533e-002f,  2.375311e-003f,  4.116509e-004f, -6.382140e-003f, -1.683208e-002f, -2.114920e-002f,
  -1.039466e-002f,  1.027840e-002f,  6.472727e-005f, -3.351838e-003f, -1.012319e-002f, -8.116008e-003f,  6.463560e-004f,  4.195839e-003f,
  -2.082490e-003f, -3.065257e-003f, -1.308954e-002f, -2.120513e-002f, -1.019608e-002f, -9.839545e-004f,  5.553812e-003f,  9.765532e-003f,
   4.838993e-003f,  4.993702e-003f,  3.824412e-003f, -3.572723e-003f, -2.499338e-003f, -7.000101e-003f, -2.954637e-003f, -5.243842e-003f,
  -6.198326e-004f, -3.267396e-003f, -1.602423e-003f, -5.448173e-003f, -2.208864e-003f, -1.284127e-003f,  3.999801e-003f,  1.035660e-002f,
   5.341887e-003f, -1.264843e-003f, -4.555540e-003f, -2.052010e-005f,  7.724921e-004f, -1.717759e-003f, -1.161191e-002f, -5.734944e-003f,
  -3.206516e-003f, -2.648350e-003f,  3.637457e-003f,  6.335474e-003f,  4.359656e-003f,  8.009964e-003f,  4.861048e-004f,  2.169148e-003f,
  -2.388827e-003f, -2.377169e-003f,  5.372779e-004f, -2.499912e-003f,  8.345047e-004f,  5.637357e-003f,  2.672850e-003f, -1.760920e-003f,
  -1.051853e-004f, -2.916056e-003f, -3.595433e-003f, -3.730452e-003f, -9.106703e-004f,  3.093957e-003f,  1.339795e-002f,  3.005507e-002f,
   4.251435e-002f,  3.301691e-002f,  3.655808e-003f, -1.613079e-002f, -2.387464e-002f, -2.127141e-002f, -4.788902e-003f,  1.561879e-003f,
   4.771052e-003f,  1.502064e-003f, -1.787959e-005f,  3.159462e-003f,  7.608081e-003f,  4.081371e-003f, -6.235826e-003f, -9.346615e-003f,
  -9.696960e-003f, -4.854941e-003f, -3.134723e-003f, -2.177445e-004f, -1.626876e-003f, -1.841398e-003f, -9.019840e-004f, -3.661951e-003f,
  -3.353263e-003f, -6.801572e-003f, -5.623100e-003f, -6.768177e-003f, -5.565631e-003f, -2.917316e-003f, -3.360443e-003f, -3.624625e-003f,
  -6.801127e-003f, -1.455185e-003f,  7.802331e-004f,  3.653086e-003f,  6.458472e-003f,  4.659153e-003f,  5.860571e-003f, -2.238111e-003f,
  -5.601641e-003f, -1.263668e-002f, -1.520134e-002f, -1.305345e-002f, -8.745967e-003f, -6.663483e-004f, -1.523883e-003f,  1.359910e-003f,
  -1.460183e-003f, -9.798341e-004f, -1.002127e-003f, -1.516735e-003f,  8.538034e-003f,  7.370579e-003f,  9.668532e-003f,  8.054184e-003f,
  -3.468941e-004f, -1.995064e-003f, -7.764430e-003f, -5.252448e-003f, -4.844245e-003f, -5.663356e-004f,  4.221000e-003f,  2.308576e-003f
};

const HRTF_DATA SpatialDecVastHRTF =
{
  44100,
  1000,
  {
    {
      {
         7.555034e-002f,  2.019329e-001f,  4.556726e-001f,  7.915036e-001f,  1.002720e+000f,  8.377898e-001f,  7.555865e-001f,
         7.637722e-001f,  9.779786e-001f,  7.647562e-001f,  1.194906e+000f,  1.428592e+000f,  1.923245e+000f,  2.076565e+000f,
         2.141423e+000f,  1.964134e+000f,  2.156052e+000f,  2.654194e+000f,  2.452708e+000f,  1.418070e+000f,  6.689099e-001f,
         5.434193e-001f,  2.948060e-001f,  5.547354e-001f,  7.234264e-001f,  8.388022e-001f,  1.383256e+000f,  8.741431e-001f
      },
      {
         3.173355e-002f,  1.422408e-001f,  3.171284e-001f,  4.885645e-001f,  5.964610e-001f,  4.800155e-001f,  3.254725e-001f,
         3.104958e-001f,  3.284488e-001f,  2.899071e-001f,  5.274247e-001f,  7.108539e-001f,  7.503902e-001f,  6.936868e-001f,
         6.862617e-001f,  6.303142e-001f,  8.649968e-001f,  9.639582e-001f,  6.014536e-001f,  2.524758e-001f,  1.004460e-001f,
         1.181265e-001f,  3.693323e-002f,  4.744367e-002f,  2.398258e-001f,  2.034003e-001f,  3.524360e-001f,  2.469210e-001f
      },
      {
         9.491908e-001f,  9.916534e-001f,  9.964026e-001f,  9.990383e-001f,  9.967277e-001f,  9.877245e-001f,  9.987046e-001f,
         9.955565e-001f,  9.985558e-001f,  9.832791e-001f,  9.881461e-001f,  9.713792e-001f,  9.903426e-001f,  9.947786e-001f,
         9.928117e-001f,  9.948255e-001f,  9.798839e-001f,  9.348688e-001f,  9.666133e-001f,  9.760712e-001f,  9.420392e-001f,
         7.081122e-001f,  6.330766e-001f,  3.932321e-001f,  9.826707e-001f,  5.720964e-001f,  5.209285e-001f,  8.434819e-001f
      },
      {
         1.645709e-001f,  9.403384e-002f,  4.974792e-001f,  6.832150e-001f,  8.397243e-001f,  1.294407e+000f,  1.515001e+000f,
         1.693030e+000f,  1.910095e+000f,  2.095338e+000f,  2.598282e+000f,  3.315327e+000f,  3.984095e+000f,  4.367259e+000f,
         4.749253e+000f,  5.072494e+000f,  5.569224e+000f,  6.621511e+000f,  7.663245e+000f,  8.377462e+000f,  8.740573e+000f,
         1.050914e+001f,  1.345331e+001f,  1.455951e+001f,  1.614087e+001f,  1.788305e+001f,  1.979769e+001f,  2.336553e+001f
      },
      VastImpulseLeft1,
      VastImpulseRight1
    },
    {
      {
         4.020475e-002f,  1.743843e-001f,  3.888547e-001f,  6.040149e-001f,  7.448009e-001f,  6.098266e-001f,  4.203496e-001f,
         3.722810e-001f,  3.717077e-001f,  2.920591e-001f,  6.234830e-001f,  8.647019e-001f,  8.696923e-001f,  7.824079e-001f,
         7.149499e-001f,  6.350401e-001f,  8.103125e-001f,  8.485292e-001f,  5.679039e-001f,  3.235464e-001f,  1.922469e-001f,
         1.510689e-001f,  1.376525e-001f,  1.358341e-001f,  1.593037e-001f,  1.770829e-001f,  2.561142e-001f,  1.446438e-001f
      },
      {
         5.366247e-002f,  1.663195e-001f,  3.834574e-001f,  6.505246e-001f,  8.114858e-001f,  6.746396e-001f,  6.317927e-001f,
         6.465764e-001f,  7.916352e-001f,  7.330398e-001f,  1.068902e+000f,  1.270735e+000f,  1.624006e+000f,  1.743769e+000f,
         2.002246e+000f,  1.977706e+000f,  2.546978e+000f,  2.960862e+000f,  2.255232e+000f,  1.133931e+000f,  3.739543e-001f,
         3.901376e-001f,  2.567350e-001f,  2.456903e-001f,  7.979958e-001f,  1.165506e+000f,  1.467462e+000f,  1.345719e+000f
      },
      {
         9.711807e-001f,  9.951708e-001f,  9.973243e-001f,  9.990106e-001f,  9.949621e-001f,  9.835180e-001f,  9.963091e-001f,
         9.956197e-001f,  9.916488e-001f,  9.938169e-001f,  9.749450e-001f,  9.626598e-001f,  9.845001e-001f,  9.840299e-001f,
         9.924213e-001f,  9.938740e-001f,  9.909120e-001f,  9.620505e-001f,  9.806905e-001f,  9.793468e-001f,  7.880861e-001f,
         6.492330e-001f,  1.954536e-001f,  8.450480e-001f,  7.732015e-001f,  8.556790e-001f,  6.393057e-001f,  8.494191e-001f
      },
      {
        -2.200461e-001f, -2.321851e-001f, -5.652533e-001f, -7.502418e-001f, -9.553330e-001f, -1.485715e+000f, -1.839662e+000f,
        -2.057289e+000f, -2.361726e+000f, -2.574547e+000f, -2.886115e+000f, -3.821880e+000f, -4.573212e+000f, -5.138817e+000f,
        -5.619226e+000f, -6.005217e+000f, -6.443953e+000f, -7.251062e+000f, -7.939557e+000f, -8.758940e+000f, -1.017497e+001f,
        -1.206231e+001f, -1.690733e+001f, -2.020006e+001f, -2.379520e+001f, -2.623502e+001f, -3.042877e+001f, -3.248904e+001f
      },
      VastImpulseLeft2,
      VastImpulseRight2
    },
    {
      {
         5.322862e-002f,  1.887626e-001f,  4.205510e-001f,  6.806711e-001f,  8.494963e-001f,  6.840174e-001f,  5.420896e-001f,
         5.475846e-001f,  6.715982e-001f,  5.176246e-001f,  9.245071e-001f,  1.296057e+000f,  1.478180e+000f,  1.438672e+000f,
         1.147318e+000f,  1.072457e+000f,  1.792099e+000f,  2.091631e+000f,  1.218169e+000f,  5.134976e-001f,  4.810884e-001f,
         4.309226e-001f,  4.066218e-001f,  2.231306e-001f,  3.851604e-001f,  4.772789e-001f,  7.737658e-001f,  4.538520e-001f
      },
      {
         4.949202e-002f,  1.532111e-001f,  3.369080e-001f,  5.539450e-001f,  6.839864e-001f,  5.251327e-001f,  4.383496e-001f,
         4.562477e-001f,  5.517129e-001f,  4.657807e-001f,  8.035913e-001f,  1.093800e+000f,  1.180785e+000f,  1.167679e+000f,
         1.121311e+000f,  1.233006e+000f,  1.870885e+000f,  2.048959e+000f,  1.160753e+000f,  4.458810e-001f,  2.649372e-001f,
         3.588453e-001f,  2.504750e-001f,  1.573156e-001f,  5.512559e-001f,  5.547709e-001f,  8.559195e-001f,  5.356708e-001f
      },
      {
         9.960551e-001f,  9.997367e-001f,  9.999605e-001f,  9.999923e-001f,  9.999038e-001f,  9.994404e-001f,  9.998297e-001f,
         9.999923e-001f,  9.994251e-001f,  9.981906e-001f,  9.999576e-001f,  9.999336e-001f,  9.993776e-001f,  9.987039e-001f,
         9.970349e-001f,  9.958204e-001f,  9.998374e-001f,  9.998279e-001f,  9.982773e-001f,  9.202315e-001f,  9.228057e-001f,
         9.751642e-001f,  9.954413e-001f,  7.819999e-001f,  8.969924e-001f,  7.782448e-001f,  9.326335e-001f,  9.823610e-001f
      },
      {
        -5.721748e-002f,  1.668455e-002f, -2.786662e-002f, -3.720104e-002f, -2.234975e-002f, -7.420415e-002f, -1.390109e-001f,
        -1.332448e-001f, -1.317839e-001f, -1.817751e-001f, -1.390220e-001f, -1.614740e-001f, -2.199623e-001f, -3.648443e-001f,
        -4.682374e-001f, -2.801759e-001f, -1.851930e-001f, -1.738835e-001f, -1.986404e-001f,  3.780154e-001f, -8.793621e-001f,
        -5.827429e-001f,  6.191175e-002f,  1.330091e+000f, -4.186168e-001f, -7.505645e-001f, -1.503538e+000f, -1.491980e+000f
      },
      VastImpulseLeft3,
      VastImpulseRight3
    },
    {
      {
         3.739983e-002f,  2.260397e-001f,  5.567057e-001f,  8.956424e-001f,  1.134876e+000f,  1.094972e+000f,  9.735698e-001f,
         9.966619e-001f,  1.387450e+000f,  1.302802e+000f,  1.180753e+000f,  1.092038e+000f,  1.260266e+000f,  1.614772e+000f,
         2.174144e+000f,  2.237181e+000f,  2.322747e+000f,  2.088162e+000f,  2.290271e+000f,  2.514683e+000f,  2.218720e+000f,
         2.136362e+000f,  1.537878e+000f,  5.397236e-001f,  1.119705e+000f,  4.658503e-001f,  1.352864e+000f,  1.322133e+000f
      },
      {
         2.536129e-002f,  1.304694e-001f,  2.936321e-001f,  4.413240e-001f,  5.279950e-001f,  4.692072e-001f,  3.575798e-001f,
         3.224775e-001f,  3.848260e-001f,  2.864596e-001f,  2.120541e-001f,  1.462096e-001f,  5.963255e-002f,  1.226112e-001f,
         2.915758e-001f,  4.326010e-001f,  6.414963e-001f,  5.936018e-001f,  3.375597e-001f,  1.648287e-001f,  8.175232e-002f,
         6.438659e-002f,  5.132807e-002f,  7.784283e-002f,  7.433308e-002f,  1.978978e-002f,  3.524727e-002f,  2.860306e-002f
      },
      {
         9.736159e-001f,  9.951620e-001f,  9.950604e-001f,  9.954070e-001f,  9.805302e-001f,  9.768832e-001f,  9.822358e-001f,
         9.818691e-001f,  9.338074e-001f,  9.430296e-001f,  9.108129e-001f,  8.660901e-001f,  2.209564e-001f,  9.145834e-001f,
         9.289267e-001f,  9.080214e-001f,  8.943629e-001f,  5.995697e-001f,  7.345429e-001f,  8.092781e-001f,  8.014833e-001f,
         3.233455e-001f,  7.093444e-001f,  6.832928e-001f,  2.525285e-001f,  4.308686e-001f,  1.092535e-001f,  3.254432e-001f
      },
      {
         0.000000e+000f,  6.507841e-001f,  1.020970e+000f,  1.364002e+000f,  1.864567e+000f,  2.604780e+000f,  3.284489e+000f,
         3.926695e+000f,  4.864527e+000f,  6.156921e+000f,  7.476145e+000f,  8.891579e+000f,  1.197575e+001f,  1.508415e+001f,
         1.646483e+001f,  1.767922e+001f,  1.922781e+001f,  2.171168e+001f,  2.476916e+001f,  2.713935e+001f,  2.914112e+001f,
         3.214993e+001f,  3.647485e+001f,  3.771369e+001f,  4.335974e+001f,  4.838014e+001f,  5.947465e+001f,  6.812040e+001f
      },
      VastImpulseLeft4,
      VastImpulseRight4
    },
    {
      {
         2.555731e-002f,  1.607687e-001f,  3.838302e-001f,  5.724831e-001f,  6.566998e-001f,  5.758545e-001f,  4.391215e-001f,
         3.657894e-001f,  4.085111e-001f,  2.723397e-001f,  1.606423e-001f,  8.226427e-002f,  1.489571e-001f,  3.091720e-001f,
         5.245871e-001f,  6.181251e-001f,  7.256905e-001f,  6.033032e-001f,  2.851469e-001f,  8.286049e-002f,  1.488895e-001f,
         1.498344e-001f,  8.637112e-002f,  7.252755e-002f,  7.415747e-002f,  3.962348e-002f,  5.948565e-002f,  2.563193e-002f
      },
      {
         2.568763e-002f,  1.745448e-001f,  4.646578e-001f,  7.563494e-001f,  9.159997e-001f,  8.962867e-001f,  8.292129e-001f,
         8.165322e-001f,  1.116702e+000f,  1.004654e+000f,  8.894474e-001f,  9.249219e-001f,  1.235300e+000f,  1.662267e+000f,
         2.145762e+000f,  2.079040e+000f,  1.751593e+000f,  1.332405e+000f,  1.788936e+000f,  2.089481e+000f,  2.133448e+000f,
         1.978551e+000f,  7.150651e-001f,  8.922705e-001f,  1.442812e+000f,  4.719610e-001f,  1.088194e+000f,  1.248130e+000f
      },
      {
         9.774735e-001f,  9.953323e-001f,  9.951058e-001f,  9.959449e-001f,  9.806913e-001f,  9.764283e-001f,  9.838467e-001f,
         9.834361e-001f,  9.354082e-001f,  9.458411e-001f,  9.393085e-001f,  7.299115e-001f,  9.522787e-001f,  9.430419e-001f,
         9.431834e-001f,  9.380526e-001f,  9.110211e-001f,  5.193833e-001f,  7.192264e-001f,  9.135537e-001f,  8.196625e-001f,
         6.475566e-001f,  6.960566e-001f,  3.714308e-001f,  4.385416e-001f,  3.882391e-001f,  2.053044e-001f,  5.612117e-001f
      },
      {
        -4.836931e-002f, -6.706774e-001f, -1.049129e+000f, -1.375115e+000f, -1.846982e+000f, -2.611335e+000f, -3.245813e+000f,
        -3.871317e+000f, -4.753344e+000f, -5.885781e+000f, -7.101177e+000f, -8.089712e+000f, -7.733286e+000f, -8.769968e+000f,
        -9.965027e+000f, -1.109382e+001f, -1.236928e+001f, -1.493893e+001f, -1.795609e+001f, -1.892418e+001f, -2.059662e+001f,
        -2.328120e+001f, -2.681450e+001f, -3.017271e+001f, -3.368282e+001f, -3.969982e+001f, -4.799358e+001f, -5.185142e+001f
      },
      VastImpulseLeft5,
      VastImpulseRight5
    }
  },
  0,
  NULL,
  NULL
};



static const float MPSVTImpulseLeft1[] =
{
    0.00000000000f,  2.793922e-001f, -1.252581e-003f,  3.601965e-002f,  5.028702e-002f,  1.261413e-002f, -3.037459e-002f, -4.231859e-002f,
   -2.288003e-002f,  4.868296e-004f,  1.319170e-002f,  1.445832e-002f,  9.291181e-003f,  5.415364e-004f, -5.960905e-003f, -6.324124e-003f,
   -4.126417e-003f, -6.238331e-003f, -1.111591e-002f, -1.031941e-002f, -1.906132e-003f,  5.501515e-003f,  4.938129e-003f,  4.596294e-004f,
   -5.182074e-004f,  1.942317e-003f,  2.384007e-003f, -3.576821e-004f, -2.259542e-003f, -1.067077e-003f,  6.992900e-004f,  4.833567e-004f,
   -8.508244e-004f, -9.375998e-004f,  6.677472e-004f,  2.402608e-003f,  2.574608e-003f,  1.112484e-003f, -4.522100e-004f, -6.328301e-004f,
    4.975653e-005f, -1.502742e-004f, -1.494560e-003f, -2.131800e-003f, -1.048848e-003f,  2.087963e-004f, -7.985278e-005f, -1.067953e-003f,
   -8.650151e-004f,  3.845305e-004f,  8.478933e-004f,  1.402693e-005f, -7.111553e-004f, -3.549829e-004f,  3.195392e-004f,  3.309711e-004f,
   -9.334439e-005f, -1.592229e-004f,  2.522437e-004f,  6.398684e-004f,  6.472322e-004f,  3.796188e-004f,  1.634219e-004f,  2.209586e-004f,
    4.078687e-004f,  3.391667e-004f, -6.963835e-005f, -3.696561e-004f, -2.124719e-004f,  7.404760e-005f, -2.665895e-005f, -3.780865e-004f,
   -4.200376e-004f, -9.420644e-005f,  7.499749e-005f, -1.453060e-004f, -3.606560e-004f, -2.338674e-004f,  9.002852e-006f,  2.037830e-005f,
   -1.300214e-004f, -1.498993e-004f,  2.988269e-006f,  1.339538e-004f,  1.379955e-004f,  8.997838e-005f,  8.270270e-005f,  1.315068e-004f,
    1.901690e-004f,  1.885556e-004f,  1.051109e-004f,  2.667570e-005f,  4.681567e-005f,  1.097204e-004f,  7.845677e-005f, -3.833250e-005f,
   -8.678559e-005f, -1.890533e-005f,  2.613740e-005f, -4.487622e-005f, -1.298382e-004f, -1.097006e-004f, -3.882614e-005f, -3.681718e-005f,
   -9.336384e-005f, -1.071053e-004f, -5.649920e-005f, -1.273837e-005f, -1.402651e-005f, -2.478224e-005f, -1.081795e-005f,  1.857482e-005f,
    4.182373e-005f,  4.981550e-005f,  4.285513e-005f,  3.408365e-005f,  4.255946e-005f,  6.199373e-005f,  6.048032e-005f,  3.177402e-005f,
    1.298181e-005f,  2.586098e-005f,  3.797238e-005f,  1.631365e-005f, -1.633025e-005f, -2.003629e-005f, -3.801365e-006f, -6.401692e-006f,
   -3.050445e-005f, -4.284399e-005f, -3.165520e-005f, -2.056782e-005f, -2.520074e-005f, -3.221059e-005f, -2.729476e-005f, -1.587224e-005f,
   -8.369267e-006f, -5.150254e-006f, -2.470205e-006f,  1.007722e-006f,  6.806863e-006f,  1.477935e-005f,  1.908912e-005f,  1.616347e-005f,
    1.317305e-005f,  1.758335e-005f,  2.319740e-005f,  1.949900e-005f,  1.009814e-005f,  7.251667e-006f,  1.113047e-005f,  1.012342e-005f,
    1.117373e-006f, -5.832349e-006f, -5.022863e-006f, -3.391781e-006f, -7.271881e-006f, -1.250399e-005f, -1.308707e-005f, -1.065089e-005f,
   -9.759183e-006f, -1.036575e-005f, -9.886572e-006f, -8.037512e-006f, -5.817409e-006f, -3.291495e-006f, -9.036132e-007f,  2.588863e-007f,
    9.661165e-007f,  3.213160e-006f,  6.262169e-006f,  7.146063e-006f,  5.823574e-006f,  5.600788e-006f,  7.409988e-006f,  8.090180e-006f,
    5.916092e-006f,  3.562649e-006f,  3.413076e-006f,  3.725474e-006f,  2.072508e-006f, -5.272387e-007f, -1.726392e-006f, -1.729899e-006f,
   -2.314030e-006f, -3.622733e-006f, -4.407403e-006f, -4.358362e-006f, -4.162509e-006f, -4.012913e-006f, -3.641903e-006f, -3.175473e-006f,
   -2.755776e-006f, -2.013800e-006f, -8.626330e-007f,  7.775887e-009f,  2.701036e-007f,  6.568929e-007f,  1.659984e-006f,  2.527064e-006f,
    2.515306e-006f,  2.193748e-006f,  2.422356e-006f,  2.857824e-006f,  2.630211e-006f,  1.872781e-006f,  1.408111e-006f,  1.333102e-006f,
    1.024230e-006f,  3.194878e-007f, -2.940693e-007f, -5.826902e-007f, -8.236551e-007f, -1.172708e-006f, -1.449127e-006f, -1.564265e-006f,
   -1.625835e-006f, -1.625112e-006f, -1.463945e-006f, -1.239068e-006f, -1.105371e-006f, -9.518178e-007f, -5.938606e-007f, -1.669792e-007f,
    6.345500e-008f,  1.660145e-007f,  4.103251e-007f,  7.643191e-007f,  9.405721e-007f,  8.970924e-007f,  8.846351e-007f,  9.906968e-007f,
    1.015256e-006f,  8.509788e-007f,  6.523391e-007f,  5.429523e-007f,  4.356750e-007f,  2.413371e-007f,  2.716949e-008f, -1.289705e-007f,
   -2.583357e-007f, -3.938605e-007f, -4.955299e-007f, -5.462107e-007f, -5.892201e-007f, -6.253256e-007f, -5.971776e-007f, -5.088825e-007f,
   -4.368486e-007f, -3.932744e-007f, -3.040428e-007f, -1.532759e-007f, -2.475539e-008f,  4.005140e-008f,  1.056845e-007f,  1.722815e-006f,
    2.628034e-005f,  3.750763e-006f, -1.453303e-005f,  5.442106e-005f,  6.253796e-005f, -7.987510e-005f, -9.692217e-005f,  1.476258e-004f,
    2.777258e-004f,  6.620672e-005f, -1.370016e-004f, -9.431208e-005f, -4.569152e-005f, -5.270785e-005f,  1.700091e-004f,  5.776738e-004f,
    7.501649e-004f,  4.800666e-004f, -1.537648e-004f, -8.267336e-004f, -8.632140e-004f, -1.391920e-004f,  1.628746e-004f, -5.396584e-004f,
   -5.346748e-004f,  1.159459e-003f,  1.810004e-003f, -7.411402e-004f, -3.072873e-003f, -1.194964e-003f,  2.070202e-003f,  1.719193e-003f,
   -5.606904e-004f, -3.582780e-004f,  4.880270e-004f, -1.660477e-003f, -3.545132e-003f, -1.401240e-003f, -8.615431e-005f, -3.823255e-003f,
   -5.590825e-003f, -1.361135e-004f,  1.707411e-003f, -1.014033e-002f, -2.201707e-002f, -1.411830e-002f,  7.957947e-003f,  2.001159e-002f,
    1.218345e-002f, -2.834786e-003f, -1.060960e-002f, -8.869376e-003f, -3.656472e-003f, -2.468100e-003f, -7.650889e-003f, -1.136046e-002f,
   -4.807384e-003f,  5.862439e-003f,  6.527046e-003f, -1.140975e-003f, -1.826684e-003f,  5.355417e-003f,  4.389777e-003f, -6.948319e-003f,
   -1.005191e-002f,  1.939180e-003f,  1.082003e-002f,  4.423652e-003f, -4.205383e-003f, -2.426377e-003f,  1.110775e-003f, -3.504659e-003f,
   -8.166944e-003f, -3.665467e-003f,  2.622450e-003f,  1.323983e-003f, -2.454316e-003f, -8.631596e-004f,  2.500476e-003f,  1.899940e-003f,
    2.645118e-004f,  8.995171e-004f,  2.511058e-004f, -3.136400e-003f, -3.936268e-003f, -6.400025e-004f,  6.140936e-004f, -2.110570e-003f,
   -2.651281e-003f,  7.816614e-004f,  1.368297e-003f, -3.227006e-003f, -5.336321e-003f, -4.043948e-004f,  5.005619e-003f,  4.181438e-003f,
    1.279234e-004f, -1.277878e-003f, -3.571166e-004f, -3.590820e-004f, -1.150687e-003f, -1.037369e-003f, -4.362971e-004f, -1.356291e-004f,
    5.358097e-004f,  1.569770e-003f,  1.742683e-003f,  1.409212e-003f,  2.124898e-003f,  2.960724e-003f,  1.504473e-003f, -1.112934e-003f,
   -1.151834e-003f,  1.224279e-003f,  1.891055e-003f,  1.803812e-004f,  2.617468e-004f,  3.393475e-003f,  5.196700e-003f,  3.250654e-003f,
    1.059133e-003f,  1.300298e-003f,  1.502146e-003f,  4.210085e-005f, -9.587351e-005f,  2.281662e-003f,  3.006790e-003f, -5.383346e-006f,
   -2.255558e-003f, -4.422374e-004f,  1.846719e-003f,  1.249685e-003f,  6.836158e-004f,  2.919135e-003f,  4.701804e-003f,  2.773212e-003f,
   -3.475383e-004f, -1.489327e-003f, -1.785583e-003f, -2.562384e-003f, -2.433123e-003f, -1.406570e-003f, -1.403383e-003f, -1.275026e-003f,
    1.191428e-003f,  2.509681e-003f, -1.800985e-003f, -6.865366e-003f, -4.568422e-003f,  1.248970e-003f, -1.795518e-004f, -6.972921e-003f,
   -6.392991e-003f,  2.726642e-003f,  6.907931e-003f,  7.877658e-004f, -4.230795e-003f,  7.390894e-004f,  9.696906e-003f,  1.402416e-002f,
    1.289962e-002f,  6.982653e-003f, -4.056980e-003f, -1.329123e-002f, -1.005956e-002f,  3.257243e-003f,  1.116702e-002f,  6.430687e-003f,
   -1.129431e-003f, -1.513430e-003f,  2.469613e-003f,  4.321700e-003f,  4.273460e-003f,  4.421441e-003f,  2.919827e-003f, -9.752645e-004f,
   -3.201560e-003f, -1.052998e-003f,  2.404792e-003f,  3.347768e-003f,  2.026287e-003f,  4.709173e-004f, -6.306674e-004f, -1.286373e-003f,
   -1.460042e-003f, -1.634921e-003f, -2.081422e-003f, -2.043059e-003f, -1.200264e-003f, -6.239527e-004f, -1.033040e-003f, -1.838095e-003f,
   -2.557460e-003f, -2.995233e-003f, -2.095215e-003f,  4.869332e-004f,  2.190443e-003f,  4.548943e-004f, -2.878676e-003f, -3.904602e-003f,
   -2.399333e-003f, -1.091439e-003f, -4.809330e-004f,  9.451962e-004f,  2.417977e-003f,  1.671040e-003f, -6.017417e-004f, -1.506329e-003f,
   -6.857881e-004f, -3.995567e-004f, -1.393108e-003f, -2.124858e-003f, -1.660405e-003f, -5.978675e-004f,  3.361639e-004f,  6.539520e-004f,
    9.424571e-006f, -8.760667e-004f, -5.529789e-004f,  8.649377e-004f,  1.472993e-003f,  4.876100e-004f, -5.654121e-004f, -3.906643e-004f,
    3.339858e-004f,  6.055291e-004f,  6.451077e-004f,  8.740139e-004f,  8.502851e-004f,  1.730904e-004f, -6.353913e-004f, -1.002005e-003f,
   -1.224029e-003f, -1.601591e-003f, -1.417341e-003f, -3.149709e-004f, -2.221104e-004f, -3.197530e-003f, -6.810439e-003f, -5.563462e-003f,
    7.724261e-004f,  4.832592e-003f,  1.902310e-003f, -2.421186e-003f, -1.032965e-003f,  3.177843e-003f,  3.015040e-003f, -2.180887e-004f,
    1.437212e-004f,  3.362073e-003f,  2.937596e-003f, -9.143139e-004f, -1.794881e-003f,  1.132570e-003f,  2.906225e-003f,  2.827237e-003f,
    3.871224e-003f,  3.999759e-003f, -6.254104e-004f, -5.754419e-003f, -3.928400e-003f,  2.518769e-003f,  4.594909e-003f,  1.070065e-003f,
   -1.096469e-003f,  7.799434e-004f,  2.399613e-003f,  1.230517e-003f, -5.627929e-004f, -1.015059e-003f, -7.459748e-005f,  1.620247e-003f,
    1.908066e-003f, -1.021415e-003f, -3.839612e-003f, -1.564892e-003f,  2.902361e-003f,  1.690422e-003f, -4.161796e-003f, -4.876060e-003f,
    1.457192e-003f,  4.869589e-003f,  3.456323e-004f, -3.913601e-003f, -1.110269e-003f,  2.792356e-003f, -1.927191e-005f, -6.102641e-003f,
   -6.817827e-003f, -1.452285e-003f,  3.101458e-003f,  2.496689e-003f, -9.343614e-004f, -2.923604e-003f, -2.260718e-003f, -6.743217e-004f,
    3.668668e-004f,  1.219200e-003f,  2.340999e-003f,  2.880179e-003f,  2.441237e-003f,  2.312229e-003f,  2.833731e-003f,  1.844614e-003f,
   -1.642669e-003f, -4.758093e-003f, -4.607399e-003f, -2.184882e-003f,  8.632141e-005f,  1.773780e-003f,  3.151571e-003f,  3.607437e-003f,
    3.030641e-003f,  1.841329e-003f, -5.890664e-004f, -3.976672e-003f, -4.869245e-003f, -1.311682e-003f,  2.159129e-003f,  2.752983e-004f,
   -4.340159e-003f, -5.062607e-003f, -1.448548e-003f,  1.747182e-003f,  3.405748e-003f,  6.130236e-003f,  9.138829e-003f,  8.586825e-003f,
    4.380846e-003f,  5.501579e-004f, -9.527532e-004f, -2.233824e-003f, -5.187063e-003f, -8.084674e-003f, -7.154367e-003f, -1.742289e-003f,
    2.449565e-003f, -1.115254e-003f, -9.570451e-003f, -1.194975e-002f, -4.286555e-003f,  4.270406e-003f,  5.834052e-003f,  4.979847e-003f,
    7.835352e-003f,  1.008701e-002f,  6.232954e-003f,  1.375181e-003f,  1.981310e-003f,  3.392262e-003f, -1.022200e-003f, -6.092213e-003f,
   -3.311796e-003f,  3.622883e-003f,  4.957406e-003f,  1.222903e-003f,  5.443624e-004f,  3.583073e-003f,  3.595508e-003f, -6.042470e-004f,
   -2.949354e-003f, -1.014081e-003f,  6.146858e-004f, -1.370912e-003f, -4.389647e-003f, -5.027154e-003f, -3.768975e-003f, -3.201191e-003f,
   -4.498614e-003f, -6.700104e-003f, -7.704200e-003f, -5.703821e-003f, -1.092077e-003f,  2.994671e-003f,  3.486545e-003f,  9.946157e-004f,
   -7.684357e-004f,  4.380990e-004f,  3.118568e-003f,  5.181198e-003f,  7.012566e-003f,  9.362779e-003f,  1.036463e-002f,  7.846474e-003f,
    3.252328e-003f, -9.342335e-005f, -1.684166e-003f, -3.506518e-003f, -5.802327e-003f, -6.456666e-003f, -4.410929e-003f, -1.199101e-003f,
    8.158583e-004f,  4.679736e-004f, -1.221829e-003f, -1.773867e-003f, -4.597697e-004f, -8.885808e-005f, -2.933503e-003f, -6.230270e-003f,
   -5.701157e-003f, -2.066218e-003f,  7.696765e-004f,  2.290232e-003f,  4.428573e-003f,  5.850898e-003f,  3.763923e-003f,  1.605962e-004f,
   -4.796661e-004f,  1.237781e-003f,  9.800156e-004f, -1.303370e-003f, -1.482512e-003f,  1.037644e-003f,  2.249791e-003f,  6.232092e-004f,
   -4.841079e-004f,  1.349184e-003f,  3.893628e-003f,  4.063419e-003f,  2.365664e-003f,  1.624503e-003f,  2.807275e-003f,  4.071360e-003f,
    3.807154e-003f,  2.753724e-003f,  2.036051e-003f,  9.197143e-004f, -1.330410e-003f, -3.052793e-003f, -2.568549e-003f, -1.248574e-003f,
   -9.001009e-004f, -3.619147e-004f,  1.408809e-003f,  1.926539e-003f, -3.018249e-004f, -1.456488e-003f,  1.571276e-003f,  4.725865e-003f,
    3.079625e-003f, -3.445151e-004f,  4.186324e-004f,  3.992036e-003f,  4.477613e-003f,  1.855397e-003f,  1.385368e-003f,  4.042832e-003f,
    5.021944e-003f,  1.790540e-003f, -2.149996e-003f, -2.511297e-003f,  3.210196e-004f,  2.309319e-003f,  9.395793e-004f, -1.795526e-003f,
   -2.451807e-003f, -1.281725e-003f, -1.290106e-003f, -2.340987e-003f, -1.123507e-003f,  2.104772e-003f,  2.783290e-003f, -1.032884e-004f,
   -1.931435e-003f, -4.498913e-004f,  8.404623e-004f, -3.446567e-004f, -1.523032e-003f, -1.058890e-003f, -7.135687e-004f, -9.129324e-004f,
    1.394555e-004f,  1.704234e-003f,  1.100578e-003f, -8.059930e-004f, -7.548407e-004f,  8.620287e-004f,  8.757123e-004f, -8.760956e-004f,
   -1.851057e-003f, -1.256902e-003f,  6.063660e-005f,  1.824471e-003f,  3.157263e-003f,  2.418000e-003f,  5.427498e-004f,  5.273236e-004f,
    2.158048e-003f,  2.147374e-003f,  2.577665e-004f, -3.413607e-004f,  8.118600e-004f,  9.708919e-004f, -1.175679e-004f,  8.613987e-005f,
    1.689343e-003f,  2.312963e-003f,  1.679900e-003f,  1.360634e-003f,  1.002689e-003f, -7.480187e-004f, -2.767914e-003f, -2.693420e-003f,
   -6.769918e-004f,  7.079599e-004f, -4.389515e-004f, -3.438014e-003f, -5.421172e-003f, -4.019571e-003f, -5.283809e-004f,  1.366263e-003f,
    8.014874e-004f,  4.599668e-004f,  1.302670e-003f,  1.216413e-003f, -2.101237e-005f,  7.126507e-005f,  1.367857e-003f,  9.166807e-004f,
   -1.116313e-003f, -1.372238e-003f,  5.779605e-004f,  2.104881e-003f,  2.752243e-003f,  3.487476e-003f,  2.717854e-003f, -5.780194e-004f,
   -2.758006e-003f, -1.017087e-003f,  1.019088e-003f, -3.985517e-004f, -2.307362e-003f, -1.039213e-003f,  7.289579e-004f, -3.865011e-004f,
   -1.744153e-003f, -3.383013e-005f,  2.438609e-003f,  2.592294e-003f,  2.099827e-003f,  3.192523e-003f,  4.218966e-003f,  3.279627e-003f,
    1.579081e-003f,  5.515189e-004f, -1.880128e-004f, -7.917816e-004f, -7.473741e-004f, -5.216852e-004f, -6.930605e-004f, -6.018667e-004f,
    4.478723e-005f,  5.106297e-004f,  1.073791e-003f,  2.384625e-003f,  2.812667e-003f,  8.774654e-004f, -7.836321e-004f,  6.779275e-004f,
    2.568461e-003f,  1.111074e-003f, -1.335031e-003f, -4.967229e-004f,  1.975130e-003f,  2.086163e-003f,  7.279472e-004f,  3.480078e-004f,
   -6.426444e-004f, -3.438184e-003f, -4.440759e-003f, -1.516101e-003f,  1.437463e-003f,  1.452894e-003f,  1.203794e-003f,  2.383313e-003f,
    2.049749e-003f, -5.627408e-004f, -1.539656e-003f,  3.045389e-004f,  1.382545e-003f,  4.687661e-004f, -2.631254e-004f, -1.656936e-003f,
   -5.928451e-003f, -8.952574e-003f, -4.400968e-003f,  4.211202e-003f,  6.044872e-003f, -1.220837e-003f, -7.696412e-003f, -5.736047e-003f,
    1.387871e-004f,  1.219570e-003f, -3.383791e-003f, -6.964448e-003f, -4.801014e-003f,  2.888721e-004f,  2.414260e-003f,  2.541231e-004f,
   -2.381928e-003f, -2.916643e-003f, -2.925577e-003f, -3.752083e-003f, -3.704087e-003f, -1.870946e-003f, -5.671534e-004f, -1.336201e-003f,
   -2.253529e-003f, -1.596213e-003f, -6.629974e-004f, -9.118769e-004f, -1.586547e-003f, -1.735131e-003f, -1.575647e-003f, -9.270046e-004f,
    8.393774e-004f,  2.766640e-003f,  2.887958e-003f,  1.194778e-003f, -1.015324e-004f,  4.830536e-004f,  1.967640e-003f,  2.352425e-003f,
    1.110104e-003f, -2.122956e-004f, -2.494202e-004f,  1.565112e-005f, -9.894440e-004f, -2.277842e-003f, -1.869749e-003f, -7.844419e-004f,
   -1.481501e-003f, -3.045653e-003f, -2.688486e-003f, -1.164583e-003f, -1.368866e-003f, -2.688362e-003f, -2.311813e-003f, -5.845431e-004f,
    2.988072e-004f,  5.098126e-004f,  6.310415e-004f, -6.873904e-004f, -2.705340e-003f, -1.760557e-003f,  1.496446e-003f,  1.504488e-003f,
   -1.750677e-003f, -1.319318e-003f,  3.580078e-003f,  4.605785e-003f, -6.388525e-004f, -3.327671e-003f,  1.122277e-003f,  5.352157e-003f,
    3.737918e-003f,  7.710251e-004f,  1.088341e-004f, -1.753708e-003f, -5.367606e-003f, -4.593315e-003f,  1.501448e-003f,  4.687552e-003f,
    7.222536e-004f, -3.843105e-003f, -2.660771e-003f,  1.368421e-003f,  2.379934e-003f,  3.007213e-004f, -6.618767e-004f,  1.161805e-003f,
    2.492061e-003f, -3.419608e-004f, -5.138719e-003f, -5.460716e-003f, -6.907816e-004f,  1.265667e-003f, -3.551165e-003f, -7.365505e-003f,
   -3.365028e-003f,  2.019565e-003f,  1.444197e-004f, -4.665211e-003f, -3.453830e-003f,  1.161406e-003f,  5.632946e-004f, -4.105859e-003f,
   -5.046585e-003f, -2.061800e-003f, -1.521828e-003f, -4.351906e-003f, -5.401200e-003f, -2.739523e-003f,  1.756587e-004f,  3.466081e-004f,
   -1.469793e-003f, -2.328832e-003f, -4.013404e-004f,  2.134403e-003f,  9.839304e-004f, -3.647159e-003f, -6.202475e-003f, -4.087551e-003f,
   -1.265603e-003f, -6.703172e-004f,  1.947405e-005f,  1.922239e-003f,  2.010430e-003f, -3.484192e-004f, -1.581299e-003f, -5.455327e-004f,
    6.058183e-004f,  2.101232e-003f,  4.941597e-003f,  5.633853e-003f,  1.561946e-003f, -1.866314e-003f,  8.969198e-004f,  5.237523e-003f,
    3.976833e-003f, -4.811784e-004f, -1.660003e-003f, -1.213432e-004f,  6.230220e-004f,  2.028794e-003f,  5.246085e-003f,  5.720005e-003f,
    1.289719e-003f, -2.342654e-003f, -1.050406e-003f,  1.303296e-003f,  1.249854e-003f,  1.407656e-003f,  3.353840e-003f,  3.823461e-003f,
    1.499910e-003f, -5.417421e-004f, -9.226590e-004f, -1.148431e-003f, -1.035719e-003f,  1.904338e-004f,  4.346620e-004f, -1.279089e-003f,
   -1.396119e-003f,  1.617225e-003f,  3.024756e-003f,  3.572243e-006f, -2.762943e-003f, -1.445911e-003f,  4.239419e-004f, -6.397372e-004f,
   -1.745657e-003f,  1.068626e-004f,  2.485137e-003f,  2.493915e-003f,  8.801949e-004f, -1.512263e-003f, -5.010480e-003f, -7.339098e-003f,
   -5.098184e-003f, -3.984237e-005f,  2.181966e-003f,  8.784645e-005f, -2.215997e-003f, -1.885623e-003f, -7.597355e-004f, -1.448511e-003f,
   -3.539430e-003f, -4.536561e-003f, -3.088973e-003f, -8.007361e-004f, -3.698902e-004f, -1.577219e-003f, -1.069635e-003f,  2.492173e-003f,
    5.836055e-003f,  5.799626e-003f,  3.610419e-003f,  1.938625e-003f,  8.617084e-004f, -4.840277e-004f, -1.190555e-003f, -2.927201e-004f,
    1.050951e-003f,  1.279307e-003f,  7.445720e-004f,  9.410328e-004f,  2.411268e-003f,  3.996517e-003f,  3.963284e-003f,  2.239062e-003f,
    9.047978e-004f,  1.077243e-003f,  7.995644e-004f, -1.394277e-003f, -3.014019e-003f, -1.514893e-003f,  8.033370e-004f,  4.481523e-004f,
   -1.259608e-003f, -8.759043e-004f,  1.049661e-003f,  1.587153e-003f,  6.025608e-004f, -1.825369e-004f, -5.935653e-004f, -8.598546e-004f,
   -2.040172e-004f,  8.434353e-004f,  4.019842e-004f, -1.008370e-003f, -1.000375e-003f,  2.857199e-005f, -1.663140e-004f, -6.841599e-004f,
    7.826774e-004f,  2.443210e-003f,  9.379261e-004f, -2.110129e-003f, -2.320991e-003f,  2.965958e-004f,  2.037914e-003f,  1.421005e-003f,
   -2.135210e-004f, -1.717641e-003f, -2.362004e-003f, -1.700323e-003f, -9.665532e-004f, -1.453383e-003f, -1.665223e-003f, -1.122706e-004f,
    1.020369e-003f, -2.086559e-005f, -3.448842e-004f,  1.871799e-003f,  2.576168e-003f, -5.221330e-004f, -1.875080e-003f,  2.662536e-003f,
    7.479667e-003f,  6.168303e-003f,  1.632932e-003f, -4.721875e-004f, -7.503459e-004f, -1.358861e-003f, -4.486306e-004f,  2.151154e-003f,
    2.032122e-003f, -1.449351e-003f, -2.530979e-003f,  7.768231e-004f,  2.880265e-003f,  7.444603e-004f, -1.206937e-003f,  2.784548e-004f,
    2.080753e-003f,  1.003940e-003f, -1.556452e-003f, -2.945523e-003f, -2.179174e-003f,  3.042598e-004f,  2.208015e-003f,  9.447816e-004f,
   -1.849231e-003f, -1.721569e-003f,  9.394458e-004f,  1.061292e-003f, -1.765014e-003f, -2.102526e-003f,  1.290263e-003f,  2.898326e-003f,
    1.552389e-004f, -2.679966e-003f, -2.446247e-003f, -1.207605e-003f, -8.986501e-004f, -6.043933e-004f, -1.201675e-005f,  3.666314e-006f,
   -2.695749e-005f,  5.981070e-004f,  5.885599e-004f, -6.781761e-004f, -1.225669e-003f, -1.801309e-004f,  3.905191e-004f, -3.261593e-004f,
   -3.790223e-004f,  4.407316e-004f, -3.897690e-004f, -3.053164e-003f, -4.288849e-003f, -2.634261e-003f, -4.657706e-004f, -1.681466e-004f,
   -1.677419e-003f, -3.533359e-003f, -3.878452e-003f, -1.821360e-003f,  5.761864e-004f,  3.278955e-004f, -1.568367e-003f, -1.248973e-003f,
    1.339830e-003f,  1.948601e-003f, -8.441209e-004f, -3.284633e-003f, -2.477135e-003f, -1.178666e-004f,  9.028862e-004f,  8.095041e-005f,
   -1.020923e-003f, -5.628037e-004f,  1.397744e-003f,  1.909171e-003f, -1.058201e-003f, -4.100483e-003f, -2.440399e-003f,  2.009015e-003f,
    3.129390e-003f,  7.204461e-004f,  2.416977e-004f,  2.512893e-003f,  2.634043e-003f, -1.631977e-004f, -9.128031e-004f,  1.490878e-003f,
    2.156453e-003f, -5.642223e-004f, -2.177148e-003f, -4.047206e-004f,  1.268913e-003f,  5.513386e-004f,  5.228375e-006f,  1.481931e-003f,
    2.682943e-003f,  1.720697e-003f,  6.001368e-004f,  1.663157e-003f,  3.698534e-003f,  4.007616e-003f,  2.543699e-003f,  1.672048e-003f,
    2.325564e-003f,  2.707904e-003f,  1.675852e-003f,  1.177818e-003f,  3.000677e-003f,  4.903792e-003f,  3.528399e-003f,  3.723002e-005f,
   -1.309903e-003f,  3.674769e-004f,  1.908377e-003f,  1.655763e-003f,  1.249646e-003f,  1.866692e-003f,  2.657589e-003f,  2.909762e-003f,
    2.565429e-003f,  1.309806e-003f, -1.974198e-004f,  7.697682e-005f,  2.146227e-003f,  2.829758e-003f,  6.848291e-004f, -1.122512e-003f,
    1.130196e-004f,  2.197145e-003f,  2.011174e-003f,  5.536908e-004f,  3.950843e-004f,  9.337153e-004f, -4.445752e-005f, -1.870268e-003f,
   -1.551404e-003f,  1.600199e-003f,  4.466909e-003f,  3.978954e-003f,  1.087378e-003f, -7.271165e-004f, -5.628452e-004f, -9.809255e-004f,
   -2.802036e-003f, -2.852656e-003f,  2.905493e-004f,  2.570419e-003f,  8.602415e-004f, -1.195501e-003f,  6.843706e-004f,  3.726043e-003f,
    3.061008e-003f,  2.960420e-004f,  2.903505e-005f,  1.616897e-003f,  1.664666e-003f,  1.007448e-003f,  2.021737e-003f,  2.706425e-003f,
    4.224182e-004f, -2.245712e-003f, -1.881070e-003f, -4.162778e-004f, -8.717818e-004f, -1.437233e-003f,  3.150872e-004f,  1.995373e-003f,
    8.302864e-004f, -1.012936e-003f, -6.039026e-004f,  7.045686e-004f,  7.058214e-004f,  3.305314e-004f,  6.991231e-004f,  6.943425e-004f,
    1.044214e-004f,  5.774971e-004f,  1.750575e-003f,  1.286217e-003f, -4.065232e-004f, -6.638713e-004f,  1.925730e-004f, -3.599747e-004f,
   -1.682999e-003f, -1.301503e-003f, -3.287825e-004f, -1.288719e-003f, -2.311113e-003f, -2.217429e-004f,  2.707182e-003f,  2.164572e-003f,
   -4.338320e-004f, -8.520073e-004f,  7.651520e-005f, -9.037983e-004f, -2.023169e-003f,  1.066874e-004f,  2.654638e-003f,  7.953722e-004f,
   -2.915088e-003f, -2.265262e-003f,  1.771135e-003f,  2.867822e-003f,  3.168329e-004f, -6.912475e-004f,  1.191932e-003f,  1.928819e-003f,
    2.328246e-004f, -4.475930e-004f,  1.121716e-003f,  1.608785e-003f, -7.178193e-004f, -2.664464e-003f, -1.223764e-003f,  1.528973e-003f,
    1.543792e-003f, -8.275578e-004f, -1.055442e-003f,  2.273505e-003f,  4.244588e-003f,  1.072778e-003f, -2.958476e-003f, -1.988835e-003f,
    1.400299e-003f,  1.135235e-003f, -5.213672e-004f,  2.674532e-003f,  7.260250e-003f,  4.611903e-003f, -2.367450e-003f, -3.157676e-003f,
    6.939544e-004f, -1.803637e-003f, -8.918460e-003f, -7.536159e-003f,  1.972495e-003f,  4.735946e-003f, -1.965863e-003f, -4.436224e-003f,
    1.291476e-003f,  3.154465e-003f, -2.373720e-003f, -3.663186e-003f,  2.662777e-003f,  5.333525e-003f,  9.098937e-004f, -2.367782e-004f,
    4.526894e-003f,  4.693819e-003f, -2.548469e-003f, -6.766853e-003f, -3.406510e-003f,  2.415411e-004f,  2.354379e-004f,  1.584875e-004f,
    2.387865e-004f, -2.216240e-003f, -3.895722e-003f, -8.938119e-004f,  2.025993e-003f,  2.128300e-004f, -8.058657e-004f,  3.838751e-003f,
    7.800095e-003f,  5.651434e-003f,  3.523845e-003f,  6.172805e-003f,  6.833620e-003f,  1.087064e-003f, -3.329919e-003f, -1.043250e-003f,
    1.174262e-003f, -1.415721e-003f, -2.506560e-003f,  1.437402e-003f,  3.336849e-003f, -5.308406e-004f, -3.034682e-003f,  2.958511e-004f,
    3.556751e-003f,  2.034369e-003f, -6.545711e-004f, -1.285824e-003f, -1.905963e-003f, -3.116987e-003f, -2.205783e-003f,  4.945685e-004f,
    1.573447e-003f,  7.749571e-004f,  4.188163e-004f,  3.682197e-004f, -5.137417e-004f, -8.821197e-004f,  1.286384e-004f,  3.710373e-004f,
   -9.318713e-004f, -1.037952e-003f,  9.436507e-004f,  1.931018e-003f,  6.722286e-004f,  3.246275e-005f,  1.399751e-003f,  2.316248e-003f,
    1.361305e-003f,  3.566038e-004f,  4.722105e-004f,  4.784656e-004f, -3.072746e-004f, -7.525749e-004f,  1.222959e-005f,  1.461847e-003f,
    2.367860e-003f,  1.584097e-003f, -7.421863e-004f, -2.498454e-003f, -1.914903e-003f, -2.013271e-004f,  2.558262e-004f, -5.510199e-004f,
   -8.502300e-004f, -2.326094e-005f,  1.312655e-003f,  2.647445e-003f,  3.171416e-003f,  1.948017e-003f, -1.363671e-004f, -8.982568e-004f,
   -1.662315e-004f,  1.188277e-004f, -5.618910e-004f, -7.102558e-004f,  1.887768e-004f,  1.049389e-003f,  1.259089e-003f,  8.003865e-004f,
   -6.540833e-004f, -2.490894e-003f, -2.804894e-003f, -1.337152e-003f, -3.450112e-004f, -8.680499e-004f, -1.146166e-003f, -4.479299e-005f,
    1.425675e-003f,  2.731965e-003f,  4.014312e-003f,  3.646538e-003f,  2.019921e-004f, -3.563490e-003f, -3.729566e-003f, -1.365019e-003f,
   -4.162468e-004f, -9.626957e-004f, -3.211201e-004f,  9.698257e-004f,  3.945439e-004f, -1.140217e-003f, -1.080115e-003f, -3.219403e-004f,
   -9.466321e-004f, -1.470563e-003f,  1.463436e-004f,  1.780854e-003f,  8.252900e-004f, -7.995632e-004f, -5.197208e-004f, -1.068896e-004f,
   -1.530650e-003f, -2.114919e-003f,  5.621819e-004f,  3.262766e-003f,  2.375132e-003f,  3.298893e-004f,  8.133671e-004f,  1.849862e-003f,
   -1.598838e-005f, -2.556641e-003f, -1.535211e-003f,  1.657161e-003f,  2.497609e-003f,  7.827358e-004f, -4.272700e-004f, -7.005238e-004f,
   -1.304254e-003f, -1.060156e-003f,  1.205837e-003f,  2.827653e-003f,  1.430739e-003f, -2.443333e-004f,  7.300209e-004f,  1.492926e-003f,
   -1.281357e-003f, -4.071685e-003f, -1.911251e-003f,  2.398934e-003f,  2.475139e-003f, -1.037838e-003f, -2.225989e-003f, -1.585963e-004f,
    7.977439e-004f, -4.188876e-004f, -4.678420e-004f,  1.401941e-003f,  2.174362e-003f,  8.594154e-004f, -2.268037e-004f,  3.893856e-005f,
    3.185417e-004f, -2.487911e-004f, -1.264522e-003f, -2.425570e-003f, -3.107751e-003f, -2.048291e-003f,  4.638195e-004f,  1.940491e-003f,
    1.019746e-003f, -5.840826e-004f, -9.605367e-004f, -7.390737e-004f, -1.417057e-003f, -2.633308e-003f, -2.667682e-003f, -9.738868e-004f,
    8.717510e-004f,  1.049878e-003f, -5.478535e-005f, -4.389333e-004f,  2.298067e-004f,  5.973908e-005f, -1.254233e-003f, -1.162642e-003f,
    1.095686e-003f,  2.263043e-003f,  4.802181e-004f, -1.044835e-003f,  5.436179e-004f,  2.713408e-003f,  1.977405e-003f, -5.077881e-004f,
   -1.717790e-003f, -1.492984e-003f, -1.129816e-003f, -7.778198e-004f, -7.155175e-004f, -1.658999e-003f, -2.467791e-003f, -1.345547e-003f,
    5.456721e-004f,  8.143967e-004f,  1.031158e-004f,  1.321576e-004f, -1.981790e-004f, -1.778731e-003f, -1.747932e-003f,  1.528270e-003f,
    3.969134e-003f,  1.955068e-003f, -1.483966e-003f, -2.065999e-003f, -8.314806e-004f, -3.687431e-004f, -1.266421e-005f,  7.839385e-004f,
    1.548079e-004f, -1.605420e-003f, -1.401010e-003f,  4.242133e-004f,  7.679541e-005f, -2.165933e-003f, -1.934577e-003f,  1.154045e-003f,
    3.125746e-003f,  3.133527e-003f,  3.572716e-003f,  3.808408e-003f,  1.484462e-003f, -1.638711e-003f, -2.321517e-003f, -1.656563e-003f,
   -1.752858e-003f, -6.409425e-004f,  3.051249e-003f,  5.217025e-003f,  2.630938e-003f, -8.344763e-004f, -5.222175e-004f,  1.597518e-003f,
    1.535456e-003f,  2.096630e-004f,  3.261146e-004f,  8.292477e-004f, -5.600497e-004f, -2.687412e-003f, -2.863266e-003f, -1.074806e-003f,
    4.737547e-004f,  5.062966e-004f, -3.762428e-004f, -1.157430e-003f, -1.739462e-003f, -2.393911e-003f, -2.327745e-003f, -6.094265e-004f,
    1.193631e-003f,  4.542291e-004f, -1.544734e-003f, -5.819915e-004f,  3.131814e-003f,  4.372047e-003f,  1.632162e-003f, -4.220846e-004f,
    5.785065e-004f,  1.513642e-003f,  1.177779e-003f,  2.352130e-003f,  4.578075e-003f,  3.914167e-003f,  1.207338e-003f,  1.179989e-003f,
    3.073114e-003f,  2.243344e-003f,  6.456953e-005f,  1.347296e-003f,  3.839288e-003f,  1.853711e-003f, -2.279420e-003f, -2.165084e-003f,
    6.867604e-004f,  6.081888e-004f, -7.557604e-004f,  1.500855e-003f,  4.666850e-003f,  2.996989e-003f, -1.481171e-003f, -2.989857e-003f,
   -1.925948e-003f, -2.010708e-003f, -2.856423e-003f, -2.573977e-003f, -2.157080e-003f, -1.969651e-003f, -4.192509e-005f,  2.711691e-003f,
    2.437417e-003f, -6.160072e-004f, -2.162039e-003f, -1.285613e-003f, -5.440264e-004f, -4.148969e-005f,  1.243950e-003f,  1.114099e-003f,
   -1.521311e-003f, -2.274706e-003f,  1.483911e-003f,  4.561938e-003f,  2.346375e-003f, -1.170171e-003f, -8.811196e-004f,  9.143293e-004f,
    4.078737e-004f, -4.662970e-004f,  6.817761e-004f,  1.038621e-003f, -1.612248e-003f, -3.592384e-003f, -1.267022e-003f,  2.790596e-003f,
    3.867464e-003f,  1.440592e-003f, -1.468504e-003f, -2.466813e-003f, -1.720046e-003f, -1.173141e-003f, -1.922485e-003f, -2.288787e-003f,
   -3.372399e-004f,  2.352473e-003f,  2.782598e-003f,  1.337493e-003f,  3.763039e-004f, -2.079926e-004f, -1.367479e-003f, -1.401822e-003f,
    8.563766e-004f,  2.545707e-003f,  1.425216e-003f,  5.073517e-006f,  4.744518e-004f,  7.243101e-004f, -2.290380e-004f,  7.026354e-004f,
    3.827418e-003f,  4.190197e-003f,  3.763872e-004f, -1.974879e-003f,  1.991780e-004f,  2.211641e-003f,  2.944976e-004f, -2.332788e-003f,
   -2.057803e-003f, -4.929345e-004f, -1.268602e-004f, -4.027864e-004f, -4.475959e-004f, -6.876173e-004f, -8.116243e-004f, -2.647672e-004f,
   -1.198998e-004f, -8.942644e-004f, -6.810135e-004f,  1.226528e-003f,  2.192889e-003f,  8.870031e-004f, -6.501538e-005f,  9.176133e-004f,
    1.332089e-003f, -5.044001e-004f, -2.104693e-003f, -1.110098e-003f,  1.101094e-003f,  2.156838e-003f,  1.574206e-003f, -1.765528e-004f,
   -2.317541e-003f, -3.128273e-003f, -1.506012e-003f,  8.827254e-004f,  1.148062e-003f, -1.498559e-003f, -5.056877e-003f, -6.490196e-003f,
   -4.155946e-003f,  3.101754e-005f,  1.806476e-003f, -1.429688e-004f, -2.048547e-003f, -6.603834e-004f,  1.874620e-003f,  1.830867e-003f,
   -4.304834e-004f, -1.717340e-003f, -5.033764e-005f,  4.491711e-003f,  9.367568e-003f,  9.382147e-003f,  2.113008e-003f, -6.251203e-003f,
   -6.953701e-003f, -6.184258e-004f,  4.038034e-003f,  3.043250e-003f,  5.454286e-004f, -2.335489e-004f, -5.615145e-004f, -6.067122e-004f,
    1.224732e-003f,  3.210917e-003f,  2.157968e-003f, -3.104605e-004f, -3.276830e-004f,  1.028058e-003f,  1.727011e-004f, -1.576743e-003f,
   -2.369042e-004f,  3.209167e-003f,  4.150727e-003f,  1.714964e-003f, -8.150393e-004f, -1.391398e-003f, -6.612735e-004f,  2.266570e-004f,
    1.317255e-004f, -1.743573e-003f, -3.985247e-003f, -3.823128e-003f, -1.098584e-003f,  1.186371e-003f,  9.049214e-004f, -1.065504e-003f,
   -2.721608e-003f, -2.714871e-003f, -8.510911e-004f,  1.394706e-003f,  2.019200e-003f,  1.229627e-003f,  9.971884e-004f,  1.375296e-003f,
    4.718819e-004f, -1.378078e-003f, -1.391486e-003f,  8.398181e-004f,  2.332504e-003f,  1.442831e-003f, -1.527775e-004f, -8.124381e-004f,
   -6.707557e-004f,  2.021009e-004f,  1.874228e-003f,  2.775296e-003f,  1.200962e-003f, -1.454407e-003f, -2.026563e-003f, -1.482041e-004f,
    1.175598e-003f, -1.668378e-004f, -2.605674e-003f, -3.132774e-003f, -1.295991e-003f,  3.184914e-004f, -1.159061e-005f, -3.725978e-004f,
    1.413243e-003f,  3.091855e-003f,  8.682729e-004f, -3.539941e-003f, -4.365605e-003f, -9.436636e-004f,  9.772845e-004f, -1.281493e-003f,
   -3.269102e-003f, -1.374972e-003f,  1.708213e-003f,  2.544935e-003f,  1.952935e-003f,  1.498103e-003f,  5.309576e-004f, -8.316776e-004f,
   -8.909814e-004f, -7.993190e-005f, -4.790906e-004f, -1.217414e-003f,  1.489948e-004f,  2.033610e-003f,  7.704899e-004f, -2.425955e-003f,
   -2.984374e-003f, -8.276234e-004f, -1.203710e-004f, -1.806503e-003f, -2.809257e-003f, -2.097028e-003f, -1.611734e-003f, -1.781886e-003f,
   -1.330314e-003f, -6.538772e-004f, -9.731840e-004f, -1.484865e-003f, -1.015813e-003f, -5.057082e-004f, -7.748666e-004f, -4.704843e-004f,
    1.065035e-003f,  1.924323e-003f,  9.243498e-004f, -4.555036e-004f, -1.052035e-003f, -1.415859e-003f, -1.293461e-003f,  2.968062e-004f,
    1.951659e-003f,  1.136857e-003f, -1.263777e-003f, -2.058168e-003f, -1.170758e-003f, -1.354395e-003f, -2.859461e-003f, -3.009893e-003f,
   -9.035300e-004f,  1.461719e-003f,  2.457217e-003f,  2.133058e-003f,  1.020430e-003f, -1.289908e-004f, -5.775320e-004f, -6.922428e-004f,
   -9.777556e-004f, -2.646414e-004f,  2.060740e-003f,  3.228280e-003f,  9.776847e-004f, -1.422772e-003f,  2.769976e-004f,  3.736043e-003f,
    3.598958e-003f,  4.634164e-004f, -9.930570e-004f, -4.896530e-004f, -1.058480e-003f, -2.057012e-003f, -1.123225e-003f, -2.146279e-004f,
   -1.848800e-003f, -2.792413e-003f,  5.045946e-004f,  4.141275e-003f,  2.660168e-003f, -1.361668e-003f, -1.783476e-003f,  9.787610e-004f,
    1.999804e-003f,  3.086269e-004f, -1.403498e-003f, -1.963279e-003f, -1.434012e-003f,  4.145689e-004f,  1.903819e-003f,  5.315305e-004f,
   -1.829799e-003f, -8.712552e-004f,  2.271109e-003f,  2.470183e-003f, -1.519757e-005f, -2.102409e-004f,  1.777450e-003f,  1.076179e-003f,
   -2.047949e-003f, -2.355566e-003f,  4.329300e-004f,  1.377173e-003f, -2.931294e-004f, -5.518948e-004f,  1.228061e-003f,  1.822031e-003f,
    9.920662e-004f,  1.289172e-003f,  2.377183e-003f,  2.019188e-003f,  8.037424e-004f,  5.392368e-004f,  5.789786e-004f,  7.199275e-007f,
   -4.185827e-006f,  8.195499e-004f,  6.026007e-004f, -4.514380e-004f,  2.618421e-004f,  2.269845e-003f,  2.000588e-003f, -6.311011e-004f,
   -1.855700e-003f, -9.940530e-004f, -1.215328e-003f, -2.839242e-003f, -2.526620e-003f,  2.718287e-004f,  2.262555e-003f,  2.159706e-003f,
    2.076146e-003f,  2.884292e-003f,  2.976398e-003f,  1.662237e-003f,  5.287215e-005f, -9.989785e-004f, -1.139544e-003f,  5.734513e-005f,
    1.751543e-003f,  1.704139e-003f, -6.743807e-004f, -2.982588e-003f, -2.891781e-003f, -8.055846e-004f,  1.284476e-003f,  1.920416e-003f,
    9.000273e-004f, -6.747654e-004f, -1.232267e-003f, -5.106709e-004f,  3.451332e-004f,  8.373044e-004f,  1.477019e-003f,  1.842812e-003f,
    7.998655e-004f, -9.294072e-004f, -1.187544e-003f,  1.639553e-004f,  9.450270e-004f,  1.446767e-004f, -8.906441e-004f, -9.576963e-004f,
   -4.074805e-004f, -2.668708e-006f, -3.828314e-005f, -2.950786e-004f,  5.500001e-005f,  1.475256e-003f,  2.590642e-003f,  1.531622e-003f,
   -9.504160e-004f, -2.022919e-003f, -7.275763e-004f,  9.382427e-004f,  1.012665e-003f, -4.286981e-004f, -1.927369e-003f, -1.676208e-003f,
    9.166575e-004f,  3.427187e-003f,  2.525347e-003f, -8.358407e-004f, -1.849079e-003f,  8.809541e-004f,  2.864511e-003f,  1.122103e-003f,
   -1.338477e-003f, -1.137593e-003f,  4.219831e-004f,  6.202267e-004f, -4.751733e-004f, -1.493164e-003f, -2.027376e-003f, -1.706001e-003f,
   -3.874789e-005f,  1.788551e-003f,  1.785390e-003f,  2.342139e-004f, -7.432979e-004f, -5.203890e-004f, -2.065117e-004f, -6.828889e-005f,
    5.516252e-004f,  1.215938e-003f,  8.490757e-004f, -1.527554e-004f, -4.183032e-004f,  1.769194e-004f,  5.724725e-004f,  3.812819e-004f,
    1.587905e-004f,  1.622978e-004f,  9.263733e-005f, -1.264291e-004f, -2.183319e-004f, -9.854894e-005f,  2.649926e-005f,  3.044447e-005f,
   -2.454141e-006f,  2.745858e-005f,  8.981737e-005f,  8.457806e-005f, -4.716523e-006f, -7.314335e-005f, -4.461550e-005f,  2.142542e-005f,
    4.472518e-005f,  3.999813e-005f,  4.011522e-005f,  2.491872e-005f, -7.180205e-006f, -1.566178e-005f,  6.559311e-007f,  5.728687e-006f
};

static const float MPSVTImpulseRight1[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  1.239615e-001f, -2.821597e-002f,  3.897466e-002f,  4.196440e-002f,
    2.720637e-002f, -3.424247e-004f, -9.386797e-003f, -2.900561e-003f,  6.959495e-003f,  5.007380e-003f, -1.985216e-003f, -3.863445e-003f,
    2.481827e-003f,  6.961548e-003f,  5.281065e-003f,  2.252970e-003f,  4.789982e-003f,  9.361265e-003f,  9.558144e-003f,  5.142255e-003f,
    2.507807e-003f,  3.319515e-003f,  3.538937e-003f,  2.533817e-004f, -3.309615e-003f, -4.005673e-003f, -2.779764e-003f, -2.340794e-003f,
   -2.435954e-003f, -1.802698e-003f, -6.908391e-004f, -3.930946e-004f, -6.423001e-004f, -6.791037e-004f, -5.435179e-004f, -6.731077e-004f,
   -5.186269e-004f,  2.097992e-004f,  7.663705e-004f,  4.383663e-004f, -3.292604e-005f,  1.300968e-004f,  4.569737e-004f,  1.113345e-004f,
   -4.436098e-004f, -3.656555e-004f,  1.032599e-004f,  5.251318e-005f, -4.452090e-004f, -6.209546e-004f, -3.296050e-004f, -1.871006e-004f,
   -3.525849e-004f, -3.959353e-004f, -1.467574e-004f,  1.144024e-005f, -9.568628e-005f, -2.159092e-004f, -1.631548e-004f, -1.002422e-004f,
   -1.270750e-004f, -1.336439e-004f, -5.350542e-005f, -8.830532e-006f, -5.064427e-005f, -9.453367e-005f, -8.772121e-005f, -9.183859e-005f,
   -1.206835e-004f, -1.234764e-004f, -8.803256e-005f, -6.959054e-005f, -8.006402e-005f, -9.136830e-005f, -9.271026e-005f, -9.682166e-005f,
   -9.179156e-005f, -7.472075e-005f, -6.539290e-005f, -6.906555e-005f, -5.890951e-005f, -4.095899e-005f, -4.941174e-005f, -7.659479e-005f,
   -7.237290e-005f, -4.065257e-005f, -3.488923e-005f, -5.914197e-005f, -5.860974e-005f, -2.947576e-005f, -2.695274e-005f, -5.861166e-005f,
   -6.567648e-005f, -3.561484e-005f, -2.351728e-005f, -4.671085e-005f, -5.381466e-005f, -2.798254e-005f, -1.764072e-005f, -4.137830e-005f,
   -5.203734e-005f, -2.920004e-005f, -1.555873e-005f, -3.299069e-005f, -4.261814e-005f, -2.363930e-005f, -1.182867e-005f, -2.830681e-005f,
   -3.957277e-005f, -2.416920e-005f, -1.164017e-005f, -2.330969e-005f, -3.295084e-005f, -2.066592e-005f, -9.898285e-006f, -1.986152e-005f,
   -2.942013e-005f, -2.016526e-005f, -1.023889e-005f, -1.689151e-005f, -2.433863e-005f, -1.707775e-005f, -9.031818e-006f, -1.448343e-005f,
   -2.104877e-005f, -1.568883e-005f, -9.035000e-006f, -1.277379e-005f, -1.754700e-005f, -1.316539e-005f, -8.019384e-006f, -1.119915e-005f,
   -1.511645e-005f, -1.172771e-005f, -7.732379e-006f, -1.012890e-005f, -1.282046e-005f, -9.836942e-006f, -6.822901e-006f, -8.988321e-006f,
   -1.107707e-005f, -8.585338e-006f, -6.341434e-006f, -8.177680e-006f, -9.537034e-006f, -7.201177e-006f, -5.520089e-006f, -7.270019e-006f,
   -8.295198e-006f, -6.219366e-006f, -4.978564e-006f, -6.585550e-006f, -7.248139e-006f, -5.262926e-006f, -4.292848e-006f, -5.830964e-006f,
   -6.353535e-006f, -4.555266e-006f, -3.800251e-006f, -5.227593e-006f, -5.599561e-006f, -3.910384e-006f, -3.268222e-006f, -4.593895e-006f,
   -4.920977e-006f, -3.408132e-006f, -2.868846e-006f, -4.072884e-006f, -4.342641e-006f, -2.964575e-006f, -2.476586e-006f, -3.556028e-006f,
   -3.810519e-006f, -2.601446e-006f, -2.173328e-006f, -3.127027e-006f, -3.353757e-006f, -2.284379e-006f, -1.891927e-006f, -2.720558e-006f,
   -2.932381e-006f, -2.012605e-006f, -1.667536e-006f, -2.381537e-006f, -2.569256e-006f, -1.774487e-006f, -1.465107e-006f, -2.071085e-006f,
   -2.237387e-006f, -1.563443e-006f, -1.297812e-006f, -1.811153e-006f, -1.951915e-006f, -1.377720e-006f, -1.148191e-006f, -1.578478e-006f,
   -1.694946e-006f, -1.210728e-006f, -1.020085e-006f, -1.382300e-006f, -1.474777e-006f, -1.063868e-006f, -9.053953e-007f, -1.208710e-006f,
   -1.279356e-006f, -9.317721e-007f, -8.044850e-007f, -1.060757e-006f, -1.112330e-006f, -8.161221e-007f, -7.139704e-007f, -9.303113e-007f,
   -9.655970e-007f, -7.128222e-007f, -6.331389e-007f, -8.177777e-007f, -8.401635e-007f, -6.229295e-007f, -5.607408e-007f, -7.184995e-007f,
   -7.306086e-007f, -5.433614e-007f, -4.958345e-007f, -6.319302e-007f, -6.366612e-007f, -4.744705e-007f, -4.379782e-007f, -5.554371e-007f,
   -5.547399e-007f, -4.139481e-007f, -3.862578e-007f, -4.882521e-007f, -4.841185e-007f, -3.616698e-007f, -3.404418e-007f, -4.288695e-007f,
   -4.224759e-007f, -3.159398e-007f, -2.997093e-007f, -3.765489e-007f, -3.690344e-007f, -2.764092e-007f, -2.638287e-007f, -1.331918e-006f,
   -5.047501e-006f,  1.258652e-005f,  3.866887e-005f,  1.804590e-005f, -2.869922e-005f, -3.748321e-005f, -3.471694e-005f, -5.853948e-005f,
   -4.854157e-005f,  8.788823e-006f,  1.709037e-005f, -1.431122e-005f,  2.332381e-005f,  6.885746e-005f,  4.906283e-007f, -6.115225e-005f,
    4.551183e-006f,  1.693268e-005f, -9.697450e-005f, -6.001201e-005f,  1.201000e-004f,  1.995396e-005f, -2.522181e-004f, -5.364133e-005f,
    4.411067e-004f,  3.091631e-004f, -3.397660e-004f, -4.072915e-004f,  9.852844e-005f,  8.087444e-005f, -3.983298e-004f, -2.453937e-004f,
    3.209464e-004f,  1.187838e-004f, -5.669139e-004f, -5.840814e-004f, -3.304024e-004f, -8.382758e-004f, -1.497975e-003f, -1.368649e-003f,
   -1.140790e-003f, -1.364856e-003f, -1.229486e-003f, -1.177815e-003f, -2.800982e-003f, -4.502144e-003f, -3.165632e-003f, -1.570474e-003f,
   -5.657218e-003f, -1.216378e-002f, -9.851008e-003f,  2.154501e-003f,  9.373859e-003f,  3.108788e-003f, -5.646307e-003f, -4.155685e-003f,
    1.722760e-003f, -8.912879e-004f, -9.287911e-003f, -1.047928e-002f, -3.347917e-003f,  1.214148e-003f, -5.354077e-004f, -1.828513e-003f,
   -2.002154e-004f, -5.742079e-004f, -3.125001e-003f, -2.053512e-003f,  2.332423e-003f,  3.199208e-003f,  1.922959e-005f, -4.956402e-004f,
    2.688372e-003f,  3.231350e-003f, -2.512673e-004f, -2.009324e-003f, -4.114871e-004f,  5.401477e-006f, -1.457201e-003f, -6.443383e-004f,
    2.006121e-003f,  1.662524e-003f, -1.188370e-003f, -1.337618e-003f,  1.358931e-003f,  2.285314e-003f,  8.789022e-004f,  2.750993e-004f,
    2.675504e-004f, -1.179282e-003f, -2.384729e-003f, -1.314293e-003f, -4.901098e-004f, -2.042095e-003f, -3.038972e-003f, -1.521943e-003f,
   -8.468878e-004f, -2.768848e-003f, -3.386709e-003f, -7.033842e-004f,  1.357183e-003f,  3.726602e-004f, -8.821729e-004f, -8.760325e-004f,
   -1.571998e-003f, -2.723261e-003f, -1.713442e-003f,  6.304334e-004f,  1.306492e-003f,  7.976061e-004f,  8.825159e-004f,  2.733485e-004f,
   -1.443654e-003f, -9.578972e-004f,  2.149347e-003f,  3.264583e-003f,  1.716175e-003f,  2.226526e-003f,  3.863786e-003f,  8.759295e-005f,
   -6.730258e-003f, -5.930976e-003f,  2.126799e-003f,  3.885311e-003f, -5.309614e-003f, -1.347470e-002f, -1.129001e-002f, -3.059739e-003f,
    5.528467e-003f,  1.438615e-002f,  2.021513e-002f,  1.635939e-002f,  5.148448e-003f, -2.577255e-003f, -2.002891e-003f,  2.234833e-003f,
    5.604727e-003f,  6.671696e-003f,  4.218178e-003f,  3.633131e-004f,  9.827816e-004f,  5.598016e-003f,  5.172539e-003f, -3.043095e-003f,
   -8.933976e-003f, -5.032789e-003f,  2.426381e-003f,  4.881490e-003f,  3.023861e-003f,  1.095314e-003f, -8.661168e-005f,  6.788343e-005f,
    2.763977e-003f,  5.212246e-003f,  3.630489e-003f,  3.256296e-004f, -4.359244e-004f, -4.582476e-004f, -2.969031e-003f, -4.936646e-003f,
   -2.831727e-003f, -1.597335e-004f, -9.553825e-004f, -2.395696e-003f, -1.181751e-003f,  1.032310e-004f, -8.220602e-004f, -1.273843e-003f,
    5.098059e-005f,  1.813886e-004f, -1.424795e-003f, -1.521480e-003f, -9.617269e-006f, -4.315980e-005f, -1.325820e-003f, -1.272935e-003f,
   -9.569460e-004f, -2.180295e-003f, -2.275016e-003f,  6.746789e-004f,  2.574803e-003f,  5.144357e-004f, -1.131695e-003f,  1.306180e-003f,
    3.820704e-003f,  2.237964e-003f, -5.833356e-004f, -7.436740e-004f,  5.404275e-004f,  1.166070e-003f,  1.917761e-003f,  3.184986e-003f,
    3.822650e-003f,  4.081352e-003f,  4.438383e-003f,  3.148647e-003f, -5.645691e-005f, -1.673164e-003f, -5.478337e-004f, -4.278595e-004f,
   -2.134903e-003f, -1.286190e-003f,  2.037108e-003f,  1.519531e-003f, -3.090689e-003f, -3.596682e-003f,  1.971164e-003f,  4.938566e-003f,
    1.316376e-003f, -1.608381e-003f,  6.431847e-004f,  2.249571e-003f, -7.327777e-004f, -3.256089e-003f, -1.766299e-003f, -2.594932e-004f,
   -1.196677e-003f, -1.058150e-003f,  1.296268e-003f,  1.853126e-003f, -1.315744e-004f, -3.833478e-004f,  1.704974e-003f,  1.683479e-003f,
   -1.197829e-003f, -2.516256e-003f, -1.157922e-003f, -1.017033e-003f, -3.001417e-003f, -3.038828e-003f,  4.519022e-004f,  3.876366e-003f,
    4.714585e-003f,  4.460407e-003f,  3.989180e-003f,  1.689438e-003f, -2.035621e-003f, -3.581812e-003f, -1.744417e-003f, -1.399030e-004f,
   -1.546791e-003f, -3.687453e-003f, -3.485495e-003f, -2.102372e-003f, -2.321840e-003f, -3.601940e-003f, -3.554472e-003f, -2.572655e-003f,
   -3.000979e-003f, -4.490895e-003f, -4.091048e-003f, -1.293473e-003f,  4.579908e-004f, -1.206754e-003f, -3.582851e-003f, -2.478468e-003f,
    1.408556e-003f,  3.131937e-003f,  8.731935e-004f, -1.443007e-003f, -9.617234e-004f, -4.925660e-004f, -2.223770e-003f, -2.257901e-003f,
    2.137895e-003f,  5.355842e-003f,  2.150729e-003f, -2.012316e-003f,  5.144226e-005f,  3.628028e-003f,  4.401559e-004f, -4.910200e-003f,
   -2.131729e-003f,  5.660098e-003f,  6.763397e-003f,  1.258460e-003f, -7.775344e-004f,  1.554673e-003f,  2.490034e-004f, -4.459958e-003f,
   -4.413938e-003f,  7.786170e-004f,  3.873850e-003f,  3.349143e-003f,  2.965372e-003f,  2.110497e-003f, -1.042012e-003f, -2.491682e-003f,
    4.672871e-004f,  2.619211e-003f,  7.566187e-004f,  3.991770e-004f,  4.155873e-003f,  5.340169e-003f,  1.126413e-003f, -1.293081e-003f,
    1.064103e-003f,  1.000643e-003f, -4.042101e-003f, -6.122594e-003f, -1.663334e-003f,  2.390470e-003f,  1.908585e-003f,  1.148409e-003f,
    2.076503e-003f,  1.416616e-003f, -3.935827e-004f,  3.334132e-004f,  1.714237e-003f, -6.672320e-004f, -4.248270e-003f, -3.502708e-003f,
    4.627374e-005f,  1.064770e-003f, -4.232492e-004f, -5.063666e-004f,  1.952636e-003f,  4.601097e-003f,  3.993277e-003f, -1.293655e-003f,
   -6.097591e-003f, -2.730100e-003f,  4.994857e-003f,  3.058401e-003f, -9.003980e-003f, -1.211061e-002f,  1.735442e-003f,  1.284952e-002f,
    5.619789e-003f, -4.935839e-003f, -6.913551e-004f,  7.477821e-003f,  1.662716e-003f, -9.085868e-003f, -6.120673e-003f,  4.063245e-003f,
    2.564556e-003f, -7.205147e-003f, -6.862745e-003f,  3.419121e-003f,  5.762141e-003f, -5.062176e-003f, -1.481165e-002f, -1.277669e-002f,
   -4.371829e-003f,  8.539506e-004f,  1.870225e-003f,  3.466263e-003f,  7.048216e-003f,  8.415261e-003f,  4.676973e-003f,  5.085194e-005f,
    3.422852e-004f,  3.648393e-003f,  3.750308e-003f,  1.262158e-003f,  1.882600e-003f,  4.733016e-003f,  3.723236e-003f, -3.470177e-004f,
   -1.090712e-003f,  1.306463e-003f,  1.483340e-003f,  1.974128e-004f,  1.703877e-003f,  3.216536e-003f, -3.655121e-004f, -5.540886e-003f,
   -6.211788e-003f, -4.867578e-003f, -6.081352e-003f, -6.349024e-003f, -2.230077e-003f,  1.280133e-004f, -4.215950e-003f, -7.762946e-003f,
   -2.309231e-003f,  6.784648e-003f,  9.583496e-003f,  6.775959e-003f,  5.445416e-003f,  6.886352e-003f,  7.768148e-003f,  7.476643e-003f,
    7.130641e-003f,  6.057204e-003f,  3.862932e-003f,  1.828834e-003f,  1.057911e-004f, -2.272863e-003f, -4.182527e-003f, -3.404131e-003f,
   -2.782004e-004f,  3.042907e-003f,  5.330479e-003f,  5.771969e-003f,  3.662497e-003f,  6.146601e-004f, -4.708856e-004f,  2.121490e-004f,
    1.626418e-004f, -1.750853e-004f,  1.826882e-003f,  5.037775e-003f,  5.136482e-003f,  1.433966e-003f, -2.030537e-003f, -2.384004e-003f,
   -5.751188e-004f,  1.541261e-003f,  3.037099e-003f,  3.352409e-003f,  2.760688e-003f,  2.599691e-003f,  3.185029e-003f,  2.876855e-003f,
    6.374512e-004f, -2.018186e-003f, -2.760470e-003f, -1.027604e-003f,  1.607472e-003f,  2.949192e-003f,  2.252188e-003f,  1.073609e-003f,
    1.232409e-003f,  2.065733e-003f,  1.294243e-003f, -1.480124e-003f, -3.950285e-003f, -3.915087e-003f, -1.659307e-003f,  5.081886e-004f,
    7.404378e-004f, -1.217466e-004f,  1.140957e-004f,  6.733107e-004f, -1.993995e-003f, -7.280628e-003f, -8.549500e-003f, -2.946936e-003f,
    2.474075e-003f,  1.191915e-003f, -2.108674e-003f,  4.341074e-005f,  4.372410e-003f,  2.152648e-003f, -5.727806e-003f, -9.399514e-003f,
   -4.112575e-003f,  4.324213e-003f,  7.289232e-003f,  1.791162e-003f, -6.963835e-003f, -9.733032e-003f, -3.547900e-003f,  3.304078e-003f,
    2.625288e-003f, -1.158739e-003f,  6.700186e-004f,  5.265307e-003f,  3.743252e-003f, -1.874719e-003f, -2.208161e-003f,  2.510424e-003f,
    4.213915e-003f,  2.320667e-003f,  2.432043e-003f,  3.729591e-003f,  1.986465e-003f,  1.853883e-004f,  2.491966e-003f,  4.048296e-003f,
    6.155707e-006f, -3.261555e-003f,  7.221677e-004f,  5.348818e-003f,  2.357326e-003f, -3.132239e-003f, -2.424340e-003f,  1.534123e-003f,
    1.664055e-003f,  4.656762e-005f,  1.544400e-003f,  3.152368e-003f,  7.886721e-004f, -1.773305e-003f, -3.886695e-004f,  1.234396e-003f,
   -9.483543e-004f, -3.439125e-003f, -1.931628e-003f,  1.258974e-003f,  2.251122e-003f,  1.679512e-003f,  1.494609e-003f,  1.419967e-003f,
    1.344949e-003f,  2.150842e-003f,  2.951883e-003f,  2.175449e-003f,  1.086298e-003f,  1.685995e-003f,  2.628827e-003f,  1.849701e-003f,
    8.176658e-004f,  1.386397e-003f,  1.556476e-003f, -4.612975e-004f, -1.507299e-003f,  1.423346e-003f,  4.736660e-003f,  3.217220e-003f,
   -1.356983e-003f, -3.106492e-003f, -1.330212e-003f, -1.742106e-004f, -6.412854e-004f,  3.640494e-005f,  1.754672e-003f,  1.370911e-003f,
   -6.301579e-004f, -2.091701e-004f,  2.681928e-003f,  3.322237e-003f,  1.617036e-004f, -2.962754e-003f, -3.683784e-003f, -3.551129e-003f,
   -2.742244e-003f,  4.468134e-004f,  3.942934e-003f,  3.551028e-003f,  1.094614e-003f,  2.351949e-003f,  6.109615e-003f,  4.989736e-003f,
   -1.404411e-003f, -4.655918e-003f, -1.343651e-003f,  1.651771e-003f, -9.304811e-004f, -4.937926e-003f, -4.766332e-003f, -1.194058e-003f,
    2.075744e-003f,  3.310808e-003f,  2.151293e-003f, -5.528938e-004f, -1.836950e-003f, -1.771354e-004f,  1.324989e-003f, -2.139259e-004f,
   -2.205716e-003f, -9.913705e-004f,  1.943987e-003f,  3.016536e-003f,  2.221598e-003f,  1.450540e-003f,  8.427458e-004f,  2.649912e-004f,
    5.847099e-004f,  1.171122e-003f,  2.370669e-004f, -1.343573e-003f, -1.159253e-003f,  2.199149e-005f, -2.168452e-004f, -9.846216e-004f,
   -2.827952e-004f,  5.274629e-005f, -2.269171e-003f, -4.530436e-003f, -3.307793e-003f, -8.800059e-004f, -8.831573e-004f, -1.442602e-003f,
    7.326190e-004f,  3.411115e-003f,  2.646626e-003f, -1.347151e-004f, -9.311668e-004f,  2.394670e-004f,  5.961683e-004f, -6.475758e-004f,
   -2.521486e-003f, -4.099959e-003f, -3.788156e-003f, -6.156286e-004f,  2.552396e-003f,  1.660772e-003f, -2.092703e-003f, -3.596137e-003f,
   -1.764347e-003f, -4.393032e-004f, -1.211485e-003f, -1.407812e-003f,  1.105921e-004f,  8.543425e-004f, -5.193765e-004f, -2.060391e-003f,
   -2.103250e-003f, -1.338297e-003f, -9.461989e-004f, -1.466415e-003f, -3.042544e-003f, -4.560235e-003f, -4.044681e-003f, -1.942279e-003f,
   -1.384520e-003f, -2.940295e-003f, -2.897963e-003f,  9.169989e-005f,  1.277951e-003f, -2.656589e-003f, -6.840719e-003f, -4.931612e-003f,
    1.206053e-003f,  5.050137e-003f,  5.198734e-003f,  4.479046e-003f,  2.625615e-003f, -1.902472e-003f, -5.351495e-003f, -2.865860e-003f,
    2.364044e-003f,  3.068628e-003f, -4.213747e-004f, -1.707169e-003f, -6.292965e-005f, -4.262681e-004f, -2.428899e-003f, -4.910332e-004f,
    4.374358e-003f,  3.738174e-003f, -4.756319e-003f, -1.223960e-002f, -1.014165e-002f, -2.615993e-004f,  8.701492e-003f,  9.684659e-003f,
    2.111030e-003f, -7.230754e-003f, -9.068521e-003f, -1.481697e-003f,  7.012544e-003f,  7.567366e-003f,  9.812475e-004f, -5.629834e-003f,
   -7.769848e-003f, -5.502910e-003f, -8.848839e-004f,  2.772098e-003f,  2.716114e-003f,  4.909080e-004f,  4.669642e-004f,  3.466262e-003f,
    5.750742e-003f,  4.775780e-003f,  1.819147e-003f, -1.053158e-003f, -2.702718e-003f, -2.196527e-003f,  5.835572e-005f,  1.417548e-003f,
    8.448405e-005f, -2.273269e-003f, -2.940886e-003f, -1.448985e-003f,  5.430314e-004f,  8.811082e-004f, -1.203101e-003f, -3.232545e-003f,
   -1.843903e-003f,  1.283756e-003f,  5.420038e-004f, -4.207476e-003f, -6.113451e-003f, -2.416173e-003f,  1.281482e-003f,  1.421076e-003f,
    1.266965e-003f,  1.631672e-003f, -1.338312e-003f, -5.173849e-003f, -1.638080e-003f,  7.216208e-003f,  8.830566e-003f,  1.055429e-003f,
   -3.343294e-003f,  1.129769e-003f,  3.765052e-003f, -2.004657e-003f, -7.131261e-003f, -4.219479e-003f,  2.566688e-004f, -3.319429e-004f,
   -1.708111e-003f,  4.956488e-004f,  2.044685e-003f, -4.701912e-004f, -2.737996e-003f, -1.051067e-003f,  1.848073e-003f,  2.935690e-003f,
    2.812954e-003f,  1.817829e-003f, -4.482697e-004f, -1.705970e-003f,  3.075111e-004f,  2.977391e-003f,  2.345323e-003f, -7.929042e-004f,
   -3.034835e-003f, -3.392394e-003f, -2.447075e-003f, -4.384204e-004f,  1.124567e-003f,  4.062234e-004f, -8.398719e-004f,  4.701555e-004f,
    2.413373e-003f,  4.158131e-004f, -4.149887e-003f, -4.904244e-003f, -3.657344e-004f,  3.933256e-003f,  3.844425e-003f,  1.145218e-003f,
   -8.426457e-004f, -1.228285e-003f, -7.185828e-004f, -3.114422e-004f, -7.196392e-004f, -1.148143e-003f,  2.485244e-005f,  2.177722e-003f,
    2.507761e-003f,  2.383478e-004f, -2.050114e-003f, -2.169492e-003f, -6.248112e-004f,  1.172663e-003f,  2.142081e-003f,  1.162241e-003f,
   -1.538223e-003f, -3.176951e-003f, -1.719979e-003f,  5.193308e-004f, -9.327649e-006f, -2.415199e-003f, -2.663372e-003f,  1.275289e-004f,
    2.784530e-003f,  3.331024e-003f,  2.971664e-003f,  2.428844e-003f,  5.747802e-004f, -2.115571e-003f, -2.892564e-003f, -1.258713e-003f,
   -1.931365e-004f, -9.616658e-004f, -1.128117e-003f,  5.738953e-005f, -3.275542e-004f, -2.414425e-003f, -1.428158e-003f,  3.609571e-003f,
    5.978867e-003f,  1.733942e-003f, -3.071286e-003f, -2.273137e-003f,  6.663195e-004f,  2.348657e-004f, -1.398655e-003f, -2.720437e-004f,
    1.253314e-003f,  2.888085e-004f, -2.675217e-004f,  1.364943e-003f,  9.551677e-004f, -2.855695e-003f, -4.122275e-003f, -6.316898e-004f,
    8.814608e-004f, -3.016403e-003f, -5.806921e-003f, -2.823965e-003f,  1.136049e-003f,  1.539269e-003f,  9.089125e-004f,  1.663103e-003f,
    2.297296e-003f,  2.964611e-003f,  4.916721e-003f,  4.785700e-003f, -1.701165e-005f, -3.220300e-003f,  1.123359e-003f,  6.369945e-003f,
    3.502008e-003f, -2.678079e-003f, -2.166177e-003f,  2.366174e-003f,  1.832597e-003f, -1.990965e-003f, -1.094714e-003f,  3.231356e-003f,
    4.122053e-003f,  2.180005e-003f,  1.918949e-003f,  1.938404e-003f, -2.051883e-004f, -9.658323e-004f,  1.745298e-003f,  2.669521e-003f,
   -9.969609e-004f, -3.414788e-003f, -9.428813e-004f,  9.716450e-004f, -1.694349e-003f, -4.273313e-003f, -2.549144e-003f,  2.716521e-004f,
    5.229778e-004f, -4.331816e-004f, -8.717008e-004f, -1.268866e-003f, -8.189816e-004f,  1.628130e-003f,  3.518249e-003f,  2.133687e-003f,
    3.162278e-004f,  2.046404e-003f,  5.033126e-003f,  4.215233e-003f, -1.703665e-004f, -3.717718e-003f, -4.183051e-003f, -2.267571e-003f,
    7.586741e-004f,  2.942323e-003f,  2.445169e-003f,  4.358031e-004f, -2.085350e-004f,  4.139741e-004f, -1.973605e-004f, -2.056503e-003f,
   -2.742680e-003f, -1.768749e-003f, -9.237807e-004f, -1.106110e-003f, -1.891556e-003f, -2.816321e-003f, -3.012170e-003f, -1.723500e-003f,
   -2.153384e-004f, -2.309701e-004f, -6.256496e-004f,  6.326810e-004f,  2.179019e-003f,  1.690448e-003f,  6.836524e-004f,  1.381700e-003f,
    1.556340e-003f, -1.155042e-003f, -3.163660e-003f, -3.507866e-004f,  3.984534e-003f,  4.208736e-003f,  1.692933e-003f,  1.261575e-003f,
    2.115924e-003f,  3.399987e-004f, -2.990273e-003f, -3.925694e-003f, -2.811213e-003f, -2.529552e-003f, -2.689290e-003f, -1.484005e-003f,
   -9.383934e-005f, -2.127681e-004f, -5.801418e-004f,  1.284605e-004f,  7.824420e-004f,  9.804171e-004f,  2.206088e-003f,  3.775978e-003f,
    2.932112e-003f,  4.947343e-004f,  4.355319e-004f,  2.595036e-003f,  2.433088e-003f, -7.542908e-004f, -2.370694e-003f, -6.582257e-004f,
    7.141154e-004f, -2.608386e-004f, -1.047662e-003f, -3.611931e-004f, -3.459734e-004f, -1.340243e-003f, -5.656504e-004f,  2.222088e-003f,
    3.279931e-003f,  8.816107e-004f, -1.848824e-003f, -1.713409e-003f,  6.708778e-004f,  2.916683e-003f,  3.735950e-003f,  2.909360e-003f,
    7.637859e-004f, -1.601510e-003f, -2.895794e-003f, -2.663165e-003f, -1.365067e-003f, -3.722852e-005f,  1.849798e-004f, -7.635817e-004f,
   -1.509197e-003f, -9.827667e-004f,  4.539051e-004f,  2.329715e-003f,  4.452991e-003f,  5.311150e-003f,  3.306378e-003f,  3.404209e-004f,
   -1.464127e-004f,  7.104053e-004f, -1.113998e-003f, -4.163256e-003f, -2.654642e-003f,  2.594098e-003f,  3.850829e-003f, -2.461705e-004f,
   -1.555619e-003f,  3.388834e-003f,  6.962572e-003f,  3.568018e-003f, -1.342233e-003f, -1.449491e-003f,  9.089252e-004f,  1.396848e-003f,
    8.728925e-004f,  5.229008e-004f, -1.672193e-003f, -5.035073e-003f, -5.014585e-003f, -1.439444e-003f,  3.145775e-004f, -1.112389e-003f,
   -9.810320e-004f,  2.171230e-003f,  3.948521e-003f,  2.562223e-003f,  1.271877e-003f,  1.085282e-003f, -7.081564e-004f, -3.714700e-003f,
   -3.900946e-003f, -7.810254e-004f,  1.553521e-003f,  1.063534e-003f, -1.225356e-004f, -7.670899e-005f,  8.949573e-004f,  1.869698e-003f,
    1.826739e-003f,  1.720594e-004f, -1.301146e-003f,  1.208956e-004f,  3.162869e-003f,  3.058786e-003f, -1.339314e-003f, -5.080213e-003f,
   -3.757495e-003f,  8.294185e-004f,  3.607462e-003f,  2.467803e-003f, -5.047869e-006f, -2.451803e-004f,  1.588004e-003f,  1.801249e-003f,
   -8.214741e-004f, -1.961495e-003f,  1.564519e-003f,  5.268973e-003f,  3.189406e-003f, -2.112828e-003f, -3.260248e-003f,  3.551984e-004f,
    2.905657e-003f,  2.370015e-003f,  1.990509e-003f,  2.790404e-003f,  2.716854e-003f,  1.959170e-003f,  1.924561e-003f,  1.059392e-003f,
   -1.673847e-003f, -2.573189e-003f,  8.216213e-004f,  3.898568e-003f,  2.186109e-003f, -5.332726e-004f,  1.175840e-003f,  4.676453e-003f,
    4.027620e-003f,  1.130073e-004f, -1.704123e-003f, -5.721932e-004f,  8.722136e-005f, -8.994756e-004f, -1.793260e-003f, -1.599908e-003f,
   -3.961348e-004f,  1.702375e-003f,  3.341746e-003f,  2.543767e-003f,  1.591768e-004f, -7.174952e-004f,  1.103892e-004f, -5.436638e-004f,
   -3.402292e-003f, -4.789514e-003f, -2.340480e-003f,  1.317249e-003f,  2.778024e-003f,  2.451952e-003f,  2.505463e-003f,  2.826862e-003f,
    1.888294e-003f,  9.010942e-005f, -6.559585e-004f, -1.993046e-004f, -3.713041e-004f, -1.710628e-003f, -2.405276e-003f, -1.304194e-003f,
    2.528967e-004f,  7.896611e-004f,  7.598890e-004f,  8.682602e-004f,  4.724101e-004f, -6.668712e-004f, -1.086289e-003f,  1.385135e-004f,
    1.701740e-003f,  2.197787e-003f,  2.076433e-003f,  2.120707e-003f,  1.929365e-003f,  1.110627e-003f,  1.371031e-004f, -7.442101e-004f,
   -1.557110e-003f, -1.358554e-003f,  7.429738e-004f,  3.282602e-003f,  3.674166e-003f,  1.810164e-003f, -7.552353e-005f, -1.043411e-003f,
   -2.108506e-003f, -2.991894e-003f, -1.375244e-003f,  3.036079e-003f,  6.210285e-003f,  4.428681e-003f,  1.541758e-004f, -5.346035e-004f,
    3.068786e-003f,  4.561866e-003f,  3.128978e-004f, -4.213032e-003f, -3.081671e-003f,  4.142043e-004f, -4.549860e-006f, -2.552018e-003f,
   -1.748915e-003f,  5.723406e-004f, -6.660704e-004f, -2.699655e-003f,  2.370889e-004f,  4.685182e-003f,  3.280050e-003f, -1.429962e-003f,
   -1.872452e-003f, -3.391194e-005f, -2.802742e-003f, -7.038412e-003f, -4.581565e-003f,  1.788798e-003f,  2.818984e-003f, -7.236517e-004f,
   -1.083607e-003f,  1.301067e-003f,  4.309228e-004f, -2.155586e-003f, -1.110408e-003f,  1.115910e-003f, -2.923149e-004f, -1.618158e-003f,
    2.168493e-003f,  6.262071e-003f,  4.246445e-003f,  3.995161e-005f,  3.276535e-004f,  2.917697e-003f,  2.854306e-003f,  1.768591e-003f,
    2.093453e-003f,  9.536896e-004f, -2.259178e-003f, -1.946925e-003f,  3.001583e-003f,  4.917874e-003f,  3.248923e-004f, -3.349305e-003f,
   -3.492457e-004f,  4.284011e-003f,  4.198194e-003f,  1.147751e-003f, -4.512867e-004f, -4.717540e-004f, -2.849151e-004f,  3.922172e-004f,
    1.067214e-003f,  4.285735e-004f, -2.216531e-004f,  1.403460e-003f,  3.850650e-003f,  3.836159e-003f,  1.770551e-003f,  5.809204e-004f,
    5.547801e-004f, -1.276237e-004f, -1.351189e-003f, -1.653578e-003f, -1.397748e-003f, -1.884473e-003f, -2.466281e-003f, -1.384052e-003f,
    1.152061e-003f,  2.776975e-003f,  1.954450e-003f,  1.137210e-004f, -1.330711e-007f,  1.801943e-003f,  2.530483e-003f,  7.518503e-004f,
   -3.242657e-004f,  2.235990e-003f,  5.363605e-003f,  4.115231e-003f, -7.108467e-005f, -1.233981e-003f,  1.592940e-003f,  3.040577e-003f,
    5.821698e-005f, -3.963414e-003f, -4.962180e-003f, -3.272787e-003f, -1.536285e-003f, -1.192684e-003f, -2.116046e-003f, -3.176515e-003f,
   -2.800411e-003f, -7.634233e-004f,  1.031953e-003f,  9.628705e-004f, -2.569155e-004f, -1.158510e-003f, -1.594595e-003f, -1.957786e-003f,
   -1.897848e-003f, -1.090940e-003f, -1.036337e-004f,  4.031300e-004f,  4.795542e-004f,  4.821272e-004f,  4.864926e-004f,  2.375521e-004f,
   -4.374500e-004f, -9.100375e-004f,  6.944957e-006f,  2.165423e-003f,  3.479363e-003f,  2.831266e-003f,  2.086646e-003f,  2.863258e-003f,
    3.194728e-003f,  7.480017e-004f, -2.433348e-003f, -2.486681e-003f,  2.708711e-004f,  2.142177e-003f,  1.898037e-003f,  1.634310e-003f,
    2.408792e-003f,  2.961130e-003f,  2.531506e-003f,  1.687431e-003f,  5.923846e-004f, -9.696654e-004f, -2.309142e-003f, -2.575340e-003f,
   -2.122173e-003f, -1.780151e-003f, -1.747878e-003f, -1.937720e-003f, -2.048522e-003f, -1.188849e-003f,  6.474270e-004f,  1.203873e-003f,
   -1.173508e-003f, -3.977824e-003f, -3.516211e-003f, -9.568604e-004f, -9.170026e-004f, -3.858352e-003f, -4.930359e-003f, -1.636815e-003f,
    2.290246e-003f,  2.933320e-003f,  1.679998e-003f,  1.570249e-003f,  1.840914e-003f,  6.829909e-005f, -2.678438e-003f, -3.123498e-003f,
   -1.140956e-003f,  2.143563e-004f, -1.844189e-004f, -2.562460e-004f,  9.371708e-004f,  1.336676e-003f, -1.978127e-004f, -1.458829e-003f,
   -4.128916e-004f,  1.602802e-003f,  2.356107e-003f,  1.946242e-003f,  1.478431e-003f,  9.471281e-004f,  4.366925e-004f,  8.558101e-004f,
    1.657575e-003f,  8.686432e-004f, -9.060522e-004f, -4.270286e-004f,  2.160280e-003f,  2.058645e-003f, -2.399442e-003f, -5.845162e-003f,
   -3.794244e-003f,  4.511602e-004f,  1.514049e-003f, -3.439983e-005f, -5.118460e-004f,  1.147993e-004f, -3.067871e-004f, -1.250746e-003f,
   -1.147060e-003f, -9.775823e-004f, -1.866537e-003f, -2.017525e-003f, -9.945860e-006f,  1.875118e-003f,  1.298928e-003f, -1.843891e-004f,
   -1.999737e-004f,  4.156078e-004f, -1.622034e-004f, -1.226512e-003f, -1.134169e-003f, -1.533996e-004f,  5.698494e-004f,  1.009390e-003f,
    1.649704e-003f,  2.404562e-003f,  2.894765e-003f,  2.632270e-003f,  1.240796e-003f, -3.538541e-004f, -2.308471e-004f,  1.625298e-003f,
    2.558942e-003f,  9.024498e-004f, -1.706066e-003f, -3.009841e-003f, -2.755395e-003f, -1.610029e-003f, -1.293245e-004f,  5.121056e-004f,
   -4.799123e-004f, -1.657941e-003f, -1.207422e-003f,  8.243898e-005f,  6.090096e-004f,  9.555935e-004f,  1.869736e-003f,  1.832961e-003f,
    1.455086e-004f, -8.370297e-004f,  2.151941e-005f,  2.812482e-004f, -9.396074e-004f, -7.626361e-004f,  1.391506e-003f,  1.930649e-003f,
    2.681819e-004f,  3.990022e-004f,  2.581239e-003f,  2.158096e-003f, -7.862165e-004f, -6.014904e-004f,  2.630866e-003f,  2.190584e-003f,
   -2.307136e-003f, -3.215448e-003f,  1.048659e-003f,  2.962941e-003f, -1.151917e-004f, -1.931572e-003f, -1.651535e-004f, -1.758925e-004f,
   -3.130144e-003f, -3.168992e-003f,  9.798133e-004f,  3.484994e-003f,  2.160579e-003f,  6.419517e-004f, -3.286884e-004f, -2.934273e-003f,
   -4.736966e-003f, -1.878808e-003f,  2.196006e-003f,  1.536858e-003f, -1.881713e-003f, -2.387608e-003f, -1.008981e-003f, -1.870846e-003f,
   -3.109684e-003f, -9.398668e-004f,  2.217381e-003f,  2.277783e-003f,  8.589677e-004f,  8.426331e-004f,  6.757993e-004f, -7.303738e-004f,
   -4.021972e-004f,  2.033351e-003f,  1.816343e-003f, -2.094671e-003f, -3.940680e-003f, -1.188699e-003f,  1.005655e-003f, -6.608720e-004f,
   -2.270076e-003f, -6.285212e-004f,  1.576703e-003f,  1.898202e-003f,  1.912845e-003f,  2.296328e-003f,  1.090977e-003f, -1.211570e-003f,
   -1.366414e-003f,  5.945552e-004f,  1.148226e-003f, -1.862281e-004f, -4.940666e-005f,  2.337239e-003f,  3.526709e-003f,  1.644009e-003f,
   -8.665383e-004f, -1.491918e-003f, -9.546012e-004f, -9.851570e-004f, -1.498965e-003f, -1.427692e-003f, -8.501210e-004f, -9.568679e-004f,
   -2.219673e-003f, -3.419633e-003f, -2.897981e-003f, -5.766617e-004f,  1.756608e-003f,  2.217512e-003f,  5.711983e-004f, -1.616018e-003f,
   -2.329695e-003f, -1.053051e-003f,  5.460270e-004f,  6.317684e-004f, -3.837893e-004f, -8.592244e-004f, -7.796501e-004f, -1.297462e-003f,
   -1.959568e-003f, -1.362827e-003f, -1.224725e-004f,  1.800419e-004f,  3.322117e-004f,  1.863402e-003f,  3.054561e-003f,  1.277555e-003f,
   -1.601024e-003f, -1.487889e-003f,  9.647293e-004f,  1.332928e-003f, -1.107828e-003f, -2.669715e-003f, -1.686194e-003f, -1.051230e-005f,
    1.455922e-003f,  3.143157e-003f,  3.457657e-003f,  8.038288e-004f, -1.891726e-003f, -6.170158e-004f,  2.655647e-003f,  2.569586e-003f,
   -6.609120e-004f, -1.518135e-003f,  1.629571e-003f,  4.233705e-003f,  3.305360e-003f,  1.336795e-003f,  9.875619e-004f,  1.216230e-003f,
    6.197933e-004f,  1.525897e-004f,  5.907309e-004f,  9.806504e-004f,  1.122968e-003f,  2.125984e-003f,  3.293204e-003f,  2.156375e-003f,
   -1.016503e-003f, -2.496924e-003f, -5.581591e-004f,  1.909515e-003f,  2.042440e-003f,  7.738742e-004f,  5.104530e-005f, -2.866363e-004f,
   -7.736112e-004f, -6.323652e-004f,  2.428979e-004f,  5.654576e-004f,  3.161783e-004f,  9.119007e-004f,  1.786390e-003f,  6.747852e-004f,
   -1.767660e-003f, -2.033690e-003f,  3.956831e-004f,  1.876159e-003f,  5.832409e-004f, -9.325211e-004f, -5.557726e-004f,  4.710716e-004f,
    7.444128e-004f,  7.104593e-004f,  5.232861e-004f, -3.297173e-004f, -9.017912e-004f,  1.031328e-004f,  1.405318e-003f,  9.390441e-004f,
   -3.481569e-004f, -1.664276e-004f,  1.046253e-003f,  1.474152e-003f,  1.549807e-003f,  2.404345e-003f,  2.746149e-003f,  1.181616e-003f,
   -4.381630e-004f,  2.161626e-004f,  1.877699e-003f,  1.907560e-003f,  6.070571e-004f,  4.536519e-005f,  3.859989e-004f,  2.938762e-004f,
   -4.647511e-004f, -1.142815e-003f, -1.504644e-003f, -1.602155e-003f, -1.236252e-003f, -6.605295e-004f, -6.621339e-004f, -1.323868e-003f,
   -1.753989e-003f, -1.336828e-003f, -3.859905e-004f,  4.262250e-004f,  5.598608e-004f, -2.549054e-004f, -1.686712e-003f, -2.697036e-003f,
   -2.257342e-003f, -4.626624e-004f,  1.069153e-003f,  5.497045e-004f, -1.618981e-003f, -2.790149e-003f, -1.583164e-003f, -6.703512e-005f,
   -5.053114e-004f, -1.713280e-003f, -1.449568e-003f, -4.364417e-004f, -4.614436e-004f, -5.705633e-004f,  7.732270e-004f,  1.939854e-003f,
    9.613935e-004f, -2.830037e-004f,  6.272831e-004f,  1.829323e-003f,  5.926026e-004f, -1.264086e-003f, -5.233385e-004f,  1.605035e-003f,
    1.859154e-003f,  5.307132e-004f,  1.059093e-004f,  8.687156e-004f,  1.735970e-003f,  2.720610e-003f,  3.457537e-003f,  2.395237e-003f,
   -1.391321e-004f, -1.544768e-003f, -1.233328e-003f, -1.295359e-003f, -1.913756e-003f, -8.676790e-004f,  1.510862e-003f,  2.001471e-003f,
    8.136854e-005f, -1.163099e-003f, -5.895995e-004f, -5.809534e-004f, -2.102358e-003f, -2.720018e-003f, -8.776339e-004f,  1.440911e-003f,
    1.690446e-003f,  2.446536e-005f, -1.436377e-003f, -1.289260e-003f, -2.144479e-004f,  8.126866e-005f, -7.788932e-004f, -1.257628e-003f,
   -3.384085e-004f,  7.667045e-004f,  6.390420e-004f, -1.293528e-004f, -2.815008e-004f,  1.252633e-004f,  5.046381e-004f,  8.303592e-004f,
    9.181218e-004f,  4.617507e-004f,  2.168477e-004f,  1.011811e-003f,  1.791993e-003f,  1.149679e-003f, -1.669944e-005f, -1.707252e-004f,
   -4.425646e-006f, -5.844485e-004f, -7.494732e-004f,  3.422959e-004f,  7.805176e-004f, -5.272654e-004f, -1.159722e-003f,  3.902089e-004f,
    1.508536e-003f,  3.886067e-004f, -2.921226e-004f,  1.380130e-003f,  2.355996e-003f,  5.857776e-006f, -2.839879e-003f, -2.658771e-003f,
   -9.714340e-004f, -1.098964e-003f, -2.651146e-003f, -3.030369e-003f, -1.774426e-003f, -4.140929e-004f,  1.190608e-004f,  4.420563e-005f,
   -2.699680e-005f,  2.980278e-004f,  4.795787e-004f, -5.343924e-004f, -2.430278e-003f, -3.451471e-003f, -2.798242e-003f, -1.248720e-003f,
    6.214550e-004f,  2.318560e-003f,  2.189141e-003f, -3.329600e-004f, -2.335474e-003f, -1.331480e-003f,  6.496529e-005f, -1.751338e-003f,
   -4.543575e-003f, -3.427918e-003f,  6.895956e-004f,  2.363625e-003f,  4.225720e-004f, -9.166111e-004f,  4.231448e-004f,  1.746594e-003f,
    1.053456e-003f,  3.901167e-005f,  4.669294e-004f,  1.328230e-003f,  9.987488e-004f, -1.827972e-004f, -8.073238e-004f, -6.675613e-004f,
   -9.108630e-004f, -1.956772e-003f, -2.387472e-003f, -1.017877e-003f,  8.041360e-004f,  9.097392e-004f, -3.832896e-004f, -1.136825e-003f,
   -1.084473e-003f, -1.078964e-003f, -4.939446e-004f,  1.260191e-003f,  2.181966e-003f,  5.956903e-004f, -1.321815e-003f, -1.015131e-003f,
    9.108289e-005f, -7.723268e-005f, -1.070933e-004f,  1.195462e-003f,  1.370509e-003f, -5.816650e-004f, -8.058590e-004f,  2.534505e-003f,
    4.735439e-003f,  2.314373e-003f, -8.000971e-004f, -3.114479e-004f,  1.465001e-003f,  9.796113e-004f, -3.942141e-004f, -4.190929e-004f,
   -2.397780e-004f, -7.010736e-004f, -2.775006e-004f,  8.079228e-004f,  4.873204e-004f, -1.078574e-004f,  1.724939e-003f,  3.778532e-003f,
    1.783900e-003f, -2.074649e-003f, -1.875793e-003f,  1.823204e-003f,  3.059682e-003f,  6.508289e-004f, -1.029975e-003f, -2.946180e-004f,
    5.273609e-004f,  6.847264e-004f,  1.282741e-003f,  1.665792e-003f,  9.114749e-004f,  5.161836e-004f,  1.398219e-003f,  1.590652e-003f,
    2.169978e-004f, -4.167305e-004f,  7.398126e-004f,  1.648248e-003f,  1.498873e-003f,  1.782162e-003f,  2.273102e-003f,  1.404777e-003f,
    5.334794e-004f,  2.054368e-003f,  4.187629e-003f,  3.585217e-003f,  1.377290e-003f,  5.879737e-004f,  2.068281e-004f, -1.844389e-003f,
   -3.203506e-003f, -1.200864e-003f,  1.133350e-003f, -5.889128e-005f, -2.345520e-003f, -1.443641e-003f,  9.982134e-004f,  6.888919e-004f,
   -1.665173e-003f, -2.323354e-003f, -1.209302e-003f, -9.186224e-004f, -1.367738e-003f, -4.549341e-004f,  1.531987e-003f,  2.171182e-003f,
    6.593430e-004f, -1.357535e-003f, -2.087637e-003f, -1.244650e-003f,  6.758919e-005f,  4.926253e-004f, -1.880044e-004f, -8.949578e-004f,
   -7.018492e-004f,  1.634203e-004f,  8.840313e-004f,  9.104696e-004f,  4.755196e-004f,  7.214868e-004f,  2.225930e-003f,  3.102623e-003f,
    9.478216e-004f, -2.727132e-003f, -3.531300e-003f, -7.512713e-004f,  1.482066e-003f,  1.013628e-003f,  4.405351e-004f,  1.207291e-003f,
    9.300556e-004f, -1.022144e-003f, -1.610012e-003f,  1.175450e-004f,  1.116827e-003f,  2.203265e-005f, -8.226969e-004f, -3.841694e-004f,
   -5.300497e-004f, -1.545514e-003f, -1.342400e-003f,  9.557333e-005f,  4.442206e-004f, -4.223550e-004f, -3.093476e-004f,  8.781108e-004f,
    1.037449e-003f,  2.861796e-006f, -3.182002e-004f,  3.646914e-004f,  5.274017e-004f, -9.741326e-005f, -3.590992e-004f, -6.798204e-005f,
    1.246492e-005f, -1.203742e-004f, -1.946979e-005f,  2.205669e-005f, -3.301882e-004f, -5.226152e-004f, -1.086639e-004f,  3.378371e-004f,
    2.359260e-004f, -7.478633e-005f, -1.088808e-004f, -5.178403e-006f, -2.017724e-005f, -4.916447e-005f,  1.185109e-005f,  4.456593e-005f,
    7.445898e-006f, -3.306911e-007f,  2.164380e-005f,  2.472080e-006f, -2.729596e-005f, -1.381446e-005f,  8.080400e-006f,  4.900972e-006f
};


static const float MPSVTImpulseLeft2[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  1.239615e-001f, -2.821597e-002f,  3.897466e-002f,  4.196440e-002f,
    2.720637e-002f, -3.424247e-004f, -9.386797e-003f, -2.900561e-003f,  6.959495e-003f,  5.007380e-003f, -1.985216e-003f, -3.863445e-003f,
    2.481827e-003f,  6.961548e-003f,  5.281065e-003f,  2.252970e-003f,  4.789982e-003f,  9.361265e-003f,  9.558144e-003f,  5.142255e-003f,
    2.507807e-003f,  3.319515e-003f,  3.538937e-003f,  2.533817e-004f, -3.309615e-003f, -4.005673e-003f, -2.779764e-003f, -2.340794e-003f,
   -2.435954e-003f, -1.802698e-003f, -6.908391e-004f, -3.930946e-004f, -6.423001e-004f, -6.791037e-004f, -5.435179e-004f, -6.731077e-004f,
   -5.186269e-004f,  2.097992e-004f,  7.663705e-004f,  4.383663e-004f, -3.292604e-005f,  1.300968e-004f,  4.569737e-004f,  1.113345e-004f,
   -4.436098e-004f, -3.656555e-004f,  1.032599e-004f,  5.251318e-005f, -4.452090e-004f, -6.209546e-004f, -3.296050e-004f, -1.871006e-004f,
   -3.525849e-004f, -3.959353e-004f, -1.467574e-004f,  1.144024e-005f, -9.568628e-005f, -2.159092e-004f, -1.631548e-004f, -1.002422e-004f,
   -1.270750e-004f, -1.336439e-004f, -5.350542e-005f, -8.830532e-006f, -5.064427e-005f, -9.453367e-005f, -8.772121e-005f, -9.183859e-005f,
   -1.206835e-004f, -1.234764e-004f, -8.803256e-005f, -6.959054e-005f, -8.006402e-005f, -9.136830e-005f, -9.271026e-005f, -9.682166e-005f,
   -9.179156e-005f, -7.472075e-005f, -6.539290e-005f, -6.906555e-005f, -5.890951e-005f, -4.095899e-005f, -4.941174e-005f, -7.659479e-005f,
   -7.237290e-005f, -4.065257e-005f, -3.488923e-005f, -5.914197e-005f, -5.860974e-005f, -2.947576e-005f, -2.695274e-005f, -5.861166e-005f,
   -6.567648e-005f, -3.561484e-005f, -2.351728e-005f, -4.671085e-005f, -5.381466e-005f, -2.798254e-005f, -1.764072e-005f, -4.137830e-005f,
   -5.203734e-005f, -2.920004e-005f, -1.555873e-005f, -3.299069e-005f, -4.261814e-005f, -2.363930e-005f, -1.182867e-005f, -2.830681e-005f,
   -3.957277e-005f, -2.416920e-005f, -1.164017e-005f, -2.330969e-005f, -3.295084e-005f, -2.066592e-005f, -9.898285e-006f, -1.986152e-005f,
   -2.942013e-005f, -2.016526e-005f, -1.023889e-005f, -1.689151e-005f, -2.433863e-005f, -1.707775e-005f, -9.031818e-006f, -1.448343e-005f,
   -2.104877e-005f, -1.568883e-005f, -9.035000e-006f, -1.277379e-005f, -1.754700e-005f, -1.316539e-005f, -8.019384e-006f, -1.119915e-005f,
   -1.511645e-005f, -1.172771e-005f, -7.732379e-006f, -1.012890e-005f, -1.282046e-005f, -9.836942e-006f, -6.822901e-006f, -8.988321e-006f,
   -1.107707e-005f, -8.585338e-006f, -6.341434e-006f, -8.177680e-006f, -9.537034e-006f, -7.201177e-006f, -5.520089e-006f, -7.270019e-006f,
   -8.295198e-006f, -6.219366e-006f, -4.978564e-006f, -6.585550e-006f, -7.248139e-006f, -5.262926e-006f, -4.292848e-006f, -5.830964e-006f,
   -6.353535e-006f, -4.555266e-006f, -3.800251e-006f, -5.227593e-006f, -5.599561e-006f, -3.910384e-006f, -3.268222e-006f, -4.593895e-006f,
   -4.920977e-006f, -3.408132e-006f, -2.868846e-006f, -4.072884e-006f, -4.342641e-006f, -2.964575e-006f, -2.476586e-006f, -3.556028e-006f,
   -3.810519e-006f, -2.601446e-006f, -2.173328e-006f, -3.127027e-006f, -3.353757e-006f, -2.284379e-006f, -1.891927e-006f, -2.720558e-006f,
   -2.932381e-006f, -2.012605e-006f, -1.667536e-006f, -2.381537e-006f, -2.569256e-006f, -1.774487e-006f, -1.465107e-006f, -2.071085e-006f,
   -2.237387e-006f, -1.563443e-006f, -1.297812e-006f, -1.811153e-006f, -1.951915e-006f, -1.377720e-006f, -1.148191e-006f, -1.578478e-006f,
   -1.694946e-006f, -1.210728e-006f, -1.020085e-006f, -1.382300e-006f, -1.474777e-006f, -1.063868e-006f, -9.053953e-007f, -1.208710e-006f,
   -1.279356e-006f, -9.317721e-007f, -8.044850e-007f, -1.060757e-006f, -1.112330e-006f, -8.161221e-007f, -7.139704e-007f, -9.303113e-007f,
   -9.655970e-007f, -7.128222e-007f, -6.331389e-007f, -8.177777e-007f, -8.401635e-007f, -6.229295e-007f, -5.607408e-007f, -7.184995e-007f,
   -7.306086e-007f, -5.433614e-007f, -4.958345e-007f, -6.319302e-007f, -6.366612e-007f, -4.744705e-007f, -4.379782e-007f, -5.554371e-007f,
   -5.547399e-007f, -4.139481e-007f, -3.862578e-007f, -4.882521e-007f, -4.841185e-007f, -3.616698e-007f, -3.404418e-007f, -4.288695e-007f,
   -4.224759e-007f, -3.159398e-007f, -2.997093e-007f, -3.765489e-007f, -3.690344e-007f, -2.764092e-007f, -2.638287e-007f, -4.686131e-006f,
   -9.686203e-006f,  3.842117e-005f,  5.356807e-005f, -1.748621e-005f, -1.032918e-005f,  9.514760e-005f,  5.446329e-005f, -1.008007e-004f,
   -7.031973e-005f,  4.700015e-005f, -2.971982e-005f, -5.731488e-005f,  1.661439e-004f,  1.185817e-004f, -3.725931e-004f, -4.453791e-004f,
    1.602950e-004f,  3.906251e-004f, -2.158005e-005f,  2.335657e-005f,  4.765007e-004f, -4.351071e-005f, -1.187733e-003f, -1.175573e-003f,
   -4.279042e-004f, -7.216591e-004f, -1.128694e-003f,  2.490395e-004f,  1.605741e-003f,  2.067808e-004f, -1.932635e-003f, -1.371150e-003f,
    3.280686e-004f,  4.581915e-005f, -6.212665e-004f,  5.905257e-004f,  9.852841e-004f, -1.582546e-003f, -3.369429e-003f, -1.978609e-003f,
   -1.744077e-003f, -4.734049e-003f, -5.162873e-003f, -6.232961e-004f,  8.741372e-004f, -5.749805e-003f, -1.279497e-002f, -1.160023e-002f,
   -4.361656e-003f,  1.999727e-003f,  4.875764e-003f,  4.048310e-003f, -5.210455e-004f, -5.322154e-003f, -5.936467e-003f, -4.751090e-003f,
   -7.363426e-003f, -1.129663e-002f, -8.689160e-003f, -3.930556e-004f,  3.999548e-003f,  1.391378e-003f, -9.155650e-004f,  1.294886e-003f,
    2.830346e-003f, -1.675316e-004f, -3.133574e-003f, -1.591354e-003f,  1.438304e-003f,  1.851196e-003f,  1.505514e-003f,  3.206130e-003f,
    4.277001e-003f,  1.341396e-003f, -2.729789e-003f, -2.987473e-003f, -3.398432e-004f,  9.151094e-004f,  7.201267e-004f,  1.840822e-003f,
    3.183330e-003f,  1.594381e-003f, -1.468850e-003f, -2.228872e-003f, -1.761827e-003f, -3.454460e-003f, -5.382466e-003f, -3.414449e-003f,
    1.318977e-004f, -2.389401e-004f, -3.187744e-003f, -3.001581e-003f, -1.821664e-004f, -1.719912e-005f, -2.302795e-003f, -2.168676e-003f,
    3.543101e-004f,  9.922931e-004f, -1.090933e-004f,  6.232606e-004f,  2.270504e-003f,  1.073184e-003f, -1.824673e-003f, -2.212026e-003f,
   -3.849489e-004f,  2.471962e-004f, -2.314424e-004f,  4.959814e-004f,  1.644089e-003f,  9.816323e-004f, -6.651984e-004f, -1.167831e-003f,
   -6.865633e-004f, -1.079047e-004f,  9.754053e-004f,  2.212211e-003f,  1.918555e-003f,  3.490312e-004f, -1.282476e-004f,  8.010196e-004f,
    9.195893e-004f, -2.726172e-004f, -7.757663e-004f,  1.401188e-004f,  1.064034e-003f,  1.358951e-003f,  1.677232e-003f,  1.845849e-003f,
    1.056620e-003f, -2.705333e-004f, -9.496702e-004f, -6.807939e-004f,  8.145785e-005f,  7.884898e-004f,  6.405838e-004f, -6.598533e-004f,
   -1.769436e-003f, -1.228577e-003f,  2.036768e-005f, -1.371203e-004f, -1.561364e-003f, -2.086595e-003f, -9.312185e-004f,  4.269247e-004f,
    6.582136e-004f, -4.132306e-005f, -8.399111e-004f, -1.116043e-003f, -6.324285e-004f,  2.383427e-004f,  7.909498e-004f,  8.060104e-004f,
    5.233372e-004f, -2.056674e-005f, -7.242997e-004f, -9.380038e-004f, -3.534141e-004f,  2.452105e-004f,  2.565243e-004f,  3.598185e-004f,
    1.040685e-003f,  1.188846e-003f, -1.799429e-004f, -1.839850e-003f, -1.838693e-003f, -3.753834e-004f,  5.536700e-004f, -1.598742e-005f,
   -1.078645e-003f, -1.374678e-003f, -7.605391e-004f,  1.504048e-004f,  7.538829e-004f,  7.925949e-004f,  5.837660e-004f,  8.430761e-004f,
    1.745734e-003f,  2.448171e-003f,  2.234392e-003f,  1.752439e-003f,  2.113660e-003f,  3.051633e-003f,  3.253167e-003f,  2.443130e-003f,
    1.693404e-003f,  1.521201e-003f,  1.218764e-003f,  4.278286e-004f, -1.090265e-004f,  1.467918e-004f,  7.521543e-004f,  1.183314e-003f,
    1.405308e-003f,  1.383300e-003f,  1.018642e-003f,  5.391788e-004f,  2.019343e-004f, -4.645038e-005f, -1.478543e-004f,  4.222850e-005f,
    6.855322e-005f, -5.936422e-004f, -1.319350e-003f, -1.122523e-003f, -2.764008e-004f,  5.293330e-004f,  1.563221e-003f,  2.553130e-003f,
    1.751313e-003f, -8.785457e-004f, -2.180988e-003f, -6.401579e-004f,  6.801196e-004f, -4.447293e-004f, -1.313405e-003f,  2.682333e-004f,
    1.477844e-003f,  4.256058e-005f, -1.172818e-003f,  3.121783e-005f,  8.091867e-004f, -5.534079e-004f, -7.881139e-004f,  1.376902e-003f,
    1.777503e-003f, -1.114857e-003f, -2.634887e-003f, -6.873556e-004f,  4.038366e-004f, -1.317546e-003f, -1.779866e-003f,  4.197656e-004f,
    8.634965e-004f, -1.936684e-003f, -3.691156e-003f, -2.720500e-003f, -2.369370e-003f, -3.524193e-003f, -3.378698e-003f, -2.222268e-003f,
   -3.045713e-003f, -4.772769e-003f, -3.898375e-003f, -1.426837e-003f, -5.475080e-004f,  1.163130e-004f,  3.471270e-003f,  7.125571e-003f,
    6.534903e-003f,  2.111506e-003f, -2.133148e-003f, -3.669742e-003f, -1.781794e-003f,  2.498716e-003f,  4.723182e-003f,  1.200947e-003f,
   -4.140485e-003f, -4.051780e-003f,  7.277675e-004f,  2.544491e-003f, -8.686171e-004f, -3.868769e-003f, -2.875979e-003f, -5.227172e-004f,
    5.190747e-004f,  6.587798e-004f,  3.256499e-004f, -5.225564e-004f, -6.928029e-004f,  2.723326e-004f,  5.677666e-004f, -4.787721e-004f,
   -1.003711e-003f, -6.674133e-004f, -1.376302e-003f, -2.490381e-003f, -1.035648e-003f,  2.118727e-003f,  2.496232e-003f, -5.812774e-004f,
   -2.918093e-003f, -2.379189e-003f, -1.161992e-003f, -9.349794e-004f, -8.006034e-004f, -2.424101e-005f,  1.008305e-003f,  1.762861e-003f,
    1.295961e-003f, -7.955247e-004f, -2.201562e-003f, -3.619565e-004f,  2.751435e-003f,  3.207355e-003f,  1.814210e-003f,  2.200711e-003f,
    3.467700e-003f,  1.862206e-003f, -1.633317e-003f, -2.884516e-003f, -2.075826e-003f, -2.181278e-003f, -2.359963e-003f, -3.361700e-004f,
    1.617958e-003f,  4.841883e-004f, -1.198410e-003f,  8.814519e-005f,  2.071985e-003f,  1.282028e-003f, -3.381652e-004f,  4.122544e-005f,
    2.904272e-004f, -1.582846e-003f, -2.201949e-003f,  8.825561e-004f,  3.476848e-003f,  1.710191e-003f, -1.092893e-003f, -9.487438e-004f,
   -8.227646e-004f, -4.568318e-003f, -8.215014e-003f, -5.218639e-003f,  2.640021e-003f,  7.385076e-003f,  6.621220e-003f,  5.680473e-003f,
    7.385192e-003f,  7.134639e-003f,  1.657473e-003f, -3.814141e-003f, -3.388902e-003f, -8.012691e-004f, -3.293300e-003f, -8.230632e-003f,
   -6.899152e-003f, -9.260423e-004f, -1.334888e-003f, -8.719902e-003f, -9.657673e-003f,  8.532990e-004f,  9.299005e-003f,  5.823650e-003f,
    6.144385e-004f,  4.725229e-003f,  9.745493e-003f,  3.882192e-003f, -4.758355e-003f, -1.433916e-003f,  8.317810e-003f,  7.069295e-003f,
   -4.908120e-003f, -1.023128e-002f, -2.189654e-003f,  8.058246e-003f,  1.136421e-002f,  9.550998e-003f,  4.733489e-003f, -3.412893e-003f,
   -9.472054e-003f, -6.712866e-003f,  3.204690e-004f,  1.237213e-003f, -3.883897e-003f, -6.745505e-003f, -5.814538e-003f, -5.209683e-003f,
   -3.383700e-003f,  2.297603e-003f,  5.186920e-003f, -8.091941e-004f, -7.232453e-003f, -3.378758e-003f,  4.382079e-003f,  3.303113e-003f,
   -3.127247e-003f, -2.476755e-003f,  3.776361e-003f,  4.986675e-003f,  2.732179e-003f,  6.638981e-003f,  1.380849e-002f,  1.282415e-002f,
    4.454343e-003f, -5.691217e-004f, -6.772707e-004f, -2.825654e-003f, -6.818642e-003f, -6.677104e-003f, -3.617040e-003f, -3.069249e-003f,
   -3.372369e-003f, -2.577653e-004f,  3.023825e-003f,  1.572236e-003f, -1.480667e-003f, -1.157226e-003f,  4.786591e-004f, -2.419284e-005f,
   -7.444220e-004f, -8.978073e-005f, -7.308424e-004f, -2.608507e-003f, -1.402608e-003f,  2.145065e-003f,  1.632261e-003f, -3.352524e-003f,
   -5.652255e-003f, -2.706454e-003f,  3.251929e-004f,  6.487850e-004f,  6.052283e-004f,  4.117948e-004f, -1.688422e-003f, -3.128153e-003f,
   -5.825019e-004f,  2.467217e-003f,  1.059173e-003f, -1.875976e-003f, -7.101592e-004f,  2.604252e-003f,  2.649338e-003f,  4.863903e-004f,
    7.356742e-004f,  2.938124e-003f,  3.503706e-003f,  2.224365e-003f,  7.720640e-004f, -9.265537e-004f, -2.359045e-003f, -1.541402e-003f,
    4.451606e-004f, -4.885046e-005f, -2.210870e-003f, -1.230087e-003f,  2.675249e-003f,  3.594081e-003f,  1.088702e-006f, -2.598018e-003f,
   -1.002446e-003f,  1.531343e-003f,  2.292244e-003f,  2.717743e-003f,  3.260770e-003f,  1.844717e-003f, -9.631515e-004f, -1.963859e-003f,
   -1.484277e-003f, -2.575924e-003f, -3.619671e-003f,  5.728306e-005f,  5.987164e-003f,  5.406151e-003f, -2.603980e-003f, -7.558554e-003f,
   -3.412724e-003f,  1.644781e-003f, -9.961439e-004f, -5.699547e-003f, -2.590535e-003f,  4.560520e-003f,  3.914183e-003f, -4.243814e-003f,
   -7.266927e-003f, -4.974034e-004f,  5.907228e-003f,  3.825016e-003f, -1.413219e-003f, -1.936439e-003f,  5.523408e-004f,  4.778533e-004f,
   -1.444931e-003f, -1.090309e-003f,  9.395009e-004f,  6.986094e-004f, -2.110975e-003f, -3.642817e-003f, -1.552006e-003f,  2.008689e-003f,
    3.083764e-003f,  4.445984e-004f, -2.838365e-003f, -2.903024e-003f, -1.100656e-004f,  1.463872e-003f,  1.352532e-004f, -8.690783e-004f,
    1.183991e-003f,  3.783535e-003f,  2.841525e-003f, -1.068758e-003f, -3.530285e-003f, -2.458859e-003f, -4.219495e-004f, -4.858329e-004f,
   -2.074839e-003f, -2.375624e-003f, -6.547425e-004f,  9.488058e-004f,  8.937657e-004f,  6.155505e-005f, -6.501490e-004f, -1.785035e-003f,
   -3.012575e-003f, -2.555002e-003f, -7.748838e-004f, -6.643573e-004f, -2.681287e-003f, -3.554807e-003f, -2.506398e-003f, -2.984894e-003f,
   -5.299453e-003f, -4.430849e-003f,  7.602440e-004f,  3.753325e-003f,  9.625465e-004f, -1.843271e-003f,  1.664430e-004f,  2.417340e-003f,
    4.109499e-005f, -2.651679e-003f, -3.437076e-004f,  2.875803e-003f,  6.433307e-004f, -3.977355e-003f, -3.499980e-003f,  1.516698e-003f,
    4.081473e-003f,  2.074977e-003f, -1.419808e-004f,  1.787887e-004f,  1.314955e-003f,  1.672724e-003f,  1.927028e-003f,  2.605406e-003f,
    3.161073e-003f,  3.416419e-003f,  3.676425e-003f,  3.774024e-003f,  3.390105e-003f,  2.696152e-003f,  1.886330e-003f,  8.803108e-004f,
   -7.552920e-005f, -3.885220e-004f, -1.975307e-005f,  2.424697e-004f, -3.689265e-004f, -1.641058e-003f, -2.251490e-003f, -1.044046e-003f,
    1.059712e-003f,  1.408662e-003f, -9.118379e-004f, -3.214858e-003f, -2.703038e-003f, -4.847984e-004f,  4.207234e-004f, -2.074424e-004f,
   -2.524898e-004f,  5.269167e-004f,  3.509406e-004f, -8.669011e-004f, -1.141284e-003f,  2.574542e-004f,  2.052642e-003f,  3.127859e-003f,
    2.667887e-003f, -5.782487e-004f, -5.682777e-003f, -7.893767e-003f, -4.140278e-003f,  1.302687e-003f,  1.907447e-003f, -1.602221e-003f,
   -2.858988e-003f, -1.608620e-004f,  1.620041e-003f, -3.296357e-004f, -2.950886e-003f, -3.154948e-003f, -1.589761e-003f,  1.243701e-004f,
    5.872818e-004f, -2.383010e-003f, -7.982846e-003f, -9.310286e-003f, -1.603125e-003f,  8.054260e-003f,  8.318690e-003f, -7.119522e-005f,
   -5.573426e-003f, -3.335434e-003f, -4.761663e-004f, -2.501494e-003f, -5.476530e-003f, -4.958014e-003f, -2.973149e-003f, -2.106126e-003f,
   -8.776534e-004f,  1.097614e-003f,  5.444608e-004f, -3.206994e-003f, -5.627225e-003f, -3.998590e-003f, -1.571481e-003f, -1.648787e-003f,
   -2.320854e-003f, -3.465445e-004f,  3.238294e-003f,  4.513027e-003f,  1.904960e-003f, -1.989908e-003f, -3.225163e-003f, -5.421830e-004f,
    3.223503e-003f,  4.237035e-003f,  2.133346e-003f, -4.197678e-005f, -3.781283e-004f, -2.020662e-004f, -9.222510e-004f, -1.449052e-003f,
   -4.028103e-004f,  1.191492e-003f,  1.415925e-003f,  3.664395e-004f, -3.369820e-004f, -2.198149e-004f, -3.861650e-004f, -1.409652e-003f,
   -2.206058e-003f, -1.374505e-003f,  1.106715e-003f,  3.733370e-003f,  4.569293e-003f,  2.807740e-003f, -4.887925e-005f, -1.320852e-003f,
   -5.831081e-004f, -5.013053e-004f, -2.176220e-003f, -2.025737e-003f,  2.534728e-003f,  6.595946e-003f,  3.443507e-003f, -4.227572e-003f,
   -6.671477e-003f, -1.105910e-003f,  5.133273e-003f,  6.669882e-003f,  5.952999e-003f,  4.938189e-003f,  1.202210e-003f, -4.031726e-003f,
   -4.312271e-003f,  8.375456e-004f,  2.907941e-003f, -2.174937e-003f, -6.964886e-003f, -4.549555e-003f,  8.698972e-004f,  1.493585e-003f,
   -2.998851e-003f, -7.214877e-003f, -7.349746e-003f, -3.069742e-003f,  3.012420e-003f,  5.897872e-003f,  3.061866e-003f, -1.053641e-003f,
   -5.674794e-004f,  3.029798e-003f,  3.545399e-003f, -2.245724e-004f, -3.916060e-003f, -4.866465e-003f, -3.760474e-003f, -1.146278e-003f,
    1.911769e-003f,  2.268866e-003f, -9.137419e-004f, -3.303703e-003f, -1.672508e-003f,  8.196844e-004f,  1.926804e-004f, -1.964018e-003f,
   -2.385276e-003f, -1.839184e-003f, -2.189739e-003f, -2.078871e-003f, -7.246203e-005f,  1.766619e-003f,  1.388686e-003f,  2.888833e-004f,
    4.025216e-004f,  9.358117e-004f,  6.646212e-004f, -6.092913e-005f, -1.134585e-003f, -2.788713e-003f, -3.144332e-003f, -1.254466e-004f,
    3.715190e-003f,  3.518556e-003f, -6.016079e-005f, -1.179304e-003f,  1.885953e-003f,  4.071124e-003f,  2.177111e-003f, -1.910017e-004f,
    5.894822e-004f,  2.341706e-003f,  1.902801e-003f,  6.334664e-004f,  9.321841e-004f,  1.541056e-003f,  4.191375e-004f, -1.338078e-003f,
   -2.001791e-003f, -2.159660e-003f, -2.274684e-003f, -1.124167e-003f,  8.549122e-004f,  1.029598e-003f, -4.652336e-004f, -3.176528e-004f,
    1.468139e-003f,  8.046142e-004f, -2.533939e-003f, -3.240007e-003f,  3.611158e-004f,  2.908350e-003f,  1.225287e-003f, -6.158730e-004f,
    6.625811e-004f,  1.948823e-003f,  4.690368e-004f, -1.000087e-003f, -4.560731e-005f,  7.143351e-004f, -1.024914e-003f, -3.085657e-003f,
   -3.506161e-003f, -3.989602e-003f, -5.607644e-003f, -5.922611e-003f, -3.062601e-003f,  1.147150e-003f,  3.855835e-003f,  4.148107e-003f,
    2.911759e-003f,  1.992968e-003f,  2.766665e-003f,  3.982969e-003f,  3.077116e-003f,  6.809895e-004f,  2.955644e-004f,  2.361595e-003f,
    3.257733e-003f,  1.573442e-003f,  2.146274e-004f,  6.465701e-004f,  3.418653e-004f, -2.183356e-003f, -4.591120e-003f, -4.650035e-003f,
   -3.078580e-003f, -1.648781e-003f, -1.482104e-003f, -2.805796e-003f, -3.940643e-003f, -2.318208e-003f,  1.372716e-003f,  3.168872e-003f,
    1.878392e-003f,  7.957907e-004f,  1.541056e-003f,  1.706659e-003f,  7.046997e-004f,  1.638633e-003f,  4.906707e-003f,  6.385820e-003f,
    4.370883e-003f,  1.955732e-003f,  6.749048e-004f, -1.512730e-003f, -4.296927e-003f, -4.012614e-003f, -3.143153e-004f,  2.564243e-003f,
    2.608629e-003f,  2.106789e-003f,  2.127865e-003f,  8.956454e-004f, -1.411540e-003f, -1.714046e-003f,  9.272108e-004f,  3.563332e-003f,
    3.508494e-003f,  1.203828e-003f, -1.180401e-003f, -1.785992e-003f, -3.077051e-004f,  1.221975e-003f,  2.369153e-004f, -2.544205e-003f,
   -3.277509e-003f, -4.966010e-004f,  2.124815e-003f,  8.658039e-004f, -2.326410e-003f, -2.419693e-003f,  1.254063e-003f,  3.713860e-003f,
    1.419212e-003f, -2.589939e-003f, -3.281218e-003f, -9.698283e-004f,  1.417048e-005f, -1.190605e-003f, -9.745558e-004f,  1.859776e-003f,
    3.501826e-003f,  1.203065e-003f, -2.458604e-003f, -3.451644e-003f, -1.093981e-003f,  2.303268e-003f,  3.834520e-003f,  1.984335e-003f,
   -1.200603e-003f, -1.368692e-003f,  1.931114e-003f,  3.491170e-003f,  4.698018e-004f, -2.555232e-003f, -1.388987e-003f,  6.685071e-004f,
   -3.035777e-004f, -1.046782e-003f,  2.394363e-003f,  6.296962e-003f,  5.262449e-003f,  1.225397e-003f, -9.063713e-004f, -1.140249e-003f,
   -1.331572e-003f, -4.244384e-004f,  1.135862e-003f, -6.545056e-004f, -5.062207e-003f, -4.360186e-003f,  3.750726e-003f,  9.981126e-003f,
    6.716661e-003f, -8.132120e-004f, -3.926441e-003f, -3.174520e-003f, -3.833185e-003f, -5.519518e-003f, -4.491575e-003f, -1.577080e-003f,
   -5.160234e-004f, -1.372354e-003f, -1.313664e-003f,  4.860354e-005f,  5.159166e-004f, -6.431552e-004f, -1.706927e-003f, -1.302470e-003f,
   -2.342815e-004f, -6.273152e-005f, -6.542372e-004f, -2.242062e-004f,  1.853598e-003f,  3.738593e-003f,  3.796183e-003f,  2.829731e-003f,
    1.937105e-003f,  3.541869e-004f, -2.236522e-003f, -3.696914e-003f, -2.559105e-003f, -8.537559e-004f, -1.036834e-003f, -2.321685e-003f,
   -2.514423e-003f, -1.325359e-003f, -9.457859e-006f,  2.187659e-004f, -1.374719e-003f, -3.988583e-003f, -5.222663e-003f, -4.633994e-003f,
   -5.183662e-003f, -7.691627e-003f, -7.629034e-003f, -2.456651e-003f,  2.426620e-003f,  1.504075e-003f, -1.906171e-003f, -1.760250e-003f,
    7.531809e-004f,  1.181913e-003f,  3.554647e-004f,  7.907422e-004f,  2.187095e-004f, -3.037357e-003f, -4.337450e-003f, -6.574981e-004f,
    2.457633e-003f,  1.845727e-004f, -2.738322e-003f, -1.041960e-003f,  1.176303e-003f, -1.226357e-003f, -4.097574e-003f, -1.498056e-003f,
    3.697784e-003f,  5.777677e-003f,  5.770805e-003f,  6.519546e-003f,  5.225149e-003f, -4.687848e-004f, -5.225005e-003f, -3.196883e-003f,
    2.438999e-003f,  4.256903e-003f,  9.694935e-004f, -2.632687e-003f, -2.983802e-003f, -7.378114e-004f,  1.384088e-003f,  1.377239e-003f,
   -1.210218e-004f, -7.087684e-004f, -1.453042e-005f, -7.720345e-005f, -5.868787e-004f,  1.385266e-003f,  4.534775e-003f,  2.819295e-003f,
   -4.303615e-003f, -8.418740e-003f, -4.119920e-003f,  2.650009e-003f,  3.984043e-003f,  1.013718e-003f, -5.197625e-004f,  3.357898e-004f,
    8.285553e-004f,  2.861952e-004f, -2.043127e-004f, -3.599986e-004f,  1.312024e-004f,  1.700230e-003f,  2.961462e-003f,  2.340949e-003f,
    1.312540e-003f,  1.745610e-003f,  1.502930e-003f, -2.108564e-003f, -6.221919e-003f, -5.532469e-003f, -3.979557e-004f,  3.378819e-003f,
    2.106871e-003f, -2.319047e-003f, -5.475292e-003f, -4.394358e-003f,  1.213611e-005f,  3.296015e-003f,  2.259641e-003f, -8.965053e-004f,
   -2.128821e-003f, -1.569329e-003f, -1.749580e-003f, -2.162233e-003f, -9.553093e-004f,  3.216974e-004f, -6.315362e-004f, -1.916323e-003f,
   -6.675904e-004f,  1.532696e-003f,  1.721219e-003f,  9.192998e-004f,  1.556555e-003f,  2.804468e-003f,  2.692525e-003f,  1.551391e-003f,
    2.774159e-004f, -1.122971e-003f, -1.402469e-003f,  1.099926e-003f,  4.439935e-003f,  4.625596e-003f,  1.539632e-003f, -1.233424e-003f,
   -1.648392e-003f,  2.314758e-005f,  3.228541e-003f,  5.631801e-003f,  3.556669e-003f, -1.650924e-003f, -3.258847e-003f,  2.228781e-004f,
    1.341655e-003f, -3.839022e-003f, -8.008459e-003f, -4.264566e-003f,  2.663614e-003f,  4.412580e-003f,  9.939161e-004f, -2.320001e-003f,
   -3.687342e-003f, -3.986943e-003f, -3.036162e-003f, -1.500977e-003f, -1.704865e-003f, -3.391576e-003f, -3.420823e-003f, -1.125256e-003f,
    9.426690e-004f,  1.717008e-003f,  2.042440e-003f,  1.351884e-003f, -1.073114e-003f, -3.207478e-003f, -3.130975e-003f, -2.182163e-003f,
   -1.582084e-003f,  5.390821e-005f,  2.374726e-003f,  1.767478e-003f, -2.138976e-003f, -4.288029e-003f, -2.163012e-003f,  2.231865e-004f,
   -2.778162e-004f, -1.139088e-003f, -2.346615e-004f, -8.768916e-005f, -2.249159e-003f, -3.440522e-003f, -1.076617e-003f,  2.318799e-003f,
    3.272039e-003f,  1.771097e-003f, -4.430873e-004f, -1.979557e-003f, -1.062148e-003f,  2.958149e-003f,  6.417698e-003f,  4.385403e-003f,
   -1.833122e-003f, -5.224117e-003f, -3.058908e-003f, -9.208257e-004f, -3.254116e-003f, -5.592681e-003f, -2.426812e-003f,  1.922896e-003f,
   -4.364071e-004f, -6.195161e-003f, -4.148588e-003f,  5.559002e-003f,  8.830925e-003f, -3.877885e-004f, -8.869551e-003f, -4.316818e-003f,
    5.135925e-003f,  4.565884e-003f, -3.911857e-003f, -6.340850e-003f, -3.403059e-004f,  2.825749e-003f, -1.896475e-003f, -6.356283e-003f,
   -3.980113e-003f,  7.523347e-004f,  1.676099e-003f,  5.829523e-004f,  2.270989e-003f,  5.837469e-003f,  6.327263e-003f,  2.416181e-003f,
   -2.032972e-003f, -3.605269e-003f, -3.039402e-003f, -2.360566e-003f, -1.291732e-003f,  9.438523e-004f,  2.377429e-003f,  5.946020e-004f,
   -2.678425e-003f, -3.262543e-003f, -4.899887e-004f,  2.333670e-003f,  3.220170e-003f,  3.459078e-003f,  4.232151e-003f,  4.617164e-003f,
    3.392825e-003f,  9.084611e-004f, -7.748331e-004f,  5.930469e-004f,  4.184355e-003f,  5.295257e-003f,  1.223124e-003f, -3.594790e-003f,
   -3.303279e-003f,  4.815659e-004f,  1.880580e-003f,  4.882312e-004f,  1.863682e-004f,  7.322372e-004f, -6.643336e-004f, -1.775280e-003f,
    1.212209e-003f,  4.997266e-003f,  3.469331e-003f, -1.571653e-003f, -3.316917e-003f, -1.093381e-003f,  3.114762e-004f, -1.791983e-004f,
    2.543962e-004f,  1.906883e-003f,  2.907393e-003f,  3.169982e-003f,  2.839471e-003f,  6.752553e-004f, -2.262172e-003f, -2.357619e-003f,
    3.595323e-004f,  1.637844e-003f,  4.279573e-004f,  3.092208e-004f,  2.430579e-003f,  3.895269e-003f,  3.583825e-003f,  2.977462e-003f,
    1.842957e-003f, -5.973456e-004f, -2.015152e-003f, -4.425472e-004f,  1.522784e-003f,  1.308054e-003f,  9.825870e-004f,  2.485124e-003f,
    3.593440e-003f,  2.966281e-003f,  2.894779e-003f,  3.415239e-003f,  1.070075e-003f, -3.332956e-003f, -3.999725e-003f, -1.665542e-005f,
    2.703615e-003f,  1.571250e-003f,  3.493503e-004f,  3.609444e-004f, -1.671779e-003f, -5.202095e-003f, -4.959496e-003f, -6.959221e-004f,
    1.094768e-003f, -2.364310e-003f, -5.732709e-003f, -4.130338e-003f,  1.725612e-004f,  2.116418e-003f,  4.827966e-004f, -1.891914e-003f,
   -2.077773e-003f,  3.714199e-005f,  2.140323e-003f,  2.541973e-003f,  1.940829e-003f,  1.284281e-003f, -1.598438e-005f, -1.673586e-003f,
   -1.207222e-003f,  1.852513e-003f,  3.575461e-003f,  1.269683e-003f, -1.624793e-003f, -5.190807e-004f,  3.283584e-003f,  4.883122e-003f,
    2.919697e-003f,  4.762233e-004f,  3.014820e-004f,  2.088398e-003f,  3.618405e-003f,  3.084528e-003f,  1.121498e-003f,  5.563287e-004f,
    2.688446e-003f,  4.762349e-003f,  3.498195e-003f,  6.641646e-005f, -1.398110e-003f,  3.582390e-004f,  2.322525e-003f,  1.885298e-003f,
    4.730684e-004f,  1.188344e-003f,  3.758524e-003f,  4.025160e-003f, -8.425840e-005f, -4.119556e-003f, -2.508308e-003f,  2.603136e-003f,
    3.664168e-003f, -6.413350e-004f, -3.145347e-003f,  1.217139e-004f,  3.558381e-003f,  1.421839e-003f, -3.329544e-003f, -4.779069e-003f,
   -2.729802e-003f, -3.715983e-004f,  1.636881e-003f,  3.710082e-003f,  4.282656e-003f,  2.613243e-003f,  8.707498e-004f,  1.530644e-004f,
   -1.424790e-003f, -3.921167e-003f, -3.699754e-003f,  3.846354e-004f,  3.642122e-003f,  2.126110e-003f, -1.477211e-003f, -2.368735e-003f,
   -6.305127e-004f,  2.478448e-004f, -7.631582e-004f, -1.697780e-003f, -1.277006e-003f,  6.470931e-005f,  1.559644e-003f,  2.098077e-003f,
    5.124720e-004f, -1.941615e-003f, -1.769179e-003f,  1.513145e-003f,  3.343859e-003f,  7.769697e-004f, -2.335899e-003f, -1.486858e-003f,
    8.420583e-004f, -1.756433e-004f, -2.703079e-003f, -1.402534e-003f,  2.696506e-003f,  3.729306e-003f,  1.111727e-003f, -2.024518e-004f,
    1.067257e-003f,  1.296631e-003f, -2.566499e-004f, -4.113861e-004f,  1.025523e-003f,  7.165085e-004f, -1.571526e-003f, -2.430555e-003f,
   -9.415930e-004f,  5.152679e-004f,  1.114125e-003f,  1.985571e-003f,  2.649412e-003f,  1.692462e-003f, -1.081678e-004f, -9.878814e-004f,
   -8.708461e-004f, -2.851209e-004f,  8.084413e-004f,  1.254945e-003f, -6.970908e-004f, -3.552499e-003f, -3.540690e-003f, -6.761568e-004f,
    8.635449e-004f, -4.878844e-004f, -1.646446e-003f, -8.041032e-004f, -1.238536e-004f, -9.448973e-004f, -1.247785e-003f,  1.404398e-004f,
    1.053805e-003f, -1.145476e-004f, -1.371343e-003f, -3.334840e-004f,  1.813945e-003f,  2.009890e-003f, -1.521260e-004f, -1.960289e-003f,
   -1.644486e-003f, -6.328151e-004f, -7.349617e-004f, -1.253457e-003f, -9.087718e-004f, -6.639424e-004f, -1.870725e-003f, -3.291482e-003f,
   -2.962767e-003f, -1.305878e-003f,  4.885797e-004f,  2.811769e-003f,  5.390571e-003f,  5.792752e-003f,  3.393916e-003f,  1.223492e-003f,
    8.123090e-004f, -2.934922e-004f, -2.912496e-003f, -3.699471e-003f, -1.532950e-003f, -3.342756e-004f, -2.095464e-003f, -3.394126e-003f,
   -1.996910e-003f, -4.539639e-004f, -4.549142e-004f, -1.889179e-004f,  6.924287e-004f,  9.421850e-005f, -1.490986e-003f, -1.633216e-003f,
   -1.513614e-003f, -3.727777e-003f, -5.615660e-003f, -2.626527e-003f,  2.836364e-003f,  3.998853e-003f,  2.478384e-004f, -2.504716e-003f,
   -1.341453e-003f,  5.511282e-004f,  9.752628e-005f, -1.690903e-003f, -2.168525e-003f, -3.115021e-004f,  2.385042e-003f,  3.250694e-003f,
    1.598502e-003f, -1.189325e-004f, -1.062148e-005f,  4.343511e-004f, -3.878592e-004f, -1.182830e-003f, -8.037217e-004f, -5.201332e-004f,
   -5.703028e-004f,  9.247360e-004f,  3.247854e-003f,  2.831760e-003f, -2.553410e-004f, -1.866152e-003f, -1.277379e-003f, -1.897814e-003f,
   -3.420535e-003f, -1.597313e-003f,  2.788820e-003f,  3.506235e-003f, -6.369903e-004f, -3.309211e-003f, -1.007658e-003f,  1.710981e-003f,
    1.257041e-004f, -3.690729e-003f, -4.830730e-003f, -2.387094e-003f,  3.555009e-004f,  6.895816e-004f, -5.054527e-004f, -7.959442e-004f,
   -2.553359e-004f, -1.128164e-003f, -3.031887e-003f, -2.404660e-003f,  1.400740e-003f,  4.103354e-003f,  3.214149e-003f,  1.677307e-003f,
    1.964505e-003f,  2.161961e-003f,  8.407616e-004f, -7.668590e-006f,  5.668812e-004f,  8.469792e-004f,  7.690294e-004f,  1.902313e-003f,
    2.844990e-003f,  1.040998e-003f, -1.539750e-003f, -1.182701e-003f,  7.615599e-004f,  5.408092e-004f, -9.357929e-004f, -2.111921e-004f,
    2.322489e-003f,  3.769608e-003f,  3.317809e-003f,  1.478029e-003f, -1.179725e-003f, -2.230515e-003f,  3.700386e-004f,  3.462364e-003f,
    2.499959e-003f, -5.090330e-004f, -3.818075e-004f,  1.892232e-003f,  1.686406e-003f, -1.393720e-004f,  3.986000e-004f,  2.119778e-003f,
    1.342569e-003f, -8.129521e-004f, -1.267157e-003f, -7.569970e-004f, -8.250400e-004f, -3.468748e-004f,  7.063901e-004f,  2.627118e-004f,
   -8.526726e-004f, -2.796437e-005f,  1.020867e-003f, -6.722419e-004f, -2.335326e-003f, -4.914444e-004f,  1.286408e-003f, -9.236154e-004f,
   -3.264825e-003f, -2.106392e-003f, -1.525083e-003f, -3.557887e-003f, -2.224920e-003f,  3.472945e-003f,  4.224413e-003f, -2.557788e-003f,
   -5.831789e-003f, -2.953494e-004f,  4.207501e-003f,  1.508995e-003f, -5.992128e-004f,  2.639233e-003f,  4.033681e-003f,  3.392158e-004f,
   -9.826728e-004f,  2.544869e-003f,  3.344199e-003f, -7.880270e-004f, -2.844137e-003f, -1.058440e-003f, -1.230607e-003f, -3.511986e-003f,
   -2.006339e-003f,  2.650351e-003f,  3.970440e-003f,  1.367593e-003f, -3.835220e-004f, -3.517269e-004f, -4.794111e-004f,  1.075071e-004f,
    2.133596e-003f,  2.875753e-003f,  1.147016e-003f, -5.051466e-004f, -1.187403e-003f, -2.206306e-003f, -2.087175e-003f,  9.592066e-004f,
    3.316592e-003f,  1.073000e-003f, -2.483634e-003f, -2.577497e-003f, -1.101349e-003f, -1.345560e-003f, -1.109279e-003f,  1.563463e-003f,
    2.986647e-003f,  5.926057e-004f, -2.219985e-003f, -2.544428e-003f, -1.793397e-003f, -8.618397e-004f,  6.866012e-004f,  7.108334e-004f,
   -2.133664e-003f, -3.565467e-003f, -4.324685e-004f,  2.499692e-003f,  8.622615e-004f, -1.123849e-003f,  6.725447e-004f,  1.881868e-003f,
   -1.391859e-003f, -4.257992e-003f, -1.920997e-003f,  2.063369e-003f,  3.104311e-003f,  2.391470e-003f,  1.844628e-003f,  8.652604e-004f,
    3.029068e-004f,  1.461667e-003f,  1.878216e-003f, -3.655230e-005f, -1.705069e-004f,  3.423835e-003f,  4.831948e-003f,  8.810342e-004f,
   -1.852090e-003f,  8.385151e-004f,  2.836649e-003f,  2.156917e-004f, -9.984786e-004f,  2.403333e-003f,  3.925534e-003f,  6.150111e-004f,
   -8.476241e-004f,  2.479310e-003f,  4.484014e-003f,  2.709968e-003f,  2.193421e-003f,  3.640329e-003f,  1.949787e-003f, -1.991747e-003f,
   -1.920509e-003f,  1.281010e-003f,  8.759653e-004f, -2.964489e-003f, -3.866266e-003f, -7.560044e-004f,  1.898041e-003f,  2.408649e-003f,
    1.869073e-003f, -1.465519e-005f, -2.398124e-003f, -1.816376e-003f,  1.859711e-003f,  3.912494e-003f,  2.275241e-003f,  6.041814e-005f,
   -7.020954e-004f, -1.002798e-003f, -6.605825e-004f,  1.079555e-003f,  2.141702e-003f,  8.146301e-004f, -4.738604e-004f,  3.134919e-004f,
    8.107134e-004f, -9.158428e-004f, -2.797632e-003f, -3.283076e-003f, -3.529620e-003f, -3.300501e-003f, -1.132255e-003f,  1.147595e-003f,
    7.965023e-004f, -4.096084e-004f,  1.472215e-004f,  3.103735e-004f, -1.857329e-003f, -2.813876e-003f, -4.456087e-004f,  5.778213e-004f,
   -2.444225e-003f, -4.104556e-003f, -5.899220e-004f,  3.095708e-003f,  2.211344e-003f, -2.527563e-004f, -7.453663e-004f, -8.212990e-004f,
   -1.397213e-003f, -3.098958e-004f,  1.654110e-003f,  1.055847e-003f, -9.653444e-004f, -4.162148e-004f,  1.547035e-003f,  1.042760e-003f,
   -5.689850e-004f,  2.414072e-004f,  1.699631e-003f,  4.784560e-004f, -1.466357e-003f, -9.890069e-004f,  4.962774e-004f,  1.104715e-003f,
    2.074383e-003f,  2.990741e-003f,  9.236191e-004f, -2.556955e-003f, -2.103189e-003f,  1.547163e-003f,  1.908780e-003f, -1.715042e-003f,
   -3.198504e-003f, -9.820308e-004f, -9.121621e-006f, -1.490747e-003f, -1.023783e-003f,  2.076012e-003f,  2.915393e-003f, -3.259988e-004f,
   -3.502195e-003f, -3.067697e-003f,  1.248121e-004f,  3.469447e-003f,  4.914503e-003f,  3.556682e-003f,  7.122970e-004f, -1.007504e-003f,
   -8.417519e-004f, -3.053391e-005f,  8.027379e-004f,  1.479330e-003f,  8.189112e-004f, -1.236054e-003f, -2.217934e-003f, -1.276632e-003f,
   -1.394231e-003f, -3.784607e-003f, -4.530582e-003f, -1.187919e-003f,  2.162156e-003f,  1.432982e-003f, -7.462009e-004f, -1.304011e-004f,
    1.792179e-003f,  1.044722e-003f, -1.830080e-003f, -3.167594e-003f, -2.033151e-003f, -4.199663e-004f,  5.003213e-004f,  9.496277e-004f,
    7.498653e-004f, -4.320462e-004f, -1.811378e-003f, -2.138204e-003f, -1.238683e-003f, -7.935936e-005f,  4.172435e-004f,  2.333803e-004f,
    2.702932e-006f,  2.140807e-005f, -1.351985e-004f, -7.063206e-004f, -1.058256e-003f, -6.373631e-004f, -3.539418e-005f, -1.410961e-004f,
   -6.559603e-004f, -4.988658e-004f,  4.856335e-004f,  1.249570e-003f,  1.199166e-003f,  1.227663e-003f,  2.219402e-003f,  3.028263e-003f,
    1.614657e-003f, -1.430475e-003f, -2.635019e-003f, -3.051106e-004f,  2.698338e-003f,  2.885966e-003f,  7.911671e-004f, -6.801055e-004f,
   -4.976456e-004f,  4.092984e-004f,  1.282906e-003f,  1.470760e-003f,  4.161096e-004f, -6.436076e-004f,  1.680736e-004f,  1.538123e-003f,
    3.861594e-004f, -2.140722e-003f, -1.588299e-003f,  1.813603e-003f,  2.680853e-003f, -2.839234e-004f, -1.871760e-003f,  3.214286e-004f,
    1.729551e-003f, -6.893854e-004f, -3.057934e-003f, -1.722288e-003f,  6.412588e-004f,  4.042026e-004f, -8.549438e-004f,  1.363422e-004f,
    2.641885e-003f,  3.491716e-003f,  1.770545e-003f, -7.500723e-004f, -2.177226e-003f, -1.882177e-003f, -4.405621e-004f,  9.517912e-004f,
    1.438588e-003f,  9.888291e-004f,  1.319110e-004f, -1.683965e-004f,  9.392585e-004f,  2.670389e-003f,  2.874677e-003f,  1.281354e-003f,
    4.913342e-004f,  1.786767e-003f,  2.626837e-003f,  9.389659e-004f, -1.137890e-003f, -9.950653e-004f,  1.105815e-004f,  2.250229e-005f,
   -1.773675e-004f,  1.161513e-003f,  2.454022e-003f,  1.720935e-003f,  5.075232e-004f,  1.006579e-003f,  1.736516e-003f,  1.633990e-004f,
   -2.260010e-003f, -1.816147e-003f,  1.559235e-003f,  3.759793e-003f,  2.166827e-003f, -9.227907e-004f, -1.592667e-003f,  3.929430e-004f,
    1.832069e-003f,  9.039926e-004f, -4.539641e-004f,  1.502490e-004f,  1.755684e-003f,  1.694053e-003f, -4.222616e-005f, -8.537121e-004f,
    1.769441e-004f,  8.769080e-004f, -3.827460e-004f, -2.063864e-003f, -1.891228e-003f, -2.110968e-004f,  8.138812e-004f,  4.398954e-004f,
   -3.302188e-005f,  3.426469e-004f,  8.585602e-004f,  6.867579e-004f,  2.860425e-004f,  3.778794e-004f,  5.860585e-004f,  2.006084e-004f,
   -4.584226e-004f, -5.698599e-004f, -1.579367e-004f,  1.259235e-004f,  1.102871e-004f,  7.217378e-005f,  2.864844e-005f, -1.329995e-004f,
   -2.151046e-004f, -4.647688e-005f,  1.354802e-004f,  1.054509e-004f,  2.182596e-005f,  5.330415e-005f,  8.613025e-005f,  2.608840e-005f,
   -2.574814e-005f, -1.776552e-005f, -1.751035e-005f, -2.653683e-005f, -1.157746e-006f,  2.014678e-005f,  2.511921e-006f, -9.226985e-006f
};

static const float MPSVTImpulseRight2[] =
{
    0.00000000000f,  2.793922e-001f, -1.252581e-003f,  3.601965e-002f,  5.028702e-002f,  1.261413e-002f, -3.037459e-002f, -4.231859e-002f,
   -2.288003e-002f,  4.868296e-004f,  1.319170e-002f,  1.445832e-002f,  9.291181e-003f,  5.415364e-004f, -5.960905e-003f, -6.324124e-003f,
   -4.126417e-003f, -6.238331e-003f, -1.111591e-002f, -1.031941e-002f, -1.906132e-003f,  5.501515e-003f,  4.938129e-003f,  4.596294e-004f,
   -5.182074e-004f,  1.942317e-003f,  2.384007e-003f, -3.576821e-004f, -2.259542e-003f, -1.067077e-003f,  6.992900e-004f,  4.833567e-004f,
   -8.508244e-004f, -9.375998e-004f,  6.677472e-004f,  2.402608e-003f,  2.574608e-003f,  1.112484e-003f, -4.522100e-004f, -6.328301e-004f,
    4.975653e-005f, -1.502742e-004f, -1.494560e-003f, -2.131800e-003f, -1.048848e-003f,  2.087963e-004f, -7.985278e-005f, -1.067953e-003f,
   -8.650151e-004f,  3.845305e-004f,  8.478933e-004f,  1.402693e-005f, -7.111553e-004f, -3.549829e-004f,  3.195392e-004f,  3.309711e-004f,
   -9.334439e-005f, -1.592229e-004f,  2.522437e-004f,  6.398684e-004f,  6.472322e-004f,  3.796188e-004f,  1.634219e-004f,  2.209586e-004f,
    4.078687e-004f,  3.391667e-004f, -6.963835e-005f, -3.696561e-004f, -2.124719e-004f,  7.404760e-005f, -2.665895e-005f, -3.780865e-004f,
   -4.200376e-004f, -9.420644e-005f,  7.499749e-005f, -1.453060e-004f, -3.606560e-004f, -2.338674e-004f,  9.002852e-006f,  2.037830e-005f,
   -1.300214e-004f, -1.498993e-004f,  2.988269e-006f,  1.339538e-004f,  1.379955e-004f,  8.997838e-005f,  8.270270e-005f,  1.315068e-004f,
    1.901690e-004f,  1.885556e-004f,  1.051109e-004f,  2.667570e-005f,  4.681567e-005f,  1.097204e-004f,  7.845677e-005f, -3.833250e-005f,
   -8.678559e-005f, -1.890533e-005f,  2.613740e-005f, -4.487622e-005f, -1.298382e-004f, -1.097006e-004f, -3.882614e-005f, -3.681718e-005f,
   -9.336384e-005f, -1.071053e-004f, -5.649920e-005f, -1.273837e-005f, -1.402651e-005f, -2.478224e-005f, -1.081795e-005f,  1.857482e-005f,
    4.182373e-005f,  4.981550e-005f,  4.285513e-005f,  3.408365e-005f,  4.255946e-005f,  6.199373e-005f,  6.048032e-005f,  3.177402e-005f,
    1.298181e-005f,  2.586098e-005f,  3.797238e-005f,  1.631365e-005f, -1.633025e-005f, -2.003629e-005f, -3.801365e-006f, -6.401692e-006f,
   -3.050445e-005f, -4.284399e-005f, -3.165520e-005f, -2.056782e-005f, -2.520074e-005f, -3.221059e-005f, -2.729476e-005f, -1.587224e-005f,
   -8.369267e-006f, -5.150254e-006f, -2.470205e-006f,  1.007722e-006f,  6.806863e-006f,  1.477935e-005f,  1.908912e-005f,  1.616347e-005f,
    1.317305e-005f,  1.758335e-005f,  2.319740e-005f,  1.949900e-005f,  1.009814e-005f,  7.251667e-006f,  1.113047e-005f,  1.012342e-005f,
    1.117373e-006f, -5.832349e-006f, -5.022863e-006f, -3.391781e-006f, -7.271881e-006f, -1.250399e-005f, -1.308707e-005f, -1.065089e-005f,
   -9.759183e-006f, -1.036575e-005f, -9.886572e-006f, -8.037512e-006f, -5.817409e-006f, -3.291495e-006f, -9.036132e-007f,  2.588863e-007f,
    9.661165e-007f,  3.213160e-006f,  6.262169e-006f,  7.146063e-006f,  5.823574e-006f,  5.600788e-006f,  7.409988e-006f,  8.090180e-006f,
    5.916092e-006f,  3.562649e-006f,  3.413076e-006f,  3.725474e-006f,  2.072508e-006f, -5.272387e-007f, -1.726392e-006f, -1.729899e-006f,
   -2.314030e-006f, -3.622733e-006f, -4.407403e-006f, -4.358362e-006f, -4.162509e-006f, -4.012913e-006f, -3.641903e-006f, -3.175473e-006f,
   -2.755776e-006f, -2.013800e-006f, -8.626330e-007f,  7.775887e-009f,  2.701036e-007f,  6.568929e-007f,  1.659984e-006f,  2.527064e-006f,
    2.515306e-006f,  2.193748e-006f,  2.422356e-006f,  2.857824e-006f,  2.630211e-006f,  1.872781e-006f,  1.408111e-006f,  1.333102e-006f,
    1.024230e-006f,  3.194878e-007f, -2.940693e-007f, -5.826902e-007f, -8.236551e-007f, -1.172708e-006f, -1.449127e-006f, -1.564265e-006f,
   -1.625835e-006f, -1.625112e-006f, -1.463945e-006f, -1.239068e-006f, -1.105371e-006f, -9.518178e-007f, -5.938606e-007f, -1.669792e-007f,
    6.345500e-008f,  1.660145e-007f,  4.103251e-007f,  7.643191e-007f,  9.405721e-007f,  8.970924e-007f,  8.846351e-007f,  9.906968e-007f,
    1.015256e-006f,  8.509788e-007f,  6.523391e-007f,  5.429523e-007f,  4.356750e-007f,  2.413371e-007f,  2.716949e-008f, -1.289705e-007f,
   -2.583357e-007f, -3.938605e-007f, -4.955299e-007f, -5.462107e-007f, -5.892201e-007f, -6.253256e-007f, -5.971776e-007f, -5.088825e-007f,
   -4.368486e-007f, -3.932744e-007f, -3.040428e-007f, -1.532759e-007f, -2.475539e-008f,  4.005140e-008f,  1.056845e-007f, -1.253497e-006f,
    3.169055e-005f,  7.490991e-005f,  6.370656e-005f,  4.715299e-005f,  4.697825e-005f, -3.589368e-005f, -1.289904e-004f, -1.423361e-005f,
    1.877729e-004f,  1.637112e-004f,  4.449972e-005f,  1.297228e-004f,  2.162207e-004f,  9.112672e-005f,  1.327866e-004f,  4.678141e-004f,
    4.549225e-004f, -8.936844e-005f, -4.688163e-004f, -5.728930e-004f, -9.583359e-004f, -1.166547e-003f, -3.167408e-004f,  6.844081e-004f,
    2.453970e-004f, -1.136251e-003f, -1.878987e-003f, -1.690598e-003f, -6.781633e-004f,  1.071310e-003f,  1.428447e-003f, -1.458495e-003f,
   -4.197982e-003f, -2.767539e-003f, -9.086851e-004f, -3.124411e-003f, -3.093565e-003f,  4.348041e-003f,  5.718986e-003f, -1.157414e-002f,
   -2.789246e-002f, -1.381027e-002f,  1.802730e-002f,  2.489013e-002f,  7.649102e-004f, -1.453551e-002f, -4.819352e-003f,  2.761101e-003f,
   -7.752290e-003f, -1.613635e-002f, -8.572613e-003f, -3.038744e-004f, -1.736496e-003f, -1.723062e-003f,  3.680928e-003f,  2.404779e-003f,
   -5.148157e-003f, -3.318733e-003f,  7.520434e-003f,  9.643398e-003f,  6.990253e-004f, -3.378419e-003f,  1.504515e-003f,  3.895748e-003f,
    1.407214e-003f,  1.980549e-003f,  4.364127e-003f,  1.509501e-003f, -2.616211e-003f, -6.750369e-004f,  2.417230e-003f, -2.093266e-004f,
   -2.999534e-003f,  7.157060e-005f,  2.769423e-003f, -3.302303e-004f, -3.049877e-003f, -1.209516e-003f, -7.856708e-004f, -3.725508e-003f,
   -2.992006e-003f,  1.666758e-003f,  1.078202e-003f, -5.643027e-003f, -8.873507e-003f, -6.444360e-003f, -5.798179e-003f, -7.592727e-003f,
   -4.938700e-003f,  1.534799e-003f,  4.419976e-003f,  3.446155e-003f,  3.810107e-003f,  4.211957e-003f,  1.081666e-004f, -5.675324e-003f,
   -7.275611e-003f, -5.357896e-003f, -3.209996e-003f, -1.842701e-004f,  3.665811e-003f,  4.500716e-003f,  2.092188e-003f,  1.702911e-003f,
    4.469035e-003f,  5.125393e-003f,  2.128644e-003f,  4.031755e-004f,  1.850929e-003f,  2.466908e-003f,  5.830487e-004f, -4.491315e-004f,
    9.771114e-004f,  2.336249e-003f,  2.010376e-003f,  1.231589e-003f,  8.735221e-004f,  2.580154e-004f, -9.179856e-004f, -1.676039e-003f,
   -7.854052e-004f,  1.346524e-003f,  1.805127e-003f, -1.552121e-003f, -5.680232e-003f, -5.476252e-003f, -1.751862e-003f, -3.474370e-005f,
   -1.065562e-003f, -4.427080e-004f,  1.730226e-003f,  4.979808e-004f, -3.445033e-003f, -3.294952e-003f,  2.029273e-003f,  5.711835e-003f,
    4.372504e-003f,  2.119179e-003f,  2.208560e-003f,  3.169243e-003f,  3.397787e-003f,  2.599352e-003f,  2.561759e-004f, -1.805394e-003f,
    3.881227e-004f,  5.302102e-003f,  5.434224e-003f, -5.035136e-004f, -4.110525e-003f, -1.318560e-003f,  1.059598e-003f, -1.278046e-003f,
   -2.426790e-003f,  1.090427e-003f,  2.565152e-003f, -2.105153e-003f, -5.724024e-003f, -2.181371e-003f,  3.054346e-003f,  2.863584e-003f,
   -2.562747e-004f, -3.318907e-004f,  2.107145e-003f,  2.735093e-003f,  6.842350e-004f, -1.766958e-003f, -2.902259e-003f, -2.100511e-003f,
    3.473273e-004f,  2.695900e-003f,  3.397718e-003f,  3.301335e-003f,  4.218250e-003f,  6.042607e-003f,  6.955984e-003f,  5.697765e-003f,
    2.802758e-003f,  3.563796e-004f,  2.392743e-004f,  1.725734e-003f,  2.152070e-003f,  9.325510e-004f,  4.995260e-004f,  2.024954e-003f,
    3.436453e-003f,  3.254448e-003f,  2.780427e-003f,  2.751187e-003f,  1.602129e-003f, -1.139485e-003f, -3.292275e-003f, -3.384057e-003f,
   -2.383286e-003f, -1.201361e-003f,  3.106614e-004f,  1.345527e-003f,  3.743165e-004f, -1.931516e-003f, -2.748406e-003f, -8.586909e-004f,
    1.551192e-003f,  1.650725e-003f, -5.048925e-004f, -2.172398e-003f, -1.749084e-003f, -1.153746e-003f, -2.660251e-003f, -4.505116e-003f,
   -3.136931e-003f,  6.015882e-004f,  2.229479e-003f,  8.442954e-004f,  1.613673e-004f,  1.514723e-003f,  1.714446e-003f, -7.249469e-004f,
   -2.966086e-003f, -2.941664e-003f, -1.882321e-003f, -9.143738e-004f,  2.959312e-005f, -3.229943e-005f, -1.756379e-003f, -2.797643e-003f,
   -1.056771e-003f,  1.240328e-003f,  1.105068e-003f, -3.244150e-004f, -8.244241e-004f, -1.540660e-003f, -3.913696e-003f, -5.795496e-003f,
   -4.930161e-003f, -2.855186e-003f, -1.800625e-003f, -1.224799e-003f, -2.907593e-004f, -2.587416e-004f, -1.967907e-003f, -3.865720e-003f,
   -4.225445e-003f, -3.135949e-003f, -1.572254e-003f, -9.693839e-005f,  1.317988e-003f,  2.689660e-003f,  3.024686e-003f,  1.150605e-003f,
   -1.406916e-003f, -1.343932e-003f,  8.669621e-004f,  1.229726e-003f,  1.333647e-004f,  2.264217e-003f,  5.591802e-003f,  1.572079e-003f,
   -8.409170e-003f, -1.044515e-002f,  1.747800e-004f,  9.559331e-003f,  7.277961e-003f,  1.863310e-003f,  2.762731e-003f,  3.501786e-003f,
   -3.438111e-003f, -1.053178e-002f, -8.426909e-003f, -1.688610e-003f,  1.424198e-003f,  2.102715e-003f,  3.319311e-003f,  2.041176e-003f,
   -1.986668e-003f, -2.562062e-003f,  1.133530e-003f,  2.056614e-003f, -9.551964e-004f, -8.262586e-004f,  3.499730e-003f,  4.790999e-003f,
    1.454081e-003f, -2.682933e-004f,  1.078594e-003f,  5.586415e-004f, -2.328051e-003f, -3.268307e-003f, -2.210091e-003f, -2.286407e-003f,
   -2.534366e-003f, -7.652318e-004f,  6.759532e-004f, -2.212546e-004f, -2.922152e-004f,  2.170990e-003f,  2.942894e-003f, -1.693206e-004f,
   -2.501706e-003f, -7.910534e-004f,  1.382164e-003f,  7.665689e-004f, -1.640344e-004f,  1.278951e-003f,  3.175757e-003f,  2.681359e-003f,
    3.372488e-004f, -1.040614e-003f,  2.442281e-004f,  2.583832e-003f,  2.426007e-003f, -5.407471e-004f, -2.006271e-003f, -2.866129e-004f,
   -6.587023e-006f, -2.982411e-003f, -2.896630e-003f,  2.680748e-003f,  4.362565e-003f, -3.719802e-003f, -1.083586e-002f, -5.650890e-003f,
    4.734106e-003f,  6.941519e-003f,  2.830909e-003f,  2.770635e-003f,  6.340782e-003f,  6.052764e-003f,  2.686595e-003f,  1.688473e-003f,
    1.070225e-003f, -3.490006e-003f, -7.899048e-003f, -6.107165e-003f, -1.575496e-003f, -2.006490e-003f, -7.412938e-003f, -1.138574e-002f,
   -1.024005e-002f, -5.439183e-003f, -2.320294e-004f,  3.065520e-003f,  4.708727e-003f,  6.589884e-003f,  8.226222e-003f,  6.876586e-003f,
    3.270485e-003f,  1.568963e-003f,  1.849047e-003f,  1.188016e-004f, -2.603410e-003f, -6.024705e-004f,  5.238340e-003f,  6.825464e-003f,
    1.825059e-003f, -2.943486e-003f, -2.850880e-003f, -4.095840e-004f,  1.823447e-003f,  3.833424e-003f,  3.947301e-003f,  7.358540e-004f,
   -2.532900e-003f, -2.850101e-003f, -3.006192e-003f, -5.247771e-003f, -5.688729e-003f, -2.297958e-003f, -5.021411e-004f, -3.146244e-003f,
   -3.980489e-003f,  6.804140e-004f,  3.649001e-003f, -8.148491e-004f, -5.937170e-003f, -3.237958e-003f,  3.923723e-003f,  7.010902e-003f,
    5.680694e-003f,  5.610215e-003f,  7.928828e-003f,  8.768627e-003f,  6.598257e-003f,  3.780067e-003f,  1.787252e-003f, -7.722535e-004f,
   -4.823963e-003f, -8.044700e-003f, -7.297526e-003f, -3.292335e-003f, -2.548779e-004f, -2.373889e-004f, -9.719731e-004f, -7.451791e-004f,
   -1.085020e-003f, -2.456662e-003f, -2.483247e-003f, -1.113460e-003f, -1.680664e-003f, -4.152080e-003f, -4.129630e-003f, -1.141623e-003f,
   -1.119769e-004f, -2.075259e-003f, -2.187375e-003f,  5.362525e-004f,  1.024869e-003f, -1.766623e-003f, -2.465221e-003f,  4.773141e-004f,
    1.959566e-003f, -4.185881e-005f, -1.393699e-003f, -2.540333e-004f,  4.168168e-004f, -1.109556e-004f,  6.683400e-004f,  2.133969e-003f,
    1.226177e-003f, -8.861818e-004f, -3.486514e-004f,  2.195905e-003f,  2.916344e-003f,  1.678805e-003f,  1.191756e-003f,  1.245829e-003f,
   -2.224321e-004f, -2.248480e-003f, -2.265765e-003f, -6.960965e-004f,  1.024690e-004f, -1.448773e-004f,  7.939246e-005f,  1.227729e-003f,
    2.460101e-003f,  3.089085e-003f,  2.863337e-003f,  1.817384e-003f,  5.241217e-004f, -2.040097e-004f,  1.423594e-005f,  9.837075e-004f,
    1.940845e-003f,  1.764415e-003f,  8.033086e-005f, -2.068064e-003f, -3.426855e-003f, -3.642304e-003f, -2.596048e-003f, -2.959281e-004f,
    1.748145e-003f,  1.242717e-003f, -1.619526e-003f, -3.762505e-003f, -3.204632e-003f, -1.439182e-003f, -9.290660e-004f, -1.840468e-003f,
   -2.035968e-003f,  1.435163e-004f,  2.976559e-003f,  2.233796e-003f, -2.977697e-003f, -7.012232e-003f, -4.609610e-003f,  8.141171e-004f,
    1.917472e-003f, -1.248169e-003f, -2.428633e-003f, -3.787634e-004f,  1.036485e-004f, -2.134709e-003f, -3.106447e-003f, -1.837282e-003f,
   -1.289693e-003f, -1.483942e-003f,  1.311011e-004f,  2.454337e-003f,  2.465240e-003f,  1.262321e-003f,  1.405317e-003f,  1.250105e-003f,
   -1.422793e-003f, -3.893359e-003f, -2.847690e-003f, -2.567091e-004f,  2.820156e-004f, -1.064025e-003f, -2.303497e-003f, -2.543023e-003f,
   -1.101075e-003f,  1.547376e-003f,  2.126813e-003f, -8.685053e-004f, -3.207291e-003f, -1.355415e-003f,  1.369167e-003f,  1.415545e-003f,
    1.541995e-003f,  3.782104e-003f,  3.749930e-003f, -5.328560e-004f, -3.077629e-003f, -5.471683e-004f,  1.597303e-003f,  2.515971e-004f,
    4.627621e-004f,  3.818712e-003f,  3.855512e-003f, -9.059766e-004f, -2.832756e-003f,  4.381437e-004f,  1.420948e-003f, -2.641059e-003f,
   -4.723222e-003f, -1.663486e-003f,  8.155621e-004f, -1.227010e-004f, -4.432003e-004f,  1.236402e-003f,  1.881164e-003f,  1.707528e-003f,
    2.862145e-003f,  2.660199e-003f, -1.608802e-003f, -5.109567e-003f, -2.621157e-003f,  1.821497e-003f,  1.732888e-003f, -1.144801e-003f,
   -1.287453e-003f,  1.503046e-003f,  4.216522e-003f,  5.710781e-003f,  4.996947e-003f,  1.103014e-003f, -2.708921e-003f, -1.824662e-003f,
    1.826119e-003f,  2.447515e-003f, -1.995685e-005f, -1.199398e-003f, -8.652138e-004f, -1.616577e-003f, -2.061534e-003f,  1.654563e-004f,
    2.129778e-003f,  2.181276e-004f, -2.852327e-003f, -2.536160e-003f,  6.041753e-005f,  7.990574e-004f, -1.242142e-003f, -3.871795e-003f,
   -4.535668e-003f, -1.761852e-003f,  2.312303e-003f,  2.328794e-003f, -2.748027e-003f, -6.188799e-003f, -3.214103e-003f,  1.219902e-003f,
    8.762542e-004f, -1.922263e-003f, -2.059868e-003f, -5.295991e-004f, -5.129292e-004f, -1.169921e-003f, -1.353056e-003f, -2.759506e-003f,
   -4.914602e-003f, -4.326051e-003f, -1.535668e-003f, -9.871153e-004f, -2.454519e-003f, -1.448598e-003f,  1.566475e-003f,  1.819373e-003f,
   -4.392595e-004f, -7.313398e-004f,  8.596007e-004f,  6.609858e-004f, -1.295573e-003f, -3.133691e-003f, -6.033202e-003f, -9.326017e-003f,
   -6.841242e-003f,  3.061410e-003f,  1.059939e-002f,  7.198619e-003f, -1.432675e-003f, -4.320581e-003f, -1.288001e-003f, -4.136504e-004f,
   -4.085889e-003f, -6.792245e-003f, -4.613533e-003f,  8.962097e-005f,  2.873664e-003f,  1.972254e-003f, -9.544773e-004f, -3.048930e-003f,
   -3.217389e-003f, -2.527918e-003f, -1.580292e-003f,  3.012372e-004f,  2.473642e-003f,  2.681594e-003f,  7.551481e-004f, -4.517052e-004f,
    7.897232e-004f,  2.642807e-003f,  2.382491e-003f, -4.058925e-004f, -3.364525e-003f, -3.109622e-003f,  1.054349e-003f,  4.780580e-003f,
    3.353488e-003f, -1.126076e-003f, -2.303463e-003f,  5.134183e-004f,  1.833819e-003f,  6.856942e-005f, -6.919658e-005f,  3.031559e-003f,
    4.678465e-003f,  2.665085e-003f,  1.072087e-003f,  2.428335e-003f,  3.562911e-003f,  1.995830e-003f, -1.247279e-004f, -6.242176e-004f,
   -1.996793e-004f,  4.387914e-004f,  1.357829e-003f,  1.251386e-003f, -9.350457e-004f, -3.042708e-003f, -2.563459e-003f, -8.393172e-004f,
   -4.451585e-004f, -7.281157e-004f,  1.575839e-005f,  5.698538e-004f, -7.597428e-004f, -2.090806e-003f, -5.844051e-004f,  2.541901e-003f,
    3.503792e-003f,  1.611142e-003f,  5.021178e-005f,  8.979698e-004f,  2.166742e-003f,  1.141394e-003f, -1.250454e-003f, -1.919554e-003f,
   -7.477092e-004f, -7.846236e-004f, -2.738408e-003f, -3.333797e-003f, -9.853331e-004f,  1.123639e-003f,  2.706584e-004f, -1.680502e-003f,
   -2.292155e-003f, -2.376367e-003f, -2.833966e-003f, -2.212461e-003f, -4.007957e-004f, -1.062276e-004f, -1.879957e-003f, -2.463380e-003f,
   -5.222094e-004f,  9.519898e-004f,  1.188974e-004f, -8.576260e-004f, -3.845044e-004f, -1.415765e-004f, -1.508233e-003f, -3.211216e-003f,
   -3.514624e-003f, -1.818526e-003f,  1.498607e-003f,  4.333361e-003f,  3.739815e-003f,  1.003721e-005f, -2.736150e-003f, -2.146151e-003f,
   -4.342600e-004f,  5.225940e-005f, -1.435617e-004f, -3.850467e-004f, -1.152949e-003f, -1.514773e-003f, -5.897672e-005f,  1.598764e-003f,
    1.088730e-003f, -3.631735e-005f,  8.132132e-004f,  1.864938e-003f,  4.185577e-004f, -1.176611e-003f,  4.812350e-004f,  2.997571e-003f,
    2.092761e-003f, -8.345930e-004f, -1.611306e-003f, -4.569014e-004f, -1.529577e-004f, -4.620266e-004f,  1.823989e-004f,  8.754319e-004f,
    5.548868e-004f,  3.584283e-004f,  4.304711e-004f, -1.124447e-003f, -3.650995e-003f, -3.585814e-003f, -8.124157e-004f,  2.845117e-004f,
   -1.979003e-003f, -4.040207e-003f, -3.379536e-003f, -1.722253e-003f, -5.160366e-004f,  1.313532e-003f,  3.543542e-003f,  3.507269e-003f,
    5.594070e-004f, -2.029920e-003f, -1.283555e-003f,  1.720429e-003f,  3.394453e-003f,  1.841330e-003f, -9.810424e-004f, -1.412429e-003f,
    1.306299e-003f,  3.819950e-003f,  3.315506e-003f,  1.350794e-003f,  7.231669e-004f,  9.510755e-004f,  1.463777e-004f, -9.309777e-004f,
   -5.119714e-004f,  3.902089e-004f, -3.529302e-004f, -2.001963e-003f, -2.052967e-003f, -2.036774e-004f,  1.488648e-003f,  1.529948e-003f,
    3.462569e-004f, -4.228172e-004f,  6.081954e-004f,  2.730310e-003f,  3.307559e-003f,  1.315838e-003f, -8.025191e-004f, -8.635253e-004f,
   -1.309251e-004f, -1.946087e-004f,  1.235923e-004f,  1.430908e-003f,  1.111967e-003f, -1.889268e-003f, -3.617283e-003f, -1.136056e-003f,
    1.941259e-003f,  1.021750e-003f, -2.215257e-003f, -3.385669e-003f, -2.464993e-003f, -1.883617e-003f, -1.131755e-003f,  1.187989e-003f,
    3.038206e-003f,  2.058496e-003f,  3.630582e-004f,  1.334876e-003f,  3.984976e-003f,  4.824738e-003f,  3.121896e-003f,  6.327053e-004f,
   -1.476897e-003f, -2.260725e-003f, -3.497542e-004f,  3.192008e-003f,  4.226243e-003f,  8.353589e-004f, -3.397867e-003f, -4.152432e-003f,
   -1.787002e-003f,  4.337642e-004f,  8.570376e-004f, -6.078548e-005f, -1.245878e-003f, -1.152397e-003f,  1.133686e-003f,  3.729585e-003f,
    3.628244e-003f,  1.209119e-003f, -1.951284e-004f,  3.813600e-004f,  6.161559e-004f, -2.351454e-004f, -1.010496e-004f,  1.351045e-003f,
    1.595810e-003f, -1.943094e-005f, -9.411982e-004f, -1.710902e-004f,  1.006236e-004f, -9.815880e-004f, -1.287512e-003f, -1.342229e-004f,
    1.215246e-004f, -1.265239e-003f, -1.597583e-003f,  2.673397e-004f,  1.351307e-003f, -2.482682e-004f, -1.422864e-003f,  1.135524e-003f,
    5.023760e-003f,  5.128223e-003f,  1.100919e-003f, -2.258470e-003f, -1.913253e-003f,  3.398440e-005f,  8.296217e-004f,  1.149254e-003f,
    2.352126e-003f,  2.877523e-003f,  9.396505e-004f, -1.427020e-003f, -1.128401e-003f,  7.201309e-004f,  6.376960e-004f, -1.316877e-003f,
   -2.129734e-003f, -1.359534e-003f, -1.202798e-003f, -1.775488e-003f, -1.218342e-003f,  1.771745e-004f,  6.257665e-004f,  5.994627e-004f,
    1.396730e-003f,  1.606273e-003f, -3.255136e-004f, -2.086433e-003f, -8.624090e-004f,  1.648054e-003f,  2.214227e-003f,  1.282077e-003f,
    7.718200e-004f, -6.714994e-005f, -2.240347e-003f, -3.804796e-003f, -2.966097e-003f, -1.058663e-003f,  3.174562e-004f,  1.291943e-003f,
    1.232525e-003f, -9.843379e-004f, -3.275907e-003f, -2.307855e-003f,  6.449665e-004f,  1.605097e-003f,  8.733307e-004f,  1.607552e-003f,
    2.982217e-003f,  1.943709e-003f, -1.421372e-004f,  1.886321e-005f,  8.888943e-004f, -8.682767e-004f, -3.467399e-003f, -3.133531e-003f,
   -8.240114e-004f,  5.068750e-004f,  1.280808e-003f,  2.368913e-003f,  1.818523e-003f, -5.658059e-004f, -1.173818e-003f,  7.867073e-004f,
    1.288754e-003f, -7.036374e-004f, -1.146118e-003f,  7.924145e-004f,  9.327236e-004f, -1.277276e-003f, -1.406581e-003f,  1.016257e-003f,
    1.480649e-003f, -5.431492e-004f, -9.239310e-004f,  5.290975e-004f,  5.282094e-005f, -1.841685e-003f, -1.219049e-003f,  1.141498e-003f,
    1.108999e-003f, -8.332406e-004f, -9.934803e-004f,  3.146933e-004f,  1.691275e-004f, -1.114154e-003f, -1.685123e-003f, -2.176133e-003f,
   -2.986406e-003f, -2.083099e-003f,  3.339099e-004f,  4.336827e-004f, -2.439645e-003f, -3.612831e-003f, -7.313336e-004f,  2.627237e-003f,
    3.192788e-003f,  1.764100e-003f, -3.372558e-004f, -2.505106e-003f, -2.741806e-003f, -4.217130e-004f,  4.651745e-004f, -2.748361e-003f,
   -5.284903e-003f, -2.042576e-003f,  2.969513e-003f,  2.580671e-003f, -1.857901e-003f, -3.418609e-003f, -1.037365e-003f,  4.818281e-004f,
   -6.137546e-004f, -1.745610e-003f, -1.636577e-003f, -9.994931e-004f,  2.940031e-004f,  1.914422e-003f,  1.660158e-003f, -8.118932e-004f,
   -2.217647e-003f, -8.457451e-004f,  4.053087e-004f, -8.362779e-004f, -2.435690e-003f, -1.844188e-003f, -2.002366e-004f,  3.989644e-004f,
    2.236369e-004f,  2.301516e-004f,  1.116850e-004f, -2.590029e-004f, -1.030090e-004f,  4.925285e-004f,  5.065942e-004f,  1.181030e-004f,
    4.954298e-004f,  1.387647e-003f,  1.316687e-003f,  1.302434e-004f, -7.733715e-004f, -5.607486e-004f,  4.918167e-004f,  2.019371e-003f,
    3.461746e-003f,  3.695185e-003f,  2.384199e-003f,  9.131114e-004f,  5.824046e-004f,  8.381261e-004f,  5.681777e-004f,  5.232154e-006f,
   -8.812905e-006f,  4.498416e-004f,  8.708846e-004f,  1.278395e-003f,  1.629634e-003f,  1.338163e-003f,  3.081387e-004f, -7.415110e-004f,
   -1.640576e-003f, -2.896548e-003f, -3.815879e-003f, -2.548622e-003f,  8.014286e-004f,  3.060356e-003f,  1.603384e-003f, -2.224010e-003f,
   -4.683713e-003f, -3.733076e-003f, -6.583258e-004f,  1.599162e-003f,  1.301622e-003f, -3.957043e-004f, -9.363974e-004f,  1.044204e-004f,
    5.128210e-004f, -6.957921e-004f, -1.482953e-003f, -6.549132e-004f, -4.177506e-004f, -2.338388e-003f, -3.951777e-003f, -2.754063e-003f,
   -4.747144e-004f,  1.861319e-004f, -1.006770e-004f,  2.189704e-004f,  1.828701e-004f, -1.012906e-003f, -1.535263e-003f, -4.550953e-004f,
    1.537643e-004f, -4.478454e-004f,  9.969301e-005f,  1.954795e-003f,  1.504774e-003f, -1.984963e-003f, -4.078615e-003f, -2.522027e-003f,
   -7.276059e-004f, -1.097381e-003f, -1.390386e-003f, -4.808010e-004f, -9.173291e-004f, -2.976503e-003f, -2.963347e-003f, -6.027669e-005f,
    1.736480e-003f,  7.021311e-004f, -1.196198e-004f,  7.972412e-004f,  1.203957e-003f,  4.678175e-004f,  8.305330e-004f,  2.235003e-003f,
    1.981888e-003f,  1.587590e-004f, -3.390863e-004f,  7.587275e-004f,  1.184645e-003f,  1.079342e-003f,  2.271705e-003f,  3.524426e-003f,
    2.194107e-003f, -2.818177e-004f, -2.682464e-004f,  1.457854e-003f,  7.256779e-004f, -2.643890e-003f, -4.136271e-003f, -1.935939e-003f,
    1.382763e-004f, -1.100791e-003f, -3.243289e-003f, -2.434244e-003f,  5.352264e-004f,  2.057070e-003f,  1.970674e-003f,  3.361420e-003f,
    6.091252e-003f,  5.765533e-003f,  1.076625e-003f, -2.975553e-003f, -2.564445e-003f, -8.536750e-004f, -2.011103e-003f, -4.233207e-003f,
   -4.029047e-003f, -2.888114e-003f, -3.725146e-003f, -4.899084e-003f, -3.866781e-003f, -2.609769e-003f, -3.394309e-003f, -3.597447e-003f,
   -7.419565e-004f,  2.173865e-003f,  2.198490e-003f,  1.775046e-003f,  2.881242e-003f,  2.274587e-003f, -1.443520e-003f, -3.286166e-003f,
   -8.209642e-004f,  3.064825e-004f, -3.231177e-003f, -5.167019e-003f, -7.854540e-004f,  3.433945e-003f,  5.570853e-004f, -4.516121e-003f,
   -3.478856e-003f,  1.704060e-003f,  3.679540e-003f,  2.288679e-003f,  2.354532e-003f,  3.885345e-003f,  3.819276e-003f,  3.265103e-003f,
    4.429967e-003f,  4.406788e-003f,  2.209458e-004f, -3.846839e-003f, -2.167358e-003f,  2.433138e-003f,  2.922687e-003f, -6.451565e-004f,
   -2.216280e-003f, -2.525976e-004f,  8.669885e-004f, -5.983408e-004f, -1.176985e-003f,  1.125879e-003f,  3.648058e-003f,  3.932313e-003f,
    3.092206e-003f,  2.905551e-003f,  3.052740e-003f,  2.474503e-003f,  1.073372e-003f, -5.405066e-004f, -1.400278e-003f, -6.796592e-004f,
    8.009198e-004f,  9.291173e-004f, -4.049533e-004f, -7.169929e-004f,  5.039566e-004f, -1.118920e-005f, -3.607424e-003f, -5.970757e-003f,
   -3.292214e-003f,  1.335888e-003f,  2.677257e-003f,  1.339386e-003f,  1.398591e-003f,  2.829215e-003f,  2.518487e-003f,  7.896313e-004f,
    5.958768e-004f,  1.622940e-003f,  1.204903e-003f, -1.134921e-004f,  2.625629e-004f,  1.460355e-003f,  5.165902e-004f, -1.796230e-003f,
   -2.079169e-003f, -2.855253e-004f,  6.726300e-004f,  2.922924e-004f,  4.342728e-004f,  1.011140e-003f,  5.645886e-004f, -5.483021e-006f,
    1.036930e-003f,  2.209856e-003f,  8.221854e-004f, -2.073997e-003f, -3.053665e-003f, -1.656456e-003f, -3.528225e-004f, -4.070208e-005f,
    6.972498e-004f,  2.321708e-003f,  3.412505e-003f,  2.877553e-003f,  1.114882e-003f, -6.480525e-004f, -1.164098e-003f, -2.657168e-004f,
    4.611453e-004f, -3.912806e-004f, -1.564714e-003f, -7.229789e-004f,  1.829677e-003f,  3.686521e-003f,  4.147877e-003f,  4.476707e-003f,
    4.860720e-003f,  4.355855e-003f,  3.277077e-003f,  2.394276e-003f,  7.283983e-004f, -2.333322e-003f, -4.152783e-003f, -2.228026e-003f,
    9.888422e-004f,  1.352519e-003f, -2.001327e-004f,  6.540076e-004f,  4.007877e-003f,  5.362349e-003f,  2.886563e-003f, -1.421438e-004f,
   -7.314702e-004f,  4.026797e-004f,  1.412059e-003f,  1.605536e-003f,  8.052065e-004f, -4.988750e-004f, -5.419595e-004f,  1.425029e-003f,
    3.100042e-003f,  2.132879e-003f, -2.083909e-004f, -1.257914e-003f, -1.077852e-003f, -1.222033e-003f, -1.301528e-003f, -1.695244e-004f,
    1.275383e-003f,  1.721510e-003f,  1.964336e-003f,  2.750252e-003f,  2.439495e-003f,  7.217220e-005f, -1.746714e-003f, -5.575420e-004f,
    1.753033e-003f,  2.019487e-003f,  7.155314e-004f,  2.073502e-004f,  3.913117e-004f, -1.513841e-004f, -5.941284e-004f,  7.586430e-004f,
    2.885625e-003f,  3.182077e-003f,  1.318787e-003f, -5.783070e-004f, -8.476828e-004f,  3.780704e-004f,  1.869111e-003f,  2.189696e-003f,
    9.291334e-004f, -4.881436e-004f, -5.144456e-004f,  2.016382e-004f, -1.657568e-005f, -1.010668e-003f, -1.351631e-003f, -9.663187e-004f,
   -6.880349e-004f, -1.887118e-004f,  9.719055e-004f,  1.494575e-003f,  3.480901e-004f, -8.652263e-004f, -3.996821e-004f,  5.949903e-004f,
    4.241301e-004f,  2.734035e-005f,  7.258130e-004f,  1.257917e-003f,  3.137281e-004f, -5.206472e-004f,  4.571496e-004f,  2.014687e-003f,
    2.614135e-003f,  2.993723e-003f,  3.390760e-003f,  1.893113e-003f, -1.515314e-003f, -3.310305e-003f, -1.904619e-003f, -5.005366e-004f,
   -1.359081e-003f, -1.906675e-003f, -7.253203e-005f,  1.317992e-003f, -4.069895e-004f, -2.714368e-003f, -2.222714e-003f, -3.758555e-004f,
   -4.988675e-004f, -2.228663e-003f, -2.774096e-003f, -1.371778e-003f,  6.622588e-004f,  2.298328e-003f,  2.831844e-003f,  1.542085e-003f,
   -8.368923e-004f, -2.155772e-003f, -1.626100e-003f, -7.102125e-004f, -5.090805e-004f, -3.666991e-004f,  2.447277e-004f,  5.382769e-004f,
   -7.084721e-005f, -8.965234e-004f, -1.141162e-003f, -9.966348e-004f, -1.114029e-003f, -1.641028e-003f, -2.036735e-003f, -1.719122e-003f,
   -9.876621e-004f, -9.081762e-004f, -1.715809e-003f, -2.082949e-003f, -1.006859e-003f,  5.202007e-004f,  1.066500e-003f,  8.112240e-004f,
    4.369260e-004f, -5.013527e-004f, -1.979658e-003f, -1.953613e-003f,  7.865600e-004f,  3.554807e-003f,  2.808681e-003f, -5.402950e-004f,
   -2.231995e-003f, -8.267025e-004f,  7.025189e-004f,  8.918843e-005f, -8.585777e-004f,  3.449901e-004f,  2.656949e-003f,  3.190332e-003f,
    1.743317e-003f,  8.109065e-004f,  1.276017e-003f,  1.019203e-003f, -1.197289e-003f, -3.149790e-003f, -2.455615e-003f, -3.209930e-004f,
    6.145657e-004f,  4.848939e-004f,  1.103344e-003f,  1.890427e-003f,  6.492648e-004f, -1.893184e-003f, -2.193345e-003f,  7.177648e-004f,
    3.270561e-003f,  2.157097e-003f, -1.426238e-003f, -3.852634e-003f, -3.431898e-003f, -1.099342e-003f,  1.667249e-003f,  3.556892e-003f,
    2.965771e-003f, -5.620652e-004f, -4.185079e-003f, -3.836589e-003f,  1.273568e-004f,  2.186201e-003f, -8.036444e-004f, -4.283382e-003f,
   -2.518061e-003f,  2.131567e-003f,  2.596232e-003f, -1.635115e-003f, -4.000283e-003f, -1.726837e-003f,  6.384767e-004f,  1.817866e-005f,
   -6.673356e-004f,  7.626485e-004f,  1.771533e-003f,  8.113059e-004f,  3.539468e-004f,  1.414574e-003f,  1.370160e-003f, -2.841809e-004f,
   -3.069894e-004f,  1.894819e-003f,  2.514012e-003f,  1.575961e-004f, -1.607409e-003f, -4.796736e-004f,  1.436068e-003f,  2.217433e-003f,
    2.526487e-003f,  2.441895e-003f,  9.870597e-004f, -6.534067e-004f, -2.168716e-004f,  1.385415e-003f,  1.379182e-003f, -1.044687e-005f,
   -3.738177e-004f,  4.072617e-004f,  7.628420e-004f,  9.415685e-004f,  1.812371e-003f,  2.066038e-003f,  5.782789e-004f, -5.775892e-004f,
    6.593529e-004f,  2.344894e-003f,  1.483721e-003f, -1.143305e-003f, -2.591912e-003f, -2.263322e-003f, -1.631241e-003f, -1.116597e-003f,
   -6.841556e-005f,  1.265286e-003f,  1.911563e-003f,  1.606339e-003f,  7.701446e-004f, -3.133847e-004f, -1.579814e-003f, -2.819486e-003f,
   -3.363941e-003f, -2.246486e-003f,  4.265162e-004f,  2.411640e-003f,  1.482108e-003f, -1.161996e-003f, -1.996627e-003f, -1.439312e-004f,
    1.460093e-003f,  5.844230e-004f, -1.454382e-003f, -2.414132e-003f, -1.870034e-003f, -4.058207e-004f,  1.380587e-003f,  2.333789e-003f,
    1.637677e-003f,  6.164960e-004f,  1.144491e-003f,  2.303207e-003f,  1.515283e-003f, -1.061902e-003f, -2.494100e-003f, -1.601612e-003f,
   -2.720850e-004f,  1.955746e-004f,  8.260381e-004f,  2.145468e-003f,  2.473686e-003f,  4.367596e-004f, -2.624305e-003f, -3.923167e-003f,
   -2.093266e-003f,  1.437143e-003f,  3.422864e-003f,  1.845027e-003f, -1.422394e-003f, -2.421157e-003f, -3.773916e-004f,  1.148650e-003f,
   -1.667023e-004f, -1.730922e-003f, -6.149766e-004f,  1.240015e-003f,  3.257804e-004f, -2.306530e-003f, -2.894061e-003f, -1.373267e-003f,
   -8.942013e-004f, -1.723719e-003f, -9.734871e-004f,  1.445091e-003f,  1.957049e-003f, -4.336242e-004f, -2.042191e-003f, -6.409179e-004f,
    8.460263e-004f, -3.387375e-004f, -1.679534e-003f,  4.347520e-004f,  4.055833e-003f,  3.999463e-003f,  8.953921e-005f, -1.813324e-003f,
    1.714432e-003f,  6.413437e-003f,  6.477839e-003f,  2.671020e-003f,  1.220346e-004f,  2.190148e-004f,  6.319403e-005f, -8.414828e-004f,
    3.929123e-004f,  3.502425e-003f,  3.967899e-003f,  7.568087e-004f, -8.827324e-004f,  2.279046e-003f,  5.825750e-003f,  4.445490e-003f,
   -2.282147e-004f, -2.725355e-003f, -1.159150e-003f,  2.047892e-003f,  3.950513e-003f,  2.997666e-003f, -1.654940e-004f, -2.443949e-003f,
   -1.672371e-003f, -1.367277e-004f, -9.455016e-004f, -2.143324e-003f,  1.317507e-004f,  3.914155e-003f,  3.576381e-003f, -8.065835e-004f,
   -3.334102e-003f, -1.660667e-003f,  2.947417e-004f, -4.500799e-004f, -2.154765e-003f, -2.398828e-003f, -8.750719e-004f,  1.892318e-003f,
    4.513623e-003f,  4.423301e-003f,  1.270732e-003f, -1.303116e-003f, -5.911545e-004f,  1.369485e-003f,  2.036801e-003f,  2.439466e-003f,
    3.506395e-003f,  2.878303e-003f, -4.881160e-004f, -2.876350e-003f, -1.232445e-003f,  1.857468e-003f,  2.514876e-003f,  1.219798e-003f,
    4.902541e-004f,  2.974812e-004f, -7.022409e-004f, -1.960847e-003f, -2.022840e-003f, -1.009677e-003f, -2.283550e-004f, -4.969803e-004f,
   -1.631430e-003f, -2.572414e-003f, -2.153208e-003f, -6.727616e-004f,  1.867907e-004f, -1.105911e-004f, -9.486120e-005f,  9.981499e-004f,
    1.618345e-003f,  3.537239e-004f, -1.735667e-003f, -2.502117e-003f, -1.243761e-003f,  7.292619e-004f,  1.198637e-003f, -9.196828e-004f,
   -3.747027e-003f, -3.919037e-003f, -9.923439e-004f,  1.626349e-003f,  1.502968e-003f,  2.219812e-004f, -1.638822e-004f, -4.948533e-004f,
   -1.844176e-003f, -2.672184e-003f, -1.602888e-003f, -3.962691e-004f, -1.223323e-003f, -3.068116e-003f, -3.356932e-003f, -1.528625e-003f,
    8.361390e-004f,  2.018623e-003f,  1.280093e-003f, -5.545696e-004f, -1.329766e-003f,  1.973693e-005f,  1.652197e-003f,  1.315561e-003f,
   -2.598628e-004f, -8.024254e-004f, -1.532769e-004f,  2.535158e-004f,  3.481603e-004f,  8.861820e-004f,  1.128150e-003f,  1.581417e-004f,
   -6.336131e-004f,  3.998525e-004f,  1.802993e-003f,  1.167401e-003f, -4.604743e-004f, -1.845958e-004f,  1.523688e-003f,  1.543617e-003f,
   -1.613066e-004f, -2.875516e-004f,  1.609022e-003f,  1.676655e-003f, -1.466113e-003f, -3.337138e-003f, -3.541794e-004f,  3.987075e-003f,
    4.121538e-003f,  7.705447e-004f, -7.410345e-004f,  1.039715e-003f,  2.194676e-003f,  3.365331e-004f, -1.879988e-003f, -1.441446e-003f,
    5.789786e-004f,  1.274900e-003f,  2.457640e-004f, -4.276197e-004f,  4.876340e-004f,  1.814887e-003f,  1.819418e-003f,  5.603440e-004f,
   -4.599682e-004f, -6.212185e-004f, -7.250202e-004f, -9.750186e-004f, -4.140479e-004f,  7.243159e-004f,  5.594552e-004f, -9.869740e-004f,
   -1.112129e-003f,  1.286810e-003f,  3.036564e-003f,  1.570114e-003f, -7.460370e-004f, -6.079315e-004f,  8.848053e-004f,  7.481738e-004f,
   -6.013054e-004f, -5.880805e-004f,  8.752392e-004f,  1.509333e-003f,  1.535890e-004f, -2.276212e-003f, -4.002731e-003f, -3.330221e-003f,
   -2.378706e-004f,  2.536584e-003f,  2.386491e-003f,  5.236188e-004f, -1.005288e-004f,  5.142658e-004f,  4.469897e-004f,  3.937593e-005f,
    6.654970e-004f,  9.444527e-004f, -1.052460e-003f, -3.453773e-003f, -3.213001e-003f, -1.207091e-003f, -1.139592e-004f,  3.386440e-004f,
    1.289982e-003f,  9.794214e-004f, -1.742868e-003f, -3.326415e-003f, -4.968749e-004f,  3.643617e-003f,  4.009663e-003f,  1.166764e-003f,
   -8.272698e-004f, -1.289646e-003f, -1.977512e-003f, -1.889501e-003f,  1.009235e-003f,  4.459410e-003f,  4.025886e-003f,  1.444928e-005f,
   -2.657457e-003f, -1.604831e-003f,  3.408906e-004f,  3.830234e-004f, -2.037287e-004f,  6.949588e-004f,  1.661862e-003f, -1.297460e-004f,
   -3.602905e-003f, -4.373943e-003f, -1.221225e-003f,  1.716420e-003f,  1.036003e-003f, -1.092806e-003f, -1.020711e-003f,  6.649776e-004f,
    1.240524e-003f,  8.544661e-004f,  1.098445e-003f,  9.695031e-004f, -9.966217e-004f, -2.614681e-003f, -1.125621e-003f,  1.355150e-003f,
    7.705813e-004f, -1.903249e-003f, -2.170965e-003f,  4.240723e-004f,  1.928849e-003f,  8.151794e-004f, -3.876375e-004f, -4.573414e-004f,
   -1.073421e-003f, -2.343672e-003f, -1.834814e-003f,  6.933030e-004f,  2.155533e-003f,  1.188669e-003f,  1.362852e-004f,  4.624604e-004f,
    3.474371e-004f, -1.171922e-003f, -1.642105e-003f,  6.711962e-004f,  3.458919e-003f,  3.902476e-003f,  2.704731e-003f,  2.059418e-003f,
    2.267972e-003f,  2.738592e-003f,  3.584245e-003f,  3.962127e-003f,  1.936164e-003f, -1.597907e-003f, -2.366883e-003f,  1.065101e-003f,
    4.202628e-003f,  2.988359e-003f, -3.990901e-004f, -1.670650e-003f, -7.292947e-004f, -1.036029e-005f,  1.033555e-004f,  3.529462e-004f,
    2.053619e-004f, -2.666935e-004f,  6.057633e-004f,  2.599933e-003f,  2.721362e-003f,  1.493373e-004f, -1.760257e-003f, -7.174590e-004f,
    1.099794e-003f,  1.167547e-003f,  3.765841e-004f,  3.189434e-004f,  2.746845e-004f, -6.727871e-004f, -1.366536e-003f, -6.242349e-004f,
    6.348040e-004f,  9.909014e-004f,  5.044657e-004f, -1.549502e-005f, -2.132632e-004f,  1.471037e-005f,  6.175562e-004f,  9.877068e-004f,
    5.803049e-004f, -1.169482e-004f, -2.494250e-004f,  9.213942e-005f,  2.179588e-004f,  4.876085e-005f,  2.930153e-006f,  1.027426e-004f,
    7.050928e-005f, -3.649712e-005f,  1.258103e-005f,  1.332714e-004f,  1.153930e-004f,  1.801782e-005f,  7.140179e-006f,  5.552915e-005f,
    5.735644e-005f,  2.658630e-005f,  2.031145e-005f,  2.905188e-005f,  2.784199e-005f,  2.173818e-005f,  1.475259e-005f,  5.219502e-006f
};

static const float MPSVTImpulseLeft3[] =
{
    0.00000000000f,  1.726629e-001f,  4.460264e-002f,  4.431874e-002f,  7.585521e-003f,  2.625528e-002f,  1.596892e-002f, -2.505367e-002f,
   -5.463173e-002f, -2.621529e-002f,  1.543335e-002f,  1.911377e-002f, -6.188357e-003f, -8.649795e-003f,  1.235697e-002f,  1.843483e-002f,
   -1.806532e-003f, -1.248062e-002f,  2.841707e-003f,  1.901092e-002f,  1.243549e-002f, -9.886899e-004f, -8.755001e-004f,  5.256289e-003f,
   -1.285520e-003f, -1.522235e-002f, -1.913205e-002f, -1.078995e-002f, -3.402162e-003f, -1.531221e-003f,  3.228515e-004f,  3.793581e-003f,
    3.408039e-003f, -6.280933e-004f, -2.471473e-003f, -6.024633e-004f, -7.858578e-005f, -2.002533e-003f, -2.099412e-003f,  1.099199e-003f,
    2.810134e-003f,  5.441461e-004f, -2.149986e-003f, -1.652391e-003f,  7.692704e-005f,  2.331138e-005f, -1.078744e-003f, -6.957495e-004f,
    7.568932e-004f,  1.181634e-003f,  2.334339e-004f, -4.743821e-004f, -2.871784e-004f,  1.321530e-004f,  2.399682e-004f,  2.836664e-004f,
    3.162935e-004f,  1.958265e-004f,  2.856314e-006f, -4.521835e-006f, -1.243528e-006f, -1.904270e-004f, -3.492923e-004f, -1.132150e-004f,
    2.846962e-004f,  3.644535e-004f,  9.686744e-005f, -8.528388e-005f, -2.966898e-005f,  3.609682e-005f, -4.734932e-005f, -1.164252e-004f,
   -4.524907e-005f,  8.261093e-005f,  1.259984e-004f,  8.566858e-005f,  8.864550e-006f, -5.990419e-005f, -8.239251e-005f, -3.510001e-005f,
    1.550072e-005f,  7.814642e-006f, -2.189935e-005f,  6.588054e-006f,  5.918064e-005f,  4.446989e-005f, -3.345618e-005f, -6.674824e-005f,
   -2.027505e-005f,  2.964590e-005f,  2.075689e-005f, -7.097957e-006f, -4.329077e-006f,  1.428518e-005f,  9.534097e-006f, -1.065411e-005f,
   -1.881528e-005f, -1.072055e-005f, -1.077890e-006f,  7.438586e-006f,  1.314623e-005f,  8.743800e-006f, -4.910633e-006f, -1.016153e-005f,
   -1.714235e-006f,  4.445737e-006f, -2.629638e-006f, -8.307590e-006f,  2.459519e-007f,  1.169671e-005f,  8.344337e-006f, -4.185330e-006f,
   -8.460374e-006f, -1.857231e-006f,  2.761883e-006f,  3.459078e-007f, -2.152076e-006f,  1.937840e-007f,  3.005883e-006f,  2.438071e-006f,
    1.790433e-008f, -1.522669e-006f, -2.137923e-006f, -1.575914e-006f,  3.894729e-007f,  2.067122e-006f,  1.208421e-006f, -7.077065e-007f,
   -7.046322e-007f,  8.612921e-007f,  7.950949e-007f, -1.114550e-006f, -1.818037e-006f, -4.184933e-008f,  1.585946e-006f,  1.026478e-006f,
   -4.215432e-007f, -6.507924e-007f,  3.315096e-008f,  2.429383e-007f, -1.882895e-007f, -3.781897e-007f, -1.052577e-007f,  2.294554e-007f,
    3.578858e-007f,  2.908266e-007f, -2.213869e-008f, -3.688831e-007f, -3.410128e-007f,  6.683921e-008f,  2.715862e-007f,  2.776582e-008f,
   -1.958706e-007f,  7.919430e-009f,  2.780905e-007f,  1.420935e-007f, -2.159855e-007f, -2.711114e-007f, -5.280979e-009f,  1.720339e-007f,
    8.203282e-008f, -4.265867e-008f, -2.938980e-008f,  3.560387e-008f,  2.975678e-008f, -1.830737e-008f, -5.001920e-008f, -4.905205e-008f,
   -1.265281e-008f,  5.164080e-008f,  7.401432e-008f,  1.325595e-008f, -5.784321e-008f, -4.102643e-008f,  2.533724e-008f,  3.230237e-008f,
   -2.440659e-008f, -4.163129e-008f,  1.161989e-008f,  5.218533e-008f,  2.123481e-008f, -2.836937e-008f, -3.099518e-008f,  3.094472e-010f,
    1.420840e-008f,  3.652125e-009f, -5.346500e-009f, -1.475766e-009f,  4.846121e-009f,  7.193668e-009f,  3.932707e-009f, -5.021511e-009f,
   -1.267032e-008f, -6.842862e-009f,  7.906857e-009f,  1.225012e-008f,  4.406081e-010f, -8.720899e-009f, -2.410618e-009f,  7.008269e-009f,
    3.406642e-009f, -6.630647e-009f, -7.021430e-009f,  2.209047e-009f,  7.083528e-009f,  2.653739e-009f, -2.856186e-009f, -2.749841e-009f,
    5.979417e-011f,  1.079616e-009f,  1.452980e-010f, -7.893636e-010f, -9.270029e-010f,  1.236516e-010f,  1.703637e-009f,  1.762539e-009f,
   -5.505650e-010f, -2.415445e-009f, -1.177952e-009f,  1.382633e-009f,  1.523129e-009f, -5.235905e-010f, -1.300670e-009f,  2.505675e-010f,
    1.388587e-009f,  3.688255e-010f, -1.113744e-009f, -9.614907e-010f,  2.406476e-010f,  7.650088e-010f,  2.930535e-010f, -2.137653e-010f,
   -2.408020e-010f, -7.159512e-012f,  1.591946e-010f,  1.155051e-010f, -1.497213e-010f, -3.278635e-010f, -8.640814e-011f,  3.539202e-010f,
    3.671301e-010f, -9.838697e-011f, -3.820569e-010f, -1.059516e-010f,  2.453789e-010f,  1.488888e-010f, -1.719004e-010f, -1.849369e-010f,
    9.130726e-011f,  2.182989e-010f,  4.636661e-011f, -1.372819e-010f, -1.163384e-010f,  1.172137e-011f,  7.068104e-011f,  1.367739e-006f,
    8.425504e-006f, -2.943557e-005f, -1.463831e-005f,  9.667713e-005f,  7.341919e-005f, -1.195291e-004f, -1.249383e-004f,  7.604683e-005f,
    3.757403e-005f, -2.063733e-004f, -1.412246e-004f,  1.440008e-004f,  1.397362e-004f,  2.032166e-005f,  1.666961e-004f,  1.319545e-004f,
   -4.479543e-004f, -8.411949e-004f, -5.111468e-004f, -1.136920e-004f, -8.866730e-005f,  4.020893e-005f,  2.867997e-004f,  1.711617e-004f,
    7.885553e-005f,  3.939416e-004f,  2.809974e-004f, -2.271944e-004f,  6.461312e-004f,  2.434371e-003f,  1.617117e-003f, -1.925517e-003f,
   -3.241126e-003f, -7.073296e-004f,  1.031518e-003f,  1.588350e-004f,  7.635221e-004f,  3.273267e-003f,  2.665446e-003f, -4.675011e-004f,
    1.272756e-004f,  2.733023e-003f, -6.955770e-004f, -7.182286e-003f, -5.237103e-003f,  2.016058e-003f, -4.223125e-004f, -1.296614e-002f,
   -1.863503e-002f, -9.358687e-003f,  4.155934e-003f,  1.056752e-002f,  8.576609e-003f,  1.128781e-004f, -1.066988e-002f, -1.436750e-002f,
   -7.621493e-003f, -1.723219e-003f, -5.405213e-003f, -8.966189e-003f, -1.740558e-003f,  7.328071e-003f,  5.465210e-003f, -8.498860e-004f,
    7.895773e-004f,  5.282929e-003f,  1.631599e-003f, -4.164740e-003f, -1.165981e-004f,  8.465558e-003f,  8.453227e-003f,  2.412633e-003f,
    1.986527e-003f,  6.014868e-003f,  4.803872e-003f, -7.287344e-004f, -2.056748e-003f,  7.481331e-004f,  1.531095e-003f,  1.085854e-003f,
    3.668244e-003f,  6.078314e-003f,  2.983762e-003f, -1.995008e-003f, -1.879794e-003f,  1.754683e-003f,  2.382987e-003f, -4.967624e-004f,
   -2.581413e-003f, -2.651960e-003f, -2.108548e-003f, -9.430323e-004f,  2.391461e-004f, -8.827855e-004f, -3.079326e-003f, -1.407562e-003f,
    3.692541e-003f,  4.705086e-003f, -8.741408e-004f, -5.056467e-003f, -1.840908e-003f,  3.100676e-003f,  2.360584e-003f, -1.198842e-003f,
   -7.409066e-004f,  2.398961e-003f,  1.922539e-003f, -2.118186e-003f, -3.853831e-003f, -1.358813e-003f,  1.364159e-003f,  1.248340e-003f,
   -5.549255e-004f, -1.821814e-003f, -1.720620e-003f, -5.496836e-004f,  4.921528e-004f,  9.410820e-005f, -1.241694e-003f, -1.541430e-003f,
   -3.789368e-004f,  4.605091e-004f, -1.189842e-004f, -1.123997e-003f, -1.417036e-003f, -1.142139e-003f, -9.795967e-004f, -1.354564e-003f,
   -2.124668e-003f, -2.326878e-003f, -1.318531e-003f, -4.028938e-004f, -1.258505e-003f, -2.768015e-003f, -2.388278e-003f, -5.596442e-004f,
    1.872080e-005f, -6.669278e-004f, -2.453665e-004f,  8.889888e-004f, -1.069510e-004f, -2.801276e-003f, -3.491190e-003f, -1.498015e-003f,
   -1.418335e-004f, -7.852503e-004f, -1.104464e-003f, -3.630455e-005f,  4.975201e-004f, -3.224572e-004f, -7.494026e-004f,  1.582142e-004f,
    1.303595e-003f,  1.983116e-003f,  2.532951e-003f,  2.796104e-003f,  2.485655e-003f,  2.271747e-003f,  2.457513e-003f,  2.166606e-003f,
    1.636738e-003f,  2.724558e-003f,  5.007730e-003f,  4.706467e-003f,  3.696141e-004f, -3.796201e-003f, -3.793380e-003f, -1.745130e-003f,
   -1.892460e-003f, -3.756099e-003f, -4.054627e-003f, -2.935040e-003f, -2.891891e-003f, -3.126324e-003f, -7.908586e-004f,  2.777388e-003f,
    2.997158e-003f, -3.451960e-004f, -2.006156e-003f,  9.925187e-004f,  5.495678e-003f,  7.383076e-003f,  6.016506e-003f,  2.419540e-003f,
   -2.266599e-003f, -5.352416e-003f, -4.320154e-003f, -1.072166e-003f, -3.756762e-005f, -1.676875e-003f, -2.645640e-003f, -2.079615e-003f,
   -2.089885e-003f, -2.501195e-003f, -1.342193e-003f, -8.377879e-005f, -1.846533e-003f, -4.977178e-003f, -5.065286e-003f, -2.503203e-003f,
   -1.309109e-003f, -1.671971e-003f, -6.104196e-004f,  1.363838e-003f,  1.247466e-003f, -1.477720e-004f,  5.237119e-004f,  2.936647e-003f,
    3.980710e-003f,  3.151624e-003f,  2.111519e-003f,  1.068030e-003f, -2.532894e-004f, -6.734791e-004f,  1.300420e-004f,  4.402120e-004f,
   -1.801735e-004f, -6.035594e-005f,  8.396389e-004f,  6.539474e-004f, -4.051731e-004f, -4.196583e-004f,  1.269913e-004f, -5.708434e-004f,
   -1.531235e-003f, -9.148645e-004f, -2.303811e-004f, -1.547654e-003f, -2.892903e-003f, -1.444546e-003f,  1.309176e-003f,  2.168389e-003f,
    1.153217e-003f,  1.195644e-004f, -4.399529e-004f, -4.939076e-004f,  2.179293e-004f,  4.087769e-004f, -1.503237e-003f, -4.032157e-003f,
   -4.490592e-003f, -3.262473e-003f, -2.064117e-003f, -3.423704e-004f,  2.111088e-003f,  2.573517e-003f,  7.823596e-005f, -1.929115e-003f,
   -1.914973e-003f, -3.145180e-003f, -6.094030e-003f, -5.669889e-003f, -6.743930e-004f,  2.454161e-003f,  2.385195e-004f, -2.254186e-003f,
   -1.045443e-003f,  5.407920e-004f, -3.744771e-004f, -1.153649e-003f, -2.161011e-004f, -4.340813e-004f, -2.991658e-003f, -5.170043e-003f,
   -5.591883e-003f, -4.997519e-003f, -2.444004e-003f,  2.573046e-003f,  6.171884e-003f,  4.651542e-003f,  1.558378e-004f, -3.276888e-003f,
   -4.713781e-003f, -3.550958e-003f,  1.274421e-003f,  5.846078e-003f,  3.900837e-003f, -1.995910e-003f, -2.435355e-003f,  2.961128e-003f,
    4.138341e-003f, -1.719966e-003f, -4.896065e-003f,  1.002447e-004f,  6.026216e-003f,  6.117532e-003f,  3.263171e-003f,  1.262693e-003f,
   -1.559879e-003f, -5.575495e-003f, -6.564868e-003f, -2.821628e-003f,  2.110337e-003f,  5.254677e-003f,  6.444857e-003f,  5.582866e-003f,
    3.381540e-003f,  2.453399e-003f,  2.954989e-003f,  1.361383e-003f, -2.571236e-003f, -3.860758e-003f, -9.647085e-004f,  1.188296e-003f,
    2.264490e-004f, -1.169110e-004f,  1.555124e-003f,  1.566043e-003f, -5.963109e-004f, -8.498770e-004f,  9.937355e-004f,  1.074833e-003f,
    1.623677e-004f,  2.026835e-003f,  4.041170e-003f,  9.614504e-004f, -3.562280e-003f, -1.914536e-003f,  3.071347e-003f,  2.332403e-003f,
   -2.733856e-003f, -2.461442e-003f,  3.376877e-003f,  5.116458e-003f,  4.802184e-004f, -2.344483e-003f, -5.752423e-005f,  1.096199e-003f,
   -1.739797e-003f, -2.886576e-003f,  7.232697e-004f,  3.673981e-003f,  1.463699e-003f, -2.094883e-003f, -1.177104e-003f,  3.391497e-003f,
    5.680941e-003f,  2.848871e-003f, -9.626025e-004f,  7.092142e-005f,  4.885399e-003f,  5.835958e-003f,  4.709961e-005f, -4.585979e-003f,
   -7.959620e-004f,  5.709922e-003f,  4.625618e-003f, -2.095527e-003f, -3.641527e-003f,  1.153595e-003f,  2.174801e-003f, -3.989409e-003f,
   -7.934252e-003f, -3.248648e-003f,  3.531193e-003f,  4.492210e-003f,  2.027691e-003f,  2.337011e-003f,  4.734948e-003f,  4.365851e-003f,
    8.446866e-004f, -1.937893e-003f, -2.296606e-003f, -2.446934e-003f, -4.314894e-003f, -6.520022e-003f, -6.374666e-003f, -4.090861e-003f,
   -3.327581e-003f, -6.134503e-003f, -8.995822e-003f, -7.045879e-003f, -1.038687e-003f,  4.032688e-003f,  6.311946e-003f,  7.975197e-003f,
    9.304876e-003f,  7.800577e-003f,  3.696247e-003f,  7.130294e-004f,  3.212190e-004f,  1.723828e-004f, -1.000313e-003f, -1.456174e-003f,
   -5.688451e-005f,  2.015445e-003f,  3.344729e-003f,  3.121084e-003f,  7.828554e-004f, -2.398404e-003f, -3.147773e-003f, -5.338843e-004f,
    1.757174e-003f,  5.216622e-004f, -2.132542e-003f, -2.280256e-003f, -3.109461e-005f,  1.480888e-003f,  1.037387e-003f,  1.221392e-004f,
   -1.274564e-004f, -3.063508e-004f, -1.292441e-003f, -2.595009e-003f, -2.515850e-003f, -3.884782e-004f,  1.667804e-003f,  1.018735e-003f,
   -1.476606e-003f, -2.473570e-003f, -1.283577e-003f, -2.908655e-004f,  1.144827e-004f,  2.286679e-003f,  5.972194e-003f,  7.346598e-003f,
    5.125337e-003f,  2.805365e-003f,  3.039374e-003f,  4.277707e-003f,  4.450879e-003f,  3.682045e-003f,  2.369942e-003f,  7.188935e-004f,
    4.061090e-004f,  2.437789e-003f,  3.862160e-003f,  1.419971e-003f, -2.395194e-003f, -2.305321e-003f,  1.494872e-003f,  3.771574e-003f,
    2.526222e-003f,  1.031311e-003f,  1.472114e-003f,  2.122546e-003f,  1.650722e-003f,  1.399882e-003f,  2.204389e-003f,  2.789694e-003f,
    2.420821e-003f,  2.042264e-003f,  1.969957e-003f,  1.126496e-003f, -6.775016e-004f, -1.930327e-003f, -1.614978e-003f, -5.394265e-004f,
    6.897160e-005f,  3.728132e-005f, -4.666388e-005f,  2.384365e-004f,  6.336111e-004f,  3.155153e-004f, -9.564513e-004f, -1.836165e-003f,
   -1.011017e-003f,  1.038398e-004f, -1.149065e-003f, -3.844525e-003f, -3.688098e-003f,  2.561129e-004f,  3.146033e-003f,  1.435185e-003f,
   -1.869618e-003f, -2.501483e-003f, -1.091168e-003f, -1.224852e-004f,  5.695028e-004f,  1.162520e-003f, -8.486624e-005f, -2.291501e-003f,
   -1.856331e-003f, -2.475936e-004f, -3.059938e-003f, -7.536699e-003f, -3.113151e-003f,  9.553113e-003f,  1.443554e-002f,  4.157423e-003f,
   -6.844646e-003f, -4.818262e-003f,  2.769150e-003f,  2.967281e-003f, -1.205568e-003f, -7.661226e-004f,  1.352292e-003f, -1.043988e-003f,
   -3.033777e-003f,  9.979216e-004f,  4.069870e-003f, -7.888671e-004f, -6.045817e-003f, -2.823811e-003f,  2.762719e-003f,  1.204605e-003f,
   -3.467124e-003f, -2.886200e-003f, -1.725351e-004f, -2.305827e-003f, -5.781984e-003f, -3.435835e-003f,  1.875869e-003f,  2.567041e-003f,
   -6.390929e-004f, -1.329534e-003f,  1.461899e-003f,  3.118280e-003f,  1.407560e-003f, -1.308640e-003f, -1.984562e-003f, -3.094593e-006f,
    2.232448e-003f,  1.572502e-003f, -1.448413e-003f, -2.504813e-003f,  3.635754e-006f,  1.998782e-003f,  3.263404e-004f, -2.157642e-003f,
   -1.819258e-003f,  6.401320e-005f,  8.415714e-004f,  1.143598e-003f,  1.865969e-003f,  9.019318e-004f, -2.601366e-003f, -4.392121e-003f,
   -4.467922e-004f,  6.020445e-003f,  7.701525e-003f,  2.930738e-003f, -2.012260e-003f, -1.650241e-003f,  1.343058e-003f,  9.237489e-004f,
   -2.784445e-003f, -4.133741e-003f, -1.398967e-003f,  8.511345e-004f, -2.587757e-004f, -2.197613e-003f, -3.012323e-003f, -4.176940e-003f,
   -5.331244e-003f, -3.132578e-003f,  2.249200e-003f,  5.928192e-003f,  5.269432e-003f,  2.135016e-003f, -1.774596e-003f, -5.476099e-003f,
   -6.166025e-003f, -3.046256e-003f, -9.060817e-004f, -2.930814e-003f, -4.538185e-003f, -1.678049e-003f,  1.257201e-003f, -1.947660e-004f,
   -2.257412e-003f, -1.334069e-003f, -1.481690e-003f, -5.079761e-003f, -6.530884e-003f, -3.376456e-003f, -1.903194e-003f, -4.250404e-003f,
   -3.498899e-003f,  1.420362e-003f,  1.414625e-003f, -5.121097e-003f, -7.182484e-003f, -9.717287e-004f,  2.691570e-003f, -1.875812e-003f,
   -5.773113e-003f, -3.074690e-003f, -5.068816e-004f, -2.699215e-003f, -4.066478e-003f, -1.306122e-003f,  8.734096e-004f,  4.948258e-004f,
    1.049960e-003f,  1.959796e-003f, -4.421771e-004f, -3.048420e-003f, -1.861164e-004f,  4.695060e-003f,  4.298136e-003f,  5.231003e-004f,
   -1.496972e-004f,  9.068250e-004f, -1.261757e-003f, -4.447381e-003f, -4.187602e-003f, -2.943928e-003f, -4.144616e-003f, -4.288696e-003f,
   -3.246985e-004f,  2.821204e-003f,  6.611158e-004f, -2.603949e-003f, -1.756155e-003f,  9.992749e-004f,  1.619056e-003f,  1.140682e-003f,
    1.792491e-003f,  2.558743e-003f,  2.521168e-003f,  3.138804e-003f,  4.751869e-003f,  5.297261e-003f,  3.443717e-003f, -1.923150e-004f,
   -3.922979e-003f, -4.913768e-003f, -1.437187e-003f,  3.108165e-003f,  3.272798e-003f, -3.097453e-004f, -2.237092e-003f, -1.943800e-003f,
   -3.595968e-003f, -6.412080e-003f, -5.256645e-003f, -1.291255e-003f, -9.549438e-004f, -3.829215e-003f, -3.392383e-003f, -3.345627e-004f,
   -2.080361e-003f, -7.719024e-003f, -7.044211e-003f,  2.437377e-003f,  1.020962e-002f,  8.344799e-003f,  1.557061e-003f, -2.034459e-003f,
   -8.949583e-004f,  2.319647e-003f,  5.267827e-003f,  5.624756e-003f,  2.557324e-003f, -5.542820e-004f, -4.850523e-005f,  2.296713e-003f,
    2.487110e-003f,  8.227898e-004f, -1.740846e-004f, -1.053192e-003f, -2.946623e-003f, -3.443495e-003f, -7.404246e-004f,  1.905273e-003f,
    1.350113e-003f, -3.696025e-005f,  6.583274e-004f,  1.344952e-003f, -4.086249e-004f, -2.213088e-003f, -1.531478e-003f, -3.590113e-004f,
   -4.372607e-004f,  6.248918e-004f,  3.759694e-003f,  4.918579e-003f,  1.951169e-003f, -9.231609e-004f, -2.484377e-004f,  9.468271e-004f,
   -7.661964e-004f, -3.059649e-003f, -2.441993e-003f, -1.467223e-004f,  6.863275e-004f, -1.894062e-004f, -1.039493e-003f, -6.752932e-004f,
    1.098434e-003f,  2.691002e-003f,  1.358561e-003f, -2.060369e-003f, -2.131863e-003f,  2.902709e-003f,  6.426236e-003f,  3.112564e-003f,
   -2.068187e-003f, -2.035385e-003f,  8.533337e-004f,  1.925656e-004f, -2.952167e-003f, -3.433259e-003f, -2.016054e-003f, -2.378070e-003f,
   -2.782478e-003f, -2.042879e-004f,  1.934398e-003f, -4.480224e-004f, -3.365061e-003f, -1.268168e-003f,  2.555184e-003f,  1.806997e-003f,
   -1.236749e-003f, -2.295642e-004f,  3.004403e-003f,  1.544028e-003f, -3.563649e-003f, -4.158985e-003f,  1.188237e-003f,  4.227175e-003f,
    1.066924e-004f, -5.004291e-003f, -3.582645e-003f,  2.112443e-003f,  4.291388e-003f,  1.520033e-003f, -3.233216e-004f,  1.595352e-003f,
    2.616317e-003f, -1.044265e-003f, -5.317164e-003f, -4.359976e-003f,  4.545191e-004f,  3.160498e-003f,  2.157926e-003f,  8.613984e-004f,
    1.052937e-003f,  1.193227e-003f,  6.448796e-004f,  5.421631e-004f,  5.888822e-004f, -7.569952e-004f, -2.791242e-003f, -2.784321e-003f,
   -8.878943e-005f,  2.587695e-003f,  2.591290e-003f,  3.908702e-004f, -1.419938e-003f, -1.502594e-003f, -1.191850e-003f, -1.985113e-003f,
   -2.802852e-003f, -1.840210e-003f, -1.990276e-004f, -2.989424e-004f, -1.214625e-003f,  8.822002e-005f,  3.033545e-003f,  3.818290e-003f,
    1.513840e-003f, -1.224582e-003f, -3.119828e-003f, -4.630648e-003f, -4.440799e-003f, -1.442590e-003f,  1.276123e-003f,  3.943496e-004f,
   -1.914717e-003f, -2.067221e-003f, -1.350282e-003f, -1.970883e-003f, -1.675054e-003f,  9.035317e-004f,  1.336213e-003f, -2.811820e-003f,
   -5.786571e-003f, -2.898339e-003f,  1.097682e-003f,  5.779778e-004f, -1.701583e-003f, -1.671608e-003f, -1.960636e-003f, -4.902634e-003f,
   -5.942468e-003f, -1.963596e-003f,  1.819945e-003f,  5.953044e-004f, -2.137322e-003f, -1.738435e-003f,  6.356760e-006f, -8.546924e-005f,
   -1.108192e-003f, -1.794289e-003f, -3.005467e-003f, -3.801221e-003f, -1.689503e-003f,  1.703581e-003f,  1.854410e-003f, -1.085540e-003f,
   -2.208873e-003f,  5.348856e-004f,  4.055963e-003f,  5.034494e-003f,  3.044416e-003f, -1.275184e-004f, -1.942472e-003f, -1.848293e-003f,
   -2.622927e-003f, -5.445768e-003f, -5.890171e-003f, -9.387711e-004f,  3.556073e-003f,  1.030854e-003f, -4.160589e-003f, -3.728064e-003f,
    1.701808e-004f, -4.656448e-004f, -4.486660e-003f, -4.224736e-003f,  1.931119e-004f,  2.069143e-003f,  7.575417e-004f,  9.466511e-004f,
    2.324109e-003f,  1.014055e-003f, -1.922824e-003f, -2.911156e-003f, -2.658919e-003f, -2.705162e-003f, -7.949768e-004f,  3.476527e-003f,
    5.243079e-003f,  2.553374e-003f,  3.264877e-004f,  1.343036e-003f,  1.848579e-003f, -1.321072e-004f, -1.384058e-003f, -1.058347e-003f,
   -1.955564e-003f, -2.983272e-003f, -4.798132e-004f,  3.029772e-003f,  1.972953e-003f, -1.773869e-003f, -2.221875e-003f, -1.319152e-004f,
    3.525576e-004f,  1.211705e-003f,  5.160108e-003f,  6.802922e-003f,  1.477011e-003f, -3.728097e-003f, -4.077418e-004f,  6.526703e-003f,
    6.899951e-003f,  1.052400e-003f, -3.600984e-003f, -4.546740e-003f, -3.115235e-003f,  5.150119e-004f,  3.484598e-003f,  7.694036e-004f,
   -4.601294e-003f, -3.241011e-003f,  4.221445e-003f,  6.467636e-003f,  1.269396e-003f, -5.458549e-004f,  4.298040e-003f,  5.154392e-003f,
   -1.996902e-003f, -6.104162e-003f, -8.740510e-004f,  4.343259e-003f,  1.593262e-003f, -3.656333e-003f, -4.971386e-003f, -4.681376e-003f,
   -4.781704e-003f, -2.152255e-003f,  1.811393e-003f,  3.712422e-004f, -5.372519e-003f, -5.794429e-003f,  1.063375e-003f,  5.751630e-003f,
    3.265518e-003f, -2.183672e-004f,  9.703920e-005f,  6.702197e-004f, -9.432157e-004f, -1.033465e-003f,  1.665892e-003f,  2.263952e-003f,
   -1.085009e-003f, -2.853757e-003f,  5.620263e-004f,  4.501285e-003f,  3.723315e-003f,  6.397964e-004f,  6.442713e-004f,  3.139166e-003f,
    2.916876e-003f, -9.770996e-004f, -3.336007e-003f, -8.658220e-004f,  2.521180e-003f,  1.807741e-003f, -1.139592e-003f, -8.005780e-004f,
    2.552433e-003f,  3.071496e-003f, -6.941178e-004f, -2.837109e-003f,  4.988700e-004f,  4.801243e-003f,  4.133942e-003f, -1.735627e-004f,
   -2.154096e-003f,  3.456573e-004f,  3.751199e-003f,  3.827849e-003f, -1.011308e-004f, -5.189219e-003f, -7.639286e-003f, -5.775274e-003f,
   -1.421059e-003f,  1.912222e-003f,  2.063019e-003f, -5.733854e-004f, -3.685964e-003f, -4.468826e-003f, -1.973407e-003f,  1.335591e-003f,
    2.006354e-003f, -9.087186e-005f, -1.907839e-003f, -1.778138e-003f, -1.140931e-003f, -1.284996e-003f, -1.393934e-003f, -8.611624e-004f,
   -8.077268e-004f, -1.916965e-003f, -2.904874e-003f, -2.427819e-003f, -8.169338e-004f,  1.050675e-003f,  2.904730e-003f,  4.047115e-003f,
    2.895473e-003f, -7.360585e-004f, -4.044929e-003f, -4.081738e-003f, -1.756805e-003f, -5.431646e-004f, -1.114530e-003f, -6.255719e-004f,
    1.488131e-003f,  1.298688e-003f, -2.818616e-003f, -5.468715e-003f, -1.558317e-003f,  5.019427e-003f,  6.486238e-003f,  2.583037e-003f,
   -3.192019e-004f,  1.056989e-004f,  2.589000e-004f, -1.126099e-003f, -9.676530e-004f,  1.248961e-003f,  2.008021e-003f,  4.202935e-004f,
   -2.741471e-004f,  1.024868e-003f,  1.556737e-003f,  1.626532e-004f, -1.090692e-003f, -1.339992e-003f, -1.774385e-003f, -1.820852e-003f,
    4.370711e-004f,  3.793943e-003f,  4.592466e-003f,  2.159520e-003f, -4.439625e-004f, -1.123955e-003f, -6.661608e-004f, -1.420090e-004f,
    4.280635e-004f,  8.705854e-004f,  6.696656e-004f, -1.304054e-004f, -1.056711e-003f, -1.466162e-003f, -3.052130e-004f,  2.513754e-003f,
    4.311593e-003f,  2.123391e-003f, -2.399569e-003f, -4.022279e-003f, -1.114830e-003f,  1.796388e-003f,  6.196187e-004f, -2.597680e-003f,
   -3.298162e-003f, -1.003210e-003f,  9.715800e-004f,  6.909886e-004f, -6.429922e-004f, -1.271725e-003f, -6.185212e-004f,  1.057159e-003f,
    2.672077e-003f,  2.607434e-003f,  8.348940e-004f, -2.195375e-004f,  1.061823e-003f,  2.711483e-003f,  2.157791e-003f,  4.203177e-004f,
    1.285994e-004f,  8.583994e-004f,  3.633524e-004f, -7.316733e-004f,  6.384669e-005f,  2.116865e-003f,  2.346260e-003f,  5.571208e-004f,
   -4.871611e-004f, -7.996591e-005f, -9.346737e-005f, -6.795041e-004f,  5.987854e-005f,  2.141635e-003f,  3.435075e-003f,  3.080855e-003f,
    1.851891e-003f,  1.019146e-004f, -1.595396e-003f, -1.520199e-003f,  5.019875e-004f,  1.796248e-003f,  9.377285e-004f,  1.058371e-004f,
    7.972909e-004f,  1.103814e-003f,  2.029089e-005f, -1.567621e-005f,  2.007374e-003f,  2.870258e-003f,  5.048910e-004f, -2.153468e-003f,
   -1.903726e-003f,  1.318517e-005f,  7.465415e-004f,  5.900266e-005f, -4.336632e-004f,  2.892269e-004f,  1.933451e-003f,  2.772604e-003f,
    1.057773e-003f, -1.685465e-003f, -1.436216e-003f,  1.917088e-003f,  3.136968e-003f, -1.169386e-004f, -2.786323e-003f, -5.848589e-004f,
    2.826355e-003f,  2.261441e-003f, -5.534915e-004f, -9.518015e-004f,  6.546556e-004f,  6.912496e-004f, -1.025181e-003f, -1.863616e-003f,
   -9.827657e-004f,  4.958304e-004f,  1.671830e-003f,  1.817511e-003f,  5.899009e-004f, -5.084210e-004f,  2.675742e-004f,  1.576921e-003f,
    6.777284e-004f, -1.764305e-003f, -2.381734e-003f, -4.032668e-004f,  1.511855e-003f,  1.587175e-003f,  8.000908e-004f,  6.175435e-004f,
    1.342332e-003f,  2.268099e-003f,  1.934581e-003f, -6.396037e-004f, -3.997119e-003f, -5.274449e-003f, -3.892036e-003f, -2.145927e-003f,
   -1.771923e-003f, -2.279751e-003f, -2.859408e-003f, -3.395761e-003f, -3.314401e-003f, -1.691637e-003f,  1.078082e-003f,  3.225636e-003f,
    3.409542e-003f,  1.926961e-003f,  3.542794e-004f, -3.450281e-005f,  1.860897e-004f, -3.742907e-004f, -1.082652e-003f, -1.301180e-004f,
    1.069482e-003f, -1.169304e-003f, -5.682964e-003f, -6.340630e-003f, -2.090307e-003f,  2.422291e-004f, -2.369333e-003f, -3.262183e-003f,
    1.909934e-003f,  6.543876e-003f,  4.562783e-003f,  1.243929e-003f,  2.879089e-003f,  4.587343e-003f, -3.102413e-004f, -6.746871e-003f,
   -5.994350e-003f, -7.397892e-004f,  2.824017e-004f, -2.641771e-003f, -2.705594e-003f,  1.155245e-004f,  1.482825e-004f, -2.478986e-003f,
   -2.365473e-003f,  8.243909e-004f,  2.000706e-003f, -3.948329e-004f, -2.799499e-003f, -2.898529e-003f, -1.396525e-003f,  1.065497e-003f,
    3.542437e-003f,  3.408719e-003f,  6.922689e-005f, -2.364574e-003f, -4.917314e-004f,  2.935927e-003f,  3.241278e-003f,  7.657522e-004f,
   -7.417763e-004f, -2.312852e-004f,  4.898816e-004f,  8.292652e-004f,  1.630051e-003f,  2.633755e-003f,  3.000267e-003f,  3.107421e-003f,
    3.212165e-003f,  2.059519e-003f, -5.366718e-004f, -1.831953e-003f, -5.748194e-006f,  2.092401e-003f,  6.974020e-004f, -2.825249e-003f,
   -3.678443e-003f, -7.466666e-004f,  1.958120e-003f,  1.297251e-003f, -9.648816e-004f, -1.276335e-003f,  8.846695e-004f,  2.748054e-003f,
    1.871072e-003f, -9.232339e-004f, -2.428878e-003f, -1.011627e-003f,  1.072718e-003f,  6.546888e-004f, -1.820719e-003f, -3.129590e-003f,
   -2.217516e-003f, -1.150607e-003f, -9.300137e-004f,  8.407835e-005f,  2.589450e-003f,  4.457038e-003f,  3.811607e-003f,  1.427298e-003f,
   -1.000052e-003f, -2.718805e-003f, -3.354565e-003f, -2.483729e-003f, -3.467436e-004f,  2.135728e-003f,  3.740690e-003f,  2.974533e-003f,
   -3.242855e-004f, -2.928079e-003f, -1.116905e-003f,  3.336215e-003f,  4.411352e-003f,  6.185627e-004f, -2.687562e-003f, -1.931639e-003f,
   -2.724295e-004f, -9.146862e-004f, -1.808539e-003f, -9.302546e-004f, -6.554225e-004f, -2.414390e-003f, -2.842259e-003f,  8.365510e-005f,
    2.598721e-003f,  1.514681e-003f, -2.786530e-004f,  5.694607e-004f,  1.762625e-003f, -1.164797e-004f, -3.236984e-003f, -3.704595e-003f,
   -1.876384e-003f, -9.404560e-004f, -1.577694e-003f, -1.952976e-003f, -1.295746e-003f, -2.164040e-004f,  1.279462e-003f,  3.245806e-003f,
    4.047084e-003f,  1.833420e-003f, -2.160239e-003f, -4.100685e-003f, -2.285058e-003f,  4.529076e-004f,  7.300947e-004f, -5.596537e-004f,
   -5.493734e-005f,  2.483740e-003f,  3.949212e-003f,  3.014610e-003f,  1.562201e-003f,  7.234483e-004f, -3.998236e-004f, -1.579141e-003f,
   -1.270589e-003f, -8.836076e-005f, -2.185026e-004f, -1.168514e-003f, -4.848726e-004f,  1.488278e-003f,  2.086089e-003f,  9.299287e-004f,
   -3.689961e-004f, -1.717387e-003f, -3.331713e-003f, -3.356784e-003f, -1.194094e-003f,  1.172048e-004f, -6.812540e-004f, -1.538798e-005f,
    3.324070e-003f,  4.232846e-003f,  3.851309e-004f, -2.055784e-003f,  1.145237e-003f,  3.997224e-003f,  6.218248e-004f, -3.878527e-003f,
   -2.114982e-003f,  3.083974e-003f,  4.464429e-003f,  2.489641e-003f,  2.241932e-003f,  3.452211e-003f,  2.644350e-003f,  1.001729e-003f,
    1.957497e-003f,  4.189440e-003f,  3.790613e-003f,  7.713106e-004f, -1.847822e-003f, -2.869325e-003f, -2.781140e-003f, -1.355799e-003f,
    1.263616e-003f,  3.209609e-003f,  3.126854e-003f,  2.126049e-003f,  1.922786e-003f,  2.408535e-003f,  2.212489e-003f,  8.678085e-004f,
   -4.757089e-004f, -6.719385e-004f, -3.787826e-004f, -9.146330e-004f, -1.458735e-003f, -1.114983e-004f,  1.778456e-003f,  5.155713e-004f,
   -3.304906e-003f, -4.357381e-003f, -1.138338e-003f,  1.192437e-003f, -3.128759e-004f, -1.570915e-003f,  4.207990e-004f,  1.926889e-003f,
   -1.082436e-004f, -1.931634e-003f,  3.480023e-004f,  3.991348e-003f,  4.373261e-003f,  1.411001e-003f, -2.064669e-003f, -3.601296e-003f,
   -1.455488e-003f,  3.144911e-003f,  4.599308e-003f, -1.729754e-006f, -4.465980e-003f, -1.698682e-003f,  4.679622e-003f,  5.866887e-003f,
    1.833091e-003f, -2.589793e-004f,  1.217860e-003f,  1.583257e-003f, -2.281557e-004f, -7.332260e-004f,  5.974100e-004f,  1.175282e-003f,
    8.218507e-004f,  7.304200e-004f, -2.570135e-004f, -2.608991e-003f, -3.269083e-003f, -9.847403e-004f,  3.539192e-004f, -1.532123e-003f,
   -2.762049e-003f, -3.198230e-004f,  2.034954e-003f, -8.750193e-005f, -4.498415e-003f, -5.966850e-003f, -3.251404e-003f,  8.188281e-004f,
    3.313528e-003f,  3.035638e-003f,  7.285157e-004f, -1.426573e-003f, -1.941848e-003f, -1.252900e-003f, -3.179728e-005f,  1.606092e-003f,
    2.413501e-003f,  8.502037e-004f, -1.473316e-003f, -1.188503e-003f,  1.216160e-003f,  1.712645e-003f, -7.508461e-004f, -2.959266e-003f,
   -3.017791e-003f, -2.224242e-003f, -1.408582e-003f, -3.914900e-004f, -4.598041e-004f, -2.422963e-003f, -3.566659e-003f, -1.546124e-003f,
    9.000097e-004f,  4.191041e-004f, -7.714901e-004f,  8.966043e-004f,  3.278069e-003f,  2.353366e-003f,  1.285547e-005f,  7.685333e-004f,
    3.180327e-003f,  2.061540e-003f, -2.292068e-003f, -4.385850e-003f, -2.500219e-003f, -6.266287e-004f, -1.121131e-003f, -1.596899e-003f,
   -4.147344e-004f,  1.389158e-004f, -1.575381e-003f, -3.104659e-003f, -1.976615e-003f, -5.002956e-005f, -4.511943e-004f, -2.384734e-003f,
   -2.659297e-003f, -9.897813e-004f,  9.914191e-005f, -1.065084e-004f, -6.307620e-005f,  1.702214e-004f, -1.016517e-003f, -2.740593e-003f,
   -2.261119e-003f, -2.004679e-004f, -2.489664e-004f, -2.643912e-003f, -3.021116e-003f,  5.580350e-004f,  4.303957e-003f,  4.605060e-003f,
    2.884792e-003f,  2.107080e-003f,  2.157946e-003f,  1.394490e-003f,  7.636692e-005f, -2.909450e-004f,  4.833526e-004f,  1.195219e-003f,
    1.042923e-003f,  4.032336e-004f, -1.910492e-004f, -1.203158e-003f, -3.100079e-003f, -4.062638e-003f, -1.142193e-003f,  4.585102e-003f,
    7.116183e-003f,  3.093110e-003f, -2.734813e-003f, -3.879415e-003f, -8.923099e-004f,  1.235035e-003f,  1.257862e-003f,  1.350805e-003f,
    1.435920e-003f,  1.513844e-004f, -8.864978e-004f,  2.126017e-004f,  1.184643e-003f, -3.918266e-004f, -1.780885e-003f,  2.860138e-004f,
    3.081648e-003f,  2.294364e-003f, -2.958567e-004f,  8.655038e-006f,  2.831218e-003f,  4.026980e-003f,  2.441849e-003f, -1.009918e-004f,
   -2.903459e-003f, -5.418798e-003f, -5.053325e-003f, -9.707425e-004f,  2.606908e-003f,  1.765231e-003f, -9.811339e-004f, -8.156360e-004f,
    1.415922e-003f,  7.935166e-004f, -3.187733e-003f, -5.313959e-003f, -2.731682e-003f,  4.477437e-004f, -6.320907e-004f, -4.026975e-003f,
   -3.914378e-003f,  2.523378e-004f,  2.779787e-003f,  8.643959e-004f, -9.928764e-004f,  1.059207e-003f,  3.329167e-003f,  1.055547e-003f,
   -2.803279e-003f, -2.290986e-003f,  1.327683e-003f,  2.030025e-003f, -3.708506e-004f, -5.984817e-004f,  2.037782e-003f,  2.690464e-003f,
    3.309490e-004f, -4.574578e-004f,  1.731524e-003f,  2.592524e-003f,  3.046439e-004f, -1.227349e-003f,  1.393835e-004f,  9.076574e-004f,
   -1.357820e-003f, -3.460378e-003f, -2.250303e-003f,  2.772706e-005f, -2.381589e-004f, -2.342335e-003f, -3.116542e-003f, -1.946956e-003f,
   -8.480708e-004f, -9.034203e-004f, -1.011256e-003f,  1.120056e-004f,  1.872921e-003f,  2.109431e-003f, -2.201805e-004f, -2.873617e-003f,
   -2.428046e-003f,  8.860105e-004f,  2.611271e-003f, -1.541102e-004f, -4.450144e-003f, -5.241639e-003f, -2.110178e-003f,  6.032737e-004f,
    6.532845e-006f, -1.761301e-003f, -1.246845e-003f,  1.019710e-003f,  1.433206e-003f, -8.712567e-004f, -2.364353e-003f, -8.098562e-004f,
    7.513804e-004f, -9.367357e-004f, -3.324243e-003f, -2.091487e-003f,  1.173560e-003f,  1.663473e-003f,  6.417663e-005f,  1.067966e-003f,
    3.928449e-003f,  2.988033e-003f, -1.917075e-003f, -4.411623e-003f, -2.335389e-003f, -7.612269e-004f, -2.312886e-003f, -3.178092e-003f,
   -1.226265e-003f,  2.627163e-004f, -3.969703e-004f, -4.090092e-004f,  1.042460e-003f,  9.333710e-004f, -1.077118e-003f, -1.514747e-003f,
    8.020672e-005f,  2.442293e-004f, -1.561769e-003f, -2.055448e-003f, -4.979454e-004f,  6.049843e-004f,  8.853658e-004f,  1.840978e-003f,
    2.274305e-003f,  4.079145e-004f, -1.211008e-003f,  4.697926e-004f,  2.538130e-003f,  4.545057e-004f, -3.468340e-003f, -3.283290e-003f,
    7.460912e-004f,  2.860639e-003f,  1.242149e-003f, -2.253515e-004f,  5.722508e-004f,  9.353989e-004f, -1.241217e-003f, -3.586554e-003f,
   -2.539384e-003f,  1.755993e-003f,  5.263437e-003f,  4.390960e-003f,  7.098838e-005f, -3.172818e-003f, -2.620409e-003f, -4.502690e-004f,
   -2.788462e-004f, -2.249037e-003f, -3.445729e-003f, -1.990134e-003f,  1.116867e-003f,  3.483563e-003f,  3.514871e-003f,  1.812626e-003f,
    6.580548e-004f,  1.114952e-003f,  1.327935e-003f, -4.999481e-004f, -2.621628e-003f, -2.074754e-003f,  4.282052e-004f,  1.358503e-003f,
   -2.253606e-004f, -1.617906e-003f, -1.032432e-003f,  4.523828e-005f, -6.145210e-005f, -4.753723e-004f,  3.849661e-004f,  1.858553e-003f,
    1.791599e-003f, -1.110723e-004f, -1.417117e-003f, -3.565066e-004f,  1.177540e-003f, -1.421286e-005f, -3.518370e-003f, -5.331297e-003f,
   -3.318375e-003f, -6.839973e-005f,  9.119136e-004f, -3.801269e-004f, -1.427152e-003f, -9.408694e-004f,  1.427511e-004f,  6.521707e-004f,
    6.468720e-004f,  6.462022e-004f,  2.072693e-004f, -1.536003e-003f, -3.638613e-003f, -3.484699e-003f, -6.503523e-004f,  1.532836e-003f,
    7.890676e-004f, -2.729416e-004f,  1.195446e-003f,  2.626911e-003f,  1.279616e-004f, -4.104377e-003f, -4.477733e-003f, -7.012583e-004f,
    2.209689e-003f,  1.746845e-003f,  1.458367e-004f, -5.403418e-004f, -6.335879e-004f, -5.967404e-004f, -4.866838e-004f, -8.032289e-004f,
   -1.290592e-003f, -7.516932e-004f,  1.994516e-004f, -6.914292e-004f, -2.924054e-003f, -3.061021e-003f, -4.114568e-004f,  1.633666e-003f,
    1.394605e-003f,  1.272868e-003f,  2.828288e-003f,  4.049453e-003f,  3.071089e-003f,  8.500292e-004f, -8.831922e-004f, -1.419228e-003f,
   -6.809452e-004f,  6.382725e-004f,  1.157508e-003f,  6.173382e-004f,  1.927031e-004f,  1.832551e-004f, -2.976098e-004f, -1.071460e-003f,
   -1.235004e-003f, -1.316823e-003f, -1.820533e-003f, -1.103018e-003f,  1.378705e-003f,  2.203090e-003f, -8.011256e-004f, -3.529592e-003f,
   -1.466953e-003f,  2.510432e-003f,  2.362331e-003f, -1.743115e-003f, -4.340441e-003f, -2.976427e-003f, -3.714989e-004f,  4.375986e-004f,
   -6.653895e-004f, -1.754766e-003f, -1.282649e-003f, -2.067191e-004f, -8.307296e-004f, -2.360769e-003f, -9.883821e-004f,  3.186124e-003f,
    4.521905e-003f,  8.210859e-004f, -2.450071e-003f, -1.435575e-003f,  9.331256e-005f, -8.947188e-004f, -8.433608e-004f,  2.034633e-003f,
    2.607554e-003f, -1.668056e-003f, -5.093168e-003f, -3.582106e-003f, -1.131981e-003f, -1.125291e-003f, -5.298298e-004f,  2.334879e-003f,
    3.527883e-003f,  1.313930e-003f, -4.209084e-004f,  3.105975e-004f,  9.130281e-004f,  6.595486e-004f,  1.615250e-003f,  2.676621e-003f,
    8.322845e-004f, -2.034226e-003f, -1.409025e-003f,  1.879276e-003f,  3.138114e-003f,  1.577608e-003f,  2.225551e-004f,  1.886305e-004f,
    4.135703e-004f,  7.419763e-004f,  1.265203e-003f,  1.144661e-003f,  4.214917e-004f,  5.090069e-005f, -4.071732e-004f, -1.514888e-003f,
   -1.376186e-003f,  1.300768e-003f,  3.618033e-003f,  2.759958e-003f,  9.765411e-004f,  1.427096e-003f,  2.614033e-003f,  2.001326e-003f,
    7.086109e-004f,  4.204228e-004f,  2.081517e-004f, -4.507942e-004f, -1.465126e-004f,  9.420258e-004f,  7.148057e-004f, -6.546855e-004f,
   -8.636394e-004f,  1.413065e-004f,  4.786920e-004f,  2.248065e-004f,  6.595869e-004f,  1.084819e-003f,  3.494680e-004f, -4.452301e-004f,
   -1.739296e-004f, -8.934715e-005f, -1.111679e-003f, -1.671761e-003f, -7.199402e-004f,  2.301685e-004f,  4.793378e-005f, -1.482147e-004f,
    4.329534e-004f,  8.098274e-004f,  4.161093e-004f,  4.787582e-005f,  4.872516e-005f, -1.322308e-004f, -4.664685e-004f, -3.884531e-004f,
   -4.490955e-005f,  4.604179e-005f,  4.752045e-006f,  1.070739e-004f,  1.116172e-004f, -1.088302e-004f, -1.832977e-004f,  3.369766e-006f,
    8.822881e-005f, -2.823562e-005f, -7.086594e-005f,  2.761636e-006f,  8.455887e-006f, -3.510182e-005f, -1.772056e-005f,  8.866032e-006f
};

static const float MPSVTImpulseRight3[] =
{
    0.00000000000f,  3.159706e-001f, -1.687358e-001f,  1.092659e-001f,  1.003642e-001f, -3.270080e-002f, -6.332269e-002f, -1.639938e-003f,
    2.106153e-002f, -1.417656e-002f, -2.683002e-002f,  4.016750e-003f,  2.195200e-002f,  4.962351e-003f, -6.199928e-003f,  9.323842e-003f,
    2.008813e-002f,  5.230519e-003f, -1.056118e-002f, -5.304318e-003f,  3.683635e-003f, -4.470813e-003f, -1.692913e-002f, -1.210546e-002f,
    3.135454e-003f,  7.623557e-003f,  8.354866e-004f, -1.285838e-003f,  4.303764e-003f,  5.482171e-003f, -1.654935e-003f, -6.869057e-003f,
   -3.955003e-003f,  6.686226e-004f,  6.200811e-004f, -1.200996e-003f, -3.040657e-004f,  1.431991e-003f,  4.815080e-004f, -1.799655e-003f,
   -2.099452e-003f, -6.580711e-004f,  1.398742e-004f,  1.702774e-005f,  3.093937e-004f,  9.493441e-004f,  7.720042e-004f, -1.424265e-004f,
   -6.277298e-004f, -4.018120e-004f, -2.080861e-004f, -3.366580e-004f, -3.390347e-004f, -6.526693e-005f,  8.209865e-005f, -6.882838e-005f,
   -1.950513e-004f, -6.560505e-005f,  1.548691e-004f,  2.536382e-004f,  2.328228e-004f,  1.618034e-004f,  4.512119e-005f, -1.027405e-004f,
   -2.174698e-004f, -2.529047e-004f, -2.006658e-004f, -6.988572e-005f,  8.454062e-005f,  1.662192e-004f,  1.373660e-004f,  6.212243e-005f,
    6.557411e-006f, -3.544744e-005f, -7.489604e-005f, -7.240160e-005f, -9.887633e-006f,  5.317797e-005f,  5.782051e-005f,  2.387234e-005f,
   -1.160927e-006f, -1.680593e-005f, -3.989022e-005f, -5.004980e-005f, -2.244981e-005f,  1.935153e-005f,  3.473951e-005f,  2.453277e-005f,
    1.553794e-005f,  1.064327e-005f, -3.748239e-006f, -1.937605e-005f, -1.574665e-005f,  2.286550e-006f,  1.092892e-005f,  4.653721e-006f,
   -1.668560e-006f, -2.246290e-006f, -5.219415e-006f, -1.073717e-005f, -8.182132e-006f,  3.564567e-006f,  1.236144e-005f,  1.142786e-005f,
    6.487761e-006f,  2.631084e-006f, -2.223573e-006f, -8.237300e-006f, -9.838226e-006f, -4.832240e-006f,  1.405024e-006f,  4.020539e-006f,
    4.100122e-006f,  3.679888e-006f,  1.802099e-006f, -1.727996e-006f, -3.880636e-006f, -2.631635e-006f,  4.462893e-008f,  1.554974e-006f,
    1.940397e-006f,  2.022430e-006f,  1.256352e-006f, -6.483245e-007f, -2.205531e-006f, -2.054260e-006f, -8.234674e-007f,  1.863959e-007f,
    7.787028e-007f,  1.217253e-006f,  1.137385e-006f,  2.740417e-007f, -6.612191e-007f, -8.462943e-007f, -4.279424e-007f, -1.204914e-008f,
    2.721965e-007f,  5.338388e-007f,  5.470267e-007f,  1.047683e-007f, -4.513629e-007f, -6.273480e-007f, -4.169875e-007f, -1.271991e-007f,
    1.353902e-007f,  3.993169e-007f,  5.146445e-007f,  3.156250e-007f, -5.079624e-008f, -2.824793e-007f, -2.987791e-007f, -2.187852e-007f,
   -9.492248e-008f,  8.506637e-008f,  2.281021e-007f,  2.042947e-007f,  4.754410e-008f, -8.668592e-008f, -1.279824e-007f, -1.167449e-007f,
   -7.232644e-008f,  2.014015e-008f,  1.157048e-007f,  1.309872e-007f,  6.046074e-008f, -2.062619e-008f, -6.332158e-008f, -7.730174e-008f,
   -6.823939e-008f, -2.322692e-008f,  3.858768e-008f,  6.749593e-008f,  4.686680e-008f,  8.699807e-009f, -1.812247e-008f, -3.324922e-008f,
   -3.692176e-008f, -1.908542e-008f,  1.407591e-008f,  3.549886e-008f,  3.031641e-008f,  1.084166e-008f, -6.927132e-009f, -2.002155e-008f,
   -2.678549e-008f, -1.999729e-008f, -6.593053e-010f,  1.668446e-008f,  2.058573e-008f,  1.400050e-008f,  4.599326e-009f, -5.084375e-009f,
   -1.304401e-008f, -1.383162e-008f, -5.824332e-009f,  4.224990e-009f,  9.009135e-009f,  8.110054e-009f,  4.563045e-009f, -4.401115e-010f,
   -5.740389e-009f, -7.882082e-009f, -4.850202e-009f,  5.897519e-010f,  4.265326e-009f,  5.059586e-009f,  3.981424e-009f,  1.454875e-009f,
   -1.976000e-009f, -4.257528e-009f, -3.681134e-009f, -1.125835e-009f,  1.215261e-009f,  2.348429e-009f,  2.444549e-009f,  1.515189e-009f,
   -3.082289e-010f, -1.928692e-009f, -2.146627e-009f, -1.068032e-009f,  2.503705e-010f,  1.136098e-009f,  1.501827e-009f,  1.225292e-009f,
    2.621233e-010f, -8.393682e-010f, -1.304558e-009f, -9.720089e-010f, -2.935266e-010f,  3.331344e-010f,  7.684460e-010f,  8.549267e-010f,
    4.691691e-010f, -1.608790e-010f, -5.815603e-010f, -5.880965e-010f, -3.290234e-010f,  1.884198e-012f,  3.077023e-010f,  4.662568e-010f,
    3.534031e-010f,  3.623530e-011f, -2.461882e-010f, -3.347286e-010f, -2.563917e-010f, -9.356092e-011f,  1.004953e-010f,  2.467300e-010f,
    2.485818e-010f,  1.061499e-010f, -6.517894e-011f, -1.605007e-010f, -1.647927e-010f, -1.039552e-010f,  1.864920e-013f,  1.151768e-005f,
   -1.582917e-005f, -8.728220e-005f, -1.041464e-004f, -6.234473e-005f, -5.598068e-005f, -3.016848e-005f,  8.625972e-005f,  9.976386e-005f,
   -1.060013e-004f, -2.382535e-004f, -1.221022e-004f, -1.984384e-005f, -5.794265e-006f,  9.379144e-005f, -4.415113e-005f, -6.912472e-004f,
   -9.498268e-004f, -9.800275e-005f,  6.240825e-004f,  1.141009e-004f, -1.389585e-004f,  9.196839e-004f,  7.905358e-004f, -2.137490e-003f,
   -4.172573e-003f, -2.097696e-003f,  3.813663e-004f, -1.320252e-003f, -4.473837e-003f, -4.125565e-003f, -1.297615e-003f,  1.194257e-003f,
    4.678885e-003f,  9.011289e-003f,  8.978843e-003f,  3.602796e-003f, -2.958757e-004f,  6.674883e-005f, -3.362341e-004f, -1.907971e-003f,
    5.814330e-004f,  3.771067e-003f,  9.525978e-006f, -3.279840e-003f,  5.571918e-003f,  1.283445e-002f, -3.196325e-003f, -2.777431e-002f,
   -2.325277e-002f,  9.497451e-003f,  2.725889e-002f,  1.089797e-002f, -9.228076e-003f, -7.965279e-003f, -1.102310e-003f, -7.269777e-003f,
   -1.467906e-002f, -8.953077e-003f, -3.578908e-004f, -8.444308e-004f, -2.279813e-003f,  2.933644e-003f,  4.990613e-003f, -2.425676e-003f,
   -7.486267e-003f, -1.584846e-003f,  5.314531e-003f,  3.580624e-003f, -6.059756e-004f,  2.998768e-004f,  2.163049e-003f,  1.086529e-004f,
   -1.969802e-003f, -4.871583e-004f,  1.334748e-003f,  1.225909e-003f,  1.624687e-003f,  2.741647e-003f,  1.462366e-003f, -1.358694e-003f,
   -1.238693e-003f,  1.752456e-003f,  2.826080e-003f,  4.142169e-004f, -2.218168e-003f, -2.805569e-003f, -2.287418e-003f, -1.880066e-003f,
   -1.762793e-003f, -1.873473e-003f, -1.850209e-003f, -1.363533e-003f, -1.082977e-003f, -1.416578e-003f, -8.534481e-004f,  1.721149e-003f,
    4.128878e-003f,  3.551966e-003f,  9.691278e-004f, -3.013522e-004f,  5.748226e-004f,  1.515260e-003f,  9.718703e-004f, -5.247637e-004f,
   -1.535311e-003f, -1.108490e-003f,  2.089334e-004f,  6.793456e-004f, -9.832331e-005f, -1.112805e-004f,  1.532182e-003f,  2.040269e-003f,
   -7.337439e-004f, -3.642553e-003f, -2.494551e-003f,  8.090456e-004f,  8.129059e-004f, -2.624242e-003f, -3.846336e-003f, -3.525357e-004f,
    3.344377e-003f,  2.831172e-003f,  1.373849e-004f, -2.474269e-004f,  1.525075e-003f,  1.581717e-003f, -1.111486e-003f, -3.299966e-003f,
   -2.749254e-003f, -1.265771e-003f, -1.109251e-003f, -1.543180e-003f, -9.434379e-004f,  2.056578e-004f,  6.444329e-004f,  6.168021e-004f,
    7.972998e-004f,  8.144132e-004f,  4.560157e-004f,  3.067073e-004f,  1.874487e-005f, -1.510487e-003f, -3.306104e-003f, -2.786092e-003f,
   -3.595075e-005f,  1.822991e-003f,  1.479035e-003f,  9.656934e-004f,  1.462340e-003f,  1.502347e-003f,  5.177892e-004f,  3.851293e-004f,
    1.991244e-003f,  3.296189e-003f,  2.152099e-003f, -9.429620e-004f, -3.537738e-003f, -3.486345e-003f, -7.852142e-004f,  2.105119e-003f,
    2.574249e-003f,  6.043360e-004f, -1.924830e-003f, -3.652144e-003f, -3.651248e-003f, -1.082511e-003f,  2.320017e-003f,  2.331126e-003f,
   -1.793457e-003f, -5.072750e-003f, -4.147855e-003f, -2.001828e-003f, -1.334556e-003f,  3.809859e-004f,  4.201491e-003f,  5.402468e-003f,
    1.890975e-003f, -6.233754e-004f,  1.810994e-003f,  4.464474e-003f,  2.795987e-003f,  5.483484e-005f, -6.718677e-005f,  9.862108e-006f,
   -1.744284e-003f, -2.306475e-003f, -4.161689e-004f,  2.257835e-004f, -1.617228e-003f, -2.400065e-003f, -1.283890e-003f, -1.358535e-003f,
   -2.363567e-003f, -1.110390e-003f,  9.790289e-004f, -1.798170e-004f, -3.116535e-003f, -3.450846e-003f, -2.217486e-003f, -2.805794e-003f,
   -3.383720e-003f, -1.041814e-003f,  1.196302e-003f, -1.939908e-004f, -2.142795e-003f, -7.925931e-004f,  1.618075e-003f,  2.023239e-003f,
    1.883417e-003f,  2.139058e-003f,  4.127857e-004f, -2.730033e-003f, -2.839740e-003f,  3.090251e-004f,  1.940536e-003f,  7.644870e-004f,
   -2.296878e-004f, -8.029150e-004f, -2.487858e-003f, -2.928859e-003f, -2.197123e-004f,  1.103487e-003f, -2.459108e-003f, -5.612694e-003f,
   -3.390419e-003f, -8.268589e-004f, -3.604012e-003f, -7.031199e-003f, -4.565966e-003f,  7.234511e-004f,  2.951779e-003f,  3.654939e-003f,
    6.316790e-003f,  8.336489e-003f,  6.196958e-003f,  1.884467e-003f, -1.246809e-003f, -2.655813e-003f, -2.163411e-003f, -9.504000e-005f,
    1.692407e-004f, -2.990068e-003f, -4.686426e-003f, -1.552254e-003f,  6.179608e-004f, -3.423046e-003f, -7.782970e-003f, -5.235910e-003f,
   -1.621216e-004f, -2.493147e-004f, -3.004767e-003f, -2.215631e-003f, -1.199480e-004f, -1.742084e-003f, -4.617698e-003f, -4.506821e-003f,
   -3.639218e-003f, -4.344427e-003f, -3.176295e-003f,  5.333395e-004f,  3.051942e-004f, -5.072203e-003f, -5.762979e-003f,  3.073707e-003f,
    1.037279e-002f,  5.462397e-003f, -4.078174e-003f, -3.627374e-003f,  5.874191e-003f,  1.020199e-002f,  4.181455e-003f, -1.699392e-003f,
    1.079645e-003f,  6.496149e-003f,  5.016329e-003f, -1.305557e-003f, -3.397068e-003f,  1.313679e-004f,  2.588172e-003f,  1.454763e-003f,
    1.169663e-003f,  3.606149e-003f,  5.108805e-003f,  4.159001e-003f,  3.435470e-003f,  3.255328e-003f,  1.317514e-003f, -6.619671e-004f,
    1.200897e-003f,  4.626465e-003f,  3.883056e-003f,  2.455880e-004f,  7.035949e-005f,  3.245097e-003f,  3.586845e-003f,  5.026752e-005f,
   -2.254439e-003f, -1.593809e-003f, -1.205696e-003f, -2.225894e-003f, -2.672869e-003f, -2.003277e-003f, -6.846084e-004f,  1.903572e-003f,
    4.551367e-003f,  3.936178e-003f,  1.014048e-003f,  1.114884e-003f,  4.254752e-003f,  3.675175e-003f, -2.183453e-003f, -5.622789e-003f,
   -2.116895e-003f,  2.543496e-003f,  2.509748e-003f,  6.328956e-004f,  1.879990e-003f,  5.282884e-003f,  6.965324e-003f,  5.569836e-003f,
    1.714973e-003f, -3.231947e-003f, -6.323320e-003f, -5.092490e-003f, -9.801638e-004f,  2.325174e-003f,  3.043741e-003f,  1.478586e-003f,
   -1.515795e-003f, -3.875681e-003f, -3.203390e-003f, -4.588565e-004f,  4.691438e-004f, -1.562454e-003f, -3.239302e-003f, -1.881604e-003f,
    1.305951e-003f,  3.820715e-003f,  4.400875e-003f,  2.652333e-003f, -9.312418e-004f, -4.359507e-003f, -5.468774e-003f, -3.738378e-003f,
   -4.586229e-004f,  1.645617e-003f, -1.520467e-004f, -4.838180e-003f, -6.940713e-003f, -3.372402e-003f,  1.246352e-003f,  1.041026e-003f,
   -2.109431e-003f, -2.232436e-003f,  7.692004e-004f,  2.013492e-003f,  4.667226e-004f, -5.104305e-004f,  3.476062e-006f,  1.448796e-004f,
    5.184360e-004f,  2.994059e-003f,  5.123546e-003f,  2.375148e-003f, -4.029935e-003f, -7.394896e-003f, -4.612149e-003f, -2.216946e-004f,
    2.554449e-004f, -2.594240e-003f, -4.223742e-003f, -2.991850e-003f, -1.191163e-003f,  1.397045e-004f,  2.796049e-003f,  6.440095e-003f,
    7.185748e-003f,  4.342765e-003f,  3.156821e-003f,  6.096371e-003f,  7.278634e-003f,  1.985361e-003f, -4.310055e-003f, -4.382760e-003f,
   -8.706012e-004f, -3.925998e-004f, -1.689416e-003f,  3.622260e-004f,  3.961379e-003f,  4.018829e-003f,  2.221626e-003f,  3.384399e-003f,
    5.704810e-003f,  4.151950e-003f, -7.996400e-006f, -1.499647e-003f,  5.789526e-004f,  3.471820e-003f,  5.907068e-003f,  7.154098e-003f,
    5.645820e-003f,  2.626630e-003f,  1.749977e-003f,  2.464826e-003f,  5.142882e-004f, -3.451226e-003f, -4.004942e-003f, -1.024334e-003f,
   -4.739767e-004f, -3.598551e-003f, -4.713807e-003f, -1.449429e-003f,  1.770082e-003f,  1.931355e-003f,  9.285711e-004f,  1.164238e-004f,
   -1.131584e-003f, -1.554226e-003f,  4.392083e-004f,  2.432765e-003f,  1.456740e-003f, -4.846141e-004f, -2.090322e-004f,  7.563267e-004f,
    3.017163e-006f, -2.823392e-004f,  2.154011e-003f,  4.075716e-003f,  1.949962e-003f, -1.520499e-003f, -1.860685e-003f,  1.219793e-004f,
    8.112506e-004f, -3.938974e-004f, -1.813659e-003f, -2.492592e-003f, -1.656742e-003f,  1.060198e-003f,  3.283086e-003f,  2.134142e-003f,
   -5.961072e-004f, -5.677756e-004f,  1.890082e-003f,  2.489946e-003f,  5.734264e-004f, -3.965582e-004f,  3.672666e-004f,  2.762330e-004f,
   -7.348252e-004f, -8.616997e-005f,  1.825786e-003f,  1.995665e-003f,  4.956441e-004f,  1.471532e-004f,  1.125552e-003f,  1.163094e-003f,
    2.856267e-004f,  5.223075e-004f,  1.839476e-003f,  2.403259e-003f,  1.715794e-003f,  5.359521e-004f, -5.496801e-004f, -6.306837e-004f,
    8.010492e-004f,  1.800901e-003f,  2.819011e-004f, -1.800968e-003f, -1.321852e-003f,  1.604093e-004f, -5.257998e-004f, -1.435307e-003f,
    4.597729e-004f,  1.441545e-003f, -3.101487e-003f, -7.960686e-003f, -4.636995e-003f,  3.668892e-003f,  5.798831e-003f, -1.584984e-004f,
   -5.543837e-003f, -5.670055e-003f, -3.943441e-003f, -2.877951e-003f, -1.836636e-003f, -1.678089e-003f, -2.251533e-003f,  6.937333e-004f,
    7.427054e-003f,  9.762382e-003f,  3.804408e-003f, -1.636448e-003f,  5.681833e-004f,  3.447925e-003f, -7.995593e-004f, -6.266197e-003f,
   -4.550302e-003f,  2.662542e-004f,  5.544308e-004f, -1.103895e-003f,  8.567849e-004f,  3.626376e-003f,  2.701321e-003f,  7.043693e-004f,
    5.972896e-004f, -4.794685e-004f, -3.514367e-003f, -3.804314e-003f, -4.116129e-004f,  9.573153e-004f, -1.361565e-003f, -2.130555e-003f,
    1.760918e-004f,  7.253063e-004f, -1.951353e-003f, -3.845442e-003f, -3.488649e-003f, -2.795427e-003f, -1.437985e-003f,  1.079822e-003f,
    1.375690e-003f, -1.757575e-003f, -2.911353e-003f,  7.016271e-004f,  3.124289e-003f,  2.069989e-004f, -2.790308e-003f, -1.438359e-003f,
    1.588327e-004f, -1.102020e-003f, -9.523409e-004f,  2.485208e-003f,  3.691029e-003f,  3.902611e-004f, -1.849409e-003f, -3.139595e-004f,
    6.568219e-004f, -5.539531e-004f, -1.563379e-004f,  1.815023e-003f,  8.729111e-004f, -2.207897e-003f, -2.024988e-003f,  1.086523e-003f,
    1.820973e-003f, -1.298075e-004f, -8.923177e-004f, -8.968235e-004f, -2.927134e-003f, -4.813182e-003f, -3.146634e-003f, -5.746130e-004f,
   -1.116444e-003f, -2.595952e-003f, -1.361884e-003f,  2.947205e-004f, -1.384062e-003f, -4.391237e-003f, -4.594698e-003f, -2.521711e-003f,
   -1.373362e-003f, -1.829771e-003f, -2.531749e-003f, -2.644183e-003f, -1.754281e-003f,  5.401157e-005f,  1.256904e-003f,  4.195756e-004f,
   -1.747802e-003f, -3.696075e-003f, -4.785238e-003f, -4.524799e-003f, -2.906876e-003f, -2.161241e-003f, -4.237768e-003f, -6.385978e-003f,
   -4.229581e-003f,  9.119976e-004f,  3.533404e-003f,  2.383498e-003f,  1.151823e-003f,  1.302605e-003f,  7.927072e-004f, -5.453308e-004f,
   -6.865473e-004f, -4.292409e-005f, -8.970644e-004f, -3.095018e-003f, -4.926136e-003f, -6.560481e-003f, -8.444737e-003f, -8.616141e-003f,
   -5.496181e-003f, -1.048158e-003f,  1.809955e-003f,  2.502740e-003f,  1.745947e-003f,  1.614122e-004f, -1.035244e-003f, -9.507764e-004f,
   -6.097695e-004f, -7.791228e-004f,  1.744216e-004f,  2.791655e-003f,  3.734782e-003f,  8.982032e-004f, -1.972238e-003f, -7.724068e-004f,
    2.115842e-003f,  1.647054e-003f, -2.139695e-003f, -4.922600e-003f, -4.135490e-003f, -6.056251e-004f,  3.300488e-003f,  4.847306e-003f,
    3.081646e-003f,  8.030916e-004f,  1.111480e-003f,  2.547738e-003f,  2.021358e-003f,  9.255219e-004f,  2.546727e-003f,  5.146365e-003f,
    4.326950e-003f,  9.429455e-004f, -1.535582e-004f,  1.748387e-003f,  2.761103e-003f,  1.298364e-003f, -2.922257e-004f, -4.481623e-004f,
   -1.624244e-004f, -5.398464e-004f, -1.628825e-003f, -2.819804e-003f, -2.966307e-003f, -1.684338e-003f, -5.288037e-004f, -5.492985e-004f,
   -1.398107e-004f,  1.461995e-003f,  1.455573e-003f, -1.367084e-003f, -2.826072e-003f, -3.259059e-004f,  1.290761e-003f, -2.254013e-003f,
   -6.093058e-003f, -3.633633e-003f,  2.445502e-003f,  4.945035e-003f,  3.116626e-003f,  7.995354e-004f, -1.377083e-003f, -3.893876e-003f,
   -3.602957e-003f,  9.410766e-004f,  4.367727e-003f,  2.131157e-003f, -1.760791e-003f, -1.546137e-003f,  1.072609e-003f,  1.377176e-003f,
    2.230856e-004f,  1.176572e-003f,  3.045479e-003f,  1.843697e-003f, -2.172871e-003f, -4.570967e-003f, -2.636308e-003f,  1.979306e-003f,
    5.680628e-003f,  6.292734e-003f,  4.479282e-003f,  2.358374e-003f,  9.543347e-004f, -4.972126e-005f, -6.705554e-004f, -9.200038e-004f,
   -1.854448e-003f, -3.429168e-003f, -2.905913e-003f,  8.502826e-004f,  3.858320e-003f,  2.433282e-003f, -9.112589e-004f, -2.174124e-003f,
   -2.441533e-003f, -3.698651e-003f, -3.092656e-003f,  1.242092e-003f,  3.831114e-003f, -2.925034e-004f, -6.144469e-003f, -5.781034e-003f,
   -4.877062e-004f,  2.272973e-003f,  3.656760e-004f, -2.028739e-003f, -1.824210e-003f,  5.084127e-004f,  3.172582e-003f,  4.013064e-003f,
    2.247375e-003f,  5.100708e-004f,  1.180749e-003f,  1.677359e-003f, -9.391006e-004f, -3.243137e-003f, -7.361940e-004f,  3.469558e-003f,
    3.810734e-003f,  2.170590e-003f,  3.260179e-003f,  4.637748e-003f,  1.501689e-003f, -3.110860e-003f, -3.230963e-003f, -5.310363e-004f,
   -1.392135e-004f, -7.811249e-004f,  1.340213e-003f,  3.795957e-003f,  2.191200e-003f, -1.397621e-003f, -2.204353e-003f, -6.594344e-004f,
   -6.851961e-005f, -7.634618e-004f, -1.447843e-003f, -2.042978e-003f, -2.080914e-003f, -7.385155e-004f,  2.931506e-004f, -1.068145e-003f,
   -2.684751e-003f, -1.274789e-003f,  1.454349e-003f,  1.771706e-003f,  6.457546e-004f,  1.220420e-003f,  2.405394e-003f,  1.245908e-003f,
   -1.160666e-003f, -1.730473e-003f, -5.442514e-004f,  5.010832e-004f,  1.131619e-003f,  1.588029e-003f,  1.277479e-003f,  2.998166e-004f,
   -8.644049e-004f, -2.944511e-003f, -5.441716e-003f, -4.877258e-003f, -3.947950e-004f,  2.440926e-003f, -4.830194e-004f, -4.389669e-003f,
   -2.985788e-003f,  1.220790e-003f,  1.583477e-003f, -1.802521e-003f, -3.541969e-003f, -2.013522e-003f, -1.999464e-004f,  7.653699e-005f,
   -4.880450e-004f, -1.006761e-003f, -8.239324e-004f,  1.625483e-004f,  2.873443e-004f, -1.904373e-003f, -4.564965e-003f, -4.853891e-003f,
   -3.200975e-003f, -1.625145e-003f, -8.794503e-006f,  1.985168e-003f,  2.191755e-003f, -6.200884e-004f, -3.535748e-003f, -3.531449e-003f,
   -1.793395e-003f, -1.069697e-003f, -1.757573e-003f, -2.624859e-003f, -2.478668e-003f, -4.119825e-004f,  2.726736e-003f,  3.961669e-003f,
    2.299985e-003f,  8.155205e-004f,  1.381158e-003f,  1.221136e-003f, -1.501855e-003f, -3.500361e-003f, -1.926280e-003f,  9.603489e-004f,
    2.380109e-003f,  2.867982e-003f,  2.797547e-003f,  1.168423e-003f, -4.154895e-004f,  6.694899e-004f,  1.997694e-003f, -6.706537e-004f,
   -4.645925e-003f, -3.680389e-003f,  9.443625e-004f,  2.303678e-003f, -4.239421e-004f, -1.854027e-003f, -5.456479e-004f,  3.197155e-004f,
    6.308773e-004f,  2.640983e-003f,  4.636747e-003f,  3.523569e-003f,  1.179774e-003f,  1.055783e-003f,  1.802517e-003f,  7.805781e-004f,
   -8.884357e-005f,  1.856448e-003f,  4.278703e-003f,  3.479080e-003f,  4.184492e-004f, -1.402714e-003f, -1.382607e-003f, -1.790063e-003f,
   -3.950230e-003f, -6.248434e-003f, -5.607907e-003f, -1.471583e-003f,  2.124457e-003f,  1.267058e-003f, -1.864360e-003f, -2.453325e-003f,
   -1.092693e-003f, -1.737340e-003f, -3.456273e-003f, -2.750111e-003f, -2.015066e-003f, -5.532396e-003f, -9.256944e-003f, -6.218100e-003f,
    1.690369e-004f,  1.051899e-003f, -1.840836e-003f,  6.564388e-004f,  7.475436e-003f,  8.036464e-003f,  9.164081e-004f, -3.140109e-003f,
    9.927393e-004f,  5.413464e-003f,  3.085277e-003f, -1.984124e-003f, -2.963997e-003f, -4.697955e-004f,  2.409265e-004f, -2.311187e-003f,
   -4.464519e-003f, -3.189282e-003f, -3.316170e-004f,  4.095548e-004f, -5.799266e-004f,  2.834037e-004f,  2.726920e-003f,  2.271022e-003f,
   -1.122114e-003f, -1.317461e-003f,  3.440396e-003f,  6.227909e-003f,  2.590104e-003f, -2.138020e-003f, -2.109517e-003f,  5.190668e-004f,
    1.743767e-003f,  2.268018e-003f,  2.890102e-003f,  1.443872e-003f, -1.373676e-003f, -1.225035e-003f,  1.704125e-003f,  2.201476e-003f,
   -4.668690e-004f, -1.704750e-003f, -1.070994e-003f, -2.479278e-003f, -4.485642e-003f, -1.357829e-003f,  5.328765e-003f,  7.085895e-003f,
    1.794676e-003f, -3.347272e-003f, -3.279544e-003f, -5.619462e-004f,  1.304690e-003f,  1.986825e-003f,  1.154761e-003f, -1.941698e-003f,
   -5.191965e-003f, -5.074512e-003f, -1.543649e-003f,  1.816552e-003f,  1.857799e-003f, -1.542090e-003f, -5.302897e-003f, -5.264185e-003f,
   -9.556369e-004f,  2.745572e-003f,  1.886580e-003f, -1.084374e-003f, -2.212313e-003f, -2.551309e-003f, -4.269818e-003f, -4.808576e-003f,
   -1.766173e-003f,  1.028906e-003f, -1.178765e-004f, -1.199815e-003f,  2.413190e-003f,  6.351019e-003f,  4.084596e-003f, -9.843635e-004f,
   -5.101502e-004f,  4.700779e-003f,  5.924392e-003f,  6.137604e-004f, -4.262058e-003f, -3.309882e-003f,  7.385976e-004f,  2.772913e-003f,
    1.592724e-003f, -8.989142e-004f, -2.433257e-003f, -1.284316e-003f,  2.397994e-003f,  5.636764e-003f,  5.426732e-003f,  2.496243e-003f,
    1.110824e-004f, -5.341895e-004f, -1.198275e-003f, -2.775449e-003f, -3.402593e-003f, -1.629545e-003f,  7.383322e-004f,  1.004098e-003f,
   -5.774764e-004f, -1.567771e-003f, -1.040167e-003f, -4.795819e-005f,  8.919380e-004f,  1.903389e-003f,  1.766499e-003f, -8.404591e-004f,
   -4.071551e-003f, -4.403437e-003f, -1.836868e-003f, -1.114348e-004f, -1.093943e-003f, -2.479853e-003f, -2.002075e-003f, -5.719057e-004f,
    9.462984e-006f, -2.807055e-004f, -5.319857e-004f, -5.010298e-004f, -5.390134e-004f, -8.975654e-004f, -1.113785e-003f, -6.605453e-008f,
    2.458321e-003f,  3.622206e-003f,  1.390286e-003f, -1.628530e-003f, -1.195874e-003f,  1.785068e-003f,  2.816552e-003f,  1.573859e-003f,
    1.468425e-003f,  1.776866e-003f, -1.548304e-003f, -6.563280e-003f, -6.054432e-003f,  4.790280e-004f,  4.750287e-003f,  2.252878e-003f,
   -1.948170e-003f, -2.807002e-003f, -1.918419e-003f, -1.428579e-003f,  3.033158e-004f,  3.504472e-003f,  4.714464e-003f,  2.677270e-003f,
    3.579442e-004f, -5.802457e-004f, -1.451994e-003f, -2.165192e-003f, -1.083118e-003f,  7.764328e-004f,  9.835757e-004f,  3.385474e-004f,
    1.064208e-003f,  2.059268e-003f,  1.087049e-003f, -5.235289e-004f, -2.436693e-004f,  1.141189e-003f,  1.646128e-003f,  1.675474e-003f,
    1.887004e-003f,  1.076999e-003f, -7.126824e-004f, -9.523531e-004f,  1.021927e-003f,  2.575267e-003f,  2.325397e-003f,  1.676601e-003f,
    1.061346e-003f, -5.097087e-004f, -2.066593e-003f, -1.800079e-003f, -8.496719e-004f, -1.074747e-003f, -8.923461e-004f,  1.407298e-003f,
    2.936806e-003f,  5.994007e-004f, -2.872375e-003f, -3.154612e-003f, -1.242992e-003f, -4.156506e-004f, -1.278235e-004f,  1.361271e-003f,
    2.327236e-003f,  1.109771e-003f,  1.702444e-004f,  1.442176e-003f,  2.019643e-003f, -4.911418e-004f, -2.852448e-003f, -1.542911e-003f,
    1.025625e-003f,  7.838692e-004f, -1.170406e-003f, -1.106738e-003f,  8.225957e-004f,  1.530941e-003f,  6.957382e-004f,  9.201453e-004f,
    2.734618e-003f,  3.467685e-003f,  1.808853e-003f,  1.814474e-004f,  7.441760e-004f,  1.664907e-003f,  3.107481e-004f, -1.821946e-003f,
   -1.421918e-003f,  6.409390e-004f,  7.194420e-004f, -7.378205e-004f,  2.007880e-004f,  3.152155e-003f,  3.115498e-003f, -7.595014e-004f,
   -3.319209e-003f, -2.284233e-003f, -1.572543e-003f, -3.194365e-003f, -3.302794e-003f,  3.140342e-004f,  3.622015e-003f,  2.900900e-003f,
    1.902144e-004f, -1.027179e-003f, -6.365005e-004f,  1.809862e-004f,  1.466958e-003f,  2.861241e-003f,  2.979513e-003f,  1.729320e-003f,
    5.496423e-004f,  5.044244e-005f, -2.968231e-004f, -5.618025e-004f, -4.269697e-004f, -9.029318e-005f,  2.265671e-004f,  5.520321e-004f,
    3.619016e-004f, -9.039179e-004f, -2.368084e-003f, -2.472836e-003f, -9.899687e-004f,  1.088518e-003f,  2.717091e-003f,  2.836912e-003f,
    1.014717e-003f, -1.205515e-003f, -1.861060e-003f, -1.522468e-003f, -1.759744e-003f, -1.630152e-003f,  2.196579e-004f,  1.530220e-003f,
   -3.500975e-004f, -3.103239e-003f, -3.002715e-003f, -1.444712e-003f, -1.770219e-003f, -2.569877e-003f, -8.345842e-004f,  1.555100e-003f,
    1.368008e-003f,  4.273643e-004f,  1.708414e-003f,  3.025434e-003f,  1.250253e-003f, -1.332967e-003f, -1.179791e-003f,  2.060135e-004f,
   -1.930714e-004f, -1.235048e-003f, -4.957734e-004f,  1.054690e-003f,  1.344388e-003f,  7.926775e-004f,  7.730688e-004f,  1.339562e-003f,
    1.902401e-003f,  1.873394e-003f,  7.606385e-004f, -6.403671e-004f, -8.014960e-004f, -2.824223e-004f, -8.231446e-004f, -1.368210e-003f,
    1.719241e-004f,  1.698012e-003f, -7.032349e-005f, -2.504714e-003f, -8.924265e-004f,  2.362252e-003f,  1.491990e-003f, -1.841297e-003f,
   -1.523079e-003f,  1.701214e-003f,  2.190376e-003f, -1.343863e-004f, -1.190442e-003f, -9.754602e-004f, -1.326634e-003f, -3.986823e-004f,
    2.373389e-003f,  2.387042e-003f, -1.587189e-003f, -3.321843e-003f, -3.047332e-004f,  1.182233e-003f, -1.707354e-003f, -2.967210e-003f,
   -2.888212e-004f,  2.005257e-004f, -2.983051e-003f, -3.116535e-003f,  6.358227e-004f,  8.086179e-004f, -2.758465e-003f, -1.142773e-003f,
    6.071931e-003f,  8.102027e-003f,  1.726765e-003f, -3.444492e-003f, -2.049078e-003f,  1.617713e-006f, -1.359156e-003f, -2.359862e-003f,
   -1.028751e-003f, -4.430149e-004f, -9.783308e-004f,  1.200302e-004f,  1.704138e-003f,  4.783720e-004f, -2.014092e-003f, -2.208363e-003f,
   -1.209025e-003f, -1.660111e-003f, -2.087530e-003f, -4.652655e-004f,  1.288645e-003f,  1.333460e-003f,  1.322106e-003f,  2.169799e-003f,
    1.908856e-003f,  2.384965e-004f, -4.175006e-004f,  3.196473e-004f,  5.242724e-004f,  4.101754e-004f,  1.388342e-003f,  1.873156e-003f,
   -2.091163e-004f, -2.587285e-003f, -1.863455e-003f,  7.445434e-004f,  1.785207e-003f,  8.965383e-004f, -3.427118e-004f, -1.550525e-003f,
   -2.276616e-003f, -1.336386e-003f,  3.217759e-004f,  1.903959e-004f, -1.230574e-003f, -1.091151e-003f,  4.860701e-004f,  1.017895e-003f,
    9.507881e-004f,  2.553391e-003f,  4.614041e-003f,  4.189327e-003f,  2.173569e-003f,  1.412848e-003f,  1.423844e-003f,  5.212014e-004f,
    2.194666e-004f,  1.896207e-003f,  2.652976e-003f,  2.397578e-004f, -1.882673e-003f, -2.419598e-004f,  2.110915e-003f,  7.525713e-004f,
   -2.553333e-003f, -3.407634e-003f, -2.070674e-003f, -1.522833e-003f, -1.662086e-003f, -6.296131e-004f,  1.027868e-003f,  1.776529e-003f,
    1.851357e-003f,  1.520067e-003f, -5.625816e-005f, -1.919744e-003f, -1.388243e-003f,  9.397549e-004f,  1.023265e-003f, -1.758139e-003f,
   -2.933107e-003f, -5.040050e-004f,  1.426898e-003f, -4.626950e-004f, -3.508903e-003f, -3.966639e-003f, -2.414759e-003f, -1.146011e-003f,
   -2.884599e-004f,  7.334423e-004f,  1.447963e-003f,  2.045130e-003f,  3.528477e-003f,  5.067372e-003f,  4.637953e-003f,  2.737375e-003f,
    1.877262e-003f,  2.503982e-003f,  3.038332e-003f,  3.163160e-003f,  3.317384e-003f,  2.389371e-003f, -1.372897e-004f, -1.749833e-003f,
   -6.051214e-004f,  9.787984e-004f,  6.913394e-004f,  3.644333e-004f,  1.662165e-003f,  1.939331e-003f, -6.275550e-004f, -2.298414e-003f,
    2.825641e-004f,  3.670980e-003f,  2.933086e-003f, -4.538515e-004f, -1.697670e-003f, -3.753141e-004f,  4.357473e-004f,  1.486358e-004f,
    8.013776e-004f,  2.672019e-003f,  3.655663e-003f,  2.510264e-003f,  3.864503e-004f, -8.273557e-004f, -7.265196e-004f, -6.034595e-004f,
   -1.172086e-003f, -1.096631e-003f,  4.441293e-004f,  1.309183e-003f, -9.555876e-005f, -8.004887e-004f,  2.227802e-003f,  5.616201e-003f,
    4.080304e-003f, -5.081038e-004f, -2.095270e-003f, -7.169968e-004f, -1.304079e-003f, -3.643235e-003f, -2.725654e-003f,  1.440008e-003f,
    3.280193e-003f,  9.751467e-004f, -1.504467e-003f, -1.606929e-003f, -7.490193e-004f, -1.754909e-004f,  1.843843e-004f, -1.843131e-004f,
   -1.178079e-003f, -9.574823e-004f,  8.248003e-004f,  1.618441e-003f,  1.539092e-004f, -1.507079e-003f, -1.689684e-003f, -1.137985e-003f,
   -6.798142e-004f, -4.868803e-004f, -1.098787e-003f, -1.883029e-003f, -6.715248e-004f,  1.968789e-003f,  2.123703e-003f, -6.913890e-004f,
   -1.884884e-003f, -1.509229e-004f, -1.176441e-004f, -3.088494e-003f, -3.759880e-003f, -1.927009e-004f,  2.133617e-003f,  3.143997e-004f,
   -1.299871e-003f, -1.162283e-004f,  4.246715e-004f, -1.266375e-003f, -1.917459e-003f, -5.612030e-004f, -1.284068e-004f, -9.725551e-004f,
   -8.966730e-004f, -8.756100e-004f, -2.878698e-003f, -4.304528e-003f, -2.232288e-003f,  4.471683e-004f,  2.372764e-004f, -8.217213e-004f,
   -6.711266e-004f, -1.963045e-003f, -5.089935e-003f, -4.858790e-003f, -1.811115e-004f,  2.232459e-003f, -5.092380e-004f, -2.337993e-003f,
    1.639998e-004f,  2.010169e-003f,  5.567430e-004f,  5.858472e-004f,  3.877139e-003f,  4.930912e-003f,  1.476871e-003f, -1.408587e-003f,
   -1.130858e-003f, -1.206310e-003f, -2.574899e-003f, -1.509874e-003f,  1.745336e-003f,  2.048337e-003f, -1.163588e-003f, -2.470358e-003f,
    3.789972e-005f,  2.034372e-003f,  9.537639e-004f, -4.485670e-004f,  2.464401e-004f,  1.710834e-003f,  2.151753e-003f,  1.660368e-003f,
    6.782566e-004f, -7.509302e-004f, -1.994717e-003f, -2.221013e-003f, -1.671344e-003f, -1.259950e-003f, -1.266501e-003f, -1.235460e-003f,
   -8.832020e-004f, -6.449996e-004f, -1.206860e-003f, -2.458620e-003f, -3.367067e-003f, -3.276522e-003f, -2.547811e-003f, -1.451768e-003f,
    1.940236e-004f,  1.731329e-003f,  1.960581e-003f,  1.330945e-003f,  1.419015e-003f,  1.875777e-003f,  9.783497e-004f, -6.388174e-004f,
   -6.162174e-004f,  6.574941e-004f,  4.414393e-004f, -1.469623e-003f, -2.613224e-003f, -2.249980e-003f, -1.494313e-003f, -1.306432e-004f,
    2.040954e-003f,  2.432556e-003f, -6.365161e-004f, -3.555304e-003f, -2.113127e-003f,  1.649687e-003f,  2.653109e-003f,  4.931667e-004f,
   -1.298702e-003f, -1.402940e-003f, -1.191809e-003f, -1.111792e-003f, -7.539174e-004f, -6.819101e-004f, -1.162851e-003f, -1.107247e-003f,
   -1.927638e-004f,  3.954976e-004f,  3.701902e-004f,  6.430086e-004f,  9.233870e-004f,  2.152072e-004f, -5.175048e-004f,  3.749586e-004f,
    1.841732e-003f,  1.511982e-003f, -2.358625e-004f, -8.393943e-004f,  5.998965e-004f,  2.734031e-003f,  4.157547e-003f,  4.036973e-003f,
    2.037271e-003f, -5.550263e-004f, -1.274308e-003f,  4.624310e-004f,  2.326686e-003f,  2.161175e-003f,  5.346554e-004f, -5.620591e-004f,
   -2.726086e-004f,  5.290183e-004f,  6.426898e-004f,  2.507997e-004f,  7.309605e-004f,  2.194857e-003f,  2.561865e-003f,  7.204413e-004f,
   -1.237725e-003f, -1.442515e-003f, -1.577340e-003f, -3.444046e-003f, -4.877176e-003f, -3.282647e-003f, -5.956413e-004f, -8.326821e-005f,
   -8.441824e-004f, -2.643370e-004f,  7.888002e-004f,  9.476738e-005f, -1.311994e-003f, -1.353485e-003f, -1.008270e-003f, -1.887396e-003f,
   -2.609049e-003f, -1.609361e-003f, -5.646384e-004f, -1.275871e-003f, -2.122960e-003f, -1.024046e-003f,  8.757320e-004f,  1.386196e-003f,
    5.685546e-004f, -4.315468e-004f, -1.430710e-003f, -2.366490e-003f, -2.567989e-003f, -1.990526e-003f, -1.361944e-003f, -7.480818e-004f,
    2.836823e-004f,  1.232563e-003f,  1.069059e-003f, -2.122293e-004f, -1.544030e-003f, -1.700601e-003f,  2.845187e-005f,  2.747342e-003f,
    3.743338e-003f,  1.439031e-003f, -1.893456e-003f, -2.935437e-003f, -2.022099e-003f, -1.845755e-003f, -2.498363e-003f, -1.800634e-003f,
    9.644154e-005f,  7.314555e-004f, -2.719398e-004f, -8.787307e-004f, -5.150201e-004f, -4.086144e-004f, -4.227765e-004f,  5.383001e-004f,
    1.366505e-003f,  3.596333e-005f, -2.261492e-003f, -2.454850e-003f, -9.160890e-004f, -9.612467e-004f, -2.766581e-003f, -2.664962e-003f,
    2.729539e-004f,  1.861199e-003f, -6.209004e-004f, -3.838562e-003f, -3.678816e-003f, -1.474008e-003f, -9.633992e-004f, -1.880985e-003f,
   -1.183788e-003f,  1.062113e-003f,  1.787974e-003f,  2.975192e-004f, -7.727149e-004f,  5.928187e-005f,  1.281695e-003f,  1.338519e-003f,
    5.356952e-004f, -1.721839e-004f, -1.259368e-004f,  9.319041e-004f,  1.972769e-003f,  1.066684e-003f, -1.677306e-003f, -3.374541e-003f,
   -2.330154e-003f, -4.119686e-004f,  3.600809e-004f,  7.221338e-004f,  1.623027e-003f,  1.973985e-003f,  1.165855e-003f,  5.655860e-004f,
    4.789780e-004f, -7.752877e-004f, -2.916392e-003f, -2.948976e-003f, -3.240819e-004f,  1.497935e-003f,  6.270296e-004f, -6.083069e-004f,
   -4.490087e-004f, -3.707546e-004f, -1.071663e-003f, -7.119207e-004f,  8.718261e-004f,  1.061582e-003f, -5.467286e-004f, -8.692722e-004f,
    1.182106e-003f,  2.743493e-003f,  2.195226e-003f,  1.580688e-003f,  2.218832e-003f,  2.460735e-003f,  1.374128e-003f,  4.591437e-004f,
    4.274420e-004f,  1.453595e-004f, -4.481931e-004f, -1.179797e-004f,  7.228551e-004f,  5.848833e-004f,  1.419871e-004f,  9.717260e-004f,
    1.772901e-003f,  1.866542e-004f, -2.397864e-003f, -2.514675e-003f, -4.617818e-004f,  2.144518e-004f, -1.401785e-003f, -2.735279e-003f,
   -2.333883e-003f, -1.214157e-003f, -1.374089e-004f,  7.736580e-004f,  6.336634e-004f, -6.803611e-004f, -1.159589e-003f,  8.669346e-005f,
    6.037946e-004f, -1.103846e-003f, -2.171638e-003f, -1.235385e-004f,  2.392665e-003f,  1.963966e-003f,  1.097808e-004f,  4.251372e-006f,
    8.200138e-004f,  1.640697e-004f, -9.071391e-004f, -1.403565e-004f,  1.330394e-003f,  1.136105e-003f, -3.086087e-005f, -2.217056e-004f,
    1.036524e-004f, -3.071191e-004f, -7.224628e-004f, -3.606868e-004f, -5.689932e-004f, -2.315317e-003f, -3.955842e-003f, -3.865565e-003f,
   -2.946183e-003f, -2.588327e-003f, -2.438778e-003f, -1.809039e-003f, -1.165444e-003f, -8.817548e-004f, -3.529147e-004f,  6.483648e-004f,
    1.267349e-003f,  9.355767e-004f,  3.010775e-004f,  3.247514e-004f,  1.093293e-003f,  1.719045e-003f,  1.288106e-003f, -1.164022e-005f,
   -1.060769e-003f, -1.342474e-003f, -1.396282e-003f, -1.386019e-003f, -7.377124e-004f,  2.733234e-004f,  5.390286e-004f,  1.842766e-004f,
    2.389123e-004f,  1.843870e-004f, -1.045800e-003f, -1.914926e-003f, -2.175892e-004f,  2.241488e-003f,  1.801110e-003f, -6.961567e-004f,
   -1.255899e-003f,  1.897243e-004f,  2.946540e-004f, -8.423225e-004f, -2.047900e-004f,  1.429796e-003f,  5.735314e-004f, -1.774579e-003f,
   -1.429651e-003f,  1.089122e-003f,  1.384333e-003f, -7.949084e-004f, -1.692413e-003f, -9.446774e-004f, -1.638975e-003f, -3.637518e-003f,
   -3.609643e-003f, -1.188245e-003f,  8.348738e-004f,  1.642897e-003f,  2.504302e-003f,  2.920355e-003f,  1.410345e-003f, -9.322518e-004f,
   -1.549555e-003f, -7.167079e-005f,  1.792221e-003f,  2.642186e-003f,  2.023208e-003f,  4.283804e-004f, -5.483350e-004f, -4.715403e-005f,
    3.164447e-004f, -9.938220e-004f, -2.293862e-003f, -1.338697e-003f,  3.785447e-004f, -1.201834e-004f, -2.113561e-003f, -2.370995e-003f,
   -4.992024e-004f,  8.318070e-004f,  3.549445e-004f, -4.807308e-004f, -2.911063e-004f,  6.996592e-004f,  1.602089e-003f,  1.752647e-003f,
    1.148260e-003f,  7.095044e-004f,  1.220260e-003f,  1.905103e-003f,  1.438733e-003f,  2.537878e-004f,  1.775389e-004f,  1.766020e-003f,
    3.476799e-003f,  3.583613e-003f,  1.970841e-003f,  9.969371e-005f, -4.058221e-004f,  5.738888e-004f,  1.507788e-003f,  1.305403e-003f,
    5.264834e-004f, -1.173699e-004f, -8.539168e-004f, -1.485811e-003f, -8.968292e-004f,  8.101569e-004f,  1.773305e-003f,  1.234265e-003f,
    6.668034e-004f,  9.050544e-004f,  7.562268e-004f, -2.907249e-004f, -7.387444e-004f,  1.448837e-004f,  8.525677e-004f,  3.059601e-004f,
   -4.017866e-004f, -1.816291e-004f,  3.165349e-004f,  2.702040e-004f,  8.799346e-005f,  2.660760e-004f,  3.893624e-004f,  6.152331e-005f,
   -3.382562e-004f, -3.456293e-004f, -1.269118e-005f,  3.934295e-004f,  6.571366e-004f,  5.924869e-004f,  2.343161e-004f, -8.966690e-005f,
   -1.747140e-004f, -1.587701e-004f, -1.650960e-004f, -1.061931e-004f,  2.922199e-005f,  7.800810e-005f, -8.454802e-006f, -8.773646e-005f,
   -7.476817e-005f, -2.542967e-005f,  8.816222e-006f,  2.757904e-005f,  2.552472e-005f,  4.452638e-006f, -8.946349e-006f, -5.201500e-006f
};

static const float MPSVTImpulseLeft4[] =
{
    0.00000000000f,  3.994024e-001f,  8.075847e-002f, -4.190122e-002f, -8.227470e-002f, -3.298921e-002f,  4.915686e-002f,  7.079224e-002f,
    3.135914e-002f, -1.230055e-002f, -2.094102e-002f, -1.331936e-002f, -1.229073e-002f, -1.568965e-002f, -1.070220e-002f, -2.808838e-003f,
   -2.118362e-003f, -6.566772e-003f, -6.632809e-003f, -3.369000e-003f, -3.098406e-003f, -4.725005e-003f, -1.362022e-003f,  5.677119e-003f,
    8.490948e-003f,  5.076202e-003f,  2.185228e-003f,  3.394799e-003f,  4.517492e-003f,  1.872191e-003f, -1.172951e-003f, -5.794968e-004f,
    1.795990e-003f,  1.512528e-003f, -1.348754e-003f, -3.162409e-003f, -2.324117e-003f, -7.667542e-004f, -2.328758e-004f, -3.600797e-004f,
   -1.136071e-004f,  5.047470e-004f,  9.147234e-004f,  7.449146e-004f,  1.759950e-004f, -2.538267e-004f, -3.369584e-005f,  5.983568e-004f,
    8.393890e-004f,  3.525812e-004f, -1.937244e-004f, -1.482494e-004f,  2.271883e-004f,  2.705029e-004f, -8.763868e-006f, -9.659777e-005f,
    1.575365e-004f,  3.583533e-004f,  2.436471e-004f, -1.942646e-005f, -1.532277e-004f, -1.007960e-004f,  4.388302e-005f,  1.454806e-004f,
    1.163240e-004f,  6.098220e-006f, -8.432295e-006f,  1.176024e-004f,  2.008553e-004f,  1.019828e-004f, -2.418622e-005f,  2.946853e-005f,
    1.866242e-004f,  2.026305e-004f,  5.481676e-005f, -4.558522e-005f,  1.050140e-005f,  9.380322e-005f,  7.870015e-005f,  1.507760e-005f,
    7.405427e-006f,  5.187548e-005f,  8.087830e-005f,  6.916493e-005f,  4.150064e-005f,  2.291118e-005f,  2.916776e-005f,  5.779725e-005f,
    7.622814e-005f,  5.382966e-005f,  1.632936e-005f,  1.574580e-005f,  4.955295e-005f,  6.125314e-005f,  3.220575e-005f,  9.662830e-006f,
    2.827673e-005f,  5.615185e-005f,  5.134831e-005f,  2.512928e-005f,  1.594731e-005f,  2.912805e-005f,  3.963655e-005f,  3.470533e-005f,
    2.509347e-005f,  2.158684e-005f,  2.419769e-005f,  2.866328e-005f,  3.036521e-005f,  2.551747e-005f,  1.837733e-005f,  1.892179e-005f,
    2.746768e-005f,  3.102199e-005f,  2.305893e-005f,  1.474582e-005f,  1.757795e-005f,  2.518733e-005f,  2.468327e-005f,  1.708807e-005f,
    1.391443e-005f,  1.814195e-005f,  2.162077e-005f,  1.925942e-005f,  1.527140e-005f,  1.452052e-005f,  1.617682e-005f,  1.722647e-005f,
    1.675475e-005f,  1.522115e-005f,  1.354735e-005f,  1.322173e-005f,  1.455622e-005f,  1.521738e-005f,  1.339946e-005f,  1.116024e-005f,
    1.154160e-005f,  1.351499e-005f,  1.353262e-005f,  1.123934e-005f,  9.857604e-006f,  1.085476e-005f,  1.197479e-005f,  1.121967e-005f,
    9.712189e-006f,  9.321166e-006f,  9.862654e-006f,  1.002262e-005f,  9.485752e-006f,  8.849303e-006f,  8.492855e-006f,  8.424584e-006f,
    8.555006e-006f,  8.542692e-006f,  8.045738e-006f,  7.390805e-006f,  7.280369e-006f,  7.638353e-006f,  7.615149e-006f,  6.947166e-006f,
    6.410841e-006f,  6.547537e-006f,  6.822263e-006f,  6.558324e-006f,  5.990616e-006f,  5.759556e-006f,  5.891691e-006f,  5.909418e-006f,
    5.640094e-006f,  5.344287e-006f,  5.210470e-006f,  5.161616e-006f,  5.091239e-006f,  4.970725e-006f,  4.786696e-006f,  4.582377e-006f,
    4.477398e-006f,  4.482240e-006f,  4.424084e-006f,  4.206935e-006f,  3.993924e-006f,  3.954365e-006f,  3.984084e-006f,  3.878530e-006f,
    3.663759e-006f,  3.532347e-006f,  3.526171e-006f,  3.498777e-006f,  3.370009e-006f,  3.225159e-006f,  3.148343e-006f,  3.108584e-006f,
    3.045521e-006f,  2.956558e-006f,  2.865844e-006f,  2.783352e-006f,  2.717583e-006f,  2.670936e-006f,  2.616589e-006f,  2.530178e-006f,
    2.439343e-006f,  2.388012e-006f,  2.361516e-006f,  2.305915e-006f,  2.216594e-006f,  2.144885e-006f,  2.112836e-006f,  2.081480e-006f,
    2.018921e-006f,  1.947117e-006f,  1.898266e-006f,  1.865633e-006f,  1.824196e-006f,  1.770952e-006f,  1.720108e-006f,  1.677246e-006f,
    1.638170e-006f,  1.600312e-006f,  1.561592e-006f,  1.518557e-006f,  1.474587e-006f,  1.438740e-006f,  1.410299e-006f,  1.377070e-006f,
    1.335054e-006f,  1.296085e-006f,  1.268497e-006f,  1.243492e-006f,  1.210237e-006f,  1.173069e-006f,  1.142734e-006f,  1.118987e-006f,
    1.093195e-006f,  1.062913e-006f,  1.033553e-006f,  1.008252e-006f,  9.845988e-007f,  9.603019e-007f,  9.357433e-007f,  9.114549e-007f,
    8.876626e-007f,  8.655002e-007f,  8.452348e-007f,  8.246715e-007f,  8.023816e-007f,  7.806325e-007f,  7.619528e-007f,  7.447433e-007f,
    7.258093e-007f,  7.056207e-007f,  6.873180e-007f,  6.714704e-007f,  6.555218e-007f,  6.381944e-007f,  6.211174e-007f, -1.567602e-005f,
    3.062453e-005f,  8.595234e-005f,  1.075815e-004f,  6.631875e-005f, -2.251251e-004f, -6.108654e-004f, -3.735458e-004f,  4.768115e-004f,
    6.768377e-004f, -1.903013e-004f, -6.009818e-004f,  2.671880e-004f,  8.679852e-004f,  1.020634e-004f, -7.529369e-004f, -7.189905e-004f,
   -5.808615e-004f, -2.416772e-004f,  1.198191e-003f,  1.609290e-003f, -2.084204e-003f, -6.453715e-003f, -3.751588e-003f,  5.343264e-003f,
    9.455880e-003f,  2.230101e-003f, -7.302532e-003f, -7.198001e-003f,  3.337577e-004f,  2.898933e-003f, -3.722321e-003f, -1.011562e-002f,
   -7.521349e-003f, -5.414551e-005f,  2.686406e-003f,  4.651522e-004f,  1.203366e-003f,  5.788393e-003f,  5.103063e-003f, -3.762504e-003f,
   -9.600892e-003f, -3.579676e-003f,  6.280713e-003f,  7.586356e-003f,  1.722371e-003f, -1.822223e-003f, -2.056038e-003f, -3.052840e-003f,
   -3.394579e-003f, -6.034556e-004f,  1.184525e-003f, -1.441566e-003f, -3.451861e-003f, -5.921120e-004f,  1.775065e-003f, -1.378813e-003f,
   -4.560717e-003f, -1.705549e-003f,  2.064769e-003f, -4.540431e-004f, -5.075144e-003f, -3.257434e-003f,  3.113674e-003f,  5.225484e-003f,
    1.732874e-003f, -7.771087e-004f,  5.872306e-004f,  2.237509e-003f,  1.891567e-003f,  1.099077e-003f,  2.391870e-004f, -2.080346e-003f,
   -4.454888e-003f, -3.664940e-003f, -6.544600e-004f,  1.224012e-004f, -2.212302e-003f, -4.163931e-003f, -4.585523e-003f, -5.865523e-003f,
   -7.353801e-003f, -4.678114e-003f,  2.005889e-003f,  6.087046e-003f,  4.180816e-003f,  1.172634e-003f,  1.779160e-003f,  3.449188e-003f,
    2.120095e-003f, -6.808512e-004f, -1.276489e-003f,  1.854832e-004f,  1.475310e-003f,  2.406083e-003f,  3.794011e-003f,  4.960950e-003f,
    4.569864e-003f,  2.397843e-003f, -1.893334e-004f, -7.018796e-004f,  1.824635e-003f,  4.026475e-003f,  1.852982e-003f, -2.365289e-003f,
   -2.322747e-003f,  1.875657e-003f,  3.416697e-003f,  3.933221e-004f, -1.313709e-003f,  9.595039e-004f,  2.460210e-003f,  6.494216e-004f,
   -6.356520e-004f,  4.469541e-004f,  3.934870e-004f, -2.186665e-003f, -4.117414e-003f, -3.968371e-003f, -3.346224e-003f, -2.301678e-003f,
   -3.430979e-004f,  2.503716e-004f, -1.427850e-003f, -1.645015e-003f,  1.092860e-003f,  2.082349e-003f, -8.639969e-004f, -2.687599e-003f,
   -7.168952e-004f,  3.073446e-004f, -1.784476e-003f, -2.013183e-003f,  1.402263e-003f,  3.294169e-003f,  2.268040e-003f,  3.267183e-003f,
    6.222224e-003f,  4.830901e-003f, -7.341387e-004f, -2.861253e-003f, -1.003741e-004f,  1.126801e-003f, -7.160215e-004f, -6.133628e-004f,
    1.755726e-003f,  1.495615e-003f, -1.157119e-003f, -1.341465e-003f,  7.745937e-004f,  1.056569e-003f, -9.843014e-005f,  5.429223e-004f,
    1.972159e-003f,  1.606949e-003f,  1.174166e-003f,  2.936161e-003f,  4.435133e-003f,  2.990242e-003f,  8.567586e-004f,  1.027327e-003f,
    2.434812e-003f,  3.012956e-003f,  3.144457e-003f,  3.492216e-003f,  3.357705e-003f,  2.636812e-003f,  2.115508e-003f,  1.681465e-003f,
    9.682598e-004f,  7.137905e-004f,  1.181680e-003f,  1.133965e-003f,  1.515610e-004f, -4.356813e-004f,  7.422979e-006f,  7.688457e-004f,
    1.721094e-003f,  2.895168e-003f,  2.875224e-003f,  9.099059e-004f, -7.519634e-004f,  5.750446e-005f,  1.844021e-003f,  1.958316e-003f,
    4.906746e-004f, -7.815388e-004f, -8.989644e-004f,  3.672051e-004f,  2.366214e-003f,  2.888838e-003f,  8.073763e-004f, -1.236644e-003f,
   -4.145358e-004f,  1.610575e-003f,  1.660666e-003f,  3.803945e-004f,  1.992884e-004f,  6.840644e-004f,  3.398248e-004f,  1.268376e-004f,
    1.103047e-003f,  1.622649e-003f,  4.084670e-004f, -7.134744e-004f,  1.015135e-005f,  1.421498e-003f,  1.878494e-003f,  1.697340e-003f,
    1.819368e-003f,  2.252767e-003f,  2.316163e-003f,  1.198805e-003f, -9.057971e-004f, -1.908095e-003f, -3.328390e-004f,  1.640987e-003f,
    1.088447e-003f, -8.371300e-004f, -1.375887e-003f, -1.400122e-003f, -2.878050e-003f, -3.975186e-003f, -2.622590e-003f, -1.392526e-003f,
   -2.812933e-003f, -4.383411e-003f, -3.945690e-003f, -3.977122e-003f, -5.042088e-003f, -2.683274e-003f,  3.444440e-003f,  6.229904e-003f,
    2.731442e-003f, -4.022694e-004f,  1.312117e-003f,  3.158527e-003f,  1.301038e-003f, -3.162489e-004f,  1.673842e-003f,  4.027327e-003f,
    3.315238e-003f,  6.496043e-004f, -1.827827e-003f, -2.487080e-003f,  6.548588e-004f,  5.856792e-003f,  6.506045e-003f,  7.862735e-004f,
   -3.441327e-003f, -5.109212e-004f,  3.833603e-003f,  2.607586e-003f, -1.359813e-003f, -2.225497e-003f, -7.975799e-004f, -3.175926e-004f,
   -1.134673e-004f,  9.293015e-004f,  1.309859e-003f,  6.520883e-004f,  2.642726e-004f, -5.683003e-004f, -2.472861e-003f, -2.208588e-003f,
    2.064240e-003f,  5.514738e-003f,  3.759789e-003f,  2.163898e-004f, -3.682376e-004f,  4.878518e-004f, -4.966373e-005f, -6.758925e-004f,
   -5.345518e-004f, -1.658620e-003f, -3.280815e-003f, -1.856587e-003f,  1.467311e-003f,  2.075162e-003f,  4.173777e-004f,  2.040109e-004f,
    2.084745e-004f, -2.448354e-003f, -4.568962e-003f, -2.326955e-003f,  6.230503e-004f, -2.088690e-005f, -8.562124e-004f,  1.746999e-003f,
    3.864035e-003f,  2.195833e-003f,  9.395441e-004f,  2.866434e-003f,  3.517875e-003f,  8.477721e-004f, -9.251506e-005f,  2.493088e-003f,
    3.341518e-003f,  8.001748e-004f, -1.999066e-004f,  1.386357e-003f,  9.120816e-004f, -1.733874e-003f, -1.589205e-003f,  1.162867e-003f,
    1.380442e-003f, -1.074465e-003f, -1.572565e-003f,  4.765755e-004f,  1.786557e-003f,  1.765098e-003f,  1.727608e-003f,  1.071057e-003f,
   -1.824152e-004f,  1.895566e-004f,  1.572264e-003f,  1.204095e-004f, -3.569742e-003f, -3.887519e-003f,  6.869972e-005f,  2.338194e-003f,
    2.036455e-004f, -1.721675e-003f, -1.848504e-004f,  1.484637e-003f, -1.462702e-004f, -2.959976e-003f, -3.136440e-003f, -6.487787e-004f,
    1.583213e-003f,  1.956210e-003f,  1.689295e-003f,  2.269482e-003f,  2.823412e-003f,  1.848900e-003f,  7.921793e-004f,  2.266960e-003f,
    4.721805e-003f,  3.865436e-003f, -9.614127e-006f, -1.891883e-003f,  1.195531e-004f,  3.028163e-003f,  4.978099e-003f,  6.406720e-003f,
    6.165204e-003f,  3.613497e-003f,  2.221528e-003f,  3.568886e-003f,  2.191591e-003f, -4.920847e-003f, -1.006239e-002f, -6.558483e-003f,
   -1.427497e-003f, -4.091579e-003f, -1.002758e-002f, -9.270855e-003f, -4.095573e-003f, -3.680022e-003f, -6.918779e-003f, -5.001702e-003f,
    2.795401e-003f,  8.851526e-003f,  1.009125e-002f,  1.016485e-002f,  1.042370e-002f,  7.816780e-003f,  1.687324e-003f, -3.595356e-003f,
   -3.934245e-003f, -6.911893e-004f,  8.450426e-004f, -1.575783e-003f, -3.499678e-003f, -2.957852e-004f,  4.625066e-003f,  4.377641e-003f,
   -1.311311e-004f, -1.955827e-003f, -3.178874e-005f,  5.656265e-004f, -7.688997e-004f, -2.201740e-004f,  1.052735e-003f, -1.044156e-003f,
   -4.126936e-003f, -3.488398e-003f, -2.112468e-003f, -4.497764e-003f, -5.805173e-003f, -3.395699e-004f,  5.617762e-003f,  3.586990e-003f,
   -1.658819e-003f, -9.075575e-004f,  3.181508e-003f,  3.285069e-003f,  2.133049e-003f,  4.980752e-003f,  6.724398e-003f,  1.882340e-003f,
   -2.166630e-003f,  2.452823e-003f,  8.053620e-003f,  3.668989e-003f, -5.378059e-003f, -6.224774e-003f,  5.783737e-004f,  4.295751e-003f,
    2.390472e-003f,  1.300689e-003f,  2.850297e-003f,  2.582278e-003f, -5.465155e-004f, -2.831541e-003f, -2.714710e-003f, -1.737169e-003f,
   -4.518310e-004f,  1.135241e-003f,  1.409705e-003f, -2.223815e-004f, -1.295527e-003f, -3.299039e-004f,  3.729798e-004f, -8.938991e-004f,
   -1.815603e-003f, -3.665227e-004f,  1.179128e-003f,  2.243764e-004f, -1.579961e-003f, -1.582256e-003f, -8.223109e-004f, -1.499925e-003f,
   -2.633543e-003f, -2.336280e-003f, -1.683250e-003f, -2.103369e-003f, -1.720992e-003f,  1.129922e-003f,  3.489303e-003f,  1.879028e-003f,
   -1.544895e-003f, -2.028907e-003f,  6.308649e-004f,  2.813770e-003f,  2.978230e-003f,  2.272881e-003f,  1.162158e-003f, -3.854695e-004f,
   -1.154908e-003f, -5.533012e-004f, -2.222717e-004f, -1.220596e-003f, -2.096702e-003f, -1.722695e-003f, -1.106372e-003f, -8.824097e-004f,
   -1.623165e-004f,  1.050281e-003f,  1.391690e-003f,  5.734840e-004f, -5.484891e-004f, -2.074542e-003f, -4.564392e-003f, -7.086064e-003f,
   -7.720368e-003f, -5.108569e-003f,  6.860343e-004f,  6.560290e-003f,  6.976756e-003f,  5.192126e-004f, -6.197168e-003f, -6.825502e-003f,
   -4.304064e-003f, -4.434159e-003f, -5.138222e-003f, -1.723013e-003f,  2.190973e-003f,  6.707837e-004f, -2.263428e-003f,  8.820763e-004f,
    6.699784e-003f,  6.321058e-003f,  1.133690e-003f, -4.308266e-004f,  2.025500e-003f,  2.261282e-003f,  2.493780e-004f,  9.511112e-004f,
    3.499855e-003f,  3.117203e-003f,  6.874973e-004f,  4.657877e-004f,  1.708919e-003f,  1.143693e-003f, -7.350832e-005f,  8.167973e-004f,
    2.396809e-003f,  2.152595e-003f,  1.348506e-003f,  2.047378e-003f,  3.025160e-003f,  2.259314e-003f,  3.594993e-004f, -7.071281e-004f,
   -6.413052e-006f,  1.855716e-003f,  3.046692e-003f,  2.225401e-003f,  6.854113e-004f,  4.853478e-004f,  7.348855e-004f, -4.278935e-004f,
   -1.390257e-003f,  5.887939e-005f,  1.358286e-003f, -7.057338e-004f, -3.063635e-003f, -1.214581e-003f,  1.999459e-003f,  9.860485e-004f,
   -2.430520e-003f, -2.435923e-003f,  3.265027e-004f,  8.000936e-004f, -8.824692e-004f, -5.149209e-004f,  1.884228e-003f,  2.557108e-003f,
    8.216880e-004f, -6.691125e-004f, -6.173797e-004f,  2.606797e-004f,  1.199068e-003f,  1.346578e-003f,  5.747342e-005f, -1.554307e-003f,
   -1.704619e-003f, -5.379156e-004f,  5.426701e-004f,  9.504871e-004f,  5.715901e-004f, -4.500055e-004f, -5.941344e-004f,  1.206690e-003f,
    2.706613e-003f,  1.500280e-003f, -2.634161e-004f,  4.420993e-004f,  1.634949e-003f,  2.964295e-004f, -1.400516e-003f, -6.715190e-004f,
   -1.508304e-004f, -2.175172e-003f, -3.117037e-003f, -7.475003e-004f,  2.026809e-004f, -2.802620e-003f, -4.242545e-003f, -1.159416e-003f,
    4.778134e-004f, -2.714806e-003f, -4.779711e-003f, -2.210215e-003f, -6.669790e-004f, -3.234030e-003f, -4.148106e-003f, -3.785830e-004f,
    2.596247e-003f,  1.671396e-003f,  9.950112e-004f,  2.276716e-003f,  1.717037e-003f, -1.033577e-003f, -1.702898e-003f,  2.154907e-005f,
    6.009487e-004f,  1.197616e-004f,  6.434775e-004f,  3.921439e-004f, -2.167159e-003f, -3.539792e-003f, -1.852798e-003f, -1.289048e-003f,
   -3.542786e-003f, -3.737119e-003f, -4.071296e-004f,  9.212870e-004f, -1.164084e-003f, -1.064838e-003f,  1.854513e-003f,  1.382646e-003f,
   -2.467606e-003f, -2.378619e-003f,  1.953343e-003f,  2.670247e-003f, -1.541197e-003f, -3.818371e-003f, -2.575295e-003f, -2.385893e-003f,
   -2.396496e-003f,  1.613649e-003f,  5.505856e-003f,  1.931498e-003f, -5.192899e-003f, -6.059999e-003f, -1.906827e-003f, -1.839218e-003f,
   -5.738675e-003f, -5.244521e-003f,  2.909118e-004f,  3.041815e-003f,  9.215164e-004f, -1.854884e-004f,  1.711500e-003f,  1.678199e-003f,
   -2.419038e-003f, -5.886202e-003f, -4.393096e-003f,  6.759078e-004f,  5.024697e-003f,  5.886675e-003f,  3.496087e-003f,  3.634649e-004f,
   -1.180907e-003f, -1.310562e-003f, -1.406365e-003f, -1.161338e-003f,  3.477440e-004f,  1.575990e-003f,  2.501894e-004f, -2.242048e-003f,
   -2.406896e-003f, -5.456706e-004f, -4.838075e-004f, -2.833202e-003f, -3.529763e-003f, -7.148191e-004f,  1.884174e-003f,  1.115791e-003f,
   -7.055799e-004f, -6.086602e-004f, -2.407666e-004f, -1.809949e-003f, -2.818375e-003f, -3.595196e-004f,  2.821664e-003f,  2.696134e-003f,
    1.152728e-003f,  2.055544e-003f,  3.278782e-003f,  4.861810e-004f, -3.853756e-003f, -3.863480e-003f, -6.064663e-004f, -7.324586e-006f,
   -2.009735e-003f, -1.217108e-003f,  2.602010e-003f,  4.123926e-003f,  2.269112e-003f,  1.328277e-003f,  2.288122e-003f,  1.594233e-003f,
   -1.198016e-003f, -2.407360e-003f, -1.150521e-003f, -3.973794e-004f, -1.223217e-003f, -2.054701e-003f, -2.817187e-003f, -4.193129e-003f,
   -4.184307e-003f, -9.173151e-004f,  2.837400e-003f,  3.207223e-003f,  1.301610e-003f,  6.960129e-004f,  1.119125e-003f, -5.738628e-005f,
   -2.107173e-003f, -2.187343e-003f, -7.764930e-004f, -5.778472e-004f, -1.065961e-003f,  5.324875e-004f,  3.240556e-003f,  2.823496e-003f,
   -1.024873e-003f, -3.279341e-003f, -1.173968e-003f,  1.693983e-003f,  1.604351e-003f,  4.067538e-004f,  1.037170e-003f,  1.573880e-003f,
   -9.505376e-004f, -4.035655e-003f, -3.057007e-003f,  1.081840e-003f,  3.771370e-003f,  4.339534e-003f,  5.515304e-003f,  6.863004e-003f,
    5.476245e-003f,  2.128991e-003f,  2.487299e-004f, -1.498386e-004f, -1.328118e-003f, -2.246816e-003f, -4.949503e-004f,  2.024490e-003f,
    1.742575e-003f, -1.659717e-004f, -1.472370e-004f,  1.252760e-003f,  1.197689e-003f,  2.373007e-004f,  5.570723e-004f,  1.421907e-003f,
    1.350624e-003f,  1.395444e-003f,  1.921232e-003f,  4.939295e-004f, -2.960620e-003f, -4.136908e-003f, -1.511989e-003f,  3.350178e-004f,
   -1.431582e-003f, -3.150902e-003f, -1.927837e-003f, -9.043576e-004f, -2.696069e-003f, -4.086583e-003f, -2.102731e-003f,  4.859716e-004f,
    3.984144e-004f, -5.906636e-004f,  4.041616e-004f,  2.228142e-003f,  2.209594e-003f,  4.452888e-004f, -1.146807e-003f, -1.382437e-003f,
    2.763692e-005f,  2.379326e-003f,  3.535883e-003f,  2.054496e-003f, -2.466193e-004f, -3.955137e-005f,  3.502124e-003f,  7.937429e-003f,
    9.934633e-003f,  7.678367e-003f,  2.532063e-003f, -1.535946e-003f, -2.267043e-003f, -1.876750e-003f, -2.530755e-003f, -1.668966e-003f,
    2.778120e-003f,  5.569514e-003f,  8.549387e-004f, -6.115575e-003f, -4.386715e-003f,  5.265846e-003f,  9.733743e-003f,  3.204621e-003f,
   -4.132964e-003f, -2.412828e-003f,  3.427397e-003f,  3.339967e-003f, -1.960708e-003f, -4.220103e-003f, -1.552436e-003f,  2.954835e-004f,
   -1.605801e-003f, -3.778248e-003f, -3.118947e-003f, -1.094543e-003f, -1.571709e-004f, -1.673545e-004f,  3.460730e-004f,  1.754093e-003f,
    2.901132e-003f,  2.040911e-003f, -1.294375e-003f, -4.497012e-003f, -3.628304e-003f,  1.321444e-003f,  4.817380e-003f,  2.123907e-003f,
   -4.105306e-003f, -6.865424e-003f, -3.800320e-003f,  4.792983e-004f,  1.372289e-003f, -1.923274e-004f, -7.267601e-004f,  5.362884e-004f,
    1.791566e-003f,  1.996927e-003f,  1.476161e-003f,  3.445050e-004f, -1.403166e-003f, -2.776116e-003f, -2.526387e-003f, -8.705746e-004f,
    5.541357e-004f,  3.641991e-004f, -1.215366e-003f, -2.348945e-003f, -1.376168e-003f,  6.812445e-004f,  6.432841e-004f, -2.227089e-003f,
   -3.967191e-003f, -1.066115e-003f,  3.903746e-003f,  5.667839e-003f,  3.864014e-003f,  2.682282e-003f,  3.866839e-003f,  5.245327e-003f,
    5.779690e-003f,  6.548645e-003f,  6.623887e-003f,  3.641996e-003f, -9.514740e-004f, -2.751144e-003f, -1.214316e-003f, -2.406652e-004f,
   -1.240082e-003f, -1.231131e-003f,  1.070975e-003f,  2.813281e-003f,  2.202662e-003f,  1.118315e-003f,  8.618729e-004f, -9.015641e-005f,
   -2.238722e-003f, -3.059752e-003f, -1.007842e-003f,  1.579668e-003f,  1.686577e-003f, -2.976365e-004f, -1.480711e-003f, -4.708423e-004f,
    9.622025e-004f,  5.750966e-004f, -7.321069e-004f,  1.154743e-004f,  3.033182e-003f,  3.474882e-003f, -7.036694e-004f, -4.433035e-003f,
   -2.350765e-003f,  2.398435e-003f,  2.839546e-003f, -4.595596e-004f, -7.073199e-004f,  3.068340e-003f,  4.155118e-003f, -3.214270e-004f,
   -4.503976e-003f, -3.425378e-003f, -2.385323e-004f,  8.836632e-005f, -1.532745e-003f, -1.316240e-003f,  7.536846e-004f,  1.521675e-003f,
   -2.211003e-004f, -2.363169e-003f, -2.469879e-003f, -5.379071e-004f,  1.116148e-003f,  4.581647e-004f, -1.845839e-003f, -3.352647e-003f,
   -2.932883e-003f, -1.362273e-003f,  6.873325e-004f,  2.757046e-003f,  3.231899e-003f,  1.131141e-003f, -1.143701e-003f, -5.393515e-004f,
    1.711795e-003f,  2.006504e-003f,  4.124030e-004f,  5.018041e-006f,  9.562130e-004f,  6.115568e-004f, -1.073675e-003f, -1.637441e-003f,
   -1.173119e-003f, -1.841105e-003f, -2.845507e-003f, -1.300638e-003f,  2.329980e-003f,  4.576737e-003f,  4.078315e-003f,  2.231333e-003f,
    2.243650e-004f, -9.812815e-004f, -1.632148e-004f,  1.570392e-003f,  1.284644e-003f, -2.575573e-004f,  1.001061e-003f,  4.173586e-003f,
    3.216298e-003f, -1.921408e-003f, -3.342401e-003f,  1.148184e-003f,  3.010426e-003f, -2.441952e-003f, -7.444838e-003f, -5.060576e-003f,
   -1.545266e-004f,  9.831599e-004f,  1.363351e-003f,  5.031949e-003f,  8.070942e-003f,  6.366362e-003f,  3.089892e-003f,  1.044185e-003f,
   -2.753609e-003f, -8.181996e-003f, -8.300994e-003f, -1.351304e-003f,  4.173818e-003f,  3.045436e-003f,  1.164662e-003f,  3.597316e-003f,
    5.674494e-003f,  2.695752e-003f, -1.574920e-003f, -2.430606e-003f, -1.359197e-003f, -6.727334e-004f,  7.405155e-004f,  2.728430e-003f,
    2.809149e-003f,  1.793774e-003f,  2.694429e-003f,  3.685745e-003f,  5.396956e-004f, -4.521892e-003f, -5.288808e-003f, -1.854373e-003f,
    3.556061e-004f,  2.104913e-004f,  7.314652e-004f,  1.405947e-003f, -5.347207e-004f, -3.237890e-003f, -2.916288e-003f, -1.124191e-003f,
   -1.741097e-003f, -3.433371e-003f, -2.390477e-003f,  2.840190e-004f,  7.654303e-004f, -6.157617e-004f, -7.910168e-004f,  3.433341e-004f,
    8.804066e-004f,  1.027072e-003f,  1.875287e-003f,  2.442150e-003f,  1.390281e-003f, -5.403185e-004f, -2.118534e-003f, -3.179680e-003f,
   -3.231263e-003f, -1.397081e-003f,  1.269402e-003f,  2.411251e-003f,  1.991241e-003f,  2.368477e-003f,  4.296144e-003f,  5.614785e-003f,
    4.422395e-003f,  1.370529e-003f, -1.431851e-003f, -2.268259e-003f, -8.620811e-004f,  1.213078e-003f,  1.803592e-003f,  7.396828e-004f,
    1.288509e-004f,  1.328198e-003f,  2.886784e-003f,  2.520077e-003f,  2.736456e-004f, -1.284951e-003f, -3.626612e-005f,  2.835832e-003f,
    3.682650e-003f,  9.515938e-004f, -2.106415e-003f, -1.502621e-003f,  1.553745e-003f,  2.304677e-003f, -1.720092e-004f, -1.816250e-003f,
   -6.297034e-004f,  3.817829e-004f, -7.153820e-004f, -1.230301e-003f,  5.236305e-004f,  1.378346e-003f, -8.595603e-004f, -2.739383e-003f,
   -1.105879e-003f,  1.012922e-003f, -6.476770e-005f, -1.713608e-003f,  1.126248e-004f,  2.999109e-003f,  2.206542e-003f, -5.044925e-004f,
    1.090368e-004f,  3.210324e-003f,  3.301021e-003f, -1.215403e-004f, -2.123132e-003f, -9.610603e-004f,  1.939037e-004f, -1.912910e-005f,
    4.485727e-004f,  1.836270e-003f,  1.887358e-003f,  5.236929e-004f,  2.276796e-005f,  7.588884e-004f,  1.017368e-003f,  1.851067e-004f,
   -1.141865e-003f, -2.401784e-003f, -2.170876e-003f,  6.855061e-004f,  3.407611e-003f,  1.833493e-003f, -2.251156e-003f, -2.765559e-003f,
    5.648769e-004f,  1.805159e-003f, -3.572497e-004f, -8.705729e-004f,  1.163277e-003f,  8.410294e-004f, -1.899621e-003f, -1.368199e-003f,
    2.177197e-003f,  1.890425e-003f, -2.505521e-003f, -3.358768e-003f,  8.532056e-004f,  2.748016e-003f, -2.662485e-004f, -2.095569e-003f,
   -3.049853e-004f, -1.324714e-004f, -3.402035e-003f, -4.738542e-003f, -1.623912e-003f,  1.575287e-003f,  1.711718e-003f,  6.823932e-004f,
    2.036763e-004f, -2.001188e-004f, -2.260255e-004f,  4.126084e-004f, -1.352621e-004f, -2.424535e-003f, -3.224539e-003f, -5.934506e-004f,
    2.593226e-003f,  3.595004e-003f,  3.502266e-003f,  3.387725e-003f,  2.188481e-003f,  3.411820e-004f, -3.763342e-005f,  5.642768e-004f,
    2.011824e-004f,  1.843498e-004f,  2.476341e-003f,  4.300305e-003f,  2.221968e-003f, -9.614031e-004f, -5.319202e-004f,  2.094877e-003f,
    2.690352e-003f,  1.797539e-003f,  1.962757e-003f,  1.620671e-003f, -1.262883e-003f, -3.666459e-003f, -2.152365e-003f,  1.025776e-003f,
    1.974863e-003f,  1.123457e-003f,  6.185463e-004f,  2.661488e-004f, -1.590867e-004f,  8.420743e-004f,  2.833451e-003f,  2.571920e-003f,
   -6.169875e-004f, -2.790974e-003f, -9.392336e-004f,  2.777814e-003f,  4.050807e-003f,  1.554944e-003f, -1.838762e-003f, -2.232972e-003f,
    7.374892e-004f,  3.154092e-003f,  2.083504e-003f, -3.500808e-004f, -1.071756e-003f, -1.161239e-003f, -2.351959e-003f, -2.197490e-003f,
    1.301828e-003f,  4.182460e-003f,  2.424793e-003f, -6.838485e-004f, -1.775175e-004f,  2.041296e-003f,  1.521464e-003f, -7.019090e-004f,
   -1.562994e-003f, -2.207187e-003f, -3.908552e-003f, -3.569737e-003f,  8.952372e-005f,  2.127476e-003f, -5.768918e-004f, -3.456462e-003f,
   -2.136688e-003f,  6.585314e-004f,  1.127542e-003f,  3.001044e-004f, -3.547113e-004f, -2.146095e-003f, -4.582332e-003f, -4.550386e-003f,
   -2.316373e-003f, -1.455804e-003f, -2.040147e-003f, -1.178881e-003f,  9.406248e-005f, -1.615741e-003f, -4.607055e-003f, -4.177149e-003f,
   -7.998826e-004f,  1.211153e-003f,  9.778981e-004f,  1.238882e-004f, -1.999490e-003f, -5.356565e-003f, -5.754620e-003f, -1.087748e-003f,
    3.550518e-003f,  3.215581e-003f,  3.979831e-004f, -7.020588e-004f, -1.194428e-003f, -3.067599e-003f, -3.865171e-003f, -1.558896e-003f,
    7.375937e-004f, -5.596025e-005f, -2.013504e-003f, -2.251639e-003f, -1.281330e-003f, -5.434115e-004f,  5.379909e-005f,  4.876526e-004f,
    3.668522e-004f,  4.856458e-004f,  1.107915e-003f,  3.274974e-004f, -2.096022e-003f, -2.474692e-003f,  8.070313e-004f,  3.263183e-003f,
    1.359288e-003f, -1.282920e-003f, -3.899411e-004f,  1.541814e-003f,  6.942002e-004f, -3.816230e-004f,  2.385263e-003f,  6.259639e-003f,
    5.430067e-003f,  3.539073e-004f, -2.937263e-003f, -1.424341e-003f,  1.888594e-003f,  2.997844e-003f,  1.623182e-003f,  5.883014e-004f,
    1.771511e-003f,  3.463484e-003f,  2.777264e-003f,  2.421684e-004f, -7.951192e-004f,  5.108990e-004f,  1.690813e-003f,  1.833846e-003f,
    2.380175e-003f,  2.590012e-003f,  6.828891e-005f, -3.552503e-003f, -3.844563e-003f, -1.017449e-003f,  5.654566e-004f,  1.868176e-004f,
    8.196833e-004f,  2.125621e-003f,  1.360069e-003f,  4.340297e-005f,  1.366682e-003f,  2.885556e-003f,  6.067573e-004f, -2.457933e-003f,
   -1.263078e-003f,  1.356366e-003f, -8.046818e-005f, -2.748041e-003f, -7.824851e-004f,  2.892995e-003f,  1.604823e-003f, -2.458930e-003f,
   -2.394056e-003f,  8.132725e-004f,  1.375989e-003f,  1.328119e-004f,  1.406159e-003f,  2.738435e-003f, -6.647487e-004f, -5.095084e-003f,
   -3.327634e-003f,  2.646383e-003f,  4.571470e-003f,  1.226141e-003f, -1.057505e-003f,  4.567143e-004f,  2.039766e-003f,  1.142638e-003f,
   -3.095130e-004f, -3.934131e-004f,  2.967113e-004f,  8.968438e-004f,  1.524905e-003f,  2.090701e-003f,  1.943069e-003f,  8.341792e-004f,
   -5.373692e-004f, -8.908196e-004f,  4.296446e-004f,  2.295626e-003f,  2.819029e-003f,  1.884740e-003f,  1.132246e-003f,  1.171257e-003f,
    9.265256e-004f,  7.180403e-005f, -2.612422e-004f,  4.013459e-004f,  1.257255e-003f,  1.827413e-003f,  2.170402e-003f,  1.890950e-003f,
    8.677260e-004f,  1.714865e-004f,  4.606620e-004f,  6.454525e-004f, -2.367296e-004f, -1.361400e-003f, -1.768218e-003f, -1.881208e-003f,
   -2.150305e-003f, -2.052400e-003f, -1.403928e-003f, -8.998819e-004f, -8.421637e-004f, -8.927648e-004f, -9.483197e-004f, -9.064833e-004f,
   -4.697646e-004f, -3.078207e-004f, -1.559746e-003f, -3.126108e-003f, -2.325672e-003f,  4.762229e-004f,  1.530179e-003f, -4.229495e-004f,
   -2.048452e-003f, -1.090962e-003f,  1.242164e-004f, -9.406965e-004f, -3.109800e-003f, -4.010938e-003f, -3.169284e-003f, -1.267781e-003f,
    6.373277e-004f,  8.488504e-004f, -9.284509e-004f, -1.929362e-003f, -7.942549e-005f,  2.118070e-003f,  1.366143e-003f, -8.113058e-004f,
   -8.525443e-004f,  5.209664e-004f, -7.286917e-005f, -2.350537e-003f, -2.960656e-003f, -1.501602e-003f, -9.735908e-004f, -2.413230e-003f,
   -3.383292e-003f, -2.281784e-003f, -7.745455e-004f, -8.884557e-004f, -1.879303e-003f, -1.442668e-003f,  7.165599e-004f,  1.969493e-003f,
    1.194056e-004f, -3.196129e-003f, -4.144323e-003f, -1.657034e-003f,  1.279735e-003f,  1.749026e-003f,  2.272852e-004f, -1.032560e-003f,
   -1.083133e-003f, -7.421683e-004f, -1.153416e-003f, -2.420862e-003f, -3.085025e-003f, -1.509635e-003f,  1.500428e-003f,  2.893381e-003f,
    1.344697e-003f, -8.281469e-004f, -1.211909e-003f, -5.479745e-004f, -5.614326e-004f, -8.724396e-004f, -3.924767e-004f,  2.084400e-004f,
   -1.416323e-004f, -6.546202e-004f, -2.569476e-005f,  1.110980e-003f,  1.059897e-003f, -2.550445e-004f, -1.081128e-003f, -2.325400e-004f,
    1.277654e-003f,  1.451575e-003f,  2.638154e-006f, -9.570671e-004f,  2.855046e-004f,  2.387301e-003f,  2.721795e-003f,  1.238642e-003f,
    3.630102e-004f,  1.196879e-003f,  2.202736e-003f,  1.936731e-003f,  8.901223e-004f,  8.504223e-005f, -3.969538e-004f, -8.966135e-004f,
   -1.328893e-003f, -1.273351e-003f, -5.284008e-004f,  3.372887e-004f,  1.994356e-004f, -1.128823e-003f, -2.180015e-003f, -1.792135e-003f,
   -8.267110e-004f, -3.847061e-004f,  1.410432e-004f,  1.150829e-003f,  1.119953e-003f, -4.074085e-004f, -6.910335e-004f,  1.725244e-003f,
    3.263464e-003f,  6.225909e-004f, -2.903816e-003f, -1.949382e-003f,  2.178286e-003f,  3.330264e-003f, -3.819143e-005f, -3.221092e-003f,
   -2.804637e-003f, -5.033807e-004f,  7.900975e-004f,  2.738679e-004f, -1.731793e-003f, -4.216489e-003f, -4.854201e-003f, -2.236402e-003f,
    1.426529e-003f,  2.661170e-003f,  1.179431e-003f, -6.393223e-004f, -1.547229e-003f, -1.845354e-003f, -1.322253e-003f,  1.525194e-004f,
    1.171926e-003f,  7.493955e-004f,  1.975255e-004f,  4.016205e-004f, -3.762364e-004f, -2.760718e-003f, -3.417941e-003f, -1.958358e-004f,
    3.073272e-003f,  2.031552e-003f, -1.055643e-003f, -1.389025e-003f,  3.580245e-004f,  7.407289e-004f,  9.132643e-004f,  3.514963e-003f,
    5.203836e-003f,  1.274479e-003f, -4.356235e-003f, -3.465285e-003f,  3.013596e-003f,  5.515265e-003f,  2.308384e-004f, -5.911751e-003f,
   -5.874990e-003f, -6.526489e-004f,  4.438949e-003f,  5.615165e-003f,  2.225036e-003f, -2.681521e-003f, -3.855043e-003f,  1.700648e-004f,
    4.356254e-003f,  3.931849e-003f,  7.997453e-004f, -6.338779e-004f, -3.195967e-004f, -8.726146e-004f, -2.320015e-003f, -2.809784e-003f,
   -2.109263e-003f, -1.130258e-003f, -2.438776e-005f,  1.062476e-003f,  1.195102e-003f, -6.001941e-006f, -1.438592e-003f, -1.289192e-003f,
    1.510184e-003f,  5.327679e-003f,  5.817230e-003f,  1.009496e-003f, -4.309442e-003f, -4.047236e-003f,  2.821939e-004f,  2.215643e-003f,
    7.236985e-004f,  2.942806e-004f,  1.573541e-003f,  6.290535e-004f, -2.624518e-003f, -3.758715e-003f, -1.526669e-003f,  1.249697e-003f,
    3.318284e-003f,  4.662289e-003f,  3.226094e-003f, -1.205370e-003f, -3.616939e-003f, -6.950098e-004f,  3.644994e-003f,  5.222786e-003f,
    5.605980e-003f,  6.067222e-003f,  3.755224e-003f, -8.354975e-004f, -1.682860e-003f,  2.374320e-003f,  4.566502e-003f,  1.760107e-003f,
   -1.033663e-003f, -1.004420e-003f, -1.456042e-003f, -2.735244e-003f, -7.053225e-004f,  3.557936e-003f,  3.970347e-003f,  6.716754e-004f,
   -2.432138e-004f,  1.504891e-003f,  4.495042e-004f, -2.951643e-003f, -2.381846e-003f,  2.377712e-003f,  4.291857e-003f,  5.787906e-004f,
   -3.443335e-003f, -2.735652e-003f,  1.630993e-003f,  5.202652e-003f,  4.812927e-003f,  1.245664e-003f, -1.335597e-003f, -4.323430e-004f,
    1.297129e-003f,  8.336026e-004f,  2.525273e-005f,  1.106561e-003f,  1.404142e-003f, -1.177869e-003f, -2.574001e-003f,  4.393605e-004f,
    3.406988e-003f,  1.754505e-003f, -1.091355e-003f, -5.610069e-004f,  7.784804e-004f, -8.317179e-004f, -2.747823e-003f, -1.156650e-003f,
    2.159492e-003f,  3.730022e-003f,  3.304959e-003f,  1.444220e-003f, -1.708502e-003f, -3.689307e-003f, -2.298429e-003f, -6.800299e-004f,
   -2.707450e-003f, -5.267547e-003f, -3.212689e-003f,  1.020056e-003f,  1.559973e-003f, -6.308728e-004f, -6.403927e-004f,  1.031858e-003f,
    7.515335e-004f, -5.568599e-004f, -6.593512e-005f,  7.757396e-004f, -1.458954e-004f, -3.694161e-004f,  2.463902e-003f,  5.319580e-003f,
    4.454222e-003f,  9.814224e-004f, -1.935206e-003f, -2.880659e-003f, -1.202601e-003f,  2.512932e-003f,  4.169139e-003f,  2.563064e-004f,
   -5.671360e-003f, -6.778978e-003f, -2.679962e-003f,  9.903392e-004f,  1.775847e-003f,  2.457378e-003f,  4.372791e-003f,  4.931714e-003f,
    2.332527e-003f, -1.458978e-003f, -2.873905e-003f, -1.098232e-004f,  4.670173e-003f,  6.356212e-003f,  2.768701e-003f, -1.371959e-003f,
   -6.215331e-004f,  2.777591e-003f,  2.886439e-003f,  4.765137e-004f,  9.879350e-004f,  3.269784e-003f,  7.480166e-004f, -5.456470e-003f,
   -5.878053e-003f,  1.815405e-003f,  7.719901e-003f,  4.995747e-003f,  1.253274e-005f,  7.122618e-004f,  4.214373e-003f,  4.136322e-003f,
    2.185615e-003f,  2.912420e-003f,  3.360981e-003f, -1.376083e-003f, -6.803087e-003f, -4.541746e-003f,  3.199945e-003f,  5.911455e-003f,
    9.193544e-004f, -3.526444e-003f, -2.144706e-003f,  6.043418e-004f,  6.043547e-005f, -1.249402e-003f,  5.048793e-004f,  3.817358e-003f,
    4.830217e-003f,  2.653721e-003f, -8.015928e-004f, -3.447711e-003f, -4.347807e-003f, -4.212118e-003f, -4.222260e-003f, -3.548467e-003f,
   -4.038115e-004f,  3.639290e-003f,  4.316994e-003f,  9.531236e-004f, -2.340226e-003f, -2.839912e-003f, -1.773134e-003f, -2.555443e-004f,
    1.775994e-003f,  2.562585e-003f,  4.859976e-004f, -1.569805e-003f, -1.690796e-004f,  1.958823e-003f,  1.726676e-004f, -3.531275e-003f,
   -4.005707e-003f, -2.047901e-003f, -1.695052e-003f, -1.840712e-003f,  6.761358e-004f,  3.330143e-003f,  2.297972e-003f,  6.327397e-004f,
    2.913938e-003f,  5.925812e-003f,  4.033551e-003f, -2.126227e-004f, -2.873984e-004f,  3.027956e-003f,  3.621656e-003f,  4.775030e-004f,
   -2.035028e-003f, -2.000232e-003f, -1.087999e-003f,  6.826773e-005f,  1.657258e-003f,  1.804470e-003f, -9.126063e-004f, -3.670293e-003f,
   -2.598901e-003f,  1.253539e-003f,  2.930020e-003f,  3.292927e-004f, -3.014921e-003f, -2.807695e-003f,  2.025229e-004f,  1.319571e-003f,
   -1.425540e-003f, -4.358125e-003f, -3.417308e-003f,  2.478118e-004f,  2.609954e-003f,  2.416639e-003f,  1.194022e-003f, -3.682223e-004f,
   -2.297157e-003f, -3.213135e-003f, -2.010155e-003f, -4.439609e-004f, -8.934801e-004f, -2.677707e-003f, -3.154137e-003f, -1.389866e-003f,
    1.087269e-003f,  2.200604e-003f,  1.183594e-003f, -4.716638e-004f, -3.863534e-004f,  1.224758e-003f,  1.441229e-003f, -2.568704e-004f,
   -3.218566e-004f,  2.545133e-003f,  4.048354e-003f,  1.497236e-003f, -8.181374e-004f,  1.035274e-003f,  3.198816e-003f,  6.772851e-004f,
   -3.379500e-003f, -2.756724e-003f,  1.213545e-003f,  2.122793e-003f, -9.334884e-004f, -2.913889e-003f, -1.618893e-003f, -1.864851e-005f,
   -1.579523e-004f, -5.271986e-004f,  1.173579e-004f,  7.460711e-004f,  5.066731e-004f,  5.931771e-005f, -1.469297e-006f,  1.509634e-004f,
    5.838358e-004f,  1.512644e-003f,  2.185357e-003f,  1.503686e-003f, -8.669902e-005f, -8.295929e-004f, -1.034404e-004f,  8.477761e-004f,
    1.109072e-003f,  1.249234e-003f,  1.357664e-003f,  8.031326e-005f, -2.641673e-003f, -4.091057e-003f, -2.482376e-003f, -3.413891e-004f,
   -4.620154e-004f, -1.668670e-003f, -1.442638e-003f, -3.956553e-004f, -5.329715e-004f, -1.202571e-003f, -5.088115e-004f,  9.743252e-004f,
    1.325291e-003f,  5.439605e-004f, -2.221763e-004f, -1.038222e-003f, -2.188145e-003f, -2.568683e-003f, -1.357648e-003f,  3.307123e-004f,
    1.152643e-003f,  1.194624e-003f,  8.072892e-004f, -2.048821e-004f, -1.313586e-003f, -1.270770e-003f, -1.570994e-004f,  4.934453e-004f,
    8.632044e-005f, -3.602878e-004f, -1.837441e-004f,  6.289054e-005f, -6.102651e-005f, -2.130642e-004f, -1.039635e-004f,  1.136289e-004f,
    3.009388e-004f,  4.044435e-004f,  2.705696e-004f, -7.160706e-005f, -2.736377e-004f, -1.626030e-004f,  2.502108e-005f,  8.393251e-005f,
    7.916622e-005f,  7.359115e-005f,  2.706111e-005f, -2.730654e-005f, -2.013184e-005f,  9.514743e-006f,  6.418139e-006f, -1.659947e-006f
};

static const float MPSVTImpulseRight4[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  4.967935e-002f,  2.556182e-002f,  1.947947e-002f,
    1.495107e-002f,  2.013764e-002f,  1.938288e-002f,  7.266457e-003f, -2.487388e-003f,  4.145611e-003f,  1.825772e-002f,  2.207591e-002f,
    1.423736e-002f,  9.138399e-003f,  1.242105e-002f,  1.426640e-002f,  6.970716e-003f, -2.427142e-003f, -3.813361e-003f,  1.921986e-003f,
    6.229121e-003f,  5.657392e-003f,  3.754797e-003f,  3.732200e-003f,  4.516980e-003f,  4.282929e-003f,  3.133296e-003f,  2.112260e-003f,
    1.550050e-003f,  1.421266e-003f,  1.574930e-003f,  1.658528e-003f,  1.362898e-003f,  1.014693e-003f,  1.022652e-003f,  1.215287e-003f,
    1.128600e-003f,  8.645860e-004f,  8.478257e-004f,  1.125707e-003f,  1.335497e-003f,  1.347751e-003f,  1.307157e-003f,  1.279852e-003f,
    1.194575e-003f,  1.138974e-003f,  1.228125e-003f,  1.337597e-003f,  1.245716e-003f,  1.052764e-003f,  1.047691e-003f,  1.242172e-003f,
    1.321918e-003f,  1.149113e-003f,  9.552079e-004f,  9.713899e-004f,  1.084039e-003f,  1.054077e-003f,  8.717768e-004f,  7.373125e-004f,
    7.442203e-004f,  7.797925e-004f,  7.114640e-004f,  5.661368e-004f,  4.621328e-004f,  4.494676e-004f,  4.582354e-004f,  4.061685e-004f,
    3.001822e-004f,  2.214666e-004f,  2.124693e-004f,  2.255774e-004f,  1.911534e-004f,  1.158921e-004f,  6.644729e-005f,  7.331528e-005f,
    9.074141e-005f,  7.004324e-005f,  2.635430e-005f,  9.375529e-006f,  2.841010e-005f,  4.671890e-005f,  3.838971e-005f,  2.125280e-005f,
    2.332013e-005f,  4.396072e-005f,  6.009447e-005f,  6.083284e-005f,  5.755537e-005f,  6.457337e-005f,  8.017696e-005f,  9.240260e-005f,
    9.519882e-005f,  9.461230e-005f,  9.866918e-005f,  1.072674e-004f,  1.133271e-004f,  1.129592e-004f,  1.096966e-004f,  1.089224e-004f,
    1.104321e-004f,  1.098519e-004f,  1.050621e-004f,  9.872445e-005f,  9.381790e-005f,  8.995684e-005f,  8.476202e-005f,  7.758706e-005f,
    6.987795e-005f,  6.299889e-005f,  5.674872e-005f,  5.030377e-005f,  4.336199e-005f,  3.638751e-005f,  2.995359e-005f,  2.431798e-005f,
    1.924679e-005f,  1.437243e-005f,  9.621956e-006f,  5.399439e-006f,  2.074206e-006f, -4.605536e-007f, -2.654758e-006f, -4.671751e-006f,
   -6.235823e-006f, -7.043772e-006f, -7.214048e-006f, -7.113553e-006f, -6.926634e-006f, -6.485589e-006f, -5.590558e-006f, -4.309652e-006f,
   -2.935868e-006f, -1.644278e-006f, -3.431628e-007f,  1.140397e-006f,  2.766962e-006f,  4.307826e-006f,  5.612090e-006f,  6.769341e-006f,
    7.928887e-006f,  9.067028e-006f,  1.000726e-005f,  1.066088e-005f,  1.112069e-005f,  1.150996e-005f,  1.180806e-005f,  1.190299e-005f,
    1.175728e-005f,  1.145867e-005f,  1.109673e-005f,  1.066346e-005f,  1.009557e-005f,  9.386288e-006f,  8.603681e-006f,  7.813232e-006f,
    7.013954e-006f,  6.172127e-006f,  5.288769e-006f,  4.413066e-006f,  3.588657e-006f,  2.815428e-006f,  2.070418e-006f,  1.354778e-006f,
    6.989400e-007f,  1.280419e-007f, -3.633783e-007f, -7.937155e-007f, -1.165658e-006f, -1.463925e-006f, -1.679124e-006f, -1.820454e-006f,
   -1.904209e-006f, -1.936168e-006f, -1.912427e-006f, -1.832569e-006f, -1.706819e-006f, -1.548554e-006f, -1.365211e-006f, -1.158178e-006f,
   -9.303527e-007f, -6.898368e-007f, -4.465644e-007f, -2.067391e-007f,  2.739893e-008f,  2.537537e-007f,  4.675328e-007f,  6.630681e-007f,
    8.369149e-007f,  9.885570e-007f,  1.118006e-006f,  1.224043e-006f,  1.304836e-006f,  1.359938e-006f,  1.390738e-006f,  1.399271e-006f,
    1.386871e-006f,  1.354387e-006f,  1.303219e-006f,  1.235882e-006f,  1.155333e-006f,  1.064068e-006f,  9.639352e-007f,  8.568495e-007f,
    7.452888e-007f,  6.320045e-007f,  5.192561e-007f,  4.086141e-007f,  3.014355e-007f,  1.993632e-007f,  1.041221e-007f,  1.697899e-008f,
   -6.144933e-008f, -1.307902e-007f, -1.905452e-007f, -2.401923e-007f, -2.795887e-007f, -3.090699e-007f, -3.291633e-007f,  5.446979e-006f,
    1.488334e-005f,  8.869556e-006f,  5.235567e-006f,  3.768373e-005f,  5.899141e-005f,  3.427667e-005f,  5.160532e-005f,  1.366200e-004f,
    1.453465e-004f,  4.838972e-005f,  2.449323e-005f,  1.068120e-004f,  1.394943e-004f,  1.532984e-004f,  2.730472e-004f,  3.242656e-004f,
    1.373288e-004f, -7.037018e-006f,  1.052354e-004f,  1.457597e-004f, -3.339212e-005f,  2.700832e-005f,  4.069365e-004f,  4.476718e-004f,
    8.976767e-006f, -2.368197e-004f, -1.988821e-004f, -4.193734e-004f, -6.587186e-004f, -4.972297e-004f, -9.171180e-004f, -2.545435e-003f,
   -3.244200e-003f, -1.098067e-003f,  1.403401e-003f,  7.245332e-004f, -1.561644e-003f, -1.475867e-003f, -9.509889e-005f, -1.790402e-003f,
   -5.905380e-003f, -7.278750e-003f, -4.828025e-003f, -2.589595e-003f, -2.169717e-003f, -1.345740e-003f,  8.505124e-005f, -2.553527e-004f,
   -1.931185e-003f, -1.922932e-003f, -1.023170e-004f,  8.431345e-004f,  5.538255e-004f,  1.074187e-003f,  2.196630e-003f,  1.528391e-003f,
   -7.742287e-004f, -1.621847e-003f,  1.735380e-004f,  2.191147e-003f,  2.317672e-003f,  1.563190e-003f,  1.740640e-003f,  2.318440e-003f,
    1.398096e-003f, -8.953974e-004f, -2.052743e-003f, -8.459500e-004f,  5.058899e-004f, -4.398951e-004f, -2.504554e-003f, -2.789007e-003f,
   -1.122241e-003f,  5.071042e-004f,  1.682345e-003f,  2.943117e-003f,  2.784065e-003f, -1.610901e-004f, -3.183397e-003f, -2.912964e-003f,
   -1.313500e-003f, -2.388565e-003f, -4.503838e-003f, -3.063161e-003f,  4.536707e-004f,  2.446258e-004f, -3.577196e-003f, -5.051970e-003f,
   -2.699206e-003f, -1.040992e-003f, -1.441195e-003f, -3.724717e-004f,  2.355936e-003f,  2.529828e-003f, -1.496570e-004f, -1.156409e-003f,
    3.895877e-004f,  5.499987e-004f, -1.312135e-003f, -1.348361e-003f,  1.075703e-003f,  2.268447e-003f,  1.397804e-003f,  1.494717e-003f,
    3.013207e-003f,  3.202448e-003f,  1.809977e-003f,  1.215668e-003f,  1.506679e-003f,  9.794920e-004f,  2.440527e-004f,  8.026304e-004f,
    1.481218e-003f,  7.233991e-004f, -1.467856e-004f,  2.292714e-004f,  4.328077e-004f, -4.503893e-004f, -6.659648e-004f,  3.954918e-004f,
    6.664745e-004f, -2.557145e-004f, -1.715240e-004f,  9.138733e-004f,  4.572361e-004f, -1.327731e-003f, -1.583091e-003f, -4.569673e-004f,
   -7.123704e-004f, -2.043078e-003f, -1.780338e-003f, -3.525165e-004f, -1.740446e-004f, -6.690981e-004f, -4.405495e-006f,  5.831652e-004f,
   -4.754598e-004f, -1.196985e-003f,  4.765926e-005f,  7.184111e-004f, -9.955274e-004f, -2.157124e-003f, -5.641802e-004f,  9.878135e-004f,
    2.742470e-004f, -1.747907e-004f,  1.471847e-003f,  2.589261e-003f,  1.512626e-003f,  7.699606e-004f,  1.669338e-003f,  1.622124e-003f,
   -3.787527e-004f, -1.490073e-003f, -4.715126e-004f,  2.596774e-004f, -3.276901e-004f, -2.568646e-004f,  9.223844e-004f,  1.216538e-003f,
    4.680440e-004f,  6.582083e-004f,  1.738771e-003f,  1.736003e-003f,  8.083771e-004f,  8.929605e-004f,  1.772022e-003f,  1.540578e-003f,
    4.248567e-004f,  3.731877e-004f,  1.377296e-003f,  1.618681e-003f,  8.318616e-004f,  4.317976e-004f,  6.155338e-004f,  2.144516e-004f,
   -6.329910e-004f, -3.996947e-004f,  8.954410e-004f,  1.251509e-003f,  4.553893e-006f, -8.519836e-004f,  4.045860e-005f,  1.167696e-003f,
    9.903766e-004f,  6.239673e-004f,  1.309603e-003f,  1.634660e-003f,  2.138380e-004f, -1.211982e-003f, -6.584153e-004f,  4.401756e-004f,
   -1.580989e-004f, -1.695852e-003f, -2.487783e-003f, -2.887097e-003f, -3.052709e-003f, -1.289895e-003f,  2.281642e-003f,  4.403145e-003f,
    3.793855e-003f,  3.069857e-003f,  3.462267e-003f,  3.115911e-003f,  2.260316e-003f,  3.566496e-003f,  6.043781e-003f,  5.782010e-003f,
    3.501544e-003f,  3.450578e-003f,  4.787265e-003f,  2.865305e-003f, -1.354780e-003f, -2.536799e-003f, -6.450270e-004f,  1.052369e-004f,
    9.133308e-005f,  2.284862e-003f,  4.176574e-003f,  1.808230e-003f, -1.528947e-003f, -6.611725e-004f,  1.652336e-003f,  2.132050e-004f,
   -2.429587e-003f, -1.294211e-003f,  1.132599e-003f,  1.510897e-004f, -1.779658e-003f, -2.376273e-004f,  2.418605e-003f,  1.875204e-003f,
   -4.865517e-004f, -1.877685e-003f, -3.689313e-003f, -6.693195e-003f, -7.306168e-003f, -3.931209e-003f, -5.585014e-004f,  3.508727e-005f,
    2.233364e-004f,  1.741222e-003f,  2.506323e-003f,  1.499195e-003f,  7.482495e-004f,  9.439935e-004f,  4.156199e-004f, -9.868317e-004f,
   -1.656207e-003f, -1.492004e-003f, -1.441333e-003f, -1.022189e-003f,  3.385641e-004f,  1.361117e-003f,  1.048142e-003f,  5.122895e-004f,
    6.349961e-004f,  4.510836e-004f, -6.442223e-004f, -1.583789e-003f, -1.459075e-003f, -5.893637e-004f,  3.917235e-004f,  9.858260e-004f,
    1.051176e-003f,  1.404339e-003f,  2.556100e-003f,  2.819226e-003f,  5.541789e-004f, -2.145524e-003f, -1.965051e-003f,  1.403234e-004f,
    6.313409e-004f, -4.554506e-004f, -2.803955e-004f,  1.054065e-003f,  1.058296e-003f, -7.062922e-005f, -1.915730e-004f,  5.435157e-004f,
    1.012317e-003f,  2.412617e-003f,  5.579806e-003f,  7.738692e-003f,  6.389393e-003f,  3.560139e-003f,  2.273548e-003f,  1.944335e-003f,
    7.734398e-004f, -5.569785e-004f, -6.813991e-004f, -1.167158e-004f,  2.422533e-004f,  6.262913e-004f,  1.204895e-003f,  1.760137e-003f,
    2.624591e-003f,  3.710132e-003f,  3.628599e-003f,  2.024489e-003f,  8.254365e-004f,  9.402396e-004f,  5.286501e-004f, -1.168411e-003f,
   -1.851118e-003f, -4.920518e-004f,  3.447773e-004f, -8.445846e-004f, -1.692806e-003f, -5.191553e-004f,  4.926667e-004f, -4.967295e-004f,
   -1.579500e-003f, -7.867683e-004f,  4.050550e-004f,  6.477987e-005f, -8.277930e-004f, -7.119460e-004f, -4.635665e-004f, -1.400590e-003f,
   -2.404884e-003f, -1.742739e-003f, -3.040634e-004f, -3.808854e-004f, -1.995602e-003f, -2.932012e-003f, -2.161207e-003f, -8.690131e-004f,
    3.078958e-005f,  1.010371e-003f,  2.071448e-003f,  2.129680e-003f,  9.877846e-004f, -2.795309e-004f, -1.436008e-003f, -3.109553e-003f,
   -4.369335e-003f, -3.312140e-003f, -6.553636e-004f,  4.812317e-004f, -8.338627e-004f, -2.075203e-003f, -1.318819e-003f,  3.228769e-004f,
    1.000700e-003f,  5.151323e-004f, -3.401786e-005f,  4.250554e-004f,  1.709637e-003f,  2.139492e-003f,  8.709477e-004f, -1.583469e-004f,
    7.383185e-004f,  1.545119e-003f,  1.068113e-004f, -1.281028e-003f, -2.249805e-004f,  1.139677e-004f, -3.448132e-003f, -6.867859e-003f,
   -5.177901e-003f, -1.559534e-003f, -1.357381e-003f, -2.338819e-003f, -3.013498e-004f,  1.871812e-003f,  7.015464e-004f,  4.938154e-004f,
    4.944535e-003f,  8.336224e-003f,  5.502130e-003f,  1.822170e-003f,  2.941066e-003f,  3.980660e-003f, -5.701901e-004f, -5.636044e-003f,
   -4.352716e-003f,  2.552060e-004f,  8.578467e-004f, -3.843721e-003f, -9.430043e-003f, -1.001750e-002f, -1.572392e-003f,  1.148964e-002f,
    1.613100e-002f,  6.361289e-003f, -6.623141e-003f, -9.889866e-003f, -5.566766e-003f, -1.609941e-003f,  1.885958e-003f,  4.993126e-003f,
    1.391555e-003f, -7.117882e-003f, -6.244115e-003f,  6.703113e-003f,  1.306137e-002f,  1.988664e-003f, -1.048646e-002f, -7.150341e-003f,
    5.456856e-003f,  1.281625e-002f,  1.354623e-002f,  1.099671e-002f,  3.226534e-003f, -6.238359e-003f, -6.300164e-003f,  3.085150e-003f,
    8.140188e-003f,  3.720247e-003f, -4.717422e-005f,  2.239758e-003f,  3.918542e-003f,  2.058974e-003f,  2.094123e-003f,  4.676354e-003f,
    4.405528e-003f,  1.549459e-003f,  6.926307e-004f,  6.917675e-004f, -1.326152e-003f, -1.875957e-003f,  1.429099e-003f,  2.734668e-003f,
   -1.308903e-003f, -4.182558e-003f, -2.066034e-003f, -9.619743e-004f, -2.864005e-003f, -3.276766e-006f,  8.215864e-003f,  9.214596e-003f,
   -1.385986e-003f, -8.744150e-003f, -1.274652e-003f,  1.026700e-002f,  9.660180e-003f, -8.487630e-006f, -3.110012e-003f,  3.144013e-003f,
    4.992776e-003f, -5.240146e-003f, -1.515445e-002f, -9.192430e-003f,  7.070603e-003f,  1.286575e-002f,  2.642969e-003f, -5.469742e-003f,
    1.503594e-003f,  1.102318e-002f,  6.907356e-003f, -3.825131e-003f, -4.381005e-003f,  3.472006e-003f,  5.066399e-003f, -1.489168e-003f,
   -5.644739e-003f, -4.716154e-003f, -4.972050e-003f, -6.491869e-003f, -3.792419e-003f,  1.518249e-003f,  3.028400e-003f,  1.353240e-003f,
    1.643918e-003f,  2.897426e-003f,  3.219846e-004f, -5.024300e-003f, -7.664591e-003f, -5.732473e-003f, -1.405147e-003f,  3.108512e-003f,
    5.670483e-003f,  4.341342e-003f,  4.571665e-004f, -2.224140e-003f, -2.655055e-003f, -2.684217e-003f, -2.478950e-003f, -6.800162e-004f,
    1.599620e-003f,  1.901907e-003f,  7.778819e-004f,  7.716597e-004f,  2.167161e-003f,  3.053646e-003f,  2.042532e-003f, -1.118819e-003f,
   -4.960111e-003f, -5.352696e-003f,  2.992160e-004f,  6.892394e-003f,  5.817304e-003f, -2.591365e-003f, -7.778839e-003f, -3.604102e-003f,
    2.996941e-003f,  3.156727e-003f, -1.021017e-003f, -2.064956e-003f, -2.796147e-004f, -1.936461e-003f, -6.779463e-003f, -7.290411e-003f,
   -1.146927e-003f,  4.562565e-003f,  4.317720e-003f,  1.663909e-003f,  1.831267e-003f,  3.514090e-003f,  2.906974e-003f,  6.827926e-004f,
   -1.671019e-004f,  4.711050e-004f,  1.200417e-003f,  2.245969e-003f,  3.557422e-003f,  3.144250e-003f,  4.496474e-004f, -1.819253e-003f,
   -1.594806e-003f,  5.490199e-005f,  1.636325e-003f,  2.563131e-003f,  1.203456e-003f, -3.507755e-003f, -7.872208e-003f, -6.446604e-003f,
   -4.407804e-004f,  2.607983e-003f, -6.828899e-004f, -4.925480e-003f, -4.377644e-003f, -9.415944e-004f,  2.472131e-005f, -1.717931e-003f,
   -1.774431e-003f,  1.044120e-003f,  2.443879e-003f, -4.302041e-004f, -4.207563e-003f, -4.724110e-003f, -3.435506e-003f, -3.385090e-003f,
   -2.243828e-003f,  3.454056e-003f,  9.683080e-003f,  9.485212e-003f,  4.787464e-003f,  3.609768e-003f,  6.115864e-003f,  4.861571e-003f,
   -5.638161e-004f, -1.692286e-003f,  3.712588e-003f,  7.039975e-003f,  3.124772e-003f, -1.973981e-003f, -1.873198e-003f,  1.054403e-003f,
    1.814000e-003f,  1.505432e-004f, -1.788242e-003f, -3.072038e-003f, -3.197694e-003f, -2.397165e-003f, -2.799050e-003f, -5.038536e-003f,
   -5.470875e-003f, -1.437013e-003f,  3.235358e-003f,  3.125514e-003f, -7.122407e-004f, -2.578178e-003f, -3.187418e-004f,  2.809399e-003f,
    3.758611e-003f,  3.537319e-003f,  4.622512e-003f,  6.467565e-003f,  5.880893e-003f,  2.385862e-003f,  1.335069e-004f,  1.618981e-003f,
    2.961991e-003f,  2.831061e-004f, -3.105929e-003f, -2.486894e-003f, -4.128806e-004f, -1.487913e-003f, -3.199445e-003f, -1.360870e-003f,
    4.646847e-004f, -2.583568e-003f, -6.338648e-003f, -4.736139e-003f, -1.184032e-003f, -1.602071e-003f, -3.092655e-003f, -1.026136e-003f,
    5.557545e-004f, -2.460247e-003f, -3.955125e-003f,  1.738766e-003f,  7.732146e-003f,  5.710620e-003f,  4.594630e-004f,  8.263842e-004f,
    4.379142e-003f,  3.270064e-003f, -1.551838e-003f, -3.241374e-003f, -9.229101e-004f,  6.097530e-004f, -6.547642e-004f, -2.453712e-003f,
   -2.690491e-003f, -1.657786e-003f, -1.478988e-003f, -3.796795e-003f, -6.600580e-003f, -5.965196e-003f, -2.718186e-003f, -2.268597e-003f,
   -5.359794e-003f, -5.814641e-003f, -6.909946e-004f,  4.725095e-003f,  5.333060e-003f,  2.298376e-003f, -1.562161e-003f, -4.998320e-003f,
   -5.943464e-003f, -3.588618e-003f, -2.228195e-003f, -5.050182e-003f, -6.760773e-003f, -1.674664e-003f,  4.836480e-003f,  3.938726e-003f,
   -1.679959e-003f, -2.495596e-003f,  1.515262e-003f,  1.862947e-003f, -2.842176e-003f, -4.452702e-003f,  8.608820e-004f,  6.236570e-003f,
    4.157030e-003f, -3.455751e-003f, -8.221528e-003f, -5.641864e-003f,  2.348958e-004f,  2.895018e-003f,  1.963856e-003f,  2.174759e-003f,
    4.538579e-003f,  4.542427e-003f,  4.386742e-004f, -3.269464e-003f, -3.052292e-003f, -8.945895e-004f,  4.650482e-004f,  8.534603e-004f,
    1.154285e-004f, -1.763964e-003f, -2.147968e-003f,  6.715800e-004f,  3.218604e-003f,  2.309788e-003f,  1.016750e-003f,  2.320475e-003f,
    2.204556e-003f, -2.985023e-003f, -8.218470e-003f, -7.164228e-003f, -2.072963e-003f,  1.192339e-003f,  1.795127e-003f,  1.353834e-003f,
   -3.275315e-004f, -1.867059e-003f,  4.213326e-006f,  3.878405e-003f,  4.582204e-003f,  2.061094e-003f,  6.847994e-004f,  2.370613e-004f,
   -2.484053e-003f, -4.929142e-003f, -2.497319e-003f,  1.644785e-003f,  1.296723e-003f, -1.803655e-003f, -2.143161e-003f, -6.760852e-004f,
   -8.787278e-004f, -5.635623e-004f,  2.805393e-003f,  5.221097e-003f,  3.028346e-003f, -3.590822e-004f, -1.317176e-003f, -1.684697e-003f,
   -2.777149e-003f, -2.537362e-003f, -1.614015e-003f, -2.823191e-003f, -3.791880e-003f, -4.059579e-004f,  3.873750e-003f,  3.310973e-003f,
    9.791959e-004f,  2.542456e-003f,  4.329822e-003f,  5.032400e-004f, -4.411885e-003f, -3.302544e-003f,  5.647623e-004f,  7.344892e-004f,
   -7.862173e-004f, -2.501122e-004f, -5.449074e-004f, -3.091554e-003f, -3.050391e-003f, -5.560684e-004f, -2.672723e-003f, -7.740538e-003f,
   -4.854651e-003f,  5.082182e-003f,  7.474258e-003f, -5.148736e-004f, -3.946997e-003f,  3.587689e-003f,  9.694420e-003f,  6.606954e-003f,
    3.014007e-003f,  4.768190e-003f,  4.648208e-003f, -1.162769e-003f, -5.454741e-003f, -4.826807e-003f, -4.653188e-003f, -5.604419e-003f,
   -2.208150e-003f,  3.344081e-003f,  2.689793e-003f, -2.855156e-003f, -3.925941e-003f,  2.229777e-004f,  1.976293e-003f,  2.402623e-004f,
    3.613410e-004f,  2.030926e-003f,  1.091542e-003f, -1.611553e-004f,  2.770628e-003f,  6.413328e-003f,  5.160012e-003f,  2.232297e-003f,
    3.776075e-003f,  7.169506e-003f,  5.476069e-003f, -8.921550e-004f, -5.482482e-003f, -4.908238e-003f, -6.297206e-004f,  4.311076e-003f,
    6.530549e-003f,  4.595996e-003f,  1.690497e-003f,  1.428328e-003f,  2.031506e-003f,  3.978894e-004f, -1.063913e-003f,  1.009877e-003f,
    3.461127e-003f,  1.944012e-003f, -7.042983e-004f,  3.196903e-005f,  1.651769e-003f,  1.568109e-004f, -1.673806e-003f, -3.455011e-004f,
    6.932499e-004f, -1.651550e-003f, -2.573793e-003f,  1.745317e-003f,  5.518454e-003f,  2.893881e-003f, -1.794719e-003f, -2.328219e-003f,
   -9.427736e-004f, -1.569043e-003f, -1.292996e-003f,  2.493941e-003f,  4.782336e-003f,  1.520206e-003f, -2.530588e-003f, -2.573453e-003f,
   -2.141829e-003f, -4.831030e-003f, -6.175559e-003f, -2.100159e-003f,  2.421370e-003f,  1.626741e-003f, -1.138604e-003f, -1.022214e-004f,
    2.596954e-003f,  1.626830e-003f, -1.549120e-003f, -1.711907e-003f,  6.261878e-004f,  6.080389e-004f, -2.106495e-003f, -2.928188e-003f,
   -2.339110e-004f,  2.296029e-003f,  1.817342e-003f,  5.032826e-005f, -3.936658e-004f,  3.044930e-004f,  8.191664e-004f,  1.055192e-003f,
    1.044848e-003f,  6.574059e-005f, -1.131887e-003f,  1.741910e-004f,  4.489145e-003f,  7.960042e-003f,  7.228605e-003f,  3.854973e-003f,
    1.003852e-003f, -1.112549e-003f, -3.016791e-003f, -2.873541e-003f,  5.122500e-005f,  2.398779e-003f,  1.689554e-003f,  5.184546e-004f,
    1.385370e-003f,  1.905852e-003f, -6.135125e-005f, -1.700685e-003f, -7.954338e-004f, -3.591617e-004f, -2.399324e-003f, -3.219393e-003f,
   -4.445483e-004f,  1.888077e-003f,  8.270570e-004f,  2.196640e-005f,  2.188831e-003f,  3.546788e-003f,  1.302412e-003f, -9.861637e-004f,
   -6.360049e-004f, -4.181068e-004f, -1.453738e-003f, -2.348905e-004f,  3.240873e-003f,  3.715777e-003f,  6.301331e-004f, -1.793030e-004f,
    2.197826e-003f,  1.669858e-003f, -2.699132e-003f, -4.206622e-003f, -1.185618e-003f,  8.051479e-005f, -1.891700e-003f, -8.796762e-004f,
    4.005121e-003f,  5.406109e-003f,  1.341897e-003f, -1.163036e-003f,  5.550864e-004f,  8.019840e-004f, -1.801343e-003f, -1.003787e-003f,
    3.925376e-003f,  4.973622e-003f, -3.385608e-004f, -4.087353e-003f, -1.858965e-003f,  5.233248e-004f, -1.224715e-003f, -2.816687e-003f,
   -8.901792e-004f,  9.832132e-004f,  2.725496e-004f, -9.277050e-005f,  9.512709e-004f, -8.722742e-005f, -3.529534e-003f, -4.825999e-003f,
   -2.980013e-003f, -2.109271e-003f, -2.914633e-003f, -1.424489e-003f,  2.286266e-003f,  3.098935e-003f,  1.391521e-004f, -1.537012e-003f,
    4.618111e-005f,  1.248520e-003f,  3.871409e-004f,  7.765754e-005f,  1.150264e-003f,  1.358773e-003f,  5.654975e-004f,  8.356857e-004f,
    1.744912e-003f,  1.336196e-003f,  3.789859e-004f,  3.931796e-004f, -6.355884e-005f, -2.030957e-003f, -2.639747e-003f, -1.558981e-004f,
    1.723606e-003f, -1.898709e-004f, -2.959063e-003f, -2.655648e-003f, -9.075159e-005f,  2.720253e-003f,  6.013873e-003f,  8.439844e-003f,
    6.233144e-003f, -8.084465e-005f, -4.511339e-003f, -4.103910e-003f, -2.377201e-003f, -2.457908e-003f, -3.193456e-003f, -2.933849e-003f,
   -1.173567e-003f,  2.607509e-003f,  6.028822e-003f,  3.568982e-003f, -4.044811e-003f, -6.630919e-003f,  6.630285e-004f,  7.547866e-003f,
    4.217466e-003f, -2.527145e-003f, -1.613774e-003f,  3.456913e-003f,  2.936843e-003f, -9.036916e-004f,  2.407403e-004f,  4.139412e-003f,
    3.193180e-003f, -6.099441e-004f, -6.209416e-004f,  1.310900e-003f,  2.164922e-004f, -6.758402e-004f,  3.086499e-003f,  6.483816e-003f,
    3.549953e-003f, -1.188973e-003f, -1.101411e-003f,  9.747760e-004f,  6.768123e-005f, -8.008463e-004f,  2.029209e-003f,  4.177763e-003f,
    1.497085e-003f, -1.546488e-003f, -4.214825e-004f,  1.144543e-003f, -7.416446e-004f, -2.431617e-003f, -5.444254e-004f,  1.000155e-003f,
   -1.240223e-003f, -3.452328e-003f, -2.091423e-003f, -6.222395e-004f, -2.496998e-003f, -4.272911e-003f, -1.926866e-003f,  1.643382e-003f,
    1.400869e-003f, -1.665536e-003f, -2.537756e-003f,  1.035381e-004f,  2.558662e-003f,  1.652264e-003f, -1.523182e-003f, -3.713311e-003f,
   -3.462725e-003f, -1.765663e-003f,  3.098584e-004f,  2.418322e-003f,  3.242364e-003f,  1.194175e-003f, -1.883481e-003f, -1.582490e-003f,
    2.156944e-003f,  3.557311e-003f, -2.427058e-005f, -2.784470e-003f,  6.584213e-004f,  6.031740e-003f,  5.789947e-003f,  8.147551e-004f,
   -1.815937e-003f, -9.707682e-005f,  1.612229e-003f,  1.137029e-003f,  8.207131e-004f,  1.579604e-003f,  1.445869e-003f,  5.797909e-004f,
    1.632315e-003f,  4.015319e-003f,  3.462403e-003f, -7.819576e-004f, -3.443619e-003f, -8.595012e-004f,  3.096732e-003f,  2.819967e-003f,
   -3.076027e-004f, -2.160722e-004f,  4.005055e-003f,  6.348825e-003f,  3.012218e-003f, -2.054266e-003f, -3.382166e-003f, -1.339781e-003f,
    3.346033e-004f,  7.276261e-004f,  1.262658e-003f,  1.734613e-003f,  1.187253e-003f,  8.113959e-004f,  1.942427e-003f,  2.833087e-003f,
    1.214529e-003f, -1.449216e-003f, -1.915954e-003f, -1.116988e-004f,  1.198762e-003f,  6.434361e-004f, -7.193311e-004f, -1.691374e-003f,
   -1.934435e-003f, -1.483803e-003f, -9.163393e-004f, -1.130091e-003f, -1.976973e-003f, -2.232732e-003f, -1.430027e-003f, -4.338828e-004f,
   -7.258596e-005f, -4.531838e-004f, -1.224503e-003f, -1.306490e-003f,  5.154697e-004f,  3.340896e-003f,  4.266732e-003f,  2.430313e-003f,
    6.633445e-004f,  1.062762e-003f,  1.623149e-003f, -1.802588e-005f, -2.146009e-003f, -1.613607e-003f,  1.016328e-003f,  2.279517e-003f,
    6.660647e-004f, -1.943760e-003f, -3.007184e-003f, -1.687511e-003f,  8.737136e-004f,  2.510776e-003f,  1.900104e-003f,  8.843167e-005f,
   -4.997061e-004f,  1.185719e-003f,  3.685895e-003f,  4.726846e-003f,  3.697579e-003f,  2.358629e-003f,  2.662924e-003f,  3.742651e-003f,
    2.687321e-003f, -6.700649e-004f, -2.405777e-003f, -3.455195e-004f,  1.853603e-003f,  2.919624e-004f, -2.523596e-003f, -1.674465e-003f,
    1.963505e-003f,  3.272510e-003f,  1.062660e-003f, -1.069224e-003f, -1.111855e-003f, -5.562436e-004f, -4.870007e-004f, -3.314961e-004f,
   -1.238221e-004f, -5.047078e-004f, -1.165257e-003f, -1.715553e-003f, -2.609025e-003f, -3.508907e-003f, -3.116198e-003f, -1.899665e-003f,
   -1.854354e-003f, -2.552508e-003f, -1.305654e-003f,  1.736923e-003f,  2.976247e-003f,  1.087598e-003f, -9.030313e-004f, -6.467387e-004f,
    2.549619e-004f, -6.213377e-004f, -3.146332e-003f, -5.391310e-003f, -5.654479e-003f, -3.506447e-003f, -2.696063e-004f,  1.933182e-003f,
    2.299748e-003f,  1.526168e-003f,  1.604490e-004f, -1.291088e-003f, -1.553976e-003f, -4.961780e-004f, -3.098714e-004f, -1.914979e-003f,
   -2.770072e-003f, -1.453234e-003f, -5.228805e-004f, -1.179262e-003f, -4.599269e-004f,  1.985732e-003f,  1.309922e-003f, -3.183607e-003f,
   -4.559536e-003f, -3.261699e-004f,  1.889624e-003f, -1.768276e-003f, -3.071481e-003f,  3.290725e-003f,  8.166400e-003f,  2.870105e-003f,
   -5.469078e-003f, -6.070675e-003f, -1.702949e-003f, -6.629571e-004f, -1.309464e-003f,  1.702140e-003f,  4.389747e-003f,  6.024191e-004f,
   -4.835848e-003f, -3.378132e-003f,  2.618755e-003f,  4.599415e-003f,  2.107466e-003f,  1.173967e-003f,  2.510512e-003f,  1.618259e-003f,
   -1.951994e-003f, -3.992652e-003f, -2.721532e-003f, -3.016292e-004f,  1.238135e-003f,  1.416850e-003f,  4.484040e-004f, -3.507666e-004f,
    4.915245e-004f,  1.841208e-003f,  9.870714e-004f, -1.878706e-003f, -3.603843e-003f, -2.956026e-003f, -1.924662e-003f, -1.675222e-003f,
   -8.549428e-004f,  1.233998e-003f,  2.888547e-003f,  2.519304e-003f,  7.377013e-004f, -9.342656e-004f, -1.900905e-003f, -2.263260e-003f,
   -1.762032e-003f, -2.137581e-005f,  2.172670e-003f,  2.960982e-003f,  1.763848e-003f,  5.309342e-004f,  9.137236e-004f,  1.483069e-003f,
    5.585969e-004f,  1.390726e-004f,  2.594657e-003f,  4.994610e-003f,  2.878032e-003f, -1.234331e-003f, -7.537571e-004f,  3.515610e-003f,
    3.772068e-003f, -1.555041e-003f, -4.731162e-003f, -1.774127e-003f,  1.356758e-003f, -8.917806e-005f, -1.946553e-003f,  3.987585e-005f,
    2.541150e-003f,  1.738357e-003f,  1.969184e-004f,  8.351792e-004f,  1.260891e-003f, -4.697394e-004f, -1.335066e-003f,  5.032344e-004f,
    1.781383e-003f,  6.997092e-004f,  5.326021e-004f,  2.730531e-003f,  3.484907e-003f,  9.632961e-004f, -1.053176e-003f, -2.316121e-004f,
    6.007101e-004f, -1.521645e-004f,  1.358435e-004f,  2.081973e-003f,  2.142198e-003f, -6.470344e-004f, -2.492026e-003f, -1.551957e-003f,
   -3.516291e-004f, -5.632794e-005f,  1.089754e-003f,  2.612835e-003f,  1.714010e-003f, -9.633913e-004f, -1.851588e-003f, -9.091845e-004f,
   -1.199175e-003f, -2.380345e-003f, -1.297999e-003f,  1.256982e-003f,  1.148583e-003f, -1.714301e-003f, -2.959704e-003f, -1.035219e-003f,
    8.405393e-004f,  4.928907e-004f, -5.001500e-004f, -6.064172e-004f, -6.585209e-004f, -1.504640e-003f, -2.396957e-003f, -2.437194e-003f,
   -1.628422e-003f, -2.357255e-004f,  1.486356e-003f,  2.887422e-003f,  3.161885e-003f,  2.055919e-003f,  1.222061e-004f, -1.515144e-003f,
   -1.797552e-003f, -6.126363e-004f,  9.877677e-004f,  1.675222e-003f,  9.562342e-004f, -4.081226e-004f, -1.061609e-003f, -6.658743e-004f,
   -5.928184e-004f, -1.798860e-003f, -2.669393e-003f, -1.343391e-003f,  5.330188e-004f, -2.554065e-005f, -1.911296e-003f, -1.384826e-003f,
    1.116127e-003f,  1.360482e-003f, -9.629134e-004f, -1.380756e-003f,  1.251893e-003f,  2.555208e-003f,  5.024690e-004f, -1.177233e-003f,
    6.788201e-005f,  1.478898e-003f,  4.379007e-004f, -1.396206e-003f, -1.811946e-003f, -1.262969e-003f, -6.095495e-004f,  3.131823e-004f,
    9.047423e-004f,  1.913943e-004f, -8.399725e-004f, -6.350221e-004f, -1.554383e-004f, -1.208100e-003f, -2.731630e-003f, -2.192060e-003f,
    1.509718e-004f,  1.409487e-003f,  6.246239e-005f, -2.264594e-003f, -2.759533e-003f, -4.158709e-004f,  2.453669e-003f,  2.241816e-003f,
   -1.291798e-003f, -3.838925e-003f, -1.950590e-003f,  2.151840e-003f,  3.652422e-003f,  1.348207e-003f, -1.794806e-003f, -2.885599e-003f,
   -1.675546e-003f,  1.715513e-005f,  3.228855e-005f, -1.929088e-003f, -3.471569e-003f, -2.387607e-003f, -1.507330e-007f,  5.366302e-004f,
   -1.157900e-003f, -2.185800e-003f, -4.581615e-004f,  2.500083e-003f,  3.183229e-003f,  1.800523e-004f, -3.522080e-003f, -3.660543e-003f,
   -7.165702e-004f,  2.565259e-004f, -2.498569e-003f, -4.427926e-003f, -2.619751e-003f, -8.729636e-004f, -2.250620e-003f, -3.210051e-003f,
   -8.999468e-004f,  7.480161e-004f, -1.372748e-003f, -3.259271e-003f, -1.713402e-003f, -6.173035e-004f, -2.723626e-003f, -3.655427e-003f,
   -5.799473e-004f,  1.942500e-003f,  7.634055e-004f, -3.315605e-004f,  9.670671e-004f,  1.163449e-003f, -7.443473e-004f, -6.534511e-004f,
    1.739951e-003f,  1.718203e-003f, -7.638623e-004f, -7.370876e-004f,  1.662599e-003f,  1.555335e-003f, -6.019382e-004f, -1.920170e-004f,
    1.819768e-003f,  1.074062e-003f, -8.242119e-004f,  5.157370e-004f,  3.310944e-003f,  3.367976e-003f,  2.034579e-003f,  1.875932e-003f,
    7.042658e-004f, -2.360401e-003f, -2.627779e-003f,  1.268863e-003f,  3.086644e-003f, -8.401305e-005f, -2.438005e-003f, -5.600576e-004f,
    8.482119e-004f, -6.650742e-004f, -4.942837e-004f,  2.867145e-003f,  4.002015e-003f,  8.219687e-004f, -1.876626e-003f, -1.756751e-003f,
   -1.754732e-003f, -2.288394e-003f, -5.521209e-004f,  2.115350e-003f,  1.548609e-003f, -1.207917e-003f, -1.778955e-003f, -5.609883e-004f,
   -8.987990e-004f, -1.887282e-003f, -5.950955e-004f,  1.634882e-003f,  1.862048e-003f,  1.087778e-003f,  1.449085e-003f,  1.746362e-003f,
    5.242861e-004f, -4.622317e-004f,  2.910959e-004f,  1.132233e-003f,  5.918829e-004f, -2.568999e-004f, -4.526515e-004f, -4.656364e-004f,
   -3.117446e-004f,  1.925668e-004f, -1.022503e-004f, -1.619355e-003f, -2.108778e-003f, -7.910759e-005f,  2.201072e-003f,  2.296403e-003f,
    1.219915e-003f,  5.727364e-004f, -2.964180e-004f, -1.505517e-003f, -1.117542e-003f,  8.844648e-004f,  1.457352e-003f, -1.320493e-004f,
   -5.193203e-004f,  1.612150e-003f,  2.734841e-003f,  8.851023e-004f, -3.860242e-004f,  1.591732e-003f,  3.104668e-003f, -6.058136e-005f,
   -4.958965e-003f, -5.450464e-003f, -1.601504e-003f,  8.728286e-004f, -1.940438e-004f, -8.906128e-004f,  1.257339e-003f,  3.101405e-003f,
    1.693050e-003f, -6.537185e-004f, -6.116217e-004f,  7.811475e-004f,  8.558847e-004f,  1.784458e-004f,  6.063029e-004f,  1.166286e-003f,
    4.141026e-007f, -1.737504e-003f, -1.853078e-003f, -1.087376e-003f, -1.419912e-003f, -2.145049e-003f, -1.298676e-003f,  3.722809e-004f,
    3.801473e-004f, -1.341301e-003f, -2.305518e-003f, -1.318944e-003f, -4.050570e-005f, -2.977824e-004f, -1.434964e-003f, -1.291503e-003f,
    6.719172e-004f,  2.415044e-003f,  2.043413e-003f,  3.909553e-004f, -3.527899e-004f,  4.641731e-004f,  2.021029e-003f,  3.688454e-003f,
    4.737211e-003f,  4.047270e-003f,  2.247528e-003f,  1.963895e-003f,  3.566253e-003f,  3.589122e-003f,  2.512256e-004f, -2.970281e-003f,
   -2.734462e-003f, -9.672068e-004f, -6.748211e-004f, -6.739066e-004f,  1.027701e-003f,  2.418432e-003f,  8.741775e-004f, -1.732726e-003f,
   -1.767230e-003f,  7.468546e-004f,  2.979157e-003f,  3.408817e-003f,  2.491675e-003f,  1.267382e-003f,  9.904616e-004f,  2.195196e-003f,
    3.422106e-003f,  2.892586e-003f,  1.267652e-003f,  5.216966e-004f,  8.406576e-004f,  9.631427e-004f,  5.312923e-004f, -4.497436e-005f,
   -7.755308e-004f, -1.435156e-003f, -1.279000e-003f, -5.737412e-004f, -5.528156e-004f, -1.186204e-003f, -1.060760e-003f,  3.021937e-004f,
    1.992472e-003f,  3.146204e-003f,  3.076699e-003f,  1.293995e-003f, -9.345295e-004f, -1.205912e-003f,  3.128872e-004f,  8.216901e-004f,
   -1.704892e-004f,  9.092496e-005f,  2.206197e-003f,  3.157873e-003f,  1.870327e-003f,  9.954034e-004f,  1.557042e-003f,  1.334795e-003f,
    2.035549e-005f,  1.704727e-004f,  1.666199e-003f,  1.179009e-003f, -1.528654e-003f, -2.675322e-003f, -1.047007e-003f,  2.388964e-004f,
   -2.821548e-004f, -2.058080e-004f,  1.664284e-003f,  3.026176e-003f,  2.324596e-003f,  1.136721e-003f,  9.992514e-004f,  1.251903e-003f,
    1.185253e-003f,  1.498352e-003f,  2.394310e-003f,  2.433045e-003f,  7.595679e-004f, -9.501746e-004f, -5.239297e-004f,  1.330935e-003f,
    1.766364e-003f,  1.334937e-004f, -9.376100e-004f,  2.879313e-005f,  8.012995e-004f, -4.097983e-004f, -1.443264e-003f, -1.587495e-004f,
    1.260009e-003f,  1.616755e-004f, -1.424552e-003f, -3.014586e-004f,  1.951771e-003f,  1.678553e-003f, -5.351651e-004f, -1.328622e-003f,
   -3.735068e-004f,  5.014911e-005f, -4.413821e-004f, -5.057365e-004f, -2.301542e-004f, -5.671124e-004f, -1.025309e-003f, -6.920960e-004f,
   -1.863727e-004f, -5.509903e-004f, -1.420943e-003f, -1.569708e-003f, -3.982101e-004f,  1.396487e-003f,  2.099770e-003f,  8.567807e-004f,
   -3.960399e-004f,  8.933735e-004f,  3.438255e-003f,  3.325158e-003f,  3.370262e-004f, -1.410254e-003f, -2.974503e-004f,  4.165845e-004f,
   -1.220539e-003f, -2.479495e-003f, -1.046070e-003f,  1.158541e-003f,  1.627826e-003f,  9.319609e-004f,  7.849108e-004f,  1.436568e-003f,
    2.225168e-003f,  2.520435e-003f,  1.831409e-003f,  5.845456e-004f,  6.334626e-005f,  3.662422e-004f,  9.499257e-005f, -9.330352e-004f,
   -1.057218e-003f,  2.072455e-004f,  1.166699e-003f,  6.832873e-004f, -5.957350e-004f, -1.811359e-003f, -2.305065e-003f, -1.262574e-003f,
    6.425526e-004f,  8.808780e-004f, -1.245756e-003f, -2.951644e-003f, -2.313311e-003f, -1.060282e-003f, -7.917258e-004f, -3.720408e-004f,
    6.572420e-004f,  5.432090e-004f, -6.594189e-004f, -3.225362e-004f,  1.640815e-003f,  1.926551e-003f, -3.790831e-004f, -2.291023e-003f,
   -2.219165e-003f, -1.624717e-003f, -1.029488e-003f,  3.531170e-004f,  1.271007e-003f,  1.575600e-004f, -6.455775e-004f,  1.904123e-003f,
    5.314109e-003f,  4.550775e-003f,  1.945755e-004f, -2.372572e-003f, -1.123866e-003f,  8.854871e-004f,  1.397246e-003f,  1.405859e-003f,
    1.825997e-003f,  1.988780e-003f,  1.697808e-003f,  1.645970e-003f,  1.691668e-003f,  1.027156e-003f, -5.603179e-005f, -3.937862e-004f,
    1.579443e-004f,  4.771346e-004f, -1.103608e-004f, -9.537484e-004f, -1.244033e-003f, -1.184486e-003f, -1.200317e-003f, -6.564497e-004f,
    1.146259e-003f,  2.932442e-003f,  2.495442e-003f,  1.311120e-004f, -1.309047e-003f, -5.147339e-004f,  6.235619e-004f,  3.365604e-004f,
   -6.889774e-004f, -1.293229e-003f, -1.483696e-003f, -1.165695e-003f,  7.384351e-005f,  1.202106e-003f,  5.598828e-004f, -1.056182e-003f,
   -1.117348e-003f,  3.943552e-004f,  6.498263e-004f, -1.395225e-003f, -3.078324e-003f, -1.946997e-003f,  7.689673e-004f,  2.047491e-003f,
    9.568460e-004f, -8.099383e-004f, -1.652693e-003f, -1.779614e-003f, -1.811324e-003f, -1.208079e-003f,  3.398186e-004f,  1.206829e-003f,
    8.107363e-006f, -1.526857e-003f, -1.001392e-003f,  4.278153e-004f,  1.789902e-004f, -7.319861e-004f,  3.741097e-004f,  2.251916e-003f,
    1.651068e-003f, -5.258809e-004f, -9.253160e-004f,  7.642391e-007f, -3.990289e-004f, -1.234230e-003f, -3.422320e-004f,  4.015607e-004f,
   -1.401049e-003f, -3.186207e-003f, -1.991032e-003f, -3.148056e-004f, -9.175111e-004f, -9.692642e-004f,  1.905952e-003f,  3.774881e-003f,
    1.474216e-003f, -1.024681e-003f, -9.661815e-005f,  8.822025e-004f, -1.018511e-003f, -1.994389e-003f,  6.600544e-004f,  2.455948e-003f,
    3.541896e-004f, -1.542109e-003f, -8.256805e-005f,  1.256247e-003f, -4.521350e-004f, -2.261481e-003f, -1.405434e-003f,  1.272015e-006f,
   -2.135586e-004f, -5.399385e-004f,  4.145170e-004f,  1.234299e-003f,  7.460620e-004f, -1.040768e-004f, -4.675724e-004f, -6.318619e-004f,
   -6.279893e-004f, -2.324655e-004f,  4.448300e-005f, -1.859374e-004f, -2.716860e-004f,  1.873075e-004f,  4.416641e-004f,  1.440010e-005f,
   -4.430223e-004f, -4.292046e-004f, -2.793603e-004f, -1.965380e-004f,  2.452376e-005f,  2.119356e-004f,  4.035287e-006f, -3.172814e-004f,
   -2.502812e-004f,  1.228908e-005f, -3.308717e-006f, -1.959295e-004f, -2.021372e-004f, -6.658654e-005f, -1.689763e-005f, -2.748684e-005f,
    4.768379e-007f,  1.745744e-005f, -7.308362e-006f, -1.317456e-005f,  2.780151e-006f, -2.027309e-006f, -1.010816e-005f, -1.142223e-006f
};

static const float MPSVTImpulseLeft5[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  4.967935e-002f,  2.556182e-002f,  1.947947e-002f,
    1.495107e-002f,  2.013764e-002f,  1.938288e-002f,  7.266457e-003f, -2.487388e-003f,  4.145611e-003f,  1.825772e-002f,  2.207591e-002f,
    1.423736e-002f,  9.138399e-003f,  1.242105e-002f,  1.426640e-002f,  6.970716e-003f, -2.427142e-003f, -3.813361e-003f,  1.921986e-003f,
    6.229121e-003f,  5.657392e-003f,  3.754797e-003f,  3.732200e-003f,  4.516980e-003f,  4.282929e-003f,  3.133296e-003f,  2.112260e-003f,
    1.550050e-003f,  1.421266e-003f,  1.574930e-003f,  1.658528e-003f,  1.362898e-003f,  1.014693e-003f,  1.022652e-003f,  1.215287e-003f,
    1.128600e-003f,  8.645860e-004f,  8.478257e-004f,  1.125707e-003f,  1.335497e-003f,  1.347751e-003f,  1.307157e-003f,  1.279852e-003f,
    1.194575e-003f,  1.138974e-003f,  1.228125e-003f,  1.337597e-003f,  1.245716e-003f,  1.052764e-003f,  1.047691e-003f,  1.242172e-003f,
    1.321918e-003f,  1.149113e-003f,  9.552079e-004f,  9.713899e-004f,  1.084039e-003f,  1.054077e-003f,  8.717768e-004f,  7.373125e-004f,
    7.442203e-004f,  7.797925e-004f,  7.114640e-004f,  5.661368e-004f,  4.621328e-004f,  4.494676e-004f,  4.582354e-004f,  4.061685e-004f,
    3.001822e-004f,  2.214666e-004f,  2.124693e-004f,  2.255774e-004f,  1.911534e-004f,  1.158921e-004f,  6.644729e-005f,  7.331528e-005f,
    9.074141e-005f,  7.004324e-005f,  2.635430e-005f,  9.375529e-006f,  2.841010e-005f,  4.671890e-005f,  3.838971e-005f,  2.125280e-005f,
    2.332013e-005f,  4.396072e-005f,  6.009447e-005f,  6.083284e-005f,  5.755537e-005f,  6.457337e-005f,  8.017696e-005f,  9.240260e-005f,
    9.519882e-005f,  9.461230e-005f,  9.866918e-005f,  1.072674e-004f,  1.133271e-004f,  1.129592e-004f,  1.096966e-004f,  1.089224e-004f,
    1.104321e-004f,  1.098519e-004f,  1.050621e-004f,  9.872445e-005f,  9.381790e-005f,  8.995684e-005f,  8.476202e-005f,  7.758706e-005f,
    6.987795e-005f,  6.299889e-005f,  5.674872e-005f,  5.030377e-005f,  4.336199e-005f,  3.638751e-005f,  2.995359e-005f,  2.431798e-005f,
    1.924679e-005f,  1.437243e-005f,  9.621956e-006f,  5.399439e-006f,  2.074206e-006f, -4.605536e-007f, -2.654758e-006f, -4.671751e-006f,
   -6.235823e-006f, -7.043772e-006f, -7.214048e-006f, -7.113553e-006f, -6.926634e-006f, -6.485589e-006f, -5.590558e-006f, -4.309652e-006f,
   -2.935868e-006f, -1.644278e-006f, -3.431628e-007f,  1.140397e-006f,  2.766962e-006f,  4.307826e-006f,  5.612090e-006f,  6.769341e-006f,
    7.928887e-006f,  9.067028e-006f,  1.000726e-005f,  1.066088e-005f,  1.112069e-005f,  1.150996e-005f,  1.180806e-005f,  1.190299e-005f,
    1.175728e-005f,  1.145867e-005f,  1.109673e-005f,  1.066346e-005f,  1.009557e-005f,  9.386288e-006f,  8.603681e-006f,  7.813232e-006f,
    7.013954e-006f,  6.172127e-006f,  5.288769e-006f,  4.413066e-006f,  3.588657e-006f,  2.815428e-006f,  2.070418e-006f,  1.354778e-006f,
    6.989400e-007f,  1.280419e-007f, -3.633783e-007f, -7.937155e-007f, -1.165658e-006f, -1.463925e-006f, -1.679124e-006f, -1.820454e-006f,
   -1.904209e-006f, -1.936168e-006f, -1.912427e-006f, -1.832569e-006f, -1.706819e-006f, -1.548554e-006f, -1.365211e-006f, -1.158178e-006f,
   -9.303527e-007f, -6.898368e-007f, -4.465644e-007f, -2.067391e-007f,  2.739893e-008f,  2.537537e-007f,  4.675328e-007f,  6.630681e-007f,
    8.369149e-007f,  9.885570e-007f,  1.118006e-006f,  1.224043e-006f,  1.304836e-006f,  1.359938e-006f,  1.390738e-006f,  1.399271e-006f,
    1.386871e-006f,  1.354387e-006f,  1.303219e-006f,  1.235882e-006f,  1.155333e-006f,  1.064068e-006f,  9.639352e-007f,  8.568495e-007f,
    7.452888e-007f,  6.320045e-007f,  5.192561e-007f,  4.086141e-007f,  3.014355e-007f,  1.993632e-007f,  1.041221e-007f,  1.697899e-008f,
   -6.144933e-008f, -1.307902e-007f, -1.905452e-007f, -2.401923e-007f, -2.795887e-007f, -3.090699e-007f, -3.291633e-007f,  7.383419e-006f,
    2.243108e-005f,  4.492444e-006f, -1.692187e-005f,  2.403097e-005f,  5.542192e-005f,  1.143955e-005f,  3.472649e-005f,  1.732070e-004f,
    1.535345e-004f, -1.086933e-004f, -2.186753e-004f, -2.975180e-006f,  1.192677e-004f, -4.304158e-005f, -7.069139e-005f,  1.531216e-004f,
    1.536776e-004f, -1.013517e-004f, -1.139236e-004f, -9.624862e-005f, -7.233410e-004f, -1.409719e-003f, -8.610855e-004f,  2.620724e-004f,
   -3.338827e-004f, -2.773746e-003f, -4.056442e-003f, -2.217311e-003f,  7.275313e-004f,  1.513326e-003f, -3.664354e-004f, -2.729892e-003f,
   -3.504152e-003f, -2.489685e-003f, -1.366269e-003f, -2.262434e-003f, -5.095182e-003f, -6.649879e-003f, -4.277153e-003f,  4.512034e-006f,
    1.978734e-003f,  1.407905e-003f,  1.714971e-003f,  3.318622e-003f,  2.634880e-003f, -3.110530e-004f, -6.089579e-004f,  2.985121e-003f,
    4.866577e-003f,  2.027279e-003f, -3.217922e-004f,  1.963611e-003f,  4.241254e-003f,  1.710307e-003f, -1.334354e-003f,  5.429655e-004f,
    3.494710e-003f,  1.772252e-003f, -1.005658e-003f,  9.587352e-004f,  3.497703e-003f, -6.649353e-005f, -5.103348e-003f, -2.852682e-003f,
    3.600874e-003f,  4.737805e-003f,  1.491740e-003f,  1.873447e-003f,  4.668662e-003f,  2.121695e-003f, -3.967198e-003f, -4.576955e-003f,
   -1.156642e-004f,  5.218055e-004f, -3.589984e-003f, -4.673486e-003f, -1.478753e-003f, -1.020647e-003f, -4.674044e-003f, -5.672030e-003f,
   -1.687437e-003f,  1.691045e-003f,  1.587444e-003f,  1.844799e-003f,  4.586820e-003f,  6.267412e-003f,  4.350288e-003f,  1.504103e-003f,
    9.738774e-004f,  2.105154e-003f,  2.276645e-003f,  8.729734e-004f, -6.359778e-005f,  1.277551e-003f,  3.581979e-003f,  3.730080e-003f,
    1.351624e-003f, -4.955695e-004f, -3.441825e-004f, -4.523926e-004f, -2.036000e-003f, -2.630874e-003f, -7.963277e-004f,  9.613896e-004f,
    7.199430e-004f,  2.005737e-004f,  8.441849e-004f,  1.287358e-003f,  7.485197e-004f,  5.237299e-004f,  8.797945e-004f,  8.240992e-004f,
    1.091119e-003f,  2.735654e-003f,  3.696792e-003f,  1.791537e-003f, -6.669238e-004f, -5.468735e-004f,  4.258372e-004f, -7.682116e-004f,
   -2.471679e-003f, -1.705606e-003f,  1.059810e-004f,  3.343933e-004f,  1.423304e-004f,  1.181791e-003f,  1.658864e-003f,  2.963008e-004f,
   -4.770383e-004f,  7.380144e-004f,  1.383962e-003f, -1.487760e-005f, -1.123669e-003f, -5.674494e-004f, -9.030790e-005f, -3.493246e-004f,
    9.825926e-005f,  9.393155e-004f,  5.145220e-004f, -2.419071e-004f,  5.737011e-004f,  1.596426e-003f,  6.220321e-004f, -8.860800e-004f,
   -5.285976e-004f,  5.767805e-004f,  3.424319e-004f, -6.397298e-004f, -1.378089e-003f, -2.349606e-003f, -2.764528e-003f, -9.420680e-004f,
    1.233293e-003f,  1.493306e-004f, -2.767265e-003f, -2.879805e-003f, -5.911080e-004f, -2.549371e-004f, -1.873855e-003f, -1.933535e-003f,
   -8.879395e-004f, -1.509274e-003f, -2.095094e-003f,  2.836387e-004f,  2.835409e-003f,  1.729757e-003f, -1.680757e-004f,  1.387905e-003f,
    3.648730e-003f,  2.285080e-003f, -1.041777e-006f,  1.172751e-003f,  3.257872e-003f,  1.945182e-003f, -3.364257e-004f,  7.756358e-004f,
    3.222612e-003f,  2.523817e-003f, -2.979859e-004f, -1.387568e-003f, -6.911677e-004f, -4.866855e-004f, -8.779367e-004f, -9.190691e-004f,
   -8.792953e-004f, -5.682905e-004f,  1.119636e-003f,  3.188045e-003f,  2.828581e-003f,  8.340615e-005f, -1.543466e-003f, -3.413993e-004f,
    1.227119e-003f,  6.613336e-004f, -1.034611e-003f, -1.467446e-003f, -3.984940e-004f,  6.280864e-004f,  1.135306e-003f,  2.108608e-003f,
    3.416643e-003f,  3.183519e-003f,  1.149674e-003f,  1.647569e-004f,  1.755435e-003f,  2.918523e-003f,  9.943043e-004f, -1.305815e-003f,
   -5.204629e-004f,  1.233715e-003f,  3.653289e-004f, -1.267350e-003f, -1.751425e-004f,  1.667632e-003f,  7.214655e-004f, -9.777974e-004f,
    1.675530e-005f,  1.497774e-003f,  1.729604e-004f, -1.483051e-003f, -3.930395e-004f,  5.188077e-004f, -1.737419e-003f, -3.708181e-003f,
   -2.127504e-003f, -4.343263e-004f, -1.789351e-003f, -2.900181e-003f, -1.350772e-003f, -9.453390e-004f, -3.312251e-003f, -3.079241e-003f,
    1.896144e-003f,  4.712244e-003f,  9.231560e-004f, -3.144583e-003f, -1.049945e-003f,  2.992442e-003f,  1.785982e-003f, -3.054379e-003f,
   -4.535966e-003f, -9.495351e-004f,  3.254118e-003f,  4.449509e-003f,  2.977007e-003f,  7.950118e-004f, -8.222966e-004f, -1.479190e-003f,
   -1.019730e-003f,  6.210159e-004f,  2.637182e-003f,  3.347462e-003f,  2.292848e-003f,  1.231529e-003f,  1.387719e-003f,  1.456973e-003f,
    2.456682e-004f, -1.181656e-003f, -1.943155e-003f, -2.703931e-003f, -2.946536e-003f, -1.145353e-003f,  9.964440e-004f, -6.927780e-005f,
   -3.049531e-003f, -3.088367e-003f, -4.416439e-004f, -3.848790e-005f, -1.839272e-003f, -6.836005e-004f,  3.485823e-003f,  4.947952e-003f,
    2.635928e-003f,  1.442204e-003f,  2.490000e-003f,  1.948297e-003f, -1.997022e-004f,  6.257184e-005f,  2.401954e-003f,  2.772054e-003f,
    1.498224e-003f,  1.958138e-003f,  3.043334e-003f,  1.398067e-003f, -1.369809e-003f, -1.589429e-003f, -2.663015e-004f,  2.146745e-004f,
    1.607000e-003f,  5.182578e-003f,  6.955660e-003f,  4.211801e-003f,  1.080639e-003f,  1.403327e-003f,  2.267628e-003f,  5.488840e-004f,
   -6.706518e-004f,  1.835318e-003f,  5.072784e-003f,  5.058581e-003f,  3.029774e-003f,  1.860069e-003f,  1.269363e-003f,  3.105912e-004f,
    2.099534e-005f,  6.708425e-004f,  4.716764e-004f, -9.814220e-004f, -1.765722e-003f, -1.286644e-003f, -1.200176e-003f, -1.961148e-003f,
   -1.941644e-003f, -6.349557e-004f,  2.553500e-004f, -4.539473e-004f, -1.865087e-003f, -2.612014e-003f, -2.431091e-003f, -1.826910e-003f,
   -1.226685e-003f, -7.817275e-004f, -5.654034e-004f, -6.292001e-004f, -7.115139e-004f, -2.155122e-004f,  8.960978e-004f,  1.514214e-003f,
    6.675133e-004f, -9.657129e-004f, -1.964033e-003f, -2.002597e-003f, -1.484242e-003f, -2.619443e-004f,  1.534485e-003f,  2.318983e-003f,
    7.283178e-004f, -2.093075e-003f, -3.682951e-003f, -3.291993e-003f, -2.270525e-003f, -1.867000e-003f, -1.879754e-003f, -1.338557e-003f,
    2.275870e-004f,  2.296226e-003f,  4.009449e-003f,  5.074391e-003f,  5.495427e-003f,  4.852233e-003f,  3.030107e-003f,  1.110630e-003f,
   -1.308428e-004f, -1.703248e-003f, -4.185347e-003f, -5.518803e-003f, -4.056160e-003f, -2.016991e-003f, -2.122321e-003f, -2.860990e-003f,
   -1.546791e-003f,  3.460988e-004f,  1.411922e-004f, -3.074293e-004f,  2.203388e-003f,  5.706134e-003f,  6.078320e-003f,  4.345529e-003f,
    4.353356e-003f,  5.180798e-003f,  2.822777e-003f, -1.927422e-003f, -4.086975e-003f, -2.418781e-003f, -6.817630e-004f, -1.022341e-003f,
   -1.481819e-003f, -6.093763e-004f, -5.046404e-005f, -1.243106e-003f, -2.677925e-003f, -2.191314e-003f, -3.042485e-004f,  6.154150e-004f,
    7.072961e-005f,  2.029482e-004f,  2.052419e-003f,  3.345872e-003f,  2.023034e-003f, -3.363799e-004f, -1.473107e-003f, -2.272707e-003f,
   -3.958006e-003f, -4.393407e-003f, -1.756120e-003f,  1.153170e-003f,  1.258906e-003f,  4.663926e-004f,  1.438654e-003f,  2.346298e-003f,
    1.348591e-003f,  1.228252e-003f,  3.510773e-003f,  3.780588e-003f, -5.540237e-004f, -4.206909e-003f, -2.704090e-003f, -2.252071e-004f,
   -1.394072e-003f, -2.577150e-003f,  6.640512e-004f,  4.666704e-003f,  4.446017e-003f,  2.591961e-003f,  3.371731e-003f,  4.358467e-003f,
    1.696743e-003f, -2.076944e-003f, -2.658460e-003f, -1.334667e-003f, -1.456083e-003f, -2.090062e-003f, -6.331146e-004f,  1.971866e-003f,
    3.000098e-003f,  2.129591e-003f,  1.021743e-003f,  9.362734e-004f,  2.073591e-003f,  3.413731e-003f,  3.270875e-003f,  1.634293e-003f,
    6.088577e-004f,  9.957619e-004f,  8.878694e-004f, -7.090775e-004f, -1.997931e-003f, -1.756896e-003f, -1.121068e-003f, -6.818022e-004f,
    4.022079e-004f,  1.445472e-003f,  5.074809e-004f, -1.690472e-003f, -2.351153e-003f, -1.401548e-003f, -1.319461e-003f, -2.188661e-003f,
   -1.592384e-003f,  4.609418e-004f,  1.089760e-003f, -6.074914e-004f, -2.293507e-003f, -2.428326e-003f, -2.096609e-003f, -2.275788e-003f,
   -2.162023e-003f, -1.071786e-003f, -6.308759e-005f, -5.742066e-004f, -2.232619e-003f, -3.076148e-003f, -2.251637e-003f, -1.546106e-003f,
   -2.911936e-003f, -5.189306e-003f, -5.447455e-003f, -3.142780e-003f, -3.007397e-004f,  1.961714e-003f,  3.921136e-003f,  4.789636e-003f,
    3.405900e-003f,  9.800381e-004f, -3.325734e-004f, -7.156207e-004f, -1.189215e-003f, -7.055934e-004f,  1.432617e-003f,  2.820863e-003f,
    1.885403e-003f,  1.461818e-003f,  3.864862e-003f,  6.055291e-003f,  4.699007e-003f,  2.044653e-003f,  1.575722e-003f,  2.052148e-003f,
    1.092664e-003f,  2.127190e-004f,  1.139081e-003f,  1.655645e-003f, -7.555693e-005f, -1.688384e-003f, -1.219227e-003f, -5.327656e-004f,
   -7.697230e-004f, -1.795337e-005f,  1.628595e-003f,  1.021071e-003f, -1.522357e-003f, -1.553579e-003f,  1.370138e-003f,  2.265738e-003f,
   -4.032705e-004f, -2.084406e-003f, -4.358893e-004f,  1.401703e-003f,  1.641468e-003f,  2.298112e-003f,  3.335984e-003f,  2.054109e-003f,
   -4.952817e-004f, -6.961029e-005f,  2.959112e-003f,  3.847727e-003f,  1.877873e-003f,  9.396274e-004f,  1.693897e-003f,  8.911568e-004f,
   -1.430589e-003f, -1.689506e-003f,  2.076581e-004f,  8.040163e-004f, -7.972453e-005f,  5.283580e-004f,  2.112739e-003f,  1.121345e-003f,
   -2.049039e-003f, -3.097516e-003f, -9.808894e-004f,  8.476494e-004f,  4.753707e-004f, -3.707026e-004f, -2.613730e-004f,  3.479576e-004f,
    1.262059e-003f,  2.607644e-003f,  3.376939e-003f,  2.897832e-003f,  2.507995e-003f,  3.184194e-003f,  3.452210e-003f,  2.226275e-003f,
    1.314924e-003f,  2.327756e-003f,  3.603509e-003f,  3.088094e-003f,  1.773171e-003f,  1.373533e-003f,  1.078758e-003f, -3.368011e-004f,
   -1.515305e-003f, -8.503812e-004f,  2.103757e-004f, -4.678743e-004f, -1.709428e-003f, -8.967358e-004f,  1.325462e-003f,  1.847408e-003f,
    1.094169e-004f, -1.233611e-003f, -7.438989e-004f,  1.708624e-004f,  6.178912e-004f,  1.663596e-003f,  3.210560e-003f,  2.970425e-003f,
    5.019091e-004f, -1.042368e-003f,  3.197240e-004f,  2.039689e-003f,  1.369822e-003f, -4.125402e-005f,  5.671101e-004f,  1.972384e-003f,
    1.203441e-003f, -1.321380e-003f, -2.940308e-003f, -3.257898e-003f, -3.701462e-003f, -4.141904e-003f, -3.475133e-003f, -2.212857e-003f,
   -1.547956e-003f, -1.264213e-003f, -8.890450e-004f, -1.140186e-003f, -2.264769e-003f, -2.916497e-003f, -2.285080e-003f, -1.347036e-003f,
   -9.382023e-004f, -6.174279e-004f,  1.092050e-005f,  7.154343e-004f,  1.241216e-003f,  1.008088e-003f, -5.666987e-004f, -2.192272e-003f,
   -1.650536e-003f,  1.864575e-004f,  7.901392e-005f, -1.637147e-003f, -1.036589e-003f,  1.957345e-003f,  2.555498e-003f, -4.357470e-004f,
   -2.332629e-003f, -1.134180e-003f, -6.325085e-004f, -2.396190e-003f, -2.739303e-003f, -4.255551e-004f,  6.472683e-004f, -9.873231e-004f,
   -1.859105e-003f, -5.646760e-004f,  1.473744e-004f, -6.243685e-004f, -9.242097e-004f, -8.854324e-004f, -1.876309e-003f, -2.013477e-003f,
    7.461915e-004f,  3.467375e-003f,  2.752011e-003f,  8.800919e-004f,  1.124947e-003f,  1.547911e-003f, -2.922081e-004f, -1.764346e-003f,
   -3.081177e-004f,  1.456289e-003f,  9.788988e-004f,  2.192012e-004f,  7.079375e-004f,  4.992861e-004f, -9.701418e-004f, -1.542866e-003f,
   -1.330557e-003f, -2.131740e-003f, -2.154820e-003f,  9.845441e-004f,  3.725919e-003f,  1.570160e-003f, -2.119286e-003f, -1.430192e-003f,
    1.576071e-003f,  1.188645e-003f, -1.262598e-003f, -7.911132e-004f,  1.456665e-003f,  1.217397e-003f, -3.417562e-004f,  3.630722e-004f,
    2.079099e-003f,  1.778568e-003f,  5.035539e-004f,  3.547049e-004f,  4.433955e-004f,  5.591294e-005f,  5.732036e-004f,  1.545575e-003f,
    6.622861e-004f, -1.046827e-003f, -2.819845e-004f,  2.070358e-003f,  2.112719e-003f, -1.976958e-004f, -1.815327e-003f, -2.399793e-003f,
   -3.034244e-003f, -2.054883e-003f,  1.533199e-003f,  4.027449e-003f,  2.466138e-003f,  6.672626e-005f,  6.512098e-004f,  2.150842e-003f,
    9.672352e-004f, -1.725295e-003f, -2.872044e-003f, -2.538332e-003f, -2.049624e-003f, -1.018581e-003f,  7.152910e-004f,  1.681787e-003f,
    1.394868e-003f,  1.227217e-003f,  1.536447e-003f,  8.816363e-004f, -1.190494e-003f, -3.019442e-003f, -2.993102e-003f, -1.382472e-003f,
    1.231993e-004f,  2.819437e-004f, -1.326155e-004f,  7.109051e-004f,  2.708325e-003f,  3.528492e-003f,  2.170921e-003f,  3.744722e-004f,
   -4.264294e-004f, -5.991723e-004f, -2.771044e-004f,  6.479996e-004f,  6.786240e-004f, -1.036518e-003f, -1.750602e-003f,  7.094342e-004f,
    3.008102e-003f,  1.393171e-003f, -1.246492e-003f, -2.144705e-004f,  2.454347e-003f,  1.703967e-003f, -1.614247e-003f, -2.841007e-003f,
   -1.338769e-003f,  1.835569e-004f,  7.681684e-004f,  6.308325e-004f, -5.384245e-004f, -1.415154e-003f, -7.728884e-005f,  1.437338e-003f,
   -7.114666e-005f, -1.941596e-003f,  5.055144e-004f,  4.450736e-003f,  3.402227e-003f, -1.271568e-003f, -2.788960e-003f, -7.422318e-004f,
   -3.548343e-004f, -2.591871e-003f, -4.240470e-003f, -4.426611e-003f, -3.377119e-003f,  2.252514e-004f,  4.434065e-003f,  3.785229e-003f,
   -1.023559e-003f, -2.372968e-003f,  1.231515e-003f,  2.454789e-003f, -1.080182e-003f, -2.913527e-003f, -6.654722e-004f,  4.391990e-004f,
   -8.719451e-004f, -2.765715e-004f,  1.464167e-003f, -2.449758e-004f, -2.814587e-003f, -5.096188e-004f,  3.054019e-003f,  6.505409e-004f,
   -4.103523e-003f, -2.507789e-003f,  3.358061e-003f,  4.617811e-003f,  8.705799e-004f, -1.455058e-003f, -1.132862e-003f, -1.160279e-003f,
   -9.148515e-004f,  1.272408e-003f,  2.994059e-003f,  2.073534e-003f,  2.031930e-004f, -1.679217e-003f, -4.578400e-003f, -6.248435e-003f,
   -3.180280e-003f,  1.818189e-003f,  2.897919e-003f,  1.079591e-003f,  1.846374e-003f,  5.000086e-003f,  6.005447e-003f,  4.586707e-003f,
    3.468101e-003f,  2.024985e-003f, -1.206675e-003f, -3.600334e-003f, -2.381735e-003f,  5.455802e-004f,  2.198190e-003f,  2.408559e-003f,
    1.437631e-003f, -1.166596e-003f, -3.782281e-003f, -3.674509e-003f, -1.002583e-003f,  2.027623e-003f,  4.264865e-003f,  4.732099e-003f,
    2.388836e-003f, -6.954856e-004f, -1.082103e-003f, -1.565884e-004f, -1.913748e-003f, -4.809867e-003f, -4.231927e-003f, -1.539379e-003f,
   -9.497543e-004f, -6.446841e-004f,  2.079852e-003f,  2.144605e-003f, -3.953102e-003f, -6.983673e-003f,  1.643530e-003f,  1.235688e-002f,
    9.983235e-003f, -2.173126e-003f, -7.542484e-003f, -8.454946e-004f,  7.851732e-003f,  9.942358e-003f,  6.482291e-003f,  2.619857e-003f,
    2.509648e-003f,  6.268258e-003f,  8.085241e-003f,  3.342646e-003f, -2.343780e-003f, -7.709023e-004f,  4.226995e-003f,  2.654499e-003f,
   -3.885118e-003f, -5.305813e-003f, -1.107309e-003f,  5.867463e-004f, -8.601106e-004f,  4.876213e-004f,  3.163862e-003f,  8.143312e-004f,
   -4.451110e-003f, -5.418308e-003f, -2.727081e-003f, -1.934804e-003f, -2.560411e-003f, -1.358199e-003f, -6.026442e-004f, -2.793731e-003f,
   -3.527426e-003f,  1.083989e-003f,  6.318723e-003f,  6.046518e-003f,  1.759951e-003f, -1.763912e-003f, -3.474535e-003f, -3.767615e-003f,
   -1.313677e-003f,  3.568605e-003f,  7.104306e-003f,  6.476500e-003f,  2.829143e-003f, -9.167615e-004f, -2.657516e-003f, -2.000863e-003f,
   -4.020796e-004f,  5.534678e-004f,  1.143883e-003f,  2.037693e-003f,  2.576645e-003f,  3.243098e-003f,  6.203975e-003f,  9.690224e-003f,
    7.526467e-003f, -5.489603e-004f, -5.330073e-003f, -1.644302e-003f,  2.759973e-003f, -5.709979e-005f, -5.240097e-003f, -4.362231e-003f,
    4.833041e-004f,  1.937905e-003f, -2.314514e-004f, -1.571753e-003f, -1.745361e-003f, -2.524628e-003f, -2.495307e-003f, -6.107654e-004f,
    4.151701e-004f, -4.328325e-004f,  3.803270e-004f,  3.962246e-003f,  5.747481e-003f,  3.335582e-003f,  8.044030e-004f,  1.049671e-003f,
    5.398603e-004f, -3.578170e-003f, -7.162960e-003f, -5.318811e-003f, -5.302434e-004f,  9.767321e-004f, -1.750668e-003f, -4.107805e-003f,
   -3.097275e-003f, -1.249723e-004f,  2.586100e-003f,  3.958445e-003f,  2.808890e-003f, -7.395442e-004f, -2.671882e-003f,  8.659144e-004f,
    6.646288e-003f,  7.484035e-003f,  2.838530e-003f, -7.164535e-004f, -4.213106e-004f, -2.786154e-004f, -1.540556e-003f,  9.911819e-006f,
    4.495698e-003f,  5.763373e-003f,  2.267337e-003f,  1.508886e-004f,  2.078641e-003f,  3.235864e-003f,  1.562809e-003f,  1.236722e-003f,
    2.910560e-003f,  1.504041e-003f, -3.176543e-003f, -4.496287e-003f, -6.870737e-004f,  1.857496e-003f, -3.039047e-004f, -2.847400e-003f,
   -2.253501e-003f, -5.292807e-004f,  3.833076e-004f,  1.406409e-003f,  2.384313e-003f,  1.488785e-003f, -1.010430e-003f, -2.966423e-003f,
   -3.653796e-003f, -3.412765e-003f, -1.734665e-003f,  1.335465e-003f,  3.634543e-003f,  2.933032e-003f, -4.210775e-004f, -3.518060e-003f,
   -3.214847e-003f,  3.656351e-004f,  2.929287e-003f,  1.416799e-003f, -1.069567e-003f, -6.076752e-004f, -6.788109e-005f, -3.802360e-003f,
   -7.921351e-003f, -5.978144e-003f, -1.239976e-003f, -1.465764e-003f, -4.568987e-003f, -2.561661e-003f,  3.253398e-003f,  4.667108e-003f,
    1.073370e-003f, -1.642783e-003f, -2.849840e-003f, -5.081909e-003f, -5.416425e-003f, -1.454065e-003f,  4.511758e-004f, -4.816367e-003f,
   -1.025497e-002f, -7.646631e-003f, -1.103559e-003f,  1.649956e-003f,  2.602252e-003f,  6.640062e-003f,  9.870258e-003f,  5.988395e-003f,
   -2.007340e-003f, -5.625484e-003f, -2.167018e-003f,  3.412073e-003f,  4.730289e-003f,  3.753809e-005f, -5.532778e-003f, -5.407771e-003f,
   -9.957241e-004f,  1.676998e-004f, -2.453960e-003f, -1.112315e-003f,  5.093531e-003f,  6.598412e-003f,  1.364503e-004f, -4.516870e-003f,
   -9.169169e-004f,  4.226143e-003f,  3.842804e-003f,  6.223539e-004f, -9.391262e-004f, -1.189553e-003f, -5.119685e-004f,  1.897151e-003f,
    3.440503e-003f,  1.589905e-003f, -9.750929e-005f,  1.630112e-003f,  2.400917e-003f, -1.256582e-003f, -3.260153e-003f,  1.877309e-003f,
    8.020904e-003f,  6.909287e-003f,  1.416814e-003f, -1.265998e-005f,  3.904998e-003f,  7.233921e-003f,  5.033168e-003f, -1.623004e-003f,
   -5.674405e-003f, -1.123330e-003f,  6.803218e-003f,  6.088472e-003f, -3.177790e-003f, -6.893021e-003f,  2.137386e-005f,  5.419541e-003f,
    2.566058e-003f,  6.434003e-004f,  3.239554e-003f, -5.752530e-005f, -9.412244e-003f, -8.465336e-003f,  4.534088e-003f,  7.685884e-003f,
   -6.968426e-003f, -1.601099e-002f, -2.957611e-003f,  1.407239e-002f,  1.303982e-002f,  1.094341e-003f, -3.389690e-003f, -2.348088e-004f,
    5.353022e-004f, -1.254521e-003f, -6.673519e-004f,  7.368676e-004f,  3.100379e-004f,  7.310612e-004f,  3.398668e-003f,  4.732184e-003f,
    2.894815e-003f,  1.135169e-005f, -2.728017e-003f, -4.769569e-003f, -3.426958e-003f,  1.757159e-003f,  6.081748e-003f,  6.555767e-003f,
    5.579983e-003f,  3.963437e-003f, -9.730511e-004f, -6.811507e-003f, -6.139679e-003f,  7.782234e-004f,  4.336977e-003f,  5.938415e-004f,
   -2.848702e-003f, -9.428606e-006f,  4.639058e-003f,  4.959609e-003f,  2.198953e-003f,  7.485141e-004f,  1.056048e-003f,  6.334163e-004f,
   -1.435023e-003f, -3.437715e-003f, -3.149236e-003f, -5.144850e-004f,  1.671495e-003f,  8.984489e-004f, -1.605314e-003f, -2.482350e-003f,
   -6.628077e-004f,  1.950785e-003f,  3.341517e-003f,  2.978419e-003f,  1.425037e-003f, -3.331907e-004f, -1.697096e-003f, -2.517878e-003f,
   -2.036946e-003f,  2.731348e-004f,  2.340667e-003f,  1.707978e-003f,  5.029546e-004f,  2.509831e-003f,  5.173152e-003f,  2.609428e-003f,
   -3.209222e-003f, -4.494507e-003f, -1.125096e-003f, -1.533194e-004f, -1.942663e-003f, -5.543256e-004f,  2.534661e-003f,  5.437122e-004f,
   -3.690020e-003f, -1.578252e-003f,  4.001585e-003f,  2.934314e-003f, -3.258057e-003f, -4.982919e-003f, -3.013341e-003f, -4.531134e-003f,
   -6.454732e-003f, -2.248463e-003f,  2.049278e-003f, -1.375260e-003f, -4.911473e-003f,  3.867859e-005f,  3.637980e-003f, -4.339901e-003f,
   -1.072752e-002f,  6.205092e-004f,  1.725752e-002f,  1.506024e-002f, -3.182443e-003f, -1.370904e-002f, -8.759161e-003f, -1.484293e-003f,
    5.856055e-004f,  2.672869e-003f,  6.045251e-003f,  4.800916e-003f, -1.201177e-003f, -5.400930e-003f, -5.499424e-003f, -4.541391e-003f,
   -3.688582e-003f, -2.183349e-003f, -1.113827e-003f, -1.275292e-003f, -1.133421e-003f, -3.848270e-004f, -7.823511e-004f, -1.763484e-003f,
   -9.046308e-004f,  8.246897e-004f,  5.070986e-004f, -5.529968e-004f,  9.774053e-004f,  3.076666e-003f,  8.698587e-004f, -4.021784e-003f,
   -4.672850e-003f,  5.461663e-005f,  3.363047e-003f,  1.314391e-003f, -1.321950e-003f,  5.182184e-004f,  3.853240e-003f,  2.971521e-003f,
   -9.269047e-004f, -1.983022e-003f,  3.064866e-004f,  7.727967e-004f, -1.586571e-003f, -1.552737e-003f,  2.356977e-003f,  4.204730e-003f,
    8.807197e-004f, -2.101019e-003f, -3.052038e-004f,  2.002125e-003f,  1.142730e-004f, -2.755263e-003f, -2.171627e-003f, -5.050391e-004f,
   -1.231664e-003f, -1.734581e-003f,  1.193194e-003f,  4.479566e-003f,  3.924116e-003f,  1.123585e-003f, -1.857039e-004f,  4.701630e-005f,
    2.176844e-004f,  2.147594e-004f, -4.484601e-004f, -2.839570e-003f, -5.151256e-003f, -4.137801e-003f, -8.075247e-004f,  7.295088e-004f,
    3.436421e-005f,  1.126289e-004f,  1.038871e-003f,  1.469415e-004f, -1.977479e-003f, -2.035377e-003f, -2.038097e-004f,  9.146269e-005f,
   -1.614897e-003f, -2.103372e-003f,  4.124455e-006f,  2.268731e-003f,  2.209515e-003f,  1.744419e-004f, -1.539754e-003f, -1.007750e-003f,
    1.191328e-003f,  2.003700e-003f, -2.062044e-004f, -2.540100e-003f, -1.418898e-003f,  1.420806e-003f,  1.158072e-003f, -2.324010e-003f,
   -4.028558e-003f, -1.730224e-003f,  9.518304e-004f,  7.805313e-004f, -6.121873e-004f, -5.775930e-004f,  3.352951e-004f,  5.541083e-004f,
    5.274874e-004f,  9.377761e-004f,  6.242709e-004f, -9.828553e-004f, -1.710486e-003f,  1.456110e-004f,  2.418781e-003f,  2.078797e-003f,
    8.239215e-005f, -3.212386e-004f,  9.438745e-004f,  9.515483e-004f, -8.992292e-004f, -1.761978e-003f, -8.260043e-005f,  2.133204e-003f,
    2.694759e-003f,  1.776836e-003f,  2.846081e-004f, -1.369332e-003f, -2.042048e-003f, -3.525610e-004f,  2.548115e-003f,  3.325131e-003f,
    7.719352e-004f, -2.395201e-003f, -3.224087e-003f, -2.236243e-003f, -2.163540e-003f, -4.057202e-003f, -5.953345e-003f, -5.387701e-003f,
   -2.498842e-003f,  1.307912e-004f,  7.312695e-004f,  2.082246e-004f,  8.922880e-005f,  2.377894e-004f,  1.448019e-005f,  7.977579e-006f,
    7.112636e-004f,  1.115832e-003f,  6.079662e-004f,  3.874812e-004f,  9.485836e-004f,  5.504733e-004f, -1.340057e-003f, -1.931185e-003f,
    3.507627e-004f,  2.099139e-003f, -1.608946e-004f, -3.658137e-003f, -2.847417e-003f,  2.045733e-003f,  5.026764e-003f,  3.021380e-003f,
   -6.594950e-005f,  5.240482e-004f,  3.763614e-003f,  4.799388e-003f,  1.628731e-003f, -2.821279e-003f, -4.815445e-003f, -3.765136e-003f,
   -1.474035e-003f,  8.891231e-004f,  3.410934e-003f,  5.337306e-003f,  4.309520e-003f, -6.078129e-004f, -5.646657e-003f, -4.849838e-003f,
    2.336344e-003f,  8.363300e-003f,  6.162557e-003f, -1.024161e-003f, -3.670702e-003f,  4.529571e-004f,  3.644189e-003f,  9.156835e-004f,
   -2.632188e-003f, -1.305066e-003f,  1.929964e-003f,  1.869815e-003f,  2.353514e-004f,  1.206702e-003f,  3.119523e-003f,  2.082117e-003f,
   -3.663572e-004f, -3.345927e-004f,  1.234856e-003f,  9.694917e-004f, -4.377849e-004f,  5.132332e-005f,  2.221649e-003f,  3.496133e-003f,
    3.132320e-003f,  2.122330e-003f,  1.226897e-003f,  1.111286e-003f,  1.866696e-003f,  1.820568e-003f, -1.306638e-004f, -1.808425e-003f,
   -1.107814e-003f, -6.134596e-005f, -1.009724e-003f, -1.736241e-003f,  6.573555e-005f,  1.151609e-003f, -1.919909e-003f, -5.596639e-003f,
   -4.711780e-003f, -1.402439e-003f, -1.076575e-003f, -2.857283e-003f, -1.899353e-003f,  1.463685e-003f,  2.528000e-003f,  3.379135e-004f,
   -1.709237e-003f, -1.966908e-003f, -1.608214e-003f, -9.784796e-004f,  2.424394e-004f,  5.654991e-004f, -1.265358e-003f, -2.802527e-003f,
   -4.194291e-004f,  4.994927e-003f,  8.086930e-003f,  5.384626e-003f, -3.612035e-004f, -3.204949e-003f, -6.454923e-004f,  3.837456e-003f,
    5.063064e-003f,  1.899216e-003f, -2.225154e-003f, -3.732360e-003f, -2.344745e-003f, -3.630038e-004f,  2.089502e-004f, -4.320036e-004f,
   -4.930167e-004f,  9.220887e-004f,  2.509829e-003f,  2.711143e-003f,  1.885979e-003f,  1.179981e-003f,  7.106148e-004f,  6.873882e-004f,
    2.260275e-003f,  4.870270e-003f,  5.292652e-003f,  2.256129e-003f, -7.675282e-004f, -5.812370e-004f,  1.058554e-003f,  1.214738e-003f,
    7.834630e-004f,  1.862356e-003f,  3.185622e-003f,  1.955016e-003f, -2.043465e-003f, -6.570935e-003f, -8.885103e-003f, -6.815911e-003f,
   -1.197528e-003f,  2.960844e-003f,  1.894541e-003f, -1.265321e-003f, -1.108233e-003f,  1.669786e-003f,  2.526305e-003f,  1.517316e-003f,
    2.268120e-003f,  4.128639e-003f,  2.960872e-003f, -9.420119e-004f, -2.713663e-003f, -5.861788e-004f,  2.027101e-003f,  2.034654e-003f,
   -1.250304e-004f, -2.384901e-003f, -3.075930e-003f, -1.807274e-003f,  7.344230e-006f,  7.657990e-004f,  9.396285e-004f,  1.508527e-003f,
    1.257736e-003f, -8.993915e-004f, -2.510866e-003f, -8.121347e-004f,  2.313770e-003f,  3.111781e-003f,  1.821665e-003f,  1.282307e-003f,
    1.720297e-003f,  1.313811e-003f,  8.041464e-005f, -5.420667e-004f, -2.864174e-004f,  3.053597e-004f,  8.381775e-004f,  4.301944e-004f,
   -1.187895e-003f, -1.756177e-003f,  7.690653e-004f,  3.959607e-003f,  3.690203e-003f,  5.919926e-004f, -8.737572e-004f,  7.113108e-004f,
    2.233966e-003f,  1.163482e-003f, -1.514488e-003f, -3.277997e-003f, -2.630999e-003f, -2.585180e-004f,  1.481575e-003f,  1.467264e-003f,
    1.569362e-003f,  3.169553e-003f,  3.901737e-003f,  1.661047e-003f, -7.784046e-004f, -1.570989e-004f,  1.168829e-003f, -6.068876e-004f,
   -3.367759e-003f, -2.318947e-003f,  1.779158e-003f,  3.868931e-003f,  2.252945e-003f, -2.659347e-004f, -1.199600e-003f, -3.595987e-004f,
    1.142628e-003f,  1.451159e-003f, -2.212178e-004f, -1.612468e-003f, -3.857312e-004f,  1.675694e-003f,  1.707073e-003f,  1.104187e-003f,
    2.373770e-003f,  3.196815e-003f,  1.969785e-004f, -3.877073e-003f, -3.697371e-003f,  1.773122e-004f,  2.916578e-003f,  3.066528e-003f,
    2.565354e-003f,  1.753602e-003f, -1.489526e-004f, -1.994999e-003f, -2.337975e-003f, -1.633870e-003f, -3.893805e-004f,  1.585697e-003f,
    2.947261e-003f,  1.990097e-003f,  2.450891e-004f,  3.142320e-004f,  1.097704e-003f,  3.645313e-004f,  5.245452e-006f,  2.693119e-003f,
    5.864712e-003f,  5.472543e-003f,  2.895086e-003f,  1.717684e-003f,  1.055178e-003f, -1.329553e-003f, -2.971948e-003f, -6.895324e-004f,
    2.663361e-003f,  2.097142e-003f, -1.474943e-003f, -2.999093e-003f, -9.842045e-004f,  1.572750e-003f,  2.455185e-003f,  2.367454e-003f,
    2.465236e-003f,  2.447022e-003f,  1.310142e-003f, -8.463091e-004f, -2.267532e-003f, -1.636896e-003f, -3.151707e-004f, -3.914498e-004f,
   -8.820978e-004f,  9.107098e-004f,  4.381961e-003f,  5.849427e-003f,  3.995582e-003f,  1.247747e-003f, -3.242658e-004f, -8.476615e-004f,
   -7.082591e-004f, -6.399355e-005f,  4.332682e-004f,  8.416435e-004f,  2.053583e-003f,  3.076432e-003f,  1.586127e-003f, -1.271858e-003f,
   -1.354007e-003f,  1.532653e-003f,  2.763521e-003f,  7.101914e-004f, -8.759488e-004f, -8.159479e-005f,  2.999539e-004f, -1.012911e-003f,
   -1.467959e-003f, -3.464452e-004f, -2.545690e-004f, -1.514386e-003f, -1.156209e-003f,  1.462762e-003f,  3.425783e-003f,  3.000408e-003f,
    1.151887e-003f, -9.358201e-004f, -2.127892e-003f, -1.107859e-003f,  9.720724e-004f,  7.738317e-004f, -1.741695e-003f, -2.631886e-003f,
   -9.702187e-004f, -5.848352e-004f, -2.480401e-003f, -2.563263e-003f,  2.814684e-004f,  1.437541e-003f, -8.788575e-004f, -2.053314e-003f,
    2.858921e-004f,  1.679153e-003f, -1.022687e-003f, -3.996168e-003f, -3.316308e-003f, -1.262210e-003f, -1.254362e-003f, -1.787377e-003f,
   -8.841878e-005f,  2.171666e-003f,  1.461303e-003f, -1.724130e-003f, -3.613561e-003f, -2.723242e-003f, -1.331320e-003f, -1.416727e-003f,
   -1.881541e-003f, -9.175645e-004f,  8.007829e-004f,  1.204615e-003f,  8.689970e-005f, -9.160069e-004f, -1.096047e-003f, -1.092024e-003f,
   -8.157849e-004f,  4.597768e-004f,  1.922057e-003f,  1.764057e-003f,  2.145791e-004f, -4.078255e-004f,  8.118553e-004f,  1.834807e-003f,
    3.726741e-004f, -2.903112e-003f, -4.577862e-003f, -2.324455e-003f,  1.481365e-003f,  1.846677e-003f, -1.844698e-003f, -4.023224e-003f,
   -1.111918e-003f,  2.421003e-003f,  1.159253e-003f, -2.230732e-003f, -1.892205e-003f,  9.651765e-004f,  8.549428e-004f, -1.807497e-003f,
   -2.108148e-003f, -1.676126e-004f, -4.978647e-004f, -3.281434e-003f, -4.475653e-003f, -3.259342e-003f, -2.030078e-003f, -8.844808e-004f,
    1.107762e-003f,  1.796293e-003f, -3.170859e-004f, -1.574303e-003f,  1.098855e-003f,  3.791908e-003f,  1.644060e-003f, -2.619475e-003f,
   -3.018014e-003f,  2.656272e-004f,  2.357365e-003f,  1.749726e-003f,  9.119168e-004f,  9.393668e-004f,  6.265471e-004f, -4.323194e-004f,
   -1.368546e-003f, -1.644111e-003f, -1.186636e-003f, -2.768429e-004f, -1.189176e-004f, -1.613928e-003f, -3.263386e-003f, -2.601532e-003f,
    2.091710e-007f,  1.285029e-003f, -5.551678e-004f, -3.354866e-003f, -3.778175e-003f, -1.735951e-003f, -5.919937e-004f, -2.328772e-003f,
   -3.969786e-003f, -1.483555e-003f,  3.347962e-003f,  4.326504e-003f,  4.917513e-006f, -3.748885e-003f, -2.689499e-003f, -2.225252e-004f,
   -9.195763e-004f, -3.215690e-003f, -3.121823e-003f, -9.470638e-004f,  3.531087e-004f,  2.771837e-004f,  2.024241e-004f,  3.060855e-004f,
    1.168884e-004f, -4.130133e-005f, -3.591336e-005f, -3.088216e-004f, -6.374671e-004f, -6.306677e-004f, -8.547076e-004f, -1.116511e-003f,
    4.761741e-004f,  3.770578e-003f,  4.731740e-003f,  1.110908e-003f, -3.218548e-003f, -3.696407e-003f, -1.421122e-003f,  1.009295e-004f,
    7.071035e-004f,  1.653279e-003f,  1.763004e-003f, -1.045130e-004f, -2.197147e-003f, -2.997252e-003f, -3.481830e-003f, -3.726045e-003f,
   -1.935565e-003f,  9.242424e-004f,  1.104324e-003f, -1.081580e-003f, -6.773404e-004f,  3.077009e-003f,  4.211869e-003f, -1.786951e-004f,
   -4.359907e-003f, -2.681946e-003f,  1.925315e-003f,  3.309218e-003f,  1.462972e-003f,  1.082324e-003f,  3.416393e-003f,  4.728802e-003f,
    2.374168e-003f, -1.388846e-003f, -2.639265e-003f, -9.035466e-004f,  6.151760e-004f, -3.299258e-004f, -2.014871e-003f, -1.694215e-003f,
   -6.111617e-006f,  1.921984e-004f, -1.357487e-003f, -1.901499e-003f, -2.757183e-004f,  1.199833e-003f,  2.939770e-004f, -2.114565e-003f,
   -3.505976e-003f, -2.481923e-003f,  3.762010e-004f,  3.017783e-003f,  3.355184e-003f,  1.441117e-003f, -2.483602e-004f,  1.218849e-004f,
    1.369806e-003f,  1.460321e-003f,  4.238015e-004f, -2.589347e-004f, -1.003637e-004f,  6.887293e-005f, -3.283871e-004f, -8.722381e-004f,
   -9.012186e-004f, -4.684785e-004f, -3.381721e-004f, -8.819423e-004f, -1.281743e-003f, -6.584353e-004f,  2.456908e-004f, -4.673473e-005f,
   -1.204453e-003f, -1.342991e-003f, -1.203299e-004f,  6.104176e-004f, -1.167784e-004f, -9.108795e-004f, -5.672328e-004f,  1.010574e-004f,
    1.071242e-004f, -2.224372e-005f,  3.637726e-004f,  6.712889e-004f,  2.889658e-004f, -2.166051e-004f, -1.729161e-004f,  9.970925e-005f,
    9.223491e-005f, -9.748191e-006f,  8.462671e-005f,  1.674974e-004f,  4.005247e-005f, -8.017042e-005f, -1.816951e-005f,  6.292633e-005f,
    3.332787e-005f, -3.879762e-006f,  1.725953e-005f,  2.532226e-005f,  6.158598e-007f, -4.208273e-006f,  8.197941e-006f,  6.136967e-006f
};

static const float MPSVTImpulseRight5[] =
{
    0.00000000000f,  3.994024e-001f,  8.075847e-002f, -4.190122e-002f, -8.227470e-002f, -3.298921e-002f,  4.915686e-002f,  7.079224e-002f,
    3.135914e-002f, -1.230055e-002f, -2.094102e-002f, -1.331936e-002f, -1.229073e-002f, -1.568965e-002f, -1.070220e-002f, -2.808838e-003f,
   -2.118362e-003f, -6.566772e-003f, -6.632809e-003f, -3.369000e-003f, -3.098406e-003f, -4.725005e-003f, -1.362022e-003f,  5.677119e-003f,
    8.490948e-003f,  5.076202e-003f,  2.185228e-003f,  3.394799e-003f,  4.517492e-003f,  1.872191e-003f, -1.172951e-003f, -5.794968e-004f,
    1.795990e-003f,  1.512528e-003f, -1.348754e-003f, -3.162409e-003f, -2.324117e-003f, -7.667542e-004f, -2.328758e-004f, -3.600797e-004f,
   -1.136071e-004f,  5.047470e-004f,  9.147234e-004f,  7.449146e-004f,  1.759950e-004f, -2.538267e-004f, -3.369584e-005f,  5.983568e-004f,
    8.393890e-004f,  3.525812e-004f, -1.937244e-004f, -1.482494e-004f,  2.271883e-004f,  2.705029e-004f, -8.763868e-006f, -9.659777e-005f,
    1.575365e-004f,  3.583533e-004f,  2.436471e-004f, -1.942646e-005f, -1.532277e-004f, -1.007960e-004f,  4.388302e-005f,  1.454806e-004f,
    1.163240e-004f,  6.098220e-006f, -8.432295e-006f,  1.176024e-004f,  2.008553e-004f,  1.019828e-004f, -2.418622e-005f,  2.946853e-005f,
    1.866242e-004f,  2.026305e-004f,  5.481676e-005f, -4.558522e-005f,  1.050140e-005f,  9.380322e-005f,  7.870015e-005f,  1.507760e-005f,
    7.405427e-006f,  5.187548e-005f,  8.087830e-005f,  6.916493e-005f,  4.150064e-005f,  2.291118e-005f,  2.916776e-005f,  5.779725e-005f,
    7.622814e-005f,  5.382966e-005f,  1.632936e-005f,  1.574580e-005f,  4.955295e-005f,  6.125314e-005f,  3.220575e-005f,  9.662830e-006f,
    2.827673e-005f,  5.615185e-005f,  5.134831e-005f,  2.512928e-005f,  1.594731e-005f,  2.912805e-005f,  3.963655e-005f,  3.470533e-005f,
    2.509347e-005f,  2.158684e-005f,  2.419769e-005f,  2.866328e-005f,  3.036521e-005f,  2.551747e-005f,  1.837733e-005f,  1.892179e-005f,
    2.746768e-005f,  3.102199e-005f,  2.305893e-005f,  1.474582e-005f,  1.757795e-005f,  2.518733e-005f,  2.468327e-005f,  1.708807e-005f,
    1.391443e-005f,  1.814195e-005f,  2.162077e-005f,  1.925942e-005f,  1.527140e-005f,  1.452052e-005f,  1.617682e-005f,  1.722647e-005f,
    1.675475e-005f,  1.522115e-005f,  1.354735e-005f,  1.322173e-005f,  1.455622e-005f,  1.521738e-005f,  1.339946e-005f,  1.116024e-005f,
    1.154160e-005f,  1.351499e-005f,  1.353262e-005f,  1.123934e-005f,  9.857604e-006f,  1.085476e-005f,  1.197479e-005f,  1.121967e-005f,
    9.712189e-006f,  9.321166e-006f,  9.862654e-006f,  1.002262e-005f,  9.485752e-006f,  8.849303e-006f,  8.492855e-006f,  8.424584e-006f,
    8.555006e-006f,  8.542692e-006f,  8.045738e-006f,  7.390805e-006f,  7.280369e-006f,  7.638353e-006f,  7.615149e-006f,  6.947166e-006f,
    6.410841e-006f,  6.547537e-006f,  6.822263e-006f,  6.558324e-006f,  5.990616e-006f,  5.759556e-006f,  5.891691e-006f,  5.909418e-006f,
    5.640094e-006f,  5.344287e-006f,  5.210470e-006f,  5.161616e-006f,  5.091239e-006f,  4.970725e-006f,  4.786696e-006f,  4.582377e-006f,
    4.477398e-006f,  4.482240e-006f,  4.424084e-006f,  4.206935e-006f,  3.993924e-006f,  3.954365e-006f,  3.984084e-006f,  3.878530e-006f,
    3.663759e-006f,  3.532347e-006f,  3.526171e-006f,  3.498777e-006f,  3.370009e-006f,  3.225159e-006f,  3.148343e-006f,  3.108584e-006f,
    3.045521e-006f,  2.956558e-006f,  2.865844e-006f,  2.783352e-006f,  2.717583e-006f,  2.670936e-006f,  2.616589e-006f,  2.530178e-006f,
    2.439343e-006f,  2.388012e-006f,  2.361516e-006f,  2.305915e-006f,  2.216594e-006f,  2.144885e-006f,  2.112836e-006f,  2.081480e-006f,
    2.018921e-006f,  1.947117e-006f,  1.898266e-006f,  1.865633e-006f,  1.824196e-006f,  1.770952e-006f,  1.720108e-006f,  1.677246e-006f,
    1.638170e-006f,  1.600312e-006f,  1.561592e-006f,  1.518557e-006f,  1.474587e-006f,  1.438740e-006f,  1.410299e-006f,  1.377070e-006f,
    1.335054e-006f,  1.296085e-006f,  1.268497e-006f,  1.243492e-006f,  1.210237e-006f,  1.173069e-006f,  1.142734e-006f,  1.118987e-006f,
    1.093195e-006f,  1.062913e-006f,  1.033553e-006f,  1.008252e-006f,  9.845988e-007f,  9.603019e-007f,  9.357433e-007f,  9.114549e-007f,
    8.876626e-007f,  8.655002e-007f,  8.452348e-007f,  8.246715e-007f,  8.023816e-007f,  7.806325e-007f,  7.619528e-007f,  7.447433e-007f,
    7.258093e-007f,  7.056207e-007f,  6.873180e-007f,  6.714704e-007f,  6.555218e-007f,  6.381944e-007f,  6.211174e-007f, -1.509805e-005f,
    1.607571e-006f, -6.566481e-006f, -7.045423e-006f,  1.455315e-004f,  1.868897e-004f, -1.906842e-004f, -4.344992e-004f, -6.402090e-005f,
    6.006674e-005f, -4.960845e-004f, -2.219219e-004f,  1.106323e-003f,  4.894059e-004f, -2.661464e-003f, -3.082099e-003f,  1.955261e-003f,
    5.807085e-003f,  2.141228e-003f, -3.871325e-003f, -3.727689e-003f,  3.800137e-004f,  4.473505e-004f, -3.458608e-003f, -5.129360e-003f,
   -3.303820e-003f, -8.328623e-004f,  1.988226e-003f,  4.588347e-003f,  3.190076e-003f, -1.755041e-003f, -3.169133e-003f,  1.371564e-003f,
    5.496553e-003f,  5.899542e-003f,  6.695929e-003f,  8.227119e-003f,  5.155980e-003f, -9.544823e-004f, -1.833982e-003f,  2.233049e-003f,
    2.559105e-003f, -1.421773e-003f, -1.772187e-003f,  1.818530e-003f,  1.972010e-003f, -8.153630e-004f,  1.953225e-004f,  3.754193e-003f,
    2.974761e-003f, -1.632105e-003f, -4.149050e-003f, -3.961608e-003f, -3.950135e-003f, -3.207250e-003f, -2.198924e-004f,  2.275948e-003f,
    2.051204e-003f,  1.205320e-003f,  1.446697e-003f,  1.712983e-003f,  1.668902e-003f,  1.123450e-003f, -2.352546e-003f, -8.132667e-003f,
   -9.338610e-003f, -3.273041e-003f,  1.348213e-003f, -2.858828e-003f, -9.445571e-003f, -8.748636e-003f, -3.065946e-003f, -3.836155e-004f,
   -6.563899e-004f,  9.283351e-004f,  3.834309e-003f,  4.894649e-003f,  5.139445e-003f,  6.282389e-003f,  6.057264e-003f,  2.791426e-003f,
   -6.623591e-004f, -1.307544e-003f,  4.520637e-004f,  3.024431e-003f,  4.827567e-003f,  4.147090e-003f,  2.167237e-003f,  2.998193e-003f,
    6.385101e-003f,  6.080604e-003f,  5.831196e-004f, -2.155733e-003f,  2.622343e-003f,  7.437741e-003f,  4.306732e-003f, -2.162524e-003f,
   -2.526523e-003f,  2.643065e-003f,  4.868401e-003f,  1.076615e-003f, -3.316891e-003f, -3.343549e-003f, -4.070857e-004f,  1.280567e-003f,
    4.745485e-004f, -7.875420e-004f, -1.282580e-003f, -2.144789e-003f, -3.540019e-003f, -3.314238e-003f, -1.305289e-003f, -7.544894e-004f,
   -2.062888e-003f, -6.950062e-004f,  4.221214e-003f,  6.226195e-003f,  2.165880e-003f, -1.801158e-003f, -1.478576e-003f, -2.021040e-003f,
   -6.192330e-003f, -6.711769e-003f, -2.828155e-005f,  4.321360e-003f, -7.049602e-004f, -6.721164e-003f, -4.524694e-003f,  2.719594e-004f,
   -1.145690e-003f, -4.983347e-003f, -3.716380e-003f, -4.098444e-004f, -1.305297e-003f, -3.231590e-003f, -5.209873e-004f,  3.424149e-003f,
    2.450474e-003f, -1.234246e-003f, -1.807102e-003f,  1.240102e-004f,  3.181548e-004f, -1.139179e-003f, -1.339203e-003f, -1.217009e-004f,
    9.115720e-004f,  1.791716e-003f,  2.983197e-003f,  3.394845e-003f,  2.098844e-003f,  1.334210e-004f, -8.539645e-004f, -4.186483e-004f,
    7.763217e-004f,  1.815607e-003f,  2.098090e-003f,  1.684749e-003f,  1.256702e-003f,  1.664407e-003f,  3.179209e-003f,  4.657543e-003f,
    4.237203e-003f,  2.138482e-003f,  1.304901e-003f,  2.981983e-003f,  3.859543e-003f,  1.220981e-003f, -1.710193e-003f, -5.690227e-004f,
    2.712530e-003f,  3.397197e-003f,  2.192132e-003f,  2.747559e-003f,  3.317020e-003f, -5.316790e-004f, -6.112780e-003f, -5.746090e-003f,
    7.920827e-004f,  4.746407e-003f,  1.398726e-003f, -3.294796e-003f, -2.658673e-003f,  7.905767e-004f,  7.283930e-004f, -2.272986e-003f,
   -2.236989e-003f,  1.719587e-003f,  3.715751e-003f,  1.098816e-003f, -9.933939e-004f,  1.386231e-003f,  3.979900e-003f,  1.746652e-003f,
   -2.387641e-003f, -2.842463e-003f, -5.530880e-004f,  2.548681e-004f, -6.766231e-005f,  8.844637e-004f,  1.647905e-003f,  4.140218e-004f,
   -1.927116e-004f,  1.781807e-003f,  2.963398e-003f,  7.896106e-004f, -1.612844e-003f, -1.559665e-003f, -1.104707e-003f, -1.364205e-003f,
   -2.310657e-004f,  1.438894e-003f,  2.332901e-005f, -2.756800e-003f, -1.543251e-003f,  2.138117e-003f,  1.542746e-003f, -3.158401e-003f,
   -5.232078e-003f, -3.067640e-003f, -1.040362e-003f, -6.898284e-004f, -8.044196e-004f, -2.647052e-003f, -6.018781e-003f, -5.646972e-003f,
    3.717340e-005f,  3.837807e-003f,  1.260095e-003f, -1.909048e-003f, -4.130152e-004f,  2.354115e-003f,  2.927639e-003f,  3.345407e-003f,
    3.916198e-003f,  2.176340e-003f,  7.354117e-004f,  3.306651e-003f,  4.335017e-003f, -2.443871e-003f, -9.065932e-003f, -4.458584e-003f,
    5.054543e-003f,  5.962170e-003f,  1.539126e-003f,  3.975699e-003f,  9.614280e-003f,  5.441768e-003f, -5.549175e-003f, -8.711220e-003f,
   -2.751444e-003f,  1.009631e-003f, -2.667619e-004f, -8.192214e-005f,  1.949737e-003f,  1.154750e-003f, -5.819967e-004f,  1.165906e-003f,
    3.402706e-003f,  1.740895e-003f, -4.720153e-004f,  8.758679e-004f,  2.344287e-003f,  2.986062e-004f, -1.403746e-003f,  1.439652e-003f,
    5.948519e-003f,  7.696302e-003f,  6.994017e-003f,  5.642480e-003f,  3.479160e-003f,  7.744391e-004f, -8.833716e-004f, -1.200694e-003f,
   -1.077894e-003f, -6.653459e-004f, -2.551617e-004f, -8.632995e-004f, -1.835625e-003f, -1.053499e-003f,  1.132602e-003f,  1.987516e-003f,
    1.078486e-003f,  8.369217e-004f,  2.349709e-003f,  4.359690e-003f,  5.861153e-003f,  6.468239e-003f,  5.492604e-003f,  3.133246e-003f,
    8.186654e-004f, -8.351978e-004f, -1.951153e-003f, -1.578679e-003f,  4.887614e-004f,  1.372735e-003f, -1.065884e-003f, -3.974959e-003f,
   -3.544708e-003f, -6.606415e-004f,  1.566542e-003f,  2.369983e-003f,  1.929243e-003f, -1.398383e-004f, -2.263093e-003f, -2.074686e-003f,
   -1.274413e-003f, -3.002065e-003f, -4.781422e-003f, -2.004434e-003f,  2.795868e-003f,  3.080853e-003f, -9.710490e-004f, -3.525979e-003f,
   -2.134925e-003f,  1.811341e-003f,  6.672883e-003f,  8.169984e-003f,  1.628715e-003f, -7.305764e-003f, -5.854903e-003f,  5.682142e-003f,
    1.185899e-002f,  7.088673e-003f,  4.127875e-003f,  8.759738e-003f,  7.587677e-003f, -6.169156e-003f, -1.628287e-002f, -9.139815e-003f,
    3.107123e-003f,  2.534713e-003f, -6.907541e-003f, -9.232500e-003f, -2.147535e-003f,  3.472754e-003f,  2.511919e-003f,  3.286038e-004f,
    1.777390e-003f,  5.009836e-003f,  5.950019e-003f,  4.144919e-003f,  2.817355e-003f,  3.608481e-003f,  3.375759e-003f, -6.733594e-004f,
   -4.948960e-003f, -4.359363e-003f, -1.057085e-003f, -1.034399e-003f, -4.296886e-003f, -6.291064e-003f, -6.160398e-003f, -5.717446e-003f,
   -4.305132e-003f, -2.091380e-003f, -2.609079e-003f, -5.149090e-003f, -2.811292e-003f,  5.084531e-003f,  9.030492e-003f,  4.796385e-003f,
    8.963320e-004f,  3.414360e-003f,  6.364756e-003f,  4.305967e-003f,  1.147278e-003f, -9.224422e-005f, -2.726697e-003f, -6.336317e-003f,
   -4.972186e-003f,  7.195854e-004f,  3.149960e-003f,  1.367794e-003f,  1.141279e-003f,  1.832018e-003f, -1.970088e-003f, -7.301442e-003f,
   -6.775198e-003f, -3.254218e-003f, -4.986966e-003f, -9.336377e-003f, -7.246918e-003f, -5.461066e-004f,  1.026988e-003f, -2.923259e-003f,
   -4.168652e-003f, -1.220344e-003f, -2.659916e-005f, -1.352314e-003f, -1.666012e-004f,  3.485275e-003f,  4.029621e-003f,  6.481766e-004f,
   -9.616006e-004f,  2.175608e-003f,  6.168824e-003f,  6.851535e-003f,  5.607481e-003f,  5.917689e-003f,  6.712986e-003f,  3.332166e-003f,
   -4.221834e-003f, -8.592658e-003f, -4.633304e-003f,  2.198166e-003f,  3.309533e-003f, -1.656512e-004f, -1.874120e-004f,  4.252783e-003f,
    5.621297e-003f,  6.748473e-004f, -4.467249e-003f, -4.171186e-003f, -6.425481e-004f,  9.663433e-004f, -8.935116e-004f, -4.171400e-003f,
   -5.575469e-003f, -2.716941e-003f,  2.573333e-003f,  4.361386e-003f, -2.122081e-004f, -5.966526e-003f, -6.065312e-003f, -1.098398e-003f,
    2.720295e-003f,  2.401010e-003f,  4.566672e-004f, -4.362653e-004f, -4.641999e-004f, -4.705313e-004f, -3.712743e-004f, -3.509001e-004f,
   -1.139637e-003f, -2.330304e-003f, -2.028507e-003f,  9.029644e-004f,  4.896487e-003f,  6.704580e-003f,  4.584752e-003f,  3.584157e-004f,
   -2.254423e-003f, -1.780024e-003f, -6.606430e-004f, -1.664951e-003f, -3.676719e-003f, -3.457097e-003f, -1.036463e-003f,  3.131478e-004f,
   -2.176279e-005f,  1.240494e-003f,  4.697216e-003f,  5.604802e-003f,  1.301182e-003f, -3.663634e-003f, -4.224691e-003f, -1.864193e-003f,
   -2.593489e-004f,  8.405647e-004f,  1.940105e-003f, -1.708011e-004f, -6.013620e-003f, -8.557759e-003f, -2.289507e-003f,  7.394187e-003f,
    1.103762e-002f,  7.248207e-003f,  1.519914e-003f, -2.630418e-003f, -4.852978e-003f, -4.186352e-003f, -3.226883e-004f,  3.740330e-003f,
    4.599169e-003f,  2.245916e-003f, -7.857136e-004f, -1.814838e-003f,  3.563623e-004f,  3.486482e-003f,  3.286348e-003f, -2.802614e-004f,
   -1.667627e-003f,  1.763144e-003f,  5.074488e-003f,  3.772318e-003f,  3.766879e-004f, -1.416527e-003f, -2.160225e-003f, -2.084707e-003f,
    8.507458e-004f,  4.435489e-003f,  2.847466e-003f, -2.569771e-003f, -3.373053e-003f,  1.727666e-003f,  4.104217e-003f,  4.270304e-004f,
   -1.701989e-003f,  1.992784e-003f,  4.995638e-003f,  2.577650e-003f,  2.062595e-004f,  2.623348e-003f,  4.702101e-003f,  8.472430e-004f,
   -4.436858e-003f, -3.495212e-003f,  2.068276e-003f,  3.821579e-003f, -7.912132e-004f, -5.290359e-003f, -4.311225e-003f, -7.729336e-004f,
    2.602235e-004f, -1.721006e-004f,  1.670252e-003f,  4.304759e-003f,  3.722090e-003f,  1.401220e-003f,  1.458406e-003f,  2.134027e-003f,
   -7.009217e-004f, -4.052310e-003f, -2.078772e-003f,  2.806220e-003f,  3.900083e-003f,  1.891973e-003f,  1.473826e-003f,  1.068796e-003f,
   -2.287891e-003f, -3.989929e-003f, -1.244396e-004f,  2.909901e-003f, -2.783364e-004f, -2.473274e-003f,  3.101937e-003f,  8.786235e-003f,
    5.453079e-003f, -1.675264e-003f, -3.701035e-003f, -2.741530e-003f, -3.386261e-003f, -2.125707e-003f,  3.121966e-003f,  5.939009e-003f,
    3.500664e-003f,  2.064413e-003f,  3.360448e-003f,  9.224896e-004f, -4.816142e-003f, -4.912682e-003f,  5.722064e-004f,  1.559740e-003f,
   -2.770401e-003f, -2.586387e-003f,  2.874819e-003f,  3.534562e-003f, -2.095381e-003f, -4.423905e-003f, -6.883423e-004f,  1.917670e-003f,
    8.865949e-004f,  4.997094e-004f,  7.970730e-004f, -1.445615e-003f, -3.538249e-003f, -1.150180e-003f,  2.332130e-003f,  1.523859e-003f,
   -1.252005e-003f, -1.356260e-003f, -5.736804e-004f, -2.197638e-003f, -3.967246e-003f, -2.842985e-003f, -6.057995e-004f,  2.727507e-004f,
    3.583636e-004f,  5.302889e-005f, -1.343125e-003f, -2.486803e-003f, -1.766922e-003f, -1.198831e-003f, -2.736423e-003f, -3.578768e-003f,
   -1.300320e-003f,  5.788018e-004f, -1.228359e-003f, -3.054146e-003f, -7.972002e-004f,  2.170098e-003f,  1.148277e-003f, -9.956456e-004f,
    7.781351e-004f,  3.660771e-003f,  1.136657e-003f, -5.167617e-003f, -6.468377e-003f,  1.227393e-004f,  7.038169e-003f,  7.007575e-003f,
    2.309903e-003f, -6.158710e-004f, -9.905613e-004f, -2.408138e-003f, -4.747645e-003f, -4.266496e-003f, -7.561213e-004f,  2.138034e-003f,
    3.388142e-003f,  4.696341e-003f,  4.749275e-003f,  8.463137e-004f, -4.083219e-003f, -4.073179e-003f,  2.485497e-004f,  2.453203e-003f,
    5.991238e-004f, -9.733349e-004f,  1.261446e-004f,  1.558927e-003f,  1.410237e-003f,  1.695358e-004f, -1.391405e-003f, -1.931514e-003f,
    2.508825e-004f,  3.448985e-003f,  3.341309e-003f,  9.503464e-005f, -1.284374e-003f,  2.551494e-004f,  1.105969e-004f, -2.865005e-003f,
   -3.818069e-003f, -6.822326e-004f,  2.544818e-003f,  3.118369e-003f,  2.661839e-003f,  2.092810e-003f,  4.181781e-004f, -1.360930e-003f,
   -1.249640e-003f, -2.121684e-004f, -2.118212e-004f, -6.296840e-004f, -5.585316e-004f, -1.031814e-003f, -1.858543e-003f, -8.140285e-004f,
    1.763694e-003f,  2.681863e-003f,  1.399606e-003f,  5.141621e-004f,  7.520702e-004f,  7.472424e-004f,  6.260440e-004f,  1.022030e-003f,
    9.336262e-004f,  2.991027e-004f,  7.539773e-004f,  1.478255e-003f,  4.741412e-005f, -1.770490e-003f, -6.810126e-004f,  6.417138e-004f,
   -1.784576e-003f, -4.078683e-003f, -1.442275e-003f,  9.161265e-004f, -2.605201e-003f, -4.957216e-003f,  9.174353e-004f,  5.850844e-003f,
   -3.859076e-004f, -8.344176e-003f, -4.458961e-003f,  3.808708e-003f,  1.344606e-003f, -7.067257e-003f, -6.489742e-003f,  1.030593e-003f,
    2.674979e-003f, -1.139728e-003f, -1.080871e-003f,  1.733203e-003f,  6.324135e-004f, -1.337119e-003f,  1.610291e-003f,  5.166264e-003f,
    3.532561e-003f,  5.522931e-004f,  5.684472e-004f, -2.206992e-004f, -3.742216e-003f, -4.097417e-003f,  4.723180e-004f,  2.790268e-003f,
    1.157598e-004f, -1.002243e-003f,  2.081647e-003f,  3.398628e-003f,  5.515874e-004f, -1.029022e-003f,  1.088671e-003f,  2.465342e-003f,
    6.651262e-004f, -1.305518e-003f, -1.152189e-003f,  2.246073e-004f,  1.595939e-003f,  1.836549e-003f,  6.351803e-005f, -1.659077e-003f,
   -1.160707e-004f,  3.089237e-003f,  3.283506e-003f,  7.181187e-004f, -2.832934e-004f,  5.755764e-004f,  2.802717e-004f, -3.153801e-004f,
    1.355211e-003f,  2.545438e-003f, -5.981746e-004f, -4.485424e-003f, -3.016614e-003f,  1.714676e-003f,  2.879398e-003f,  3.986096e-004f,
   -1.449675e-004f,  1.996137e-003f,  2.087967e-003f, -1.059104e-003f, -3.008782e-003f, -1.114021e-003f,  1.653128e-003f,  1.519105e-003f,
   -1.057645e-003f, -2.707331e-003f, -1.733544e-003f,  2.375612e-004f,  1.032059e-003f,  8.436876e-004f,  1.187732e-003f,  2.054248e-003f,
    2.120514e-003f,  1.253588e-003f,  7.187053e-004f,  1.137508e-003f,  1.842357e-003f,  1.917771e-003f,  1.011149e-003f, -1.671514e-004f,
   -2.090716e-004f,  7.676395e-004f,  4.007282e-004f, -2.107369e-003f, -3.608066e-003f, -1.865104e-003f,  1.386124e-004f, -7.565047e-004f,
   -2.124126e-003f, -6.579980e-004f,  1.485998e-003f,  1.205849e-003f,  6.494284e-004f,  2.191637e-003f,  2.540663e-003f, -7.536148e-004f,
   -2.754737e-003f,  6.566219e-004f,  3.957901e-003f,  4.416930e-004f, -5.818816e-003f, -5.944396e-003f, -3.071968e-005f,  4.153177e-003f,
    3.298427e-003f,  1.203693e-003f,  1.020653e-003f,  1.589305e-003f,  9.807853e-004f, -7.985184e-004f, -2.521578e-003f, -2.990916e-003f,
   -2.076739e-003f, -9.989005e-004f, -6.970154e-004f, -7.557279e-004f, -1.068856e-003f, -2.478490e-003f, -4.259451e-003f, -3.972140e-003f,
   -1.611140e-003f, -2.654667e-004f, -8.189065e-004f, -3.610798e-004f,  2.065675e-003f,  3.075738e-003f,  8.610082e-004f, -1.383092e-003f,
   -7.672810e-004f,  1.080987e-003f,  1.782902e-003f,  1.871977e-003f,  2.153156e-003f,  1.500931e-003f, -1.623989e-004f, -3.732981e-004f,
    1.934515e-003f,  4.187681e-003f,  4.085446e-003f,  2.898956e-003f,  2.785139e-003f,  3.404937e-003f,  3.366649e-003f,  2.868932e-003f,
    2.785438e-003f,  2.877904e-003f,  2.812115e-003f,  3.183189e-003f,  3.629480e-003f,  1.994343e-003f, -2.145160e-003f, -5.145709e-003f,
   -3.666366e-003f,  2.750095e-004f,  2.132726e-003f,  1.268225e-003f,  6.521285e-004f,  1.411148e-003f,  2.003956e-003f,  1.951306e-003f,
    2.005226e-003f,  1.354483e-003f, -9.595377e-004f, -2.637916e-003f, -6.356646e-004f,  3.530743e-003f,  5.244149e-003f,  3.004547e-003f,
   -5.437492e-004f, -2.886886e-003f, -3.453140e-003f, -2.256318e-003f,  3.371836e-005f,  1.582906e-003f,  1.282136e-003f,  2.187619e-005f,
   -1.102962e-003f, -1.915737e-003f, -1.936539e-003f, -6.916465e-004f,  5.821297e-004f,  5.072420e-004f,  3.291527e-004f,  1.671378e-003f,
    2.728374e-003f,  9.236081e-004f, -1.992280e-003f, -2.243117e-003f, -1.864475e-004f,  6.879386e-004f, -1.858849e-004f, -1.828942e-004f,
    1.517964e-003f,  2.974231e-003f,  2.967619e-003f,  2.027181e-003f,  6.668530e-004f, -7.566269e-004f, -1.397423e-003f, -1.119175e-003f,
   -1.085341e-003f, -1.721090e-003f, -1.697831e-003f, -2.281569e-004f,  1.229806e-003f,  8.070609e-004f, -1.324808e-003f, -3.168683e-003f,
   -2.958710e-003f, -7.474856e-004f,  1.668754e-003f,  2.471938e-003f,  1.590372e-003f,  5.279282e-004f,  6.771739e-004f,  2.139871e-003f,
    3.671731e-003f,  3.548905e-003f,  1.414348e-003f, -7.040209e-004f, -5.638302e-004f,  1.371030e-003f,  2.935036e-003f,  3.447474e-003f,
    3.536855e-003f,  2.839617e-003f,  8.520521e-004f, -8.938540e-004f, -5.233053e-004f,  1.286488e-003f,  2.564242e-003f,  2.667260e-003f,
    1.775432e-003f,  1.467962e-004f, -7.203605e-004f,  6.594975e-004f,  2.622058e-003f,  2.441159e-003f,  1.259567e-003f,  1.792018e-003f,
    2.434904e-003f,  3.019351e-004f, -1.948987e-003f, -3.822024e-004f,  1.853812e-003f, -2.485246e-004f, -3.404764e-003f, -1.702552e-003f,
    1.747589e-003f,  8.420920e-004f, -5.660360e-004f,  4.487989e-003f,  1.079333e-002f,  7.777685e-003f, -1.740842e-003f, -5.211525e-003f,
   -5.241119e-004f,  2.658015e-003f,  3.465327e-004f, -1.493428e-003f,  1.654467e-004f,  1.197575e-003f, -4.114939e-004f, -1.569573e-003f,
   -7.606655e-004f,  2.815574e-004f,  9.442032e-004f,  1.607809e-003f,  1.088878e-003f, -7.695915e-004f, -1.009274e-003f,  1.561243e-003f,
    3.178109e-003f,  8.781037e-004f, -2.554804e-003f, -3.208308e-003f, -1.777938e-003f, -1.093479e-003f, -1.233249e-003f, -5.671550e-004f,
    5.886579e-004f,  3.894656e-004f, -1.356836e-003f, -2.487279e-003f, -1.272109e-003f,  8.941219e-004f,  7.237613e-004f, -2.528839e-003f,
   -5.351319e-003f, -4.278816e-003f, -4.768973e-004f,  2.114758e-003f,  1.842222e-003f,  1.521175e-004f, -1.383715e-003f, -2.427664e-003f,
   -3.125892e-003f, -3.739558e-003f, -4.206879e-003f, -3.458005e-003f, -7.637729e-004f,  2.177822e-003f,  2.887014e-003f,  1.744096e-003f,
    1.184927e-003f,  1.551654e-003f,  9.946252e-004f, -7.116016e-004f, -1.730563e-003f, -1.589650e-003f, -1.728823e-003f, -2.372997e-003f,
   -1.917068e-003f, -4.332820e-005f,  1.123999e-003f,  7.485851e-005f, -1.602719e-003f, -1.272941e-003f,  8.959854e-004f,  1.896267e-003f,
    1.879166e-004f, -1.897068e-003f, -1.790667e-003f, -7.656555e-004f, -1.426630e-003f, -2.925362e-003f, -2.631984e-003f, -1.011180e-003f,
   -2.473006e-004f,  3.429042e-004f,  2.325063e-003f,  3.518212e-003f,  1.333629e-003f, -1.357301e-003f, -4.018813e-004f,  1.793002e-003f,
    3.291027e-005f, -4.158722e-003f, -4.831644e-003f, -1.663994e-003f,  4.528408e-004f,  3.778319e-004f,  1.047584e-003f,  2.125594e-003f,
    6.027511e-004f, -2.014713e-003f, -1.111843e-003f,  2.616142e-003f,  3.537185e-003f,  1.964397e-004f, -2.567672e-003f, -1.434681e-003f,
    1.138289e-003f,  1.708918e-003f,  3.959284e-004f, -8.329629e-004f, -1.167939e-003f, -8.717264e-004f, -3.075300e-004f, -3.219990e-005f,
   -4.569008e-004f, -9.071064e-004f, -2.611793e-004f,  1.096952e-003f,  1.321749e-003f, -1.613751e-004f, -1.303796e-003f, -1.250873e-004f,
    2.324231e-003f,  3.480679e-003f,  2.933498e-003f,  2.362160e-003f,  2.385766e-003f,  2.118013e-003f,  1.666282e-003f,  2.216602e-003f,
    3.438891e-003f,  3.535599e-003f,  2.159825e-003f,  7.748281e-004f,  3.061064e-005f, -6.900877e-004f, -1.124496e-003f, -1.142498e-004f,
    2.052702e-003f,  3.498972e-003f,  3.256483e-003f,  2.255949e-003f,  1.638092e-003f,  1.293709e-003f,  3.636347e-004f, -1.328119e-003f,
   -2.649815e-003f, -2.322838e-003f, -6.204459e-004f,  1.068453e-003f,  2.270403e-003f,  3.312672e-003f,  3.378687e-003f,  1.355003e-003f,
   -1.314607e-003f, -1.875788e-003f, -5.831564e-004f, -2.491623e-004f, -1.436083e-003f, -1.913876e-003f, -7.498976e-004f,  9.027911e-004f,
    2.440135e-003f,  3.492897e-003f,  2.500032e-003f, -5.940827e-004f, -2.543070e-003f, -1.417289e-003f,  2.404607e-004f,  3.268089e-004f,
    6.655515e-004f,  2.081378e-003f,  1.777990e-003f, -6.211009e-004f, -1.011698e-003f,  1.516458e-003f,  2.259903e-003f, -4.002976e-004f,
   -1.920461e-003f, -3.823648e-004f,  2.492855e-004f, -1.533084e-003f, -2.140250e-003f, -8.193622e-004f, -1.015777e-003f, -2.358823e-003f,
   -8.301653e-004f,  2.362386e-003f,  1.927964e-003f, -1.407671e-003f, -1.902660e-003f,  5.624496e-004f,  7.504330e-004f, -1.875372e-003f,
   -2.907928e-003f, -1.675090e-003f, -1.359201e-003f, -1.944997e-003f, -8.466440e-004f,  1.333885e-003f,  2.143177e-003f,  1.787116e-003f,
    1.321772e-003f,  2.442137e-006f, -1.686091e-003f, -1.057045e-003f,  1.610790e-003f,  2.267708e-003f, -2.667472e-004f, -2.606445e-003f,
   -3.037157e-003f, -3.216825e-003f, -3.158895e-003f, -1.184095e-003f,  1.109361e-003f,  4.670340e-004f, -1.973730e-003f, -2.525840e-003f,
   -1.365978e-003f, -9.815904e-004f, -6.374106e-004f,  1.267083e-003f,  2.256670e-003f, -2.661121e-004f, -3.176330e-003f, -2.194095e-003f,
    7.511009e-004f,  9.940908e-004f, -1.012786e-003f, -1.483805e-003f, -3.130508e-004f, -3.472407e-004f, -1.623000e-003f, -1.767879e-003f,
   -8.193815e-004f, -9.087104e-004f, -1.976221e-003f, -1.847871e-003f, -1.825115e-004f,  1.015094e-003f,  7.373597e-004f,  7.525837e-005f,
   -1.319121e-004f, -3.829410e-004f, -8.767029e-004f, -8.171235e-004f, -2.123782e-005f,  3.985591e-004f, -2.735451e-004f, -1.258921e-003f,
   -1.523106e-003f, -9.816908e-004f, -6.891580e-005f,  6.983812e-004f,  5.928453e-004f, -4.934144e-004f, -1.265019e-003f, -7.380191e-004f,
   -1.394557e-004f, -9.360473e-004f, -1.954646e-003f, -1.296445e-003f,  6.825068e-005f,  8.186500e-005f, -3.358924e-004f,  9.053634e-004f,
    2.452795e-003f,  1.314985e-003f, -1.667934e-003f, -2.871832e-003f, -1.666985e-003f, -5.997529e-004f, -5.408330e-004f, -7.714446e-005f,
    8.534613e-004f,  7.949919e-004f, -1.446088e-004f, -3.346876e-004f,  7.012684e-004f,  1.993505e-003f,  2.667547e-003f,  2.234677e-003f,
    6.743075e-004f, -8.374425e-004f, -9.604767e-004f, -2.701156e-004f, -3.353982e-004f, -1.030495e-003f, -1.064276e-003f, -4.455753e-004f,
    1.164121e-005f,  5.044556e-004f,  1.203394e-003f,  1.025726e-003f, -2.828114e-004f, -9.137002e-004f,  1.251728e-005f,  6.967047e-004f,
   -6.671713e-005f, -6.469748e-004f,  3.870742e-004f,  1.730378e-003f,  1.682959e-003f,  6.341653e-004f, -1.149353e-004f, -5.513219e-006f,
    8.402306e-004f,  1.614270e-003f,  1.095478e-003f, -5.579347e-004f, -1.505913e-003f, -1.067807e-003f, -7.820865e-004f, -1.359147e-003f,
   -1.440499e-003f, -6.848817e-004f, -6.782850e-004f, -1.507244e-003f, -1.186969e-003f,  3.691249e-004f,  7.866703e-004f, -4.666087e-004f,
   -1.271798e-003f, -9.066853e-004f, -8.000149e-004f, -1.055262e-003f, -3.444497e-004f,  8.292621e-004f,  7.463554e-004f, -8.368582e-005f,
    1.492633e-004f,  9.708457e-004f,  5.240272e-004f, -9.371256e-004f, -1.660623e-003f, -1.358491e-003f, -8.825970e-004f, -3.333031e-004f,
    3.550074e-004f,  5.486592e-004f,  2.090622e-004f,  1.998987e-004f,  3.780599e-004f, -3.053107e-004f, -1.276292e-003f, -7.270895e-004f,
    9.874634e-004f,  1.379905e-003f, -1.844933e-004f, -1.525063e-003f, -1.249089e-003f, -4.427422e-004f, -1.394578e-004f,  1.737088e-004f,
    7.464490e-004f,  6.915025e-004f, -1.771482e-004f, -6.579578e-004f, -1.894711e-004f,  1.969860e-004f, -2.112707e-004f, -6.523622e-004f,
   -6.348307e-004f, -1.138639e-003f, -2.729553e-003f, -3.999245e-003f, -3.494466e-003f, -1.879270e-003f, -5.538212e-004f,  4.099369e-004f,
    1.206672e-003f,  9.812044e-004f, -3.425291e-004f, -9.278475e-004f,  3.884728e-005f,  6.713869e-004f, -5.960311e-005f, -2.474179e-004f,
    8.193324e-004f,  4.156426e-004f, -2.382899e-003f, -3.678702e-003f, -9.802016e-004f,  2.166924e-003f,  2.100803e-003f,  7.586168e-004f,
    9.495704e-004f,  9.925407e-004f, -1.090819e-003f, -2.876156e-003f, -1.723212e-003f,  7.176232e-004f,  1.917074e-003f,  1.944620e-003f,
    1.007898e-003f, -1.352889e-003f, -2.905731e-003f, -4.791580e-004f,  3.713951e-003f,  4.032985e-003f,  5.075725e-004f, -1.112274e-003f,
    9.605695e-004f,  2.391474e-003f,  1.135805e-003f,  4.145601e-004f,  1.876540e-003f,  2.663432e-003f,  1.006655e-003f, -8.567754e-004f,
   -7.946670e-004f,  5.315190e-004f,  1.872012e-003f,  2.890774e-003f,  3.181668e-003f,  2.281726e-003f,  6.489743e-004f, -7.467984e-004f,
   -1.295463e-003f, -8.082681e-004f,  2.411075e-004f,  7.741352e-004f,  6.253704e-004f,  1.048775e-003f,  2.381948e-003f,  2.841759e-003f,
    1.194333e-003f, -1.194467e-003f, -2.289449e-003f, -1.530125e-003f,  4.982669e-004f,  2.419204e-003f,  2.372493e-003f,  3.759197e-004f,
   -8.042430e-004f,  2.430349e-004f,  9.651161e-004f, -5.364401e-004f, -1.682281e-003f, -7.114391e-005f,  1.900329e-003f,  1.293536e-003f,
   -5.077274e-004f, -1.143435e-003f, -1.123468e-003f, -8.999658e-004f,  9.619117e-004f,  3.691053e-003f,  3.720423e-003f,  6.154209e-004f,
   -1.858922e-003f, -1.939687e-003f, -1.291950e-003f, -1.220941e-004f,  2.495107e-003f,  4.073288e-003f,  1.732935e-003f, -1.451535e-003f,
   -5.564197e-004f,  2.613028e-003f,  2.613660e-003f, -3.650458e-004f, -1.839914e-003f, -9.672667e-004f, -1.782084e-004f,  4.715870e-005f,
    5.878739e-005f, -1.420956e-003f, -3.613418e-003f, -2.550782e-003f,  1.984948e-003f,  4.413114e-003f,  2.166182e-003f, -3.318583e-004f,
   -5.153352e-005f, -3.148351e-005f, -2.080671e-003f, -2.795876e-003f, -6.094648e-004f,  7.753296e-004f, -5.843516e-004f, -1.459282e-003f,
    1.546002e-004f,  1.836999e-003f,  1.995247e-003f,  2.065751e-003f,  2.135844e-003f,  4.137471e-004f, -2.095853e-003f, -2.196468e-003f,
   -2.586027e-004f,  1.480728e-004f, -1.414264e-003f, -1.666797e-003f,  3.119284e-004f,  1.490902e-003f,  1.613462e-004f, -1.403824e-003f,
   -5.972155e-004f,  2.301530e-003f,  5.225625e-003f,  6.253490e-003f,  4.314785e-003f,  3.001628e-004f, -2.571685e-003f, -1.941525e-003f,
    1.705236e-004f, -1.524751e-004f, -2.535496e-003f, -2.275691e-003f,  2.140314e-003f,  5.533291e-003f,  3.139953e-003f, -2.117878e-003f,
   -3.703093e-003f, -5.368303e-004f,  2.651920e-003f,  2.716888e-003f,  1.138943e-003f,  1.337341e-004f, -7.692903e-005f,  1.947419e-005f,
    2.103747e-005f, -8.161500e-004f, -2.392991e-003f, -2.828203e-003f, -8.036842e-004f,  2.182603e-003f,  3.695600e-003f,  3.241194e-003f,
    1.922034e-003f,  7.635765e-004f,  4.443754e-004f,  1.131835e-003f,  1.888356e-003f,  1.532320e-003f,  1.019980e-004f, -1.544084e-003f,
   -2.707863e-003f, -2.629430e-003f, -1.033486e-003f,  5.808079e-004f,  7.525872e-004f,  1.017005e-003f,  3.263424e-003f,  4.949018e-003f,
    2.476367e-003f, -1.516053e-003f, -1.261964e-003f,  2.428764e-003f,  3.714536e-003f,  2.241756e-003f,  2.679734e-003f,  4.194633e-003f,
    1.138114e-003f, -5.130947e-003f, -6.180037e-003f,  3.414152e-005f,  5.821080e-003f,  5.604834e-003f,  1.881203e-003f, -1.602245e-003f,
   -3.706814e-003f, -2.711261e-003f,  1.980858e-003f,  5.248623e-003f,  1.890795e-003f, -4.099697e-003f, -4.460895e-003f,  5.098865e-004f,
    2.946896e-003f,  1.981777e-004f, -2.264806e-003f, -6.490062e-004f,  2.365211e-003f,  3.339510e-003f,  2.350967e-003f,  8.114856e-004f,
   -3.854891e-004f, -3.188993e-004f,  9.517827e-004f,  1.313389e-003f, -6.753483e-004f, -2.935670e-003f, -2.367050e-003f,  6.571908e-004f,
    2.749360e-003f,  2.185175e-003f,  1.063454e-003f,  2.149425e-003f,  4.709949e-003f,  5.018648e-003f,  1.372306e-003f, -3.082548e-003f,
   -4.260606e-003f, -2.492580e-003f, -1.222100e-003f, -1.265557e-003f, -7.508318e-005f,  3.091295e-003f,  5.153405e-003f,  3.726576e-003f,
    5.311696e-004f, -1.468388e-003f, -1.868607e-003f, -1.864186e-003f, -1.482943e-003f, -1.018193e-004f,  1.389680e-003f,  1.336645e-003f,
    2.304475e-005f, -5.010261e-004f,  3.938857e-004f,  1.003488e-003f,  4.011847e-004f,  2.128938e-004f,  1.612750e-003f,  2.660720e-003f,
    1.134739e-003f, -1.582734e-003f, -2.333955e-003f, -7.888043e-004f,  6.903731e-004f,  9.044092e-004f,  6.437462e-004f,  3.656129e-004f,
   -1.739097e-004f, -5.075372e-004f, -1.161981e-004f,  1.317803e-004f, -6.588576e-004f, -1.501693e-003f, -1.085071e-003f, -2.526104e-004f,
   -6.863507e-004f, -1.792882e-003f, -1.246099e-003f,  1.172911e-003f,  2.244698e-003f, -7.303258e-004f, -5.344815e-003f, -5.926297e-003f,
   -1.197638e-003f,  2.792060e-003f,  7.964137e-004f, -3.359644e-003f, -2.391819e-003f,  2.555479e-003f,  3.668659e-003f, -1.928801e-004f,
   -1.573915e-003f,  2.217376e-003f,  4.138038e-003f,  5.312458e-005f, -3.638224e-003f, -1.218460e-003f,  2.461944e-003f,  8.855055e-004f,
   -2.860031e-003f, -2.118439e-003f,  1.758398e-003f,  2.398300e-003f, -9.254814e-004f, -3.458189e-003f, -3.207968e-003f, -2.155998e-003f,
   -1.064163e-003f,  8.088488e-004f,  2.017864e-003f,  4.267456e-004f, -2.217202e-003f, -1.968388e-003f,  1.246034e-003f,  3.400077e-003f,
    2.312914e-003f,  5.890133e-005f, -1.001951e-003f, -1.148351e-003f, -1.332846e-003f, -1.221454e-003f, -4.127107e-004f,  6.008770e-004f,
    1.583748e-003f,  2.678790e-003f,  2.999761e-003f,  1.511144e-003f, -4.097910e-004f, -2.127488e-004f,  1.558895e-003f,  1.553404e-003f,
   -1.052241e-003f, -3.004952e-003f, -1.901645e-003f,  6.665930e-004f,  2.013667e-003f,  1.319003e-003f, -9.678346e-004f, -3.573134e-003f,
   -4.183771e-003f, -2.082495e-003f, -2.971294e-004f, -1.354304e-003f, -2.507610e-003f, -9.356925e-005f,  3.337638e-003f,  2.455522e-003f,
   -1.832237e-003f, -3.720053e-003f, -1.895939e-003f, -4.067218e-004f, -6.904822e-004f, -1.683051e-004f,  1.126066e-003f, -1.115621e-004f,
   -3.556566e-003f, -4.398413e-003f, -9.116794e-004f,  2.695780e-003f,  2.597098e-003f,  2.243125e-006f, -1.869049e-003f, -1.887711e-003f,
   -9.815713e-004f, -5.861799e-004f, -1.701472e-003f, -3.744652e-003f, -4.550588e-003f, -2.928538e-003f, -4.798567e-004f,  4.263739e-004f,
   -4.488694e-004f, -1.492898e-003f, -1.497304e-003f, -6.761674e-004f, -7.539616e-005f, -4.467340e-004f, -1.316007e-003f, -1.440387e-003f,
   -6.666678e-004f, -3.662515e-004f, -1.140281e-003f, -1.448352e-003f,  2.904840e-006f,  1.701509e-003f,  1.023266e-003f, -2.064888e-003f,
   -4.603977e-003f, -3.966992e-003f, -7.342495e-004f,  1.851614e-003f,  1.190362e-003f, -1.776879e-003f, -3.400534e-003f, -1.562102e-003f,
    1.709562e-003f,  2.864507e-003f,  1.235269e-003f, -6.487937e-004f, -6.217122e-004f,  8.729565e-004f,  2.034697e-003f,  1.807297e-003f,
    4.813818e-004f, -8.378531e-004f, -1.101969e-003f, -2.868927e-004f,  4.110894e-004f, -6.611075e-005f, -1.055892e-003f, -8.032290e-004f,
    9.212397e-004f,  1.874332e-003f,  2.353771e-004f, -2.339843e-003f, -2.662282e-003f, -8.658461e-004f, -4.387147e-004f, -2.542673e-003f,
   -3.744736e-003f, -1.654979e-003f,  6.320869e-004f, -6.136894e-004f, -3.327238e-003f, -2.789910e-003f,  6.734833e-004f,  2.378482e-003f,
    7.735400e-004f, -1.039128e-003f, -1.108986e-003f, -8.143429e-004f, -9.209982e-004f, -3.992003e-004f,  2.755728e-004f, -6.036290e-004f,
   -1.924048e-003f, -8.981776e-004f,  1.310945e-003f,  5.766070e-004f, -2.748263e-003f, -3.309997e-003f,  6.865627e-004f,  4.295914e-003f,
    3.534280e-003f,  7.231609e-004f, -5.620449e-004f, -7.098513e-004f, -1.274754e-003f, -1.554331e-003f, -8.348289e-004f, -1.758163e-004f,
    6.885098e-005f,  6.949168e-004f,  6.761719e-004f, -1.618355e-003f, -3.815618e-003f, -1.869928e-003f,  2.438537e-003f,  2.923721e-003f,
   -1.043273e-003f, -3.144971e-003f, -4.628678e-004f,  2.105304e-003f,  4.276430e-004f, -2.677233e-003f, -2.996746e-003f, -1.156877e-003f,
    4.571233e-004f,  1.437063e-003f,  1.854269e-003f,  1.210133e-003f,  2.607672e-004f,  4.681396e-004f,  1.268759e-003f,  1.027478e-003f,
    2.042485e-004f,  3.450061e-004f,  8.701875e-004f,  1.961800e-004f, -9.921934e-004f, -8.421334e-004f,  2.885610e-004f,  5.579790e-004f,
   -1.438388e-004f, -3.701255e-004f,  2.384828e-004f,  7.218238e-004f,  6.115543e-004f,  2.624271e-004f, -7.358706e-005f, -2.925223e-004f,
   -1.470932e-004f,  2.721944e-004f,  3.927930e-004f,  1.293085e-005f, -3.539473e-004f, -2.943179e-004f, -1.113683e-005f,  1.583857e-004f,
    1.691574e-004f,  1.030744e-004f,  1.856828e-005f,  2.796441e-006f,  8.672135e-005f,  1.587384e-004f,  1.296503e-004f,  5.814954e-005f,
    1.925219e-005f,  4.337701e-006f, -2.430778e-006f,  8.576608e-006f,  2.219731e-005f,  1.761441e-005f,  7.758649e-006f,  4.499797e-006f
};



static const float MPSVTReverbLeft[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  4.636661e-011f, -1.372819e-010f, -1.163384e-010f,  1.172137e-011f,  7.068104e-011f,  1.367739e-006f,
    8.425504e-006f, -2.943557e-005f, -1.463831e-005f,  9.667713e-005f,  7.341919e-005f, -1.195291e-004f, -1.249383e-004f,  7.604683e-005f,
    3.757403e-005f, -2.063733e-004f, -1.412246e-004f,  1.440008e-004f,  1.397362e-004f,  2.032166e-005f,  1.666961e-004f,  1.319545e-004f,
   -4.479543e-004f, -8.411949e-004f, -5.111468e-004f, -1.136920e-004f, -8.866730e-005f,  4.020893e-005f,  2.867997e-004f,  1.711617e-004f,
    7.885553e-005f,  3.939416e-004f,  2.809974e-004f, -2.271944e-004f,  6.461312e-004f,  2.434371e-003f,  1.617117e-003f, -1.925517e-003f,
   -3.241126e-003f, -7.073296e-004f,  1.031518e-003f,  1.588350e-004f,  7.635221e-004f,  3.273267e-003f,  2.665446e-003f, -4.675011e-004f,
    1.272756e-004f,  2.733023e-003f, -6.955770e-004f, -7.182286e-003f, -5.237103e-003f,  2.016058e-003f, -4.223125e-004f, -1.296614e-002f,
   -1.863503e-002f, -9.358687e-003f,  4.155934e-003f,  1.056752e-002f,  8.576609e-003f,  1.128781e-004f, -1.066988e-002f, -1.436750e-002f,
   -7.621493e-003f, -1.723219e-003f, -5.405213e-003f, -8.966189e-003f, -1.740558e-003f,  7.328071e-003f,  5.465210e-003f, -8.498860e-004f,
    7.895773e-004f,  5.282929e-003f,  1.631599e-003f, -4.164740e-003f, -1.165981e-004f,  8.465558e-003f,  8.453227e-003f,  2.412633e-003f,
    1.986527e-003f,  6.014868e-003f,  4.803872e-003f, -7.287344e-004f, -2.056748e-003f,  7.481331e-004f,  1.531095e-003f,  1.085854e-003f,
    3.668244e-003f,  6.078314e-003f,  2.983762e-003f, -1.995008e-003f, -1.879794e-003f,  1.754683e-003f,  2.382987e-003f, -4.967624e-004f,
   -2.581413e-003f, -2.651960e-003f, -2.108548e-003f, -9.430323e-004f,  2.391461e-004f, -8.827855e-004f, -3.079326e-003f, -1.407562e-003f,
    3.692541e-003f,  4.705086e-003f, -8.741408e-004f, -5.056467e-003f, -1.840908e-003f,  3.100676e-003f,  2.360584e-003f, -1.198842e-003f,
   -7.409066e-004f,  2.398961e-003f,  1.922539e-003f, -2.118186e-003f, -3.853831e-003f, -1.358813e-003f,  1.364159e-003f,  1.248340e-003f,
   -5.549255e-004f, -1.821814e-003f, -1.720620e-003f, -5.496836e-004f,  4.921528e-004f,  9.410820e-005f, -1.241694e-003f, -1.541430e-003f,
   -3.789368e-004f,  4.605091e-004f, -1.189842e-004f, -1.123997e-003f, -1.417036e-003f, -1.142139e-003f, -9.795967e-004f, -1.354564e-003f,
   -2.124668e-003f, -2.326878e-003f, -1.318531e-003f, -4.028938e-004f, -1.258505e-003f, -2.768015e-003f, -2.388278e-003f, -5.596442e-004f,
    1.872080e-005f, -6.669278e-004f, -2.453665e-004f,  8.889888e-004f, -1.069510e-004f, -2.801276e-003f, -3.491190e-003f, -1.498015e-003f,
   -1.418335e-004f, -7.852503e-004f, -1.104464e-003f, -3.630455e-005f,  4.975201e-004f, -3.224572e-004f, -7.494026e-004f,  1.582142e-004f,
    1.303595e-003f,  1.983116e-003f,  2.532951e-003f,  2.796104e-003f,  2.485655e-003f,  2.271747e-003f,  2.457513e-003f,  2.166606e-003f,
    1.636738e-003f,  2.724558e-003f,  5.007730e-003f,  4.706467e-003f,  3.696141e-004f, -3.796201e-003f, -3.793380e-003f, -1.745130e-003f,
   -1.892460e-003f, -3.756099e-003f, -4.054627e-003f, -2.935040e-003f, -2.891891e-003f, -3.126324e-003f, -7.908586e-004f,  2.777388e-003f,
    2.997158e-003f, -3.451960e-004f, -2.006156e-003f,  9.925187e-004f,  5.495678e-003f,  7.383076e-003f,  6.016506e-003f,  2.419540e-003f,
   -2.266599e-003f, -5.352416e-003f, -4.320154e-003f, -1.072166e-003f, -3.756762e-005f, -1.676875e-003f, -2.645640e-003f, -2.079615e-003f,
   -2.089885e-003f, -2.501195e-003f, -1.342193e-003f, -8.377879e-005f, -1.846533e-003f, -4.977178e-003f, -5.065286e-003f, -2.503203e-003f,
   -1.309109e-003f, -1.671971e-003f, -6.104196e-004f,  1.363838e-003f,  1.247466e-003f, -1.477720e-004f,  5.237119e-004f,  2.936647e-003f,
    3.980710e-003f,  3.151624e-003f,  2.111519e-003f,  1.068030e-003f, -2.532894e-004f, -6.734791e-004f,  1.300420e-004f,  4.402120e-004f,
   -1.801735e-004f, -6.035594e-005f,  8.396389e-004f,  6.539474e-004f, -4.051731e-004f, -4.196583e-004f,  1.269913e-004f, -5.708434e-004f,
   -1.531235e-003f, -9.148645e-004f, -2.303811e-004f, -1.547654e-003f, -2.892903e-003f, -1.444546e-003f,  1.309176e-003f,  2.168389e-003f,
    1.153217e-003f,  1.195644e-004f, -4.399529e-004f, -4.939076e-004f,  2.179293e-004f,  4.087769e-004f, -1.503237e-003f, -4.032157e-003f,
   -4.490592e-003f, -3.262473e-003f, -2.064117e-003f, -3.423704e-004f,  2.111088e-003f,  2.573517e-003f,  7.823596e-005f, -1.929115e-003f,
   -1.914973e-003f, -3.145180e-003f, -6.094030e-003f, -5.669889e-003f, -6.743930e-004f,  2.454161e-003f,  2.385195e-004f, -2.254186e-003f,
   -1.045443e-003f,  5.407920e-004f, -3.744771e-004f, -1.153649e-003f, -2.161011e-004f, -4.340813e-004f, -2.991658e-003f, -5.170043e-003f,
   -5.591883e-003f, -4.997519e-003f, -2.444004e-003f,  2.573046e-003f,  6.171884e-003f,  4.651542e-003f,  1.558378e-004f, -3.276888e-003f,
   -4.713781e-003f, -3.550958e-003f,  1.274421e-003f,  5.846078e-003f,  3.900837e-003f, -1.995910e-003f, -2.435355e-003f,  2.961128e-003f,
    4.138341e-003f, -1.719966e-003f, -4.896065e-003f,  1.002447e-004f,  6.026216e-003f,  6.117532e-003f,  3.263171e-003f,  1.262693e-003f,
   -1.559879e-003f, -5.575495e-003f, -6.564868e-003f, -2.821628e-003f,  2.110337e-003f,  5.254677e-003f,  6.444857e-003f,  5.582866e-003f,
    3.381540e-003f,  2.453399e-003f,  2.954989e-003f,  1.361383e-003f, -2.571236e-003f, -3.860758e-003f, -9.647085e-004f,  1.188296e-003f,
    2.264490e-004f, -1.169110e-004f,  1.555124e-003f,  1.566043e-003f, -5.963109e-004f, -8.498770e-004f,  9.937355e-004f,  1.074833e-003f,
    1.623677e-004f,  2.026835e-003f,  4.041170e-003f,  9.614504e-004f, -3.562280e-003f, -1.914536e-003f,  3.071347e-003f,  2.332403e-003f,
   -2.733856e-003f, -2.461442e-003f,  3.376877e-003f,  5.116458e-003f,  4.802184e-004f, -2.344483e-003f, -5.752423e-005f,  1.096199e-003f,
   -1.739797e-003f, -2.886576e-003f,  7.232697e-004f,  3.673981e-003f,  1.463699e-003f, -2.094883e-003f, -1.177104e-003f,  3.391497e-003f,
    5.680941e-003f,  2.848871e-003f, -9.626025e-004f,  7.092142e-005f,  4.885399e-003f,  5.835958e-003f,  4.709961e-005f, -4.585979e-003f,
   -7.959620e-004f,  5.709922e-003f,  4.625618e-003f, -2.095527e-003f, -3.641527e-003f,  1.153595e-003f,  2.174801e-003f, -3.989409e-003f,
   -7.934252e-003f, -3.248648e-003f,  3.531193e-003f,  4.492210e-003f,  2.027691e-003f,  2.337011e-003f,  4.734948e-003f,  4.365851e-003f,
    8.446866e-004f, -1.937893e-003f, -2.296606e-003f, -2.446934e-003f, -4.314894e-003f, -6.520022e-003f, -6.374666e-003f, -4.090861e-003f,
   -3.327581e-003f, -6.134503e-003f, -8.995822e-003f, -7.045879e-003f, -1.038687e-003f,  4.032688e-003f,  6.311946e-003f,  7.975197e-003f,
    9.304876e-003f,  7.800577e-003f,  3.696247e-003f,  7.130294e-004f,  3.212190e-004f,  1.723828e-004f, -1.000313e-003f, -1.456174e-003f,
   -5.688451e-005f,  2.015445e-003f,  3.344729e-003f,  3.121084e-003f,  7.828554e-004f, -2.398404e-003f, -3.147773e-003f, -5.338843e-004f,
    1.757174e-003f,  5.216622e-004f, -2.132542e-003f, -2.280256e-003f, -3.109461e-005f,  1.480888e-003f,  1.037387e-003f,  1.221392e-004f,
   -1.274564e-004f, -3.063508e-004f, -1.292441e-003f, -2.595009e-003f, -2.515850e-003f, -3.884782e-004f,  1.667804e-003f,  1.018735e-003f,
   -1.476606e-003f, -2.473570e-003f, -1.283577e-003f, -2.908655e-004f,  1.144827e-004f,  2.286679e-003f,  5.972194e-003f,  7.346598e-003f,
    5.125337e-003f,  2.805365e-003f,  3.039374e-003f,  4.277707e-003f,  4.450879e-003f,  3.682045e-003f,  2.369942e-003f,  7.188935e-004f,
    4.061090e-004f,  2.437789e-003f,  3.862160e-003f,  1.419971e-003f, -2.395194e-003f, -2.305321e-003f,  1.494872e-003f,  3.771574e-003f,
    2.526222e-003f,  1.031311e-003f,  1.472114e-003f,  2.122546e-003f,  1.650722e-003f,  1.399882e-003f,  2.204389e-003f,  2.789694e-003f,
    2.420821e-003f,  2.042264e-003f,  1.969957e-003f,  1.126496e-003f, -6.775016e-004f, -1.930327e-003f, -1.614978e-003f, -5.394265e-004f,
    6.897160e-005f,  3.728132e-005f, -4.666388e-005f,  2.384365e-004f,  6.336111e-004f,  3.155153e-004f, -9.564513e-004f, -1.836165e-003f,
   -1.011017e-003f,  1.038398e-004f, -1.149065e-003f, -3.844525e-003f, -3.688098e-003f,  2.561129e-004f,  3.146033e-003f,  1.435185e-003f,
   -1.869618e-003f, -2.501483e-003f, -1.091168e-003f, -1.224852e-004f,  5.695028e-004f,  1.162520e-003f, -8.486624e-005f, -2.291501e-003f,
   -1.856331e-003f, -2.475936e-004f, -3.059938e-003f, -7.536699e-003f, -3.113151e-003f,  9.553113e-003f,  1.443554e-002f,  4.157423e-003f,
   -6.844646e-003f, -4.818262e-003f,  2.769150e-003f,  2.967281e-003f, -1.205568e-003f, -7.661226e-004f,  1.352292e-003f, -1.043988e-003f,
   -3.033777e-003f,  9.979216e-004f,  4.069870e-003f, -7.888671e-004f, -6.045817e-003f, -2.823811e-003f,  2.762719e-003f,  1.204605e-003f,
   -3.467124e-003f, -2.886200e-003f, -1.725351e-004f, -2.305827e-003f, -5.781984e-003f, -3.435835e-003f,  1.875869e-003f,  2.567041e-003f,
   -6.390929e-004f, -1.329534e-003f,  1.461899e-003f,  3.118280e-003f,  1.407560e-003f, -1.308640e-003f, -1.984562e-003f, -3.094593e-006f,
    2.232448e-003f,  1.572502e-003f, -1.448413e-003f, -2.504813e-003f,  3.635754e-006f,  1.998782e-003f,  3.263404e-004f, -2.157642e-003f,
   -1.819258e-003f,  6.401320e-005f,  8.415714e-004f,  1.143598e-003f,  1.865969e-003f,  9.019318e-004f, -2.601366e-003f, -4.392121e-003f,
   -4.467922e-004f,  6.020445e-003f,  7.701525e-003f,  2.930738e-003f, -2.012260e-003f, -1.650241e-003f,  1.343058e-003f,  9.237489e-004f,
   -2.784445e-003f, -4.133741e-003f, -1.398967e-003f,  8.511345e-004f, -2.587757e-004f, -2.197613e-003f, -3.012323e-003f, -4.176940e-003f,
   -5.331244e-003f, -3.132578e-003f,  2.249200e-003f,  5.928192e-003f,  5.269432e-003f,  2.135016e-003f, -1.774596e-003f, -5.476099e-003f,
   -6.166025e-003f, -3.046256e-003f, -9.060817e-004f, -2.930814e-003f, -4.538185e-003f, -1.678049e-003f,  1.257201e-003f, -1.947660e-004f,
   -2.257412e-003f, -1.334069e-003f, -1.481690e-003f, -5.079761e-003f, -6.530884e-003f, -3.376456e-003f, -1.903194e-003f, -4.250404e-003f,
   -3.498899e-003f,  1.420362e-003f,  1.414625e-003f, -5.121097e-003f, -7.182484e-003f, -9.717287e-004f,  2.691570e-003f, -1.875812e-003f,
   -5.773113e-003f, -3.074690e-003f, -5.068816e-004f, -2.699215e-003f, -4.066478e-003f, -1.306122e-003f,  8.734096e-004f,  4.948258e-004f,
    1.049960e-003f,  1.959796e-003f, -4.421771e-004f, -3.048420e-003f, -1.861164e-004f,  4.695060e-003f,  4.298136e-003f,  5.231003e-004f,
   -1.496972e-004f,  9.068250e-004f, -1.261757e-003f, -4.447381e-003f, -4.187602e-003f, -2.943928e-003f, -4.144616e-003f, -4.288696e-003f,
   -3.246985e-004f,  2.821204e-003f,  6.611158e-004f, -2.603949e-003f, -1.756155e-003f,  9.992749e-004f,  1.619056e-003f,  1.140682e-003f,
    1.792491e-003f,  2.558743e-003f,  2.521168e-003f,  3.138804e-003f,  4.751869e-003f,  5.297261e-003f,  3.443717e-003f, -1.923150e-004f,
   -3.922979e-003f, -4.913768e-003f, -1.437187e-003f,  3.108165e-003f,  3.272798e-003f, -3.097453e-004f, -2.237092e-003f, -1.943800e-003f,
   -3.595968e-003f, -6.412080e-003f, -5.256645e-003f, -1.291255e-003f, -9.549438e-004f, -3.829215e-003f, -3.392383e-003f, -3.345627e-004f,
   -2.080361e-003f, -7.719024e-003f, -7.044211e-003f,  2.437377e-003f,  1.020962e-002f,  8.344799e-003f,  1.557061e-003f, -2.034459e-003f,
   -8.949583e-004f,  2.319647e-003f,  5.267827e-003f,  5.624756e-003f,  2.557324e-003f, -5.542820e-004f, -4.850523e-005f,  2.296713e-003f,
    2.487110e-003f,  8.227898e-004f, -1.740846e-004f, -1.053192e-003f, -2.946623e-003f, -3.443495e-003f, -7.404246e-004f,  1.905273e-003f,
    1.350113e-003f, -3.696025e-005f,  6.583274e-004f,  1.344952e-003f, -4.086249e-004f, -2.213088e-003f, -1.531478e-003f, -3.590113e-004f,
   -4.372607e-004f,  6.248918e-004f,  3.759694e-003f,  4.918579e-003f,  1.951169e-003f, -9.231609e-004f, -2.484377e-004f,  9.468271e-004f,
   -7.661964e-004f, -3.059649e-003f, -2.441993e-003f, -1.467223e-004f,  6.863275e-004f, -1.894062e-004f, -1.039493e-003f, -6.752932e-004f,
    1.098434e-003f,  2.691002e-003f,  1.358561e-003f, -2.060369e-003f, -2.131863e-003f,  2.902709e-003f,  6.426236e-003f,  3.112564e-003f,
   -2.068187e-003f, -2.035385e-003f,  8.533337e-004f,  1.925656e-004f, -2.952167e-003f, -3.433259e-003f, -2.016054e-003f, -2.378070e-003f,
   -2.782478e-003f, -2.042879e-004f,  1.934398e-003f, -4.480224e-004f, -3.365061e-003f, -1.268168e-003f,  2.555184e-003f,  1.806997e-003f,
   -1.236749e-003f, -2.295642e-004f,  3.004403e-003f,  1.544028e-003f, -3.563649e-003f, -4.158985e-003f,  1.188237e-003f,  4.227175e-003f,
    1.066924e-004f, -5.004291e-003f, -3.582645e-003f,  2.112443e-003f,  4.291388e-003f,  1.520033e-003f, -3.233216e-004f,  1.595352e-003f,
    2.616317e-003f, -1.044265e-003f, -5.317164e-003f, -4.359976e-003f,  4.545191e-004f,  3.160498e-003f,  2.157926e-003f,  8.613984e-004f,
    1.052937e-003f,  1.193227e-003f,  6.448796e-004f,  5.421631e-004f,  5.888822e-004f, -7.569952e-004f, -2.791242e-003f, -2.784321e-003f,
   -8.878943e-005f,  2.587695e-003f,  2.591290e-003f,  3.908702e-004f, -1.419938e-003f, -1.502594e-003f, -1.191850e-003f, -1.985113e-003f,
   -2.802852e-003f, -1.840210e-003f, -1.990276e-004f, -2.989424e-004f, -1.214625e-003f,  8.822002e-005f,  3.033545e-003f,  3.818290e-003f,
    1.513840e-003f, -1.224582e-003f, -3.119828e-003f, -4.630648e-003f, -4.440799e-003f, -1.442590e-003f,  1.276123e-003f,  3.943496e-004f,
   -1.914717e-003f, -2.067221e-003f, -1.350282e-003f, -1.970883e-003f, -1.675054e-003f,  9.035317e-004f,  1.336213e-003f, -2.811820e-003f,
   -5.786571e-003f, -2.898339e-003f,  1.097682e-003f,  5.779778e-004f, -1.701583e-003f, -1.671608e-003f, -1.960636e-003f, -4.902634e-003f,
   -5.942468e-003f, -1.963596e-003f,  1.819945e-003f,  5.953044e-004f, -2.137322e-003f, -1.738435e-003f,  6.356760e-006f, -8.546924e-005f,
   -1.108192e-003f, -1.794289e-003f, -3.005467e-003f, -3.801221e-003f, -1.689503e-003f,  1.703581e-003f,  1.854410e-003f, -1.085540e-003f,
   -2.208873e-003f,  5.348856e-004f,  4.055963e-003f,  5.034494e-003f,  3.044416e-003f, -1.275184e-004f, -1.942472e-003f, -1.848293e-003f,
   -2.622927e-003f, -5.445768e-003f, -5.890171e-003f, -9.387711e-004f,  3.556073e-003f,  1.030854e-003f, -4.160589e-003f, -3.728064e-003f,
    1.701808e-004f, -4.656448e-004f, -4.486660e-003f, -4.224736e-003f,  1.931119e-004f,  2.069143e-003f,  7.575417e-004f,  9.466511e-004f,
    2.324109e-003f,  1.014055e-003f, -1.922824e-003f, -2.911156e-003f, -2.658919e-003f, -2.705162e-003f, -7.949768e-004f,  3.476527e-003f,
    5.243079e-003f,  2.553374e-003f,  3.264877e-004f,  1.343036e-003f,  1.848579e-003f, -1.321072e-004f, -1.384058e-003f, -1.058347e-003f,
   -1.955564e-003f, -2.983272e-003f, -4.798132e-004f,  3.029772e-003f,  1.972953e-003f, -1.773869e-003f, -2.221875e-003f, -1.319152e-004f,
    3.525576e-004f,  1.211705e-003f,  5.160108e-003f,  6.802922e-003f,  1.477011e-003f, -3.728097e-003f, -4.077418e-004f,  6.526703e-003f,
    6.899951e-003f,  1.052400e-003f, -3.600984e-003f, -4.546740e-003f, -3.115235e-003f,  5.150119e-004f,  3.484598e-003f,  7.694036e-004f,
   -4.601294e-003f, -3.241011e-003f,  4.221445e-003f,  6.467636e-003f,  1.269396e-003f, -5.458549e-004f,  4.298040e-003f,  5.154392e-003f,
   -1.996902e-003f, -6.104162e-003f, -8.740510e-004f,  4.343259e-003f,  1.593262e-003f, -3.656333e-003f, -4.971386e-003f, -4.681376e-003f,
   -4.781704e-003f, -2.152255e-003f,  1.811393e-003f,  3.712422e-004f, -5.372519e-003f, -5.794429e-003f,  1.063375e-003f,  5.751630e-003f,
    3.265518e-003f, -2.183672e-004f,  9.703920e-005f,  6.702197e-004f, -9.432157e-004f, -1.033465e-003f,  1.665892e-003f,  2.263952e-003f,
   -1.085009e-003f, -2.853757e-003f,  5.620263e-004f,  4.501285e-003f,  3.723315e-003f,  6.397964e-004f,  6.442713e-004f,  3.139166e-003f,
    2.916876e-003f, -9.770996e-004f, -3.336007e-003f, -8.658220e-004f,  2.521180e-003f,  1.807741e-003f, -1.139592e-003f, -8.005780e-004f,
    2.552433e-003f,  3.071496e-003f, -6.941178e-004f, -2.837109e-003f,  4.988700e-004f,  4.801243e-003f,  4.133942e-003f, -1.735627e-004f,
   -2.154096e-003f,  3.456573e-004f,  3.751199e-003f,  3.827849e-003f, -1.011308e-004f, -5.189219e-003f, -7.639286e-003f, -5.775274e-003f,
   -1.421059e-003f,  1.912222e-003f,  2.063019e-003f, -5.733854e-004f, -3.685964e-003f, -4.468826e-003f, -1.973407e-003f,  1.335591e-003f,
    2.006354e-003f, -9.087186e-005f, -1.907839e-003f, -1.778138e-003f, -1.140931e-003f, -1.284996e-003f, -1.393934e-003f, -8.611624e-004f,
   -8.077268e-004f, -1.916965e-003f, -2.904874e-003f, -2.427819e-003f, -8.169338e-004f,  1.050675e-003f,  2.904730e-003f,  4.047115e-003f,
    2.895473e-003f, -7.360585e-004f, -4.044929e-003f, -4.081738e-003f, -1.756805e-003f, -5.431646e-004f, -1.114530e-003f, -6.255719e-004f,
    1.488131e-003f,  1.298688e-003f, -2.818616e-003f, -5.468715e-003f, -1.558317e-003f,  5.019427e-003f,  6.486238e-003f,  2.583037e-003f,
   -3.192019e-004f,  1.056989e-004f,  2.589000e-004f, -1.126099e-003f, -9.676530e-004f,  1.248961e-003f,  2.008021e-003f,  4.202935e-004f,
   -2.741471e-004f,  1.024868e-003f,  1.556737e-003f,  1.626532e-004f, -1.090692e-003f, -1.339992e-003f, -1.774385e-003f, -1.820852e-003f,
    4.370711e-004f,  3.793943e-003f,  4.592466e-003f,  2.159520e-003f, -4.439625e-004f, -1.123955e-003f, -6.661608e-004f, -1.420090e-004f,
    4.280635e-004f,  8.705854e-004f,  6.696656e-004f, -1.304054e-004f, -1.056711e-003f, -1.466162e-003f, -3.052130e-004f,  2.513754e-003f,
    4.311593e-003f,  2.123391e-003f, -2.399569e-003f, -4.022279e-003f, -1.114830e-003f,  1.796388e-003f,  6.196187e-004f, -2.597680e-003f,
   -3.298162e-003f, -1.003210e-003f,  9.715800e-004f,  6.909886e-004f, -6.429922e-004f, -1.271725e-003f, -6.185212e-004f,  1.057159e-003f,
    2.672077e-003f,  2.607434e-003f,  8.348940e-004f, -2.195375e-004f,  1.061823e-003f,  2.711483e-003f,  2.157791e-003f,  4.203177e-004f,
    1.285994e-004f,  8.583994e-004f,  3.633524e-004f, -7.316733e-004f,  6.384669e-005f,  2.116865e-003f,  2.346260e-003f,  5.571208e-004f,
   -4.871611e-004f, -7.996591e-005f, -9.346737e-005f, -6.795041e-004f,  5.987854e-005f,  2.141635e-003f,  3.435075e-003f,  3.080855e-003f,
    1.851891e-003f,  1.019146e-004f, -1.595396e-003f, -1.520199e-003f,  5.019875e-004f,  1.796248e-003f,  9.377285e-004f,  1.058371e-004f,
    7.972909e-004f,  1.103814e-003f,  2.029089e-005f, -1.567621e-005f,  2.007374e-003f,  2.870258e-003f,  5.048910e-004f, -2.153468e-003f,
   -1.903726e-003f,  1.318517e-005f,  7.465415e-004f,  5.900266e-005f, -4.336632e-004f,  2.892269e-004f,  1.933451e-003f,  2.772604e-003f,
    1.057773e-003f, -1.685465e-003f, -1.436216e-003f,  1.917088e-003f,  3.136968e-003f, -1.169386e-004f, -2.786323e-003f, -5.848589e-004f,
    2.826355e-003f,  2.261441e-003f, -5.534915e-004f, -9.518015e-004f,  6.546556e-004f,  6.912496e-004f, -1.025181e-003f, -1.863616e-003f,
   -9.827657e-004f,  4.958304e-004f,  1.671830e-003f,  1.817511e-003f,  5.899009e-004f, -5.084210e-004f,  2.675742e-004f,  1.576921e-003f,
    6.777284e-004f, -1.764305e-003f, -2.381734e-003f, -4.032668e-004f,  1.511855e-003f,  1.587175e-003f,  8.000908e-004f,  6.175435e-004f,
    1.342332e-003f,  2.268099e-003f,  1.934581e-003f, -6.396037e-004f, -3.997119e-003f, -5.274449e-003f, -3.892036e-003f, -2.145927e-003f,
   -1.771923e-003f, -2.279751e-003f, -2.859408e-003f, -3.395761e-003f, -3.314401e-003f, -1.691637e-003f,  1.078082e-003f,  3.225636e-003f,
    3.409542e-003f,  1.926961e-003f,  3.542794e-004f, -3.450281e-005f,  1.860897e-004f, -3.742907e-004f, -1.082652e-003f, -1.301180e-004f,
    1.069482e-003f, -1.169304e-003f, -5.682964e-003f, -6.340630e-003f, -2.090307e-003f,  2.422291e-004f, -2.369333e-003f, -3.262183e-003f,
    1.909934e-003f,  6.543876e-003f,  4.562783e-003f,  1.243929e-003f,  2.879089e-003f,  4.587343e-003f, -3.102413e-004f, -6.746871e-003f,
   -5.994350e-003f, -7.397892e-004f,  2.824017e-004f, -2.641771e-003f, -2.705594e-003f,  1.155245e-004f,  1.482825e-004f, -2.478986e-003f,
   -2.365473e-003f,  8.243909e-004f,  2.000706e-003f, -3.948329e-004f, -2.799499e-003f, -2.898529e-003f, -1.396525e-003f,  1.065497e-003f,
    3.542437e-003f,  3.408719e-003f,  6.922689e-005f, -2.364574e-003f, -4.917314e-004f,  2.935927e-003f,  3.241278e-003f,  7.657522e-004f,
   -7.417763e-004f, -2.312852e-004f,  4.898816e-004f,  8.292652e-004f,  1.630051e-003f,  2.633755e-003f,  3.000267e-003f,  3.107421e-003f,
    3.212165e-003f,  2.059519e-003f, -5.366718e-004f, -1.831953e-003f, -5.748194e-006f,  2.092401e-003f,  6.974020e-004f, -2.825249e-003f,
   -3.678443e-003f, -7.466666e-004f,  1.958120e-003f,  1.297251e-003f, -9.648816e-004f, -1.276335e-003f,  8.846695e-004f,  2.748054e-003f,
    1.871072e-003f, -9.232339e-004f, -2.428878e-003f, -1.011627e-003f,  1.072718e-003f,  6.546888e-004f, -1.820719e-003f, -3.129590e-003f,
   -2.217516e-003f, -1.150607e-003f, -9.300137e-004f,  8.407835e-005f,  2.589450e-003f,  4.457038e-003f,  3.811607e-003f,  1.427298e-003f,
   -1.000052e-003f, -2.718805e-003f, -3.354565e-003f, -2.483729e-003f, -3.467436e-004f,  2.135728e-003f,  3.740690e-003f,  2.974533e-003f,
   -3.242855e-004f, -2.928079e-003f, -1.116905e-003f,  3.336215e-003f,  4.411352e-003f,  6.185627e-004f, -2.687562e-003f, -1.931639e-003f,
   -2.724295e-004f, -9.146862e-004f, -1.808539e-003f, -9.302546e-004f, -6.554225e-004f, -2.414390e-003f, -2.842259e-003f,  8.365510e-005f,
    2.598721e-003f,  1.514681e-003f, -2.786530e-004f,  5.694607e-004f,  1.762625e-003f, -1.164797e-004f, -3.236984e-003f, -3.704595e-003f,
   -1.876384e-003f, -9.404560e-004f, -1.577694e-003f, -1.952976e-003f, -1.295746e-003f, -2.164040e-004f,  1.279462e-003f,  3.245806e-003f,
    4.047084e-003f,  1.833420e-003f, -2.160239e-003f, -4.100685e-003f, -2.285058e-003f,  4.529076e-004f,  7.300947e-004f, -5.596537e-004f,
   -5.493734e-005f,  2.483740e-003f,  3.949212e-003f,  3.014610e-003f,  1.562201e-003f,  7.234483e-004f, -3.998236e-004f, -1.579141e-003f,
   -1.270589e-003f, -8.836076e-005f, -2.185026e-004f, -1.168514e-003f, -4.848726e-004f,  1.488278e-003f,  2.086089e-003f,  9.299287e-004f,
   -3.689961e-004f, -1.717387e-003f, -3.331713e-003f, -3.356784e-003f, -1.194094e-003f,  1.172048e-004f, -6.812540e-004f, -1.538798e-005f,
    3.324070e-003f,  4.232846e-003f,  3.851309e-004f, -2.055784e-003f,  1.145237e-003f,  3.997224e-003f,  6.218248e-004f, -3.878527e-003f,
   -2.114982e-003f,  3.083974e-003f,  4.464429e-003f,  2.489641e-003f,  2.241932e-003f,  3.452211e-003f,  2.644350e-003f,  1.001729e-003f,
    1.957497e-003f,  4.189440e-003f,  3.790613e-003f,  7.713106e-004f, -1.847822e-003f, -2.869325e-003f, -2.781140e-003f, -1.355799e-003f,
    1.263616e-003f,  3.209609e-003f,  3.126854e-003f,  2.126049e-003f,  1.922786e-003f,  2.408535e-003f,  2.212489e-003f,  8.678085e-004f,
   -4.757089e-004f, -6.719385e-004f, -3.787826e-004f, -9.146330e-004f, -1.458735e-003f, -1.114983e-004f,  1.778456e-003f,  5.155713e-004f,
   -3.304906e-003f, -4.357381e-003f, -1.138338e-003f,  1.192437e-003f, -3.128759e-004f, -1.570915e-003f,  4.207990e-004f,  1.926889e-003f,
   -1.082436e-004f, -1.931634e-003f,  3.480023e-004f,  3.991348e-003f,  4.373261e-003f,  1.411001e-003f, -2.064669e-003f, -3.601296e-003f,
   -1.455488e-003f,  3.144911e-003f,  4.599308e-003f, -1.729754e-006f, -4.465980e-003f, -1.698682e-003f,  4.679622e-003f,  5.866887e-003f,
    1.833091e-003f, -2.589793e-004f,  1.217860e-003f,  1.583257e-003f, -2.281557e-004f, -7.332260e-004f,  5.974100e-004f,  1.175282e-003f,
    8.218507e-004f,  7.304200e-004f, -2.570135e-004f, -2.608991e-003f, -3.269083e-003f, -9.847403e-004f,  3.539192e-004f, -1.532123e-003f,
   -2.762049e-003f, -3.198230e-004f,  2.034954e-003f, -8.750193e-005f, -4.498415e-003f, -5.966850e-003f, -3.251404e-003f,  8.188281e-004f,
    3.313528e-003f,  3.035638e-003f,  7.285157e-004f, -1.426573e-003f, -1.941848e-003f, -1.252900e-003f, -3.179728e-005f,  1.606092e-003f,
    2.413501e-003f,  8.502037e-004f, -1.473316e-003f, -1.188503e-003f,  1.216160e-003f,  1.712645e-003f, -7.508461e-004f, -2.959266e-003f,
   -3.017791e-003f, -2.224242e-003f, -1.408582e-003f, -3.914900e-004f, -4.598041e-004f, -2.422963e-003f, -3.566659e-003f, -1.546124e-003f,
    9.000097e-004f,  4.191041e-004f, -7.714901e-004f,  8.966043e-004f,  3.278069e-003f,  2.353366e-003f,  1.285547e-005f,  7.685333e-004f,
    3.180327e-003f,  2.061540e-003f, -2.292068e-003f, -4.385850e-003f, -2.500219e-003f, -6.266287e-004f, -1.121131e-003f, -1.596899e-003f,
   -4.147344e-004f,  1.389158e-004f, -1.575381e-003f, -3.104659e-003f, -1.976615e-003f, -5.002956e-005f, -4.511943e-004f, -2.384734e-003f,
   -2.659297e-003f, -9.897813e-004f,  9.914191e-005f, -1.065084e-004f, -6.307620e-005f,  1.702214e-004f, -1.016517e-003f, -2.740593e-003f,
   -2.261119e-003f, -2.004679e-004f, -2.489664e-004f, -2.643912e-003f, -3.021116e-003f,  5.580350e-004f,  4.303957e-003f,  4.605060e-003f,
    2.884792e-003f,  2.107080e-003f,  2.157946e-003f,  1.394490e-003f,  7.636692e-005f, -2.909450e-004f,  4.833526e-004f,  1.195219e-003f,
    1.042923e-003f,  4.032336e-004f, -1.910492e-004f, -1.203158e-003f, -3.100079e-003f, -4.062638e-003f, -1.142193e-003f,  4.585102e-003f,
    7.116183e-003f,  3.093110e-003f, -2.734813e-003f, -3.879415e-003f, -8.923099e-004f,  1.235035e-003f,  1.257862e-003f,  1.350805e-003f,
    1.435920e-003f,  1.513844e-004f, -8.864978e-004f,  2.126017e-004f,  1.184643e-003f, -3.918266e-004f, -1.780885e-003f,  2.860138e-004f,
    3.081648e-003f,  2.294364e-003f, -2.958567e-004f,  8.655038e-006f,  2.831218e-003f,  4.026980e-003f,  2.441849e-003f, -1.009918e-004f,
   -2.903459e-003f, -5.418798e-003f, -5.053325e-003f, -9.707425e-004f,  2.606908e-003f,  1.765231e-003f, -9.811339e-004f, -8.156360e-004f,
    1.415922e-003f,  7.935166e-004f, -3.187733e-003f, -5.313959e-003f, -2.731682e-003f,  4.477437e-004f, -6.320907e-004f, -4.026975e-003f,
   -3.914378e-003f,  2.523378e-004f,  2.779787e-003f,  8.643959e-004f, -9.928764e-004f,  1.059207e-003f,  3.329167e-003f,  1.055547e-003f,
   -2.803279e-003f, -2.290986e-003f,  1.327683e-003f,  2.030025e-003f, -3.708506e-004f, -5.984817e-004f,  2.037782e-003f,  2.690464e-003f,
    3.309490e-004f, -4.574578e-004f,  1.731524e-003f,  2.592524e-003f,  3.046439e-004f, -1.227349e-003f,  1.393835e-004f,  9.076574e-004f,
   -1.357820e-003f, -3.460378e-003f, -2.250303e-003f,  2.772706e-005f, -2.381589e-004f, -2.342335e-003f, -3.116542e-003f, -1.946956e-003f,
   -8.480708e-004f, -9.034203e-004f, -1.011256e-003f,  1.120056e-004f,  1.872921e-003f,  2.109431e-003f, -2.201805e-004f, -2.873617e-003f,
   -2.428046e-003f,  8.860105e-004f,  2.611271e-003f, -1.541102e-004f, -4.450144e-003f, -5.241639e-003f, -2.110178e-003f,  6.032737e-004f,
    6.532845e-006f, -1.761301e-003f, -1.246845e-003f,  1.019710e-003f,  1.433206e-003f, -8.712567e-004f, -2.364353e-003f, -8.098562e-004f,
    7.513804e-004f, -9.367357e-004f, -3.324243e-003f, -2.091487e-003f,  1.173560e-003f,  1.663473e-003f,  6.417663e-005f,  1.067966e-003f,
    3.928449e-003f,  2.988033e-003f, -1.917075e-003f, -4.411623e-003f, -2.335389e-003f, -7.612269e-004f, -2.312886e-003f, -3.178092e-003f,
   -1.226265e-003f,  2.627163e-004f, -3.969703e-004f, -4.090092e-004f,  1.042460e-003f,  9.333710e-004f, -1.077118e-003f, -1.514747e-003f,
    8.020672e-005f,  2.442293e-004f, -1.561769e-003f, -2.055448e-003f, -4.979454e-004f,  6.049843e-004f,  8.853658e-004f,  1.840978e-003f,
    2.274305e-003f,  4.079145e-004f, -1.211008e-003f,  4.697926e-004f,  2.538130e-003f,  4.545057e-004f, -3.468340e-003f, -3.283290e-003f,
    7.460912e-004f,  2.860639e-003f,  1.242149e-003f, -2.253515e-004f,  5.722508e-004f,  9.353989e-004f, -1.241217e-003f, -3.586554e-003f,
   -2.539384e-003f,  1.755993e-003f,  5.263437e-003f,  4.390960e-003f,  7.098838e-005f, -3.172818e-003f, -2.620409e-003f, -4.502690e-004f,
   -2.788462e-004f, -2.249037e-003f, -3.445729e-003f, -1.990134e-003f,  1.116867e-003f,  3.483563e-003f,  3.514871e-003f,  1.812626e-003f,
    6.580548e-004f,  1.114952e-003f,  1.327935e-003f, -4.999481e-004f, -2.621628e-003f, -2.074754e-003f,  4.282052e-004f,  1.358503e-003f,
   -2.253606e-004f, -1.617906e-003f, -1.032432e-003f,  4.523828e-005f, -6.145210e-005f, -4.753723e-004f,  3.849661e-004f,  1.858553e-003f,
    1.791599e-003f, -1.110723e-004f, -1.417117e-003f, -3.565066e-004f,  1.177540e-003f, -1.421286e-005f, -3.518370e-003f, -5.331297e-003f,
   -3.318375e-003f, -6.839973e-005f,  9.119136e-004f, -3.801269e-004f, -1.427152e-003f, -9.408694e-004f,  1.427511e-004f,  6.521707e-004f,
    6.468720e-004f,  6.462022e-004f,  2.072693e-004f, -1.536003e-003f, -3.638613e-003f, -3.484699e-003f, -6.503523e-004f,  1.532836e-003f,
    7.890676e-004f, -2.729416e-004f,  1.195446e-003f,  2.626911e-003f,  1.279616e-004f, -4.104377e-003f, -4.477733e-003f, -7.012583e-004f,
    2.209689e-003f,  1.746845e-003f,  1.458367e-004f, -5.403418e-004f, -6.335879e-004f, -5.967404e-004f, -4.866838e-004f, -8.032289e-004f,
   -1.290592e-003f, -7.516932e-004f,  1.994516e-004f, -6.914292e-004f, -2.924054e-003f, -3.061021e-003f, -4.114568e-004f,  1.633666e-003f,
    1.394605e-003f,  1.272868e-003f,  2.828288e-003f,  4.049453e-003f,  3.071089e-003f,  8.500292e-004f, -8.831922e-004f, -1.419228e-003f,
   -6.809452e-004f,  6.382725e-004f,  1.157508e-003f,  6.173382e-004f,  1.927031e-004f,  1.832551e-004f, -2.976098e-004f, -1.071460e-003f,
   -1.235004e-003f, -1.316823e-003f, -1.820533e-003f, -1.103018e-003f,  1.378705e-003f,  2.203090e-003f, -8.011256e-004f, -3.529592e-003f,
   -1.466953e-003f,  2.510432e-003f,  2.362331e-003f, -1.743115e-003f, -4.340441e-003f, -2.976427e-003f, -3.714989e-004f,  4.375986e-004f,
   -6.653895e-004f, -1.754766e-003f, -1.282649e-003f, -2.067191e-004f, -8.307296e-004f, -2.360769e-003f, -9.883821e-004f,  3.186124e-003f,
    4.521905e-003f,  8.210859e-004f, -2.450071e-003f, -1.435575e-003f,  9.331256e-005f, -8.947188e-004f, -8.433608e-004f,  2.034633e-003f,
    2.607554e-003f, -1.668056e-003f, -5.093168e-003f, -3.582106e-003f, -1.131981e-003f, -1.125291e-003f, -5.298298e-004f,  2.334879e-003f,
    3.527883e-003f,  1.313930e-003f, -4.209084e-004f,  3.105975e-004f,  9.130281e-004f,  6.595486e-004f,  1.615250e-003f,  2.676621e-003f,
    8.322845e-004f, -2.034226e-003f, -1.409025e-003f,  1.879276e-003f,  3.138114e-003f,  1.577608e-003f,  2.225551e-004f,  1.886305e-004f,
    4.135703e-004f,  7.419763e-004f,  1.265203e-003f,  1.144661e-003f,  4.214917e-004f,  5.090069e-005f, -4.071732e-004f, -1.514888e-003f,
   -1.376186e-003f,  1.300768e-003f,  3.618033e-003f,  2.759958e-003f,  9.765411e-004f,  1.427096e-003f,  2.614033e-003f,  2.001326e-003f,
    7.086109e-004f,  4.204228e-004f,  2.081517e-004f, -4.507942e-004f, -1.465126e-004f,  9.420258e-004f,  7.148057e-004f, -6.546855e-004f,
   -8.636394e-004f,  1.413065e-004f,  4.786920e-004f,  2.248065e-004f,  6.595869e-004f,  1.084819e-003f,  3.494680e-004f, -4.452301e-004f,
   -1.739296e-004f, -8.934715e-005f, -1.111679e-003f, -1.671761e-003f, -7.199402e-004f,  2.301685e-004f,  4.793378e-005f, -1.482147e-004f,
    4.329534e-004f,  8.098274e-004f,  4.161093e-004f,  4.787582e-005f,  4.872516e-005f, -1.322308e-004f, -4.664685e-004f, -3.884531e-004f,
   -4.490955e-005f,  4.604179e-005f,  4.752045e-006f,  1.070739e-004f,  1.116172e-004f, -1.088302e-004f, -1.832977e-004f,  3.369766e-006f,
    8.822881e-005f, -2.823562e-005f, -7.086594e-005f,  2.761636e-006f,  8.455887e-006f, -3.510182e-005f, -1.772056e-005f,  8.866032e-006f
};



static const float MPSVTReverbRight[] =
{
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,  0.00000000000f,
    0.00000000000f,  0.00000000000f, -6.517894e-011f, -1.605007e-010f, -1.647927e-010f, -1.039552e-010f,  1.864920e-013f,  1.151768e-005f,
   -1.582917e-005f, -8.728220e-005f, -1.041464e-004f, -6.234473e-005f, -5.598068e-005f, -3.016848e-005f,  8.625972e-005f,  9.976386e-005f,
   -1.060013e-004f, -2.382535e-004f, -1.221022e-004f, -1.984384e-005f, -5.794265e-006f,  9.379144e-005f, -4.415113e-005f, -6.912472e-004f,
   -9.498268e-004f, -9.800275e-005f,  6.240825e-004f,  1.141009e-004f, -1.389585e-004f,  9.196839e-004f,  7.905358e-004f, -2.137490e-003f,
   -4.172573e-003f, -2.097696e-003f,  3.813663e-004f, -1.320252e-003f, -4.473837e-003f, -4.125565e-003f, -1.297615e-003f,  1.194257e-003f,
    4.678885e-003f,  9.011289e-003f,  8.978843e-003f,  3.602796e-003f, -2.958757e-004f,  6.674883e-005f, -3.362341e-004f, -1.907971e-003f,
    5.814330e-004f,  3.771067e-003f,  9.525978e-006f, -3.279840e-003f,  5.571918e-003f,  1.283445e-002f, -3.196325e-003f, -2.777431e-002f,
   -2.325277e-002f,  9.497451e-003f,  2.725889e-002f,  1.089797e-002f, -9.228076e-003f, -7.965279e-003f, -1.102310e-003f, -7.269777e-003f,
   -1.467906e-002f, -8.953077e-003f, -3.578908e-004f, -8.444308e-004f, -2.279813e-003f,  2.933644e-003f,  4.990613e-003f, -2.425676e-003f,
   -7.486267e-003f, -1.584846e-003f,  5.314531e-003f,  3.580624e-003f, -6.059756e-004f,  2.998768e-004f,  2.163049e-003f,  1.086529e-004f,
   -1.969802e-003f, -4.871583e-004f,  1.334748e-003f,  1.225909e-003f,  1.624687e-003f,  2.741647e-003f,  1.462366e-003f, -1.358694e-003f,
   -1.238693e-003f,  1.752456e-003f,  2.826080e-003f,  4.142169e-004f, -2.218168e-003f, -2.805569e-003f, -2.287418e-003f, -1.880066e-003f,
   -1.762793e-003f, -1.873473e-003f, -1.850209e-003f, -1.363533e-003f, -1.082977e-003f, -1.416578e-003f, -8.534481e-004f,  1.721149e-003f,
    4.128878e-003f,  3.551966e-003f,  9.691278e-004f, -3.013522e-004f,  5.748226e-004f,  1.515260e-003f,  9.718703e-004f, -5.247637e-004f,
   -1.535311e-003f, -1.108490e-003f,  2.089334e-004f,  6.793456e-004f, -9.832331e-005f, -1.112805e-004f,  1.532182e-003f,  2.040269e-003f,
   -7.337439e-004f, -3.642553e-003f, -2.494551e-003f,  8.090456e-004f,  8.129059e-004f, -2.624242e-003f, -3.846336e-003f, -3.525357e-004f,
    3.344377e-003f,  2.831172e-003f,  1.373849e-004f, -2.474269e-004f,  1.525075e-003f,  1.581717e-003f, -1.111486e-003f, -3.299966e-003f,
   -2.749254e-003f, -1.265771e-003f, -1.109251e-003f, -1.543180e-003f, -9.434379e-004f,  2.056578e-004f,  6.444329e-004f,  6.168021e-004f,
    7.972998e-004f,  8.144132e-004f,  4.560157e-004f,  3.067073e-004f,  1.874487e-005f, -1.510487e-003f, -3.306104e-003f, -2.786092e-003f,
   -3.595075e-005f,  1.822991e-003f,  1.479035e-003f,  9.656934e-004f,  1.462340e-003f,  1.502347e-003f,  5.177892e-004f,  3.851293e-004f,
    1.991244e-003f,  3.296189e-003f,  2.152099e-003f, -9.429620e-004f, -3.537738e-003f, -3.486345e-003f, -7.852142e-004f,  2.105119e-003f,
    2.574249e-003f,  6.043360e-004f, -1.924830e-003f, -3.652144e-003f, -3.651248e-003f, -1.082511e-003f,  2.320017e-003f,  2.331126e-003f,
   -1.793457e-003f, -5.072750e-003f, -4.147855e-003f, -2.001828e-003f, -1.334556e-003f,  3.809859e-004f,  4.201491e-003f,  5.402468e-003f,
    1.890975e-003f, -6.233754e-004f,  1.810994e-003f,  4.464474e-003f,  2.795987e-003f,  5.483484e-005f, -6.718677e-005f,  9.862108e-006f,
   -1.744284e-003f, -2.306475e-003f, -4.161689e-004f,  2.257835e-004f, -1.617228e-003f, -2.400065e-003f, -1.283890e-003f, -1.358535e-003f,
   -2.363567e-003f, -1.110390e-003f,  9.790289e-004f, -1.798170e-004f, -3.116535e-003f, -3.450846e-003f, -2.217486e-003f, -2.805794e-003f,
   -3.383720e-003f, -1.041814e-003f,  1.196302e-003f, -1.939908e-004f, -2.142795e-003f, -7.925931e-004f,  1.618075e-003f,  2.023239e-003f,
    1.883417e-003f,  2.139058e-003f,  4.127857e-004f, -2.730033e-003f, -2.839740e-003f,  3.090251e-004f,  1.940536e-003f,  7.644870e-004f,
   -2.296878e-004f, -8.029150e-004f, -2.487858e-003f, -2.928859e-003f, -2.197123e-004f,  1.103487e-003f, -2.459108e-003f, -5.612694e-003f,
   -3.390419e-003f, -8.268589e-004f, -3.604012e-003f, -7.031199e-003f, -4.565966e-003f,  7.234511e-004f,  2.951779e-003f,  3.654939e-003f,
    6.316790e-003f,  8.336489e-003f,  6.196958e-003f,  1.884467e-003f, -1.246809e-003f, -2.655813e-003f, -2.163411e-003f, -9.504000e-005f,
    1.692407e-004f, -2.990068e-003f, -4.686426e-003f, -1.552254e-003f,  6.179608e-004f, -3.423046e-003f, -7.782970e-003f, -5.235910e-003f,
   -1.621216e-004f, -2.493147e-004f, -3.004767e-003f, -2.215631e-003f, -1.199480e-004f, -1.742084e-003f, -4.617698e-003f, -4.506821e-003f,
   -3.639218e-003f, -4.344427e-003f, -3.176295e-003f,  5.333395e-004f,  3.051942e-004f, -5.072203e-003f, -5.762979e-003f,  3.073707e-003f,
    1.037279e-002f,  5.462397e-003f, -4.078174e-003f, -3.627374e-003f,  5.874191e-003f,  1.020199e-002f,  4.181455e-003f, -1.699392e-003f,
    1.079645e-003f,  6.496149e-003f,  5.016329e-003f, -1.305557e-003f, -3.397068e-003f,  1.313679e-004f,  2.588172e-003f,  1.454763e-003f,
    1.169663e-003f,  3.606149e-003f,  5.108805e-003f,  4.159001e-003f,  3.435470e-003f,  3.255328e-003f,  1.317514e-003f, -6.619671e-004f,
    1.200897e-003f,  4.626465e-003f,  3.883056e-003f,  2.455880e-004f,  7.035949e-005f,  3.245097e-003f,  3.586845e-003f,  5.026752e-005f,
   -2.254439e-003f, -1.593809e-003f, -1.205696e-003f, -2.225894e-003f, -2.672869e-003f, -2.003277e-003f, -6.846084e-004f,  1.903572e-003f,
    4.551367e-003f,  3.936178e-003f,  1.014048e-003f,  1.114884e-003f,  4.254752e-003f,  3.675175e-003f, -2.183453e-003f, -5.622789e-003f,
   -2.116895e-003f,  2.543496e-003f,  2.509748e-003f,  6.328956e-004f,  1.879990e-003f,  5.282884e-003f,  6.965324e-003f,  5.569836e-003f,
    1.714973e-003f, -3.231947e-003f, -6.323320e-003f, -5.092490e-003f, -9.801638e-004f,  2.325174e-003f,  3.043741e-003f,  1.478586e-003f,
   -1.515795e-003f, -3.875681e-003f, -3.203390e-003f, -4.588565e-004f,  4.691438e-004f, -1.562454e-003f, -3.239302e-003f, -1.881604e-003f,
    1.305951e-003f,  3.820715e-003f,  4.400875e-003f,  2.652333e-003f, -9.312418e-004f, -4.359507e-003f, -5.468774e-003f, -3.738378e-003f,
   -4.586229e-004f,  1.645617e-003f, -1.520467e-004f, -4.838180e-003f, -6.940713e-003f, -3.372402e-003f,  1.246352e-003f,  1.041026e-003f,
   -2.109431e-003f, -2.232436e-003f,  7.692004e-004f,  2.013492e-003f,  4.667226e-004f, -5.104305e-004f,  3.476062e-006f,  1.448796e-004f,
    5.184360e-004f,  2.994059e-003f,  5.123546e-003f,  2.375148e-003f, -4.029935e-003f, -7.394896e-003f, -4.612149e-003f, -2.216946e-004f,
    2.554449e-004f, -2.594240e-003f, -4.223742e-003f, -2.991850e-003f, -1.191163e-003f,  1.397045e-004f,  2.796049e-003f,  6.440095e-003f,
    7.185748e-003f,  4.342765e-003f,  3.156821e-003f,  6.096371e-003f,  7.278634e-003f,  1.985361e-003f, -4.310055e-003f, -4.382760e-003f,
   -8.706012e-004f, -3.925998e-004f, -1.689416e-003f,  3.622260e-004f,  3.961379e-003f,  4.018829e-003f,  2.221626e-003f,  3.384399e-003f,
    5.704810e-003f,  4.151950e-003f, -7.996400e-006f, -1.499647e-003f,  5.789526e-004f,  3.471820e-003f,  5.907068e-003f,  7.154098e-003f,
    5.645820e-003f,  2.626630e-003f,  1.749977e-003f,  2.464826e-003f,  5.142882e-004f, -3.451226e-003f, -4.004942e-003f, -1.024334e-003f,
   -4.739767e-004f, -3.598551e-003f, -4.713807e-003f, -1.449429e-003f,  1.770082e-003f,  1.931355e-003f,  9.285711e-004f,  1.164238e-004f,
   -1.131584e-003f, -1.554226e-003f,  4.392083e-004f,  2.432765e-003f,  1.456740e-003f, -4.846141e-004f, -2.090322e-004f,  7.563267e-004f,
    3.017163e-006f, -2.823392e-004f,  2.154011e-003f,  4.075716e-003f,  1.949962e-003f, -1.520499e-003f, -1.860685e-003f,  1.219793e-004f,
    8.112506e-004f, -3.938974e-004f, -1.813659e-003f, -2.492592e-003f, -1.656742e-003f,  1.060198e-003f,  3.283086e-003f,  2.134142e-003f,
   -5.961072e-004f, -5.677756e-004f,  1.890082e-003f,  2.489946e-003f,  5.734264e-004f, -3.965582e-004f,  3.672666e-004f,  2.762330e-004f,
   -7.348252e-004f, -8.616997e-005f,  1.825786e-003f,  1.995665e-003f,  4.956441e-004f,  1.471532e-004f,  1.125552e-003f,  1.163094e-003f,
    2.856267e-004f,  5.223075e-004f,  1.839476e-003f,  2.403259e-003f,  1.715794e-003f,  5.359521e-004f, -5.496801e-004f, -6.306837e-004f,
    8.010492e-004f,  1.800901e-003f,  2.819011e-004f, -1.800968e-003f, -1.321852e-003f,  1.604093e-004f, -5.257998e-004f, -1.435307e-003f,
    4.597729e-004f,  1.441545e-003f, -3.101487e-003f, -7.960686e-003f, -4.636995e-003f,  3.668892e-003f,  5.798831e-003f, -1.584984e-004f,
   -5.543837e-003f, -5.670055e-003f, -3.943441e-003f, -2.877951e-003f, -1.836636e-003f, -1.678089e-003f, -2.251533e-003f,  6.937333e-004f,
    7.427054e-003f,  9.762382e-003f,  3.804408e-003f, -1.636448e-003f,  5.681833e-004f,  3.447925e-003f, -7.995593e-004f, -6.266197e-003f,
   -4.550302e-003f,  2.662542e-004f,  5.544308e-004f, -1.103895e-003f,  8.567849e-004f,  3.626376e-003f,  2.701321e-003f,  7.043693e-004f,
    5.972896e-004f, -4.794685e-004f, -3.514367e-003f, -3.804314e-003f, -4.116129e-004f,  9.573153e-004f, -1.361565e-003f, -2.130555e-003f,
    1.760918e-004f,  7.253063e-004f, -1.951353e-003f, -3.845442e-003f, -3.488649e-003f, -2.795427e-003f, -1.437985e-003f,  1.079822e-003f,
    1.375690e-003f, -1.757575e-003f, -2.911353e-003f,  7.016271e-004f,  3.124289e-003f,  2.069989e-004f, -2.790308e-003f, -1.438359e-003f,
    1.588327e-004f, -1.102020e-003f, -9.523409e-004f,  2.485208e-003f,  3.691029e-003f,  3.902611e-004f, -1.849409e-003f, -3.139595e-004f,
    6.568219e-004f, -5.539531e-004f, -1.563379e-004f,  1.815023e-003f,  8.729111e-004f, -2.207897e-003f, -2.024988e-003f,  1.086523e-003f,
    1.820973e-003f, -1.298075e-004f, -8.923177e-004f, -8.968235e-004f, -2.927134e-003f, -4.813182e-003f, -3.146634e-003f, -5.746130e-004f,
   -1.116444e-003f, -2.595952e-003f, -1.361884e-003f,  2.947205e-004f, -1.384062e-003f, -4.391237e-003f, -4.594698e-003f, -2.521711e-003f,
   -1.373362e-003f, -1.829771e-003f, -2.531749e-003f, -2.644183e-003f, -1.754281e-003f,  5.401157e-005f,  1.256904e-003f,  4.195756e-004f,
   -1.747802e-003f, -3.696075e-003f, -4.785238e-003f, -4.524799e-003f, -2.906876e-003f, -2.161241e-003f, -4.237768e-003f, -6.385978e-003f,
   -4.229581e-003f,  9.119976e-004f,  3.533404e-003f,  2.383498e-003f,  1.151823e-003f,  1.302605e-003f,  7.927072e-004f, -5.453308e-004f,
   -6.865473e-004f, -4.292409e-005f, -8.970644e-004f, -3.095018e-003f, -4.926136e-003f, -6.560481e-003f, -8.444737e-003f, -8.616141e-003f,
   -5.496181e-003f, -1.048158e-003f,  1.809955e-003f,  2.502740e-003f,  1.745947e-003f,  1.614122e-004f, -1.035244e-003f, -9.507764e-004f,
   -6.097695e-004f, -7.791228e-004f,  1.744216e-004f,  2.791655e-003f,  3.734782e-003f,  8.982032e-004f, -1.972238e-003f, -7.724068e-004f,
    2.115842e-003f,  1.647054e-003f, -2.139695e-003f, -4.922600e-003f, -4.135490e-003f, -6.056251e-004f,  3.300488e-003f,  4.847306e-003f,
    3.081646e-003f,  8.030916e-004f,  1.111480e-003f,  2.547738e-003f,  2.021358e-003f,  9.255219e-004f,  2.546727e-003f,  5.146365e-003f,
    4.326950e-003f,  9.429455e-004f, -1.535582e-004f,  1.748387e-003f,  2.761103e-003f,  1.298364e-003f, -2.922257e-004f, -4.481623e-004f,
   -1.624244e-004f, -5.398464e-004f, -1.628825e-003f, -2.819804e-003f, -2.966307e-003f, -1.684338e-003f, -5.288037e-004f, -5.492985e-004f,
   -1.398107e-004f,  1.461995e-003f,  1.455573e-003f, -1.367084e-003f, -2.826072e-003f, -3.259059e-004f,  1.290761e-003f, -2.254013e-003f,
   -6.093058e-003f, -3.633633e-003f,  2.445502e-003f,  4.945035e-003f,  3.116626e-003f,  7.995354e-004f, -1.377083e-003f, -3.893876e-003f,
   -3.602957e-003f,  9.410766e-004f,  4.367727e-003f,  2.131157e-003f, -1.760791e-003f, -1.546137e-003f,  1.072609e-003f,  1.377176e-003f,
    2.230856e-004f,  1.176572e-003f,  3.045479e-003f,  1.843697e-003f, -2.172871e-003f, -4.570967e-003f, -2.636308e-003f,  1.979306e-003f,
    5.680628e-003f,  6.292734e-003f,  4.479282e-003f,  2.358374e-003f,  9.543347e-004f, -4.972126e-005f, -6.705554e-004f, -9.200038e-004f,
   -1.854448e-003f, -3.429168e-003f, -2.905913e-003f,  8.502826e-004f,  3.858320e-003f,  2.433282e-003f, -9.112589e-004f, -2.174124e-003f,
   -2.441533e-003f, -3.698651e-003f, -3.092656e-003f,  1.242092e-003f,  3.831114e-003f, -2.925034e-004f, -6.144469e-003f, -5.781034e-003f,
   -4.877062e-004f,  2.272973e-003f,  3.656760e-004f, -2.028739e-003f, -1.824210e-003f,  5.084127e-004f,  3.172582e-003f,  4.013064e-003f,
    2.247375e-003f,  5.100708e-004f,  1.180749e-003f,  1.677359e-003f, -9.391006e-004f, -3.243137e-003f, -7.361940e-004f,  3.469558e-003f,
    3.810734e-003f,  2.170590e-003f,  3.260179e-003f,  4.637748e-003f,  1.501689e-003f, -3.110860e-003f, -3.230963e-003f, -5.310363e-004f,
   -1.392135e-004f, -7.811249e-004f,  1.340213e-003f,  3.795957e-003f,  2.191200e-003f, -1.397621e-003f, -2.204353e-003f, -6.594344e-004f,
   -6.851961e-005f, -7.634618e-004f, -1.447843e-003f, -2.042978e-003f, -2.080914e-003f, -7.385155e-004f,  2.931506e-004f, -1.068145e-003f,
   -2.684751e-003f, -1.274789e-003f,  1.454349e-003f,  1.771706e-003f,  6.457546e-004f,  1.220420e-003f,  2.405394e-003f,  1.245908e-003f,
   -1.160666e-003f, -1.730473e-003f, -5.442514e-004f,  5.010832e-004f,  1.131619e-003f,  1.588029e-003f,  1.277479e-003f,  2.998166e-004f,
   -8.644049e-004f, -2.944511e-003f, -5.441716e-003f, -4.877258e-003f, -3.947950e-004f,  2.440926e-003f, -4.830194e-004f, -4.389669e-003f,
   -2.985788e-003f,  1.220790e-003f,  1.583477e-003f, -1.802521e-003f, -3.541969e-003f, -2.013522e-003f, -1.999464e-004f,  7.653699e-005f,
   -4.880450e-004f, -1.006761e-003f, -8.239324e-004f,  1.625483e-004f,  2.873443e-004f, -1.904373e-003f, -4.564965e-003f, -4.853891e-003f,
   -3.200975e-003f, -1.625145e-003f, -8.794503e-006f,  1.985168e-003f,  2.191755e-003f, -6.200884e-004f, -3.535748e-003f, -3.531449e-003f,
   -1.793395e-003f, -1.069697e-003f, -1.757573e-003f, -2.624859e-003f, -2.478668e-003f, -4.119825e-004f,  2.726736e-003f,  3.961669e-003f,
    2.299985e-003f,  8.155205e-004f,  1.381158e-003f,  1.221136e-003f, -1.501855e-003f, -3.500361e-003f, -1.926280e-003f,  9.603489e-004f,
    2.380109e-003f,  2.867982e-003f,  2.797547e-003f,  1.168423e-003f, -4.154895e-004f,  6.694899e-004f,  1.997694e-003f, -6.706537e-004f,
   -4.645925e-003f, -3.680389e-003f,  9.443625e-004f,  2.303678e-003f, -4.239421e-004f, -1.854027e-003f, -5.456479e-004f,  3.197155e-004f,
    6.308773e-004f,  2.640983e-003f,  4.636747e-003f,  3.523569e-003f,  1.179774e-003f,  1.055783e-003f,  1.802517e-003f,  7.805781e-004f,
   -8.884357e-005f,  1.856448e-003f,  4.278703e-003f,  3.479080e-003f,  4.184492e-004f, -1.402714e-003f, -1.382607e-003f, -1.790063e-003f,
   -3.950230e-003f, -6.248434e-003f, -5.607907e-003f, -1.471583e-003f,  2.124457e-003f,  1.267058e-003f, -1.864360e-003f, -2.453325e-003f,
   -1.092693e-003f, -1.737340e-003f, -3.456273e-003f, -2.750111e-003f, -2.015066e-003f, -5.532396e-003f, -9.256944e-003f, -6.218100e-003f,
    1.690369e-004f,  1.051899e-003f, -1.840836e-003f,  6.564388e-004f,  7.475436e-003f,  8.036464e-003f,  9.164081e-004f, -3.140109e-003f,
    9.927393e-004f,  5.413464e-003f,  3.085277e-003f, -1.984124e-003f, -2.963997e-003f, -4.697955e-004f,  2.409265e-004f, -2.311187e-003f,
   -4.464519e-003f, -3.189282e-003f, -3.316170e-004f,  4.095548e-004f, -5.799266e-004f,  2.834037e-004f,  2.726920e-003f,  2.271022e-003f,
   -1.122114e-003f, -1.317461e-003f,  3.440396e-003f,  6.227909e-003f,  2.590104e-003f, -2.138020e-003f, -2.109517e-003f,  5.190668e-004f,
    1.743767e-003f,  2.268018e-003f,  2.890102e-003f,  1.443872e-003f, -1.373676e-003f, -1.225035e-003f,  1.704125e-003f,  2.201476e-003f,
   -4.668690e-004f, -1.704750e-003f, -1.070994e-003f, -2.479278e-003f, -4.485642e-003f, -1.357829e-003f,  5.328765e-003f,  7.085895e-003f,
    1.794676e-003f, -3.347272e-003f, -3.279544e-003f, -5.619462e-004f,  1.304690e-003f,  1.986825e-003f,  1.154761e-003f, -1.941698e-003f,
   -5.191965e-003f, -5.074512e-003f, -1.543649e-003f,  1.816552e-003f,  1.857799e-003f, -1.542090e-003f, -5.302897e-003f, -5.264185e-003f,
   -9.556369e-004f,  2.745572e-003f,  1.886580e-003f, -1.084374e-003f, -2.212313e-003f, -2.551309e-003f, -4.269818e-003f, -4.808576e-003f,
   -1.766173e-003f,  1.028906e-003f, -1.178765e-004f, -1.199815e-003f,  2.413190e-003f,  6.351019e-003f,  4.084596e-003f, -9.843635e-004f,
   -5.101502e-004f,  4.700779e-003f,  5.924392e-003f,  6.137604e-004f, -4.262058e-003f, -3.309882e-003f,  7.385976e-004f,  2.772913e-003f,
    1.592724e-003f, -8.989142e-004f, -2.433257e-003f, -1.284316e-003f,  2.397994e-003f,  5.636764e-003f,  5.426732e-003f,  2.496243e-003f,
    1.110824e-004f, -5.341895e-004f, -1.198275e-003f, -2.775449e-003f, -3.402593e-003f, -1.629545e-003f,  7.383322e-004f,  1.004098e-003f,
   -5.774764e-004f, -1.567771e-003f, -1.040167e-003f, -4.795819e-005f,  8.919380e-004f,  1.903389e-003f,  1.766499e-003f, -8.404591e-004f,
   -4.071551e-003f, -4.403437e-003f, -1.836868e-003f, -1.114348e-004f, -1.093943e-003f, -2.479853e-003f, -2.002075e-003f, -5.719057e-004f,
    9.462984e-006f, -2.807055e-004f, -5.319857e-004f, -5.010298e-004f, -5.390134e-004f, -8.975654e-004f, -1.113785e-003f, -6.605453e-008f,
    2.458321e-003f,  3.622206e-003f,  1.390286e-003f, -1.628530e-003f, -1.195874e-003f,  1.785068e-003f,  2.816552e-003f,  1.573859e-003f,
    1.468425e-003f,  1.776866e-003f, -1.548304e-003f, -6.563280e-003f, -6.054432e-003f,  4.790280e-004f,  4.750287e-003f,  2.252878e-003f,
   -1.948170e-003f, -2.807002e-003f, -1.918419e-003f, -1.428579e-003f,  3.033158e-004f,  3.504472e-003f,  4.714464e-003f,  2.677270e-003f,
    3.579442e-004f, -5.802457e-004f, -1.451994e-003f, -2.165192e-003f, -1.083118e-003f,  7.764328e-004f,  9.835757e-004f,  3.385474e-004f,
    1.064208e-003f,  2.059268e-003f,  1.087049e-003f, -5.235289e-004f, -2.436693e-004f,  1.141189e-003f,  1.646128e-003f,  1.675474e-003f,
    1.887004e-003f,  1.076999e-003f, -7.126824e-004f, -9.523531e-004f,  1.021927e-003f,  2.575267e-003f,  2.325397e-003f,  1.676601e-003f,
    1.061346e-003f, -5.097087e-004f, -2.066593e-003f, -1.800079e-003f, -8.496719e-004f, -1.074747e-003f, -8.923461e-004f,  1.407298e-003f,
    2.936806e-003f,  5.994007e-004f, -2.872375e-003f, -3.154612e-003f, -1.242992e-003f, -4.156506e-004f, -1.278235e-004f,  1.361271e-003f,
    2.327236e-003f,  1.109771e-003f,  1.702444e-004f,  1.442176e-003f,  2.019643e-003f, -4.911418e-004f, -2.852448e-003f, -1.542911e-003f,
    1.025625e-003f,  7.838692e-004f, -1.170406e-003f, -1.106738e-003f,  8.225957e-004f,  1.530941e-003f,  6.957382e-004f,  9.201453e-004f,
    2.734618e-003f,  3.467685e-003f,  1.808853e-003f,  1.814474e-004f,  7.441760e-004f,  1.664907e-003f,  3.107481e-004f, -1.821946e-003f,
   -1.421918e-003f,  6.409390e-004f,  7.194420e-004f, -7.378205e-004f,  2.007880e-004f,  3.152155e-003f,  3.115498e-003f, -7.595014e-004f,
   -3.319209e-003f, -2.284233e-003f, -1.572543e-003f, -3.194365e-003f, -3.302794e-003f,  3.140342e-004f,  3.622015e-003f,  2.900900e-003f,
    1.902144e-004f, -1.027179e-003f, -6.365005e-004f,  1.809862e-004f,  1.466958e-003f,  2.861241e-003f,  2.979513e-003f,  1.729320e-003f,
    5.496423e-004f,  5.044244e-005f, -2.968231e-004f, -5.618025e-004f, -4.269697e-004f, -9.029318e-005f,  2.265671e-004f,  5.520321e-004f,
    3.619016e-004f, -9.039179e-004f, -2.368084e-003f, -2.472836e-003f, -9.899687e-004f,  1.088518e-003f,  2.717091e-003f,  2.836912e-003f,
    1.014717e-003f, -1.205515e-003f, -1.861060e-003f, -1.522468e-003f, -1.759744e-003f, -1.630152e-003f,  2.196579e-004f,  1.530220e-003f,
   -3.500975e-004f, -3.103239e-003f, -3.002715e-003f, -1.444712e-003f, -1.770219e-003f, -2.569877e-003f, -8.345842e-004f,  1.555100e-003f,
    1.368008e-003f,  4.273643e-004f,  1.708414e-003f,  3.025434e-003f,  1.250253e-003f, -1.332967e-003f, -1.179791e-003f,  2.060135e-004f,
   -1.930714e-004f, -1.235048e-003f, -4.957734e-004f,  1.054690e-003f,  1.344388e-003f,  7.926775e-004f,  7.730688e-004f,  1.339562e-003f,
    1.902401e-003f,  1.873394e-003f,  7.606385e-004f, -6.403671e-004f, -8.014960e-004f, -2.824223e-004f, -8.231446e-004f, -1.368210e-003f,
    1.719241e-004f,  1.698012e-003f, -7.032349e-005f, -2.504714e-003f, -8.924265e-004f,  2.362252e-003f,  1.491990e-003f, -1.841297e-003f,
   -1.523079e-003f,  1.701214e-003f,  2.190376e-003f, -1.343863e-004f, -1.190442e-003f, -9.754602e-004f, -1.326634e-003f, -3.986823e-004f,
    2.373389e-003f,  2.387042e-003f, -1.587189e-003f, -3.321843e-003f, -3.047332e-004f,  1.182233e-003f, -1.707354e-003f, -2.967210e-003f,
   -2.888212e-004f,  2.005257e-004f, -2.983051e-003f, -3.116535e-003f,  6.358227e-004f,  8.086179e-004f, -2.758465e-003f, -1.142773e-003f,
    6.071931e-003f,  8.102027e-003f,  1.726765e-003f, -3.444492e-003f, -2.049078e-003f,  1.617713e-006f, -1.359156e-003f, -2.359862e-003f,
   -1.028751e-003f, -4.430149e-004f, -9.783308e-004f,  1.200302e-004f,  1.704138e-003f,  4.783720e-004f, -2.014092e-003f, -2.208363e-003f,
   -1.209025e-003f, -1.660111e-003f, -2.087530e-003f, -4.652655e-004f,  1.288645e-003f,  1.333460e-003f,  1.322106e-003f,  2.169799e-003f,
    1.908856e-003f,  2.384965e-004f, -4.175006e-004f,  3.196473e-004f,  5.242724e-004f,  4.101754e-004f,  1.388342e-003f,  1.873156e-003f,
   -2.091163e-004f, -2.587285e-003f, -1.863455e-003f,  7.445434e-004f,  1.785207e-003f,  8.965383e-004f, -3.427118e-004f, -1.550525e-003f,
   -2.276616e-003f, -1.336386e-003f,  3.217759e-004f,  1.903959e-004f, -1.230574e-003f, -1.091151e-003f,  4.860701e-004f,  1.017895e-003f,
    9.507881e-004f,  2.553391e-003f,  4.614041e-003f,  4.189327e-003f,  2.173569e-003f,  1.412848e-003f,  1.423844e-003f,  5.212014e-004f,
    2.194666e-004f,  1.896207e-003f,  2.652976e-003f,  2.397578e-004f, -1.882673e-003f, -2.419598e-004f,  2.110915e-003f,  7.525713e-004f,
   -2.553333e-003f, -3.407634e-003f, -2.070674e-003f, -1.522833e-003f, -1.662086e-003f, -6.296131e-004f,  1.027868e-003f,  1.776529e-003f,
    1.851357e-003f,  1.520067e-003f, -5.625816e-005f, -1.919744e-003f, -1.388243e-003f,  9.397549e-004f,  1.023265e-003f, -1.758139e-003f,
   -2.933107e-003f, -5.040050e-004f,  1.426898e-003f, -4.626950e-004f, -3.508903e-003f, -3.966639e-003f, -2.414759e-003f, -1.146011e-003f,
   -2.884599e-004f,  7.334423e-004f,  1.447963e-003f,  2.045130e-003f,  3.528477e-003f,  5.067372e-003f,  4.637953e-003f,  2.737375e-003f,
    1.877262e-003f,  2.503982e-003f,  3.038332e-003f,  3.163160e-003f,  3.317384e-003f,  2.389371e-003f, -1.372897e-004f, -1.749833e-003f,
   -6.051214e-004f,  9.787984e-004f,  6.913394e-004f,  3.644333e-004f,  1.662165e-003f,  1.939331e-003f, -6.275550e-004f, -2.298414e-003f,
    2.825641e-004f,  3.670980e-003f,  2.933086e-003f, -4.538515e-004f, -1.697670e-003f, -3.753141e-004f,  4.357473e-004f,  1.486358e-004f,
    8.013776e-004f,  2.672019e-003f,  3.655663e-003f,  2.510264e-003f,  3.864503e-004f, -8.273557e-004f, -7.265196e-004f, -6.034595e-004f,
   -1.172086e-003f, -1.096631e-003f,  4.441293e-004f,  1.309183e-003f, -9.555876e-005f, -8.004887e-004f,  2.227802e-003f,  5.616201e-003f,
    4.080304e-003f, -5.081038e-004f, -2.095270e-003f, -7.169968e-004f, -1.304079e-003f, -3.643235e-003f, -2.725654e-003f,  1.440008e-003f,
    3.280193e-003f,  9.751467e-004f, -1.504467e-003f, -1.606929e-003f, -7.490193e-004f, -1.754909e-004f,  1.843843e-004f, -1.843131e-004f,
   -1.178079e-003f, -9.574823e-004f,  8.248003e-004f,  1.618441e-003f,  1.539092e-004f, -1.507079e-003f, -1.689684e-003f, -1.137985e-003f,
   -6.798142e-004f, -4.868803e-004f, -1.098787e-003f, -1.883029e-003f, -6.715248e-004f,  1.968789e-003f,  2.123703e-003f, -6.913890e-004f,
   -1.884884e-003f, -1.509229e-004f, -1.176441e-004f, -3.088494e-003f, -3.759880e-003f, -1.927009e-004f,  2.133617e-003f,  3.143997e-004f,
   -1.299871e-003f, -1.162283e-004f,  4.246715e-004f, -1.266375e-003f, -1.917459e-003f, -5.612030e-004f, -1.284068e-004f, -9.725551e-004f,
   -8.966730e-004f, -8.756100e-004f, -2.878698e-003f, -4.304528e-003f, -2.232288e-003f,  4.471683e-004f,  2.372764e-004f, -8.217213e-004f,
   -6.711266e-004f, -1.963045e-003f, -5.089935e-003f, -4.858790e-003f, -1.811115e-004f,  2.232459e-003f, -5.092380e-004f, -2.337993e-003f,
    1.639998e-004f,  2.010169e-003f,  5.567430e-004f,  5.858472e-004f,  3.877139e-003f,  4.930912e-003f,  1.476871e-003f, -1.408587e-003f,
   -1.130858e-003f, -1.206310e-003f, -2.574899e-003f, -1.509874e-003f,  1.745336e-003f,  2.048337e-003f, -1.163588e-003f, -2.470358e-003f,
    3.789972e-005f,  2.034372e-003f,  9.537639e-004f, -4.485670e-004f,  2.464401e-004f,  1.710834e-003f,  2.151753e-003f,  1.660368e-003f,
    6.782566e-004f, -7.509302e-004f, -1.994717e-003f, -2.221013e-003f, -1.671344e-003f, -1.259950e-003f, -1.266501e-003f, -1.235460e-003f,
   -8.832020e-004f, -6.449996e-004f, -1.206860e-003f, -2.458620e-003f, -3.367067e-003f, -3.276522e-003f, -2.547811e-003f, -1.451768e-003f,
    1.940236e-004f,  1.731329e-003f,  1.960581e-003f,  1.330945e-003f,  1.419015e-003f,  1.875777e-003f,  9.783497e-004f, -6.388174e-004f,
   -6.162174e-004f,  6.574941e-004f,  4.414393e-004f, -1.469623e-003f, -2.613224e-003f, -2.249980e-003f, -1.494313e-003f, -1.306432e-004f,
    2.040954e-003f,  2.432556e-003f, -6.365161e-004f, -3.555304e-003f, -2.113127e-003f,  1.649687e-003f,  2.653109e-003f,  4.931667e-004f,
   -1.298702e-003f, -1.402940e-003f, -1.191809e-003f, -1.111792e-003f, -7.539174e-004f, -6.819101e-004f, -1.162851e-003f, -1.107247e-003f,
   -1.927638e-004f,  3.954976e-004f,  3.701902e-004f,  6.430086e-004f,  9.233870e-004f,  2.152072e-004f, -5.175048e-004f,  3.749586e-004f,
    1.841732e-003f,  1.511982e-003f, -2.358625e-004f, -8.393943e-004f,  5.998965e-004f,  2.734031e-003f,  4.157547e-003f,  4.036973e-003f,
    2.037271e-003f, -5.550263e-004f, -1.274308e-003f,  4.624310e-004f,  2.326686e-003f,  2.161175e-003f,  5.346554e-004f, -5.620591e-004f,
   -2.726086e-004f,  5.290183e-004f,  6.426898e-004f,  2.507997e-004f,  7.309605e-004f,  2.194857e-003f,  2.561865e-003f,  7.204413e-004f,
   -1.237725e-003f, -1.442515e-003f, -1.577340e-003f, -3.444046e-003f, -4.877176e-003f, -3.282647e-003f, -5.956413e-004f, -8.326821e-005f,
   -8.441824e-004f, -2.643370e-004f,  7.888002e-004f,  9.476738e-005f, -1.311994e-003f, -1.353485e-003f, -1.008270e-003f, -1.887396e-003f,
   -2.609049e-003f, -1.609361e-003f, -5.646384e-004f, -1.275871e-003f, -2.122960e-003f, -1.024046e-003f,  8.757320e-004f,  1.386196e-003f,
    5.685546e-004f, -4.315468e-004f, -1.430710e-003f, -2.366490e-003f, -2.567989e-003f, -1.990526e-003f, -1.361944e-003f, -7.480818e-004f,
    2.836823e-004f,  1.232563e-003f,  1.069059e-003f, -2.122293e-004f, -1.544030e-003f, -1.700601e-003f,  2.845187e-005f,  2.747342e-003f,
    3.743338e-003f,  1.439031e-003f, -1.893456e-003f, -2.935437e-003f, -2.022099e-003f, -1.845755e-003f, -2.498363e-003f, -1.800634e-003f,
    9.644154e-005f,  7.314555e-004f, -2.719398e-004f, -8.787307e-004f, -5.150201e-004f, -4.086144e-004f, -4.227765e-004f,  5.383001e-004f,
    1.366505e-003f,  3.596333e-005f, -2.261492e-003f, -2.454850e-003f, -9.160890e-004f, -9.612467e-004f, -2.766581e-003f, -2.664962e-003f,
    2.729539e-004f,  1.861199e-003f, -6.209004e-004f, -3.838562e-003f, -3.678816e-003f, -1.474008e-003f, -9.633992e-004f, -1.880985e-003f,
   -1.183788e-003f,  1.062113e-003f,  1.787974e-003f,  2.975192e-004f, -7.727149e-004f,  5.928187e-005f,  1.281695e-003f,  1.338519e-003f,
    5.356952e-004f, -1.721839e-004f, -1.259368e-004f,  9.319041e-004f,  1.972769e-003f,  1.066684e-003f, -1.677306e-003f, -3.374541e-003f,
   -2.330154e-003f, -4.119686e-004f,  3.600809e-004f,  7.221338e-004f,  1.623027e-003f,  1.973985e-003f,  1.165855e-003f,  5.655860e-004f,
    4.789780e-004f, -7.752877e-004f, -2.916392e-003f, -2.948976e-003f, -3.240819e-004f,  1.497935e-003f,  6.270296e-004f, -6.083069e-004f,
   -4.490087e-004f, -3.707546e-004f, -1.071663e-003f, -7.119207e-004f,  8.718261e-004f,  1.061582e-003f, -5.467286e-004f, -8.692722e-004f,
    1.182106e-003f,  2.743493e-003f,  2.195226e-003f,  1.580688e-003f,  2.218832e-003f,  2.460735e-003f,  1.374128e-003f,  4.591437e-004f,
    4.274420e-004f,  1.453595e-004f, -4.481931e-004f, -1.179797e-004f,  7.228551e-004f,  5.848833e-004f,  1.419871e-004f,  9.717260e-004f,
    1.772901e-003f,  1.866542e-004f, -2.397864e-003f, -2.514675e-003f, -4.617818e-004f,  2.144518e-004f, -1.401785e-003f, -2.735279e-003f,
   -2.333883e-003f, -1.214157e-003f, -1.374089e-004f,  7.736580e-004f,  6.336634e-004f, -6.803611e-004f, -1.159589e-003f,  8.669346e-005f,
    6.037946e-004f, -1.103846e-003f, -2.171638e-003f, -1.235385e-004f,  2.392665e-003f,  1.963966e-003f,  1.097808e-004f,  4.251372e-006f,
    8.200138e-004f,  1.640697e-004f, -9.071391e-004f, -1.403565e-004f,  1.330394e-003f,  1.136105e-003f, -3.086087e-005f, -2.217056e-004f,
    1.036524e-004f, -3.071191e-004f, -7.224628e-004f, -3.606868e-004f, -5.689932e-004f, -2.315317e-003f, -3.955842e-003f, -3.865565e-003f,
   -2.946183e-003f, -2.588327e-003f, -2.438778e-003f, -1.809039e-003f, -1.165444e-003f, -8.817548e-004f, -3.529147e-004f,  6.483648e-004f,
    1.267349e-003f,  9.355767e-004f,  3.010775e-004f,  3.247514e-004f,  1.093293e-003f,  1.719045e-003f,  1.288106e-003f, -1.164022e-005f,
   -1.060769e-003f, -1.342474e-003f, -1.396282e-003f, -1.386019e-003f, -7.377124e-004f,  2.733234e-004f,  5.390286e-004f,  1.842766e-004f,
    2.389123e-004f,  1.843870e-004f, -1.045800e-003f, -1.914926e-003f, -2.175892e-004f,  2.241488e-003f,  1.801110e-003f, -6.961567e-004f,
   -1.255899e-003f,  1.897243e-004f,  2.946540e-004f, -8.423225e-004f, -2.047900e-004f,  1.429796e-003f,  5.735314e-004f, -1.774579e-003f,
   -1.429651e-003f,  1.089122e-003f,  1.384333e-003f, -7.949084e-004f, -1.692413e-003f, -9.446774e-004f, -1.638975e-003f, -3.637518e-003f,
   -3.609643e-003f, -1.188245e-003f,  8.348738e-004f,  1.642897e-003f,  2.504302e-003f,  2.920355e-003f,  1.410345e-003f, -9.322518e-004f,
   -1.549555e-003f, -7.167079e-005f,  1.792221e-003f,  2.642186e-003f,  2.023208e-003f,  4.283804e-004f, -5.483350e-004f, -4.715403e-005f,
    3.164447e-004f, -9.938220e-004f, -2.293862e-003f, -1.338697e-003f,  3.785447e-004f, -1.201834e-004f, -2.113561e-003f, -2.370995e-003f,
   -4.992024e-004f,  8.318070e-004f,  3.549445e-004f, -4.807308e-004f, -2.911063e-004f,  6.996592e-004f,  1.602089e-003f,  1.752647e-003f,
    1.148260e-003f,  7.095044e-004f,  1.220260e-003f,  1.905103e-003f,  1.438733e-003f,  2.537878e-004f,  1.775389e-004f,  1.766020e-003f,
    3.476799e-003f,  3.583613e-003f,  1.970841e-003f,  9.969371e-005f, -4.058221e-004f,  5.738888e-004f,  1.507788e-003f,  1.305403e-003f,
    5.264834e-004f, -1.173699e-004f, -8.539168e-004f, -1.485811e-003f, -8.968292e-004f,  8.101569e-004f,  1.773305e-003f,  1.234265e-003f,
    6.668034e-004f,  9.050544e-004f,  7.562268e-004f, -2.907249e-004f, -7.387444e-004f,  1.448837e-004f,  8.525677e-004f,  3.059601e-004f,
   -4.017866e-004f, -1.816291e-004f,  3.165349e-004f,  2.702040e-004f,  8.799346e-005f,  2.660760e-004f,  3.893624e-004f,  6.152331e-005f,
   -3.382562e-004f, -3.456293e-004f, -1.269118e-005f,  3.934295e-004f,  6.571366e-004f,  5.924869e-004f,  2.343161e-004f, -8.966690e-005f,
   -1.747140e-004f, -1.587701e-004f, -1.650960e-004f, -1.061931e-004f,  2.922199e-005f,  7.800810e-005f, -8.454802e-006f, -8.773646e-005f,
   -7.476817e-005f, -2.542967e-005f,  8.816222e-006f,  2.757904e-005f,  2.552472e-005f,  4.452638e-006f, -8.946349e-006f, -5.201500e-006f
};

const HRTF_DATA SpatialDecMPSVTHRTF =
{
  44100,
  2048,
  {
    {
      {
          2.850812e-001f,  2.858675e-001f,  2.878558e-001f,  2.908104e-001f,  2.965263e-001f,  3.050316e-001f,  3.136006e-001f,
          3.220602e-001f,  3.374044e-001f,  3.573224e-001f,  3.369616e-001f,  3.290336e-001f,  3.260348e-001f,  3.267194e-001f,
          3.521396e-001f,  4.082165e-001f,  4.336186e-001f,  4.092240e-001f,  3.340236e-001f,  2.462363e-001f,  1.829524e-001f,
          1.221038e-001f,  2.100100e-001f,  2.470339e-001f,  2.991193e-001f,  2.981693e-001f,  2.944358e-001f,  2.915784e-001f
      },
      {
          2.270468e-001f,  2.298082e-001f,  2.337272e-001f,  2.355047e-001f,  2.333751e-001f,  2.246904e-001f,  2.110276e-001f,
          1.936715e-001f,  1.638608e-001f,  1.337278e-001f,  1.525763e-001f,  1.929635e-001f,  2.043780e-001f,  1.886358e-001f,
          1.592575e-001f,  1.286288e-001f,  1.148413e-001f,  1.159458e-001f,  9.244222e-002f,  7.019780e-002f,  4.363479e-002f,
          2.624535e-002f,  6.024440e-002f,  1.382806e-001f,  1.353934e-001f,  1.409476e-001f,  1.494170e-001f,  1.567384e-001f
      },
      {
          9.994319e-001f,  9.987401e-001f,  9.985269e-001f,  9.984685e-001f,  9.937740e-001f,  9.942306e-001f,  9.946753e-001f,
          9.951487e-001f,  9.853902e-001f,  9.988029e-001f,  9.861931e-001f,  9.756664e-001f,  9.746329e-001f,  9.745016e-001f,
          9.770908e-001f,  9.908894e-001f,  9.967840e-001f,  9.596103e-001f,  9.645983e-001f,  9.420963e-001f,  9.649582e-001f,
          9.325311e-001f,  9.445526e-001f,  6.408637e-001f,  7.578863e-001f,  6.135577e-001f,  4.936112e-001f,  7.887919e-001f
      },
      {
          4.102137e-002f,  1.908030e-001f,  3.785371e-001f,  5.754121e-001f,  8.697632e-001f,  1.246787e+000f,  1.603471e+000f,
          1.937885e+000f,  2.376395e+000f,  2.674843e+000f,  2.901672e+000f,  3.549604e+000f,  4.332158e+000f,  5.112403e+000f,
          5.853863e+000f,  6.356767e+000f,  6.616996e+000f,  7.219518e+000f,  8.269819e+000f,  9.251158e+000f,  1.036818e+001f,
          1.120106e+001f,  1.249749e+001f,  1.455441e+001f,  1.722412e+001f,  2.020885e+001f,  2.374648e+001f,  2.682302e+001f,
      },
      MPSVTImpulseLeft1,
      MPSVTImpulseRight1
    },
    {
      {
          2.270468e-001f,  2.298082e-001f,  2.337272e-001f,  2.355047e-001f,  2.333751e-001f,  2.246904e-001f,  2.110276e-001f,
          1.936715e-001f,  1.638608e-001f,  1.337278e-001f,  1.525763e-001f,  1.929635e-001f,  2.043780e-001f,  1.886358e-001f,
          1.592575e-001f,  1.286288e-001f,  1.148413e-001f,  1.159458e-001f,  9.244222e-002f,  7.019780e-002f,  4.363479e-002f,
          2.624535e-002f,  6.024440e-002f,  1.382806e-001f,  1.353934e-001f,  1.409476e-001f,  1.494170e-001f,  1.567384e-001f
      },
      {
          2.850812e-001f,  2.858675e-001f,  2.878558e-001f,  2.908104e-001f,  2.965263e-001f,  3.050316e-001f,  3.136006e-001f,
          3.220602e-001f,  3.374044e-001f,  3.573224e-001f,  3.369616e-001f,  3.290336e-001f,  3.260348e-001f,  3.267194e-001f,
          3.521396e-001f,  4.082165e-001f,  4.336186e-001f,  4.092240e-001f,  3.340236e-001f,  2.462363e-001f,  1.829524e-001f,
          1.221038e-001f,  2.100100e-001f,  2.470339e-001f,  2.991193e-001f,  2.981693e-001f,  2.944358e-001f,  2.915784e-001f
      },
      {
          9.994319e-001f,  9.987401e-001f,  9.985269e-001f,  9.984685e-001f,  9.937740e-001f,  9.942306e-001f,  9.946753e-001f,
          9.951487e-001f,  9.853902e-001f,  9.988029e-001f,  9.861931e-001f,  9.756664e-001f,  9.746329e-001f,  9.745016e-001f,
          9.770908e-001f,  9.908894e-001f,  9.967840e-001f,  9.596103e-001f,  9.645983e-001f,  9.420963e-001f,  9.649582e-001f,
          9.325311e-001f,  9.445526e-001f,  6.408637e-001f,  7.578863e-001f,  6.135577e-001f,  4.936112e-001f,  7.887919e-001f
      },
      {
         -4.102137e-002f, -1.908030e-001f, -3.785371e-001f, -5.754121e-001f, -8.697632e-001f, -1.246787e+000f, -1.603471e+000f,
         -1.937885e+000f, -2.376395e+000f, -2.674843e+000f, -2.901672e+000f, -3.549604e+000f, -4.332158e+000f, -5.112403e+000f,
         -5.853863e+000f, -6.356767e+000f, -6.616996e+000f, -7.219518e+000f, -8.269819e+000f, -9.251158e+000f, -1.036818e+001f,
         -1.120106e+001f, -1.249749e+001f, -1.455441e+001f, -1.722412e+001f, -2.020885e+001f, -2.374648e+001f, -2.682302e+001f
      },
      MPSVTImpulseLeft2,
      MPSVTImpulseRight2
    },
    {
      {
          2.293430e-001f,  2.312802e-001f,  2.361003e-001f,  2.431356e-001f,  2.557123e-001f,  2.701312e-001f,  2.751582e-001f,
          2.675697e-001f,  2.402348e-001f,  2.145230e-001f,  2.443980e-001f,  3.181209e-001f,  3.760572e-001f,  3.726799e-001f,
          3.208119e-001f,  2.701217e-001f,  2.770384e-001f,  3.305479e-001f,  2.364471e-001f,  1.266015e-001f,  9.819428e-002f,
          1.099405e-001f,  1.773550e-001f,  3.219727e-001f,  1.671431e-001f,  1.133626e-001f,  1.305375e-001f,  1.453719e-001f
      },
      {
          2.579883e-001f,  2.593808e-001f,  2.627546e-001f,  2.674398e-001f,  2.749970e-001f,  2.823774e-001f,  2.842397e-001f,
          2.810543e-001f,  2.714921e-001f,  2.595282e-001f,  2.553604e-001f,  2.644859e-001f,  2.948089e-001f,  3.448756e-001f,
          3.739612e-001f,  3.618969e-001f,  3.159805e-001f,  2.274627e-001f,  2.354855e-001f,  1.830667e-001f,  1.435277e-001f,
          1.026192e-001f,  7.523473e-002f,  1.675723e-001f,  4.785279e-001f,  5.064277e-001f,  5.062540e-001f,  5.061078e-001f
      },
      {
          9.999969e-001f,  9.999940e-001f,  9.999933e-001f,  9.999921e-001f,  9.999576e-001f,  9.999413e-001f,  9.999229e-001f,
          9.999008e-001f,  9.993760e-001f,  9.985379e-001f,  9.974791e-001f,  9.968878e-001f,  9.966895e-001f,  9.971755e-001f,
          9.976183e-001f,  9.961644e-001f,  9.927977e-001f,  9.592970e-001f,  9.676480e-001f,  9.961465e-001f,  9.958284e-001f,
          9.239808e-001f,  9.494379e-001f,  7.837238e-001f,  7.476776e-001f,  9.837959e-001f,  9.952584e-001f,  9.992663e-001f
      },
      {
          3.035305e-003f,  1.330101e-002f,  2.336941e-002f,  3.023255e-002f,  3.165323e-002f,  1.324131e-002f, -2.488799e-002f,
         -6.722599e-002f, -8.665890e-002f,  3.226986e-002f,  1.772032e-001f,  9.485825e-002f, -1.716610e-001f, -3.773117e-001f,
         -3.614209e-001f, -1.512605e-001f,  1.558928e-001f, -9.933864e-002f, -7.489954e-001f, -3.241143e-001f, -2.346209e-001f,
          3.599416e-001f, -5.586099e-001f, -1.533081e+000f, -1.950396e+000f, -7.291706e-001f, -3.127735e-001f, -1.260709e-001f
      },
      MPSVTImpulseLeft3,
      MPSVTImpulseRight3
    },
    {
      {
          3.902883e-001f,  3.875820e-001f,  3.843835e-001f,  3.834925e-001f,  3.858822e-001f,  3.933179e-001f,  4.046426e-001f,
          4.192524e-001f,  4.459345e-001f,  4.788908e-001f,  4.786582e-001f,  4.192866e-001f,  3.415112e-001f,  3.112800e-001f,
          3.186678e-001f,  3.206771e-001f,  3.291750e-001f,  3.800872e-001f,  5.110926e-001f,  6.197523e-001f,  6.595696e-001f,
          6.794698e-001f,  6.407468e-001f,  5.267657e-001f,  3.638894e-001f,  3.474767e-001f,  3.393170e-001f,  3.321770e-001f
      },
      {
          3.305226e-001f,  3.222428e-001f,  3.036736e-001f,  2.806889e-001f,  2.484783e-001f,  2.173446e-001f,  2.016596e-001f,
          1.890675e-001f,  1.514964e-001f,  1.155174e-001f,  9.482091e-002f,  7.491277e-002f,  5.565655e-002f,  5.618742e-002f,
          7.940945e-002f,  1.025357e-001f,  1.166536e-001f,  1.124402e-001f,  7.163155e-002f,  3.151317e-002f,  2.901138e-002f,
          2.592821e-002f,  6.719798e-002f,  9.734550e-002f,  4.467587e-002f,  3.304341e-002f,  3.414060e-002f,  3.513714e-002f
      },
      {
          9.925344e-001f,  9.861179e-001f,  9.868033e-001f,  9.879566e-001f,  9.565151e-001f,  9.616059e-001f,  9.606374e-001f,
          9.561236e-001f,  8.623705e-001f,  8.885070e-001f,  8.947801e-001f,  8.926489e-001f,  9.048420e-001f,  8.973858e-001f,
          8.580226e-001f,  8.329928e-001f,  8.212483e-001f,  4.027787e-001f,  5.041847e-001f,  7.138358e-001f,  6.353890e-001f,
          4.105748e-001f,  2.002901e-001f,  1.360745e-001f,  2.697101e-001f,  1.680395e-001f,  2.215640e-002f,  1.514807e-001f
      },
      {
          1.498290e-001f,  6.736648e-001f,  1.262998e+000f,  1.827481e+000f,  2.621236e+000f,  3.607228e+000f,  4.570615e+000f,
          5.585086e+000f,  7.053185e+000f,  8.753207e+000f,  1.038086e+001f,  1.201476e+001f,  1.363261e+001f,  1.510447e+001f,
          1.683683e+001f,  1.881443e+001f,  2.092034e+001f,  2.414179e+001f,  2.819575e+001f,  3.137761e+001f,  3.399026e+001f,
          3.810448e+001f,  4.225436e+001f,  4.932470e+001f,  5.780070e+001f,  6.710917e+001f,  7.848865e+001f,  8.838540e+001f
      },
      MPSVTImpulseLeft4,
      MPSVTImpulseRight4
    },
    {
      {
          3.305226e-001f,  3.222428e-001f,  3.036736e-001f,  2.806889e-001f,  2.484783e-001f,  2.173446e-001f,  2.016596e-001f,
          1.890675e-001f,  1.514964e-001f,  1.155174e-001f,  9.482091e-002f,  7.491277e-002f,  5.565655e-002f,  5.618742e-002f,
          7.940945e-002f,  1.025357e-001f,  1.166536e-001f,  1.124402e-001f,  7.163155e-002f,  3.151317e-002f,  2.901138e-002f,
          2.592821e-002f,  6.719798e-002f,  9.734550e-002f,  4.467587e-002f,  3.304341e-002f,  3.414060e-002f,  3.513714e-002f
      },
      {
          3.902883e-001f,  3.875820e-001f,  3.843835e-001f,  3.834925e-001f,  3.858822e-001f,  3.933179e-001f,  4.046426e-001f,
          4.192524e-001f,  4.459345e-001f,  4.788908e-001f,  4.786582e-001f,  4.192866e-001f,  3.415112e-001f,  3.112800e-001f,
          3.186678e-001f,  3.206771e-001f,  3.291750e-001f,  3.800872e-001f,  5.110926e-001f,  6.197523e-001f,  6.595696e-001f,
          6.794698e-001f,  6.407468e-001f,  5.267657e-001f,  3.638894e-001f,  3.474767e-001f,  3.393170e-001f,  3.321770e-001f
      },
      {
          9.925344e-001f,  9.861179e-001f,  9.868033e-001f,  9.879566e-001f,  9.565151e-001f,  9.616059e-001f,  9.606374e-001f,
          9.561236e-001f,  8.623705e-001f,  8.885070e-001f,  8.947801e-001f,  8.926489e-001f,  9.048420e-001f,  8.973858e-001f,
          8.580226e-001f,  8.329928e-001f,  8.212483e-001f,  4.027787e-001f,  5.041847e-001f,  7.138358e-001f,  6.353890e-001f,
          4.105748e-001f,  2.002901e-001f,  1.360745e-001f,  2.697101e-001f,  1.680395e-001f,  2.215640e-002f,  1.514807e-001f
      },
      {
         -1.498290e-001f, -6.736648e-001f, -1.262998e+000f, -1.827481e+000f, -2.621236e+000f, -3.607228e+000f, -4.570615e+000f,
         -5.585086e+000f, -7.053185e+000f, -8.753207e+000f, -1.038086e+001f, -1.201476e+001f, -1.363261e+001f, -1.510447e+001f,
         -1.683683e+001f, -1.881443e+001f, -2.092034e+001f, -2.414179e+001f, -2.819575e+001f, -3.137761e+001f, -3.399026e+001f,
         -3.810448e+001f, -4.225436e+001f, -4.932470e+001f, -5.780070e+001f, -6.710917e+001f, -7.848865e+001f, -8.838540e+001f
      },
      MPSVTImpulseLeft5,
      MPSVTImpulseRight5
    }
  },
  2048,
  MPSVTReverbLeft,
  MPSVTReverbRight
};

static const float TestImpulseLeft1[] = 
{
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  1.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
};

static const float TestImpulseRight1[] = 
{
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  1.000000e-006f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
};

static const float TestImpulseLeft2[] = 
{
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  1.000000e-006f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
};

static const float TestImpulseRight2[] = 
{
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  1.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
};

static const float TestImpulseLeft3[] = 
{
   1.628655e-004f, -1.954385e-004f,  6.188886e-004f, -7.817540e-004f,  1.270351e-003f, -1.824093e-003f,  2.410408e-003f, -3.289881e-003f, 
   3.908771e-003f, -4.462513e-003f,  5.244266e-003f,  9.771925e-004f,  1.733214e-001f,  1.975883e-001f, -2.202592e-001f, -8.240991e-003f, 
   6.351752e-003f, -1.670673e-001f,  2.372949e-001f,  1.949825e-001f,  7.596043e-002f,  3.838738e-001f,  3.605515e-001f, -2.128977e-001f, 
  -1.664159e-001f,  1.478492e-001f, -2.660244e-001f, -4.410070e-001f, -6.599307e-002f, -4.446226e-002f, -2.389562e-001f, -4.159583e-002f, 
   9.811013e-002f,  2.605846e-003f,  3.530923e-002f,  1.371979e-001f,  1.070352e-001f,  4.426682e-002f,  8.035780e-002f,  5.026027e-002f, 
  -2.947864e-002f, -6.221459e-003f,  3.957630e-002f, -1.912040e-002f, -5.527652e-002f, -3.573267e-002f, -4.022776e-002f, -6.954353e-002f, 
  -8.830563e-002f, -7.889201e-002f, -6.664453e-002f, -4.335478e-002f, -8.240991e-003f,  3.713332e-003f,  6.319179e-003f,  2.218227e-002f, 
   4.267074e-002f,  4.478799e-002f,  3.026040e-002f,  2.267087e-002f,  1.801292e-002f,  4.918536e-003f, -7.947833e-003f, -7.328944e-003f, 
  -1.543965e-002f, -2.667736e-002f, -2.276859e-002f, -2.397380e-002f, -2.999981e-002f, -2.397380e-002f, -1.765461e-002f, -1.970672e-002f, 
  -1.456017e-002f, -2.377835e-003f,  2.475555e-003f,  5.113975e-003f,  1.146573e-002f,  1.788262e-002f,  1.364813e-002f,  3.648185e-003f, 
  -1.107485e-003f, -1.954385e-004f, -3.387601e-003f, -9.967364e-003f, -8.892453e-003f, -1.013023e-002f, -1.286636e-002f, -9.511341e-003f, 
  -5.374559e-003f, -5.700290e-003f, -4.788243e-003f, -1.628655e-004f, -1.954385e-003f, -8.012979e-003f, -4.429940e-003f,  1.921812e-003f, 
   1.856665e-003f,  5.211694e-004f,  1.172632e-003f, -1.205204e-003f, -4.723097e-003f, -3.876197e-003f, -4.983682e-003f, -6.351752e-003f, 
  -5.830582e-003f, -7.035786e-003f, -7.817540e-003f, -4.169355e-003f,  8.143272e-004f,  2.410408e-003f,  3.908771e-004f, -1.433216e-003f, 
  -1.074912e-003f, -3.094443e-003f, -6.579763e-003f, -6.026021e-003f, -5.146547e-003f, -6.254033e-003f, -5.276840e-003f, -2.703566e-003f, 
  -1.661227e-003f, -8.794733e-004f, -6.840347e-004f, -1.726374e-003f, -1.889239e-003f, -1.237777e-003f, -1.824093e-003f, -1.889239e-003f
};

static const float TestImpulseRight3[] = 
{
   1.628655e-004f, -1.954385e-004f,  6.188886e-004f, -7.817540e-004f,  1.270351e-003f, -1.824093e-003f,  2.410408e-003f, -3.289881e-003f, 
   3.908771e-003f, -4.462513e-003f,  5.244266e-003f,  9.771925e-004f,  1.733214e-001f,  1.975883e-001f, -2.202592e-001f, -8.240991e-003f, 
   6.351752e-003f, -1.670673e-001f,  2.372949e-001f,  1.949825e-001f,  7.596043e-002f,  3.838738e-001f,  3.605515e-001f, -2.128977e-001f, 
  -1.664159e-001f,  1.478492e-001f, -2.660244e-001f, -4.410070e-001f, -6.599307e-002f, -4.446226e-002f, -2.389562e-001f, -4.159583e-002f, 
   9.811013e-002f,  2.605846e-003f,  3.530923e-002f,  1.371979e-001f,  1.070352e-001f,  4.426682e-002f,  8.035780e-002f,  5.026027e-002f, 
  -2.947864e-002f, -6.221459e-003f,  3.957630e-002f, -1.912040e-002f, -5.527652e-002f, -3.573267e-002f, -4.022776e-002f, -6.954353e-002f, 
  -8.830563e-002f, -7.889201e-002f, -6.664453e-002f, -4.335478e-002f, -8.240991e-003f,  3.713332e-003f,  6.319179e-003f,  2.218227e-002f, 
   4.267074e-002f,  4.478799e-002f,  3.026040e-002f,  2.267087e-002f,  1.801292e-002f,  4.918536e-003f, -7.947833e-003f, -7.328944e-003f, 
  -1.543965e-002f, -2.667736e-002f, -2.276859e-002f, -2.397380e-002f, -2.999981e-002f, -2.397380e-002f, -1.765461e-002f, -1.970672e-002f, 
  -1.456017e-002f, -2.377835e-003f,  2.475555e-003f,  5.113975e-003f,  1.146573e-002f,  1.788262e-002f,  1.364813e-002f,  3.648185e-003f, 
  -1.107485e-003f, -1.954385e-004f, -3.387601e-003f, -9.967364e-003f, -8.892453e-003f, -1.013023e-002f, -1.286636e-002f, -9.511341e-003f, 
  -5.374559e-003f, -5.700290e-003f, -4.788243e-003f, -1.628655e-004f, -1.954385e-003f, -8.012979e-003f, -4.429940e-003f,  1.921812e-003f, 
   1.856665e-003f,  5.211694e-004f,  1.172632e-003f, -1.205204e-003f, -4.723097e-003f, -3.876197e-003f, -4.983682e-003f, -6.351752e-003f, 
  -5.830582e-003f, -7.035786e-003f, -7.817540e-003f, -4.169355e-003f,  8.143272e-004f,  2.410408e-003f,  3.908771e-004f, -1.433216e-003f, 
  -1.074912e-003f, -3.094443e-003f, -6.579763e-003f, -6.026021e-003f, -5.146547e-003f, -6.254033e-003f, -5.276840e-003f, -2.703566e-003f, 
  -1.661227e-003f, -8.794733e-004f, -6.840347e-004f, -1.726374e-003f, -1.889239e-003f, -1.237777e-003f, -1.824093e-003f, -1.889239e-003f
};

static const float TestImpulseLeft4[] = 
{
   7.263798e-003f, -1.283379e-002f,  1.693800e-002f, -7.491810e-004f,  4.386943e-001f,  2.094124e-001f, -7.255980e-001f, -1.513997e-001f, 
   4.386292e-001f,  7.201910e-002f,  9.749125e-002f,  6.702238e-001f,  1.688263e-001f, -4.565118e-001f,  2.057642e-001f,  5.232215e-001f, 
  -9.521113e-002f, -3.263172e-001f, -1.190872e-001f, -2.565782e-001f, -1.673280e-001f, -1.693800e-003f, -2.508127e-001f, -3.175875e-001f, 
  -6.755657e-002f,  9.729581e-002f,  4.267074e-002f,  4.117238e-002f,  1.467417e-001f,  1.214976e-001f,  6.381067e-002f,  7.683990e-002f, 
   1.794777e-002f, -9.817528e-002f, -5.341986e-002f, -1.579794e-002f, -5.983676e-002f, -1.045596e-001f, -9.511341e-002f, -5.517880e-002f, 
  -2.843630e-002f,  5.309413e-003f,  6.644910e-003f, -9.967364e-003f, -8.338710e-003f,  1.478818e-002f,  2.221484e-002f,  2.267087e-002f, 
   2.609104e-002f,  2.488584e-002f,  1.084684e-002f, -5.407132e-003f, -4.299647e-003f,  2.052104e-003f, -1.726374e-002f, -2.638420e-002f, 
  -2.921806e-002f, -3.859910e-002f, -3.872940e-002f, -1.749174e-002f, -3.257308e-005f, -5.439705e-003f, -1.140058e-002f, -3.908771e-003f, 
   8.403856e-003f,  7.394091e-003f,  1.358298e-002f,  2.159595e-002f,  1.407157e-002f, -2.964151e-003f, -3.257308e-003f, -1.368069e-003f, 
  -9.511341e-003f, -7.328944e-003f,  3.289881e-003f, -5.765436e-003f, -1.732889e-002f, -1.133543e-002f, -4.071636e-003f, -4.201927e-003f, 
   7.491810e-004f,  5.928301e-003f, -2.768713e-003f, -8.436430e-003f, -4.169355e-003f,  6.514617e-004f,  3.289881e-003f,  8.469002e-003f, 
   5.439705e-003f, -4.951108e-003f, -1.039081e-002f, -6.188886e-003f, -1.107485e-003f,  8.143272e-004f, -2.605846e-003f, -9.902218e-003f, 
  -1.664484e-002f, -1.556993e-002f, -4.234501e-003f,  4.983682e-003f,  2.996724e-003f, -5.341986e-003f, -9.739353e-003f, -9.902218e-003f, 
  -4.690524e-003f,  2.280116e-003f,  3.192162e-003f, -4.039062e-003f, -1.146573e-002f, -1.299666e-002f, -7.752394e-003f, -9.120463e-004f, 
   2.605846e-003f,  6.188886e-004f, -4.136782e-003f, -5.211694e-003f, -8.794733e-004f,  4.136782e-003f,  3.094443e-003f, -2.280116e-004f, 
  -2.475555e-003f, -4.527659e-003f, -4.885963e-003f, -7.166079e-004f,  2.442981e-003f,  9.446195e-004f, -1.498362e-003f, -2.247543e-003f
};

static const float TestImpulseRight4[] = 
{
   0.000000e+000f,  0.000000e+000f,  3.257308e-005f,  3.257308e-005f,  3.257308e-005f,  3.257308e-005f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f, -3.257308e-005f,  3.257308e-005f,  0.000000e+000f,  0.000000e+000f,  9.771925e-005f,  3.257308e-005f, 
   3.257308e-005f,  6.514617e-005f,  9.771925e-005f, -1.302923e-004f,  1.302923e-004f,  3.583039e-004f, -6.514617e-005f,  3.257308e-004f, 
   4.560232e-004f,  3.257308e-004f,  5.537424e-003f,  3.602583e-002f,  2.895747e-002f, -1.771976e-002f, -5.732863e-003f,  2.071648e-002f, 
   1.091198e-002f,  2.573274e-003f,  2.368063e-002f,  7.296371e-002f,  9.625347e-002f,  6.726342e-002f,  4.338735e-002f,  2.328975e-002f, 
   3.713332e-003f, -9.055318e-003f, -2.944607e-002f, -1.429959e-002f,  1.491847e-002f,  2.084678e-002f,  2.918548e-002f,  3.006496e-002f, 
   8.012979e-003f, -1.840379e-002f, -2.677508e-002f, -3.361542e-002f, -4.596062e-002f, -4.876191e-002f, -4.048834e-002f, -3.429946e-002f, 
  -2.644935e-002f, -1.009766e-002f, -9.771925e-004f,  4.071636e-003f,  1.084684e-002f,  1.560250e-002f,  1.211719e-002f,  4.136782e-003f, 
   4.560232e-004f, -3.029297e-003f, -8.175844e-003f, -1.032567e-002f, -1.032567e-002f, -1.231263e-002f, -1.547222e-002f, -1.537450e-002f, 
  -1.498362e-002f, -1.527678e-002f, -1.644941e-002f, -1.482075e-002f, -1.039081e-002f, -7.361517e-003f, -2.768713e-003f, -6.188886e-004f, 
  -1.628655e-004f,  9.771925e-005f, -3.908771e-004f, -1.791520e-003f, -4.104208e-003f, -3.941343e-003f, -3.485320e-003f, -4.755671e-003f, 
  -6.058594e-003f, -6.188886e-003f, -5.439705e-003f, -4.951108e-003f, -4.234501e-003f, -5.374559e-003f, -5.569998e-003f, -4.234501e-003f, 
  -2.540701e-003f, -1.954385e-003f, -2.866432e-003f, -2.573274e-003f, -3.452747e-003f, -3.908771e-003f, -3.094443e-003f, -2.670993e-003f, 
  -3.192162e-003f, -3.941343e-003f, -4.592805e-003f, -6.091166e-003f, -6.710056e-003f, -5.863155e-003f, -4.820817e-003f, -4.397366e-003f, 
  -3.876197e-003f, -3.257308e-003f, -3.224736e-003f, -3.192162e-003f, -3.908771e-003f, -4.299647e-003f, -3.713332e-003f, -2.670993e-003f, 
  -1.954385e-003f, -1.107485e-003f, -3.257308e-004f, -1.302923e-004f, -5.863155e-004f, -1.563508e-003f, -2.377835e-003f, -3.159589e-003f
};

static const float TestImpulseLeft5[] = 
{
   0.000000e+000f,  0.000000e+000f,  3.257308e-005f,  3.257308e-005f,  3.257308e-005f,  3.257308e-005f,  0.000000e+000f,  0.000000e+000f, 
   0.000000e+000f,  0.000000e+000f, -3.257308e-005f,  3.257308e-005f,  0.000000e+000f,  0.000000e+000f,  9.771925e-005f,  3.257308e-005f, 
   3.257308e-005f,  6.514617e-005f,  9.771925e-005f, -1.302923e-004f,  1.302923e-004f,  3.583039e-004f, -6.514617e-005f,  3.257308e-004f, 
   4.560232e-004f,  3.257308e-004f,  5.537424e-003f,  3.602583e-002f,  2.895747e-002f, -1.771976e-002f, -5.732863e-003f,  2.071648e-002f, 
   1.091198e-002f,  2.573274e-003f,  2.368063e-002f,  7.296371e-002f,  9.625347e-002f,  6.726342e-002f,  4.338735e-002f,  2.328975e-002f, 
   3.713332e-003f, -9.055318e-003f, -2.944607e-002f, -1.429959e-002f,  1.491847e-002f,  2.084678e-002f,  2.918548e-002f,  3.006496e-002f, 
   8.012979e-003f, -1.840379e-002f, -2.677508e-002f, -3.361542e-002f, -4.596062e-002f, -4.876191e-002f, -4.048834e-002f, -3.429946e-002f, 
  -2.644935e-002f, -1.009766e-002f, -9.771925e-004f,  4.071636e-003f,  1.084684e-002f,  1.560250e-002f,  1.211719e-002f,  4.136782e-003f, 
   4.560232e-004f, -3.029297e-003f, -8.175844e-003f, -1.032567e-002f, -1.032567e-002f, -1.231263e-002f, -1.547222e-002f, -1.537450e-002f, 
  -1.498362e-002f, -1.527678e-002f, -1.644941e-002f, -1.482075e-002f, -1.039081e-002f, -7.361517e-003f, -2.768713e-003f, -6.188886e-004f, 
  -1.628655e-004f,  9.771925e-005f, -3.908771e-004f, -1.791520e-003f, -4.104208e-003f, -3.941343e-003f, -3.485320e-003f, -4.755671e-003f, 
  -6.058594e-003f, -6.188886e-003f, -5.439705e-003f, -4.951108e-003f, -4.234501e-003f, -5.374559e-003f, -5.569998e-003f, -4.234501e-003f, 
  -2.540701e-003f, -1.954385e-003f, -2.866432e-003f, -2.573274e-003f, -3.452747e-003f, -3.908771e-003f, -3.094443e-003f, -2.670993e-003f, 
  -3.192162e-003f, -3.941343e-003f, -4.592805e-003f, -6.091166e-003f, -6.710056e-003f, -5.863155e-003f, -4.820817e-003f, -4.397366e-003f, 
  -3.876197e-003f, -3.257308e-003f, -3.224736e-003f, -3.192162e-003f, -3.908771e-003f, -4.299647e-003f, -3.713332e-003f, -2.670993e-003f, 
  -1.954385e-003f, -1.107485e-003f, -3.257308e-004f, -1.302923e-004f, -5.863155e-004f, -1.563508e-003f, -2.377835e-003f, -3.159589e-003f
};

static const float TestImpulseRight5[] = 
{
   7.263798e-003f, -1.283379e-002f,  1.693800e-002f, -7.491810e-004f,  4.386943e-001f,  2.094124e-001f, -7.255980e-001f, -1.513997e-001f, 
   4.386292e-001f,  7.201910e-002f,  9.749125e-002f,  6.702238e-001f,  1.688263e-001f, -4.565118e-001f,  2.057642e-001f,  5.232215e-001f, 
  -9.521113e-002f, -3.263172e-001f, -1.190872e-001f, -2.565782e-001f, -1.673280e-001f, -1.693800e-003f, -2.508127e-001f, -3.175875e-001f, 
  -6.755657e-002f,  9.729581e-002f,  4.267074e-002f,  4.117238e-002f,  1.467417e-001f,  1.214976e-001f,  6.381067e-002f,  7.683990e-002f, 
   1.794777e-002f, -9.817528e-002f, -5.341986e-002f, -1.579794e-002f, -5.983676e-002f, -1.045596e-001f, -9.511341e-002f, -5.517880e-002f, 
  -2.843630e-002f,  5.309413e-003f,  6.644910e-003f, -9.967364e-003f, -8.338710e-003f,  1.478818e-002f,  2.221484e-002f,  2.267087e-002f, 
   2.609104e-002f,  2.488584e-002f,  1.084684e-002f, -5.407132e-003f, -4.299647e-003f,  2.052104e-003f, -1.726374e-002f, -2.638420e-002f, 
  -2.921806e-002f, -3.859910e-002f, -3.872940e-002f, -1.749174e-002f, -3.257308e-005f, -5.439705e-003f, -1.140058e-002f, -3.908771e-003f, 
   8.403856e-003f,  7.394091e-003f,  1.358298e-002f,  2.159595e-002f,  1.407157e-002f, -2.964151e-003f, -3.257308e-003f, -1.368069e-003f, 
  -9.511341e-003f, -7.328944e-003f,  3.289881e-003f, -5.765436e-003f, -1.732889e-002f, -1.133543e-002f, -4.071636e-003f, -4.201927e-003f, 
   7.491810e-004f,  5.928301e-003f, -2.768713e-003f, -8.436430e-003f, -4.169355e-003f,  6.514617e-004f,  3.289881e-003f,  8.469002e-003f, 
   5.439705e-003f, -4.951108e-003f, -1.039081e-002f, -6.188886e-003f, -1.107485e-003f,  8.143272e-004f, -2.605846e-003f, -9.902218e-003f, 
  -1.664484e-002f, -1.556993e-002f, -4.234501e-003f,  4.983682e-003f,  2.996724e-003f, -5.341986e-003f, -9.739353e-003f, -9.902218e-003f, 
  -4.690524e-003f,  2.280116e-003f,  3.192162e-003f, -4.039062e-003f, -1.146573e-002f, -1.299666e-002f, -7.752394e-003f, -9.120463e-004f, 
   2.605846e-003f,  6.188886e-004f, -4.136782e-003f, -5.211694e-003f, -8.794733e-004f,  4.136782e-003f,  3.094443e-003f, -2.280116e-004f, 
  -2.475555e-003f, -4.527659e-003f, -4.885963e-003f, -7.166079e-004f,  2.442981e-003f,  9.446195e-004f, -1.498362e-003f, -2.247543e-003f
};

const HRTF_DATA SpatialDecTestHRTF =
{
  44100,
  128,
  {
    {
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      TestImpulseLeft1,
      TestImpulseRight1
    },
    {
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      TestImpulseLeft2,
      TestImpulseRight2
    },
    {
      {
         4.370924e-001f,  7.010393e-001f,  8.383406e-001f,  8.621954e-001f,  8.247752e-001f,  8.494204e-001f,  8.233382e-001f, 
         7.860918e-001f,  7.835764e-001f,  1.027310e+000f,  1.458626e+000f,  1.476009e+000f,  1.308725e+000f,  1.242959e+000f, 
         1.367163e+000f,  1.579752e+000f,  1.746490e+000f,  1.446752e+000f,  1.203043e+000f,  1.009048e+000f,  5.333833e-001f, 
         2.855004e-001f,  2.249040e-001f,  9.211854e-001f,  8.195068e-001f,  1.059322e+000f,  1.214852e+000f,  7.485591e-001f
      },
      {
         4.370924e-001f,  7.010393e-001f,  8.383406e-001f,  8.621954e-001f,  8.247752e-001f,  8.494204e-001f,  8.233382e-001f, 
         7.860918e-001f,  7.835764e-001f,  1.027310e+000f,  1.458626e+000f,  1.476009e+000f,  1.308725e+000f,  1.242959e+000f, 
         1.367163e+000f,  1.579752e+000f,  1.746490e+000f,  1.446752e+000f,  1.203043e+000f,  1.009048e+000f,  5.333833e-001f, 
         2.855004e-001f,  2.249040e-001f,  9.211854e-001f,  8.195068e-001f,  1.059322e+000f,  1.214852e+000f,  7.485591e-001f
      },
      {
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f, 
         1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f,  1.000000e+000f
      },
      {
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f, 
         0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f,  0.000000e+000f
      },
      TestImpulseLeft3,
      TestImpulseRight3
    },
    {
      {
         5.280031e-001f,  8.336785e-001f,  9.869970e-001f,  1.025786e+000f,  1.126209e+000f,  1.341599e+000f,  1.368003e+000f, 
         1.396738e+000f,  1.522988e+000f,  1.496456e+000f,  1.403694e+000f,  1.537554e+000f,  1.669922e+000f,  1.637370e+000f, 
         1.460056e+000f,  1.120508e+000f,  6.493181e-001f,  9.366830e-001f,  1.273692e+000f,  1.359695e+000f,  1.678276e+000f, 
         1.946924e+000f,  1.995053e+000f,  1.183452e+000f,  1.807511e+000f,  1.859266e+000f,  1.228482e+000f,  7.349062e-001f
      },
      {
         2.821823e-001f,  5.198394e-001f,  6.723547e-001f,  7.488481e-001f,  7.246682e-001f,  6.188524e-001f,  6.605622e-001f, 
         6.358058e-001f,  5.309695e-001f,  5.078888e-001f,  3.350730e-001f,  1.648914e-001f,  1.109400e-001f,  2.127970e-001f, 
         3.173144e-001f,  4.218637e-001f,  4.990227e-001f,  4.670481e-001f,  3.261253e-001f,  1.609552e-001f,  2.918509e-002f, 
         1.517498e-002f,  8.401115e-002f,  2.084128e-001f,  1.245009e-001f,  3.700322e-002f,  4.930865e-002f,  6.078253e-002f
      },
      {
         9.912679e-001f,  9.963487e-001f,  9.938882e-001f,  9.903200e-001f,  9.600061e-001f,  9.923907e-001f,  9.765615e-001f, 
         9.697533e-001f,  9.514849e-001f,  8.963590e-001f,  8.511819e-001f,  8.035887e-001f,  6.890041e-001f,  8.801028e-001f, 
         9.134347e-001f,  8.937091e-001f,  7.957618e-001f,  6.277516e-001f,  6.554545e-001f,  6.534512e-001f,  6.624641e-001f, 
         6.303147e-001f,  5.938156e-001f,  8.282658e-001f,  1.066249e-001f,  3.245954e-001f,  3.809198e-001f,  3.942417e-001f
      },
      {
         3.026851e-001f,  5.663372e-001f,  8.961913e-001f,  1.324449e+000f,  2.095054e+000f,  2.682424e+000f,  3.199355e+000f, 
         4.069215e+000f,  4.904351e+000f,  6.342136e+000f,  8.063613e+000f,  9.913350e+000f,  1.262810e+001f,  1.473773e+001f, 
         1.622540e+001f,  1.751989e+001f,  1.936644e+001f,  2.251860e+001f,  2.530549e+001f,  2.833891e+001f,  3.124231e+001f, 
         4.235038e+001f,  4.462840e+001f,  4.686767e+001f,  5.053357e+001f,  5.546453e+001f,  6.101682e+001f,  6.981119e+001f
      },
      TestImpulseLeft4,
      TestImpulseRight4
    },
    {
      {
         2.821823e-001f,  5.198394e-001f,  6.723547e-001f,  7.488481e-001f,  7.246682e-001f,  6.188524e-001f,  6.605622e-001f, 
         6.358058e-001f,  5.309695e-001f,  5.078888e-001f,  3.350730e-001f,  1.648914e-001f,  1.109400e-001f,  2.127970e-001f, 
         3.173144e-001f,  4.218637e-001f,  4.990227e-001f,  4.670481e-001f,  3.261253e-001f,  1.609552e-001f,  2.918509e-002f, 
         1.517498e-002f,  8.401115e-002f,  2.084128e-001f,  1.245009e-001f,  3.700322e-002f,  4.930865e-002f,  6.078253e-002f
      },
      {
         5.280031e-001f,  8.336785e-001f,  9.869970e-001f,  1.025786e+000f,  1.126209e+000f,  1.341599e+000f,  1.368003e+000f, 
         1.396738e+000f,  1.522988e+000f,  1.496456e+000f,  1.403694e+000f,  1.537554e+000f,  1.669922e+000f,  1.637370e+000f, 
         1.460056e+000f,  1.120508e+000f,  6.493181e-001f,  9.366830e-001f,  1.273692e+000f,  1.359695e+000f,  1.678276e+000f, 
         1.946924e+000f,  1.995053e+000f,  1.183452e+000f,  1.807511e+000f,  1.859266e+000f,  1.228482e+000f,  7.349062e-001f
      },
      {
         9.912679e-001f,  9.963487e-001f,  9.938882e-001f,  9.903200e-001f,  9.600061e-001f,  9.923907e-001f,  9.765615e-001f, 
         9.697533e-001f,  9.514849e-001f,  8.963590e-001f,  8.511819e-001f,  8.035887e-001f,  6.890041e-001f,  8.801028e-001f, 
         9.134347e-001f,  8.937091e-001f,  7.957618e-001f,  6.277516e-001f,  6.554545e-001f,  6.534512e-001f,  6.624641e-001f, 
         6.303147e-001f,  5.938156e-001f,  8.282658e-001f,  1.066249e-001f,  3.245954e-001f,  3.809198e-001f,  3.942417e-001f
      },
      {
        -3.026851e-001f, -5.663372e-001f, -8.961913e-001f, -1.324449e+000f, -2.095054e+000f, -2.682424e+000f, -3.199355e+000f, 
        -4.069215e+000f, -4.904351e+000f, -6.342136e+000f, -8.063613e+000f, -9.913350e+000f, -1.262810e+001f, -1.473773e+001f, 
        -1.622540e+001f, -1.751989e+001f, -1.936644e+001f, -2.251860e+001f, -2.530549e+001f, -2.833891e+001f, -3.124231e+001f, 
        -4.235038e+001f, -4.462840e+001f, -4.686767e+001f, -5.053357e+001f, -5.546453e+001f, -6.101682e+001f, -6.981119e+001f
      },
      TestImpulseLeft5,
      TestImpulseRight5
    }
  },
  0,
  NULL,
  NULL
};

